<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n3="http://www.w3.org/1999/xhtml" xmlns:n1="urn:hl7-org:v3" xmlns:n2="urn:hl7-org:v3/meta/voc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
  <xsl:output method="html" indent="yes" version="4.01" encoding="ISO-8859-1" doctype-public="-//W3C//DTD HTML 4.01//EN"/>
  <!-- CDA document -->
  <xsl:variable name="tableWidth">50%</xsl:variable>
  <xsl:variable name="title">
    <xsl:choose>
      <xsl:when test="/n1:ClinicalDocument/n1:title">
        <xsl:value-of select="/n1:ClinicalDocument/n1:title"/>
      </xsl:when>
      <xsl:otherwise>Clinical Document</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:template match="/">
    <xsl:apply-templates select="n1:ClinicalDocument"/>
  </xsl:template>
  <xsl:template match="n1:ClinicalDocument">
    <html> 
        <head>
          <!-- THE FOLLOWING LINE OF CODE SETS THE BROWSER COMPATIBILIY SO THAT THE FNC FUNCTIONS ARE CALLABLE. ANY VALUE ABOVE IE=8 WILL CAUSE THE FNC METHODS NOT TO BE REACHABLE. FIX FOR BUG 41813-->
          <meta http-equiv="X-UA-Compatible" content="IE=8" />
        
          <style>
            h1
            {
            font-family:arial;
            font-size:medium;
            }
            .sectionTitle
            {
            font-weight:bold;
            vertical-align: top;
            margin: 10px 0px 0px 0px;
            padding: 0px 5px;
            background-color: #BAD7DD;
            border-style: solid;
            border-width: 1px 1px 0px 1px;
            border-color: #9999B2;
            }
            .sectionBody
            {
            vertical-align: top;
            margin: 0px 0px 5px 0px;
            padding: 5px;
            border-style: solid;
            border-width: 1px 1px 1px 1px;
            border-color: #9999B2;
            }

            ul#refList {
            padding: 0;
            text-align: left;
            }

            ul#refList li {
            display: inline;
            float: left
            }

            ul#refList li a {
            color: blue;
            padding: 0px 10px 0px 0px;
            }

            <!--ul#refList li a {
            background-color: black;
            color: white;
            padding: 2px 10px;
            text-decoration: none;
            border-radius: 1px 1px 0 0;
            }-->

            <!--ul#refList li a:hover {
            background-color: orange;
            }-->

          </style>
          <!-- <meta name='Generator' content='&CDA-Stylesheet;'/> -->
          <xsl:comment>
                      Do NOT edit this HTML directly, it was generated via an XSLt
                      transformation from the original release 2 CDA Document.
          </xsl:comment>
          <title>
            <xsl:value-of select="$title"/>
          </title>
          <iMedica External="iMedica.Prm.Client.Web.External.FNC"/>
          <script src="iMedica.js" language="JavaScript"/>
      </head>
      <xsl:comment>
          Derived from HL7 Finland R2 Tyylitiedosto: Tyyli_R2_B3_01.xslt
          Updated by Calvin E. Beebe, Mayo Clinic - Rochester Mn.
          Updated by DiagnosisONE, Inc.
        </xsl:comment>
      <body>
        <h1 align="center">
          <b>
            <!--xsl:value-of select="$title"/-->
            <xsl:text>Clinical Decision Recommendations</xsl:text>
          </b>
        </h1>
        <table width="100%">
          <tr>
            <td width="1%">
              <b>
                <xsl:text>Patient: </xsl:text>
              </b>
            </td>
            <td width="40%">
              <xsl:call-template name="getName">
                <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:name"/>
              </xsl:call-template>
            </td>
            <td width="25%" align="right">
              <b>
                <xsl:text>MRN: </xsl:text>
              </b>
            </td>
            <td width="25%">
              <xsl:value-of select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:id/@extension"/>
            </td>
          </tr>
          <tr>
            <td width="1%">
              <b>
                <xsl:text>Birthdate: </xsl:text>
              </b>
            </td>
            <td width="40%">
              <xsl:call-template name="formatDate">
                <xsl:with-param name="date" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:birthTime/@value"/>
              </xsl:call-template>
            </td>
            <td width="35%" align="right">
              <b>
                <xsl:text>Sex: </xsl:text>
              </b>
            </td>
            <td width="25%">
              <xsl:variable name="sex" select="/n1:ClinicalDocument/n1:recordTarget/n1:patientRole/n1:patient/n1:administrativeGenderCode/@code"/>
              <xsl:choose>
                <xsl:when test="$sex='M'">Male</xsl:when>
                <xsl:when test="$sex='F'">Female</xsl:when>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td width="1%">
              <b>
                <xsl:text>Created: </xsl:text>
              </b>
            </td>
            <td width="25%">
              <xsl:call-template name="formatDate">
                <xsl:with-param name="date" select="/n1:ClinicalDocument/n1:effectiveTime/@value"/>
              </xsl:call-template>
            </td>
          </tr>
        </table>
        <table width="100%">
          <tr>
            <td width="100%">
              <xsl:apply-templates select="n1:component/n1:structuredBody"/>
              <xsl:call-template name="bottomline"/>
            </td>
          </tr>
        </table>
        
        <script>          
          window.onload = function(){CDSLoadVisitProcedures()};          
        </script>      
      </body>    
        

    </html>
  </xsl:template>
  <!-- Get a Name  -->
  <xsl:template name="getName">
    <xsl:param name="name"/>
    <xsl:choose>
      <xsl:when test="$name/n1:family">
        <xsl:value-of select="$name/n1:given"/>
        <xsl:text> </xsl:text>
        <xsl:text/>
        <xsl:value-of select="$name/n1:family"/>
        <xsl:text/>
        <xsl:if test="$name/n1:suffix">
          <xsl:text>, </xsl:text>
          <xsl:value-of select="$name/n1:suffix"/>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$name"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!--  Format Date 
    
      outputs a date in Month Day, Year form
      e.g., 19991207  ==> December 07, 1999
-->
  <xsl:template name="formatDate">
    <xsl:param name="date"/>
    <xsl:variable name="month" select="substring ($date, 5, 2)"/>
    <xsl:choose>
      <xsl:when test="$month='01'">
        <xsl:text>January </xsl:text>
      </xsl:when>
      <xsl:when test="$month='02'">
        <xsl:text>February </xsl:text>
      </xsl:when>
      <xsl:when test="$month='03'">
        <xsl:text>March </xsl:text>
      </xsl:when>
      <xsl:when test="$month='04'">
        <xsl:text>April </xsl:text>
      </xsl:when>
      <xsl:when test="$month='05'">
        <xsl:text>May </xsl:text>
      </xsl:when>
      <xsl:when test="$month='06'">
        <xsl:text>June </xsl:text>
      </xsl:when>
      <xsl:when test="$month='07'">
        <xsl:text>July </xsl:text>
      </xsl:when>
      <xsl:when test="$month='08'">
        <xsl:text>August </xsl:text>
      </xsl:when>
      <xsl:when test="$month='09'">
        <xsl:text>September </xsl:text>
      </xsl:when>
      <xsl:when test="$month='10'">
        <xsl:text>October </xsl:text>
      </xsl:when>
      <xsl:when test="$month='11'">
        <xsl:text>November </xsl:text>
      </xsl:when>
      <xsl:when test="$month='12'">
        <xsl:text>December </xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="substring ($date, 7, 1)=&quot;0&quot;">
        <xsl:value-of select="substring ($date, 8, 1)"/>
        <xsl:text>, </xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="substring ($date, 7, 2)"/>
        <xsl:text>, </xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="substring ($date, 1, 4)"/>
  </xsl:template>
  <!-- StructuredBody -->
  <xsl:template match="n1:component/n1:structuredBody">
    <xsl:apply-templates select="n1:component/n1:section"/>
  </xsl:template>
  <!-- Component/Section -->
  <!-- recomendations-->
  <xsl:template match="n1:component/n1:section">
    <!--<div class="sectionTitle">
			Recommendations
		</div>
    <div class="sectionBody">
      <xsl:apply-templates select="n1:text"/>
    </div>-->
    <xsl:choose>
      <xsl:when test="n1:entry[n1:observation/@classCode='ALRT']">
        <!--<div class="sectionBody">-->
          <div class="sectionTitle">
					  Alerts
				  </div>
          <div class="sectionBody">
            <table border="0" width="100%">
              <tr>
                  <th width="30%" align="left">Name</th>
                  <!--th width="20%" align="left">Procedure</th-->
                  <th width="40%" align="left">Guideline</th>
                  <!--th width="5%" align="left">Priority</th-->
                  <!--th width="5%" align="left">SP</th-->
                  <!--th width="5%" align="left">SO</th-->
                  <!--th width="30%" align="left">References</th-->
                  <th width="30%" align="left">References</th>
              </tr>
              <xsl:for-each select="n1:entry[n1:observation/@classCode='ALRT']">                
                <tr>
                  <xsl:choose>
                    <xsl:when test="((descendant::n1:code[@codeSystemName='C4']) or (descendant::n1:code[@codeSystemName='HPC']) or (descendant::n1:code[@codeSystemName='SNOMED CT']/@PRMproccode)) and (descendant::n1:procedure[@negationInd='false'] or descendant::n1:observation[@negationInd='false'])">
                      <xsl:comment>Name</xsl:comment>
                      <td valign="top">
                        <xsl:value-of select="descendant::n1:code/@displayName"/>
                      </td>
                      <xsl:comment>GUIDELINE</xsl:comment>
                      <td valign="top">
                        <xsl:variable name="excludeProviderAlertString">
                          <xsl:call-template name="string-replace-all">
                            <xsl:with-param name="text" select="descendant::n1:text"/>
                            <xsl:with-param name="replace" select="'[Provider Alert]'"/>
                            <xsl:with-param name="by" select="''"/>
                          </xsl:call-template>
                        </xsl:variable>
                        <div  style="color: #0000FF" onclick="document.getElementById('{generate-id()}').style.visibility=document.getElementById('{generate-id()}').style.visibility=='visible' ? 'hidden' : 'visible';document.getElementById('{generate-id()}').style.display=document.getElementById('{generate-id()}').style.display=='block' ? 'none' : 'block';"><u><xsl:value-of select="concat(substring($excludeProviderAlertString, 0, 80), '...')"/></u></div>
                         <div id='{generate-id()}' style="visibility:hidden;display:none"><xsl:value-of select="$excludeProviderAlertString"/></div>                        
                        <!--xsl:value-of select="$excludeProviderAlertString"/-->
                      </td>
                      <xsl:comment>REFERENCES</xsl:comment>
                        <td valign="top">
                        <xsl:choose>
                          <xsl:when test="descendant::n1:reference[@typeCode='SPRT']">
                            <ul id="refList">
                                 <xsl:variable name="ref"/>
                                 <xsl:for-each select="descendant::n1:reference[@typeCode='SPRT']">
                                    <li>
                                        <a target="_blank">
                                          <xsl:variable name="refDocumentTitle" select="n1:externalDocument/n1:text"/>
                                          <xsl:attribute name="href">
                                            <xsl:value-of select="n1:externalDocument/n1:text/n1:reference/@value"/>
                                          </xsl:attribute>                                          
                                          <!--<xsl:value-of select="n1:externalDocument/n1:text"/></a>-->
                                          <xsl:value-of select="concat(substring($refDocumentTitle, 0, 30), '...')"/>
                                          </a>
                                    </li>
                                    <!--<div  style="color: #0000FF" onclick="document.getElementById('{generate-id()}').style.visibility=document.getElementById('{generate-id()}').style.visibility=='visible' ? 'hidden' : 'visible';document.getElementById('{generate-id()}').style.display=document.getElementById('{generate-id()}').style.display=='block' ? 'none' : 'block';"><u><xsl:value-of select="concat(substring(n1:externalDocument/n1:text, 0, 80), '...')"/></u></div>
                                            <div id='{generate-id()}' style="visibility:hidden;display:none"><xsl:value-of select="n1:externalDocument/n1:text"/></div>-->
                                </xsl:for-each>
                             </ul>
                           </xsl:when>
                        </xsl:choose>
                      </td>
                    </xsl:when>
                  </xsl:choose>
                </tr>
                <td></td>
                <td colspan="3">                
                    <xsl:comment>PROCESS PROCEDURE BLOCKS</xsl:comment>
                    <xsl:for-each select="n1:observation/n1:entryRelationship[@typeCode='CAUS']">
                        <xsl:choose>                    
                            <xsl:when test="((descendant::n1:code[@codeSystemName='C4']) or (descendant::n1:code[@codeSystemName='HPC']) or (descendant::n1:code[@codeSystemName='SNOMED CT']/@PRMproccode)) and (descendant::n1:procedure[@negationInd='false'] or descendant::n1:observation[@negationInd='false'])">
                            <table border="0" width="85%">
                                <thead>   
                                    <tr>
                                        <th width="45%" align="left">Procedure</th>
                                        <th width="5%" align="left">SP</th>
                                        <th width="5%" align="left">SO</th>
                                        <th width="15%" align="left">Priority</th>
                                        <th width="15%" align="left">Decline</th>
                                    </tr>
                                </thead>      
                                <tbody>
                                <tr>
                                    <td>                                        
                                        <xsl:comment>PROCEDURECODE WRAPPED IN PARENTHESES</xsl:comment>
                                        <xsl:choose>
                                            <xsl:when test="descendant::n1:code[@codeSystemName='C4']">
                                              <b>
                                                <xsl:text>(</xsl:text>
                                                <xsl:value-of select="descendant::n1:code[@codeSystemName='C4']/@code"/>
                                                <xsl:text disable-output-escaping="yes">)&amp;nbsp;</xsl:text>
                                              </b>
                                              <xsl:value-of select="descendant::n1:code[@codeSystemName='C4']/@displayName"/>
                                            </xsl:when>
                                        </xsl:choose>
                                        <xsl:choose>
                                        <xsl:when test="descendant::n1:code[@codeSystemName='HPC']">
                                            <b>
                                              <xsl:text>(</xsl:text>
                                              <xsl:value-of select="descendant::n1:code[@codeSystemName='HPC']/@code"/>
                                              <xsl:text disable-output-escaping="yes">)&amp;nbsp;</xsl:text>                                  
                                            </b>
                                            <xsl:value-of select="descendant::n1:code[@codeSystemName='HPC']/@displayName"/>
                                        </xsl:when>
                                        </xsl:choose>
                                        <xsl:choose>
                                        <xsl:when test="(descendant::n1:code[@codeSystemName='SNOMED CT']) and (descendant::n1:code[@codeSystemName='SNOMED CT']/@PRMproccode)">
                                            <br>
                                              <xsl:text>(</xsl:text>
                                              <xsl:value-of select="descendant::n1:code[@codeSystemName='SNOMED CT']/@PRMproccode"/>
                                              <xsl:text disable-output-escaping="yes">)&amp;nbsp;</xsl:text>
                                            </br>
                                            <xsl:value-of select="descendant::n1:code[@codeSystemName='SNOMED CT']/@displayName"/>
                                        </xsl:when>
                                      </xsl:choose>
                                    </td>
                                <xsl:comment>DEFINE A COLUMN FOR SP BUTTON CHECKBOX. DEFINE A ONCLICK HANDLER</xsl:comment>
                                <xsl:choose>
                                    <xsl:when test="descendant::n1:code[@codeSystemName='C4']">
                                    <xsl:comment>GET THE PROCEDURE CODE STRING VALUE FROM THE NODE. SET AS AN ARG WHEN ONLICK IS CALLED</xsl:comment>
                                    <td valign="top">
                                      <xsl:variable name = "SPCodeC4" select="descendant::n1:code[@codeSystemName='C4']/@code"/>
                                      <xsl:comment>The name prop of the checkbox includes the code and is preceeded by SP to indicate it is an SP checkbox</xsl:comment>                                      
                                      <xsl:variable name = "CBSPCodeC4" select="concat('SP_', $SPCodeC4)"/>                                      
                                      <input type="checkbox" name="{$CBSPCodeC4}" id="{$CBSPCodeC4}" onclick="CDSServiceClick(this, '{$SPCodeC4}', true)" style="width: 5" align="middle"/>
                                    </td>
                                  </xsl:when>
                                  <xsl:when test="descendant::n1:code[@codeSystemName='HPC']">
                                    <td valign="top">
                                      <xsl:variable name = "SPCodeHPC" select="descendant::n1:code[@codeSystemName='HPC']/@code"/>
                                      <xsl:comment>The name prop of the checkbox includes the code and is preceeded by SP to indicate it is an SP checkbox</xsl:comment>
                                      <xsl:variable name = "CBSPCodeHPC" select="concat('SP_', $SPCodeHPC)"/>                                        
                                      <input type="checkbox" name="{$CBSPCodeHPC}" id="{$CBSPCodeHPC}" onclick="CDSServiceClick(this, '{$SPCodeHPC}', true)" style="width: 5" align="middle"/>
                                    </td>
                                  </xsl:when>
                                  <xsl:when test="descendant::n1:code[@codeSystemName='SNOMED CT']">
                                    <td valign="top">
                                      <xsl:variable name = "SPCodeSNOMED" select="descendant::n1:code[@codeSystemName='SNOMED CT']/@code"/>
                                      <xsl:comment>The name prop of the checkbox includes the code and is preceeded by SP to indicate it is an SP checkbox</xsl:comment>
                                      <xsl:variable name = "CBSPCodeSNOMED" select="concat('SP_', $SPCodeSNOMED)"/>                                      
                                      <input type="checkbox" name="{$CBSPCodeSNOMED}" id="{$CBSPCodeSNOMED}" onclick="CDSServiceClick(this, '{$SPCodeSNOMED}']/@PRMproccode', true)" style="width: 5" align="middle"/>
                                    </td>
                                  </xsl:when>
                                </xsl:choose>
                                <xsl:comment>DEFINE A COLUMN FOR SO BUTTON CHECKBOX. DEFINE AN ONCLICK HANDLER</xsl:comment>
                                <xsl:choose>
                                  <xsl:when test="descendant::n1:code[@codeSystemName='C4']">
                                    <xsl:comment>GET THE PROCEDURE CODE STRING VALUE FROM THE NODE. SET AS AN ARG WHEN ONLICK IS CALLED</xsl:comment>
                                    <td valign="top">
                                      <xsl:variable name = "SOCodeC4" select="descendant::n1:code[@codeSystemName='C4']/@code"/>
                                      <xsl:comment>The name prop of the checkbox includes the code and is preceeded by SO to indicate it is an SO checkbox</xsl:comment>
                                      <xsl:variable name = "CBSOCodeC4" select="concat('SO_', $SOCodeC4)"/>                                      
                                      <input type="checkbox" name="{$CBSOCodeC4}" id="{$CBSOCodeC4}" onclick="CDSServiceClick(this, '{$SOCodeC4}', false)" style="width: 5" align="middle"/>
                                    </td>
                                  </xsl:when>
                                  <xsl:when test="descendant::n1:code[@codeSystemName='HPC']">
                                    <td valign="top">
                                      <xsl:variable name = "SOCodeHPC" select="descendant::n1:code[@codeSystemName='HPC']/@code"/>
                                      <xsl:comment>The name prop of the checkbox includes the code and is preceeded by SO to indicate it is an SO checkbox</xsl:comment>
                                      <xsl:variable name = "CBSOCodeHPC" select="concat('SO_', $SOCodeHPC)"/>                                      
                                      <input type="checkbox" name="{$CBSOCodeHPC}" id="{$CBSOCodeHPC}" onclick="CDSServiceClick(this, '{$SOCodeHPC}', false)" style="width: 5" align="middle"/>
                                    </td>
                                  </xsl:when>
                                  <xsl:when test="descendant::n1:code[@codeSystemName='SNOMED CT']">
                                    <td valign="top">
                                      <xsl:variable name = "SOCodeSNOMED" select="descendant::n1:code[@codeSystemName='SNOMED CT']/@code"/>
                                      <xsl:comment>The name prop of the checkbox includes the code and is preceeded by SO to indicate it is an SO checkbox</xsl:comment>
                                      <xsl:variable name = "CBSOCodeSNOMED" select="concat('SO_', $SOCodeSNOMED)"/>                                      
                                      <input type="checkbox" name="{$CBSOCodeSNOMED}" id="{$CBSOCodeSNOMED}" onclick="CDSServiceClick(this, '{$SOCodeSNOMED}']/@PRMproccode', false)" style="width: 5" align="middle"/>
                                    </td>
                                  </xsl:when>
                                </xsl:choose>
                                <xsl:comment>PRIORITY</xsl:comment>
                                <xsl:choose>
                                  <xsl:when test="../n1:priorityCode/@code='S'">
                                      <td class="label" width="5%" style="vertical-align:top; color:white; background-color:#ff3300">
                                          <xsl:value-of select="../n1:priorityCode/@displayName"/>
                                      </td>
                                  </xsl:when>
                                </xsl:choose>
                                <xsl:choose>
                                  <xsl:when test="../n1:priorityCode/@code='A'">
                                      <td class="label" width="5%" style="vertical-align:top; color:white; background-color:#ff3300">
                                          <xsl:value-of select="../n1:priorityCode/@displayName"/>
                                      </td>
                                  </xsl:when>
                                </xsl:choose>
                                <xsl:choose>
                                  <xsl:when test="../n1:priorityCode/@code='UR'">
                                      <td class="label" width="5%" style="vertical-align:top; background-color:yellow">
                                          <xsl:value-of select="../n1:priorityCode/@displayName"/>
                                      </td>
                                  </xsl:when>
                                </xsl:choose>
                                <xsl:choose>
                                  <xsl:when test="../n1:priorityCode/@code='R'">
                                      <td class="label" width="5%" style="vertical-align:top; background-color:lightgreen">
                                          <xsl:value-of select="../n1:priorityCode/@displayName"/>
                                      </td>
                                  </xsl:when>
                                </xsl:choose>
                                <xsl:choose>
                                  <xsl:when test="../n1:priorityCode/@code='EL'">
                                      <td class="label" width="5%" style="vertical-align:top;">
                                          <xsl:value-of select="../n1:priorityCode/@displayName"/>
                                      </td>
                                  </xsl:when>
                                </xsl:choose>                         
                                <xsl:comment>DECLINE DROP DOWN</xsl:comment>
                                <td style="vertical-align:top;" id = ''>
                                    <xsl:comment>Set the proc code for this row into the variable "procCode". A negation reason from dropdown will be set for the procedure.</xsl:comment>
                                    <xsl:variable name="procCode">
                                        <xsl:choose>
                                              <xsl:when test="descendant::n1:code[@codeSystemName='C4']">
                                                    <xsl:value-of select="descendant::n1:code[@codeSystemName='C4']/@code"/>
                                              </xsl:when>
                                              <xsl:when test="descendant::n1:code[@codeSystemName='HPC']">
                                                    <xsl:value-of select="descendant::n1:code[@codeSystemName='HPC']/@code"/>
                                              </xsl:when>
                                              <xsl:when test="(descendant::n1:code[@codeSystemName='SNOMED CT']) and (descendant::n1:code[@codeSystemName='SNOMED CT']/@PRMproccode)">
                                                    <xsl:value-of select="descendant::n1:code[@codeSystemName='SNOMED CT']/@PRMproccode"/>
                                              </xsl:when>
                                        </xsl:choose>
                                    </xsl:variable>
                                    <xsl:comment>Define the negation dropdown list box that shows next to the SP, SO checkboxes</xsl:comment>
                                    <xsl:variable name = "NEGCode" select="concat('NEG_', $procCode)"/>
                                    <select name="{$NEGCode}" id="{$NEGCode}" onchange="CDSNegationOnSelectionChange (this, '{$procCode}')"/>
                                    <script>
                                        <xsl:comment>Preload dropdown with possible values</xsl:comment>
                                        CDSLoadNegationReasons(<xsl:value-of select="$NEGCode"/>);
                                    </script>
                                </td>                    
                              </tr>
                                  <xsl:comment>LINE BREAK AFTER A PROCEDURE ROW</xsl:comment>
                                  <tr><td colspan='4'>&#160;</td>
                              </tr>
                        </tbody>
                </table>
                    </xsl:when>
                  </xsl:choose>
                </xsl:for-each>
    </td>
    <!--/tr-->
              </xsl:for-each>
            </table>
          </div>
        <!--</div>-->
      </xsl:when>
    </xsl:choose>
  </xsl:template>  
  <xsl:template match="n1:component/n1:section/n1:entry">
    <div class="entry"/>
  </xsl:template>
  <!--   Title  -->
  <xsl:template match="n1:title">
    <!--h3-->
    <xsl:value-of select="."/>
    <!--/h3-->
  </xsl:template>
  <!--   Text   -->
  <xsl:template match="n1:text">
    <xsl:apply-templates/>
  </xsl:template>
  <!--   paragraph  -->
  <xsl:template match="n1:paragraph">
    <xsl:apply-templates/>
    <br/>
  </xsl:template>
  <!--     Content w/ deleted text is hidden -->
  <xsl:template match="n1:content[@revised='delete']"/>
  <!--   content  -->
  <xsl:template match="n1:content">
    <xsl:apply-templates/>
  </xsl:template>
  <!--   list  -->
  <xsl:template match="n1:list">
    <xsl:if test="n1:caption">
      <span style="font-weight:bold; ">
        <xsl:apply-templates select="n1:caption"/>
      </span>
    </xsl:if>
    <ul>
      <xsl:for-each select="n1:item">
        <li>
          <xsl:apply-templates/>
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>
  <xsl:template match="n1:list[@listType='ordered']">
    <xsl:if test="n1:caption">
      <span style="font-weight:bold; ">
        <xsl:apply-templates select="n1:caption"/>
      </span>
    </xsl:if>
    <ol>
      <xsl:for-each select="n1:item">
        <li>
          <xsl:apply-templates/>
        </li>
      </xsl:for-each>
    </ol>
  </xsl:template>
  <!--   caption  -->
  <xsl:template match="n1:caption">
    <xsl:apply-templates/>
    <xsl:text>: </xsl:text>
  </xsl:template>
  <!--      Tables   -->
  <xsl:template match="n1:table/@*|n1:thead/@*|n1:tfoot/@*|n1:tbody/@*|n1:colgroup/@*|n1:col/@*|n1:tr/@*|n1:th/@*|n1:td/@*">
    <xsl:copy>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="n1:table">
    <table>
      <xsl:apply-templates/>
    </table>
  </xsl:template>
  <xsl:template match="n1:thead">
    <thead>
      <xsl:apply-templates/>
    </thead>
  </xsl:template>
  <xsl:template match="n1:tfoot">
    <tfoot>
      <xsl:apply-templates/>
    </tfoot>
  </xsl:template>
  <xsl:template match="n1:tbody">
    <tbody>
      <xsl:apply-templates/>
    </tbody>
  </xsl:template>
  <xsl:template match="n1:colgroup">
    <colgroup>
      <xsl:apply-templates/>
    </colgroup>
  </xsl:template>
  <xsl:template match="n1:col">
    <col>
      <xsl:apply-templates/>
    </col>
  </xsl:template>
  <xsl:template match="n1:tr">
    <tr>
      <xsl:apply-templates/>
    </tr>
  </xsl:template>
  <xsl:template match="n1:th">
    <th>
      <xsl:apply-templates/>
    </th>
  </xsl:template>
  <xsl:template match="n1:td">
    <td>
      <xsl:apply-templates/>
    </td>
  </xsl:template>
  <xsl:template match="n1:table/n1:caption">
    <span style="font-weight:bold; ">
      <xsl:apply-templates/>
    </span>
  </xsl:template>
  <!--   RenderMultiMedia 

         this currently only handles GIF's and JPEG's.  It could, however,
	 be extended by including other image MIME types in the predicate
	 and/or by generating <object> or <applet> tag with the correct
	 params depending on the media type  @ID  =$imageRef     referencedObject
 -->
  <xsl:template match="n1:renderMultiMedia">
    <xsl:variable name="imageRef" select="@referencedObject"/>
    <xsl:choose>
      <xsl:when test="//n1:regionOfInterest[@ID=$imageRef]">
        <!-- Here is where the Region of Interest image referencing goes -->
        <xsl:if test="//n1:regionOfInterest[@ID=$imageRef]//n1:observationMedia/n1:value[@mediaType=&quot;image/gif&quot; or @mediaType=&quot;image/jpeg&quot;]">
          <br clear="all"/>
          <xsl:element name="img">
            <xsl:attribute name="src">graphics/
				<xsl:value-of select="//n1:regionOfInterest[@ID=$imageRef]//n1:observationMedia/n1:value/n1:reference/@value"/>
						</xsl:attribute>
          </xsl:element>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <!-- Here is where the direct MultiMedia image referencing goes -->
        <xsl:if test="//n1:observationMedia[@ID=$imageRef]/n1:value[@mediaType=&quot;image/gif&quot; or @mediaType=&quot;image/jpeg&quot;]">
          <br clear="all"/>
          <xsl:element name="img">
            <xsl:attribute name="src">graphics/
				<xsl:value-of select="//n1:observationMedia[@ID=$imageRef]/n1:value/n1:reference/@value"/>
						</xsl:attribute>
          </xsl:element>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- 	Stylecode processing   
	  Supports Bold, Underline and Italics display

-->
  <xsl:template match="//n1:*[@styleCode]">
    <xsl:if test="@styleCode='Bold'">
      <xsl:element name="b">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
    <xsl:if test="@styleCode='Italics'">
      <xsl:element name="i">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
    <xsl:if test="@styleCode='Underline'">
      <xsl:element name="u">
        <xsl:apply-templates/>
      </xsl:element>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Italics') and not (contains(@styleCode, 'Underline'))">
      <xsl:element name="b">
        <xsl:element name="i">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:element>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Italics'))">
      <xsl:element name="b">
        <xsl:element name="u">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:element>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Bold'))">
      <xsl:element name="i">
        <xsl:element name="u">
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:element>
    </xsl:if>
    <xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and contains(@styleCode, 'Bold')">
      <xsl:element name="b">
        <xsl:element name="i">
          <xsl:element name="u">
            <xsl:apply-templates/>
          </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- 	Superscript or Subscript   -->
  <xsl:template match="n1:sup">
    <xsl:element name="sup">
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="n1:sub">
    <xsl:element name="sub">
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  <!--  Bottomline  -->
  <xsl:template name="bottomline">
    <xsl:if test="/n1:ClinicalDocument/n1:legalAuthenticator/n1:assignedEntity/n1:assignedPerson/n1:name">
      <br/>
      <b>
        <xsl:text>Signed by: </xsl:text>
      </b>
      <xsl:call-template name="getName">
        <xsl:with-param name="name" select="/n1:ClinicalDocument/n1:legalAuthenticator/n1:assignedEntity/n1:assignedPerson/n1:name"/>
      </xsl:call-template>
      <xsl:text> on </xsl:text>
      <xsl:call-template name="formatDate">
        <xsl:with-param name="date" select="//n1:ClinicalDocument/n1:legalAuthenticator/n1:time/@value"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  <xsl:template name="string-replace-all">
    <xsl:param name="text"/>
    <xsl:param name="replace"/>
    <xsl:param name="by"/>
    <xsl:choose>
      <xsl:when test="contains($text, $replace)">
        <xsl:value-of select="substring-before($text,$replace)"/>
        <xsl:value-of select="$by"/>
        <xsl:call-template name="string-replace-all">
          <xsl:with-param name="text" select="substring-after($text,$replace)"/>
          <xsl:with-param name="replace" select="$replace"/>
          <xsl:with-param name="by" select="$by"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
