var AsyncXMLHTTPObjects;
var AsyncXMLHTTPActiveObjects;
var XMLHTTPReviewIntervalID = null;

function getASPNetURL()
{
	return("http://local/");
	/*
	if (typeof(sASPNetURL) != "undefined")
		return sASPNetURL;
	else if (typeof(parent.fnGetASPNetURL) == "function")
		return parent.fnGetASPNetURL();
	else if (typeof(parent.sASPNetURL) != "undefined")
		return parent.sASPNetURL;
	else if (typeof(oDesktop) != "undefined") {
		if (typeof(oDesktop.fnGetASPNetURL) != "undefined")
			return oDesktop.fnGetASPNetURL();
		else
			return oDesktop.sASPNetURL;
	}
	else if (typeof(myParentsParent.fnGetASPNetURL) == "function")
		return myParentsParent.fnGetASPNetURL();
	else
		return myParentsParent.sASPNetURL;
*/
}

function XMLHTTP_Open_fixForNastyXML3Problem(url,async,throwError,submitType) {
	var failed = true;
	if(submitType != "GET" && submitType != "POST") submitType = "POST";
	for(var i = 0; i < 5 && failed; i++) {
		failed = false;
		try {
			//var xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
			var xmlhttp = new ActiveXObject("MSXML2.XMLHTTP.3.0");
			xmlhttp.Open(submitType,url, async);
		} catch(e) {
			failed = true;
		}
	}
	if(failed == true)
		if(typeof(throwError) == "undefined")
			throw "xmlHTTPCommon.js: Failed to xmlhttp.Open after 5 attempts, XMLHTTP_Open_fixForNastyXML3Problem didn't work. The URL " + url + " could not be opened.";
		else
			return(false);
	return(xmlhttp);
}

function getUnsecuredWebName()
{
	var theURL = String(document.URL).toLowerCase();
	var ind = theURL.indexOf("browscapmin");
	if(ind > 0) theURL = theURL.substr(0,ind-1);
	ind = theURL.indexOf("https:");
	if(ind >= 0) theURL = "http:" + theURL.substring(ind+6, theURL.length);
	return theURL;
}

function getQueryString(sParm)
{
	var indexStart = document.URL.lastIndexOf(sParm);
	var indexEnd = document.URL.indexOf('&', indexStart);
	var sParmLen = sParm.length + 1;
	if (indexStart != -1)
		if (indexEnd == -1)
			return document.URL.substr(indexStart + sParmLen);
		else
			return document.URL.substr(indexStart + sParmLen, indexEnd - (indexStart + sParmLen));
	return '';
}

function replaceFileName(url,file)
{
	var lastQuestion = url.lastIndexOf('?');
	if (lastQuestion != -1)
		var sUrl = url.substring(0,lastQuestion + 1);
	else
		var sUrl = url;
	var lastSlash = sUrl.lastIndexOf('/');
	if(lastSlash != -1)
		return sUrl.substring(0,lastSlash + 1) + file;
	return file;
}

function XMLHTTPPost(xmlDoc, theAsp, retXMLDoc, bDotNet)
{
	var url = replaceFileName(bDotNet ? getASPNetURL() : document.URL, theAsp);
	var xmlhttp = XMLHTTP_Open_fixForNastyXML3Problem(url,false);
	xmlhttp.Send(xmlDoc);
	var bReturnValue = retXMLDoc.load(xmlhttp.responseStream);
	if (!bReturnValue)
	{
		retXMLDoc.loadXML(xmlhttp.responseText);
		if (xmlhttp.statusText != "OK")
			showError(xmlhttp.responseText, url, xmlDoc);
	}
	delete xmlhttp;
	return bReturnValue;
}

function XMLHTTPPostNoReply(xmlDoc, theAsp)
{
	var url = replaceFileName(document.URL, theAsp);
	var xmlhttp = XMLHTTP_Open_fixForNastyXML3Problem(url,false);
	xmlhttp.Send(xmlDoc);
	delete xmlhttp;
}

function XMLHTTPPostNoReplyReturnRespText(xmlDoc, theAsp)
{
	var url = replaceFileName(document.URL, theAsp);
	var xmlhttp = XMLHTTP_Open_fixForNastyXML3Problem(url,false);
	xmlhttp.Send(xmlDoc);
	var strResponseText = xmlhttp.responseText;
	delete xmlhttp;
	return strResponseText;
}

function XMLHTTPGet(theAsp, retXMLDoc, bDotNet)
{
	var url = replaceFileName(bDotNet ? getASPNetURL() : document.URL, theAsp);
	var xmlhttp = XMLHTTP_Open_fixForNastyXML3Problem(url,false,false,"GET");
	xmlhttp.Send('');
	var bReturnValue = retXMLDoc.load(xmlhttp.responseStream);
	if (!bReturnValue)
	{
		retXMLDoc.loadXML(xmlhttp.responseText);
		if (xmlhttp.statusText != "OK")
			showError(xmlhttp.responseText, url, "This was called from XMLHTTPGet; no XML was sent to Server.");
	}
	delete xmlhttp;
	return bReturnValue;
}

function checkAsyncXMLHTTPObjectsForOneActiveObject() {return(AsyncXMLHTTPActiveObjects > 0);}

//********************************************************************************
//******************************** Async Stuff ***********************************

// XMLHTTPPostAsync does an asynchronous XMLHTTP POST.
// parameters:
//	xmlDoc: The XML to SEND the server.
//			(NOTE: Can be an empty string, "" if you
//			 don't have anything to send.)
//	theAsp: The ASP on the server to SEND the XML to
//			and/or get a reply from.
//  onFinishProcedure: A STRING containing the NAME of
//			the function to be called once the reply
//			has been received and parsed. The function
//			must take one parameter, a refference to
//			the XMLHTTP object. If this procedure is
//			called with a NULL then an error has
//			occurred and the operation failed.
//			Example: passing 'finished' would result
//			in having a 'function finished(xmlhttpRef){}'
//			called when the XML has been loaded.
// RETURN Value: Returns a refference to the XMLHTTP
//			object created for this request.
function XMLHTTPPostAsync(xmlDoc, theAsp, onFinishProcedure, arg, submitType, bDotNet){
	onFinishProcedure = (onFinishProcedure instanceof Function ? onFinishProcedure : (new Function("return("+onFinishProcedure+");"))());
	var url;
	if(bDotNet == "ABSOLUTEURL")
		url = theAsp;
	else
		url = replaceFileName(bDotNet ? getASPNetURL() : document.URL, theAsp);

	var item = new Array();
		item.url = url;
		item.xmlDoc = xmlDoc;
		item.onFinishProcedure = onFinishProcedure;
		item.arg = arg;
		item.submitType = submitType;
	addToXMLHTTPQueue(item);
}

//********************************************************************************
//********************************************************************************
//********************************************************************************

function asyncXMLHTTPPostNoReply(xmlDoc, theAsp, bDotNet)
{
	url = replaceFileName(bDotNet ? getASPNetURL() : document.URL, theAsp);
	var xmlhttp = XMLHTTP_Open_fixForNastyXML3Problem(url,true);
	xmlhttp.Send(xmlDoc);
	xmlhttp = null;
}

function isXMLHTTPObjectOK(xmlhttp,displayErrors) {
	if(xmlhttp.responseXML == null) {
		if(xmlhttp.responseXML.documentElement == null) {
		} else {}
	} else {}
	return(true);
}

function XMLHTTPResponseOK(retXMLDoc, strErrMsg)
{
	var bResponseOK = true;
	if (retXMLDoc.xml == "") {
		bResponseOK = false;
		alert("An error occurred" + strErrMsg +".\nIf the problem persists, please contact technical support.");
	}else{
		//check for any <ERROR> nodes
		var numErrors = retXMLDoc.selectNodes("//error").length;
		if (numErrors > 0) {
			bResponseOK = false;
			var strError = "The following " + numErrors.toString() + " error(s) occurred" + strErrMsg + ".\nIf the problem persists, please contact technical support.";
			//one or more errors exist. alert the user.
			var ErrorNodeList = retXMLDoc.selectNodes("//error");
			// Display the error messages...
			for (i=0; i<numErrors; i++) {
				strError += "\n\n Error #" + (i+1) + ": " + unescape(ErrorNodeList.item(i).text);
				ErrorNodeList.nextNode();
			}
			alert(strError);
		}
	}
	return bResponseOK ;
}

function postXMLHTTPPostAsync(item) {
		if(typeof(item.xmlhttp = XMLHTTP_Open_fixForNastyXML3Problem(item.url,true,false,item.submitType)) != "object") {
			item.Status = "retry";
			item.xmlhttp = null;
		} else {
			item.Status = "pending";
			item.xmlhttp.onreadystatechange = new Function ("processXMLHTTPPostAsyncStateChange(AsyncXMLHTTPObjects["+item.index+"])");
			item.xmlhttp.Send(item.xmlDoc);
		}
}

function processXMLHTTPPostAsyncStateChange(item) {
	if(item != null && item instanceof Array && item.xmlhttp != null) {
		if(item.xmlhttp.readyState == 4 && item.Status != "done") {
			item.Status = "done";
			delete item.xmlhttp.onreadystatechange;

			// Trys to load the returning data into an xml document.
			var retXMLDoc = createMSXMLDOMObject();
			var bReturnValue = retXMLDoc.load(item.xmlhttp.responseStream);
			// If the operation fails, call the showError routine to display server error message
			if (!bReturnValue)
			{
				if (item.xmlhttp.statusText != "OK")
					showError(item.xmlhttp.responseText, item.url, item.xmlDoc);
			}
			item.onFinishProcedure(item.xmlhttp,item.arg);
			removeFromXMLHTTPQueue(item);
		}
	} else {
		alert("xmlHTTPCommon.js processXMLHTTPPostAsyncStateChange recieved a bad item");s
	}
}

// -->
	//item is an Array with the following properties:
	//  Name					Values
	//  ----------------------------------------------------------------------------------
	//	url						The URL to submit xmlDoc to, and or get an xmlDoc from.
	//	xmlDoc					('' || XMLDoc)
	//	onFinishProcedure		When the XMLDoc has been fully loaded
	//								onFinishProcedure(xmlhttp,arg) will be called.
	//	arg						Anything
	//	submitType				( "GET" || "POST" )

	function addToXMLHTTPQueue(item) {
		if(!(AsyncXMLHTTPObjects instanceof Array)) {
			AsyncXMLHTTPObjects = new Array();
			AsyncXMLHTTPActiveObjects = 0;
		}

		item.Status = "new";
		item.iteration = 0;
		item.xmlhttp = null;
		item.index = AsyncXMLHTTPObjects.length;
		AsyncXMLHTTPObjects[item.index] = item;
		AsyncXMLHTTPActiveObjects++;
		postXMLHTTPPostAsync(item);

		if(XMLHTTPReviewIntervalID == null) {
			XMLHTTPReviewIntervalID =  window.setTimeout(reviewXMLHTTPQueue,50);
		}
	}

	function reviewXMLHTTPQueue() {
		var rowsChecked = false;
		if(AsyncXMLHTTPObjects instanceof Array) {
			for(var i = 0; i < AsyncXMLHTTPObjects.length; i++) {
				if(AsyncXMLHTTPObjects[i] != null) {
					rowsChecked = true;
					AsyncXMLHTTPObjects[i].iteration++;
					switch(AsyncXMLHTTPObjects[i].Status) {
						case "new":
						break;
						case "retry":
							postXMLHTTPPostAsync(AsyncXMLHTTPObjects[i]);
						break;
						case "pending":
						break;
						case "done":
						break;
						default:
							alert("Unexpected execution of default case in xmlHTTPCommon.js reviewXMLHTTPQueue.");
						break;
					}
				}
			}
		}

		if(rowsChecked == true) {
			XMLHTTPReviewIntervalID = window.setTimeout(reviewXMLHTTPQueue,50);
		} else {
			XMLHTTPReviewIntervalID = null;
		}
	}

function removeFromXMLHTTPQueue(item) {
	if(!checkAsyncXMLHTTPObjectsForOneActiveObject() && XMLHTTPReviewIntervalID != null) {
		window.clearInterval(XMLHTTPReviewIntervalID);
		XMLHTTPReviewIntervalID = null;
		delete AsyncXMLHTTPObjects;
	}
	var index = item.index;
	delete item.url;
	item.xmlDoc = null;
	delete item.xmlDoc;
	delete item.onFinishProcedure;
	item.arg = null;
	delete item.arg;
	delete item.submitType;
	delete item.Status;
	delete item.iteration;
	item.xmlhttp.abort();
	delete item.xmlhttp;
	delete item.index;
	delete item;
	delete AsyncXMLHTTPObjects[index];
	AsyncXMLHTTPActiveObjects--;
}

function showError(strHTML, strURL, oXML)
{
	if (true)
	{
		try
		{
			if (strHTML == "")
				return;
			var parms = new Array();
			parms[0] = strHTML;
			parms[1] = strURL;
			if (typeof(oXML) == "string")
				parms[2] = oXML;
			else
				parms[2] = oXML.xml;
			window.showModalDialog("../includes/errorWindow.htm", parms, "help: no; status: no");
		}
		catch (e) { if (e.description != '') alert(e.description); }
	}
}

function createMSXMLDOMObject()
{
	// While MSXML3 has a "replace" mode that allows a newer version of MSXML3 to be used
	// to substitute for MSXML2, future releases of MSXML will not allow that (per MSXML4 doc)
	// This code attempts to isolate future changes.
	return new ActiveXObject("MSXML2.DOMDocument.3.0");
}

function deleteMSXMLDOMObject(oMSXML)
{
	delete oMSXML;
	oMSXML = null;
}

//This function replaces the use of oDestDoc.appendChild(oSrcNode.cloneNode(bDeep)); to copy nodes between XMLDocuments.
//The above sample will cause an error if the two documents are not implemented using the same version of MSXML.
//Parameters:
//	oSrcNode:	The XMLNode object which you would like appended to oDestDoc
//	oDestDoc:	The XMLDocument which you would like to have oSrcNode and its value appended to.
//	dDeep:	TRUE if you would like to clone oSrcNode and all of its children. FALSE if only oSrcNode is to be copied.
//Example:
//	oDestDoc.selectSingleNode(XPathExpression).appendChild(fnCloneByValue(oSrcNode,oDestDoc,bDeep));
function fnCloneByValue(oSrcNode,oDestDoc, bDeep)
{
	if(bDeep == null) bDeep = true; // by default, clone the entire tree
	// clone the node (oSrcNode) so that it becomes part of oDestDoc
	if(oDestDoc == null || oDestDoc == oSrcNode.ownerDocument)
		return oSrcNode.cloneNode(bDeep);
	else
	{
		var oClonedNode = oDestDoc.createNode(oSrcNode.nodeType,oSrcNode.nodeName,oSrcNode.namespaceURI);
		var oAttrMap = oSrcNode.attributes;
		if(oAttrMap != null)
			for (var i=0; i < oAttrMap.length; i++)
			{
				var oAttr = oAttrMap.item(i);
				oClonedNode.setAttribute(oAttr.nodeName,oAttr.value);
			}
		switch(oClonedNode.nodeType)
		{
			case 3: // TEXT
			case 4:	// CDATA
			case 8: // COMMENT
				oClonedNode.nodeValue = oSrcNode.nodeValue;
				break;
		}
		if(bDeep) {
			var oChildList = oSrcNode.childNodes;
			for (var j=0; j < oChildList.length; j++)
			{
				var oChild = oChildList.item(j);
				var oNodeChild = fnCloneByValue(oChild,oDestDoc,bDeep);
				oClonedNode.appendChild(oNodeChild);
			}
		}
		return oClonedNode;
	}
}