function getCurrentTab() {
    var iCurrentTab = -1;
    for (var i = 0; i < tabs.length && iCurrentTab < 0; i++) {
        if (tabs[i].className == "clsTabSelected")
            iCurrentTab = i;
    }
    return (iCurrentTab < 0 ? 0 : iCurrentTab);
}

function fnTabClick(nTab) {
    nTab = parseInt(nTab);
    var oTab;
    var prevTab = nTab - 1;
    var nextTab = nTab + 1;
    if (event != null) {
        event.cancelBubble = true;
        el = event.srcElement;
    }
    for (var i = 0; i < newsContent.length; i++) {
        oTab = tabs[i];
        oTab.className = "clsTab";
        oTab.style.borderLeftStyle = "";
        oTab.style.borderRightStyle = "";
        newsContent[i].style.display = "none";
    }
    newsContent[nTab].style.display = "block";
    tabs[nTab].className = "clsTabSelected";
    oTab = tabs[nextTab];
    if (oTab)
        oTab.style.borderLeftStyle = "none";
    oTab = tabs[prevTab];
    if (oTab)
        oTab.style.borderRightStyle = "none";
    if (event != null) {
        event.returnValue = false;
    }
    if (nTab != 0 && nTab != 4)
        window.resizeBy(0, 1);
    initDesktop();
}

function clickNextTab(directionFlag) {
    var oTab;
    var direct = (directionFlag == 1 ? 1 : -1);
    // get the tab that is currently selected
    var numTabs = newsContent.length;
    for (var i = 0; i < numTabs; i++) {
        if (tabs[i].className == "clsTabSelected")
            break;
    }
    // i is the currently selected tab number
    for (var j = (i + direct) ; j < (i + direct + numTabs) ; j = (j + direct)) {
        // determine which is the "next" tab
        if (j <= 0)
            j += numTabs;
        if (j >= numTabs)
            j -= numTabs;
        if (tabs[j].style.display != "none")
            break;
    }
    fnTabClick(j);
}

document.onkeydown = checkKey;
function checkKey() {
    try {
        // press right arrow key, move forward one tab (will wrap on last tab)
        if (event.keyCode == 39) {
            clickNextTab(1);
            event.cancelBubble = true;
        }
        else {
            // press left arrow key, move backward one tab (will wrap on first tab)
            if (event.keyCode == 37) {
                clickNextTab(0);
                event.cancelBubble = true;
            }
        }
    }
    catch (e)
    { }
}

function printTab(intTab) {
    var aDivs = document.all.newsContent[intTab].getElementsByTagName("DIV");
    var strHTML;
    var patient;
    var header;
    var footer;
    var reportName;

    header = iMedica.Patient.getPrintHeader(aDivs["printDiv"].name);
    header = '<html><head><link href="../iMedica.css" type="text/css" rel="stylesheet"></head><body>' + header;
    footer = '</body></html>';
    strHTML = header + aDivs["printDiv"].innerHTML + footer;

    reportName = getReportNameByTab(intTab);
    iMedica.Patient.PrintWithAudit(strHTML, reportName);
}

function getReportNameByTab(intTab) {
    var reportName;
    switch (intTab) {
        case 0:
            reportName = 'Demographics';
            break;
        case 1:
            reportName = 'Account';
            break;
        case 2:
            reportName = 'Contacts';
            break;
        case 3:
            reportName = 'Employment';
            break;
        case 4:
            reportName = 'Pharmacies';
            break;
        case 5:
            reportName = 'Survey';
            break;
        case 7:
            reportName = 'Notes';
            break;
        case 6:
            reportName = 'Programs';
            break;
        case 8:
            reportName = 'Forms';
            break;
        default:
            reportName = '';
    }
    if (reportName != '')
        reportName = 'Patient ' + reportName;
    return reportName;
}

function getTabData(intTab, addressFlag) {
    var aDivs = document.all.newsContent[intTab].getElementsByTagName("DIV");

    if (addressFlag == 0)  // No Address	
        return iMedica.Patient.getPrintHeaderNoAddress(aDivs["printDiv"].name) + aDivs["printDiv"].innerHTML;
    else
        return iMedica.Patient.getPrintHeader(aDivs["printDiv"].name) + aDivs["printDiv"].innerHTML;
}

function printAllTabs() {
    var currentTab;
    var header;
    var footer;
    var strHTML;

    header = '<html><head><link href="../iMedica.css" type="text/css" rel="stylesheet"></head><body>'
    footer = '</body></html>';

    currentTab = getCurrentTab();

    // Demographics Tab
    fnTabClick(0);
    strHTML = header + getTabData(0, 1);

    //// Employment Tab
    //fnTabClick(3);
    //strHTML += getTabData(3, 0) + footer;

    //iMedica.Patient.PrintWithAudit(strHTML, 'Demographics and Employment');

    //// Account Tab
    //fnTabClick(1);
    //strHTML = header + getTabData(1, 1) + footer;

    //iMedica.Patient.PrintWithAudit(strHTML, 'Account');

    //// Contacts Tab
    //fnTabClick(2);
    //strHTML = header + getTabData(2, 1);

    //iMedica.Patient.PrintWithAudit(strHTML, 'Contacts, Pharmacies, Survey, Practice Forms, Patient Programs, and Notes');

    // Employment Tab
    fnTabClick(3);
    strHTML += getTabData(3, 0);

    // Account Tab
    fnTabClick(1);
    strHTML += getTabData(1, 0);

    // Contacts Tab
    fnTabClick(2);
    strHTML += getTabData(2, 0);

    // Pharmacies Tab
    fnTabClick(4);
    strHTML += getTabData(4, 0);

    // Survey Tab
    fnTabClick(5);
    strHTML += getTabData(5, 0);

    // Notes Tab
    fnTabClick(7);
    strHTML += getTabData(7, 0);

    // Programs Tab
    fnTabClick(6);
    strHTML += getTabData(6, 0);

    // Forms Tab
    fnTabClick(8);
    strHTML += getTabData(8, 0) + footer;

    iMedica.Patient.PrintWithAudit(strHTML, 'Demographics, Employment, Account, Contacts, Pharmacies, Survey, Practice Forms, Patient Programs, and Notes');

    fnTabClick(currentTab);
}

