//<SCRIPT LANGUAGE="JSCRIPT">
var MS_IN_MIN = 1000 * 60; // milliseconds in a minute
var MS_IN_HOUR = MS_IN_MIN * 60; // milliseconds in an hour
var MS_IN_DAY = MS_IN_HOUR * 24; // milliseconds in a day

var daysOfWeek = new Array( "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");
var daysOfWeekFull = new Array( "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
var monthsOfYear = new Array('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
var monthsOfYearFull = new Array('January', 'Febuary', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');

function convertDateObjToDateStr(oDate, strSeparator, bFormal)
{
	var iMonth = oDate.getMonth() + 1;
	var sMonth = (bFormal ? (iMonth < 10 ? '0' + iMonth : iMonth) : iMonth);
	var iDay = oDate.getDate();
	var sDay = (bFormal ? (iDay < 10 ? '0' + iDay : iDay) : iDay);
	return '' + sMonth + strSeparator + sDay + strSeparator + oDate.getFullYear();
}

function convertDateObjToDateStrYY(oDate, strSeparator)
{
	return '' + (oDate.getMonth() + 1) + strSeparator + oDate.getDate() + strSeparator + oDate.getFullYear().toString().substr(2);
}

function convertXMLDateTimeToJSDateObj(strDate)
{
	// parse the XML datetime string: yyyy-mm-ddThh:mm:ss
	return new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
}

function convertUTDDateObjToLocalDateObj(oUTCDT)
{
	return new Date(oUTCDT.getTime() - (oUTCDT.getTimezoneOffset() * MS_IN_MIN));
}

function convertDateObjTo12HRTime(oDate)
{	//returns hh:mm(AM/PM)
	var hour = parseInt(oDate.getHours(), 10);
	var mins = parseInt(oDate.getMinutes(), 10);
	return '' + (hour == 0 ? 12 : (hour > 12 ? hour - 12 : hour)) + ':' +  (mins < 10 ? ('0' + mins) : mins) + (hour < 12 ? ' AM' : ' PM');
}

function changeDateObj(oDate, iDays)
{	// returns a date object with the date iDays forward or backwards
	var tempDate = new Date(oDate.getTime() + iDays*MS_IN_DAY);
	return tempDate;
}

function convertXMLTimeToMin(xmlDate)
{
	// parse the XML datetime string: yyyy-mm-ddThh:mm:ss
	return parseInt(xmlDate.substring(11, 13), 10) * 60 + parseInt(xmlDate.substring(14, 16), 10);
}

function convertMinsToDateTime(mins)
{
	return new Date(2000, 0, 1, parseInt(mins/60, 10), mins%60);
}

function convertMinsToTimeStr(iMins)
{
	var iHour = parseInt(iMins/60, 10);
	var iMins = iMins%60;
	return  '' + (iHour == 0 ? 12 : (iHour > 12 ? iHour - 12 : iHour)) + ':' + (iMins < 10 ? ('0' + iMins) : iMins) + (iHour < 12 ? ' AM' : ' PM');
}

//change the date to the number of days forward or backward based on numDays
function changeDate(oDate, numDays)
{
	return (new Date(oDate.getTime() + numDays*MS_IN_DAY));
}
//----------------------------------------------------
function getHourMinuteAMPM(dDate)
{
	var theHour, theMinute, theAmPm;
	theHour = dDate.getHours();
	theAmPm = "A";
	if (theHour > 12){
		theAmPm = "P";
		theHour = theHour - 12;
	}else{
		if (theHour == 12){
			theAmPm = "P";
		}else{
			if (theHour == 0){
				theHour = theHour+12;
				theAmPm = "A";
			}else{
				theAmPm = "A";
			}
		}
	}
	theMinute = dDate.getMinutes();
	if (theMinute < 10) 
		theMinute = "0" + theMinute;
	var strTime = theHour.toString() + ":" + theMinute.toString() + theAmPm;
	return strTime;
}
//----------------------------------------------------

function convertDateToStringDate (dDate)
{
	var theMonth = (dDate.getMonth()+1);
	var theDate = dDate.getDate();
	if (theMonth < 10) {
		theMonth = "0" + (theMonth);
	}
	if (theDate < 10) {
		theDate = "0" + theDate;
	}
	var strDate = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString();
	return strDate;
}

function convertDateToStringTime (dDate)
{
	var theHours = dDate.getHours();
	var sAMorPM = (theHours > 11 ? "PM" : "AM");
	if (theHours > 12) theHours -= 12;
	if (theHours == 0) theHours = 12;
	var theMins = dDate.getMinutes();
	var strTime = theHours + ":" + (theMins < 10 ? '0' : '') + theMins + " " + sAMorPM;
	return strTime;
}

function convertStringDateToDate (sDate)
{ 
	// assume it is a valid date MM/DD/YYYY !!
	var iInd = sDate.indexOf('/');
	var theMonth = parseInt(sDate.substr(0,iInd),10);
	sDate = sDate.substr(iInd + 1);
	iInd = sDate.indexOf('/');
	var theDate = parseInt(sDate.substr(0,iInd),10);
	sDate = sDate.substr(iInd + 1);
	var theYear = parseInt(sDate,10);
	return new Date(theYear,theMonth-1,theDate);
}

function convertStringTimeToDate (sTime)
{ 
    // assume it is a valid time HH:MM AM|PM !!
    var iInd = sTime.indexOf(':');
    var theHours = parseInt(sTime.substr(0,iInd),10);
    sTime = sTime.substr(iInd + 1);
    var theMins = parseInt(sTime,10);
    var isPM = (sTime.indexOf('PM') > 0) || (sTime.indexOf('pm') > 0);
    if (isPM)
    {
        if (theHours < 12)
            theHours += 12;
    }
    else
    {
        if (theHours == 12)
            theHours = 0;
    }
	return new Date(2000,0,1,theHours,theMins);
}

function getXMLFormattedDateTime(dDate)
{
	var today = (dDate == null ? new Date() : dDate);
	var hh = today.getMonth() + 1;
	hh = (hh < 10 ? '0' + hh : '' + hh);
	var dd = today.getDate();
	dd = (dd < 10 ? '0' + dd : '' + dd);	
	var hrs = today.getHours();
	hrs = (hrs < 10 ? '0' + hrs : '' + hrs);	
	var min = today.getMinutes();
	min = (min < 10 ? '0' + min : '' + min);	
	var sec = today.getSeconds();
	sec = (sec < 10 ? '0' + sec : '' + sec);	
	var dCreateDate = today.getFullYear() + '-' + hh + "-" + dd + 'T' + hrs + ':' + min + ':' + sec;
	return dCreateDate;
}

function validateDate(sValue) {
    re = /^\d{1,2}\/\d{1,2}\/(19|20)\d\d$/;
    var oFlag = re.test(sValue);
    if(oFlag == false) return false;
    
    // now check for # days in month, etc.
	var arr = sValue.split("/");
	if (sValue == "" || arr.length != 3 || isNaN(arr[0]) || isNaN(arr[1]) || isNaN(arr[2]))
		return false;	
	var dDate = new Date(arr[2], arr[0] - 1, arr[1]);
	if ((dDate.getMonth() + 1) != arr[0] || dDate.getDate() != arr[1] || dDate.getFullYear() != arr[2])
		return false;
	return true;
}

function validateTime(sValue) {
  re = /^\d{1,2}:\d{1,2}\s(AM|PM|am|pm)/;
  return re.test(sValue);
}

function getStringDate(sXMLDateTime)
{
	if(sXMLDateTime == null || sXMLDateTime=="") return "";
	return convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
}

function convertDate(xmlDate)
{
	var i = xmlDate.indexOf('T');
	var date = xmlDate.substr(0,i);
	var j = date.indexOf('-');
	var year = date.substr(0,j);
	var k = date.indexOf('-',j+1);
	var month = date.substring(j+1,k);
	var day = date.substr(k + 1);
	var time = xmlDate.substr(i+1);
	i = time.indexOf(':');
	j = time.indexOf(':',i + 1);
	var hh = parseInt(time.substr(0,i),10);
	var AMPM = (hh < 12 ? "AM" : "PM");
	if(hh > 12) hh -= 12;
	var mm = parseInt(time.substring(i + 1, j),10);
	mm = (mm < 10) ? "0" + mm : mm;
	return "" + month + "/" + day + "/" + year + " " + hh + ":" + mm + AMPM;
}
//----------------------------------------------------

//</SCRIPT>