﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:msxsl="urn:schemas-microsoft-com:xslt" 
  xmlns:user="urn:schemas-imedica.com:prm">
  
  <xsl:output method="html" encoding="UTF-8"/>
  <xsl:template match="/">

    <table border="0" cellpadding="10" cellspacing="0" align="center" style="table-layout: fixed;" width="98%" class="small">
      <colgroup>
          <col span="1" style="width: 30%;text-align: left" />
          <col span="1" style="width: 20%;text-align: right" />
          <col span="1" style="width: 50%;text-align: left" />
      </colgroup>
      <thead>
        <tr>
          <td>Deposit Reference Number</td>
          <td>Unallocated Amount</td>
          <td>Batch</td>
        </tr>
      </thead>

      <xsl:for-each select="ROOT/AR_ViewFinancialCenterClosingSummary_DepositsWithBalance">
        <tr hidden="true">
          <xsl:if test="position() mod 2 = 0">
            <xsl:attribute name="class">oddrow</xsl:attribute>
          </xsl:if>
          <xsl:if test="position() mod 2 = 1">
            <xsl:attribute name="class">evenrow</xsl:attribute>
          </xsl:if>
          <td>
            <xsl:if test="@DepositReferenceNumber != '&lt;NA&gt;'">
              <a href="#" hint="Click here to edit this deposit">
                <xsl:attribute name="onClick">
                  iMedica.CompleteBatchExternalHandler.HandleDepositClick('<xsl:value-of select="@DepositUid"/>');
                </xsl:attribute>
                <xsl:value-of select="@DepositReferenceNumber"/>
              </a>
            </xsl:if>
          </td>
          <td>
            <xsl:value-of select="format-number(@DepositReceiptBalance, '#,###.00')"/>
          </td>
          <td>
            <xsl:value-of select="string(@ArBatchName)"/>
          </td>
        </tr>
      </xsl:for-each>
    </table>
  </xsl:template>
  <msxsl:script language="Jscript" implements-prefix="user">
		<![CDATA[
    
    function convertXMLDateTimeToJSDateObj(strDate)
		{
			// parse the XML datetime string: yyyy-mm-ddThh:mm:ss
			return new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
		}

		function convertDateToStringDate(dDate)
		{
			var theMonth = (dDate.getMonth()+1);
			var theDate = dDate.getDate();
			if (theMonth < 10) {
				theMonth = "0" + (theMonth);
			}
			if (theDate < 10) {
				theDate = "0" + theDate;
			}
			var strDate = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString();
			return strDate;
		}

		function getStringDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
			return "";
		}

	]]>
  </msxsl:script>

</xsl:stylesheet>