<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
 xmlns:user="urn:schemas-imedica.com:prm">
	<xsl:template match="ROOT/Patient">
		<xsl:element name="DIV">
			<xsl:attribute name="ID">printDiv</xsl:attribute>
			<xsl:attribute name="name">Pharmacies</xsl:attribute>
			<table border="0" cellpadding="1" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
				<col width="24%"/>
				<col width="40%"/>
				<col width="18%"/>
				<col width="18%"/>
				<col width="20"/>
				<col width="0%"/>
				<TR class="insideGreyHeader">
					<TD align="left" nowrap="true" valign="top">
						<SPAN class="smallHeader">Name</SPAN>
					</TD>
					<TD align="left" nowrap="true" valign="top">
						<SPAN class="smallHeader">Address</SPAN>
					</TD>
					<TD align="left" nowrap="true" valign="top">
						<SPAN class="smallHeader">Phone 1</SPAN>
					</TD>
					<TD align="left" nowrap="true" valign="top">
						<SPAN class="smallHeader">Phone 2</SPAN>
					</TD>
					<TD></TD>
					<TD></TD>
				</TR>
			</table>
			<table border="0" cellpadding="1" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
				<col width="24%"/>
				<col width="40%"/>
				<col width="18%"/>
				<col width="18%"/>
				<col width="20"/>
				<col width="0%"/>
				<xsl:choose>
					<xsl:when test="PatientPharmacy/@PharmacyUid[.!='']">
						<xsl:for-each select="PatientPharmacy/ListPharmacy">
							<xsl:sort select="../@DisplayOrder" order="ascending"/>
							<TR class="picklist" ID="MyRow" NAME="MyRow" style="cursor:hand">
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">whitesmoke</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">white</xsl:attribute>
								</xsl:if>
								<xsl:attribute name="onMouseOver">hiliteRow("picklist","#cccccc");</xsl:attribute>
								<xsl:attribute name="onMouseOut">setTrBgColor(this);</xsl:attribute>
								<TD align="left" nowrap="true" title="Click here to edit this pharmacy" class="small">
									<xsl:attribute name="onClick">
										if (iMedica.Patient.EditPharmacy('<xsl:value-of select="../@PatientPharmacyUid"/>')) init1();
									</xsl:attribute>
									<xsl:if test="@Inactive = 'False'">
										<xsl:value-of select="@Name"/>
									</xsl:if>
									<xsl:if test="@Inactive = 'True'">
										<EM>
											<xsl:value-of select="@Name"/>
										</EM>
									</xsl:if>
								</TD>
								<TD align="left" nowrap="true" title="Click here to edit this pharmacy" class="small">
									<xsl:attribute name="onClick">
										if (iMedica.Patient.EditPharmacy('<xsl:value-of select="../@PatientPharmacyUid"/>')) init1();
									</xsl:attribute>
									<xsl:if test="@Inactive = 'False'">
										<xsl:value-of select="./Address/Address/Address1"/>&#xa0;<xsl:value-of select="./Address/Address/Address2"/>,&#xa0;<xsl:value-of select="./Address/Address/City"/>,&#xa0;<xsl:value-of select="./Address/Address/State"/>&#xa0;<xsl:value-of select="./Address/Address/Zip"/>
									</xsl:if>
									<xsl:if test="@Inactive = 'True'">
										<EM>
											<xsl:value-of select="./Address/Address/Address2"/>&#xa0;<xsl:value-of select="./Address/Address/Address2"/>,&#xa0;<xsl:value-of select="./Address/Address/City"/>,&#xa0;<xsl:value-of select="./Address/Address/State"/>&#xa0;<xsl:value-of select="./Address/Address/Zip"/>
										</EM>
									</xsl:if>
								</TD>
								<TD align="left" nowrap="true" hint="Click here to edit this pharmacy" class="small">
									<xsl:attribute name="onClick">
										if (iMedica.Patient.EditPharmacy('<xsl:value-of select="../@PatientPharmacyUid"/>')) init1();
									</xsl:attribute>
									<xsl:if test="@Inactive = 'False'">
										<xsl:value-of select ="./Phone1/Phone/PhoneTypeName"/>&#xa0;<xsl:value-of select="./Phone1/Phone/PhoneNumber"/>
									</xsl:if>
									<xsl:if test="@Inactive = 'True'">
										<EM>
											<xsl:value-of select ="./Phone1/Phone/PhoneTypeName"/>&#xa0;<xsl:value-of select="./Phone1/Phone/PhoneNumber"/>
										</EM>

									</xsl:if>
								</TD>
								<TD align="left" nowrap="true" title="Click here to edit this pharmacy" class="small">
									<xsl:attribute name="onClick">
										if (iMedica.Patient.EditPharmacy('<xsl:value-of select="../@PatientPharmacyUid"/>')) init1();
									</xsl:attribute>
									<xsl:if test="@Inactive = 'False'">
										<xsl:value-of select ="./Phone2/Phone/PhoneTypeName"/>&#xa0;<xsl:value-of select="./Phone2/Phone/PhoneNumber"/>
									</xsl:if>
									<xsl:if test="@Inactive = 'True'">
										<EM>
											<xsl:value-of select ="./Phone2/Phone/PhoneTypeName"/>&#xa0;<xsl:value-of select="./Phone2/Phone/PhoneNumber"/>
										</EM>
									</xsl:if>
								</TD>
								<TD width="20" valign="top">
									<button type="button" title="Click here to sort this pharmacy up" style="height 10px">
										<xsl:attribute name="onClick">
											if (iMedica.Patient.SortUpPatientPharmacy('<xsl:value-of select="../@PatientPharmacyUid"/>')) init1();
										</xsl:attribute>
										<b>&#8593;</b>
									</button>
								</TD>
								<TD width="20" valign="top">
									<button type="button" title="Click here to sort this pharmacy down" style="height 10px">
										<xsl:attribute name="onClick">
											if (iMedica.Patient.SortDownPatientPharmacy('<xsl:value-of select="../@PatientPharmacyUid"/>')) init1();
										</xsl:attribute>
										<b>&#8595;</b>
									</button>
								</TD>
								<TD width="20" valign="top">
									<button type="button" title="Click here to delete this pharmacy" style="height 10px">
										<xsl:attribute name="onClick">
											if (iMedica.Patient.DeletePatientPharmacy('<xsl:value-of select="../@PatientPharmacyUid"/>')) init1();
										</xsl:attribute>
										<b>X</b>
									</button>
								</TD>
								<TD width="0" valign="top">
									<xsl:element name="INPUT">
										<xsl:attribute name="TYPE">hidden</xsl:attribute>
										<xsl:attribute name="ID">
											contactUUID<xsl:value-of select="UUID"/>
										</xsl:attribute>
										<xsl:attribute name="NAME">
											contactUUID<xsl:value-of select="UUID"/>
										</xsl:attribute>
										<xsl:attribute name="VALUE">
											<xsl:value-of select="UUID"/>
										</xsl:attribute>
									</xsl:element>
								</TD>
							</TR>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<TR ID="MyRow" NAME="MyRow" CLASS="picklist" bgcolor="white">
							<TD width="598" colspan="6" align="center" nowrap="true" valign="top">
								<SPAN class="hint">(No pharmacies listed for this patient.)</SPAN>
							</TD>
						</TR>
					</xsl:otherwise>
				</xsl:choose>
			</table>
			<br/>
		</xsl:element>
		<!--printDIV-->
		<table width="98%" align="center" border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed;">
			<TR>
				<TD width="70%" valign="top">
					<SPAN class="hint">
						Click on the X button next to a Pharmacy to remove it. Click '<B>Add</B>' to find and add a new pharmacy.
					</SPAN>
				</TD>
				<TD width="30%" align="right">
					<input id="btnPrintDemographics" type="button" class="blueBtn" value="Add" >
						<xsl:attribute name="onClick">if(iMedica.Patient.AddPharmacy(PersonUid)) init1();</xsl:attribute>
						<!--if(iMedica.Patient.AddPharmacy(PharmacyFindControl.children(2).value, PersonUid)) init1();-->
					</input>
				</TD>
			</TR>
		</table>
		<!--table width="98%" align="center" border="0" cellpadding="0" cellspacing="0">
			<tr align="center">
				<td width="100%">
					<input type="button" class="blueBtn" disabled="true" onClick="formatForPrinting('contactsPrint.htm','Contacts','685px','375px');" value="Print Contacts" />
					<input type="button" class="blueBtn" disabled="true" onClick="formatForPrinting('identificationPrint.htm','Identification','685px','406px');" value="Print Identification" />
				</td>
			</tr>
		</table -->
	</xsl:template>
</xsl:stylesheet>