﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
 xmlns:user="urn:schemas-imedica.com:prm">
	<xsl:template match="ROOT/Person">
	<xsl:element name="DIV">
	  <xsl:attribute name="ID">printDiv</xsl:attribute>
	  <xsl:attribute name="name">Programs</xsl:attribute>
		<table border="0" cellpadding="1" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
		<col width="20%"/><col width="20%"/><col width="25%"/><col width="12%"/><col width="12%"/><col width="20%"/>
			<TR class="insideGreyHeader">
				<TD align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Program</SPAN></TD>
        <TD align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Effective Date</SPAN></TD>
				<TD align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Expiration Date</SPAN></TD>
        <TD align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Icon Text</SPAN></TD>
        <TD></TD>
				<TD></TD>
			</TR>
		</table>
		<table border="0" cellpadding="1" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
		<col width="20%"/><col width="20%"/><col width="25%"/><col width="12%"/><col width="12%"/><col width="11%"/><col width="20%"/>
			<xsl:choose>
      <xsl:when test="Patient/RelPatientProgram/@PatientUid[.!='']">
			<xsl:for-each select="Patient/RelPatientProgram">
			<TR class="picklist" ID="MyRow" NAME="MyRow" style="cursor:hand">
				<xsl:if test="position() mod 2 = 0">
					<xsl:attribute name="bgcolor">whitesmoke</xsl:attribute>
				</xsl:if>
				<xsl:if test="position() mod 2 = 1">
					<xsl:attribute name="bgcolor">white</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="onClick">if(iMedica.Patient.EditProgram('<xsl:value-of select="@RelPatientProgramUid"/>')) init1();</xsl:attribute>
				<xsl:attribute name="onMouseOver">hiliteRow("picklist","#cccccc");</xsl:attribute>
				<xsl:attribute name="onMouseOut">setTrBgColor(this);</xsl:attribute>
        <TD align="left" nowrap="true" valign="top">
          <SPAN class="small">
            <xsl:value-of select="ListPatientProgram/@Name"/>
          </SPAN>
        </TD>
				<TD align="left" nowrap="true" valign="top">
				 <span class="small">
               <xsl:value-of select="user:getStringDate(string(@EffectiveDate))"/>
         </span>
				</TD>
				<TD align="left" nowrap="true" valign="top">
					<span class="small">
                    <xsl:value-of select="user:getStringDate(string(@ExpirationDate))"/>
                  </span>
				</TD>
        <TD align="left" nowrap="true" valign="top">
          <xsl:variable name="txtColor">
            <xsl:value-of select="user:decimalColorToHTMLcolor(string(ListPatientProgram/@Color))"/>
          </xsl:variable>
          <SPAN class="small">
            <Font>
              <xsl:attribute name="color">
                <xsl:value-of select="$txtColor"/>
              </xsl:attribute>
              <xsl:value-of select="ListPatientProgram/@ToolbarText"/>
            </Font>
          </SPAN>
        </TD>
        <TD width="20" valign="top">
          <button type="button" title="Click here to delete this program" style="height 10px">
            <xsl:attribute name="onClick">
              if (iMedica.Patient.DeleteProgram('<xsl:value-of select="@RelPatientProgramUid"/>')) init1();
            </xsl:attribute>
            <b>X</b>
          </button>
        </TD>
        <TD width="0" valign="top">
					<xsl:element name="INPUT">
						<xsl:attribute name="TYPE">hidden</xsl:attribute>
						<xsl:attribute name="ID">programUUID<xsl:value-of select="UUID"/></xsl:attribute>
						<xsl:attribute name="NAME">programUUID<xsl:value-of select="UUID"/></xsl:attribute>
						<xsl:attribute name="VALUE"><xsl:value-of select="UUID"/></xsl:attribute>
					</xsl:element>
				</TD>
			</TR>
			</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
			<TR ID="MyRow" NAME="MyRow" CLASS="picklist" bgcolor="white">
				<TD width="598" colspan="6" align="center" nowrap="true" valign="top">
					<SPAN class="hint">(No program listed for this patient.)</SPAN>
				</TD>
			</TR>
			</xsl:otherwise>
			</xsl:choose>
		</table><br/>
		</xsl:element><!--printDIV-->
		<table width="98%" align="center" border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed;">
			<TR>
				<TD width="90%" valign="top">
					<SPAN class="hint">Click on a program row to view/edit the program or click '<B>Add</B>' to add a new program.</SPAN>
				</TD>
				<TD width="10%" align="right">
					<input id="btnPrintDemographics" type="button" class="blueBtn" value="Add" >
						<xsl:attribute name="onClick">if(iMedica.Patient.AddProgram('<xsl:value-of select="//@PersonUid"/>')) init1();</xsl:attribute>
					</input>
				</TD>
			</TR>
		</table>
	</xsl:template>
	<msxsl:script language="Jscript" implements-prefix="user">
		<![CDATA[
    function decimalColorToHTMLcolor(num) {
        num >>>= 0;
        var b = num & 0xFF,
        g = (num & 0xFF00) >>> 8,
        r = (num & 0xFF0000) >>> 16,
        a = ( (num & 0xFF000000) >>> 24 ) / 255 ;
        
        return "#" + componentToHex(r) + componentToHex(g) + componentToHex(b);
    } 
    function componentToHex(c) {
      var hex = c.toString(16);
      return hex.length == 1 ? "0" + hex : hex;
    }  
		function convertXMLDateTimeToJSDateObj(strDate)
		{
			// parse the XML datetime string: yyyy-mm-ddThh:mm:ss
			return new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
		}

		function convertDateToStringDate(dDate)
		{
			var theMonth = (dDate.getMonth()+1);
			var theDate = dDate.getDate();
			var strDate = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString();
			return strDate;
		}

    function getStringFuzzyDate(sXMLDateTime, fuzzyAnswer)
    {
      if(sXMLDateTime != "")
      {
        var stringDate = convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
        if(stringDate == fuzzyAnswer)
        {
          return stringDate;
        }
        else
        {
          return stringDate + " ("+fuzzyAnswer+")";
        }
      }
			return fuzzyAnswer;
    }

		function getStringDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
			return "";
		}

		// Need to add support for .trim() manually
		String.prototype.trim = String_trim;
		function String_trim() {
			//
			// trims spaces from both ends of a string
			if(this.length > 0) {
				var start = 0;
				while(((this.charAt(start)).valueOf() == " ".valueOf()) && (start < this.length)) {
					start++;
				}
				if(start >= this.length) {
					return ""; //string contains spaces only.
				}
				var endstr = this.length - 1;
				while(((this.charAt(endstr)).valueOf() == " ".valueOf()) && (endstr >= 0)) {
					endstr--;
				}
				return this.substring(start,endstr+1);
			}
			else {
			return "" + this;
			}
		}
		]]>
	</msxsl:script>
</xsl:stylesheet>