<?xml version="1.0"?>
<!--xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl" default-space="preserve" indent-result="yes"-->
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
 xmlns:user="urn:schemas-imedica.com:prm">

	<xsl:template match="ROOT">
		<xsl:apply-templates select="*"/>
	</xsl:template>

	<xsl:template match="CheckDuplicatePerson">
		<xsl:element name="DIV">
			<xsl:attribute name="ID">printDiv</xsl:attribute>
			<xsl:attribute name="name">Demographics</xsl:attribute>
			<table border="0" cellpadding="1" cellspacing="0" align="center" style="table-layout: fixed;" width="98%" class="small">
				<col width="5%"/>
				<col width="45%"/>
				<col width="50%"/>
				<tr>
					<td id="personname" colspan="2">
						<B>Name:</B>&#xa0;
					</td>
					<td>
						<a href="#" hint="Click here to edit this patient">
							<xsl:attribute name="onClick">
								iMedica.DuplicatePersonExternalHandler.HandleClick('<xsl:value-of select="@PersonUid"/>');
							</xsl:attribute>
							<xsl:value-of select="@FullNameFormal"/>
						</a>
					</td>
				</tr>
				<tr>
					<td id="socialsecuritynumber" colspan="2">
						<b>Social Security Number:</b>
					</td>
					<td>
						<xsl:value-of select="@SocialSecurityNumber"/>
					</td>
				</tr>
				<tr>
					<td id="birthdate" colspan="2">
						<b>Date of Birth:</b>
					</td>
					<td>
						<xsl:value-of select="user:getStringDate(string(@Birthdate))"/>
					</td>
				</tr>
				<tr>
					<xsl:if test="string-length(@DriverLicenseNumber)">
						<td id="driverlicense" colspan="2">
							<b>Driver License:</b>
						</td>
						<td>
							<xsl:if test="string-length(@DriverLicenseState)">
								<xsl:value-of select="@DriverLicenseState"/>&#xa0;
						</xsl:if>
							<xsl:value-of select="@DriverLicenseNumber"/>
						</td>
					</xsl:if>
				</tr>
				<tr>
					<td colspan="2" valign="top">
						<b>Address:</b>
					</td>
					<td>
						<xsl:if test="string-length(@Address1)">
							<xsl:value-of select="@Address1"/>
							<br />
						</xsl:if>
						<xsl:if test="string-length(@Address2)">
							<xsl:value-of select="@Address2"/>
							<br />
						</xsl:if>
						<xsl:if test="string-length(@City) or string-length(@State) or string-length(@Zip)">
							<xsl:value-of select="@City"/>&#xa0;<xsl:value-of select="@State"/>&#xa0;<xsl:value-of select="@Zip"/>
						</xsl:if>
					</td>
				</tr>
				<tr>
					<xsl:if test="string-length(@Phone)">
						<td id="phone" colspan="2">
							<b>Primary Phone:</b>
						</td>
						<td>
							<xsl:value-of select="@Phone"/>
						</td>
					</xsl:if>
				</tr>
				<tr>
					<xsl:if test="string-length(@MedicalRecordNumber)">
						<td id="medicalrecordnumber" colspan="2">
							<b>Medical Record Number:</b>
						</td>
						<td>
							<xsl:value-of select="@MedicalRecordNumber"/>
						</td>
					</xsl:if>
				</tr>
				<tr>
					<td>
						<br />
					</td>
				</tr>
			</table>
		</xsl:element>
	</xsl:template>

	<msxsl:script language="Jscript" implements-prefix="user">
		<![CDATA[

		function getAddressLabel(sDisplayOrder)
		{
			if (sDisplayOrder == "1")
				return "Primary Address";
			else if (sDisplayOrder == "2")
				return "Secondary Address";
			else
				return "Address " + sDisplayOrder;
		}

		function convertXMLDateTimeToJSDateObj(strDate)
		{
			// parse the XML datetime string: yyyy-mm-ddThh:mm:ss
			return new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
		}

		function convertDateToStringDate(dDate)
		{
			var theMonth = (dDate.getMonth()+1);
			var theDate = dDate.getDate();
			if (theMonth < 10) {
				theMonth = "0" + (theMonth);
			}
			if (theDate < 10) {
				theDate = "0" + theDate;
			}
			var strDate = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString();
			return strDate;
		}

		function getStringDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
			return "";
		}

	]]>
	</msxsl:script>

</xsl:stylesheet>