angular.module("aprima-sigwriter",["ui.router","restangular","ngTouch","ngAnimate","truncate","ui.bootstrap","angularLocalStorage","gettext","lodash","toaster","rt.debounce","hmTouchEvents","mgo-angular-wizard","aprima-core","aprima-core-ui","aprima-bridge","aprima-config","aprima-legacy-common","aprima-provider-api","aprima-patient"]),angular.module("aprima-sigwriter").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("/sigwriter/component-views/dosingCalculator.html",'<div class="container-fluid container-flush" ng-cloak>\r\n    <uib-alert type="danger"\r\n               ng-if="vm.errors"\r\n               class="alert-flush">\r\n        <div ng-repeat="error in vm.errors">\r\n            {{error}}\r\n        </div>\r\n    </uib-alert>\r\n    <form novalidate>\r\n        <div class="row">\r\n            <div class="col-xs-12 col-xs-flush">\r\n                <div class="form-group">\r\n                    <label class="control-label medium-blue-label"\r\n                           for="general-dosing-info"\r\n                           translate>\r\n                        General Dosing Range Information\r\n                        <button type="button"\r\n                                id="dc-dosing-info"\r\n                                class="btn btn-inline-icon"\r\n                                ng-click="vm.updateDosingInfo()">\r\n                            <i class="fa fa-refresh" ng-hide="vm.loadingDosingInfo || vm.loadingPatientInfo"/>\r\n                            <ap-spinner size="1" ng-show="vm.loadingDosingInfo || vm.loadingPatientInfo"/>\r\n                        </button>\r\n                    </label>\r\n                    <textarea readonly\r\n                              class="form-control resize-none"\r\n                              id="general-dosing-info"\r\n                              ng-model="vm.generalDosingInfo"\r\n                              rows="7">\r\n                    </textarea>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <label class="control-label medium-blue-label clickable"\r\n               ng-click="vm.patientInfoCollapsed = !vm.patientInfoCollapsed"\r\n               translate>\r\n            Patient Information\r\n            <i ng-class="vm.patientInfoCollapsed ? \'ap-chevron-down-blue\' : \'ap-chevron-up-blue\'"/>\r\n        </label>\r\n        <div class="row" uib-collapse="vm.patientInfoCollapsed">\r\n            <div class="col-xs-12 col-md-8 col-xs-flush">\r\n                <div class="row">\r\n                    <div class="col-xs-12 col-xs-flush">\r\n                        <div class="form-group">\r\n                            <label class="control-label medium-gray-label">\r\n                                <span translate>Weight</span>\r\n                            </label>\r\n                            <span ng-show="vm.weightDate">\r\n                                (From\r\n                                <ap-date-formatter date="{{vm.weightDate}}" format="date"/>)\r\n                            </span>\r\n                            <div class="checkbox checkbox-sm-wrapper checkbox-inline-inner-label">\r\n                                <label class="medium-gray-label">\r\n                                    <input type="checkbox"\r\n                                           class="checkbox-sm"\r\n                                           ap-checkbox\r\n                                           id="weight-toggle-system"\r\n                                           ng-model="vm.weightMetric"\r\n                                           ng-change="vm.changeWeightSystem()"/>\r\n                                    <span translate>Metric</span>\r\n                                </label>\r\n                            </div>\r\n                            <div class="row">\r\n                                <div class="col-xs-12 col-sm-6 col-xs-flush col-sm-reset-flush-right">\r\n                                    <div class="input-group">\r\n                                        <input type="number"\r\n                                               id="weight-value-primary"\r\n                                               class="form-control text-right"\r\n                                               ng-model="vm.weightPrimary"\r\n                                               ng-disabled="!vm.weightEnabled || vm.loadingDosingInfo || vm.loadingPatientInfo"/>\r\n                                        <div class="input-group-addon addon-min-width-50">\r\n                                            {{vm.weightMetric ? \'kg\': \'lbs\'}}\r\n                                        </div>\r\n                                    </div>\r\n                                </div>\r\n                                <div class="col-xs-12 col-sm-6 col-xs-flush col-sm-reset-flush-left"\r\n                                     ng-hide="vm.weightMetric">\r\n                                    <div class="input-group">\r\n                                        <input type="number"\r\n                                               id="weight-value-secondary"\r\n                                               class="form-control text-right"\r\n                                               ng-model="vm.weightSecondary"\r\n                                               ng-disabled="!vm.weightEnabled || vm.loadingDosingInfo || vm.loadingPatientInfo"/>\r\n                                        <div class="input-group-addon addon-min-width-50">\r\n                                            oz\r\n                                        </div>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row">\r\n                    <div class="col-xs-12 col-xs-flush">\r\n                        <div class="form-group">\r\n                            <label class="control-label medium-gray-label">\r\n                                <span translate>Height</span>\r\n                            </label>\r\n                            <span ng-show="vm.heightDate">\r\n                                (From\r\n                                <ap-date-formatter date="{{vm.heightDate}}" format="date"/>)\r\n                            </span>\r\n                            <div class="checkbox checkbox-sm-wrapper checkbox-inline-inner-label">\r\n                                <label class="medium-gray-label">\r\n                                    <input type="checkbox"\r\n                                           class="checkbox-sm"\r\n                                           ap-checkbox\r\n                                           id="height-toggle-system"\r\n                                           ng-model="vm.heightMetric"\r\n                                           ng-change="vm.changeHeightSystem()"/>\r\n                                    <span translate>Metric</span>\r\n                                </label>\r\n                            </div>\r\n                            <div class="row">\r\n                                <div class="col-xs-12 col-sm-6 col-xs-flush col-sm-reset-flush-right">\r\n                                    <div class="input-group">\r\n                                        <input type="number"\r\n                                               id="height-value-primary"\r\n                                               class="form-control text-right"\r\n                                               ng-model="vm.heightPrimary"\r\n                                               ng-disabled="!vm.heightEnabled || vm.loadingDosingInfo || vm.loadingPatientInfo"/>\r\n                                        <div class="input-group-addon addon-min-width-50">\r\n                                            {{vm.heightMetric ? \'cm\' : \'ft\'}}\r\n                                        </div>\r\n                                    </div>\r\n                                </div>\r\n                                <div class="col-xs-12 col-sm-6 col-xs-flush col-sm-reset-flush-left"\r\n                                     ng-hide="vm.heightMetric">\r\n                                    <div class="input-group">\r\n                                        <input type="number"\r\n                                               id="height-value-secondary"\r\n                                               class="form-control text-right"\r\n                                               ng-model="vm.heightSecondary"\r\n                                               ng-disabled="!vm.heightEnabled || vm.loadingDosingInfo || vm.loadingPatientInfo"/>\r\n                                        <div class="input-group-addon addon-min-width-50">\r\n                                            in\r\n                                        </div>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="col-xs-12 col-md-4 col-xs-flush col-md-reset-flush-left"\r\n                 ng-show="vm.bsaEnabled && !vm.loadingPatientInfo">\r\n                <div class="form-group">\r\n                    <label class="control-label medium-gray-label"\r\n                           uib-tooltip="Body Surface Area"\r\n                           tooltip-placement="auto top-right">\r\n                        <span translate>BSA</span>\r\n                    </label>\r\n                    <p class="form-control-static form-control-static-flush">\r\n                        {{vm.getBsa()}}\r\n                    </p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="row">\r\n            <div class="col-xs-12 col-xs-flush">\r\n                <div class="form-group">\r\n                    <label class="control-label medium-blue-label"\r\n                           for="dosing-info-by-mg"\r\n                           translate>\r\n                        Dosing Information by MG\r\n                    </label>\r\n                    <div class="row">\r\n                        <div class="col-xs-12 col-xs-flush">\r\n                            <div class="input-group">\r\n                                <input type="number"\r\n                                       id="dosing-mg"\r\n                                       class="form-control text-right"\r\n                                       ng-model="vm.dosingMg"\r\n                                       ng-change="vm.changeMg()"\r\n                                       ng-disabled="!vm.dosingMgEnabled || vm.loadingDosingInfo"\r\n                                       uib-tooltip="{{vm.dosingMgToolTip}}"\r\n                                       tooltip-trigger="focus"\r\n                                       tooltip-placement="auto top-right"/>\r\n                                <div class="input-group-addon addon-min-width-50">\r\n                                    {{vm.dosingMgUnits}}\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                    <textarea readonly\r\n                              class="form-control secondary-control resize-none"\r\n                              id="dosing-info-by-mg"\r\n                              resize="none"\r\n                              ng-model="vm.dosingInfoByMg"\r\n                              rows="6">\r\n                    </textarea>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n    </form>\r\n</div>\r\n\r\n'),$templateCache.put("/sigwriter/component-views/drugIconGroup.html",'<i ng-class="$ctrl.genericTypeClass" ng-if="$ctrl.genericTypeClass"></i>\r\n<i ng-class="$ctrl.ePrescribeTypeClass" ng-if="$ctrl.ePrescribeTypeClass"></i>'),$templateCache.put("/sigwriter/component-views/drugSearch.html",'<div id="drug-search" class="panel panel-default panel-flush">\r\n    <div class="panel-body">\r\n        <div class="row">\r\n            <div class="col-xs-8 text-left">\r\n                <input type="text" name="searchInput" ng-model="$ctrl.searchText" ng-change="$ctrl.searchRx()"\r\n                    placeholder="{{\'Search\' | translate}}" id="searchText" class="form-control" \r\n                    ng-attr-autofocus="{{$ctrl}}" />\r\n            </div>\r\n            <div class="col-xs-1" ng-if="$ctrl.useEnhancedDrugSearch">\r\n                <span>\r\n                    <a href="http://www.pdr.net/search/searchResult.aspx?searchCriteria={{$ctrl.searchText}}&cid=07940" id="drug-search-pdr" target="_blank"><span class="ap-drugsearch-pdr" title="Search for drug on PDR website" /></a>\r\n                </span>\r\n            </div>\r\n            <div class="col-xs-3" ng-if="$ctrl.useEnhancedDrugSearch" col-xs-flush text-right>\r\n                <div class="checkbox checkbox-native">\r\n                    <input type="checkbox"\r\n                            class="native"\r\n                            name="cbInactiveInclude"\r\n                            id="cbInactiveInclude"\r\n                            ng-model="$ctrl.includeInactive"\r\n                            ng-change="$ctrl.inactiveIncludeChange()">\r\n                    <label class="lg-touch" for="cbInactiveInclude">{{::\'Include Inactive\' | translate}}</label>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row" ng-if="!$ctrl.loading && $ctrl.loadError">\r\n        <div class="col-xs-12 col-xs-flush">\r\n            <uib-alert type="danger">\r\n                {{"An error has occurred and drugs could not be loaded." | translate}}\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="drug-search-list-content">\r\n        <drug-search-list\r\n            drugs="$ctrl.drugs"\r\n            loading="$ctrl.loading"\r\n            searched="$ctrl.searched"\r\n            patient-id="$ctrl.patientId"\r\n            session-id="$ctrl.sessionId"\r\n            use-enhanced-drug-search="$ctrl.useEnhancedDrugSearch"\r\n            on-drug-search-result-selected="$ctrl.selectDrugSearchResult(drugSearchResult, switchToGeneric, dosingSuggestion)"\r\n            update-search-text="$ctrl.updateSearchText(searchText)"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/drugSearchList.html",'<div id="drug-search-list" class="panel panel-default panel-flush">\r\n    \r\n    <div class="col-xs-12 col-xs-flush text-center ng-hide" ng-show="$ctrl.loading">  \x3c!-- && !$ctrl.drugs.length"> --\x3e\r\n        <ap-spinner size="3"></ap-spinner>\r\n    </div>\r\n\r\n    <ul ng-disabled="$ctrl.loading" class="list-group" ng-show="!$ctrl.loading">\r\n        <li class="list-group-item text-center" ng-show="$ctrl.drugs && !$ctrl.drugs.length && $ctrl.searched">\r\n            <div class="col-xs-12 text-center text-center-vert">\r\n                <span>{{::\'Your search did not return any results. Please change your search.\' | translate}}</span>\r\n            </div>\r\n        </li>\r\n        <li ng-if="$ctrl.useEnhancedDrugSearch"\r\n            ng-repeat="drug in $ctrl.drugs"\r\n            class="list-group-item flexbox flexbox-horizontal-center drug-search-result clickable"\r\n            ng-click="$ctrl.selectDrug(drug, false)" hm-propagation="true"\r\n            id="enhanced-drug-result-{{$index}}">\r\n\r\n            <div class="col-xs-1 col-xs-flush text-left" ng-if="!drug.indicateSelected">\r\n                <span ng-switch="drug.ResultType">\r\n                    <span ng-switch-when="Drug" id="drug-{{::drug.Drug.DrugId}}" class="ap-drugsearch-result-drug" title="Search drug result" />\r\n                    <span ng-switch-when="Patient" id="patient-sig-{{::drug.SigId}}" class="ap-drugsearch-result-patientmed" title="Patient active medication" />\r\n                    <span ng-switch-when="DefaultProvider" id="default-sig-{{::drug.SigId}}" class="ap-drugsearch-result-defaultsig" tite="Default sig" />\r\n                    <span ng-switch-when="Mfu" id="drug-{{::drug.Drug.DrugId}}" class="ap-drugsearch-result-mfu" title="Freuqently Used Drug" />\r\n                </span>\r\n            </div>\r\n\r\n            <div class="col-xs-1 col-xs-flush text-left" ng-if="drug.indicateSelected">\r\n                    <ap-spinner size="2"></ap-spinner>\r\n            </div>\r\n            \r\n            <div class="col-xs-9 col-xs-flush">\r\n                <div class="row">\r\n                    <div class="col-xs-12 col-lg-12 heading-title overflow-ellipsis">\r\n                        <span ng-if="drug.ProviderDefaultSIGName">{{::drug.ProviderDefaultSIGName}}</span>\r\n                        <span ng-if="!drug.ProviderDefaultSIGName">{{::drug.Drug.Description}}</span>\r\n                        <span ng-if="!$ctrl.hideDrugInformationIcon" ng-click="$ctrl.displayDrugDetail(drug)" id="drug-info-{{$index}}" hm-stop-propagation="true" class="ap-drugsearch-info" title="Drug detail information" /></span>\r\n                        <span ng-switch="drug.Drug.FederalDeaClassCode">\r\n                            <span ng-switch-when="0"></span>\r\n                            <span ng-switch-when="1" hm-stop-propagation="true" class="ap-drugsearch-controlled-substance-i" title="DEA Schedule I" />\r\n                            <span ng-switch-when="2" hm-stop-propagation="true" class="ap-drugsearch-controlled-substance-ii" title="DEA Schedule II" />\r\n                            <span ng-switch-when="3" hm-stop-propagation="true" class="ap-drugsearch-controlled-substance-iii" title="DEA Schedule III" />\r\n                            <span ng-switch-when="4" hm-stop-propagation="true" class="ap-drugsearch-controlled-substance-iv" title="DEA Schedule IV" />\r\n                            <span ng-switch-when="5" hm-stop-propagation="true" class="ap-drugsearch-controlled-substance-v" title="DEA Schedule V" />\r\n                            <span ng-switch-when="6" hm-stop-propagation="true" class="ap-drugsearch-controlled-substance-vi" title="DEA Schedule VI - Mixed Schedule" />\r\n                        </span>\r\n                        <span ng-if="drug.IsInactiveOrObsolete" class="ap-drugsearch-inactive" title="Inactive/Obsolete Drug" />\r\n                        <span ng-switch="drug.Drug.EPrescribeIndicator">\r\n                            <span ng-switch-when="none" class="ap-drugsearch-erx-not-available" title="ePrescribing not available" />\r\n                        </span>\r\n                    </div>\r\n                    <div class="col-xs-12 col-lg-12 heading-title overflow-ellipsis">\r\n                        <div>{{::drug.ResultType === "Drug" ? drug.Drug.Class : drug.SigText}}</div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="col-xs-2 col-xs-flush text-right">\r\n                <span ng-if="drug.Drug.GenericMedId && drug.Drug.GenericMedId != drug.Drug.MedId" ng-click="$ctrl.selectDrug(drug, true)" id="drug-generic-{{$index}}" hm-stop-propagation="true" class="ap-drugsearch-generic" title="{{::drug.Drug.GenericDescDisplay}}" />\r\n            </div>                \r\n        </li>\r\n\r\n        <li ng-if="!$ctrl.useEnhancedDrugSearch"\r\n            ng-repeat="drug in $ctrl.drugs"\r\n            class="list-group-item flexbox flexbox-horizontal-center drug-search-result clickable"\r\n            ng-click="$ctrl.selectDrug(drug, false)" hm-propagation="true"\r\n            id="drug-result-{{$index}}">\r\n\r\n            \x3c!-- todo need to handle additional drug types --\x3e\r\n            <div ng-switch="drug.ResultType">\r\n                <div ng-switch-when="Drug" id="drug-{{::drug.Drug.DrugId}}">\r\n                    <div class="heading-title overflow-ellipsis">\r\n                        {{::drug.Drug.Description}}\r\n                    </div>\r\n                    <div class="heading-subtitle overflow-ellipsis" ng-if="drug.Drug.Class">\r\n                        {{::drug.Drug.Class}}\r\n                    </div>\r\n                </div>\r\n\r\n                <div ng-switch-when="Patient" id="patient-sig-{{::drug.SigId}}">\r\n                    <div class="heading-title overflow-ellipsis">\r\n                        {{::drug.Drug.Description}}\r\n                    </div>\r\n                    \x3c!-- is drug class relevant when viewing a patient sig?? seems irrelevant --\x3e\r\n                    <div class="heading-subtitle">\r\n                        <div>[Patient] {{::drug.SigText}}</div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div ng-switch-when="DefaultProvider" id="default-sig-{{::drug.SigId}}">\r\n                    <div class="heading-title overflow-ellipsis">\r\n                        {{::drug.Drug.Description}}\r\n                    </div>\r\n                    \x3c!-- is drug class relevant when viewing a default sig?? seems irrelevant --\x3e\r\n                    <div class="heading-subtitle">\r\n                        <div>[Default SIG] {{::drug.SigText}}</div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div ng-switch-when="Mfu" id="drug-{{::drug.Drug.DrugId}}">\r\n                    <div class="heading-title overflow-ellipsis">\r\n                        {{::drug.Drug.Description}}\r\n                    </div>\r\n                    <div class="heading-subtitle overflow-ellipsis" ng-if="drug.Drug.Class">\r\n                        {{::drug.Drug.Class}}\r\n                    </div>\r\n                </div>\r\n            </div>\r\n           \r\n            <div class="col-xs-1 col-xs-flush text-right" ng-if="drug.indicateSelected">\r\n                    <ap-spinner size="2"></ap-spinner>\r\n            </div>\r\n           \r\n            <div class="flexbox flexbox-pull-right">\r\n                <span><i class="ap-chevron-right-gray"></i></span>\r\n            </div>\r\n        </li>\r\n    </ul>\r\n</div>'),$templateCache.put("/sigwriter/component-views/epcsSignature.html",'                    <div class="row epcs-signature">\r\n                        <div class="col-xs-12">\r\n                            <div class="heading-title">Provider Signature for Prescribing Controlled Substances</div>\r\n                        </div>\r\n                        <div class="col-xs-12">\r\n                            <div class="heading-title col-xs-4 col-xs-flush">Provider Name:</div>\r\n                            <div class="col-xs-8 col-xs-flush">{{ $ctrl.epcsModel.providerName }}</div>\r\n                        </div>\r\n                        <div class="col-xs-12">\r\n                            <div class="heading-title col-xs-4 col-xs-flush">DEA Number:</div>\r\n                            <div class="col-xs-8 col-xs-flush">{{ $ctrl.epcsModel.providerDeaNumber }}</div>\r\n                        </div>\r\n                        <div class="col-xs-12">\r\n                            <div class="detail-group">\r\n                                <div class="form-group">\r\n                                    <div class="col-xs-6">\r\n                                        <label class="control-label" for="EpcsSignatureOtpPassword" translate>OTP Password</label>\r\n                                        <br>\r\n                                        <input type="password"\r\n                                                class="form-control"\r\n                                                name="EpcsSignatureOtpPassword"\r\n                                                ng-model="$ctrl.epcsModel.otpPassword"\r\n                                                ap-required="true" />\r\n                                    </div>\r\n                                    <div class="col-xs-6">\r\n                                        <label class="control-label" for="EpcsSignatureOtpPinCode" translate>OTP PIN Code</label>\r\n                                        <br>\r\n                                        <input type="text"\r\n                                                class="form-control"\r\n                                                name="EpcsSignatureOtpPinCode"\r\n                                                ng-model="$ctrl.epcsModel.otpPinCode"\r\n                                                ap-required="true" />\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="col-xs-12 epcs-instructions">\r\n                            By completing the two-factor authentication protocol at this time, you are legally signing the prescription(s) and authorizing the transmission of the above information to the pharmacy for dispensing. The two-factor authentication protocol may only be completed by the practitioner whose name and DEA registration number appear above.\r\n                        </div>\r\n                    </div>\r\n'),$templateCache.put("/sigwriter/component-views/formularyDetails.html",'<div id="sigwriter-formulary-details">\r\n    <div class="row" ng-hide="$ctrl.isInfoAvailable || $ctrl.loading || !$ctrl.details">\r\n        <div class="col-xs-12">\r\n            <span translate>\r\n                Formulary information is not currently available.\r\n            </span>\r\n        </div>\r\n    </div>\r\n    \r\n    <div ng-show="!$ctrl.loading && !$ctrl.error && $ctrl.isInfoAvailable">\r\n        <div class="row" id="drug-formulary-summary">\r\n            <div class="col-xs-12">\r\n                <div class="form-group row">\r\n                    <div class="col-xs-3 col-md-2">\r\n                        <label class="control-label text-left">{{::\'Medication\' | translate}}</label>\r\n                    </div>\r\n\r\n                    <div class="col-xs-9 col-md-10">\r\n                        <span class="text-left">{{$ctrl.details.primaryMedication.name}}</span>\r\n                    </div>\r\n                </div>\r\n                <div class="form-group row ng-hide" ng-show="$ctrl.details.primaryMedication.formularyStatus">\r\n                    <div class="col-xs-3 col-md-2">\r\n                        <label class="control-label text-left">{{::\'Formulary Status\' | translate}}</label>\r\n                    </div>\r\n\r\n                    <div class="col-xs-9 col-md-10">\r\n                        <span class="text-left">{{$ctrl.details.primaryMedication.formularyStatus}}</span>\r\n                    </div>\r\n                </div>\r\n                <div class="form-group row" ng-repeat="copay in $ctrl.details.primaryMedication.copays">\r\n                    <div class="col-xs-3 col-md-2">\r\n                        <label class="control-label text-left">{{copay.CopayLabel}}</label>\r\n                    </div>\r\n\r\n                    <div class="col-xs-9 col-md-10">\r\n                        <span class="text-left">{{copay.CopayValue}}</span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id="rx-formulary-display">\r\n        <div id="rx-formulary-loading" ng-show="$ctrl.loading">\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    Loading Formulary Details\r\n                    <br/>\r\n                    <ap-spinner data-size="3"></ap-spinner>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        \r\n        <div ng-show="!$ctrl.loading && !$ctrl.error && $ctrl.details && !$ctrl.showResponseXml && !$ctrl.showRFSResponseXml">\r\n            <div class="row" ng-if="$ctrl.details.ResponsePMBC.Medications && $ctrl.details.ResponsePMBC.Medications.length > 0">\r\n                <div class="col-xs-12">\r\n                    <div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'!Alternative\'} : true">\r\n                        <span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Medication Requested" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                        <sigwriter-pmbc-medication\r\n                            med="med"\r\n                            show-drug-icons="true"\r\n                            select="$ctrl.changeMedication(med, pricingCoverage)"\r\n                        />\r\n                    </div>\r\n                    <div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true">\r\n                        <span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Alternative Medications" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                        <sigwriter-pmbc-medication\r\n                            med="med"\r\n                            show-drug-icons="true"\r\n                            select="$ctrl.changeMedication(med, pricingCoverage)"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n                <div class="col-xs-12">\r\n                    <span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails = !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails">Transmit Status - Patient Medication Benefit Check<span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.Status }}">\r\n                            Status: {{ $ctrl.details.ResponsePMBC.TransmitStatus.Status }}\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.Response }}">\r\n                            Response: {{ $ctrl.details.ResponsePMBC.TransmitStatus.Response }} <button ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.ResponseXml && $ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showResponseXml = true;"><span>View Response</span></button>\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus">\r\n                            Deny Status: {{ $ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus }}\r\n                        </div>\t\t\t\t\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.RequestError">\r\n                            Request Error: {{ $ctrl.details.ResponsePMBC.TransmitStatus.RequestError }}\r\n                        </div>\t\t\t\t\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-if="$ctrl.details.ResponseRFS.Medications && $ctrl.details.ResponseRFS.Medications.length > 0">\r\n                <div class="col-xs-12">\r\n                    <div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'!Alternative\'} : true">\r\n                        <span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Formulary Medication" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                        <sigwriter-rfs-medication\r\n                            med="med"\r\n                            show-drug-icons="true"\r\n                            select="$ctrl.changeMedication(med)"\r\n                        />\r\n                    </div>\r\n                    <div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true">\r\n                        <span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Formulary Alternatives" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                        <sigwriter-rfs-medication\r\n                            med="med"\r\n                            show-drug-icons="true"\r\n                            select="$ctrl.changeMedication(med)"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-if="$ctrl.details.ResponseRFS.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n                <div class="col-xs-12">\r\n                    <span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails = !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails">Transmit Status - Representative Formulary Service<span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.Status }}">\r\n                            Status: {{ $ctrl.details.ResponseRFS.TransmitStatus.Status }}\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.Response }}">\r\n                            Response: {{ $ctrl.details.ResponseRFS.TransmitStatus.Response }} <button ng-if="$ctrl.details.ResponseRFS.TransmitStatus.ResponseXml && $ctrl.details.ResponseRFS.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showRFSResponseXml = true;"><span>View Response</span></button>\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponseRFS.TransmitStatus.DenyStatus">\r\n                            Deny Status: {{ $ctrl.details.ResponseRFS.TransmitStatus.DenyStatus }}\r\n                        </div>\t\t\t\t\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponseRFS.TransmitStatus.RequestError">\r\n                            Request Error: {{ $ctrl.details.ResponseRFS.TransmitStatus.RequestError }}\r\n                        </div>\t\t\t\t\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    \r\n        <div ng-show="$ctrl.showResponseXml">\r\n            <div class="row">\r\n                <div class="col-xs-12 col-xs-flush response-xml">\r\n                    <div class="col-xs-12">\r\n                        <span class="pull-left header">Response XML</span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n                    </div>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <pre ng-bind="$ctrl.details.ResponsePMBC.TransmitStatus.ResponseXml" />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    \r\n        <div ng-show="$ctrl.showRFSResponseXml">\r\n            <div class="row">\r\n                <div class="col-xs-12 col-xs-flush response-xml">\r\n                    <div class="col-xs-12">\r\n                        <span class="pull-left header">Response XML</span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showRFSResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n                    </div>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <pre ng-bind="$ctrl.details.ResponseRFS.TransmitStatus.ResponseXml" />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    \r\n        <div ng-show="!$ctrl.loading && !$ctrl.error && !$ctrl.details">\r\n            <div class="col-xs-12">\r\n                <uib-alert type="success" translate>\r\n                    No formulary details were found.\r\n                </uib-alert>\r\n            </div>\r\n        </div>\r\n        \r\n        <div ng-show="$ctrl.error">\r\n            <div class="col-xs-12">\r\n                <uib-alert type="danger" translate>\r\n                    There was a communication issue with the server.  Please contact support.\r\n                </uib-alert>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/formularyDisplay.html",'<div id="sigwriter-formulary-display">\r\n    <div class="row" ng-hide="$ctrl.isInfoAvailable || $ctrl.loading || !$ctrl.details">\r\n        <div class="col-xs-12">\r\n            <span translate>\r\n                Formulary information is not currently available.\r\n            </span>\r\n        </div>\r\n    </div>\r\n    \r\n    <div ng-show="!$ctrl.loading && !$ctrl.error && $ctrl.isInfoAvailable">\r\n        <div id="drug-formulary-summary">\r\n            <div class="form-group row">\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-medication-name">{{$ctrl.details.primaryMedication.name}}</span>\r\n                </div>\r\n            </div>\r\n            <div class="form-group row">\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-status" title="{{ $ctrl.formularyStatusCertification($ctrl.details.primaryMedication.formularyStatus) }}">{{$ctrl.formularyStatusShow($ctrl.details.primaryMedication.formularyStatus)}}</span>\r\n                </div>\r\n            </div>\r\n            <div class="form-group row" ng-repeat="copay in $ctrl.details.primaryMedication.copays">\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-copay-label">{{copay.CopayLabel}}:</span>\r\n                    <span class="rx-formulary-copay">{{copay.CopayValue}}</span>\r\n                </div>\r\n            </div>\r\n            <div class="form-group row" ng-show="$ctrl.details.primaryMedication.formularyCoverageRestrictions">\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-restrictions">{{::\'Has Coverage Factors\' | translate }}</span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="!$ctrl.loading && !$ctrl.error && $ctrl.details && $ctrl.hasAlternatives()">\r\n        <div id="drug-formulary-alternatives">\r\n            <div class="form-group row">\r\n                <div class="col-xs-12">\r\n                    <span class="crx-formulary-medication-name">{{::\'Alternatives\' | translate }}</span>\r\n                </div>\r\n            </div>        \r\n            <div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true" class="form-group" ng-if="$ctrl.details.ResponsePMBC.Medications && $ctrl.details.ResponsePMBC.Medications.length > 0">\r\n                <div class="col-xs-12" title="{{ med.Description + \' \' + (med.Strength || \'\') }}">                        \r\n                    <span class="rx-formulary-medication-name" ng-class="{\'clickable\': (med.MedId > 0) }" title="{{ med.Description }}" ng-click="$ctrl.changeMedication(med, null)">{{ med.Description + (med.Strength || \'\') }}</span>\r\n                </div>\r\n                <div class="col-xs-12" title="{{ med.DisplaySinglePrice }}">                        \r\n                    <span class="rx-formulary-status" title="{{ $ctrl.formularyStatusCertification(med.FormularyStatus) }}" ng-show="med.FormularyStatus">{{ med.FormularyStatusTerse }}</span>\r\n                    <span class="rx-formulary-dash" ng-show="med.FormularyStatus && med.DisplayTerseSinglePrice">-</span>\r\n                    <span class="rx-formulary-copay-label" ng-show="med.DisplayTerseSinglePrice">{{ med.DisplayTerseSinglePrice }}</span>\r\n                    <span class="rx-formulary-restrictions">{{ med.DisplayHasRestrictions ? \' (Restrictions)\' : \'\' }}</span>\r\n                </div>\r\n            </div>\r\n            <div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true" class="form-group" ng-if="$ctrl.details.ResponseRFS.Medications && $ctrl.details.ResponseRFS.Medications.length > 0">\r\n                <div class="col-xs-12" title="{{ med.Description }}">\r\n                    <span class="rx-formulary-medication-name" ng-class="{\'clickable\': (med.MedId > 0) }" title="{{ med.Description }}" ng-click="$ctrl.changeMedication(med, null)">{{ med.Description }}</span>\r\n                </div>\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-status" title="{{ $ctrl.formularyStatusCertification(med.FormularyStatus) }}" ng-show="med.FormularyStatus">{{ med.FormularyStatusTerse }}</span>\r\n                    <span class="rx-formulary-dash" ng-show="med.FormularyStatus && med.DisplaySingleCopayTerseValue">-</span>\r\n                    <span class="rx-formulary-copay" title="{{ med.DisplaySingleCopayLabel + \': \' + med.DisplaySingleCopayValue }}" ng-show="med.DisplaySingleCopayTerseValue">{{ med.DisplaySingleCopayTerseValue }}</span>\r\n                    <span class="rx-formulary-restrictions">{{ med.DisplayHasRestrictions ? \' (Restrictions)\' : \'\' }}</span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="!$ctrl.loading && !$ctrl.error && !$ctrl.details">\r\n        <div class="col-xs-12">\r\n            <uib-alert type="success" translate>\r\n                No formulary details were found.\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n    \r\n    <div ng-show="$ctrl.error">\r\n        <div class="col-xs-12">\r\n            <uib-alert type="danger" translate>\r\n                There was a communication issue with the server.  Please contact support.\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/freeTextDirections.html",'<div ng-hide="vm.textOpen || vm.hasValue()">\r\n    <button type="button"\r\n            class="btn btn-link btn-square"\r\n            ng-click="vm.onClickOpen()">\r\n        <span class="ap-insert-text"></span>\r\n    </button>\r\n</div>\r\n<div ng-show="vm.textOpen || vm.hasValue()" ng-transclude>\r\n</div>\r\n'),$templateCache.put("/sigwriter/component-views/nddCondensedDrugScreening.html",'<div id="ndd-condensed-drug-screening">\r\n    <div id="drug-screening-loading" ng-if="$ctrl.loading">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Performing Drug Screening\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id="drug-screening-error" ng-if="!$ctrl.loading && $ctrl.error">\r\n        <div class="col-xs-12">\r\n            <uib-alert type="danger" translate>\r\n                There was an error while performing drug screening.  Please contact support.\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n    <div id="drug-screening-info" ng-if="!$ctrl.loading && !$ctrl.error">\r\n        <div ng-if="$ctrl.screening.Error">\r\n            <div ng-if="$ctrl.screening.Error === \'NoScreeningOptionsSelected\'">\r\n                <uib-alert type="warning" translate>None of the drug screening options have been selected.</uib-alert>\r\n            </div>\r\n            <div ng-if="$ctrl.screening.Error === \'NoActiveMedications\'">\r\n                <uib-alert type="warning" translate>The patient does not have any active medications to screen.</uib-alert>\r\n            </div>\r\n            <div ng-if="$ctrl.screening.Error === \'NoParameters\'">\r\n                <uib-alert type="warning" translate>There was nothing to screen.</uib-alert>\r\n            </div>\r\n        </div>\r\n        <div ng-if="!$ctrl.screening.Error">\r\n            <div class="row" ng-if="$ctrl.screening.Status === \'Completed\' || $ctrl.screening.Status === \'CompletedOutOfDate\'">\r\n                <div class="col-xs-12">\r\n                    <uib-alert type="success" translate>\r\n                        No medication alerts or precautions were found.\r\n                    </uib-alert>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-if="$ctrl.screening.Status === \'CompletedWithAlerts\'">\r\n                \x3c!-- FDB Alerts --\x3e\r\n                <div class="col-xs-12">\r\n                    <div ng-if="$ctrl.screening.ProposedDrug && $ctrl.screening.ProposedDrug.IsUserDefined">\r\n                        <uib-alert type="danger">{{::\'Drug screening cannot be performed with a user defined medication.\' | translate}}</uib-alert>\r\n                    </div>\r\n                    <div ng-if="$ctrl.screening.ActXResult">\r\n                        <uib-alert type="warning" translate>ActX result available below.</uib-alert>\r\n                    </div>\r\n\r\n                    <div ng-if="!($ctrl.screening.ProposedDrug && $ctrl.screening.ProposedDrug.IsUserDefined)">\r\n                        <div class="" ng-if="$ctrl.screening.InteractionResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.InteractionResult.OverallSeverity)" translate>\r\n                                INTERACTION ALERT\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.DuplicateTherapyResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.DuplicateTherapyResult.OverallSeverityLevel)" translate>\r\n                                DUPLICATE THERAPY ALERT\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.DuplicateIngredientResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.DuplicateIngredientResult.OverallSeverityLevel)" translate>\r\n                                DUPLICATE INGREDIENT ALERT\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.AllergyResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.AllergyResult.OverallSeverityLevel)" translate>\r\n                                ALLERGY ALERT\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.MedicalConditionResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.MedicalConditionResult.OverallSeverity)" translate>\r\n                                MEDICAL CONDITION PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.PregnancyResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.PregnancyResult.OverallSeverity)" translate>\r\n                                PREGNANCY PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.LactationResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.LactationResult.OverallSeverity)" translate>\r\n                                LACTATION PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.PediatricResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.PediatricResult.OverallSeverity)" translate>\r\n                                PEDIATRIC PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.GeriatricResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.GeriatricResult.OverallSeverity)" translate>\r\n                                GERIATRIC PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.UserDefinedAllergyResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.UserDefinedAllergyResult.OverallSeverityLevel)" translate>\r\n                                USER DEFINED ALLERGIES\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.UserDefinedMedicationResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.UserDefinedMedicationResult.OverallSeverityLevel)" translate>\r\n                                USER DEFINED MEDICATIONS\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="$ctrl.screening.DisclaimerText">\r\n            <hr/>\r\n            <div class="row">\r\n                <div id="ndd-legal-alert" class="col-xs-12">\r\n                    {{$ctrl.screening.DisclaimerText}}\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="$ctrl.screening.Version">\r\n            <hr/>\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    <div ng-if="$ctrl.screening.Version.ExpirationWarning">{{$ctrl.screening.Version.ExpirationWarning}}</div>\r\n                    <div>{{$ctrl.screening.Version.VersionInformation}}</div>\r\n                    <div>{{$ctrl.screening.Version.Copyright}}</div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="!$ctrl.screening.Error && $ctrl.screening.Status === \'CompletedWithAlerts\'">\r\n            \x3c!-- Non-FDB Alerts --\x3e\r\n            <div ng-if="$ctrl.screening.ActXResult">\r\n                <hr/>\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.ActXResult.OverallSeverityLevel)" translate>\r\n                            ACTX ALERT\r\n                        </span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/nddDetailedDrugScreening.html",'<div id="ndd-detailed-drug-screening">\r\n    <div id="drug-screening-loading" ng-if="$ctrl.loading">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Performing Drug Screening\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id="drug-screening-error" ng-if="!$ctrl.loading && $ctrl.error">\r\n        <div class="col-xs-12">\r\n            <uib-alert type="danger" translate>\r\n                There was an error while performing drug screening.  Please contact support.\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n    <div id="drug-screening-info" ng-if="!$ctrl.loading && !$ctrl.error">\r\n        <div ng-if="$ctrl.screening.Error">\r\n            <div ng-if="$ctrl.screening.Error === \'NoScreeningOptionsSelected\'">\r\n                <uib-alert type="warning" translate>None of the drug screening options have been selected.</uib-alert>\r\n            </div>\r\n            <div ng-if="$ctrl.screening.Error === \'NoActiveMedications\'">\r\n                <uib-alert type="warning" translate>The patient does not have any active medications to screen.</uib-alert>\r\n            </div>\r\n            <div ng-if="$ctrl.screening.Error === \'NoParameters\'">\r\n                <uib-alert type="warning" translate>There was nothing to screen.</uib-alert>\r\n            </div>\r\n        </div>\r\n        <div ng-if="!$ctrl.screening.Error">\r\n            <div class="row" ng-if="$ctrl.screening.Status === \'Completed\' || $ctrl.screening.Status === \'CompletedOutOfDate\'">\r\n                <div class="col-xs-12">\r\n                    <uib-alert type="success" translate>\r\n                        No medication alerts or precautions were found.\r\n                    </uib-alert>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-if="$ctrl.screening.Status === \'CompletedWithAlerts\'">\r\n                \x3c!-- FDB Alerts --\x3e\r\n                <div class="col-xs-12">\r\n                    <div ng-if="$ctrl.screening.ProposedDrug && $ctrl.screening.ProposedDrug.IsUserDefined">\r\n                        <uib-alert type="danger">{{::\'Drug screening cannot be performed with a user defined medication.\' | translate}}</uib-alert>\r\n                    </div>\r\n                    <div ng-if="$ctrl.screening.ActXResult">\r\n                        <uib-alert type="warning" translate>ActX result available below.</uib-alert>\r\n                    </div>\r\n\r\n                    <div ng-if="!($ctrl.screening.ProposedDrug && $ctrl.screening.ProposedDrug.IsUserDefined)">\r\n                        <div class="" ng-if="$ctrl.screening.InteractionResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.InteractionResult.OverallSeverity)" translate>\r\n                                INTERACTION ALERT\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="interactionFinding in $ctrl.screening.InteractionResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(interactionFinding.Severity)">\r\n                                    {{ $ctrl.getInteractionSeverityTitle(interactionFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span>Use of</span>\r\n                                    <span class="medication-name">{{ interactionFinding.FirstMedicationName }}</span>\r\n                                    <span>and</span>\r\n                                    <span class="medication-name">{{ interactionFinding.SecondMedicationName }}</span>\r\n                                    <span>may interact based on the potential interaction between</span>\r\n                                    <span class="interaction-description">{{ interactionFinding.Description + \'.\' }}</span>\r\n                                    <div class="interaction-effect" ng-repeat="effect in interactionFinding.Effects">\r\n                                        <span class="effect-label">Effect:</span>\r\n                                        <span>{{ effect }}</span>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.DuplicateTherapyResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.DuplicateTherapyResult.OverallSeverityLevel)" translate>\r\n                                DUPLICATE THERAPY ALERT\r\n                            </h4>\r\n                            <div class="warning" ng-repeat="duplicateTherapyWarning in $ctrl.screening.DuplicateTherapyResult.Warnings">\r\n                                <span>Use of</span>\r\n                                <span class="medication-name">{{ duplicateTherapyWarning.FirstMedicationName }}</span>\r\n                                <span>and</span>\r\n                                <span class="medication-name">{{ duplicateTherapyWarning.SecondMedicationName }}</span>\r\n                                <span>may represent a duplication in therapy based on their association to the therapeutic drug class</span>\r\n                                <span class="class-description">{{ duplicateTherapyWarning.ClassDescription + \'.\' }}</span>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.DuplicateIngredientResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.DuplicateIngredientResult.OverallSeverityLevel)" translate>\r\n                                DUPLICATE INGREDIENT ALERT\r\n                            </h4>\r\n                            <div class="warning" ng-repeat="duplicateIngredientWarning in $ctrl.screening.DuplicateIngredientResult.Warnings">\r\n                                <span>Use of</span>\r\n                                <span class="medication-name">{{ duplicateIngredientWarning.FirstMedicationName }}</span>\r\n                                <span>and</span>\r\n                                <span class="medication-name">{{ duplicateIngredientWarning.SecondMedicationName }}</span>\r\n                                <span>{{ \'represent a duplication based on the following ingredient\' + (duplicateIngredientWarning.IngredientListCount > 1 ? \'s\' : \'\') + \':\' }}</span>\r\n                                <span class="ingredient-list">{{ duplicateIngredientWarning.IngredientList + \'.\' }}</span>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.AllergyResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.AllergyResult.OverallSeverityLevel)" translate>\r\n                                ALLERGY ALERT\r\n                            </h4>\r\n                            <div class="warning" ng-repeat="allergyWarning in $ctrl.screening.AllergyResult.Warnings">\r\n                                <span>Use of</span>\r\n                                <span class="medication-name">{{ allergyWarning.MedicationName }}</span>\r\n                                <span>may result in an allergic reaction based on a reported history of allergy to</span>\r\n                                <span class="allergen">{{ allergyWarning.AllergenName + \'.\' }}</span>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.MedicalConditionResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.MedicalConditionResult.OverallSeverity)" translate>\r\n                                MEDICAL CONDITION PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="medicalConditionFinding in $ctrl.screening.MedicalConditionResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(medicalConditionFinding.Severity)">\r\n                                    {{ $ctrl.getMedicalConditionSeverityTitle(medicalConditionFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span>Use of</span>\r\n                                    <span class="medication-name">{{ medicalConditionFinding.MedicationName }}</span>\r\n                                    <span>is contraindicated when</span>\r\n                                    <span>{{ medicalConditionFinding.FdbDescription + \',\' }}</span>\r\n                                    <span>a condition related to</span>\r\n                                    <span>{{ medicalConditionFinding.DiseaseDescription + \',\' }}</span>\r\n                                    <span>exists.</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.PregnancyResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.PregnancyResult.OverallSeverity)" translate>\r\n                                PREGNANCY PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="pregnancyFinding in $ctrl.screening.PregnancyResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(pregnancyFinding.Severity)">\r\n                                    {{ $ctrl.getPregnancySeverityTitle(pregnancyFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span class="medication-name">{{ pregnancyFinding.MedicationName }}</span>\r\n                                    <span>{{ pregnancyFinding.Narrative }}</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.LactationResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.LactationResult.OverallSeverity)" translate>\r\n                                LACTATION PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="lactationFinding in $ctrl.screening.LactationResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(lactationFinding.Severity)">\r\n                                    {{ $ctrl.getLactationSeverityTitle(lactationFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span class="medication-name">{{ lactationFinding.MedicationName }}</span>\r\n                                    <span>(due to</span>\r\n                                    <span class="ingredient-name">{{ lactationFinding.Description }}</span>\r\n                                    <span>ingredient)</span>\r\n                                    <span>{{ lactationFinding.SeverityDescription }}</span>\r\n                                    <br/>\r\n                                    <span>{{ lactationFinding.EffectsOnInfant + \',\' }}</span>\r\n                                    <br/>\r\n                                    <span>{{ lactationFinding.ExcretionPotential + \',\' }}</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.PediatricResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.PediatricResult.OverallSeverity)" translate>\r\n                                PEDIATRIC PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="pediatricFinding in $ctrl.screening.PediatricResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(pediatricFinding.Severity)">\r\n                                    {{ $ctrl.getPediatricSeverityTitle(pediatricFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span class="medication-name">{{ pediatricFinding.MedicationName }}</span>\r\n                                    <span>{{ pediatricFinding.Narrative }}</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.GeriatricResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.GeriatricResult.OverallSeverity)" translate>\r\n                                GERIATRIC PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="geriatricFinding in $ctrl.screening.GeriatricResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(geriatricFinding.Severity)">\r\n                                    {{ $ctrl.getGeriatricSeverityTitle(geriatricFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span class="medication-name">{{ geriatricFinding.MedicationName }}</span>\r\n                                    <span class="geriatric-narrative">{{ geriatricFinding.Narrative }}</span>\r\n                                    <div ng-if="geriatricFinding.DrugListNames && geriatricFinding.DrugListNames.length">\r\n                                        <br/>\r\n                                        <span class="medication-name">{{ geriatricFinding.MedicationName }}</span>\r\n                                        <span>{{ \'is included in the following "potentially harmful drugs in the elderly" list\' + (geriatricFinding.DrugListNames.length > 1 ? \'s\' : \'\') + \':\' }}</span>\r\n                                        <span class="geriatric-drug-lists">{{ geriatricFinding.DrugListNames.join(\', \') + \'.\' }}</span>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.UserDefinedAllergyResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.UserDefinedAllergyResult.OverallSeverityLevel)" translate>\r\n                                USER DEFINED ALLERGIES\r\n                            </h4>\r\n                            <div class="warning">\r\n                                <span>The following drug allergies were not included in any allergy to drug screening test:</span>\r\n                                <span ng-repeat="userDefinedAllergyWarning in $ctrl.screening.UserDefinedAllergyResult.Warnings">\r\n                                    {{ userDefinedAllergyWarning.AllergyName + ($last ? \'\' : \',\') }}\r\n                                </span>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.UserDefinedMedicationResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.UserDefinedMedicationResult.OverallSeverityLevel)" translate>\r\n                                USER DEFINED MEDICATIONS\r\n                            </h4>\r\n                            <div class="warning">\r\n                                <span>The following medications were not included in any drug screening test:</span>\r\n                                <span ng-repeat="userDefinedMedicationWarning in $ctrl.screening.UserDefinedMedicationResult.Warnings">\r\n                                    {{ userDefinedMedicationWarning.MedicationName + ($last ? \'\' : \',\') }}\r\n                                </span>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="$ctrl.screening.DisclaimerText">\r\n            <hr/>\r\n            <div class="row">\r\n                <div id="ndd-legal-alert" class="col-xs-12">\r\n                    {{$ctrl.screening.DisclaimerText}}\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="$ctrl.screening.Version">\r\n            <hr/>\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    <div ng-if="$ctrl.screening.Version.ExpirationWarning">{{$ctrl.screening.Version.ExpirationWarning}}</div>\r\n                    <div>{{$ctrl.screening.Version.VersionInformation}}</div>\r\n                    <div>{{$ctrl.screening.Version.Copyright}}</div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="!$ctrl.screening.Error && $ctrl.screening.Status === \'CompletedWithAlerts\'">\r\n            \x3c!-- Non-FDB Alerts --\x3e\r\n            <div ng-if="$ctrl.screening.ActXResult">\r\n                <hr/>\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.ActXResult.OverallSeverityLevel)" translate>\r\n                            ACTX ALERT\r\n                        </h4>\r\n                        <div class="warning">\r\n                            <div ng-repeat="actXWarning in $ctrl.screening.ActXResult.Warnings">\r\n                                <div class="medication-name">{{ actXWarning.MedicationName }}</div>\r\n                                <div>\r\n                                    Seriousness: {{actXWarning.Seriousness}}\r\n                                </div>\r\n                                <div>\r\n                                    Summary: {{actXWarning.ShortSummary}}\r\n                                </div>\r\n                                <div>\r\n                                    Additional Information: {{actXWarning.ExtendedSummary}}\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/pmbcMedication.html",'<div class="col-xs-12 col-xs-flush medication">\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'clickable\': ($ctrl.med.MedId > 0), \'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         title="{{ $ctrl.med.Description + \' \' + ($ctrl.med.Strength || \'\') }}"\r\n         ng-click="$ctrl.onSelect()">\r\n\r\n        Drug Description: {{ $ctrl.med.Description }} <span ng-if="$ctrl.med.Strength" ng-bind="$ctrl.med.Strength"></span>\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis">\r\n        Formulary Status: {{ $ctrl.med.FormularyStatus }}\r\n    </div>\r\n    <div class="hidden-xs hidden-sm col-md-4 overflow-ellipsis" ng-if="!$ctrl.med.ShowDetails">\r\n        &nbsp;\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis">\r\n        Quantity Requested: {{ $ctrl.med.QuantityRequested }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis">\r\n        Days Supply Requested: {{ $ctrl.med.DaysSupplyRequested }}\r\n    </div>\r\n    <div class="hidden-xs hidden-sm col-md-4 overflow-ellipsis" ng-if="!$ctrl.med.ShowDetails">\r\n        &nbsp;\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.ProductCode">\r\n        {{ $ctrl.med.ProductCodeQualifier}}: {{ $ctrl.med.ProductCode }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.Strength">\r\n        Strength: {{ $ctrl.med.Strength }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.DrugDbCode">\r\n        {{ $ctrl.med.DrugDbCodeQualifier}}: {{ $ctrl.med.DrugDbCode }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.DeaSchedule">\r\n        DEA Schedule: {{ $ctrl.med.DeaSchedule }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.Quantity">\r\n        Quantity: {{ $ctrl.med.Quantity }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.WrittenDate">\r\n        Date Written: {{ $ctrl.med.WrittenDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.LastFillDate">\r\n        Last Fill Date: {{ $ctrl.med.LastFillDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.ExpirationDate">\r\n        Expiration Date: {{ $ctrl.med.ExpirationDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.EarliestFillDate">\r\n        Earliest Fill Date: {{ $ctrl.med.EarliestFillDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.PeriodEndDate">\r\n        Period End Date: {{ $ctrl.med.PeriodEndDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.DeliveredOnDate">\r\n        Date Delivered: {{ $ctrl.med.DeliveredOnDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.ValidatedOnDate">\r\n        Date Validated: {{ $ctrl.med.ValidatedOnDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.DispenseAsWritten">\r\n        DAW: {{ $ctrl.med.DispenseAsWritten }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.NumberOfRefills">\r\n        # of Refills: {{ $ctrl.med.NumberOfRefills }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{ \'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         ng-if="$ctrl.med.ShowDetails && $ctrl.med.Diagnoses">\r\n\r\n        Diagnoses: {{ $ctrl.med.Diagnoses }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.CouponNumber">\r\n        Coupon Number: {{ $ctrl.med.CouponNumber }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{ \'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         ng-if="$ctrl.med.ShowDetails && $ctrl.med.Note">\r\n\r\n        Note: {{ $ctrl.med.Note }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.PriorAuthorization">\r\n        Prior Authorization: {{ $ctrl.med.PriorAuthorization }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.PriorAuthorizationStatus">\r\n        Prior Authorization Status: {{ $ctrl.med.PriorAuthorizationStatus }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.CompoundInformation">\r\n        Compound Info: {{ $ctrl.med.CompoundInformation }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{ \'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         ng-if="$ctrl.med.ShowDetails && $ctrl.med.SigText">\r\n\r\n        Sig Text: {{ $ctrl.med.SigText }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.RefillsRemaining">\r\n        Refills Remaining: {{ $ctrl.med.RefillsRemaining }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.RefillsLimit">\r\n        Refills Limit: {{ $ctrl.med.RefillsLimit }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.ReasonForDawCode">\r\n        Reason for DAW: {{ $ctrl.med.ReasonForDawCode }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.OfficeOfPharmacyAffairsId">\r\n        Office of Pharmacy Affairs ID: {{ $ctrl.med.OfficeOfPharmacyAffairsId }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4" ng-if="$ctrl.showDrugIcons">\r\n        <sigwriter-drug-icon-group drug="$ctrl.med.Drug" />\r\n    </div>\r\n</div>\r\n<div>\r\n    <div class="col-xs-12 col-xs-flush col-sm-6 col-md-4 pricing-spacer"\r\n         ng-repeat="pricingCoverage in $ctrl.med.PricingCoverages">\r\n        <div class="col-xs-12 col-xs-flush pricing">\r\n            <div class="col-xs-12"\r\n                 ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails, \'clickable\': pricingCoverage.PharmacyId }"\r\n                 title="{{ (pricingCoverage.PharmacyType || \'\') + \' \' + pricingCoverage.PharmacyName }}"\r\n                 ng-click="$ctrl.onSelect(pricingCoverage)">\r\n\r\n                Pharmacy<span ng-if="pricingCoverage.PharmacyType" ng-bind="pricingCoverage.PharmacyType"></span>: <span class="detail-emphasis" ng-bind="pricingCoverage.PharmacyName"></span>\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="pricingCoverage.QuantityPriced">\r\n                Quantity Priced: {{ pricingCoverage.QuantityPriced }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="pricingCoverage.DaysSupplyPriced">\r\n                Days Supply Priced: {{ pricingCoverage.DaysSupplyPriced }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="pricingCoverage.PatientPayAmount">\r\n                Est. Patient Pay Amount: <span class="detail-emphasis" ng-bind="pricingCoverage.PatientPayAmount | currency"></span>\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.DrugStatus">\r\n                Drug Status: {{ pricingCoverage.DrugStatus }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.FormularyStatus">\r\n                Formulary Status: {{ pricingCoverage.FormularyStatus }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.PriorAuthRequired">\r\n                Prior Auth Required: {{ pricingCoverage.PriorAuthRequired }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.OutOfPocketAppliedAmount">\r\n                OOP Applied Amount: {{ pricingCoverage.OutOfPocketAppliedAmount | currency }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.OutOfPocketRemainingAmount">\r\n                OOP Remaining Amount: {{ pricingCoverage.OutOfPocketRemainingAmount | currency }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.DeductibleAppliedAmount">\r\n                Deductible Applied Amount: {{ pricingCoverage.DeductibleAppliedAmount | currency }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.DeductibleRemainingAmount">\r\n                Deductible Remaining Amount: {{ pricingCoverage.DeductibleRemainingAmount | currency }}\r\n            </div>\r\n            <div class="col-xs-12 col-xs-flush"\r\n                 ng-if="pricingCoverage.Restrictions && (pricingCoverage.Restrictions.length > 0)"\r\n                 title="{{ pricingCoverage.Restrictions.join(\', \') }}">\r\n\r\n                Restrictions/Alerts: <ul><li ng-repeat="restriction in pricingCoverage.Restrictions" list-group-item"" ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails }">{{ restriction }}</li></ul>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/rfsMedication.html",'<div class="col-xs-12 col-xs-flush medication">\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails, \'clickable\': ($ctrl.med.MedId > 0) }"\r\n         title="{{ $ctrl.med.Description }}"\r\n         ng-click="$ctrl.onSelect()">\r\n\r\n        Name: {{ $ctrl.med.Description }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis"\r\n         title="{{ $ctrl.med.FormularyStatus }}">\r\n\r\n        Formulary Status: {{ $ctrl.med.FormularyStatus }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis"\r\n         ng-if="$ctrl.med.FormularyCost">\r\n\r\n        Formulary Cost: {{ $ctrl.med.FormularyCost }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         ng-repeat="copay in $ctrl.med.FormularyCopays">\r\n\r\n        {{ copay }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         title="{{ $ctrl.med.DrugClass }}">\r\n\r\n        Drug Class: {{ $ctrl.med.DrugClass }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         title="{{ $ctrl.med.DrugType }}">\r\n\r\n        Drug Type: {{ $ctrl.med.DrugType }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 coverage-factors"\r\n         ng-if="$ctrl.med.CoverageFactors && $ctrl.med.CoverageFactors.length">\r\n\r\n        Restrictions:\r\n        <span ng-if="!$ctrl.med.ShowDetails" ng-bind="$ctrl.formatRestrictions($ctrl.med.FormularyCoverageRestrictions)"></span>\r\n        <ul ng-if="$ctrl.med.ShowDetails">\r\n            <li ng-repeat="coverageFactor in $ctrl.med.CoverageFactors" ng-bind-html="$ctrl.$sce.trustAsHtml(coverageFactor)"></li>\r\n        </ul>\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-if="$ctrl.showDrugIcons">\r\n\r\n        <sigwriter-drug-icon-group drug="$ctrl.med.Drug" />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/rxFormularyDetails.html",'<div id="rx-formulary-display">\r\n\t<div id="rx-formulary-loading" ng-show="$ctrl.loading">\r\n\t\t<div class="row">\r\n\t\t\t<div class="col-xs-12 text-center">\r\n\t\t\t\tLoading Formulary Details\r\n\t\t\t\t<br/>\r\n\t\t\t\t<ap-spinner data-size="3"></ap-spinner>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\t\r\n\t<div ng-show="!$ctrl.loading && !$ctrl.$scope.httpError && $ctrl.details && !$ctrl.showResponseXml && !$ctrl.showRFSResponseXml">\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponsePMBC.Medications && $ctrl.details.ResponsePMBC.Medications.length > 0">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'!Alternative\'} : true">\r\n\t\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Medication Requested" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t\t<sigwriter-pmbc-medication\r\n\t\t\t\t\t\tmed="med"\r\n\t\t\t\t\t\tshow-drug-icons="$ctrl.showDrugIcons"\r\n\t\t\t\t\t\tselect="$ctrl.changeMedication(med, pricingCoverage)"\r\n\t\t\t\t\t/>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true">\r\n\t\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Alternative Medications" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t\t<sigwriter-pmbc-medication\r\n\t\t\t\t\t\tmed="med"\r\n\t\t\t\t\t\tshow-drug-icons="$ctrl.showDrugIcons"\r\n\t\t\t\t\t\tselect="$ctrl.changeMedication(med, pricingCoverage)"\r\n\t\t\t\t\t/>\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails = !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails">Transmit Status - Patient Medication Benefit Check<span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.Status }}">\r\n\t\t\t\t\t\tStatus: {{ $ctrl.details.ResponsePMBC.TransmitStatus.Status }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.Response }}">\r\n\t\t\t\t\t\tResponse: {{ $ctrl.details.ResponsePMBC.TransmitStatus.Response }} <button ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.ResponseXml && $ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showResponseXml = true;"><span>View Response</span></button>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus">\r\n\t\t\t\t\t\tDeny Status: {{ $ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus }}\r\n\t\t\t\t\t</div>\t\t\t\t\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.RequestError">\r\n\t\t\t\t\t\tRequest Error: {{ $ctrl.details.ResponsePMBC.TransmitStatus.RequestError }}\r\n\t\t\t\t\t</div>\t\t\t\t\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponseRFS.Medications && $ctrl.details.ResponseRFS.Medications.length > 0">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'!Alternative\'} : true">\r\n\t\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Formulary Medication" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t\t<sigwriter-rfs-medication\r\n\t\t\t\t\t\tmed="med"\r\n\t\t\t\t\t\tshow-drug-icons="$ctrl.showDrugIcons"\r\n\t\t\t\t\t\tselect="$ctrl.changeMedication(med)"\r\n\t\t\t\t\t/>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true">\r\n\t\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Formulary Alternatives" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t\t<sigwriter-rfs-medication\r\n\t\t\t\t\t\tmed="med"\r\n\t\t\t\t\t\tshow-drug-icons="$ctrl.showDrugIcons"\r\n\t\t\t\t\t\tselect="$ctrl.changeMedication(med)"\r\n\t\t\t\t\t/>\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponseRFS.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails = !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails">Transmit Status - Representative Formulary Service<span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.Status }}">\r\n\t\t\t\t\t\tStatus: {{ $ctrl.details.ResponseRFS.TransmitStatus.Status }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.Response }}">\r\n\t\t\t\t\t\tResponse: {{ $ctrl.details.ResponseRFS.TransmitStatus.Response }} <button ng-if="$ctrl.details.ResponseRFS.TransmitStatus.ResponseXml && $ctrl.details.ResponseRFS.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showRFSResponseXml = true;"><span>View Response</span></button>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponseRFS.TransmitStatus.DenyStatus">\r\n\t\t\t\t\t\tDeny Status: {{ $ctrl.details.ResponseRFS.TransmitStatus.DenyStatus }}\r\n\t\t\t\t\t</div>\t\t\t\t\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponseRFS.TransmitStatus.RequestError">\r\n\t\t\t\t\t\tRequest Error: {{ $ctrl.details.ResponseRFS.TransmitStatus.RequestError }}\r\n\t\t\t\t\t</div>\t\t\t\t\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\r\n\t<div ng-show="$ctrl.showResponseXml">\r\n\t\t<div class="row">\r\n\t\t\t<div class="col-xs-12 col-xs-flush response-xml">\r\n\t\t\t\t<div class="col-xs-12">\r\n\t\t\t\t\t<span class="pull-left header">Response XML</span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<pre ng-bind="$ctrl.details.ResponsePMBC.TransmitStatus.ResponseXml" />\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\r\n\t<div ng-show="$ctrl.showRFSResponseXml">\r\n\t\t<div class="row">\r\n\t\t\t<div class="col-xs-12 col-xs-flush response-xml">\r\n\t\t\t\t<div class="col-xs-12">\r\n\t\t\t\t\t<span class="pull-left header">Response XML</span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showRFSResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<pre ng-bind="$ctrl.details.ResponseRFS.TransmitStatus.ResponseXml" />\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\r\n\t<div ng-show="!$ctrl.loading && !$ctrl.$scope.httpError && !$ctrl.details">\r\n\t\t<div class="col-xs-12">\r\n\t\t\t<uib-alert type="success" translate>\r\n\t\t\t\tNo formulary details were found.\r\n\t\t\t</uib-alert>\r\n\t\t</div>\r\n\t</div>\r\n\t\r\n\t<div ng-show="$ctrl.$scope.httpError">\r\n\t\t<div class="col-xs-12">\r\n\t\t\t<uib-alert type="danger" translate>\r\n\t\t\t\tThere was a communication issue with the server.  Please contact support.\r\n\t\t\t</uib-alert>\r\n\t\t</div>\r\n\t</div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/sigwriterTabletShell.html",'<form name="$ctrl.tabletShellForm" class="desktop-form" id="sigwriter-tablet-shell" ng-if="!$ctrl.resetting">\r\n    <div class="sigwriter-tablet-grid">\r\n        <div class="row sigwriter-tablet-content-row" ng-class="(!$ctrl.displayPdr) ? \'expanded\' : \'\'">\r\n            <div id="sigwriter-content-column" class="sigwriter-tablet-content-column" ng-class="$ctrl.getContentColumnClass()">\r\n                <div class="sigwriter-tablet-content">\r\n                    <sigwriter-tablet-directions\r\n                        form="$ctrl.tabletShellForm"\r\n                        patient-details="$ctrl.patientDetails"\r\n                        rx-options="$ctrl.rxOptions"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        sig-formulary="$ctrl.currentRx.sigFormulary"\r\n                        sig-instruction="$ctrl.currentInstruction"\r\n                        sig-options="$ctrl.currentRx.options"\r\n                        sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                        set-drug-from-search-result="$ctrl.setDrugFromSearchResult(selectedDrug)"\r\n                        update-sig-instruction="$ctrl.updateSigInstruction(updatedSigInstruction)"\r\n                        update-sig-options="$ctrl.updateSigOptions(updatedSigOptions)"\r\n                        update-sig-options-non-formulary="$ctrl.updateSigOptionsNonFormulary(updatedSigOptionsNonFormulary)"\r\n                    />\r\n                </div>\r\n            </div>\r\n            <div class="sigwriter-tablet-info-column" ng-class="$ctrl.getInfoColumnClass()">\r\n                <div class="sigwriter-tablet-additional-info sigwriter-tablet-tile">\r\n                    <div class="sigwriter-tablet-additional-info-content sigwriter-tablet-tile-content">\r\n                        <sigwriter-tablet-additional-info\r\n                            sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                            show-additional-info-modal="$ctrl.showAdditionalInfoModal()"\r\n                        />\r\n                    </div>\r\n                </div>\r\n                <div class="sigwriter-tablet-drug-screening sigwriter-tablet-tile" ng-if="!$ctrl.disableDrugScreening">\r\n                    <div class="sigwriter-tablet-drug-screening-content sigwriter-tablet-tile-content">\r\n                        <sigwriter-tablet-drug-screening\r\n                            drug-screening="$ctrl.currentRx.drugScreening"\r\n                            rx-parameters="$ctrl.rxParameters"\r\n                            show-detailed-screening-modal="$ctrl.showDetailedScreeningModal()"\r\n                            update-drug-screening="$ctrl.updateDrugScreening(drugScreening)"\r\n                            update-is-screening-loaded="$ctrl.updateIsScreeningLoaded(isLoaded, isOverrideRequired)"\r\n                        />\r\n                    </div>\r\n                </div>\r\n                <div class="sigwriter-tablet-formulary sigwriter-tablet-tile" ng-if="!$ctrl.disableFormulary">\r\n                    <div class="sigwriter-tablet-formulary-content sigwriter-tablet-tile-content">\r\n                        <sigwriter-tablet-formulary-alternatives\r\n                            rel-visit-medication-id="$ctrl.currentRx.relVisitMedicationId"\r\n                            rx-parameters="$ctrl.rxParameters"\r\n                            sig-formulary="$ctrl.currentRx.sigFormulary"\r\n                            sig-instruction="$ctrl.currentInstruction"\r\n                            sig-options="$ctrl.currentRx.options"\r\n                            sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                            on-drug-selected="$ctrl.setNewDrug(drug, pharmacy)"\r\n                            update-rel-visit-medication-id="$ctrl.updateRelVisitMedicationId(relVisitMedicationId)"\r\n                            update-sig-formulary="$ctrl.updateSigFormulary(sigFormulary)"\r\n                            update-sig-options="$ctrl.updateSigOptions(sigOptions)"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="row sigwriter-tablet-pdr-row" ng-show="$ctrl.displayPdr">\r\n            <div class="col-xs-12">\r\n                <div class="sigwriter-tablet-pdr">\r\n                    <sigwriter-tablet-pdr\r\n                        drug="$ctrl.rxParameters.drug"\r\n                        patient-id="$ctrl.rxParameters.patientId"\r\n                        rx-id="$ctrl.rxParameters.rxId"\r\n                        sig-type="$ctrl.rxParameters.sigType"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="row sigwriter-tablet-buttons-row">\r\n            <div class="col-xs-12 sigwriter-tablet-buttons-column">\r\n                <div class="sigwriter-tablet-buttons">\r\n                    <div class="sigwriter-tablet-left-buttons">\r\n                        <button type="button" class="btn btn-primary pull-left" ng-click="$ctrl.saveDefaultSig()"><span ng-hide="$ctrl.saveDefaultSigLoading">{{::\'Save Default SIG\' | translate}}</span><ap-spinner class="save-default-sig" ng-show="$ctrl.saveDefaultSigLoading"></ap-spinner></button>\r\n                        <button type="button" class="btn btn-default btn-pdr" ng-click="$ctrl.togglePdr()"><i class="ap-pdr" title="Toggle PDR"></i><i ng-class="($ctrl.displayPdr) ? \'ap-chevron-down-gray\' : \'ap-chevron-up-gray\'"></i></button>\r\n                    </div>\r\n                    <div class="sigwriter-tablet-right-buttons pull-right" ng-class="$ctrl.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n                        <button type="button" class="btn btn-primary" ng-click="$ctrl.cancel()">{{::\'Cancel\' | translate}}</button>\r\n                        <button type="submit" class="btn btn-primary" ng-hide="$ctrl.defaultSigContext" ng-click="$ctrl.save()">{{::\'Save\' | translate}}</button>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</form>'),$templateCache.put("/sigwriter/component-views/sigwriterWizardShell.html",'<wizard name="{{$ctrl.wizardName}}" hide-indicators="true" on-finish="$ctrl.onFinish()">\r\n    <div class="modal-header modal-header-slim">\r\n        <ul class="ap-steps-indicator steps-{{$ctrl.getWizard().getEnabledSteps().length}}">\r\n            <li ng-repeat="step in $ctrl.getWizard().getEnabledSteps()">\r\n                <i ng-class="$ctrl.getStepIconClass(step)"\r\n                   id="{{$ctrl.getStepIconId(step)}}"\r\n                   ng-click="$ctrl.goToStep(step, $index + 1)">\r\n                </i>\r\n            </li>\r\n        </ul>\r\n    </div>\r\n    <div id=\'wizard-shell-body\' class="modal-body">\r\n        <wz-step wz-title="{{$ctrl.titles.sigInstructions}}" canexit="$ctrl.canAdvanceFromCurrentStep()">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.sigInstructions)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-sig-instructions\r\n                        disable-dates="$ctrl.disableSigDates"\r\n                        enable-medication-type-selection="$ctrl.enableMedicationTypeSelection"\r\n                        rx-options="$ctrl.rxOptions"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        sig-instruction="$ctrl.currentInstruction"\r\n                        sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                        apply-dosing-suggestion="$ctrl.applyDosingSuggestion(suggestion, instructionId)"\r\n                        register-form-submit-callback="$ctrl.registerFormSubmitCallback($ctrl.titles.sigInstructions, callbackFn)"\r\n                        update-is-valid="$ctrl.updateIsSigInstructionsValid(isValid)"\r\n                        update-sig-instruction="$ctrl.updateSigInstruction(sigInstruction)"\r\n                        update-sig-options-non-formulary="$ctrl.updateSigOptionsNonFormulary(sigOptionsNonFormulary)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.formularyAlternatives}}" wz-disabled="{{$ctrl.skipFormularyAlternatives}}">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.formularyAlternatives)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-formulary-alternatives-content\r\n                        is-active-step="$ctrl.getCurrentStepTitle() === $ctrl.titles.formularyAlternatives"\r\n                        rel-visit-medication-id="$ctrl.currentRx.relVisitMedicationId"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        sig-formulary="$ctrl.currentRx.sigFormulary"\r\n                        sig-instruction="$ctrl.currentInstruction"\r\n                        sig-options="$ctrl.currentRx.options"\r\n                        sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                        skip-formulary-alternatives="$ctrl.skipFormularyAlternatives"\r\n                        on-drug-selected="$ctrl.setNewDrug(drug, pharmacy)"\r\n                        update-is-available="$ctrl.updateIsFormularyAlternativesAvailable(isAvailable)"\r\n                        update-rel-visit-medication-id="$ctrl.updateRelVisitMedicationId(relVisitMedicationId)"\r\n                        update-sig-formulary="$ctrl.updateSigFormulary(sigFormulary)"\r\n                        update-sig-options="$ctrl.updateSigOptions(sigOptions)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.drugScreening}}">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.drugScreening)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-screening-content\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        update-drug-screening="$ctrl.updateDrugScreening(drugScreening)"\r\n                        update-is-screening-loaded="$ctrl.updateIsScreeningLoaded(isLoaded, isOverrideRequired, status)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.screeningOverride}}" wz-disabled="{{!$ctrl.isOverrideRequired}}">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.screeningOverride)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-screening-override\r\n                        drug-screening="$ctrl.currentRx.drugScreening"\r\n                        update-drug-screening="$ctrl.updateDrugScreening(drugScreening)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.sigOptions}}" canexit="$ctrl.canAdvanceFromCurrentStep()">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.sigOptions)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-sig-options\r\n                        rx-options="$ctrl.rxOptions"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        sig-options="$ctrl.currentRx.options"\r\n                        sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                        register-form-submit-callback="$ctrl.registerFormSubmitCallback($ctrl.titles.sigOptions, callbackFn)"\r\n                        update-is-valid="$ctrl.updateIsSigOptionsValid(isValid)"\r\n                        update-sig-options="$ctrl.updateSigOptions(sigOptions)"\r\n                        update-sig-options-non-formulary="$ctrl.updateSigOptionsNonFormulary(sigOptionsNonFormulary)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.summary}}" canexit="$ctrl.canAdvanceFromCurrentStep()">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.summary)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-review\r\n                        current-rx="$ctrl.currentRxClone"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        register-form-submit-callback="$ctrl.registerFormSubmitCallback($ctrl.titles.summary, callbackFn)"\r\n                        update-epcs-signature="$ctrl.updateEpcsSignature(epcsSignature)"\r\n                        update-is-valid="$ctrl.updateIsSummaryValid(isValid)"\r\n                        update-sig-options="$ctrl.updateSigOptions(sigOptions)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n    </div>\r\n    <div class="modal-footer modal-footer-slim">\r\n        <div class="row">\r\n            <div class="col-xs-6">\r\n                <button id="previous-btn" type="submit" ng-hide="($ctrl.getWizard().currentStepNumber() === 1)" class="btn-modal btn-default" wz-previous>Back</button>\r\n            </div>\r\n            <div class="col-xs-6">\r\n                <button id="next-btn" type="submit" ng-hide="($ctrl.getWizard().currentStepNumber() === $ctrl.getWizard().getEnabledSteps().length)" class="btn-modal btn-default" wz-next="$ctrl.onNext()">Next</button>\r\n                <button id="finish-btn" type="submit" ng-show="($ctrl.getWizard().currentStepNumber() === $ctrl.getWizard().getEnabledSteps().length)" class="btn-modal btn-default" wz-finish>Finish</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</wizard>'),$templateCache.put("/sigwriter/component-views/tabletAdditionalInfo.html",'<div id="drug-tablet-additional-info-sidebar"></div>\r\n<div id="drug-tablet-additional-info-display">\r\n    <div>\r\n        <h4 class="additional-info-color"><b>{{$ctrl.getTitle()}}</b></h4>\r\n    </div>\r\n    <div class="show-details-container" ng-click="$ctrl.showDetails()">\r\n        <i class="clickable ap-expand-more"></i>\r\n    </div>\r\n    <div>\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n            <span class="additional-info-color" translate>Site:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.medicationSite.Name }}</span>\r\n        </div>\r\n        <div>\r\n            <span class="additional-info-color" translate>Lot #:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.lotNumber }}</span>\r\n        </div>\r\n        <div>\r\n            <span class="additional-info-color" translate>Manufacturer:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.manufacturer.Name }}</span>\r\n        </div>\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n            <span class="additional-info-color" translate>Funding Source:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.fundingSource.Name }}</span>\r\n        </div>\r\n        <div>\r\n            <span class="additional-info-color" translate>Expiration:</span>\r\n            <span><ap-date-formatter date="{{ $ctrl.sigOptionsNonFormulary.expirationDate }}" format="date"></ap-date-formatter></span>\r\n        </div>\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n            <span class="additional-info-color" translate>Initials:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.initials }}</span>\r\n        </div>\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n            <span class="additional-info-color" translate>Administered Date:</span>\r\n            <span><ap-date-formatter date="{{ $ctrl.sigOptionsNonFormulary.administeredDateTime }}" format="date-time"></ap-date-formatter></span>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/tabletDirections.html",'<form id="drug-tablet-directions">\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="directions-header">\r\n                <a ng-if="$ctrl.allowSearchDrugDosage"\r\n                   class="clickable"\r\n                   ng-click="$ctrl.onClickSearchDrugDosage()"\r\n                   id="td-search-drug-dosage">\r\n                    {{$ctrl.rxParameters.drug.Description}}\r\n                </a>\r\n                <span ng-if="!$ctrl.allowSearchDrugDosage">\r\n                    {{$ctrl.rxParameters.drug.Description}}\r\n                </span>\r\n                <i class="ap-dosing-suggestions-black clickable"\r\n                    ng-click="$ctrl.onClickDosingSuggestions()"\r\n                    id="td-dosing-suggestions">\r\n                </i>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row">\r\n        <div class="col-xs-12" ng-if="$ctrl.warnings">\r\n            <div ng-repeat="(key, value) in $ctrl.warnings" ng-if="value">\r\n                <uib-alert type="warning" close="$ctrl.removeWarning(value, key)">{{value}}</uib-alert>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row" id="drug-tablet-directions-content">\r\n        <div class="col-xs-6">\r\n            <fieldset ap-fieldset-invalid="!$ctrl.isDirectionsValid()">\r\n                <legend>Directions ({{$ctrl.getRemainingSigCharacters()}} of 140)</legend>\r\n                <div class="rx-instructions-menu-text flexbox flexbox-horizontal-center flexbox-horizontal-wrap">\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.startText">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.startText"\r\n                             id="td-start-text">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div>\r\n                        <div class="text-token instructions-dosage"\r\n                             ng-class="$ctrl.updatedSigInstruction.dosage.Name ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editDosage()"\r\n                             id="td-edit-dosage">\r\n                            <span ng-if="$ctrl.updatedSigInstruction.dosage.Name && !$ctrl.updatedSigInstruction.dosage.isNull">\r\n                                {{$ctrl.updatedSigInstruction.dosage.Name}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.dosage || $ctrl.updatedSigInstruction.dosage.isNull || $ctrl.updatedSigInstruction.dosage.Name === 0" class="rx-instruction-placeholder">\r\n                                {{::\'Dosage\' | translate}}\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.postDosage">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.postDosage"\r\n                             id="td-post-dosage">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div>\r\n                        <div class="text-token instructions-unit"\r\n                             ng-class="$ctrl.updatedSigInstruction.unit.Name ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editUnit()"\r\n                             id="td-edit-unit">\r\n                            <span ng-if="$ctrl.updatedSigInstruction.unit.Name && !$ctrl.updatedSigInstruction.unit.isNull">\r\n                                {{$ctrl.updatedSigInstruction.unit.Name || (\'Unit\' | translate)}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.unit || $ctrl.updatedSigInstruction.unit.isNull" class="rx-instruction-placeholder">\r\n                                {{::\'Unit\' | translate}}\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.postUnit">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.postUnit"\r\n                             id="td-post-unit">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div>\r\n                        <div class="text-token instructions-route"\r\n                             ng-class="($ctrl.updatedSigInstruction.route | medCommonLanguage) ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editRoute()"\r\n                             id="td-edit-route">\r\n                            {{$ctrl.updatedSigInstruction.route | medCommonLanguage:false:\'Route\'}}\r\n                        </div>\r\n                    </div>\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.postRoute">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.postRoute"\r\n                             id="td-post-route">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div>\r\n                        <div class="text-token instructions-frequency"\r\n                             ng-class="($ctrl.updatedSigInstruction.frequency | medCommonLanguage) ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editFrequency()"\r\n                             id="td-edit-frequency">\r\n                            {{$ctrl.updatedSigInstruction.frequency | medCommonLanguage:false:\'Frequency\'}}\r\n                        </div>\r\n                    </div>\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.postFrequency">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.postFrequency"\r\n                             id="td-post-frequency">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                        <div class="text-token instructions-prn-reason"\r\n                             ng-class="$ctrl.updatedSigInstruction.prnReason.Name ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editPrn()"\r\n                             id="td-edit-prn">\r\n                            <span ng-if="$ctrl.updatedSigInstruction.prnReason.Name && !$ctrl.updatedSigInstruction.prnReason.isNull">{{\'as needed\' | translate}}</span>\r\n                            <span ng-if="$ctrl.updatedSigInstruction.prnReason.Name && !$ctrl.updatedSigInstruction.prnReason.isNull">\r\n                                {{$ctrl.updatedSigInstruction.prnReason.Name || (\'PRN\' | translate)}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.prnReason || $ctrl.updatedSigInstruction.prnReason.isNull" class="rx-instruction-placeholder">\r\n                                {{::\'PRN\' | translate}}\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                    <div contenteditable \r\n                         class="text-token"\r\n                         data-placeholder="Instructions"\r\n                         ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                         ng-model="$ctrl.updatedSigInstruction.endText"\r\n                         id="td-end-text">\r\n                    </div>\r\n                </div>\r\n                <div class="rx-instructions-menu-text flexbox flexbox-horizontal-center flexbox-horizontal-wrap">\r\n                    <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                        <div class="text-token instructions-days"\r\n                             ng-class="$ctrl.updatedSigInstruction.days ? \'\' : \'placeholder\'"\r\n                             ap-field-invalid="!$ctrl.isDaysValid()"\r\n                             ng-click="$ctrl.editDays()"\r\n                             id="td-edit-days">\r\n                            <span ng-if="$ctrl.updatedSigInstruction.days.Name && !$ctrl.updatedSigInstruction.days.isNull">\r\n                                {{$ctrl.updatedSigInstruction.days.Name}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.days || $ctrl.updatedSigInstruction.days.isNull || $ctrl.updatedSigInstruction.days.Name === 0" class="rx-instruction-placeholder">\r\n                                {{::\'Day(s)\' | translate}}\r\n                            </span>\r\n                            <span ng-if="$ctrl.updatedSigInstruction.days.Name && !$ctrl.updatedSigInstruction.days.isNull">{{\'day(s)\' | translate}}</span>\r\n                        </div>\r\n                    </div>\r\n                    <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                        <div class="text-token instructions-refills"\r\n                             ng-class="$ctrl.updatedSigInstruction.refills ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editRefills()"\r\n                             id="td-edit-refills">\r\n                            <span ng-if="($ctrl.updatedSigInstruction.refills.Name || $ctrl.updatedSigInstruction.refills.Name === 0) && !$ctrl.updatedSigInstruction.refills.isNull">\r\n                                {{$ctrl.updatedSigInstruction.refills.Name}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.refills || $ctrl.updatedSigInstruction.refills.isNull" class="rx-instruction-placeholder">\r\n                                {{::\'Refill(s)\' | translate}}\r\n                            </span>\r\n                            <span ng-if="($ctrl.updatedSigInstruction.refills.Name || $ctrl.updatedSigInstruction.refills.Name === 0) && !$ctrl.updatedSigInstruction.refills.isNull">{{\'refill(s)\' | translate}}</span>\r\n                        </div>\r\n                    </div>\r\n                    <div class="tablet-directions-repeat-sig flexbox flexbox-horizontal-center flexbox-horizontal-wrap"\r\n                         ng-show="$ctrl.shouldDisplayRepeatSig()">\r\n                        <div id="repeat-sig-button" class="clickable" title="Repeat SIG">\r\n                            <i class="ap-plus-blue"\r\n                               ng-click="$ctrl.onClickRepeatSig()"\r\n                               id="td-repeat-sig"\r\n                            ></i>\r\n                        </div>\r\n                        <span ng-if="$ctrl.updatedSigInstruction.repeatSigCount === 1">&nbsp;{{::\'Repeat Once\' | translate}}</span>\r\n                        <span ng-if="$ctrl.updatedSigInstruction.repeatSigCount === 2">&nbsp;{{::\'Repeat Twice\' | translate}}</span>\r\n                    </div>\r\n                </div>\r\n                <div class="rx-instructions-menu-text flexbox flexbox-horizontal-center flexbox-horizontal-wrap">\r\n                    <div class="input-group tablet-directions-quantity">\r\n                        <input type="number" class="form-control"\r\n                               name="quantity"\r\n                               min="0.00001"\r\n                               max="99999"\r\n                               step="any"\r\n                               ap-field-invalid="!$ctrl.isQuantityValid()"\r\n                               ap-required="false"\r\n                               ng-disabled="$ctrl.sigInstruction.disallowChangingQuantity || !$ctrl.sigInstruction.isManualQuantity"\r\n                               ng-model="$ctrl.updatedSigInstruction.quantity"\r\n                               ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                        </input>\r\n                        <span class="input-group-btn" id="toggle-quantity-btn-group" ng-if="!$ctrl.sigInstruction.disallowChangingQuantity">\r\n                            <button class="btn btn-default"\r\n                                    ng-if="!$ctrl.updatedSigInstruction.isManualQuantity"\r\n                                    ng-click="$ctrl.toggleQuantityType()"\r\n                                    ng-disabled="$ctrl.updatedSigInstruction.disallowAutoQuantity"\r\n                                    id="auto-quantity-btn">\r\n                                {{::\'Auto\' | translate}}\r\n                            </button>\r\n                            <button class="btn btn-default"\r\n                                    ng-if="$ctrl.updatedSigInstruction.isManualQuantity"\r\n                                    ng-click="$ctrl.toggleQuantityType()"\r\n                                    ng-disabled="$ctrl.updatedSigInstruction.disallowAutoQuantity"\r\n                                    id="manual-quantity-btn">\r\n                                {{::\'Manual\' | translate}}\r\n                            </button>\r\n                        </span>\r\n                    </div>\r\n                    <div class="form-group tablet-directions-unit-of-measure">\r\n                        \x3c!--<label for="unitOfMeasure">{{::\'Unit of Measure\' | translate}}</label>--\x3e\r\n                        <ap-select>\r\n                            <select class="form-control" id="unitOfMeasure"\r\n                                    ap-required="true"\r\n                                    ng-model="$ctrl.updatedSigOptions.uom"\r\n                                    ng-options="uom.Name for uom in $ctrl.rxOptions.lists.unitsOfMeasure track by uom.Id"\r\n                                    ng-change="$ctrl.onUpdatedSigOptionsChanged()" />\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n            </fieldset>\r\n            <div class="row" ng-show="$ctrl.shouldDisplayStartEndDates()">\r\n                <div class="col-xs-6">\r\n                    <div class="form-group">\r\n                        <label for="startDate">{{::\'Start Date\' | translate}}</label>\r\n                        <input type="date"\r\n                               class="form-control"\r\n                               id="startDate"\r\n                               name="startDate"\r\n                               min="1900-01-01"\r\n                               max="9998-12-31"\r\n                               ap-required="$ctrl.isStartDateRequired()"\r\n                               ng-model="$ctrl.updatedSigInstruction.startDate"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ng-change="$ctrl.onUpdatedSigInstructionChanged();">\r\n                        </input>\r\n                    </div>\r\n                </div>\r\n                <div class="col-xs-6">\r\n                    <div class="form-group">\r\n                        <label for="endDate">{{::\'End Date\' | translate}}</label>\r\n                        <input type="date"\r\n                               class="form-control"\r\n                               id="endDate"\r\n                               name="endDate"\r\n                               min="{{$ctrl.updatedSigInstruction.startDate}}"\r\n                               max="9998-12-31"\r\n                               ap-required="$ctrl.isEndDateRequired()"\r\n                               ng-model="$ctrl.updatedSigInstruction.endDate"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ng-change="$ctrl.onEndDateChanged()">\r\n                        </input>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="form-group">\r\n                <label for="category">{{::\'Category\' | translate}}</label>\r\n                <ap-select>\r\n                    <select class="form-control" id="category"\r\n                            ng-model="$ctrl.updatedSigOptionsNonFormulary.category"\r\n                            ng-options="category.Name for category in $ctrl.rxOptions.lists.medicationCategories track by category.Id"\r\n                            ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()" />\r\n                </ap-select>\r\n            </div>\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplayPrescriber()">\r\n                <label for="prescriber">{{::\'Prescriber\' | translate}}</label>\r\n                <ap-select>\r\n                        <select id="prescriber" name="prescriber"\r\n                                class="form-control"\r\n                                data-ng-model="$ctrl.updatedSigOptionsNonFormulary.prescriber"\r\n                                data-ng-options="provider.Description for provider in $ctrl.rxOptions.authorizedPrescribers track by provider.Id"\r\n                                ng-change="$ctrl.onChangePrescriber()"\r\n                                ng-disabled="$ctrl.shouldDisablePrescriber()"\r\n                                ap-required="$ctrl.isPrescriberRequired()">\r\n                        </select>\r\n                </ap-select>            \r\n            </div>\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplaySupervisingProvider()">\r\n                <label for="supervisingProvider">{{::\'Supervising Provider\' | translate}}</label>\r\n                <input type="text" class="form-control" id="supervisingProvider" ng-model="$ctrl.supervisingProviderText" readonly>\r\n            </div>\r\n        </div>\r\n        <div class="col-xs-6">\r\n            <div class="directions-separator directions-separator-right" ap-vertical-separator="drug-tablet-directions-content"></div>\r\n            <div class="row" id="checkboxesAndButtons">\r\n                <div ng-class="$ctrl.getCheckboxesColumnClass()">\r\n                    <div>\r\n                        <div class="checkbox checkbox-native">\r\n                            <input type="checkbox"\r\n                                   class="native"\r\n                                   id="daw"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.daw"\r\n                                   ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()">\r\n                            <label class="lg-touch" for="daw">{{::\'Dispense as Written\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                    <div>\r\n                        <div class="checkbox checkbox-native">\r\n                            <input type="checkbox"\r\n                                   class="native"\r\n                                   id="chronicMed"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.isChronicMed"\r\n                                   ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()">\r\n                            <label class="lg-touch" for="chronicMed">{{::\'Chronic Medication\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplayIncludeMonograph()">\r\n                        <div class="checkbox checkbox-native">\r\n                            <input type="checkbox"\r\n                                   class="native"\r\n                                   id="includeMonograph"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.includeMonograph"\r\n                                   ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()">\r\n                            <label class="lg-touch" for="includeMonograph">{{::\'Include Monograph\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplayMode()">\r\n                        <div class="checkbox checkbox-native">\r\n                            <input type="checkbox"\r\n                                   class="native"\r\n                                   id="administered"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.isAdministered"\r\n                                   ng-change="$ctrl.onIsAdministeredChanged()">\r\n                            <label class="lg-touch" for="administered">{{::\'Administered\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplayMode()">\r\n                        <div class="checkbox checkbox-native">\r\n                            <input type="checkbox"\r\n                                   class="native"\r\n                                   id="sampleGiven"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.isSampleGiven"\r\n                                   ng-change="$ctrl.onSampleGivenChanged()">\r\n                            <label class="lg-touch" for="sampleGiven">{{::\'Sample Given\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <div ng-class="$ctrl.getButtonsColumnClass()">\r\n                    <div class="directions-separator directions-separator-right" ap-vertical-separator="checkboxesAndButtons"></div>\r\n                    <div ng-show="$ctrl.shouldDisplayEpaButton()">\r\n                        <img class="tablet-directions-epa-button"\r\n                             id="toggle-epa-btn"\r\n                             ng-class="$ctrl.updatedSigOptionsNonFormulary.sendPriorAuth ? \'ap-ePA-selected\' : \'ap-ePA-unselected\'"\r\n                             ng-click="$ctrl.toggleEpaButton()"/>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplaySpecialtyButton()">\r\n                        <img class="tablet-directions-specialty-button"\r\n                             id="toggle-spo-btn"\r\n                             ng-class="$ctrl.updatedSigOptionsNonFormulary.sendIsSpecialty ? \'ap-spo-selected\' : \'ap-spo-unselected\'"\r\n                             ng-click="$ctrl.toggleSpoButton()"/>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplayConsent()">\r\n                        <img class="tablet-directions-rx-consent-button"\r\n                             ng-click="$ctrl.onOpenDrugConsent()" \r\n                             ng-class="$ctrl.updatedSigOptionsNonFormulary.MedicationConsent ? \'ap-rx-consent-green\' : \'ap-rx-consent-unselected\'"\r\n                             id="td-drug-consent">\r\n                        </img>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplayDxProblems()">\r\n                <label for="dxProblems">{{::\'DX &amp; Problems\' | translate}}</label>\r\n                <sigwriter-dx-problems\r\n                    id="dxProblems"\r\n                    data-patient-id="$ctrl.rxParameters.patientId"\r\n                    ng-model="$ctrl.updatedSigOptionsNonFormulary.problems"\r\n                    ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()">\r\n                </sigwriter-dx-problems>\r\n            </div>\r\n            <div class="form-group" ng-if="$ctrl.shouldDisplayPharmacy()">\r\n                <label for="PharmacyId">{{::\'Pharmacy\' | translate}}</label>\r\n                <ap-find-pharmacy\r\n                        id="PharmacyId"\r\n                        name="PharmacyId"\r\n                        select-disabled="$ctrl.isFixedPharmacy()"\r\n                        ng-model="$ctrl.updatedSigOptions.pharmacy"\r\n                        ng-change="$ctrl.onUpdatedSigOptionsChanged()"\r\n                        data-patient-id="$ctrl.rxParameters.patientId"\r\n                        parent-container-id="$ctrl.parentContainerId"\r\n                        default-list="true">\r\n                </ap-find-pharmacy>\r\n            </div>\r\n            <div class="form-group" ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered || $ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n                <label for="pharmacyInstructions">\r\n                    <a class="clickable underline" ng-click="$ctrl.onClickPharmacyInstructions()" id="td-pharmacy-instructions-link">\r\n                        {{::\'Pharmacy Instructions\' | translate}}\r\n                    </a>\r\n                    <span class="char-count">\r\n                        &nbsp;({{$ctrl.getRemainingPharmacyInstructionsCharacters()}} {{::\'of\' | translate}} {{::$ctrl.maxPharmacyInstructionsCharacters}})\r\n                    </span>\r\n                </label>\r\n                <input type="text" \r\n                       ng-model="$ctrl.updatedSigOptionsNonFormulary.pharmacyInstructions"\r\n                       ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()"\r\n                       maxlength="{{$ctrl.maxPharmacyInstructionsCharacters}}"\r\n                       class="form-control" \r\n                       id="pharmacyInstructions">\r\n            </div>\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplayCptCode()">\r\n                <label for="cpt">CPT<i class="ap-important-sm" ng-show="$ctrl.cptList && $ctrl.cptList.length > 0"></i>\r\n                </label>\r\n                <ap-select>\r\n                        <select class="form-control" id="cpt"\r\n                                ng-disabled="!$ctrl.cptList || $ctrl.cptList < 1"\r\n                                ng-model="$ctrl.updatedSigOptionsNonFormulary.procedure"\r\n                                ng-options="cpt as \'(\' + cpt.Code + \')\' + cpt.ShortDescription for cpt in $ctrl.cptList"\r\n                                ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()" />\r\n                </ap-select>\r\n            </div>\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplayAuthorizationCode()">\r\n                <label for="authorization">{{::\'Authorization\' | translate}}</label>\r\n                <input type="text" class="form-control" id="authorization"\r\n                    ng-model="$ctrl.updatedSigOptionsNonFormulary.authorCode"\r\n                    ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()"\r\n                    ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.AuthorCode"\r\n                    maxlength="{{$ctrl.rxOptions.metadata.sig.Fields.AuthorCode.MaxLength}}"/>\r\n            </div>\r\n            <div class="form-group">\r\n                <label for="internalNote">\r\n                    <a class="clickable underline" ng-click="$ctrl.onClickInternalNote()" id="td-internal-note-link">\r\n                        {{\'Internal Note\' | translate}}\r\n                    </a>\r\n                    <span class="char-count">\r\n                        &nbsp;({{$ctrl.getRemainingInternalNoteCharacters()}} {{::\'of\' | translate}} {{::$ctrl.maxInternalNoteCharacters}})\r\n                    </span>\r\n                </label>\r\n                <input type="text"\r\n                        id="internalNote"\r\n                        class="form-control"\r\n                        ng-model="$ctrl.updatedSigOptionsNonFormulary.internalNote"\r\n                        ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()"\r\n                        maxlength="{{$ctrl.maxInternalNoteCharacters}}">\r\n            </div>\r\n        </div>\r\n    </div>\r\n</form>'),$templateCache.put("/sigwriter/component-views/tabletDrugDosageSearch.html",'<div id="drug-search" class="panel panel-default panel-flush">\r\n    <div class="row" ng-if="$ctrl.loadError">\r\n        <div class="col-xs-12 col-xs-flush">\r\n            <uib-alert type="danger">\r\n                {{"An error has occurred and drugs could not be loaded." | translate}}\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="drug-search-list-content">\r\n        <drug-search-list\r\n            drugs="$ctrl.drugs"\r\n            hide-drug-information-icon="true"\r\n            loading="$ctrl.loading"\r\n            patient-id="$ctrl.patientId"\r\n            session-id="$ctrl.sessionId"\r\n            use-enhanced-drug-search="$ctrl.useEnhancedDrugSearch"\r\n            on-drug-search-result-selected="$ctrl.selectDrugSearchResult(drugSearchResult, switchToGeneric, dosingSuggestion)"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/tabletDrugScreening.html",'<div id="drug-tablet-screening-sidebar" ng-class="$ctrl.getSidebarClass()"></div>\r\n<div id="drug-tablet-screening-display">\r\n    <div>\r\n        <h4><b>{{::\'Drug Screening\' | translate}}</b></h4>\r\n    </div>\r\n    <div class="show-details-container" ng-if="!$ctrl.loading && !$ctrl.nddScreeningError" ng-click="$ctrl.showDetails()">\r\n        <i class="clickable ap-expand-more"></i>\r\n    </div>\r\n    <ndd-condensed-drug-screening\r\n        error="$ctrl.nddScreeningError"\r\n        loading="$ctrl.loading"\r\n        screening="$ctrl.nddScreening"\r\n    />\r\n</div>'),$templateCache.put("/sigwriter/component-views/tabletDrugSearch.html",'<sigwriter-drug-search\r\n    initial-search-text="$ctrl.initialSearchText"\r\n    patient-id="$ctrl.patientId"\r\n    use-previous-search-text="$ctrl.usePreviousSearchText"\r\n    on-drug-search-result-selected="$ctrl.onDrugSearchResultSelected(drugSearchResult, switchToGeneric, dosingSuggestion, useEnhancedDrugSearch)"\r\n/>\r\n'),$templateCache.put("/sigwriter/component-views/tabletFormularyAlternatives.html",'<div id="drug-tablet-formulary-sidebar" ng-class="$ctrl.isAnimating(\'drug-tablet-formulary-sidebar\') ? \'\' : $ctrl.downloadStatusClass()"></div>\r\n<div id="drug-tablet-formulary-display">\r\n    <div id="drug-tablet-formulary-banner">\r\n        <div>\r\n            <h4><b>{{::\'Formulary\' | translate}}</b></h4>\r\n        </div>\r\n        <div ng-if="$ctrl.eRxEligibilities && $ctrl.eRxEligibilities.length > 0">\r\n            <div class="show-details-container" ng-click="$ctrl.openFormularyDetailsModal(null)" ng-show="$ctrl.eRxEligibility">\r\n                <i class="clickable ap-expand-more"></i>\r\n            </div>\r\n        </div>\r\n        <div class="row" ng-if="$ctrl.eRxEligibility">\r\n            <div class="col-xs-12" >\r\n                <label for="DownloadedDate" \r\n                    ng-click="$ctrl.openRxBenefitDetailsModal()"\r\n                    ng-class="{\'rx-formulary-download-date-expired\': ($ctrl.eRxEligibility && $ctrl.eRxEligibility.IsExpired) }"><a class="clickable underline">Rx Benefits: {{$ctrl.formatEligibilityDate() }}</a></label>\r\n            </div>        \r\n        </div>\r\n        <div class="form-group row" ng-if="$ctrl.eRxEligibilities && $ctrl.eRxEligibilities.length > 0">\r\n            <div class="col-xs-12">\r\n                <ap-select>\r\n                    <select class="form-control"\r\n                            ng-model="$ctrl.eRxEligibility"\r\n                            ng-options="erxe as $ctrl.formatEligibilityName(erxe) for erxe in $ctrl.eRxEligibilities track by erxe.PatienteRxElgibilityUid"\r\n                            ng-change="$ctrl.onERxEligibilityChanged()">\r\n                    </select>\r\n                </ap-select>\r\n            </div>\r\n        </div>\r\n        <div ng-if="!$ctrl.eRxEligibilities.length && !$ctrl.loadingERxEligibilities">\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <span translate>\r\n                        There are no active coverages downloaded for this patient.\r\n                    </span>\r\n                </div>\r\n            </div>\r\n            <br>\r\n        </div>\r\n    </div>\r\n    <div id="drug-tablet-formulary-data" ng-if="$ctrl.eRxEligibility">\r\n        <sigwriter-formulary-display\r\n            details="$ctrl.details"\r\n            error="$ctrl.$scope.httpError"\r\n            is-info-available="$ctrl.isInfoAvailable"\r\n            loading="$ctrl.loading"\r\n            on-drug-selected="$ctrl.changeMedication(drug, pharmacy)"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/tabletPdr.html",'<div id="drug-documentation">\r\n    <div id="drug-documentation-loading" ng-show="$ctrl.loadingDrugDocumentation">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Loading Drug Documentation\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id="drug-documentation-content" ng-show="!$ctrl.loadingDrugDocumentation && !$ctrl.$scope.httpError">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <iframe ng-src="{{$ctrl.drugDocumentation.html}}"\r\n                        width="780px"\r\n                        height="112px">\r\n                </iframe>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row" ng-if="!!$ctrl.$scope.httpError">\r\n        <div ng-if="$ctrl.$scope.httpError.unhandled && $ctrl.drug && $ctrl.drug.MedId === 0">\r\n            <uib-alert type="warning">\r\n                {{::\'PDF documentation is not available for user defined medications.\' | translate}}\r\n            </uib-alert>\r\n        </div>\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.unhandled && !($ctrl.drug && $ctrl.drug.MedId === 0) && \r\n                !$ctrl.$scope.httpError.is400 && !$ctrl.$scope.httpError.is403">\r\n            <uib-alert type="danger">\r\n                {{::\'An error has occurred and the documentation could not be loaded.\' | translate}}\r\n            </uib-alert>\r\n        </div>\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.is400 && !($ctrl.drug && $ctrl.drug.MedId === 0)">\r\n            <uib-alert type="warning">\r\n                {{::\'No PDR BRIEF Information found.\' | translate}}\r\n            </uib-alert>\r\n        </div>        \r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.is403">\r\n            <uib-alert type="danger">\r\n                {{::\'You do not have access to the documentation.\' | translate}}\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/sigwriter/component-views/tabletSigDetails.html",'<div id="tablet-sig-details">\r\n    <table>\r\n        <thead>\r\n            <tr>\r\n                <th colspan="2">\r\n                    <span translate ng-if="!$ctrl.shouldDisplayDosingCalc()">Dosage</span>\r\n                    <a translate id="open-dosing-calc" class="clickable"\r\n                       ng-if="$ctrl.shouldDisplayDosingCalc()"\r\n                       ng-click="$ctrl.onClickDosingCalculator()">\r\n                       \r\n                       Dosage\r\n                    </a>\r\n                </th>\r\n                <th translate>Route</th>\r\n                <th translate>Frequency</th>\r\n                <th translate ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <div class="checkbox checkbox-native">\r\n                        <input type="checkbox"\r\n                               class="native"\r\n                               id="prn"\r\n                               ng-attr-autofocus="{{$ctrl.initialField === \'prn\' || undefined}}"\r\n                               ng-model="$ctrl.updatedSigInstruction.isPrn"\r\n                               ng-change="$ctrl.onIsPrnChanged()">\r\n                        <label for="prn">{{\'PRN\' | translate}}</label>\r\n                    </div>\r\n                </th>\r\n                <th translate ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">Days</th>\r\n                <th translate ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">Refill</th>\r\n            </tr>\r\n        </thead>\r\n        <tbody>\r\n            <tr class="input-row">\r\n                <td>\r\n                    <input type="text"\r\n                           id="tsd-manual-dosage"\r\n                           ng-attr-autofocus="{{$ctrl.initialField === \'dosage\' || undefined}}"\r\n                           ng-model="$ctrl.manualDosage"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onDosageTyped()">\r\n                </td>\r\n                <td>\r\n                    <input type="text" disabled\r\n                           ng-model="$ctrl.updatedSigInstruction.unit.Name"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                </td>\r\n                <td>\r\n                    <input type="text" disabled\r\n                           ng-value="$ctrl.updatedSigInstruction.route | medCommonLanguage:true">\r\n                </td>\r\n                <td>\r\n                    <input type="text" disabled\r\n                           ng-value="$ctrl.updatedSigInstruction.frequency | medCommonLanguage:true">\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <input type="text" disabled\r\n                           ng-model="$ctrl.updatedSigInstruction.prnReason.Name"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <input type="number"\r\n                           id="tsd-manual-days"\r\n                           ng-attr-autofocus="{{$ctrl.initialField === \'days\' || undefined}}"\r\n                           class="validated-control"\r\n                           min="0"\r\n                           max="999"\r\n                           ap-field-invalid="!$ctrl.isDaysValid()"\r\n                           ap-required="false"\r\n                           ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                           ng-model="$ctrl.manualDays"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onDaysTyped()">\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <input type="number"\r\n                           id="tsd-manual-refills"\r\n                           ng-attr-autofocus="{{$ctrl.initialField === \'refills\' || undefined}}"\r\n                           min="0"\r\n                           max="99"\r\n                           ap-required="false"\r\n                           ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                           ng-model="$ctrl.manualRefills"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onRefillsTyped()">\r\n                </td>\r\n            </tr>\r\n            <tr>\r\n                <td>\r\n                    <select size="2"\r\n                            id="tsd-dosage-options"\r\n                            ng-model="$ctrl.updatedSigInstruction.dosage"\r\n                            ng-options="option as option.Name for option in $ctrl.dosageOptions"\r\n                            ng-change="$ctrl.onDosageSelected()">\r\n                    </select>\r\n                </td>\r\n                <td>\r\n                    <select size="2"\r\n                            id="tsd-unit-options"\r\n                            ng-attr-autofocus="{{$ctrl.initialField === \'unit\' || undefined}}"\r\n                            ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                            ng-model="$ctrl.updatedSigInstruction.unit"\r\n                            ng-options="option as option.Name for option in $ctrl.unitOptions"\r\n                            ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                    </select>\r\n                </td>\r\n                <td>\r\n                    <select size="2"\r\n                            id="tsd-route-options"\r\n                            ng-attr-autofocus="{{$ctrl.initialField === \'route\' || undefined}}"\r\n                            ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                            ng-model="$ctrl.updatedSigInstruction.route"\r\n                            ng-options="option as (option | medCommonLanguage:true) for option in $ctrl.routeOptions"\r\n                            ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                    </select>\r\n                </td>\r\n                <td>\r\n                    <select size="2"\r\n                            id="tsd-frequency-options"\r\n                            ng-attr-autofocus="{{$ctrl.initialField === \'frequency\' || undefined}}"\r\n                            ng-model="$ctrl.updatedSigInstruction.frequency"\r\n                            ng-options="option as (option | medCommonLanguage:true) for option in $ctrl.frequencyOptions"\r\n                            ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                    </select>\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <select size="2"\r\n                            id="tsd-prn-reason-options"\r\n                            ng-disabled="!$ctrl.updatedSigInstruction.isPrn"\r\n                            ng-model="$ctrl.updatedSigInstruction.prnReason"\r\n                            ng-options="option as option.Name for option in $ctrl.prnReasons"\r\n                            ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                    </select>\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <select size="2"\r\n                            id="tsd-day-options"\r\n                            ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                            ng-model="$ctrl.updatedSigInstruction.days"\r\n                            ng-options="option as option.Name for option in $ctrl.dayOptions"\r\n                            ng-change="$ctrl.onDaysSelected()">\r\n                    </select>\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <select size="2"\r\n                            id="tsd-refill-options"\r\n                            ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                            ng-model="$ctrl.updatedSigInstruction.refills"\r\n                            ng-options="option as option.Name for option in $ctrl.refillOptions"\r\n                            ng-change="$ctrl.onRefillsSelected()">\r\n                    </select>\r\n                </td>\r\n            </tr>\r\n        </tbody>\r\n    </table>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardDosingContent.html",'<div id="drug-screening-alert">\r\n    <div id="drug-screening-loading" ng-show="$ctrl.loading">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Fetching Drug Dosing Suggestions\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <uib-tabset ng-show="!$ctrl.loading && $ctrl.dosingGroups.length > 0" active="$ctrl.activeDosingGroup">\r\n        <uib-tab heading="{{::dosingGroup.name}}" ng-repeat="dosingGroup in $ctrl.dosingGroups">\r\n            <div class="panel panel-default" ng-repeat="condition in dosingGroup.conditions">\r\n                <div id="wdc-condition-{{$parent.$index}}-{{$index}}" class="panel-heading clickable" ng-click="condition.detailsCollapsed = !condition.detailsCollapsed" ng-init="$ctrl.initConditionForDisplay(condition)">\r\n                    <div class="pull-right panel-collapser">\r\n                        <span class="ap-chevron-up-blue" ng-show="!condition.detailsCollapsed"></span>\r\n                        <span class="ap-chevron-down-blue" ng-show="condition.detailsCollapsed"></span>\r\n                    </div>\r\n                    <h3 class="panel-title text-center">\r\n                        {{ condition.ConditionDescription }}\r\n                    </h3>\r\n                </div>\r\n                <ul class="list-group" uib-collapse="condition.detailsCollapsed">\r\n                    <li id="wdc-suggestion-{{$parent.$parent.$index}}-{{$parent.$index}}-{{$index}}" class="list-group-item" ng-repeat="suggestion in condition.Suggestions" ng-class="{\'selected\' : suggestion.isSelected}" ng-click="$ctrl.suggestionSelected(suggestion)">\r\n                        <div>{{suggestion.Description}}</div>\r\n                    </li>\r\n                </ul>\r\n            </div>\r\n        </uib-tab>\r\n    </uib-tabset>\r\n    <div class="row ng-hide" ng-show="!$ctrl.loading && $ctrl.dosingGroups.length === 0">\r\n        <div class="col-xs-12">\r\n            <uib-alert type="warning" translate>\r\n                No recommended dosages were found\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardDrugDescription.html",'<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="detail-group">\r\n            <div class="form-group">\r\n                <p class="form-control-static">\r\n                    <strong>{{$ctrl.rxParameters.drug.Description}}</strong>\r\n                </p>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardDrugDetail.html",'<div class="ap-row-striped ap-row-hover ap-row-border">\r\n    <div class="row" ng-if="$ctrl.drugdetail.PatientText">\r\n        <div class="col-xs-12 col-md-3 field-title">Patient</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.PatientText}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.HxSource">\r\n        <div class="col-xs-12 col-md-3 field-title">Source</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.HxSource}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.HxSourceNotes">\r\n        <div class="col-xs-12 col-md-3 field-title">Source Notes</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.HxSourceNotes}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.ProviderText">\r\n        <div class="col-xs-12 col-md-3 field-title">Provider</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.ProviderText}}</div>\r\n    </div>\r\n    <div class="row table-striped table-hover">\r\n        <div class="col-xs-12 col-md-3 field-title">Name</div>\r\n        <div class="col-xs-12 col-md-9 field-detail clickable"><a name="akaSearch" id="akaSearch" ng-if="$ctrl.searchEnabled" ng-click="$ctrl.searchAka($ctrl.drugdetail)" title="AKA Search">{{$ctrl.drugdetail.Description}}</a></div>\r\n        <div class="col-xs-12 col-md-9 field-detail" ng-if="!$ctrl.searchEnabled">{{$ctrl.drugdetail.Description}}</a></div>\r\n    </div>\r\n    <div class="row table-striped table-hover" ng-if="$ctrl.drugdetail.Name">\r\n        <div class="col-xs-12 col-md-3 field-title">Drug</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.Name}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.DrugTypeDescription">\r\n        <div class="col-xs-12 col-md-3 field-title">Info</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.DrugTypeDescription}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.Direction">\r\n        <div class="col-xs-12 col-md-3 field-title">Patient Directions</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.Direction}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.Status">\r\n        <div class="col-xs-12 col-md-3 field-title">Status</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.Status}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.Class">\r\n        <div class="col-xs-12 col-md-3 field-title">Class</div>\r\n        <div class="col-xs-12 col-md-9 field-detail clickable"><a name="classSearch" id="classSearch" ng-if="$ctrl.searchEnabled" ng-click="$ctrl.searchClass($ctrl.drugdetail)" title="Class Search">{{$ctrl.drugdetail.Class}}</a></div>\r\n        <div class="col-xs-12 col-md-9 field-detail" ng-if="!$ctrl.searchEnabled">{{$ctrl.drugdetail.Class}}</a></div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.DosageQuantityText">\r\n        <div class="col-xs-12 col-md-3 field-title">Amount</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.DosageQuantityText}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.DosageUnitText">\r\n        <div class="col-xs-12 col-md-3 field-title">Unit</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.DosageUnitText}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.RouteText">\r\n        <div class="col-xs-12 col-md-3 field-title">Route</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.RouteText}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.Frequency">\r\n        <div class="col-xs-12 col-md-3 field-title">Frequency</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.Frequency}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.DurationText">\r\n        <div class="col-xs-12 col-md-3 field-title">Days</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.Duration}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.RefillQuantity">\r\n        <div class="col-xs-12 col-md-3 field-title">Refills</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.RefillQuantity}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.Quantity">\r\n        <div class="col-xs-12 col-md-3 field-title">Quantity</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.Quantity}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.CreatedDateText">\r\n        <div class="col-xs-12 col-md-3 field-title">Created Date</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.CreatedDateText}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.StartDateText">\r\n        <div class="col-xs-12 col-md-3 field-title">Start Date</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.StartDateText}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.EndDateText">\r\n        <div class="col-xs-12 col-md-3 field-title">End Date</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.EndDateText}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.DAW">\r\n        <div class="col-xs-12 col-md-3 field-title">DAW</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.DAW}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.Maintenance">\r\n        <div class="col-xs-12 col-md-3 field-title">Maintenance</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.Maintenance}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.IsSampleGiven">\r\n        <div class="col-xs-12 col-md-3 field-title">Sample Given</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.IsSampleGiven}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.PharmacyInstructions">\r\n        <div class="col-xs-12 col-md-3 field-title">Pharmacy Inst</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.PharmacyInstructions}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.PatientInstructions">\r\n        <div class="col-xs-12 col-md-3 field-title">Patient Inst</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.PatientInstructions}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.InternalNote">\r\n        <div class="col-xs-12 col-md-3 field-title">Internal Notes</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.InternalNote}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.FullTextSIG">\r\n        <div class="col-xs-12 col-md-3 field-title">SIG</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.FullTextSIG}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.Diagnoses.length > 0">\r\n        <div class="col-xs-12 col-md-3 field-title">Diagnosis</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">\r\n            <ul class="list-group-item" ng-repeat="diagnosis in $ctrl.drugdetail.Diagnoses">\r\n                <li>{{diagnosis.Description}}</li>\r\n            </ul>\r\n        </div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.Problems.length > 0">\r\n        <div class="col-xs-12 col-md-3 field-title">Problems</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">\r\n            <ul class="list-group-item" ng-repeat="problem in $ctrl.drugdetail.Problems">\r\n                <li>{{problem.DiseaseName}}</li>\r\n            </ul>\r\n        </div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.AuthorCode">\r\n        <div class="col-xs-12 col-md-3 field-title">Authorization Code</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.AuthorCode}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.DCReasonComment">\r\n        <div class="col-xs-12 col-md-3 field-title">Discontinued Reason</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.DCReasonComment}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.ReasonForOverrideScreening">\r\n        <div class="col-xs-12 col-md-3 field-title">Reason for overriding of drug screening</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.ReasonForOverrideScreening}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.MedicationSiteName">\r\n        <div class="col-xs-12 col-md-3 field-title">Site</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.MedicationSiteName}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.LotNumber">\r\n        <div class="col-xs-12 col-md-3 field-title">Lot Number</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.LotNumber}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.MedicationMfrName">\r\n        <div class="col-xs-12 col-md-3 field-title">Manufacturer</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.MedicationMfrName}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.MedicationFundingSourceName">\r\n        <div class="col-xs-12 col-md-3 field-title">Funding Source</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.MedicationFundingSourceName}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.ExpirationDate">\r\n        <div class="col-xs-12 col-md-3 field-title">Expiration Date</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.ExpirationDate}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.Initials">\r\n        <div class="col-xs-12 col-md-3 field-title">Initials</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.Initials}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.VISDate">\r\n        <div class="col-xs-12 col-md-3 field-title">VIS Date</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.VISDate}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.VISDateGiven">\r\n        <div class="col-xs-12 col-md-3 field-title">VIS Date Given</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.VISDateGiven}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.AdministeredDateTime">\r\n        <div class="col-xs-12 col-md-3 field-title">Administered Date</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.AdministeredDateTime}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.FulfillmentSequentialNumber">\r\n        <div class="col-xs-12 col-md-3 field-title">Fulfillment Sequential #</div>\r\n        <div class="col-xs-12 col-md-9 field-detail">{{$ctrl.drugdetail.FulfillmentSequentialNumber}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.MedicationConsentInfoHowDiscussed">\r\n        <div class="col-xs-12 col-md-3 field-title">Medication Consent</div>\r\n        <div class="col-xs-12 col-md-9 field-detail"><b><i>How Discussed:</i></b> {{$ctrl.drugdetail.MedicationConsentInfoHowDiscussed}}<br>\r\n                                                    <b><i>Symptom:</i></b> {{$ctrl.drugdetail.MedicationConsentInfoSymptom}}</div>\r\n    </div>\r\n    <div class="row">\r\n        <div class="col-xs-12 col-md-3 field-title">RxNorm</div>\r\n        <div class="col-xs-12 col-md-9 field-detail clickable"><a name="rxnSearch" id="rxnSearch" ng-if="$ctrl.searchEnabled" ng-click="$ctrl.searchRxn($ctrl.drugdetail)" title="RxNorm Search">{{$ctrl.drugdetail.RxNormCode}}</a></div>\r\n        <div class="col-xs-12 col-md-9 field-detail" ng-if="!$ctrl.isSearchEnabled()">{{$ctrl.drugdetail.RxNormCode}}</div>\r\n    </div>\r\n    <div class="row">\r\n        <div class="col-xs-12 col-md-3 field-title">Representative NDC</div>\r\n        <div class="col-xs-12 col-md-9 field-detail clickable"><a name="ndcSearch" id="ndcSearch" ng-if="$ctrl.searchEnabled" ng-click="$ctrl.searchNdc($ctrl.drugdetail)" title="NDC Search">{{$ctrl.drugdetail.Ndc}}</a></div>\r\n        <div class="col-xs-12 col-md-9 field-detail" ng-if="!$ctrl.searchEnabled">{{$ctrl.drugdetail.Ndc}}</div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.PharmacyText">\r\n        <div class="col-xs-12 col-md-3 field-title">Pharmacy</div>\r\n        <div class="col-xs-12 col-md-9 field-detail"><div ng-bind-html="$ctrl.scrubPharmacyText()"></div></div>\r\n    </div>\r\n    <div class="row" ng-if="$ctrl.drugdetail.FillHistory.length > 0">\r\n        <div class="col-xs-12 col-md-12 field-title">Problems</div>\r\n        <div class="col-xs-12 col-md-12 field-detail">\r\n            <div class="row">\r\n                <div class="col-xs-3 col-md-3">Provider</div>\r\n                <div class="col-xs-6 col-md-4">Drug</div>\r\n                <div class="col-xs-3 col-md-1">Quantity</div>\r\n                <div class="col-xs-3 col-md-1">Last Fill Date</div>\r\n                <div class="col-xs-3 col-md-1">Written Date</div>\r\n                <div class="col-xs-3 col-md-1">Effective Date</div>\r\n                <div class="col-xs-3 col-md-1">Expiration Date</div>\r\n            </div>\r\n            <div class="list-group-item" ng-repeat="fillHistory in $ctrl.drugdetail.FillHistory">\r\n                <div class="row">\r\n                    <div class="col-xs-3 col-md-3">{{ fillHistory.ProviderName}}</div>\r\n                    <div class="col-xs-6 col-md-4">{{ fillHistory.DrugName }}</div>\r\n                    <div class="col-xs-3 col-md-1">{{ fillHistory.Quantity }}</div>\r\n                    <div class="col-xs-3 col-md-1">{{ fillHistory.LastFillDate}}</div>\r\n                    <div class="col-xs-3 col-md-1">{{ fillHistory.WrittenDate}}</div>\r\n                    <div class="col-xs-3 col-md-1">{{ fillHistory.EffectiveDate}}</div>\r\n                    <div class="col-xs-3 col-md-1">{{ fillHistory.ExpirationDate}}</div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardDrugSearch.html",'<sigwriter-drug-search\r\n    patient-id="$ctrl.patientId"\r\n    use-previous-search-text="$ctrl.usePreviousSearchText"\r\n    on-drug-search-result-selected="$ctrl.selectDrugSearchResult(drugSearchResult, switchToGeneric, dosingSuggestion, useEnhancedDrugSearch)"\r\n/>\r\n'),$templateCache.put("/sigwriter/component-views/wizardFormularyAlternativesContent.html",'<sigwriter-wizard-formulary-alternatives-original\r\n    ng-if="!$ctrl.useSurescripts"\r\n    is-active-step="$ctrl.isActiveStep"\r\n    rel-visit-medication-id="$ctrl.relVisitMedicationId"\r\n    rx-parameters="$ctrl.rxParameters"\r\n    sig-instruction="$ctrl.sigInstruction"\r\n    sig-options="$ctrl.sigOptions"\r\n    sig-options-non-formulary="$ctrl.sigOptionsNonFormulary"\r\n    skip-formulary-alternatives="$ctrl.skipFormularyAlternatives"\r\n    on-drug-selected="$ctrl.onDrugSelected({drug: drug})"\r\n    update-is-available="$ctrl.updateIsAvailable({isAvailable: isAvailable})"\r\n    update-rel-visit-medication-id="$ctrl.updateRelVisitMedicationId({relVisitMedicationId: relVisitMedicationId})"\r\n    update-sig-options="$ctrl.updateSigOptions({sigOptions: sigOptions})"\r\n/>\r\n<sigwriter-wizard-formulary-alternatives-surescripts\r\n    ng-if="$ctrl.useSurescripts"\r\n    is-active-step="$ctrl.isActiveStep"\r\n    rel-visit-medication-id="$ctrl.relVisitMedicationId"\r\n    rx-parameters="$ctrl.rxParameters"\r\n    sig-formulary="$ctrl.sigFormulary"\r\n    sig-instruction="$ctrl.sigInstruction"\r\n    sig-options="$ctrl.sigOptions"\r\n    sig-options-non-formulary="$ctrl.sigOptionsNonFormulary"\r\n    skip-formulary-alternatives="$ctrl.skipFormularyAlternatives"\r\n    on-drug-selected="$ctrl.onDrugSelected({drug: drug, pharmacy: pharmacy})"\r\n    update-is-available="$ctrl.updateIsAvailable({isAvailable: isAvailable})"\r\n    update-rel-visit-medication-id="$ctrl.updateRelVisitMedicationId({relVisitMedicationId: relVisitMedicationId})"\r\n    update-sig-formulary="$ctrl.updateSigFormulary({sigFormulary: sigFormulary})"\r\n    update-sig-options="$ctrl.updateSigOptions({sigOptions: sigOptions})"\r\n/>'),$templateCache.put("/sigwriter/component-views/wizardFormularyAlternativesContentOriginal.html",'<div id="drug-formulary-display" class="text-center">\r\n\t<div id="drug-screening-loading" ng-show="$ctrl.loading">\r\n\t\t<div class="row">\r\n\t\t\t<div class="col-xs-12 text-center">\r\n\t\t\t\tLoading Formulary Alternatives\r\n\t\t\t\t<br/>\r\n\t\t\t\t<ap-spinner data-size="3"></ap-spinner>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\t\r\n\t<div ng-show="!$ctrl.loading && !$ctrl.$scope.httpError">\r\n\t\t<ul class="list-group" ng-show="$ctrl.drugs.length > 0">\r\n\t\t\t<li class="list-group-item" ng-repeat="drug in $ctrl.drugs">\r\n\t\t\t\t<div class="flexbox flexbox-horizontal-center reverse">\r\n                    <div class="text-center-vert flexbox-pull-right text-center center" style="flex: 0 1 auto;">\r\n\t\t\t\t\t\t<button class="btn btn-warning" hm-click="$ctrl.formularySelected(drug)" translate>Use</button>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="text-center-vert overflow-ellipsis flexbox-pull-left" style="flex: 0 10 auto;">\r\n\t\t\t\t\t\t<div class="heading-title overflow-ellipsis">{{::drug.Description}}</div>\r\n\t\t\t\t\t\t<div class="heading-subtitle overflow-ellipsis">Status - {{::drug.FormularyStatusName}}</div>\r\n\t\t\t\t\t\t<div class="heading-subtitle overflow-ellipsis">Retail Copay - {{::drug.CopayRetail}}</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n\t\t\t</li>\r\n\t\t</ul>\r\n\t\t<div ng-show="$ctrl.drugs.length === 0">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<uib-alert type="success" translate>\r\n\t\t\t\t\tNo formulary alternatives were found.\r\n\t\t\t\t</uib-alert>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\t\r\n\t<div ng-show="$ctrl.$scope.httpError">\r\n\t\t<div class="col-xs-12">\r\n\t\t\t<uib-alert type="danger" translate>\r\n\t\t\t\tThere was a communication issue with the server.  Please contact support.\r\n\t\t\t</uib-alert>\r\n\t\t</div>\r\n\t</div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardFormularyAlternativesSurescripts.html",'<div id="drug-surescripts-formulary-display">\r\n    <div class="row" ng-if="$ctrl.eRxEligibilities && $ctrl.eRxEligibilities.length > 1">\r\n        <div class="col-xs-12">\r\n            <div class="form-group row">\r\n                <div class="col-xs-3 col-md-2">\r\n                    <label class="control-label text-left">{{::\'eRx Eligibility\' | translate}}</label>\r\n                </div>\r\n\r\n                <div class="col-xs-9 col-md-10">\r\n                    <ap-select>\r\n                        <select class="form-control"\r\n                                ng-model="$ctrl.eRxEligibility"\r\n                                ng-options="erxe as erxe.Name for erxe in $ctrl.eRxEligibilities track by erxe.PatienteRxElgibilityUid"\r\n                                ng-change="$ctrl.onERxEligibilityChanged()">\r\n                        </select>\r\n                    </ap-select>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div ng-hide="$ctrl.eRxEligibilities.length || $ctrl.loadingERxEligibilities">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <span translate>\r\n                    There are no active coverages downloaded for this patient.\r\n                </span>\r\n            </div>\r\n        </div>\r\n        <br>\r\n    </div>\r\n    <sigwriter-formulary-details\r\n        details="$ctrl.details"\r\n        error="$ctrl.$scope.httpError"\r\n        hide-transmit-status="$ctrl.hideTransmitStatus"\r\n        is-info-available="$ctrl.isInfoAvailable"\r\n        loading="$ctrl.loading"\r\n        on-drug-selected="$ctrl.changeMedication(drug, pharmacy)"\r\n    />\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardPdr.html",'<div id="drug-documentation">\r\n    <div id="drug-documentation-loading" ng-show="$ctrl.loadingDrugDocumentation">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Loading Drug Documentation\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id="drug-documentation-content" ng-show="!$ctrl.loadingDrugDocumentation && !$ctrl.$scope.httpError">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <iframe ng-src="{{$ctrl.drugDocumentation.html}}"\r\n                        width="310px"\r\n                        height="180px"\r\n                        class="pdr-border">\r\n                </iframe>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row" ng-if="!!$ctrl.$scope.httpError">\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.unhandled">\r\n            <uib-alert type="danger">\r\n                {{::"An error has occurred and the documentation could not be loaded." | translate}}\r\n            </uib-alert>\r\n        </div>\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.is403">\r\n            <uib-alert type="danger">\r\n                {{::\'You do not have access to the documentation.\' | translate}}\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/sigwriter/component-views/wizardReview.html",'<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Medication Type\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                <span ng-if="$ctrl.currentRx.optionsNonFormulary.isAdministered" translate>Administered</span>\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.isAdministered && $ctrl.currentRx.optionsNonFormulary.isSampleGiven" translate>Sample Given</span>\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.isAdministered && !$ctrl.currentRx.optionsNonFormulary.isSampleGiven" translate>Standard</span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr />\r\n\r\n<div class="row" ng-repeat="instruction in $ctrl.currentRx.instructions">\r\n    <div class="row" ng-if="$index !== 0">\r\n        <hr/>\r\n    </div>\r\n    <div class="col-xs-12">\r\n        <div class="detail-group">\r\n            <div class="form-group">\r\n                <p class="form-control-static">\r\n                    {{instruction.sigString}}\r\n                </p>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="col-xs-6 col-md-3">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Duration\' | translate}}</label>\r\n\r\n            <p ng-if="instruction.days.Name" class="form-control-static">\r\n                {{instruction.days.Name}} {{::\'Day(s)\' | translate}}\r\n            </p>\r\n            <p ng-if="!instruction.days.Name">\r\n                {{::\'N/A\' | translate}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-6 col-md-3">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Refills\' | translate}}</label>\r\n\r\n            <p ng-if="instruction.refills.Name" class="form-control-static">\r\n                {{instruction.refills.Name}} {{::\'Refill(s)\' | translate}}\r\n            </p>\r\n            <p ng-if="!instruction.refills.Name">\r\n                {{::\'N/A\' | translate}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-6 col-md-3">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Quantity\' | translate}}\r\n                (<span ng-if="!instruction.isManualQuantity">{{::\'Auto\' | translate}}</span><span\r\n                        ng-if="instruction.isManualQuantity">{{::\'Manual\' | translate}}</span>)\r\n            </label>\r\n\r\n            <p class="form-control-static">\r\n                {{instruction.quantity}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-6 col-md-3">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Start + End\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                <ap-date-formatter date="{{instruction.startDate}}" format="long-date"></ap-date-formatter>\r\n                -\r\n                <ap-date-formatter date="{{instruction.endDate}}" format="long-date"></ap-date-formatter>\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr/>\r\n\r\n<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Unit of Measure\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.options.uom.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.options.uom">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Diagnoses & Problems\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                <span ng-repeat="problem in $ctrl.currentRx.optionsNonFormulary.problems">\r\n                    {{problem.Name}}\r\n                    <br/>\r\n                </span>\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.problems.length">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Category\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.category.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.category">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Pharmacy Instructions\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.pharmacyInstructions}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.pharmacyInstructions">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Internal Note\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.internalNote}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.internalNote">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Prescriber\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.user.fullName}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered || $ctrl.currentRx.optionsNonFormulary.isSampleGiven"/>\r\n<div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered || $ctrl.currentRx.optionsNonFormulary.isSampleGiven" class="row">\r\n    <div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered" class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Site\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.medicationSite.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.medicationSite">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Lot #\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.lotNumber}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.lotNumber">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Manufacturer\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.manufacturer.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.manufacturer">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered" class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Funding Source\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.fundingSource.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.fundingSource">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Expiration Date\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                <ap-date-formatter date="{{$ctrl.currentRx.optionsNonFormulary.expirationDate}}" format="long-date"></ap-date-formatter>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered" class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Initials\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.initials}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.initials">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered" class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Administered Date\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                <ap-date-formatter date="{{$ctrl.currentRx.optionsNonFormulary.administeredDateTime}}" format="long-date"></ap-date-formatter>\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr ng-show="$ctrl.currentRx.optionsNonFormulary.daw || $ctrl.currentRx.optionsNonFormulary.isChronicMed || $ctrl.currentRx.optionsNonFormulary.includeMonograph" />\r\n\r\n<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.daw">\r\n                {{::\'Dispense as Written\' | translate}}\r\n            </div>\r\n        </div>\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.isChronicMed">\r\n                {{::\'Chronic Medication\' | translate}}\r\n            </div>\r\n        </div>\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.includeMonograph">\r\n                {{::\'Include Monograph\' | translate}}\r\n            </div>\r\n        </div>\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.sendPriorAuth">\r\n                {{::\'Electronic Prior Authorization\' | translate}}\r\n            </div>\r\n        </div>\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.sendIsSpecialty">\r\n                {{::\'Specialty Patient Enrollment\' | translate}}\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr/>\r\n\r\n<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Pharmacy\' | translate}}</label>\r\n\r\n            <p ng-if="$ctrl.currentRx.options.pharmacy" class="form-control-static">\r\n                {{$ctrl.currentRx.options.pharmacy.Name}}\r\n\r\n                <br/>\r\n\r\n                ph. <a dial-href="$ctrl.currentRx.options.pharmacy.Phone.PhoneNumber">{{$ctrl.currentRx.options.pharmacy.Phone.PhoneNumber}}</a>\r\n\r\n                <ap-address data-address="$ctrl.currentRx.options.pharmacy.Address"></ap-address>\r\n            </p>\r\n            <p ng-if="!$ctrl.currentRx.options.pharmacy">\r\n                {{::\'N/A\' | translate}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n<hr/>\r\n\r\n<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <div class="flexbox flexbox-horizontal-center">\r\n                <div>\r\n                    {{::\'Save as Default SIG?\' | translate}}\r\n                </div>\r\n                <div class="flexbox-pull-right">\r\n                    <input type="checkbox" name="create-default-sig" id="create-default-sig"\r\n                            ng-model="$ctrl.options.createDefaultSig"\r\n                            ng-change="$ctrl.onOptionsChanged()">\r\n                    <label for="create-default-sig"></label>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n<form name="$ctrl.epcsForm" novalidate>\r\n    <sigwriter-epcs-signature\r\n        ng-if="$ctrl.needsEpcs()"\r\n        epcs-model="$ctrl.user.epcsModel"\r\n    />\r\n</form>'),$templateCache.put("/sigwriter/component-views/wizardScreeningContent.html",'<div id="drug-screening-alert">\r\n    <div id="drug-screening-loading" ng-show="$ctrl.loadingDrugScreening">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Performing Drug Screening\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    \r\n    <div id="drug-screening-alerts" ng-show="$ctrl.drugScreeningMode === \'display\' || $ctrl.drugScreeningMode === \'redirecting\'">\r\n        <div class="row" ng-show="$ctrl.drugScreeningMode === \'display\'">\r\n            <div class="col-xs-12" translate>\r\n                <div class="drug-screening-group" id="drug-screening-user-alert" ng-if="$ctrl.screening.ProspectiveDrugIsUserDefined && $ctrl.screening.NewDrugWarning.IsUserDefined">\r\n                    <span class="drug-screening-alert-header">{{::\'Drug screening cannot be performed when adding the user defined medication\' | translate}}</span>\r\n                    <div>\r\n                        {{::$ctrl.screening.NewDrugWarning.DrugName}}\r\n                    </div>\r\n                </div>\r\n    \r\n                <div ng-if="!$ctrl.screening.ProspectiveDrugIsUserDefined">\r\n                    <div class="drug-screening-group" id="drug-screening-interaction-alert" ng-if="$ctrl.screening.Interactions">\r\n                        <span class="drug-screening-alert-header">{{::\'Interaction Alert\' | translate}}</span>\r\n                        <div ng-repeat="msg in $ctrl.screening.Interactions.Messages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-repeat="msg in $ctrl.screening.Interactions.ScreenMessages track by $index">\r\n                            {{msg.ScreenMessage}}\r\n                            <div>\r\n                                <strong>{{\'Severity\' | translate}}:</strong>&nbsp;{{msg.Severity}}\r\n                            </div>\r\n                            <div>\r\n                                <strong>{{\'Effect\' | translate}}:</strong>&nbsp;{{msg.ClinicalEffectCode1}}\r\n                            </div>\r\n                            <div ng-show="msg.ClinicalEffectCode2">\r\n                                <strong>{{\'Effect\' | translate}}:</strong>&nbsp;{{msg.ClinicalEffectCode2}}\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n    \r\n                    <div class="drug-screening-group" id="drug-screening-therapy-alert" ng-if="$ctrl.screening.DuplicateTherapy">\r\n                        <span class="drug-screening-alert-header">{{::\'Duplicate Therapy Alert\' | translate}}</span>\r\n                        <div ng-repeat="msg in $ctrl.screening.DuplicateTherapy.Messages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-repeat="msg in $ctrl.screening.DuplicateTherapy.ScreenMessages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                    </div>\r\n                    <div class="drug-screening-group" id="drug-screening-ingredients-alert" ng-if="$ctrl.screening.DuplicateIngredients && $ctrl.screening.DuplicateIngredients.length > 0">\r\n                        <span class="drug-screening-alert-header">{{::\'Duplicate Ingredient Alert\' | translate}}</span>\r\n                        <div ng-repeat="msg in $ctrl.screening.DuplicateIngredients.Messages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-repeat="msg in $ctrl.screening.DuplicateIngredients.ScreenMessages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                    </div>\r\n    \r\n                    <div class="drug-screening-group" id="drug-screening-allergy-alert" ng-if="$ctrl.screening.Allergies">\r\n                        <span class="drug-screening-alert-header">{{::\'Allergy Alert\' | translate}}</span>\r\n                        <div ng-repeat="msg in $ctrl.screening.Allergies.Messages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-repeat="msg in $ctrl.screening.Allergies.ScreenMessages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-if="$ctrl.screening.Allergies.UserDefinedDrugAllergies.length">\r\n                            <strong>{{::\'Custom Drug Allergy Present\' | translate}}</strong>\r\n                            {{\'The following drug allergies were not included in any allergy to drug screening test:\'}}\r\n                            <span ng-repeat="allergy in $ctrl.screening.Allergies.UserDefinedDrugAllergies track by $index">\r\n                                {{allergy}}<span ng-if="$index !== $ctrl.screening.Allergies.UserDefinedDrugAllergies.length - 1">,</span>\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n    \r\n                    <div class="drug-screening-group" id="drug-screening-medical-precaution" ng-if="$ctrl.screening.MedicalCondition">\r\n                        <span class="drug-screening-alert-header">{{::\'Medical Condition Precaution\' | translate}}</span>\r\n                        <div ng-repeat="msg in $ctrl.screening.MedicalCondition.Messages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-repeat="msg in $ctrl.screening.MedicalCondition.ScreenMessages track by $index">\r\n                            {{msg.ScreenMessage}}\r\n                            <br />\r\n                            <strong>{{::\'Severity\' | translate}} {{msg.Severity}}</strong>\r\n                        </div>\r\n                        <div ng-if="$ctrl.screening.Allergies.UserDefinedDrugAllergies.length">\r\n                            <strong>{{::\'Custom Drug Allergy Present\' | translate}}</strong>\r\n                            {{\'The following drug allergies were not included in any allergy to drug screening test:\'}}\r\n                            <span ng-repeat="allergy in $ctrl.screening.Allergies.UserDefinedDrugAllergies track by $index">\r\n                                {{allergy}}<span ng-if="$index !== $ctrl.screening.Allergies.UserDefinedDrugAllergies.length - 1">,</span>\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n    \r\n                    <div class="drug-screening-group" id="drug-screening-pregnancy-precaution" ng-if="$ctrl.screening.PregancyMessages">\r\n                        <span class="drug-screening-alert-header">{{::\'Pregnancy Precaution\' | translate}}</span>\r\n                        <div ng-repeat="msg in $ctrl.screening.PregancyMessages.Messages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-repeat="msg in $ctrl.screening.PregancyMessages.ScreenMessages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                    </div>\r\n    \r\n                    <div class="drug-screening-group" id="drug-screening-lactation-precaution" ng-if="$ctrl.screening.LactationScreening">\r\n                        <span class="drug-screening-alert-header">{{::\'Lactation Precaution\' | translate}}</span>\r\n                        <div ng-repeat="msg in $ctrl.screening.LactationScreening.Messages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-repeat="msg in $ctrl.screening.LactationScreening.ScreenMessages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                    </div>\r\n    \r\n                    <div class="drug-screening-group" id="drug-screening-pediatric-precaution" ng-if="$ctrl.screening.PediatricScreening">\r\n                        <span class="drug-screening-alert-header">{{::\'Pediatric Precaution\' | translate}}</span>\r\n                        <div ng-repeat="msg in $ctrl.screening.PediatricScreening.Messages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-repeat="msg in $ctrl.screening.PediatricScreening.ScreenMessages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                    </div>\r\n    \r\n                    <div class="drug-screening-group" id="drug-screening-geriatric-precaution" ng-if="$ctrl.screening.GeriatricScreening">\r\n                        <span class="drug-screening-alert-header">{{::\'Geriatric Precaution\' | translate}}</span>\r\n                        <div ng-repeat="msg in $ctrl.screening.GeriatricScreening.Messages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                        <div ng-repeat="msg in $ctrl.screening.GeriatricScreening.ScreenMessages track by $index">\r\n                            {{msg}}\r\n                        </div>\r\n                    </div>\r\n    \r\n                    <div class="drug-screening-group" id="drug-screening-definition-alert" ng-if="$ctrl.screening.WarnUserDefinedMedications.length">\r\n                        <span class="drug-screening-alert-header">{{::\'User Defined Medication Present\' | translate}}</span>\r\n                        <div>\r\n                            {{\'The following medications were not included in any drug screening test:\'}}\r\n                        </div>\r\n                        <div>\r\n                            <span ng-repeat="drug in $ctrl.screening.WarnUserDefinedMedications track by $index">\r\n                                {{drug}}<span ng-if="!$last">,</span>\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="row" ng-show="$ctrl.drugScreeningMode === \'redirecting\'">\r\n            <div class="col-xs-12">\r\n                <uib-alert type="success" translate>\r\n                    Drug screening found no interactions.\r\n                </uib-alert>\r\n            </div>\r\n        </div>\r\n        <hr/>\r\n        <div class="row">\r\n            <div id="legal-alert" class="col-xs-12">\r\n                {{::$ctrl.screening.DisclaimerText}}\r\n\r\n                <div class="row">\r\n                    <div ng-if="$ctrl.screening.Version" class="col-xs-12 text-center">\r\n                        <div ng-if="$ctrl.screening.Version.NumberOfDaysExpired">\r\n                            {{::\'Number of days the First Databank data has been expired\' | translate}}\r\n                            {{$ctrl.screening.Version.NumberOfDaysExpired}}\r\n                        </div>\r\n                        <div>{{$ctrl.screening.Version.VersionInformation}}</div>\r\n                        <div>{{$ctrl.screening.Version.Copyright}}</div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    \r\n    <div id="drug-screening-out-of-date" ng-show="$ctrl.drugScreeningMode === \'outofdate\'">\r\n        <div class="row">\r\n            <div class="col-xs-12" translate>\r\n                Drug database is out of date and drug screening cannot be performed.\r\n            </div>\r\n        </div>\r\n    </div>\r\n     <div class="drug-screening-group" id="drug-screening-actx-alert" ng-if="$ctrl.screening.ActXMessages">\r\n        <span class="drug-screening-alert-header">{{::\'ActX Precaution\' | translate}} </span>\r\n        <div ng-repeat="msg in $ctrl.screening.ActXMessages.Alerts track by $index">\r\n            <div>\r\n                {{msg.MedicationName}}\r\n            </div>\r\n            <div>\r\n                Seriousness: {{msg.Seriousness}}\r\n            </div>\r\n            <div>\r\n               Summary:  {{msg.ShortSummary}}\r\n            </div>\r\n            <div>\r\n                Additional Information: {{msg.ExtendedSummary}}\r\n            </div>\r\n        </div>\r\n    </div> \r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardScreeningOverride.html",'<div id="drug-screening-alert-override">\r\n    <div id="drug-screening-override">\r\n        <div class="form-group">\r\n            <label class="control-label" translate>Enter Override Reason</label>\r\n            <ap-select>\r\n                <select\r\n                    class="form-control"\r\n                    name="NotesList"\r\n                    ng-model="$ctrl.selectedOverrideReason"\r\n                    ng-options="override.Notes as override.Name for override in $ctrl.drugScreeningOverrides"\r\n                    ng-change="$ctrl.overrideSelected()">\r\n                </select>\r\n            </ap-select>\r\n            <br />\r\n            <textarea\r\n                class="form-control"\r\n                name="Note"\r\n                ng-model="$ctrl.overrideText"\r\n                ng-change="$ctrl.onOverrideTextChanged()"\r\n                rows="5"\r\n                ng-trim="false"\r\n                ng-required="true">\r\n            </textarea>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardSigInstructions.html",'<form name="$ctrl.sigInstructionsForm">\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="detail-group">\r\n                <div class="form-group" ng-class="{ \'has-error\' : $ctrl.sigInstructionsForm.$error.siginstructionlength}">\r\n                    <div class="pull-right">\r\n                        <label class="control-label">\r\n                            {{$ctrl.getRemainingSigCharacters()}}\r\n                        </label>\r\n                    </div>\r\n                    <p class="form-control-static" ng-if="!$ctrl.isNested">\r\n                        <strong>{{$ctrl.rxParameters.drug.Description}}</strong>\r\n                    </p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row" id="sig-instructions-icons">\r\n        <div class="col-xs-6">\r\n            <i id="open-dosing-btn" class="ap-dosing-suggestions-black" ng-click="$ctrl.openDosingSuggestions()"></i>\r\n        </div>\r\n        <div class="col-xs-6">\r\n            <i class="ap-pdr" ng-click="$ctrl.openPdr()"></i>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="detail-group">\r\n                <div class="form-group" ng-class="{ \'has-error\' : $ctrl.sigInstructionsForm.$error.siginstructionlength}">\r\n                    <sigwriter-wizard-sig-instructions-content\r\n                        rx-options="$ctrl.rxOptions"\r\n                        sig-instruction="$ctrl.sigInstruction"\r\n                        sig-options-non-formulary="$ctrl.sigOptionsNonFormulary"\r\n                        on-select="$ctrl.onSigSelected(sig)"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="form-horizontal">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <div class="form-group" id="quantity-form-group">\r\n                    <label class="col-xs-3 col-sm-2 control-label">{{::\'Quantity\' | translate}}</label>\r\n                    <div class="col-xs-9 col-sm-10">\r\n                        <div class="input-group">\r\n                            <input type="number" class="form-control"\r\n                                   name="quantity"\r\n                                   ng-disabled="$ctrl.sigInstruction.disallowChangingQuantity || !$ctrl.sigInstruction.isManualQuantity"\r\n                                   ng-model="$ctrl.sig.quantity"\r\n                                   ng-change="$ctrl.saveSigInstruction()"\r\n                                   ap-metadata="$ctrl.rxOptions.metadata.visit.Fields.Prescriptions.Fields.Instructions.Fields.TotalQuantity">\r\n                            </input>\r\n                            <span class="input-group-btn" id="toggle-quantity-btn-group" ng-if="!$ctrl.sigInstruction.disallowChangingQuantity">\r\n                                <button class="btn btn-default"\r\n                                        ng-if="!$ctrl.sigInstruction.isManualQuantity"\r\n                                        ng-click="$ctrl.toggleQuantityType()"\r\n                                        ng-disabled="$ctrl.sigInstruction.disallowAutoQuantity"\r\n                                        id="auto-quantity-btn">\r\n                                    {{::\'Auto\' | translate}}\r\n                                </button>\r\n                                <button class="btn btn-default"\r\n                                        ng-if="$ctrl.sigInstruction.isManualQuantity"\r\n                                        ng-click="$ctrl.toggleQuantityType()"\r\n                                        ng-disabled="$ctrl.sigInstruction.disallowAutoQuantity"\r\n                                        id="manual-quantity-btn">\r\n                                    {{::\'Manual\' | translate}}\r\n                                </button>\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="row" ng-hide="$ctrl.disableDates">\r\n            <div class="col-xs-12">\r\n                <div class="form-group">\r\n                    <label class="col-xs-3 col-sm-2 control-label">{{::\'Start Date\' | translate}}</label>\r\n                    <div class="col-xs-9 col-sm-10">\r\n                        <input type="date" class="form-control"\r\n                               ng-model="$ctrl.sig.startDate"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ng-change="$ctrl.saveSigInstruction();"\r\n                               ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.StartDate">\r\n                        </input>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="row" ng-hide="$ctrl.disableDates">\r\n            <div class="col-xs-12">\r\n                <div class="form-group">\r\n                    <label class="col-xs-3 col-sm-2 control-label">{{::\'End Date\' | translate}}</label>\r\n                    <div class="col-xs-9 col-sm-10">\r\n                        <input type="date" class="form-control"\r\n                               ng-model="$ctrl.sig.endDate"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ng-change="$ctrl.endDateChanged()"\r\n                               ng-min="$ctrl.sig.startDate"\r\n                               ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.StopDate">\r\n                        </input>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row" ng-if="!$ctrl.rxParameters.isFixedPharmacy && $ctrl.enableMedicationTypeSelection">\r\n        <div class="col-xs-12">\r\n            <div class="form-group row">\r\n                <label class="col-xs-3 col-sm-2 control-label">{{::\'Medication Type\' | translate}}</label>\r\n\r\n                <div class="col-xs-9 col-sm-10">\r\n                    <ap-select>\r\n                        <select class="form-control"\r\n                                ng-model="$ctrl.medicationType"\r\n                                ng-options="type.name for type in $ctrl.rxOptions.additionalMedInfo.medTypes track by type.Id"\r\n                                ng-change="$ctrl.onMedTypeChanged()">\r\n                        </select>\r\n                    </ap-select>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</form>'),$templateCache.put("/sigwriter/component-views/wizardSigInstructionsContent.html",'<div>\r\n    <div class="rx-instructions-menu-text flexbox flexbox-horizontal-center flexbox-horizontal-wrap">\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.startText"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div class="ap-flex-group-r text-token-parent">\r\n            <div class="text-token instructions-dosage ap-flex-group-item"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'dosage\');"\r\n                 ap-context-menu-close="$ctrl.menuClosed(\'dosage\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.dosage.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.dosage.Name && !$ctrl.sig.dosage.isNull">\r\n                    {{$ctrl.sig.dosage.Name}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.dosage || $ctrl.sig.dosage.isNull || $ctrl.sig.dosage.Name === 0" class="rx-instruction-placeholder">\r\n                    {{::\'Dosage\' | translate}}\r\n                </span>\r\n            </div>\r\n            <button type="button"\r\n                    class="btn btn-default-blue-text ap-flex-group-item"\r\n                    ng-if="$ctrl.shouldDisplayDosingCalc()"\r\n                    ng-click="$ctrl.onClickDosingCalculator()">\r\n                {{::\'Calc\' | translate}}\r\n            </button>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postDosage"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div class="text-token instructions-unit"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'unit\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.unit.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.unit.Name && !$ctrl.sig.unit.isNull">\r\n                    {{$ctrl.sig.unit.Name || (\'Unit\' | translate)}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.unit || $ctrl.sig.unit.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'Unit\' | translate}}\r\n                </span>\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postUnit"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div class="text-token instructions-route"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'route\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.route.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.route.Name && !$ctrl.sig.route.isNull">\r\n                    {{$ctrl.sig.route.Name || (\'Route\' | translate)}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.route || $ctrl.sig.route.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'Route\' | translate}}\r\n                </span>\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postRoute"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div class="text-token instructions-frequency"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'frequency\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.frequency.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.frequency.Name && !$ctrl.sig.frequency.isNull">\r\n                    {{$ctrl.sig.frequency.Name || (\'Frequency\' | translate)}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.frequency || $ctrl.sig.frequency.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'Frequency\' | translate}}\r\n                </span>\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postFrequency"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div class="text-token instructions-prn-reason"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'prnReason\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.prnReason.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.prnReason.Name && !$ctrl.sig.prnReason.isNull">{{\'as needed\' | translate}}</span>\r\n                <span ng-if="$ctrl.sig.prnReason.Name && !$ctrl.sig.prnReason.isNull">\r\n                    {{$ctrl.sig.prnReason.Name || (\'PRN\' | translate)}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.prnReason || $ctrl.sig.prnReason.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'PRN\' | translate}}\r\n                </span>\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postPrn"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.endText"\r\n                 data-placeholder="Instructions"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n            <div class="text-token instructions-days"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'days\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.days ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.days.Name && !$ctrl.sig.days.isNull">\r\n                    {{$ctrl.sig.days.Name}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.days || $ctrl.sig.days.isNull || $ctrl.sig.days.Name === 0" class="rx-instruction-placeholder">\r\n                    {{::\'Day(s)\' | translate}}\r\n                </span>\r\n                <span ng-if="$ctrl.sig.days.Name && !$ctrl.sig.days.isNull">{{\'day(s)\' | translate}}</span>\r\n            </div>\r\n        </div>\r\n\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n            <div class="text-token instructions-refills"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'refills\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.refills ? \'\' : \'placeholder\'">\r\n                <span ng-if="($ctrl.sig.refills.Name || $ctrl.sig.refills.Name === 0) && !$ctrl.sig.refills.isNull">\r\n                    {{$ctrl.sig.refills.Name}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.refills || $ctrl.sig.refills.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'Refill(s)\' | translate}}\r\n                </span>\r\n                <span ng-if="($ctrl.sig.refills.Name || $ctrl.sig.refills.Name === 0) && !$ctrl.sig.refills.isNull">{{\'refill(s)\' | translate}}</span>\r\n            </div>\r\n        </div>\r\n\r\n\r\n    </div>\r\n</div>\r\n\r\n<div id="rx-instructions-context-menu" class="context-menu" ng-cloak style="bottom: 0px; left: 0; width: 100%;  height: {{$ctrl.maxHeight}}px;">\r\n    <ul class="dropdown-menu position-fixed" role="menu"\r\n        style="height: auto; min-height: {{$ctrl.maxHeight}}px; max-height: {{$ctrl.maxHeight}}px; overflow-x: hidden; width: 100%; top:0;">\r\n        <li class="dropdown-header">\r\n            {{$ctrl.currentOption.name}}\r\n        </li>\r\n\r\n        <li ng-if="$ctrl.currentOption.allowNumericFreeEntry">\r\n            <form>\r\n                <div class="form-group">\r\n                    <div class="input-group input-group-sm">\r\n                        <input type="number"\r\n                               class="form-control"\r\n                               placeholder="Custom {{$ctrl.currentOption.name}}"\r\n                               ng-model="$ctrl.sig.numericEntry" />\r\n                        <span class="input-group-btn">\r\n                            <button class="btn btn-default" type="submit"\r\n                                    ng-click="$ctrl.selectTextOption()">\r\n                                <span><i class="fa fa-check"></i></span>\r\n                            </button>\r\n                        </span>\r\n                    </div>\r\n                </div>\r\n            </form>\r\n        </li>\r\n\r\n        <li ng-repeat="option in $ctrl.options"\r\n            class="text-center rx-instructions-option"\r\n                ng-class="{\'selected\': $ctrl.optionSelected(option, $ctrl.currentOption)}">\r\n            <a class="pointer"\r\n               role="menuitem"\r\n               tabindex="{{$index}}"\r\n               ng-click="$ctrl.selectOption(option)"\r\n               translate>\r\n                {{option.Name || option}} {{option.suffix || option.Suffix}}\r\n            </a>\r\n        </li>\r\n    </ul>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardSigOptions.html",'<form name="$ctrl.sigOptionsForm" novalidate>\r\n    <div>\r\n        <div ng-if="!$ctrl.rxParameters.isFixedPharmacy && !$ctrl.drugAdministered">\r\n            <div class="form-horizontal">\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group rx-pharmacy" id="pharmacy-form-group"\r\n                            ng-class="{ \'has-error\' : ($ctrl.sigOptionsForm.PharmacyId.$invalid && ($ctrl.sigOptionsForm.PharmacyId.$dirty || $ctrl.sigOptionsForm.isSubmitted))}">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Pharmacy\' | translate}}</label>\r\n\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <ap-find-pharmacy\r\n                                        name="PharmacyId"\r\n                                        ng-model="$ctrl.pharmacy"\r\n                                        ng-change="$ctrl.onFindPharmacyChanged()"\r\n                                        ap-required="true"\r\n                                        default-list="$ctrl.pharmacies"\r\n                                        parent-container-id="$ctrl.parentContainerId">\r\n                                </ap-find-pharmacy>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group"\r\n                        ng-class="{ \'has-error\' : ($ctrl.sigOptionsForm.pharmacyInstructions.$invalid && ($ctrl.sigOptionsForm.pharmacyInstructions.$dirty || $ctrl.sigOptionsForm.isSubmitted))}">\r\n                        <div class="pull-right">\r\n                            <label class="control-label">\r\n                                {{$ctrl.getRemainingPharmacyInstructionCharacters()}}\r\n                            </label>\r\n                        </div>\r\n                        <label class="control-label">{{::\'Pharmacy Instructions\' | translate}}</label>\r\n                        <textarea class="form-control"\r\n                                name="pharmacyInstructions"\r\n                                ng-model="$ctrl.optionsNonFormulary.pharmacyInstructions"\r\n                                ap-auto-grow\r\n                                ap-metadata="$ctrl.rxOptions.metadata.visit.Fields.Prescriptions.Fields.Instructions.Fields.PharmacyInstruction"\r\n                                ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                        </textarea>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="form-horizontal">\r\n            <div class="row" ng-if="$ctrl.rxParameters.isFixedPharmacy">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group" id="Pharmacy">\r\n                        <label class="col-xs-3 col-sm-2 control-label" class="control-label" translate>Pharmacy</label>\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <ap-pharmacy-item pharmacy="$ctrl.options.pharmacy"></ap-pharmacy-item>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <hr />\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="col-xs-3 col-sm-2 control-label">{{::\'UOM\' | translate}}</label>\r\n\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <ap-select>\r\n                                <select class="form-control"\r\n                                        ng-model="$ctrl.options.uom"\r\n                                        ng-options="uom.Name for uom in $ctrl.rxOptions.lists.unitsOfMeasure track by uom.Id"\r\n                                        ng-change="$ctrl.onOptionsChanged()">\r\n                                </select>\r\n                            </ap-select>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <hr />\r\n\r\n            <div ng-show="$ctrl.optionsNonFormulary.isAdministered || $ctrl.optionsNonFormulary.isSampleGiven">\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 control-label" style="color:rgb(0, 105, 165);font-weight:bold">{{::\'MEDICATION OPTIONS\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row" ng-show="$ctrl.optionsNonFormulary.isAdministered">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Site\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <ap-select>\r\n                                    <select class="form-control"\r\n                                            id="mt-site"\r\n                                            ng-model="$ctrl.optionsNonFormulary.medicationSite"\r\n                                            ng-options="site.Name for site in $ctrl.rxOptions.additionalMedInfo.medicationSites"\r\n                                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                    </select>\r\n                                </ap-select>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Lot #\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <textarea class="form-control"\r\n                                          id="mt-lot"\r\n                                          ng-model="$ctrl.optionsNonFormulary.lotNumber"\r\n                                          ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                </textarea>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Manufacturer\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <ap-select>\r\n                                    <select class="form-control" id="mt-mfr"\r\n                                            ng-model="$ctrl.optionsNonFormulary.manufacturer"\r\n                                            ng-options="site.Name for site in $ctrl.rxOptions.additionalMedInfo.manufacturers"\r\n                                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                    </select>\r\n                                </ap-select>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row" ng-show="$ctrl.optionsNonFormulary.isAdministered">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Funding Source\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <ap-select>\r\n                                    <select class="form-control" id="mt-funding"\r\n                                            ng-model="$ctrl.optionsNonFormulary.fundingSource"\r\n                                            ng-options="site.Name for site in $ctrl.rxOptions.additionalMedInfo.fundingSources"\r\n                                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                    </select>\r\n                                </ap-select>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Expiration Date\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <input type="date" class="form-control" id="mt-expirDate"\r\n                                       ng-model="$ctrl.optionsNonFormulary.expirationDate"\r\n                                       ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.ExpirationDate"\r\n                                       ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                                       ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                </input>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row" ng-show="$ctrl.optionsNonFormulary.isAdministered">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Initials\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <textarea class="form-control"\r\n                                          id="mt-initials"\r\n                                          ng-model="$ctrl.optionsNonFormulary.initials"\r\n                                          ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                </textarea>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row" ng-show="$ctrl.optionsNonFormulary.isAdministered">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Administered Date\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <input type="date" class="form-control" id="mt-adminDate"\r\n                                       ng-model="$ctrl.optionsNonFormulary.administeredDateTime"\r\n                                       ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                                       ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.AdministeredDate"\r\n                                       ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                </input>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <hr ng-show="$ctrl.optionsNonFormulary.isAdministered || $ctrl.optionsNonFormulary.isSampleGiven" />\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="col-xs-3 col-sm-2 control-label">{{::\'Diagnoses & Problems\' | translate}}</label>\r\n\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <select class="form-control"\r\n                                    ng-model="$ctrl.optionsNonFormulary.problems"\r\n                                    ng-options="problem as problem.Name for problem in $ctrl.problems"\r\n                                    ng-change="$ctrl.onOptionsNonFormularyChanged()"\r\n                                    multiple="multiple">\r\n                            </select>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="col-xs-3 col-sm-2 control-label">{{::\'Category\' | translate}}</label>\r\n\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <ap-select>\r\n                                <select class="form-control"\r\n                                        ng-model="$ctrl.optionsNonFormulary.category"\r\n                                        ng-options="category as category.Name for category in $ctrl.rxOptions.lists.medicationCategories track by category.Id"\r\n                                        ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                </select>\r\n                            </ap-select>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="col-xs-3 col-sm-2 control-label">{{::\'Options\' | translate}}</label>\r\n\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <div class="flexbox flexbox-horizontal-center">\r\n                                <div>\r\n                                    {{::\'Dispense as Written\' | translate}}\r\n                                </div>\r\n                                <div class="flexbox-pull-right">\r\n                                    <input type="checkbox" name="daw" id="daw"\r\n                                           ng-model="$ctrl.optionsNonFormulary.daw"\r\n                                           ng-disabled="$ctrl.dawDisabled"\r\n                                           ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                    <label for="daw"></label>\r\n                                </div>\r\n                            </div>\r\n                            <hr />\r\n                            <div class="flexbox flexbox-horizontal-center">\r\n                                <div>\r\n                                    {{::\'Chronic Medication\' | translate}}\r\n                                </div>\r\n                                <div class="flexbox-pull-right">\r\n                                    <input type="checkbox" name="chronic-med" id="chronic-med"\r\n                                           ng-model="$ctrl.optionsNonFormulary.isChronicMed"\r\n                                           ng-disabled="$ctrl.chronicDisabled"\r\n                                           ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                    <label for="chronic-med"></label>\r\n                                </div>\r\n                            </div>\r\n                            <hr />\r\n                            <div class="flexbox flexbox-horizontal-center">\r\n                                <div>\r\n                                    {{::\'Include Monograph\' | translate}}\r\n                                </div>\r\n                                <div class="flexbox-pull-right">\r\n                                    <input type="checkbox" name="include-monograph" id="include-monograph"\r\n                                           ng-model="$ctrl.optionsNonFormulary.includeMonograph"\r\n                                           ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                    <label for="include-monograph"></label>\r\n                                </div>\r\n                            </div>\r\n                            <div ng-show="$ctrl.shouldDisplayEpaSpoCheckbox">\r\n                                <hr />\r\n                                <div class="flexbox flexbox-horizontal-center">\r\n                                    <div>\r\n                                        {{::\'Electronic Prior Authorization\' | translate}}\r\n                                    </div>\r\n                                    <div class="flexbox-pull-right">\r\n                                        <input type="checkbox" name="send-prior-auth" id="send-prior-auth"\r\n                                            ng-model="$ctrl.optionsNonFormulary.sendPriorAuth"\r\n                                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                        <label for="send-prior-auth"></label>\r\n                                    </div>\r\n                                </div>\r\n                                <hr />\r\n                                <div class="flexbox flexbox-horizontal-center">\r\n                                    <div>\r\n                                        {{::\'Specialty Patient Enrollment\' | translate}}\r\n                                    </div>\r\n                                    <div class="flexbox-pull-right">\r\n                                        <input type="checkbox" name="send-is-specialty" id="send-is-specialty"\r\n                                            ng-model="$ctrl.optionsNonFormulary.sendIsSpecialty"\r\n                                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                        <label for="send-is-specialty"></label>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="row" ng-if="!$ctrl.rxParameters.isFixedPharmacy">\r\n            <div class="col-xs-12">\r\n                <div class="form-group">\r\n                    <label class="control-label">{{::\'Internal Note\' | translate}} </label>\r\n                    <ap-select>\r\n                        <select class="form-control"\r\n                                name="NotesList"\r\n                                ng-model="$ctrl.notesList.Note"\r\n                                ng-options="generalNote.Notes as generalNote.Name for generalNote in $ctrl.generalNotes"\r\n                                ng-change="$ctrl.notesListChanged()">\r\n                        </select>\r\n                    </ap-select>\r\n                    <br>\r\n                    <textarea\r\n                            name="PharmacyNote"\r\n                            class="form-control"\r\n                            ng-model="$ctrl.optionsNonFormulary.internalNote"\r\n                            ap-auto-grow\r\n                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                    </textarea>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</form>\r\n'),$templateCache.put("/sigwriter/views/modals/dosing-calculator-modal.html",'<div class="modal-noborder" ap-full-modal>\r\n    <div class="modal-header">\r\n        Calculate Dosing\r\n        <button id="dcm-close-x"\r\n                type="button"\r\n                class="close"\r\n                ng-click="vm.cancel()">\r\n            &times;\r\n        </button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <dosing-calculator data-age-in-days="vm.ageInDays"\r\n                             data-dose-type-indicator="vm.doseTypeIndicator"\r\n                             data-frequency-per-day="vm.frequencyPerDay"\r\n                             data-gcn-seq-no="vm.gcnSeqNo"\r\n                             data-gestational-age="vm.gestationalAge"\r\n                             data-height-cm="vm.heightCm"\r\n                             data-height-date="vm.heightDate"\r\n                             data-icd-code="vm.icdCode"\r\n                             data-med-id="vm.medId"\r\n                             data-patient-id="vm.patientId"\r\n                             data-visit-id="vm.visitId"\r\n                             data-weight-date="vm.weightDate"\r\n                             data-weight-kg="vm.weightKg"/>\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button">\r\n        <button id="dcm-close"\r\n                type="button"\r\n                class="btn btn-primary"\r\n                ng-click="vm.done()"\r\n                translate>\r\n            Close\r\n        </button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/drug-consent-modal.html",'<div ap-full-modal class="modal-v18 modal-medication-consent">\r\n    <form ng-submit="vm.save(rxConsentForm)" name="rxConsentForm" novalidate>\r\n        <div class="modal-header">\r\n            <div class="row">\r\n                <div class="col-xs-8 heading-title modal-title">{{\'Rx Consent\' | translate}}</div>\r\n                <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n            </div>\r\n        </div>\r\n        <div class="modal-body">\r\n            <div class="form-group">\r\n                <label translate>How Discussed</label>\r\n                <div class="row col-xs-12">\r\n                    <input type="checkbox" id="cbOption" ng-model="vm.inPerson" ng-change="vm.telephone=false; vm.telemedicine=false; vm.previously=false;"\r\n                        ap-checkbox/>\r\n                    <label for="cbOption">In-Person</label>\r\n                </div>\r\n\r\n                <div class="row col-xs-12">\r\n                    <input type="checkbox" id="cbOption2" ng-model="vm.telephone" ng-change="vm.inPerson=false; vm.telemedicine=false; vm.previously=false;"\r\n                        ap-checkbox/>\r\n                    <label for="cbOption2">Telephone</label>\r\n                </div>\r\n                <div class="row col-xs-12">\r\n                    <input type="checkbox" id="cbOption3" ng-model="vm.telemedicine" ng-change="vm.inPerson=false; vm.telephone=false; vm.previously=false;"\r\n                        ap-checkbox/>\r\n                    <label for="cbOption3">Telemedicine</label>\r\n                </div>\r\n                <div class="row col-xs-12">\r\n                    <input type="checkbox" id="cbOption4" ng-model="vm.previously" ng-change="vm.inPerson=false; vm.telephone=false; vm.telemedicine=false;"\r\n                        ap-checkbox/>\r\n                    <label for="cbOption4">Previously</label>\r\n                </div>\r\n            </div>\r\n            <div class="row"></div>\r\n\r\n            <div class="row">\r\n                <div class="col col-xs-12">\r\n                    <div class="form-group">\r\n                        <label for="symptomtext">\r\n                            <a class="clickable underline" ng-click="vm.onClickSymptom()" id="mc-symptom-link">\r\n                                {{::\'Symptom\' | translate}}\r\n                            </a>\r\n                        </label>\r\n                        <input type="text" name="symptomtext" class="form-control" ng-model="vm.symptom" ap-required="true" />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row">\r\n                <div class="col col-xs-12">\r\n                    <div class="form-group">\r\n                        <label for="formattingmodel" translate>Formatting Model</label>\r\n                        <input type="text" name="formattingmodel" ng-model="vm.formattingTemplateName" class="form-control" readonly="true" />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n            <button type="button" class="btn btn-primary" ng-click="vm.cancel()">{{::\'Cancel\' | translate}}</button>\r\n            <button type="submit" class="btn btn-primary">{{::\'Save\' | translate}}</button>\r\n        </div>\r\n    </form>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/drug-consent-warning-modal.html",'<div id="drug-consent-warning" ap-full-modal>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="$dismiss(\'\')">&times;</button>\r\n        <h4 class="modal-title">Patient Consent Required</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <uib-alert type="danger">\r\n                    {{drugConsentWarning.drugName}}\r\n                    <span translate>\r\n                        cannot be prescribed because it requires patient consent. Aprima NOW does not support drugs which require patient consent.\r\n                    </span>\r\n                </uib-alert>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id="drug-consent-warning-footer" class="modal-footer">\r\n        <button type="submit" class="btn btn-default" ng-click="$dismiss(\'close\')">Close</button>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/sigwriter/views/modals/drug-detail-modal.html",'<div id="drug-detail" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title" translate>Medication Detail</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <sigwriter-wizard-drug-detail\r\n            med-id="vm.medId"\r\n            patient-id="vm.patientId"\r\n            rel-patient-medication-id="vm.relPatientMedicationId"\r\n            sig-id="vm.sigId"\r\n            rx-id="vm.rxId"\r\n            search-update="vm.searchUpdate(searchText)"\r\n            search-enabled="vm.searchEnabled"\r\n        />\r\n        <div ng-if="vm.showDosingContent()" >\r\n            <sigwriter-wizard-dosing-content\r\n                rx-parameters="vm.rxParameters"\r\n                sig-instruction="vm.sigInstruction"\r\n                on-suggestion-changed="vm.selectDosingSuggestion(suggestion, instructionId)"\r\n            />\r\n        </div>\r\n    </div>\r\n    <div id="drug-detail-footer" class="modal-footer">\r\n        <button class="btn btn-default" ng-click="vm.close()" translate>Close</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/drug-documentation-modal.html",'<div id="drug-documentation" ap-full-modal class="modal-v18">\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title" translate>Drug Documentation</h4>\r\n    </div>\r\n    <div class="modal-body pdr-modal-body">\r\n        <sigwriter-wizard-pdr\r\n            drug="vm.drug"\r\n            patient="vm.patient"\r\n            rx-id="vm.rxId"\r\n        />\r\n    </div>\r\n    <div class="modal-footer">\r\n        <button class="btn btn-primary" ng-click="vm.close()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/drug-dosing-modal.html",'<div ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button id="ddm-close-x" type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title" translate>Drug Dosing Suggestion</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <sigwriter-wizard-dosing-content\r\n            rx-parameters="vm.rxParameters"\r\n            sig-instruction="vm.sigInstruction"\r\n            on-suggestion-changed="vm.selectDosingSuggestion(suggestion, instructionId)"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/drug-screening-modal.html",'<div ap-full-modal ap-full-modal-always>\r\n    <wizard name="{{vm.wizardName}}" on-finish="vm.onFinish()" hide-indicators="true">\r\n        <div class="modal-header">\r\n            <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n            <h4 class="modal-title">{{vm.getStepTitle()}}</h4>\r\n        </div>\r\n        <div class="modal-body">\r\n            <wz-step wz-title="{{::vm.lookups.screeningTitle}}">\r\n                <sigwriter-wizard-screening-content\r\n                    rx-parameters="vm.rxParameters"\r\n                    update-drug-screening="vm.updateDrugScreening(drugScreening)"\r\n                    update-is-screening-loaded="vm.updateIsScreeningLoaded(isLoaded, isOverrideRequired, status)"\r\n                />\r\n            </wz-step>\r\n            <wz-step wz-title="{{::vm.lookups.overrideTitle}}" wz-disabled="{{!vm.requiresOverride}}">\r\n                <sigwriter-wizard-screening-override\r\n                    drug-screening="vm.drugScreening"\r\n                    update-drug-screening="vm.updateDrugScreening(drugScreening)"\r\n                />\r\n            </wz-step>\r\n        </div>\r\n        <div class="modal-footer">\r\n            <div class="row">\r\n                <div class="col-xs-6">\r\n                    <button id="previous-btn" type="submit" class="btn-modal btn-default"\r\n                            ng-hide="(vm.getWizard().currentStepNumber() === 1)"\r\n                            wz-previous>\r\n\r\n                        Back\r\n                    </button>\r\n                </div>\r\n                <div class="col-xs-6">\r\n                    <button id="next-btn" type="submit" class="btn-modal btn-default"\r\n                            ng-hide="(vm.getWizard().currentStepNumber() === vm.getWizard().getEnabledSteps().length)"\r\n                            wz-next>\r\n\r\n                        Next\r\n                    </button>\r\n                    <button id="finish-btn" type="submit" class="btn-modal btn-default"\r\n                            ng-show="(vm.getWizard().currentStepNumber() === vm.getWizard().getEnabledSteps().length)"\r\n                            ng-disabled="!vm.isScreeningLoaded"\r\n                            wz-finish>\r\n\r\n                        Finish\r\n                    </button>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </wizard>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/dx-problems-modal.html",'<div class="modal-noborder" ap-full-modal>\r\n    <div class="modal-header">\r\n        Active Dx & Problems ({{vm.countSelected()}})\r\n        <button id="dpm-close-x"\r\n                type="button"\r\n                class="close"\r\n                ng-click="vm.cancel()">\r\n            &times;\r\n        </button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <uib-alert type="danger"\r\n                   ng-if="vm.httpError"\r\n                   translate\r\n                   class="alert-flush">\r\n            There was an error loading the patient\'s diagnoses and problems.\r\n        </uib-alert>\r\n        <div ng-if="!vm.httpError">\r\n            <div ng-repeat="item in vm.items | orderBy: vm.getItemOrder track by item.Uid"\r\n                 class="checkbox checkbox-sm-wrapper">\r\n                <label>\r\n                    <input type="checkbox"\r\n                           class="checkbox-sm"\r\n                           ap-checkbox\r\n                           id="dx-problem-{{$index}}"\r\n                           ng-model="item.selected">\r\n                    {{vm.formatter(item)}}\r\n                </label>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button">\r\n        <button id="dpm-clear"\r\n                type="button"\r\n                class="btn btn-default"\r\n                ng-click="vm.clear()">\r\n            Clear\r\n        </button>\r\n        <button id="dpm-done"\r\n                type="button"\r\n                class="btn btn-primary"\r\n                ng-click="vm.done()"\r\n                translate>\r\n            Done\r\n        </button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/newDefaultSigModal.html",'<div ap-full-modal class="modal-v18">\r\n    <form ng-submit="vm.ok(newDefaultSigForm)" name="newDefaultSigForm" novalidate>\r\n        <div class="modal-header">\r\n            <div class="row">\r\n                <div class="col-xs-8 heading-title modal-title">{{\'New Default SIG\' | translate}}</div>\r\n                <button id="ndsm-close-x" type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n            </div>\r\n        </div>\r\n        <div class="modal-body">\r\n            <div class="row">\r\n                <div class="col col-xs-4">\r\n                    <div class= "form-group">\r\n                        <label for="ExternalId">{{\'ID\' | translate}}</label>\r\n                        <input \r\n                            type="text" \r\n                            id="new-default-sig-id" \r\n                            ng-model="vm.externalId" \r\n                            class="form-control"\r\n                            name= "ExternalId"\r\n                            ap-metadata="vm.metadata.Fields.ExternalId">\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="col col-xs-12">\r\n                    <div class="form-group">\r\n                        <label for="Name">{{\'Name\' | translate}}</label>\r\n                        <input \r\n                            type="text" \r\n                            id="new-default-sid-name" \r\n                            ng-model="vm.name" \r\n                            class="form-control"\r\n                            name= "Name"\r\n                            ap-metadata="vm.metadata.Fields.Name">\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="col col-xs-12">\r\n                    <div class= "form-group">\r\n                        <label for="Notes">{{\'Notes\' | translate}}</label>\r\n                        <input \r\n                            type="text" \r\n                            id="new-default-sid-notes" \r\n                            ng-model="vm.notes" \r\n                            class="form-control"\r\n                            name= "Notes"\r\n                            ng-disabled="true"\r\n                            ap-metadata="vm.metadata.Fields.Notes">\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n            <button id="ndsm-cancel" type="button" class="btn btn-primary" ng-click="vm.cancel()">{{\'Cancel\' | translate}}</button>\r\n            <button id="ndsm-save" type="submit" class="btn btn-primary"><span ng-hide="vm.loading">{{\'Save\' | translate}}</span><ap-spinner ng-show="vm.loading"></ap-spinner></button>\r\n        </div>\r\n    </form>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/required-screens-modal.html",'<div id="required-screens" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.close()">&times;</button>\r\n        <h4 class="modal-title" translate>Required Screens</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <h4 translate>These pages must be viewed:</h4>\r\n        <div ng-repeat="title in vm.titles">\r\n            <a class="clickable" ng-click="vm.selectTitle(title)">\r\n                {{title}}\r\n            </a>\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer">\r\n        <button class="btn btn-primary" ng-click="vm.close()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/save-rx-modal.html",'<div id="save-rx" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title" translate>Save Rx</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <div ng-show="vm.saving" class="text-center">\r\n            <ap-spinner size="3"></ap-spinner>\r\n        </div>\r\n\r\n        <div id="save-rx-error" ng-if="vm.errorMessages">\r\n            <h4 translate>Error saving Rx:</h4>\r\n            <span ng-repeat="errorText in vm.errorMessages track by $index"><br>{{errorText}}</span>\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer">\r\n        <button class="btn btn-primary" ng-click="vm.cancel()" ng-disabled="vm.saving" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/sigwriterAdditionalInfoModal.html",'<div class="desktop-form" id="sig-additional-info-modal">\r\n    <div class="modal-header">\r\n        <button id="saim-close-x" type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title">{{vm.getTitle()}}</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <div class="form-group" ng-hide="vm.optionsNonFormulary.isSampleGiven">\r\n            <label for="medicationSite">{{ \'Site\' | translate }}</label>\r\n            <ap-select>\r\n                <select id="medicationSite" name="medicationSite"\r\n                        class="form-control"\r\n                        ng-model="vm.optionsNonFormulary.medicationSite"\r\n                        ng-options="site.Name for site in vm.rxOptions.additionalMedInfo.medicationSites track by site.Id">                                \r\n                </select>\r\n            </ap-select>\r\n        </div>\r\n        <div class="form-group">\r\n            <label for="lotNumber">{{ \'Lot #\' | translate }}</label>\r\n            <input type="text"\r\n                   id="lotNumber"\r\n                   class="form-control"\r\n                   ng-model="vm.optionsNonFormulary.lotNumber"\r\n                   ap-metadata="vm.rxOptions.metadata.sig.Fields.LotNumber"\r\n                   maxlength="{{vm.rxOptions.metadata.sig.Fields.LotNumber.MaxLength}}"/>\r\n        </div>\r\n        <div class="form-group">\r\n            <label for="manufacturer">{{ \'Manufacturer\' | translate }}</label>\r\n            <ap-select>\r\n                <select id="manufacturer" name="manufacturer"\r\n                        class="form-control"\r\n                        ng-model="vm.optionsNonFormulary.manufacturer"\r\n                        ng-options="manufacturer.Name for manufacturer in vm.rxOptions.additionalMedInfo.manufacturers track by manufacturer.Id">                                \r\n                </select>\r\n            </ap-select>\r\n        </div>\r\n        <div class="form-group" ng-hide="vm.optionsNonFormulary.isSampleGiven">\r\n            <label for="fundingSource">{{ \'Funding Source\' | translate }}</label>\r\n            <ap-select>\r\n                <select id="fundingSource" name="fundingSource"\r\n                        class="form-control"\r\n                        ng-model="vm.optionsNonFormulary.fundingSource"\r\n                        ng-options="fundingSource.Name for fundingSource in vm.rxOptions.additionalMedInfo.fundingSources track by fundingSource.Id">                                \r\n                </select>\r\n            </ap-select>\r\n        </div>\r\n        <div class="form-group">\r\n            <label for="expirationDate">{{ \'Expiration Date\' | translate }}</label>\r\n            <input type="date"\r\n                   class="form-control"\r\n                   id="expirationDate"\r\n                   ng-model="vm.optionsNonFormulary.expirationDate"\r\n                   ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }">\r\n            </input>\r\n        </div>\r\n        <div class="form-group" ng-hide="vm.optionsNonFormulary.isSampleGiven">\r\n            <label for="initials">{{ \'Initials\' | translate }}</label>\r\n            <input type="text"\r\n                   id="initials"\r\n                   class="form-control"\r\n                   ng-model="vm.optionsNonFormulary.initials"\r\n                   ap-metadata="vm.rxOptions.metadata.sig.Fields.Initials"\r\n                   maxlength="{{vm.rxOptions.metadata.sig.Fields.Initials.MaxLength}}"/>\r\n        </div>\r\n        <div class="form-group" ng-hide="vm.optionsNonFormulary.isSampleGiven">\r\n            <label for="administeredDate">{{ \'Administration Date\' | translate }}</label>\r\n            <input type="date"\r\n                   class="form-control"\r\n                   id="administeredDate"\r\n                   ng-model="vm.optionsNonFormulary.administeredDateTime"\r\n                   ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }">\r\n        </div>\r\n        <div class="form-group" ng-hide="vm.optionsNonFormulary.isSampleGiven">\r\n            <label for="administeredTime">{{ \'Administration Time\' | translate }}</label>\r\n            <input type="time"\r\n                   class="form-control"\r\n                   id="administeredTime"\r\n                   ng-model="vm.optionsNonFormulary.administeredDateTime"\r\n                   ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }">\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n        <button id="saim-cancel" class="btn btn-primary" ng-click="vm.cancel()" translate>Cancel</button>\r\n        <button id="saim-ok" class="btn btn-primary" ng-click="vm.ok()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/sigwriterFormularyDetailsModal.html",'<div id="formulary-details-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <sigwriter-formulary-details\r\n            details="vm.details"\r\n            is-info-available="vm.isInfoAvailable"\r\n            on-drug-selected="vm.changeMedication(drug, pharmacy)"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/sigwriterRxBenefitDetailsModal.html",'<div id="rx-benefit-details-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <patient-rx-benefit-details\r\n            eligibility="vm.eligibility"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/sigwriterScreeningModal.html",'<div id="sig-screening-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button id="ssm-close-x" type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title" translate>Drug Screening</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <div id="drug-screening-loading" ng-if="vm.loadingDrugScreening">\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    Performing Drug Screening\r\n                    <br/>\r\n                    <ap-spinner data-size="3"></ap-spinner>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div id="drug-screening-error" ng-if="!vm.loadingDrugScreening && vm.nddScreeningErrorMessages">\r\n            <h4 translate>Error Performing Drug Screening:</h4>\r\n            <span ng-repeat="errorText in vm.nddScreeningErrorMessages track by $index"><br>{{errorText}}</span>\r\n        </div>\r\n        <div id="drug-screening-alerts" ng-if="!vm.loadingDrugScreening && !vm.nddScreeningErrorMessages">\r\n            <div class="screening-content">\r\n                <ndd-detailed-drug-screening\r\n                    screening="vm.nddScreening"\r\n                />\r\n            </div>\r\n            <div class="screening-override">\r\n                <div class="form-group">\r\n                    <label for="overrideReason">\r\n                        <a class="clickable underline"\r\n                           ng-click="vm.onClickOverrideReason()"\r\n                           translate>\r\n                            Reason for Override\r\n                        </a>\r\n                    </label>\r\n                    <textarea\r\n                        ng-model="vm.overrideText"\r\n                        class="textarea-full"\r\n                        id="overrideReason">\r\n                    </textarea>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n        <button id="ssm-cancel" class="btn btn-primary" ng-click="vm.cancel()" translate>Cancel</button>\r\n        <button id="ssm-ok" class="btn btn-primary" ng-click="vm.ok()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/sigwriterSigDetailsModal.html",'<div id="sig-details-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <form name="vm.tabletSigDetailsForm">\r\n            <sigwriter-tablet-sig-details\r\n                initial-field="vm.initialField"\r\n                patient-details="vm.patientDetails"\r\n                rx-options="vm.rxOptions"\r\n                rx-parameters="vm.rxParameters"\r\n                sig-instruction="vm.sigInstruction"\r\n                sig-options-non-formulary="vm.sigOptionsNonFormulary"\r\n                update-sig-instruction="vm.updateSigInstruction(updatedSigInstruction)"\r\n            >\r\n            </sigwriter-tablet-sig-details>\r\n        </form>\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n        <button class="btn btn-primary" ng-click="vm.cancel()" translate>Cancel</button>\r\n        <button class="btn btn-primary" ng-click="vm.ok()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/rxWizardDrugSearch.html",'<sigwriter-wizard-drug-search\r\n    defer-saving="vm.deferSaving"\r\n    patient-id="vm.patientId"\r\n    use-previous-search-text="vm.usePreviousSearchText"\r\n    on-drug-selected="vm.onDrugSelected(rx)"\r\n    on-existing-sig-selected="vm.onExistingSigSelected(rx)"\r\n/>'),$templateCache.put("/sigwriter/views/rxWizardRefill.html",'<div class="container-fluid search-unlocked" ng-cloak>\r\n    <div class="panel panel-default" ng-show="!vm.$scope.httpError">\r\n        <div class="panel-body">\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    <span ng-show="vm.loadingRefill">\r\n                        Preparing Refill...\r\n                    </span>\r\n                    <br/>\r\n                    <ap-spinner size="3"></ap-spinner>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="panel panel-default ng-hide" ng-show="vm.$scope.httpError">\r\n        <div class="panel-heading" translate>\r\n            New Rx Refill\r\n        </div>\r\n        <div class="panel-body">\r\n            <div class="row">\r\n                <div class="col-xs-12" ng-show="vm.$scope.httpError.unhandled">\r\n                    <uib-alert type="danger">\r\n                        {{::"An error has occurred and the SIG could not be loaded." | translate}}\r\n                    </uib-alert>\r\n                </div>\r\n                <div class="col-xs-12" ng-show="vm.$scope.httpError.is403">\r\n                    <uib-alert type="danger">\r\n                        {{::\'You do not have access to this SIG.\' | translate}}\r\n                    </uib-alert>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/sigwriterDrugDosageSearchModal.html",'<div ap-full-modal ap-full-modal-always class="modal-v18">\r\n    <div class="modal-header">\r\n        <div class="row">\r\n            <div class="col-xs-8 heading-title modal-title">{{::\'Select Strength\' | translate}}</div>\r\n            <button id="sddsm-close-x" type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        </div>\r\n    </div>\r\n    <div class="modal-body modal-body-no-padding">\r\n        <sigwriter-tablet-drug-dosage-search\r\n            ng-if="vm.useAlternatives"\r\n            drug="vm.drug"\r\n            patient-id="vm.patientId"\r\n            provider-id="vm.providerId"\r\n            sig-type="vm.sigType"\r\n            on-drug-selected="vm.onDrugSelected({dosingSuggestion: dosingSuggestion, drugSearchResult: drugSearchResult, switchToGeneric: switchToGeneric, useEnhancedDrugSearch: useEnhancedDrugSearch})"\r\n        />\r\n        <sigwriter-tablet-drug-search\r\n            ng-if="!vm.useAlternatives"\r\n            patient-id="vm.patientId"\r\n            use-previous-search-text="false"\r\n            select-drug-search-result="vm.onDrugSelected({dosingSuggestion: dosingSuggestion, drugSearchResult: drugSearchResult, switchToGeneric: switchToGeneric, useEnhancedDrugSearch: useEnhancedDrugSearch})"\r\n        />\r\n    </div>\r\n</div>\r\n')}]),function(angular,defineProperties){"use strict";var mgToolTip="Enter the number of mgs to dose.";angular.module("aprima-sigwriter").component("dosingCalculator",{templateUrl:"/sigwriter/component-views/dosingCalculator.html",bindings:{ageInDays:"<",doseTypeIndicator:"<",frequencyPerDay:"<",gcnSeqNo:"<",gestationalAge:"<",heightCm:"<",heightDate:"<",icdCode:"<",medId:"<",patientId:"<",visitId:"<",weightDate:"<",weightKg:"<"},controller:["_","$q","debounce","DoseRangeUtil","DosingService","ErrorService","NumUtil","UnitConvert",function(_,$q,debounce,DoseRangeUtil,DosingService,ErrorService,NumUtil,UnitConvert){var vm=this;vm.errors=null,vm.patientInfoCollapsed=!1,vm.loadingDosingInfo=!1,vm.loadingPatientInfo=!1,vm.generalDosingInfo=null,vm.bsaEnabled=!1,vm.weightMetric=!0,vm.weightEnabled=!1,defineProperties(vm,{weightPrimary:{get:function(){if(vm.weightMetric)return weightValueKg;return weightValueLbs},set:function(value){if(vm.weightMetric)return void(weightValueKg=value);weightValueLbs=value}},weightSecondary:{get:function(){return weightValueOz},set:function(value){weightValueOz=value}}});var currentCalcKg,currentCalcLbs,currentCalcOz,weightValueKg=null,weightValueLbs=null,weightValueOz=null;vm.heightMetric=!0,vm.heightEnabled=!1,defineProperties(vm,{heightPrimary:{get:function(){if(vm.heightMetric)return heightValueCm;return heightValueFt},set:function(value){if(vm.heightMetric)return void(heightValueCm=value);heightValueFt=value}},heightSecondary:{get:function(){return heightValueIn},set:function(value){heightValueIn=value}}});var currentCalcCm,currentCalcFt,currentCalcIn,heightValueCm=null,heightValueFt=null,heightValueIn=null,singleDosingInfo=null;vm.dosingMgEnabled=!1,vm.dosingMgUnits="mg",vm.dosingMgToolTip=mgToolTip,vm.dosingMg=null,vm.dosingInfoByMg=null;var debouncedUpdateDosingInformation=debounce(300,function(){var weight=getCurrentWeightKg(),height=getCurrentHeightCm();vm.loadingDosingInfo=!0,DosingService.getDoseRangeInfo(vm.ageInDays,vm.medId,vm.gcnSeqNo,weight,height,vm.gestationalAge,vm.doseTypeIndicator,vm.icdCode).then(function(dosingInfo){vm.errors=null,singleDosingInfo=dosingInfo,vm.generalDosingInfo=singleDosingInfo.MaxMinInformation,updateInfoByMg()}).catch(function(response){vm.errors=ErrorService.convertToErrorMessages(response)}).finally(function(){vm.loadingDosingInfo=!1,vm.bsaEnabled=DoseRangeUtil.allowsBsaAdjustment(singleDosingInfo,vm.ageInDays),vm.dosingMgEnabled=DoseRangeUtil.canCalculateByMg(singleDosingInfo),vm.weightEnabled=!0,vm.heightEnabled=!0,singleDosingInfo&&singleDosingInfo.WeightRequired?(vm.heightEnabled=!1,vm.dosingMgUnits="mg per kg",vm.dosingMgToolTip="Enter the number of mgs per kg to dose."):vm.bsaEnabled?(vm.dosingMgUnits="single dose mg per 1.73 m2 (bsa)",vm.dosingMgToolTip="Enter the number of milligrams in a single dose."):(vm.dosingMgUnits="mg",vm.dosingMgToolTip=mgToolTip)})}),debouncedUpdateInfoByMg=debounce(300,updateInfoByMg);function updateInfoByMg(){singleDosingInfo&&(vm.dosingInfoByMg=DoseRangeUtil.CalculateDosingInformation(singleDosingInfo,vm.frequencyPerDay,vm.dosingMg))}function setCalculatedWeightKg(value){weightValueKg=currentCalcKg=value}function setCalculatedWeightLbs(value){weightValueLbs=currentCalcLbs=value}function setCalculatedWeightOz(value){weightValueOz=currentCalcOz=value}function setCalculatedHeightCm(value){heightValueCm=currentCalcCm=value}function setCalculatedHeightFt(value){heightValueFt=currentCalcFt=value}function setCalculatedHeightIn(value){heightValueIn=currentCalcIn=value}function getCurrentWeightKg(){var currentWeight=weightValueKg;return currentWeight&&(vm.weightMetric||weightValueLbs===currentCalcLbs&&weightValueOz===currentCalcOz)||(setCalculatedWeightLbs(weightValueLbs),setCalculatedWeightOz(weightValueOz),setCalculatedWeightKg(currentWeight=UnitConvert.usToKgRounded(weightValueLbs,weightValueOz))),currentWeight=currentWeight||0}function getCurrentHeightCm(){var currentHeight=heightValueCm;return currentHeight&&(vm.heightMetric||heightValueFt===currentCalcFt&&heightValueIn===currentCalcIn)||(setCalculatedHeightFt(heightValueFt),setCalculatedHeightIn(heightValueIn),setCalculatedHeightCm(currentHeight=UnitConvert.usToCmRounded(heightValueFt,heightValueIn))),currentHeight=currentHeight||0}function updatePatientDetails(getPromiseFn,id){getPromiseFn&&id&&(vm.loadingPatientInfo=!0,getPromiseFn(id).then(function(data){data&&(vm.ageInDays=data.AgeInDays,vm.weightKg=data.WeightInKg,vm.weightDate=data.WeightPerformedDate,vm.heightCm=data.HeightInCm,vm.heightDate=data.HeightPerformedDate)}).finally(function(){setCalculatedWeightKg(UnitConvert.roundKg(vm.weightKg)),vm.weightMetric=!0,setCalculatedHeightCm(UnitConvert.roundCm(vm.heightCm)),vm.heightMetric=!0,debouncedUpdateDosingInformation(),vm.loadingPatientInfo=!1}))}vm.$onChanges=function(changeObj){if(visitId=changeObj.visitId&&changeObj.visitId.currentValue,patientId=changeObj.patientId&&changeObj.patientId.currentValue,!visitId||vm.ageInDays&&vm.weightKg&&vm.heightCm?patientId&&!(vm.ageInDays&&vm.weightKg&&vm.heightCm)&&(updatePatientDetails(DosingService.getPatientDosingDetails,patientId),1):(updatePatientDetails(DosingService.getVisitDosingDetails,visitId),1))return;var visitId,patientId;var weightUpdated=!1,heightUpdated=!1;changeObj.weightKg&&(setCalculatedWeightKg(UnitConvert.roundKg(changeObj.weightKg.currentValue)),vm.weightMetric=!0,weightUpdated=!0);changeObj.heightCm&&(setCalculatedHeightCm(UnitConvert.roundCm(changeObj.heightCm.currentValue)),vm.heightMetric=!0,heightUpdated=!0);changeObj.ageInDays||changeObj.medId||changeObj.gcnSeqNo||changeObj.gestationalAge||changeObj.doseTypeIndicator||changeObj.icdCode||weightUpdated||heightUpdated?debouncedUpdateDosingInformation():changeObj.frequencyPerDay&&debouncedUpdateInfoByMg()},vm.changeHeightSystem=function(){if(vm.heightMetric&&!heightValueFt&&!heightValueIn)return void setCalculatedHeightCm(0);if(!vm.heightMetric&&!heightValueCm)return setCalculatedHeightFt(0),void setCalculatedHeightIn(0);if(vm.heightMetric&&heightValueFt===currentCalcFt&&heightValueIn===currentCalcIn&&angular.isNumber(heightValueCm))return;if(!vm.heightMetric&&heightValueCm===currentCalcCm&&(angular.isNumber(heightValueFt)||angular.isNumber(heightValueIn)))return setCalculatedHeightFt(heightValueFt||0),void setCalculatedHeightIn(heightValueIn||0);if(vm.heightMetric){var totalCm=UnitConvert.usToCmRounded(heightValueFt,heightValueIn);setCalculatedHeightCm(totalCm)}else{var values=UnitConvert.cmToUsRounded(heightValueCm);setCalculatedHeightFt(values.feet),setCalculatedHeightIn(values.inches)}},vm.changeWeightSystem=function(){if(vm.weightMetric&&!weightValueLbs&&!weightValueOz)return void setCalculatedWeightKg(0);if(!vm.weightMetric&&!weightValueKg)return setCalculatedWeightLbs(0),void setCalculatedWeightOz(0);if(vm.weightMetric&&weightValueLbs===currentCalcLbs&&weightValueOz===currentCalcOz&&angular.isNumber(weightValueKg))return;if(!vm.weightMetric&&weightValueKg===currentCalcKg&&(angular.isNumber(weightValueLbs)||angular.isNumber(weightValueOz)))return setCalculatedWeightLbs(weightValueLbs||0),void setCalculatedWeightOz(weightValueOz||0);if(vm.weightMetric){var totalKg=UnitConvert.usToKgRounded(weightValueLbs,weightValueOz);setCalculatedWeightKg(totalKg)}else{var values=UnitConvert.kgToUsRounded(weightValueKg);setCalculatedWeightLbs(values.pounds),setCalculatedWeightOz(values.ounces)}},vm.updateDosingInfo=debouncedUpdateDosingInformation,vm.changeMg=debouncedUpdateInfoByMg,vm.getBsa=function(){var bsa=UnitConvert.getBodySurfaceArea(getCurrentHeightCm(),getCurrentWeightKg());return NumUtil.format(bsa,"0.0[000]")}}],controllerAs:"vm"})}(window.angular,window.Object.defineProperties),function(){"use strict";angular.module("aprima-sigwriter").component("drugSearchList",{templateUrl:"/sigwriter/component-views/drugSearchList.html",bindings:{drugs:"<",hideDrugInformationIcon:"<",loading:"<",searched:"<",patientId:"<",sessionId:"<",useEnhancedDrugSearch:"<",onDrugSearchResultSelected:"&",updateSearchText:"&"},controller:["DrugDetailModal",function(DrugDetailModal){var vm=this;function selectDrug(drugSearchResult,switchToGeneric,dosingSuggestion){drugSearchResult.indicateSelected=!0,vm.onDrugSearchResultSelected({dosingSuggestion:dosingSuggestion,drugSearchResult:drugSearchResult,switchToGeneric:switchToGeneric})}vm.displayDrugDetail=function(drugSearchResult){DrugDetailModal.openDrugDetailModal(drugSearchResult.Drug,drugSearchResult.Drug.MedId,vm.patientId,drugSearchResult.RelPatientMedicationId,drugSearchResult.SigId,vm.sessionId,!0).then(function(result){result&&(result.searchText?vm.updateSearchText({searchText:result.searchText}):result.suggestion&&selectDrug(drugSearchResult,!1,result.suggestion))})},vm.selectDrug=selectDrug}]})}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("freeTextDirections",{templateUrl:"/sigwriter/component-views/freeTextDirections.html",transclude:!0,bindings:{textOpen:"=",textValue:"<"},controller:["$element","$timeout",function($element,$timeout){var elementToFocus,vm=this;vm.onClickOpen=function(){vm.textOpen=!0,$timeout(function(){elementToFocus&&elementToFocus.focus()})},vm.$postLink=function(){elementToFocus=$element.children("[ng-transclude]").children()[0]},vm.hasValue=function(){return!!vm.textValue}}],controllerAs:"vm"})}(),function(angular){"use strict";angular.module("aprima-sigwriter").component("nddCondensedDrugScreening",{templateUrl:"/sigwriter/component-views/nddCondensedDrugScreening.html",bindings:{error:"<",loading:"<",screening:"<"},controller:["SigwriterDrugScreeningService",function(SigwriterDrugScreeningService){this.getClassFromSeverity=SigwriterDrugScreeningService.getClassFromSeverity,this.getClassFromSeverityLevel=SigwriterDrugScreeningService.getClassFromSeverityLevel}]})}(angular),function(angular){"use strict";angular.module("aprima-sigwriter").component("nddDetailedDrugScreening",{templateUrl:"/sigwriter/component-views/nddDetailedDrugScreening.html",bindings:{error:"<",loading:"<",screening:"<"},controller:["SigwriterDrugScreeningService",function(SigwriterDrugScreeningService){var vm=this;vm.getClassFromSeverity=SigwriterDrugScreeningService.getClassFromSeverity,vm.getClassFromSeverityLevel=SigwriterDrugScreeningService.getClassFromSeverityLevel,vm.getGeriatricSeverityTitle=SigwriterDrugScreeningService.getGeriatricSeverityTitle,vm.getInteractionSeverityTitle=SigwriterDrugScreeningService.getInteractionSeverityTitle,vm.getLactationSeverityTitle=SigwriterDrugScreeningService.getLactationSeverityTitle,vm.getMedicalConditionSeverityTitle=SigwriterDrugScreeningService.getMedicalConditionSeverityTitle,vm.getPediatricSeverityTitle=SigwriterDrugScreeningService.getPediatricSeverityTitle,vm.getPregnancySeverityTitle=SigwriterDrugScreeningService.getPregnancySeverityTitle}]})}(angular),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterDrugIconGroup",{templateUrl:"/sigwriter/component-views/drugIconGroup.html",bindings:{drug:"<",drugWithFormulary:"<"},controller:[function(){var vm=this;vm.drug?(vm.genericTypeClass=getGenericTypeClass(vm.drug.AKAIndicator),vm.ePrescribeTypeClass=getEPrescribeClass(vm.drug.EPrescribeIndicator)):vm.drugWithFormulary&&(vm.genericTypeClass=getGenericTypeClass(vm.drugWithFormulary.AKAIndicator),vm.ePrescribeTypeClass=getEPrescribeClass(vm.drugWithFormulary.EPrescribeIndicator));function getGenericTypeClass(genericType){switch(genericType){case"Brand":return"ap-rxsearch-icon-brand";case"Generic":return"ap-rxsearch-icon-generic"}}function getEPrescribeClass(ePrescribeType){switch(ePrescribeType){case"Schedule0":return"ap-rxsearch-icon-schedule0";case"Schedule1":return"ap-rxsearch-icon-schedule1";case"Schedule2":return"ap-rxsearch-icon-schedule2";case"Schedule3":return"ap-rxsearch-icon-schedule3";case"Schedule4":return"ap-rxsearch-icon-schedule4";case"Schedule5":return"ap-rxsearch-icon-schedule5";default:return"ap-rxsearch-icon-noeprescribe"}}}]})}(),function(angular){"use strict";angular.module("aprima-sigwriter").component("sigwriterDrugSearch",{templateUrl:"/sigwriter/component-views/drugSearch.html",bindings:{includeNonDispensable:"<",initialSearchText:"<",patientId:"<",usePreviousSearchText:"<",onDrugSearchResultSelected:"&"},controller:["$q","_","debounce","DrugRepository","ErrorService","PatientRepository","ServerInfoRepository","SigwriterRxService","uxConstants",function($q,_,debounce,DrugRepository,ErrorService,PatientRepository,ServerInfoRepository,SigwriterRxService,uxConstants){var vm=this,drugSearchPromises=[];function searchRx(override){vm.searchRx.cancel();var newSearchText=vm.searchText;newSearchText?(override||newSearchText!==previousSearchText)&&(previousSearchText=newSearchText,drugSearchPromises=[DrugRepository.search(newSearchText+(vm.includeInactive?" INACTIVE":""),vm.patientId,drugSearchPromises,vm.includeNonDispensable)],vm.loading++,drugSearchPromises[0].then(function(results){vm.drugs=results,vm.searched=!0,vm.loadError=null}).catch(function(err){vm.loadError=ErrorService.convertToErrorMessages(err)}).finally(function(){vm.loading--})):(drugSearchPromises=[],vm.loading++,previousSearchText=newSearchText,vm.patientId?vm.useEnhancedDrugSearch?drugSearchPromises.push(DrugRepository.getPatientActiveDrugs(vm.patientId)):drugSearchPromises.push(PatientRepository.getMedications(vm.patientId).then(function(results){return _.map(results,function(r){return{ResultType:"Patient",Drug:r.Drug,SigId:r.MedicationSigId,SigText:r.Description,RelPatientMedicationId:r.RelPatientMedicationId}})})):drugSearchPromises.push($q.when([])),drugSearchPromises.push(DrugRepository.getMfuDrugs()),$q.all(drugSearchPromises).then(function(results){var patientMeds=results[0],mfuDrugs=_.map(results[1],function(r){return{CanBePrescribed:!0,Drug:r,ResultType:"Mfu"}});vm.drugs=patientMeds.concat(mfuDrugs),vm.searched=!1,vm.loadError=null}).catch(function(err){vm.loadError=ErrorService.convertToErrorMessages(err)}).finally(function(){vm.loading--}))}vm.drugs=[],vm.includeInactive=!1,vm.loadError=null,vm.loading=0,vm.searched=!1,vm.searchText="",vm.sessionId="",vm.useEnhancedDrugSearch=!1,vm.inactiveIncludeChange=function(){searchRx(!0)},vm.searchRx=debounce(uxConstants.searchDebounceTime,searchRx),vm.selectDrugSearchResult=function(drugSearchResult,switchToGeneric,dosingSuggestion){vm.onDrugSearchResultSelected({dosingSuggestion:dosingSuggestion,drugSearchResult:drugSearchResult,switchToGeneric:switchToGeneric,useEnhancedDrugSearch:vm.useEnhancedDrugSearch})},vm.updateSearchText=function(searchText){vm.searchText=searchText,searchRx(!0)},function(){vm.usePreviousSearchText?vm.searchText=previousSearchText:vm.initialSearchText&&(vm.searchText=vm.initialSearchText);vm.sessionId=SigwriterRxService.newId(),vm.useEnhancedDrugSearch=ServerInfoRepository.isFeatureSupported(["EnhancedDrugSearch"]),searchRx(!0)}()}]});var previousSearchText=""}(angular),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterDxProblems",{templateUrl:"/core-ui/component-views/ap-multi-select-button.html",bindings:{ngDisabled:"&",patientId:"<"},require:{ngModelCtrl:"ngModel"},controller:["$element","ApMultiSelectButton","DxProblemsModal",function($element,ApMultiSelectButton,DxProblemsModal){var vm=this;function formatter(value){if(!value)return null;var code=value.Icd10Code||value.Icd9Code,description=(code?code+" - ":"")+value.Name;return description}function getOrder(item){if(!item)return"2";var order=""+(item.IsProblem?1:0)+(item.Name&&item.Name.toLowerCase());return order}ApMultiSelectButton.init(vm,function(selectedItems){return DxProblemsModal.openModal(vm.patientId,selectedItems,formatter,getOrder)},formatter,getOrder,$element.find("button"))}],controllerAs:"vm"})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterEpcsSignature",{templateUrl:"/sigwriter/component-views/epcsSignature.html",bindings:{epcsModel:"=",siteId:"<"},controller:["LocalStorageRepository","SettingRepository","$q",function(LocalStorageRepository,SettingRepository,$q){var vm=this;vm.epcsModel={};var promises=[LocalStorageRepository.getUserName(),LocalStorageRepository.getUserID(),LocalStorageRepository.getDeviceId(),LocalStorageRepository.getUserFullName()];$q.all(promises).then(function(results){vm.epcsModel.loggedOnUser=results[0],vm.epcsModel.loggedOnUserId=results[1],vm.epcsModel.loggedOnDevice=results[2],vm.epcsModel.providerName=results[3],SettingRepository.getProviderEpcsSettings(results[1],vm.siteId).then(function(result){vm.epcsModel.providerDeaNumber=(result||{}).DeaNumber})})}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterFormularyDetails",{templateUrl:"/sigwriter/component-views/formularyDetails.html",bindings:{details:"<",error:"<",hideTransmitStatus:"<",isInfoAvailable:"<",loading:"<",onDrugSelected:"&"},controller:["toaster",function(toaster){var vm=this;vm.showResponseXml=!1,vm.showRFSResponseXml=!1,vm.changeMedication=function(med,pricingCoverage){if(!med.Drug)return void toaster.pop("error","","'"+med.Description+"' is an unknown drug in the system.");var pharmacy;pricingCoverage&&(pricingCoverage.Pharmacy&&pricingCoverage.Pharmacy.Id?pharmacy=pricingCoverage.Pharmacy:toaster.pop("warning","","'"+pricingCoverage.PharmacyName+"' is an unknown pharmacy in the system."));vm.onDrugSelected({drug:med.Drug,pharmacy:pharmacy})}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterFormularyDisplay",{templateUrl:"/sigwriter/component-views/formularyDisplay.html",bindings:{details:"<",error:"<",isInfoAvailable:"<",loading:"<",onDrugSelected:"&"},controller:["toaster",function(toaster){var vm=this;vm.changeMedication=function(med,pricingCoverage){if(!med.Drug)return void toaster.pop("error","","'"+med.Description+"' is an unknown drug in the system.");var pharmacy;pricingCoverage&&(pricingCoverage.Pharmacy&&pricingCoverage.Pharmacy.Id?pharmacy=pricingCoverage.Pharmacy:toaster.pop("warning","","'"+pricingCoverage.PharmacyName+"' is an unknown pharmacy in the system."));vm.onDrugSelected({drug:med.Drug,pharmacy:pharmacy})},vm.formularyStatusCertification=function(formularyStatus){return formularyStatus?"Formulary"===formularyStatus?"On Formulary/Non-Preferred":formularyStatus.length>="Preferred".length&&"Preferred"===formularyStatus.substring(0,"Preferred".length)?"On Formulary/"+formularyStatus:formularyStatus:"Formulary Status Not Available"},vm.formularyStatusShow=function(formularyStatus){return formularyStatus?"Formulary"===formularyStatus?"On Formulary":formularyStatus.length>="Preferred".length&&"Preferred"===formularyStatus.substring(0,"Preferred".length)?"On Formulary/"+formularyStatus:formularyStatus:"Formulary Status Not Available"},vm.hasAlternatives=function(){var i;if(vm.details.ResponsePMBC&&vm.details.ResponsePMBC.Medications)for(i=0;i<vm.details.ResponsePMBC.Medications.length;i++){if("Alternative"===vm.details.ResponsePMBC.Medications[i].MedicationAlternativeType)return!0;if("AlternativeSubstitute"===vm.details.ResponsePMBC.Medications[i].MedicationAlternativeType)return!0}if(vm.details.ResponseRFS&&vm.details.ResponseRFS.Medications)for(i=0;i<vm.details.ResponseRFS.Medications.length;i++){if("Alternative"===vm.details.ResponseRFS.Medications[i].MedicationAlternativeType)return!0;if("AlternativeSubstitute"===vm.details.ResponseRFS.Medications[i].MedicationAlternativeType)return!0}return!1}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterPmbcMedication",{templateUrl:"/sigwriter/component-views/pmbcMedication.html",bindings:{med:"<",showDrugIcons:"<",select:"&"},controller:["$sce",function($sce){var vm=this;vm.$sce=$sce,vm.onSelect=function(pricingCoverage){vm.select({med:vm.med,pricingCoverage:pricingCoverage})}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterRfsMedication",{templateUrl:"/sigwriter/component-views/rfsMedication.html",bindings:{med:"<",showDrugIcons:"<",select:"&"},controller:["$sce","aprgettext",function($sce,gettext){var vm=this;vm.$sce=$sce,vm.formatRestrictions=function(restrictions){if(restrictions){var restrictionCodes=restrictions.split("|");return _.map(restrictionCodes,function(restrictionCode){switch(restrictionCode){case"DE":return gettext("Product Coverage Exclusion");case"PA":return gettext("Prior Authorization");case"MN":return gettext("Medical Necessity");case"ST":return gettext("Step Therapy");case"GL":return gettext("Gender Limit");case"AL":return gettext("Age Limit");case"QL":return gettext("Quantity Limit");case"SM":return gettext("Step Medication")}}).reduce(function(formatted,value){return value&&(formatted&&(formatted+=", "),formatted+=value),formatted},"")}},vm.onSelect=function(){vm.select({med:vm.med})}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("rxFormularyDetails",{templateUrl:"/sigwriter/component-views/rxFormularyDetails.html",controller:["$rootScope","Bridge","$timeout","$sce","$window",function($rootScope,Bridge,$timeout,$sce,$window){var vm=this;function processDetails(detailData){detailData?(vm.details=detailData,vm.details.ResponsePMBC&&vm.details.ResponsePMBC.Medications&&vm.details.ResponsePMBC.Medications.forEach(function(med){med.ShowDetails="Alternative"!==med.MedicationAlternativeType}),vm.details.ResponseRFS&&vm.details.ResponseRFS.Medications&&vm.details.ResponseRFS.Medications.forEach(function(med){med.ShowDetails="Alternative"!==med.MedicationAlternativeType}),vm.$scope.removeHttpError()):vm.$scope.addHttpError({}),vm.loading=!1}function processMedicationChange(){$window.close()}function timeOut(){vm.loading&&(vm.$scope.addHttpError({},"The server is taking longer than anticipated to respond to the data request. The request may have failed."),vm.loading=!1)}vm.$sce=$sce,vm.$scope=$rootScope.$new(),$rootScope.setupDirectiveScope(vm.$scope),vm.changeMedication=function(med,pricingCoverage){Bridge.fireEvent("formulary-details-change-medication",{MedId:med.MedId,PharmacyId:pricingCoverage&&pricingCoverage.PharmacyId})},vm.$onInit=function(){Bridge.on("formulary-details-response",vm.$scope,processDetails),Bridge.on("formulary-details-medication-changed",vm.$scope,processMedicationChange),vm.loading=!1,vm.loaded||(vm.loading=!0,vm.loaded=!0,Bridge.fireEvent("formulary-details-request",{}),$timeout(timeOut,5e3))}}]})}(),function(angular){"use strict";angular.module("aprima-sigwriter").component("sigwriterTabletAdditionalInfo",{templateUrl:"/sigwriter/component-views/tabletAdditionalInfo.html",bindings:{sigOptionsNonFormulary:"<",showAdditionalInfoModal:"&"},controller:["aprgettext",function(gettext){var vm=this;vm.getTitle=function(){var title;if(vm.sigOptionsNonFormulary.isAdministered)title="Administered";else{if(!vm.sigOptionsNonFormulary.isSampleGiven)return;title="Sample Given"}return gettext(title)},vm.showDetails=function(){vm.showAdditionalInfoModal()}}]})}(angular),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletDirections",{templateUrl:"/sigwriter/component-views/tabletDirections.html",bindings:{form:"<",patientDetails:"<",rxOptions:"<",rxParameters:"<",sigFormulary:"<",sigInstruction:"<",sigOptions:"<",sigOptionsNonFormulary:"<",setDrugFromSearchResult:"&",updateSigInstruction:"&",updateSigOptions:"&",updateSigOptionsNonFormulary:"&"},controller:["_","CurrentUser","DosingService","DrugConsentModal","DrugDosingModal","DrugRepository","ErrorService","GeneralNotesModal","GeneralNoteTypeKeys","SigwriterDrugDosageSearchModal","SigWriterRepository","SigwriterRxService","SigwriterSigDetailsModal","StrConvert","$q",function(_,CurrentUser,DosingService,DrugConsentModal,DrugDosingModal,DrugRepository,ErrorService,GeneralNotesModal,GeneralNoteTypeKeys,SigwriterDrugDosageSearchModal,SigWriterRepository,SigwriterRxService,SigwriterSigDetailsModal,StrConvert,$q){var vm=this;function loadCptList(medId){medId?SigWriterRepository.getDrugCptList(medId).then(function(result){vm.cptList=result,vm.cptList&&vm.updatedSigOptionsNonFormulary.procedure&&_.find(vm.cptList,function(procedure){vm.updatedSigOptionsNonFormulary.procedure.ProcedureId===procedure.ProcedureId&&(vm.updatedSigOptionsNonFormulary.procedure=procedure)}),onUpdatedSigOptionsNonFormularyChanged()}):vm.cptList=[]}function getRemainingSigCharacters(){return SigwriterRxService.getRemainingSigCharacters(vm.updatedSigInstruction)}function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&(vm.toggleEpaChanged=!1,vm.toggleSpoChanged=!1,vm.updatedSigOptionsNonFormulary&&null!==previousMedid&&(vm.updatedSigOptionsNonFormulary.sendPriorAuth=void 0,onUpdatedSigOptionsNonFormularyChanged()),vm.updatedSigOptionsNonFormulary&&null!==previousMedid&&(vm.updatedSigOptionsNonFormulary.procedure=null),loadCptList(currentMedid));var sigType=vm.rxParameters&&vm.rxParameters.sigType;switch(sigType){case"ChangeRx":vm.allowSearchDrugDosage=!1;break;default:vm.allowSearchDrugDosage=!0}}function onSigFormularyChanged(changeSigFormulary){changeSigFormulary.currentValue&&changeSigFormulary.currentValue.primaryMedication&&updateEpaButton(changeSigFormulary.currentValue.primaryMedication.requiresPa)}function onUpdatedSigInstructionChanged(){vm.updateSigInstruction({updatedSigInstruction:vm.updatedSigInstruction}),getMinMaxWarning(),getQuantityWarning()}function onUpdatedSigOptionsNonFormularyChanged(){vm.updateSigOptionsNonFormulary({updatedSigOptionsNonFormulary:vm.updatedSigOptionsNonFormulary})}function loadProviderDrugSettings(){if(vm.updatedSigOptionsNonFormulary.prescriber&&vm.updatedSigOptionsNonFormulary.prescriber.Id){var promises=[SigWriterRepository.getMaintenanceDrugSettings(vm.rxParameters.drug.MedId,vm.updatedSigOptionsNonFormulary.prescriber.Id),DrugRepository.checkIsSpecialtyId(vm.rxParameters.drug.Ndc,vm.rxParameters.drug.RxNormCode,vm.updatedSigOptionsNonFormulary.prescriber.Id)];$q.all(promises).then(function(result){var drugSettings=result[0];drugSettings&&(vm.updatedSigOptionsNonFormulary.isChronicMed=drugSettings),vm.updatedSigOptionsNonFormulary.sendIsSpecialty=result[1],onUpdatedSigOptionsNonFormularyChanged()})}}function openSigDetailsModal(initialField){SigwriterSigDetailsModal.openModal(vm.patientDetails,vm.rxOptions,vm.rxParameters,vm.sigInstruction,vm.sigOptionsNonFormulary,initialField).then(function(results){vm.updatedSigInstruction=_.merge(vm.updatedSigInstruction,results.sigInstruction),onUpdatedSigInstructionChanged()})}function shouldDisplayButtons(){return shouldDisplayConsent()||shouldDisplayEpaButton()||shouldDisplaySpecialtyButton()}function shouldDisplayConsent(){if(!vm.rxParameters.drug.RequiresConsent)return!1;switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"Hx":return!1;default:return!0}}function shouldDisplayEpaButton(){return shouldDisplaySurescriptsButton()}function shouldDisplaySpecialtyButton(){return shouldDisplaySurescriptsButton()}function shouldDisplaySurescriptsButton(){switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":case"Hx":return!1;default:return!0}}function updateEpaButton(value){vm.updatedSigOptionsNonFormulary&&!vm.toggleEpaChanged&&(vm.updatedSigOptionsNonFormulary.sendPriorAuth=value,onUpdatedSigOptionsNonFormularyChanged())}function onMedicationConsentCompleted(medicationConsent){vm.updatedSigOptionsNonFormulary.MedicationConsent=medicationConsent,onUpdatedSigOptionsNonFormularyChanged()}function getQuantityWarning(){"Hx"!==vm.rxParameters.sigType&&"CppMedication"!==vm.rxParameters.sigType&&"DefaultSig"!==vm.rxParameters.sigType&&(vm.updatedSigInstruction.quantity?removeWarning(null,"quantityWarning"):addOrReplaceWarning("Quantity is missing; cannot be e-prescribed.","quantityWarning"))}function getMinMaxWarning(){DosingService.getMinMaxWarning(vm.updatedSigInstruction,vm.rxParameters,vm.patientDetails).then(function(minMaxWarningText){minMaxWarningText?addOrReplaceWarning(minMaxWarningText,"minMaxWarning"):removeWarning(null,"minMaxWarning")}).catch(function(response){removeWarning(null,"minMaxWarning"),console.log(response)})}function removeWarning(warning,key){key&&vm.warnings[key]&&(vm.warnings[key]=void 0)}function addOrReplaceWarning(message,key){var exist;if(message=StrConvert.replaceNewLine(message),key&&(exist=vm.warnings[key])&&exist.message!==message&&(removeWarning(exist,key),exist=null),!exist)return function(message,key){key&&(message=StrConvert.replaceNewLine(message),vm.warnings[key]=message)}(message,key)}vm.parentContainerId="sigwriter-content-column",vm.updatedSigInstruction=null,vm.updatedSigOptions=null,vm.updatedSigOptionsNonFormulary=null,vm.warnings={},vm.$onChanges=function(changes){changes.sigInstruction&&changes.sigInstruction.currentValue&&(changesSigInstructions=changes.sigInstruction,vm.updatedSigInstruction=_.merge(vm.updatedSigInstruction,changesSigInstructions.currentValue));var changesSigInstructions;changes.sigFormulary&&changes.sigFormulary.currentValue&&onSigFormularyChanged(changes.sigFormulary);changes.sigOptions&&changes.sigOptions.currentValue&&(changesSigOptions=changes.sigOptions,vm.updatedSigOptions=_.merge(vm.updatedSigOptions,changesSigOptions.currentValue));var changesSigOptions;changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&(changesSigOptionsNonFormulary=changes.sigOptionsNonFormulary,vm.updatedSigOptionsNonFormulary=_.merge(vm.updatedSigOptionsNonFormulary,changesSigOptionsNonFormulary.currentValue));var changesSigOptionsNonFormulary;changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters)},vm.allowSearchDrugDosage=!0,vm.editDays=function(){openSigDetailsModal("days")},vm.editDosage=function(){openSigDetailsModal("dosage")},vm.editFrequency=function(){openSigDetailsModal("frequency")},vm.editPrn=function(){openSigDetailsModal("prn")},vm.editRefills=function(){openSigDetailsModal("refills")},vm.editRoute=function(){openSigDetailsModal("route")},vm.editUnit=function(){openSigDetailsModal("unit")},vm.getButtonsColumnClass=function(){return shouldDisplayButtons()?"col-xs-4":"ng-hide"},vm.getCheckboxesColumnClass=function(){return shouldDisplayButtons()?"col-xs-8":"col-xs-12"},vm.getMinMaxWarning=getMinMaxWarning,vm.getQuantityWarning=getQuantityWarning,vm.getRemainingSigCharacters=getRemainingSigCharacters,vm.getRemainingPharmacyInstructionsCharacters=function(){return SigwriterRxService.getRemainingPharmacyInstructionsCharacters(vm.updatedSigOptionsNonFormulary.pharmacyInstructions)},vm.getRemainingInternalNoteCharacters=function(){return SigwriterRxService.getRemainingInternalNoteCharacters(vm.updatedSigOptionsNonFormulary.internalNote)},vm.isDaysValid=function(){return SigwriterRxService.isDaysValid(vm.updatedSigInstruction)},vm.isDirectionsValid=function(){return 0<=getRemainingSigCharacters()&&(vm.updatedSigInstruction.sigString||vm.updatedSigInstruction.days||vm.updatedSigInstruction.refills)},vm.isEndDateRequired=function(){return!!vm.updatedSigInstruction.repeatSigCount},vm.isFixedPharmacy=function(){return vm.rxParameters.isFixedPharmacy},vm.isPrescriberRequired=function(){switch(vm.rxParameters.sigType){case"Hx":return!1;default:return!0}},vm.isQuantityValid=function(){var quantity=vm.form.quantity.$viewValue;if(!quantity)return!0;var numDigitsAllowed=5;0===quantity.indexOf("0.")?numDigitsAllowed+=2:0<=quantity.indexOf(".")&&numDigitsAllowed++;return quantity.length<=numDigitsAllowed},vm.isStartDateRequired=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"Hx":return!1;default:return!0}},vm.onChangePrescriber=function(){onUpdatedSigOptionsNonFormularyChanged(),loadProviderDrugSettings()},vm.onClickDosingSuggestions=function(){DrugDosingModal.openModal(vm.rxParameters,vm.updatedSigInstruction).then(function(data){var dosingSuggestion=data.suggestion;vm.updatedSigInstruction=SigwriterRxService.updateInstructionFromDosingSuggestion(vm.updatedSigInstruction,dosingSuggestion,vm.rxOptions),onUpdatedSigInstructionChanged()})},vm.onClickPharmacyInstructions=function(){function onCommentUpdated(result){vm.updatedSigOptionsNonFormulary.pharmacyInstructions=result,onUpdatedSigOptionsNonFormularyChanged()}GeneralNotesModal.openModal("Pharmacy Instructions",vm.updatedSigOptionsNonFormulary.pharmacyInstructions,!0,vm.maxPharmacyInstructionsCharacters,GeneralNoteTypeKeys.SigPharmacyInstructions).then(onCommentUpdated)},vm.onClickInternalNote=function(){function onCommentUpdated(result){vm.updatedSigOptionsNonFormulary.internalNote=result,onUpdatedSigOptionsNonFormularyChanged()}GeneralNotesModal.openModal("Internal Note",vm.updatedSigOptionsNonFormulary.internalNote,!0,vm.maxInternalNoteCharacters,GeneralNoteTypeKeys.SigInternalNotes).then(onCommentUpdated)},vm.onClickRepeatSig=function(){var previousCount=vm.updatedSigInstruction.repeatSigCount||0;vm.updatedSigInstruction.repeatSigCount=(previousCount+1)%3,onUpdatedSigInstructionChanged()},vm.onClickSearchDrugDosage=function(){var providerId=vm.sigOptionsNonFormulary.prescriber&&vm.sigOptionsNonFormulary.prescriber.Id||CurrentUser.get().userId;SigwriterDrugDosageSearchModal.openModal(vm.rxParameters.sigType,vm.rxParameters.drug,vm.rxParameters.patientId,providerId).then(function(selectedDrug){vm.setDrugFromSearchResult({selectedDrug:selectedDrug})})},vm.onEndDateChanged=function(){vm.updatedSigInstruction.endDateChanged=!0,onUpdatedSigInstructionChanged()},vm.onIsAdministeredChanged=function(){vm.updatedSigOptionsNonFormulary.isAdministered&&(vm.updatedSigOptionsNonFormulary.isSampleGiven=!1);onUpdatedSigOptionsNonFormularyChanged()},vm.onOpenDrugConsent=function(){DrugConsentModal.openModal(vm.updatedSigOptionsNonFormulary.MedicationConsent,vm.rxParameters.drug.RxConsentFormattingTemplateName).then(onMedicationConsentCompleted)},vm.onSampleGivenChanged=function(){vm.updatedSigOptionsNonFormulary.isSampleGiven&&(vm.updatedSigOptionsNonFormulary.isAdministered=!1);onUpdatedSigOptionsNonFormularyChanged()},vm.onUpdatedSigInstructionChanged=onUpdatedSigInstructionChanged,vm.onUpdatedSigOptionsChanged=function(){vm.updateSigOptions({updatedSigOptions:vm.updatedSigOptions})},vm.onUpdatedSigOptionsNonFormularyChanged=onUpdatedSigOptionsNonFormularyChanged,vm.removeWarning=removeWarning,vm.supervisingProviderText=vm.rxParameters&&vm.rxParameters.visit&&vm.rxParameters.visit.SupervisingProvider&&vm.rxParameters.visit.SupervisingProvider.Description,vm.shouldDisablePrescriber=function(){return vm.rxOptions.authorizedPrescribers&&1===vm.rxOptions.authorizedPrescribers.length&&"Hx"!==vm.rxParameters.sigType},vm.shouldDisplayAuthorizationCode=function(){switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":case"Hx":return!1}return!vm.sigOptionsNonFormulary.isSampleGiven},vm.shouldDisplayCptCode=function(){switch(vm.rxParameters.sigType){case"ChangeRx":case"Hx":case"RefillFromHx":case"RefillFromHxOnly":return!1}return!vm.sigOptionsNonFormulary.isSampleGiven},vm.shouldDisplayConsent=shouldDisplayConsent,vm.shouldDisplayDxProblems=function(){switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":return!1;default:return!0}},vm.shouldDisplayEpaButton=shouldDisplayEpaButton,vm.shouldDisplayIncludeMonograph=function(){switch(vm.rxParameters.sigType){case"EditRx":case"NewRx":case"RefillMessage":return vm.rxParameters.drug&&0<vm.rxParameters.drug.MedId}return!1},vm.shouldDisplayMode=function(){switch(vm.rxParameters.sigType){case"ChangeRx":case"Hx":case"RefillFromHx":case"RefillFromHxOnly":return!1;default:return!0}},vm.shouldDisplayPharmacy=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"Hx":return!1}return!vm.sigOptionsNonFormulary.isAdministered&&!vm.sigOptionsNonFormulary.isSampleGiven},vm.shouldDisplayPrescriber=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"RefillMessage":return!1;default:return!0}},vm.shouldDisplayRepeatSig=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"Hx":return!1;default:return!0}},vm.shouldDisplaySpecialtyButton=shouldDisplaySpecialtyButton,vm.shouldDisplayStartEndDates=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":return!1}return!vm.sigOptionsNonFormulary.isAdministered},vm.shouldDisplaySupervisingProvider=function(){switch(vm.rxParameters.sigType){case"NewRx":case"EditRx":return!0;default:return!1}},vm.toggleQuantityType=function(){SigwriterRxService.toggleQuantityType(vm.updatedSigInstruction)&&onUpdatedSigInstructionChanged()},vm.toggleEpaButton=function(){if(!vm.updatedSigOptionsNonFormulary)return;vm.updatedSigOptionsNonFormulary.sendPriorAuth=!vm.updatedSigOptionsNonFormulary.sendPriorAuth,vm.toggleEpaChanged=!0,onUpdatedSigOptionsNonFormularyChanged()},vm.toggleEpaChanged=!1,vm.toggleSpoButton=function(){if(!vm.updatedSigOptionsNonFormulary)return;vm.updatedSigOptionsNonFormulary.sendIsSpecialty=!vm.updatedSigOptionsNonFormulary.sendIsSpecialty,vm.toggleSpoChanged=!0,onUpdatedSigOptionsNonFormularyChanged()},vm.toggleSpoChanged=!1,vm.maxPharmacyInstructionsCharacters=SigwriterRxService.getMaxPharmacyInstructionsCharacters(),vm.maxInternalNoteCharacters=SigwriterRxService.getMaxInternalNoteCharacters(),vm.$onInit=function(){"NewRx"===vm.rxParameters.sigType&&loadProviderDrugSettings();getQuantityWarning(),getMinMaxWarning()}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterTabletDrugDosageSearch",{templateUrl:"/sigwriter/component-views/tabletDrugDosageSearch.html",bindings:{drug:"<",patientId:"<",providerId:"<",sigType:"<",onDrugSelected:"&"},controller:["DrugRepository","ErrorService","ServerInfoRepository","SigwriterRxService",function(DrugRepository,ErrorService,ServerInfoRepository,SigwriterRxService){var vm=this;vm.drugs=[],vm.loadError=null,vm.loading=!1,vm.searched=!1,vm.searchText="",vm.sessionId="",vm.useEnhancedDrugSearch=!1,vm.selectDrugSearchResult=function(drugSearchResult,switchToGeneric,dosingSuggestion){vm.onDrugSelected({dosingSuggestion:dosingSuggestion,drugSearchResult:drugSearchResult,switchToGeneric:switchToGeneric,useEnhancedDrugSearch:vm.useEnhancedDrugSearch})},vm.sessionId=SigwriterRxService.newId(),vm.useEnhancedDrugSearch=ServerInfoRepository.isFeatureSupported(["EnhancedDrugSearch"]),vm.loading=!0,DrugRepository.drugDosageAlternativesSearch(vm.drug,vm.providerId).then(function(result){vm.drugs=result,vm.searched=!1,vm.loadError=null}).catch(function(err){vm.loadError=ErrorService.convertToErrorMessages(err)}).finally(function(){vm.loading=!1})}]})}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletDrugScreening",{templateUrl:"/sigwriter/component-views/tabletDrugScreening.html",bindings:{drugScreening:"<",rxParameters:"<",showDetailedScreeningModal:"&",updateDrugScreening:"&",updateIsScreeningLoaded:"&"},controller:["DrugRepository","ErrorService","FncRxRepository",function(DrugRepository,ErrorService,FncRxRepository){var vm=this;function getSidebarClass(){var base="drug-tablet-screening-sidebar-";if(vm.loading)return base+"loading";if(vm.error)return base+"unknown";var nddScreening=vm.nddScreening;if(nddScreening){if(nddScreening.Error)return base+"unknown";switch(nddScreening.Status){case"Completed":return base+"none";case"CompletedOutOfDate":return base+"unknown";case"CompletedWithAlerts":switch(nddScreening.OverallSeverityLevel){case-1:return base+"unknown";case 10:return base+"low";case 20:return base+"moderate";case 30:return base+"high";case 40:return base+"severe"}}}return base+"unknown"}function onRxParametersChanged(){vm.loading=!0,vm.updateIsScreeningLoaded({isLoaded:!1,isOverrideRequired:!1}),(vm.rxParameters.visit&&vm.rxParameters.visit.VisitId?FncRxRepository.getSigwriterNddDrugScreeningResults(vm.rxParameters.patientId,vm.rxParameters.visit.VisitId,vm.rxParameters.drug,null):DrugRepository.nddDrugScreening(vm.rxParameters.patientId,vm.rxParameters.drug,vm.drugScreening.otherDrugs)).then(function(results){vm.loading=!1,vm.nddScreening=results,vm.nddScreeningError=null,vm.updateDrugScreening({drugScreening:{nddScreening:vm.nddScreening,screeningResult:vm.nddScreening.PlainText}}),vm.updateIsScreeningLoaded({isLoaded:!0,isOverrideRequired:"drug-tablet-screening-sidebar-none"!==getSidebarClass()})}).catch(function(error){vm.nddScreeningError=ErrorService.convertToErrorMessages(error),vm.updateIsScreeningLoaded({isLoaded:!0,isOverrideRequired:!1})}).finally(function(){vm.loading=!1})}vm.loading=!1,vm.nddScreening=null,vm.nddScreeningError=null,vm.$onChanges=function(changes){changes.rxParameters&&onRxParametersChanged(changes.rxParameters)},vm.getSidebarClass=getSidebarClass,vm.showDetails=function(){if(vm.loading||vm.nddScreeningError)return;vm.showDetailedScreeningModal()}}]})}(),function(angular){"use strict";angular.module("aprima-sigwriter").component("sigwriterTabletDrugSearch",{templateUrl:"/sigwriter/component-views/tabletDrugSearch.html",bindings:{initialSearchText:"<",patientId:"<",usePreviousSearchText:"<",selectDrugSearchResult:"&"},controller:["SigwriterDrugSearchService","toaster",function(SigwriterDrugSearchService,toaster){var vm=this;vm.onDrugSearchResultSelected=function(drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch){if(!SigwriterDrugSearchService.validateDrugSearchResult(drugSearchResult,!0).success)return toaster.error("Unknown error selecting the drug search result"),void(drugSearchResult.indicateSelected=!1);vm.selectDrugSearchResult({drugSearchResult:drugSearchResult,switchToGeneric:switchToGeneric,dosingSuggestion:dosingSuggestion,useEnhancedDrugSearch:useEnhancedDrugSearch})}}]})}(angular),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletFormularyAlternatives",{templateUrl:"/sigwriter/component-views/tabletFormularyAlternatives.html",bindings:{relVisitMedicationId:"<",rxParameters:"<",sigFormulary:"<",sigInstruction:"<",sigOptions:"<",sigOptionsNonFormulary:"<",onDrugSelected:"&",updateSigFormulary:"&",updateIsAvailable:"&",updateRelVisitMedicationId:"&",updateSigOptions:"&"},controller:["$rootScope","$sce","$scope","$document","debounce","DrugRepository","aprgettext","moment","PatientRepository","SigwriterRxService","SigwriterFormularyDetailsModal","SigwriterRxBenefitDetailsModal","toaster",function($rootScope,$sce,$scope,$document,debounce,DrugRepository,gettext,moment,PatientRepository,SigwriterRxService,SigwriterFormularyDetailsModal,SigwriterRxBenefitDetailsModal,toaster){var initialFormularyLoadPromise,vm=this,debouncedRefreshFormularyData=debounce(1e3,function(){if(!vm.sigOptions||!vm.sigInstruction||vm.loadingERxEligibilities)return;if(vm.eRxEligibilities&&!vm.eRxEligibilities.length)return void vm.updateIsAvailable({isAvailable:!0});var medId=vm.rxParameters.drug.MedId,eRxEligibilityId=vm.sigOptions.eRxEligibility?vm.sigOptions.eRxEligibility.PatienteRxElgibilityUid:null;if(medId<=0||!eRxEligibilityId)return void vm.updateIsAvailable({isAvailable:!1});vm.loading=!0,vm.updateIsAvailable({isAvailable:null}),DrugRepository.getDrugRepresentativeFormularies(medId,eRxEligibilityId,vm.rxParameters.patientId,vm.relVisitMedicationId,vm.sigOptions.pharmacy?vm.sigOptions.pharmacy.Id:null,vm.sigInstruction.days?parseInt(vm.sigInstruction.days.Name):null,vm.sigOptionsNonFormulary.daw,vm.sigInstruction.quantity,vm.sigOptions.uom?vm.sigOptions.uom.Id:null,vm.details&&vm.details.ResponsePMBC.Parameters,vm.details&&vm.details.ResponseRFS.Parameters).then(refreshFormularyDataSuccessful).catch(function(err){vm.$scope.addHttpError(err),vm.loading=!1,vm.updateIsAvailable({isAvailable:!0})})}),defaultedERxEligibility=!1;function onERxEligibilityChanged(){vm.eRxEligibility&&vm.eRxEligibility.PatienteRxElgibilityUid?(vm.options.eRxEligibility=_.cloneDeep(vm.eRxEligibility),vm.eRxEligibility.IsExpired&&toaster.pop("warning","",gettext("The patient's coverage has not been downloaded recently and may be out of date"))):vm.options.eRxEligibility=null,vm.updateSigOptions({sigOptions:vm.options})}function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&(initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData())}function onSigInstructionsChanged(){initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData()}function onSigOptionsChanged(changesSigOptions){vm.options=_.merge(vm.options,changesSigOptions.currentValue),initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData(),!defaultedERxEligibility&&vm.eRxEligibilities&&setDefaultERxEligibility()}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){var previousDaw=changesSigOptionsNonFormulary.previousValue?changesSigOptionsNonFormulary.previousValue.daw:null,currentDaw=changesSigOptionsNonFormulary.currentValue?changesSigOptionsNonFormulary.currentValue.daw:null;previousDaw!==currentDaw&&updatePrimaryMedication()}function refreshFormularyDataSuccessful(data){switch(vm.relVisitMedicationId||vm.updateRelVisitMedicationId({relVisitMedicationId:data.RelVisitMedicationId}),vm.details||(vm.details={}),data.Details.ResponsePMBC.Status){case"unchanged":break;default:vm.details.ResponsePMBC=data.Details.ResponsePMBC}switch(data.Details.ResponseRFS.Status){case"unchanged":break;default:vm.details.ResponseRFS=data.Details.ResponseRFS}vm.updateIsAvailable({isAvailable:!0}),vm.loading=!1,vm.$scope.removeHttpError(),updatePrimaryMedication()}function setDefaultERxEligibility(forceUpdate){defaultedERxEligibility=!0;var defaultEligibility=function(){var defaultEligibility=_.find(vm.eRxEligibilities,{IsMainAccountEligibility:!0});!defaultEligibility&&vm.eRxEligibilities&&0<vm.eRxEligibilities.length&&(defaultEligibility=vm.eRxEligibilities[0]);return defaultEligibility||null}();defaultEligibility!==vm.eRxEligibility?(vm.eRxEligibility=defaultEligibility,onERxEligibilityChanged()):forceUpdate&&debouncedRefreshFormularyData()}function updatePrimaryMedication(){vm.details&&(vm.details.primaryMedication=SigwriterRxService.getPrimaryMedication(vm.details,vm.sigOptionsNonFormulary),vm.updateSigFormulary({sigFormulary:vm.details}))}vm.$sce=$sce,vm.$scope=$scope,vm.details=null,vm.eRxEligibility=null,vm.eRxEligibilities=null,vm.hideTransmitStatus=!0,vm.isInfoAvailable=!1,vm.loading=!1,vm.loadingERxEligibilities=!1,vm.options=_.cloneDeep(vm.sigOptions),vm.showDrugIcons=!0,vm.$onChanges=function(changes){changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters);changes.sigInstruction&&changes.sigInstruction.currentValue&&onSigInstructionsChanged(changes.sigInstruction);changes.sigFormulary&&changes.sigFormulary.currentValue&&(changeSigFormulary=changes.sigFormulary,vm.details=changeSigFormulary.currentValue,vm.isInfoAvailable=vm.details&&vm.details.ResponsePMBC&&"completed"===vm.details.ResponsePMBC.Status||vm.details&&vm.details.ResponseRFS&&"completed"===vm.details.ResponseRFS.Status);var changeSigFormulary;changes.sigOptions&&changes.sigOptions.currentValue?onSigOptionsChanged(changes.sigOptions):changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.$onInit=function(){vm.loadingERxEligibilities=!0,PatientRepository.geteRxEligibilities(vm.rxParameters.patientId).then(function(results){vm.eRxEligibilities=results,vm.options&&setDefaultERxEligibility(!0)}).finally(function(){vm.loadingERxEligibilities=!1,debouncedRefreshFormularyData.flushPending()})},vm.changeMedication=function(drug,pharmacy){vm.onDrugSelected({drug:drug,pharmacy:pharmacy})},vm.downloadStatusClass=function(){var base="rx-formulary-download-status-";if(vm.loading)return base+"loading";if(vm.loadingERxEligibilities)return base+"loading";if(!vm.details)return base+"default";if(!vm.details.ResponsePMBC)return base+"default";switch(vm.details.ResponsePMBC.Status){case"processing":return base+"loading";case"insufficient":return base+"insufficient";case"error":return base+"error";case"completed":return base+"completed";case"none":case"denied":case"disposed":default:return base+"default"}},vm.formatEligibilityDate=function(){return vm.eRxEligibility?moment(vm.eRxEligibility.LastDownloadedDate).format("L")+(vm.eRxEligibility.IsExpired?" (3+ Days)":""):""},vm.formatEligibilityName=function(erxe){return erxe.Name+(erxe.HealthPlanName?" ("+erxe.HealthPlanName+")":"")},vm.isAnimating=function(elementId){if(!$document)return!1;var element=$document[0].getElementById(elementId);if(!element)return!1;if(!element.className)return!1;if(0<=element.className.indexOf("ng-animate"))return console.log(element.className),!0;return!1},vm.onERxEligibilityChanged=onERxEligibilityChanged,vm.openFormularyDetailsModal=function(){function formularyDetailsModalCompleted(results){results.chosenMedication&&vm.onDrugSelected(results.chosenMedication)}SigwriterFormularyDetailsModal.openModal(vm.details,vm.isInfoAvailable).then(formularyDetailsModalCompleted)},vm.openRxBenefitDetailsModal=function(){SigwriterRxBenefitDetailsModal.openModal(vm.eRxEligibility)},$rootScope.setupDirectiveScope(vm.$scope),vm.relVisitMedicationId||(initialFormularyLoadPromise=DrugRepository.getDrugRepresentativeFormularies(0,void 0,void 0,vm.relVisitMedicationId).then(refreshFormularyDataSuccessful).finally(function(){initialFormularyLoadPromise=null}))}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterTabletPdr",{templateUrl:"/sigwriter/component-views/tabletPdr.html",bindings:{drug:"<",patientId:"<",rxId:"<",sigType:"<"},controller:["$rootScope","$sce","$scope","SigwriterRxService",function($rootScope,$sce,$scope,SigwriterRxService){var vm=this;function updateDisplay(){if(vm.drug){var pdrBriefType,medId=vm.drug.MedId,ndc=vm.drug.Ndc,patientId=vm.patientId;switch(vm.sigType){case"RefillFromHx":case"RefillFromHxOnly":pdrBriefType="RefillRx";break;default:pdrBriefType="NewRx"}vm.loadingDrugDocumentation=!0,SigwriterRxService.getDrugDocumentation(medId,ndc,patientId,pdrBriefType,vm.rxId).then(function(result){vm.$scope.removeHttpError(),vm.drugDocumentation={html:$sce.trustAsResourceUrl("data:text/html;charset=utf-8; base64,"+result.Html)}}).catch(function(err){vm.$scope.addHttpError(err)}).finally(function(){vm.loadingDrugDocumentation=!1})}}vm.$scope=$scope,vm.loadingDrugDocumentation=!1,vm.$onChanges=function(changes){changes.drug&&updateDisplay()},$rootScope.setupDirectiveScope(vm.$scope)}]})}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletShell",{templateUrl:"/sigwriter/component-views/sigwriterTabletShell.html",bindings:{options:"<",canceled:"&",completed:"&"},controller:["$timeout","_","aprgettext","DeviceSettings","NewDefaultSigModal","PersistentWarningService","SigwriterAdditionalInfoModal","SigwriterDrugSearchService","SigWriterRepository","SigwriterRxService","SigwriterScreeningModal","toaster",function($timeout,_,gettext,DeviceSettings,NewDefaultSigModal,PersistentWarningService,SigwriterAdditionalInfoModal,SigwriterDrugSearchService,SigWriterRepository,SigwriterRxService,SigwriterScreeningModal,toaster){var vm=this;function getNumberOfVisibleInfoTiles(){var numTiles=0;return(vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven)&&numTiles++,vm.disableDrugScreening||numTiles++,vm.disableFormulary||numTiles++,numTiles}function isFixedPharmacy(sigType){switch(sigType){case"ChangeRx":case"RefillMessage":return!0;default:return!1}}function shouldRequireConsent(){if(!vm.rxParameters.drug.RequiresConsent)return!1;switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":case"Hx":case"RefillFromHx":case"RefillFromHxOnly":case"RefillMessage":return!1;default:return!0}}function showAdditionalInfoModal(){SigwriterAdditionalInfoModal.openModal(vm.currentRx.optionsNonFormulary,vm.rxOptions).then(function(result){updateSigOptionsNonFormulary(result.optionsNonFormulary)})}function showDetailedScreeningModal(){var drugScreening=vm.currentRx.drugScreening;if(vm.isScreeningLoaded&&drugScreening.nddScreening)return SigwriterScreeningModal.openModal(drugScreening.nddScreening,drugScreening.overrideText).then(function(result){updateDrugScreening({overrideText:result.overrideText}),vm.isScreeningViewed=!0})}function updateDrugScreening(drugScreening){vm.currentRx.drugScreening=_.assignIn(_.cloneDeep(vm.currentRx.drugScreening),_.cloneDeep(drugScreening))}function updateRxParameters(rxParameters){vm.rxParameters=_.assignIn(_.cloneDeep(vm.rxParameters),_.cloneDeep(rxParameters))}function updateSigInstruction(updatedSigInstruction){var source;vm.currentInstruction=_.cloneDeep((source=updatedSigInstruction,SigwriterRxService.setRxInstructions(vm.currentRx,source)))}function updateSigOptions(updatedSigOptions){vm.currentRx.options=_.assignIn(_.cloneDeep(vm.currentRx.options),_.cloneDeep(updatedSigOptions))}function updateSigOptionsNonFormulary(updatedSigOptionsNonFormulary){var administeredChanged=vm.currentRx.optionsNonFormulary.isAdministered^updatedSigOptionsNonFormulary.isAdministered,shouldShowAdditionalInfoModal=!vm.currentRx.optionsNonFormulary.isAdministered&&updatedSigOptionsNonFormulary.isAdministered||!vm.currentRx.optionsNonFormulary.isSampleGiven&&updatedSigOptionsNonFormulary.isSampleGiven;vm.currentRx.optionsNonFormulary=_.assignIn(_.cloneDeep(vm.currentRx.optionsNonFormulary),_.cloneDeep(updatedSigOptionsNonFormulary)),administeredChanged&&updateSigInstruction(vm.currentInstruction),shouldShowAdditionalInfoModal&&showAdditionalInfoModal()}function validateAll(){var isValid=!0;return shouldRequireConsent()&&!vm.currentRx.optionsNonFormulary.MedicationConsent&&(toaster.pop({type:"error",title:gettext("Missing Rx Consent"),body:gettext("This drug requires medication consent before prescribing.")}),isValid=!1),vm.tabletShellForm.$valid||(toaster.error("SIG is not valid. Please correct all errors."),isValid=!1),isValid}function autoHidePdr(){vm.togglePdrModified||vm.togglePdr(!0)}vm.currentInstruction=null,vm.currentRx=null,vm.disableDrugScreening=!1,vm.disableFormulary=!1,vm.displayPdr=!0,vm.isScreeningLoaded=!1,vm.isScreeningOverrideRequired=!1,vm.isScreeningViewed=!1,vm.rxOptions=null,vm.rxParameters=null,vm.cancel=function(){PersistentWarningService.clear(),vm.canceled()},vm.getContentColumnClass=function(){return 0<getNumberOfVisibleInfoTiles()?"col-xs-9":"col-xs-12"},vm.getInfoColumnClass=function(){var cls="sigwriter-tablet-info-column-tiles-";vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven||(cls="sigwriter-tablet-tile-hide-addl-info "+cls);var numTiles=getNumberOfVisibleInfoTiles();cls=0<numTiles?"col-xs-3 "+cls:"ng-hide "+cls;return cls+numTiles},vm.saveDefaultSig=function(){vm.saveDefaultSigLoading=!0;var providerDefaultSigId=null,defaultSig=vm.options.defaultSig;defaultSig&&(providerDefaultSigId=defaultSig.id);SigWriterRepository.initializeDefaultSig(SigwriterRxService.mapToSigwriterResultsDto(vm.currentRx),providerDefaultSigId).then(function(data){if(data.CanSaveDefaultSig){var createModifyDefaultSigDto=SigwriterRxService.newCreateModifyDefaultSigDto(vm.currentRx);defaultSig&&(createModifyDefaultSigDto=SigwriterRxService.mergeDefaultSigWithCreateModifyDefaultSigDto(defaultSig,createModifyDefaultSigDto)),createModifyDefaultSigDto.Notes=data.Notes,NewDefaultSigModal.openModal(createModifyDefaultSigDto).then(function(isSuccess){vm.defaultSigContext&&isSuccess&&vm.canceled()})}else toaster.pop({type:"warning",title:gettext("Invalid Request"),body:gettext("Unable to save Default SIG, Provider does not have KDB configured."),timeout:0})}).catch(function(){toaster.pop({type:"error",title:gettext("Failed Request"),body:gettext("An error occurred and we are unable to save Default SIG."),timeout:0})}).finally(function(){vm.saveDefaultSigLoading=!1})},vm.save=function(){{if(vm.isScreeningOverrideRequired&&!vm.isScreeningViewed)return showDetailedScreeningModal().then(function(){complete()});complete()}function complete(){validateAll()&&(vm.completed({rx:vm.currentRx}),PersistentWarningService.clear())}},vm.setCurrentRx=function(rx){updateRxParameters({drug:rx.drug,rxId:rx.id}),vm.currentRx=rx,vm.currentInstruction=vm.currentRx.instructions[0],vm.rxOptions=vm.currentRx.rxOptions},vm.setDrugFromSearchResult=function(selectedDrug){SigwriterDrugSearchService.updateRxFromDrugSearchResult(vm.currentRx,selectedDrug.drugSearchResult,selectedDrug.switchToGeneric,selectedDrug.dosingSuggestion,selectedDrug.useEnhancedDrugSearch).then(function(rx){vm.resetting=!0,$timeout(function(){vm.setCurrentRx(rx),vm.resetting=!1})})},vm.setNewDrug=function(drug,pharmacy){if(updateRxParameters({drug:drug}),SigwriterRxService.setRxDrug(vm.currentRx,drug),!vm.rxParameters.isFixedPharmacy&&pharmacy){var sigOptions={pharmacy:pharmacy};updateSigOptions(sigOptions)}},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},vm.showAdditionalInfoModal=showAdditionalInfoModal,vm.showDetailedScreeningModal=showDetailedScreeningModal,vm.togglePdr=function(forceHide){vm.togglePdrModified=!0,vm.displayPdr||forceHide?vm.displayPdr=!1:vm.displayPdr=!0},vm.updateDrugScreening=updateDrugScreening,vm.updateIsScreeningLoaded=function(isLoaded,isOverrideRequired){vm.isScreeningLoaded=isLoaded,vm.isScreeningOverrideRequired=isOverrideRequired,vm.isScreeningViewed=!1},vm.updateRelVisitMedicationId=function(relVisitMedicationId){vm.currentRx.relVisitMedicationId||(vm.currentRx.relVisitMedicationId=relVisitMedicationId)},vm.updateSigFormulary=function(updatedSigFormulary){vm.currentRx.sigFormulary=_.assignIn(_.cloneDeep(vm.currentRx.sigFormulary),_.cloneDeep(updatedSigFormulary))},vm.updateSigInstruction=updateSigInstruction,vm.updateSigOptions=updateSigOptions,vm.updateSigOptionsNonFormulary=updateSigOptionsNonFormulary,function(){switch(vm.currentRx=vm.options.rx,vm.currentInstruction=vm.currentRx.instructions[0],vm.rxOptions=vm.currentRx.rxOptions,vm.rxParameters={drug:vm.currentRx.drug,isFixedPharmacy:isFixedPharmacy(vm.currentRx.sigType),patientId:vm.currentRx.patient&&vm.currentRx.patient.Id,rxId:vm.currentRx.id,sigType:vm.currentRx.sigType,visit:vm.currentRx.visit},vm.patientDetails=vm.currentRx.patientDosingDetails,vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"EditRx":vm.disableDrugScreening=!0}switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":case"Hx":vm.disableFormulary=!0}"DefaultSig"===vm.rxParameters.sigType&&(vm.defaultSigContext=!0);$timeout(autoHidePdr,15e3)}()}]})}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletSigDetails",{templateUrl:"/sigwriter/component-views/tabletSigDetails.html",bindings:{initialField:"<",patientDetails:"<",rxOptions:"<",rxParameters:"<",sigInstruction:"<",sigOptionsNonFormulary:"<",updateSigInstruction:"&"},controller:["_","DosingCalcModal","SigwriterRxService",function(_,DosingCalcModal,SigwriterRxService){var vm=this,dosingCalcSupported=DosingCalcModal.isSupported();function initializeInstruction(source){var model,instruction=_.cloneDeep(source);return instruction.days&&((model=_(vm.dayOptions).find({Id:instruction.days.Id}))&&(instruction.days=model),vm.manualDays=parseFloat(instruction.days.Name)),instruction.dosage&&((model=_(vm.dosageOptions).find({Id:instruction.dosage.Id}))&&(instruction.dosage=model),vm.manualDosage=instruction.dosage.Name),instruction.frequency&&(model=_(vm.frequencyOptions).find({Id:instruction.frequency.Id}))&&(instruction.frequency=model),instruction.prnReason&&(model=_(vm.prnReasons).find({Id:instruction.prnReason.Id}))&&(instruction.prnReason=model),instruction.refills&&((model=_(vm.refillOptions).find({Id:instruction.refills.Id}))&&(instruction.refills=model),vm.manualRefills=parseFloat(instruction.refills.Name)),instruction.route&&(model=_(vm.routeOptions).find({Id:instruction.route.Id}))&&(instruction.route=model),instruction.unit&&(model=_(vm.unitOptions).find({Id:instruction.unit.Id}))&&(instruction.unit=model),instruction}function onUpdatedSigInstructionChanged(){vm.updateSigInstruction({updatedSigInstruction:vm.updatedSigInstruction})}vm.dayOptions=[],vm.dosageOptions=[],vm.inputModelOptions={debounce:300},vm.frequencyOptions=[],vm.manualDays=null,vm.manualDosage=null,vm.manualRefills=null,vm.prnReasons=[],vm.refillOptions=[],vm.routeOptions=[],vm.unitOptions=[],vm.updatedSigInstruction=null,vm.$onInit=function(){vm.dayOptions=vm.rxOptions.lists.medicationsDays,vm.dosageOptions=vm.rxOptions.lists.medicationsDosages,vm.frequencyOptions=vm.rxOptions.lists.medicationsFrequencies,vm.prnReasons=vm.rxOptions.lists.medicationsPrnReasons,vm.refillOptions=vm.rxOptions.lists.medicationsRefills,vm.routeOptions=vm.rxOptions.lists.medicationsRoutes,vm.unitOptions=vm.rxOptions.lists.medicationsUnits,vm.updatedSigInstruction=initializeInstruction(vm.sigInstruction)},vm.isDaysValid=function(){return SigwriterRxService.isDaysValid(vm.updatedSigInstruction)},vm.isDosingCalcSupported=function(){return dosingCalcSupported},vm.onClickDosingCalculator=function(){DosingCalcModal.openFromSigwriter(vm.updatedSigInstruction,vm.rxParameters,vm.patientDetails)},vm.onDaysSelected=function(){vm.updatedSigInstruction.days?vm.manualDays=parseFloat(vm.updatedSigInstruction.days.Name):vm.manualDays=null;onUpdatedSigInstructionChanged()},vm.onDaysTyped=function(){vm.manualDays?vm.updatedSigInstruction.days={Name:""+vm.manualDays,Id:""+vm.manualDays}:vm.updatedSigInstruction.days=null;onUpdatedSigInstructionChanged()},vm.onDosageSelected=function(){vm.updatedSigInstruction.dosage?vm.manualDosage=parseFloat(vm.updatedSigInstruction.dosage.Id):vm.manualDosage=null;onUpdatedSigInstructionChanged()},vm.onDosageTyped=function(){vm.manualDosage?vm.updatedSigInstruction.dosage={Name:vm.manualDosage,Id:vm.manualDosage}:vm.updatedSigInstruction.dosage=null;onUpdatedSigInstructionChanged()},vm.onIsPrnChanged=function(){vm.updatedSigInstruction.isPrn||(vm.updatedSigInstruction.prnReason=null);onUpdatedSigInstructionChanged()},vm.onRefillsSelected=function(){vm.updatedSigInstruction.refills?vm.manualRefills=parseFloat(vm.updatedSigInstruction.refills.Name):vm.manualRefills=null;onUpdatedSigInstructionChanged()},vm.onRefillsTyped=function(){vm.manualRefills?vm.updatedSigInstruction.refills={Name:""+vm.manualRefills,Id:""+vm.manualRefills}:vm.updatedSigInstruction.refills=null;onUpdatedSigInstructionChanged()},vm.onUpdatedSigInstructionChanged=onUpdatedSigInstructionChanged,vm.shouldDisplayDosingCalc=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"Hx":return!1}return dosingCalcSupported}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardDosingContent",{templateUrl:"/sigwriter/component-views/wizardDosingContent.html",bindings:{rxParameters:"<",sigInstruction:"<",onSuggestionChanged:"&"},controller:["aprgettext","SigwriterRxService",function(gettext,SigwriterRxService){var vm=this,dosingSuggestions=null;function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&(vm.loading=!0,vm.activeDosingGroup=0,dosingSuggestions=null,SigwriterRxService.getDrugDosingSuggestions(vm.rxParameters.patientId,vm.rxParameters.drug.MedId,vm.rxParameters.rxId).then(function(results){dosingSuggestions=results,vm.sigInstruction&&processData()}).finally(function(){vm.loading=!1}))}function onSigInstructionChanged(changesSigInstruction){var previousSigid=changesSigInstruction.previousValue?changesSigInstruction.previousValue.id:null,currentSigid=changesSigInstruction.currentValue?changesSigInstruction.currentValue.id:null;previousSigid!==currentSigid&&dosingSuggestions&&processData()}function processData(){var results=dosingSuggestions,instructions=vm.sigInstruction;vm.dosingGroups=[];var theCondition,groupedResults=_(results).groupBy(function(condition){return condition.PatientHasCondition||"Default Order"===condition.ConditionDescription}).value(),patientDosingGroup={name:gettext("Recommended"),conditions:groupedResults.true},otherDosingGroup={name:gettext("Diagnoses"),conditions:groupedResults.false};patientDosingGroup.conditions&&"Auto"!==instructions.source&&patientDosingGroup.conditions.splice(0,0,{ConditionDescription:instructions.source,Suggestions:[{Description:instructions.sigString,Type:"CurrentInstructions",isSelected:!0}]}),patientDosingGroup.conditions&&0<patientDosingGroup.conditions.length&&(vm.dosingGroups.push(patientDosingGroup),(theCondition=_.find(patientDosingGroup.conditions,function(condition){return _.some(condition.Suggestions,{isSelected:!0})}))&&(vm.activeDosingGroup=vm.dosingGroups.indexOf(patientDosingGroup))),otherDosingGroup.conditions&&0<otherDosingGroup.conditions.length&&(vm.dosingGroups.push(otherDosingGroup),theCondition||(theCondition=_.find(otherDosingGroup.conditions,function(condition){return _.some(condition.Suggestions,{isSelected:!0})}))&&(vm.activeDosingGroup=vm.dosingGroups.indexOf(otherDosingGroup))),(theCondition||vm.dosingGroups&&vm.dosingGroups[0]&&vm.dosingGroups[0].conditions&&vm.dosingGroups[0].conditions[0]||{detailsCollapsed:!0}).detailsCollapsed=!1}vm.activeDosingGroup=0,vm.dosingGroups=null,vm.loading=!1,vm.$onChanges=function(changes){changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters);changes.sigInstruction&&changes.sigInstruction.currentValue&&onSigInstructionChanged(changes.sigInstruction)},vm.initConditionForDisplay=function(condition){void 0===condition.detailsCollapsed&&(condition.detailsCollapsed=!0)},vm.suggestionSelected=function(suggestion){var selectedSuggestion=null;suggestion.isSelected?suggestion.isSelected=!1:(_(vm.dosingGroups).map("conditions").flatten().map("Suggestions").flatten().forEach(unselectDosingSuggestion),suggestion.isSelected=!0,"CurrentInstructions"!==suggestion.Type&&(selectedSuggestion=suggestion));function unselectDosingSuggestion(dosingSuggestion){dosingSuggestion.isSelected=!1}vm.onSuggestionChanged({suggestion:selectedSuggestion,instructionId:vm.sigInstruction.id})}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardDrugDescription",{templateUrl:"/sigwriter/component-views/wizardDrugDescription.html",bindings:{rxParameters:"<"},controller:[function(){}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardDrugDetail",{templateUrl:"/sigwriter/component-views/wizardDrugDetail.html",bindings:{medId:"<",patientId:"<",relPatientMedicationId:"<",sigId:"<",rxId:"<",searchUpdate:"&",searchEnabled:"<"},controller:["$rootScope","$sce","$scope","SigwriterRxService",function($rootScope,$sce,$scope,SigwriterRxService){var vm=this;function updateDisplay(){vm.medId?(vm.loadingDetailDocumentation=!0,SigwriterRxService.getDrugDetail(vm.medId,vm.patientId,vm.relPatientMedicationId,vm.sigId,vm.rxId).then(function(result){vm.$scope.removeHttpError(),vm.drugdetail=result}).catch(function(err){vm.$scope.addHttpError(err)}).finally(function(){vm.loadingDetailDocumentation=!1})):vm.drugdetail=null}vm.$scope=$scope,vm.loadingDetailDocumentation=!1,vm.$onChanges=function(changes){changes.medId&&updateDisplay()},vm.scrubPharmacyText=function(){return $sce.trustAsHtml(vm.drugdetail.PharmacyText.replace(/\n/g,"<br/>"))},vm.searchAka=function(drugdetail){vm.searchUpdate({searchText:"aka: "+drugdetail.Description})},vm.searchClass=function(drugdetail){vm.searchUpdate({searchText:"class: "+drugdetail.Class})},vm.searchNdc=function(drugdetail){vm.searchUpdate({searchText:"ndc: "+drugdetail.Ndc})},vm.searchRxn=function(drugdetail){vm.searchUpdate({searchText:"rxn: "+drugdetail.RxNormCode})},vm.updateDisplay=updateDisplay,$rootScope.setupDirectiveScope(vm.$scope)}]})}(),function(angular){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardDrugSearch",{templateUrl:"/sigwriter/component-views/wizardDrugSearch.html",bindings:{deferSaving:"<",patientId:"<",usePreviousSearchText:"<",onDrugSelected:"&",onExistingSigSelected:"&"},controller:["DrugConsentWarningModal","SigwriterDrugSearchService","toaster",function(DrugConsentWarningModal,SigwriterDrugSearchService,toaster){var vm=this;vm.selectDrugSearchResult=function(drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch){var validationResult=SigwriterDrugSearchService.validateDrugSearchResult(drugSearchResult,!1);if(!validationResult.success)return validationResult.consentUnsupported?DrugConsentWarningModal.openDrugConsentWarningModal(drugSearchResult.Drug.Name):toaster.error("Unknown error selecting the drug search result"),void(drugSearchResult.indicateSelected=!1);SigwriterDrugSearchService.createNewRxFromDrugSearchResult("NewRx",drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch,vm.patientId,vm.deferSaving,!1).then(function(rx){rx.relPatientMedicationId?vm.onExistingSigSelected({rx:rx}):vm.onDrugSelected({rx:rx})}).catch(function(){toaster.error("Unknown error selecting the drug search result"),drugSearchResult.indicateSelected=!1})}}]})}(angular),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardFormularyAlternativesContent",{templateUrl:"/sigwriter/component-views/wizardFormularyAlternativesContent.html",bindings:{isActiveStep:"<",relVisitMedicationId:"<",rxParameters:"<",sigFormulary:"<",sigInstruction:"<",sigOptions:"<",sigOptionsNonFormulary:"<",skipFormularyAlternatives:"<",onDrugSelected:"&",updateIsAvailable:"&",updateRelVisitMedicationId:"&",updateSigFormulary:"&",updateSigOptions:"&"},controller:["ServerInfoRepository",function(ServerInfoRepository){this.useSurescripts=ServerInfoRepository.isFeatureSupported(["SurescriptsRFSPMBC"])}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardFormularyAlternativesOriginal",{templateUrl:"/sigwriter/component-views/wizardFormularyAlternativesContentOriginal.html",bindings:{isActiveStep:"<",relVisitMedicationId:"<",rxParameters:"<",sigInstruction:"<",sigOptions:"<",onDrugSelected:"&",updateIsAvailable:"&",updateRelVisitMedicationId:"&"},controller:["$rootScope","DrugRepository",function($rootScope,DrugRepository){var vm=this;function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&(vm.loading=!0,DrugRepository.getDrugFormularyInfo(vm.rxParameters.drug.MedId,vm.rxParameters.patientId).then(function(data){vm.drugs=_.filter(data,{IsFormularyAlternative:!0}),vm.$scope.removeHttpError()}).catch(function(err){vm.$scope.addHttpError(err)}).finally(function(){vm.loading=!1,vm.updateIsAvailable({isAvailable:!0})}))}vm.$scope=null,vm.drugs=[],vm.loading=!1,vm.$onChanges=function(changes){changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters)},vm.formularySelected=function(med){vm.onDrugSelected({drug:med})},vm.$scope=$rootScope.$new(),$rootScope.setupDirectiveScope(vm.$scope)}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardFormularyAlternativesSurescripts",{templateUrl:"/sigwriter/component-views/wizardFormularyAlternativesSurescripts.html",bindings:{isActiveStep:"<",relVisitMedicationId:"<",rxParameters:"<",sigFormulary:"<",sigInstruction:"<",sigOptions:"<",sigOptionsNonFormulary:"<",skipFormularyAlternatives:"<",onDrugSelected:"&",updateIsAvailable:"&",updateRelVisitMedicationId:"&",updateSigFormulary:"&",updateSigOptions:"&"},controller:["$rootScope","$sce","$scope","debounce","DrugRepository","aprgettext","PatientRepository","SigwriterRxService","toaster",function($rootScope,$sce,$scope,debounce,DrugRepository,gettext,PatientRepository,SigwriterRxService,toaster){var initialFormularyLoadPromise,vm=this,debouncedRefreshFormularyData=debounce(1e3,function(){if(!vm.sigOptions||!vm.sigInstruction||vm.skipFormularyAlternatives||vm.loadingERxEligibilities)return;if(vm.eRxEligibilities&&!vm.eRxEligibilities.length)return void vm.updateIsAvailable({isAvailable:!0});var medId=vm.rxParameters.drug.MedId,eRxEligibilityId=vm.sigOptions.eRxEligibility?vm.sigOptions.eRxEligibility.PatienteRxElgibilityUid:null;if(medId<=0||!eRxEligibilityId)return void vm.updateIsAvailable({isAvailable:!1});vm.loading=!0,vm.updateIsAvailable({isAvailable:null}),DrugRepository.getDrugRepresentativeFormularies(medId,eRxEligibilityId,vm.rxParameters.patientId,vm.relVisitMedicationId,vm.sigOptions.pharmacy?vm.sigOptions.pharmacy.Id:null,vm.sigInstruction.days?parseInt(vm.sigInstruction.days.Name):null,vm.sigOptionsNonFormulary.daw,vm.sigInstruction.quantity,vm.sigOptions.uom?vm.sigOptions.uom.Id:null,vm.details&&vm.details.ResponsePMBC.Parameters,vm.details&&vm.details.ResponseRFS.Parameters).then(refreshFormularyDataSuccessful).catch(function(err){vm.$scope.addHttpError(err),vm.loading=!1,vm.updateIsAvailable({isAvailable:!0})})}),defaultedERxEligibility=!1,pendingShowExpiredEligibilityMessage=!1;function onERxEligibilityChanged(){vm.eRxEligibility&&vm.eRxEligibility.PatienteRxElgibilityUid?(vm.options.eRxEligibility=_.cloneDeep(vm.eRxEligibility),vm.eRxEligibility.IsExpired&&(vm.isActiveStep?showExpiredEligibilityMessage():pendingShowExpiredEligibilityMessage=!0)):vm.options.eRxEligibility=null,vm.updateSigOptions({sigOptions:vm.options})}function onIsActiveStepChanged(changesIsActiveStep){changesIsActiveStep.currentValue&&pendingShowExpiredEligibilityMessage&&showExpiredEligibilityMessage()}function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&(initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData())}function onSigInstructionsChanged(){initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData()}function onSigOptionsChanged(changesSigOptions){vm.options=_.merge(vm.options,changesSigOptions.currentValue),initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData(),!defaultedERxEligibility&&vm.eRxEligibilities&&setDefaultERxEligibility()}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){vm.optionsNonFormulary=_.merge(vm.optionsNonFormulary,changesSigOptionsNonFormulary.currentValue);var previousDaw=changesSigOptionsNonFormulary.previousValue?changesSigOptionsNonFormulary.previousValue.daw:null,currentDaw=changesSigOptionsNonFormulary.currentValue?changesSigOptionsNonFormulary.currentValue.daw:null;previousDaw!==currentDaw&&updatePrimaryMedication()}function refreshFormularyDataSuccessful(data){switch(vm.relVisitMedicationId||vm.updateRelVisitMedicationId({relVisitMedicationId:data.RelVisitMedicationId}),vm.details||(vm.details={}),data.Details.ResponsePMBC.Status){case"unchanged":break;default:vm.details.ResponsePMBC=data.Details.ResponsePMBC}switch(data.Details.ResponseRFS.Status){case"unchanged":break;default:vm.details.ResponseRFS=data.Details.ResponseRFS}vm.updateIsAvailable({isAvailable:!0}),vm.loading=!1,vm.$scope.removeHttpError(),updatePrimaryMedication()}function setDefaultERxEligibility(forceUpdate){defaultedERxEligibility=!0;var defaultEligibility=function(){var defaultEligibility=_.find(vm.eRxEligibilities,{IsMainAccountEligibility:!0});!defaultEligibility&&vm.eRxEligibilities&&0<vm.eRxEligibilities.length&&(defaultEligibility=vm.eRxEligibilities[0]);return defaultEligibility||null}();defaultEligibility!==vm.eRxEligibility?(vm.eRxEligibility=defaultEligibility,onERxEligibilityChanged()):forceUpdate&&debouncedRefreshFormularyData()}function showExpiredEligibilityMessage(){pendingShowExpiredEligibilityMessage=!1,toaster.pop("warning","",gettext("The patient's coverage has not been downloaded recently and may be out of date"))}function updatePrimaryMedication(){vm.details&&(vm.details.primaryMedication=SigwriterRxService.getPrimaryMedication(vm.details,vm.sigOptionsNonFormulary),vm.updateSigFormulary({sigFormulary:vm.details}))}vm.$sce=$sce,vm.$scope=$scope,vm.details=null,vm.eRxEligibility=null,vm.eRxEligibilities=null,vm.hideTransmitStatus=!0,vm.isInfoAvailable=!1,vm.loading=!1,vm.loadingERxEligibilities=!1,vm.options=_.cloneDeep(vm.sigOptions),vm.optionsNonFormulary=_.cloneDeep(vm.sigOptionsNonFormulary),vm.showDrugIcons=!0,vm.$onChanges=function(changes){changes.isActiveStep&&onIsActiveStepChanged(changes.isActiveStep);changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters);changes.sigInstruction&&changes.sigInstruction.currentValue&&onSigInstructionsChanged(changes.sigInstruction);changes.sigFormulary&&changes.sigFormulary.currentValue&&(changeSigFormulary=changes.sigFormulary,vm.details=changeSigFormulary.currentValue,vm.isInfoAvailable=vm.details&&vm.details.ResponsePMBC&&"completed"===vm.details.ResponsePMBC.Status||vm.details&&vm.details.ResponseRFS&&"completed"===vm.details.ResponseRFS.Status);var changeSigFormulary;changes.sigOptions&&changes.sigOptions.currentValue&&onSigOptionsChanged(changes.sigOptions);changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.$onInit=function(){vm.loadingERxEligibilities=!0,PatientRepository.geteRxEligibilities(vm.rxParameters.patientId).then(function(results){vm.eRxEligibilities=results,vm.options&&setDefaultERxEligibility(!0)}).finally(function(){vm.loadingERxEligibilities=!1,debouncedRefreshFormularyData.flushPending()})},vm.changeMedication=function(drug,pharmacy){vm.onDrugSelected({drug:drug,pharmacy:pharmacy})},vm.onERxEligibilityChanged=onERxEligibilityChanged,$rootScope.setupDirectiveScope(vm.$scope),vm.relVisitMedicationId||(initialFormularyLoadPromise=DrugRepository.getDrugRepresentativeFormularies(0,void 0,void 0,vm.relVisitMedicationId).then(refreshFormularyDataSuccessful).finally(function(){initialFormularyLoadPromise=null}))}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardPdr",{templateUrl:"/sigwriter/component-views/wizardPdr.html",bindings:{drug:"<",patient:"<",rxId:"<"},controller:["$rootScope","$sce","$scope","SigwriterRxService",function($rootScope,$sce,$scope,SigwriterRxService){var vm=this;function updateDisplay(){if(vm.drug){var medId=vm.drug.MedId,ndc=vm.drug.Ndc,patientId=vm.patient&&vm.patient.Id;vm.loadingDrugDocumentation=!0,SigwriterRxService.getDrugDocumentation(medId,ndc,patientId,"HistoryRx",vm.rxId).then(function(result){vm.$scope.removeHttpError(),vm.drugDocumentation={html:$sce.trustAsResourceUrl("data:text/html;charset=utf-8,"+atob(result.Html))}}).catch(function(err){vm.$scope.addHttpError(err)}).finally(function(){vm.loadingDrugDocumentation=!1})}}vm.$scope=$scope,vm.loadingDrugDocumentation=!1,vm.$onChanges=function(changes){changes.drug&&updateDisplay()},$rootScope.setupDirectiveScope(vm.$scope)}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardReview",{templateUrl:"/sigwriter/component-views/wizardReview.html",bindings:{currentRx:"<",rxParameters:"<",sigOptions:"<",registerFormSubmitCallback:"&",updateEpcsSignature:"&",updateIsValid:"&",updateSigOptions:"&"},controller:["$scope","$timeout","aprgettext","CurrentUser","SettingRepository","toaster",function($scope,$timeout,gettext,CurrentUser,SettingRepository,toaster){var formWatcherCleanupFn,formValidWatcherCleanupFn,vm=this,epcsEnabled=!1;function isControlledSubstance(){return vm.rxParameters.drug&&"0"!==vm.rxParameters.drug.FederalDeaClassCode}function isDeferredRx(){return vm.rxParameters.isDeferredRx}function isEpcsPharmacy(){var masterPharmacy=vm.currentRx&&vm.currentRx.options&&vm.currentRx.options.pharmacy&&vm.currentRx.options.pharmacy.MasterPharmacy;return masterPharmacy&&masterPharmacy.IsEpcsPharmacy}function isERxPharmacy(){var masterPharmacy=vm.currentRx&&vm.currentRx.options&&vm.currentRx.options.pharmacy&&vm.currentRx.options.pharmacy.MasterPharmacy;return masterPharmacy&&masterPharmacy.ConfiguredForEPrescribing}function onFormChanged(newValue,oldValue){formValidWatcherCleanupFn&&newValue===oldValue||(formValidWatcherCleanupFn?formValidWatcherCleanupFn():vm.registerFormSubmitCallback({callbackFn:submit}),formValidWatcherCleanupFn=$scope.$watch("$ctrl.epcsForm.$valid",onFormValidChanged),vm.epcsForm&&$timeout(function(){onFormValidChanged(vm.epcsForm.$valid)},0))}function onFormValidChanged(newValue,oldValue){newValue!==oldValue&&verifyPrescription(!1)}function submit(){verifyPrescription(!0)&&vm.updateEpcsSignature({epcsSignature:function(){if(vm.user.epcsModel){var loggedOnUser=(vm.user.epcsModel.loggedOnUser||"").split("\\");return{LoggedOnUserDomain:loggedOnUser[0],LoggedOnUserName:loggedOnUser[1],LoggedOnUserWorkstation:vm.user.epcsModel.loggedOnDevice,PinType:"otp",OtpPinCode:vm.user.epcsModel.otpPinCode,OtpPassword:vm.user.epcsModel.otpPassword}}return null}()}),vm.epcsForm.$setSubmitted(!0),vm.epcsForm.isSubmitted=!0}function verifyPrescription(showToasters){var valid=!0;return vm.currentRx?(angular.forEach(vm.currentRx.instructions,function(instruction){instruction.quantity||(showToasters&&toaster.pop("error","",gettext("Quantity required. Please go back and enter a quantity before submitting.")),valid=!1)}),vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven||isDeferredRx()||(vm.currentRx&&vm.currentRx.options&&vm.currentRx.options.pharmacy&&vm.currentRx.options.pharmacy.Id?isERxPharmacy()?isControlledSubstance()&&!isEpcsPharmacy()&&(showToasters&&toaster.pop("error","",gettext("EPCS Pharmacy required. Please go back and select a pharmacy configured for EPCS before submitting.")),valid=!1):(showToasters&&toaster.pop("error","",gettext("ERx Pharmacy required. Please go back and select a pharmacy configured for ERx before submitting.")),valid=!1):(showToasters&&toaster.pop("error","",gettext("Pharmacy required. Please go back and select a pharmacy before submitting.")),valid=!1))):valid=!1,vm.epcsForm?vm.epcsForm.$valid||(showToasters&&toaster.pop("error","",gettext("OTP signature required.")),valid=!1):valid=!1,vm.updateIsValid({isValid:valid}),valid}vm.options=_.cloneDeep(vm.sigOptions),vm.user=null,vm.$onChanges=function(changes){changes.sigOptions&&changes.sigOptions.currentValue&&(changesSigOptions=changes.sigOptions,vm.options=_.merge(vm.options,changesSigOptions.currentValue));var changesSigOptions},vm.$onDestroy=function(){formWatcherCleanupFn&&formWatcherCleanupFn();formValidWatcherCleanupFn&&formValidWatcherCleanupFn()},vm.$onInit=function(){formWatcherCleanupFn=$scope.$watch("$ctrl.epcsForm",onFormChanged)},vm.needsEpcs=function(){return!isDeferredRx()&&isControlledSubstance()&&epcsEnabled&&isERxPharmacy()&&isEpcsPharmacy()},vm.onOptionsChanged=function(){vm.updateSigOptions({sigOptions:vm.options})},vm.user=CurrentUser.get(),SettingRepository.getProviderEpcsSettings(vm.user.userId).then(function(data){epcsEnabled=data&&data.IsEpcsEnabled})}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardScreeningContent",{templateUrl:"/sigwriter/component-views/wizardScreeningContent.html",bindings:{rxParameters:"<",updateIsScreeningLoaded:"&",updateDrugScreening:"&",visitScreeningParameters:"<"},controller:["SigwriterRxService","FncRxRepository",function(SigwriterRxService,FncRxRepository){var vm=this;function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&performScreening()}function performScreening(){vm.loadingDrugScreening=!0,vm.updateIsScreeningLoaded({isLoaded:!1});(vm.visitScreeningParameters?FncRxRepository.getDrugScreeningResults(vm.visitScreeningParameters.patientId,vm.visitScreeningParameters.visitId):SigwriterRxService.getDrugScreeningResults(vm.rxParameters.patientId,vm.rxParameters.drug.MedId,vm.rxParameters.rxId)).then(function(results){var overrideRequired=!1,status="yellow";vm.screening=results,"Completed"===vm.screening.Status?(vm.drugScreeningMode="redirecting",overrideRequired=!1,status="green"):"CompletedWithAlerts"===vm.screening.Status?(vm.drugScreeningMode="display",overrideRequired=!0):"CompletedOutOfDate"===vm.screening.Status?(vm.drugScreeningMode="outofdate",overrideRequired=!0):vm.drugScreeningMode="unknown",vm.updateDrugScreening({drugScreening:{screeningResult:vm.screening.PlainText}}),vm.updateIsScreeningLoaded({isLoaded:!0,isOverrideRequired:overrideRequired,status:status})}).finally(function(){vm.loadingDrugScreening=!1})}vm.drugScreeningMode=null,vm.loadingDrugScreening=!1,vm.screening=null,vm.$onChanges=function(changes){changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters)},vm.$onInit=function(){vm.visitScreeningParameters&&performScreening()}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardScreeningOverride",{templateUrl:"/sigwriter/component-views/wizardScreeningOverride.html",bindings:{drugScreening:"<",updateDrugScreening:"&"},controller:["$q","ListService","LocalStorageRepository",function($q,ListService,LocalStorageRepository){var vm=this;function loadDrugScreeningOverrideReasons(){var medOverrideGeneralNoteTypeId=LocalStorageRepository.getMedicationOverrideGeneralNoteTypeId();return medOverrideGeneralNoteTypeId?ListService.getList("generalnotes/"+medOverrideGeneralNoteTypeId):$q.when([])}function onOverrideTextChanged(){vm.updateDrugScreening({drugScreening:{overrideText:vm.overrideText}})}function onDrugScreeningChanged(changesDrugScreening){vm.overrideText!==changesDrugScreening.currentValue.overrideText&&(vm.overrideText=changesDrugScreening.currentValue.overrideText)}vm.drugScreeningOverrides=null,vm.overrideText="",vm.selectedOverrideReason=null,vm.$onChanges=function(changes){changes.drugScreening&&changes.drugScreening.currentValue&&onDrugScreeningChanged(changes.drugScreening)},vm.onOverrideTextChanged=onOverrideTextChanged,vm.overrideSelected=function(){var changed=!1;vm.overrideText&&(vm.overrideText+="\r\n",changed=!0);vm.selectedOverrideReason&&(vm.overrideText+=vm.selectedOverrideReason,changed=!0);changed&&onOverrideTextChanged()},loadDrugScreeningOverrideReasons().then(function(reasons){vm.drugScreeningOverrides=reasons})}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardShell",{templateUrl:"/sigwriter/component-views/sigwriterWizardShell.html",bindings:{options:"<",completed:"&"},controller:["$anchorScroll","$q","$scope","$timeout","aprgettext","moment","RequiredScreensModal","SaveRxModal","SigwriterRxService","toaster","VisitRepository","WizardHandler",function($anchorScroll,$q,$scope,$timeout,gettext,moment,RequiredScreensModal,SaveRxModal,SigwriterRxService,toaster,VisitRepository,WizardHandler){var formSubmitCallbackFns,vm=this;function canAdvanceFromCurrentStep(){var stepTitle=getCurrentStepTitle();return stepTitle===vm.titles.sigInstructions?vm.isSigInstructionsValid:stepTitle===vm.titles.sigOptions?vm.isSigOptionsValid:stepTitle!==vm.titles.summary||vm.isSummaryValid}function cloneCurrentRx(){vm.currentRxClone=_.cloneDeep(vm.currentRx)}function convertStepTitleToId(stepTitle){return stepTitle.replace(/ /g,"-")+"-top"}function getCurrentStepTitle(){var wizard=getWizard();if(wizard){var currentStep=wizard.currentStep();if(currentStep)return currentStep.wzTitle}}function getWizard(){return WizardHandler.wizard(vm.wizardName)}function isStepBehindCurrentStep(stepNumber){var currentStepNumber=getWizard().currentStepNumber();return stepNumber<=currentStepNumber}function onStepChanged(){var currentStepTitle=getCurrentStepTitle();currentStepTitle===vm.titles.drugScreening&&vm.isScreeningLoaded?vm.isScreeningViewed=!0:currentStepTitle===vm.titles.formularyAlternatives?(vm.isFormularyAvailable&&(vm.hasEverViewedFormulary=!0,vm.isFormularyViewed=!0),console.log("stepChanged: formulary, isFormularyAvailable: "+vm.isFormularyAvailable+", isFormularyViewed: "+vm.isFormularyViewed+", hasEverViewedFormulary: "+vm.hasEverViewedFormulary)):currentStepTitle===vm.titles.summary&&verifyReviewedRequiredScreens(),$timeout(function(){$anchorScroll(convertStepTitleToId(currentStepTitle))},0)}function setRxInstructions(source){return SigwriterRxService.setRxInstructions(vm.currentRx,source)}function shouldSkipFormularyAlternatives(){return vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven}function submitCurrentStep(){var stepTitle=getCurrentStepTitle(),callbackFn=formSubmitCallbackFns[stepTitle];callbackFn&&callbackFn()}function updateRxParameters(rxParameters){vm.rxParameters=_.assignIn(_.cloneDeep(vm.rxParameters),_.cloneDeep(rxParameters))}function updateSigOptions(sigOptions){vm.currentRx.options=_.assignIn(_.cloneDeep(vm.currentRx.options),_.cloneDeep(sigOptions)),cloneCurrentRx()}function verifyReviewedRequiredScreens(){var unviewedScreens=[];return vm.hasEverViewedFormulary||vm.skipFormularyAlternatives||unviewedScreens.push(vm.titles.formularyAlternatives),vm.isScreeningViewed||unviewedScreens.push(vm.titles.drugScreening),unviewedScreens.length?RequiredScreensModal.openModal(unviewedScreens).then(function(stepTitle){getWizard().goTo(stepTitle)}):null}vm.currentInstruction=null,vm.currentRx=null,vm.currentRxClone=null,vm.disableSigDates=!1,vm.enableMedicationTypeSelection=!1,vm.hasEverViewedFormulary=!1,vm.isFormularyAvailable=null,vm.isFormularyViewed=!1,vm.isOverrideRequired=!1,vm.isScreeningLoaded=!1,vm.isScreeningViewed=!1,vm.isSigInstructionsValid=null,vm.isSigOptionsValid=null,vm.isSummaryValid=!1,vm.rxOptions=null,vm.rxParameters=null,vm.screeningStatus="black",vm.skipFormularyAlternatives=!1,vm.titles={drugScreening:gettext("Drug Screening"),formularyAlternatives:gettext("Formulary Alternatives"),screeningOverride:gettext("Override"),sigInstructions:gettext("SIG Instructions"),sigOptions:gettext("SIG Options"),summary:gettext("Summary")},vm.wizardName="sigwriterWizardShell",vm.applyDosingSuggestion=function(suggestion,instructionId){var instructions=SigwriterRxService.newRxInstructions(vm.currentRx);(instructions=SigwriterRxService.updateInstructionFromDosingSuggestion(instructions,suggestion,vm.currentRx.rxOptions)).id=instructionId;var newInstruction=setRxInstructions(instructions);vm.currentInstruction.id===newInstruction.id&&(vm.currentInstruction=newInstruction)},vm.canAdvanceFromCurrentStep=canAdvanceFromCurrentStep,vm.convertStepTitleToId=convertStepTitleToId,vm.getCurrentStepTitle=getCurrentStepTitle,vm.getStepIconClass=function(step){switch(step.wzTitle){case vm.titles.drugScreening:return"ap-sigwizard-screening-"+vm.screeningStatus;case vm.titles.formularyAlternatives:return vm.isFormularyViewed?"ap-sigwizard-formulary-green":null===vm.isFormularyAvailable?"ap-sigwizard-formulary-black":vm.isFormularyAvailable?"ap-sigwizard-formulary-yellow":"ap-sigwizard-formulary-red";case vm.titles.screeningOverride:return"ap-sigwizard-override-"+vm.screeningStatus;case vm.titles.sigInstructions:return null===vm.isSigInstructionsValid?"ap-sigwizard-script-black":vm.isSigInstructionsValid?"ap-sigwizard-script-green":"ap-sigwizard-script-red";case vm.titles.sigOptions:return null===vm.isSigOptionsValid?"ap-sigwizard-options-black":vm.isSigOptionsValid?"ap-sigwizard-options-green":"ap-sigwizard-options-red";case vm.titles.summary:return"ap-sigwizard-review-black"}},vm.getStepIconId=function(step){return step.wzTitle.replace(/ /g,"-")+"-icon"},vm.getWizard=getWizard,vm.goToStep=function(step,stepNumber){var targetStepTitle=step.wzTitle;isStepBehindCurrentStep(stepNumber)||submitCurrentStep();getWizard().goTo(targetStepTitle)},vm.onFinish=function(){if(submitCurrentStep(),canAdvanceFromCurrentStep()){if(verifyReviewedRequiredScreens())return;if(vm.rxParameters.isDeferredRx)vm.completed({rx:vm.currentRx});else{var visitDto=SigwriterRxService.mapToVisitDto(vm.currentRx),savePromise=VisitRepository.createVisit(visitDto);SaveRxModal.openModal(savePromise).then(function(result){toaster.pop("success","",gettext("RX submitted successfully.")),vm.completed({rx:vm.currentRx,visit:result})})}}},vm.onNext=function(){submitCurrentStep()},vm.registerFormSubmitCallback=function(stepTitle,callbackFn){formSubmitCallbackFns[stepTitle]=callbackFn},vm.setNewDrug=function(drug,pharmacy){if(updateRxParameters({drug:drug}),SigwriterRxService.setRxDrug(vm.currentRx,drug),!vm.rxParameters.isFixedPharmacy&&pharmacy){var sigOptions={pharmacy:pharmacy};updateSigOptions(sigOptions)}else cloneCurrentRx();getWizard().goTo(vm.titles.sigInstructions)},vm.updateDrugScreening=function(drugScreening){vm.currentRx.drugScreening=_.assignIn(_.cloneDeep(vm.currentRx.drugScreening),_.cloneDeep(drugScreening)),cloneCurrentRx()},vm.updateEpcsSignature=function(epcsSignature){vm.currentRx.epcsSignature=_.cloneDeep(epcsSignature),cloneCurrentRx()},vm.updateIsFormularyAlternativesAvailable=function(isAvailable){(vm.isFormularyAvailable=isAvailable)&&(vm.isFormularyViewed=getCurrentStepTitle()===vm.titles.formularyAlternatives,vm.hasEverViewedFormulary=vm.hasEverViewedFormulary||vm.isFormularyViewed);console.log("updateIsFormularyAlternativesAvailable: "+isAvailable+", isFormularyViewed: "+vm.isFormularyViewed+", hasEverViewedFormulary: "+vm.hasEverViewedFormulary)},vm.updateIsScreeningLoaded=function(isLoaded,isOverrideRequired,status){vm.isScreeningLoaded=isLoaded,vm.isOverrideRequired=isOverrideRequired,vm.screeningStatus=status||"black",vm.isScreeningViewed=!!isLoaded&&getCurrentStepTitle()===vm.titles.drugScreening},vm.updateIsSigInstructionsValid=function(isValid){vm.isSigInstructionsValid=isValid},vm.updateIsSigOptionsValid=function(isValid){vm.isSigOptionsValid=isValid},vm.updateIsSummaryValid=function(isValid){vm.isSummaryValid=isValid},vm.updateRelVisitMedicationId=function(relVisitMedicationId){vm.currentRx.relVisitMedicationId||(vm.currentRx.relVisitMedicationId=relVisitMedicationId,cloneCurrentRx())},vm.updateSigFormulary=function(sigFormulary){vm.currentRx.sigFormulary=_.assignIn(_.cloneDeep(vm.currentRx.sigFormulary),_.cloneDeep(sigFormulary))},vm.updateSigInstruction=function(sigInstruction){vm.currentInstruction=_.cloneDeep(setRxInstructions(sigInstruction)),cloneCurrentRx()},vm.updateSigOptions=updateSigOptions,vm.updateSigOptionsNonFormulary=function(sigOptionsNonFormulary){vm.currentRx.optionsNonFormulary=_.assignIn(_.cloneDeep(vm.currentRx.optionsNonFormulary),_.cloneDeep(sigOptionsNonFormulary)),vm.disableSigDates=vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven,vm.skipFormularyAlternatives=shouldSkipFormularyAlternatives(),cloneCurrentRx()},$scope.$on("wizard:stepChanged",onStepChanged),formSubmitCallbackFns={},vm.currentRx=vm.options.rx,vm.currentInstruction=vm.currentRx.instructions[0],vm.rxOptions=vm.currentRx.rxOptions,vm.rxParameters={drug:vm.currentRx.drug,isDeferredRx:vm.options.isDeferredRx,isFixedPharmacy:vm.options.isFixedPharmacy,patientId:vm.currentRx.patient.Id,rxId:vm.currentRx.id},vm.enableMedicationTypeSelection=vm.rxOptions.additionalMedInfo.isMedicationTypeEditable,vm.skipFormularyAlternatives=shouldSkipFormularyAlternatives(),cloneCurrentRx()}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardSigInstructions",{templateUrl:"/sigwriter/component-views/wizardSigInstructions.html",bindings:{disableDates:"<",enableMedicationTypeSelection:"<",rxOptions:"<",rxParameters:"<",sigInstruction:"<",sigOptionsNonFormulary:"<",applyDosingSuggestion:"&",registerFormSubmitCallback:"&",updateIsValid:"&",updateSigInstruction:"&",updateSigOptionsNonFormulary:"&"},controller:["_","$anchorScroll","$scope","$timeout","DrugDocumentationModal","DrugDosingModal","SigwriterRxService",function(_,$anchorScroll,$scope,$timeout,DrugDocumentationModal,DrugDosingModal,SigwriterRxService){var formWatcherCleanupFn,formValidWatcherCleanupFn,vm=this;function onDisableDatesChanged(changesDisableDates){changesDisableDates.currentValue?(vm.sig.startDate=null,vm.sig.endDate=null):vm.sig.endDateChanged=!1,saveSigInstruction()}function onFormChanged(newValue,oldValue){formValidWatcherCleanupFn&&newValue===oldValue||(formValidWatcherCleanupFn?formValidWatcherCleanupFn():vm.registerFormSubmitCallback({callbackFn:onFormSubmit}),formValidWatcherCleanupFn=$scope.$watch("$ctrl.sigInstructionsForm.$valid",onFormValidChanged),vm.sigInstructionsForm&&$timeout(function(){onFormValidChanged(vm.sigInstructionsForm.$valid)},0))}function onFormSubmit(){vm.sigInstructionsForm.$setSubmitted(!0),vm.sigInstructionsForm.$valid||$anchorScroll("quantity-form-group")}function onFormValidChanged(newValue,oldValue){newValue!==oldValue&&vm.updateIsValid({isValid:newValue})}function onMedTypeChangedExternally(){var selectedMedType;selectedMedType=vm.sigOptionsNonFormulary.isAdministered?vm.rxOptions.additionalMedInfo.medTypes[1]:vm.sigOptionsNonFormulary.isSampleGiven?vm.rxOptions.additionalMedInfo.medTypes[2]:vm.rxOptions.additionalMedInfo.medTypes[0],vm.medicationType=selectedMedType}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){vm.optionsNonFormulary=_.merge(vm.optionsNonFormulary,changesSigOptionsNonFormulary.currentValue),onMedTypeChangedExternally()}function saveSigInstruction(){vm.updateSigInstruction({sigInstruction:vm.sig})}vm.medicationType=null,vm.optionsNonFormulary=_.cloneDeep(vm.sigOptionsNonFormulary),vm.sig=_.cloneDeep(vm.sigInstruction),vm.sigInstructionsForm=null,vm.$onChanges=function(changes){changes.disableDates&&void 0!==changes.disableDates.currentValue&&onDisableDatesChanged(changes.disableDates);changes.sigInstruction&&changes.sigInstruction.currentValue&&(changesSigInstruction=changes.sigInstruction,vm.sig=_.merge(vm.sig,changesSigInstruction.currentValue));var changesSigInstruction;changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.$onDestroy=function(){formWatcherCleanupFn&&formWatcherCleanupFn();formValidWatcherCleanupFn&&formValidWatcherCleanupFn()},vm.$onInit=function(){formWatcherCleanupFn=$scope.$watch("$ctrl.sigInstructionsForm",onFormChanged)},vm.getRemainingSigCharacters=function(){var remainingCharacters=SigwriterRxService.getRemainingSigCharacters(vm.sigInstruction);vm.sigInstructionsForm&&vm.sigInstructionsForm.$setValidity("siginstructionlength",0<=remainingCharacters);return Math.max(0,remainingCharacters)},vm.endDateChanged=function(){vm.sig.endDateChanged=!0,saveSigInstruction()},vm.openDosingSuggestions=function(){DrugDosingModal.openModal(vm.rxParameters,vm.sigInstruction).then(function(selection){vm.applyDosingSuggestion(selection)})},vm.openPdr=function(){DrugDocumentationModal.openModal(vm.rxParameters.drug.MedId,vm.rxParameters.drug.Ndc,vm.rxParameters.patientId,vm.rxParameters.rxId)},vm.onMedTypeChanged=function(){vm.medicationType&&1!==vm.medicationType.Id?2===vm.medicationType.Id?(vm.optionsNonFormulary.isAdministered=!0,vm.optionsNonFormulary.isSampleGiven=!1):3===vm.medicationType.Id&&(vm.optionsNonFormulary.isAdministered=!1,vm.optionsNonFormulary.isSampleGiven=!0):(vm.optionsNonFormulary.isAdministered=!1,vm.optionsNonFormulary.isSampleGiven=!1);vm.updateSigOptionsNonFormulary({sigOptionsNonFormulary:vm.optionsNonFormulary})},vm.onSigSelected=function(sig){vm.updateSigInstruction({sigInstruction:sig})},vm.saveSigInstruction=saveSigInstruction,vm.toggleQuantityType=function(){SigwriterRxService.toggleQuantityType(vm.sig)&&saveSigInstruction()}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardSigInstructionsContent",{templateUrl:"/sigwriter/component-views/wizardSigInstructionsContent.html",bindings:{rxOptions:"<",sigInstruction:"<",sigOptionsNonFormulary:"<",onSelect:"&",rxParameters:"<"},controller:["$rootScope","DosingCalcModal","ViewportInfo",function($rootScope,DosingCalcModal,ViewportInfo){var mode,vm=this,dosingCalcSupported=DosingCalcModal.isSupported();function fireOnSelect(){vm.sig&&vm.sigInstruction&&(vm.sig.isPrn=vm.sig.prnReason&&!vm.sig.prnReason.isNull,vm.onSelect({sig:vm.sig}))}function loadTopMenu(){setDimensions(),vm.currentOption=null,vm.options=vm.rxOptions.options}function menuClosed(closingMode){mode===closingMode&&loadTopMenu()}function navigateToNextOption(parentOption){setDimensions(),parentOption?(vm.currentOption=_(vm.rxOptions.options).dropWhile(function(i){return parentOption.key!==i.key}).filter(function(o){return!vm.sig[o.key]}).head(),vm.currentOption?(vm.options=vm.currentOption.items,mode=vm.currentOption.key):"top"!==mode?($rootScope.$broadcast("close-context-menu"),menuClosed()):loadTopMenu()):loadTopMenu()}function onIsAdministeredChanged(){vm.sigOptionsNonFormulary.isAdministered&&(vm.sig.days={Name:"None",isNull:!0},vm.sig.refills={Name:"None",isNull:!0},vm.sig.StartDate=null,vm.sig.EndDate=null,fireOnSelect())}function onSigInstructionsChanged(changesSigInstructions){if(!vm.sig){vm.sig={startText:"",postDosage:"",postUnit:"",postRoute:"",postFrequency:"",postPrn:"",endText:""}}vm.sig=_.merge(vm.sig,changesSigInstructions.currentValue)}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){var previousIsAdministered=!changesSigOptionsNonFormulary.isFirstChange()&&changesSigOptionsNonFormulary.previousValue?changesSigOptionsNonFormulary.previousValue.isAdministered:void 0;previousIsAdministered!==changesSigOptionsNonFormulary.currentValue.isAdministered&&onIsAdministeredChanged()}function setDimensions(){vm.maxHeight=Math.max(ViewportInfo.getWindowHeight()/2,200),vm.maxWidth=ViewportInfo.getWindowWidth()}vm.currentOption=null,vm.options=null,vm.sig=null,vm.$onInit=function(){setDimensions()},vm.$onChanges=function(changes){changes.sigInstruction&&changes.sigInstruction.currentValue&&onSigInstructionsChanged(changes.sigInstruction);changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.fireOnSelect=fireOnSelect,vm.menuClosed=menuClosed,vm.open=function(key){setDimensions(),mode=key;var option=_(vm.rxOptions.options).find({key:key});if(option){vm.currentOption=option,vm.options=option.items;var selectedVal=vm.sig[vm.currentOption.key];selectedVal&&selectedVal.isCustom&&(vm.sig.numericEntry=selectedVal.Name)}else loadTopMenu()},vm.optionSelected=function(option,currentOption){return option.key&&vm.sig[option.key]||currentOption&&(option===vm.sig[currentOption.key]||option&&option.Name&&vm.sig[currentOption.key]&&option.Name===vm.sig[currentOption.key].Name)},vm.selectOption=function(option){var parent=vm.currentOption;(vm.currentOption=option).items?vm.options=option.items:(parent&&(vm.sig[parent.key]=option),navigateToNextOption(parent),fireOnSelect())},vm.selectTextOption=function(){vm.sig[vm.currentOption.key]={Name:vm.sig.numericEntry,isCustom:!0},navigateToNextOption(vm.currentOption),vm.sig.numericEntry=null,fireOnSelect()},vm.onClickDosingCalculator=function(){DosingCalcModal.openFromSigwriter(vm.sig,vm.rxParameters,null)},vm.shouldDisplayDosingCalc=function(){return dosingCalcSupported}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardSigOptions",{templateUrl:"/sigwriter/component-views/wizardSigOptions.html",bindings:{rxOptions:"<",rxParameters:"<",sigOptions:"<",sigOptionsNonFormulary:"<",registerFormSubmitCallback:"&",updateIsValid:"&",updateSigOptions:"&",updateSigOptionsNonFormulary:"&"},controller:["_","$anchorScroll","$scope","$timeout","ListService","LocalStorageRepository","PatientRepository","PharmacyRepository","ServerInfoRepository","SigWriterRepository",function(_,$anchorScroll,$scope,$timeout,ListService,LocalStorageRepository,PatientRepository,PharmacyRepository,ServerInfoRepository,SigWriterRepository){var formWatcherCleanupFn,formValidWatcherCleanupFn,vm=this,defaultedPharmacy=!1,defaultedProblems=!1,chronicMedCheckSupported=ServerInfoRepository.isFeatureSupported("SigWriter_ChronicMed");function getMedicationTypeChanged(current,previous){var currentType=getMedicationType(current),previousType=getMedicationType(previous);return previousType!==currentType;function getMedicationType(optionsNonFormulary){return optionsNonFormulary?optionsNonFormulary.isAdministered?2:optionsNonFormulary.isSampleGiven?3:1:1}}function loadPharmacyNotes(){var pharmacyGeneralNoteTypeId=LocalStorageRepository.getPharmacyGeneralNoteTypeId();if(pharmacyGeneralNoteTypeId){var listsToLoad={generalNotes:"generalnotes/"+pharmacyGeneralNoteTypeId};ListService.getLists(listsToLoad).then(function(lists){lists.generalNotes&&(vm.generalNotes=lists.generalNotes)})}}function onFindPharmacyChanged(){vm.pharmacy&&vm.pharmacy.Id?vm.options.pharmacy=_.cloneDeep(vm.pharmacy):vm.options.pharmacy=null,onOptionsChanged()}function onFormChanged(newValue,oldValue){formValidWatcherCleanupFn&&newValue===oldValue||(formValidWatcherCleanupFn?formValidWatcherCleanupFn():vm.registerFormSubmitCallback({callbackFn:onFormSubmit}),formValidWatcherCleanupFn=$scope.$watch("$ctrl.sigOptionsForm.$valid",onFormValidChanged),vm.sigOptionsForm&&$timeout(function(){onFormValidChanged(vm.sigOptionsForm.$valid)},0))}function onFormSubmit(){vm.sigOptionsForm.$setSubmitted(!0),vm.sigOptionsForm.isSubmitted=!0,vm.sigOptionsForm.$valid||$anchorScroll("pharmacy-form-group")}function onFormValidChanged(newValue,oldValue){newValue!==oldValue&&vm.updateIsValid({isValid:newValue})}function onMedTypeChanged(){vm.optionsNonFormulary.isAdministered?(vm.options.pharmacy=null,vm.drugAdministered=!0,vm.optionsNonFormulary.daw=!1,vm.dawDisabled=!0,vm.optionsNonFormulary.isChronicMed=!1,vm.chronicDisabled=!0):(vm.optionsNonFormulary.isSampleGiven&&(vm.options.pharmacy=null),vm.drugAdministered=!1,vm.dawDisabled=!1,vm.chronicDisabled=!1),onOptionsChanged(),onOptionsNonFormularyChanged()}function onOptionsChanged(){vm.updateSigOptions({sigOptions:vm.options})}function onOptionsNonFormularyChanged(){vm.updateSigOptionsNonFormulary({sigOptionsNonFormulary:vm.optionsNonFormulary})}function onSigOptionsChanged(changesSigOptions){var pharmacyChanged=(vm.pharmacy?vm.pharmacy.Id:void 0)!==(changesSigOptions.currentValue.pharmacy?changesSigOptions.currentValue.pharmacy.Id:void 0);vm.options=_.merge(vm.options,changesSigOptions.currentValue),vm.pharmacies&&(defaultedPharmacy?pharmacyChanged&&setPharmacyById():setDefaultPharmacy())}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){var medTypeChanged=getMedicationTypeChanged(changesSigOptionsNonFormulary.currentValue,vm.optionsNonFormulary),prescriberChanged=hasPrescriberChanged(changesSigOptionsNonFormulary.currentValue,vm.optionsNonFormulary,changesSigOptionsNonFormulary.isFirstChange());vm.optionsNonFormulary=_.merge(vm.optionsNonFormulary,changesSigOptionsNonFormulary.currentValue),medTypeChanged&&onMedTypeChanged(),!defaultedProblems&&vm.problems&&setDefaultProblems(),prescriberChanged&&loadProviderDrugSettings()}function hasPrescriberChanged(current,previous,firstChange){var currentPrescriberId=current&&current.prescriber&&current.prescriber.Id,previousPrescriberId=previous&&previous.prescriber&&previous.prescriber.Id,prescriberChanged=currentPrescriberId&&(firstChange||currentPrescriberId!==previousPrescriberId);return prescriberChanged}function setDefaultPharmacy(){var foundPharmacy,searchObj;vm.options.pharmacy&&vm.options.pharmacy.Id?vm.options.pharmacy.MasterPharmacy&&vm.options.pharmacy.MasterPharmacy.PharmacyClearinghouse?foundPharmacy=vm.options.pharmacy:(searchObj={Id:vm.options.pharmacy.Id},(foundPharmacy=_(vm.pharmacies).filter(searchObj).head())||PharmacyRepository.getPharmacy(searchObj.Id).then(function(pharmacy){vm.pharmacy=pharmacy,onFindPharmacyChanged()})):(searchObj={IsPreferredPharmacy:!0},foundPharmacy=_(vm.pharmacies).filter(searchObj).head()),defaultedPharmacy=!0,foundPharmacy&&(vm.pharmacy=foundPharmacy,onFindPharmacyChanged())}function setDefaultProblems(){var currentProblems=_(vm.optionsNonFormulary.problems);vm.optionsNonFormulary.problems=_(vm.problems).filter(function(problem){return problem.DiseaseId?currentProblems.some({DiseaseId:problem.DiseaseId}):currentProblems.some(function(p){return p.Icd10Code===problem.Icd10Code&&p.Icd9Code===problem.Icd9Code})}).value(),defaultedProblems=!0,onOptionsNonFormularyChanged()}function setPharmacyById(){if(vm.options.pharmacy&&vm.options.pharmacy.Id){var selectedPharmacy=_(vm.pharmacies).filter({Id:vm.options.pharmacy.Id}).head();selectedPharmacy&&(vm.pharmacy=selectedPharmacy)}else vm.pharmacy=null}function loadProviderDrugSettings(){if(chronicMedCheckSupported){var prescriberId=vm.optionsNonFormulary&&vm.optionsNonFormulary.prescriber&&vm.optionsNonFormulary.prescriber.Id;prescriberId&&SigWriterRepository.getMaintenanceDrugSettings(vm.rxParameters.drug.MedId,prescriberId).then(function(isChronic){isChronic&&(vm.optionsNonFormulary.isChronicMed=isChronic,onOptionsNonFormularyChanged())})}}vm.chronicDisabled=!1,vm.dawDisabled=!1,vm.drugAdministered=!1,vm.generalNotes=[],vm.notesList={},vm.options=_.cloneDeep(vm.sigOptions),vm.optionsNonFormulary=_.cloneDeep(vm.sigOptionsNonFormulary),vm.parentContainerId="wizard-shell-body",vm.pharmacy=null,vm.pharmacies=null,vm.problems=null,vm.shouldDisplayEpaSpoCheckbox=!1,vm.sigOptionsForm=null,vm.$onChanges=function(changes){changes.sigOptions&&changes.sigOptions.currentValue&&onSigOptionsChanged(changes.sigOptions);changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.$onDestroy=function(){formWatcherCleanupFn&&formWatcherCleanupFn();formValidWatcherCleanupFn&&formValidWatcherCleanupFn()},vm.$onInit=function(){formWatcherCleanupFn=$scope.$watch("$ctrl.sigOptionsForm",onFormChanged),vm.shouldDisplayEpaSpoCheckbox=ServerInfoRepository.isFeatureSupported("SendPriorAuthIsSpecialty"),PatientRepository.getPharmacies(vm.rxParameters.patientId).then(function(pharmacies){vm.pharmacies=pharmacies,vm.options&&setDefaultPharmacy()}),loadPharmacyNotes(),PatientRepository.getProblems(vm.rxParameters.patientId).then(function(problems){vm.problems=problems,vm.optionsNonFormulary&&setDefaultProblems()})},vm.getRemainingPharmacyInstructionCharacters=function(){if(!vm.rxOptions||!vm.options)return 0;var metadata=vm.rxOptions.metadata.visit,maxLength=metadata&&metadata.Fields&&metadata.Fields.Prescriptions&&metadata.Fields.Prescriptions.Fields&&metadata.Fields.Prescriptions.Fields.Instructions&&metadata.Fields.Prescriptions.Fields.Instructions.Fields&&metadata.Fields.Prescriptions.Fields.Instructions.Fields.PharmacyInstruction&&metadata.Fields.Prescriptions.Fields.Instructions.Fields.PharmacyInstruction.MaxLength||0;return void 0!==vm.optionsNonFormulary.pharmacyInstructions?Math.max(0,vm.optionsNonFormulary.pharmacyInstructions?maxLength-vm.optionsNonFormulary.pharmacyInstructions.length:maxLength):0},vm.notesListChanged=function(){vm.optionsNonFormulary.internalNote&&(vm.optionsNonFormulary.internalNote+="\r\n");vm.optionsNonFormulary.internalNote+=vm.notesList.Note,onOptionsNonFormularyChanged()},vm.onFindPharmacyChanged=onFindPharmacyChanged,vm.onOptionsChanged=onOptionsChanged,vm.onOptionsNonFormularyChanged=onOptionsNonFormularyChanged}]})}(),function(){"use strict";angular.module("aprima-sigwriter").controller("SigwriterWizardDrugSearchCtrl",["SigwriterRxService","TransitionManager","deferSaving","patientId","pharmacy",function(SigwriterRxService,TransitionManager,deferSaving,patientId,pharmacy){var isValidPharmacy,previousTransition,vm=this;vm.deferSaving=deferSaving,vm.patientId=patientId,vm.usePreviousSearchText=!1,vm.onDrugSelected=function(rx){isValidPharmacy&&(rx.options.pharmacy=pharmacy);SigwriterRxService.setStoredWizardOptions(previousTransition,rx,deferSaving,isValidPharmacy),TransitionManager.transition({appRoute:"rxwizardsigwriter",opts:{}})},vm.onExistingSigSelected=function(rx){isValidPharmacy&&(rx.options.pharmacy=pharmacy);previousTransition.opts.sigwriterCompleted=!0,SigwriterRxService.setStoredSigwriterResults(rx),TransitionManager.replaceCurrentState(previousTransition)},isValidPharmacy=pharmacy&&pharmacy.Id,(previousTransition=TransitionManager.getPreviousTransition()).opts.sigwriterCompleted=!1,vm.usePreviousSearchText="rxwizardsigwriter"===previousTransition.appRoute}])}(),function(){"use strict";angular.module("aprima-sigwriter").controller("SigwriterWizardRefillCtrl",["$scope","gettext","SigwriterRxService","toaster","TransitionManager","medicationSigId","patientId",function($scope,gettext,SigwriterRxService,toaster,TransitionManager,medicationSigId,patientId){var vm=this;function onRxLoaded(rx){if(vm.$scope.removeHttpError(),!rx||!rx.drug||!rx.drug.MedId)return toaster.pop("warning","",gettext("The medication is invalid and cannot be refilled.")),void TransitionManager.goBack();SigwriterRxService.setStoredWizardOptions(TransitionManager.getPreviousTransition(),rx),TransitionManager.replaceCurrentState({appRoute:"rxwizardsigwriter",opts:{}})}vm.$scope=$scope,vm.loadingRefill=!1,vm.loadingRefill=!0,SigwriterRxService.loadFromExistingSig("RefillFromHxOnly",patientId,medicationSigId).then(onRxLoaded).catch(function(response){vm.$scope.addHttpError(response)}).finally(function(){vm.loadingRefill=!1})}])}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").filter("medCommonLanguage",[function(){return function(object,includeAbbrev,description){if(!object||object.isNull)return description||null;if(!object.PatientInstructions||!object.PatientInstructions.trim())return object.Name;var resultStr=object.PatientInstructions;includeAbbrev&&object.Name&&(resultStr+=" ("+object.Name+")");return resultStr}}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("DosingCalcModal",["$uibModal","DosingService","LicenseService","ServerInfoRepository",function($modal,DosingService,LicenseService,ServerInfoRepository){return{open:openModal,openFromSigwriter:function(sigInstruction,rxParameters,patientDetails){var params=DosingService.mapDoseParams(sigInstruction,rxParameters,patientDetails);return openModal(params.patientId,params.visitId,params.frequencyPerDay,params.ageInDays,params.medId,params.gcnSeqNo,params.weight,params.weightDate,params.height,params.heightDate,params.gestationalAge,params.doseTypeIndicator,params.icdCode)},isSupported:function(){var hasFeatures=ServerInfoRepository.isFeatureSupported(["DosingCalculation","PatientDosingDetails"]),hasLicense=LicenseService.hasFdbDosingLicense();return hasFeatures&&hasLicense}};function openModal(patientId,visitId,frequencyPerDay,ageInDays,medId,gcnSeqNo,weightKg,weightDate,heightCm,heightDate,gestationalAge,doseTypeIndicator,icdCode){var modal=$modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/dosing-calculator-modal.html",controller:"DosingCalcModalCtrl",controllerAs:"vm",resolve:{patientId:value(patientId),visitId:value(visitId),frequencyPerDay:value(frequencyPerDay),ageInDays:value(ageInDays),medId:value(medId),gcnSeqNo:value(gcnSeqNo),weightKg:value(weightKg),weightDate:value(weightDate),heightCm:value(heightCm),heightDate:value(heightDate),gestationalAge:value(gestationalAge),doseTypeIndicator:value(doseTypeIndicator),icdCode:value(icdCode)}});return modal.result}function value(val){return function(){return val}}}]),angular.module("aprima-sigwriter").controller("DosingCalcModalCtrl",["$uibModalInstance","ageInDays","doseTypeIndicator","frequencyPerDay","gcnSeqNo","gestationalAge","heightCm","heightDate","icdCode","medId","patientId","visitId","weightDate","weightKg",function($modalInstance,ageInDays,doseTypeIndicator,frequencyPerDay,gcnSeqNo,gestationalAge,heightCm,heightDate,icdCode,medId,patientId,visitId,weightDate,weightKg){var vm=this;vm.ageInDays=ageInDays,vm.doseTypeIndicator=doseTypeIndicator,vm.frequencyPerDay=frequencyPerDay,vm.gcnSeqNo=gcnSeqNo,vm.gestationalAge=gestationalAge,vm.heightCm=heightCm,vm.heightDate=heightDate,vm.icdCode=icdCode,vm.medId=medId,vm.patientId=patientId,vm.visitId=visitId,vm.weightDate=weightDate,vm.weightKg=weightKg,vm.cancel=function(){$modalInstance.dismiss()},vm.done=function(){$modalInstance.close()}}])}(window.angular),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugConsentModal",["$uibModal",function($modal){return{openModal:function(medicationConsent,formattingTemplateName){return openModalOnly(medicationConsent,formattingTemplateName).result},openModalOnly:openModalOnly};function openModalOnly(medicationConsent,formattingTemplateName){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/drug-consent-modal.html",controller:"DrugConsentModalCtrl",controllerAs:"vm",resolve:{formattingTemplateName:function(){return formattingTemplateName},medicationConsent:function(){return medicationConsent}}})}}]),angular.module("aprima-sigwriter").controller("DrugConsentModalCtrl",["$uibModalInstance","DeviceSettings","formattingTemplateName","GeneralNotesModal","GeneralNoteTypeKeys","aprgettext","medicationConsent","toaster",function($modalInstance,DeviceSettings,formattingTemplateName,GeneralNotesModal,GeneralNoteTypeKeys,gettext,medicationConsent,toaster){var vm=this;if(vm.cancel=function(){$modalInstance.dismiss()},vm.onClickSymptom=function(){GeneralNotesModal.openModal("Symptom",vm.symptom,!0,!1,GeneralNoteTypeKeys.MedicationConsent).then(function(result){vm.symptom=result})},vm.save=function(){var howDiscussed=vm.inPerson?"In-Person":vm.telephone?"Telephone":vm.telemedicine?"Telemedicine":vm.previously?"Previously":null;howDiscussed?vm.symptom&&""!==vm.symptom?$modalInstance.close({HowDiscussed:howDiscussed,Symptom:vm.symptom}):toaster.pop("error","","Symptom is required."):toaster.pop("error","",gettext("You must select an option for How Discussed."))},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},vm.formattingTemplateName=formattingTemplateName,medicationConsent){switch(medicationConsent.HowDiscussed){case"In-Person":vm.inPerson=!0;break;case"Telephone":vm.telephone=!0;break;case"Telemedicine":vm.telemedicine=!0;break;case"Previously":vm.previously=!0}vm.symptom=medicationConsent.Symptom}}])}(),angular.module("aprima-sigwriter").factory("DrugConsentWarningModal",["$uibModal","$q","$rootScope",function($modal,$q,$rootScope){"use strict";return{openDrugConsentWarningModal:function(drugName){var $scope=$rootScope.$new();$rootScope.setupDirectiveScope($scope);var deferred=$q.defer();$scope.drugConsentWarning={drugName:drugName};var drugConsentModal=$modal.open({backdrop:"static",scope:$scope,templateUrl:"/sigwriter/views/modals/drug-consent-warning-modal.html",windowClass:"modal-full"});return drugConsentModal.result.catch(function(result){deferred.reject(result)}),$scope.$on("$destroy",function(){drugConsentModal.close()}),deferred.promise}}}]),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugDetailModal",["$uibModal",function($modal){return{openDrugDetailModal:function(drug,medId,patientId,relPatientMedicationId,sigId,rxId,searchEnabled){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/drug-detail-modal.html",windowClass:"modal-full",controller:"DrugDetailModalCtrl",controllerAs:"vm",resolve:{drug:function(){return drug},medId:function(){return medId},patientId:function(){return patientId},relPatientMedicationId:function(){return relPatientMedicationId},sigId:function(){return sigId},rxId:function(){return rxId},searchEnabled:function(){return searchEnabled}}}).result}}}]),angular.module("aprima-sigwriter").controller("DrugDetailModalCtrl",["$uibModalInstance","drug","medId","patientId","relPatientMedicationId","sigId","rxId","searchEnabled",function($modalInstance,drug,medId,patientId,relPatientMedicationId,sigId,rxId,searchEnabled){var vm=this;vm.drug=drug,vm.medId=medId,vm.patientId=patientId,vm.relPatientMedicationId=relPatientMedicationId,vm.sigId=sigId,vm.rxId=rxId,vm.rxParameters=null,vm.sigInstruction=null,vm.searchEnabled=searchEnabled,vm.cancel=function(){$modalInstance.dismiss()},vm.close=function(){$modalInstance.close()},vm.searchUpdate=function(searchText){$modalInstance.close({searchText:searchText})},vm.selectDosingSuggestion=function(suggestion,instructionId){suggestion&&$modalInstance.close({suggestion:suggestion,instructionId:instructionId})},vm.showDosingContent=function(){return null!==vm.Drug},vm.rxParameters={drug:drug,medId:medId,patientId:patientId,rxId:rxId},vm.sigInstruction={id:null}}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugDocumentationModal",["$uibModal",function($modal){return{openModal:function(medId,ndc,patientId,rxId){var drug={MedId:medId,Ndc:ndc},patient={Id:patientId},something={value:medId};return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/drug-documentation-modal.html",windowClass:"modal-pdr",controller:"DrugDocumentationModalCtrl",controllerAs:"vm",resolve:{drug:drug,patient:patient,rxId:rxId,something:something}}).result}}}]),angular.module("aprima-sigwriter").controller("DrugDocumentationModalCtrl",["$uibModalInstance","drug","patient","rxId","something",function($modalInstance,drug,patient,rxId,something){var vm=this;vm.something=something,vm.drug=drug,vm.patient=patient,vm.rxId=rxId,vm.cancel=function(){$modalInstance.dismiss()},vm.close=function(){$modalInstance.close()}}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugDosingModal",["$uibModal",function($modal){return{openModal:function(rxParameters,sigInstruction){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/drug-dosing-modal.html",windowClass:"modal-full",controller:"DrugDosingModalCtrl",controllerAs:"vm",resolve:{rxParameters:rxParameters,sigInstruction:sigInstruction}}).result}}}]),angular.module("aprima-sigwriter").controller("DrugDosingModalCtrl",["$uibModalInstance","rxParameters","sigInstruction",function($modalInstance,rxParameters,sigInstruction){var vm=this,selection=null;vm.rxParameters=rxParameters,vm.sigInstruction=sigInstruction,vm.cancel=function(){$modalInstance.dismiss()},vm.close=close,vm.selectDosingSuggestion=function(suggestion,instructionId){selection=suggestion?{suggestion:suggestion,instructionId:instructionId}:null;$modalInstance.close(selection)}}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugScreeningModal",["$uibModal",function($modal){return{openModal:function(patientId,drugMedId,rxId,defaultOverrideText){var rxParameters={drug:{MedId:drugMedId},patientId:patientId,rxId:rxId},drugScreening={overrideText:defaultOverrideText};return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/drug-screening-modal.html",windowClass:"modal-full",controller:"DrugScreeningModalCtrl",controllerAs:"vm",resolve:{drugScreening:drugScreening,rxParameters:rxParameters}}).result}}}]),angular.module("aprima-sigwriter").controller("DrugScreeningModalCtrl",["$uibModalInstance","aprgettext","drugScreening","rxParameters","WizardHandler",function($modalInstance,gettext,drugScreening,rxParameters,WizardHandler){var vm=this;function cancel(){$modalInstance.dismiss()}function getWizard(){var wizard=WizardHandler.wizard(vm.wizardName);return wizard}vm.drugScreening=_.cloneDeep(drugScreening),vm.isScreeningLoaded=!1,vm.lookups={screeningTitle:gettext("Drug Screening + Alerts"),overrideTitle:gettext("Drug Screening Override")},vm.progress={requiresOverride:!1,screeningComplete:!1},vm.requiresOverride=!1,vm.rxParameters=rxParameters,vm.wizardName="DrugScreeningWizard",vm.cancel=cancel,vm.getWizard=getWizard,vm.onFinish=function(){vm.isScreeningLoaded?$modalInstance.close(vm.drugScreening):cancel()},vm.updateDrugScreening=function(updatedDrugScreening){vm.drugScreening=_.assignIn(vm.drugScreening,_.cloneDeep(updatedDrugScreening))},vm.updateIsScreeningLoaded=function(isLoaded,isOverrideRequired){vm.isScreeningLoaded=isLoaded,vm.requiresOverride=isOverrideRequired},vm.getStepTitle=function(){var wizard=getWizard();if(wizard&&wizard.totalStepCount())return wizard.currentStepTitle();return}}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("DxProblemsModal",["$uibModal",function($modal){return{openModal:function(patientId,selectedItems,formatter,orderFn){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/dx-problems-modal.html",controller:"DxProblemsModalCtrl",controllerAs:"vm",resolve:{selectedItems:function(){return selectedItems},patientId:function(){return patientId},formatter:function(){return formatter},orderFn:function(){return orderFn}}}).result}}}]),angular.module("aprima-sigwriter").controller("DxProblemsModalCtrl",["_","$uibModalInstance","debounce","ErrorService","formatter","orderFn","patientId","PatientRepository","selectedItems",function(_,$modalInstance,debounce,ErrorService,formatter,orderFn,patientId,PatientRepository,selectedItems){var vm=this;function loadData(ignoreCache){vm.loading=!0;var promise=PatientRepository.getActiveProblems(patientId,{ignoreCache:!!ignoreCache}).then(function(problems){ErrorService.removeHttpErrorFromScope(vm),vm.items=_.compact(problems),vm.items.forEach(function(item){item.previouslySelected=!1,item.selected=!1}),selectedItems&&_.intersectionBy(vm.items,selectedItems,"Uid").forEach(function(item){item.previouslySelected=!0,item.selected=!0})}).catch(function(response){ErrorService.addHttpErrorToScope(vm,response)}).finally(function(){vm.loading=!1});return promise}vm.cancel=function(){$modalInstance.dismiss()},vm.done=function(){var selected=_.filter(vm.items,"selected");$modalInstance.close(selected)},vm.clear=debounce(100,function(){if(!vm.items)return;_.forEach(vm.items,function(item){item&&(item.selected=!1)})}),vm.load=debounce(200,loadData),vm.getItemOrder=function(item){return item?""+(item.previouslySelected?0:1)+orderFn(item):"2"},vm.countSelected=function(){return vm.items?_.sumBy(vm.items,function(val){return val&&val.selected?1:0}):0},vm.loading=!1,vm.items=[],vm.formatter=formatter,loadData(!0)}])}(window.angular),angular.module("aprima-sigwriter").factory("MedicationService",["AprimaRestangular",function(AprimaRestangular){"use strict";return{getMedicationSite:function(){return AprimaRestangular.get().one("lists/medications/site").get()},getFundingSource:function(){return AprimaRestangular.get().one("lists/medications/fundingsource").get()},getManufacturer:function(){return AprimaRestangular.get().one("lists/medications/mfr").get()}}}]),function(){"use strict";angular.module("aprima-sigwriter").factory("NewDefaultSigModal",["$uibModal",function($modal){return{openModal:function(currentRx,notes){return openModalOnly(currentRx).result},openModalOnly:openModalOnly};function openModalOnly(createModifyDefaultSigDto){return $modal.open({templateUrl:"/sigwriter/views/modals/newDefaultSigModal.html",controller:"NewDefaultSigModalCtrl",controllerAs:"vm",resolve:{createModifyDefaultSigDto:function(){return createModifyDefaultSigDto}}})}}]),angular.module("aprima-sigwriter").controller("NewDefaultSigModalCtrl",["$uibModalInstance","aprgettext","createModifyDefaultSigDto","DeviceSettings","SigWriterRepository","toaster",function($modalInstance,gettext,createModifyDefaultSigDto,DeviceSettings,SigWriterRepository,toaster){var vm=this;vm.cancel=function(){$modalInstance.dismiss()},vm.ok=function(form){form.$valid&&(vm.loading=!0,createModifyDefaultSigDto.Notes=vm.notes,createModifyDefaultSigDto.Name=vm.name,createModifyDefaultSigDto.ExternalId=vm.externalId,SigWriterRepository.saveDefaultSig(createModifyDefaultSigDto).then(function(){toaster.success(gettext("New Default SIG"),gettext("Save Complete")),$modalInstance.close(!0)}).catch(function(){toaster.pop({type:"error",title:gettext("Save Failed"),body:gettext("Error saving Default SIG"),timeout:0})}).finally(function(){vm.loading=!1}))},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},SigWriterRepository.getDefaultSigMetadata(vm),vm.notes=createModifyDefaultSigDto.Notes,vm.name=createModifyDefaultSigDto.Name,vm.externalId=createModifyDefaultSigDto.ExternalId}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("RequiredScreensModal",["$uibModal",function($modal){return{openModal:function(titles){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/required-screens-modal.html",windowClass:"modal-full",controller:"RequiredScreensModalCtrl",controllerAs:"vm",resolve:{titles:function(){return titles}}}).result}}}]),angular.module("aprima-sigwriter").controller("RequiredScreensModalCtrl",["$uibModalInstance","titles",function($modalInstance,titles){function selectTitle(title){$modalInstance.close(title)}this.titles=titles,this.close=function(){selectTitle(titles[0])},this.selectTitle=selectTitle}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("SaveRxModal",["$uibModal",function($modal){return{openModal:function(savePromise){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/save-rx-modal.html",windowClass:"modal-full",controller:"SaveRxModalCtrl",controllerAs:"vm",resolve:{wrappedSavePromise:function(){return{promise:savePromise}}}}).result}}}]),angular.module("aprima-sigwriter").controller("SaveRxModalCtrl",["$uibModalInstance","ErrorService","wrappedSavePromise",function($modalInstance,ErrorService,wrappedSavePromise){var vm=this;function onFailure(error){vm.saving=!1,vm.errorMessages=ErrorService.convertToErrorMessages(error)}function onSuccess(result){$modalInstance.close(result)}vm.errorMessages=null,vm.saving=!0,vm.cancel=function(){vm.saving||$modalInstance.dismiss()},wrappedSavePromise.promise.then(onSuccess).catch(onFailure)}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterAdditionalInfoModal",["$uibModal",function($modal){return{openModal:function(optionsNonFormulary,rxOptions){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/sigwriterAdditionalInfoModal.html",controller:"SigwriterAdditionalInfoModalCtrl",controllerAs:"vm",resolve:{optionsNonFormulary:function(){return optionsNonFormulary},rxOptions:function(){return rxOptions}}}).result}}}]),angular.module("aprima-sigwriter").controller("SigwriterAdditionalInfoModalCtrl",["$uibModalInstance","_","aprgettext","DeviceSettings","optionsNonFormulary","rxOptions",function($modalInstance,_,gettext,DeviceSettings,optionsNonFormulary,rxOptions){var vm=this;vm.optionsNonFormulary=_.cloneDeep(optionsNonFormulary),vm.rxOptions=rxOptions,vm.cancel=function(){$modalInstance.dismiss()},vm.getTitle=function(){var title;if(vm.optionsNonFormulary.isAdministered)title="Administered";else{if(!vm.optionsNonFormulary.isSampleGiven)return;title="Sample Given"}return gettext(title)},vm.ok=function(){$modalInstance.close({optionsNonFormulary:vm.optionsNonFormulary})},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},null===vm.optionsNonFormulary.administeredDateTime&&(vm.optionsNonFormulary.administeredDateTime=new Date)}])}(window.angular),function(){"use strict";angular.module("aprima-sigwriter").factory("SigwriterDrugDosageSearchModal",["$uibModal",function($modal){return{openModal:function(sigType,drug,patientId,providerId){return $modal.open({templateUrl:"/sigwriter/views/sigwriterDrugDosageSearchModal.html",windowClass:"modal-full",controller:"SigwriterDrugDosageSearchModalCtrl",controllerAs:"vm",resolve:{drug:function(){return drug},patientId:function(){return patientId},providerId:function(){return providerId},sigType:function(){return sigType}}}).result}}}]),angular.module("aprima-sigwriter").controller("SigwriterDrugDosageSearchModalCtrl",["$uibModalInstance","drug","patientId","providerId","sigType",function($modalInstance,drug,patientId,providerId,sigType){var vm=this;vm.drug=drug,vm.patientId=patientId,vm.providerId=providerId,vm.sigType=sigType,vm.useAlternatives=!1,vm.cancel=function(){$modalInstance.dismiss()},vm.onDrugSelected=function(selectedDrug){$modalInstance.close(selectedDrug)},function(){switch(vm.sigType){case"EditRx":case"NewRx":case"RefillFromHx":case"RefillFromHxOnly":case"RefillMessage":vm.useAlternatives=!0;break;default:vm.useAlternatives=!1}}()}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterDrugScreeningService",["$q","DrugRepository","FncRxRepository","Guid","SigwriterScreeningModal",function($q,DrugRepository,FncRxRepository,Guid,SigwriterScreeningModal){return{getClassFromSeverity:function(severity){return severity?getClassFromSeverityLevel(severity.NormalizedSeverity):""},getClassFromSeverityLevel:getClassFromSeverityLevel,getGeriatricSeverityTitle:function(geriatricFinding){return getSeverityTitle(geriatricFinding&&geriatricFinding.Severity)},getInteractionSeverityTitle:function(interactionFinding){return getSeverityTitle(interactionFinding&&interactionFinding.Severity)},getLactationSeverityTitle:function(lactationFinding){return getSeverityTitle(lactationFinding&&lactationFinding.Severity)},getMedicalConditionSeverityTitle:function(medicalConditionFinding){return getSeverityTitle(medicalConditionFinding&&medicalConditionFinding.Severity)},getPediatricSeverityTitle:function(pediatricFinding){return getSeverityTitle(pediatricFinding&&pediatricFinding.Severity)},getPregnancySeverityTitle:function(pregnancyFinding){return getSeverityTitle(pregnancyFinding&&pregnancyFinding.Severity)},isCleanScreening:isCleanScreening,performDrugScreening:function(defaultOverrideText,drug,patientId,visitId){var drugScreeningPromise;drugScreeningPromise=visitId&&visitId!==Guid.empty()?FncRxRepository.getSigwriterNddDrugScreeningResults(patientId,visitId,drug):DrugRepository.nddDrugScreening(patientId,drug);var screeningSuccess=!1;return drugScreeningPromise.then(function(nddScreening){return screeningSuccess=!0,showDrugScreening(defaultOverrideText,nddScreening)}).catch(function(error){if(screeningSuccess)return $q.reject();var deferred=$q.defer();return SigwriterScreeningModal.openModalWithPromise(drugScreeningPromise,defaultOverrideText).finally(function(){deferred.reject(error)}),deferred.promise})},showDrugScreening:showDrugScreening};function getClassFromSeverityLevel(severityLevel){switch(severityLevel){case 10:return"low-alert";case 20:return"moderate-alert";case 30:return"high-alert";case 40:return"severe-alert"}}function getSeverityTitle(severity){return severity?severity.Severity+": "+severity.Description:""}function isCleanScreening(nddScreening){return nddScreening&&!nddScreening.Error&&"Completed"===nddScreening.Status}function showDrugScreening(defaultOverrideText,nddScreening){var result={overrideText:null,screeningResult:nddScreening.PlainText};return isCleanScreening(nddScreening)?$q.when(result):SigwriterScreeningModal.openModal(nddScreening,defaultOverrideText).then(function(modalResult){return result.overrideText=modalResult.overrideText,result})}}])}(angular),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterDrugSearchService",["$q","apConfirm","DosingService","SigwriterRxService",function($q,apConfirm,DosingService,SigwriterRxService){return{createNewRxFromDrugSearchResult:createNewRxFromDrugSearchResult,updateRxFromDrugSearchResult:function(rx,drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch){var sigType=rx.sigType,patientId=rx.patient.Id,visitInfo=rx.visit;return createNewRxFromDrugSearchResult(sigType,drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch,patientId,!1,!0,visitInfo)},validateDrugSearchResult:validateDrugSearchResult};function createNewRxFromDrugSearchResult(sigType,drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch,patientId,allowAsIs,isConsentSupported,visitInfo,patientDosingDetails){var relPatientMedicationId,sigId,canSkipSigwriter=drugSearchResult.CanSkipSigwriter,deferred=$q.defer(),validationResult=validateDrugSearchResult(drugSearchResult,isConsentSupported);if(!validationResult.success){var error="validation error";return validationResult.invalid?error="invalid drug search result":validationResult.invalidResultType?error="need to support additional drug result types":validationResult.consentUnsupported&&(error="consent is required but not supported by the calling screen"),deferred.reject(error),deferred.promise}"Patient"!==drugSearchResult.ResultType&&"DefaultProvider"!==drugSearchResult.ResultType||(sigId=drugSearchResult.SigId,relPatientMedicationId=drugSearchResult.RelPatientMedicationId);var acceptConfirmation=canSkipSigwriter&&relPatientMedicationId&&sigId&&allowAsIs?apConfirm("Accept the medication as is?","Yes","No"):$q.when(!1),promises=[acceptConfirmation];return useEnhancedDrugSearch?promises.push(SigwriterRxService.loadFromEnhancedDrugSearch(sigType,patientId,drugSearchResult,switchToGeneric,visitInfo)):sigId?promises.push(SigwriterRxService.loadFromExistingSig(sigType,patientId,sigId)):promises.push(SigwriterRxService.loadFromDrugSearchResult(sigType,patientId,drugSearchResult)),patientDosingDetails?promises.push($q.when(patientDosingDetails)):visitInfo&&visitInfo.Id?promises.push(DosingService.getVisitDosingDetails(visitInfo.Id)):promises.push(DosingService.getPatientDosingDetails(patientId)),$q.all(promises).then(function(results){var useAsIs=results[0],rx=results[1],patientDosingDetailsResult=results[2];if(rx.drug&&dosingSuggestion){var source=rx.instructions[0];source=SigwriterRxService.updateInstructionFromDosingSuggestion(source,dosingSuggestion,rx.rxOptions)}useAsIs&&(rx.relPatientMedicationId=relPatientMedicationId),rx.patientDosingDetails=patientDosingDetailsResult,deferred.resolve(rx)}).catch(function(error){deferred.reject(error)}),deferred.promise}function validateDrugSearchResult(drugSearchResult,isConsentSupported){var result={consentUnsupported:!1,invalid:!1,invalidResultType:!1,success:!0};if(!drugSearchResult||!drugSearchResult.Drug)return result.invalid=!0,result.success=!1,result;switch(drugSearchResult.ResultType){case"Drug":case"Mfu":case"Patient":case"DefaultProvider":break;default:result.invalidResultType=!0,result.success=!1}return drugSearchResult.Drug.RequiresConsent&&!isConsentSupported&&(result.consentUnsupported=!0,result.success=!1),result}}])}(angular),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterFormularyDetailsModal",["$uibModal",function($modal){return{openModal:function(details,isInfoAvailable){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/sigwriterFormularyDetailsModal.html",windowClass:"modal-full",controller:"SigwriterFormularyDetailsModalCtrl",controllerAs:"vm",resolve:{details:function(){return details},isInfoAvailable:function(){return isInfoAvailable}}}).result}}}]),angular.module("aprima-sigwriter").controller("SigwriterFormularyDetailsModalCtrl",["$uibModalInstance","details","isInfoAvailable",function($modalInstance,details,isInfoAvailable){var vm=this;vm.details=details,vm.isInfoAvailable=isInfoAvailable,vm.changeMedication=function(drug,pharmacy){$modalInstance.close({chosenMedication:{drug:drug,pharmacy:pharmacy}})},vm.cancel=function(){$modalInstance.dismiss()},vm.ok=function(){$modalInstance.close({})}}])}(window.angular),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterRxBenefitDetailsModal",["$uibModal",function($modal){return{openModal:function(eligibility){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/sigwriterRxBenefitDetailsModal.html",windowClass:"modal-full",controller:"SigwriterRxBenefitDetailsModalCtrl",controllerAs:"vm",resolve:{eligibility:function(){return eligibility}}}).result}}}]),angular.module("aprima-sigwriter").controller("SigwriterRxBenefitDetailsModalCtrl",["$uibModalInstance","eligibility",function($modalInstance,eligibility){this.eligibility=eligibility,this.cancel=function(){$modalInstance.dismiss()}}])}(window.angular),function(){"use strict";angular.module("aprima-sigwriter").factory("SigwriterRxService",["$q","CurrentUser","DeviceSettings","DrugRepository","DosingService","FncRxRepository","Guid","ListService","medCommonLanguageFilter","MedicationService","MetadataRepository","moment","PatientRepository","SigRepository","SigWriterRepository","ServerInfoRepository","SettingService","SystemGuid",function($q,CurrentUser,DeviceSettings,DrugRepository,DosingService,FncRxRepository,Guid,ListService,medCommonLanguage,MedicationService,MetadataRepository,moment,PatientRepository,SigRepository,SigWriterRepository,ServerInfoRepository,SettingService,SystemGuid){var storedSigwriterResults,storedWizardOptions,findDosage=_.partial(findOption,0),findUnit=_.partial(findOption,1),findRoute=_.partial(findOption,2),findFrequency=_.partial(findOption,3),findPrnReason=_.partial(findOption,4),findRefill=_.partial(findOption,6),rxPromises={};return{addOtherDrugsForScreening:function(rx,otherDrugs){rx.drugScreening.otherDrugs=otherDrugs},findDosage:findDosage,findFrequency:findFrequency,findPrnReason:findPrnReason,findRoute:findRoute,findUnit:findUnit,getDrugDetail:function(medId,patientId,relPatientMedicationId,sigId,rxId){return getDataLoadPromise("detail",function(){return DrugRepository.getDrugDetail(medId,patientId,relPatientMedicationId,sigId)},[medId,patientId,relPatientMedicationId,sigId,rxId].join("-"))},getDrugDocumentation:function(medId,ndc,patientId,briefMode,rxId){return getDataLoadPromise("documentation",function(){return DrugRepository.getDrugDocumentation(medId,ndc,patientId,briefMode)},[medId,ndc,patientId,briefMode,rxId].join("-"))},getDrugDosingSuggestions:function(patientId,medId,rxId){return getDataLoadPromise("dosing",function(){return DrugRepository.getDrugDosingSuggestions(patientId,medId)},[patientId,medId,rxId].join("-"))},getDrugScreeningResults:function(patientId,medId,rxId){return getDataLoadPromise("screening",function(){return DrugRepository.drugScreening(patientId,medId)},[patientId,medId,rxId].join("-"))},getPrimaryMedication:function(details,sigOptionsNonFormulary){var med;if(details){var dispenseAsWritten=!!sigOptionsNonFormulary&&sigOptionsNonFormulary.daw;if(med=findPrimaryMedication(details.ResponsePMBC,details.ResponseRFS,dispenseAsWritten)){var rfsMed=findPrimaryMedication(null,details.ResponseRFS,dispenseAsWritten),restrictions=rfsMed?rfsMed.FormularyCoverageRestrictions:null,formularyStatus=med.FormularyStatusTerse||!rfsMed?med.FormularyStatusTerse:rfsMed.FormularyStatusTerse;return{copays:med.DisplayCopay?med.DisplayCopay:med.DisplayPricingCoverages,formularyCoverageRestrictions:restrictions,formularyStatus:formularyStatus,name:med.Description,requiresPa:null!=med.RequiresPA?med.RequiresPA:!!rfsMed&&rfsMed.RequiresPA}}}return null},getRemainingSigCharacters:function(sigInstruction){var maxLength=140;sigInstruction&&sigInstruction.sigString&&(maxLength-=sigInstruction.sigString.length);return maxLength},getRemainingPharmacyInstructionsCharacters:function(pharmacyInstructions){var maxLength=210;pharmacyInstructions&&(maxLength-=pharmacyInstructions.length);return maxLength},getMaxPharmacyInstructionsCharacters:function(){return 210},getRemainingInternalNoteCharacters:function(internalNote){var maxLength=210;internalNote&&(maxLength-=internalNote.length);return maxLength},getMaxInternalNoteCharacters:function(){return 210},getStoredSigwriterResults:function(){return storedSigwriterResults},getStoredWizardOptions:function(){return storedWizardOptions},isDaysValid:function(instruction){var daysName=instruction.days&&instruction.days.Name;if(!daysName)return!instruction.repeatSigCount;var strDays=daysName.toString();if(-1<strDays.indexOf("."))return!1;var numDays=parseFloat(strDays);return 0<=numDays&&numDays<1e3},loadFromDrugSearchResult:function(sigType,patientId,dsr){return $q.all([loadOptions(sigType),PatientRepository.getPatient(patientId)]).then(function(results){var rxOptions=results[0],patient=results[1],currentRx=startNewRx(sigType,rxOptions,dsr.Drug,patient,null);return getCurrentRxWithoutSig(currentRx,patient),currentRx})},loadFromEnhancedDrugSearch:function(sigType,patientId,dsr,switchToGeneric,visitInfo){var patientPromise=patientId&&patientId!==Guid.empty()?PatientRepository.getPatient(patientId):$q.when({}),pharmacyPromise=patientId&&patientId!==Guid.empty()?PatientRepository.getPharmacies(patientId):$q.when([]),drugSelected={CanSkipSigwriter:dsr.CanSkipSigwriter,Drug:dsr.Drug,SigId:dsr.SigId,SwitchToGeneric:switchToGeneric},useSigwriterResults=ServerInfoRepository.isFeatureSupported("SigwriterResults"),visitId=visitInfo?visitInfo.visitId:null,sigPromise=useSigwriterResults?SigWriterRepository.startNewRx(patientId,visitId,sigType,drugSelected):SigWriterRepository.getDrugSelected(drugSelected),visitPromise=visitId?SigWriterRepository.getVisitInfo(visitId):$q.when(visitInfo),promises=[loadOptions(sigType),patientPromise,pharmacyPromise,sigPromise,visitPromise],isSpecialty=visitInfo&&visitInfo.RenderingProvider&&drugSelected.Drug&&drugSelected.Drug.Ndc&&drugSelected.Drug.RxNorm;if(isSpecialty){var specialtyPromise=visitInfo.RenderingProvider.SPI?DrugRepository.checkIsSpecialtySPI(drugSelected.Drug.Ndc,drugSelected.Drug.RxNormCode,visitInfo.RenderingProvider.SPI):DrugRepository.checkIsSpecialtyId(drugSelected.Drug.Ndc,drugSelected.Drug.RxNormCode,visitInfo.RenderingProvider.Id);promises.push(specialtyPromise)}return $q.all(promises).then(function(results){var rxOptions=results[0],patient=results[1];null!=patient&&(patient.pharmacies=results[2]);var sig=results[3],visit=results[4];isSpecialty&&(isSpecialty=results[5]);var currentRx=startNewRx(sigType,rxOptions,sig.Drug,patient,visit,isSpecialty);return dsr.SigId&&useSigwriterResults?(getCurrentRxWithSigwriterResultsDto(currentRx,rxOptions,sig),currentRx.options.pharmacy=findPharmacy(sig.Pharmacy,patient)):dsr.SigId&&!useSigwriterResults?getCurrentRxWithPrescriptionDto(currentRx,patient,rxOptions,sig):getCurrentRxWithoutSig(currentRx,patient),currentRx})},loadFromExistingRelVisitMedication:function(sigType,patientId,relVisitMedicationId,visitInfo,getStateFromDesktopContext){return $q.all([FncRxRepository.getRx(sigType,relVisitMedicationId)]).then(function(results){var sigwriterResultsDto=results[0];if(getStateFromDesktopContext){var result=getStateFromDesktopContext({sigType:sigType,relVisitMedicationId:relVisitMedicationId});if(result)return result.then(function(state){sigwriterResultsDto.Procedure=state.Procedure,sigwriterResultsDto.IncludeMonograph=state.IncludeMonograph;var currentRxPromise=loadFromSigwriterResultsDto(sigType,patientId,sigwriterResultsDto,visitInfo);return currentRxPromise})}var currentRxPromise=loadFromSigwriterResultsDto(sigType,patientId,sigwriterResultsDto,visitInfo);return currentRxPromise})},loadFromExistingSig:function(sigType,patientId,sigId){var useSigwriterResults=ServerInfoRepository.isFeatureSupported("SigwriterResults"),sigPromise=useSigwriterResults?SigRepository.getSigwriterResults(sigType,sigId):SigRepository.getSig(sigId);return $q.all([loadOptions(sigType),PatientRepository.getPatient(patientId),PatientRepository.getPharmacies(patientId),sigPromise]).then(function(results){var rxOptions=results[0],patient=results[1];patient.pharmacies=results[2];var sig=results[3],currentRx=startNewRx(sigType,rxOptions,sig.Drug,patient,null);return useSigwriterResults?getCurrentRxWithSigwriterResultsDto(currentRx,rxOptions,sig):getCurrentRxWithPrescriptionDto(currentRx,patient,rxOptions,sig),currentRx.options.pharmacy=findPharmacy(sig.Pharmacy,patient),currentRx})},loadFromSigwriterResultsDto:loadFromSigwriterResultsDto,loadOptions:loadOptions,mapToVisitDto:function(rx){return{BillingProvider:null,RenderingProvider:null,Date:moment().format(),IsCompleted:!0,MarkReadyToPrescribe:!0,ClinicalNoteType:{Id:"10101010-1111-0000-0000-000000000001"},Patient:{Id:rx.patient.Id},VisitType:{Id:"ADA7EB5D-FD9A-4E9F-88E5-84EDDA9EFC42",Description:"Refill Visit",ExternalId:""},ServiceSite:null,FinancialCenter:null,Appointment:null,ProviderCareType:null,ReferredByProvider:null,ReferringDate:null,Account:null,PatientCase:null,SavedByBillingProvider:!0,SavedByRenderingProvider:!0,CompletedDate:moment().format(),Prescriptions:mapToVisitPrescriptions(rx),EpcsSignature:rx.epcsSignature}},mapToVisitPrescriptions:mapToVisitPrescriptions,mapToSigwriterResultsDto:mapToSigwriterResultsDto,mergeDefaultSigWithCreateModifyDefaultSigDto:function(defaultSig,createModifyDefaultSigDto){return createModifyDefaultSigDto.ProviderDefaultSigId=defaultSig.id,createModifyDefaultSigDto.Name=defaultSig.name,createModifyDefaultSigDto.Notes=defaultSig.notes,createModifyDefaultSigDto.ExternalId=defaultSig.externalId,createModifyDefaultSigDto},mergeRxWithDefaultSig:function(currentRx,defaultSigRx){currentRx&&currentRx.instructions&&currentRx.instructions[0]&&(defaultSigRx.instructions[0]=defaultSigRx.instructions[0]?_.mergeWith({},currentRx.instructions[0],defaultSigRx.instructions[0],customizer):currentRx.instructions[0]);currentRx&&currentRx.optionsNonFormulary&&(defaultSigRx.optionsNonFormulary=defaultSigRx.optionsNonFormulary?_.mergeWith({},currentRx.optionsNonFormulary,defaultSigRx.optionsNonFormulary,customizer):currentRx.optionsNonFormulary);return defaultSigRx;function customizer(a,b){return null===b||""===b?a:void 0}},newCreateModifyDefaultSigDto:function(rx){return{ProviderDefaultSigId:null,Name:null,Notes:null,ExternalId:null,VisitPrescription:mapToSigwriterResultsDto(rx)}},newId:newId,newRxInstructions:newRxInstructions,setRxDrug:setRxDrug,setRxInstructions:setRxInstructions,setStoredSigwriterResults:function(rx,visit){storedSigwriterResults={rx:rx,visit:visit}},setStoredWizardOptions:function(previousTransition,rx,isDeferredRx,isFixedPharmacy){storedWizardOptions={previousTransition:previousTransition,rx:rx,isDeferredRx:isDeferredRx,isFixedPharmacy:isFixedPharmacy}},startNewRx:startNewRx,toggleQuantityType:function(instruction){if(instruction.disallowAutoQuantity)return!1;return instruction.isManualQuantity=!instruction.isManualQuantity,!0},updateInstructionFromDosingSuggestion:function(instruction,dosingSuggestion,rxOptions){instruction.dosage={Name:dosingSuggestion.Quantity},instruction.frequency=dosingSuggestion.Frequency,instruction.postFrequency=dosingSuggestion.PostFrequency,instruction.unit=dosingSuggestion.Units,instruction.postUnit=dosingSuggestion.PostUnits,dosingSuggestion.Duration&&(instruction.days=findDuration(null,dosingSuggestion.Duration.toString(),rxOptions));return instruction}};function dateDiffInDays(a,b){a=new Date(a),b=new Date(b);var utc1=Date.UTC(a.getFullYear(),a.getMonth(),a.getDate()),utc2=Date.UTC(b.getFullYear(),b.getMonth(),b.getDate());return Math.floor(Math.abs(utc1-utc2)/864e5)}function findDuration(id,name,rxOptions){var duration=findOption(5,id,name,rxOptions);return duration||{Id:id,Name:name}}function findOption(optionIndex,id,name,rxOptions){var optionList=_(rxOptions.options[optionIndex].items),result=id?optionList.filter({Id:id}).head():null;return result||(result=optionList.filter({Name:name}).head()),!result&&name&&(result=optionList.filter(function(opt){return opt.PatientInstructions&&opt.PatientInstructions.toLowerCase()===name.toLowerCase()}).head()),result}function findPharmacy(pharmacy,patient){return pharmacy?{Id:pharmacy.Id}:patient&&patient.pharmacies&&patient.pharmacies[0]?patient.pharmacies[0]:null}function getDataLoadPromise(dataType,loadfunction,cacheId){var key=dataType+"-"+cacheId,existingPromise=rxPromises[key];return existingPromise||(existingPromise=loadfunction().catch(function(error){return rxPromises[key]=null,$q.reject(error)}),rxPromises[key]=existingPromise),existingPromise}function getDosageAmount(instruction,uom){var dosageAmount;if(instruction&&instruction.dosage)if(_.isString(instruction.dosage.Name)&&0<=instruction.dosage.Name.indexOf("/")){var components=instruction.dosage.Name.split("/"),numerator=parseInt(components[0]),denominator=parseInt(components[1]);dosageAmount=!numerator||!denominator||numerator<0||denominator<0?0:numerator/denominator}else dosageAmount=parseFloat(instruction.dosage.Name||0)||0;else dosageAmount=0;return function(unit,uom){if(!unit||!uom)return!1;var uomMl=uom.Id===SystemGuid.sigQtyUomMilliliter,imperialLiquidUnit=unit.Id===SystemGuid.medicationUnitTeaspoons||unit.Id===SystemGuid.medicationUnitTablespoons||unit.Id===SystemGuid.medicationUnitOz;return uomMl&&imperialLiquidUnit}(instruction&&instruction.unit,uom)&&(dosageAmount=DosingService.convertToCommonUnit(instruction.unit.Id,dosageAmount)),dosageAmount}function getDosageQuantity(instruction,uom){var dosageAmount=getDosageAmount(instruction,uom),dosesPerDay=getDosesPerDay(instruction),days=parseInt(instruction.days&&instruction.days.Name||0)||0;return Math.ceil(dosageAmount*dosesPerDay*days)}function getDosesPerDay(instruction){return instruction&&instruction.frequency&&parseFloat(instruction.frequency.DosesPerDay||0)||0}function loadFromSigwriterResultsDto(sigType,patientId,sigwriterResultsDto,visitInfo,patientDosingDetails){var patientDosingDetailsPromise,patientPromise=patientId&&patientId!==Guid.empty()?PatientRepository.getPatient(patientId):$q.when({}),pharmacyPromise=patientId&&patientId!==Guid.empty()?PatientRepository.getPharmacies(patientId):$q.when([]),problemsPromise=patientId&&patientId!==Guid.empty()?PatientRepository.getActiveProblems(patientId):$q.when([]);return patientDosingDetailsPromise=patientDosingDetails?$q.when(patientDosingDetails):visitInfo&&visitInfo.Id?DosingService.getVisitDosingDetails(visitInfo.Id):DosingService.getPatientDosingDetails(patientId),$q.all([loadOptions(sigType),patientPromise,pharmacyPromise,problemsPromise,patientDosingDetailsPromise]).then(function(results){var rxOptions=results[0],patient=results[1];null!=patient&&(patient.pharmacies=results[2]);var problems=results[3],patientDosingDetailsResult=results[4],currentRx=startNewRx(sigType,rxOptions,sigwriterResultsDto.Drug,patient,visitInfo);return getCurrentRxWithSigwriterResultsDto(currentRx,rxOptions,sigwriterResultsDto),currentRx.options.pharmacy=findPharmacy(sigwriterResultsDto.Pharmacy,patient),currentRx.optionsNonFormulary.problems=function(problems,activeProblems){return problems&&activeProblems?(problems.forEach(function(problem,index,array){var activeProblem=_.find(activeProblems,function(p){return!!(problem.Icd9Code||problem.Icd10Code||problem.DiseaseId)&&(problem.IsProblem?p.DiseaseId===problem.DiseaseId:p.Icd9Code===problem.Icd9Code&&p.Icd10Code===problem.Icd10Code)});array[index]=activeProblem}),problems):null}(sigwriterResultsDto.Problems,problems),currentRx.patientDosingDetails=patientDosingDetailsResult,currentRx})}function getCurrentRxWithoutSig(currentRx,patient){var newInstructions=newRxInstructions(currentRx);currentRx.currentInstruction=setRxInstructions(currentRx,newInstructions),patient&&patient.pharmacies&&patient.pharmacies[0]&&(currentRx.options.pharmacy=patient.pharmacies[0]),setDefaultPrescriber(currentRx)}function getCurrentRxWithPrescriptionDto(currentRx,patient,rxOptions,sig){var instructions=_(sig.Instructions).sortBy("DisplayOrder"),firstInstruction=instructions.head();currentRx.optionsNonFormulary.daw=sig.DispenseAsWritten,currentRx.optionsNonFormulary.includeMonograph=sig.IncludeMonograph,currentRx.optionsNonFormulary.internalNote=firstInstruction.InternalNotes,currentRx.optionsNonFormulary.isChronicMed=sig.IsMaintenanceMedication,currentRx.options.pharmacy={Id:sig.PharmacyId},!currentRx.options.pharmacy.Id&&patient.pharmacies&&patient.pharmacies[0]&&(currentRx.options.pharmacy=patient.pharmacies[0]),currentRx.optionsNonFormulary.pharmacyInstructions=firstInstruction.PharmacyInstruction,currentRx.optionsNonFormulary.category=_(rxOptions.lists.medicationsCategories).filter({Id:sig.CategoryId}).head(),currentRx.options.uom=_(rxOptions.lists.unitsOfMeasure).filter({Id:sig.UnitOfMeasureId}).head(),instructions.forEach(function(source){var mappedInstruction={startText:source.StartText,dosage:findDosage(null,source.DosageQuantity,rxOptions)||source.DosageQuantity?{Name:source.DosageQuantity}:null,postDosage:source.PostDosageQuantityText,unit:findUnit(source.DosageUomId,source.DosageUom,rxOptions),postUnit:source.PostDosageUomText,route:findRoute(source.RouteId,source.Route,rxOptions)||findRoute(null,sig.Route,rxOptions),postRoute:source.PostRouteText,frequency:findFrequency(source.FrequencyId,source.Frequency,rxOptions),postFrequency:source.PostFrequencyText,isPrn:source.PrescribeAsNeeded,prnReason:source.PrescribeAsNeeded?findPrnReason(source.PrnReasonId,source.PrnReason,rxOptions):null,postPrn:source.PostPrnText,endText:source.EndText,quantity:source.TotalQuantity,days:{Name:source.Days},refills:{Name:source.Refills},startDate:moment().startOf("day").toDate(),source:"SIG"};mappedInstruction.isManualQuantity=!!getIsManualQuantity(mappedInstruction,currentRx.options.uom),setRxInstructions(currentRx,mappedInstruction)}),setDefaultPrescriber(currentRx)}function getCurrentRxWithSigwriterResultsDto(currentRx,rxOptions,sigwriterResultsDto){var dto,category=sigwriterResultsDto.Category,instruction=sigwriterResultsDto.Instruction||{},uom=sigwriterResultsDto.UnitOfMeasure;currentRx.optionsNonFormulary.authorCode=sigwriterResultsDto.AuthorCode,currentRx.optionsNonFormulary.administeredDateTime=sigwriterResultsDto.AdministeredDateTime,currentRx.optionsNonFormulary.category=category?_(rxOptions.lists.medicationCategories).filter({Id:category.Id}).head():null,currentRx.optionsNonFormulary.daw=sigwriterResultsDto.DispenseAsWritten,currentRx.optionsNonFormulary.expirationDate=sigwriterResultsDto.ExpirationDate,currentRx.optionsNonFormulary.includeMonograph=sigwriterResultsDto.IncludeMonograph,currentRx.optionsNonFormulary.initials=sigwriterResultsDto.Initials,currentRx.optionsNonFormulary.internalNote=instruction.InternalNote,currentRx.optionsNonFormulary.isAdministered=sigwriterResultsDto.IsAdministered,currentRx.optionsNonFormulary.isChronicMed=sigwriterResultsDto.IsMaintenanceMedication,currentRx.optionsNonFormulary.isSampleGiven=sigwriterResultsDto.IsSampleGiven,currentRx.optionsNonFormulary.lotNumber=sigwriterResultsDto.LotNumber,currentRx.optionsNonFormulary.fundingSource=sigwriterResultsDto.MedicationFundingSource,currentRx.optionsNonFormulary.manufacturer=sigwriterResultsDto.MedicationManufacturer,currentRx.optionsNonFormulary.medicationSite=sigwriterResultsDto.MedicationSite,currentRx.options.eRxEligibility=sigwriterResultsDto.PatienteRxEligibility,currentRx.optionsNonFormulary.pharmacyInstructions=instruction.PharmacyInstructions,currentRx.optionsNonFormulary.prescriber=sigwriterResultsDto.Prescriber,currentRx.optionsNonFormulary.procedure=sigwriterResultsDto.Procedure,currentRx.relVisitMedicationId=sigwriterResultsDto.RelVisitMedicationId,currentRx.optionsNonFormulary.sendPriorAuth=sigwriterResultsDto.SendPriorAuth,currentRx.optionsNonFormulary.sendIsSpecialty=sigwriterResultsDto.SendIsSpecialty,currentRx.drugScreening.overrideText=sigwriterResultsDto.ScreeningOverride,currentRx.drugScreening.screeningResult=sigwriterResultsDto.ScreeningResult,currentRx.options.uom=uom?_(rxOptions.lists.unitsOfMeasure).filter({Id:uom.Id}).head():null,currentRx.optionsNonFormulary.MedicationConsent=(dto=sigwriterResultsDto).MedicationConsentInfoHowDiscussed||dto.MedicationConsentInfoSymptom?{HowDiscussed:sigwriterResultsDto.MedicationConsentInfoHowDiscussed,Symptom:sigwriterResultsDto.MedicationConsentInfoSymptom}:null;var dosageUnit=instruction.DosageUnit,frequency=instruction.Frequency,prnReason=sigwriterResultsDto.IsPrn&&sigwriterResultsDto.PrnReason,route=sigwriterResultsDto.Route,parsedQuantity=parseInt(instruction.TotalQuantity),endDate=instruction.StopDate?moment(instruction.StopDate).startOf("day").toDate():null,startDate=instruction.StartDate?moment(instruction.StartDate).startOf("day").toDate():moment().startOf("day").toDate(),mappedInstruction={days:instruction.Days?{Name:instruction.Days}:null,dosage:findDosage(null,instruction.DosageQuantity,rxOptions)||instruction.DosageQuantity?{Name:instruction.DosageQuantity}:null,endDate:endDate,endText:instruction.EndText,frequency:frequency?findFrequency(frequency.Id,frequency.PatientInstructions,rxOptions):null,isPrn:sigwriterResultsDto.IsPrn,postDosage:instruction.PostDosageQuantityText,postFrequency:instruction.PostFrequencyText,postPrn:instruction.PostPrnText,postRoute:instruction.PostRouteText,postUnit:instruction.PostDosageUnitText,prnReason:prnReason?findPrnReason(prnReason.Id,prnReason.Name,rxOptions):null,quantity:0<parsedQuantity?parsedQuantity:null,refills:{Name:sigwriterResultsDto.RefillQuantity},route:route?findRoute(route.Id,route.PatientInstructions,rxOptions):null,source:"SIG",startDate:startDate,startText:instruction.StartText,unit:dosageUnit?findUnit(dosageUnit.Id,dosageUnit.PatientInstructions,rxOptions):null};mappedInstruction.isManualQuantity=!!getIsManualQuantity(mappedInstruction,currentRx.options.uom),setRxInstructions(currentRx,mappedInstruction),setDefaultPrescriber(currentRx)}function getIsManualQuantity(instruction,uom){return!instruction.quantity||instruction.quantity!==getDosageQuantity(instruction,uom)}function loadOptions(sigType){var sigMetadataSupported=ServerInfoRepository.isFeatureSupported("SigMetadata"),medicationTypesSupported=ServerInfoRepository.isFeatureSupported("MedicationTypes"),surescriptsRFSPMBCSupported=ServerInfoRepository.isFeatureSupported("SurescriptsRFSPMBC"),imperialUnitsAllowed=SettingService.imperialUnitsAllowed(),optionsPromises=[ListService.getList({name:"medications-units",params:{excludeImperial:!imperialUnitsAllowed}}),ListService.getList("medications-routes"),ListService.getList("medications-frequencies"),ListService.getList("medications-prn-reasons"),ListService.getList("medications-days"),ListService.getList("medications-refills"),ListService.getList("unitsofmeasure"),MetadataRepository.getMetadata("visit")];return sigMetadataSupported?optionsPromises.push(MetadataRepository.getMetadata("sig"),FncRxRepository.getAuthorizedPrescriberList(sigType)):optionsPromises.push($q.when(),$q.when()),medicationTypesSupported&&optionsPromises.push(MedicationService.getFundingSource(),MedicationService.getManufacturer(),MedicationService.getMedicationSite(),ListService.getList("medications-categories")),surescriptsRFSPMBCSupported&&optionsPromises.push(DrugRepository.getDrugRepresentativeFormularies(0)),$q.all(optionsPromises).then(function(arr){var currentIndex=0,rxLists={medicationsDosages:[{Name:"1/2",Id:"0.5"},{Name:"3/4",Id:"0.75"},{Name:"1",Id:"1"},{Name:"2",Id:"2"},{Name:"3",Id:"3"},{Name:"4",Id:"4"},{Name:"5",Id:"5"},{Name:"6",Id:"6"},{Name:"7",Id:"7"},{Name:"8",Id:"8"},{Name:"9",Id:"9"},{Name:"30",Id:"30"}],medicationsUnits:getNextResult(),medicationsRoutes:getNextResult(),medicationsFrequencies:getNextResult(),medicationsPrnReasons:getNextResult(),medicationsDays:getNextResult(),medicationsRefills:getNextResult(),unitsOfMeasure:getNextResult()},options=function(options){return[{name:"Dosage Amount",key:"dosage",items:options.dosages,allowNumericFreeEntry:!0},{name:"Dosage Type",key:"unit",items:options.units},{name:"Route",key:"route",items:options.routes},{name:"Frequency",key:"frequency",items:options.frequencies},{name:"PRN?",key:"prnReason",items:options.prnReasons},{name:"Days",key:"days",items:options.days,allowNumericFreeEntry:!0},{name:"Refill",key:"refills",items:options.refills,allowNumericFreeEntry:!0}]}({dosages:_.union([{Name:"None",isNull:!0}],rxLists.medicationsDosages),units:_.union([{Name:"None",isNull:!0}],rxLists.medicationsUnits),routes:_.union([{Name:"None",isNull:!0}],rxLists.medicationsRoutes),frequencies:_.union([{Name:"None",isNull:!0}],rxLists.medicationsFrequencies),prnReasons:_.union([{Name:"None",isNull:!0}],rxLists.medicationsPrnReasons),days:_.union([{Name:"None",isNull:!0}],rxLists.medicationsDays),refills:_.union([{Name:"None",isNull:!0}],rxLists.medicationsRefills)}),metadata={visit:getNextResult(),sig:getNextResult()},authorizedPrescribers=getNextResult(),additionalMedInfo={isMedicationTypeEditable:!1,medTypes:[{name:"Standard",Id:1},{name:"Administered",Id:2},{name:"Sample Given",Id:3}]},rxOptions={additionalMedInfo:additionalMedInfo,authorizedPrescribers:authorizedPrescribers,lists:rxLists,metadata:metadata,options:options};return medicationTypesSupported&&(additionalMedInfo.isMedicationTypeEditable=!0,additionalMedInfo.fundingSources=getNextResult(),additionalMedInfo.manufacturers=getNextResult(),additionalMedInfo.medicationSites=getNextResult(),rxLists.medicationCategories=getNextResult()),surescriptsRFSPMBCSupported&&(rxOptions.initialFormularyData=getNextResult()),rxOptions;function getNextResult(){var nextResult=arr[currentIndex];return currentIndex++,nextResult}})}function mapToVisitPrescriptions(rx){if(!rx||!rx.drug)return[];var isAdministered=0,isSampleGiven=0;rx.optionsNonFormulary.isAdministered?isAdministered=1:rx.optionsNonFormulary.isSampleGiven&&(isSampleGiven=1);var problemDisplayOrder=0,diagnosisDisplayOrder=0,instructionDisplayOrder=0,prescriptions=[{RelVisitMedicationId:rx.relVisitMedicationId,DrugMedId:rx.drug.MedId,DrugDescription:rx.drug.Description,DrugStrength:rx.drug.Strength,DrugStrengthUnits:rx.drug.StrengthUnits,DrugNdc:rx.drug.Ndc,DrugRxNormCode:rx.drug.RxNormCode,DrugRxNormQualifier:rx.drug.RxNormQualifier,UnitOfMeasureCode:rx.options.uom?rx.options.uom.NCtlCode:null,UnitOfMeasureName:rx.options.uom?rx.options.uom.Name:null,UnitOfMeasureId:rx.options.uom?rx.options.uom.Id:null,CategoryId:rx.optionsNonFormulary.category?rx.optionsNonFormulary.category.Id:null,DispenseAsWritten:rx.optionsNonFormulary.daw,SiteId:rx.optionsNonFormulary.medicationSite?rx.optionsNonFormulary.medicationSite.Id:null,LotNumber:rx.optionsNonFormulary.lotNumber,MfrId:rx.optionsNonFormulary.manufacturer?rx.optionsNonFormulary.manufacturer.Id:null,FundingSourceId:rx.optionsNonFormulary.fundingSource?rx.optionsNonFormulary.fundingSource.Id:null,ExpirationDate:rx.optionsNonFormulary.expirationDate,IsSampleGiven:isSampleGiven,IsAdministered:isAdministered,Initials:rx.optionsNonFormulary.initials,AdministeredDate:rx.optionsNonFormulary.administeredDateTime,IsMaintenanceMedication:rx.optionsNonFormulary.isChronicMed,IsControlledSubstance:"0"!==rx.drug.FederalDeaClassCode,IncludeMonograph:rx.optionsNonFormulary.includeMonograph,PharmacyId:rx.options.pharmacy?rx.options.pharmacy.Id:null,PharmacyInstruction:rx.optionsNonFormulary.pharmacyInstructions,InternalNote:rx.optionsNonFormulary.internalNote,Problems:_(rx.optionsNonFormulary.problems).filter({IsProblem:!0}).map(function(p){return{ProblemId:p.DiseaseId,DisplayOrder:problemDisplayOrder++}}).value(),Diagnoses:_(rx.optionsNonFormulary.problems).filter({IsProblem:!1}).map(function(p){return{DiagnosisId:p.DiagnosisId,Icd9Code:p.Icd9Code,Icd10Code:p.Icd10Code,Description:p.Description,DisplayOrder:diagnosisDisplayOrder++}}).value(),Instructions:_(rx.instructions).map(function(d){return{StartText:d.startText,DosageQuantity:d.dosage&&d.dosage.Name,PostDosageQuantityText:d.postDosage,DosageUomId:d.unit?d.unit.Id:null,DosageUomName:d.unit?d.unit.Name:null,PostDosageUomText:d.postUnit,RouteId:d.route?d.route.Id:null,PostRouteText:d.postRoute,FrequencyId:d.frequency?d.frequency.Id:null,FrequencyName:d.frequency?d.frequency.Name:null,PostFrequencyText:d.postFrequency,PrescribeAsNeeded:!!d.isPrn,PrnReasonId:d.isPrn&&d.prnReason&&!d.prnReason.isNull?d.prnReason.Id:null,PostPrnText:d.postPrn,EndText:d.endText,StartDate:d.startDate,Days:d.days?parseInt(d.days.Name):null,TotalQuantity:d.quantity,Refills:d.refills?parseInt(d.refills.Name):null,DisplayOrder:instructionDisplayOrder++,PharmacyInstruction:rx.optionsNonFormulary.pharmacyInstructions,InternalNote:rx.optionsNonFormulary.internalNote}}).value(),ScreeningOverride:rx.drugScreening.overrideText,ScreeningResult:rx.drugScreening.screeningResult,SendPriorAuth:rx.optionsNonFormulary.sendPriorAuth,SendIsSpecialty:rx.optionsNonFormulary.sendIsSpecialty}];return prescriptions}function mapToSigwriterResultsDto(rx){var instruction=rx.instructions[0];return{AuthorCode:rx.optionsNonFormulary.authorCode,AdministeredDateTime:rx.optionsNonFormulary.administeredDateTime,Category:rx.optionsNonFormulary.category,DispenseAsWritten:rx.optionsNonFormulary.daw,Drug:rx.drug,ExpirationDate:rx.optionsNonFormulary.expirationDate,FormularyResults:rx.sigFormulary,IncludeMonograph:rx.optionsNonFormulary.includeMonograph,Initials:rx.optionsNonFormulary.initials,Instruction:{Days:instruction.days?parseInt(instruction.days.Name):null,DosageQuantity:instruction.dosage&&instruction.dosage.Name,DosageUnit:instruction.unit,EndText:instruction.endText,Frequency:instruction.frequency,InternalNote:rx.optionsNonFormulary.internalNote,PharmacyInstructions:rx.optionsNonFormulary.pharmacyInstructions,PostDosageQuantityText:instruction.postDosage,PostDosageUnitText:instruction.postUnit,PostFrequencyText:instruction.postFrequency,PostPrnText:instruction.postPrn,PostRouteText:instruction.postRoute,StartDate:instruction.startDate,StartText:instruction.startText,StopDate:instruction.endDate,TotalQuantity:instruction.quantity},IsAdministered:rx.optionsNonFormulary.isAdministered,IsMaintenanceMedication:rx.optionsNonFormulary.isChronicMed,IsPrn:!!instruction.isPrn,IsSampleGiven:rx.optionsNonFormulary.isSampleGiven,LotNumber:rx.optionsNonFormulary.lotNumber,MedicationFundingSource:rx.optionsNonFormulary.fundingSource,MedicationManufacturer:rx.optionsNonFormulary.manufacturer,MedicationSite:rx.optionsNonFormulary.medicationSite,PatienteRxEligibility:rx.options.eRxEligibility,Pharmacy:rx.options.pharmacy,Prescriber:rx.optionsNonFormulary.prescriber,Procedure:rx.optionsNonFormulary.procedure,PrnReason:instruction.prnReason,Problems:rx.optionsNonFormulary.problems,RefillQuantity:instruction.refills?parseInt(instruction.refills.Name):null,RelVisitMedicationId:rx.relVisitMedicationId,RepeatSigCount:instruction.repeatSigCount,SendPriorAuth:rx.optionsNonFormulary.sendPriorAuth,SendIsSpecialty:rx.optionsNonFormulary.sendIsSpecialty,Route:instruction.route,ScreeningOverride:rx.drugScreening.overrideText,ScreeningResult:rx.drugScreening.screeningResult,UnitOfMeasure:rx.options.uom,MedicationConsentInfoHowDiscussed:rx.optionsNonFormulary.MedicationConsent?rx.optionsNonFormulary.MedicationConsent.HowDiscussed:null,MedicationConsentInfoSymptom:rx.optionsNonFormulary.MedicationConsent?rx.optionsNonFormulary.MedicationConsent.Symptom:null,FromDesktop:!1}}function newId(){return(new Date).getTime()}function newRxInstructions(rx){var instructions={isManualQuantity:!1,refills:findRefill(0,"0",rx.rxOptions),repeatSigCount:0,route:findRoute(null,rx.drug.RouteDescription,rx.rxOptions),source:"Auto",startDate:moment().startOf("day").toDate(),unit:findUnit(rx.drug.UnitId,rx.drug.UnitName,rx.rxOptions)};return instructions}function setDefaultPrescriber(rx){switch(rx.sigType){case"CppMedication":case"DefaultSig":case"RefillMessage":return}if(!rx.optionsNonFormulary.prescriber||!rx.optionsNonFormulary.prescriber.Id){var defaultPresciber=function(){var prescriber=null,authorizedPrescribers=rx.rxOptions.authorizedPrescribers;if(!authorizedPrescribers)return prescriber;1===authorizedPrescribers.length?prescriber=authorizedPrescribers[0]:rx.visit&&rx.visit.RenderingProvider&&(prescriber=_.find(authorizedPrescribers,function(provider){return provider.Id===rx.visit.RenderingProvider.Id}));prescriber||(prescriber=_.find(authorizedPrescribers,function(provider){return provider.Id===CurrentUser.get().userId}));return prescriber}();defaultPresciber&&(rx.optionsNonFormulary.prescriber=defaultPresciber)}}function setRxDrug(rx,drug){rx.drug=drug,rx.drugId=drug.Id||drug.DrugId}function setRxInstructions(rx,source){var instruction;!function(rx,instruction){if(!rx||!instruction)return;if("ChangeRx"===rx.sigType&&!instruction.isPrn){if(!instruction.alreadySetRemainingQty){var remainingQuantity=function(instruction){var remainingQuantity=0;if(!instruction)return remainingQuantity;(remainingQuantity=parseFloat(instruction.quantity)||0)<0&&(remainingQuantity=0);var quantityPerDay,days=dateDiffInDays(instruction.startDate,instruction.endDate);quantityPerDay=0<days?remainingQuantity/days:remainingQuantity;var remainingDays=dateDiffInDays(moment(),instruction.endDate);return remainingQuantity=Math.round(remainingDays*quantityPerDay)}(instruction);instruction.alreadySetRemainingQty=!0,instruction.startDate=moment().startOf("day").toDate(),instruction.quantity=remainingQuantity}var dosageAmount=getDosageAmount(instruction,rx.options&&rx.options.uom),dosesPerDay=getDosesPerDay(instruction),quantityPerDay=dosageAmount*dosesPerDay,calculatedDays=0;0<quantityPerDay&&(calculatedDays=Math.ceil(instruction.quantity/quantityPerDay)),instruction.days=findDuration(null,calculatedDays.toString(),rx.rxOptions)}if(instruction.endDateChanged){if(instruction.endDateChanged=!1,!instruction.startDate||!instruction.endDate)return;var dateDiff=dateDiffInDays(instruction.startDate,instruction.endDate),intDaysOfFills=instruction.refills&&parseInt(instruction.refills.Name),daysOfFills=intDaysOfFills?intDaysOfFills+1:1,numDays=Math.floor(dateDiff/daysOfFills);instruction.days={Name:numDays,Id:numDays}}else if(!instruction.isPrn){var startDate=instruction.startDate||null,days=instruction.days?parseInt(instruction.days.Name)||0:null,intRefills=instruction.refills&&parseInt(instruction.refills.Name),refills=intRefills?intRefills+1:1;null!==startDate&&null!==days&&(refills&&(days*=refills),instruction.endDate=moment(startDate).add(days,"days").toDate())}}(rx,source);var strings=[source.startText,source.dosage?source.dosage.Name:null,source.postDosage,source.unit?source.unit.Name:null,source.postUnit,medCommonLanguage(source.route),source.postRoute,medCommonLanguage(source.frequency),source.postFrequency,!rx.optionsNonFormulary.isAdministered&&source.isPrn?"as needed":null,!rx.optionsNonFormulary.isAdministered&&source.postPrn,!rx.optionsNonFormulary.isAdministered&&source.isPrn&&source.prnReason&&!source.prnReason.isNull?source.prnReason.Name:null,source.endText];return source.sigString=_(strings).map(function(s){return s?(""+s).trim():null}).compact().value().join(" "),"ChangeRx"===rx.sigType?(source.disallowAutoQuantity=!0,source.isManualQuantity=!0):(source.disallowAutoQuantity=!!source.isPrn,source.disallowAutoQuantity&&(source.isManualQuantity=!0),!source.isManualQuantity&&source.dosage&&source.frequency&&source.days&&(source.quantity=getDosageQuantity(source,rx.options.uom))),source.id?instruction=_(rx.instructions).filter({id:source.id}).head():(instruction={disallowChangingQuantity:"ChangeRx"===rx.sigType,id:""+newId()},rx.instructions.push(instruction)),_.assignIn(instruction,_.cloneDeep(source)),instruction}function startNewRx(sigType,rxOptions,initialDrug,patient,visit,isSpecialty){var rx={id:newId(),drugScreening:{overrideText:null,screeningResult:null},epcsSignature:null,instructions:[],options:{uom:initialDrug.UnitOfMeasureId?_(rxOptions.lists.unitsOfMeasure).filter({Id:initialDrug.UnitOfMeasureId}).head():null},optionsNonFormulary:{daw:!1,isChronicMed:!1,pharmacyInstructions:"",administeredDateTime:moment().startOf("minute").toDate(),sendIsSpecialty:isSpecialty},patient:patient,rxOptions:rxOptions,sigType:sigType,visit:visit};return rxOptions.initialFormularyData&&(rx.relVisitMedicationId=rxOptions.initialFormularyData.RelVisitMedicationId),setRxDrug(rx,initialDrug),rx}function findPrimaryMedication(pmbc,rfs,dispenseAsWritten){var pmbcAvailable=pmbc&&"completed"===pmbc.Status&&pmbc.Medications&&0<pmbc.Medications.length,rfsAvailable=rfs&&"completed"===rfs.Status&&rfs.Medications&&0<rfs.Medications.length,med=null,substitute=null;if(pmbcAvailable){if(med=_.find(pmbc.Medications,isSelectedMedication),!dispenseAsWritten){var isSubstitutePreferred=rfsAvailable?rfs.IsSubstitutePreferred:pmbc.IsSubstitutePreferred;isSubstitutePreferred&&(substitute=_.find(pmbc.Medications,isSubstituteMedication))&&(med=substitute)}}else rfsAvailable&&(med=_.find(rfs.Medications,isSelectedMedication),dispenseAsWritten||rfs.IsSubstitutePreferred&&(substitute=_.find(rfs.Medications,isSubstituteMedication))&&(med=substitute));return med;function isSelectedMedication(medication){return"Selected"===medication.MedicationAlternativeType}function isSubstituteMedication(medication){switch(medication.MedicationAlternativeType){case"AlternativeSubstitute":case"SubstituteNonFormulary":return!0;default:return!1}}}}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterScreeningModal",["$uibModal","$q",function($modal,$q){return{openModal:function(nddScreening,overrideText){return openModalWithPromise($q.when(nddScreening),overrideText)},openModalWithPromise:openModalWithPromise};function openModalWithPromise(nddScreeningPromise,overrideText){var modal=$modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/sigwriterScreeningModal.html",windowClass:"modal-full",controller:"SigwriterScreeningModalCtrl",controllerAs:"vm",resolve:{wrappedNddScreeningPromise:function(){return{promise:nddScreeningPromise}},overrideText:function(){return overrideText}}});return modal.result}}]),angular.module("aprima-sigwriter").controller("SigwriterScreeningModalCtrl",["$uibModalInstance","DeviceSettings","ErrorService","GeneralNotesModal","GeneralNoteTypeKeys","overrideText","wrappedNddScreeningPromise",function($modalInstance,DeviceSettings,ErrorService,GeneralNotesModal,GeneralNoteTypeKeys,overrideText,wrappedNddScreeningPromise){var vm=this;function onFailure(error){vm.nddScreeningErrorMessages=ErrorService.convertToErrorMessages(error)}function onSuccess(result){vm.nddScreening=result}vm.loadingDrugScreening=!0,vm.nddScreening=null,vm.nddScreeningErrorMessages=null,vm.overrideText=overrideText,vm.cancel=function(){$modalInstance.dismiss()},vm.ok=function(){$modalInstance.close({overrideText:vm.overrideText})},vm.onClickOverrideReason=function(){GeneralNotesModal.openModal("Reason for Override",vm.overrideText,!0,0,GeneralNoteTypeKeys.DrugScreeningOverrideReason).then(function(overrideText){vm.overrideText=overrideText})},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},wrappedNddScreeningPromise.promise.then(onSuccess).catch(onFailure).finally(function(){vm.loadingDrugScreening=!1})}])}(window.angular),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterSigDetailsModal",["$uibModal",function($modal){return{openModal:function(patientDetails,rxOptions,rxParameters,sigInstruction,sigOptionsNonFormulary,initialField){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/sigwriterSigDetailsModal.html",windowClass:"modal-full",controller:"SigwriterSigDetailsModalCtrl",controllerAs:"vm",resolve:{initialField:function(){return initialField},patientDetails:function(){return patientDetails},rxOptions:function(){return rxOptions},rxParameters:function(){return rxParameters},sigInstruction:function(){return sigInstruction},sigOptionsNonFormulary:function(){return sigOptionsNonFormulary}}}).result}}}]),angular.module("aprima-sigwriter").controller("SigwriterSigDetailsModalCtrl",["$uibModalInstance","DeviceSettings","toaster","initialField","patientDetails","rxOptions","rxParameters","sigInstruction","sigOptionsNonFormulary",function($modalInstance,DeviceSettings,toaster,initialField,patientDetails,rxOptions,rxParameters,sigInstruction,sigOptionsNonFormulary){var vm=this,updatedSigInstruction=null;function cancel(){$modalInstance.dismiss()}function validateAll(){var isValid=!0;return vm.tabletSigDetailsForm.$valid||(toaster.error("SIG is not valid. Please correct all errors."),isValid=!1),isValid}vm.initialField=initialField,vm.patientDetails=patientDetails,vm.rxOptions=rxOptions,vm.rxParameters=rxParameters,vm.sigInstruction=sigInstruction,vm.sigOptionsNonFormulary=sigOptionsNonFormulary,vm.cancel=cancel,vm.ok=function(){updatedSigInstruction?validateAll()&&$modalInstance.close({sigInstruction:updatedSigInstruction}):cancel()},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},vm.updateSigInstruction=function(modifiedSigInstruction){updatedSigInstruction=modifiedSigInstruction}}])}(window.angular);
//# sourceMappingURL=aprima-sigwriter.min.js.map