angular.module("aprima-legacy-common",["ui.router","restangular","ngTouch","ngAnimate","truncate","ui.bootstrap","angularLocalStorage","gettext","lodash","toaster","rt.debounce","hmTouchEvents","aprima-core","aprima-bridge","aprima-config"]),angular.module("aprima-legacy-common").value("moment",window.moment),function(){"use strict";var messageTypes={LabResultMessageGuid:"",TaskMessageGuid:"10101010-0000-0000-0000-000000000005",PortalAppointmentQuestionMessageGuid:"fd4e2c5d-29c6-4a51-bd20-551d6ed90843",PortalBillingQuestionMessageGuid:"73366ba8-0149-47e0-875b-cb12bb4cb250",PortalDemographicsQuestionMessageGuid:"dffb40d0-2318-41a9-8eef-94c58babb9b9",PortalGeneralQuestionMessageGuid:"9af1089b-e98b-4758-80f8-0435b143426d",PortalRxQuestionMessageGuid:"e94b7146-407d-4f92-a393-de8429b7bfbf",PhoneMessageGuid:"10101010-0000-0000-0000-000000000003",LabMessageGuid:"f05f9c71-a893-46c3-a7fe-37988f48a782",AttachmentApprovalGuid:"10101010-0000-0000-0000-000000000002",ServiceOrderApprovalMessageGuid:"10101010-0000-0000-0000-000000000008",RxRefillRequestMessageGuid:"136d8762-82ec-487d-9448-f52469a3cdcd",PatientRxRefillRequestMessageGuid:"b1b7d286-1fb2-43d0-a883-7946b1cd8751",PharmacyRefillRequestMessageGuid:"d7716f70-61d6-4ec0-8ba6-01afc95e99f2"};messageTypes.SupportedMessageTypesForCreate={Types:[{id:messageTypes.TaskMessageGuid},{id:messageTypes.PhoneMessageGuid,requiredFeature:"PhoneMessageCreation"}],SubTypes:[{id:messageTypes.PortalGeneralQuestionMessageGuid}]};var appointmentScheduleTypes={PatientVisit:{id:"patientvisit",name:"Patient Visit"},Event:{id:"event",name:"Event",requiredFeature:"Appointments_DifferentScheduleTypes"},BlockingEvent:{id:"blockingevent",name:"Blocking Event",requiredFeature:"Appointments_DifferentScheduleTypes"},GroupVisit:{id:"groupvisit",name:"Group Visit",requiredFeature:"Appointments_DifferentScheduleTypes"}};appointmentScheduleTypes.List=_.values(appointmentScheduleTypes);angular.module("aprima-legacy-common").constant("MessageTypes",messageTypes),angular.module("aprima-legacy-common").constant("AppointmentScheduleTypes",appointmentScheduleTypes),angular.module("aprima-legacy-common").constant("RequestTypes",{listData:"listData",default:"default"})}(),angular.module("aprima-legacy-common").run(["$rootScope","ErrorService","RequestTypes",function($rootScope,ErrorService,RequestTypes){"use strict";$rootScope.requestTypes=RequestTypes,$rootScope.addHttpError=function(httpResponse,messages,type){return httpResponse.isAborted?httpResponse:ErrorService.addHttpErrorToScope(this,httpResponse,messages,type)},$rootScope.removeHttpError=function(type){return ErrorService.removeHttpErrorFromScope(this,type)},$rootScope.setupDirectiveScope=function($scope){$scope.addHttpError=$rootScope.addHttpError,$scope.removeHttpError=$rootScope.removeHttpError},$rootScope.$on("$stateChangeSuccess",function(){$rootScope.removeHttpError()})}]),angular.module("aprima-legacy-common").run(["$rootScope","TransitionManager","AprimaAnalytics","DeviceSettings","_","toaster",function($rootScope,TransitionManager,AprimaAnalytics,DeviceSettings,_,toaster){"use strict";$rootScope.goBack=function(){TransitionManager.goBack(),AprimaAnalytics.sendEvent("user","click","back button")},$rootScope.isEmpty=function(obj){return _.isEmpty(obj)},$rootScope.isPhone=DeviceSettings.isPhoneOrOverride,$rootScope.isTablet=DeviceSettings.isTabletOrOverride,$rootScope.isBrowser=DeviceSettings.isBrowserOrOverride,$rootScope.tryToastModelStateError=function(response){var modelState=response.ModelState||response.data&&response.data.ModelState;modelState&&modelState.commandResult&&_(modelState.commandResult).forEach(function(e){toaster.pop("error","",e)})}}]),angular.module("aprima-legacy-common").run(["gettextCatalog","LocalStorageRepository",function(gettextCatalog,LocalStorageRepository){"use strict";LocalStorageRepository.getLang()?gettextCatalog.currentLanguage=LocalStorageRepository.getLang():navigator.userLanguage?gettextCatalog.currentLanguage=navigator.userLanguage:navigator.language&&(gettextCatalog.currentLanguage=navigator.language,LocalStorageRepository.setLang(navigator.language))}]),angular.module("aprima-legacy-common").factory("aprgettext",["gettextCatalog",function(gettextCatalog){"use strict";return function(text){return gettextCatalog.getString(text)}}]),angular.module("aprima-legacy-common").run(["Bridge","$rootScope","AppRoutes","_","$uibModalStack",function(Bridge,$rootScope,AppRoutes,_,$uibModalStack){"use strict";$rootScope.$on("$stateChangeSuccess",function(event,toState){var appRoute=_.find(AppRoutes,{state:toState.name});appRoute&&appRoute.nativeSettings&&!appRoute.nativeSettings.ctrlSetsUpPage&&Bridge.setupPage(appRoute.nativeSettings)}),$rootScope.$on("$stateChangeStart",function(event){$uibModalStack.dismissAll(event&&event.name)})}]),angular.module("aprima-legacy-common").run(["$rootScope","$location","$log","AprimaAnalytics","$state",function($rootScope,$location,$log,AprimaAnalytics,$state){"use strict";$rootScope.$watch(function(){return $location.path()},function(a){var output=$state.current.description?$state.current.description:a;$log.info("url has changed: "+output),AprimaAnalytics.sendPageView(output)})}]),function(angular){"use strict";window.angular.module("aprima-legacy-common").run(["moment",function(moment){moment.fn.removeOffset=function(){return this.add(this.utcOffset(),"minutes").utc()},moment.fn.formatRemoveOffset=function(){return this.removeOffset().format()}}])}(),angular.module("aprima-legacy-common").run(["Restangular","_","HttpAbortableContext","$qHelpers",function(Restangular,_,HttpAbortableContext,$qHelpers){"use strict";var abortableFields={};function wrapCallsToRestangularizedElement(restangularizedElement,promiseInterceptor){return _(restangularizedElement).functions().forEach(function(key){var elementFn=restangularizedElement[key],wrappedKey="_"+key;restangularizedElement[wrappedKey]=restangularizedElement[wrappedKey]||elementFn,restangularizedElement[key]=function(){var result=elementFn.apply(this,arguments);return $qHelpers.isPromise(result)&&(result=promiseInterceptor(result)),result}}),restangularizedElement}abortableFields.abortable="abortable",abortableFields.aborts="aborts",Restangular.setRestangularFields(abortableFields),Restangular.setOnElemRestangularized(function(element,isCollection,route,restangularObject){element&&restangularObject.configuration.isRestangularized(element)&&(element.aborts=function(promisesToAbort){return wrapCallsToRestangularizedElement(this,function(promise){return $qHelpers.abortPromises(promisesToAbort),promise}),this},element.abortable=function(promisesToAbort){var abortableContext=new HttpAbortableContext(promisesToAbort),httpConfig=restangularObject.configuration.restangularFields.httpConfig;return this[httpConfig]=_.defaults(this[httpConfig],{timeout:abortableContext.abortPromise}),wrapCallsToRestangularizedElement(this,abortableContext.wrap),this});return element})}]),angular.module("aprima-legacy-common").config(["$provide",function($provide){"use strict";$provide.decorator("$exceptionHandler",["$delegate","$injector",function($delegate,$injector){var AprimaAnalytics;return function(exception,cause){var message=exception.message+' (caused by "'+cause+'")';(AprimaAnalytics=AprimaAnalytics||$injector.get("AprimaAnalytics")).sendException(message),$delegate(exception,cause)}}])}]),angular.module("aprima-legacy-common").filter("apPatientThumbnailSrc",[function(){"use strict";return function(patientId,height,width){if(patientId){height&&!width&&(width=height);var url="patients/"+patientId+"/thumbnail";return height&&(url+="?height="+height+"&width="+width),url}}}]),function(){"use strict";angular.module("aprima-legacy-common").filter("apPersonThumbnailSrc",["ServerInfoRepository",function(ServerInfoRepository){return function(personId,height,width){if(personId&&ServerInfoRepository.isFeatureSupported(["PersonPhoto"])){height&&!width&&(width=height);var url="persons/"+personId+"/thumbnail";return height&&(url+="?height="+height+"&width="+width),url}}}])}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("DoseRange",["ObjUtil",function(ObjUtil){return DoseRange.mapFromDto=function(obj){return obj?new DoseRange(obj):null},DoseRange;function DoseRange(obj){ObjUtil.defineReadonlyProps(this,{Id:obj.Id,WeightRequired:obj.WeightRequired,BodySurfaceAreaRequired:obj.BodySurfaceAreaRequired,LowDose:obj.LowDose,LowDoseUnits:obj.LowDoseUnits,HighDose:obj.HighDose,HighDoseUnits:obj.HighDoseUnits,MaximumDosePerDay:obj.MaximumDosePerDay,MaximumDosePerDayUnits:obj.MaximumDosePerDayUnits,MaximumSingleDose:obj.MaximumSingleDose,MaximumSingleDoseUnits:obj.MaximumSingleDoseUnits,MaximumLifetimeDose:obj.MaximumLifetimeDose,MaximumLifetimeDoseUnits:obj.MaximumLifetimeDoseUnits,NteAmountPerSingleDose:obj.NteAmountPerSingleDose,NteAmountPerSingleDoseUnits:obj.NteAmountPerSingleDoseUnits,LowFrequency:obj.LowFrequency,HighFrequency:obj.HighFrequency,LowDuration:obj.LowDuration,HighDuration:obj.HighDuration,AdjustedLowDose:obj.AdjustedLowDose,AdjustedHighDose:obj.AdjustedHighDose,AdjustedMaximumSingleDose:obj.AdjustedMaximumSingleDose,AdjustedMaximumDosePerDay:obj.AdjustedMaximumDosePerDay,AdjustedMaximumLifetimeDose:obj.AdjustedMaximumLifetimeDose,AdjustedNteAmountPerSingleDose:obj.AdjustedNteAmountPerSingleDose,RangeLowDose:obj.RangeLowDose,RangeLowDoseUnits:obj.RangeLowDoseUnits,RangeHighDose:obj.RangeHighDose,RangeHighDoseUnits:obj.RangeHighDoseUnits,RangeLowDoseForm:obj.RangeLowDoseForm,RangeLowDoseFormUnits:obj.RangeLowDoseFormUnits,RangeHighDoseForm:obj.RangeHighDoseForm,RangeHighDoseFormUnits:obj.RangeHighDoseFormUnits,NtePediDailyDoseStrength:obj.NtePediDailyDoseStrength,NtePediDailyDoseStrengthUnits:obj.NtePediDailyDoseStrengthUnits,NtePediDailyDoseForm:obj.NtePediDailyDoseForm,NtePediDailyDoseFormUnits:obj.NtePediDailyDoseFormUnits,IngredientStrength:obj.IngredientStrength,IngredientStrengthUomAbbr:obj.IngredientStrengthUomAbbr,IngredientStrengthUomDesc:obj.IngredientStrengthUomDesc,IngredientVolume:obj.IngredientVolume,IngredientVolumeUomAbbr:obj.IngredientVolumeUomAbbr,IngredientVolumeUomDesc:obj.IngredientVolumeUomDesc,WeightKg:obj.WeightKg,BodySurfaceArea:obj.BodySurfaceArea,ErrorMsg:obj.ErrorMsg,HasError:obj.HasError})}}])}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("DoseRangeInfo",["DoseRange","ObjUtil",function(DoseRange,ObjUtil){return DoseRangeInfo.mapFromDto=function(obj){return obj?new DoseRangeInfo(obj):null},DoseRangeInfo;function DoseRangeInfo(obj){DoseRange.call(this,obj),ObjUtil.defineReadonlyProps(this,{MaxMinInformation:obj.MaxMinInformation})}}])}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("ImoPatient",["_","DateUtilities","ObjUtil",function(_,DateUtilities,ObjUtil){var femaleRegex=/^f(emale)?$/i,maleRegex=/^m(ale)?$/i;return ImoPatient.mapFromApi=function(patient){if(!patient)return null;var name=patient.FirstName+" "+patient.LastName,birthDate=patient.BirthDate||patient.DateOfBirth,deathDate=patient.DeathDate,ageInfo=DateUtilities.getPersonAge(birthDate,deathDate,"years"),gender=patient.Gender||patient.GenderName||patient.GenderAnsi;return new ImoPatient(name,ageInfo.age,gender)},ImoPatient;function ImoPatient(name,ageInYears,gender){var standardizedAge=null;ageInYears=parseFloat(ageInYears),!_.isNaN(ageInYears)&&0<=ageInYears&&(standardizedAge=_.round(ageInYears));var standardizedGender=null;femaleRegex.test(gender)?standardizedGender="F":maleRegex.test(gender)&&(standardizedGender="M"),ObjUtil.defineReadonlyProps(this,{name:name,age:ageInYears,standardizedAge:standardizedAge,hasAge:!!standardizedAge||0===standardizedAge,gender:gender,standardizedGender:standardizedGender,hasGender:!!standardizedGender})}}])}(),angular.module("aprima-legacy-common").factory("AprimaAnalytics",["Bridge","$timeout","_",function(Bridge,$timeout,_){"use strict";var sendTiming=function(category,label,timingValue,page){$timeout(function(){Bridge.trackTiming(category,label,timingValue,page)},0)};function stopTiming(timing){timing.endTime=(new Date).getTime(),timing.value=moment(timing.endTime).diff(moment(timing.startTime),"millisecond"),sendTiming(timing.category,timing.label,timing.value,timing.page)}return{sendEvent:function(category,action,label,value){$timeout(function(){Bridge.trackEvent(category,action,label,value)},0)},sendTiming:sendTiming,sendPageView:function(location){$timeout(function(){Bridge.trackPageChange(location)},0)},sendException:function(message){$timeout(function(){Bridge.trackException(message)},0)},startTiming:function(page,category,label){var timing={startTime:(new Date).getTime(),page:page,label:label,category:category};return timing.stop=_.partial(stopTiming,timing),timing},stopTiming:stopTiming}}]),angular.module("aprima-legacy-common").config(["$provide",function($provide){"use strict";$provide.decorator("$exceptionHandler",["$delegate","$injector",function($delegate,$injector){var AprimaAnalytics;return function(exception,cause){var message=exception.message+' (caused by "'+cause+'")';(AprimaAnalytics=AprimaAnalytics||$injector.get("AprimaAnalytics")).sendException(message),$delegate(exception,cause)}}])}]),angular.module("aprima-legacy-common").factory("AprimaRestangular",["$log","$state","_","AppRoutes","Bridge","BrowserService","configuration","debugLogService","LocalStorageRepository","Restangular","TransitionManager",function($log,$state,_,AppRoutes,Bridge,BrowserService,configuration,debugLogService,LocalStorageRepository,Restangular,TransitionManager){"use strict";var alwaysIgnoreCache=!1,debugModeValue=LocalStorageRepository.getSupportedFeatures();return{get:function(endpointBase,options){return _.isString(endpointBase)||options||(options=endpointBase,endpointBase=null),options=_.defaults(options||{},{ignoreCache:BrowserService.isLegacyIE(),debugMode:!1}),Restangular.withConfig(function(RestangularConfigurer){var urlComponents=[LocalStorageRepository.getClientURL().replace(/\/$/,""),"api",endpointBase||"",configuration.SERVER_API_VERSION],baseUrl=_.filter(urlComponents,function(c){return!_.isNull(c)&&!_.isEmpty(c)}).join("/");RestangularConfigurer.setBaseUrl(baseUrl);var headers={"Auth-Token":LocalStorageRepository.getJsonWebToken(),ApiKey:configuration.API_KEY};options.ignoreCache&&(Bridge.fireEvent("clear-cache",{}),headers["Cache-Control"]="no-cache, no-store, must-revalidate",headers.Pragma="no-cache",headers.Expires=new Date),RestangularConfigurer.setDefaultHeaders(headers);var debugModeFeature=function(features){angular.isArray(features)||(features=[features]);var supportedFeatures=debugModeValue;return _.intersection(features,supportedFeatures).length===features.length}("DebuggerFeature");debugModeFeature?(RestangularConfigurer.addFullRequestInterceptor(function(element,operation,what,url,_5,parameters){return alwaysIgnoreCache&&operation.toLowerCase(),debugLogService.getDebugMode()?{params:_.assignIn(parameters,{t:(new Date).toJSON(),debug:!0,levels:"info,debug,fatal,warn,error"})}:element}),RestangularConfigurer.addResponseInterceptor(function(data,operation,what,url,response){return debugLogService.getDebugMode()&&($log.log("URL:",url),$log.log("WHAT:",what),$log.log("THE HEADERS ARE:",JSON.stringify(response.headers(),null,2))),data})):RestangularConfigurer.addFullRequestInterceptor(function(element,operation,what,url,_5,parameters){return alwaysIgnoreCache&&"get"===operation.toLowerCase()?{params:_.assignIn(parameters,{t:(new Date).toJSON()})}:element}),RestangularConfigurer.setErrorInterceptor(function(response){if(401===response.status){var deviceId=LocalStorageRepository.getDeviceId(),jwt=LocalStorageRepository.getJsonWebToken(),msg="User logged out by 401. Redirected to login. DeviceId="+deviceId+" JWT:"+(jwt=void 0===jwt?"undefined":jwt?jwt.length:'"falsy token"');$log.info(msg),Bridge.trackException(msg),$state.current.alternativeLoginRoute?TransitionManager.transition({appRoute:AppRoutes.statementslogin.state}):TransitionManager.transition({appRoute:AppRoutes.login.state})}else debugModeFeature&&200!==response.status&&debugLogService.getDebugMode()&&$log.log("THE EXCEPTION INFORMATION:",JSON.stringify(response.headers(),null,2));if(response.data&&response.data.ModelState){var errorCode=response.data.ModelState["commandResult-ErrorCode"];errorCode&&(response.errorCode=parseInt(errorCode))}return!0})})},getUrl:function(endpointBase,parent){var urlComponents=[LocalStorageRepository.getClientURL(),"api",endpointBase||"",configuration.SERVER_API_VERSION,parent];return[_.filter(urlComponents,function(c){return!_.isNull(c)&&!_.isEmpty(c)}).join("/"),{"Auth-Token":LocalStorageRepository.getJsonWebToken(),ApiKey:configuration.API_KEY}]},disableCaching:function(){alwaysIgnoreCache=!0}}}]),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("AuthorizationService",["CurrentUser","ServerInfoRepository",function(CurrentUser,ServerInfoRepository){return{isUserProvider:function(){if(ServerInfoRepository.isFeatureSupported("ProviderAuthorization")){var user=CurrentUser.get();return user.permissions&&("True"===user.permissions.IsProvider||!0===user.permissions.IsProvider)}return!0},icd10User:function(){var user=CurrentUser.get();return user.permissions&&("True"===user.permissions.ICD10User||!0===user.permissions.ICD10User)}}}])}(),angular.module("aprima-legacy-common").factory("CurrentUser",["LocalStorageRepository","TransitionManager","Bridge","LogOffService","$state","LogInService","$rootScope",function(LocalStorageRepository,TransitionManager,Bridge,LogOffService,$state,LogInService,$rootScope){"use strict";var previousTransition;return $rootScope.$on("TransitionActivated",function(evt,transition){previousTransition=transition}),Bridge.on("force-logoff-user",null,function(){LogInService.setRedirect(previousTransition),LogOffService.logoff().then(function(){TransitionManager.transition({appRoute:"login",opts:{replaceCurrentState:!0}})})}),{isAuthenticated:function(){return!!LocalStorageRepository.getJsonWebToken()},get:function(){return{name:LocalStorageRepository.getUserName(),fullName:LocalStorageRepository.getUserFullName(),userId:LocalStorageRepository.getUserID(),token:LocalStorageRepository.getJsonWebToken(),clientId:LocalStorageRepository.getClientID(),clientURL:LocalStorageRepository.getClientURL(),deviceId:LocalStorageRepository.getDeviceId(),permissions:LocalStorageRepository.getUserPermissions()}}}}]),angular.module("aprima-legacy-common").factory("DashboardStructure",["ServerInfoRepository","VersionService","CurrentUser","DeviceSettings","widgetViews","configuration",function(ServerInfoRepository,VersionService,CurrentUser,DeviceSettings,widgetViews,configuration){"use strict";function mapV1ConfigurationsToV2(configs){return _.map(configs,function(config){return{Id:config.Type,ExternalId:"",Name:config.Type,DisplayOrder:"All"===config.Type?0:1,PhoneTiles:mapTiles(config,1),TabletTiles:mapTiles(config,2),DesktopTiles:mapTiles(config,3)}});function mapTiles(config,numColumns){return _(config.WidgetDescriptors).filter(function(tile){return"header"!==tile.Name}).map(_.partialRight(mapTile,numColumns)).value()}function mapTile(tile,index,collection,numColumns){return{Id:tile.Id,TileDescriptorId:_.find(widgetViews,{name:tile.Name}).id,Name:tile.Name,Heading:tile.Heading,ColumnSpan:Math.min(DeviceSettings.isPhoneOrOverride||"dblCol"!==tile.Column?1:2,numColumns||2),IsCollapsed:"remarks"!==tile.Name,Filter:tile.Filter}}}return{get:function(numColumns){var routeSuffix="phone";switch(numColumns){case 1:routeSuffix="phone";break;case 2:routeSuffix="tablet";break;case 3:routeSuffix="desktop";break;case void 0:case null:routeSuffix="";break;default:throw new Error("Unsupported number of columns for dashboard configuration: "+numColumns)}return VersionService.checkVersionValid(ServerInfoRepository.getPrmAssemblyVersion(),configuration.MIN_PRM_DASHBOARD_VERSION)?{repositoryRoute:"settings/patient-dashboards/"+routeSuffix,mapFn:_.identity}:{repositoryRoute:"settings/patientdashboards/"+CurrentUser.get().userId,mapFn:mapV1ConfigurationsToV2}}}}]),angular.module("aprima-legacy-common").factory("DateUtilities",["_","moment","LanguageFactory",function(_,moment,LanguageFactory){"use strict";var words={years:{en_us:"Years",es_mx:"Años"},months:{en_us:"Months",es_mx:"Meses"},days:{en_us:"Days",es_mx:"Días"},weeks:{en_us:"Weeks",es_mx:"Semanas"},deceased:{en_us:"deceased at",es_mx:"fallecido en"}},lang=LanguageFactory.getLang();return{getPersonAge:_getPersonAge,displayAge:function(person,options){var ageString,langCode=lang.code.toLowerCase();if(!person||""===person.birthdate)return"";ageString=person.age+" "+person.units,person.deceased&&(ageString=words.deceased[langCode]+" "+ageString);if(options&&"age"===options.display)return ageString;if(options&&"birthdate"===options.display)return person.birthdate;return person.birthdate+" ("+ageString+")"},getDurationString:function(refDate){var diff=Date.parse(refDate)-new Date,msg=moment.duration(diff).humanize();return diff<0?msg+" ago":"in "+msg},getPersonAgeAbbr:function(birthDate,deathDate,unit){moment(birthDate,"MM/DD/YYYY").isValid()||(birthDate=moment(birthDate).format("L"));var ageInfo=_getPersonAge(birthDate,deathDate,unit);return ageInfo.age+""+ageInfo.units.charAt(0).toLowerCase()}};function _getPersonAge(birthDate,deathDate,unit){var end,years,months,days,weeks,_units="Years",_age=0,_deceased=!1,langCode=lang.code.toLowerCase(),birthDateMoment=birthDate;if(moment.locale(langCode),!moment(birthDate+"","MM/DD/YYYY").isValid())return{birthdate:"",age:0,units:words.years[langCode]};birthDateMoment=moment(birthDate,"MM/DD/YYYY");var tempDeathDate=moment(deathDate+"","MM/DD/YYYY");return tempDeathDate.isValid()?(end=tempDeathDate,_deceased=!0):end=moment(),years=end.diff(birthDateMoment,"years"),months=end.diff(birthDateMoment,"months"),days=end.diff(birthDateMoment,"days"),weeks=end.diff(birthDateMoment,"weeks"),_units=!unit&&days<14||"days"===unit?(_age=days,words.days[langCode]||"Days"):!unit&&months<2||"weeks"===unit?(_age=weeks,words.weeks[langCode]||"Weeks"):!unit&&years<2||"months"===unit?(_age=months,words.months[langCode]||"Months"):(_age=years,words.years[langCode]||"Years"),{birthdate:moment(birthDate,"MM/DD/YYYY").format("L"),deathdate:moment(deathDate,"MM/DD/YYYY").format("L"),age:_age,units:_units,deceased:_deceased}}}]),angular.module("aprima-legacy-common").factory("debugLogService",[function(){"use strict";var debugMode=!1;return{disableDebugMode:function(){debugMode=!1},enableDebugMode:function(){debugMode=!0},getDebugMode:function(){return debugMode}}}]),function(angular,Math){"use strict";var AdjustedForWeight=" (adjusted for patient's weight)";angular.module("aprima-legacy-common").factory("DoseRangeUtil",["_","NumUtil","StringBuilder","SystemGuid",function(_,NumUtil,StringBuilder,SystemGuid){return{createWeightBasedMaxMinInformation:function(weightBasedDoseRange){if(!weightBasedDoseRange)return"";var sb=StringBuilder.init();addDoseRange(sb,weightBasedDoseRange.LowDoseAmount,weightBasedDoseRange.LowDoseAmountUnits,weightBasedDoseRange.HighDoseAmount,weightBasedDoseRange.HighDoseAmountUnits),0<sb.Length&&sb.AppendLine();addDoseRange(sb,weightBasedDoseRange.LowDoseForm,weightBasedDoseRange.LowDoseFormUnits,weightBasedDoseRange.HighDoseForm,weightBasedDoseRange.HighDoseFormUnits),0<sb.Length&&sb.AppendLine();return addNTEInfo(sb,weightBasedDoseRange.NTEAmount,weightBasedDoseRange.NTEAmountUnits),addNTEInfo(sb,weightBasedDoseRange.NTEForm,weightBasedDoseRange.NTEFormUnits),function(sb,nte,nteUnits){sb&&0<nte&&(sb.Append("Single Dose NTE: "),sb.Append(numFormat(nte,"0.00")),nteUnits&&(sb.Append(" "),sb.Append(nteUnits)),sb.AppendLine())}(sb,weightBasedDoseRange.NTESingleDoseAmount,weightBasedDoseRange.NTESingleDoseAmountUnits),sb.ToString()},formatAgeInDays:formatAgeInDays,getWeightBasedSummary:getWeightBasedSummary,mapVariableDosingFromDto:function(variableDosingDto){if(!variableDosingDto)return null;var variableDosing={isDisabled:!1,minAge:variableDosingDto.MinAgeInDays,maxAge:variableDosingDto.MaxAgeInDays,defaultDosingQuantity:variableDosingDto.DefaultDosingQuantity,defaultMaximumDoseQuantity:variableDosingDto.DefaultMaximumDoseQuantity,variableDosingTypeId:variableDosingDto.VariableDosingTypeId,overrides:_.map(variableDosingDto.Overrides,function(override){return{minAge:override.MinAgeInDays,maxAge:override.MaxAgeInDays,overrideDosingQuantity:override.OverrideDosingQuantity,overrideMaximumDoseQuantity:override.OverrideMaximumDoseQuantity}}),calculationErrors:variableDosingDto.CalculationErrors},processedDosingType=processDosingType(variableDosing.variableDosingTypeId);return variableDosing.unitDescription=processedDosingType.dosingUnits,variableDosing.maxUnitDescription=processedDosingType.maxDoseUnits,variableDosing.summary=getWeightBasedSummary(variableDosing),variableDosing},mapVariableDosingToDto:function(variableDosing){return!variableDosing||variableDosing.isDisabled?null:{DefaultDosingQuantity:variableDosing.defaultDosingQuantity,DefaultMaximumDoseQuantity:variableDosing.defaultMaximumDoseQuantity,MaxAgeInDays:variableDosing.maxAge,MinAgeInDays:variableDosing.minAge,Overrides:_.map(variableDosing.overrides,function(override){return{MaxAgeInDays:override.maxAge,MinAgeInDays:override.minAge,OverrideDosingQuantity:override.overrideDosingQuantity,OverrideMaximumDoseQuantity:override.overrideMaximumDoseQuantity}}),VariableDosingTypeId:variableDosing.variableDosingTypeId}},processDoseRanges:function(variableDoseRanges){var variableDosingTypeId,weightBasedDoseRanges=variableDoseRanges.WeightBasedDoseRanges||[],minAge=365,maxAge=0;weightBasedDoseRanges.forEach(function(doseRange){var matches=doseRange.MaxMinInformation&&doseRange.MaxMinInformation.match(/\r\n/g),maxMinInformationRows=(matches||[]).length+1;doseRange.maxMinInformationRows=maxMinInformationRows,doseRange.MinAgeInDays<minAge&&(minAge=doseRange.MinAgeInDays),doseRange.MaxAgeInDays>maxAge&&(maxAge=doseRange.MaxAgeInDays),variableDosingTypeId=doseRange.VariableDosingTypeId});var processedDosingType=processDosingType(variableDosingTypeId);return{weightBasedDoseRanges:weightBasedDoseRanges,dosingUnits:processedDosingType.dosingUnits,maxAge:maxAge,maxDoseUnits:processedDosingType.maxDoseUnits,minAge:minAge,variableDosingTypeId:variableDosingTypeId}},GetMaxMinWarningMsg:function(drc,amount,frequencyPerDay,durationOfTherapyInDays){if(!drc)return"";if(drc.ErrorMsg&&-1===drc.ErrorMsg.indexOf("there is no dosing information supplied for this patient"))return drc.ErrorMsg;durationOfTherapyInDays=durationOfTherapyInDays||0;var dailyDose=function(drc,amount,frequencyPerDay){if(!drc)return 0;var dosingValue=0,dosePerDay=multiply(amount=amount||0,frequencyPerDay=frequencyPerDay||0),strength=0;0<=drc.IngredientStrength&&(strength=drc.IngredientStrength);dosingValue=isMilliliterUnitVolume(drc)?multiply(strength,divide(amount,drc.IngredientVolume)):multiply(strength,dosePerDay);return dosingValue}(drc,amount=amount||0,frequencyPerDay=frequencyPerDay||0);{if(0<drc.AdjustedLowDose&&dailyDose<drc.AdjustedLowDose)return"The dosing is less than the recommended daily dosing; "+fdbDosingInformation(drc);if(0<drc.AdjustedHighDose&&0<drc.AdjustedMaximumSingleDose&&dailyDose>drc.AdjustedHighDose&&dailyDose<drc.AdjustedMaximumSingleDose)return"The dosing is greater than the recommended daily dosing; "+fdbDosingInformation(drc);if(0<drc.AdjustedHighDose&&dailyDose>drc.AdjustedHighDose)return"The dosing is greater than the recommended daily dosing; "+fdbDosingInformation(drc);if(0<drc.AdjustedMaximumDosePerDay&&dailyDose>drc.AdjustedMaximumDosePerDay||0<drc.AdjustedNteAmountPerSingleDose&&dailyDose>drc.AdjustedNteAmountPerSingleDose)return"The dosing is greater than the recommended maximum single dose; "+fdbDosingInformation(drc);if(0<drc.LowFrequency&&drc.LowFrequency>frequencyPerDay)return"Prescribed frequency of administration per day is less than the recommended minimum frequency of administration range for the drug.  Please evaluate frequency.";if(0<drc.HighFrequency&&frequencyPerDay>drc.HighFrequency)return"Prescribed frequency of administration per day is greater than the recommended maximum frequency of administration for the drug.  Please evaluate frequency.";if(0<drc.LowDuration&&durationOfTherapyInDays<drc.LowDuration)return"Prescribed duration is less than the recommended low duration for the drug.";if(0<drc.HighDuration&&durationOfTherapyInDays>drc.HighDuration)return"Prescribed duration is greater than the highest recommended duration for the drug."}return""},CreateMaxMinInformation:function(drc){if(!drc)return"";var sb=StringBuilder.init();drc.ErrorMsg&&0<drc.ErrorMsg.length&&(sb.AppendLine(drc.ErrorMsg),sb.AppendLine(),sb.AppendLine());var doseLow=0,doseHigh=0,doseFormLow=0,doseFormHigh=0,doseUnit="",doseResult=function(drc){var result={doseLow:0,doseHigh:0};if(!drc)return result;0<=drc.RangeLowDose&&0<=drc.RangeHighDose&&(result.doseLow=drc.LowDose,result.doseHigh=drc.HighDose);drc.WeightRequired&&0<=drc.WeightKg&&(result.doseLow=multiply(result.doseLow,Math.max(1,drc.WeightKg)),result.doseHigh=multiply(result.doseHigh,Math.max(1,drc.WeightKg)));if(drc.BodySurfaceAreaRequired&&0<=drc.BodySurfaceArea){var bsa=drc.BodySurfaceArea;result.doseLow=divide(multiply(result.doseLow,bsa),1.73),result.doseHigh=divide(multiply(result.doseHigh,bsa),1.73)}return result}(drc);doseLow=doseResult.doseLow,doseHigh=doseResult.doseHigh;var formDoseResult=function(drc){var result={doseFormLow:0,doseFormHigh:0};if(!drc)return result;0<=drc.RangeLowDoseForm&&0<=drc.RangeHighDoseForm&&(result.doseFormLow=drc.RangeLowDoseForm,result.doseFormHigh=drc.RangeHighDoseForm);drc.WeightRequired&&0<=drc.WeightKg&&(result.doseFormLow=multiply(result.doseFormLow,Math.max(1,drc.WeightKg)),result.doseFormHigh=multiply(result.doseFormHigh,Math.max(1,drc.WeightKg)));if(drc.BodySurfaceAreaRequired&&0<=drc.BodySurfaceArea){var bsa=drc.BodySurfaceArea;result.doseFormLow=divide(multiply(result.doseFormLow,bsa),1.73),result.doseFormHigh=divide(multiply(result.doseFormHigh,bsa),1.73)}return result}(drc);doseFormLow=formDoseResult.doseFormLow,doseFormHigh=formDoseResult.doseFormHigh,0<doseLow&&0<doseHigh&&(sb.Append(fdbDosingInformation(drc)),sb.AppendLine(),sb.AppendLine(),doseUnit=drc.RangeLowDoseUnits?doseUnitOnly(doseUnit=drc.RangeLowDoseUnits):"",sb.Append("dose "),sb.Append(numFormat(doseLow,"[0].[00]")),sb.Append(" "),sb.Append(doseUnit),doseUnit=drc.RangeHighDoseUnits?doseUnitOnly(doseUnit=drc.RangeHighDoseUnits):"",sb.Append(" to "),sb.Append(numFormat(doseHigh,"[0].[00]")),sb.Append(" "),sb.Append(doseUnit),drc.WeightRequired&&sb.Append(AdjustedForWeight),drc.BodySurfaceAreaRequired&&sb.Append(" (adjusted for body surface area)"));0<doseFormLow&&0<doseFormHigh&&(doseUnit=drc.RangeLowDoseFormUnits?doseUnitOnly(doseUnit=drc.RangeLowDoseFormUnits):"",sb.AppendLine(),sb.Append("dose form "),sb.Append(numFormat(doseFormLow,"[0].[00]")),sb.Append(" "),sb.Append(doseUnit),doseUnit=drc.RangeHighDoseFormUnits?doseUnitOnly(doseUnit=drc.RangeHighDoseFormUnits):"",sb.Append(" to "),sb.Append(numFormat(doseFormHigh,"[0].[00]")),sb.Append(" "),sb.Append(doseUnit),drc.WeightRequired&&sb.Append(AdjustedForWeight),drc.BodySurfaceAreaRequired&&sb.Append(" (adjusted for body surface area)"));return sb.ToString()},CalculateDosingInformation:function(drc,frequencyPerDay,mg){if(!drc)return"";if(frequencyPerDay=frequencyPerDay||0,0<(mg=mg||0))return isMilliliterUnitVolume(drc)?function(drc,frequencyPerDay,mg){if(!drc)return"";frequencyPerDay=frequencyPerDay||0,mg=mg||0;var sb=StringBuilder.init();drc.WeightRequired&&0<=drc.WeightKg&&(sb.Append(numFormat(multiply(mg,drc.WeightKg),"0.0")),sb.Append(" mg "),sb.AppendLine(AdjustedForWeight),sb.AppendLine());if(0<mg&&0<drc.IngredientVolume&&0<drc.IngredientStrength){var ml=divide(drc.IngredientVolume,drc.IngredientStrength),totalML=0;totalML=drc.WeightRequired&&0<=drc.WeightKg?multiply(ml,mg,drc.WeightKg):multiply(ml,mg),sb.Append(function(drc,frequencyPerDay,dose){var sb=StringBuilder.init();if(frequencyPerDay=frequencyPerDay||0,dose=dose||0,isMilliliterUnitVolume(drc)){var timesPerDay=frequencyPerDay;0===frequencyPerDay&&(sb.AppendLine("Cannot calculate a single dose without a frequency."),timesPerDay=1);var convertDose=_.round(divide(dose,timesPerDay),1);0!==convertDose&&(sb.AppendLine(),sb.Append("Milliliter(s) "),0<frequencyPerDay?(sb.Append("single dose "),sb.Append(numFormat(convertDose,"[0].[0]"))):(sb.Append("per day "),sb.Append(numFormat(multiply(convertDose,timesPerDay),"[0].[0]"))))}return sb.ToString()}(drc,frequencyPerDay,totalML)),sb.AppendLine(),sb.Append("Daily total ml: "),sb.Append(numFormat(totalML,"0.0")),drc.WeightRequired?sb.Append(" = (("):sb.Append(" = ("),sb.Append(numFormat(ml,"0.0[000]")),sb.Append(" (ml per mg) * "),sb.Append(numFormat(mg,"0.0")),drc.WeightRequired?(sb.Append(") * "),sb.Append(numFormat(drc.WeightKg||0,"0.000")),sb.Append("(kg))")):sb.Append(")")}return sb.ToString()}(drc,frequencyPerDay,mg):function(drc,mg){if(!drc)return"";mg=mg||0;var sb=StringBuilder.init(),bsa=0,adjustedMG=mg,strength=0;0<=drc.IngredientStrength&&(strength=drc.IngredientStrength);drc.WeightRequired?(adjustedMG=multiply(mg,drc.WeightKg||0),sb.Append(numFormat(adjustedMG,"0.0")),sb.Append(" mg "),sb.AppendLine(AdjustedForWeight),sb.AppendLine()):drc.BodySurfaceAreaRequired&&0<=drc.BodySurfaceArea&&(bsa=drc.BodySurfaceArea,adjustedMG=divide(multiply(bsa,mg),1.73),sb.Append(numFormat(adjustedMG,"0.0")),sb.Append(" mg "),sb.AppendLine(" (adjusted for body surface area)"),sb.AppendLine());sb.Append(function(mg,strength){mg=mg||0,strength=strength||0;var sb=StringBuilder.init(),convertDose=Math.floor(mg);0!==convertDose&&(sb.Append("Milligram(s) "),sb.Append("single dose "),sb.Append(numFormat(convertDose,"[0]")));var dose,num1,num2,result,remainder,formatted=(dose=divide(convertDose=_.round(mg,3),strength),result="",num1=dose=dose||0,num2=Math.trunc(dose),.499<(remainder=NumUtil.subtract(num1,num2))&&remainder<.999&&(result=" 1/2"),result=numFormat(Math.trunc(dose),"[0]")+result);return formatted&&(sb.AppendLine(),sb.Append("Each "),sb.Append("single dose "),sb.Append(formatted)),sb.ToString()}(adjustedMG,strength)),drc.WeightRequired?(sb.AppendLine(),sb.AppendLine(),sb.Append("Single dose mg: "),sb.Append(numFormat(adjustedMG,"0.0")),sb.Append(" = ("),sb.Append(numFormat(mg,"0.0")),sb.Append("(mg) * "),sb.Append(numFormat(drc.WeightKg||0,"0.000")),sb.Append("(kg))")):drc.BodySurfaceAreaRequired&&(sb.AppendLine(),sb.AppendLine(),sb.Append("Single pediatric dose mg: "),sb.Append(numFormat(adjustedMG,"0.0")),sb.Append(" = (("),sb.Append(numFormat(bsa,"0.0[000]")),sb.Append(" (bsa m2) * "),sb.Append(numFormat(mg,"0.0")),sb.Append(" (adult dose mg)"),sb.AppendLine(") / 1.73)"),sb.AppendLine(),sb.Append("Body Surface Area is calculated using the 'DuBois and DuBois 2' formula."));return sb.ToString()}(drc,mg);return""},allowsBsaAdjustment:function(drc,patientAgeInDays){return!!drc&&(patientAgeInDays=patientAgeInDays||0,drc.BodySurfaceAreaRequired||patientAgeInDays<=6569&&drc.WeightRequired&&canCalculateByMg(drc))},canCalculateByMg:canCalculateByMg};function canCalculateByMg(drc){var strengthUomAbbr=drc&&drc.IngredientStrengthUomAbbr;if(!strengthUomAbbr)return!1;var isMg="mg"===strengthUomAbbr.toLowerCase();return isMg}function formatAgeInDays(ageInDays){return ageInDays<60?numFormat(ageInDays/7,"0")+" weeks":ageInDays<730?numFormat(ageInDays/30.5,"0")+" months":numFormat(ageInDays/365,"0")+" years"}function getWeightBasedSummary(weightBasedDosing){var sb=StringBuilder.init();return 0<weightBasedDosing.minAge&&(sb.Append("Age "),sb.Append(formatAgeInDays(0)),sb.Append(" - "),sb.AppendLine(formatAgeInDays(weightBasedDosing.minAge-1)),sb.AppendLine("  Manual Input Required")),weightBasedDosing.overrides.forEach(function(doseRange){sb.AppendLine(),sb.Append("Age "),sb.Append(formatAgeInDays(doseRange.minAge)),sb.Append(" - "),sb.AppendLine(formatAgeInDays(doseRange.maxAge)),sb.Append("  "),sb.Append(doseRange.overrideDosingQuantity?doseRange.overrideDosingQuantity:weightBasedDosing.defaultDosingQuantity),sb.Append(" "),sb.Append(weightBasedDosing.unitDescription);var maxDose=doseRange.overrideMaximumDoseQuantity?doseRange.overrideMaximumDoseQuantity:weightBasedDosing.defaultMaximumDoseQuantity;maxDose&&(sb.AppendLine(),sb.Append("  Maximum Dose "),sb.Append(maxDose),sb.Append(" "),sb.Append(weightBasedDosing.maxUnitDescription)),sb.AppendLine()}),sb.AppendLine(),sb.Append("Age "),sb.Append(formatAgeInDays(weightBasedDosing.maxAge+1)),sb.AppendLine(" and older"),sb.Append("  Manual Input Required"),sb.ToString()}function processDosingType(variableDosingTypeId){var dosingUnits,maxDoseUnits;switch(variableDosingTypeId){case SystemGuid.DosingCalculatorUnitGPerKgPerDay:dosingUnits="g/kg/day",maxDoseUnits="g";break;case SystemGuid.DosingCalculatorUnitMcgPerKgPerDay:dosingUnits="mcg/kg/day",maxDoseUnits="mcg";break;case SystemGuid.DosingCalculatorUnitMgPerKgPerDay:dosingUnits="mg/kg/day",maxDoseUnits="mg";break;case SystemGuid.DosingCalculatorUnitMlPerKgPerDay:dosingUnits="mL/kg/day",maxDoseUnits="mL"}return{dosingUnits:dosingUnits,maxDoseUnits:maxDoseUnits}}function isMilliliterUnitVolume(drc){return!!drc&&!!(drc.IngredientVolumeUomAbbr&&"ml"===drc.IngredientVolumeUomAbbr.toLowerCase()&&0<drc.IngredientVolume)}function addDoseRange(sb,low,lowUnits,high,highUnits){sb&&0<low&&0<high&&(sb.Append(numFormat(low,"0.00")),lowUnits&&(sb.Append(" "),sb.Append(lowUnits)),sb.Append(" - "),sb.Append(numFormat(high,"0.00")),highUnits&&(sb.Append(" "),sb.Append(highUnits)))}function addNTEInfo(sb,nte,nteUnits){sb&&0<nte&&(sb.Append("NTE: "),sb.Append(numFormat(nte,"0.00")),nteUnits&&(sb.Append(" "),sb.Append(nteUnits)),sb.AppendLine())}function doseFormRange(drc,sb){drc&&sb&&addDoseRange(sb,drc.RangeLowDoseForm,drc.RangeLowDoseFormUnits,drc.RangeHighDoseForm,drc.RangeHighDoseFormUnits)}function doseRange(drc,sb){drc&&sb&&addDoseRange(sb,drc.RangeLowDose,drc.RangeLowDoseUnits,drc.RangeHighDose,drc.RangeHighDoseUnits)}function fdbDosingInformation(drc){var sb=StringBuilder.init();return isMilliliterUnitVolume(drc)?(doseFormRange(drc,sb),0<sb.Length&&sb.Append("; "),doseRange(drc,sb)):(doseRange(drc,sb),0<sb.Length&&sb.Append("; "),doseFormRange(drc,sb)),sb.ToString()}function doseUnitOnly(doseUnit){if(!doseUnit)return doseUnit;var len=doseUnit.indexOf("/");return 0<len&&(doseUnit=doseUnit.substr(0,len)),doseUnit}function multiply(){var result=NumUtil.multiply.apply(null,arguments);return result}function divide(num1,num2){var result=NumUtil.divide(num1,num2);return result}function numFormat(num,format){var result=NumUtil.format(num,format);return result}}])}(window.angular,window.Math),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("ErrorService",["_","aprgettext","RequestTypes","toaster",function(_,gettext,RequestTypes,toaster){return{convertToErrorMessages:convertToErrorMessages,displayErrorMessages:function(error,asHtml){var errors=_.isArray(error)?error:convertToErrorMessages(error);return errors.forEach(function(err){toaster.pop({type:"error",title:"",body:err,bodyOutputType:asHtml?"trustedHtml":""})}),errors},addHttpErrorToScope:function(scope,httpResponse,messages,type){var error={type:type||RequestTypes.default},key="is"+httpResponse.status;error[key]=!0,error.reason=messages&&messages[key],403===httpResponse.status?error.responseMessage=httpResponse.headers()["reason-phrase"]:error.unhandled=!0;return error.reason=error.reason||error.responseMessage,scope.httpError=error},removeHttpErrorFromScope:function(scope,type){scope.hasOwnProperty("httpError")&&scope.httpError&&(!type&&scope.httpError.type===RequestTypes.default||scope.httpError.type===type)&&(scope.httpError=null)}};function convertToErrorMessages(error){var errors=[];if(!error)return errors.push(getGenericError()),errors;if(_.isString(error))return errors.push(error),errors;var modelState=error.data&&error.data.ModelState||error.ModelState;if(modelState&&(_(modelState).flatMap(function(value){return value||[]}).forEach(function(err){errors.push(gettext(err))}),errors.length))return errors;var validationResult=error.data&&error.data.ValidationResult||error.ValidationResult;if(validationResult&&!validationResult.IsValid&&(_(validationResult.Errors).forEach(function(err){errors.push(gettext(err.ErrorMessage))}),errors.length))return errors;if(error.status&&error.statusText)errors.push(gettext("An error has occurred. Status: "+error.status+": "+error.statusText));else{var genericError=getGenericError();error.Message&&(genericError+=" "+error.Message),errors.push(genericError)}return errors}function getGenericError(){return gettext("An error has occurred and the process cannot be completed.")}}])}(),angular.module("aprima-legacy-common").factory("LanguageFactory",["gettextCatalog","LocalStorageRepository",function(gettextCatalog,LocalStorageRepository){"use strict";var currentLang={code:gettextCatalog.currentLanguage},langOptions=[{name:"English",id:"en_US"},{name:"Spanish",id:"es_MX"}];function normalizeToUnderscore(language){return language?language.replace("-","_"):language}function getLang(){return currentLang.code=currentLang.code?normalizeToUnderscore(currentLang.code):"en_US",currentLang}return{setLang:function(language){gettextCatalog.currentLanguage=normalizeToUnderscore(language),currentLang.code=gettextCatalog.currentLanguage,LocalStorageRepository.setLang(gettextCatalog.currentLanguage)},getLang:getLang,getLangOptions:langOptions,getActiveLanguage:function(){return _.find(langOptions,{id:getLang().code})}}}]),angular.module("aprima-legacy-common").factory("ListNavigationService",["$log","$filter","Bridge",function($log,$filter,Bridge){"use strict";var cachedEnumerators=[],activeItems=[];return{buildAndCacheEnumerator:function(enumeratorName,list,orderPredicate,transitionFunction){var filter=$filter("orderBy"),enumerator=this.buildEnumerator(filter(list,orderPredicate),transitionFunction);return cachedEnumerators[enumeratorName]=enumerator,activeItems[enumeratorName]&&enumerator.setActiveItemById(activeItems[enumeratorName]),enumerator},getEnumerator:function(enumeratorName){return cachedEnumerators[enumeratorName]},buildEnumerator:function(list,callbackFunction){$log.info("enumerator built");var currentIndex=-1,transitionFunction=function(item){currentIndex=list.indexOf(item),callbackFunction&&callbackFunction(item)},next=function(){var lookupIndex;if(-1!==currentIndex){if(currentIndex===list.length-1)return null;lookupIndex=currentIndex+1}else{if(0===list.length)return null;lookupIndex=0}return list[lookupIndex]},canGoNext=function(){return-1!==currentIndex&&currentIndex!==list.length-1},currentItem=function(){return-1!==currentIndex?list[currentIndex]:null};return{next:next,previous:function(){var lookupIndex;if(-1!==currentIndex){if(0===currentIndex)return null;lookupIndex=currentIndex-1}else{if(0===list.length)return null;lookupIndex=list.length-1}return list[lookupIndex]},first:function(){return 0===list.length?null:list[0]},last:function(){return 0===list.length?null:list[list.length-1]},moveToNextItem:function(){var next=this.next();next&&transitionFunction(next)},moveToPreviousItem:function(){var previous=this.previous();previous&&transitionFunction(previous)},moveToFirstItem:function(){transitionFunction(this.first())},moveToLastItem:function(){transitionFunction(this.last())},moveToItem:function(item){var indexOf=list.indexOf(item);if(!(0<=indexOf))throw new Exception("Cannot move to item as it does not exist in the list.");currentIndex=indexOf,transitionFunction(item)},canGoNext:canGoNext,canGoPrevious:function(){return-1!==currentIndex&&0!==currentIndex},getNavStatus:function(){return{canGoForward:this.canGoNext(),canGoBack:this.canGoPrevious()}},setActiveItemById:function(id){for(var i=0;i<=list.length-1;i++)if(list[i].Id===id){currentIndex=i;break}},currentItem:currentItem,toArray:function(){var oldIndex=currentIndex,arr=[];for(currentIndex=0,currentItem()&&arr.push(currentItem());canGoNext();)arr.push(next()),currentIndex++;return currentIndex=oldIndex,arr}}},hydrateListNavigationProperties:function(enumeratorName,settings){var enumerator=cachedEnumerators[enumeratorName];enumerator&&(angular.forEach(settings.phone.modes,function(value){angular.forEach(value.headers,function(headerValue){headerValue.requiresNavSettings&&(headerValue.listNavigationProperties=enumerator.getNavStatus())})}),angular.forEach(settings.tablet.modes,function(value){angular.forEach(value.headers,function(headerValue){headerValue.requiresNavSettings&&(headerValue.listNavigationProperties=enumerator.getNavStatus())})}))},setAsBridgeHandler:function(enumeratorName,$scope){var enumerator=cachedEnumerators[enumeratorName];enumerator&&Bridge.on("navigate-item",$scope,function(data){switch(data.navigationType){case"next":enumerator.moveToNextItem();break;case"previous":enumerator.moveToPreviousItem()}})},registerActiveItemForList:function(listType,itemId,settings,$scope){var enumerator=this.getEnumerator(listType);enumerator&&(enumerator.setActiveItemById(itemId),this.hydrateListNavigationProperties(listType,settings),this.setAsBridgeHandler(listType,$scope)),activeItems[listType]=itemId},deregisterActiveItemForList:function(listType,itemId){activeItems[listType]&&activeItems[listType]===itemId&&(activeItems[listType]=null)},setActiveItemByIdForEnumerator:function(enumeratorName,id){var enumerator=cachedEnumerators[enumeratorName];enumerator&&enumerator.setActiveItemById(id)}}}]),angular.module("aprima-legacy-common").factory("LocalStorageRepository",["storage","_",function(storage,_){"use strict";var trueRegex=/^true$/i,falseRegex=/^false$/i,overwritePropertiesAndSave=function(destinationGetter,source,storageKey){var destination=destinationGetter()||{};destination=_.assign(destination,source),storage.set(storageKey,destination)},defaultPropertiesAndSave=function(destinationGetter,source,storageKey){var destination=destinationGetter()||{};destination=_.defaults(destination,source),storage.set(storageKey,destination)};function getPatientDashboardsKey(type){var key="patientDashboardConfigurations";return angular.isNumber(type)&&(type+="cols"),type&&(key+="."+type),key}return{clearAll:function(){storage.clearAll()},getIsActiveDirectoryUser:function(){return storage.get("activeDirectoryUser")},setIsActiveDirectoryUser:function(value){storage.set("activeDirectoryUser",value)},getClientID:function(){return storage.get("clientID")},setClientID:function(value){storage.set("clientID",value)},getNotificationTimeout:function(){return storage.get("notificationTimeout")},setNotificationTimeout:function(value){storage.set("notificationTimeout",value)},getClientURL:function(){var url=storage.get("clientURL");return _.isUndefined(url)?null:url},setClientURL:function(value){storage.set("clientURL",value)},removeClientURL:function(){storage.remove("clientURL")},getGatewayUrl:function(){return storage.get("gatewayUrl")},setGatewayUrl:function(value){storage.set("gatewayUrl",value)},setJsonWebToken:function(jwt){storage.set("json-web-token",jwt)},getJsonWebToken:function(){return storage.get("json-web-token")},removeJsonWebToken:function(){storage.remove("json-web-token")},setDecodedJsonWebToken:function(decodedToken){storage.set("decoded-json-web-token",JSON.stringify(decodedToken))},removeDecodedJsonWebToken:function(){storage.remove("decoded-json-web-token")},getDecodedJsonWebToken:function(){var val=storage.get("decoded-json-web-token");return JSON.parse(val)},setUserName:function(username){storage.set("userName",username)},getUserName:function(){return storage.get("userName")},setBirthDate:function(birthDate){storage.set("birthDate",birthDate)},getBirthDate:function(){return storage.get("birthDate")},setAccessCode:function(statementId){storage.set("accessCode",statementId)},getAccessCode:function(){return storage.get("accessCode")},setUserFullName:function(name){storage.set("userFullName",name)},getUserFullName:function(){return storage.get("userFullName")},removeUserName:function(){storage.remove("userName")},setUserID:function(userid){storage.set("userId",userid)},getUserID:function(){return storage.get("userId")},getIsPatient:function(){return storage.get("isPatient")},setIsPatient:function(isPatient){storage.set("isPatient",isPatient)},getSupportedFeatures:function(){return storage.get("apiSupportedFeatures")},removeUserID:function(){storage.remove("userId")},setLang:function(lang){storage.set("lang",lang)},getLang:function(){return storage.get("lang")},setDefaultSuperbillSubmissionMethod:function(methodId){storage.set("superbillMethod",methodId)},getDefaultSuperbillSubmissionMethod:function(){return storage.get("superbillMethod")},setKey:function(key,value,keyType){if(storage.set(key,value),keyType){var keyDictionary,activeKeys=storage.get(keyType+"keys");keyDictionary=activeKeys?activeKeys.split(","):[],_.includes(keyDictionary,key)||(keyDictionary.push(key),storage.set(keyType+"keys",keyDictionary.join(",")))}},getKey:function(key,keyType){var k=storage.get(key);if(keyType){var keyDictionary,activeKeys=storage.get(keyType+"keys");keyDictionary=activeKeys?activeKeys.split(","):[],_.includes(keyDictionary,key)||(keyDictionary.push(key),storage.set(keyType+"keys",keyDictionary.join(",")))}return k},removeKey:function(key){storage.remove(key)},setPatientDashboardWidgets:function(widget){storage.set("patientDashboardWidgets",widget)},getPatientDashboardWidgets:function(){return storage.get("patientDashboardWidgets")},setPatientDashboardConfigurations:function(newList,type){var list=this.getPatientDashboardConfigurations(type)||[],hasV1Tiles=_.some(list,function(val){return!_.isUndefined(val.WidgetDescriptors)});_.isEmpty(list)||hasV1Tiles||_.forEach(newList,function(val){val.Tiles=_.map(val.Tiles,function(tile){var savedConfig=_(list).find({Id:val.Id});if(savedConfig){var savedTile=_(savedConfig.Tiles).find({Id:tile.Id});if(savedTile)return _.defaults(tile,savedTile)}return tile})}),storage.set(getPatientDashboardsKey(type),newList)},removePatientDashboardWidgets:function(){storage.remove("patientDashboardWidgets")},overwritePatientDashboardConfigurations:function(newList,type){storage.set(getPatientDashboardsKey(type),newList)},getPatientDashboardConfigurations:function(type){return storage.get(getPatientDashboardsKey(type))},removePatientDashboardConfigurations:function(type){storage.remove(getPatientDashboardsKey(type))},getDashboardTileSettings:function(){return storage.get("settings.dashboard.tiles")},setDashboardTileSettings:function(settings){return overwritePropertiesAndSave(this.getDashboardTileSettings,settings,"settings.dashboard.tiles")},setDefaultDashboardTileSettings:function(settings){return defaultPropertiesAndSave(this.getDashboardTileSettings,settings,"settings.dashboard.tiles")},getAppointmentsListSettings:function(){return storage.get("settings.appointmentslist")},setAppointmentsListSettings:function(settings){return overwritePropertiesAndSave(this.getAppointmentsListSettings,settings,"settings.appointmentslist")},setDefaultAppointmentsListSettings:function(settings){return defaultPropertiesAndSave(this.getAppointmentsListSettings,settings,"settings.appointmentslist")},getMessagesListSettings:function(){return storage.get("settings.messageslist")},setMessagesListSettings:function(settings){return overwritePropertiesAndSave(this.getMessagesListSettings,settings,"settings.messageslist")},setDefaultMessagesListSettings:function(settings){var messageSettings=this.getMessagesListSettings();return messageSettings&&messageSettings.messageFilterId?storage.set("settings.messageslist",settings):defaultPropertiesAndSave(this.getMessagesListSettings,settings,"settings.messageslist")},getAppointmentsBadgeSettings:function(){return storage.get("settings.appointments.badge.settings")},setAppointmentsBadgeSettings:function(settings){return overwritePropertiesAndSave(this.getAppointmentsBadgeSettings,settings,"settings.appointments.badge.settings")},setDefaultAppointmentsBadgeSettings:function(settings){return defaultPropertiesAndSave(this.getAppointmentsBadgeSettings,settings,"settings.appointments.badge.settings")},getDefaultServiceSiteId:function(){return storage.get("serviceSiteId")},setDefaultServiceSiteId:function(serviceSiteId){storage.set("serviceSiteId",serviceSiteId)},getDeviceId:function(){return storage.get("deviceId")},setDeviceId:function(deviceId){storage.set("deviceId",deviceId)},getPhoneMessageGeneralNoteTypeId:function(){return storage.get("settings.phoneMessageGeneralNoteTypeId")},setPhoneMessageGeneralNoteTypeId:function(id){storage.set("settings.phoneMessageGeneralNoteTypeId",id)},getTaskMessageGeneralNoteTypeId:function(){return storage.get("settings.taskMessageGeneralNoteTypeId")},setTaskMessageGeneralNoteTypeId:function(id){storage.set("settings.taskMessageGeneralNoteTypeId",id)},getPharmacyGeneralNoteTypeId:function(){return storage.get("settings.pharmacyGeneralNoteTypeId")},setPharmacyGeneralNoteTypeId:function(id){storage.set("settings.pharmacyGeneralNoteTypeId",id)},getPortalMessageGeneralNoteTypeId:function(){return storage.get("settings.portalMessageGeneralNoteTypeId")},setPortalMessageGeneralNoteTypeId:function(id){storage.set("settings.portalMessageGeneralNoteTypeId",id)},getRxRefillMessageGeneralNoteTypeId:function(){return storage.get("settings.rxRefillMessageGeneralNoteTypeId")},setRxRefillMessageGeneralNoteTypeId:function(id){storage.set("settings.rxRefillMessageGeneralNoteTypeId",id)},getPharmacyRefillMessageGeneralNoteTypeId:function(){return storage.get("settings.pharmacyRefillMessageGeneralNoteTypeId")},setPharmacyRefillMessageGeneralNoteTypeId:function(id){storage.set("settings.pharmacyRefillMessageGeneralNoteTypeId",id)},getPatientVitalsDefaultSettingId:function(){return storage.get("settings.patientVitalsDefaultSettingId")},setPatientVitalsDefaultSettingId:function(id){storage.set("settings.patientVitalsDefaultSettingId",id)},getMedicationOverrideGeneralNoteTypeId:function(){return storage.get("settings.medicationOverrideGeneralNoteTypeId")},setMedicationOverrideGeneralNoteTypeId:function(id){storage.set("settings.medicationOverrideGeneralNoteTypeId",id)},getCurrentUserLicenses:function(){return storage.get("settings.currentUserLicenses")},setCurrentUserLicenses:function(licenses){storage.set("settings.currentUserLicenses",licenses)},getIsERxEnabled:function(){return storage.get("settings.erxenabled")},setIsERxEnabled:function(enabled){storage.set("settings.erxenabled",!!enabled)},getAllowImperialUnits:function(){return storage.get("settings.allowImperialUnitsInPrescription")},setAllowImperialUnits:function(allowed){storage.set("settings.allowImperialUnitsInPrescription",!!allowed)},getApplicationVersion:function(){return storage.get("applicationVersion")},setApplicationVersion:function(version){storage.set("applicationVersion",version)},getUserPermissions:function(){return storage.get("userPermissions")},setUserPermissions:function(permissions){permissions=function(permissions){var permissionObj=permissions||{};for(var prop in permissionObj)trueRegex.test(permissionObj[prop])?permissionObj[prop]=!0:falseRegex.test(permissionObj[prop])&&(permissionObj[prop]=!1);return permissionObj}(permissions),storage.set("userPermissions",permissions)},getAskedUserForTouchID:function(){return storage.get("askedUserForTouchID")},setAskedUserForTouchID:function(prompt){storage.set("askedUserForTouchID",prompt)},getUserEnabledTouchID:function(){return storage.get("userEnabledTouchID")},setUserEnabledTouchID:function(enabled){storage.set("userEnabledTouchID",enabled)},getOncePerLoginChartConsent:function(){return storage.get("OncePerLoginChartConsent")},setOncePerLoginChartConsent:function(enabled){storage.set("OncePerLoginChartConsent",enabled)},clearKeysOfType:function(keyType){var activeKeys=storage.get(keyType+"keys");if(activeKeys){var keyDictionary=activeKeys.split(",");_.forEach(keyDictionary,function(key){storage.remove(key)})}storage.remove(keyType+"keys")},clearSessionStorage:function(){clearKeysOfType("list"),clearKeysOfType("metadata")},clearOldVersionCache:function(){storage.remove("messagetypessupportedforcreate")}}}]),angular.module("aprima-legacy-common").factory("LogInService",["DeviceSettings",function(DeviceSettings){"use strict";var redirectState,redirectParams,isCustomRedirect,customTransition;function setDefaultRedirect(){isCustomRedirect=!1,redirectState=DeviceSettings.isDevice?"dashboard":"landing",redirectParams=null}return setDefaultRedirect(),{getRedirect:function(){if(isCustomRedirect)return customTransition;var redirect={appRoute:redirectState,opts:redirectParams||{}};return redirect.opts.replaceCurrentState=!0,redirect},setDefaultRedirect:setDefaultRedirect,setRedirect:function(transition){isCustomRedirect=!0,(customTransition=transition).opts.replaceCurrentState=!0}}}]),angular.module("aprima-legacy-common").factory("LogOffService",["AprimaAnalytics","Bridge","LocalStorageRepository","$q",function(AprimaAnalytics,Bridge,LocalStorageRepository,$q){"use strict";return{logoff:function(){return LocalStorageRepository.removeJsonWebToken(),LocalStorageRepository.removeDecodedJsonWebToken(),AprimaAnalytics.sendEvent("user","click","logoff",0),Bridge.logoff("logoff"),$q.when()}}}]),angular.module("aprima-legacy-common").factory("AppointmentTransitionToHelper",["apFilterFeatureFilter","AppointmentScheduleTypes",function(apFilterFeature,AppointmentScheduleTypes){"use strict";var routes={};return routes[AppointmentScheduleTypes.PatientVisit.id]={view:"appointment",edit:"editAppointment",add:"addAppointment",requiredFeature:AppointmentScheduleTypes.PatientVisit.requiredFeature},routes[AppointmentScheduleTypes.GroupVisit.id]={view:"groupAppointment",edit:"editGroupAppointment",add:"addGroupAppointment",requiredFeature:AppointmentScheduleTypes.GroupVisit.requiredFeature},routes[AppointmentScheduleTypes.Event.id]={view:"eventAppointment",edit:"editEventAppointment",add:"addEventAppointment",requiredFeature:AppointmentScheduleTypes.Event.requiredFeature},routes[AppointmentScheduleTypes.BlockingEvent.id]={view:"blockingEventAppointment",edit:"editBlockingEventAppointment",add:"addBlockingEventAppointment",requiredFeature:AppointmentScheduleTypes.BlockingEvent.requiredFeature},{getTransition:function(apptScheduleType,patientId,calendarId,edit,apptId){if(!apptScheduleType)return!1;var filteredRoutes=apFilterFeature(routes,"requiredFeature"),transition={opts:{}},lowerScheduleType=apptScheduleType.toLowerCase();if(apptId){transition.opts.id=apptId;var property=edit?"edit":"view";transition.appRoute=filteredRoutes[lowerScheduleType]&&filteredRoutes[lowerScheduleType][property]||filteredRoutes[AppointmentScheduleTypes.PatientVisit.id][property]}else transition.appRoute=filteredRoutes[lowerScheduleType]&&filteredRoutes[lowerScheduleType].add||filteredRoutes[AppointmentScheduleTypes.PatientVisit.id].add;return patientId&&(transition.opts.patientid=patientId),calendarId&&(transition.opts.calendarId=calendarId),transition}}}]),angular.module("aprima-legacy-common").provider("AppRoutes",["_",function(_){"use strict";var appRoutes={};function getAppRoutes(){return appRoutes}this.setupAppRoutes=function(newAppRoutes){_.defaults(appRoutes,newAppRoutes)},this.getAppRoutes=getAppRoutes,this.$get=["DeviceSettings",function(DeviceSettings){return getAppRoutes()}]}]),angular.module("aprima-legacy-common").factory("BrowserWebViewManager",["$window","$state",function($window,$state){"use strict";return{activateView:function(appRoute,transition){var opts=transition.opts;return opts.replaceCurrentState&&!0===opts.replaceCurrentState?$state.go(appRoute.state,opts,{location:"replace"}):$state.go(appRoute.state,opts),!0},goBack:function(){$window.history.back()}}}]),angular.module("aprima-legacy-common").factory("MessageTransitionToHelper",["MessageTypes","_","apFilterFeatureFilter",function(MessageTypes,_,apFilterFeature){"use strict";var routes={};return routes[MessageTypes.PhoneMessageGuid]={route:"phonemessage"},routes[MessageTypes.TaskMessageGuid]={route:"taskmessage"},routes[MessageTypes.LabMessageGuid]={route:"labmessage"},routes[MessageTypes.PortalAppointmentQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.PortalBillingQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.PortalDemographicsQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.PortalGeneralQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.PortalRxQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.AttachmentApprovalGuid]={route:"aamessage"},routes[MessageTypes.ServiceOrderApprovalMessageGuid]={route:"serviceorderapprovalmessage"},routes[MessageTypes.RxRefillRequestMessageGuid]={route:"rxrefillmessage",requiredFeature:"Messages_RxRefill,Visits_RX"},routes[MessageTypes.PatientRxRefillRequestMessageGuid]={route:"rxrefillmessage",requiredFeature:"Messages_RxRefill,Visits_RX"},routes[MessageTypes.PharmacyRefillRequestMessageGuid]={route:"pharmacyrefillmessage",requiredFeature:"Messages_PharmacyRefill,Visits_RX"},{getTransitionForMessage:function(messageTypeId,messageId,messageSubTypeId,createNew,options){var transition={appRoute:"message",opts:{id:messageId}};options&&_.merge(transition.opts,options);var lowerMessageTypeId=messageTypeId.toLowerCase(),lowerMessageSubTypeId=messageSubTypeId.toLowerCase(),filteredRoutes=apFilterFeature(routes,"requiredFeature");return transition.appRoute=(createNew?"create":"")+(filteredRoutes[lowerMessageTypeId]&&filteredRoutes[lowerMessageTypeId].route||filteredRoutes[lowerMessageSubTypeId]&&filteredRoutes[lowerMessageSubTypeId].route||"message"),transition}}}]),angular.module("aprima-legacy-common").factory("RouteFormatter",["$urlMatcherFactory","_",function($urlMatcherFactory,_){"use strict";return{formatRoute:function(routePattern,params){return params=_.isUndefined(params)?{}:params,$urlMatcherFactory.compile(routePattern).format(params)},formatRelativeRoute:function(routePattern,parentRoutePattern,params){return params=_.isUndefined(params)?{}:params,0===routePattern.indexOf(parentRoutePattern+"/")&&(routePattern=routePattern.substring(parentRoutePattern.length)),$urlMatcherFactory.compile(routePattern).format(params)}}}]),angular.module("aprima-legacy-common").service("TransitionManager",["$log","$state","AppRoutes","_","WebViewManager","$rootScope",function($log,$state,AppRoutes,_,WebViewManager,$rootScope){"use strict";var previousTransition;$rootScope.$on("$stateChangeSuccess",function(event,toState,toParams,fromState,fromParams){var appRoute=_(AppRoutes).findKey({state:fromState.name||toState.name});previousTransition={appRoute:appRoute,opts:fromParams}});var transitionToState=function(transition,replaceState){if(transition=function(transition){return transition?(transition=_.defaults(transition,{type:"transition",appRoute:"",opts:{}}),$log.info("TransitionManager postMessage to "+JSON.stringify(transition)),transition):void $log.warn("Cannot transition to null or undefined transition")}(transition)){var targetRoute=AppRoutes[transition.appRoute];return targetRoute?(_.isBoolean(transition.opts.replaceCurrentState)||(_.isBoolean(replaceState)?transition.opts.replaceCurrentState=replaceState:$state.current&&$state.current.name===targetRoute.state?transition.opts.replaceCurrentState=!0:transition.opts.replaceCurrentState=!1),targetRoute.options&&(transition.opts=_.merge(transition.opts,targetRoute.options)),$rootScope.$broadcast("TransitionActivated",transition),WebViewManager.activateView(targetRoute,transition)):($log.warn('Unable to find AppRoute: "'+transition.appRoute+'". Aborting transition.'),!1)}};return{transition:transitionToState,replaceCurrentState:function(transition){transitionToState(transition,!0)},goBack:function(){WebViewManager.goBack()},getPreviousTransition:function(){return previousTransition}}}]),angular.module("aprima-legacy-common").factory("WebViewManager",["$log","BrowserWebViewManager","XamarinWebViewManager","DeviceSettings",function($log,BrowserWebViewManager,XamarinWebViewManager,DeviceSettings){"use strict";return DeviceSettings.isDevice||DeviceSettings.isPrm?($log.info("Using XamarinWebViewManager"),XamarinWebViewManager):($log.info("Using BrowserWebViewManager"),BrowserWebViewManager)}]),angular.module("aprima-legacy-common").factory("XamarinWebViewManager",["RouteFormatter","_","Bridge","$state",function(RouteFormatter,_,Bridge,$state){"use strict";return Bridge.onNavigate(function(d){if(!_.isUndefined(d)){var opts=JSON.parse(d.opts);opts&&!0===opts.replaceCurrentState?$state.go(d.state,opts,{location:"replace"}):$state.go(d.state,opts)}}),{activateView:function(appRoute,transition){var rawRoute=appRoute.route;appRoute.route&&(rawRoute=function completeRoute(appState){var parentSeperator=appState.state.lastIndexOf(".");if(0<parentSeperator){var parentState=$state.get(appState.state.substring(0,parentSeperator));return completeRoute({state:parentState.name,route:parentState.url})+appState.route}return appState.route}(appRoute));var route=appRoute.route?RouteFormatter.formatRelativeRoute(rawRoute,$state.get("^").url,transition.opts):"";return Bridge.navigate(appRoute,route,transition),!0},goBack:function(){Bridge.goBack()}}}]),angular.module("aprima-legacy-common").factory("NoteTypeRepository",["_","SystemGuid",function(_,SystemGuid){"use strict";var supportedTabs=["3e4888e6-a0be-4e5b-bdbf-3da7d4f71375",SystemGuid.UIControl_Note_CC,SystemGuid.UIControl_Note_CCHPI,"ffbb556f-ab4e-478f-a2d7-b4b863a344e9",SystemGuid.UIControl_Note_Confidential,"2c513cab-0d52-4e06-b64f-dc6391e464b7",SystemGuid.UIControl_Note_DX,SystemGuid.UIControl_Note_DXDSM,SystemGuid.UIControl_Note_GeneralNote,"8b40d89b-3511-42a4-b07b-decadc72647e",SystemGuid.UIControl_Note_HPI,SystemGuid.UIControl_Note_HX,"38080e33-7a49-4e4d-9d5c-ff87319d8307",SystemGuid.UIControl_Note_PE,SystemGuid.UIControl_Note_Plan,SystemGuid.UIControl_Note_Results,SystemGuid.UIControl_Note_ROS,SystemGuid.UIControl_Note_ROSPE,SystemGuid.UIControl_Note_RX,"871c47ed-372f-4c89-a4b8-c753951ca93e",SystemGuid.UIControl_Note_SO,SystemGuid.UIControl_Note_SP,SystemGuid.UIControl_Note_VisitText,SystemGuid.UIControl_Note_Vitals],supportedSliders=["2f35a3bb-0778-4cd6-a178-7734e7b4836e","4836176d-e412-47e9-ab6b-b549515c8007","bf9d1d68-cdcc-48f0-8080-1815212914fb","41e171a8-667a-4ade-aba4-dc7ce21c30d7","87d90295-1cbf-41cd-8582-fad6e0a7a4b9","142937f8-4c55-4c15-9677-f1a2105a019e","5b8fa2e2-31fa-40aa-bbf6-9d969ae5cc71","41e171a8-667a-4ade-aba4-dc7ce21c30d7","48606f65-ddf6-4f83-afaf-7dfb842d13d6","881ee22a-9193-45b3-85f5-818e4bd6ece9","b9d820ab-b216-47bf-af2d-b7ebfb79a137","14266173-8cfc-4b4e-8fa6-8f95ea61e03d"];function isNoteTabsSupported(note){if(_.isNil(note))return!1;var noteTabs=_.map(note.Tabs,"TabSliderUid");return _.intersection(noteTabs,supportedTabs).length===noteTabs.length}function isNoteSlidersSupported(note){if(_.isNil(note))return!1;var noteSliders=_.map(note.Sliders,"TabSliderUid");return _.intersection(noteSliders,supportedSliders).length===noteSliders.length}return{isNoteTypeSupported:function(note){return!_.isNil(note)&&isNoteTabsSupported(note)&&isNoteSlidersSupported(note)},isNoteTabsSupported:isNoteTabsSupported,isNoteSlidersSupported:isNoteSlidersSupported}}]),angular.module("aprima-legacy-common").factory("$qHelpers",["$q","_","$timeout",function($q,_,$timeout){"use strict";return{whenFirstSuccess:function(promises){var deferred=$q.defer(),results=[],resolved=!1,rejectionFlagValue={};function tryResolveToFirstSuccess(){var index=-1,length=results?results.length:0;if(!results||resolved)return!1;for(;++index<length;){var result=results[index];if(void 0===result)return!1;if(result!==rejectionFlagValue)return resolved=!0,deferred.resolve(result),results=null,!1}deferred.reject("Could not resolve first successful promise. All promises were rejected.")}return _.forEach(promises,function(promise,index){results[index]=void 0,promise.then(function(result){resolved||(results[index]=result,tryResolveToFirstSuccess())},function(){resolved||(results[index]=rejectionFlagValue,tryResolveToFirstSuccess())})}),deferred.promise},timeout:function(promise,time){var deferred=$q.defer(),timeoutPromise=$timeout(function(){deferred.reject("Promise took too long to resolve and was rejected.")},time);return promise.then(function(result){deferred.resolve(result)}).catch(function(err){deferred.reject(err)}).finally(function(){$timeout.cancel(timeoutPromise)}),deferred.promise},delay:function(promise,time){var deferred=$q.defer();return $timeout(function(){promise.then(function(result){deferred.resolve(result)}).catch(function(err){deferred.reject(err)})},time),deferred.promise},abortablePromise:abortablePromise,isPromise:function(value){return!!(value&&angular.isFunction(value.then)&&angular.isFunction(value.catch)&&angular.isFunction(value.finally))},abortPromises:abortPromises,abortPromise:abortPromise};function abortablePromise(promise,previousPromises,shouldRejectOnAbort){var deferred=$q.defer();shouldRejectOnAbort=angular.isFunction(shouldRejectOnAbort)?_.once(shouldRejectOnAbort):function(){return!0},abortPromises(previousPromises),promise.then(function(result){deferred.resolve(result)},function(error){deferred.reject(error)});var error={isAborted:!0,msg:"Aborted"};return deferred.promise.abort=function(){var shouldAbort=!!shouldRejectOnAbort(error);return shouldAbort&&deferred.reject(error),shouldAbort},replaceChainFnsWithAbortableFns(deferred.promise,"then"),replaceChainFnsWithAbortableFns(deferred.promise,"catch"),replaceChainFnsWithAbortableFns(deferred.promise,"finally"),deferred.promise}function abortPromises(promises){_.isArray(promises)?_.forEach(promises,function(promise){abortPromise(promise)}):abortPromise(promises)}function abortPromise(promise){promise&&promise.abort&&promise.abort()}function replaceChainFnsWithAbortableFns(promise,chainFnKey){var wrappedKey="_"+chainFnKey,wrappedFn=promise[wrappedKey]=promise[wrappedKey]||promise[chainFnKey]||angular.noop;promise[chainFnKey]=function(){var chained=wrappedFn.apply(promise,arguments);return _.isFunction(chained.abort)?chained:abortablePromise(chained,null,function(){return promise.abort()})}}}]),angular.module("aprima-legacy-common").factory("HttpAbortableContext",["$q","$qHelpers","_",function($q,$qHelpers,_){"use strict";return function(previousPromiseToAbort){var abortDeferred=$q.defer();return{abortPromise:abortDeferred.promise,wrap:function(promise){var abortedError;return promise=promise.catch(function(error){return abortedError&&error&&error.status<0&&_.assign(error,abortedError),$q.reject(error)}),$qHelpers.abortablePromise(promise,previousPromiseToAbort,function(error){return abortedError=error,abortDeferred.resolve(),!1})}}}}]),function(angular){"use strict";window.angular.module("aprima-legacy-common").constant("Permissions",{Schedule:"schedule",FullNoteComposer:"fnc",StrikeoutVisits:"strikeoutvisits"})}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("SecurityRepository",["_","$q","AprimaCache","AprimaRestangular",function(_,$q,AprimaCache,AprimaRestangular){var defaultCache=AprimaCache.Permissions.httpMode;return{getPermissions:function(permissionName){return AprimaRestangular.get().one("permissions",permissionName).withHttpConfig({cache:defaultCache}).get().then(function(securityPermission){return securityPermission?(_.has(securityPermission,"IsAllowed")||(securityPermission.IsAllowed=!0),securityPermission):$q.reject("No permission matches '"+permissionName+"'")})}}}])}(),function(){"use strict";angular.module("aprima-legacy-common").value("SystemGuid",{CareTeam:"10101010-0000-0000-0000-000000000001",Everyone:"00000101-0000-0000-0000-000000000000",BuildInMessageImplementation:"10101010-0000-0000-0000-000000000006",ApproveMessageImplementation:"10101010-0000-0000-0000-000000000007",RoutineMessageUrgency:"c2a64d38-3be1-4f8a-8947-ef9e9ad861a4",AAMessageType:"10101010-0000-0000-0000-000000000002",TCMessageType:"10101010-0000-0000-0000-000000000003",RxMessageType:"10101010-0000-0000-0000-000000000004",TaskMessageType:"10101010-0000-0000-0000-000000000005",TaskMessageType_Procedure:"10101010-0000-0000-1111-000000000005",HL7MessageType:"10101010-0000-0000-0000-000000000008",ANMessageType:"10101010-0000-0000-0000-000000000009",ClaimErrorMessageType:"10101010-0000-0000-0000-000000000010",MessageAttachHTML:"10101010-0000-0000-0000-000000000011",ERxRefillMessageType:"d7716f70-61d6-4ec0-8ba6-01afc95e99f2",RxRefillMessageType:"a2b88bc2-e7c8-4990-92f6-ae28b5c0dc77",SurveyMessageType:"5e9280e5-3388-49e8-a5ae-4dffbb0a9b89",AuthorizationMessageType:"34e136de-85d4-4bdf-a487-7972ea3ce105",MessageAttachmentType:"10101010-0000-0000-0000-000000000012",InstantMessageMessageType:"3c2fa842-9097-483a-bff8-2e7e47f2b6e2",CollectionMessageMessageType:"7a0ea261-29e8-44be-9e0a-13bdaa7b282a",StrikeOutMessageType:"e3226583-1509-4ef1-9647-e5d5991dd41a",LabMessageType:"f05f9c71-a893-46c3-a7fe-37988f48a782",PatientLabOrderMessageType:"77882a75-7c9d-430b-9da6-f8ed12058ddb",ERxChangeMessageType:"f4bee48e-2975-46d5-acc8-4a04126f5275",ERxEligibilityMessageType:"10101010-0000-0000-0000-000000000014",ERxMedicationHistoryMessageType:"10101010-0000-0000-0000-000000000013",PatientEmergencyChartAccessMessageType:"07dfc802-0ce9-4381-bdae-959315458476",VisitBillingReviewMessageType:"81ad57ba-e3f1-4b8f-b3f2-23a189fba3e5",VaccineAdministrationMessageType:"3a68f4d0-b93d-4f9d-8036-1a89db86cdd5",PatientReferralMessageType:"b2a91010-cd37-4391-a850-683d230c177f",RefundTaskMessageType:"52249495-41c2-4c68-b027-eac66218599f",FinancialChangeAlertMessageType:"2cc02936-d3d5-4887-8f8f-45831ce1a46a",AmendmentMessageType:"b1f8b643-cd55-410f-bc5d-649fb64e98ba",MessageRxRequestSubType:"136d8762-82ec-487d-9448-f52469a3cdcd",MessageRxResponseSubType:"d0ddd888-de71-4156-a2d8-6f1f4068b249",MessageRxElectronicTransmissionErrorSubType:"f28b3d6a-2244-4197-8133-aeef881354fa",JobEngineSubMessageType:"00000000-0000-0000-7777-200000000001",DocumentFaxErrorSubMessageType:"77ef2a24-7e5e-436c-b689-8427ae45e7bf",PatientSurveySubMessageType:"0266be8e-73d2-452c-89fb-e16786ebdd94",PatientDemographicsSubMessageType:"d1d54662-29c2-44da-a0cf-28fefdf5d825",PatientAppointmentRequestSubMessageType:"4778614c-4594-4d1b-851d-5c67d21c5776",PatientRxRefillRequestSubMessageType:"b1b7d286-1fb2-43d0-a883-7946b1cd8751",PatientAmendmentSubMessageType:"e9fc14a7-0f2a-47ab-8fc3-4a04b7a20247",PatientGeneralQuestionSubMessageType:"9af1089b-e98b-4758-80f8-0435b143426d",PatientAppointmentQuestionSubMessageType:"fd4e2c5d-29c6-4a51-bd20-551d6ed90843",PatientRxQuestionSubMessageType:"e94b7146-407d-4f92-a393-de8429b7bfbf",PatientDemographicsQuestionSubMessageType:"dffb40d0-2318-41a9-8eef-94c58babb9b9",PatientBillingQuestionSubMessageType:"73366ba8-0149-47e0-875b-cb12bb4cb250",PatientEmailNewPatientAccountSubMessageType:"897562e2-94cd-4a0f-9f8c-2fcff3fe95ff",PatientEmailNewPortalAccountSubMessageType:"28652a5e-19e3-45ea-a6ba-f546d50e7fe7",PatientPortalErrorSubMessageType:"786e319f-01ef-48b8-a5a2-8499334a660d",PatientSubmitLoginAssistanceType:"eca5b8a3-8371-4c08-bf43-386bac737d3f",CDSReminderSubMessageType:"45d56c6b-f843-4e12-8d41-dc0f728c8b41",PatientRecallSubMessageType:"af799cc9-343c-4b2e-876d-36ce0ebdbf5a",PatientFamilyHistorySubMessageType:"2a00a8fb-4a0e-49c0-9dfa-c94a9ae6f165",PatientServiceOrderSubMessageType:"8080c9d5-be1c-478b-af6c-e179102e0c46",PatientWelcomeMessagePracticeDefaultSubMessageType:"d9a50836-98bb-4157-94ff-10a61c4f8355",PatientWelcomeMessageProviderOverrideSubMessageType:"3ff6ab41-02f2-4835-90d0-7093311e7ca0",HMRuleMessageSubType:"10101010-0000-0000-0000-000000000050",ReplicationMessageSubType:"594d621b-cbf4-4e1f-bafc-5195abc0ea9e",MessageProcedureRequestSubType:"6116da32-d833-4b3d-ba27-e7bec468fb6f",PatientVisitNoteAccessSubMessageType:"2a470344-8bb2-46a5-8893-73701911fc96",PatientChartAccessSubMessageType:"015a35fc-7c0e-4ac8-8ec9-3946a302028b",CPOBillingMessageSubType:"5214f054-5369-4102-97e4-9abbae205b66",SecurityAlertMessageSubType:"99810285-c0da-4e4a-8f23-8f6100fbdec3",ScheduledReportMessageSubType:"99b8ef67-faf4-4a15-abc5-76d95d826093",ClaimReportMessageSubType:"02430101-0067-485e-8431-842a420c2d41",CancelledServiceOrderSubType:"cba8e1a7-e65c-4eca-b3a3-c2cbedf6d7d3",CarePlanMessageSubType:"18cb87f2-291e-47b6-b1eb-8c2ad96a9b6c",CCMMessageSubType:"65e1a474-3ef4-41a0-ba88-473ec2c11011",CollectionStatusExpirationMessageSubType:"806a2155-acf7-4d0a-b83f-915232530e50",AuthorizationRequestSubType:"3febe005-809b-4c15-ae4a-3e7bcf12f2b1",AuthorizationResponseSubType:"34830710-2326-468c-a58c-355165a7d5e1",AccountChangeAlertSubType:"43580720-de8c-4ccb-8c8a-170a3d8cda65",PatientLabOrderRequestSubType:"22a2b2b0-d3c5-4229-84a4-9db792836f58",PatientLabOrderResponseSubType:"73fc9cfd-777d-497b-8c18-a9c09bc489c4",DocumentGenerationInstructionsSubType:"25fb8f0e-22cf-41dc-a63a-e10d49a34e8e",CompleteChartPrintSubType:"5b6f1708-e35c-4264-b4aa-a53a5dca7446",ProviderIDVerificationSubType:"00cdcaeb-d65b-4a1d-976e-b349a3e48da1",RequestGrantProviderEPCSRightsSubType:"082a7b1b-9a44-408b-87fd-6508b90544fe",RequestRevokeProviderEPCSSubType:"77e7df51-c19f-45ba-88a0-9f3492159ffd",DirectMailWithoutAttachmentMessageSubType:"613f69c5-42f4-4f81-ae64-deedb3670490",DirectMailWithAttachmentMessageSubType:"6347edde-54ee-4da1-b912-ea742030efc3",UrlLinkMessageSubType:"fd530fb4-05e3-46fe-8abb-6bfc3c1cd531",ElectronicResultMessageSubType:"43bca388-7d6c-466b-b859-0480156ec4f2",ERxMessageDenyReasonRefillNotAppropriate:"fffa4de9-d931-4311-8969-0dbd4e9c25ee",ERxMessageDenyReasonPatientUnknownToPractice:"b2464f3f-7ab4-4c18-b36f-96bf046b1c00",MessageStatusNew:"10101010-0000-0000-0000-000000000010",MessageStatusView:"10101010-0000-0000-0000-000000000011",MessageStatusComplete:"10101010-0000-0000-0000-000000000012",MessageStatusWait:"10101010-0000-0000-0000-000000000013",KdbSecurityGroup:"10101010-0000-0000-0000-000000000021",ClinicalDelgateSecurityAllow:"82276eab-504d-46b6-8aea-4d9ab1c0bab8",SecurityListEditorObjects:"10101010-0000-0000-0000-000000000022",SecurityListReportObjects:"10101010-0000-0000-0000-000000000023",SecurityListFilterObjects:"10101010-0000-0000-0000-000000000024",ReportSecurity:"10101010-0000-0000-0000-000000000025",AttachmentHandler_GraphicNote:"10101010-0000-0000-0000-000000000100",AttachmentHandler_AllFiles:"fc724a17-fdc7-4a0c-89a2-6a02f6b3e701",AttachmentHandler_Bmp:"1d037286-73d1-4ca3-b9f8-3dff4fb459a0",Report_CQM:"153cab39-18ff-416b-bd31-178f92fc23ff",Report_HEDIS:"3d2bda74-02bf-45d3-ad7f-06e3ae7bd173",HL7ListenerJob:"10101010-0000-0000-0000-000000000110",MainFinancialCenterUid:"14b99c94-edac-47bd-97b9-cf421ac16018",ClaimReportStatusNewUid:"00000000-0000-0000-0000-000000000010",ClaimReportStatusReviewedUid:"00000000-0000-0000-0000-000000000011",PaperClaimOptionDefaultToElectronicUid:"5b36f9c3-b1cf-4e80-8541-11397058b723",PaperClaimOptionSecondaryClaimsPrintUid:"9cb84c44-19f5-4f32-809c-3350bbe99aca",PaperClaimOptionAllClaimsPrintUid:"09aa94e4-e72b-499e-bf6e-e5fe9e05d8b8",ETacticsHL7PartnerUid:"905317b4-d36e-4b19-9d79-244a67b9274e",ETacticsCreateHL7PartnerMessageUid:"76c48549-a2fb-4396-a0d9-6dc9c05dbff6",PrintStatementActionUid:"a88f5a75-0ad5-4c90-b006-8a007a7fa13c",SubmitStatementActionUid:"dd9e9acd-0a49-44f3-b0b0-ece163fd8d42",PrintPreviewStatementActionUid:"067ab4ce-7bc3-4da5-8fa8-f8f5db24057e",PracticeInsightElectronicStatementsHL7PartnerUid:"66f598ce-0658-4ab4-814f-d2aa59cded6c",PracticeInsightElectronicStatementsHL7PartnerMessageUid:"d7c2b2b0-6c9f-4676-b5df-04d8c6bf44a9",ProcessStatementActionUid:"6fcad410-fe20-426f-b996-1b39650bc409",PaymentTypeCheckUid:"97270636-da7a-4e41-9fe9-e42b8dfa2f13",PaymentTypePureAdjustmentUid:"4a3eea98-802c-45f8-b3a1-d9957eafd075",ListDepositMacro_Visit:"2f480610-bc75-4193-9072-1d4cd9e5788c",ListDepositMacro_Account:"1dea5e1c-440d-4177-84b0-26aa78103fae",ListDepositMacro_RPOldestFirst:"2318d5e2-cc3f-428f-89a3-fe57338333cf",ListPayerCreditRefundStatus_Pending:"66872612-1a69-4c93-90a2-819288479ab2",ListPayerCreditRefundStatus_Approved:"b0f4343b-ac05-492a-91f7-2e41d5e9d197",ListPayerCreditRefundStatus_Rejected:"2049316f-4819-4d51-8d04-488b000b85bc",ListPayerCreditRefundStatus_Open:"5279aee2-ef6a-44e5-8a3c-a6a4a916db40",ListPayerCreditRefundStatus_Closed:"296b823d-78dc-4f60-a24d-e000e162e3cb",ScheduledAppointmentStatusUid:"17982339-1dfe-4d69-ac0e-8f3af4087255",CancelledAppointmentStatusUid:"9c52e394-e4b6-450c-aba2-87b2a75fdb13",NoShowAppointmentStatusUid:"e7be0240-f633-4271-9054-50f1b5c1e9d4",CheckedInAppointmentStatusUid:"cd2a0578-0c89-4151-b4e9-66ed9d5b4995",DischargedAppointmentStatusUid:"31886389-631f-4d03-bc28-b4db87e9b172",ReadyToDischageAppointmentStatusUid:"c8f3cd36-ff13-4088-8181-81ed9b14dbd1",AppointmentCallStatusConfirmed:"20af514b-517b-4419-88c9-6725b2469989",NeedToRescheduleAppointmentStatusUid:"923ed792-581d-4610-9f17-9fa915df97b2",DefaultAmountAllowedScheduleUid:"00000000-0000-0000-0fee-000000000001",UserDefinedGroupType:"10101010-0000-0000-0000-000000000099",AttachmentType_Dictation:"00000000-0000-0000-8888-000000000004",AttachmentType_CCDCDataExchangExport:"82e352da-9dea-48ff-9ee6-108aff424bb5",ReportAppointment:"9e8a3f49-d368-48dc-a65f-dbd3d96ed4b9",ReportBalanceAndCloseCharges:"ee20411b-a90f-4327-b145-7a358b332bae",ReportBalanceAndCloseTransactions:"a1eb2c50-66eb-4e28-8a22-073e000a9fa7",ReportCapitation:"729b0f35-d190-458e-ae64-91edd24b1d6e",ReportCMS1500:"7e372962-6870-41d2-9162-76d0e643fea1",ReportCMS1500NPI:"58ea30f7-d52f-4aee-92cd-3701204d763b",ReportCMS1500NPI5010:"09676db6-dfb9-4d9a-a204-f0c7465231f4",ReportCollectionsInsurance:"38373452-9546-46fb-901f-d5e4d7be8703",ReportCollectionsPatient:"ece75489-f96e-4a5c-b6d1-cd1d8840dadc",ReportDepositSlip:"eb6ae34c-af06-4cdc-ac77-a1151ee4848b",ReportHL7LabReport:"a26cda78-dd9f-4253-b4cc-e26e227877cf",ReportInsuranceAging:"4e5703f5-6389-4981-ad1e-d152d8025045",ReportNoSB_Encounters:"9b35b7d0-d8a6-46be-94bc-711550e7a6fc",ReportPatientLedger:"c7aa9366-ba87-41bf-8895-9cfd6a1a9968",ReportPracticeFinancials:"5d890d9f-c967-4f95-b280-8ed488dcf853",ReportPrescription:"f8eaa510-83c6-4575-a124-ed5ddecc1b76",ReportProcedureProductivity:"70d9290a-2265-4059-a1b8-071b353f4327",ReportStatementBatch:"53bebc35-28b7-4ef9-b479-21e0ff8d1767",ReportStatementDetails:"ab980a4e-d02d-402c-b88b-16cfc14e54d8",ReportStatementBatchMainAccount:"9b3ecd3c-e695-43b0-a5d7-e4524dc33b4a",ReportStatementDetailsMainAccount:"ab08221b-61bf-4f7d-9554-d0a84deecd67",ReportTotalAR:"9d6625bf-4f6b-4944-a402-8d1c5083789d",ReportVisitsWithoutSBs:"f8414e3f-9aa2-42c7-a4f2-0cd060e30bb5",ReportMedicationTimeFlow:"e8fcf679-a654-4b12-85ad-fb7e107ad377",ReportSuperbill:"bb768412-3b62-425b-9e70-4becc6783702",ReportERA:"92256504-356b-41ae-b68d-84076d3d2e2c",ReportStatementBatchByFinancialCenter:"aa491038-ac02-458d-b5d9-682e229b3e8c",ReportStatementDetailsByFinancialCenter:"a77ef1c5-f9ec-4597-9646-b96b8fc0054b",ReportStatementBatchMainAccountByFinancialCenter:"cd3c82a1-ae62-49c0-8587-6f859029fa2b",ReportStatementDetailsMainAccountByFinancialCenter:"e57f4dce-a24d-470c-b163-42060726cf91",ReportPrintAttachmentText:"a363aed0-4a54-4576-b79e-d8fc90bc52fe",ReportPrintAttachmentImage:"d541d42f-b4a2-4dba-be41-52ddbec8facf",ReportPrintAttachmentNoNote:"f5777afe-de62-4959-a3b1-08779dac8341",ReportPrintAttachmentImageOnly:"363e08f6-ad10-4b07-827e-097d13af5537",ReportGroupVisitRosterSignInSheet:"75ee272a-0890-40c4-944c-3e865ecd0042",ReportPatientRecordDisclosure:"f7b11729-c421-4b92-b177-343018f4a81a",ReportCDSReminders:"b9ba795f-71fa-4e33-a9dd-40f09819388b",ReportCallpointeMU:"6cdf8b90-0071-49a8-a534-64134f00599c",ReportPrintAttachmentTIF:"1f505b4d-9b89-44c2-8924-c09133fc7a15",ReportMedicationReviewForm:"900377c9-d12c-4f73-b5f0-429ff928def8",AppointmentChargeTicket:"d8b62581-8cc1-4d09-b078-6372e9cfdaf0",ListFindTable_Reports:"6c57e4a8-1314-4e42-9100-24534d01b887",ListFindTable_DiagnosisCode10:"48ac27ee-cb5a-4be6-b43c-d98534fb484e",ReportRefundCheck:"69305c0d-881f-4b24-bbe6-4dbdc6af8523",ReportRefundCheckRegister:"e85955b5-b04f-4e1d-9668-3e8d8154f69e",ReportUB04:"4ee0fb9c-41cc-4da9-964c-ddbb588c7a72",ReportCMSR131L:"b7c160c6-dbc9-4380-a2c2-c18a9f0dbec2",ReportResponsiblePartyAccountPage:"90c232e9-7941-4629-bb86-a0be2a1325d4",Vital_BMI:"00000000-0000-0000-7777-100000000007",Vital_Temperature:"00000000-0000-0000-7777-100000000008",Vital_Temperature_Method:"00000000-0000-0000-7777-100000000009",Vital_RR:"00000000-0000-0000-7777-100000000010",Vital_RR_Condition:"00000000-0000-0000-7777-100000000011",Vital_SpO2:"00000000-0000-0000-7777-100000000012",Vital_SpO2_Condition:"00000000-0000-0000-7777-100000000013",Vital_SpO2_Method:"00000000-0000-0000-7777-100000000014",Vital_Comment:"00000000-0000-0000-7777-100000000015",Vital_Metric_Head_Circ:"00000000-0000-0000-7777-100000000069",Vital_HR_Method:"00000000-0000-0000-7777-100000000016",Vital_HR_Value_Sitting:"00000000-0000-0000-7777-100000000017",Vital_HR_Value_Standing:"00000000-0000-0000-7777-100000000018",Vital_HR_Value_Supine:"00000000-0000-0000-7777-100000000019",Vital_HR_Location_Sitting:"00000000-0000-0000-7777-100000000020",Vital_HR_Location_Standing:"00000000-0000-0000-7777-100000000021",Vital_HR_Location_Supine:"00000000-0000-0000-7777-100000000022",Vital_HR_Regularity_Sitting:"00000000-0000-0000-7777-100000000023",Vital_HR_Regularity_Standing:"00000000-0000-0000-7777-100000000024",Vital_HR_Regularity_Supine:"00000000-0000-0000-7777-100000000025",Vital_BP_Location_1:"00000000-0000-0000-7777-100000000051",Vital_BP_Position_1:"00000000-0000-0000-7777-100000000052",Vital_BP_Sys_1:"00000000-0000-0000-7777-100000000053",Vital_BP_Dias_1:"00000000-0000-0000-7777-100000000054",Vital_BP_Location_2:"00000000-0000-0000-7777-100000000055",Vital_BP_Position_2:"00000000-0000-0000-7777-100000000056",Vital_BP_Sys_2:"00000000-0000-0000-7777-100000000057",Vital_BP_Dias_2:"00000000-0000-0000-7777-100000000058",Vital_BP_Location_3:"00000000-0000-0000-7777-100000000059",Vital_BP_Position_3:"00000000-0000-0000-7777-100000000060",Vital_BP_Sys_3:"00000000-0000-0000-7777-100000000061",Vital_BP_Dias_3:"00000000-0000-0000-7777-100000000062",Vital_BP_Location_4:"00000000-0000-0000-7777-100000000063",Vital_BP_Position_4:"00000000-0000-0000-7777-100000000064",Vital_BP_Sys_4:"00000000-0000-0000-7777-100000000065",Vital_BP_Dias_4:"00000000-0000-0000-7777-100000000066",Vital_BP_Location_NotSelected:"00000000-0000-0000-7777-000000000101",Vital_BP_Location_LeftArm:"00000000-0000-0000-7777-000000000102",Vital_BP_Location_RightArm:"00000000-0000-0000-7777-000000000103",Vital_BP_Location_LeftLeg:"00000000-0000-0000-7777-000000000104",Vital_BP_Location_RightLeg:"00000000-0000-0000-7777-000000000105",Vital_BP_Position_NotSelected:"00000000-0000-0000-7777-000000000106",Vital_BP_Position_Sitting:"00000000-0000-0000-7777-000000000107",Vital_BP_Position_Standing:"00000000-0000-0000-7777-000000000108",Vital_BP_Position_Supine:"00000000-0000-0000-7777-000000000109",Vital_Heart_Rate_1:"00000000-0000-0000-7777-100000000017",Vital_Heart_Rate_2:"00000000-0000-0000-7777-100000000018",Vital_Heart_Rate_3:"00000000-0000-0000-7777-100000000019",Vital_Position_Sitting:"00000000-0000-0000-7777-000000000107",Vital_Position_Standing:"00000000-0000-0000-7777-000000000108",Vital_Position_Supine:"00000000-0000-0000-7777-000000000109",Vital_Weight_Dress_NotSelected:"00000000-0000-0000-7777-000000000001",Vital_Weight_Dress_Clothed:"00000000-0000-0000-7777-000000000002",Vital_Weight_Dress_Unclothed:"00000000-0000-0000-7777-000000000003",Vital_Respiratory_Rate_NotSelected:"00000000-0000-0000-7777-000000000021",Vital_Respiratory_Rate_Quiet:"00000000-0000-0000-7777-000000000022",Vital_Respiratory_Rate_Sleeping:"00000000-0000-0000-7777-000000000023",Vital_Respiratory_Rate_Crying:"00000000-0000-0000-7777-000000000024",Vital_Heart_Regularity_Regular:"00000000-0000-0000-7777-000000000081",Vital_Heart_Regularity_Irregular:"00000000-0000-0000-7777-000000000082",Vital_Heart_Regularity_RegularRegular:"00000000-0000-0000-7777-000000000083",Vital_Heart_Regularity_RegularIrregular:"00000000-0000-0000-7777-000000000084",Vital_Heart_Regularity_IrregularRegular:"00000000-0000-0000-7777-000000000085",Vital_Heart_Regularity_IrregularIrregular:"00000000-0000-0000-7777-000000000086",Vital_MetricWeight:"00000000-0000-0000-7777-100000000070",Vital_MetricHeight:"00000000-0000-0000-7777-100000000071",Vital_MetricTemp:"00000000-0000-0000-7777-100000000072",Vital_ImperialTemp:"00000000-0000-0000-7777-100000000077",Vital_BloodPressureMethod:"00000000-0000-0000-7777-100000000026",Vital_MetricBloodPressure1:"00000000-0000-0000-7777-100000000073",Vital_MetricBloodPressure2:"00000000-0000-0000-7777-100000000074",Vital_MetricBloodPressure3:"00000000-0000-0000-7777-100000000075",Vital_MetricBloodPressure4:"00000000-0000-0000-7777-100000000076",Vital_HeadCircumference:"00000000-0000-0000-7777-100000000006",Vital_WaistMeasure:"2a11dc70-be5f-40aa-a34a-caef718d0513",ListSignatureSource_Medical_Records_Release:"42de70f4-9f0f-4a08-b446-e1e5027e7e00",ListSuperbillStatus_AprimaVaultDataConversionComplete:"0e755dd2-6a40-47b4-a60c-d06257ee58e0",ListSuperbillStatus_Cancelled:"fc8ad61b-139a-4cfa-9580-cdacfc3acf90",ListSuperbillStatus_Complete:"30f64d66-55cb-4438-bb2f-7a6250399312",ListSuperbillStatus_Filed:"9ffe6214-7c7f-4516-9899-43d37fabe21d",ListSuperbillStatus_Hold:"5d149ced-a42f-4a23-a236-f1c9c48ee8b1",ListSuperbillStatus_Insurance_Action:"b4d6b17e-a8a1-425d-95d3-5d29b465d682",ListSuperbillStatus_Account_Change_Alert:"b42f00ab-32ea-4d81-81e9-b4ad186fac4f",ListSuperbillStatus_Overpaid:"43c2c635-184b-4e5e-a893-d2030bde7df3",ListSuperbillStatus_Pending_Patient_Payment:"d2bf0f3c-6e03-478f-bdae-4dcac5eb9410",ListSuperbillStatus_Preliminary:"df81be7c-71cf-47f4-8573-733e81e30ea8",ListSuperbillStatus_Queued:"0b42c4c4-6d7e-41f2-9d08-b28f17404e79",ListSuperbillStatus_Ready_to_Review:"d2291c14-3f4e-4381-80a7-883c76c9499b",ListSuperbillStatus_Ready_to_Submit:"55ed3239-89f3-4488-89c9-71be5a541cc4",ListSuperbillStatus_Rejected:"2c4a6e7d-eb6d-4370-a836-5937363c6b69",ListSuperbillStatus_Succeeded:"d2341cba-6f5c-47d9-95a5-16d5680565c3",ListSuperbillStatus_Failed_Validation:"695681c6-f9b3-45f6-a8fe-5fa3b1d07469",ListSuperbillStatus_Passed_CodeValidation:"96d656a3-fea4-4aa4-9cc4-e39640ab5808",ListSuperbillStatus_ERA_Claim_Rejected:"2352f0fb-708b-437e-9809-f80128195f9e",ListSuperbillStatus_Queued_Rejected:"8bca307f-e59f-42f2-925b-b1c102a985f9",ListSuperbillStatus_Batched:"3796674a-6a9e-45b3-abf3-0c3b606159dd",ListSuperbillStatus_Batching:"55f1c3f2-2384-4d54-a9e5-fb60ddb28f76",PatientHistory_AnchorQuestion_Immunization:"00000000-0000-0000-0000-000000111201",PatientHistory_AnchorQuestion_Menstrual:"ffffffff-0000-0000-0000-000000000001",PatientHistory_AnchorQuestion_Pregnancy:"078dc26e-5ac4-4901-a7b9-cf310b9610eb",HistoryGroupMedicalHistory:"00000000-0000-0000-0000-000000000101",HistoryGroupInfectionHistory:"00000000-0000-0000-0000-000000000102",HistoryGroupSurgicalHistory:"00000000-0000-0000-0000-000000000103",HistoryGroupFamilyHistory:"00000000-0000-0000-0000-000000000104",HistoryGroupGeneticScreening:"00000000-0000-0000-0000-000000000105",HistoryGroupSocialHistory:"00000000-0000-0000-0000-000000000106",HistoryGroupMedicationHistory:"00000000-0000-0000-0000-000000000107",HistoryGroupFoodAllergy:"00000000-0000-0000-0000-000000000108",HistoryGroupDrugAllergy:"00000000-0000-0000-0000-000000000109",HistoryGroupEnvironmentAllergy:"00000000-0000-0000-0000-000000000110",HistoryGroupImmunizationHistory:"00000000-0000-0000-0000-000000000111",HistoryGroupSpecialtyHistory:"00000000-0000-0000-0000-000000000112",HistoryGroupMenstrualHistory:"00000000-0000-0000-0000-000000000114",HistoryGroupPregnancyHistory:"00000000-0000-0000-0000-000000000115",HistoryGroupFlowsheet:"00000000-0000-0000-0000-000000000011",HistoryGroupObservationHistory:"00000000-0000-0000-0000-000000000116",HistoryGroupProblemDiagnosis:"0238a133-904e-4e49-bdba-4eb3cb3b39a7",HistoryGroupAddressHistory:"49283214-0137-45ed-893e-19fb6b688ebb",HistoryGroupNewFamilyHistory:"a3faf896-b328-4364-9621-012f8c6643bb",HistoryGroupDSMIV:"167473e6-7f98-4840-870b-a5a5313b022e",HistoryGroupCognitiveAssessment:"00000000-0000-0000-0000-000000000120",HistoryGroupFunctionalAssessment:"00000000-0000-0000-0000-000000000121",HistoryGroupProcedureHistory:"fa2b8214-a2ef-419d-8ef4-ce42ac4e8191",HistoryGroup_Immunization_Question_Vaccine:"00000000-0000-0000-0000-000000111201",HistoryGroup_Immunization_Question_TypeofVaccine:"00000000-0000-0000-0000-000000111202",HistoryGroup_Immunization_Question_DateGiven:"00000000-0000-0000-0000-000000111203",HistoryGroup_Immunization_Question_Route:"00000000-0000-0000-0000-000000111204",HistoryGroup_Immunization_Question_SiteGiven:"00000000-0000-0000-0000-000000111205",HistoryGroup_Immunization_Question_LotNum:"00000000-0000-0000-0000-000000111206",HistoryGroup_Immunization_Question_Manufacture:"00000000-0000-0000-0000-000000111207",HistoryGroup_Immunization_Question_ExpDate:"00000000-0000-0000-0000-000000111208",HistoryGroup_Immunization_Question_VISDate:"00000000-0000-0000-0000-000000111209",HistoryGroup_Immunization_Question_VISGivenDate:"00000000-0000-0000-0000-000000111210",HistoryGroup_Immunization_Question_Initial:"00000000-0000-0000-0000-000000111211",HistoryGroup_Immunization_Question_Notes:"00000000-0000-0000-0000-000000111212",HistoryGroup_Immunization_Question_FundingSource:"1d524fe4-8ac3-43f8-bd00-c08cec100ffa",HistoryGroup_Immunization_Answer_Date:"00000000-0000-0000-0000-000000000171",HistoryGroup_Immunization_Answer_Text:"00000000-0000-0000-0000-000000000288",HistoryGroup_Immunization_VaccineFunding_AnswerGroup:"a33cdd2b-67e3-4cc1-afd0-76a3e3d0fc0f",HistoryGroup_Immunization_FamilyImmunizationSection:"417ed290-1967-4f05-be18-1242b37d3f75",VaccineRoute_PO:"47c0dd4e-cfa1-4a72-b623-0ad9d501fa81",VaccineRoute_NS:"c6e14630-95c2-4c47-ad37-4abbf79a9ed5",VaccineRoute_OTH:"0ee77772-27ed-4b40-98ef-c4f1e3a4caec",HistoryGroup_ANSWERGOUP_TIMEFRAME:"00000000-0000-0000-0000-000000101000",HistoryGroup_ANSWERGOUP_FAMILY_DISEASE:"00000000-0000-0000-0000-000000104000",HistoryGroup_ANSWERGOUP_REACTION:"00000000-0000-0000-0000-000000108000",HistoryGroup_MedicationHistory_PatientTakesNoMeds:"a9a4e0a0-443a-4734-8e3f-592abea0061b",SocialHistory_TobaccoHistory:"00000000-0000-0000-0000-000000000008",SocialHistory_TobaccoHistory_NeverSmoked:"00000000-0000-0000-0000-000000000047",SocialHistory_TobaccoHistory_QuitSmoking5:"00000000-0000-0000-0000-000000000051",SocialHistory_TobaccoHistory_QuitSmoking10:"00000000-0000-0000-0000-000000000052",SocialHistory_TobaccoHistory_QuitSmoking10Plus:"00000000-0000-0000-0000-000000000053",SocialHistory_TobaccoHistory_CurrentlySmokeless:"83569607-629e-4f31-a10b-af2a34326e1e",SocialHistory_TobaccoHistory_CurrentlySmokes:"00000000-0000-0000-0000-000000000048",SocialHistory_TobaccoHistory_EverydaySmoker:"292f21b1-9ca3-4ace-b5cd-fe73bf1b3a31",SocialHistory_TobaccoHistory_SomeDaySmoker:"809d9f30-5e2c-4552-a7a9-a70e2eeb6031",SocialHistory_TobaccoHistory_Smoker_StatusUnknown:"13d7e47e-1634-48cc-bb0c-5bf5675ca044",SocialHistory_TobaccoHistory_HeavySmoker:"f82a9884-3a7b-477e-a3cd-a30ab7afed42",SocialHistory_TobaccoHistory_LightSmoker:"30daa871-dd29-44a1-a830-04150363421f",PatientCommunicationType_SmokingCessation:"8e30897b-39ac-456a-b8db-5f670b1ae009",PatientCommunicationType_PhysicalActivity:"8b0798af-346d-4de5-abb9-2c29d59b8325",PatientCommunicationType_Nutrition:"84b0c475-ef42-4988-b00a-d0b1d6e352fe",PatientCommunicationType_Underweight:"84b0c475-ef42-4988-b00a-d0b1d6e35200",PatientCommunicationType_Overweight:"84b0c475-ef42-4988-b00a-d0b1d6e35201",OBCaseTypeUid:"5bdc8794-20cb-4253-96af-0907e73b9185",Disease_Pregnancy:"00000000-0000-0000-0000-000000101101",CaseTypeOBFlowsheet:"34157ce8-e296-4fdc-a060-e34de957022c",CaseTypeOBEDD:"4b29d2ed-4983-4f4a-b16f-070659f6ac30",eRxMessageType_new_rx:"9f19ed8c-3524-46ea-9f4b-b932d38f8585",eRxMessageType_refill_request:"443d1a55-7384-495b-9bdf-15debd9379e2",eRxMessageType_refill_response:"5151d647-729f-40f1-afe3-f0cdf31f12a7",eRxMessageType_error_script:"fbfe211c-18ba-4ddd-a5e2-817933847588",eRxMessageType_status:"06d3f14d-3da4-4404-a45f-1b3294b487ed",eRxMessageType_verify:"4cd98089-2475-4f86-a904-f0086cfc0b0b",eRxMessageType_eligibity:"6b18c334-e4a6-4f82-a831-1aaa6cf6009e",eRxMessageType_eligibility_response:"5506f18b-084c-489f-8891-89c76fb3dfab",eRxMessageType_rx_history_request:"90db44ee-adea-427c-9450-b418f8577ade",eRxMessageType_rx_history_response:"1a36a4a2-4b4f-4e49-8dc8-b6f13439fde3",eRxMessageType_rx_cancel_request:"c0bd8e17-1fcf-44b2-a1e8-99bb840e5591",eRxMessageType_rx_cancel_response:"f59bdcb7-8df9-4468-bbba-544415db133e",eRxMessageType_rx_change_request:"2c259b74-444f-4f29-9634-5768dda9e572",eRxMessageType_rx_change_response:"1c03a342-4fde-4dde-99cf-28bae7d1fa1a",eRxMessageType_rx_formularyupdate:"4a412563-f3de-43f2-907e-3e6df8b20e90",eRxMessageType_rx_formularylist:"e76dcef2-7b7e-4640-b750-ea28768ebd2b",eRxMessageType_rx_eprescribingactivityreportupdate:"eff314ca-668b-4823-b206-366921a0d243",eRxMessageType_pharmacy_update:"0ffde3e6-a37b-4885-a142-4430c7526fc3",eRxMessageType_pharmacy_list:"a68df433-597d-4e7c-800a-beb65397ff04",eRxMessageType_prescriber_update:"c0c8c0de-96f3-4efe-8db0-125d0b6dbe4f",eRxMessageType_prescriber_list:"f60e147c-81b2-4562-af18-a69e25ca2185",eRxMessageType_inboundmessageroutingregistration:"ce675e1b-3b82-4ec3-8d7b-3b1a027e42b4",eRxMessageType_inbound:"d375fb2c-454f-4175-a253-6a382028fb0a",eRxMessageType_providerdirectory:"be1a51c4-fa09-49fc-8c10-6e7f6f878b07",eRxMessageType_formulary_download:"a54ec9c9-ae68-4381-81fe-14cbff113e4e",eRxMessageType_pharmacy_download:"93af01dc-c3a9-49d2-afb8-df6adb39d745",eRxMessageType_prescriber_download:"b0484716-ea09-4eb3-ba50-cbd352d4351f",eRxSentSuccessfulStatusUid:"b1f7efaf-d56d-4bad-ae1f-8205e1d00b58",eRxQueueForTransmissionStatusUid:"0605b6f6-2fe4-49cb-b868-9df448ab3e01",eRxQueueForRxRefillAcceptUid:"e2427516-e347-4586-af42-8c9a32872a78",eRxControlledDrugStatusUid:"1a2ca5ed-297d-4973-858e-a79180565591",eRxControlledDrugRequiresSignatureUid:"e8b201fe-5540-4f47-bf0b-197331d054f3",eRxUserDefinedDrugStatusUid:"c5c9af90-92f8-479f-81d5-6a327d19cd1d",eRxUnknownDrugClassStatusUid:"e6378e41-2b44-4c76-923d-99994f749c1b",eRxNoMailOrderBenefitUid:"369e0bf1-b361-4d27-9e6a-752f2b8c37a1",eRxFailedValidationStatusUid:"86250938-b4de-4c85-9e12-5e132086b305",eRxSentFailureStatusUid:"5f659708-d32c-4a81-af49-860883626304",eRxProcessingErrorStatusUid:"5196d31c-360d-4eac-a294-05245a927f8c",eRxProviderMappingErrorStatusUid:"aa16051b-fdc9-4cf5-b1eb-32135baec80d",eRxPatientMappingErrorStatusUid:"c008a24b-37fd-44f8-b29b-70d141aaee72",eRxDownloadInProgressStatusUid:"09cdf8fb-8678-4084-805e-35d81e35534b",eRxNoMedicationHistoryToDownloadStatusUid:"bb189f74-f733-4552-a036-c305a33a69ba",eRxDownloadCompletedWithErrorStatusUid:"378e7d05-06e5-41be-bd41-d1be5b6716f3",eRxDownloadCompletedSuccessfulStatusUid:"c20ca48a-f961-40f7-8eb6-e6f0ecbd1ef5",eRxDownloadWaitForRXBenefitsResponsStatusUid:"4769f67c-c4ba-4e77-8fcc-82a967e4c887",JobScheduler:"10101010-0000-0000-0000-000000000101",JobScheduledReports:"10101010-0000-0000-0000-000000000301",JobScheduledERxMonitor:"fbc47409-4dda-4457-bd3e-2c2666b45d98",JobERAMessageProcessor:"0b5d9460-b33d-4968-a435-d5287c598c6b",JobApplyERARules:"dca52c7c-4d0b-4445-bf23-99a25ffe9719",JobEligibility:"3dca8049-8df5-4b4f-a10f-fe6f54c0abad",JobTimeIntervalSeconds:"10101010-0000-0000-0000-000000000201",JobTimeIntervalMinutes:"10101010-0000-0000-0000-000000000202",JobTimeIntervalHourly:"10101010-0000-0000-0000-000000000203",JobTimeIntervalDaily:"10101010-0000-0000-0000-000000000204",JobTimeIntervalWeekly:"10101010-0000-0000-0000-000000000205",JobTimeIntervalMonthly:"10101010-0000-0000-0000-000000000206",JobTimeIntervalRunOnce:"10101010-0000-0000-0000-000000000207",ListTimespanToday:"f2e52f89-7f2c-466a-a878-459f82fa12c9",ListTimespanLast2Weeks:"125f81d9-9055-4020-8927-9ec814b6c05d",ListTimespanLast30Days:"95e07b97-aeab-46de-94ee-2674e419307b",ListTimespanCustomDates:"b657552d-872a-4e05-b76a-298754f56ecd",ListTimespanCurrentWeek:"43570f5f-909d-4a76-9b9f-a0f293733fd6",ListTimespanCurrentMonth:"b35a144b-b91e-4207-8e26-f7c9fcd06645",ListTimespanCurrentQuarter:"87212cb8-01b5-4e49-b206-a94111b7874a",ListTimespanCurrentYear:"3863338d-160f-45d8-81c7-62738f3114d0",ListTimespanLast2WeeksFromSunday:"b3b927bf-fee9-4c44-bd0a-3e9587d34f69",ListTimespanLast60Days:"11e8ceb9-308d-4fcb-9315-21c4f74214a7",ListTimespanLast90Days:"4f614170-b9aa-4f08-a86e-25b509ed0c3e",ListTimespanLast365Days:"c90f9c3e-6a8e-4e2a-8afe-829094df0366",ClaimFormatElectronic837:"0baf0b1a-48e6-403a-8981-2b58618dfc07",ClaimFormatElectronic837I:"8d4cce55-2211-4ecf-8b01-f996cb5a0cfc",UPINClaimFormatValueTypeUid:"be3aae71-5565-4edc-a166-3d7b688548b9",DEAClaimFormatValueTypeUid:"018e7542-5de7-405e-9f4a-ee4bffde68d4",NPIClaimFormatValueTypeUid:"ce282f4e-a866-49ba-9636-c4ba0439e907",SPIClaimFormatValueTypeUid:"87197e82-1f35-467a-ba37-0d8cf3de04d5",CTPClaimFormatValueTypeUid:"a337b06f-b4e2-4e8b-a439-faa973de3ca5",MedicalLicenseNumberClaimFormatValueTypeUid:"2e7c5879-b7dc-4c2f-9e1c-ad157c561c3b",StateLicenseNumberClaimFormatValueTypeUid:"37b7ea5e-1e98-46c0-916b-766ab518e99e",SSNClaimFormatValueTypeUid:"897ff8b5-5c4f-4289-83eb-d75cdbedc510",MedicareProviderIDClaimFormatValueTypeUid:"b339708b-7b70-432d-8452-f2e199b46a01",MedicaidProviderIDClaimFormatValueTypeUid:"33d096f9-ce6d-415a-bf57-9d2aaa5d2b2e",PriorAuthorizationClaimFormatValueTypeUid:"e8654441-940f-4d57-a0ee-f36d13c860b2",FileIDClaimFormatValueTypeUid:"a197989d-4200-4ea6-9e6e-7e3ab6f5f462",PPONumberClaimFormatValueTypeUid:"783c246f-b633-4d8a-9cfc-7cd02bf4293c",PayerIdentificationNumberClaimFormatValueTypeUid:"1a84232e-dcfd-43bf-8352-0afd0af79f47",RxHubParticipantIDClaimFormatValueTypeUid:"4fec0a5f-2412-4408-97ad-d0ea3ad512b8",SurescriptsStateLicenseNumberClaimFormatValueTypeUid:"846b9878-70d2-4daf-af6d-451f416f67ea",ProcedureClaimFormatValueTypeUid:"024c64d6-9f63-471b-891f-2e777515668d",ClaimFormatValueTypeTypeFilingTypeGroupIndividual:"4bbec2af-efee-49e5-8a55-96f837146061",ClaimFormatValueTypeTypeClaimValueFormat:"205448ce-1aba-4273-b7bd-b4017e789d0c",ClaimFormatValueTypeTypeCodeBasedClaimValueFormat:"d64d9c6e-ad54-4f27-b5bf-4fb8bbd84412",ClaimFormatValueTypeTypePaperBillingAsRef:"5f392cc6-ecc7-45be-9e4c-598ed4b36f8b",LabUse_BillingProvider:"83a25a0d-bd39-42ed-8324-12670f1d17c6",ClaimFormatValueTypeTypeLabUseBillingProvider:"aa380c38-3091-44ff-9675-bf8ba2088c7e",ClaimFormatOptionType2310A:"fff19d24-8250-4355-9b4b-60333eaef3e4",ClaimFormatOptionTypeEPSDT:"fe1d5047-6059-4051-b041-08c33031bb9f",ClaimFormatValueTypeTypeProcedureOverrideFormatValue:"ae114249-40bc-49dd-a0e6-702fe4b7aab1",ClaimFormatValueTypeTypeTypeOfBillOverrideFormatValue:"cf54a488-7a3c-473f-8cb7-8fc255899d9f",ClaimFormatValueTypeTypeBox29Type:"81fe128f-2c86-42e6-83e1-f44a3edeebaf",MiscPracticeUid:"39035923-68fd-4276-8616-b027919d7840",MiscProviderUid:"2cc009f6-7e06-4197-9b7c-9bb7893f9669",MiscServiceSiteUid:"3eea5d17-2d86-4eaf-ab26-cb9016e175b8",MiscFinancialCenterUid:"284a3ec8-a39a-4178-aade-e20c6829708b",MiscMedicalServicesProviderUid:"4f49b11d-ced0-4e8d-9439-9113eac60b47",MiscProcedureOwnerUid:"ebff0a0d-3a79-4e50-b15d-71a998a7e6e0",AttachmentTypePatientIndication:"8f6c46b0-f17b-41ad-8215-3fb3d116a9bb",AttachmentTypeScheduledReport:"10101011-0000-0000-0000-000000000100",AttachmentTypeDeposit:"78d03a12-29a8-46a2-8a72-0a31efeee2db",AttachmentTypeGeneratedDocument:"afecb3ab-f316-41b7-884a-94d441103b9a",AttachmentTypeAdvancedDirective:"10101011-0000-0000-0000-000000000101",AttachmentTypeExternalPatient:"7ef83ec9-cbde-4074-b9fd-bca3e6aac463",AttachmentTypeLabResults:"af6e749e-fbd9-40c8-98f4-09d1d0a5e04e",AttachmentTypeAssessmentForms:"10101011-0000-0000-0000-000000000102",AttachmentTypeScannedChart:"39981fac-3c26-45a8-b3ee-ea754692d17a",AttachmentTypeDirectMail:"91293e86-6aa1-4b30-aa00-7ddd42135d64",AttachmentTypeCareManagement:"6ff4a1f0-d9b3-4283-b109-ba492b172c86",AttachmentTypeStatement:"3bd598e3-1b14-4b4d-9a0c-49fd31a32edb",FinancialCenterDataSecurityUid:"efa3bef1-b522-4e9a-ae74-4645851cfbf6",BatchSecurityUid:"2bbd5b04-9549-4ef2-b321-489fa93a2324",BatchOwnerDataSecurityUid:"6dc8e244-75b4-43a0-9eae-6ee2c7b372cc",BatchProcessTypeSecurityUid:"bfb6c86d-ec0e-435a-a10e-ee8f1f75bf5d",ClaimClearingHousePracticeInsightUid:"b58b4c69-907d-4ab1-9945-0e4cd53df510",PharmacyClearinghouseMedAvantUid:"371decbd-66d4-4c4f-8dbd-110c00098169",PharmacyClearinghouseSureScriptsUid:"118422aa-c165-4a2e-8389-e5b7e89636ea",PharmacyClearinghouseFaxUid:"e5a59c09-a77d-4c08-953d-d92ce1b1135c",eRxWSSureScripts:"118422aa-c165-4a2e-8389-e5b7e89636ea",eRxWSJobSendMessages:"2438b6b4-6d85-4f8f-91ce-7b26b094e353",eRxWSJobPharmacyDirectoryDownloadNightly:"d2c7de64-1463-4b04-ac6e-0c2cd67bc781",eRxWSJobMonitor:"923d2ab4-f0df-47e8-b0c3-42c5f0887554",eRxWSJobPharmacyDirectoryDownloadFull:"902cb485-3f44-467d-877a-81c2269eb477",eRxWSJobFormularyDirectoryDownload:"cc2aa760-702e-45f6-abe9-12ce88521744",eRxWSJobProcessFormularyDirectory:"f3bcc7fa-ae86-4954-8097-f637a6a0315c",eRxWSJobePrescribingActivityReportUpload:"6a887b40-3446-4c61-a570-10c01a2bcdf5",eRxWSJobGenerateePrescribingActivityReport:"20fe8b8f-5dce-4701-9fc4-5fbc4d4ba858",eRxWSJobPRVBRD:"fd66ccc4-10ec-44e6-b4ed-8cef32d1f24b",eRxWSJobPrescriberDirectoryDownloadFull:"8c1bb635-7efe-4087-a5b4-667196f0565e",eRxWSJobPrescriberDirectoryDownloadNightly:"2a109586-c975-4eb0-a0c4-359ef7b58f0d",eRxWSJobProcess_FormularyAlternative:"dca8121e-06c2-4e0a-9aa4-02cd672691e1",eRxWSJobProcess_FormularyCopay:"ecb1c118-bafe-4b65-b6b3-397147bb4be6",eRxWSJobProcess_FormularyCoverage:"fb64ceec-908b-4410-95df-7a83b0a9db66",eRxWSJob_Process_FormularyStatus:"ca4762f2-4f23-469a-b9a9-0b5de63e2141",eRxWSMessageType_refill_request:"443d1a55-7384-495b-9bdf-15debd9379e2",eRxWSMessageType_pharmacy_update:"0ffde3e6-a37b-4885-a142-4430c7526fc3",eRxWSMessageType_provider_update:"83e4ce75-831d-42ff-a8be-5c192a358bba",eRxWSMessageType_error_prvbrd:"eccf1422-6127-4dd5-9897-44585f612c84",eRxWSMessageType_error_script:"fbfe211c-18ba-4ddd-a5e2-817933847588",eRxWSMessageType_new_rx:"9f19ed8c-3524-46ea-9f4b-b932d38f8585",eRxWSMessageType_pharmacy_list:"a68df433-597d-4e7c-800a-beb65397ff04",eRxWSMessageType_provider_list:"69f6dff1-210e-4258-b246-b50556ff2e0a",eRxWSMessageType_refill_response:"5151d647-729f-40f1-afe3-f0cdf31f12a7",eRxWSMessageType_Download_Pharmacy_File_Nightly:"9629d151-c4ba-4882-8ed8-6ec143827c30",eRxWSMessageType_Download_Pharmacy_File_Full:"3f6c999f-dc86-472d-9f0c-5c0d90675a58",eRxWSMessageType_Process_Pharmacy_File_Nightly:"25c70185-07db-47c2-b567-b16de01c2655",eRxWSMessageType_Process_Pharmacy_File_Full:"ed7c8aab-0bb8-4cee-b6d5-23fba39fe3d9",eRxWSMessageType_formulary_file_list:"68f79b7e-6d5b-4574-ac4f-17c9f8077cf8",eRxWSMessageType_ePrescribingActivityReport:"2e84582e-5947-4a5a-8ec8-c000853796d0",eRxWSMessageType_Download_FormularyAlternative:"1543e471-f8d1-4fc2-adb8-15db5958fed3",eRxWSMessageType_Download_FormularyCopay:"dd3851b6-9a93-4b06-b6dc-378af8616475",eRxWSMessageType_Download_FormularyCoverage:"fb64ceec-908b-4410-95df-7a83b0a9db66",eRxWSMessageType_Download_FormularyStatus:"8230406d-7e9c-4a2f-948f-4142ac629fe2",MessageSecurityUid:"10101010-0000-0000-0000-100000000100",ListFindTable_Users:"ec4c281c-12b3-4ca7-8269-7171ad5d8f94",ListFindTable_UserSetting:"4dad8226-6097-4892-9d3f-fe5e1e346f42",Security_GeneralNoteTypeNotes:"387c1f8e-69aa-4144-85dd-fc7e922ec9c4",ListReferralTrackingStatusInitiated:"fc29eadd-fa10-4430-b6e5-7328f5b74c62",ListReferralTrackingStatusRelationship:"cac39e49-14e8-4045-bc1e-d051c33ae887",ListInstantMessageStatusBusy:"fefb6c5e-d476-432c-ba09-5009b38e5ccc",ListInstantMessageStatusHidden:"5004e771-4ffd-4095-9ed2-be38e690b70d",Relationship_Self:"7b4c63c7-fe13-48ef-81e5-3afc963f3fee",Relationship_Employee:"fda2b6c2-fb40-416b-bfc8-73118827f8f0",Relationship_Spouse:"9863d8b0-e698-4cea-8a3f-b4e1c7e6d094",Relationship_Significant:"9b1f93b8-7611-4702-85ad-9ee0b7b99e57",Relationship_Mother:"cc4a41ef-5881-4f77-8a8c-330ebe75556d",Relationship_Father:"111a79d8-3641-48dc-b47c-a8f8b374bf68",Relationship_Child:"719bed52-7ec2-4240-aa02-00d073fda8c7",Relationship_Unknown:"11eadee6-52dc-4fe1-bfd4-e1c03abaaa51",Relationship_OtherAdult:"bfe52efa-e4c2-4ec3-9f20-9637691fbe38",Relationship_GuardianUid:"96118232-da86-41a3-9e99-0a7dc9c3ae26",Relationship_CareGiverUid:"59aa0df9-3346-4e54-a3b1-3659d5cecaaa",PQRIGroupMedicare:"bf5e56e0-187f-427a-a7ad-2d5eebeb0b43",PQRIOperatorOR:"121dce7d-6aed-4974-b72e-0cb0aadacf5c",PQRIOperatorAND:"184449fa-bc7c-43c8-9e84-58fb3cdf9261",PQRIOperatorNOTOR:"93e9e5b7-e171-47b0-88b8-d9c22469b23d",PQRIOperatorNOTAND:"6e1d0d18-ad47-4970-81e1-6c0323821304",PQRICodeTypeICD9:"a057050d-e0c8-4727-a9e9-86fe9a05b5f9",PQRICodeTypeEM:"da5185e3-539e-4200-9e7a-7133115562d1",PQRICodeTypeCPT:"13bfb012-d2af-4d5c-b3a4-8d288992c696",PQRICodeTypeCPTII:"ca39b7a8-2b88-467a-8293-7e76b527e44e",PQRIMeasure125Adoption_e_Prescribing:"ff13c3e2-b72b-41b8-b483-ed8a41be3a2a",PQRIMeasure124Adoption_EMR:"ce2eb02f-9f13-43fe-913b-b9747f265f25",PQRIMeasure114TobaccoUse:"b4df7b7b-f0be-4791-b0e0-04e60b362eb0",PQRIMeasure115QuitSmoking:"14b51863-8ad7-460a-9db7-8cd576f740a0",PQRIMeasure116InappropriateAntibiotic:"0bd7ca31-3380-41e0-a9b1-2816fbf553d4",PQRIMeasure128BMI:"3263ff24-207b-4423-8adb-19cbfefae3a3",PQRIMeasure130CurrentMedication:"361c7e72-00e1-421a-83d4-38c8561ae42e",PQRIMeasure142Osteoarthritis:"be0a135a-91ff-46c1-b6b9-f450ba6e5cd6",PQRINumerator_130_NotDocumented_NotEligible_G8430:"445f3804-cc10-4653-a64e-5a544d07ef41",PQRINumerator_130_Documented_NotVerified_G8428:"9f9fbe2f-0907-4e49-9885-235b9a052811",PQRINumerator_130_NotDocumented_G8429:"1621c1f1-f77c-4a0b-a784-be9dc348259b",PQRINumerator_130_Documented_Verified_G8427:"7216fad4-218f-4042-adad-73ae0d21dd30",PQRINumerator_114_TobaccoUseNotAssessed_1000F_8P:"3d971193-17d6-4443-85de-894b1ef6b713",PQRINumerator_115_Smokeless_G8456:"1f26313b-d3fa-4add-a789-e77ec22d2346",PQRINumerator_115_NonSmoker_G8457:"17d1fc9e-82f8-4f80-b7de-a6b86ec7d1c1",PQRINumerator_128_BMI_Normal_G8420:"33db8be1-623b-40f1-be34-044b2514d75c",PQRINumerator_128_BMI_Overweight_G8417:"60c61fce-db9e-4549-882c-71c43eb6871f",PQRINumerator_128_BMI_Underweight_G8418:"a5aa8faa-ddb4-4079-af5d-4272cc38db79",PQRINumerator_128_BMI_NotEligible_G8422:"ff0e3c89-22aa-481f-830b-09bbcf7ecbad",PQRINumerator_128_BMI_NotPerformed_G8421:"51119e92-f3fd-4be2-9480-7623abd880d5",PQRINumerator_128_BMI_OverUnderWeight_NoEducation_G8419:"17cb9df2-88ca-4c48-8132-65083aabe660",PQRINumerator_142_OST_AntiInflam_Assessed_1007F:"2258d5fb-1505-43d2-9610-1970db8f2558",PQRINumerator_142_OST_AntiInflam_NotAssessed_1007F_8P:"617b87f3-9100-4989-885f-921541bdeffa",PQRINumerator_ERX_Incentive_G8553:"fc128494-7632-4b64-84f4-7dedae62d77d",DesktopControl_Calendar:"10101010-0000-0000-1000-000000000001",DesktopControl_Waitlist:"10101010-0000-0000-1000-000000000002",DesktopControl_Message:"10101010-0000-0000-1000-000000000003",DesktopControl_Note:"10101010-0000-0000-1000-000000000004",AddInType_Acquisition_Attachment:"10101010-0000-0000-1001-000000000001",AddInType_Acquisition_Vitals:"10101010-0000-0000-1001-000000000002",AddInType_PatientDemographics:"10101010-0000-0000-1001-000000000003",AddInType_FNC:"10101010-0000-0000-1001-000000000004",AddInType_Schedule:"10101010-0000-0000-1001-000000000005",AddInType_Messaging:"10101010-0000-0000-1001-000000000006",AddInType_PatientToolstrip:"10101010-0000-0000-1001-000000000007",AddInType_Desktop:"10101010-0000-0000-1001-000000000008",AddInType_CreditCardReader:"10101010-0000-0000-1001-000000000009",AddInType_FNC_Slider:"10101010-0000-0000-1001-000000000010",AddInType_FNC_SPSO:"10101010-0000-0000-1001-000000000011",AddInType_AppointmentTypeFilter:"10101010-0000-0000-1001-000000000012",AddInType_SuperbillChargeProcessor:"10101010-0000-0000-1001-000000000013",AddInType_Find:"10101010-0000-0000-1001-000000000014",AddInType_Find_Background:"10101010-0000-0000-1001-000000000015",AddInType_SaveProcessor:"10101010-0000-0000-1001-000000000016",AddInType_ServerObjectProcessor:"10101010-0000-0000-1001-000000000017",AddInType_BillingRule:"10101010-0000-0000-1001-000000000018",AddInType_CombinedServices:"10101010-0000-0000-1001-000000000019",AddInType_OrderObservation:"abeddd4f-b031-4a88-ae39-bfd56f74359c",Compression_Zip:"10101011-0000-0000-1001-000000000001",EraStatus_Error:"8b694843-f568-4097-b862-e4c63487881c",ERA_GroupCode_CO:"55ba9568-1c8a-4a6d-a919-f11ce4cc9be5",ERA_ReasonCode_45:"d16c8f44-ee79-4f01-ae2f-fdf83d3e048f",MessageUrgency_Abnormal:"10101010-0000-0000-1000-100000000004",MessageUrgency_Urgent:"623496d7-f48e-4ddb-8983-827cacee6901",MessageUrgency_LowPriority:"2afc12c6-f24f-422d-800f-bfe534373f3f",MessageUrgency_Routine:"c2a64d38-3be1-4f8a-8947-ef9e9ad861a4",ListCreditType_Transfer:"0274c6df-47fb-402e-b19c-ca660b05fce1",ListCreditType_Transfer_Adjustment:"3709199d-2a5a-49ed-b9ba-7272627c9ea6",ListCreditType_Remark:"ee8f34fe-4cbe-4f71-9f48-5907b7ff5820",ListCreditType_ContractualInsuranceAdjustmentType:"f8690cac-f9f8-45f6-8782-61246386d480",ListCreditType_InsuranceAdjustmentType:"7f839eb0-406b-4ae2-94eb-a1eee171f331",ListCreditType_CarrierTransferType:"046ac40d-c58d-4732-8399-266851b9f29d",ListCreditType_PatientPaymentType:"bbfdc458-cac6-4598-8e9c-660696b95e11",ListCreditType_InsPaymentType:"83daa0c5-0888-4e57-8ce2-9888f8054889",ListCreditType_PatientTransferType:"0274c6df-47fb-402e-b19c-ca660b05fce1",ListGenderFemale:"e5ded511-ee8a-4b47-aa68-8ff9f74741a1",ListGenderMale:"8202fcb6-c28d-4985-9fc4-0c92e35c2dfd",ListGenderUnknown:"9ef147f5-0265-4611-a9c7-d4005d306fd6",ProviderCareTypePrimaryCare:"37e9f42d-9e10-45db-bcdc-cc86d1d4ff90",ProviderCareTypeReferring:"9ed1cc47-1e90-41c1-81e4-16110078f9fe",FtpProtocol_FTP:"11a82019-6756-481d-8491-d20fb4897a59",FtpProtocol_FTPSSL:"b418682d-f146-439d-9e9b-8111d8aa2fd4",FtpProtocol_SFTP:"893b891e-ec44-4284-92b2-ccd2102c4cfb",ProcedureCodeType_CPT:"00000000-0000-0000-0000-000000000001",ProcedureCodeType_HCPCS:"00000000-0000-0000-0000-000000000002",ProcedureCodeType_LAB:"00000000-0000-0000-0000-000000000003",ProcedureCodeType_ProcedureSet:"66164f99-1142-4f7e-8878-83e600fc6ded",ProcedureCodeType_PQRI:"0852e87a-a5e0-43b2-808a-c6152251a4cd",ProcedureCodeType_CarePlan:"b4350da1-2202-4566-bac3-60f3d55e312d",ProcedureCodeType_RiskAssessment:"4b45bbe4-31c1-4b2d-8df0-67960b9419c9",ProcedureCodeType_Lab:"ed8e7b10-9769-4d4d-9816-1117a95af96a",ProcedureCodeType_Radiology:"7b04148e-4902-496b-b027-f0ee5038d157",ProcedureCodeType_Referral:"6405ca7e-6739-4cd0-9b12-5350e769ee98",AddIn_CSSNDriverLicense:"10101010-0000-0000-0000-110000000001",AddIn_CSSNInsuranceCard:"10101010-0000-0000-0000-110000000002",AddIn_ICSDriverLicense:"10101010-0000-0000-0000-110000000003",AddIn_ICSInsuranceCard:"10101010-0000-0000-0000-110000000004",AddIn_ICS6DriverLicense:"10101010-0000-0000-0000-110000000005",AddIn_ICS6InsuranceCard:"10101010-0000-0000-0000-110000000006",AddIn_ExistingImage:"ad312d6f-cd0c-4956-9652-3d12e73ae0ef",AddIn_ConsentForm:"a9aa31c9-be6e-4cb5-905a-ce04da7cb90e",AddIn_TopazSignature:"a4935c4a-dd00-4666-a820-0fdced9bf6ce",AddIn_BillTimeRule:"f33c7695-0233-4bd6-9600-4efa1340b34f",AddIn_FeeScheduleRule:"2d90ff99-d43d-442e-a3cd-bfa730d704af",AddIn_CombinedServices:"7c3967d2-ac2b-4783-ae2a-c7091022bf24",AddIn_PDRNetwork:"b0273b46-5983-43f2-9b28-432ab9546c8d",AddIn_ePASurescripts:"1353fbb7-ed52-4cf7-8665-fb35d6d60497",AddIn_VitalBMI:"ccf82708-f120-43ff-97fc-a1299eef462e",AddIn_VitalBP:"a6425135-9530-4078-a4f3-eecc68358b1e",KDB_MFU:"ffffffff-0000-0000-0000-000000000001",KDB_PATIENT_MFU:"ffffffff-0000-0000-0000-000000000002",KDB_DASP:"ffffffff-0000-0000-0000-000000000003",KDB_DESP:"ffffffff-0000-0000-0000-000000000004",KDB_CPP:"ffffffff-0000-0000-0000-000000000005",KDB_ADDIN:"ffffffff-0000-0000-0000-000000000006",KDB_ALL:"ffffffff-0000-0000-0000-000000000099",CONTEXTREPORTTYPE_PATIENT:"10101010-0000-0000-0001-110000000001",CONTEXTREPORTTYPE_VISIT:"10101010-0000-0000-0001-110000000002",CONTEXTREPORTTYPE_SUPERBILL:"10101010-0000-0000-0001-110000000003",CONTEXTREPORTTYPE_APPOINTMENT:"10101010-0000-0000-0001-110000000004",USERGROUPTYPE_CARETEAM:"10101010-0000-0000-0000-000000000001",USERGROUPTYPE_AUTHORIZATION:"10101010-0000-0000-0000-000000000002",USERGROUPTYPE_SECURITY:"10101010-0000-0000-0001-110000000003",USERGROUP_CLINICALADMINISTRATORS:"00000101-0000-0000-0000-000000000001",USERGROUP_FINANCIALADMINISTRATORS:"00000101-0000-0000-0000-000000000002",USERGROUP_ADMINISTRATORS:"00000101-0000-0000-0000-000000000003",USERGROUP_PHYSICIANS:"00000101-0000-0000-0000-000000000004",USERGROUP_NURSES:"00000101-0000-0000-0000-000000000005",USERGROUP_REGISTRATION:"00000101-0000-0000-0000-000000000006",USERGROUP_PAYMENTPOSTERS:"00000101-0000-0000-0000-000000000007",medicationUnitTablets:"944ae82b-8244-4553-9fdd-328fffe901c7",medicationUnitCapsules:"fc42ebe7-5c16-4f91-aa73-b6bc48b0a4aa",medicationUnitDrops:"768585b4-71ba-4045-8e9d-77a972e8597a",medicationUnitUnits:"513bc21a-b348-43ea-a8b4-276d5e550f1e",medicationUnitMilliliters:"e9b15f0d-cb8f-4364-ac09-b86301b4d585",medicationUnitGrams:"495c5e93-5c82-44bf-8ac0-423d83a29280",medicationUnitTeaspoons:"9aaba096-f0b5-4f4d-acdb-bce2b131bc22",medicationUnitTablespoons:"328bf7c1-fa26-4229-81cf-9cf5b0c019a6",medicationUnitOz:"cb31a6dc-e156-4f5b-9119-5f6d53abcfb0",medicationUnitMilligrams:"d362abc2-4661-4703-80e8-0d506937274c",medicationUnitMicrograms:"708613a7-6ac4-4027-8dc9-aba237f8c5ca",medicationUnitSpray:"ce49ba3e-d8c8-4e14-a1e3-7a9b24eb14c8",medicationUnitPuffs:"0aba7d84-b35e-4eee-b34b-ac3b9244c2d6",DiscontinueReason_DC:"be13824c-b025-46b2-931c-378c00585ef7",DiscontinueReason_Refilled:"8f132a93-e4a7-4b45-bdbe-ac68e63b1ed4",DiscontinueReason_Deleted:"e322d823-f96d-4070-af3b-aab21b21e6a9",DiscontinueReason_Unspecified:"fe706b0e-9df7-485b-b22b-cefc59192c62",DiscontinueReason_Reaction:"106bff92-868b-4ad6-a1ea-d26b3e71ffd8",DiscontinueReason_Revised:"0587b29a-c354-432b-8b41-f34f7916ef1f",FINDTABLE_RELCCSYSTEMSYMPTOM:"9c4ca244-69d6-4faf-a16f-60a7645b577c",FINDTABLE_DIAGNOSIS:"3b12df01-5df4-44a2-a16b-ba0bc5dd459a",FINDTABLE_SO:"21c60022-225f-4ffe-ae7c-b0b3863cfbcf",FINDTABLE_SP:"22c60022-225f-4ffe-ae7c-b0b3863cfbcf",FINDTABLE_MEDICATION:"d3e281ce-6db6-4a06-8b1c-7c869041cbdf",FINDTABLE_PATIENT:"034f9d24-92ec-4ad5-9b08-dab99d030bc3",FINDTABLE_GENERALNOTETYPE:"c6d90dd0-8d75-4dda-ad40-b661dff8fd09",FINDTABLE_LISTASSESSMENTFORM:"632770df-5a4e-4859-b890-50f32e309e67",FINDTABLE_LISTLABORATORY:"91716d23-9fed-4e35-8169-2ff1b4360c96",FINDTABLE_FINDVITALSOBSERVATION:"a01cfadf-d7db-4aa6-af55-f130825e6c1a",FINDTABLE_WAITINGKLISTDETAIL:"59723a32-10b5-4185-a1ad-f2dbdfd2a27f",PhoneType_Work:"01443a53-7345-4327-a43e-9cc7cf82c98c",PhoneType_Fax:"48af7137-1791-48e4-b338-3dd0a7419073",PhoneType_Home:"07044f79-126c-4bf5-8a91-5ab4b36ac99a",PhoneType_Cell:"13248051-ef12-451e-b27f-71a38ee4c3dc",PhoneType_Pager:"4f6d1328-7e5c-4b1b-b3b1-c06e24d0654a",PhoneType_Rx:"f1e28b28-4c23-4f56-ab4f-e03b10c045cc",PhoneType_Other:"8f7fc1ab-054d-4c5f-a130-d2a63d9d0a26",PhoneType_Night:"ee7ce61f-24e7-4e15-a500-a8d0ae470c71",PhoneType_Office:"ebb01f3d-6431-4d3d-9f51-62d8efa6ae66",ReimbursementRuleUidForQuestABN:"4bfe0401-785b-4b00-88ea-974b6e79f432",LaboratoryUidQuest:"4524b6e9-2be4-4e55-9389-514159a6f995",ClinicalNoteType_FNC:"10101010-1111-0000-0000-000000000001",ClinicalNoteType_SBC:"10101010-1111-0000-0000-000000000002",ClinicalNoteType_Order:"10101010-1111-0000-0000-000000000003",ClinicalNoteType_General:"10101010-1111-0000-0000-000000000004",ClinicalNoteControl_SP:"5db71e56-0da7-4480-a277-e4f796cbff67",VisitType_StrikeOut:"fb954167-9d1c-43b7-9f5b-a76260654c96",VisitType_Private:"dddb34a1-f886-49e3-ad75-e267fafcb1c4",VisitType_Refill:"ada7eb5d-fd9a-4e9f-88e5-84edda9efc42",VisitType_Lab:"6a18a657-b912-4c12-828e-a3df8571d205",VisitType_CancelRX:"7e9ca276-3445-4dfc-9e6c-972b23d34229",VisitType_RxChange:"4bca0ee2-7f2f-4a2e-ad74-834c31af92c5",VisitDiagnosisType_Differential:"240f7492-a04c-4f57-a2b0-58ef7ab57ff0",VisitDiagnosisType_PreOp:"fcdc0aad-94fe-484e-9202-933606eaf421",VisitDiagnosisType_PostOp:"f004794f-c9fb-4c62-98e2-9594bcba1f8d",VisitDiagnosisAxisType_One:"c60524b9-33a6-44c6-ba8f-0fa133818c50",VisitDiagnosisAxisType_Two:"d41e2a8d-1c05-48df-805e-94f4a5cb3f10",VisitDiagnosisAxisType_Three:"ccf041f6-3e09-4276-b11a-dca172b64f8f",PatientTrackingEvent_General:"fb0b78ed-7140-4980-969e-f70039176b5d",PatientTrackingEvent_Visit:"87291d36-0d40-4536-8458-1d5c55882804",sigQtyUomCapsule:"74972c03-9c7f-4af0-b3d9-4030eb8b3c82",sigQtyUomInhaler:"90cc0864-aaaf-40fa-b39e-e472783fa9f6",sigQtyUomKit:"faeb9b7f-c4b3-441a-b16d-dc089c472cb5",sigQtyUomSuppository:"e8357870-a050-494d-94fc-391b7ece24e3",sigQtyUomTablet:"3720a2af-50ea-4bbe-968d-90434f08cb8c",sigQtyUomGum:"352c9425-7c67-407d-a111-870757f019cb",sigQtyUomPacket:"3e7cb1b6-fbf8-4626-b327-0b064e68ba72",sigQtyUomBottle:"b11ecea7-3715-494d-979b-7d2120d83e10",sigQtyUomCartridge:"0bdd7d87-dfee-4f03-89f7-9e216172bcff",sigQtyUomUnit:"24401a56-521e-467a-85c2-b0e6267a4b3c",sigQtyUomLozenge:"b020244f-dcbf-4f74-96c8-e20d07a24928",sigQtyUomSyringe:"d68de1e5-5836-4bd9-85c2-f5d275f637fc",sigQtyUomMilliliter:"b2b811b0-2ad8-4324-a909-a885936f1460",sigQtyUomTablespoon:"83c4b10c-6933-4438-bcc0-b322dada5a33",sigQtyUomTeaspoon:"ccec57e0-431f-48ee-a146-4af1829c4b72",sigQtyUomNotSpecified:"a1ef67ed-010e-45f1-a292-38b1fd03419d",DosingCalculatorUnitGPerKgPerDay:"b657d3c5-4a62-4c10-8ccb-c091a5f5ec0b",DosingCalculatorUnitMcgPerKgPerDay:"75fc5f60-02fb-4861-a2ca-cefe57dbdeb0",DosingCalculatorUnitMgPerKgPerDay:"172b6568-77ee-41cc-956d-5fc15a2a796f",DosingCalculatorUnitMlPerKgPerDay:"a7ba4269-07ab-45b6-9d4c-bf4ca1a3126c",TransactionType_Payment:"e78af210-4992-484d-b804-cc2031868598",TransactionType_Adjustment:"dfe2cdcd-f156-4c5c-a56e-52d7cd3105d3",TransactionType_CollectableAdjustment:"9cceb99c-727a-48fd-9474-f91f14f22a97",TransactionType_Remark:"c02494ee-f471-4237-a35f-974555b0f828",TransactionType_Transfer:"28a84e67-a2a0-48e4-93ba-ef49607ead17",TransactionType_Charge:"b4c75e1c-4360-453d-b8f7-5091e51ddaf0",TransactionType_CarrierTransfer:"ee9a074d-5660-400c-9975-2f961a38d7b2",CoverageType_Medical:"10101010-0000-0000-1001-000000000001",CoverageType_Dental:"10101010-0000-0000-1001-000000000002",CoverageType_BehavioralHealth:"10101010-0000-0000-1001-000000000003",CoverageType_Uninsured:"10101010-0000-0000-1001-000000000004",PatientBill:"4d460de7-fd6c-43b6-9fdb-bec08713ec98",InsuranceBill:"2eafdf7d-3b73-46dc-af8b-4f2ba5a1743e",ClientBill:"9376a37e-b27f-422b-97c0-d398a5dd86d8",EM1995RulesExamination:"b78818e4-345f-4a20-b303-7f2146343330",CardiovascularExamination:"58dd4ba5-1ec2-49d2-9287-8fef51acf104",ENTExamination:"8cca5d54-2f38-44aa-a416-8e62c2b4d2ef",EyeExamination:"49949119-8d84-4764-aaba-902698c65cbb",GeneralMultiSystemExamination:"9c1c8d66-89f9-4097-b1e7-f601f10e60f8",GenitourinaryExamination:"23c8a50e-06bc-4fd4-98aa-a80242cb0374",HematologicLymphaticImmunologicExamination:"f5e2db8f-0884-487e-bc04-5554bb187b4a",MusculoskeletalExamination:"20ef398a-50e2-4b42-b350-d563a8c22637",NeurologicalExamination:"97b8c00d-d75f-4885-8363-1e6c252dfcd4",PsychiatricExamination:"37e40cc7-07af-4520-9d47-d2e6d09b4ed7",RespiratoryExamination:"199151d4-0a37-4567-9c67-0bb7858523c7",SkinExamination:"aadde121-1315-46fc-a32d-4440d55fb239",EMHistoryPresentIllness:"bef97f98-fc7b-4938-a611-3961fabe7c82",EMReviewOfSystems:"2f4c8c81-20d6-4551-80cd-87fb9403fd0c",EMHistory:"e770d652-dddc-4950-8c23-1941677ec51e",EMPhysicalExam:"dbcd49e7-4d67-4414-9881-f72438eabae6",EMComplexity:"8ffbe65c-8e12-4c3f-b4ae-d603c8217692",SystemBodyAreaAbdomen:"88fb7da6-9fd7-45a8-bb9b-525db08174dd",SystemBodyAreaAllergicImmunologic:"d316b3ed-5004-4a69-85b3-2308cdc310c8",SystemBodyAreaBack:"745f34ab-10dd-4e22-8aa4-e506d3d77791",SystemBodyAreaCardiovascular:"18c37cd0-6b72-41f6-97f1-22171a694da4",SystemBodyAreaChestBreasts:"61433637-4dce-4e4e-a8c6-016447fe0251",SystemBodyAreaConstitutionalGeneral:"fee1b725-b1c9-4544-87dd-d9ac27dcc7ed",SystemBodyAreaEachExtremity:"3368a111-dedf-44c6-9363-dfddb21367fe",SystemBodyAreaEndocrine:"11d2dae7-6d0c-419d-954d-5d9702826f1f",SystemBodyAreaENMT:"57824fba-b1eb-4753-aa00-1dd9b245a00c",SystemBodyAreaExtremities:"82f5a636-a9d2-483c-86e9-659055efc076",SystemBodyAreaEyes:"7df385b7-fd9b-49bc-b951-374f55b45e5a",SystemBodyAreaGastrointestinal:"074a4b52-6e98-4b0d-a381-5a59778dd2a1",SystemBodyAreaGenitaliaGroinButtocks:"65511a5a-6009-4fc1-9457-fdba294ab963",SystemBodyAreaGenitourinary:"d152486f-74b1-4cce-958d-bfd0108683c1",SystemBodyAreaGUfemale:"c09042c4-3280-4824-9be8-95f736c3f2a2",SystemBodyAreaGUmale:"43093213-8382-48b6-9a7c-c5cb230d9c39",SystemBodyAreaHeadFace:"546c7b3a-a749-4556-ac1f-e9f224427756",SystemBodyAreaHematologicLymphatic:"a320cbeb-45dd-4ff3-a978-ca9e49031976",SystemBodyAreaIntegumentary:"95593059-117e-4f38-b508-14e03e9f0fd6",SystemBodyAreaMusculoskeletal:"348a5b05-0c69-4079-8c51-e7fc70d18db9",SystemBodyAreaNeck:"258b3fef-2c22-4c14-b766-aaf1be4b7210",SystemBodyAreaNeurological:"dff1ee30-ce8e-4911-a6b6-a89ee1c3ccab",SystemBodyAreaPsychiatric:"23970102-c468-42b7-b326-163aa89700ff",SystemBodyAreaRespiratory:"348e524f-264d-40eb-91c3-dbc0a6d00ded",BulletExaminationGaitAndStation:"e0b4bf3c-5bca-400e-8a6d-aabea02e0f9b",BulletHeadNeckAssessmentMuscleStrength:"87abb1ab-88bd-46fe-b444-f6cfdf2706b8",BulletHeadNeckAssessmentRangeMotion:"c00f5206-3dd7-4415-9421-35633ca04c30",BulletHeadNeckAssessmentStability:"89a893e4-cc49-4271-967e-a47edb373887",BulletHeadNeckInspectionPercussionPalpation:"d314963d-9ad4-46c6-8612-e93bdd6e11b4",BulletLLEAssessmentMuscleStrength:"7248507d-4079-46ea-bd04-7c93ef8de796",BulletLLEAssessmentRangeMotion:"ff7a2629-3050-451f-b876-90bbf94d1237",BulletLLEAssessmentStability:"3e7ff9f5-bde9-40f0-850f-1de5a22ef782",BulletLLEInspectionPercussionPalpation:"eb210e0d-8e14-42bc-a230-c8d217ce4b6f",BulletLUEAssessmentMuscleStrength:"23a0260c-ef54-4aae-823a-8872d4e51aa1",BulletLUEAssessmentRangeMotion:"4dd4328c-49ae-462a-a4b2-b91244bd336a",BulletLUEAssessmentStability:"e7e3316f-0b29-4ff2-9c4b-97cfe7eeee6d",BulletLUEInspectionPercussionPalpation:"5726e7e5-5eb4-4b14-a92b-7c8aa8b0fee1",BulletRLEAssessmentMuscleStrength:"5fed9f47-4715-443d-98f0-186409e7e5d4",BulletRLEAssessmentRangeMotion:"ab880484-1d2c-4c57-bfa0-8ef204426613",BulletRLEAssessmentStability:"2a30e4cc-8e92-41d3-bf53-ec0a8cb2ae4b",BulletRLEInspectionPercussionPalpation:"3bff721c-a1fe-4211-be53-3cb6bfb58272",BulletRUEAssessmentMuscleStrength:"a2a73e16-346d-40c4-9448-0cf35ec252df",BulletRUEAssessmentRangeMotion:"68cbf246-3f18-4023-b5de-98cd6f6c4faa",BulletRUEAssessmentStability:"8f343b4b-f9d3-4a75-acd0-053a5b2997f2",BulletRUEInspectionPercussionPalpation:"ce254a35-4999-468c-8142-916fc9ed1147",BulletSpineRibsPelvisAssessmentMuscleStrength:"f9331555-d8ff-4a1b-a23a-87622739cf36",BulletSpineRibsPelvisAssessmentRangeMotion:"7fcab774-1053-4a52-893d-0ea2fd4bc8c3",BulletSpineRibsPelvisAssessmentStability:"3871ce19-a073-4282-930e-a3d61b1546e4",BulletSpineRibsPelvisInspectionPercussionPalpation:"8e4dd741-589a-45c7-a2f9-4b008d261498",BulletBilateralLowerExtremitiesAssessmentMuscleStrength:"feaf086d-a100-4629-8fc8-80784dc10b2d",BulletBilateralLowerExtremitiesAssessmentRangeMotion:"85b34895-9afa-4ec4-8e99-8d7f8eacd350",BulletBilateralLowerExtremitiesAssessmentStability:"82faba5e-8c37-4725-ac07-6cbb684165ee",BulletBilateralLowerExtremitiesInspectionPercussionPalpation:"69c445bf-5d9b-4486-abdd-fd56d411ad2f",BulletBilateralUpperExtremitiesAssessmentMuscleStrength:"911d7cc1-5bd4-4e99-a810-3c236c3725cf",BulletBilateralUpperExtremitiesAssessmentRangeMotion:"a3ef1718-b31a-4da5-8d53-3e71b9e8da7d",BulletBilateralUpperExtremitiesAssessmentStability:"f53e7fb0-8ec0-432a-9d57-ba8fa89de18e",BulletBilateralUpperExtremitiesInspectionPercussionPalpation:"a0624d3a-2f36-4705-b3ac-ab397d9e459e",BulletSkinInspectionEccrineandApocrineGlands:"bf719d7d-bc45-4507-b162-5227526bd781",BulletSkinPalpationofScalpInspectionofHair:"2b4bfede-73ab-4098-b1ba-e40b717fe352",BulletSkinChestBreastsAxillaInspectionPalpation:"adc1c908-a874-485c-85a3-5b9391631bc8",BulletSkinGenitaliaGroinButtocksInspectionPalpation:"94e371f4-36be-4cb4-b904-ba3bc373871a",BulletSkinBackInspectionpalpation:"869022df-099b-4a5f-8902-30c6ab9b9bae",BulletSkinAbdomenInspectionPalpation:"059e7a21-124d-4ce9-8faf-32f48c4a3463",BulletSkinNeckInspectionPalpation:"dead1aa4-4474-4cd5-a88c-9804281e7b1b",BulletSkinHeadFaceInspectionPalpation:"12f6ec75-2e61-4ed0-9040-a61dee0528bc",BulletSkinRLEInspectionPalpation:"3c82c8fb-87c5-457b-bae2-cd43438692a7",BulletSkinRUEInspectionPalpation:"dd39da78-5a0f-44dd-95e5-0d4baa7ad63d",BulletSkinLUEInspectionPalpation:"4ef562f1-3345-4ba2-9806-0985b6bf6cad",BulletSkinLLEInspectionPalpation:"f4331d61-7d78-47ee-a23b-c65720e8e27a",BulletSkinBilateralLowerExtremitiesInspectionPalpation:"747bd4ac-a12d-40e4-bee7-210a6a7d059e",BulletSkinBilateralUpperExtremitiesInspectionPalpation:"3944567f-767d-44d8-8113-2637997bdf03",AnswerGroupGestationalAge:"ffffffff-0000-0000-0000-000000000004",GestationalAge24Weeks:"556f48a1-2f5d-409d-bd09-e08057f5be4c",GestationalAge25Weeks:"8fe8a052-7bbf-4569-8520-44eca79867c7",GestationalAge26Weeks:"a46638f1-a764-4a1c-9bbf-5bf8279fd6a7",GestationalAge27Weeks:"4b3640e3-9563-4703-bcf5-b4bcbdb7790c",GestationalAge28Weeks:"b32c8d4e-d3fd-449e-a5f7-f997893d97b8",GestationalAge29Weeks:"74815aac-f0dc-4076-9b38-b716ad8c6f30",GestationalAge30Weeks:"22d9d282-8063-457e-82ce-976f2fdbf7ef",GestationalAge31Weeks:"60884edd-9bdb-43d4-87a6-d658a10c5b22",GestationalAge32Weeks:"fb996b55-bdad-43d8-8362-69a2f756d3c2",GestationalAge33Weeks:"ad63793e-d690-4774-812c-f8dff9130e8d",GestationalAge34Weeks:"80641b5e-f7bd-44e1-915f-da508fe592b0",GestationalAge35Weeks:"9124175e-ef21-48de-8d74-09b88147b0fc",GestationalAge36Weeks:"47c03c8e-bcc8-4ec0-abce-2256e997f5d9",GestationalAge37Weeks:"f0c15fe4-f9ca-4f98-90bf-21ed0b2562ca",GestationalAge38Weeks:"25e2e7af-44dd-4711-9109-613af18aca92",GestationalAge39Weeks:"6cd6e108-9266-4bc6-aa2d-046ea54e65cc",HistoryStateActive:"506b5714-4dda-4080-81af-e2b37d4c4f19",HistoryStateInactive:"8984ba72-9122-4cde-8627-33e740ec0c7c",HistoryStateResolved:"9415899e-91ea-4be1-a7c3-d2c44bc0acb1",HistoryStateChronic:"044fade0-a022-48a8-9f8d-9a2b14e60580",JobeRxPollMessageUID:"c7491df5-12b6-4a94-ac8a-7e238d2e3ac7",JobeRxSendMessageUID:"592f87ec-356c-484d-924b-9229d769fa87",JobeRxProcessScriptUID:"183495cc-9b64-4f1b-a3c9-e3b728621079",JobeRxProcessPharmacyUID:"fdee0da3-1319-430a-9164-63bf273cc4b2",JobeRxSendRXHMessageUID:"c0c5dab1-abc4-4a44-9df0-cb97e6013b51",JobeRxSendELGMessageUID:"38684974-e91a-494b-9f0d-64765f4e0196",JobeRxCreateRXHMessagesFromCalendarUID:"160c2f70-efd0-476a-8ca9-8a97340af073",JobeRxCreateELGMessagesFromCalendarUID:"a9b1ec6a-c4ac-44bf-846d-69a3cd13aedf",JobeRxProcessPRVBRDUpdateMessagesUID:"5a696db7-0632-4979-981e-8460bc6ff8be",JobeRxProcessX12ScriptUID:"e95ebece-e069-44a6-9a5f-7566db1785e7",JobeRxProccessePrescribingActivityReportUID:"a0010916-897a-4ff1-8e3d-bd567054a7a5",JobScheduleeRxPollAllUID:"c7a28bc3-9b4a-4832-a64c-947f24d4c2b6",JobScheduleeRxPollPrescriptionUID:"bf2aab37-3656-453e-89f8-358e18503793",JobScheduleeRxPollPharmacyUID:"eaff3043-e1ae-437a-833e-b24295b12b69",JobScheduleeRxPollPrescriberUID:"4bda1f87-b348-4404-bfbe-5560bee4235d",JobScheduleeRxServiceCreateeMedHxMessagesUID:"54556fee-0696-4c52-a4e3-4e9d4e9a3fb3",JobScheduleeRxServiceDownloadPrescriberOrganizationDirectoryUID:"4bda1f87-b348-4404-bfbe-5560bee4235d",JobScheduleeRxServiceCreateRxBenefitsMessagesUID:"c45aa546-acf7-4496-a2cc-9da49d173e27",JobScheduleeRxServiceDownloadPharmacyDirectoryUID:"eaff3043-e1ae-437a-833e-b24295b12b69",AuditTypeSecurity:"b6d3b9f2-1847-4061-a8bb-36c1dbc2ab87",AuditEventTypeFindControl:"e4482728-322a-4f68-b71f-66a3f27f4ec3",AuditEventTypeWorkflow:"b5ba8723-6011-45fc-9d42-9c3af3c07b9d",Control_Type_Blood_Pressure:"34c77b17-5978-478a-a584-85905652e705",Control_Type_Generic_Kilogram:"e7648055-dd5c-4852-8e36-af37daff8478",Control_Type_Generic_Length:"4d5c3bd5-1f2a-4936-b5bc-2a8b648596fc",Control_Type_Generic_Observation:"b8df29b0-1df3-42d6-b2d3-a2952313a3fc",Control_Type_Head_Circumference:"8b8671a1-c984-4928-add7-9de4b2dabf62",Control_Type_Heart_Rate:"16e1d982-3d5f-4a74-8abe-6179b46705dd",Control_Type_Height:"afeb48db-4ac4-45d2-a3fc-aa6dd2a94d03",Control_Type_Respiratory_Rate:"731cd44f-50e3-460d-9d75-0c221506279d",Control_Type_SpO2:"4fc9c432-4b6a-4971-99b9-84160cb1b579",Control_Type_Temperature:"17912814-2d13-4b9a-ab26-089ba658917e",Control_Type_Weight:"9bd6af71-120e-4d58-a99a-c52ef2fd4676",Control_Type_Generic_Number:"2219e1a3-3919-43e5-9964-decb281fe826",Control_Type_Generic_Date:"c3ee6e69-c4e8-4b29-b17e-b59de3d0280b",Control_Type_Eyeglass_Prescription:"1e10fbd4-37c5-4265-baf5-501904f863f5",ObservationItemSource:"50ab9c8d-9945-4867-879f-d17ef43f9f2b",StandardCustomVitals:"67f9360a-5b25-4b12-83c2-3c10a76f7792",GAFObservation:"84a5ff1d-eb34-4528-9e92-c5fc912a279d",DefaultOPSTemplate:"f20ee29a-2eab-4be2-bd1c-210c0da89606",DefaultVisitTemplate:"c0b27735-8ad2-4397-bf68-272eb7c1dc86",DefaultRPNTemplate:"e84d2316-2ca1-425b-9955-d8b31b045c2f",DefaultRPNPrintAttachmentTemplate:"abf1577a-9efa-490a-8b5b-cd084a3408d0",AccessDeniedTemplate:"a1382f72-d478-45ab-9524-2618aab76032",AccessDeniedTemplatePatientChart:"1d78f979-28ac-4911-8184-9612ad8101e0",DefaultPatientWelcomeEmailTemplate:"7c8b6a18-2eed-47c4-80b3-4f092600ce13",DefaultPortalMessageNotificationEmailTemplate:"e5949ce7-84f4-40b2-a9fb-c9a2b83ca126",DefaultPortalWelcomeEmailTemplate:"09a0cd36-5ec9-454a-9b36-c8de4a4e9507",DefaultPortalChangePasswordEmailTemplate:"14b2a33d-31da-4845-aff1-ce50f731ebae",DefaultPortalNewMessageFromPrmEmailTemplate:"6f9a8978-bca6-4a8f-8a68-f83d8d673457",DefaultPortalResetPasswordFromPortalTemplate:"2017c0f9-19b0-41fa-8f08-572de811ff93",DefaultPortalAccountResponsiblePartyStatementEmailTemplate:"c1608427-2fbd-4660-8931-54b990c449b7",DefaultCheckoutTemplate:"68452037-77d6-4499-91f3-f5533bf9ddcc",DefaultOPSPrintHeader:"a8ae8ca1-e854-40b9-976c-10e86a9f7ced",DefaultOPSPrintFilteredHeader:"d69082ee-8c88-458b-a71c-8cb2d9414b3f",CompleteChartZippedAttachment:"e60e42c0-e9fe-4373-a7d3-5536e2b22b9a",CompleteChartNotIncludedAttachment:"1a38397e-9aa1-47a5-9e98-6385f9c35088",DefaultClinicalSummaryTemplateUid:"7bc0cad4-06d2-4f5c-8e96-d8df589db6ec",DefaultRPNPrintButton:"bd75524a-378b-4fdc-b7f8-e7cb438aaf27",DefaultOPSPrintButton:"ae48142a-e4bd-42a6-a34b-b82cad46acdf",AllFileTypesToFiles:"cd57cf3c-d2f9-44f6-8366-a4708a9d88fb",ChartAccessControlsSecurityUid:"426ecfd5-7259-414e-81c7-a7edbccb1b66",EmergencyChartAccessSecurityUid:"0e0b6e89-614e-4ee6-a8c4-c6e818cb7f9b",ListVaccineAdmin_PediatricVaccineCard:"6b1b35b9-85a8-499e-83d9-11ebb24cea04",ListVaccineAdmin_AdultVaccineCard:"187d09c3-f59f-446f-af14-3d8e1a3bd920",ListImmzCompletion_Refused:"d656418e-f475-4b76-a624-d4697b2b7d7b",ProductParameter_PatientPortalRouteMessagesByServiceSite:"ba5d6df9-8124-4a90-94c3-2fe739597f1c",ProductParameter_PatientPortalUpdateDemographics:"db28aa45-8e4e-4646-bd98-332c718ace12",ProductParameter_PatientPortalUpdateDemographicsPhoto:"6a47f7f6-41d6-467b-8a7a-be36d6c92d9b",ProductParameter_PatientPortalTagLine:"72af95ce-12f5-450a-8c0a-3941a3256ac7",ProductParameter_PatientPortalPracticeConsent:"1d1fe66b-54b1-46cd-9d6d-aeeff9e411e3",ProductParameter_PatientPortalChartConsent:"8d3b926a-d237-4ba1-99c8-1c40bd5d7dd5",ProductParameter_PatientPortalURL:"d0df5185-9f23-4d2b-8bf3-0e6c48442861",ProductParameter_PatientPortal_ViewClinicalSummary:"27d5a4b8-1c68-45bb-a89f-023fbc5fc370",ProductParameter_PatientPortal_ViewCompleteChart:"aa04ca02-089b-4455-8566-cf9d766487b6",ProductParameter_PatientPortal_ViewImmunizations:"0354d96b-e135-4753-b06c-1634e6745299",ProductParameter_PatientPortal_ViewEducationalMaterial:"aaad592b-0bff-4141-9f1c-504786cfe873",ProductParameter_PatientPortal_UpdateInsurance:"349cdc7a-781c-4586-8414-12f79b1b6d1d",ProductParameter_PatientPortal_MakeAPayment:"a3978397-4796-43b3-9586-7f24e41aee33",ProductParameter_PatientPortal_UpdateDemographics:"db28aa45-8e4e-4646-bd98-332c718ace12",ProductParameter_Practice_Email:"ecdf36fc-d8ae-460c-ad3d-8ebbdef9abe1",ProductParameter_Practice_Website:"da6121e9-0978-4526-9052-ee4e844f0456",ProductParameter_Practice_From_Email:"efbb66f7-afbb-421d-8a99-697d36ff5625",ProductParameter_AutoAddOnSetToDX:"0f1a6e38-41f4-48b2-8713-5688c222c9ee",ProductParameter_DocumentLinkingWarningNumber:"86a89f8b-6cf1-42ad-be0c-2cfc0a663536",ProductParameter_PatientPortalSecurityQuestions:"8c66bafa-eb42-472b-b89c-8b8de09218f1",ProductParameter_PatientPortalContentAttributes:"1c190aa8-df1e-49b7-8fff-901d28046d22",ProductParameter_PatientPortalMessageSubHeading:"b348f800-1fcb-4397-9e1a-2226afd836e4",ProductParameter_PatientPortalPracticeName:"2ad081a3-a195-4093-9c7f-1563bd3179a3",ProductParameterDPNActionPrint:"dbface34-6154-488d-8f44-c13dcb64b165",ProductParameterDPNActionGenerateCCD:"a6845a5d-2fb1-494c-81c6-1e57fd4eb02e",ProductParameterDPNActionSendDocument:"134d73d3-f594-48af-be75-84ebcbd76e99",ProductParameterDPNActionCreateReferral:"a336390a-5c72-4ca5-a9f6-40ee9a741cce",ProductParameter_ApexAffinity:"5ae76288-3801-4c71-b943-370e7239bbc0",ProductParameterFacilityAccountEditingEnabled:"274cf86f-edf0-4b61-ac12-ed5edcfec653",ProductParameterDirectMailUserAccountCreationWarning:"96354ac3-d38a-46cc-afae-bf0b532d995e",ProductParameterDirectMailUserAccountDeletionWarning:"4fefe5bb-55d0-4275-96e3-9afc101e9f15",ProductParameterDirectMailNitorOneFacilityPerDomain:"0de075f1-fddc-4cb6-a5f1-6c30af39b544",ProductParameterDirectMailNitorFacilityInactivePollSeconds:"0fecddc7-5174-4311-a7ba-524377e6da3d",ProductParameterDirectMailNitorFacilityActivePollSeconds:"78b5d74a-d9ca-4611-981b-74e6275af6e0",ProductParameterDiagnosisOneUrl:"719523ee-c072-495d-8e37-4e97d3a832a5",ProductParameterDiagnosisOnePassword:"0d3ab0ca-dd67-4870-b8a6-62216481d613",ProductParameterDiagnosisOneUserName:"2134b723-15ce-4147-884b-e0f0c2669f89",ProductParameterDiagnosisOneRuleSet:"9106f134-b471-487b-a48f-bd69e465e1ca",ProductParameterDiagnosisOneSaveToFileEnabled:"924496a8-b7a9-46ed-b59d-ce052c076eef",ProductParameterDiagnosisOneMaxBatchSize:"f0db6d11-ec84-447b-adb4-70fc3485a60b",ProductParameterDiagnosisOneOAuthPath:"ba5e0d70-7bf6-46bd-9646-acc5536b9b5f",ProductParameterDiagnosisOneBaseINROrderUrl:"55b1f554-1699-4796-88c1-4821ca3a165b",ProductParameterDiagnosisOneBaseINRReportUrl:"777f29c5-122e-41f6-9b4e-31933fa63b21",ProductParameterDiagnosisOneEnterpriseID:"e227b015-4a0e-4397-af18-a1478e438613",ProductParameterDiagnosisOneINROrderUsername:"4baeecea-a4bf-4470-bb7b-c6b2138e1aff",ProductParameterDiagnosisOneINROrderPassword:"2d2b9c78-d37d-4625-b5dd-018d8dc5491a",ProductParameterDiagnosisOneTokenGeneratorUsername:"b59cb0ee-f4e4-4dd2-9e46-a6bc8f7a97ba",ProductParameterDiagnosisOneTokenGeneratorPassword:"9be8782f-bfc2-453f-92a2-67cd4ee62d80",ProductParameterDefualtCCM_CPOTime:"680f3ffb-096f-4cdf-a84d-fc68d9da1557",ProductParameterValidePAPayors:"5397bb02-9803-4639-9c85-dbff48739e88",ProductParameterInfoResponseReviewed:"125f71db-c197-45e1-9c39-3e7561638fab",ProductParameterTransmissionSettingsCreateNewMailbox:"783fbc03-825b-4fb6-b8e8-5e84c25275cd",ProductParameterAprimaNowLockoutTimeout:"aab069b0-5b64-44ef-8963-371dfeff4edc",ResultStatus_Approved:"53bdc86c-2839-4066-9821-c20c214967b1",ResultStatus_Resulted:"e4861953-d5f3-4d86-be78-530b394ae39e",ResultStatus_Received:"0017db73-34cc-42fe-974d-555f72088690",ResultStatus_Reviewed:"40040bb9-3e07-4829-adf6-55bc637142e1",ResultStatus_Collected:"71812cbc-af6d-4c84-aac9-70d0c024f282",ResultStatus_Performed:"537aeecc-d952-4b66-831a-c4d6531906b1",ResultStatus_Cancelled:"6b6a1578-26d1-452d-a198-dccfbcd9094f",ResultStatus_Pending:"d8acd15c-4f00-41fc-93c2-e1ba0a4edaa8",ResultStatus_Ordered:"9114caee-042b-4b2c-a505-e70ba934000f",ResultStatus_PendingResulted:"dd6bc606-fa5f-47ea-a2a2-fd0f3938931c",UserSetting_Default:"10101010-1111-1000-0000-000000000001",UserSetting_ICS:"10101010-1111-1000-0000-000000000002",UserSetting_Midmark:"10101010-1111-1000-0000-000000000003",ServiceSiteType_Home:"e5cbbaff-919a-44f7-912e-07b014b27bcd",RelationalOperator_IsNull:"75c59d5e-d1d6-4cfe-bb3b-1897fb56c268",RelationalOperator_IsNotNull:"ead36730-d30a-49db-b900-d2d9b67ad770",RelationalOperator_InList:"a7203de7-eb48-419d-b8de-5197e60e8a63",RelationalOperator_NotInList:"4b1f614c-ce33-4614-90bf-0ce2718cd23c",RelationalOperator_GreaterThan:"48eb6b68-552e-453f-ba8b-50ccb2a0988f",RelationalOperator_GreaterThanOrEqual:"5fcf409e-2137-4630-886c-e928057dac36",RelationalOperator_NotLike:"0885c3fa-be9b-4752-935c-51166f5cb199",RelationalOperator_NotEqualTo:"f4977c61-7ad6-4a4f-ad94-9a858a6a5760",RelationalOperator_LessThan:"e935c919-6b45-417a-a569-c4ad0b719a02",RelationalOperator_LessThanOrEqualTo:"aa3f54b6-f4e9-4031-bffa-ce067e0196f4",RelationalOperator_EqualTo:"127889ba-7c69-4f1a-9657-de3bf969a7eb",RelationalOperator_Like:"f4bed64e-be68-4a57-9fb1-fbe242643a36",UserDefinedControl_Find:"8a957d7c-8b86-4a67-8336-b830c30fd123",UserDefinedControl_TextRange:"9b225d53-0cbd-4f0d-bd0a-54d05685ccca",UserDefinedControl_DateRange:"f81b4b08-d296-4ee9-b1f3-e61f85644a88",UserDefinedControl_NumericRange:"def86050-eef6-4577-9d2c-f7c172a0f6ea",UserDefinedControl_Timespan:"df87d0d5-bf48-49fb-abbc-cb75cc29eb64",CPOExternalType:"cdb32bb9-25b8-4598-85c2-eca33d3b854c",ChronicCareManagementType:"14e95bcd-a9bc-41e4-9743-ecdbad35fb6a",CarePlanOversightType:"928a4f18-ff1f-4bba-90d9-66aee2233c9a",HMRules_OperandUid_LessThan:"3eebb69d-3bc4-4ce9-97fc-815c70f314a8",HMRules_OperandUid_GreaterThan:"1263504f-77e8-41e2-aabb-75b10647d7f7",HMRules_ConjUid_AND:"8637cc01-aab8-4e8a-a971-9cd91d0ef1eb",HMRules_ConjUid_OR:"578cbd26-44df-4b86-b119-c2c4b759042f",Scrub_Superbills:"3e6dafcf-ebf1-4dc5-90b5-f596a9ef8498",Scrub_Claims:"5bac9c30-6387-4359-9c39-42e2850d924c",TimeFrame_Clear:"2ec8c22d-49a2-4289-829d-017457bebfc0",TimeFrame_Default:"444e6dc7-df0f-45bc-b8c1-c8b4122eed97",TimeFrame_FreeText:"d6153566-df35-42ae-8cba-b36544c53133",TimeFrame_Calendar:"2a65cc34-b700-4be1-bc0c-bc3947abdbb4",TimeFrame_Birth:"86317d78-c519-4fe3-8f02-b794ffb00357",TimeFrame_Childhood:"4ce23cf0-c9bb-4016-900f-76a567a3c82c",TimeFrame_Teenage:"3ff31d6d-0706-429d-9acf-c54e081ecd29",ProblemStatus_Active:"613cd9a8-4e48-41d2-9c91-41eb7d5885b4",ProblemStatus_Resolved:"116e88e8-daf1-4289-b354-e4cbc8a0103d",ProblemStatus_Inactive:"92aeb1dc-a874-4c7a-bee1-53653161266d",ProblemHistoryCategory:"df10c01a-d56a-4d97-aeca-5616ff05314a",ListEthnicity_Hispanic:"304621ec-0958-4dc1-ae4d-2438e1d0dbdf",ListEthnicity_Hispanic_Or_Latino:"f34dad44-e417-47b3-b338-515954d242e3",ProblemDiagnosisSortName:"624601c5-0b33-4c6a-91e6-69ddb47200ee",ProblemDiagnosisSortOnset:"97226c02-8856-4d93-88fa-9bf71c9d9c04",ProblemDiagnosisSortResolved:"9322c9ee-2ddd-49a1-bb54-308b7b501077",ProblemDiagnosisSortProblemStatus:"59afd3b8-36de-4575-ba33-dea43720c2f5",ProblemDiagnosisSortProblemDuration:"6d2632e1-8b63-48b9-994a-244a67a3fa7f",ProblemDiagnosisSortRecordDate:"33c9190f-8f4b-4f1d-a56f-782759d3202f",ProblemDiagnosisDurationSortUnknown:"187ad067-794a-45f0-b954-f6816668bc54",ProblemDiagnosisDurationSortAcute:"38379dd8-cd7a-45af-a7b2-ba3aa4507ba3",ProblemDiagnosisDurationSortChronic:"983c3ad7-3524-40cc-816b-1b942236dffd",ProblemDiagnosisNameSortLevel:"624601c5-0b33-4c6a-91e6-69ddb47200ee",ProblemDiagnosisOnsetSortLevel:"97226c02-8856-4d93-88fa-9bf71c9d9c04",ProblemDiagnosisResolvedSortLevel:"9322c9ee-2ddd-49a1-bb54-308b7b501077",ProblemDiagnosisProblemStatusSortLevel:"59afd3b8-36de-4575-ba33-dea43720c2f5",ProblemDiagnosisProblemDurationSortLevel:"6d2632e1-8b63-48b9-994a-244a67a3fa7f",ProblemDiagnosisRecordDateSortLevel:"33c9190f-8f4b-4f1d-a56f-782759d3202f",ProblemDiagnosisStatusInactive:"92aeb1dc-a874-4c7a-bee1-53653161266d",ProblemDiagnosisStatusActive:"613cd9a8-4e48-41d2-9c91-41eb7d5885b4",ProblemDiagnosisStatusChronic:"e7e822a8-edd9-45f9-80b8-dfb3d2383122",ProblemDiagnosisStatusResolved:"116e88e8-daf1-4289-b354-e4cbc8a0103d",ProblemDiagnosisStatusDeleted:"0ee6820d-a8f8-4364-b0b1-25aab505959a",CollectionStatusGlobal:"d497b60d-5bd2-414d-aa1e-4f8e558c5ce5",ListDisclosureReasonReleasedToPatient:"23453773-db8a-47bc-b3f5-5d915fa2b313",ListDisclosureReasonCompleteChartSummary:"dc3160a4-95f4-4224-a3f6-eff5d33dd61b",ListDisclosureReasonReferral:"e4b426a5-59aa-416d-b37b-ac7bd782b780",ListDisclosureReasonReleasedByPatient:"f296c968-14d2-4616-a526-1acd35527801",ListCustomNotePrintCompleteChart:"893996ba-e098-4239-885d-7e3252bba8f9",FaxServer_Interfax:"cc7d8447-2def-4b56-b7fe-675f4f9e7dac",FaxServer_Fax2Mail:"3c85e316-d741-4c67-9cdd-fec603be7bc6",FaxServer_GFIFaxMaker:"4e064089-ab4a-4015-9ab0-8fdc9d18a99b",FaxServer_Biscomfax:"a1fb09d9-5ef0-492b-945e-b524ee47d5c1",FaxServer_RightFax:"1f955d28-c5bd-467b-93c9-fe9c83f95cbf",FaxServer_FaXit:"d9a693f0-e780-4427-a6e3-2a578025f8b8",FaxServer_Kno2:"586f8db3-fdf7-4639-af4f-b5865a6f670f",DocumentLinkingGeneralFolder:"9e6422c4-3f95-4ce6-bc84-79d068b93135",DocumentLinkingIgnoreFolder:"d762799d-1d5a-4546-9ead-fdfdc2021fc5",DocumentLinkingRejectedFolder:"e38fcf0c-75b9-4624-95c6-346c78fccb2c",DocumentLinkingDirectMailFolder:"2dea85bb-503f-40a6-85ac-b2b199f63dcf",DocumentLinkingFaXitFolder:"47688f38-cdfb-4b76-b73c-b2f69e36713a",MapSource_ClaimsMapping:"18b56921-1614-4e0a-af7f-edd311e682e4",MapSource_BeaconCarrierMapping:"45193380-4dcc-4837-99bb-fd145f1cf420",MapSource_FromSurescriptsPhoneType:"b41b3296-f1be-4f41-b90d-6aec99299ff3",MapSource_ToSurescriptsPhoneType:"8a2fe4ae-25fd-42eb-9b2a-9b68e1795206",UIControlType_ChargeTicket:"362af25f-7a3b-4b37-83d2-3f316d87f8b1",UIControlType_DataInput:"1232ccd0-b254-4cb0-af95-bf482de4f1c8",UIControlType_ClinicalNoteTab:"26c21b2e-3aec-4cb5-9bc2-c9dc7dc9e34c",UIControlType_ClinicalNoteSlider:"690c5ea2-3345-4785-ad1c-a1787feafe1d",UIControlType_ClinicalAssessmentForm:"d5b6f824-c839-4bd5-b660-042a74c43ebc",UIControl_ChargeTicket_Designer:"f7992625-529f-4862-b984-23fc76a6740b",UIControl_ChargeTicket_Standard:"4277e604-1ed7-4d19-b0e6-fc1acd09f10d",UIControl_DataEntry_Designer:"a71ae324-02b7-47e9-bd32-b96dde7e779e",UIControl_Note_DesignerInput:"2ff8df13-6adf-497a-87c5-4bf34047b2ea",UIControl_Note_DesignerCaseInput:"5ef07c48-9b2e-4551-8199-26e0cdfaaa70",UIControl_Note_Plan:"892d6a04-149b-4283-abeb-12495ab3c560",UIControl_Note_CC:"c7aa99b0-b9aa-4570-9357-145f175fad62",UIControl_Note_SO:"d558a00e-a0b8-4425-b6ca-18cfcdd4e5e6",UIControl_Note_HPI:"7480235f-7012-4c04-ba36-1aefc1697593",UIControl_Note_PE:"32bf6c13-ed87-48de-9fef-52a5143d444d",UIControl_Note_VisitText:"bd6530dc-2373-49de-b284-56ea3d79cc46",UIControl_Note_AssessmentForms:"eca5fc07-e1bf-4325-8dec-5bff94d40925",UIControl_Note_Vitals:"7a048322-ab0e-45a1-91be-64b25276950c",UIControl_Note_ROS:"c16a0788-f5af-4b93-b23e-82ecd52aea52",UIControl_Note_Confidential:"56d27dff-e1cd-4428-b790-8d5738b020f5",UIControl_Note_Results:"a3aedf6d-720c-4da2-9b9a-945b8d490d37",UIControl_Note_CCHPI:"4f22cd53-53a7-4d55-8fde-a3d52561c817",UIControl_Note_RX:"79434f26-2cdd-48ad-9295-b03a3a5f02e9",UIControl_Note_ROSPE:"dbe463a3-ab72-44f2-9756-b07f0e1f853c",UIControl_Note_DX:"71ba0a7e-39e4-4e94-8edb-c364fe7f736b",UIControl_Note_DXDSM:"a3dfeab4-6579-4743-8873-f96311e07589",UIControl_Note_GeneralNote:"8b40d89b-3511-42a4-b07b-decadc72647e",UIControl_Note_SP:"5db71e56-0da7-4480-a277-e4f796cbff67",UIControl_Note_HX:"7eca6fd5-b1ca-408b-b073-f6feff45e8eb",PrimaryInsType_IsPrimary:"10101010-0000-7777-0000-000000000001",CHCSystemDefault:"10101010-0000-0000-1001-000000000001",DefaultOrderingProvider:"87ccdbcd-4df2-4212-a7dc-33006c98f92e",LanguageEnglish:"e76c7b0b-d485-4307-9921-b2f65c5ba718",LanguageSpanish:"311d2501-d8ca-45e5-a171-c7126b4fdd5c",ListClaimBatchStatus_InProgress:"37671b78-bec4-44cf-babc-5a60cfa25f50",ListClaimBatchStatus_ReadyToSend:"f4ae1494-47d5-4404-bb9d-d2ed4da9fba7",ListClaimBatchStatus_Sent:"08076914-83e5-48dd-9260-c56c5ec73412",ListClaimBatchStatus_Failed:"c1e377d7-7948-4473-a9d4-1038887b322b",DeclinedToSpecify:"4176e3b5-c69d-4df0-8d9b-2a059459d859",CallPointePerson:"af8f2184-6591-4df8-86be-e91ccf2506e7",NotificationMethodEmail:"d804e208-8525-459d-aa9d-613b174939b0",NotificationMethodMail:"6e5a8ab2-4779-4ab6-9a69-09a266da6ba0",NotificationMethodPhone:"262854e9-0dfa-46d8-a3b1-ac83cebda18a",NotificationMethodText:"c0edfc41-134b-49b1-b3ab-872def185a76",NotificationMethodUnknown:"79f84471-3104-48dc-9331-4cfa1e78c158",RecallTypeClinicalDecisionSupport:"a35165d7-78cc-4aac-b130-7f945a92c35f",RecallTypePatientsByCondition:"17eb9743-ac60-4c6f-b6c7-246983b9c69f",ListRuleMeasure_HEDIS:"86e6b8d1-a851-4f16-8c33-cfdedcc5c888",ListRuleMeasure_MUII_QRDA_Aggregate:"627c0740-381e-4c43-9db5-42cc66ba1969",ListRuleMeasure_MUII_QRDA_Aggregate_2014:"cf6ef5da-1cb0-4af3-ab1a-48444562ea2e",ListRuleMeasure_PQRS:"1c7684c7-fef4-48fd-9b3d-dee660a6e8f8",ListEligibilityStatusCannotProcess:"a9d72b1e-42fc-495e-ae92-74e6c68ffa6b",ListIntegrationPartnerSurescriptseRxServiceUid:"118422aa-c165-4a2e-8389-e5b7e89636ea",ListIntegrationPartnerSurescriptsDirectMessageUid:"4d1bc44b-31f5-4b41-8f50-a95047266ffc",ListIntegrationPartnerNitorDirectMessageWithCertificateUid:"8053bc8f-0bea-41da-8a2f-4fc7d6da65d5",ListIntegrationPartnereTacticsUid:"da11fe70-9b5a-4318-ae16-550ba170a9b3",ListIntegrationPartnerCommonWellUid:"01178549-2cef-462b-89b0-e41ea99ee57a",ListIntegrationPartnerCircleLinkUid:"60157d55-360b-4505-bb1a-f09e538826c9",ListIntegrationPartnerPersiviaUid:"c75bd792-315c-425f-8a01-7ba85510d616",TransmissionConfigurationSurescriptsDirectMessageUid:"55ef6d4c-23a2-4ecd-a4e9-b6cd6f8350f2",TransmissionConfigurationeRxOrganizationDirectoryUid:"1fd91627-0d23-43ac-a8db-cfca9ec19af0",TransmissionConfigurationeRxProviderDirectoryUid:"d081543c-8f64-4c66-85b0-955eb8f944d0",TransmissionConfigurationSurescriptsDirectMessageInboundUid:"1d370169-a34b-45ae-b029-b4ebeb549c4b",ClinicalDelgateSecurityCanCreateOrder:"5be7f005-87a8-4dfa-b2a8-7f01db80ab21",ClinicalDelgateSecurityCanCanCreatePrescription:"91012e30-80b9-4b68-a719-9e4f65dc606f",ClinicalDelgateSecurityCanSendDirectMail:"6247f22f-fbba-4949-ba3c-b44f4a5db747",ClinicalDelgateSecurityCanCompleteNote:"1b48ba6e-4799-4975-ab68-f7a91b85c0a6",ListRuleMeasureCcdaCcdDocumentTypeUid:"d2acb40b-b670-4283-b803-88e91f2a18d7",ListRuleMeasureC32CcdDocumentTypeUid:"3de2dbe0-f202-4d12-964f-aaf46bfaa347",ListRuleMeasureCcrDocumentTypeUid:"56b481a8-7947-4a65-8692-feb7519516e2",ListRuleMeasureCqmDocumentTypeUid:"627c0740-381e-4c43-9db5-42cc66ba1969",ProcedureNegationReasonUid:"cc03cd94-0f99-40fb-9c56-fc9649b416c3",ImmzRefusalOtherUid:"15655cf4-170f-4c4a-9dc0-e0cebf51c42b",ImmzRefusalParentalDecisionUid:"4d38e0be-33f4-478b-87b2-4239b508a81e",ImmzRefusalPatientDecisionUid:"f2facba0-29f1-42a2-b584-a8f07e4d2435",CdaSectionC32:"2cb025a2-3918-4988-8f78-5187897ade8e",CdaSectionCcda:"f1d05427-2c72-456a-a45b-a01b08728b5c",ABNNotRequiredUid:"dbf01d6f-5582-4f03-a3f2-23e137f9f9c0",ABNRequiredUid:"abfeae05-10b9-45ff-9139-14276f138790",ABNCompletedUid:"52045ae5-a3d2-49bc-8180-b690157954d7",FormTitleGeneric:"99999999-0000-0000-0000-000000000000",FormTitleFNC:"99999999-0000-0000-0000-000000000001",FormTitleDemographics:"99999999-0000-0000-0000-000000000002",PatientStatus_TestPatient:"77a41e18-5554-4874-9454-54dc3d7a33a0",PatientStatus_Transfer:"a2582df2-e663-4a79-9464-11da43f9bd53",PatientStatus_Deceased:"40bad38d-146f-4314-95fc-5388151a4f38",PatientStatus_Consult:"a83dd048-b972-4578-a21d-586b65d563ce",PatientStatus_Relocated:"785cc385-0635-47b7-a8c4-7717ca3bbddd",PatientStatus_Inactive:"ecea6163-dc76-4741-b6d0-9101037d2a0b",HMRULEPatientDeclineUid:"755dc7cc-affe-4da4-a2e5-1f050f3230c3",HMRULENoInsuranceUid:"85868f64-30b2-46e9-a22a-22ca00e916cf",HMRULENotNecessaryUid:"4088dace-5ac9-44dc-a428-24ce90cc417b",NegationReasonProcRefusedUid:"cc03cd94-0f99-40fb-9c56-fc9649b416c3",NegationReasonUninsuredUid:"c59fd3dd-684f-4f27-840d-f7c2538d1d4b",NegationReasonProcNotIndicatedUid:"533c24a6-a5f7-4e21-a449-d216420f4e02",AdultAgeGroupUid:"00000000-0000-0000-0000-000000000001",PediatricAgeGroupUid:"00000000-0000-0000-0000-000000000002",MedicalServicesProviderTypeHospice:"b502c7e7-226a-446d-89ad-1627bba55504",MedicalServicesProviderTypeInHome:"144b3ba7-e61c-49be-aaa7-9012317a9ca8",AddressType_Home:"a9b8c13f-822b-4f20-8f13-306db46a4c59",AddressType_Homeless:"c27fc3db-4071-4380-acf6-7672bb9521c9",AddressType_BirthPlace:"7c111fb1-6fa5-47cc-b888-34982b6d3bf1",PatientPortalMessageRoutingDefaultMessageSubTypeUid:"df0201ea-814b-4f2b-852a-8fef5834ed70",PatientPortalMessageRoutingDefaultServiceSiteUid:"9fab7f69-127e-4bc3-b0cd-df5de7c96e88",PatientPortalMessageRoutingDefaultProviderUid:"b4f160ea-f938-40e4-9c34-28bdd14952d2",PatientPortalDefaultMessageRoutingUid:"1e4a73da-6b53-41ad-b172-b5e29670dbb3",CCDABatchProcessTypeUid:"10000101-0000-0000-0000-000000000001",CQMBatchProcessTypeUid:"10000101-0000-0000-0000-000000000002",ClaimsBatchProcessTypeUid:"10000101-0000-0000-0000-000000000003",RemittanceBatchProcessTypeUid:"10000101-0000-0000-0000-000000000004",StatementsBatchProcessTypeUid:"10000101-0000-0000-0000-000000000005",CreditCardConsentsBatchProcessTypeUid:"10000101-0000-0000-0000-000000000006",BPatientChartsatchProcessTypeUid:"10000101-0000-0000-0000-000000000007",CancerRegistryBatchProcessTypeUid:"10000101-0000-0000-0000-000000000077",DpnGroupGenericNos:"4cae9a8d-baa8-4d5f-a6ad-1b628e575cc7",DpnNodePlanRecall:"2bd193b7-7904-4261-8073-4d5308ada0ee",DpnNodePlanPatientInstructions:"e4e7edd0-2b55-47de-a746-3cf134cecd1c",DpnNodePlanPlanNotes:"136cf736-82ff-44e0-8cbd-1a52f839aa1a",DpnNodePlanInternalNotes:"2552419f-81b6-41eb-8804-8b35652c9778"})}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("TileGroup",["_","AprimaCache",function(_,AprimaCache){var groupStates={userPreference:0,allExpanded:1,allCollapsed:2};return function(tileGroupName,config,storageType,disablePersistence){this.setupTile=function(tileId,defaultValue,forceDefault){var tile=tiles[tileId];tile&&!forceDefault||(tile=tiles[tileId]={isCollapsed:defaultValue});groupState===groupStates.allExpanded?tile.isCollapsed=!1:groupState===groupStates.allCollapsed?tile.isCollapsed=!0:groupState===groupStates.userPreference&&persist&&save();return tile},this.toggle=function(tileId){var tile=tiles[tileId];if(!tile)return;tile.isCollapsed=!tile.isCollapsed,groupState===groupStates.userPreference&&persist&&save()},this.nextState=function(){groupState=groupState!==groupStates.allCollapsed?groupState+1:groupStates.userPreference,updateTiles()},this.changeConfiguration=function(config){if(!config||configuration===config)return;configuration=config,updateTiles()},this.getName=function(){return name},this.setPersistence=function(enable){persist=!!enable};var name=tileGroupName,persist=!disablePersistence,configuration=config||"default",type="tileGroup",tiles={},groupState=groupStates.userPreference,cache=AprimaCache.getOrCreateOverride(type+"."+name,{storagePrefix:"caches."});persist&&cache.setStorageMode(storageType||"localStorage");function save(){return cache.put(configuration,tiles)}function updateTiles(){if(groupState!==groupStates.userPreference){var newValue=groupState===groupStates.allCollapsed;_.forEach(tiles,function(val){val.isCollapsed=newValue})}else _.merge(tiles,cache.get(configuration))}updateTiles()}}])}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("UrlParsingService",["$location","$q",function($location,$q){return{parsePortalUrl:function(marker){var url=$location.absUrl(),markerIndex=url.indexOf(marker),restOfUrlIndex=markerIndex+marker.length;if(0<markerIndex&&restOfUrlIndex<url.length){var hostUrl=url.substring(0,markerIndex),restOfUrl=url.substring(restOfUrlIndex),firstSlashIndex=restOfUrl.indexOf("/");if(0<firstSlashIndex){var clientId=restOfUrl.substring(0,firstSlashIndex),clientConfig={ClientId:clientId,HostUrl:hostUrl};return $q.when(clientConfig)}}return $q.reject()}}}])}(),angular.module("aprima-legacy-common").value("widgetViews",[{id:"259e6a7b-64a8-437c-82b7-000000000001",name:"allergies",displayName:"Allergies",userPlaceable:!0,view:"/patients/views/dashboard-widgets/allergiesTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000002",name:"appointments",displayName:"Appointments",userPlaceable:!0,view:"/patients/views/dashboard-widgets/appointmentsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000003",name:"demographics",displayName:"Demographics",userPlaceable:!0,view:"/patients/views/dashboard-widgets/demographicsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000004",name:"header",displayName:"Patient Header",userPlaceable:!1,view:"/patients/views/dashboard-widgets/patientHeaderTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000009",name:"problems",displayName:"Problem List",userPlaceable:!0,view:"/patients/views/dashboard-widgets/problemListTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000006",name:"medications",displayName:"Active Medications",userPlaceable:!0,view:"/patients/views/dashboard-widgets/medicationsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000012",name:"visits",displayName:"Visits",userPlaceable:!0,view:"/patients/views/dashboard-widgets/visitsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000010",name:"remarks",displayName:"Remarks",userPlaceable:!0,view:"/patients/views/dashboard-widgets/remarksTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000008",name:"orders",displayName:"Orders",userPlaceable:!0,view:"/patients/views/dashboard-widgets/ordersTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000007",name:"observationResults",displayName:"Observation Results",userPlaceable:!0,view:"/patients/views/dashboard-widgets/observationResultsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000011",name:"vitals",displayName:"Vitals",userPlaceable:!0,view:"/patients/views/dashboard-widgets/vitalsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000005",name:"healthMaintenanceReminders",displayName:"Health Reminders",userPlaceable:!0,view:"/patients/views/dashboard-widgets/healthMaintenanceRemindersTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000013",name:"attachments",displayName:"Attachments",userPlaceable:!0,view:"/patients/views/dashboard-widgets/attachmentsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000014",name:"observationValues",displayName:"Observation Values",userPlaceable:!0,view:"/patients/views/dashboard-widgets/observationValuesTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000015",name:"diagnosisSummaries",displayName:"Diagnosis Summaries",userPlaceable:!0,view:"/patients/views/dashboard-widgets/diagnosisSummariesTiles.html"},{id:"259e6a7b-64a8-437c-82b7-000000000016",name:"recalls",displayName:"Recalls",userPlaceable:!0,view:"/patients/views/dashboard-widgets/recallsTile.html"}]);
//# sourceMappingURL=aprima-legacy-common.min.js.map