DECLARE @dbname SYSNAME,
		@sql NVARCHAR (MAX)
SET @dbname = db_name ()

-- Enable change tracking for db
SET @sql = 
	--N'ALTER DATABASE ' + @dbname + CHAR (10) +
	--N'SET READ_COMMITTED_SNAPSHOT ON;' + CHAR (10) +
	N'IF NOT EXISTS (	SELECT *' + CHAR (10) +
	N'				FROM sys.databases' + CHAR (10) +
	N'				WHERE name = @pdbname AND snapshot_isolation_state <> 0' + CHAR (10) +
	N'			  )' + CHAR (10) +
	N'BEGIN' + CHAR (10) +
	N'ALTER DATABASE ' + QUOTENAME(@dbname) + CHAR (10) +
	N'SET ALLOW_SNAPSHOT_ISOLATION ON' + CHAR (10) +
	N'END;' + CHAR (10) +
	N'IF NOT EXISTS ( SELECT *' + CHAR (10) +
	N'				FROM sys.change_tracking_databases AS ctdb' + CHAR (10) +
	N'					INNER JOIN sys.databases as db ON ctdb.database_id = db.database_id' + CHAR (10) +
	N'				WHERE db.name = @pdbname' + CHAR (10) +
	N'			  )' + CHAR (10) +
	N'BEGIN' + CHAR (10) +
	N'	ALTER DATABASE ' + QUOTENAME(@dbname) + CHAR (10) +
	N'	SET CHANGE_TRACKING = ON' + CHAR (10) +
	N'	(CHANGE_RETENTION = 15 DAYS, AUTO_CLEANUP = ON);' + CHAR (10) +
	N'END;'

EXEC sp_executesql @sql, N'@pdbname sysname',
	@pdbname = @dbname
	
-- Enable change tracking on table
DECLARE @tableName SYSNAME,
		@is_track_columns_updated_on BIT

DECLARE CTE_CSR CURSOR FAST_FORWARD LOCAL FOR
WITH cteTables AS
(
	SELECT st.name AS TableName, st.object_id
	FROM sys.key_constraints AS kc
		INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu
			ON kc.type = 'PK' AND kc.name = kcu.CONSTRAINT_NAME
		INNER JOIN sys.tables AS st
			ON kc.parent_object_id = st.object_id
		INNER JOIN .sys.columns AS sc
			ON st.object_id = sc.object_id AND kcu.COLUMN_NAME = sc.name
	WHERE NOT (
			st.name LIKE 'Old%'
			OR st.name LIKE 'Temp%'
			OR st.name LIKE 'Tmp%'
			OR st.name LIKE 'cus[_]%'
			OR st.name LIKE 'Test[_]%'
			OR st.name LIKE '%[_]Test'
			OR st.name LIKE 'sys%' -- system tables
			OR st.name IN ('fdb_classification_ahfs',
			'ListeRxIdentificationQualifier',
			'PrescriptionSequentialNumber',
			'EZPAYBINTEST',
			'ReplicationHistory',
			'FDB_ETClassification_Drugs',
			'EZPAYCONNECTION_SETTINGS',
			'EZPAYSETTLEMENT_HISTORY',
			'fdb_packageddrug',
			'MasterFormularyProduct',
			'EZPAYERROR_CODES',
			'EZPAYSETTLEMENT_DETAILS',
			'ReplicationFilter',
			'EZPAYMERCHANT_SETTINGS',
			'FDB_Version',
			'Lock',
			'FDB_Classification_ETC',
			'JobNotification',
			'ReplicationQueue',
			'FDB_Disclaimer',
			'SuperbillAggregate',
			'JobHistory',
			'eRxPRVBRDOutbound',
			'FDB_DdImDrugLink',
			'fdb_extvocab_relateddxid',
			'FDB_DuplicateTherapy',
			'FDB_Ingredient',
			'fdb_dxid_relateddxid',
			'ListDBObjects',
			'FDB_PrecPreg_DrugLink',
			'FDB_Generic_DrugName',
			'fdb_medcondextvocablink',
			'FDB_PrecLact_DrugLink',
			'fdb_poemtext',
			'FDB_Monograph_Pem',
			'FDB_DrugValidation',
			'FDB_PrecGeri_DrugLink',
			'FDB_mnid_hicl',
			'fdb_ddcm',
			'VersionPRM',
			'fdb_poem_units',
			'FDB_DdImInteraction',
			'fdb_allergengroup',
			'FDB_Allergens',
			'fdb_poem_orderstring_addltext',
			'EMMapping',
			'SeedTable',
			'FDB_DtDrugLink',
			'HL7OrderSplitCategory',
			'fdb_dosetype',
			'FDB_PrecGeri',
			'FDB_Settings',
			'FDB_PrecPreg',
			'FDB_POEM',
			'Cms1500ClaimProcs',
			'FDB_PrecLact',
			'fdb_doseroute',
			'FDB_HicSeqNo_BaseIngredient',
			'FDB_GcnSeqNo_Pem',
			'fdb_medcond',
			'FDB_PrecPedi_DrugLink',
			'FDB_Language',
			'FDB_Classification_ETCSearch',
			'fdb_poem_default',
			'Cms1500Claim',
			'fdb_poem_orderstring',
			'fdb_poem_adminrates',
			'fdb_ddcmdruglink',
			'FDB_PrecPedi',
			'eRxFormularyDownload',
			'fdb_poem_doseformunits',
			'fdb_ahfsclassification_drugs',
			'FDB_CodeDefinition',
			'FDB_DamScreenInfo',
			'FDB_DamScreen',
			'FDB_Discreen',
			'Hl7Message',
			'ReplicationStatus',
			'RelCacheMachineAppointment',
			'RelCacheMachineMessage',
			'RelCacheMachinePatient'
			)
		  )
	GROUP BY st.name, st.object_id
)
SELECT st.TableName,
	ctt.is_track_columns_updated_on
FROM cteTables AS st
	LEFT OUTER JOIN sys.change_tracking_tables AS ctt ON st.object_id = ctt.object_id
WHERE ctt.object_id IS NULL

OPEN CTE_CSR
FETCH NEXT FROM CTE_CSR INTO @tableName, @is_track_columns_updated_on
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @sql =
		N'ALTER TABLE ' + QUOTENAME(@dbname) + N'..' + QUOTENAME(@tableName) + CHAR (10) +
		N'ENABLE CHANGE_TRACKING;'
	EXEC sp_executesql @sql
	FETCH NEXT FROM CTE_CSR INTO @tableName, @is_track_columns_updated_on
END
CLOSE CTE_CSR
DEALLOCATE CTE_CSR
