IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[IMO_ICD]') AND name = N'PK_AA_IMO_ICD')
ALTER TABLE [IMO_ICD] ADD  CONSTRAINT [PK_AA_IMO_ICD] PRIMARY KEY CLUSTERED 
(
	[ICD_GLOBAL_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[IMO_ICD_BASE_TEXT_TERMINATED]') AND name = N'PK_IMO_ICD_BASE_TEXT_TERMINATED')
ALTER TABLE [IMO_ICD_BASE_TEXT_TERMINATED] ADD  CONSTRAINT [PK_IMO_ICD_BASE_TEXT_TERMINATED] PRIMARY KEY CLUSTERED 
(
	[ICD_BASE_TEXT_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[IMO_ICD_MODIFIER]') AND name = N'PK_IMO_ICD_MODIFIER')
ALTER TABLE [IMO_ICD_MODIFIER] ADD  CONSTRAINT [PK_IMO_ICD_MODIFIER] PRIMARY KEY CLUSTERED 
(
	[ICD_MODIFIER_UID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[IMO_ICD_MODIFIER_MAP]') AND name = N'PK_AA_IMO_ICD_MODIFIER_MAP')
ALTER TABLE [IMO_ICD_MODIFIER_MAP] ADD  CONSTRAINT [PK_AA_IMO_ICD_MODIFIER_MAP] PRIMARY KEY CLUSTERED 
(
	[ICD_MODIFIER_MAP_UID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[IMO_ICD9]') AND name = N'PK_AA_IMO_ICD9')
ALTER TABLE [IMO_ICD9] ADD  CONSTRAINT [PK_AA_IMO_ICD9] PRIMARY KEY CLUSTERED 
(
	[ICD_IMO_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[IMO_ProblemIT_SearchResult_Base]') AND name = N'IMO_ProblemIT_SearchResult_Base.PK_IMO_ProblemIT_SearchResult_Base')
ALTER TABLE [IMO_ProblemIT_SearchResult_Base] ADD  CONSTRAINT [IMO_ProblemIT_SearchResult_Base.PK_IMO_ProblemIT_SearchResult_Base] PRIMARY KEY CLUSTERED 
(
	[LexCode] ASC,
	[Code10] ASC,
	[Code09] ASC,
	[Code10PrefBase] ASC,
	[Code09PrefBase] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[ListProductCommon]') AND name = N'PK_ListProductCommon')
ALTER TABLE [ListProductCommon] ADD  CONSTRAINT [PK_ListProductCommon] PRIMARY KEY CLUSTERED 
(
	[ProductCommonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[MASTER_MU2_InterfaceDataMapping]') AND name = N'PK_MASTER_MU2_InterfaceDataMapping1')
ALTER TABLE [MASTER_MU2_InterfaceDataMapping] ADD  CONSTRAINT [PK_MASTER_MU2_InterfaceDataMapping1] PRIMARY KEY CLUSTERED 
(
	[InterfaceDataMappingUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[MasterDiagnosis]') AND name = N'PK_MasterDiagnosisUid')
ALTER TABLE [MasterDiagnosis] ADD  CONSTRAINT [PK_MasterDiagnosisUid] PRIMARY KEY CLUSTERED 
(
	[MasterDiagnosisUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[MasterGrowthChart]') AND name = N'PK_MasterGrowthChart')
ALTER TABLE [MasterGrowthChart] ADD  CONSTRAINT [PK_MasterGrowthChart] PRIMARY KEY CLUSTERED 
(
	[MasterGrowthChartUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[MasterLoinc]') AND name = N'PK_MasterLoinc')
ALTER TABLE [MasterLoinc] ADD  CONSTRAINT [PK_MasterLoinc] PRIMARY KEY CLUSTERED 
(
	[MasterLoincUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_COPYRIGHT_INFO]') AND name = N'NDD_COPYRIGHT_INFO_PK')
ALTER TABLE [NDD_COPYRIGHT_INFO] ADD  CONSTRAINT [NDD_COPYRIGHT_INFO_PK] PRIMARY KEY CLUSTERED 
(
	[IsCurrentRow] DESC,
	[Copyright] DESC,
	[IsDelete] ASC,
	[Uid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_PRODUCT_INFO]') AND name = N'NDD_PRODUCT_INFO_PK')
ALTER TABLE [NDD_PRODUCT_INFO] ADD  CONSTRAINT [NDD_PRODUCT_INFO_PK] PRIMARY KEY CLUSTERED 
(
	[IsCurrentRow] DESC,
	[PRODUCTION_DATE] DESC,
	[IsDelete] ASC,
	[Uid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIDA0_DISPLAY_ACTION]') AND name = N'RADIDA0_PK')
ALTER TABLE [NDD_RADIDA0_DISPLAY_ACTION] ADD  CONSTRAINT [RADIDA0_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_DISPLAY_ACTION_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIDC0_DDI_DC_GCNSEQNO_SCREEN]') AND name = N'RADIDC0_PK')
ALTER TABLE [NDD_RADIDC0_DDI_DC_GCNSEQNO_SCREEN] ADD  CONSTRAINT [RADIDC0_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_MONOX] ASC,
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIGE0_DDI_GCNSEQNO_EXCEPT]') AND name = N'RADIGE0_PK')
ALTER TABLE [NDD_RADIGE0_DDI_GCNSEQNO_EXCEPT] ADD  CONSTRAINT [RADIGE0_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_MONOX] ASC,
	[SIDE_A_GCN_SEQNO] ASC,
	[SIDE_B_GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIMEF0_CLIN_EFFECT]') AND name = N'RADIMEF0_PK')
ALTER TABLE [NDD_RADIMEF0_CLIN_EFFECT] ADD  CONSTRAINT [RADIMEF0_PK] PRIMARY KEY CLUSTERED 
(
	[ADI_EFFTC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIMGC4_GCNSEQNO_LINK]') AND name = N'RADIMGC4_PK')
ALTER TABLE [NDD_RADIMGC4_GCNSEQNO_LINK] ADD  CONSTRAINT [RADIMGC4_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DDI_CODEX] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIMIE4_CLIN_EFFECTS_LINK]') AND name = N'RADIMIE4_PK')
ALTER TABLE [NDD_RADIMIE4_CLIN_EFFECTS_LINK] ADD  CONSTRAINT [RADIMIE4_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_CODEX] ASC,
	[ADI_EFFTC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIMM0_MONOX_MSTR]') AND name = N'RADIMM0_PK')
ALTER TABLE [NDD_RADIMM0_MONOX_MSTR] ADD  CONSTRAINT [RADIMM0_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_MONOX] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIMMA5_MSTR]') AND name = N'RADIMMA5_PK')
ALTER TABLE [NDD_RADIMMA5_MSTR] ADD  CONSTRAINT [RADIMMA5_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_CODEX] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIMMO5_MONO]') AND name = N'RADIMMO5_PK')
ALTER TABLE [NDD_RADIMMO5_MONO] ADD  CONSTRAINT [RADIMMO5_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_MONOX] ASC,
	[ADI_MONOSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIMSL1_SEVER_LEVEL]') AND name = N'RADIMSL1_PK')
ALTER TABLE [NDD_RADIMSL1_SEVER_LEVEL] ADD  CONSTRAINT [RADIMSL1_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_SL] ASC,
	[DDI_SLSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIRGE0_DDI_RTD_GEN_EXCEPT]') AND name = N'RADIRGE0_PK')
ALTER TABLE [NDD_RADIRGE0_DDI_RTD_GEN_EXCEPT] ADD  CONSTRAINT [RADIRGE0_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_MONOX] ASC,
	[SIDE_A_ROUTED_GEN_ID] ASC,
	[SIDE_B_ROUTED_GEN_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RADIRME0_DDI_RTD_MED_EXCEPT]') AND name = N'RADIRME0_PK')
ALTER TABLE [NDD_RADIRME0_DDI_RTD_MED_EXCEPT] ADD  CONSTRAINT [RADIRME0_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_MONOX] ASC,
	[SIDE_A_ROUTED_MED_ID] ASC,
	[SIDE_B_ROUTED_MED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RAHFSD1_DESC]') AND name = N'RAHFSD1_PK')
ALTER TABLE [NDD_RAHFSD1_DESC] ADD  CONSTRAINT [RAHFSD1_PK] PRIMARY KEY CLUSTERED 
(
	[AHFS8] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RAHFSGC1_GCNSEQNO_LINK]') AND name = N'RAHFSGC1_PK')
ALTER TABLE [NDD_RAHFSGC1_GCNSEQNO_LINK] ADD  CONSTRAINT [RAHFSGC1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[AHFS8] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RAPLR0_APPL_RELATION]') AND name = N'RAPLR0_PK')
ALTER TABLE [NDD_RAPLR0_APPL_RELATION] ADD  CONSTRAINT [RAPLR0_PK] PRIMARY KEY CLUSTERED 
(
	[APPL_RELATION_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RAPLRT0_APPL_RELATION_TYPE]') AND name = N'RAPLRT0_PK')
ALTER TABLE [NDD_RAPLRT0_APPL_RELATION_TYPE] ADD  CONSTRAINT [RAPLRT0_PK] PRIMARY KEY CLUSTERED 
(
	[APPL_RELATION_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RAPPLNA0_FDA_NDC_APPL]') AND name = N'RAPPLNA0_PK')
ALTER TABLE [NDD_RAPPLNA0_FDA_NDC_APPL] ADD  CONSTRAINT [RAPPLNA0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[APPL_NO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RAPPLSL0_FDA_NDC_NDA_ANDA]') AND name = N'RAPPLSL0_PK')
ALTER TABLE [NDD_RAPPLSL0_FDA_NDC_NDA_ANDA] ADD  CONSTRAINT [RAPPLSL0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RAPPLTD0_FDA_APPL_TYPE]') AND name = N'RAPPLTD0_PK')
ALTER TABLE [NDD_RAPPLTD0_FDA_APPL_TYPE] ADD  CONSTRAINT [RAPPLTD0_PK] PRIMARY KEY CLUSTERED 
(
	[APPL_TYPE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RATCD0_ATC_DESC]') AND name = N'RATCD0_PK')
ALTER TABLE [NDD_RATCD0_ATC_DESC] ADD  CONSTRAINT [RATCD0_PK] PRIMARY KEY CLUSTERED 
(
	[ATC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RATCGC0_ATC_GCNSEQNO_LINK]') AND name = N'RATCGC0_PK')
ALTER TABLE [NDD_RATCGC0_ATC_GCNSEQNO_LINK] ADD  CONSTRAINT [RATCGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[ATC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RCMMD0_DESC]') AND name = N'RCMMD0_PK')
ALTER TABLE [NDD_RCMMD0_DESC] ADD  CONSTRAINT [RCMMD0_PK] PRIMARY KEY CLUSTERED 
(
	[CMMC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RCMMGC0_GCNSEQNO_LINK]') AND name = N'RCMMGC0_PK')
ALTER TABLE [NDD_RCMMGC0_GCNSEQNO_LINK] ADD  CONSTRAINT [RCMMGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[CMMC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RCQDNDC0_DISP_CLNQTY_NDC]') AND name = N'RCQDNDC0_PK')
ALTER TABLE [NDD_RCQDNDC0_DISP_CLNQTY_NDC] ADD  CONSTRAINT [RCQDNDC0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RCQMED0_CLNQTY_MEDID]') AND name = N'RCQMED0_PK')
ALTER TABLE [NDD_RCQMED0_CLNQTY_MEDID] ADD  CONSTRAINT [RCQMED0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[MEDID_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RCQNDC0_CLNQTY_NDC]') AND name = N'RCQNDC0_PK')
ALTER TABLE [NDD_RCQNDC0_CLNQTY_NDC] ADD  CONSTRAINT [RCQNDC0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[MEDID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMAGD1_ALRGN_GRP_DESC]') AND name = N'RDAMAGD1_PK')
ALTER TABLE [NDD_RDAMAGD1_ALRGN_GRP_DESC] ADD  CONSTRAINT [RDAMAGD1_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_ALRGN_GRP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMAPM0_ALRGN_PICKLIST_MSTR]') AND name = N'RDAMAPM0_PK')
ALTER TABLE [NDD_RDAMAPM0_ALRGN_PICKLIST_MSTR] ADD  CONSTRAINT [RDAMAPM0_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_CONCEPT_ID] ASC,
	[DAM_CONCEPT_ID_TYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMCA0_CONCEPT]') AND name = N'RDAMCA0_PK')
ALTER TABLE [NDD_RDAMCA0_CONCEPT] ADD  CONSTRAINT [RDAMCA0_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_CONCEPT_ID] ASC,
	[DAM_CONCEPT_ID_TYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMCAS0_STATUS_DESC]') AND name = N'RDAMCAS0_PK')
ALTER TABLE [NDD_RDAMCAS0_STATUS_DESC] ADD  CONSTRAINT [RDAMCAS0_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_CONCEPT_STATUS_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMCD0_PICKLIST_CON_TYP_DESC]') AND name = N'RDAMCD0_PK')
ALTER TABLE [NDD_RDAMCD0_PICKLIST_CON_TYP_DESC] ADD  CONSTRAINT [RDAMCD0_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_CONCEPT_ID_TYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMCSD1_XSENSIT_ALLERGY_DESC]') AND name = N'RDAMCSD1_PK')
ALTER TABLE [NDD_RDAMCSD1_XSENSIT_ALLERGY_DESC] ADD  CONSTRAINT [RDAMCSD1_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_ALRGN_XSENSE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMGHC0_HIC_ALRGN_GRP_LINK]') AND name = N'RDAMGHC0_PK')
ALTER TABLE [NDD_RDAMGHC0_HIC_ALRGN_GRP_LINK] ADD  CONSTRAINT [RDAMGHC0_PK] PRIMARY KEY CLUSTERED 
(
	[HIC_SEQN] ASC,
	[DAM_ALRGN_GRP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMGRH0_ALRGN_GRP_HIST]') AND name = N'RDAMGRH0_PK')
ALTER TABLE [NDD_RDAMGRH0_ALRGN_GRP_HIST] ADD  CONSTRAINT [RDAMGRH0_PK] PRIMARY KEY CLUSTERED 
(
	[REPL_DAM_ALRGN_GRP] ASC,
	[PREV_DAM_ALRGN_GRP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMGSD0_GRP_STATUS_DESC]') AND name = N'RDAMGSD0_PK')
ALTER TABLE [NDD_RDAMGSD0_GRP_STATUS_DESC] ADD  CONSTRAINT [RDAMGSD0_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_ALRGN_GRP_STATUS_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMGX0_ALRGN_GRP_XSENSE_LINK]') AND name = N'RDAMGX0_PK')
ALTER TABLE [NDD_RDAMGX0_ALRGN_GRP_XSENSE_LINK] ADD  CONSTRAINT [RDAMGX0_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_ALRGN_GRP] ASC,
	[DAM_ALRGN_XSENSE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMHHA0_HIC_HICL_ALG_LINK]') AND name = N'RDAMHHA0_PK')
ALTER TABLE [NDD_RDAMHHA0_HIC_HICL_ALG_LINK] ADD  CONSTRAINT [RDAMHHA0_PK] PRIMARY KEY CLUSTERED 
(
	[HICL_SEQNO] ASC,
	[DAM_ALRGN_HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMXHC0_HIC_ALRGN_XSENSE_LINK]') AND name = N'RDAMXHC0_PK')
ALTER TABLE [NDD_RDAMXHC0_HIC_ALRGN_XSENSE_LINK] ADD  CONSTRAINT [RDAMXHC0_PK] PRIMARY KEY CLUSTERED 
(
	[HIC_SEQN] ASC,
	[DAM_ALRGN_XSENSE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMXSD0_XSENSE_STATUS_DESC]') AND name = N'RDAMXSD0_PK')
ALTER TABLE [NDD_RDAMXSD0_XSENSE_STATUS_DESC] ADD  CONSTRAINT [RDAMXSD0_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_ALRGN_XSENSE_STATUS_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDAMXSH0_ALRGN_XSENSE_HIST]') AND name = N'RDAMXSH0_PK')
ALTER TABLE [NDD_RDAMXSH0_ALRGN_XSENSE_HIST] ADD  CONSTRAINT [RDAMXSH0_PK] PRIMARY KEY CLUSTERED 
(
	[REPL_DAM_ALRGN_XSENSE] ASC,
	[PREV_DAM_ALRGN_XSENSE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDCCD0_DRUG_CAT_DESC]') AND name = N'RDCCD0_PK')
ALTER TABLE [NDD_RDCCD0_DRUG_CAT_DESC] ADD  CONSTRAINT [RDCCD0_PK] PRIMARY KEY CLUSTERED 
(
	[DCC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDCMDD0_CONTRA_DRUG_DESC]') AND name = N'RDDCMDD0_PK')
ALTER TABLE [NDD_RDDCMDD0_CONTRA_DRUG_DESC] ADD  CONSTRAINT [RDDCMDD0_PK] PRIMARY KEY CLUSTERED 
(
	[DDXCN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDCMGC0_CONTRA_GCNSEQNO_LINK]') AND name = N'RDDCMGC0_PK')
ALTER TABLE [NDD_RDDCMGC0_CONTRA_GCNSEQNO_LINK] ADD  CONSTRAINT [RDDCMGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DDXCN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDCMMA1_CONTRA_MSTR]') AND name = N'RDDCMMA1_PK')
ALTER TABLE [NDD_RDDCMMA1_CONTRA_MSTR] ADD  CONSTRAINT [RDDCMMA1_PK] PRIMARY KEY CLUSTERED 
(
	[DDXCN] ASC,
	[DDXCN_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDCMRG0_ROUTED_GEN_LINK]') AND name = N'RDDCMRG0_PK')
ALTER TABLE [NDD_RDDCMRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RDDCMRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[DDXCN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDCMRM0_ROUTED_MED_LINK]') AND name = N'RDDCMRM0_PK')
ALTER TABLE [NDD_RDDCMRM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RDDCMRM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[DDXCN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDCMSL0_SEVER_LEVEL]') AND name = N'RDDCMSL0_PK')
ALTER TABLE [NDD_RDDCMSL0_SEVER_LEVEL] ADD  CONSTRAINT [RDDCMSL0_PK] PRIMARY KEY CLUSTERED 
(
	[DDXCN_SL] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDIMAG0_AGENT]') AND name = N'RDDIMAG0_PK')
ALTER TABLE [NDD_RDDIMAG0_AGENT] ADD  CONSTRAINT [RDDIMAG0_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_CODEX] ASC,
	[DDI_AGSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDIMIN0_NDC_INACTV_DDIM_LINK]') AND name = N'RDDIMIN0_PK')
ALTER TABLE [NDD_RDDIMIN0_NDC_INACTV_DDIM_LINK] ADD  CONSTRAINT [RDDIMIN0_PK] PRIMARY KEY CLUSTERED 
(
	[DDI_NDC] ASC,
	[DDI_CODEX] ASC,
	[DDI_NDC_HICSEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDIMRD0_REF_CATEGORY]') AND name = N'RDDIMRD0_PK')
ALTER TABLE [NDD_RDDIMRD0_REF_CATEGORY] ADD  CONSTRAINT [RDDIMRD0_PK] PRIMARY KEY CLUSTERED 
(
	[IAMREFCAT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDIMRG0_ROUTED_GEN_LINK]') AND name = N'RDDIMRG0_PK')
ALTER TABLE [NDD_RDDIMRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RDDIMRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[DDI_CODEX] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDDIMRM0_ROUTED_MED_LINK]') AND name = N'RDDIMRM0_PK')
ALTER TABLE [NDD_RDDIMRM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RDDIMRM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[DDI_CODEX] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDFIMGC0_GCNSEQNO_LINK]') AND name = N'RDFIMGC0_PK')
ALTER TABLE [NDD_RDFIMGC0_GCNSEQNO_LINK] ADD  CONSTRAINT [RDFIMGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[FDCDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDFIMMA0_MSTR]') AND name = N'RDFIMMA0_PK')
ALTER TABLE [NDD_RDFIMMA0_MSTR] ADD  CONSTRAINT [RDFIMMA0_PK] PRIMARY KEY CLUSTERED 
(
	[FDCDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDFIMMO0_MONO]') AND name = N'RDFIMMO0_PK')
ALTER TABLE [NDD_RDFIMMO0_MONO] ADD  CONSTRAINT [RDFIMMO0_PK] PRIMARY KEY CLUSTERED 
(
	[FDCDE] ASC,
	[FDCDE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDFIMRG0_ROUTED_GEN_LINK]') AND name = N'RDFIMRG0_PK')
ALTER TABLE [NDD_RDFIMRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RDFIMRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[FDCDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDFIMRM0_ROUTED_MED_LINK]') AND name = N'RDFIMRM0_PK')
ALTER TABLE [NDD_RDFIMRM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RDFIMRM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[FDCDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMCR0_CLIN_REVIEW_STATUS]') AND name = N'RDLIMCR0_PK')
ALTER TABLE [NDD_RDLIMCR0_CLIN_REVIEW_STATUS] ADD  CONSTRAINT [RDLIMCR0_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_DRUG_ID] ASC,
	[DLIM_DRUG_ID_TYP_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMDD0_DOC_LEVEL_DESC]') AND name = N'RDLIMDD0_PK')
ALTER TABLE [NDD_RDLIMDD0_DOC_LEVEL_DESC] ADD  CONSTRAINT [RDLIMDD0_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_DOC_LEVEL_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMDI0_DRUG_GRP_ID]') AND name = N'RDLIMDI0_PK')
ALTER TABLE [NDD_RDLIMDI0_DRUG_GRP_ID] ADD  CONSTRAINT [RDLIMDI0_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_DRUG_GRP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMDR0_DRUG_ID_TYP_DESC]') AND name = N'RDLIMDR0_PK')
ALTER TABLE [NDD_RDLIMDR0_DRUG_ID_TYP_DESC] ADD  CONSTRAINT [RDLIMDR0_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_DRUG_ID_TYP_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMGC1_GCNSEQNO_DRUG_GROUP]') AND name = N'RDLIMGC1_PK')
ALTER TABLE [NDD_RDLIMGC1_GCNSEQNO_DRUG_GROUP] ADD  CONSTRAINT [RDLIMGC1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DLIM_DRUG_GRP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMID0_INTERFERENCE_TYP_DESC]') AND name = N'RDLIMID0_PK')
ALTER TABLE [NDD_RDLIMID0_INTERFERENCE_TYP_DESC] ADD  CONSTRAINT [RDLIMID0_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_INTER_TYP_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMMA1_LAB_INTERFERENCE_MSTR]') AND name = N'RDLIMMA1_PK')
ALTER TABLE [NDD_RDLIMMA1_LAB_INTERFERENCE_MSTR] ADD  CONSTRAINT [RDLIMMA1_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_DRUG_GRP_ID] ASC,
	[MTL_SPEC_LAB_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMMI0_MONO_ID]') AND name = N'RDLIMMI0_PK')
ALTER TABLE [NDD_RDLIMMI0_MONO_ID] ADD  CONSTRAINT [RDLIMMI0_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_MONOGRAPH_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMMO1_MONO]') AND name = N'RDLIMMO1_PK')
ALTER TABLE [NDD_RDLIMMO1_MONO] ADD  CONSTRAINT [RDLIMMO1_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_MONOGRAPH_ID] ASC,
	[DLIM_TEXT_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMRG0_ROUTED_GEN_LINK]') AND name = N'RDLIMRG0_PK')
ALTER TABLE [NDD_RDLIMRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RDLIMRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[DLIM_DRUG_GRP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMRM0_ROUTED_MED_DRUG_GROUP]') AND name = N'RDLIMRM0_PK')
ALTER TABLE [NDD_RDLIMRM0_ROUTED_MED_DRUG_GROUP] ADD  CONSTRAINT [RDLIMRM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[DLIM_DRUG_GRP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMSD0_STATUS_DESC]') AND name = N'RDLIMSD0_PK')
ALTER TABLE [NDD_RDLIMSD0_STATUS_DESC] ADD  CONSTRAINT [RDLIMSD0_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_STATUS_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDLIMTD0_MONO_TXT_TYP_DESC]') AND name = N'RDLIMTD0_PK')
ALTER TABLE [NDD_RDLIMTD0_MONO_TXT_TYP_DESC] ADD  CONSTRAINT [RDLIMTD0_PK] PRIMARY KEY CLUSTERED 
(
	[DLIM_TXT_TYP_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDOSED2_DOSE_DESC]') AND name = N'RDOSED2_PK')
ALTER TABLE [NDD_RDOSED2_DOSE_DESC] ADD  CONSTRAINT [RDOSED2_PK] PRIMARY KEY CLUSTERED 
(
	[GCDF] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDOSSRC0_DOSING_AGE_SOURCE]') AND name = N'RDOSSRC0_PK')
ALTER TABLE [NDD_RDOSSRC0_DOSING_AGE_SOURCE] ADD  CONSTRAINT [RDOSSRC0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSING_AGE_SOURCE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDPTCL0_CLASS_ID]') AND name = N'RDPTCL0_PK')
ALTER TABLE [NDD_RDPTCL0_CLASS_ID] ADD  CONSTRAINT [RDPTCL0_PK] PRIMARY KEY CLUSTERED 
(
	[DPT_CLASS_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDPTGC0_GCNSEQNO_LINK]') AND name = N'RDPTGC0_PK')
ALTER TABLE [NDD_RDPTGC0_GCNSEQNO_LINK] ADD  CONSTRAINT [RDPTGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DPT_CLASS_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDPTRG0_ROUTED_GEN_LINK]') AND name = N'RDPTRG0_PK')
ALTER TABLE [NDD_RDPTRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RDPTRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[DPT_CLASS_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDPTRTM0_ROUTED_MED_LINK]') AND name = N'RDPTRTM0_PK')
ALTER TABLE [NDD_RDPTRTM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RDPTRTM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[DPT_CLASS_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCAE0_AGE_EXCLUSION]') AND name = N'RDRCAE0_PK')
ALTER TABLE [NDD_RDRCAE0_AGE_EXCLUSION] ADD  CONSTRAINT [RDRCAE0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DR2_RT] ASC,
	[EXCLUSION_LOAGED] ASC,
	[EXCLUSION_HIAGED] ASC,
	[FDBDX] ASC,
	[DR2_DOSTPI] ASC,
	[NEOM_LOW_GEST_BIRTH_AGE_WEEKS] ASC,
	[NEOM_HIGH_GEST_BIRTH_AGE_WEEKS] ASC,
	[NEOM_LOW_CURRENT_WEIGHT_GRAMS] ASC,
	[NEOM_HIGH_CURRENT_WEIGHT_GRAMS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCAR0_EXCLUSION_REASON]') AND name = N'RDRCAR0_PK')
ALTER TABLE [NDD_RDRCAR0_EXCLUSION_REASON] ADD  CONSTRAINT [RDRCAR0_PK] PRIMARY KEY CLUSTERED 
(
	[EXCLUSION_REASON_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCAT0_ADJ_TYPE]') AND name = N'RDRCAT0_PK')
ALTER TABLE [NDD_RDRCAT0_ADJ_TYPE] ADD  CONSTRAINT [RDRCAT0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSING_ADJ_TYPE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCCD0_CALC_REQ_TYPE_DESC]') AND name = N'RDRCCD0_PK')
ALTER TABLE [NDD_RDRCCD0_CALC_REQ_TYPE_DESC] ADD  CONSTRAINT [RDRCCD0_PK] PRIMARY KEY CLUSTERED 
(
	[UNITS_CTYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCCVU0_UNITS_CONVERSION]') AND name = N'RDRCCVU0_PK')
ALTER TABLE [NDD_RDRCCVU0_UNITS_CONVERSION] ADD  CONSTRAINT [RDRCCVU0_PK] PRIMARY KEY CLUSTERED 
(
	[DCNV_PUI] ASC,
	[UNITS_RUI] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCDD0_DOSE_CALC_DESC]') AND name = N'RDRCDD0_PK')
ALTER TABLE [NDD_RDRCDD0_DOSE_CALC_DESC] ADD  CONSTRAINT [RDRCDD0_PK] PRIMARY KEY CLUSTERED 
(
	[UNITS_DCC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCDTD0_DOSE_TYPE_DESC]') AND name = N'RDRCDTD0_PK')
ALTER TABLE [NDD_RDRCDTD0_DOSE_TYPE_DESC] ADD  CONSTRAINT [RDRCDTD0_PK] PRIMARY KEY CLUSTERED 
(
	[DR2_DOSTPI] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCEX0_EXCLUSIONS]') AND name = N'RDRCEX0_PK')
ALTER TABLE [NDD_RDRCEX0_EXCLUSIONS] ADD  CONSTRAINT [RDRCEX0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCMA2_MSTR]') AND name = N'RDRCMA2_PK')
ALTER TABLE [NDD_RDRCMA2_MSTR] ADD  CONSTRAINT [RDRCMA2_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DR2_RT] ASC,
	[DR2_LOAGED] ASC,
	[DR2_HIAGED] ASC,
	[FDBDX] ASC,
	[DR2_DOSTPI] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCMD0_MATH_PROCESS_DESC]') AND name = N'RDRCMD0_PK')
ALTER TABLE [NDD_RDRCMD0_MATH_PROCESS_DESC] ADD  CONSTRAINT [RDRCMD0_PK] PRIMARY KEY CLUSTERED 
(
	[DCNV_MTHI] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCMF0_MONO_FORMAT_DESC]') AND name = N'RDRCMF0_PK')
ALTER TABLE [NDD_RDRCMF0_MONO_FORMAT_DESC] ADD  CONSTRAINT [RDRCMF0_PK] PRIMARY KEY CLUSTERED 
(
	[DRC_MONO_FORMAT_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCMS0_MONO_SECTION_DESC]') AND name = N'RDRCMS0_PK')
ALTER TABLE [NDD_RDRCMS0_MONO_SECTION_DESC] ADD  CONSTRAINT [RDRCMS0_PK] PRIMARY KEY CLUSTERED 
(
	[DRC_MONO_SECTION_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCNMA1_MSTR]') AND name = N'RDRCNMA1_PK')
ALTER TABLE [NDD_RDRCNMA1_MSTR] ADD  CONSTRAINT [RDRCNMA1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DR2_RT] ASC,
	[DR2_LOAGED] ASC,
	[DR2_HIAGED] ASC,
	[FDBDX] ASC,
	[DR2_DOSTPI] ASC,
	[NEOM_LOW_GEST_BIRTH_AGE_WEEKS] ASC,
	[NEOM_HIGH_GEST_BIRTH_AGE_WEEKS] ASC,
	[NEOM_LOW_CURRENT_WEIGHT_GRAMS] ASC,
	[NEOM_HIGH_CURRENT_WEIGHT_GRAMS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCNMA2_MSTR]') AND name = N'RDRCNMA2_PK')
ALTER TABLE [NDD_RDRCNMA2_MSTR] ADD  CONSTRAINT [RDRCNMA2_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DR2_RT] ASC,
	[DR2_LOAGED] ASC,
	[DR2_HIAGED] ASC,
	[FDBDX] ASC,
	[DR2_DOSTPI] ASC,
	[NEOM_LOW_GEST_BIRTH_AGE_WEEKS] ASC,
	[NEOM_HIGH_GEST_BIRTH_AGE_WEEKS] ASC,
	[LOW_CURRENT_WEIGHT_GRAMS] ASC,
	[HIGH_CURRENT_WEIGHT_GRAMS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCRL0_RENAL_MONO_LINE]') AND name = N'RDRCRL0_PK')
ALTER TABLE [NDD_RDRCRL0_RENAL_MONO_LINE] ADD  CONSTRAINT [RDRCRL0_PK] PRIMARY KEY CLUSTERED 
(
	[REN_MONO_ID] ASC,
	[REN_MONO_LINE_NUMBER] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCRM0_RENAL_MSTR]') AND name = N'RDRCRM0_PK')
ALTER TABLE [NDD_RDRCRM0_RENAL_MSTR] ADD  CONSTRAINT [RDRCRM0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DR2_RT] ASC,
	[REN_LOAGED] ASC,
	[REN_HIAGED] ASC,
	[FDBDX] ASC,
	[DR2_DOSTPI] ASC,
	[REN_LOCRCL] ASC,
	[REN_HICRCL] ASC,
	[REN_SORT_ORDER] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCRTD0_ROUTE_DESC]') AND name = N'RDRCRTD0_PK')
ALTER TABLE [NDD_RDRCRTD0_ROUTE_DESC] ADD  CONSTRAINT [RDRCRTD0_PK] PRIMARY KEY CLUSTERED 
(
	[DR2_RT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCSCD0_EXCLUSION_STATUS_DESC]') AND name = N'RDRCSCD0_PK')
ALTER TABLE [NDD_RDRCSCD0_EXCLUSION_STATUS_DESC] ADD  CONSTRAINT [RDRCSCD0_PK] PRIMARY KEY CLUSTERED 
(
	[EXCLUSION_STATUS_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCSD0_SEVER_LEVEL_DESC]') AND name = N'RDRCSD0_PK')
ALTER TABLE [NDD_RDRCSD0_SEVER_LEVEL_DESC] ADD  CONSTRAINT [RDRCSD0_PK] PRIMARY KEY CLUSTERED 
(
	[DR2_SL] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCUND0_UNITS_DESC]') AND name = N'RDRCUND0_PK')
ALTER TABLE [NDD_RDRCUND0_UNITS_DESC] ADD  CONSTRAINT [RDRCUND0_PK] PRIMARY KEY CLUSTERED 
(
	[DR2_UNITS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RDRCXRT0_XREF]') AND name = N'RDRCXRT0_PK')
ALTER TABLE [NDD_RDRCXRT0_XREF] ADD  CONSTRAINT [RDRCXRT0_PK] PRIMARY KEY CLUSTERED 
(
	[GCRT2] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCCTD0_ETC_CHANGE_TYPE_DESC]') AND name = N'RETCCTD0_PK')
ALTER TABLE [NDD_RETCCTD0_ETC_CHANGE_TYPE_DESC] ADD  CONSTRAINT [RETCCTD0_PK] PRIMARY KEY CLUSTERED 
(
	[ETC_CHANGE_TYPE_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCGC0_ETC_GCNSEQNO]') AND name = N'RETCGC0_PK')
ALTER TABLE [NDD_RETCGC0_ETC_GCNSEQNO] ADD  CONSTRAINT [RETCGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[ETC_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCGCH0_ETC_GCNSEQNO_HIST]') AND name = N'RETCGCH0_PK')
ALTER TABLE [NDD_RETCGCH0_ETC_GCNSEQNO_HIST] ADD  CONSTRAINT [RETCGCH0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[ETC_ID] ASC,
	[ETC_REVISION_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCHCH0_ETC_HICSEQN_HIST]') AND name = N'RETCHCH0_PK')
ALTER TABLE [NDD_RETCHCH0_ETC_HICSEQN_HIST] ADD  CONSTRAINT [RETCHCH0_PK] PRIMARY KEY CLUSTERED 
(
	[HIC_SEQN] ASC,
	[ETC_ID] ASC,
	[ETC_REVISION_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCHCL0_ETC_HICLSEQNO]') AND name = N'RETCHCL0_PK')
ALTER TABLE [NDD_RETCHCL0_ETC_HICLSEQNO] ADD  CONSTRAINT [RETCHCL0_PK] PRIMARY KEY CLUSTERED 
(
	[HICL_SEQNO] ASC,
	[ETC_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCHIC0_ETC_HICSEQN]') AND name = N'RETCHIC0_PK')
ALTER TABLE [NDD_RETCHIC0_ETC_HICSEQN] ADD  CONSTRAINT [RETCHIC0_PK] PRIMARY KEY CLUSTERED 
(
	[HIC_SEQN] ASC,
	[ETC_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCHLH0_ETC_HICLSEQNO_HIST]') AND name = N'RETCHLH0_PK')
ALTER TABLE [NDD_RETCHLH0_ETC_HICLSEQNO_HIST] ADD  CONSTRAINT [RETCHLH0_PK] PRIMARY KEY CLUSTERED 
(
	[HICL_SEQNO] ASC,
	[ETC_ID] ASC,
	[ETC_REVISION_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCMDH0_ETC_MEDID_HIST]') AND name = N'RETCMDH0_PK')
ALTER TABLE [NDD_RETCMDH0_ETC_MEDID_HIST] ADD  CONSTRAINT [RETCMDH0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[ETC_ID] ASC,
	[ETC_REVISION_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCMED0_ETC_MEDID]') AND name = N'RETCMED0_PK')
ALTER TABLE [NDD_RETCMED0_ETC_MEDID] ADD  CONSTRAINT [RETCMED0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[ETC_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCMNM0_ETC_MED_NAME_ID]') AND name = N'RETCMNM0_PK')
ALTER TABLE [NDD_RETCMNM0_ETC_MED_NAME_ID] ADD  CONSTRAINT [RETCMNM0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_ID] ASC,
	[ETC_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCNDC0_ETC_NDC]') AND name = N'RETCNDC0_PK')
ALTER TABLE [NDD_RETCNDC0_ETC_NDC] ADD  CONSTRAINT [RETCNDC0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[ETC_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCNDH0_ETC_NDC_HIST]') AND name = N'RETCNDH0_PK')
ALTER TABLE [NDD_RETCNDH0_ETC_NDC_HIST] ADD  CONSTRAINT [RETCNDH0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[ETC_ID] ASC,
	[ETC_REVISION_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCNMH0_ETC_MED_NAME_ID_HIST]') AND name = N'RETCNMH0_PK')
ALTER TABLE [NDD_RETCNMH0_ETC_MED_NAME_ID_HIST] ADD  CONSTRAINT [RETCNMH0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_ID] ASC,
	[ETC_ID] ASC,
	[ETC_REVISION_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCSCH0_ETC_SEARCH]') AND name = N'RETCSCH0_PK')
ALTER TABLE [NDD_RETCSCH0_ETC_SEARCH] ADD  CONSTRAINT [RETCSCH0_PK] PRIMARY KEY CLUSTERED 
(
	[ETC_SEARCH_ETC_ID] ASC,
	[ETC_PRODUCT_RELATED_ETC_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCTBL0_ETC_ID]') AND name = N'RETCTBL0_PK')
ALTER TABLE [NDD_RETCTBL0_ETC_ID] ADD  CONSTRAINT [RETCTBL0_PK] PRIMARY KEY CLUSTERED 
(
	[ETC_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RETCXRF0_ETC_HIC3_ETC]') AND name = N'RETCXRF0_PK')
ALTER TABLE [NDD_RETCXRF0_ETC_HIC3_ETC] ADD  CONSTRAINT [RETCXRF0_PK] PRIMARY KEY CLUSTERED 
(
	[ETC_ID] ASC,
	[HIC3_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDCD0_RXN_CONCEPT_DESC]') AND name = N'REVDCD0_PK')
ALTER TABLE [NDD_REVDCD0_RXN_CONCEPT_DESC] ADD  CONSTRAINT [REVDCD0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_RXN_CONCEPT_DESC_KEY] ASC,
	[EVD_RXN_SEQ_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDCM0_CVX_MVX_LINK]') AND name = N'REVDCM0_PK')
ALTER TABLE [NDD_REVDCM0_CVX_MVX_LINK] ADD  CONSTRAINT [REVDCM0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_CVX_CD] ASC,
	[EVD_MVX_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDCPT0_EXT_CPT_CVX_LINK]') AND name = N'REVDCPT0_PK')
ALTER TABLE [NDD_REVDCPT0_EXT_CPT_CVX_LINK] ADD  CONSTRAINT [REVDCPT0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_CPT_CD] ASC,
	[EVD_CVX_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDCS0_RXN_CONCEPT_SOURCE]') AND name = N'REVDCS0_PK')
ALTER TABLE [NDD_REVDCS0_RXN_CONCEPT_SOURCE] ADD  CONSTRAINT [REVDCS0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_RXN_CONCEPT_SOURCE_KEY] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDCVX0_EXT_VOCAB_CVX_DESC]') AND name = N'REVDCVX0_PK')
ALTER TABLE [NDD_REVDCVX0_EXT_VOCAB_CVX_DESC] ADD  CONSTRAINT [REVDCVX0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_CVX_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDEL0_EXT_VOCAB_LINK]') AND name = N'REVDEL0_PK')
ALTER TABLE [NDD_REVDEL0_EXT_VOCAB_LINK] ADD  CONSTRAINT [REVDEL0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_FDB_VOCAB_ID] ASC,
	[EVD_FDB_VOCAB_TYPE_ID] ASC,
	[EVD_EXT_VOCAB_ID] ASC,
	[EVD_EXT_VOCAB_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDEV0_EXT_VOCAB_DESC]') AND name = N'REVDEV0_PK')
ALTER TABLE [NDD_REVDEV0_EXT_VOCAB_DESC] ADD  CONSTRAINT [REVDEV0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_EXT_VOCAB_ID] ASC,
	[EVD_EXT_VOCAB_TYPE_ID] ASC,
	[EVD_SEQ_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDEVN0_EXT_VOCAB_NOTE]') AND name = N'REVDEVN0_PK')
ALTER TABLE [NDD_REVDEVN0_EXT_VOCAB_NOTE] ADD  CONSTRAINT [REVDEVN0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_EXT_VOCAB_ID] ASC,
	[EVD_EXT_VOCAB_TYPE_ID] ASC,
	[EVD_SEQ_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDLT0_LINK_TYPE_DESC]') AND name = N'REVDLT0_PK')
ALTER TABLE [NDD_REVDLT0_LINK_TYPE_DESC] ADD  CONSTRAINT [REVDLT0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_LINK_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDMVX0_EXT_VOCAB_MVX_DESC]') AND name = N'REVDMVX0_PK')
ALTER TABLE [NDD_REVDMVX0_EXT_VOCAB_MVX_DESC] ADD  CONSTRAINT [REVDMVX0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_MVX_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDNCM0_NDC_CVX_MVX_LINK]') AND name = N'REVDNCM0_PK')
ALTER TABLE [NDD_REVDNCM0_NDC_CVX_MVX_LINK] ADD  CONSTRAINT [REVDNCM0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDRC0_RXN_CONCEPT_MSTR]') AND name = N'REVDRC0_PK')
ALTER TABLE [NDD_REVDRC0_RXN_CONCEPT_MSTR] ADD  CONSTRAINT [REVDRC0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_RXN_RXCUI] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDRH0_RXCUI_REP_HIST]') AND name = N'REVDRH0_PK')
ALTER TABLE [NDD_REVDRH0_RXCUI_REP_HIST] ADD  CONSTRAINT [REVDRH0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_EXT_PREV_VOCAB_ID] ASC,
	[EVD_EXT_CHANGE_DT] ASC,
	[EVD_EXT_REP_VOCAB_ID] ASC,
	[EVD_EXT_ULT_REP_VOCAB_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDRHD0_RXCUI_REP_DESC]') AND name = N'REVDRHD0_PK')
ALTER TABLE [NDD_REVDRHD0_RXCUI_REP_DESC] ADD  CONSTRAINT [REVDRHD0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_EXT_PREV_VOCAB_ID] ASC,
	[EVD_EXT_CHANGE_DT] ASC,
	[EVD_EXT_SEQ_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDUR0_RXCUI_ULT_REPL]') AND name = N'REVDURO_PK')
ALTER TABLE [NDD_REVDUR0_RXCUI_ULT_REPL] ADD  CONSTRAINT [REVDURO_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_EXT_VOCAB_ID] ASC,
	[EVD_EXT_ULT_REP_VOCAB_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDUSE0_EXT_VOCAB_CVX_USAGE]') AND name = N'REVDUSE0_PK')
ALTER TABLE [NDD_REVDUSE0_EXT_VOCAB_CVX_USAGE] ADD  CONSTRAINT [REVDUSE0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_CVX_CD_USAGE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDVB0_CDC_VIS_LOOKUP]') AND name = N'REVDVB0_PK')
ALTER TABLE [NDD_REVDVB0_CDC_VIS_LOOKUP] ADD  CONSTRAINT [REVDVB0_PK] PRIMARY KEY CLUSTERED 
(
	[CDC_VIS_GDTI_DOCUMENT_CD] ASC,
	[CDC_VIS_FULLY_ENCODED_TEXT] ASC,
	[CDC_VIS_EDITION_DT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDVD0_VOCAB_DATA_VERSION]') AND name = N'REVDVD0_PK')
ALTER TABLE [NDD_REVDVD0_VOCAB_DATA_VERSION] ADD  CONSTRAINT [REVDVD0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_DATA_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDVG0_CDC_CVX_VG_LINK]') AND name = N'REVDVG0_PK')
ALTER TABLE [NDD_REVDVG0_CDC_CVX_VG_LINK] ADD  CONSTRAINT [REVDVG0_PK] PRIMARY KEY CLUSTERED 
(
	[CDC_DATA_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDVL0_CDC_CVX_VIS_LINK]') AND name = N'REVDVL0_PK')
ALTER TABLE [NDD_REVDVL0_CDC_CVX_VIS_LINK] ADD  CONSTRAINT [REVDVL0_PK] PRIMARY KEY CLUSTERED 
(
	[CDC_CVX_CD] ASC,
	[CDC_VIS_FULLY_ENCODED_TEXT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDVS0_SOURCE_DESC]') AND name = N'REVDVS0_PK')
ALTER TABLE [NDD_REVDVS0_SOURCE_DESC] ADD  CONSTRAINT [REVDVS0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_SOURCE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_REVDVT0_VOCAB_TYPE_DEF]') AND name = N'REVDVT0_PK')
ALTER TABLE [NDD_REVDVT0_VOCAB_TYPE_DEF] ADD  CONSTRAINT [REVDVT0_PK] PRIMARY KEY CLUSTERED 
(
	[EVD_VOCAB_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLCMD0_CLIN_MOD_DESC]') AND name = N'RFMLCMD0_PK')
ALTER TABLE [NDD_RFMLCMD0_CLIN_MOD_DESC] ADD  CONSTRAINT [RFMLCMD0_PK] PRIMARY KEY CLUSTERED 
(
	[FML_CLIN_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLCSD0_ICD_STATUS_DESC]') AND name = N'RFMLCSD0_PK')
ALTER TABLE [NDD_RFMLCSD0_ICD_STATUS_DESC] ADD  CONSTRAINT [RFMLCSD0_PK] PRIMARY KEY CLUSTERED 
(
	[ICD_STATUS_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLDDD0_DX_DURATION_DESC]') AND name = N'RFMLDDD0_PK')
ALTER TABLE [NDD_RFMLDDD0_DX_DURATION_DESC] ADD  CONSTRAINT [RFMLDDD0_PK] PRIMARY KEY CLUSTERED 
(
	[DXID_DISEASE_DURATION_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLDRH0_DXID_HIST]') AND name = N'RFMLDRH0_PK')
ALTER TABLE [NDD_RFMLDRH0_DXID_HIST] ADD  CONSTRAINT [RFMLDRH0_PK] PRIMARY KEY CLUSTERED 
(
	[FMLPRVDXID] ASC,
	[FMLREPDXID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLDSR0_DXID_SEARCH]') AND name = N'RFMLDSR0_PK')
ALTER TABLE [NDD_RFMLDSR0_DXID_SEARCH] ADD  CONSTRAINT [RFMLDSR0_PK] PRIMARY KEY CLUSTERED 
(
	[SEARCH_DXID] ASC,
	[RELATED_DXID] ASC,
	[FML_CLIN_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLDX0_DXID]') AND name = N'RFMLDX0_PK')
ALTER TABLE [NDD_RFMLDX0_DXID] ADD  CONSTRAINT [RFMLDX0_PK] PRIMARY KEY CLUSTERED 
(
	[DXID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLIAD0_ICD_ALL_DESC]') AND name = N'RFMLIAD0_PK')
ALTER TABLE [NDD_RFMLIAD0_ICD_ALL_DESC] ADD  CONSTRAINT [RFMLIAD0_PK] PRIMARY KEY CLUSTERED 
(
	[ICD_CD] ASC,
	[ICD_CD_TYPE] ASC,
	[ICD_DESC_SOURCE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLIBD0_ICD_BILLABLE_DESC]') AND name = N'RFMLIBD0_PK')
ALTER TABLE [NDD_RFMLIBD0_ICD_BILLABLE_DESC] ADD  CONSTRAINT [RFMLIBD0_PK] PRIMARY KEY CLUSTERED 
(
	[ICD_BILLABLE_IND] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLIBH0_ICD_BILLABLE_HIST]') AND name = N'RFMLIBH0_PK')
ALTER TABLE [NDD_RFMLIBH0_ICD_BILLABLE_HIST] ADD  CONSTRAINT [RFMLIBH0_PK] PRIMARY KEY CLUSTERED 
(
	[ICD_CD] ASC,
	[ICD_CD_TYPE] ASC,
	[ICD_FIRST_BILLABLE_DT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLINM1_ICD_DESC]') AND name = N'RFMLINM1_PK')
ALTER TABLE [NDD_RFMLINM1_ICD_DESC] ADD  CONSTRAINT [RFMLINM1_PK] PRIMARY KEY CLUSTERED 
(
	[ICD_CD] ASC,
	[ICD_CD_TYPE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLISD1_ICD_DESC_SOURCE_DESC]') AND name = N'RFMLISD1_PK')
ALTER TABLE [NDD_RFMLISD1_ICD_DESC_SOURCE_DESC] ADD  CONSTRAINT [RFMLISD1_PK] PRIMARY KEY CLUSTERED 
(
	[ICD_DESC_SOURCE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLISR1_ICD_SEARCH]') AND name = N'RFMLISR1_PK')
ALTER TABLE [NDD_RFMLISR1_ICD_SEARCH] ADD  CONSTRAINT [RFMLISR1_PK] PRIMARY KEY CLUSTERED 
(
	[SEARCH_ICD_CD] ASC,
	[ICD_CD_TYPE] ASC,
	[RELATED_DXID] ASC,
	[FML_CLIN_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLISX0_ICD_SEARCH_EXCLUSION]') AND name = N'RFMLISX0_PK')
ALTER TABLE [NDD_RFMLISX0_ICD_SEARCH_EXCLUSION] ADD  CONSTRAINT [RFMLISX0_PK] PRIMARY KEY CLUSTERED 
(
	[SEARCH_ICD_CD] ASC,
	[RELATED_DXID] ASC,
	[FML_CLIN_CODE] ASC,
	[ICD_CD_TYPE] ASC,
	[CLIN_DRUG_GROUP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLITD1_ICD_CD_TYPE_DESC]') AND name = N'RFMLITD1_PK')
ALTER TABLE [NDD_RFMLITD1_ICD_CD_TYPE_DESC] ADD  CONSTRAINT [RFMLITD1_PK] PRIMARY KEY CLUSTERED 
(
	[ICD_CD_TYPE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLNAV0_DXID_NAVIGATION]') AND name = N'RFMLNAV0_PK')
ALTER TABLE [NDD_RFMLNAV0_DXID_NAVIGATION] ADD  CONSTRAINT [RFMLNAV0_PK] PRIMARY KEY CLUSTERED 
(
	[DXID] ASC,
	[BROADER_DXID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLNVD0_NAVIGATION_DESC]') AND name = N'RFMLNVD0_PK')
ALTER TABLE [NDD_RFMLNVD0_NAVIGATION_DESC] ADD  CONSTRAINT [RFMLNVD0_PK] PRIMARY KEY CLUSTERED 
(
	[FML_NAV_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLSCD0_DXID_STATUS_DESC]') AND name = N'RFMLSCD0_PK')
ALTER TABLE [NDD_RFMLSCD0_DXID_STATUS_DESC] ADD  CONSTRAINT [RFMLSCD0_PK] PRIMARY KEY CLUSTERED 
(
	[DXID_STATUS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLSND0_SYN_NAME_TYPE_DESC]') AND name = N'RFMLSND0_PK')
ALTER TABLE [NDD_RFMLSND0_SYN_NAME_TYPE_DESC] ADD  CONSTRAINT [RFMLSND0_PK] PRIMARY KEY CLUSTERED 
(
	[DXID_SYN_NMTYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLSSD0_SYN_STATUS_DESC]') AND name = N'RFMLSSD0_PK')
ALTER TABLE [NDD_RFMLSSD0_SYN_STATUS_DESC] ADD  CONSTRAINT [RFMLSSD0_PK] PRIMARY KEY CLUSTERED 
(
	[DXID_SYN_STATUS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RFMLSYN0_DXID_SYN]') AND name = N'RFMLSYN0_PK')
ALTER TABLE [NDD_RFMLSYN0_DXID_SYN] ADD  CONSTRAINT [RFMLSYN0_PK] PRIMARY KEY CLUSTERED 
(
	[DXID_SYNID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGCN0_GCN_GCNSEQNO_LINK]') AND name = N'RGCN0_PK')
ALTER TABLE [NDD_RGCN0_GCN_GCNSEQNO_LINK] ADD  CONSTRAINT [RGCN0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[GCN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGCNINH0_GCNSEQNO_INACTV_LINK]') AND name = N'RGCNINH0_PK')
ALTER TABLE [NDD_RGCNINH0_GCNSEQNO_INACTV_LINK] ADD  CONSTRAINT [RGCNINH0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGCNINS0_STUDY_TABLE]') AND name = N'RGCNINS0_PK')
ALTER TABLE [NDD_RGCNINS0_STUDY_TABLE] ADD  CONSTRAINT [RGCNINS0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_PK')
ALTER TABLE [NDD_RGCNSEQ4_GCNSEQNO_MSTR] ADD  CONSTRAINT [RGCNSEQ4_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGCNSTR0_INGREDIENT_STRENGTH]') AND name = N'RGCNSTR0_PK')
ALTER TABLE [NDD_RGCNSTR0_INGREDIENT_STRENGTH] ADD  CONSTRAINT [RGCNSTR0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGERIGC0_GERI_GCNSEQNO_LINK]') AND name = N'RGERIGC0_PK')
ALTER TABLE [NDD_RGERIGC0_GERI_GCNSEQNO_LINK] ADD  CONSTRAINT [RGERIGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[GERI_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGERIMA1_GERI_MSTR]') AND name = N'RGERIMA1_PK')
ALTER TABLE [NDD_RGERIMA1_GERI_MSTR] ADD  CONSTRAINT [RGERIMA1_PK] PRIMARY KEY CLUSTERED 
(
	[GERI_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGERIRG0_ROUTED_GEN_LINK]') AND name = N'RGERIRG0_PK')
ALTER TABLE [NDD_RGERIRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RGERIRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[GERI_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGERIRM0_ROUTED_MED_LINK]') AND name = N'RGERIRM0_PK')
ALTER TABLE [NDD_RGERIRM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RGERIRM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[GERI_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGERISD0_GERI_SEVER_LEVEL_DESC]') AND name = N'RGERISD0_PK')
ALTER TABLE [NDD_RGERISD0_GERI_SEVER_LEVEL_DESC] ADD  CONSTRAINT [RGERISD0_PK] PRIMARY KEY CLUSTERED 
(
	[GERI_SL] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RGTCD0_GEN_THERAP_CLASS_DESC]') AND name = N'RGTCD0_PK')
ALTER TABLE [NDD_RGTCD0_GEN_THERAP_CLASS_DESC] ADD  CONSTRAINT [RGTCD0_PK] PRIMARY KEY CLUSTERED 
(
	[GTC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHIC1D2_HIC_ORGAN_SYS_DESC]') AND name = N'RHIC1D2_PK')
ALTER TABLE [NDD_RHIC1D2_HIC_ORGAN_SYS_DESC] ADD  CONSTRAINT [RHIC1D2_PK] PRIMARY KEY CLUSTERED 
(
	[HIC1_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHIC2D3_HIC_RX_CLASS_DESC]') AND name = N'RHIC2D3_PK')
ALTER TABLE [NDD_RHIC2D3_HIC_RX_CLASS_DESC] ADD  CONSTRAINT [RHIC2D3_PK] PRIMARY KEY CLUSTERED 
(
	[HIC2_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHIC3D3_HIC_THERAP_CLASS_DESC]') AND name = N'RHIC3D3_PK')
ALTER TABLE [NDD_RHIC3D3_HIC_THERAP_CLASS_DESC] ADD  CONSTRAINT [RHIC3D3_PK] PRIMARY KEY CLUSTERED 
(
	[HIC3_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHIC3L2_HIC3_HICLSEQNO_LINK]') AND name = N'RHIC3L2_PK')
ALTER TABLE [NDD_RHIC3L2_HIC3_HICLSEQNO_LINK] ADD  CONSTRAINT [RHIC3L2_PK] PRIMARY KEY CLUSTERED 
(
	[HICL_SEQNO] ASC,
	[HIC3_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHIC4D2_HIC_BASE_ING_DESC]') AND name = N'RHIC4D2_PK')
ALTER TABLE [NDD_RHIC4D2_HIC_BASE_ING_DESC] ADD  CONSTRAINT [RHIC4D2_PK] PRIMARY KEY CLUSTERED 
(
	[HIC4_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHICCAS1_HIC_CAS_LINK]') AND name = N'RHICCAS1_PK')
ALTER TABLE [NDD_RHICCAS1_HIC_CAS_LINK] ADD  CONSTRAINT [RHICCAS1_PK] PRIMARY KEY CLUSTERED 
(
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHICD5_HIC_DESC]') AND name = N'RHICD5_PK')
ALTER TABLE [NDD_RHICD5_HIC_DESC] ADD  CONSTRAINT [RHICD5_PK] PRIMARY KEY CLUSTERED 
(
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHICHCR0_HIC_HIC_LINK]') AND name = N'RHICHCR0_PK')
ALTER TABLE [NDD_RHICHCR0_HIC_HIC_LINK] ADD  CONSTRAINT [RHICHCR0_PK] PRIMARY KEY CLUSTERED 
(
	[HIC_SEQN] ASC,
	[RELATED_HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHICL1_HIC_HICLSEQNO_LINK]') AND name = N'RHICL1_PK')
ALTER TABLE [NDD_RHICL1_HIC_HICLSEQNO_LINK] ADD  CONSTRAINT [RHICL1_PK] PRIMARY KEY CLUSTERED 
(
	[HICL_SEQNO] ASC,
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHICLSQ1_HICLSEQNO_MSTR]') AND name = N'RHICLSQ1_PK')
ALTER TABLE [NDD_RHICLSQ1_HICLSEQNO_MSTR] ADD  CONSTRAINT [RHICLSQ1_PK] PRIMARY KEY CLUSTERED 
(
	[HICL_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHICLSQ2_HICLSEQNO_MSTR]') AND name = N'RHICLSQ2_PK')
ALTER TABLE [NDD_RHICLSQ2_HICLSEQNO_MSTR] ADD  CONSTRAINT [RHICLSQ2_PK] PRIMARY KEY CLUSTERED 
(
	[HICL_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHICRH0_ING_HIST]') AND name = N'RHICRH0_PK')
ALTER TABLE [NDD_RHICRH0_ING_HIST] ADD  CONSTRAINT [RHICRH0_PK] PRIMARY KEY CLUSTERED 
(
	[REPL_HIC_SEQN] ASC,
	[PREV_HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RHICSCD0_ING_STAT_CD_DESC]') AND name = N'RHICSCD0_PK')
ALTER TABLE [NDD_RHICSCD0_ING_STAT_CD_DESC] ADD  CONSTRAINT [RHICSCD0_PK] PRIMARY KEY CLUSTERED 
(
	[ING_STATUS_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RINDMDD0_INDCTS_DRUG_DESC]') AND name = N'RINDMDD0_PK')
ALTER TABLE [NDD_RINDMDD0_INDCTS_DRUG_DESC] ADD  CONSTRAINT [RINDMDD0_PK] PRIMARY KEY CLUSTERED 
(
	[INDCTS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RINDMGC0_INDCTS_GCNSEQNO_LINK]') AND name = N'RINDMGC0_PK')
ALTER TABLE [NDD_RINDMGC0_INDCTS_GCNSEQNO_LINK] ADD  CONSTRAINT [RINDMGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[INDCTS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RINDMLD0_LABELED_DESC]') AND name = N'RINDMLD0_PK')
ALTER TABLE [NDD_RINDMLD0_LABELED_DESC] ADD  CONSTRAINT [RINDMLD0_PK] PRIMARY KEY CLUSTERED 
(
	[INDCTS_LBL] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RINDMMA2_INDCTS_MSTR]') AND name = N'RINDMMA2_PK')
ALTER TABLE [NDD_RINDMMA2_INDCTS_MSTR] ADD  CONSTRAINT [RINDMMA2_PK] PRIMARY KEY CLUSTERED 
(
	[INDCTS] ASC,
	[INDCTS_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RINDMPD0_PREDICTOR_DESC]') AND name = N'RINDMPD0_PK')
ALTER TABLE [NDD_RINDMPD0_PREDICTOR_DESC] ADD  CONSTRAINT [RINDMPD0_PK] PRIMARY KEY CLUSTERED 
(
	[PRED_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RINDMRG0_ROUTED_GEN_LINK]') AND name = N'RINDMRG0_PK')
ALTER TABLE [NDD_RINDMRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RINDMRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[INDCTS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RINDMRM0_ROUTED_MED_LINK]') AND name = N'RINDMRM0_PK')
ALTER TABLE [NDD_RINDMRM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RINDMRM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[INDCTS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMACO0_ADMXTR_COMP_LINK]') AND name = N'RIVMACO0_PK')
ALTER TABLE [NDD_RIVMACO0_ADMXTR_COMP_LINK] ADD  CONSTRAINT [RIVMACO0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMADMIX] ASC,
	[IVMCOMP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMAMA0_ADMXTR_MSTR]') AND name = N'RIVMAMA0_PK')
ALTER TABLE [NDD_RIVMAMA0_ADMXTR_MSTR] ADD  CONSTRAINT [RIVMAMA0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMADMIX] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMCDS0_COMP_DESC]') AND name = N'RIVMCDS0_PK')
ALTER TABLE [NDD_RIVMCDS0_COMP_DESC] ADD  CONSTRAINT [RIVMCDS0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMCOMP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMCGC0_COMP_GCNSEQNO_LINK]') AND name = N'RIVMCGC0_PK')
ALTER TABLE [NDD_RIVMCGC0_COMP_GCNSEQNO_LINK] ADD  CONSTRAINT [RIVMCGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IVMCOMP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMMFG0_MANUFACTURER_DESC]') AND name = N'RIVMMFG0_PK')
ALTER TABLE [NDD_RIVMMFG0_MANUFACTURER_DESC] ADD  CONSTRAINT [RIVMMFG0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMMFG] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMRMK0_REMARKS]') AND name = N'RIVMRMK0_PK')
ALTER TABLE [NDD_RIVMRMK0_REMARKS] ADD  CONSTRAINT [RIVMRMK0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMRMK] ASC,
	[IVMRMKSEQ] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMSAD0_STDY_GRP_ADMXTR_LINK]') AND name = N'RIVMSAD0_PK')
ALTER TABLE [NDD_RIVMSAD0_STDY_GRP_ADMXTR_LINK] ADD  CONSTRAINT [RIVMSAD0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMSGRP] ASC,
	[IVMADMIX] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMSMA0_STDY_GRP_MSTR]') AND name = N'RIVMSMA0_PK')
ALTER TABLE [NDD_RIVMSMA0_STDY_GRP_MSTR] ADD  CONSTRAINT [RIVMSMA0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMSGRP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT]') AND name = N'RIVMTCO0_PK')
ALTER TABLE [NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT] ADD  CONSTRAINT [RIVMTCO0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMSGRP] ASC,
	[IVMTESTSN] ASC,
	[IVMADMIX] ASC,
	[IVMCOMP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMTMA0_STDY_GRP_TST_MSTR]') AND name = N'RIVMTMA0_PK')
ALTER TABLE [NDD_RIVMTMA0_STDY_GRP_TST_MSTR] ADD  CONSTRAINT [RIVMTMA0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMSGRP] ASC,
	[IVMTESTSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMTPI0_TPN_ING_DESC]') AND name = N'RIVMTPI0_PK')
ALTER TABLE [NDD_RIVMTPI0_TPN_ING_DESC] ADD  CONSTRAINT [RIVMTPI0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMCOMP] ASC,
	[IVMTPNINGR] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMTPN0_TPN_DESC]') AND name = N'RIVMTPN0_PK')
ALTER TABLE [NDD_RIVMTPN0_TPN_DESC] ADD  CONSTRAINT [RIVMTPN0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMCOMP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RIVMTRM0_STDY_GRP_TST_REMARK]') AND name = N'RIVMTRM0_PK')
ALTER TABLE [NDD_RIVMTRM0_STDY_GRP_TST_REMARK] ADD  CONSTRAINT [RIVMTRM0_PK] PRIMARY KEY CLUSTERED 
(
	[IVMSGRP] ASC,
	[IVMTESTSN] ASC,
	[IVMRMKSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLACTED0_EXCRT_POTENTIAL_DESC]') AND name = N'RLACTED0_PK')
ALTER TABLE [NDD_RLACTED0_EXCRT_POTENTIAL_DESC] ADD  CONSTRAINT [RLACTED0_PK] PRIMARY KEY CLUSTERED 
(
	[LACT_EXCRT] ASC,
	[LACT_EXCRTSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLACTGC0_LACT_GCNSEQNO_LINK]') AND name = N'RLACTGC0_PK')
ALTER TABLE [NDD_RLACTGC0_LACT_GCNSEQNO_LINK] ADD  CONSTRAINT [RLACTGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[LACT_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLACTID0_EFFECTS_INFANTS_DESC]') AND name = N'RLACTID0_PK')
ALTER TABLE [NDD_RLACTID0_EFFECTS_INFANTS_DESC] ADD  CONSTRAINT [RLACTID0_PK] PRIMARY KEY CLUSTERED 
(
	[LACT_LCTN] ASC,
	[LACT_LCTNSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLACTMA0_LACT_MSTR]') AND name = N'RLACTMA0_PK')
ALTER TABLE [NDD_RLACTMA0_LACT_MSTR] ADD  CONSTRAINT [RLACTMA0_PK] PRIMARY KEY CLUSTERED 
(
	[LACT_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLACTRG0_ROUTED_GEN_LINK]') AND name = N'RLACTRG0_PK')
ALTER TABLE [NDD_RLACTRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RLACTRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[LACT_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLACTRM0_ROUTED_MED_LINK]') AND name = N'RLACTRM0_PK')
ALTER TABLE [NDD_RLACTRM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RLACTRM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[LACT_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLACTSD0_SEVER_LEVEL_DESC]') AND name = N'RLACTSD0_PK')
ALTER TABLE [NDD_RLACTSD0_SEVER_LEVEL_DESC] ADD  CONSTRAINT [RLACTSD0_PK] PRIMARY KEY CLUSTERED 
(
	[LACT_SL] ASC,
	[LACT_SLSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLBLRID3_LBLR_DESC]') AND name = N'RLBLRID3_PK')
ALTER TABLE [NDD_RLBLRID3_LBLR_DESC] ADD  CONSTRAINT [RLBLRID3_PK] PRIMARY KEY CLUSTERED 
(
	[LBLRID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLBLWD0_DESC]') AND name = N'RLBLWD0_PK')
ALTER TABLE [NDD_RLBLWD0_DESC] ADD  CONSTRAINT [RLBLWD0_PK] PRIMARY KEY CLUSTERED 
(
	[LBL_WARN] ASC,
	[LBL_TEXTSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLBLWGC0_GCNSEQNO_LINK]') AND name = N'RLBLWGC0_PK')
ALTER TABLE [NDD_RLBLWGC0_GCNSEQNO_LINK] ADD  CONSTRAINT [RLBLWGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[LBL_WARN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLBLWV0_VENDOR_LINK]') AND name = N'RLBLWV0_PK')
ALTER TABLE [NDD_RLBLWV0_VENDOR_LINK] ADD  CONSTRAINT [RLBLWV0_PK] PRIMARY KEY CLUSTERED 
(
	[LBL_WARN] ASC,
	[LBLW_VTYPE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RLBLWVD0_VENDOR_TYPE_DESC]') AND name = N'RLBLWVD0_PK')
ALTER TABLE [NDD_RLBLWVD0_VENDOR_TYPE_DESC] ADD  CONSTRAINT [RLBLWVD0_PK] PRIMARY KEY CLUSTERED 
(
	[LBLW_VTYPE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDCD0_MED_CONCEPT_TYP_DESC]') AND name = N'RMEDCD0_PK')
ALTER TABLE [NDD_RMEDCD0_MED_CONCEPT_TYP_DESC] ADD  CONSTRAINT [RMEDCD0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_CONCEPT_ID_TYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDDIN0_RDFMID_INACTV_LINK]') AND name = N'RMEDDIN0_PK')
ALTER TABLE [NDD_RMEDDIN0_RDFMID_INACTV_LINK] ADD  CONSTRAINT [RMEDDIN0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC,
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDDIS0_ROUTED_DF_STUDY_TABLE]') AND name = N'RMEDDIS0_PK')
ALTER TABLE [NDD_RMEDDIS0_ROUTED_DF_STUDY_TABLE] ADD  CONSTRAINT [RMEDDIS0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDIN0_MEDID_INACTV_LINK]') AND name = N'RMEDIN0_PK')
ALTER TABLE [NDD_RMEDIN0_MEDID_INACTV_LINK] ADD  CONSTRAINT [RMEDIN0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDIS0_MEDID_STUDY_TABLE]') AND name = N'RMEDIS0_PK')
ALTER TABLE [NDD_RMEDIS0_MEDID_STUDY_TABLE] ADD  CONSTRAINT [RMEDIS0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDMGL0_MED_GENERIC_MED_LINK]') AND name = N'RMEDMGL0_PK')
ALTER TABLE [NDD_RMEDMGL0_MED_GENERIC_MED_LINK] ADD  CONSTRAINT [RMEDMGL0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_CONCEPT_ID] ASC,
	[MED_CONCEPT_ID_TYP] ASC,
	[GENERIC_MED_CONCEPT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDMHL0_MED_HICLSEQNO_LINK]') AND name = N'RMEDMHL0_PK')
ALTER TABLE [NDD_RMEDMHL0_MED_HICLSEQNO_LINK] ADD  CONSTRAINT [RMEDMHL0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_CONCEPT_ID] ASC,
	[MED_CONCEPT_ID_TYP] ASC,
	[HICL_SEQNO] ASC,
	[MED_CONCEPT_HICL_SRC_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDMRD0_MOVE_REASON_DESC]') AND name = N'RMEDMRD0_PK')
ALTER TABLE [NDD_RMEDMRD0_MOVE_REASON_DESC] ADD  CONSTRAINT [RMEDMRD0_PK] PRIMARY KEY CLUSTERED 
(
	[MOVE_REASON_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDNGH0_NDC_GEN_MEDID_HIST]') AND name = N'RMEDNGH0_PK')
ALTER TABLE [NDD_RMEDNGH0_NDC_GEN_MEDID_HIST] ADD  CONSTRAINT [RMEDNGH0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[PRODUCTION_DATE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDNGM0_NDC_GEN_MEDID]') AND name = N'RMEDNGM0_PK')
ALTER TABLE [NDD_RMEDNGM0_NDC_GEN_MEDID] ADD  CONSTRAINT [RMEDNGM0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDNGR0_NDC_GEN_MEDID_REASON]') AND name = N'RMEDNGR0_PK')
ALTER TABLE [NDD_RMEDNGR0_NDC_GEN_MEDID_REASON] ADD  CONSTRAINT [RMEDNGR0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[PRODUCTION_DATE] ASC,
	[MOVE_REASON_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDNIN0_MNID_INACTV_LINK]') AND name = N'RMEDNIN0_PK')
ALTER TABLE [NDD_RMEDNIN0_MNID_INACTV_LINK] ADD  CONSTRAINT [RMEDNIN0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_ID] ASC,
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDNIS0_MED_NAME_STUDY_TABLE]') AND name = N'RMEDNIS0_PK')
ALTER TABLE [NDD_RMEDNIS0_MED_NAME_STUDY_TABLE] ADD  CONSTRAINT [RMEDNIS0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDNMH0_NDC_MEDID_HIST]') AND name = N'RMEDNMH0_PK')
ALTER TABLE [NDD_RMEDNMH0_NDC_MEDID_HIST] ADD  CONSTRAINT [RMEDNMH0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[PRODUCTION_DATE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDNMR0_NDC_MEDID_REASON]') AND name = N'RMEDNMR0_PK')
ALTER TABLE [NDD_RMEDNMR0_NDC_MEDID_REASON] ADD  CONSTRAINT [RMEDNMR0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[PRODUCTION_DATE] ASC,
	[MOVE_REASON_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDRIN0_RMID_INACTV_LINK]') AND name = N'RMEDRIN0_PK')
ALTER TABLE [NDD_RMEDRIN0_RMID_INACTV_LINK] ADD  CONSTRAINT [RMEDRIN0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDRIS0_ROUTED_MED_STDY_TBL]') AND name = N'RMEDRIS0_PK')
ALTER TABLE [NDD_RMEDRIS0_ROUTED_MED_STDY_TBL] ADD  CONSTRAINT [RMEDRIS0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDST0_MEDID_SEARCH_TERM]') AND name = N'RMEDST0_PK')
ALTER TABLE [NDD_RMEDST0_MEDID_SEARCH_TERM] ADD  CONSTRAINT [RMEDST0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[SEARCH_TERM_TYPE_CD] ASC,
	[SEARCH_TERM_TEXT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMEDSTD0_SEARCH_TERM_TYPE_DESC]') AND name = N'RMEDSTD0_PK')
ALTER TABLE [NDD_RMEDSTD0_SEARCH_TERM_TYPE_DESC] ADD  CONSTRAINT [RMEDSTD0_PK] PRIMARY KEY CLUSTERED 
(
	[SEARCH_TERM_TYPE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIDE2D1_REF_DESI2_IND_DESC]') AND name = N'RMIDE2D1_PK')
ALTER TABLE [NDD_RMIDE2D1_REF_DESI2_IND_DESC] ADD  CONSTRAINT [RMIDE2D1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_DESI2_IND] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIDEAD1_REF_FED_DEA_DESC]') AND name = N'RMIDEAD1_PK')
ALTER TABLE [NDD_RMIDEAD1_REF_FED_DEA_DESC] ADD  CONSTRAINT [RMIDEAD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_DEA_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIDESD1_REF_DESI_IND_DESC]') AND name = N'RMIDESD1_PK')
ALTER TABLE [NDD_RMIDESD1_REF_DESI_IND_DESC] ADD  CONSTRAINT [RMIDESD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_DESI_IND] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIDFD1_DOSE_FORM]') AND name = N'RMIDFD1_PK')
ALTER TABLE [NDD_RMIDFD1_DOSE_FORM] ADD  CONSTRAINT [RMIDFD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_DOSAGE_FORM_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]') AND name = N'RMIDFID1_PK')
ALTER TABLE [NDD_RMIDFID1_ROUTED_DOSE_FORM_MED] ADD  CONSTRAINT [RMIDFID1_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIDFRH1_ROUTED_DOSE_FORM_HIST]') AND name = N'RMIDFRH1_PK')
ALTER TABLE [NDD_RMIDFRH1_ROUTED_DOSE_FORM_HIST] ADD  CONSTRAINT [RMIDFRH1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REPL_ROUTED_DF_MED_ID] ASC,
	[MED_PREV_ROUTED_DF_MED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIGC1_MEDID_GCNSEQNO_LINK]') AND name = N'RMIGC1_PK')
ALTER TABLE [NDD_RMIGC1_MEDID_GCNSEQNO_LINK] ADD  CONSTRAINT [RMIGC1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIGCND1_GCNSEQNO_ASSGN_DESC]') AND name = N'RMIGCND1_PK')
ALTER TABLE [NDD_RMIGCND1_GCNSEQNO_ASSGN_DESC] ADD  CONSTRAINT [RMIGCND1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_GCNSEQNO_ASSIGN_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIGECD1_REF_GEN_THERAP_DESC]') AND name = N'RMIGECD1_PK')
ALTER TABLE [NDD_RMIGECD1_REF_GEN_THERAP_DESC] ADD  CONSTRAINT [RMIGECD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_GEN_THERA_EQU_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIGNCD1_REF_GEN_NAME_DESC]') AND name = N'RMIGNCD1_PK')
ALTER TABLE [NDD_RMIGNCD1_REF_GEN_NAME_DESC] ADD  CONSTRAINT [RMIGNCD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_GEN_DRUG_NAME_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIGPCD1_REF_GEN_PRC_DESC]') AND name = N'RMIGPCD1_PK')
ALTER TABLE [NDD_RMIGPCD1_REF_GEN_PRC_DESC] ADD  CONSTRAINT [RMIGPCD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_GEN_COMP_PRICE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIGSCD1_REF_GEN_PRC_SPRD_DESC]') AND name = N'RMIGSCD1_PK')
ALTER TABLE [NDD_RMIGSCD1_REF_GEN_PRC_SPRD_DESC] ADD  CONSTRAINT [RMIGSCD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_GEN_SPREAD_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIID1_MED]') AND name = N'RMIID1_PK')
ALTER TABLE [NDD_RMIID1_MED] ADD  CONSTRAINT [RMIID1_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIINND1_REF_INNOV_IND_DESC]') AND name = N'RMIINND1_PK')
ALTER TABLE [NDD_RMIINND1_REF_INNOV_IND_DESC] ADD  CONSTRAINT [RMIINND1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_INNOV_IND] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMILGND1_REF_FED_LGND_DESC]') AND name = N'RMILGND1_PK')
ALTER TABLE [NDD_RMILGND1_REF_FED_LGND_DESC] ADD  CONSTRAINT [RMILGND1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_FED_LEGEND_IND] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIMLTD1_REF_MULTI_SRC_DESC]') AND name = N'RMIMLTD1_PK')
ALTER TABLE [NDD_RMIMLTD1_REF_MULTI_SRC_DESC] ADD  CONSTRAINT [RMIMLTD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REF_MULTI_SOURCE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMINAMD1_NAME_SRC_DESC]') AND name = N'RMINAMD1_PK')
ALTER TABLE [NDD_RMINAMD1_NAME_SRC_DESC] ADD  CONSTRAINT [RMINAMD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_SOURCE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMINDC1_NDC_MEDID]') AND name = N'RMINDC1_PK')
ALTER TABLE [NDD_RMINDC1_NDC_MEDID] ADD  CONSTRAINT [RMINDC1_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMINMD1_MED_NAME_TYPE_DESC]') AND name = N'RMINMD1_PK')
ALTER TABLE [NDD_RMINMD1_MED_NAME_TYPE_DESC] ADD  CONSTRAINT [RMINMD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_TYPE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMINMID1_MED_NAME]') AND name = N'RMINMID1_PK')
ALTER TABLE [NDD_RMINMID1_MED_NAME] ADD  CONSTRAINT [RMINMID1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMINMRH1_MED_NAME_HIST]') AND name = N'RMINMRH1_PK')
ALTER TABLE [NDD_RMINMRH1_MED_NAME_HIST] ADD  CONSTRAINT [RMINMRH1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REPL_NAME_ID] ASC,
	[MED_PREV_NAME_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIRH1_MED_HIST]') AND name = N'RMIRH1_PK')
ALTER TABLE [NDD_RMIRH1_MED_HIST] ADD  CONSTRAINT [RMIRH1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REPL_MEDID] ASC,
	[MED_PREV_MEDID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIRMID1_ROUTED_MED]') AND name = N'RMIRMID1_PK')
ALTER TABLE [NDD_RMIRMID1_ROUTED_MED] ADD  CONSTRAINT [RMIRMID1_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIRMRH1_ROUTED_MED_HIST]') AND name = N'RMIRMRH1_PK')
ALTER TABLE [NDD_RMIRMRH1_ROUTED_MED_HIST] ADD  CONSTRAINT [RMIRMRH1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_REPL_ROUTED_MED_ID] ASC,
	[MED_PREV_ROUTED_MED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMIRTD1_ROUTE]') AND name = N'RMIRTD1_PK')
ALTER TABLE [NDD_RMIRTD1_ROUTE] ADD  CONSTRAINT [RMIRTD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_ROUTE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMISCD1_STATUS_DESC]') AND name = N'RMISCD1_PK')
ALTER TABLE [NDD_RMISCD1_STATUS_DESC] ADD  CONSTRAINT [RMISCD1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_STATUS_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMMADMA1_ADULT_DOSE_MSTR]') AND name = N'RMMADMA1_PK')
ALTER TABLE [NDD_RMMADMA1_ADULT_DOSE_MSTR] ADD  CONSTRAINT [RMMADMA1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMMARMA0_ADULT_RANGE_MSTR]') AND name = N'RMMARMA0_PK')
ALTER TABLE [NDD_RMMARMA0_ADULT_RANGE_MSTR] ADD  CONSTRAINT [RMMARMA0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMMGDMA1_GERI_DOSE_MSTR]') AND name = N'RMMGDMA1_PK')
ALTER TABLE [NDD_RMMGDMA1_GERI_DOSE_MSTR] ADD  CONSTRAINT [RMMGDMA1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMMGRMA1_GERI_RANGE_MSTR]') AND name = N'RMMGRMA1_PK')
ALTER TABLE [NDD_RMMGRMA1_GERI_RANGE_MSTR] ADD  CONSTRAINT [RMMGRMA1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMMSRC0_DOSING_AGE_SOURCE]') AND name = N'RMMSRC0_PK')
ALTER TABLE [NDD_RMMSRC0_DOSING_AGE_SOURCE] ADD  CONSTRAINT [RMMSRC0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSING_AGE_SOURCE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLAID0_ANALYTE_ID]') AND name = N'RMTLAID0_PK')
ALTER TABLE [NDD_RMTLAID0_ANALYTE_ID] ADD  CONSTRAINT [RMTLAID0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_ANALYTE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLEVL0_EXT_VOCAB_LINK]') AND name = N'RMTLEVL0_PK')
ALTER TABLE [NDD_RMTLEVL0_EXT_VOCAB_LINK] ADD  CONSTRAINT [RMTLEVL0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_EXTRN_VOCAB_TYP_CODE] ASC,
	[MTL_EXTRN_VOCAB_CODE] ASC,
	[MTL_FDB_ID_TYP_CODE] ASC,
	[MTL_FDB_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLITD0_FDB_ID_TYP_DESC]') AND name = N'RMTLITD0_PK')
ALTER TABLE [NDD_RMTLITD0_FDB_ID_TYP_DESC] ADD  CONSTRAINT [RMTLITD0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_FDB_ID_TYP_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLLAB0_LAB_ID]') AND name = N'RMTLLAB0_PK')
ALTER TABLE [NDD_RMTLLAB0_LAB_ID] ADD  CONSTRAINT [RMTLLAB0_PK] PRIMARY KEY CLUSTERED 
(
	[LAB_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLLRH0_LAB_ID_HIST]') AND name = N'RMTLLRH0_PK')
ALTER TABLE [NDD_RMTLLRH0_LAB_ID_HIST] ADD  CONSTRAINT [RMTLLRH0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_PREV_LAB_ID] ASC,
	[MTL_REPL_LAB_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLLSD0_LAB_ID_STATUS_DESC]') AND name = N'RMTLLSD0_PK')
ALTER TABLE [NDD_RMTLLSD0_LAB_ID_STATUS_DESC] ADD  CONSTRAINT [RMTLLSD0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_LAB_ID_STATUS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLMID0_METHODOLOGY_ID]') AND name = N'RMTLMID0_PK')
ALTER TABLE [NDD_RMTLMID0_METHODOLOGY_ID] ADD  CONSTRAINT [RMTLMID0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_METHOD_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLPID0_PANEL_ID]') AND name = N'RMTLPID0_PK')
ALTER TABLE [NDD_RMTLPID0_PANEL_ID] ADD  CONSTRAINT [RMTLPID0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_PANEL_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLPLB0_PANEL_LABID_LINK]') AND name = N'RMTLPLB0_PK')
ALTER TABLE [NDD_RMTLPLB0_PANEL_LABID_LINK] ADD  CONSTRAINT [RMTLPLB0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_PANEL_ID] ASC,
	[LAB_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLPRH0_PANEL_ID_HIST]') AND name = N'RMTLPRH0_PK')
ALTER TABLE [NDD_RMTLPRH0_PANEL_ID_HIST] ADD  CONSTRAINT [RMTLPRH0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_PREV_PANEL_ID] ASC,
	[MTL_REPL_PANEL_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLPSD0_PANEL_ID_STATUS_DESC]') AND name = N'RMTLPSD0_PK')
ALTER TABLE [NDD_RMTLPSD0_PANEL_ID_STATUS_DESC] ADD  CONSTRAINT [RMTLPSD0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_PANEL_ID_STATUS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLSCD0_SPEC_LAB_STATUS_DESC]') AND name = N'RMTLSCD0_PK')
ALTER TABLE [NDD_RMTLSCD0_SPEC_LAB_STATUS_DESC] ADD  CONSTRAINT [RMTLSCD0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_SPEC_LAB_ID_STATUS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLSID0_SPECIMEN_ID]') AND name = N'RMTLSID0_PK')
ALTER TABLE [NDD_RMTLSID0_SPECIMEN_ID] ADD  CONSTRAINT [RMTLSID0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_SPECIMEN_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLSLT0_SPECIFIC_LAB_ID]') AND name = N'RMTLSLT0_PK')
ALTER TABLE [NDD_RMTLSLT0_SPECIFIC_LAB_ID] ADD  CONSTRAINT [RMTLSLT0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_SPEC_LAB_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLSND0_LAB_ID_SYN_NMTYP_DESC]') AND name = N'RMTLSND0_PK')
ALTER TABLE [NDD_RMTLSND0_LAB_ID_SYN_NMTYP_DESC] ADD  CONSTRAINT [RMTLSND0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_LAB_ID_SYN_NMTYP_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLSRH0_SPECIFIC_LAB_ID_HIST]') AND name = N'RMTLSRH0_PK')
ALTER TABLE [NDD_RMTLSRH0_SPECIFIC_LAB_ID_HIST] ADD  CONSTRAINT [RMTLSRH0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_PREV_SPEC_LAB_ID] ASC,
	[MTL_REPL_SPEC_LAB_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLSSD0_LABID_SYN_STATUS_DESC]') AND name = N'RMTLSSD0_PK')
ALTER TABLE [NDD_RMTLSSD0_LABID_SYN_STATUS_DESC] ADD  CONSTRAINT [RMTLSSD0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_LAB_ID_SYN_STATUS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLSYN0_LAB_ID_SYN]') AND name = N'RMTLSYN0_PK')
ALTER TABLE [NDD_RMTLSYN0_LAB_ID_SYN] ADD  CONSTRAINT [RMTLSYN0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_LAB_ID_SYNID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RMTLVTD0_EXT_VOCAB_TYP_DESC]') AND name = N'RMTLVTD0_PK')
ALTER TABLE [NDD_RMTLVTD0_EXT_VOCAB_TYP_DESC] ADD  CONSTRAINT [RMTLVTD0_PK] PRIMARY KEY CLUSTERED 
(
	[MTL_EXTRN_VOCAB_TYP_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RNDC14_NDC_MSTR]') AND name = N'RNDC14_PK')
ALTER TABLE [NDD_RNDC14_NDC_MSTR] ADD  CONSTRAINT [RNDC14_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RNDCAT0_NDC_ATTRIBUTE]') AND name = N'RNDCAT0_PK')
ALTER TABLE [NDD_RNDCAT0_NDC_ATTRIBUTE] ADD  CONSTRAINT [RNDCAT0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[NDC_ATTRIBUTE_TYPE_CD] ASC,
	[NDC_ATTRIBUTE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RNDCDR0_NDC_DELETION_REASON]') AND name = N'RNDCDR0_PK')
ALTER TABLE [NDD_RNDCDR0_NDC_DELETION_REASON] ADD  CONSTRAINT [RNDCDR0_PK] PRIMARY KEY CLUSTERED 
(
	[FDB_PRODUCT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RNDCINH0_NDC_INACTV_LINK]') AND name = N'RNDCINH0_PK')
ALTER TABLE [NDD_RNDCINH0_NDC_INACTV_LINK] ADD  CONSTRAINT [RNDCINH0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RNDCINR0_INACTV_REVIEWED]') AND name = N'RNDCINR0_PK')
ALTER TABLE [NDD_RNDCINR0_INACTV_REVIEWED] ADD  CONSTRAINT [RNDCINR0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RNDCTD0_NDC_ATTRIBUTE_TYP_DSC]') AND name = N'RNDCTD0_PK')
ALTER TABLE [NDD_RNDCTD0_NDC_ATTRIBUTE_TYP_DSC] ADD  CONSTRAINT [RNDCTD0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC_ATTRIBUTE_TYPE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RNDCVD0_NDC_ATTRIBUTE_VALU_DSC]') AND name = N'RNDCVD0_PK')
ALTER TABLE [NDD_RNDCVD0_NDC_ATTRIBUTE_VALU_DSC] ADD  CONSTRAINT [RNDCVD0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC_ATTRIBUTE_TYPE_CD] ASC,
	[NDC_ATTRIBUTE_VALUE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RNP2_NDC_PRICE]') AND name = N'RNP2_PK')
ALTER TABLE [NDD_RNP2_NDC_PRICE] ADD  CONSTRAINT [RNP2_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[NPT_TYPE] ASC,
	[NPT_DATEC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RNPTYPD0_NDC_PRICE_TYPE_DESC]') AND name = N'RNPTYPD0_PK')
ALTER TABLE [NDD_RNPTYPD0_NDC_PRICE_TYPE_DESC] ADD  CONSTRAINT [RNPTYPD0_PK] PRIMARY KEY CLUSTERED 
(
	[NPT_TYPE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_ROBCD0_OBC_DESC]') AND name = N'ROBCD0_PK')
ALTER TABLE [NDD_ROBCD0_OBC_DESC] ADD  CONSTRAINT [ROBCD0_PK] PRIMARY KEY CLUSTERED 
(
	[OBC] ASC,
	[OBC_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_ROBCNDC0_OBC_NDC]') AND name = N'ROBCNDC0_PK')
ALTER TABLE [NDD_ROBCNDC0_OBC_NDC] ADD  CONSTRAINT [ROBCNDC0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPDMMA1_PEDI_MSTR]') AND name = N'RPDMMA1_PK')
ALTER TABLE [NDD_RPDMMA1_PEDI_MSTR] ADD  CONSTRAINT [RPDMMA1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[PDM_MNAGE] ASC,
	[PDM_MXAGE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC]') AND name = N'RPDMUND0_PK')
ALTER TABLE [NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC] ADD  CONSTRAINT [RPDMUND0_PK] PRIMARY KEY CLUSTERED 
(
	[PDM_UNIT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPDMWT1_PEDI_WEIGHT]') AND name = N'RPDMWT1_PK')
ALTER TABLE [NDD_RPDMWT1_PEDI_WEIGHT] ADD  CONSTRAINT [RPDMWT1_PK] PRIMARY KEY CLUSTERED 
(
	[PDM_MNAGE] ASC,
	[PDM_MXAGE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEDIGC0_PEDI_GCNSEQNO_LINK]') AND name = N'RPEDIGC0_PK')
ALTER TABLE [NDD_RPEDIGC0_PEDI_GCNSEQNO_LINK] ADD  CONSTRAINT [RPEDIGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[PEDI_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEDIMA1_PEDI_MSTR]') AND name = N'RPEDIMA1_PK')
ALTER TABLE [NDD_RPEDIMA1_PEDI_MSTR] ADD  CONSTRAINT [RPEDIMA1_PK] PRIMARY KEY CLUSTERED 
(
	[PEDI_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEDIRG0_ROUTED_GEN_LINK]') AND name = N'RPEDIRG0_PK')
ALTER TABLE [NDD_RPEDIRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RPEDIRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[PEDI_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEDIRM0_ROUTED_MED_LINK]') AND name = N'RPEDIRM0_PK')
ALTER TABLE [NDD_RPEDIRM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RPEDIRM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[PEDI_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEDISD0_PEDI_SEVER_LEVEL_DESC]') AND name = N'RPEDISD0_PK')
ALTER TABLE [NDD_RPEDISD0_PEDI_SEVER_LEVEL_DESC] ADD  CONSTRAINT [RPEDISD0_PK] PRIMARY KEY CLUSTERED 
(
	[PEDI_SL] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIAD0_ATTRIBUTE_DESC]') AND name = N'RPEIAD0_PK')
ALTER TABLE [NDD_RPEIAD0_ATTRIBUTE_DESC] ADD  CONSTRAINT [RPEIAD0_PK] PRIMARY KEY CLUSTERED 
(
	[ATTRIBUTE_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIAL0_DF_ATTRIBUTE_LINK]') AND name = N'RPEIAL0_PK')
ALTER TABLE [NDD_RPEIAL0_DF_ATTRIBUTE_LINK] ADD  CONSTRAINT [RPEIAL0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSAGE_FORM_ID] ASC,
	[DOSAGE_FORM_ATTRIBUTE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIAT0_ATTRIBUTE_TYPE_DESC]') AND name = N'RPEIAT0_PK')
ALTER TABLE [NDD_RPEIAT0_ATTRIBUTE_TYPE_DESC] ADD  CONSTRAINT [RPEIAT0_PK] PRIMARY KEY CLUSTERED 
(
	[ATTRIBUTE_TYPE_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIAV0_ATTRIBUTE_VALUE_DESC]') AND name = N'RPEIAV0_PK')
ALTER TABLE [NDD_RPEIAV0_ATTRIBUTE_VALUE_DESC] ADD  CONSTRAINT [RPEIAV0_PK] PRIMARY KEY CLUSTERED 
(
	[ATTRIBUTE_CODE] ASC,
	[ATTRIBUTE_VALUE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIDFA0_DOSAGE_FORM_ATTRIBUTE]') AND name = N'RPEIDFA0_PK')
ALTER TABLE [NDD_RPEIDFA0_DOSAGE_FORM_ATTRIBUTE] ADD  CONSTRAINT [RPEIDFA0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSAGE_FORM_ATTRIBUTE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIDM0_DOSAGE_FORM_MSTR]') AND name = N'RPEIDM0_PK')
ALTER TABLE [NDD_RPEIDM0_DOSAGE_FORM_MSTR] ADD  CONSTRAINT [RPEIDM0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSAGE_FORM_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIDT0_DOSAGE_FORM_TYPE]') AND name = N'RPEIDT0_PK')
ALTER TABLE [NDD_RPEIDT0_DOSAGE_FORM_TYPE] ADD  CONSTRAINT [RPEIDT0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSAGE_FORM_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIGA0_GCNSEQNO_ATTRIBUTE]') AND name = N'RPEIGA0_PK')
ALTER TABLE [NDD_RPEIGA0_GCNSEQNO_ATTRIBUTE] ADD  CONSTRAINT [RPEIGA0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[ATTRIBUTE_CODE] ASC,
	[ATTRIBUTE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIGD0_GCNSEQNO_DF_LINK]') AND name = N'RPEIGD0_PK')
ALTER TABLE [NDD_RPEIGD0_GCNSEQNO_DF_LINK] ADD  CONSTRAINT [RPEIGD0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[DOSAGE_FORM_ID] ASC,
	[DOSAGE_FORM_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIGL0_GEN_DF_MSTR_LINK]') AND name = N'RPEIGL0_PK')
ALTER TABLE [NDD_RPEIGL0_GEN_DF_MSTR_LINK] ADD  CONSTRAINT [RPEIGL0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSAGE_FORM_ID] ASC,
	[GCDF] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIGR0_GCNSEQNO_RT_RELATION]') AND name = N'RPEIGR0_PK')
ALTER TABLE [NDD_RPEIGR0_GCNSEQNO_RT_RELATION] ADD  CONSTRAINT [RPEIGR0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[PARENT_RT_ID] ASC,
	[CLINICAL_RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIGRR0_GCNSEQNO_REP_RT]') AND name = N'RPEIGRR0_PK')
ALTER TABLE [NDD_RPEIGRR0_GCNSEQNO_REP_RT] ADD  CONSTRAINT [RPEIGRR0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIGS0_GCNSEQNO_STR_LINK]') AND name = N'RPEIGS0_PK')
ALTER TABLE [NDD_RPEIGS0_GCNSEQNO_STR_LINK] ADD  CONSTRAINT [RPEIGS0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[HIC_SEQN] ASC,
	[STR_CONC_TYPE_ID] ASC,
	[STR_SEQ] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIHR0_HICLSEQNO_RT_RELATION]') AND name = N'RPEIHR0_PK')
ALTER TABLE [NDD_RPEIHR0_HICLSEQNO_RT_RELATION] ADD  CONSTRAINT [RPEIHR0_PK] PRIMARY KEY CLUSTERED 
(
	[HICL_SEQNO] ASC,
	[PARENT_RT_ID] ASC,
	[CLINICAL_RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIMA0_MED_ATTRIBUTE]') AND name = N'RPEIMA0_PK')
ALTER TABLE [NDD_RPEIMA0_MED_ATTRIBUTE] ADD  CONSTRAINT [RPEIMA0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[ATTRIBUTE_CODE] ASC,
	[ATTRIBUTE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIMD0_MED_DF_LINK]') AND name = N'RPEIMD0_PK')
ALTER TABLE [NDD_RPEIMD0_MED_DF_LINK] ADD  CONSTRAINT [RPEIMD0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[DOSAGE_FORM_ID] ASC,
	[DOSAGE_FORM_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIML0_MED_DF_MSTR_LINK]') AND name = N'RPEIML0_PK')
ALTER TABLE [NDD_RPEIML0_MED_DF_MSTR_LINK] ADD  CONSTRAINT [RPEIML0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSAGE_FORM_ID] ASC,
	[MED_DOSAGE_FORM_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIMNR0_MED_NAME_RT_RELATION]') AND name = N'RPEIMNR0_PK')
ALTER TABLE [NDD_RPEIMNR0_MED_NAME_RT_RELATION] ADD  CONSTRAINT [RPEIMNR0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_ID] ASC,
	[PARENT_RT_ID] ASC,
	[CLINICAL_RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIMRR0_MED_RT_RELATION]') AND name = N'RPEIMRR0_PK')
ALTER TABLE [NDD_RPEIMRR0_MED_RT_RELATION] ADD  CONSTRAINT [RPEIMRR0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[PARENT_RT_ID] ASC,
	[CLINICAL_RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIMS0_MED_STR_LINK]') AND name = N'RPEIMS0_PK')
ALTER TABLE [NDD_RPEIMS0_MED_STR_LINK] ADD  CONSTRAINT [RPEIMS0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[HIC_SEQN] ASC,
	[STR_CONC_TYPE_ID] ASC,
	[STR_SEQ] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEINA0_MED_NAME_ATTRIBUTE]') AND name = N'RPEINA0_PK')
ALTER TABLE [NDD_RPEINA0_MED_NAME_ATTRIBUTE] ADD  CONSTRAINT [RPEINA0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_ID] ASC,
	[ATTRIBUTE_CODE] ASC,
	[ATTRIBUTE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIND0_NDC_DF_LINK]') AND name = N'RPEIND0_PK')
ALTER TABLE [NDD_RPEIND0_NDC_DF_LINK] ADD  CONSTRAINT [RPEIND0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[DOSAGE_FORM_ID] ASC,
	[DOSAGE_FORM_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEINR0_NDC_RT_RELATION]') AND name = N'RPEINR0_PK')
ALTER TABLE [NDD_RPEINR0_NDC_RT_RELATION] ADD  CONSTRAINT [RPEINR0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[PARENT_RT_ID] ASC,
	[CLINICAL_RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEINS0_NDC_STR_LINK]') AND name = N'RPEINS0_PK')
ALTER TABLE [NDD_RPEINS0_NDC_STR_LINK] ADD  CONSTRAINT [RPEINS0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[HIC_SEQN] ASC,
	[STR_CONC_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIOL0_OVW_DF_MSTR_LINK]') AND name = N'RPEIOL0_PK')
ALTER TABLE [NDD_RPEIOL0_OVW_DF_MSTR_LINK] ADD  CONSTRAINT [RPEIOL0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSAGE_FORM_ID] ASC,
	[OVW_DOSAGE_FORM_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIPF0_POEM_DF_MSTR_LINK]') AND name = N'RPEIPF0_PK')
ALTER TABLE [NDD_RPEIPF0_POEM_DF_MSTR_LINK] ADD  CONSTRAINT [RPEIPF0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSAGE_FORM_ID] ASC,
	[POEUNITCDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIPP0_PATIENT_PARAM_REQ_DESC]') AND name = N'RPEIPP0_PK')
ALTER TABLE [NDD_RPEIPP0_PATIENT_PARAM_REQ_DESC] ADD  CONSTRAINT [RPEIPP0_PK] PRIMARY KEY CLUSTERED 
(
	[PATIENT_PARAM_REQ_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRA0_RT_DF_MED_ATTRIBUTE]') AND name = N'RPEIRA0_PK')
ALTER TABLE [NDD_RPEIRA0_RT_DF_MED_ATTRIBUTE] ADD  CONSTRAINT [RPEIRA0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC,
	[ATTRIBUTE_CODE] ASC,
	[ATTRIBUTE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRD0_RTD_DF_MED_DF_LINK]') AND name = N'RPEIRD0_PK')
ALTER TABLE [NDD_RPEIRD0_RTD_DF_MED_DF_LINK] ADD  CONSTRAINT [RPEIRD0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC,
	[DOSAGE_FORM_ID] ASC,
	[DOSAGE_FORM_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRER0_RELATED_RT]') AND name = N'RPEIRER0_PK')
ALTER TABLE [NDD_RPEIRER0_RELATED_RT] ADD  CONSTRAINT [RPEIRER0_PK] PRIMARY KEY CLUSTERED 
(
	[CONTINUOUS_RT_ID] ASC,
	[INTERMITTENT_RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRH0_RT_HIERARCHY]') AND name = N'RPEIRH0_PK')
ALTER TABLE [NDD_RPEIRH0_RT_HIERARCHY] ADD  CONSTRAINT [RPEIRH0_PK] PRIMARY KEY CLUSTERED 
(
	[PARENT_RT_ID] ASC,
	[CLINICAL_RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRL0_RT_LABELED_DESC]') AND name = N'RPEIRL0_PK')
ALTER TABLE [NDD_RPEIRL0_RT_LABELED_DESC] ADD  CONSTRAINT [RPEIRL0_PK] PRIMARY KEY CLUSTERED 
(
	[RT_LABELED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRM0_RT_MSTR]') AND name = N'RPEIRM0_PK')
ALTER TABLE [NDD_RPEIRM0_RT_MSTR] ADD  CONSTRAINT [RPEIRM0_PK] PRIMARY KEY CLUSTERED 
(
	[RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRMA0_RTD_MED_ATTRIBUTE]') AND name = N'RPEIRMA0_PK')
ALTER TABLE [NDD_RPEIRMA0_RTD_MED_ATTRIBUTE] ADD  CONSTRAINT [RPEIRMA0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[ATTRIBUTE_CODE] ASC,
	[ATTRIBUTE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRMD0_RTD_MED_DF_LINK]') AND name = N'RPEIRMD0_PK')
ALTER TABLE [NDD_RPEIRMD0_RTD_MED_DF_LINK] ADD  CONSTRAINT [RPEIRMD0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[DOSAGE_FORM_ID] ASC,
	[DOSAGE_FORM_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRMR0_RTD_MED_RT_RELATION]') AND name = N'RPEIRMR0_PK')
ALTER TABLE [NDD_RPEIRMR0_RTD_MED_RT_RELATION] ADD  CONSTRAINT [RPEIRMR0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[PARENT_RT_ID] ASC,
	[CLINICAL_RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIRR0_RTD_DF_MED_RT_RELATION]') AND name = N'RPEIRR0_PK')
ALTER TABLE [NDD_RPEIRR0_RTD_DF_MED_RT_RELATION] ADD  CONSTRAINT [RPEIRR0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC,
	[PARENT_RT_ID] ASC,
	[CLINICAL_RT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIST0_STR_CONC_TYPE]') AND name = N'RPEIST0_PK')
ALTER TABLE [NDD_RPEIST0_STR_CONC_TYPE] ADD  CONSTRAINT [RPEIST0_PK] PRIMARY KEY CLUSTERED 
(
	[STR_CONC_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIUC0_UOM_CONVERSION]') AND name = N'RPEIUC0_PK')
ALTER TABLE [NDD_RPEIUC0_UOM_CONVERSION] ADD  CONSTRAINT [RPEIUC0_PK] PRIMARY KEY CLUSTERED 
(
	[FROM_UOM_MSTR_ID] ASC,
	[TO_UOM_MSTR_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIUM0_UOM_MSTR]') AND name = N'RPEIUM0_PK')
ALTER TABLE [NDD_RPEIUM0_UOM_MSTR] ADD  CONSTRAINT [RPEIUM0_PK] PRIMARY KEY CLUSTERED 
(
	[UOM_MSTR_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEIUT0_UOM_TYPE_DESC]') AND name = N'RPEIUT0_PK')
ALTER TABLE [NDD_RPEIUT0_UOM_TYPE_DESC] ADD  CONSTRAINT [RPEIUT0_PK] PRIMARY KEY CLUSTERED 
(
	[UOM_TYPE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEMGC0_GCNSEQNO_LINK]') AND name = N'RPEMGC0_PK')
ALTER TABLE [NDD_RPEMGC0_GCNSEQNO_LINK] ADD  CONSTRAINT [RPEMGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[PEC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEMMA5_MSTR]') AND name = N'RPEMMA5_PK')
ALTER TABLE [NDD_RPEMMA5_MSTR] ADD  CONSTRAINT [RPEMMA5_PK] PRIMARY KEY CLUSTERED 
(
	[PEC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEMMOE2_MONO]') AND name = N'RPEMMOE2_PK')
ALTER TABLE [NDD_RPEMMOE2_MONO] ADD  CONSTRAINT [RPEMMOE2_PK] PRIMARY KEY CLUSTERED 
(
	[PEMONO] ASC,
	[PEMONOE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEMOGC0_MONO_GCNSEQNO_LINK]') AND name = N'RPEMOGC0_PK')
ALTER TABLE [NDD_RPEMOGC0_MONO_GCNSEQNO_LINK] ADD  CONSTRAINT [RPEMOGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[PEMONO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEMORG0_ROUTED_GEN_LINK]') AND name = N'RPEMORG0_PK')
ALTER TABLE [NDD_RPEMORG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RPEMORG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[PEMONO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPEMRG0_ROUTED_GEN_LINK]') AND name = N'RPEMRG0_PK')
ALTER TABLE [NDD_RPEMRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RPEMRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[PEC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOEAR1_ADMINISTRATION_RATE]') AND name = N'RPOEAR1_PK')
ALTER TABLE [NDD_RPOEAR1_ADMINISTRATION_RATE] ADD  CONSTRAINT [RPOEAR1_PK] PRIMARY KEY CLUSTERED 
(
	[POEOSTRID] ASC,
	[POEADMINSQ] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOECD1_DEFINITION]') AND name = N'RPOECD1_PK')
ALTER TABLE [NDD_RPOECD1_DEFINITION] ADD  CONSTRAINT [RPOECD1_PK] PRIMARY KEY CLUSTERED 
(
	[POEUNITCDE] ASC,
	[POELANGCDE] ASC,
	[POECOCDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOECL1_CLIN_CONTEXT]') AND name = N'RPOECL1_PK')
ALTER TABLE [NDD_RPOECL1_CLIN_CONTEXT] ADD  CONSTRAINT [RPOECL1_PK] PRIMARY KEY CLUSTERED 
(
	[POECLINID] ASC,
	[POECLINTYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOECOD0_COUNTRY_DESC]') AND name = N'RPOECOD0_PK')
ALTER TABLE [NDD_RPOECOD0_COUNTRY_DESC] ADD  CONSTRAINT [RPOECOD0_PK] PRIMARY KEY CLUSTERED 
(
	[POECOCDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOECRD0_CALC_REQ_TYPE_DESC]') AND name = N'RPOECRD0_PK')
ALTER TABLE [NDD_RPOECRD0_CALC_REQ_TYPE_DESC] ADD  CONSTRAINT [RPOECRD0_PK] PRIMARY KEY CLUSTERED 
(
	[POECALCRTC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOECTD0_CLIN_CONTEXT_TYP_DESC]') AND name = N'RPOECTD0_PK')
ALTER TABLE [NDD_RPOECTD0_CLIN_CONTEXT_TYP_DESC] ADD  CONSTRAINT [RPOECTD0_PK] PRIMARY KEY CLUSTERED 
(
	[POECLINTYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOECVD0_CLIN_CONTEXT_VAL_DESC]') AND name = N'RPOECVD0_PK')
ALTER TABLE [NDD_RPOECVD0_CLIN_CONTEXT_VAL_DESC] ADD  CONSTRAINT [RPOECVD0_PK] PRIMARY KEY CLUSTERED 
(
	[POECLINVAL] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOEDTD0_DOSE_TYPE_DESC]') AND name = N'RPOEDTD0_PK')
ALTER TABLE [NDD_RPOEDTD0_DOSE_TYPE_DESC] ADD  CONSTRAINT [RPOEDTD0_PK] PRIMARY KEY CLUSTERED 
(
	[POEDOSETYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOEGCS1_STANDARD_ORDER]') AND name = N'RPOEGCS1_PK')
ALTER TABLE [NDD_RPOEGCS1_STANDARD_ORDER] ADD  CONSTRAINT [RPOEGCS1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[POECLINID] ASC,
	[POEOSETID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOEGSQ2_GCNSEQNO_MSTR]') AND name = N'RPOEGSQ1_PK')
ALTER TABLE [NDD_RPOEGSQ2_GCNSEQNO_MSTR] ADD  CONSTRAINT [RPOEGSQ1_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[FDBDX] ASC,
	[POEOSETID] ASC,
	[POECLINID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOELGD0_LANGUAGE_DESC]') AND name = N'RPOELGD0_PK')
ALTER TABLE [NDD_RPOELGD0_LANGUAGE_DESC] ADD  CONSTRAINT [RPOELGD0_PK] PRIMARY KEY CLUSTERED 
(
	[POELANGCDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOEOS1_ORDER_SET]') AND name = N'RPOEOS1_PK')
ALTER TABLE [NDD_RPOEOS1_ORDER_SET] ADD  CONSTRAINT [RPOEOS1_PK] PRIMARY KEY CLUSTERED 
(
	[POEOSETID] ASC,
	[POEOSTRSEQ] ASC,
	[POEOSTRID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOEOSR1_ORDER_STRING]') AND name = N'RPOEOSR1_PK')
ALTER TABLE [NDD_RPOEOSR1_ORDER_STRING] ADD  CONSTRAINT [RPOEOSR1_PK] PRIMARY KEY CLUSTERED 
(
	[POEOSTRID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOEOSX1_TEXT_LINK]') AND name = N'RPOEOSX1_PK')
ALTER TABLE [NDD_RPOEOSX1_TEXT_LINK] ADD  CONSTRAINT [RPOEOSX1_PK] PRIMARY KEY CLUSTERED 
(
	[POEOSTRID] ASC,
	[POETEXTTYP] ASC,
	[POETXTSTRL] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOERDD0_ROUTE_DESC]') AND name = N'RPOERDD0_PK')
ALTER TABLE [NDD_RPOERDD0_ROUTE_DESC] ADD  CONSTRAINT [RPOERDD0_PK] PRIMARY KEY CLUSTERED 
(
	[POEROUTE_D] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOETSD0_TEXT_STR_LOC_DESC]') AND name = N'RPOETSD0_PK')
ALTER TABLE [NDD_RPOETSD0_TEXT_STR_LOC_DESC] ADD  CONSTRAINT [RPOETSD0_PK] PRIMARY KEY CLUSTERED 
(
	[POETXTSTRL] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOETTD0_TEXT_TYPE_DESC]') AND name = N'RPOETTD0_PK')
ALTER TABLE [NDD_RPOETTD0_TEXT_TYPE_DESC] ADD  CONSTRAINT [RPOETTD0_PK] PRIMARY KEY CLUSTERED 
(
	[POETEXTTYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOETXT1_TEXT]') AND name = N'RPOETXT1_PK')
ALTER TABLE [NDD_RPOETXT1_TEXT] ADD  CONSTRAINT [RPOETXT1_PK] PRIMARY KEY CLUSTERED 
(
	[POETEXTCDE] ASC,
	[POELANGCDE] ASC,
	[POECOCDE] ASC,
	[POETXTNUM] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPOEUTD0_UNIT_TYPE_DESC]') AND name = N'RPOEUTD0_PK')
ALTER TABLE [NDD_RPOEUTD0_UNIT_TYPE_DESC] ADD  CONSTRAINT [RPOEUTD0_PK] PRIMARY KEY CLUSTERED 
(
	[POEUNITTYP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRD0_PRODUCT]') AND name = N'RPRD0_PK')
ALTER TABLE [NDD_RPRD0_PRODUCT] ADD  CONSTRAINT [RPRD0_PK] PRIMARY KEY CLUSTERED 
(
	[FDB_PRODUCT_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDCC0_CURRENCY_CD_DESC]') AND name = N'RPRDCC0_PK')
ALTER TABLE [NDD_RPRDCC0_CURRENCY_CD_DESC] ADD  CONSTRAINT [RPRDCC0_PK] PRIMARY KEY CLUSTERED 
(
	[CURRENCY_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDPA0_PRICE_ATTR]') AND name = N'RPRDPA0_PK')
ALTER TABLE [NDD_RPRDPA0_PRICE_ATTR] ADD  CONSTRAINT [RPRDPA0_PK] PRIMARY KEY CLUSTERED 
(
	[FDB_PRODUCT_ID] ASC,
	[PRICE_TYPE_ID] ASC,
	[PRICE_EFFECTIVE_DT] ASC,
	[PRICE_ATTRIBUTE_CD] ASC,
	[PRICE_ATTRIBUTE_SN] ASC,
	[PRICE_ATTRIBUTE_VALUE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDPAD0_PRICE_ATTR_DESC]') AND name = N'RPRDPAD0_PK')
ALTER TABLE [NDD_RPRDPAD0_PRICE_ATTR_DESC] ADD  CONSTRAINT [RPRDPAD0_PK] PRIMARY KEY CLUSTERED 
(
	[PRICE_ATTRIBUTE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDPAT0_PRICE_ATTR_TYPE_DESC]') AND name = N'RPRDPAT0_PK')
ALTER TABLE [NDD_RPRDPAT0_PRICE_ATTR_TYPE_DESC] ADD  CONSTRAINT [RPRDPAT0_PK] PRIMARY KEY CLUSTERED 
(
	[PRICE_ATTRIBUTE_TYPE_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDPAV0_PRICE_ATTR_VALUE_DESC]') AND name = N'RPRDPAV0_PK')
ALTER TABLE [NDD_RPRDPAV0_PRICE_ATTR_VALUE_DESC] ADD  CONSTRAINT [RPRDPAV0_PK] PRIMARY KEY CLUSTERED 
(
	[PRICE_ATTRIBUTE_CD] ASC,
	[PRICE_ATTRIBUTE_VALUE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDPC0_EXT_PRODUCT_CD]') AND name = N'RPRDPC0_PK')
ALTER TABLE [NDD_RPRDPC0_EXT_PRODUCT_CD] ADD  CONSTRAINT [RPRDPC0_PK] PRIMARY KEY CLUSTERED 
(
	[FDB_PRODUCT_ID] ASC,
	[EXT_PRODUCT_CD_TYPE_ID] ASC,
	[EXT_PRODUCT_CD_START_DT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDPCD0_EXT_PRODUCT_CD_DESC]') AND name = N'RPRDPCD0_PK')
ALTER TABLE [NDD_RPRDPCD0_EXT_PRODUCT_CD_DESC] ADD  CONSTRAINT [RPRDPCD0_PK] PRIMARY KEY CLUSTERED 
(
	[EXT_PRODUCT_CD_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDPKD0_PACKAGE_DESC]') AND name = N'RPRDPKD0_PK')
ALTER TABLE [NDD_RPRDPKD0_PACKAGE_DESC] ADD  CONSTRAINT [RPRDPKD0_PK] PRIMARY KEY CLUSTERED 
(
	[PACKAGE_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDPP0_PRODUCT_PRICE]') AND name = N'RPRDPP0_PK')
ALTER TABLE [NDD_RPRDPP0_PRODUCT_PRICE] ADD  CONSTRAINT [RPRDPP0_PK] PRIMARY KEY CLUSTERED 
(
	[FDB_PRODUCT_ID] ASC,
	[PRICE_TYPE_ID] ASC,
	[PRICE_EFFECTIVE_DT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDPTD0_PRICE_TYPE_DESC]') AND name = N'RPRDPTD0_PK')
ALTER TABLE [NDD_RPRDPTD0_PRICE_TYPE_DESC] ADD  CONSTRAINT [RPRDPTD0_PK] PRIMARY KEY CLUSTERED 
(
	[PRICE_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDSD0_PRODUCT_STATUS_DESC]') AND name = N'RPRDSD0_PK')
ALTER TABLE [NDD_RPRDSD0_PRODUCT_STATUS_DESC] ADD  CONSTRAINT [RPRDSD0_PK] PRIMARY KEY CLUSTERED 
(
	[FDB_PRODUCT_STATUS_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPRDUOM0_PRICE_QTY_UOM]') AND name = N'RPRDUOM0_PK')
ALTER TABLE [NDD_RPRDUOM0_PRICE_QTY_UOM] ADD  CONSTRAINT [RPRDUOM0_PK] PRIMARY KEY CLUSTERED 
(
	[PRICE_UOM_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGGC0_PREG_GCNSEQNO_LINK]') AND name = N'RPREGGC0_PK')
ALTER TABLE [NDD_RPREGGC0_PREG_GCNSEQNO_LINK] ADD  CONSTRAINT [RPREGGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[PREG_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGMA0_PREG_MSTR]') AND name = N'RPREGMA0_PK')
ALTER TABLE [NDD_RPREGMA0_PREG_MSTR] ADD  CONSTRAINT [RPREGMA0_PK] PRIMARY KEY CLUSTERED 
(
	[PREG_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGMA1_PREG_MSTR]') AND name = N'RPREGMA1_PK')
ALTER TABLE [NDD_RPREGMA1_PREG_MSTR] ADD  CONSTRAINT [RPREGMA1_PK] PRIMARY KEY CLUSTERED 
(
	[PREG_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGMS0_MONO_SECTION_DESC]') AND name = N'RPREGMS0_PK')
ALTER TABLE [NDD_RPREGMS0_MONO_SECTION_DESC] ADD  CONSTRAINT [RPREGMS0_PK] PRIMARY KEY CLUSTERED 
(
	[PREG_MONO_SECTION_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGPL0_PREG_MONO_LINE]') AND name = N'RPREGPL0_PK')
ALTER TABLE [NDD_RPREGPL0_PREG_MONO_LINE] ADD  CONSTRAINT [RPREGPL0_PK] PRIMARY KEY CLUSTERED 
(
	[PREG_MONO_ID] ASC,
	[PREG_MONO_SECTION_CD] ASC,
	[PREG_MONO_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGRE0_PREG_REFERENCE]') AND name = N'RPREGRE0_PK')
ALTER TABLE [NDD_RPREGRE0_PREG_REFERENCE] ADD  CONSTRAINT [RPREGRE0_PK] PRIMARY KEY CLUSTERED 
(
	[PREG_REFERENCE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGRG0_ROUTED_GEN_LINK]') AND name = N'RPREGRG0_PK')
ALTER TABLE [NDD_RPREGRG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RPREGRG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[PREG_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGRL0_PREG_REFERENCE_LINK]') AND name = N'RPREGRL0_PK')
ALTER TABLE [NDD_RPREGRL0_PREG_REFERENCE_LINK] ADD  CONSTRAINT [RPREGRL0_PK] PRIMARY KEY CLUSTERED 
(
	[PREG_CODE] ASC,
	[PREG_REFERENCE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGRM0_ROUTED_MED_LINK]') AND name = N'RPREGRM0_PK')
ALTER TABLE [NDD_RPREGRM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RPREGRM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[PREG_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGRT0_PREG_REFERENCE_TYPE]') AND name = N'RPREGRT0_PK')
ALTER TABLE [NDD_RPREGRT0_PREG_REFERENCE_TYPE] ADD  CONSTRAINT [RPREGRT0_PK] PRIMARY KEY CLUSTERED 
(
	[PREG_REFERENCE_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGSL0_PREG_SEVER_LEVEL]') AND name = N'RPREGSL0_PK')
ALTER TABLE [NDD_RPREGSL0_PREG_SEVER_LEVEL] ADD  CONSTRAINT [RPREGSL0_PK] PRIMARY KEY CLUSTERED 
(
	[PREG_SL] ASC,
	[PREG_SLSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RPREGSL1_PREG_SEVER_LEVEL]') AND name = N'RPREGSL1_PK')
ALTER TABLE [NDD_RPREGSL1_PREG_SEVER_LEVEL] ADD  CONSTRAINT [RPREGSL1_PK] PRIMARY KEY CLUSTERED 
(
	[PREG_SL] ASC,
	[PREG_SLSN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RROUTED3_ROUTE_DESC]') AND name = N'RROUTED3_PK')
ALTER TABLE [NDD_RROUTED3_ROUTE_DESC] ADD  CONSTRAINT [RROUTED3_PK] PRIMARY KEY CLUSTERED 
(
	[GCRT] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RRTGN0_ROUTED_GEN_MSTR]') AND name = N'RRTGN0_PK')
ALTER TABLE [NDD_RRTGN0_ROUTED_GEN_MSTR] ADD  CONSTRAINT [RRTGN0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RRTGNGC0_RTD_GEN_GCNSEQNO_LNK]') AND name = N'RRTGNGC0_PK')
ALTER TABLE [NDD_RRTGNGC0_RTD_GEN_GCNSEQNO_LNK] ADD  CONSTRAINT [RRTGNGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RRTGNND0_ROUTED_GEN_NDC_LINK]') AND name = N'RRTGNND0_PK')
ALTER TABLE [NDD_RRTGNND0_ROUTED_GEN_NDC_LINK] ADD  CONSTRAINT [RRTGNND0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RRTGNSD0_RTD_GEN_STATUS_DSC]') AND name = N'RRTGNSD0_PK')
ALTER TABLE [NDD_RRTGNSD0_RTD_GEN_STATUS_DSC] ADD  CONSTRAINT [RRTGNSD0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_STATUS_CD] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RSIDEDD0_DRUG_DESC]') AND name = N'RSIDEDD0_PK')
ALTER TABLE [NDD_RSIDEDD0_DRUG_DESC] ADD  CONSTRAINT [RSIDEDD0_PK] PRIMARY KEY CLUSTERED 
(
	[SIDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RSIDEGC0_GCNSEQNO_LINK]') AND name = N'RSIDEGC0_PK')
ALTER TABLE [NDD_RSIDEGC0_GCNSEQNO_LINK] ADD  CONSTRAINT [RSIDEGC0_PK] PRIMARY KEY CLUSTERED 
(
	[GCN_SEQNO] ASC,
	[SIDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RSIDEMA3_MSTR]') AND name = N'RSIDEMA3_PK')
ALTER TABLE [NDD_RSIDEMA3_MSTR] ADD  CONSTRAINT [RSIDEMA3_PK] PRIMARY KEY CLUSTERED 
(
	[SIDE] ASC,
	[SIDE_SN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RSIDERG0_ROUTED_GEN_LINK]') AND name = N'RSIDERG0_PK')
ALTER TABLE [NDD_RSIDERG0_ROUTED_GEN_LINK] ADD  CONSTRAINT [RSIDERG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_GEN_ID] ASC,
	[SIDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RSIDERM0_ROUTED_MED_LINK]') AND name = N'RSIDERM0_PK')
ALTER TABLE [NDD_RSIDERM0_ROUTED_MED_LINK] ADD  CONSTRAINT [RSIDERM0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[SIDE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RSTR1_STRNGTH_DESC]') AND name = N'RSTR1_PK')
ALTER TABLE [NDD_RSTR1_STRNGTH_DESC] ADD  CONSTRAINT [RSTR1_PK] PRIMARY KEY CLUSTERED 
(
	[STR60] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RSTRSCD0_STRENGTH_STATUS_DESC]') AND name = N'RSTRSCD0_PK')
ALTER TABLE [NDD_RSTRSCD0_STRENGTH_STATUS_DESC] ADD  CONSTRAINT [RSTRSCD0_PK] PRIMARY KEY CLUSTERED 
(
	[STRENGTH_STATUS_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RSTRTD0_STRENGTH_TYP_DESC]') AND name = N'RSTRTD0_PK')
ALTER TABLE [NDD_RSTRTD0_STRENGTH_TYP_DESC] ADD  CONSTRAINT [RSTRTD0_PK] PRIMARY KEY CLUSTERED 
(
	[STRENGTH_TYP_CODE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RSTRUOM0_STRENGTH_UOM]') AND name = N'RSTRUOM0_PK')
ALTER TABLE [NDD_RSTRUOM0_STRENGTH_UOM] ADD  CONSTRAINT [RSTRUOM0_PK] PRIMARY KEY CLUSTERED 
(
	[UOM_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTCD0_STD_THERAP_CLASS_DESC]') AND name = N'RTCD0_PK')
ALTER TABLE [NDD_RTCD0_STD_THERAP_CLASS_DESC] ADD  CONSTRAINT [RTCD0_PK] PRIMARY KEY CLUSTERED 
(
	[TC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMDFCG0_TM_RTD_DF_CNFSN_GRP]') AND name = N'RTMDFCG0_PK')
ALTER TABLE [NDD_RTMDFCG0_TM_RTD_DF_CNFSN_GRP] ADD  CONSTRAINT [RTMDFCG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC,
	[TM_GROUP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMDFID1_TM_ROUTED_DF_MED]') AND name = N'RTMDFID1_PK')
ALTER TABLE [NDD_RTMDFID1_TM_ROUTED_DF_MED] ADD  CONSTRAINT [RTMDFID1_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMDT0_TM_NAME_TYPE]') AND name = N'RTMDT0_PK')
ALTER TABLE [NDD_RTMDT0_TM_NAME_TYPE] ADD  CONSTRAINT [RTMDT0_PK] PRIMARY KEY CLUSTERED 
(
	[TM_NAME_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMGRPD1_TM_GROUP_DESC]') AND name = N'RTMGRPD1_PK')
ALTER TABLE [NDD_RTMGRPD1_TM_GROUP_DESC] ADD  CONSTRAINT [RTMGRPD1_PK] PRIMARY KEY CLUSTERED 
(
	[TM_GROUP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMMICG0_TM_MED_CNFSN_GRP]') AND name = N'RTMMICG0_PK')
ALTER TABLE [NDD_RTMMICG0_TM_MED_CNFSN_GRP] ADD  CONSTRAINT [RTMMICG0_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[TM_GROUP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMMID1_TM_MED]') AND name = N'RTMMID1_PK')
ALTER TABLE [NDD_RTMMID1_TM_MED] ADD  CONSTRAINT [RTMMID1_PK] PRIMARY KEY CLUSTERED 
(
	[MEDID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMNCG0_TM_NDC_CNFSN_GRP]') AND name = N'RTMNCG0_PK')
ALTER TABLE [NDD_RTMNCG0_TM_NDC_CNFSN_GRP] ADD  CONSTRAINT [RTMNCG0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[TM_GROUP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMNGN0_TM_GNN]') AND name = N'RTMNGN_PK')
ALTER TABLE [NDD_RTMNGN0_TM_GNN] ADD  CONSTRAINT [RTMNGN_PK] PRIMARY KEY CLUSTERED 
(
	[HICL_SEQNO] ASC,
	[TM_GNN_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMNGT0_TM_GNN_TYPE]') AND name = N'RTMNGT_PK')
ALTER TABLE [NDD_RTMNGT0_TM_GNN_TYPE] ADD  CONSTRAINT [RTMNGT_PK] PRIMARY KEY CLUSTERED 
(
	[TM_GNN_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMNID0_TM_NDC]') AND name = N'RTMNID0_PK')
ALTER TABLE [NDD_RTMNID0_TM_NDC] ADD  CONSTRAINT [RTMNID0_PK] PRIMARY KEY CLUSTERED 
(
	[NDC] ASC,
	[TM_NAME_TYPE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMNMCG0_TM_MED_NAME_CNFSN_GRP]') AND name = N'RTMNMCG0_PK')
ALTER TABLE [NDD_RTMNMCG0_TM_MED_NAME_CNFSN_GRP] ADD  CONSTRAINT [RTMNMCG0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_ID] ASC,
	[TM_GROUP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMNMID1_TM_MED_NAME]') AND name = N'RTMNMID1_PK')
ALTER TABLE [NDD_RTMNMID1_TM_MED_NAME] ADD  CONSTRAINT [RTMNMID1_PK] PRIMARY KEY CLUSTERED 
(
	[MED_NAME_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMRMCG0_TM_RTD_MED_CNFSN_GRP]') AND name = N'RTMRMCG0_PK')
ALTER TABLE [NDD_RTMRMCG0_TM_RTD_MED_CNFSN_GRP] ADD  CONSTRAINT [RTMRMCG0_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[TM_GROUP_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMRMID1_TM_ROUTED_MED]') AND name = N'RTMRMID1_PK')
ALTER TABLE [NDD_RTMRMID1_TM_ROUTED_MED] ADD  CONSTRAINT [RTMRMID1_PK] PRIMARY KEY CLUSTERED 
(
	[ROUTED_MED_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RTMSRCD1_TM_SOURCE_DESC]') AND name = N'RTMSRCD1_PK')
ALTER TABLE [NDD_RTMSRCD1_TM_SOURCE_DESC] ADD  CONSTRAINT [RTMSRCD1_PK] PRIMARY KEY CLUSTERED 
(
	[TM_SOURCE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RUNITSD0_UNITS_DESC]') AND name = N'RUNITSD0_PK')
ALTER TABLE [NDD_RUNITSD0_UNITS_DESC] ADD  CONSTRAINT [RUNITSD0_PK] PRIMARY KEY CLUSTERED 
(
	[DOSING_MODULE_UNIT_ABBREV] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RXRFAHX0_AGCSP_HICSEQN]') AND name = N'RXRFAHX0_PK')
ALTER TABLE [NDD_RXRFAHX0_AGCSP_HICSEQN] ADD  CONSTRAINT [RXRFAHX0_PK] PRIMARY KEY CLUSTERED 
(
	[DAM_AGCSP] ASC,
	[HIC_SEQN] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RXRFDDX0_DACN_AGCSP]') AND name = N'RXRFDDX0_PK')
ALTER TABLE [NDD_RXRFDDX0_DACN_AGCSP] ADD  CONSTRAINT [RXRFDDX0_PK] PRIMARY KEY CLUSTERED 
(
	[DACN] ASC,
	[DAM_AGCSP] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RXRFPCX0_PIF_ALG_CHEMNO]') AND name = N'RXRFPCX0_PK')
ALTER TABLE [NDD_RXRFPCX0_PIF_ALG_CHEMNO] ADD  CONSTRAINT [RXRFPCX0_PK] PRIMARY KEY CLUSTERED 
(
	[PIF_ALG] ASC,
	[PIF_ALGSUB] ASC,
	[CHEMNO] ASC,
	[CHEMSE] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RXRFSCD0_STATUS_DESC]') AND name = N'RXRFSCD0_PK')
ALTER TABLE [NDD_RXRFSCD0_STATUS_DESC] ADD  CONSTRAINT [RXRFSCD0_PK] PRIMARY KEY CLUSTERED 
(
	[XRF_STATUS] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RXRGDFQ0_GCDF_SCRIPT_QQ]') AND name = N'RXRGDFQ0_PK')
ALTER TABLE [NDD_RXRGDFQ0_GCDF_SCRIPT_QQ] ADD  CONSTRAINT [RXRGDFQ0_PK] PRIMARY KEY CLUSTERED 
(
	[GCDF] ASC,
	[SCRIPT_QQ_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RXRMDFQ0_MEDDOSFM_SCRIPT_QQ]') AND name = N'RXRMDFQ0_PK')
ALTER TABLE [NDD_RXRMDFQ0_MEDDOSFM_SCRIPT_QQ] ADD  CONSTRAINT [RXRMDFQ0_PK] PRIMARY KEY CLUSTERED 
(
	[MED_DOSAGE_FORM_ID] ASC,
	[SCRIPT_QQ_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RXRNCQQ0_QQ_MSTR]') AND name = N'RXRNCQQ0_PK')
ALTER TABLE [NDD_RXRNCQQ0_QQ_MSTR] ADD  CONSTRAINT [RXRNCQQ0_PK] PRIMARY KEY CLUSTERED 
(
	[SCRIPT_QQ_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RXRNSRC0_SOURCE_DESC]') AND name = N'RXRNSRC0_PK')
ALTER TABLE [NDD_RXRNSRC0_SOURCE_DESC] ADD  CONSTRAINT [RXRNSRC0_PK] PRIMARY KEY CLUSTERED 
(
	[XRF_SOURCE_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_RXRPDFQ0_POEMDOSFM_SCRIPT_QQ]') AND name = N'RXRPDFQ0_PK')
ALTER TABLE [NDD_RXRPDFQ0_POEMDOSFM_SCRIPT_QQ] ADD  CONSTRAINT [RXRPDFQ0_PK] PRIMARY KEY CLUSTERED 
(
	[POEUNITCDE] ASC,
	[SCRIPT_QQ_ID] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[VersionCommon]') AND name = N'PK_VersionPRM')
ALTER TABLE [VersionCommon] ADD  CONSTRAINT [PK_VersionPRM] PRIMARY KEY CLUSTERED 
(
	[PRMVersion] DESC,
	[PRMSeq] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_SearchDispensable]') AND name = N'NDD_SearchDispensable_PK')
ALTER TABLE [NDD_SearchDispensable] ADD  CONSTRAINT [NDD_SearchDispensable_PK] PRIMARY KEY NONCLUSTERED 
(
	[medid] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_SearchDrugName]') AND name = N'NDD_SearchDrugName_PK')
ALTER TABLE [NDD_SearchDrugName] ADD  CONSTRAINT [NDD_SearchDrugName_PK] PRIMARY KEY NONCLUSTERED 
(
	[mnid] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_SearchRouted]') AND name = N'NDD_SearchRouted_PK')
ALTER TABLE [NDD_SearchRouted] ADD  CONSTRAINT [NDD_SearchRouted_PK] PRIMARY KEY NONCLUSTERED 
(
	[rmid] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[NDD_SearchRxNorm]') AND name = N'NDD_SearchRxNorm_PK')
ALTER TABLE [NDD_SearchRxNorm] ADD  CONSTRAINT [NDD_SearchRxNorm_PK] PRIMARY KEY NONCLUSTERED 
(
	[PK_HASH] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

