SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_SearchDispensable]') AND name = N'IX_NDD_Dispensable')
CREATE CLUSTERED INDEX [IX_NDD_Dispensable] ON [dbo].[NDD_SearchDispensable]
(
	[SearchMedDesc] ASC,
	[MedDesc] ASC,
	[medid] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_SearchDrugName]') AND name = N'IX_NDD_SearchDrugName')
CREATE CLUSTERED INDEX [IX_NDD_SearchDrugName] ON [dbo].[NDD_SearchDrugName]
(
	[SearchDrugName] ASC,
	[mnid] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_SearchRouted]') AND name = N'IX_NDD_SearchRouted')
CREATE CLUSTERED INDEX [IX_NDD_SearchRouted] ON [dbo].[NDD_SearchRouted]
(
	[SearchRoutedMedDesc] ASC,
	[rmid] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_SearchRxNorm]') AND name = N'IX_NDD_SearchRxNorm')
CREATE CLUSTERED INDEX [IX_NDD_SearchRxNorm] ON [dbo].[NDD_SearchRxNorm]
(
	[RxNormCode] ASC,
	[medid] ASC,
	[mnid] ASC,
	[NDC] ASC,
	[IsDelete] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ICD]') AND name = N'IX_ICD_BASE_TEXT_CODE')
CREATE NONCLUSTERED INDEX [IX_ICD_BASE_TEXT_CODE] ON [dbo].[IMO_ICD]
(
	[ICD_BASE_TEXT_CODE] ASC
)
INCLUDE ( 	[ICD_IMO_CODE]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ICD_MODIFIER]') AND name = N'IX_IMO_ICD_MODIFIER_CODE')
CREATE NONCLUSTERED INDEX [IX_IMO_ICD_MODIFIER_CODE] ON [dbo].[IMO_ICD_MODIFIER]
(
	[ICD_MODIFIER_IMO_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ICD_MODIFIER_MAP]') AND name = N'IX_ICD_IMO_CODE')
CREATE NONCLUSTERED INDEX [IX_ICD_IMO_CODE] ON [dbo].[IMO_ICD_MODIFIER_MAP]
(
	[ICD_IMO_CODE] ASC
)
INCLUDE ( 	[ICD_MODIFIER_IMO_CODE]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ICD_MODIFIER_MAP]') AND name = N'IX_IMO_ICD_MODIFIER_MAP_CODE')
CREATE NONCLUSTERED INDEX [IX_IMO_ICD_MODIFIER_MAP_CODE] ON [dbo].[IMO_ICD_MODIFIER_MAP]
(
	[ICD_MODIFIER_IMO_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_Keywords]') AND name = N'IX_IMO_ProblemIT_Keywords')
CREATE NONCLUSTERED INDEX [IX_IMO_ProblemIT_Keywords] ON [dbo].[IMO_ProblemIT_Keywords]
(
	[WORD_TEXT] ASC
)
INCLUDE ( 	[Code],
	[WORD_POS]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_Keywords]') AND name = N'IX_IMO_ProblemIT_Keywords_Code_WORD_TEXT')
CREATE NONCLUSTERED INDEX [IX_IMO_ProblemIT_Keywords_Code_WORD_TEXT] ON [dbo].[IMO_ProblemIT_Keywords]
(
	[Code] ASC,
	[WORD_TEXT] ASC
)
INCLUDE ( 	[WORD_POS]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_SearchResult_Base]') AND name = N'IX_IMO_ProblemIT_SearchResult_Base_Code10')
CREATE NONCLUSTERED INDEX [IX_IMO_ProblemIT_SearchResult_Base_Code10] ON [dbo].[IMO_ProblemIT_SearchResult_Base]
(
	[Code10] ASC,
	[LexCode] ASC,
	[Code09PrefBase] ASC,
	[Code10PrefBase] ASC
)
INCLUDE ( 	[Code09],
	[CodeDescription10],
	[HccCommunityFactors],
	[ManifestationCode10],
	[Billable10],
	[Specific10],
	[Primary10],
	[CodeDescription09],
	[SnoMedCodeList],
	[ModifierCodeList],
	[ModifiersExistInSubCodes],
	[Syn]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_SearchResult_Base]') AND name = N'IX_IMO_ProblemIT_SearchResult_Base_LexCode')
CREATE NONCLUSTERED INDEX [IX_IMO_ProblemIT_SearchResult_Base_LexCode] ON [dbo].[IMO_ProblemIT_SearchResult_Base]
(
	[LexCode] ASC,
	[Code09PrefBase] ASC,
	[Code10PrefBase] ASC,
	[Code10] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_SearchResult_Base]') AND name = N'IX_IMO_ProblemIT_SearchResult_Base_PrefBase')
CREATE NONCLUSTERED INDEX [IX_IMO_ProblemIT_SearchResult_Base_PrefBase] ON [dbo].[IMO_ProblemIT_SearchResult_Base]
(
	[Code09PrefBase] ASC,
	[Code10PrefBase] ASC,
	[LexCode] ASC,
	[Code10] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MASTER_MU2_InterfaceDataMapping]') AND name = N'ix_MASTER_MU2_InterfaceDataMapping_PRMCode')
CREATE NONCLUSTERED INDEX [ix_MASTER_MU2_InterfaceDataMapping_PRMCode] ON [dbo].[MASTER_MU2_InterfaceDataMapping]
(
	[PRMCode] ASC
)
INCLUDE ( 	[InterfaceDataMappingUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MASTER_MU2_InterfaceDataMapping]') AND name = N'ix_MASTER_MU2_InterfaceDataMapping_QRDASection')
CREATE NONCLUSTERED INDEX [ix_MASTER_MU2_InterfaceDataMapping_QRDASection] ON [dbo].[MASTER_MU2_InterfaceDataMapping]
(
	[QRDASection] ASC
)
INCLUDE ( 	[InterfaceDataMappingUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MASTER_MU2_InterfaceDataMapping]') AND name = N'ix_MASTER_MU2_InterfaceDataMapping_TopicIndicator')
CREATE NONCLUSTERED INDEX [ix_MASTER_MU2_InterfaceDataMapping_TopicIndicator] ON [dbo].[MASTER_MU2_InterfaceDataMapping]
(
	[TopicIndicator] ASC
)
INCLUDE ( 	[InterfaceDataMappingUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MASTER_MU2_InterfaceDataMapping]') AND name = N'Name_NCQMeasure_CCDCode')
CREATE NONCLUSTERED INDEX [Name_NCQMeasure_CCDCode] ON [dbo].[MASTER_MU2_InterfaceDataMapping]
(
	[Name] ASC,
	[NCQMeasure] ASC,
	[CCDCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MASTER_MU2_InterfaceDataMapping]') AND name = N'NCQMeas_Name_DataElementName_Rootid_CCDCode')
CREATE NONCLUSTERED INDEX [NCQMeas_Name_DataElementName_Rootid_CCDCode] ON [dbo].[MASTER_MU2_InterfaceDataMapping]
(
	[NCQMeasure] ASC,
	[Name] ASC,
	[DataElementName] ASC,
	[Rootid] ASC,
	[CCDCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MASTER_MU2_InterfaceDataMapping]') AND name = N'NCQMeas_Name_DataElementName_Rootid_PRMCode')
CREATE NONCLUSTERED INDEX [NCQMeas_Name_DataElementName_Rootid_PRMCode] ON [dbo].[MASTER_MU2_InterfaceDataMapping]
(
	[NCQMeasure] ASC,
	[Name] ASC,
	[DataElementName] ASC,
	[Rootid] ASC,
	[PRMCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MASTER_MU2_InterfaceDataMapping]') AND name = N'NQFNum_Name_DataElementName_Rootid_CCDCode')
CREATE NONCLUSTERED INDEX [NQFNum_Name_DataElementName_Rootid_CCDCode] ON [dbo].[MASTER_MU2_InterfaceDataMapping]
(
	[NQFNumber] ASC,
	[Name] ASC,
	[DataElementName] ASC,
	[Rootid] ASC,
	[CCDCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MASTER_MU2_InterfaceDataMapping]') AND name = N'NQFNum_Name_DataElementName_Rootid_PRMCode')
CREATE NONCLUSTERED INDEX [NQFNum_Name_DataElementName_Rootid_PRMCode] ON [dbo].[MASTER_MU2_InterfaceDataMapping]
(
	[NQFNumber] ASC,
	[Name] ASC,
	[DataElementName] ASC,
	[Rootid] ASC,
	[PRMCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MASTER_MU2_InterfaceDataMapping]') AND name = N'Rootid_Name_CCDCode_PRMCode_DataElementName_Modifier_NCQMeasure')
CREATE NONCLUSTERED INDEX [Rootid_Name_CCDCode_PRMCode_DataElementName_Modifier_NCQMeasure] ON [dbo].[MASTER_MU2_InterfaceDataMapping]
(
	[Rootid] ASC,
	[Name] ASC,
	[CCDCode] ASC,
	[PRMCode] ASC,
	[DataElementName] ASC,
	[Modifier] ASC,
	[NCQMeasure] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterDiagnosis]') AND name = N'IX_DiagnosisCode10')
CREATE NONCLUSTERED INDEX [IX_DiagnosisCode10] ON [dbo].[MasterDiagnosis]
(
	[DiagnosisCode10] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterDiagnosis]') AND name = N'IX_DiagnosisCode9')
CREATE NONCLUSTERED INDEX [IX_DiagnosisCode9] ON [dbo].[MasterDiagnosis]
(
	[DiagnosisCode9] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterDiagnosis]') AND name = N'IX_LongDescription')
CREATE NONCLUSTERED INDEX [IX_LongDescription] ON [dbo].[MasterDiagnosis]
(
	[LongDescription] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterDiagnosis]') AND name = N'IX_ShortDescription')
CREATE NONCLUSTERED INDEX [IX_ShortDescription] ON [dbo].[MasterDiagnosis]
(
	[ShortDescription] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterDiagnosis]') AND name = N'IXR_ExpirationDateW')
CREATE NONCLUSTERED INDEX [IXR_ExpirationDateW] ON [dbo].[MasterDiagnosis]
(
	[ExpirationDate] ASC
)
INCLUDE ( 	[DiagnosisCode9]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterGrowthChart]') AND name = N'IX_MasterGrowthChart')
CREATE UNIQUE NONCLUSTERED INDEX [IX_MasterGrowthChart] ON [dbo].[MasterGrowthChart]
(
	[DataType] ASC,
	[Gender] ASC,
	[Agemos] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RADIMGC4_GCNSEQNO_LINK]') AND name = N'RADIMGC4_NX1')
CREATE NONCLUSTERED INDEX [RADIMGC4_NX1] ON [dbo].[NDD_RADIMGC4_GCNSEQNO_LINK]
(
	[DDI_CODEX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RADIMIE4_CLIN_EFFECTS_LINK]') AND name = N'RADIMIE4_NX1')
CREATE NONCLUSTERED INDEX [RADIMIE4_NX1] ON [dbo].[NDD_RADIMIE4_CLIN_EFFECTS_LINK]
(
	[ADI_EFFTC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RADIMMA5_MSTR]') AND name = N'RADIMMA5_NX1')
CREATE NONCLUSTERED INDEX [RADIMMA5_NX1] ON [dbo].[NDD_RADIMMA5_MSTR]
(
	[DDI_SL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RADIMMA5_MSTR]') AND name = N'RADIMMA5_NX2')
CREATE NONCLUSTERED INDEX [RADIMMA5_NX2] ON [dbo].[NDD_RADIMMA5_MSTR]
(
	[DDI_MONOX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RADIMMO5_MONO]') AND name = N'RADIMMO5_NX1')
CREATE NONCLUSTERED INDEX [RADIMMO5_NX1] ON [dbo].[NDD_RADIMMO5_MONO]
(
	[IAMREFCAT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RAHFSGC1_GCNSEQNO_LINK]') AND name = N'RAHFSGC0_NX1')
CREATE NONCLUSTERED INDEX [RAHFSGC0_NX1] ON [dbo].[NDD_RAHFSGC1_GCNSEQNO_LINK]
(
	[AHFS8] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RATCGC0_ATC_GCNSEQNO_LINK]') AND name = N'RATCGC0_NX1')
CREATE NONCLUSTERED INDEX [RATCGC0_NX1] ON [dbo].[NDD_RATCGC0_ATC_GCNSEQNO_LINK]
(
	[ATC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RCMMGC0_GCNSEQNO_LINK]') AND name = N'RCMMGC0_NX1')
CREATE NONCLUSTERED INDEX [RCMMGC0_NX1] ON [dbo].[NDD_RCMMGC0_GCNSEQNO_LINK]
(
	[CMMC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDDCMGC0_CONTRA_GCNSEQNO_LINK]') AND name = N'RDDCMGC0_NX1')
CREATE NONCLUSTERED INDEX [RDDCMGC0_NX1] ON [dbo].[NDD_RDDCMGC0_CONTRA_GCNSEQNO_LINK]
(
	[DDXCN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDDCMMA1_CONTRA_MSTR]') AND name = N'RDDCMMA1_NX1')
CREATE NONCLUSTERED INDEX [RDDCMMA1_NX1] ON [dbo].[NDD_RDDCMMA1_CONTRA_MSTR]
(
	[FDBDX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDDCMMA1_CONTRA_MSTR]') AND name = N'RDDCMMA1_NX2')
CREATE NONCLUSTERED INDEX [RDDCMMA1_NX2] ON [dbo].[NDD_RDDCMMA1_CONTRA_MSTR]
(
	[DXID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDDCMRM0_ROUTED_MED_LINK]') AND name = N'RDDCMRM0_NX1')
CREATE NONCLUSTERED INDEX [RDDCMRM0_NX1] ON [dbo].[NDD_RDDCMRM0_ROUTED_MED_LINK]
(
	[DDXCN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDDIMRM0_ROUTED_MED_LINK]') AND name = N'RDDIMRM0_NX1')
CREATE NONCLUSTERED INDEX [RDDIMRM0_NX1] ON [dbo].[NDD_RDDIMRM0_ROUTED_MED_LINK]
(
	[DDI_CODEX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDFIMGC0_GCNSEQNO_LINK]') AND name = N'RDFIMGC0_NX1')
CREATE NONCLUSTERED INDEX [RDFIMGC0_NX1] ON [dbo].[NDD_RDFIMGC0_GCNSEQNO_LINK]
(
	[FDCDE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDFIMRM0_ROUTED_MED_LINK]') AND name = N'RDFIMRM0_NX1')
CREATE NONCLUSTERED INDEX [RDFIMRM0_NX1] ON [dbo].[NDD_RDFIMRM0_ROUTED_MED_LINK]
(
	[FDCDE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDPTGC0_GCNSEQNO_LINK]') AND name = N'RDPTGC0_NX1')
CREATE NONCLUSTERED INDEX [RDPTGC0_NX1] ON [dbo].[NDD_RDPTGC0_GCNSEQNO_LINK]
(
	[DPT_CLASS_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDPTRTM0_ROUTED_MED_LINK]') AND name = N'RDPTRTM0_NX1')
CREATE NONCLUSTERED INDEX [RDPTRTM0_NX1] ON [dbo].[NDD_RDPTRTM0_ROUTED_MED_LINK]
(
	[DPT_CLASS_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDRCMA2_MSTR]') AND name = N'RDRCMA2_NX1')
CREATE NONCLUSTERED INDEX [RDRCMA2_NX1] ON [dbo].[NDD_RDRCMA2_MSTR]
(
	[DR2_RT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDRCMA2_MSTR]') AND name = N'RDRCMA2_NX2')
CREATE NONCLUSTERED INDEX [RDRCMA2_NX2] ON [dbo].[NDD_RDRCMA2_MSTR]
(
	[DR2_DOSTPI] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDRCMA2_MSTR]') AND name = N'RDRCMA2_NX3')
CREATE NONCLUSTERED INDEX [RDRCMA2_NX3] ON [dbo].[NDD_RDRCMA2_MSTR]
(
	[DR2_LOAGED] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDRCMA2_MSTR]') AND name = N'RDRCMA2_NX4')
CREATE NONCLUSTERED INDEX [RDRCMA2_NX4] ON [dbo].[NDD_RDRCMA2_MSTR]
(
	[DR2_HIAGED] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDRCMA2_MSTR]') AND name = N'RDRCMA2_NX5')
CREATE NONCLUSTERED INDEX [RDRCMA2_NX5] ON [dbo].[NDD_RDRCMA2_MSTR]
(
	[FDBDX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDRCMA2_MSTR]') AND name = N'RDRCMA2_NX6')
CREATE NONCLUSTERED INDEX [RDRCMA2_NX6] ON [dbo].[NDD_RDRCMA2_MSTR]
(
	[DXID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RDRCXRT0_XREF]') AND name = N'RDRCXRT0_NX1')
CREATE NONCLUSTERED INDEX [RDRCXRT0_NX1] ON [dbo].[NDD_RDRCXRT0_XREF]
(
	[DR2_RT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCGC0_ETC_GCNSEQNO]') AND name = N'RETCGC0_NX1')
CREATE NONCLUSTERED INDEX [RETCGC0_NX1] ON [dbo].[NDD_RETCGC0_ETC_GCNSEQNO]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCGCH0_ETC_GCNSEQNO_HIST]') AND name = N'RETCGCH0_NX1')
CREATE NONCLUSTERED INDEX [RETCGCH0_NX1] ON [dbo].[NDD_RETCGCH0_ETC_GCNSEQNO_HIST]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCHCH0_ETC_HICSEQN_HIST]') AND name = N'RETCHCH0_NX1')
CREATE NONCLUSTERED INDEX [RETCHCH0_NX1] ON [dbo].[NDD_RETCHCH0_ETC_HICSEQN_HIST]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCHCL0_ETC_HICLSEQNO]') AND name = N'IX_RETCHCL0_ETC_HICLSEQNO')
CREATE NONCLUSTERED INDEX [IX_RETCHCL0_ETC_HICLSEQNO] ON [dbo].[NDD_RETCHCL0_ETC_HICLSEQNO]
(
	[ETC_ID] ASC
)
INCLUDE ( 	[HICL_SEQNO]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCHCL0_ETC_HICLSEQNO]') AND name = N'RETCHCL0_NX1')
CREATE NONCLUSTERED INDEX [RETCHCL0_NX1] ON [dbo].[NDD_RETCHCL0_ETC_HICLSEQNO]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCHIC0_ETC_HICSEQN]') AND name = N'RETCHIC0_NX1')
CREATE NONCLUSTERED INDEX [RETCHIC0_NX1] ON [dbo].[NDD_RETCHIC0_ETC_HICSEQN]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCHLH0_ETC_HICLSEQNO_HIST]') AND name = N'RETCHLH0_NX1')
CREATE NONCLUSTERED INDEX [RETCHLH0_NX1] ON [dbo].[NDD_RETCHLH0_ETC_HICLSEQNO_HIST]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCMDH0_ETC_MEDID_HIST]') AND name = N'RETCMDH0_NX1')
CREATE NONCLUSTERED INDEX [RETCMDH0_NX1] ON [dbo].[NDD_RETCMDH0_ETC_MEDID_HIST]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCMED0_ETC_MEDID]') AND name = N'IX_RETCMED0_ETC_MEDID_Search')
CREATE NONCLUSTERED INDEX [IX_RETCMED0_ETC_MEDID_Search] ON [dbo].[NDD_RETCMED0_ETC_MEDID]
(
	[ETC_ID] ASC
)
INCLUDE ( 	[MEDID],
	[ETC_COMMON_USE_IND],
	[ETC_DEFAULT_USE_IND],
	[LastModifiedDate],
	[IsDelete]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCMED0_ETC_MEDID]') AND name = N'RETCMED0_NX1')
CREATE NONCLUSTERED INDEX [RETCMED0_NX1] ON [dbo].[NDD_RETCMED0_ETC_MEDID]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCMNM0_ETC_MED_NAME_ID]') AND name = N'IX_RETCMNM0_ETC_MED_NAME_ID')
CREATE NONCLUSTERED INDEX [IX_RETCMNM0_ETC_MED_NAME_ID] ON [dbo].[NDD_RETCMNM0_ETC_MED_NAME_ID]
(
	[ETC_ID] ASC
)
INCLUDE ( 	[MED_NAME_ID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCMNM0_ETC_MED_NAME_ID]') AND name = N'RETCMNM0_NX1')
CREATE NONCLUSTERED INDEX [RETCMNM0_NX1] ON [dbo].[NDD_RETCMNM0_ETC_MED_NAME_ID]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCNDC0_ETC_NDC]') AND name = N'IX_RETCNDC0_ETC_NDC')
CREATE NONCLUSTERED INDEX [IX_RETCNDC0_ETC_NDC] ON [dbo].[NDD_RETCNDC0_ETC_NDC]
(
	[ETC_ID] ASC
)
INCLUDE ( 	[NDC]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCNDC0_ETC_NDC]') AND name = N'RETCNDC0_NX1')
CREATE NONCLUSTERED INDEX [RETCNDC0_NX1] ON [dbo].[NDD_RETCNDC0_ETC_NDC]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCNDH0_ETC_NDC_HIST]') AND name = N'RETCNDH0_NX1')
CREATE NONCLUSTERED INDEX [RETCNDH0_NX1] ON [dbo].[NDD_RETCNDH0_ETC_NDC_HIST]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCNMH0_ETC_MED_NAME_ID_HIST]') AND name = N'RETCNMH0_NX1')
CREATE NONCLUSTERED INDEX [RETCNMH0_NX1] ON [dbo].[NDD_RETCNMH0_ETC_MED_NAME_ID_HIST]
(
	[ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCSCH0_ETC_SEARCH]') AND name = N'RETCSCH0_NX1')
CREATE NONCLUSTERED INDEX [RETCSCH0_NX1] ON [dbo].[NDD_RETCSCH0_ETC_SEARCH]
(
	[ETC_PRODUCT_RELATED_ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCTBL0_ETC_ID]') AND name = N'IX_NDD_RETCTBL0_ETC_ID_ULTIMATE_PARENT')
CREATE NONCLUSTERED INDEX [IX_NDD_RETCTBL0_ETC_ID_ULTIMATE_PARENT] ON [dbo].[NDD_RETCTBL0_ETC_ID]
(
	[ETC_ULTIMATE_PARENT_ETC_ID] ASC
)
INCLUDE ( 	[ETC_ID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCTBL0_ETC_ID]') AND name = N'IX_RETCTBL0_ETC_ID_Search')
CREATE NONCLUSTERED INDEX [IX_RETCTBL0_ETC_ID_Search] ON [dbo].[NDD_RETCTBL0_ETC_ID]
(
	[ETC_NAME] ASC
)
INCLUDE ( 	[ETC_ID],
	[ETC_ULTIMATE_CHILD_IND],
	[ETC_DRUG_CONCEPT_LINK_IND],
	[ETC_PARENT_ETC_ID],
	[ETC_FORMULARY_LEVEL_IND],
	[ETC_PRESENTATION_SEQNO],
	[ETC_ULTIMATE_PARENT_ETC_ID],
	[ETC_HIERARCHY_LEVEL],
	[ETC_SORT_NUMBER],
	[ETC_RETIRED_IND],
	[ETC_RETIRED_DATE],
	[LastModifiedDate],
	[IsDelete]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCTBL0_ETC_ID]') AND name = N'RETCTBL0_NX1')
CREATE NONCLUSTERED INDEX [RETCTBL0_NX1] ON [dbo].[NDD_RETCTBL0_ETC_ID]
(
	[ETC_PARENT_ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCTBL0_ETC_ID]') AND name = N'RETCTBL0_NX2')
CREATE NONCLUSTERED INDEX [RETCTBL0_NX2] ON [dbo].[NDD_RETCTBL0_ETC_ID]
(
	[ETC_ULTIMATE_PARENT_ETC_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RETCXRF0_ETC_HIC3_ETC]') AND name = N'RETCXRF0_NX1')
CREATE NONCLUSTERED INDEX [RETCXRF0_NX1] ON [dbo].[NDD_RETCXRF0_ETC_HIC3_ETC]
(
	[HIC3_SEQN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLDRH0_DXID_HIST]') AND name = N'RFMLDRH0_NX1')
CREATE NONCLUSTERED INDEX [RFMLDRH0_NX1] ON [dbo].[NDD_RFMLDRH0_DXID_HIST]
(
	[FMLREPDXID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLDSR0_DXID_SEARCH]') AND name = N'RFMLDSR0_NX1')
CREATE NONCLUSTERED INDEX [RFMLDSR0_NX1] ON [dbo].[NDD_RFMLDSR0_DXID_SEARCH]
(
	[FML_NAV_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLDSR0_DXID_SEARCH]') AND name = N'RFMLDSR0_NX2')
CREATE NONCLUSTERED INDEX [RFMLDSR0_NX2] ON [dbo].[NDD_RFMLDSR0_DXID_SEARCH]
(
	[FML_CLIN_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLDSR0_DXID_SEARCH]') AND name = N'RFMLDSR0_NX3')
CREATE NONCLUSTERED INDEX [RFMLDSR0_NX3] ON [dbo].[NDD_RFMLDSR0_DXID_SEARCH]
(
	[RELATED_DXID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLDX0_DXID]') AND name = N'RFMLDX0_NX1')
CREATE NONCLUSTERED INDEX [RFMLDX0_NX1] ON [dbo].[NDD_RFMLDX0_DXID]
(
	[DXID_STATUS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLDX0_DXID]') AND name = N'RFMLDX0_NX2')
CREATE NONCLUSTERED INDEX [RFMLDX0_NX2] ON [dbo].[NDD_RFMLDX0_DXID]
(
	[FDBDX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLDX0_DXID]') AND name = N'RFMLDX0_NX3')
CREATE NONCLUSTERED INDEX [RFMLDX0_NX3] ON [dbo].[NDD_RFMLDX0_DXID]
(
	[DXID_DISEASE_DURATION_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLNAV0_DXID_NAVIGATION]') AND name = N'RFMLNAV0_NX1')
CREATE NONCLUSTERED INDEX [RFMLNAV0_NX1] ON [dbo].[NDD_RFMLNAV0_DXID_NAVIGATION]
(
	[BROADER_DXID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLSYN0_DXID_SYN]') AND name = N'RFMLSYN0_NX1')
CREATE NONCLUSTERED INDEX [RFMLSYN0_NX1] ON [dbo].[NDD_RFMLSYN0_DXID_SYN]
(
	[DXID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLSYN0_DXID_SYN]') AND name = N'RFMLSYN0_NX2')
CREATE NONCLUSTERED INDEX [RFMLSYN0_NX2] ON [dbo].[NDD_RFMLSYN0_DXID_SYN]
(
	[DXID_SYN_NMTYP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RFMLSYN0_DXID_SYN]') AND name = N'RFMLSYN0_NX3')
CREATE NONCLUSTERED INDEX [RFMLSYN0_NX3] ON [dbo].[NDD_RFMLSYN0_DXID_SYN]
(
	[DXID_SYN_STATUS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNINH0_GCNSEQNO_INACTV_LINK]') AND name = N'RGCNINH0_NX1')
CREATE NONCLUSTERED INDEX [RGCNINH0_NX1] ON [dbo].[NDD_RGCNINH0_GCNSEQNO_INACTV_LINK]
(
	[HIC_SEQN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_NX1')
CREATE NONCLUSTERED INDEX [RGCNSEQ4_NX1] ON [dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]
(
	[HIC3] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_NX2')
CREATE NONCLUSTERED INDEX [RGCNSEQ4_NX2] ON [dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]
(
	[HICL_SEQNO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_NX3')
CREATE NONCLUSTERED INDEX [RGCNSEQ4_NX3] ON [dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]
(
	[GCDF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_NX4')
CREATE NONCLUSTERED INDEX [RGCNSEQ4_NX4] ON [dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]
(
	[GCRT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_NX5')
CREATE NONCLUSTERED INDEX [RGCNSEQ4_NX5] ON [dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]
(
	[STR60] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_NX6')
CREATE NONCLUSTERED INDEX [RGCNSEQ4_NX6] ON [dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]
(
	[GTC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_NX7')
CREATE NONCLUSTERED INDEX [RGCNSEQ4_NX7] ON [dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]
(
	[TC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_NX8')
CREATE NONCLUSTERED INDEX [RGCNSEQ4_NX8] ON [dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]
(
	[DCC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]') AND name = N'RGCNSEQ4_NX9')
CREATE NONCLUSTERED INDEX [RGCNSEQ4_NX9] ON [dbo].[NDD_RGCNSEQ4_GCNSEQNO_MSTR]
(
	[HIC3_SEQN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGERIGC0_GERI_GCNSEQNO_LINK]') AND name = N'RGERIGC0_NX1')
CREATE NONCLUSTERED INDEX [RGERIGC0_NX1] ON [dbo].[NDD_RGERIGC0_GERI_GCNSEQNO_LINK]
(
	[GERI_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RGERIRM0_ROUTED_MED_LINK]') AND name = N'RGERIRM0_NX1')
CREATE NONCLUSTERED INDEX [RGERIRM0_NX1] ON [dbo].[NDD_RGERIRM0_ROUTED_MED_LINK]
(
	[GERI_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHIC1D2_HIC_ORGAN_SYS_DESC]') AND name = N'RHIC1D2_NX1')
CREATE NONCLUSTERED INDEX [RHIC1D2_NX1] ON [dbo].[NDD_RHIC1D2_HIC_ORGAN_SYS_DESC]
(
	[HIC1] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHIC2D3_HIC_RX_CLASS_DESC]') AND name = N'RHIC2D3_NX1')
CREATE NONCLUSTERED INDEX [RHIC2D3_NX1] ON [dbo].[NDD_RHIC2D3_HIC_RX_CLASS_DESC]
(
	[HIC2] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHIC2D3_HIC_RX_CLASS_DESC]') AND name = N'RHIC2D3_NX2')
CREATE NONCLUSTERED INDEX [RHIC2D3_NX2] ON [dbo].[NDD_RHIC2D3_HIC_RX_CLASS_DESC]
(
	[HIC2_ROOT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHIC3D3_HIC_THERAP_CLASS_DESC]') AND name = N'RHIC3D3_NX1')
CREATE NONCLUSTERED INDEX [RHIC3D3_NX1] ON [dbo].[NDD_RHIC3D3_HIC_THERAP_CLASS_DESC]
(
	[HIC3] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHIC3D3_HIC_THERAP_CLASS_DESC]') AND name = N'RHIC3D3_NX2')
CREATE NONCLUSTERED INDEX [RHIC3D3_NX2] ON [dbo].[NDD_RHIC3D3_HIC_THERAP_CLASS_DESC]
(
	[HIC3_ROOT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHIC3L2_HIC3_HICLSEQNO_LINK]') AND name = N'RHIC3L2_NX1')
CREATE NONCLUSTERED INDEX [RHIC3L2_NX1] ON [dbo].[NDD_RHIC3L2_HIC3_HICLSEQNO_LINK]
(
	[HIC3_SEQN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHIC3L2_HIC3_HICLSEQNO_LINK]') AND name = N'RHIC3L2_NX2')
CREATE NONCLUSTERED INDEX [RHIC3L2_NX2] ON [dbo].[NDD_RHIC3L2_HIC3_HICLSEQNO_LINK]
(
	[HIC3] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHIC4D2_HIC_BASE_ING_DESC]') AND name = N'RHIC4D2_NX1')
CREATE NONCLUSTERED INDEX [RHIC4D2_NX1] ON [dbo].[NDD_RHIC4D2_HIC_BASE_ING_DESC]
(
	[HIC4] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHIC4D2_HIC_BASE_ING_DESC]') AND name = N'RHIC4D2_NX2')
CREATE NONCLUSTERED INDEX [RHIC4D2_NX2] ON [dbo].[NDD_RHIC4D2_HIC_BASE_ING_DESC]
(
	[HIC4_ROOT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHICD5_HIC_DESC]') AND name = N'RHICD5_NX2')
CREATE NONCLUSTERED INDEX [RHICD5_NX2] ON [dbo].[NDD_RHICD5_HIC_DESC]
(
	[HIC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHICD5_HIC_DESC]') AND name = N'RHICD5_NX3')
CREATE NONCLUSTERED INDEX [RHICD5_NX3] ON [dbo].[NDD_RHICD5_HIC_DESC]
(
	[HIC_ROOT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHICL1_HIC_HICLSEQNO_LINK]') AND name = N'RHICL1_NX1')
CREATE NONCLUSTERED INDEX [RHICL1_NX1] ON [dbo].[NDD_RHICL1_HIC_HICLSEQNO_LINK]
(
	[HIC_SEQN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RHICL1_HIC_HICLSEQNO_LINK]') AND name = N'RHICL1_NX2')
CREATE NONCLUSTERED INDEX [RHICL1_NX2] ON [dbo].[NDD_RHICL1_HIC_HICLSEQNO_LINK]
(
	[HIC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RINDMGC0_INDCTS_GCNSEQNO_LINK]') AND name = N'RINDMGC0_NX1')
CREATE NONCLUSTERED INDEX [RINDMGC0_NX1] ON [dbo].[NDD_RINDMGC0_INDCTS_GCNSEQNO_LINK]
(
	[INDCTS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RINDMMA2_INDCTS_MSTR]') AND name = N'RINDMMA2_NX1')
CREATE NONCLUSTERED INDEX [RINDMMA2_NX1] ON [dbo].[NDD_RINDMMA2_INDCTS_MSTR]
(
	[INDCTS_LBL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RINDMMA2_INDCTS_MSTR]') AND name = N'RINDMMA2_NX2')
CREATE NONCLUSTERED INDEX [RINDMMA2_NX2] ON [dbo].[NDD_RINDMMA2_INDCTS_MSTR]
(
	[PRED_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RINDMMA2_INDCTS_MSTR]') AND name = N'RINDMMA2_NX3')
CREATE NONCLUSTERED INDEX [RINDMMA2_NX3] ON [dbo].[NDD_RINDMMA2_INDCTS_MSTR]
(
	[DXID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RINDMMA2_INDCTS_MSTR]') AND name = N'RINDMMA2_NX4')
CREATE NONCLUSTERED INDEX [RINDMMA2_NX4] ON [dbo].[NDD_RINDMMA2_INDCTS_MSTR]
(
	[FDBDX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RINDMRM0_ROUTED_MED_LINK]') AND name = N'RINDMRM0_NX1')
CREATE NONCLUSTERED INDEX [RINDMRM0_NX1] ON [dbo].[NDD_RINDMRM0_ROUTED_MED_LINK]
(
	[INDCTS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RIVMACO0_ADMXTR_COMP_LINK]') AND name = N'RIVMACO0_NX1')
CREATE NONCLUSTERED INDEX [RIVMACO0_NX1] ON [dbo].[NDD_RIVMACO0_ADMXTR_COMP_LINK]
(
	[IVMCOMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RIVMCGC0_COMP_GCNSEQNO_LINK]') AND name = N'RIVMCGC0_NX1')
CREATE NONCLUSTERED INDEX [RIVMCGC0_NX1] ON [dbo].[NDD_RIVMCGC0_COMP_GCNSEQNO_LINK]
(
	[IVMCOMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RIVMSAD0_STDY_GRP_ADMXTR_LINK]') AND name = N'RIVMSAD0_NX1')
CREATE NONCLUSTERED INDEX [RIVMSAD0_NX1] ON [dbo].[NDD_RIVMSAD0_STDY_GRP_ADMXTR_LINK]
(
	[IVMADMIX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT]') AND name = N'RIVMTCO0_NX1')
CREATE NONCLUSTERED INDEX [RIVMTCO0_NX1] ON [dbo].[NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT]
(
	[IVMADMIX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT]') AND name = N'RIVMTCO0_NX2')
CREATE NONCLUSTERED INDEX [RIVMTCO0_NX2] ON [dbo].[NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT]
(
	[IVMCOMP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT]') AND name = N'RIVMTCO0_NX3')
CREATE NONCLUSTERED INDEX [RIVMTCO0_NX3] ON [dbo].[NDD_RIVMTCO0_STDY_GRP_TST_COMP_DT]
(
	[IVMMFG] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RIVMTPI0_TPN_ING_DESC]') AND name = N'RIVMTPI0')
CREATE NONCLUSTERED INDEX [RIVMTPI0] ON [dbo].[NDD_RIVMTPI0_TPN_ING_DESC]
(
	[IVMMFG] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RLACTGC0_LACT_GCNSEQNO_LINK]') AND name = N'RLACTGC0_NX1')
CREATE NONCLUSTERED INDEX [RLACTGC0_NX1] ON [dbo].[NDD_RLACTGC0_LACT_GCNSEQNO_LINK]
(
	[LACT_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RLACTRM0_ROUTED_MED_LINK]') AND name = N'RLACTRM0_NX1')
CREATE NONCLUSTERED INDEX [RLACTRM0_NX1] ON [dbo].[NDD_RLACTRM0_ROUTED_MED_LINK]
(
	[LACT_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RLBLWGC0_GCNSEQNO_LINK]') AND name = N'RLBLWGC0_NX1')
CREATE NONCLUSTERED INDEX [RLBLWGC0_NX1] ON [dbo].[NDD_RLBLWGC0_GCNSEQNO_LINK]
(
	[LBL_WARN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RLBLWV0_VENDOR_LINK]') AND name = N'RLBLWV0_NX1')
CREATE NONCLUSTERED INDEX [RLBLWV0_NX1] ON [dbo].[NDD_RLBLWV0_VENDOR_LINK]
(
	[LBLW_VTYPE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIDFD1_DOSE_FORM]') AND name = N'RMIDFD1_NX1')
CREATE NONCLUSTERED INDEX [RMIDFD1_NX1] ON [dbo].[NDD_RMIDFD1_DOSE_FORM]
(
	[MED_DOSAGE_FORM_ABBR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]') AND name = N'IX_RMIDFID1_ROUTED_DOSE_FORM_MED')
CREATE NONCLUSTERED INDEX [IX_RMIDFID1_ROUTED_DOSE_FORM_MED] ON [dbo].[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]
(
	[ROUTED_MED_ID] ASC
)
INCLUDE ( 	[ROUTED_DOSAGE_FORM_MED_ID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]') AND name = N'RMIDFID1_NX1')
CREATE NONCLUSTERED INDEX [RMIDFID1_NX1] ON [dbo].[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]
(
	[ROUTED_MED_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]') AND name = N'RMIDFID1_NX2')
CREATE NONCLUSTERED INDEX [RMIDFID1_NX2] ON [dbo].[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]
(
	[MED_DOSAGE_FORM_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]') AND name = N'RMIDFID1_NX3')
CREATE NONCLUSTERED INDEX [RMIDFID1_NX3] ON [dbo].[NDD_RMIDFID1_ROUTED_DOSE_FORM_MED]
(
	[MED_STATUS_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIDFRH1_ROUTED_DOSE_FORM_HIST]') AND name = N'RMIDFRH1_NX1')
CREATE NONCLUSTERED INDEX [RMIDFRH1_NX1] ON [dbo].[NDD_RMIDFRH1_ROUTED_DOSE_FORM_HIST]
(
	[MED_PREV_ROUTED_DF_MED_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIGC1_MEDID_GCNSEQNO_LINK]') AND name = N'RMIGC1_NX')
CREATE NONCLUSTERED INDEX [RMIGC1_NX] ON [dbo].[NDD_RMIGC1_MEDID_GCNSEQNO_LINK]
(
	[MEDID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'IX_Med_Medid_Desc_Search')
CREATE NONCLUSTERED INDEX [IX_Med_Medid_Desc_Search] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_MEDID_DESC] ASC
)
INCLUDE ( 	[MEDID],
	[ROUTED_DOSAGE_FORM_MED_ID],
	[MED_STRENGTH],
	[MED_STRENGTH_UOM],
	[GCN_SEQNO],
	[MED_GCNSEQNO_ASSIGN_CD],
	[MED_NAME_SOURCE_CD],
	[MED_REF_FED_LEGEND_IND],
	[MED_REF_DEA_CD],
	[MED_REF_MULTI_SOURCE_CD],
	[MED_REF_GEN_DRUG_NAME_CD],
	[MED_REF_GEN_COMP_PRICE_CD],
	[MED_REF_GEN_SPREAD_CD],
	[MED_REF_INNOV_IND],
	[MED_REF_GEN_THERA_EQU_CD],
	[MED_REF_DESI_IND],
	[MED_REF_DESI2_IND],
	[MED_STATUS_CD],
	[GENERIC_MEDID],
	[LastModifiedDate],
	[IsDelete]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'IX_NDD_RMIID1_MED_GCN_SEQNO')
CREATE NONCLUSTERED INDEX [IX_NDD_RMIID1_MED_GCN_SEQNO] ON [dbo].[NDD_RMIID1_MED]
(
	[GCN_SEQNO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'IX_NDD_RMIID1_MED_MED_STRENGTH')
CREATE NONCLUSTERED INDEX [IX_NDD_RMIID1_MED_MED_STRENGTH] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_STRENGTH] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'IX_ROUTED_DOSAGE_FORM_MED_ID')
CREATE NONCLUSTERED INDEX [IX_ROUTED_DOSAGE_FORM_MED_ID] ON [dbo].[NDD_RMIID1_MED]
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC
)
INCLUDE ( 	[GCN_SEQNO]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX1')
CREATE NONCLUSTERED INDEX [RMIID1_NX1] ON [dbo].[NDD_RMIID1_MED]
(
	[ROUTED_DOSAGE_FORM_MED_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX10')
CREATE NONCLUSTERED INDEX [RMIID1_NX10] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_GEN_COMP_PRICE_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX11')
CREATE NONCLUSTERED INDEX [RMIID1_NX11] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_GEN_SPREAD_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX12')
CREATE NONCLUSTERED INDEX [RMIID1_NX12] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_INNOV_IND] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX13')
CREATE NONCLUSTERED INDEX [RMIID1_NX13] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_GEN_THERA_EQU_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX14')
CREATE NONCLUSTERED INDEX [RMIID1_NX14] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_DESI_IND] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX15')
CREATE NONCLUSTERED INDEX [RMIID1_NX15] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_DESI2_IND] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX16')
CREATE NONCLUSTERED INDEX [RMIID1_NX16] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_STATUS_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX2')
CREATE NONCLUSTERED INDEX [RMIID1_NX2] ON [dbo].[NDD_RMIID1_MED]
(
	[GCN_SEQNO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX3')
CREATE NONCLUSTERED INDEX [RMIID1_NX3] ON [dbo].[NDD_RMIID1_MED]
(
	[GENERIC_MEDID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX4')
CREATE NONCLUSTERED INDEX [RMIID1_NX4] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_GCNSEQNO_ASSIGN_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX5')
CREATE NONCLUSTERED INDEX [RMIID1_NX5] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_NAME_SOURCE_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX6')
CREATE NONCLUSTERED INDEX [RMIID1_NX6] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_FED_LEGEND_IND] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX7')
CREATE NONCLUSTERED INDEX [RMIID1_NX7] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_DEA_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX8')
CREATE NONCLUSTERED INDEX [RMIID1_NX8] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_MULTI_SOURCE_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIID1_MED]') AND name = N'RMIID1_NX9')
CREATE NONCLUSTERED INDEX [RMIID1_NX9] ON [dbo].[NDD_RMIID1_MED]
(
	[MED_REF_GEN_DRUG_NAME_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMINDC1_NDC_MEDID]') AND name = N'RMINDC1_NX1')
CREATE NONCLUSTERED INDEX [RMINDC1_NX1] ON [dbo].[NDD_RMINDC1_NDC_MEDID]
(
	[MEDID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMINMID1_MED_NAME]') AND name = N'IX_Med_Name_Search')
CREATE NONCLUSTERED INDEX [IX_Med_Name_Search] ON [dbo].[NDD_RMINMID1_MED_NAME]
(
	[MED_NAME] ASC
)
INCLUDE ( 	[MED_NAME_ID],
	[MED_NAME_TYPE_CD],
	[MED_STATUS_CD]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMINMID1_MED_NAME]') AND name = N'RMINMID1_NX1')
CREATE NONCLUSTERED INDEX [RMINMID1_NX1] ON [dbo].[NDD_RMINMID1_MED_NAME]
(
	[MED_NAME_TYPE_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMINMID1_MED_NAME]') AND name = N'RMINMID1_NX2')
CREATE NONCLUSTERED INDEX [RMINMID1_NX2] ON [dbo].[NDD_RMINMID1_MED_NAME]
(
	[MED_STATUS_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMINMID1_MED_NAME]') AND name = N'RMINMID1_NX3')
CREATE NONCLUSTERED INDEX [RMINMID1_NX3] ON [dbo].[NDD_RMINMID1_MED_NAME]
(
	[MED_NAME] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMINMRH1_MED_NAME_HIST]') AND name = N'RMINMRH1_NX1')
CREATE NONCLUSTERED INDEX [RMINMRH1_NX1] ON [dbo].[NDD_RMINMRH1_MED_NAME_HIST]
(
	[MED_PREV_NAME_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIRH1_MED_HIST]') AND name = N'RMIRH1_NX1')
CREATE NONCLUSTERED INDEX [RMIRH1_NX1] ON [dbo].[NDD_RMIRH1_MED_HIST]
(
	[MED_PREV_MEDID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIRMID1_ROUTED_MED]') AND name = N'IX_RMIRMID1_ROUTED_MED')
CREATE NONCLUSTERED INDEX [IX_RMIRMID1_ROUTED_MED] ON [dbo].[NDD_RMIRMID1_ROUTED_MED]
(
	[MED_NAME_ID] ASC
)
INCLUDE ( 	[ROUTED_MED_ID],
	[MED_ROUTE_ID],
	[MED_ROUTED_MED_ID_DESC],
	[MED_STATUS_CD],
	[LastModifiedDate],
	[IsDelete]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIRMID1_ROUTED_MED]') AND name = N'RMIRMID1_NX1')
CREATE NONCLUSTERED INDEX [RMIRMID1_NX1] ON [dbo].[NDD_RMIRMID1_ROUTED_MED]
(
	[MED_NAME_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIRMID1_ROUTED_MED]') AND name = N'RMIRMID1_NX2')
CREATE NONCLUSTERED INDEX [RMIRMID1_NX2] ON [dbo].[NDD_RMIRMID1_ROUTED_MED]
(
	[MED_ROUTE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIRMID1_ROUTED_MED]') AND name = N'RMIRMID1_NX3')
CREATE NONCLUSTERED INDEX [RMIRMID1_NX3] ON [dbo].[NDD_RMIRMID1_ROUTED_MED]
(
	[MED_STATUS_CD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIRMRH1_ROUTED_MED_HIST]') AND name = N'RMIRMRH1_NX1')
CREATE NONCLUSTERED INDEX [RMIRMRH1_NX1] ON [dbo].[NDD_RMIRMRH1_ROUTED_MED_HIST]
(
	[MED_PREV_ROUTED_MED_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RMIRTD1_ROUTE]') AND name = N'RMIRTD1_NX1')
CREATE NONCLUSTERED INDEX [RMIRTD1_NX1] ON [dbo].[NDD_RMIRTD1_ROUTE]
(
	[MED_ROUTE_ABBR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RNDC14_NDC_MSTR]') AND name = N'RNDC14_NX1')
CREATE NONCLUSTERED INDEX [RNDC14_NX1] ON [dbo].[NDD_RNDC14_NDC_MSTR]
(
	[LBLRID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RNDC14_NDC_MSTR]') AND name = N'RNDC14_NX2')
CREATE NONCLUSTERED INDEX [RNDC14_NX2] ON [dbo].[NDD_RNDC14_NDC_MSTR]
(
	[GCN_SEQNO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RNDCINH0_NDC_INACTV_LINK]') AND name = N'RNDCINH0_NX1')
CREATE NONCLUSTERED INDEX [RNDCINH0_NX1] ON [dbo].[NDD_RNDCINH0_NDC_INACTV_LINK]
(
	[HIC_SEQN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RNP2_NDC_PRICE]') AND name = N'RNP2_NX1')
CREATE NONCLUSTERED INDEX [RNP2_NX1] ON [dbo].[NDD_RNP2_NDC_PRICE]
(
	[NPT_TYPE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPDMMA1_PEDI_MSTR]') AND name = N'RPDMMA1_NX1')
CREATE NONCLUSTERED INDEX [RPDMMA1_NX1] ON [dbo].[NDD_RPDMMA1_PEDI_MSTR]
(
	[PDM_MNDU] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPDMMA1_PEDI_MSTR]') AND name = N'RPDMMA1_NX2')
CREATE NONCLUSTERED INDEX [RPDMMA1_NX2] ON [dbo].[NDD_RPDMMA1_PEDI_MSTR]
(
	[PDM_MNUF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPDMMA1_PEDI_MSTR]') AND name = N'RPDMMA1_NX3')
CREATE NONCLUSTERED INDEX [RPDMMA1_NX3] ON [dbo].[NDD_RPDMMA1_PEDI_MSTR]
(
	[PDM_MXDU] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPDMMA1_PEDI_MSTR]') AND name = N'RPDMMA1_NX4')
CREATE NONCLUSTERED INDEX [RPDMMA1_NX4] ON [dbo].[NDD_RPDMMA1_PEDI_MSTR]
(
	[PDM_MXUF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPDMMA1_PEDI_MSTR]') AND name = N'RPDMMA1_NX5')
CREATE NONCLUSTERED INDEX [RPDMMA1_NX5] ON [dbo].[NDD_RPDMMA1_PEDI_MSTR]
(
	[PDM_NTEDU] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPDMMA1_PEDI_MSTR]') AND name = N'RPDMMA1_NX6')
CREATE NONCLUSTERED INDEX [RPDMMA1_NX6] ON [dbo].[NDD_RPDMMA1_PEDI_MSTR]
(
	[PDM_NTEUF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPEDIGC0_PEDI_GCNSEQNO_LINK]') AND name = N'RPEDIGC0_NX1')
CREATE NONCLUSTERED INDEX [RPEDIGC0_NX1] ON [dbo].[NDD_RPEDIGC0_PEDI_GCNSEQNO_LINK]
(
	[PEDI_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPEDIRM0_ROUTED_MED_LINK]') AND name = N'RPEDIRM0_NX1')
CREATE NONCLUSTERED INDEX [RPEDIRM0_NX1] ON [dbo].[NDD_RPEDIRM0_ROUTED_MED_LINK]
(
	[PEDI_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPEMGC0_GCNSEQNO_LINK]') AND name = N'RPEMGC0_NX1')
CREATE NONCLUSTERED INDEX [RPEMGC0_NX1] ON [dbo].[NDD_RPEMGC0_GCNSEQNO_LINK]
(
	[PEC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPEMMA5_MSTR]') AND name = N'RPEMMA5_NX1')
CREATE NONCLUSTERED INDEX [RPEMMA5_NX1] ON [dbo].[NDD_RPEMMA5_MSTR]
(
	[PEMONO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPEMMA5_MSTR]') AND name = N'RPEMMA5_NX2')
CREATE NONCLUSTERED INDEX [RPEMMA5_NX2] ON [dbo].[NDD_RPEMMA5_MSTR]
(
	[ASHPCDE3] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPEMMA5_MSTR]') AND name = N'RPEMMA5_NX3')
CREATE NONCLUSTERED INDEX [RPEMMA5_NX3] ON [dbo].[NDD_RPEMMA5_MSTR]
(
	[PEMONOS] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPEMOGC0_MONO_GCNSEQNO_LINK]') AND name = N'RPEMOGC0_NX1')
CREATE NONCLUSTERED INDEX [RPEMOGC0_NX1] ON [dbo].[NDD_RPEMOGC0_MONO_GCNSEQNO_LINK]
(
	[PEMONO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOECD1_DEFINITION]') AND name = N'RPOECD1_NX1')
CREATE NONCLUSTERED INDEX [RPOECD1_NX1] ON [dbo].[NDD_RPOECD1_DEFINITION]
(
	[POELANGCDE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOECD1_DEFINITION]') AND name = N'RPOECD1_NX2')
CREATE NONCLUSTERED INDEX [RPOECD1_NX2] ON [dbo].[NDD_RPOECD1_DEFINITION]
(
	[POEUNITTYP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOECD1_DEFINITION]') AND name = N'RPOECD1_NX3')
CREATE NONCLUSTERED INDEX [RPOECD1_NX3] ON [dbo].[NDD_RPOECD1_DEFINITION]
(
	[POECALCRTC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOECD1_DEFINITION]') AND name = N'RPOECD1_NX4')
CREATE NONCLUSTERED INDEX [RPOECD1_NX4] ON [dbo].[NDD_RPOECD1_DEFINITION]
(
	[POECOCDE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOECL1_CLIN_CONTEXT]') AND name = N'RPOECL1_NX1')
CREATE NONCLUSTERED INDEX [RPOECL1_NX1] ON [dbo].[NDD_RPOECL1_CLIN_CONTEXT]
(
	[POECLINTYP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOECL1_CLIN_CONTEXT]') AND name = N'RPOECL1_NX2')
CREATE NONCLUSTERED INDEX [RPOECL1_NX2] ON [dbo].[NDD_RPOECL1_CLIN_CONTEXT]
(
	[POECLINVAL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEGCS1_STANDARD_ORDER]') AND name = N'RPOEGCS1_NX1')
CREATE NONCLUSTERED INDEX [RPOEGCS1_NX1] ON [dbo].[NDD_RPOEGCS1_STANDARD_ORDER]
(
	[POEOSETID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEGCS1_STANDARD_ORDER]') AND name = N'RPOEGCS1_NX2')
CREATE NONCLUSTERED INDEX [RPOEGCS1_NX2] ON [dbo].[NDD_RPOEGCS1_STANDARD_ORDER]
(
	[POECLINID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEGSQ2_GCNSEQNO_MSTR]') AND name = N'RPOEGSQ1_NX1')
CREATE NONCLUSTERED INDEX [RPOEGSQ1_NX1] ON [dbo].[NDD_RPOEGSQ2_GCNSEQNO_MSTR]
(
	[POECLINID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEGSQ2_GCNSEQNO_MSTR]') AND name = N'RPOEGSQ1_NX2')
CREATE NONCLUSTERED INDEX [RPOEGSQ1_NX2] ON [dbo].[NDD_RPOEGSQ2_GCNSEQNO_MSTR]
(
	[POEOSETID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEGSQ2_GCNSEQNO_MSTR]') AND name = N'RPOEGSQ1_NX4')
CREATE NONCLUSTERED INDEX [RPOEGSQ1_NX4] ON [dbo].[NDD_RPOEGSQ2_GCNSEQNO_MSTR]
(
	[DXID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEGSQ2_GCNSEQNO_MSTR]') AND name = N'RPOEGSQ2_NX3')
CREATE NONCLUSTERED INDEX [RPOEGSQ2_NX3] ON [dbo].[NDD_RPOEGSQ2_GCNSEQNO_MSTR]
(
	[FDBDX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEOS1_ORDER_SET]') AND name = N'RPOEOS1_NX1')
CREATE NONCLUSTERED INDEX [RPOEOS1_NX1] ON [dbo].[NDD_RPOEOS1_ORDER_SET]
(
	[POEOSTRID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEOS1_ORDER_SET]') AND name = N'RPOEOS1_NX2')
CREATE NONCLUSTERED INDEX [RPOEOS1_NX2] ON [dbo].[NDD_RPOEOS1_ORDER_SET]
(
	[POEDOSETYP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEOSR1_ORDER_STRING]') AND name = N'RPOEOSR1_NX1')
CREATE NONCLUSTERED INDEX [RPOEOSR1_NX1] ON [dbo].[NDD_RPOEOSR1_ORDER_STRING]
(
	[POEROUTE_D] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEOSX1_TEXT_LINK]') AND name = N'RPOEOSX1_NX2')
CREATE NONCLUSTERED INDEX [RPOEOSX1_NX2] ON [dbo].[NDD_RPOEOSX1_TEXT_LINK]
(
	[POETEXTTYP] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEOSX1_TEXT_LINK]') AND name = N'RPOEOSX1_NX3')
CREATE NONCLUSTERED INDEX [RPOEOSX1_NX3] ON [dbo].[NDD_RPOEOSX1_TEXT_LINK]
(
	[POETXTSTRL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOEOSX1_TEXT_LINK]') AND name = N'RPOEOSX1_NX4')
CREATE NONCLUSTERED INDEX [RPOEOSX1_NX4] ON [dbo].[NDD_RPOEOSX1_TEXT_LINK]
(
	[POETEXTCDE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOETXT1_TEXT]') AND name = N'RPOETXT1_NX1')
CREATE NONCLUSTERED INDEX [RPOETXT1_NX1] ON [dbo].[NDD_RPOETXT1_TEXT]
(
	[POELANGCDE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPOETXT1_TEXT]') AND name = N'RPOETXT1_NX2')
CREATE NONCLUSTERED INDEX [RPOETXT1_NX2] ON [dbo].[NDD_RPOETXT1_TEXT]
(
	[POECOCDE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPREGGC0_PREG_GCNSEQNO_LINK]') AND name = N'RPREGGC0_NX1')
CREATE NONCLUSTERED INDEX [RPREGGC0_NX1] ON [dbo].[NDD_RPREGGC0_PREG_GCNSEQNO_LINK]
(
	[PREG_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RPREGRM0_ROUTED_MED_LINK]') AND name = N'RPREGRM0_NX1')
CREATE NONCLUSTERED INDEX [RPREGRM0_NX1] ON [dbo].[NDD_RPREGRM0_ROUTED_MED_LINK]
(
	[PREG_CODE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RSIDEGC0_GCNSEQNO_LINK]') AND name = N'RSIDEGC0')
CREATE NONCLUSTERED INDEX [RSIDEGC0] ON [dbo].[NDD_RSIDEGC0_GCNSEQNO_LINK]
(
	[SIDE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RSIDEMA3_MSTR]') AND name = N'RSIDEMA3_NX1')
CREATE NONCLUSTERED INDEX [RSIDEMA3_NX1] ON [dbo].[NDD_RSIDEMA3_MSTR]
(
	[FDBDX] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RSIDEMA3_MSTR]') AND name = N'RSIDEMA3_NX2')
CREATE NONCLUSTERED INDEX [RSIDEMA3_NX2] ON [dbo].[NDD_RSIDEMA3_MSTR]
(
	[DXID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RSIDERM0_ROUTED_MED_LINK]') AND name = N'RSIDERM0_NX1')
CREATE NONCLUSTERED INDEX [RSIDERM0_NX1] ON [dbo].[NDD_RSIDERM0_ROUTED_MED_LINK]
(
	[SIDE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RXRFAHX0_AGCSP_HICSEQN]') AND name = N'RXRFAHX0_NX1')
CREATE NONCLUSTERED INDEX [RXRFAHX0_NX1] ON [dbo].[NDD_RXRFAHX0_AGCSP_HICSEQN]
(
	[HIC_SEQN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RXRFAHX0_AGCSP_HICSEQN]') AND name = N'RXRFAHX0_NX2')
CREATE NONCLUSTERED INDEX [RXRFAHX0_NX2] ON [dbo].[NDD_RXRFAHX0_AGCSP_HICSEQN]
(
	[HIC] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[NDD_RXRFHCX0_HICSEQN_CHEMNO]') AND name = N'RXRFHCX0_UK1')
ALTER TABLE [dbo].[NDD_RXRFHCX0_HICSEQN_CHEMNO] ADD  CONSTRAINT [RXRFHCX0_UK1] UNIQUE NONCLUSTERED 
(
	[HIC_SEQN] ASC,
	[CHEMNO] ASC,
	[CHEMSE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

