IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateDatabaseCLR]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [dbo].[CreateDatabaseCLR]
END
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROC [dbo].[CreateDatabaseCLR] AS
BEGIN
	EXEC sp_executesql N'
		BEGIN
			exec sp_changedbowner ''sa''

			EXEC sp_configure @configname = ''clr enabled'', @configvalue = 1
			RECONFIGURE WITH OVERRIDE
			
			DECLARE @dbname varchar(255) = db_name()
			EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY ON'')

			IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''StoredProcedures'')
			BEGIN
				If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
					exec UninstallDatabaseCLR
				
				PRINT ''Dropping Assembly [StoredProcedures]''
				DROP ASSEMBLY [StoredProcedures];
			END
			
			IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
			BEGIN
				If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
					exec UninstallDatabaseCLR
				
				PRINT ''Dropping Assembly [PRMDatabaseCLR]''
				DROP ASSEMBLY [PRMDatabaseCLR];
			END
		END
		'
	EXEC sp_executesql N'
			USE [master];  -- this will automatically reset to the PRM DB
			DECLARE @dbname varchar(255) = db_name()
		
			IF NOT EXISTS (select name from sys.certificates where name = ''PRMCLRCodeCert2018'')
			BEGIN
				IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
				BEGIN
					If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
						exec UninstallDatabaseCLR
					DROP ASSEMBLY [PRMDatabaseCLR];
				END
				EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY ON'')
			
				PRINT ''Create temporary [PRMDatabaseCLR] in master''
				-- the string DLLBYTES below will be replaced by the DatabaseCLR post build step
				CREATE ASSEMBLY [PRMDatabaseCLR]
				AUTHORIZATION [dbo]
				FROM 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
				WITH PERMISSION_SET = SAFE;

				PRINT ''Create certificate PRMCLRCodeCert2018 from [PRMDatabaseCLR]''
				CREATE CERTIFICATE PRMCLRCodeCert2018 FROM 	ASSEMBLY [PRMDatabaseCLR]
				-- CREATE CERTIFICATE PRMCLRCodeCert2018 FROM EXECUTABLE FILE = ''\Installation\DBScript\Assemblies\PRMDatabaseCLR.dll''   
			END
			
			IF NOT EXISTS (SELECT name FROM sys.server_principals WHERE name = ''PRMCLRCodeLogin2018'')
			BEGIN
				PRINT ''Create Login PRMCLRCodeLogin2018 from PRMCLRCodeCert2018''
				CREATE LOGIN PRMCLRCodeLogin2018 FROM CERTIFICATE PRMCLRCodeCert2018
				GRANT UNSAFE ASSEMBLY TO PRMCLRCodeLogin2018
			END
			
			IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
			BEGIN
				If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
					exec UninstallDatabaseCLR
				PRINT ''Drop temporary Assembly [PRMDatabaseCLR] from master''
				DROP ASSEMBLY [PRMDatabaseCLR];
			END
			IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[CreateDatabaseCLR]'') AND type in (N''P'', N''PC''))
			BEGIN
				DROP PROCEDURE [dbo].[CreateDatabaseCLR]
			END
			EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY OFF'')
		'

	EXEC sp_executesql N'
			-- the string DLLBYTES below will be replaced by the DatabaseCLR post build step
			CREATE ASSEMBLY [PRMDatabaseCLR]
			AUTHORIZATION [dbo]
			FROM 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
			WITH PERMISSION_SET = UNSAFE;
		'
	
	EXEC sp_executesql N'
			CREATE PROCEDURE [InstallDatabaseCLR] AS EXTERNAL NAME [PRMDatabaseCLR].[Registration].[InstallDatabaseCLR]
		'
	EXEC sp_executesql N'
			EXEC [InstallDatabaseCLR];
		'
	
	EXEC sp_executesql N'
			DECLARE @dbname varchar(255) = db_name()
			EXECUTE(''ALTER DATABASE ['' + @dbname  + ''] SET TRUSTWORTHY OFF'')
		'
	/*
		-- 2012 code certificate  in the PRM DB run this to verify the certificate and login exist Login should be in both, cert only in Master
		select name from sys.certificates where name = 'PRMCLRCodeCert'
		SELECT name FROM sys.server_principals WHERE name = 'PRMCLRCodeLogin'
		select name from master.sys.certificates where name = 'PRMCLRCodeCert'
		SELECT name FROM master.sys.server_principals WHERE name = 'PRMCLRCodeLogin'
		-- 2015 code certificate in the PRM DB run this to verify the certificate and login exist Login should be in both, cert only in Master
		select name from sys.certificates where name = 'PRMCLRCodeCert2015'
		SELECT name FROM sys.server_principals WHERE name = 'PRMCLRCodeLogin2015'
		select name from master.sys.certificates where name = 'PRMCLRCodeCert2015'
		SELECT name FROM master.sys.server_principals WHERE name = 'PRMCLRCodeLogin2015'
		-- 2018 code certificate in the PRM DB run this to verify the certificate and login exist Login should be in both, cert only in Master
		select name from sys.certificates where name = 'PRMCLRCodeCert2018'
		SELECT name FROM sys.server_principals WHERE name = 'PRMCLRCodeLogin2018'
		select name from master.sys.certificates where name = 'PRMCLRCodeCert2018'
		SELECT name FROM master.sys.server_principals WHERE name = 'PRMCLRCodeLogin2018'
		-- This will remove the cert and login so we can create new ones
		USE master; 
		DROP LOGIN PRMCLRCodeLogin
		DROP CERTIFICATE PRMCLRCodeCert 
		DROP LOGIN PRMCLRCodeLogin2018
		DROP CERTIFICATE PRMCLRCodeCert2018

		once the CLR has been installed, the follow should be run to verify
		that clr strict security is ON and trustworthy is OFF
		EXEC sp_configure 'show advanced options', 1
		RECONFIGURE;
		EXEC sp_configure 'clr strict security'
		select name, is_trustworthy_on from sys.databases

		-- test with this
		exec HelloWorld 'howdy'
	*/
END
GO

EXEC sp_executesql N'
		EXEC [CreateDatabaseCLR];
	'
GO
