IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateDatabaseCLR]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [dbo].[CreateDatabaseCLR]
END
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROC [dbo].[CreateDatabaseCLR] AS
BEGIN
	EXEC sp_executesql N'
		BEGIN
			exec sp_changedbowner ''sa''

			EXEC sp_configure @configname = ''clr enabled'', @configvalue = 1
			RECONFIGURE WITH OVERRIDE

			DECLARE @dbname varchar(255)
			select @dbname = db_name()
			EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY ON'')

			IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''StoredProcedures'')
			BEGIN
				If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
					exec UninstallDatabaseCLR
				
				PRINT ''Dropping Assembly [StoredProcedures]''
				DROP ASSEMBLY [StoredProcedures];
			END
			
			IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
			BEGIN
				If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
					exec UninstallDatabaseCLR
				
				PRINT ''Dropping Assembly [PRMDatabaseCLR]''
				DROP ASSEMBLY [PRMDatabaseCLR];
			END
		END
		'
	EXEC sp_executesql N'
			-- the string DLLBYTES below will be replaced by the DatabaseCLR post build step
			CREATE ASSEMBLY [PRMDatabaseCLR]
			AUTHORIZATION [dbo]
			FROM %DLLBYTES%
			WITH PERMISSION_SET = UNSAFE;
		'
	EXEC sp_executesql N'
			CREATE PROCEDURE [InstallDatabaseCLR] AS EXTERNAL NAME [PRMDatabaseCLR].[Registration].[InstallDatabaseCLR]
		'
	EXEC sp_executesql N'
			EXEC [InstallDatabaseCLR]
		'
END
GO

EXEC sp_executesql N'
		EXEC [CreateDatabaseCLR]
	'
GO