-- Backup the ListReportRdl table so that we do not lose any reports
-- requested by Support
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_ListReportRdl]') AND type in (N'U'))
	DROP TABLE [dbo].[cus_ListReportRdl]

SELECT * INTO cus_ListReportRdl FROM ListReportRdl
GO

-- clear out the Error Reports from the last version.
truncate table ErrorReport
GO
-- clear out the JobHistory
truncate table JobHistory
GO

-- reset the Weekly update rows to get the latest download.
delete from ListProductParameter where ParameterName like '%Updates'
delete from ListProductParameter where ParameterName = 'Update'
GO

---  Keep the items above regardless of the version of the db.

/*
	Bug 61425:Migration Error
	Cleans out cache tables for Financial Center Close during migration
	Good for all 2016 and 2018 migrations
	2017-12-19  BMR  Created
	20171219_Bug61425_ClearFinancialCloseTablesBeforeMigration.sql
*/
IF EXISTS(SELECT * FROM sys.tables WHERE Name = 'AR_ViewFinancialCenterClosingSummary_ObjectLinks')
	DELETE FROM AR_ViewFinancialCenterClosingSummary_ObjectLinks;
IF EXISTS(SELECT * FROM sys.tables WHERE Name = 'AR_ViewFinancialCenterClosingSummary_DepositsWithBalance')
	DELETE FROM AR_ViewFinancialCenterClosingSummary_DepositsWithBalance;
IF EXISTS(SELECT * FROM sys.tables WHERE Name = 'AR_ViewFinancialCenterClosingSummary_BatchInfo')
	DELETE FROM AR_ViewFinancialCenterClosingSummary_BatchInfo;
GO
