/*	#10781 ALT Accounts - Migration  20180821_Task_10781_MigrateAccountInsuranceParent_To_RelAlternateAccountPeriod.sql
	Migrate AccountInsurance based Alternate Account To AccountPeriod based
	Task 10781  -  Create Script To Migrate Existing Account Insurance Parent To New Alternate Account Relationship
	BMR   20180821  Created
*/

IF EXISTS(SELECT * FROM RelAlternateAccountPeriod) -- already done
	RETURN;

SELECT MASTER_AI.AccountPeriodUid AS MasterAccountPeriodUid, 
		ALTERNATE_AI.AccountPeriodUid AS AlternateAccountPeriodUid,
		ALTERNATE_PIP.InsurancePlanUid AS TargetInsurancePlanUid,
		'Alternate Migrated - From: ?' + MASTER_VPP.PayerPlanName + '? Target: ' + ALTERNATE_VPP.PayerPlanName + '' AS Note
	INTO #Temp_AlternateAccountRecordsToMigrate
	FROM AccountInsurance ALTERNATE_AI
		INNER JOIN AccountInsurance MASTER_AI ON ALTERNATE_AI.ParentAccountInsuranceUid = MASTER_AI.AccountInsuranceUid
		INNER JOIN PersonInsurancePlan ALTERNATE_PIP ON ALTERNATE_AI.PersonInsurancePlanUid = ALTERNATE_PIP.PersonInsurancePlanUid
		INNER JOIN ViewPayerPlan ALTERNATE_VPP ON ALTERNATE_PIP.InsurancePlanUid =  ALTERNATE_VPP.InsurancePlanUid
		INNER JOIN PersonInsurancePlan MASTER_PIP ON MASTER_AI.PersonInsurancePlanUid = MASTER_PIP.PersonInsurancePlanUid
		INNER JOIN ViewPayerPlan MASTER_VPP ON MASTER_PIP.InsurancePlanUid =  MASTER_VPP.InsurancePlanUid
	WHERE NOT ALTERNATE_AI.ParentAccountInsuranceUid IS NULL;

--SELECT * 
--	FROM #Temp_AlternateAccountRecordsToMigrate;

INSERT INTO RelAlternateAccountPeriod (MasterAccountPeriodUid, AlternateAccountPeriodUid, TargetInsurancePlanUid, Note)
	SELECT MasterAccountPeriodUid, AlternateAccountPeriodUid, TargetInsurancePlanUid, Note 
		FROM #Temp_AlternateAccountRecordsToMigrate;

-- leaving ParentAccountInsuranceUid records in place for reference, but code no longer uses

DROP TABLE #Temp_AlternateAccountRecordsToMigrate;

-- SELECT * FROM RelAlternateAccountPeriod;
GO

-- #10974 Change/Cancel MigrationScript-TransmissionConfiguration-TestMode.sql
-- CMR: Make sure the TestMode in TransmissionConfiguration matches the IntegrationPartion TestMode for surescripts related entries
-- They should always match but rows added in later versions need to be made consistent.  (ChangeRx and CancelRx added)
UPDATE tc
SET
   TestMode         = lip.TestMode,
   LastModifiedDate = GETUTCDATE()
FROM TransmissionConfiguration tc
INNER JOIN ListIntegrationPartner lip ON lip.IntegrationPartnerUid = tc.IntegrationPartnerUid
WHERE tc.TestMode <> lip.TestMode
  AND lip.Inactive = 0
  AND tc.IntegrationPartnerUid IN('118422AA-C165-4A2E-8389-E5B7E89636EA', '4D1BC44B-31F5-4B41-8F50-A95047266FFC')

--  
-- #10960 #12316   duplicate pharmacies  10960_CleanupDuplicatedPharmacy_qry.sql
DECLARE @PharmacyClearinghouseUid [uniqueidentifier] = '118422AA-C165-4A2E-8389-E5B7E89636EA',	-- Surescripts
	@MasterPharmacyUid [uniqueidentifier],
	@PharmacyUid [uniqueidentifier],
	@debug [bit] = 0

DECLARE @MasterPharmacy_TBL TABLE
(
	[MasterPharmacyUid] [uniqueidentifier] primary key
)

DECLARE @Pharmacy_TBL TABLE
(
	[PharmacyUid] [uniqueidentifier] primary key
)

INSERT @MasterPharmacy_TBL
SELECT mp.[MasterPharmacyUid]
FROM [ListPharmacy] AS lp with(nolock)
	INNER JOIN [MasterPharmacy] AS mp  with(nolock) ON lp.[MasterPharmacyUid] = mp.[MasterPharmacyUid]
WHERE mp.[PharmacyClearinghouseUid] = @PharmacyClearinghouseUid
GROUP BY mp.[MasterPharmacyUid]
HAVING COUNT(*) > 1

SELECT 'Duplicated List Pharmacy'
SELECT lp.*
FROM @MasterPharmacy_TBL AS vmp
	INNER JOIN [ListPharmacy] AS lp with(nolock) ON  vmp.[MasterPharmacyUid] = lp.[MasterPharmacyUid]

DECLARE DuplicatedPharmacy_CSR CURSOR FAST_FORWARD FOR
SELECT *
FROM @MasterPharmacy_TBL

OPEN DuplicatedPharmacy_CSR
FETCH NEXT FROM DuplicatedPharmacy_CSR INTO @MasterPharmacyUid
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE @Pharmacy_TBL
	SELECT TOP 1 @PharmacyUid = [PharmacyUid]
	FROM [ListPharmacy] with(nolock)
	WHERE [MasterPharmacyUid] = @MasterPharmacyUid
	ORDER BY [LastModifiedDate] DESC

	INSERT @Pharmacy_TBL
	SELECT [PharmacyUid]
	FROM [ListPharmacy] with(nolock)
	WHERE [MasterPharmacyUid] = @MasterPharmacyUid
		AND [PharmacyUid] <> @PharmacyUid

	IF EXISTS (
		SELECT TOP 1 *
		FROM @Pharmacy_TBL
	)
	BEGIN
		IF @debug <> 0
		BEGIN
			SELECT 'Before clean up'
			SELECT 'Duplicated Pharmacy in PatientPharmacy'
			SELECT pp.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [PatientPharmacy] AS pp with(nolock) ON vp.[PharmacyUid] = pp.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'Duplicated Pharmacy in eRxOutbound'
			SELECT ob.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [eRxOutbound] AS ob with(nolock) ON vp.[PharmacyUid] = ob.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'Duplicated Pharmacy in eRxPRVBRDOutbound'
			SELECT ob.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [eRxPRVBRDOutbound] AS ob with(nolock) ON vp.[PharmacyUid] = ob.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'Duplicated Pharmacy in MedicationSIG'
			SELECT ms.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [MedicationSIG] AS ms with(nolock) ON vp.[PharmacyUid] = ms.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'Duplicated Pharmacy in MessageRxRefill'
			SELECT mr.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [MessageRxRefill] AS mr with(nolock) ON vp.[PharmacyUid] = mr.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'Duplicated Pharmacy in PatientPharmacy'
			SELECT pp.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [PatientPharmacy] AS pp with(nolock) ON vp.[PharmacyUid] = pp.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'Duplicated Pharmacy in ListPharmacy'
			SELECT *
			FROM [ListPharmacy] with(nolock)
			WHERE [MasterPharmacyUid] = @MasterPharmacyUid
		END

		PRINT 'Clean up'
		BEGIN TRAN
		BEGIN TRY
			PRINT 'Change Pharmacy in eRxOutbound to ' + CAST(@PharmacyUid AS [varchar] (128))
			UPDATE [eRxOutbound]
				SET [PharmacyUid] = @PharmacyUid
			FROM @Pharmacy_TBL AS vp
				INNER JOIN [eRxOutbound] AS ob with(nolock) ON vp.[PharmacyUid] = ob.[PharmacyUid]

			PRINT 'Change Pharmacy in eRxPRVBRDOutbound to ' + CAST(@PharmacyUid AS [varchar] (128))
			UPDATE [eRxPRVBRDOutbound]
				SET [PharmacyUid] = @PharmacyUid
			FROM @Pharmacy_TBL AS vp
				INNER JOIN [eRxPRVBRDOutbound] AS ob with(nolock) ON vp.[PharmacyUid] = ob.[PharmacyUid]

			PRINT 'Change Pharmacy in MedicationSIG to ' + CAST(@PharmacyUid AS [varchar] (128))
			UPDATE [MedicationSIG]
				SET [PharmacyUid] = @PharmacyUid
			FROM @Pharmacy_TBL AS vp
				INNER JOIN [MedicationSIG] AS ms with(nolock) ON vp.[PharmacyUid] = ms.[PharmacyUid]

			PRINT 'Change Pharmacy in MessageRxRefill to ' + CAST(@PharmacyUid AS [varchar] (128))
			UPDATE [MessageRxRefill]
				SET [PharmacyUid] = @PharmacyUid
			FROM @Pharmacy_TBL AS vp
				INNER JOIN [MessageRxRefill] AS mr with(nolock) ON vp.[PharmacyUid] = mr.[PharmacyUid]

			PRINT 'Change Pharmacy in PatientPharmacy to ' + CAST(@PharmacyUid AS [varchar] (128))
			UPDATE [PatientPharmacy]
				SET [PharmacyUid] = @PharmacyUid
			FROM @Pharmacy_TBL AS vp
				INNER JOIN [PatientPharmacy] AS pp with(nolock) ON vp.[PharmacyUid] = pp.[PharmacyUid]

			PRINT 'Remove duplicated ListPharmacy'
			DELETE [ListPharmacy]
			FROM @Pharmacy_TBL AS vp
				INNER JOIN [ListPharmacy] AS p with(nolock) ON vp.[PharmacyUid] = p.[PharmacyUid]

			COMMIT TRAN
		END TRY
		BEGIN CATCH
			ROLLBACK TRAN
		END CATCH

		IF @debug <> 0
		BEGIN
			PRINT 'After clean up'
			SELECT 'PatientPharmacy'
			SELECT pp.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [PatientPharmacy] AS pp with(nolock) ON vp.[PharmacyUid] = pp.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'eRxOutbound'
			SELECT ob.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [eRxOutbound] AS ob with(nolock) ON vp.[PharmacyUid] = ob.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'eRxPRVBRDOutbound'
			SELECT ob.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [eRxPRVBRDOutbound] AS ob with(nolock) ON vp.[PharmacyUid] = ob.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'MedicationSIG'
			SELECT ms.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [MedicationSIG] AS ms with(nolock) ON vp.[PharmacyUid] = ms.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'MessageRxRefill'
			SELECT mr.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [MessageRxRefill] AS mr with(nolock) ON vp.[PharmacyUid] = mr.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'Duplicated Pharmacy in PatientPharmacy'
			SELECT pp.*
			FROM [ListPharmacy] AS vp with(nolock)
				INNER JOIN [PatientPharmacy] AS pp with(nolock) ON vp.[PharmacyUid] = pp.[PharmacyUid]
			WHERE vp.[MasterPharmacyUid] = @MasterPharmacyUid

			SELECT 'ListPharmacy'
			SELECT *
			FROM [ListPharmacy] with(nolock)
			WHERE [MasterPharmacyUid] = @MasterPharmacyUid
		END
	END
	FETCH NEXT FROM DuplicatedPharmacy_CSR INTO @MasterPharmacyUid
END
CLOSE DuplicatedPharmacy_CSR
DEALLOCATE DuplicatedPharmacy_CSR
GO
DECLARE @PharmacyClearinghouseUid [uniqueidentifier] = '118422AA-C165-4A2E-8389-E5B7E89636EA',	-- Surescripts
	@PatientUid [uniqueidentifier],
	@PharmacyUid [uniqueidentifier],
	@PatientPharmacyUid [uniqueidentifier],
	@debug [bit] = 0

DECLARE @PatientPharmacy_TBL TABLE
(
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PharmacyUid] [uniqueidentifier] NOT NULL,
	primary key([PatientUid], [PharmacyUid])
)

DECLARE @PatientPharmacyToDelete_TBL TABLE
(
	[PatientPharmacyUid] [uniqueidentifier] primary key
)

INSERT @PatientPharmacy_TBL
SELECT pp.[PatientUid], pp.[PharmacyUid]
FROM [PatientPharmacy] AS pp  with(nolock)
	INNER JOIN [ListPharmacy] AS lp with(nolock) ON pp.[PharmacyUid] = lp.[PharmacyUid]
	INNER JOIN [MasterPharmacy] AS mp  with(nolock) ON lp.[MasterPharmacyUid] = mp.[MasterPharmacyUid]
WHERE mp.[PharmacyClearinghouseUid] = @PharmacyClearinghouseUid
GROUP BY pp.[PatientUid], pp.[PharmacyUid]
HAVING COUNT(*) > 1

SELECT 'Duplicated Patient Pharmacy'
SELECT pp.*
FROM @PatientPharmacy_TBL AS vpp
	INNER JOIN [PatientPharmacy] AS pp with(nolock) ON vpp.[PatientUid] = pp.[PatientUid]
		AND vpp.[PharmacyUid] = pp.[PharmacyUid]
ORDER BY pp.[PatientUid], pp.[PharmacyUid]

DECLARE DuplicatedPatientPharmacy_CSR CURSOR FAST_FORWARD FOR
SELECT *
FROM @PatientPharmacy_TBL

OPEN DuplicatedPatientPharmacy_CSR
FETCH NEXT FROM DuplicatedPatientPharmacy_CSR INTO 	@PatientUid, @PharmacyUid

WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE @PatientPharmacyToDelete_TBL
	SELECT TOP 1 @PatientPharmacyUid = [PatientPharmacyUid]
	FROM [PatientPharmacy] with(nolock)
	WHERE [PatientUid] = @PatientUid
		AND [PharmacyUid] = @PharmacyUid
	ORDER BY [LastModifiedDate] DESC

	INSERT @PatientPharmacyToDelete_TBL
	SELECT [PatientPharmacyUid]
	FROM [PatientPharmacy] with(nolock)
	WHERE [PatientUid] = @PatientUid
		AND [PharmacyUid] = @PharmacyUid
		AND [PatientPharmacyUid] <> @PatientPharmacyUid

	IF EXISTS (
		SELECT TOP 1 *
		FROM @PatientPharmacyToDelete_TBL
	)
	BEGIN
		IF @debug <> 0
		BEGIN
			SELECT 'Before clean up'
			SELECT 'Duplicated Pharmacy in PatientPharmacy'
			SELECT *
			FROM [PatientPharmacy] with(nolock)
			WHERE [PatientUid] = @PatientUid
				AND [PharmacyUid] = @PharmacyUid
		END

		PRINT 'Clean up'
		BEGIN TRAN
		BEGIN TRY
			PRINT 'Remove duplicated PatientPharmacy'
			DELETE [PatientPharmacy]
			FROM @PatientPharmacyToDelete_TBL AS vpp
				INNER JOIN [PatientPharmacy] AS pp with(nolock) ON vpp.[PatientPharmacyUid] = pp.[PatientPharmacyUid]
			COMMIT TRAN
		END TRY
		BEGIN CATCH
			ROLLBACK TRAN
		END CATCH

		IF @debug <> 0
		BEGIN
			PRINT 'After clean up'
			SELECT 'Duplicated Pharmacy in PatientPharmacy'
			SELECT *
			FROM [PatientPharmacy] with(nolock)
			WHERE [PatientUid] = @PatientUid
				AND [PharmacyUid] = @PharmacyUid
		END
	END
	FETCH NEXT FROM DuplicatedPatientPharmacy_CSR INTO 	@PatientUid, @PharmacyUid
END
CLOSE DuplicatedPatientPharmacy_CSR
DEALLOCATE DuplicatedPatientPharmacy_CSR
GO


-- #11796 custom DX codes  PostMigration_CustomDiagnosis.sql
IF EXISTS(SELECT * FROM sys.Columns where object_id = OBJECT_ID(N'[ListDiagnosis]') and name = 'LexicalCode')
Begin

IF NOT EXISTS(SELECT * FROM SeedTable where SeedName = 'ListDiagnosisLexicalCode')
BEGIN

INSERT into SeedTable
values('908FAF24-5F42-404D-AD7D-796EDD305599', 'ListDiagnosisLexicalCode',0,GETUTCDATE())

END

DELETE FROM ListDiagnosis
WHERE MasterDiagnosisUid IS NOT NULL

IF NOT EXISTS(SELECT * FROM LISTDIAGNOSIS WHERE LexicalCode IS NOT NULL)
BEGIN

UPDATE x
SET x.LexicalCode = x.New_LexicalCode*-1
FROM (
      SELECT LexicalCode, ROW_NUMBER() OVER (ORDER BY [ShortDescription]) AS New_LexicalCode
      FROM ListDiagnosis
      ) x

DECLARE @SeedNumber int;

SELECT @SeedNumber = Count(*) from LISTDIAGNOSIS	
UPDATE SeedTable
SET SeedValue = @SeedNumber
WHERE SeedName = 'ListDiagnosisLexicalCode'

END
END

-- #11796 custom DX codes  PostMigration_UpdateListFindTable.sql
IF EXISTS(SELECT * FROM LISTFINDTABLE WHERE FINDTABLEUID = '3B12DF01-5DF4-44A2-A16B-BA0BC5DD459A')
BEGIN
UPDATE LISTFINDTABLE
SET NAME = 'Custom Diagnosis', ShowInListEditor = 1
WHERE FINDTABLEUID = '3B12DF01-5DF4-44A2-A16B-BA0BC5DD459A'

END
GO

-- #11602 computed columns ListPharmacy
--post upgrade script to populate computed columns of ListPharmacy
update lp set lp.Computed_Address1_Address1 = lp.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)'),
	lp.Computed_Address1_Address2 = lp.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)'),
	lp.Computed_Address1_City = lp.[Address].value('(/Address/City)[1]', 'VARCHAR(35)'),
	lp.Computed_Address1_State = lp.[Address].value('(/Address/State)[1]', 'VARCHAR(3)'),
	lp.Computed_Address1_Zip = lp.[Address].value('(/Address/Zip)[1]', 'VARCHAR(10)'),
	lp.Computed_Address1_Country = lp.[Address].value('(/Address/Country)[1]', 'VARCHAR(50)'),
	lp.[Computed_Address1_StreetAddress] = COALESCE(lp.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)'),'') + COALESCE(lp.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)'),''),
	lp.Computed_Phone1_PhoneNumber = lp.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(80)'),
	lp.Computed_Phone1_PhoneType = lp.Phone1.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)'),
	lp.Computed_Phone1_Scrubbed = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(lp.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(80)'), '-', ''), ' ', ''), '(', ''), ')', ''), 'ext', ''), 'x', ''), 
	lp.Computed_Phone2_PhoneNumber = lp.Phone2.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(80)'),
	lp.Computed_Phone2_PhoneType = lp.Phone2.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)'),
	lp.Computed_Phone2_Scrubbed = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(lp.Phone2.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(80)'), '-', ''), ' ', ''), '(', ''), ')', ''), 'ext', ''), 'x', ''), 
	lp.Computed_Phone3_PhoneNumber = lp.Phone3.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(80)'),
	lp.Computed_Phone3_PhoneType = lp.Phone3.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)'),
	lp.Computed_Phone3_Scrubbed = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(lp.Phone3.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(80)'), '-', ''), ' ', ''), '(', ''), ')', ''), 'ext', ''), 'x', '')
from ListPharmacy lp

-- #8022 BMI/BP Note Processors  bpnoteprocessorconfig.sql
DECLARE @BPConfiguration VARCHAR(MAX)
SET @BPConfiguration = '<BloodPressureProcessorConfiguration xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
  <EnableCpt>{0}</EnableCpt>
  <EnableIcd>{1}</EnableIcd>
  <IsExclude>{2}</IsExclude>
  <InsurancePlans>{3}</InsurancePlans>
  <RequiredTabs>SP</RequiredTabs>
  <ListenerItems>
    <BloodPressureListener>
      <CptCode>3074F</CptCode>
      <DefaultDescription>SYST BP LT 130 MM HG</DefaultDescription>
      <BloodPressureType>Systolic</BloodPressureType>
      <RangeStart>0</RangeStart>
      <RangeEnd>129.9</RangeEnd>
      <AgeStart>18</AgeStart>
      <AgeEnd>85</AgeEnd>
      <MedicareType>false</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
    <BloodPressureListener>
      <CptCode>3075F</CptCode>
      <DefaultDescription>SYST BP GE 130 - 139MM HG</DefaultDescription>
      <BloodPressureType>Systolic</BloodPressureType>
      <RangeStart>130</RangeStart>
      <RangeEnd>139.9</RangeEnd>
      <AgeStart>18</AgeStart>
      <AgeEnd>85</AgeEnd>
      <MedicareType>false</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
    <BloodPressureListener>
      <CptCode>3077F</CptCode>
      <DefaultDescription>SYST BP &gt;/= 140 MM HG</DefaultDescription>
      <BloodPressureType>Systolic</BloodPressureType>
      <RangeStart>140</RangeStart>
      <RangeEnd>999</RangeEnd>
      <AgeStart>18</AgeStart>
      <AgeEnd>85</AgeEnd>
      <MedicareType>false</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
    <BloodPressureListener>
      <CptCode>3078F</CptCode>
      <DefaultDescription>DIAST BP &lt;80 MM HG</DefaultDescription>
      <BloodPressureType>Diastolic</BloodPressureType>
      <RangeStart>0</RangeStart>
      <RangeEnd>79.9</RangeEnd>
      <AgeStart>18</AgeStart>
      <AgeEnd>85</AgeEnd>
      <MedicareType>false</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
    <BloodPressureListener>
      <CptCode>3079F</CptCode>
      <DefaultDescription>DIAST BP 80-89 MM HG</DefaultDescription>
      <BloodPressureType>Diastolic</BloodPressureType>
      <RangeStart>80</RangeStart>
      <RangeEnd>89.9</RangeEnd>
      <AgeStart>18</AgeStart>
      <AgeEnd>85</AgeEnd>
      <MedicareType>false</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
    <BloodPressureListener>
      <CptCode>3080F</CptCode>
      <DefaultDescription>DIAST BP &gt;/= 90 MM HG</DefaultDescription>
      <BloodPressureType>Diastolic</BloodPressureType>
      <RangeStart>90</RangeStart>
      <RangeEnd>999</RangeEnd>
      <AgeStart>18</AgeStart>
      <AgeEnd>85</AgeEnd>
      <MedicareType>false</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
    <BloodPressureListener>
      <CptCode>G8752</CptCode>
      <DefaultDescription>Most recent systolic blood pressure &lt; 140 mmHg</DefaultDescription>
      <BloodPressureType>Systolic</BloodPressureType>
      <RangeStart>0</RangeStart>
      <RangeEnd>139.9</RangeEnd>
      <AgeStart>0</AgeStart>
      <AgeEnd>999</AgeEnd>
      <MedicareType>true</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
    <BloodPressureListener>
      <CptCode>G8753</CptCode>
      <DefaultDescription>Most recent systolic blood pressure &gt; 140 mmHg</DefaultDescription>
      <BloodPressureType>Systolic</BloodPressureType>
      <RangeStart>140</RangeStart>
      <RangeEnd>999</RangeEnd>
      <AgeStart>0</AgeStart>
      <AgeEnd>999</AgeEnd>
      <MedicareType>true</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
    <BloodPressureListener>
      <CptCode>G8754</CptCode>
      <DefaultDescription>Most recent diastolic blood pressure &lt; 90 mmHg</DefaultDescription>
      <BloodPressureType>Diastolic</BloodPressureType>
      <RangeStart>0</RangeStart>
      <RangeEnd>89.9</RangeEnd>
      <AgeStart>0</AgeStart>
      <AgeEnd>999</AgeEnd>
      <MedicareType>true</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
    <BloodPressureListener>
      <CptCode>G8755</CptCode>
      <DefaultDescription>Most recent diastolic blood pressure &gt; 90 mmHg</DefaultDescription>
      <BloodPressureType>Diastolic</BloodPressureType>
      <RangeStart>90</RangeStart>
      <RangeEnd>999</RangeEnd>
      <AgeStart>0</AgeStart>
      <AgeEnd>999</AgeEnd>
      <MedicareType>true</MedicareType>
      <Uid>00000000-0000-0000-0000-000000000000</Uid>
    </BloodPressureListener>
  </ListenerItems>
</BloodPressureProcessorConfiguration>'

IF EXISTS(SELECT 1 FROM ListAddIn WHERE AddInUid = 'A6425135-9530-4078-A4F3-EECC68358B1E')
BEGIN
	DECLARE @Inactive BIT
	SELECT @Inactive = Inactive FROM ListAddIn WHERE AddInUid = 'A6425135-9530-4078-A4F3-EECC68358B1E'

	UPDATE ListAddIn SET Inactive = 1 WHERE AddInUid = 'A6425135-9530-4078-A4F3-EECC68358B1E'

	DECLARE @BMIAssignCPT VARCHAR(50)
	SELECT @BMIAssignCPT = CONVERT(XML, ConfigurationData).value('(./Control[@Name="checkboxAssignCPT"]/@Value)[1]', 'varchar(max)') FROM ListAddIn WHERE AddInUid = 'A6425135-9530-4078-A4F3-EECC68358B1E'
	IF LOWER(@BMIAssignCPT) = 'true'
		SET @BPConfiguration = REPLACE(@BPConfiguration, '{0}', '1')
	ELSE
		SET @BPConfiguration = REPLACE(@BPConfiguration, '{0}', '0')

	DECLARE @BMIAssignICD VARCHAR(50)
	SELECT @BMIAssignICD = CONVERT(XML, ConfigurationData).value('(./Control[@Name="checkboxAssignICD"]/@Value)[1]', 'varchar(max)') FROM ListAddIn WHERE AddInUid = 'A6425135-9530-4078-A4F3-EECC68358B1E'
	IF LOWER(@BMIAssignICD) = 'true'
		SET @BPConfiguration = REPLACE(@BPConfiguration, '{1}', '1')
	ELSE
		SET @BPConfiguration = REPLACE(@BPConfiguration, '{1}', '0')

	DECLARE @BMIInclude VARCHAR(50)
	SELECT @BMIInclude = CONVERT(XML, ConfigurationData).value('(./Control[@Name="prmRadioButtonInclude"]/@Value)[1]', 'varchar(max)') FROM ListAddIn WHERE AddInUid = 'A6425135-9530-4078-A4F3-EECC68358B1E'
	IF LOWER(@BMIInclude) = 'true'
		SET @BPConfiguration = REPLACE(@BPConfiguration, '{2}', '0')
	ELSE
		SET @BPConfiguration = REPLACE(@BPConfiguration, '{2}', '1')

	DECLARE @BPInsurance VARCHAR(MAX), @BPInsuranceNames VARCHAR(MAX)
	DECLARE @InsurancePlans VARCHAR(MAX) = ''
	SELECT @BPInsurance = CONVERT(XML, ConfigurationData).value('(./Control[@Name="_findTextInsurancePayerPlan"]/@Guid)[1]', 'varchar(max)') + ';' FROM ListAddIn WHERE AddInUid = 'A6425135-9530-4078-A4F3-EECC68358B1E'
	SELECT @BPInsuranceNames = CONVERT(XML, ConfigurationData).value('(./Control[@Name="_findTextInsurancePayerPlan"]/@Value)[1]', 'varchar(max)') + ';' FROM ListAddIn WHERE AddInUid = 'A6425135-9530-4078-A4F3-EECC68358B1E'
	IF LEN(@BPInsurance) > 0 AND CHARINDEX(';', @BPInsurance) >= 1
	BEGIN
		WHILE CHARINDEX(';', @BPInsurance) >= 1
		BEGIN
			DECLARE @Guid VARCHAR(100), @Name VARCHAR(100)
			SELECT @Guid = SUBSTRING(@BPInsurance, 0, CHARINDEX(';', @BPInsurance))
			SELECT @Name = SUBSTRING(@BPInsuranceNames, 0, CHARINDEX(';', @BPInsuranceNames))
			SET @InsurancePlans = @InsurancePlans + '<InsurancePlanDto><Id>' + @Guid + '</Id><Name>' + @Name + '</Name></InsurancePlanDto>'
			SET @BPInsurance = SUBSTRING(@BPInsurance, CHARINDEX(';', @BPInsurance) + 1, LEN(@BPInsurance))
			SET @BPInsuranceNames = SUBSTRING(@BPInsuranceNames, CHARINDEX(';', @BPInsuranceNames) + 1, LEN(@BPInsuranceNames))
		END
		SET @BPConfiguration = REPLACE(@BPConfiguration, '{3}', @InsurancePlans)
	END
	ELSE
		SET @BPConfiguration = REPLACE(@BPConfiguration, '{3}', '')

	UPDATE ListAddIn
	SET Inactive = @Inactive,
	ConfigurationData = @BPConfiguration
	WHERE AddInUid = 'C49D88BD-0E5B-4FAC-B543-2AA1810464FD'
END
GO


-- #8022 BMI/BP Note Processors bminoteprocessorconfig3.sql
DECLARE @BMIConfiguration VARCHAR(MAX)
SET @BMIConfiguration = '<BmiProcessorConfiguration xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
  <EnableCpt>{0}</EnableCpt>
  <EnableIcd>{1}</EnableIcd>
  <UseDefaultCpt>{2}</UseDefaultCpt>
  <IsExclude>{3}</IsExclude>
  <InsurancePlans>{4}</InsurancePlans>
  <RequiredTabs>DX, SP</RequiredTabs>
  <ListenerItems>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.1</DiagnosisCode10>
      <DiagnosisCode9>V85.0</DiagnosisCode9>
      <Description>Body mass index (BMI) 19 or less, adult</Description>
      <RangeStart>0</RangeStart>
      <RangeEnd>19.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.20</DiagnosisCode10>
      <DiagnosisCode9>V85.1</DiagnosisCode9>
      <Description>Body mass index (BMI) 20.0-20.9, adult</Description>
      <RangeStart>20</RangeStart>
      <RangeEnd>20.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.21</DiagnosisCode10>
      <DiagnosisCode9>V85.1</DiagnosisCode9>
      <Description>Body mass index (BMI) 21.0-21.9, adult</Description>
      <RangeStart>21</RangeStart>
      <RangeEnd>21.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.22</DiagnosisCode10>
      <DiagnosisCode9>V85.1</DiagnosisCode9>
      <Description>Body mass index (BMI) 22.0-22.9, adult</Description>
      <RangeStart>22</RangeStart>
      <RangeEnd>22.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.23</DiagnosisCode10>
      <DiagnosisCode9>V85.1</DiagnosisCode9>
      <Description>Body mass index (BMI) 23.0-23.9, adult</Description>
      <RangeStart>23</RangeStart>
      <RangeEnd>23.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.24</DiagnosisCode10>
      <DiagnosisCode9>V85.1</DiagnosisCode9>
      <Description>Body mass index (BMI) 24.0-24.9, adult</Description>
      <RangeStart>24</RangeStart>
      <RangeEnd>24.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.25</DiagnosisCode10>
      <DiagnosisCode9>V85.21</DiagnosisCode9>
      <Description>Body mass index (BMI) 25.0-25.9, adult</Description>
      <RangeStart>25</RangeStart>
      <RangeEnd>25.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.26</DiagnosisCode10>
      <DiagnosisCode9>V85.22</DiagnosisCode9>
      <Description>Body mass index (BMI) 26.0-26.9, adult</Description>
      <RangeStart>26</RangeStart>
      <RangeEnd>26.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.27</DiagnosisCode10>
      <DiagnosisCode9>V85.23</DiagnosisCode9>
      <Description>Body mass index (BMI) 27.0-27.9, adult</Description>
      <RangeStart>27</RangeStart>
      <RangeEnd>27.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.28</DiagnosisCode10>
      <DiagnosisCode9>V85.24</DiagnosisCode9>
      <Description>Body mass index (BMI) 28.0-28.9, adult</Description>
      <RangeStart>28</RangeStart>
      <RangeEnd>28.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.29</DiagnosisCode10>
      <DiagnosisCode9>V85.25</DiagnosisCode9>
      <Description>Body mass index (BMI) 29.0-29.9, adult</Description>
      <RangeStart>29</RangeStart>
      <RangeEnd>29.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.30</DiagnosisCode10>
      <DiagnosisCode9>V85.30</DiagnosisCode9>
      <Description>Body mass index (BMI) 30.0-30.9, adult</Description>
      <RangeStart>30</RangeStart>
      <RangeEnd>30.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.31</DiagnosisCode10>
      <DiagnosisCode9>V85.31</DiagnosisCode9>
      <Description>Body mass index (BMI) 31.0-31.9, adult</Description>
      <RangeStart>31</RangeStart>
      <RangeEnd>31.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.32</DiagnosisCode10>
      <DiagnosisCode9>V85.32</DiagnosisCode9>
      <Description>Body mass index (BMI) 32.0-32.9, adult</Description>
      <RangeStart>32</RangeStart>
      <RangeEnd>32.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.33</DiagnosisCode10>
      <DiagnosisCode9>V85.33</DiagnosisCode9>
      <Description>Body mass index (BMI) 33.0-33.9, adult</Description>
      <RangeStart>33</RangeStart>
      <RangeEnd>33.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.34</DiagnosisCode10>
      <DiagnosisCode9>V85.34</DiagnosisCode9>
      <Description>Body mass index (BMI) 34.0-34.9, adult</Description>
      <RangeStart>34</RangeStart>
      <RangeEnd>34.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.35</DiagnosisCode10>
      <DiagnosisCode9>V85.35</DiagnosisCode9>
      <Description>Body mass index (BMI) 35.0-35.9, adult</Description>
      <RangeStart>35</RangeStart>
      <RangeEnd>35.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.36</DiagnosisCode10>
      <DiagnosisCode9>V85.36</DiagnosisCode9>
      <Description>Body mass index (BMI) 36.0-36.9, adult</Description>
      <RangeStart>36</RangeStart>
      <RangeEnd>36.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.37</DiagnosisCode10>
      <DiagnosisCode9>V85.37</DiagnosisCode9>
      <Description>Body mass index (BMI) 37.0-37.9, adult</Description>
      <RangeStart>37</RangeStart>
      <RangeEnd>37.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.38</DiagnosisCode10>
      <DiagnosisCode9>V85.38</DiagnosisCode9>
      <Description>Body mass index (BMI) 38.0-38.9, adult</Description>
      <RangeStart>38</RangeStart>
      <RangeEnd>38.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.39</DiagnosisCode10>
      <DiagnosisCode9>V85.39</DiagnosisCode9>
      <Description>Body mass index (BMI) 39.0-39.9, adult</Description>
      <RangeStart>39</RangeStart>
      <RangeEnd>39.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.41</DiagnosisCode10>
      <DiagnosisCode9>V85.41</DiagnosisCode9>
      <Description>Body mass index (BMI) 40.0-44.9, adult</Description>
      <RangeStart>40</RangeStart>
      <RangeEnd>44.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.42</DiagnosisCode10>
      <DiagnosisCode9>V85.42</DiagnosisCode9>
      <Description>Body mass index (BMI) 45.0-49.9, adult</Description>
      <RangeStart>45</RangeStart>
      <RangeEnd>49.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.43</DiagnosisCode10>
      <DiagnosisCode9>V85.43</DiagnosisCode9>
      <Description>Body mass index (BMI) 50-59.9 , adult</Description>
      <RangeStart>50</RangeStart>
      <RangeEnd>59.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.44</DiagnosisCode10>
      <DiagnosisCode9>V85.44</DiagnosisCode9>
      <Description>Body mass index (BMI) 60.0-69.9, adult</Description>
      <RangeStart>60</RangeStart>
      <RangeEnd>69.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.45</DiagnosisCode10>
      <DiagnosisCode9>V85.45</DiagnosisCode9>
      <Description>Body mass index (BMI) 70 or greater, adult</Description>
      <RangeStart>70</RangeStart>
      <RangeEnd>999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000001</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.51</DiagnosisCode10>
      <DiagnosisCode9>V85.51</DiagnosisCode9>
      <Description>Body mass index (BMI) pediatric, less than 5th percentile for age</Description>
      <RangeStart>0</RangeStart>
      <RangeEnd>4.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000002</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.52</DiagnosisCode10>
      <DiagnosisCode9>V85.52</DiagnosisCode9>
      <Description>Body mass index (BMI) pediatric, 5th percentile to less than 85th percentile for age</Description>
      <RangeStart>5</RangeStart>
      <RangeEnd>84.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000002</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.53</DiagnosisCode10>
      <DiagnosisCode9>V85.53</DiagnosisCode9>
      <Description>Body mass index (BMI) pediatric, 85th percentile to less than 95th percentile for age</Description>
      <RangeStart>85</RangeStart>
      <RangeEnd>94.999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000002</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <DiagnosisCode10>Z68.54</DiagnosisCode10>
      <DiagnosisCode9>V85.54</DiagnosisCode9>
      <Description>Body mass index (BMI) pediatric, greater than or equal to 95th percentile for age</Description>
      <RangeStart>95</RangeStart>
      <RangeEnd>999</RangeEnd>
      <AgeGroup>00000000-0000-0000-0000-000000000002</AgeGroup>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <CptCode>G8417</CptCode>
      <Description>BMI is documented above normal parameters and a follow-up plan is documented</Description>
      <RangeStart>25</RangeStart>
      <RangeEnd>999</RangeEnd>
      <AgeStart>18</AgeStart>
      <AgeEnd>64</AgeEnd>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <CptCode>G8418</CptCode>
      <Description>BMI is documented below normal parameters and a follow-up plan is documented</Description>
      <RangeStart>0.1</RangeStart>
      <RangeEnd>18.4</RangeEnd>
      <AgeStart>18</AgeStart>
      <AgeEnd>64</AgeEnd>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <CptCode>G8418</CptCode>
      <Description>BMI is documented below normal parameters and a follow-up plan is documented</Description>
      <RangeStart>0.1</RangeStart>
      <RangeEnd>22.999</RangeEnd>
      <AgeStart>65</AgeStart>
      <AgeEnd>999</AgeEnd>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <CptCode>G8420</CptCode>
      <Description>BMI is documented within normal parameters and no follow-up plan is required</Description>
      <RangeStart>18.5</RangeStart>
      <RangeEnd>24.999</RangeEnd>
      <AgeStart>18</AgeStart>
      <AgeEnd>64</AgeEnd>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <CptCode>G8420</CptCode>
      <Description>BMI is documented within normal parameters and no follow-up plan is required</Description>
      <RangeStart>23</RangeStart>
      <RangeEnd>29.999</RangeEnd>
      <AgeStart>65</AgeStart>
      <AgeEnd>999</AgeEnd>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <CptCode>G8421</CptCode>
      <Description>Bmi not documented and no reason is given</Description>
      <RangeStart>0</RangeStart>
      <RangeEnd>0</RangeEnd>
      <AgeStart>0</AgeStart>
      <AgeEnd>999</AgeEnd>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <CptCode>G8422</CptCode>
      <Description>BMI not documented, documentation the patient is not eligible for BMI calculation</Description>
      <RangeStart>0</RangeStart>
      <RangeEnd>0</RangeEnd>
      <AgeStart>0</AgeStart>
      <AgeEnd>999</AgeEnd>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
    <BodyMassIndexListener>
      <CptCode>G8938</CptCode>
      <Description>BMI is documented as being outside of normal limits, follow-up plan is not documented, documentation the patient is not eligible</Description>
      <RangeStart>0</RangeStart>
      <RangeEnd>0</RangeEnd>
      <AgeStart>0</AgeStart>
      <AgeEnd>999</AgeEnd>
      <Enabled>1</Enabled>
    </BodyMassIndexListener>
  </ListenerItems>
</BmiProcessorConfiguration>'

IF EXISTS(SELECT 1 FROM ListAddIn WHERE AddInUid = 'CCF82708-F120-43FF-97FC-A1299EEF462E')
BEGIN
	DECLARE @Inactive BIT
	SELECT @Inactive = Inactive FROM ListAddIn WHERE AddInUid = 'CCF82708-F120-43FF-97FC-A1299EEF462E'

	UPDATE ListAddIn SET Inactive = 1 WHERE AddInUid = 'CCF82708-F120-43FF-97FC-A1299EEF462E'

	DECLARE @BMIAssignCPT VARCHAR(50)
	SELECT @BMIAssignCPT = CONVERT(XML, ConfigurationData).value('(./Control[@Name="checkboxAssignCPT"]/@Value)[1]', 'varchar(max)') FROM ListAddIn WHERE AddInUid = 'CCF82708-F120-43FF-97FC-A1299EEF462E'
	IF LOWER(@BMIAssignCPT) = 'true'
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{0}', '1')
	ELSE
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{0}', '0')

	DECLARE @BMIAssignICD VARCHAR(50)
	SELECT @BMIAssignICD = CONVERT(XML, ConfigurationData).value('(./Control[@Name="checkboxAssignICD"]/@Value)[1]', 'varchar(max)') FROM ListAddIn WHERE AddInUid = 'CCF82708-F120-43FF-97FC-A1299EEF462E'
	IF LOWER(@BMIAssignICD) = 'true'
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{1}', '1')
	ELSE
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{1}', '0')

	DECLARE @BMIUseDefault VARCHAR(50)
	SELECT @BMIUseDefault = CONVERT(XML, ConfigurationData).value('(./Control[@Name="checkBoxUseDefaultCpt"]/@Value)[1]', 'varchar(max)') FROM ListAddIn WHERE AddInUid = 'CCF82708-F120-43FF-97FC-A1299EEF462E'
	IF LOWER(@BMIUseDefault) = 'true'
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{2}', '1')
	ELSE
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{2}', '0')

	DECLARE @BMIInclude VARCHAR(50)
	SELECT @BMIInclude = CONVERT(XML, ConfigurationData).value('(./Control[@Name="prmRadioButtonInclude"]/@Value)[1]', 'varchar(max)') FROM ListAddIn WHERE AddInUid = 'CCF82708-F120-43FF-97FC-A1299EEF462E'
	IF LOWER(@BMIInclude) = 'true'
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{3}', '0')
	ELSE
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{3}', '1')

	DECLARE @BMIInsurance VARCHAR(MAX), @BMIInsuranceNames VARCHAR(MAX)
	DECLARE @InsurancePlans VARCHAR(MAX) = ''
	SELECT @BMIInsurance = CONVERT(XML, ConfigurationData).value('(./Control[@Name="_findTextInsurancePayerPlan"]/@Guid)[1]', 'varchar(max)') + ';' FROM ListAddIn WHERE AddInUid = 'CCF82708-F120-43FF-97FC-A1299EEF462E'
	SELECT @BMIInsuranceNames = CONVERT(XML, ConfigurationData).value('(./Control[@Name="_findTextInsurancePayerPlan"]/@Value)[1]', 'varchar(max)') + ';' FROM ListAddIn WHERE AddInUid = 'CCF82708-F120-43FF-97FC-A1299EEF462E'
	IF LEN(@BMIInsurance) > 0 AND CHARINDEX(';', @BMIInsurance) >= 1
	BEGIN
		WHILE CHARINDEX(';', @BMIInsurance) >= 1
		BEGIN
			DECLARE @Guid VARCHAR(100), @Name VARCHAR(100)
			SELECT @Guid = SUBSTRING(@BMIInsurance, 0, CHARINDEX(';', @BMIInsurance))
			SELECT @Name = SUBSTRING(@BMIInsuranceNames, 0, CHARINDEX(';', @BMIInsuranceNames))
			SET @InsurancePlans = @InsurancePlans + '<InsurancePlanDto><Id>' + @Guid + '</Id><Name>' + @Name + '</Name></InsurancePlanDto>'
			SET @BMIInsurance = SUBSTRING(@BMIInsurance, CHARINDEX(';', @BMIInsurance) + 1, LEN(@BMIInsurance))
			SET @BMIInsuranceNames = SUBSTRING(@BMIInsuranceNames, CHARINDEX(';', @BMIInsuranceNames) + 1, LEN(@BMIInsuranceNames))
		END
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{4}', @InsurancePlans)
	END
	ELSE
		SET @BMIConfiguration = REPLACE(@BMIConfiguration, '{4}', '')

	UPDATE ListAddIn
	SET Inactive = @Inactive,
	ConfigurationData = @BMIConfiguration
	WHERE AddInUid = 'CCD7CB59-7995-4DB7-8567-37B9430C86B4'
END
GO

-- #12362 UpdateMitochonSettings  PostMigration_UpdateMitochonSettings.sql
IF EXISTS(Select * from ListMessageSubtype where MessageSubTypeUid = 'C9C0DACB-D75C-4E6E-8333-CE5927482DE7')
BEGIN
update listmessagesubtype
set ConfigurationXML = '<Configuration>
  <ForeignBusinessObjectAQN />
  <ControlNewAQN />
  <ControlEditAQN />
  <MessageDetailPath />
  <TabPages>
    <TabPage>
      <TabPageAQN>iMedica.Prm.Client.UI.Messaging.ControlDrugSampleMessage</TabPageAQN>
      <TabPageName>tabPageDrugSample</TabPageName>
      <TabPageTitle>Drug Sample</TabPageTitle>
      <TabPageScrollable>0</TabPageScrollable>
    </TabPage>
  </TabPages>
</Configuration>'
where MessageSubTypeUid = 'C9C0DACB-D75C-4E6E-8333-CE5927482DE7'
END


IF EXISTS(Select * from ListIntegrationPartner where IntegrationPartnerUid = 'EFD45848-D973-4509-B3AA-2D1E3851B241')
BEGIN
update ListIntegrationPartner
set AdditionalOutboundXML = '<settings corepointTestBaseUrl="https://cp01.prod.aprima.com:31110/" corepointProdBaseUrl="https://integration.aprima.com/REST/" username="aprima" testPassword="y7qp!$xd7b" prodPassword="4rfq2c7!i%" prodBaseUrl="https://sampleorderapi.mitochon.com" testBaseUrl="http://mitochonapi.ddns.net">
  <ProviderOptOut />
</settings>'
where IntegrationPartnerUid = 'EFD45848-D973-4509-B3AA-2D1E3851B241'
END
GO

-- #12164 SetPatientCarePlanActive   PostMigration_SetPatientCarePlanActive.sql
IF EXISTS(select * from ListUIControl where UIControlUid = 'C9107E04-5836-472E-BAB1-00FF62795AA8')
BEGIN
update listuicontrol
set Inactive = 0
where UIControlUid = 'C9107E04-5836-472E-BAB1-00FF62795AA8'
END
GO

-- #13206 UpdateListMessageType PostMigration_UpdateListMessageType.sql
IF EXISTS(Select * from ListMessageType where messagetypeuid = '2C259B74-444F-4F29-9634-5768DDA9E572')
BEGIN
update ListMessageType
set ConfigurationXML = '<Configuration>
	<ForeignBusinessObjectAQN />
  <ControlNewAQN>iMedica.Prm.Client.UI.Messaging.MessageRx.ControlMessage</ControlNewAQN>
  <ControlEditAQN>iMedica.Prm.Client.UI.Messaging.MessageRx.ControlMessage</ControlEditAQN>
	<MessageDetailPath />
	<TabPages>
		<TabPage>
			<TabPageAQN>iMedica.Prm.Client.UI.Messaging.MessageERxChangeRequest.ControlERxChangeRequestMessage</TabPageAQN>
			<TabPageName>tabPageRxChangeRequest</TabPageName>
			<TabPageTitle>Rx Change Request</TabPageTitle>
			<TabPageScrollable>0</TabPageScrollable>
		</TabPage>
	</TabPages>
</Configuration>'
where messagetypeuid = '2C259B74-444F-4F29-9634-5768DDA9E572'
END

IF EXISTS(Select * from ListMessageType where messagetypeuid = '61A96124-6977-491E-9390-EF506DBBC05F')
BEGIN
update ListMessageType
set ConfigurationXML = '<Configuration>
	<ForeignBusinessObjectAQN />
	<ControlNewAQN>iMedica.Prm.Client.UI.Messaging.MessageRx.ControlMessage</ControlNewAQN>
	<ControlEditAQN>iMedica.Prm.Client.UI.Messaging.MessageRx.ControlMessage</ControlEditAQN>
	<MessageDetailPath />
	<TabPages>
		<TabPage>
			<TabPageAQN>iMedica.Prm.Client.UI.Messaging.MessageERxChangeRequest.ControlERxChangeRequestMessage</TabPageAQN>
			<TabPageName>tabPageRxChangeRequest</TabPageName>
			<TabPageTitle>Rx Prior Authorization Request</TabPageTitle>
			<TabPageScrollable>0</TabPageScrollable>
		</TabPage>
	</TabPages>
</Configuration>'
where messagetypeuid = '61A96124-6977-491E-9390-EF506DBBC05F'
END
GO

-- #14043 Mitochon TestMode 
IF EXISTS(Select * from ListMessageSubtype where MessageSubTypeUid = 'C9C0DACB-D75C-4E6E-8333-CE5927482DE7')
BEGIN
update listmessagesubtype
set ConfigurationXML = '<Configuration>
  <ForeignBusinessObjectAQN />
  <ControlNewAQN />
  <ControlEditAQN />
  <MessageDetailPath />
  <TabPages>
    <TabPage>
      <TabPageAQN>iMedica.Prm.Client.UI.Messaging.ControlDrugSampleMessage</TabPageAQN>
      <TabPageName>tabPageDrugSample</TabPageName>
      <TabPageTitle>Drug Sample</TabPageTitle>
      <TabPageScrollable>0</TabPageScrollable>
    </TabPage>
  </TabPages>
</Configuration>'
where MessageSubTypeUid = 'C9C0DACB-D75C-4E6E-8333-CE5927482DE7'
END

DECLARE @TestFlag bit, @Number varchar(20), @TestMode varchar(9) = 0
select @TestFlag = BoolValue from ListProductParameter where ParameterName = 'RegistrationCustomerLicense'
select @Number = StringValue from ListProductParameter where ParameterName = 'RegistrationCustomerNumber'

select @TestMode = 1   where @TestFlag = 1
OR @Number like 'test' -- regular test database license
OR @Number like '000%' -- dev test database license 
OR @Number like '888%' -- QA test database licenses


IF EXISTS(Select * from ListIntegrationPartner where IntegrationPartnerUid = 'EFD45848-D973-4509-B3AA-2D1E3851B241')
BEGIN
update ListIntegrationPartner
set AdditionalOutboundXML = '<settings corepointTestBaseUrl="https://cp01.prod.aprima.com:31110/" corepointProdBaseUrl="https://integration.aprima.com/REST/" username="aprima" testPassword="y7qp!$xd7b" prodPassword="4rfq2c7!i%" prodBaseUrl="https://sampleorderapi.mitochon.com" testBaseUrl="http://mitochonapi.ddns.net">
  <ProviderOptOut />
</settings>',TestMode = @TestMode
where IntegrationPartnerUid = 'EFD45848-D973-4509-B3AA-2D1E3851B241'
END
GO