-- Neil  (copied from 2011/2014 migration)
-- ListSystem has a new unique index on Name so cleanup the duplicates
IF EXISTS(SELECT * FROM ListSystem s1 INNER JOIN ListSystem s2 ON s1.Name = s2.Name WHERE s1.SystemUid <> s2.SystemUid)
BEGIN
	DECLARE @duplicate TABLE (	Name VARCHAR(100),
								SystemUid UNIQUEIDENTIFIER NULL
							)

	INSERT			@duplicate(Name)
	SELECT DISTINCT	s1.Name
	FROM			ListSystem s1 inner join ListSystem s2 on s1.Name = s2.Name 
	WHERE			s1.SystemUid <> s2.SystemUid

	UPDATE	@duplicate
	SET		SystemUid = s.SystemUid
	FROM	@duplicate d INNER JOIN ListSystem s ON d.Name = s.Name
	WHERE	s.UserDefined = 0 OR s.UserDefined = 2

	UPDATE	@duplicate
	SET		SystemUid = s.SystemUid
	FROM	@duplicate d INNER JOIN ListSystem s ON d.Name = s.Name
	WHERE	d.SystemUid IS NULL AND
			s.Inactive = 0

	UPDATE	@duplicate
	SET		SystemUid = s.SystemUid
	FROM	@duplicate d INNER JOIN ListSystem s ON d.Name = s.Name
	WHERE	d.SystemUid IS NULL 

	UPDATE	s
	SET		Inactive = 0
	FROM	@duplicate d INNER JOIN ListSystem s ON d.SystemUid = s.SystemUid
	WHERE	s.Inactive = 1 AND
			s.Name IN (SELECT s1.Name FROM ListSystem s1 WHERE s1.Name = s.Name AND s1.Inactive = 0)

	DECLARE	@systemUid1 UNIQUEIDENTIFIER
	DECLARE	@systemUid2 UNIQUEIDENTIFIER
	DECLARE @temp UNIQUEIDENTIFIER
	DECLARE @symptomUid UNIQUEIDENTIFIER
	DECLARE @relSystemSymptomUid UNIQUEIDENTIFIER

	DECLARE cur CURSOR FOR
		SELECT			d.SystemUid, s.SystemUid
		FROM			@duplicate d INNER JOIN ListSystem s ON d.Name = s.Name
		WHERE			s.SystemUid <> d.SystemUid

	OPEN cur

	FETCH NEXT FROM cur INTO @systemUid1, @systemUid2
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		PRINT 'Merging ' + CAST(@systemUid2 AS VARCHAR(50))+ ' into ' + CAST(@systemUid1 AS VARCHAR(50))

		DECLARE ccCursor CURSOR FOR
			SELECT	CCSymptomUid
			FROM	RelCCSystemSymptom
			WHERE	CCSystemUid = @systemUid2

		OPEN ccCursor
		FETCH NEXT FROM ccCursor INTO @symptomUid
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			IF NOT EXISTS(SELECT * FROM CCSystem WHERE CCSystemUid = @systemUid1)
				INSERT	CCSystem
				SELECT	@systemUid1, DisplayOrder, UserDefined, LicenseCode, ClinicCenterOverride, ProviderOverride, LastModifiedDate, LastModifiedByUid
				FROM	CCSystem					
				WHERE	CCSystemUid = @systemUid2

			PRINT	'Update CppCC'
			UPDATE	CppCC
			SET		CCSystemUid = @systemUid1
			WHERE	CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid

			PRINT 'Update VisitHpi'
			UPDATE	VisitHpi
			SET		CCSystemUid = @systemUid1
			WHERE	CCSystemUid = @systemUid2 AND
					CCSymptomUid = @symptomUid

			SET @relSystemSymptomUid = NULL
			SELECT TOP 1 @relSystemSymptomUid = RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid1 AND CCSymptomUid = @symptomUid
			IF @relSystemSymptomUid IS NULL 
			BEGIN
				PRINT	'Update RelCCSystemSymptom ' + CAST(@systemUid1 AS VARCHAR(50)) + ' ' + CAST(@systemUid2 AS VARCHAR(50)) + ' ' + CAST(@symptomUid AS VARCHAR(50))
				UPDATE	RelCCSystemSymptom
				SET		CCSystemUid = @systemUid1
				WHERE	CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid
			END
			ELSE
			BEGIN
				PRINT	'Update VisitCC ' + CAST(@systemUid1 AS VARCHAR(50)) + ' ' + CAST(@systemUid2 AS VARCHAR(50)) + ' -> ' + CAST(@symptomUid AS VARCHAR(50)) + '/' + CAST(@relSystemSymptomUid AS VARCHAR(50))
				UPDATE	VisitCC
				SET		RelCCSystemSymptomUid = @relSystemSymptomUid,
						CCSystemUid = @systemUid1
				WHERE	CCSystemUid = @systemUid2 AND -- Handle MFU Case
						CCSymptomUid = @symptomUid

				UPDATE	r
				SET	RelCCSystemSymptomUid = @relSystemSymptomUid
				FROM	RelEduFormCCSymptom r
				WHERE	r.RelCCSystemSymptomUid IN (SELECT RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND RelCCSystemSymptomUid <> @relSystemSymptomUid)

				UPDATE	v
				SET		RelCCSystemSymptomUid = @relSystemSymptomUid
				FROM	VisitCC v
				WHERE	v.RelCCSystemSymptomUid IN (SELECT RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND RelCCSystemSymptomUid <> @relSystemSymptomUid)

				PRINT	'Delete RelCCSymptomHpi'
				DELETE	hpi
				FROM	RelCCSymptomHpi hpi INNER JOIN RelCCSymptomHpiCategory hpicat ON hpi.RelCCSymptomHpiCategoryUid = hpicat.RelCCSymptomHpiCategoryUid
						INNER JOIN RelCCSystemSymptom syssym ON hpicat.RelCCSystemSymptomUid = syssym.RelCCSystemSymptomUid
				WHERE	CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND syssym.RelCCSystemSymptomUid <> @relSystemSymptomUid

				PRINT	'Delete RelCCSymptomHpiCategory'
				DELETE	hpicat
				FROM	RelCCSymptomHpiCategory hpicat INNER JOIN RelCCSystemSymptom syssym ON hpicat.RelCCSystemSymptomUid = syssym.RelCCSystemSymptomUid
				WHERE	CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND syssym.RelCCSystemSymptomUid <> @relSystemSymptomUid

				PRINT	'Delete RelCCSystemSymptom'
				DELETE FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND RelCCSystemSymptomUid <> @relSystemSymptomUid
			END

			FETCH NEXT FROM ccCursor INTO @symptomUid
		END	
		CLOSE ccCursor
		DEALLOCATE ccCursor	

		PRINT	'Update CppCC'
		UPDATE	CppCC
		SET		CCSystemUid = @systemUid1
		WHERE	CCSystemUid = @systemUid2

		PRINT	'Update VisitCC'
		UPDATE	VisitCC
		SET		CCSystemUid = @systemUid1
		WHERE	CCSystemUid = @systemUid2				

		PRINT	'Update VisitHpi'
		UPDATE	VisitHpi
		SET		CCSystemUid = @systemUid1
		WHERE	CCSystemUid = @systemUid2

		PRINT	'Delete CCSystem'
		DELETE FROM	CCSystem
		WHERE	CCSystemUid = @systemUid2

		DECLARE rosCursor CURSOR FOR
			SELECT	RosSymptomUid
			FROM	RelRosSystemSymptom
			WHERE	RosSystemUid = @systemUid2

		OPEN rosCursor
		FETCH NEXT FROM rosCursor INTO @symptomUid
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			SET @relSystemSymptomUid = NULL
			SELECT TOP 1 @relSystemSymptomUid = RelRosSystemSymptomUid FROM RelRosSystemSymptom WHERE RosSystemUid = @systemUid1 AND RosSymptomUid = @symptomUid
			IF @relSystemSymptomUid IS NULL 
			BEGIN
				IF NOT EXISTS(SELECT * FROM RosSystem WHERE RosSystemUid = @systemUid1)
					INSERT	ROSSystem
					SELECT	@systemUid1, DisplayOrder, SystemDisplayOrder, UserDefined, ClinicCenterOverride, ProviderOverride, LastModifiedByUid, LastModifiedDate
					FROM	RosSystem					
					WHERE	RosSystemUid = @systemUid2
					
				select * from rossystem
				PRINT	'Update RelRosSystemSymptom'
				UPDATE	RelRosSystemSymptom
				SET		RosSystemUid = @systemUid1
				WHERE	RosSystemUid = @systemUid2 AND RosSymptomUid = @symptomUid

				PRINT	'Update RelRosSystemSymptom'
				UPDATE	RelRosSystemSymptom
				SET		RosSystemUid = @systemUid1
				WHERE	RosSystemUid = @systemUid2 AND RosSymptomUid = @symptomUid
			END
			ELSE
			BEGIN
				PRINT	'Update ListSurveyQuestion'
				UPDATE	lq
				SET		RelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	ListSurveyQuestion lq INNER JOIN RelRosSystemSymptom r ON lq.RelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid2 AND r.RosSymptomUid = @symptomUid

				PRINT	'Update SurveyResponse'
				UPDATE	sr
				SET	RelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	SurveyResponse sr INNER JOIN RelRosSystemSymptom r ON sr.RelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid2 AND r.RosSymptomUid = @symptomUid

				PRINT	'Update SurveyResponse'
				UPDATE	sr
				SET		RelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	SurveyResponse sr INNER JOIN RelRosSystemSymptom r ON sr.PredeterminedRelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid2 AND r.RosSymptomUid = @symptomUid

				PRINT	'Delete RelRosSystemSymptom'
				DELETE FROM RelRosSystemSymptom WHERE RosSystemUid = @systemUid2 AND RosSymptomUid = @symptomUid AND RelRosSystemSymptomUid <> @relSystemSymptomUid
			END
			FETCH NEXT FROM rosCursor INTO @symptomUid
		END	
		CLOSE rosCursor
		DEALLOCATE rosCursor	

		PRINT	'Update VisitRos'
		UPDATE	VisitRos
		SET		RosSystemUid = @systemUid1
		WHERE	RosSystemUid = @systemUid2

		PRINT	'Update CppRos'
		UPDATE	r1
		SET		r1.RosSystemUid = @systemUid1
		FROM	CPPRos r1 LEFT JOIN CPPRos r2 ON r1.RosSymptomUid = r2.RosSymptomUid AND r2.RosSystemUid = @systemUid1
		WHERE	r1.RosSystemUid = @systemUid2 AND
				r2.CppRosUid IS NULL

		PRINT	'Delete CppRos'
		DELETE FROM	CPPRos 
		WHERE	RosSystemUid = @systemUid2 

		PRINT 'Delete ListSystem'
		DELETE FROM ListSystem WHERE SystemUid = @systemUid2

		FETCH NEXT FROM cur INTO @systemUid1, @systemUid2
	END

	CLOSE cur
	DEALLOCATE cur
END
GO

-- Neil
-- ListSymptom has a new unique index on Name so cleanup the duplicates
IF EXISTS(SELECT * FROM ListSymptom s1 INNER JOIN ListSymptom s2 ON s1.Name = s2.Name WHERE s1.SymptomUid <> s2.SymptomUid)
BEGIN
	DECLARE @duplicate TABLE (	Name VARCHAR(100),
								SymptomUid UNIQUEIDENTIFIER NULL
							)

	INSERT			@duplicate(Name)
	SELECT DISTINCT	s1.Name
	FROM			ListSymptom s1 inner join ListSymptom s2 on s1.Name = s2.Name 
	WHERE			s1.Symptomuid <> s2.Symptomuid

	UPDATE	@duplicate
	SET		SymptomUid = s.SymptomUid
	FROM	@duplicate d INNER JOIN ListSymptom s ON d.Name = s.Name
	WHERE	s.UserDefined = 0 OR s.UserDefined = 2

	UPDATE	@duplicate
	SET		SymptomUid = s.SymptomUid
	FROM	@duplicate d INNER JOIN ListSymptom s ON d.Name = s.Name
	WHERE	d.SymptomUid IS NULL AND
			s.Inactive = 0

	UPDATE	@duplicate
	SET		SymptomUid = s.SymptomUid
	FROM	@duplicate d INNER JOIN ListSymptom s ON d.Name = s.Name
	WHERE	d.SymptomUid IS NULL 

	UPDATE	s
	SET		Inactive = 0
	FROM	@duplicate d INNER JOIN ListSymptom s ON d.SymptomUid = s.SymptomUid
	WHERE	s.Inactive = 1 AND
			s.Name IN (SELECT s1.Name FROM ListSymptom s1 WHERE s1.Name = s.Name AND s1.Inactive = 0)

	DECLARE	@symptomUid1 UNIQUEIDENTIFIER
	DECLARE	@symptomUid2 UNIQUEIDENTIFIER
	DECLARE @temp UNIQUEIDENTIFIER
	DECLARE @systemUid UNIQUEIDENTIFIER
	DECLARE @relSystemSymptomUid UNIQUEIDENTIFIER

	DECLARE cur CURSOR FOR
		SELECT			d.SymptomUid, s.SymptomUid
		FROM			@duplicate d INNER JOIN ListSymptom s ON d.Name = s.Name
		WHERE			s.SymptomUid <> d.SymptomUid

	OPEN cur

	FETCH NEXT FROM cur INTO @symptomUid1, @symptomUid2
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		PRINT 'Merging ' + CAST(@symptomUid2 AS VARCHAR(50))+ ' into ' + CAST(@symptomUid1 AS VARCHAR(50))

		DECLARE ccCursor CURSOR FOR
			SELECT	CCSystemUid
			FROM	RelCCSystemSymptom
			WHERE	CCSymptomUid = @symptomUid2

		OPEN ccCursor
		FETCH NEXT FROM ccCursor INTO @systemUid
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			PRINT	'Update CppCC'
			UPDATE	CppCC
			SET		CCSymptomUid = @symptomUid1
			WHERE	CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2

			PRINT 'Update VisitHpi'
			UPDATE	VisitHpi
			SET		CCSymptomUid = @symptomUid1
			WHERE	CCSystemUid = @systemUid AND
					CCSymptomUid = @symptomUid2

			SET @relSystemSymptomUid = NULL
			SELECT TOP 1 @relSystemSymptomUid = RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid1
			IF @relSystemSymptomUid IS NULL 
			BEGIN
				PRINT	'Update RelCCSystemSymptom ' + CAST(@systemUid AS VARCHAR(50)) + ' ' + CAST(@symptomUid1 AS VARCHAR(50)) + ' ' + CAST(@symptomUid2 AS VARCHAR(50))
				UPDATE	RelCCSystemSymptom
				SET		CCSymptomUid = @symptomUid1
				WHERE	CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2
			END
			ELSE
			BEGIN
				PRINT	'Update VisitCC ' + CAST(@systemUid AS VARCHAR(50)) + ' ' + CAST(@symptomUid2 AS VARCHAR(50)) + ' -> ' + CAST(@symptomUid1 AS VARCHAR(50)) + '/' + CAST(@relSystemSymptomUid AS VARCHAR(50))
				UPDATE	VisitCC
				SET		RelCCSystemSymptomUid = @relSystemSymptomUid,
						CCSymptomUid = @symptomUid1
				WHERE	(CCSystemUid = @systemUid OR CCSystemUid = 'FFFFFFFF-0000-0000-0000-000000000001') AND -- Handle MFU Case
						CCSymptomUid = @symptomUid2 

				UPDATE	v
				SET		RelCCSystemSymptomUid = @relSystemSymptomUid
				FROM	VisitCC v
				WHERE	v.RelCCSystemSymptomUid IN (SELECT RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2 AND RelCCSystemSymptomUid <> @relSystemSymptomUid)

				PRINT	'Delete RelCCSymptomHpi'
				DELETE	hpi
				FROM	RelCCSymptomHpi hpi INNER JOIN RelCCSymptomHpiCategory hpicat ON hpi.RelCCSymptomHpiCategoryUid = hpicat.RelCCSymptomHpiCategoryUid
						INNER JOIN RelCCSystemSymptom syssym ON hpicat.RelCCSystemSymptomUid = syssym.RelCCSystemSymptomUid
				WHERE	CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2 AND syssym.RelCCSystemSymptomUid <> @relSystemSymptomUid

				PRINT	'Delete RelCCSymptomHpiCategory'
				DELETE	hpicat
				FROM	RelCCSymptomHpiCategory hpicat INNER JOIN RelCCSystemSymptom syssym ON hpicat.RelCCSystemSymptomUid = syssym.RelCCSystemSymptomUid
				WHERE	CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2 AND syssym.RelCCSystemSymptomUid <> @relSystemSymptomUid

				PRINT	'Delete RelCCSystemSymptom'
				DELETE FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2 AND RelCCSystemSymptomUid <> @relSystemSymptomUid
			END

			FETCH NEXT FROM ccCursor INTO @systemUid
		END	
		CLOSE ccCursor
		DEALLOCATE ccCursor	

		PRINT	'Update CppCC'
		UPDATE	CppCC
		SET		CCSymptomUid = @symptomUid1
		WHERE	CCSymptomUid = @symptomUid2

		PRINT	'Update CppHPI'
		UPDATE	CppHpi
		SET		CCSymptomUid = @symptomUid1
		WHERE	CCSymptomUid = @symptomUid2

		PRINT	'Update VisitCC'
		UPDATE	VisitCC
		SET		CCSymptomUid = @symptomUid1
		WHERE	CCSymptomUid = @symptomUid2				

		PRINT	'Update VisitHpi'
		UPDATE	VisitHpi
		SET		CCSymptomUid = @symptomUid1
		WHERE	CCSymptomUid = @symptomUid2

		DECLARE rosCursor CURSOR FOR
			SELECT	RosSystemUid
			FROM	RelRosSystemSymptom
			WHERE	RosSymptomUid = @symptomUid2

		OPEN rosCursor
		FETCH NEXT FROM rosCursor INTO @systemUid
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			SET @relSystemSymptomUid = NULL
			SELECT TOP 1 @relSystemSymptomUid = RelRosSystemSymptomUid FROM RelRosSystemSymptom WHERE RosSystemUid = @systemUid AND RosSymptomUid = @symptomUid1
			IF @relSystemSymptomUid IS NULL 
			BEGIN
				PRINT	'Update RelRosSystemSymptom'
				UPDATE	RelRosSystemSymptom
				SET		RosSymptomUid = @symptomUid1
				WHERE	RosSystemUid = @systemUid AND RosSymptomUid = @symptomUid2

				PRINT	'Update RelRosSystemSymptom'
				UPDATE	RelRosSystemSymptom
				SET		RosSymptomUid = @symptomUid1
				WHERE	RosSystemUid = @systemUid AND RosSymptomUid = @symptomUid2
			END
			ELSE
			BEGIN
				PRINT	'Update SurveyResponse'
				UPDATE	sr
				SET		RelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	SurveyResponse sr INNER JOIN RelRosSystemSymptom r ON sr.RelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid AND r.RosSymptomUid = @symptomUid2

				PRINT	'ListSurveyAnswer'
				UPDATE	sa
				SET		PredeterminedRelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	ListSurveyAnswer sa INNER JOIN RelRosSystemSymptom r ON sa.PredeterminedRelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid AND r.RosSymptomUid = @symptomUid2
				
				PRINT	'Delete RelRosSystemSymptom'
				DELETE FROM RelRosSystemSymptom WHERE RosSystemUid = @systemUid AND RosSymptomUid = @symptomUid2 AND RelRosSystemSymptomUid <> @relSystemSymptomUid
			END
			FETCH NEXT FROM rosCursor INTO @systemUid
		END	
		CLOSE rosCursor
		DEALLOCATE rosCursor	

		PRINT	'Update VisitRos'
		UPDATE	VisitRos
		SET		RosSymptomUid = @symptomUid1
		WHERE	RosSymptomUid = @symptomUid2

		PRINT	'Update CppRos'
		UPDATE	r1
		SET		r1.RosSymptomUid = @symptomUid1
		FROM	CPPRos r1 LEFT JOIN CPPRos r2 ON r1.RosSystemUid = r2.RosSystemUid AND r2.RosSymptomUid = @symptomUid1
		WHERE	r1.RosSymptomUid = @symptomUid2 AND
				r2.CppRosUid IS NULL

		PRINT	'Delete CppRos'
		DELETE FROM	CPPRos 
		WHERE	RosSymptomUid = @symptomUid2 

		PRINT 'Delete ListSymptom'
		DELETE FROM ListSymptom WHERE SymptomUid = @symptomUid2

		FETCH NEXT FROM cur INTO @symptomUid1, @symptomUid2
	END

	CLOSE cur
	DEALLOCATE cur
END
GO

-- Neil  (copied from 2011/2014 migration)
DECLARE @DuplicateSS TABLE	(	CCSystemUid UNIQUEIDENTIFIER,
								CCSymptomUid UNIQUEIDENTIFIER,
								RelCCSystemSymptomUid UNIQUEIDENTIFIER NULL								
							)

INSERT				@DuplicateSS	(	CCSystemUid, CCSymptomUid	)
SELECT DISTINCT		relcc1.CCSystemUid, relcc1.CCSymptomUid
FROM				RelCCSystemSymptom relcc1 INNER JOIN RelCCSystemSymptom relcc2 ON relcc1.CCSystemUid = relcc2.CCSystemUid AND relcc1.CCSymptomUid = relcc2.CCSymptomUid
WHERE				relcc1.RelCCSystemSymptomUid <> relcc2.RelCCSystemSymptomUid

UPDATE	dss
SET		RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	relcc.UserDefined = 0 OR relcc.UserDefined = 2

UPDATE	dss
SET		RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	dss.RelCCSystemSymptomUid IS NULL AND
		(SELECT COUNT(*) FROM RelCCSymptomHpiCategory relhpicat WHERE relhpicat.RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid) > 0

UPDATE	dss
SET		RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	dss.RelCCSystemSymptomUid IS NULL 

UPDATE	vcc
SET		RelCCSystemSymptomUid = d.RelCCSystemSymptomUid
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS d ON relcc.CCSystemUid = d.CCSystemUid AND relcc.CCSymptomUid = d.CCSymptomUid AND relcc.RelCCSystemSymptomUid <> d.RelCCSystemSymptomUid
		INNER JOIN VisitCC vcc ON relcc.RelCCSystemSymptomUid = vcc.RelCCSystemSymptomUid

DELETE	relhpi
FROM	RelCCSymptomHpi relhpi INNER JOIN RelCCSymptomHpiCategory relhpicat ON relhpi.RelCCSymptomHpiCategoryUid = relhpicat.RelCCSymptomHpiCategoryUid
		INNER JOIN RelCCSystemSymptom relcc ON relhpicat.RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
		INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	relcc.RelCCSystemSymptomUid <> dss.RelCCSystemSymptomUid

DELETE	relhpicat
FROM	RelCCSymptomHpiCategory relhpicat INNER JOIN RelCCSystemSymptom relcc ON relhpicat.RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
		INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	relcc.RelCCSystemSymptomUid <> dss.RelCCSystemSymptomUid

DELETE	relcc
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	relcc.RelCCSystemSymptomUid <> dss.RelCCSystemSymptomUid
GO

-- Cleanup RelFindTableXXX
DELETE r
FROM   RelFindTableMFU r
WHERE  FindTableUid NOT IN (SELECT FindTableUid FROM ListFindTable)

DELETE r
FROM   RelFindTableMRU r
WHERE  FindTableUid NOT IN (SELECT FindTableUid FROM ListFindTable)

DELETE r
FROM   RelFindTableHide r
WHERE  FindTableUid NOT IN (SELECT FindTableUid FROM ListFindTable)
GO

-- Cleanup FK errors -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
-- DELETE T1 FROM RelVaccinePrintCols T1 LEFT JOIN ListMisc T2 ON T1.PrintColsUid = T2.MiscUid WHERE T1.PrintColsUid IS NOT NULL AND T2.MiscUid IS NULL;

-- 58933 Fix Duplicate Items so can add Unique Index
DECLARE @uniqueindex TABLE	(	RelProcedureTypeofVaccineUid UNIQUEIDENTIFIER NULL,
								ProcedureUid UNIQUEIDENTIFIER,
								TypeOfVaccineUid UNIQUEIDENTIFIER
							)

INSERT				@uniqueindex (ProcedureUid, TypeOfVaccineUid)
SELECT DISTINCT		ProcedureUid, TypeOfVaccineUid
FROM				RelProcedureTypeofVaccine r

UPDATE	t
SET		RelProcedureTypeofVaccineUid = r.RelProcedureTypeofVaccineUid
FROM	@uniqueindex t INNER JOIN RelProcedureTypeofVaccine r ON t.ProcedureUid = r.ProcedureUid AND t.TypeOfVaccineUid = r.TypeofVaccineUid

DELETE	r
FROM	RelProcedureTypeofVaccine r
WHERE	r.RelProcedureTypeofVaccineUid NOT IN (SELECT RelProcedureTypeofVaccineUid FROM @uniqueindex)
GO

-- Neil ListKdbConfiguration/ProviderDefaultSIG
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[temp_ListKdbConfiguration]') AND type in (N'U'))
begin
	declare @sql nvarchar(4000) =
	N'	INSERT		ListKdbConfiguration( KdbConfigurationUid, [Name] )
	SELECT		KdbConfigurationUid, [Name]
	FROM		temp_ListKdbConfiguration
	'
	exec (@sql)
end			
GO

-- #10358  NDD_Search     ListMedication.sql
--ALTER TABLE ListMedication ADD medid INT NOT NULL CONSTRAINT DF_ListMedication_medid DEFAULT(0)
--CREATE UNIQUE INDEX IX_ListMedication_MEDID on ListMedication(medid)
--EXEC sys.sp_addextendedproperty @name='Replication.EnsureExternalId', @value='1', @level0type='SCHEMA', @level0name='dbo', @level1type='TABLE', @level1name='ListMedication', @level2type='COLUMN', @level2name='medid'

-- Need this to run before the unique index is applied
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
   DECLARE @medid INT, @MedicationUid UNIQUEIDENTIFIER

   -- find the smallest current medid (should all be 0)
   SELECT @medid = MIN(med.medid) - 1 FROM ListMedication med
   IF (@medid IS NULL) SET @medid = -1

   DECLARE MedCursor CURSOR LOCAL FORWARD_ONLY FOR
   SELECT med.MedicationUid FROM ListMedication med WHERE med.medid = 0 ORDER BY Name

   OPEN MedCursor FETCH NEXT FROM MedCursor INTO @MedicationUid
   WHILE @@FETCH_STATUS = 0
   BEGIN
      UPDATE ListMedication
      SET
         medid             = @medid,
         LastModifiedDate  = DATEADD(MI, 10, med.LastModifiedDate)
      FROM ListMedication med
      WHERE med.MedicationUid = @MedicationUid

	  IF NOT EXISTS(SELECT * FROM SeedTable WHERE SeedName = 'ListMedication')
      BEGIN
	     INSERT INTO SeedTable(SeedName, SeedValue) VALUES('ListMedication', ABS(@medid))
	  END
      UPDATE SeedTable SET SeedValue = ABS(@medid), LastModifiedDate = GETUTCDATE() WHERE SeedName = 'ListMedication'
      FETCH NEXT FROM MedCursor INTO @MedicationUid
      SET @medid = @medid - 1
   END

   UPDATE sig
   SET
      FDB_MEDID        = med.medid,
      LastModifiedDate = DATEADD(MI, 10, sig.LastModifiedDate)
   FROM dbo.MedicationSIG sig
   INNER JOIN ListMedication med ON med.descdisplay = sig.DrugName
   WHERE sig.FDB_MEDID = 0
     AND sig.DrugName != ''
     AND ISNULL(sig.Strength, '') = ISNULL(med.Strength, '')
     AND ISNULL(sig.StrengthUnits, '') = ISNULL(med.StrengthUnits, '')
END
ELSE
BEGIN
   -- if the replication client has rows where medid has not been set, then clear the table
   IF EXISTS(SELECT * FROM ListMedication WHERE medid = 0)
   BEGIN
      TRUNCATE TABLE ListMedication
   END
END
GO
