SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewHMRule]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewHMRule]
AS
SELECT     HMRuleUid, ExternalID, Name, Inactive, Notes
FROM         dbo.ListHMRule




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]'))
EXEC dbo.sp_executesql @statement = N'







CREATE VIEW [dbo].[ViewPerson] WITH SCHEMABINDING AS
SELECT	P.PersonUid, Inactive, Prefix, FirstName, MiddleName, LastName, Suffix, AkaFirstName, AkaLastName,
    SocialSecurityNumber, Birthdate, Deathdate, DriverLicenseNumber,
    dbo.UDF_getFormattedName(Prefix, FirstName, MiddleName, LastName, Suffix) AS FullName,
    dbo.UDF_getFormattedInternalName(FirstName, MiddleName, LastName, AkaFirstName, AkaLastName) AS FormattedInternalName,
    dbo.UDF_getFormattedName(NULL, FirstName, MiddleName, LastName, Suffix) AS FormattedPreferredName,
    dbo.UDF_getFormattedName(NULL, ISNULL(AkaFirstName, FirstName), NULL, ISNULL(AkaLastName, LastName), NULL) AS AkaName,
    p.Address1, 
    p.Computed_Address1_Address1 AS Address1_Address1,
    p.Computed_Address1_Address2 AS Address1_Address2,
    p.Computed_Address1_City AS Address1_City,
    p.Computed_Address1_State AS Address1_State,
    p.Computed_Address1_Zip AS Address1_Zip,
    p.Phone1, 
    p.Computed_Phone1_PhoneNumber AS PhoneNumber1,
    p.Computed_Phone1_PhoneType AS PhoneType1,
    REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(p.Computed_Phone1_PhoneNumber, ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', '''') AS PhoneNumberScrubbed,
    p.Phone2, 
    p.Computed_Phone2_PhoneNumber AS PhoneNumber2,
    p.Computed_Phone2_PhoneType AS PhoneType2,
    p.Phone3, 
    p.Computed_Phone3_PhoneNumber AS PhoneNumber3,
    p.Computed_Phone3_PhoneType AS PhoneType3,
    p.Phone4,
    p.Computed_Phone4_PhoneNumber AS PhoneNumber4,
    p.Computed_Phone4_PhoneType AS PhoneType4,
    p.Email1,
    p.Email2,
    p.EmailDirect,
    p.PreferredContactMethod,
	p.Email1MessagingAllowed,
	p.Email2MessagingAllowed,
	p.Phone1MessagingAllowed,
	p.Phone2MessagingAllowed,
	p.Phone3MessagingAllowed,
	p.Phone4MessagingAllowed	
FROM	dbo.Person P            

/* Make sure indexes exist when you alter this view. If not recreate the indexes below
CREATE UNIQUE CLUSTERED INDEX IX_PersonUid ON ViewPerson(PersonUid)
CREATE INDEX IX_LastName ON ViewPerson(LastName)
CREATE INDEX IX_FirstName ON ViewPerson(FirstName)
CREATE INDEX IX_Name ON ViewPerson(FirstName, LastName)
CREATE INDEX IX_SSN ON ViewPerson(SocialSecurityNumber)
CREATE INDEX IX_DL ON ViewPerson(DriverLicenseNumber)
CREATE INDEX IX_Birthdate ON ViewPerson(BirthDate)
CREATE INDEX IX_Address1_Address1 ON ViewPerson(Address1_Address1)
CREATE INDEX IX_Address1_City ON ViewPerson(Address1_City)
CREATE INDEX IX_Address1_State ON ViewPerson(Address1_State)
CREATE INDEX IX_Address1_Zip ON ViewPerson(Address1_Zip)
CREATE INDEX IX_FormattedInternalName ON ViewPerson(FormattedInternalName)
CREATE INDEX IX_FormattedPreferredName ON ViewPerson(FormattedPreferredName)
CREATE INDEX IX_FullName ON ViewPerson(FullName)
*/





' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_PersonUid')
CREATE UNIQUE CLUSTERED INDEX [IX_PersonUid] ON [dbo].[ViewPerson]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewProvider]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewProvider] AS
SELECT			pe.PersonUid, pr.ExternalID, 
				pe.Prefix, pe.FirstName, pe.MiddleName, pe.LastName, pe.Suffix,
				pe.AkaFirstName, pe.AkaLastName,
				pr.Inactive, 
				pr.ClinicCenterUid, cc.Name AS ClinicCenter,
				(CASE WHEN u.PersonUid IS NULL THEN 0 ELSE 1 END) AS IsActiveUser, 
				pr.ProviderRoleID, pr.ProviderLicense, pr.FTE,
				pr.SpecialtyUid, ls.Name as Specialty, pr.ConsultingProvider,
				pe.Address1, pe.Address2,
				pe.Phone1, pe.Phone2, pe.Phone3, pe.Phone4,
				pr.Notes, PFN.FullName, PFN.FormattedInternalName,
				(CASE WHEN pr.AprimaDataExchangeProviderRegistrationUid IS NULL THEN 0 ELSE 1 END) AS IsAprimaDataExchangeProvider,
				pr.AprimaDataExchangeProviderRegistrationUid,
				pe.EmailDirect,
				pe.Email1, pe.Email2,
				ls.ANSICode as SpecialtyANSICode
FROM            Provider pr 
				INNER JOIN Person pe ON pr.PersonUid = pe.PersonUid 
				LEFT JOIN ListClinicCenter cc ON pr.ClinicCenterUid = cc.ClinicCenterUid 
                LEFT JOIN UserPRM u ON pr.PersonUid = u.PersonUid AND u.Inactive = 0
                LEFT JOIN ListSpecialty ls on pr.SpecialtyUid = ls.SpecialtyUid
                INNER JOIN ViewPerson (NOEXPAND) PFN ON PR.PersonUid = PFN.PersonUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientRecall]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewPatientRecall] AS
SELECT pr.PatientRecallUid, pr.PatientUid, pr.ProviderUid, pr.NotificationUserUid, pr.RecallTypeUid, pr.NotificationMethodUid, pr.AppointmentUid, pr.OriginVisitUid, pr.VisitUid, hmr.HMRuleUid, pc.PatientConditionUid,
	pr.CreateDateTime, 
	dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName, p.LastName, p.Suffix) AS PatientName,
	dbo.UDF_getFormattedName(p2.Prefix, p2.FirstName, p2.MiddleName, p2.LastName, p.Suffix) AS NotificationUserName,
	vp.FullName AS ProviderName, 
	rt.Name AS RecallType,
	pr.DateNotified, 
	pr.DateDue, 
	pr.DateSatisfied, 
	hmr.Name,
	hmr.Name as HMRule,

	CASE 
		when CHARINDEX(''phone'', p.PreferredContactMethod) > 0 then ''Phone''
		when CHARINDEX(''address'', p.PreferredContactMethod) > 0 then ''Address''
		when CHARINDEX(''email'', p.PreferredContactMethod) > 0 then ''Email''
		when CHARINDEX(''text'', p.PreferredContactMethod) > 0 then ''Text''
		When p.PreferredContactMethod IS NULL then ''''
		else p.PreferredContactMethod
	END AS PreferredContactMethod,

	nm.Name as ContactMethod,
	ISNULL(pw.PatientWebAccess,0) AS PatientWebAccess,
	pr.Notes,
	pr.LastModifiedByUid,
	pr.LastModifiedDate,
	pr.Inactive,

    p.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneType1, P.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS Phone1, 
    p.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneType2, P.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS Phone2, 
    p.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneType3, P.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS Phone3, 
    p.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneType4, P.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS Phone4, 
    P.Address1.value(''(/Address/Address1)[1]'', ''varchar(100)'') AS PrimaryAddress1,
    P.Address1.value(''(/Address/Address2)[1]'', ''varchar(100)'') AS PrimaryAddress2,
    P.Address1.value(''(/Address/City)[1]'', ''varchar(100)'') AS PrimaryCity,
    P.Address1.value(''(/Address/State)[1]'', ''varchar(100)'') AS PrimaryState,
    P.Address1.value(''(/Address/Zip)[1]'', ''varchar(100)'') AS PrimaryZip,                      
    P.Address2.value(''(/Address/Address1)[1]'', ''varchar(100)'') AS SecondaryAddress1,
    P.Address2.value(''(/Address/Address2)[1]'', ''varchar(100)'') AS SecondaryAddress2,
    P.Address2.value(''(/Address/City)[1]'', ''varchar(100)'') AS SecondaryCity,
    P.Address2.value(''(/Address/State)[1]'', ''varchar(100)'') AS SecondaryState,
    P.Address2.value(''(/Address/Zip)[1]'', ''varchar(100)'') AS SecondaryZip,
	p.Email1, p.Email2

FROM patientrecall AS pr
INNER JOIN person AS p ON p.PersonUid = pr.PatientUid
LEFT OUTER JOIN person as p2 on p2.PersonUid = pr.NotificationUserUid
left outer JOIN ViewProvider AS vp ON pr.ProviderUid = vp.PersonUid
inner JOIN ListRecallType AS rt ON rt.RecallTypeUid = pr.RecallTypeUid
LEFT OUTER JOIN PatientHMRule AS phmr ON phmr.PatientHMRuleUid = pr.PatientHMRuleUid
LEFT OUTER JOIN ViewHMRule AS hmr on hmr.HMRuleUid = phmr.HMRuleUid
left outer JOIN ListNotificationMethod AS nm on nm.NotificationMethodUid = pr.NotificationMethodUid
LEFT OUTER JOIN PersonWeb pw on pw.PersonUid = p.PersonUid
Left Outer Join Patient pat on pat.PersonUid = p.PersonUid
LEFT OUTER JOIN ListPatientCondition pc ON pc.PatientConditionUid = (Select Top 1 PatientConditionUid FROM RelPatientCondition WHERE PatientUid = pat.PersonUid ORDER BY DisplayOrder ASC)



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewBatchClosingsLockedClosed]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewBatchClosingsLockedClosed] 
AS
SELECT ArBatchUid, Name AS ArBatchName, GlDate, IsLocked, IsClosed 
      FROM ARBatch
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_PayerCreditDistributionDeposit]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[MDOL_RPT2_View_PayerCreditDistributionDeposit]  
AS 
/*
	BMR 20120724 - Changed to remove AR_ViewLedger
*/
SELECT L.LedgerUid,PC.DepositUid    
	FROM AR_LedgerDetail LD
		INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
		INNER JOIN AR_PayerCredit PC ON LD.PayerCreditUid = PC.PayerCreditUid
	WHERE L.EntryType =2 and LD.PayerCreditUid is not null

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewDepositDate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewDepositDate]
AS 
SELECT LD.DepositUid, L.EntryDate AS DepositDate 
	FROM AR_LedgerDetail LD
		INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
	WHERE L.EntryType =0 
		AND L.VoidLedgerUid IS NULL 
		AND LD.PayerCreditUid IS NULL --AND DepositUid IS NOT NULL
		AND LD.IsCredit =1

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureBatchSub]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewSuperbillProcedureBatchSub] WITH SCHEMABINDING    
 AS    
 SELECT SBP.SuperbillUid, SBP.SuperbillProcedureUid,  L.ArBatchUid, ARB.Name AS ArBatchName, 
			ARB.GLDate AS ArBatchPostingDate, L.CreatedDateTime, LD.LedgerDetailUid   
	 FROM dbo.AR_Ledger L  
		INNER JOIN dbo.AR_LedgerDetail LD ON L.LedgerUid = LD.LedgerUid  
		INNER JOIN dbo.SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid 
		INNER JOIN dbo.ARBatch ARB ON L.ArBatchUid = ARB.ARBatchUid  
	 WHERE L.EntryType = 1 -- charge  AND LD.IsCredit = 0             

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewSuperbillProcedureBatchSub ON AR_ViewSuperbillProcedureBatchSub(SuperbillProcedureUid, CreatedDateTime, ArBatchUid, ArBatchName, ArBatchPostingDate, SuperbillUid, LedgerDetailUid)
CREATE INDEX PK_AR_ViewSuperbillProcedureBatchSub_SuperbillUid ON AR_ViewSuperbillProcedureBatchSub(SuperbillUid, ArBatchPostingDate)

*/

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureBatchSub]') AND name = N'PK_AR_ViewSuperbillProcedureBatchSub')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewSuperbillProcedureBatchSub] ON [dbo].[AR_ViewSuperbillProcedureBatchSub]
(
	[SuperbillProcedureUid] ASC,
	[CreatedDateTime] ASC,
	[ArBatchUid] ASC,
	[ArBatchName] ASC,
	[ArBatchPostingDate] ASC,
	[SuperbillUid] ASC,
	[LedgerDetailUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureBatch]'))
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[AR_ViewSuperbillProcedureBatch]   
AS  
WITH cteRankedBatchInfo AS
(
	SELECT DISTINCT SuperbillUid, SuperbillProcedureUid, ArBatchUid, ArBatchName, ArBatchPostingDate,
			ROW_NUMBER() OVER (PARTITION BY SuperbillProcedureUid ORDER BY CreatedDateTime DESC) AS Rank    
		  FROM AR_ViewSuperbillProcedureBatchSub WITH (NOEXPAND, NOLOCK)
		  
)
SELECT SuperbillUid, SuperbillProcedureUid, ArBatchUid, ArBatchName, ArBatchPostingDate
	FROM cteRankedBatchInfo VSBS  
	WHERE VSBS.Rank = 1  







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillProcedureSub]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewSuperbillProcedureSub] WITH SCHEMABINDING 
AS
SELECT     SBP.SuperbillProcedureUid, LP.Code, SBP.SuperbillUid, SB.ExternalID AS SuperbillExternalId, SB.SuperbillStatusUid,
						SB.ServiceDateStart, SB.ServiceDateEnd, SB.VisitUid, SB.ClaimPaper, SB.ABN,
						SBP.DisplayOrder, SBP.ProcedureUid, 
						SBP.Inactive, SBP.ProcedureCharge, SBP.Units, SBP.ProcedureAllowed, SBP.InsurancePercent, SBP.FixedCopayAmount,
						SBP.TotalTax, SBP.TotalAllowed, 
						SBP.ProcedureServiceDateStart, SBP.ProcedureServiceDateEnd, SBP.DiagnosisPointer1, SBP.DiagnosisPointer2, SBP.DiagnosisPointer3, 
						SBP.DiagnosisPointer4, SBP.DiagnosisPointer5, SBP.DiagnosisPointer6, SBP.DiagnosisPointer7, SBP.DiagnosisPointer8, 
						SBP.DontClaim, SBP.LastModifiedDate, 
						SBP.LastModifiedByUid, AC.AccountUid, AC.AccountResponsiblePartyUid, AC.PersonUid, CAST(0 as bit) as IsModified, -- TODO: Remove IsModified
						SBA.FirstFiledDate, SBA.LastFiledDate, SBA.IsPosted, SBA.CodeValidationErrors,
						LSS.Name AS SuperbillStatusName,
						P.Prefix AS PatientPrefix, P.FirstName AS PatientFirstName, P.MiddleName AS PatientMiddleName, P.LastName AS PatientLastName, 
						P.Suffix AS PatientSuffix, SBA.PrimaryInsurancePlanUid, SBA.LastPatientPaymentDate, SBA.LastPatientPaymentAmount, SBA.LastInsurancePaymentCarrierUid,
						SBA.LastInsurancePaymentAmount, SBA.LastInsurancePaymentDate, SB.ReferringProviderUid
FROM         dbo.SuperbillProcedure AS SBP 
				INNER JOIN dbo.SuperbillAggregate SBA ON SBP.SuperbillUid = SBA.SuperbillUid
				INNER JOIN dbo.Superbill AS SB ON SBP.SuperbillUid = SB.SuperbillUid 
					INNER JOIN dbo.Account AS AC ON SB.AccountUid = AC.AccountUid
						INNER JOIN dbo.Person P ON AC.PersonUid = P.PersonUid
					INNER JOIN dbo.ListSuperbillStatus LSS ON SB.SuperbillStatusUid = LSS.SuperbillStatusUid
                INNER JOIN dbo.ListProcedure AS LP ON SBP.ProcedureUid = LP.ProcedureUid

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_ViewSuperbillProcedureSub ON ViewSuperbillProcedureSub(SuperbillProcedureUid)

*/

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillProcedureSub]') AND name = N'PK_ViewSuperbillProcedureSub')
CREATE UNIQUE CLUSTERED INDEX [PK_ViewSuperbillProcedureSub] ON [dbo].[ViewSuperbillProcedureSub]
(
	[SuperbillProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillProcedure]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbillProcedure]
AS
SELECT SBP.*, V.VisitDate, V.IsCompleted AS VisitIsCompleted,
		SA.RenderingProviderUid, SA.ClaimingProviderUid, SA.ServiceSiteUid, SA.FinancialCenterUid,
		dbo.UDF_getFormattedName(sbp.PatientPrefix, sbp.PatientFirstName, sbp.PatientMiddleName , sbp.PatientLastName, sbp.PatientSuffix) as PatientFormattedName, 
		CLAIMER.FirstName AS ClaimerFirstName, CLAIMER.MiddleName AS ClaimerMiddleName , CLAIMER.LastName AS ClaimerLastName, 
			CLAIMER.AkaFirstName AS ClaimerAkaFirstName, CLAIMER.AkaLastName AS ClaimerAkaLastName,
		RENDERER.FirstName AS RendererFirstName, RENDERER.MiddleName AS RendererMiddleName , RENDERER.LastName AS RendererLastName, 
			RENDERER.AkaFirstName AS RendererAkaFirstName, RENDERER.AkaLastName AS RendererAkaLastName,
		RENDERERNS.FormattedInternalName AS RenderingProviderFormattedInternalName,   
		CLAIMERNS.FormattedInternalName AS ClaimingProviderFormattedInternalName,
		REFERERNS.FormattedInternalName AS ReferringProviderFormattedInternalName, -- UI Only
		FC.Name AS FinancialCenterName, LSS.Name AS ServiceSiteName, 
              (SELECT MAX(ArbatchPostingDate) FROM AR_ViewSuperbillProcedureBatchSub (NOEXPAND) WHERE SuperbillUid = SBP.SuperbillUid) AS MaxPostingDate,
              (SELECT MIN(ArbatchPostingDate) FROM AR_ViewSuperbillProcedureBatchSub (NOEXPAND) WHERE SuperbillUid = SBP.SuperbillUid) AS MinPostingDate,
		SA.CurrentCarrier as InsuranceOrder, ISNULL(ILN.InsuranceLevelName,'''') AS InsuranceLevelName,
		dbo.GetModifierForSuperbillProcedure(sbp.SuperbillProcedureUid) AS Modifiers, SBPB.ArBatchUid, SBPB.ArBatchName,
		dbo.GetDiagnosisCodeList(SBP.SuperbillProcedureUid) AS Diagnoses,
		(SELECT COUNT(SuperbillProcedureUid) FROM SuperbillProcedure WITH (NOLOCK) WHERE Inactive = 0 AND SuperbillUid = SBP.SuperbillUid) AS SuperbillProcedureCount
	FROM  ViewSuperbillProcedureSub (NOEXPAND) AS SBP 
		LEFT JOIN AR_ViewSuperbillProcedureBatch SBPB on SBP.SuperbillProcedureUid = SBPB.SuperbillProcedureUid
		INNER JOIN SuperbillAggregate SA ON SBP.superbillUid = SA.SuperbillUid
		LEFT JOIN ListInsuranceLevelName ILN ON SA.CurrentCarrier = ILN.InsuranceLevel
		LEFT JOIN Visit v on SBP.VisitUid = v.VisitUid
			LEFT JOIN Person RENDERER on SA.RenderingProviderUid = RENDERER.PersonUid 
				LEFT JOIN ViewPerson (NOEXPAND) RENDERERNS on SA.RenderingProviderUid = RENDERERNS.PersonUid 
			LEFT JOIN Person CLAIMER on SA.ClaimingProviderUid = CLAIMER.PersonUid 
				LEFT JOIN ViewPerson (NOEXPAND) CLAIMERNS on SA.ClaimingProviderUid = CLAIMERNS.PersonUid   
			LEFT JOIN ViewPerson (NOEXPAND) REFERERNS on SBP.ReferringProviderUid = REFERERNS.PersonUid  -- UI Only
			LEFT JOIN ListServiceSite LSS on SA.ServiceSiteUid = LSS.ServiceSiteUid
			LEFT JOIN FinancialCenter FC on SA.FinancialCenterUid = FC.FinancialCenterUid







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewProcedureProductivityByPayments]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewProcedureProductivityByPayments]
AS 
-- May 2 2008 Deposit Date is added
SELECT  COALESCE(S.SuperbillUid,''10000000-0000-0000-0000-000000000000'') as SuperbillUid, NULL ARContextUid,LD.RenderingProviderUid as RenderingProviderUid, 
                      RP.LastName + '', ''+ RP.FirstName  AS RenderingProvider,
					  LD.ClaimingProviderUid  as  ClaimingProviderUid, CP.LastName + '', ''+ CP.FirstName   AS  ClaimingProvider, dbo.ListServiceSite.ServiceSiteUid, 
                      dbo.ListServiceSite.Name AS ServiceSite, -1 * LD.Amount  AS TotalPayment, 
                      COALESCE (dbo.ListProcedureGroup.ProcedureGroupUid, ''10000000-0000-0000-0000-000000000000'') AS ProcedureGroupUid, 
                      COALESCE (dbo.ListProcedureGroup.Name, ''Unassigned'') AS ProcedureGroup, dbo.ListProcedure.Code  AS CPTCode, 
                      dbo.ListProcedure.ShortDescription  AS Description, S.ServiceDateStart, S.ServiceDateEnd, dbo.ARBatch.GLDate, 
                      LD.FinancialCenterUid, LD.RenderingProviderUid AS ProviderUid,ISNULL(D.DepositDate,D1.DepositDate) AS DepositDate,
                      S.PatientUid AS PatientUid, dbo.ListProcedure.ProcedureUid AS ProcedureUid,
                      CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed,
                      S.ExternalID as SuperbillNumber,PE .LastName + '', ''+ PE.FirstName  AS PatientName,
                       --dbo.Convertdateonly(ARBatch.GLDate) as ProcedurePostingDate,
                      SPB.minPostingDate as ProcedurePostingDate
FROM
	dbo.AR_Ledger  L 
INNER JOIN
	dbo.AR_LedgerDetail LD
ON
	L.LedgerUid = LD.LedgerUid AND (L.EntryType=2) --AND LD.IsCredit = 1
INNER JOIN 
	dbo.SuperbillProcedure SP  
ON 
	SP.SuperbillProcedureUid = LD.SuperbillProcedureUid 
INNER JOIN 
	dbo.ViewSuperbillprocedure SPB  
ON 
	SP.SuperbillProcedureUid = SPB.SuperbillProcedureUid
INNER JOIN 
	dbo.Superbill S  
ON 
	S.SuperbillUid = SP.SuperbillUid 
INNER JOIN
	dbo.ARBatch 
ON	
	ARBatch.ARBatchUID=L.ARBatchUid --VS.ARBatchUID
INNER JOIN 
	AR_ViewBatchClosingsLockedClosed VARB 
ON 
	L.ArBatchUid =VARB.ARBatchUid	 
INNER JOIN
    dbo.ListServiceSite ON dbo.ListServiceSite.ServiceSiteUid = LD.ServiceSiteUid 
LEFT JOIN
    dbo.ListProcedure ON SP.ProcedureUid = dbo.ListProcedure.ProcedureUid --AND dbo.ListProcedure.Inactive=0 
LEFT JOIN
    dbo.ListProcedureGroup ON dbo.ListProcedure.ProcedureGroupUid = dbo.ListProcedureGroup.ProcedureGroupUid
LEFT JOIN 
	AR_Transaction T
ON
	T.TransactionUid=L.TransactionUid 
LEFT JOIN
	[MDOL_RPT2_View_PayerCreditDistributionDeposit] PCD
ON
	PCD.LedgerUid =L.LedgerUid 		
LEFT JOIN
	[ViewDepositDate] D
ON
	(D.DepositUid =T.DepositUid)  --OR (T.DepositUid IS NULL AND PCD.DepositUid =D.DepositUid))
LEFT JOIN
	[ViewDepositDate] D1
ON
	T.DepositUid IS NULL AND PCD.DepositUid =D1.DepositUid 	
INNER JOIN
    Person CP
ON
	CP.PersonUid = LD.ClaimingProviderUid 
INNER JOIN
    Person RP
ON
	RP.PersonUid = LD.RenderingProviderUid  
INNER JOIN
    Person PE
ON
	PE.PersonUid = S.PatientUid 







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_PayerCreditCandidate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_PayerCreditCandidate] AS
   SELECT
      PrimaryUid              = CASE
                                   WHEN ard.InsurancePlanUid IS NOT NULL THEN ard.InsurancePlanUid
                                   WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ins.InsuranceCarrierUid
                                   ELSE acc.AccountResponsiblePartyUid
                                END,
      PayerUid                = CASE
                                   WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ins.InsuranceCarrierUid
                                   ELSE acc.AccountResponsiblePartyUid
                                END,
      PayerType               = CASE
                                   WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ''Insurance Payer''
                                   ELSE ''Acount Responsible Party''
                                END,
      PayerName               = CASE
                                   WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ins.Name
                                   ELSE vpn.FullName
                                END,
      LiabilityOwner          = ard.LiabilityOwner,
      InsurancePlanUid        = ard.InsurancePlanUid,                                
      SuperbillUid            = sbp.SuperbillUid,
      PayerBalance            = SUM(CASE WHEN arl.EntryType = 2 AND ard.IsCredit = 1 THEN ard.Amount ELSE 0 END) +
                                SUM(CASE WHEN (arl.EntryType = 1 AND ard.IsCredit = 0) OR (arl. EntryType = 3) OR (arl. EntryType = 4) THEN ard.Amount ELSE 0 END),
      PayerPaid               = SUM(CASE WHEN arl.EntryType = 2 AND ard.IsCredit = 1 THEN -ard.Amount ELSE 0 END),
      PayerOwed               = SUM(CASE WHEN (arl.EntryType = 1 AND ard.IsCredit = 0) OR (arl. EntryType = 3) OR (arl. EntryType = 4) THEN ard.Amount ELSE 0 END)
   FROM AR_LedgerDetail ard
   INNER JOIN AR_Ledger arl ON arl.LedgerUid = ard.LedgerUid
   INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = ard.SuperbillProcedureUid
   INNER JOIN Superbill sbx ON sbx.SuperbillUid = sbp.SuperbillUid
   INNER JOIN Account acc ON acc.AccountUid = sbx.AccountUid
   INNER JOIN AccountResponsibleParty arp ON arp.AccountResponsiblePartyUid = acc.AccountResponsiblePartyUid
   INNER JOIN Person per ON per.PersonUid = arp.PersonUid
   INNER JOIN ViewPerson (NOEXPAND) vpn ON vpn.PersonUid = per.PersonUid
   LEFT JOIN InsurancePlan ins ON ins.InsurancePlanUid = ard.InsurancePlanUid
   LEFT JOIN InsuranceCarrier inc ON inc.CorporationUid = ins.InsuranceCarrierUid
   GROUP BY ins.InsuranceCarrierUid, acc.AccountResponsiblePartyUid, ins.Name, vpn.FullName, ard.LiabilityOwner, ard.InsurancePlanUid, sbp.SuperbillUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindUserAndUserGroup]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW	[dbo].[ViewFindUserAndUserGroup] AS
SELECT		lug.UserGroupUId AS UId, lug.ExternalID, 
			CAST(NULL AS NVARCHAR(50)) as LoginID, 
			lug.Inactive, lug.Name, 
			lug.Name as LastName, CAST(NULL AS NVARCHAR(50)) AS FirstName, 
			CAST(NULL AS NVARCHAR(50)) AS MiddleName,
			CAST(NULL AS NVARCHAR(50)) AS AkaFirstName,
			CAST(NULL AS NVARCHAR(50)) AS AkaLastName,
			lug.Notes, 2 AS ForeignKeyIndex, ''Group'' AS [UserGroupType], 
			CASE WHEN lug.UserGroupTypeUid = ''10101010-0000-0000-0000-000000000001'' THEN 1 ELSE 0 END AS IsCareTeamGroupOrProvider
FROM		dbo.ListUserGroup lug
UNION ALL
SELECT		u.PersonUId AS UId, COALESCE(u.ExternalID, u.Login) AS ExternalID, 
			u.Login as LoginID, u.Inactive, 
			p.FormattedInternalName AS Name,
			p.LastName, p.FirstName, p.MiddleName, p.AkaFirstName, p.AkaLastname,
			per.[Notes], 1 AS ForeignKeyIndex, ''User'' AS [UserGroupType], 
			CASE WHEN prov.PersonUid IS NULL THEN 0 ELSE 1 END AS IsCareTeamGroupOrProvider
FROM        dbo.UserPRM u 
			INNER JOIN dbo.ViewPerson p (NOEXPAND) ON u.PersonUId = p.PersonUId 
			INNER JOIN [dbo].[Person] AS per ON p.[PersonUid] = per.[PersonUid]
			LEFT JOIN Provider prov ON u.PersonUid = prov.PersonUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCorporation]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewCorporation] WITH SCHEMABINDING AS
SELECT	c.CorporationUid, c.ExternalID, 
		c.Name, 
		c.[Address] AS [Address],
        c.Computed_Address_Address1 AS Address1,
        c.Computed_Address_Address2 AS Address2,
        c.Computed_Address_City AS City,
        c.Computed_Address_State AS [State],
        c.Computed_Address_Zip AS Zip,        
		c.[Phone1],
        c.Computed_Phone1_PhoneNumber AS PhoneNumber,
        c.Computed_Phone1_PhoneType AS PhoneType,
		REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(c.Computed_Phone1_PhoneNumber, ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', '''') AS PhoneNumberScrubbed,
		c.Inactive,
		c.Internal,
		c.CorpNotes
FROM    dbo.Corporation AS c 

/*
CREATE UNIQUE CLUSTERED INDEX IX_CorporationUid ON ViewCorporation(CorporationUid)
CREATE INDEX IX_Name ON ViewCorporation(Name)
CREATE INDEX IX_Address1 ON ViewCorporation(Address1)
CREATE INDEX IX_City ON ViewCorporation(City)
CREATE INDEX IX_State ON ViewCorporation(State)
CREATE INDEX IX_Zip ON ViewCorporation(Zip)
*/


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindEmployer]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewFindEmployer] AS
	SELECT	c.*,
			e.Notes
	FROM	ViewCorporation c LEFT JOIN Employer e ON c.CorporationUid = e.CorporationUid
	WHERE	c.Internal = 0
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewDepositAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewDepositAggregateSub] WITH SCHEMABINDING
AS
	SELECT LD.DepositUid, 
			SUM(CASE WHEN LD.IsCredit = 0 THEN 0 ELSE LD.AMOUNT*-1 END) As Receipt, 
			SUM(LD.Amount*-1) As ReceiptBalance,
			COUNT_BIG(*) AS COUNT
		FROM dbo.AR_LedgerDetail LD 
		WHERE NOT LD.DepositUid IS NULL
		GROUP BY LD.DepositUid

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewDepositAggregateSub_DepositUid ON AR_ViewDepositAggregateSub(DepositUid)

*/



' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewDepositAggregateSub]') AND name = N'PK_AR_ViewDepositAggregateSub_DepositUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewDepositAggregateSub_DepositUid] ON [dbo].[AR_ViewDepositAggregateSub]
(
	[DepositUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewDepositAggregate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewDepositAggregate] 
AS
SELECT DP.DepositUid, 
	ISNULL(VDAS.Receipt, 0) AS Receipt, 
	ISNULL(VDAS.ReceiptBalance, 0) AS ReceiptBalance
FROM Deposit DP
	LEFT JOIN AR_ViewDepositAggregateSub VDAS WITH (NOEXPAND)  ON DP.DepositUid = VDAS.DepositUid 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAge]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[AR_ViewSuperbillProcedureAge] --WITH SCHEMABINDING    
AS   
select   
 LD.SuperbillProcedureUid,  
 LD.LiabilityOwner,   
 DATEDIFF(DD, MAX(ARB.GLDate), GETDATE()) Age   
From  
dbo.AR_Ledger  L   
JOIN   
 dbo.AR_LedgerDetail LD    
ON    
 L.LedgerUid=LD.LedgerUid  AND (L.EntryType=1 OR L.EntryType =4) 
JOIN    
 dbo.ARBatch   ARB  
ON    
 L.ArBatchUid = ARB.ARBatchUid    
GROUP BY  
  LD.SuperbillProcedureUid,LD.LiabilityOwner   
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'



/* 09/05/2014 - kculberth - added NOLOCKs to prevent statements from causing deadlocks  */
CREATE VIEW [dbo].[AR_ViewSuperbillProcedureAggregateSub] WITH SCHEMABINDING
AS  
SELECT PE.PersonUid, AC.AccountUid, SB.SuperbillUid, SBP.SuperbillProcedureUid,           
            SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.AMOUNT ELSE 0 END) As Liability,         
            SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) AND NOT LD.LiabilityOwner IS NULL AND LD.LiabilityOwner > 0 THEN LD.AMOUNT ELSE 0 END) As AssignedLiability,        
            SUM(CASE WHEN L.EntryType = 2 THEN LD.AMOUNT*-1 ELSE 0 END) As Distribution,        
            SUM(CASE WHEN L.EntryType = 2 AND NOT LD.LiabilityOwner IS NULL AND LD.LiabilityOwner > 0  THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedDistribution,        
            SUM(CASE WHEN L.EntryType = 3 THEN LD.AMOUNT*-1 ELSE 0 END) As Adjustment,        
            SUM(CASE WHEN L.EntryType = 3 AND NOT LD.LiabilityOwner IS NULL AND LD.LiabilityOwner > 0 THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedAdjustment,        
            SUM(LD.Amount) As LiabilityBalance,         
            SUM(CASE WHEN NOT LD.LiabilityOwner IS NULL AND LD.LiabilityOwner > 0 THEN LD.Amount ELSE 0 END) As AssignedLiabilityBalance,  
			SUM(CASE WHEN  LD.LiabilityOwner = 1 THEN LD.AMOUNT ELSE 0 END) As AssignedPrimaryLiabilityBalance,  
			SUM(CASE WHEN  LD.LiabilityOwner = 2 THEN LD.AMOUNT ELSE 0 END) As AssignedSecondaryLiabilityBalance,
			SUM(CASE WHEN  LD.LiabilityOwner = 3 THEN LD.AMOUNT ELSE 0 END) As AssignedTertiaryLiabilityBalance,
			SUM(CASE WHEN  LD.LiabilityOwner = 4 THEN LD.AMOUNT ELSE 0 END) As AssignedQuaternaryLiabilityBalance,        
            COUNT_BIG(*) AS Count  
      FROM dbo.AR_LedgerDetail (NOLOCK) LD  
            INNER JOIN dbo.AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
            INNER JOIN dbo.SuperbillProcedure (NOLOCK) SBP  ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
            INNER JOIN dbo.Superbill (NOLOCK) SB  ON SBP.SuperbillUid = SB.SuperbillUid
            INNER JOIN dbo.Account (NOLOCK) AC  ON SB.AccountUid = AC.AccountUid
            INNER JOIN dbo.Person (NOLOCK) PE ON AC.PersonUid = PE.PersonUid
      WHERE NOT LD.SuperbillProcedureUid IS NULL   
      GROUP BY PE.PersonUid, AC.AccountUid, SB.SuperbillUid, SBP.SuperbillProcedureUid     

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewSuperbillProcedureAggregateSub_SuperbillProcedureUid ON AR_ViewSuperbillProcedureAggregateSub(SuperbillProcedureUid)
CREATE INDEX IX_AR_ViewSuperbillProcedureAggregateSub_AccountUid ON AR_ViewSuperbillProcedureAggregateSub(AccountUid) INCLUDE(Liability, AssignedLiability, LiabilityBalance, AssignedLiabilityBalance)
CREATE INDEX IX_AR_ViewSuperbillProcedureAggregateSub_PersonUid ON AR_ViewSuperbillProcedureAggregateSub(PersonUid) INCLUDE(Liability, AssignedLiability, LiabilityBalance, AssignedLiabilityBalance)
CREATE INDEX IX_AR_ViewSuperbillProcedureAggregateSub_SuperbillUid ON AR_ViewSuperbillProcedureAggregateSub(SuperbillUid) INCLUDE(Liability, LiabilityBalance, AssignedLiability, AssignedLiabilityBalance)


*/



' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregateSub]') AND name = N'PK_AR_ViewSuperbillProcedureAggregateSub_SuperbillProcedureUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewSuperbillProcedureAggregateSub_SuperbillProcedureUid] ON [dbo].[AR_ViewSuperbillProcedureAggregateSub]
(
	[SuperbillProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewSuperbillProcedureAggregate] 
AS
SELECT SBP.SuperbillProcedureUid, SBP.SuperbillUid,
	ISNULL(VSPAB.Liability, 0) AS Liability, 
	CAST(ISNULL(VSPAB.AssignedLiability, 0) AS MONEY) AS AssignedLiability,
	CAST(ISNULL(VSPAB.Distribution, 0) AS MONEY) AS Distribution, 
	CAST(ISNULL(VSPAB.AssignedDistribution, 0) AS MONEY) AS AssignedDistribution,
	CAST(ISNULL(VSPAB.Adjustment, 0) AS MONEY) AS Adjustment, 
	CAST(ISNULL(VSPAB.AssignedAdjustment, 0) AS MONEY) AS AssignedAdjustment, 
	ISNULL(VSPAB.LiabilityBalance, 0) AS LiabilityBalance, 
	CAST(ISNULL(VSPAB.AssignedLiabilityBalance, 0) AS MONEY) AS AssignedLiabilityBalance
FROM SuperbillProcedure(NOLOCK) SBP
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON SBP.SuperbillProcedureUid = VSPAB.SuperbillProcedureUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewTransactionAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewTransactionAggregateSub]
AS
	select	art.TransactionUid, 
			-- Payments and Charges are not part of a transaction 
			-- Distribution ( 4 types: 1) Insurance Payments 2) Patient Payments 3) Insurance Payer Credits 4) Patient Payer Credits
			SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) AS InsDistribution, -- Used by AR_LedgerDetail_SuperbillAggregate_Insert
            SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) AS PatientDistribution, -- Used by AR_LedgerDetail_SuperbillAggregate_Insert
			--SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as InsPaymentDistributions,  -- Total distributions from an insurance payment(deposit)
            --SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as PtPaymentDistributions, -- Total distributions from an patient payment(deposit)
			SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.PayerCreditUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as InsPayerCreditDistributions,  -- Total distributions from an insurance payer credit
            SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.PayerCreditUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as PtPayerCreditDistributions, -- Total distributions from an patient payer credit
            -- Adjustments ( 3 types: 1) Insurance Adjustments 2) Patient Adjustments
			SUM(CASE WHEN (arl.EntryType = 3 AND ldCredit.LiabilityOwner > 0) THEN ldDebit.Amount ELSE 0 END) as InsAdjustment,	
			SUM(CASE WHEN (arl.EntryType = 3 AND ldCredit.LiabilityOwner = 0) THEN ldDebit.Amount ELSE 0 END) as PatientAdjustment,
			-- Transfers ( 2 types: 1) Carrier to Carrier 2) Patient to Carrier ( or vice-versa )
			SUM(CASE WHEN (arl.EntryType = 4 AND lct.TransactionTypeUid = ''28A84E67-A2A0-48E4-93BA-EF49607EAD17'') -- Patient Transfer
					 THEN ldDebit.Amount ELSE 0 END) AS PatientTransfer,
			SUM(CASE WHEN (arl.EntryType = 4 AND lct.TransactionTypeUid = ''EE9A074D-5660-400C-9975-2F961A38D7B2'')  -- Carrier Transfer
					 THEN ldDebit.Amount ELSE 0 END) AS InsTransfer,
			-- Count of all distributions, adjustments, and transfers in this transaction
			COUNT_BIG(*) AS Count	
	from dbo.AR_Transaction art
			inner join dbo.AR_Ledger arl on art.TransactionUid = arl.TransactionUid
			inner join dbo.AR_LedgerDetail ldDebit on arl.LedgerUid = ldDebit.LedgerUid
													AND ldDebit.IsCredit = 0
			inner join dbo.AR_LedgerDetail ldCredit on arl.LedgerUid = ldCredit.LedgerUid
													AND ldCredit.IsCredit = 1
			inner join dbo.ListCreditType lct on ldDebit.IncomeAccountUid = lct.CreditTypeUid
			inner join dbo.ListMisc lm on lct.TransactionTypeUid = lm.MiscUid
	group by art.TransactionUid
	
--ALTER VIEW [dbo].[AR_ViewTransactionAggregateSub] 
--WITH SCHEMABINDING
--AS

-- Could NOT use the following indexed view because Credit side does not tell us if it is from a  deposit or payer credit
--select	art.TransactionUid,   
--		-- Payments ( entryType = 0 ) and Charges ( entryType = 1 ) are not part of transactions
--		SUM(CASE WHEN (arl.EntryType = 2 ) THEN -(ldCredit.Amount) ELSE 0 END) AS Distribution,
--		SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0) THEN -(ldCredit.Amount) ELSE 0 END) as PatientDistribution,
--		SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0) THEN -(ldCredit.Amount) ELSE 0 END) as InsDistribution,
--		SUM(CASE WHEN (arl.EntryType = 3 ) THEN -(ldCredit.Amount) ELSE 0 END) AS Adjustment,
--		SUM(CASE WHEN (arl.EntryType = 3 AND ldCredit.LiabilityOwner = 0) THEN -(ldCredit.Amount) ELSE 0 END) as PatientAdjustment,
--		SUM(CASE WHEN (arl.EntryType = 3 AND ldCredit.LiabilityOwner > 0) THEN -(ldCredit.Amount) ELSE 0 END) as InsAdjustment,	
--		SUM(CASE WHEN (arl.EntryType = 4 AND lct.TransactionTypeUid = ''28A84E67-A2A0-48E4-93BA-EF49607EAD17'') -- Patient Transfer
--			     THEN -(ldCredit.Amount) ELSE 0 END) AS PatientTransfer,
--		SUM(CASE WHEN (arl.EntryType = 4 AND lct.TransactionTypeUid = ''EE9A074D-5660-400C-9975-2F961A38D7B2'')  -- Carrier Transfer
--				 THEN -(ldCredit.Amount) ELSE 0 END) AS InsTransfer,
--		COUNT_BIG(*) AS Count	
--from dbo.AR_Transaction art
--		inner join dbo.AR_Ledger arl on art.TransactionUid = arl.TransactionUid
--		--inner join dbo.AR_LedgerDetail ldDebit on arl.LedgerUid = ldDebit.LedgerUid
--		--										AND ldDebit.IsCredit = 0
--		inner join dbo.AR_LedgerDetail ldCredit on arl.LedgerUid = ldCredit.LedgerUid
--												AND ldCredit.IsCredit = 1
--		inner join dbo.ListCreditType lct on ldCredit.IncomeAccountUid = lct.CreditTypeUid
--		--inner join dbo.ListMisc lm on lct.TransactionTypeUid = lm.MiscUid
--group by art.TransactionUid

---- Index for indexed view
--CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewTransactionAggregateSub_TransactionUid] ON [dbo].[AR_ViewTransactionAggregateSub] 
--(
--	[TransactionUid] ASC
--)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewDepositTransactionAggregate]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[AR_ViewDepositTransactionAggregate]
AS
select art.DepositUid, 
       SUM(vta.InsDistribution + vta.PatientDistribution) as Distribution,
       SUM(vta.PatientDistribution) as PatientDistribution,
       SUM(vta.InsDistribution) as InsDistribution,
       SUM(vta.InsAdjustment + vta.PatientAdjustment) as Adjustment,
       SUM(vta.PatientAdjustment) as PatientAdjustment,
       SUM(vta.InsAdjustment) as InsAdjustment,
       SUM(vta.PatientTransfer) as PatientTransfer,
       SUM(vta.InsTransfer) as InsTransfer
from AR_Transaction art
		inner join AR_ViewTransactionAggregateSub vta on art.TransactionUid = vta.TransactionUid
																			AND art.DepositUid IS NOT NULL
GROUP BY art.DepositUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewDeposit]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[ViewDeposit]
AS
SELECT
d.DepositUid,
d.AppointmentUid,
CASE WHEN arlVoid.LedgerUid IS NULL THEN 0 ELSE 1 END AS Void,
CAST((CASE WHEN VDA.Receipt > VDA.ReceiptBalance THEN 1 ELSE 0 END) as bit) AS Credited,
d.ReferenceNumber AS ReferenceNumber, -- use for search, otherwise cannot optimize when search by deposituid -- Bug 234721
ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumberForSpread, -- mark as <ND> so can hyperlink on null values
VDA.Receipt AS AmountInverse, -- new model this is already inversed
VDA.Receipt - VDA.ReceiptBalance AS AllocatedAmountInverse, -- new model this is already inversed
VDA.ReceiptBalance AS UnallocatedAmountInverse,
LD.AccountResponsiblePartyUid as WhoPaidPersonUid,
LD.InsurancePayerUid as WhoPaidInsuranceCarrierUid,
(CASE WHEN p.PersonUid          IS NOT NULL THEN dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName, p.LastName, p.Suffix)
       WHEN icArp.CorporationUid IS NOT NULL THEN icArp.Name
       WHEN LD.InsurancePayerUid IS NOT NULL THEN ic.Name     END) AS WhoPaidName,       
 L.EntryDate as DepositDate,
d.PaymentTypeUid,
lpt.Name AS PaymentTypeName,
d.DepositMacroUid,
ldm.Name AS DepositMacroName,
ldm.AppointmentRequired,
d.LastModifiedByUid,
dbo.UDF_getFormattedName(up.Prefix, up.FirstName, up.MiddleName, up.LastName, up.Suffix) AS LastModifiedByName,
d.Comment,
CAST((CASE WHEN isNull(VDA.ReceiptBalance,0) = 0 THEN 1 ELSE 0 END) as bit) as IsFullyAllocated,
VDA.Receipt - VDA.ReceiptBalance as TotalPayment,
(CASE WHEN LD.InsurancePayerUid IS NOT NULL THEN VDT.InsAdjustment ELSE VDT.PatientAdjustment END) AS TotalAdjustment,
ARB.ARBatchUid,
ARB.Name as ARBatchName,
ARB.GLDate as GLDate,
ARB.IsLocked as IsLocked,
ARB.IsClosed as IsClosed,
CASE WHEN ARB.IsClosed = 1 THEN ''Closed'' 
      WHEN ARB.IsLocked = 1 THEN ''Complete''
      ELSE ''Open'' END as BatchState,
 d.TargetFinancialCenterUid as TargetFinancialCenterUid,
 fc.Name as TargetFinancialCenterName
FROM Deposit d with(nolock)
                                INNER JOIN AR_LedgerDetail LD with(nolock) ON d.DepositUid = LD.DepositUid
                                INNER JOIN AR_Ledger L with(nolock) ON LD.LedgerUid = L.LedgerUid
                                INNER JOIN ARBatch ARB with(nolock) ON L.ArBatchUid = ARB.ArBatchUid
                                LEFT OUTER JOIN AR_Ledger arlVoid with(nolock) on L.LedgerUid = arlVoid.VoidLedgerUid            -- Checks for voiding entries                                                                                                           
                                INNER JOIN AR_ViewDepositAggregate VDA with(nolock) ON d.deposituid = vda.deposituid
                                LEFT JOIN AccountResponsibleParty arp with(nolock) on LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid                              
                                LEFT JOIN Person p with(nolock) ON arp.PersonUid = p.PersonUid 
                                LEFT JOIN Corporation icArp with(nolock) ON arp.CorporationUid = icArp.CorporationUid
                                LEFT JOIN Corporation ic with(nolock) ON ic.CorporationUid = LD.InsurancePayerUid 
                                LEFT JOIN ListPaymentType lpt with(nolock) ON lpt.PaymentTypeUid = d.PaymentTypeUid 
                                LEFT JOIN ListDepositMacro ldm with(nolock) ON ldm.DepositMacroUid = d.DepositMacroUid 
                                LEFT JOIN Person up with(nolock) ON up.PersonUid = d.LastModifiedByUid
                                LEFT JOIN AR_ViewDepositTransactionAggregate VDT  with(nolock) ON d.DepositUid = VDT.depositUid
								LEFT JOIN FinancialCenter fc with(nolock) ON d.TargetFinancialCenterUid = fc.FinancialCenterUid
WHERE L.EntryType = 0 -- Payment
                                                AND L.VoidLedgerUid IS NULL     -- Don''t include reversing(void) entries
                   AND LD.IsCredit = 1                                                                                                                        
                                                AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_ResponsiblePartyARSummary]'))
EXEC dbo.sp_executesql @statement = N'
/*Pancratius 12/30/2013 Removed current date conversion function  from all date columns*/


CREATE VIEW [dbo].[MDOL_RPT2_View_ResponsiblePartyARSummary]  
AS  
SELECT
			B.AccountResponsiblePartyUID,  
			B.ResponsiblePartyName,  
			B.VisitDate,  
			B.LiabilityOwner,  
			B.PatientLastPaymentDate,  
			B.InsuranceLastPaymentDate,  
			B.age,  
			B.FinancialCenterUID,  
			B.ClaimingProviderUID,  
			B.RenderingProviderUID,  
			B.BillingProvider,  
			RenderingProvider,  
			B.SuperbillUid,
			B.SuperbillProcedureUid,
			(CASE WHEN B.Type=''Patient'' THEN 
				(SELECT SUM(CASE WHEN LD2.Amount<0 THEN -1 * (ISNULL(VD2.ReceiptBalance,0)) ELSE (ISNULL(VD2.ReceiptBalance,0)) END)
				FROM   
					ViewDeposit D2 with (NOLOCK)   
				INNER JOIN  
					AR_ViewDepositAggregate VD2 with (NOLOCK)  
				ON  
					D2.DepositUid =VD2.DepositUid   
				INNER JOIN  
					AR_Transaction T2 with (NOLOCK)  
				ON  
					D2.DepositUid =T2.DepositUid  AND D2.WhoPaidPersonUid IS NOT NULL   
				INNER JOIN  
					AR_Ledger L2 with (NOLOCK)  
				ON  
					T2.TransactionUid = L2.TransactionUid AND L2.EntryType=2  
				INNER JOIN   
					AR_LedgerDetail LD2 with (NOLOCK)  
				ON  
					L2.LedgerUid =LD2.LedgerUid   
				WHERE  
					LD2.SuperbillProcedureUid=B.SuperbillProcedureUid
				--GROUP BY LD2.Amount
				) 
			ELSE
				0
			END)AS PatientUnAllocated,
			
			(CASE WHEN B.Type=''Insurance'' THEN 
				(SELECT SUM(CASE WHEN LD2.Amount<0 THEN -1 * (ISNULL(VD2.ReceiptBalance,0)) ELSE (ISNULL(VD2.ReceiptBalance,0)) END)
				FROM   
					ViewDeposit D2 with (NOLOCK)   
				INNER JOIN  
					AR_ViewDepositAggregate VD2 with (NOLOCK)  
				ON  
					D2.DepositUid =VD2.DepositUid   
				INNER JOIN  
					AR_Transaction T2 with (NOLOCK)  
				ON  
					D2.DepositUid =T2.DepositUid  AND D2.WhoPaidPersonUid IS  NULL   
				INNER JOIN  
					AR_Ledger L2 with (NOLOCK)  
				ON  
					T2.TransactionUid = L2.TransactionUid AND L2.EntryType=2  
				INNER JOIN   
					AR_LedgerDetail LD2 with (NOLOCK)  
				ON  
					L2.LedgerUid =LD2.LedgerUid   
				WHERE  
					LD2.SuperbillProcedureUid=B.SuperbillProcedureUid
				--GROUP BY LD2.Amount
				) 
			ELSE
				0
			END)AS InsuranceUnAllocated,
		    (CASE WHEN B.Type=''Patient'' THEN	
				ISNULL(VSP.LiabilityBalance - VSP.AssignedLiabilityBalance,0) 
			 ELSE 
				0
			 END) AS PatientBalanceDue,    
			(CASE WHEN B.Type=''Insurance'' THEN	
				ISNULL(VSP.AssignedLiabilityBalance,0) 
			 ELSE 
				0 
			 END) AS InsuranceBalanceDue,
			 B.IsBatchClosed    
			
FROM
(
	SELECT
			A.AccountUid AS AccountUid,
			A.AccountResponsiblePartyUID AS AccountResponsiblePartyUID,  
			A.ResponsiblePartyName AS ResponsiblePartyName,  
			A.VisitDate AS VisitDate,  
			A.LiabilityOwner AS LiabilityOwner, 
			(SELECT MAX(D1.DepositDate)   
			FROM  
				Deposit D1 with (NOLOCK)  
			INNER JOIN   
				AR_Transaction T1 with (NOLOCK)  
			ON   
				D1.DepositUid =T1.DepositUid  AND D1.WhoPaidPersonUid IS NOT NULL  
			INNER JOIN   
				Superbill S1 with (NOLOCK)  
			ON  
				S1.SuperbillUid = T1.SuperbillUid   
			WHERE
				S1.AccountUID = A.AccountUID  
			) AS PatientLastPaymentDate,  
			NULL  AS InsuranceLastPaymentDate,   
			MAX(A.age) AS age,  
			A.FinancialCenterUID AS FinancialCenterUID,  
			A.ClaimingProviderUID AS ClaimingProviderUID,  
			A.RenderingProviderUID AS RenderingProviderUID,  
			A.BillingProvider AS BillingProvider,  
			A.RenderingProvider AS RenderingProvider,  
			A.SuperbillUid AS SuperbillUid,
			A.SuperbillProcedureUid AS SuperbillProcedureUid,
			A.Type AS Type,
			MIN(A.IsBatchClosed) AS IsBatchClosed
	FROM
	(
		SELECT  
			A.AccountUid AS AccountUid,
			ARP.AccountResponsiblePartyUID AS AccountResponsiblePartyUID,  
			(CASE     
			WHEN ARP.PersonUid IS NOT NULL    
			THEN [dbo].[UDF_getFormattedPreferredNameFromValues]  
			(  
			P.FirstName,  
			P.LastName,  
			P.MiddleName,  
			P.Suffix  
			)  
			WHEN ARP.CorporationUid IS NOT NULL    
			THEN CO.Name    
			END) AS ResponsiblePartyName,  
			ISNULL((V.VisitDate),S.ServiceDateStart ) AS VisitDate,  
			LD.LiabilityOwner AS LiabilityOwner,  
			--DATEDIFF(DAY, ARB.GLDate, GETUTCDATE()) AS age,  
			VSA.Age AS age, 
			LD.FinancialCenterUID AS FinancialCenterUID,  
			COALESCE(LD.ClaimingProviderUID,LD.RenderingProviderUid,''00000000-0000-0000-0000-000000000000'') AS ClaimingProviderUID,  
			LD.RenderingProviderUID AS RenderingProviderUID,  
			(CASE WHEN LD.ClaimingProviderUID IS NULL THEN ISNULL(dbo.UDF_getFormattedPreferredNameFromValues(RP.FirstName,RP.LastName,RP.MiddleName,RP.Suffix),''-'') ELSE ISNULL(dbo.UDF_getFormattedPreferredNameFromValues(CP.FirstName,CP.LastName,CP.MiddleName,CP.Suffix),''-'') END) AS BillingProvider,  
			ISNULL(dbo.UDF_getFormattedPreferredNameFromValues(RP.FirstName,RP.LastName,RP.MiddleName,RP.Suffix),''-'') AS RenderingProvider,  
			S.SuperbillUid AS SuperbillUid,
			SP.SuperbillProcedureUid AS SuperbillProcedureUid,
			''Patient'' AS Type,
			CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed
		FROM  
			Account A with (NOLOCK)  
		LEFT JOIN  
			AccountResponsibleParty ARP with (NOLOCK)   
		ON   
			A.AccountResponsiblePartyUID = ARP.AccountResponsiblePartyUID  
		LEFT JOIN    
			Person P with (NOLOCK)     
		ON    
			ARP.PersonUID = P.PersonUID  
		LEFT JOIN  
			Corporation CO with (NOLOCK)   
		ON    
			CO.CorporationUID=ARP.CorporationUID   
		INNER JOIN   
			Superbill S with (NOLOCK)   
		ON  
			S.AccountUid = A.AccountUid   
		INNER JOIN  
			SuperbillProcedure SP with (NOLOCK)   
		ON  
			S.SuperbillUid  = SP.SuperbillUid      
		INNER JOIN  
			AR_LedgerDetail LD with (NOLOCK)    
		ON  
			LD.SuperbillProcedureUid = SP.SuperbillProcedureUid   
		INNER JOIN  
			AR_Ledger L with (NOLOCK)  
		ON  
			L.LedgerUid = LD.LedgerUid  AND (L.EntryType=1 OR L.EntryType=4) -- LD.IsCredit = 0    
		LEFT JOIN
			ARBatch ARB with (NOLOCK) 
		ON
			L.ArBatchUid = ARB.ARBatchUid 
		LEFT JOIN 
			AR_ViewBatchClosingsLockedClosed VARB with (NOLOCK)  
		ON 
			L.ArBatchUid =VARB.ARBatchUid			
		INNER JOIN  
			Person CP with (NOLOCK)   
		ON  
			LD.ClaimingProviderUID =CP.PersonUID  
		INNER JOIN  
			Person RP with (NOLOCK)   
		ON  
			LD.RenderingProviderUID =RP.PersonUID  
		LEFT JOIN
			Visit V with (NOLOCK) 
		ON
			V.VisitUid =S.VisitUid 
		JOIN 
			[AR_ViewSuperbillProcedureAge] VSA with (NOLOCK)   
		ON  
			LD.SuperbillProcedureUid = VSA.SuperbillProcedureUid AND LD.LiabilityOwner = VSA.LiabilityOwner  
		WHERE  
			LD.LiabilityOwner = 0  
		    
		UNION ALL  

		SELECT   
			A.AccountUid AS AccountUid,
			ARP.AccountResponsiblePartyUID AS AccountResponsiblePartyUID,  
			(CASE     
			WHEN ARP.PersonUid IS NOT NULL    
			THEN [dbo].[UDF_getFormattedPreferredNameFromValues]  
			  (  
			   P.FirstName,  
			   P.LastName,  
			   P.MiddleName,  
			   P.Suffix  
			  )  
			WHEN ARP.CorporationUid IS NOT NULL    
			THEN CO.Name    
			END) AS ResponsiblePartyName,  
			ISNULL((V.VisitDate),S.ServiceDateStart) AS VisitDate,  
			LD.LiabilityOwner,  
			DATEDIFF(DAY, ARB.GLDate, GETUTCDATE()) AS age,  
			LD.FinancialCenterUID AS FinancialCenterUID,  
			COALESCE(LD.ClaimingProviderUID,LD.RenderingProviderUid,''00000000-0000-0000-0000-000000000000'') AS ClaimingProviderUID,  
			LD.RenderingProviderUID AS RenderingProviderUID,  
			(CASE WHEN LD.ClaimingProviderUID IS NULL THEN ISNULL(dbo.UDF_getFormattedPreferredNameFromValues(RP.FirstName,RP.LastName,RP.MiddleName,RP.Suffix),''-'') ELSE ISNULL(dbo.UDF_getFormattedPreferredNameFromValues(CP.FirstName,CP.LastName,CP.MiddleName,CP.Suffix),''-'') END) AS BillingProvider,  
			ISNULL(dbo.UDF_getFormattedPreferredNameFromValues(RP.FirstName,RP.LastName,RP.MiddleName,RP.Suffix),''-'') AS RenderingProvider,
			S.SuperbillUid AS SuperbillUid,
			SP.SuperbillProcedureUid AS SuperbillProcedureUid,
			''Insurance'' AS Type,
			CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed
		FROM  
			Account A with (NOLOCK)   
		LEFT JOIN  
			AccountResponsibleParty ARP with (NOLOCK)   
		ON   
			A.AccountResponsiblePartyUID = ARP.AccountResponsiblePartyUID  
		LEFT JOIN    
			Person P with (NOLOCK)     
		ON    
			ARP.PersonUID = P.PersonUID  
		LEFT JOIN  
			Corporation CO with (NOLOCK)   
		ON    
			CO.CorporationUID=ARP.CorporationUID   
		INNER JOIN   
			Superbill S with (NOLOCK)   
		ON  
			S.AccountUid = A.AccountUid   
		INNER JOIN  
			SuperbillProcedure SP with (NOLOCK)   
		ON  
			S.SuperbillUid  = SP.SuperbillUid   
		INNER JOIN  
			AR_LedgerDetail LD with (NOLOCK)    
		ON  
			LD.SuperbillProcedureUid = SP.SuperbillProcedureUid   
		INNER JOIN  
			AR_Ledger L with (NOLOCK)   
		ON  
			L.LedgerUid = LD.LedgerUid  AND (L.EntryType=1 OR L.EntryType=4) --AND LD.IsCredit = 0    
		LEFT JOIN
			ARBatch ARB with (NOLOCK) 
		ON
			L.ArBatchUid = ARB.ARBatchUid 
		LEFT JOIN 
			AR_ViewBatchClosingsLockedClosed VARB with (NOLOCK)  
		ON 
			L.ArBatchUid =VARB.ARBatchUid				
		INNER JOIN  
			Person CP with (NOLOCK)   
		ON  
			LD.ClaimingProviderUID =CP.PersonUID  
		INNER JOIN  
			Person RP with (NOLOCK)   
		ON  
			LD.RenderingProviderUID =RP.PersonUID 
		LEFT JOIN
			Visit V with (NOLOCK) 
		ON
			V.VisitUid =S.VisitUid 			 
		WHERE  
			LD.LiabilityOwner > 0  
	)A
	 GROUP BY
			A.AccountUid,
			A.AccountResponsiblePartyUID,
			A.ResponsiblePartyName,
			A.VisitDate,
			A.LiabilityOwner,
			A.FinancialCenterUID,
			A.ClaimingProviderUID,
			A.RenderingProviderUID,
			A.BillingProvider,
			A.RenderingProvider, 
			A.SuperbillUid, 
			A.SuperbillProcedureUid, 
			A.Type
)B  
INNER JOIN  
	AR_ViewSuperbillProcedureAggregate VSP with (NOLOCK)   
ON  
	VSP.SuperbillProcedureUid =B.SuperbillProcedureUid  





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSenderDirectAddress]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewSenderDirectAddress] AS
SELECT	sda.RelSenderDirectAddressUid,
		ipda.RelIntegrationPartnerDirectAddressUid,
		ipda.IntegrationPartnerUid,    
		ipda.DirectAddress,    
		ipda.AdditionalConfigurationXML,
		ipda.MessageRoutingUid,
		mr.Name as MessageRoutingName, 
		sda.IsDefault,
		(CASE WHEN ipda.Inactive = 1 then 1 
				WHEN lip.Inactive = 1 then 1
				ELSE 0 END) As Inactive,
		(CASE WHEN sda.ProviderUid IS NULL THEN 0 ELSE 1 END) AS IsProvider,
		(CASE WHEN sda.ServiceSiteUid IS NULL THEN 0 ELSE 1 END) AS IsOrganization,        
		sda.ProviderUid,
		sda.ServiceSiteUid,             
		(CASE WHEN sda.ProviderUid IS NOT NULL THEN dbo.UDF_getFormattedName(null, pe.FirstName, pe.MiddleName, pe.LastName, null) 
				WHEN sda.ServiceSiteUid IS NOT NULL Then lss.Name 
				ELSE ps.Name END) as FriendlyName,
		(CASE WHEN sda.ProviderUid IS NOT NULL THEN dbo.UDF_getFormattedName(pe.Prefix, pe.FirstName, pe.MiddleName, pe.LastName, pe.Suffix) 
				WHEN sda.ServiceSiteUid IS NOT NULL Then lss.Name 
				ELSE ps.Name 
		END) as Name,
		COALESCE(pr.ProviderLicense, 0) AS ProviderLicense,
		tc.TransmissionConfigurationUid,
		lip.Name as IntegrationPartnerName,
		(CASE WHEN sda.ProviderUid IS NOT NULL OR sda.ServiceSiteUid IS NOT NULL then NULL
				ELSE ps.PracticeSettingsUid END) as PracticeSettingsUid
FROM  RelSenderDirectAddress as sda
      LEFT JOIN RelIntegrationPartnerDirectAddress (NOLOCK) ipda on ipda.RelIntegrationPartnerDirectAddressUid = sda.RelIntegrationPartnerDirectAddressUid
      LEFT JOIN Provider (NOLOCK) pr ON pr.PersonUid = sda.ProviderUid 
      LEFT JOIN Person (NOLOCK) as pe On sda.ProviderUid = pe.PersonUid
      LEFT JOIN ListServiceSite (NOLOCK) as lss on lss.ServiceSiteUid = sda.ServiceSiteUid
      LEFT JOIN ListIntegrationPartner (NOLOCK) as lip on lip.IntegrationPartnerUid = ipda.IntegrationPartnerUid        
      LEFT JOIN TransmissionConfiguration (NOLOCK) as tc on tc.IntegrationPartnerUid = ipda.IntegrationPartnerUid AND tc.AutoSend=1
      LEFT JOIN ListMessageRouting (NOLOCK) as mr on mr.MessageRoutingUid = ipda.MessageRoutingUid
      CROSS APPLY (SELECT top 1 * from PracticeSettings)  ps
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindProvider]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewFindProvider] AS
SELECT			pe.PersonUid, 
				pr.ExternalID, 
				pe.Prefix, 
				pe.FirstName, 
				pe.MiddleName, 
				pe.LastName, 
				pe.Suffix,
				pe.AkaFirstName,
				pe.AkaLastName,
				pe.FormattedInternalName,
				--
				pr.Inactive, 
				pr.ClinicCenterUid, 
				cc.Name AS ClinicCenter,
				(CASE WHEN u.PersonUid IS NULL THEN 0 ELSE 1 END) AS IsActiveUser, 
				pr.SpecialtyUid, 
				ls.Name as Specialty, 
				pr.ConsultingProvider,
				pe.Address1,
				pe.Phone1,
				pe.Phone2,
				pe.Phone3,
				pe.Phone4,
				pr.Notes,
				pe.Address1_Address1 AS Address1Ln1,
				pe.Address1_Address2 AS Address1Ln2,
				pe.Address1_City AS City1,
				pe.Address1_State AS [State1],
				pe.Address1_Zip AS Zip1,
				pe.PhoneNumber1 AS PhoneNumber1, 
				pe.PhoneType1 AS PhoneTypeName1,
				pe.PhoneNumberScrubbed AS PhoneNumberScrubbed1,
				(CASE WHEN pr.AprimaDataExchangeProviderRegistrationUid IS NULL THEN 0 ELSE 1 END) AS IsAprimaDataExchangeProvider,
				pr.AprimaDataExchangeProviderRegistrationUid,
				CASE 
		  WHEN frm.DirectAddress IS NOT NULL THEN frm.DirectAddress
          WHEN u.PersonUid IS NOT NULL THEN dmu.DirectMailAddress
          WHEN u.PersonUid IS NULL THEN dmu.DirectMailAddress
          ELSE NULL
        END as EmailDirect
FROM    Provider pr WITH (NOLOCK)
		INNER JOIN dbo.ViewPerson pe (NOEXPAND) ON pr.PersonUid = pe.PersonUid 
		LEFT JOIN ListClinicCenter cc WITH (NOLOCK) ON pr.ClinicCenterUid = cc.ClinicCenterUid 
        LEFT JOIN UserPRM u WITH (NOLOCK) ON pr.PersonUid = u.PersonUid AND u.Inactive = 0
        LEFT JOIN ListSpecialty ls WITH (NOLOCK) on pr.SpecialtyUid = ls.SpecialtyUid
        OUTER APPLY (select top 1 DirectAddress
                     from ViewSenderDirectAddress sda
                     where sda.ProviderUid = pr.PersonUid
					   and sda.Inactive = 0
                     ORDER BY IsDefault DESC, RelSenderDirectAddressUid, IntegrationPartnerUid DESC) frm
				OUTER apply (select top 1 dmuT1.DirectMailAddress, dmuT1.IsUser
                      from DirectMailUser dmuT1 WITH (NOLOCK)
                      LEFT JOIN TransmissionConfiguration as tc WITH (NOLOCK) on tc.TransmissionConfigurationUid = dmuT1.TransmissionConfigurationUid
                      LEFT JOIN ListIntegrationPartner as lip WITH (NOLOCK) on lip.IntegrationPartnerUid = tc.IntegrationPartnerUid
                      where dmuT1.ProviderUid = pr.PersonUid 
					    AND dmuT1.Inactive = 0
					    AND (lip.IntegrationPartnerUid is NULL OR lip.Inactive = 0)
                      ORDER BY dmuT1.Password desc , dmuT1.IsDefault desc) dmu       



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientAppointments]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewPatientAppointments] AS
	SELECT	a.AppointmentUid, 
			COALESCE(a.PatientUid, g.PatientUid) AS PatientUid,
			a.Reason,
			a.StartDateTime, 
			a.EndDateTime, 
			c.TimeZone,
			a.AppointmentTypeUid, 
			atype.[Name] AS AppointmentType, 
			atype.Color AS AppointmentTypeColor,
			astat.AppointmentStatusUid, 
			AppointmentStatus = ISNULL(gstat.Name, astat.Name),
			astat.IsCanceledStatus, 
			astat.Color AS AppointmentStatusColor,
			a.CalendarUid, 
			c.[Name] AS Calendar,
			(SELECT TOP 1 v.VisitUid FROM Visit v WHERE v.AppointmentUid = a.AppointmentUid) AS VisitUid,
			a.ProviderUid, 
			p.FormattedInternalName AS [Provider],
			a.BillingProviderUid, 
			bp.FormattedInternalName AS BillingProvider,
			a.ServiceSiteUid, 
			ss.[Name] AS ServiceSite,
			a.FinancialCenterUid,
			fc.[Name] AS FinancialCenter
	FROM	Appointment a 	
			Left JOIN RelGroupAppointmentPatient g ON g.AppointmentUid = a.AppointmentUid 
			LEFT JOIN ListAppointmentType atype ON a.AppointmentTypeUid = atype.AppointmentTypeUid
			LEFT JOIN ListCalendar c ON a.CalendarUid = c.CalendarUid
			LEFT JOIN ViewFindProvider p ON a.ProviderUid = p.PersonUid
			LEFT JOIN ViewFindProvider bp ON a.BillingProviderUid = bp.PersonUid
			LEFT JOIN ListServiceSite ss ON a.ServiceSiteUid = ss.ServiceSiteUid
			LEFT JOIN FinancialCenter fc ON a.FinancialCenterUid = fc.FinancialCenterUid
			LEFT JOIN ListAppointmentStatus astat WITH (NOLOCK) ON a.AppointmentStatusUid = astat.AppointmentStatusUid
            LEFT JOIN ListAppointmentStatus gstat WITH (NOLOCK) ON g.AppointmentStatusUid = gstat.AppointmentStatusUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindPatient]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewFindPatient] AS
SELECT	per.PersonUid, pat.ExternalID, pat.Inactive, per.FirstName, per.LastName, 
		vp.FormattedPreferredName AS FullName, vp.AkaName, 
		per.Birthdate, per.Deathdate, per.AkaFirstName, per.AkaLastName, per.SocialSecurityNumber, 
        pat.MedicalRecordNumber, 
        per.Phone1, 
		vp.PhoneNumber1 AS PhoneNumber, 
        vp.PhoneType1 AS PhoneTypeName,
		vp.PhoneNumberScrubbed, 
        per.[Address1] AS [Address],
        vp.Address1_Address1 AS Address1,
        vp.Address1_Address2 AS Address2,
        vp.Address1_City AS City,
        vp.Address1_State AS [State],
        vp.Address1_Zip AS Zip,        
        g1.Name AS Gender, per.PhotoAttachmentUid, 
        per.Phone2, 
        vp.PhoneNumber2 AS PhoneNumber2, 
        vp.PhoneType2 AS PhoneTypeName2,
        per.Phone3, 
        vp.PhoneNumber3 AS PhoneNumber3, 
        vp.PhoneType3 AS PhoneTypeName3,
        per.Phone4, 
        vp.PhoneNumber4 AS PhoneNumber4, 
        vp.PhoneType4 AS PhoneTypeName4,                        
        pat.ExternalID AS PatientExternalID, per.Notes,
        pc.PatientConditionUid, dbo.UDFPatientConditions(per.PersonUid) AS PatientCondition, pc.Color AS PatientConditionColor,
        pat.ProviderUid, 
		prov.FormattedInternalName AS Provider
FROM    dbo.ViewPerson (NOEXPAND) AS vp INNER JOIN
        dbo.Person per ON vp.PersonUid = per.PersonUid INNER JOIN
        dbo.Patient pat ON per.PersonUid = pat.PersonUid LEFT OUTER JOIN
        dbo.ListGender AS g1 ON per.GenderUid = g1.GenderUid --LEFT OUTER JOIN
        LEFT JOIN ListPatientCondition pc ON pc.PatientConditionUid = (Select Top 1 PatientConditionUid FROM RelPatientCondition WHERE PatientUid = per.PersonUid ORDER BY DisplayOrder ASC)
        LEFT JOIN ViewFindProvider prov ON pat.ProviderUid = prov.PersonUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientTrackingEventsFilter]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewPatientTrackingEventsFilter]
AS
SELECT	PatientTrackingEventUid, 
		PTE.EventDate, 
		PAT.FullName AS [Patient], 
		LPTET.Name AS [EventTypeName], 
		PTE.Notes, 
		PTE.Inactive,
		PAT.PersonUid AS PatientUid,
		PTE.PatientTrackingEventTypeUid
FROM PatientTrackingEvent AS PTE
INNER JOIN dbo.ViewFindPatient AS PAT ON PTE.PatientUid = PAT.PersonUid
INNER JOIN ListPatientTrackingEventType AS LPTET ON LPTET.PatientTrackingEventTypeUid = PTE.PatientTrackingEventTypeUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCHCSuperbillProcedurePatientLiability]'))
EXEC dbo.sp_executesql @statement = N'

/* 	 02/02/2017 - kculberth - Bug 51825:Statements-CHC Payer Setting Encounter codes need to print on statement if there is a patient liability for this code.
*/

CREATE VIEW [dbo].[ViewCHCSuperbillProcedurePatientLiability] WITH SCHEMABINDING
AS
   SELECT sbp.SuperbillProcedureUid
   ,SUM(CASE WHEN NOT LD.LiabilityOwner IS NULL AND LD.LiabilityOwner = 0 THEN LD.Amount ELSE 0 END) AS PatientLiability
   ,COUNT_BIG(*) AS Count  
   from dbo.AR_LedgerDetail (NOLOCK) LD              
   INNER JOIN dbo.SuperbillProcedure (NOLOCK) SBP  ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
   INNER JOIN dbo.ChcRelApprovalSetting ras on ras.servicesiteuid = ld.servicesiteuid and sbp.procedureuid = ras.procedureuid
   INNER JOIN dbo.ChcSuperbillProcedure chcsbp on chcsbp.SuperbillProcedureUid = sbp.SuperbillProcedureUid
   group by sbp.SuperbillProcedureUid


/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_ViewCHCSuperbillProcedurePatientLiability_SuperbillProcedureUid ON ViewCHCSuperbillProcedurePatientLiability(SuperbillProcedureUid)
CREATE INDEX IX_ViewCHCSuperbillProcedurePatientLiability_SuperbillProcedureUid ON ViewCHCSuperbillProcedurePatientLiability(SuperbillProcedureUid)


*/
' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewCHCSuperbillProcedurePatientLiability]') AND name = N'PK_ViewCHCSuperbillProcedurePatientLiability_SuperbillProcedureUid')
CREATE UNIQUE CLUSTERED INDEX [PK_ViewCHCSuperbillProcedurePatientLiability_SuperbillProcedureUid] ON [dbo].[ViewCHCSuperbillProcedurePatientLiability]
(
	[SuperbillProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountResponsiblePartyAggregate_SumAccountLiabilities_Filter]'))
EXEC dbo.sp_executesql @statement = N'

/*   05/15/2015 - kculberth - use AR_ViewSuperbillProcedureAggregateSub_CHC_Statements instead of AR_ViewSuperbillProcedureAggregateSub
*/


CREATE VIEW [dbo].[AR_ViewAccountResponsiblePartyAggregate_SumAccountLiabilities_Filter] 
AS
--SELECT AC.AccountResponsiblePartyUid, 
--	SUM(ISNULL(VSA.Liability,0)) AS Liability, 
--	SUM(ISNULL(VSA.AssignedLiability,0)) AS AssignedLiability,
--	SUM(ISNULL(VSA.LiabilityBalance,0)) AS LiabilityBalance, 
--	SUM(ISNULL(VSA.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance
--FROM Account AC WITH (NOLOCK)
--LEFT JOIN Superbill (NOLOCK) SB ON AC.AccountUid = SB.AccountUid
----LEFT JOIN AR_ViewSuperbillProcedureAggregateSub VSA WITH (NOEXPAND) ON SB.SuperbillUid = VSA.SuperbillUid
--LEFT JOIN AR_ViewSuperbillProcedureAggregateSub_CHC_Statements VSA  ON SB.SuperbillUid = VSA.SuperbillUid
--LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
--ON SB.SuperbillStatusUid = rpsss.SuperbillStatusUid
--WHERE rpsss.superbillstatusuid is null AND AC.Inactive = 0
--GROUP BY AC.AccountResponsiblePartyUid

select 
	AC.AccountResponsiblePartyUid
	,SUM(ISNULL(Liability,0)) AS Liability
	,SUM(ISNULL(AssignedLiability,0)) AS AssignedLiability
	,SUM(ISNULL(LiabilityBalance,0)) AS LiabilityBalance 
	,SUM(ISNULL(AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance
FROM Account AC WITH (NOLOCK)
LEFT JOIN Superbill (NOLOCK) SB ON AC.AccountUid = SB.AccountUid
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub VSA WITH (NOEXPAND) ON SB.SuperbillUid = VSA.SuperbillUid
LEFT JOIN ViewCHCSuperbillProcedurePatientLiability cte WITH (NOEXPAND) ON cte.superbillprocedureuid = VSA.SuperbillProcedureUid
LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus  rpsss WITH (NOLOCK) ON SB.SuperbillStatusUid = rpsss.SuperbillStatusUid
WHERE rpsss.superbillstatusuid IS NULL AND AC.Inactive = 0
AND (cte.patientliability <> 0 OR cte.patientliability IS NULL)
GROUP BY AC.AccountResponsiblePartyUid







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillProcedure_IsVoid]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewSuperbillProcedure_IsVoid]
AS

WITH cteSuperbillProcedures AS -- this seems to reduce sql reads (possibly it cannot optimize fact that only single field gets used?)
(
	SELECT SuperbillProcedureUid
		FROM SuperbillProcedure WITH (NOLOCK)
),
 cteSupperbillProceduresWithLedgers AS
(
	SELECT DISTINCT LD.SuperbillProcedureUid, L_VOID.LedgerUid AS VoidingLedgerUid
		FROM AR_LedgerDetail LD WITH (NOLOCK) 
				LEFT JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid  
					LEFT JOIN AR_Ledger L_VOID WITH (NOLOCK) ON L.LedgerUid = L_Void.VoidLedgerUid
		WHERE LD.IsCredit = 0 AND LD.Amount >= 0 -- debit side only with amount >= 0
			AND L.VoidLedgerUid IS NULL AND L.EntryType IN (1,4) -- not voiding and (CHARGE or TRANSFER)
),
cteSupperbillProceduresWithLedgersNotVoid AS 
(
SELECT SBPWL.SuperbillProcedureUid, 1 AS HasFinancials -- superbill procedures with non voided charges
	FROM cteSupperbillProceduresWithLedgers SBPWL 
	WHERE SBPWL.VoidingLedgerUid IS NULL
UNION
SELECT SBP.SuperbillProcedureUid, 0 AS HasFinanicals -- superbill procedures without any charges
	FROM cteSuperbillProcedures SBP
		LEFT JOIN cteSupperbillProceduresWithLedgers SBPWL ON SBP.SuperbillProcedureUid = SBPWL.SuperbillProcedureUid
	WHERE SBPWL.SuperbillProcedureUid IS NULL
)
SELECT DISTINCT SBP.SuperbillProcedureUid, 
		CASE WHEN NOT SBPWLNV.SuperbillProcedureUid IS NULL THEN 0 ELSE 1 END AS IsVoid, -- if not in non voided list, they are voided
		CASE WHEN SBPWLNV.SuperbillProcedureUid IS NULL OR SBPWLNV.HasFinancials = 1  THEN 1 ELSE 0 END AS HasFinanicals -- flag for wether they have any charges at all (claims)
	FROM cteSuperbillProcedures SBP
		LEFT JOIN cteSupperbillProceduresWithLedgersNotVoid SBPWLNV ON SBP.SuperbillProcedureUid = SBPWLNV.SuperbillProcedureUid -- these are ''non voided''





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillCompleteBatchSub]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewSuperbillCompleteBatchSub]     --WITH SCHEMABINDING
AS
SELECT S.SuperbillUid,SP.SuperbillProcedureUid, CASE WHEN arb.IsClosed=1  OR  arb.IsLocked =1 THEN 1 ELSE 0 END AS CompleteBatch    FROM 
	dbo.AR_Ledger L 
JOIN
	dbo.AR_LedgerDetail LD
ON
	L.LedgerUid = LD.LedgerUid  AND L.EntryType =1
JOIN
	dbo.SuperbillProcedure SP
ON
	LD.SuperbillProcedureUid =SP.SuperbillProcedureUid
LEFT JOIN
   ViewSuperbillProcedure_IsVoid VSPVOID
ON
   VSPVOID.SuperbillProcedureUid=Sp.SuperbillProcedureUid
JOIN
	dbo.Superbill S
ON
	SP.SuperbillUid =S.SuperbillUid 
JOIN
	dbo.ARBatch ARB
ON
	L.ArBatchUid =ARB.ARBatchUid 
WHERE 
    VSPVOID.IsVoid IS NULL OR VSPVOID.IsVoid=0
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewBatchUnallocatedDeposits]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[AR_ViewBatchUnallocatedDeposits]
AS
-- bmr 20120622 Removed AR_ViewLedgerSub references - go direct to base tables
-- batches with non reconciled transactions that have un distributed deposits
SELECT L. ArBatchUid , LD .DepositUid, L.Reconciled , DA. ReceiptBalance
       FROM AR_Ledger L
             INNER JOIN AR_LedgerDetail LD ON L .LedgerUid = LD.LedgerUid
             INNER JOIN ARBatch ARB ON L .ArBatchUid = ARB.ArBatchUId
             INNER JOIN AR_ViewDepositAggregate DA ON LD .DepositUid = DA.DepositUid
       WHERE NOT LD.DepositUid IS NULL AND DA .ReceiptBalance != 0
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillAggregate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewSuperbillAggregate] 
AS
SELECT SB.SuperbillUid,
	SUM(ISNULL(VSPAB.Liability, 0)) AS Liability, 
	SUM(ISNULL(VSPAB.AssignedLiability, 0)) AS AssignedLiability,
	SUM(ISNULL(VSPAB.Liability, 0)) - SUM(ISNULL(VSPAB.AssignedLiability, 0)) AS UnAssignedLiability,
	SUM(ISNULL(VSPAB.Distribution, 0)) AS Distribution, 
	SUM(ISNULL(VSPAB.AssignedDistribution, 0)) AS AssignedDistribution, 
	SUM(ISNULL(VSPAB.Distribution, 0)) - SUM(ISNULL(VSPAB.AssignedDistribution, 0)) AS UnAssignedDistribution, 
	SUM(ISNULL(VSPAB.Adjustment, 0)) AS Adjustment,
	SUM(ISNULL(VSPAB.AssignedAdjustment, 0)) AS AssignedAdjustment,
	SUM(ISNULL(VSPAB.Adjustment, 0)) - SUM(ISNULL(VSPAB.AssignedAdjustment, 0)) AS UnAssignedAdjustment,
	SUM(ISNULL(VSPAB.LiabilityBalance, 0)) AS LiabilityBalance, 
	CASE WHEN SUM(ISNULL(VSPAB.LiabilityBalance, 0))=0 AND SUM(ABS(ISNULL(VSPAB.LiabilityBalance, 0)))>0 THEN 1 ELSE 0 END AS ZeroLiabilityBalanceNotDistributed, -- we have a ZeroBalance made up of offsetting balances (not properly distributed) 
	SUM(ISNULL(VSPAB.AssignedLiabilityBalance, 0)) AS AssignedLiabilityBalance,
	SUM(ISNULL(VSPAB.LiabilityBalance, 0)) - SUM(ISNULL(VSPAB.AssignedLiabilityBalance, 0)) AS UnAssignedLiabilityBalance
FROM Superbill SB WITH (NOLOCK) 
	LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON SB.SuperbillUid = VSPAB.SuperbillUid
GROUP BY SB.SuperbillUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewBatchZeroLiabilitySuperbills]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewBatchZeroLiabilitySuperbills] 
AS

-- bmr 20120622 Removed AR_ViewLedgerSub references - go direct to base tables

WITH cteSuperbillAggregate AS
(
	SELECT SuperbillUid, Liability FROM AR_ViewSuperbillAggregate
		WHERE Liability = 0
)
-- batches with non reconciled transactions that have a zero dollar superbill liability
SELECT L.ArBatchUid , SBP.SuperbillUid, L.Reconciled, SA.Liability
	FROM AR_Ledger L
		INNER JOIN AR_LedgerDetail LD ON L.LedgerUid = LD.LedgerUid
		INNER JOIN ARBatch ARB ON L.ArBatchUid = ARB.ArBatchUId
		INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		INNER JOIN cteSuperbillAggregate SA ON SBP.SuperbillUid = SA.SuperbillUid 
	WHERE NOT LD.SuperbillProcedureUid IS NULL 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewBatchClosings]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewBatchClosings] 
AS
SELECT DISTINCT BCLC.ArBatchUid, BCLC.ArBatchName, BCLC.GlDate, BCLC.IsLocked, BCLC.IsClosed,
		CAST(CASE WHEN BUD.ArBatchUid IS NULL THEN 0 ELSE 1 END AS BIT) AS HasUnallocatedDeposits,
		CAST(CASE WHEN ZLS.ArBatchUid IS NULL THEN 0 ELSE 1 END AS BIT) AS HasZeroLiabilitySuperbills
	FROM AR_ViewBatchClosingsLockedClosed BCLC
		LEFT JOIN AR_ViewBatchUnallocatedDeposits BUD ON BCLC.ARBatchUid = BUD.ArBatchUid
		LEFT JOIN AR_ViewBatchZeroLiabilitySuperbills ZLS ON BCLC.ARBatchUid = ZLS.ArBatchUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewBatchFinancialCenterRelations]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[AR_ViewBatchFinancialCenterRelations]   -- BMR 2016-11-03 - Removed SCHEMABINDING 
AS  
	SELECT L.ArBatchUid, LD.FinancialCenterUid, ARB.GLDate, FC.ARClosedThroughDate, COUNT_BIG(*) AS Count        
		FROM dbo.AR_LedgerDetail LD              
			INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid              
			INNER JOIN dbo.FinancialCenter FC ON LD.FinancialCenterUid = FC.FinancialCenterUid              
			INNER JOIN dbo.ARBatch ARB ON L.ArBatchUid = ARB.ARBatchUid        
		WHERE NOT LD.FinancialCenterUid IS NULL        
		GROUP BY L.ArBatchUid, LD.FinancialCenterUid, ARB.GLDate, FC.ARClosedThroughDate             






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewARBatch_Deposit]'))
EXEC dbo.sp_executesql @statement = N'

CREATE  VIEW [dbo].[ViewARBatch_Deposit]  
AS  

WITH cteBatchDeposit AS
(	-- FIRST we need a list of unique Batch/Deposit pairs ... 
	-- Since the aggregate ALWAYS returns a single record per deposituid, adding the balances does not break anything
	SELECT DISTINCT L.ArBatchUid, LD.DepositUid, VDA.Receipt, VDA.ReceiptBalance
		FROM AR_LedgerDetail LD
			INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid 
			INNER JOIN AR_ViewDepositAggregate VDA ON LD.DepositUid = VDA.DepositUid
		WHERE L.EntryType = 0 -- payment
			AND LD.IsCredit = 1
			AND NOT LD.DepositUid IS NULL
	-- SO, out of this CTE we basically have a unique set of ArBatchUid, DepositUid
)
-- NOW, we want, per batch, the count of the number of unique deposits in the batch
-- Since the CTE above is unique, this is all good
SELECT BD.ArBatchUid,
		COUNT(BD.DepositUid) AS DepositCount,
		SUM(-BD.Receipt) as DepositAmount,  
        SUM(BD.Receipt - BD.ReceiptBalance) as DepositAllocatedAmount 
	FROM cteBatchDeposit BD
	GROUP BY BD.ArBatchUid
-- We ALSO want a sum of the Amounts and Allocated Amounts on the Deposits as a WHOLE
-- We do NOT want to sum these values specifically from the Amounts IN the batch ... 
-- We want these totals based upon the DEPOSIT, irrespective of the BATCH
-- DavidW and BrettR 05/03/2012 - This made sense this evening at 4:30 PM





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPayerCredit]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewPayerCredit] 
AS
	with myCTE as
	(
	SELECT ld.PayerCreditUid, 
	       SUM(CASE WHEN ld.IsCredit = 0 THEN 0
	                WHEN apc.DepositUid != ld2.DepositUid THEN 0 -- Refunds will be an credit==0 but will have a different deposit
	                ELSE ld.AMOUNT*-1 END) As Receipt,         
		   SUM(ld.Amount*-1) As ReceiptBalance, 
		   COUNT_BIG(*) AS Count  
	FROM dbo.AR_LedgerDetail ld
			inner join dbo.AR_PayerCredit apc on ld.PayerCreditUid = apc.PayerCreditUid 
			inner join dbo.AR_Ledger arl on ld.LedgerUid = arl.LedgerUid
			inner join dbo.AR_LedgerDetail ld2 on arl.LedgerUid = ld2.LedgerUid
													and ld.LedgerDetailUid != ld2.LedgerDetailUid   
	WHERE ld.PayerCreditUid IS NOT NULL  
	GROUP BY ld.PayerCreditUid      
	)
	SELECT PC.PayerCreditUid, 
		ISNULL(vpc.Receipt, 0) AS Receipt, 
		ISNULL(vpc.ReceiptBalance, 0) AS ReceiptBalance
	FROM AR_PayerCredit PC
		LEFT OUTER JOIN myCTE vpc ON PC.PayerCreditUid = vpc.PayerCreditUid
	--LEFT JOIN AR_ViewPayerCreditAggregateSub VPCAS WITH (NOEXPAND) ON PC.PayerCreditUid = VPCAS.PayerCreditUid
	--LEFT JOIN AR_ViewPayerCreditAggregateSub VPCAS ON PC.PayerCreditUid = VPCAS.PayerCreditUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewARBatch_PayerCredit]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewARBatch_PayerCredit]  
AS  
	with myBatchPC as  -- PayerCredits can have multiple Ledger Entries.  Only get 1st entry based on batch, payer credit
	(
		SELECT L.ArBatchUid,
			   LD.PayerCreditUid,
			   Row_Number() OVER (PARTITION BY L.ArBatchUid, LD.PayerCreditUid ORDER BY L.ArBatchUid) as apcCount
			FROM AR_LedgerDetail LD
				INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
			WHERE L.EntryType = 0 -- payment
				AND LD.IsCredit = 1
				AND NOT LD.PayerCreditUid IS NULL
	),
	myBatchPCWithAllocatedAmounts as -- merge in the payer credit balances
	(
		SELECT mbc.ArBatchUid, mbc.PayerCreditUid, VPCA.Receipt, VPCA.ReceiptBalance
			FROM myBatchPC mbc
				--INNER JOIN AR_ViewPayerCreditAggregate VPCA ON mbc.PayerCreditUid = VPCA.PayerCreditUid	
				INNER JOIN AR_ViewPayerCredit VPCA ON mbc.PayerCreditUid = VPCA.PayerCreditUid	
			where mbc.apcCount = 1 -- strip out the duplicates of batch/pc
	)
	select mbc.ArBatchUid, 
		   COUNT(mbc.ArBatchUid) as PayerCreditCount,
		   SUM(-mbc.Receipt) as PayerCreditAmount,
		   SUM(mbc.Receipt  - mbc.ReceiptBalance) as PayerCreditAllocatedAmount
	from myBatchPCWithAllocatedAmounts mbc
	GROUP BY mbc.ArBatchUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewARBatch_Superbill]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewARBatch_Superbill]  
AS  
WITH superbillTotalsCte AS
(
	SELECT L.ARBatchUid,
			   SBP.SuperbillUid, 
			   sum(LD.Amount) AS SuperbillTotalAmount
		  FROM AR_LedgerDetail LD
				inner join AR_Ledger L ON LD.LedgerUid = L.LedgerUid 
				inner join dbo.SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
				inner join arbatch ARB on L.ARBatchUid = ARB.ARBatchUid
		  WHERE NOT LD.SuperbillProcedureUid IS NULL
				AND  (L.EntryType = 1 OR L.EntryType = 4) -- Charge/Transfer
				AND ((L.EntryType <> 4 AND LD.IsCredit = 0) OR (L.EntryType = 4)) -- the Charge/Transfer side (include BOTH sides on a Transfer)
		  GROUP BY L.ARBatchUid, SBP.SuperbillUid
)
select ARBatchUid,
       count( distinct SuperbillUid) as SuperbillCount,
       sum(SuperbillTotalAmount) as SuperbillTotalAmount
from superbillTotalsCte 
group by ARBatchUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewARBatch]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[ViewARBatch]  AS 
-- NOTE: \BusinessObject\XML\FindView.xml refrences this. Any changes here need to be made there as well.      
SELECT      
 ARBatch.ARBatchUid,      
 ARBatch.ExternalID,      
 ARBatch.Name,      
 ARBatch.Inactive,      
 ARBatch.Notes,      
 ARBatch.LastModifiedDate,      
 ARBatch.LastModifiedByUid,      
 ARBatch.GLDate,      
 ARBatch.IsLocked,    
 ARBatch.IsClosed,
 CASE ARBatch.IsClosed 
	WHEN 1 THEN ''Closed''
	ELSE CASE ARBatch.IsLocked WHEN 1 THEN ''Completed'' ELSE ''Open'' END
 END AS [Status],
 CAST(CASE ARBatch.IsClosed 
	WHEN 1 THEN 3
	ELSE CASE ARBatch.IsLocked WHEN 1 THEN 2 ELSE 1 END
 END AS [SmallInt]) AS [ARBatchState], -- Maps to ARBatchStateEnum
 ARBatch.OwnerUid,  
 p.FullName as OwnerName,  
 isNull(d.DepositCount,0) as DepositCount,          
 isNull(0 - d.DepositAmount,0) as DepositAmount,
 ISNULL(d.DepositAllocatedAmount,0) as DepositAllocatedAmount,      
 (0 - (isNull(d.DepositAmount,0) + isNull(d.DepositAllocatedAmount,0))) as DepositUnallocatedAmount,          
 isNull(pc.PayerCreditCount,0) as PayerCreditCount,          
 isNull(0 - pc.PayerCreditAmount,0) as PayerCreditAmount,
 ISNULL(pc.PayerCreditAllocatedAmount,0) as PayerCreditAllocatedAmount,      
 (0 - (isNull(pc.PayerCreditAmount,0) + isNull(pc.PayerCreditAllocatedAmount,0))) as PayerCreditUnallocatedAmount,          
 isNull(sb.SuperbillCount,0) as SuperbillCount,          
 isNull(sb.SuperbillTotalAmount,0) as SuperbillTotalAmount          
FROM ARBatch         
	LEFT JOIN ViewARBatch_Deposit d ON d.ARBatchUid = ARBatch.ARBatchUid     
	LEFT JOIN ViewARBatch_PayerCredit pc ON pc.ARBatchUid = ARBatch.ARBatchUid        
	LEFT JOIN ViewARBatch_Superbill sb ON  sb.ARBatchUid = ARBatch.ARBatchUid  
	LEFT JOIN ViewPerson (NOEXPAND) p ON p.PersonUid = ARBatch.OwnerUid  









' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFinancialCenterClosing]'))
EXEC dbo.sp_executesql @statement = N'







CREATE VIEW [dbo].[ViewFinancialCenterClosing]    
AS       
    
SELECT FC.FinancialCenterUid, FC.ExternalId AS FinancialCenterExternalId, FC.Name AS FinancialCenterName,
FC.ArClosedThroughDate AS FinancialCenterArClosedThroughDate, 
CASE WHEN COUNT(VARB.ArBatchUid) = 0 THEN NULL ELSE COUNT(VARB.ArBatchUid) END AS BatchCount, SUM(VARB.DepositCount) AS DepositCount, 
SUM(VARB.DepositAmount) AS DepositAmount, SUM(VARB.DepositAllocatedAmount) AS DepositAllocatedAmount, SUM(VARB.DepositUnallocatedAmount) AS DepositUnallocatedAmount,
SUM(VARB.SuperbillCount) AS SuperbillCount, SUM(VARB.SuperbillTotalAmount) AS SuperbillTotalAmount 
FROM FinancialCenter FC 
LEFT JOIN (SELECT BFCR.ArBatchUid, BFCR.GLDate AS ArBatchGlDate, ARB.Name AS ArBatchName, ARB.IsLocked AS ArBatchIsLocked,
					BFCR.FinancialCenterUid, FC.Name AS FinancialCenterName, FC.ExternalID AS FinancialCenterExternalId,
					FC.ARClosedThroughDate AS FinancialCenterArClosedThroughDate
				FROM AR_ViewBatchFinancialCenterRelations BFCR -- BMR 2016-11-03 - Removed NOEXPAND as removed SCHEMABINDING
					INNER JOIN ARBatch ARB ON BFCR.ArBatchUid = ARB.ARBatchUid
					INNER JOIN FinancialCenter FC ON BFCR.FinancialCenterUid = FC.FinancialCenterUid
					INNER JOIN AR_ViewBatchClosings VBC ON BFCR.ArBatchUid = VBC.ArBatchUid
				WHERE VBC.IsClosed = 0) ARBFCREL ON FC.FinancialCenterUid = ARBFCREL.FinancialCenterUid
LEFT JOIN ViewArBatch VARB ON ARBFCREL.ArBatchUid = VARB.ArBatchUid AND VARB.IsClosed = 0
GROUP BY FC.FinancialCenterUid, FC.ExternalId, FC.Name, FC.ArClosedThroughDate






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountAggregate]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[AR_ViewAccountAggregate] 
AS
SELECT AC.AccountUid,
      SUM(ISNULL(VSPAB.Liability,0)) AS Liability, SUM(ISNULL(VSPAB.AssignedLiability,0)) AS AssignedLiability,
      SUM(ISNULL(VSPAB.LiabilityBalance,0)) AS LiabilityBalance, SUM(ISNULL(VSPAB.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance,
      SUM(ISNULL(VSPAB.LiabilityBalance,0)) - SUM(ISNULL(VSPAB.AssignedLiabilityBalance,0)) AS UnassignedLiabilityBalance
FROM Account AC WITH (NOLOCK)
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON AC.AccountUid = VSPAB.AccountUid
GROUP BY AC.AccountUid

-- NOTICE:  This returns a set of values DIFFERENT from the OLDER ViewArAccountAggregate
-- In the case of an account credit, in the OLD, this is reflected in ViewArAccountAggregate
-- Now, this gets reflected in the ResponsibleParty aggregate and will NOT be reflected here ... this is INTENTIONAL
-- Added calculated UnassignedLiabilityBalance for Demographics Patient Balance



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_AccountResponsiblePartyAccountReport]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[MDOL_RPT2_VIEW_AccountResponsiblePartyAccountReport]
AS	
SELECT
	ARP.AccountResponsiblePartyUid,
	(CASE 
	WHEN ARPPerson.PersonUid IS NOT NULL THEN (ARPPerson.LastName + '', '' + ARPPerson.FirstName)
	ELSE ARPCorp.Name
	END) AS ARPName,
	CASE 
	WHEN ARPPerson.PersonUid IS NOT NULL THEN ARPPerson.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
	ELSE ARPCorp.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
	END AS Address1,
	CASE 
	WHEN ARPPerson.PersonUid IS NOT NULL THEN ARPPerson.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
	ELSE ARPCorp.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
	END AS Address2,
	CASE 
	WHEN ARPPerson.PersonUid IS NOT NULL THEN ARPPerson.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)'')
	ELSE ARPCorp.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'')
	END AS City,
	CASE 
	WHEN ARPPerson.PersonUid IS NOT NULL THEN ARPPerson.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)'')
	ELSE ARPCorp.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'')
	END AS [State],
	CASE 
	WHEN ARPPerson.PersonUid IS NOT NULL THEN ARPPerson.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
	ELSE ARPCorp.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
	END AS Zip,
	CASE 
	WHEN ARPPerson.PersonUid IS NOT NULL THEN ARPPerson.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'')
	ELSE ARPCorp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'')
	END AS PhoneNumber,
	LCS.Name as CollectionStatus,
	CSL.Name as CollectionStatusLevel,
	dbo.GetAccountRPBalanceInCollections(ARP.AccountResponsiblePartyUid) as CollectionsBalance,
	ARP.CollectionStatusExpirationDate	AS PaymentDueDate,
	CASE
	WHEN ARP.OverrideSufficient = 1 THEN ARP.OverridePaymentAmount
	ELSE ARP.CalculatedPaymentAmount
	END AS PaymentAmount,
	Account.AccountUid,
	Account.Name as AccountName,
	AcctPerson.PersonUid as PatientUid,
	AcctPerson.LastName as PatientLastName,
	AcctPerson.FirstName as PatientFirstName,
	isnull(Convert(varchar(10), AcctPerson.BirthDate, 101), '''') as PatientBirthDate,
	(VA.LiabilityBalance - VA.AssignedLiabilityBalance) as PatientLiability,
	(VA.LiabilityBalance) as TotalBalance
FROM
	AccountResponsibleParty ARP WITH(NOLOCK)
LEFT JOIN
	Person ARPPerson  WITH(NOLOCK)
ON
	ARP.PersonUid = ARPPerson.PersonUid
LEFT JOIN
	Corporation ARPCorp  WITH(NOLOCK)
ON
	ARP.CorporationUid = ARPCorp.CorporationUid	
LEFT JOIN
	ListCollectionStatus LCS  WITH(NOLOCK)
ON
	ARP.CollectionStatusUid = LCS.CollectionStatusUid
LEFT JOIN
	CollectionStatusLevel CSL  WITH(NOLOCK)
ON
	ARP.CollectionStatusLevelUid = CSL.CollectionStatusLevelUid
LEFT JOIN
	Account  WITH(NOLOCK)
ON
	ARP.AccountResponsiblePartyUid = Account.AccountResponsiblePartyUid
LEFT JOIN
	--ViewArAccountAggregate VA
	AR_ViewAccountAggregate VA WITH(NOLOCK)
ON
	Account.AccountUid=VA.AccountUid
LEFT JOIN
	Person AcctPerson  WITH(NOLOCK)
ON
	Account.PersonUid = AcctPerson.PersonUid
INNER JOIN
	Patient  WITH(NOLOCK)
ON
	AcctPerson.PersonUid = Patient.PersonUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillCompleteBatch]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewSuperbillCompleteBatch]
AS

SELECT
SuperbillUID,
MIN(CompleteBatch) CompleteBatch
FROM
	dbo.[AR_ViewSuperbillCompleteBatchSub]
GROUP BY
SuperbillUID 	

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFinancialCenterClosingBatch]'))
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[ViewFinancialCenterClosingBatch]    
AS     
    
SELECT NEWID() AS ViewFinancialCenterClosingBatchUid, FC.FinancialCenterUid, VARB.ARBatchUid
FROM FinancialCenter FC 
INNER JOIN (SELECT BFCR.ArBatchUid, BFCR.GLDate AS ArBatchGlDate, ARB.Name AS ArBatchName, ARB.IsLocked AS ArBatchIsLocked,
					BFCR.FinancialCenterUid, FC.Name AS FinancialCenterName, FC.ExternalID AS FinancialCenterExternalId,
					FC.ARClosedThroughDate AS FinancialCenterArClosedThroughDate
				FROM AR_ViewBatchFinancialCenterRelations  BFCR  -- BMR 2016-11-03 - Removed NOEXPAND as removed SCHEMABINDING
					INNER JOIN ARBatch ARB ON BFCR.ArBatchUid = ARB.ARBatchUid
					INNER JOIN FinancialCenter FC ON BFCR.FinancialCenterUid = FC.FinancialCenterUid
					INNER JOIN AR_ViewBatchClosings VBC ON BFCR.ArBatchUid = VBC.ArBatchUid
				WHERE VBC.IsClosed = 0) ARBFCREL ON FC.FinancialCenterUid = ARBFCREL.FinancialCenterUid
INNER JOIN ViewArBatch VARB ON ARBFCREL.ArBatchUid = VARB.ArBatchUid AND VARB.IsClosed = 0





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementResponsibleParty]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewStatementResponsibleParty]  
AS   
/* This is the source for electronic statements and also for paper statements, indirectly via  
 the stored proc MDOL_RPT2_StatementHeader/ One record per responsible party with active accounts.  
 02/21/2014  - KBernecker - modified to check for existance of dunning messages before calculating the age of the superbill procedures
 08/21/2014 - kculberth - added NOLOCKs to prevent statements from causing deadlocks
 05/27/2015 - kculberth - add email1, phone1, language
 02/01/2017 - kculberth - Product Backlog Item 54937:Batch Statements Mimimum Balance Due should not exceed the actual total patient balance
 11/02/2017 - kculberth - Bug 56127:OnDemand Statements generated by Practice do not display the Responsible Party prefix/title
*/


with cte_arpsbdtable AS
(
	select * from (
		select StatementBatchDetailUid,AccountResponsiblePartyUid,sbd.FinancialCenterUid
		,ROW_NUMBER() OVER (partition by AccountResponsiblePartyUid order by sbd.lastmodifieddate desc) AS ROWNUM 
		from StatementBatchDetail sbd
		inner join StatementBatch sb on sb.StatementBatchUid = sbd.StatementBatchUid			
		where --sb.StatementActionUid = ''DD9E9ACD-0A49-44F3-B0B0-ECE163FD8D42'' -- Submit 
				--and 
				sbd.FinancialCenterUid is null
	)a
	where a.ROWNUM = 1
),
cte_DunningMsgsExist AS (
	select coalesce(dm.DunningMsg1,dm.dunningmsg2,dm.dunningmsg3,dm.dunningmsg4,'''') as DunningMsgsExist
	from DunningMsgs (NOLOCK) dm
	inner join PracticeSettings ps on dm.DunningMsgsUid = ps.DunningMsgsUid
)
,cte_DuplicatedDunningMsgs as (
	select top 1 case when dunningmsg1 is not null and ((dunningmsg1 = DunningMsg2) and (DunningMsg2 = DunningMsg3) and (DunningMsg3 = DunningMsg4) and (DunningMsg4 = DunningMsg5))
	then dunningmsg1 else NULL end as DuplicatedDunningMsg from DunningMsgs
)
,cte_dunningmsg as (
	select CASE WHEN LEN(dunningMsgsExist) = 0 THEN '''' else 	
	case when DuplicatedDunningMsg is NOT NULL THEN DuplicatedDunningMsg else
	NULL END 
	END  as DunningMsg
	FROM cte_DunningMsgsExist,
	cte_DuplicatedDunningMsgs
)


SELECT DISTINCT 
	arp.AccountResponsiblePartyUid as RPUid,   
	''00000000-0000-0000-0000-000000000000''  as FinancialCenterUid,   
	ps.Name as CustomerName,   
	ISNULL(ps.MainAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''')  AS CustomerAddress1,   
	ISNULL(ps.MainAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''')  AS CustomerAddress2,   
	ISNULL(ps.MainAddress.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''')  AS CustomerCity,   
	ISNULL(ps.MainAddress.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''')  AS CustomerState,   
	ISNULL(ps.MainAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''')  AS CustomerZip,   
	ISNULL(ps.MainAddress.value(''(/Address/Country)[1]'', ''VARCHAR(100)''),'''')  AS CustomerCountry,   
	ISNULL(ps.MainPhone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)''),'''')  AS CustomerPhone,   
	ps.Name as RemitToName,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(
	ps.MainAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToAddress1,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(
	ps.MainAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToAddress2,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToCity,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToState,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToZip,    
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Country)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/Country)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToCountry,     
	arp.ExternalID as RPID, 
	CASE WHEN p.PersonUid IS NOT NULL THEN (case when p.Prefix is null then ''''else p.Prefix + '' '' END) + ISNULL(P.FirstName,'''') + (case when p.MiddleName is null then '''' else '' '' + p.MiddleName END) +'' ''+ ISNULL(p.LastName,'''') + (case when p.Suffix is null then '''' else '', '' + p.suffix end)  ELSE c.Name END AS RPName,  
	--CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(P.FirstName,'''') + '' ''+ ISNULL(p.MiddleName,'''') +'' ''+ ISNULL(p.LastName,'''')  ELSE c.Name END AS RPName,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''), '''') END AS RPAddress1,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''), '''') END AS RPAddress2,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)''), '''') END AS RPCity,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''), '''') END AS RPState,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''), '''') END AS RPZip,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Country)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)''), '''') END AS RPCountry,   
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Email1,'''') ELSE ISNULL(c.email1,'''') END AS RPEmail1,
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.phone1.value(''(/Phone/PhoneNumber)[1]'',''VARCHAR(100)''), '''') ELSE ISNULL(c.[phone1].value(''(/Phone/PhoneNumber)[1]'',''VARCHAR(100)''), '''') END AS RPPhone1,
	ISNULL(l.name,'''') AS RPLanguage, 
	CAST(GetDate() AS DATE) as StatementDate, 
	CAST(DATEADD(day, PS.StatementDueDays, GetDate()) AS DATE) as DueDate,   
	ps.StatementMinimumAmount  AS StatementMinimumAmount,
	(CASE WHEN (collections.PaymentAmount IS NOT NULL AND collections.PaymentAmount > 0 and collections.PaymentAmount < (VA.LiabilityBalance - VA.AssignedLiabilityBalance)) THEN collections.PaymentAmount 
	 ELSE (VA.LiabilityBalance - VA.AssignedLiabilityBalance) END) AS MinimumPaymentDue,
	(VA.LiabilityBalance - VA.AssignedLiabilityBalance) AS AmountDue,  
	VA.LiabilityBalance as TotalBalance,   
	VA.AssignedLiabilityBalance as InsuranceBalance,   
	CASE WHEN (VA.LiabilityBalance - VA.AssignedLiabilityBalance) > 0 then  --Patient Balance > 0
			CASE WHEN cte_dunningmsg.DunningMsg IS NOT NULL then cte_dunningmsg.DunningMsg 
			else dbo.getStatementDunningMsg(arp.AccountResponsiblePartyUid,cte.StatementBatchDetailUid) END 
			else '''' END  as  DunningMsg,
	--CASE WHEN LEN(dunningMsgsExist) = 0 THEN '''' else dbo.getStatementDunningMsg(arp.AccountResponsiblePartyUid) END as  DunningMsg,
	dbo.getSuperbillOfResponsibleParty(arp.AccountResponsiblePartyUid) as Superbills, 	 
	ps.StatementFooter  AS StatementFooter
FROM Account (NOLOCK) a 
	INNER JOIN AccountResponsibleParty (NOLOCK) arp ON a.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid   
	INNER JOIN AR_ViewAccountResponsiblePartyAggregate_SumAccountLiabilities_Filter VA ON arp.AccountResponsiblePartyUid = VA.AccountResponsiblePartyUid  
	INNER JOIN cte_arpsbdtable cte on cte.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
	LEFT JOIN MDOL_RPT2_VIEW_AccountResponsiblePartyAccountReport collections on collections.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid and collections.CollectionStatus IS NOT NULL
	LEFT JOIN Person (NOLOCK) p ON p.PersonUid = arp.PersonUid   
	LEFT JOIN Corporation (NOLOCK) c ON c.CorporationUid = arp.CorporationUid  
	LEFT JOIN ListLanguage l WITH (NOLOCK) on l.LanguageUid = p.languageuid,
	PracticeSettings ps WITH (NOLOCK)
	,cte_dunningmsg 
WHERE a.Inactive = 0 

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindPerson]'))
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[ViewFindPerson] AS
	SELECT	p.PersonUid, p.Inactive, vp.FirstName, vp.MiddleName, vp.LastName, vp.FormattedPreferredName AS FullName, 
			vp.AkaName, p.Birthdate, vp.AkaFirstName, vp.AkaLastName, 
            vp.SocialSecurityNumber,
            pat.ExternalID AS PatientExternalID, arp.ExternalID AS ResponsiblePartyExternalID, 
            vp.Phone1, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName,
            vp.Phone2, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber2, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName2,
            vp.Phone3, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber3, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName3,
            vp.Phone4, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber4, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName4,
            vp.Address1 AS Address1Xml, vp.Address1.value(''(/Address/Address1)[1]'', ''varchar(100)'') AS Address1,
            vp.Address1.value(''(/Address/Address2)[1]'', ''varchar(100)'') AS Address2,
            vp.Address1.value(''(/Address/City)[1]'', ''varchar(100)'') AS City,
            vp.Address1.value(''(/Address/State)[1]'', ''varchar(100)'') AS State,
            vp.Address1.value(''(/Address/Zip)[1]'', ''varchar(100)'') AS Zip,                      
            cast(isnull(arp.ScheduledPaymentAllowed,0) AS bit) as ScheduledPaymentAllowed ,
            g1.ANSICode AS GenderANSICode
	FROM	Person AS p INNER JOIN
			ViewPerson AS vp ON p.PersonUid = vp.PersonUid LEFT OUTER JOIN
			ListGender AS g1 ON p.GenderUid = g1.GenderUid LEFT OUTER JOIN
			Patient AS pat ON p.PersonUid = pat.PersonUid LEFT OUTER JOIN
			AccountResponsibleParty AS arp ON p.PersonUid = arp.PersonUid






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFinancialCenterClosingDeposit]'))
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[ViewFinancialCenterClosingDeposit]    
AS     
    
SELECT NEWID() AS ViewFinancialCenterClosingDepositUid, FC.FinancialCenterUid, DP.DepositUid
FROM FinancialCenter FC 
INNER JOIN (SELECT BFCR.ArBatchUid, BFCR.GLDate AS ArBatchGlDate, ARB.Name AS ArBatchName, ARB.IsLocked AS ArBatchIsLocked,
					BFCR.FinancialCenterUid, FC.Name AS FinancialCenterName, FC.ExternalID AS FinancialCenterExternalId,
					FC.ARClosedThroughDate AS FinancialCenterArClosedThroughDate
				FROM AR_ViewBatchFinancialCenterRelations  BFCR -- BMR 2016-11-03 - Removed NOEXPAND as removed SCHEMABINDING
					INNER JOIN ARBatch ARB ON BFCR.ArBatchUid = ARB.ARBatchUid
					INNER JOIN FinancialCenter FC ON BFCR.FinancialCenterUid = FC.FinancialCenterUid
					INNER JOIN AR_ViewBatchClosings VBC ON BFCR.ArBatchUid = VBC.ArBatchUid
				WHERE VBC.IsClosed = 0) ARBFCREL ON FC.FinancialCenterUid = ARBFCREL.FinancialCenterUid
INNER JOIN ViewArBatch VARB ON ARBFCREL.ArBatchUid = VARB.ArBatchUid AND VARB.IsClosed = 0
INNER JOIN Deposit DP ON VARB.ArBatchUid = DP.ArBatchUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementResponsiblePartyStringDates]'))
EXEC dbo.sp_executesql @statement = N'



--06/28/2016 kculberth add statement footer

CREATE VIEW [dbo].[ViewStatementResponsiblePartyStringDates]
AS

SELECT     RPUid, FinancialCenterUid, CustomerName, CustomerAddress1, CustomerAddress2, CustomerCity, CustomerState, CustomerZip, CustomerPhone, RemitToName, 
                      RemitToAddress1, RemitToAddress2, RemitToCity, RemitToState, RemitToZip, RPID, RPName, RPAddress1, RPAddress2, RPCity, RPState, RPZip, 
                      RPEmail1, RPPhone1, RPLanguage, CONVERT(varchar(10), StatementDate, 120) AS StatementDate, CONVERT(varchar(10), DueDate, 120) AS DueDate, MinimumPaymentDue, AmountDue, TotalBalance, InsuranceBalance, 
                      DunningMsg,StatementFooter, 
					  RTRIM(SUBSTRING((SELECT top 6 name + ''  '' AS ''data()'' 
						FROM listpaymenttype pt 
						WHERE InternalCardType IS NOT NULL AND Inactive=0 Order by Name
						FOR XML PATH('''')),1,80)) AS PaymentTypes
FROM         dbo.ViewStatementResponsibleParty


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementLineItem]'))
EXEC dbo.sp_executesql @statement = N'

--20150109 - kculberth - add statement notes from reason codes - bug 33625
--02/02/2017 - kculberth - Bug 51825:Statements-CHC Payer Setting Encounter codes need to print on statement if there is a patient liability for this code.

CREATE VIEW [dbo].[ViewStatementLineItem]  
AS 

--NEW
WITH cteWhoPaidName --Stolen from ViewDeposit
AS
-- Define the CTE query.
(
SELECT d.deposituid,
      ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumber, -- mark as <ND> so can hyperlink on null values
      (CASE WHEN p.PersonUid IS NOT NULL THEN p1.FormattedPreferredName
       WHEN icArp.CorporationUid IS NOT NULL THEN icArp.Name
       WHEN LD.InsurancePayerUid IS NOT NULL THEN ic.Name END) AS WhoPaidName,
       L.EntryType  
FROM Deposit d
            INNER JOIN AR_LedgerDetail (NOLOCK) LD ON d.DepositUid = LD.DepositUid
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid
            LEFT OUTER JOIN AR_Ledger (NOLOCK) arlVoid on L.LedgerUid = arlVoid.VoidLedgerUid      -- Checks for voiding entries                                       
            LEFT JOIN AccountResponsibleParty (NOLOCK) arp on LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid            
            LEFT JOIN Person (NOLOCK) p ON arp.PersonUid = p.PersonUid 
            LEFT JOIN Corporation (NOLOCK) icArp ON arp.CorporationUid = icArp.CorporationUid
            LEFT JOIN Corporation (NOLOCK) ic ON ic.CorporationUid = LD.InsurancePayerUid 
            LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = p.PersonUid              
WHERE (L.EntryType = 0 -- Payment
	   OR L.EntryType = 3) -- Adjustment
       AND  (L.VoidLedgerUid IS NULL AND arlVoid.LedgerUid IS NULL) -- Don''t include reversing(void) entries
       AND LD.IsCredit = 1                                              
       AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits    
),

cteLastFiledDate --
AS
-- Define the CTE query.
(
	SELECT SA.SuperbillUid,SA.LastFiledDate
	FROM SuperbillAggregate SA
)
SELECT
	FinancialCenterUid,  
	ItemUid,   
	RPUid,     
	''Header'' AS Type, 
	2 AS DisplayOrder, 
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	NULL AS ItemDate,   
	NULL AS CreditGroupUid,   
	0 AS IsPayment,   
	NULL AS CreditUid,   
	0 AS CreditSubOrder,   
	'''' AS WhoPaid,
	PatientName + '' / '' +  RenderingProviderName + Coalesce(ISNULL(ReferringProviderName,NULL), ReferringProviderName,'''') AS Description, 
	CONVERT(Money, 0) Charge, 
	CONVERT(Money, 0) Insurance, 
	CONVERT(Money, 0) Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM  
( 
	SELECT   
		LD.FinancialCenterUid,  
		S.SuperbillUid AS ItemUid,   
		A.AccountResponsiblePartyUid AS RPUid,     
		p1.FormattedPreferredName AS PatientName,  
		p2.FormattedPreferredName AS RenderingProviderName, 
		A.ExternalID AS AccountID,   
		S.ExternalID AS SuperbillID,   
		S.SuperbillUid,   
		S.ServiceDateStart AS SuperbillDate,   
		(CASE WHEN (ps.IncludeReferringProvider = 1) THEN ('' / '' + p3.FormattedPreferredName)
			ELSE NULL END) AS ReferringProviderName, 
		--VSC.CompleteBatch AS IsSuperBilCompleteBatch,   
		(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch      
	FROM   
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid 
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid		  
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS 
	WHERE rpsss.superbillstatusuid is null and
		((L.EntryType = 1 OR L.EntryType = 4) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null))
		AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
) A 
GROUP BY   
	FinancialCenterUid,  
	ItemUid,   
	RPUid,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	ReferringProviderName
	  
UNION ALL

SELECT   
	FinancialCenterUid,  
	ItemUid,   
	RPUid,   
	''Charge'' AS Type,   
	4 AS DisplayOrder,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	ItemDate,   
	NULL AS CreditGroupUid,   
	0 AS IsPayment,   
	NULL AS CreditUid,   
	0 AS CreditSubOrder,   
	'''' AS WhoPaid,   
	Description,   
	Charge,   
	Sum(Insurance) AS Insurance,  
	Sum(Patient) AS Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM  
(  
	SELECT   
		LD.FinancialCenterUid,  
		LD.SuperbillProcedureUid AS ItemUid,   
		A.AccountResponsiblePartyUid AS RPUid,   
		p1.formattedPreferredName AS PatientName,
		p2.formattedPreferredName AS RenderingProviderName,
		A.ExternalID AS AccountID,   
		S.ExternalID AS SuperbillID,   
		S.SuperbillUid,   
		S.ServiceDateStart AS SuperbillDate,   
		SP.ProcedureServiceDateStart AS ItemDate,   
		(CASE WHEN (PS.IncludeProcedureCode= 1)   
			THEN ISNULL(LP.Code, '''') + ISNULL('' '' + LP.ShortDescription, '''')  
			ELSE ISNULL('' '' + LP.ShortDescription, '''') END) AS Description,   
		COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS Charge,   
		(CASE WHEN LD.LiabilityOwner > 0   THEN LD.Amount ELSE Convert(Money, 0) END) AS Insurance, 
		(CASE WHEN LD.LiabilityOwner = 0 THEN LD.Amount ELSE Convert(Money, 0) END) AS Patient,  
		--VSC.CompleteBatch AS IsSuperBilCompleteBatch,   
		(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch   
	FROM  
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		INNER JOIN ListProcedure (NOLOCK) LP ON SP.ProcedureUid = LP.ProcedureUid  
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid		     
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS 
	WHERE rpsss.superbillstatusuid is null and
		((L.EntryType = 1 OR L.EntryType = 4) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null))
		AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
) B  
GROUP BY   
	FinancialCenterUid,  
	ItemUid,   
	RPUid,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	ItemDate,   
	Description,   
	Charge
	
UNION ALL

SELECT   
      FinancialCenterUid,  
      ItemUid,  
      RPUid,   
      Type,   
      Case When Type=''Payment'' Then 5 ELSE 6 END as DisplayOrder,   
      PatientName,   
      RenderingProviderName,   
      AccountID,   
      SuperbillID,   
      SuperbillUid,   
      SuperbillDate,   
      MIN(ItemDate) as ItemDate,   
      CreditGroupUid,  
      IsPayment,   
      CreditUid,   
      2 as CreditSubOrder,   
      WhoPaid,   
      Description,  
      CONVERT(Money, 0) as Charge,   
      SUM(Insurance) as Insurance,   
      SUM(Patient) as Patient,
      0 as Amount, 
      0 AS Age,
      NULL AS SuperbillProcedureUid,  
      0 AS TotalCharge,  
      NULL AS LastFiledDate,  
      '''' AS ReferenceNumber,  
      '''' AS ReferringProviderName,   
      '''' AS InsuranacePlan,  
      0 AS IsSuperBilCompleteBatch,       
      1 AS CompleteBatch,
      0 AS DisplayOrder2  
FROM  
( 
      SELECT   
            LD.FinancialCenterUid,  
            (Case When LCT.Name = ''Patient Payment'' AND D.DepositUid is not null Then D.DepositUid ELSE 
             CASE When LCT.Name = ''PatientPayment'' AND D.DepositUid is null Then LD.FinancialCenterUid ELSE LD.FinancialCenterUid END END) AS ItemUid, 
            A.AccountResponsiblePartyUid as RPUid,   
            (Case When L.EntryType  = 2 Then ''Payment'' Else ''Adjustment'' END) as Type,   
            p1.FormattedPreferredName as PatientName,
            p2.FormattedPreferredName as RenderingProviderName,
            A.ExternalID as AccountID,   
            S.ExternalID as SuperbillID,   
            S.SuperbillUid,   
            S.ServiceDateStart as SuperbillDate,   
            ARB.GLDate as ItemDate,   
            LD.FinancialCenterUid  CreditGroupUid,  
            (Case When L.EntryType = 2 Then 1 Else 0 END) IsPayment,   
            LD.FinancialCenterUid CreditUid,   
            LDOS.AccountResponsiblePartyUid as WhoPaidPersonUid,
            LDOS.InsurancePayerUid as WhoPaidInsuranceCarrierUid,
            WhoPaid.WhoPaidName AS WhoPaid, 
            WhoPaid.ReferenceNumber AS ReferenceNumber,
            (CASE WHEN L.EntryType != 2
				  THEN ISNULL(LCT.Name,'''')
				  ELSE
				     (CASE WHEN PS.IncludePaymentReferenceNumber = 1 
					  THEN 
                         ISNULL(LCT.Name,'''') + '' Ref #'' + ISNULL(WhoPaid.ReferenceNumber,''N/A'') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
                      ELSE ISNULL(LCT.Name,'''') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
                      END)
              END) as Description,
            (Case When LD.LiabilityOwner > 0 Then (LD.Amount) Else Convert(Money, 0) END) as Insurance,   
            (Case When LD.LiabilityOwner = 0 Then (LD.Amount) Else Convert(Money, 0) END) as Patient,  
            p3.FormattedPreferredName as ReferringProviderName,
            (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch
      FROM  
            AR_LedgerDetail (NOLOCK) LD
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid        
			LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
			INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
            INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
            INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
            INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid                        
            --LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = LDOS.DepositUid
			LEFT JOIN AR_Transaction T ON L.TransactionUid = T.TransactionUid 
			LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = T.DepositUid            
            LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
            LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
            LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
            LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid   
			LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	
            LEFT JOIN cteWhoPaidName AS whoPaid ON d.depositUid = WhoPaid.deposituid --and d.referencenumber = WhoPaid.referencenumber
			LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
			ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
			CROSS JOIN PracticeSettings (NOLOCK) PS 
		WHERE rpsss.superbillstatusuid is null and
            ((L.EntryType=2 OR L.EntryType=3) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 1)
			AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
      ) B                
GROUP BY  
      FinancialCenterUid,  
      ItemUid,  
      RPUid,   
      Type,   
      PatientName,   
      RenderingProviderName,   
      AccountID,   
      SuperbillID,   
      SuperbillUid,   
      SuperbillDate,  
      CreditGroupUid,   
      IsPayment,   
      CreditUid,   
      WhoPaid,   
      Description,  
      ReferringProviderName,
      ReferenceNumber

UNION ALL

--NEW COMMENT

SELECT   
	LD.FinancialCenterUid,  
	CB.ClaimBatchUid as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Comment'' as Type,   
	6 as DisplayOrder,   
	p1.FormattedPreferredName as PatientName,
	p2.FormattedPreferredName as RenderingProviderName,
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	max(CB.ClaimDate) as ItemDate,   
	NULL as CreditGroupUid,   
	0 as IsPayment,   
	NULL as CreditUid,   
	0 as CreditSubOrder,   
	'''' as WhoPaid,   
	(dbo.ARFN_getInsLevelName(CB.InsuranceOrder) + '' claim filed to '' + ISNULL(C.Name,'''') + 
	(CASE WHEN (ps.IncludelastFileDate = 1) THEN ('' on '' + (CONVERT(VARCHAR, lfd.LastFiledDate, 101)))
			ELSE '''' END)) AS Description,   
	CONVERT(Money, 0) as Charge,   
	CONVERT(Money, 0) as Insurance,   
	CONVERT(Money, 0) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	lfd.LastFiledDate AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM 
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation (NOLOCK) C ON IP.InsuranceCarrierUid = C.CorporationUid   
		LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = s.ReferringProviderUid  
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid			 
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS 
WHERE rpsss.superbillstatusuid is null and 
	  ((L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 0  AND (L.EntryType = 1))
	  AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
GROUP BY   
 LD.FinancialCenterUid,  
 CB.ClaimBatchUid,   
 A.AccountResponsiblePartyUid,   
 S.PatientUid,   
 LD.RenderingProviderUid,  
 A.ExternalID,  
 S.ExternalID,   
 S.SuperbillUid,   
 S.ServiceDateStart,   
 CB.ClaimDate,
 lfd.LastFiledDate, 
 CB.InsuranceOrder,   
 C.Name,  
 S.ReferringProviderUid,  
 PS.IncludeLastFileDate,
 P1.FormattedPreferredName,
 p2.FormattedPreferredName,
 p3.FormattedPreferredName   

UNION ALL
--NEW Comment 2  
--Statement notes from credits. Associated with the payments AND adjustments, so use the same display ORder  
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
SELECT   
	LD.FinancialCenterUid,  
	LD.LedgerDetailUid as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Comment'' as Type,   
	(CASE WHEN L.EntryType = 2 THEN 5 
	WHEN L.EntryType = 3 THEN 6
	WHEN L.EntryType = 4 THEN 7
	ELSE 6 END) as DisplayOrder,   
	p1.FormattedPreferredName as PatientName, 
	p2.FormattedPreferredName as RenderingProviderName,
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	D.DepositDate as ItemDate,   
	LD.LedgerDetailUid AS CreditGroupUid,  
	(Case When L.EntryType = 2 Then 1 Else 0 END) IsPayment,   
	LD.LedgerDetailUid AS CreditUid,  
	4 as CreditSubOrder,   
	'''' as WhoPaid,   
	L.StatementNote as Description,   
	Convert(Money, 0) as Charge,   
	Convert(Money, 0) as Insurance,   
	Convert(Money, 0) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	 
	(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch,
	0 AS DisplayOrder2     
FROM 
	AR_LedgerDetail (NOLOCK) LD
	INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
	INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid     		
	LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = LDOS.DepositUid
	LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
	LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid 
	LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
  WHERE rpsss.superbillstatusuid is null and	  
	 ((L.StatementNote is NOT NULL OR L.StatementNote != '''')   
	 AND (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
	 AND (L.EntryType=2 OR L.EntryType=3 OR L.EntryType=4) AND LD.IsCredit = 1)  			
	 AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
 UNION ALL
--Remark notes from reason codes. Associated with procedures
SELECT DISTINCT  
	LD.FinancialCenterUid,  
	NULL as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Comment'' as Type,   
	6 as DisplayOrder,   
	p1.FormattedPreferredName as PatientName, 
	NULL as RenderingProviderName,
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	NULL as ItemDate,   
	NULL AS CreditGroupUid,  
	0 as IsPayment,   
	NULL AS CreditUid,  
	4 as CreditSubOrder,   
	'''' as WhoPaid,   
	adj.StatementNote as Description,   
	Convert(Money, 0) as Charge,   
	Convert(Money, 0) as Insurance,   
	Convert(Money, 0) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	 
	NULL CompleteBatch,
	0 AS DisplayOrder2      
FROM Superbill (NOLOCK) S 
	INNER JOIN SuperbillProcedure SP WITH (NOLOCK) ON SP.superbilluid = S.superbilluid
	INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SP.SuperbillProcedureUid = LD.SuperbillProcedureUid
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid   
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	left join cobclaimdetail cob on cob.superbilluid = s.superbilluid
	left join COBLineAdjustments adj on adj.cobclaimdetailuid = cob.cobclaimdetailuid and adj.superbillprocedureuid = sp.superbillprocedureuid and adj.Notes IS NOT NULL
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	
WHERE rpsss.superbillstatusuid is null and
	(adj.StatementNote is NOT NULL OR adj.StatementNote != '''')  
	 AND (chc.patientliability <> 0 OR chc.patientliability IS NULL) 			
UNION ALL
--NEW Subtotal
SELECT 
	LD.FinancialCenterUid,  
	S.SuperbillUid as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Subtotal'' as Type,   
	8 as DisplayOrder,   
	p1.FormattedPreferredName as PatientName,
	p2.FormattedPreferredName as RenderingProviderName, 
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	NULL as ItemDate,   
	NULL as CreditGroupUid,   
	0 as IsPayment,   
	NULL as CreditUid,   
	0 as CreditSubOrder,   
	'''' as WhoPaid,   
	''Balance Superbill '' + ISNULL(''#'' + S.ExternalID, Convert(Varchar, dbo.UDF_utcToCurrentDate(S.ServiceDateStart), 101)) as Description,   
	Sum(case when L.EntryType= 1 OR L.EntryType=4 then LD.Amount else 0 END) as Charge,   
	Sum(Case When LD.LiabilityOwner > 0 Then LD.Amount Else Convert(Money, 0) END) as Insurance,   
	Sum(Case When LD.LiabilityOwner = 0 Then LD.Amount Else Convert(Money, 0) END) as Patient, 
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	 
	1  CompleteBatch,
	0 AS DisplayOrder2  
FROM 
	AR_LedgerDetail (NOLOCK) LD
	INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid    
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
	LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid 
	LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	CROSS JOIN PracticeSettings (NOLOCK) PS 
WHERE rpsss.superbillstatusuid is null and
	 ((L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null))
	 AND (chc.patientliability <> 0 OR chc.patientliability IS NULL) 		
GROUP BY   
	LD.FinancialCenterUid,  
	S.SuperbillUid,   
	A.AccountResponsiblePartyUid,   
	S.PatientUid,   
	LD.RenderingProviderUid,  
	S.ServiceDateStart,   
	A.ExternalID,  
	S.ExternalID,   
	S.ReferringProviderUid,  
	P1.FormattedPreferredName,
	p2.FormattedPreferredName,
	p3.FormattedPreferredName 		



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementBalanceandAge_MainAccount]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewStatementBalanceandAge_MainAccount]   
AS  
SELECT  
-- dbo.Charge.ChargeUid  
 A.AccountResponsiblePartyUid,   
 LD.FinancialCenterUid,  
 LD.LiabilityOwner,  
 (CASE WHEN ld.Amount <0 THEN  isnull(VSP.LiabilityBalance - VSP.AssignedLiabilityBalance,0) * -1 ELSE  isnull(VSP.LiabilityBalance - VSP.AssignedLiabilityBalance,0) END)  AS BalanceAll,  
 ARB.GLDate as LiabilityDate   
FROM  
 AR_Ledger L  
INNER JOIN  
 AR_LedgerDetail LD  
ON  
 L.LedgerUid=LD.LedgerUid AND (L.EntryType=1 OR L.EntryType=4)  --AND LD.IsCredit=0  
JOIN
 ARBatch ARB
ON
 L.ArBatchUid =ARB.ARBatchUid 
INNER JOIN  
 AR_ViewSuperbillProcedureAggregate VSP  
ON  
 LD.SuperbillProcedureUid= VSP.SuperbillProcedureUid  
INNER JOIN  
 SuperbillProcedure SP  
ON  
 SP.SuperbillProcedureUid=LD.SuperbillProcedureUid  
INNER JOIN  
 Superbill S  
ON  
 S.SuperbillUid=SP.SuperbillUid  
INNER JOIN  
 Account A  
ON  
 S.AccountUid = A.AccountUid  
WHERE  
 (VSP.LiabilityBalance - VSP.AssignedLiabilityBalance) > 0 AND LD.LiabilityOwner = 0  
 AND A.IsMain = 1  
 AND SP.SuperbillUid NOT IN  
             (  
                 SELECT SuperbillUid FROM [ViewStatementLineItem]  
                 WHERE Type=''subtotal''  
                 AND Patient=0  
             )   



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindUser]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewFindUser]
AS
SELECT		vp.PersonUid, 
			COALESCE(u.ExternalID, u.Login) AS ExternalID, u.Inactive, 
			u.[Login], 
			vp.Prefix, vp.FirstName, vp.MiddleName, vp.LastName, vp.Suffix,
			vp.AkaLastName + '', '' + vp.AkaFirstName AS AKAName,
			vp.FormattedInternalName,
			COALESCE(vp.AkaFirstName, '''') AS AkaFirstName, COALESCE(vp.AkaLastName, '''') AS AkaLastName,
			CASE WHEN prov.PersonUid IS NULL THEN ''USER'' ELSE ''Provider'' END AS Type, ims.Name as InstantMessageStatus,
			p.Notes, CAST(NULL AS VARCHAR(255)) AS DirectMailAddress, CAST(NULL AS VARCHAR(255)) AS [Password], 
			CAST(NULL AS UNIQUEIDENTIFIER)TransmissionConfigurationUid
FROM        Person p INNER JOIN UserPRM u ON p.PersonUid = u.PersonUid 
			INNER JOIN ViewPerson vp ON p.PersonUid = vp.PersonUid
			LEFT JOIN Provider prov ON u.PersonUid = prov.PersonUid
			LEFT JOIN ListInstantMessageStatus ims on u.InstantMessageStatusUid = ims.InstantMessageStatusUid			
			-- LEFT JOIN DirectMailUser dmu on prov.PersonUid = dmu.ProviderUid AND dmu.Inactive=0 
				-- AND dmu.IsUser = 1 -- Bug 39120 Removed Join - Causing Duplicates - Review Notes IN Bug
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewVisitFilter]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewVisitFilter] AS

WITH cteVisitLockInfo AS
(
	SELECT LSV.VisitUid, ROW_NUMBER() OVER (PARTITION BY LSV.VisitUid ORDER BY LSV.LockDateStart) AS RowNo, 
	LSV.LockUid, PNS.FullName, LSV.HostName, LSV.LockDate, LSV.LockDateStart 
	FROM
	(
		SELECT VS.VisitUid, L.LockByUid,
		L.LockUid, L.HostName, L.LockDate, L.LockDateStart
		FROM Lock L
		INNER JOIN Visit VS ON L.LockedUid = VS.VisitUid
		UNION
		SELECT VS.VisitUid, L.LockByUid,
		L.LockUid, L.HostName, L.LockDate, L.LockDateStart
		FROM Lock L
		INNER JOIN Visit VS ON L.LockedUid = VS.VisitUid
	) LSV
	INNER JOIN ViewPerson PNS ON LSV.LockByUid = PNS.PersonUid
)
-- don''t know why FullName was renamed to Patient but FullName is needed so adding it back but leaving Patient alias also
SELECT		v.VisitUid, v.VisitDate, v.IsCompleted, 
			appt.Reason, appt.CheckinDateTime, appt.DischargeDateTime, appt.AppointmentStatusUid, 
            appt.AppointmentTypeUid, appt.CalendarUid, c.[Name] AS Calendar,
			v.PatientUid, pat.FullName, pat.FullName AS Patient, pat.ExternalID AS PatientID, pat.MedicalRecordNumber, pat.Birthdate,
            v.ProviderUid, 
            dbo.UDF_GetFormattedInternalName(prov.FirstName, prov.MiddleName, prov.LastName, prov.AkaFirstName, prov.AkaLastName) AS Provider, 
            v.RenderingProviderUid, 
            dbo.UDF_GetFormattedInternalName(rendProv.FirstName, rendProv.MiddleName, rendProv.LastName, rendProv.AkaFirstName, rendProv.AkaLastName) AS RenderingProvider, 
            v.ServiceSiteUid, ss.Name AS ServiceSite, 
            v.LastModifiedDate, v.LastModifiedByUid, 
            dbo.UDF_GetFormattedInternalName(usr.FirstName, usr.MiddleName, usr.LastName, usr.AKAName, usr.AkaLastName) AS LastModifiedBy, 
            v.LastSavedByUid, 
            dbo.UDF_GetFormattedInternalName(lsUser.FirstName, lsUser.MiddleName, lsUser.LastName, lsUser.AKAName, lsUser.AkaLastName) AS LastSavedBy, 
            vc.CosignUid AS CosignProviderUid, 
            dbo.UDF_GetFormattedInternalName(coProv.FirstName, coProv.MiddleName, coProv.LastName, coProv.AkaFirstName, coProv.AkaLastName) AS CosignProvider, 
            vc.CompletedUid AS CompletedProviderUid, 
            dbo.UDF_GetFormattedInternalName(cmpProv.FirstName, cmpProv.MiddleName, cmpProv.LastName, cmpProv.AkaFirstName, cmpProv.AkaLastName) AS CompletedProvider, 
            ISNULL(vc.IsCompleted, 0) AS CoSignCompleted, 
            CAST(CASE WHEN vc.IsApproved = 1 THEN 1 WHEN vc.IsApproved = 2 AND vc.IsCompleted = 1 AND v.VisitDate < DATEADD(MM, -6, GETUTCDATE()) THEN 1 ELSE 0 END AS BIT) AS IsApproved, 
            ISNULL(vc.IsMessage, 0) AS IsMessage, vc.ForwardDate, vc.LastModifiedDate AS CosignLastModifiedDate, va.DateRecorded, va.DateSent, 
            va.DateReceived, va.DateMerged, ts.TranscriptionStatusUid, ts.Name AS TranscriptionStatus, ts.Color AS TranscriptionStatusColor, 
            va.TranscriptionistUid, trans.FullName AS Transcriptionist, 
            ISNULL(visitType.Name, ''Standard'') AS VisitTypeName,
			v.AppointmentUid,
            VLI.LockUid, VLI.FullName AS LockedByUserName, VLI.HostName AS LockedByHostName,
			VLI.LockDate AS LockedDate, VLI.LockDateStart AS LockedDateStart,
			(SELECT TOP 1 Name FROM Superbill s INNER JOIN ListSuperbillStatus ss ON s.SuperbillStatusUid = ss.SuperbillStatusUid WHERE s.VisitUid = v.VisitUid ORDER BY ss.DisplayOrder) AS SuperbillStatus,
			cnt.Name as [ClinicalNoteType]
FROM        Visit AS v INNER JOIN ViewFindPatient AS pat ON v.PatientUid = pat.PersonUid 
			INNER JOIN ViewProvider AS prov ON v.ProviderUid = prov.PersonUid 
			LEFT JOIN ViewProvider AS rendProv ON v.RenderingProviderUid = rendProv.PersonUid 
			LEFT JOIN ListServiceSite AS ss ON v.ServiceSiteUid = ss.ServiceSiteUid 
			LEFT JOIN ViewFindUser AS usr ON v.LastModifiedByUid = usr.PersonUid 
			LEFT JOIN ViewFindUser AS lsUser ON v.LastSavedByUid = lsUser.PersonUid 
			LEFT JOIN VisitCoSign AS vc ON v.VisitUid = vc.VisitUid 
			LEFT JOIN ViewProvider AS coProv ON vc.CosignUid = coProv.PersonUid 
			LEFT JOIN ViewProvider AS cmpProv ON vc.CompletedUid = cmpProv.PersonUid 
			LEFT JOIN VoiceAttachment AS va ON v.VoiceAttachmentUid = va.AttachmentUid 
			LEFT JOIN ViewPerson AS trans ON va.TranscriptionistUid = trans.PersonUid 
			LEFT JOIN ListTranscriptionStatus AS ts ON dbo.GetVoiceAttachmentStatus(va.DateRecorded, va.DateSent, va.DateReceived, va.DateMerged, va.ReadyToTranscribe) = ts.Name 
			LEFT JOIN Appointment AS appt ON v.AppointmentUid = appt.AppointmentUid 
			LEFT JOIN ListCalendar c ON appt.CalendarUid = c.CalendarUid
            LEFT JOIN ListVisitType AS visitType ON v.VisitTypeUid = visitType.VisitTypeUid
			LEFT JOIN cteVisitLockInfo VLI ON v.VisitUid = VLI.VisitUid AND VLI.RowNo = 1
			LEFT JOIN ListClinicalNoteType cnt ON v.ClinicalNoteTypeUid = cnt.ClinicalNoteTypeUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountResponsiblePartyAggregate_SumAccountLiabilities]'))
EXEC dbo.sp_executesql @statement = N'

--20160128 - kculberth - add nolocks

CREATE VIEW [dbo].[AR_ViewAccountResponsiblePartyAggregate_SumAccountLiabilities] 
AS
SELECT AC.AccountResponsiblePartyUid, 
	SUM(ISNULL(VSA.Liability,0)) AS Liability, 
	SUM(ISNULL(VSA.AssignedLiability,0)) AS AssignedLiability,
	SUM(ISNULL(VSA.LiabilityBalance,0)) AS LiabilityBalance, 
	SUM(ISNULL(VSA.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance
FROM Account AC WITH (NOLOCK)
LEFT JOIN Superbill SB WITH (NOLOCK) ON AC.AccountUid = SB.AccountUid
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub VSA WITH (NOEXPAND) ON SB.SuperbillUid = VSA.SuperbillUid
GROUP BY AC.AccountResponsiblePartyUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountResponsiblePartyAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewAccountResponsiblePartyAggregateSub] WITH SCHEMABINDING  
AS  
SELECT AccountResponsiblePartyUid,         
		SUM(CASE WHEN IsCredit = 0 THEN 0 ELSE AMOUNT*-1 END) As Receipt,        
		SUM(Amount*-1) As ReceiptBalance, COUNT_BIG(*) AS Count  
	FROM dbo.AR_LedgerDetail    
	WHERE NOT AccountResponsiblePartyUid IS NULL  GROUP BY AccountResponsiblePartyUid        

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE CLUSTERED UNIQUE INDEX PK_AR_ViewAccountResponsiblePartyAggregateSub_AccountResponsiblePartyUid ON AR_ViewAccountResponsiblePartyAggregateSub(AccountResponsiblePartyUid) 

*/

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountResponsiblePartyAggregateSub]') AND name = N'PK_AR_ViewAccountResponsiblePartyAggregateSub_AccountResponsiblePartyUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewAccountResponsiblePartyAggregateSub_AccountResponsiblePartyUid] ON [dbo].[AR_ViewAccountResponsiblePartyAggregateSub]
(
	[AccountResponsiblePartyUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountResponsiblePartyAggregate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewAccountResponsiblePartyAggregate] 
AS
SELECT ARP.AccountResponsiblePartyUid, 
	ISNULL(VARPAB.Receipt, 0) AS Receipt,
	ISNULL(VARPAB.ReceiptBalance, 0) AS ReceiptBalance,
	ISNULL(SAL.Liability, 0) AS Liability, 
	ISNULL(SAL.AssignedLiability, 0) AS AssignedLiability,
	ISNULL(SAL.LiabilityBalance, 0) AS LiabilityBalance, 
	ISNULL(SAL.AssignedLiabilityBalance, 0) AS AssignedLiabilityBalance
FROM AccountResponsibleParty ARP
LEFT JOIN AR_ViewAccountResponsiblePartyAggregateSub (NOEXPAND) VARPAB ON ARP.AccountResponsiblePartyUid = VARPAB.AccountResponsiblePartyUid
LEFT JOIN AR_ViewAccountResponsiblePartyAggregate_SumAccountLiabilities SAL ON ARP.AccountResponsiblePartyUid = SAL.AccountResponsiblePartyUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillFollowup]'))
EXEC dbo.sp_executesql @statement = N'/*
	Bug 55790:Track Superbills Screen -Change the Followup – Multicolumn (change to no nulls)
	2017-02-22	BMR	Add FIXED UID for NULL rows to support Multi Column Primary Key 
					Also insure every superbill has a corresponding row even where no followup notes
	2017-03-01      BMR      Add Filter where Modifies are both null, with above, this should flag as a FollowupAll				
*/

CREATE VIEW [dbo].[ViewSuperbillFollowup] 
AS

WITH cteSuperbillFollowupAll AS
(
SELECT  RR.SuperbillUid, RR.LastModifiedByUid, LastModifiedDate
        FROM eReportRows RR WITH (NOLOCK)
        WHERE (followup = 1) AND (NOT RR.SuperbillUid IS NULL)
),
cteSuperbillFollowupAllDistinct AS
(
SELECT  DISTINCT SBFA.SuperbillUid, SBFA.LastModifiedByUid
	FROM cteSuperbillFollowupAll SBFA
),
cteBasicFollowup AS
(
SELECT  DISTINCT SBFA.SuperbillUid, 
		(SELECT TOP 1 LastModifiedDate FROM cteSuperbillFollowupAll 
			WHERE superbillUid = SBFA.SuperbillUid 
				ORDER BY LastModifiedDate DESC) AS MaxFollowupModifiedDate,
		-- IN ORDER TO SUPPORT MULTICOLUMN PRIMARY KEY, INSURE NOT NULL -- NULL = ''EDDE7773-BC99-41C4-8967-CD1B7308FBBF''
		CAST(ISNULL(SBFA.LastModifiedByUid, ''EDDE7773-BC99-41C4-8967-CD1B7308FBBF'') AS UNIQUEIDENTIFIER) AS LastFollowupModifiedByUid,
		(SELECT TOP 1 LastModifiedDate FROM cteSuperbillFollowupAll 
			WHERE superbillUid = SBFA.SuperbillUid 
					AND ((LastModifiedByUid = SBFA.LastModifiedByUid) 
						OR (LastModifiedByUid IS NULL AND SBFA.LastModifiedByUid IS NULL))
				ORDER BY LastModifiedDate DESC) AS LastFollowupModifiedDate
	FROM cteSuperbillFollowupAllDistinct SBFA
UNION
SELECT SB.SuperbillUid, NULL AS MaxFollowupModifiedDate, ''EDDE7773-BC99-41C4-8967-CD1B7308FBBF'' AS LastFollowupModifiedByUid, NULL AS LastFollowupModifiedDate
	FROM Superbill SB WITH (NOLOCK)
		LEFT JOIN (SELECT DISTINCT SuperbillUid FROM cteSuperbillFollowupAllDistinct) SBFADS ON SB.SuperbillUid = SBFADS.superbillUid -- pulling unmatchinig so that view returns at least one row for EVERY superbill
	WHERE SBFADS.superbillUid IS NULL
)
SELECT *, CAST(0 AS BIGINT) AS LastFollowupByUser, 
		CAST((CASE WHEN (LastFollowupModifiedDate = MaxFollowupModifiedDate) OR (LastFollowupModifiedDate IS NULL AND MaxFollowupModifiedDate IS NULL) 
			THEN 1 ELSE 0 END) AS BIGINT) LastFollowupAll
	FROM cteBasicFollowup 










' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewInsurancePlan]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewInsurancePlan] AS
SELECT	ip.InsurancePlanUid, ip.Name AS InsurancePlan, 
		ic.CorporationUid AS InsuranceCarrierUid, 
		c.Name AS InsuranceCarrier, c.Name + ''/'' + ip.Name AS Name,
		ip.ExternalID, ip.Inactive | ic.Inactive AS Inactive,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address] ELSE ip.[Address] END AS [Address],
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') END AS Address1,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') END AS Address2,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') END AS City,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'') END AS [State],
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') END AS Zip,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') END AS Country,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Phone1] ELSE ip.[Phone] END AS Phone,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Phone1].value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') ELSE ip.[Phone].value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') END AS PhoneNumber,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Phone1].value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') ELSE ip.[Phone].value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') END AS PhoneType,
		CASE WHEN ip.UseInsuranceCarrierAccountType=1 THEN ic.AccountTypeUid ELSE ip.AccountTypeUid END AS AccountTypeUid,
		ip.Notes, ic.ExternalID AS InsuranceCarrierExternalID
FROM	InsurancePlan AS ip INNER JOIN InsuranceCarrier AS ic ON ip.InsuranceCarrierUid = ic.CorporationUid INNER JOIN
        Corporation AS c ON ic.CorporationUid = c.CorporationUid 





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillProcedureFullInsurance]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbillProcedureFullInsurance] AS
       SELECT SBP.SuperbillProcedureUid, SBP.ProcedureUid, SBP.Code, SBP.DisplayOrder, SBP.ProcedureCharge, SBP.ProcedureAllowed, SBP.Units, SBP.InsurancePercent,
                        SBP.FixedCopayAmount, SBP.TotalTax, SBP.DontClaim, SBP.TotalAllowed, SBP.Modifiers, SBP.Diagnoses, SBP.SuperbillUid,
                     SBP.SuperbillExternalId AS ExternalID,
                     SBP.PersonUid AS PatientUid, SBP.PatientFormattedName AS PatientName,
                     SBP.RenderingProviderUid, SBP.RenderingProviderFormattedInternalName AS RenderingProviderName,
                     SBP.ClaimingProviderUid, SBP.ClaimingProviderFormattedInternalName AS ClaimingProviderName, 
					 SBP.ReferringProviderFormattedInternalName AS ReferringProviderName, 
                     SBP.SuperbillStatusUid, SBP.SuperbillStatusName,
                     SBP.ServiceDateStart, SBP.ServiceDateEnd, SBP.FirstFiledDate, SBP.LastFiledDate,
                     SBP.ServiceSiteUid, SBP.ServiceSiteName,
                     SBP.AccountUid, SBP.VisitUid, SBP.VisitDate, SBP.VisitIsCompleted, SBP.ClaimPaper, SBP.LastModifiedByUid,   
                     SBP.IsPosted, SBP.ArBatchUid, SBP.ArBatchName,
                     SBP.FinancialCenterUid, SBP.FinancialCenterName, SBP.MaxPostingDate, SBP.MinPostingDate,
                     pip.InsurancePlanUid AS PrimaryInsurancePlanUid, pip.InsuranceCarrierUid AS PrimaryInsuranceCarrierUd, 
                     pip.InsuranceCarrier AS PrimaryInsuranceCarrier, pip.Name AS PrimaryInsurance, 
                     cip.InsurancePlanUid AS CurrentInsurancePlanUid, 
            cip.InsuranceCarrierUid AS CurrentInsuranceCarrierUd, 
            cip.InsuranceCarrier AS CurrentInsuranceCarrier, 
            cip.Name AS CurrentInsurance, 
                     cip.Name AS PayerPlanName, cip.InsuranceCarrier AS PayerName,
                     cip.InsuranceCarrierUid, cip.InsurancePlanUid, 
                     SBP.InsuranceOrder, SBP.InsuranceLevelName,
                     VSA.Liability AS TotalCharge,
                     (VSA.LiabilityBalance - VSA.AssignedLiabilityBalance) AS PatientResponsibility,
                     VSA.AssignedLiabilityBalance AS InsuranceResponsibility,
                     SBP.LastPatientPaymentDate, 
            0-COALESCE(SBP.LastPatientPaymentAmount, 0) AS LastPatientPayment,
                     SBP.LastInsurancePaymentCarrierUid, SBP.LastInsurancePaymentDate, 
            0-COALESCE(SBP.LastInsurancePaymentAmount, 0) AS LastInsurancePayment, 
                     lcf.ClaimFormatUid, lcf.Name as FilingMethod, 
                     SBP.CodeValidationErrors,
                     CAST(0 as bit) as Inactive, -- sa.Inactive,
                     CAST(0 as bit) AS ARLocked, /* not needed anymore since only one row per Superbill */
            CAST(case when pip.InsurancePlanUid=cip.InsurancePlanUid then 1 else 0 end as bit) as IsCurrentInsurancePrimary,
            case when SBP.ABN=1 then ''Yes'' else ''No'' end as ABN,       
            cip.AccountTypeUid,
            CAST(ISNULL(VSPIV.IsVoid, 0) AS BIT) AS IsVoid,
			SBP.SuperbillProcedureCount
     FROM   ViewSuperbillProcedure SBP  
				LEFT JOIN ViewSuperbillProcedure_IsVoid VSPIV ON sbp.SuperbillProcedureUid = VSPIV.SuperbillProcedureUid
				LEFT JOIN ViewInsurancePlan pip ON SBP.PrimaryInsurancePlanUid = pip.InsurancePlanUid
				LEFT JOIN ViewInsurancePlan cip ON dbo.GetSuperbillCurrentInsurancePlan(SBP.SuperbillUid) = cip.InsurancePlanUid
				LEFT JOIN AR_ViewSuperbillAggregate VSA ON SBP.SuperbillUid = VSA.SuperbillUid 
				LEFT JOIN ListClaimFormat lcf ON lcf.ClaimFormatUid = dbo.UDF_AR_getPlanClaimFormatUid(SBP.ClaimPaper, cip.InsurancePlanUid, SBP.InsuranceOrder)









--EXEC sys.sp_addextendedproperty @name=N''GenerateEntityObject'', @value=N''false'' , @level0type=N''SCHEMA'',@level0name=N''dbo'', @level1type=N''VIEW'',@level1name=N''ViewSuperbillProcedureFullInsurance''



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillProcedureScrubFullInsurance]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewSuperbillProcedureScrubFullInsurance] 
AS

SELECT vsfb.*, 
	VSF.LastFollowupModifiedByUid, VSF.LastFollowupModifiedDate, VSF.LastFollowupByUser, VSF.LastFollowupAll, VSF.MaxFollowupModifiedDate,
	act.AccountResponsiblePartyUid, -- 7440
	ARPA.LiabilityBalance - ARPA.AssignedLiabilityBalance AS AccountResponsiblePartyLiabilityBalance, -- 7761
	(ISNULL(vsfb.PatientResponsibility,0) +  ISNULL(vsfb.InsuranceResponsibility,0)) AS TotalLiability -- 7761
	FROM ViewSuperbillProcedureFullInsurance vsfb
	INNER JOIN Account act on vsfb.AccountUid = act.AccountUid -- 7440
	INNER JOIN Account AC WITH (NOLOCK) ON vsfb.AccountUid = AC.AccountUid
	LEFT JOIN ViewSuperbillFollowup VSF ON vsfb.SuperbillUid = VSF.SuperbillUid
	LEFT JOIN AR_ViewAccountResponsiblePartyAggregate ARPA ON AC.AccountResponsiblePartyUid = ARPA.AccountResponsiblePartyUid -- 7761

  

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFinancialCenterClosingSuperbill]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewFinancialCenterClosingSuperbill]    
AS     
    
SELECT NEWID() AS ViewFinancialCenterClosingSuperbillUid, FC.FinancialCenterUid, SB.SuperbillUid
FROM FinancialCenter FC 
INNER JOIN (SELECT BFCR.ArBatchUid, BFCR.GLDate AS ArBatchGlDate, ARB.Name AS ArBatchName, ARB.IsLocked AS ArBatchIsLocked,
					BFCR.FinancialCenterUid, FC.Name AS FinancialCenterName, FC.ExternalID AS FinancialCenterExternalId,
					FC.ARClosedThroughDate AS FinancialCenterArClosedThroughDate
				FROM AR_ViewBatchFinancialCenterRelations BFCR  -- BMR 2016-11-03 - Removed NOEXPAND as removed SCHEMABINDING
					INNER JOIN ARBatch ARB ON BFCR.ArBatchUid = ARB.ARBatchUid
					INNER JOIN FinancialCenter FC ON BFCR.FinancialCenterUid = FC.FinancialCenterUid
					INNER JOIN AR_ViewBatchClosings VBC ON BFCR.ArBatchUid = VBC.ArBatchUid
				WHERE VBC.IsClosed = 0) ARBFCREL ON FC.FinancialCenterUid = ARBFCREL.FinancialCenterUid
INNER JOIN ViewArBatch VARB ON ARBFCREL.ArBatchUid = VARB.ArBatchUid AND VARB.IsClosed = 0
INNER JOIN Superbill SB ON VARB.ArBatchUid = SB.ArBatchUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureInsurancePlanAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'



 CREATE VIEW [dbo].[AR_ViewSuperbillProcedureInsurancePlanAggregateSub] WITH SCHEMABINDING 
  AS  
  SELECT LD.SuperbillProcedureUid,InsurancePlanUid,   
		  SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.Amount ELSE 0 END) As Liability,   
		  SUM(LD.Amount) As LiabilityBalance,   COUNT_BIG(*) AS Count  
	  FROM dbo.AR_LedgerDetail LD          
		INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
	  WHERE NOT LD.InsurancePlanUid IS NULL AND NOT LD.SuperbillProcedureUid IS NULL   
	  GROUP BY LD.SuperbillProcedureUid, LD.InsurancePlanUid          

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX IX_AR_ViewSuperbillProcedureInsurancePlanAggregateSub ON AR_ViewSuperbillProcedureInsurancePlanAggregateSub(SuperbillProcedureUid, InsurancePlanUid)

*/

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureInsurancePlanAggregateSub]') AND name = N'IX_AR_ViewSuperbillProcedureInsurancePlanAggregateSub')
CREATE UNIQUE CLUSTERED INDEX [IX_AR_ViewSuperbillProcedureInsurancePlanAggregateSub] ON [dbo].[AR_ViewSuperbillProcedureInsurancePlanAggregateSub]
(
	[SuperbillProcedureUid] ASC,
	[InsurancePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillFinancialDetails]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewSuperbillFinancialDetails] as
SELECT SuperbillUid, FinancialCenterUid, ServiceSiteUid, ClaimingProviderUid, RenderingProviderUid
	FROM SuperbillAggregate WITH (NOLOCK)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_MDOL_RPT2_Total A/R Aging]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[View_MDOL_RPT2_Total A/R Aging]  
AS 
SELECT DISTINCT TOP (100) PERCENT   

(Case  When dbo.AR_LedgerDetail.LiabilityOwner=0 then ''-'' Else ISNULL(dbo.Corporation.Name, ''-'')  End) AS Payer,  
(Case  When dbo.AR_LedgerDetail.LiabilityOwner=0 then Null Else Corporation.CorporationUid End) as CorporationUid ,   
(Case  When dbo.AR_LedgerDetail.LiabilityOwner=0 then ''-'' Else ISNULL(dbo.InsurancePlan.Name, ''-'') End) AS PlanName,   
--dbo.AR_LedgerDetail.LiabilityOwner,
--dbo.AR_LedgerDetail.InsurancePlanUid,
case when  dbo.AR_LedgerDetail.LiabilityOwner = 0 then null else dbo.AR_LedgerDetail.InsurancePlanUid end as InsurancePlanUid,
dbo.UDF_getFormattedPreferredName(dbo.Account.PersonUid) AS preferredName,   
CONVERT(varchar(50),dbo.Account.PersonUid) AS PatientUid,
Patient.ExternalId as PatientId,  
VSF.FinancialCenterUid,  
ISNULL(dbo.Account.Name, ''-'') AS AccountName,   
dbo.Account.AccountUid,   
VSF.ClaimingProviderUid,   
VSF.RenderingProviderUid,   
ISNULL(dbo.Superbill.ExternalID, ''ACCOUNT'') AS SuperBillID,   
dbo.Superbill.SuperbillUid,
ISNULL(SuperBill.ServiceDateStart, '''') AS SuperBillDate,
dbo.SuperBillProcedure.TotalCharge AS OriginalCharges,
--dbo.AR_LedgerDetail.CreatedDate ,
CASE  WHEN dbo.AR_LedgerDetail.LiabilityOwner=0 THEN VS.LiabilityBalance - VS.AssignedLiabilityBalance ELSE   VI.LiabilityBalance  END AS BalanceAll,
--DATEDIFF(DD, dbo.ARBatch.GLDate , GETDATE()) Age 
VSA.Age,
DATEDIFF(DD, SuperBillProcedure.ProcedureServiceDateStart, GETDATE()) as ServiceAge,
--dbo.AR_LedgerDetail.LastModifiedDate
AR_LedgerDetail.SuperbillProcedureUid AS SuperbillProcedureUid,
CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed
FROM           
	dbo.AR_Ledger WITH (NOLOCK)  
JOIN   
	dbo.AR_LedgerDetail  WITH (NOLOCK)
ON  
	dbo.AR_Ledger.LedgerUid=dbo.AR_LedgerDetail.LedgerUid  AND (dbo.AR_Ledger.EntryType =1 OR dbo.AR_Ledger.EntryType =4) --AND dbo.AR_LedgerDetail.IsCredit = 0  
JOIN   
	dbo.SuperbillProcedure  WITH (NOLOCK)
ON  
	dbo.AR_LedgerDetail.SuperbillProcedureUid =dbo.SuperbillProcedure.SuperbillProcedureUid  
JOIN  
	dbo.ARBatch  WITH (NOLOCK) 
ON  
	dbo.AR_Ledger.ArBatchUid = dbo.ARBatch.ARBatchUid  
JOIN 
	AR_ViewBatchClosingsLockedClosed VARB WITH (NOLOCK)
ON 
	dbo.AR_Ledger.ArBatchUid =VARB.ARBatchUid
JOIN   
	dbo.Superbill WITH (NOLOCK)  
ON  
	dbo.Superbill.SuperbillUid = dbo.SuperbillProcedure.SuperbillUid  
JOIN   
	AR_ViewSuperbillProcedureAggregate VS  WITH (NOLOCK)
ON  
	dbo.AR_LedgerDetail.SuperbillProcedureUid =VS.SuperbillProcedureUid    
LEFT JOIN  
	[AR_ViewSuperbillProcedureInsurancePlanAggregateSub] VI WITH (NOLOCK) 
ON  
	VI.InsurancePlanUid =  dbo.AR_LedgerDetail.InsurancePlanUid   
AND   
	VI.SuperbillProcedureUid =  dbo.AR_LedgerDetail.SuperbillProcedureUid      
JOIN  
	dbo.Account WITH (NOLOCK)
ON 
	dbo.Account.AccountUid = dbo.Superbill.AccountUid 
LEFT OUTER JOIN  
	dbo.Patient WITH (NOLOCK)
ON 
	dbo.Patient.PersonUid = dbo.Account.PersonUid 
LEFT OUTER JOIN   
--                      dbo.AccountPeriod ON dbo.AccountPeriod.AccountUid = dbo.Account.AccountUid AND (dbo.AccountPeriod.EffectiveDate IS NULL OR  
--                      dbo.AccountPeriod.EffectiveDate <= ISNULL(dbo.Superbill.ServiceDateEnd, dbo.AR_LedgerDetail.CreatedDate)) AND   
--                      (dbo.AccountPeriod.ExpirationDate IS NULL OR  
--                      dbo.AccountPeriod.ExpirationDate >= ISNULL(dbo.Superbill.ServiceDateEnd, dbo.AR_LedgerDetail.CreatedDate)) LEFT OUTER JOIN  
--                      dbo.AccountInsurance ON dbo.AccountInsurance.AccountPeriodUid = dbo.AccountPeriod.AccountPeriodUid AND   
--						dbo.AccountInsurance.DisplayOrder = dbo.AR_LedgerDetail.LiabilityOwner LEFT OUTER JOIN  
--                      dbo.PersonInsurancePlan ON dbo.PersonInsurancePlan.PersonInsurancePlanUid = dbo.AccountInsurance.PersonInsurancePlanUid LEFT OUTER JOIN  
	dbo.InsurancePlan WITH (NOLOCK) ON dbo.InsurancePlan.InsurancePlanUid = dbo.AR_LedgerDetail.InsurancePlanUid--, dbo.PersonInsurancePlan.InsurancePlanUid)   
LEFT OUTER JOIN  
	dbo.Corporation WITH (NOLOCK) ON dbo.Corporation.CorporationUid = dbo.InsurancePlan.InsuranceCarrierUid 
JOIN
	[AR_ViewSuperbillProcedureAge] VSA WITH (NOLOCK)
ON
	dbo.AR_LedgerDetail.SuperbillProcedureUid = VSA.SuperbillProcedureUid AND dbo.AR_LedgerDetail.LiabilityOwner = VSA.LiabilityOwner
JOIN
	ViewSuperbillFinancialDetails VSF WITH (NOLOCK)
ON
	dbo.Superbill.SuperbillUid = VSF.SuperbillUid 
WHERE      
	(((VS.LiabilityBalance -  VS.AssignedLiabilityBalance) <> 0 AND dbo.AR_LedgerDetail.LiabilityOwner =0)  OR (VI.LiabilityBalance  <> 0 AND VS.AssignedLiabilityBalance <> 0 AND dbo.AR_LedgerDetail.LiabilityOwner >0)  )



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindePAPatient]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewFindePAPatient] AS

SELECT	vfp.PersonUid, vfp.ExternalID, vfp.Inactive, vfp.FirstName, vfp.LastName, 
		vfp.FullName, 
		vfp.AkaName, 
		vfp.Birthdate, 
		vfp.Deathdate, vfp.AkaFirstName, vfp.AkaLastName, vfp.SocialSecurityNumber, 
        vfp.MedicalRecordNumber, 
        vfp.Phone1, 
		vfp.PhoneNumber, 
        vfp.PhoneTypeName,
		vfp.PhoneNumberScrubbed, 
        vfp.[Address],
        vfp.Address1,
        vfp.Address2,
        vfp.City,
        vfp.[State],
        vfp.Zip,        
        vfp.Gender, 
		vfp.PhotoAttachmentUid, 
        vfp.Phone2, 
        vfp.PhoneNumber2, 
        vfp.PhoneTypeName2,
        vfp.Phone3, 
        vfp.PhoneNumber3, 
        vfp.PhoneTypeName3,
        vfp.Phone4, 
        vfp.PhoneNumber4, 
        vfp.PhoneTypeName4,                        
        vfp.PatientExternalID, 
		vfp.Notes,
        vfp.PatientConditionUid, 
		vfp.PatientCondition, 
		vfp.PatientConditionColor,
		(select top 1 v.ProviderUid from Visit v inner join RelVisitMedication rvm on v.VisitUid = rvm.VisitUid
		and rvm.ePAStatus = 4
			where v.PatientUid = vfp.PersonUid order by v.visitdate) as [ProviderUid],
		vfp.Provider
FROM    ViewFindPatient vfp
where vfp.PersonUid in (SELECT	DISTINCT vfp.PersonUid
FROM    ViewFindPatient vfp
	inner join Visit v on vfp.PersonUid = v.PatientUid
	inner join RelVisitMedication rvm on v.VisitUid = rvm.VisitUid
		and rvm.ePAStatus = 4
)

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_MDOL_PerformanceMangementCharges]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[View_MDOL_PerformanceMangementCharges] 
AS
		SELECT
		 ISNULL(LD.Amount, 0) AS Charges,
		 AR.GLDate,
		 SB.ServiceDateStart,
		 LD.RenderingProviderUID AS ProviderUid,
		 LD.ClaimingProviderUid AS ClaimingProviderUid,
		 dbo.UDF_getFormattedPreferredName(LD.RenderingProviderUID) AS ProviderName,
		 dbo.UDF_getFormattedPreferredName(LD.ClaimingProviderUid) AS ClaimingProviderName,
		 LD.ServiceSiteUid,
		 LD.FinancialCenterUid,
		 LSS.Name AS ServiceSiteName,
		 FC.Name AS FinancialCenterName,
		 SB.SuperbillUid,
		 SP.SuperbillProcedureUid,
		 CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed
		FROM
			AR_Ledger L
		LEFT JOIN 
			ARBatch AR
		ON
			L.ArBatchUid = AR.ARBatchUid 
		LEFT JOIN 
			AR_ViewBatchClosingsLockedClosed VARB 
		ON 
			L.ArBatchUid =VARB.ARBatchUid			
		JOIN
			AR_LedgerDetail	LD 
		ON	
			L.LedgerUid = LD.LedgerUid AND (L.EntryType = 1 OR L.EntryType = 4)-- AND LD.IsCredit = 0
		JOIN
			SuperbillProcedure SP
		ON
			LD.SuperbillProcedureUid = SP.SuperbillProcedureUid 
		LEFT JOIN
			Superbill SB
		ON
			SP.SuperbillUid = SB.SuperbillUid 
		LEFT JOIN 
			ListServiceSite LSS
		ON
			LD.ServiceSiteUid = LSS.ServiceSiteUid 
		LEFT JOIN
			FinancialCenter FC
		ON
			LD.FinancialCenterUid = FC.FinancialCenterUid 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementResponsibleParty_MainAccount]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewStatementResponsibleParty_MainAccount]  
AS   
/* This is the source for electronic statements and also for paper statements, indirectly via  
 the stored proc MDOL_RPT2_StatementHeader/ One record per responsible party with active accounts.  
 02/21/2014  - KBernecker - modified to check for existance of dunning messages before calculating the age of the superbill procedures
 08/21/2014 - kculberth - added NOLOCKs to prevent statements from causing deadlocks
 10/14/2014 - kculberth - updated logic to match regular statements by practice
 03/22/2016 - kculberth - added responsible party suffix (Bug 46772:The Responsible Party / Addressee suffix is not displayed when statements are generated by Main Account)
 08/18/2016 - kculberth - added MinimumPaymentDue to grab collections payment amount if applicable
 02/01/2017 - kculberth - Product Backlog Item 54937:Batch Statements Mimimum Balance Due should not exceed the actual total patient balance
 11/02/2017 - kculberth - Bug 56127:OnDemand Statements generated by Practice do not display the Responsible Party prefix/title
*/


with cte_arpsbdtable AS
(
	select * from (
		select StatementBatchDetailUid,AccountResponsiblePartyUid,sbd.FinancialCenterUid
		,ROW_NUMBER() OVER (partition by AccountResponsiblePartyUid order by sbd.lastmodifieddate desc) AS ROWNUM 
		from StatementBatchDetail sbd
		inner join StatementBatch sb on sb.StatementBatchUid = sbd.StatementBatchUid			
		where --sb.StatementActionUid = ''DD9E9ACD-0A49-44F3-B0B0-ECE163FD8D42'' -- Submit 
				--and 
				sbd.FinancialCenterUid is null
	)a
	where a.ROWNUM = 1
),
cte_DunningMsgsExist AS (
	select coalesce(dm.DunningMsg1,dm.dunningmsg2,dm.dunningmsg3,dm.dunningmsg4,'''') as DunningMsgsExist
	from DunningMsgs (NOLOCK) dm
	inner join PracticeSettings ps on dm.DunningMsgsUid = ps.DunningMsgsUid
)
,cte_DuplicatedDunningMsgs as (
	select top 1 case when dunningmsg1 is not null and ((dunningmsg1 = DunningMsg2) and (DunningMsg2 = DunningMsg3) and (DunningMsg3 = DunningMsg4) and (DunningMsg4 = DunningMsg5))
	then dunningmsg1 else NULL end as DuplicatedDunningMsg from DunningMsgs
)
,cte_dunningmsg as (
	select CASE WHEN LEN(dunningMsgsExist) = 0 THEN '''' else 	
	case when DuplicatedDunningMsg is NOT NULL THEN DuplicatedDunningMsg else
	NULL END 
	END  as DunningMsg
	FROM cte_DunningMsgsExist,
	cte_DuplicatedDunningMsgs
)

---*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv

SELECT DISTINCT 
	arp.AccountResponsiblePartyUid as RPUid,   
	''00000000-0000-0000-0000-000000000000''  as FinancialCenterUid,   
	ps.Name as CustomerName,   
	ISNULL(ps.MainAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''')  AS CustomerAddress1,   
	ISNULL(ps.MainAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''')  AS CustomerAddress2,   
	ISNULL(ps.MainAddress.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''')  AS CustomerCity,   
	ISNULL(ps.MainAddress.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''')  AS CustomerState,   
	ISNULL(ps.MainAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''')  AS CustomerZip,   
	ISNULL(ps.MainAddress.value(''(/Address/Country)[1]'', ''VARCHAR(100)''),'''')  AS CustomerCountry,   
	ISNULL(ps.MainPhone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)''),'''')  AS CustomerPhone,   
	ps.Name as RemitToName,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(
	ps.MainAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToAddress1,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(
	ps.MainAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToAddress2,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToCity,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToState,   
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToZip,    
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Country)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/Country)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToCountry,     
	arp.ExternalID as RPID, 
	CASE WHEN p.PersonUid IS NOT NULL THEN (case when p.Prefix is null then '''' else p.Prefix + '' '' END) + ISNULL(P.FirstName,'''') + (case when p.MiddleName is null then '''' else '' '' + p.MiddleName END) +'' ''+ ISNULL(p.LastName,'''') + (case when p.Suffix is null then '''' else '', '' + p.suffix end)  ELSE c.Name END AS RPName,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''), '''') END AS RPAddress1,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''), '''') END AS RPAddress2,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)''), '''') END AS RPCity,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''), '''') END AS RPState,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''), '''') END AS RPZip,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Country)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)''), '''') END AS RPCountry,   
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Email1,'''') ELSE ISNULL(c.email1,'''') END AS RPEmail1,
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.phone1.value(''(/Phone/PhoneNumber)[1]'',''VARCHAR(100)''), '''') ELSE ISNULL(c.[phone1].value(''(/Phone/PhoneNumber)[1]'',''VARCHAR(100)''), '''') END AS RPPhone1,
	ISNULL(l.name,'''') AS RPLanguage,
	CONVERT(varchar(10), CAST(GetDate() AS DATE), 120) as StatementDate, 
	CONVERT(varchar(10), CAST(DATEADD(day, PS.StatementDueDays, GetDate()) AS DATE), 120) as DueDate,     
	ps.StatementMinimumAmount  AS StatementMinimumAmount,  
	(CASE WHEN (collections.PaymentAmount IS NOT NULL AND collections.PaymentAmount > 0 AND collections.PaymentAmount < (VA.LiabilityBalance - VA.AssignedLiabilityBalance)) THEN collections.PaymentAmount 
	 ELSE (VA.LiabilityBalance - VA.AssignedLiabilityBalance) END) AS MinimumPaymentDue,
	(VA.LiabilityBalance - VA.AssignedLiabilityBalance) AS AmountDue,  
	VA.LiabilityBalance as TotalBalance,   
	VA.AssignedLiabilityBalance as InsuranceBalance,   
	CASE WHEN LEN(dunningMsgsExist) = 0 THEN '''' else dbo.getStatementDunningMsg_MainAccount(arp.AccountResponsiblePartyUid) END as  DunningMsg,
	dbo.getSuperbillOfResponsibleParty_MainAccount(arp.AccountResponsiblePartyUid) as Superbills, 	 
	ps.StatementFooter  AS StatementFooter,
	RTRIM(SUBSTRING((SELECT top 6 name + ''  '' AS ''data()'' 
					 FROM listpaymenttype pt 
					 WHERE InternalCardType IS NOT NULL AND Inactive=0 Order by Name
					 FOR XML PATH('''')),1,80)) AS PaymentTypes    
FROM Account (NOLOCK) a 
	INNER JOIN AccountResponsibleParty (NOLOCK) arp ON a.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid   
	INNER JOIN AR_ViewAccountResponsiblePartyAggregate_SumAccountLiabilities_Filter VA ON arp.AccountResponsiblePartyUid = VA.AccountResponsiblePartyUid  
	LEFT JOIN MDOL_RPT2_VIEW_AccountResponsiblePartyAccountReport collections on collections.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid and collections.CollectionStatus IS NOT NULL
	LEFT JOIN Person (NOLOCK) p ON p.PersonUid = arp.PersonUid   
	LEFT JOIN Corporation (NOLOCK) c ON c.CorporationUid = arp.CorporationUid  
	LEFT JOIN ListLanguage l WITH (NOLOCK) on l.LanguageUid = p.languageuid,
	PracticeSettings ps WITH (NOLOCK),
	cte_DunningMsgsExist  
WHERE a.Inactive = 0 AND A.ISMAIN=1


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountByFinancialCenterAggregate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewAccountByFinancialCenterAggregate] 
AS
SELECT AC.AccountUid, SFD.FinancialCenterUid,
      SUM(ISNULL(VSPAB.Liability,0)) AS Liability, SUM(ISNULL(VSPAB.AssignedLiability,0)) AS AssignedLiability,
      SUM(ISNULL(VSPAB.LiabilityBalance,0)) AS LiabilityBalance, SUM(ISNULL(VSPAB.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance,
      SUM(ISNULL(VSPAB.LiabilityBalance,0)) - SUM(ISNULL(VSPAB.AssignedLiabilityBalance,0)) AS UnassignedLiabilityBalance
FROM Account AC 
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON AC.AccountUid = VSPAB.AccountUid
LEFT JOIN ViewSuperbillFinancialDetails SFD ON VSPAB.SuperbillUid = SFD.SuperbillUid
GROUP BY AC.AccountUid, SFD.FinancialCenterUid

-- NOTICE:  This returns a set of values DIFFERENT from the OLDER ViewArAccountAggregate
-- In the case of an account credit, in the OLD, this is reflected in ViewArAccountAggregate
-- Now, this gets reflected in the ResponsibleParty aggregate and will NOT be reflected here ... this is INTENTIONAL
-- Added calculated UnassignedLiabilityBalance for Demographics Patient Balance


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountResponsiblePartyByFinancialCenterAggregate_SumAccountLiabilities_Filter]'))
EXEC dbo.sp_executesql @statement = N'

/* 	 02/02/2017 - kculberth - Bug 51825:Statements-CHC Payer Setting Encounter codes need to print on statement if there is a patient liability for this code.
*/

CREATE VIEW [dbo].[AR_ViewAccountResponsiblePartyByFinancialCenterAggregate_SumAccountLiabilities_Filter] 
AS
--SELECT AC.AccountResponsiblePartyUid, SFD.FinancialCenterUid,
--	SUM(ISNULL(VSA.Liability,0)) AS Liability, 
--	SUM(ISNULL(VSA.AssignedLiability,0)) AS AssignedLiability,
--	SUM(ISNULL(VSA.LiabilityBalance,0)) AS LiabilityBalance, 
--	SUM(ISNULL(VSA.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance
--FROM Account AC WITH (NOLOCK)
--LEFT JOIN Superbill SB WITH (NOLOCK) ON AC.AccountUid = SB.AccountUid
--LEFT JOIN AR_ViewSuperbillAggregate VSA ON SB.SuperbillUid = VSA.SuperbillUid
--LEFT JOIN ViewSuperbillFinancialDetails SFD ON SB.SuperbillUid = SFD.SuperbillUid
--LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus rfcss WITH (NOLOCK) 
--ON SB.SuperbillStatusUid = rfcss.SuperbillStatusUid AND SFD.FinancialCenterUid = rfcss.FinancialCenterUid
--where rfcss.superbillstatusuid is null
--GROUP BY AC.AccountResponsiblePartyUid, SFD.FinancialCenterUid

SELECT AC.AccountResponsiblePartyUid, SFD.FinancialCenterUid,
	SUM(ISNULL(VSA.Liability,0)) AS Liability, 
	SUM(ISNULL(VSA.AssignedLiability,0)) AS AssignedLiability,
	SUM(ISNULL(VSA.LiabilityBalance,0)) AS LiabilityBalance, 
	SUM(ISNULL(VSA.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance
FROM Account AC WITH (NOLOCK)
LEFT JOIN Superbill SB WITH (NOLOCK) ON AC.AccountUid = SB.AccountUid
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub VSA ON SB.SuperbillUid = VSA.SuperbillUid
LEFT JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = VSA.SuperbillProcedureUid
LEFT JOIN ViewSuperbillFinancialDetails SFD ON SB.SuperbillUid = SFD.SuperbillUid
LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus rfcss WITH (NOLOCK) 
ON SB.SuperbillStatusUid = rfcss.SuperbillStatusUid AND SFD.FinancialCenterUid = rfcss.FinancialCenterUid
WHERE rfcss.superbillstatusuid IS NULL AND AC.Inactive = 0
AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
GROUP BY AC.AccountResponsiblePartyUid, SFD.FinancialCenterUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPayerCreditByPayerFinancialCenterSub]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewPayerCreditByPayerFinancialCenterSub]    WITH SCHEMABINDING
AS

select ld.InsurancePayerUid, 
       ld.AccountResponsiblePartyUid, 
	   ld.FinancialCenterUid,
       SUM(ld.Amount) as PayerCreditBalance, 
       COUNT_BIG(*) AS Count
from dbo.AR_LedgerDetail ld
where ld.PayerCreditUid is not null
group by ld.InsurancePayerUid, ld.AccountResponsiblePartyUid, ld.FinancialCenterUid

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewPayerCreditByPayerFinancialCenterSub_Ins_AccountResponsiblePartyUid_FC ON AR_ViewPayerCreditByPayerFinancialCenterSub(InsurancePayerUid, AccountResponsiblePartyUid, FinancialCenterUid)

*/


' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPayerCreditByPayerFinancialCenterSub]') AND name = N'PK_AR_ViewPayerCreditByPayerFinancialCenterSub_Ins_AccountResponsiblePartyUid_FC')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewPayerCreditByPayerFinancialCenterSub_Ins_AccountResponsiblePartyUid_FC] ON [dbo].[AR_ViewPayerCreditByPayerFinancialCenterSub]
(
	[InsurancePayerUid] ASC,
	[AccountResponsiblePartyUid] ASC,
	[FinancialCenterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPayerCreditByPayer]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewPayerCreditByPayer] 
AS
SELECT vpcs.InsurancePayerUid,
       vpcs.AccountResponsiblePartyUid,
       SUM(vpcs.PayerCreditBalance) AS PayerCreditBalance
FROM AR_ViewPayerCreditByPayerFinancialCenterSub vpcs (NOEXPAND)
GROUP BY vpcs.InsurancePayerUid, vpcs.AccountResponsiblePartyUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPayerCreditByPayerFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewPayerCreditByPayerFinancialCenter] 
AS
SELECT vpcs.InsurancePayerUid,
       vpcs.AccountResponsiblePartyUid,
	   vpcs.FinancialCenterUid,
       vpcs.PayerCreditBalance
FROM AR_ViewPayerCreditByPayerFinancialCenterSub vpcs (NOEXPAND)



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementBalanceByFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'



-- 20140703 kdc fix Bug #30565: Create Statements for eTactics not populating name when responsible party is Corp 
-- 20141028 kdc fix problem with statements not populating based on minimum statement balance in FC
-- 20150512 kdc added NOLOCK on FinancialCenter in join at bottom
-- 2016/02/01 - kculberth 	Task 45999 - Add or change send statement view to look at new responsible party ID "send statement" flag.
-- 2016/06/20 - broy 	added PayerCreditBalance for Batch Processing Changes
-- 2016/03/13 - kculberth fix Bug 56134:OnDemand Statements print Last Name/First Name when generated by Financial Center
-- 2017/11/02 - kculberth - Bug 56127:OnDemand Statements generated by Practice do not display the Responsible Party prefix/title
-- 2018/03/19 - kculberth fix Work item Changed: Bug 62451 - Statement balance showing double. remove use of RelAccountResponsiblePartyFinancialCenter because we no longer need it

CREATE view [dbo].[ViewStatementBalanceByFinancialCenter]
AS
select a.FinancialCenterUid,
	   FinancialCenterName,
	   a.AccountResponsiblePartyUid,	   
	   ResponsiblePartyName,
	   LastName,
	   Balance,
	   TotalBalance,
	   InsuranceBalance,
	   LastStatementDate,
	   CycleTrigger,
	   SuperBills,
	   a.ExternalID,
	   pcbp.PayerCreditBalance
	    from (
SELECT DISTINCT
	varpafc.FinancialCenterUid, 
	fc.Name as FinancialCenterName, 
	varpafc.AccountResponsiblePartyUid as AccountResponsiblePartyUid,
	CASE WHEN p.PersonUid IS NOT NULL THEN (case when p.Prefix is null then '''' else p.Prefix + '' '' END) + ISNULL(P.FirstName,'''') + (case when p.MiddleName is null then ''''else '' '' + p.MiddleName END) +'' ''+ ISNULL(p.LastName,'''') + (case when p.Suffix is null then '''' else '', '' + p.suffix end)  ELSE c.Name END AS ResponsiblePartyName,  
	(CASE WHEN p.PersonUid IS NOT NULL THEN p.LastName 
	ELSE c.Name END) AS LastName, 
	SUM(varpafc.LiabilityBalance - varpafc.AssignedLiabilityBalance) AS Balance,
	Sum(varpafc.LiabilityBalance) as TotalBalance, 
    SUM(varpafc.AssignedLiabilityBalance) as InsuranceBalance, 
	NULL AS LastStatementDate, 
	arp.CycleTrigger AS CycleTrigger,			
	'''' AS SuperBills,
	arp.ExternalID,
	pcbp.PayerCreditBalance
FROM	[AR_ViewAccountResponsiblePartyByFinancialCenterAggregate_SumAccountLiabilities_Filter] varpafc
INNER JOIN AccountResponsibleParty (NOLOCK) arp ON arp.AccountResponsiblePartyUid = varpafc.AccountResponsiblePartyUid
INNER JOIN FinancialCenter (NOLOCK) fc on fc.FinancialCenterUid = varpafc.FinancialCenterUid
LEFT JOIN Person (NOLOCK) p ON p.PersonUid = arp.PersonUid 
LEFT JOIN Corporation (NOLOCK) c ON c.CorporationUid = arp.CorporationUid 
LEFT JOIN ViewPerson (NOEXPAND) vpns on vpns.PersonUid = arp.PersonUid
LEFT JOIN AR_ViewPayerCreditByPayer pcbp on arp.AccountResponsiblePartyUid = pcbp.AccountResponsiblePartyUid
GROUP BY arp.AccountResponsiblePartyUid,varpafc.AccountResponsiblePartyUid,arp.externalid, pcbp.PayerCreditBalance, p.personuid,p.lastname,p.firstname,p.middlename,p.Suffix,p.prefix,c.Name,varpafc.FinancialCenterUid,fc.Name,
arp.CycleTrigger,arp.laststatementdate
) a
inner join financialcenter (NOLOCK) fc on a.financialcenteruid = fc.FinancialCenterUid
LEFT JOIN AR_ViewPayerCreditByPayerFinancialCenter pcbp on a.AccountResponsiblePartyUid = pcbp.AccountResponsiblePartyUid
												and a.FinancialCenterUid = pcbp.FinancialCenterUid
where balance >= fc.StatementMinimumAmount



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementResponsiblePartyByFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'



-- 20160503 kc add missing WITH (NOLOCK) 
-- 20170303 kculberth add Minimum Payment Due based on collections payment amount Bug 55967:Minimum Amount due does not display on Statements generated by Financial Center

CREATE VIEW [dbo].[ViewStatementResponsiblePartyByFinancialCenter]
AS --nag2
/*	This is the source for electronic statements and also for paper statements, indirectly via
	the stored proc MDOL_RPT2_StatementHeader/ One record per responsible party with active accounts.

	01/28/2008 - Qatalys - #12798 - Modified Balance with BalanceAll
	05/19/2008 - Qatalys - #13325 - Added Financial Center 
	01/22/2009 - Qatalys		  - Modified to replace PersonBalanceAll,AccountBalanceAll of Account
	07/29/2009 -- Included Dunning Message
	09/23/2013 - KBernecker - Modified to use ViewStatementBalanceByFinancialCenter
	02/21/2014 - KBernecker - Added cte_DunningMsgsExist to resolve timeout involing getStatementDunningMsgByFinancialCenter 
	05/27/2015 - kculberth - add email1, phone1, language
	05/03/2016 - kculberth - add missing WITH (NOLOCK)
	05/05/2016 - kculberth - modify handling of DunningMsgs bug 49049
*/
WITH cte_DunningMsgsExist AS (
	select distinct coalesce(dm.DunningMsg1,dm.dunningmsg2,dm.dunningmsg3,dm.dunningmsg4,'''') as DunningMsgsExist
	,FinancialCenterUid
	from DunningMsgs dm WITH (NOLOCK)
	inner join FinancialCenter fc WITH (NOLOCK) on dm.DunningMsgsUid = fc.DunningMsgsUid
)
--,
--cte_arpsbdtable AS
--(
--	select * from (
--		select StatementBatchDetailUid,AccountResponsiblePartyUid,sbd.FinancialCenterUid
--		,ROW_NUMBER() OVER (partition by AccountResponsiblePartyUid order by sbd.lastmodifieddate desc) AS ROWNUM 
--		from StatementBatchDetail sbd WITH (NOLOCK)
--		inner join StatementBatch sb WITH (NOLOCK) on sb.StatementBatchUid = sbd.StatementBatchUid			
--		where --sb.StatementActionUid = ''DD9E9ACD-0A49-44F3-B0B0-ECE163FD8D42'' -- Submit 
--				--and 
--				sbd.FinancialCenterUid is not null
--	)a
--	where a.ROWNUM = 1
--)

SELECT   
	s.AccountResponsiblePartyUid as RPUid,  
	s.FinancialCenterUid,   
	FC.Name as CustomerName,   
	ISNULL(fc.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') as CustomerAddress1,   
	ISNULL(fc.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') as CustomerAddress2,   
	ISNULL(fc.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)''), '''') as CustomerCity,   
	ISNULL(fc.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''), '''') as CustomerState,   
	ISNULL(fc.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''), '''') as CustomerZip,   
	ISNULL(fc.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''), '''') as CustomerPhone,   
	FC.Name as RemitToName,   
	ISNULL(fc.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') as RemitToAddress1,   
	ISNULL(fc.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') as RemitToAddress2,   
	ISNULL(fc.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''') as RemitToCity,   
	ISNULL(fc.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') as RemitToState,   
	ISNULL(fc.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') as RemitToZip,   
	s.ExternalID as RPID,   
	s.ResponsiblePartyName as RPName,   
	(CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''')   
	WHEN c.CorporationUid IS NOT NULL THEN ISNULL(c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''')   
	END) as RPAddress1,   
	(CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''')   
	WHEN c.CorporationUid IS NOT NULL THEN ISNULL(c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''')   
	END) as RPAddress2,   
	(CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''')   
	WHEN c.CorporationUid IS NOT NULL THEN ISNULL(c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''')   
	END) as RPCity,   
	(CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''')   
	WHEN c.CorporationUid IS NOT NULL THEN ISNULL(c.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''')   
	END) as RPState,   
	(CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''')   
	WHEN c.CorporationUid IS NOT NULL THEN ISNULL(c.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''')   
	END) as RPZip,   
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Email1,'''') ELSE ISNULL(c.email1,'''') END AS RPEmail1,
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.phone1.value(''(/Phone/PhoneNumber)[1]'',''VARCHAR(100)''), '''') ELSE ISNULL(c.[phone1].value(''(/Phone/PhoneNumber)[1]'',''VARCHAR(100)''), '''') END AS RPPhone1,
	ISNULL(l.name,'''') AS RPLanguage, 
	s.LastStatementDate, 
	CONVERT(date,dbo.UDF_utcToCurrentDate(getUtcDate())) as StatementDate,
	CONVERT(date, DATEADD(day, fc.StatementDueDays, dbo.UDF_utcToCurrentDate(getUtcDate()))) as DueDate, 
	fc.StatementMinimumAmount,
	(CASE WHEN (collections.PaymentAmount IS NOT NULL AND collections.PaymentAmount > 0) THEN collections.PaymentAmount 
	 ELSE (s.balance) END) AS MinimumPaymentDue,
	s.Balance,  
	s.TotalBalance,   
	s.Balance AS PatientBalance,   
	s.InsuranceBalance,   
	'''' AS Note,  
	s.CycleTrigger,	
	case when cte2.DunningMsgsExist = '''' then '''' else (dbo.getStatementDunningMsgByFinancialCenter(s.AccountResponsiblePartyUid,FC.FinancialCenterUid)) end as DunningMsg,
	fc.StatementFooter AS StatementFooter 
FROM ViewStatementBalanceByFinancialCenter s 
INNER JOIN AccountResponsibleParty arp WITH (NOLOCK) on s.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
INNER JOIN FinancialCenter fc WITH (NOLOCK) ON s.FinancialCenterUid = fc.FinancialCenterUid 
--INNER JOIN cte_arpsbdtable cte on cte.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid and cte.FinancialCenterUid = s.FinancialCenterUid
LEFT JOIN MDOL_RPT2_VIEW_AccountResponsiblePartyAccountReport collections on collections.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid and collections.CollectionStatus IS NOT NULL
LEFT JOIN Person p WITH (NOLOCK) ON arp.PersonUid = p.PersonUid  
LEFT JOIN Corporation c WITH (NOLOCK) ON arp.CorporationUid = c.CorporationUid   
LEFT JOIN ListLanguage l WITH (NOLOCK) on l.LanguageUid = p.languageuid
LEFT  JOIN cte_DunningMsgsExist cte2 on cte2.FinancialCenterUid = fc.FinancialCenterUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementsByFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'




CREATE View [dbo].[ViewStatementsByFinancialCenter]
AS
--BEGIN
--	SET NOCOUNT ON
	SELECT * FROM
	(	
		SELECT 
			V.FinancialCenterUid, 
			CustomerName as FinancialCenterName, 
			Convert(Varchar(50), RPUid) as AccountResponsiblePartyUid,
			RPName as ResponsiblePartyName,
	 		(CASE WHEN p.PersonUid IS NOT NULL THEN p.LastName 
			ELSE c.Name END) AS LastName, 
			Convert(decimal(20, 2), Balance) as Balance, 
			Convert(varchar, V.StatementDate, 101) as LastStatementDate, 
			V.CycleTrigger,
			dbo.getSuperbillOfResponsiblePartyByFinancialCenter(V.RPUid,V.FinancialCenterUid, NEWID()) AS SuperBills
		FROM ViewStatementResponsiblePartyByFinancialCenter  V
		LEFT JOIN AccountResponsibleParty (NOLOCK) arp ON arp.AccountResponsiblePartyUid = V.RPUid
		LEFT JOIN Person (NOLOCK) p ON p.PersonUid = arp.PersonUid 
		LEFT JOIN Corporation (NOLOCK) c ON c.CorporationUid = arp.CorporationUid 
		WHERE RPUid in 
			( Select AccountResponsiblePartyUid 
			FROM StatementBatchDetail (NOLOCK)
			WHERE Balance>=StatementMinimumAmount )
			AND arp.SendStatement = 1 
			AND arp.Inactive=0
	) A
		WHERE
			SuperBills IS NOT NULL
--		ORDER BY ResponsiblePartyName,FinancialCenterName asc
--END





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_MDOL_PerformanceManagementTransaction]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[View_MDOL_PerformanceManagementTransaction] 
AS
	SELECT
		CASE WHEN L.EntryType = 2 AND LD.IsCredit = 1 THEN (-1 * ISNULL(LD.Amount,0)) ELSE 0 END as TotalPayment,
		CASE WHEN L.EntryType = 3 AND LD.IsCredit = 1 THEN (-1 * ISNULL(LD.Amount, 0)) ELSE 0 END AS TotalAdjustment,
		D.PaymentTypeUid,
		AR.GLDate,
		D.DepositDate,
		LD.RenderingProviderUID AS ProviderUid,
		LD.ClaimingProviderUid AS ClaimingProviderUid,
		dbo.UDF_getFormattedPreferredName(LD.RenderingProviderUID) AS ProviderName,
		dbo.UDF_getFormattedPreferredName(LD.ClaimingProviderUid) AS ClaimingProviderName,
		LD.ServiceSiteUid,
		LD.FinancialCenterUid,
		LSS.Name AS ServiceSiteName,
		FC.Name AS FinancialCenterName,
		SB.SuperbillUid AS SuperbillUid,
		SP.SuperbillProcedureUid AS SuperbillProcedureUid,
		CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed
	FROM
			AR_Ledger L
		LEFT JOIN 
			ARBatch AR
		ON
			L.ArBatchUid = AR.ARBatchUid 
		LEFT JOIN 
			AR_ViewBatchClosingsLockedClosed VARB 
		ON 
			L.ArBatchUid =VARB.ARBatchUid			
		JOIN
			AR_LedgerDetail	LD 
		ON	
			L.LedgerUid = LD.LedgerUid 
		JOIN
			SuperbillProcedure SP
		ON
			LD.SuperbillProcedureUid = SP.SuperbillProcedureUid 
		LEFT JOIN
			Superbill SB
		ON
			SP.SuperbillUid = SB.SuperbillUid 
		LEFT JOIN
			AR_Transaction T
		ON
			L.TransactionUid = T.TransactionUid 
		LEFT JOIN
			ViewDeposit D
		ON
			T.DepositUid = D.DepositUid 
		LEFT JOIN 
			ListServiceSite LSS
		ON
			LD.ServiceSiteUid = LSS.ServiceSiteUid 
		LEFT JOIN
			FinancialCenter FC
		ON
			LD.FinancialCenterUid = FC.FinancialCenterUid 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPayerPlan]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewPayerPlan] AS
SELECT	vip.InsurancePlanUid, vip.InsuranceCarrierUid,
		vip.InsuranceCarrier AS PayerName, vip.InsurancePlan AS PlanName,
		vip.Inactive, vip.[Address],
		vip.Address1 AS PlanAddress1, vip.Address2 AS PlanAddress2, vip.City AS PlanCity, vip.[State] AS PlanState, vip.Zip AS PlanZip,
		vip.PhoneNumber, 
        REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(vip.PhoneNumber, ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', '''') AS PhoneNumberScrubbed, 
        vip.Name AS PayerPlanName,
        vip.Notes, vip.ExternalID AS PlanExternalID, vip.InsuranceCarrierExternalID AS PayerExternalID,
        ISNULL(vip.ExternalID, vip.InsuranceCarrierExternalID) AS ExternalID             
FROM    [ViewInsurancePlan] vip



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPersonInsurancePlan]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewPersonInsurancePlan]
AS
SELECT     pip.PersonInsurancePlanUid, pip.PersonUid, pip.CorporationUid, pip.CopayPrimary, pip.PlanMemberID, pip.PlanGroupID, pip.EffectiveDate, 
                      pip.ExpirationDate, COALESCE (c.Name, p.LastName + '', '' + p.FirstName) AS Insured, vpp.PayerName, vpp.PlanName, vpp.PlanAddress1, 
                      vpp.PlanAddress2, vpp.PlanCity, vpp.PlanState, vpp.PlanZip, vpp.PayerPlanName
FROM         dbo.PersonInsurancePlan AS pip LEFT OUTER JOIN
                      dbo.Person AS p ON p.PersonUid = pip.PersonUid LEFT OUTER JOIN
                      dbo.Corporation AS c ON c.CorporationUid = pip.CorporationUid LEFT OUTER JOIN
                      dbo.ViewPayerPlan AS vpp ON vpp.InsurancePlanUid = pip.InsurancePlanUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillCurrentLiabilityOwnerAndCarrier]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewSuperbillCurrentLiabilityOwnerAndCarrier]
AS
SELECT SuperbillUid, CurrentLiabilityOwner, CurrentCarrier
	FROM SuperbillAggregate


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillProcedureScrub]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewSuperbillProcedureScrub] as
     SELECT sbp.SuperbillProcedureUid, sbp.ProcedureUid, 
                    sbp.DisplayOrder, sbp.ProcedureCharge, sbp.ProcedureAllowed, sbp.Units, sbp.InsurancePercent,
                    sbp.FixedCopayAmount, sbp.TotalTax, sbp.TotalAllowed, sbp.DontClaim, 
                    sbp.Modifiers, sbp.Diagnoses, 
                     sbp.Code, sbp.SuperbillUid, sbp.SuperbillExternalId AS ExternalID, 
                     sbp.PersonUid AS PatientUid,
                     sbp.RenderingProviderUid, sbp.ClaimingProviderUid, sbp.SuperbillStatusUid,   
                     sbp.ServiceDateStart, sbp.ServiceDateEnd, 
                     VSBPA.Liability AS TotalCharge,
                     VSA.Liability AS TotalChargeOnSuperbill, sbp.FirstFiledDate, sbp.LastFiledDate,
                     sbp.ServiceSiteUid,   
                     sbp.PatientFormattedName as PatientName,   
                     sbp.RenderingProviderFormattedInternalName as RenderingProviderName,   
                     sbp.ClaimingProviderFormattedInternalName as ClaimingProviderName,
					 sbp.ReferringProviderFormattedInternalName as ReferringProviderName,
                     sbp.SuperbillStatusName, 
                     sbp.ServiceSiteName,
                     sbp.AccountUid, sbp.VisitUid, sbp.VisitDate, sbp.VisitIsCompleted,  
                     sbp.ClaimPaper, sbp.LastModifiedByUid, sbp.IsPosted, sbp.FinancialCenterUid,
                     sbp.FinancialCenterName, 
                     vsclo.CurrentCarrier as InsuranceOrder, -- was sts.InsuranceOrder which is now obsolete
                     CASE WHEN sbp.CodeValidationErrors = 1 THEN ''Errors'' ELSE '''' END AS CodeValidationErrors,
                     sbp.MaxPostingDate, sbp.MinPostingDate, 
                     sbp.ABN, sbp.ArBatchUid, sbp.ArBatchName,
                     ISNULL(ILN.InsuranceLevelName,'''') AS InsuranceLevelName,
                     CAST(ISNULL(VSPIV.IsVoid, 0) AS BIT) AS IsVoid,
					 VSF.LastFollowupModifiedByUid, VSF.LastFollowupModifiedDate, VSF.LastFollowupByUser, VSF.LastFollowupAll, VSF.MaxFollowupModifiedDate,
					 SBP.SuperbillProcedureCount,
					 act.AccountResponsiblePartyUid -- 7440
     FROM   ViewSuperbillProcedure sbp 
                     LEFT JOIN AR_ViewSuperbillAggregate VSA ON sbp.SuperbillUid = VSA.SuperbillUid 
                     INNER JOIN AR_ViewSuperbillProcedureAggregate VSBPA ON SBP.SuperbillProcedureUid = VSBPA.SuperbillProcedureUid
                     INNER  JOIN ViewSuperbillCurrentLiabilityOwnerAndCarrier vsclo ON vsclo.superbillUid = sbp.SuperbillUid
					 INNER JOIN Superbill sb on sbp.SuperbillUid = sb.SuperbillUid	-- 7440
					 INNER JOIN Account act on sb.AccountUid = act.AccountUid		-- 7440
                     LEFT JOIN ListInsuranceLevelName ILN ON vsclo.CurrentCarrier = ILN.InsuranceLevel
                     LEFT JOIN ViewSuperbillProcedure_IsVoid VSPIV ON sbp.SuperbillProcedureUid = VSPIV.SuperbillProcedureUid
					 LEFT JOIN ViewSuperbillFollowup VSF ON sbp.SuperbillUid = VSF.SuperbillUid








' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_PracticeSettings]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[MDOL_RPT2_VIEW_PracticeSettings]
AS
SELECT TOP 1 * FROM PracticeSettings WITH (NOLOCK)




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementResponsibleParty_MainAccountBase]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewStatementResponsibleParty_MainAccountBase]
AS
/*	This is the source for electronic statements and also for paper statements, indirectly via
	the stored proc MDOL_RPT2_StatementHeader_MainAccount/ One record per responsible party with active accounts.
*/
/*
	01/28/2008 - Qatalys - #12798 - Modified Balance with BalanceAll
	01/22/2009 - Qatalys		  - Modified to replace PersonBalanceAll,AccountBalanceAll of Account
*/
SELECT DISTINCT 
	RPUid,
	FinancialCenterUid, 
	PersonUid,
	CorporationUid,
	PracticeSettingsUid,
	CustomerName, 
	CreditCard1,
	CreditCard2,
	CreditCard3,
	CreditCard4,
	CreditCard5,
	CreditCard6,
	RPID, 
	RPName,
	RemitToName, 
	StatementDate, 
	DueDate, 
	StatementMinimumAmount,
	AmountDue,
	TotalBalance, 
	PatientBalance, 
	InsuranceBalance, 
	Note,
	StatementsByFinancialCenter,
--	Age ,
--	DunningMsgsUid,
	(CASE WHEN Age <=30 THEN Dn.DunningMsg1
	WHEN Age <=30 THEN Dn.DunningMsg1
	WHEN Age >=31 AND Age <=60 THEN Dn.DunningMsg2
	WHEN Age >=61 AND Age <=90 THEN Dn.DunningMsg3
	WHEN Age >=91 AND Age <=120 THEN Dn.DunningMsg4
	WHEN Age >=121  THEN Dn.DunningMsg5
	ELSE ''''
	END) DunningMsg,
	SuperBills
FROM (
SELECT
	AccountResponsibleParty.AccountResponsiblePartyUid as RPUid,
	(CASE WHEN PracticeSettings.StatementsByFinancialCenter = 1 THEN FinancialCenter.FinancialCenterUid ELSE ''00000000-0000-0000-0000-000000000000'' END) as FinancialCenterUid, 
	(CASE WHEN PracticeSettings.StatementsByFinancialCenter = 1 THEN FinancialCenter.Name  ELSE PracticeSettings.Name END) as CustomerName, 
	AccountResponsibleParty.PersonUid,
	AccountResponsibleParty.CorporationUid,
	PracticeSettings.PracticeSettingsUid,
	PracticeSettings.StatementsByFinancialCenter,
	ISNULL(dbo.getCreditCardName(1),'''')  AS CreditCard1,
	ISNULL(dbo.getCreditCardName(2),'''')  AS CreditCard2,
	ISNULL(dbo.getCreditCardName(3),'''')  AS CreditCard3,
	ISNULL(dbo.getCreditCardName(4),'''')  AS CreditCard4,
	ISNULL(dbo.getCreditCardName(5),'''')  AS CreditCard5,
	ISNULL(dbo.getCreditCardName(6),'''')  AS CreditCard6,
	(CASE WHEN PracticeSettings.StatementsByFinancialCenter = 1 THEN FinancialCenter.Name ELSE PracticeSettings.Name END) as RemitToName, 
--	dbo.getSuperbillOfResposibleParty(AccountResponsibleParty.AccountResponsiblePartyUid,FinancialCenter.FinancialCenterUid) as SuperBills,
	AccountResponsibleParty.ExternalID as RPID, 
	--(CASE WHEN AccountResponsibleParty.PersonUid IS NOT NULL THEN dbo.UDF_getFormattedPreferredName(AccountResponsibleParty.PersonUid) 
	--	WHEN AccountResponsibleParty.CorporationUid IS NOT NULL THEN Corporation.Name 
	--	END) as RPName,
	(CASE WHEN AccountResponsibleParty.PersonUid IS NOT NULL THEN ISNULL(Person.FirstName,'''') + '' ''+ ISNULL(Person.MiddleName,'''') +'' ''+ ISNULL(Person.LastName,'''')
		WHEN AccountResponsibleParty.CorporationUid IS NOT NULL THEN Corporation.Name 
		END) as RPName, 
	CAST(GetDate() AS DATE) as StatementDate, 
	(CASE WHEN PracticeSettings.StatementsByFinancialCenter = 1 THEN CAST(DATEADD(day, FinancialCenter.StatementDueDays, GetDate()) AS DATE) ELSE CAST(DATEADD(day, PracticeSettings.StatementDueDays, GetDate()) AS DATE) END) as DueDate, 
	(CASE WHEN PracticeSettings.StatementsByFinancialCenter = 1 THEN FinancialCenter.StatementMinimumAmount  ELSE PracticeSettings.StatementMinimumAmount END) AS StatementMinimumAmount,
--	Sum(Account.PersonBalanceAll) as AmountDue, 
	(CASE WHEN PracticeSettings.StatementsByFinancialCenter = 1 THEN  
		(SELECT ISNULL(SUM(BalanceAll),0) 
			FROM [ViewStatementBalanceandAge_MainAccount] V 
			WHERE 
				FinancialCenter.FinancialCenterUid = V.FinancialCenterUid 
			AND AccountResponsibleParty.AccountResponsiblePartyUid=V.AccountResponsiblePartyUid)
--			AND (FinancialCenter.InsuranceBalanceOnlySuperbills=1 OR Patient != 0  ))
	ELSE
		Sum(VA.LiabilityBalance-VA.AssignedLiabilityBalance )
	END)AS AmountDue,
	Sum(VA.LiabilityBalance) as TotalBalance, 
	Sum(VA.LiabilityBalance-VA.AssignedLiabilityBalance) as PatientBalance, 
	Sum(VA.AssignedLiabilityBalance) as InsuranceBalance, 
	'''' as Note,
	(CASE WHEN PracticeSettings.StatementsByFinancialCenter = 1 THEN 
		 (SELECT MAX(DATEDIFF(DD, LiabilityDate, GETUTCDATE())) AS LiabilityDate 
			FROM [ViewStatementBalanceandAge_MainAccount] V 
			WHERE 
				FinancialCenter.FinancialCenterUid = V.FinancialCenterUid 
			AND AccountResponsibleParty.AccountResponsiblePartyUid=V.AccountResponsiblePartyUid
		  ) 
	ELSE 
		(SELECT MAX(DATEDIFF(DD, LiabilityDate, GETUTCDATE())) AS LiabilityDate
			FROM [ViewStatementBalanceandAge_MainAccount] V 
			WHERE 
				AccountResponsibleParty.AccountResponsiblePartyUid=V.AccountResponsiblePartyUid
--		AND (PracticeSettings.InsuranceBalanceOnlySuperbills=1 OR Patient != 0 ) 
		)
	END) AS Age ,
	(CASE WHEN PracticeSettings.StatementsByFinancialCenter = 1 THEN FinancialCenter.DunningMsgsUid  ELSE PracticeSettings.DunningMsgsUid END) AS DunningMsgsUid,
	(CASE WHEN PracticeSettings.StatementsByFinancialCenter = 1 THEN dbo.getSuperbillOfResposibleParty_MainAccount( AccountResponsibleParty.AccountResponsiblePartyUid, FinancialCenter.FinancialCenterUid) ELSE dbo.getSuperbillOfResposibleParty_MainAccount( AccountResponsibleParty.AccountResponsiblePartyUid, NULL) END) AS SuperBills
	FROM Account
		INNER JOIN		
			AccountResponsibleParty
		ON
			Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid 
		INNER JOIN 
			AR_ViewAccountAggregate  VA
		ON
			Account.AccountUid=VA.AccountUid
		LEFT JOIN Person ON Person.PersonUid = AccountResponsibleParty.PersonUid 
		LEFT JOIN Corporation ON Corporation.CorporationUid = AccountResponsibleParty.CorporationUid , 
		--PracticeSettings 
		MDOL_RPT2_VIEW_PracticeSettings PracticeSettings
		LEFT JOIN FinancialCenter ON PracticeSettings.StatementsByFinancialCenter = 1 AND FinancialCenter.Inactive=0

	WHERE 
		--Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid 
		Account.Inactive = 0 AND Account.IsMain=1
--		AND FinancialCenter.Inactive=0
	GROUP BY
--		PracticeSettings.Name, 
		FinancialCenter.Name,
		FinancialCenter.FinancialCenterUid,
		AccountResponsibleParty.PersonUid,
		AccountResponsibleParty.CorporationUid,
		AccountResponsibleParty.AccountResponsiblePartyUid, 
		AccountResponsibleParty.ExternalID, 
		Corporation.Name, 
		AccountResponsibleParty.PersonUid, 
		AccountResponsibleParty.CorporationUid, 
		PracticeSettings.PracticeSettingsUid,
		FinancialCenter.StatementDueDays,
		FinancialCenter.StatementMinimumAmount,
		FinancialCenter.DunningMsgsUid,
		FinancialCenter.InsuranceBalanceOnlySuperbills,
		PracticeSettings.Name, 
		PracticeSettings.StatementDueDays,
		PracticeSettings.StatementMinimumAmount,
		PracticeSettings.DunningMsgsUid,
		PracticeSettings.InsuranceBalanceOnlySuperbills,
		PracticeSettings.StatementsByFinancialCenter,
		Person.FirstName,
		Person.LastName,
		Person.MiddleName  
) Temp
LEFT JOIN
	DunningMsgs Dn
ON
	Temp.DunningMsgsUid=Dn.DunningMsgsUid
--Where Temp.SuperBills is not null



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillInsurancePlanLiabilityOwnerAggregate]'))
EXEC dbo.sp_executesql @statement = N'

 CREATE VIEW [dbo].[AR_ViewSuperbillInsurancePlanLiabilityOwnerAggregate]   
  AS  
  SELECT SBP.SuperbillUid,InsurancePlanUid,  LD.LiabilityOwner,  
		  SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.Amount ELSE 0 END) As Liability,   
		  SUM(LD.Amount) As LiabilityBalance,   COUNT_BIG(*) AS Count  
	  FROM dbo.AR_LedgerDetail LD          
		INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
		JOIN dbo.SuperbillProcedure SBP ON LD.SuperbillProcedureUId=SBP.SuperbillProcedureUId
	  WHERE NOT LD.InsurancePlanUid IS NULL AND NOT LD.SuperbillProcedureUid IS NULL   
	  GROUP BY SBP.SuperbillUid, LD.InsurancePlanUid,LD.LiabilityOwner           
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureInsurancePlanLiabilityOwnerAggregate]'))
EXEC dbo.sp_executesql @statement = N'
 CREATE VIEW [dbo].[AR_ViewSuperbillProcedureInsurancePlanLiabilityOwnerAggregate]   
  AS  
  SELECT LD.SuperbillProcedureUid,InsurancePlanUid,  LD.LiabilityOwner,  
		  SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.Amount ELSE 0 END) As Liability,   
		  SUM(LD.Amount) As LiabilityBalance,   COUNT_BIG(*) AS Count  
	  FROM dbo.AR_LedgerDetail LD          
		INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
	  WHERE NOT LD.InsurancePlanUid IS NULL AND NOT LD.SuperbillProcedureUid IS NULL   
	  GROUP BY LD.SuperbillProcedureUid, LD.InsurancePlanUid,LD.LiabilityOwner           

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_insuranceaging]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[MDOL_RPT2_VIEW_insuranceaging]  
AS 
--2016.02.18 dmg added with (nolock)  
SELECT   
 dbo.UDF_getFormattedPreferredNameFromValues(P.FirstName,P.LastName,P.MiddleName,P.Suffix) AS preferredName,  
 Convert(varchar(50),P.PersonUid) as PatientUid,  
 ISNULL(VSF.ClaimingProviderUid ,VSF.RenderingProviderUid) as ClaimingProviderUid,  
  VSF.RenderingProviderUid as RenderingProviderUid,  
  ISNULL(P.BirthDate,'''') as Birthdate,  
  VSPIL.Liabilityowner as Liabilityowner,  
  ISNULL(c.CorporationUid,'''')as CorporationUid,  
  COALESCE(c.Phone1, c.Phone2, c.Phone3, c.Phone4).value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS MemberServicesPhone,  
  ISNULL(IP.Name,'''') as PlanName,  
  ISNULL(PersonInsurancePlan.PlanMemberID,''-'') as PlanMemberID,  
  ISNULL(C.Name,'''') as CorporationName,  
  ISNULL(S.ExternalID,''ACCOUNT'') as SuperBillID,  
  ISNULL(S.ServiceDateStart,'''') as SuperBillDate,  
  ISNULL(VSPIL.LiabilityBalance,0) AS  BalanceAll, 
  ISNULL(VSIPL.LiabilityBalance,0) AS  SuperbillBalanceAll,   
  VSA.Age as Age,  
  DATEDIFF(DD, SP.ProcedureServiceDateStart, GETDATE()) as ServiceAge,  
  VSF.FinancialCenterUID as FinancialCenterUid,  
  S.SuperBillUid as Superbilluid,  
  S.ServiceDateStart as ServiceDateStart,  
  LA2.AccountTypeUid,  
  LA2.Name as PlanAccountType,  
  VSF.ServiceSiteUid as ServiceSiteUid,  
  SP.SuperbillProcedureUid,  
  IP.InsurancePlanUid,  
  CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed   
FROM  
 [AR_ViewSuperbillProcedureInsurancePlanLiabilityOwnerAggregate] VSPIL  WITH(NOLOCK) --2016.02.18 dmg
 
JOIN  
 SuperbillProcedure SP    WITH(NOLOCK) --2016.02.18 dmg
ON  
 VSPIL.SuperbillProcedureUid =SP.SuperbillProcedureUid   
JOIN  
 Superbill S    WITH(NOLOCK) --2016.02.18 dmg
ON  
 S.SuperbillUid = SP.SuperbillUid 
 JOIN
  [AR_ViewSuperbillInsurancePlanLiabilityOwnerAggregate] VSIPL   WITH(NOLOCK) --2016.02.18 dmg 
ON  
 S.SuperbillUid = VSIPL.SuperbillUid AND VSIPL.InsurancePlanUid = VSPIL.InsurancePlanUid  and  VSIPL.LiabilityOwner= VSPIL.LiabilityOwner
JOIN  
 Person  P    WITH(NOLOCK) --2016.02.18 dmg
ON  
 S.PatientUid = P.PersonUid   
JOIN  
 ViewSuperbillFinancialDetails  VSF    WITH(NOLOCK) --2016.02.18 dmg
ON  
 VSF.SuperbillUid = S.SuperbillUid   
JOIN  
 InsurancePlan IP    WITH(NOLOCK) --2016.02.18 dmg
ON  
 VSPIL.InsurancePlanUid =IP.InsurancePlanUid   
JOIN  
 Corporation C    WITH(NOLOCK) --2016.02.18 dmg
ON  
 IP.InsuranceCarrierUid =C.CorporationUid   
JOIN  
   [AR_ViewSuperbillProcedureAge] VSA    WITH(NOLOCK) --2016.02.18 dmg
 ON  
  VSPIL.SuperbillProcedureUid = VSA.SuperbillProcedureUid AND VSPIL.LiabilityOwner = VSA.LiabilityOwner  
JOIN  
 Account A    WITH(NOLOCK) --2016.02.18 dmg
ON  
 S.AccountUid =A.AccountUid   
LEFT JOIN  
 ListAccountType LA2    WITH(NOLOCK) --2016.02.18 dmg
ON  
 IP.AccountTypeUid =LA2.AccountTypeUid   
JOIN  
 [AR_ViewSuperbillProcedureBatch] SPB    WITH(NOLOCK) --2016.02.18 dmg
ON  
 SPB.SuperbillProcedureUid =SP.SuperbillProcedureUid   
JOIN  
 AR_ViewBatchClosingsLockedClosed VARB    WITH(NOLOCK) --2016.02.18 dmg
ON  
 SPB.ArBatchUid = VARB.ARBatchUid  
LEFT JOIN   
 AccountPeriod     WITH(NOLOCK) --2016.02.18 dmg
ON   
 AccountPeriod.AccountUid = A.AccountUid  
 AND (AccountPeriod.EffectiveDate IS NULL OR AccountPeriod.EffectiveDate <= S.ServiceDateEnd)  
 AND (AccountPeriod.ExpirationDate IS NULL OR AccountPeriod.ExpirationDate >= S.ServiceDateEnd)  
LEFT JOIN  
 ListAccountType LA1    WITH(NOLOCK) --2016.02.18 dmg
ON  
 AccountPeriod.AccountTypeUid =LA1.AccountTypeUid   
LEFT JOIN   
 AccountInsurance    WITH(NOLOCK) --2016.02.18 dmg 
ON   
 AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
 AND AccountInsurance.DisplayOrder = VSPIL.LiabilityOwner  
LEFT JOIN   
 PersonInsurancePlan     WITH(NOLOCK) --2016.02.18 dmg
ON   
 AccountInsurance.PersonInsurancePlanUid=PersonInsurancePlan.PersonInsurancePlanUid --AccountInsurance.PersonInsurancePlanUid  
--WHERE VSPIL.LiabilityBalance <> 0   



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindAttachments]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewFindAttachments]
AS
SELECT        rag.RelAttachmentGroupUid, rag.AttachmentGroupUid, a.AttachmentUid, rag.PersonUid, rag.VisitUid, rag.AccountResponsiblePartyUid, rag.DepositUid, 
                         ag.AttachmentTypeUid, at.Name AS AttachmentType, ag.Name, CAST(CASE WHEN ag.StrikeOut = 1 OR
                         a.StrikeOut = 1 THEN 1 ELSE 0 END as bit) AS StrikeOut, a.FileName, a.FileExtension, ISNULL(a.FileDate, v.VisitDate) AS Date, p.FullName AS Person
FROM            dbo.RelAttachmentGroup AS rag INNER JOIN
                         dbo.AttachmentGroup AS ag ON rag.AttachmentGroupUid = ag.AttachmentGroupUid INNER JOIN
                         dbo.Attachment AS a ON ag.AttachmentGroupUid = a.AttachmentGroupUid LEFT OUTER JOIN
                         dbo.ViewPerson AS p ON rag.PersonUid = p.PersonUid LEFT OUTER JOIN
                         dbo.Visit AS v ON rag.VisitUid = v.VisitUid LEFT OUTER JOIN
                         dbo.ListAttachmentType AS at ON ag.AttachmentTypeUid = at.AttachmentTypeUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillAccountInsurance_All]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewSuperbillAccountInsurance_All]
AS
select s.SuperbillUid,
	s.ExternalID,
	a.AccountUid,
	a.Name,
	ap.AccountPeriodUid,
	ap.EffectiveDate,
	ap.ExpirationDate,
	ai.AccountInsuranceUid,
	ai.DisplayOrder,
	ip.Name as InsurancePlanName,
	co.Name as InsurancePayerName,
	co.Name + ''/'' + ip.Name as InsuranceName,
	s.ServiceDateStart as SuperbillServiceDateStart,
	s.ServiceDateEnd as SuperbillServiceDateEnd,
	a.PersonUid
from Superbill s
 inner join Account a on
  a.AccountUid = s.AccountUid
 inner join AccountPeriod ap on
  a.AccountUid = ap.AccountUid
  and (ap.EffectiveDate is null or ap.EffectiveDate <= s.ServiceDateEnd) -- MUST use Service Date End - Otherwise superbill could SPAN multiple periods and we loose the correct period
  and (ap.ExpirationDate is null or DateAdd(dd, 1, ap.ExpirationDate) > s.ServiceDateEnd) -- above see Bug 27722 - Using end to be consistant with superbill fetch
 left join AccountInsurance ai on
  ai.AccountPeriodUid = ap.AccountPeriodUid
  left join PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
  left join InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
  left join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
  left join Corporation co on ic.CorporationUid = co.CorporationUid


/*
	Allows for Superbills WITH or WITHOUTAccountInsurances
*/




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillAccountInsurance]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewSuperbillAccountInsurance]
AS
select *
from ViewSuperbillAccountInsurance_All
where not DisplayOrder is null

/*
	Allows for Superbills only WITH AccountInsurances
*/


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewInsuranceCarrier]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewInsuranceCarrier] AS
SELECT	ic.CorporationUid, c.Name, 
		c.[Address],
		c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') AS Address1,
		c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') AS Address2,
		c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') AS City,
		c.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'') AS [State],
		c.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') AS Zip,
		c.Phone1,
		c.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS PhoneNumber,
		c.Phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS PhoneType,
        REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(c.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''), ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', '''') AS PhoneNumber1Scrubbed, 
        ic.Notes, ic.ExternalID,
        ic.Inactive | c.Inactive AS Inactive,
		ic.ICD10Date
FROM    dbo.InsuranceCarrier AS ic LEFT OUTER JOIN
        dbo.Corporation AS c ON c.CorporationUid = ic.CorporationUid 




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewLedgerExtended]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewLedgerExtended] AS
SELECT  LD.LedgerDetailUid, LD.LedgerUid, L.TransactionUid, TR.ReferenceNumber AS TransactionReferenceNumber,
	L.VoidLedgerUid, COALESCE(L.VoidLedgerUid, VL.LedgerUid) AS ReversalPartnerUid, 
	L.EntryDate, L.EntryType, L.ArBatchUid, ARB.GlDate as PostingDate, ISNULL(L.ShortName,'''') AS ShortName, L.Reconciled,
	CASE WHEN LD.IsCredit = 0 THEN LD.Amount ELSE 0.00 END AS Debit, 
	CASE WHEN LD.IsCredit = 1 THEN -LD.Amount ELSE 0.00 END AS Credit, LD.IsCredit, LD.Amount,
	LD.LedgerAccountUid, LD.IncomeAccountUid, LD.AccountResponsiblePartyUid, LD.InsurancePayerUid,
	LD.DepositUid,LD.PayerCreditUid, PC.Note AS PayerCreditNote, LD.SuperbillProcedureUid, LD.LiabilityOwner, 
	LD.InsurancePlanUid, 
	CASE WHEN L.EntryType = 2 AND LD.IsCredit = 0 THEN LD_OS.ClaimingProviderUid ELSE LD.ClaimingProviderUid END AS ClaimingProviderUid, 
	CASE WHEN L.EntryType = 2 AND LD.IsCredit = 0 THEN LD_OS.RenderingProviderUid ELSE LD.RenderingProviderUid END AS RenderingProviderUid, 
	CASE WHEN L.EntryType = 2 AND LD.IsCredit = 0 THEN LD_OS.FinancialCenterUid ELSE LD.FinancialCenterUid END AS FinancialCenterUid, 
	CASE WHEN L.EntryType = 2 AND LD.IsCredit = 0 THEN LD_OS.ServiceSiteUid ELSE LD.ServiceSiteUid END AS ServiceSiteUid, 
	L.CreatedDateTime, ACT.AccountResponsiblePartyUid AS ResponsibleAccountResponsiblePartyUid,
	IPL.InsuranceCarrierUid AS ResponsibleInsurancePayerUid,
	L.LastModifiedByUid,
	ARB.Name AS ArBatchName,
	ARB.IsLocked AS ArBatchIsLocked,
	ARB.IsClosed AS ArBatchIsClosed,
	DEP.ReferenceNumber AS DepositReferenceNumber, VSBP.SuperbillUid, VSBP.SuperbillExternalId AS ExternalID,
	VRP.FullName AS RenderingProviderFullName, 
	VCP.FullName AS ClaimingProviderFullName,
	VPL.Name AS InsurancePayerPlanName,
	SS.Name AS ServiceSiteName, FC.Name AS FinancialCenterName,
	COALESCE(VP.FullName, VPA.Name,'''') AS PayerName,
	CASE WHEN NOT DEP.DepositUid IS NULL THEN ''Payment  '' + DEP.ReferenceNumber + '' - '' + COALESCE(VP.FullName, VPA.Name) 
		WHEN NOT VSBP.SuperbillProcedureUid IS NULL THEN ''Charge  '' + VSBP.SuperbillExternalId + '' - '' + VSBP.Code + '' - '' + COALESCE(VPSBL.FullName, VPL.Name)
		WHEN NOT LD.LedgerAccountUid IS NULL THEN ''Lockbox  ''
		WHEN NOT LD.IncomeAccountUid IS NULL THEN ''IncomeExpense  '' 
		ELSE ''Unallocated  ''
	END AS [Description], 
    CASE 
		WHEN L.EntryType = 0 THEN ''Deposit ('' + ISNULL(DEP.ReferenceNumber,''<NA>'') + '')'' 
		WHEN L.EntryType = 1 THEN ''Charge ('' + ISNULL(VSBP.SuperbillExternalId,''<NA>'') + ''/''
			+ ISNULL(VSBP.Code,'''') + '')'' 
		WHEN L.EntryType = 2 THEN ''Payment ('' + ISNULL(TR.ReferenceNumber,''<NA>'') + '')'' 
		WHEN L.EntryType = 3 THEN ''Adjustment ('' + ISNULL(TR.ReferenceNumber,''<NA>'') + '')'' 
		WHEN L.EntryType = 4 THEN ''Transfer ('' + ISNULL(TR.ReferenceNumber,''<NA>'') + '')'' 
		ELSE '''' 
    END AS ReferenceDescription,
	CAST(0 AS MONEY) AS InsuranceBalance, CAST(0 AS MONEY) AS TotalBalance,
	CAST(0 AS BIT) AS SearchResult -- using this as a tag ... this one is the primary detail to show in the grid, the rest in the ledgeruid are splits
FROM AR_LedgerDetail LD
		INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
		INNER JOIN AR_LedgerDetail LD_OS ON LD.LedgerUid = LD_OS.LedgerUid AND LD.LedgerDetailUid <> LD_OS.LedgerDetailUid
		INNER JOIN ARBatch ARB ON L.ARBatchUid = ARB.ARBatchUid
		LEFT JOIN AR_Ledger VL ON L.LedgerUid = VL.VoidLedgerUid
		LEFT JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			LEFT JOIN Superbill SBL ON SBP.SuperbillUid = SBL.SuperbillUid
			LEFT JOIN Account ACT ON SBL.AccountUid = ACT.AccountUid
		LEFT JOIN InsurancePlan IPL ON LD.InsurancePlanUid = IPL.InsurancePlanUid
	LEFT JOIN AR_Transaction TR ON L.TransactionUid = TR.TransactionUid
	LEFT JOIN Deposit DEP ON LD.DepositUid = DEP.DepositUid
	LEFT JOIN AR_PayerCredit PC ON LD.PayerCreditUid = PC.PayerCreditUid
	LEFT JOIN AccountResponsibleParty ARP ON LD.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid -- on deposit
		LEFT JOIN ViewPerson VP ON ARP.PersonUid = VP.PersonUid
	LEFT JOIN ViewInsuranceCarrier VPA ON LD.InsurancePayerUid = VPA.CorporationUid
	LEFT JOIN ViewSuperbillProcedureSub (NOEXPAND) VSBP ON LD.SuperbillProcedureUid = VSBP.SuperbillProcedureUid
		LEFT JOIN AccountResponsibleParty ARPSBL ON VSBP.AccountResponsiblePartyUid = ARPSBL.AccountResponsiblePartyUid
		LEFT JOIN ViewPerson VPSBL ON ARPSBL.PersonUid = VPSBL.PersonUid
	LEFT JOIN ViewInsurancePlan VPL ON LD.InsurancePlanUid = VPL.InsurancePlanUid
	LEFT JOIN ViewProvider VRP ON (CASE WHEN L.EntryType = 2 AND LD.IsCredit = 0 THEN LD_OS.RenderingProviderUid ELSE LD.RenderingProviderUid END) = VRP.PersonUid
	LEFT JOIN ViewProvider VCP ON (CASE WHEN L.EntryType = 2 AND LD.IsCredit = 0 THEN LD_OS.ClaimingProviderUid ELSE LD.ClaimingProviderUid END) = VCP.PersonUid
	LEFT JOIN ListServiceSite SS ON (CASE WHEN L.EntryType = 2 AND LD.IsCredit = 0 THEN LD_OS.ServiceSiteUid ELSE LD.ServiceSiteUid END) = SS.ServiceSiteUid
	LEFT JOIN FinancialCenter FC ON (CASE WHEN L.EntryType = 2 AND LD.IsCredit = 0 THEN LD_OS.FinancialCenterUid ELSE LD.FinancialCenterUid END) = FC.FinancialCenterUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindClaimBatch]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewFindClaimBatch]  
AS    
SELECT
 ClaimBatch.ClaimBatchUid,  
 ClaimBatch.ClaimDate,  
 (select count(ClaimBatchDetail.Status)  
  from ClaimBatchDetail  
  where  
   ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid  
 ) as ClaimCount,  
 (select sum(VLE.Amount)
  from ClaimBatchDetail  
  INNER JOIN Superbill s on  
   s.SuperbillUid = ClaimBatchDetail.SuperbillUid  
   INNER JOIN AR_ViewLedgerExtended VLE ON S.SuperbillUid = VLE.SuperbillUid AND 
	VLE.EntryType = 1 
  where  
   ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid  
 ) as ClaimBatchAmount,  
 ClaimBatch.ClaimingUserUid,  
 Person.LastName + '', '' + dbo.Person.FirstName AS CreatorFullName,  
 '''' AS Name,  
 ecf.eClaimFileUid,
 ClaimBatch.ClaimFormatTypeUid,
 lcft.Name as ClaimFormatTypeName,
 CAST(CASE WHEN ecf.Data is null THEN 0 ELSE 1 END AS BIT) AS HasClaimFileData,
 ecf.TransmissionStatusUid,
 lcbs.Name as TransmissionStatusName,
 ecf.TransmissionDate
FROM ClaimBatch  
 INNER JOIN UserPRM ON   
  UserPRM.PersonUid = ClaimBatch.ClaimingUserUid  
 INNER JOIN Person ON  
  Person.PersonUid = UserPRM.PersonUid   
 LEFT JOIN eClaimFile ecf ON  
  ecf.eClaimFileUid = ClaimBatch.eClaimFileUid  
 LEFT JOIN ListClaimFormatType lcft on
  lcft.ClaimFormatTypeUid = ClaimBatch.ClaimFormatTypeUid
 LEFT JOIN ListClaimBatchStatus lcbs on
  lcbs.BatchStatusUid = ecf.TransmissionStatusUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillChargesAllInsurance]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbillChargesAllInsurance] AS
	SELECT		VSA.SuperbillUid,
				VSA.AssignedLiability AS Amount, 
				CAST(0 AS MONEY) AS Balance, -- old preposting balance ... no longer using
				AssignedLiabilityBalance AS BalanceAll
	FROM		AR_ViewSuperbillAggregate VSA

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_PatientAging_LastPaymentDate]'))
EXEC dbo.sp_executesql @statement = N'/*Pancratius 12/30/2013 Removed current date conversion function  from all date columns*/


CREATE VIEW [dbo].[MDOL_RPT2_View_PatientAging_LastPaymentDate] 
AS
SELECT  CONVERT(VARCHAR (32),(max(d.DepositDate)),101) as LastPaymentDate,
SB.AccountUid,SB.PatientUid 
				FROM ViewDeposit AS d with (nolock)					
					LEFT JOIN AR_Transaction T1 with (nolock) ON d.DepositUid = T1.DepositUid
					INNER JOIN Superbill SB with (nolock) ON T1.SuperbillUid = SB.SuperbillUid 
					--INNER JOIN Account on SB.AccountUId = Account.AccountUid 
					--where SB.AccountUId = Account.AccountUid 
					Group by SB.AccountUid,SB.PatientUid--,d.DepositDate



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindCompletedNotes]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewFindCompletedNotes]
AS
SELECT     v.VisitUid, v.VisitDate, v.CompletedDate, v.PatientUid, v.ProviderUid, bp.FullName AS BillingProviderName, v.RenderingProviderUid, 
                      rp.FullName AS RenderingProviderName, v.ServiceSiteUid, s.Name AS ServiceSiteName, p.ExternalID, p.FullName, p.AkaName, p.Birthdate, 
                      p.SocialSecurityNumber, p.MedicalRecordNumber, p.Gender, p.PhoneNumber, v.PatientCaseUid
FROM         dbo.Visit AS v INNER JOIN
                      dbo.ViewFindPatient AS p ON v.PatientUid = p.PersonUid LEFT OUTER JOIN
                      dbo.ViewPerson AS bp ON v.ProviderUid = bp.PersonUid LEFT OUTER JOIN
                      dbo.ViewPerson AS rp ON v.RenderingProviderUid = rp.PersonUid LEFT OUTER JOIN
                      dbo.ListServiceSite AS s ON v.ServiceSiteUid = s.ServiceSiteUid
WHERE     (v.IsCompleted = 1)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_PatientAging_Unallocated]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[MDOL_RPT2_View_PatientAging_Unallocated] 
AS
SELECT  MAX(ISNULL(VD.ReceiptBalance ,0)) as Unallocated,LD.SuperbillProcedureUid
			FROM ViewDeposit D WITH (NOLOCK)
			LEFT JOIN AR_ViewDepositAggregate VD with (nolock) ON D.DepositUid=VD.DepositUid
			LEFT JOIN AR_Transaction T with (nolock)On D.DepositUid =T.DepositUid 
			LEFT JOIN AR_Ledger L with (nolock) ON L.TransactionUid  =T.TransactionUid AND (L.EntryType =2 OR L.EntryType =3)	
			LEFT JOIN ARBatch AR with (nolock) ON L.ArBatchUid = AR.ARBatchUid	 
			LEFT JOIN AR_LedgerDetail LD with (nolock) ON L.LedgerUid  =LD.LedgerUid  AND LD.IsCredit=1 AND LD.SuperbillProcedureUid IS NOT NULL
			Group By LD.SuperbillProcedureUid
			--WHERE LD.SuperbillProcedureUid  = AR_LedgerDetail.SuperbillProcedureUid AND AR_LedgerDetail.LiabilityOwner = 0   


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMasterPharmacy]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewMasterPharmacy] AS
SELECT	mp.MasterPharmacyUid, 
		mp.Inactive, 
		mp.Name, 
		mp.ExternalID, 
		mp.Notes, 
		lpch.PharmacyClearinghouseUid, 
		lpch.Name AS PharmacyClearinghouseName, 
		mp.[Address],
		mp.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') AS Address1,
		mp.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') AS Address2,
		mp.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') AS City,
		mp.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'') AS [State],
		mp.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') AS Zip,
		mp.PartnerAccount, 
		mp.IsFaxOnly,
		mp.CrossStreet,
		dbo.ServiceLevelCode(mp.ServiceLevelCode) AS ServiceLevelCode,
		mp.MailOrderEnabled,
		dbo.SpecialtyIDCode(mp.SpecialtyID) AS SpecialtyIDCode
FROM  dbo.MasterPharmacy AS mp 
	LEFT OUTER JOIN dbo.ListPharmacyClearinghouse AS lpch ON lpch.PharmacyClearinghouseUid = mp.PharmacyClearinghouseUid 

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[PrintTextEPCSRefillResponse]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[PrintTextEPCSRefillResponse] AS
WITH XMLNAMESPACES (''http://www.ncpdp.org/schema/SCRIPT'' as x)
SELECT 
   rvm.RelVisitMedicationUid,
   PrintText = ''(Response to an electronic controlled substance refill request - RxReferenceNumber: ''
             + CONVERT(VARCHAR(MAX), mrx.MessageXML.query(''data(//x:RefillRequest.eRxService/@RxReferenceNumber)'')) 
             + '')''
FROM RelVisitMedication rvm
INNER JOIN MedicationSIG sig ON sig.MedicationSIGUid = rvm.MedicationSIGUid
INNER JOIN MessageERxRefillRequest mrx ON mrx.RelVisitMedicationUid = rvm.RelVisitMedicationUid
INNER JOIN Visit vis ON vis.VisitUid = rvm.VisitUid
INNER JOIN ViewPerson pat ON pat.PersonUid = vis.PatientUid
LEFT JOIN ViewMasterPharmacy vmp ON vmp.MasterPharmacyUid = mrx.MasterPharmacyUid
                                AND vmp.MailOrderEnabled = 0
LEFT JOIN RelMedicationStateScheduledDrugName drg ON drg.DrugNameUid = dbo.IntToGUID(sig.FDB_MNID)
LEFT JOIN ListMedicationStateScheduled sts ON sts.State IN(pat.Address1_State, vmp.State)
                                          AND sts.MedicationStateScheduledUid = drg.MedicationStateScheduledUid
WHERE mrx.MessageXML IS NOT NULL
  AND   (sig.FederalDEAClassCode IS NULL
      OR sig.FederalDEAClassCode != 0
      OR mrx.MessageXML.value(''(//x:MedicationPrescribed/x:DrugCoded/x:DEASchedule)[1]'', ''varchar(50)'') != ''''
      OR sts.Schedule > 0)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_PatientAging]'))
EXEC dbo.sp_executesql @statement = N'
/*Pancratius 12/30/2013 Removed current date conversion function  from all date columns*/





CREATE VIEW [dbo].[MDOL_RPT2_View_PatientAging] 
AS 
SELECT    
		--Charge.ChargeUid,  
		Account.PersonUid AS patientID,
		CASE WHEN Superbill.SuperbillUid IS NULL THEN ''Account'' ELSE SuperBill.ExternalID END AS ExternalID,
		Superbill.SuperbillUid AS SuperbillID, 
		Account.AccountResponsiblePartyUid, 
		CASE   
			WHEN AccountResponsibleParty.PersonUid IS NOT NULL  
				THEN [dbo].[UDF_getFormattedPreferredNameFromValues]
						(
							p2.FirstName,
							p2.LastName,
							p2.MiddleName,
							p2.Suffix
						)
			WHEN AccountResponsibleParty.CorporationUid IS NOT NULL  
				THEN Corporation.Name  
		END AS ResponsiblePartyName,  
		CONVERT(VARCHAR(32),Superbill.ServiceDateStart, 101) AS  serviceDate,  
		CASE WHEN Superbill.SuperbillUid IS NOT NULL THEN dbo.UDF_getCPTCode(Superbill.SuperbillUid,0) ELSE '''' END AS CPTCode,
		(Account.LastStatementDate) AS LastStatementDate,		
		LPymnt.LastPaymentDate as LastPaymentDate,
		MAX(ISNULL(VS.LiabilityBalance - VS.AssignedLiabilityBalance,0)) AS patientLiability,    
		--MAX(DATEDIFF(DAY, ARBatch.GLDate, GETUTCDATE())) AS age,  
		MAX(VSA.Age) AS age, 
		MAX(ISNULL(VS.LiabilityBalance - VS.AssignedLiabilityBalance,0)) AS balanceDue,    
		--0.00 as Unallocated,
		UL.Unallocated as Unallocated,		
		ISNULL(AR_LedgerDetail.ClaimingProviderUid,AR_LedgerDetail.RenderingProviderUid) as ClaimingProviderUid, 
		AR_LedgerDetail.RenderingProviderUid AS RenderingProviderUid,
		SUBSTRING(Person.LastName,1,1) as LastNameFChar,
		--DATEDIFF(DAY, ARBatch.GLDate, GETDATE()) as GAge,
		AR_LedgerDetail.FinancialCenterUid,
		VS.LiabilityBalance,
		VS.AssignedLiabilityBalance,
		ISNULL(AR_LedgerDetail.ServiceSiteUid,NULL) AS ServiceSiteUid,
		ListPatientStatus.PatientStatusUid AS PatientStatusUid,
	    ListPatientStatus.Name AS PatientStatus,
	    MIN(CAST(ARBatch.IsClosed AS INT)) AS IsBatchClosed
	FROM Account with (nolock) 
		--INNER JOIN AR_ViewAccountAggregate VA with (nolock) ON Account.AccountUid=VA.AccountUid
		INNER JOIN Person with (nolock) ON Account.PersonUid = Person.PersonUid
		INNER JOIN Patient with (nolock) ON Patient.PersonUid = Person.PersonUid
		INNER JOIN AccountResponsibleParty with (nolock) ON Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid
		LEFT JOIN Person AS p2 with (nolock) ON AccountResponsibleParty.PersonUid = p2.PersonUid
		LEFT JOIN Corporation with (nolock) ON AccountResponsibleParty.CorporationUid = Corporation.CorporationUid  
		INNER JOIN Superbill with (nolock) ON Account.AccountUid = Superbill.AccountUid 
		INNER JOIN SuperbillProcedure with (nolock) ON Superbill.SuperbillUid = SuperbillProcedure.SuperbillUid 
		INNER JOIN AR_LedgerDetail with (nolock) ON SuperbillProcedure.SuperbillProcedureUid = AR_LedgerDetail.SuperbillProcedureUid and AR_LedgerDetail.LiabilityOwner = 0
		INNER JOIN AR_Ledger with (nolock) ON AR_Ledger.LedgerUid=AR_LedgerDetail.LedgerUid  AND (AR_Ledger.EntryType =1 OR AR_Ledger.EntryType =4) --AND AR_LedgerDetail.IsCredit = 0
		INNER JOIN AR_ViewSuperbillProcedureAggregate VS with (nolock) ON AR_LedgerDetail.SuperbillProcedureUid = VS.SuperbillProcedureUid 
		INNER JOIN ARBatch with (nolock) ON AR_Ledger.ArBatchUid = ARBatch.ARBatchUid 
		LEFT JOIN MDOL_RPT2_View_PatientAging_LastPaymentDate LPymnt with (nolock) on LPymnt.AccountUid=Account.AccountUid 
		LEFT JOIN MDOL_RPT2_View_PatientAging_Unallocated UL with (nolock) on UL.SuperbillProcedureUid=AR_LedgerDetail.SuperbillProcedureUid AND AR_LedgerDetail.LiabilityOwner = 0
		LEFT JOIN RelPatientStatus WITH (NOLOCK) ON RelPatientStatus.PatientUid = Patient.PersonUid 
		LEFT JOIN ListPatientStatus WITH (NOLOCK) ON ListPatientStatus.PatientStatusUid = RelPatientStatus.PatientStatusUid 
		JOIN [AR_ViewSuperbillProcedureAge] VSA WITH (NOLOCK) ON dbo.AR_LedgerDetail.SuperbillProcedureUid = VSA.SuperbillProcedureUid AND dbo.AR_LedgerDetail.LiabilityOwner = VSA.LiabilityOwner  
		GROUP BY  
		Account.PersonUid,
		AccountResponsibleParty.CorporationUid,  
		Corporation.Name,  
		Superbill.SuperbillUid,  
		SuperBill.ExternalID,  
		AccountResponsibleParty.PersonUid,  
		p2.FirstName,
		p2.LastName,
		p2.MiddleName,
		p2.Suffix,
		Account.AccountResponsiblePartyUid ,  
		Account.AccountUid,  
		Superbill.ServiceDateStart,  
		Account.LastStatementDate,  
		--Charge.ChargeUid,
		AR_LedgerDetail.ClaimingProviderUid, 
		AR_LedgerDetail.RenderingProviderUid,
		AR_LedgerDetail.LiabilityOwner,
		AR_LedgerDetail.SuperbillProcedureUid,
		Person.LastName,
		--GLDate,
		AR_LedgerDetail.FinancialCenterUid,
		VS.LiabilityBalance,
		VS.AssignedLiabilityBalance,
		LPymnt.LastPaymentDate,
		Ul.Unallocated,
		AR_LedgerDetail.ServiceSiteUid,
		ListPatientStatus.PatientStatusUid,
		ListPatientStatus.Name		
		--HAVING  
		----SUM(vaca.BalanceAll) <> 0
		--SUM(VS.LiabilityBalance -  VS.AssignedLiabilityBalance)<>0  




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientCareManagementReviewDetails]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewPatientCareManagementReviewDetails] AS
SELECT pcmlog.PatientCareManagementLogUid, pcmlog.PatientUid, pat.FormattedPreferredName AS PatientName,  
  pcmlog.ProviderUid, prov.FormattedPreferredName AS ProviderName,
  CASE WHEN pcmlog.IsCCM = 1 and ISNULL(pcmlog.IsApproved,0) = 1 THEN pcmlog.LogMinutes ELSE 0 END AS CCMApprovedMinutes,
	CASE WHEN pcmlog.IsCCM = 1 and ISNULL(pcmlog.IsApproved,0) = 0 THEN pcmlog.LogMinutes ELSE 0 END AS CCMUnapprovedMinutes,
  CASE WHEN pcmlog.IsCPO = 1 and ISNULL(pcmlog.IsApproved,0) = 1 THEN pcmlog.LogMinutes ELSE 0 END AS CPOApprovedMinutes,
	CASE WHEN pcmlog.IsCPO = 1 and ISNULL(pcmlog.IsApproved,0) = 0 THEN pcmlog.LogMinutes ELSE 0 END AS CPOUnapprovedMinutes,
  [dbo].[DateAsYYYYMMInt](pcmlog.LogDate) AS LogMonth,pcmlog.MedicalDecisionComplexityHighOrMedium AS MedicalDecisionComplexityHighOrMedium
FROM PatientCareManagementLog  pcmlog with (NOLOCK) 
		INNER JOIN PatientCareManagement pcm with (NOLOCK) 
			ON pcmlog.PatientUid = pcm.PatientUid 
				AND (pcm.EffectiveDate  IS NULL OR pcm.EffectiveDate  <= pcmlog.LogDate)
				AND (pcm.ExpirationDate IS NULL OR pcm.ExpirationDate >= pcmlog.LogDate) 
				and ((pcm.CareTypeUid=''14E95BCD-A9BC-41E4-9743-ECDBAD35FB6A'' and pcmlog.IsCCM = 1 )
				or (pcm.CareTypeUid=''928A4F18-FF1F-4BBA-90D9-66AEE2233C9A'' and pcmlog.IsCPO = 1))
		INNER JOIN ViewPerson pat with (NOLOCK) ON pcmlog.PatientUid = pat.PersonUid
		INNER JOIN ViewPerson prov with (NOLOCK) ON pcmlog.ProviderUid = prov.PersonUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewObservationItem]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewObservationItem] AS
	SELECT	oi.ObservationItemUid, oi.ExternalID, oi.Name, oi.ControlTypeUid,
			rocu.DisplayOrder, 
			isnull(rocu.LabelText, oi.name) as LabelText, 
			rocu.ObservationCustomUserUid, rocu.DisplayOrder as [OriginalDisplayOrder]
	FROM	ListObservationItem oi LEFT JOIN RelObservationCustomUser rocu ON oi.ObservationItemUid = rocu.ObservationItemUid

			

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewVisitObservationItem]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewVisitObservationItem] AS
SELECT ov.ObservationItemUid, ov.ObservationValueUid, ov.ObservationOrderUid, oi.ControlTypeUid, ov.VisitUid, oi.Name, ov.ObservationValue, ov.MetricValue1, ov.MetricValue2, 
		CASE 
			WHEN charindex(''Temperature'', oi.Name)>0 THEN ov.MetricValue1*1.8+32.0
			WHEN charindex(''Height'', oi.Name)>0 THEN ov.MetricValue1*0.393701 
			WHEN charindex(''Weight'', oi.Name)>0 THEN ov.MetricValue1*2.20462
			ELSE 0 
		END AS AmericanValue1,
		CASE 
			WHEN charindex(''Temperature'', oi.Name)>0 THEN ''Temperature''
			WHEN charindex(''Height'', oi.Name)>0 THEN ''Height''
			WHEN charindex(''Weight'', oi.Name)>0 THEN ''Weight''
			WHEN charindex(''Respiratory Rate'', oi.Name)>0 THEN ''RespiratoryRate''
			WHEN charindex(''Heart Rate'', oi.Name)>0 THEN ''HeartRate''
			WHEN charindex(''Blood Pressure'', oi.Name)>0 THEN ''BloodPressure''
			ELSE oi.Name
		END AS UnitType
from ObservationValue ov
JOIN ViewObservationItem oi on oi.ObservationItemUid = ov.ObservationItemUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewProviderEPCS]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewProviderEPCS]
AS
SELECT        dbo.ProviderEPCS.ProviderUid, dbo.ProviderEPCS.AuthenticationUserName, dbo.ProviderEPCS.DEA, dbo.ViewPerson.FullName, dbo.ProviderEPCS.Inactive, dbo.ProviderEPCS.LastName, 
                         dbo.ProviderEPCS.FirstName, dbo.Provider.ExternalID
FROM            dbo.ProviderEPCS INNER JOIN
                         dbo.ViewPerson ON dbo.ProviderEPCS.ProviderUid = dbo.ViewPerson.PersonUid INNER JOIN
                         dbo.Provider ON dbo.ProviderEPCS.ProviderUid = dbo.Provider.PersonUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_BatchDepositReview]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[MDOL_RPT2_VIEW_BatchDepositReview]  
AS  
SELECT   
 AB.ARBatchUID AS ARBatchUID,  
 AB.OwnerUID AS OwnerUID,  
 AB.Name AS Batch,  
 (CASE WHEN AB.IsLocked = 1 THEN ''Complete''  
    WHEN AB.IsClosed = 1 THEN ''Closed''  
 ELSE ''Open'' END) AS Status,  
 AB.GLDate AS PostDate,  
 D.DepositUID,  
 D.DepositDate AS DepositDate,  
 ISNULL(D.AmountInverse,0) AS Amount,  
 ISNULL(D.UnallocatedAmountInverse,0) AS NotAllocated,  
 D.WhoPaidName as PayerName,
 D.ReferenceNumber AS Reference#,  
 D.Comment AS Comment,  
 (CASE WHEN D.Void = 1 THEN ''Y'' ELSE ''N'' END) AS Void,  
 [dbo].[UDF_getFormattedPreferredNameFromValues](P1.FirstName,P1.LastName,P1.MiddleName,P1.Suffix) AS Owner,  
 CASE WHEN AB.IsClosed =1 THEN 1 ELSE 0 END AS IsBatchClosed  
FROM   
 ARBatch AB WITH (NOLOCK)  
LEFT JOIN   
 ViewDeposit D WITH (NOLOCK)  
ON  
 AB.ARBatchUID = D.ARBatchUID 
LEFT JOIN  
 Person P1 WITH (NOLOCK)  
ON  
 AB.OwnerUID = P1.PersonUID  







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewPatientBP]'))
EXEC dbo.sp_executesql @statement = N'
--20160217  kculberth change NOLOCKs to WITH NOLOCKs

CREATE VIEW [dbo].[MDOL_RPT2_ViewPatientBP]
AS
SELECT OO.PatientUid
	,COALESCE(OO.PerformDateTime, dbo.UDF_utcToCurrentDate(V.VisitDate), OO.PerformDateTime, OO.PerformDate) AS MeasureDate
	,Metricvalue1
	,Metricvalue2
FROM ObservationValue OV WITH (NOLOCK)
INNER JOIN ObservationOrder OO WITH (NOLOCK) ON OV.ObservationOrderUid = OO.ObservationOrderUid
	AND OO.IsDelete = 0
LEFT JOIN Visit V WITH (NOLOCK) ON V.VisitUid = OV.VisitUid
WHERE (
		ObservationItemuid = ''00000000-0000-0000-7777-100000000073''
		OR ObservationItemuid = ''00000000-0000-0000-7777-100000000074''
		)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewPatientInfo]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[MDOL_RPT2_ViewPatientInfo]
AS
Select 
	PersonUid,
	A.MeasureDate,
	A. SystolicBP,
	A.DiastolicBP 
From
	 Patient WITH (NOLOCK)
Left Join
	 (Select
		PatientUid,
		MAX(MeasureDate) AS MeasureDate,
		[dbo].[getPatientBp](PatientUid,''S'') SystolicBP,
		[dbo].[getPatientBp](PatientUid,''D'') DiastolicBP 
	 From
	 [MDOL_RPT2_ViewPatientBP] WITH (NOLOCK)
	 Group By
	   PatientUid) A
  ON
   Patient.PersonUid = A.PatientUid 
 
 


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbill]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbill] as
SELECT s.SuperbillUid, s.ExternalID, s.PatientUid,
              sa.RenderingProviderUid, sa.ClaimingProviderUid, s.SuperbillStatusUid,
              s.ServiceDateStart, s.ServiceDateEnd, VSA.LiabilityBalance, 
              VSA.Liability AS TotalCharge, sa.FirstFiledDate, sa.LastFiledDate,
              sa.ServiceSiteUid,   
              p.FullName as PatientName,   
              renderer.FormattedInternalName as RenderingProviderName,
              claimer.FormattedInternalName as ClaimingProviderName,
			  referer.FormattedInternalName as ReferingProviderName, -- for UI column name only
              sts.Name AS SuperbillStatusName, 
              ste.Name AS ServiceSiteName,
              s.AccountUid, s.VisitUid, v.VisitDate, v.IsCompleted AS VisitIsCompleted, 
              s.ClaimPaper, s.LastModifiedByUid, sa.IsPosted, sa.FinancialCenterUid,
              fc.Name AS FinancialCenterName, 
              sa.CurrentCarrier as InsuranceOrder, -- was sts.InsuranceOrder which is now obsolete
              ISNULL(ILN.InsuranceLevelName,'''') AS InsuranceLevelName,
              CASE WHEN sa.CodeValidationErrors = 1 THEN ''Errors'' ELSE '''' END AS CodeValidationErrors,
              (SELECT MAX(ArbatchPostingDate) FROM AR_ViewSuperbillProcedureBatchSub (NOEXPAND) WHERE SuperbillUid = s.SuperbillUid) AS MaxPostingDate,
              (SELECT MIN(ArbatchPostingDate) FROM AR_ViewSuperbillProcedureBatchSub (NOEXPAND) WHERE SuperbillUid = s.SuperbillUid) AS MinPostingDate,
			  s.ABN, s.ARBatchUid,-- Igor note: temporary added to fix application error (bug 7146)1/12/2011
			  s.Notes,
			  S.appointmentUid,
			  (SELECT COUNT(SuperbillProcedureUid) FROM SuperbillProcedure WITH (NOLOCK) WHERE Inactive = 0 AND SuperbillUid = s.SuperbillUid) AS SuperbillProcedureCount
FROM   Superbill(NOLOCK) s 
              INNER JOIN SuperbillAggregate(NOLOCK) sa ON s.SuperbillUid = sa.SuperbillUid
              INNER JOIN ViewPerson (NOEXPAND) p on p.PersonUid = s.PatientUid 
              LEFT JOIN ViewPerson (NOEXPAND) renderer on renderer.PersonUid = sa.RenderingProviderUid    
              LEFT JOIN ViewPerson (NOEXPAND) claimer on claimer.PersonUid = sa.ClaimingProviderUid    
			  LEFT JOIN ViewPerson (NOEXPAND) referer on referer.PersonUid = s.ReferringProviderUid -- for UI column name only
              INNER JOIN ListSuperbillStatus(NOLOCK) sts on s.SuperbillStatusUid = sts.SuperbillStatusUid
              LEFT JOIN ListServiceSite(NOLOCK) ste on sa.ServiceSiteUid = ste.ServiceSiteUid
              LEFT JOIN FinancialCenter(NOLOCK) fc on sa.FinancialCenterUid = fc.FinancialCenterUid
              LEFT JOIN Visit(NOLOCK) v on s.VisitUid = v.VisitUid
              LEFT JOIN AR_ViewSuperbillAggregate VSA ON s.SuperbillUid = VSA.SuperbillUid 
              LEFT JOIN ListInsuranceLevelName(NOLOCK) ILN ON sa.CurrentCarrier = ILN.InsuranceLevel











' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VieweRxEligibilityOutbound]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[VieweRxEligibilityOutbound]
AS
SELECT TOP 100 PERCENT
	ob.eRxEligibilityOutboundUid,
	ob.RequestDate, 
	vp_Patient.FullName AS Patient, 
	vp_Provider.FullName AS Provider, 
	ob.Successful, 
	ob.LastModifiedDate AS eRxSentDateTime,
	COALESCE (ob.SendResponse, es.Name, '''') AS SendResponse, 
    COALESCE(lpc.Name, ''None'') as ClearingHouse,
	ob.PatientUid, 
	ob.ProviderUid, 
	lmt.Name eRxMessageType,
	CASE WHEN ob.eRxEligibilityOutboundUid IS NOT NULL 
		THEN REPLACE (ob.eRxEligibilityOutboundUid, ''-'', '''')
		ELSE NULL
	END AS eRxMessageID,
	ob.OrderNumber,
	ob.OrderDateTime,
	lmt.eRxMessageTypeUid,
	ob.Processed
FROM eRxEligibilityOutbound AS ob
	INNER JOIN dbo.Provider AS p ON ob.ProviderUid = p.PersonUid
	INNER JOIN dbo.Patient AS pp ON ob.PatientUid = pp.PersonUid
	INNER JOIN dbo.ViewPerson AS vp_Patient ON pp.PersonUid = vp_Patient.PersonUid
	LEFT OUTER JOIN dbo.ViewPerson AS vp_Provider ON p.PersonUid = vp_Provider.PersonUid
	LEFT OUTER JOIN dbo.ListeRxStatus AS es ON ob.eRxStatusUid = es.eRxStatusUid
	LEFT OUTER JOIN dbo.ListPharmacyClearinghouse as lpc ON ob.PharmacyClearinghouseUid = lpc.PharmacyClearinghouseUid
	LEFT OUTER JOIN dbo.ListeRxMessageType AS lmt ON ob.eRxMessageTypeUid = lmt.eRxMessageTypeUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPayerWithoutClaimFormat]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbillPayerWithoutClaimFormat]    
AS
-- NOTE: OTHER VIEWS MAY DEPEND ON THIS ONE. Use sp_f ViewSuperbillPayerWithoutClaimFormat (or other means) to identify and update them.
-- NOTE: ViewSuperbillPayer uses this view. In most cases you''ll want to use ViewSuperbillPayer and NOT ViewSuperbillPayerWithoutClaimFormat.
SELECT    
	s.ExternalID,
	s.SuperbillUid,
	s.PatientUid,
	s.RenderingProviderUid,
	s.ClaimingProviderUid,
	s.SuperbillStatusUid,
	s.ServiceDateStart,
	s.ServiceDateEnd,
	s.FirstFiledDate,
	s.LastFiledDate,
	s.ServiceSiteUid,
	s.PatientName,
	s.RenderingProviderName,
	s.ClaimingProviderName,
	s.SuperbillStatusName,
	s.ServiceSiteName,
	s.AccountUid,
	s.VisitUid,
	s.VisitDate,
	s.ClaimPaper,
	s.LastModifiedByUid,
	s.TotalCharge,
	s.IsPosted,
	s.FinancialCenterUid,
	--s.InsuranceCarrierUid,
	--s.PayerName,
	a.Name as AccountName,    
	coalesce(ai.DisplayOrder, 0) as InsuranceOrder,    
    s.InsuranceOrder as CurrentCarrier, -- see in underlying query ViewSuperbill ... no need to rejoin
    ISNULL(ILN.InsuranceLevelName,'''') as InsuranceLevelName,
	pip.PersonUid as InsuredPersonUid,    
	pip.CorporationUid as InsuredCorporationUid,    
	coalesce((case when pip.PersonUid is not null then dbo.UDF_getFormattedName(insp.Prefix, insp.FirstName, insp.MiddleName , insp.LastName, insp.Suffix) else insc.Name end), '''') as InsuredName,    
	CAST(coalesce(pip.AuthorizeAssignment, 0) as bit) as AuthorizeAssignment,    
	coalesce(pip.PlanMemberID, '''') as PlanMemberID,    
	coalesce(pip.PlanGroupID, '''') as PlanGroupID,    
	ip.InsuranceCarrierUid,  -- Someone added this to ViewSuperbill so I removed it here.
	ip.InsurancePlanUid,    
	coalesce(ip.Name, '''') as InsurancePlanName,    
	coalesce(icc.Name, '''') as PayerName,    
	ip.IsCapitated AS Capitated,    

	(SELECT COUNT(*)    
	FROM eReportRows err     
	WHERE err.SuperbillUid = s.SuperbillUid    
	AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
	AND err.ErrorFlag = ''E'')    
	AS Errors,    
	(SELECT COUNT(*)    
	FROM eReportRows err    
	WHERE err.SuperbillUid = s.SuperbillUid    
	AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
	AND err.ErrorFlag = ''W'')    
	AS Warnings,    
	dbo.UDF_AR_getClaimFormatUid(s.ClaimPaper, ip.UseCarrierElectronicClaimFormat, ip.UseCarrierPaperClaimFormat,     
								 ip.ElectronicClaimFormatUid, ic.ElectronicClaimFormatUid, 
								 ip.PaperClaimFormatUid, ic.PaperClaimFormatUid,
								 ip.UseCarrierPaperClaimDefaultOption, ip.PaperClaimDefaultOptionUid, 
								 ic.PaperClaimDefaultOptionUid, s.InsuranceOrder ) as ClaimFormatUid,     

	lep.ClaimClearingHouseUid as ClaimClearingHouseUid,     
	lcch.Name as ClaimClearingHouse,    
    pipp.InsurancePlanUid as PrimaryInsurancePlanUid, 
    Case when ip.UseInsuranceCarrierAccountType=1 then ic.AccountTypeUid else ip.AccountTypeUid end as AccountTypeUid, 
     s.ARBatchUid,-- Igor note: temporary added to fix application error (bug 7146)1/12/2011
	 s.Notes
from ViewSuperbill s    
 inner join Account(NOLOCK) a on     
  a.AccountUid = s.AccountUid    
 left join AccountPeriod(NOLOCK) ap on    
  a.AccountUid = ap.AccountUid    
  and (ap.EffectiveDate is null or ap.EffectiveDate <= s.ServiceDateEnd)    
  and (ap.ExpirationDate is null or DateAdd(dd, 1, ap.ExpirationDate) > s.ServiceDateEnd)    
 left join AccountInsurance(NOLOCK) ai on    
  ai.AccountPeriodUid = ap.AccountPeriodUid    
 left join PersonInsurancePlan(NOLOCK) pip on    
  pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid    
 left join Person(NOLOCK) insp on    
  insp.PersonUid = pip.PersonUid    
 left join Corporation(NOLOCK) insc on    
  insc.CorporationUid = pip.CorporationUid    
 left join InsurancePlan(NOLOCK) ip on    
  ip.InsurancePlanUid = pip.InsurancePlanUid    
 left join InsuranceCarrier(NOLOCK) ic on    
  ic.CorporationUid = ip.InsuranceCarrierUid    
 left join Corporation(NOLOCK) icc on    
  icc.CorporationUid = ic.CorporationUid    
 left join ListElectronicPayer(NOLOCK) lep on    
  lep.ElectronicPayerUid = ic.ElectronicPayerUid    
 left join ListClaimClearingHouse(NOLOCK) lcch on    
  lcch.ClaimClearingHouseUid = lep.ClaimClearingHouseUid
 LEFT JOIN AccountInsurance(NOLOCK) aip ON ap.AccountPeriodUid = aip.AccountPeriodUid AND aip.DisplayOrder = 1
 LEFT JOIN PersonInsurancePlan(NOLOCK) pipp ON aip.PersonInsurancePlanUid = pipp.PersonInsurancePlanUid
 left join ListInsuranceLevelName(NOLOCK) ILN ON s.InsuranceOrder = ILN.InsuranceLevel -- see in underlying query ViewSuperbill ... no need to rejoin


--EXEC sys.sp_addextendedproperty @name=N''GenerateEntityObject'', @value=N''false'' , @level0type=N''SCHEMA'',@level0name=N''dbo'', @level1type=N''VIEW'',@level1name=N''ViewSuperbillPayerWithoutClaimFormat''


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementLineItemByFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'

--20150109 - kculberth - add statement notes from reason codes - bug 33625
--20150413 - kculberth - add more NOLOCKs to prevent locking of tables
--20150512 - kculberth - add one more NOLOCK on DEPOSIT in the cte to prevent locking of tables
--20161020 - kculberth - fix problem with last filed to being incorrect
--02/02/2017 - kculberth - Bug 51825:Statements-CHC Payer Setting Encounter codes need to print on statement if there is a patient liability for this code.

CREATE VIEW [dbo].[ViewStatementLineItemByFinancialCenter]
AS 
--NEW
WITH cteWhoPaidName --Stolen from ViewDeposit
AS
-- Define the CTE query.
(
SELECT d.deposituid,
      ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumber, -- mark as <ND> so can hyperlink on null values
      (CASE WHEN p.PersonUid IS NOT NULL THEN p1.FormattedPreferredName
       WHEN icArp.CorporationUid IS NOT NULL THEN icArp.Name
       WHEN LD.InsurancePayerUid IS NOT NULL THEN ic.Name END) AS WhoPaidName,
       L.EntryType  
FROM Deposit (NOLOCK) d
            INNER JOIN AR_LedgerDetail (NOLOCK) LD ON d.DepositUid = LD.DepositUid
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid
            LEFT OUTER JOIN AR_Ledger (NOLOCK) arlVoid on L.LedgerUid = arlVoid.VoidLedgerUid      -- Checks for voiding entries                                       
            LEFT JOIN AccountResponsibleParty (NOLOCK) arp on LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid            
            LEFT JOIN Person (NOLOCK) p ON arp.PersonUid = p.PersonUid 
            LEFT JOIN Corporation (NOLOCK) icArp ON arp.CorporationUid = icArp.CorporationUid
            LEFT JOIN Corporation (NOLOCK) ic ON ic.CorporationUid = LD.InsurancePayerUid 
            LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = p.PersonUid              
WHERE (L.EntryType = 0 -- Payment
	   OR L.EntryType = 3) -- Adjustment
       AND  (L.VoidLedgerUid IS NULL AND arlVoid.LedgerUid IS NULL) -- Don''t include reversing(void) entries
       AND LD.IsCredit = 1                                              
       AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits    
),

cteLastFiledDate --
AS
-- Define the CTE query.
(
	SELECT SA.SuperbillUid,SA.LastFiledDate,SA.CurrentInsurancePlanUid
	FROM SuperbillAggregate (NOLOCK) SA
)
SELECT
	FinancialCenterUid,  
	ItemUid,   
	RPUid,     
	''Header'' AS Type, 
	2 AS DisplayOrder, 
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	NULL AS ItemDate,   
	NULL AS CreditGroupUid,   
	0 AS IsPayment,   
	NULL AS CreditUid,   
	0 AS CreditSubOrder,   
	'''' AS WhoPaid,
	PatientName + '' / '' +  RenderingProviderName + Coalesce(ISNULL(ReferringProviderName,NULL), ReferringProviderName,'''') AS Description, 
	CONVERT(Money, 0) Charge, 
	CONVERT(Money, 0) Insurance, 
	CONVERT(Money, 0) Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM  
(
	SELECT   
		LD.FinancialCenterUid,  
		S.SuperbillUid AS ItemUid,   
		A.AccountResponsiblePartyUid AS RPUid,     
		p1.FormattedPreferredName AS PatientName,  
		p2.FormattedPreferredName AS RenderingProviderName, 
		A.ExternalID AS AccountID,   
		S.ExternalID AS SuperbillID,   
		S.SuperbillUid,   
		S.ServiceDateStart AS SuperbillDate,   
		(CASE WHEN (FC.IncludeReferringProvider = 1) THEN ('' / '' + p3.FormattedPreferredName)
			ELSE NULL END) AS ReferringProviderName, 
		--VSC.CompleteBatch AS IsSuperBilCompleteBatch,  
		(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch      
	FROM   
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger(NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		INNER JOIN FinancialCenter (NOLOCK) FC ON LD.FinancialCenterUid = FC.FinancialCenterUid 		
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid 
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid			  
		LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
	WHERE 
		rpsss.superbillstatusuid is null AND 
		(L.EntryType = 1 OR L.EntryType = 4) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null)
		AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
) A
GROUP BY   
	FinancialCenterUid,  
	ItemUid,   
	RPUid,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	ReferringProviderName
	  
UNION ALL

SELECT   
	FinancialCenterUid,  
	ItemUid,   
	RPUid,   
	''Charge'' AS Type,   
	4 AS DisplayOrder,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	ItemDate,   
	NULL AS CreditGroupUid,   
	0 AS IsPayment,   
	NULL AS CreditUid,   
	0 AS CreditSubOrder,   
	'''' AS WhoPaid,   
	Description,   
	Charge,   
	Sum(Insurance) AS Insurance,  
	Sum(Patient) AS Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM  
(  
	SELECT   
		LD.FinancialCenterUid,  
		LD.SuperbillProcedureUid AS ItemUid,   
		A.AccountResponsiblePartyUid AS RPUid,   
		p1.formattedPreferredName AS PatientName,
		p2.formattedPreferredName AS RenderingProviderName,
		A.ExternalID AS AccountID,   
		S.ExternalID AS SuperbillID,   
		S.SuperbillUid,   
		S.ServiceDateStart AS SuperbillDate,   
		SP.ProcedureServiceDateStart AS ItemDate,   
		(CASE WHEN FC.IncludeProcedureCode= 1   
			THEN ISNULL(LP.Code, '''') + ISNULL('' '' + LP.ShortDescription, '''')  
			ELSE ISNULL('' '' + LP.ShortDescription, '''') END) AS Description,   
		COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS Charge,   
		(CASE WHEN LD.LiabilityOwner > 0   THEN LD.Amount ELSE Convert(Money, 0) END) AS Insurance, 
		(CASE WHEN LD.LiabilityOwner = 0 THEN LD.Amount ELSE Convert(Money, 0) END) AS Patient,  
		(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch   
	FROM  
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		INNER JOIN ListProcedure (NOLOCK) LP ON SP.ProcedureUid = LP.ProcedureUid  
		INNER JOIN FinancialCenter (NOLOCK) FC ON LD.FinancialCenterUid = FC.FinancialCenterUid 			
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid		   
		LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
	WHERE 
		rpsss.superbillstatusuid is null AND
		(L.EntryType = 1 OR L.EntryType = 4) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null)
		AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
) B  
GROUP BY   
	FinancialCenterUid,  
	ItemUid,   
	RPUid,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	ItemDate,   
	Description,   
	Charge

UNION ALL

SELECT   
	FinancialCenterUid,  
	ItemUid,  
	RPUid,   
	Type,   
	Case When Type=''Payment'' Then 5 ELSE 6 END as DisplayOrder,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	MIN(ItemDate) as ItemDate,   
	CreditGroupUid,  
	IsPayment,   
	CreditUid,   
	2 as CreditSubOrder,   
	WhoPaid,   
	Description,  
	CONVERT(Money, 0) as Charge,   
	SUM(Insurance) as Insurance,   
	SUM(Patient) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM  
(  
	SELECT   
		LD.FinancialCenterUid,  
		(Case When LCT.Name = ''Patient Payment'' Then D.DepositUid ELSE LD.FinancialCenterUid END) AS ItemUid, 
		A.AccountResponsiblePartyUid as RPUid,   
		(Case When L.EntryType  = 2 Then ''Payment'' Else ''Adjustment'' END) as Type,   
		p1.FormattedPreferredName as PatientName,
		p2.FormattedPreferredName as RenderingProviderName,
		A.ExternalID as AccountID,   
		S.ExternalID as SuperbillID,   
		S.SuperbillUid,   
		S.ServiceDateStart as SuperbillDate,   
		ARB.GLDate as ItemDate,   
		LD.FinancialCenterUid  CreditGroupUid,  
		(Case When L.EntryType = 2 Then 1 Else 0 END) IsPayment,   
		LD.FinancialCenterUid CreditUid,   
            LDOS.AccountResponsiblePartyUid as WhoPaidPersonUid,
            LDOS.InsurancePayerUid as WhoPaidInsuranceCarrierUid,
            WhoPaid.WhoPaidName AS WhoPaid, 
            WhoPaid.ReferenceNumber AS ReferenceNumber,
            (CASE WHEN L.EntryType != 2
				  THEN ISNULL(LCT.Name,'''')
				  ELSE
				     (CASE WHEN FC.IncludePaymentReferenceNumber = 1 
					  THEN 
                         ISNULL(LCT.Name,'''') + '' Ref #'' + ISNULL(WhoPaid.ReferenceNumber,''N/A'') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
                      ELSE ISNULL(LCT.Name,'''') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
                      END)
              END) as Description,
		(Case When LD.LiabilityOwner > 0 Then (LD.Amount) Else Convert(Money, 0) END) as Insurance,   
		(Case When LD.LiabilityOwner = 0 Then (LD.Amount) Else Convert(Money, 0) END) as Patient,  
		p3.FormattedPreferredName as ReferringProviderName,
		(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch
	FROM  
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger(NOLOCK)  L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid     		
		LEFT JOIN AR_Transaction (NOLOCK) T ON L.TransactionUid = T.TransactionUid 
		LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = T.DepositUid            
		LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
		INNER JOIN FinancialCenter (NOLOCK) FC ON LD.FinancialCenterUid = FC.FinancialCenterUid 			
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid   
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	
		LEFT JOIN cteWhoPaidName AS whoPaid ON d.depositUid = WhoPaid.deposituid --and d.referencenumber = WhoPaid.referencenumber
		LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
	WHERE 
		rpsss.superbillstatusuid is null AND
		(L.EntryType=2 OR L.EntryType=3) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 1 
		AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
	) B 	
GROUP BY  
	FinancialCenterUid,  
	ItemUid,  
	RPUid,   
	Type,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,  
	CreditGroupUid,   
	IsPayment,   
	CreditUid,   
	WhoPaid,   
	Description,  
    ReferringProviderName,
    ReferenceNumber

UNION ALL

SELECT   
	LD.FinancialCenterUid,  
	NewID() as ItemUid,
	A.AccountResponsiblePartyUid as RPUid,   
	''Comment'' as Type,   
	6 as DisplayOrder,   
	p1.FormattedPreferredName as PatientName,
	p2.FormattedPreferredName as RenderingProviderName,
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	max(CB.ClaimDate) as ItemDate,   
	NULL as CreditGroupUid,   
	0 as IsPayment,   
	NULL as CreditUid,   
	0 as CreditSubOrder,   
	'''' as WhoPaid,   
	(ISNULL(dbo.ARFN_getInsLevelName(CB.InsuranceOrder), '''') + '' claim filed to '' + ISNULL(C.Name,'''') + 
	(CASE WHEN (FC.IncludelastFileDate = 1) THEN ('' on '' + (CONVERT(VARCHAR, ISNULL(lfd.LastFiledDate,GETDATE()), 101)))
			ELSE '''' END)) 
			AS Description,   
	CONVERT(Money, 0) as Charge,   
	CONVERT(Money, 0) as Insurance,   
	CONVERT(Money, 0) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	lfd.LastFiledDate AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	C.Name AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM 
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		LEFT JOIN InsurancePlan (NOLOCK) IP ON IP.InsurancePlanUid=LD.InsurancePlanUid  
		LEFT JOIN Corporation (NOLOCK) C ON IP.InsuranceCarrierUid = C.CorporationUid							 
		LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid		
		LEFT JOIN FinancialCenter (NOLOCK) FC on FC.FinancialCenterUid = LD.FinancialCenterUid					 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = s.ReferringProviderUid
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid			   
		LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
WHERE 
	rpsss.superbillstatusuid is null AND
	(L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 0  AND (L.EntryType = 1)
	and CB.InsuranceOrder is not null
	AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
GROUP BY   
 LD.FinancialCenterUid,  
 CB.InsuranceOrder,   
 A.AccountResponsiblePartyUid,   
 S.PatientUid,   
 LD.RenderingProviderUid,  
 A.ExternalID,  
 S.ExternalID,   
 S.SuperbillUid,   
 S.ServiceDateStart,   
 lfd.LastFiledDate,   
 S.ReferringProviderUid,  
 C.Name, 
 FC.IncludelastFileDate,
 P1.FormattedPreferredName,
 p2.FormattedPreferredName,
 p3.FormattedPreferredName

UNION ALL

--NEW Comment 2  
--Statement notes from credits. Associated with the payments AND adjustments, so use the same display ORder  
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
SELECT   
	LD.FinancialCenterUid,  
	LD.LedgerDetailUid as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Comment'' as Type,   
	(CASE WHEN L.EntryType = 2 THEN 5 
	WHEN L.EntryType = 3 THEN 6
	WHEN L.EntryType = 4 THEN 7
	ELSE 6 END) as DisplayOrder,   
	p1.FormattedPreferredName as PatientName, 
	p2.FormattedPreferredName as RenderingProviderName,
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	D.DepositDate as ItemDate,   
	LD.LedgerDetailUid AS CreditGroupUid,  
	(Case When L.EntryType = 2 Then 1 Else 0 END) IsPayment,   
	LD.LedgerDetailUid AS CreditUid,  
	4 as CreditSubOrder,   
	'''' as WhoPaid,   
	L.StatementNote as Description,   
	Convert(Money, 0) as Charge,   
	Convert(Money, 0) as Insurance,   
	Convert(Money, 0) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	 
	(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch,
	0 AS DisplayOrder2     
FROM 
	AR_LedgerDetail (NOLOCK) LD
	INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
	INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid     		
	LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = LDOS.DepositUid
	LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
	LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid   
	LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	
	LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
WHERE 
	rpsss.superbillstatusuid is null AND
	(L.StatementNote is NOT NULL OR L.StatementNote != '''')   
	AND (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
	AND (L.EntryType=2 OR L.EntryType=3 OR L.EntryType=4) AND LD.IsCredit = 1  
	AND (chc.patientliability <> 0 OR chc.patientliability IS NULL) 			
UNION ALL
--Remark notes from reason codes. Associated with procedures
SELECT DISTINCT  
	LD.FinancialCenterUid,  
	NULL as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Comment'' as Type,   
	6 as DisplayOrder,   
	p1.FormattedPreferredName as PatientName, 
	NULL as RenderingProviderName,
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	NULL as ItemDate,   
	NULL AS CreditGroupUid,  
	0 as IsPayment,   
	NULL AS CreditUid,  
	4 as CreditSubOrder,   
	'''' as WhoPaid,   
	adj.StatementNote as Description,   
	Convert(Money, 0) as Charge,   
	Convert(Money, 0) as Insurance,   
	Convert(Money, 0) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	 
	NULL CompleteBatch,
	0 AS DisplayOrder2      
FROM Superbill (NOLOCK) S 
	INNER JOIN SuperbillProcedure SP WITH (NOLOCK) ON SP.superbilluid = S.superbilluid
	INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SP.SuperbillProcedureUid = LD.SuperbillProcedureUid
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid   
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	left join cobclaimdetail (NOLOCK) cob on cob.superbilluid = s.superbilluid
	left join COBLineAdjustments (NOLOCK) adj on adj.cobclaimdetailuid = cob.cobclaimdetailuid and adj.superbillprocedureuid = sp.superbillprocedureuid and adj.Notes IS NOT NULL
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid 
	LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid		 
WHERE rpsss.superbillstatusuid is null and
	(adj.StatementNote is NOT NULL OR adj.StatementNote != '''')  
 	AND (chc.patientliability <> 0 OR chc.patientliability IS NULL) 				
--NEW Subtotal
UNION ALL
SELECT 
	LD.FinancialCenterUid,  
	S.SuperbillUid as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Subtotal'' as Type,   
	8 as DisplayOrder,   
	p1.FormattedPreferredName as PatientName,
	p2.FormattedPreferredName as RenderingProviderName, 
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	NULL as ItemDate,   
	NULL as CreditGroupUid,   
	0 as IsPayment,   
	NULL as CreditUid,   
	0 as CreditSubOrder,   
	'''' as WhoPaid,   
	''Balance Superbill '' + ISNULL(''#'' + S.ExternalID, Convert(Varchar, dbo.UDF_utcToCurrentDate(S.ServiceDateStart), 101)) as Description,   
	Sum(case when L.EntryType= 1 OR L.EntryType=4 then LD.Amount else 0 END) as Charge,   
	Sum(Case When LD.LiabilityOwner > 0 Then LD.Amount Else Convert(Money, 0) END) as Insurance,   
	Sum(Case When LD.LiabilityOwner = 0 Then LD.Amount Else Convert(Money, 0) END) as Patient, 
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	 
	1  CompleteBatch,
	0 AS DisplayOrder2  
FROM 
	AR_LedgerDetail (NOLOCK) LD
	INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid    
	INNER JOIN FinancialCenter (NOLOCK) FC ON LD.FinancialCenterUid = FC.FinancialCenterUid 				
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
	LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid 
	LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid		 
	--CROSS JOIN PracticeSettings (NOLOCK) PS  	  
	LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
WHERE 
	rpsss.superbillstatusuid is null AND
	 (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
 	AND (chc.patientliability <> 0 OR chc.patientliability IS NULL) 		    
GROUP BY   
	LD.FinancialCenterUid,  
	S.SuperbillUid,   
	A.AccountResponsiblePartyUid,   
	S.PatientUid,   
	LD.RenderingProviderUid,  
	S.ServiceDateStart,   
	A.ExternalID,  
	S.ExternalID,   
	S.ReferringProviderUid,  
	P1.FormattedPreferredName,
	p2.FormattedPreferredName,
	p3.FormattedPreferredName 		


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewERATransactionSet]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewERATransactionSet]
AS
SELECT	ts.ERATransactionSetUid, ts.ControlNumber, ts.TransactionHandlingCode, ts.TotalMonetaryAmount, 
		ts.CreditDebitFlagCode, ts.PaymentMethodCode, ts.CheckIssueDate, ts.TraceTypeCode, ts.ReferenceID, 
		ts.ProductionDate, ts.PayerName, ts.PayerID,  
        ts.RuleStatus, 
		(CASE ISNull(ts.RuleStatus, 0) WHEN 0 THEN ''Unprocessed'' 
									   WHEN 1 THEN ''Processed'' 
									   WHEN 2 THEN ''Processed'' -- All Processed
									   WHEN 3 THEN ''Hold''
									   WHEN 4 THEN ''Locked''
									   WHEN 5 THEN ''No Matched Claims''
									   WHEN 99 THEN ''Busy'' 
									   WHEN -1 THEN ''Error'' 
									   ELSE (''Unknown Status '' + Convert(varchar, ts.RuleStatus)) END) AS Status, 
        dbo.ERAGetTransactionError(ts.ERATransactionSetUid) AS ErrorText, 
        eic.RawMessage AS RawMessage, 
        ISNULL(ts.Archived,0) AS Archived
FROM	ERATransactionSet ts
		inner join ERAFunctionalGroup efg on efg.ERAFunctionalGroupUid = ts.ERAFunctionalGroupUid    
		inner join ERAInterchangeControl eic on eic.ERAInterchangeControlUid = efg.ERAInterchangeControlUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewEDIResponse]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewEDIResponse]
AS

SELECT 
	   vets.[ERATransactionSetUid] as ResponseUid
	  ,vets.[ERATransactionSetUid]
	  ,vets.[ControlNumber]
      ,vets.[TransactionHandlingCode]
      ,vets.[TotalMonetaryAmount]
      ,vets.[CreditDebitFlagCode]
      ,vets.[PaymentMethodCode]
      ,vets.[CheckIssueDate]
      ,vets.[TraceTypeCode]
      ,vets.[ReferenceID]
      ,vets.[ProductionDate]
      ,vets.[PayerName]
      ,vets.[PayerID]
      ,vets.[RuleStatus]
      ,vets.[Status]
      ,vets.[ErrorText]
      ,vets.[RawMessage]
      ,vets.[Archived] 
      ,''ERA'' as Type
	  ,null as FileName
	  ,ets.LastModifiedDate as CreateDateTime
	  ,etsd.DepositUid
	  FROM ViewERATransactionSet vets
	  inner join ERATransactionSet ets on ets.ERATransactionSetUid = vets.ERATransactionSetUid
	  left join ERATransactionSetDeposit etsd on ets.ERATransactionSetUid = etsd.ERATransactionSetUid
UNION ALL
SELECT  
	   [downloadedFileUid] as ResponseUid
	  , null as ERATransactionSetUid
	  , null as ControlNumber
      , null as TransactionHandlingCode
      , null as TotalMonetaryAmount
      , null as CreditDebitFlagCode
      , null as PaymentMethodCode
      , null as CheckIssueDate
      , null as TraceTypeCode
      , null as ReferenceID
      , null as ProductionDate
      , null as PayerName
      , null as PayerID
      , null as RuleStatus
      , ''Processed'' as Status
      , null as ErrorText
      , CONVERT(VARCHAR(max),CONVERT(VARBINARY(max),fileImage)) AS RawMessage 
      , ISNULL(Archived,0) AS Archived
      ,[Type]
	  ,[name] as FileName
	  ,[CreateDateTime]
	  ,null as DepositUid
FROM downloadedFiles


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPayer]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewSuperbillPayer]  
AS
SELECT  
	NEWID() AS ViewSuperbillPayerUid, -- no other unique to use as PK
	s.ExternalID,
	s.SuperbillUid,
	s.PatientUid,
	s.RenderingProviderUid,
	s.ClaimingProviderUid,
	s.SuperbillStatusUid,
	s.ServiceDateStart,
	s.ServiceDateEnd,
	s.FirstFiledDate, 
	s.LastFiledDate,
	s.ServiceSiteUid,
	s.PatientName,
	s.RenderingProviderName,
	s.ClaimingProviderName,
	s.SuperbillStatusName,
	s.ServiceSiteName,
	s.AccountUid,
	s.VisitUid,
	s.VisitDate,
	s.ClaimPaper,
	s.LastModifiedByUid,
	s.TotalCharge,
	s.IsPosted,
	s.FinancialCenterUid,
	s.AccountName,
	s.InsuranceOrder,
	s.InsuredPersonUid,
	s.InsuredCorporationUid,
	s.InsuredName,
	s.AuthorizeAssignment,
	s.PlanMemberID,
	s.PlanGroupID,
	s.InsuranceCarrierUid,
	s.InsurancePlanUid,
	s.InsurancePlanName,
	s.PayerName,
	s.Capitated,
	s.Errors,
	s.Warnings,
	s.ClaimFormatUid,
	s.ClaimClearingHouseUid,
	s.ClaimClearingHouse,
	lcf.Name as ClaimFormat,
	lcft.ClaimFormatTypeUid,   
	lcft.Name as ClaimFormatType,   
	lcft.IsPaper as ClaimFormatTypeIsPaper
from ViewSuperbillPayerWithoutClaimFormat s  
 left join ListClaimFormat(NOLOCK) lcf on  
   lcf.ClaimFormatUid = s.ClaimFormatUid  
 left join ListClaimFormatType(NOLOCK) lcft on  
   lcft.ClaimFormatTypeUid = lcf.ClaimFormatTypeUid






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientCareManagementReview]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewPatientCareManagementReview] AS
SELECT   
	NEWID() AS ViewPatientCareManagementReviewUid,
	viewlog.PatientUid,  
	viewlog.PatientName,  
	viewlog.ProviderUid,
	viewlog.ProviderName,
	SUM (viewlog.CCMApprovedMinutes) as CCMApprovedMinutes,
	SUM (viewlog.CCMUnapprovedMinutes) AS CCMUnapprovedMinutes,
	SUM (viewlog.CPOApprovedMinutes) AS CPOApprovedMinutes,
	SUM (viewlog.CPOUnapprovedMinutes) AS CPOUnapprovedMinutes,
	viewlog.LogMonth,
	yy.SuperbillUid, 
	yy.ExternalId,
	SUM (viewlog.CCMApprovedMinutes) + SUM (viewlog.CCMUnapprovedMinutes) AS CCMTotalMinutes,
	SUM (viewlog.CPOApprovedMinutes) + SUM (viewlog.CPOUnapprovedMinutes) AS CPOTotalMinutes,
	MAX ( CAST ( viewlog.MedicalDecisionComplexityHighOrMedium AS INT ) ) AS MDMHighOrMedium
FROM  
	ViewPatientCareManagementReviewDetails  viewlog  
	OUTER APPLY (SELECT TOP 1 SuperbillUid, ExternalID 
		FROM Superbill s
		WHERE s.patientuid=viewlog.patientuid 
			AND s.ServiceDateStart BETWEEN [dbo].[YYYYMMIntAsDateFirstDayOfMonth](viewlog.logmonth) 
				AND [dbo].[YYYYMMIntAsDateLastDayOfMonth](viewlog.logmonth) 
			AND s.superbilluid IN 
				(SELECT SuperbillUid FROM SuperbillProcedure sp 
					INNER JOIN listprocedure lp ON sp.ProcedureUid = lp.ProcedureUid 
					WHERE sp.superbilluid = s.SuperbillUid
						AND sp.ProcedureServiceDateStart BETWEEN [dbo].[YYYYMMIntAsDateFirstDayOfMonth](viewlog.logmonth) 
							AND [dbo].[YYYYMMIntAsDateLastDayOfMonth](viewlog.logmonth) 
						AND lp.Code IN (''99490'',''G0181'',''G0182'',''99487'',''99489''))) AS yy
		GROUP BY viewlog.PatientUid, 
			viewlog.PatientName, 
			viewlog.ProviderUid, 
			viewlog.ProviderName,
			viewlog.LogMonth,
			yy.SuperbillUid,
			yy.ExternalID
UNION
SELECT 
	pcm.PatientCareManagementUid,
	pcm.PatientUid,
	pat.FormattedPreferredName AS PatientName,  
	pcm.ProviderUid,
	(CASE WHEN pcm.ProviderUid IS NOT NULL THEN prov.FormattedPreferredName 
		ELSE '' '' END )
	AS ProviderName,
	null AS CCMApprovedMinutes,
	null AS CCMUnapprovedMinutes,
	null AS CPOApprovedMinutes,
	null AS CPOUnapprovedMinutes, 
	-1 AS Logmonth,
	null AS SuperbillUid,
	'' '' AS ExternalId,
	null AS CCMTotalMinutes,
	null AS CPOTotalMinutes,
	0 AS MDMHighOrMedium
FROM
	PatientCareManagement pcm
		INNER JOIN ViewPerson pat   
			ON pcm.PatientUid = pat.PersonUid
		LEFT JOIN ViewPerson prov   
			ON pcm.ProviderUid = prov.PersonUid
WHERE
	PatientUid NOT IN 
		( SELECT PatientUid FROM PatientCareManagementLog )

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewVisitMedication]'))
EXEC dbo.sp_executesql @statement = N'


/* do not include deleted medication in this view*/
CREATE VIEW [dbo].[ViewVisitMedication]
AS
SELECT
   VisitDate               = v.VisitDate,
   Patient                 = (SELECT pat.FullName FROM dbo.ViewPerson pat WHERE pat.PersonUid = v.PatientUid),
   Provider                = (SELECT prv.FullName FROM dbo.ViewPerson prv WHERE prv.PersonUid = ms.ProviderUid),
   Medication              = ms.Name + '' ''
                              + CASE WHEN sd.Direction != ''''
                                   THEN sd.Direction
                                   ELSE COALESCE (sd.DosageQuantity + '' '', '''')
                                      + COALESCE (sd.DosageUnit + '' '', '''')
                                      + COALESCE (ms.Route + '' '', '''')
                                      + COALESCE (sd.Frequency, '''')
                                END
                              + ISNULL('', QTY: '' + sd.Quantity, '''')
                              + ISNULL('', UOM: '' + (SELECT uom.Name FROM ListSIGQuantityUnitOfMeasure uom WHERE uom.SIGQuantityUnitOfMeasureUid = ms.SIGQuantityUnitOfMeasureUid), '''')
                              + CASE WHEN ms.RefillQuantity > 0 THEN '', Refills: '' + CONVERT(VARCHAR(20), ms.RefillQuantity) ELSE '''' END,
   Pharmacy                = CASE
                                 WHEN ms.IsSampleGiven <> 0 OR ms.IsAdministered <> 0 THEN ''''
                                 ELSE pharm.Name
                              END,
   Successful              = rxo.Successful,
   eRxSentDateTime         = rxo.LastModifiedDate,
   faxDateTime             = CASE WHEN rvm.FulfillmentMethod = 2 THEN rvm.FulfillmentDateTime ELSE null END,
   printDateTime           = CASE WHEN rvm.FulfillmentMethod = 3 THEN rvm.FulfillmentDateTime ELSE null END,
   ReadyToPrescribe        = CASE rvm.ReadyToPrescribe WHEN 0 THEN ''No'' ELSE ''Yes'' END,
   SendResponse            = CASE rvm.ReadyToPrescribe
                                 WHEN 0 THEN
                                    CASE
                                       WHEN ms.IsSampleGiven <> 0 THEN ''Sample was given''
                                       ELSE
                                          CASE
                                             WHEN ms.IsAdministered <> 0 THEN ''Administered''
                                             ELSE ''Medication NOT Marked Ready to Prescribe''
                                          END
                                    END
                                 ELSE
                                    CASE
                                       WHEN rvm.eRxStatusUid = ''0605B6F6-2FE4-49CB-B868-9DF448AB3E01'' AND rxo.eRxOutboundUid IS NULL THEN ''''
                                       ELSE COALESCE(REPLACE(rxo.SendResponse,
                                                             ''Code:000, Description Code: Transaction successful; pending'',
                                                             ''Code:000, Description Code: Transaction successful''),
													 CASE WHEN rvm.StatusMessage != '''' THEN rvm.StatusMessage ELSE NULL END,
                                                     es.Name,
                                                     rxo.ProcessStatus,
                                                     '''')
                                    END
                             END,
   RelVisitMedicationUid   = rvm.RelVisitMedicationUid,
   SIGDetailUid            = sd.SIGDetailUid,
   PatientUid              = v.PatientUid,
   ProviderUid             = ms.ProviderUid,
   PharmacyUid             = CASE
                                 WHEN ms.IsSampleGiven <> 0 OR ms.IsAdministered <> 0 THEN null
                                 ELSE pharm.PharmacyUid
                             END,
   VisitUid                = rvm.VisitUid,
   ClearingHouse           = CASE
                                 WHEN ms.IsSampleGiven <> 0 OR ms.IsAdministered <> 0 THEN ''''
     ELSE COALESCE(lpc.Name, ''None'')
                             END,
eRxMessageType          = lmt.Name,
   eRxMessageID            = CASE
                                 WHEN rxo.eRxOutboundUid IS NOT NULL  THEN REPLACE (rxo.eRxOutboundUid, ''-'', '''')
                                 ELSE NULL
                              END,
   eRxMessageTypeUid       = lmt.eRxMessageTypeUid,
   eRxOutboundUid          = rxo.eRxOutboundUid,
   eRxStatusUid            = rvm.eRxStatusUid,
   PharmacyClearinghouseUid = CASE
                                 WHEN ms.IsSampleGiven <> 0 OR ms.IsAdministered <> 0 THEN null
                                 ELSE mp.PharmacyClearinghouseUid
                              END
FROM dbo.RelVisitMedication AS rvm
INNER JOIN dbo.MedicationSIG AS ms ON rvm.MedicationSIGUid = ms.MedicationSIGUid
INNER JOIN dbo.Visit AS v ON rvm.VisitUid = v.VisitUid
LEFT OUTER JOIN dbo.SIGDetail AS sd ON ms.MedicationSIGUid = sd.MedicationSIGUid
LEFT OUTER JOIN dbo.ListPharmacy AS pharm ON ms.PharmacyUid = pharm.PharmacyUid
LEFT OUTER JOIN dbo.MasterPharmacy as mp ON pharm.MasterPharmacyUid = mp.MasterPharmacyUid
LEFT OUTER JOIN dbo.ListPharmacyClearinghouse as lpc ON mp.PharmacyClearinghouseUid = lpc.PharmacyClearinghouseUid
LEFT OUTER JOIN dbo.ListeRxStatus AS es ON rvm.eRxStatusUid = es.eRxStatusUid
OUTER APPLY (
   SELECT TOP 1 *
   FROM dbo.eRxOutbound rxo
   WHERE rxo.RelVisitMedicationUid = rvm.RelVisitMedicationUid
   ORDER BY LastModifiedDate DESC) rxo
LEFT OUTER JOIN dbo.ListeRxMessageType AS lmt ON rxo.eRxMessageTypeUid = lmt.eRxMessageTypeUid
WHERE (dbo.IsDrugDeleted(ms.DiscontinueReasonUid) = 0)

UNION ALL

SELECT
   VisitDate                = CONVERT(DATE, tob.EnqueuedTimestamp),
   Patient                  = (SELECT pat.FullName FROM dbo.ViewPerson pat WHERE pat.PersonUid = rpm.PatientUid),
   Provider                 = (SELECT prv.FullName FROM dbo.ViewPerson prv WHERE prv.PersonUid = ms.ProviderUid),
   Medication               = ms.Name + '' ''
                            + CASE WHEN sd.Direction != ''''
                                   THEN sd.Direction
                                   ELSE COALESCE (sd.DosageQuantity + '' '', '''')
                                      + COALESCE (sd.DosageUnit + '' '', '''')
                                      + COALESCE (ms.Route + '' '', '''')
                                      + COALESCE (sd.Frequency, '''')
                              END
                            + ISNULL('', QTY: '' + sd.Quantity, '''')
                            + ISNULL('', UOM: '' + (SELECT uom.Name FROM ListSIGQuantityUnitOfMeasure uom WHERE uom.SIGQuantityUnitOfMeasureUid = ms.SIGQuantityUnitOfMeasureUid), '''')
                            + CASE WHEN ms.RefillQuantity > 0 THEN '', Refills: '' + CONVERT(VARCHAR(20), ms.RefillQuantity) ELSE '''' END,
   Pharmacy                 = CASE
                                 WHEN ms.IsSampleGiven <> 0 OR ms.IsAdministered <> 0 THEN ''''
                                 ELSE pharm.Name
                              END,
   Successful               = hlp.Successful,
   eRxSentDateTime          = tob.LastModifiedDate,
   faxDateTime              = NULL,
   printDateTime            = NULL,
   ReadyToPrescribe         = ''Yes'',
   SendResponse             = COALESCE(hlp.ProcessStatus,
                                       REPLACE(hlp.SendResponse, ''Code:000, Description Code: Transaction successful; pending'', ''Code:000, Description Code: Transaction successful''),
									   CASE WHEN rpm.StatusMessage != '''' THEN rpm.StatusMessage ELSE NULL END,
                                       es.Name,
                                       hlp.ProcessStatus,
                                       ''''),
   RelVisitMedicationUid    = NULL,
   SIGDetailUid             = sd.SIGDetailUid,
   PatientUid               = rpm.PatientUid,
   ProviderUid              = ms.ProviderUid,
   PharmacyUid              = ms.PharmacyUid,
   VisitUid                 = NULL,
   ClearingHouse            = CASE
                                  WHEN ms.IsSampleGiven <> 0 OR ms.IsAdministered <> 0 THEN ''''
                                  ELSE COALESCE(lpc.Name, ''None'')
                              END,
   eRxMessageType           = lmt.Name,
   eRxMessageID             = REPLACE(tob.TransmissionOutboundUid, ''-'', ''''),
   eRxMessageTypeUid        = lmt.eRxMessageTypeUid,
   eRxOutboundUid           = NULL,
   eRxStatusUid             = hlp.eRxStatusUid,
   PharmacyClearinghouseUid = CASE
                                 WHEN ms.IsSampleGiven <> 0 OR ms.IsAdministered <> 0 THEN null
                                 ELSE mp.PharmacyClearinghouseUid
                              END
FROM dbo.TransmissionOutbound tob
INNER JOIN dbo.RelPatientMedication rpm ON rpm.RelPatientMedicationUid = tob.ForeignObjectUid
INNER JOIN dbo.MedicationSIG AS ms ON ms.MedicationSIGUid = rpm.MedicationSIGUid
INNER JOIN dbo.SIGDetail AS sd ON sd.MedicationSIGUid = ms.MedicationSIGUid
INNER JOIN dbo.ListPharmacy AS pharm ON ms.PharmacyUid = pharm.PharmacyUid
INNER JOIN dbo.MasterPharmacy as mp ON pharm.MasterPharmacyUid = mp.MasterPharmacyUid
INNER JOIN dbo.ListPharmacyClearinghouse as lpc ON mp.PharmacyClearinghouseUid = lpc.PharmacyClearinghouseUid
INNER JOIN dbo.ListeRxMessageType AS lmt ON lmt.ExternalID = tob.TransmissionType
CROSS APPLY (
   SELECT
      eRxStatusUid  = rpm.DataXML.value(''(/CancelRx/eRxStatusUid)[1]'', ''UNIQUEIDENTIFIER''),
     Successful    = rpm.DataXML.value(''(/CancelRx/TransmissionInfo/Successful)[1]'', ''BIT''),
     SendResponse  = rpm.DataXML.value(''(/CancelRx/TransmissionInfo/SendResponse)[1]'', ''VARCHAR(MAX)''),
     ProcessStatus =  rpm.DataXML.value(''(/CancelRx/TransmissionInfo/ProcessStatus)[1]'', ''VARCHAR(MAX)'')) hlp
LEFT OUTER JOIN dbo.ListeRxStatus AS es ON es.eRxStatusUid = hlp.eRxStatusUid
WHERE tob.TransmissionType = ''CANRX''



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountResponsiblePartyByFinancialCenterAggregate_SumAccountLiabilities]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewAccountResponsiblePartyByFinancialCenterAggregate_SumAccountLiabilities] 
AS
SELECT AC.AccountResponsiblePartyUid, SFD.FinancialCenterUid,
	SUM(ISNULL(VSA.Liability,0)) AS Liability, 
	SUM(ISNULL(VSA.AssignedLiability,0)) AS AssignedLiability,
	SUM(ISNULL(VSA.LiabilityBalance,0)) AS LiabilityBalance, 
	SUM(ISNULL(VSA.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance
FROM Account AC 
LEFT JOIN Superbill SB ON AC.AccountUid = SB.AccountUid
LEFT JOIN AR_ViewSuperbillAggregate VSA ON SB.SuperbillUid = VSA.SuperbillUid
LEFT JOIN ViewSuperbillFinancialDetails SFD ON SB.SuperbillUid = SFD.SuperbillUid
GROUP BY AC.AccountResponsiblePartyUid, SFD.FinancialCenterUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewHL7MessageStatus]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewHL7MessageStatus] AS
SELECT
	[MiscUid],
	[Name],
	CONVERT ([smallint], [Val]) AS [HL7MessageStatus],
	[DisplayOrder]
FROM [ListMisc]
WHERE [ListType] = ''HL7MessageStatus''
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessagesNewRx]'))
EXEC dbo.sp_executesql @statement = N'
CREATE view [dbo].[ViewMessagesNewRx] as
SELECT tob.[TransmissionOutboundUid] AS [Uid],
       CASE WHEN tob.[TransmissionOutboundUid] IS NOT NULL THEN 2 ELSE 3 END AS [Type],
       COALESCE (ob.[RequestXML], ob.[MessageXML]) AS [ViewXmlMessage],
       CONVERT(VARCHAR(MAX),COALESCE (ob.[RequestXML], ob.[MessageXML])) AS [XmlMessageText],
       COALESCE (ob.[RequestXML], ob.[MessageXML]) AS [XmlMessage],
       COALESCE (ob.RequestNCPDP, ob.[MessageSent]) AS [RawMessage],
       CASE WHEN tob.[Status] IS NOT NULL THEN
                    CASE WHEN td.[RequestId] = CAST (tob.[ForeignObjectUid] AS VARCHAR(128)) AND td.[IsError] <> 0 THEN 500
                                ELSE tob.[Status]
                    END
            WHEN vm.[eRxOutboundUid] IS NULL THEN 100
            WHEN ob.[Processed] = 0 and ob.[Successful] = 0 THEN 0
            WHEN ob.[Processed] <> 0 and (ob.[Successful] = 0 OR (ob.[Successful] <> 0 AND msg.[MessageUid] IS NOT NULL)) THEN 500 ELSE 100
       END AS [StatusCode],
       s.[Name] AS [Status], 
       CONVERT(datetime, null) AS [RetryTime],
       CONVERT(int, null) AS [RetryMinutes],
       CONVERT(int, null) AS [MessageControlID],
       CONVERT(varchar(8000), COALESCE (tob.[LastError], td.[LastError], (CASE WHEN ob.[SendResponse] IS NOT NULL AND ob.[SendResponse] <> '''' THEN ob.[SendResponse] END), msg.[Body])) AS [Error],
       vmmt.[eRxMessageTypeUid] AS [HL7PartnerMessageUid],
       COALESCE (tc.[IntegrationPartnerUid], ob.[PharmacyClearinghouseUid], vm.[PharmacyClearinghouseUid]) AS [HL7PartnerUid],
       CASE
            WHEN vm.[ClearingHouse] = '''' AND ms.[IsSampleGiven] <> 0 THEN ''Sample Given''
            WHEN vm.[ClearingHouse] = '''' AND ms.[IsAdministered] <> 0 THEN ''Administered''
                    ELSE COALESCE (vm.[ClearingHouse], (CASE WHEN tob.[TransmissionOutboundUid] IS NOT NULL THEN lip.[Name] ELSE lip.[ExternalID] END))
       END AS [Name],
       vmmt.[ExternalID] AS [MessageType], 
       CASE WHEN vm.[faxDateTime] IS NOT NULL THEN vm.[faxDateTime]
            WHEN vm.[printDateTime] IS NOT NULL THEN vm.[printDateTime]
            WHEN vm.[eRxSentDateTime] IS NOT NULL THEN vm.[eRxSentDateTime]
            ELSE COALESCE (rvm.[LastModifiedDate], ob.[LastModifiedDate])
       END AS [LastModifiedDate],
       ''Send'' AS [InOut],
       0 AS Reprocess,
       vm.[Patient],
       vm.[Provider],
       ss.[Name] AS [ServiceSite],
       vm.[Medication] AS [Description],
       vm.[Pharmacy],
       vm.[VisitUid],
       vm.[PatientUid],
       vm.[ProviderUid],
       v.[ServiceSiteUid],
       vm.[PharmacyUid]
FROM [ViewVisitMedication] AS vm WITH(NOLOCK)
    INNER JOIN [RelVisitMedication] AS rvm WITH(NOLOCK) ON vm.[RelVisitMedicationUid] = rvm.[RelVisitMedicationUid]
    INNER JOIN [MedicationSIG] AS ms WITH(NOLOCK) ON rvm.[MedicationSIGUid] = ms.[MedicationSIGUid]
    INNER JOIN [Visit] AS v WITH(NOLOCK) ON vm.[VisitUid] = v.[VisitUid]
    INNER JOIN [eRxOutbound] AS ob WITH(NOLOCK) ON vm.[eRxOutboundUid] = ob.[eRxOutboundUid]
    INNER JOIN [TransmissionConfiguration] AS tc WITH(NOLOCK) ON ob.[TransmissionConfigurationUid] = tc.[TransmissionConfigurationUid]
	INNER JOIN [ListeRxMessageType] AS vmmt WITH(NOLOCK) ON vmmt.[eRxMessageTypeUid] = ''9F19ED8C-3524-46EA-9F4B-B932D38F8585''
		AND tc.[TransmissionType] = vmmt.[ExternalID]
    INNER JOIN [TransmissionOutbound] AS tob WITH(NOLOCK) ON vmmt.[ExternalID] = tob.[TransmissionType]
            AND ob.[eRxOutboundUid] = tob.[ForeignObjectUid]
    OUTER APPLY
    (
            SELECT *
            FROM [TransmissionData] WITH(NOLOCK)
            WHERE [TransmissionType] = tob.[TransmissionType]
				AND [RequestId] = CAST (tob.[ForeignObjectUid] AS VARCHAR(256))
				AND [IsError] <> 0
    ) AS td
    OUTER APPLY
    (
            SELECT *
            FROM [MessageRX] WITH (NOLOCK)
            WHERE [eRxOutboundUid] = ob.[eRxOutboundUid]
				AND ob.[Successful] = 0
    ) AS msg
    OUTER APPLY
    (
    SELECT [IntegrationPartnerUid], [Name], [ExternalID]
            FROM [ListIntegrationPartner] WITH(NOLOCK)
            WHERE [IntegrationPartnerUid] IN (
                    ob.[PharmacyClearinghouseUid],
                    vm.[PharmacyClearinghouseUid],
                    tc.[IntegrationPartnerUid],
                    ''118422AA-C165-4A2E-8389-E5B7E89636EA''
            )
    ) AS lip
    LEFT OUTER JOIN [ListServiceSite] AS ss WITH(NOLOCK) ON v.[ServiceSiteUid] = ss.[ServiceSiteUid]
    LEFT OUTER JOIN [ViewHL7MessageStatus] AS s WITH(NOLOCK) ON (CASE WHEN tob.[Status] IS NOT NULL THEN
																		CASE WHEN td.[RequestId] = CAST (tob.[ForeignObjectUid] AS VARCHAR(128)) AND td.[IsError] <> 0 THEN 500
																			ELSE tob.[Status]
																		END
																		WHEN vm.[eRxOutboundUid] IS NULL THEN 100
																		WHEN ob.[Processed] = 0 and ob.[Successful] = 0 THEN 0
																		WHEN ob.[Processed] <> 0 and (ob.[Successful] = 0 OR (ob.[Successful] <> 0 AND msg.[MessageUid] IS NOT NULL)) THEN 500 ELSE 100
																END) = s.[HL7MessageStatus]
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountResponsiblePartyByFinancialCenterAggregate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewAccountResponsiblePartyByFinancialCenterAggregate] 
AS
SELECT ARP.AccountResponsiblePartyUid, SAL.FinancialCenterUid,
	ISNULL(VARPAB.Receipt, 0) AS Receipt,
	ISNULL(VARPAB.ReceiptBalance, 0) AS ReceiptBalance,
	ISNULL(SAL.Liability, 0) AS Liability, 
	ISNULL(SAL.AssignedLiability, 0) AS AssignedLiability,
	ISNULL(SAL.LiabilityBalance, 0) AS LiabilityBalance, 
	ISNULL(SAL.AssignedLiabilityBalance, 0) AS AssignedLiabilityBalance
FROM AccountResponsibleParty ARP
LEFT JOIN AR_ViewAccountResponsiblePartyAggregateSub (NOEXPAND) VARPAB ON ARP.AccountResponsiblePartyUid = VARPAB.AccountResponsiblePartyUid
LEFT JOIN AR_ViewAccountResponsiblePartyByFinancialCenterAggregate_SumAccountLiabilities SAL ON ARP.AccountResponsiblePartyUid = SAL.AccountResponsiblePartyUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewBatchProcessDetailCreditCardConsents]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewBatchProcessDetailCreditCardConsents]

AS

SELECT BPD.BatchProcessDetailUid, BP.BatchProcessUid, 
			CASE WHEN BPD.Error IS NULL THEN 0 ELSE 1 END AS HasError,
			CASE WHEN BPD.DetailXml IS NULL THEN 0 ELSE 1 END AS [Generated],
			BPD.Error, 

		BPD.Uid as AccountResponsiblePartyUid, COALESCE(VP.FullName, VC.Name) AS AccountResponsiblePartyFullName,
		(SELECT x.n.value(''.'',''VARCHAR(500)'') FROM BPD.IntermediateXml.nodes(''GeneratedDocument/Superbills'') AS x(n)) AS SelectedSuperbillList,
		(SELECT x.n.value(''count(Superbill)'',''INT'') FROM BPD.IntermediateXml.nodes(''GeneratedDocument/Superbills'') AS x(n)) AS SelectedSuperbillCount,
		(SELECT x.n.value(''./@Amount'',''MONEY'') FROM BPD.IntermediateXml.nodes(''GeneratedDocument/Deposit'') AS x(n)) AS PaymentAmount,
		(SELECT x.n.value(''.'',''UNIQUEIDENTIFIER'') FROM BPD.IntermediateXml.nodes(''GeneratedDocument/Deposit'') AS x(n)) AS DepositUid,
		(SELECT x.n.value(''./@ReferenceNumber'',''VARCHAR(500)'') FROM BPD.IntermediateXml.nodes(''GeneratedDocument/Deposit'') AS x(n)) AS DepositReferenceNumber,

		CASE WHEN NOT BPD.DetailXml IS NULL THEN ''Processed'' ELSE ''InProcess'' END AS Status

	FROM BatchProcess BP WITH (NOLOCK)
			INNER JOIN BatchProcessDetail BPD WITH (NOLOCK) ON BP.BatchProcessUid = BPD.BatchProcessUid
			INNER JOIN AccountResponsibleParty ARP WITH (NOLOCK) ON BPD.Uid = ARP.AccountResponsiblePartyUid
				LEFT JOIN ViewPerson VP WITH (NOLOCK) ON ARP.PersonUid = VP.PersonUid  
				LEFT JOIN ViewCorporation VC WITH (NOLOCK) ON ARP.CorporationUid = VC.CorporationUid  
	WHERE BatchProcessTypeUid =  ''10000101-0000-0000-0000-000000000006''






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VieweRxMedicationHistoryOutbound]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[VieweRxMedicationHistoryOutbound]
AS
SELECT TOP 100 PERCENT
	ob.eRxMedicationHistoryOutboundUid,
	ob.RequestDateFrom, 
	ob.RequestDateTo, 
	vp_Patient.FullName AS Patient, 
	vp_Provider.FullName AS Provider, 
	ob.Successful, 
	ob.LastModifiedDate AS eRxSentDateTime,
	COALESCE (ob.SendResponse, es.Name, '''') AS SendResponse, 
    COALESCE(lpc.Name, ''None'') as ClearingHouse,
	ob.PatientUid, 
	ob.ProviderUid, 
	lmt.Name eRxMessageType,
	CASE WHEN ob.eRxMedicationHistoryOutboundUid IS NOT NULL 
		THEN REPLACE (ob.eRxMedicationHistoryOutboundUid, ''-'', '''')
		ELSE NULL
	END AS eRxMessageID,
	ob.eMedHxSource,
	ob.OrderNumber,
	ob.OrderDateTime,
	lmt.eRxMessageTypeUid,
	ob.Processed
FROM eRxMedicationHistoryOutbound AS ob
	INNER JOIN dbo.Provider AS p ON ob.ProviderUid = p.PersonUid
	INNER JOIN dbo.Patient AS pp ON ob.PatientUid = pp.PersonUid
	INNER JOIN dbo.ViewPerson AS vp_Patient ON pp.PersonUid = vp_Patient.PersonUid
	LEFT OUTER JOIN dbo.ViewPerson AS vp_Provider ON p.PersonUid = vp_Provider.PersonUid
	LEFT OUTER JOIN dbo.ListeRxStatus AS es ON ob.eRxStatusUid = es.eRxStatusUid
	LEFT OUTER JOIN dbo.ListPharmacyClearinghouse as lpc ON ob.PharmacyClearinghouseUid = lpc.PharmacyClearinghouseUid
	LEFT OUTER JOIN dbo.ListeRxMessageType AS lmt ON ob.eRxMessageTypeUid = lmt.eRxMessageTypeUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewAccountResponsiblePartySendStatement]'))
EXEC dbo.sp_executesql @statement = N'




/**
	Task 46000:Create logic to handle all new send statement option
	ATTN:  Update SendStatementComment In ControlAccountResponsibleParty.cs if change so match
	20160126	BMR		Created
	20150128    BMR		Added Comment and ARP Selection
	20161019    BMR		Added SendPaperlessStatements
	20161021	BMR		Reformated to make easier to read
	20180724    BMR     BUG 9674 - Added Corporation Support - BadAddress and Email
**/

CREATE VIEW [dbo].[ViewAccountResponsiblePartySendStatement]  AS 
WITH cteBase AS 
(
SELECT ARP.AccountResponsiblePartyUid, 
	CASE 
		WHEN ARP.SendStatement = 1	THEN ''1;ARP - Send''  -- ARP is YES
		WHEN ARP.SendStatement = 2	THEN ''0;ARP - Do Not Send''  -- ARP is NO 
		WHEN COALESCE(P.BadAddress1, C.BadAddress) = 1	THEN ''0;Blocked By Bad Address'' -- ARP Person Has Bad Address 
		WHEN LCS.SendStatement = 0  THEN ''0;Blocked By Collection Status'' -- Collection Status and SendStatement not set - Do Not Send
		ELSE ''1;System - Send'' -- otherwise, send
	END AS SendStatementInfo, 
	CASE 
		WHEN NOT EXISTS(SELECT * FROM ListProductParameter WHERE ProductParameterUid = ''D0DF5185-9F23-4D2B-8BF3-0E6C48442861'' AND LEN(StringValue) > 0) 
			THEN ''0;PatientPortalURL Not Defined - Do Not Send'' 
		WHEN NOT EXISTS(SELECT * FROM ListProductParameter WHERE ProductParameterUid = ''EFBB66F7-AFBB-421D-8A99-697D36FF5625'' AND LEN(StringValue) > 0) 
			THEN ''0;PracticeFromEmail Not Defined - Do Not Send''  
		WHEN COALESCE(P.Email1, P.Email2) IS NULL THEN ''0;ARP Email Not Defined - Do Not Send'' 
		WHEN ARP.SendPaperlessStatements = 1	THEN ''1;ARP - Send''  -- ARP is YES 
		WHEN ARP.SendPaperlessStatements = 2	THEN ''0;ARP - Do Not Send''  -- ARP is NO 
		WHEN EXISTS(SELECT * FROM PracticeSettings WHERE SendPaperlessStatements = 1) THEN ''1;System - Send'' -- Practice Settings is YES 
		ELSE ''0;System - Do Not Send''
	END AS SendPaperlessStatementsInfo 
	FROM dbo.AccountResponsibleParty ARP
		LEFT JOIN dbo.Corporation C ON ARP.CorporationUid = C.CorporationUid
		LEFT JOIN dbo.Person P ON ARP.PersonUid = P.PersonUid
		LEFT JOIN dbo.ListCollectionStatus LCS ON ARP.CollectionStatusUid = LCS.CollectionStatusUid
) -- used strings above to make logic clearer while providing both the bool and ''reason'' information
SELECT AccountResponsiblePartyUid,
	CAST(SUBSTRING(SendStatementInfo,1,1) AS BIT) AS SendStatement,
	SUBSTRING(SendStatementInfo,3,100) AS SendStatementComment,
	CAST(SUBSTRING(SendPaperlessStatementsInfo,1,1) AS BIT) AS SendPaperlessStatements,
	SUBSTRING(SendPaperlessStatementsInfo,3,100) AS SendPaperlessStatementsComment
		FROM cteBase

/*

	SELECT ARPSS.*
		FROM ViewAccountResponsiblePartySendStatement ARPSS
	SELECT ARPSS.*,  VP.*
		FROM ViewAccountResponsiblePartySendStatement ARPSS
			INNER JOIN AccountResponsibleParty ARP ON ARPSS.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid
			INNER JOIN ViewPerson VP ON ARP.PersonUid = VP.PersonUid
*/











' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewARPBalanceWithUid]'))
EXEC dbo.sp_executesql @statement = N'


--20120620 KB removed check for PracticeSettings.IncludeCompletedOrClosed to improve performance
--2016/02/01 - kculberth 	Task 45999 - Add or change send statement view to look at new responsible party ID "send statement" flag.

CREATE VIEW [dbo].[ViewARPBalanceWithUid]    
AS    
  

SELECT  arp.AccountResponsiblePartyUid,   
SUM(VAA.LiabilityBalance - VAA.AssignedLiabilityBalance) AS Balance        
FROM dbo.AccountResponsibleParty arp   (nolock)
INNER JOIN dbo.Account a (nolock) ON arp.AccountResponsiblePartyUid = a.AccountResponsiblePartyUid    
INNER JOIN AR_ViewAccountAggregate VAA (nolock) ON A.AccountUid = VAA.AccountUid  
INNER JOIN ViewAccountResponsiblePartySendStatement ss on ss.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
WHERE ss.SendStatement = 1 --and a.Inactive=0  
GROUP BY arp.AccountResponsiblePartyUid 



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalance]'))
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[ViewStatementSuperbillBalance]  WITH SCHEMABINDING
AS 
SELECT
	A.AccountResponsiblePartyUid as RPUid, 
	S.SuperbillUid, 
	LD.FinancialCenterUid,
	Sum(Case When LD.LiabilityOwner > 0  Then LD.Amount Else Convert(Money, 0) End) as Insurance, 
	Sum(Case When LD.LiabilityOwner = 0  Then LD.Amount Else Convert(Money, 0) End) as Patient,
	Sum(LD.Amount) as LiabilityBalance,
	S.SuperbillStatusUid,
	COUNT_BIG(*) MaxCnt
FROM	dbo.AR_Ledger (NOLOCK) L 
INNER JOIN	dbo.AR_LedgerDetail (NOLOCK) LD
ON	L.LedgerUid=LD.LedgerUid 
INNER JOIN	dbo.SuperbillProcedure (NOLOCK) SP 
ON	SP.SuperbillProcedureUid=LD.SuperbillProcedureUid
INNER JOIN	dbo.Superbill (NOLOCK) S 
ON	S.SuperbillUid=SP.SuperbillUid
INNER JOIN	dbo.Account (NOLOCK) A 
ON	S.AccountUid = A.AccountUid
GROUP BY 
	A.AccountResponsiblePartyUid, S.SuperbillUid, LD.FinancialCenterUid, SuperbillStatusUid

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_ViewStatementSuperbillBalance_AccountResponsiblePartyUid ON ViewStatementSuperbillBalance(RPUid, SuperbillUid, FinancialCenterUid)

*/



' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalance]') AND name = N'PK_ViewStatementSuperbillBalance_AccountResponsiblePartyUid')
CREATE UNIQUE CLUSTERED INDEX [PK_ViewStatementSuperbillBalance_AccountResponsiblePartyUid] ON [dbo].[ViewStatementSuperbillBalance]
(
	[RPUid] ASC,
	[SuperbillUid] ASC,
	[FinancialCenterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementBalanceandAgeInsurance]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewStatementBalanceandAgeInsurance]   
AS  
SELECT  
-- dbo.Charge.ChargeUid  
 A.AccountResponsiblePartyUid,   
 LD.FinancialCenterUid,  
 LD.LiabilityOwner,  
 (CASE WHEN ld.Amount <0 THEN isnull(VSP.LiabilityBalance - VSP.AssignedLiabilityBalance,0) * -1 ELSE isnull(VSP.LiabilityBalance - VSP.AssignedLiabilityBalance,0) END) AS BalanceAll,  
 ARB.GLDate as LiabilityDate    
FROM  
 AR_Ledger L  
INNER JOIN  
 AR_LedgerDetail LD  
ON  
 L.LedgerUid=LD.LedgerUid AND (L.EntryType=1 OR L.EntryType=4) --AND LD.IsCredit=0 
JOIN
 ARBatch ARB
ON
 L.ArBatchUid =ARB.ARBatchUid  
INNER JOIN  
 AR_ViewSuperbillProcedureAggregate VSP  
ON  
 LD.SuperbillProcedureUid= VSP.SuperbillProcedureUid  
INNER JOIN  
 SuperbillProcedure SP  
ON  
 SP.SuperbillProcedureUid=LD.SuperbillProcedureUid  
INNER JOIN  
 Superbill S  
ON  
 S.SuperbillUid=SP.SuperbillUid  
INNER JOIN  
 Account A  
ON  
 S.AccountUid = A.AccountUid  
WHERE  
 ( VSP.AssignedLiabilityBalance) > 0 AND LD.LiabilityOwner > 0  
 --AND SP.SuperbillUid NOT IN  
 --            (  
 --                SELECT SuperbillUid FROM [ViewStatementLineItem]  
 --                WHERE Type=''subtotal''  
 --                AND Patient=0  
 --            )   
  
 AND SP.SuperbillUid NOT IN  
             (  
     select SuperbillUid from ViewStatementSuperbillBalance  WITH (NOEXPAND)
     where Patient=0  
             )    
  




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewARPBalanceWithName]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewARPBalanceWithName]
AS
SELECT	arp.AccountResponsiblePartyUid, arpb.Balance, 
		(CASE WHEN arp.CycleTrigger = 1 THEN 1 WHEN EXISTS (SELECT 1 FROM Account a WHERE a.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid AND a.CycleTrigger = 1) THEN 1 ELSE 0 END) AS CycleTrigger, 
		arp.LastStatementDate, 
		(CASE WHEN p.PersonUid IS NOT NULL 
		THEN vpns.FullName 
		ELSE c.Name END) AS arpFullName,
 		(CASE WHEN p.PersonUid IS NOT NULL THEN p.LastName 
		ELSE c.Name END) AS LastName,
		arp.ExternalID 
FROM	ViewARPBalanceWithUid arpb 
		INNER JOIN AccountResponsibleParty arp ON (arp.AccountResponsiblePartyUid = arpb.AccountResponsiblePartyUid) 
		LEFT JOIN Person p ON p.PersonUid = arp.PersonUid 
		LEFT JOIN Corporation c ON c.CorporationUid = arp.CorporationUid 
		LEFT JOIN ViewPerson vpns on vpns.PersonUid = p.PersonUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[Audit]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[Audit] AS
		SELECT	*
		FROM	[AuditCurrent] WITH (NOLOCK)
		UNION ALL
		SELECT	*
		FROM	[AuditArchive] WITH (NOLOCK)
		
-- BMR 20141010 - Added NOLOCK here ... no reason we need locks on these reads

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewAudit]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[ViewAudit]
AS
SELECT     
	Audit.AuditUid, 
	Audit.Type, 
	Audit.TableName, 
	Audit.RowPrimaryUid, 
	Audit.Changes, 
	Audit.Workstation, 
	Audit.UserUid, 
	Audit.ChangeDate, 
	Audit.LastModifiedDate,
	Users.Inactive, 
	CASE 
		WHEN (Audit.UserUid IS NOT NULL AND UserPrm.LastModifiedDate IS NULL)
		THEN ''System User''
		ELSE
			Users.FirstName + '' '' + Users.LastName 
	END
	AS UserName, 
	Audit.PatientUid, 
	PersonPatient.FirstName + '' '' + PersonPatient.LastName AS PatientName, 
	Patient.ExternalID,
	CASE ISNULL(Audit.Description, ''See Details'') 
		WHEN '''' 
		THEN ''See Details'' 
		ELSE Audit.Description 
	END AS Description,
	CASE 
		WHEN (RelAuditSuperbill.Source IS NULL)
		THEN ''''
		ELSE RelAuditSuperbill.Source
	END AS Source
	
FROM Audit with (NOLOCK)
LEFT JOIN Person Users ON Users.PersonUid = Audit.UserUid
LEFT JOIN Person PersonPatient ON PersonPatient.PersonUid = Audit.PatientUid
LEFT JOIN Patient Patient ON Patient.PersonUid = Audit.PatientUid
LEFT JOIN UserPRM ON UserPRM.PersonUid = Audit.UserUid
LEFT JOIN ListAuditEventConfiguration ON ListAuditEventConfiguration.Name = Audit.Type
LEFT JOIN RelAuditSuperbill ON Audit.AuditUid = RelAuditSuperbill.AuditUid
WHERE ListAuditEventConfiguration.AuditEvent = 1




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillFullInsurance]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewSuperbillFullInsurance] AS
       SELECT s.SuperbillUid,
                     s.ExternalID, 
                     s.PatientUid, s.PatientName,
                     s.RenderingProviderUid, s.RenderingProviderName,
                     s.ClaimingProviderUid, s.ClaimingProviderName, s.ReferingProviderName,
                     s.SuperbillStatusUid, s.SuperbillStatusName,
                     s.ServiceDateStart, s.ServiceDateEnd, s.FirstFiledDate, s.LastFiledDate,
                     s.ServiceSiteUid, s.ServiceSiteName,
                     s.AccountUid, s.VisitUid, s.VisitDate, S.VisitIsCompleted, s.ClaimPaper, s.LastModifiedByUid,   
                     s.IsPosted, 
                     s.FinancialCenterUid, s.FinancialCenterName, s.MaxPostingDate, s.MinPostingDate,
					 s.Notes,
					 SA.PrimaryInsurancePlanUid as testthis,
                     pip.InsurancePlanUid AS PrimaryInsurancePlanUid, pip.InsuranceCarrierUid AS PrimaryInsuranceCarrierUd, 
                     pip.InsuranceCarrier AS PrimaryInsuranceCarrier, pip.Name AS PrimaryInsurance, 
                     cip.InsurancePlanUid AS CurrentInsurancePlanUid, 
            cip.InsuranceCarrierUid AS CurrentInsuranceCarrierUd, 
            cip.InsuranceCarrier AS CurrentInsuranceCarrier, 
            cip.Name AS CurrentInsurance, 
                     cip.Name AS PayerPlanName, cip.InsuranceCarrier AS PayerName,
                     cip.InsuranceCarrierUid, cip.InsurancePlanUid, 
                     s.InsuranceOrder, s.InsuranceLevelName,
                     VSA.Liability AS TotalCharge,
                     (VSA.LiabilityBalance - VSA.AssignedLiabilityBalance) AS PatientResponsibility,
                     VSA.AssignedLiabilityBalance AS InsuranceResponsibility,
                     sa.LastPatientPaymentDate, 
            0-COALESCE(sa.LastPatientPaymentAmount, 0) AS LastPatientPayment,
                     sa.LastInsurancePaymentCarrierUid, sa.LastInsurancePaymentDate, 
            0-COALESCE(sa.LastInsurancePaymentAmount, 0) AS LastInsurancePayment, 
                     lcf.ClaimFormatUid, lcf.Name as FilingMethod, 
                     s.CodeValidationErrors,
                     CAST(0 as bit) as Inactive, -- sa.Inactive,
                     CAST(0 as bit) AS ARLocked, /* not needed anymore since only one row per Superbill */
            CAST(case when pip.InsurancePlanUid=cip.InsurancePlanUid then 1 else 0 end as bit) as IsCurrentInsurancePrimary,
            case when s.ABN=1 then ''Yes'' else ''No'' end as ABN,       
            cip.AccountTypeUid ,
			S.SuperbillProcedureCount
FROM   ViewSuperbill s 
					 INNER JOIN SuperbillAggregate sa WITH (NOLOCK) ON s.SuperbillUid = sa.SuperbillUid
                     LEFT JOIN ViewInsurancePlan pip ON sa.PrimaryInsurancePlanUid = pip.InsurancePlanUid
                     LEFT JOIN ViewInsurancePlan cip ON dbo.GetSuperbillCurrentInsurancePlan(s.SuperbillUid) = cip.InsurancePlanUid
                     LEFT JOIN AR_ViewSuperbillAggregate VSA ON s.SuperbillUid = VSA.SuperbillUid 
                     LEFT JOIN ListClaimFormat lcf WITH (NOLOCK) ON lcf.ClaimFormatUid = dbo.UDF_AR_getPlanClaimFormatUid(s.ClaimPaper, cip.InsurancePlanUid, s.InsuranceOrder)







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillScrubFullInsurance]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewSuperbillScrubFullInsurance] AS
WITH cteSuperbillLockInfo AS
(
	SELECT LSV.SuperbillUid, ROW_NUMBER() OVER (PARTITION BY LSV.SuperbillUid ORDER BY LSV.LockDateStart) AS RowNo, 
	LSV.LockUid, PNS.FullName, LSV.HostName, LSV.LockDate, LSV.LockDateStart 
	FROM
	(
		SELECT SB.SuperbillUid, L.LockByUid,
		L.LockUid, L.HostName, L.LockDate, L.LockDateStart
		FROM Lock L WITH (NOLOCK)
		INNER JOIN Superbill SB ON L.LockedUid = SB.SuperbillUid
		UNION
		SELECT SB.SuperbillUid, L.LockByUid,
		L.LockUid, L.HostName, L.LockDate, L.LockDateStart
		FROM Lock L WITH (NOLOCK)
		INNER JOIN Superbill SB ON L.LockedUid = SB.VisitUid
	) LSV
	INNER JOIN ViewPerson PNS ON LSV.LockByUid = PNS.PersonUid
)
	SELECT
		   vsfb.SuperbillUid
		  ,vsfb.ExternalID AS ExternalID 
		  ,vsfb.PatientUid
		  ,vsfb.PatientName
		  ,vsfb.RenderingProviderUid
		  ,vsfb.RenderingProviderName
		  ,vsfb.ClaimingProviderUid
		  ,vsfb.ClaimingProviderName
		  ,vsfb.ReferingProviderName
		  ,vsfb.SuperbillStatusUid
		  ,vsfb.SuperbillStatusName
		  ,vsfb.ServiceDateStart
		  ,vsfb.ServiceDateEnd
		  ,vsfb.FirstFiledDate
		  ,vsfb.LastFiledDate
		  ,vsfb.ServiceSiteUid
		  ,vsfb.ServiceSiteName
		  ,vsfb.AccountUid
		  ,vsfb.VisitUid
		  ,vsfb.VisitDate
		  ,vsfb.VisitIsCompleted
		  ,vsfb.ClaimPaper
		  ,vsfb.LastModifiedByUid
		  ,vsfb.IsPosted
		  ,vsfb.FinancialCenterUid
		  ,vsfb.FinancialCenterName
		  ,vsfb.MaxPostingDate
		  ,vsfb.MinPostingDate
		  ,vsfb.PrimaryInsurancePlanUid
		  ,vsfb.PrimaryInsuranceCarrierUd
		  ,vsfb.PrimaryInsuranceCarrier
		  ,vsfb.PrimaryInsurance
		  ,vsfb.CurrentInsurancePlanUid
		  ,vsfb.CurrentInsuranceCarrierUd
		  ,vsfb.CurrentInsuranceCarrier
		  ,vsfb.CurrentInsurance
		  ,vsfb.PayerPlanName
		  ,vsfb.PayerName
		  ,vsfb.InsuranceCarrierUid
		  ,vsfb.InsurancePlanUid
		  ,vsfb.InsuranceOrder
		  ,vsfb.InsuranceLevelName
		  ,vsfb.TotalCharge
		  ,(ISNULL(vsfb.PatientResponsibility,0) +  ISNULL(vsfb.InsuranceResponsibility,0)) AS TotalLiability
		  ,vsfb.PatientResponsibility
		  ,vsfb.InsuranceResponsibility
		  ,vsfb.LastPatientPaymentDate
		  ,vsfb.LastPatientPayment
		  ,vsfb.LastInsurancePaymentCarrierUid
		  ,vsfb.LastInsurancePaymentDate
		  ,vsfb.LastInsurancePayment
		  ,vsfb.ClaimFormatUid
		  ,vsfb.FilingMethod
		  ,vsfb.CodeValidationErrors
		  ,vsfb.Inactive
		  ,vsfb.ARLocked
		  ,vsfb.IsCurrentInsurancePrimary
		  ,vsfb.ABN
		  ,vsfb.AccountTypeUid
		  ,vsfb.Notes
		  ,ARP.AccountResponsiblePartyUid
		  ,CASE WHEN NOT ARP.CorporationUid IS NULL THEN ARPCORP.Name
			ELSE ARPPERSON.FullName END AS AccountResponsiblePartyName
		  ,ARPA.LiabilityBalance - ARPA.AssignedLiabilityBalance AS AccountResponsiblePartyLiabilityBalance
		  ,CASE WHEN (vsfb.CodeValidationErrors = ''Errors'' OR ((SELECT COUNT(*)    
				   FROM eReportRows err     
				   WHERE err.SuperbillUid = vsfb.SuperbillUid    
				   AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
				   AND err.ErrorFlag = ''E'') > 0)) THEN ''Errors'' ELSE '''' END AS ValidationErrors
		  ,(SELECT COUNT(*)    
				   FROM eReportRows err     
				   WHERE err.SuperbillUid = vsfb.SuperbillUid    
				   AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
				   AND err.ErrorFlag = ''E'')    
				   AS Errors
		   ,(SELECT COUNT(*)    
				   FROM eReportRows err    
				   WHERE err.SuperbillUid = vsfb.SuperbillUid    
				   AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
				   AND err.ErrorFlag = ''W'')    
				   AS Warnings,
			SLI.LockUid, SLI.FullName AS LockedByUserName, SLI.HostName AS LockedByHostName,
			SLI.LockDate AS LockedDate, SLI.LockDateStart AS LockedDateStart,
			ARPCCAC.TotalAuthorizationAmount AS ArpTotalAuthorizationAmount,
			VSA.LiabilityBalance, VSA.AssignedLiabilityBalance,
			VSF.LastFollowupModifiedByUid, VSF.LastFollowupModifiedDate, VSF.LastFollowupByUser, VSF.LastFollowupAll, VSF.MaxFollowupModifiedDate,
			vsfb.SuperbillProcedureCount
	  FROM ViewSuperbillFullInsurance vsfb
	  			INNER JOIN Account AC WITH (NOLOCK) ON vsfb.AccountUid = AC.AccountUid
				INNER JOIN AccountResponsibleParty ARP WITH (NOLOCK) ON AC.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid
				LEFT JOIN AccountResponsiblePartyCreditCardAuthorizationCache ARPCCAC WITH (NOLOCK) ON AC.AccountResponsiblePartyUid = ARPCCAC.AccountResponsiblePartyUid
				LEFT JOIN AR_ViewSuperbillAggregate VSA ON vsfb.SuperbillUid = VSA.SuperbillUid
				LEFT JOIN ViewPerson ARPPERSON WITH (NOEXPAND) on ARP.PersonUid = ARPPERSON.PersonUid  
				LEFT JOIN Corporation ARPCORP WITH (NOLOCK) ON ARP.CorporationUid = ARPCORP.CorporationUid 
				LEFT JOIN AR_ViewAccountResponsiblePartyAggregate ARPA ON AC.AccountResponsiblePartyUid = ARPA.AccountResponsiblePartyUid
				LEFT JOIN cteSuperbillLockInfo SLI ON vsfb.SuperbillUid = SLI.SuperbillUid AND SLI.RowNo = 1
				LEFT JOIN ViewSuperbillFollowup VSF ON vsfb.SuperbillUid = VSF.SuperbillUid


















' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewBalanceByRespnsiblePartyandFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'CREATE View [dbo].[ViewBalanceByRespnsiblePartyandFinancialCenter]
AS
SELECT DISTINCT A.AccountResponsiblePartyUid , VSF.FinancialCenterUid   
FROM
	[AR_ViewSuperbillAggregate] VS
INNER JOIN
	[ViewSuperbillFinancialDetails] VSF
ON
	VS.SuperbillUid =VSF.SuperbillUid 
INNER JOIN 
	Superbill  S
ON
	S.SuperbillUid = VS.SuperbillUid
INNER JOIN 
	Account A
ON S.AccountUid = A.AccountUid	
WHERE 
	VS.Liability >0
	
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPayerCreditAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewPayerCreditAggregateSub] WITH SCHEMABINDING 
AS  
	SELECT ld.PayerCreditUid, 
	       SUM(CASE WHEN ld.IsCredit = 0 THEN 0
	                --WHEN apc.DepositUid != ld2.DepositUid THEN 0 -- Refunds will be an credit==0 but will have a different deposit
	                ELSE ld.AMOUNT*-1 END) As Receipt,         
		   SUM(ld.Amount*-1) As ReceiptBalance, 
		   COUNT_BIG(*) AS Count  
	FROM dbo.AR_LedgerDetail ld
			inner join dbo.AR_PayerCredit apc on ld.PayerCreditUid = apc.PayerCreditUid 
			inner join dbo.AR_Ledger arl on ld.LedgerUid = arl.LedgerUid
			--inner join dbo.AR_LedgerDetail ld2 on arl.LedgerUid = ld2.LedgerUid
													--and ld.LedgerDetailUid != ld2.LedgerDetailUid   
	WHERE ld.PayerCreditUid IS NOT NULL  
	GROUP BY ld.PayerCreditUid      

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_ViewPayerCreditAggregateSub_PayerCredtitUid ON AR_ViewPayerCreditAggregateSub(PayerCreditUid)

*/


' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPayerCreditAggregateSub]') AND name = N'PK_ViewPayerCreditAggregateSub_PayerCredtitUid')
CREATE UNIQUE CLUSTERED INDEX [PK_ViewPayerCreditAggregateSub_PayerCredtitUid] ON [dbo].[AR_ViewPayerCreditAggregateSub]
(
	[PayerCreditUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPayerCreditAggregate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewPayerCreditAggregate] 
AS
SELECT PC.PayerCreditUid, 
	ISNULL(VPCAS.Receipt, 0) AS Receipt, 
	ISNULL(VPCAS.ReceiptBalance, 0) AS ReceiptBalance
FROM AR_PayerCredit PC
LEFT JOIN AR_ViewPayerCreditAggregateSub VPCAS WITH (NOEXPAND) ON PC.PayerCreditUid = VPCAS.PayerCreditUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewTransactionDistributionsByPayerCredit]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewTransactionDistributionsByPayerCredit]
AS
	select	art.TransactionUid,
			ldDebit.PayerCreditUid, 
			-- Payments and Charges are not part of a transaction 
			-- Distribution ( 4 types: 1) Insurance Payments 2) Patient Payments 3) Insurance Payer Credits 4) Patient Payer Credits
			SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) AS InsDistribution, -- Used by AR_LedgerDetail_SuperbillAggregate_Insert
            SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) AS PatientDistribution, -- Used by AR_LedgerDetail_SuperbillAggregate_Insert
			--SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as InsPaymentDistributions,  -- Total distributions from an insurance payment(deposit)
            --SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as PtPaymentDistributions, -- Total distributions from an patient payment(deposit)
			SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.PayerCreditUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as InsPayerCreditDistributions,  -- Total distributions from an insurance payer credit
            SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.PayerCreditUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as PtPayerCreditDistributions, -- Total distributions from an patient payer credit
			-- Count of all distributions, adjustments, and transfers in this transaction
			COUNT_BIG(*) AS Count	
	from dbo.AR_Transaction art
			inner join dbo.AR_Ledger arl on art.TransactionUid = arl.TransactionUid
			inner join dbo.AR_LedgerDetail ldDebit on arl.LedgerUid = ldDebit.LedgerUid
													AND ldDebit.IsCredit = 0
			inner join dbo.AR_LedgerDetail ldCredit on arl.LedgerUid = ldCredit.LedgerUid
													AND ldCredit.IsCredit = 1
	group by art.TransactionUid, ldDebit.PayerCreditUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewTransactionPayerCredits]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[AR_ViewTransactionPayerCredits]    
AS  
SELECT  TR.TransactionUid, LD.PayerCreditUid, 
		COUNT_BIG(*) AS Count  
	FROM dbo.AR_Transaction TR        
		INNER JOIN dbo.AR_Ledger L ON TR.TransactionUid = L.TransactionUid          
		INNER JOIN dbo.AR_LedgerDetail LD ON L.LedgerUid = LD.LedgerUid        
	WHERE LD.PayerCreditUid IS NOT NULL        
	GROUP BY TR.TransactionUid, LD.PayerCreditUid             



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewTransactionsByPayerCredit]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewTransactionsByPayerCredit] 
AS
select vtpc.TransactionUid,
	   vtpc.PayerCreditUid as PayerCreditUid,
       art.ReferenceNumber as Name,
       sb.SuperbillUid,
       sb.ExternalID as Superbill,
 	   lss.Name as SuperbillStatus,
       p.PersonUid as PatientUid,
	   dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName , p.LastName, p.Suffix) as Patient,
	   art.CreatedDateTime,
	   -- Current deposit balances
	   vpca.Receipt, 
	   vpca.ReceiptBalance,
	   -- Distributions of deposit in this transaction
	   vtdpc.InsDistribution,
	   vtdpc.InsPayerCreditDistributions,
	   vtdpc.PatientDistribution,
	   vtdpc.PtPayerCreditDistributions,
	   -- Adjustments
	   vta.InsAdjustment,
	   vta.PatientAdjustment,
	   vta.PatientTransfer,
	   vta.InsTransfer,
	   -- Batch
	   gtb.batchUids as BatchUids,
	   gtb.batchNames as BatchNames,
	   gtb.batchStates as BatchState,
	   -- ALL deposits in the transaction
	   gtd.DepositUids as DepositUids,
	   gtd.DepositNames as ReferenceNumbers,
	   -- Superbill Aggregates
	   vsa.Liability as SuperbillLiability,
	   vsa.LiabilityBalance as SuperbillLiabilityBalance,
	   vsa.AssignedLiabilityBalance as SuperbillAssignedLiabilityBalance
from AR_ViewTransactionPayerCredits vtpc with (nolock)
		inner join AR_Transaction art with (nolock) on vtpc.TransactionUid = art.TransactionUid
		inner join Superbill sb with (nolock) on art.SuperbillUid = sb.SuperbillUid
		inner join ListSuperbillStatus lss with (nolock) on sb.SuperbillStatusUid = lss.SuperbillStatusUid
		inner join Person p with (nolock) on sb.PatientUid = p.PersonUid
		inner join AR_ViewSuperbillAggregate vsa with (nolock) on sb.SuperbillUid = vsa.SuperbillUid
		inner join AR_ViewPayerCreditAggregate vpca with (nolock) on vtpc.PayerCreditUid = vpca.PayerCreditUid
		inner join AR_ViewTransactionDistributionsByPayerCredit vtdpc with (nolock) on vtpc.PayerCreditUid = vtdpc.PayerCreditUid
																					and vtpc.TransactionUid = vtdpc.TransactionUid
		inner join AR_ViewTransactionAggregateSub vta with (nolock) on art.TransactionUid = vta.TransactionUid
	    CROSS APPLY dbo.AR_GetTransactionBatches(art.TransactionUid) AS gtb
        CROSS APPLY dbo.AR_GetTransactionDeposits(art.TransactionUid) AS gtd
		



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_SuperbillProcedureBatch]'))
EXEC dbo.sp_executesql @statement = N'


--20160217  kculberth change NOLOCKs to WITH NOLOCKs

CREATE VIEW [dbo].[MDOL_RPT2_VIEW_SuperbillProcedureBatch]   
AS    
SELECT
A.SuperbillProcedureUid,
MIN(A.IsBatchClosed) AS IsBatchClosed
FROM
(
	SELECT LD.SuperbillProcedureUid,CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed
    FROM dbo.AR_LedgerDetail  LD WITH (NOLOCK)         
    INNER JOIN dbo.AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid    
    INNER JOIN dbo.SuperbillProcedure SBP WITH (NOLOCK) ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid 
    LEFT JOIN AR_ViewBatchClosingsLockedClosed VARB WITH (NOLOCK) ON L.ArBatchUid =VARB.ARBatchUid	    
    WHERE NOT LD.SuperbillProcedureUid IS NULL 
)A    
GROUP BY A.SuperbillProcedureUid        
  





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessagesEligibilityRx]'))
EXEC dbo.sp_executesql @statement = N'
CREATE view [dbo].[ViewMessagesEligibilityRx] as
SELECT tob.[TransmissionOutboundUid] AS [Uid],
	   CASE WHEN tob.[TransmissionOutboundUid] IS NOT NULL THEN 4 ELSE 5 END AS [Type],
	   COALESCE (ob.[RequestXML], ob.[MessageXML]) AS [ViewXmlMessage],
	   CONVERT(VARCHAR(MAX),COALESCE (ob.[RequestXML], ob.[MessageXML])) AS [XmlMessageText],
	   COALESCE (ob.[RequestXML], ob.[MessageXML]) AS [XmlMessage],
	   COALESCE (ob.[RequestX12], ob.[MessageSent]) AS [RawMessage],
	   CASE WHEN tob.[Status] IS NOT NULL THEN
					CASE WHEN td.[RequestId] = CAST (tob.[ForeignObjectUid] AS VARCHAR(128)) AND td.[IsError] <> 0 THEN 500
								ELSE tob.[Status]
					END
			WHEN ob.[Processed] = 0 and ob.[Successful] = 0 THEN 0
			WHEN ob.[Processed] <> 0 and (ob.[Successful] = 0 OR (ob.[Successful] <> 0 AND msg.[MessageUid] IS NOT NULL)) THEN 500 ELSE 100
	   END AS [StatusCode],
	   s.[Name] AS [Status], 
	   CONVERT(datetime, null) AS [RetryTime],
	   CONVERT(int, null) AS [RetryMinutes],
	   CONVERT(int, null) AS [MessageControlID],
	   CONVERT(varchar(8000), COALESCE (tob.[LastError], td.[LastError], (CASE WHEN ob.[SendResponse] IS NOT NULL AND ob.[SendResponse] <> '''' THEN ob.[SendResponse] END), msg.[Body])) AS [Error],
	   vmmt.[eRxMessageTypeUid] AS [HL7PartnerMessageUid],
	   COALESCE (tc.[IntegrationPartnerUid], ob.[PharmacyClearinghouseUid]) AS [HL7PartnerUid],
	   CASE WHEN tob.[TransmissionOutboundUid] IS NOT NULL THEN lip.[Name] ELSE lip.[ExternalID] END AS [Name],
	   vmmt.[ExternalID] AS [MessageType], 
	   ob.[LastModifiedDate] AS [LastModifiedDate],
	   ''Send'' as [InOut],
       0 AS Reprocess,
	   vp_Patient.[FullName] AS [Patient],
	   vp_Provider.[FullName] AS [Provider],
	   ss.[Name] AS  [ServiceSite],
	   ''Request date= '''''' + CONVERT (VARCHAR (65), ob.[RequestDate], 101) + ''''''.'' AS [Description],
	   CONVERT(VARCHAR(2), null) AS [Pharmacy],
	   CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [VisitUid],
	   ob.[PatientUid],
	   ob. [ProviderUid],
	   ob.[ServiceSiteUid],
	   CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [PharmacyUid]
FROM [eRxEligibilityOutbound] AS ob WITH(NOLOCK)
    INNER JOIN [Provider] AS p WITH(NOLOCK) ON ob.[ProviderUid] = p.[PersonUid]
    INNER JOIN [Patient] AS pp WITH(NOLOCK) ON ob.[PatientUid] = pp.[PersonUid]
    INNER JOIN [ViewPerson] AS vp_Patient WITH(NOLOCK) ON pp.[PersonUid] = vp_Patient.[PersonUid]
    INNER JOIN [ViewPerson] AS vp_Provider WITH(NOLOCK) ON p.[PersonUid] = vp_Provider.[PersonUid]
    INNER JOIN [TransmissionConfiguration] AS tc WITH(NOLOCK) ON ob.TransmissionConfigurationUid = tc.TransmissionConfigurationUid
	INNER JOIN [ListeRxMessageType] AS vmmt WITH(NOLOCK) ON vmmt.[eRxMessageTypeUid] = ''6B18C334-E4A6-4F82-A831-1AAA6CF6009E''
		AND tc.[TransmissionType] = vmmt.[ExternalID]
    INNER JOIN [TransmissionOutbound] AS tob WITH(NOLOCK) ON vmmt.[ExternalID] = tob.[TransmissionType]
            AND ob.eRxEligibilityOutboundUid = tob.ForeignObjectUid
    OUTER APPLY
    (
            SELECT *
            FROM [TransmissionData] WITH(NOLOCK)
            WHERE [TransmissionType] = tob.[TransmissionType]
                    AND [RequestId] = CAST (tob.[ForeignObjectUid] AS VARCHAR(256))
                    AND [IsError] <> 0
    ) AS td
    OUTER APPLY
    (
            SELECT *
            FROM [MessageeRxEligibility] WITH (NOLOCK)
            WHERE [eRxEligibilityOutboundUid] = ob.[eRxEligibilityOutboundUid]
				AND ob.[Successful] = 0
    ) AS msg
    OUTER APPLY
    (
            SELECT [IntegrationPartnerUid], [Name], [ExternalID]
            FROM [ListIntegrationPartner] WITH(NOLOCK)
            WHERE [IntegrationPartnerUid] IN (
                    tc.[IntegrationPartnerUid],
                    ''118422AA-C165-4A2E-8389-E5B7E89636EA''
            )
    ) AS lip
    LEFT OUTER JOIN [ListServiceSite] AS ss WITH(NOLOCK) ON ob.[ServiceSiteUid] = ss.[ServiceSiteUid]
    LEFT OUTER JOIN [ViewHL7MessageStatus] AS s WITH(NOLOCK) ON (
                                                                    CASE WHEN tob.[Status] IS NOT NULL THEN
                                                                                CASE WHEN td.[RequestId] = CAST (tob.[ForeignObjectUid] AS VARCHAR(128)) AND td.[IsError] <> 0 THEN 500
                                                                                        ELSE tob.[Status]
																				END
																		WHEN ob.[Processed] = 0 and ob.[Successful] = 0 THEN 0
																		WHEN ob.[Processed] <> 0 and (ob.[Successful] = 0 OR (ob.[Successful] <> 0 AND msg.[MessageUid] IS NOT NULL)) THEN 500 ELSE 100
																	END) = s.[HL7MessageStatus]
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_RPT2_PracticeSnapshotReport_Superbill]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[View_RPT2_PracticeSnapshotReport_Superbill] 
AS 
		
		Select 
			   --AR.ARcontextUID,
			   isnull(SP.ExternalID,''Account'') as A3SuperBillID,
			   SP.PatientUID as A3PatientUID,
			   LGP.ProcedureGroupUID,    
			   isnull(LGP.Name,'''') as ProcedureGroup,    
			   LP.ProcedureUID,  
			   isnull(LP.Code,'''') as CPTCode,
			   SBP.Units as ChargeUnits,
			   SBP.Units as AdjustmentUnits,
			   SBP.Units as ReceiptUnits,
			   SBP.Units as RefundUnits,
--			   (Select Max(Ch.GLDate) From Charge Ch JOIN ARContext AR on AR.ARContextUID=Ch.ARContextUID Where AR.SuperBIllUID=SP.SuperBillUID) as GLDate,
				ARB.GLDate,
			   SP.ServiceDateStart,  
			   SP.ServiceDateEnd,
			   LST.ServiceSiteTypeUID,  
			   LST.Name as PlaceOfServiceCode,  
			   LS.ServiceSiteUID,  
			   isnull(LS.Name,'''') as ServiceSite,    
			   isnull(SP.ExternalID,'''') as SuperBillID,
			   SB.RenderingProviderUID,  
		       dbo.UDF_getFormattedPreferredName(SB.RenderingProviderUID) as RenderingProvider,   
		       SB.ClaimingProviderUID as BillingProviderUID,      
		       dbo.UDF_getFormattedPreferredName(SB.ClaimingProviderUID) as BillingProvider,
		       SP.AccountUid,
		       SBP.SuperbillProcedureUid,
			   isnull(VD1.Code,'''') as DiagnosisCode1,
			   isnull(VD2.Code,'''') as DiagnosisCode2,
			   isnull(VD3.Code,'''') as DiagnosisCode3,
			   isnull(VD4.Code,'''') as DiagnosisCode4,
			   isnull(VD5.Code,'''') as DiagnosisCode5,
			   isnull(VD6.Code,'''') as DiagnosisCode6,
			   isnull(VD7.Code,'''') as DiagnosisCode7,
			   isnull(VD8.Code,'''') as DiagnosisCode8,
			   SPB.IsBatchClosed AS IsBatchClosed
		From
			ViewSuperbill SP
		JOIN
			[ViewSuperbillFinancialDetails] SB
		ON
			SP.SuperbillUid =SB.SuperbillUid 
		JOIN
			SuperbillProcedure SBP    
		on    
			SBP.SuperbillUID=SP.SuperbillUID  AND SBP.Inactive = 0
	   JOIN
	        [MDOL_RPT2_VIEW_SuperbillProcedureBatch] SPB
	   ON
		    SBP.SuperbillProcedureUid = SPB.SuperbillProcedureUid			
		LEFT JOIN
			[AR_ViewSuperbillProcedureBatch] VSPB
		ON
			SBP.SuperbillProcedureUid  =VSPB.SuperbillProcedureUid
		LEFT JOIN
			ARBatch ARB
		ON
			ARB.ARBatchUid=VSPB.ARBatchUid
		LEFT JOIN    
			ListServiceSite LS    
		on    
			LS.ServiceSiteUID=SP.SErviceSiteUID  
		LEFT JOIN  
			ListServiceSiteType LST  
		on   
			Ls.ServiceSiteTypeUID = LST.ServiceSiteTypeUID 
		LEFT JOIN
			ListProcedure LP    
		on    
			LP.ProcedureUID=SBP.ProcedureUID    
		LEFT JOIN
			ListProcedureGroup LGP    
		on    
			LGP.ProcedureGroupUID=LP.ProcedureGroupUID 
		LEFT JOIN
			VisitDiagnosis  VD1    
		on    
			VD1.VisitUid=SP.VisitUid AND VD1.DisplayOrder = 1  
		LEFT JOIN
			VisitDiagnosis  VD2    
		on    
			VD2.VisitUid=SP.VisitUid AND VD2.DisplayOrder = 2 
		LEFT JOIN
			VisitDiagnosis  VD3    
		on    
			VD3.VisitUid=SP.VisitUid AND VD3.DisplayOrder = 3 
		LEFT JOIN
			VisitDiagnosis  VD4    
		on    
			VD4.VisitUid=SP.VisitUid AND VD4.DisplayOrder = 4 
					LEFT JOIN
			VisitDiagnosis  VD5    
		on    
			VD5.VisitUid=SP.VisitUid AND VD5.DisplayOrder = 5 
		LEFT JOIN
			VisitDiagnosis  VD6    
		on    
			VD6.VisitUid=SP.VisitUid AND VD6.DisplayOrder = 6 
		LEFT JOIN
			VisitDiagnosis  VD7    
		on    
			VD7.VisitUid=SP.VisitUid AND VD7.DisplayOrder = 7 
		LEFT JOIN
			VisitDiagnosis  VD8    
		on    
			VD8.VisitUid=SP.VisitUid AND VD8.DisplayOrder = 8 


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_StatementLineItem_CHC_Statements]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[MDOL_RPT2_VIEW_StatementLineItem_CHC_Statements]  
AS  
/* Source fOR the line items in the paper and electronic statement.  
 AS of GA5, the paper statement does not use the Header, Comment, AND Subtotal types.  
 gaps have been LEFT in the display ORder fOR adding comment lines at any point.   
 Comments to be mixed in with a certain type should have the same display ORder,  
 e.g., claim filing comments are mixed with payments.  
  
 The primary keys of the biz object view fOR this are ItemUid, SuperbillUid,    
 DisplayOrder, AND CreditSubOrder so make sure this set of four is unique if you   
 update this view.  
  
 Use CreditSubOrder to order items associated with an individual payment OR adjustment  
 credit. Make it less than 2 to precede the payment OR adjustment OR greater than 2  
 to follow it. E.g., a credit statement note follows the credit.  
  
 The intended ORdering for these line items is:  
 ORDER BY RPUid, SuperbillDate asc, SuperbillUid, DisplayOrder asc, ItemDate asc,   
  CreditGroupUid, IsPayment desc, CreditUid, CreditSubOrder asc   
*/  
/*  
 01/24/2008 - Qatalys - Modified to remove GLDate (#13093)  
 05/19/2008 - Qatalys - Modified to include Financial Center  
 08/02/2011 - kbernecker - branched off of ViewStatementLineItem for performance reasons 
 11/15/2011 - kbernecker - remove payment notes (entire "Transfer" section), fixed reference numbers
 7/05/2012 - kbernecker - add payer information
 6/04/2013 - kbernecker - modified to use lastfileddate cte and get insurance plan correctly
 08/12/2013 - kbernecker - fix problem with initial transfers being lost and also get correct insurance payer
 01/28/2014 - kbernecker - fix issue with truly distinct payments and transfers that are being lost because they have the same posting date and reference number. add superbillprocedureuid to criteria.
 01/29/2014 - kbernecker - roll up payments and adjustments to sum them, but not lose the ones that appear to be identical
 09/16/2014 - kbernecker - add more NOLOCKs
 10/08/2014 - kbernecker - use LD.CreatedDateTime instead of ARB.GLDate for payments. Bug 32278.
 10/24/2014 - kbernecker - return ARB.GLDate instead of LD.CreatedDate time for payments. Bug 3323
 20150109 - kculberth - add statement notes from reason codes - bug 33625
 20150421 - kculberth - bug 37045 checking for ClaimDate > ARBatch.GLDate was causing a problem when reference numbers are reused and primary/secondary insurance payers are the same
 20150513 - kculberth - bug 28165 exclude CHC encounter codes found in ChcRelApprovalSetting table
 20160512 - kculberth - fix Bug 44841:Statement reflects incorrect insurance payer filed. retrieve InsurancePlanUid from SuperbillAggregate for Charges
 20160721 - kculberth - back out previous change, order IP.Name by cbd.lastmodifieddate desc instead.
						Fix bugs 44841, 50103, 51092, and 50964.
 20161020 - kculberth - get rid of unnecessary "Comments" by changing the section with type of Comment, using CB.ClaimBatchUid as ItemUid...changed ClaimBatch left join to inner join
 20161028 - kculberth - Bug 52800:Statement not reflecting same balance as account
*/   
--NEW
WITH cteWhoPaidName --Stolen from ViewDeposit
AS
-- Define the CTE query.
(
SELECT d.deposituid,
      ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumber, -- mark as <ND> so can hyperlink on null values
      (CASE WHEN p.PersonUid IS NOT NULL THEN p1.FormattedPreferredName
       WHEN icArp.CorporationUid IS NOT NULL THEN icArp.Name
       WHEN LD.InsurancePayerUid IS NOT NULL THEN ic.Name END) AS WhoPaidName,
       L.EntryType  
FROM Deposit (NOLOCK) d
            INNER JOIN AR_LedgerDetail (NOLOCK) LD ON d.DepositUid = LD.DepositUid
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid
            LEFT OUTER JOIN AR_Ledger (NOLOCK) arlVoid on L.LedgerUid = arlVoid.VoidLedgerUid      -- Checks for voiding entries                  
LEFT JOIN AccountResponsibleParty (NOLOCK) arp on LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid            
            LEFT JOIN Person (NOLOCK) p ON arp.PersonUid = p.PersonUid 
            LEFT JOIN Corporation (NOLOCK) icArp ON arp.CorporationUid = icArp.CorporationUid
            LEFT JOIN Corporation (NOLOCK) ic ON ic.CorporationUid = LD.InsurancePayerUid 
            LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = p.PersonUid              
WHERE (L.EntryType = 0 -- Payment
	   OR L.EntryType = 3) -- Adjustment
       AND  (L.VoidLedgerUid IS NULL AND arlVoid.LedgerUid IS NULL) -- Don''t include reversing(void) entries
       AND LD.IsCredit = 1                                              
       AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits    
),
cteLastFiledDate --
AS
-- Define the CTE query.
(
	SELECT SA.SuperbillUid,SA.LastFiledDate,SA.CurrentInsurancePlanUid
	FROM SuperbillAggregate (NOLOCK) SA
)

SELECT   
 FinancialCenterUid,  
 ItemUid,   
 RPUid,   
 ''Charge'' AS Type,   
 4 AS DisplayOrder,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 NULL AS CreditGroupUid,   
 0 AS IsPayment,   
 NULL AS CreditUid,   
 0 AS CreditSubOrder,   
 '''' AS WhoPaid,   
 Description,   
 Charge,   
 SUM(Insurance) AS Insurance,  
 SUM(Patient) AS Patient,  
 SUM(Amount) AS Amount,  
 --MIN(AGE)  AS Age,  
 age,
 SuperbillProcedureUid,  
 MAX(TotalCharge) TotalCharge,  
 MAX(LastFiledDate) LastFiledDate,  
 '''' AS ReferenceNumber,  
 ReferringProviderName,  
 InsuranacePlan,  
 MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
 1 AS CompleteBatch,
 0 AS DisplayOrder2    
 FROM  
 (  
SELECT   
 LD.FinancialCenterUid,  
 SP.SuperbillProcedureUid AS ItemUid,   
 A.AccountResponsiblePartyUid AS RPUid, 
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName,   
 A.ExternalID AS AccountID,   
 S.ExternalID AS SuperbillID,   
 S.SuperbillUid,   
 S.ServiceDateStart AS SuperbillDate,   
 SP.ProcedureServiceDateStart AS ItemDate,     
 (CASE WHEN (PS.IncludeProcedureCode=1) 
 THEN ISNULL(LP.Code, '''') +ISNULL('' '' + LP.ShortDescription, '''')  
 ELSE ISNULL('' '' + LP.ShortDescription, '''') END) AS Description,   
 COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS Charge,   
 (CASE WHEN LD.LiabilityOwner > 0   THEN LD.Amount ELSE CONVERT(Money, 0) END) AS Insurance,  
 (CASE WHEN LD.LiabilityOwner = 0 THEN LD.Amount ELSE CONVERT(Money, 0) END) AS Patient,  
 ISNULL(LD.Amount,0) AS Amount,  
 --DATEDIFF(DD, (ARB.GLDate), GETUTCDATE())  AS Age, 
 NULL as age, 
 SP.SuperbillProcedureUid,   
 COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS TotalCharge,   
 lfd.LastFiledDate as LastFiledDate,    
 p3.FormattedPreferredName AS ReferringProviderName,
 (SELECT top 1 IP.Name from ClaimBatchDetail (NOLOCK) CBD   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL
		LEFT JOIN InsurancePlan (NOLOCK) IP ON CBD.InsurancePlanUid = IP.InsurancePlanUid   
		where CBD.SuperbillUid = S.SuperbillUid order by cbd.lastmodifieddate desc) as InsuranacePlan,
-- IP.Name as InsuranacePlan,	
 (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) IsSuperbilCompleteBatch,   
 (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch   
FROM
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid AND (L.EntryType=1 OR L.EntryType=4)		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		INNER JOIN ListProcedure (NOLOCK) LP ON SP.ProcedureUid = LP.ProcedureUid  		
		LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation (NOLOCK) C ON IP.InsuranceCarrierUid = C.CorporationUid   
		--LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		--LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
		--			 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = s.ReferringProviderUid   
		left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS  	  	
 WHERE rpsss.superbillstatusuid is null and
	(L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
	and ras.ProcedureUid is null
) A   
GROUP BY   
 FinancialCenterUid,  
 ItemUid,   
 RPUid,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 Description,   
 Charge,   
 SuperbillProcedureUid,  
 ReferringProviderName,  
 InsuranacePlan,
 age     
UNION ALL   
select 
	FinancialCenterUid,  
	ItemUid,  
	RPUid,   
	Type,   
	DisplayOrder,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	MIN(ItemDate) AS ItemDate,   
	CreditGroupUid,  
	IsPayment,   
	CreditUid,   
	2 AS CreditSubOrder,   
	WhoPaid,   
	Description,  
	Charge,   
	SUM(Insurance) AS Insurance,   
	SUM(Patient) AS Patient,  
	SUM(Amount) AS Amount,  
	0 AS Age,  
	NULL AS SuperbillProcedureUid,  
	MAX(TotalCharge) AS TotalCharge,  
	MAX(LastFiledDate) AS LastFiledDate,  
	ReferenceNumber,  
	 ReferringProviderName,  
	'''' as InsuranacePlan,  
	MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
	--CASE WHEN AR.IsClosed =1 OR AR.IsLocked =1 THEN 1 ELSE 0 END   
	1 CompleteBatch, 
	DisplayOrder2 
FROM
(
	SELECT DISTINCT  
		FinancialCenterUid,  
		ItemUid,  
		RPUid,   
		Type,   
		CASE WHEN Type=''Payment'' THEN 5 ELSE 6 END AS DisplayOrder,   
		PatientName,   
		RenderingProviderName,   
		AccountID,   
		SuperbillID,   
		SuperbillUid,   
		SuperbillDate,   
		MIN(ItemDate) AS ItemDate,   
		CreditGroupUid,  
		IsPayment,   
		CreditUid,   
		2 AS CreditSubOrder,   
		WhoPaid,   
		Description,  
		CONVERT(Money, 0) AS Charge,   
		SUM(Insurance) AS Insurance,   
		SUM(Patient) AS Patient,  
		SUM(Amount) AS Amount,  
		0 AS Age,  
		SuperbillProcedureUid,  
		MAX(TotalCharge) AS TotalCharge,  
		MAX(LastFiledDate) AS LastFiledDate,  
		ReferenceNumber,  
		 ReferringProviderName,  
		'''' as InsuranacePlan,  
		MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
		--CASE WHEN AR.IsClosed =1 OR AR.IsLocked =1 THEN 1 ELSE 0 END   
		1 CompleteBatch, 
		DisplayOrder2 
	FROM  
	(  
	 SELECT DISTINCT  
		 LD.FinancialCenterUid,  
		 (CASE WHEN LCT.Name = ''Patient Payment'' THEN D.DepositUid ELSE LD.FinancialCenterUid END) AS ItemUid, 
		 A.AccountResponsiblePartyUid AS RPUid,   
		 (CASE WHEN L.EntryType  = 2 THEN ''Payment'' ELSE ''Adjustment'' END) AS Type,    
		 p1.FormattedPreferredName AS PatientName,   
		 p2.FormattedPreferredName AS RenderingProviderName,  
		 A.ExternalID AS AccountID,   
		 S.ExternalID AS SuperbillID,   
		 S.SuperbillUid,   
		 S.ServiceDateStart AS SuperbillDate,   
		 (ARB.GLDate) AS ItemDate,   
		 LD.FinancialCenterUid  CreditGroupUid,  
		 (CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
		 LD.FinancialCenterUid CreditUid,      
		 WhoPaid.WhoPaidName AS WhoPaid, 
					(CASE WHEN L.EntryType != 2
						  THEN ISNULL(LCT.Name,'''')
						  ELSE
							 (CASE WHEN PS.IncludePaymentReferenceNumber = 1 
							  THEN 
								 ISNULL(LCT.Name,'''') + '' Ref #'' + ISNULL(WhoPaid.ReferenceNumber,''N/A'') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
							  ELSE ISNULL(LCT.Name,'''') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
							  END)
					  END) as Description,
		 (CASE WHEN LD.LiabilityOwner > 0 THEN (LD.Amount) ELSE CONVERT(Money, 0) END) AS Insurance,   
		 (CASE WHEN LD.LiabilityOwner = 0 THEN (LD.Amount) ELSE CONVERT(Money, 0) END) AS Patient,  
		 (ISNULL(LD.Amount, 0)) AS Amount,    
		 LD.LastModifiedDate,
		 LD.SuperbillProcedureUid,  
		 (SP.TotalCharge) AS TotalCharge,  
		 lfd.LastFiledDate AS LastFiledDate,  
		 D.ReferenceNumber,  
		  p3.FormattedPreferredName AS ReferringProviderName,
		 --(dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) AS InsuranacePlan,  
		 ((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) AS IsSuperBilCompleteBatch,  
		 CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END CompleteBatch,
		 CASE    
			  WHEN LCT.IsPayment = 1 THEN 1    
			  WHEN LCT.IsAdjustment = 1 THEN 2    
		  ELSE 3     
		  END AS DisplayOrder2
	 FROM  
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid        
		LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
		INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
		INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid                        
		LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  	
		LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid 
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN AR_Transaction (NOLOCK) T ON L.TransactionUid = T.TransactionUid 
		LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = T.DepositUid            
		LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid   
		LEFT JOIN cteWhoPaidName AS whoPaid ON d.depositUid = WhoPaid.deposituid --and d.referencenumber = WhoPaid.referencenumber
		left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS  	  	
		WHERE rpsss.superbillstatusuid is null and
			(L.EntryType=2 OR L.EntryType=3) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 1 
		and ras.ProcedureUid is null
	) B     
	GROUP BY  
	 FinancialCenterUid,  
	 ItemUid,  
	 RPUid,   
	 Type,   
	 PatientName,   
	 RenderingProviderName,   
	 AccountID,   
	 SuperbillID,   
	 SuperbillUid,   
	 SuperbillDate,  
	 CreditGroupUid,   
	 IsPayment,   
	 CreditUid,   
	 WhoPaid,   
	 Description,  
	 --SuperbillProcedureUid,  
	 ReferenceNumber, 
	 SuperbillProcedureUid, 
	 ReferringProviderName,  
	 DisplayOrder2
	) A
GROUP BY  
 FinancialCenterUid,  
 ItemUid,  
 RPUid,   
 Type,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate, 
 DisplayOrder, 
 CreditGroupUid,   
 IsPayment, 
 CreditUid,   
 WhoPaid,   
 Description,  
 --SuperbillProcedureUid,  
 ReferenceNumber, 
 Charge,
 ReferringProviderName,  
 InsuranacePlan,
 DisplayOrder2
   
UNION ALL  
  
--Claim filing comment can be mixed among the payments, so use the same display ORder  
SELECT   
LD.FinancialCenterUid,  
CB.ClaimBatchUid AS ItemUid,   
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
6 AS DisplayOrder,   
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName, 
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
MAX(CB.ClaimDate) AS ItemDate,   
NULL AS CreditGroupUid,   
0 AS IsPayment,   
NULL AS CreditUid,   
0 AS CreditSubOrder,   
'''' AS WhoPaid,   
(dbo.ARFN_getInsLevelName(CB.InsuranceOrder) + '' claim filed to '' +ISNULL(C.Name,'''')) AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
NULL SuperbillProcedureUid, --CR,  
MAX(SP.TotalCharge) TotalCharge,  
 lfd.LastFiledDate as LastFiledDate,    
'''' AS ReferenceNumber,  
 p3.FormattedPreferredName AS ReferringProviderName,
 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan,
CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END IsSuperBilCompleteBatch,  
CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END CompleteBatch,
 0 AS DisplayOrder2 
FROM  
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
		LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation (NOLOCK) C ON IP.InsuranceCarrierUid = C.CorporationUid   
		LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		INNER JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    --was left join
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = s.ReferringProviderUid   
		left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS 
 WHERE rpsss.superbillstatusuid is null and
	(L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 0  AND (L.EntryType = 1) 
	and ras.ProcedureUid is null
GROUP BY   
 LD.FinancialCenterUid,  
 CB.ClaimBatchUid,   
 A.AccountResponsiblePartyUid,   
 S.PatientUid,   
 LD.RenderingProviderUid,  
 A.ExternalID,  
 S.ExternalID,   
 S.SuperbillUid,   
 S.ServiceDateStart,
 CB.ClaimDate,   
 CB.InsuranceOrder,   
 C.Name,
 lfd.LastFiledDate,    
ARB.IsClosed,      
ARB.IsLocked,
 S.ReferringProviderUid,  
  p1.FormattedPreferredName,
  p2.FormattedPreferredName,
  p3.FormattedPreferredName
UNION ALL   
  
--Statement notes FROM credits. Associated with the payments AND adjustments, so use the same display ORder  
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
SELECT   
LD.FinancialCenterUid,  
LD.LedgerDetailUid AS ItemUid,   
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
CASE WHEN L.EntryType=1 THEN 4
WHEN L.EntryType=2 THEN 5 
WHEN L.EntryType=3 THEN 6
WHEN L.EntryType =4 THEN 7
ELSE 6 END AS DisplayOrder,   
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName,   
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
COALESCE(ARB.GLDate,D.DepositDate,S.ServiceDateStart,NULL) AS ItemDate,      
LD.LedgerDetailUid AS CreditGroupUid,  
(CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
LD.LedgerDetailUid AS CreditUid,  
4 AS CreditSubOrder,   
'''' AS WhoPaid,   
L.StatementNote AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
LD.SuperbillProcedureUid,  
SP.TotalCharge,  
 lfd.LastFiledDate AS LastFiledDate,  
'''' AS ReferenceNumber,  
 p3.FormattedPreferredName AS ReferringProviderName,
 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan,
((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) IsSuperBilCompleteBatch,  
((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) CompleteBatch,
 CASE    
      WHEN LCT.IsPayment = 1 THEN 1    
      WHEN LCT.IsAdjustment = 1 THEN 2    
  ELSE 3     
  END AS DisplayOrder2
FROM 
	AR_LedgerDetail (NOLOCK) LD
	INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid 
	INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid     		
	LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  	
	LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
	INNER JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
				 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid 
	LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 	
	LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = LDOS.DepositUid
	LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid 
	LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = s.ReferringProviderUid 
	left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	CROSS JOIN PracticeSettings (NOLOCK) PS 
WHERE rpsss.superbillstatusuid is null and
 (L.StatementNote is NOT NULL OR L.StatementNote != '''')   
 AND (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
 AND (L.EntryType=2 OR L.EntryType=3 OR L.EntryType=4) AND LD.IsCredit = 1  
 and ras.ProcedureUid is null
 UNION ALL			
--Remark notes from Reason Codes. Associated with procedures, so use the same display Order 
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
select FinancialCenterUid,
NULL as ItemUid,
 RPUid,   
Type,   
 DisplayOrder,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 CreditGroupUid,   
IsPayment,   
CreditUid,   
 CreditSubOrder,   
  WhoPaid,   
 Description,   
 Charge,   
 Insurance,  
 Patient,  
 Amount,  
 --MIN(AGE)  AS Age,  
 age,
 SuperbillProcedureUid,  
 TotalCharge,  
 LastFiledDate,  
 ReferenceNumber,  
 ReferringProviderName,  
 InsuranacePlan,  
 IsSuperBilCompleteBatch,  
 CompleteBatch,
 DisplayOrder2
 from (   
SELECT distinct  
LD.FinancialCenterUid,  
--LD.LedgerDetailUid AS ItemUid,   
NULL as ItemUid,
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
6 AS DisplayOrder,   
p1.FormattedPreferredName AS PatientName,   
NULL AS RenderingProviderName,   
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
SP.ProcedureServiceDateStart AS ItemDate,      
--LD.LedgerDetailUid AS CreditGroupUid,  
--(CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
--LD.LedgerDetailUid AS CreditUid,  
NULL AS CreditGroupUid,  
NULL AS IsPayment,   
NULL AS CreditUid,  
4 AS CreditSubOrder,   
'''' AS WhoPaid,   
adj.StatementNote AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
--LD.SuperbillProcedureUid,  
--SP.TotalCharge AS TotalCharge,  
NULL AS SuperbillProcedureUid,  
CASE WHEN SP.TotalCharge > 0 THEN 99999 ELSE 0 END AS TotalCharge,  
 NULL AS LastFiledDate,  
'''' AS ReferenceNumber,  
NULL AS ReferringProviderName,
NULL AS  InsuranacePlan,
NULL AS IsSuperBilCompleteBatch,  
NULL AS CompleteBatch,
  3  AS DisplayOrder2
FROM Superbill (NOLOCK) S 
	INNER JOIN SuperbillProcedure SP WITH (NOLOCK) ON SP.superbilluid = S.superbilluid
	INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SP.SuperbillProcedureUid = LD.SuperbillProcedureUid
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid   
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	left join cobclaimdetail cob on cob.superbilluid = s.superbilluid
	left join COBLineAdjustments adj on adj.cobclaimdetailuid = cob.cobclaimdetailuid and adj.superbillprocedureuid = sp.superbillprocedureuid and adj.Notes IS NOT NULL
	CROSS JOIN PracticeSettings (NOLOCK) PS 
WHERE rpsss.superbillstatusuid is null and
 (adj.StatementNote is NOT NULL OR adj.StatementNote != '''')  
	and ras.ProcedureUid is null
 ) A




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewTransactionDeposits]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[AR_ViewTransactionDeposits]    
AS
	SELECT  TR.TransactionUid, LD.DepositUid, 
			COUNT_BIG(*) AS Count  
		FROM dbo.AR_Transaction TR        
			INNER JOIN dbo.AR_Ledger L ON TR.TransactionUid = L.TransactionUid          
			INNER JOIN dbo.AR_LedgerDetail LD ON L.LedgerUid = LD.LedgerUid        
		WHERE LD.DepositUid IS not NULL 
				AND (TR.DepositUid IS NULL OR TR.DepositUid != LD.DepositUid)       
		GROUP BY TR.TransactionUid, LD.DepositUid 
	UNION ALL            
		-- Union required since not every transaction has a distribution ( ledgerDetail with depositUid ) but
		-- transaction is still associated with deposit ( i.e. adjustment only transactions )
		SELECT TR.TransactionUid, TR.DepositUid,
			COUNT_BIG(*) AS Count
		FROM dbo.AR_Transaction TR
		WHERE TR.DepositUid IS NOT NULL
		GROUP BY TR.TransactionUid, TR.DepositUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewTransactionDistributionsByDeposit]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewTransactionDistributionsByDeposit]
AS
	select	art.TransactionUid,
			ldDebit.DepositUid, 
			-- Payments and Charges are not part of a transaction 
			-- Distribution ( 4 types: 1) Insurance Payments 2) Patient Payments 3) Insurance Payer Credits 4) Patient Payer Credits
			SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) AS InsDistribution, -- Used by AR_LedgerDetail_SuperbillAggregate_Insert
            SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) AS PatientDistribution, -- Used by AR_LedgerDetail_SuperbillAggregate_Insert
			--SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as InsPaymentDistributions,  -- Total distributions from an insurance payment(deposit)
            --SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as PtPaymentDistributions, -- Total distributions from an patient payment(deposit)
			SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.PayerCreditUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as InsPayerCreditDistributions,  -- Total distributions from an insurance payer credit
            SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.PayerCreditUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as PtPayerCreditDistributions, -- Total distributions from an patient payer credit
			-- Count of all distributions, adjustments, and transfers in this transaction
			COUNT_BIG(*) AS Count	
	from dbo.AR_Transaction art
			inner join dbo.AR_Ledger arl on art.TransactionUid = arl.TransactionUid
			inner join dbo.AR_LedgerDetail ldDebit on arl.LedgerUid = ldDebit.LedgerUid
													AND ldDebit.IsCredit = 0
			inner join dbo.AR_LedgerDetail ldCredit on arl.LedgerUid = ldCredit.LedgerUid
													AND ldCredit.IsCredit = 1
			--inner join dbo.ListCreditType lct on ldDebit.IncomeAccountUid = lct.CreditTypeUid
			--inner join dbo.ListMisc lm on lct.TransactionTypeUid = lm.MiscUid
	group by art.TransactionUid, ldDebit.DepositUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewTransactionsByDeposit]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewTransactionsByDeposit] 
AS
select vtd.TransactionUid,
	   vtd.DepositUid as DepositUid,
       art.ReferenceNumber as Name,
       sb.SuperbillUid,
       sb.ExternalID as Superbill,
       p.PersonUid as PatientUid,
	   dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName , p.LastName, p.Suffix) as Patient,
	   art.CreatedDateTime,
	   -- Current deposit balances
	   vda.Receipt, 
	   vda.ReceiptBalance,
	   -- Distributions of deposit in this transaction
	   vtdd.InsDistribution,
	   vtdd.InsPayerCreditDistributions,
	   vtdd.PatientDistribution,
	   vtdd.PtPayerCreditDistributions,
	   -- Adjustments
	   vta.InsAdjustment,
	   vta.PatientAdjustment,
	   vta.PatientTransfer,
	   vta.InsTransfer,
	   -- Batch
	   gtb.batchUids as BatchUids,
	   gtb.batchNames as BatchNames,
	   gtb.batchStates as BatchState,
	   -- ALL deposits in the transaction
	   gtd.DepositUids as DepositUids,
	   gtd.DepositNames as ReferenceNumbers,
	   -- Superbill Aggregates
	   vsa.Liability as SuperbillLiability,
	   vsa.LiabilityBalance as SuperbillLiabilityBalance,
	   vsa.AssignedLiabilityBalance as SuperbillAssignedLiabilityBalance,
	   lss.Name as SuperbillStatus
	   --''THEEND'' as THEEND
from AR_ViewTransactionDeposits vtd with (nolock)
		inner join AR_Transaction art with (nolock) on vtd.TransactionUid = art.TransactionUid
		inner join Superbill sb with (nolock) on art.SuperbillUid = sb.SuperbillUid
		inner join ListSuperbillStatus lss with (nolock) on sb.SuperbillStatusUid = lss.SuperbillStatusUid
		inner join Person p with (nolock) on sb.PatientUid = p.PersonUid
		inner join AR_ViewSuperbillAggregate vsa with (nolock) on sb.SuperbillUid = vsa.SuperbillUid
		inner join AR_ViewDepositAggregate vda with (nolock) on vtd.DepositUid = vda.DepositUid
		-- AR_ViewTransactionDistributionsByDeposit using left join since a distribution may not be in the transaction
		LEFT OUTER JOIN AR_ViewTransactionDistributionsByDeposit vtdd with (nolock) on vtd.DepositUid = vtdd.DepositUid
																					and vtd.TransactionUid = vtdd.TransactionUid
	    CROSS APPLY dbo.AR_GetTransactionBatches(art.TransactionUid) AS gtb
        CROSS APPLY dbo.AR_GetTransactionDeposits(art.TransactionUid) AS gtd
		CROSS APPLY dbo.AR_GetTransactionAggregate(art.TransactionUid) AS vta





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementsByFinancialCenterSearch]'))
EXEC dbo.sp_executesql @statement = N'





CREATE View [dbo].[ViewStatementsByFinancialCenterSearch]
AS
/*
 	2013/04/22 - kbernecker 20442, 20797, 20804
	2016/02/01 - kculberth 	Task 45999 - Add or change send statement view to look at new responsible party ID "send statement" flag.
*/

		SELECT DISTINCT
			V.FinancialCenterUid, 
			CustomerName as FinancialCenterName, 
			RPUid as AccountResponsiblePartyUid,
			RPName as ResponsiblePartyName,
	 		(CASE WHEN p.PersonUid IS NOT NULL THEN p.LastName 
			ELSE c.Name END) AS LastName, 
			Convert(decimal(20, 2), Balance) as Balance, 
			V.LastStatementDate as LastStatementDate,
			--COALESCE(RARPFC.LastStatementDate,V.LastStatementDate) AS LastStatementDate, 
			V.CycleTrigger AS CycleTrigger,			
			'''' AS SuperBills,
			arp.ExternalID
		FROM ViewStatementResponsiblePartyByFinancialCenter  V
		JOIN [ViewBalanceByRespnsiblePartyandFinancialCenter] V2 ON  V.RPUid=V2.AccountResponsiblePartyUid AND V.FinancialCenterUid =V2.FinancialCenterUid
		LEFT JOIN AccountResponsibleParty (NOLOCK) arp ON arp.AccountResponsiblePartyUid = V.RPUid
		LEFT JOIN ViewAccountResponsiblePartySendStatement ss on ss.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
		LEFT JOIN Person (NOLOCK) p ON p.PersonUid = arp.PersonUid 
		LEFT JOIN Corporation (NOLOCK) c ON c.CorporationUid = arp.CorporationUid 
		WHERE
			Convert(decimal(20, 2), Balance) >= V.StatementMinimumAmount
		AND 
			ss.SendStatement=1







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPromisePayment]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewSuperbillPromisePayment]   
AS  
SELECT	IPPS.InsurancePromiseSuperbillUid, 
		IPP.InsurancePromiseUid,
		IPP.InsurancePayerContactUid,
		IPP.PromiseMade,
		IPP.PromisedBy,
		S.ExternalId AS SuperbillExternalId,
		S.SuperbillUid,
		IPPS.Amount AS PromiseAmount,
		isnull((SELECT SUM(CASE WHEN LD.IsCredit = 1 AND (L.EntryType = 2 OR L.EntryType = 3) THEN LD.AMOUNT ELSE 0 END)
					FROM AR_LedgerDetail LD
					INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
					INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
					WHERE LD.CreatedDateTime > IPP.PromiseMade AND NOT InsurancePlanUid IS NULL
						AND SBP.SuperbillUid=IPPS.SuperbillUid ),0)*-1 AS PaymentAmount,
		-- duplicated both below to break out ... not most efficient by quick fix 
		isnull((SELECT SUM(CASE WHEN LD.IsCredit = 1 AND (L.EntryType = 2) THEN LD.AMOUNT ELSE 0 END)
					FROM AR_LedgerDetail LD
					INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
					INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
					WHERE LD.CreatedDateTime > IPP.PromiseMade AND NOT InsurancePlanUid IS NULL
						AND SBP.SuperbillUid=IPPS.SuperbillUid ),0)*-1 AS PaymentAmountDistribution,
		isnull((SELECT SUM(CASE WHEN LD.IsCredit = 1 AND (L.EntryType = 3) THEN LD.AMOUNT ELSE 0 END)
					FROM AR_LedgerDetail LD
					INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
					INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
					WHERE LD.CreatedDateTime > IPP.PromiseMade AND NOT InsurancePlanUid IS NULL
						AND SBP.SuperbillUid=IPPS.SuperbillUid ),0)*-1 AS PaymentAmountAdjustment
FROM InsurancePayerPromiseSuperbill IPPS
INNER JOIN Superbill S ON IPPS.SuperbillUid = S.SuperbillUid
INNER JOIN InsurancePayerPromise IPP ON IPPS.InsurancePromiseUid = IPP.InsurancePromiseUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillFullInsurancePromise]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewSuperbillFullInsurancePromise]   
AS
SELECT  
	isnull(IPPS.Amount,0) AS PromiseAmount, -- set to 0 if link entries do not exist
	isnull(VSPP.PaymentAmount,0) AS PaymentAmount, -- set to 0 if link entries do not exist
	IPPS.InsurancePromiseUid,
	VSFI.* 
FROM ViewSuperbillFullInsurance VSFI
LEFT JOIN InsurancePayerPromiseSuperbill IPPS ON VSFI.SuperbillUid = IPPS.SuperbillUid
LEFT JOIN ViewSuperbillPromisePayment VSPP ON IPPS.InsurancePromiseSuperbillUid = VSPP.InsurancePromiseSuperbillUid
LEFT JOIN (SELECT * FROM InsurancePayerPromise WHERE IsCompleted = 0) IPP ON IPPS.InsurancePromiseUid = IPP.InsurancePromiseUid
WHERE isnull(IPP.IsCompleted,0) = 0  -- we want to pull superbill record even if link entries do not exist
AND Inactive = 0 AND ARLocked = 0 





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCopay]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[ViewCopay]  
AS  
  
SELECT   
	d.DepositUid,
	d.AppointmentUid,   
	(CASE WHEN d.Void = 1 THEN ''Void'' WHEN d.Credited = 1 THEN ''Allocated'' ELSE ''New'' END) as CopayStatus,   
	d.DepositMacroName as CopayType,   
	d.ReferenceNumber,   
	d.AmountInverse as PaymentAmount,   
	d.WhoPaidPersonUid as PersonUid,   
	d.WhoPaidName as PersonName,   
	d.PaymentTypeUid,  
	d.PaymentTypeName,  
	d.DepositMacroUid,  
	d.DepositMacroName,  
	d.DepositDate as PaymentDate,   
	d.Comment,
	d.ARBatchUid,
	d.ARBatchName,
	d.GLDate,
	Person.PersonUid as PatientUid,
	dbo.UDF_getFormattedName(Person.Prefix, Person.FirstName, Person.MiddleName,Person.LastName, Person.Suffix) as PatientName,
	lss.Name as ServiceSiteName,
	a.ServiceSiteUid,
	ISNULL(LAS.IsCanceledStatus,0)  AS IsCanceledStatus
FROM 
	ViewDeposit D
INNER JOIN
	Appointment A 
on 
	d.AppointmentUid =  a.AppointmentUid
inner join 
	Person 
on 
	Person.PersonUid = a.PatientUid
LEFT OUTER JOIN 
	ListServiceSite lss 
ON 
	a.ServiceSiteUid = lss.ServiceSiteUid
LEFT JOIN 
	ListAppointmentStatus LAS 
ON 
	LAS.AppointmentstatusUid=a.AppointmentstatusUid

WHERE d.AppointmentUid Is Not Null AND d.DepositMacroUid Is Not Null  





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessagesMedicationHx]'))
EXEC dbo.sp_executesql @statement = N'
CREATE view [dbo].[ViewMessagesMedicationHx] as
SELECT tob.[TransmissionOutboundUid] AS [Uid],
       CASE WHEN tob.[TransmissionOutboundUid] IS NOT NULL THEN 6 ELSE 7 END AS [Type],
       COALESCE (ob.[RequestXML], ob.[MessageXML]) AS [ViewXmlMessage],
       CONVERT(VARCHAR(MAX),COALESCE (ob.[RequestXML], ob.[MessageXML])) AS [XmlMessageText],
       COALESCE (ob.[RequestXML], ob.[MessageXML]) AS [XmlMessage],
       COALESCE (ob.[RequestNCPDP], ob.[MessageSent]) AS [RawMessage],
       CASE WHEN tob.[Status] IS NOT NULL THEN
                    CASE WHEN td.[RequestId] = CAST (tob.[ForeignObjectUid] AS VARCHAR(128)) AND td.[IsError] <> 0 THEN 500
                                ELSE tob.[Status]
                    END
            WHEN ob.[Processed] = 0 and ob.[Successful] = 0 THEN 0
            WHEN ob.[Processed] <> 0 and (ob.[Successful] = 0 OR (ob.[Successful] <> 0 AND msg.[MessageUid] IS NOT NULL)) THEN 500 ELSE 100
       END AS [StatusCode],
       s.[Name] AS [Status], 
       CONVERT(datetime, null) AS [RetryTime],
       CONVERT(int, null) AS [RetryMinutes],
       CONVERT(int, null) AS [MessageControlID],
       CONVERT(varchar(8000), COALESCE (tob.[LastError], td.[LastError], (CASE WHEN ob.[SendResponse] IS NOT NULL AND ob.[SendResponse] <> '''' THEN ob.[SendResponse] END), msg.[Body])) AS [Error],
       vmmt.[eRxMessageTypeUid] AS [HL7PartnerMessageUid],
       COALESCE (tc.[IntegrationPartnerUid], ob.[PharmacyClearinghouseUid]) AS [HL7PartnerUid],
       CASE WHEN tob.[TransmissionOutboundUid] IS NOT NULL THEN lip.[Name] ELSE lip.[ExternalID] END AS [Name],
       vmmt.[ExternalID] AS [MessageType], 
       ob.[LastModifiedDate] AS [LastModifiedDate],
       ''Send'' as [InOut],
       0 AS Reprocess,
       vp_Patient.[FullName] AS[Patient],
       vp_Provider.[FullName] AS [Provider],
       ss.[Name] AS  [ServiceSite],
       ''eMedHxSource='''''' +  ob.[eMedHxSource] + '''''', Request date= '''''' + CONVERT (VARCHAR (65), ob.[RequestDateFrom], 101) +
       ''''''-'''''' + CONVERT (VARCHAR (65), ob.[RequestDateTo], 101) + ''''''.'' AS [Description],
       CONVERT(VARCHAR(2), null) AS [Pharmacy],
       CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [VisitUid],
       ob.[PatientUid],
       ob. [ProviderUid],
       ob.[ServiceSiteUid],
       CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [PharmacyUid]
FROM [eRxMedicationHistoryOutbound] AS ob WITH(NOLOCK)
    INNER JOIN [Provider] AS p WITH(NOLOCK) ON ob.[ProviderUid] = p.[PersonUid]
    INNER JOIN [Patient] AS pp WITH(NOLOCK) ON ob.[PatientUid] = pp.[PersonUid]
    INNER JOIN [ViewPerson] AS vp_Patient WITH(NOLOCK) ON pp.[PersonUid] = vp_Patient.[PersonUid]
    INNER JOIN [ViewPerson] AS vp_Provider WITH(NOLOCK) ON p.[PersonUid] = vp_Provider.[PersonUid]
    INNER JOIN [TransmissionConfiguration] AS tc WITH(NOLOCK) ON ob.[TransmissionConfigurationUid] = tc.[TransmissionConfigurationUid]
	INNER JOIN [ListeRxMessageType] AS vmmt WITH(NOLOCK) ON vmmt.[eRxMessageTypeUid] = ''90DB44EE-ADEA-427C-9450-B418F8577ADE''
		AND tc.[TransmissionType] = vmmt.[ExternalID]
    INNER JOIN [TransmissionOutbound] AS tob WITH(NOLOCK) ON vmmt.[ExternalID] = tob.[TransmissionType]
            AND ob.[eRxMedicationHistoryOutboundUid] = tob.[ForeignObjectUid]
    OUTER APPLY
    (
        SELECT *
        FROM [TransmissionData] WITH(NOLOCK)
        WHERE [TransmissionType] = tob.[TransmissionType]
                AND [RequestId] = CAST (tob.[ForeignObjectUid] AS VARCHAR(256))
                AND [IsError] <> 0
    ) AS td
    OUTER APPLY
    (
        SELECT *
		FROM [MessageeRxMedicationHistory] WITH (NOLOCK)
        WHERE [eRxMedicationHistoryOutboundUid] = ob.eRxMedicationHistoryOutboundUid
			AND ob.[Successful] = 0
    ) AS msg
    OUTER APPLY
    (
        SELECT [IntegrationPartnerUid], [Name], [ExternalID]
        FROM [ListIntegrationPartner] WITH(NOLOCK)
        WHERE [IntegrationPartnerUid] IN (
                ob.[PharmacyClearinghouseUid],
                tc.[IntegrationPartnerUid],
                ''118422AA-C165-4A2E-8389-E5B7E89636EA''
        )
    ) AS lip
    LEFT OUTER JOIN [ListServiceSite] AS ss WITH(NOLOCK) ON ob.[ServiceSiteUid] = ss.[ServiceSiteUid]
    LEFT OUTER JOIN [ViewHL7MessageStatus] AS s WITH(NOLOCK) ON (
																	CASE WHEN tob.[Status] IS NOT NULL THEN
																				CASE WHEN td.[RequestId] = CAST (tob.[ForeignObjectUid] AS VARCHAR(128)) AND td.[IsError] <> 0 THEN 500
																							ELSE tob.[Status]
																				END
																		WHEN ob.[Processed] = 0 and ob.[Successful] = 0 THEN 0
																		WHEN ob.[Processed] <> 0 and (ob.[Successful] = 0 OR (ob.[Successful] <> 0 AND msg.[MessageUid] IS NOT NULL)) THEN 500 ELSE 100
																	END) = s.[HL7MessageStatus]
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_InsuranceProductivity]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[View_InsuranceProductivity]  
AS 
SELECT 
CorporationUid,
Col1,
Col2,
CASE WHEN SUBSTRING(Col1,1,1) not between ''A'' and ''Z'' THEN ''A'' ELSE  SUBSTRING(Col1,1,1) END AS ColCharFrom,
CASE WHEN SUBSTRING(Col1,1,1) not between ''A'' and ''Z'' THEN ''A'' ELSE  SUBSTRING(Col1,1,1) END As ColCharTo,  
ProcedureUID,
Col3,
ShortDescription,
SUM(Units) AS Units,
MIN(GLDate) AS GLDate ,
SUM(TotalCharge) AS TotalCharge,   
SUM(Charge) AS Charge,
SUM(Payment) AS Payment,
SUM(Adjustment) AS Adjustment,  
ClaimingProviderUid,
RenderingProviderUid,
ServiceSiteUid,
FinancialCenterUid,
SuperbillProcedureUid,
ProcedureServiceDateEnd,
AccountTypeUid,
AccountType,
Modifier AS Modifier,
MIN(IsBatchClosed) AS IsBatchClosed
   --CASE WHEN dbo.AR_Ledger.EntryType=2 AND dbo.AR_LedgerDetail.IsCredit=1 THEN -1 * ISNULL(dbo.AR_LedgerDetail.Amount, 0) ELSE 0 END AS Payment,  
   --CASE WHEN dbo.AR_Ledger.EntryType=3 AND dbo.AR_LedgerDetail.IsCredit=1 THEN -1 * ISNULL(dbo.AR_LedgerDetail.Amount, 0) ELSE 0 END AS Adjustment,  
   --  dbo.AR_LedgerDetail.ClaimingProviderUid,   
   --  dbo.AR_LedgerDetail.RenderingProviderUid,   
   --  dbo.AR_LedgerDetail.ServiceSiteUid,   
   --  dbo.AR_LedgerDetail.FinancialCenterUid,   
   --  dbo.AR_LedgerDetail.SuperbillProcedureUid,   
   --  dbo.SuperbillProcedure.ProcedureServiceDateEnd,  
   --  dbo.ListAccountType.AccountTypeUid,  
   --  dbo.ListAccountType.Name AS AccountType, 
   --  ISNULL(LPM.Modifier,'''') As Modifier,
   --  CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed
FROM
(
 SELECT       
  dbo.Corporation.CorporationUid,   
  ISNULL(dbo.Corporation.Name, '''') AS Col1,   
  ISNULL(dbo.InsurancePlan.Name, '''') AS Col2, 
  CASE WHEN SUBSTRING(dbo.Corporation.Name,1,1) not between ''A'' and ''Z'' THEN ''A'' ELSE  SUBSTRING(dbo.Corporation.Name,1,1) END AS ColCharFrom,
  CASE WHEN SUBSTRING(dbo.Corporation.Name,1,1) not between ''A'' and ''Z'' THEN ''A'' ELSE  SUBSTRING(dbo.Corporation.Name,1,1) END As ColCharTo,  
  dbo.ListProcedure.ProcedureUid AS ProcedureUID,   
  dbo.ListProcedure.Code AS Col3,   
  dbo.ListProcedure.ShortDescription AS ShortDescription,  
  CASE WHEN dbo.AR_Ledger.EntryType=1 THEN
	  CASE WHEN  dbo.AR_LedgerDetail.Amount < 0 THEN -1 * dbo.SuperbillProcedure.Units
	  ELSE  dbo.SuperbillProcedure.Units END
  ELSE	
	  0
  END AS Units,   
  -- VSB.MinPostingDate AS GLDate,  
   ARBatch.gldate AS GLDate,
  CASE WHEN dbo.AR_Ledger.EntryType=1 THEN 
	CASE WHEN  dbo.AR_LedgerDetail.Amount < 0 THEN -1 * dbo.SuperbillProcedure.TotalCharge
    ELSE dbo.SuperbillProcedure.TotalCharge 
    END
  ELSE
	0
   END AS TotalCharge,   
   CASE WHEN dbo.AR_Ledger.EntryType=1 OR dbo.AR_Ledger.EntryType=4 THEN ISNULL(dbo.AR_LedgerDetail.Amount, 0) ELSE 0 END AS Charge,  
   CASE WHEN dbo.AR_Ledger.EntryType=2 AND dbo.AR_LedgerDetail.IsCredit=1 THEN -1 * ISNULL(dbo.AR_LedgerDetail.Amount, 0) ELSE 0 END AS Payment,  
   CASE WHEN dbo.AR_Ledger.EntryType=3 AND dbo.AR_LedgerDetail.IsCredit=1 THEN -1 * ISNULL(dbo.AR_LedgerDetail.Amount, 0) ELSE 0 END AS Adjustment,  
     dbo.AR_LedgerDetail.ClaimingProviderUid,   
     dbo.AR_LedgerDetail.RenderingProviderUid,   
     dbo.AR_LedgerDetail.ServiceSiteUid,   
     dbo.AR_LedgerDetail.FinancialCenterUid,   
     dbo.AR_LedgerDetail.SuperbillProcedureUid,   
     dbo.SuperbillProcedure.ProcedureServiceDateEnd,  
     dbo.ListAccountType.AccountTypeUid,  
     dbo.ListAccountType.Name AS AccountType, 
     ISNULL(LPM.Modifier,'''') As Modifier,
     CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed  
  FROM         dbo.AR_Ledger INNER JOIN  
        dbo.AR_LedgerDetail ON dbo.AR_Ledger.LedgerUid = dbo.AR_LedgerDetail.LedgerUid
          INNER JOIN  
        dbo.ARBatch  ON dbo.AR_Ledger.ARBatchUid = dbo.ARBatch.ARBatchUid 
        INNER JOIN  
        AR_ViewBatchClosingsLockedClosed VARB ON dbo.AR_Ledger.ArBatchUid =VARB.ARBatchUid
        INNER JOIN  
dbo.SuperbillProcedure ON dbo.AR_LedgerDetail.SuperbillProcedureUid = dbo.SuperbillProcedure.SuperbillProcedureUid  AND dbo.SuperbillProcedure.Inactive = 0   
        
        --LEFT JOIN  
        --dbo.ViewSuperbillProcedure_IsVoid VSPVOID ON VSPVOID.SuperbillProcedureUid=dbo.SuperbillProcedure.SuperbillProcedureUid   
         INNER JOIN  
        dbo.Superbill  ON dbo.Superbill.SuperbillUid  = dbo.SuperbillProcedure.SuperbillUid
        --INNER JOIN
        -- AR_ViewSuperbillBatches VSB On dbo.Superbill.SuperbillUid=VSB.SuperbillUid
         --INNER JOIN
         --ViewSuperbillProcedure VSB On SuperbillProcedure.SuperbillProcedureUid=VSB.SuperbillProcedureUid
         LEFT OUTER JOIN  
        dbo.InsurancePlan ON dbo.InsurancePlan.InsurancePlanUid = dbo.AR_LedgerDetail.InsurancePlanUid 
        LEFT OUTER JOIN  
        dbo.Corporation ON dbo.Corporation.CorporationUid = dbo.InsurancePlan.InsuranceCarrierUid 
        LEFT OUTER JOIN  
        dbo.InsuranceCarrier ON dbo.InsuranceCarrier.CorporationUid =dbo.Corporation.CorporationUid
         LEFT OUTER JOIN  
        dbo.ListAccountType ON (dbo.InsurancePlan.AccountTypeUid = dbo.ListAccountType.AccountTypeUid 
        AND InsurancePlan.UseInsuranceCarrierAccountType=0) OR (dbo.InsuranceCarrier.AccountTypeUid = dbo.ListAccountType.AccountTypeUid
         AND InsurancePlan.UseInsuranceCarrierAccountType=1) 
			LEFT OUTER JOIN  
        dbo.ListProcedure ON dbo.SuperbillProcedure.ProcedureUid = dbo.ListProcedure.ProcedureUid   
        LEFT JOIN
           dbo.SuperbillProcedureModifier SPM
        ON
           dbo.SuperbillProcedure.SuperbillProcedureUid=SPM.SuperbillProcedureUid AND SPM.DisplayOrder=1
        LEFT JOIN
           dbo.ListProcedureModifier LPM
        ON
           SPM.ProcedureModifierUid=LPM.ProcedureModifierUid  
        WHERE (dbo.AR_LedgerDetail.LiabilityOwner > 0) 
         --AND
         --dbo.AR_Ledger.EntryType<>4
         --AND (AR_LedgerDetail.amount<>0)
        )A
  GROUP BY  
   --CorporationUid,Col1,Col2,Col3,SuperBillProcedureUID,ProcedureUID,ShortDescription,ClaimingProviderUid, RenderingProviderUid,ServiceSiteUid,FinancialCenterUid,AccountTypeUid,AccountType,TotalCharge,ProcedureServiceDateEnd      
CorporationUid,Col1,Col2,Col3,ProcedureUID,ShortDescription,ClaimingProviderUid, RenderingProviderUid,ServiceSiteUid,FinancialCenterUid,SuperBillProcedureUID,ProcedureServiceDateEnd,AccountTypeUid,AccountType,Modifier


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewAccountPeriodEligibilityDate]'))
EXEC dbo.sp_executesql @statement = N'

-- DSW 08/30/2016 50228-Eligibility issues with Medicare for HMO payers
--        Add OtherPayerTypeCode, PlanMemberID, eligibilitySubscriberID

CREATE VIEW	[dbo].[ViewAccountPeriodEligibilityDate] AS
	SELECT		ap.AccountPeriodUid, a.AccountUid, a.PersonUid AS PatientUid,				
				pip.EligibilityVerificationDateTime as EligibilityDate,
				pip.EligibilityStatusUid, pip.EligibilityResponseXML,
				CAST(CASE			WHEN es.EligibilityStatusUid IS NULL AND pip.EligibilityTransmissionInProcess = 1 THEN 0 /* Downloading */
									WHEN es.EligibilityStatusUid = ''A9D72B1E-42FC-495E-AE92-74E6C68FFA6B'' THEN 3 /* Error */
									WHEN es.EligibilityStatusUid IS NULL AND pip.EligibilityTransmissionStatus = ''Eligibility Verification Failed'' THEN 3 /* Error */
									WHEN es.EligibilityStatusUid IS NULL AND pip.EligibilityResponseXML.value(''(/error)[1]'', ''VARCHAR(MAX)'') IS NOT NULL THEN 3 /* Error */
									WHEN pip.EligibilityExpirationDate < GETUTCDATE() THEN 5 /* Insurance Expired */
									WHEN es.ActiveCoverage = 1 THEN 1 /* Active Coverage */
									WHEN es.ActiveCoverage = 0 THEN 2 /* Inactive Coverage */									
									WHEN pip.EligibilityTransmissionStatus IS NULL THEN NULL /* Expired OR Never Done*/
									ELSE 4 END /* Unknown */ AS SMALLINT) AS EligibilityStatus,
				-- EB - Subscriber Eligibility or Benefit Information, Loop 2110C ( 50228, 2704 )
				(   
					coalesce
					(
						--   EB01, Other or Additional Payer == R
						--   EB03, Health Benefit Plan Coverage == 30  
						(
						select top 1 o.value(''InsuranceTypeCode[1]'', ''varchar(2)'')  
									from pip.EligibilityResponseXML.nodes(''//Loop2110/EligibilityorBenefit'') as EB(o)
									where o.value(''EligibilityorBenefitInformation[1]'', ''varchar(2)'') = ''R''
										and o.value(''ServiceTypeCode[1]'', ''varchar(2)'') = ''30''
						), -- coalesce choice 1
						--   EB01, Contact Following Entity for Eligibility or Benefit Information == U
						--   EB03, Health Benefit Plan Coverage == 30  
						(
						select top 1 o.value(''InsuranceTypeCode[1]'', ''varchar(2)'')  
									from pip.EligibilityResponseXML.nodes(''//Loop2110/EligibilityorBenefit'') as EB(o)
									where o.value(''EligibilityorBenefitInformation[1]'', ''varchar(2)'') = ''U''
										and o.value(''ServiceTypeCode[1]'', ''varchar(2)'') = ''30''
						), -- coalesce choice 2
						NULL  -- last coalesc choice
					)  -- end of coalesce
				) as OtherPayerTypeCode,
				pip.PlanMemberID,	-- PRM planMemberID ( 50228 )
				-- NM1 - Subscriber Name, Loop 2100C (50228 )
				--   NM101, IL == Insured or Subscriber
				--   NM108, MI == Member Identification Number
				--   NM109, Identification Code, Subscriber Primary Identifier
				( select s.value(''IdentificationCode[1]'', ''varchar(80)'') 
				  from pip.EligibilityResponseXML.nodes(''//Loop2100/Subscriber'') as Subscriber(s)
				  where s.value(''EntityIdentifierCode[1]'', ''varchar(2)'') = ''IL''
					  and s.value(''IdentificationCodeQualifier[1]'', ''varchar(2)'') = ''MI'') AS eligibilitySubscriberID
	FROM		Account a INNER JOIN AccountPeriod ap ON a.AccountUid = ap.AccountUid
				INNER JOIN AccountInsurance ai ON ap.AccountPeriodUid = ai.AccountPeriodUid AND ai.DisplayOrder = 1
				INNER JOIN PersonInsurancePlan pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
				LEFT JOIN ListEligibilityStatus es ON pip.EligibilityStatusUid = es.EligibilityStatusUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientCollectionHistory]'))
EXEC dbo.sp_executesql @statement = N'

/*
	Moved from ViewPatientCollectionHistory.cs
	    public static string COLLECTION_ALERT_NOT_ALERTABLE = string.Empty;
        public static string COLLECTION_ALERT_CLEARED = "Cleared";
        public static string COLLECTION_ALERT_EXPIRED = "Expired";
        public static string COLLECTION_ALERT_ALERTED = "Alerted";
*/

CREATE VIEW [dbo].[ViewPatientCollectionHistory]
AS
SELECT     ch.CollectionHistoryUid, ch.AccountResponsiblePartyUid, dbo.UDF_getFormattedName('''', arpp.FirstName, arpp.MiddleName, arpp.LastName, '''') 
                      AS AccountResponsiblePartyName, ch.InitialCollectionStatusUid, ISNULL(ics.Name, ''N/A'') AS InitialCollectionStatusName, 
                      ch.InitialCollectionStatusLevelUid, ISNULL(icsl.Name, ''N/A'') AS InitialCollectionStatusLevelName, ch.NewCollectionStatusUid, ISNULL(ncs.Name, ''N/A'') 
                      AS NewCollectionStatusName, ch.NewCollectionStatusLevelUid, ISNULL(ncsl.Name, ''N/A'') AS NewCollectionStatusLevelName, ch.CreatedDateTime, ch.Reason, 
                      ch.Notes, ncs.AlertDays AS NewCollectionStatusAlertDays, ch.DisableAlert,
					  CASE WHEN ISNULL(ncs.AlertDays, 0) = 0 THEN ''''
						WHEN (ch.DisableAlert = 1) THEN ''Cleared''
						WHEN (ncs.AlertDays < 0) THEN ''Alerted''  -- forever alerted
						WHEN (DATEADD(d, ISNULL(ncs.AlertDays, 0), ch.CreatedDateTime) < GETUTCDATE()) THEN ''Expired''
						ELSE ''Alerted''
					  END AS CollectionAlert
FROM         dbo.CollectionHistory AS ch INNER JOIN
                      dbo.AccountResponsibleParty AS arp ON ch.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid LEFT OUTER JOIN
                      dbo.Person AS arpp ON arp.PersonUid = arpp.PersonUid LEFT OUTER JOIN
                      dbo.ListCollectionStatus AS ics ON ch.InitialCollectionStatusUid = ics.CollectionStatusUid LEFT OUTER JOIN
                      dbo.ListCollectionStatus AS ncs ON ch.NewCollectionStatusUid = ncs.CollectionStatusUid LEFT OUTER JOIN
                      dbo.CollectionStatusLevel AS icsl ON ch.InitialCollectionStatusLevelUid = icsl.CollectionStatusLevelUid LEFT OUTER JOIN
                      dbo.CollectionStatusLevel AS ncsl ON ch.NewCollectionStatusLevelUid = ncsl.CollectionStatusLevelUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewAppointment]'))
EXEC dbo.sp_executesql @statement = N'


-- DSW 09/09/2016 50228-Eligibility issues with Medicare for HMO payers
--        Add OtherPayerTypeCode, PlanMemberID, eligibilitySubscriberID

CREATE VIEW [dbo].[ViewAppointment] AS
SELECT  a.AppointmentUid, a.AppointmentTypeUid, a.AppointmentStatusUid, a.CalendarUid, 
                     c.Name AS Calendar, c.TimeZone, a.ProviderUid, 
                     PNS.FormattedInternalName AS Provider,
                     a.ServiceSiteUid, 
                     a.PatientUid, a.StartDateTime, a.EndDateTime, per.LastName + '', '' + per.FirstName AS FullName, 
            per.Birthdate, pat.MedicalRecordNumber, a.Reason, 
            CASE WHEN NOT a.AppointmentUid IS NULL THEN Phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') ELSE NULL END AS PhoneNumber, 
            per.Address1, 
                     CASE
                           WHEN (PPS.Address1_Address1 IS NOT NULL AND LEN(RTRIM(PPS.Address1_Address1)) > 0)
                                         OR 
                                         (PPS.Address1_Address2 IS NOT NULL AND LEN(RTRIM(PPS.Address1_Address2)) > 0)THEN
                                  RTRIM(ISNULL(PPS.Address1_Address1, ''''))
                                  + 
                                  CASE
                                         WHEN PPS.Address1_Address1 IS NULL
                                                       OR LEN(RTRIM(PPS.Address1_Address1)) = 0 THEN
                                                RTRIM(PPS.Address1_Address2)
                                         WHEN PPS.Address1_Address2 IS NULL
                                                       OR LEN(RTRIM(PPS.Address1_Address2)) = 0 THEN
                                                ''''
                                         ELSE
                                                '', '' + RTRIM(PPS.Address1_Address2)
                                  END
                                  + CHAR(13)
                           ELSE
                                  ''''
                     END
                     + ISNULL(PPS.Address1_City,'''') 
                     + '' '' + ISNULL(PPS.Address1_State,'''') 
                     + ''  '' + ISNULL(PPS.Address1_Zip,'''') 
                     AS AddressString,
            
                     per.Phone1, per.Phone2,
            per.LastName + '', '' + per.FirstName + ''('' + CONVERT(varchar(20), a.StartDateTime, 120) + '')'' AS Name, 
            a.CallConfirmStatusUid, astat.Color AS ApptStatusColor, at.Color AS ApptTypeColor, 
            a.CheckinDateTime, a.DischargeDateTime, 0 AS Inactive, astat.ShowOnSchedule, astat.ShowOnDesktop, a.CreatedDateTime,
            at.Name AS AppointmentTypeName,
            astat.Name AS AppointmentStatusName,
            a.AccountUid,
            aped.EligibilityStatus,
                     CONVERT(BIT, 
                           CASE WHEN (EXISTS(SELECT UseThirdPartyPM FROM PracticeSettings WHERE UseThirdPartyPM = 0) AND -- bug 39680
                                  (ARP_AG.LiabilityBalance - ARP_AG.AssignedLiabilityBalance) > 0) THEN 1 ELSE 0 END) AS HasArpBalance,
                     CONVERT(BIT, CASE WHEN (SELECT COUNT(*) FROM Visit v WHERE v.AppointmentUid = a.AppointmentUid AND v.IsCompleted = 1) > 0 THEN 1 ELSE 0 END) AS isCommitted,
                     CONVERT(BIT, CASE WHEN (SELECT COUNT(*) FROM Visit v WHERE v.AppointmentUid = a.AppointmentUid) > 0 THEN 1 ELSE 0 END) AS AssociatedWithVisit,
                     a.ScheduleType,
                     CONVERT(BIT, CASE WHEN (SELECT COUNT(*) FROM RelGroupAppointmentPatient g LEFT JOIN Visit v ON v.AppointmentUid = g.AppointmentUid AND v.PatientUid = g.PatientUid WHERE g.AppointmentUid = a.AppointmentUid AND v.VisitUid IS NULL) > 0 THEN 1 ELSE 0 END) AS CanCreateGroupVisit,
             aped.OtherPayerTypeCode,
			 aped.PlanMemberID,
			 aped.eligibilitySubscriberID,
			 lg.Name AS Gender,
			 LCS.CollectionStatusUid,
			 LCS.Name AS CollectionStatusName,
			 CAST(CASE WHEN EXISTS(SELECT * FROM ViewPatientCollectionHistory WHERE AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid AND CollectionAlert = ''Alerted'') THEN 1 ELSE 0 END AS BIT) AS CollectionAlerted
FROM        Appointment a 
          LEFT JOIN Provider PR ON A.ProviderUid = PR.PersonUid -- filter out for providers only
                     LEFT JOIN ViewPerson PNS WITH (NOEXPAND) ON PR.PersonUid = PNS.PersonUid
                     LEFT JOIN ListCalendar c ON a.CalendarUid = c.CalendarUid 
                     LEFT JOIN ListAppointmentType at ON a.AppointmentTypeUid = at.AppointmentTypeUid 
                     LEFT JOIN ListAppointmentStatus astat ON a.AppointmentStatusUid = astat.AppointmentStatusUid 
                     LEFT JOIN Patient pat ON a.PatientUid = pat.PersonUid 
                     LEFT JOIN Person per ON pat.PersonUid = per.PersonUid
                     LEFT JOIN ViewPerson PPS WITH (NOEXPAND) ON per.PersonUid = PPS.PersonUid
					 LEFT JOIN ListGender lg ON per.GenderUid = lg.GenderUid
                     LEFT JOIN ViewAccountPeriodEligibilityDate aped ON aped.AccountPeriodUid = (SELECT TOP 1 ap.AccountPeriodUid
                                                FROM AccountPeriod ap -- Replaces GetAccountPeriod
                                                WHERE ap.AccountUid = a.AccountUid AND
                                                       (ap.EffectiveDate <= dbo.ConvertTimeByTimezone(a.StartDateTime, ISNULL(c.TimeZone, ''local'')) OR ap.EffectiveDate IS NULL) AND
                                                       (ap.ExpirationDate > dbo.ConvertTimeByTimezone(a.StartDateTime, ISNULL(c.TimeZone, ''local'')) OR ap.ExpirationDate IS NULL))
                     LEFT JOIN Account AC WITH (NOLOCK) ON a.AccountUid = AC.AccountUid
                     LEFT JOIN AR_ViewAccountResponsiblePartyAggregate ARP_AG ON AC.AccountResponsiblePartyUid = ARP_AG.AccountResponsiblePartyUid
                     LEFT JOIN AccountResponsibleParty ARP ON AC.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid
                     LEFT JOIN ListCollectionStatus LCS with (NOLOCK) ON ARP.CollectionStatusUid = LCS.CollectionStatusUid








' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HL7PartnerMessageView]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[HL7PartnerMessageView]
AS
SELECT     pm.HL7PartnerMessageUid, pm.HL7PartnerUid, (p.Name + ''/'' + ISNULL(pm.MessageType,'''') + ISNULL(pm.MessageEvent,'''')) as Name, 
			pm.Notes, pm.Inactive, pm.MessageType, pm.MessageEvent, pm.UserDefined
FROM         dbo.HL7PartnerMessage AS pm INNER JOIN
                      dbo.HL7Partner AS p ON pm.HL7PartnerUid = p.HL7PartnerUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewIntegrationPartnerMessageType]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewIntegrationPartnerMessageType] AS
SELECT	[HL7PartnerMessageUid] AS [IntegrationPartnerMessageUid],
		[HL7PartnerUid] AS [IntegrationPartnerUid],
		[Name], 
		[Notes],
		[Inactive],
		[MessageType],
		[MessageEvent],
		[UserDefined],
		NULL AS [ExternalID]
FROM [HL7PartnerMessageView] AS pm WITH(NOLOCK)

UNION -- ePrescribe message
SELECT lmt.[eRxMessageTypeUid] AS [IntegrationPartnerMessageUid],
	tc.[IntegrationPartnerUid],
	lip.[Name] + ''/'' + lmt.[Name] AS [Name],
	CAST (lip.[Notes] AS [varchar](max)) AS [Notes],
	lip.[Inactive],
	lmt.[ExternalID] AS  MessageType,
	NULL AS [MessageEvent],
	lip.[UserDefined],
	NULL AS [ExternalID]
FROM [TransmissionConfiguration] AS tc with(nolock)
	INNER JOIN [ListIntegrationPartner] AS lip with(nolock) ON tc.[IntegrationPartnerUid] = lip.[IntegrationPartnerUid]
	INNER JOIN [ListeRxMessageType] AS lmt with(nolock) ON tc.[TransmissionType] = lmt.[ExternalID]
WHERE tc.[IntegrationPartnerUid] = ''118422AA-C165-4A2E-8389-E5B7E89636EA''	
	AND lmt.[eRxMessageTypeUid] IN (
-- Outbound message
		''9F19ED8C-3524-46EA-9F4B-B932D38F8585'',	--	NEWRX
		''5151D647-729F-40F1-AFE3-F0CDF31F12A7'',	--	REFRES
		''6B18C334-E4A6-4F82-A831-1AAA6CF6009E'',	--	ELGREQ
		''90DB44EE-ADEA-427C-9450-B418F8577ADE'',	--	RXHREQ
		''C0BD8E17-1FCF-44B2-A1E8-99BB840E5591'',	--	CANRX
		''1C03A342-4FDE-4DDE-99CF-28BAE7D1FA1A'',	--	CHGRES
		''08904166-1336-480E-99C3-174D80B092DA'',	--	PMBC
		''F2FEBF5D-379B-472E-8FB8-4676CE0FBA61'',	--	RFS
		''C0C8C0DE-96F3-4EFE-8DB0-125D0B6DBE4F'',	--	UpdatePrescriber
		''BE1A51C4-FA09-49FC-8C10-6E7F6F878B07'',	--	ProviderDirectory
		''CE675E1B-3B82-4EC3-8D7B-3B1A027E42B4'',	--	InboundMessageRoutingRegistration

-- Inbound message
		--''443D1A55-7384-495B-9BDF-15DEBD9379E2'',	--	REFREQ
		--''5506F18B-084C-489F-8891-89C76FB3DFAB'',	--	ELGRES
		--''1A36A4A2-4B4F-4E49-8DC8-B6F13439FDE3'',	--	RXHRES

		--''06D3F14D-3DA4-4404-A45F-1B3294B487ED'',	--	STATUS
		--''4CD98089-2475-4F86-A904-F0086CFC0B0B'',	--	VERIFY
		--''FBFE211C-18BA-4DDD-A5E2-817933847588'',	--	ERROR
		--''2C259B74-444F-4F29-9634-5768DDA9E572'',	--	RXCHG
		--''F59BDCB7-8DF9-4468-BBBA-544415DB133E'',	--	CANRES
		--''c5a3c450-cbde-433a-8458-6935e164fa50'',	--	RXFILL

		''D375FB2C-454F-4175-A253-6A382028FB0A''	--	INBOUND
	)

UNION
SELECT	t.[TransmissionConfigurationUid] AS [IntegrationPartnerMessageUid],
		t1. [IntegrationPartnerUid],
		t1.[Name] + ''/''+ t.[TransmissionType] AS [Name], 
		NULL AS [Notes],
		t1.[Inactive],
		t.[TransmissionType] AS  MessageType,
		NULL AS [MessageEvent],
		t1.[UserDefined],
		NULL AS [ExternalID]
FROM (
		SELECT *
		FROM [TransmissionConfiguration] WITH(NOLOCK)
		EXCEPT
		SELECT t.*
		FROM [TransmissionConfiguration] AS t WITH(NOLOCK)
			INNER JOIN [ListeRxMessageType] AS t1 WITH(NOLOCK) ON t.[TransmissionType] = t1.[ExternalID]
	) AS t
	LEFT OUTER JOIN [ListIntegrationPartner] AS t1 WITH(NOLOCK) ON t.[IntegrationPartnerUid] = t1.[IntegrationPartnerUid]
where (t1.IntegrationPartnerUid <> ''118422AA-C165-4A2E-8389-E5B7E89636EA'' or t.TransmissionType = ''ePATransport'')
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessages]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewMessages]
AS
WITH CTE_Table AS (
SELECT m.HL7MessageUid AS Uid
				, 0 AS Type
				,CASE WHEN CONVERT(VARCHAR(MAX),CONVERT(XML,m.XmlMessage)) LIKE ''%<OBX.5.4>Base64</OBX.5.4>%'' THEN (STUFF(CONVERT(VARCHAR(MAX),CONVERT(XML,m.XmlMessage)),CHARINDEX(''<OBX.5.4>Base64</OBX.5.4>'',CONVERT(VARCHAR(MAX),CONVERT(XML,m.XmlMessage))),CHARINDEX(''</OBX.5.5>'',CONVERT(VARCHAR(MAX),CONVERT(XML,m.XmlMessage))) - CHARINDEX(''<OBX.5.4>Base64</OBX.5.4>'',CONVERT(VARCHAR(MAX),CONVERT(XML,m.XmlMessage))) + 10,''''))
					ELSE CONVERT(varchar(max),m.XmlMessage) END AS XmlMessage
				--,CASE WHEN CONVERT(VARCHAR(MAX),m.RawMessage) LIKE ''%OBX||PDF%'' THEN (STUFF(CONVERT(VARCHAR(MAX),m.RawMessage),CHARINDEX(''OBX||PDF'',m.RawMessage),LEN(m.RawMessage) - CHARINDEX(''OBX||PDF'',m.RawMessage) + 1,''OBX||PDF|View of Base 64 String Ommitted|''))
				--	ELSE CONVERT(varchar(max),m.RawMessage) END AS RawMessage
				--,CASE WHEN CONVERT(VARCHAR(MAX),m.RawMessage) LIKE ''%PDF^Base64%'' THEN (left(m.RawMessage, charindex(''^'', m.RawMessage, charindex(''PDF^Base64'', m.RawMessage)+2)-1)+''^Base64^View of Base 64 String Ommitted|'')
				--	ELSE CONVERT(varchar(max),m.RawMessage) END AS RawMessage
				,CONVERT(varchar(max),m.RawMessage) AS RawMessage
				,m.Status AS StatusCode
				,s.Name AS Status
				,m.RetryTime
				,m.RetryMinutes
				,m.MessageControlID
				,(SELECT TOP 1 CONVERT(varchar(8000), me.Error) FROM dbo.HL7MessageError AS me WHERE m.HL7MessageUid = me.HL7MessageUid ORDER BY me.LastModifiedDate DESC) AS Error
				,pm.HL7PartnerMessageUid
				,p.HL7PartnerUid
				,p.Name
				,pm.MessageType + pm.MessageEvent AS MessageType
				,ISNULL((SELECT MAX(me.LastModifiedDate) FROM dbo.HL7MessageError AS me WHERE m.HL7MessageUid = me.HL7MessageUid), m.LastModifiedDate) AS LastModifiedDate
				,CASE WHEN pm.Send = 1 THEN ''Send'' ELSE ''Receive'' END AS InOut
				,CAST(0 as bit) AS Reprocess
				,CASE WHEN pn.FirstName is not null THEN pn.LastName + '', '' + pn.FirstName 
					ELSE NULL END AS Patient
				,CASE WHEN pv.FirstName is not null THEN pv.LastName + '', '' + pv.FirstName 
					ELSE NULL END AS Provider
				,NULL AS  ServiceSite
				,NULL AS  Description
				,NULL AS Pharmacy
				,NULL AS VisitUid
				,m.PatientUid AS PatientUid
				,m.ProviderUid AS ProviderUid
				,m.ServiceSiteUid AS ServiceSiteUid
				,NULL AS PharmacyUid
				,cast(NULL as varchar(1024)) AS OutboundReprocessorAQN
FROM dbo.HL7Message AS m 
INNER JOIN dbo.HL7PartnerMessage AS pm ON m.HL7PartnerMessageUid = pm.HL7PartnerMessageUid 
INNER JOIN dbo.HL7Partner AS p ON pm.HL7PartnerUid = p.HL7PartnerUid 
LEFT JOIN dbo.Person pn on pn.PersonUid = m.PatientUid
LEFT JOIN dbo.Person pv on pv.PersonUid = m.ProviderUid
LEFT OUTER JOIN dbo.ListMisc AS s ON m.Status = s.Val AND s.ListType = ''HL7MessageStatus''
WHERE 0 = (SELECT COUNT(*) 
			FROM HL7MessageError hme
			JOIN HL7ActionTypeObject ato on hme.ActionTypeObjectUid = ato.HL7ActionTypeObjectUid
			where hme.HL7MessageUid = m.HL7MessageUid)  
			)

SELECT        Uid
				,Type
				,XmlMessage as ViewXmlMessage
				,XmlMessage as XmlMessageText
				,XmlMessage AS XmlMessage
				,RawMessage
				,StatusCode
				,Status
				,RetryTime
				,RetryMinutes
				,MessageControlID
				,Error
				,HL7PartnerMessageUid
				,HL7PartnerUid
				,Name
				,MessageType
				,LastModifiedDate
				,InOut
				,Reprocess
				,Patient
				,Provider
				,ServiceSite
				,Description
				,Pharmacy
				,VisitUid
				,PatientUid
				,ProviderUid
				,ServiceSiteUid
				,PharmacyUid
				,OutboundReprocessorAQN
FROM CTE_Table

UNION ALL

SELECT        m.HL7ActionTypeObjectUid AS Uid, 1 AS Type, 
                     m.ActionType + '' '' + m.ObjectType + '' '' + CONVERT(varchar(50), m.ObjectUid) AS ViewXmlMessage, 
                     Convert(VARCHAR(MAX),m.ActionType + '' '' + m.ObjectType + '' '' + CONVERT(varchar(50), m.ObjectUid)) AS XmlMessageText, 
                     m.ActionType + '' '' + m.ObjectType + '' '' + CONVERT(varchar(50), m.ObjectUid) AS XmlMessage, 
                     m.MessageContextXML AS RawMessage, 
                     CASE WHEN ProcessingError = 1 THEN 75 ELSE 50 END AS StatusCode, s.Name AS Status, 
                     NULL AS RetryTime, NULL AS RetryMinutes, NULL AS MessageControlID, 
                     (SELECT TOP 1 Error FROM HL7MessageError WHERE ActionTypeObjectUid = m.HL7ActionTypeObjectUid ORDER BY LastModifiedDate DESC) AS Error, 
                     pm.HL7PartnerMessageUid, 
                     p.HL7PartnerUid, p.Name, pm.MessageType + pm.MessageEvent AS MessageType, 
                     m.LastModifiedDate AS LastModifiedDate, 
                     CASE WHEN pm.Send = 1 THEN ''Send'' ELSE ''Receive'' END AS InOut,
                     0 AS Reprocess,
                     NULL AS Patient,
                     NULL AS Provider,
                     NULL AS  ServiceSite,
                     NULL AS  Description,
                     NULL AS Pharmacy,
                     NULL AS VisitUid,
                     NULL AS PatientUid,
                     NULL AS ProviderUid,
                     NULL AS ServiceSiteUid,
                     NULL AS PharmacyUid,
					 cast(NULL as varchar(1024)) AS OutboundReprocessorAQN
FROM          dbo.HL7ActionTypeObject AS m 
                     INNER JOIN dbo.HL7PartnerMessage AS pm ON m.HL7PartnerMessageUid = pm.HL7PartnerMessageUid 
					 INNER JOIN dbo.HL7Partner AS p ON pm.HL7PartnerUid = p.HL7PartnerUid 
                     LEFT OUTER JOIN dbo.ListMisc AS s ON CASE WHEN m.ProcessingError = 1 THEN 75 ELSE 50 END = s.Val AND s.ListType = ''HL7MessageStatus''

UNION ALL -- ePrescribe outbound message
SELECT tob.[TransmissionOutboundUid] AS [UID],
	CASE lmt.eRxMessageTypeUid
		WHEN ''9F19ED8C-3524-46EA-9F4B-B932D38F8585'' THEN 2	-- NEWRX
		WHEN ''5151D647-729F-40F1-AFE3-F0CDF31F12A7'' THEN 9	-- REFRES
		WHEN ''6B18C334-E4A6-4F82-A831-1AAA6CF6009E'' THEN 4	-- ELGREQ
		WHEN ''90DB44EE-ADEA-427C-9450-B418F8577ADE''	THEN 6	-- RXHREQ
		WHEN ''C0BD8E17-1FCF-44B2-A1E8-99BB840E5591''	THEN 21	-- CANRX
		WHEN ''1C03A342-4FDE-4DDE-99CF-28BAE7D1FA1A''	THEN 22	-- CHGRES
		WHEN ''08904166-1336-480E-99C3-174D80B092DA'' THEN 23	-- PMBC
		WHEN ''F2FEBF5D-379B-472E-8FB8-4676CE0FBA61'' THEN 24	-- RFS
		WHEN ''C0C8C0DE-96F3-4EFE-8DB0-125D0B6DBE4F'' THEN 25	-- UpdatePrescriber
		WHEN ''BE1A51C4-FA09-49FC-8C10-6E7F6F878B07'' THEN 26	-- ProviderDirectory
		WHEN ''CE675E1B-3B82-4EC3-8D7B-3B1A027E42B4'' THEN 27	-- InboundMessageRoutingRegistration
	END AS [TYPE], 
	CONVERT([varchar](max), [dbo].[ScrubXmlContentTag](tob.[TransmissionControlXML])) AS [ViewXmlMessage],
	CONVERT([varchar](MAX), tob.[TransmissionControlXML]) AS [XmlMessageText],
	tob.[Description] AS [XmlMessage],
	tob.[RawMessage] AS [RAWMESSAGE], 
	tob.[Status] AS [STATUSCODE], 
	CASE tob.[ExternalStatus] 
		WHEN ''000'' THEN tob.[ExternalStatus] + '' Transaction Successful (Pending) - '' + ISNULL(tob.[ExternalStatusDescription], '''')
		WHEN ''010'' THEN tob.[ExternalStatus] + '' Transaction Successful (Accepted) - '' + ISNULL(tob.[ExternalStatusDescription], '''')
		ELSE  s.[Name] + ISNULL('' '' + tob.[ExternalStatus], '''') + ISNULL('' '', tob.[ExternalStatusDescription])
	END AS [STATUS],
	tob.[NextSendAttempt] AS [RETRYTIME], 
	NULL AS [RETRYMINUTES], 
	NULL AS [MESSAGECONTROLID], 
	tob.[LastError] AS [ERROR], 
	tc.[TransmissionConfigurationUid] AS [HL7PARTNERMESSAGEUID],
	tc.[IntegrationPartnerUid] AS [HL7PARTNERUID],
	lip.[Name],
	tob.[TransmissionType] AS [MESSAGETYPE], 
	tob.[LastModifiedDate], 
	''Send'' AS [InOut],
	0 AS [REPROCESS],
	vp.[FullName] AS [Patient],
	prov.[FullName] AS [Provider],
	lss.[Name] AS  [ServiceSite],
	tob.[Description],
	NULL AS [Pharmacy],
	NULL AS [VisitUid],
	tob.[PatientUid],
	tob.[ProviderUid],
	tob.[ServiceSiteUid],
	NULL AS [PharmacyUid],
	th.[OutboundReprocessorAQN]
FROM [TransmissionOutbound] AS tob with(nolock)
	INNER JOIN [TransmissionConfiguration] AS tc with(nolock) ON tob.[TransmissionType] = tc.[TransmissionType]
	INNER JOIN [ListIntegrationPartner] AS lip with(nolock) ON tc.[IntegrationPartnerUid] = lip.[IntegrationPartnerUid]
	INNER JOIN [ListeRxMessageType] AS lmt with(nolock) ON tc.[TransmissionType] = lmt.[ExternalID]
	INNER JOIN [ViewIntegrationPartnerMessageType] AS vimt with(nolock) ON tc.[IntegrationPartnerUid] = vimt.[IntegrationPartnerUid]
		AND lmt.[eRxMessageTypeUid] = vimt.[IntegrationPartnerMessageUid]
    LEFT OUTER JOIN [ViewHL7MessageStatus] AS s with(nolock) ON tob.[Status] = s.[HL7MessageStatus]
	LEFT OUTER JOIN [ListTransmissionHandling] AS th with(nolock) ON tc.TransmissionConfigurationUid = th.MessageTypeUid
	LEFT OUTER JOIN [ViewFindPatient] AS vp with(nolock) ON tob.[PatientUid] = vp.[PersonUid]
	LEFT OUTER JOIN [ViewProvider] AS prov with(nolock) ON tob.[ProviderUid] = prov.[PersonUid]
	LEFT OUTER JOIN [ListServiceSite] AS lss with(nolock) ON tob.[ServiceSiteUid] = lss.[ServiceSiteUid]
WHERE tc.[IntegrationPartnerUid] = ''118422AA-C165-4A2E-8389-E5B7E89636EA''
	AND lip.[Inactive] = 0

UNION ALL -- ePrescribe inbound message
SELECT td.[TransmissionDataUid] as [UID], 
	8 AS [TYPE], 
	CONVERT(varchar(max), [dbo].[ScrubXmlContentTag](td.[RawMessage])) AS [ViewXmlMessage],
	CONVERT(varchar(max), td.[DataContent]) AS [XmlMessageText],
	td.[Description] AS [XmlMessage],
	td.[RawMessage] AS [RAWMESSAGE], 
	CASE WHEN td.[IsError] = 0 AND td.[MessageProcessed] <> 0 THEN 100 --successfully processed
		WHEN td.[IsError] <> 0 AND td.[MessageProcessed] <> 0 THEN 500 --error/failed processing
		ELSE 0
	END AS [STATUSCODE], --not yet processed
	CASE WHEN td.[IsError] = 0 AND td.[MessageProcessed] <> 0 THEN ''Successful'' --successfully processed
		WHEN td.[IsError] <> 0 AND td.[MessageProcessed] <> 0 THEN ''ProcessingError'' --error/failed processing
		ELSE ''Unprocessed''
	END AS [STATUS], --not yet processed
	NULL AS RETRYTIME, 
	NULL AS RETRYMINUTES, 
	NULL AS [MESSAGECONTROLID], 
	td.[LastError] AS [ERROR], 
	tc.[TransmissionConfigurationUid] AS [HL7PARTNERMESSAGEUID],
	tc.[IntegrationPartnerUid] AS [HL7PARTNERUID],
	lip.[Name],
	td.[TransmissionType] AS [MESSAGETYPE], 
	td.[LastModifiedDate], 
	''Receive'' as [InOut],
	0 AS [REPROCESS],
	NULL AS [Patient],
	NULL AS [Provider],
	NULL AS [ServiceSite],
	td.[Description],
	NULL AS [Pharmacy],
	NULL AS [VisitUid],
	NULL AS [PatientUid],
	NULL AS [ProviderUid],
	NULL AS [ServiceSiteUid],
	NULL AS [PharmacyUid],
	th.[OutboundReprocessorAQN]
FROM [TransmissionData] AS td with(nolock)
	INNER JOIN [TransmissionConfiguration] AS tc with(nolock) ON td.[TransmissionType] = tc.[TransmissionType]
	INNER JOIN [ListIntegrationPartner] AS lip with(nolock) ON tc.[IntegrationPartnerUid] = lip.[IntegrationPartnerUid]
	INNER JOIN [ListeRxMessageType] AS lmt with(nolock) ON tc.[TransmissionType] = lmt.[ExternalID]
	LEFT OUTER JOIN [ListTransmissionHandling] AS th with(nolock) ON tc.[TransmissionConfigurationUid] = th.[MessageTypeUid]
WHERE tc.[IntegrationPartnerUid] = ''118422AA-C165-4A2E-8389-E5B7E89636EA''
	AND lip.[Inactive] = 0
-- Inbound message
	AND lmt.[eRxMessageTypeUid] = ''D375FB2C-454F-4175-A253-6A382028FB0A''	--	INBOUND

UNION ALL
SELECT tro.TransmissionOutboundUid as UID, 
   20 AS TYPE, 
              convert(varchar(max),dbo.ScrubXmlContentTag(tro.TransmissionControlXML)) AS ViewXmlMessage,
              CONVERT(VARCHAR(MAX),tro.TransmissionControlXML) as XmlMessageText,
              --tro.TransmissionControlXML as XmlMessage,
			  tro.description as XmlMessage,
			  tro.RawMessage AS RAWMESSAGE, 
              tro.Status AS STATUSCODE, 
              STATUS = CASE tro.ExternalStatus 
                            WHEN ''000'' THEN tro.ExternalStatus + '' Transaction Successful (Pending) - '' + ISNULL(tro.ExternalStatusDescription, '''')
           WHEN ''010'' THEN tro.ExternalStatus + '' Transaction Successful (Accepted) - '' + ISNULL(tro.ExternalStatusDescription, '''')
                            ELSE  lm.Name + ISNULL('' '' + tro.ExternalStatus, '''') + ISNULL('' '', tro.ExternalStatusDescription)
                       END,
              tro.NextSendAttempt AS RETRYTIME, 
              NULL AS RETRYMINUTES, 
              NULL AS MESSAGECONTROLID, 
              tro.LastError AS ERROR, 
              tc.TransmissionConfigurationUid AS HL7PARTNERMESSAGEUID,
  --lip.IntegrationPartnerUid as HL7PARTNERUID,
			  tc.IntegrationPartnerUid as HL7PARTNERUID,
              lip.Name,
              tro.transmissiontype AS MESSAGETYPE, 
              tro.LastModifiedDate, 
              ''Send'' as InOut,
              0 AS REPROCESS,
              vp.FullName AS Patient,
              prov.FullName AS Provider,
              lss.Name AS  ServiceSite,
              tro.description AS  Description,
              NULL AS Pharmacy,
              NULL AS VisitUid,
              tro.PatientUid AS PatientUid,
              tro.ProviderUid AS ProviderUid,
			  tro.ServiceSiteUid AS ServiceSiteUid,
			NULL AS PharmacyUid,
			 th.OutboundReprocessorAQN
from TransmissionOutbound as tro
       JOIN TransmissionConfiguration tc on tc.TransmissionType = tro.TransmissionType
       join ListIntegrationPartner lip on tc.IntegrationPartnerUid = lip.IntegrationPartnerUid
	   join ListIntegrationPartnerType lipt on lipt.IntegrationPartnerUid = lip.IntegrationPartnerUid AND lipt.Name=''CCM''
       LEFT OUTER JOIN ListMisc AS lm ON tro.Status = lm.Val AND lm.ListType = ''HL7MessageStatus''
	   LEFT OUTER JOIN ListTransmissionHandling th on tc.TransmissionConfigurationUid = th.MessageTypeUid
	left join ViewFindPatient vp on tro.PatientUid = vp.PersonUid
	left join ViewProvider prov on tro.ProviderUid = prov.PersonUid
	left join ListServiceSite lss on tro.ServiceSiteUid = lss.ServiceSiteUid


UNION ALL
SELECT tro.TransmissionOutboundUid as UID, 
              20 AS TYPE, 
              convert(varchar(max),dbo.ScrubXmlContentTag(tro.TransmissionControlXML)) AS ViewXmlMessage,
              CONVERT(VARCHAR(MAX),tro.TransmissionControlXML) as XmlMessageText,
              --tro.TransmissionControlXML as XmlMessage,
			  tro.description as XmlMessage,
			  tro.RawMessage AS RAWMESSAGE, 
              tro.Status AS STATUSCODE, 
              STATUS = CASE tro.ExternalStatus 
                            WHEN ''000'' THEN tro.ExternalStatus + '' Transaction Successful (Pending) - '' + ISNULL(tro.ExternalStatusDescription, '''')
                            WHEN ''010'' THEN tro.ExternalStatus + '' Transaction Successful (Accepted) - '' + ISNULL(tro.ExternalStatusDescription, '''')
                            ELSE  lm.Name + ISNULL('' '' + tro.ExternalStatus, '''') + ISNULL('' '', tro.ExternalStatusDescription)
                       END,
              tro.NextSendAttempt AS RETRYTIME, 
              NULL AS RETRYMINUTES, 
              NULL AS MESSAGECONTROLID, 
              tro.LastError AS ERROR, 
              tc.TransmissionConfigurationUid AS HL7PARTNERMESSAGEUID,
  --lip.IntegrationPartnerUid as HL7PARTNERUID,
			  tc.IntegrationPartnerUid as HL7PARTNERUID,
              lip.Name,
              tro.transmissiontype AS MESSAGETYPE, 
              tro.LastModifiedDate, 
              ''Send'' as InOut,
    0 AS REPROCESS,
              vp.FullName AS Patient,
              prov.FullName AS Provider,
              lss.Name AS  ServiceSite,
              tro.description AS  Description,
              NULL AS Pharmacy,
              NULL AS VisitUid,
              tro.PatientUid AS PatientUid,
              tro.ProviderUid AS ProviderUid,
			  tro.ServiceSiteUid AS ServiceSiteUid,
			NULL AS PharmacyUid,
			 th.OutboundReprocessorAQN
from TransmissionOutbound as tro
       JOIN TransmissionConfiguration tc on tc.TransmissionType = tro.TransmissionType
       join ListIntegrationPartner lip on tc.IntegrationPartnerUid = lip.IntegrationPartnerUid
       LEFT OUTER JOIN ListMisc AS lm ON tro.Status = lm.Val AND lm.ListType = ''HL7MessageStatus''
	   LEFT OUTER JOIN ListTransmissionHandling th on tc.TransmissionConfigurationUid = th.MessageTypeUid
	left join ViewFindPatient vp on tro.PatientUid = vp.PersonUid
	left join ViewProvider prov on tro.ProviderUid = prov.PersonUid
	left join ListServiceSite lss on tro.ServiceSiteUid = lss.ServiceSiteUid
where tro.transmissiontype like ''%DirectMessage%''
UNION ALL
SELECT trd.TransmissionDataUid as UID, 
              20 AS TYPE, 
              convert(varchar(max),dbo.ScrubXmlContentTag(trd.RawMessage)) AS ViewXmlMessage,
              CONVERT(VARCHAR(MAX),trd.DataContent) as XmlMessageText,
              --tro.TransmissionControlXML as XmlMessage,
			  trd.Description as XmlMessage,
			  trd.RawMessage AS RAWMESSAGE, 
              case when trd.IsError = 0 and trd.MessageProcessed = 1 then 100 --successfully processed
					when trd.IsError <> 0 and trd.MessageProcessed = 1 then 500 --error/failed processing
					else 0 end as STATUSCODE, --not yet processed
              case when trd.IsError = 0 and trd.MessageProcessed = 1 then ''Successful'' --successfully processed
					when trd.IsError <> 0 and trd.MessageProcessed = 1 then ''ProcessingError'' --error/failed processing
					else ''Unprocessed'' end as STATUS, --not yet processed
              NULL AS RETRYTIME, 
              NULL AS RETRYMINUTES, 
              NULL AS MESSAGECONTROLID, 
              trd.LastError AS ERROR, 
              tc.TransmissionConfigurationUid AS HL7PARTNERMESSAGEUID,
              --lip.IntegrationPartnerUid as HL7PARTNERUID,
  			  tc.IntegrationPartnerUid as HL7PARTNERUID,
              lip.Name,
              trd.transmissiontype AS MESSAGETYPE, 
              trd.LastModifiedDate, 
              ''Receive'' as InOut,
              0 AS REPROCESS,
              NULL AS Patient,
              NULL AS Provider,
              NULL AS  ServiceSite,
              trd.description AS  Description,
              NULL AS Pharmacy,
              NULL AS VisitUid,
              NULL AS PatientUid,
              NULL AS ProviderUid,
			  NULL AS ServiceSiteUid,
     NULL AS PharmacyUid,
			 th.OutboundReprocessorAQN
from TransmissionData as trd
	JOIN TransmissionConfiguration tc on tc.TransmissionType = trd.TransmissionType       
	join ListIntegrationPartner lip on tc.IntegrationPartnerUid = lip.IntegrationPartnerUid
	LEFT OUTER JOIN ListTransmissionHandling th on tc.TransmissionConfigurationUid = th.MessageTypeUid
where trd.transmissiontype like ''%DirectMessage%''

/*
UNION ALL
SELECT tro.TransmissionOutboundUid as UID, 
              20 AS TYPE, 
              dbo.ScrubXmlContentTag(tro.TransmissionControlXML) 
                      AS ViewXmlMessage,
              CONVERT(VARCHAR(MAX),tro.TransmissionControlXML) as XmlMessageText,
              tro.TransmissionControlXML as XmlMessage,
              tro.RawMessage AS RAWMESSAGE, 
              tro.Status AS STATUSCODE, 
 lm.Name AS STATUS,
tro.NextSendAttempt AS RETRYTIME, 
              NULL AS RETRYMINUTES, 
              NULL AS MESSAGECONTROLID, 
              tro.LastError AS ERROR, 
              tc.TransmissionConfigurationUid AS HL7PARTNERMESSAGEUID,
   null as HL7PARTNERUID,
    tro.TransmissionType as name,
              tro.transmissiontype AS MESSAGETYPE, 
              tro.LastModifiedDate, 
              ''Send'' as InOut,
  0 AS REPROCESS,
              NULL AS Patient,
              NULL AS Provider,
              NULL AS  ServiceSite,
              tro.Description AS  Description,
              NULL AS Pharmacy,
              NULL AS VisitUid,
              NULL AS PatientUid,
              NULL AS ProviderUid,
              NULL AS ServiceSiteUid,
             NULL AS PharmacyUid
from TransmissionOutbound as tro with(nolock)
       LEFT OUTER JOIN TransmissionConfiguration tc with(nolock) on tc.TransmissionType = tro.TransmissionType
       LEFT OUTER JOIN ListMisc AS lm with(nolock) ON tro.Status = lm.Val AND lm.ListType = ''HL7MessageStatus''
where tro.TransmissionType NOT IN (''NitorTestDirectMessage'', ''ELGREQ'', ''NitorDirectMessage'', ''NitorWithCertificateDirectMessage'', ''INBOUND'', ''RXHREQ'', 
                                                              ''NEWRX'', ''NitorTestWithCertificateDirectMessage'', ''REFRES'', ''ePATransport'')
*/

UNION ALL
SELECT tro.TransmissionOutboundUid as UID, 
            20 AS TYPE, 
            tro.RawMessage AS ViewXmlMessage,
            CONVERT(VARCHAR(MAX),tro.TransmissionControlXML) as XmlMessageText,
            convert(varchar(max),tro.TransmissionControlXML) as XmlMessage,
            tro.RawMessage AS RAWMESSAGE, 
            tro.Status AS STATUSCODE, 
            lm.Name AS STATUS,
            tro.NextSendAttempt AS RETRYTIME, 
            NULL AS RETRYMINUTES, 
            NULL AS MESSAGECONTROLID, 
            tro.LastError AS ERROR, 
            tc.TransmissionConfigurationUid AS HL7PARTNERMESSAGEUID,
			tc.TransmissionConfigurationUid as HL7PARTNERUID,
            tro.TransmissionType as name,
            tro.transmissiontype AS MESSAGETYPE, 
            tro.LastModifiedDate, 
            ''Send'' as InOut,
            0 AS REPROCESS,
                     vp_Patient.[FullName] AS[Patient],
                     vp_Provider.[FullName] AS [Provider],              
                     ss.Name AS  ServiceSite,
            tro.Description AS  Description,
            ph.Name AS Pharmacy,
            V.VisitUid AS VisitUid,
            vp_Patient.PersonUid AS PatientUid,
            vp_Provider.PersonUid AS ProviderUid,
            V.ServiceSiteUid AS ServiceSiteUid,
            M.PharmacyUid AS PharmacyUid,
		 cast(NULL as varchar(1024)) AS OutboundReprocessorAQN
from TransmissionOutbound as tro with(nolock)
       LEFT JOIN TransmissionConfiguration tc with(nolock) on tc.TransmissionType = tro.TransmissionType
       LEFT JOIN ListMisc AS lm with(nolock) ON tro.Status = lm.Val AND lm.ListType = ''HL7MessageStatus''
          LEFT JOIN RelVisitMedication rvm with(nolock) on tro.ForeignObjectUid = rvm.RelVisitMedicationUid
          LEFT JOIN MedicationSIG m with(nolock) on rvm.MedicationSIGUid = m.MedicationSIGUid
       LEFT JOIN [ViewPerson] AS vp_Provider WITH(NOLOCK) ON m.ProviderUid = vp_Provider.[PersonUid]
          LEFT JOIN Visit V with(nolock) ON rvm.VisitUid = v.VisitUid
          LEFT JOIN [ViewPerson] AS vp_Patient WITH(NOLOCK) ON V.PatientUid = vp_Patient.[PersonUid]
          LEFT JOIN [ListServiceSite] AS ss WITH(NOLOCK) ON v.[ServiceSiteUid] = ss.[ServiceSiteUid]
          LEFT JOIN ListPharmacy ph with(nolock) on m.PharmacyUid = ph.PharmacyUid
where tro.TransmissionType = ''ePATransport''

UNION ALL
SELECT		  tro.TransmissionOutboundUid as UID, 
              20 AS TYPE, 
              convert(varchar(max),dbo.ScrubXmlContentTag(tro.TransmissionControlXML)) AS ViewXmlMessage,
              CONVERT(VARCHAR(MAX),tro.TransmissionControlXML) as XmlMessageText,
              --tro.TransmissionControlXML as XmlMessage,
			  case when tro.RawMessage is not null then RawMessage
					else ''<root>null</root>'' end as XmlMessage,
			  tro.RawMessage AS RAWMESSAGE, 
   tro.Status AS STATUSCODE, 
STATUS = lm.name,
              tro.NextSendAttempt AS RETRYTIME, 
              NULL AS RETRYMINUTES, 
              NULL AS MESSAGECONTROLID, 
              tro.LastError AS ERROR, 
tc.TransmissionConfigurationUid AS HL7PARTNERMESSAGEUID,
  --lip.IntegrationPartnerUid as HL7PARTNERUID,
			  tc.TransmissionConfigurationUid as HL7PARTNERUID,
              lip.Name,
              tro.transmissiontype AS MESSAGETYPE, 
              tro.LastModifiedDate, 
              ''Send'' as InOut,
0 AS REPROCESS,
              vp.FullName AS Patient,
              prov.FullName AS Provider,
              lss.Name AS  ServiceSite,
              tro.description AS  Description,
              NULL AS Pharmacy,
              NULL AS VisitUid,
              tro.PatientUid AS PatientUid,
              tro.ProviderUid AS ProviderUid,
			  tro.ServiceSiteUid AS ServiceSiteUid,
			NULL AS PharmacyUid,
			 th.OutboundReprocessorAQN
from TransmissionOutbound as tro
       JOIN TransmissionConfiguration tc on tc.TransmissionType = tro.TransmissionType
       join ListIntegrationPartner lip on tc.IntegrationPartnerUid = lip.IntegrationPartnerUid
       LEFT OUTER JOIN ListMisc AS lm ON tro.Status = lm.Val AND lm.ListType = ''HL7MessageStatus''
	   LEFT OUTER JOIN ListTransmissionHandling th on tc.TransmissionConfigurationUid = th.MessageTypeUid
	left join ViewFindPatient vp on tro.PatientUid = vp.PersonUid
	left join ViewProvider prov on tro.ProviderUid = prov.PersonUid
	left join ListServiceSite lss on tro.ServiceSiteUid = lss.ServiceSiteUid
where tc.ActionType = ''RegistryCDAGeneration''
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillHistory]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbillHistory]
AS
WITH cteErrorReports AS
(
      SELECT ERR.SuperbillUid, 
	              COALESCE(ERR.LastModifiedDate, ERD.ImportDate) as EventDate,-- wasCOALESCE(ERD.ImportDate, ERR.LastModifiedDate) as EventDate,
                  ERR.LastModifiedByUid as UserUid, 
				  SUBSTRING( CASE WHEN df.fileImage IS NOT NULL THEN CAST(CAST(df.fileImage AS VARBINARY(MAX)) AS VARCHAR(MAX))
								   WHEN err.errorDescription IS NULL THEN COALESCE(ERR.additionalClaimInformation, '''')  
								   ELSE (ERR.errorDescription + COALESCE('' ('' + ERR.additionalClaimInformation + '')'', '''')) END,
							 1, 2500 ) AS RawMessage,
                  (CASE ERD.ReportNumber WHEN ''PAYMENT'' THEN ''Payment Note''
                        WHEN ''SB Note'' THEN ''Superbill Note'' ELSE ERD.ReportNumber END) as [Description],
                  (CASE errorFlag WHEN ''E'' THEN ''Error'' WHEN ''W'' THEN ''Warning'' ELSE ''Information'' END) as Status,
                  (CASE WHEN ERR.errorDescription IS NULL THEN COALESCE(ERR.additionalClaimInformation, '''') 
                        ELSE (ERR.errorDescription + COALESCE('' ('' + ERR.additionalClaimInformation + '')'', '''')) END) AS Notes,
                  ERD.SuperbillNoteChanges,
				  ERR.InsuranceCarrierUid AS InsurancePayerUid, COALESCE(err.followUp, 0) as followUp
            FROM eReportRows ERR
                  LEFT JOIN eReportDetails ERD On ERR.eReportDetailUid = ERD.eReportDetailUid 
                  LEFT JOIN downloadedFiles DF on ERD.eReportFileUid = DF.downloadedFileUid
), 
cteClaimBatch AS
(
      --SELECT CBD.SuperbillUid, CB.ClaimDate as EventDate,  
      --            CB.ClaimingUserUid as UserUid, ''NO REPORT'' AS RawMessage,
      --            CFT.Name AS [Description], CBD.[Status],
      --            NULL AS Notes, IP.InsuranceCarrierUid AS InsurancePayerUid
      --      FROM ClaimBatch CB
      --            INNER JOIN ClaimBatchDetail CBD On CB.ClaimBatchUid = CBD.ClaimBatchUid
      --            INNER JOIN ListClaimFormatType AS CFT ON CB.ClaimFormatTypeUid = CFT.ClaimFormatTypeUid 
      --            INNER JOIN InsurancePlan AS IP ON CBD.InsurancePlanUid = IP.InsurancePlanUid 

      SELECT CBD.SuperbillUid, CB.ClaimDate as EventDate,  
                  CB.ClaimingUserUid as UserUid, 
				  CASE WHEN ecf.data is NULL THEN ''NO REPORT'' 
					   ELSE ecf.data                           END AS RawMessage,
                  CFT.Name AS [Description], CBD.[Status],
				  CASE WHEN cb.SubmissionNumber IS NULL THEN NULL
					   ELSE ''Claim Submission '' + CONVERT(VARCHAR(7), cb.SubmissionNumber) END AS Notes, 
				  IP.InsuranceCarrierUid AS InsurancePayerUid
            FROM ClaimBatch CB
                  INNER JOIN ClaimBatchDetail CBD On CB.ClaimBatchUid = CBD.ClaimBatchUid
                  INNER JOIN ListClaimFormatType AS CFT ON CB.ClaimFormatTypeUid = CFT.ClaimFormatTypeUid 
                  INNER JOIN InsurancePlan AS IP ON CBD.InsurancePlanUid = IP.InsurancePlanUid 
				  LEFT OUTER JOIN eClaimFile ecf on cb.EClaimFileUid = ecf.EClaimFileUid
),
cteTransactionNote AS
(
      SELECT ARTrans.SuperbillUid, ARTrans.CreatedDateTime as EventDate,  
                  ARTrans.LastModifiedByUid as UserUid, 
                  ''Transaction Note ('' + Coalesce( ARTrans.ReferenceNumber, '''') + ''): '' + CONVERT(varchar(2500), Coalesce( ARTrans.Notes, '''')) AS RawMessage,
                  ''Transaction Note'' AS [Description], 
                  (CASE WHEN vda.ReceiptBalance = 0 THEN ''Allocated'' ELSE ''Pending'' END) as Status, 
                  convert(varchar(2500),ARTrans.Notes) AS Notes, 
                  NULL as InsurancePayerUid, --
                  ARTrans.TransactionUid
            FROM AR_Transaction ARTrans
				inner join AR_Ledger l on ARTrans.TransactionUid = l.TransactionUid
				inner join ARBatch arb on l.ArBatchUid = arb.ARBatchUid -- to get gldate for event date
            INNER JOIN AR_ViewDepositAggregate vda on vda.DepositUid = ARTrans.DepositUid
            INNER JOIN Deposit d on d.DepositUid = ARTrans.DepositUid
            LEFT JOIN Corporation wpc ON d.WhoPaidInsuranceCarrierUid = wpc.CorporationUid   
            LEFT JOIN Person wpp ON d.WhoPaidPersonUid = wpp.PersonUid    
),
cteFinancials AS
(
     SELECT LE.SuperbillUid, LE.CreatedDateTime as EventDate,  
                  LE.LastModifiedByUid as UserUid, 
                  ''NO REPORT'' AS RawMessage, 
                  (CASE WHEN NOT LDOS.DepositUid IS NULL AND NOT LE.VoidLedgerUid IS NULL  THEN ''Payment Reversal''
                        WHEN NOT LDOS.DepositUid IS NULL THEN ''Payment'' 
                        WHEN NOT LE.VoidLedgerUid IS NULL THEN ''Charge Reversal'' 
                        WHEN LDOS.PayerCreditUid IS NOT NULL THEN ''Payer Credit''
                        ELSE '''' END) as [Description], 
                  (CASE WHEN NOT LDOS.DepositUid IS NULL AND NOT LE.VoidLedgerUid IS NULL  THEN ''Payment Reversal''
                        WHEN NOT LDOS.DepositUid IS NULL THEN ''Payment'' 
                        WHEN NOT LE.VoidLedgerUid IS NULL THEN ''Charge Reversal'' 
                        WHEN LDOS.PayerCreditUid IS NOT NULL THEN ''Payment''
                        ELSE '''' END) as [Status], 
                  (CASE WHEN NOT LDOS.DepositUid IS NULL 
       THEN ''Applied Payment of '' + CAST(LDOS.Amount AS VARCHAR(12)) +  '' from Deposit '' + DPOS.ReferenceNumber 
                        WHEN NOT LE.VoidLedgerUid IS NULL 
                              THEN ''Reversed Charge of '' + CAST(LDOS.Amount AS VARCHAR(12)) + '' from Procedure '' + LP.Code + '' in Batch '' + LE.ArBatchName
                        WHEN LDOS.PayerCreditUid IS NOT NULL 
                              THEN ''Applied Payment of '' + CAST(LDOS.Amount AS VARCHAR(12)) + '' from Payer Credit '' + APC.Note 
                        ELSE '''' END) as Notes,
                   LDOS.InsurancePayerUid, -- LE.InsurancePayerUid, 
                   LDOS.AccountResponsiblePartyUid
            FROM AR_ViewLedgerExtended LE
                  INNER JOIN SuperbillProcedure SBP ON LE.SuperbillProcedureUid = SBP.SuperbillProcedureUid
                  INNER JOIN ListProcedure LP ON SBP.ProcedureUid = LP.ProcedureUid
                  LEFT JOIN AR_LedgerDetail LDOS ON LE.LedgerUid = LDOS.LedgerUid AND LE.LedgerDetailUid <> LDOS.LedgerDetailUid
                  LEFT JOIN AR_ViewDepositAggregate VDA ON LDOS.DepositUid = VDA.DepositUid
                  LEFT JOIN Deposit DPOS ON LDOS.DepositUid = DPOS.DepositUid
                  LEFT JOIN AR_PayerCredit APC ON LDOS.PayerCreditUid = APC.PayerCreditUid
            WHERE NOT LE.SuperbillUid IS NULL 
                  AND NOT (LE.EntryType=1 AND LE.VoidLedgerUid IS NULL) 
                  AND NOT LE.EntryType IN (3,4) -- ignore adjustments and transfers for now
),
cteAggregate AS
(
      SELECT SuperbillUid, [Description], EventDate, UserUid, RawMessage, [Status], Notes, InsurancePayerUid,
                  NULL AS AccountResponsiblePartyPayerUid,
                  NULL AS TransactionUid, SuperbillNoteChanges, followUp
            FROM cteErrorReports
      UNION
      SELECT SuperbillUid, [Description], EventDate, UserUid, RawMessage, [Status], Notes, InsurancePayerUid,
                  NULL AS AccountResponsiblePartyPayerUid,
                  NULL AS TransactionUid, NULL AS SuperbillNoteChanges, 0 as followUp
            FROM cteClaimBatch
      UNION
      SELECT SuperbillUid, [Description], EventDate, UserUid, RawMessage, [Status], Notes, InsurancePayerUid,
                   AccountResponsiblePartyUid AS AccountResponsiblePartyPayerUid,
                  NULL AS TransactionUid, NULL AS SuperbillNoteChanges, 0 as followUp                      
            FROM cteFinancials
      UNION
            SELECT SuperbillUid, [Description], EventDate, UserUid, RawMessage, [Status], Notes, InsurancePayerUid,
                   NULL AS AccountResponsiblePartyPayerUid,
                   TransactionUid, NULL AS SuperbillNoteChanges, 0 as followUp 
            FROM cteTransactionNote
)
SELECT NEWID() AS ViewSuperbillHistoryUid, 
       AG.SuperbillUid, 
       VSB.ExternalID, 
       VSB.PatientUid, 
       AG.EventDate, 
       AG.UserUid, 
       AG.RawMessage, 
       UFN.FullName AS UserName,   
       AG.[Description], 
       AG.[Status],
        AG.Notes, 
		AG.SuperbillNoteChanges,
        AG.InsurancePayerUid AS InsuranceCarrierUid, 
       CASE WHEN AG.TransactionUid IS NOT NULL THEN dbo.UDF_AR_getTransactionPayerCreditAndDepositNames(AG.TransactionUid)
                                                           ELSE COALESCE(CORP.Name, PFN.FullName) END AS PayerName, 
       VSB.InsuranceOrder, 
       ILN.InsuranceLevelName AS InsuranceOrderName,
       AG.TransactionUid,
	   AG.followUp
      FROM cteAggregate AG
            INNER JOIN ViewSuperbill VSB ON AG.SuperbillUid = VSB.SuperbillUid
            LEFT JOIN ListInsuranceLevelName ILN ON VSB.InsuranceOrder = ILN.InsuranceLevel      
            LEFT JOIN ViewPerson (NOEXPAND) UFN ON AG.UserUid = UFN.PersonUid
            LEFT JOIN Corporation CORP ON AG.InsurancePayerUid = CORP.CorporationUid
            LEFT JOIN AccountResponsibleParty ARP ON AG.AccountResponsiblePartyPayerUid = ARP.AccountResponsiblePartyUid
            LEFT JOIN ViewPerson (NOEXPAND) PFN ON ARP.PersonUid = PFN.PersonUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillScrub]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewSuperbillScrub] as
WITH cteSuperbillLockInfo AS
(
	SELECT LSV.SuperbillUid, ROW_NUMBER() OVER (PARTITION BY LSV.SuperbillUid ORDER BY LSV.LockDateStart) AS RowNo, 
	LSV.LockUid, PNS.FullName, LSV.HostName, LSV.LockDate, LSV.LockDateStart 
	FROM
	(
		SELECT SB.SuperbillUid, L.LockByUid,
		L.LockUid, L.HostName, L.LockDate, L.LockDateStart
		FROM Lock L
		INNER JOIN Superbill SB ON L.LockedUid = SB.SuperbillUid
		UNION
		SELECT SB.SuperbillUid, L.LockByUid,
		L.LockUid, L.HostName, L.LockDate, L.LockDateStart
		FROM Lock L
		INNER JOIN Superbill SB ON L.LockedUid = SB.VisitUid
	) LSV
	INNER JOIN ViewPerson PNS ON LSV.LockByUid = PNS.PersonUid
)

SELECT s.SuperbillUid, s.ExternalID AS ExternalID, 
			  s.PatientUid,
              s.RenderingProviderUid, 
              s.ClaimingProviderUid, 
              s.SuperbillStatusUid,   
              s.ServiceDateStart, 
              s.ServiceDateEnd,  
              s.TotalCharge, 
              s.FirstFiledDate, 
              s.LastFiledDate,
              s.ServiceSiteUid,   
              s.PatientName,   
              s.RenderingProviderName,   
              s.ClaimingProviderName,
			  s.ReferingProviderName,
              s.SuperbillStatusName, 
              s.ServiceSiteName,
              s.AccountUid, 
              s.VisitUid,
              s.VisitDate,   
              S.VisitIsCompleted,
              s.ClaimPaper, 
              s.LastModifiedByUid, 
              s.IsPosted, 
              s.FinancialCenterUid,
              s.FinancialCenterName, 
              s.InsuranceOrder,
              --s.CodeValidationErrors,
              s.MaxPostingDate, 
              s.MinPostingDate, 
			  s.ABN,
			  s.InsuranceLevelName,
			  ARP.AccountResponsiblePartyUid,
			  CASE WHEN NOT ARP.CorporationUid IS NULL THEN ARPCORP.Name
				ELSE ARPPERSON.FullName END AS AccountResponsiblePartyName,
			  CASE WHEN (s.CodeValidationErrors = ''Errors'' OR ((SELECT COUNT(*)    
	           FROM eReportRows err     
	           WHERE err.SuperbillUid = s.SuperbillUid    
	           AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
	           AND err.ErrorFlag = ''E'') > 0)) THEN ''Errors'' ELSE '''' END AS ValidationErrors,
			  (SELECT COUNT(*)    
	           FROM eReportRows err     
	           WHERE err.SuperbillUid = s.SuperbillUid    
	           AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
	           AND err.ErrorFlag = ''E'')    
	           AS Errors,     
	          (SELECT COUNT(*)    
	           FROM eReportRows err    
	           WHERE err.SuperbillUid = s.SuperbillUid    
	           AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
	           AND err.ErrorFlag = ''W'')    
	           AS Warnings,
			   s.Notes,
			   SLI.LockUid, SLI.FullName AS LockedByUserName, SLI.HostName AS LockedByHostName,
			   SLI.LockDate AS LockedDate, SLI.LockDateStart AS LockedDateStart,
			   ARPCCAC.TotalAuthorizationAmount AS ArpTotalAuthorizationAmount,
			   VSA.LiabilityBalance, VSA.AssignedLiabilityBalance,
			   VSF.LastFollowupModifiedByUid, VSF.LastFollowupModifiedDate, VSF.LastFollowupByUser, VSF.LastFollowupAll, VSF.MaxFollowupModifiedDate,
			   S.SuperbillProcedureCount
FROM   ViewSuperbill s 
				INNER JOIN Account AC WITH (NOLOCK) ON s.AccountUid = AC.AccountUid
				INNER JOIN AccountResponsibleParty ARP WITH (NOLOCK) ON AC.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid
				LEFT JOIN AccountResponsiblePartyCreditCardAuthorizationCache ARPCCAC WITH (NOLOCK) ON AC.AccountResponsiblePartyUid = ARPCCAC.AccountResponsiblePartyUid
				LEFT JOIN AR_ViewSuperbillAggregate VSA ON S.SuperbillUid = VSA.SuperbillUid
				LEFT JOIN ViewPerson (NOEXPAND) ARPPERSON on ARP.PersonUid = ARPPERSON.PersonUid  
				LEFT JOIN Corporation ARPCORP ON ARP.CorporationUid = ARPCORP.CorporationUid 
				LEFT JOIN cteSuperbillLockInfo SLI ON S.SuperbillUid = SLI.SuperbillUid AND SLI.RowNo = 1
				LEFT JOIN ViewSuperbillFollowup VSF ON S.SuperbillUid = VSF.SuperbillUid
























' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessagesRxErrors]'))
EXEC dbo.sp_executesql @statement = N'
CREATE view [dbo].[ViewMessagesRxErrors] as
SELECT td.[TransmissionDataUid] AS Uid,
	   8 AS [Type],
	   CONVERT(VARCHAR(2), null) AS [ViewXmlMessage],
	   CONVERT(varchar(2), null) AS [XmlMessageText],
	   CONVERT(xml, null) AS [XmlMessage],
	   td.[RawMessage],
	   500 AS [StatusCode],
	   s.[Name] AS [Status], 
	   CONVERT(datetime, null) AS [RetryTime],
	   CONVERT(int, null) AS [RetryMinutes],
	   CONVERT(int, null) AS [MessageControlID],
	   CONVERT(varchar(2), td.[LastError]) AS [Error], 
	   vmmt.[eRxMessageTypeUid] AS [HL7PartnerMessageUid],
	   tc.[IntegrationPartnerUid] AS [HL7PartnerUid],
	   lip.[Name],
	   vmmt.[ExternalID] AS [MessageType], 
	   td.[LastModifiedDate] AS [LastModifiedDate],
	   ''Receive'' as [InOut],
       0 AS Reprocess,
	   CONVERT(varchar(2), null) AS [Patient],
	   CONVERT(varchar(2), null) AS [Provider],
	   CONVERT(varchar(2), null) AS [ServiceSite],
	   CONVERT(varchar(2), null) AS [Description],
	   CONVERT(varchar(2), null) AS [Pharmacy],
	   CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [VisitUid],
	   CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [PatientUid],
	   CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [ProviderUid],
	   CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [ServiceSiteUid],
	   CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [PharmacyUid]
FROM [ListeRxMessageType] AS vmmt WITH(NOLOCK)
	INNER JOIN [TransmissionData] AS td WITH(NOLOCK) ON vmmt.[ExternalID] = td.[TransmissionType]
	INNER JOIN [TransmissionConfiguration] AS tc WITH(NOLOCK) ON td.[TransmissionType] = tc.[TransmissionType]
	INNER JOIN [ListIntegrationPartner] AS lip  WITH(NOLOCK) ON tc.[IntegrationPartnerUid] = lip.[IntegrationPartnerUid]
    LEFT OUTER JOIN [ViewHL7MessageStatus] AS s WITH(NOLOCK) ON s.[HL7MessageStatus] = 500
WHERE td.[IsError] <> 0
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewBatchProcessDetailClaims]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewBatchProcessDetailClaims] AS
SELECT bpd.BatchProcessDetailUid, bpd.BatchProcessUid,
			CASE WHEN bpd.Error IS NULL THEN 0 ELSE 1 END AS HasError,
			CASE WHEN bpd.DetailXml IS NULL THEN 0 ELSE 1 END AS [Generated],
			--bpd.Error,
	       Error = REPLACE( STUFF( (select ''@'' + err.errorDescription
									from eReportDetails erd
											inner join eReportRows err with (nolock) on erd.eReportDetailUid = err.eReportDetailUid
									where erd.ClaimBatchUid = bp.BatchProcessUid
									order by err.LastModifiedDate asc
									FOR XML PATH('''')),
									1, 1, ''''
							),
							''@'', CHAR(13)+CHAR(10)),
			------------------------------
			cbd.DisplayOrder,
			vsp.ExternalID as SuperbillId,
			cbd.IncludedInBatch,
			bp.CreatedDateTime,
			vsp.PatientName,
			vsp.InsuredName,
			vsp.RenderingProviderName, 
			vsp.ClaimingProviderName,
			vsp.ServiceSiteName,
			cbd.[Status] as Status,
			dbo.ConvertDateOnly(sb.ServiceDateStart) AS ServiceDateStart,
			CASE WHEN cbd.IncludedInBatch = 1
			     THEN bpd.DetailXml.value(''(/ClaimSuperbill/Superbill/@totalBill)[1]'', ''money'')
				 ELSE NULL END AS TotalSuperbillCharges
FROM BatchProcess bp WITH (NOLOCK)
		INNER JOIN ClaimBatch cb WITH (NOLOCK) ON bp.BatchProcessUid = cb.ClaimBatchUid
		INNER JOIN BatchProcessDetail bpd WITH (NOLOCK) ON bp.BatchProcessUid = bpd.BatchProcessUid
		INNER JOIN ClaimBatchDetail cbd WITH (NOLOCK) ON bpd.BatchProcessDetailUid = cbd.ClaimBatchDetailUid
		INNER JOIN Superbill sb WITH (NOLOCK) ON cbd.SuperbillUid = sb.SuperbillUid
		INNER JOIN ViewSuperbillPayer vsp WITH (NOLOCK) ON cbd.SuperbillUid = vsp.SuperbillUid
															AND vsp.InsuranceOrder = cb.InsuranceOrder  -- without this it gets all insurance
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientHistoryDrugAllergy]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewPatientHistoryDrugAllergy]  WITH SCHEMABINDING
		AS
		SELECT      
			phd.PatientHistoryDetailUid,
			ph.PatientUid,
			ph.PatientHistoryUid,
			ph.ActiveDate,
			ph.InactiveDate,
			phd.QuestionUid,
			phd.AnswerUid,
			phd.QuestionName,
			phd.AnswerName,
			phd.RecordDateTime
		FROM  
			[dbo].Patient pat 
			INNER JOIN [dbo].PatientHistory ph ON pat.PersonUid = ph.PatientUid  AND ph.HistoryGroupUid = ''00000000-0000-0000-0000-000000000109''  
			INNER JOIN [dbo].PatientHistoryDetail phd ON phd.PatientHistoryUid = ph.PatientHistoryUid  AND phd.Denies = 0 

		--IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N''[dbo].[ViewPatientHistoryDrugAllergy]'') AND name = N''IX_ViewPatientHistoryDrugAllergy'')
		--CREATE UNIQUE CLUSTERED INDEX [IX_ViewPatientHistoryDrugAllergy] ON [dbo].[ViewPatientHistoryDrugAllergy]
		--(
		--	[PatientHistoryDetailUid] ASC,
		--	[PatientUid] ASC,
		--	[PatientHistoryUid] ASC,
		--	[ActiveDate] ASC,
		--	[InactiveDate] ASC,
		--	[QuestionUid] ASC,
		--	[AnswerUid] ASC,
		--	[QuestionName] ASC,
		--	[AnswerName] ASC,
		--	[RecordDateTime] ASC
		--) ON [PRIMARY]

		--IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N''GenerateEntityObject'' , N''SCHEMA'',N''dbo'', N''VIEW'',N''ViewPatientHistoryDrugAllergy'', NULL,NULL))
		--EXEC sys.sp_addextendedproperty @name=N''GenerateEntityObject'', @value=N''false'' , @level0type=N''SCHEMA'',@level0name=N''dbo'', @level1type=N''VIEW'',@level1name=N''ViewPatientHistoryDrugAllergy''
	
' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientHistoryDrugAllergy]') AND name = N'IX_ViewPatientHistoryDrugAllergy')
CREATE UNIQUE CLUSTERED INDEX [IX_ViewPatientHistoryDrugAllergy] ON [dbo].[ViewPatientHistoryDrugAllergy]
(
	[PatientHistoryDetailUid] ASC,
	[PatientUid] ASC,
	[PatientHistoryUid] ASC,
	[ActiveDate] ASC,
	[InactiveDate] ASC,
	[QuestionUid] ASC,
	[AnswerUid] ASC,
	[QuestionName] ASC,
	[AnswerName] ASC,
	[RecordDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCDSPatientDrugAllergy]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewCDSPatientDrugAllergy] 
	AS
	SELECT      
		NewId() as ViewCDSPatientDrugAllergyUid,
		vphga.[PatientUid] AS [PersonUid],
		vphga.PatientHistoryUid,
		vphga.ActiveDate,
		vphga.InactiveDate,
		vphga.PatientHistoryDetailUid,
		vphga.QuestionUid,
		vphga.AnswerUid,
		vphga.QuestionName,
		vphga.AnswerName,
		vphga.RecordDateTime,
		rqas.AnswerSnomedConceptID as ReactionSnomedConceptID,
		que.SnomedConceptID,
		CASE WHEN rxn.RxNormCode != '''' THEN rxn.RxNormCode ELSE NULL END as RxNormCode
	FROM  
		[ViewPatientHistoryDrugAllergy] AS vphga WITH(NOEXPAND)
		LEFT OUTER JOIN RelQuestionAnswerSnomed rqas ON rqas.AnswerUid = vphga.AnswerUid and rqas.QuestionUid = vphga.QuestionUid
		LEFT OUTER JOIN ListQuestion que ON que.QuestionUid = vphga.QuestionUid
		CROSS APPLY (SELECT RxNormCode = dbo.RxNormCodeFromQuestionUid(que.QuestionUid)) AS rxn

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessagesRefReq]'))
EXEC dbo.sp_executesql @statement = N'
CREATE view [dbo].[ViewMessagesRefReq] as
SELECT t.[MessageUid] AS [Uid],
	   9 AS [Type],
	   t.[MessageXML] AS [ViewXmlMessage],
	    CONVERT(VARCHAR(MAX),t.[MessageXML]) AS [XmlMessageText],
	   t.[MessageXML] AS [XmlMessage],
	   CONVERT(varchar(2), null) AS [RawMessage],
	   CONVERT(int, s.[HL7MessageStatus]) AS [StatusCode],
	   s.[Name] AS [Status], 
	   CONVERT(datetime, null) AS [RetryTime],
	   CONVERT(int, null) AS [RetryMinutes],
	   CONVERT(int, null) AS [MessageControlID],
	   CONVERT(varchar(2), null) AS [Error], 
	   lmt.[eRxMessageTypeUid] AS [HL7PartnerMessageUid],
	   t2.[PharmacyClearinghouseUid] AS [HL7PartnerUid],
	   t2.[Name],
	   lmt.[ExternalID] AS [MessageType], 
	   t.[LastModifiedDate] AS [LastModifiedDate],
	   ''Receive'' as [InOut],
       0 AS Reprocess,
	   vp_Patient.[FullName] AS [Patient],
	   vp_Provider.[FullName] AS [Provider],
	   ss.[Name] AS  [ServiceSite],
	   CONVERT(varchar(2), null) AS [Description],
	   t1.[Name] AS [Pharmacy],
	   CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [VisitUid],
	   msg.[PersonUid] AS [PatientUid],
	   t.[ProviderUid] AS [ProviderUid],
	   t.[ServiceSiteUid] AS [ServiceSiteUid],
	   CONVERT(uniqueidentifier, ''00000000-0000-0000-0000-000000000000'') AS [PharmacyUid]
FROM [MessageERxRefillRequest] AS t WITH(NOLOCK)
	INNER JOIN [TransmissionData] AS td WITH(NOLOCK) ON t.[MessageID] = td.[RequestId]
    INNER JOIN [ListeRxMessageType] AS t3 WITH(NOLOCK) ON t3.[eRxMessageTypeUid] = ''D375FB2C-454F-4175-A253-6A382028FB0A''
		AND td.[TransmissionType] = t3.[ExternalID]
	INNER JOIN [TransmissionConfiguration] AS tc ON td.[TransmissionType] = tc.[TransmissionType]
    INNER JOIN [MasterPharmacy] AS t1 WITH (NOLOCK) ON t.[MasterPharmacyUid] = t1.[MasterPharmacyUid]
    INNER JOIN [ListPharmacyClearinghouse] AS t2 WITH(NOLOCK) ON t1.[PharmacyClearinghouseUid] = t2.[PharmacyClearinghouseUid]
    INNER JOIN [Message] AS msg ON msg.[MessageUid] = t.[MessageUid]
    LEFT JOIN [ViewPerson] AS vp_Patient WITH(NOLOCK) ON msg.[PersonUid] = vp_Patient.[PersonUid]
    LEFT JOIN [ViewPerson] AS vp_Provider WITH(NOLOCK) ON t.[ProviderUid] = vp_Provider.[PersonUid]
    LEFT JOIN ListServiceSite AS ss WITH(NOLOCK) ON t.[ServiceSiteUid] = ss.[ServiceSiteUid]
    LEFT OUTER JOIN [ViewHL7MessageStatus] AS s WITH(NOLOCK) ON (
			CASE WHEN td.[MessageProcessed] = 0 THEN 0
				ELSE CASE WHEN td.[IsError] <> 0 THEN 500 ELSE 100 END
			END 
		) = s.[HL7MessageStatus]
    OUTER APPLY
    (
            SELECT [eRxMessageTypeUid], [Name], [ExternalID]
            FROM [ListeRxMessageType] WITH(NOLOCK)
            WHERE [eRxMessageTypeUid] = ''443D1A55-7384-495B-9BDF-15DEBD9379E2'' -- REFREQ
    ) AS lmt
WHERE msg.[DateCompleted] IS NULL
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_VoidReview_Charges]'))
EXEC dbo.sp_executesql @statement = N'
--20160217  kculberth add WITH NOLOCKs

CREATE VIEW [dbo].[MDOL_RPT2_View_VoidReview_Charges]
AS
SELECT        CASE WHEN LVOID.LedgerUid IS NULL THEN ''Voiding'' ELSE ''Voided'' END AS VoidAction, VARB.Name AS VoidBatch, VARB.GLDate AS VoidPostDate, 
                         CASE WHEN VARB.IsClosed = 1 THEN ''Closed'' WHEN VARB.IsLocked = 1 THEN ''Complete'' ELSE ''Open'' END AS BatchState, LVOID.ArBatchUid, 
                         SP.ProcedureServiceDateStart, LD.Amount AS Amount, LP.Code, VLD.SuperbillProcedureUnits, SB.PatientName, SB.ExternalID AS SuperbillID, SP.SuperbillUid, 
                         SB.PatientUid
FROM            dbo.AR_Ledger AS L WITH (NOLOCK) INNER JOIN
                         dbo.AR_LedgerDetail AS LD WITH (NOLOCK) ON (L.LedgerUid = LD.LedgerUid AND LD.IsCredit = 1) INNER JOIN
                         dbo.AR_Ledger AS LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid LEFT OUTER JOIN
                         dbo.ARBatch AS VARB WITH (NOLOCK) ON LVOID.ArBatchUid = VARB.ARBatchUid INNER JOIN
                         dbo.AR_LedgerDetail AS VLD WITH (NOLOCK) ON LVOID.LedgerUid = VLD.LedgerUid AND VLD.SuperbillProcedureUid IS NOT NULL AND VLD.IsCredit = 0 INNER JOIN
                         dbo.SuperbillProcedure AS SP WITH (NOLOCK) ON VLD.SuperbillProcedureUid = SP.SuperbillProcedureUid INNER JOIN
                         dbo.ListProcedure AS LP WITH (NOLOCK) ON SP.ProcedureUid = LP.ProcedureUid INNER JOIN
                         dbo.ViewSuperbill AS SB ON SP.SuperbillUid = SB.SuperbillUid
WHERE        (LD.Amount <> 0) AND (L.EntryType = 1)


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementBalanceandAge]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewStatementBalanceandAge]   
AS  
 
SELECT  
-- dbo.Charge.ChargeUid  
 A.AccountResponsiblePartyUid,   
 LD.FinancialCenterUid,  
 LD.LiabilityOwner,  
 (CASE WHEN ld.Amount <0 THEN  isnull(VSP.LiabilityBalance - VSP.AssignedLiabilityBalance,0) * -1 ELSE  isnull(VSP.LiabilityBalance - VSP.AssignedLiabilityBalance,0) END)  AS BalanceAll,  
 ARB.GLDate as LiabilityDate  
FROM  
 AR_Ledger L  
INNER JOIN  
 AR_LedgerDetail LD  
ON  
 L.LedgerUid=LD.LedgerUid AND (L.EntryType=1 OR L.EntryType=4) --AND LD.IsCredit=0  
JOIN
 ARBatch ARB
ON
 L.ArBatchUid =ARB.ARBatchUid 
INNER JOIN  
 AR_ViewSuperbillProcedureAggregate VSP  
ON  
 LD.SuperbillProcedureUid= VSP.SuperbillProcedureUid  
INNER JOIN  
 SuperbillProcedure SP  
ON  
 SP.SuperbillProcedureUid=LD.SuperbillProcedureUid  
INNER JOIN  
 Superbill S  
ON  
 S.SuperbillUid=SP.SuperbillUid  
INNER JOIN  
 Account A  
ON  
 S.AccountUid = A.AccountUid  
WHERE  
 (VSP.LiabilityBalance - VSP.AssignedLiabilityBalance) > 0 AND LD.LiabilityOwner = 0  
 AND SP.SuperbillUid NOT IN  
             (  
                 SELECT SuperbillUid FROM [ViewStatementLineItem]  
                 WHERE Type=''subtotal''  
                 AND Patient=0  
             )   


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_VoidReview_Deposits]'))
EXEC dbo.sp_executesql @statement = N'
--20160217  kculberth add WITH NOLOCKs

CREATE VIEW [dbo].[MDOL_RPT2_View_VoidReview_Deposits]
AS
SELECT		CASE WHEN LVOID.LedgerUid IS NULL THEN ''Voiding'' ELSE ''Voided'' END AS VoidAction, VARB.Name AS VoidBatch, 
                      CASE WHEN VARB.IsClosed = 1 THEN ''Closed'' WHEN VARB.IsLocked = 1 THEN ''Complete'' ELSE ''Open'' END AS BatchState, LVOID.ArBatchUid, 
                      LD.DepositUid, VARB.GLDate AS VoidPostDate, L.EntryDate AS DepositDate, LD.Amount AS Amount, 
                      CASE WHEN NOT VLD.InsurancePayerUid IS NULL THEN VIC.Name + '' (IP)'' ELSE VPNS_ARP.FullName + '' (ARP)'' END AS Payer, 
                      ISNULL(DP.ReferenceNumber, ''-'') AS DepositReferenceNumber, DP.Comment AS DepositComment
FROM         dbo.AR_Ledger AS L WITH (NOLOCK) INNER JOIN
                      dbo.AR_LedgerDetail AS LD WITH (NOLOCK) ON (L.LedgerUid = LD.LedgerUid AND LD.IsCredit = 1) LEFT OUTER JOIN
                      dbo.ViewPerson AS VPNS_LD WITH (NOLOCK) ON LD.LastModifiedByUid = VPNS_LD.PersonUid INNER JOIN
                      dbo.AR_Ledger AS LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid LEFT OUTER JOIN
                      dbo.ARBatch AS VARB WITH (NOLOCK) ON LVOID.ArBatchUid = VARB.ARBatchUid INNER JOIN
                      dbo.AR_LedgerDetail AS VLD WITH (NOLOCK) ON LVOID.LedgerUid = VLD.LedgerUid AND VLD.IsCredit = 1 LEFT OUTER JOIN
                      dbo.AccountResponsibleParty AS ARP WITH (NOLOCK) ON VLD.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid LEFT OUTER JOIN
                      dbo.ViewPerson AS VPNS_ARP WITH (NOEXPAND) ON ARP.PersonUid = VPNS_ARP.PersonUid LEFT OUTER JOIN
                      dbo.ViewInsuranceCarrier AS VIC ON VLD.InsurancePayerUid = VIC.CorporationUid INNER JOIN
                      dbo.Deposit AS DP WITH (NOLOCK) ON LD.DepositUid = DP.DepositUid
WHERE     (LD.Amount <> 0) AND (L.EntryType = 0)



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPersonWeb]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewPersonWeb]
AS
SELECT PW.PersonUid, PW.UserName, VP.FullName, 
		RSSPW.ServiceSiteUid, LSS.Name AS ServiceSiteName,
		RPPPW.PatientProgramUid, LPP.Name AS PatientProgramName
	FROM PersonWeb PW
		INNER JOIN ViewPerson VP ON PW.PersonUid = VP.PersonUid
		LEFT JOIN RelServiceSitePersonWeb RSSPW ON PW.PersonUid = RSSPW.PersonUid
			LEFT JOIN ListServiceSite LSS ON RSSPW.ServiceSiteUid = LSS.ServiceSiteUid
		LEFT JOIN RelPatientProgramPersonWeb RPPPW ON PW.PersonUid = RPPPW.PersonUid
			LEFT JOIN ListPatientProgram LPP ON RPPPW.PatientProgramUid = LPP.PatientProgramUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessagesePA]'))
EXEC dbo.sp_executesql @statement = N'
CREATE view [dbo].[ViewMessagesePA] as
SELECT      tro.TransmissionOutboundUid as Uid, 
            22 AS Type, 
            tro.RawMessage AS ViewXmlMessage,
            CONVERT(VARCHAR(MAX),tro.TransmissionControlXML) as XmlMessageText,
            tro.TransmissionControlXML as XmlMessage,
            tro.RawMessage AS RawMessage, 
            CONVERT(int, tro.Status) AS StatusCode, 
            lm.Name AS Status,
            tro.NextSendAttempt AS RetryTime, 
            CONVERT(int, null) AS RetryMinutes, 
            CONVERT(int, null) AS MessageControlID, 
            tro.LastError AS Error, 
            tc.TransmissionConfigurationUid AS HL7PartnerMessageUid,
			tc.TransmissionConfigurationUid as HL7PartnerUid,
            tro.TransmissionType as Name,
            tro.transmissiontype AS MessageType, 
            tro.LastModifiedDate, 
            ''Send'' as InOut,
            0 AS Reprocess,
            vp_Patient.[FullName] AS[Patient],
            vp_Provider.[FullName] AS [Provider],              
            ss.Name AS  ServiceSite,
            tro.Description AS  Description,
            ph.Name AS Pharmacy,
            V.VisitUid AS VisitUid,
            vp_Patient.PersonUid AS PatientUid,
            vp_Provider.PersonUid AS ProviderUid,
            V.ServiceSiteUid AS ServiceSiteUid,
            M.PharmacyUid AS PharmacyUid
from TransmissionOutbound as tro with(nolock)
       LEFT JOIN TransmissionConfiguration tc with(nolock) on tc.TransmissionType = tro.TransmissionType
       LEFT JOIN ListMisc AS lm with(nolock) ON tro.Status = lm.Val AND lm.ListType = ''HL7MessageStatus''
          LEFT JOIN RelVisitMedication rvm with(nolock) on tro.ForeignObjectUid = rvm.RelVisitMedicationUid
          LEFT JOIN MedicationSIG m with(nolock) on rvm.MedicationSIGUid = m.MedicationSIGUid
       LEFT JOIN [ViewPerson] AS vp_Provider WITH(NOLOCK) ON m.ProviderUid = vp_Provider.[PersonUid]
          LEFT JOIN Visit V with(nolock) ON rvm.VisitUid = v.VisitUid
          LEFT JOIN [ViewPerson] AS vp_Patient WITH(NOLOCK) ON V.PatientUid = vp_Patient.[PersonUid]
          LEFT JOIN [ListServiceSite] AS ss WITH(NOLOCK) ON v.[ServiceSiteUid] = ss.[ServiceSiteUid]
          LEFT JOIN ListPharmacy ph with(nolock) on m.PharmacyUid = ph.PharmacyUid
where tro.TransmissionType = ''ePATransport''
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCanDoMDOLGetClaimXML]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewCanDoMDOLGetClaimXML]
As
SELECT DISTINCT
	d.SuperbillUID,
	d.ExternalID,
	(CASE WHEN
		d.SuperbillUID is not null and
		a.AccountUID is not null and
		ap.accountPeriodUID is not null and
		lr.RelationShipUID is not null and
		PIP.PersonInsurancePlanUID is not null and
		IP.InsurancePlanUID is not null and
		IC.CorporationUID is not null and
		p.PersonUID is not null and
		per.PersonUID is not null and
		(aI.DisplayOrder = 1 or aI.DisplayOrder = 2)
		THEN ''PASS''
		ELSE ''FAIL''
	END) as CanPrint,
	a.AccountUID,
	ap.accountPeriodUID,
	lr.RelationShipUID,
	PIP.PersonInsurancePlanUID,
	IP.InsurancePlanUID,
	IC.CorporationUID,
	p.PersonUID as ProviderPersonUID,
	per.PersonUID as PersonInsurancePlanPersonUID,
	aI.DisplayOrder,
	(CASE WHEN aI.DisplayOrder = 1 or aI.DisplayOrder = 2 THEN '''' ELSE ''AccountInsurance DISPLAY ORDER MUST BE 1 or 2'' END) as DisplayOrderErrorMsg
FROM Superbill d
INNER JOIN ViewSuperbillFinancialDetails VSFD ON d.SuperbillUid = VSFD.SuperbillUid
-- INNER 
LEFT JOIN Account a
	ON a.AccountUID = d.AccountUID 
-- INNER 
LEFT JOIN AccountPeriod ap
	ON a.accountUID = ap.accountUID 
-- INNER 
LEFT JOIN AccountInsurance aI
	ON aI.accountPeriodUID = ap.accountPeriodUID 
-- INNER 
LEFT JOIN ListRelationShip lr
	ON lr.RelationShipUID = aI.RelationShipUID
-- INNER 
LEFT JOIN PersonInsurancePlan PIP
	ON PIP.PersonInsurancePlanUID = aI.PersonInsurancePlanUID 
	--AND PIP.InsurancePlanUid = cb.InsurancePlanUid
-- INNER 
LEFT JOIN InsurancePlan IP
	ON IP.InsurancePlanUID = PIP.InsurancePlanUID 
-- INNER 
LEFT JOIN InsuranceCarrier IC					--INNER
	ON IC.CorporationUID = IP.InsuranceCarrierUID --AND IC.CorporationUID = IP.InsuranceCarrierUID 
LEFT JOIN ListClaimFormat lcf		--INNER
	ON lcf.ClaimFormatUid = IP.ElectronicClaimFormatUid
LEFT JOIN ListClaimFormatType lcft
	ON lcft.ClaimFormatTypeUid = lcf.ClaimFormatTypeUid	
-- INNER 
LEFT JOIN Provider p
	ON p.PersonUID = VSFD.ClaimingProviderUid
LEFT JOIN ListProviderCareType lprct
	ON lprct.ProviderCareTypeUid = p.DefaultProviderCareTypeUid 
--INNER 
LEFT JOIN Person per
	ON per.PersonUID = PIP.PersonUID
LEFT JOIN ListGender perLG 
	ON per.GenderUid = perLG.GenderUid
LEFT JOIN PersonEmployer PEMP	--INNER 
	ON PEMP.PersonUID = per.PersonUID
LEFT JOIN Corporation crp 
	ON PEMP.EmployerUID = crp.CorporationUID
LEFT JOIN ListEmploymentStatus perES
	ON perES.EmploymentStatusUid = PEMP.EmploymentStatusUid









' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_VoidReview_Distributions]'))
EXEC dbo.sp_executesql @statement = N'

--20160217  kculberth add WITH NOLOCKs

CREATE VIEW [dbo].[MDOL_RPT2_View_VoidReview_Distributions]
AS
SELECT  CASE WHEN LVOID.LedgerUid IS NULL THEN ''Voiding'' ELSE ''Voided'' END AS VoidAction, VARB.Name AS VoidBatch, 
                         CASE WHEN VARB.IsClosed = 1 THEN ''Closed'' WHEN VARB.IsLocked = 1 THEN ''Complete'' ELSE ''Open'' END AS BatchState, LVOID.ArBatchUid, VLD.DepositUid, 
                         VARB.GLDate AS VoidPostDate, L.EntryDate AS DepositDate, 0 - LD.Amount AS Amount, LP.Code, CASE WHEN NOT LD.InsurancePayerUid IS NULL 
                         THEN VIC.Name + '' (IP)'' ELSE VPNS_ARP.FullName + '' (ARP)'' END AS Payer, DP.ReferenceNumber AS DepositReferenceNumber, CASE WHEN LP.Code IS NULL THEN PC.Note + '' (PC)'' ELSE ART.ReferenceNumber END AS ReferenceNumber
FROM            dbo.AR_Ledger AS L WITH (NOLOCK) INNER JOIN
                         dbo.AR_LedgerDetail AS LD WITH (NOLOCK) ON L.LedgerUid = LD.LedgerUid LEFT OUTER JOIN
                         dbo.ViewInsuranceCarrier AS VIC WITH (NOLOCK) ON LD.InsurancePayerUid = VIC.CorporationUid LEFT OUTER JOIN
                         dbo.AccountResponsibleParty AS ARP WITH (NOLOCK) ON LD.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid LEFT OUTER JOIN
                         dbo.ViewPerson AS VPNS_ARP WITH (NOEXPAND) ON ARP.PersonUid = VPNS_ARP.PersonUid INNER JOIN
                         dbo.AR_Ledger AS LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid LEFT OUTER JOIN
                         dbo.ARBatch AS VARB WITH (NOLOCK) ON LVOID.ArBatchUid = VARB.ARBatchUid INNER JOIN
                         dbo.Deposit AS DP WITH (NOLOCK) ON LD.DepositUid = DP.DepositUid LEFT OUTER JOIN
                         dbo.AR_Transaction AS ART WITH (NOLOCK) ON LVOID.TransactionUid = ART.TransactionUid INNER JOIN
                         dbo.AR_LedgerDetail AS VLD WITH (NOLOCK) ON ((LVOID.LedgerUid = VLD.LedgerUid AND VLD.IsCredit = 1) AND (VLD.SuperbillProcedureUid IS NOT NULL OR VLD.PayerCreditUid IS NOT NULL)) LEFT OUTER JOIN
                         dbo.SuperbillProcedure AS SP WITH (NOLOCK) ON VLD.SuperbillProcedureUid = SP.SuperbillProcedureUid LEFT OUTER JOIN
                         dbo.ListProcedure AS LP WITH (NOLOCK) ON SP.ProcedureUid = LP.ProcedureUid LEFT OUTER JOIN
                         dbo.AR_PayerCredit AS PC WITH (NOLOCK) ON vld.PayerCreditUid = pc.PayerCreditUid
WHERE        
	((L.EntryType = 2) OR (L.EntryType = 0 AND VLD.PayerCreditUid IS NOT NULL))
	AND LD.Amount <> 0





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregateSubCompleteBatch]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewSuperbillProcedureAggregateSubCompleteBatch] --WITH SCHEMABINDING  
AS  
SELECT PE.PersonUid, AC.AccountUid, SB.SuperbillUid, SBP.SuperbillProcedureUid,           
            SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.AMOUNT ELSE 0 END) As Liability,         
            SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT ELSE 0 END) As AssignedLiability,        
            SUM(CASE WHEN L.EntryType = 2 THEN LD.AMOUNT*-1 ELSE 0 END) As Distribution,        
            SUM(CASE WHEN L.EntryType = 2 AND NOT LD.InsurancePlanUid IS NULL  THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedDistribution,        
            SUM(CASE WHEN L.EntryType = 3 THEN LD.AMOUNT*-1 ELSE 0 END) As Adjustment,        
            SUM(CASE WHEN L.EntryType = 3 AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedAdjustment,        
            SUM(LD.Amount) As LiabilityBalance,         
            SUM(CASE WHEN NOT LD.InsurancePlanUid IS NULL THEN LD.Amount ELSE 0 END) As AssignedLiabilityBalance,        
            COUNT_BIG(*) AS Count  
      FROM dbo.AR_LedgerDetail  LD        
            INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
            INNER JOIN dbo.SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
            LEFT JOIN dbo.ViewSuperbillProcedure_IsVoid VSPVOID ON VSPVOID.SuperbillProcedureUid=SBP.SuperbillProcedureUid
            INNER JOIN dbo.Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
            INNER JOIN dbo.Account AC ON SB.AccountUid = AC.AccountUid
            INNER JOIN dbo.Person PE ON AC.PersonUid = PE.PersonUid
			INNER JOIN dbo.[AR_ViewSuperbillCompleteBatch] VSC ON SB.SuperbillUid = VSC.SuperbillUid
			INNER JOIN dbo.ARBatch ARB ON L.ArBatchUid=ARB.ARBatchUid 
      WHERE NOT LD.SuperbillProcedureUid IS NULL AND VSC.CompleteBatch=1   AND (ARB.IsClosed=1 OR ARB.IsLocked =1) 
            AND (VSPVOID.IsVoid IS NULL OR VSPVOID.IsVoid=0)
      GROUP BY PE.PersonUid, AC.AccountUid, SB.SuperbillUid, SBP.SuperbillProcedureUid      



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewAppointmentWithGroup]'))
EXEC dbo.sp_executesql @statement = N'

--20150817 kdc add billingprovideruid

CREATE VIEW [dbo].[ViewAppointmentWithGroup] AS
	WITH PracticeSettings_CTE (PracticeSettingsUid, PracticeName, PracticeAddress1, PracticeCity, PracticeState, PracticeZip, PracticePhoneNumber, PracticePhoneTypeUid, PracticePhoneType)
	AS
	(
		SELECT
			TOP 1 
			PracticeSettingsUid     = ps.PracticeSettingsUid,
			PracticeName			= ps.Name,
			PracticeAddress1		= ISNULL(ps.MainAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(255)''), ''''),
			PracticeCity			= ISNULL(ps.MainAddress.value(''(/Address/City)[1]'', ''VARCHAR(255)''), ''''),
			PracticeState			= ISNULL(ps.MainAddress.value(''(/Address/State)[1]'', ''VARCHAR(255)''), ''''),
			PracticeZip				= ISNULL(ps.MainAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(255)''), ''''),
			PracticePhoneNumber		= ISNULL(ps.MainPhone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(255)''), ''''),
			PracticePhoneTypeUid	= ISNULL(ps.MainPhone.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(255)''), ''00000000-0000-0000-8000-000000000000''),
			PracticePhoneType		= ISNULL(ps.MainPhone.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(255)''), '''')
		FROM PracticeSettings ps
	)

   SELECT
		AppointmentUid          = a.AppointmentUid,
		AppointmentTypeUid      = a.AppointmentTypeUid,
		AppointmentStatusUid    = a.AppointmentStatusUid,
		CheckinDateTime         = a.CheckinDateTime,
		DischargeDateTime       = a.DischargeDateTime,
		PatientCaseUid          = a.PatientCaseUid,
		PatientUid              = ISNULL(a.PatientUid, g.PatientUid),
		AccountUid              = ISNULL(a.AccountUid, g.AccountUid),
		CalendarUid				= a.CalendarUid,
		ServiceSiteUid          = a.ServiceSiteUid,

		VisitLocationUid		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									lss.ServiceSiteUid
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeSettingsUid FROM PracticeSettings_CTE)
								  END,

		VisitLocationName		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Name, '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeName FROM PracticeSettings_CTE)
								  END,

		VisitLocationAddress1	= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeAddress1 FROM PracticeSettings_CTE)
								  END,

		VisitLocationCity		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeCity FROM PracticeSettings_CTE)
								  END,

		VisitLocationState		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeState FROM PracticeSettings_CTE)
								  END,

		VisitLocationZip		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeZip FROM PracticeSettings_CTE)
								  END,

		VisitLocationPhoneNumber = CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticePhoneNumber FROM PracticeSettings_CTE)
								  END,

		VisitLocationPhoneType	= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticePhoneType FROM PracticeSettings_CTE)
								  END,

      FinancialCenterUid		= a.FinancialCenterUid,
      ProviderUid				= a.ProviderUid, --Rendering Provider
      ProviderCareTypeUid		= a.ProviderCareTypeUid,
	  BillingProviderUid		= a.BillingProviderUid,
      ReferredbyProviderUid		= a.ReferredbyProviderUid,
      ReferringDate				= a.ReferringDate,
      Phone						= a.Phone,
      CallConfirmStatusUid		= a.CallConfirmStatusUid,
      CallConfirmStatusDetail	= a.CallConfirmStatusDetail,
      Reason					= a.Reason,
      AuthorizationReminder		= a.AuthorizationReminder,
      AuthorizationCode			= a.AuthorizationCode,
      StartDateTime				= a.StartDateTime,
      EndDateTime				= a.EndDateTime,
      ExternalID				= a.ExternalID,
      Notes						= a.Notes,
      CreatedByUid				= a.CreatedByUid,
      CreatedDateTime			= a.CreatedDateTime,
      LastModifiedDate			= a.LastModifiedDate,
      LastModifiedByUid			= a.LastModifiedByUid,
      TriggerOverride			= a.TriggerOverride,
      ReferralSrcUid			= a.ReferralSrcUid,
      ScheduleType				= a.ScheduleType,

      Calendar					= c.Name,
	  TimeZone					= c.TimeZone,
      Provider					= PNS.FormattedInternalName,
	  ProviderFullName			= PNS.FullName,
      FullName					= per.LastName + '', '' + per.FirstName,
      Birthdate					= per.Birthdate,
      MedicalRecordNumber		= pat.MedicalRecordNumber,
      PhoneNumber				= CASE WHEN NOT a.AppointmentUid IS NULL THEN Phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') ELSE NULL END,
      Address1					= per.Address1,
      AddressString				= RTRIM(per.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') + '' ''
									+ ISNULL(per.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(255)''),'''')) + CHAR(13)
									+ ISNULL(per.Address1.value(''(/Address/City)[1]'', ''VARCHAR(255)''),'''') + '' ''
									+ ISNULL(per.Address1.value(''(/Address/State)[1]'', ''VARCHAR(255)''),'''') + ''  ''
									+ ISNULL(per.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(255)''),''''),
      Phone1					= per.Phone1,
	  Phone2					= per.Phone2,
      Name						= per.LastName + '', '' + per.FirstName + ''('' + CONVERT(varchar(20), a.StartDateTime, 120) + '')'',
      Inactive					= 0,
      ShowOnSchedule			= astat.ShowOnSchedule,
      ShowOnDesktop				= astat.ShowOnDesktop,

	  ApptTypeColor             = at.Color,
      AppointmentTypeName       = at.Name,
	  AppointmentTypeDuration   = at.Duration,
	  AppointmentTypeExternalId = at.ExternalID,
	  AppointmentTypeGroupVisit = at.GroupVisit,

      ApptStatusColor           = astat.Color,
      AppointmentStatusName     = ISNULL(gstat.Name, astat.Name),
	  AppointmentStatusExternalId = ISNULL(gstat.ExternalID, astat.ExternalID),

      EligibilityStatus			= aped.EligibilityStatus,
      isCommitted				= CONVERT(BIT, CASE WHEN (SELECT COUNT(*) FROM Visit v WHERE v.AppointmentUid = a.AppointmentUid AND v.IsCompleted = 1) > 0 THEN 1 ELSE 0 END),
      AssociatedWithVisit		= CONVERT(BIT, CASE WHEN (SELECT COUNT(*) FROM Visit v WHERE v.AppointmentUid = a.AppointmentUid) > 0 THEN 1 ELSE 0 END),
      CanCreateGroupVisit		= CONVERT(BIT, CASE WHEN (SELECT COUNT(*) FROM RelGroupAppointmentPatient g LEFT JOIN Visit v ON v.AppointmentUid = g.AppointmentUid AND v.PatientUid = g.PatientUid WHERE g.AppointmentUid = a.AppointmentUid AND v.VisitUid IS NULL) > 0 THEN 1 ELSE 0 END)
FROM Appointment a
   LEFT JOIN RelGroupAppointmentPatient g WITH (NOLOCK) ON g.AppointmentUid = a.AppointmentUid
   LEFT JOIN Provider PR WITH (NOLOCK) ON A.ProviderUid = PR.PersonUid -- filter out for providers only
   LEFT JOIN ViewPerson PNS WITH (NOEXPAND) ON PR.PersonUid = PNS.PersonUid
   LEFT JOIN ListCalendar c WITH (NOLOCK) ON a.CalendarUid = c.CalendarUid
   LEFT JOIN ListAppointmentType at WITH (NOLOCK) ON a.AppointmentTypeUid = at.AppointmentTypeUid
   LEFT JOIN ListAppointmentStatus astat WITH (NOLOCK) ON a.AppointmentStatusUid = astat.AppointmentStatusUid
   LEFT JOIN ListAppointmentStatus gstat WITH (NOLOCK) ON g.AppointmentStatusUid = gstat.AppointmentStatusUid
   LEFT JOIN Patient pat WITH (NOLOCK) ON ISNULL(a.PatientUid, g.PatientUid) = pat.PersonUid
   LEFT JOIN Person per WITH (NOLOCK) ON ISNULL(a.PatientUid, g.PatientUid) = per.PersonUid
   LEFT JOIN ViewAccountPeriodEligibilityDate aped ON aped.AccountPeriodUid =
               (SELECT TOP 1 ap.AccountPeriodUid
                FROM AccountPeriod ap WITH (NOLOCK)  -- Replaces GetAccountPeriod
                WHERE ap.AccountUid = a.AccountUid
                  AND (CAST(ap.EffectiveDate AS DATE) <= CAST(a.StartDateTime AS DATE) OR ap.EffectiveDate IS NULL) AND
                      (CAST(ap.ExpirationDate AS DATE) >= CAST(a.StartDateTime AS DATE) OR ap.ExpirationDate IS NULL))
   LEFT JOIN ListServiceSite lss WITH (NOLOCK) ON lss.ServiceSiteUid = a.ServiceSiteUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewReport_Appointment]'))
EXEC dbo.sp_executesql @statement = N'

/*Pancratius 12/20/2013 Removed function dbo.UDF_utcToCurrent from all date columns*/

CREATE VIEW [dbo].[ViewReport_Appointment] 
AS
Select 
	AppointmentUid,
	(A.StartDateTime) AS StartDateTime ,
	(A.EndDateTime) AS EndDateTime,
	(A.CheckinDateTime) AS CheckinDateTime,
	(A.DischargeDateTime) AS DischargeDateTime,
	LAS.Name AppointmentStatus,
	LAT.Name AS AppointmentType,
	A.CalendarUid,
	c.Name AS Calendar,
	A.ProviderUid,
	dbo.UDF_getFormattedName(prov.Prefix, prov.FirstName, prov.Middlename, prov.LastName, prov.Suffix) AS Provider,
    a.PatientUid, 
    per.LastName + '', '' + per.FirstName AS Patient,   
	per.Birthdate, 
	pat.MedicalRecordNumber, 
	a.Reason,   
	A.ServiceSiteUid,
	LS.Name ServiceSite,
	A.FinancialCenterUid,
	FC.Name as FinancialCenter,
	A.ReferredbyProviderUid, 
	RefProv.LastName + '', '' + RefProv.FirstName AS ReferringProvider
From 
    ViewAppointmentWithGroup A 
 LEFT OUTER JOIN 
	dbo.ViewProvider Prov 
 ON 
	A.ProviderUid = Prov.PersonUid 
LEFT OUTER JOIN  
	dbo.ListCalendar c 
ON 
	A.CalendarUid = C.CalendarUid 
LEFT OUTER JOIN  
	ListAppointmentStatus LAS
On
	A.AppointmentStatusUid = LAS.AppointmentStatusUid 
LEFT OUTER JOIN
	ListAppointmentType  LAT
On
	A.AppointmentTypeUid = LAT.AppointmentTypeUid  
LEFT OUTER JOIN
	ListServiceSite LS
ON
	A.ServiceSiteUid =LS.ServiceSiteUid 
JOIN
   dbo.Patient pat 
ON 
	a.PatientUid = pat.PersonUid 
LEFT OUTER JOIN  
    dbo.Person per 
ON
	pat.PersonUid = per.PersonUid
LEFT OUTER JOIN
	FinancialCenter FC
ON
	A.FinancialCenterUid = FC.FinancialCenterUid
LEFT OUTER JOIN
	Person RefProv
ON
	A.ReferredbyProviderUid = RefProv.PersonUid 	
Where A.PatientUid IS NOT NULL



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillAggregateCompleteBatch]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewSuperbillAggregateCompleteBatch] 
AS
SELECT SB.SuperbillUid, 
	SUM(ISNULL(VSPACB.Liability, 0)) AS Liability, 
	SUM(ISNULL(VSPACB.AssignedLiability, 0)) AS AssignedLiability,
	SUM(ISNULL(VSPACB.Distribution, 0)) AS Distribution, 
	SUM(ISNULL(VSPACB.AssignedDistribution, 0)) AS AssignedDistribution, 
	SUM(ISNULL(VSPACB.Adjustment, 0)) AS Adjustment,
	SUM(ISNULL(VSPACB.AssignedAdjustment, 0)) AS AssignedAdjustment,
	SUM(ISNULL(VSPACB.LiabilityBalance, 0)) AS LiabilityBalance, 
	CASE WHEN SUM(ISNULL(VSPACB.LiabilityBalance, 0))=0 AND SUM(ABS(ISNULL(VSPACB.LiabilityBalance, 0)))>0 THEN 1 ELSE 0 END AS ZeroLiabilityBalanceNotDistributed, -- we have a ZeroBalance made up of offsetting balances (not properly distributed) 
	SUM(ISNULL(VSPACB.AssignedLiabilityBalance, 0)) AS AssignedLiabilityBalance
FROM Superbill SB
LEFT JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid
LEFT JOIN
   ViewSuperbillProcedure_IsVoid VSPVOID
ON
   VSPVOID.SuperbillProcedureUid=SBP.SuperbillProcedureUid
--LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON SBP.SuperbillProcedureUid = VSPAB.SuperbillProcedureUid
LEFT JOIN [AR_ViewSuperbillProcedureAggregateSubCompleteBatch]  VSPACB ON SBP.SuperbillProcedureUid = VSPACB.SuperbillProcedureUid
WHERE 
    VSPVOID.IsVoid IS NULL OR VSPVOID.IsVoid=0
GROUP BY SB.SuperbillUid 

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_PatientStatus]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[MDOL_RPT2_VIEW_PatientStatus]
AS
    
	 SELECT  P.PatientUid,
				stuff((select ''|'' + LPS.Name
				FROM  listpatientstatus lps  WITH (NOLOCK)
				INNER JOIN relpatientstatus rps  WITH (NOLOCK) on lps.PatientStatusUid= rps.PatientStatusUid
				Where p.PatientUid = rps.PatientUid
				AND  LPS.Name is not null
				FOR xml path('''')),1,1,'''') PatientStatus
	FROM relpatientstatus P WITH (NOLOCK)
	GROUP BY P.PatientUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_DemographicbySchedule_Demographics]'))
EXEC dbo.sp_executesql @statement = N'
-- 20170315 kculberth Bug 56191:Reports. Demographic by Schedule report only lists one race for the patient configured with multiple race

/*Pancratius 11/03/2014: Modified View to show multiple Patient statuses on a single row separated by pipe (|) from  */
CREATE VIEW [dbo].[MDOL_RPT2_VIEW_DemographicbySchedule_Demographics]
AS
SELECT 
 
	PT.PersonUID AS PersonUID,
	P.SocialSecurityNumber AS SSN,
	Pt.MedicalRecordNumber AS MRN,
	dbo.UDF_getFormattedPreferredNameFromValues(P1.Firstname,P1.LastName,P1.MiddleName,P1.Suffix) AS ProviderName,
	P.BirthDate AS DOB,
	LG.Name AS Gender,
	LMS.Name AS MaritalStatus,
	p.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') AS PrimaryAddress1,
	p.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') AS PrimaryAddress2,
	p.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)'') AS City1,
	p.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)'') AS State1,
	p.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')AS ZIP1,
	p.Address1.value(''(/Address/Country)[1]'', ''VARCHAR(100)'') AS Country1,
	p.Address2.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') AS SecondaryAddress1,
	p.Address2.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') AS SecondaryAddress2,
	p.Address2.value(''(/Address/City)[1]'', ''VARCHAR(100)'') AS City2,
	p.Address2.value(''(/Address/State)[1]'', ''VARCHAR(100)'') AS State2,
	p.Address2.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') AS ZIP2,
	p.Address2.value(''(/Address/Country)[1]'', ''VARCHAR(100)'') AS Country2,
	P.Notes AS Notes,
	P.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone1,
	P.Phone2.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone2,
	P.Phone3.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone3,
	P.Phone4.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone4,
	P.Phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone1Type,
	P.Phone2.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone2Type,
	P.Phone3.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone3Type,
	P.Phone4.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone4Type,
	P.Email1 AS Email,
	LL.Name AS [Language],
	(select stuff((select '', '' + lr.Name
			FROM  RelPersonRace pr  WITH (NOLOCK)
			INNER Join ListRace lr on lr.RaceUid = pr.RaceUid
			Where pr.PersonUid = pt.personuid
			FOR xml path('''')),1,1,'''')) AS Race,
	(select stuff((select '', '' + le.Name --PRM2017!!!
			FROM  RelPersonEthnicity pe  WITH (NOLOCK)
			INNER Join ListEthnicity le on le.EthnicityUid = pe.EthnicityUid
			Where pe.PersonUid = pt.personuid
			FOR xml path('''')),1,1,'''')) AS Ethnicity,
	LDH.Name AS DominantHand,
	P.DriverLicenseNumber AS DrivingLicense,
	RPS.PatientStatus AS PatientStatus,
	PT.ScannedChartDate AS OriginalChartScanned,
	PT.ReleaseDate AS ReleaseSignedDate
FROM
	Patient PT   WITH (NOLOCK)
LEFT JOIN
	Person P   WITH (NOLOCK)
ON
	P.PersonUID=Pt.PersonUID
LEFT JOIN
	ListGender LG  WITH (NOLOCK)
ON
	P.GenderUID=LG.GenderUID
LEFT JOIN
	ListMaritalStatus LMS  WITH (NOLOCK)
ON	
	P.MaritalStatusUID=LMS.MaritalStatusUID
LEFT JOIN
	ListLanguage LL  WITH (NOLOCK)
ON
	P.LanguageUID=LL.LanguageUID
LEFT JOIN
	RelPersonRace LR  WITH (NOLOCK) ON P.PersonUid=LR.PersonUid
LEFT JOIN
	ListDominantHand LDH  WITH (NOLOCK)
ON
	P.DominantHandUID=LDH.DominantHandUID
LEFT JOIN
	MDOL_RPT2_VIEW_PatientStatus RPS  WITH (NOLOCK)
ON	
	P.PersonUID=RPS.PatientUID

LEFT JOIN 
	Person P1  WITH (NOLOCK)
ON	
	PT.ProviderUID=P1.PersonUID






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountResponsiblePartyAggregateCompleteBatch]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewAccountResponsiblePartyAggregateCompleteBatch] 
AS
SELECT AC.AccountResponsiblePartyUid, 
	SUM(ISNULL(VSA.Liability,0)) AS Liability, 
	SUM(ISNULL(VSA.AssignedLiability,0)) AS AssignedLiability,
	SUM(ISNULL(VSA.LiabilityBalance,0)) AS LiabilityBalance, 
	SUM(ISNULL(VSA.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance
FROM Account AC 
JOIN Superbill SB ON AC.AccountUid = SB.AccountUid
JOIN [AR_ViewSuperbillAggregateCompleteBatch] VSA ON SB.SuperbillUid = VSA.SuperbillUid
--JOIN [AR_ViewSuperbillCompleteBatch] SBC ON SB.SuperbillUid = SBC.SuperbillUid
--WHERE SBC.CompleteBatch=1
GROUP BY AC.AccountResponsiblePartyUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessagesPrescriptionEligilibility]'))
EXEC dbo.sp_executesql @statement = N'
CREATE view [dbo].[ViewMessagesPrescriptionEligilibility] as
select * from ViewMessagesEligibilityRx
union all
select * from ViewMessagesMedicationHx

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEWReferringProviderAnalysis_EXCEL]'))
EXEC dbo.sp_executesql @statement = N'




--10/12/2017  Chayes bug # 59925. excel version of report was not getting Sbs by referral source if they also had no referring provider
--10/19/2017  CHayes Bug # 60219. excel version of report not getting all superbills when Provider Option set to Billing corrected Billing provider to come 
							    --from LedgerDetail.Claiming provider instead of Superbill.DefaultClaimingProvider
--05/07/2018  CHayes TFS 2795. add service date to output on excel version of report 

CREATE View [dbo].[MDOL_RPT2_VIEWReferringProviderAnalysis_EXCEL]
AS	
	Select
		LS.Name as ServiceSiteName,
		FC.Name as FinancialCenterName,
		dbo.UDF_GetFormattedPreferredName(COALESCE(LD.RenderingProviderUid , LD.ClaimingProviderUid)) as Provider,
		dbo.UDF_GetFormattedPreferredName(SB.ReferringProviderUID) as ReferringProvider,
		dbo.UDF_GetFormattedPreferredName(SB.PatientUID) as Patient,
		PAT.BirthDate,
		isnull(SB.ExternalID,'''') as ExternalID,
		CASE WHEN L.EntryType=1 OR L.EntryType=4 THEN ISNULL(LD.Amount, 0) ELSE 0 END AS Charge,
		CASE WHEN L.EntryType=2 AND LD.IsCredit=1  THEN -1 * ISNULL(LD.Amount, 0) ELSE 0 END AS Payment,
		CASE WHEN L.EntryType=3 AND LD.IsCredit=1  THEN -1 * ISNULL(LD.Amount, 0) ELSE 0 END AS Adjustment,		
		(Case 
			 When LD.RenderingProviderUID IS NOT NULL AND LD.ClaimingProviderUid IS NOT NULL Then ''A''
			 When LD.RenderingProviderUID IS NOT NULL Then ''R''
			 When LD.ClaimingProviderUid IS NOT NULL Then ''B''
			 Else '''' End) as ProviderType,
		COALESCE(LD.RenderingProviderUid , LD.ClaimingProviderUid) as ProviderUID,
		SB.PatientUID,
		SB.ReferringProviderUID,
		LD.ServiceSiteUID,
		LD.FinancialCenterUID,
		SB.ServiceDateStart,
		SP.ProcedureServiceDateStart,
		ARB.GlDate,
		LRS.ReferralSrcUid,
		LRS.Name AS ReferralSource,
		LP.ProcedureUid AS ProcedureUid,
		COALESCE(LG.ProcedureGroupUid,NULL) as ProcedureGroupUid,
		COALESCE(LG.Name,NULL) as ProcedureGroup,
		LP.Code AS ProcedureCode,
		CASE  WHEN VARB.IsClosed=1 THEN ''Yes'' ELSE ''No'' END AS IsBatchClosed	
	From
		AR_Ledger L WITH (NOLOCK) 
		Join AR_LedgerDetail LD	WITH (NOLOCK) on L.LedgerUid = LD.LedgerUid 
	LEFT JOIN SuperbillProcedure SP WITH (NOLOCK) ON LD.SuperbillProcedureUid = SP.SuperbillProcedureUid 
	LEFT JOIN Superbill SB WITH (NOLOCK) ON SP.SuperbillUid = SB.SuperbillUid 
	Join Person PAT WITH (NOLOCK) on PAT.PersonUID=SB.PatientUID
	Left Join ListServiceSite LS WITH (NOLOCK) ON LS.ServiceSiteUID = LD.ServiceSiteUID
	Left Join FinancialCenter FC with (NOLOCK) on FC.financialcenterUid = LD.FinancialCenterUid
	Left Join ARBatch ARB WITH (NOLOCK) on L.ARBatchUid = ARB.ARBatchUid
	LEFT JOIN AR_ViewBatchClosingsLockedClosed VARB WITH (NOLOCK) ON L.ArBatchUid =VARB.ARBatchUid
	LEFT JOIN ListReferralSrc LRS WITH (NOLOCK) ON SB.ReferralSrcUid = LRS.ReferralSrcUid
	LEFT OUTER JOIN ListProcedure LP WITH (NOLOCK) ON SP.ProcedureUid = LP.ProcedureUid   
	LEFT JOIN ListProcedureGroup LG WITH (NOLOCK) ON LG.ProcedureGroupUID=LP.ProcedureGroupUID
	Where
		SB.ReferringProviderUID IS NOT NULL or sb.referralsrcuid IS NOT NULL







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewReport_Provider]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewReport_Provider] 
AS
Select 
	PersonUid,
	ExternalID,
	Prefix,
	FirstName,
	MiddleName,
	LastName,
	Suffix,
	Inactive,
	ClinicCenterUid,
	ClinicCenter,
	IsActiveUser,
	SpecialtyUid,
	Specialty,
	ConsultingProvider,
	 Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') AS PrimaryAddress1,  
	 Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') AS PrimaryAddress2,  
	 Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)'') AS City1,  
	 Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)'') AS State1,  
	 Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')AS ZIP1,  
	 Address1.value(''(/Address/Country)[1]'', ''VARCHAR(100)'') AS Country1,  
	 Address2.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') AS SecondaryAddress1,  
     Address2.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') AS SecondaryAddress2,  
	 Address2.value(''(/Address/City)[1]'', ''VARCHAR(100)'') AS City2,  
	 Address2.value(''(/Address/State)[1]'', ''VARCHAR(100)'') AS State2,  
	 Address2.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') AS ZIP2,  
	 Address2.value(''(/Address/Country)[1]'', ''VARCHAR(100)'') AS Country2, 	
	 --Address1,
	Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone1,  
	Phone2.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone2,  
	Phone3.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone3,  
	Phone4.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone4,  
	Phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone1Type,  
	Phone2.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone2Type,  
	Phone3.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone3Type,  
	Phone4.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone4Type,  
	--Address2,
	Notes,
	dbo.UDF_getClaimFormatTypeValue(''018E7542-5DE7-405E-9F4A-EE4BFFDE68D4'', PersonUid, NULL,NULL)		AS ProviderDEANumber,
	dbo.UDF_getClaimFormatTypeValue(''2E7C5879-B7DC-4C2F-9E1C-AD157C561C3B'', PersonUid, NULL,NULL)	AS ProviderLicenseNumber,
	dbo.UDF_getClaimFormatTypeValue(''CE282F4E-A866-49BA-9636-C4BA0439E907'', PersonUid, NULL,NULL)		AS ProviderNPINumber
	--
	-- 2010.11.15 - Report Designer needs to be updated to understand an Image data type.
	--              This will be addressed in a future release of the Report Designer.	
	--      
	--,(SELECT TOP 1 Signature 
	--	FROM ProviderSignature
	--	WHERE ProviderSignature.ProviderUid = ViewProvider.PersonUid
	--	AND ProviderSignature.IsPermanentSignature = 1) AS ProviderSignature
From 
	ViewProvider 
	

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewAccountTypeProcedureUnits]'))
EXEC dbo.sp_executesql @statement = N'

--20160217  kculberth add WITH NOLOCKs


CREATE VIEW [dbo].[MDOL_RPT2_ViewAccountTypeProcedureUnits] -----------View for getting units--------------------
AS
SELECT 
	VSFD.RenderingProviderUid,
	P1.LastName + '', '' + P1.FirstName AS RenderingProviderName,
	ISNULL(VSFD.ClaimingProviderUid,VSFD.RenderingProviderUid) AS ClaimingProviderUid,
	(CASE WHEN VSFD.ClaimingProviderUid IS NULL 
	THEN P1.LastName + '', '' + P1.FirstName 
	ELSE P2.LastName + '', '' + P2.FirstName END)ClaimingProviderName,
	FC.FinancialCenterUid,
	ISNULL(FC.Name,''-'') AS FinancialCenterName,	
	SS.ServiceSiteUid,
	ISNULL(SS.Name,''-'') AS ServiceSiteName,	
	LP.ProcedureUid,
	ISNULL(LP.Code,''-'') AS ProcedureCode,
	LPG.ProcedureGroupUid,
	ISNULL(LPG.Name,''UnGrouped'') AS ProcedureGroup,	
	LAT.AccountTypeUid,
	ISNULL(LAT.Name,''N/A'') AS AccountTypeName,	
	SB.ServiceDateStart,
	SB.ServiceDateEnd,
	SB.SuperbillUid,
	SBP.SuperbillProcedureUid,
	ARB.GLDate AS PostingDate,
	SBP.Units
FROM 
	Superbill SB WITH (NOLOCK)
INNER JOIN 
	ViewSuperbillFinancialDetails VSFD 
ON
	SB.SuperbillUid = VSFD.SuperbillUid
INNER JOIN
	SuperbillProcedure SBP WITH (NOLOCK)
ON 
	SB.SuperbillUid=SBP.SuperbillUid 
INNER JOIN
	ListProcedure LP WITH (NOLOCK)  ON SBP.ProcedureUid=LP.ProcedureUid 
LEFT JOIN
	ListProcedureGroup LPG WITH (NOLOCK)
ON 
	LP.ProcedureGroupUid=LPG.ProcedureGroupUid 
LEFT JOIN
	FinancialCenter FC WITH (NOLOCK)
ON 
	FC.FinancialCenterUid=VSFD.FinancialCenterUid 
LEFT JOIN
	ListServiceSite SS WITH (NOLOCK)
ON 
	SS.ServiceSiteUid=VSFD.ServiceSiteUid 
LEFT JOIN
	Account A WITH (NOLOCK)
ON 
	A.AccountUid=SB.AccountUid 
LEFT JOIN   
	AccountPeriod AP WITH (NOLOCK) 
ON   
	AP.AccountUid = A.AccountUid  
	AND (AP.EffectiveDate IS NULL OR AP.EffectiveDate <= SB.ServiceDateEnd)  
	AND (AP.ExpirationDate IS NULL OR AP.ExpirationDate >= SB.ServiceDateEnd) 
LEFT JOIN 
	ListAccountType LAT WITH (NOLOCK)
ON 
	AP.AccountTypeUid=LAT.AccountTypeUid 
LEFT JOIN 
	ARBatch ARB WITH (NOLOCK)
ON 
	ARB.ARBatchUid=SB.ARBatchUid 
LEFT JOIN 
	Person P1 WITH (NOLOCK)
ON 
	P1.PersonUid=VSFD.RenderingProviderUid 
LEFT JOIN 
	Person P2 WITH (NOLOCK)
ON 
	P2.PersonUid =VSFD.ClaimingProviderUid 





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewBatchProcessDetailCreditCardConsentsPaymentDistributions]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewBatchProcessDetailCreditCardConsentsPaymentDistributions]

AS

WITH cteSuperbillStrings AS
(
SELECT BatchProcessDetailUid,  
	Superbills.value(''.'',''VARCHAR(500)'') as SuperbillUidString,
	Superbills.value(''./@AmountApplied'',''VARCHAR(500)'') as AmountAppliedString,
	Superbills.value(''./@TransactionUid'',''VARCHAR(500)'') as TransactionUidString,
	Superbills.value(''./@TransactionReferenceNumber'',''VARCHAR(500)'') as TransactionReferenceNumber
	        
FROM BatchProcessDetail 
	CROSS APPLY IntermediateXML.nodes(''GeneratedDocument/Superbills/Superbill'') AS T1(Superbills)
), 
cteSuperbill AS
(
	SELECT BatchProcessDetailUid, CAST(cteSS.SuperbillUidString AS UNIQUEIDENTIFIER) AS SuperbillUid,
			CAST(CASE WHEN ISNUMERIC(cteSS.AmountAppliedString)=1 THEN  cteSS.AmountAppliedString ELSE NULL END AS MONEY) AS AmountApplied,
			CAST(cteSS.TransactionUidString AS UNIQUEIDENTIFIER) AS TransactionUid, cteSS.TransactionReferenceNumber
		FROM cteSuperbillStrings cteSS 
)
SELECT cteSB.SuperbillUid, SB.ExternalID, cteSB.BatchProcessDetailUid,  SB.ServiceDateStart, 
		CAST(CASE WHEN cteSB.AmountApplied > 0 THEN cteSB.AmountApplied ELSE NULL END AS MONEY) AS AmountApplied,
		VP.PersonUid,
		VP.FullName AS PatientFulName,
		cteSB.TransactionUid,
		cteSB.TransactionReferenceNumber
	FROM cteSuperbill cteSB
		INNER JOIN Superbill SB ON cteSB.SuperbillUid = SB.SuperbillUid
		INNER JOIN ViewPerson VP ON SB.PatientUid = VP.PersonUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPayerCurrentCarrierExtended]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewSuperbillPayerCurrentCarrierExtended] AS
SELECT NEWID() AS ViewSuperbillPayerCurrentCarrierExtendedUid, s.ExternalID, s.SuperbillUid, s.PatientUid, s.RenderingProviderUid, s.ClaimingProviderUid, 
  s.SuperbillStatusUid, s.ServiceDateStart, s.ServiceDateEnd, s.FirstFiledDate, s.LastFiledDate, s.ServiceSiteUid, s.PatientName, s.RenderingProviderName, 
  s.ClaimingProviderName, s.SuperbillStatusName, s.ServiceSiteName, s.AccountUid, s.VisitUid, s.VisitDate, s.ClaimPaper, s.LastModifiedByUid, s.TotalCharge, 
  s.IsPosted, s.FinancialCenterUid, s.AccountName, s.CurrentCarrier AS InsuranceOrder, s.InsuredPersonUid, s.InsuredCorporationUid, s.InsuredName, 
  s.AuthorizeAssignment, s.PlanMemberID, s.PlanGroupID, s.InsuranceCarrierUid, s.InsurancePlanUid, s.InsurancePlanName, s.PayerName, s.InsuranceLevelName, 
  s.Capitated, s.Errors, s.Warnings, s.ClaimFormatUid, s.ClaimClearingHouseUid, s.ClaimClearingHouse, lcf.Name AS ClaimFormat, lcft.ClaimFormatTypeUid, 
  lcft.Name AS ClaimFormatType, lcft.IsPaper AS ClaimFormatTypeIsPaper, VSA.LiabilityBalance - VSA.AssignedLiabilityBalance AS PatientResponsibility, 
  VSA.AssignedLiabilityBalance AS InsuranceResponsibility, VSA.LiabilityBalance AS TotalLiability, SA.LastInsurancePaymentAmount AS LastInsurancePayment,
  SA.LastInsurancePaymentDate, SA.LastPatientPaymentAmount AS LastPatientPayment, SA.LastPatientPaymentDate, s.PrimaryInsurancePlanUid,
  pip.Name AS PrimaryInsurancePlan, s.AccountTypeUid, s.Notes, s.Arbatchuid AS ARBatchUid, cfl.ClaimFormLayoutUid, cfl.Name as ClaimFormLayout,
  CAST(0 as bit) as Inactive, CAST(0 as bit) AS ARLocked, VSF.LastFollowupModifiedByUid, VSF.LastFollowupModifiedDate, VSF.LastFollowupByUser,
  VSF.LastFollowupAll, VSF.MaxFollowupModifiedDate
FROM dbo.ViewSuperbillPayerWithoutClaimFormat AS s 
  INNER JOIN dbo.SuperbillAggregate AS SA ON s.superbillUid = SA.SuperbillUid 
  INNER JOIN dbo.AR_ViewSuperbillAggregate AS VSA ON s.superbillUid = VSA.SuperbillUid 
  LEFT OUTER JOIN dbo.ListClaimFormat AS lcf ON lcf.ClaimFormatUid = s.ClaimFormatUid 
  LEFT OUTER JOIN dbo.ListClaimFormatType AS lcft ON lcft.ClaimFormatTypeUid = lcf.ClaimFormatTypeUid 
  LEFT OUTER JOIN dbo.ViewInsurancePlan AS pip ON s.PrimaryInsurancePlanUid = pip.InsurancePlanUid
  LEFT OUTER JOIN ClaimFormatOption cfo ON lcf.ClaimFormatUid = cfo.ClaimFormatUid	-- Scenario 39252: Set custom payer claim layout		
    AND cfo.ClaimFormatOptionTypeUid in (	''85912913-6DF7-46FD-BA9C-47788EBC347C'', -- Paper CMS-1500 5010
      ''213406F9-EB44-46AE-A85B-E75082C7BD41'', -- Paper ADA 2006
      ''5A04B8A3-CD89-4873-B639-43015702B181'', -- Paper CMS-1500
      ''FC409618-D134-4225-93C3-629566A3DA0B'') -- Paper UB04
  LEFT OUTER JOIN ListClaimFormLayout cfl ON cfo.ClaimFormatValueTypeUid = cfl.ClaimFormLayoutUid
  LEFT JOIN ViewSuperbillFollowup VSF ON s.SuperbillUid = VSF.SuperbillUid
WHERE (s.CurrentCarrier = s.InsuranceOrder)' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillBatches]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewSuperbillBatches] 
AS

SELECT SuperbillUid, MAX(ArBatchPostingDate) AS MaxPostingDate, MIN(ArBatchPostingDate) AS MinPostingDate
	FROM AR_ViewSuperbillProcedureBatch SPB
	GROUP BY SuperbillUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_GetInsuranceName]'))
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[MDOL_RPT2_View_GetInsuranceName]
AS
SELECT 
SB.SuperbillUid AS SuperbillUid,
LD.InsurancePlanUid AS InsurancePlanUid 

FROM 
	dbo.AR_LedgerDetail LD WITH (NOLOCK)  
INNER JOIN 
	dbo.AR_Ledger L WITH (NOLOCK) 
ON 
	LD.LedgerUid = L.LedgerUid
LEFT JOIN
	SuperbillProcedure SBP WITH (NOLOCK) 
ON 
	LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid 
LEFT JOIN
	Superbill SB WITH (NOLOCK) 
ON
	SBP.SuperbillUid = SB.SuperbillUid 
WHERE 
	NOT LD.InsurancePlanUid IS NULL AND NOT LD.SuperbillProcedureUid IS NULL 
AND
	L.EntryType = 1
GROUP BY 
	SB.SuperbillUid, 
	LD.InsurancePlanUid
	



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillProcedureDiagnosis]'))
EXEC dbo.sp_executesql @statement = N'




--20150611 kculberth updated for ICD10


CREATE VIEW [dbo].[ViewSuperbillProcedureDiagnosis]
AS
WITH cteSuperbillProcedureDiagnosis
AS
(
SELECT SBP.SuperbillProcedureUid, SBP.SuperbillUid,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer1) AS DiagnosisCode1, 
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer2) AS DiagnosisCode2, 
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer3) AS DiagnosisCode3, 
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer4) AS DiagnosisCode4, 
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer5) AS DiagnosisCode5, 
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer6) AS DiagnosisCode6, 
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer7) AS DiagnosisCode7, 
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer8) AS DiagnosisCode8,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer9) AS DiagnosisCode9,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer10) AS DiagnosisCode10,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer11) AS DiagnosisCode11,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer12) AS DiagnosisCode12,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer13) AS DiagnosisCode13,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer14) AS DiagnosisCode14,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer15) AS DiagnosisCode15,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer16) AS DiagnosisCode16,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer17) AS DiagnosisCode17,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer18) AS DiagnosisCode18,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer19) AS DiagnosisCode19,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer20) AS DiagnosisCode20,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer21) AS DiagnosisCode21,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer22) AS DiagnosisCode22,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer23) AS DiagnosisCode23,
	(SELECT TOP 1 ISNULL(Code10,Code9) FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer24) AS DiagnosisCode24,
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)  
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer1) AS DiagnosisPt1,
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer2) AS DiagnosisPt2, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer3) AS DiagnosisPt3, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer4) AS DiagnosisPt4, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer5) AS DiagnosisPt5, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer6) AS DiagnosisPt6, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer7) AS DiagnosisPt7, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer8) AS DiagnosisPt8, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer9) AS DiagnosisPt9, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer10) AS DiagnosisPt10, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer11) AS DiagnosisPt11, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer12) AS DiagnosisPt12, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer13) AS DiagnosisPt13, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer14) AS DiagnosisPt14, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer15) AS DiagnosisPt15, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer16) AS DiagnosisPt16, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer17) AS DiagnosisPt17, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer18) AS DiagnosisPt18, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer19) AS DiagnosisPt19, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer20) AS DiagnosisPt20, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer21) AS DiagnosisPt21, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer22) AS DiagnosisPt22, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer23) AS DiagnosisPt23, 
	(SELECT TOP 1 DisplayOrder FROM SuperbillDiagnosis(NOLOCK)
		WHERE SuperbillUid = SBP.SuperbillUid AND DisplayOrder = SBP.DiagnosisPointer24) AS DiagnosisPt24                                  
	FROM SuperbillProcedure(NOLOCK) SBP
)

--SELECT * FROM cteSuperbillProcedureDiagnosis where superbillprocedureuid in(''222007B9-8E74-4087-96E1-E45203DC0AB0'') 

SELECT SPD.SuperbillProcedureUid,
			DiagnosisCode1, DiagnosisPt1,
			DiagnosisCode2,DiagnosisPt2,
			DiagnosisCode3,DiagnosisPt3,
			DiagnosisCode4,DiagnosisPt4,
			DiagnosisCode5,DiagnosisPt5,
			DiagnosisCode6,DiagnosisPt6,
			DiagnosisCode7,DiagnosisPt7,
			DiagnosisCode8,DiagnosisPt8,
			DiagnosisCode9,DiagnosisPt9,
			DiagnosisCode10,DiagnosisPt10,
			DiagnosisCode11,DiagnosisPt11,
			DiagnosisCode12,DiagnosisPt12,
			DiagnosisCode13,DiagnosisPt13,
			DiagnosisCode14,DiagnosisPt14,
			DiagnosisCode15,DiagnosisPt15,
			DiagnosisCode16,DiagnosisPt16,
			DiagnosisCode17,DiagnosisPt17,
			DiagnosisCode18,DiagnosisPt18,
			DiagnosisCode19,DiagnosisPt19,
			DiagnosisCode20,DiagnosisPt20,
			DiagnosisCode21,DiagnosisPt21,
			DiagnosisCode22,DiagnosisPt22,
			DiagnosisCode23,DiagnosisPt23,
			DiagnosisCode24,DiagnosisPt24,
			CASE WHEN DiagnosisCode1 is NOT NULL THEN DiagnosisCode1 ELSE '''' END  +  
			CASE WHEN DiagnosisCode2 is NOT NULL THEN '','' + cast(DiagnosisCode2 as varchar) ELSE '''' END  +
			CASE WHEN DiagnosisCode3 is NOT NULL THEN '','' + cast(DiagnosisCode3 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode4 is NOT NULL THEN '','' + cast(DiagnosisCode4 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode5 is NOT NULL THEN '','' + cast(DiagnosisCode5 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode6 is NOT NULL THEN '','' + cast(DiagnosisCode6 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode7 is NOT NULL THEN '','' + cast(DiagnosisCode7 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode8 is NOT NULL THEN '','' + cast(DiagnosisCode8 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode9 is NOT NULL THEN '','' + cast(DiagnosisCode9 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode10 is NOT NULL THEN '','' + cast(DiagnosisCode10 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode11 is NOT NULL THEN '','' + cast(DiagnosisCode11 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode12 is NOT NULL THEN '','' + cast(DiagnosisCode12 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode13 is NOT NULL THEN '','' + cast(DiagnosisCode13 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode14 is NOT NULL THEN '','' + cast(DiagnosisCode14 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode15 is NOT NULL THEN '','' + cast(DiagnosisCode15 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode16 is NOT NULL THEN '','' + cast(DiagnosisCode16 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode17 is NOT NULL THEN '','' + cast(DiagnosisCode17 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode18 is NOT NULL THEN '','' + cast(DiagnosisCode18 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode19 is NOT NULL THEN '','' + cast(DiagnosisCode19 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode20 is NOT NULL THEN '','' + cast(DiagnosisCode20 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode21 is NOT NULL THEN '','' + cast(DiagnosisCode21 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode22 is NOT NULL THEN '','' + cast(DiagnosisCode22 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode23 is NOT NULL THEN '','' + cast(DiagnosisCode23 as varchar) ELSE ''''  END  +
			CASE WHEN DiagnosisCode24 is NOT NULL THEN '','' + cast(DiagnosisCode24 as varchar) ELSE ''''  END  as Diagnosis,
			
			CASE WHEN DiagnosisCode1 is NOT NULL THEN		cast(DiagnosisPt1 as varchar) ELSE '''' END  +  
			CASE WHEN DiagnosisCode2 is NOT NULL THEN '','' + cast(DiagnosisPt2 as varchar) ELSE '''' END  +
			CASE WHEN DiagnosisCode3 is NOT NULL THEN '','' + cast(DiagnosisPt3 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode4 is NOT NULL THEN '','' + cast(DiagnosisPt4 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode5 is NOT NULL THEN '','' + cast(DiagnosisPt5 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode6 is NOT NULL THEN '','' + cast(DiagnosisPt6 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode7 is NOT NULL THEN '','' + cast(DiagnosisPt7 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode8 is NOT NULL THEN '','' + cast(DiagnosisPt8 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode9 is NOT NULL THEN '','' + cast(DiagnosisPt9 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode10 is NOT NULL THEN '','' + cast(DiagnosisPt10 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode11 is NOT NULL THEN '','' + cast(DiagnosisPt11 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode12 is NOT NULL THEN '','' + cast(DiagnosisPt12 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode13 is NOT NULL THEN '','' + cast(DiagnosisPt13 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode14 is NOT NULL THEN '','' + cast(DiagnosisPt14 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode15 is NOT NULL THEN '','' + cast(DiagnosisPt15 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode16 is NOT NULL THEN '','' + cast(DiagnosisPt16 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode17 is NOT NULL THEN '','' + cast(DiagnosisPt17 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode18 is NOT NULL THEN '','' + cast(DiagnosisPt18 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode19 is NOT NULL THEN '','' + cast(DiagnosisPt19 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode20 is NOT NULL THEN '','' + cast(DiagnosisPt20 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode21 is NOT NULL THEN '','' + cast(DiagnosisPt21 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode22 is NOT NULL THEN '','' + cast(DiagnosisPt22 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode23 is NOT NULL THEN '','' + cast(DiagnosisPt23 as varchar) ELSE ''''  END  + 
			CASE WHEN DiagnosisCode24 is NOT NULL THEN '','' + cast(DiagnosisPt24 as varchar) ELSE ''''  END		as DiagnosisPointer
	FROM cteSuperbillProcedureDiagnosis SPD
	
	




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_BillingAnalysis]'))
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[MDOL_RPT2_View_BillingAnalysis]
AS 
	SELECT DISTINCT
		S.RenderingProviderName,
		S.ClaimingProviderName,
		S.PayerName,
		S.InsurancePlanName as PlanName,
		S.PatientName,
		S.ExternalID as SuperbillID,
		S.SuperbillUID,
		S.ServiceDateStart as ServiceDate,
		VSB.MaxPostingDate as PostingDate,  
		S.SuperbillStatusName,
		(S.ServiceSiteName + '', '' + LS.Ansicode) as ServiceSite,
		FC.Name AS FinancialCenter,
		LP.Code as [Procedure],
		CASE WHEN VSP.DiagnosisCode1 is NOT NULL THEN VSP.DiagnosisCode1 ELSE '''' END  +  
		CASE WHEN VSP.DiagnosisCode2 is NOT NULL THEN '','' + cast(VSP.DiagnosisCode2 as varchar) ELSE '''' END  +
		CASE WHEN VSP.DiagnosisCode3 is NOT NULL THEN '','' + cast(VSP.DiagnosisCode3 as varchar) ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode4 is NOT NULL THEN '','' + cast(VSP.DiagnosisCode4 as varchar) ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode5 is NOT NULL THEN '','' + cast(VSP.DiagnosisCode5 as varchar) ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode6 is NOT NULL THEN '','' + cast(VSP.DiagnosisCode6 as varchar) ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode7 is NOT NULL THEN '','' + cast(VSP.DiagnosisCode7 as varchar) ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode8 is NOT NULL THEN '','' + cast(VSP.DiagnosisCode8 as varchar) ELSE ''''  END  as Diagnosis,
		
		CASE WHEN VSP.DiagnosisCode1 is NOT NULL THEN Cast(DiagnosisPt1 as varchar) ELSE '''' END  +  
		CASE WHEN VSP.DiagnosisCode2 is NOT NULL THEN '','' + cast(DiagnosisPt2 as varchar)  ELSE '''' END  +
		CASE WHEN VSP.DiagnosisCode3 is NOT NULL THEN '','' + cast(DiagnosisPt3 as varchar) ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode4 is NOT NULL THEN '','' + cast(DiagnosisPt4 as varchar) ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode5 is NOT NULL THEN '','' + cast(DiagnosisPt5 as varchar) ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode6 is NOT NULL THEN '','' + cast(DiagnosisPt6 as varchar) ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode7 is NOT NULL THEN '','' + cast(DiagnosisPt7 as varchar)  ELSE ''''  END  + 
		CASE WHEN VSP.DiagnosisCode8 is NOT NULL THEN '','' + cast(DiagnosisPt8 as varchar)  ELSE ''''  END  as DiagnosisPointer,

		LG.Name as ProcedureGroup,
		dbo.GetModifierForSuperbillProcedure(SP.SuperbillProcedureUID) as Modifier,
		AT.Name as AccountType,
		--SP.ProcedureCharge,
		SP.TotalCharge as ProcedureCharge,
		S.RenderingProviderUID,
		S.ClaimingProviderUID,
		S.InsuranceCarrierUID,
		S.InsurancePlanUID,
		S.ServiceSiteUID,
		S.FinancialCenterUID,
		LP.ProcedureUID,
		LP.ProcedureGroupUID,
		AP.AccountTypeUID,
		SP.SuperbillProcedureUID,
		SPB.IsBatchClosed
	FROM
		ViewSuperbillPayer S WITH (NOLOCK) 
	LEFT JOIN
		ListServiceSite SS WITH (NOLOCK) 
	ON
		SS.ServiceSiteUID=S.ServiceSiteUID
	LEFT JOIN
		ListServiceSiteType LS WITH (NOLOCK) 
	ON
		LS.ServiceSiteTypeUID=SS.ServiceSiteTypeUID
	LEFT JOIN
		SuperbillProcedure SP WITH (NOLOCK) 
	ON
		SP.SuperbillUID=S.SuperbillUID 
	LEFT JOIN
		[MDOL_RPT2_VIEW_SuperbillProcedureBatch] SPB WITH (NOLOCK) 
	ON
		SP.SuperbillProcedureUid = SPB.SuperbiLlProcedureUid
	JOIN 
		[AR_ViewSuperbillBatches] VSB WITH (NOLOCK) 
	ON 
		SP.SuperbillUid = VSB.SuperbillUid 
	LEFT JOIN
		ListProcedure LP WITH (NOLOCK) 
	ON
		LP.ProcedureUID=SP.ProcedureUID AND LP.Inactive=0
	LEFT JOIN
		ListProcedureGroup LG WITH (NOLOCK) 
	ON
		LG.ProcedureGroupUID=LP.ProcedureGroupUID
		
	LEFT JOIN ViewSuperbillProcedureDiagnosis VSP WITH (NOLOCK) 	
	ON
		SP.SuperbillProcedureUid =VSP.SuperbillProcedureUid
	LEFT JOIN
		SuperbillDiagnosis SD WITH (NOLOCK) 
	ON
		SD.SuperbillUID=S.SuperbillUID AND SD.DisplayOrder=SP.DiagnosisPointer1
	LEFT JOIN
		Account Ac WITH (NOLOCK) 
	ON
		Ac.AccountUID=S.AccountUID
	 left join AccountPeriod ap WITH (NOLOCK)  on    
	  ac.AccountUid = ap.AccountUid    
	  and (ap.EffectiveDate is null or ap.EffectiveDate <= S.ServiceDateEnd)    
	  and (ap.ExpirationDate is null or DateAdd(dd, 1, ap.ExpirationDate) > S.ServiceDateEnd) 
	LEFT JOIN
		ListAccountType AT WITH (NOLOCK) 
	ON
		AT.AccountTypeUID=AP.AccountTypeUID
	LEFT JOIN 
		FinancialCenter FC WITH (NOLOCK) 
	ON 
		S.FinancialCenterUid = FC.FinancialCenterUid
	 LEFT JOIN
		MDOL_RPT2_View_GetInsuranceName GIN WITH (NOLOCK) 
	ON
		S.SuperbillUID = GIN.SuperbillUID
	WHERE
		S.InsuranceOrder<=1








' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewPatientRecallSummary]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[MDOL_RPT2_ViewPatientRecallSummary]
AS
    WITH CTE_ReturnUintID AS (
		   SELECT *
		   FROM (
			   VALUES
			   (''1'',''day'',''1'')
			   ,(''2'',''week'',''7'')
			   ,(''3'',''month'',''30'')
			   ,(''4'',''year'',''365'')
			   ) AS T(ReturnUnitID,datepartname,multiplier)
	),
	CTE_FollowUpDate as (
	SELECT vplan.VisitUid
		  ,DATEADD(day,(COALESCE(vplan.ReturnNum,1)*COALESCE(u.multiplier,1)),COALESCE(v.VisitDate,a.StartDateTime)) AS FollowupDate
	FROM VisitPlan vplan WITH (NOLOCK)
	INNER JOIN Visit v WITH (NOLOCK) ON vplan.VisitUid=v.VisitUid
	AND (
		v.visittypeuid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96'' --@visitTypeStrikeOut
		OR v.visittypeuid IS NULL
		)
	LEFT JOIN Appointment a WITH (NOLOCK) ON vplan.FUAppointmentUid=a.AppointmentUid
	LEFT JOIN CTE_ReturnUintID u ON vplan.ReturnUnitID=u.ReturnUnitID
	WHERE (vplan.ReturnNum IS NOT NULL OR vplan.ReturnUnitID IS NOT NULL)
		AND (COALESCE(vplan.ReturnNum,1) * COALESCE(vplan.ReturnUnitID,1)) > 0 
	UNION
	SELECT vpd.VisitUid
	      ,DateDue as FollowupDate
	FROM  PatientRecall PR WITH (NOLOCK)
	INNER JOIN VisitPlanDiagnosis vpd WITH (NOLOCK) on vpd.RecallUid = pr.PatientRecallUid
	)

	SELECT Pt.Inactive
		,Ap.StartDateTime
		,patient.FormattedPreferredName AS PatientName
		,Pt.ExternalID
		,V.RenderingProviderUid AS ProviderUid
		,rp.FormattedPreferredName AS ProviderName
		,patient.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS PhoneNumber
		,0 AS ReturnUnitID -- not used in RDL
		,0 AS ReturnNum -- not used in RDL
		,V.isCompleted
		,cte.FollowupDate
		,(
			SELECT MIN(StartDateTime)
			FROM dbo.Appointment AS Ap1 WITH (NOLOCK) 
			LEFT JOIN ListAppointmentStatus LAS ON LAS.AppointmentStatusUid=AP1.AppointmentStatusUid 
			WHERE (AP1.PatientUid = v.PatientUid) 
				AND ((AP1.StartDateTime > Ap.StartDateTime) OR (AP1.StartDateTime > V.VisitDate))
				AND las.IsCanceledStatus = 0 
			) AS NextFutureAppointment
		,(
			SELECT TOP 1 PlanComment
			FROM VisitComment VC WITH (NOLOCK)
			WHERE VC.VisitUID = V.VisitUID
			) AS PlanComment
		,LS.NAME AS Clinic
		,patient.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') AS PatientAddress1
		,patient.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') AS PatientAddress2
		,patient.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)'') AS PatientCity
		,patient.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)'') AS PatientState
		,patient.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') AS PatientZip
		--las.IsCanceledStatus 
	FROM dbo.Visit AS V WITH (NOLOCK)
	INNER JOIN ViewPerson patient WITH (NOEXPAND,NOLOCK) ON patient.personuid = v.patientuid
	INNER JOIN ViewPerson RP WITH (NOEXPAND,NOLOCK) on RP.personuid = v.RenderingProviderUid
	LEFT JOIN dbo.Appointment AS Ap WITH (NOLOCK) ON V.AppointmentUid = Ap.AppointmentUid
	LEFT JOIN CTE_FollowUpDate AS cte ON cte.VisitUid = V.VisitUid
	LEFT JOIN dbo.Patient AS Pt WITH (NOLOCK) ON Pt.PersonUid = V.PatientUid
	LEFT JOIN dbo.ListServiceSite AS LS WITH (NOLOCK) ON LS.ServiceSiteUid = V.ServiceSiteUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPatientAggregate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewPatientAggregate] 
AS
SELECT PA.PersonUid as PatientUid, 
      SUM(ISNULL(VSPAB.Liability,0)) AS Liability, SUM(ISNULL(VSPAB.AssignedLiability,0)) AS AssignedLiability,
      SUM(ISNULL(VSPAB.LiabilityBalance,0)) AS LiabilityBalance, SUM(ISNULL(VSPAB.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance
FROM Patient PA
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON PA.PersonUid = VSPAB.PersonUid
GROUP BY PA.PersonUid 

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewClaimedSuperbill]'))
EXEC dbo.sp_executesql @statement = N'








CREATE VIEW [dbo].[ViewClaimedSuperbill]  
AS
SELECT	cb.ClaimBatchUid, cb.ClaimFormatTypeUid, lcf.Name AS ClaimFormat, cb.ClaimDate, vsb.FirstFiledDate, vsb.LastFiledDate, 
		p.FullName AS ClaimingUserName, 
		cb.ClaimingUserUid, cbd.ClaimBatchDetailUid, vsb.SuperbillStatusName AS SuperbillStatus, vsb.SuperbillStatusName AS ClaimStatus, 
		cbd.Status AS ClaimBatchDetailStatus, cbd.SuperbillUid, vsb.ExternalID, 
		vsb.PatientUid, vsb.RenderingProviderUid, vsb.ClaimingProviderUid, vsb.ServiceDateStart, vsb.ServiceSiteUid, 
		vsb.PatientName, vsb.RenderingProviderName, vsb.LastModifiedByUid, vsb.ClaimingProviderName, 
		vsb.ServiceSiteName, vsb.SuperbillStatusUid, cbd.InsurancePlanUid, c.Name AS PayerName, 
		cb.InsuranceOrder, ISNULL(ILN.InsuranceLevelName,'''') AS InsuranceOrderName,
		ip.InsuranceCarrierUid, lep.ClaimClearingHouseUid as ClaimClearingHouseUid, lcch.Name as ClaimClearingHouse, 
		vsb.FinancialCenterUid, vsb.TotalCharge, vsb.ClaimPaper, 
		CASE WHEN ip.UseInsuranceCarrierAccountType=1 then ins.AccountTypeUid else ip.AccountTypeUid end as AccountTypeUid ,
		vsb.AccountUid, vsb.ServiceDateEnd, vsb.VisitUid, vsb.VisitDate, vsb.IsPosted, vsb.ARBatchUid, vsb.Notes, 
		vsb.MaxPostingDate, vsb.MinPostingDate
FROM	ClaimBatch AS cb 
		LEFT JOIN ListInsuranceLevelName ILN ON cb.InsuranceOrder = ILN.InsuranceLevel
		INNER JOIN ClaimBatchDetail AS cbd ON cb.ClaimBatchUid = cbd.ClaimBatchUid 
		INNER JOIN InsurancePlan AS ip ON cbd.InsurancePlanUid = ip.InsurancePlanUid 
		INNER JOIN ViewSuperbill AS vsb ON cbd.SuperbillUid = vsb.superbillUid 
		INNER JOIN ViewPerson (NOEXPAND) AS p ON cb.ClaimingUserUid = p.PersonUid 
		INNER JOIN ListClaimFormatType AS lcf ON cb.ClaimFormatTypeUid = lcf.ClaimFormatTypeUid 
		INNER JOIN InsuranceCarrier AS ins ON ip.InsuranceCarrierUid = ins.CorporationUid 
		INNER JOIN Corporation AS c ON ins.CorporationUid = c.CorporationUid 
		LEFT JOIN ListElectronicPayer lep ON lep.ElectronicPayerUid = ins.ElectronicPayerUid 
		LEFT JOIN ListClaimClearingHouse lcch ON lcch.ClaimClearingHouseUid = lep.ClaimClearingHouseUid









' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountPatientResponsiblePartyAggregate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewAccountPatientResponsiblePartyAggregate] 
AS
SELECT AC.AccountUid,
			ISNULL(VAA.Liability,0) AS AccountLiability, ISNULL(VAA.AssignedLiability,0) AS AccountAssignedLiability,
			ISNULL(VAA.LiabilityBalance,0) AS AccountLiabilityBalance, ISNULL(VAA.AssignedLiabilityBalance,0) AS AccountAssignedLiabilityBalance,

			ISNULL(VPA.Liability,0) AS PatientLiability, ISNULL(VPA.AssignedLiability,0) AS PatientAssignedLiability,
			ISNULL(VPA.LiabilityBalance,0) AS PatientLiabilityBalance, ISNULL(VPA.AssignedLiabilityBalance,0) AS PatientAssignedLiabilityBalance,

			ISNULL(VARPA.Liability,0) AS AccountResponsiblePartyLiability, ISNULL(VARPA.AssignedLiability,0) AS AccountResponsiblePartyAssignedLiability,
			ISNULL(VARPA.LiabilityBalance,0) AS AccountResponsiblePartyLiabilityBalance, ISNULL(VARPA.AssignedLiabilityBalance,0) AS AccountResponsiblePartyAssignedLiabilityBalance
FROM Account AC
	INNER JOIN AR_ViewAccountAggregate VAA ON AC.AccountUid = VAA.AccountUid
	INNER JOIN AR_ViewPatientAggregate VPA ON AC.PersonUid = VPA.PatientUid
	INNER JOIN AR_ViewAccountResponsiblePartyAggregate VARPA ON AC.AccountResponsiblePartyUid = VARPA.AccountResponsiblePartyUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_StatementLineItem]'))
EXEC dbo.sp_executesql @statement = N'









CREATE VIEW [dbo].[MDOL_RPT2_VIEW_StatementLineItem]  
AS  
/* Source fOR the line items in the paper and electronic statement.  
 AS of GA5, the paper statement does not use the Header, Comment, AND Subtotal types.  
 gaps have been LEFT in the display ORder fOR adding comment lines at any point.   
 Comments to be mixed in with a certain type should have the same display ORder,  
 e.g., claim filing comments are mixed with payments.  
  
 The primary keys of the biz object view fOR this are ItemUid, SuperbillUid,    
 DisplayOrder, AND CreditSubOrder so make sure this set of four is unique if you   
 update this view.  
  
 Use CreditSubOrder to order items associated with an individual payment OR adjustment  
 credit. Make it less than 2 to precede the payment OR adjustment OR greater than 2  
 to follow it. E.g., a credit statement note follows the credit.  
  
 The intended ORdering for these line items is:  
 ORDER BY RPUid, SuperbillDate asc, SuperbillUid, DisplayOrder asc, ItemDate asc,   
  CreditGroupUid, IsPayment desc, CreditUid, CreditSubOrder asc   
*/  
/*  
 01/24/2008 - Qatalys - Modified to remove GLDate (#13093)  
 05/19/2008 - Qatalys - Modified to include Financial Center  
 08/02/2011 - kbernecker - branched off of ViewStatementLineItem for performance reasons 
 11/15/2011 - kbernecker - remove payment notes (entire "Transfer" section), fixed reference numbers
 7/05/2012 - kbernecker - add payer information
 6/04/2013 - kbernecker - modified to use lastfileddate cte and get insurance plan correctly
 08/12/2013 - kbernecker - fix problem with initial transfers being lost and also get correct insurance payer
 01/28/2014 - kbernecker - fix issue with truly distinct payments and transfers that are being lost because they have the same posting date and reference number. add superbillprocedureuid to criteria.
 01/29/2014 - kbernecker - roll up payments and adjustments to sum them, but not lose the ones that appear to be identical
 09/16/2014 - kbernecker - add more NOLOCKs
 10/08/2014 - kbernecker - use LD.CreatedDateTime instead of ARB.GLDate for payments. Bug 32278.
 10/24/2014 - kbernecker - return ARB.GLDate instead of LD.CreatedDate time for payments. Bug 3323
 20150109 - kculberth - add statement notes from reason codes - bug 33625
 20150421 - kculberth - bug 37045 checking for ClaimDate > ARBatch.GLDate was causing a problem when reference numbers are reused and primary/secondary insurance payers are the same
*/   
--NEW
WITH cteWhoPaidName --Stolen from ViewDeposit
AS
-- Define the CTE query.
(
SELECT d.deposituid,
      ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumber, -- mark as <ND> so can hyperlink on null values
      (CASE WHEN p.PersonUid IS NOT NULL THEN p1.FormattedPreferredName
       WHEN icArp.CorporationUid IS NOT NULL THEN icArp.Name
       WHEN LD.InsurancePayerUid IS NOT NULL THEN ic.Name END) AS WhoPaidName,
       L.EntryType  
FROM Deposit d WITH (NOLOCK)
            INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON d.DepositUid = LD.DepositUid
            INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid
            LEFT OUTER JOIN AR_Ledger arlVoid WITH (NOLOCK) on L.LedgerUid = arlVoid.VoidLedgerUid      -- Checks for voiding entries                                       
            LEFT JOIN AccountResponsibleParty arp WITH (NOLOCK) on LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid            
            LEFT JOIN Person p WITH (NOLOCK) ON arp.PersonUid = p.PersonUid 
            LEFT JOIN Corporation icArp WITH (NOLOCK) ON arp.CorporationUid = icArp.CorporationUid
            LEFT JOIN Corporation ic WITH (NOLOCK) ON ic.CorporationUid = LD.InsurancePayerUid 
            LEFT JOIN ViewPerson p1 WITH (NOLOCK) on p1.personuid = p.PersonUid              
WHERE (L.EntryType = 0 -- Payment
	   OR L.EntryType = 3) -- Adjustment
       AND  (L.VoidLedgerUid IS NULL AND arlVoid.LedgerUid IS NULL) -- Don''t include reversing(void) entries
       AND LD.IsCredit = 1                                              
       AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits    
),
cteLastFiledDate --
AS
-- Define the CTE query.
(
	SELECT SA.SuperbillUid,SA.LastFiledDate,SA.CurrentInsurancePlanUid
	FROM SuperbillAggregate SA WITH (NOLOCK)
)   
SELECT   
 FinancialCenterUid,  
 ItemUid,   
 RPUid,   
 ''Charge'' AS Type,   
 4 AS DisplayOrder,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 NULL AS CreditGroupUid,   
 0 AS IsPayment,   
 NULL AS CreditUid,   
 0 AS CreditSubOrder,   
 '''' AS WhoPaid,   
 Description,   
 Charge,   
 SUM(Insurance) AS Insurance,  
 SUM(Patient) AS Patient,  
 SUM(Amount) AS Amount,  
 --MIN(AGE)  AS Age,  
 age,
 SuperbillProcedureUid,  
 MAX(TotalCharge) TotalCharge,  
 MAX(LastFiledDate) LastFiledDate,  
 '''' AS ReferenceNumber,  
 ReferringProviderName,  
 InsuranacePlan,  
 MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
 1 AS CompleteBatch,
 0 AS DisplayOrder2    
 FROM  
 (  
SELECT   
 LD.FinancialCenterUid,  
 SP.SuperbillProcedureUid AS ItemUid,   
 A.AccountResponsiblePartyUid AS RPUid, 
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName,   
 A.ExternalID AS AccountID,   
 S.ExternalID AS SuperbillID,   
 S.SuperbillUid,   
 S.ServiceDateStart AS SuperbillDate,   
 SP.ProcedureServiceDateStart AS ItemDate,     
 (CASE WHEN (PS.IncludeProcedureCode=1) 
 THEN ISNULL(LP.Code, '''') +ISNULL('' '' + LP.ShortDescription, '''')  
 ELSE ISNULL('' '' + LP.ShortDescription, '''') END) AS Description,   
 COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS Charge,   
 (CASE WHEN LD.LiabilityOwner > 0   THEN LD.Amount ELSE CONVERT(Money, 0) END) AS Insurance,  
 (CASE WHEN LD.LiabilityOwner = 0 THEN LD.Amount ELSE CONVERT(Money, 0) END) AS Patient,  
 ISNULL(LD.Amount,0) AS Amount,  
 --DATEDIFF(DD, (ARB.GLDate), GETUTCDATE())  AS Age, 
 NULL as age, 
 SP.SuperbillProcedureUid,   
 COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS TotalCharge,   
 lfd.LastFiledDate as LastFiledDate,    
 p3.FormattedPreferredName AS ReferringProviderName,
 (SELECT top 1 IP.Name from ClaimBatchDetail CBD WITH (NOLOCK)   
		LEFT JOIN ClaimBatch CB WITH (NOLOCK) ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL
		LEFT JOIN InsurancePlan IP WITH (NOLOCK) ON CBD.InsurancePlanUid = IP.InsurancePlanUid   
		where CBD.SuperbillUid = S.SuperbillUid) as InsuranacePlan,
-- IP.Name as InsuranacePlan,	
 (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) IsSuperbilCompleteBatch,   
 (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch   
FROM
		AR_LedgerDetail LD WITH (NOLOCK)
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid AND (L.EntryType=1 OR L.EntryType=4)		
        LEFT JOIN AR_Ledger LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure SP WITH (NOLOCK) on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill S WITH (NOLOCK) ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid 
		INNER JOIN ListProcedure LP WITH (NOLOCK) ON SP.ProcedureUid = LP.ProcedureUid  		
		LEFT JOIN InsurancePlan IP WITH (NOLOCK) ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation C WITH (NOLOCK) ON IP.InsuranceCarrierUid = C.CorporationUid   
		--LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		--LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
		--			 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK) on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK) on p3.personuid = s.ReferringProviderUid   
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings PS WITH (NOLOCK) 	  	
 WHERE rpsss.superbillstatusuid is null and
	(L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) --AND LD.IsCredit = 0  AND (L.EntryType = 1)
) A   
GROUP BY   
 FinancialCenterUid,  
 ItemUid,   
 RPUid,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 Description,   
 Charge,   
 SuperbillProcedureUid,  
 ReferringProviderName,  
 InsuranacePlan,
 age     
UNION ALL   
select 
	FinancialCenterUid,  
	ItemUid,  
	RPUid,   
	Type,   
	DisplayOrder,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	MIN(ItemDate) AS ItemDate,   
	CreditGroupUid,  
	IsPayment,   
	CreditUid,   
	2 AS CreditSubOrder,   
	WhoPaid,   
	Description,  
	Charge,   
	SUM(Insurance) AS Insurance,   
	SUM(Patient) AS Patient,  
	SUM(Amount) AS Amount,  
	0 AS Age,  
	NULL AS SuperbillProcedureUid,  
	MAX(TotalCharge) AS TotalCharge,  
	MAX(LastFiledDate) AS LastFiledDate,  
	ReferenceNumber,  
	 ReferringProviderName,  
	'''' as InsuranacePlan,  
	MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
	--CASE WHEN AR.IsClosed =1 OR AR.IsLocked =1 THEN 1 ELSE 0 END   
	1 CompleteBatch, 
	DisplayOrder2 
FROM
(
	SELECT DISTINCT  
		FinancialCenterUid,  
		ItemUid,  
		RPUid,   
		Type,   
		CASE WHEN Type=''Payment'' THEN 5 ELSE 6 END AS DisplayOrder,   
		PatientName,   
		RenderingProviderName,   
		AccountID,   
		SuperbillID,   
		SuperbillUid,   
		SuperbillDate,   
		MIN(ItemDate) AS ItemDate,   
		CreditGroupUid,  
		IsPayment,   
		CreditUid,   
		2 AS CreditSubOrder,   
		WhoPaid,   
		Description,  
		CONVERT(Money, 0) AS Charge,   
		SUM(Insurance) AS Insurance,   
		SUM(Patient) AS Patient,  
		SUM(Amount) AS Amount,  
		0 AS Age,  
		SuperbillProcedureUid,  
		MAX(TotalCharge) AS TotalCharge,  
		MAX(LastFiledDate) AS LastFiledDate,  
		ReferenceNumber,  
		 ReferringProviderName,  
		'''' as InsuranacePlan,  
		MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
		--CASE WHEN AR.IsClosed =1 OR AR.IsLocked =1 THEN 1 ELSE 0 END   
		1 CompleteBatch, 
		DisplayOrder2 
	FROM  
	(  
	 SELECT DISTINCT  
		 LD.FinancialCenterUid,  
		 (CASE WHEN LCT.Name = ''Patient Payment'' THEN D.DepositUid ELSE LD.FinancialCenterUid END) AS ItemUid, 
		 A.AccountResponsiblePartyUid AS RPUid,   
		 (CASE WHEN L.EntryType  = 2 THEN ''Payment'' ELSE ''Adjustment'' END) AS Type,    
		 p1.FormattedPreferredName AS PatientName,   
		 p2.FormattedPreferredName AS RenderingProviderName,  
		 A.ExternalID AS AccountID,   
		 S.ExternalID AS SuperbillID,   
		 S.SuperbillUid,   
		 S.ServiceDateStart AS SuperbillDate,   
		 --(LD.CreatedDateTime) AS ItemDate,  
		 ARB.GLDate as ItemDate,
		 LD.CreatedDateTime, 
		 LD.FinancialCenterUid  CreditGroupUid,  
		 (CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
		 LD.FinancialCenterUid CreditUid,      
		 WhoPaid.WhoPaidName AS WhoPaid, 
					(CASE WHEN L.EntryType != 2
						  THEN ISNULL(LCT.Name,'''')
						  ELSE
							 (CASE WHEN PS.IncludePaymentReferenceNumber = 1 
							  THEN 
								 ISNULL(LCT.Name,'''') + '' Ref #'' + ISNULL(WhoPaid.ReferenceNumber,''N/A'') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
							  ELSE ISNULL(LCT.Name,'''') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
							  END)
					  END) as Description,
		 (CASE WHEN LD.LiabilityOwner > 0 THEN (LD.Amount) ELSE CONVERT(Money, 0) END) AS Insurance,   
		 (CASE WHEN LD.LiabilityOwner = 0 THEN (LD.Amount) ELSE CONVERT(Money, 0) END) AS Patient,  
		 (ISNULL(LD.Amount, 0)) AS Amount,    
		 LD.SuperbillProcedureUid,  
		 (SP.TotalCharge) AS TotalCharge,  
		 lfd.LastFiledDate AS LastFiledDate,  
		 D.ReferenceNumber,  
		  p3.FormattedPreferredName AS ReferringProviderName,
		 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) AS InsuranacePlan,  
		 ((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) AS IsSuperBilCompleteBatch,  
		 CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END CompleteBatch,
		 CASE    
			  WHEN LCT.IsPayment = 1 THEN 1    
			  WHEN LCT.IsAdjustment = 1 THEN 2    
		  ELSE 3     
		  END AS DisplayOrder2
	 FROM  
		AR_LedgerDetail LD WITH (NOLOCK)
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid        
		LEFT JOIN AR_Ledger LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid  
		INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid=ARB.ARBatchUid   
		INNER JOIN SuperbillProcedure SP WITH (NOLOCK) on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill S WITH (NOLOCK) ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid 
		INNER JOIN AR_LedgerDetail LDOS WITH (NOLOCK) ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid                        
		LEFT JOIN InsurancePlan IP WITH (NOLOCK) ON LD.InsurancePlanUid = IP.InsurancePlanUid  	
		LEFT JOIN ClaimBatchDetail CBD WITH (NOLOCK) ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch CB WITH (NOLOCK) ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					-- AND CB.ClaimDate > ARB.GLDate  -- was causing a problem when reference numbers are reused and primary/secondary insurance payers are the same
					AND CBD.InsurancePlanUid =  IP.InsurancePlanUid 
		LEFT JOIN cteLastFiledDate lfd WITH (NOLOCK) on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN AR_Transaction T WITH (NOLOCK) ON L.TransactionUid = T.TransactionUid 
		LEFT JOIN Deposit d WITH (NOLOCK) ON D.DepositUid = T.DepositUid            
		LEFT JOIN ListCreditType LCT WITH (NOLOCK) ON LD.IncomeAccountUid = LCT.CreditTypeUid 
		LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK) on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK) on p3.personuid = S.ReferringProviderUid   
		LEFT JOIN cteWhoPaidName AS whoPaid ON d.depositUid = WhoPaid.deposituid --and d.referencenumber = WhoPaid.referencenumber
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings PS WITH (NOLOCK) 
	  WHERE rpsss.superbillstatusuid is null and
			(L.EntryType=2 OR L.EntryType=3) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 1 
	) B     
	GROUP BY  
	 FinancialCenterUid,  
	 ItemUid,  
	 RPUid,   
	 Type,   
	 PatientName,   
	 RenderingProviderName,   
	 AccountID,   
	 SuperbillID,   
	 SuperbillUid,   
	 SuperbillDate,  
	 CreditGroupUid,   
	 IsPayment,   
	 CreditUid,   
	 WhoPaid,   
	 Description,  
	 --SuperbillProcedureUid,  
	 ReferenceNumber, 
	 SuperbillProcedureUid, 
	 ReferringProviderName,  
	 InsuranacePlan,
	 DisplayOrder2
	) A
GROUP BY  
 FinancialCenterUid,  
 ItemUid,  
 RPUid,   
 Type,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate, 
 DisplayOrder, 
 CreditGroupUid,   
 IsPayment,   
 CreditUid,   
 WhoPaid,   
 Description,  
 --SuperbillProcedureUid,  
 ReferenceNumber, 
 Charge,
 ReferringProviderName,  
 InsuranacePlan,
 DisplayOrder2
   
UNION ALL  
  
--Claim filing comment can be mixed among the payments, so use the same display ORder  
SELECT   
LD.FinancialCenterUid,  
CB.ClaimBatchUid AS ItemUid,   
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
6 AS DisplayOrder,   
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName, 
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
MAX(CB.ClaimDate) AS ItemDate,   
NULL AS CreditGroupUid,   
0 AS IsPayment,   
NULL AS CreditUid,   
0 AS CreditSubOrder,   
'''' AS WhoPaid,   
(dbo.ARFN_getInsLevelName(CB.InsuranceOrder) + '' claim filed to '' +ISNULL(C.Name,'''')) AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
NULL SuperbillProcedureUid, --CR,  
MAX(SP.TotalCharge) TotalCharge,  
 lfd.LastFiledDate as LastFiledDate,    
'''' AS ReferenceNumber,  
 p3.FormattedPreferredName AS ReferringProviderName,
 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan,
CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END IsSuperBilCompleteBatch,  
CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END CompleteBatch,
 0 AS DisplayOrder2 
FROM  
		AR_LedgerDetail LD WITH (NOLOCK)
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure SP WITH (NOLOCK) on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill S WITH (NOLOCK) ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid 
		LEFT JOIN InsurancePlan IP WITH (NOLOCK) ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation C WITH (NOLOCK) ON IP.InsuranceCarrierUid = C.CorporationUid   
		LEFT JOIN ClaimBatchDetail CBD WITH (NOLOCK) ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch CB WITH (NOLOCK) ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK) on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK) on p3.personuid = s.ReferringProviderUid   
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings PS WITH (NOLOCK)
 WHERE rpsss.superbillstatusuid is null and
	(L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 0  AND (L.EntryType = 1) 
GROUP BY   
 LD.FinancialCenterUid,  
 CB.ClaimBatchUid,   
 A.AccountResponsiblePartyUid,   
 S.PatientUid,   
 LD.RenderingProviderUid,  
 A.ExternalID,  
 S.ExternalID,   
 S.SuperbillUid,   
 S.ServiceDateStart,
 CB.ClaimDate,   
 CB.InsuranceOrder,   
 C.Name,
 lfd.LastFiledDate,    
 ARB.IsClosed,      
 ARB.IsLocked,
 S.ReferringProviderUid,  
  p1.FormattedPreferredName,
  p2.FormattedPreferredName,
  p3.FormattedPreferredName
UNION ALL   
  
--Statement notes FROM credits. Associated with the payments AND adjustments, so use the same display ORder  
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
SELECT   
LD.FinancialCenterUid,  
LD.LedgerDetailUid AS ItemUid,   
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
CASE WHEN L.EntryType=1 THEN 4
WHEN L.EntryType=2 THEN 5 
WHEN L.EntryType=3 THEN 6
WHEN L.EntryType =4 THEN 7
ELSE 6 END AS DisplayOrder,   
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName,   
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
COALESCE(ARB.GLDate,D.DepositDate,S.ServiceDateStart,NULL) AS ItemDate,      
LD.LedgerDetailUid AS CreditGroupUid,  
(CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
LD.LedgerDetailUid AS CreditUid,  
4 AS CreditSubOrder,   
'''' AS WhoPaid,   
L.StatementNote AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
LD.SuperbillProcedureUid,  
SP.TotalCharge,  
 lfd.LastFiledDate AS LastFiledDate,  
'''' AS ReferenceNumber,  
 p3.FormattedPreferredName AS ReferringProviderName,
 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan,
((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) IsSuperBilCompleteBatch,  
((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) CompleteBatch,
 CASE    
      WHEN LCT.IsPayment = 1 THEN 1    
      WHEN LCT.IsAdjustment = 1 THEN 2    
  ELSE 3     
  END AS DisplayOrder2
FROM 
	AR_LedgerDetail LD WITH (NOLOCK)
	INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure SP WITH (NOLOCK) on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill S WITH (NOLOCK) ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid 
	INNER JOIN AR_LedgerDetail LDOS WITH (NOLOCK) ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid     		
	LEFT JOIN InsurancePlan IP WITH (NOLOCK) ON LD.InsurancePlanUid = IP.InsurancePlanUid  	
	LEFT JOIN ClaimBatchDetail CBD WITH (NOLOCK) ON CBD.SuperbillUid = S.SuperbillUid   
	LEFT JOIN ClaimBatch CB WITH (NOLOCK) ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
				 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid 
	LEFT JOIN cteLastFiledDate lfd WITH (NOLOCK) on lfd.SuperbillUid = S.SuperbillUid					 	
	LEFT JOIN Deposit d WITH (NOLOCK) ON D.DepositUid = LDOS.DepositUid
	LEFT JOIN ListCreditType LCT WITH (NOLOCK) ON LD.IncomeAccountUid = LCT.CreditTypeUid 
	LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK) on p2.personuid = LD.RenderingProviderUid 
	LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK) on p3.personuid = s.ReferringProviderUid 	  
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	CROSS JOIN PracticeSettings PS WITH (NOLOCK)
WHERE rpsss.superbillstatusuid is null and
 (L.StatementNote is NOT NULL OR L.StatementNote != '''')   
 AND (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
 AND (L.EntryType=2 OR L.EntryType=3 OR L.EntryType=4) AND LD.IsCredit = 1  
 UNION ALL			
--Remark notes from Reason Codes. Associated with procedures, so use the same display Order  
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
select FinancialCenterUid,
NULL as ItemUid,
 RPUid,   
Type,   
 DisplayOrder,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 CreditGroupUid,   
IsPayment,   
CreditUid,   
 CreditSubOrder,   
  WhoPaid,   
 Description,   
 Charge,   
 Insurance,  
 Patient,  
 Amount,  
 --MIN(AGE)  AS Age,  
 age,
 SuperbillProcedureUid,  
 TotalCharge,  
 LastFiledDate,  
 ReferenceNumber,  
 ReferringProviderName,  
InsuranacePlan,  
 IsSuperBilCompleteBatch,  
 CompleteBatch,
 DisplayOrder2
 from (   
SELECT distinct  
LD.FinancialCenterUid,  
--LD.LedgerDetailUid AS ItemUid,   
NULL as ItemUid,
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
6 AS DisplayOrder,   
p1.FormattedPreferredName AS PatientName,   
NULL AS RenderingProviderName,   
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
SP.ProcedureServiceDateStart AS ItemDate, 
--LD.LedgerDetailUid AS CreditGroupUid,  
--(CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
--LD.LedgerDetailUid AS CreditUid,  
NULL AS CreditGroupUid,  
NULL AS IsPayment,   
NULL AS CreditUid,  
4 AS CreditSubOrder,   
'''' AS WhoPaid,   
adj.StatementNote AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
--LD.SuperbillProcedureUid,  
--SP.TotalCharge AS TotalCharge,  
NULL AS SuperbillProcedureUid,  
CASE WHEN SP.TotalCharge > 0 THEN 99999 ELSE 0 END AS TotalCharge,  
 NULL AS LastFiledDate,  
'''' AS ReferenceNumber,  
NULL AS ReferringProviderName,
NULL AS  InsuranacePlan,
NULL AS IsSuperBilCompleteBatch,  
NULL AS CompleteBatch,
  3  AS DisplayOrder2
FROM Superbill S WITH (NOLOCK) 
	INNER JOIN SuperbillProcedure SP WITH (NOLOCK) ON SP.superbilluid = S.superbilluid
	INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SP.SuperbillProcedureUid = LD.SuperbillProcedureUid
	INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid   
	LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = S.PatientUid  
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	left join cobclaimdetail cob WITH (NOLOCK) on cob.superbilluid = s.superbilluid
	left join COBLineAdjustments adj WITH (NOLOCK) on adj.cobclaimdetailuid = cob.cobclaimdetailuid and adj.superbillprocedureuid = sp.superbillprocedureuid and adj.Notes IS NOT NULL
	CROSS JOIN PracticeSettings PS WITH (NOLOCK) 
WHERE rpsss.superbillstatusuid is null and
 (adj.StatementNote is NOT NULL OR adj.StatementNote != '''')  
 ) A


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPromise]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewSuperbillPromise]   
AS  
SELECT VS.*, ISNULL(IPPS.Amount,0) AS PromiseAmount
FROM ViewSuperbill VS
LEFT JOIN InsurancePayerPromiseSuperbill IPPS ON VS.SuperbillUid = IPPS.SuperbillUid' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewClaimedSuperbillHistory]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewClaimedSuperbillHistory]  
AS
select distinct vcs.SuperbillUid,vcs.ExternalID,vcs.PatientUid,vcs.ClaimingProviderUid,vcs.SuperbillStatusUid,vcs.ServiceSiteUid,
	vcs.ServiceDateStart,vcs.FirstFiledDate,vcs.LastFiledDate,vcs.PatientName,vcs.ClaimingProviderName,
	vcs.ClaimStatus AS SuperbillStatusName,vcs.ServiceSiteName,vcs.ClaimPaper,vcs.InsuranceOrder,vcs.InsuranceCarrierUid,vcs.InsurancePlanUid,
	vcs.PayerName,vcs.LastModifiedByUid,vcs.TotalCharge,vcs.ClaimFormatTypeUid,
	vcs.ClaimClearingHouse,vcs.ClaimClearingHouseUid,vcs.FinancialCenterUid,
	vcs.RenderingProviderUid, vcs.ServiceDateEnd, vcs.RenderingProviderName, a.AccountUid, a.Name as AccountName, pip.PersonUid as InsuredPersonUid,
	pip.CorporationUid as InsuredCorporationUid, 
	coalesce((case when pip.PersonUid is not null then dbo.UDF_getFormattedName(insp.Prefix, insp.FirstName, insp.MiddleName , insp.LastName, insp.Suffix) else insc.Name end), '''') as InsuredName,    
	CAST(coalesce(pip.AuthorizeAssignment, 0) as bit) as AuthorizeAssignment,    
		coalesce(pip.PlanMemberID, '''') as PlanMemberID,    
		coalesce(pip.PlanGroupID, '''') as PlanGroupID,    
		coalesce(ip.Name, '''') as InsurancePlanName,    
		(SELECT COUNT(*)    
		FROM eReportRows err     
		WHERE err.SuperbillUid = vcs.SuperbillUid    
		AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
		AND err.ErrorFlag = ''E'')    
		AS Errors,    
		(SELECT COUNT(*)    
		FROM eReportRows err    
		WHERE err.SuperbillUid = vcs.SuperbillUid    
		AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
		AND err.ErrorFlag = ''W'')    
		AS Warnings,
		lcft.Name as ClaimFormatType,   
		lcft.IsPaper as ClaimFormatTypeIsPaper,
		vcs.IsPosted,
		vcs.VisitUid,
		vcs.VisitDate,
		lcf.Name as ClaimFormat,
		dbo.UDF_AR_getClaimFormatUid(vcs.ClaimPaper, ip.UseCarrierElectronicClaimFormat, ip.UseCarrierPaperClaimFormat,     
									 ip.ElectronicClaimFormatUid, ic.ElectronicClaimFormatUid, 
									 ip.PaperClaimFormatUid, ic.PaperClaimFormatUid,
									 ip.UseCarrierPaperClaimDefaultOption, ip.PaperClaimDefaultOptionUid,
									 ic.PaperClaimDefaultOptionUid, vcs.InsuranceOrder) as ClaimFormatUid, 
		vcs.ARBatchUid,-- Igor note: temporary added to fix application error (bug 7146)1/12/2011
		dbo.ARFN_getInsLevelName(coalesce(vcs.InsuranceOrder, 0)) as InsuranceLevelName, 
		VCS.Notes,	
		cfl.ClaimFormLayoutUid,
		cfl.Name as ClaimFormLayout,
		VSF.LastFollowupModifiedByUid, VSF.LastFollowupModifiedDate, VSF.LastFollowupByUser, VSF.LastFollowupAll, VSF.MaxFollowupModifiedDate,
		vcs.MinPostingDate, vcs.MaxPostingDate
FROM 
	(SELECT DISTINCT ExternalID,SuperbillUid,PatientUid,ClaimingProviderUid,SuperbillStatusUid,ServiceSiteUid,
		ServiceDateStart,FirstFiledDate,LastFiledDate,PatientName,ClaimingProviderName,
		ServiceSiteName,ClaimPaper,InsuranceOrder,InsuranceCarrierUid,InsurancePlanUid,
		PayerName,LastModifiedByUid,TotalCharge,ClaimFormatTypeUid,
		ClaimClearingHouse,ClaimClearingHouseUid,FinancialCenterUid, ClaimStatus, RenderingProviderUid, RenderingProviderName, 
		ServiceDateEnd, VisitUid, VisitDate, IsPosted, AccountUid, ARBatchUid, Notes, MinPostingDate, MaxPostingDate
	FROM ViewClaimedSuperbill) vcs 
		 INNER JOIN Account a ON a.AccountUid = vcs.AccountUid    
		 LEFT JOIN AccountPeriod ap ON a.AccountUid = ap.AccountUid    
										  and (ap.EffectiveDate is null or ap.EffectiveDate <= vcs.ServiceDateEnd)    
										  and (ap.ExpirationDate is null or DateAdd(dd, 1, ap.ExpirationDate) > vcs.ServiceDateEnd)    
		 LEFT JOIN AccountInsurance ai ON ai.AccountPeriodUid = ap.AccountPeriodUid    
										  and ai.DisplayOrder = vcs.InsuranceOrder
		 LEFT JOIN PersonInsurancePlan pip ON pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid    
		 LEFT JOIN Person insp ON insp.PersonUid = pip.PersonUid    
		 LEFT JOIN Corporation insc ON insc.CorporationUid = pip.CorporationUid    
		 LEFT JOIN InsurancePlan ip ON ip.InsurancePlanUid = pip.InsurancePlanUid    
		 LEFT JOIN InsuranceCarrier ic ON ic.CorporationUid = ip.InsuranceCarrierUid    
		 LEFT JOIN ListClaimFormat lcf ON  lcf.ClaimFormatUid = dbo.UDF_AR_getClaimFormatUid(vcs.ClaimPaper, ip.UseCarrierElectronicClaimFormat, ip.UseCarrierPaperClaimFormat,     
																							ip.ElectronicClaimFormatUid, ic.ElectronicClaimFormatUid, 
																							ip.PaperClaimFormatUid, ic.PaperClaimFormatUid,
																							ip.UseCarrierPaperClaimDefaultOption, ip.PaperClaimDefaultOptionUid, 
																							ic.PaperClaimDefaultOptionUid, vcs.InsuranceOrder )
		 LEFT JOIN ListClaimFormatType lcft ON  lcft.ClaimFormatTypeUid = vcs.ClaimFormatTypeUid
		 LEFT OUTER JOIN ClaimFormatOption cfo ON lcf.ClaimFormatUid = cfo.ClaimFormatUid	-- Scenario 39252: Set custom payer claim layout		
													AND cfo.ClaimFormatOptionTypeUid in (	''85912913-6DF7-46FD-BA9C-47788EBC347C'', -- Paper CMS-1500 5010
																					  		''213406F9-EB44-46AE-A85B-E75082C7BD41'', -- Paper ADA 2006
																							''5A04B8A3-CD89-4873-B639-43015702B181'', -- Paper CMS-1500
																							''FC409618-D134-4225-93C3-629566A3DA0B'') -- Paper UB04
		 LEFT OUTER JOIN ListClaimFormLayout cfl ON cfo.ClaimFormatValueTypeUid = cfl.ClaimFormLayoutUid
		 LEFT JOIN ViewSuperbillFollowup VSF ON vcs.SuperbillUid = VSF.SuperbillUid
	








--GO

--EXEC sys.sp_addextendedproperty @name=N''primaryKey'', @value=N''SuperbillUid;InsuranceOrder;InsurancePlanUid;ClaimFormatTypeUid'' , @level0type=N''SCHEMA'',@level0name=N''dbo'', @level1type=N''VIEW'',@level1name=N''ViewClaimedSuperbillHistory''
--GO





--EXEC sys.sp_addextendedproperty @name=N''primaryKey'', @value=N''SuperbillUid;InsuranceOrder;InsurancePlanUid;ClaimFormatTypeUid'' , @level0type=N''SCHEMA'',@level0name=N''dbo'', @level1type=N''VIEW'',@level1name=N''ViewClaimedSuperbillHistory''




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessagesRx]'))
EXEC dbo.sp_executesql @statement = N'

CREATE view [dbo].[ViewMessagesRx] as
select * from ViewMessagesNewRx
union all
select * from ViewMessagesRxErrors
union all
select * from ViewMessagesRefReq
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewReport_VisitMedication]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewReport_VisitMedication] 
AS
SELECT 
	VM.VisitDate,
	VM.Patient,
	VM.Provider,
	VM.Medication,
	VM.Pharmacy,
	VM.Successful,
	VM.eRxSentDateTime,
	VM.ReadyToPrescribe,
	VM.SendResponse,
	VM.RelVisitMedicationUid,
	VM.SIGDetailUid,
	VM.PatientUid,
	VM.ProviderUid,
	VM.PharmacyUid,
	VM.VisitUid,
	VM.ClearingHouse,
	VM.eRxMessageType,
	VM.eRxMessageID,
	VM.eRxMessageTypeUid,
	VM.eRxOutboundUid,
	M.RefillQuantity ,
	M.DispenseAsWritten ,
	M.IsSampleGiven ,
	M.IsAdministered ,
	M.IsMaintenanceDrug,
	M.FullTextSIG ,
	SG.DosageQuantity,
	SG.DosageUnit ,
	SG.Frequency,
	SG.Quantity,
	SG.ItemStartDate,
	SG.ItemStopDate ,
	SG.Duration,
	SG.Comment  
FROM
	ViewVisitMedication VM
INNER JOIN
	SIGDetail SG 
ON
	VM.SIGDetailUid =SG.SIGDetailUid 
INNER JOIN
	MedicationSIG M
ON
	SG.MedicationSIGUid =M.MedicationSIGUid ' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewInsurancePlanAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewInsurancePlanAggregateSub] WITH SCHEMABINDING  
AS  
SELECT InsurancePlanUid,   
		SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.Amount ELSE 0 END) As Liability,   
		SUM(LD.Amount) As LiabilityBalance, COUNT_BIG(*) AS Count  
	FROM dbo.AR_LedgerDetail LD         
		INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
	WHERE NOT LD.InsurancePlanUid IS NULL  
	GROUP BY LD.InsurancePlanUid      

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
REATE UNIQUE CLUSTERED INDEX PK_AR_ViewInsurancePlanAggregateSub_InsurancePlanUid ON AR_ViewInsurancePlanAggregateSub(InsurancePlanUid)

*/

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewInsurancePlanAggregateSub]') AND name = N'PK_AR_ViewInsurancePlanAggregateSub_InsurancePlanUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewInsurancePlanAggregateSub_InsurancePlanUid] ON [dbo].[AR_ViewInsurancePlanAggregateSub]
(
	[InsurancePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewInsurancePlanAggregate]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewInsurancePlanAggregate] 
AS
SELECT IP.InsurancePlanUid, 
	ISNULL(VIPAB.Liability, 0) AS Liability,
	ISNULL(VIPAB.LiabilityBalance, 0) AS LiabilityBalance
FROM InsurancePlan IP
LEFT JOIN AR_ViewInsurancePlanAggregateSub (NOEXPAND) VIPAB ON IP.InsurancePlanUid = VIPAB.InsurancePlanUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPayableSuperbills]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewPayableSuperbills]    
as     
 select 
  sb.SuperbillUid,  
  sb.ExternalID,    
  sb.PatientUid,    
  sb.RenderingProviderUid,    
  sb.ClaimingProviderUid,    
  sb.SuperbillStatusUid,    
  sb.ServiceDateStart,    
  sb.ServiceDateEnd,    
  sb.ServiceSiteUid,    
  sb.PatientName,    
  sb.RenderingProviderName,    
  sb.ClaimingProviderName,    
  sb.SuperbillStatusName,    
  sb.ServiceSiteName,    
  sb.AccountUid,  
  ac.AccountResponsiblePartyUid,  
  sb.ClaimPaper,    
  sb.LastModifiedByUid,    
  sb.TotalCharge,    
  sb.LiabilityBalance as Balance,  
  sb.FinancialCenterUid    
 from ViewSuperbill sb  
 inner join Account ac ON ac.AccountUid = sb.AccountUid 
 group by     
  sb.ExternalID,    
  sb.SuperbillUid,    
  sb.PatientUid,    
  sb.RenderingProviderUid,    
  sb.ClaimingProviderUid,    
  sb.SuperbillStatusUid,    
  sb.ServiceDateStart,    
  sb.ServiceDateEnd,    
  sb.ServiceSiteUid,    
  sb.PatientName,    
  sb.RenderingProviderName,    
  sb.ClaimingProviderName,    
  sb.SuperbillStatusName,    
  sb.ServiceSiteName,    
  sb.AccountUid,    
  ac.AccountResponsiblePartyUid,  
  sb.ClaimPaper,    
  sb.LastModifiedByUid,    
  sb.TotalCharge,  
  sb.FinancialCenterUid,  
  sb.LiabilityBalance  




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewClaimedSuperbillHistoryExtended]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewClaimedSuperbillHistoryExtended]  
AS
	SELECT DISTINCT vcs.ExternalID,vcs.SuperbillUid,vcs.PatientUid,vcs.ClaimingProviderUid,vcs.SuperbillStatusUid,vcs.ServiceSiteUid,
		vcs.ServiceDateStart,vcs.FirstFiledDate,vcs.LastFiledDate,vcs.PatientName,vcs.ClaimingProviderName,
		vcs.SuperbillStatus AS SuperbillStatusName,vcs.ServiceSiteName,vcs.ClaimPaper,vcs.InsuranceOrder,vcs.InsuranceCarrierUid,vcs.InsurancePlanUid,
		vcs.PayerName,vcs.LastModifiedByUid,vcs.TotalCharge,vcs.ClaimFormatTypeUid,
		vcs.ClaimClearingHouse,vcs.ClaimClearingHouseUid,vcs.FinancialCenterUid,
		vcs.RenderingProviderUid, vcs.ServiceDateEnd, vcs.RenderingProviderName, a.AccountUid, a.Name as AccountName, pip.PersonUid as InsuredPersonUid,
		pip.CorporationUid as InsuredCorporationUid, 
		coalesce((case when pip.PersonUid is not null then dbo.UDF_getFormattedName(insp.Prefix, insp.FirstName, insp.MiddleName , insp.LastName, insp.Suffix) else insc.Name end), '''') as InsuredName,    
		coalesce(pip.AuthorizeAssignment, 0) as AuthorizeAssignment,    
			coalesce(pip.PlanMemberID, '''') as PlanMemberID,    
			coalesce(pip.PlanGroupID, '''') as PlanGroupID,    
			coalesce(ip.Name, '''') as InsurancePlanName,    
			(SELECT COUNT(*)    
			FROM eReportRows err     
			WHERE err.SuperbillUid = vcs.SuperbillUid    
			AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
			AND err.ErrorFlag = ''E'')    
			AS Errors,    
			(SELECT COUNT(*)    
			FROM eReportRows err    
			WHERE err.SuperbillUid = vcs.SuperbillUid    
			AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
			AND err.ErrorFlag = ''W'')    
			AS Warnings,
			lcft.Name as ClaimFormatType,   
			lcft.IsPaper as ClaimFormatTypeIsPaper,
			vcs.IsPosted,
			vcs.VisitUid,
			vcs.VisitDate,
			lcf.Name as ClaimFormat,
			dbo.UDF_AR_getClaimFormatUid(vcs.ClaimPaper, ip.UseCarrierElectronicClaimFormat, ip.UseCarrierPaperClaimFormat,     
										 ip.ElectronicClaimFormatUid, ic.ElectronicClaimFormatUid, 
										 ip.PaperClaimFormatUid, ic.PaperClaimFormatUid,
										 ip.UseCarrierPaperClaimDefaultOption, ip.PaperClaimDefaultOptionUid,
										 ic.PaperClaimDefaultOptionUid, vcs.InsuranceOrder) as ClaimFormatUid, 
			pipp.InsurancePlanUid as PrimaryInsurancePlanUid,
			 vpip.Name as PrimaryInsurancePlan,
			dbo.ARFN_getInsLevelName(coalesce(ai.DisplayOrder, 0)) as InsuranceLevelName,
			VSA.LiabilityBalance - VSA.AssignedLiabilityBalance AS PatientResponsibility,            
			VSA.AssignedLiabilityBalance AS InsuranceResponsibility,
			VSA.LiabilityBalance AS TotalLiability,
			ARPA.LiabilityBalance - ARPA.AssignedLiabilityBalance AS AccountResponsiblePartyLiabilityBalance,
			SA.LastInsurancePaymentAmount AS LastInsurancePayment,
			SA.LastInsurancePaymentDate,
			SA.LastPatientPaymentAmount AS LastPatientPayment,
			SA.LastPatientPaymentDate,
			ap.AccountTypeUid,
			vcs.Notes,			
			cfl.ClaimFormLayoutUid,
			cfl.Name as ClaimFormLayout,
			CAST(0 as bit) as Inactive, -- sa.Inactive,
			CAST(0 as bit) AS ARLocked, /* not needed anymore since only one row per Superbill */
			VSF.LastFollowupModifiedByUid, VSF.LastFollowupModifiedDate, VSF.LastFollowupByUser, VSF.LastFollowupAll, VSF.MaxFollowupModifiedDate
	FROM (SELECT DISTINCT ExternalID,SuperbillUid,PatientUid,ClaimingProviderUid,SuperbillStatusUid, SuperbillStatus, ServiceSiteUid,
						ServiceDateStart,FirstFiledDate,LastFiledDate,PatientName,ClaimingProviderName,
						ServiceSiteName,ClaimPaper,InsuranceOrder,InsuranceCarrierUid,InsurancePlanUid,
						PayerName,LastModifiedByUid,TotalCharge,ClaimFormatTypeUid,
						ClaimClearingHouse,ClaimClearingHouseUid,FinancialCenterUid, ClaimStatus, RenderingProviderUid, RenderingProviderName, 
						ServiceDateEnd, VisitUid, VisitDate, IsPosted, AccountUid, ARBatchUid, Notes
		  FROM ViewClaimedSuperbill) vcs 
				 INNER JOIN SuperbillAggregate SA ON vcs.SuperbillUid = SA.SuperbillUid
				 INNER JOIN AR_ViewSuperbillAggregate VSA ON vcs.SuperbillUid = VSA.SuperbillUid
				 INNER JOIN Account a ON a.AccountUid = vcs.AccountUid    
				 INNER JOIN AR_ViewAccountResponsiblePartyAggregate ARPA ON a.AccountResponsiblePartyUid = ARPA.AccountResponsiblePartyUid 
				 LEFT JOIN AccountPeriod ap ON a.AccountUid = ap.AccountUid    
												  and (ap.EffectiveDate is null or ap.EffectiveDate <= vcs.ServiceDateEnd)    
												  and (ap.ExpirationDate is null or DateAdd(dd, 1, ap.ExpirationDate) > vcs.ServiceDateEnd)    
				 LEFT JOIN AccountInsurance ai ON ai.AccountPeriodUid = ap.AccountPeriodUid    
													and ai.DisplayOrder = vcs.InsuranceOrder
				 LEFT JOIN PersonInsurancePlan pip on pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid    
				 LEFT JOIN Person insp ON insp.PersonUid = pip.PersonUid    
				 LEFT JOIN Corporation insc ON insc.CorporationUid = pip.CorporationUid    
				 LEFT JOIN InsurancePlan ip ON ip.InsurancePlanUid = pip.InsurancePlanUid    
				 LEFT JOIN InsuranceCarrier ic ON ic.CorporationUid = ip.InsuranceCarrierUid    
				 LEFT JOIN AccountInsurance aip ON ap.AccountPeriodUid = aip.AccountPeriodUid AND aip.DisplayOrder = 1
				 LEFT JOIN PersonInsurancePlan pipp ON aip.PersonInsurancePlanUid = pipp.PersonInsurancePlanUid
				 LEFT JOIN ListClaimFormat lcf ON  lcf.ClaimFormatUid = dbo.UDF_AR_getClaimFormatUid(vcs.ClaimPaper, ip.UseCarrierElectronicClaimFormat, ip.UseCarrierPaperClaimFormat,     
																									ip.ElectronicClaimFormatUid, ic.ElectronicClaimFormatUid, 
																									ip.PaperClaimFormatUid, ic.PaperClaimFormatUid,
																									ip.UseCarrierPaperClaimDefaultOption, ip.PaperClaimDefaultOptionUid, 
																									ic.PaperClaimDefaultOptionUid, vcs.InsuranceOrder )
				 LEFT JOIN ListClaimFormatType lcft ON  lcft.ClaimFormatTypeUid = vcs.ClaimFormatTypeUid
			     LEFT JOIN ViewInsurancePlan vpip ON pipp.InsurancePlanUid  = vpip.InsurancePlanUid
				 LEFT OUTER JOIN ClaimFormatOption cfo ON lcf.ClaimFormatUid = cfo.ClaimFormatUid	-- Scenario 39252: Set custom payer claim layout		
													AND cfo.ClaimFormatOptionTypeUid in (	''85912913-6DF7-46FD-BA9C-47788EBC347C'', -- Paper CMS-1500 5010
																					  		''213406F9-EB44-46AE-A85B-E75082C7BD41'', -- Paper ADA 2006
																							''5A04B8A3-CD89-4873-B639-43015702B181'', -- Paper CMS-1500
																							''FC409618-D134-4225-93C3-629566A3DA0B'') -- Paper UB04
				 LEFT OUTER JOIN ListClaimFormLayout cfl ON cfo.ClaimFormatValueTypeUid = cfl.ClaimFormLayoutUid
				 LEFT JOIN ViewSuperbillFollowup VSF ON vcs.SuperbillUid = VSF.SuperbillUid














--EXEC sys.sp_addextendedproperty @name=N''primaryKey'', @value=N''SuperbillUid;InsuranceOrder;InsurancePlanUid;ClaimFormatTypeUid'' , @level0type=N''SCHEMA'',@level0name=N''dbo'', @level1type=N''VIEW'',@level1name=N''ViewClaimedSuperbillHistoryExtended''





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_ResponsiblePartyCollectionsList]'))
EXEC dbo.sp_executesql @statement = N'



/*
Pancratius: 09/21/2014 Added most recent CollectionDate column

--select*from [MDOL_RPT2_VIEW_ResponsiblePartyCollectionsList]
  kculbert  01242017 Bug 53204:Responisble Party Collections List report is reflecting data after entire collections list was cleared


*/

CREATE VIEW [dbo].[MDOL_RPT2_VIEW_ResponsiblePartyCollectionsList]
AS
SELECT A.AccountResponsiblePartyUID,InactiveResponsibleParties,ID,LAST,First,PrimaryAddress1,PrimaryAddress2,City,State,ZIP,Phone1,Phone2,Phone1Type,Phone2Type,SSN,DOB,Balance,CollectionStatusLevelUID,CollectionStatusLevel,ResponsiblePartyIs_PersonUID,ResponsiblePartyIs_CorporationUID,CollectionBalance,B.CollectionDate,DateofService--,C.LastPaymentDate,C.LastPaymentAmt
FROM
(
	SELECT DISTINCT -- PERSON 
		ARP.AccountResponsiblePartyUID AS AccountResponsiblePartyUID,
		ARP.Inactive AS InactiveResponsibleParties,
		A.AccountUID,
		ARP.ExternalID as ID,
		--Dbo.UDF_getFormattedPreferredName(P.personuid) AS LAST,
		P.LastName  AS [Last],
		P.FirstName  AS [First],
		
		p.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') AS PrimaryAddress1,
		p.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') AS PrimaryAddress2,
		p.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)'') AS City,
		p.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)'') AS State,
		p.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') AS ZIP,
		p.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone1,
		p.Phone2.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone2,
		p.Phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone1Type,
		p.Phone2.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone2Type,
		P.SocialSecurityNumber AS SSN,
		P.BirthDate AS DOB,
		--VA.PersonBalanceAll  AS Balance,
		(VA.LiabilityBalance - VA.AssignedLiabilityBalance) AS Balance,
		CSL.CollectionStatusLevelUID,
		CSL.Name AS CollectionStatusLevel,
		ARP.PersonUID AS ResponsiblePartyIs_PersonUID,
		ARP.CorporationUID AS ResponsiblePartyIs_CorporationUID
	FROM AccountResponsibleParty ARP with (NOLOCK)
	INNER JOIN Person P with (NOLOCK) ON ARP.PersonUID = P.PersonUID
	INNER JOIN Account A with (NOLOCK) ON ARP.AccountResponsiblePartyUID = A.AccountResponsiblePartyUID
	INNER JOIN AR_ViewAccountAggregate VA with (NOLOCK) ON A.AccountUid=VA.AccountUid
	LEFT JOIN CollectionStatusLevel CSL with (NOLOCK) ON ARP.CollectionStatusLevelUID = CSL.CollectionStatusLevelUID
	WHERE ARP.CollectionStatusUid IS NOT NULL
	UNION
	SELECT DISTINCT --CORPORATION
		ARP.AccountResponsiblePartyUID AS AccountResponsiblePartyUID,
		ARP.Inactive AS InactiveResponsibleParties,
		A.AccountUID,
		ARP.ExternalID as ID,
		''-''  AS [First],
		CP.Name   AS [Last],
		cp.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') AS PrimaryAddress1,
		cp.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') AS PrimaryAddress2,
		cp.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') AS City,
		cp.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'') AS State,
		cp.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') AS ZIP,
		cp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone1,
		cp.Phone2.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS Phone2,
		cp.Phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone1Type,
		cp.Phone2.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)'') AS Phone2Type,
		''-'' AS SSN,
		'''' AS DOB,
		(VA.AssignedLiabilityBalance) AS Balance,
		CSL.CollectionStatusLevelUID,
		CSL.Name AS CollectionStatusLevel,
		ARP.PersonUID AS ResponsiblePartyIs_PersonUID,
		ARP.CorporationUID AS ResponsiblePartyIs_CorporationUID
	FROM AccountResponsibleParty ARP with (NOLOCK)
	INNER JOIN Corporation CP with (NOLOCK) ON CP.CorporationUID = ARP.CorporationUID 
	INNER JOIN Account A with (NOLOCK) ON ARP.AccountResponsiblePartyUID = A.AccountResponsiblePartyUID
	INNER JOIN AR_ViewAccountAggregate VA with (NOLOCK)	ON A.AccountUid=VA.AccountUid
	LEFT JOIN CollectionStatusLevel CSL with (NOLOCK) ON ARP.CollectionStatusLevelUID = CSL.CollectionStatusLevelUID
	WHERE ARP.CollectionStatusUid IS NOT NULL
)
A
JOIN
(
	SELECT ACC.AccountResponsiblePartyUid,Sum(VSA.LiabilityBalance - VSA.AssignedLiabilityBalance) AS CollectionBalance
	,Max(SB.DateEnteredAutomatedCollections) AS CollectionDate
	,Min(SB.ServiceDateStart) as DateofService
	FROM AR_ViewSuperbillAggregate VSA  
	INNER JOIN Superbill SB with (NOLOCK) ON VSA.SuperbillUid =SB.SuperbillUid AND (NOT SB.DateEnteredAutomatedCollections IS NULL   
		AND SB.DateLeftAutomatedCollections IS NULL)  
    INNER JOIN Account ACC with (NOLOCK) ON SB.AccountUid = ACC.AccountUid  
    GROUP BY  ACC.AccountResponsiblePartyUid
 )
 B
 ON A.AccountResponsiblePartyUid=B.AccountResponsiblePartyUid

 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindUserAndUserGroupAndPersonWeb]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewFindUserAndUserGroupAndPersonWeb] AS
SELECT		lug.UserGroupUId AS UId, lug.ExternalID, null as LoginID, lug.Inactive, lug.Name, lug.Name as LastName, null as FirstName, null as MiddleName,
			NULL AS AkaFirstName, NULL AS AkaLastName,
			lug.Notes, 2 AS ForeignKeyIndex, ''Group'' AS [UserGroupType], 
			CASE WHEN lug.UserGroupTypeUid = dbo.SystemGuid(1) THEN 1 ELSE 0 END AS IsCareTeamGroupOrProvider
FROM		dbo.ListUserGroup lug
UNION ALL
SELECT		u.PersonUId AS UId, ISNULL(u.ExternalID, u.Login) AS ExternalID, u.Login as LoginID, u.Inactive, 
			p.FormattedInternalName AS Name, 
			p.LastName, p.FirstName, p.MiddleName, p.AkaFirstName, p.AkaLastName,
			NULL AS Notes, 1 AS ForeignKeyIndex, ''User'' AS [UserGroupType], 
			CASE WHEN prov.PersonUid IS NULL THEN 0 ELSE 1 END AS IsCareTeamGroupOrProvider
FROM        dbo.UserPRM u 
            INNER JOIN dbo.ViewPerson p (NOEXPAND) ON u.PersonUId = p.PersonUId 
			LEFT JOIN Provider prov ON u.PersonUid = prov.PersonUid
UNION ALL
SELECT		pw.PersonUid AS UId, ISNULL(pat.ExternalID, pw.UserName) AS ExternalID, pw.UserName as LoginID, pat.Inactive,    
			p.FormattedInternalName AS Name, 
			p.LastName, p.FirstName, p.MiddleName, p.AkaFirstName, p.AkaLastName,
			NULL AS Notes, 3 AS ForeignKeyIndex,  ''Patient'' AS [UserGroupType], 
			0 AS IsCareTeamGroupOrProvider      
FROM		dbo.PersonWeb pw 
			INNER JOIN dbo.ViewPerson p (NOEXPAND) ON pw.PersonUId = p.PersonUId
			INNER JOIN Patient pat ON pat.PersonUid = pw.PersonUid
			LEFT JOIN UserPRM usr ON p.PersonUid = usr.PersonUid
WHERE		usr.PersonUid IS NULL
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementAge]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewStatementAge] -- WITH SCHEMABINDING 
AS  
 SELECT  
 A.AccountResponsiblePartyUid,   
 DATEDIFF(DD,MIN(ARB.GLDate),GETUTCDATE()) as Age   -- MAXIMUM AGE
FROM  
 dbo.AR_Ledger L  
INNER JOIN  
 dbo.AR_LedgerDetail LD  
ON  
 L.LedgerUid=LD.LedgerUid AND (L.EntryType=1 OR L.EntryType=4) --AND LD.IsCredit=0  
JOIN
 dbo.ARBatch ARB
ON
 L.ArBatchUid =ARB.ARBatchUid 
INNER JOIN  
 dbo.AR_ViewSuperbillProcedureAggregate VSP  
ON  
 LD.SuperbillProcedureUid= VSP.SuperbillProcedureUid  
INNER JOIN  
 dbo.SuperbillProcedure SP 
LEFT JOIN
   ViewSuperbillProcedure_IsVoid VSPVOID
ON
   VSPVOID.SuperbillProcedureUid=Sp.SuperbillProcedureUid
ON  
 SP.SuperbillProcedureUid=LD.SuperbillProcedureUid  
INNER JOIN  
 dbo.Superbill S  
ON  
 S.SuperbillUid=SP.SuperbillUid  
INNER JOIN  
 dbo.Account A  
ON  
 S.AccountUid = A.AccountUid  
WHERE  
 (VSP.LiabilityBalance - VSP.AssignedLiabilityBalance) > 0 AND LD.LiabilityOwner = 0  
 AND (VSPVOID.IsVoid IS NULL OR VSPVOID.IsVoid=0)
GROUP BY
A.AccountResponsiblePartyUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPersonContact]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewPersonContact] AS
	SELECT	pc.PersonContactUid, pc.PersonUid,
			pc.ContactPersonUid, p.FullName, p.Phone1, p.Phone2, p.Phone3, p.Phone4,
			pc.ContactRelationshipUid, r.[Name] AS Relationship, pc.DisplayOrder,
			pc.EmergencyContact, pc.AuthorizedToMakeMedicalDecisions, pc.AllowHIPAARelease,
			pc.HIPAARelease
	FROM	PersonContact pc INNER JOIN ViewPerson p ON pc.ContactPersonUid = p.PersonUid
			LEFT JOIN ListRelationship r ON pc.ContactRelationshipUid = r.RelationshipUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_LedgerGetResponsiblePartyDetails]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[MDOL_RPT2_VIEW_LedgerGetResponsiblePartyDetails]
AS
	SELECT
		(CASE WHEN ARP.PersonUID IS NOT NULL THEN dbo.UDF_getFormattedPreferredNameFromValues(RP.FirstName,RP.LastName,RP.MiddleName,RP.Suffix)
				  ELSE CP.Name END) AS ResponsibleParty,
		ARP.AccountResponsiblePartyUID AS ResponsiblePartyUID,
		CASE WHEN ARP.PersonUid IS NOT NULL THEN
			RP.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
		ELSE
			cp.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
		END AS Address1,
		CASE WHEN ARP.PersonUid IS NOT NULL THEN
			RP.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
		ELSE
			cp.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
		END AS Address2,
		CASE WHEN ARP.PersonUid IS NOT NULL THEN
			RP.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)'')
		ELSE
			cp.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'')
		END AS City,
		CASE WHEN ARP.PersonUid IS NOT NULL THEN
			RP.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)'')
		ELSE
			cp.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'')
		END AS [State],
		CASE WHEN ARP.PersonUid IS NOT NULL THEN
			RP.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
		ELSE
			cp.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
		END AS Zip,
		CASE WHEN ARP.PersonUID IS NOT NULL THEN 
			rp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') 
		ELSE
			cp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') 
		END AS ResponsiblePartyDayPhone,
		AC.AccountUID,
		AC.Name AS AccountName,
		P.PersonUID AS PatientUID,
		dbo.UDF_getFormattedPreferredNameFromValues(P.FirstName,P.LastName,P.MiddleName,P.Suffix) AS Patient,
		--VA.AccountBalanceAll AS AccountBalance,
		--VA.PersonBalanceALL AS AccountPersonLiability,
		--(VA.AccountBalanceAll-VA.PersonBalanceALL) AS AccountInsuranceLiability,
		ISNULL(VA.LiabilityBalance,0) AS AccountBalance,
		ISNULL(VA.LiabilityBalance - VA.AssignedLiabilityBalance,0) AS AccountPersonLiability,    
		ISNULL(VA.AssignedLiabilityBalance,0) AS AccountInsuranceLiability,
		AC.LastStatementDate
	FROM
		AccountResponsibleParty ARP WITH (NOLOCK)
	JOIN
		Account AC WITH (NOLOCK)
		ON
			AC.AccountResponsiblePartyUid=ARP.AccountResponsiblePartyUid
	INNER JOIN 
		AR_ViewAccountAggregate VA WITH (NOLOCK)
	ON 
		AC.AccountUid=VA.AccountUid
	JOIN
		Person P WITH (NOLOCK)
	ON
		P.PersonUID=AC.PersonUID
	LEFT JOIN
		Person RP WITH (NOLOCK)
	ON
		ARP.PersonUID IS NOT NULL AND RP.PersonUID=ARP.PersonUID
	LEFT JOIN
		Corporation CP WITH (NOLOCK)
	ON
		ARP.CorporationUID IS NOT NULL AND CP.CorporationUID=ARP.CorporationUID



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewClaimReport]'))
EXEC dbo.sp_executesql @statement = N'
-- Bug 37472: Removed unnecessary RawMessage which caused a LOT of data transfer

CREATE VIEW [dbo].[ViewClaimReport]
AS
Select      err.eReportRowUid, 
      erd.importDate as ImportDate, 
      erd.reportNumber as ReportNumber, 
      err.eReportDetailUid, 
      coalesce(err.ClaimReportStatusUid, convert(uniqueidentifier, ''00000000-0000-0000-0000-000000000010'')) as ClaimReportStatusUid, 
      coalesce(lcrs.Name, ''New'') as ClaimReportStatus, 
      vs.ServiceDateStart, 
      vs.ServiceDateEnd, 
      vs.ClaimingProviderUid, 
      vs.ClaimingProviderName, 
      vs.superbillUid as SuperbillUid, 
      vs.ExternalID as SuperbillExternalID, 
      vs.SuperbillStatusName,
      vs.patientUid as PatientUid, 
      vs.PatientName, 
      vs.ServiceSiteUid,
      vs.ServiceSiteName,
      vs.FinancialCenterUid,
      err.insuredUid as InsuredUid, 
      coalesce((case when ins.PersonUid is not null then ins.FullName else c2.Name end), '''') as InsuredName, 
      err.InsuranceCarrierUid, 
      c.Name as PayerName, 
      (case when errorFlag = ''E'' then ''Error'' when errorFlag = ''W'' then ''Warning'' else ''Information'' end) as ErrorStatus, 
      err.errorDescription as ErrorDescription, 
      err.additionalClaimInformation as AdditionalClaimInformation, 
      (case when err.errorDescription is null then coalesce(err.additionalClaimInformation, '''') else (err.errorDescription + coalesce('' ('' + err.additionalClaimInformation + '')'', '''')) end) as Notes, 
      err.perSeErrorCode as PerSeErrorCode, vs.InsuranceOrder,
      err.LastModifiedDate, 
      err.LastModifiedByUid
      --CONVERT(VARCHAR(max),CONVERT(VARBINARY(max),df.fileImage)) AS RawMessage
From eReportRows err 
      Left Join eReportDetails erd On err.eReportDetailUid = erd.eReportDetailUid 
      Left Join ListClaimReportStatus lcrs On lcrs.ClaimReportStatusUid = err.ClaimReportStatusUid 
      Left Join ViewSuperbill vs On vs.SuperbillUid = err.superbillUid 
      Left Join Corporation c on c.CorporationUid = err.InsuranceCarrierUid 
      Left Join ViewPerson (noexpand) ins on ins.PersonUid = err.insuredUid 
      Left Join Corporation c2 on c2.CorporationUid = err.insuredUid
      --left join downloadedFiles df on df.downloadedFileUid = erd.eReportFileUid







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewInsurancePlanProviderInNetworkStatus]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewInsurancePlanProviderInNetworkStatus] AS

SELECT IPPNS.RelInsurancePlanProviderInNetworkStatusUid, IP.Name AS InsurancePlan, VP.FullName AS Provider,
		IPPNS.EffectiveDate, IPPNS.ExpirationDate
	FROM RelInsurancePlanProviderInNetworkStatus IPPNS WITH (NOLOCK)
		INNER JOIN ViewInsurancePlan IP WITH (NOLOCK) ON IPPNS.InsurancePlanUid = IP.InsurancePlanUid
		INNER JOIN ViewPerson VP WITH (NOEXPAND) ON IPPNS.ProviderUid = VP.PersonUid
		
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementAgeByFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewStatementAgeByFinancialCenter] -- WITH SCHEMABINDING 
AS  
SELECT  
 A.AccountResponsiblePartyUid,   
 LD.FinancialCenterUid ,
 DATEDIFF(DD,MIN(ARB.GLDate),GETUTCDATE()) as Age   -- MAXIMUM AGE
FROM  
 dbo.AR_Ledger L  
INNER JOIN  
 dbo.AR_LedgerDetail LD  
ON  
 L.LedgerUid=LD.LedgerUid AND (L.EntryType=1 OR L.EntryType=4) --AND LD.IsCredit=0  
JOIN
 dbo.ARBatch ARB
ON
 L.ArBatchUid =ARB.ARBatchUid 
INNER JOIN  
 dbo.AR_ViewSuperbillProcedureAggregate VSP  
ON  
 LD.SuperbillProcedureUid= VSP.SuperbillProcedureUid  
INNER JOIN  
 dbo.SuperbillProcedure SP  
ON  
 SP.SuperbillProcedureUid=LD.SuperbillProcedureUid
LEFT JOIN
   ViewSuperbillProcedure_IsVoid VSPVOID
ON
   VSPVOID.SuperbillProcedureUid=Sp.SuperbillProcedureUid  
INNER JOIN  
 dbo.Superbill S  
ON  
 S.SuperbillUid=SP.SuperbillUid  
INNER JOIN  
 dbo.Account A  
ON  
 S.AccountUid = A.AccountUid  
WHERE  
 (VSP.LiabilityBalance - VSP.AssignedLiabilityBalance) > 0 AND LD.LiabilityOwner = 0
 AND (VSPVOID.IsVoid IS NULL OR VSPVOID.IsVoid=0  )
GROUP BY
A.AccountResponsiblePartyUid,
LD.FinancialCenterUid 


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillInsurance]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewSuperbillInsurance]
AS
select pip.PersonInsurancePlanUid,  
       sb.SuperbillUid, sb.ExternalID,
       act.AccountUid, act.Name as Account,
       ap.AccountPeriodUid, ap.EffectiveDate, ap.ExpirationDate,
	   ai.AccountInsuranceUid, ai.DisplayOrder, 
	   pip.PlanMemberID, pip.PlanGroupID, 
	   ip.InsurancePlanUid, ip.Name as InsurancePlan,
	   corp.CorporationUid, corp.Name as InsuranceCarrier,
	   CASE WHEN ai.DisplayOrder = 0 THEN (''Patient '' + ip.Name + ''/'' + corp.Name) 
	        WHEN ai.DisplayOrder = 1 THEN (''Primary '' + ip.Name + ''/'' + corp.Name) 
	        WHEN ai.DisplayOrder = 2 THEN (''Secondary '' + ip.Name + ''/'' + corp.Name) 
	        WHEN ai.DisplayOrder = 3 THEN (''Tertiary '' + ip.Name + ''/'' + corp.Name) 
	        ELSE (convert(varchar(2), ISNULL(ai.DisplayOrder,'' '')) + ip.Name + ''/'' + corp.Name) END AS Name
from Superbill sb WITH (NOLOCK)
		inner join Account act WITH (NOLOCK) on sb.AccountUid = act.AccountUid
		inner join AccountPeriod ap WITH (NOLOCK) on act.AccountUid = ap.AccountUid 
					and (ap.EffectiveDate is null or ap.EffectiveDate <= sb.ServiceDateEnd)
					and (ap.ExpirationDate is null or DateAdd(dd, 1, ap.ExpirationDate) > sb.ServiceDateEnd)
		inner join AccountInsurance ai WITH (NOLOCK) on ap.AccountPeriodUid = ai.AccountPeriodUid	
		inner join PersonInsurancePlan pip WITH (NOLOCK) on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
		inner join InsurancePlan ip WITH (NOLOCK) on pip.InsurancePlanUid = ip.InsurancePlanUid
		--inner join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
		inner join Corporation corp WITH (NOLOCK) on ip.InsuranceCarrierUid = corp.CorporationUid







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewDepositTransactionSummary]'))
EXEC dbo.sp_executesql @statement = N'






CREATE VIEW [dbo].[ViewDepositTransactionSummary]
AS



-- bmr 20120622 Removed AR_ViewLedgerSub references - go direct to base tables
	
with cteTransactionDeposits as
(     -- Deposits by Transaction    ( NOTE:  uses rownum later to get 1st deposit and 1st ARP payment
      select  DISTINCT arl_l.TransactionUid,
                       d.DepositUid, 
                               d.ReferenceNumber, 
                               ld2.LiabilityOwner, 
                               ld2.CreatedDateTime,
                              ROW_NUMBER() over (PARTITION BY arl_l.TransactionUid, ld2.LiabilityOwner order by ld2.CreatedDateTime) as rownum,
                              arl_ld.InsurancePayerUid,
                              corp.Name AS PayerName
      from AR_Ledger ARL_L
		inner join AR_LedgerDetail ARL_LD ON ARL_L.LedgerUid = ARL_LD.LedgerUid  
                  inner join AR_LedgerDetail ld2 on arl_l.LedgerUid = ld2.LedgerUid
                                                                        and arl_ld.LedgerDetailUid != ld2.LedgerDetailUid
                  inner join Deposit d on arl_ld.DepositUid = d.DepositUid
                  left outer join Corporation corp on arl_ld.InsurancePayerUid = corp.CorporationUid
      where arl_ld.DepositUid is not null and arl_l.EntryType = 2 and arl_l.Transactionuid is not null
),
cteTransactionSummary as
(   --  Sum (Group by) of Insurance payments/adjustments AND Account Responsible Party payments/adjustments
      Select arl_l.TransactionUid,  
						-- pass on the null -- BUG 41901
                  SUM(Case when (arl_l.EntryType = 2 and arl_ld.LiabilityOwner > 0 ) THEN (0 - arl_ld.Amount) ELSE NULL END) AS TotalInsPayment,
                  SUM(Case when (arl_l.EntryType = 3 and arl_ld.LiabilityOwner > 0 ) THEN (0 - arl_ld.Amount) ELSE NULL END) AS TotalInsAdjustment,
                  SUM(Case when (arl_l.EntryType = 2 and arl_ld.LiabilityOwner = 0 ) THEN (0 - arl_ld.Amount) ELSE NULL END) AS TotalARPPayment,
                  SUM(Case when (arl_l.EntryType = 3 and arl_ld.LiabilityOwner = 0 ) THEN (0 - arl_ld.Amount) ELSE NULL END) AS TotalARPAdjustment,
                  MAX(arl_ld.LiabilityOwner) AS MaxInsLiabilityOwner
      FROM AR_Ledger arl_l
		inner join AR_LedgerDetail arl_ld ON arl_l.LedgerUid = arl_ld.LedgerUid
                  INNER JOIN AR_LedgerDetail ard2 on arl_l.LedgerUid = ard2.LedgerUid 
                                                                        AND arl_ld.LedgerDetailUid != ard2.LedgerDetailUid
                                                                        AND ard2.SuperbillProcedureUid IS NULL
                  WHERE arl_l.TransactionUid IS NOT NULL and
                        arl_ld.SuperbillProcedureUid IS NOT NULL
      GROUP BY arl_l.TransactionUid
)
--select * from cteTransactionSummary
select art.TransactionUid,
            art.ReferenceNumber,
            art.SuperbillUid,
            art.CreatedDateTime,
            -- Insurance
            COALESCE(ctedIns.InsurancePayerUid, vsi.CorporationUid) as InsurancePayerUid, 
            COALESCE(ctedIns.PayerName, vsi.InsuranceCarrier) as InsurancePayer,                  
            ctes.TotalInsPayment,  -- pass on the null from above -- BUG 41901
            ctes.TotalInsAdjustment, -- pass on the null from above -- BUG 41901
            ctedIns.ReferenceNumber as InsReferenceNumber,
            ctedIns.DepositUid as InsDepositUid,
            -- Account Responsible party
            arp.AccountResponsiblePartyUid,
            CASE WHEN (ctes.TotalARPAdjustment = 0 AND ctes.TotalARPPayment = 0) 
                 THEN NULL 
                 WHEN (NOT p.PersonUid IS NULL)
					THEN dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName, p.LastName, p.Suffix)
                 WHEN (NOT cp.CorporationUid IS NULL)
                 THEN cp.Name
                 ELSE ''<ND>'' END AS ResponsiblePartyName,  
            ctes.TotalARPPayment, -- pass on the null from above -- BUG 41901
			ctes.TotalARPAdjustment, -- pass on the null from above -- BUG 41901
            ctedArp.ReferenceNumber as ARPReferenceNumber,
            ctedArp.DepositUid as ARPDepositUid
from AR_Transaction art
            inner join cteTransactionSummary ctes on art.TransactionUid = ctes.TransactionUid
            inner join Superbill sb on art.SuperbillUid = sb.SuperbillUid
inner join Account act on sb.AccountUid = act.AccountUid
            inner join AccountResponsibleParty arp on act.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
            left join Person p on arp.PersonUid = p.PersonUid
            left join Corporation cp on arp.CorporationUid = cp.CorporationUid
            left outer join cteTransactionDeposits ctedIns on art.TransactionUid = ctedIns.TransactionUid
                                                                                    and ctedIns.LiabilityOwner > 0    -- MUST be an insurance
                                                                                    and ctedIns.rownum = 1            -- Used to select ONLY one insurance
            left outer join cteTransactionDeposits ctedArp on art.TransactionUid = ctedArp.TransactionUid
                                                                                    and ctedArp.LiabilityOwner = 0      -- MUST be an Account Responsible Party reference   
			left outer join ViewSuperbillInsurance vsi with (nolock) on sb.SuperbillUid = vsi.SuperbillUid
																					and ctes.MaxInsLiabilityOwner IS NOT NULL
																					and ctes.MaxInsLiabilityOwner = vsi.DisplayOrder






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_OBCaseReport]'))
EXEC dbo.sp_executesql @statement = N'


---select*from [MDOL_RPT2_VIEW_OBCaseReport]

CREATE VIEW [dbo].[MDOL_RPT2_VIEW_OBCaseReport]  
AS 
With CTE_OBReport AS

(SELECT   
 PC.PatientUID AS PatientUID,  
 PC.ProviderUID AS ProviderUID,  
 PT.ExternalID AS ExternalID,  
 dbo.UDF_getFormattedPreferredNameFromValues(P.Firstname,P.LastName,P.MiddleName,P.Suffix) AS PatientName,  
 dbo.UDF_getFormattedPreferredNameFromValues(P1.Firstname,P1.LastName,P1.MiddleName,P1.Suffix) AS ProviderName,  
 LSS.ServiceSiteUID AS ServiceSiteUID,  
 LSS.Name AS ServiceSite,  
 p.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS PhoneNumber,  
 (SELECT Top 1 dbo.UDF_utcToCurrentDate(StartDateTime) FROM ViewAppointmentWithGroup A WHERE A.PatientUid=PC.Patientuid and CAST(CONVERT(VARCHAR(10),dbo.UDF_utcToCurrentDate(StartDateTime),101) AS DATETIME)  > GETUTCDATE()) AS NextAppointmentDate,  
 PCM.Name AS CaseName,  
 PCM.ModuleData AS ModuleData,  
 Coalesce(dbo.OBInformation1(PCM.ModuleData,''findDateBoxLMP''),dbo.OBInformation1(PCM.ModuleData,''findDateBoxInitialExam''),dbo.OBInformation1(PCM.ModuleData,''findDateBoxUltraSound'')) as InitialExam,
 dbo.OBInformation1(PCM.ModuleData,''prmTextBoxFinalEDD'')  AS EDD,  
 dbo.OBInformation1(PCMO.ModuleData,''Hospital'') AS Hospital,  
 dbo.OBInformation1(PCMO.ModuleData,''PatientRecordsSent'') AS RecordSenton,  
 PC.PatientCaseUid,  
 PC.StartDate AS OBStartDate,
 PC.EndDate AS OBEndDate,
 ISNULL(C.[Name],''Patients Without Insurance'')  AS Insurance,
 IP.Name As InsurancePlan,
 (VA.LiabilityBalance - VA.AssignedLiabilityBalance) As PatientLiability      
FROM  
 PatientCase PC WITH (NOLOCK)
LEFT JOIN  
 Person P WITH (NOLOCK)
ON  
 PC.PatientUID=P.PersonUID  
LEFT JOIN  
 Person P1 WITH (NOLOCK)
ON  
 PC.ProviderUID=P1.PersonUID  
LEFT JOIN  
 Patient PT WITH (NOLOCK)
ON  
 PC.PatientUID=PT.PersonUID  
LEFT JOIN  
 Visit V WITH (NOLOCK)
ON  
 PC.PatientUID=V.PatientUID  
LEFT JOIN  
 ListServiceSite LSS WITH (NOLOCK)
ON  
 V.ServiceSiteUID=LSS.ServiceSiteUID 
INNER JOIN   
 PatientCaseModuleData PCM WITH (NOLOCK) -- TO GET FINAL EDD  
ON   
 PCM.PatientCaseUid = PC.PatientCaseUid  
AND
 PCM.CaseTypeModuleUid = ''4B29D2ED-4983-4F4A-B16F-070659F6AC30''  
INNER JOIN   
 PatientCaseModuleData PCMO WITH (NOLOCK) -- TO GET OTHER OB INFORMATION  
ON   
 PCMO.PatientCaseUid = PC.PatientCaseUid  
AND  
 PCMO.Name=''Other Info''  
  LEFT JOIN 
 Account AC WITH (NOLOCK)
ON 
  AC.Personuid = V.Patientuid AND  AC.AccountUid=V.AccountUid
LEFT JOIN  
  dbo.AccountPeriod AP WITH (NOLOCK)
ON   
AC.AccountUid = AP.AccountUid   
AND 
(
	(AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(V.Visitdate AS DATE))
	OR 
	(AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(V.Visitdate AS DATE) AND CAST(AP.expirationDate AS DATE) >= CAST(V.Visitdate AS DATE)) 
	OR
	(AP.effectiveDate IS NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.expirationDate AS DATE) >= CAST(V.Visitdate AS DATE) ) 
	OR 
	(AP.effectiveDate IS NULL AND AP.ExpirationDate IS NULL)
)  
LEFT JOIN
	AccountInsurance AI WITH (NOLOCK)
ON   
	AI.AccountPeriodUid = AP.AccountPeriodUid AND AI.DisplayOrder=1  
LEFT JOIN  
	PersonInsurancePlan PIP WITH (NOLOCK)
ON   
	PIP.PersonInsurancePlanUid = AI.PersonInsurancePlanUid   
LEFT JOIN  
	InsurancePlan IP WITH (NOLOCK)
ON   
	IP.InsurancePlanUid = PIP.InsurancePlanUid  
LEFT JOIN
	Corporation C WITH (NOLOCK)
ON
	C.CorporationUid = IP.InsuranceCarrierUid   
LEFT JOIN  
	AR_ViewAccountAggregate VA WITH (NOLOCK)
ON  
	AC.AccountUid=VA.AccountUid
)

Select
O.PatientUID
,O.ProviderUID
,O.ExternalID
,O.PatientName
,O.ProviderName
,O.ServiceSiteUID
,O.ServiceSite
,O.PhoneNumber
,O.NextAppointmentDate
,O.CaseName
--,convert(xml,O.ModuleData) as ModuleData
,InitialExam
,Case when IsDate(O.EDD)=1 Then Convert(Varchar(50),O.EDD,101) Else Convert(varchar(50),DATEADD(month,10,InitialExam),101) End as EDD
,O.Hospital
,O.RecordSenton
,O.PatientCaseUid
,O.OBStartDate
,O.OBEndDate
,O.Insurance
,O.InsurancePlan
,O.PatientLiability
from CTE_OBReport O WITH (NOLOCK)







' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewRenderingProviderAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewRenderingProviderAggregateSub] WITH SCHEMABINDING  
AS  
SELECT RenderingProviderUid,         
		SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.AMOUNT ELSE 0 END) As Liability,         
		SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT ELSE 0 END) As AssignedLiability,        
		SUM(CASE WHEN L.EntryType = 2  THEN LD.AMOUNT*-1 ELSE 0 END) As Distribution,        
		SUM(CASE WHEN L.EntryType = 2 AND NOT LD.InsurancePlanUid IS NULL  THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedDistribution,        
		SUM(CASE WHEN L.EntryType = 3 THEN LD.AMOUNT*-1 ELSE 0 END) As Adjustment,        
		SUM(CASE WHEN L.EntryType = 3 AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedAdjustment,        
		SUM(LD.Amount) As LiabilityBalance,         
		SUM(CASE WHEN NOT LD.InsurancePlanUid IS NULL THEN LD.Amount ELSE 0 END) As AssignedLiabilityBalance,        
		COUNT_BIG(*) AS Count  
	FROM dbo.AR_LedgerDetail LD        
		INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
	WHERE NOT RenderingProviderUid IS NULL AND NOT SuperbillProcedureUid IS NULL   
	GROUP BY RenderingProviderUid      


/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewRenderingProviderAggregateSub_RenderingProviderUid ON AR_ViewRenderingProviderAggregateSub(RenderingProviderUid)

*/
' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewRenderingProviderAggregateSub]') AND name = N'PK_AR_ViewRenderingProviderAggregateSub_RenderingProviderUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewRenderingProviderAggregateSub_RenderingProviderUid] ON [dbo].[AR_ViewRenderingProviderAggregateSub]
(
	[RenderingProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewRenderingProviderAggregate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewRenderingProviderAggregate] 
AS
SELECT PRO.PersonUid AS RenderingProviderUid, 
	ISNULL(VRPAB.Liability, 0) AS Liability, 
	CAST(ISNULL(VRPAB.AssignedLiability, 0) AS MONEY) AS AssignedLiability,
	ISNULL(VRPAB.LiabilityBalance, 0) AS LiabilityBalance, 
	CAST(ISNULL(VRPAB.AssignedLiabilityBalance, 0) AS MONEY) AS AssignedLiabilityBalance
FROM Provider PRO
LEFT JOIN AR_ViewRenderingProviderAggregateSub (NOEXPAND) VRPAB ON PRO.PersonUid = VRPAB.RenderingProviderUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewVisit]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewVisit] AS
SELECT		v.VisitUid, v.VisitDate, 
			v.PatientUid, dbo.UDF_getFormattedName(per.Prefix, per.FirstName, per.MiddleName, per.LastName, per.Suffix) AS PatientName, 
			a.StartDateTime, a.EndDateTime, 
            dbo.UDF_getFormattedName(per.Prefix, per.FirstName, per.MiddleName, per.LastName, per.Suffix) + ''(visit date:'' + CONVERT(varchar(20), v.VisitDate, 120) + '')'' + CASE WHEN a.StartDateTime IS NULL THEN '''' ELSE '' for appoinment on '' + CONVERT(varchar(20), a.StartDateTime, 120) END AS Name, 
			v.IsCompleted,
			prov.FormattedInternalName AS Provider,
			rprov.FormattedInternalName AS RenderingProvider,
			ss.Name AS ServiceSite,
			fc.Name AS FinancialCenter
FROM        Visit v INNER JOIN Person per ON v.PatientUid = per.PersonUid 
			LEFT JOIN Appointment a ON v.AppointmentUid = a.AppointmentUid
			LEFT JOIN ViewProvider prov ON v.ProviderUid = prov.PersonUid
			LEFT JOIN ViewProvider rprov ON v.RenderingProviderUid = rprov.PersonUid
			LEFT JOIN ListServiceSite ss ON v.ServiceSiteUid = ss.ServiceSiteUid
			LEFT JOIN FinancialCenter fc ON v.FinancialCenterUid = fc.FinancialCenterUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCollectionLetterPrintQueue]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewCollectionLetterPrintQueue]
AS
SELECT 
     CLPQ.CollectionLetterPrintQueueUid AS ViewUid, 
     ARP.AccountResponsiblePartyUid, 
     ARP.ExternalID, 
     CASE WHEN ARP.PersonUid IS NULL THEN RC.Name 
          WHEN ARP.CorporationUid IS NULL THEN RP.FormattedPreferredName 
          ELSE '''' END AS ARName, 
     dbo.GetAccountRPBalanceInCollections(ARP.AccountResponsiblePartyUid) AS BalanceInCollections, 
     ARP.CollectionStatusExpirationDate AS PaymentDueDate, 
     CASE WHEN ARP.OverrideSufficient = 1 THEN ARP.OverridePaymentAmount 
          ELSE ARP.CalculatedPaymentAmount END AS PaymentAmount, 
     ARP.CollectionStatusUid, 
     LCS.Name AS CollectionStatus, 
     ARP.CollectionStatusLevelUid,
     CSL.Name AS CollectionStatusLevel, 
     DATEDIFF(DAY, ISNULL(dbo.GetAccountResponsiblePartyMostRecentPaymentDate(ARP.AccountResponsiblePartyUid), 
              ARP.DateEnteredCollections), GETUTCDATE()) AS DaysSinceLastPayment,
     AG.Name AS LetterName,
     AG.LastModifiedDate AS LetterGeneratedDate,
     AG.AttachmentGroupUid,
     CASE WHEN CLPQ.LastPrintedDate IS NULL THEN '' ''
          ELSE CONVERT( VARCHAR(30), CLPQ.LastPrintedDate, 101 ) END AS LastPrinted
FROM CollectionLetterPrintQueue CLPQ
	INNER JOIN RelAttachmentGroup RAG ON  CLPQ.RelAttachmentGroupUid = RAG.RelAttachmentGroupUid  
	INNER JOIN AttachmentGroup AG ON RAG.AttachmentGroupUid = AG.AttachmentGroupUid
	INNER JOIN AccountResponsibleParty ARP ON RAG.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid
    LEFT JOIN ViewPerson RP WITH (NOEXPAND) ON ARP.PersonUid = RP.PersonUid
    LEFT JOIN Corporation RC ON ARP.CorporationUid = RC.CorporationUid
	LEFT JOIN ListCollectionStatus LCS ON ARP.CollectionStatusUid = LCS.CollectionStatusUid 
	LEFT JOIN CollectionStatusLevel CSL ON ARP.CollectionStatusLevelUid = CSL.CollectionStatusLevelUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_MDOL_RPT2_UserGroup]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[View_MDOL_RPT2_UserGroup]

AS

Select 
	ListUserGroup.ExternalID,
	ListUserGroup.UserGroupuID,
	ListUserGroup.Name as UserGroupName ,
	[dbo].[MDOL_RPT2_getUserGroupMember](ListUserGroup.UserGroupuID) AS UserGroupMember,
	ListUserGroupType.Name as UserGroupTypeName ,	
	ViewFindUserAndUserGroup.Name as UserGroupMemberForMsgSecurity,	
	[dbo].[MDOL_RPT2_getUserGroupMemberMaxPermission](SecurityUserGroup.Permission) AS Persmission,
--	ListUserGroup.UserGroupTypeUid,	                 
--	SecurityUserGroup.UserGroupUid as SecurityGroupUid , 
--    SecurityUserGroup.Permission,                      
--	SecurityUserGroup.UserDefined,
--	SecurityUserGroup.LastModifiedDate,
--	ListUserGroup.UserGroupUid,
--	ListUserGroupType.Notes as Notes2,

	ListUserGroup.Inactive,
--	ViewFindUserAndUserGroup.Name as UserName,

	ListUserGroup.Notes as Notes,
	(CASE WHEN ListUserGroup.Inactive=0 THEN ''Active User Groups'' ELSE ''Inactive User Groups'' END) AS Type 
	
FROM        
			ListUserGroup WITH (NOLOCK)
Left Join
			ListUserGroupType WITH (NOLOCK)
on 
			ListUserGroup.UserGroupTypeUid=ListUserGroupType.UserGroupTypeUid
Left Join
            SecurityUserGroup WITH (NOLOCK)
On         
			ListUserGroup.UserGroupUid = SecurityUserGroup.ParentObjectUid
AND
	SecurityUserGroup.SecurityUid = ''10101010-0000-0000-0000-100000000100''
Left Join
	ViewFindUserAndUserGroup WITH (NOLOCK)
on
	SecurityUserGroup.UserPRMuid=ViewFindUserAndUserGroup.uid 
OR
	SecurityUserGroup.UserGroupUId=ViewFindUserAndUserGroup.uid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCollectionsAccountResponsiblePartySearch]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewCollectionsAccountResponsiblePartySearch]
AS
SELECT DISTINCT 
                      dbo.AccountResponsibleParty.AccountResponsiblePartyUid, dbo.AccountResponsibleParty.ExternalID, 
                      CASE WHEN AccountResponsibleParty.PersonUid IS NULL THEN responsibleCor.Name WHEN AccountResponsibleParty.CorporationUid IS NULL 
                      THEN dbo.UDF_getFormattedPreferredName(responsiblePerson.PersonUid) ELSE '''' END AS ARName, 
                      CASE WHEN AccountResponsibleParty.PersonUid IS NULL THEN UPPER(responsibleCor.Name) 
                      WHEN AccountResponsibleParty.CorporationUid IS NULL THEN UPPER(responsiblePerson.LastName) ELSE '''' END AS ARFilterName, 
                      dbo.GetAccountRPBalanceInCollections(dbo.AccountResponsibleParty.AccountResponsiblePartyUid) AS BalanceInCollections, 
                      dbo.AccountResponsibleParty.CollectionStatusExpirationDate AS PaymentDueDate, 
                      CASE WHEN AccountResponsibleParty.OverrideSufficient = 1 THEN AccountResponsibleParty.OverridePaymentAmount ELSE AccountResponsibleParty.CalculatedPaymentAmount
                       END AS PaymentAmount, dbo.AccountResponsibleParty.CollectionStatusUid, dbo.ListCollectionStatus.Name AS CollectionStatus, 
                      dbo.AccountResponsibleParty.CollectionStatusLevelUid, dbo.CollectionStatusLevel.Name AS CollectionStatusLevel, DATEDIFF(day, 
                      ISNULL(dbo.GetAccountResponsiblePartyMostRecentPaymentDate(dbo.AccountResponsibleParty.AccountResponsiblePartyUid), 
                      dbo.AccountResponsibleParty.DateEnteredCollections), GetUTCDate()) AS DaysSinceLastPayment,
					  -- 59379:Collections Screen Available Payer Credits should display as a positive value
                      -VPCBP.PayerCreditBalance AS PayerCreditBalance
FROM         dbo.AccountResponsibleParty LEFT OUTER JOIN
                      dbo.Person AS responsiblePerson ON responsiblePerson.PersonUid = dbo.AccountResponsibleParty.PersonUid LEFT OUTER JOIN
                      dbo.Corporation AS responsibleCor ON responsibleCor.CorporationUid = dbo.AccountResponsibleParty.CorporationUid INNER JOIN
                      dbo.ListCollectionStatus ON dbo.AccountResponsibleParty.CollectionStatusUid = dbo.ListCollectionStatus.CollectionStatusUid LEFT OUTER JOIN
                      dbo.CollectionStatusLevel ON dbo.AccountResponsibleParty.CollectionStatusLevelUid = dbo.CollectionStatusLevel.CollectionStatusLevelUid LEFT OUTER JOIN 
                      AR_ViewPayerCreditByPayer VPCBP ON dbo.AccountResponsibleParty.AccountResponsiblePartyUid = VPCBP.AccountResponsiblePartyUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewBalanceAndCloseChargesReport]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewBalanceAndCloseChargesReport]      
AS  -- $Id: Daily Charges Trial Balance.sql,v 1.2 2007/12/19 11:24:04 imedica\susheela Exp $        
SELECT   
 SB.ExternalID,   
 SB.ServiceDateStart,  
 ARB.ARBatchUid,  
 ARB.[Name] AS BatchName,   
 ARB.GLDate AS GLDate,   
 LD.LiabilityOwner  AS ARContextUid,   
 LP.Code as ShortDescription,  
 LD.RenderingProviderUid,  
 LD.ClaimingProviderUid,   
 LD.FinancialCenterUid,  
 FC.Name AS FinancialCenter,   
 LD.ServiceSiteUid,  
 LD.amount as Amount,
 --VSPA.liability as BalanceAll,     
 VSB.LiabilityBalance AS BalanceAll,
    --Convert(NUMERIC(20,2),SUM(LD.Amount)) AS Amount,       
    --Convert(NUMERIC(20,2),SUM(VSPA.Liability )) AS BalanceAll,     
    dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName, p.LastName, p.Suffix) AS PatientName,       
    LSS.InternalSite,   
    LSS.Name AS Expr1,   
    LD.LastModifiedByUid,
    CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed	    
FROM           
  
     AR_Ledger L  
INNER JOIN  
 AR_LedgerDetail LD  
ON  
 L.LedgerUid=LD.LedgerUid AND (L.EntryType=1) 
--LEFT JOIN  
-- AR_Transaction T  
--ON  
-- L.TransactionUid = T.TransactionUid   
LEFT JOIN  
 ARBatch ARB  
ON   
 ARB.ARBatchUID=L.ARBatchUID  
INNER JOIN  
 SuperbillProcedure SP  
ON  
 SP.SuperbillProcedureUid=LD.SuperbillProcedureUid  
--INNER JOIN  
-- AR_ViewSuperbillProcedureAggregate VSPA  
--ON   
--    SP.SuperbillProcedureUid = VSPA.SuperbillProcedureUid   
LEFT JOIN  
 Superbill  SB  
ON   
 SB.SuperbillUid = SP.SuperbillUid 
INNER JOIN
	AR_ViewSuperbillAggregate VSB
ON
	SB.SuperbillUid =VSB.SuperbillUid   
LEFT JOIN    
    ACCOUNT AC    
ON     
    AC.AccountUid=SB.AccountUID   
LEFT JOIN  
 Person P   
ON   
 P.PersonUid = AC.PersonUid   
LEFT JOIN      
    ListServiceSite LSS   
ON   
 LSS.ServiceSiteUid = LD.ServiceSiteUid  
LEFT JOIN  
 FinancialCenter FC  
ON   
 FC.FinancialCenterUid = LD.FinancialCenterUid   
LEFT JOIN  
 ListProcedure LP  
ON   
 SP.ProcedureUid = LP.ProcedureUid
LEFT JOIN
	AR_ViewBatchClosingsLockedClosed VARB
ON
	ARB.ArBatchUid =VARB.ARBatchUid	   
--By Qatalys : To show the charge reversal.      
--WHERE    arc.Inactive=0       
--GROUP BY sb.ExternalID, sb.ServiceDateStart,arb.ARBatchUid,arb.[Name], ARB.GLDate,LD.LedgerUid,  lp.Code, LD.RenderingProviderUid,LD.ClaimingProviderUid, LD.ServiceSiteUid, dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName,   
--p.LastName, p.Suffix),       
--                      lss.InternalSite, lss.Name, LD.LastModifiedByUid, LD.FinancialCenterUid,fc.Name     
    


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ChcViewAccountResponsiblePartySFHistory]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ChcViewAccountResponsiblePartySFHistory]
AS
SELECT     TOP (100) PERCENT h.AccountResponsiblePartySFHistoryUid, h.AccountResponsiblePartyUid, h.FamilySize, h.MonthlyIncome, 
                      h.MonthlyIncome * 12 AS AnnualIncome, h.NoIncome, h.SFCorporationUid, CASE WHEN (h.SFCorporationUid IS NULL) 
                      THEN ''None '' ELSE c.Name END AS SFCarrierName, sd.SFScheduleUid, CASE WHEN (sfs.Name IS NULL) 
                      THEN ''None '' ELSE sfs.Name END AS SFSchedule, h.SFScheduleDetailUid, CASE WHEN (sd.PovertyPercent IS NULL) 
                      THEN ''None '' ELSE Cast(sd.PovertyPercent as Varchar(10)) END AS SFPovertyPercent, CASE WHEN (sd.Name IS NULL) THEN ''None '' ELSE sd.Name END AS SFClass, 
                      h.SFFormOfDeclarationUid, CASE WHEN (fod.Name IS NULL) THEN ''None '' ELSE fod.Name END AS FormOfDeclaration, h.SFEffectiveDate, 
                      h.NotFedSFQual, h.RefusedFSMI, h.UseSFClass, h.SFNote, h.LastModifiedDate, h.LastModifiedByUid, dbo.UDF_getFormattedNameChc(p.Prefix, 
                      p.FirstName, p.MiddleName, p.LastName, p.Suffix) AS LastModifiedBy
FROM         dbo.ChcAccountResponsiblePartySFHistory AS h LEFT OUTER JOIN
                      dbo.ViewPerson AS p ON p.PersonUid = h.LastModifiedByUid LEFT OUTER JOIN
                      dbo.ViewCorporation AS c ON h.SFCorporationUid = c.CorporationUid LEFT OUTER JOIN
                      dbo.ChcListSFFormOfDeclaration AS fod ON h.SFFormOfDeclarationUid = fod.SFFormOfDeclarationUid LEFT OUTER JOIN
                      dbo.ChcListSFScheduleDetail AS sd ON h.SFScheduleDetailUid = sd.SFScheduleDetailUid LEFT OUTER JOIN
                      dbo.ChcListSFSchedule AS sfs ON sd.SFScheduleUid = sfs.SFScheduleUid
ORDER BY h.SFEffectiveDate DESC, h.LastModifiedDate DESC
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_AdjustmentSummary]'))
EXEC dbo.sp_executesql @statement = N'

-- 10/23/2014 kc fixed Bug #31737: Report is combining Adjustments. modified to match MDOL_RPT2_View_AdjustmentDetail on inner join tp AR_LedgerDetail
-- 05/01/2017 kculberth added ServiceSiteUid to data set

CREATE VIEW [dbo].[MDOL_RPT2_View_AdjustmentSummary]  
AS  
 SELECT  
  ISNULL(LD.Amount,0) as Adjustment,  
  coalesce(LCT1.Name,''Without Adjustment Type'') as TransactionName,  
  LCT1.CreditTypeUid,  
  AB.GLDate,  
  D.DepositDate,  
  --CR.CreditUID, 
  LD.LedgerDetailUid as CreditUID, 
  LD.RenderingProviderUID,  
  ISNULL(LD.ClaimingProviderUID,LD.RenderingProviderUID) AS ClaimingProviderUID,  
  LD.RenderingProviderUid AS ProviderUid,   
  LD.FinancialCenterUID,
  LD.ServiceSiteUid,
  CASE WHEN VARB.IsClosed =1 THEN 1 ELSE 0 END AS IsBatchClosed   
 FROM  
 	AR_Ledger L WITH(NOLOCK)
INNER JOIN
	AR_LedgerDetail LD WITH(NOLOCK)
ON
--	L.LedgerUid=LD.LedgerUid AND L.EntryType=3 AND LD.IsCredit=0 --  AND LD.SuperbillProcedureUid IS NOT NULL -- AND LD.IsCredit=1
	L.LedgerUid=LD.LedgerUid AND L.EntryType=3  AND LD.SuperbillProcedureUid IS NOT NULL --AND LD.IsCredit=1
INNER JOIN
		AR_ViewBatchClosingsLockedClosed VARB WITH(NOLOCK)
ON
		L.ArBatchUid =VARB.ARBatchUid		
LEFT JOIN
	AR_Transaction T WITH(NOLOCK)
ON
	L.TransactionUid = T.TransactionUid 
left JOIN    
	ListCreditType LCT1   WITH(NOLOCK)
ON
	LD.IncomeAccountUid =LCT1.CreditTypeUid 
LEFT JOIN 
	ARBatch AB  WITH(NOLOCK)
ON 
	L.ArBatchUid = AB.ARBatchUid
LEFT JOIN    
    ViewDeposit D     WITH(NOLOCK)
ON    
    D.DepositUID=T.DepositUID 





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_ResultStatus]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[MDOL_RPT2_VIEW_ResultStatus]  AS 
SELECT [UserDefinedDataUid], [ExternalID], [Name], [Notes], [Inactive], [FindTableUid], [UserDefined], [DisplayOrder], [LastModifiedByUid], [LastModifiedDate] FROM [ListUserDefinedData] with (NOLOCK)
 WHERE ([Inactive]=0 AND [FindTableUid]=''570186EA-D3B9-473B-B455-A67A6007FF1D'')
-- AND 
--NOT UserDefinedDataUid IN (SELECT [Uid] FROM [RelFindTableHide]
-- WHERE ([FindTableUid]=''570186EA-D3B9-473B-B455-A67A6007FF1D'' AND [UserUid]=''004ACE28-E4F7-4A9A-A648-D8A5B97C0FF2'')
--)



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewVisitDiagnosis]'))
EXEC dbo.sp_executesql @statement = N'

--20150611 kculberth updated for ICD10

CREATE VIEW [dbo].[MDOL_RPT2_ViewVisitDiagnosis]  
AS
	SELECT V.VisitUid,V.VisitDate, V.PatientUid,ISNULL(VD.Code10,Code) AS DiagnosisCode, 
	VD.Code10 as Code10, VD.Code as Code,
	vd.Name as ShortDescription, vd.IsDelete as IsDelete, v.ProviderUid, v.RenderingProviderUid
	FROM  Visit AS V WITH (NOLOCK)
	INNER JOIN VisitDiagnosis AS VD WITH (NOLOCK) ON V.VisitUid = VD.VisitUid AND VD.IsDelete = 0


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewVisitSOSPDGCodes]'))
EXEC dbo.sp_executesql @statement = N'


--20150611 kculberth updated for ICD10

CREATE VIEW [dbo].[MDOL_RPT2_ViewVisitSOSPDGCodes]
AS
SELECT 
	A.VisitUid, 
	A.PatientUid,
	A.VisitDate,
	A.Code,
	A.Diagnosiscode9,
	A.Code9,
	A.Code10,
	A.SOProcedureUid,
	A.SPProcedureUid,
	A.DiagnosisUid,
	A.ResultStatusUid,
	A.ResultStatus
FROM
(
SELECT  
	V.VisitUid, V.PatientUid ,V.VisitDate ,LP.Code,'''' AS Diagnosiscode9, '''' as Code9, '''' as Code10,LP.ProcedureUid AS SOProcedureUid,NULL AS SPProcedureUid,NULL AS DiagnosisUid, RS.UserDefinedDataUID AS ResultStatusUid,RS.Name AS ResultStatus
FROM Visit (NOLOCK) V
INNER JOIN VisitProcedure (NOLOCK) VP ON V.VisitUid=VP.VisitUid AND VP.IsDelete = 0
LEFT JOIN ObservationOrder (NOLOCK) OO ON OO.VisitProcedureUid=VP.VisitProcedureUid AND OO.IsDelete = 0
LEFT JOIN MDOL_RPT2_VIEW_ResultStatus (NOLOCK) RS ON RS.ExternalID = OO.ResultStatusID
INNER JOIN ListProcedure (NOLOCK) LP ON	VP.ProcedureUid =LP.ProcedureUid 
UNION ALL

SELECT  
	V.VisitUid, V.PatientUid ,V.VisitDate,'''',VVD.DiagnosisCode as DiagnosisCode9,VVD.Code as Code9,VVD.Code10,NULL AS SOProcedureUid, NULL AS SPProcedureUid,
	NULL AS DiagnosisUid,NULL AS ResultStatusUid, '''' AS ResultStatus
FROM Visit (NOLOCK) V 
INNER JOIN MDOL_RPT2_ViewVisitDiagnosis VVD ON	V.PatientUID = VVD.PatientUID AND V.VisitUid=VVD.VisitUid 
)A





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPersonAggregate]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[AR_ViewPersonAggregate] 
AS
SELECT PE.PersonUid as PersonUid, 
	SUM(ISNULL(VAA.Liability,0)) AS Liability, SUM(ISNULL(VAA.AssignedLiability,0)) AS AssignedLiability,
	SUM(ISNULL(VAA.LiabilityBalance,0)) AS LiabilityBalance, SUM(ISNULL(VAA.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance
FROM Person PE
LEFT JOIN Account AC ON PE.PersonUid = AC.PersonUid
LEFT JOIN AR_ViewAccountAggregate VAA ON AC.AccountUid = VAA.AccountUid
GROUP BY PE.PersonUid ' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_AccountLastTransaction]'))
EXEC dbo.sp_executesql @statement = N'

-- 20151103 kculberth Fix Bug 42334:Incorrect Last Insurance Payment Date on Patient Ledger

CREATE VIEW [dbo].[MDOL_RPT2_VIEW_AccountLastTransaction] 
AS 
Select ARP.AccountResponsiblePartyUid, S.AccountUid, LastPatientPaymentDate,
ROW_NUMBER() OVER (PARTITION BY S.AccountUid ORDER BY LastPatientPaymentDate DESC) AS ''PatientRowNum'',
ROW_NUMBER() OVER (PARTITION BY S.AccountUid ORDER BY LastInsurancePaymentDate DESC) AS ''InsuranceRowNum'',
lastpatientpaymentamount,
LastInsurancePaymentAmount,
LastInsurancePaymentDate
from dbo.SuperbillAggregate as SA WITH (NOLOCK)
JOIN dbo.Superbill as S WITH (NOLOCK) ON S.SuperbillUid = SA.SuperbillUid 
LEFT JOIN Account as AC WITH (NOLOCK) ON AC.AccountUid=S.AccountUid
LEFT JOIN AccountResponsibleParty as ARP WITH (NOLOCK) ON ARP.AccountResponsiblePartyUid=AC.AccountResponsiblePartyUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_LedgerGetTransactions]'))
EXEC dbo.sp_executesql @statement = N'
-- 20151103 kculberth Fix Bug 42334:Incorrect Last Insurance Payment Date on Patient Ledger

CREATE VIEW [dbo].[MDOL_RPT2_VIEW_LedgerGetTransactions]
AS 
SELECT AC.AccountUid,
	   SUM(ISNULL(VSPAB.Liability,0)) AS BilledAmount,
	   SUM(ISNULL(VSPAB.Distribution,0)) AS TotalPayment,
	   SUM(ISNULL(VSPAB.AssignedDistribution ,0)) AS InsurancePayment,
	   SUM(ISNULL(VSPAB.Distribution - VSPAB.AssignedDistribution ,0)) AS PatientPayment,
	   MAX(ALTPatient.LastPatientPaymentDate) AS LastPatientPaymentDate,
	   MAX(ALTPatient.LastPatientPaymentAmount)  AS LastPatientPaymentAmount,
	   MAX(ALTPatient.LastPatientPaymentDate) AS LastPaymentDate,
	   MAX(ALTPatient.LastPatientPaymentAmount)  AS LastPaymentAmount,
	   MAX(ALTInsurance.LastInsurancePaymentDate) AS LastInsurancePaymentDate,
	   MAX(ALTInsurance.LastInsurancePaymentAmount)  AS LastInsurancePaymentAmount,    
	   --'''' AS LastPaymentDate,
	   --0  AS LastPaymentAmount,
	   0 AS AccountCredits
FROM Account AC WITH (NOLOCK)
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub VSPAB WITH (NOEXPAND) ON AC.AccountUid = VSPAB.AccountUid
LEFT JOIN	[MDOL_RPT2_VIEW_AccountLastTransaction] ALTPatient WITH (NOLOCK) ON AC.AccountUid  = ALTPatient.AccountUid AND ALTPatient.PatientRowNum=1
LEFT JOIN	[MDOL_RPT2_VIEW_AccountLastTransaction] ALTInsurance WITH (NOLOCK) ON AC.AccountUid  = ALTInsurance.AccountUid AND ALTInsurance.InsuranceRowNum=1
GROUP BY AC.AccountUid






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewPayerCredit]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[MDOL_RPT2_ViewPayerCredit] 
AS
	SELECT  LD.PayerCreditUid, LD.FinancialCenterUid, LD.ServiceSiteUid, LD.ClaimingProviderUid,
			 LD.RenderingProviderUid AS ProviderUid,--,SUM(LD.AMOUNT * -1) AS Receipt,MAX(VPCA.ReceiptBalance) AS ReceiptBalance,MIN(ARB.GLDate) AS GLDate,
			 LS.Name AS ServiceSiteName,FC.Name AS FinancialCenterName,DBO.UDF_getFormattedPreferredNameFromValues(P.FirstName,P.LastName,P.MiddleName,P.Suffix ) Provider,
			 ARB.ARbatchuid,ARB.GLDate,CASE  WHEN ARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed, LD.Amount AS Receipt, LD2.DepositUid,ARB.Name as BatchName,ld.AccountResponsiblePartyUid 
			 --Row_Number() OVER (PARTITION BY LD.PayerCreditUid ORDER BY ARB.GLDate asc) as pcCount
			 ,LD.IncomeAccountUid,LD.InsurancePayerUid,LD.RenderingProviderUid 
	FROM AR_LedgerDetail LD (NOLOCK)
		INNER JOIN AR_Ledger L (NOLOCK) ON LD.LedgerUid = L.LedgerUid
		INNER JOIN ARBatch ARB (NOLOCK) ON L.ArBatchUid =ARB.ARBatchUid 
		LEFT JOIN ListServiceSite LS (NOLOCK) ON LS.ServiceSiteUid=LD.ServiceSiteUid
		LEFT JOIN FinancialCenter FC (NOLOCK) ON FC.FinancialCenterUid=LD.FinancialCenterUid
		INNER JOIN Person P (NOLOCK) on LD.RenderingProviderUid =P.PersonUid 
		--INNER JOIN AR_PayerCredit PC ON LD.PayerCreditUid = PC.PayerCreditUid 
		LEFT JOIN AR_LedgerDetail LD2 (NOLOCK) ON L.LedgerUid =LD2.LedgerUid AND LD.LedgerDetailUid != LD2.LedgerDetailUid 
		WHERE L.EntryType = 0 AND NOT LD.PayerCreditUid IS NULL AND LD.IsCredit = 1 --AND L.VoidLedgerUid IS NULL




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewRefund]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[MDOL_RPT2_ViewRefund] 
AS
	SELECT  LD.PayerCreditUid, LD.FinancialCenterUid, LD.ServiceSiteUid, LD.ClaimingProviderUid,
			 LD.RenderingProviderUid AS ProviderUid,--,SUM(LD.AMOUNT * -1) AS Receipt,MAX(VPCA.ReceiptBalance) AS ReceiptBalance,MIN(ARB.GLDate) AS GLDate,
			 LS.Name AS ServiceSiteName,FC.Name AS FinancialCenterName,DBO.UDF_getFormattedPreferredNameFromValues(P.FirstName,P.LastName,P.MiddleName,P.Suffix ) Provider,
			 ARB.ARbatchuid,ARB.GLDate,CASE  WHEN ARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed, LD.Amount AS Receipt,LD2.DepositUid,ld.AccountResponsiblePartyUid, 
			 ARB.Name as BatchName,
			 LD.IncomeAccountUid
			 
	FROM AR_LedgerDetail LD with (NOLOCK)
		INNER JOIN AR_Ledger L with (NOLOCK) ON LD.LedgerUid = L.LedgerUid
		INNER JOIN ARBatch ARB with (NOLOCK) ON L.ArBatchUid =ARB.ARBatchUid 
		LEFT JOIN ListServiceSite LS with (NOLOCK) ON LS.ServiceSiteUid=LD.ServiceSiteUid
		LEFT JOIN FinancialCenter FC with (NOLOCK) ON FC.FinancialCenterUid=LD.FinancialCenterUid
		INNER JOIN Person P with (NOLOCK) on LD.RenderingProviderUid =P.PersonUid 
		LEFT JOIN AR_LedgerDetail LD2 with (NOLOCK) ON L.LedgerUid =LD2.LedgerUid AND LD.LedgerDetailUid != LD2.LedgerDetailUid 
		WHERE L.EntryType = 0 AND NOT LD.PayerCreditUid IS NULL AND LD.Iscredit = 0  AND L.VoidLedgerUid IS NULL
		



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewInsurancePayerAggregate_SumPlanLiabilities]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewInsurancePayerAggregate_SumPlanLiabilities] 
AS
SELECT IC.CorporationUid as InsurancePayerUid, 
	SUM(ISNULL(VIPLA.Liability,0)) AS Liability, 
	SUM(ISNULL(VIPLA.LiabilityBalance,0)) AS LiabilityBalance 
FROM InsuranceCarrier IC 
LEFT JOIN InsurancePlan IPL ON IC.CorporationUid = IPL.InsuranceCarrierUid
LEFT JOIN AR_ViewInsurancePlanAggregate VIPLA ON IPL.InsurancePlanUid = VIPLA.InsurancePlanUid
GROUP BY IC.CorporationUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewInsurancePayerAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewInsurancePayerAggregateSub] WITH SCHEMABINDING  AS  
	SELECT InsurancePayerUid, 
	SUM(CASE WHEN IsCredit = 0 THEN 0 ELSE AMOUNT*-1 END) As Receipt,         
	SUM(AMOUNT*-1) As ReceiptBalance, 
	COUNT_BIG(*) AS Count  
	FROM dbo.AR_LedgerDetail   
	WHERE NOT InsurancePayerUid IS NULL  
	GROUP BY InsurancePayerUid            

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewInsurancePayerAggregateSub_InsurancePayerUid ON AR_ViewInsurancePayerAggregateSub(InsurancePayerUid)

*/
' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewInsurancePayerAggregateSub]') AND name = N'PK_AR_ViewInsurancePayerAggregateSub_InsurancePayerUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewInsurancePayerAggregateSub_InsurancePayerUid] ON [dbo].[AR_ViewInsurancePayerAggregateSub]
(
	[InsurancePayerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewInsurancePayerAggregate]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewInsurancePayerAggregate] 
AS
SELECT IP.CorporationUid AS InsurancePayerUid, 
	ISNULL(VIPAB.Receipt, 0) AS Receipt,
	ISNULL(VIPAB.ReceiptBalance, 0) AS ReceiptBalance,
	ISNULL(SPL.Liability, 0) AS Liability, 
	ISNULL(SPL.LiabilityBalance, 0) AS LiabilityBalance 
FROM InsuranceCarrier IP
LEFT JOIN AR_ViewInsurancePayerAggregateSub (NOEXPAND) VIPAB ON IP.CorporationUid = VIPAB.InsurancePayerUid
LEFT JOIN AR_ViewInsurancePayerAggregate_SumPlanLiabilities SPL ON IP.CorporationUid = SPL.InsurancePayerUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPayerCredit]'))
EXEC dbo.sp_executesql @statement = N'



-- Bug 36072: SQL Timeout error message being received when trying to add superbill to payment
--   commented out join with ld_os
-- Bug 35384: Track Payer Credits - Server Times Out when searching for payer credits in Hard Closed Batches
--   Replace AR_ViewPayerCreditAggregate with AR_ViewPayerCreditAggregateSub
--   Calculate refunds with internal common table expression
-- Bug 40912 - After Payer Credit reverts back to the Original Payer Credit it is only visible when the "Include Void" box is checked on the Payer Credit Screen
--   View was getting last ledgerDetail distribution entry so it saw the payer credit as voided.  Changed to only look at Payment ledger entry types.
--   Set bug history for details.
-- Bug 50611 - SQL Timeout when accessing payer credits
--     rewrote to remove extra common table expressions
-- Bug 54513:Application error when populating superbill ID in payer credit to allocate
--  Added myCTE to account for multiple payment ( ledger detail entries ) for the same payer credit

CREATE VIEW [dbo].[ViewPayerCredit]
AS

with myCTE as
(		select ROW_NUMBER() OVER ( PARTITION BY apc.payercredituid order by arl.createddatetime desc) as apcCnt,
			apc.payerCredituid     , ldp.LedgerDetailUid, arl.ledgeruid
		FROM AR_PayerCredit apc WITH (NOLOCK)
				INNER JOIN AR_LedgerDetail ldp with (nolock) on apc.PayerCreditUid = ldp.PayerCreditUid
					
				INNER JOIN AR_Ledger arl with (nolock) on ldp.LedgerUid = arl.LedgerUid
															AND arl.EntryType = 0 -- payment
)
	select 
			  apc.PayerCreditUid as PayerCreditUid,
			   ld.LedgerDetailUid,
			   apc.DepositUid,
		       d.ReferenceNumber as ReferenceNumber,
			   apc.Note, 
			   ld.ServiceSiteUid ,
			   lss.Name as ServiceSiteName,
			   ld.FinancialCenterUid ,
		       fc.Name AS FinancialCenterName,
			   ld.RenderingProviderUid ,
		       rendPr.FullName AS ProviderFullName,
			   ld.ClaimingProviderUid ,
			   clmPr.FullName AS ClaimProviderFullName,
			   ld.AccountResponsiblePartyUid,
		       COALESCE(VPer.FullName, '''') AS ResponsiblePartyFullName,
			   ld.InsurancePayerUid,
			   COALESCE(VPCorp.Name,'''') AS InsurancePayerFullName,
			   VPCAS.Receipt +
			     -( COALESCE( (	SELECT SUM(ld2.Amount)
								FROM AR_LedgerDetail ld2 WITH (NOLOCK) 
								WHERE ld.LedgerUid = ld2.LedgerUid AND ld2.DepositUid IS NOT NULL AND ld2.DepositUid != d.DepositUid
							), 0)) AS Receipt,
		       VPCAS.ReceiptBalance as ReceiptBalance,
		       ISNULL(IPA.LiabilityBalance,0) AS InsurancePayerLiabilityBalance,
			   ISNULL(ARPA.LiabilityBalance,0) AS AccountResponsiblePartyLiabilityBalance ,
			   CAST (
						CASE WHEN EXISTS ( SELECT TOP 1 *
											FROM Account act WITH (NOLOCK) 
													INNER JOIN Superbill sb WITH (NOLOCK) on act.AccountUid = sb.AccountUid
																							  AND sb.SuperbillStatusUid NOT IN 	(''FC8AD61B-139A-4CFA-9580-CDACFC3ACF90'', ''30F64D66-55CB-4438-BB2F-7A6250399312'') -- Canceled and Complete											
											WHERE ld.AccountResponsiblePartyUid IS NOT NULL 
													AND ld.AccountResponsiblePartyUid = act.AccountResponsiblePartyUid
										 ) THEN 1
							WHEN EXISTS ( SELECT TOP 1 *
											FROM InsurancePlan ip 
													inner join SuperbillAggregate sba WITH (NOLOCK) ON ip.InsurancePlanUid = sba.CurrentInsurancePlanUid
													inner join Superbill sb WITH (NOLOCK) ON sba.SuperbillUid = sb.SuperbillUid	
																							  AND sb.SuperbillStatusUid NOT IN 	(''FC8AD61B-139A-4CFA-9580-CDACFC3ACF90'', ''30F64D66-55CB-4438-BB2F-7A6250399312'') -- Canceled and Complete											
											WHERE ld.InsurancePayerUid IS NOT NULL
													AND ld.InsurancePayerUid = ip.InsuranceCarrierUid
										) THEN 1
							ELSE 0 END AS BIT ) as HasActiveSuperbills,
			   ISNULL(arb.IsLocked,0) AS IsLocked,
		       ISNULL(arb.IsClosed,0) AS IsClosed,
		       CASE WHEN arb.IsClosed = 1 THEN ''Closed'' 
			        WHEN arb.IsLocked = 1 THEN ''Locked''
			        ELSE ''Open'' END as BatchState,
			  CASE WHEN COALESCE(arl.VoidLedgerUid, Varl.LedgerUid) IS NULL THEN 0 ELSE 1 END AS Void,
			  CAST((CASE WHEN ISNULL(VPCAS.ReceiptBalance,0) = 0 THEN 1 ELSE 0 END) AS bit) as IsFullyAllocated,
			  arb.ArBatchUid as ARBatchUid,
			  arb.Name as ARBatchName,
			  (
				SELECT MIN(AP.StartDateTime) 
				FROM Account act WITH (NOLOCK) 
					INNER JOIN Appointment AP WITH (NOLOCK) ON act.AccountUid = AP.AccountUid AND AP.StartDateTime > GETUTCDATE()
				WHERE ld.PayerCreditUid IS NOT NULL 
						AND ld.AccountResponsiblePartyUid IS NOT NULL
						AND ld.AccountResponsiblePartyUid = act.AccountResponsiblePartyUid
			  ) as NextAppointmentStartDateTime,
			  isnull(pcrs.PayerCreditRefundStatusUid, pcrsOpen.PayerCreditRefundStatusUid) AS PayerCreditRefundStatusUid,
			  isnull(pcrs.Name, pcrsOpen.Name) AS RefundStatus,
			  apc.RefundNote,
			  d.PaymentTypeUid as PaymentTypeUid,
			  LPT.Name as PaymentTypeName,
			  LPT.DefaultRefundPaymentTypeUid,
			  LPTREF.Name as DefaultRefundPaymentTypeName,
			  apc.RefundApprovedDate,
			  apc.RefundApprovedByUid,
			  REFAPVDP.FullName AS RefundApprovedByPersonName
		FROM AR_PayerCredit apc WITH (NOLOCK)
		       INNER JOIN myCTE mc on apc.PayerCreditUid = mc.PayerCreditUid
				INNER JOIN AR_LedgerDetail ld with (nolock) on mc.LedgerDetailUid = ld.LedgerDetailUid
																and mc.apcCnt = 1
				INNER JOIN AR_Ledger arl on ld.LedgerUid = arl.LedgerUid
				--INNER JOIN AR_Ledger arl with (nolock) on ld.LedgerUid = arl.LedgerUid
				--											AND arl.EntryType = 0 -- payment
				INNER JOIN Deposit d with (nolock) on apc.depositUid = d.DepositUid
				INNER JOIN ARBatch ARB ON arl.ARBatchUid = ARB.ARBatchUid
				INNER JOIN AR_ViewPayerCreditAggregateSub VPCAS WITH (NOEXPAND) ON apc.PayerCreditUid = VPCAS.PayerCreditUid
				LEFT OUTER JOIN AR_Ledger Varl WITH (NOLOCK) ON  ld.LedgerUid = Varl.VoidLedgerUid
				LEFT OUTER JOIN ListServiceSite lss WITH (NOLOCK) on ld.ServiceSiteUid = lss.ServiceSiteUid
				LEFT OUTER JOIN FinancialCenter fc WITH (NOLOCK) on ld.FinancialCenterUid = fc.FinancialCenterUid
				LEFT OUTER JOIN ViewPerson rendPr WITH (NOEXPAND, NOLOCK) on ld.RenderingProviderUid = rendPR.PersonUid
				LEFT OUTER JOIN ViewPerson clmPr WITH (NOEXPAND, NOLOCK) on ld.ClaimingProviderUid = clmPr.PersonUid
				LEFT OUTER JOIN AccountResponsibleParty ARP WITH (NOLOCK) ON ld.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid -- on deposit
				LEFT OUTER JOIN ViewPerson VPer WITH (NOEXPAND, NOLOCK) ON ARP.PersonUid = VPer.PersonUid
				LEFT OUTER JOIN Corporation VPCorp WITH (NOLOCK) ON ld.InsurancePayerUid = VPCorp.CorporationUid
				LEFT OUTER JOIN ListPaymentType LPT WITH (NOLOCK) on d.PaymentTypeUid = LPT.PaymentTypeUid
				LEFT OUTER JOIN ListPaymentType LPTREF WITH (NOLOCK) ON LPT.DefaultRefundPaymentTypeUid = LPTREF.PaymentTypeUid	
				LEFT OUTER JOIN AR_ViewInsurancePayerAggregate IPA WITH (NOLOCK) ON ld.InsurancePayerUid = IPA.InsurancePayerUid
				LEFT OUTER JOIN AR_ViewAccountResponsiblePartyAggregate ARPA WITH (NOLOCK) ON ld.AccountResponsiblePartyUid = ARPA.AccountResponsiblePartyUid
				LEFT OUTER JOIN ListPayerCreditRefundStatus pcrs WITH (NOLOCK) on apc.payercreditrefundstatusuid = pcrs.payercreditrefundstatusuid
				LEFT OUTER JOIN ListPayerCreditRefundStatus pcrsOpen WITH (NOLOCK) on pcrsOpen.PayerCreditRefundStatusUid = ''5279AEE2-EF6A-44E5-8A3C-A6A4A916DB40''
				LEFT OUTER JOIN ViewPerson REFAPVDP WITH (NOEXPAND, NOLOCK) ON apc.RefundApprovedByUid = REFAPVDP.PersonUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewBalanceAndCloseTransactionsReport]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewBalanceAndCloseTransactionsReport]  
as                         
-- $Id: Daily Transactions Trial Balance.sql,v 1.1 2007/12/05 10:38:50 imedica\susheela Exp $            
-- THIS STORED PROCEDURE IS UNDER SOURCE CONTROL. ANY CHANGES TO IT NEED TO BE COMMITTED TO THE FILE LISTED IN THE ID TAG ABOVE.            
-- AFTER COMMITTING YOUR CHANGE DEVELOPMENT DATABASE(S) ON FIJI MUST BE ALSO UPDATED.            
-- 20170228 kculberth added "DISTINCT" to SELECT for Payer Credits for Bug 55758:Daily Transaction Trial Balance doubles the distributions when refunding a payer credit in prm 2016
SELECT            
   D.DepositUid AS DepositUid , 
    ''Y''  as IsPayment, -- This is lame. I can''t get reporting services to do filters based on bit columns though.            
   LPT.Name,            
   ISNULL(D.ReferenceNumber,'''')  ReferenceNumber,            
   D.DepositDate as DepositDate,
   ARB.GLDate as GLDate,           
   Null FinancialCenterUid,            
   ARB.ARBatchUID ARBatchUID,            
   --ISNULL(VDA.Receipt,0) as DepositAmount,   
   D.AmountInverse as DepositAmount, --         
   --COALESCE((VDA.Receipt - VDA.ReceiptBalance),0) as DepositAllocatedAmount, 
   D.AllocatedAmountInverse    as DepositAllocatedAmount,         
   --CASE WHEN LD2.PayerCreditUid  IS NULL THEN COALESCE(VDA.ReceiptBalance,0) ELSE 0 END AS UnappliedAmount,        
   D.UnallocatedAmountInverse  AS UnappliedAmount,        
   --ISNULL(CONVERT(VARCHAR,D.Comment),'''') AS Comment,  
   D.Comment  AS Comment,   
   COALESCE(D.WhoPaidName,'''') as PayerName,            
   Null as PatientName,            
   Null ExternalID,            
   Null ServiceDateEnd,            
   Null AS ShortDescription,            
   Null AS ProviderUid,
   Null AS ClaimingProviderUid,            
   0 AS CreditAmount,            
   Null as CreditTypeName,        
   CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed,
   Null PayerCreditUid
FROM 
	ViewDeposit  D
JOIN 
	ARBatch ARB 
ON 
	D.ArBatchUid = ARB.ARBatchUid
JOIN  
	AR_ViewBatchClosingsLockedClosed VARB  
ON  
	ARB.ArBatchUid =VARB.ARBatchUid
LEFT JOIN             
	 ListPaymentType LPT             
  on            
     LPT.PaymentTypeUid = D.PaymentTypeUid	
WHERE  
    --D.AmountInverse=D.UnallocatedAmountInverse  and 
		(D.AmountInverse!=0)
		
UNION ALL		   
			    
 SELECT            
   D.DepositUid AS DepositUid , 
   (CASE WHEN L.EntryType =2 THEN ''Y'' WHEN L.EntryType  is null THEN ''Y'' ELSE ''N'' END) as IsPayment, -- This is lame. I can''t get reporting services to do filters based on bit columns though.            
   LPT.Name,            
   CASE WHEN LD2.PayerCreditUid  IS NULL  THEN ISNULL(D.ReferenceNumber,'''') ELSE ''Payer Credit Distributions'' END ReferenceNumber,            
   VD.DepositDate as DepositDate,
   ARB.GLDate as GLDate,           
   LD.FinancialCenterUid,            
   ARB.ARBatchUID ARBatchUID,            
   --ISNULL(VDA.Receipt,0) as DepositAmount,   
   0 as DepositAmount, --         
   --COALESCE((VDA.Receipt - VDA.ReceiptBalance),0) as DepositAllocatedAmount, 
   0   as DepositAllocatedAmount,         
   --CASE WHEN LD2.PayerCreditUid  IS NULL THEN COALESCE(VDA.ReceiptBalance,0) ELSE 0 END AS UnappliedAmount,        
   0 AS UnappliedAmount,        
   --ISNULL(CONVERT(VARCHAR,D.Comment),'''') AS Comment,  
   ''''  AS Comment,   
   COALESCE(ICC.Name, ICC2.Name, VPC.ResponsiblePartyFullName,VPC.InsurancePayerFullName,dbo.UDF_getFormattedName(P.Prefix,P.FirstName,P.MiddleName,P.LastName,P.Suffix),'''') as PayerName,            
   dbo.UDF_getFormattedName(PER.Prefix,PER.FirstName,PER.MiddleName,PER.LastName,PER.Suffix) as PatientName,            
   SB.ExternalID,            
   SB.ServiceDateEnd,            
   LP.Code AS ShortDescription,            
   LD.RenderingProviderUid AS ProviderUid,
   LD.ClaimingProviderUid,            
   (CASE WHEN L.EntryType = 2 OR  L.EntryType = 3 THEN -1*LD.Amount ELSE 0 END) AS CreditAmount,            
   LCT.name as CreditTypeName,        
   CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed,
   LD2.PayerCreditUid
  FROM    
	AR_Ledger L            
  INNER JOIN            
	 AR_LedgerDetail LD            
  ON            
	 L.LedgerUid  =LD.LedgerUid AND LD.SuperbillProcedureUid IS NOT NULL AND (L.EntryType =2 OR L.EntryType =3)  
  INNER JOIN            
	 AR_LedgerDetail LD2            
  ON            
	 L.LedgerUid  =LD2.LedgerUid AND LD.LedgerDetailUid != LD2.LedgerDetailUid
  INNER JOIN
     AR_Transaction T
  ON
    T.TransactionUid=L.TransactionUid   	     
  LEFT JOIN   
    Deposit D
  ON  
    (D.DepositUid =T.DepositUid) --OR (T.DepositUid IS NULL AND PCD.DepositUid =D.DepositUid))   
  LEFT JOIN
	ViewDepositDate VD
  ON
    VD.DepositUid=T.DepositUid    
  --LEFT JOIN
  --  AR_ViewDepositAggregate VDA  
  --ON  
  --  VDA.DepositUid=T.DepositUid
  LEFT JOIN          
     AccountResponsibleParty ARP          
  ON          
	 LD2.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid           
 LEFT JOIN             
	 ListPaymentType LPT             
  on            
     LPT.PaymentTypeUid = D.PaymentTypeUid
 LEFT JOIN             
    Person P             
  on            
    P.PersonUid = ARP.PersonUid           
 LEFT JOIN             
    InsurancePlan  IP             
  on            
	Ip.InsurancePlanuid = LD2.InsurancePlanuid            
 LEFT JOIN             
	Corporation ICC             
  on            
    ICC.CorporationUId = IP.InsuranceCarrierUid   
 LEFT JOIN             
	Corporation ICC2             
  on            
    ICC2.CorporationUId = ARP.CorporationUid               
 LEFT JOIN             
	ListCreditType LCT             
  on            
	LCT.CreditTypeUid = LD.IncomeAccountUid              
 INNER JOIN            
	SuperbillProcedure SP            
 ON            
	LD.SuperbillProcedureUid =SP.SuperbillProcedureUid
 LEFT JOIN             
	Superbill SB             
  on       
	SB.SuperbillUid = SP.SuperbillUid   	       
 LEFT JOIN            
	ListProcedure LP            
 ON            
	SP.ProcedureUid =LP.ProcedureUid            
 LEFT JOIN             
	Person PER             
 on            
	PER.PersonUid = SB.PatientUid            
 LEFT JOIN        
    AR_ViewBatchClosingsLockedClosed VARB        
 ON        
    L.ArBatchUid =VARB.ARBatchUid   
 LEFT JOIN
    ARBatch ARB
 ON 
    ARB.ArBatchUid=L.ArBatchUid   
 LEFT JOIN
	ViewPayerCredit VPC
ON
	 LD2.PayerCreditUid =VPC.PayerCreditUid            
 
  
UNION ALL  

SELECT           -- Negation entry of payer credit distribution. 
   NULL AS DepositUid ,            
   (CASE WHEN L.EntryType =2 THEN ''Y'' WHEN L.EntryType  is null THEN ''Y'' ELSE ''N'' END) as IsPayment, -- This is lame. I can''t get reporting services to do filters based on bit columns though.            
   Null as Name,          
   ''Payer Credit Distributions''  ReferenceNumber,            
   NULL DepositDate,
   ARB.GLDate as GLDate,           
   VPC.FinancialCenterUid,            
   ISNULL(VPC.ARbatchuid,ARB.ARBatchUid) ARBatchUID,            
   0 as DepositAmount,           
   0 as DepositAllocatedAmount,            
   0 AS UnappliedAmount,        
   Null AS Comment,            
   COALESCE(VPC.ResponsiblePartyFullName,VPC.InsurancePayerFullName,'''') as PayerName,            
   '''' as PatientName,            
   '''' as ExternalID,            
   NuLL AS ServiceDateEnd,            
   ''-'' AS ShortDescription,            
   VPC.RenderingProvideruid AS ProviderUid,
   VPC.RenderingProvideruid as ClaimingProviderUid,            
   ISNULL(-1*LD.Amount,0) AS CreditAmount,            
   LCT.name as CreditTypeName,        
   VARB.IsClosed as IsBatchClosed ,
   LD.PayerCreditUid
  FROM
	 	AR_Ledger L
	JOIN
		AR_LedgerDetail LD 
	ON
		L.LedgerUid =LD.LedgerUid AND L.EntryType = 2 AND LD.PayerCreditUid IS NOT NULL AND LD.SuperbillProcedureUid IS NULL
	JOIN
	    ViewPayerCredit VPC
	ON
	    VPC.PayerCreditUid=LD.PayerCreditUid	
	JOIN 
		ARBatch ARB 
	ON 
		L.ARBatchUid = ARB.ARBatchUid
	JOIN
		AR_ViewBatchClosingsLockedClosed VARB
	ON
		ARB.ArBatchUid =VARB.ARBatchUid
	LEFT JOIN
		Account A
	ON
		LD.AccountUid=A.AccountUid
	--LEFT JOIN 
	--	ListAccountType LAT
	--ON
	--	A.AccountTypeUid = LAT.AccountTypeUid
	LEFT JOIN             
		ListCreditType LCT             
	on            
		LCT.CreditTypeUid = LD.IncomeAccountUid  

 UNION ALL --Payer Credit
 
 SELECT DISTINCT           
   D.DepositUId AS DepositUid,            
   ''Y'' as IsPayment,
   LPT.Name As Name,            
  ISNULL(D.ReferenceNumber, '''' )  AS ReferenceNumber,            
   VD.DepositDate AS DepositDate,
   VPC.GLDate,           
   VPC.FinancialCenterUid,            
   VPC.ARBatchUid AS ARBatchUID,            
   0 as DepositAmount,     
   0 as DepositAllocatedAmount,            
   0 AS UnappliedAmount,        
   CASE WHEN VPC.DepositUId = PC.DepositUid THEN ''Payer Credit'' ELSE ''Refund'' END AS Comment,            
   COALESCE(VPC2.ResponsiblePartyFullName,VPC2.InsurancePayerFullName,'''') as PayerName,            
   NULL as PatientName,        
   '''' AS ExternalID,            
   NULL AS ServiceDateEnd,            
   '''' AS ShortDescription,            
   VPC.ClaimingProviderUid AS ProviderUid,  
   VPC.ClaimingProviderUid AS ClaimingProviderUid,          
   ISNULL(-1 * VPC.Receipt,0) AS CreditAmount,            
   NULL as CreditTypeName,        
   VPC.IsBatchClosed AS IsBatchClosed,
   VPC.PayerCreditUid               
   FROM
	  MDOL_RPT2_ViewPayerCredit VPC
	LEFT JOIN
	  Deposit D
	ON
	  VPC.DepositUid=D.DepositUid
	LEFT JOIN
	  ViewDepositDate VD
	ON
	  VD.DepositUid=VPC.DepositUid
	LEFT JOIN
	  AR_ViewDepositAggregate VDA
	ON
	  VDA.DepositUid=VPC.DepositUid
	LEFT JOIN
	   ListPaymentType LPT             
	ON            
	   LPT.PaymentTypeUid = D.PaymentTypeUid  
	INNER JOIN
		AR_PayerCredit PC
	ON
		PC.PayerCreditUid = VPC.PayerCreditUid  
	 LEFT JOIN
		ViewPayerCredit VPC2
	ON
		 VPC.PayerCreditUid =VPC2.PayerCreditUid    
	 	   
UNION ALL --Refund
 
 SELECT            
   D.DepositUId AS DepositUid,            
   ''Y'' as IsPayment,
   LPT.Name As Name,            
  ISNULL(D.ReferenceNumber, '''' ) AS ReferenceNumber,            
   VD.DepositDate AS DepositDate,
   VRF.GLDate,           
   VRF.FinancialCenterUid,            
   VRF.ARBatchUid AS ARBatchUID,            
   0 as DepositAmount,     
   0 as DepositAllocatedAmount,            
   0 AS UnappliedAmount,        
   ''Refund'' AS Comment,            
   Null AS PayerName,            
   NULL as PatientName,        
   '''' AS ExternalID,            
   NULL AS ServiceDateEnd,            
   '''' AS ShortDescription,            
   VRF.ClaimingProviderUid AS ProviderUid,  
   VRF.ClaimingProviderUid AS ClaimingProviderUid,          
   ISNULL(-1 * VRF.Receipt,0) AS CreditAmount,            
   NULL as CreditTypeName,        
   VRF.IsBatchClosed AS IsBatchClosed ,
   VRF.PayerCreditUid              
   FROM
	  MDOL_RPT2_ViewRefund VRF
	LEFT JOIN
	  Deposit D
	ON
	  VRF.DepositUid=D.DepositUid
	LEFT JOIN
	  ViewDepositDate VD
	ON
	  VD.DepositUid=VRF.DepositUid
	LEFT JOIN
	  AR_ViewDepositAggregate VDA
	ON
	  VDA.DepositUid=VRF.DepositUid
	LEFT JOIN
	   ListPaymentType LPT             
	ON            
	   LPT.PaymentTypeUid = D.PaymentTypeUid 
    

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewVisits]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewVisits] AS
	SELECT	v.VisitUid, v.VisitDate, v.IsCompleted, v.CompletedDate,
			v.ClinicalNoteTypeUid, cnt.Name AS ClinicalNoteType,
			v.PatientUid, dbo.UDF_getFormattedName(per.Prefix, per.FirstName, per.MiddleName, per.LastName, per.Suffix) AS Patient,
			pat.ExternalID,
			v.ServiceSiteUid, ss.Name AS ServiceSite,
			v.RenderingProviderUid, dbo.UDF_getFormattedName(rprov.Prefix, rprov.FirstName, rprov.MiddleName, rprov.LastName, rprov.Suffix) AS RenderingProvider,
			v.ProviderUid, dbo.UDF_getFormattedName(prov.Prefix, prov.FirstName, prov.MiddleName, prov.LastName, prov.Suffix) AS Provider,
			v.SupervisingProviderUid, dbo.UDF_getFormattedName(sprov.Prefix, sprov.FirstName, sprov.MiddleName, sprov.LastName, sprov.Suffix) AS SupervisingProvider,
			pat.ProviderUid AS PrimaryProviderUid, dbo.UDF_getFormattedName(pprov.Prefix, pprov.FirstName, pprov.MiddleName, pprov.LastName, pprov.Suffix) AS PrimaryProvider,
			v.FinancialCenterUid, fc.Name as FinancialCenter
	FROM	Visit v INNER JOIN Patient pat ON v.PatientUid = pat.PersonUid
			INNER JOIN Person per ON v.PatientUid = per.PersonUid
			INNER JOIN ListServiceSite ss ON v.ServiceSiteUid = ss.ServiceSiteUid
			INNER JOIN FinancialCenter fc ON v.FinancialCenterUid = fc.FinancialCenterUid
			INNER JOIN ViewFindProvider rprov ON v.RenderingProviderUid = rprov.PersonUid
			INNER JOIN ViewFindProvider prov ON v.ProviderUid = prov.PersonUid
			LEFT JOIN ViewFindProvider sprov ON v.SupervisingProviderUid = sprov.PersonUid
			LEFT JOIN ViewFindProvider pprov ON pat.ProviderUid = pprov.PersonUid
			INNER JOIN ListClinicalNoteType cnt ON v.ClinicalNoteTypeUid = cnt.ClinicalNoteTypeUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_StatementLineItemByFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[MDOL_RPT2_View_StatementLineItemByFinancialCenter]
AS
/*	Source for the line items in the paper and electronic statement.
	As of GA5, the paper statement does not use the Header, Comment, and Subtotal types.
	gaps have been left in the display order for adding comment lines at any point. 
	Comments to be mixed in with a certain type should have the same display order,
	e.g., claim filing comments are mixed with payments.

	The primary keys of the biz object view for this are ItemUid, SuperbillUid,  
	DisplayOrder, and CreditSubOrder so make sure this set of four is unique if you 
	update this view.

	Use CreditSubOrder to order items associated with an individual payment or adjustment
	credit. Make it less than 2 to precede the payment or adjustment or greater than 2
	to follow it. E.g., a credit statement note follows the credit.

	The intended ordering for these line items is:
	ORDER BY	RPUid, SuperbillDate asc, SuperbillUid, DisplayOrder asc, ItemDate asc, 
		CreditGroupUid, IsPayment desc, CreditUid, CreditSubOrder asc 
*/
/*
	01/24/2008 - Qatalys - Modified to remove GLDate (#13093)
	05/19/2008 - Qatalys - Modified to include Financial Center
	07/11/2011 - KBernecker - Added "Header" section back
	11/15/2011 - kbernecker - remove payment notes (entire "Transfer" section), fixed reference numbers	
	1/20/2012 - kbernecker - split out for paper statements by FC
	06/23/2014 - kbernecker - performance improvements
	20150109 - kculberth - add statement notes from reason codes - bug 33625
	20161020 - kculberth - fixed bug 44841 (last filed to payer was incorrect in certain circumstances) also
						   get rid of unnecessary "Comments" by changing the section with type of Comment, using CB.ClaimBatchUid as ItemUid...changed ClaimBatch left join to inner join
*/
WITH cteWhoPaidName --Stolen from ViewDeposit
AS
	-- Define the CTE query.
	(
	SELECT d.deposituid
		,ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumber
		,-- mark as <ND> so can hyperlink on null values
		(
			CASE 
				WHEN p.PersonUid IS NOT NULL
					THEN p1.FormattedPreferredName
				WHEN icArp.CorporationUid IS NOT NULL
					THEN icArp.NAME
				WHEN LD.InsurancePayerUid IS NOT NULL
					THEN ic.NAME
				END
			) AS WhoPaidName
		,L.EntryType
	FROM Deposit d
	INNER JOIN AR_LedgerDetail LD WITH (NOLOCK)
		ON d.DepositUid = LD.DepositUid
	INNER JOIN AR_Ledger L WITH (NOLOCK)
		ON LD.LedgerUid = L.LedgerUid
	LEFT JOIN AR_Ledger arlVoid WITH (NOLOCK)
		ON L.LedgerUid = arlVoid.VoidLedgerUid -- Checks for voiding entries                                       
	LEFT JOIN AccountResponsibleParty arp WITH (NOLOCK)
		ON LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
	LEFT JOIN Person p WITH (NOLOCK)
		ON arp.PersonUid = p.PersonUid
	LEFT JOIN Corporation icArp WITH (NOLOCK)
		ON arp.CorporationUid = icArp.CorporationUid
	LEFT JOIN Corporation ic WITH (NOLOCK)
		ON ic.CorporationUid = LD.InsurancePayerUid
	LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK)
		ON p1.personuid = p.PersonUid
	WHERE (	
			L.EntryType = 0 -- Payment
			OR L.EntryType = 3
			) -- Adjustment
		AND (
			L.VoidLedgerUid IS NULL
			AND arlVoid.LedgerUid IS NULL
			) -- Don''t include reversing(void) entries
		AND LD.IsCredit = 1
		AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits    
	)
	,cteLastFiledDate --
AS
	-- Define the CTE query.
	(
	SELECT SA.SuperbillUid
		,SA.LastFiledDate
		,SA.CurrentInsurancePlanUid
	FROM SuperbillAggregate SA WITH (NOLOCK)
	)
SELECT FinancialCenterUid
	,ItemUid
	,RPUid
	,''Charge'' AS Type
	,4 AS DisplayOrder
	,PatientName
	,RenderingProviderName
	,AccountID
	,SuperbillID
	,SuperbillUid
	,SuperbillDate
	,ItemDate
	,NULL AS CreditGroupUid
	,0 AS IsPayment
	,NULL AS CreditUid
	,0 AS CreditSubOrder
	,'''' AS WhoPaid
	,Description
	,Charge
	,Sum(Insurance) AS Insurance
	,Sum(Patient) AS Patient
	,Sum(Amount) AS Amount
	,SuperbillProcedureUid
	,MAX(TotalCharge) TotalCharge
	,MAX(LastFiledDate) LastFiledDate
	,'''' AS ReferenceNumber
	,ReferringProviderName
	,InsuranacePlan
	,MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch
	,1 CompleteBatch
	,0 AS DisplayOrder2
FROM (
	SELECT LD.FinancialCenterUid
		,SP.SuperbillProcedureUid AS ItemUid
		,A.AccountResponsiblePartyUid AS RPUid
		,
		--''Charge'' as Type, 
		--4 as DisplayOrder, 
		p1.FormattedPreferredName AS PatientName
		,p2.FormattedPreferredName AS RenderingProviderName
		,A.ExternalID AS AccountID
		,S.ExternalID AS SuperbillID
		,S.SuperbillUid
		,S.ServiceDateStart AS SuperbillDate
		,SP.ProcedureServiceDateStart AS ItemDate
		,(
			CASE 
				WHEN (FC.IncludeProcedureCode = 1)
					THEN ISNULL(LP.Code, '''') + ISNULL('' '' + LP.ShortDescription, '''')
				ELSE ISNULL('' '' + LP.ShortDescription, '''')
				END
			) AS Description
		,Coalesce(SP.TotalCharge, convert(MONEY, SP.ProcedureCharge * SP.Units), 0) AS Charge
		,(
			CASE 
				WHEN LD.LiabilityOwner > 0
					THEN LD.Amount
				ELSE Convert(MONEY, 0)
				END
			) AS Insurance
		,(
			CASE 
				WHEN LD.LiabilityOwner = 0
					THEN LD.Amount
				ELSE Convert(MONEY, 0)
				END
			) AS Patient
		,(ISNULL(LD.Amount, 0)) AS Amount
		,SP.SuperbillProcedureUid
		,Coalesce(SP.TotalCharge, convert(money,SP.ProcedureCharge * SP.Units), 0) AS TotalCharge
		,lfd.LastFiledDate AS LastFiledDate
		,p3.FormattedPreferredName AS ReferringProviderName
		, (SELECT top 1 IP.Name from ClaimBatchDetail (NOLOCK) CBD   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL
		LEFT JOIN InsurancePlan (NOLOCK) IP ON CBD.InsurancePlanUid = IP.InsurancePlanUid   
		where CBD.SuperbillUid = S.SuperbillUid order by cbd.lastmodifieddate desc) as InsuranacePlan
		,CASE 
			WHEN (
					ARB.IsClosed = 1
					OR ARB.IsLocked = 1
					)
				THEN 1
			ELSE 0
			END IsSuperBilCompleteBatch
		,(
			CASE 
				WHEN fc.IncludeCompletedOrClosed = 1
					THEN 1
				ELSE 0
				END
			) AS IncludeCompletedOrClosed
		,CASE 
			WHEN (
					ARB.IsClosed = 1
					OR ARB.IsLocked = 1
					)
				THEN 1
			ELSE 0
			END CompleteBatch
	FROM AR_LedgerDetail LD WITH (NOLOCK)
	INNER JOIN AR_Ledger L WITH (NOLOCK)
		ON LD.LedgerUid = L.LedgerUid
			AND (
				L.EntryType = 1
				OR L.EntryType = 4
				)
	LEFT JOIN AR_Ledger LVOID WITH (NOLOCK)
		ON L.LedgerUid = LVOID.VoidLedgerUid
	INNER JOIN ARBatch ARB WITH (NOLOCK)
		ON L.ArBatchUid = ARB.ARBatchUid
	INNER JOIN SuperbillProcedure SP WITH (NOLOCK)
		ON LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill S WITH (NOLOCK)
		ON S.SuperbillUid = SP.SuperbillUid
	INNER JOIN Account A WITH (NOLOCK)
		ON S.AccountUid = A.AccountUid
	INNER JOIN ListProcedure LP WITH (NOLOCK)
		ON SP.ProcedureUid = LP.ProcedureUid
	INNER JOIN cteLastFiledDate lfd WITH (NOLOCK)
		ON lfd.SuperbillUid = S.SuperbillUid
	--LEFT JOIN InsurancePlan IP WITH (NOLOCK)
	--	ON lfd.CurrentInsurancePlanUid = IP.InsurancePlanUid
	INNER JOIN FinancialCenter FC WITH (NOLOCK)
		ON LD.FinancialCenterUid = FC.FinancialCenterUid
	LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK)
		ON p1.personuid = S.PatientUid
	LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK)
		ON p2.personuid = LD.RenderingProviderUid
	LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK)
		ON p3.personuid = s.ReferringProviderUid
	LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus rpsss WITH (NOLOCK)
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
	WHERE 
		rpsss.superbillstatusuid is null AND
			(
			L.EntryType = 1
			OR L.EntryType = 4
			)
		AND (
			L.VoidLedgeruid IS NULL
			AND LVOID.LedgerUid IS NULL
			)
	) A
WHERE A.IncludeCompletedOrClosed = 0
	OR CompleteBatch = 1
GROUP BY FinancialCenterUid
	,ItemUid
	,RPUid
	,PatientName
	,RenderingProviderName
	,AccountID
	,SuperbillID
	,SuperbillUid
	,SuperbillDate
	,ItemDate
	,Description
	,Charge
	,SuperbillProcedureUid
	,ReferringProviderName
	,InsuranacePlan

UNION ALL

SELECT FinancialCenterUid
	,ItemUid
	,RPUid
	,Type
	,CASE 
		WHEN Type = ''Payment''
			THEN 5
		ELSE 6
		END AS DisplayOrder
	,PatientName
	,RenderingProviderName
	,AccountID
	,SuperbillID
	,SuperbillUid
	,SuperbillDate
	,ItemDate
	,CreditGroupUid
	,IsPayment
	,CreditUid
	,2 AS CreditSubOrder
	,WhoPaid
	,Description
	,Convert(MONEY, 0) AS Charge
	,SUM(Insurance) AS Insurance
	,SUM(Patient) AS Patient
	,SUM(Amount) AS Amount
	,NULL AS SuperbillProcedureUid
	,MAX(TotalCharge) AS TotalCharge
	,MAX(LastFiledDate) AS LastFiledDate
	,ReferenceNumber
	,ReferringProviderName
	,InsuranacePlan
	,MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch
	,1 CompleteBatch
	,DisplayOrder2
FROM (
	SELECT LD.FinancialCenterUid
		,(
			CASE 
				WHEN LCT.NAME = ''Patient Payment''
					THEN D.DepositUid
				ELSE LD.FinancialCenterUid
				END
			) AS ItemUid
		,
		--LD.FinancialCenterUid ItemUid,
		A.AccountResponsiblePartyUid AS RPUid
		,(
			CASE 
				WHEN L.EntryType = 2
					THEN ''Payment''
				ELSE ''Adjustment''
				END
			) AS Type
		,
		--6 as DisplayOrder, 
		p1.FormattedPreferredName AS PatientName
		,p2.FormattedPreferredName AS RenderingProviderName
		,A.ExternalID AS AccountID
		,S.ExternalID AS SuperbillID
		,S.SuperbillUid
		,S.ServiceDateStart AS SuperbillDate
		,(ARb.GLDate) AS ItemDate
		,LD.FinancialCenterUid CreditGroupUid
		,(
			CASE 
				WHEN L.EntryType = 2
					THEN 1
				ELSE 0
				END
			) IsPayment
		,LD.FinancialCenterUid CreditUid
		,
		--2 as CreditSubOrder, 
		WhoPaid.WhoPaidName AS WhoPaid
		,(
			CASE 
				WHEN L.EntryType != 2
					THEN ISNULL(LCT.NAME, '''')
				ELSE (
						CASE 
							WHEN FC.IncludePaymentReferenceNumber = 1
								THEN ISNULL(LCT.NAME, '''') + '' Ref #'' + ISNULL(WhoPaid.ReferenceNumber, ''N/A'') + '' '' + ISNULL(WhoPaid.WhoPaidName, '''')
							ELSE ISNULL(LCT.NAME, '''') + '' '' + ISNULL(WhoPaid.WhoPaidName, '''')
							END
						)
				END
			) AS Description
		,
		--Convert(Money, 0) as Charge, 
		(
			CASE 
				WHEN LD.LiabilityOwner > 0
					THEN (LD.Amount)
				ELSE Convert(MONEY, 0)
				END
			) AS Insurance
		,(
			CASE 
				WHEN LD.LiabilityOwner = 0
					THEN (LD.Amount)
				ELSE Convert(MONEY, 0)
				END
			) AS Patient
		,(ISNULL(LD.Amount, 0)) AS Amount
		,LD.SuperbillProcedureUid
		,(SP.TotalCharge) AS TotalCharge
		,lfd.LastFiledDate AS LastFiledDate
		,D.ReferenceNumber
		,p3.FormattedPreferredName AS ReferringProviderName
		,IP.NAME InsuranacePlan
		,0 IsSuperBilCompleteBatch
		,(
			CASE 
				WHEN fc.IncludeCompletedOrClosed = 1
					THEN 1
				ELSE 0
				END
			) AS IncludeCompletedOrClosed
		,CASE 
			WHEN (
					ARB.IsClosed = 1
					OR ARB.IsLocked = 1
					)
				THEN 1
			ELSE 0
			END CompleteBatch
		,CASE 
			WHEN LCT.IsPayment = 1
				THEN 1
			WHEN LCT.IsAdjustment = 1
				THEN 2
			ELSE 3
			END AS DisplayOrder2
	FROM AR_LedgerDetail LD WITH (NOLOCK)
	INNER JOIN AR_Ledger L WITH (NOLOCK)
		ON LD.LedgerUid = L.LedgerUid
	LEFT JOIN AR_Ledger LVOID WITH (NOLOCK)
		ON L.LedgerUid = LVOID.VoidLedgerUid
	INNER JOIN ARBatch ARB WITH (NOLOCK)
		ON L.ArBatchUid = ARB.ARBatchUid
	INNER JOIN SuperbillProcedure SP WITH (NOLOCK)
		ON LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill S WITH (NOLOCK)
		ON S.SuperbillUid = SP.SuperbillUid
	INNER JOIN Account A WITH (NOLOCK)
		ON S.AccountUid = A.AccountUid
	INNER JOIN AR_LedgerDetail LDOS WITH (NOLOCK)
		ON LD.LedgerUid = LDOS.LedgerUid
			AND LD.LedgerDetailUid != LDOS.LedgerDetailUid
	--LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = LDOS.DepositUid
	LEFT JOIN AR_Transaction T WITH (NOLOCK)
		ON L.TransactionUid = T.TransactionUid
	LEFT JOIN Deposit d WITH (NOLOCK)
		ON D.DepositUid = T.DepositUid
	LEFT JOIN ListCreditType LCT WITH (NOLOCK)
		ON LD.IncomeAccountUid = LCT.CreditTypeUid
	LEFT JOIN cteLastFiledDate lfd WITH (NOLOCK)
		ON lfd.SuperbillUid = S.SuperbillUid
	LEFT JOIN InsurancePlan IP WITH (NOLOCK)
		ON lfd.CurrentInsurancePlanUid = IP.InsurancePlanUid
	INNER JOIN FinancialCenter FC WITH (NOLOCK)
		ON LD.FinancialCenterUid = FC.FinancialCenterUid
	LEFT JOIN cteWhoPaidName AS whoPaid WITH (NOLOCK)
		ON d.depositUid = WhoPaid.deposituid
	LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK)
		ON p1.personuid = S.PatientUid
	LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK)
		ON p2.personuid = LD.RenderingProviderUid
	LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK)
		ON p3.personuid = s.ReferringProviderUid
	LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus rpsss WITH (NOLOCK)
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
	WHERE 
		rpsss.superbillstatusuid is null AND
		 (
			L.EntryType = 2
			OR L.EntryType = 3
			)
		AND (
			L.VoidLedgeruid IS NULL
			AND LVOID.LedgerUid IS NULL
			)
		AND LD.IsCredit = 1
	) B
WHERE B.IncludeCompletedOrClosed = 0
	OR B.CompleteBatch = 1
GROUP BY FinancialCenterUid
	,ItemUid
	,RPUid
	,Type
	,PatientName
	,RenderingProviderName
	,AccountID
	,SuperbillID
	,SuperbillUid
	,SuperbillDate
	,ItemDate
	,CreditGroupUid
	,IsPayment
	,CreditUid
	,WhoPaid
	,Description
	,
	--SuperbillProcedureUid,
	ReferenceNumber
	,ReferringProviderName
	,InsuranacePlan
	,DisplayOrder2

UNION ALL

--Claim filing comment can be mixed among the payments, so use the same display order
SELECT LD.FinancialCenterUid
	,CB.ClaimBatchUid AS ItemUid
	,A.AccountResponsiblePartyUid AS RPUid
	,''Comment'' AS Type
	,6 AS DisplayOrder
	,
	--'''' as PatientName, 
	--'''' as RenderingProviderName, 
	p1.FormattedPreferredName AS PatientName
	,p2.FormattedPreferredName AS RenderingProviderName
	,A.ExternalID AS AccountID
	,S.ExternalID AS SuperbillID
	,S.SuperbillUid
	,S.ServiceDateStart AS SuperbillDate
	,max(CB.ClaimDate) AS ItemDate
	,NULL AS CreditGroupUid
	,0 AS IsPayment
	,NULL AS CreditUid
	,0 AS CreditSubOrder
	,'''' AS WhoPaid
	,coalesce(dbo.ARFN_getInsLevelName(CB.InsuranceOrder), '''') + '' claim filed to '' + C.NAME AS Description
	,Convert(MONEY, 0) AS Charge
	,Convert(MONEY, 0) AS Insurance
	,Convert(MONEY, 0) AS Patient
	,Convert(MONEY, 0) AS Amount
	,NULL SuperbillProcedureUid
	,--CR,
	MAX(SP.TotalCharge) TotalCharge
	,MAX(lfd.LastFiledDate) LastFiledDate
	,'''' AS ReferenceNumber
	,p3.FormattedPreferredName AS ReferringProviderName
	,(dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan
	,0 IsSuperBilCompleteBatch
	,1 CompleteBatch
	,0 AS DisplayOrder2
FROM AR_LedgerDetail LD WITH (NOLOCK)
INNER JOIN AR_Ledger L WITH (NOLOCK)
	ON LD.LedgerUid = L.LedgerUid
LEFT JOIN AR_Ledger LVOID WITH (NOLOCK)
	ON L.LedgerUid = LVOID.VoidLedgerUid
INNER JOIN ARBatch ARB WITH (NOLOCK)
	ON L.ArBatchUid = ARB.ARBatchUid
INNER JOIN SuperbillProcedure SP WITH (NOLOCK)
	ON LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
INNER JOIN Superbill S WITH (NOLOCK)
	ON S.SuperbillUid = SP.SuperbillUid
INNER JOIN Account A WITH (NOLOCK)
	ON S.AccountUid = A.AccountUid
LEFT JOIN ClaimBatchDetail CBD WITH (NOLOCK)
	ON CBD.SuperbillUid = S.SuperbillUid
LEFT JOIN cteLastFiledDate lfd WITH (NOLOCK)
	ON lfd.SuperbillUid = S.SuperbillUid
LEFT JOIN InsurancePlan IP WITH (NOLOCK)
	ON LD.InsurancePlanUid = IP.InsurancePlanUid
LEFT JOIN Corporation C WITH (NOLOCK)
	ON IP.InsuranceCarrierUid = C.CorporationUid
INNER JOIN ClaimBatch CB WITH (NOLOCK)
	ON CB.ClaimBatchUid = CBD.ClaimBatchUid
		AND CB.ClaimDate IS NOT NULL
		AND CB.ClaimDate > ARB.GLDate
		AND CBD.InsurancePlanUid = IP.InsurancePlanUid
--LEFT JOIN InsurancePlan IP1 WITH (NOLOCK)
--	ON lfd.CurrentInsurancePlanUid = IP1.InsurancePlanUid
INNER JOIN FinancialCenter FC WITH (NOLOCK)
	ON LD.FinancialCenterUid = FC.FinancialCenterUid
LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK)
	ON p1.personuid = S.PatientUid
LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK)
	ON p2.personuid = LD.RenderingProviderUid
LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK)
	ON p3.personuid = s.ReferringProviderUid
LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus rpsss WITH (NOLOCK)
ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
WHERE 
	rpsss.superbillstatusuid is null 
	AND (
		L.VoidLedgeruid IS NULL
		AND LVOID.LedgerUid IS NULL
		)
GROUP BY LD.FinancialCenterUid
	,CB.ClaimBatchUid
	,A.AccountResponsiblePartyUid
	,S.PatientUid
	,LD.RenderingProviderUid
	,A.ExternalID
	,S.ExternalID
	,S.SuperbillUid
	,S.ServiceDateStart
	,CB.ClaimDate
	,CB.InsuranceOrder
	,C.NAME
	,S.ReferringProviderUid
	,P1.FormattedPreferredName
	,p2.FormattedPreferredName
	,p3.FormattedPreferredName

UNION ALL

--Statement notes from credits. Associated with the payments and adjustments, so use the same display order
-- but vary SubDisplayOrder in order to make the comment show after the payment or adjustment it goes with
SELECT LD.FinancialCenterUid
	,LD.LedgerDetailUid AS ItemUid
	,A.AccountResponsiblePartyUid AS RPUid
	,''Comment'' AS Type
	,CASE 
		WHEN L.EntryType = 1
			THEN 4
		WHEN L.EntryType = 2
			THEN 5
		WHEN L.EntryType = 3
			THEN 6
		WHEN L.EntryType = 4
			THEN 7
		ELSE 6
		END AS DisplayOrder
	,p1.FormattedPreferredName AS PatientName
	,p2.FormattedPreferredName AS RenderingProviderName
	,A.ExternalID AS AccountID
	,S.ExternalID AS SuperbillID
	,S.SuperbillUid
	,S.ServiceDateStart AS SuperbillDate
	,D.DepositDate AS ItemDate
	,LD.LedgerDetailUid AS CreditGroupUid
	,(
		CASE 
			WHEN L.EntryType = 2
				THEN 1
			ELSE 0
			END
		) IsPayment
	,LD.LedgerDetailUid AS CreditUid
	,4 AS CreditSubOrder
	,'''' AS WhoPaid
	,L.StatementNote AS Description
	,Convert(MONEY, 0) AS Charge
	,Convert(MONEY, 0) AS Insurance
	,Convert(MONEY, 0) AS Patient
	,Convert(MONEY, 0) AS Amount
	,LD.SuperbillProcedureUid
	,SP.TotalCharge
	,lfd.LastFiledDate
	,'''' AS ReferenceNumber
	,p3.FormattedPreferredName AS ReferringProviderName
	,(dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan
	,0 IsSuperBilCompleteBatch
	,CASE 
		WHEN ARB.IsClosed = 1
			OR ARB.IsLocked = 1
			THEN 1
		ELSE 0
		END CompleteBatch
	,0 AS DisplayOrder2
FROM AR_LedgerDetail LD WITH (NOLOCK)
INNER JOIN AR_Ledger L WITH (NOLOCK)
	ON LD.LedgerUid = L.LedgerUid
LEFT JOIN AR_Ledger LVOID WITH (NOLOCK)
	ON L.LedgerUid = LVOID.VoidLedgerUid
INNER JOIN ARBatch ARB WITH (NOLOCK)
	ON L.ArBatchUid = ARB.ARBatchUid
INNER JOIN SuperbillProcedure SP WITH (NOLOCK)
	ON LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
INNER JOIN Superbill S WITH (NOLOCK)
	ON S.SuperbillUid = SP.SuperbillUid
INNER JOIN Account A WITH (NOLOCK)
	ON S.AccountUid = A.AccountUid
INNER JOIN AR_LedgerDetail LDOS WITH (NOLOCK)
	ON LD.LedgerUid = LDOS.LedgerUid
		AND LD.LedgerDetailUid != LDOS.LedgerDetailUid
LEFT JOIN Deposit d WITH (NOLOCK)
	ON D.DepositUid = LDOS.DepositUid
LEFT JOIN cteWhoPaidName AS whoPaid WITH (NOLOCK)
	ON d.depositUid = WhoPaid.deposituid --and d.referencenumber = WhoPaid.referencenumber	
LEFT JOIN AR_Transaction T WITH (NOLOCK)
	ON L.TransactionUid = T.TransactionUid
LEFT JOIN ViewDeposit D2 WITH (NOLOCK)
	ON D2.DepositUid = T.DepositUid
LEFT JOIN cteLastFiledDate lfd WITH (NOLOCK)
	ON lfd.SuperbillUid = S.SuperbillUid
LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  
LEFT JOIN Corporation (NOLOCK) C ON IP.InsuranceCarrierUid = C.CorporationUid   
LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
				AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
INNER JOIN FinancialCenter FC WITH (NOLOCK)
	ON LD.FinancialCenterUid = FC.FinancialCenterUid
LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK)
	ON p1.personuid = S.PatientUid
LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK)
	ON p2.personuid = LD.RenderingProviderUid
LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK)
	ON p3.personuid = s.ReferringProviderUid
LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus rpsss WITH (NOLOCK)
ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid and ld.FinancialCenterUid = rpsss.FinancialCenterUid
WHERE 
	rpsss.superbillstatusuid is null AND
	 (
		L.StatementNote IS NOT NULL
		OR L.StatementNote != ''''
		)
	AND (
		L.VoidLedgeruid IS NULL
		AND LVOID.LedgerUid IS NULL
		)
	AND (
		L.EntryType = 2
		OR L.EntryType = 3
		OR L.EntryType = 4
		)
	AND LD.IsCredit = 1
	Union All
--Remark notes from Reason Codes. Associated with procedures, so use the same display Order  
select FinancialCenterUid
	,ItemUid
	,RPUid
	,Type
	,DisplayOrder
	,PatientName
	,RenderingProviderName
	,AccountID
	,SuperbillID
	,SuperbillUid
	,SuperbillDate
	,ItemDate
	,NULL AS CreditGroupUid
	,0 AS IsPayment
	,NULL AS CreditUid
	,CreditSubOrder
	,'''' AS WhoPaid
	,Description
	,Charge
	,Insurance
	,Patient
	,Amount
	,SuperbillProcedureUid
	,TotalCharge
	,LastFiledDate
	,'''' AS ReferenceNumber
	,ReferringProviderName
	,InsuranacePlan
	,IsSuperBilCompleteBatch
	,1 CompleteBatch
	,0 AS DisplayOrder2
from (
	SELECT distinct  
	LD.FinancialCenterUid,  
	--LD.LedgerDetailUid AS ItemUid,   
	NULL as ItemUid,
	A.AccountResponsiblePartyUid AS RPUid,   
	''Comment'' AS Type,   
	6 AS DisplayOrder,   
	p1.FormattedPreferredName AS PatientName,   
	NULL AS RenderingProviderName,   
	A.ExternalID AS AccountID,   
	S.ExternalID AS SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart AS SuperbillDate,   
	SP.ProcedureServiceDateStart AS ItemDate,      
	--LD.LedgerDetailUid AS CreditGroupUid,  
	--(CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
	--LD.LedgerDetailUid AS CreditUid,  
	NULL AS CreditGroupUid,  
	NULL AS IsPayment,   
	NULL AS CreditUid,  
	4 AS CreditSubOrder,   
	'''' AS WhoPaid,   
	adj.StatementNote AS Description,   
	CONVERT(Money, 0) AS Charge,   
	CONVERT(Money, 0) AS Insurance,   
	CONVERT(Money, 0) AS Patient,  
	CONVERT(Money, 0) AS Amount,  
	0 AS Age,  
	--LD.SuperbillProcedureUid,  
	--SP.TotalCharge AS TotalCharge,  
	NULL AS SuperbillProcedureUid,  
	CASE WHEN SP.TotalCharge > 0 THEN 99999 ELSE 0 END AS TotalCharge,  
	 NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	NULL AS ReferringProviderName,
	NULL AS  InsuranacePlan,
	NULL AS IsSuperBilCompleteBatch,  
	NULL AS CompleteBatch,
	  3  AS DisplayOrder2
	FROM Superbill S WITH (NOLOCK) 
		INNER JOIN SuperbillProcedure SP WITH (NOLOCK) ON SP.superbilluid = S.superbilluid
		INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SP.SuperbillProcedureUid = LD.SuperbillProcedureUid
		INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid   
		LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = S.PatientUid  
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		left join cobclaimdetail cob WITH (NOLOCK) on cob.superbilluid = s.superbilluid
		left join COBLineAdjustments adj WITH (NOLOCK) on adj.cobclaimdetailuid = cob.cobclaimdetailuid and adj.superbillprocedureuid = sp.superbillprocedureuid and adj.Notes IS NOT NULL
		CROSS JOIN PracticeSettings PS WITH (NOLOCK) 
	WHERE rpsss.superbillstatusuid is null and
	 (adj.StatementNote is NOT NULL OR adj.StatementNote != '''')  
 ) A

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewVisitsCosign]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewVisitsCosign] AS
	SELECT	v.*,			
			vcs.VisitCoSignUid,
			vcs.CosignUid, dbo.UDF_getFormattedName(cosign.Prefix, cosign.FirstName, cosign.MiddleName, cosign.LastName, cosign.Suffix) AS Cosigner,
			vcs.IsApproved, vcs.CosignSignatureUid, CAST(CASE WHEN vcs.CosignSignatureUid IS NULL THEN 0 ELSE 1 END AS BIT) AS IsCosigned
	FROM	ViewVisits v LEFT JOIN VisitCoSign vcs ON v.VisitUid = vcs.VisitUid
			LEFT JOIN Person cosign ON vcs.CosignUid = cosign.PersonUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewVisitSOSPDGCodes_WithResult]'))
EXEC dbo.sp_executesql @statement = N'
/*
Pancratius:01/07/2014 Modified to Join on diagnosis codes and not diagnosis Uid
select*from [MDOL_RPT2_ViewVisitSOSPDGCodes_WithResult]where visitDate>''09/04/2014'' and visitdate<=''09/30/2014''

--20150611 kculberth updated for ICD10
--20150918 cmcfadden updated for new PatientProblemDiagnosisHistory table
--20170919 cmcfadden update changed RecordDateTime to Sequence
*/


CREATE VIEW [dbo].[MDOL_RPT2_ViewVisitSOSPDGCodes_WithResult]
AS
SELECT   
	 A.VisitUid
	,A.PatientUid  
	,A.VisitDate  
	,A.Code  
	,A.Diagnosiscode9  
	,A.Code9
	,A.Code10
	,A.SOProcedureUid  
	,A.SPProcedureUid  
	,A.ResultStatusUid 
	,A.ResultStatus
	,A.NumericObservationValue
	,A.SystolicBP
	,A.DiastolicBP  
		
FROM  
(  
	SELECT    
		 V.VisitUid 
		,V.PatientUid 
		,V.VisitDate
		,LP.Code
		,'''' AS Diagnosiscode9 
		,'''' AS Code9
		,'''' AS Code10
		,LP.ProcedureUid AS SOProcedureUid
		,NULL AS SPProcedureUid
		,RS.UserDefinedDataUID AS ResultStatusUid
		,RS.Name AS ResultStatus
		--,(CASE WHEN ISNUMERIC(CONVERT(VARCHAR(MAX),ObservationValue))=1 AND CONVERT(VARCHAR(MAX),ObservationValue)!=''.'' 
		,(CASE WHEN ISNUMERIC(CONVERT(VARCHAR(MAX),ObservationValue))=1 AND CONVERT(VARCHAR(MAX),ObservationValue)!=''.'' AND CONVERT(VARCHAR(MAX),ObservationValue)!=''-''  AND CONVERT(VARCHAR(MAX),ObservationValue)!=''+'' 
			   THEN CONVERT(NUMERIC(10,2),CONVERT(VARCHAR(MAX),ObservationValue)) ELSE -1 END) AS NumericObservationValue
		,dbo.[getPatientSystolic_Adult_Diabetes](V.VisitUid) AS SystolicBP
		,dbo.[getPatientDiastolic_Adult_Diabetes](V.VisitUid) AS DiastolicBP  
 	FROM Visit (NOLOCK) V  
	INNER JOIN VisitProcedure (NOLOCK) VP ON V.VisitUid=VP.VisitUid AND VP.IsDelete = 0  
	LEFT JOIN ObservationOrder (NOLOCK) OO ON OO.VisitProcedureUid = VP.VisitProcedureUid AND OO.IsDelete = 0 
	LEFT JOIN MDOL_RPT2_VIEW_ResultStatus (NOLOCK) RS ON RS.ExternalID = OO.ResultStatusID  
	INNER JOIN ListProcedure (NOLOCK) LP ON VP.ProcedureUid =LP.ProcedureUid  
	LEFT JOIN ObservationValue (NOLOCK) OV ON OO.ObservationOrderUid = OV.ObservationOrderUid 
  
	UNION ALL  
	 
	SELECT    
		 VVD.VisitUid 
		,VVD.PatientUid 
		,VVD.VisitDate
		,''''
		,VVD.DiagnosisCode as DiagnosisCode9
		,VVD.Code as Code9
		,VVD.Code10 as Code10
		,NULL AS SOProcedureUid 
		,NULL AS SPProcedureUid
		,NULL AS ResultStatusUid
		,'''' AS ResultStatus
		,0 AS NumericObservationValue
		,0.00 AS SystolicBP
		,0.00 AS DiastolicBP 
	FROM  MDOL_RPT2_ViewVisitDiagnosis VVD    
		
	UNION ALL
	
	SELECT 
	 NULL AS VisitUid 
		,PPDH.PatientUid 
		,CAST(PPDH.Sequence AS DATE) AS VisitDate
		,''''
		,Coalesce(PPDH.Code10,PPDH.Code9) as DiagnosisCode9
		,PPDH.Code9 as Code9
		,PPDH.Code10 as Code10
		,NULL AS SOProcedureUid 
		,NULL AS SPProcedureUid
		,NULL AS ResultStatusUid
		,'''' AS ResultStatus
		,0 AS NumericObservationValue
		,0.00 AS SystolicBP
		,0.00 AS DiastolicBP 
	FROM PatientProblemDiagnosisHistory (NOLOCK) PPDH	
)A 



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindProcedure]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewFindProcedure]
AS
SELECT
   ViewFindProcedureUid     = prc.ProcedureUid, 
   ProcedureUid             = prc.ProcedureUid, 
   ExternalID               = prc.ExternalID, 
   Inactive                 = prc.Inactive, 
   Code                     = prc.Code, 
   ProcedureCodeTypeUid     = prc.ProcedureCodeTypeUid, 
   ProcedureCodeTypeName    = pct.Name, 
   ShortDescription         = prc.ShortDescription,
   LongDescription          = ISNULL(LEFT(tab.LabNames, LEN(tab.LabNames)-1) + '': '', '''') + prc.LongDescription, 
   IDDescription            = COALESCE (''('' + prc.Code + '') '', '''') + prc.ShortDescription, 
   Notes                    = prc.Notes, 
   IsEM                     = prc.IsEM, 
   ProcedureGroupUid        = prc.ProcedureGroupUid, 
   LaboratoryUids           = LEFT(tbl.LabUids, LEN(tbl.LabUids)-1),
   Unit                     = prc.Unit,
   ProcedureModifier1Uid    = prc.ProcedureModifier1Uid, 
   ProcedureModifier2Uid    = prc.ProcedureModifier2Uid, 
   ProcedureModifier3Uid    = prc.ProcedureModifier3Uid, 
   ProcedureModifier4Uid    = prc.ProcedureModifier4Uid, 
   GenerateObservationOrder = prc.GenerateObservationOrder, 
   FDB_MEDID                = prc.FDB_MEDID, 
   RevenueCode              = prc.RevenueCode, 
   AddInProcedure           = CAST(0 AS TINYINT), 
   DefaultDontClaim         = prc.DefaultDontClaim, 
   HistoryGroupUid          = prc.HistoryGroupUid,
   SortToBottom				= prc.SortToBottom
FROM dbo.ListProcedure AS prc 
LEFT JOIN dbo.ListProcedureCodeType AS pct ON pct.ProcedureCodeTypeUid = prc.ProcedureCodeTypeUid
OUTER APPLY (
   SELECT lab.Name + '',''
   FROM RelProcedureLaboratoryOrder rel
   INNER JOIN ListLaboratoryOrder llo ON llo.LaboratoryOrderUid = rel.LaboratoryOrderUid
   INNER JOIN ListLaboratory lab ON lab.LaboratoryUid = llo.LaboratoryUid
   WHERE rel.ProcedureUid = prc.ProcedureUid
   ORDER BY rel.DisplayOrder 
   FOR XML PATH('''')) tab(LabNames)
OUTER APPLY (
   SELECT UPPER(CONVERT(VARCHAR(50), lab.LaboratoryUid)) + '',''
   FROM RelProcedureLaboratoryOrder rel
   INNER JOIN ListLaboratoryOrder llo ON llo.LaboratoryOrderUid = rel.LaboratoryOrderUid
   INNER JOIN ListLaboratory lab ON lab.LaboratoryUid = llo.LaboratoryUid
   WHERE rel.ProcedureUid = prc.ProcedureUid
   ORDER BY rel.DisplayOrder 
   FOR XML PATH('''')) tbl(LabUids)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindProcedureRVU]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewFindProcedureRVU] AS
     -- move from UDF - Bug 38547/37035
	 SELECT	p.*,
			rsv.WorkRVU + rsv.RBNonFacilityPERVU + rsv.RBFacilityPERVU + rsv.MPRVU AS RVU,
			rsv.RVUScheduleUid
	FROM	ViewFindProcedure p LEFT JOIN RVUScheduleValue rsv ON p.ProcedureUid = rsv.ProcedureUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillAggregate_Filter]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[AR_ViewSuperbillAggregate_Filter] 
AS
SELECT SB.SuperbillUid,
	SUM(ISNULL(VSPAB.Liability, 0)) AS Liability, 
	SUM(ISNULL(VSPAB.AssignedLiability, 0)) AS AssignedLiability,
	SUM(ISNULL(VSPAB.Liability, 0)) - SUM(ISNULL(VSPAB.AssignedLiability, 0)) AS UnAssignedLiability,
	SUM(ISNULL(VSPAB.Distribution, 0)) AS Distribution, 
	SUM(ISNULL(VSPAB.AssignedDistribution, 0)) AS AssignedDistribution, 
	SUM(ISNULL(VSPAB.Distribution, 0)) - SUM(ISNULL(VSPAB.AssignedDistribution, 0)) AS UnAssignedDistribution, 
	SUM(ISNULL(VSPAB.Adjustment, 0)) AS Adjustment,
	SUM(ISNULL(VSPAB.AssignedAdjustment, 0)) AS AssignedAdjustment,
	SUM(ISNULL(VSPAB.Adjustment, 0)) - SUM(ISNULL(VSPAB.AssignedAdjustment, 0)) AS UnAssignedAdjustment,
	SUM(ISNULL(VSPAB.LiabilityBalance, 0)) AS LiabilityBalance, 
	CASE WHEN SUM(ISNULL(VSPAB.LiabilityBalance, 0))=0 AND SUM(ABS(ISNULL(VSPAB.LiabilityBalance, 0)))>0 THEN 1 ELSE 0 END AS ZeroLiabilityBalanceNotDistributed, -- we have a ZeroBalance made up of offsetting balances (not properly distributed) 
	SUM(ISNULL(VSPAB.AssignedLiabilityBalance, 0)) AS AssignedLiabilityBalance,
	SUM(ISNULL(VSPAB.LiabilityBalance, 0)) - SUM(ISNULL(VSPAB.AssignedLiabilityBalance, 0)) AS UnAssignedLiabilityBalance
FROM Superbill (NOLOCK) SB
	LEFT JOIN SuperbillProcedure (NOLOCK) SBP ON SB.SuperbillUid = SBP.SuperbillUid
	LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON SBP.SuperbillProcedureUid = VSPAB.SuperbillProcedureUid
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON SB.SuperbillStatusUid = rpsss.SuperbillStatusUid
WHERE  rpsss.superbillstatusuid is null
GROUP BY SB.SuperbillUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFormattingTemplateAttachmentGroup]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewFormattingTemplateAttachmentGroup] AS
       SELECT ag.AttachmentGroupUid, ag.Name, ft.FormattingTemplateUid, ft.Name AS FormattingTemplate,
            COALESCE(rag.PersonUid, v.PatientUid) AS PersonUid, rag.VisitUid, CAST(ag.LastModifiedDate AS DATE) AS AttachmentDate,
            p.FirstName, p.LastName, p.FullName, p.PatientExternalID AS ExternalID
       FROM   ListFormattingTemplate ft INNER JOIN Attachment a ON a.FormattingTemplateUid = ft.FormattingTemplateUid
				INNER JOIN AttachmentGroup ag on a.AttachmentGroupUid = ag.AttachmentGroupUid
				INNER JOIN RelAttachmentGroup rag ON ag.AttachmentGroupUid = rag.AttachmentGroupUid
				LEFT JOIN Visit v ON rag.VisitUid = v.VisitUid
				LEFT JOIN ViewFindPerson p ON COALESCE(rag.PersonUid, v.PatientUid) = p.PersonUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[NDD_ViewClassificationAHFS]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[NDD_ViewClassificationAHFS] AS
SELECT
   AHFS8                      = tab.AHFS8,
   classid                    = cls.classid,
   Description                = tab.AHFS_DESC,
   parentid                   = par.parentid,
   ParentDescription          = (SELECT tbl.AHFS_DESC FROM dbo.NDD_RAHFSD1_DESC tbl WHERE tbl.IsDelete = 0 AND tbl.AHFS8 = CONVERT(NUMERIC(8,0), par.parentid) * 100),
   ultimateparentid           = par.ultimateparentid,
   UltimateParentDescription  = (SELECT tbl.AHFS_DESC FROM dbo.NDD_RAHFSD1_DESC tbl WHERE tbl.IsDelete = 0 AND tbl.AHFS8 = CONVERT(NUMERIC(8,0), par.ultimATEparentid) * 100),
   hierarchylevel             = CASE WHEN par.parentid IS NULL THEN 1
                                     WHEN par.parentid = par.ultimateparentid THEN 2
                                     ELSE 3
                                END,
   IsDelete                   = tab.IsDelete,
   LastModifiedDate           = tab.LastModifiedDate
FROM NDD_RAHFSD1_DESC tab
CROSS APPLY (
   SELECT classid      = CASE WHEN tab.ahfs8 > 9999999 THEN + SUBSTRING(CONVERT(VARCHAR(8), tab.ahfs8), 1, 6)
                              ELSE ''0'' + SUBSTRING(CONVERT(VARCHAR(8), tab.ahfs8), 1, 5)
                         END) cls
CROSS APPLY (
   SELECT
      parentid         = CASE WHEN SUBSTRING(cls.classid, 3, 4) = ''0000'' THEN NULL
                              WHEN SUBSTRING(cls.classid, 5, 2) = ''00'' THEN SUBSTRING(cls.classid, 1, 2) + ''0000''
                              ELSE SUBSTRING(cls.classid, 1, 4) + ''00''
                         END,
      ultimateparentid = CASE WHEN SUBSTRING(cls.classid, 3, 4) = ''0000'' THEN NULL
                              ELSE SUBSTRING(cls.classid, 1, 2) + ''0000''
                         END) par
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[fdb_classification_ahfs]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[fdb_classification_ahfs] AS
SELECT
   PK                         = ISNULL(CONVERT(UNIQUEIDENTIFIER, dbo.IntToGUID(tab.classid)), ''00000000-0000-0000-0000-00000000FFFF''),
   classid                    = ISNULL(CONVERT(varchar(6), tab.classid), 0),
   description1               = CONVERT(VARCHAR(40),      tab.Description),
   description2               = CONVERT(VARCHAR(120),     NULL),
   description3               = CONVERT(VARCHAR(120),     NULL),
   description4               = CONVERT(VARCHAR(120),     NULL),
   description5               = CONVERT(VARCHAR(120),     NULL),
   description6               = CONVERT(VARCHAR(120),     NULL),
   ultimatechildind           = CONVERT(SMALLINT,         NULL),
   directdruglinkind          = CONVERT(SMALLINT,         NULL),
   parentid                   = CONVERT(VARCHAR(6),       NULL),
   formularylevelind          = CONVERT(SMALLINT,         NULL),
   presentationseqno          = CONVERT(INT,              NULL),
   ultiparentid               = CONVERT(VARCHAR(6),       NULL),
   hierarchylevel             = CONVERT(SMALLINT,         NULL),
   sortnumber                 = CONVERT(INT,              NULL),
   retiredind                 = CONVERT(SMALLINT,         NULL),
   retireddate                = CONVERT(VARCHAR(8),       NULL),
   altcode                    = CONVERT(VARCHAR(20),      NULL),
   LastModifiedByUid          = CONVERT(UNIQUEIDENTIFIER, NULL),
   LastModifiedDate           = tab.LastModifiedDate
FROM dbo.NDD_ViewClassificationAHFS tab
WHERE tab.IsDelete = 0
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalance_MainAccount]'))
EXEC dbo.sp_executesql @statement = N'






CREATE VIEW [dbo].[ViewStatementSuperbillBalance_MainAccount]  WITH SCHEMABINDING
AS 
SELECT
	A.AccountResponsiblePartyUid as RPUid, 
	S.SuperbillUid, 
	LD.FinancialCenterUid,
	Sum(Case When LD.LiabilityOwner > 0  Then LD.Amount Else Convert(Money, 0) End) as Insurance, 
	Sum(Case When LD.LiabilityOwner = 0  Then LD.Amount Else Convert(Money, 0) End) as Patient,
	Sum(LD.Amount) as LiabilityBalance,
	S.SuperbillStatusUid,
	COUNT_BIG(*) MaxCnt
FROM	dbo.AR_Ledger (NOLOCK) L 
INNER JOIN	dbo.AR_LedgerDetail (NOLOCK) LD
ON	L.LedgerUid=LD.LedgerUid 
INNER JOIN	dbo.SuperbillProcedure (NOLOCK) SP 
ON	SP.SuperbillProcedureUid=LD.SuperbillProcedureUid
INNER JOIN	dbo.Superbill (NOLOCK) S 
ON	S.SuperbillUid=SP.SuperbillUid
INNER JOIN	dbo.Account (NOLOCK) A 
ON	S.AccountUid = A.AccountUid
WHERE A.IsMain = 1
GROUP BY 
	A.AccountResponsiblePartyUid, S.SuperbillUid, LD.FinancialCenterUid, SuperbillStatusUid

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_ViewStatementSuperbillBalance_MainAccount_AccountResponsiblePartyUid ON ViewStatementSuperbillBalance_MainAccount(RPUid, SuperbillUid, FinancialCenterUid)

*/




' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalance_MainAccount]') AND name = N'PK_ViewStatementSuperbillBalance_MainAccount_AccountResponsiblePartyUid')
CREATE UNIQUE CLUSTERED INDEX [PK_ViewStatementSuperbillBalance_MainAccount_AccountResponsiblePartyUid] ON [dbo].[ViewStatementSuperbillBalance_MainAccount]
(
	[RPUid] ASC,
	[SuperbillUid] ASC,
	[FinancialCenterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalanceExcludeStatus_MainAccount]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewStatementSuperbillBalanceExcludeStatus_MainAccount] 
AS 
SELECT
	RPUid, 
	SuperbillUid, 
	FinancialCenterUid,
	Insurance, 
	Patient,
	LiabilityBalance,
	MaxCnt
FROM	dbo.ViewStatementSuperbillBalance_MainAccount vssb WITH (NOEXPAND)
LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
ON vssb.SuperbillStatusUid = rpsss.SuperbillStatusUid
where rpsss.superbillstatusuid is null


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewClaimingProviderAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewClaimingProviderAggregateSub] WITH SCHEMABINDING  AS  
SELECT ClaimingProviderUid, SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.AMOUNT ELSE 0 END) As Liability,
			SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT ELSE 0 END) As AssignedLiability,        
			SUM(CASE WHEN L.EntryType = 2  THEN LD.AMOUNT*-1 ELSE 0 END) As Distribution,        
			SUM(CASE WHEN L.EntryType = 2 AND NOT LD.InsurancePlanUid IS NULL  THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedDistribution,        
			SUM(CASE WHEN L.EntryType = 3 THEN LD.AMOUNT*-1 ELSE 0 END) As Adjustment,        
			SUM(CASE WHEN L.EntryType = 3 AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedAdjustment,        
			SUM(LD.Amount) As LiabilityBalance, SUM(CASE WHEN NOT LD.InsurancePlanUid IS NULL THEN LD.Amount ELSE 0 END) As AssignedLiabilityBalance,        
			COUNT_BIG(*) AS Count  
		FROM dbo.AR_LedgerDetail LD        
			INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
		WHERE NOT ClaimingProviderUid IS NULL AND NOT SuperbillProcedureUid IS NULL   
		GROUP BY ClaimingProviderUid        

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewClaimingProviderAggregateSub_ClaimingProviderUid ON AR_ViewClaimingProviderAggregateSub(ClaimingProviderUid)

*/

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewClaimingProviderAggregateSub]') AND name = N'PK_AR_ViewClaimingProviderAggregateSub_ClaimingProviderUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewClaimingProviderAggregateSub_ClaimingProviderUid] ON [dbo].[AR_ViewClaimingProviderAggregateSub]
(
	[ClaimingProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewClaimingProviderAggregate]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewClaimingProviderAggregate] 
AS
SELECT PRO.PersonUid AS ClaimingProviderUid, 
	ISNULL(VCPAB.Liability, 0) AS Liability, 
	CAST(ISNULL(VCPAB.AssignedLiability, 0) AS MONEY) AS AssignedLiability,
	ISNULL(VCPAB.LiabilityBalance, 0) AS LiabilityBalance, 
	CAST(ISNULL(VCPAB.AssignedLiabilityBalance, 0) AS MONEY) AS AssignedLiabilityBalance
FROM Provider PRO
LEFT JOIN AR_ViewClaimingProviderAggregateSub (NOEXPAND) VCPAB ON PRO.PersonUid = VCPAB.ClaimingProviderUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindTranscriptionist]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewFindTranscriptionist] AS

	SELECT	t.PersonUid, t.Inactive, t.ExternalID, 
			vp.FullName as [FullName], vp.AkaName,
			p.Prefix, p.FirstName, p.MiddleName, p.LastName, p.Suffix,
			p.AkaFirstName, p.AkaLastName
	FROM    Transcriptionist t INNER JOIN Person p ON t.PersonUid = p.PersonUid
			INNER JOIN dbo.ViewPerson AS vp (NOEXPAND) ON p.PersonUid = vp.PersonUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_StatementLineItem_MainAccount]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[MDOL_RPT2_VIEW_StatementLineItem_MainAccount]  
AS  
/* Source fOR the line items in the paper AND electronic statement.  
 AS of GA5, the paper statement does NOT use the Header, Comment, AND Subtotal types.  
 gaps have been LEFT in the display ORder fOR adding comment lines at any point.   
 Comments to be mixed in with a certain type should have the same display ORder,  
 e.g., claim filing comments are mixed with payments.  
  
 The primary keys of the biz object view fOR this are ItemUid, SuperbillUid,    
 DisplayOrder, AND CreditSubOrder so make sure this set of four is unique if you   
 update this view.  
  
 Use CreditSubOrder to ORder items associated with an individual payment OR adjustment  
 credit. Make it less than 2 to precede the payment OR adjustment OR greater than 2  
 to follow it. E.g., a credit statement note follows the credit.  
  
 The intENDed ORdering fOR these line items is:  
 ORDER BY RPUid, SuperbillDate asc, SuperbillUid, DisplayOrder asc, ItemDate asc,   
  CreditGroupUid, IsPayment desc, CreditUid, CreditSubOrder asc   
*/  
/*  
 01/24/2008 - Qatalys - Modified to remove GLDate (#13093)  
 05/19/2008 - Qatalys - Modified to include Financial Center  
 08/02/2011 - kbernecker - branched off of ViewStatementLineItem for performance reasons 
 11/15/2011 - kbernecker - remove payment notes (entire "Transfer" section), fixed reference numbers
 7/05/2012 - kbernecker - add payer information
 6/04/2013 - kbernecker - modified to use lastfileddate cte and get insurance plan correctly
 08/12/2013 - kbernecker - fix problem with initial transfers being lost and also get correct insurance payer
 01/28/2014 - kbernecker - fix issue with truly distinct payments and transfers that are being lost because they have the same posting date and reference number. add superbillprocedureuid to criteria.
 01/29/2014 - kbernecker - roll up payments and adjustments to sum them, but not lose the ones that appear to be identical
 10/14/2014 - kculberth - updated logic to match regular statements by practice
 20150109 - kculberth - add statement notes from reason codes
*/   
--NEW
WITH cteWhoPaidName --Stolen from ViewDeposit
AS
-- Define the CTE query.
(
SELECT d.deposituid,
      ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumber, -- mark as <ND> so can hyperlink on null values
      (CASE WHEN p.PersonUid IS NOT NULL THEN p1.FormattedPreferredName
       WHEN icArp.CorporationUid IS NOT NULL THEN icArp.Name
       WHEN LD.InsurancePayerUid IS NOT NULL THEN ic.Name END) AS WhoPaidName,
       L.EntryType  
FROM Deposit d WITH (NOLOCK)
            INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON d.DepositUid = LD.DepositUid
            INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid
            LEFT OUTER JOIN AR_Ledger arlVoid WITH (NOLOCK) on L.LedgerUid = arlVoid.VoidLedgerUid      -- Checks for voiding entries                                       
            LEFT JOIN AccountResponsibleParty arp WITH (NOLOCK) on LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid            
            LEFT JOIN Person p WITH (NOLOCK) ON arp.PersonUid = p.PersonUid 
            LEFT JOIN Corporation icArp WITH (NOLOCK) ON arp.CorporationUid = icArp.CorporationUid
            LEFT JOIN Corporation ic WITH (NOLOCK) ON ic.CorporationUid = LD.InsurancePayerUid 
            LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = p.PersonUid              
WHERE (L.EntryType = 0 -- Payment
	   OR L.EntryType = 3) -- Adjustment
       AND  (L.VoidLedgerUid IS NULL AND arlVoid.LedgerUid IS NULL) -- Don''t include reversing(void) entries
       AND LD.IsCredit = 1                                              
       AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits    
),
cteLastFiledDate --
AS
-- Define the CTE query.
(
	SELECT SA.SuperbillUid,SA.LastFiledDate,SA.CurrentInsurancePlanUid
	FROM SuperbillAggregate SA WITH (NOLOCK)
)   
SELECT   
 FinancialCenterUid,  
 ItemUid,   
 RPUid,   
 ''Charge'' AS Type,   
 4 AS DisplayOrder,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 NULL AS CreditGroupUid,   
 0 AS IsPayment,   
 NULL AS CreditUid,   
 0 AS CreditSubOrder,   
 '''' AS WhoPaid,   
 Description,   
 Charge,   
 SUM(Insurance) AS Insurance,  
 SUM(Patient) AS Patient,  
 SUM(Amount) AS Amount,  
 --MIN(AGE)  AS Age,  
 age,
 SuperbillProcedureUid,  
 MAX(TotalCharge) TotalCharge,  
 MAX(LastFiledDate) LastFiledDate,  
 '''' AS ReferenceNumber,  
 ReferringProviderName,  
 InsuranacePlan,  
 MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
 1 AS CompleteBatch,
 0 AS DisplayOrder2    
 FROM  
 (  
SELECT   
 LD.FinancialCenterUid,  
 SP.SuperbillProcedureUid AS ItemUid,   
 A.AccountResponsiblePartyUid AS RPUid, 
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName,   
 A.ExternalID AS AccountID,   
 S.ExternalID AS SuperbillID,   
 S.SuperbillUid,   
 S.ServiceDateStart AS SuperbillDate,   
 SP.ProcedureServiceDateStart AS ItemDate,     
 (CASE WHEN (PS.IncludeProcedureCode=1) 
 THEN ISNULL(LP.Code, '''') +ISNULL('' '' + LP.ShortDescription, '''')  
 ELSE ISNULL('' '' + LP.ShortDescription, '''') END) AS Description,   
 COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS Charge,   
 (CASE WHEN LD.LiabilityOwner > 0   THEN LD.Amount ELSE CONVERT(Money, 0) END) AS Insurance,  
 (CASE WHEN LD.LiabilityOwner = 0 THEN LD.Amount ELSE CONVERT(Money, 0) END) AS Patient,  
 ISNULL(LD.Amount,0) AS Amount,  
 --DATEDIFF(DD, (ARB.GLDate), GETUTCDATE())  AS Age, 
 NULL as age, 
 SP.SuperbillProcedureUid,   
 COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS TotalCharge,   
 lfd.LastFiledDate as LastFiledDate,    
 p3.FormattedPreferredName AS ReferringProviderName,
 (SELECT top 1 IP.Name from ClaimBatchDetail (NOLOCK) CBD   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL
		LEFT JOIN InsurancePlan (NOLOCK) IP ON CBD.InsurancePlanUid = IP.InsurancePlanUid   
		where CBD.SuperbillUid = S.SuperbillUid) as InsuranacePlan,
-- IP.Name as InsuranacePlan,	
 (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) IsSuperbilCompleteBatch,   
 (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch   
FROM
		AR_LedgerDetail LD WITH (NOLOCK)
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid AND (L.EntryType=1 OR L.EntryType=4)		
        LEFT JOIN AR_Ledger LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure SP WITH (NOLOCK) on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill S WITH (NOLOCK) ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid AND A.IsMain = 1
		INNER JOIN ListProcedure LP WITH (NOLOCK) ON SP.ProcedureUid = LP.ProcedureUid  		
		LEFT JOIN InsurancePlan IP WITH (NOLOCK) ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation C WITH (NOLOCK) ON IP.InsuranceCarrierUid = C.CorporationUid   
		--LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		--LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
		--			 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd WITH (NOLOCK) on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK) on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK) on p3.personuid = s.ReferringProviderUid   
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings PS WITH (NOLOCK)  	  	
 WHERE rpsss.superbillstatusuid is null and
	(L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) --AND LD.IsCredit = 0  AND (L.EntryType = 1)
) A   
GROUP BY   
 FinancialCenterUid,  
 ItemUid,   
 RPUid,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 Description,   
 Charge,   
 SuperbillProcedureUid,  
 ReferringProviderName,  
 InsuranacePlan,
 age     
UNION ALL   
select 
	FinancialCenterUid,  
	ItemUid,  
	RPUid,   
	Type,   
	DisplayOrder,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	MIN(ItemDate) AS ItemDate,   
	CreditGroupUid,  
	IsPayment,   
	CreditUid,   
	2 AS CreditSubOrder,   
	WhoPaid,   
	Description,  
	Charge,   
	SUM(Insurance) AS Insurance,   
	SUM(Patient) AS Patient,  
	SUM(Amount) AS Amount,  
	0 AS Age,  
	NULL AS SuperbillProcedureUid,  
	MAX(TotalCharge) AS TotalCharge,  
	MAX(LastFiledDate) AS LastFiledDate,  
	ReferenceNumber,  
	 ReferringProviderName,  
	'''' as InsuranacePlan,  
	MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
	--CASE WHEN AR.IsClosed =1 OR AR.IsLocked =1 THEN 1 ELSE 0 END   
	1 CompleteBatch, 
	DisplayOrder2 
FROM
(
	SELECT DISTINCT  
		FinancialCenterUid,  
		ItemUid,  
		RPUid,   
		Type,   
		CASE WHEN Type=''Payment'' THEN 5 ELSE 6 END AS DisplayOrder,   
		PatientName,   
		RenderingProviderName,   
		AccountID,   
		SuperbillID,   
		SuperbillUid,   
		SuperbillDate,   
		MIN(ItemDate) AS ItemDate,   
		CreditGroupUid,  
		IsPayment,   
		CreditUid,   
		2 AS CreditSubOrder,   
		WhoPaid,   
		Description,  
		CONVERT(Money, 0) AS Charge,   
		SUM(Insurance) AS Insurance,   
		SUM(Patient) AS Patient,  
		SUM(Amount) AS Amount,  
		0 AS Age,  
		SuperbillProcedureUid,  
		MAX(TotalCharge) AS TotalCharge,  
		MAX(LastFiledDate) AS LastFiledDate,  
		ReferenceNumber,  
		 ReferringProviderName,  
		'''' as InsuranacePlan,  
		MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
		--CASE WHEN AR.IsClosed =1 OR AR.IsLocked =1 THEN 1 ELSE 0 END   
		1 CompleteBatch, 
		DisplayOrder2 
	FROM  
	(  
	 SELECT DISTINCT  
		 LD.FinancialCenterUid,  
		 (CASE WHEN LCT.Name = ''Patient Payment'' THEN D.DepositUid ELSE LD.FinancialCenterUid END) AS ItemUid, 
		 A.AccountResponsiblePartyUid AS RPUid,   
		 (CASE WHEN L.EntryType  = 2 THEN ''Payment'' ELSE ''Adjustment'' END) AS Type,    
		 p1.FormattedPreferredName AS PatientName,   
		 p2.FormattedPreferredName AS RenderingProviderName,  
		 A.ExternalID AS AccountID,   
		 S.ExternalID AS SuperbillID,   
		 S.SuperbillUid,   
		 S.ServiceDateStart AS SuperbillDate,   
		 (ARB.GLDate) AS ItemDate,   
		 LD.FinancialCenterUid  CreditGroupUid,  
		 (CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
		 LD.FinancialCenterUid CreditUid,      
		 WhoPaid.WhoPaidName AS WhoPaid, 
					(CASE WHEN L.EntryType != 2
						  THEN ISNULL(LCT.Name,'''')
						  ELSE
							 (CASE WHEN PS.IncludePaymentReferenceNumber = 1 
							  THEN 
								 ISNULL(LCT.Name,'''') + '' Ref #'' + ISNULL(WhoPaid.ReferenceNumber,''N/A'') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
							  ELSE ISNULL(LCT.Name,'''') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
							  END)
					  END) as Description,
		 (CASE WHEN LD.LiabilityOwner > 0 THEN (LD.Amount) ELSE CONVERT(Money, 0) END) AS Insurance,   
		 (CASE WHEN LD.LiabilityOwner = 0 THEN (LD.Amount) ELSE CONVERT(Money, 0) END) AS Patient,  
		 (ISNULL(LD.Amount, 0)) AS Amount,    
		 LD.SuperbillProcedureUid,  
		 (SP.TotalCharge) AS TotalCharge,  
		 lfd.LastFiledDate AS LastFiledDate,  
		 D.ReferenceNumber,  
		  p3.FormattedPreferredName AS ReferringProviderName,
		 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) AS InsuranacePlan,  
		 ((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) AS IsSuperBilCompleteBatch,  
		 CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END CompleteBatch,
		 CASE 
			  WHEN LCT.IsPayment = 1 THEN 1    
			  WHEN LCT.IsAdjustment = 1 THEN 2    
		  ELSE 3     
		  END AS DisplayOrder2
	 FROM  
		AR_LedgerDetail LD WITH (NOLOCK)
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid        
		LEFT JOIN AR_Ledger LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid  
		INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid=ARB.ARBatchUid   
		INNER JOIN SuperbillProcedure SP WITH (NOLOCK) on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill S WITH (NOLOCK) ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid AND A.IsMain = 1 
		INNER JOIN AR_LedgerDetail LDOS WITH (NOLOCK) ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid                        
		LEFT JOIN InsurancePlan IP WITH (NOLOCK) ON LD.InsurancePlanUid = IP.InsurancePlanUid  	
		LEFT JOIN ClaimBatchDetail CBD WITH (NOLOCK) ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch CB WITH (NOLOCK) ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid 
		LEFT JOIN cteLastFiledDate lfd WITH (NOLOCK) on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN AR_Transaction T WITH (NOLOCK) ON L.TransactionUid = T.TransactionUid 
		LEFT JOIN Deposit d WITH (NOLOCK) ON D.DepositUid = T.DepositUid            
		LEFT JOIN ListCreditType LCT WITH (NOLOCK) ON LD.IncomeAccountUid = LCT.CreditTypeUid 
		LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK) on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK) on p3.personuid = S.ReferringProviderUid   
		LEFT JOIN cteWhoPaidName AS whoPaid WITH (NOLOCK) ON d.depositUid = WhoPaid.deposituid --and d.referencenumber = WhoPaid.referencenumber
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings PS WITH (NOLOCK) 
	  WHERE rpsss.superbillstatusuid is null and
			(L.EntryType=2 OR L.EntryType=3) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 1 
	) B     
	GROUP BY  
	 FinancialCenterUid,  
	 ItemUid,  
	 RPUid,   
	 Type,   
	 PatientName,   
	 RenderingProviderName,   
	 AccountID,   
	 SuperbillID,   
	 SuperbillUid,   
	 SuperbillDate,  
	 CreditGroupUid,   
	 IsPayment,   
	 CreditUid,   
	 WhoPaid,   
	 Description,  
	 --SuperbillProcedureUid,  
	 ReferenceNumber, 
	 SuperbillProcedureUid, 
	 ReferringProviderName,  
	 InsuranacePlan,
	 DisplayOrder2
	) A
GROUP BY  
 FinancialCenterUid,  
 ItemUid,  
 RPUid,   
 Type,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate, 
 DisplayOrder, 
 CreditGroupUid,   
 IsPayment,   
 CreditUid,   
 WhoPaid,   
 Description,  
 --SuperbillProcedureUid,  
 ReferenceNumber, 
 Charge,
 ReferringProviderName,  
 InsuranacePlan,
 DisplayOrder2
   
UNION ALL  
  
--Claim filing comment can be mixed among the payments, so use the same display ORder  
SELECT   
LD.FinancialCenterUid,  
CB.ClaimBatchUid AS ItemUid,   
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
6 AS DisplayOrder,   
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName, 
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
MAX(CB.ClaimDate) AS ItemDate,   
NULL AS CreditGroupUid,   
0 AS IsPayment,   
NULL AS CreditUid,   
0 AS CreditSubOrder,   
'''' AS WhoPaid,   
(dbo.ARFN_getInsLevelName(CB.InsuranceOrder) + '' claim filed to '' +ISNULL(C.Name,'''')) AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
NULL SuperbillProcedureUid, --CR,  
MAX(SP.TotalCharge) TotalCharge,  
 lfd.LastFiledDate as LastFiledDate,    
'''' AS ReferenceNumber,  
 p3.FormattedPreferredName AS ReferringProviderName,
 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan,
CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END IsSuperBilCompleteBatch,  
CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END CompleteBatch,
 0 AS DisplayOrder2 
FROM  
		AR_LedgerDetail LD WITH (NOLOCK)
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure SP WITH (NOLOCK) on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill S WITH (NOLOCK) ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid AND A.IsMain = 1 
		LEFT JOIN InsurancePlan IP WITH (NOLOCK) ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation C WITH (NOLOCK) ON IP.InsuranceCarrierUid = C.CorporationUid   
		LEFT JOIN ClaimBatchDetail CBD WITH (NOLOCK) ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch CB WITH (NOLOCK) ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd WITH (NOLOCK) on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK) on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson p3 WITH (NOEXPAND, NOLOCK) on p3.personuid = s.ReferringProviderUid   
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings PS WITH (NOLOCK) 
 WHERE rpsss.superbillstatusuid is null and
	(L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 0  AND (L.EntryType = 1) 
GROUP BY   
 LD.FinancialCenterUid,  
 CB.ClaimBatchUid,   
 A.AccountResponsiblePartyUid,   
 S.PatientUid,   
 LD.RenderingProviderUid,  
 A.ExternalID,  
 S.ExternalID,   
 S.SuperbillUid,   
 S.ServiceDateStart,
 CB.ClaimDate,   
 CB.InsuranceOrder,   
 C.Name,
 lfd.LastFiledDate,    
 ARB.IsClosed,      
 ARB.IsLocked,
 S.ReferringProviderUid,  
  p1.FormattedPreferredName,
  p2.FormattedPreferredName,
  p3.FormattedPreferredName
UNION ALL   
  
--Statement notes FROM credits. Associated with the payments AND adjustments, so use the same display ORder  
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
SELECT   
LD.FinancialCenterUid,  
LD.LedgerDetailUid AS ItemUid,   
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
CASE WHEN L.EntryType=1 THEN 4
WHEN L.EntryType=2 THEN 5 
WHEN L.EntryType=3 THEN 6
WHEN L.EntryType =4 THEN 7
ELSE 6 END AS DisplayOrder,   
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName,   
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
COALESCE(ARB.GLDate,D.DepositDate,S.ServiceDateStart,NULL) AS ItemDate,      
LD.LedgerDetailUid AS CreditGroupUid,  
(CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
LD.LedgerDetailUid AS CreditUid,  
4 AS CreditSubOrder,   
'''' AS WhoPaid,   
L.StatementNote AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
LD.SuperbillProcedureUid,  
SP.TotalCharge,  
 lfd.LastFiledDate AS LastFiledDate,  
'''' AS ReferenceNumber,  
 p3.FormattedPreferredName AS ReferringProviderName,
 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan,
((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) IsSuperBilCompleteBatch,  
((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) CompleteBatch,
 CASE    
      WHEN LCT.IsPayment = 1 THEN 1    
      WHEN LCT.IsAdjustment = 1 THEN 2    
  ELSE 3     
  END AS DisplayOrder2
FROM 
	AR_LedgerDetail (NOLOCK) LD
	INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger LVOID WITH (NOLOCK) ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure SP WITH (NOLOCK) on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill S WITH (NOLOCK) ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid AND A.IsMain = 1 
	INNER JOIN AR_LedgerDetail LDOS WITH (NOLOCK) ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid     		
	LEFT JOIN InsurancePlan IP WITH (NOLOCK) ON LD.InsurancePlanUid = IP.InsurancePlanUid  	
	LEFT JOIN ClaimBatchDetail CBD WITH (NOLOCK) ON CBD.SuperbillUid = S.SuperbillUid   
	LEFT JOIN ClaimBatch CB WITH (NOLOCK) ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
				 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid 
	LEFT JOIN cteLastFiledDate lfd WITH (NOLOCK) on lfd.SuperbillUid = S.SuperbillUid					 	
	LEFT JOIN Deposit d WITH (NOLOCK) ON D.DepositUid = LDOS.DepositUid
	LEFT JOIN ListCreditType LCT WITH (NOLOCK) ON LD.IncomeAccountUid = LCT.CreditTypeUid 
	LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson p2 WITH (NOEXPAND, NOLOCK) on p2.personuid = LD.RenderingProviderUid 
	LEFT JOIN ViewPerson p3 WITH (NOEXPANd, NOLOCK) on p3.personuid = s.ReferringProviderUid 	  
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	CROSS JOIN PracticeSettings PS WITH (NOLOCK) 
WHERE rpsss.superbillstatusuid is null and
 (L.StatementNote is NOT NULL OR L.StatementNote != '''')   
 AND (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
 AND (L.EntryType=2 OR L.EntryType=3 OR L.EntryType=4) AND LD.IsCredit = 1  
 UNION ALL
select FinancialCenterUid,
NULL as ItemUid,
 RPUid,   
Type,   
 DisplayOrder,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 CreditGroupUid,   
IsPayment,   
CreditUid,   
 CreditSubOrder,   
  WhoPaid,   
 Description,   
 Charge,   
 Insurance,  
 Patient,  
 Amount,  
 --MIN(AGE)  AS Age,  
 age,
 SuperbillProcedureUid,  
 TotalCharge,  
 LastFiledDate,  
 ReferenceNumber,  
 ReferringProviderName,  
 InsuranacePlan,  
 IsSuperBilCompleteBatch,  
 CompleteBatch,
 DisplayOrder2
 from (   
SELECT distinct  
LD.FinancialCenterUid,  
--LD.LedgerDetailUid AS ItemUid,   
NULL as ItemUid,
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
6 AS DisplayOrder,   
p1.FormattedPreferredName AS PatientName,   
NULL AS RenderingProviderName,   
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
SP.ProcedureServiceDateStart AS ItemDate,      
--LD.LedgerDetailUid AS CreditGroupUid,  
--(CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
--LD.LedgerDetailUid AS CreditUid,  
NULL AS CreditGroupUid,  
NULL AS IsPayment,   
NULL AS CreditUid,  
4 AS CreditSubOrder,   
'''' AS WhoPaid,   
adj.StatementNote AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
--LD.SuperbillProcedureUid,  
--SP.TotalCharge AS TotalCharge,  
NULL AS SuperbillProcedureUid,  
CASE WHEN SP.TotalCharge > 0 THEN 99999 ELSE 0 END AS TotalCharge,  
 NULL AS LastFiledDate,  
'''' AS ReferenceNumber,  
NULL AS ReferringProviderName,
NULL AS  InsuranacePlan,
NULL AS IsSuperBilCompleteBatch,  
NULL AS CompleteBatch,
  3  AS DisplayOrder2
FROM Superbill (NOLOCK) S 
	INNER JOIN SuperbillProcedure SP WITH (NOLOCK) ON SP.superbilluid = S.superbilluid
	INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SP.SuperbillProcedureUid = LD.SuperbillProcedureUid
	INNER JOIN Account A WITH (NOLOCK) ON S.AccountUid = A.AccountUid AND A.IsMain = 1   
	LEFT JOIN ViewPerson p1 WITH (NOEXPAND, NOLOCK) on p1.personuid = S.PatientUid  
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus rpsss WITH (NOLOCK)
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	left join cobclaimdetail cob WITH (NOLOCK) on cob.superbilluid = s.superbilluid
	left join COBLineAdjustments adj WITH (NOLOCK) on adj.cobclaimdetailuid = cob.cobclaimdetailuid and adj.superbillprocedureuid = sp.superbillprocedureuid and adj.Notes IS NOT NULL
	CROSS JOIN PracticeSettings PS WITH (NOLOCK) 
WHERE rpsss.superbillstatusuid is null and
 (adj.StatementNote is NOT NULL OR adj.StatementNote != '''')  
 ) A 			









' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_FQHCBadDebt]'))
EXEC dbo.sp_executesql @statement = N'

CREATE View [dbo].[MDOL_RPT2_View_FQHCBadDebt]
AS
--2016.02.18 dmg added With (nolock)
With CTE_SuperbillInsurance AS
	(
		SELECT  SB.patientUid,VSAI.ExternalID, VSAI.SuperbillUid, VSAI.DisplayOrder, VIPL.Name, PIP.PlanMemberID--, LAT.ANSICode
			FROM ViewSuperbillAccountInsurance VSAI 
			INNER JOIN Superbill Sb WITH (NOLOCK) ON SB.superbilluid=vsai.superbilluid  --2016.02.28 dmg
				LEFT JOIN AccountInsurance AI WITH (NOLOCK) ON VSAI.AccountInsuranceUid = AI.AccountInsuranceUid
				LEFT JOIN PersonInsurancePlan PIP WITH (NOLOCK) ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
				LEFT JOIN ViewInsurancePlan VIPL WITH (NOLOCK) ON PIP.InsurancePlanUid = VIPL.InsurancePlanUid
				Left JOIn AccountPeriod AP WITH (NOLOCK) on AP.accountperioduid=AI.AccountPeriodUid --2016.02.18 dmg
				LEFT JOIN ListAccountType LAT WITH (NOLOCK) ON LAT.AccountTypeUid=AP.AccountTypeUid --2016.02.18 dmg
	),

CTE_SuperbillInsuranceExtended AS
	(
		SELECT dbo.UDF_getFormattedPreferredName(SI_PRI.Patientuid) as Patient,SI_PRI.ExternalID, SA.SuperbillUid, 
				SI_PRI.Name AS PrimaryInsurance, SI_PRI.PlanMemberID AS PrimaryMemberId,
				SI_SEC.Name AS SecondaryInsurance, SI_SEC.PlanMemberID AS SecondaryMemberId
			FROM SuperbillAggregate SA WITH (NOLOCK)
				LEFT JOIN ViewInsurancePlan VIPL_CUR WITH (NOLOCK) ON SA.CurrentInsurancePlanUid = VIPL_CUR.InsurancePlanUid
				LEFT JOIN CTE_SuperbillInsurance SI_PRI WITH (NOLOCK) ON SA.SuperbillUid = SI_PRI.SuperbillUid AND SI_PRI.DisplayOrder = 1
				LEFT JOIN CTE_SuperbillInsurance SI_SEC WITH (NOLOCK) ON SA.SuperbillUid = SI_SEC.SuperbillUid AND SI_SEC.DisplayOrder = 2
				WHERE SI_PRI.ExternalID is not null
			
	),
CTE_Deductible
AS
(
Select 
A.Patient
,A.SuperbillUid
,A.ExternalID
,Max(ServiceDateStart) as ServiceDateStart
,Max(ServiceDateEnd) as ServiceDateEnd
,Max(AdjudicationDate) as AdjudicationDate
,Sum(Deductible) as Deductible
From(
select dbo.UDF_getFormattedPreferredName(sb.Patientuid) as Patient
,sb.SuperbillUid
,sb.ExternalID
,sb.ServiceDateStart
,sb.ServiceDateEnd
,sbp.DisplayOrder
,lp.Code
,ccd.AdjudicationDate
,grp.Code as [Group]
,rsn.Code as Reason
,sum( -cobl.Amount) as Deductible
From Superbill sb with (Nolock)
              inner join SuperbillProcedure sbp with (nolock) on sb.SuperbillUid = sbp.SuperbillUid
              inner join ListProcedure lp with (nolock) on sbp.ProcedureUid = lp.ProcedureUid
              inner join COBLineAdjustments cobl with (nolock) on sbp.SuperbillProcedureUid = cobl.SuperbillProcedureUid
			  inner join COBClaimDetail ccd with (nolock) on ccd.SuperbillUid=sbp.SuperbillUid --2016.02.18 dmg
              inner join ListERACode grp with (nolock) on cobl.GroupCodeERACodeUid = grp.ERACodeUid
			  inner join ListERACode rsn with (nolock) on cobl.ReasonCodeERACodeUid = rsn.ERACodeUid AND rsn.code=1
group by Sb.Patientuid,sb.SuperbillUid,sb.ExternalID, sb.ServiceDateStart,sb.ServiceDateEnd,sbp.DisplayOrder, lp.Code, grp.Code, rsn.Code,ccd.AdjudicationDate) A
Group by 
A.Patient
,A.SuperbillUid
,A.ExternalID
),
CTE_PostingDate
AS
(
Select sb.superbillUid, Max(ARl.EntryDate) as PostingDate
FROM Superbill sb with (nolock)  --2016.02.18 dmg
JOIN SuperbillProcedure sbp  with (nolock) on sbp.superbilluid=sb.superbilluid --2016.02.18 dmg
JOIN AR_LedgerDetail ARD  with (nolock) on ARD.SuperbillProcedureUid=sbp.superbillprocedureUid --2016.02.18 dmg
JOIN AR_Ledger ARl  with (nolock) ON ARl.LedgerUid=ARD.LedgerUid --2016.02.18 dmg
Group by sb.superbillUid
),

CTE_Coinsurance
AS
(
Select 
A.Patient
,A.SuperbillUid
,A.ExternalID
,Max(ServiceDateStart) as ServiceDateStart
,Max(ServiceDateEnd) as ServiceDateEnd
,Max(AdjudicationDate) as AdjudicationDate
,Sum(Coinsurance) as Coinsurance
From(
select dbo.UDF_getFormattedPreferredName(sb.Patientuid) as Patient
,sb.SuperbillUid
,sb.ExternalID
,sb.ServiceDateStart
,sb.ServiceDateEnd
,sbp.DisplayOrder
,lp.Code
,ccd.AdjudicationDate
,grp.Code as [Group]
,rsn.Code as Reason
,sum( -cobl.Amount) as Coinsurance
From Superbill sb with (Nolock)
              inner join SuperbillProcedure sbp with (nolock) on sb.SuperbillUid = sbp.SuperbillUid
              inner join ListProcedure lp with (nolock) on sbp.ProcedureUid = lp.ProcedureUid
              inner join COBLineAdjustments cobl with (nolock) on sbp.SuperbillProcedureUid = cobl.SuperbillProcedureUid
			  inner join COBClaimDetail ccd with (nolock) on ccd.SuperbillUid=sbp.SuperbillUid --2016.02.18 dmg
              inner join ListERACode grp with (nolock) on cobl.GroupCodeERACodeUid = grp.ERACodeUid
			  inner join ListERACode rsn with (nolock) on cobl.ReasonCodeERACodeUid = rsn.ERACodeUid AND rsn.code=2
group by Sb.Patientuid,sb.SuperbillUid,sb.ExternalID, sb.ServiceDateStart,sb.ServiceDateEnd,sbp.DisplayOrder, lp.Code, grp.Code, rsn.Code,ccd.AdjudicationDate) A
Group by 
A.Patient
,A.SuperbillUid
,A.ExternalID
)
Select
CC.Patient
,CSE. PrimaryInsurance
,CSE.PrimaryMemberId
,CC.ExternalId as SuperbillID
,Case WHEN SecondaryInsurance Like ''%MC%''
Then ''X'' Else '''' End as Indigency
,Case WHEN SecondaryInsurance Like ''%MC%''
Then SecondaryMemberId Else '''' End as MCDID
,(CC.ServiceDateStart) as ServiceDateStart
,(CC.ServiceDateEnd) as ServiceDateEnd
,cpd.PostingDate
,CC.AdjudicationDate
,(CC.Coinsurance) as Coinsurance
,(CD.Deductible) as Deductible
,(CC.Coinsurance + CD.Deductible) as Total
from CTE_Coinsurance CC with (nolock) --2016.02.18 dmg
JOIN CTE_Deductible CD  with (nolock) ON CD.SuperbillUid=CC.SuperbillUid --2016.02.18 dmg
JOIN CTE_SuperbillInsuranceExtended CSE  with (nolock) ON CSE.SuperbillUid=CC.SuperbillUid --2016.02.18 dmg
JOIN CTE_PostingDate CPD  with (nolock) On cpd.superbilluid=cse.superbilluid --2016.02.18 dmg




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ChcViewFindSystemDefault]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ChcViewFindSystemDefault]
AS
SELECT     sd.SystemDefaultUid, sd.ExternalID, sd.Inactive, sd.Name, sd.Notes, sd.SFCorporationUid, sd.AllowInputOnNotFedQualified, sd.DefaultFirstSlidingFeeClass, 
                      sd.UserDefined, CASE WHEN (sd.SFCorporationUid IS NULL) THEN ''None '' ELSE c.Name END AS SFCarrierName, sd.LastModifiedDate, sd.LastModifiedByUid, 
                      dbo.UDF_getFormattedNameChc(p.Prefix, p.FirstName, p.MiddleName, p.LastName, p.Suffix) AS LastModifiedBy
FROM         dbo.ChcListSystemDefault AS sd LEFT OUTER JOIN
                      dbo.ViewPerson AS p ON sd.LastModifiedByUid = p.PersonUid LEFT OUTER JOIN
                      dbo.ViewCorporation AS c ON sd.SFCorporationUid = c.CorporationUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewVisitEducationForms]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewVisitEducationForms] AS
	SELECT	vef.VisitEduFormUid, v.VisitUid, v.PatientUid, 
			v.RenderingProviderUid, dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName, p.LastName, p.Suffix) AS RenderingProvider,
			COALESCE(vef.Name, ef.Name) AS Name,
			vef.Notes, vef.PrintedDate,
			vef.EduFormUid, vef.ReportUid, vef.Data, vef.DataContentType
	FROM	Visit v INNER JOIN ViewFindProvider p ON v.RenderingProviderUid = p.PersonUid
			INNER JOIN VisitEduForm vef ON v.VisitUid = vef.VisitUid
			LEFT JOIN ListEduForm ef ON vef.EduFormUid = ef.EduFormUid' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementLineItemExcludeZeroBalance]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewStatementLineItemExcludeZeroBalance]
AS
SELECT NEWID() AS [ItemUid]
      ,[RPUid]
      ,[FinancialCenterUid]
      ,[Type]
      ,[DisplayOrder]
      ,[PatientName]
      ,[RenderingProviderName]
      ,[AccountID]
      ,[SuperbillID]
      ,VS.[SuperbillUid]
      ,[SuperbillDate]
      ,CAST([ItemDate] AS DATE) as [ItemDate]
      ,[CreditGroupUid]
      ,[IsPayment]
      ,[CreditUid]
      ,[CreditSubOrder]
      ,[WhoPaid]
      ,[Description]
      ,[Charge]
      ,[Insurance]
      ,[Patient]
FROM ViewStatementLineItem (NOLOCK) VS
INNER JOIN AR_ViewSuperbillAggregate SBV WITH (NOLOCK) ON VS.superbilluid = SBV.superbilluid AND SBV.LiabilityBalance != 0
WHERE description is not null' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementLineItemExcludeZeroBalancebyFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewStatementLineItemExcludeZeroBalancebyFinancialCenter]
AS
SELECT NEWID() AS [ItemUid]
      ,[RPUid]
      ,VS.[FinancialCenterUid]
      ,[Type]
      ,[DisplayOrder]
      ,[PatientName]
      ,[RenderingProviderName]
      ,[AccountID]
      ,[SuperbillID]
      ,VS.[SuperbillUid]
      ,[SuperbillDate]
      ,CAST([ItemDate] AS DATE) as [ItemDate]
      ,[CreditGroupUid]
      ,[IsPayment]
      ,[CreditUid]
      ,[CreditSubOrder]
      ,[WhoPaid]
      ,[Description]
      ,[Charge]
      ,[Insurance]
      ,[Patient]
FROM ViewStatementLineItembyFinancialCenter VS
JOIN FinancialCenter (NOLOCK)  FC ON VS.FinancialCenterUid=FC.FinancialCenterUid 
INNER JOIN AR_ViewSuperbillAggregate SBV WITH (NOLOCK) ON VS.superbilluid = SBV.superbilluid AND SBV.LiabilityBalance != 0' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_DXAppointments]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[MDOL_RPT2_View_DXAppointments]
As

SELECT distinct
a.AppointmentUid,
lpc.PatientConditionUid,
--pdh.PatientProblemDiagnosisUid,
--pdh.PatientProblemUid,
a.PatientUid,
pt.ExternalID AS PatientID,
vp.FormattedInternalName,  
vp.Address1_Address1,vp.Address1_Address2,vp.Address1_City,vp.Address1_State,vp.Address1_Zip,
vp.PhoneNumber1,
vp.Birthdate,
a.StartDateTime AS StartDateTime, 
pdh.Code10,
pdh.Code9,

(SELECT MIN(dbo.udf_UTCToCurrentDate(StartDateTime)) 
			FROM Appointment AP
				INNER JOIN ListAppointmentStatus ApptStatus on ApptStatus.AppointmentStatusUid = AP.AppointmentStatusUid
			WHERE AP.AppointmentUID = a.AppointmentUID
				AND ApptStatus.IsCanceledStatus = 0 AND AP.StartDateTime > GETUTCDATE()) AS NextAppointment,

--stuff((SELECT Distinct '','' + Coalesce(ppdh.Code10,ppdh.Code9, '''')
--                     FROM PatientProblemDiagnosisHistory ppdh WITH (NOLOCK)
--					 inner join ListProblemStatus lps on ppdh.ProblemStatusUid = lps.ProblemStatusUid
--                     WHERE a.PatientUid = ppdh.PatientUid AND IsPatientProblem = 0 
--					 and lps.ActiveStatus = 1 and ppdh.InactiveDate is null and ppdh.IsDelete = 0
--                     FOR xml path('''')),1,1,'''') 
--                           AS DX,

stuff((SELECT distinct '','' + lpc.NAME 
				FROM RelPatientCondition rpc WITH (NOLOCK) 
				INNER JOIN ListPatientCondition LPC WITH (NOLOCK) ON lpc.PatientConditionUid = rpc.PatientConditionUid
				WHERE vp.PersonUid = rpc.PatientUid
				FOR xml path('''')),1,1,'''') 
				AS PatientCondition
From  Patient pt  
LEFT JOIN ViewPerson vp WITH (NOEXPAND) ON vp.personuid = pt.PersonUid
LEFT JOIN Appointment a ON pt.PersonUid = a.PatientUid
LEFT JOIN RelPatientCondition rpc WITH (NOLOCK) ON vp.PersonUid = rpc.PatientUid
LEFT JOIN ListPatientCondition LPC WITH (NOLOCK) ON lpc.PatientConditionUid = rpc.PatientConditionUid
LEFT JOIN PatientProblemDiagnosisHistory pdh WITH (NOLOCK) ON pt.PersonUid = pdh.PatientUid AND IsPatientProblem = 0
WHERE pdh.InactiveDate IS NOT NULL 


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementResponsiblePartyStringDatesbyFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'
-- 20170303 kculberth add Minimum Payment Due based on collections payment amount Bug 55967:Minimum Amount due does not display on Statements generated by Financial Center

CREATE VIEW [dbo].[ViewStatementResponsiblePartyStringDatesbyFinancialCenter]
AS
SELECT [RPUid]  
      ,[FinancialCenterUid]  
      ,[CustomerName]  
      ,[CustomerAddress1]  
      ,[CustomerAddress2]  
      ,[CustomerCity]  
      ,[CustomerState]  
      ,[CustomerZip]  
      ,[CustomerPhone]  
      ,[RemitToName]  
      ,[RemitToAddress1]  
      ,[RemitToAddress2]  
      ,[RemitToCity]  
      ,[RemitToState]  
      ,[RemitToZip]  
      ,[RPID]  
      ,[RPName]  
      ,[RPAddress1]  
      ,[RPAddress2]  
      ,[RPCity]  
      ,[RPState]  
      ,[RPZip]  
	  ,[RPEmail1]
	  ,[RPPhone1]
	  ,[RPLanguage]
      ,Convert(varchar(10), StatementDate, 120) as StatementDate  
	  ,MinimumPaymentDue
      ,Convert(varchar(10), DueDate, 120) as DueDate  
      ,Balance as [AmountDue]  
      ,[TotalBalance]  
      ,[InsuranceBalance]
	  ,DunningMsg
	  ,RTRIM(SUBSTRING((SELECT top 6 name + ''  '' AS ''data()'' 
						FROM listpaymenttype pt 
						WHERE InternalCardType IS NOT NULL AND Inactive=0 Order by Name
						FOR XML PATH('''')),1,80)) AS PaymentTypes
  FROM [ViewStatementResponsiblePartybyFinancialCenter]




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewDrugClass]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewDrugClass] AS
SELECT
   ClassId   = cls.classid,
   Class     = cls.Description,
   MedId     = dis.medid
FROM dbo.NDD_SearchDispensable dis
INNER JOIN dbo.NDD_RAHFSGC1_GCNSEQNO_LINK rel ON rel.IsDelete = 0 AND rel.GCN_SEQNO = dis.gcnseqno
INNER JOIN dbo.NDD_ViewClassificationAHFS cls ON cls.IsDelete = 0 AND cls.AHFS8 = rel.AHFS8
WHERE dis.IsDelete = 0
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_ResponsiblePartyList]'))
EXEC dbo.sp_executesql @statement = N'

-- 2016/02/01 - kculberth 	Task 45999 - Add or change send statement view to look at new responsible party ID "send statement" flag.

CREATE VIEW [dbo].[MDOL_RPT2_VIEW_ResponsiblePartyList] AS
SELECT 
	ARP.AccountResponsiblePartyUID AS AccountResponsiblePartyUID,
	(CASE WHEN ARP.PersonUID IS NOT NULL THEN P.FirstName ELSE ''-'' END) AS [First],
	(CASE WHEN ARP.PersonUID IS NOT NULL THEN P.LastName ELSE  CP.Name END) AS [Last],
	ARP.ExternalID AS ExternalID,
	CASE WHEN ARP.PersonUid IS NOT NULL THEN
		p.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
	ELSE
		cp.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
	END AS PrimaryAddress1,
		CASE WHEN ARP.PersonUid IS NOT NULL THEN
		p.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
	ELSE
		cp.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
	END AS PrimaryAddress2,
		CASE WHEN ARP.PersonUid IS NOT NULL THEN
		p.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)'')
	ELSE
		cp.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'')
	END AS City,  
		CASE WHEN ARP.PersonUid IS NOT NULL THEN
		p.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)'')
	ELSE
		cp.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'')
	END AS [State],  
	CASE WHEN ARP.PersonUid IS NOT NULL THEN
		p.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
	ELSE
		cp.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
	END AS ZIP,
	(CASE WHEN SUBSTRING(CASE WHEN arp.PersonUid IS NOT NULL THEN p.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') ELSE cp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') END,1,1)=''('' THEN  SUBSTRING(CASE WHEN arp.PersonUid IS NOT NULL THEN p.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') ELSE cp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') END,6,9) ELSE SUBSTRING(CASE WHEN arp.PersonUid IS NOT NULL THEN p.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') ELSE cp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') END,1,9) END) AS Phone1,  
	(CASE WHEN SUBSTRING(CASE WHEN arp.PersonUid IS NOT NULL THEN p.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') ELSE cp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') END,1,1)=''('' THEN  SUBSTRING(CASE WHEN arp.PersonUid IS NOT NULL THEN p.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') ELSE cp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') END,2,3) ELSE ''-'' END) AS AreaCode,
	ARP.Inactive AS InactiveResponsibleParties,
	ARP.PersonUID AS ResponsiblePartyIs_PersonUID,
	ARP.CorporationUID AS ResponsiblePartyIs_CorporationUID,
	Pt.ProviderUid,
	ARP. ExcludeFromAutomatedCollections,
	ss.SendStatement
FROM AccountResponsibleParty ARP with (NOLOCK)
INNER JOIN ViewAccountResponsiblePartySendStatement ss with (NOLOCK) on ss.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
LEFT JOIN Person P with (NOLOCK) ON ARP.PersonUID IS NOT NULL AND ARP.PersonUID = P.PersonUID
LEFT JOIN Corporation CP with (NOLOCK) ON ARP.CorporationUID IS NOT NULL AND CP.CorporationUID=ARP.CorporationUID 
INNER JOIN Account A with (NOLOCK) ON A.AccountResponsiblePartyUid=arp.AccountResponsiblePartyUid
INNER JOIN Patient Pt with (NOLOCK) ON Pt.PersonUid = A.PersonUid 



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ChcViewPatientHomelessHistory]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ChcViewPatientHomelessHistory]
AS
SELECT     TOP (100) PERCENT h.PatientHomelessHistoryUid, h.PatientUid, h.Homeless, h.HomelessEffectiveDate, h.HomelessStatusUid, 
                      hs.Name AS HomelessStatus, h.HomelessNote, h.LastModifiedDate, h.LastModifiedByUid, dbo.UDF_getFormattedNameChc(p.Prefix, p.FirstName, 
                      p.MiddleName, p.LastName, p.Suffix) AS LastModifiedBy
FROM         dbo.ChcPatientHomelessHistory AS h INNER JOIN
                      dbo.ChcListHomelessStatus AS hs ON h.HomelessStatusUid = hs.HomelessStatusUid LEFT OUTER JOIN
                      dbo.ViewPerson AS p ON h.LastModifiedByUid = p.PersonUid
ORDER BY h.HomelessEffectiveDate DESC, h.LastModifiedDate DESC


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewDocumentBatchPatient]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewDocumentBatchPatient]  
AS  
SELECT bp.[DocumentBatchPatientUid]  
	,bp.[DocumentBatchUid]  
	,bp.[PatientUid]  
	,bp.[FirstName] AS PatientFirstName  
	,bp.[LastName] AS PatientLastName  
	,per.FullName + ''  ( '' + p.ExternalID + '' )''AS PatientName  
	,per.Birthdate  
	,per.Deathdate  
	,p.ExternalID  
	,per1.GenderUid  
	,g.NAME AS GenderName  
	,g.ANSICode AS GenderANSICode  
	,g.ExternalID AS GenderExternalID  
	,dbo.GetPrimaryRaceUid(per1.PersonUid) as [RaceUid]  
	,lr.NAME AS RaceName  
	,lr.ANSICode AS RaceANSICode  
	,lr.ExternalID AS RaceExternalID  
	,dbo.GetPrimaryEthnicityUid (per1.PersonUid) as [EthnicityUid]  
	,le.NAME AS EthnicityName  
	,le.ANSICode AS EthnicityANSICode  
	,le.ExternalID AS EthnicityExternalID  
	,bp.[InsurancePlanUid] AS PayerUid  
	,c.NAME AS PayerName  
	,ic.ExternalID AS PayerID  
	,bp.[Zip]  
	,bp.[ReportDetailXml]  
	,bp.[PatientReportIntermediateXml]  
	,bp.[PatientReportXml]  
	,bp.[LastModifiedByUid]  
	,bp.[LastModifiedDate]  
	,bp.[Error]  
FROM DocumentBatchPatient bp WITH (NOLOCK)  
INNER JOIN ViewPerson per(NOEXPAND) ON bp.PatientUid = per.PersonUid  
INNER JOIN Patient p WITH (NOLOCK) ON bp.PatientUid = p.PersonUid  
INNER JOIN Person per1 WITH (NOLOCK) ON bp.PatientUid = per1.PersonUid  
LEFT JOIN ListGender g WITH (NOLOCK) ON per1.GenderUid = g.GenderUid  
LEFT JOIN ListRace lr WITH (NOLOCK) ON dbo.GetPrimaryRaceUid(per1.PersonUid) = lr.RaceUid  
LEFT JOIN ListEthnicity le WITH (NOLOCK) ON dbo.GetPrimaryEthnicityUid (per1.PersonUid) = le.EthnicityUid  
LEFT JOIN InsurancePlan ip WITH (NOLOCK) ON bp.InsurancePlanUid = ip.InsurancePlanUid  
LEFT JOIN InsuranceCarrier ic WITH (NOLOCK) ON ip.InsuranceCarrierUid = ic.CorporationUid  
LEFT JOIN Corporation c WITH (NOLOCK) ON ic.CorporationUid = c.CorporationUid  
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCppMedication]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewCppMedication] AS
	SELECT	mCpp.CppMedicationUid, CppUid, MedicationSIGUid,
			Name, FDB_HIC_SEQN, DisplayOrder, UserDefined,
			Isnull(dc.Class, ''unknown'') as Class,
			(SELECT TOP 1 FDB_MEDID FROM SIGDetail sd
				INNER JOIN MedicationSIG ms ON sd.MedicationSIGUid = ms.MedicationSIGUid
				WHERE ms.MedicationSIGUid = mCpp.MedicationSIGUid) AS FDB_MEDID
	FROM	CppMedication mCpp LEFT JOIN ViewDrugClass dc ON 
			(SELECT TOP 1 FDB_MEDID FROM SIGDetail sd
				INNER JOIN MedicationSIG ms ON sd.MedicationSIGUid = ms.MedicationSIGUid
				WHERE ms.MedicationSIGUid = mCpp.MedicationSIGUid AND ms.DiscontinueReasonUid is NULL) = dc.MedId


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPersonCorporation]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewPersonCorporation]   AS
	SELECT	p.PersonUid as ViewPrimaryKeyUid,
            ISNULL(arp.ExternalID, pat.ExternalID) as ExternalID,
            CAST(0 as bit) as Inactive,
			p.FullName AS [Name], p.FirstName, p.LastName,
			p.Birthdate,
			p.SocialSecurityNumber,
			p.Phone1, p.PhoneNumber1, p.PhoneType1, p.PhoneNumberScrubbed,
			p.Address1 AS [Address], p.Address1_Address1 AS Address1, p.Address1_Address2 AS Address2, 
			p.Address1_City AS City, p.Address1_State AS [State], p.Address1_Zip AS Zip,
			0 as ForeignKeyIndex,
			null as CorpNotes
	FROM	dbo.ViewPerson p (NOEXPAND) 
			LEFT JOIN dbo.Patient pat ON p.PersonUid = pat.PersonUid
			LEFT JOIN dbo.AccountResponsibleParty arp ON p.PersonUid = arp.PersonUid

	UNION ALL

	SELECT	c.CorporationUid as ViewPrimaryKeyUid,
            ISNULL(arp.ExternalID, c.ExternalID) as ExternalID,
            c.Inactive as Inactive, c.Name as [Name],
            null as FirstName, c.Name as LastName,
			NULL as Birthdate,
			NULL as SocialSecurityNumber,
            c.Phone1, 
            c.PhoneNumber AS PhoneNumber,
            c.PhoneType AS PhoneType,
			c.PhoneNumberScrubbed,
            c.[Address],
            c.Address1,
			c.Address2,
			c.City,
			c.[State],
			c.Zip,
			1 as ForeignKeyIndex,
			c.CorpNotes
FROM		dbo.ViewCorporation c LEFT JOIN dbo.AccountResponsibleParty arp ON c.CorporationUid = arp.CorporationUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewDocumentBatchPatientMeasure]'))
EXEC dbo.sp_executesql @statement = N'CREATE view [dbo].[ViewDocumentBatchPatientMeasure] as
select pm.DocumentBatchPatientMeasureUid,
            bp.DocumentBatchPatientUid,
            bp.DocumentBatchUid,
            bp.PatientUid,
            bp.PatientFirstName,
            bp.PatientLastName,
			bp.PatientName,
			bp.Birthdate,
			bp.Deathdate,
            bp.GenderUid,
            bp.GenderName,
            bp.GenderANSICode,
            bp.GenderExternalID,
            bp.RaceUid,
            bp.RaceName,
            bp.RaceANSICode,
            bp.RaceExternalID,
            bp.EthnicityUid,
            bp.EthnicityName,
            bp.EthnicityANSICode,
            bp.EthnicityExternalID,
            bp.PayerUid,
            bp.PayerName,
            bp.PayerID,
            bp.Zip,     
            pm.MeasureUid,
            pm.RuleNumber,
            pm.PopulationNumber,
            pm.StratumNumber,
            pm.InNumerator,
            pm.NumeratorNumber,
            pm.InDenominator,
            pm.InException,
            pm.InExclusion,
            pm.NumeratorMembershipXml,
            pm.PopulationMembershipXml,
            pm.StratumMembershipXml,
			bp.Error,
            Case when bp.Error IS not null then bp.error
                        when bp.PatientReportXml IS not null then ''Generated Successfully''
                        else ''Not Generated'' end as PatientReportStatus,
			bp.LastModifiedDate
from ViewDocumentBatchPatient bp
join DocumentBatchPatientMeasure pm on pm.DocumentBatchPatientUid = bp.DocumentBatchPatientUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewReport_BillingDetail]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewReport_BillingDetail] 
AS
SELECT
S.SuperbillUid,
PatientUid,
RenderingProviderUid,
ClaimingProviderUid,
S.ServiceSiteUid,
FinancialCenterUid,
PatientName,
RenderingProviderName,
ClaimingProviderName,
ServiceSiteName,
FinancialCenterName,
SP.ProcedureServiceDateStart ,
SP.ProcedureServiceDateEnd ,
SP.ProcedureCharge ,
SP.ProcedureAllowed ,
LP.Code,
LP.ShortDescription AS ProcedureDesc,
SPA.Liability,
SPA.AssignedLiability,
SPA.Distribution,
SPA.AssignedDistribution,
SPA.Adjustment,
SPA.AssignedAdjustment,
SPA.LiabilityBalance,
SPA.AssignedLiabilityBalance
FROM
	ViewSuperbill S
INNER JOIN
	SuperbillProcedure SP
ON
	S.SuperbillUid =SP.SuperbillUid	
INNER JOIN
	ListProcedure  LP
ON
	SP.ProcedureUid=LP.ProcedureUid
INNER JOIN
	AR_ViewSuperbillProcedureAggregate SPA
ON
	SP.SuperbillProcedureUid = SPA.SuperbillProcedureUid 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewFinancialCenterAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewFinancialCenterAggregateSub] WITH SCHEMABINDING  
AS  
SELECT FinancialCenterUid,         
		SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.AMOUNT ELSE 0 END) As Liability,         
		SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT ELSE 0 END) As AssignedLiability,       
		SUM(CASE WHEN L.EntryType = 2  THEN LD.AMOUNT*-1 ELSE 0 END) As Distribution,        
		SUM(CASE WHEN L.EntryType = 2 AND NOT LD.InsurancePlanUid IS NULL  THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedDistribution,        
		SUM(CASE WHEN L.EntryType = 3 THEN LD.AMOUNT*-1 ELSE 0 END) As Adjustment,        
		SUM(CASE WHEN L.EntryType = 3 AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedAdjustment,        
		SUM(LD.Amount) As LiabilityBalance, SUM(CASE WHEN NOT LD.InsurancePlanUid IS NULL THEN LD.Amount ELSE 0 END) As AssignedLiabilityBalance,        
		COUNT_BIG(*) AS Count  
	FROM dbo.AR_LedgerDetail LD        
		INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
	WHERE NOT FinancialCenterUid IS NULL AND NOT SuperbillProcedureUid IS NULL   
	GROUP BY FinancialCenterUid      

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewFinancialCenterAggregateSub_FinancialCenterUid ON AR_ViewFinancialCenterAggregateSub(FinancialCenterUid)

*/

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewFinancialCenterAggregateSub]') AND name = N'PK_AR_ViewFinancialCenterAggregateSub_FinancialCenterUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewFinancialCenterAggregateSub_FinancialCenterUid] ON [dbo].[AR_ViewFinancialCenterAggregateSub]
(
	[FinancialCenterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewFinancialCenterAggregate]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewFinancialCenterAggregate] 
AS
SELECT FIN.FinancialCenterUid, 
	ISNULL(VFINAB.Liability, 0) AS Liability, 
	CAST(ISNULL(VFINAB.AssignedLiability, 0) AS MONEY) AS AssignedLiability,
	ISNULL(VFINAB.LiabilityBalance, 0) AS LiabilityBalance, 
	CAST(ISNULL(VFINAB.AssignedLiabilityBalance, 0) AS MONEY) AS AssignedLiabilityBalance
FROM FinancialCenter FIN
LEFT JOIN AR_ViewFinancialCenterAggregateSub (NOEXPAND) VFINAB ON FIN.FinancialCenterUid = VFINAB.FinancialCenterUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewHospitalRound]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewHospitalRound] AS
SELECT   
 hr.HospitalRoundUid,  
 hr.Inactive,    
 hr.ServiceSiteUid,  
 ss.Name AS ServiceSiteName,     
 hr.PatientUid,  
 pat.FormattedPreferredName AS PatientName,    
 hr.Location,  
 hr.AdmitDate,  
 hr.DischargeDate,   
 hr.Notes,    
 hr.ExternalTypeUid,  
 m.Name AS ExternalType,    
 dbo.GetHospitalRoundUids(hr.HospitalRoundUid, 1) AS ProviderUids,  
 dbo.GetHospitalRoundNames(hr.HospitalRoundUid, 1) AS ProviderNames,    
 dbo.GetHospitalRoundUids(hr.HospitalRoundUid, 0) AS DiagnosisUids,   
 dbo.GetHospitalRoundNames(hr.HospitalRoundUid, 0) AS DiagnosisNames    
FROM  
 HospitalRound(NOLOCK)  hr    
INNER JOIN   
 ListServiceSite(NOLOCK) ss   
ON   
 hr.ServiceSiteUid = ss.ServiceSiteUid    
INNER JOIN   
 ViewPerson pat   
ON   
 hr.PatientUid = pat.PersonUid    
LEFT JOIN   
 ListMisc(NOLOCK) m ON hr.ExternalTypeUid = m.MiscUid 
 

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewResultTracking_ObservationOrder]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewResultTracking_ObservationOrder] AS
-- Observation Orders
SELECT
   PK                               = obo.ObservationOrderUid,
   ResultUid                        = obo.ObservationOrderUid,
   PatientUid                       = obo.PatientUid,
   DisplayTypeID                    = CASE
                                         WHEN obo.AttachmentTypeUid IS NOT NULL THEN ISNULL(lat.DisplayTypeID, 1)
                                         ELSE ISNULL(loa.DisplayTypeID, 1)
                                      END,
   RPNResultTypeID                  = 1,
   RPNResultUid                     = obo.ObservationOrderUid,
   AttachmentTypeUid                = ISNULL(obo.AttachmentTypeUid, llo.AttachmentTypeUid),
   AttachmentType                   = CASE
                                         WHEN obo.AttachmentTypeUid IS NOT NULL THEN lat.Name
                                         ELSE loa.Name
                                      END,
   HasAttachmentType                = CAST(CASE WHEN ISNULL(lat.AttachmentTypeUid, loa.AttachmentTypeUid) IS NULL THEN 0 ELSE 1 END AS BIT),
   AbnormalFlagCode                 = CAST(obo.AbnormalFlagCode AS VARCHAR(2)),
   ResultStatusID                   = obo.ResultStatusID,
   Status                           = sts.Name,
   OrderDate                        = obo.OrderDate,
   OrderDateTime                    = obo.OrderDateTime,
   DueDate                          = obo.DueDate,
   ResultDate                       = obo.ResultDate,
   ResultDateTime                   = obo.ResultDateTime,
   ProviderUid                      = obo.OrderProviderUid,
   ApproveDate                      = obo.ApproveDate,
   ApproveProviderUid               = obo.ApproveProviderUid,
   ObservationUid                   = obo.ObservationUid,
   Template                         = obs.Name,
   VisitUid                         = ISNULL(obo.VisitUid, rag.VisitUid),
   CPT                              = ISNULL(prc.Code, ''''),
   LaboratoryUid                    = lab.LaboratoryUid,
   LaboratoryName                   = ISNULL(lab.Name, ''''),
   OrderType                        = CASE
                                         WHEN vpr.IsPerformed IS NULL THEN ''''
                                         WHEN vpr.IsPerformed = 1 THEN ''SP''
                                         ELSE ''SO''
                                      END,
   Description                      = COALESCE(prc.ShortDescription, atg.Name, ''''),
   PhaseName                        = ctp.Name,
   PatientCaseUid                   = obo.PatientCaseUid,
   Technician                       = obo.Technician,
   ExtractDate                      = obo.ExtractDate,
   ExtractDateTime                  = obo.ExtractDateTime,
   ReceiveDate                      = obo.ReceiveDate,
   ReceiveDateTime                  = obo.ReceiveDateTime,
   PerformDate                      = obo.PerformDate,
   PerformDateTime                  = obo.PerformDateTime,
   Notes                            = obo.Notes,
   LOINCUid                         = obs.LOINCUid,
   VisitProcedureUid                = obo.VisitProcedureUid,
   PSC                              = CAST(obo.PSC AS INT),
   EstimatedDueDate                 = obo.DueDate,
   Result                           = CASE obo.AbnormalFlagCode
                                         WHEN ''C''  THEN ''Critical''
                                         WHEN ''AL'' THEN ''Alert''
                                         WHEN ''AB'' THEN ''Abnormal''
                                         WHEN ''N''  THEN ''Normal''
                                         ELSE ''''
                                      END,
   LaboratoryOrderUid               = obo.LaboratoryOrderUid,
   RelAttachmentGroupUid            = rag.RelAttachmentGroupUid,
   ResultingVisitUid                = obo.ResultingVisitUid,
   ReferredByProviderUid            = vis.ReferredByProviderUid,
 ServiceSiteUid                   = vis.ServiceSiteUid,
   ImedicaAccessionNumber           = obo.ImedicaAccessionNumber,
   LabAccessionNumber               = obo.LabAccessionNumber,
   ObservationOrderResultStatusUid  = obo.ObservationOrderResultStatusUid,
   MessageUrgencyUid                = obo.MessageUrgencyUid,
   VisitDate                        = vis.VisitDate,
   VisitProcedureName               = vpr.Name,
   IsDelete                         = CASE
                                         WHEN vis.VisitTypeUid = ''FB954167-9D1C-43B7-9F5B-A76260654C96'' THEN CAST (1 AS INT)
                                         ELSE obo.IsDelete
                                      END
FROM ObservationOrder obo
LEFT JOIN ListLaboratoryOrder llo ON llo.LaboratoryOrderUid = obo.LaboratoryOrderUid
LEFT JOIN ListAttachmentType loa ON loa.AttachmentTypeUid = llo.AttachmentTypeUid
LEFT JOIN ListObservation obs ON obs.ObservationUid = obo.ObservationUid
LEFT JOIN ListAttachmentType lat ON lat.AttachmentTypeUid = obo.AttachmentTypeUid
LEFT JOIN ListCaseTypePhase ctp ON ctp.CaseTypePhaseUid = obo.CaseTypePhaseUid
LEFT JOIN ListObservationOrderResultStatus sts ON sts.ObservationOrderResultStatusUid = obo.ObservationOrderResultStatusUid
LEFT JOIN VisitProcedure vpr ON vpr.VisitProcedureUid = obo.VisitProcedureUid
LEFT JOIN ListProcedure prc ON prc.ProcedureUid = vpr.ProcedureUid
OUTER APPLY (
   SELECT TOP 1 *
   FROM RelAttachmentGroup
   WHERE RelAttachmentGroup.ObservationOrderUid = obo.ObservationOrderUid
   ORDER BY LastModifiedDate) AS rag
LEFT JOIN ListLaboratory lab ON lab.LaboratoryUid = obo.LaboratoryUid
LEFT JOIN Visit vis ON vis.VisitUid = obo.VisitUid
LEFT JOIN AttachmentGroup atg ON atg.AttachmentGroupUid = rag.AttachmentGroupUid
WHERE obo.Inactive = 0
  --AND ISNULL(vis.VisitTypeUid, ''00000000-0000-0000-0000-000000000000'') != ''FB954167-9D1C-43B7-9F5B-A76260654C96''
  AND obo.ResultStatusID != 0
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewResultTracking_RelAttachmentGroup]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewResultTracking_RelAttachmentGroup] AS
SELECT
   -- Attachments
   PK                               = rag.RelAttachmentGroupUid,
   ResultUid                        = rag.RelAttachmentGroupUid,
   PatientUid                       = rag.PersonUid,
   DisplayTypeID                    = ISNULL(lat.DisplayTypeID, 1),
   RPNResultTypeID                  = CASE WHEN vis.VisitUid IS NOT NULL THEN 2 ELSE 3 END,
   RPNResultUid                     = rag.RelAttachmentGroupUid,
   AttachmentTypeUid                = atg.AttachmentTypeUid,
   AttachmentType                   = lat.Name,
   HasAttachmentType                = CAST(CASE WHEN lat.AttachmentTypeUid IS NULL THEN 0 ELSE 1 END AS BIT),
   AbnormalFlagCode                 = CAST('''' AS VARCHAR(2)),
   ResultStatusID                   = CAST(ISNULL(att.ResultStatusID, 9) AS SMALLINT),
   Status                           = CASE WHEN att.ResultStatusID = 7
                                         THEN (SELECT Name FROM ListObservationOrderResultStatus WHERE ObservationOrderResultStatusUid = ''E4861953-D5F3-4D86-BE78-530B394AE39E'')  -- 7
                                         ELSE (SELECT Name FROM ListObservationOrderResultStatus WHERE ObservationOrderResultStatusUid = ''53BDC86C-2839-4066-9821-C20C214967B1'')  -- 9
                                       END,
   OrderDate                        = CAST(NULL AS DATE),
   OrderDateTime                    = CAST(NULL AS DATETIME),
   DueDate                          = CAST(NULL AS DATE),
   ResultDate                       = CAST(ISNULL(att.FileDate, atg.LastModifiedDate) AS DATE),
   ResultDateTime                   = CAST(CAST(ISNULL(att.FileDate, atg.LastModifiedDate) AS DATE) AS DATETIME),
   ProviderUid                      = CAST(NULL AS UNIQUEIDENTIFIER),
   ApproveDate                      = CAST(NULL AS DATE),
   ApproveProviderUid               = CAST(NULL AS UNIQUEIDENTIFIER),
   ObservationUid                   = CAST(NULL AS UNIQUEIDENTIFIER),
   Template                         = CAST('''' AS VARCHAR(100)),
   VisitUid                         = rag.VisitUid,
   CPT                              = CAST('''' AS VARCHAR(30)),
   LaboratoryUid                    = CAST(NULL AS UNIQUEIDENTIFIER),
   LaboratoryName                   = CAST('''' AS VARCHAR(100)),
   OrderType                        = CAST('''' AS VARCHAR(2)),
   Description                      = atg.Name,
   PhaseName                        = CAST('''' AS VARCHAR(50)),
   PatientCaseUid                   = vis.PatientCaseUid,
   Technician                       = CAST(NULL AS VARCHAR(100)),
   ExtractDate                      = CAST(NULL AS DATE),
   ExtractDateTime                  = CAST(NULL AS DATETIME),
   ReceiveDate                      = CAST(NULL AS DATE),
   ReceiveDateTime                  = CAST(NULL AS DATETIME),
   PerformDate                      = CAST(NULL AS DATE),
   PerformDateTime                  = CAST(NULL AS DATETIME),
   Notes                            = CAST(NULL AS VARCHAR(MAX)),
   LOINCUid                         = CAST(NULL AS UNIQUEIDENTIFIER),
   VisitProcedureUid                = CAST(NULL AS UNIQUEIDENTIFIER),
   PSC                              = 0,
   EstimatedDueDate                   = CAST(ISNULL(att.FileDate, atg.LastModifiedDate) AS DATE),
   Result                           = CAST('''' AS VARCHAR(8)),
   LaboratoryOrderUid               = CAST(NULL AS UNIQUEIDENTIFIER),
   RelAttachmentGroupUid            = rag.RelAttachmentGroupUid,
   ResultingVisitUid                = CAST(NULL AS UNIQUEIDENTIFIER),
   ReferredByProviderUid            = vis.ReferredByProviderUid,
   ServiceSiteUid                   = vis.ServiceSiteUid,
   ImedicaAccessionNumber           = CAST(NULL AS VARCHAR(25)),
   LabAccessionNumber               = CAST(NULL AS VARCHAR(25)),
   ObservationOrderResultStatusUid  = CAST(CASE WHEN att.ResultStatusID = 7
            THEN ''E4861953-D5F3-4D86-BE78-530B394AE39E''  -- 7
                                             ELSE ''53BDC86C-2839-4066-9821-C20C214967B1''  -- 9
                                           END AS UNIQUEIDENTIFIER),
   MessageUrgencyUid                = CAST(''C2A64D38-3BE1-4F8A-8947-EF9E9AD861A4'' AS UNIQUEIDENTIFIER), -- Default is Routine
   VisitDate                        = vis.VisitDate,
   VisitProcedureName               = CAST(NULL AS VARCHAR(255)),
   IsDelete                         = CASE 
                                         WHEN vis.VisitTypeUid = ''FB954167-9D1C-43B7-9F5B-A76260654C96'' THEN CAST(1 AS INT) 
                                         ELSE 0
                                      END
FROM RelAttachmentGroup rag
INNER JOIN AttachmentGroup atg ON atg.AttachmentGroupUid = rag.AttachmentGroupUid
INNER JOIN ListAttachmentType lat ON lat.AttachmentTypeUid = atg.AttachmentTypeUid AND lat.DisplayTypeID = 1  -- Result type attachment
LEFT JOIN Visit vis ON vis.VisitUid = rag.VisitUid
OUTER APPLY (
   SELECT
       FileDate       = MIN(tab.FileDate),
       ResultStatusID = MIN(CASE WHEN ata.ApprovedByUserPRMUid IS NULL THEN 7 ELSE 9 END)
   FROM Attachment tab
   LEFT JOIN AttachmentApproval ata ON tab.AttachmentUid = ata.AttachmentUid
   WHERE tab.AttachmentGroupUid = rag.AttachmentGroupUid) AS att
WHERE rag.ObservationOrderUid IS NULL
  --AND ISNULL(vis.VisitTypeUid, ''00000000-0000-0000-0000-000000000000'') != ''FB954167-9D1C-43B7-9F5B-A76260654C96''
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewResultTracking]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewResultTracking] AS
SELECT
   PK                               = vrt.PK,
   ResultUid                        = vrt.ResultUid,
   PatientUid                       = vrt.PatientUid,
   PatientName                      = pat.FirstName + '' '' + pat.LastName,
   DisplayTypeID                    = vrt.DisplayTypeID,
   RPNResultTypeID                  = vrt.RPNResultTypeID,
   RPNResultUid                     = vrt.RPNResultUid,
   AttachmentTypeUid                = vrt.AttachmentTypeUid,
   AttachmentType                   = vrt.AttachmentType,
   HasAttachmentType                = vrt.HasAttachmentType,
   UrgentTypeID                     = urg.UrgentTypeID,
   Urgent                           = CASE ISNULL(urg.UrgentTypeID, 0) WHEN 1 THEN ''!'' ELSE '''' END,
   AbnormalFlagCode                 = vrt.AbnormalFlagCode,
   ResultStatusID                   = vrt.ResultStatusID,
   Status                           = vrt.Status,
   OrderDate                        = vrt.OrderDate,
   OrderDateTime                    = vrt.OrderDateTime,
   DueDate                          = vrt.DueDate,
   ResultDate                       = vrt.ResultDate,
   ResultDateTime                   = vrt.ResultDateTime,
   ProviderUid                      = vrt.ProviderUid,
   ProviderName                     = dbo.UDF_getFormattedInternalName(prv.FirstName, prv.MiddleName, prv.LastName, prv.AkaFirstName, prv.AkaLastName),
   ApproveDate                      = vrt.ApproveDate,
   ApproveProviderUid               = vrt.ApproveProviderUid,
   ApproveProviderName              = dbo.UDF_getFormattedInternalName(app.FirstName, app.MiddleName, app.LastName, app.AkaFirstName, app.AkaLastName),
   ObservationUid                   = vrt.ObservationUid,
   Template                         = vrt.Template,
   VisitUid                         = vrt.VisitUid,
   CPT                              = vrt.CPT,
   LaboratoryUid                    = vrt.LaboratoryUid,
   LaboratoryName                   = vrt.LaboratoryName,
   OrderType                        = vrt.OrderType,
   Description                      = vrt.Description,
   PhaseName                        = vrt.PhaseName,
   PatientCaseUid                   = vrt.PatientCaseUid,
   Technician                       = vrt.Technician,
   ExtractDate                      = vrt.ExtractDate,
   ExtractDateTime                  = vrt.ExtractDateTime,
   ReceiveDate                      = vrt.ReceiveDate,
   ReceiveDateTime                  = vrt.ReceiveDateTime,
   PerformDate                      = vrt.PerformDate,
   PerformDateTime                  = vrt.PerformDateTime,
   Notes                            = vrt.Notes,
   LOINCUid                         = vrt.LOINCUid,
   VisitProcedureUid                = vrt.VisitProcedureUid,
   PSC                              = vrt.PSC,
   EstimatedDueDate                 = vrt.EstimatedDueDate,
   Result                           = vrt.Result,
   LaboratoryOrderUid               = vrt.LaboratoryOrderUid,
   RelAttachmentGroupUid            = vrt.RelAttachmentGroupUid,
   ResultingVisitUid                = vrt.ResultingVisitUid,
   ReferredByProviderUid            = vrt.ReferredByProviderUid,
   ReferredByProviderName           = ISNULL(dbo.UDF_getFormattedInternalName(ref.FirstName, ref.MiddleName, ref.LastName, ref.AkaFirstName, ref.AkaLastName), ''''),
   ServiceSiteUid                   = vrt.ServiceSiteUid,
   ServiceSiteName                  = lss.Name,
   PatientAddress                   = pat.Address1,
   PatientAddress1                  = pat.[Address1].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),
   PatientAddress2                  = pat.[Address1].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),
   PatientCity                      = pat.[Address1].value(''(/Address/City)[1]'', ''VARCHAR(100)''),
   PatientState                     = pat.[Address1].value(''(/Address/State)[1]'', ''VARCHAR(100)''),
PatientZip                       = pat.[Address1].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),
   ImedicaAccessionNumber           = vrt.ImedicaAccessionNumber,
   LabAccessionNumber               = vrt.LabAccessionNumber,
   ObservationOrderResultStatusUid  = vrt.ObservationOrderResultStatusUid,
   MessageUrgencyUid                = vrt.MessageUrgencyUid,
   VisitDate                        = vrt.VisitDate,
   VisitProcedureName               = vrt.VisitProcedureName,
   UrgencyName                      = urg.Name,
   UrgencyDisplayOrder              = urg.DisplayOrder,
   IsDelete                         = vrt.IsDelete
FROM (
   SELECT * FROM ViewResultTracking_ObservationOrder
   UNION ALL
   SELECT * FROM ViewResultTracking_RelAttachmentGroup) vrt
LEFT JOIN Person pat ON pat.PersonUid = vrt.PatientUid
LEFT JOIN Person prv ON prv.PersonUid = vrt.ProviderUid
LEFT JOIN Person app ON app.PersonUid = vrt.ApproveProviderUid
LEFT JOIN Person ref ON ref.PersonUid = vrt.ReferredByProviderUid
LEFT JOIN ListServiceSite lss ON lss.ServiceSiteUid = vrt.ServiceSiteUid
LEFT JOIN ListMessageUrgency urg ON urg.MessageUrgencyUid = vrt.MessageUrgencyUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewReport_Superbill]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewReport_Superbill] 
AS
	
SELECT    
S.SuperbillUid,
S.ExternalID,
PatientUid,
RenderingProviderUid,
ClaimingProviderUid,
SuperbillStatusUid,
ServiceDateStart,
ServiceDateEnd,
TotalCharge,
FirstFiledDate,
LastFiledDate,
ServiceSiteUid,
PatientName,
RenderingProviderName,
ClaimingProviderName,
SuperbillStatusName,
ServiceSiteName,
AccountUid,
VisitUid,
VisitDate,
ClaimPaper,
LastModifiedByUid,
IsPosted,
FinancialCenterUid,
FinancialCenterName,
InsuranceOrder,
CodeValidationErrors,
MaxPostingDate,
MinPostingDate,
ABN,
SA.Liability,
SA.AssignedLiability,
SA.Distribution,
SA.AssignedDistribution,
SA.Adjustment,
SA.AssignedAdjustment,
SA.LiabilityBalance,
SA.ZeroLiabilityBalanceNotDistributed,
SA.AssignedLiabilityBalance
FROM
	ViewSuperBill S
INNER JOIN
	AR_ViewSuperbillAggregate SA
ON
	S.SuperbillUid =SA.SuperbillUid 



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewRPNResult]'))
EXEC dbo.sp_executesql @statement = N'






CREATE VIEW [dbo].[ViewRPNResult]
AS
-- den 9/18/2015 I am removing the RPNResultTypeID == 2 filter--something changed in ViewResultTracking
-- I am adding the filter to remove RPNResultTypeID == 2 rows, since these are always represented in type 3 rows.  den 3/30/2007
-- den 8/15/08  issue 10780--want to see last , first format names in display
-- den 1/13/11  issue 6907--tweak which RPNResultTypeID and DisplayTypeID is shown
SELECT     PK, PatientUid, DisplayTypeID, RPNResultTypeID, RPNResultUid, AttachmentTypeUid, AttachmentType, 
           HasAttachmentType, Urgent, [Status], 
           OrderDate, ResultDate, ProviderUid, 
           CASE WHEN ProviderUid IS NULL THEN '' '' ELSE per.LastName + '', '' + per.FirstName END  AS ProviderName, 
           Template, CPT, OrderType, Description
FROM       dbo.ViewResultTracking LEFT JOIN Person per ON per.PersonUid = ProviderUid
WHERE       ((ResultStatusID = 7) OR (ResultStatusID = 8) OR (ResultStatusID = 9)) 
            AND ((RPNResultTypeID <> 3) OR (RPNResultTypeID = 3 AND DisplayTypeID <> 0))
                       










' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPharmacy]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewPharmacy] AS
SELECT	
   PharmacyUid               = lp.PharmacyUid, 
   Name                      = lp.Name, 
		mp.PharmacyClearinghouseUid, 
		mp.PharmacyClearinghouseName, 
		lp.[Address],
		lp.Computed_Address1_Address1 AS Address1,
		lp.Computed_Address1_Address2 AS Address2,
		lp.Computed_Address1_City AS City,
		lp.Computed_Address1_State AS [State],
		lp.Computed_Address1_Zip AS Zip,
		lp.Computed_Address1_Country AS Country,
		lp.[Computed_Address1_StreetAddress] AS StreetAddress,
		lp.Phone1,
		lp.Computed_Phone1_PhoneNumber AS PhoneNumber1,
		lp.Computed_Phone1_PhoneType AS PhoneTypeName1,		
		lp.Computed_Phone1_Scrubbed  AS PhoneNumberScrubbed, 
		lp.Inactive, 
		lp.Phone2,
		lp.Computed_Phone2_PhoneNumber AS PhoneNumber2,
		lp.Computed_Phone2_PhoneType AS PhoneTypeName2,		
		lp.Phone3,
		lp.Computed_Phone3_PhoneNumber AS PhoneNumber3,
		lp.Computed_Phone3_PhoneType AS PhoneTypeName3,		
		mp.PartnerAccount, 
		mp.IsFaxOnly,
		mp.CrossStreet,
		mp.ServiceLevelCode,
		mp.MailOrderEnabled,
		mp.SpecialtyIDCode
FROM  dbo.ListPharmacy AS lp 
	LEFT OUTER JOIN dbo.ViewMasterPharmacy AS mp ON mp.MasterPharmacyUid = lp.MasterPharmacyUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindVisit]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewFindVisit]
AS
SELECT      v.VisitUid, v.AppointmentUid, v.IsCompleted, v.VisitDate, 
			v.PatientUid, p.FormattedPreferredName AS PatientName,
			CASE WHEN v.IsCompleted = 1 THEN ''Complete'' ELSE ''Incomplete'' END AS VisitStatus, v.LastModifiedByUid, 
			v.ProviderUid, prov.FormattedInternalName AS ProviderName,
			v.RenderingProviderUid, rprov.FormattedInternalName AS RenderingProviderName,
			v.SupervisingProviderUid, sprov.FormattedInternalName AS SupervisingProviderName,
            v.PatientCaseUid,
            v.VisitTypeUid, ISNULL(vt.ExternalID, '''') AS VisitTypeName,
            v.ClinicalNoteTypeUid, ct.Name AS ClinicalNoteType,
			v.ServiceSiteUid, ss.[Name] AS ServiceSite,
			v.FinancialCenterUid, fc.[Name] AS FinancialCenter
FROM		Visit v LEFT JOIN ViewPerson p ON v.PatientUid = p.PersonUid
            LEFT JOIN ListVisitType vt ON v.VisitTypeUid = vt.VisitTypeUid
            LEFT JOIN ListClinicalNoteType ct ON v.ClinicalNoteTypeUid = ct.ClinicalNoteTypeUid
			LEFT JOIN ViewFindProvider rprov ON v.RenderingProviderUid = rprov.PersonUid
			INNER JOIN ViewFindProvider prov ON v.ProviderUid = prov.PersonUid
			LEFT JOIN ViewFindProvider sprov ON v.SupervisingProviderUid = sprov.PersonUid
			LEFT JOIN ListServiceSite ss ON v.ServiceSiteUid = ss.ServiceSiteUid
			LEFT JOIN FinancialCenter fc ON v.FinancialCenterUid = fc.FinancialCenterUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ChcViewSFInsuranceCarrier]'))
EXEC dbo.sp_executesql @statement = N'/**** NOTE *****
FormularyOrgUid in the 2009 database existed in the folowing tables and views:
InsuranceCarrier
ViewFormularyOrg
ViewInsuranceCarrier
Account
InsurancePlan
PatienteRxEligibility
ViewAccountFormulary
ViewPayerPlan
ViewPersonInsurancePlan

In the 2011 database it only exists in the following tables and views:
ViewFormularyOrg
ViewAccountFormulary
PatienteRxEligibility

FormularyOrgUid was NULL in the 2009 database so I''m setting it to NULL in the current view until resolved
*/

CREATE VIEW [dbo].[ChcViewSFInsuranceCarrier]
AS
SELECT    ic.CorporationUid, 
  ic.Inactive | ic.Inactive AS Inactive, 
  ic.Name, 
  ic.Address1, 
  ic.City, 
  ic.State, 
  ic.Zip, 
  ic.PhoneNumber AS PhoneNumber1, 
  REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(ic.PhoneNumber, ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', '''') AS PhoneNumber1Scrubbed, 
  CONVERT(uniqueidentifier, null) as FormularyOrgUid
FROM         dbo.ViewInsuranceCarrier AS ic 
WHERE ic.CorporationUid IN (
SELECT ViewInsurancePlan.InsuranceCarrierUid AS CorporationUid
FROM ChcInsurancePlan INNER JOIN
     ViewInsurancePlan ON ChcInsurancePlan.InsurancePlanUid = ViewInsurancePlan.InsurancePlanUid
WHERE (ChcInsurancePlan.SFCarrier = 1)
)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessageFilter]'))
EXEC dbo.sp_executesql @statement = N'



--
-- Fix for bug #32630
--
-- Fix bug #51341
--
CREATE VIEW [dbo].[ViewMessageFilter] AS
SELECT
   MessageUid                 = msg.MessageUid,
   CreatedByUid               = msg.CreatedByUid,
   CreatedBy                  = crb.FullName,
   PatientUid                 = msg.PersonUid,
   Patient                    = per.FormattedPreferredName,
   MessageTypeUid             = msg.MessageTypeUid,
   MessageType                = typ.Name,
   MessageSubTypeUid          = msg.MessageSubTypeUid,
   MessageSubType             = mst.Name,
   Header                     = msg.Header,
   MessageUrgencyUid          = msg.MessageUrgencyUid,
   MessageUrgency             = urg.Name,
   MessageUrgencyColor        = urg.Color,
   MessageUrgencyDisplayOrder = urg.DisplayOrder,
   MessageStatusUid           = msg.MessageStatusUid,
   MessageStatus              = sts.Name,
   CreatedDate                = msg.CreatedDate,
   CreatedDateTime            = msg.CreatedDateTime,
   LastModifiedDate           = msg.LastModifiedDate,
   DateToBeCompleted          = msg.DateToBeCompleted,
   DateCompleted              = msg.DateCompleted,
   ResponseTime				  = CONVERT(decimal(14,3), DATEDIFF(SECOND, COALESCE(msg.CreatedDateTime, msg.CreatedDate), msg.DateCompleted) / 3600.0),
   LastReadByUid              = msg.LastReadByUid,
   LastReadBy                 = lrb.FullName,
   CompletedByUid             = msg.CompletedByUid,
   CompletedBy                = cby.FullName,
   AssignedTo                 = dbo.GetMessageAssignedTo(msg.MessageUid),
   AutoComplete               = msg.AutoComplete,
   PhoneNumber				  = ISNULL(mtc.Computed_Phone_PhoneNumber, mrx.Computed_Phone_PhoneNumber),
   MedicalRecordNumber        = pat.MedicalRecordNumber,
   Birthdate                  = per.Birthdate,
   IsCompleted                = CAST(CASE WHEN msg.CompletedByUid IS NULL THEN 0 ELSE 1 END AS BIT),
   AppointmentStatusUid       = apt.AppointmentStatusUid,
   AttachmentTypeUid          = ag.AttachmentTypeUid,
   AppointmentStartDateTime   = apt.StartDateTime,
   ApproveDate                = CAST(COALESCE(lax.ApproveDate, lab.ApproveDate, dbo.ConvertUTCToLocalTime(mvb.ApproveDate)) AS DATE),
   ResultDate                 = ISNULL(lax.ResultDate, lab.ResultDate),
   Result                     = ISNULL(lax.Result, lab.Result),
   HMRuleUid                  = hmr.HMRuleUid,
   PatientHMRuleUid           = hmr.PatientHMRuleUid,
   InactivePatientHMRule      = hmr.Inactive,
   StrikeOut                  = msg.StrikeOut,
   LockUid                    = mli.LockUid,
   LockedByUserName           = pns.FullName,
   LockedByHostName           = mli.HostName,
   LockedDate                 = mli.LockDate,
   LockedDateStart            = mli.LockDateStart,
   MessageNote				  = (SELECT TOP 1 [Note] FROM MessageNote mn WITH (NOLOCK) WHERE mn.MessageUid = msg.MessageUid ORDER BY mn.LastModifiedDate DESC)
FROM dbo.Message                        AS msg WITH (NOLOCK)
LEFT OUTER JOIN dbo.ViewPerson              AS crb WITH (NOLOCK, NOEXPAND) ON msg.CreatedByUid = crb.PersonUid
LEFT OUTER JOIN dbo.ViewPerson              AS lrb WITH (NOLOCK, NOEXPAND) ON msg.LastReadByUid = lrb.PersonUid
LEFT OUTER JOIN dbo.ViewPerson              AS cby WITH (NOLOCK, NOEXPAND) ON msg.CompletedByUid = cby.PersonUid
LEFT OUTER JOIN dbo.ListMessageType     AS typ WITH (NOLOCK) ON msg.MessageTypeUid = typ.MessageTypeUid
LEFT OUTER JOIN dbo.ListMessageSubType  AS mst WITH (NOLOCK) ON msg.MessageSubTypeUid = mst.MessageSubTypeUid
LEFT OUTER JOIN dbo.ListMessageStatus   AS sts WITH (NOLOCK) ON msg.MessageStatusUid = sts.MessageStatusUid
LEFT OUTER JOIN dbo.ListMessageUrgency  AS urg WITH (NOLOCK) ON msg.MessageUrgencyUid = urg.MessageUrgencyUid
											-- fix for bug #32630
											OR (msg.MessageUrgencyUid is null and urg.MessageUrgencyUid = ''C2A64D38-3BE1-4F8A-8947-EF9E9AD861A4'')
LEFT OUTER JOIN dbo.Visit               AS vis WITH (NOLOCK) ON msg.VisitUid = vis.VisitUid
LEFT OUTER JOIN dbo.Appointment         AS apt WITH (NOLOCK) ON vis.AppointmentUid = apt.AppointmentUid
LEFT OUTER JOIN dbo.Patient             AS pat WITH (NOLOCK) ON msg.PersonUid = pat.PersonUid
LEFT OUTER JOIN dbo.ViewPerson          AS per WITH (NOLOCK, NOEXPAND) ON msg.PersonUid = per.PersonUid

-- Phone
LEFT OUTER JOIN dbo.MessageTC           AS mtc WITH (NOLOCK) ON msg.MessageTypeUid IN(''10101010-0000-0000-0000-000000000003'')
                                                            AND msg.MessageUid = mtc.MessageUid
-- Task
LEFT OUTER JOIN dbo.MessageTask         AS tsk WITH (NOLOCK) ON msg.MessageTypeUid IN(''10101010-0000-0000-0000-000000000005'')
                                                            AND msg.MessageUid = tsk.MessageUid
LEFT OUTER JOIN dbo.PatientHMRule       AS hmr WITH (NOLOCK) ON msg.MessageTypeUid IN(''10101010-0000-0000-0000-000000000005'')
                                                            AND tsk.PatientHMRuleUid = hmr.PatientHMRuleUid
-- Rx Refill
LEFT OUTER JOIN dbo.MessageRxRefill     AS mrx WITH (NOLOCK) ON msg.MessageTypeUid IN(''A2B88BC2-E7C8-4990-92F6-AE28B5C0DC77'')
                                                            AND msg.MessageUid = mrx.MessageUid
-- Visit Billing Review
LEFT OUTER JOIN dbo.MessageVisitBilling AS mvb WITH (NOLOCK) ON msg.MessageTypeUid IN(''81AD57BA-E3F1-4B8F-B3F2-23A189FBA3E5'')
                                                            AND msg.MessageUid = mvb.MessageUid
-- Attachment / Attachment Approval
LEFT OUTER JOIN dbo.RelAttachmentGroup  AS rag WITH (NOLOCK) ON msg.MessageTypeUid IN(''10101010-0000-0000-0000-000000000012'', ''10101010-0000-0000-0000-000000000002'')
                                                            AND msg.MessageUid = rag.MessageUid
LEFT OUTER JOIN dbo.AttachmentGroup     AS ag  WITH (NOLOCK) ON msg.MessageTypeUid IN(''10101010-0000-0000-0000-000000000012'', ''10101010-0000-0000-0000-000000000002'')
                                                            AND rag.AttachmentGroupUid = ag.AttachmentGroupUid
-- Patient Lab Order
OUTER APPLY (
   SELECT
      PatientUid    = CONVERT(UNIQUEIDENTIFIER, MAX(CONVERT(VARCHAR(40), obo.PatientUid))),
      VisitUid      = CONVERT(UNIQUEIDENTIFIER, MAX(CONVERT(VARCHAR(40), obo.VisitUid))),
      LaboratoryUid = CONVERT(UNIQUEIDENTIFIER, MAX(CONVERT(VARCHAR(40), obo.LaboratoryUid))),
      ApproveDate   = MAX(CASE WHEN obo.ApproveDate = ''99991231'' THEN NULL ELSE obo.ApproveDate END),
      ResultDate    = MAX(CASE WHEN obo.ResultDate  = ''19000101'' THEN NULL ELSE obo.ResultDate END),
      Result        = CASE MAX(CASE obo.AbnormalFlagCode WHEN ''N''  THEN 1 WHEN ''AB'' THEN 2 WHEN ''AL'' THEN 3 WHEN ''C''  THEN 4 ELSE 0 END)
                         WHEN 1 THEN ''Normal''
                         WHEN 2 THEN ''Abnormal''
                         WHEN 3 THEN ''Alert''
                         WHEN 4 THEN ''Critical''
                         WHEN 0 THEN ''Unknown''
                      END
   FROM dbo.RelMessageHL7ObservationOrder AS moo WITH (NOLOCK)
   INNER JOIN dbo.ObservationOrder AS obo WITH (NOLOCK) ON obo.ObservationOrderUid = moo.ObservationOrderUid
   WHERE msg.MessageTypeUid IN(''10101010-0000-0000-0000-000000000008'')
     AND msg.MessageUid = moo.MessageUid) AS lab
     
-- Patient Lab Order - All results for visit
OUTER APPLY (
   SELECT
      ApproveDate = MAX(CASE WHEN obo.ApproveDate = ''99991231'' THEN NULL ELSE obo.ApproveDate END),
      ResultDate  = MAX(CASE WHEN obo.ResultDate  = ''19000101'' THEN NULL ELSE obo.ResultDate END),
      Result      = CASE MAX(CASE obo.AbnormalFlagCode WHEN ''N''  THEN 1 WHEN ''AB'' THEN 2 WHEN ''AL'' THEN 3 WHEN ''C''  THEN 4 ELSE 0 END)
                       WHEN 1 THEN ''Normal''
                       WHEN 2 THEN ''Abnormal''
                       WHEN 3 THEN ''Alert''
                       WHEN 4 THEN ''Critical''
                       WHEN 0 THEN ''Unknown''
END
   FROM dbo.ObservationOrder AS obo WITH (NOLOCK)
   WHERE msg.MessageTypeUid IN(''10101010-0000-0000-0000-000000000008'')
     AND obo.PatientUid = lab.PatientUid
     AND obo.VisitUid = lab.VisitUid
     AND obo.LaboratoryUid = lab.LaboratoryUid
     AND obo.Inactive = 0
AND obo.ResultStatusID > 0
     AND obo.AbnormalFlagCode IS NOT NULL
     AND obo.ObservationUid != ''FFFFFFFF-0000-0000-0000-000000000001'') AS lax

-- MessageLockInfo
OUTER APPLY (
      SELECT TOP 1
         MessageUid     = msg.MessageUid,
         LockUid        = lck.LockUid,
         LockByUid      = lck.LockByUid,
         HostName       = lck.HostName,
         LockDate       = lck.LockDate,
         LockDateStart  = lck.LockDateStart
      FROM Lock lck WITH (NOLOCK)
      WHERE lck.LockedUid IN(msg.MessageUid, msg.VisitUid)
      ORDER BY lck.LockDateStart) AS mli
LEFT OUTER JOIN ViewPerson pns WITH (NOLOCK, NOEXPAND) ON mli.LockByUid = pns.PersonUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_ARBatchDeposits]'))
EXEC dbo.sp_executesql @statement = N'


CREATE  VIEW [dbo].[MDOL_RPT2_View_ARBatchDeposits]  
AS  
SELECT   
 AB.ARBatchUid,  
 AB.Name,  
 AB.GLDate,  
 AB.OwnerUid,  
 SUM(D.AmountInverse) AS Amount,
 CASE WHEN VARB.IsClosed =1 THEN 1 ELSE 0 END AS IsBatchClosed    
FROM   
 ViewDeposit D WITH (NOLOCK) 
INNER JOIN  
 ARBatch AB WITH (NOLOCK) 
ON  
 D.ARBatchUid = AB.ARBatchUid 
INNER JOIN
	AR_ViewBatchClosingsLockedClosed VARB WITH (NOLOCK) 
ON
		AB.ArBatchUid =VARB.ARBatchUid 
WHERE D.Void = 0  
GROUP BY  
 AB.ARBatchUid,  
 AB.Name,  
 AB.GLDate,  
 AB.OwnerUid,
 VARB.IsClosed  
  





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewTransactions]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewTransactions] 
AS
select art.TransactionUid,
       art.ReferenceNumber as Name,
       sb.SuperbillUid,
       sb.ExternalID as Superbill,
	   lss.Name as SuperbillStatus,
       p.PersonUid as PatientUid,
	   dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName , p.LastName, p.Suffix) as Patient,
	   vda.Receipt, 
	   vda.ReceiptBalance,
	   art.CreatedDateTime,
	   -- Distributions
	   vta.InsDistribution,
	   vta.InsPayerCreditDistributions,
	   vta.PatientDistribution,
	   vta.PtPayerCreditDistributions,
	   -- Adjustments
	   vta.InsAdjustment,
	   vta.PatientAdjustment,
	   -- Transfer
	   vta.PatientTransfer,
	   vta.InsTransfer,
	   -- Batch
	   dbo.GetBatchUidsByTransaction(art.TransactionUid) as BatchUids,
	   dbo.GetBatchNamesByTransaction(art.TransactionUid) as BatchNames,
	   dbo.GetBatchStateByTransaction(art.TransactionUid) as BatchState,
	   -- Deposit
	   art.DepositUid as DepositUids,
	   dbo.GetDepositNamesByTransaction(art.TransactionUid) as ReferenceNumbers,
	   -- Superbill Aggregates
	   vsa.Liability as SuperbillLiability,
	   vsa.LiabilityBalance as SuperbillLiabilityBalance,
	   vsa.AssignedLiabilityBalance as SuperbillAssignedLiabilityBalance
from AR_Transaction art with (nolock)
		inner join Superbill sb with (nolock) on art.SuperbillUid = sb.SuperbillUid
		inner join ListSuperbillStatus lss with (nolock) on sb.SuperbillStatusUid = lss.SuperbillStatusUid
		inner join Person p with (nolock) on sb.PatientUid = p.PersonUid
		inner join AR_ViewTransactionAggregateSub vta with (nolock) on art.TransactionUid = vta.TransactionUid -- changed from inner join to allow transactions with only remarks
		inner join AR_ViewSuperbillAggregate vsa with (nolock) on sb.SuperbillUid = vsa.SuperbillUid  -- changed from inner join to allow transactions with only remarks
		left join AR_ViewDepositAggregate vda with (nolock) on art.DepositUid = vda.DepositUid
	     





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewLedgerAccountAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewLedgerAccountAggregateSub] WITH SCHEMABINDING  AS  
	SELECT LedgerAccountUid, 
	SUM(Amount) As AvailableBalance,
	COUNT_BIG(*) AS Count  
	FROM dbo.AR_LedgerDetail   
	WHERE NOT LedgerAccountUid IS NULL 
	GROUP BY LedgerAccountUid          

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewLedgerAccountAggregateSub_LedgerAccountUid ON AR_ViewLedgerAccountAggregateSub(LedgerAccountUid)

*/

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewLedgerAccountAggregateSub]') AND name = N'PK_AR_ViewLedgerAccountAggregateSub_LedgerAccountUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewLedgerAccountAggregateSub_LedgerAccountUid] ON [dbo].[AR_ViewLedgerAccountAggregateSub]
(
	[LedgerAccountUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewLedgerAccountAggregate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewLedgerAccountAggregate]  -- for consistancy - all have non base view
AS
SELECT LedgerAccountUid, AvailableBalance
FROM AR_ViewLedgerAccountAggregateSub (NOEXPAND) 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPatientAmountDue]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewPatientAmountDue] 
AS
		 
SELECT
	AccountResponsiblePartyUid,
	FinancialCenterUid,
	SUM(AMOUNT) AMOUNT,
	SUM(CompleteBatchAmount) CompleteBatchAmount
FROM
(			 
	SELECT 
		LD.FinancialCenterUid,
		A.AccountResponsiblePartyUid,
		LD.AMOUNT,
		(CASE WHEN (AR.IsClosed = 1 OR  AR.IsLocked = 1) THEN  LD.AMOUNT ELSE 0 END) CompleteBatchAmount		
	FROM AR_LedgerDetail LD
	INNER JOIN AR_Ledger L ON L.LedgerUid=LD.LedgerUid 
	LEFT JOIN AR_Ledger LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
	INNER JOIN SuperbillProcedure SP ON SP.SuperbillProcedureUid=LD.SuperbillProcedureUid
	INNER JOIN Superbill S ON S.SuperbillUid=SP.SuperbillUid
	INNER JOIN Account A ON S.AccountUid = A.AccountUid
	INNER JOIN ARBatch AR ON L.ArBatchUid = AR.ARBatchUid 		
	WHERE
		LD.LiabilityOwner = 0 
		AND (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) --kb 
	) A
GROUP BY
	FinancialCenterUid, AccountResponsiblePartyUid 		 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementResponsiblePartyByFinancialCenterBase]'))
EXEC dbo.sp_executesql @statement = N'/*Pancratius 12/31/2013 Removed current date conversion function  from all date columns*/

 
 
CREATE VIEW [dbo].[ViewStatementResponsiblePartyByFinancialCenterBase] AS 
/*    This is the source for electronic statements and also for paper statements, indirectly via
      the stored proc MDOL_RPT2_StatementHeader/ One record per responsible party with active accounts.
 
      01/28/2008 - Qatalys - #12798 - Modified Balance with BalanceAll
      05/19/2008 - Qatalys - #13325 - Added Financial Center 
      01/22/2009 - Qatalys            - Modified to replace PersonBalanceAll,AccountBalanceAll of Account
      11/04/2009 - kellye bernecker - use FinancialCenter.MinimumStatementAmount instead of PracticeSettings.MinimumStatementAmount
      1/10/2011  - kellye bernecker - defect 7083 - remove account.cycletrigger from group by clause - was causing two rows with duplicate primary key to be returned
      10/10/2012 - kellye bernecker - removed unnecssary credit card stuff to speed things up, also added suffix to RPName
      03/18/2013 - kellye bernecker - fixed problem with statementdate being blank - Bug 19816
*/
SELECT
      RPUid,
      A.FinancialCenterUid, 
      CustomerName, 
      RPName, 
      ------CreditCard1,
      ------CreditCard2,
      ------CreditCard3,
      ------CreditCard4,
      ------CreditCard5,
      ------CreditCard6,
      RemitToName, 
      --      dbo.getSuperbillOfResposibleParty(arp.AccountResponsiblePartyUid,fc.FinancialCenterUid) as SuperBills,
      PersonUid,
      CorporationUid,
      RPID, 
      LastStatementDate, 
      StatementDate, 
      DueDate, 
      StatementMinimumAmount,
      --    Sum(a.PersonBalanceAll) as AmountDue, 
      VPA.AMOUNT AS AmountDue,
      TotalBalance, 
      PatientBalance, 
      InsuranceBalance, 
      Note,
      CycleTrigger
FROM
 
(SELECT
      a.AccountResponsiblePartyUid as RPUid,
      fc.FinancialCenterUid, 
      fc.Name as CustomerName, 
      --(CASE WHEN p.PersonUid IS NOT NULL THEN dbo.UDF_getFormattedPreferredName(p.PersonUid) 
      --    WHEN c.CorporationUid IS NOT NULL THEN c.Name 
      --    END) as RPName, 
	  CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(P.FirstName,'''') + (CASE WHEN p.MiddleName is null THEN '''' ELSE '' '' + p.MiddleName END) +'' ''+ ISNULL(p.LastName,'''') + (CASE WHEN p.Suffix is null THEN '''' ELSE '', '' + p.Suffix END)  ELSE c.Name END AS RPName,        
      ------ISNULL(dbo.getCreditCardName(1),'''')  AS CreditCard1,
      ------ISNULL(dbo.getCreditCardName(2),'''')  AS CreditCard2,
      ------ISNULL(dbo.getCreditCardName(3),'''')  AS CreditCard3,
      ------ISNULL(dbo.getCreditCardName(4),'''')  AS CreditCard4,
      ------ISNULL(dbo.getCreditCardName(5),'''')  AS CreditCard5,
      ------ISNULL(dbo.getCreditCardName(6),'''')  AS CreditCard6,
      fc.Name as RemitToName, 
--    dbo.getSuperbillOfResposibleParty(arp.AccountResponsiblePartyUid,fc.FinancialCenterUid) as SuperBills,
      p.PersonUid,
      c.CorporationUid,
      arp.ExternalID as RPID, 
      (arp.LastStatementDate) as LastStatementDate, 
------      dbo.ConvertDateOnly(getDate()) as StatementDate, 
      CONVERT(date,(getUtcDate())) as StatementDate,
------      dbo.ConvertDateOnly(DATEADD(day, fc.StatementDueDays, getDate())) as DueDate, 
      CONVERT(date, DATEADD(day, fc.StatementDueDays, (getUtcDate()))) as DueDate, 
      fc.StatementMinimumAmount,
--    Sum(a.PersonBalanceAll) as AmountDue, 
      --(SELECT SUM(Patient) 
      --    FROM ViewStatementLineItemByFinancialCenter V 
      --    WHERE 
      --          fc.FinancialCenterUid = V.FinancialCenterUid 
      --    AND arp.AccountResponsiblePartyUid=V.RPUid
      --    AND (Type in (''Charge'', ''Payment'', ''Adjustment'') OR 
      --          (Type = ''Comment'' AND CreditSubOrder = 4))
      --    AND
      --          (
      --          fc.IncludeCompletedOrClosed=1 AND V.IsSuperBilCompleteBatch=1 AND V.CompleteBatch=1 
-- OR
      --          fc.IncludeCompletedOrClosed=0
      --          )
      --          ) AS AmountDue,
      Sum(VA.LiabilityBalance) as TotalBalance, 
      Sum(VA.LiabilityBalance - VA.AssignedLiabilityBalance ) as PatientBalance, 
      SUM(VA.AssignedLiabilityBalance) as InsuranceBalance, 
      '''' as Note,
      (CASE WHEN arp.CycleTrigger = 1 THEN 1 WHEN EXISTS 
       (SELECT 1 FROM Account WHERE Account.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid AND Account.CycleTrigger = 1) 
      THEN 1 ELSE 0 END) AS CycleTrigger ,
      fc.IncludeCompletedOrClosed
      FROM  Account a INNER JOIN AccountResponsibleParty arp ON a.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid 
                  INNER JOIN AR_ViewAccountAggregate VA ON a.AccountUid=VA.AccountUid
                  LEFT JOIN Person p ON p.PersonUid = arp.PersonUid 
                  LEFT JOIN Corporation c ON c.CorporationUid = arp.CorporationUid,
--          ViewPracticeSettings ,
            MDOL_RPT2_VIEW_PracticeSettings,
            FinancialCenter fc
      WHERE 
            a.Inactive = 0 
            AND fc.Inactive=0
      GROUP BY
            fc.Name,
            fc.FinancialCenterUid,
            arp.AccountResponsiblePartyUid, 
            arp.ExternalID, 
            c.Name, 
            p.PersonUid,
            p.FirstName,
            p.LastName,
            p.MiddleName,
            p.Suffix,
            a.AccountResponsiblePartyUid,
            c.CorporationUid,
            arp.PersonUid, 
            arp.CorporationUid,
            arp.CycleTrigger, 
            --a.CycleTrigger,
            arp.LastStatementDate, 
            fc.StatementDueDays,
            fc.StatementMinimumAmount,
            fc.IncludeCompletedOrClosed
 
) A
 
LEFT JOIN
      [AR_ViewPatientAmountDue] VPA
ON
      A.FinancialCenterUid=VPA.FinancialCenterUid
AND
      A.RPUid = VPA.AccountResponsiblePartyUid
 
 
 
 
 
 
 



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_MDOL_RPT2_PaymentApplication_TransferToAmount]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[View_MDOL_RPT2_PaymentApplication_TransferToAmount]
AS
Select
A.SuperbillProcedureUid ,A.LiabilityOwner, Max(A.TransferTo) TransferTo,Sum(A.TransferAmount) TransferAmount
From 
	(Select 
		LD.LiabilityOwner,
		LD.SuperbillProcedureUid ,
		IsNull(dbo.Corporation.Name,P.LastName + '', '' + P.FirstName) as TransferTo, 
		LD.Amount AS TransferAmount
	From 
		AR_Ledger L WITH (NOLOCK)
	INNER JOIN
		AR_LedgerDetail LD WITH (NOLOCK)
	ON
		L.LedgerUid =LD.LedgerUid 
	INNER JOIN
		SuperbillProcedure SP WITH (NOLOCK)
	ON
		LD.SuperbillProcedureUid =SP.SuperbillProcedureUid 
	INNER JOIN	
		Superbill S WITH (NOLOCK)
	ON
		S.SuperbillUid = SP.SuperbillUid 
	LEFT JOIN 
		dbo.InsurancePlan WITH (NOLOCK)
	ON 
		dbo.InsurancePlan.InsurancePlanUid = LD.InsurancePlanUid
	LEFT JOIN 
		dbo.Corporation WITH (NOLOCK)
	ON 
		dbo.Corporation.CorporationUid = dbo.InsurancePlan.InsuranceCarrierUid 
	LEFT JOIN
		dbo.Account A WITH (NOLOCK)
	On
		S.AccountUID=A.AccountUID
	LEFT JOIN
		dbo.AccountResponsibleParty WITH (NOLOCK) 
	on
		dbo.AccountResponsibleParty.AccountResponsiblePartyUID=A.AccountResponsiblePartyUID
	LEFT JOIN
		Person P WITH (NOLOCK)
	ON
		P.PersonUid=	dbo.AccountResponsibleParty.Personuid		
	Where L.EntryType=4 AND LD.IsCredit =0
	) A
Group By 
A.SuperbillProcedureUid ,A.LiabilityOwner



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_MDOL_RPT2_PaymentApplication]'))
EXEC dbo.sp_executesql @statement = N'
--20170613 kculberth Fix Product Backlog Item 57093:"Payer Credit" name reflects as Payer on Payment Application Report
--20170721 kculberth Fix Bug 58130:Payment Application report reflecting 0.00 charge
--					 Return BillAmount (Charges) on every row, not just EntryType = 1 (Distributions). This was keeping 
--                   Charges from showing up on entries in the report that have adjustments
CREATE VIEW [dbo].[View_MDOL_RPT2_PaymentApplication]  
AS   
	SELECT  CASE WHEN LD2.PayerCreditUid IS NOT NULL THEN ''1'' ELSE ''0'' END as PayerCredit, 
			ARB.ARBatchuid,
			ARB.GLDate as BatchPostingDate,
			ARB.Name as Batch,
			COALESCE(DEP_0DP.DepositUid, DEP_0PC.DepositUid,DEP_2.DepositUid,DEP_3.DepositUid,DEP_4.DepositUid) AS DepositUid, 
			COALESCE(DEP_0DP.ReferenceNumber, DEP_0PC.ReferenceNumber,DEP_2.ReferenceNumber,DEP_3.ReferenceNumber,DEP_4.ReferenceNumber,TRAN_3.ReferenceNumber,''<ND>'') AS ReferenceNumber,  
			--COALESCE(DEP_0DP.PaymentTypeName, DEP_0PC.PaymentTypeName,DEP_2.PaymentTypeName,DEP_3.PaymentTypeName,DEP_4.PaymentTypeName,''Payer Credit'') AS PaymentType,
			COALESCE(DEP_0DP.PaymentTypeName, DEP_2.PaymentTypeName,DEP_3.PaymentTypeName,DEP_4.PaymentTypeName,CASE WHEN LD2.PayerCreditUid IS NOT NULL THEN ''Payer Credit'' ELSE ''<ND>'' END) AS PaymentType,
			COALESCE(DEP_0DP.WhoPaidPersonUid,DEP_0DP.WhoPaidInsuranceCarrierUid,DEP_0PC.WhoPaidPersonUid,DEP_0PC.WhoPaidInsuranceCarrierUid,DEP_2.WhoPaidPersonUid,DEP_2.WhoPaidInsuranceCarrierUid,DEP_3.WhoPaidPersonUid,DEP_3.WhoPaidInsuranceCarrierUid,DEP_4.WhoPaidPersonUid,DEP_4.WhoPaidInsuranceCarrierUid) AS PayerUid,
			COALESCE(DEP_0DP.WhoPaidName, DEP_0PC.WhoPaidName,DEP_2.WhoPaidName,DEP_3.WhoPaidName,DEP_4.WhoPaidName,CASE WHEN LD2.PayerCreditUid IS NOT NULL THEN ''Payer Credit'' ELSE ''<ND>'' END) AS Payer,
			COALESCE(DEP_0DP.AmountInverse,DEP_0PC.AmountInverse,DEP_3.AmountInverse,DEP_4.AmountInverse) as Amount,
			COALESCE(DEP_0DP.UnallocatedAmountInverse,DEP_0PC.UnallocatedAmountInverse,DEP_3.UnallocatedAmountInverse,DEP_4.UnallocatedAmountInverse) as Unallocated,
			SB.ExternalID AS ID,
			SB.ServiceDateStart AS ServiceDateStart,				
			ISNULL(VTT.TransferTo,''-'') AS TransferTo,  
			ISNULL(VTT.TransferAmount,0) AS TransferAmount,  
			LP.Code,  
			DBO.UDF_getFormattedPreferredName(SB.PatientUid) as Patient,  
			--(CASE WHEN L.EntryType <> 2 THEN 0 
			--	ELSE CASE WHEN LD.Amount<=0 THEN  SP.TotalCharge ELSE SP.TotalCharge*-1 END END) AS BillAmount,
			CASE WHEN LD.Amount<=0 THEN  SP.TotalCharge ELSE SP.TotalCharge*-1 END AS BillAmount,
			CASE WHEN L.EntryType = 2  THEN -1 * ISNULL(LD.Amount,0) ELSE 0 END AS Payment,
			CASE WHEN L.EntryType = 3  THEN -1 * ISNULL(LD.Amount,0) ELSE 0 END AS Adjustment,
			LD.FinancialCenterUid,  
			SB.SuperbillUid,  
			LD.SuperbillProcedureUid,  
			LD.ClaimingProviderUid AS BillingProviderID,  
			LD.RenderingProviderUid AS RenderingProviderID,   
			LD.ServiceSiteUid,  
			LS.Name AS ServiceSiteID,    
			LP.ProcedureUid AS ProcedureID,  
			FC.Name AS FinancialCenter,  
			LD.SuperbillProcedureUid AS ChargeID,  
			CASE  WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed   
	FROM AR_LedgerDetail LD WITH (NOLOCK)
	INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid
	INNER JOIN AR_LedgerDetail LD2 WITH (NOLOCK) ON L.LedgerUid = LD2.LedgerUid AND LD.LedgerDetailUid != LD2.LedgerDetailUid 
	INNER JOIN AR_ViewBatchClosingsLockedClosed VARB ON L.ArBatchUid = VARB.ARBatchUid
	INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid = ARB.ARBatchUid    
	LEFT JOIN ARBatch ARB2 (nolock) ON L.ARBatchUid = ARB.ARBatchUid AND L.EntryType IN (1) AND NOT LD.SuperbillProcedureUid IS NULL 			 
	INNER JOIN AR_Transaction T WITH (NOLOCK) ON L.TransactionUid =T.TransactionUid
	LEFT JOIN SuperbillProcedure SP (nolock) ON LD.SuperbillProcedureUid = SP.SuperbillProcedureUid 
	LEFT JOIN Superbill SB (nolock) ON SP.SuperbillUid = SB.SuperbillUid 	
	LEFT JOIN ListProcedure LP (nolock) ON LP.ProcedureUID=SP.ProcedureUID
	LEFT JOIN ViewDeposit DEP_0DP WITH (NOLOCK) ON L.EntryType = 0 AND LD.DepositUid = DEP_0DP.DepositUid
	LEFT JOIN AR_PayerCredit PC_0 WITH (NOLOCK) ON L.EntryType = 2 AND LD2.PayerCreditUid = PC_0.PayerCreditUid
	LEFT JOIN ViewDeposit DEP_0PC WITH (NOLOCK) ON PC_0.DepositUid = DEP_0PC.DepositUid
	LEFT JOIN ViewDeposit DEP_2 WITH (NOLOCK) ON L.EntryType = 2 AND LD.DepositUid = DEP_2.DepositUid AND L.TransactionUid IS NULL AND LD.PayerCreditUid IS NULL AND LD.iscredit=1 
	LEFT JOIN AR_Transaction TRAN_3 WITH (NOLOCK) ON L.EntryType = 3 AND L.TransactionUid = TRAN_3.TransactionUid
	LEFT JOIN ViewDeposit DEP_3 WITH (NOLOCK) ON TRAN_3.DepositUid = DEP_3.DepositUid
	LEFT JOIN ViewDeposit DEP_4 WITH (NOLOCK) ON DEP_4.DepositUid=LD2.DepositUid AND NOT LD.SuperbillProcedureUid  IS NULL and L.EntryType = 2
	LEFT JOIN MDOL_RPT2_View_ARBatchDeposits VAD WITH (NOLOCK) ON VAD.ARBatchUid=VARB.ArBatchUid
	LEFT JOIN [View_MDOL_RPT2_PaymentApplication_TransferToAmount] VTT WITH (NOLOCK) ON LD.SuperbillProcedureUid = VTT.SuperbillProcedureUid AND LD.LiabilityOwner = VTT.LiabilityOwner  
	LEFT JOIN ListServiceSite LS WITH (NOLOCK) ON LD.ServiceSiteUid = LS.ServiceSiteUid   
	LEFT JOIN FinancialCenter FC WITH (NOLOCK) ON LD.FinancialCenterUid = FC.FinancialCenterUid  
	where LD.SuperbillProcedureUid IS NOT NULL and 
			L.EntryType <> 4

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewServiceSiteAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewServiceSiteAggregateSub] WITH SCHEMABINDING  
AS  
SELECT ServiceSiteUid,         
		SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.AMOUNT ELSE 0 END) As Liability,         
		SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT ELSE 0 END) As AssignedLiability,        
		SUM(CASE WHEN L.EntryType = 2  THEN LD.AMOUNT*-1 ELSE 0 END) As Distribution,        
		SUM(CASE WHEN L.EntryType = 2 AND NOT LD.InsurancePlanUid IS NULL  THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedDistribution,        
		SUM(CASE WHEN L.EntryType = 3 THEN LD.AMOUNT*-1 ELSE 0 END) As Adjustment,        
		SUM(CASE WHEN L.EntryType = 3 AND NOT LD.InsurancePlanUid IS NULL THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedAdjustment,        
		SUM(LD.Amount) As LiabilityBalance,         
		SUM(CASE WHEN NOT LD.InsurancePlanUid IS NULL THEN LD.Amount ELSE 0 END) As AssignedLiabilityBalance,        
		COUNT_BIG(*) AS Count  
	FROM dbo.AR_LedgerDetail LD        
		INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
	WHERE NOT ServiceSiteUid IS NULL  AND NOT SuperbillProcedureUid IS NULL   
	GROUP BY ServiceSiteUid      

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_AR_ViewServiceSiteAggregateSub_ServiceSiteUid ON AR_ViewServiceSiteAggregateSub(ServiceSiteUid)

*/
' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewServiceSiteAggregateSub]') AND name = N'PK_AR_ViewServiceSiteAggregateSub_ServiceSiteUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewServiceSiteAggregateSub_ServiceSiteUid] ON [dbo].[AR_ViewServiceSiteAggregateSub]
(
	[ServiceSiteUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewServiceSiteAggregate]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_ViewServiceSiteAggregate] 
AS
SELECT SVC.ServiceSiteUid, 
	ISNULL(VSVCAB.Liability, 0) AS Liability, 
	CAST(ISNULL(VSVCAB.AssignedLiability, 0) AS MONEY) AS AssignedLiability,
	ISNULL(VSVCAB.LiabilityBalance, 0) AS LiabilityBalance, 
	CAST(ISNULL(VSVCAB.AssignedLiabilityBalance, 0) AS MONEY) AS AssignedLiabilityBalance
FROM ListServiceSite SVC
LEFT JOIN AR_ViewServiceSiteAggregateSub (NOEXPAND) VSVCAB ON SVC.ServiceSiteUid = VSVCAB.ServiceSiteUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewEnrollmentDemographicsEDIResponse]'))
EXEC dbo.sp_executesql @statement = N'






CREATE VIEW [dbo].[ViewEnrollmentDemographicsEDIResponse]
AS

SELECT eo.EnrollmentOutboundUid AS OutboundUid,
       vwEnrollPatientNames.PersonUid,
       vwEnrollPatientNames.FullName AS PatientName,
       ''Enrollment'' AS RequestType,
       tc.TransmissionConfigurationUid,
       tc.TransmissionType, 
       lcch.ClaimClearingHouseUid, 
       lcch.Name AS ClearingHouseName, 
       eo.TransmissionDataUid,
       eo.PatientExternalID,  -- TransmissionData.RequestId
       eo.ProviderUid AS PrimaryProviderUid,
       vwEnrollProviderNames.FormattedInternalName AS PrimaryProviderName,
       eo.SubmissionNumber AS SubmissionID,
       eo.SubmitDate,
       eo.TransmitDate,
       eo.TransmitStatus,
       
       (CASE WHEN eo.TransmitStatusID = -1      THEN ''Cancelled''
             WHEN eo.TransmitStatusID =  0      THEN ''Submitted''
             WHEN eo.TransmitStatusID = 10      THEN ''Error Transmitting to AprimaVault''
             WHEN eo.TransmitStatusID = 20      THEN ''Successfully Transmitted to AprimaVault''
             WHEN eo.TransmitStatusID = 30      THEN ''Error Converting To X12 Format (Validation Error)''
             WHEN eo.TransmitStatusID = 40      THEN ''Successfully Converted To X12 Format''
             WHEN eo.TransmitStatusID = 50      THEN ''Error Sending to Clearinghouse FTP''
             WHEN eo.TransmitStatusID = 60      THEN ''Successfully Sent to Clearinghouse FTP''
             WHEN eo.TransmitStatusID >= 70 
                  and eo.TransmitStatusID <= 79 THEN ''Rejected by Clearinghouse''
             WHEN eo.TransmitStatusID = 80      THEN ''Pending Clearinghouse Approval''
             WHEN eo.TransmitStatusID = 90      THEN ''Rejected by Clearinghouse''
             WHEN eo.TransmitStatusID = 95      THEN ''Accepted by Clearinghouse'' 
             WHEN eo.TransmitStatusID = 200     THEN ''Rejected by ADHS''
             WHEN eo.TransmitStatusID = 205     THEN ''Accepted by ADHS''
             ELSE (''Unknown Status : '' + CONVERT(VARCHAR, eo.TransmitStatusID)) 
         END) AS CurrentStatus,  
                      
       eo.TransmitStatusID, 
       eo.RequestType AS EnrollmentMaintenanceReasonCode,
       eo.AccountUid AS AccountUid,
       acct.Name AS AccountName        

FROM    eEnrollmentsOutbound eo
        INNER JOIN ViewPerson (NOEXPAND) vwEnrollPatientNames on vwEnrollPatientNames.PersonUid = eo.PatientUid 
        LEFT  JOIN ViewPerson (NOEXPAND) vwEnrollProviderNames on vwEnrollProviderNames.PersonUid = eo.ProviderUid 
        INNER JOIN TransmissionConfiguration tc on tc.TransmissionConfigurationUid = eo.TransmissionConfigurationUid 
        INNER JOIN ListClaimClearingHouse lcch on lcch.ClaimClearingHouseUid = tc.ClaimClearingHouseUid 
        INNER JOIN Account acct on acct.AccountUid = eo.AccountUid

UNION ALL

SELECT do.DemographicsOutboundUid AS OutboundUid,
       vwDemoPatientNames.PersonUid,
       vwDemoPatientNames.FullName AS PatientName,   
       ''Demographics'' AS RequestType, 
       tc.TransmissionConfigurationUid,
       tc.TransmissionType, 
       lcch.ClaimClearingHouseUid, 
       lcch.Name as ClearingHouseName, 
       do.TransmissionDataUid,
       do.PatientExternalID,  -- TransmissionData.RequestId
       do.ProviderUid AS PrimaryProviderUid,
       vwDemoProviderNames.FormattedInternalName AS PrimaryProviderName,
       do.SubmissionNumber AS SubmissionID,
       do.SubmitDate,
       do.TransmitDate,
       do.TransmitStatus,
       
       (CASE WHEN do.TransmitStatusID = -1      THEN ''Cancelled''
             WHEN do.TransmitStatusID =  0      THEN ''Submitted''
             WHEN do.TransmitStatusID = 10      THEN ''Error Transmitting to AprimaVault''
             WHEN do.TransmitStatusID = 20      THEN ''Successfully Transmitted to AprimaVault''
             WHEN do.TransmitStatusID = 30      THEN ''Error Converting To X12 Format (Validation Error)''
             WHEN do.TransmitStatusID = 40      THEN ''Successfully Converted To X12 Format''
             WHEN do.TransmitStatusID = 50      THEN ''Error Sending to Clearinghouse FTP''
             WHEN do.TransmitStatusID = 60      THEN ''Successfully Sent to Clearinghouse FTP''
             WHEN do.TransmitStatusID = 70      THEN ''Rejected by Clearinghouse''
             WHEN do.TransmitStatusID = 80      THEN ''Pending Clearinghouse Approval''
             WHEN do.TransmitStatusID = 90      THEN ''Rejected Clearinghouse Approval''
             WHEN do.TransmitStatusID = 95      THEN ''Accepted by Clearinghouse''
             WHEN do.TransmitStatusID = 200     THEN ''Rejected by ADHS''
             WHEN do.TransmitStatusID = 205     THEN ''Accepted by ADHS''
             ELSE (''Unknown Status : '' + CONVERT(VARCHAR, do.TransmitStatusID)) 
         END) AS CurrentStatus,       
       
       do.TransmitStatusID, 
       null as EnrollmentMaintenanceReasonCode,
       do.AccountUid AS AccountUid,
       acct.Name AS AccountName              
            
FROM    eDemographicsOutbound do
        INNER JOIN ViewPerson (NOEXPAND) vwDemoPatientNames on vwDemoPatientNames.PersonUid   = do.PatientUid 
        LEFT  JOIN ViewPerson (NOEXPAND) vwDemoProviderNames on vwDemoProviderNames.PersonUid = do.ProviderUid 
        INNER JOIN TransmissionConfiguration tc on tc.TransmissionConfigurationUid = do.TransmissionConfigurationUid
        INNER JOIN ListClaimClearingHouse lcch on lcch.ClaimClearingHouseUid = tc.ClaimClearingHouseUid 
        INNER JOIN Account acct on acct.AccountUid = do.AccountUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEWReferringProviderAnalysis]'))
EXEC dbo.sp_executesql @statement = N'
--10/12/2017  Chayes bug # 59925. discovered report version was getting results with No referring provider and was not getting Sbs by referral source if they also had no referring provider
				--also, removed appointment as it is not used

CREATE VIEW [dbo].[MDOL_RPT2_VIEWReferringProviderAnalysis]
AS	
	SELECT 
		LS.Name as ServiceSiteName,
		LD.RenderingProviderUid as RenderingProviderUid,
		LD.ClaimingProviderUid as BillingProviderUid,
		PAT.BirthDate,
		isnull(SB.ExternalID,'''') as ExternalID,
		CASE WHEN L.EntryType=1 OR L.EntryType=4 THEN ISNULL(LD.Amount, 0) ELSE 0 END AS Charge,
		CASE WHEN L.EntryType=2 AND LD.IsCredit=1  THEN -1 * ISNULL(LD.Amount, 0) ELSE 0 END AS Payment,
		CASE WHEN L.EntryType=3 AND LD.IsCredit=1  THEN -1 * ISNULL(LD.Amount, 0) ELSE 0 END AS Adjustment,		
		SB.PatientUID,
		SB.ReferringProviderUID,
		LD.ServiceSiteUID,
		LD.FinancialCenterUID,
		SB.ServiceDateEnd,
		ARB.GlDate,
		--COALESCE(LRS.ReferralSrcUid,LRSA.ReferralSrcUid) AS ReferralSrcUid,
		--COALESCE(LRS.Name,LRSA.Name) AS ReferralSource,
		LRS.ReferralSrcUid,
		LRS.Name AS ReferralSource,
		CASE WHEN VARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed	
	From AR_Ledger L WITH (NOLOCK)
	JOIN AR_LedgerDetail LD WITH (NOLOCK) on L.LedgerUid = LD.LedgerUid 
	LEFT JOIN SuperbillProcedure SP WITH (NOLOCK) ON LD.SuperbillProcedureUid = SP.SuperbillProcedureUid 
	LEFT JOIN Superbill SB WITH (NOLOCK) ON SP.SuperbillUid = SB.SuperbillUid 
	--LEFT JOIN Appointment Appt WITH (NOLOCK) ON SB.AppointmentUid = Appt.AppointmentUid
	JOIN Person PAT WITH (NOLOCK) on PAT.PersonUID=SB.PatientUID
	LEFT JOIN ListServiceSite LS WITH (NOLOCK) ON LS.ServiceSiteUID = LD.ServiceSiteUID
	LEFT JOIN ARBatch ARB WITH (NOLOCK) on L.ARBatchUid = ARB.ARBatchUid
	LEFT JOIN AR_ViewBatchClosingsLockedClosed VARB WITH (NOLOCK) ON L.ArBatchUid =VARB.ARBatchUid 	
	LEFT JOIN ListReferralSrc LRS WITH (NOLOCK) ON SB.ReferralSrcUid = LRS.ReferralSrcUid
	--LEFT JOIN ListReferralSrc LRSA WITH (NOLOCK) ON LRSA.ReferralSrcUid = Appt.ReferralSrcUid
	WHERE SB.ReferringProviderUID IS NOT NULL or SB.referralsrcUid IS NOT NULL
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_MonthlyRevenueProductivity]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[MDOL_RPT2_VIEW_MonthlyRevenueProductivity]
AS 
SELECT
			LD.ClaimingProviderUid,
			LD.RenderingProviderUid,
			LD.ServiceSiteUid,
			LD.FinancialCenterUid,
			dbo.UDF_getFormattedPreferredName(LD.ClaimingProviderUid) AS BillingProvider,
			dbo.UDF_getFormattedPreferredName(LD.RenderingProviderUid) AS RenderingProvider,
			AR.GLDate AS GLDate,
			Listprocedure.Code AS Code,
			Substring(Listprocedure.ShortDescription,1,35) AS Description,
			ListServiceSite.Name AS ServiceSite,
			FinancialCenter.Name AS FinancialCenter,
			ISNULL(ListprocedureGroup.Name,''Unknown'') AS ProcedureGroup ,
			CASE WHEN L.EntryType = 2 THEN (ISNULL(LD.Amount,0) * -1) ELSE 0 END As Payment,
			CASE WHEN L.EntryType = 3 THEN (ISNULL(LD.Amount,0) * -1) ELSE 0 END As Adjustment,
			CASE  WHEN AR.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed
FROM
	AR_LedgerDetail LD WITH (NOLOCK) 
INNER JOIN AR_Ledger L WITH (NOLOCK)
	ON L.LedgerUid = LD.LedgerUid
INNER JOIN  
	AR_Transaction T WITH (NOLOCK) 
ON  
	L.TransactionUid = T.TransactionUid AND LD.IsCredit = 1 AND LD.SuperbillProcedureUid IS NOT NULL
LEFT JOIN      
	ViewDeposit D WITH (NOLOCK)      
ON      
	D.DepositUID=T.DepositUID 
LEFT JOIN 
	ARBatch AR WITH (NOLOCK)  
ON 
	L.ArBatchUid = AR.ARBatchUid		
LEFT JOIN 
	AR_LedgerDetail LD2 WITH (NOLOCK) 
ON 
	L.LedgerUid = LD2.LedgerUid  AND LD2.IsCredit=1 AND LD2.SuperbillProcedureUid IS NOT NULL
LEFT JOIN 
	Superbill S WITH (NOLOCK) 
ON 
	S.SuperbillUid = T.SuperbillUid
LEFT JOIN 
	SuperbillProcedure WITH (NOLOCK)  
ON 
	SuperbillProcedure.SuperbillProcedureUid = LD2.SuperbillProcedureUid
LEFT JOIN 
	ListServicesite (NOLOCK) 
ON 
	LD.ServicesiteUid = ListServicesite.ServicesiteUid	
LEFT JOIN 
	Listprocedure (NOLOCK) 
ON 
	Listprocedure.ProcedureUid = SuperbillProcedure.ProcedureUid 
LEFT JOIN 
	ListprocedureGroup WITH (NOLOCK) 
ON 
	ListprocedureGroup.ProcedureGroupUid = Listprocedure.ProcedureGroupUid
--- Pancratius: 09/22/2014 Added Financia Center 
LEFT JOIN FinancialCenter WITH (NOLOCK)
	ON FinancialCenter.FinancialCenterUid=ld.FinancialCenterUid
	
UNION ALL

SELECT
			VPC.RenderingProviderUid As ClaimingProviderUid,
			VPC.RenderingProviderUid,
			VPC.ServiceSiteUid,
			vpc.FinancialCenterUid,
			dbo.UDF_getFormattedPreferredName(VPC.RenderingProviderUid) AS BillingProvider,
			dbo.UDF_getFormattedPreferredName(VPC.RenderingProviderUid) AS RenderingProvider,
			ARB.GLDate AS GLDate,
			''-'' AS Code,
			''Payer Credit'' AS Description,
			VPC.ServiceSiteName AS ServiceSite,
			VPC.FinancialCenterName AS FinancialCenter,
			''Unknown'' AS ProcedureGroup ,
			VPC.Receipt As Payment,
			0 As Adjustment,
			CASE  WHEN ARB.IsClosed=1 THEN 1 ELSE 0 END AS IsBatchClosed
FROM
	    MDOL_RPT2_ViewPayerCredit VPC WITH (NOLOCK)
	JOIN 
		ARBatch ARB WITH (NOLOCK)
	ON 
		ARB.ARBatchUid = VPC.ArBatchUid 
	JOIN
		AR_ViewBatchClosingsLockedClosed VARB WITH (NOLOCK)
	ON
		ARB.ArBatchUid =VARB.ARBatchUid	



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPersonAccountInsurance]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewSuperbillPersonAccountInsurance] as
SELECT SB.SuperbillUid, SB.AccountUid, AP.AccountPeriodUid, AI.AccountInsuranceUid 
	FROM Superbill AS SB 
		INNER JOIN AccountPeriod AS AP ON SB.AccountUid = AP.AccountUid 
			LEFT JOIN AccountInsurance AS AI ON AP.AccountPeriodUid = AI.AccountPeriodUid -- LEFT as not always have AI
			LEFT JOIN PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
			LEFT JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid
		LEFT JOIN AR_LedgerDetail LD ON PIP.InsurancePlanUid = LD.InsurancePlanUid 
			AND SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid
			AND AI.DisplayOrder = LD.LiabilityOwner
WHERE (AP.EffectiveDate is null or AP.EffectiveDate <= SB.ServiceDateEnd)
	AND (AP.ExpirationDate IS NULL OR DateAdd(dd, 1, AP.ExpirationDate) > SB.ServiceDateEnd)
	-- AND ((AI.DisplayOrder = SB.InsuranceOrder AND SB.InsuranceOrder>0) OR SB.InsuranceOrder=0) -- use LD existance rather than SB.InsuranceOrder
	AND NOT LD.LedgerDetailUid IS NULL



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewAccountPeriodSuperbillServiceDateRange]'))
EXEC dbo.sp_executesql @statement = N'
-- Load list of AccountPeriods with Min and Max Superbill Service Dates to bound Account Period Effective dates
CREATE VIEW [dbo].[ViewAccountPeriodSuperbillServiceDateRange] as
SELECT AP.AccountPeriodUid, MIN(SB.ServiceDateStart) AS MinSuperbillServiceDateStart, MAX(SB.ServiceDateEnd) as MaxSuperbillServiceDateEnd
FROM AccountPeriod AP
LEFT JOIN ViewSuperbillPersonAccountInsurance SPAI ON AP.AccountPeriodUid = SPAI.AccountPeriodUid
LEFT JOIN Superbill SB ON SPAI.SuperbillUid = SB.SuperbillUid
GROUP BY AP.AccountPeriodUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCacheMachinePatient]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewCacheMachinePatient] AS
	SELECT	r.CacheMachinePatientUid,
			r.CacheMachineUid,cm.Name AS CacheMachine, r.Action,
			p.PersonUid AS PatientUid, p.FirstName, p.LastName, p.FullName AS Patient, p.MedicalRecordNumber, p.ExternalID, 
			p.Birthdate
	FROM	RelCacheMachinePatient r INNER JOIN ViewFindPatient p ON r.PatientUid = p.PersonUid
			INNER JOIN ListCacheMachine cm ON r.CacheMachineUid = cm.CacheMachineUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_DemographicbySchedule_Main_InsuranceAddress]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[MDOL_RPT2_VIEW_DemographicbySchedule_Main_InsuranceAddress]
AS
SELECT   	
	A.AccountUID,    
	A.PersonUID,  

	(CASE WHEN ip.[Address] IS NOT  NULL THEN
		(CASE WHEN  ip.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE ip.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') + '','' END) + (CASE WHEN  ip.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE ip.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') + '','' END) + (CASE WHEN  ip.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') IS NULL THEN ''''  ELSE ip.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') + '' '' +  ISNULL(ip.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') + '' '' +  ISNULL(ip.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') + '','' END)+  (CASE WHEN ip.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE ip.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') + '','' END) + ''Plan Phone:'' + ISNULL(ip.Phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''),'''')
	ELSE
		(CASE WHEN  c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') + '','' END) + (CASE WHEN  c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') + '','' END) + (CASE WHEN  c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') IS NULL THEN ''''  ELSE c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') + '' '' +  ISNULL(c.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''')  + '' '' +  ISNULL(c.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') + '','' END)+  (CASE WHEN c.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE c.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') + '','' END) + ''Plan Phone:'' + ISNULL(c.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''),'''') 
	END) AS InsuranceAddress,
	AI.DisplayOrder,
	AP.AccountTypeUid,
	dbo.UDF_getFormattedPreferredNameFromValues(P1.Firstname,P1.LastName,P1.MiddleName,P1.Suffix) AS INSSubName,
	P1.BirthDate AS INSBirthDate,
	PIP.AuthorizeAssignment AS Assignment,
	LRS.Name AS Relation,
	C.Name AS InsuranceName,
	IP.Name AS PlanName,
	PIP.PlanGroupID AS GroupID,
	PIP.PlanMemberID AS MemberID,
	PIP.CopayPrimary AS CopayPrimary,
	PIP.CopaySpecialist AS CopaySpecialist,
	PIP.CopayOther AS CopayOther
FROM            
	Account AS A   WITH (NOLOCK)
LEFT JOIN  
	dbo.AccountPeriod AS AP   WITH (NOLOCK)
ON   
	A.AccountUid = AP.AccountUid   
	AND ((AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(GETDATE() AS DATE))
    OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.expirationDate AS DATE) >= CAST(GETDATE() AS DATE)) 
    OR (AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(GETDATE() AS DATE) AND CAST(AP.expirationDate AS DATE) >= CAST(GETDATE() AS DATE)) 
    OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NULL))       
       
LEFT JOIN  
	AccountInsurance AS AI   WITH (NOLOCK)
ON   
	AI.AccountPeriodUid = AP.AccountPeriodUid   
LEFT JOIN  
	PersonInsurancePlan AS PIP   WITH (NOLOCK)
ON   
	PIP.PersonInsurancePlanUid = AI.PersonInsurancePlanUid   
LEFT JOIN  
	dbo.InsurancePlan AS IP   WITH (NOLOCK)
ON   
	IP.InsurancePlanUid = PIP.InsurancePlanUid  
LEFT JOIN
	Corporation C WITH (NOLOCK)
ON
	C.CorporationUid = IP.InsuranceCarrierUid 
LEFT JOIN
	Person P1 WITH (NOLOCK)
ON
		PIP.PersonUID=P1.PersonUID
LEFT JOIN
		ListRelationship LRS WITH (NOLOCK)
ON
		AI.RelationShipUID=LRS.RelationshipUID
WHERE A.IsMain=1  -- Main account primary and secondary insurance





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_DemographicbySchedule_Other_InsuranceAddress]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[MDOL_RPT2_VIEW_DemographicbySchedule_Other_InsuranceAddress] AS
SELECT   	
	A.AccountUID,    
	A.PersonUID,  
	(CASE WHEN ip.[Address] IS NOT  NULL THEN
		(CASE WHEN  ip.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE ip.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') + '','' END) + (CASE WHEN  ip.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE ip.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') + '','' END) + (CASE WHEN  ip.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') IS NULL THEN ''''  ELSE ip.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') + '' '' + ISNULL(ip.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') + '' '' +  ISNULL(ip.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') + '','' END)+  (CASE WHEN ip.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE ip.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') + '','' END) + ''Plan Phone:'' + ISNULL(ip.Phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''),'''')
	ELSE
		(CASE WHEN c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') + '','' END) + (CASE WHEN  c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') + '','' END) + (CASE WHEN  c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') IS NULL THEN ''''  ELSE c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') + '' '' +  ISNULL(c.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''')  + '' '' +  ISNULL(c.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') + '','' END)+  (CASE WHEN c.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') IS NULL THEN '''' ELSE c.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') + '','' END) + ''Plan Phone:'' + ISNULL(c.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''),'''') 
	END) AS InsuranceAddress,
	AI.DisplayOrder,
	dbo.UDF_getFormattedPreferredNameFromValues(P1.Firstname,P1.LastName,P1.MiddleName,P1.Suffix) AS INSSubName,
	P1.BirthDate AS INSBirthDate,
	PIP.AuthorizeAssignment AS Assignment,
	LRS.Name AS Relation,
	C.Name AS InsuranceName,
	IP.Name AS PlanName,
	PIP.PlanGroupID AS GroupID,
	PIP.PlanMemberID AS MemberID,
	PIP.CopayPrimary AS CopayPrimary,
	PIP.CopaySpecialist AS CopaySpecialist,
	PIP.CopayOther AS CopayOther 
FROM            
	Account AS A   WITH (NOLOCK)
LEFT JOIN  
	dbo.AccountPeriod AS AP   WITH (NOLOCK)
ON   
	A.AccountUid = AP.AccountUid   
	AND ((AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(GETDATE() AS DATE))
     OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.expirationDate AS DATE) >= CAST(GETDATE() AS DATE)) 
     OR (AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(GETDATE() AS DATE) AND CAST(AP.expirationDate AS DATE) >= CAST(GETDATE() AS DATE)) 
     OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NULL))       
       
LEFT JOIN  
	AccountInsurance AS AI   WITH (NOLOCK)
ON   
	AI.AccountPeriodUid = AP.AccountPeriodUid   
LEFT JOIN  
	PersonInsurancePlan AS PIP   WITH (NOLOCK)
ON   
	PIP.PersonInsurancePlanUid = AI.PersonInsurancePlanUid   
LEFT JOIN  
	dbo.InsurancePlan AS IP   WITH (NOLOCK)
ON   
	IP.InsurancePlanUid = PIP.InsurancePlanUid  
LEFT JOIN
	Corporation C WITH (NOLOCK)
ON
	C.CorporationUid = IP.InsuranceCarrierUid 
LEFT JOIN
	Person P1 WITH (NOLOCK)
ON
		PIP.PersonUID=P1.PersonUID
LEFT JOIN
		ListRelationship LRS WITH (NOLOCK)
ON
		AI.RelationShipUID=LRS.RelationshipUID
WHERE A.IsMain !=1  -- Other account primary and secondary insurance





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_DemographicbySchedule_Accounts]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[MDOL_RPT2_VIEW_DemographicbySchedule_Accounts]

AS 
	SELECT 
		AC.IsMain AS IsMain,
		PT.PersonUID AS PersonUID,
		AC.AccountUid,
		AC.Name AS Account,
		AC.ExternalID AS AccountID,
		LAT.Name AS AccountType,
		ARP.ExternalID AS RespPartyID,
		dbo.UDF_getFormattedPreferredNameFromValues(P2.Firstname,P2.LastName,P2.MiddleName,P2.Suffix) AS RespParty,
		--VA.AccountBalanceAll AS TotalBalance,
		--VA.PersonBalanceaLL AS PatientBalance,
		(VA.LiabilityBalance - VA.AssignedLiabilityBalance) as PatientBalance,
		(VA.LiabilityBalance) as TotalBalance,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.InsuranceName,''-'') else IsNull(OIA1.InsuranceName,''-'') END) AS PrimaryInsuranceName,
		(CASE WHEN AC.IsMain=1 THEN MIA2.InsuranceName else IsNull(OIA2.InsuranceName,''-'') END) AS SecondaryInsuranceName,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.InsuranceAddress,''-'') else IsNull(OIA1.InsuranceAddress,''-'') END) AS PrimaryInsuranceAddress,
		(CASE WHEN AC.IsMain=1 THEN MIA2.InsuranceAddress else IsNull(OIA2.InsuranceAddress,''-'') END) AS SecondaryInsuranceAddress,
	--	(CASE WHEN DisplayOrder=1 THEN IA.InsuranceAddress else ''-'' END) AS PrimaryInsuranceAddress,
	--	(CASE WHEN DisplayOrder=2 THEN IA.InsuranceAddress else ''-'' END) AS SecondaryInsuranceAddress,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.INSSubName,''-'') else IsNull(OIA1.INSSubName,''-'') END) AS PrimaryInsSubcriber,
		(CASE WHEN AC.IsMain=1 THEN MIA1.INSBirthDate else OIA1.INSBirthDate END) AS PrimaryInsSubcriberDOB,
--		(CASE WHEN AC.IsMain=1 THEN (CASE WHEN(MIA1.Assignment=1) THEN ''Yes'' ELSE ''No'' END) else (CASE WHEN(OIA1.Assignment=1) THEN ''Yes'' ELSE ''No'' END) END) AS PrimaryInsSubcriberAssignment,
		(CASE WHEN AC.IsMain=1 THEN (CASE WHEN(MIA1.Assignment=1) THEN ''Yes'' ELSE (CASE WHEN(MIA1.Assignment=0)THEN ''No'' ELSE ''-'' END) END) ELSE (CASE WHEN(OIA1.Assignment=1) THEN ''Yes'' ELSE (CASE WHEN(OIA1.Assignment=0)THEN ''No'' ELSE ''-'' END) END) END) AS PrimaryInsSubcriberAssignment,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.Relation,''-'') else IsNull(OIA1.Relation,''-'') END) AS PrimaryInsSubcriberRelation,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA2.INSSubName,''-'') else IsNull(OIA2.INSSubName,''-'') END) AS SecondaryInsSubcriber,
		(CASE WHEN AC.IsMain=1 THEN MIA2.INSBirthDate else OIA2.INSBirthDate END) AS SecondaryInsSubcriberDOB,
--		(CASE WHEN AC.IsMain=1 THEN (CASE WHEN(MIA2.Assignment=1) THEN ''Yes'' ELSE ''No'' END) else  (CASE WHEN(OIA2.Assignment=1) THEN ''Yes'' ELSE ''No'' END) END) AS SecondaryInsSubcriberAssignment,
		(CASE WHEN AC.IsMain=1 THEN (CASE WHEN(MIA2.Assignment=1) THEN ''Yes'' ELSE (CASE WHEN(MIA2.Assignment=0)THEN ''No'' ELSE ''-'' END) END) else  (CASE WHEN(OIA2.Assignment=1) THEN ''Yes'' ELSE (CASE WHEN(OIA2.Assignment=0)THEN ''No'' ELSE ''-'' END) END) END) AS SecondaryInsSubcriberAssignment,

		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA2.Relation,''-'') else IsNull(OIA2.Relation,''-'') END) AS SecondaryInsSubcriberRelation,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.GroupID,''-'') else IsNull(OIA1.GroupID,''-'') END) AS PrimaryGroupID,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA2.GroupID,''-'') else IsNull(OIA2.GroupID,''-'') END) AS SecondaryGroupID,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.MemberID,''-'') else IsNull(OIA1.MemberID,''-'') END) AS PrimaryMemberID,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA2.MemberID,''-'') else IsNull(OIA2.MemberID,''-'') END) AS SecondaryMemberID,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.PlanName,''-'') else IsNull(OIA1.PlanName,''-'') END) AS PrimaryPlanName,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA2.PlanName,''-'') else IsNull(OIA2.PlanName,''-'') END) AS SecondaryPlanName,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.CopayPrimary,''-'') else IsNull(OIA1.CopayPrimary,''-'') END) AS PrimaryCopayPrimary,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA2.CopayPrimary,''-'') else IsNull(OIA2.CopayPrimary,''-'') END) AS SecondaryCopayPrimary,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.CopaySpecialist,''-'') else IsNull(OIA1.CopaySpecialist,''-'') END) AS PrimaryCopaySpecialist,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA2.CopaySpecialist,''-'') else IsNull(OIA2.CopaySpecialist,''-'') END) AS SecondaryCopaySpecialist,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA1.CopayOther,''-'') else IsNull(OIA1.CopayOther,''-'') END) AS PrimaryCopayOther,
		(CASE WHEN AC.IsMain=1 THEN IsNull(MIA2.CopayOther,''-'') else IsNull(OIA2.CopayOther,''-'') END) AS SecondaryCopayOther

	FROM
		Patient Pt WITH (NOLOCK)
	LEFT JOIN
		Person P  WITH (NOLOCK)
	ON
		P.PersonUID=Pt.PersonUID
	LEFT JOIN
		Account AC WITH (NOLOCK)
	ON	
		P.PersonUID=AC.PersonUID
    LEFT JOIN
		--ViewArAccountAggregate VA
		AR_ViewAccountAggregate VA WITH (NOLOCK)
    ON
		AC.AccountUid=VA.AccountUid
	LEFT JOIN
		AccountResponsibleParty ARP WITH (NOLOCK)
	ON
		AC.AccountResponsiblePartyUID=ARP.AccountResponsiblePartyUID
	LEFT JOIN
		Person P2 WITH (NOLOCK)
	ON
		P2.PersonUID=ARP.PersonUID
	LEFT JOIN 
		[MDOL_RPT2_VIEW_DemographicbySchedule_Main_InsuranceAddress] MIA1 WITH (NOLOCK)
	ON
		P.PersonUID=MIA1.PersonUID
	AND
		AC.AccountUid=MIA1.AccountUid
	AND
		MIA1.DISPLAYORDER=1
	LEFT JOIN 
		ListAccountType LAT WITH (NOLOCK)
	ON
		MIA1.AccountTypeUid = LAT.AccountTypeUid
	LEFT JOIN 
		[MDOL_RPT2_VIEW_DemographicbySchedule_Main_InsuranceAddress] MIA2 WITH (NOLOCK)
	ON
		P.PersonUID=MIA2.PersonUID
	AND
		AC.AccountUid=MIA2.AccountUid
	AND
		MIA2.DISPLAYORDER=2

	LEFT JOIN 
		[MDOL_RPT2_VIEW_DemographicbySchedule_Other_InsuranceAddress] OIA1 WITH (NOLOCK)
	ON
		P.PersonUID=OIA1.PersonUID
	AND
		AC.AccountUid=OIA1.AccountUid
	AND
		OIA1.DISPLAYORDER=1
	LEFT JOIN 
		[MDOL_RPT2_VIEW_DemographicbySchedule_Other_InsuranceAddress] OIA2 WITH (NOLOCK)
	ON
		P.PersonUID=OIA2.PersonUID
	AND
		AC.AccountUid=OIA2.AccountUid
	AND
		OIA2.DISPLAYORDER=2








' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindWaitingListDetail]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewFindWaitingListDetail] AS
SELECT	rwlwld.WaitingListDetailUid, wld.ExternalID, pp.FullName AS PatientName, 
		ISNULL(wld.Phone, pp.Phone1) AS Phone,
		ISNULL(wld.Phone.value(''(Phone/PhoneNumber)[1]'', ''VARCHAR(50)''), pp.PhoneNumber) AS PhoneNumber,
		ISNULL(wld.Phone.value(''(Phone/PhoneNumber)[1]'', ''VARCHAR(50)''), pp.PhoneTypeName) AS PhoneType,
		wld.StartDateTime, wld.EndDateTime, lat.Name AS AppointmentType, lwlp.Name AS PriorityDescription,
		lwlp.Priority, 
		dbo.UDF_getFormattedInternalName(ppv.FirstName, ppv.MiddleName, ppv.LastName, ppv.AkaFirstName, ppv.AkaLastName) AS ProviderName, 
		lss.Name AS ServiceSiteName, wld.Inactive, convert(varchar(8000),wld.Notes) as Notes,
		wld.ExpiredOn, rwlwld.RelWaitingListWaitingListDetailUid, rwlwld.WaitingListUid, wld.PatientUid,
		wld.ProviderUid, wld.AppointmentTypeUid, wld.WaitingListPriorityUid, wld.ServiceSiteUid, lwlp.Color,
		wld.AppointmentUid, lat.Color AS ApptTypeColor, pp.Birthdate, pp.MedicalRecordNumber
FROM	RelWaitingListWaitingListDetail AS rwlwld
		INNER JOIN WaitingList AS wl ON rwlwld.WaitingListUId = wl.WaitingListUid
		INNER JOIN WaitingListDetail AS wld ON rwlwld.WaitingListDetailUid = wld.WaitingListDetailUid
		INNER JOIN ViewFindPatient AS pp ON wld.PatientUid = pp.PersonUid
		LEFT JOIN ViewProvider AS ppv ON wld.ProviderUid = ppv.PersonUid
		LEFT JOIN ListAppointmentType AS lat ON wld.AppointmentTypeUid = lat.AppointmentTypeUid
		LEFT JOIN ListWaitingListPriority AS lwlp ON wld.WaitingListPriorityUid = lwlp.WaitingListPriorityUid
		LEFT JOIN ListServiceSite AS lss ON wld.ServiceSiteUid = lss.ServiceSiteUid
		LEFT JOIN Appointment AS a ON wld.AppointmentUid = a.AppointmentUid






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewVisitsWithoutSuperbill]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewVisitsWithoutSuperbill]
AS

WITH cteVisitLockInfo AS
(
	SELECT LSV.VisitUid, ROW_NUMBER() OVER (PARTITION BY LSV.VisitUid ORDER BY LSV.LockDateStart) AS RowNo, 
	LSV.LockUid, PNS.FullName, LSV.HostName, LSV.LockDate, LSV.LockDateStart 
	FROM
	(
		SELECT VS.VisitUid, L.LockByUid,
		L.LockUid, L.HostName, L.LockDate, L.LockDateStart
		FROM Lock L
		INNER JOIN Visit VS ON L.LockedUid = VS.VisitUid
		UNION
		SELECT VS.VisitUid, L.LockByUid,
		L.LockUid, L.HostName, L.LockDate, L.LockDateStart
		FROM Lock L
		INNER JOIN Visit VS ON L.LockedUid = VS.VisitUid
	) LSV
	INNER JOIN ViewPerson PNS ON LSV.LockByUid = PNS.PersonUid
)


SELECT v.VisitUid, v.PatientUid, v.SuperbillRequired, v.VisitDate, v.RenderingProviderUid, v.Provideruid as BillingProviderUid, v.ServiceSiteUid, pp.LastName + '', '' + pp.FirstName AS PatientName,
                       dbo.UDF_getFormattedInternalName(pu.FirstName, pu.MiddleName, pu.LastName, pu.AkaFirstName, pu.AkaLastName) AS RenderingProviderName, 
                       dbo.UDF_getFormattedInternalName(bu.FirstName, bu.MiddleName, bu.LastName, bu.AkaFirstName, bu.AkaLastName) AS BillingProviderName, 
                       ss.Name AS ServiceSiteName, 
                      CASE v.IsCompleted WHEN 1 THEN ''Completed'' ELSE ''Incomplete'' END AS VisitStatus, v.IsCompleted, 
                      v.FinancialCenterUid, ISNULL(fc.name,''<Unknown>'') AS FinancialCenterName, VisitTypeUid,
                      VLI.LockUid, VLI.FullName AS LockedByUserName, VLI.HostName AS LockedByHostName,
					  VLI.LockDate AS LockedDate, VLI.LockDateStart AS LockedDateStart                      
FROM Visit v
	INNER JOIN ListClinicalNoteType CVNT ON V.ClinicalNoteTypeUid = CVNT.ClinicalNoteTypeUid
	LEFT JOIN Superbill sb ON v.VisitUid = sb.VisitUid 
	LEFT JOIN Person pu ON v.RenderingProviderUid = pu.PersonUid
	LEFT JOIN Person bu ON v.Provideruid = bu.PersonUid
	LEFT JOIN Person  pp ON v.PatientUid = pp.PersonUid
	LEFT JOIN ListServiceSite ss on v.ServiceSiteUid = ss.ServiceSiteUid
	LEFT JOIN FinancialCenter fc on v.FinancialCenterUid = fc.FinancialCenterUid
	LEFT JOIN cteVisitLockInfo VLI ON v.VisitUid = VLI.VisitUid AND VLI.RowNo = 1
WHERE sb.VisitUid IS NULL AND CVNT.HasServicesPerformed = 1





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[View_RPT2_PracticeSnapshotReport]'))
EXEC dbo.sp_executesql @statement = N'

--05/03/2018 Chayes: corrected age in years logic. bug 1947

CREATE VIEW [dbo].[View_RPT2_PracticeSnapshotReport] 
AS
Select 
		--PATIENT	
		isnull(PAT.ExternalId,'''') as ExternalID,        
		P.PersonUID as PatientUID,     
		--dbo.UDF_getFormattedPreferredName(P.PersonUID) as PatientName,      
		patientName.FormattedPreferredName as PatientName,
		P.FirstName,      
		P.LastName,        
		P.BirthDate,        
		--DateDiff(Year,P.BirthDate,getdate()) as AgeYears,        
		FLOOR(DATEDIFF(DAY, P.Birthdate, GETUTCDATE()) / 365.25) as AgeYears,
		DateDiff(Month,P.BirthDate,getdate()) as AgeMonths,        
		LG.GenderUID,    
		isnull(LG.Name,'''') as Sex,    
		ISNULL(P.Computed_Address1_Address1,'''')+ '' ''+ISNULL(P.Computed_Address1_Address2,'''') as PatientAddress,   
		ISNULL(P.Computed_Address1_City,'''') as City,
		ISNULL(P.Computed_Address1_State,'''') as [State],
		ISNULL(P.Computed_Address1_Zip,'''') as ZipCode,
		Coalesce(P.Computed_Phone1_PhoneNumber,p.Computed_Phone2_PhoneNumber,p.Computed_Phone3_PhoneNumber) as PhoneNumber,

		--(isnull(p.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') + '' '' + isnull(p.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''')) as PatientAddress,        
		--isnull(p.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''') as City,      
		--isnull(p.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') as [State],      
		--isnull(p.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') as ZipCode,      
		--isnull(p.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''),'''') as PhoneNumber,
		isnull(p.Email1,'''') as Email,     
		LA.AccountTypeUID,       
		isnull(LA.Name,'''') as AccountType,       
		C.CorporationUID,        
		isnull(C.Name,'''') as InsurancePayer,        
		IPlan.InsurancePlanUID,        
		isnull(IPlan.Name,'''') as InsurancePlan,    
		(CASE WHEN PAT.Inactive=1 Then 0 ELSE 1 END) AS Active, -- 0 - Inactive 1- Active    
		(Case When (P.DeathDate IS NULL) Then 0 Else 1 End) as Deceased,  -- 0 - N and 1 -Y    
		isnull(PP.PlanMemberID,'''') as MemberID,    
		--AC.AccountUid AS AccountUid,
		---Superbill	
		--AR.ARcontextUID,
		SP.SuperbillUid,
		isnull(SP.ExternalID,''Account'') as A3SuperBillID,
		SP.PatientUID as A3PatientUID,
		LGP.ProcedureGroupUID,    
		isnull(LGP.Name,'''') as ProcedureGroup,    
		LP.ProcedureUID,  
		isnull(LP.Code,'''') as CPTCode,
		SBP.Units as ChargeUnits,
		SBP.Units as AdjustmentUnits,
		SBP.Units as ReceiptUnits,
		SBP.Units as RefundUnits,
		--			   (Select Max(Ch.GLDate) From Charge Ch JOIN ARContext AR on AR.ARContextUID=Ch.ARContextUID Where AR.SuperBIllUID=SP.SuperBillUID) as GLDate,
		ARB.GLDate,
		SP.ServiceDateStart,  
		SP.ServiceDateEnd,
		LST.ServiceSiteTypeUID,  
		LST.Name as PlaceOfServiceCode,  
		LS.ServiceSiteUID,  
		isnull(LS.Name,'''') as ServiceSite,    
		isnull(SP.ExternalID,'''') as SuperBillID,
		SB.RenderingProviderUID,  
		--dbo.UDF_getFormattedPreferredName(SB.RenderingProviderUID) as RenderingProvider,   
		renderingName.FormattedPreferredName as RenderingProvider,
		SB.ClaimingProviderUID as BillingProviderUID,      
		--dbo.UDF_getFormattedPreferredName(SB.ClaimingProviderUID) as BillingProvider,
		billingName.FormattedPreferredName as BillingProvider,
		SP.AccountUid,
		SBP.SuperbillProcedureUid,
		SPB.IsBatchClosed AS IsBatchClosed,
		SP.VisitUid AS VisitUid 
	From
		Superbill(NOLOCK) SP
	JOIN
		[ViewSuperbillFinancialDetails] SB
	ON
		SP.SuperbillUid =SB.SuperbillUid 
	JOIN
		viewSuperbillProcedure SBP    
	on    
		SBP.SuperbillUID=SP.SuperbillUID  AND SBP.Inactive = 0
	JOIN
		[MDOL_RPT2_VIEW_SuperbillProcedureBatch] SPB
	ON
		SBP.SuperbillProcedureUid = SPB.SuperbillProcedureUid			
	--LEFT JOIN
	--	[AR_ViewSuperbillProcedureBatch] VSPB
	--ON
	--	SBP.SuperbillProcedureUid  =VSPB.SuperbillProcedureUid
	INNER JOIN
		ARBatch(NOLOCK) ARB
	ON
		ARB.ARBatchUid=SBP.ARBatchUid
	JOIN
		Patient(NOLOCK) PAT        
	ON
		SP.PatientUid=PAT.PersonUID		
	JOIN        
		Person(NOLOCK) P        
	on        
		PAT.PersonUID=P.PersonUID        
	LEFT JOIN        
		ListGender(NOLOCK) LG        
	on        
		LG.GenderUID=P.GenderUID        
	LEFT JOIN        
		Account(NOLOCK) AC        
	on        
		Ac.PersonUID=P.PersonUID AND AC.IsMain=1        
	LEFT JOIN        
		AccountPeriod(NOLOCK) AP        
	on        
		AP.AccountUID=Ac.AccountUID         
	AND     
		((AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NULL AND AP.effectiveDate  <= GETUTCDATE() ) 
		OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NOT NULL AND AP.expirationDate >= GETUTCDATE())     
		OR (AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NOT NULL AND AP.effectiveDate <= GETUTCDATE() AND AP.expirationDate >= GETUTCDATE())     
		OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NULL))    
	LEFT JOIN        
		AccountInsurance(NOLOCK) AI        
	on        
		AI.AccountPeriodUID=AP.AccountPeriodUID AND AI.DisplayOrder=1        
	LEFT JOIN        
		PersonInsurancePlan(NOLOCK) PP        
	on        
		Pp.PersonInsurancePlanUID=AI.PersonInsurancePlanUID        
	LEFT JOIN        
		InsurancePlan(NOLOCK) IPlan        
	on         
		IPlan.InsurancePlanUID=PP.InsurancePlanUID        
	LEFT JOIN        
		Corporation(NOLOCK) C        
	on        
		C.CorporationUID=Iplan.InsuranceCarrierUID        
	LEFT JOIN        
		InsuranceCarrier(NOLOCK) IC        
	on        
		IC.CorporationUID=C.CorporationUID        
	LEFT JOIN        
		ListAccountType(NOLOCK) LA        
	on        
		LA.AccountTypeUID=IC.AccountTypeUID     
	LEFT JOIN    
		ListServiceSite(NOLOCK) LS    
	on    
		LS.ServiceSiteUID=SB.SErviceSiteUID  
	LEFT JOIN  
		ListServiceSiteType(NOLOCK) LST  
	on   
		Ls.ServiceSiteTypeUID = LST.ServiceSiteTypeUID 
	LEFT JOIN
		ListProcedure(NOLOCK) LP    
	on    
		LP.ProcedureUID=SBP.ProcedureUID    
	LEFT JOIN
		ListProcedureGroup(NOLOCK) LGP    
	on    
		LGP.ProcedureGroupUID=LP.ProcedureGroupUID 
	LEFT JOIN 
		ViewPerson patientName on patientName.PersonUid = p.PersonUid
	LEFT JOIN 
		ViewPerson renderingName on renderingName.PersonUid = sb.RenderingProviderUid
	LEFT JOIN 
		ViewPerson billingName on billingName.PersonUid = sb.ClaimingProviderUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_AdjustmentDetail]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[MDOL_RPT2_View_AdjustmentDetail]  
AS  
 SELECT  
  ISNULL(LD.Amount,0) as Adjustment,    
  coalesce(LCT1.Name,''Without Adjustment Type'') as TransactionName,  
  LD.IncomeAccountUid as CreditTypeUid,
  AB.GLDate,    
  D.DepositDate,  
  --CR.CreditUID, 
  LD.LedgerDetailUid as CreditUID,
  ISNULL(SB.ExternalID,''ACCOUNT'') as ExternalID,  
  SB.ServiceDateEnd,    
  LD.RenderingProviderUid as RenderingProviderUID,  
  ISNULL(LD.ClaimingProviderUID,LD.RenderingProviderUid) as ClaimingProviderUID,  
  ISNULL(SB.PatientUID,A.PersonUid) as PatientUid,  
  LP.Code AS ShortDescription,  
  LD.RenderingProviderUid AS ProviderUid,     
  LD.FinancialCenterUID,   
 IC.CorporationUID as InsuranceCarrierUid,  
 IC.Name as InsuranceCarrierName,
 CASE WHEN VARB.IsClosed =1 THEN 1 ELSE 0 END AS IsBatchClosed  
 FROM    
	AR_Ledger L WITH(NOLOCK)
INNER JOIN
	AR_LedgerDetail LD WITH(NOLOCK)
ON
	L.LedgerUid=LD.LedgerUid AND L.EntryType=3  AND LD.SuperbillProcedureUid IS NOT NULL --AND LD.IsCredit=1
INNER JOIN
		AR_ViewBatchClosingsLockedClosed VARB WITH(NOLOCK)
ON
		L.ArBatchUid =VARB.ARBatchUid	
LEFT JOIN
	AR_Transaction T WITH(NOLOCK)
ON
	L.TransactionUid = T.TransactionUid 
left JOIN    
	ListCreditType LCT1   WITH(NOLOCK)
ON
	LD.IncomeAccountUid =LCT1.CreditTypeUid 
LEFT JOIN 
	ARBatch AB  WITH(NOLOCK)
ON 
	L.ArBatchUid = AB.ARBatchUid
LEFT JOIN    
    ViewDeposit D     WITH(NOLOCK)
ON    
    D.DepositUID=T.DepositUID 
LEFT JOIN
	SuperbillProcedure SBP WITH(NOLOCK)
ON 
	LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid 
LEFT JOIN    
    Superbill SB     WITH(NOLOCK)
ON    
    SB.SuperbillUID=SBP.SuperbillUID    
LEFT JOIN  
    ACCOUNT A   WITH(NOLOCK)
ON   
    A.AccountUid=SB.AccountUID  
LEFT JOIN  
    Corporation IC   WITH(NOLOCK)
ON   
    IC.CorporationUid=D.WhoPaidInsuranceCarrierUid 
LEFT JOIN
	ListProcedure LP WITH(NOLOCK)
ON
	SBP.ProcedureUid = LP.ProcedureUid 
 --WHERE    
 -- LCT1.IsPayment=0    


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSecuritySecurityGroup]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSecuritySecurityGroup]
AS
SELECT     SecurityUid AS Uid, ExternalId, Name, Notes, s.SecurityUid, SecurityGroupUid, s.Name AS SecurityName, Id AS SecurityId, Inactive, 
                      0 AS ForeignKeyIndex
FROM         dbo.ListSecurity s
UNION ALL
SELECT     f.FindTableUid AS Uid, f.ExternalId, f.Name, f.Notes, s.SecurityUid, f.SecurityGroupUid, s.Name AS SecurityName, s.Id AS SecurityId, f.Inactive, 
                      1 AS ForeignKeyIndex
FROM         ListFindTable f INNER JOIN
                      ListSecurity s ON s.Id = ''listeditorobjects''
WHERE     f.AllowMaintenance = 1 AND f.HasSecurity = 1
UNION ALL
SELECT     r.ReportUid AS Uid, r.ExternalId, r.Name, r.Notes, s.SecurityUid, r.SecurityGroupUid, s.Name AS SecurityName, s.Id AS SecurityId, r.Inactive, 
                      1 AS ForeignKeyIndex
FROM         ListReport r INNER JOIN
                      ListSecurity s ON s.Id = ''listreportobjects''
WHERE     r.AllowMaintenance = 1 AND r.HasSecurity = 1
UNION ALL
SELECT     f.FilterUid AS Uid, f.ExternalId, f.Name, f.Notes, s.SecurityUid, f.SecurityGroupUid, s.Name AS SecurityName, s.Id AS SecurityId, f.Inactive, 
                      1 AS ForeignKeyIndex
FROM         ListFilter f INNER JOIN
                      ListSecurity s ON s.Id = ''listfilterobjects''
WHERE     f.AllowMaintenance = 1 AND f.HasSecurity = 1





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSecurityGroupList_SR]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewSecurityGroupList_SR]
AS
SELECT     
			s.Uid AS Uid, 
			s.Name, 
			sg.Name AS SecurityGroup,
			sg.Permission AS PermissionMask,
			s.SecurityUid,
			s.SecurityId AS Id,
			0 AS ObjectSecurity,sg.SecurityGroupUid,
			(Select Count(*) from ListSecurity where SecurityUID=S.UID) as ListSecurity
FROM        
			dbo.ViewSecuritySecurityGroup s 
INNER JOIN
            dbo.ListSecurityGroup sg 
ON
			s.SecurityGroupUid = sg.SecurityGroupUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_StatementResponsibleParty]'))
EXEC dbo.sp_executesql @statement = N'




-- 20150924 kculberth incorporate performance improvements by utilizing StatementBatchDetailUid to narrow dataset and moving dunning logic to Header
--20160217  kculberth change NOLOCKs to WITH NOLOCKs

CREATE VIEW [dbo].[MDOL_RPT2_VIEW_StatementResponsibleParty]
AS 

/*	This is the source for electronic statements and also for paper statements, indirectly via
	the stored proc MDOL_RPT2_StatementHeader/ One record per responsible party with active accounts.

	01/28/2008 - Qatalys - #12798 - Modified Balance with BalanceAll
	05/19/2008 - Qatalys - #13325 - Added Financial Center 
	01/22/2009 - Qatalys		  - Modified to replace PersonBalanceAll,AccountBalanceAll of Account
	11/02/2009 - KBernecker       - Modified total balance if breaking statements by Financial Center
	02/18/2011 - Qatalys     Bug # 2943 - Modified to include new feature closed or complete batch item only
	08/02/2011 - KBernecker - branched off from ViewStatementResponsibleParty to clean up performance problems.
	12/02/2011 - KBernecker - Modified to sort by RPLastname, RPFirstname instead of RPName.
	09/22/2013 - KBernecker - modified to use  AR_ViewAccountResponsiblePartyAggregate_SumAccountLiabilities_Filter
	12/6/2013  - KBernecker - modified to check for existance of dunning messages before calculating the age of the superbill procedures
	09/16/2014 - KCulberth - modified to check for duplicate 
	01/15/2015 - KCulberth - move dunningmsg logic and getsuperbillofresponsiblelparty to MDOL_RPT2_StatementHeader
     20151102  - kculberth  - Fix bug 40187. Get ResponsiblePartyName from person table instead of view.							   
								ViewStatementResponsiblePartyByFinancialCenter is used by the Create Statements UI, and cannot be changed 
								because the format is lastname, firstname, middle name. The UI needs that format.						   
								The statement needs firstname middle name lastname, suffix.											  
*/


SELECT DISTINCT --top 1000
	arp.AccountResponsiblePartyUid as RPUid, 
	''00000000-0000-0000-0000-000000000000''  as FinancialCenterUid, 
	ps.Name as CustomerName, 
	--ps.MainAddress as CustomerAddress, 
	ISNULL(ps.MainAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''')  AS CustomerAddress1, 
	ISNULL(ps.MainAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''')  AS CustomerAddress2, 
	ISNULL(ps.MainAddress.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''')  AS CustomerCity, 
	ISNULL(ps.MainAddress.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''')  AS CustomerState, 
	ISNULL(ps.MainAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''')  AS CustomerZip, 
	ISNULL(ps.MainAddress.value(''(/Address/Country)[1]'', ''VARCHAR(100)''),'''')  AS CustomerCountry, 
	ISNULL(ps.MainPhone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)''),'''')  AS CustomerPhone, 
	ps.Name as RemitToName, 	
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToAddress1, 
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToAddress2, 
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToCity, 
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToState, 
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToZip, 	
	(CASE WHEN (ps.BillingAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')!='''' OR ps.BillingAddress.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')!='''') THEN COALESCE(ps.BillingAddress.value(''(/Address/Country)[1]'', ''VARCHAR(100)''),'''') ELSE COALESCE(ps.MainAddress.value(''(/Address/Country)[1]'', ''VARCHAR(100)''),'''') END)  as RemitToCountry,  	
	arp.ExternalID as RPID,
	p.LastName as RPLastname,
	p.FirstName as RPFirstname,
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(P.FirstName,'''') + (case when p.MiddleName is null then ''''else '' '' + p.MiddleName END) +'' ''+ ISNULL(p.LastName,'''') + (case when p.Suffix is null then '''' else '', '' + p.suffix end)  ELSE c.Name END AS RPName,  
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''), '''') END AS RPAddress1,
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''), '''') END AS RPAddress2,
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/City)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)''), '''') END AS RPCity,
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/State)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''), '''') END AS RPState,
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''), '''') END AS RPZip,
	CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Country)[1]'', ''VARCHAR(100)''), '''') ELSE ISNULL(c.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)''), '''') END AS RPCountry,	
	cast(convert(varchar, getutcDate(), 101) AS datetime) as StatementDate,
	cast(convert(varchar, DATEADD(day, ps.StatementDueDays, getutcDate()), 101) AS datetime) as DueDate,
	ps.StatementMinimumAmount  AS StatementMinimumAmount,
	VA.LiabilityBalance - VA.AssignedLiabilityBalance AS AmountDue,
	VA.LiabilityBalance as TotalBalance, 
	VA.AssignedLiabilityBalance as InsuranceBalance, 
	ps.StatementFooter  AS StatementFooter	 
	FROM	Account a WITH (NOLOCK)
	INNER JOIN AccountResponsibleParty arp WITH (NOLOCK) ON a.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid 
	INNER JOIN AR_ViewAccountResponsiblePartyAggregate_SumAccountLiabilities_Filter VA WITH (NOLOCK) ON arp.AccountResponsiblePartyUid=VA.AccountResponsiblePartyUid
	LEFT JOIN Person p WITH (NOLOCK) ON p.PersonUid = arp.PersonUid 
	LEFT JOIN Corporation c WITH (NOLOCK) ON c.CorporationUid = arp.CorporationUid,
	PracticeSettings ps WITH (NOLOCK)
	--,cte_dunningmsg
WHERE a.Inactive=0 








' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VIEW_SecurityGroup]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[VIEW_SecurityGroup]
AS
	Select distinct
			A.[SecurityGroup] as  SecurityGroup,/* [SecurityGroup], */
			A.[Name] + (Case(A.ListSecurity) When 1 then '' (S)'' else '' (F)'' end) as FunctionName, /*[Function], */
			Z.Name as UserName,
			Z.UserGroupType as UserGroupType, 
			A.UID as GroupID,
			Z.UID as UserID,
			B.Permission,
			A.PermissionMask,
			B.LastModifiedDate,
			Z.UID,
			A.SecurityGroupUID
	From    
			ViewSecurityGroupList_SR A
	JOIN	
			SecurityUserGroup B
	ON
			B.ObjectUId=A.UID
	JOIN
			ViewFindUserAndUserGroup Z
	ON
			(B.UserPRMUId=Z.UID or B.UserGroupUId=Z.UID)
	Where
			((B.ParentObjectUID is null And A.ListSecurity=1)
			OR
			(A.ListSecurity=0))

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientDxHistoryDisease]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewPatientDxHistoryDisease]  
	AS
		SELECT 
			ListDisease.DiseaseUid,
			ppdh.PatientUid,
			COUNT_BIG(*) AS [RowID]
		FROM [dbo].PatientProblemDiagnosisHistory ppdh
			join [dbo].ListProblemStatus lps ON ppdh.ProblemStatusUid = lps.ProblemStatusUid  
			JOIN [dbo].RelDiagnosisDisease ON RelDiagnosisDisease.Code9 = ppdh.Code9  
			JOIN [dbo].ListDiagnosis ON ListDiagnosis.DiagnosisCode9 = RelDiagnosisDisease.Code9  
					AND ListDiagnosis.Inactive = 0
			JOIN [dbo].ListDisease ON ListDisease.DiseaseUid = RelDiagnosisDisease.DiseaseUid 
					AND ListDisease.Inactive = 0
		WHERE  ppdh.IsPatientProblem = 0
				AND ppdh.InactiveDate IS NULL	
				AND ppdh.IsDelete = 0
				AND lps.ActiveStatus = 1
		GROUP BY
			ListDisease.DiseaseUid,
			ppdh.PatientUid

		--IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N''[dbo].[ViewPatientDxHistoryDisease]'') AND name = N''IX_ViewPatientDxHistoryDisease'')
		--	CREATE UNIQUE CLUSTERED INDEX [IX_ViewPatientDxHistoryDisease] ON [dbo].[ViewPatientDxHistoryDisease]
		--	(
		--		[DiseaseUid] ASC,
		--		[PatientUid] ASC
		--	) ON [PRIMARY]

		--IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N''GenerateEntityObject'' , N''SCHEMA'',N''dbo'', N''VIEW'',N''ViewPatientDxHistoryDisease'', NULL,NULL))
		--	EXEC sys.sp_addextendedproperty @name=N''GenerateEntityObject'', @value=N''false'' , @level0type=N''SCHEMA'',@level0name=N''dbo'', @level1type=N''VIEW'',@level1name=N''ViewPatientDxHistoryDisease''
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientProblemDisease]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewPatientProblemDisease]  
	AS
		SELECT  
			ppdh.DiseaseUid,
			ppdh.PatientUid,
			COUNT_BIG(*) AS [RowID]
		FROM    
				[dbo].PatientProblemDiagnosisHistory ppdh JOIN 
				[dbo].ListProblemStatus lps ON ppdh.ProblemStatusUid = lps.ProblemStatusUid 
		WHERE   ppdh.IsPatientProblem = 1
				AND ppdh.InactiveDate IS NULL	
				AND ppdh.IsDelete = 0
				AND lps.ActiveStatus = 1
		GROUP BY
			ppdh.DiseaseUid,
			ppdh.PatientUid

			--IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N''[dbo].[ViewPatientProblemDisease]'') AND name = N''IX_ViewPatientProblemDisease'')
			--CREATE UNIQUE CLUSTERED INDEX [IX_ViewPatientProblemDisease] ON [dbo].[ViewPatientProblemDisease]
			--(
			--	[DiseaseUid] ASC,
			--	[PatientUid] ASC
			--) ON [PRIMARY]

			--IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N''GenerateEntityObject'' , N''SCHEMA'',N''dbo'', N''VIEW'',N''ViewPatientProblemDisease'', NULL,NULL))
			--EXEC sys.sp_addextendedproperty @name=N''GenerateEntityObject'', @value=N''false'' , @level0type=N''SCHEMA'',@level0name=N''dbo'', @level1type=N''VIEW'',@level1name=N''ViewPatientProblemDisease''
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewCDSPatientDisease]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewCDSPatientDisease] 
	AS
	SELECT [DiseaseUid], [PatientUid]
	FROM [ViewPatientDxHistoryDisease]
	UNION
	SELECT [DiseaseUid], [PatientUid]
	FROM [ViewPatientProblemDisease]
	

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientCCMCPO]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewPatientCCMCPO] AS
SELECT   
	pcm.PatientCareManagementUid,  
	pcm.PatientUid,  
	pat.FormattedPreferredName AS PatientName,  
	pcm.Location,  
	pcm.EffectiveDate,  
	pcm.ExpirationDate,   
	pcm.Notes,    
	pcm.CareTypeUid,  
	lm.Val AS CareType,    
	pcm.ProviderUid,  
	dbo.GetPatientCareManagementNames(pcm.PatientCareManagementUid, 1) AS ProviderNames,    
	dbo.GetPatientCareManagementNames(pcm.PatientCareManagementUid, 0) AS DiagnosisNames,  
	pcm.MedicalServicesProviderUid,
	msp.Name AS MSPName,
	mspRole.Name AS MSPRoleName
FROM  
	PatientCareManagement(NOLOCK)  pcm     
		INNER JOIN ViewPerson pat   
			ON pcm.PatientUid = pat.PersonUid    
		LEFT JOIN ListMisc(NOLOCK) lm 
			ON pcm.CareTypeUid = lm.MiscUid 
		LEFT JOIN Corporation(NOLOCK) msp 
			ON pcm.MedicalServicesProviderUid = msp.CorporationUid
		LEFT JOIN PatientProviderRelationship(NOLOCK) ppr 
			ON ppr.PatientUid = pcm.PatientUid AND ppr.MedicalServicesProviderUid = pcm.MedicalServicesProviderUid
				AND (pcm.EffectiveDate IS NULL OR (ppr.CareTypeActiveFrom IS NULL OR pcm.EffectiveDate >= ppr.CareTypeActiveFrom))
				AND (pcm.ExpirationDate IS NULL OR (ppr.CareTypeActiveUntil IS NULL OR pcm.ExpirationDate <= ppr.CareTypeActiveUntil))
		LEFT JOIN ListProviderCareType(NOLOCK) mspRole 
			ON mspRole.ProviderCareTypeUid = ppr.ProviderCareTypeUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillDiagnosis]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewSuperbillDiagnosis]
AS
SELECT SuperbillDiagnosisUid, SuperbillUid, dbo.Diagnosis_GetCode(Code9, Code10) AS Code,
		Code9, Code10, CodeDescription, dbo.Diagnosis_GetFullDescription(Code9, Code10, CodeDescription) AS FullDescription,
		DisplayOrder, LastModifiedDate, LastModifiedByUid
	FROM SuperbillDiagnosis


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillDiags]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbillDiags]
AS
SELECT
	Superbill.SuperbillUid,
	sd1.Code9 AS diagnosis1, 
	sd2.Code9 AS diagnosis2, 
	sd3.Code9 AS diagnosis3, 
	sd4.Code9 AS diagnosis4

FROM Superbill 

	LEFT JOIN ViewSuperBillDiagnosis sd1 ON Superbill.SuperbillUid = sd1.SuperbillUid AND sd1.DisplayOrder = 1
	LEFT JOIN ViewSuperBillDiagnosis sd2 ON Superbill.SuperbillUid = sd2.SuperbillUid AND sd2.DisplayOrder = 2
	LEFT JOIN ViewSuperBillDiagnosis sd3 ON Superbill.SuperbillUid = sd3.SuperbillUid AND sd3.DisplayOrder = 3
	LEFT JOIN ViewSuperBillDiagnosis sd4 ON Superbill.SuperbillUid = sd4.SuperbillUid AND sd4.DisplayOrder = 4

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_Appointment]'))
EXEC dbo.sp_executesql @statement = N'



CREATE View [dbo].[MDOL_RPT2_View_Appointment]
AS
/*
	02/11/2008	- Qatalys - To fix Appointment time error
	08/11/2014 - Pancratius Modified StartDatetime function to dbo.UDF_UTCTOCurrentDate
	11/11/2014 - kculberth Add Phone Number
	20150817 kdc add billingprovideruid
*/

Select 
   C.[Name] as ''PayerName'',
   IP.[Name] as ''PlanName'',	
   LAT.[Name] as ''AccountType'',
   A.AppointmentUID,   
   A.AppointmentTypeUID,   
   LT.Name as AppointmentType,  
   A.AppointmentStatusUID,  
   LAS.Name as AppointmentStatus,  
   A.CalendarUID,  
   LC.Name as CalendarName,  
   PatientUID,  
   dbo.UDF_getFormattedPreferredName(PatientUID) Patient,
   COALESCE(P.Phone1, P.Phone2, P.Phone3, P.Phone4).value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') AS PhoneNumber,
   A.BillingProviderUid as BillingProviderUid,
   dbo.UDF_getFormattedPreferredName(A.BillingProviderUid) as BillingProvider,   
   A.ProviderUID as ProviderUid,  
   dbo.UDF_getFormattedPreferredName(A.ProviderUid) as  Provider,   
   dbo.udf_UTCToCurrentDate(StartDateTime) AS StartDateTime,  
   EndDateTime,  
   A.Reason,
   P.BirthDate,
   Pat.ExternalID As ID,
   A.ServiceSiteUid,
   LSS.Name as ServiceSite,
   LRS.ReferralSrcUid,
   LRS.Name AS ReferralSource
 FROM  ViewAppointmentWithGroup A WITH(NOLOCK)  
 Left Join	Person P WITH (NOLOCK) ON A.Patientuid=P.Personuid
 Left Join 	Patient Pat WITH (NOLOCK) ON A.PatientUid=pat.PersonUid	
 Left join ListCalendar LC WITH (NOLOCK) ON a.CalendarUid = LC.CalendarUid AND LC.Inactive = 0  
 Left Join ListAppointmentStatus LAS WITH (NOLOCK) ON A.AppointmentStatusUid = LAS.AppointmentStatusUid   
 Left Join ListAppointmentType LT WITH (NOLOCK) ON A.AppointmentTypeUid = LT.AppointmentTypeUid  
 LEFT JOIN Account AS AC WITH (NOLOCK) ON AC.Personuid = A.Patientuid AND  AC.AccountUid=A.AccountUid --  AC.IsMain=1
 LEFT JOIN  dbo.AccountPeriod AS AP WITH (NOLOCK) ON AC.AccountUid = AP.AccountUid   
	--AND ((AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(GETDATE() AS DATE))
 --   OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.expirationDate AS DATE) >=CAST(GETDATE() AS DATE)) 
 --   OR (AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(GETDATE() AS DATE) AND CAST(AP.expirationDate AS DATE) >= CAST(GETDATE() AS DATE)) 
 --   OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NULL)) 
     AND ((AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(A.Startdatetime AS DATE))
    OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.expirationDate AS DATE) >= CAST(A.Startdatetime AS DATE)) 
    OR (AP.effectiveDate IS NOT NULL AND AP.ExpirationDate IS NOT NULL AND CAST(AP.effectiveDate AS DATE) <= CAST(A.Startdatetime AS DATE) AND CAST(AP.expirationDate AS DATE) >= CAST(A.Startdatetime AS DATE)) 
    OR (AP.effectiveDate IS NULL AND AP.ExpirationDate IS NULL))      
       
 LEFT JOIN AccountInsurance AS AI WITH (NOLOCK) ON AI.AccountPeriodUid = AP.AccountPeriodUid AND AI.DisplayOrder=1  
 LEFT JOIN PersonInsurancePlan AS PIP WITH (NOLOCK) ON PIP.PersonInsurancePlanUid = AI.PersonInsurancePlanUid   
 LEFT JOIN dbo.InsurancePlan AS IP WITH (NOLOCK) ON IP.InsurancePlanUid = PIP.InsurancePlanUid  
 LEFT JOIN Corporation C WITH (NOLOCK) ON	C.CorporationUid = IP.InsuranceCarrierUid 
 LEFT JOIN ListAccountType LAT WITH (NOLOCK) ON AP.AccountTypeuid = LAT.AccountTypeuid
 LEFT JOIN ListServiceSite LSS WITH (NOLOCK) ON A.ServiceSiteUid = LSS.ServiceSiteUid
LEFT JOIN ListReferralSrc LRS WITH (NOLOCK) ON A.ReferralSrcUid = LRS.ReferralSrcUid 
-- Where
-- Where
--	AC.IsMain=1
--	AND 
--	AI.DisplayOrder=1
  





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementLineItem_MainAccount]'))
EXEC dbo.sp_executesql @statement = N'



--20150109 - kculberth - add statement notes from reason codes - bug 33625
--20161018 - kculberth - update for new statement batch model
--02/02/2017 - kculberth - Bug 51825:Statements-CHC Payer Setting Encounter codes need to print on statement if there is a patient liability for this code.

CREATE VIEW [dbo].[ViewStatementLineItem_MainAccount]  
AS 

--NEW
WITH cteWhoPaidName --Stolen from ViewDeposit
AS
-- Define the CTE query.
(
SELECT d.deposituid,
      ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumber, -- mark as <ND> so can hyperlink on null values
      (CASE WHEN p.PersonUid IS NOT NULL THEN p1.FormattedPreferredName
       WHEN icArp.CorporationUid IS NOT NULL THEN icArp.Name
       WHEN LD.InsurancePayerUid IS NOT NULL THEN ic.Name END) AS WhoPaidName,
       L.EntryType  
FROM Deposit d
            INNER JOIN AR_LedgerDetail (NOLOCK) LD ON d.DepositUid = LD.DepositUid
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid
            LEFT OUTER JOIN AR_Ledger (NOLOCK) arlVoid on L.LedgerUid = arlVoid.VoidLedgerUid      -- Checks for voiding entries                                       
            LEFT JOIN AccountResponsibleParty (NOLOCK) arp on LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid            
            LEFT JOIN Person (NOLOCK) p ON arp.PersonUid = p.PersonUid 
            LEFT JOIN Corporation (NOLOCK) icArp ON arp.CorporationUid = icArp.CorporationUid
            LEFT JOIN Corporation (NOLOCK) ic ON ic.CorporationUid = LD.InsurancePayerUid 
            LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = p.PersonUid              
WHERE (L.EntryType = 0 -- Payment
	   OR L.EntryType = 3) -- Adjustment
       AND  (L.VoidLedgerUid IS NULL AND arlVoid.LedgerUid IS NULL) -- Don''t include reversing(void) entries
       AND LD.IsCredit = 1                                              
       AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits    
),

cteLastFiledDate --
AS
-- Define the CTE query.
(
	SELECT SA.SuperbillUid,SA.LastFiledDate
	FROM SuperbillAggregate SA
)
SELECT distinct
	FinancialCenterUid,  
	ItemUid,   
	RPUid,     
	''Header'' AS Type, 
	2 AS DisplayOrder, 
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	NULL AS ItemDate,   
	NULL AS CreditGroupUid,   
	0 AS IsPayment,   
	NULL AS CreditUid,   
	0 AS CreditSubOrder,   
	'''' AS WhoPaid,
	PatientName + '' / '' +  RenderingProviderName + Coalesce(ISNULL(ReferringProviderName,NULL), ReferringProviderName,'''') AS Description, 
	CONVERT(Money, 0) Charge, 
	CONVERT(Money, 0) Insurance, 
	CONVERT(Money, 0) Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM  
( 
	SELECT   
		LD.FinancialCenterUid,  
		S.SuperbillUid AS ItemUid,   
		A.AccountResponsiblePartyUid AS RPUid,     
		p1.FormattedPreferredName AS PatientName,  
		p2.FormattedPreferredName AS RenderingProviderName, 
		A.ExternalID AS AccountID,   
		S.ExternalID AS SuperbillID,   
		S.SuperbillUid,   
		S.ServiceDateStart AS SuperbillDate,   
		(CASE WHEN (ps.IncludeReferringProvider = 1) THEN ('' / '' + p3.FormattedPreferredName)
			ELSE NULL END) AS ReferringProviderName, 
		--VSC.CompleteBatch AS IsSuperBilCompleteBatch,   
		(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch      
	FROM   
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid and A.IsMain = 1
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid   
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS 
	WHERE rpsss.superbillstatusuid is null and
		((L.EntryType = 1 OR L.EntryType = 4) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null))
		AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
) A 
GROUP BY   
	FinancialCenterUid,  
	ItemUid,   
	RPUid,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	ReferringProviderName
	  
UNION ALL

SELECT   
	FinancialCenterUid,  
	ItemUid,   
	RPUid,   
	''Charge'' AS Type,   
	4 AS DisplayOrder,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	ItemDate,   
	NULL AS CreditGroupUid,   
	0 AS IsPayment,   
	NULL AS CreditUid,   
	0 AS CreditSubOrder,   
	'''' AS WhoPaid,   
	Description,   
	Charge,   
	Sum(Insurance) AS Insurance,  
	Sum(Patient) AS Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM  
(  
	SELECT distinct  
		LD.FinancialCenterUid,  
		LD.SuperbillProcedureUid AS ItemUid,   
		A.AccountResponsiblePartyUid AS RPUid,   
		p1.formattedPreferredName AS PatientName,
		p2.formattedPreferredName AS RenderingProviderName,
		A.ExternalID AS AccountID,   
		S.ExternalID AS SuperbillID,   
		S.SuperbillUid,   
		S.ServiceDateStart AS SuperbillDate,   
		CAST(SP.ProcedureServiceDateStart AS DATE) AS ItemDate,   
		(CASE WHEN (PS.IncludeProcedureCode= 1)   
			THEN ISNULL(LP.Code, '''') + ISNULL('' '' + LP.ShortDescription, '''')  
			ELSE ISNULL('' '' + LP.ShortDescription, '''') END) AS Description,   
		COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS Charge,   
		(CASE WHEN LD.LiabilityOwner > 0   THEN LD.Amount ELSE Convert(Money, 0) END) AS Insurance, 
		(CASE WHEN LD.LiabilityOwner = 0 THEN LD.Amount ELSE Convert(Money, 0) END) AS Patient,  
		--VSC.CompleteBatch AS IsSuperBilCompleteBatch,   
		(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch   
	FROM  
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1
		INNER JOIN ListProcedure (NOLOCK) LP ON SP.ProcedureUid = LP.ProcedureUid  
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid 
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	  
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS 
	WHERE rpsss.superbillstatusuid is null and
		((L.EntryType = 1 OR L.EntryType = 4) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null))
		AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
) B  
GROUP BY   
	FinancialCenterUid,  
	ItemUid,   
	RPUid,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	ItemDate,   
	Description,   
	Charge
	
UNION ALL

SELECT distinct  
      FinancialCenterUid,  
      ItemUid,  
      RPUid,   
      Type,   
      Case When Type=''Payment'' Then 5 ELSE 6 END as DisplayOrder,   
      PatientName,   
      RenderingProviderName,   
      AccountID,   
      SuperbillID,   
      SuperbillUid,   
      SuperbillDate,   
      CAST(MIN(ItemDate) AS DATE) as ItemDate,   
      CreditGroupUid,  
      IsPayment,   
      CreditUid,   
      2 as CreditSubOrder,   
      WhoPaid,   
      Description,  
      CONVERT(Money, 0) as Charge,   
      SUM(Insurance) as Insurance,   
      SUM(Patient) as Patient,
      0 as Amount, 
      0 AS Age,
      NULL AS SuperbillProcedureUid,  
      0 AS TotalCharge,  
      NULL AS LastFiledDate,  
      '''' AS ReferenceNumber,  
      '''' AS ReferringProviderName,   
      '''' AS InsuranacePlan,  
      0 AS IsSuperBilCompleteBatch,       
      1 AS CompleteBatch,
      0 AS DisplayOrder2  
FROM  
( 
      SELECT distinct  
            LD.FinancialCenterUid,  
            (Case When LCT.Name = ''Patient Payment'' AND D.DepositUid is not null Then D.DepositUid ELSE 
             CASE When LCT.Name = ''PatientPayment'' AND D.DepositUid is null Then LD.FinancialCenterUid ELSE LD.FinancialCenterUid END END) AS ItemUid, 
            A.AccountResponsiblePartyUid as RPUid,   
            (Case When L.EntryType  = 2 Then ''Payment'' Else ''Adjustment'' END) as Type,   
            p1.FormattedPreferredName as PatientName,
            p2.FormattedPreferredName as RenderingProviderName,
            A.ExternalID as AccountID,   
            S.ExternalID as SuperbillID,   
            S.SuperbillUid,   
            S.ServiceDateStart as SuperbillDate,   
            CAST(ARB.GLDate AS DATE) as ItemDate,   
            LD.FinancialCenterUid  CreditGroupUid,  
            (Case When L.EntryType = 2 Then 1 Else 0 END) IsPayment,   
            LD.FinancialCenterUid CreditUid,   
            LDOS.AccountResponsiblePartyUid as WhoPaidPersonUid,
            LDOS.InsurancePayerUid as WhoPaidInsuranceCarrierUid,
            WhoPaid.WhoPaidName AS WhoPaid, 
            WhoPaid.ReferenceNumber AS ReferenceNumber,
            (CASE WHEN L.EntryType != 2
				  THEN ISNULL(LCT.Name,'''')
				  ELSE
				     (CASE WHEN PS.IncludePaymentReferenceNumber = 1 
					  THEN 
                         ISNULL(LCT.Name,'''') + '' Ref #'' + ISNULL(WhoPaid.ReferenceNumber,''N/A'') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
                      ELSE ISNULL(LCT.Name,'''') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
                      END)
              END) as Description,
            (Case When LD.LiabilityOwner > 0 Then (LD.Amount) Else Convert(Money, 0) END) as Insurance,   
            (Case When LD.LiabilityOwner = 0 Then (LD.Amount) Else Convert(Money, 0) END) as Patient,  
            p3.FormattedPreferredName as ReferringProviderName,
            (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch
      FROM  
            AR_LedgerDetail (NOLOCK) LD
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid        
			LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
			INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
            INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
            INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1
            INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid                        
            --LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = LDOS.DepositUid
			LEFT JOIN AR_Transaction T ON L.TransactionUid = T.TransactionUid 
			LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = T.DepositUid            
            LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
            LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
            LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
            LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid   
			LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	 
            LEFT JOIN cteWhoPaidName AS whoPaid ON d.depositUid = WhoPaid.deposituid --and d.referencenumber = WhoPaid.referencenumber
			LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
			ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
			CROSS JOIN PracticeSettings (NOLOCK) PS 
		WHERE rpsss.superbillstatusuid is null and
            ((L.EntryType=2 OR L.EntryType=3) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 1)
			AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
      ) B                
GROUP BY  
      FinancialCenterUid,  
      ItemUid,  
      RPUid,   
      Type,   
      PatientName,   
      RenderingProviderName,   
      AccountID,   
      SuperbillID,   
      SuperbillUid,   
      SuperbillDate,  
      CreditGroupUid,   
      IsPayment,   
      CreditUid,   
      WhoPaid,   
      Description,  
      ReferringProviderName,
      ReferenceNumber

UNION ALL

--NEW COMMENT

SELECT distinct  
	LD.FinancialCenterUid,  
	CB.ClaimBatchUid as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Comment'' as Type,   
	6 as DisplayOrder,   
	p1.FormattedPreferredName as PatientName,
	p2.FormattedPreferredName as RenderingProviderName,
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	CAST(max(CB.ClaimDate) AS DATE) as ItemDate,   
	NULL as CreditGroupUid,   
	0 as IsPayment,   
	NULL as CreditUid,   
	0 as CreditSubOrder,   
	'''' as WhoPaid,   
	(dbo.ARFN_getInsLevelName(CB.InsuranceOrder) + '' claim filed to '' + ISNULL(C.Name,'''') + 
	(CASE WHEN (ps.IncludelastFileDate = 1) THEN ('' on '' + (CONVERT(VARCHAR, lfd.LastFiledDate, 101)))
			ELSE '''' END)) AS Description,   
	CONVERT(Money, 0) as Charge,   
	CONVERT(Money, 0) as Insurance,   
	CONVERT(Money, 0) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	lfd.LastFiledDate AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	
	1 AS CompleteBatch,
	0 AS DisplayOrder2  
FROM 
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1
		LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation (NOLOCK) C ON IP.InsuranceCarrierUid = C.CorporationUid   
		LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = s.ReferringProviderUid   
		LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	 
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS 
WHERE rpsss.superbillstatusuid is null and 
	  ((L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 0  AND (L.EntryType = 1))
	  AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)
GROUP BY   
 LD.FinancialCenterUid,  
 CB.ClaimBatchUid,   
 A.AccountResponsiblePartyUid,   
 S.PatientUid,   
 LD.RenderingProviderUid,  
 A.ExternalID,  
 S.ExternalID,   
 S.SuperbillUid,   
 S.ServiceDateStart,   
 CB.ClaimDate,
 lfd.LastFiledDate, 
 CB.InsuranceOrder,   
 C.Name,  
 S.ReferringProviderUid,  
 PS.IncludeLastFileDate,
 P1.FormattedPreferredName,
 p2.FormattedPreferredName,
 p3.FormattedPreferredName   

UNION ALL
--NEW Comment 2  
--Statement notes from credits. Associated with the payments AND adjustments, so use the same display ORder  
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
SELECT distinct  
	LD.FinancialCenterUid,  
	LD.LedgerDetailUid as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Comment'' as Type,   
	(CASE WHEN L.EntryType = 2 THEN 5 
	WHEN L.EntryType = 3 THEN 6
	WHEN L.EntryType = 4 THEN 7
	ELSE 6 END) as DisplayOrder,   
	p1.FormattedPreferredName as PatientName, 
	p2.FormattedPreferredName as RenderingProviderName,
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	CAST(D.DepositDate AS DATE) as ItemDate,   
	LD.LedgerDetailUid AS CreditGroupUid,  
	(Case When L.EntryType = 2 Then 1 Else 0 END) IsPayment,   
	LD.LedgerDetailUid AS CreditUid,  
	4 as CreditSubOrder,   
	'''' as WhoPaid,   
	L.StatementNote as Description,   
	Convert(Money, 0) as Charge,   
	Convert(Money, 0) as Insurance,   
	Convert(Money, 0) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	 
	(CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch,
	0 AS DisplayOrder2     
FROM 
	AR_LedgerDetail (NOLOCK) LD
	INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1
	INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid     		
	LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = LDOS.DepositUid
	LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
	LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid 
	LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	 
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
  WHERE rpsss.superbillstatusuid is null and	  
		((L.StatementNote is NOT NULL OR L.StatementNote != '''')   
		AND (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
		AND (L.EntryType=2 OR L.EntryType=3 OR L.EntryType=4) AND LD.IsCredit = 1) 
	    AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)  			
 UNION ALL
--Remark notes from reason codes. Associated with procedures
SELECT DISTINCT  
	LD.FinancialCenterUid,  
	NULL as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Comment'' as Type,   
	6 as DisplayOrder,   
	p1.FormattedPreferredName as PatientName, 
	NULL as RenderingProviderName,
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	NULL as ItemDate,   
	NULL AS CreditGroupUid,  
	0 as IsPayment,   
	NULL AS CreditUid,  
	4 as CreditSubOrder,   
	'''' as WhoPaid,   
	adj.StatementNote as Description,   
	Convert(Money, 0) as Charge,   
	Convert(Money, 0) as Insurance,   
	Convert(Money, 0) as Patient,
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	 
	NULL CompleteBatch,
	0 AS DisplayOrder2      
FROM Superbill (NOLOCK) S 
	INNER JOIN SuperbillProcedure SP WITH (NOLOCK) ON SP.superbilluid = S.superbilluid
	INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SP.SuperbillProcedureUid = LD.SuperbillProcedureUid
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1  
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	left join cobclaimdetail cob on cob.superbilluid = s.superbilluid
	left join COBLineAdjustments adj on adj.cobclaimdetailuid = cob.cobclaimdetailuid and adj.superbillprocedureuid = sp.superbillprocedureuid and adj.Notes IS NOT NULL
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid	 
WHERE rpsss.superbillstatusuid is null and
	  (adj.StatementNote is NOT NULL OR adj.StatementNote != '''')  			
	  AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)  		
UNION ALL
--NEW Subtotal
SELECT distinct
	LD.FinancialCenterUid,  
	S.SuperbillUid as ItemUid,   
	A.AccountResponsiblePartyUid as RPUid,   
	''Subtotal'' as Type,   
	8 as DisplayOrder,   
	p1.FormattedPreferredName as PatientName,
	p2.FormattedPreferredName as RenderingProviderName, 
	A.ExternalID as AccountID,   
	S.ExternalID as SuperbillID,   
	S.SuperbillUid,   
	S.ServiceDateStart as SuperbillDate,   
	NULL as ItemDate,   
	NULL as CreditGroupUid,   
	0 as IsPayment,   
	NULL as CreditUid,   
	0 as CreditSubOrder,   
	'''' as WhoPaid,   
	''Balance Superbill '' + ISNULL(''#'' + S.ExternalID, Convert(Varchar, dbo.UDF_utcToCurrentDate(S.ServiceDateStart), 101)) as Description,   
	Sum(case when L.EntryType= 1 OR L.EntryType=4 then LD.Amount else 0 END) as Charge,   
	Sum(Case When LD.LiabilityOwner > 0 Then LD.Amount Else Convert(Money, 0) END) as Insurance,   
	Sum(Case When LD.LiabilityOwner = 0 Then LD.Amount Else Convert(Money, 0) END) as Patient, 
	0 as Amount, 
	0 AS Age,
	NULL AS SuperbillProcedureUid,  
	0 AS TotalCharge,  
	NULL AS LastFiledDate,  
	'''' AS ReferenceNumber,  
	'''' AS ReferringProviderName,   
	'''' AS InsuranacePlan,  
	0 AS IsSuperBilCompleteBatch, 	 
	1  CompleteBatch,
	0 AS DisplayOrder2  
FROM 
	AR_LedgerDetail (NOLOCK) LD
	INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1   
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
	LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid 
	LEFT OUTER JOIN ViewCHCSuperbillProcedurePatientLiability chc WITH (NOEXPAND) ON chc.superbillprocedureuid = sp.SuperbillProcedureUid
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	CROSS JOIN PracticeSettings (NOLOCK) PS 
WHERE rpsss.superbillstatusuid is null and
	 ((L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null))
	  AND (chc.patientliability <> 0 OR chc.patientliability IS NULL)  
GROUP BY   
	LD.FinancialCenterUid,  
	S.SuperbillUid,   
	A.AccountResponsiblePartyUid,   
	S.PatientUid,   
	LD.RenderingProviderUid,  
	S.ServiceDateStart,   
	A.ExternalID,  
	S.ExternalID,   
	S.ReferringProviderUid,  
	P1.FormattedPreferredName,
	p2.FormattedPreferredName,
	p3.FormattedPreferredName 		





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindFacilityPerson]'))
EXEC dbo.sp_executesql @statement = N'			CREATE VIEW [dbo].[ViewFindFacilityPerson] AS
	SELECT	p.PersonUid, p.Inactive, vp.FirstName, vp.MiddleName, vp.LastName, vp.FormattedPreferredName AS FullName, 
			vp.AkaName, p.Birthdate, vp.AkaFirstName, vp.AkaLastName, 
            vp.SocialSecurityNumber,
            vp.Phone1, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName,
            vp.Phone2, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber2, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName2,
            vp.Phone3, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber3, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName3,
            vp.Phone4, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber4, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName4,
            vp.Address1 AS Address1Xml, vp.Address1.value(''(/Address/Address1)[1]'', ''varchar(100)'') AS Address1,
            vp.Address1.value(''(/Address/Address2)[1]'', ''varchar(100)'') AS Address2,
            vp.Address1.value(''(/Address/City)[1]'', ''varchar(100)'') AS City,
            vp.Address1.value(''(/Address/State)[1]'', ''varchar(100)'') AS State,
            vp.Address1.value(''(/Address/Zip)[1]'', ''varchar(100)'') AS Zip,                      
            g1.ANSICode AS GenderANSICode,
			isnull(pw.FacilityPortalWebAccess, 0) AS FacilityPortalWebAccess,
			isnull(cast(CASE WHEN prov.PersonUid IS NULL THEN 0 ELSE 1 END AS bit), 0) AS IsProvider
	FROM	Person p INNER JOIN
			ViewPerson vp ON p.PersonUid = vp.PersonUid LEFT OUTER JOIN
			ListGender g1 ON p.GenderUid = g1.GenderUid LEFT OUTER JOIN
			PersonWeb pw ON p.PersonUid = pw.PersonUid LEFT OUTER JOIN
			Provider prov ON p.PersonUid = prov.PersonUid
	WHERE   
			-- Person is Potential Facility Portal user through FacilityPortalWebAccess in PersonWeb if:
			-- Not UserPRM (because they would login with domain account)
				NOT EXISTS (SELECT up.PersonUid 
							FROM UserPRM up 
							WHERE up.PersonUid = p.PersonUid) 
			AND
			-- And Not Patient
				NOT EXISTS (SELECT pat.PersonUid 
							FROM Patient pat 
							WHERE pat.PersonUid = p.PersonUid)' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementLineItemExcludeZeroBalance_MainAccount]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewStatementLineItemExcludeZeroBalance_MainAccount]
AS
SELECT NEWID() AS [ItemUid], VS.*
from ( select distinct 
      [RPUid]
      ,[FinancialCenterUid]
      ,[Type]
      ,[DisplayOrder]
      ,[PatientName]
      ,[RenderingProviderName]
      ,[AccountID]
      ,[SuperbillID]
      ,[SuperbillUid]
      ,[SuperbillDate]
      ,CAST([ItemDate] AS DATE) as [ItemDate]
      ,[CreditGroupUid]
      ,[IsPayment]
      ,[CreditUid]
      ,[CreditSubOrder]
      ,[WhoPaid]
      ,[Description]
      ,[Charge]
      ,[Insurance]
      ,[Patient]
FROM ViewStatementLineItem_MainAccount (NOLOCK)
) VS 
INNER JOIN AR_ViewSuperbillAggregate SBV WITH (NOLOCK) ON VS.superbilluid = SBV.superbilluid AND SBV.LiabilityBalance != 0
WHERE description IS NOT NULL' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_ExternalPatientList]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[MDOL_RPT2_VIEW_ExternalPatientList]
AS
SELECT
	HospitalRoundUid,
	Inactive,
	ServiceSiteUid,
	ServiceSiteName,
	PatientUid,
	PatientName,
	ISNULL(Location,''-'') AS Location,
	AdmitDate,
	DischargeDate,
	--Notes,
	ISNULL(convert(varchar(max),Notes),''-'') AS Notes,
	ProviderUids,
	ProviderNames,
	DiagnosisUids,
	ISNULL(DiagnosisNames,''-'') AS DiagnosisNames
FROM
	ViewHospitalRound VHR1 WITH (NOLOCK)
GROUP BY
	HospitalRoundUid,
	Inactive,
	ServiceSiteUid,
	ServiceSiteName,
	PatientUid,
	PatientName,
	Location,
	AdmitDate,
	DischargeDate,
	--Notes,
	convert(varchar(max),Notes),
	ProviderUids,
	ProviderNames,
	DiagnosisUids,
	DiagnosisNames
HAVING 
MAX(AdmitDate) >= ALL
    (SELECT AdmitDate
     FROM ViewHospitalRound VHR2 where VHR1.PatientUid =VHR2.PatientUid )
     

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewDocumentManagement]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewDocumentManagement] AS
SELECT        rag.RelAttachmentGroupUid, ag.AttachmentGroupUid, a.AttachmentUid, ag.Name AS AttachmentGroup, ag.Notes, ag.AttachmentTypeUid, 
                         at.Name AS AttachmentType, at.Color AS AttachmentTypeColor, a.AttachmentContentType, a.AttachmentContentSize, a.UncompressedAttachmentContentSize, 
                         CAST(CASE WHEN a.CompressionUid IS NULL THEN 0 ELSE 1 END AS BIT) AS Compressed, CASE WHEN a.CompressionUid IS NULL OR
                         a.UncompressedAttachmentContentSize = 0 THEN NULL ELSE (CONVERT(real, a.UncompressedAttachmentContentSize - a.AttachmentContentSize) 
                         / a.UncompressedAttachmentContentSize) * 100.0 END AS CompressionPercent, a.ThumbnailAttachmentContent, a.FilePath, a.FileName, a.FileExtension, 
                         a.FileDate, a.Name AS AttachmentName, a.DisplayOrder, rag.PersonUid AS PatientUid, dbo.UDF_getFormattedPreferredName(rag.PersonUid) AS Patient, 
                         rag.VisitUid, v.VisitDate, rag.AccountResponsiblePartyUid, CASE WHEN arp.PersonUid IS NULL 
                         THEN c.Name ELSE dbo.UDF_getFormattedPreferredName(arp.PersonUid) END AS ResponsibleParty, rag.ObservationOrderUid, rag.MessageUid, 
                         CASE WHEN a.AttachmentContentSize = 0 AND a.GraphicNoteUid IS NULL THEN ''Linked'' ELSE ''Imported'' END AS AttachmentMethod, 
                         CASE 
							-- the order is important, the first two are correct; don''t know the order for the rest - chm
							WHEN NOT rag.PatientProcedureHistoryUid IS NULL THEN ''Patient Procedure History'' 
							WHEN NOT rag.ObservationOrderUid IS NULL THEN ''Observation'' 
							WHEN NOT rag.VisitUid IS NULL THEN ''Visit'' 
							WHEN NOT rag.AccountResponsiblePartyUid IS NULL THEN ''Responsible Party'' 
							WHEN NOT rag.MessageUid IS NULL THEN ''Message'' 
							WHEN NOT rag.DepositUid IS NULL THEN ''Deposit'' 
							WHEN NOT rag.PatientProviderRelationshipUid IS NULL THEN ''Provider Relationship''
							WHEN NOT rag.PatientReferralUid IS NULL THEN ''Patient Referral''
							WHEN NOT rag.PersonUid IS NULL THEN ''Patient'' 
							ELSE ''Unknown'' END 
						 AS AttachmentLocation, 
						 a.StrikeOut, a.StrikeOutNotes, a.GraphicNoteUid, rag.DepositUid,
                         rag.PatientProviderRelationshipUid, 
                         rag.PatientReferralUid,
						 ag.LastModifiedDate
FROM            dbo.Attachment AS a INNER JOIN
                         dbo.AttachmentGroup AS ag ON a.AttachmentGroupUid = ag.AttachmentGroupUid INNER JOIN
                         dbo.RelAttachmentGroup AS rag ON ag.AttachmentGroupUid = rag.AttachmentGroupUid LEFT OUTER JOIN
                         dbo.ListAttachmentType AS at ON ag.AttachmentTypeUid = at.AttachmentTypeUid LEFT OUTER JOIN
                         dbo.Visit AS v ON rag.VisitUid = v.VisitUid LEFT OUTER JOIN
                         dbo.AccountResponsibleParty AS arp ON rag.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid LEFT OUTER JOIN
                         dbo.Corporation AS c ON arp.CorporationUid = c.CorporationUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewDocumentManagementCanCompress]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewDocumentManagementCanCompress]
AS
SELECT        dcm.RelAttachmentGroupUid, dcm.AttachmentGroupUid, dcm.AttachmentUid, dcm.AttachmentGroup, dcm.Notes, dcm.AttachmentTypeUid, 
                         dcm.AttachmentType, dcm.AttachmentTypeColor, dcm.AttachmentContentType, dcm.AttachmentContentSize, dcm.UncompressedAttachmentContentSize, dcm.Compressed, 
                         dcm.CompressionPercent, dcm.ThumbnailAttachmentContent, dcm.FilePath, dcm.FileName, dcm.FileExtension, dcm.FileDate, dcm.AttachmentName, 
                         dcm.DisplayOrder, dcm.PatientUid, dcm.Patient, dcm.VisitUid, dcm.VisitDate, dcm.AccountResponsiblePartyUid, dcm.ResponsibleParty, 
                         dcm.ObservationOrderUid, dcm.MessageUid, dcm.AttachmentMethod, dcm.AttachmentLocation, dcm.StrikeOut, dcm.StrikeOutNotes, dcm.GraphicNoteUid, 
                         c.Name AS Compression, dcm.DepositUid, dcm.LastModifiedDate
FROM            dbo.ViewDocumentManagement AS dcm INNER JOIN
                         dbo.AttachmentHandlerFileNameWildcards() AS ah ON dcm.FileName LIKE REPLACE(REPLACE(ah.FileNameWildcard, ''*'', ''%''), ''?'', ''_'') INNER JOIN
                         dbo.ListCompression AS c ON ah.CompressionUid = c.CompressionUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewAccountSuperbillServiceDateRange]'))
EXEC dbo.sp_executesql @statement = N'
-- Load list of Accounts with Min and Max Superbill Service Dates to bound Account Effective dates
CREATE VIEW [dbo].[ViewAccountSuperbillServiceDateRange] as
SELECT A.AccountUid, MIN(SB.ServiceDateStart) AS MinSuperbillServiceDateStart, MAX(SB.ServiceDateEnd) as MaxSuperbillServiceDateEnd
FROM Account A
INNER JOIN AccountPeriod AP ON A.AccountUid = AP.AccountUid
LEFT JOIN ViewSuperbillPersonAccountInsurance SPAI ON AP.AccountPeriodUid = SPAI.AccountPeriodUid
LEFT JOIN Superbill SB ON SPAI.SuperbillUid = SB.SuperbillUid
GROUP BY A.AccountUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSecurityPermission]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSecurityPermission]
AS
SELECT     s.Uid AS Uid, s.Name, sg.Name AS SecurityGroup, sg.Permission AS PermissionMask, s.SecurityUid, s.SecurityId AS Id, 0 AS ObjectSecurity
FROM         dbo.ViewSecuritySecurityGroup s INNER JOIN
                      dbo.ListSecurityGroup sg ON s.SecurityGroupUid = sg.SecurityGroupUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_PayerCreditCandidate_Procedure]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_PayerCreditCandidate_Procedure] AS
   SELECT
      PayerUid                = CASE
                                    WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ins.InsuranceCarrierUid
                                    ELSE acc.AccountResponsiblePartyUid
                                    END,
      PayerType               = CASE
                                      WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ''Insurance Payer''
                                      ELSE ''Acount Responsible Party''
                                END,
      PayerName               = CASE
                                   WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ins.Name
                                   ELSE vpn.FullName
                                END,
      ProcedureCode           = prc.Code,
      ProcedureName           = prc.ShortDescription,
      DisplayOrder            = sbp.DisplayOrder,
      LiabilityOwner          = ard.LiabilityOwner,                                
      SuperbillUid            = sbp.SuperbillUid,
      SuperbillProcedureUid   = sbp.SuperbillProcedureUid,
      PayerBalance            = SUM(CASE WHEN arl.EntryType = 2 AND ard.IsCredit = 1 THEN ard.Amount ELSE 0 END) +
                                SUM(CASE WHEN (arl.EntryType = 1 AND ard.IsCredit = 0) OR (arl. EntryType = 3) OR (arl. EntryType = 4) THEN ard.Amount ELSE 0 END),
      PayerPaid               = SUM(CASE WHEN arl.EntryType = 2 AND ard.IsCredit = 1 THEN -ard.Amount ELSE 0 END),
      PayerOwed               = SUM(CASE WHEN (arl.EntryType = 1 AND ard.IsCredit = 0) OR (arl. EntryType = 3) OR (arl. EntryType = 4) THEN ard.Amount ELSE 0 END)
   FROM AR_LedgerDetail ard
   INNER JOIN AR_Ledger arl ON arl.LedgerUid = ard.LedgerUid
   INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = ard.SuperbillProcedureUid AND sbp.Inactive != 1
   INNER JOIN ListProcedure prc ON prc.ProcedureUid = sbp.ProcedureUid
   INNER JOIN Superbill sbx ON sbx.SuperbillUid = sbp.SuperbillUid
   INNER JOIN Account acc ON acc.AccountUid = sbx.AccountUid
   INNER JOIN AccountResponsibleParty arp ON arp.AccountResponsiblePartyUid = acc.AccountResponsiblePartyUid
   INNER JOIN Person per ON per.PersonUid = arp.PersonUid
   INNER JOIN ViewPerson (NOEXPAND) vpn ON vpn.PersonUid = per.PersonUid
   LEFT JOIN InsurancePlan ins ON ins.InsurancePlanUid = ard.InsurancePlanUid
   LEFT JOIN InsuranceCarrier inc ON inc.CorporationUid = ins.InsuranceCarrierUid
   --WHERE sbx.SuperbillUid = @SuperbillUid
   GROUP BY ins.InsuranceCarrierUid, acc.AccountResponsiblePartyUid, ins.Name, vpn.FullName, prc.Code, prc.ShortDescription, sbp.DisplayOrder, ard.LiabilityOwner, sbp.SuperbillUid, sbp.SuperbillProcedureUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewStatementARPByFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewStatementARPByFinancialCenter]
AS
select
fca.AccountResponsiblePartyUid,
fca.FinancialCenterUid,
SUM(fca.Liability) as Liability,
sum(fca.assignedLiability) as AssignedLiability,
sum(fca.liabilitybalance) as LiabilityBalance,
sum(fca.assignedliabilitybalance) as AssignedLiabilityBalance
from
AR_ViewAccountResponsiblePartyByFinancialCenterAggregate FCA
group by AccountResponsiblePartyUid,FinancialCenterUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_PayerCreditCandidate_Deposit]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_PayerCreditCandidate_Deposit] AS
   SELECT
      PayerUid                = CASE
                                    WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ins.InsuranceCarrierUid
                                    ELSE acc.AccountResponsiblePartyUid
                                END,
      PayerType               = CASE
                                      WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ''Insurance Payer''
                                      ELSE ''Acount Responsible Party''
                                END,
      PayerName               = CASE
                                   WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ins.Name
                                   ELSE vpn.FullName
                                END,
      LiabilityOwner          = ard.LiabilityOwner,                                
      SuperbillUid            = sbp.SuperbillUid,
      DepositUid              = ISNULL(ots.DepositUid, crd.DepositUid),
      DepositCreateDateTime   = dep.CreateDateTime,
      PayerPaid               = SUM(CASE WHEN arl.EntryType = 2 AND ard.IsCredit = 1 THEN -ard.Amount ELSE 0 END)
   FROM AR_LedgerDetail ard
   INNER JOIN AR_Ledger arl ON arl.LedgerUid = ard.LedgerUid
   INNER JOIN AR_LedgerDetail ots ON ots.LedgerDetailUid != ard.LedgerDetailUid AND ots.LedgerUid = ard.LedgerUid
   LEFT JOIN AR_PayerCredit crd ON crd.PayerCreditUid = ots.PayerCreditUid
   INNER JOIN Deposit dep ON dep.DepositUid = ISNULL(ots.DepositUid, crd.DepositUid)
   INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = ard.SuperbillProcedureUid AND sbp.Inactive != 1
   INNER JOIN ListProcedure prc ON prc.ProcedureUid = sbp.ProcedureUid
   INNER JOIN Superbill sbx ON sbx.SuperbillUid = sbp.SuperbillUid
   INNER JOIN Account acc ON acc.AccountUid = sbx.AccountUid
   INNER JOIN AccountResponsibleParty arp ON arp.AccountResponsiblePartyUid = acc.AccountResponsiblePartyUid
   INNER JOIN Person per ON per.PersonUid = arp.PersonUid
   INNER JOIN ViewPerson (NOEXPAND) vpn ON vpn.PersonUid = per.PersonUid
   LEFT JOIN InsurancePlan ins ON ins.InsurancePlanUid = ard.InsurancePlanUid
   LEFT JOIN InsuranceCarrier inc ON inc.CorporationUid = ins.InsuranceCarrierUid
   WHERE ISNULL(ots.DepositUid, crd.DepositUid) IS NOT NULL
     --AND sbx.SuperbillUid = @SuperbillUid
   GROUP BY ins.InsuranceCarrierUid, acc.AccountResponsiblePartyUid, ins.Name, vpn.FullName, ard.LiabilityOwner, sbp.SuperbillUid, ots.DepositUid, crd.DepositUid, dep.CreateDateTime


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewResponsibleParty]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewResponsibleParty] AS
SELECT	arp.AccountResponsiblePartyUid, arp.PersonUid, arp.CorporationUid, 
		isnull(pc1.PersonUid, pc2.CorporationUid) AS ResponsiblePartyUid, 
		arp.ExternalID, 
		(SELECT LiabilityBalance - AssignedLiabilityBalance FROM AR_ViewAccountResponsiblePartyAggregate
		WHERE AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid) AS PersonBalanceAll, 
        ISNULL(-(pcbp.PayerCreditBalance),0) as PayerCreditBalance,  -- Account Payer Credit Balance
        p.Prefix, p.FirstName, p.MiddleName, p.Suffix, 
        coalesce(p.LastName, pc1.lastname, pc2.Name) AS LastName, 
        isnull(pc1.FullName, pc2.Name) AS [Name], 
        isnull(pc1.PhoneNumber1, pc2.PhoneNumber) AS PhoneNumber,
        isnull(pc1.PhoneNumberScrubbed, pc2.PhoneNumberScrubbed) as PhoneNumberScrubbed,
        p.Email1, p.GenderUid, 
		dbo.GetPrimaryRaceUid(p.PersonUid) as [RaceUid], 
		dbo.GetPrimaryEthnicityUid (p.PersonUid) as [EthnicityUid],
		p.Birthdate, 
        p.Deathdate, p.SocialSecurityNumber, p.DriverLicenseState, p.DriverLicenseNumber, p.MaritalStatusUid, 
        CASE WHEN arp.CorporationUid IS NOT NULL THEN ''Corporation'' ELSE ''Person'' END as [Type],
        arp.Inactive, 
		isnull(pc1.Address1_Address1, pc2.Address1) as Address1,
        isnull(pc1.Address1_Address2, pc2.Address2) as Address2,
        isnull(pc1.Address1_City, pc2.City) as City,
        isnull(pc1.Address1_State, pc2.[State]) as [State],
        isnull(pc1.Address1_Zip, pc2.Zip) as Zip,
        p.AkaFirstName, p.AkaLastName,
        (CASE WHEN p.AkaLastName IS NULL AND p.AkaFirstName IS NULL THEN '''' ELSE IsNull(p.AkaLastName, p.LastName) + '', '' + IsNull(p.AkaFirstName, p.FirstName) END) AS AkaName,
		LCS.Name AS CollectionStatusName,
		CAST(CASE WHEN EXISTS(SELECT * FROM ViewPatientCollectionHistory WHERE AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid AND CollectionAlert = ''Alerted'') THEN 1 ELSE 0 END AS BIT) AS CollectionAlerted
FROM    AccountResponsibleParty AS arp 
		LEFT JOIN ViewPerson pc1 ON arp.PersonUid = pc1.PersonUid
		LEFT JOIN ViewCorporation pc2 ON arp.CorporationUid = pc2.CorporationUid
		LEFT JOIN Person AS p ON arp.PersonUid = p.PersonUid 
		LEFT JOIN AR_ViewPayerCreditByPayer pcbp on arp.AccountResponsiblePartyUid = pcbp.AccountResponsiblePartyUid
		LEFT JOIN ListCollectionStatus LCS with (NOLOCK) ON ARP.CollectionStatusUid = LCS.CollectionStatusUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPayerCurrentCarrier]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbillPayerCurrentCarrier]  
AS
SELECT  
	NEWID() AS ViewSuperbillPayerCurrentCarrierUid, -- no other unique to use as PK
	s.ExternalID,
	s.SuperbillUid,
	s.PatientUid,
	s.RenderingProviderUid,
	s.ClaimingProviderUid,
	s.SuperbillStatusUid,
	s.ServiceDateStart,
	s.ServiceDateEnd,
	s.FirstFiledDate, 
	s.LastFiledDate,
	s.ServiceSiteUid,
	s.PatientName,
	s.RenderingProviderName,
	s.ClaimingProviderName,
	s.SuperbillStatusName,
	s.ServiceSiteName,
	s.AccountUid,
	s.VisitUid,
	s.VisitDate,
	s.ClaimPaper,
	s.LastModifiedByUid,
	s.TotalCharge,
	s.IsPosted,
	s.FinancialCenterUid,
	s.AccountName,
    s.CurrentCarrier as InsuranceOrder,
	s.InsuredPersonUid,
	s.InsuredCorporationUid,
	s.InsuredName,
	s.AuthorizeAssignment,
	s.PlanMemberID,
	s.PlanGroupID,
	s.InsuranceCarrierUid,
	s.InsurancePlanUid,
	s.InsurancePlanName,
	s.PayerName,
	s.Capitated,
	s.Errors,
	s.Warnings,
	s.ClaimFormatUid,
	s.ClaimClearingHouseUid,
	s.ClaimClearingHouse,
	lcf.Name as ClaimFormat,
	lcft.ClaimFormatTypeUid,   
	lcft.Name as ClaimFormatType,   
	lcft.IsPaper as ClaimFormatTypeIsPaper,
	s.InsuranceLevelName,
	s.ARBatchUid, -- Igor note: temporary added to fix application error (bug 7146) 1/12/2011
	s.Notes,
	cfl.ClaimFormLayoutUid,
	cfl.Name as ClaimFormLayout,
	VSF.LastFollowupModifiedByUid, VSF.LastFollowupModifiedDate, VSF.LastFollowupByUser, VSF.LastFollowupAll, VSF.MaxFollowupModifiedDate
from ViewSuperbillPayerWithoutClaimFormat s  
	 LEFT JOIN ListClaimFormat lcf ON lcf.ClaimFormatUid = s.ClaimFormatUid  
	 LEFT JOIN ListClaimFormatType lcft ON lcft.ClaimFormatTypeUid = lcf.ClaimFormatTypeUid
     LEFT OUTER JOIN ClaimFormatOption cfo ON lcf.ClaimFormatUid = cfo.ClaimFormatUid	-- Scenario 39252: Set custom payer claim layout		
												AND cfo.ClaimFormatOptionTypeUid in (	''85912913-6DF7-46FD-BA9C-47788EBC347C'', -- Paper CMS-1500 5010
																					  	''213406F9-EB44-46AE-A85B-E75082C7BD41'', -- Paper ADA 2006
																						''5A04B8A3-CD89-4873-B639-43015702B181'', -- Paper CMS-1500
																						''FC409618-D134-4225-93C3-629566A3DA0B'') -- Paper UB04
	  LEFT JOIN ListClaimFormLayout cfl ON cfo.ClaimFormatValueTypeUid = cfl.ClaimFormLayoutUid
	  LEFT JOIN ViewSuperbillFollowup VSF ON s.SuperbillUid = VSF.SuperbillUid
where s.CurrentCarrier = s.InsuranceOrder



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPendingCreditCardPayments]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[ViewPendingCreditCardPayments] AS
		select NEWID() as Uid, 
		CreditCardTransactionHistory.AccountResponsiblePartyUid, 
		CreditCardTransactionHistory.DepositUid, 
		ViewResponsibleParty.PersonUid, 
		ViewResponsibleParty.ResponsiblePartyUid,
		CreditCardTransactionHistory.TxID, 
		ViewDeposit.IsFullyAllocated, 
		CreditCardTransactionHistory.PaymentAmount, 
		CreditCardTransactionHistory.SourceOfPayment, 
		CreditCardTransactionHistory.IsPartialApproval,
		CreditCardTransactionHistory.ResponseAuthorizedAmount, 
		ViewResponsibleParty.FirstName, 
		ViewResponsibleParty.LastName,
		CreditCardTransactionHistory.TxDateTime 
	from CreditCardTransactionHistory with (nolock)
		inner join ViewDeposit with (nolock)
		on CreditCardTransactionHistory.DepositUid = ViewDeposit.DepositUid
		inner join ViewResponsibleParty with (nolock)
		on CreditCardTransactionHistory.AccountResponsiblePartyUid = ViewResponsibleParty.AccountResponsiblePartyUid		
	where IsFullyAllocated = ''0''



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindOBPatientCase]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewFindOBPatientCase]
AS
SELECT        dbo.PatientCase.PatientCaseUid, dbo.PatientCase.PatientUid, dbo.PatientCase.CaseTypeUid, dbo.PatientCase.ProviderUid, 
			  Patient.ExternalID, Patient.MedicalRecordNumber,
			  PatientPerson.FormattedPreferredName AS PatientName, 
			  PatientPerson.AkaName AS AkaName, Patientperson.Birthdate, 
			  dbo.PatientCase.Name, dbo.PatientCase.StartDate, 
              dbo.PatientCase.EndDate, dbo.ListCaseType.Name AS CaseTypeName, ProviderPerson.FormattedPreferredName AS ProviderName, dbo.PatientCase.Notes, dbo.PatientCase.Inactive
FROM            dbo.PatientCase INNER JOIN
                         dbo.Patient ON dbo.PatientCase.PatientUid = dbo.Patient.PersonUid INNER JOIN
                         dbo.ListCaseType ON dbo.PatientCase.CaseTypeUid = dbo.ListCaseType.CaseTypeUid INNER JOIN
                         dbo.ViewPerson AS PatientPerson ON dbo.Patient.PersonUid = PatientPerson.PersonUid 
						 LEFT JOIN dbo.Provider ON dbo.PatientCase.ProviderUid = dbo.Provider.PersonUid 
						 LEFT JOIN dbo.ViewPerson AS ProviderPerson ON dbo.Provider.PersonUid = ProviderPerson.PersonUid
WHERE        (dbo.PatientCase.CaseTypeUid = ''5BDC8794-20CB-4253-96AF-0907E73B9185'')

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_View_ReceiptsAnalysis]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[MDOL_RPT2_View_ReceiptsAnalysis]
AS
	SELECT
		ISNULL(LD.Amount,0) as Payment,
		ISNULL(LP.Name,LP1.Name) as PaymentType,
		ISNULL(LP.PaymentTypeUid,LP1.PaymentTypeUid) PaymentTypeUid,
		AB.GLDate,
		ISNULL(VD.DepositDate,VD1.DepositDate) AS DepositDate,
		--D.DepositDate,
		--CG.CreditGroupUID,
		LD.RenderingProviderUID,
		ISNULL(LD.ClaimingProviderUID,LD.RenderingProviderUID) AS ClaimingProviderUID,
		LD.RenderingProviderUid AS ProviderUid,	
		LD.FinancialCenterUID,
		CASE WHEN VARB.IsClosed =1 THEN 1 ELSE 0 END AS IsBatchClosed,
		LC.Name AS CreditType,
		LC.CreditTypeUid  
	FROM
 		AR_Ledger L with (NOLOCK)
	JOIN
		AR_LedgerDetail LD with (NOLOCK) 
	ON
		L.LedgerUid =LD.LedgerUid AND L.EntryType = 2 --AND LD.IsCredit = 1
	INNER JOIN  
		AR_ViewBatchClosingsLockedClosed VARB with (NOLOCK)  
	ON  
		L.ArBatchUid =VARB.ARBatchUid
	JOIN 
		ARBatch AB with (NOLOCK) 
	ON 
		L.ArBatchUid = AB.ARBatchUid
	LEFT JOIN
		AR_Transaction T with (NOLOCK)
	ON
		L.TransactionUid =T.TransactionUid 
	LEFT JOIN
		[MDOL_RPT2_View_PayerCreditDistributionDeposit] PCD with (NOLOCK)
	ON
		PCD.LedgerUid =L.LedgerUid 
	LEFT JOIN   
		ViewDepositDate  VD with (NOLOCK)
	ON  
	   VD.DepositUid =T.DepositUid --OR (T.DepositUid IS NULL AND PCD.DepositUid =D.DepositUid))
	LEFT JOIN
	   ViewDepositDate VD1 with (NOLOCK)
	ON
	   T.DepositUid IS NULL AND PCD.DepositUid =VD1.DepositUid  
	LEFT JOIN
		Deposit  D with (NOLOCK)
	ON  
	   D.DepositUid =T.DepositUid	
	LEFT JOIN
		Deposit  D1 with (NOLOCK)
	ON  
	   T.DepositUid IS NULL AND PCD.DepositUid =D1.DepositUid  		   
	LEFT JOIN
		ListPaymentType LP with (NOLOCK)
	ON
		LP.PaymentTypeUID=D.PaymentTypeUID
	LEFT JOIN
		ListPaymentType LP1 with (NOLOCK)
	ON
		LP1.PaymentTypeUID=D1.PaymentTypeUID
    LEFT JOIN
        ListCreditType LC with (NOLOCK)
    ON
        LC.CreditTypeUid=LD.IncomeAccountUid 
           
WHERE LD.SuperbillProcedureUid IS NOT NULL
		
UNION ALL -- NEGATION ENTRY OF PAYER CREDIT DISTRIBUTION.

	SELECT
		ISNULL(LD.Amount,0) as Payment,
		LP.Name as PaymentType,
		LP.PaymentTypeUid PaymentTypeUid,
		AB.GLDate,
		VD.DepositDate AS DepositDate,
		--D.DepositDate,
		--CG.CreditGroupUID,
		PC.RenderingProviderUid,
		ISNULL(PC.RenderingProviderUid,PC.RenderingProviderUid) AS ClaimingProviderUID,
		PC.RenderingProviderUid AS ProviderUid,	
		PC.FinancialCenterUID,
		CASE WHEN VARB.IsClosed =1 THEN 1 ELSE 0 END AS IsBatchClosed,
		LC.Name AS CreditType,
		LC.CreditTypeUid
	FROM
 		AR_Ledger L with (NOLOCK)
	JOIN
		AR_LedgerDetail LD with (NOLOCK) 
	ON
		L.LedgerUid =LD.LedgerUid AND L.EntryType = 2 --AND LD.IsCredit = 1
	INNER JOIN  
		AR_ViewBatchClosingsLockedClosed VARB with (NOLOCK)  
	ON  
		L.ArBatchUid =VARB.ARBatchUid
	JOIN 
		ARBatch AB with (NOLOCK) 
	ON 
		L.ArBatchUid = AB.ARBatchUid
	--LEFT JOIN
	--	AR_Transaction T
	--ON
	--	L.TransactionUid =T.TransactionUid 
	--LEFT JOIN
	--	[MDOL_RPT2_View_PayerCreditDistributionDeposit] PCD
	--ON
	--	PCD.LedgerUid =L.LedgerUid 
	LEFT JOIN
		ViewPayerCredit PC with (NOLOCK)
	ON
		PC.PayerCreditUid =LD.PayerCreditUid 
	LEFT JOIN   
		ViewDepositDate  VD with (NOLOCK)
	ON  
	   VD.DepositUid =PC.DepositUid 
	LEFT JOIN
		Deposit  D with (NOLOCK)
	ON  
	   D.DepositUid =PC.DepositUid	
	 		   
	LEFT JOIN
		ListPaymentType LP with (NOLOCK)
	ON
		LP.PaymentTypeUID=D.PaymentTypeUID
	LEFT JOIN
        ListCreditType LC with (NOLOCK)
    ON
        LC.CreditTypeUid=LD.IncomeAccountUid 	
	
WHERE LD.PayerCreditUid IS NOT NULL AND LD.SuperbillProcedureUid IS NULL

UNION ALL
	SELECT
		ISNULL(PC.Receipt,0) as Payment,
		LPT.Name as PaymentType,
		LPT.PaymentTypeUid PaymentTypeUid,
		PC.GLDate,
		VD.DepositDate AS DepositDate,
		PC.ProviderUid as RenderingProviderUID,
		PC.ProviderUid as ClaimingProviderUID,
		PC.ProviderUid ,
		PC.FinancialCenterUID,
		PC.IsBatchClosed  AS IsBatchClosed ,
		LC.Name AS CreditType,
		LC.CreditTypeUid 
	FROM
		MDOL_RPT2_ViewPayerCredit PC with (NOLOCK)
	JOIN
		Deposit D with (NOLOCK)
	ON
		D.DepositUid = PC.DepositUid
	JOIN
		ViewDepositDate VD with (NOLOCK)
	ON
		D.DepositUid = VD.DepositUid 
	LEFT JOIN
		ListPaymentType LPT with (NOLOCK)
	ON
		LPT.PaymentTypeUid =D.PaymentTypeUid 
    LEFT JOIN
ListCreditType LC with (NOLOCK)
    ON
        LC.CreditTypeUid=PC.IncomeAccountUid
         
UNION ALL
	SELECT
		ISNULL(RF.Receipt,0) as Payment,
		LPT.Name as PaymentType,
		LPT.PaymentTypeUid PaymentTypeUid,
		RF.GLDate,
		VD.DepositDate AS DepositDate,
		RF.ProviderUid as RenderingProviderUID,
		RF.ProviderUid as ClaimingProviderUID,
		RF.ProviderUid ,
		RF.FinancialCenterUID,
		RF.IsBatchClosed  AS IsBatchClosed,
		LC.Name AS CreditType,
		LC.CreditTypeUid   
	FROM
		MDOL_RPT2_ViewRefund RF with (NOLOCK)
	JOIN
		Deposit D with (NOLOCK)
	ON
		D.DepositUid = RF.DepositUid
	JOIN
		ViewDepositDate VD with (NOLOCK)
	ON
		D.DepositUid = VD.DepositUid 
	LEFT JOIN
		ListPaymentType LPT with (NOLOCK)
	ON
		LPT.PaymentTypeUid =D.PaymentTypeUid 			
	LEFT JOIN
        ListCreditType LC with (NOLOCK)
    ON
        LC.CreditTypeUid=RF.IncomeAccountUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewEmployer]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewEmployer]
AS
SELECT		e.CorporationUid, cp.ExternalID, cp.Name, e.Inactive | cp.Inactive AS Inactive,
			cp.[Address],
			cp.Address1,
			cp.Address2,
			cp.City,
			cp.[State],
			cp.Zip,
			cp.[Phone1],
			cp.PhoneNumber,
			cp.PhoneType,
			vip.Name AS InsuranceName,
			e.Notes
FROM		Employer e LEFT JOIN ViewCorporation AS cp ON cp.CorporationUid = e.CorporationUid 
			LEFT JOIN RelEmployerInsurancePlan reip ON e.CorporationUid = reip.CorporationUid AND 
						(reip.EffectiveDate IS NULL OR reip.EffectiveDate <= GetDate()) AND (reip.ExpirationDate IS NULL OR reip.ExpirationDate > GetDate())
			LEFT JOIN ViewInsurancePlan vip ON reip.InsurancePlanUid = vip.InsurancePlanUid					

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_PayerCreditCandidate_DistributionLedger]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[AR_PayerCreditCandidate_DistributionLedger] AS
   SELECT
      PayerUid                = CASE
                                    WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ins.InsuranceCarrierUid
                                    ELSE acc.AccountResponsiblePartyUid
                                END,
      PayerType               = CASE
                                      WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ''Insurance Payer''
                                      ELSE ''Acount Responsible Party''
                                END,
      PayerName               = CASE
                                   WHEN ins.InsuranceCarrierUid IS NOT NULL THEN ins.Name
                                   ELSE vpn.FullName
                                END,
      LiabilityOwner          = ots.LiabilityOwner,                                
      SuperbillUid            = sbp.SuperbillUid,
      SuperbillProcedureUid   = sbp.SuperbillProcedureUid,
      DepositUid              = ISNULL(ard.DepositUid, crd.DepositUid),
      LedgerUid               = arl.LedgerUid,
      PayerPaid               = CASE WHEN arl.EntryType = 2 AND ard.IsCredit = 0 THEN ard.Amount ELSE 0 END
   FROM AR_LedgerDetail ard
   INNER JOIN AR_Ledger arl ON arl.LedgerUid = ard.LedgerUid
   INNER JOIN AR_LedgerDetail ots ON ots.LedgerDetailUid != ard.LedgerDetailUid AND ots.LedgerUid = ard.LedgerUid
   INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = ots.SuperbillProcedureUid AND sbp.Inactive != 1
   LEFT JOIN AR_PayerCredit crd ON crd.PayerCreditUid = ard.PayerCreditUid
   INNER JOIN ListProcedure prc ON prc.ProcedureUid = sbp.ProcedureUid
   INNER JOIN Superbill sbx ON sbx.SuperbillUid = sbp.SuperbillUid
   INNER JOIN Account acc ON acc.AccountUid = sbx.AccountUid
   INNER JOIN AccountResponsibleParty arp ON arp.AccountResponsiblePartyUid = acc.AccountResponsiblePartyUid
   INNER JOIN Person per ON per.PersonUid = arp.PersonUid
   INNER JOIN ViewPerson (NOEXPAND) vpn ON vpn.PersonUid = per.PersonUid
   LEFT JOIN InsurancePlan ins ON ins.InsurancePlanUid = ots.InsurancePlanUid
   LEFT JOIN InsuranceCarrier inc ON inc.CorporationUid = ins.InsuranceCarrierUid
   WHERE arl.EntryType = 2
     AND ard.IsCredit = 0
     AND ISNULL(ard.DepositUid, crd.DepositUid) IS NOT NULL

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_PatientLedger_Header]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[MDOL_RPT2_PatientLedger_Header]
AS
-- $Id: PatientLedger.sql,v 1.10 2008/09/28 02:39:45 broy Exp $
-- THIS STORED PROCEDURE IS UNDER SOURCE CONTROL. ANY CHANGES TO IT NEED TO BE COMMITTED TO THE FILE LISTED IN THE ID TAG ABOVE.
-- AFTER COMMITTING YOUR CHANGE DEVELOPMENT DATABASE(S) ON FIJI MUST BE ALSO UPDATED.
SELECT
	pp.personUID AS patientID,
	-- pp.XMLe AS pp.XMLe,
	Patient.ExternalId,
					(CASE WHEN pp.LastName IS NULL THEN ''''
						ELSE pp.LastName + '', ''
				END )
				+
				RTRIM((CASE WHEN pp.FirstName IS NULL THEN ''''
						ELSE pp.FirstName + '' ''
				END )
				+
				(CASE WHEN pp.MiddleName IS NULL THEN ''''
						ELSE pp.MiddleName
				END))
				+
				(CASE WHEN pp.Suffix IS NULL OR RTRIM(pp.Suffix)='''' THEN ''''
						ELSE '', '' + pp.Suffix
				END) AS patientName,
	--dbo.UDF_getFormattedPreferredName (pp.PersonUid) AS patientName,
	arp.AccountResponsiblePartyUid,
	CASE WHEN arp.PersonUid IS NULL THEN rc.CorporationUid
	WHEN arp.CorporationUid IS NULL THEN rp.personUid
	END AS responsiblePersonID,
	CASE WHEN arp.PersonUid IS NULL THEN
	rc.Name
	WHEN arp.CorporationUid IS NULL THEN
					(CASE WHEN rp.LastName IS NULL THEN ''''
						ELSE rp.LastName + '', ''
				END )
				+
				RTRIM((CASE WHEN rp.FirstName IS NULL THEN ''''
						ELSE rp.FirstName + '' ''
				END )
				+
				(CASE WHEN rp.MiddleName IS NULL THEN ''''
						ELSE rp.MiddleName
				END))
				+
				(CASE WHEN rp.Suffix IS NULL OR RTRIM(rp.Suffix)='''' THEN ''''
						ELSE '', '' + rp.Suffix
				END)
	-- dbo.UDF_getFormattedPreferredName (rp.PersonUid)
	ELSE '''' END AS responsibleName,
	CASE WHEN arp.PersonUid IS NULL THEN
	rc.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
	WHEN arp.CorporationUid IS NULL THEN
	ISNULL(rp.Address1, rp.Address2).value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') 
	ELSE '''' END AS address1,
	CASE WHEN arp.PersonUid IS NULL THEN
	rc.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
	WHEN arp.CorporationUid IS NULL THEN
	ISNULL(rp.Address1, rp.Address2).value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') 
	ELSE '''' END AS address2,
	CASE WHEN arp.PersonUid IS NULL THEN
	rc.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'')
	WHEN arp.CorporationUid IS NULL THEN
	ISNULL(rp.Address1, rp.Address2).value(''(/Address/City)[1]'', ''VARCHAR(100)'') 
	ELSE '''' END AS city,
	CASE WHEN arp.PersonUid IS NULL THEN
	rc.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'')
	WHEN arp.CorporationUid IS NULL THEN
	ISNULL(rp.Address1, rp.Address2).value(''(/Address/State)[1]'', ''VARCHAR(100)'') 
	ELSE '''' END AS state,
	CASE WHEN arp.PersonUid IS NULL THEN
	rc.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
	WHEN arp.CorporationUid IS NULL THEN
	ISNULL(rp.Address1, rp.Address2).value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') 
	ELSE '''' END AS zip,
	CASE WHEN arp.PersonUid IS NULL THEN
	ISNULL(rc.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''),'''')
	WHEN arp.CorporationUid IS NULL THEN
	ISNULL(rp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''),'''')
	ELSE ''''
	END AS dayPhone,
	CASE WHEN arp.PersonUid IS NULL THEN ''''
	WHEN arp.CorporationUid IS NULL THEN
	ISNULL(rp.Phone2.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''), '''')
	ELSE ''''
	END AS eveningPhone,
	a.Name AS AccountName,
	a.accountUid AS AccountId,
	a.LastStatementDate,
	(VA.LiabilityBalance - VA.AssignedLiabilityBalance)  AS patientLiabilityBalance,
	(VA.AssignedLiabilityBalance ) AS InsuranceLiabilityBalance,
	VA.LiabilityBalance AS AccountBalance,
	arp.ExternalID as RPID
FROM Person as pp WITH (NOLOCK)
	INNER JOIN Patient WITH (NOLOCK) 
	ON	pp.personUid=patient.personUid
	INNER JOIN Account as A WITH (NOLOCK)
	ON A.personUid = pp.personUid
	INNER JOIN AR_ViewAccountAggregate as VA WITH (NOLOCK)
	ON A.AccountUid=VA.AccountUid 
	INNER JOIN AccountResponsibleParty as arp WITH (NOLOCK)
	ON arp.AccountResponsiblePartyUid = A.AccountResponsiblePartyUid
	LEFT JOIN person as rp WITH (NOLOCK)
	ON rp.personUid = arp.PersonUid
	LEFT JOIN Corporation as rc WITH (NOLOCK)
	ON rc.CorporationUid = arp.CorporationUid






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementResponsiblePartyByFinancialCenterSumBase]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewStatementResponsiblePartyByFinancialCenterSumBase] AS
/* This is the source for electronic statements and also for paper statements, indirectly via
the stored proc MDOL_RPT2_StatementHeader/ One record per responsible party with active accounts.
*/
SELECT
a.AccountResponsiblePartyUid as RPUid,
va.FinancialCenterUid,
fc.Name as CustomerName,
(CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.FirstName,'''') + '' ''+ ISNULL(p.MiddleName,'''') +'' ''+ ISNULL(p.LastName,'''')
WHEN c.CorporationUid IS NOT NULL THEN c.Name
END) as RPName,
fc.Name as RemitToName,
p.PersonUid,
c.CorporationUid,
arp.ExternalID as RPID,
arp.LastStatementDate as LastStatementDate,
CAST(GetDate() AS DATE) as StatementDate,
DATEADD(day, fc.StatementDueDays, CAST(GetDate() AS DATE)) as DueDate,
fc.StatementMinimumAmount,
(CASE WHEN ps.IncludeCompletedOrClosed=1
THEN VPA.CompleteBatchAmount
ELSE VPA.AMOUNT END) AS AmountDue,
VA.LiabilityBalance as TotalBalance,
VA.LiabilityBalance - VA.AssignedLiabilityBalance as PatientBalance,
VA.AssignedLiabilityBalance as InsuranceBalance,
'''' as Note,
(CASE WHEN arp.CycleTrigger = 1 THEN 1 WHEN EXISTS
(SELECT 1 FROM Account WHERE Account.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid AND Account.CycleTrigger = 1)
THEN 1 ELSE 0 END) AS CycleTrigger,
fc.IncludeCompletedOrClosed

FROM AccountResponsibleParty arp
INNER JOIN [AR_ViewStatementARPByFinancialCenter] VA ON va.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
inner join Account a on a.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
LEFT join AR_ViewPatientAmountDue VPA on vpa.AccountResponsiblePartyUid = va.AccountResponsiblePartyUid and vpa.FinancialCenterUid = va.financialcenteruid
LEFT JOIN Person p ON p.PersonUid = arp.PersonUid
LEFT JOIN Corporation c ON c.CorporationUid = arp.CorporationUid
inner join FinancialCenter fc on fc.FinancialCenterUid = va.FinancialCenterUid,
PracticeSettings ps

WHERE
a.Inactive = 0
AND fc.Inactive=0
GROUP BY
fc.Name,
fc.FinancialCenterUid,
arp.AccountResponsiblePartyUid,
va.financialcenteruid,
arp.ExternalID,
c.Name,
p.PersonUid,
p.FirstName,
p.LastName,
p.MiddleName,
a.AccountResponsiblePartyUid,
c.CorporationUid,
arp.PersonUid,
arp.CorporationUid,
arp.CycleTrigger,
arp.LastStatementDate,
va.liabilitybalance,
va.assignedliabilitybalance,
fc.StatementDueDays,
fc.StatementMinimumAmount,
fc.IncludeCompletedOrClosed,
ps.IncludeCompletedOrClosed,
vpa.CompleteBatchAmount,
vpa.AMOUNT


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalanceByFinancialCenter]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewStatementSuperbillBalanceByFinancialCenter]  WITH SCHEMABINDING
AS 
SELECT
	A.AccountResponsiblePartyUid as RPUid, 	
	SUM(CAST(0 AS MONEY)) AS PayerCreditBalance,
	S.SuperbillUid, 
	LD.FinancialCenterUid,
	Sum(Case When LD.LiabilityOwner > 0  Then LD.Amount Else Convert(Money, 0) End) as Insurance, 
	Sum(Case When LD.LiabilityOwner = 0  Then LD.Amount Else Convert(Money, 0) End) as Patient,
	Sum(LD.Amount) as LiabilityBalance,
	S.SuperbillStatusUid,
	COUNT_BIG(*) MaxCnt
FROM	dbo.AR_Ledger (NOLOCK) L
INNER JOIN	dbo.AR_LedgerDetail (NOLOCK) LD
ON	L.LedgerUid=LD.LedgerUid 
INNER JOIN	dbo.SuperbillProcedure (NOLOCK) SP
ON	SP.SuperbillProcedureUid=LD.SuperbillProcedureUid
INNER JOIN	dbo.Superbill (NOLOCK) S
ON	S.SuperbillUid=SP.SuperbillUid
INNER JOIN	dbo.Account (NOLOCK) A
ON	S.AccountUid = A.AccountUid
GROUP BY 
	A.AccountResponsiblePartyUid, S.SuperbillUid, LD.FinancialCenterUid, S.SuperbillStatusUid

/*
Developer Note: Make sure indexes still exist after running Alter Table. If not Run Command below.
CREATE UNIQUE CLUSTERED INDEX PK_ViewStatementSuperbillBalanceByFinancialCenter_AccountResponsiblePartyUid ON ViewStatementSuperbillBalanceByFinancialCenter(RPUid, SuperbillUid, FinancialCenterUid)

*/


' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalanceByFinancialCenter]') AND name = N'PK_ViewStatementSuperbillBalanceByFinancialCenter_AccountResponsiblePartyUid')
CREATE UNIQUE CLUSTERED INDEX [PK_ViewStatementSuperbillBalanceByFinancialCenter_AccountResponsiblePartyUid] ON [dbo].[ViewStatementSuperbillBalanceByFinancialCenter]
(
	[RPUid] ASC,
	[SuperbillUid] ASC,
	[FinancialCenterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalanceByFinancialCenterExcludeStatus]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[ViewStatementSuperbillBalanceByFinancialCenterExcludeStatus] 
AS 
SELECT
	RPUid, 	
	SuperbillUid, 
	vssbbfc.FinancialCenterUid,
	Insurance, 
	Patient,
	LiabilityBalance,
	MaxCnt
FROM dbo.ViewStatementSuperbillBalanceByFinancialCenter vssbbfc WITH (NOEXPAND)
LEFT OUTER JOIN dbo.RelFinancialCenterSuperbillStatus (NOLOCK) rfcss
ON vssbbfc.SuperbillStatusUid = rfcss.SuperbillStatusUid AND vssbbfc.FinancialCenterUid = rfcss.FinancialCenterUid
WHERE rfcss.superbillstatusuid is null


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[UDS_View_PatientGenderRaceEthnicity]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[UDS_View_PatientGenderRaceEthnicity]
AS      
      SELECT pat.personuid,    
      pat.externalid,    
      COALESCE(g.Name,''Not Recorded'') AS Gender ,     
      p.Birthdate,    
      rpc.PatientConditionUid,
      coalesce(r.Name,''Unreported/Refused to report'') AS Race,    
      coalesce(e.Name,''Unreported/Refused to report'') AS Ethnicity,
      COALESCE((vfp.FirstName + '','' + vfp.LastName),''Not Recorded'') AS PrimaryProvider
      FROM Patient pat     
      INNER JOIN Person p ON pat.PersonUid = p.PersonUid     
      LEFT JOIN ListGender g ON p.GenderUid = g.GenderUid     
      LEFT JOIN ListRace r ON dbo.GetPrimaryRaceUid(p.PersonUid) = r.RaceUid     
      LEFT JOIN ListEthnicity e ON dbo.GetPrimaryEthnicityUid (p.PersonUid) = e.EthnicityUid
      LEFT JOIN ViewFindProvider vfp ON pat.ProviderUid = vfp.PersonUid
	  LEFT JOIN RelPatientCondition rpc on pat.PersonUid = rpc.PatientUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewListCacheMachine]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewListCacheMachine]  AS 
WITH ctePracticeSettings AS
(
	SELECT TOP 1 *
	FROM PracticeSettings
	ORDER BY LastModifiedDate DESC
)
SELECT		lcm.CacheMachineUid, 
			lcm.ID, 
			lcm.ExternalID, 
			lcm.Name, 
			lcm.URL, 
			lcm.Notes, 
			lcm.Inactive, 
			COALESCE (lcm.ReplicationAppointmentHours, ps.ReplicationAppointmentHours) AS ReplicationAppointmentHours, 
			COALESCE (lcm.ReplicationAttachmentSizeKB, ps.ReplicationAttachmentSizeKB) AS ReplicationAttachmentSizeKB,
			COALESCE (lcm.TriggerRemovePatientSeconds, ps.TriggerRemovePatientSeconds) AS TriggerRemovePatientSeconds,
			COALESCE (lcm.ReplicationRemovePatientHours, ps.ReplicationRemovePatientHours) AS ReplicationRemovePatientHours,
			COALESCE (lcm.TriggerReplicationSeconds, ps.TriggerReplicationSeconds) AS TriggerReplicationSeconds,
			lcm.EnableLogging, 
			lcm.Status, 
			lcm.ReplicateEverything,
			lcm.ReplicationMode, 
			lcm.LastModifiedByUid, 
			lcm.LastModifiedDate
FROM        dbo.ListCacheMachine AS lcm, ctePracticeSettings AS ps
WHERE		exists ( SELECT TOP 1 *
					 FROM dbo.ReplicationFilter AS rf
					 WHERE rf.CacheMachineUid = lcm.CacheMachineUid )
						or lcm.inactive = 1

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewReplicationStatus]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewReplicationStatus] AS
	SELECT cm.CacheMachineUid,
		cm.URL,
		CASE WHEN cm.ReplicateEverything <> 0 THEN ''Site-to-Site Replication''
			 WHEN EXISTS (SELECT TOP 1 * FROM RelCacheMachineFinancialCenter WHERE CacheMachineUid = cm.CacheMachineUid) THEN ''Financial Center Replication''
			 WHEN EXISTS (SELECT TOP 1 * FROM RelCacheMachineProvider WHERE CacheMachineUid = cm.CacheMachineUid)
				OR EXISTS (SELECT TOP 1 * FROM RelCacheMachineUserPRM WHERE CacheMachineUid = cm.CacheMachineUid) THEN ''Selective Replication''
			 ELSE
				''Other''
		END AS ReplicationType,
		rs.InitialReplicationCompletedDate,
		rs.LogonAt,
		rs.ConnectionStatus,
		rs.UploadStartAt,
		rs.PatientsToUpload,
		rs.MessagesToUpload,
		rs.UploadPending,
		rs.UploadFailures,
		rs.UploadTotal,
		rs.UploadTableInProgress,
		rs.LastCopiedObjectInUploadTableInProgress,
		CASE WHEN rs.UploadStatus  NOT LIKE ''%Exception%'' AND
				rs.LastCopiedObjectInUploadTableInProgress IS NOT NULL THEN
			rs.UploadStatus + '' - last completed item - '' + CAST (rs.LastCopiedObjectInUploadTableInProgress AS VARCHAR (128))
			 ELSE rs.UploadStatus
		END UploadStatus,
		rs.LastUploadCompletedFailures,
		rs.LastUploadCompletedDate,
		rs.DownloadStartAt,
		rs.PatientsToDownload,
		rs.MessagesToDownload,
		rs.DownloadPending,
		rs.DownloadFailures,
		rs.DownloadTotal,
		rs.DownloadTableInProgress,
		rs.LastCopiedObjectInDownloadTableInProgress,
		CASE WHEN rs.DownloadStatus NOT LIKE ''%Exception%'' AND
				rs.LastCopiedObjectInDownloadTableInProgress IS NOT NULL THEN
			rs.DownloadStatus + '' - last completed item - '' + CAST (rs.LastCopiedObjectInDownloadTableInProgress AS VARCHAR (128))
			 ELSE rs.DownloadStatus
		END DownloadStatus,
		rs.LastDownloadCompletedFailures,
		rs.LastDownloadCompletedDate,
		cm.Inactive,
		rs.MasterServerURI,
		rs.CacheServerURI
	FROM ViewListCacheMachine AS cm
		LEFT OUTER JOIN ReplicationStatus AS rs ON cm.CacheMachineUid = rs.ReplicationStatusUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFormTitlePatient]'))
EXEC dbo.sp_executesql @statement = N'
--
-- Fix for bug #54815
--

CREATE VIEW [dbo].[ViewFormTitlePatient] AS
SELECT 
	pat.PersonUid, pat.ExternalID, pat.MedicalRecordNumber, 
	per.FirstName, per.MiddleName, per.LastName, per.Suffix, pern.FormattedPreferredName AS FullName, 
	pern.Address1_Address1 AS Address1, pern.Address1_Address2 AS Address2, pern.Address1_City AS City, pern.Address1_State AS [State], pern.Address1_Zip AS Zip, 
	per.email1 AS Email, 
	dbo.GetPatientCondition(per.PersonUid) AS Condition, ll.Name AS Language, lg.Name AS Gender, lr.Name AS Race, le.name AS Ethnicity, lms.name MaritalStatus, 
	ldh.name DominantHand, 
	convert(varchar, per.Birthdate, 110) AS Birthdate, per.SocialSecurityNumber, per.DriverLicenseNumber, per.DriverLicenseState, 
	pro.FirstName AS ProviderFirstName, pro.MiddleName AS ProviderMiddleName, pro.LastName AS ProviderLastName, pron.FormattedPreferredName AS ProviderFullName,
    CASE 
      WHEN RIGHT(''00''+CAST(MONTH(per.Birthdate) AS VARCHAR(2)),2)+RIGHT(''00''+CAST(DAY(per.Birthdate) AS VARCHAR(2)),2) >= RIGHT(''00''+CAST(MONTH(GETDATE()) AS VARCHAR(2)),2)+RIGHT(''00''+CAST(DAY(GETDATE()) AS VARCHAR(2)),2)
      THEN DATEDIFF(Year, per.Birthdate, GETDATE()) 
      ELSE DATEDIFF(Year, per.Birthdate, GETDATE())-1 
    END AS age,
	
	pip.CopayPrimary,
	pip.CopaySpecialist,
	pip.CopayOther,
	pip.PlanMemberID,
	pip.PlanGroupID,
	pip.InsuranceCarrier,
	pip.InsurancePlan,

	CONVERT(date, getdate()) as VisitDate

FROM patient pat
JOIN person per on per.PersonUid = pat.PersonUid
LEFT JOIN ViewPerson pern on pern.PersonUid = pat.PersonUid
LEFT JOIN person pro on pro.PersonUid = pat.ProviderUid
LEFT JOIN ViewPerson pron on pron.PersonUid = pro.PersonUid
LEFT JOIN ListLanguage ll on ll.LanguageUid = per.LanguageUid
LEFT JOIN ListGender lg on lg.GenderUid = per.GenderUid
LEFT JOIN ListRace lr on lr.RaceUid = dbo.GetPrimaryRaceUid(per.PersonUid)
LEFT JOIN ListEthnicity le on le.EthnicityUid = dbo.GetPrimaryEthnicityUid (per.PersonUid)
LEFT JOIN ListMaritalStatus lms on lms.MaritalStatusUid = per.MaritalStatusUid
LEFT JOIN ListDominantHand ldh on ldh.DominantHandUid = per.DominantHandUid
OUTER APPLY (
                SELECT TOP 1 
                                pip.CopayPrimary, 
                                pip.CopaySpecialist, 
                                pip.CopayOther, 
                                pip.PlanMemberID, 
                                pip.PlanGroupID, 
                                ip.Name as [InsurancePlan], 
                                c.Name as [InsuranceCarrier], 
                                a.PersonUid
                FROM  dbo.Account AS a 
                INNER JOIN dbo.AccountPeriod AS ap ON a.AccountUid = ap.AccountUid
                                                                AND ap.ExpirationDate IS NULL and a.IsMain = 1
                LEFT JOIN dbo.AccountInsurance AS ai ON ap.AccountPeriodUid = ai.AccountPeriodUid AND ai.DisplayOrder = 1
                LEFT JOIN dbo.PersonInsurancePlan AS pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid 
                LEFT JOIN dbo.InsurancePlan AS ip ON pip.InsurancePlanUid = ip.InsurancePlanUid
                LEFT JOIN dbo.Corporation AS c ON ip.InsuranceCarrierUid = c.CorporationUid   
                WHERE a.PersonUid = pat.PersonUid  
) pip


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalanceExcludeStatus]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewStatementSuperbillBalanceExcludeStatus] 
AS 
SELECT
	RPUid, 
	SuperbillUid, 
	FinancialCenterUid,
	Insurance, 
	Patient,
	LiabilityBalance,
	MaxCnt
FROM	dbo.ViewStatementSuperbillBalance vssb WITH (NOEXPAND)
LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
ON vssb.SuperbillStatusUid = rpsss.SuperbillStatusUid
where rpsss.superbillstatusuid is null

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPayerCredit_ReportVersion]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewPayerCredit_ReportVersion]
AS
	-- civa specific to overwrite current due to breaks financial reports
	-- broy 2015-04-09

	with cteArpPayersWithActiveSuperbills AS
	(
		SELECT DISTINCT act.AccountResponsiblePartyUid
		FROM AR_LedgerDetail ld WITH (NOLOCK) 
				INNER JOIN Account act WITH (NOLOCK) on ld.AccountResponsiblePartyUid = act.AccountResponsiblePartyUid
				INNER JOIN Superbill sb WITH (NOLOCK) on act.AccountUid = sb.AccountUid
		WHERE ld.PayerCreditUid IS NOT NULL 
				AND  NOT SB.SuperbillStatusUid  IN (''FC8AD61B-139A-4CFA-9580-CDACFC3ACF90'', ''30F64D66-55CB-4438-BB2F-7A6250399312'') -- Canceled and Complete			
	),
	cteInsPayersWithActiveSuperbills AS
	(
		select distinct ld.InsurancePlanUid
		FROM AR_LedgerDetail ld WITH (NOLOCK)
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) on ld.SuperbillProcedureUid = sbp.SuperbillProcedureUid
				INNER JOIN Superbill sb WITH (NOLOCK) on sbp.SuperbillUid = sb.SuperbillUid
		WHERE ld.PayerCreditUid IS NOT NULL
			  AND ld.InsurancePlanUid IS NOT NULL
			  AND NOT SB.SuperbillStatusUid  IN (''FC8AD61B-139A-4CFA-9580-CDACFC3ACF90'', ''30F64D66-55CB-4438-BB2F-7A6250399312'') -- Canceled and Complete
	),
	cteArpNextAppointment AS
	(
		SELECT act.AccountResponsiblePartyUid, MIN(AP.StartDateTime) AS NextAppointmentStartDateTime
		FROM AR_LedgerDetail ld WITH (NOLOCK) 
				INNER JOIN Account act WITH (NOLOCK) on ld.AccountResponsiblePartyUid = act.AccountResponsiblePartyUid
				INNER JOIN Appointment AP WITH (NOLOCK) ON act.AccountUid = AP.AccountUid AND AP.StartDateTime > GETUTCDATE()
		WHERE ld.PayerCreditUid IS NOT NULL 
		GROUP BY act.AccountResponsiblePartyUid

	),
	apcCTEZ AS
	(
		select 
			  apc.PayerCreditUid as PayerCreditUid,
			  d.PaymentTypeUid as PaymentTypeUid,
			  d.ReferenceNumber,
			  d.DepositUid,
			  apc.RefundApprovedByUid,
			  apc.payercreditrefundstatusuid,
			  apc.Note, 
			  apc.RefundNote,
			  apc.RefundApprovedDate,
			  MAX( ld.CreatedDateTime ) as apcMaxTime
		FROM AR_PayerCredit apc WITH (NOLOCK)
				INNER JOIN Deposit d WITH (NOLOCK) ON apc.DepositUid = d.DepositUid
				INNER JOIN AR_LedgerDetail ld WITH (NOLOCK) on apc.PayerCreditUid = ld.PayerCreditUid
				INNER JOIN AR_LedgerDetail ld_os WITH (NOLOCK) ON ld.LedgerUid = ld_os.LedgerUid
																	AND ld_os.DepositUid = apc.DepositUid -- bug 28096 -- want to weed out all ledger records that are not related to the original payer credit deposit -- i.e. refunds 
		GROUP BY apc.PayerCreditUid, d.PaymentTypeUid, d.ReferenceNumber, d.DepositUid, RefundApprovedByUid, payercreditrefundstatusuid,
					   apc.Note, apc.RefundNote, apc.RefundApprovedDate

	)
		select 
			  apcz.PayerCreditUid as PayerCreditUid,
			   ld.LedgerDetailUid,
			   apcz.DepositUid,
		       apcz.ReferenceNumber as ReferenceNumber,
			   apcz.Note, 
			   ld.ServiceSiteUid ,
			   lss.Name as ServiceSiteName,
			   ld.FinancialCenterUid ,
		       fc.Name AS FinancialCenterName,
			   ld.RenderingProviderUid ,
		       rendPr.FullName AS ProviderFullName,
			   ld.ClaimingProviderUid ,
			   clmPr.FullName AS ClaimProviderFullName,
			   ld.AccountResponsiblePartyUid,
		       COALESCE(VPer.FullName, '''') AS ResponsiblePartyFullName,
			   ld.InsurancePayerUid,
			   COALESCE(VPCorp.Name,'''') AS InsurancePayerFullName,
			   vpca.Receipt as Receipt,
		       vpca.ReceiptBalance as ReceiptBalance,
		       ISNULL(IPA.LiabilityBalance,0) AS InsurancePayerLiabilityBalance,
			   ISNULL(ARPA.LiabilityBalance,0) AS AccountResponsiblePartyLiabilityBalance ,
			  CAST(CASE 
					WHEN arpASB.AccountResponsiblePartyUid IS NOT NULL THEN 1
					WHEN insASB.InsurancePlanUid IS NOT NULL THEN 1
					ELSE 0 END AS BIT) as HasActiveSuperbills,
			   ISNULL(arb.IsLocked,0) AS IsLocked,
		       ISNULL(arb.IsClosed,0) AS IsClosed,
		       CASE WHEN arb.IsClosed = 1 THEN ''Closed'' 
			        WHEN arb.IsLocked = 1 THEN ''Locked''
			  ELSE ''Open'' END as BatchState,
			  CASE WHEN COALESCE(arl.VoidLedgerUid, Varl.LedgerUid) IS NULL THEN 0 ELSE 1 END AS Void,
			  CAST((CASE WHEN ISNULL(VPCA.ReceiptBalance,0) = 0 THEN 1 ELSE 0 END) AS bit) as IsFullyAllocated,
			  arb.ArBatchUid as ARBatchUid,
			  arb.Name as ARBatchName,
			  aprna.NextAppointmentStartDateTime,
			  isnull(pcrs.PayerCreditRefundStatusUid, pcrsOpen.PayerCreditRefundStatusUid) AS PayerCreditRefundStatusUid,
			  isnull(pcrs.Name, pcrsOpen.Name) AS RefundStatus,
			  apcz.RefundNote,
			  apcz.PaymentTypeUid as PaymentTypeUid,
			  LPT.Name as PaymentTypeName,
			  LPT.DefaultRefundPaymentTypeUid,
			  LPTREF.Name as DefaultRefundPaymentTypeName,
			  apcz.RefundApprovedDate,
			  apcz.RefundApprovedByUid,
			  REFAPVDP.FullName AS RefundApprovedByPersonName			
		FROM APCCTEZ apcz WITH (NOLOCK)
			    INNER JOIN AR_ViewPayerCredit vpca WITH (NOLOCK) on apcz.PayerCreditUid = vpca.PayerCreditUid
				INNER JOIN AR_LedgerDetail ld WITH (NOLOCK) on apcz.PayerCreditUid = ld.PayerCreditUid
																AND ld.CreatedDateTime = apcz.apcMaxTime  -- join back to the ledger detail with the correct max date
				-- NOTE:  ld_os not strictly needed but seems to help with number of reads while not affecting Duration significantly
				INNER JOIN AR_LedgerDetail ld_os WITH (NOLOCK) ON ld.LedgerUid = ld_os.LedgerUid
																	AND ld_os.DepositUid = apcz.DepositUid -- bug 28096 -- want to weed out all ledger records that are not related to the original payer credit deposit -- i.e. refunds 
				INNER JOIN AR_Ledger arl ON LD.LedgerUid = arl.LedgerUid
				INNER JOIN ARBatch ARB ON arl.ARBatchUid = ARB.ARBatchUid
				LEFT OUTER JOIN ListPaymentType LPT WITH (NOLOCK) on apcz.PaymentTypeUid = LPT.PaymentTypeUid
				LEFT OUTER JOIN ListPaymentType LPTREF WITH (NOLOCK) ON LPT.DefaultRefundPaymentTypeUid = LPTREF.PaymentTypeUid	
				LEFT OUTER JOIN ListServiceSite lss WITH (NOLOCK) on ld.ServiceSiteUid = lss.ServiceSiteUid
				LEFT OUTER JOIN FinancialCenter fc WITH (NOLOCK) on ld.FinancialCenterUid = fc.FinancialCenterUid
				LEFT OUTER JOIN ViewPerson rendPr WITH (NOLOCK) on ld.RenderingProviderUid = rendPR.PersonUid
				LEFT OUTER JOIN ViewPerson clmPr WITH (NOLOCK) on ld.ClaimingProviderUid = clmPr.PersonUid
				LEFT OUTER JOIN AccountResponsibleParty ARP WITH (NOLOCK) ON ld.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid -- on deposit
				LEFT OUTER JOIN ViewPerson VPer WITH (NOLOCK) ON ARP.PersonUid = VPer.PersonUid
				LEFT OUTER JOIN Corporation VPCorp WITH (NOLOCK) ON ld.InsurancePayerUid = VPCorp.CorporationUid
				LEFT OUTER JOIN AR_ViewInsurancePayerAggregate IPA WITH (NOLOCK) ON ld.InsurancePayerUid = IPA.InsurancePayerUid
				LEFT OUTER JOIN AR_ViewAccountResponsiblePartyAggregate ARPA WITH (NOLOCK) ON ld.AccountResponsiblePartyUid = ARPA.AccountResponsiblePartyUid
				LEFT OUTER JOIN cteArpPayersWithActiveSuperbills arpASB on ld.AccountResponsiblePartyUid = arpASB.AccountResponsiblePartyUid
				LEFT OUTER JOIN cteInsPayersWithActiveSuperbills insASB on ld.InsurancePlanUid = insASB.InsurancePlanUid
				LEFT OUTER JOIN AR_Ledger Varl WITH (NOLOCK) ON  ld.LedgerUid = Varl.VoidLedgerUid
				LEFT OUTER JOIN ViewPerson REFAPVDP WITH (NOLOCK) ON apcz.RefundApprovedByUid = REFAPVDP.PersonUid
				LEFT OUTER JOIN cteArpNextAppointment aprna on ld.AccountResponsiblePartyUid = aprna.AccountResponsiblePartyUid
				LEFT OUTER JOIN ListPayerCreditRefundStatus pcrs WITH (NOLOCK) on apcz.payercreditrefundstatusuid = pcrs.payercreditrefundstatusuid
				LEFT OUTER JOIN ListPayerCreditRefundStatus pcrsOpen WITH (NOLOCK) on pcrsOpen.PayerCreditRefundStatusUid = ''5279AEE2-EF6A-44E5-8A3C-A6A4A916DB40''






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewPayerCreditByDeposit]'))
EXEC dbo.sp_executesql @statement = N'
-- Bug 35252 - deposits in closed batches appear to have unallocated funds on deposit screen, but don''t in tracking screen
--          one payer credit containing multiple batches causes problems.  Now just put in individual entries into payer credit

CREATE VIEW [dbo].[AR_ViewPayerCreditByDeposit] 
AS

	with myCTE as
	(
		select apc.PayerCreditUid,
			   apc.Note as Name,
			   d.ReferenceNumber,
			   arb.Name as BatchName,
			   arb.ARBatchUid,
			   ldDep.DepositUid,
			   (ldPC.CreatedDateTime) AS CreatedDateTime,
			   (ldPC.Amount) as pcDistribution,			   
			   CASE WHEN (apc.DepositUid = ldDep.DepositUid) THEN ''Payer Credit'' ELSE ''Refund'' END as Type
		from AR_PayerCredit apc with (nolock)
				INNER JOIN AR_LedgerDetail ldPC on apc.PayerCreditUid = ldPC.PayerCreditUid -- Payer Credit LedgerDetail
				INNER JOIN AR_Ledger arl on ldPC.LedgerUid = arl.LedgerUid					-- AR_Ledger
												AND arl.EntryType = 0
												AND arl.VoidLedgerUid IS NULL
				INNER JOIN AR_LedgerDetail ldDep on arl.LedgerUid = ldDep.LedgerUid
													AND ldPC.LedgerDetailUid != ldDep.LedgerDetailUid -- ''Other side'' is Deposit reference 
				INNER JOIN Deposit d with (nolock) on ldDep.DepositUid = d.DepositUid
				INNER JOIN ARBatch arb with (nolock) on arl.ArBatchUid = arb.ARBatchUid
				LEFT OUTER JOIN AR_Ledger arlVoid with (nolock) on arl.LedgerUid = arlVoid.VoidLedgerUid
		WHERE arlVoid.LedgerUid IS NULL
		--group by apc.PayerCreditUid, apc.Note, d.ReferenceNumber, arb.Name,arb.ARBatchUid, 
		--		ldDep.DepositUid, apc.DepositUid
	)
	select NEWID() as AR_ViewTransactionUid, -- fake transactionUid.  Can''t use PayerCreditUid or DepositUid since they not be unique in the rows returned,
		   mc.PayerCreditUid,
		   mc.Name,
		   mc.ReferenceNumber,
		   --(CASE WHEN mc.Type = ''Refund'' THEN pcDistribution -- (pca.Receipt - pca.ReceiptBalance)
		   --     ELSE pca.Receipt END) AS Distribution,
		   (CASE WHEN mc.Type = ''Refund'' THEN pcDistribution -- (pca.Receipt - pca.ReceiptBalance)
		        ELSE -(pcDistribution) END) AS Distribution,
		   --pca.Receipt as Distribution, -- Distribution means distributed "to" the payer credit in this case
		   pca.ReceiptBalance,
		   -pcDistribution as Receipt, --pca.Receipt, 
		   mc.BatchName,
		   mc.ARBatchUid,
		   mc.DepositUid,
		   mc.CreatedDateTime,
		   mc.Type
	from myCTE mc
			--INNER JOIN AR_ViewPayerCreditAggregate pca with (nolock) on mc.PayerCreditUid = pca.PayerCreditUid
			INNER JOIN AR_ViewPayerCredit pca with (nolock) on mc.PayerCreditUid = pca.PayerCreditUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPatientResponsibleDate]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbillPatientResponsibleDate]  
AS  
Select SP.SuperbillUid,MAX(ARB.GLDate) AS PatientResponsibleDate 
From
	AR_Ledger L
JOIN
	AR_LedgerDetail LD 
ON
	L.LedgerUid =ld.LedgerUid AND (L.EntryType =1 OR L.EntryType =4) AND LiabilityOwner =0
JOIN
	SuperbillProcedure	SP
ON
	LD.SuperbillProcedureUid =SP.SuperbillProcedureUid
JOIN
	AR_ViewSuperbillAggregate VSA
ON
	SP.SuperbillUid = VSA.SuperbillUid
JOIN
	ARBatch ARB
ON
	L.ArBatchUid =ARB.ARBatchUid 
WHERE
	(VSA.LiabilityBalance  - VSA.AssignedLiabilityBalance  ) >0
	
GROUP BY 
	SP.SuperbillUid 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_PatientLabResultsWithProvider]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[MDOL_RPT2_VIEW_PatientLabResultsWithProvider]
AS

SELECT ('';'' + loi.NAME + '': '' + coalesce(nullif(Convert(VARCHAR(50), ISNULL(ov.ObservationValue,'''')), ''''), ''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50), coalesce(oo.ResultDate, oo.Performdate, Extractdate, Orderdate), 101))) AS LabResult
	,loi.ObservationItemUid
	,coalesce(convert(varchar(max),convert(decimal(10,1),ov.MetricValue1)), LEFT(SUBSTRING(ov.ObservationValue, PATINDEX(''%[0-9.-]%'', ov.ObservationValue), 800), PATINDEX(''%[^0-9.-]%'', SUBSTRING(ObservationValue, PATINDEX(''%[0-9.-]%'', ov.ObservationValue), 800) + ''X'') - 1)) AS NumericObservationValue
	,coalesce(v.visitDate, oo.ResultDate, oo.Performdate, Extractdate, Orderdate) AS ResultDate
	,oo.LaboratoryUid
	,oo.PatientUid
	,oo.IsDelete
	,oo.OrderProviderUid
	,OrderProvider.FormattedPreferredName as OrderProvider
	,oo.ApproveProviderUid
	,ApproveProvider.FormattedPreferredName as ApproveProvider
	,oo.PerformProviderUid
	,PerformProvider.FormattedPreferredName as PerformProvider
	FROM ObservationOrder oo WITH (NOLOCK)
INNER JOIN ObservationValue ov WITH (NOLOCK)
	ON ov.ObservationOrderUid = oo.ObservationOrderUid
INNER JOIN ListObservationItem loi WITH (NOLOCK)
	ON loi.ObservationItemUid = ov.ObservationItemUid
INNER JOIN Person PR WITH (NOLOCK)
	ON PR.PersonUid = oo.PatientUid
LEFT JOIN Visit V WITH (NOLOCK)
ON v.VisitUid=oo.VisitUid
LEFT JOIN ViewPerson OrderProvider WITH (NOEXPAND, NOLOCK) ON oo.OrderProviderUid = OrderProvider.PersonUid
LEFT JOIN ViewPerson ApproveProvider WITH (NOEXPAND, NOLOCK) ON oo.ApproveProviderUid = ApproveProvider.PersonUid
LEFT JOIN ViewPerson PerformProvider WITH (NOEXPAND, NOLOCK) ON oo.PerformProviderUid = PerformProvider.PersonUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_StatementLineItem_MainAccount_CHC_Statements]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[MDOL_RPT2_VIEW_StatementLineItem_MainAccount_CHC_Statements]  
AS  
/* Source fOR the line items in the paper and electronic statement.  
 AS of GA5, the paper statement does not use the Header, Comment, AND Subtotal types.  
 gaps have been LEFT in the display ORder fOR adding comment lines at any point.   
 Comments to be mixed in with a certain type should have the same display ORder,  
 e.g., claim filing comments are mixed with payments.  
  
 The primary keys of the biz object view fOR this are ItemUid, SuperbillUid,    
 DisplayOrder, AND CreditSubOrder so make sure this set of four is unique if you   
 update this view.  
  
 Use CreditSubOrder to order items associated with an individual payment OR adjustment  
 credit. Make it less than 2 to precede the payment OR adjustment OR greater than 2  
 to follow it. E.g., a credit statement note follows the credit.  
  
 The intended ORdering for these line items is:  
 ORDER BY RPUid, SuperbillDate asc, SuperbillUid, DisplayOrder asc, ItemDate asc,   
  CreditGroupUid, IsPayment desc, CreditUid, CreditSubOrder asc   
*/  
/*  
 01/24/2008 - Qatalys - Modified to remove GLDate (#13093)  
 05/19/2008 - Qatalys - Modified to include Financial Center  
 08/02/2011 - kbernecker - branched off of ViewStatementLineItem for performance reasons 
 11/15/2011 - kbernecker - remove payment notes (entire "Transfer" section), fixed reference numbers
 7/05/2012 - kbernecker - add payer information
 6/04/2013 - kbernecker - modified to use lastfileddate cte and get insurance plan correctly
 08/12/2013 - kbernecker - fix problem with initial transfers being lost and also get correct insurance payer
 01/28/2014 - kbernecker - fix issue with truly distinct payments and transfers that are being lost because they have the same posting date and reference number. add superbillprocedureuid to criteria.
 01/29/2014 - kbernecker - roll up payments and adjustments to sum them, but not lose the ones that appear to be identical
 09/16/2014 - kbernecker - add more NOLOCKs
 10/08/2014 - kbernecker - use LD.CreatedDateTime instead of ARB.GLDate for payments. Bug 32278.
 10/24/2014 - kbernecker - return ARB.GLDate instead of LD.CreatedDate time for payments. Bug 3323
 20150109 - kculberth - add statement notes from reason codes - bug 33625
 20150421 - kculberth - bug 37045 checking for ClaimDate > ARBatch.GLDate was causing a problem when reference numbers are reused and primary/secondary insurance payers are the same
 20150513 - kculberth - bug 28165 exclude CHC encounter codes found in ChcRelApprovalSetting table
 20160512 - kculberth - fix Bug 44841:Statement reflects incorrect insurance payer filed. retrieve InsurancePlanUid from SuperbillAggregate for Charges
 20160721 - kculberth - back out previous change, order IP.Name by cbd.lastmodifieddate desc instead.
						Fix bugs 44841, 50103, 51092, and 50964.
 20160831 - kculberth - modify regular version MDOL_RPT2_VIEW_StatementLineItem_CHC_Statements for main account
*/   
--NEW
WITH cteWhoPaidName --Stolen from ViewDeposit
AS
-- Define the CTE query.
(
SELECT d.deposituid,
      ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumber, -- mark as <ND> so can hyperlink on null values
      (CASE WHEN p.PersonUid IS NOT NULL THEN p1.FormattedPreferredName
       WHEN icArp.CorporationUid IS NOT NULL THEN icArp.Name
       WHEN LD.InsurancePayerUid IS NOT NULL THEN ic.Name END) AS WhoPaidName,
       L.EntryType  
FROM Deposit (NOLOCK) d
            INNER JOIN AR_LedgerDetail (NOLOCK) LD ON d.DepositUid = LD.DepositUid
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid
            LEFT OUTER JOIN AR_Ledger (NOLOCK) arlVoid on L.LedgerUid = arlVoid.VoidLedgerUid      -- Checks for voiding entries                                       
            LEFT JOIN AccountResponsibleParty (NOLOCK) arp on LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid            
            LEFT JOIN Person (NOLOCK) p ON arp.PersonUid = p.PersonUid 
            LEFT JOIN Corporation (NOLOCK) icArp ON arp.CorporationUid = icArp.CorporationUid
            LEFT JOIN Corporation (NOLOCK) ic ON ic.CorporationUid = LD.InsurancePayerUid 
            LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = p.PersonUid              
WHERE (L.EntryType = 0 -- Payment
	   OR L.EntryType = 3) -- Adjustment
       AND  (L.VoidLedgerUid IS NULL AND arlVoid.LedgerUid IS NULL) -- Don''t include reversing(void) entries
       AND LD.IsCredit = 1                                              
       AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits    
),
cteLastFiledDate --
AS
-- Define the CTE query.
(
	SELECT SA.SuperbillUid,SA.LastFiledDate,SA.CurrentInsurancePlanUid
	FROM SuperbillAggregate (NOLOCK) SA
)

SELECT   
 FinancialCenterUid,  
 ItemUid,   
 RPUid,   
 ''Charge'' AS Type,   
 4 AS DisplayOrder,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 NULL AS CreditGroupUid,   
 0 AS IsPayment,   
 NULL AS CreditUid,   
 0 AS CreditSubOrder,   
 '''' AS WhoPaid,   
 Description,   
 Charge,   
 SUM(Insurance) AS Insurance,  
 SUM(Patient) AS Patient,  
 SUM(Amount) AS Amount,  
 --MIN(AGE)  AS Age,  
 age,
 SuperbillProcedureUid,  
 MAX(TotalCharge) TotalCharge,  
 MAX(LastFiledDate) LastFiledDate,  
 '''' AS ReferenceNumber,  
 ReferringProviderName,  
 InsuranacePlan,  
 MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
 1 AS CompleteBatch,
 0 AS DisplayOrder2    
 FROM  
 (  
SELECT   
 LD.FinancialCenterUid,  
 SP.SuperbillProcedureUid AS ItemUid,   
 A.AccountResponsiblePartyUid AS RPUid, 
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName,   
 A.ExternalID AS AccountID,   
 S.ExternalID AS SuperbillID,   
 S.SuperbillUid,   
 S.ServiceDateStart AS SuperbillDate,   
 SP.ProcedureServiceDateStart AS ItemDate,     
 (CASE WHEN (PS.IncludeProcedureCode=1) 
 THEN ISNULL(LP.Code, '''') +ISNULL('' '' + LP.ShortDescription, '''')  
 ELSE ISNULL('' '' + LP.ShortDescription, '''') END) AS Description,   
 COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS Charge,   
 (CASE WHEN LD.LiabilityOwner > 0   THEN LD.Amount ELSE CONVERT(Money, 0) END) AS Insurance,  
 (CASE WHEN LD.LiabilityOwner = 0 THEN LD.Amount ELSE CONVERT(Money, 0) END) AS Patient,  
 ISNULL(LD.Amount,0) AS Amount,  
 --DATEDIFF(DD, (ARB.GLDate), GETUTCDATE())  AS Age, 
 NULL as age, 
 SP.SuperbillProcedureUid,   
 COALESCE(SP.TotalCharge, CONVERT(money,SP.ProcedureCharge * SP.Units), 0) AS TotalCharge,   
 lfd.LastFiledDate as LastFiledDate,    
 p3.FormattedPreferredName AS ReferringProviderName,
 (SELECT top 1 IP.Name from ClaimBatchDetail (NOLOCK) CBD   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL
		LEFT JOIN InsurancePlan (NOLOCK) IP ON CBD.InsurancePlanUid = IP.InsurancePlanUid   
		where CBD.SuperbillUid = S.SuperbillUid order by cbd.lastmodifieddate desc) as InsuranacePlan,
-- IP.Name as InsuranacePlan,	
 (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) IsSuperbilCompleteBatch,   
 (CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END) CompleteBatch   
FROM
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid AND (L.EntryType=1 OR L.EntryType=4)		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1 
		INNER JOIN ListProcedure (NOLOCK) LP ON SP.ProcedureUid = LP.ProcedureUid  		
		LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation (NOLOCK) C ON IP.InsuranceCarrierUid = C.CorporationUid   			 
		--LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		--LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
		--			 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = s.ReferringProviderUid   
		left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS  	  	
 WHERE rpsss.superbillstatusuid is null and
	(L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
	and ras.ProcedureUid is null
) A   
GROUP BY   
 FinancialCenterUid,  
 ItemUid,   
 RPUid,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 Description,   
 Charge,   
 SuperbillProcedureUid,  
 ReferringProviderName,  
 InsuranacePlan,
 age     
UNION ALL   
select 
	FinancialCenterUid,  
	ItemUid,  
	RPUid,   
	Type,   
	DisplayOrder,   
	PatientName,   
	RenderingProviderName,   
	AccountID,   
	SuperbillID,   
	SuperbillUid,   
	SuperbillDate,   
	MIN(ItemDate) AS ItemDate,   
	CreditGroupUid,  
	IsPayment,   
	CreditUid,   
	2 AS CreditSubOrder,   
	WhoPaid,   
	Description,  
	Charge,   
	SUM(Insurance) AS Insurance,   
	SUM(Patient) AS Patient,  
	SUM(Amount) AS Amount,  
	0 AS Age,  
	NULL AS SuperbillProcedureUid,  
	MAX(TotalCharge) AS TotalCharge,  
	MAX(LastFiledDate) AS LastFiledDate,  
	ReferenceNumber,  
	 ReferringProviderName,  
	'''' as InsuranacePlan,  
	MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
	--CASE WHEN AR.IsClosed =1 OR AR.IsLocked =1 THEN 1 ELSE 0 END   
	1 CompleteBatch, 
	DisplayOrder2 
FROM
(
	SELECT DISTINCT  
		FinancialCenterUid,  
		ItemUid,  
		RPUid,   
		Type,   
		CASE WHEN Type=''Payment'' THEN 5 ELSE 6 END AS DisplayOrder,   
		PatientName,   
		RenderingProviderName,   
		AccountID,   
		SuperbillID,   
		SuperbillUid,   
		SuperbillDate,   
		MIN(ItemDate) AS ItemDate,   
		CreditGroupUid,  
		IsPayment,   
		CreditUid,   
		2 AS CreditSubOrder,   
		WhoPaid,   
		Description,  
		CONVERT(Money, 0) AS Charge,   
		SUM(Insurance) AS Insurance,   
		SUM(Patient) AS Patient,  
		SUM(Amount) AS Amount,  
		0 AS Age,  
		SuperbillProcedureUid,  
		MAX(TotalCharge) AS TotalCharge,  
		MAX(LastFiledDate) AS LastFiledDate,  
		ReferenceNumber,  
		 ReferringProviderName,  
		'''' as InsuranacePlan,  
		MIN(IsSuperBilCompleteBatch) IsSuperBilCompleteBatch,  
		--CASE WHEN AR.IsClosed =1 OR AR.IsLocked =1 THEN 1 ELSE 0 END   
		1 CompleteBatch, 
		DisplayOrder2 
	FROM  
	(  
	 SELECT DISTINCT  
		 LD.FinancialCenterUid,  
		 (CASE WHEN LCT.Name = ''Patient Payment'' THEN D.DepositUid ELSE LD.FinancialCenterUid END) AS ItemUid, 
		 A.AccountResponsiblePartyUid AS RPUid,   
		 (CASE WHEN L.EntryType  = 2 THEN ''Payment'' ELSE ''Adjustment'' END) AS Type,    
		 p1.FormattedPreferredName AS PatientName,   
		 p2.FormattedPreferredName AS RenderingProviderName,  
		 A.ExternalID AS AccountID,   
		 S.ExternalID AS SuperbillID,   
		 S.SuperbillUid,   
		 S.ServiceDateStart AS SuperbillDate,   
		 (ARB.GLDate) AS ItemDate,   
		 LD.FinancialCenterUid  CreditGroupUid,  
		 (CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
		 LD.FinancialCenterUid CreditUid,      
		 WhoPaid.WhoPaidName AS WhoPaid, 
					(CASE WHEN L.EntryType != 2
						  THEN ISNULL(LCT.Name,'''')
						  ELSE
							 (CASE WHEN PS.IncludePaymentReferenceNumber = 1 
							  THEN 
								 ISNULL(LCT.Name,'''') + '' Ref #'' + ISNULL(WhoPaid.ReferenceNumber,''N/A'') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
							  ELSE ISNULL(LCT.Name,'''') + '' '' + ISNULL(WhoPaid.WhoPaidName,'''') 
							  END)
					  END) as Description,
		 (CASE WHEN LD.LiabilityOwner > 0 THEN (LD.Amount) ELSE CONVERT(Money, 0) END) AS Insurance,   
		 (CASE WHEN LD.LiabilityOwner = 0 THEN (LD.Amount) ELSE CONVERT(Money, 0) END) AS Patient,  
		 (ISNULL(LD.Amount, 0)) AS Amount,    
		 LD.LastModifiedDate,
		 LD.SuperbillProcedureUid,  
		 (SP.TotalCharge) AS TotalCharge,  
		 lfd.LastFiledDate AS LastFiledDate,  
		 D.ReferenceNumber,  
		  p3.FormattedPreferredName AS ReferringProviderName,
		 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) AS InsuranacePlan,  
		 ((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) AS IsSuperBilCompleteBatch,  
		 CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END CompleteBatch,
		 CASE    
			  WHEN LCT.IsPayment = 1 THEN 1    
			  WHEN LCT.IsAdjustment = 1 THEN 2    
		  ELSE 3     
		  END AS DisplayOrder2
	 FROM  
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid        
		LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
		INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
		INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1 
		INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid                        
		LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  	
		LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid 
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN AR_Transaction (NOLOCK) T ON L.TransactionUid = T.TransactionUid 
		LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = T.DepositUid            
		LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = s.PatientUid  
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = S.ReferringProviderUid   
		LEFT JOIN cteWhoPaidName AS whoPaid ON d.depositUid = WhoPaid.deposituid --and d.referencenumber = WhoPaid.referencenumber
		left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS  	  	
		WHERE rpsss.superbillstatusuid is null and
			(L.EntryType=2 OR L.EntryType=3) and (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 1 
		and ras.ProcedureUid is null
	) B     
	GROUP BY  
	 FinancialCenterUid,  
	 ItemUid,  
	 RPUid,   
	 Type,   
	 PatientName,   
	 RenderingProviderName,   
	 AccountID,   
	 SuperbillID,   
	 SuperbillUid,   
	 SuperbillDate,  
	 CreditGroupUid,   
	 IsPayment,   
	 CreditUid,   
	 WhoPaid,   
	 Description,  
	 --SuperbillProcedureUid,  
	 ReferenceNumber, 
	 SuperbillProcedureUid, 
	 ReferringProviderName,  
	 InsuranacePlan,
	 DisplayOrder2
	) A
GROUP BY  
 FinancialCenterUid,  
 ItemUid,  
 RPUid,   
 Type,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate, 
 DisplayOrder, 
 CreditGroupUid,   
 IsPayment, 
 CreditUid,   
 WhoPaid,   
 Description,  
 --SuperbillProcedureUid,  
 ReferenceNumber, 
 Charge,
 ReferringProviderName,  
 InsuranacePlan,
 DisplayOrder2
   
UNION ALL  
  
--Claim filing comment can be mixed among the payments, so use the same display ORder  
SELECT   
LD.FinancialCenterUid,  
CB.ClaimBatchUid AS ItemUid,   
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
6 AS DisplayOrder,   
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName, 
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
MAX(CB.ClaimDate) AS ItemDate,   
NULL AS CreditGroupUid,   
0 AS IsPayment,   
NULL AS CreditUid,   
0 AS CreditSubOrder,   
'''' AS WhoPaid,   
(dbo.ARFN_getInsLevelName(CB.InsuranceOrder) + '' claim filed to '' +ISNULL(C.Name,'''')) AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
NULL SuperbillProcedureUid, --CR,  
MAX(SP.TotalCharge) TotalCharge,  
 lfd.LastFiledDate as LastFiledDate,    
'''' AS ReferenceNumber,  
 p3.FormattedPreferredName AS ReferringProviderName,
 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan,
CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END IsSuperBilCompleteBatch,  
CASE WHEN (ARB.IsClosed =1 OR ARB.IsLocked =1) THEN 1 ELSE 0 END CompleteBatch,
 0 AS DisplayOrder2 
FROM  
		AR_LedgerDetail (NOLOCK) LD
		INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
        LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
        INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
        INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
		INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
		INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1 
		LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  
		LEFT JOIN Corporation (NOLOCK) C ON IP.InsuranceCarrierUid = C.CorporationUid   
		LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
		LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
					 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid  
		LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 
		LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid   
		LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid   
		LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = s.ReferringProviderUid   
		left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
		LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
		ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
		CROSS JOIN PracticeSettings (NOLOCK) PS 
 WHERE rpsss.superbillstatusuid is null and
	(L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) AND LD.IsCredit = 0  AND (L.EntryType = 1) 
	and ras.ProcedureUid is null
GROUP BY   
 LD.FinancialCenterUid,  
 CB.ClaimBatchUid,   
 A.AccountResponsiblePartyUid,   
 S.PatientUid,   
 LD.RenderingProviderUid,  
 A.ExternalID,  
 S.ExternalID,   
 S.SuperbillUid,   
 S.ServiceDateStart,
 CB.ClaimDate,   
 CB.InsuranceOrder,   
 C.Name,
 lfd.LastFiledDate,    
 ARB.IsClosed,      
 ARB.IsLocked,
 S.ReferringProviderUid,  
  p1.FormattedPreferredName,
  p2.FormattedPreferredName,
  p3.FormattedPreferredName
UNION ALL   
  
--Statement notes FROM credits. Associated with the payments AND adjustments, so use the same display ORder  
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
SELECT   
LD.FinancialCenterUid,  
LD.LedgerDetailUid AS ItemUid,   
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
CASE WHEN L.EntryType=1 THEN 4
WHEN L.EntryType=2 THEN 5 
WHEN L.EntryType=3 THEN 6
WHEN L.EntryType =4 THEN 7
ELSE 6 END AS DisplayOrder,   
 p1.FormattedPreferredName AS PatientName,   
 p2.FormattedPreferredName AS RenderingProviderName,   
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
COALESCE(ARB.GLDate,D.DepositDate,S.ServiceDateStart,NULL) AS ItemDate,      
LD.LedgerDetailUid AS CreditGroupUid,  
(CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
LD.LedgerDetailUid AS CreditUid,  
4 AS CreditSubOrder,   
'''' AS WhoPaid,   
L.StatementNote AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
LD.SuperbillProcedureUid,  
SP.TotalCharge,  
 lfd.LastFiledDate AS LastFiledDate,  
'''' AS ReferenceNumber,  
 p3.FormattedPreferredName AS ReferringProviderName,
 (dbo.ARFN_getInsLevelName(CB.InsuranceOrder)) as InsuranacePlan,
((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) IsSuperBilCompleteBatch,  
((CASE WHEN (ARB.IsClosed = 1 OR ARB.IsLocked = 1) THEN 1 ELSE 0 END)) CompleteBatch,
 CASE    
      WHEN LCT.IsPayment = 1 THEN 1    
      WHEN LCT.IsAdjustment = 1 THEN 2    
  ELSE 3     
  END AS DisplayOrder2
FROM 
	AR_LedgerDetail (NOLOCK) LD
	INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid		
    LEFT JOIN AR_Ledger (NOLOCK) LVOID ON L.LedgerUid = LVOID.VoidLedgerUid  
    INNER JOIN ARBatch (NOLOCK) ARB ON L.ArBatchUid=ARB.ARBatchUid   
    INNER JOIN SuperbillProcedure (NOLOCK) SP on LD.SuperbillProcedureUid = SP.SuperbillProcedureUid
	INNER JOIN Superbill (NOLOCK) S ON S.SuperbillUid=SP.SuperbillUid  
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1
	INNER JOIN AR_LedgerDetail (NOLOCK) LDOS ON LD.LedgerUid = LDOS.LedgerUid AND LD.LedgerDetailUid != LDOS.LedgerDetailUid     		
	LEFT JOIN InsurancePlan (NOLOCK) IP ON LD.InsurancePlanUid = IP.InsurancePlanUid  	
	LEFT JOIN ClaimBatchDetail (NOLOCK) CBD ON CBD.SuperbillUid = S.SuperbillUid   
	LEFT JOIN ClaimBatch (NOLOCK) CB ON CB.ClaimBatchUid = CBD.ClaimBatchUid AND CB.ClaimDate IS NOT NULL    
				 AND CB.ClaimDate > ARB.GLDate AND CBD.InsurancePlanUid =  IP.InsurancePlanUid 
	LEFT JOIN cteLastFiledDate lfd on lfd.SuperbillUid = S.SuperbillUid					 	
	LEFT JOIN Deposit (NOLOCK) d ON D.DepositUid = LDOS.DepositUid
	LEFT JOIN ListCreditType (NOLOCK) LCT ON LD.IncomeAccountUid = LCT.CreditTypeUid 
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	LEFT JOIN ViewPerson (NOEXPAND) p2 on p2.personuid = LD.RenderingProviderUid 
	LEFT JOIN ViewPerson (NOEXPAND) p3 on p3.personuid = s.ReferringProviderUid 
	left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	CROSS JOIN PracticeSettings (NOLOCK) PS 
WHERE rpsss.superbillstatusuid is null and
 (L.StatementNote is NOT NULL OR L.StatementNote != '''')   
 AND (L.VoidLedgeruid is null and  LVOID.LedgerUid Is Null) 
 AND (L.EntryType=2 OR L.EntryType=3 OR L.EntryType=4) AND LD.IsCredit = 1  
 and ras.ProcedureUid is null
 UNION ALL			
--Remark notes from Reason Codes. Associated with procedures, so use the same display Order  
-- but vary SubDisplayOrder in ORder to make the comment show after the payment OR adjustment it goes with  
select FinancialCenterUid,
NULL as ItemUid,
 RPUid,   
Type,   
 DisplayOrder,   
 PatientName,   
 RenderingProviderName,   
 AccountID,   
 SuperbillID,   
 SuperbillUid,   
 SuperbillDate,   
 ItemDate,   
 CreditGroupUid,   
IsPayment,   
CreditUid,   
 CreditSubOrder,   
  WhoPaid,   
 Description,   
 Charge,   
 Insurance,  
 Patient,  
 Amount,  
 --MIN(AGE)  AS Age,  
 age,
 SuperbillProcedureUid,  
 TotalCharge,  
 LastFiledDate,  
 ReferenceNumber,  
 ReferringProviderName,  
 InsuranacePlan,  
 IsSuperBilCompleteBatch,  
 CompleteBatch,
 DisplayOrder2
 from (   
SELECT distinct  
LD.FinancialCenterUid,  
--LD.LedgerDetailUid AS ItemUid,   
NULL as ItemUid,
A.AccountResponsiblePartyUid AS RPUid,   
''Comment'' AS Type,   
6 AS DisplayOrder,   
p1.FormattedPreferredName AS PatientName,   
NULL AS RenderingProviderName,   
A.ExternalID AS AccountID,   
S.ExternalID AS SuperbillID,   
S.SuperbillUid,   
S.ServiceDateStart AS SuperbillDate,   
SP.ProcedureServiceDateStart AS ItemDate,      
--LD.LedgerDetailUid AS CreditGroupUid,  
--(CASE WHEN L.EntryType  = 2 THEN 1 ELSE 0 END) IsPayment,   
--LD.LedgerDetailUid AS CreditUid,  
NULL AS CreditGroupUid,  
NULL AS IsPayment,   
NULL AS CreditUid,  
4 AS CreditSubOrder,   
'''' AS WhoPaid,   
adj.StatementNote AS Description,   
CONVERT(Money, 0) AS Charge,   
CONVERT(Money, 0) AS Insurance,   
CONVERT(Money, 0) AS Patient,  
CONVERT(Money, 0) AS Amount,  
0 AS Age,  
--LD.SuperbillProcedureUid,  
--SP.TotalCharge AS TotalCharge,  
NULL AS SuperbillProcedureUid,  
CASE WHEN SP.TotalCharge > 0 THEN 99999 ELSE 0 END AS TotalCharge,  
 NULL AS LastFiledDate,  
'''' AS ReferenceNumber,  
NULL AS ReferringProviderName,
NULL AS  InsuranacePlan,
NULL AS IsSuperBilCompleteBatch,  
NULL AS CompleteBatch,
  3  AS DisplayOrder2
FROM Superbill (NOLOCK) S 
	INNER JOIN SuperbillProcedure SP WITH (NOLOCK) ON SP.superbilluid = S.superbilluid
	INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SP.SuperbillProcedureUid = LD.SuperbillProcedureUid
	INNER JOIN Account (NOLOCK) A ON S.AccountUid = A.AccountUid AND A.IsMain = 1   
	LEFT JOIN ViewPerson (NOEXPAND) p1 on p1.personuid = S.PatientUid  
	left outer join ChcRelApprovalSetting ras WITH (NOLOCK) on ras.ProcedureUid = sp.ProcedureUid and LD.ServiceSiteUid = ras.ServiceSiteUid	
	LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
	ON s.SuperbillStatusUid = rpsss.SuperbillStatusUid
	left join cobclaimdetail cob on cob.superbilluid = s.superbilluid
	left join COBLineAdjustments adj on adj.cobclaimdetailuid = cob.cobclaimdetailuid and adj.superbillprocedureuid = sp.superbillprocedureuid and adj.Notes IS NOT NULL
	CROSS JOIN PracticeSettings (NOLOCK) PS 
WHERE rpsss.superbillstatusuid is null and
 (adj.StatementNote is NOT NULL OR adj.StatementNote != '''')  
	and ras.ProcedureUid is null
 ) A




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementResponsiblePartyByFinancialCenterSum]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewStatementResponsiblePartyByFinancialCenterSum]
AS --nag2
/* This is the source for electronic statements and also for paper statements, indirectly via
the stored proc MDOL_RPT2_StatementHeader/ One record per responsible party with active accounts.

01/28/2008 - Qatalys - #12798 - Modified Balance with BalanceAll
05/19/2008 - Qatalys - #13325 - Added Financial Center
01/22/2009 - Qatalys   - Modified to replace PersonBalanceAll,AccountBalanceAll of Account
07/29/2009 -- Included Dunning Message
10/2/2012 - change inner join on person to left join
*/
SELECT
s.RPUid,
s.FinancialCenterUid,
s.CustomerName,
ISNULL(fc.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') as CustomerAddress1,
ISNULL(fc.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') as CustomerAddress2,
ISNULL(fc.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)''), '''') as CustomerCity,
ISNULL(fc.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''), '''') as CustomerState,
ISNULL(fc.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''), '''') as CustomerZip,
ISNULL(fc.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)''), '''') as CustomerPhone,
s.RemitToName,
ISNULL(fc.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') as RemitToAddress1,
ISNULL(fc.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''') as RemitToAddress2,
ISNULL(fc.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)''),'''') as RemitToCity,
ISNULL(fc.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)''),'''') as RemitToState,
ISNULL(fc.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),'''') as RemitToZip,
s.RPID,
s.RPName,
(CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''')
WHEN c.CorporationUid IS NOT NULL THEN ISNULL(c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''')
END) as RPAddress1,
(CASE WHEN p.PersonUid IS NOT NULL THEN ISNULL(p.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),'''')
WHEN c.CorporationUid IS NOT NULL THEN ISNULL(c.[Address].value(''(/Address/Address2)[1]'', ''V