SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AccessCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [AccessCode](
	[AccessCodeUid] [uniqueidentifier] NOT NULL,
	[Code] [varchar](25) NOT NULL,
	[CreatedDate] [datetime] NOT NULL CONSTRAINT [DF_AccessCode_CreatedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AccessionTracking]') AND type in (N'U'))
BEGIN
CREATE TABLE [AccessionTracking](
	[AccessionTrackingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[LaboratoryUid] [uniqueidentifier] NULL,
	[IMedicaAccessionNumber] [varchar](25) NOT NULL,
	[QueueState] [int] NOT NULL CONSTRAINT [DF_AccessionTracking_QueueState]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AccessionTracking_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Account]') AND type in (N'U'))
BEGIN
CREATE TABLE [Account](
	[AccountUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Account_AccountUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[ResponsiblePartyRelationshipUid] [uniqueidentifier] NULL,
	[FormularyList] [varchar](100) NULL,
	[PatienteRxEligibilityUid] [uniqueidentifier] NULL,
	[EligibilityProviderUid] [uniqueidentifier] NULL,
	[EligibilityLastCheckedDate] [date] NULL,
	[EligibilityLastResponse] [varchar](100) NULL,
	[IsMain] [bit] NOT NULL CONSTRAINT [DF_Account_IsMain]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Account_Inactive]  DEFAULT ((0)),
	[LastStatementDate] [date] NULL,
	[CycleTrigger] [bit] NOT NULL CONSTRAINT [DF_Account_CycleTrigger]  DEFAULT ((0)),
	[ExcludeFromAutomatedCollections] [bit] NOT NULL CONSTRAINT [DF_Account_ExcludeFromAutomatedCollections]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Account_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[CoverageTypeUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AccountInsurance]') AND type in (N'U'))
BEGIN
CREATE TABLE [AccountInsurance](
	[AccountInsuranceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_AccountInsurance_AccountInsuranceUid]  DEFAULT (newid()),
	[PersonInsurancePlanUid] [uniqueidentifier] NOT NULL,
	[AccountPeriodUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_AccountInsurance_DisplayOrder]  DEFAULT ((0)),
	[RelationshipUid] [uniqueidentifier] NOT NULL,
	[PolicyNumberSuffix] [varchar](50) NULL,
	[ParentAccountInsuranceUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AccountInsurance_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AccountPeriod]') AND type in (N'U'))
BEGIN
CREATE TABLE [AccountPeriod](
	[AccountPeriodUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_AccountPeriod_AccountPeriodUid]  DEFAULT (newid()),
	[AccountUid] [uniqueidentifier] NOT NULL,
	[AccountTypeUid] [uniqueidentifier] NULL,
	[FundTypeUid] [uniqueidentifier] NULL,
	[EligibilityFundUid] [uniqueidentifier] NULL,
	[RegionUid] [uniqueidentifier] NULL,
	[PayorPlanSetUid] [uniqueidentifier] NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AccountPeriod_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MedicareSecondaryReasonCodeUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AccountResponsibleParty]') AND type in (N'U'))
BEGIN
CREATE TABLE [AccountResponsibleParty](
	[AccountResponsiblePartyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_AccountResponsibleParty_AccountResponsiblePartyUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NULL,
	[CorporationUid] [uniqueidentifier] NULL,
	[SendStatement] [tinyint] NULL CONSTRAINT [DF_AccountResponsibleParty_SendStatement]  DEFAULT ((0)),
	[LastStatementDate] [date] NULL,
	[SendPaperlessStatements] [tinyint] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_SendPaperlessStatements]  DEFAULT ((0)),
	[CycleTrigger] [bit] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_CycleTrigger]  DEFAULT ((0)),
	[DunningOn] [bit] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_DunningOn]  DEFAULT ((0)),
	[DunningLevel] [smallint] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_DunningLevel]  DEFAULT ((0)),
	[CollectionStatusUid] [uniqueidentifier] NULL,
	[CollectionStatusLevelUid] [uniqueidentifier] NULL,
	[CollectionStatusExpirationDate] [date] NULL,
	[IsCollectionExpireDayOfMonth] [bit] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_IsCollectionExpireDayOfMonth]  DEFAULT ((0)),
	[OverrideSufficient] [bit] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_OverrideSufficient]  DEFAULT ((0)),
	[OverridePaymentAmount] [money] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_OverridePaymentAmount]  DEFAULT ((0)),
	[CalculatedPaymentAmount] [money] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_CalculatedPaymentAmount]  DEFAULT ((0)),
	[DateEnteredCollections] [date] NULL,
	[DateEnteredStatus] [date] NULL,
	[DateEnteredStatusLevel] [date] NULL,
	[ExcludeFromAutomatedCollections] [bit] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_ExcludeFromAutomatedCollections]  DEFAULT ((0)),
	[PaymentsLastProcessed] [date] NULL,
	[ScheduledPaymentAllowed] [bit] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_ScheduledPaymentAllowed]  DEFAULT ((0)),
	[ScheduledPayCardholderName] [varchar](255) NULL,
	[ScheduledPayCardTypeUid] [uniqueidentifier] NULL,
	[ScheduledPayCardExpirationMonth] [int] NULL,
	[ScheduledPayCardExpirationYear] [int] NULL,
	[ScheduledPayCardNumberMasked] [varchar](255) NULL,
	[ScheduledPayFieldOne] [varchar](255) NULL,
	[ScheduledPayFieldTwo] [varchar](255) NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AccountResponsibleParty_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AccountResponsiblePartyCreditCardAuthorizationCache]') AND type in (N'U'))
BEGIN
CREATE TABLE [AccountResponsiblePartyCreditCardAuthorizationCache](
	[AccountResponsiblePartyCreditCardAuthorizationCacheUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NULL,
	[LastRefreshDate] [date] NOT NULL,
	[TotalAuthorizationAmount] [money] NOT NULL,
	[ConsentDetails] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AccountResponsiblePartyCreditCardAuthorizationCache_ApplyToSuperbills]') AND type in (N'U'))
BEGIN
CREATE TABLE [AccountResponsiblePartyCreditCardAuthorizationCache_ApplyToSuperbills](
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AddressHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [AddressHistory](
	[AddressHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_AddressHistory_AddressHistoryUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](50) NULL,
	[StartDate] [xml](CONTENT [TimeFrame]) NULL,
	[StartDateTime] [datetime] NULL,
	[EndDate] [xml](CONTENT [TimeFrame]) NULL,
	[EndDateTime] [datetime] NULL,
	[AddressTypeUid] [uniqueidentifier] NULL,
	[Address1] [xml](CONTENT [Address]) NULL,
	[Address2] [xml](CONTENT [Address]) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_AddressHistory_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_AddressHistory_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_AddressHistory_UserDefined]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AddressHistory_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Appointment]') AND type in (N'U'))
BEGIN
CREATE TABLE [Appointment](
	[AppointmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Appointment_AppointmentUid]  DEFAULT (newid()),
	[AppointmentTypeUid] [uniqueidentifier] NULL,
	[AppointmentStatusUid] [uniqueidentifier] NULL,
	[CheckinDateTime] [datetime] NULL,
	[DischargeDateTime] [datetime] NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[CalendarUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ProviderCareTypeUid] [uniqueidentifier] NULL,
	[ReferredbyProviderUid] [uniqueidentifier] NULL,
	[ReferringDate] [date] NULL,
	[Phone] [xml](CONTENT [Phone]) NULL,
	[CallConfirmStatusUid] [uniqueidentifier] NULL,
	[CallConfirmStatusDetail] [varchar](max) NULL,
	[Reason] [varchar](max) NULL,
	[AuthorizationReminder] [bit] NOT NULL CONSTRAINT [DF_Appointment_AuthorizationReminder]  DEFAULT ((0)),
	[AuthorizationCode] [varchar](30) NULL,
	[StartDateTime] [datetime] NULL,
	[EndDateTime] [datetime] NULL,
	[ExternalID] [varchar](50) NULL,
	[Notes] [varchar](max) NULL,
	[CreatedByUid] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NULL CONSTRAINT [DF_Appointment_CreatedDate]  DEFAULT (getutcdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Appointment_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[TriggerOverride] [bit] NOT NULL CONSTRAINT [DF_Appointment_TriggerOverride]  DEFAULT ((0)),
	[ReferralSrcUid] [uniqueidentifier] NULL,
	[ScheduleType] [tinyint] NOT NULL CONSTRAINT [DF_Appointment_ScheduleType]  DEFAULT ((0)),
	[PatientGroupUid] [uniqueidentifier] NULL,
	[RecurringInstanceUid] [uniqueidentifier] NULL,
	[AppointmentReplicationDataXml] [xml] NULL,
	[BillingProviderUid] [uniqueidentifier] NULL,
	[ClipboardUserUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_Ledger]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_Ledger](
	[LedgerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[EntryDate] [date] NOT NULL,
	[ArBatchUid] [uniqueidentifier] NOT NULL,
	[ShortName] [varchar](50) NULL,
	[Comment] [varchar](max) NULL,
	[EntryType] [smallint] NOT NULL,
	[VoidLedgerUid] [uniqueidentifier] NULL,
	[Reconciled] [bit] NOT NULL CONSTRAINT [DF_AR_Ledger_Reconciled]  DEFAULT ((0)),
	[TransactionUid] [uniqueidentifier] NULL,
	[GroupERACodeUid] [uniqueidentifier] NULL,
	[ReasonERACodeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[StatementNote] [varchar](300) NULL,
	[Quantity] [decimal](18, 0) NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_AR_Ledger_CreatedDate]  DEFAULT (getutcdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AR_Ledger_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_LedgerDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_LedgerDetail](
	[LedgerDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[LedgerUid] [uniqueidentifier] NOT NULL,
	[Amount] [money] NOT NULL,
	[LiabilityOwner] [int] NULL,
	[LedgerAccountUid] [uniqueidentifier] NULL,
	[IncomeAccountUid] [uniqueidentifier] NULL,
	[InsurancePayerUid] [uniqueidentifier] NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NULL,
	[SuperbillProcedureUid] [uniqueidentifier] NULL,
	[SuperbillProcedureUnits] [decimal](20, 1) NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[PayerCreditUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[InsurancePlanUid] [uniqueidentifier] NULL,
	[RenderingProviderUid] [uniqueidentifier] NULL,
	[ClaimingProviderUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[MigrationUid] [uniqueidentifier] NULL,
	[IsCredit] [bit] NOT NULL CONSTRAINT [DF_AR_LedgerDetail_IsCredit]  DEFAULT ((0)),
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_AR_LedgerDetail_CreatedDate]  DEFAULT (getutcdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AR_LedgerDetail_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_PayerCredit]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_PayerCredit](
	[PayerCreditUid] [uniqueidentifier] NOT NULL,
	[DepositUid] [uniqueidentifier] NOT NULL,
	[Note] [varchar](max) NOT NULL,
	[MigrationUid] [uniqueidentifier] NULL,
	[PayerCreditRefundStatusUid] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_AR_PayerCredit_CreatedDate]  DEFAULT (getutcdate()),
	[RefundNote] [varchar](max) NULL,
	[RefundApprovedDate] [date] NULL,
	[RefundApprovedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AR_PayerCredit_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_RelLedgerDetailModifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_RelLedgerDetailModifier](
	[LedgerDetailUid] [uniqueidentifier] NOT NULL,
	[OriginalAmountAllowed] [money] NULL,
	[ActualAmountAllowed] [money] NULL,
	[WorkRVU] [decimal](5, 2) NULL,
	[RVU] [decimal](5, 2) NULL,
	[TotalTax] [money] NULL,
	[LastModifiedDate] [date] NOT NULL CONSTRAINT [DF_AR_RelLedgerDetailModifier_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_RelLedgerDetailProcedureModifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_RelLedgerDetailProcedureModifier](
	[RelLedgerDetailProcedureModifierUid] [uniqueidentifier] NOT NULL,
	[LedgerDetailUid] [uniqueidentifier] NOT NULL,
	[ProcedureModifierUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AR_RelLedgerDetailProcedureModifier_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_RelLedgerTag]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_RelLedgerTag](
	[RelLedgerTagUid] [uniqueidentifier] NOT NULL,
	[LedgerUid] [uniqueidentifier] NOT NULL,
	[Value] [varchar](255) NOT NULL,
	[Text] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_Transaction]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_Transaction](
	[TransactionUid] [uniqueidentifier] NOT NULL,
	[ReferenceNumber] [varchar](250) NOT NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[SuperbillUid] [uniqueidentifier] NULL,
	[MigrationUid] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_AR_Transaction_CreatedDate]  DEFAULT (getutcdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AR_Transaction_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_ViewFinancialCenterClosingSummary_BatchInfo]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_ViewFinancialCenterClosingSummary_BatchInfo](
	[FinancialCenterClosingSummaryUid] [uniqueidentifier] NOT NULL,
	[ARBatchUid] [uniqueidentifier] NOT NULL,
	[BatchName] [varchar](255) NOT NULL,
	[GLDate] [date] NOT NULL,
	[Complete] [bit] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_ViewFinancialCenterClosingSummary_DepositsWithBalance]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_ViewFinancialCenterClosingSummary_DepositsWithBalance](
	[FinancialCenterClosingSummaryUid] [uniqueidentifier] NOT NULL,
	[DepositUid] [uniqueidentifier] NOT NULL,
	[DepositReferenceNumber] [varchar](250) NOT NULL,
	[DepositReceiptBalance] [money] NOT NULL,
	[ArBatchName] [varchar](255) NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AR_ViewFinancialCenterClosingSummary_ObjectLinks]') AND type in (N'U'))
BEGIN
CREATE TABLE [AR_ViewFinancialCenterClosingSummary_ObjectLinks](
	[FinancialCenterClosingSummaryUid] [uniqueidentifier] NOT NULL,
	[ObjectUid] [uniqueidentifier] NOT NULL,
	[Type] [varchar](1) NOT NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[Blocking] [bit] NULL,
	[CreatedDateTime] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ARBatch]') AND type in (N'U'))
BEGIN
CREATE TABLE [ARBatch](
	[ARBatchUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ARBatch_ARBatchUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ARBatch_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[GLDate] [date] NOT NULL,
	[IsLocked] [bit] NOT NULL CONSTRAINT [DF_ARBatch_IsComplete]  DEFAULT ((0)),
	[IsClosed] [bit] NOT NULL CONSTRAINT [DF_ARBatch_IsClosed]  DEFAULT ((0)),
	[OwnerUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ARBatch_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ARContext]') AND type in (N'U'))
BEGIN
CREATE TABLE [ARContext](
	[ARContextUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ARContext_ARContextUid]  DEFAULT (newid()),
	[ShortDescription] [varchar](20) NULL,
	[LongDescription] [varchar](255) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ARContext_Inactive]  DEFAULT ((0)),
	[RenderingProviderUid] [uniqueidentifier] NULL,
	[ClaimingProviderUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NOT NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[SuperbillUid] [uniqueidentifier] NULL,
	[SuperbillProcedureUid] [uniqueidentifier] NULL,
	[NonReversedSuperbillProcedureUid] [uniqueidentifier] NULL,
	[SuperbillProcedureUnits] [decimal](20, 1) NOT NULL CONSTRAINT [DF_ARContext_SuperbillProcedureUnits]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ARContext_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Attachment]') AND type in (N'U'))
BEGIN
CREATE TABLE [Attachment](
	[AttachmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Attachment_AttachmentUid]  DEFAULT (newid()),
	[AttachmentGroupUid] [uniqueidentifier] NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[AttachmentContentType] [varchar](50) NULL,
	[AttachmentContentSize] [int] NULL,
	[CompressionUid] [uniqueidentifier] NULL,
	[UncompressedAttachmentContentSize] [int] NULL,
	[ThumbnailAttachmentContent] [varbinary](max) NULL,
	[ThumbnailAttachmentContentType] [varchar](50) NULL,
	[DisplayOrder] [int] NULL CONSTRAINT [DF_Attachment_DisplayOrder]  DEFAULT ((0)),
	[ViewMode] [smallint] NULL CONSTRAINT [DF_Attachment_ViewMode]  DEFAULT ((2)),
	[PrintingOptions] [int] NOT NULL CONSTRAINT [DF_Attachment_PrintingOptions]  DEFAULT ((7)),
	[GraphicNoteUid] [uniqueidentifier] NULL,
	[ConsentFormUid] [uniqueidentifier] NULL,
	[ConsentFormHash] [varbinary](16) NULL,
	[ConsentFormSignature] [varchar](max) NULL,
	[ConsentFormSignatureHash] [varbinary](16) NULL,
	[FilePath] [varchar](512) NULL,
	[FileName] [varchar](260) NULL,
	[FileExtension] [varchar](50) NULL,
	[FileDate] [datetime] NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Attachment_Inactive]  DEFAULT ((0)),
	[Received] [bit] NULL CONSTRAINT [DF_Attachment_Received]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Attachment_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Attachment_UserDefined]  DEFAULT ((1)),
	[StrikeOut] [bit] NOT NULL CONSTRAINT [DF_Attachment_StrikeOut]  DEFAULT ((0)),
	[StrikeOutNotes] [varchar](max) NULL,
	[IntermediateData] [xml] NULL,
	[FormattingTemplateUid] [uniqueidentifier] NULL,
	[CDASectionUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AttachmentApproval]') AND type in (N'U'))
BEGIN
CREATE TABLE [AttachmentApproval](
	[AttachmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ApprovedByUserPRMUid] [uniqueidentifier] NOT NULL,
	[ApprovedDate] [date] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AttachmentApproval_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AttachmentGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [AttachmentGroup](
	[AttachmentGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_AttachmentGroup_AttachmentGroupUid]  DEFAULT (newid()),
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_AttachmentGroup_Inactive]  DEFAULT ((0)),
	[Name] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_AttachmentGroup_UserDefined]  DEFAULT ((1)),
	[StrikeOut] [bit] NOT NULL CONSTRAINT [DF_AttachmentGroup_StrikeOut]  DEFAULT ((0)),
	[StrikeOutNotes] [varchar](max) NULL,
	[EffectiveDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AttachmentGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AuditArchive]') AND type in (N'U'))
BEGIN
CREATE TABLE [AuditArchive](
	[AuditUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Audit_AuditUid]  DEFAULT (newid()),
	[Type] [varchar](25) NOT NULL,
	[TableName] [varchar](50) NULL,
	[RowPrimaryUid] [uniqueidentifier] NULL,
	[Changes] [varchar](max) NULL,
	[Workstation] [varchar](50) NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[ChangeDate] [datetime] NOT NULL CONSTRAINT [DF_Audit_Date]  DEFAULT (getutcdate()),
	[PatientUid] [uniqueidentifier] NULL,
	[Description] [varchar](2000) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Audit_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AuditCurrent]') AND type in (N'U'))
BEGIN
CREATE TABLE [AuditCurrent](
	[AuditUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_AuditCurrent_AuditUid]  DEFAULT (newid()),
	[Type] [varchar](25) NOT NULL,
	[TableName] [varchar](50) NULL,
	[RowPrimaryUid] [uniqueidentifier] NULL,
	[Changes] [varchar](max) NULL,
	[Workstation] [varchar](50) NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[ChangeDate] [datetime] NOT NULL CONSTRAINT [DF_AuditCurrent_Date]  DEFAULT (getutcdate()),
	[PatientUid] [uniqueidentifier] NULL,
	[Description] [varchar](2000) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AuditCurrent_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AuditEventMessageRoutingGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [AuditEventMessageRoutingGroup](
	[AuditEventMessageRoutingGroupUid] [uniqueidentifier] NOT NULL,
	[AuditEventConfigurationUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AuditFinancialsArchive]') AND type in (N'U'))
BEGIN
CREATE TABLE [AuditFinancialsArchive](
	[AuditFinancialsUid] [uniqueidentifier] NOT NULL,
	[ObjectUid] [uniqueidentifier] NOT NULL,
	[ObjectType] [varchar](2) NOT NULL,
	[ErrorTag] [bit] NOT NULL,
	[WorkflowLogXml] [xml] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AuditWorkflowLogArchive]') AND type in (N'U'))
BEGIN
CREATE TABLE [AuditWorkflowLogArchive](
	[AuditWorkflowLogUid] [uniqueidentifier] NOT NULL,
	[AuditUid] [uniqueidentifier] NULL,
	[WorkflowLogXml] [xml] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AuditWorkflowLogArchive_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AuditWorkflowLogCurrent]') AND type in (N'U'))
BEGIN
CREATE TABLE [AuditWorkflowLogCurrent](
	[AuditWorkflowLogUid] [uniqueidentifier] NOT NULL,
	[AuditUid] [uniqueidentifier] NULL,
	[WorkflowLogXml] [xml] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[BatchProcess]') AND type in (N'U'))
BEGIN
CREATE TABLE [BatchProcess](
	[BatchProcessUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_BatchProcess_BatchProcessUid]  DEFAULT (newid()),
	[BatchProcessTypeUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[Status] [smallint] NOT NULL CONSTRAINT [DF_BatchProcess_Status]  DEFAULT ((0)),
	[Parameters] [xml] NULL,
	[IntermediateXml] [xml] NULL,
	[SummaryXml] [xml] NULL,
	[ExportXml] [xml] NULL,
	[Error] [varchar](max) NULL,
	[Archive] [bit] NOT NULL CONSTRAINT [DF_BatchProcess_Archive]  DEFAULT ((0)),
	[AutoStartDetail] [bit] NOT NULL CONSTRAINT [DF_BatchProcess_AutoStart_1]  DEFAULT ((0)),
	[RunApplicationServer] [varchar](255) NULL,
	[RunMode] [smallint] NOT NULL CONSTRAINT [DF_BatchProcess_RunMode]  DEFAULT ((0)),
	[RunStartDateTime] [datetime] NULL,
	[RunStatus] [varchar](200) NULL,
	[RunCurrentItem] [int] NULL,
	[RunTotalItems] [int] NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_BatchProcess_CreatedDateTime]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_BatchProcess_LastModifiedDate]  DEFAULT (getutcdate()),
	[DisableParametersReset] [bit] NOT NULL CONSTRAINT [DF_BatchProcess_DisableParametersReset]  DEFAULT ((0)),
	[NameFormatUid] [uniqueidentifier] NULL,
	[Stage] [varchar](100) NULL,
	[StageHistory] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[BatchProcessDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [BatchProcessDetail](
	[BatchProcessDetailUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_BatchProcessDetail_BatchProcessDetailUid]  DEFAULT (newid()),
	[Selected] [bit] NOT NULL CONSTRAINT [DF_BatchProcessDetail_Selected]  DEFAULT ((1)),
	[BatchProcessUid] [uniqueidentifier] NOT NULL,
	[IntermediateXml] [xml] NULL,
	[DetailXml] [xml] NULL,
	[ExportXml] [xml] NULL,
	[Error] [varchar](max) NULL,
	[Uid] [uniqueidentifier] NOT NULL,
	[Uid2] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_BatchProcessDetail_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CaseAuthorization]') AND type in (N'U'))
BEGIN
CREATE TABLE [CaseAuthorization](
	[CaseAuthorizationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CaseAuthorization_CaseAuthorizationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](116) NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[AuthorizationCode] [varchar](30) NULL,
	[AuthorizationExpirationDate] [date] NULL,
	[InitialVisitNum] [smallint] NOT NULL CONSTRAINT [DF_CaseAuthorization_InitialVisitNum]  DEFAULT ((1)),
	[RemainingVisitNum] [smallint] NOT NULL CONSTRAINT [DF_CaseAuthorization_RemainingVisitNum]  DEFAULT ((1)),
	[AccountPeriodUid] [uniqueidentifier] NULL,
	[PrimaryInsuranceRBType] [int] NOT NULL CONSTRAINT [DF_CaseAuthorization_PrimaryInsuranceRBType]  DEFAULT ((3)),
	[PrimaryAuthorizationCode] [varchar](30) NULL,
	[SecondaryInsuranceRBType] [int] NOT NULL CONSTRAINT [DF_CaseAuthorization_SecondaryInsuranceRBType]  DEFAULT ((3)),
	[SecondaryAuthorizationCode] [varchar](30) NULL,
	[TertiaryInsuranceRBType] [int] NOT NULL CONSTRAINT [DF_CaseAuthorization_TertiaryInsuranceRBType]  DEFAULT ((3)),
	[TertiaryAuthorizationCode] [varchar](30) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_CaseAuthorization_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[ActiveAuthorizationCode] [bit] NOT NULL CONSTRAINT [DF_CaseAuthorization_CompletionStatus]  DEFAULT ((0)),
	[OriginCreateDate] [date] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CaseAuthorization_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CaseAuthorization_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CaseAuthorizationCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [CaseAuthorizationCode](
	[CaseAuthorizationCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[TerminationDate] [date] NULL,
	[NumVisits] [int] NULL,
	[Type] [int] NOT NULL,
	[Code] [varchar](30) NULL,
	[Type2] [int] NOT NULL,
	[Code2] [varchar](30) NULL,
	[Type3] [int] NOT NULL,
	[Code3] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CCSystem]') AND type in (N'U'))
BEGIN
CREATE TABLE [CCSystem](
	[CCSystemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CCSystem_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CCSystem_UserDefined]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[ClinicCenterOverride] [xml](CONTENT [KdbOverrideCC]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverrideCC]) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CCSystem_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CDSCatalog]') AND type in (N'U'))
BEGIN
CREATE TABLE [CDSCatalog](
	[CDSCatalogUid] [uniqueidentifier] NOT NULL,
	[CatalogName] [varchar](100) NOT NULL,
	[CatalogCode] [varchar](50) NOT NULL,
	[CatalogDescription] [varchar](255) NULL,
	[PublishDate] [datetime] NULL,
	[ApplyAllCareTeams] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChargeCapture]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChargeCapture](
	[ChargeCaptureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ExternalId] [varchar](25) NULL,
	[Notes] [varchar](max) NULL,
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[IsInvalid] [bit] NULL,
	[IsOpen] [bit] NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChargeCaptureDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChargeCaptureDiagnosis](
	[ChargeCaptureDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ChargeCaptureUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[DateApplied] [datetime] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChargeCapturePatientDiagnosisHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChargeCapturePatientDiagnosisHistory](
	[ChargeCapturePatientDiagnosisHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[DateSaved] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChargeCaptureProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChargeCaptureProcedure](
	[ChargeCaptureProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ChargeCaptureUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[DiagnosesList] [varchar](1500) NULL,
	[DateApplied] [datetime] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChargePostBatch]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChargePostBatch](
	[ChargePostBatchUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ChargePostBatch_ChargePostBatchUid]  DEFAULT (newid()),
	[PostingUserUid] [uniqueidentifier] NULL,
	[BatchCreateDateTime] [datetime] NULL CONSTRAINT [DF_ChargePostBatch_BatchCreateDate]  DEFAULT (getutcdate()),
	[PostingCompleteDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChargePostBatch_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChargePostQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChargePostQueue](
	[ChargePostQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ChargePostQueue_ChargePostQueueUid]  DEFAULT (newid()),
	[ChargePostBatchUid] [uniqueidentifier] NOT NULL,
	[SuperbillUid] [uniqueidentifier] NULL,
	[ChargeUid] [uniqueidentifier] NULL,
	[IsPosted] [bit] NOT NULL CONSTRAINT [DF_ChargePostQueue_Posted]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChargePostQueue_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChartAccess]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChartAccess](
	[ChartAccessUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChartAccessDeny]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChartAccessDeny](
	[ChartAccessDenyUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChartAccessMessageRouting]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChartAccessMessageRouting](
	[ChartAccessMessageRoutingUid] [uniqueidentifier] NOT NULL,
	[PracticeSettingsUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChartDeniedMessageRouting]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChartDeniedMessageRouting](
	[ChartDeniedMessageRoutingUid] [uniqueidentifier] NOT NULL,
	[PracticeSettingsUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcAccountResponsibleParty]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcAccountResponsibleParty](
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[FamilySize] [tinyint] NOT NULL,
	[MonthlyIncome] [money] NOT NULL,
	[NoIncome] [bit] NOT NULL,
	[SFCorporationUid] [uniqueidentifier] NULL,
	[SFScheduleDetailUid] [uniqueidentifier] NULL,
	[SFFormOfDeclarationUid] [uniqueidentifier] NULL,
	[SFEffectiveDate] [date] NULL,
	[NotFedSFQual] [bit] NOT NULL,
	[RefusedFSMI] [bit] NOT NULL,
	[UseSFClass] [bit] NOT NULL,
	[SFNote] [text] NULL,
	[PayFrequency] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcAccountResponsiblePartySFHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcAccountResponsiblePartySFHistory](
	[AccountResponsiblePartySFHistoryUid] [uniqueidentifier] NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[FamilySize] [tinyint] NOT NULL,
	[MonthlyIncome] [money] NOT NULL,
	[NoIncome] [bit] NOT NULL,
	[SFCorporationUid] [uniqueidentifier] NULL,
	[SFScheduleDetailUid] [uniqueidentifier] NULL,
	[SFFormOfDeclarationUid] [uniqueidentifier] NULL,
	[SFEffectiveDate] [date] NULL,
	[NotFedSFQual] [bit] NOT NULL,
	[RefusedFSMI] [bit] NOT NULL,
	[UseSFClass] [bit] NOT NULL,
	[SFNote] [text] NULL,
	[PayFrequency] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcApprovalPeriod]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcApprovalPeriod](
	[ApprovalPeriodUid] [uniqueidentifier] NOT NULL,
	[ApprovalSettingUid] [uniqueidentifier] NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[BillingType] [int] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcFeeScheduleFee]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcFeeScheduleFee](
	[FeeScheduleFeeUid] [uniqueidentifier] NOT NULL,
	[RevenueGroupUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcInsurancePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcInsurancePlan](
	[InsurancePlanUid] [uniqueidentifier] NOT NULL,
	[SFCarrier] [bit] NOT NULL,
	[FQHCCarrier] [bit] NOT NULL,
	[SFFileClaims] [bit] NOT NULL,
	[AutoAdjustVisits] [bit] NOT NULL,
	[InsuredAlwaysSameAsPatient] [bit] NOT NULL,
	[OMAPInsCarrier] [bit] NOT NULL,
	[BenefitSetUid] [uniqueidentifier] NULL,
	[CPSPInsCarrier] [bit] NOT NULL,
	[MngCareInsCarrier] [bit] NOT NULL,
	[MBAdvantageInsCarrier] [bit] NOT NULL,
	[Secondary_BypassPrimaryFiling] [bit] NOT NULL,
	[ApprovalSettingUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListAgriculturalWorkStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListAgriculturalWorkStatus](
	[AgriculturalWorkStatusUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListAgriculturalWorkStatus_AgriculturalWorkStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListAgriculturalWorkStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListAgriculturalWorkStatus_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListAgriculturalWorkStatus_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListApprovalSetting]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListApprovalSetting](
	[ApprovalSettingUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListApprovalSettingCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListApprovalSettingCategory](
	[ApprovalSettingCategoryUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[PrimaryInsTypeUid] [uniqueidentifier] NULL,
	[AddValueCode] [bit] NOT NULL,
	[ValueCodeUid] [uniqueidentifier] NULL,
	[Notes] [text] NULL,
	[Inactive] [bit] NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListBenefitSet]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListBenefitSet](
	[BenefitSetUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListCitizenship]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListCitizenship](
	[CitizenshipUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListCitizenship_CitizenshipUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListCitizenship_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListCitizenship_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListCitizenship_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListContractTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListContractTypeCode](
	[ContractTypeCodeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListContractTypeCode_ContractTypeCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListContractTypeCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListContractTypeCode_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListContractTypeCode_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListEducation]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListEducation](
	[EducationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListEducation_EducationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListEducation_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListEducation_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListEducation_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListFinancialClass]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListFinancialClass](
	[FinancialClassUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListFinancialClass_FinancialClassUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListFinancialClass_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListFinancialClass_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListFinancialClass_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListFPLRegion]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListFPLRegion](
	[FPLRegionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListFPLRegion_FPLRegionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListFPLRegion_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListFPLRegion_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListFPLRegion_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListFPLSchedule]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListFPLSchedule](
	[FPLScheduleUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListFPLSchedule_FPLScheduleUid]  DEFAULT (newid()),
	[FPLRegionUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListFPLSchedule_Inactive]  DEFAULT ((0)),
	[Name] [varchar](75) NOT NULL,
	[ScheduleYear] [int] NULL,
	[EffectiveDate] [date] NULL,
	[BaseAmount] [money] NOT NULL CONSTRAINT [DF_ChcListFPLSchedule_BaseAmount]  DEFAULT ((0)),
	[IncrementalAmount] [money] NOT NULL CONSTRAINT [DF_ChcListFPLSchedule_IncrementalAmount]  DEFAULT ((0)),
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListFPLSchedule_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListFPLSchedule_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListHomelessStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListHomelessStatus](
	[HomelessStatusUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListHomelessStatus_HomelessStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListHomelessStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListHomelessStatus_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListHomelessStatus_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListPayorPlanSet]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListPayorPlanSet](
	[PayorPlanSetUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSet_PayorPlanSetUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSet_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[AutoAdjust] [bit] NULL,
	[ChargeAllowed] [bit] NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSet_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSet_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListPayorPlanSetRange]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListPayorPlanSetRange](
	[PayorPlanSetRangeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_PayorPlanSetRangeUid]  DEFAULT (newid()),
	[PayorPlanSetUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_Inactive]  DEFAULT ((0)),
	[Name] [varchar](75) NULL,
	[RangeType] [smallint] NOT NULL,
	[FrProcedureUid] [uniqueidentifier] NULL,
	[ToProcedureUid] [uniqueidentifier] NULL,
	[FrRevenueGroupUid] [uniqueidentifier] NULL,
	[ToRevenueGroupUid] [uniqueidentifier] NULL,
	[PayorPlanTypeUid] [uniqueidentifier] NULL,
	[Minimum] [money] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_Minimum]  DEFAULT ((0)),
	[Maximum] [money] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_Maximum]  DEFAULT ((0)),
	[StopLoss] [money] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_StopLoss]  DEFAULT ((0)),
	[Pct] [int] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_Pct]  DEFAULT ((0)),
	[MinVsPct] [smallint] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_MinVsPct]  DEFAULT ((0)),
	[Each] [bit] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_Each]  DEFAULT ((0)),
	[AggPayorPlanType] [bit] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_AggPayorPlanType]  DEFAULT ((0)),
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListPayorPlanSetRange_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListPayorPlanType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListPayorPlanType](
	[PayorPlanTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListPayorPlanType_PayorPlanTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListPayorPlanType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[InsurancePercent] [smallint] NULL,
	[PatientCopayAmount] [money] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListPayorPlanType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListPayorPlanType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListPrimaryInsType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListPrimaryInsType](
	[PrimaryInsTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListPrimaryInsType_PrimaryInsTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListPrimaryInsType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListPrimaryInsType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListPrimaryInsType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListPriorMedical]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListPriorMedical](
	[PriorMedicalUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListPriorMedical_PriorMedicalUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListPriorMedical_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListPriorMedical_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListPriorMedical_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListProcedureModifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListProcedureModifier](
	[ProcedureModifierUid] [uniqueidentifier] NOT NULL,
	[ProcedureModifierTypeUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListProcedureModifierType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListProcedureModifierType](
	[ProcedureModifierTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListProcedureModifierType_ProcedureModifierTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListProcedureModifierType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListProcedureModifierType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListProcedureModifierType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListReferralSource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListReferralSource](
	[ReferralSourceUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListReferralSource_ReferralSourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListReferralSource_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListReferralSource_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListReferralSource_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListRevenueGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListRevenueGroup](
	[RevenueGroupUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListServiceSiteType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListServiceSiteType](
	[ServiceSiteTypeUid] [uniqueidentifier] NOT NULL,
	[TypeOfBill] [varchar](5) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListSFFormOfDeclaration]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListSFFormOfDeclaration](
	[SFFormOfDeclarationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListSFFormOfDeclaration_SFFormOfDeclarationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListSFFormOfDeclaration_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListSFFormOfDeclaration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListSFSchedule]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListSFSchedule](
	[SFScheduleUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListSFSchedule_SFScheduleUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListSFSchedule_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListSFSchedule_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcListSFSchedule_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListSFScheduleDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListSFScheduleDetail](
	[SFScheduleDetailUid] [uniqueidentifier] NOT NULL,
	[SFScheduleUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[PovertyPercent] [int] NOT NULL,
	[Name] [varchar](75) NULL,
	[PayorPlanSetUid] [uniqueidentifier] NULL,
	[UseAsDefault] [bit] NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListSystemDefault]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListSystemDefault](
	[SystemDefaultUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[SFCorporationUid] [uniqueidentifier] NULL,
	[AllowInputOnNotFedQualified] [bit] NOT NULL,
	[DefaultFirstSlidingFeeClass] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcListVeteranStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcListVeteranStatus](
	[VeteranStatusUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ChcListVeteranStatus_VeteranStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ChcListVeteranStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ChcListVeteranStatus_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcPatient](
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Translation] [bit] NOT NULL CONSTRAINT [DF_ChcPatient_Translation]  DEFAULT ((0)),
	[CallCriteria] [tinyint] NULL,
	[CallCodeName] [varchar](30) NULL,
	[TimeToCall] [varchar](30) NULL,
	[CallCriteriaW] [tinyint] NULL,
	[CallCodeNameW] [varchar](30) NULL,
	[TimeToCallW] [varchar](30) NULL,
	[ReferralSourceUid] [uniqueidentifier] NULL,
	[ReferredByPersonUid] [uniqueidentifier] NULL,
	[RefDoctorUid] [uniqueidentifier] NULL,
	[BillingNotes] [text] NULL,
	[BenefitAssignmentDate] [date] NULL,
	[PrivacyPolicyAcknowledgementDate] [date] NULL,
	[MailOK] [tinyint] NULL,
	[AlertNotes] [text] NULL,
	[AppointmentNotes] [text] NULL,
	[ProfileNotes] [text] NULL,
	[PriorMedicalUid] [uniqueidentifier] NULL,
	[MemberHPSM] [bit] NOT NULL CONSTRAINT [DF_ChcPatient_MemberHPSM]  DEFAULT ((0)),
	[MediCaidNo] [varchar](25) NULL,
	[HapNo] [varchar](25) NULL,
	[ConfidentialVisit] [int] NOT NULL CONSTRAINT [DF_ChcPatient_ConfidentialVisit]  DEFAULT ((0)),
	[MailingList] [bit] NOT NULL CONSTRAINT [DF_ChcPatient_MailingList]  DEFAULT ((0)),
	[AgriculturalWorkStatusUid] [uniqueidentifier] NULL,
	[County] [varchar](30) NULL,
	[CitizenshipUid] [uniqueidentifier] NULL,
	[VeteranStatusUid] [uniqueidentifier] NULL,
	[EducationUid] [uniqueidentifier] NULL,
	[Homeless] [bit] NOT NULL CONSTRAINT [DF_ChcPatient_Homeless]  DEFAULT ((0)),
	[HomelessEffectiveDate] [date] NULL,
	[HomelessStatusUid] [uniqueidentifier] NULL,
	[HomelessNote] [text] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ChcPatient_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcPatientHomelessHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcPatientHomelessHistory](
	[PatientHomelessHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Homeless] [bit] NOT NULL,
	[HomelessEffectiveDate] [date] NULL,
	[HomelessStatusUid] [uniqueidentifier] NULL,
	[HomelessNote] [text] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcRelApprovalSetting]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcRelApprovalSetting](
	[RelApprovalSettingUid] [uniqueidentifier] NOT NULL,
	[ApprovalSettingUid] [uniqueidentifier] NULL,
	[ApprovalSettingCategoryUid] [uniqueidentifier] NULL,
	[Description] [varchar](50) NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[ContractTypeCodeUid] [uniqueidentifier] NULL,
	[Rate] [money] NULL,
	[UseFeeSchedule] [bit] NOT NULL,
	[UseAllowedAmount] [bit] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[ApprovalPeriodUid] [uniqueidentifier] NULL,
	[PostingType] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcSuperbill]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcSuperbill](
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[PrintOnPaperClaims] [bit] NOT NULL,
	[ClaimHeaderNotes] [text] NULL,
	[VisitNotes] [text] NULL,
	[ReceiptNotes] [text] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ChcSuperbillProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [ChcSuperbillProcedure](
	[SuperbillProcedureUid] [uniqueidentifier] NOT NULL,
	[RevenueGroupUid] [uniqueidentifier] NULL,
	[AddedBy_FQHChargeProcessor] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClaimBatch]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClaimBatch](
	[ClaimBatchUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ClaimBatch_ClaimBatchUid]  DEFAULT (newid()),
	[ClaimFormatTypeUid] [uniqueidentifier] NOT NULL,
	[InsuranceOrder] [int] NOT NULL,
	[ClaimDate] [datetime] NOT NULL CONSTRAINT [DF_ClaimBatch_ClaimDate]  DEFAULT (getutcdate()),
	[ClaimingUserUid] [uniqueidentifier] NULL,
	[FileName] [varchar](50) NULL,
	[Comments] [varchar](500) NULL,
	[EClaimFileUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ClaimBatch_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Status] [varchar](50) NULL,
	[BillingProviderUid] [uniqueidentifier] NULL,
	[ClaimClearingHouseUid] [uniqueidentifier] NULL,
	[SubmissionNumber] [int] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClaimBatchDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClaimBatchDetail](
	[ClaimBatchDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ClaimBatchDetail_ClaimBatchDetailUid]  DEFAULT (newid()),
	[ClaimBatchUid] [uniqueidentifier] NOT NULL,
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[InsurancePlanUid] [uniqueidentifier] NOT NULL,
	[Status] [varchar](50) NOT NULL,
	[Comments] [varchar](500) NULL,
	[IncludedInBatch] [bit] NOT NULL CONSTRAINT [DF_ClaimBatchDetail_IncludedInFile]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ClaimBatchDetail_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClaimFormatOption]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClaimFormatOption](
	[ClaimFormatOptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ClaimFormatOption_ClaimFormatOptionUid]  DEFAULT (newid()),
	[ClaimFormatUid] [uniqueidentifier] NOT NULL,
	[ClaimFormatOptionTypeUid] [uniqueidentifier] NOT NULL,
	[ClaimFormatValueTypeUid] [uniqueidentifier] NULL,
	[FixedValue] [varchar](255) NULL,
	[Codes] [varchar](2048) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ClaimFormatOption_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ClaimFormatOption_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClaimFormatValue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClaimFormatValue](
	[ClaimFormatValueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ClaimFormatVariable_ClaimFormatVariableUid]  DEFAULT (newid()),
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[ClaimFormatValueTypeUid] [uniqueidentifier] NOT NULL,
	[Value] [varchar](255) NOT NULL CONSTRAINT [DF_ClaimFormatValue_Value]  DEFAULT (''),
	[ProviderUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[Value2] [varchar](255) NULL,
	[Value3] [varchar](255) NULL,
	[Value4] [varchar](255) NULL,
	[Value5] [varchar](255) NULL,
	[Value6] [varchar](255) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ClaimFormatValue_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ClaimFormatValue_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicalDecisionSupportResults]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicalDecisionSupportResults](
	[ClinicalDecisionSupportResultsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AppointmentUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[RequestGeneratedDateTime] [datetime] NULL,
	[DateRequested] [date] NULL,
	[Request] [xml] NULL,
	[Response] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicCenterAttachment]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicCenterAttachment](
	[ClinicCenterAttachmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[AttachmentUid] [uniqueidentifier] NOT NULL,
	[Hide] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicCenterChargeTicketDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicCenterChargeTicketDiagnosis](
	[ClinicCenterChargeTicketDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[ChargeTicketDiagnosisUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicCenterChargeTicketSO]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicCenterChargeTicketSO](
	[ClinicCenterChargeTicketSOUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[ChargeTicketSOUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicCenterChargeTicketSP]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicCenterChargeTicketSP](
	[ClinicCenterChargeTicketSPUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[ChargeTicketSPUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicCenterCpp]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicCenterCpp](
	[ClinicCenterCppUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ClinicCenterCpp_ClinicCenterCppUid]  DEFAULT (newid()),
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[CppUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ClinicCenterCpp_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ClinicCenterCpp_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicCenterObservationItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicCenterObservationItem](
	[ClinicCenterObservationItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[RelObservationObservationItemUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[Hide] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicCenterObservationItemQualifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicCenterObservationItemQualifier](
	[ClinicCenterObservationItemQualifierUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[RelObservationItemQualifierUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[Hide] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicCenterProcedureModifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicCenterProcedureModifier](
	[ClinicCenterProcedureModifierUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[ProcedureModifierUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[Hide] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ClinicCenterSettings]') AND type in (N'U'))
BEGIN
CREATE TABLE [ClinicCenterSettings](
	[ClinicCenterSettingsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ClinicCenterSettings_ClinicCenterSettingsUid]  DEFAULT (newid()),
	[ReplicationAppointmentHours] [smallint] NULL,
	[ReplicationRemovePatientHours] [smallint] NULL,
	[ReplicationAttachmentSizeKB] [int] NULL,
	[ScanAppointmentSeconds] [smallint] NULL,
	[TriggerRemovePatientSeconds] [smallint] NULL,
	[TriggerReplicationSeconds] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ClinicCenterSettings_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ClinicCenterSettings_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Cms1500Claim]') AND type in (N'U'))
BEGIN
CREATE TABLE [Cms1500Claim](
	[Cms1500ClaimUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SuperBillUId] [uniqueidentifier] NULL,
	[Box_1] [varchar](1) NULL,
	[aInsuredsIDNumber_1] [varchar](100) NULL,
	[PatientName_2] [varchar](200) NULL,
	[PatientBirthDate_3] [varchar](10) NULL,
	[PatientSEX_3] [varchar](1) NULL,
	[InsuredsName_4] [varchar](200) NULL,
	[PatientsAddress_5] [varchar](200) NULL,
	[PatientCity_5] [varchar](25) NULL,
	[PatientState_5] [varchar](3) NULL,
	[PatientZipCode_5] [varchar](10) NULL,
	[PatientPhone_5] [varchar](22) NULL,
	[PatientRelationShipToInsured_6] [varchar](1) NULL,
	[InsuredsAddress_7] [varchar](200) NULL,
	[InsuredsCity_7] [varchar](25) NULL,
	[InsuredsState_7] [varchar](3) NULL,
	[InsuredsZipCode_7] [varchar](10) NULL,
	[InsuredsPhone_7] [varchar](22) NULL,
	[PatientStatus_8] [varchar](1) NULL,
	[PatientStatusEmployed_8] [varchar](1) NULL,
	[OtherInsuredsName_9] [varchar](200) NULL,
	[OtherInsuredsIDNumber_9a] [varchar](100) NULL,
	[OtherInsuredsBirthDate_9b] [varchar](10) NULL,
	[OtherInsuredsSEX_9b] [varchar](1) NULL,
	[EmployersName_9c] [varchar](50) NULL,
	[InsurancePlanName_9d] [varchar](100) NULL,
	[PatientConditionRelatedTo_10] [varchar](1) NULL,
	[PatientConditionRelatedToAutoAccidentPlace_10b] [varchar](3) NULL,
	[InsuredsPolicyGroupOrFECANumber_11] [varchar](100) NULL,
	[InsuredsBirthDate_11a] [varchar](10) NULL,
	[InsuredsSEX_11a] [varchar](1) NULL,
	[EmployersName_11b] [varchar](50) NULL,
	[InsurancePlanName_11c] [varchar](100) NULL,
	[AnotherHealthBenefitPlan_11d] [varchar](1) NULL,
	[PatientSigned_12] [varchar](25) NULL,
	[PatientSignedDate_12] [varchar](10) NULL,
	[InsuredsSignature_13] [varchar](25) NULL,
	[DateOfCurrent_14] [varchar](10) NULL,
	[FirstDate_15] [varchar](10) NULL,
	[FromDateUnableToWork_16] [varchar](10) NULL,
	[ToDateUnableToWork_16] [varchar](10) NULL,
	[RefferringPhysicianName_17] [varchar](200) NULL,
	[RefferringPhysicianIDNumber_17a] [varchar](50) NULL,
	[HospitalizationDateFrom_18] [varchar](10) NULL,
	[HospitalizationDateTo_18] [varchar](10) NULL,
	[ResrvedForLocalUse_19] [varchar](max) NULL,
	[OutsideLab_20] [varchar](1) NULL,
	[Charge_20] [money] NULL,
	[Diagnosis1_21] [varchar](25) NULL,
	[Diagnosis2_21] [varchar](25) NULL,
	[Diagnosis3_21] [varchar](25) NULL,
	[Diagnosis4_21] [varchar](25) NULL,
	[MedicaidResubmissionCode_22] [varchar](50) NULL,
	[MedicaidResubmissionOriginalRefNo_22] [varchar](50) NULL,
	[PriorAuthorizationNumber_23] [varchar](35) NULL,
	[FederalTaxId_25] [varchar](50) NULL,
	[ProviderTaxType_25] [varchar](50) NULL,
	[PatientAccountNumber_26] [varchar](50) NULL,
	[AcceptAssignment_27] [varchar](1) NULL,
	[PhysicianName_31] [varchar](200) NULL,
	[Date_31] [varchar](10) NULL,
	[FacilityName_32] [varchar](50) NULL,
	[FacilityAddress_32] [varchar](100) NULL,
	[FacilityCSZ_32] [varchar](50) NULL,
	[PhysicianName_33] [varchar](100) NULL,
	[PhysicianAddress_33] [varchar](100) NULL,
	[PhysicianCS_33] [varchar](50) NULL,
	[PhysicianPIN_33] [varchar](25) NULL,
	[PhysicianGRP_33] [varchar](25) NULL,
	[PayerName_34] [varchar](50) NULL,
	[PayerAddress_34] [varchar](100) NULL,
	[PayerCSZ_34] [varchar](50) NULL,
	[TotalCharge_28] [money] NULL,
	[AmountPaid_29] [money] NULL,
	[BalanceDue_30] [money] NULL,
	[ClaimBatchUID] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[MedicareApprovedAmount] [money] NULL,
	[MedicareDeductible] [money] NULL,
	[FacilityId_32a] [varchar](25) NULL,
	[MedicareCoInsurance] [money] NULL,
	[DatePaidByMedicare] [varchar](6) NULL,
	[OtherSourceAmount] [money] NULL,
	[OtherSourceCode] [varchar](1) NULL,
	[EPSDT] [varchar](1) NULL,
	[Box17aType] [varchar](10) NULL,
	[rProviderNPI] [varchar](25) NULL,
	[Box32bType] [varchar](25) NULL,
	[ServiceSiteNPI] [varchar](25) NULL,
	[Box33GRPType] [varchar](10) NULL,
	[Box33Phone] [varchar](20) NULL,
	[Box15Qualifier] [varchar](3) NULL,
	[Box17Qualifier] [varchar](2) NULL,
	[DisplayOrder] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Cms1500ClaimProcs]') AND type in (N'U'))
BEGIN
CREATE TABLE [Cms1500ClaimProcs](
	[Cms1500ClaimProcsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SuperBillUId] [uniqueidentifier] NULL,
	[DOSFrom_24a1] [varchar](10) NULL,
	[DOSTo_24a1] [varchar](10) NULL,
	[POS_24b1] [varchar](10) NULL,
	[TOS_24c1] [varchar](10) NULL,
	[ProcedureCode_24d1] [varchar](25) NULL,
	[ProcedureModifier_24d1] [varchar](2) NULL,
	[ModifierList_24d1] [varchar](20) NULL,
	[DiagnosisCodePointer_24e1] [varchar](7) NULL,
	[Charges_24f1] [money] NULL,
	[DaysOrUnits_24g1] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h1] [varchar](1) NULL,
	[EMG_24i1] [varchar](10) NULL,
	[COB_24j1] [varchar](10) NULL,
	[ReservedForLocalUse_24k1] [varchar](100) NULL,
	[DOSFrom_24a2] [varchar](10) NULL,
	[DOSTo_24a2] [varchar](10) NULL,
	[POS_24b2] [varchar](10) NULL,
	[TOS_24c2] [varchar](10) NULL,
	[ProcedureCode_24d2] [varchar](25) NULL,
	[ProcedureModifier_24d2] [varchar](2) NULL,
	[ModifierList_24d2] [varchar](20) NULL,
	[DiagnosisCodePointer_24e2] [varchar](7) NULL,
	[Charges_24f2] [money] NULL,
	[DaysOrUnits_24g2] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h2] [varchar](1) NULL,
	[EMG_24i2] [varchar](10) NULL,
	[COB_24j2] [varchar](10) NULL,
	[ReservedForLocalUse_24k2] [varchar](100) NULL,
	[DOSFrom_24a3] [varchar](10) NULL,
	[DOSTo_24a3] [varchar](10) NULL,
	[POS_24b3] [varchar](10) NULL,
	[TOS_24c3] [varchar](10) NULL,
	[ProcedureCode_24d3] [varchar](25) NULL,
	[ProcedureModifier_24d3] [varchar](2) NULL,
	[ModifierList_24d3] [varchar](20) NULL,
	[DiagnosisCodePointer_24e3] [varchar](7) NULL,
	[Charges_24f3] [money] NULL,
	[DaysOrUnits_24g3] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h3] [varchar](1) NULL,
	[EMG_24i3] [varchar](10) NULL,
	[COB_24j3] [varchar](10) NULL,
	[ReservedForLocalUse_24k3] [varchar](100) NULL,
	[DOSFrom_24a4] [varchar](10) NULL,
	[DOSTo_24a4] [varchar](10) NULL,
	[POS_24b4] [varchar](10) NULL,
	[TOS_24c4] [varchar](10) NULL,
	[ProcedureCode_24d4] [varchar](25) NULL,
	[ProcedureModifier_24d4] [varchar](2) NULL,
	[ModifierList_24d4] [varchar](20) NULL,
	[DiagnosisCodePointer_24e4] [varchar](7) NULL,
	[Charges_24f4] [money] NULL,
	[DaysOrUnits_24g4] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h4] [varchar](1) NULL,
	[EMG_24i4] [varchar](10) NULL,
	[COB_24j4] [varchar](10) NULL,
	[ReservedForLocalUse_24k4] [varchar](100) NULL,
	[DOSFrom_24a5] [varchar](10) NULL,
	[DOSTo_24a5] [varchar](10) NULL,
	[POS_24b5] [varchar](10) NULL,
	[TOS_24c5] [varchar](10) NULL,
	[ProcedureCode_24d5] [varchar](25) NULL,
	[ProcedureModifier_24d5] [varchar](2) NULL,
	[ModifierList_24d5] [varchar](20) NULL,
	[DiagnosisCodePointer_24e5] [varchar](7) NULL,
	[Charges_24f5] [money] NULL,
	[DaysOrUnits_24g5] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h5] [varchar](1) NULL,
	[EMG_24i5] [varchar](10) NULL,
	[COB_24j5] [varchar](10) NULL,
	[ReservedForLocalUse_24k5] [varchar](100) NULL,
	[DOSFrom_24a6] [varchar](10) NULL,
	[DOSTo_24a6] [varchar](10) NULL,
	[POS_24b6] [varchar](10) NULL,
	[TOS_24c6] [varchar](10) NULL,
	[ProcedureCode_24d6] [varchar](25) NULL,
	[ProcedureModifier_24d6] [varchar](2) NULL,
	[ModifierList_24d6] [varchar](20) NULL,
	[DiagnosisCodePointer_24e6] [varchar](7) NULL,
	[Charges_24f6] [money] NULL,
	[DaysOrUnits_24g6] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h6] [varchar](1) NULL,
	[EMG_24i6] [varchar](10) NULL,
	[COB_24j6] [varchar](10) NULL,
	[ReservedForLocalUse_24k6] [varchar](100) NULL,
	[ClaimBatchUID] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[CMS1500ClaimUId] [uniqueidentifier] NULL,
	[DOSFrom_24a7] [varchar](10) NULL,
	[DOSTo_24a7] [varchar](10) NULL,
	[POS_24b7] [varchar](10) NULL,
	[TOS_24c7] [varchar](10) NULL,
	[ProcedureCode_24d7] [varchar](25) NULL,
	[ProcedureModifier_24d7] [varchar](2) NULL,
	[ModifierList_24d7] [varchar](20) NULL,
	[DiagnosisCodePointer_24e7] [varchar](7) NULL,
	[Charges_24f7] [money] NULL,
	[DaysOrUnits_24g7] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h7] [varchar](1) NULL,
	[EMG_24i7] [varchar](10) NULL,
	[COB_24j7] [varchar](10) NULL,
	[ReservedForLocalUse_24k7] [varchar](100) NULL,
	[DOSFrom_24a8] [varchar](10) NULL,
	[DOSTo_24a8] [varchar](10) NULL,
	[POS_24b8] [varchar](10) NULL,
	[TOS_24c8] [varchar](10) NULL,
	[ProcedureCode_24d8] [varchar](25) NULL,
	[ProcedureModifier_24d8] [varchar](2) NULL,
	[ModifierList_24d8] [varchar](20) NULL,
	[DiagnosisCodePointer_24e8] [varchar](7) NULL,
	[Charges_24f8] [money] NULL,
	[DaysOrUnits_24g8] [varchar](5) NULL,
	[EPSDTFamilyPlan_8] [varchar](1) NULL,
	[EMG_24i8] [varchar](10) NULL,
	[COB_24j8] [varchar](10) NULL,
	[ReservedForLocalUse_24k8] [varchar](100) NULL,
	[DOSFrom_24a9] [varchar](10) NULL,
	[DOSTo_24a9] [varchar](10) NULL,
	[POS_24b9] [varchar](10) NULL,
	[TOS_24c9] [varchar](10) NULL,
	[ProcedureCode_24d9] [varchar](25) NULL,
	[ProcedureModifier_24d9] [varchar](2) NULL,
	[ModifierList_24d9] [varchar](20) NULL,
	[DiagnosisCodePointer_24e9] [varchar](7) NULL,
	[Charges_24f9] [money] NULL,
	[DaysOrUnits_24g9] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h9] [varchar](1) NULL,
	[EMG_24i9] [varchar](10) NULL,
	[COB_24j9] [varchar](10) NULL,
	[ReservedForLocalUse_24k9] [varchar](100) NULL,
	[DOSFrom_24a10] [varchar](10) NULL,
	[DOSTo_24a10] [varchar](10) NULL,
	[POS_24b10] [varchar](10) NULL,
	[TOS_24c10] [varchar](10) NULL,
	[ProcedureCode_24d10] [varchar](25) NULL,
	[ProcedureModifier_24d10] [varchar](2) NULL,
	[ModifierList_24d10] [varchar](20) NULL,
	[DiagnosisCodePointer_24e10] [varchar](7) NULL,
	[Charges_24f10] [money] NULL,
	[DaysOrUnits_24g10] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h10] [varchar](1) NULL,
	[EMG_24i10] [varchar](10) NULL,
	[COB_24j10] [varchar](10) NULL,
	[ReservedForLocalUse_24k10] [varchar](100) NULL,
	[DOSFrom_24a11] [varchar](10) NULL,
	[DOSTo_24a11] [varchar](10) NULL,
	[POS_24b11] [varchar](10) NULL,
	[TOS_24c11] [varchar](10) NULL,
	[ProcedureCode_24d11] [varchar](25) NULL,
	[ProcedureModifier_24d11] [varchar](2) NULL,
	[ModifierList_24d11] [varchar](20) NULL,
	[DiagnosisCodePointer_24e11] [varchar](7) NULL,
	[Charges_24f11] [money] NULL,
	[DaysOrUnits_24g11] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h11] [varchar](1) NULL,
	[EMG_24i11] [varchar](10) NULL,
	[COB_24j11] [varchar](10) NULL,
	[ReservedForLocalUse_24k11] [varchar](100) NULL,
	[DOSFrom_24a12] [varchar](10) NULL,
	[DOSTo_24a12] [varchar](10) NULL,
	[POS_24b12] [varchar](10) NULL,
	[TOS_24c12] [varchar](10) NULL,
	[ProcedureCode_24d12] [varchar](25) NULL,
	[ProcedureModifier_24d12] [varchar](2) NULL,
	[ModifierList_24d12] [varchar](20) NULL,
	[DiagnosisCodePointer_24e12] [varchar](7) NULL,
	[Charges_24f12] [money] NULL,
	[DaysOrUnits_24g12] [varchar](5) NULL,
	[EPSDTFamilyPlan_24h12] [varchar](1) NULL,
	[EMG_24i12] [varchar](10) NULL,
	[COB_24j12] [varchar](10) NULL,
	[ReservedForLocalUse_24k12] [varchar](100) NULL,
	[Note_24l1] [varchar](80) NULL,
	[Note_24l2] [varchar](80) NULL,
	[Note_24l3] [varchar](80) NULL,
	[Note_24l4] [varchar](80) NULL,
	[Note_24l5] [varchar](80) NULL,
	[Note_24l6] [varchar](80) NULL,
	[Note_24l7] [varchar](80) NULL,
	[Note_24l8] [varchar](80) NULL,
	[Note_24l9] [varchar](80) NULL,
	[Note_24l10] [varchar](80) NULL,
	[Note_24l11] [varchar](80) NULL,
	[Note_24l12] [varchar](80) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CMSCodeXml]') AND type in (N'U'))
BEGIN
CREATE TABLE [CMSCodeXml](
	[FilePath] [varchar](max) NULL,
	[Measure] [varchar](10) NULL,
	[Content] [varbinary](max) NULL,
	[XMLContent] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[COBClaimAdjustments]') AND type in (N'U'))
BEGIN
CREATE TABLE [COBClaimAdjustments](
	[COBClaimAdjustmentsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[COBClaimDetailUid] [uniqueidentifier] NOT NULL,
	[DepositUid] [uniqueidentifier] NOT NULL,
	[GroupCodeERACodeUid] [uniqueidentifier] NOT NULL,
	[ReasonCodeERACodeUid] [uniqueidentifier] NOT NULL,
	[Amount] [money] NOT NULL,
	[Quantity] [decimal](18, 0) NULL,
	[Notes] [varchar](max) NULL,
	[StatementNote] [varchar](300) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[COBClaimDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [COBClaimDetail](
	[COBClaimDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_COBClaimDetail_COBClaimDetailUid]  DEFAULT (newid()),
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[InsuranceOrder] [smallint] NOT NULL CONSTRAINT [DF_COBClaimDetail_InsuranceOrder]  DEFAULT ((0)),
	[ICN] [varchar](80) NULL,
	[ReimbursementRate] [decimal](18, 0) NULL,
	[HCPCSPayableAmount] [money] NULL,
	[MOARemarkCode1Uid] [uniqueidentifier] NULL,
	[MOARemarkCode2Uid] [uniqueidentifier] NULL,
	[MOARemarkCode3Uid] [uniqueidentifier] NULL,
	[MOARemarkCode4Uid] [uniqueidentifier] NULL,
	[MOARemarkCode5Uid] [uniqueidentifier] NULL,
	[ESRDPaymentAmount] [money] NULL,
	[NonpayableProfessionalComponentAmount] [money] NULL,
	[AdjudicationDate] [date] NULL,
	[DiscountAmount] [money] NULL,
	[PerDayLimitAmount] [money] NULL,
	[PatientResponsibleAmount] [money] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_COBClaimDetail_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[COBLineAdjustments]') AND type in (N'U'))
BEGIN
CREATE TABLE [COBLineAdjustments](
	[COBLineAdjustmentsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[COBClaimDetailUid] [uniqueidentifier] NOT NULL,
	[SuperbillProcedureUid] [uniqueidentifier] NOT NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[CreditTypeUid] [uniqueidentifier] NULL,
	[TransactionUid] [uniqueidentifier] NULL,
	[GroupCodeERACodeUid] [uniqueidentifier] NOT NULL,
	[ReasonCodeERACodeUid] [uniqueidentifier] NOT NULL,
	[Amount] [money] NOT NULL,
	[Quantity] [decimal](18, 0) NULL,
	[Notes] [varchar](max) NULL,
	[StatementNote] [varchar](300) NULL,
	[LiabilityOwner] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CollectionHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [CollectionHistory](
	[CollectionHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CollectionHistory_CollectionHistoryUid]  DEFAULT (newid()),
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[InitialCollectionStatusUid] [uniqueidentifier] NULL,
	[InitialCollectionStatusLevelUid] [uniqueidentifier] NULL,
	[NewCollectionStatusUid] [uniqueidentifier] NULL,
	[NewCollectionStatusLevelUid] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_CollectionHistory_Date]  DEFAULT (getutcdate()),
	[Reason] [varchar](500) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisableAlert] [bit] NOT NULL CONSTRAINT [DF_CollectionHistory_DisableAlert]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CollectionHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CollectionLetter]') AND type in (N'U'))
BEGIN
CREATE TABLE [CollectionLetter](
	[CollectionLetterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CollectionLetterPrintQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [CollectionLetterPrintQueue](
	[CollectionLetterPrintQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RelAttachmentGroupUid] [uniqueidentifier] NULL,
	[LastPrintedDate] [datetime] NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CollectionMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [CollectionMessage](
	[CollectionMessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CollectionStatusGlobal]') AND type in (N'U'))
BEGIN
CREATE TABLE [CollectionStatusGlobal](
	[CollectionStatusGlobalUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CollectionStatusGlobal_CollectionStatusGlobalUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL CONSTRAINT [DF_CollectionStatusGlobal_Name]  DEFAULT ('Global Settings'),
	[InitialCollectionStatusUid] [uniqueidentifier] NULL,
	[GlobalSufficientPercentage] [int] NULL,
	[PatientLiabilityDays] [int] NULL CONSTRAINT [DF_CollectionStatusGlobal_PatientLiabilityDays]  DEFAULT ((60)),
	[OverrideProcedureUid] [uniqueidentifier] NULL,
	[FeeDefaultProcedureUid] [uniqueidentifier] NULL,
	[FeeDefaultProviderUid] [uniqueidentifier] NULL,
	[FeeDefaultFinancialCenterUid] [uniqueidentifier] NULL,
	[FeeDefaultServiceSiteUid] [uniqueidentifier] NULL,
	[FeeBatchOwnerUid] [uniqueidentifier] NULL,
	[FeeNamingPrefix] [varchar](25) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CollectionStatusGlobal_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CollectionStatusGlobal_LastModifiedDate]  DEFAULT (getutcdate()),
	[UseStatementCountSinceLastPayment] [bit] NULL,
	[StatmentCountSinceLastPayment] [int] NULL,
	[NumberOfDaysForResponseAfterLastStatmentDate] [int] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CollectionStatusLevel]') AND type in (N'U'))
BEGIN
CREATE TABLE [CollectionStatusLevel](
	[CollectionStatusLevelUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CollectionStatusLevels_CollectionStatusLevelUid]  DEFAULT (newid()),
	[CollectionStatusUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[BalanceFrom] [money] NOT NULL,
	[BalanceTo] [money] NULL,
	[GreaterThan] [bit] NOT NULL CONSTRAINT [DF_CollectionStatusLevels_GreaterThan]  DEFAULT ((0)),
	[EnteringLetterModelUid] [uniqueidentifier] NULL,
	[EnteringPatientRemark] [bit] NOT NULL CONSTRAINT [DF_CollectionStatusLevel_EnteringPatientRemark]  DEFAULT ((0)),
	[ExpirationNextStatusSufficientUid] [uniqueidentifier] NULL,
	[ExpirationNextStatusInsufficientUid] [uniqueidentifier] NOT NULL,
	[ExpirationNumberOfDays] [int] NOT NULL,
	[InsufficientPatientRemark] [bit] NOT NULL CONSTRAINT [DF_CollectionStatusLevel_InsufficientPatientRemark]  DEFAULT ((0)),
	[InsufficientExpirationMessageRecipientUserUid] [uniqueidentifier] NULL,
	[InsufficientExpirationMessageRecipientUserGroupUid] [uniqueidentifier] NULL,
	[InsufficientExpirationMessageUrgencyUid] [uniqueidentifier] NULL,
	[ChargeFee] [bit] NOT NULL CONSTRAINT [DF_CollectionStatusLevels_ChargeFee]  DEFAULT ((0)),
	[IsFeeFixedAmount] [bit] NOT NULL CONSTRAINT [DF_CollectionStatusLevel_IsFeeFixedAmount]  DEFAULT ((1)),
	[ExpirationPercent] [decimal](18, 0) NOT NULL CONSTRAINT [DF_CollectionStatusLevel_ExpirationPercent]  DEFAULT ((0)),
	[ExpirationFixedFeeAmount] [money] NOT NULL CONSTRAINT [DF_CollectionStatusLevel_ExpirationFixedFeeAmount]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_CollectionStatusLevels_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CollectionStatusLevels_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CollectionStatusLevels_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Corporation]') AND type in (N'U'))
BEGIN
CREATE TABLE [Corporation](
	[CorporationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Corporation_CorporationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Corporation_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Address] [xml](CONTENT [Address]) NULL,
	[BadAddress] [bit] NOT NULL CONSTRAINT [DF_Corporation_BadAddress]  DEFAULT ((0)),
	[PrimaryContact] [varchar](50) NULL,
	[SecondaryContact] [varchar](50) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Phone3] [xml](CONTENT [Phone]) NULL,
	[Phone4] [xml](CONTENT [Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Internal] [bit] NOT NULL CONSTRAINT [DF_Corporation_Internal]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Corporation_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Corporation_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Computed_Address_Address1] [varchar](100) NULL,
	[Computed_Address_Address2] [varchar](100) NULL,
	[Computed_Address_City] [varchar](35) NULL,
	[Computed_Address_State] [varchar](3) NULL,
	[Computed_Address_Zip] [varchar](10) NULL,
	[Computed_Phone1_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone1_PhoneType] [varchar](50) NULL,
	[Computed_Phone2_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone2_PhoneType] [varchar](50) NULL,
	[Computed_Phone3_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone3_PhoneType] [varchar](50) NULL,
	[Computed_Phone4_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone4_PhoneType] [varchar](50) NULL,
	[CorpNotes] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppAssessmentForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppAssessmentForm](
	[CppAssessmentFormUid] [uniqueidentifier] NOT NULL,
	[CppUid] [uniqueidentifier] NOT NULL,
	[AssessmentFormUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[Data] [xml] NULL,
	[Text] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppCC]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppCC](
	[CppCCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CppCC_CppCCUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NOT NULL,
	[CCSystemUid] [uniqueidentifier] NOT NULL,
	[CCSystemName] [varchar](100) NULL,
	[CCSymptomUid] [uniqueidentifier] NOT NULL,
	[CCSymptomName] [varchar](100) NULL,
	[Preposition] [varchar](25) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppCC_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppCC_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppCC_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppDiagnosis](
	[CppDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CppDiagnosis_CppDiagnosisUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[Name] [varchar](200) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppDiagnosis_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppDiet]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppDiet](
	[CppDietUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table_1_VisitDietUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NOT NULL,
	[DietUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppDiet_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppDiet_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppDiet_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppEduForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppEduForm](
	[CppEduFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CppUid] [uniqueidentifier] NULL,
	[EduFormUid] [uniqueidentifier] NULL,
	[ReleaseProviderUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppExercise]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppExercise](
	[CppExerciseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table_1_VisitExerciseUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NOT NULL,
	[ExerciseUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppExercise_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppExercise_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppExercise_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppHpi]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppHpi](
	[CppHpiUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CppHpi_CppHpiUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NULL,
	[CCSymptomUid] [uniqueidentifier] NULL,
	[CCSymptomName] [varchar](100) NULL,
	[CCSymptomDisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppHpi_CCSymptomDisplayOrder]  DEFAULT ((0)),
	[HpiCategoryUid] [uniqueidentifier] NULL,
	[HpiCategoryName] [varchar](100) NULL,
	[HpiCategoryDisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppHpi_HpiCategoryDisplayOrder]  DEFAULT ((0)),
	[HpiUid] [uniqueidentifier] NULL,
	[HpiName] [varchar](100) NULL,
	[HpiDisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppHpi_HpiDisplayOrder]  DEFAULT ((0)),
	[Denies] [bit] NOT NULL CONSTRAINT [DF_CppHpi_Denies]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppHpi_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppHpi_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppMedication]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppMedication](
	[CppMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ProviderCppMedication_ProviderCppMedicationUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NOT NULL,
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](500) NULL,
	[FDB_HIC_SEQN] [int] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppMedication_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ProviderCppMedication_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppMedication_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppPatientInstruction]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppPatientInstruction](
	[CppPatientInstructionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_CppCCUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NOT NULL,
	[UserNotesUid] [uniqueidentifier] NOT NULL,
	[RecordTypeID] [smallint] NULL CONSTRAINT [DF_CppPatientInstruction_RecordTypeID]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppPatientInstruction_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppPatientInstruction_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppPE](
	[CppPEUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CppPE_CppPEUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NOT NULL,
	[PETemplateUid] [uniqueidentifier] NOT NULL,
	[PETemplateName] [varchar](100) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppPE_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppPE_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppPE_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppPEDescription]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppPEDescription](
	[CppPEDescriptionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CppPEDescription_CppPEDescriptionUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NOT NULL,
	[PETemplateUid] [uniqueidentifier] NOT NULL,
	[PEParentSystemUid] [uniqueidentifier] NULL,
	[PESystemUid] [uniqueidentifier] NULL,
	[PESymptomUid] [uniqueidentifier] NULL,
	[PEDescriptionUid] [uniqueidentifier] NULL,
	[PETemplateName] [varchar](100) NULL,
	[PEParentSystemName] [varchar](100) NULL,
	[PEParentSystemDisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppPEDescription_PEParentSystemDisplayOrder]  DEFAULT ((0)),
	[PESystemName] [varchar](100) NULL,
	[PESystemDisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppPEDescription_PESystemDisplayOrder]  DEFAULT ((0)),
	[PESymptomName] [varchar](100) NULL,
	[PESymptomDisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppPEDescription_PESymptomDisplayOrder]  DEFAULT ((0)),
	[PEDescriptionName] [varchar](255) NULL,
	[IsPEParentSystemBilateral] [bit] NOT NULL CONSTRAINT [DF_CppPEDescription_IsPEParentSystemBilateral]  DEFAULT ((0)),
	[IsPESystemBilateral] [bit] NOT NULL CONSTRAINT [DF_CppPEDescription_IsPESystemBilateral]  DEFAULT ((0)),
	[IsPESymptomBilateral] [bit] NOT NULL CONSTRAINT [DF_CppPEDescription_IsPESymptomBilateral]  DEFAULT ((0)),
	[BilateralityValue] [smallint] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppPEDescription_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppPEDescription_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppPEDescription_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppRos]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppRos](
	[CppRosUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_CppRos_CppRosUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NOT NULL,
	[RosSystemUid] [uniqueidentifier] NOT NULL,
	[RosSymptomUid] [uniqueidentifier] NOT NULL,
	[RosSystemName] [varchar](100) NULL,
	[RosSymptomName] [varchar](100) NULL,
	[RosSystemDisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppRos_RosSystemDisplayOrder]  DEFAULT ((0)),
	[DenyFlag] [bit] NOT NULL CONSTRAINT [DF_CppRos_DenyFlag]  DEFAULT ((0)),
	[AllNormalFlag] [bit] NOT NULL CONSTRAINT [DF_CppRos_AllNormalFlag]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppRos_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppRos_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppRos_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppSO]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppSO](
	[CppSOUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CppSO_CppSOUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[Name] [varchar](255) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppSO_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppSO_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppSO_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CppSP]') AND type in (N'U'))
BEGIN
CREATE TABLE [CppSP](
	[CppSPUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CppSP_CppSPUid]  DEFAULT (newid()),
	[CppUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[Name] [varchar](255) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_CppSP_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CppSP_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CppSP_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CreditCardConsentOnFile]') AND type in (N'U'))
BEGIN
CREATE TABLE [CreditCardConsentOnFile](
	[ConsentOnFileUid] [uniqueidentifier] NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[ConsentID] [int] NOT NULL,
	[ConsentType] [varchar](10) NOT NULL,
	[CardNoLastDigits] [varchar](20) NULL,
	[CardTypeName] [varchar](20) NULL,
	[IsEnabled] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CreditCardErrorLog]') AND type in (N'U'))
BEGIN
CREATE TABLE [CreditCardErrorLog](
	[ErrorLogUid] [uniqueidentifier] NOT NULL,
	[ModuleName] [varchar](250) NULL,
	[ModuleInArgs] [varchar](max) NULL,
	[ServiceMethodCall] [varchar](250) NULL,
	[DisplayErrorMessage] [varchar](max) NULL,
	[ResponseMessage] [varchar](max) NULL,
	[ErrorMessage] [varchar](max) NULL,
	[ErrorCode] [int] NOT NULL,
	[ExceptionMessage] [varchar](max) NULL,
	[StackTrace] [varchar](max) NULL,
	[LastServiceEndPointName] [varchar](250) NULL,
	[LastServiceCallUid] [uniqueidentifier] NULL,
	[UserPRMUid] [uniqueidentifier] NULL,
	[RemoteSessionId] [varchar](500) NULL,
	[SubmitDate] [date] NULL,
	[SubmitDateTime] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CreditCardServiceCall]') AND type in (N'U'))
BEGIN
CREATE TABLE [CreditCardServiceCall](
	[CreditCardServiceCallUid] [uniqueidentifier] NOT NULL,
	[UserPRMUid] [uniqueidentifier] NOT NULL,
	[RemoteSessionId] [varchar](500) NOT NULL,
	[AprimaEndPointName] [varchar](250) NOT NULL,
	[AprimaInArgs] [varchar](max) NULL,
	[AprimaOutArgs] [varchar](max) NULL,
	[ServiceEndPointName] [varchar](250) NOT NULL,
	[ServiceCallInArgs] [nvarchar](max) NULL,
	[ServiceCallOutArgs] [varchar](max) NULL,
	[SubmitDate] [date] NOT NULL,
	[SubmitDateTime] [datetime] NOT NULL,
	[ResponseDateTime] [datetime] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CreditCardTransactionHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [CreditCardTransactionHistory](
	[TransactionHistoryUid] [uniqueidentifier] NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[MerchID] [varchar](50) NOT NULL,
	[TxID] [int] NOT NULL,
	[TxDateTime] [datetime] NOT NULL,
	[ConsentID] [int] NULL,
	[ConsentType] [varchar](50) NULL,
	[PaymentAmount] [money] NULL,
	[TxCode] [varchar](50) NULL,
	[AVSresult] [varchar](50) NULL,
	[CVVresult] [varchar](50) NULL,
	[IsPartialApproval] [bit] NULL,
	[ResponseAuthorizedAmount] [money] NULL,
	[ResponseBalanceAmount] [money] NULL,
	[ResponseApprovedAmount] [money] NULL,
	[CreditCardResponse] [varchar](500) NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[SourceOfPayment] [smallint] NOT NULL,
	[ApplicationSubmittingPayment] [varchar](100) NULL,
	[IsVoided] [bit] NOT NULL,
	[VoidedDateTime] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CustomizeLink]') AND type in (N'U'))
BEGIN
CREATE TABLE [CustomizeLink](
	[CustomizeLinkUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[LinkProcedureUid] [varchar](10) NULL,
	[ProcedureNotePageUid] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[CVXVISMap]') AND type in (N'U'))
BEGIN
CREATE TABLE [CVXVISMap](
	[CVXVISMapUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CVXVISMap_CVXVISMapUid]  DEFAULT (newid()),
	[CVXCode] [varchar](50) NOT NULL,
	[CVXVaccineDescr] [varchar](max) NOT NULL,
	[VISDocTypeDescr] [varchar](max) NOT NULL,
	[VISEditionDate] [date] NOT NULL,
	[VISEncodedString] [varchar](max) NOT NULL,
	[VISGDTIDocCode] [varchar](max) NOT NULL,
	[VISEditionStatus] [varchar](200) NOT NULL,
	[VISLastUpdatedDate] [date] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_CVXVISMapping_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CVXVISMap_UserDefined]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CVXVISMapping_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DefaultMedicationUnit]') AND type in (N'U'))
BEGIN
CREATE TABLE [DefaultMedicationUnit](
	[DefaultMedicationUnitUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_DefaultMedicationUnit_DefaultMedicationUnitUid]  DEFAULT (newid()),
	[medid] [int] NOT NULL,
	[MedicationUnitUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_DefaultMedicationUnit_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_DefaultMedicationUnit_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_DefaultMedicationUnit_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Deposit]') AND type in (N'U'))
BEGIN
CREATE TABLE [Deposit](
	[DepositUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Deposit_DepositUid]  DEFAULT (newid()),
	[Amount] [money] NOT NULL CONSTRAINT [DF_Deposit_Amount]  DEFAULT ((0)),
	[WhoPaidPersonUid] [uniqueidentifier] NULL,
	[WhoPaidInsuranceCarrierUid] [uniqueidentifier] NULL,
	[PayerAlias] [varchar](250) NULL,
	[DepositDate] [date] NULL,
	[AppointmentUid] [uniqueidentifier] NULL,
	[PaymentTypeUid] [uniqueidentifier] NOT NULL,
	[DepositMacroUid] [uniqueidentifier] NULL,
	[ReferenceNumber] [varchar](250) NULL,
	[Void] [bit] NOT NULL CONSTRAINT [DF_Deposit_Void]  DEFAULT ((0)),
	[Comment] [varchar](max) NULL,
	[CreateDateTime] [datetime] NULL CONSTRAINT [DF_Deposit_CreateDate]  DEFAULT (getutcdate()),
	[ARBatchUid] [uniqueidentifier] NULL,
	[WhoPaidCorporationUid] [uniqueidentifier] NULL,
	[ParentDepositUid] [uniqueidentifier] NULL,
	[ReplicationAppointmentUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Deposit_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[TargetFinancialCenterUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DepositAggregate]') AND type in (N'U'))
BEGIN
CREATE TABLE [DepositAggregate](
	[DepositUid] [uniqueidentifier] NOT NULL,
	[Receipt] [money] NOT NULL,
	[ReceiptBalance] [money] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DepositSuperbill_09]') AND type in (N'U'))
BEGIN
CREATE TABLE [DepositSuperbill_09](
	[DepositSuperbillUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_DepositSuperbill_DepositSuperbillUid]  DEFAULT (newid()),
	[DepositUid] [uniqueidentifier] NOT NULL,
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_DepositSuperbill_Inactive]  DEFAULT ((0)),
	[CreateDate] [datetime] NOT NULL CONSTRAINT [DF_DepositSuperbill_CreateDate]  DEFAULT (getutcdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_DepositSuperbill_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DirectMailUser]') AND type in (N'U'))
BEGIN
CREATE TABLE [DirectMailUser](
	[DirectMailUserUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL,
	[DirectMailAddress] [varchar](255) NULL,
	[Password] [varchar](255) NULL,
	[IsUser] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[IsDefault] [bit] NOT NULL,
	[TransmissionConfigurationUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DocumentBatch]') AND type in (N'U'))
BEGIN
CREATE TABLE [DocumentBatch](
	[DocumentBatchUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_DocumentBatch_DocumentBatchUid]  DEFAULT (newid()),
	[Description] [varchar](max) NULL,
	[BatchType] [varchar](250) NULL,
	[ReportParametersXml] [xml] NULL,
	[SummaryReportIntermediateXml] [xml] NULL,
	[SummaryReportXml] [xml] NULL,
	[SummaryReportExportXml] [xml] NULL,
	[SummaryReportExportFilename] [varchar](max) NULL,
	[PatientReportBatchExportFilename] [varchar](max) NULL,
	[Aggregate_RuleNumber] [varchar](16) NULL,
	[Aggregate_PatientNumber] [int] NULL,
	[Aggregate_StartDateTime] [datetime] NULL,
	[Aggregate_TotalPatientNumber] [int] NULL,
	[Aggregate_Error] [varchar](max) NULL,
	[Individual_StartDateTime] [datetime] NULL,
	[Archive] [bit] NOT NULL CONSTRAINT [DF_DocumentBatch_Archive_1]  DEFAULT ((0)),
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_DocumentBatch_CreatedDateTime_1]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_DocumentBatch_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DocumentBatchPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [DocumentBatchPatient](
	[DocumentBatchPatientUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_DocumentBatchPatient_DocumentBatchPatientUid]  DEFAULT (newid()),
	[DocumentBatchUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[FirstName] [varchar](50) NULL,
	[LastName] [varchar](50) NULL,
	[BirthDate] [date] NULL,
	[DeathDate] [date] NULL,
	[SocialSecurityNumber] [varchar](11) NULL,
	[PCPUid] [uniqueidentifier] NULL,
	[PatientExternalId] [varchar](25) NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[RaceUid] [uniqueidentifier] NULL,
	[EthnicityUid] [uniqueidentifier] NULL,
	[InsurancePlanUid] [uniqueidentifier] NULL,
	[Zip] [varchar](50) NULL,
	[ReportDetailXml] [xml] NULL,
	[PatientReportIntermediateXml] [xml] NULL,
	[PatientReportXml] [xml] NULL,
	[PatientReportExportFilename] [varchar](max) NULL,
	[Error] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_DocumentBatchPatient_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DocumentBatchPatientMeasure]') AND type in (N'U'))
BEGIN
CREATE TABLE [DocumentBatchPatientMeasure](
	[DocumentBatchPatientMeasureUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_DocumentBatchPatientMeasure_DocumentBatchPatientMeasureUid]  DEFAULT (newid()),
	[DocumentBatchPatientUid] [uniqueidentifier] NOT NULL,
	[MeasureUid] [uniqueidentifier] NOT NULL,
	[RuleNumber] [int] NOT NULL,
	[PopulationNumber] [int] NOT NULL CONSTRAINT [DF_DocumentBatchPatientMeasure_PopulationNumber]  DEFAULT ((1)),
	[StratumNumber] [int] NOT NULL CONSTRAINT [DF_DocumentBatchPatientMeasure_StratumNumber]  DEFAULT ((1)),
	[InNumerator] [int] NOT NULL CONSTRAINT [DF_Table_1_InNumerator]  DEFAULT ((0)),
	[NumeratorNumber] [int] NOT NULL CONSTRAINT [DF_DocumentBatchPatientMeasure_NumeratorNumber]  DEFAULT ((0)),
	[InDenominator] [int] NOT NULL CONSTRAINT [DF_Table_1_InDenominator]  DEFAULT ((0)),
	[InException] [int] NOT NULL CONSTRAINT [DF_Table_1_InException]  DEFAULT ((0)),
	[InExclusion] [int] NOT NULL CONSTRAINT [DF_Table_1_InExclusion]  DEFAULT ((0)),
	[NumeratorMembershipXml] [xml] NULL,
	[PopulationMembershipXml] [xml] NULL,
	[StratumMembershipXml] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_DocumentBatchPatientMeasure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[downloadedFiles]') AND type in (N'U'))
BEGIN
CREATE TABLE [downloadedFiles](
	[downloadedFileUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[type] [varchar](20) NULL,
	[parentFileUid] [uniqueidentifier] NULL,
	[name] [varchar](50) NULL,
	[Crc] [bigint] NULL,
	[fileImage] [varbinary](max) NULL,
	[creator] [varchar](50) NULL,
	[fileTransferSessionUid] [uniqueidentifier] NULL,
	[CreateDateTime] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Archived] [bit] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DunningMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [DunningMessage](
	[DunningMessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PayPlanMessage] [varchar](300) NULL,
	[NoPayPlanMessage] [varchar](300) NULL,
	[MessageLevel] [smallint] NOT NULL,
	[MinimumUseAgeDays] [int] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[DunningMsgs]') AND type in (N'U'))
BEGIN
CREATE TABLE [DunningMsgs](
	[DunningMsgsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_DunningMsgs_DunningMsgsUid]  DEFAULT (newid()),
	[DunningMsg1] [nvarchar](150) NULL,
	[DunningMsg2] [nvarchar](150) NULL,
	[DunningMsg3] [nvarchar](150) NULL,
	[DunningMsg4] [nvarchar](150) NULL,
	[DunningMsg5] [nvarchar](150) NULL,
	[DunningMsg6] [nvarchar](150) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_DunningMsgs_LastModifiedByDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eClaimEvents]') AND type in (N'U'))
BEGIN
CREATE TABLE [eClaimEvents](
	[eClaimEventUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eClaimEvents_eClaimEventUid]  DEFAULT (newid()),
	[eClaimSessionUid] [uniqueidentifier] NOT NULL,
	[label] [varchar](50) NULL,
	[description] [varchar](255) NULL,
	[createDate] [datetime] NULL CONSTRAINT [DF_eClaimEvents_createDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eClaimEvents_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eClaimFile]') AND type in (N'U'))
BEGIN
CREATE TABLE [eClaimFile](
	[EClaimFileUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eClaimFile_EClaimFileUid]  DEFAULT (newid()),
	[SourceXML] [varchar](max) NULL,
	[Data] [varbinary](max) NULL,
	[ClaimClearingHouseUid] [uniqueidentifier] NULL,
	[PlugInUid] [uniqueidentifier] NULL,
	[CreateDate] [datetime] NULL,
	[TransmissionStatusUid] [uniqueidentifier] NULL,
	[TransmissionDate] [datetime] NULL,
	[TransmittedByUid] [uniqueidentifier] NULL,
	[ClaimCount] [int] NULL,
	[SubmitCount] [int] NULL,
	[ConfirmedClaims] [int] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eClaimFile_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eClaimFileDetails]') AND type in (N'U'))
BEGIN
CREATE TABLE [eClaimFileDetails](
	[EClaimFileDetailsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eClaimFileDetails_EClaimFileDetailsUid]  DEFAULT (newid()),
	[EClaimFileUid] [uniqueidentifier] NULL,
	[ClaimBatchUid] [uniqueidentifier] NULL,
	[Result] [varchar](50) NULL,
	[ClaimCount] [int] NULL,
	[ErrorCount] [int] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eClaimFileDetails_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eDemographicsOutbound]') AND type in (N'U'))
BEGIN
CREATE TABLE [eDemographicsOutbound](
	[DemographicsOutboundUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientExternalID] [varchar](25) NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NOT NULL,
	[SubmissionNumber] [int] NULL,
	[SubmitDate] [datetime] NULL,
	[TransmitDate] [datetime] NULL,
	[TransmitStatus] [varchar](1024) NULL,
	[TransmitStatusID] [int] NULL,
	[RequestXML] [varchar](max) NULL,
	[RequestTransaction] [varchar](max) NULL,
	[ResponseXML] [varchar](max) NULL,
	[ErrorStatus] [varchar](max) NULL,
	[ErrorValidationXML] [varchar](max) NULL,
	[TransmissionConfigurationUid] [uniqueidentifier] NULL,
	[TransmissionDataUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eEnrollmentsOutbound]') AND type in (N'U'))
BEGIN
CREATE TABLE [eEnrollmentsOutbound](
	[EnrollmentOutboundUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientExternalID] [varchar](25) NOT NULL,
	[PersonInsurancePlanUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NOT NULL,
	[SubmissionNumber] [int] NULL,
	[AdditionalParamsXML] [varchar](max) NULL,
	[SubmitDate] [datetime] NULL,
	[TransmitDate] [datetime] NULL,
	[TransmitStatus] [varchar](1024) NULL,
	[TransmitStatusID] [int] NULL,
	[RequestXML] [varchar](max) NULL,
	[RequestTransaction] [varchar](max) NULL,
	[ResponseXML] [varchar](max) NULL,
	[RequestType] [varchar](10) NULL,
	[ErrorStatus] [varchar](max) NULL,
	[ErrorValidationXML] [varchar](max) NULL,
	[TransmissionConfigurationUid] [uniqueidentifier] NULL,
	[TransmissionDataUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EligibilityRequest]') AND type in (N'U'))
BEGIN
CREATE TABLE [EligibilityRequest](
	[EligibilityRequestUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_EligibilityRequest_EligibilityRequestUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PersonInsurancePlanUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[RequestDateTime] [datetime] NOT NULL CONSTRAINT [DF_EligibilityRequest_RequestDate]  DEFAULT (getutcdate()),
	[DateOfService] [date] NOT NULL,
	[MainAccountOnly] [bit] NOT NULL CONSTRAINT [DF_EligibilityRequest_MainAccountOnly]  DEFAULT ((1)),
	[TransmitDateTime] [datetime] NULL,
	[TransmitStatus] [varchar](50) NULL,
	[SubmissionID] [int] NULL,
	[RequestXML] [varchar](max) NULL,
	[RequestX12] [varchar](max) NULL,
	[ResponseXML] [varchar](max) NULL,
	[ResponseX12] [varchar](max) NULL,
	[Error] [varchar](max) NULL,
	[EligibilityStatusUid] [uniqueidentifier] NULL,
	[CopayPrimary] [money] NULL,
	[CopaySpecialist] [money] NULL,
	[CopayOther] [money] NULL,
	[InNetworkCoinsurance] [decimal](18, 0) NULL,
	[InNetworkDeductible] [money] NULL,
	[InNetworkRemaining] [money] NULL,
	[InNetworkMet] [money] NULL,
	[OutNetworkCoinsurance] [decimal](18, 0) NULL,
	[OutNetworkDeductible] [money] NULL,
	[OutNetworkRemaining] [money] NULL,
	[OutNetworkMet] [money] NULL,
	[EligibilityEffectiveDate] [date] NULL,
	[EligibilityExpirationDate] [date] NULL,
	[EligibilityNotes] [varchar](8000) NULL,
	[RequestType] [varchar](10) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_EligibilityRequest_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ResponseHTML] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EmailResponse]') AND type in (N'U'))
BEGIN
CREATE TABLE [EmailResponse](
	[EmailResponseUid] [uniqueidentifier] NOT NULL,
	[EmailTrackingUid] [uniqueidentifier] NOT NULL,
	[ResponseContent] [varchar](max) NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EmailStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [EmailStatus](
	[EmailStatusUid] [uniqueidentifier] NOT NULL,
	[EmailTrackingUid] [uniqueidentifier] NULL,
	[EmailAddress] [varchar](255) NOT NULL,
	[Status] [varchar](50) NOT NULL,
	[StatusExtension] [varchar](50) NULL,
	[Note] [varchar](255) NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EmailStatusBlock]') AND type in (N'U'))
BEGIN
CREATE TABLE [EmailStatusBlock](
	[EmailStatusBlockUid] [uniqueidentifier] NOT NULL,
	[EmailAddress] [varchar](255) NOT NULL,
	[BlockToken] [varchar](25) NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EmailTracking]') AND type in (N'U'))
BEGIN
CREATE TABLE [EmailTracking](
	[EmailTrackingUid] [uniqueidentifier] NOT NULL,
	[ListenerAqn] [varchar](512) NOT NULL,
	[ListenerArgs] [varchar](max) NOT NULL,
	[SubjectExtract] [varchar](50) NULL,
	[BodyExtract] [varchar](50) NULL,
	[RequestContent] [varchar](max) NOT NULL,
	[EmailName] [varchar](255) NOT NULL,
	[EmailAddress] [varchar](255) NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EmailUnsubscribeGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [EmailUnsubscribeGroup](
	[EmailUnsubscribeGroupUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[Description] [varchar](255) NOT NULL,
	[Type] [tinyint] NOT NULL CONSTRAINT [DF_EmailUnsubscribeGroup_InternalId]  DEFAULT ((0)),
	[ReferenceId] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_EmailUnsubscribeGroup_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_EmailUnsubscribeGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_EmailUnsubscribeGroup_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EMMapping]') AND type in (N'U'))
BEGIN
CREATE TABLE [EMMapping](
	[EMMappingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_EMMapping_EMMappingUid]  DEFAULT (newid()),
	[EMKeyComponentUid] [uniqueidentifier] NULL,
	[EMExaminationDescriptionUid] [uniqueidentifier] NULL,
	[EMSystemBodyAreaUid] [uniqueidentifier] NULL,
	[EMBulletUid] [uniqueidentifier] NULL,
	[originalExaminationUid] [uniqueidentifier] NULL,
	[originalSystemBodyAreaUid] [uniqueidentifier] NULL,
	[originalPESystemUid] [uniqueidentifier] NULL,
	[originalBulletUid] [uniqueidentifier] NULL,
	[originalPEDescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_EMMapping_UserDefined]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_EMMapping_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Employer]') AND type in (N'U'))
BEGIN
CREATE TABLE [Employer](
	[CorporationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Employer_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Employer_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAClaimAdjustment]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAClaimAdjustment](
	[ERAClaimAdjustmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAClaimPaymentInfoUid] [uniqueidentifier] NOT NULL,
	[GroupCode] [varchar](2) NOT NULL,
	[GroupCodeERACodeUid] [uniqueidentifier] NULL,
	[ReasonCode] [varchar](5) NOT NULL,
	[ReasonCodeERACodeUid] [uniqueidentifier] NULL,
	[Amount] [money] NOT NULL,
	[Quantity] [decimal](18, 0) NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAClaimAmount]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAClaimAmount](
	[ERAClaimAmountUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAClaimPaymentInfoUid] [uniqueidentifier] NOT NULL,
	[QualifierCode] [varchar](3) NOT NULL,
	[Amount] [money] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAClaimEntity]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAClaimEntity](
	[ERAClaimEntityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAClaimPaymentInfoUid] [uniqueidentifier] NOT NULL,
	[IdentifierCode] [varchar](3) NOT NULL,
	[TypeQualifier] [char](1) NOT NULL,
	[LastName] [varchar](60) NULL,
	[FirstName] [varchar](35) NULL,
	[MiddleName] [varchar](25) NULL,
	[Suffix] [varchar](50) NULL,
	[IDCodeQualifier] [varchar](3) NULL,
	[IDCode] [varchar](80) NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAClaimIdentification]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAClaimIdentification](
	[ERAClaimIdentificationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAClaimPaymentInfoUid] [uniqueidentifier] NOT NULL,
	[ReferenceIDQualifier] [varchar](3) NOT NULL,
	[ReferenceID] [varchar](30) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAClaimPaymentInfo]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAClaimPaymentInfo](
	[ERAClaimPaymentInfoUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAHeaderUid] [uniqueidentifier] NOT NULL,
	[ClaimSubmitterID] [varchar](38) NOT NULL,
	[ClaimStatusCode] [varchar](2) NOT NULL,
	[TotalClaimChargeAmount] [money] NOT NULL,
	[ClaimPaymentAmount] [money] NOT NULL,
	[PatientResponsibleAmount] [money] NULL,
	[ClaimFilingIndicatorCode] [varchar](2) NOT NULL,
	[PayerClaimControlNumber] [varchar](50) NULL,
	[FacilityTypeCode] [varchar](2) NULL,
	[ClaimFrequencyCode] [char](1) NULL,
	[DRGCode] [varchar](4) NULL,
	[DRGWeight] [decimal](18, 0) NULL,
	[DischargeFraction] [decimal](18, 0) NULL,
	[ServiceStartDate] [date] NULL,
	[ServiceEndDate] [date] NULL,
	[ReimbursementRate] [decimal](18, 0) NULL,
	[HCPCSPayableAmount] [money] NULL,
	[MOARemarkCode1] [varchar](30) NULL,
	[MOARemarkCode2] [varchar](30) NULL,
	[MOARemarkCode3] [varchar](30) NULL,
	[MOARemarkCode4] [varchar](30) NULL,
	[MOARemarkCode5] [varchar](30) NULL,
	[ESRDPaymentAmount] [money] NULL,
	[NonpayableProfessionalComponentAmount] [money] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[SuperbillUidOldPM] [uniqueidentifier] NULL,
	[RuleStatus] [int] NULL,
	[ErrorMessage] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[TransactionUid] [uniqueidentifier] NULL,
	[ERAOrder] [int] NULL,
	[ProcessStatus] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAClaimPaymentInfoError]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAClaimPaymentInfoError](
	[ERAClaimPaymentInfoErrorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAClaimPaymentInfoUid] [uniqueidentifier] NOT NULL,
	[ErrorText] [varchar](max) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Sequence] [bigint] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAFunctionalGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAFunctionalGroup](
	[ERAFunctionalGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAInterchangeControlUid] [uniqueidentifier] NOT NULL,
	[SenderCode] [varchar](15) NOT NULL,
	[ReceiverCode] [varchar](15) NOT NULL,
	[DateTime] [datetime] NOT NULL,
	[ControlNumber] [int] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAHeader]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAHeader](
	[ERAHeaderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERATransactionSetUid] [uniqueidentifier] NOT NULL,
	[AssignedNumber] [varchar](6) NOT NULL,
	[ReferenceID] [varchar](30) NULL,
	[FacilityTypeCode] [varchar](2) NULL,
	[FiscalPeriodDate] [date] NULL,
	[TotalClaimCount] [int] NULL,
	[TotalClaimChargeAmount] [money] NULL,
	[TotalCoveredChargeAmount] [money] NULL,
	[TotalNoncoveredChargeAmount] [money] NULL,
	[TotalDeniedChargeAmount] [money] NULL,
	[TotalProviderPaymentAmount] [money] NULL,
	[TotalInterestAmount] [money] NULL,
	[TotalContractualAdjustmentAmount] [money] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAHealthCareRemarkCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAHealthCareRemarkCode](
	[ERAHealthCareRemarkCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAServicePaymentInfoUid] [uniqueidentifier] NOT NULL,
	[CodeListQualifierCode] [varchar](3) NOT NULL,
	[IndustryCode] [varchar](30) NOT NULL,
	[IndustryCodeERACodeUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAInterchangeControl]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAInterchangeControl](
	[ERAInterchangeControlUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SenderID] [varchar](15) NOT NULL,
	[ReceiverID] [varchar](15) NOT NULL,
	[DateTime] [datetime] NOT NULL,
	[UsageIndicator] [char](1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[RawMessage] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAProviderAdjustment]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAProviderAdjustment](
	[ERAProviderAdjustmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERATransactionSetUid] [uniqueidentifier] NOT NULL,
	[ProviderID] [varchar](30) NOT NULL,
	[FiscalPeriodDate] [date] NOT NULL,
	[ReasonCode1] [char](2) NOT NULL,
	[Identifier1] [varchar](50) NULL,
	[Amount1] [money] NOT NULL,
	[ReasonCode2] [char](2) NULL,
	[Identifier2] [varchar](50) NULL,
	[Amount2] [money] NULL,
	[ReasonCode3] [char](2) NULL,
	[Identifier3] [varchar](50) NULL,
	[Amount3] [money] NULL,
	[ReasonCode4] [char](2) NULL,
	[Identifier4] [varchar](50) NULL,
	[Amount4] [money] NULL,
	[ReasonCode5] [char](2) NULL,
	[Identifier5] [varchar](50) NULL,
	[Amount5] [money] NULL,
	[ReasonCode6] [char](2) NULL,
	[Identifier6] [varchar](50) NULL,
	[Amount6] [money] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAServiceAdjustment]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAServiceAdjustment](
	[ERAServiceAdjustmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAServicePaymentInfoUid] [uniqueidentifier] NOT NULL,
	[GroupCode] [varchar](2) NOT NULL,
	[GroupCodeERACodeUid] [uniqueidentifier] NULL,
	[ReasonCode] [varchar](5) NOT NULL,
	[ReasonCodeERACodeUid] [uniqueidentifier] NULL,
	[Amount] [money] NOT NULL,
	[Quantity] [decimal](18, 0) NULL,
	[CreditUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LedgerDetailUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAServiceAdjustmentError]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAServiceAdjustmentError](
	[ERAServiceAdjustmentErrorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAServiceAdjustmentUid] [uniqueidentifier] NOT NULL,
	[ErrorText] [varchar](max) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Sequence] [bigint] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAServiceAmount]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAServiceAmount](
	[ERAServiceAmountUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAServicePaymentInfoUid] [uniqueidentifier] NOT NULL,
	[QualifierCode] [varchar](3) NOT NULL,
	[QualiferCodeERACodeUid] [uniqueidentifier] NULL,
	[Amount] [money] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[CreditUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAServiceAmountError]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAServiceAmountError](
	[ERAServiceAmountErrorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAServiceAmountUid] [uniqueidentifier] NOT NULL,
	[ErrorText] [varchar](max) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Sequence] [bigint] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAServiceIdentification]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAServiceIdentification](
	[ERAServiceIdentificationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAServicePaymentInfoUid] [uniqueidentifier] NOT NULL,
	[ReferenceIDQualifier] [varchar](3) NOT NULL,
	[ReferenceID] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAServicePaymentInfo]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAServicePaymentInfo](
	[ERAServicePaymentInfoUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAClaimPaymentInfoUid] [uniqueidentifier] NOT NULL,
	[ProcedureCodeQualifier] [char](2) NULL,
	[ProcedureCode] [varchar](48) NULL,
	[ProcedureCodeModifier1] [char](2) NULL,
	[ProcedureCodeModifier2] [char](2) NULL,
	[ProcedureCodeModifier3] [char](2) NULL,
	[ProcedureCodeModifier4] [char](2) NULL,
	[ProcedureDescription] [varchar](80) NULL,
	[BilledAmount] [money] NULL,
	[ProviderPaidAmount] [money] NULL,
	[Quantity] [decimal](18, 0) NULL,
	[SubmittedProcedureCodeQualifier] [char](2) NULL,
	[SubmitedProcedureCode] [varchar](48) NULL,
	[SubmittedProcedureCodeModifier1] [char](2) NULL,
	[SubmittedProcedureCodeModifier2] [char](2) NULL,
	[SubmittedProcedureCodeModifier3] [char](2) NULL,
	[SubmittedProcedureCodeModifier4] [char](2) NULL,
	[SubmittedProcedureDescription] [varchar](80) NULL,
	[SubmittedQuantity] [decimal](18, 0) NULL,
	[ServiceStartDate] [date] NULL,
	[ServiceEndDate] [date] NULL,
	[ARContextUid] [uniqueidentifier] NULL,
	[CreditUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[SuperbillProcedureUid] [uniqueidentifier] NULL,
	[LedgerDetailUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAServicePaymentInfoError]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAServicePaymentInfoError](
	[ERAServicePaymentInfoErrorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAServicePaymentInfoUid] [uniqueidentifier] NOT NULL,
	[ErrorText] [varchar](max) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Sequence] [bigint] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERAServiceRemark]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERAServiceRemark](
	[ERAServiceRemarkUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAServicePaymentInfoUid] [uniqueidentifier] NOT NULL,
	[QualifierCode] [varchar](3) NOT NULL,
	[RemarkCode] [varchar](30) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERATransactionSet]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERATransactionSet](
	[ERATransactionSetUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAFunctionalGroupUid] [uniqueidentifier] NOT NULL,
	[ControlNumber] [varchar](9) NOT NULL,
	[TransactionHandlingCode] [varchar](2) NOT NULL,
	[TotalMonetaryAmount] [money] NOT NULL,
	[CreditDebitFlagCode] [char](1) NOT NULL,
	[PaymentMethodCode] [char](3) NOT NULL,
	[CheckIssueDate] [date] NOT NULL,
	[TraceTypeCode] [varchar](2) NOT NULL,
	[ReferenceID] [varchar](50) NOT NULL,
	[OriginatingCompanyIdentifier] [char](10) NOT NULL,
	[ProductionDate] [date] NULL,
	[PayerName] [varchar](60) NULL,
	[PayerID] [varchar](80) NULL,
	[PayerAddress] [xml](CONTENT [Address]) NULL,
	[PayeeName] [varchar](60) NULL,
	[PayeeIDCodeQualifier] [varchar](2) NULL,
	[PayeeID] [varchar](80) NULL,
	[PayeeAddress] [xml](CONTENT [Address]) NULL,
	[RuleStatus] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Archived] [bit] NULL,
	[ProcessStatus] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERATransactionSetDeposit]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERATransactionSetDeposit](
	[ERATransactionSetDepositUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERATransactionSetUid] [uniqueidentifier] NOT NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[PayerUid] [uniqueidentifier] NULL,
	[MonetaryAmount] [money] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ERATransactionSetError]') AND type in (N'U'))
BEGIN
CREATE TABLE [ERATransactionSetError](
	[ERATransactionSetErrorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERATransactionSetUid] [uniqueidentifier] NOT NULL,
	[ErrorText] [varchar](max) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Sequence] [bigint] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eReportDetails]') AND type in (N'U'))
BEGIN
CREATE TABLE [eReportDetails](
	[eReportDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eReportDetails_eReportDetailUid]  DEFAULT (newid()),
	[importDate] [datetime] NULL,
	[messageProcessDate] [datetime] NULL,
	[status] [varchar](50) NULL,
	[reportNumber] [varchar](10) NULL,
	[totalCharge] [money] NULL,
	[totalClaims] [int] NULL,
	[acceptedCharges] [money] NULL,
	[acceptedClaims] [int] NULL,
	[SuperbillNoteChanges] [varchar](max) NULL,
	[ClaimBatchUid] [uniqueidentifier] NULL,
	[eReportFileUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eReportDetails_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eReportFiles]') AND type in (N'U'))
BEGIN
CREATE TABLE [eReportFiles](
	[eReportFileUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[createDate] [datetime] NULL,
	[fileImage] [varbinary](max) NULL,
	[status] [varchar](50) NULL,
	[downloadedFileUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eReportRows]') AND type in (N'U'))
BEGIN
CREATE TABLE [eReportRows](
	[eReportRowUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eReportRows_eReportRowUid]  DEFAULT (newid()),
	[eReportDetailUid] [uniqueidentifier] NOT NULL,
	[ClaimReportStatusUid] [uniqueidentifier] NULL,
	[providerUid] [varchar](50) NULL,
	[superbillUid] [uniqueidentifier] NULL,
	[patientUid] [uniqueidentifier] NULL,
	[insuredUid] [uniqueidentifier] NULL,
	[InsuranceCarrierUid] [uniqueidentifier] NULL,
	[providerName] [varchar](50) NULL,
	[payerName] [varchar](50) NULL,
	[claimProcessDate] [datetime] NULL,
	[claimID] [varchar](20) NULL,
	[claimSequenceID] [int] NULL,
	[claimType] [varchar](5) NULL,
	[patientAccountNumber] [varchar](20) NULL,
	[patientLastName] [varchar](50) NULL,
	[patientFirstName] [varchar](25) NULL,
	[patientBirthDate] [date] NULL,
	[patientPhone] [varchar](20) NULL,
	[insuredIDNumber] [varchar](20) NULL,
	[insuredGroupNumber] [varchar](20) NULL,
	[insuredLastName] [varchar](50) NULL,
	[insuredFirstName] [varchar](20) NULL,
	[primaryDiagnosisCode] [varchar](10) NULL,
	[serviceLine1FromDate] [date] NULL,
	[serviceLine1ToDate] [date] NULL,
	[serviceLine1PlaceOfService] [varchar](2) NULL,
	[primaryProcedureCode] [varchar](10) NULL,
	[serviceLine1Modifier1] [varchar](5) NULL,
	[serviceLine1Units] [varchar](5) NULL,
	[serviceLine1Charge] [money] NULL,
	[renderingDoctorUid] [varchar](50) NULL,
	[renderingPhysicianName] [varchar](50) NULL,
	[providerIDNumber] [varchar](20) NULL,
	[payerClaimControlNumber] [varchar](30) NULL,
	[payerPaidAmount] [money] NULL,
	[updateDate] [date] NULL,
	[errorDescription] [varchar](2500) NULL,
	[additionalClaimInformation] [varchar](255) NULL,
	[correspondenceContact] [varchar](50) NULL,
	[correspondencePhone] [varchar](20) NULL,
	[correspondenceName] [varchar](50) NULL,
	[correspondenceAddress] [varchar](50) NULL,
	[correspondenceCity] [varchar](30) NULL,
	[correspondenceState] [varchar](2) NULL,
	[correspondenceZip] [varchar](9) NULL,
	[clientClaimControlNumber] [varchar](30) NULL,
	[transmissionTrackingNumber] [varchar](25) NULL,
	[formType] [varchar](1) NULL,
	[perSeErrorCode] [varchar](25) NULL,
	[errorFlag] [varchar](1) NULL,
	[epayerUid] [uniqueidentifier] NULL,
	[ClaimPayerId] [varchar](25) NULL,
	[new_eReportRowUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eReportRows_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[followUp] [bit] NOT NULL CONSTRAINT [DF_eReportRows_followUp]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ErrorReport]') AND type in (N'U'))
BEGIN
CREATE TABLE [ErrorReport](
	[ErrorReportUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Version] [varchar](24) NULL,
	[UserName] [varchar](100) NULL,
	[ComputerName] [varchar](100) NULL,
	[Message] [varchar](max) NULL,
	[Text] [varchar](max) NULL,
	[ScreenImage] [varbinary](max) NULL,
	[Notes] [varchar](max) NULL,
	[Uploaded] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[TextXML] [xml] NULL,
	[Origin] [int] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxBenefitsDownload]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxBenefitsDownload](
	[PatientUid] [uniqueidentifier] NOT NULL,
	[RXBenefitsMessageID] [varchar](35) NULL,
	[RXBenefitsRequestProviderUid] [uniqueidentifier] NULL,
	[RXBenefitsRequestDate] [datetime] NULL,
	[RXBenefitsDownloadStatusUid] [uniqueidentifier] NULL,
	[RXBenefitsRequests] [int] NULL,
	[RXBenefitsDownloadResponse] [varchar](max) NULL,
	[eMedHXClaimDataRequestProviderUid] [uniqueidentifier] NULL,
	[eMedHXClaimDataMessageID] [varchar](35) NULL,
	[eMedHXClaimDataRequestDate] [datetime] NULL,
	[eMedHXClaimDataRequestDateFrom] [dbo].[PRMDateTimeUnconverted] NULL,
	[eMedHXClaimDataRequestDateTo] [dbo].[PRMDateTimeUnconverted] NULL,
	[eMedHXClaimDataDownloadStatusUid] [uniqueidentifier] NULL,
	[eMedHXClaimDataDownloadResponse] [varchar](max) NULL,
	[eMedHXClaimDataRequests] [int] NULL,
	[eMedHXFillDataRequestProviderUid] [uniqueidentifier] NULL,
	[eMedHXFillDataMessageID] [varchar](35) NULL,
	[eMedHXFillDataRequestDate] [datetime] NULL,
	[eMedHXFillDataRequestDateFrom] [dbo].[PRMDateTimeUnconverted] NULL,
	[eMedHXFillDataRequestDateTo] [dbo].[PRMDateTimeUnconverted] NULL,
	[eMedHXFillDataDownloadStatusUid] [uniqueidentifier] NULL,
	[eMedHXFillDataDownloadResponse] [varchar](max) NULL,
	[eMedHXFillDataRequests] [int] NULL,
	[LastSucceedRXBenefitsDownloadedDate] [datetime] NULL,
	[LastSucceedeMedHXDownloadedDate] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxEligibilityOutbound]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxEligibilityOutbound](
	[eRxEligibilityOutboundUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eRxEligibilityOutbound_eRxEligibilityOutboundUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[eRxMessageTypeUid] [uniqueidentifier] NOT NULL,
	[eRxStatusUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[RequestDate] [dbo].[PRMDateTimeUnconverted] NOT NULL,
	[MessageXML] [varchar](max) NOT NULL,
	[MessageSent] [varchar](max) NULL,
	[SendResponse] [varchar](max) NULL,
	[Processed] [bit] NOT NULL CONSTRAINT [DF_eRxEligibilityOutbound_Processed]  DEFAULT ((0)),
	[Successful] [bit] NULL,
	[OrderNumber] [varchar](35) NULL,
	[OrderDateTime] [datetime] NULL,
	[SubmitByUid] [uniqueidentifier] NULL,
	[MessageId] [int] NULL,
	[RequestXML] [xml] NULL,
	[RequestX12] [varchar](max) NULL,
	[ResponseXML] [xml] NULL,
	[ResponseX12] [varchar](max) NULL,
	[ProcessStatus] [varchar](max) NULL,
	[TransmissionConfigurationUid] [uniqueidentifier] NULL,
	[DownloadeMedHX] [bit] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eRxEligibilityOutbound_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxInbound]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxInbound](
	[eRxInboundUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[MessageID] [varchar](35) NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[MasterPharmacyUid] [uniqueidentifier] NULL,
	[DateTimeReceived] [datetime] NOT NULL,
	[MessageXML] [varchar](max) NULL,
	[MessageReceived] [varchar](max) NOT NULL,
	[eRxMessageTypeUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Processed] [bit] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxMedicationHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxMedicationHistory](
	[eRxMedicationHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProcessStatus] [tinyint] NOT NULL,
	[MedicationXML] [varchar](max) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastDownloadedDate] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxMedicationHistoryDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxMedicationHistoryDetail](
	[eRxMedicationHistoryDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[IsDuplicate] [bit] NOT NULL,
	[IsProcessed] [bit] NOT NULL,
	[MedicationXML] [varchar](max) NOT NULL,
	[BenefitsXML] [varchar](max) NULL,
	[RelPatientMedicationUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastDownloadedDate] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxMedicationHistoryOutbound]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxMedicationHistoryOutbound](
	[eRxMedicationHistoryOutboundUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_eRxMedicationHistoryOutboundUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[eRxMessageTypeUid] [uniqueidentifier] NOT NULL,
	[eRxStatusUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientConsent] [bit] NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_PatientConsent]  DEFAULT ((0)),
	[RequestDateFrom] [dbo].[PRMDateTimeUnconverted] NULL,
	[RequestDateTo] [dbo].[PRMDateTimeUnconverted] NULL,
	[MessageXML] [varchar](max) NOT NULL,
	[MessageSent] [varchar](max) NULL,
	[SendResponse] [varchar](max) NULL,
	[Processed] [bit] NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_Processed]  DEFAULT ((0)),
	[Successful] [bit] NULL,
	[OrderNumber] [varchar](35) NULL,
	[OrderDateTime] [datetime] NULL,
	[eMedHxSource] [varchar](80) NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_eMedHxSource]  DEFAULT ('XXXXX'),
	[eMedHxRequestType] [varchar](8) NULL,
	[SubmitByUid] [uniqueidentifier] NULL,
	[PatienteRxEligibilityUid] [uniqueidentifier] NULL,
	[RelatesToMessageID] [varchar](35) NULL,
	[RequestXML] [xml] NULL,
	[RequestNCPDP] [varchar](max) NULL,
	[ResponseXML] [xml] NULL,
	[ResponseNCPDP] [varchar](max) NULL,
	[ProcessStatus] [varchar](max) NULL,
	[TransmissionConfigurationUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxOutbound]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxOutbound](
	[eRxOutboundUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eRxOutbound_eRxOutboundUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[PharmacyUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[RelVisitMedicationUid] [uniqueidentifier] NULL,
	[SIGDetailUid] [uniqueidentifier] NULL,
	[eRxMessageTypeUid] [uniqueidentifier] NOT NULL,
	[MessageXML] [varchar](max) NOT NULL,
	[MessageSent] [varchar](max) NULL,
	[SendResponse] [varchar](max) NULL,
	[Processed] [bit] NOT NULL CONSTRAINT [DF_eRxOutbound_Processed]  DEFAULT ((0)),
	[Successful] [bit] NULL,
	[RelatesToMessageID] [varchar](35) NULL,
	[SubmitByUid] [uniqueidentifier] NULL,
	[RequestXML] [xml] NULL,
	[RequestNCPDP] [varchar](max) NULL,
	[ResponseXML] [xml] NULL,
	[ResponseNCPDP] [varchar](max) NULL,
	[ProcessStatus] [varchar](max) NULL,
	[TransmissionConfigurationUid] [uniqueidentifier] NULL,
	[OrderNumber] [varchar](35) NULL,
	[OrderDateTime] [datetime] NULL,
	[DigitalSignatureDigestValue] [varchar](max) NULL,
	[DigitalSignatureSignatureValue] [varchar](max) NULL,
	[DigitalSignatureX509Data] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eRxOutbound_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxProcessStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxProcessStatus](
	[eRxProcessStatusUid] [uniqueidentifier] NOT NULL,
	[TransmissionOutboundUid] [uniqueidentifier] NOT NULL,
	[Successful] [bit] NOT NULL,
	[ProcessStatus] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxPRVBRDOutbound]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxPRVBRDOutbound](
	[eRxPRVBRDOutboundUid] [uniqueidentifier] NOT NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[eRxMessageTypeUid] [uniqueidentifier] NOT NULL,
	[MessageID] [varchar](50) NULL,
	[MessageXML] [varchar](max) NOT NULL,
	[SendResponse] [varchar](max) NULL,
	[Processed] [bit] NOT NULL,
	[Successful] [bit] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[TransmissionConfigurationUid] [uniqueidentifier] NULL,
	[RelatesToMessageID] [varchar](max) NULL,
	[RequestType] [varchar](50) NULL,
	[RequestXML] [xml] NULL,
	[ProviderDirectoryUid] [uniqueidentifier] NULL,
	[PharmacyUid] [uniqueidentifier] NULL,
	[SearchServiceLevel] [int] NULL,
	[SearchProviderType] [varchar](10) NULL,
	[SearchIdentifier] [varchar](255) NULL,
	[SearchIdentifierType] [varchar](50) NULL,
	[SearchAddressLine1] [varchar](100) NULL,
	[SearchAddressLine2] [varchar](100) NULL,
	[SearchCity] [varchar](100) NULL,
	[SearchState] [varchar](100) NULL,
	[SearchZipCode] [varchar](100) NULL,
	[OrganizationDirectoryUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ExternalDataReporting]') AND type in (N'U'))
BEGIN
CREATE TABLE [ExternalDataReporting](
	[ExternalDataReportingUid] [uniqueidentifier] NOT NULL,
	[ReportInstanceUid] [uniqueidentifier] NOT NULL,
	[InsertSequence] [int] NOT NULL,
	[XmlData] [xml] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EZPAYBINTEST]') AND type in (N'U'))
BEGIN
CREATE TABLE [EZPAYBINTEST](
	[BinTestUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_EZPAYBINTEST_BinTestUid]  DEFAULT (newid()),
	[RECNO] [int] NOT NULL,
	[BINLO] [int] NULL,
	[BINHI] [int] NULL,
	[CARDTYPE] [varchar](2) NULL,
	[LEN] [int] NULL,
	[CATEGORY] [varchar](16) NULL,
	[ENABLED] [int] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_EZPAYBINTEST_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_EZPAYBINTEST_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EZPAYCONNECTION_SETTINGS]') AND type in (N'U'))
BEGIN
CREATE TABLE [EZPAYCONNECTION_SETTINGS](
	[ConnectionSettingsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_EZPAYCONNECTION_SETTINGS_ConnectionSettingsUid]  DEFAULT (newid()),
	[PARAMETER] [varchar](50) NOT NULL,
	[VALUE] [varchar](50) NULL,
	[OPTIONS] [varchar](50) NULL,
	[DESCRIPTION] [varchar](255) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_EZPAYCONNECTION_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_EZPAYCONNECTION_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EZPAYERROR_CODES]') AND type in (N'U'))
BEGIN
CREATE TABLE [EZPAYERROR_CODES](
	[ErrorCodesUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_EZPAYERROR_CODES_ErrorCodesUid]  DEFAULT (newid()),
	[ERROR_CODE] [nchar](3) NOT NULL,
	[MESSAGE] [nchar](100) NULL,
	[EXPLANATION] [nchar](255) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_EZPAYERROR_CODES_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_EZPAYERROR_CODES_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EZPAYMERCHANT_SETTINGS]') AND type in (N'U'))
BEGIN
CREATE TABLE [EZPAYMERCHANT_SETTINGS](
	[MerchantSettingsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_EZPAYMERCHANT_SETTINGS_MerchantSettingsUid]  DEFAULT (newid()),
	[MERCH_REC] [int] NOT NULL,
	[CLIENTNUM] [varchar](6) NULL,
	[MERCHNUMBER] [varchar](12) NULL,
	[MERCHDESCR] [varchar](50) NULL,
	[USERNAME] [varchar](16) NULL,
	[PASSWORD] [varchar](16) NULL,
	[INDUSTRYCODE] [varchar](1) NULL,
	[TERMINALID] [varchar](6) NULL,
	[REGKEY] [varchar](19) NULL,
	[MID] [varchar](12) NULL,
	[MIDVIMC] [varchar](15) NULL,
	[MIDDS] [varchar](15) NULL,
	[MIDAE] [varchar](15) NULL,
	[BANKID] [varchar](12) NULL,
	[DOES_ACH] [bit] NULL CONSTRAINT [DF_MERCHANT_SETTINGS_DOES_ACH]  DEFAULT ((0)),
	[ACH_USERNAME] [varchar](20) NULL,
	[ACH_PASSWORD] [varchar](20) NULL,
	[DOES_GIFT] [bit] NULL CONSTRAINT [DF_MERCHANT_SETTINGS_DOES_GIFT]  DEFAULT ((0)),
	[GIFT_USERNAME] [varchar](20) NULL,
	[GIFT_PASSWORD] [varchar](20) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_EZPAYMERCHANT_SETTINGS_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_EZPAYMERCHANT_SETTINGS_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_EZPAYMERCHANT_SETTINGS_Inactive]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EZPAYSETTLEMENT_DETAILS]') AND type in (N'U'))
BEGIN
CREATE TABLE [EZPAYSETTLEMENT_DETAILS](
	[SettlementDetailsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RECNO] [int] NOT NULL,
	[SEQ_NO] [varchar](50) NULL,
	[ACCT_LAST_NAME] [varchar](50) NULL,
	[ACCT_FIRST_NAME] [varchar](50) NULL,
	[ACCT_NO] [varchar](16) NULL,
	[EXP_DATE] [varchar](5) NULL,
	[AMOUNT] [varchar](10) NULL,
	[TXN_DATE] [varchar](6) NULL,
	[TXN_TIME] [varchar](6) NULL,
	[TXN_CODE] [varchar](50) NULL,
	[AUTH_RESP] [varchar](4000) NULL,
	[AUTH_MSG] [varchar](4000) NULL,
	[BATCH_NO] [varchar](50) NULL,
	[CARD_TYPE] [varchar](2) NULL,
	[SALE_TAX] [varchar](9) NULL,
	[SURCHARGE] [varchar](8) NULL,
	[CASHBACK] [varchar](9) NULL,
	[CUST_LAST_NAME] [varchar](50) NULL,
	[CUST_FIRST_NAME] [varchar](50) NULL,
	[STATUS] [varchar](10) NULL,
	[REF_ID] [varchar](20) NULL,
	[MERCH_REC] [int] NULL,
	[ACCOUNTID] [int] NULL,
	[SERVER] [varchar](6) NULL,
	[TIP] [varchar](9) NULL,
	[IV] [varchar](255) NULL,
	[DATE_LAST_CHANGED] [datetime] NULL,
	[LAST_CHANGED_BY] [varchar](16) NULL,
	[PAYMENT_TYPE] [varchar](1) NULL,
	[ACCOUNT_NO] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[EZPAYSETTLEMENT_HISTORY]') AND type in (N'U'))
BEGIN
CREATE TABLE [EZPAYSETTLEMENT_HISTORY](
	[SettlementHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RECNO] [bigint] NOT NULL,
	[BATCH_NO] [varchar](20) NULL,
	[SETTLEMENT_RESP] [varchar](4000) NULL,
	[SETTLEMENT_DATE] [datetime] NULL,
	[SETTLEMENT_STATUS] [varchar](20) NULL,
	[SETTLEMENT_AMOUNT] [numeric](18, 2) NULL,
	[LAST_CHANGED_DATE] [datetime] NULL,
	[LAST_CHANGED_BY] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FaxCoverSheetItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [FaxCoverSheetItem](
	[FaxCoverSheetItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FaxCoverSheetGroupUid] [uniqueidentifier] NULL,
	[FaxCoverSheetUid] [uniqueidentifier] NULL,
	[DefaultCoverSheet] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FaxQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [FaxQueue](
	[FaxQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[TransactionID] [decimal](18, 0) NULL,
	[StatusID] [int] NULL,
	[Submitted] [bit] NULL,
	[Message] [varchar](max) NULL,
	[StatusDetail] [varchar](max) NULL,
	[FaxNumber] [varchar](15) NULL,
	[RetryFaxNumber] [varchar](15) NULL,
	[FaxType] [varchar](10) NULL,
	[FaxSubType] [varchar](20) NULL,
	[FaxReceipientName] [varchar](500) NULL,
	[MsgReceipient] [uniqueidentifier] NULL,
	[SubmitTime] [datetime] NULL,
	[CompletionTime] [datetime] NULL,
	[Duration] [int] NULL,
	[Contact] [varchar](100) NULL,
	[JobID] [varchar](20) NULL,
	[PagesSent] [smallint] NULL,
	[PagesSubmitted] [smallint] NULL,
	[Subject] [varchar](200) NULL,
	[Units] [decimal](18, 2) NULL,
	[CostPerUnit] [decimal](18, 2) NULL,
	[PageSize] [varchar](10) NULL,
	[SenderCSID] [varchar](20) NULL,
	[RemoteCSID] [varchar](20) NULL,
	[PageOrientation] [varchar](20) NULL,
	[PageResolution] [varchar](20) NULL,
	[RenderingQuality] [varchar](20) NULL,
	[PageHeader] [varchar](500) NULL,
	[RetriesToPerform] [smallint] NULL,
	[TrialsPerformed] [smallint] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[Parameters] [varchar](max) NULL,
	[Parameters2] [varchar](500) NULL,
	[SequentialNumber] [int] NULL,
	[FaxCoverSheetUid] [uniqueidentifier] NULL,
	[XDN] [varchar](50) NULL,
	[ServicedBy] [varchar](20) NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[UserUid] [uniqueidentifier] NULL,
	[FaxServerUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FeeSchedule]') AND type in (N'U'))
BEGIN
CREATE TABLE [FeeSchedule](
	[FeeScheduleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_FeeSchedule_FeeScheduleUid]  DEFAULT (newid()),
	[Name] [varchar](50) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[IsAmountAllowed] [bit] NOT NULL CONSTRAINT [DF_FeeSchedule_IsAmountAllowed]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_FeeList_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_FeeSchedule_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_FeeList_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FeeScheduleFee]') AND type in (N'U'))
BEGIN
CREATE TABLE [FeeScheduleFee](
	[FeeScheduleFeeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_FeeScheduleFee_FeeScheduleFeeUid]  DEFAULT (newid()),
	[FeeSchedulePeriodUid] [uniqueidentifier] NOT NULL,
	[Fee] [money] NULL,
	[IsInsurancePlanPhysician] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_IsInsurancePlanPhysician]  DEFAULT ((0)),
	[IsInsurancePlanOther] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_IsInsurancePlanOther]  DEFAULT ((0)),
	[FixedCopayAmount] [money] NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[InsurancePercent] [smallint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UserDefined]  DEFAULT ((1)),
	[GlobalPeriodDays] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_FeeListFee_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MultiplyUnits] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_MultiplyUnits]  DEFAULT ((1)),
	[ContractTypeCodeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[PayorPlanSetUid] [uniqueidentifier] NULL,
	[FamilyPlanning] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_FamilyPlanning]  DEFAULT ((0)),
	[UseProcedureTaxableOption] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseProcedureTaxableOption]  DEFAULT ((1)),
	[TaxableOption] [smallint] NOT NULL CONSTRAINT [DF_FeeScheduleFee_TaxableOption]  DEFAULT ((0)),
	[UseAlternateInsurancePlan] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseAlternateInsurancePlan]  DEFAULT ((0)),
	[UseBillTimeRule] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseBillTimeRule]  DEFAULT ((0)),
	[BillTimeRuleUid] [uniqueidentifier] NULL,
	[BillTimeRuleConfigData] [varchar](max) NULL,
	[UseFeeScheduleRule] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseFeeScheduleRule_1]  DEFAULT ((0)),
	[BillFeeRuleUid] [uniqueidentifier] NULL,
	[BillFeeRuleConfigData] [varchar](max) NULL,
	[BillTransportationRuleConfigData] [varchar](max) NULL,
	[UseTransportationRule] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseTransportationRule_1]  DEFAULT ((0)),
	[DoNotClaim] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_DoNotClaim]  DEFAULT ((0)),
	[ModifierRequired] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_ModifierRequired]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FeeSchedulePeriod]') AND type in (N'U'))
BEGIN
CREATE TABLE [FeeSchedulePeriod](
	[FeeSchedulePeriodUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_FeeSchedulePeriod_FeeSchedulePeriodUid]  DEFAULT (newid()),
	[FeeScheduleUid] [uniqueidentifier] NOT NULL,
	[RVUScheduleUid] [uniqueidentifier] NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[InsurancePercent] [smallint] NULL,
	[IsAutoPopulated] [bit] NOT NULL CONSTRAINT [DF_FeeSchedulePeriod_IsAutoPopulated]  DEFAULT ((0)),
	[IsAutoUpdated] [bit] NOT NULL CONSTRAINT [DF_FeeSchedulePeriod_IsAutoUpdated]  DEFAULT ((0)),
	[AutoWriteoffOvercharge] [bit] NOT NULL CONSTRAINT [DF_FeeSchedulePeriod_AutoWriteoffOvercharge]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_FeeSchedulePeriod_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_FeeListPeriod_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[fileTransferEvents]') AND type in (N'U'))
BEGIN
CREATE TABLE [fileTransferEvents](
	[fileTransferSessionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[downloadedFileUid] [uniqueidentifier] NULL,
	[label] [varchar](50) NULL,
	[description] [varchar](255) NULL,
	[createDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FinancialCenter]') AND type in (N'U'))
BEGIN
CREATE TABLE [FinancialCenter](
	[FinancialCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_FinancialCenter_FinancialCenterUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Address] [xml](CONTENT [Address]) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Phone3] [xml](CONTENT [Phone]) NULL,
	[Phone4] [xml](CONTENT [Phone]) NULL,
	[Email1] [varchar](255) NULL,
	[Email2] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_FinancialCenter_UserDefined]  DEFAULT ((1)),
	[ARClosedThroughDate] [date] NULL,
	[SuperbillIDPrefix] [varchar](3) NULL,
	[StatementCycle] [smallint] NOT NULL CONSTRAINT [DF_FinancialCenter_StatementCycle]  DEFAULT ((30)),
	[StatementDueDays] [smallint] NOT NULL CONSTRAINT [DF_FinancialCenter_StatementDueDays]  DEFAULT ((20)),
	[DunningMsgsUid] [uniqueidentifier] NULL,
	[StatementOnNewActivity] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_StatementOnNewActivity]  DEFAULT ((0)),
	[StatementMinimumAmount] [money] NOT NULL CONSTRAINT [DF_FinancialCenter_StatementMinimumAmount]  DEFAULT ((1)),
	[InsuranceBalanceOnlySuperbills] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_InsuranceBalanceOnlySuperbills]  DEFAULT ((0)),
	[IncludeReferringProvider] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludeReferringProvider]  DEFAULT ((1)),
	[SuppressZeroDollarProcedures] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_SuppressZeroDollarProcedures]  DEFAULT ((1)),
	[IncludeLastFileDate] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludeLastFileDate]  DEFAULT ((1)),
	[StatementFooter] [varchar](325) NULL,
	[IncludePaymentReferenceNumber] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludePaymentReferenceNumber]  DEFAULT ((1)),
	[IncludeProcedureCode] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludeProcedureCode]  DEFAULT ((1)),
	[IncludeCompletedOrClosed] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludeCompletedOrClosed]  DEFAULT ((0)),
	[BlockSuperbillCreationThroughVisitDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_FinancialCenter_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[StatementModelUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormTemplate]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormTemplate](
	[FormTemplateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormTemplateTypeUid] [uniqueidentifier] NULL,
	[Name] [varchar](50) NULL,
	[FileName] [varchar](80) NULL,
	[FilePath] [varchar](100) NULL,
	[FileExt] [varchar](10) NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[SpecialtyUid] [uniqueidentifier] NULL,
	[SectionId] [int] NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HIEPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [HIEPatient](
	[HIEPatientUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[PatientId] [varchar](max) NULL,
	[DocumentList] [varchar](max) NULL,
	[DocumentListDate] [datetime] NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[HasNewDocuments] [bit] NULL,
	[ProviderUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HIEPatientDocument]') AND type in (N'U'))
BEGIN
CREATE TABLE [HIEPatientDocument](
	[HIEPatientDocumentUid] [uniqueidentifier] NOT NULL,
	[HIEPatientUid] [uniqueidentifier] NOT NULL,
	[DocumentId] [varchar](max) NOT NULL,
	[DocumentStatusUid] [uniqueidentifier] NOT NULL,
	[AttachmentUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Completed] [bit] NULL,
	[Name] [varchar](max) NULL,
	[DocumentType] [varchar](max) NULL,
	[Url] [varchar](max) NULL,
	[ProviderUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7ActionTypeObject]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7ActionTypeObject](
	[HL7ActionTypeObjectUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HL7ActionTypeObject_HL7ActionTypeObject]  DEFAULT (newid()),
	[HL7PartnerMessageUid] [uniqueidentifier] NOT NULL,
	[ActionType] [varchar](50) NOT NULL,
	[ObjectType] [varchar](50) NOT NULL,
	[ObjectUid] [uniqueidentifier] NULL,
	[MessageContextXML] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HL7ActionTypeObject_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ProcessingError] [bit] NOT NULL CONSTRAINT [DF_HL7ActionTypeObject_ProcessingError]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7IdMap]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7IdMap](
	[HL7IdMapUid] [uniqueidentifier] NOT NULL,
	[HL7PartnerUid] [uniqueidentifier] NOT NULL,
	[MapType] [varchar](50) NOT NULL,
	[ExternalId] [varchar](25) NOT NULL,
	[InternalUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7MappedField]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7MappedField](
	[HL7MappedFieldUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HL7MappedField_HL7MappedFieldUid]  DEFAULT (newid()),
	[HL7MappedSegmentUid] [uniqueidentifier] NOT NULL,
	[BusinessObject] [varchar](255) NULL,
	[Name] [varchar](200) NOT NULL,
	[DefaultXPath] [varchar](200) NULL,
	[FormatString] [varchar](50) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_HL7MappedField_Inactive]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_HL7MappedField_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[FindTableUid] [uniqueidentifier] NULL,
	[UseForMatching] [bit] NOT NULL CONSTRAINT [DF_HL7MappedField_UseForMatchinng]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_HL7MappedField_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HL7MappedField_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7MappedSegment]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7MappedSegment](
	[HL7MappedSegmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HL7MappedSegment_HL7MappedSegmentUid]  DEFAULT (newid()),
	[MessageType] [varchar](50) NULL,
	[Name] [varchar](50) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_HL7MappedSegment_Inactive]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_HL7MappedSegment_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_HL7MappedSegment_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HL7MappedSegment_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7Message]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7Message](
	[HL7MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HL7Message_HL7MessageUid]  DEFAULT (newid()),
	[HL7PartnerMessageUid] [uniqueidentifier] NULL,
	[XmlMessage] [varchar](max) NULL,
	[RawMessage] [varchar](max) NULL,
	[Status] [int] NOT NULL CONSTRAINT [DF_HL7Message_Status]  DEFAULT ((0)),
	[RetryTime] [datetime] NULL,
	[RetryMinutes] [int] NOT NULL CONSTRAINT [DF_HL7Message_RetryMinutes]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HL7Message_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageControlID] [int] NOT NULL CONSTRAINT [DF_HL7Message_MessageControlID]  DEFAULT ((0)),
	[PatientUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[OriginalAtoXml] [varchar](max) NULL,
	[OriginalObjectUid] [uniqueidentifier] NULL,
	[OriginalObjectType] [varchar](50) NULL,
	[OriginalActionType] [varchar](50) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7MessageError]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7MessageError](
	[HL7MessageErrorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HL7MessageError_HL7MessageErrorUid]  DEFAULT (newid()),
	[HL7MessageUid] [uniqueidentifier] NOT NULL,
	[Error] [varchar](max) NULL,
	[ErrorStatus] [int] NULL,
	[ErrorCode] [int] NULL,
	[MappingUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HL7MessageError_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ActionTypeObjectUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7MessageTracking]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7MessageTracking](
	[HL7MessageTrackingUid] [uniqueidentifier] NOT NULL,
	[HL7MessageUid] [uniqueidentifier] NULL,
	[HL7PartnerMessageUid] [uniqueidentifier] NOT NULL,
	[ObjectUid] [uniqueidentifier] NOT NULL,
	[ObjectType] [varchar](250) NOT NULL,
	[TransmitLocalDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7OrderSplitCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7OrderSplitCategory](
	[HL7OrderSplitCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[LabOrderCode] [varchar](30) NULL,
	[LaboratoryUid] [uniqueidentifier] NULL,
	[SplitCategory] [varchar](2) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7Partner]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7Partner](
	[HL7PartnerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HL7Partner_HL7PartnerUid]  DEFAULT (newid()),
	[Name] [varchar](50) NULL,
	[ExternalId] [varchar](25) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_Inactive]  DEFAULT ((0)),
	[TestMode] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_TestMode]  DEFAULT ((0)),
	[SendPort] [smallint] NULL,
	[SendMessageDirectory] [varchar](255) NULL,
	[ReceivePort] [smallint] NULL,
	[ReceiveMessageDirectory] [varchar](255) NULL,
	[IpAddress] [varchar](50) NULL,
	[QueueLength] [smallint] NULL,
	[SendAck] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_SendAck]  DEFAULT ((0)),
	[ReceiveAck] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_ReceiveAck]  DEFAULT ((0)),
	[AckMessage] [varchar](255) NULL,
	[SegmentSeparator] [varchar](255) NULL,
	[BeginMessagePartOfMessage] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_BeginMessagePartOfMessage]  DEFAULT ((0)),
	[BeginMessage] [varchar](255) NULL,
	[EndMessage] [varchar](255) NULL,
	[HL7XmlStructure] [varchar](max) NULL,
	[FindTableMappingXml] [varchar](max) NULL,
	[KeepAliveInterval] [int] NULL,
	[MessageTypeMapping] [varchar](1024) NULL,
	[InboundFilePrefix] [varchar](50) NULL,
	[InboundFileSuffix] [varchar](50) NULL,
	[OutboundFilePrefix] [varchar](50) NULL,
	[OutboundFileSuffix] [varchar](50) NULL,
	[FTPAddress] [varchar](50) NULL,
	[FTPUser] [varchar](50) NULL,
	[FTPPassword] [varchar](250) NULL,
	[TranslatorAQN] [varchar](512) NULL,
	[TransmissionAQN] [varchar](512) NULL,
	[TransmissionSettings] [varchar](max) NULL,
	[RestTabXML] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_HL7Partner_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HL7Partner_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[FTPDownloadPath] [varchar](255) NULL,
	[FTPInboundFilePrefix] [varchar](50) NULL,
	[FTPInboundFileSuffix] [varchar](50) NULL,
	[FTPSecureServer] [bit] NULL,
	[FTPPort] [smallint] NULL,
	[FTPProtocol] [uniqueidentifier] NULL,
	[ConsentStatus] [smallint] NOT NULL CONSTRAINT [DF_HL7Partner_ConsentStatus_1]  DEFAULT ((0)),
	[ConsentRequired] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_ConsentRequired_1]  DEFAULT ((0)),
	[ConsentSharingProtection] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_ConsentSharingProtection]  DEFAULT ((0)),
	[UseICD10] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_UseICD10]  DEFAULT ((0)),
	[SendError] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_ZeroSendError]  DEFAULT ((0)),
	[AlertUserUid] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HL7PartnerMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [HL7PartnerMessage](
	[HL7PartnerMessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HL7PartnerMessage_HL7PartnerMessageUid]  DEFAULT (newid()),
	[HL7PartnerUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_HL7PartnerMessage_Inactive]  DEFAULT ((0)),
	[MessageType] [varchar](50) NOT NULL CONSTRAINT [DF_HL7PartnerMessage_MessageType]  DEFAULT ('New'),
	[MessageEvent] [varchar](50) NULL,
	[SendFunction] [varchar](50) NULL,
	[Send] [bit] NOT NULL CONSTRAINT [DF_HL7PartnerMessage_Send]  DEFAULT ((0)),
	[Receive] [bit] NOT NULL CONSTRAINT [DF_HL7PartnerMessage_Receive]  DEFAULT ((0)),
	[FieldMappingTable] [varchar](max) NULL,
	[ElementStartPos] [tinyint] NULL,
	[ProcessorAQN] [varchar](512) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_HL7PartnerMessage_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HL7PartnerMessage_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[OrderActionTemplateXml] [xml] NULL,
	[FormEditAQN] [varchar](1024) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HMRuleObservationTest]') AND type in (N'U'))
BEGIN
CREATE TABLE [HMRuleObservationTest](
	[HMRuleObservationTestUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HMRuleObservationTest_HMRuleObservationTestUid]  DEFAULT (newid()),
	[HMRuleUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_HMRuleObservationTest_DisplayOrder]  DEFAULT ((0)),
	[Type] [int] NOT NULL,
	[Subtype] [varchar](50) NOT NULL,
	[ObservationItemUid] [uniqueidentifier] NULL,
	[StringExpression] [varchar](max) NULL,
	[StringValue] [varchar](max) NULL,
	[DecimalValue1] [decimal](14, 6) NULL,
	[DecimalValue2] [decimal](14, 6) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_HMRuleObservationTest_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HMRuleObservationTest_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HmUserStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [HmUserStatus](
	[HmUserStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[HmUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[HospitalRound]') AND type in (N'U'))
BEGIN
CREATE TABLE [HospitalRound](
	[HospitalRoundUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HospitalRound_HospitalRoundUid]  DEFAULT (newid()),
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Location] [varchar](500) NULL,
	[AdmitDate] [date] NULL,
	[DischargeDate] [date] NULL,
	[ExternalTypeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_HospitalRound_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HospitalRound_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImmunizationHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImmunizationHistory](
	[ImmunizationHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ImmunizationHistory_ImmunizationHistoryUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VaccineUid] [uniqueidentifier] NULL,
	[VaccineName] [varchar](255) NULL,
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[TypeofVaccineName] [varchar](255) NULL,
	[VaccineDose] [varchar](50) NULL,
	[VaccineUnits] [varchar](60) NULL,
	[AdministeredDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[AdministeredDateName] [varchar](255) NULL,
	[VaccineSiteUid] [uniqueidentifier] NULL,
	[VaccineSiteName] [varchar](255) NULL,
	[VaccineRouteUid] [uniqueidentifier] NULL,
	[VaccineRouteName] [varchar](255) NULL,
	[VaccineFundingSourceUid] [uniqueidentifier] NULL,
	[VaccineFundingSourceName] [varchar](255) NULL,
	[VFCEligibilityUid] [uniqueidentifier] NULL,
	[DateOnVIS] [date] NULL,
	[DateOnVISName] [varchar](255) NULL,
	[ExpirationDate] [date] NULL,
	[ExpirationDateName] [varchar](255) NULL,
	[VaccineMfrUid] [uniqueidentifier] NULL,
	[VaccineMfrName] [varchar](255) NULL,
	[VaccineLotNo] [varchar](255) NULL,
	[DateVISGiven] [date] NULL,
	[DateVISGivenName] [varchar](255) NULL,
	[Initials] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[VaccinatorUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ImmzHistorySourceUid] [uniqueidentifier] NULL,
	[ImmzReminderRecallUid] [uniqueidentifier] NULL,
	[ImmzRefusalUid] [uniqueidentifier] NULL,
	[ImmzCompletionUid] [uniqueidentifier] NULL,
	[ImmzReactionUid] [uniqueidentifier] NULL,
	[PatientRefused] [bit] NOT NULL CONSTRAINT [DF_ImmunizationHistory_PatientRefused_1]  DEFAULT ((0)),
	[ImedicaAccessionNumber] [varchar](25) NULL,
	[OriginCreateTime] [datetime] NULL,
	[InactiveDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_ImmunizationHistory_IsDelete_1]  DEFAULT ((0)),
	[HistoryAdministeredDate] [xml](CONTENT [TimeFrame]) NULL,
	[HistoryAdministeredFuzzyDate] [date] NULL,
	[VXUSentDateTime] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ImmunizationHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImmzCPII]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImmzCPII](
	[ImmzCPIIUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ImmunizationHistoryUid] [uniqueidentifier] NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[ImmzContraindicationUid] [uniqueidentifier] NULL,
	[ImmzReactionUid] [uniqueidentifier] NULL,
	[ImmzEvidenceOfImmunityUid] [uniqueidentifier] NULL,
	[ImmzSpecialIndicationsUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImmzForecastDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImmzForecastDetail](
	[ImmzForeCastDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[CVXCodeUid] [uniqueidentifier] NOT NULL,
	[DateVaccineDue] [date] NOT NULL,
	[EarliestDatetoGive] [date] NOT NULL,
	[DateImmzRecordReceived] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ProblemIT_Attribute]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ProblemIT_Attribute](
	[IMO_ProblemIT_AttributeUid] [uniqueidentifier] NOT NULL,
	[Range] [varchar](25) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IncludeInPatientDiagnosis] [bit] NULL,
	[DSMAxis] [varchar](25) NULL,
	[LifeLong] [bit] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ProblemIT_Custom]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ProblemIT_Custom](
	[IMO_ProblemIT_Custom_Uid] [uniqueidentifier] NOT NULL,
	[Code09] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[SnoMedCodeList] [varchar](max) NULL,
	[Billable] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[CustomLexCode] [int] IDENTITY(-1,-1) NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ProblemIT_Custom_Word_Index]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ProblemIT_Custom_Word_Index](
	[IMO_ProblemIT_Custom_Uid] [uniqueidentifier] NOT NULL,
	[WORD_TEXT] [nvarchar](75) NOT NULL,
	[WORD_POS] [int] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ProblemIT_SearchQualifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ProblemIT_SearchQualifier](
	[IMO_ProblemIT_SearchQualifierUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_IMO_ProblemIT_SearchQualifierUid]  DEFAULT (newid()),
	[Qualifier] [nvarchar](75) NOT NULL,
	[SearchOrder] [bigint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_UserDefined]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[IMO_ProblemIT_SearchResult]') AND type in (N'U'))
BEGIN
CREATE TABLE [IMO_ProblemIT_SearchResult](
	[SearchUid] [uniqueidentifier] NOT NULL,
	[Code10] [varchar](100) NOT NULL,
	[CodeDescription10] [varchar](500) NOT NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LexCode] [bigint] NOT NULL,
	[ManifestationCode10] [bit] NOT NULL,
	[Billable10] [bit] NOT NULL,
	[Specific10] [bit] NOT NULL,
	[Primary10] [bit] NOT NULL,
	[Code09] [varchar](100) NOT NULL,
	[CodeDescription09] [varchar](500) NOT NULL,
	[SnoMedCodeList] [varchar](max) NULL,
	[ModifierCodeList] [varchar](500) NULL,
	[ModifiersExistInSubCodes] [bit] NOT NULL,
	[Syn] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IMO_ProblemIT_Custom_Uid] [uniqueidentifier] NULL,
	[IMO_Notes] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[InstantMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [InstantMessage](
	[InstantMessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_InstantMessage_InstantMessageUid]  DEFAULT (newid()),
	[Name] [varchar](255) NULL,
	[UserPrmUid1] [uniqueidentifier] NOT NULL,
	[UserPrmUid2] [uniqueidentifier] NOT NULL,
	[Conversation] [varchar](max) NOT NULL,
	[ConversationDate] [datetime] NOT NULL CONSTRAINT [DF_InstantMessage_ConversationDate]  DEFAULT (getutcdate()),
	[Notes] [varchar](max) NULL,
	[ExternalID] [varchar](25) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_InstantMessage_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[InsuranceCarrier]') AND type in (N'U'))
BEGIN
CREATE TABLE [InsuranceCarrier](
	[CorporationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrier_Inactive]  DEFAULT ((0)),
	[ExternalID] [varchar](25) NULL,
	[UseProviderFeeSchedule] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrier_UseProviderFeeSchedule]  DEFAULT ((1)),
	[ERAPayerID] [varchar](8000) NULL,
	[FeeScheduleUid] [uniqueidentifier] NULL,
	[AmountAllowedFeeScheduleUid] [uniqueidentifier] NULL,
	[NoNetwork] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrier_NoNetwork]  DEFAULT ((1)),
	[PaperClaimFormatUid] [uniqueidentifier] NULL,
	[ElectronicClaimFormatUid] [uniqueidentifier] NULL,
	[PaperClaimDefaultOptionUid] [uniqueidentifier] NULL,
	[ElectronicPayerUid] [uniqueidentifier] NULL,
	[AccountTypeUid] [uniqueidentifier] NULL,
	[PQRIGroupUid] [uniqueidentifier] NULL,
	[AcceptAssignment] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrier_AcceptAssignment]  DEFAULT ((1)),
	[AcceptAssignmentLabOnly] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrier_AcceptAssignmentLabOnly]  DEFAULT ((0)),
	[IsEPrescribingIncentive] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrier_IsEPrescribingIncentive]  DEFAULT ((0)),
	[MemberIDFormat] [varchar](50) NULL,
	[GroupIDFormat] [varchar](50) NULL,
	[ReimbursementRuleUid] [uniqueidentifier] NULL,
	[PrmRuleGroupUid] [uniqueidentifier] NULL,
	[ScrubProfileUid] [uniqueidentifier] NULL,
	[AutoWriteoffCreditTypeUid] [uniqueidentifier] NULL,
	[CodeValidationCarrierMapUid] [uniqueidentifier] NULL,
	[Notes] [varchar](8000) NULL,
	[EligibilityClearingHouseUid] [uniqueidentifier] NULL,
	[EligibilityPayerUid] [uniqueidentifier] NULL,
	[MapToPayerTypeCode] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrier_MapToPayerTypeCode]  DEFAULT ((0)),
	[ReferralRequired] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrier_ReferralRequired]  DEFAULT ((0)),
	[AlternateInsurancePlanUid] [uniqueidentifier] NULL,
	[EnrollmentClearingHouseUid] [uniqueidentifier] NULL,
	[DemographicsClearingHouseUid] [uniqueidentifier] NULL,
	[InsuranceGroupUid] [uniqueidentifier] NULL,
	[EnglishFormattingTemplateUid] [uniqueidentifier] NULL,
	[SpanishFormattingTemplateUid] [uniqueidentifier] NULL,
	[RequiresABNChecking] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrier_RequiresABNChecking]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_InsuranceCarrier_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[OrderDefaults] [xml] NULL,
	[ICD10Date] [date] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[InsurancePayerContact]') AND type in (N'U'))
BEGIN
CREATE TABLE [InsurancePayerContact](
	[InsurancePayerContactUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_InsuranceCarrierContact_InsuranceCarrierContactUid]  DEFAULT (newid()),
	[ExternalID] [varchar](20) NULL,
	[InsurancePlanUid] [uniqueidentifier] NULL,
	[CorporationUid] [uniqueidentifier] NOT NULL,
	[Title] [varchar](50) NULL,
	[FirstName] [varchar](50) NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NULL,
	[Suffix] [varchar](50) NULL,
	[Name] [varchar](100) NULL,
	[AkaFirstName] [varchar](50) NULL,
	[AkaLastName] [varchar](50) NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrierContact_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_InsuranceCarrierContact_LastModifiedDate]  DEFAULT (getdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[InsurancePayerPromise]') AND type in (N'U'))
BEGIN
CREATE TABLE [InsurancePayerPromise](
	[InsurancePromiseUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](50) NULL,
	[Amount] [money] NOT NULL CONSTRAINT [DF_InsurancePayerPromise_Amount]  DEFAULT ((0)),
	[PromiseMade] [date] NOT NULL CONSTRAINT [DF_InsuranceCarrierPromise_PromiseMade]  DEFAULT (getdate()),
	[PromisedBy] [date] NOT NULL,
	[InsurancePayerContactUid] [uniqueidentifier] NOT NULL,
	[PaidMessageRecipientUserUid] [uniqueidentifier] NULL,
	[PaidMessageRecipientUserGroupUid] [uniqueidentifier] NULL,
	[UnpaidMessageRecipientUserUid] [uniqueidentifier] NULL,
	[UnpaidMessageRecipientUserGroupUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[IsCompleted] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrierPromise_IsCompleted]  DEFAULT ((0)),
	[IsBroken] [bit] NOT NULL CONSTRAINT [DF_InsuranceCarrierPromise_IsBroken]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_InsuranceCarrierPromise_LastModifiedDate]  DEFAULT (getdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[InsurancePayerPromiseSuperbill]') AND type in (N'U'))
BEGIN
CREATE TABLE [InsurancePayerPromiseSuperbill](
	[InsurancePromiseSuperbillUid] [uniqueidentifier] NOT NULL,
	[InsurancePromiseUid] [uniqueidentifier] NOT NULL,
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[Amount] [money] NOT NULL CONSTRAINT [DF_InsurancePayerPromiseSuperbill_Amount]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[InsurancePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [InsurancePlan](
	[InsurancePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_InsurancePlan_InsurancePlanUid]  DEFAULT (newid()),
	[InsuranceCarrierUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_Inactive]  DEFAULT ((0)),
	[IsCapitated] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_IsCapitated]  DEFAULT ((0)),
	[UseCarrierAddress] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierAddress]  DEFAULT ((1)),
	[Address] [xml](CONTENT [Address]) NULL,
	[Phone] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Phone3] [xml](CONTENT [Phone]) NULL,
	[Phone4] [xml](CONTENT [Phone]) NULL,
	[UseProviderFeeSchedule] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseProviderFeeSchedule]  DEFAULT ((0)),
	[UseCarrierFeeSchedule] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierFeeSchedule]  DEFAULT ((1)),
	[FeeScheduleUid] [uniqueidentifier] NULL,
	[UseInsuranceCarrierAccountType] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseInsuranceCarrierAccountType]  DEFAULT ((1)),
	[AccountTypeUid] [uniqueidentifier] NULL,
	[UseCarrierAmountAllowedFeeSchedule] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierAmountAllowedFeeSchedule]  DEFAULT ((1)),
	[AmountAllowedFeeScheduleUid] [uniqueidentifier] NULL,
	[UseCarrierNoNetwork] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierNoNetwork]  DEFAULT ((1)),
	[NoNetwork] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_NoNetwork]  DEFAULT ((1)),
	[UseCarrierPaperClaimFormat] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierPaperClaimFormat]  DEFAULT ((1)),
	[PaperClaimFormatUid] [uniqueidentifier] NULL,
	[UseCarrierElectronicClaimFormat] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierElectronicClaimFormat]  DEFAULT ((1)),
	[ElectronicClaimFormatUid] [uniqueidentifier] NULL,
	[UseCarrierPaperClaimDefaultOption] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierPaperClaimDefaultOption_1]  DEFAULT ((1)),
	[PaperClaimDefaultOptionUid] [uniqueidentifier] NULL,
	[UseCarrierMemberIDFormat] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierMemberIDFormat]  DEFAULT ((1)),
	[MemberIDFormat] [varchar](50) NULL,
	[UseCarrierGroupIDFormat] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierGroupIDformat]  DEFAULT ((1)),
	[GroupIDFormat] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_InsurancePlan_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ReimbursementRuleUid] [uniqueidentifier] NULL,
	[UseCarrierAutoWriteoffCreditType] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierAutoWriteoffCreditType]  DEFAULT ((1)),
	[AutoWriteoffCreditTypeUid] [uniqueidentifier] NULL,
	[CodeValidationCarrierMapUid] [uniqueidentifier] NULL,
	[UseCarrierCodeValidation] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UseCarrierCodeValidation]  DEFAULT ((1)),
	[ReferralRequired] [bit] NULL,
	[UserCarrierReferralRequired] [bit] NOT NULL CONSTRAINT [DF_InsurancePlan_UserCarrierReferralRequired]  DEFAULT ((1)),
	[Notes] [varchar](8000) NULL,
	[OrderDefaults] [xml] NULL,
	[PayerTypologySourceUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[InterfaceDataMapping]') AND type in (N'U'))
BEGIN
CREATE TABLE [InterfaceDataMapping](
	[InterfaceDataMappingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_InterfaceDataMapping1_InterfaceDataMappingUid]  DEFAULT (newid()),
	[Rootid] [varchar](40) NOT NULL,
	[Name] [varchar](100) NULL,
	[CCDCode] [varchar](25) NOT NULL,
	[PRMCode] [varchar](25) NULL,
	[CCDPrintName] [varchar](250) NULL,
	[IsDefault] [bit] NULL CONSTRAINT [DF_InterfaceDataMapping1_Default]  DEFAULT ((0)),
	[Inactive] [bit] NULL CONSTRAINT [DF_InterfaceDataMapping1_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_InterfaceDataMapping1_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_InterfaceDataMapping1_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[QRDAMeasure] [varchar](10) NULL,
	[TopicIndicator] [varchar](10) NULL,
	[NQFNumber] [varchar](10) NULL,
	[DataElementName] [varchar](100) NULL,
	[Modifier] [varchar](25) NULL,
	[EndDate] [varchar](25) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[InterfaceMessageStructure]') AND type in (N'U'))
BEGIN
CREATE TABLE [InterfaceMessageStructure](
	[InterfaceMessageStructureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[HL7PartnerMessageUid] [uniqueidentifier] NOT NULL,
	[FieldXPath] [varchar](255) NOT NULL,
	[ConstantValue] [varchar](255) NULL,
	[InterfaceBusinessObjectUid] [uniqueidentifier] NULL,
	[BusinessObjectPath] [varchar](255) NULL,
	[Formatting] [varchar](255) NULL,
	[FindTableUid] [uniqueidentifier] NULL,
	[Required] [bit] NOT NULL,
	[AllowNew] [bit] NOT NULL,
	[EmptyToNull] [bit] NOT NULL,
	[IsEntityObject] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[JobHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [JobHistory](
	[JobHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[JobScheduleUid] [uniqueidentifier] NOT NULL,
	[DateStarted] [datetime] NULL,
	[DateEnded] [datetime] NULL,
	[Status] [smallint] NULL,
	[NeedNotification] [smallint] NULL,
	[Inactive] [bit] NOT NULL,
	[JobInfo] [varchar](max) NULL,
	[AuditWorkflowLogUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[JobNotification]') AND type in (N'U'))
BEGIN
CREATE TABLE [JobNotification](
	[JobNotificationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_JobNotification_JobNotificationUid]  DEFAULT (newid()),
	[JobUid] [uniqueidentifier] NOT NULL,
	[MemberUserUid] [uniqueidentifier] NULL,
	[MemberUserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_JobEmailList_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[JobSchedule]') AND type in (N'U'))
BEGIN
CREATE TABLE [JobSchedule](
	[JobScheduleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_JobSchedule_JobUid]  DEFAULT (newid()),
	[JobUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_JobSchedule_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[MethodParams] [varchar](max) NULL,
	[RunImmediately] [bit] NOT NULL CONSTRAINT [DF_JobSchedule_JobAutoRepeat]  DEFAULT ((0)),
	[JobScheduleTimeBaseUid] [uniqueidentifier] NOT NULL,
	[JobRepeatInterval] [varchar](50) NULL,
	[JobRepeatFrom] [datetime] NOT NULL,
	[JobRestart] [bit] NOT NULL CONSTRAINT [DF_JobSchedule_JobRestart]  DEFAULT ((1)),
	[JobSuccessHistoryDepth] [int] NOT NULL CONSTRAINT [DF_JobSchedule_JobSuccessHistoryDepth]  DEFAULT ((50)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_JobSchedule_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_JobSchedule_UserDefined]  DEFAULT ((1)),
	[LastErrorDate] [datetime] NULL,
	[JobServer] [tinyint] NOT NULL CONSTRAINT [DF_JobSchedule_JobServer]  DEFAULT ((1)),
	[ActionAQN] [varchar](1024) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[LaboratoryLocation]') AND type in (N'U'))
BEGIN
CREATE TABLE [LaboratoryLocation](
	[LaboratoryLocationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[LaboratoryUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NULL,
	[Address1] [xml](CONTENT [Address]) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[LabDirector] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[OID] [varchar](100) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAccountType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAccountType](
	[AccountTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAccountType_AccountTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](2) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAccountType_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAccountType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAccountType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAddIn]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAddIn](
	[AddInUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAddIn_AddInUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAddIn_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[AcquirerAssemblyQualifiedName] [varchar](512) NULL,
	[ViewerAssemblyQualifiedName] [varchar](512) NULL,
	[ConfigurationAssemblyQualifiedName] [varchar](512) NULL,
	[ConfigurationData] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[Data] [varchar](8000) NULL,
	[Icon] [varbinary](max) NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[AttachmentContentType] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAddIn_UserDefined]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAddIn_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAddInType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAddInType](
	[AddInTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table1_AddInUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAddInType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAddInType_UserDefined]  DEFAULT ((1)),
	[AcquirerAQN] [bit] NOT NULL CONSTRAINT [DF_ListAddInType_AcquirerAQN]  DEFAULT ((0)),
	[ViewerAQN] [bit] NOT NULL CONSTRAINT [DF_ListAddInType_ViewerAQN]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAddInType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAdminDrugFundingSource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAdminDrugFundingSource](
	[AdminDrugFundingSourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAdminDrugMfr]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAdminDrugMfr](
	[AdminDrugMfrUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAdminDrugSite]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAdminDrugSite](
	[AdminDrugSiteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAdmissionSource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAdmissionSource](
	[AdmissionSourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAdmissionSource_AdmissionSourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAdmissionSource_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAdmissionSource_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAdmissionSource_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAdmissionType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAdmissionType](
	[AdmissionTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAdmissionType_AdmissionTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAdmissionType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAdmissionType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAdmissionType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAgeGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAgeGroup](
	[AgeGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAgeGroup_AgeGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAgeGroup_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[StartDays] [int] NULL,
	[EndDays] [int] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAgeGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAgeGroup_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAmendmentSource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAmendmentSource](
	[AmendmentSourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAmendmentSource_AmendmentSourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAmendmentSource_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAmendmentSource_UserDefined]  DEFAULT ((1)),
	[Notes] [text] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAmendmentSource_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAnswer]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAnswer](
	[AnswerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAnswer_AnswerUid]  DEFAULT (newid()),
	[DiseaseUid] [uniqueidentifier] NULL,
	[VaccineUid] [uniqueidentifier] NULL,
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAnswer_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAnswer_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAnswer_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAnswerGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAnswerGroup](
	[AnswerGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAnswerGroup_AnswerGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAnswerGroup_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAnswerGroup_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UseDiseases] [bit] NOT NULL CONSTRAINT [DF_ListAnswerGroup_UseDiseases]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAnswerGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAppointmentStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAppointmentStatus](
	[AppointmentStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAppointmentStatus_AppointmentStatusUid]  DEFAULT (newid()),
	[AppointmentStatusTypeUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[Color] [int] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_Color]  DEFAULT ((0)),
	[ShowOnSchedule] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_ShowOnSchedule]  DEFAULT ((1)),
	[ShowOnDesktop] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_ShowOnDesktop]  DEFAULT ((1)),
	[ChargeCancelationFee] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_ChargeCancelationFee]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_UserDefined]  DEFAULT ((1)),
	[IsCanceledStatus] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_IsCanceledStatus]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAppointmentStatusType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAppointmentStatusType](
	[AppointmentStatusTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Tag] [varchar](50) NOT NULL,
	[DisplayOrder] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAppointmentType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAppointmentType](
	[AppointmentTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAppointmentType_AppointmentTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_IsEnabled]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Color] [char](6) NOT NULL CONSTRAINT [DF_ListAppointmentType_Color]  DEFAULT ('FFFFFF'),
	[Duration] [int] NOT NULL CONSTRAINT [DF_ListAppointmentType_Duration]  DEFAULT ((5)),
	[Blocking] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_IsBlocking]  DEFAULT ((0)),
	[AllowBlockOverride] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_Warn]  DEFAULT ((0)),
	[AllowPatientRequest] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_AllowPatientRequest]  DEFAULT ((0)),
	[ChargeCancelationProcedureUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAppointmentType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[GroupVisit] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_GroupVisit]  DEFAULT ((0)),
	[Description] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAppServer]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAppServer](
	[AppServerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AppServerName] [varchar](255) NOT NULL,
	[Port] [int] NOT NULL,
	[DBServerName] [varchar](255) NULL,
	[DBName] [varchar](255) NULL,
	[AppServiceName] [varchar](255) NULL,
	[Type] [varchar](24) NOT NULL,
	[InstallPath] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListARRAReports]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListARRAReports](
	[ARRAReportsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](250) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListARRAReports_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListARRAReports_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAssignmentOfBenefits]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAssignmentOfBenefits](
	[AssignmentOfBenefitsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAttachmentHandler]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAttachmentHandler](
	[AttachmentHandlerUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListAttachmentHandler_AttachmentHandlerUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[FileNameWildcard] [varchar](255) NULL,
	[CompressionUid] [uniqueidentifier] NULL,
	[ViewerAQN] [varchar](500) NULL,
	[PrinterAQN] [varchar](500) NULL,
	[ExternalViewerPath] [varchar](500) NULL,
	[AutoOpen] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentHandler_AutoOpen]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentHandler_Inactive]  DEFAULT ((0)),
	[Priority] [smallint] NOT NULL CONSTRAINT [DF_ListAttachmentHandler_Priority]  DEFAULT ((0)),
	[BlockUpload] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentHandler_BlockUpload_1]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAttachmentHandler_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAttachmentHandler_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAttachmentType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAttachmentType](
	[AttachmentTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAttachmentType_AttachmentTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[NeedReview] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentType_NeedReview]  DEFAULT ((0)),
	[DisplayOnOPS] [bit] NOT NULL CONSTRAINT [DF_ListAttachmentType_DisplayOnOPS]  DEFAULT ((0)),
	[DisplayTypeID] [smallint] NULL CONSTRAINT [DF_ListAttachmentType_DisplayTypeID]  DEFAULT ((0)),
	[Color] [int] NOT NULL CONSTRAINT [DF_ListAttachmentType_Color]  DEFAULT ((0)),
	[ShowInFNC] [bit] NULL CONSTRAINT [DF_ListAttachmentType_ShowInFNC]  DEFAULT ((0)),
	[SummaryOfCare] [bit] NULL CONSTRAINT [DF_ListAttachmentType_SummaryOfCare]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAttachmentType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageSubTypeUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAttachmentType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListAuditEventConfiguration]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListAuditEventConfiguration](
	[AuditEventConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListAuditEventConfiguration_AuditUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAuditEventConfiguration_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[AuditEvent] [bit] NOT NULL CONSTRAINT [DF_ListAuditEventConfiguration_AuditEvent]  DEFAULT ((1)),
	[SendAlertMessage] [bit] NOT NULL CONSTRAINT [DF_ListAuditEventConfiguration_SendAlertMessage]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAuditEventConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAuditEventConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListBatchProcessType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListBatchProcessType](
	[BatchProcessTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ConfigurationAQN] [varchar](255) NULL,
	[ProcessAQN] [varchar](255) NULL,
	[SummaryXSLT] [xml] NULL,
	[SummaryRouting] [varchar](255) NULL,
	[DetailXSLT] [xml] NULL,
	[DetailRouting] [varchar](255) NULL,
	[MaxConcurrency] [smallint] NOT NULL CONSTRAINT [DF_ListBatchProcessType_MaxConcurrency]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListBatchProcessType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListBatchProcessType_UserDefined]  DEFAULT ((1)),
	[AutoStartDetail] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_AutoStartDetail]  DEFAULT ((0)),
	[Hide] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_Hide]  DEFAULT ((1)),
	[AllowIsCached] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_AllowIsCached]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListBillTimeRule]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListBillTimeRule](
	[BillTimeRuleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListBillTimeRule_BillTimeRuleUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListBillTimeRule_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[AQN] [varchar](255) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListBillTimeRule_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListBillTimeRule_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListBloodPressureMethods]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListBloodPressureMethods](
	[BloodPressureMethodsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListBloodPressureMethods_BloodPressureMethodsUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListBloodPressureMethods_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListBloodPressureMethods_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListBloodPressureMethods_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCacheMachine]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCacheMachine](
	[CacheMachineUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCacheMachine_CacheMachineUid]  DEFAULT (newid()),
	[ID] [int] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[URL] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCacheMachine_Inactive]  DEFAULT ((0)),
	[ReplicationAppointmentHours] [int] NULL,
	[ReplicationAttachmentSizeKB] [int] NULL,
	[TriggerRemovePatientSeconds] [int] NULL,
	[ReplicationRemovePatientHours] [int] NULL,
	[TriggerReplicationSeconds] [int] NULL,
	[EnableLogging] [bit] NOT NULL CONSTRAINT [DF_ListCacheMachine_EnableLogging]  DEFAULT ((0)),
	[Status] [varchar](max) NULL,
	[ReplicateEverything] [bit] NOT NULL CONSTRAINT [DF_ListCacheMachine_ReplicateEverything]  DEFAULT ((0)),
	[ReplicationMode] [smallint] NOT NULL CONSTRAINT [DF_ListCacheMachine_ReplicationMode]  DEFAULT ((0)),
	[MaxRows] [int] NOT NULL CONSTRAINT [DF_ListCacheMachine_MaxRows_1]  DEFAULT ((5000)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCacheMachine_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCalendar]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCalendar](
	[CalendarUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Calendar_CalendarUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[PatientCenterUid] [uniqueidentifier] NULL,
	[StartTime] [smallint] NOT NULL CONSTRAINT [DF_Calendar_StartTime]  DEFAULT ((480)),
	[EndTime] [smallint] NOT NULL CONSTRAINT [DF_Calendar_EndTime]  DEFAULT ((1020)),
	[TimeZone] [varchar](30) NULL,
	[DisplayInterval] [tinyint] NOT NULL CONSTRAINT [DF_Calendar_DisplayInterval]  DEFAULT ((15)),
	[BookingLevel] [tinyint] NOT NULL CONSTRAINT [DF_ListCalendar_BookingLevel]  DEFAULT ((1)),
	[DefaultProviderUid] [uniqueidentifier] NULL,
	[DisplayProviderName] [bit] NOT NULL CONSTRAINT [DF_ListCalendar_DisplayProviderName]  DEFAULT ((0)),
	[DefaultServiceSiteUid] [uniqueidentifier] NULL,
	[AllowPatientRequest] [bit] NOT NULL CONSTRAINT [DF_ListCalendar_AllowPatientRequest]  DEFAULT ((0)),
	[Color] [char](6) NOT NULL CONSTRAINT [DF_ListCalendar_Color]  DEFAULT ('FFFFCC'),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Calendar_IsEnabled]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Calendar_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCalendarTemplateDay]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCalendarTemplateDay](
	[CalendarTemplateDayUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCalendarTemplateDay_CalendarTemplateDayUid]  DEFAULT (newid()),
	[CalendarTemplateHeadUid] [uniqueidentifier] NOT NULL,
	[TemplateDay] [smallint] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[IsOpen] [bit] NOT NULL CONSTRAINT [DF_ListCalendarTemplateDay_IsOpen]  DEFAULT ((1)),
	[StartTime] [smallint] NULL,
	[EndTime] [smallint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCalendarTemplateDay_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCalendarTemplateDay_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCalendarTemplateDaySlot]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCalendarTemplateDaySlot](
	[CalendarTemplateDaySlotUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCalendarTemplateDaySlot_CalendarTemplateDaySlotUid]  DEFAULT (newid()),
	[CalendarTemplateDayUid] [uniqueidentifier] NOT NULL,
	[AppointmentTypeUid] [uniqueidentifier] NOT NULL,
	[StartTime] [smallint] NOT NULL,
	[EndTime] [smallint] NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListCalendarTemplateDaySlot_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCalendarTemplateDaySlot_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCalendarTemplateDaySlot_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCalendarTemplateHead]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCalendarTemplateHead](
	[CalendarTemplateHeadUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCalendarTemplate_CalendarTemplateUid]  DEFAULT (newid()),
	[ExternalID] [varchar](50) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Color] [char](6) NOT NULL CONSTRAINT [DF_ListCalendarTemplateHead_Color]  DEFAULT ('FFFFFF'),
	[NumDays] [smallint] NOT NULL CONSTRAINT [DF_ListCalendarTemplate_NumDays]  DEFAULT ((1)),
	[StartTime] [smallint] NOT NULL CONSTRAINT [DF_ListCalendarTemplateHead_StartTime]  DEFAULT ((480)),
	[EndTime] [smallint] NOT NULL CONSTRAINT [DF_ListCalendarTemplateHead_EndTime]  DEFAULT ((1080)),
	[DisplayInterval] [tinyint] NOT NULL CONSTRAINT [DF_ListCalendarTemplateHead_DisplayInterval]  DEFAULT ((15)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCalendarTemplate_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCalendarTemplate_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCaseAuthorizationCodeSet]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCaseAuthorizationCodeSet](
	[CaseAuthorizationCodeSetUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCaseAuthorizationCodeSet_CaseAuthorizationCodeSetUid]  DEFAULT (newid()),
	[ExternalID] [varchar](50) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCaseAuthorizationCodeSet_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCaseAuthorizationCodeSet_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCaseAuthorizationCodeSet_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCaseModule]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCaseModule](
	[CaseModuleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCaseModule_CaseModuleUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCaseModule_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ControlClass] [varchar](255) NULL,
	[RequiresUserDefinedControlGroup] [bit] NOT NULL CONSTRAINT [DF_ListCaseModule_RequiresUserDefinedControlGroup]  DEFAULT ((0)),
	[RequiresFormLayout] [bit] NOT NULL CONSTRAINT [DF_ListCaseModule_RequiresFormLayout]  DEFAULT ((0)),
	[RequiresControlClass] [bit] NOT NULL CONSTRAINT [DF_ListCaseModule_RequiresControlClass]  DEFAULT ((0)),
	[UserDefinedControlGroupUid] [uniqueidentifier] NULL,
	[FormLayoutUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCaseModule_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCaseModule_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCasePhase]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCasePhase](
	[CasePhaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCaseType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCaseType](
	[CaseTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCaseType_CaseTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[DisplayAlertsOnVisits] [bit] NOT NULL CONSTRAINT [DisplayAlertsOnVisitsNoNull]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCaseType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCaseType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCaseType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCaseTypeModule]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCaseTypeModule](
	[CaseTypeModuleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCaseTypeModule_CaseTypeModuleUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCaseTypeModule_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[CaseTypeUid] [uniqueidentifier] NULL,
	[CaseModuleUid] [uniqueidentifier] NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListCaseTypeModule_DisplayOrder]  DEFAULT ((-1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCaseTypeModule_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCaseTypeModule_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCaseTypePhase]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCaseTypePhase](
	[CaseTypePhaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCaseTypePhase_CaseTypePhaseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCaseTypePhase_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[CaseTypeUid] [uniqueidentifier] NULL,
	[PhaseNumber] [int] NOT NULL CONSTRAINT [DF_ListCaseTypePhase_PhaseNumber]  DEFAULT ((0)),
	[Duration] [int] NOT NULL CONSTRAINT [DF_ListCaseTypePhase_Duration]  DEFAULT ((0)),
	[TimeTypeUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListCaseTypePhase_DisplayOrder]  DEFAULT ((-1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCaseTypePhase_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCaseTypePhase_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCDASection]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCDASection](
	[CDASectionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_DietUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCDASection_Inactive]  DEFAULT ((0)),
	[SectionsIncluded] [xml] NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCDASection_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCDASection_LastModifiedDate]  DEFAULT (getutcdate()),
	[StoreIntermediateData] [bit] NOT NULL CONSTRAINT [DF_ListCDASection_StoreIntermediateData]  DEFAULT ((0)),
	[UseCat1DocumentGenerator] [bit] NOT NULL CONSTRAINT [DF_ListCDASection_UseNewCdaGenerator]  DEFAULT ((0)),
	[RuleMeasureUid] [uniqueidentifier] NULL,
	[FileExtension] [nchar](10) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListChargeTicketDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListChargeTicketDiagnosis](
	[ChargeTicketDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListChargeTicketDiagnosis_ChargeTicketDiagnosisUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListChargeTicketDiagnosis_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IncludeProviderMFU] [bit] NOT NULL CONSTRAINT [DF_ListChargeTicketDiagnosis_IncludeProviderMFU_1]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListChargeTicketDiagnosis_UserDefined]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListChargeTicketDiagnosis_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListChargeTicketSO]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListChargeTicketSO](
	[ChargeTicketSOUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListChargeTicketSO_ChargeTicketSOUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListChargeTicketSO_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IncludeProviderMFU] [bit] NOT NULL CONSTRAINT [DF_ListChargeTicketSO_IncludeProviderMFU]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListChargeTicketSO_UserDefined]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListChargeTicketSO_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListChargeTicketSP]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListChargeTicketSP](
	[ChargeTicketSPUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListChargeTicketSP_ChargeTicketSPUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListChargeTicketSP_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IncludeProviderMFU] [bit] NOT NULL CONSTRAINT [DF_ListChargeTicketSP_IncludeProviderMFU]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListChargeTicketSP_UserDefined]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListChargeTicketSP_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimBatchStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimBatchStatus](
	[BatchStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListClaimBatchStatus_BatchStatusUid]  DEFAULT (newid()),
	[ExternalId] [varchar](24) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClaimBatchStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimBatchStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimBatchStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimClearingHouse]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimClearingHouse](
	[ClaimClearingHouseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListClaimClearingHouse_ClaimClearingHouseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClaimClearingHouse_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ContactName] [varchar](100) NULL,
	[Address] [xml](CONTENT [Address]) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimClearingHouse_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimClearingHouse_LastModifiedDate]  DEFAULT (getutcdate()),
	[ClaimCreatorAQN] [varchar](100) NULL,
	[TransmissionAQN] [varchar](100) NULL,
	[OrganizationName] [varchar](255) NULL,
	[ReceiverID] [varchar](50) NULL,
	[ClaimFormatValueTypeUid] [uniqueidentifier] NULL,
	[ClearingHousePublicKeyFile] [varbinary](max) NULL,
	[SubmitterPrivateKeyFile] [varbinary](max) NULL,
	[IsEligibility] [bit] NOT NULL CONSTRAINT [DF_ListClaimClearingHouse_IsEligibility]  DEFAULT ((0)),
	[ConnectionType] [varchar](20) NULL,
	[TransmissionSettingsEditorAQN] [varchar](255) NULL,
	[ClearingHouseType] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimClearingHouse_ClearingHouseType]  DEFAULT ((1)),
	[ERAStatus] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimClearingHouse_ERAStatus]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimFormat]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimFormat](
	[ClaimFormatUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListClaimFormat_ClaimFormatTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormat_Inactive]  DEFAULT ((0)),
	[ClaimFormatTypeUid] [uniqueidentifier] NOT NULL,
	[SendNPI] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormat_SendNPI]  DEFAULT ((1)),
	[Dmerc] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormat_Dmerc]  DEFAULT ((0)),
	[SendPQRIproc] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormat_SendPQRIproc]  DEFAULT ((0)),
	[Output2310D] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormat_Output2310D]  DEFAULT ((0)),
	[OutputAAE] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormat_OutputAAE]  DEFAULT ((0)),
	[BHTTypePR] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormat_BHTTypePR]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimFormat_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimFormat_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimFormatOptionType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimFormatOptionType](
	[ClaimFormatOptionTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ClaimFormatOptionType_ClaimFormatOptionTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormatOptionType_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimFormatOptionType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ClaimFormatTypeUid] [uniqueidentifier] NOT NULL,
	[ClaimFormatValueTypeTypeUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimFormatOptionType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimFormatType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimFormatType](
	[ClaimFormatTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ClaimFormatType_ClaimFormatTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Tag] [varchar](10) NOT NULL CONSTRAINT [DF_ListClaimFormatType_Tag]  DEFAULT ('unnamed'),
	[IsPaper] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormatType_IsPaper]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormatType_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimFormatType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimFormatType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimFormatValueType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimFormatValueType](
	[ClaimFormatValueTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListClaimFormatValueTypeType_ClaimFormatValueTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NULL,
	[Notes] [varchar](max) NULL,
	[IsPerProviderValue] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormatValueType_IsPerProviderValue]  DEFAULT ((0)),
	[IsPerFinancialCenterValue] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormatValueType_IsPerPractice]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormatValueType_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimFormatValueType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ClaimFormatValueTypeTypeUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimFormatValueType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimFormatValueTypeType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimFormatValueTypeType](
	[ClaimFormatValueTypeTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListClaimFormatValueTypeType_ClaimFormatValueTypeTypeUid]  DEFAULT (newid()),
	[Name] [varchar](100) NOT NULL,
	[Tag] [varchar](50) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListClaimFormatValueTypeType_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimFormatValueTypeType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimFormatValueTypeType_UserDefined]  DEFAULT ((1)),
	[AllowUserDataEntry] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormatValueTypeType_UserDataEntry]  DEFAULT ((1)),
	[UserSelectableType] [bit] NOT NULL CONSTRAINT [DF_ListClaimFormatValueTypeType_UserSelectableType]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimFormLayout]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimFormLayout](
	[ClaimFormLayoutUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListClaimFormLayout_ClaimFormLayoutUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[AssemblyName] [varchar](255) NOT NULL,
	[TypeName] [varchar](255) NOT NULL,
	[ReportUid] [uniqueidentifier] NULL,
	[ClaimFormatTypeUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ClaimFormLayout_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimFormLayout_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimFormLayout_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimHeaderNoteCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimHeaderNoteCode](
	[ClaimHeaderNoteCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListClaimHeaderNoteCode_ClaimHeaderNoteCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClaimHeaderNoteCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimHeaderNoteCode_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimHeaderNoteCode_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClaimReportStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClaimReportStatus](
	[ClaimReportStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListClaimReportStatus_ClaimReportStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClaimReportStatus_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClaimReportStatus_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClaimReportStatus_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClientMachine]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClientMachine](
	[ClientMachineUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[URL] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClinicalNoteType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClinicalNoteType](
	[ClinicalNoteTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListClinicalNoteType_ClinicalNoteTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClinicalNoteType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClinicalNoteType_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[HasAttachments] [bit] NOT NULL CONSTRAINT [DF_ListClinicalNoteType_HasAttachments_1]  DEFAULT ((0)),
	[HasDictation] [bit] NOT NULL CONSTRAINT [DF_ListClinicalNoteType_HasDictation_1]  DEFAULT ((0)),
	[HasServicesPerformed] [bit] NOT NULL CONSTRAINT [DF_ListClinicalNoteType_HasServicesPerformed_1]  DEFAULT ((0)),
	[MinTabWidth] [smallint] NOT NULL CONSTRAINT [DF_ListClinicalNoteType_MinTabWidth_1]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClinicalNoteType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListClinicCenter]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListClinicCenter](
	[ClinicCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListClinicalCenter_ClinicalCenterUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListClinicalCenter_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ChargeTicketDiagnosisUid] [uniqueidentifier] NULL,
	[ChargeTicketSOUid] [uniqueidentifier] NULL,
	[ChargeTicketSPUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListClinicCenter_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListClinicalCenter_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCodeValidationCarrierMap]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCodeValidationCarrierMap](
	[CodeValidationCarrierMapUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CodeValidationCarrierMap_CodeValidationCarrierMapUid]  DEFAULT (newid()),
	[Name] [varchar](100) NOT NULL,
	[LongCarrierID] [varchar](100) NOT NULL,
	[ShortCarrierID] [varchar](100) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCodeValidationCarrierMap_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCodeValidationCarrierMap_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCodeValidationCarrierMap_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCollectionStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCollectionStatus](
	[CollectionStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCollectionStatus_CollectionStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](150) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCollectionStatus_InActive]  DEFAULT ((0)),
	[SendStatement] [bit] NOT NULL CONSTRAINT [DF_ListCollectionStatus_SendStatement]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCollectionStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCollectionStatus_UserDefined]  DEFAULT ((1)),
	[RequireSecurityToBookAppointment] [bit] NOT NULL CONSTRAINT [ListCollectionStatus_RequireSecurityToBookAppointment_Defualt]  DEFAULT ((0)),
	[AlertDays] [int] NOT NULL CONSTRAINT [DF_ListCollectionStatus_AlertDays]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCompression]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCompression](
	[CompressionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table2_AttachmentHandlerUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[AQN] [varchar](500) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCompression_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCompression_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCompression_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListConditionalOperator]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListConditionalOperator](
	[ConditionalOperatorUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ConditionalOperator] [nchar](15) NOT NULL,
	[ANSICode] [nchar](15) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListConditionCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListConditionCode](
	[ConditionCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListConditionCode_ConditionCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListConditionCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListConditionCode_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListConditionCode_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListConsentForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListConsentForm](
	[ConsentFormUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[IsUsed] [bit] NOT NULL,
	[Form] [varchar](max) NULL,
	[FormHash] [varbinary](16) NULL,
	[UseAllSignatures] [bit] NOT NULL,
	[RootObjectType] [varchar](256) NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListContextReportType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListContextReportType](
	[ContextReportTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table1_LanguageUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListContextReportType_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListContextReportType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListContextReportType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListContractTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListContractTypeCode](
	[ContractTypeCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListContractTypeCode_ContractTypeCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListContractTypeCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListContractTypeCode_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListContractTypeCode_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListControlType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListControlType](
	[ControlTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListControlType_ControlTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListControlType_Inactive]  DEFAULT ((0)),
	[DesignTimeClass] [varchar](255) NULL,
	[RunTimeClass] [varchar](255) NOT NULL,
	[UserDefinedControlUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListControlType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListControlType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCoverageType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCoverageType](
	[CoverageTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCoverageType_CoverageTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCoverageType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCoverageType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCoverageType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCP_CarePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCP_CarePlan](
	[CP_CarePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCP_Goal]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCP_Goal](
	[CP_GoalUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[GoalValue] [varchar](max) NULL,
	[Value1] [decimal](14, 6) NULL,
	[Value2] [decimal](14, 6) NULL,
	[Colors] [xml](CONTENT [GoalColors]) NULL,
	[Operator] [smallint] NULL,
	[AQN] [varchar](512) NULL,
	[ObservationItemUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[AchieveGoalAnswerUid] [uniqueidentifier] NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCP_HealthConcern]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCP_HealthConcern](
	[CP_HealthConcernUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IsRisk] [bit] NOT NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCpp]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCpp](
	[CppUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCpp_CppUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[CppGroupUid] [uniqueidentifier] NULL,
	[Name] [varchar](255) NOT NULL,
	[PETemplateUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCpp_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCpp_Inactive]  DEFAULT ((0)),
	[SpecialtyUid] [uniqueidentifier] NULL,
	[Type] [smallint] NULL CONSTRAINT [DF_ListCpp_PlanType]  DEFAULT ((0)),
	[ReturnNum] [int] NULL,
	[ReturnUnitID] [int] NULL,
	[ExcerciseStyleID] [int] NULL,
	[ExerciseSuggestionID] [int] NULL,
	[IsDietRegular] [bit] NOT NULL CONSTRAINT [DF_ListCpp_IsDietRegular]  DEFAULT ((0)),
	[IsDietSoft] [bit] NOT NULL CONSTRAINT [DF_ListCpp_IsDietSoft]  DEFAULT ((0)),
	[IsDietLiquid] [bit] NOT NULL CONSTRAINT [DF_ListCpp_IsDietLiquid]  DEFAULT ((0)),
	[IsDietLowSodium] [bit] NOT NULL CONSTRAINT [DF_ListCpp_IsDietLowSodium]  DEFAULT ((0)),
	[IsDietAda] [bit] NOT NULL CONSTRAINT [DF_ListCpp_IsDietAda]  DEFAULT ((0)),
	[IsDietLowFat] [bit] NOT NULL CONSTRAINT [DF_ListCpp_IsDietLowFat]  DEFAULT ((0)),
	[PrnText] [varchar](50) NULL,
	[SymptomText] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCpp_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCppGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCppGroup](
	[CppGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCppGroup_CppGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCppGroup_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Abbrev] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCppGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCppGroup_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCQM]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCQM](
	[CQMUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCQM_CQMUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](4000) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DomainDescription] [varchar](4000) NULL,
	[CMS] [varchar](255) NULL,
	[PQRS] [varchar](255) NULL,
	[NQF] [varchar](255) NULL,
	[GPRO] [varchar](255) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCQM_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCQM_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCQM_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCreditCard]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCreditCard](
	[CreditCardUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCreditCard_CreditCardUid]  DEFAULT (newid()),
	[ExternalId] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListCreditCard_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCreditCard_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCreditCard_LastModifiedDate_1]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCreditCard_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCreditType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCreditType](
	[CreditTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCreditType_CreditTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](25) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCreditType_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCreditType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[IsPayment] [bit] NOT NULL CONSTRAINT [DF_ListCreditType_IsPayment]  DEFAULT ((0)),
	[IsAdjustment] [bit] NOT NULL CONSTRAINT [DF_ListCreditType_IsAdjustment]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[IsCollectableAdjustment] [bit] NOT NULL CONSTRAINT [DF_ListCreditType_IsCollectableAdjustment]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCreditType_UserDefined]  DEFAULT ((1)),
	[TransactionTypeUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCustomNotePrint]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCustomNotePrint](
	[CustomNotePrintUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCustomNotePrint_CustomNotePrintUid]  DEFAULT (newid()),
	[Name] [varchar](100) NULL,
	[CustomizationOptions] [varchar](max) NULL,
	[ReportUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCustomNotePrint_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCustomNotePrint_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCustomNotePrint_LastModifiedDate]  DEFAULT (getutcdate()),
	[ExternalID] [varchar](25) NULL,
	[UseVisitContext] [bit] NOT NULL CONSTRAINT [DF_ListCustomNotePrint_UseVisitContext]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListCVXCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListCVXCode](
	[CVXCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[CVXShortDesc] [varchar](max) NOT NULL,
	[CVXFullVaccineName] [varchar](max) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCVXCode_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCVXCode_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDataFormatter]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDataFormatter](
	[DataFormatterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDataFormatter_DataFormatterUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDataFormatter_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[EditorAssemblyQualifiedName] [varchar](512) NULL,
	[ContentSourceAssemblyQualifiedName] [varchar](512) NULL,
	[ParameterEditorAssemblyQualifiedName] [varchar](512) NULL,
	[FieldDefinition] [xml] NULL,
	[RootObjectType] [varchar](256) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDataFormatter_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDataFormatter_UserDefined]  DEFAULT ((1)),
	[QueryFilterAssemblyQualifiedName] [varchar](512) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDecileCQM]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDecileCQM](
	[DecileCQMUID] [uniqueidentifier] NOT NULL CONSTRAINT [df_ListDecileCQM_DecileCQMUID]  DEFAULT (newsequentialid()),
	[MeasureName] [varchar](max) NOT NULL,
	[Measure_ID] [varchar](20) NOT NULL,
	[CQMUID] [uniqueidentifier] NOT NULL,
	[CQMYear] [varchar](7) NOT NULL,
	[Decile3_Low] [numeric](6, 3) NULL,
	[Decile3_High] [numeric](6, 3) NULL,
	[Decile4_Low] [numeric](6, 3) NULL,
	[Decile4_High] [numeric](6, 3) NULL,
	[Decile5_Low] [numeric](6, 3) NULL,
	[Decile5_High] [numeric](6, 3) NULL,
	[Decile6_Low] [numeric](6, 3) NULL,
	[Decile6_High] [numeric](6, 3) NULL,
	[Decile7_Low] [numeric](6, 3) NULL,
	[Decile7_High] [numeric](6, 3) NULL,
	[Decile8_Low] [numeric](6, 3) NULL,
	[Decile8_High] [numeric](6, 3) NULL,
	[Decile9_Low] [numeric](6, 3) NULL,
	[Decile9_High] [numeric](6, 3) NULL,
	[Decile10_Low] [numeric](6, 3) NULL,
	[Decile10_High] [numeric](6, 3) NULL,
	[Inactive] [bit] NULL CONSTRAINT [df_ListDecileCQM_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [df_ListDecileCQM_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NULL CONSTRAINT [df_ListDecileCQM_UserDefined]  DEFAULT ((0)),
	[LastModifiedByUID] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDegreeRelated]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDegreeRelated](
	[DegreeRelatedUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDegreeRelated_DegreeRelatedUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListDegreeRelated_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDegreeRelated_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDegreeRelated_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDegreeRelated_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDelayReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDelayReason](
	[DelayReasonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDelayReason_DelayReasonUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDelayReason_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDelayReason_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDelayReason_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDepartment]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDepartment](
	[DepartmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDepositMacro]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDepositMacro](
	[DepositMacroUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDepositMacro_DepositMacroUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[AppointmentRequired] [bit] NOT NULL CONSTRAINT [DF_ListDepositMacro_AppointmentRequired]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDepositMacro_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDepositMacro_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDepositMacro_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDesktopControl]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDesktopControl](
	[DesktopControlUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListDesktopControl_DesktopControlUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDesktopControl_Inactive]  DEFAULT ((0)),
	[AssemblyQualifiedName] [varchar](512) NOT NULL,
	[Notes] [varchar](max) NULL,
	[RefreshInterval] [int] NOT NULL CONSTRAINT [DF_ListDesktopControl_RefreshInterval]  DEFAULT ((300)),
	[MinRefreshInterval] [int] NOT NULL CONSTRAINT [DF_ListDesktopControl_RefreshInterval1]  DEFAULT ((30)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDesktopControl_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDesktopControl_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDiagnosis](
	[DiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDiagnosis_DiagnosisUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDiagnosis_Inactive]  DEFAULT ((0)),
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[Specificity] [char](1) NOT NULL CONSTRAINT [DF_ListDiagnosis_Specificity]  DEFAULT ('C'),
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[Complete] [bit] NOT NULL CONSTRAINT [DF_ListDiagnosis_Complete]  DEFAULT ((0)),
	[MasterDiagnosisUid] [uniqueidentifier] NULL,
	[ShortDescription] [varchar](75) NOT NULL,
	[LongDescription] [varchar](1024) NOT NULL,
	[Notes] [varchar](max) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[SnomedDescriptionUid] [uniqueidentifier] NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[DSMAxis] [varchar](250) NULL CONSTRAINT [DF_ListDiagnosis_DSMAxis]  DEFAULT ('Axis III'),
	[IncludeInPatientDiagnosis] [bit] NOT NULL CONSTRAINT [DF_ListDiagnosis_IncludeInPatientDiagnosis]  DEFAULT ((1)),
	[ShortDescriptionChangedFromMaster] [bit] NOT NULL CONSTRAINT [DF_ListDiagnosis_ShortDescriptionChangedFromMaster]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDiagnosis_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()),
	[LexicalCode] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDiagnosisCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDiagnosisCategory](
	[DiagnosisCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDiagnosisCategory_DiagnosisCategoryUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDiagnosisCategory_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDiagnosisCategory_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListDiagnosisCategory_DisplayOrder]  DEFAULT ((0)),
	[UIControlUid] [uniqueidentifier] NULL,
	[UIControlData] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDiagnosisCategory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDiagnosisPanel]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDiagnosisPanel](
	[DiagnosisPanelUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDiagnosisPanel_DiagnosisPanelUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDiagnosisPanel_Inactive]  DEFAULT ((0)),
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListDiagnosisPanel_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDiagnosisPanel_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDiagnosisPanel_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDiagnosisRangePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDiagnosisRangePlan](
	[DiagnosisRangePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDiagnosisSearchDefinition]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDiagnosisSearchDefinition](
	[DiagnosisSearchDefinitionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDiagnosisSearchDefinition_DiagnosisSearchDefinitionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Definition] [varchar](max) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDiagnosisSearchDefinition_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDiagnosisSearchDefinition_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDiagnosisSearchDefinition_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDiet]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDiet](
	[DietUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table_2_ExerciseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDiet_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDiet_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDiet_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDisclosureReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDisclosureReason](
	[DisclosureReasonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDisclosureReason_DisclosureReasonUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDisclosureReason_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDisclosureReason_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDisclosureReason_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDiscontinueReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDiscontinueReason](
	[DiscontinueReasonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDiscontinueReason_DiscontinueReasonUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDiscontinueReason_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDiscontinueReason_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDiscontinueReason_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDisease]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDisease](
	[DiseaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDisease_DiseaseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[FamilyHistorySnomedConceptID] [varchar](50) NULL,
	[FamilyHistoryDescriptionUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDisease_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDisease_UserDefined]  DEFAULT ((1)),
	[IsFamilyDisease] [bit] NOT NULL CONSTRAINT [DF_ListDisease_IsFamilyDisease]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDisease_LastModifiedDate_1]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDiseaseGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDiseaseGroup](
	[DiseaseGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDiseaseGroup_DiseaseGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDiseaseGroup_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDiseaseGroup_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDiseaseGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDocumentLinkingFolderType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDocumentLinkingFolderType](
	[DocumentLinkingFolderTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListDocumentLinkingFolderTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DeleteImportedFiles] [bit] NOT NULL CONSTRAINT [DF_ListDocumentLinkingFolderType_DeleteImportedFiles]  DEFAULT ((0)),
	[MaxFilesToProcess] [int] NOT NULL CONSTRAINT [DF_ListDocumentLinkingFolderType_MaxFilesToProcess]  DEFAULT ((50)),
	[DefaultDocumentName] [varchar](255) NULL,
	[DefaultCheckApprovalMessage] [bit] NOT NULL CONSTRAINT [DF_ListDocumentLinkingFolderType_DefaultCheckApprovalMessage]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDocumentLinkingFolderType_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDocumentLinkingFolderType_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDocumentLinkingFolderType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDominantHand]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDominantHand](
	[DominantHandUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDominantHand_DominantHandUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDominantHand_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDominantHand_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDominantHand_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDpnGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDpnGroup](
	[DpnGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDpnGroup_DpnGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDpnGroup_Inactive]  DEFAULT ((0)),
	[IsPlan] [bit] NOT NULL CONSTRAINT [DF_ListDpnGroup_IsPlan]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDpnGroup_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListDpnGroup_DisplayOrder]  DEFAULT ((0)),
	[MaxNodeLevel] [int] NULL CONSTRAINT [DF_ListDpnGroup_MaxNodeLevel]  DEFAULT ((1)),
	[Node0Description] [varchar](25) NULL,
	[Node1Description] [varchar](25) NULL,
	[Node2Description] [varchar](25) NULL,
	[Node3Description] [varchar](25) NULL,
	[Node4Description] [varchar](25) NULL,
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[PatientDashboardUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDpnGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListDpnNode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListDpnNode](
	[DpnNodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDpnNode_DpnNodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDpnNode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[NaturalLanguage] [varchar](100) NULL,
	[Conjunctor] [varchar](100) NULL,
	[ExcludeFromReport] [bit] NOT NULL CONSTRAINT [DF_ListDpnNode_ExcludeFromReport]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDpnNode_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListDpnNode_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDpnNode_LastModifiedDate]  DEFAULT (getutcdate()),
	[FindTableUid] [uniqueidentifier] NULL,
	[FindUid] [uniqueidentifier] NULL,
	[SubFindTableUid] [uniqueidentifier] NULL,
	[AllowsBilaterality] [bit] NOT NULL CONSTRAINT [DF_ListDpnNode_AllowsBilaterality]  DEFAULT ((0)),
	[IsPlan] [bit] NOT NULL CONSTRAINT [DF_ListDpnNode_IsPlan]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEduForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEduForm](
	[EduFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEduForm_EduFormUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEduForm_Inactive]  DEFAULT ((0)),
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[PQRIMeasureUid] [uniqueidentifier] NULL,
	[VendorID] [varchar](255) NULL,
	[AttachmentUid] [uniqueidentifier] NULL,
	[XSLFileName] [varchar](100) NULL,
	[PatientCommunications] [xml](CONTENT [UidList]) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEduForm_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEduForm_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LicenseCode] [varchar](50) NULL,
	[LanguageUid] [uniqueidentifier] NOT NULL,
	[DocumentMetadata] [xml] NULL,
	[ProcedureUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEduFormAssociation]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEduFormAssociation](
	[EduFormAssociationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_EduFormGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEduFormAssociation_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEduFormAssociation_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEduFormAssociation_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListElectronicPayer]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListElectronicPayer](
	[ElectronicPayerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListElectronicPayer_ElectronicPayerUid]  DEFAULT (newid()),
	[ClaimClearingHouseUid] [uniqueidentifier] NOT NULL,
	[ClearingHousePayerID] [varchar](25) NULL,
	[PayerOrgID] [varchar](25) NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListElectronicPayer_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[RegistrationRequired] [bit] NOT NULL CONSTRAINT [DF_ListElectronicPayer_RegistrationRequired]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListElectronicPayer_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListElectronicPayer_LastModifiedDate]  DEFAULT (getutcdate()),
	[EligibilityID] [varchar](25) NULL,
	[EligibilityRegistrationRequired] [bit] NOT NULL CONSTRAINT [DF_ListElectronicPayer_EligibilityRegistrationRequired]  DEFAULT ((0)),
	[Version] [varchar](10) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEligibilityAAAErrorCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEligibilityAAAErrorCode](
	[EligibilityAAAErrorCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEligibilityAAAErrorCode_EligibilityAAAErrorCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityAAAErrorCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEligibilityAAAErrorCode_UserDefined]  DEFAULT ((1)),
	[EligibilityStatusUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedByDate] [datetime] NOT NULL CONSTRAINT [DF_ListEligibilityAAAErrorCode_LastModifiedByDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEligibilityCoverageLevel]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEligibilityCoverageLevel](
	[EligibilityCoverageLevelUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEligibilityCoverageLevel_EligibilityCoverageLevelUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityCoverageLevel_Inactive]  DEFAULT ((0)),
	[Name] [varchar](150) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEligibilityCoverageLevel_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEligibilityCoverageLevel_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEligibilityFollowUpActionCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEligibilityFollowUpActionCode](
	[ListEligibilityFollowupActionCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEligibilityFollowUpActionCode_ListEligibilityFollowupActionCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityFollowUpActionCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[ANSICode] [varchar](10) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEligibilityFollowUpActionCode_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedByDate] [datetime] NOT NULL CONSTRAINT [DF_ListEligibilityFollowUpActionCode_LastModifiedByDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEligibilityFund]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEligibilityFund](
	[EligibilityFundUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](2) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEligibilityServiceType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEligibilityServiceType](
	[EligibilityServiceTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_EligibilityServiceTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](150) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Copay] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_Copay]  DEFAULT ((0)),
	[SpecialtyCopay] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_SpecialtyCopay]  DEFAULT ((0)),
	[OtherCopay] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_OtherCopay]  DEFAULT ((0)),
	[Coinsurance] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_Coinsurance]  DEFAULT ((0)),
	[Deductible] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_Deductible_1]  DEFAULT ((0)),
	[EligibilityStatus] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_EligibilityStatus_1]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEligibilityServiceType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEligibilityStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEligibilityStatus](
	[EligibilityStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEligibilityStatus_EligibilityStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEligibilityStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](150) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[ActiveCoverage] [bit] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEligibilityStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEligibilityStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEMBullet]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEMBullet](
	[EMBulletUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEMBullet_EMBulletUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEMBullet_Inactive]  DEFAULT ((0)),
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEMBullet_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEMBullet_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEmergencyIndicator]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEmergencyIndicator](
	[EmergencyIndicatorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEmergencyIndicator_EmergencyIndicatorUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEmergencyIndicator_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEmergencyIndicator_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEmergencyIndicator_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEMExaminationDescription]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEMExaminationDescription](
	[EMExaminationDescriptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEMExaminationDescription_ListEMExaminationDescriptionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEMSystemBody_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEMSystemBody_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEMSystemBody_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEMKeyComponent]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEMKeyComponent](
	[EMKeyComponentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEMKeyComponent_EMKeyComponentUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEMKeyComponent_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEMKeyComponent_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEMKeyComponent_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEmploymentStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEmploymentStatus](
	[EmploymentStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEmploymentStatus_EmploymentStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEmploymentStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEmploymentStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEmploymentStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEMServiceSite]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEMServiceSite](
	[EMServiceSiteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](10) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ANSICode] [varchar](10) NULL,
	[PlaceOfServiceID] [int] NOT NULL CONSTRAINT [DF_ListEMServiceSite_PlaceOfServiceID]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEMServiceSite_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEMServiceSite_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEMSystemBodyArea]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEMSystemBodyArea](
	[EMSystemBodyAreaUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEMSystemBodyArea_EMSystemBodyAreaUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEMSystemBodyArea_Inactive]  DEFAULT ((0)),
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEMSystemBodyArea_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEMSystemBodyArea_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEPSDTReferralCondIndicator]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEPSDTReferralCondIndicator](
	[EPSDTReferralCondIndicatorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEPSDTReferralCondIndicator_EPSDTReferralCondIndicatorUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEPSDTReferralCondIndicator_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEPSDTReferralCondIndicator_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEPSDTReferralCondIndicator_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListERACode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListERACode](
	[ERACodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListERACode_ERACodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Code] [varchar](30) NOT NULL,
	[Type] [varchar](25) NOT NULL,
	[StatementNote] [varchar](max) NULL,
	[InternalNote] [varchar](max) NULL,
	[Description] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListERACode_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListERACode_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ERACode_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListeRxIdentificationQualifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListeRxIdentificationQualifier](
	[eRxIdentificationQualifierUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListeRxIdentificationQualifier_eRxIdentificationQualifierUid]  DEFAULT (newid()),
	[ExternalID] [varchar](50) NULL,
	[Code] [varchar](50) NOT NULL,
	[XMLTag] [varchar](50) NOT NULL,
	[CodeName] [varchar](50) NOT NULL,
	[Name] [varchar](512) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListeRxIdentificationQualifier_Inactive]  DEFAULT ((0)),
	[ePrescribe] [bit] NOT NULL CONSTRAINT [DF_ListeRxIdentificationQualifier_ePrescribe]  DEFAULT ((0)),
	[QualifierType] [varchar](64) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListeRxIdentificationQualifier_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListeRxIdentificationQualifier_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListeRxMessageDenyReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListeRxMessageDenyReason](
	[eRxMessageDenyReasonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListeRxMessageDenyReason_eRxMessageDenyReasonUid]  DEFAULT (newid()),
	[ExternalID] [varchar](50) NULL,
	[VendorID] [varchar](50) NOT NULL,
	[Name] [varchar](200) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListeRxMessageDenyReason_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListeRxMessageDenyReason_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListeRxMessageDenyReason_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListeRxMessageType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListeRxMessageType](
	[eRxMessageTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListeRxMessageType_eRxMessageType]  DEFAULT (newid()),
	[ExternalID] [varchar](50) NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Tag] [varchar](50) NOT NULL,
	[TransactionType] [varchar](50) NOT NULL CONSTRAINT [DF_ListeRxMessageType_TransactionType]  DEFAULT ('SCRIPT'),
	[ProcessInboundAQN] [varchar](2048) NULL,
	[OutboundGeneratorAQN] [varchar](2048) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListeRxMessageType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListeRxMessageType_UserDefined]  DEFAULT ((1)),
	[RestrictTo] [int] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListeRxStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListeRxStatus](
	[eRxStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListeRxStatus_eRxStatusUid]  DEFAULT (newid()),
	[Name] [varchar](200) NOT NULL,
	[DisplayOrder] [tinyint] NOT NULL CONSTRAINT [DF_ListeRxStatus_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListeRxStatus_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListeRxStatus_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListEthnicity]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListEthnicity](
	[EthnicityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEthnicity_EthnicityUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEthnicity_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEthnicity_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEthnicity_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListExercise]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListExercise](
	[ExerciseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListExercise_ExerciseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListExercise_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListExercise_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListExercise_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFaxCoverSheet]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFaxCoverSheet](
	[FaxCoverSheetUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFaxCoverSheet_FaxCoverSheetUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[DocType] [varchar](10) NULL,
	[DocName] [varchar](100) NULL,
	[DocData] [varbinary](max) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFaxCoverSheet_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFaxCoverSheet_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFaxCoverSheet_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFaxCoverSheetGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFaxCoverSheetGroup](
	[FaxCoverSheetGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFaxServer]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFaxServer](
	[FaxServerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFaxServer_FaxServerUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](10) NOT NULL,
	[UserName] [varchar](100) NULL,
	[Password] [varchar](100) NULL,
	[DocType] [varchar](10) NULL,
	[DocName] [varchar](100) NULL,
	[DocData] [varbinary](max) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFaxServer_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFaxServer_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFaxServer_LastModifiedDate]  DEFAULT (getutcdate()),
	[AQN] [varchar](512) NULL,
	[ServiceURL] [varchar](200) NULL,
	[OrderActionTemplateXml] [xml] NULL,
	[OutboundFolder] [varchar](512) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFilter]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFilter](
	[FilterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFilter_FilterUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFilter_Inactive]  DEFAULT ((0)),
	[Type] [varchar](50) NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ReportParameters] [varchar](max) NULL,
	[Criteria] [varchar](max) NULL,
	[Sort] [varchar](max) NULL,
	[Columns] [varchar](max) NULL,
	[MaxRows] [int] NOT NULL CONSTRAINT [DF_ListFilter_MaxRows]  DEFAULT ((100)),
	[UserPRMUid] [uniqueidentifier] NULL,
	[JobScheduleUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFilter_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFilter_UserDefined]  DEFAULT ((1)),
	[AllowMaintenance] [bit] NOT NULL CONSTRAINT [DF_ListFilter_AllowMaintenance]  DEFAULT ((1)),
	[HasSecurity] [bit] NOT NULL CONSTRAINT [DF_ListFilter_HasSecurity]  DEFAULT ((1)),
	[SecurityGroupUid] [uniqueidentifier] NULL CONSTRAINT [DF_ListFilter_SecurityGroupUid]  DEFAULT ('C6BC91BD-C909-4193-813E-B20EFB696F2E'),
	[Notes] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFindTable]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFindTable](
	[FindTableUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEditor_ListEditorUid]  DEFAULT (newid()),
	[ExternalId] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[SecurityGroupUid] [uniqueidentifier] NULL,
	[Id] [varchar](50) NULL,
	[ShowInListEditor] [bit] NOT NULL CONSTRAINT [DF_ListEditor_ShowInListEditor]  DEFAULT ((1)),
	[LoadPriority] [smallint] NOT NULL CONSTRAINT [DF_ListFindTable_LoadPriority]  DEFAULT ((10)),
	[Prepopulate] [smallint] NOT NULL CONSTRAINT [DF_ListEditor_PrepopulateFind]  DEFAULT ((0)),
	[HasSecurity] [bit] NOT NULL CONSTRAINT [DF_ListFindTable_HasSecurity]  DEFAULT ((0)),
	[AllowMaintenance] [bit] NOT NULL CONSTRAINT [DF_ListEditor_AllowMaintenance]  DEFAULT ((1)),
	[AllowNew] [bit] NOT NULL CONSTRAINT [DF_ListFindTable_AllowNew]  DEFAULT ((1)),
	[AllowDelete] [smallint] NOT NULL CONSTRAINT [DF_ListFindTable_AllowDelete]  DEFAULT ((2)),
	[AllowImport] [bit] NOT NULL CONSTRAINT [DF_ListFindTable_AllowImport]  DEFAULT ((1)),
	[AllowExport] [bit] NOT NULL CONSTRAINT [DF_ListFindTable_AllowExport]  DEFAULT ((1)),
	[AllowHide] [bit] NOT NULL CONSTRAINT [DF_ListFindTable_AllowHide]  DEFAULT ((0)),
	[LimitMaintenanceOnNonUserDefined] [bit] NOT NULL CONSTRAINT [DF_ListFindTable_LimitMaintenanceOnNonUserDefined]  DEFAULT ((1)),
	[ExternalIdWildcard] [bit] NOT NULL CONSTRAINT [DF_ListFindTable_ExternalIdWildcard]  DEFAULT ((1)),
	[BeginningWildcard] [bit] NOT NULL CONSTRAINT [DF_ListEditor_BegininngWildcard]  DEFAULT ((0)),
	[SizableFindDialog] [bit] NOT NULL CONSTRAINT [DF_ListEditor_SizableDialog]  DEFAULT ((1)),
	[BusinessObjectRequired] [bit] NOT NULL CONSTRAINT [DF_ListFindTable_BusinessObjectRequired]  DEFAULT ((1)),
	[LoadStoredProcedure] [varchar](255) NULL,
	[CustomDBAccessClassName] [varchar](255) NULL,
	[FindControlClass] [varchar](255) NULL,
	[EditFormType] [varchar](255) NULL,
	[BusinessObject] [varchar](255) NULL,
	[BusinessObjectSpans] [varchar](255) NULL,
	[EditBusinessObject] [varchar](255) NULL,
	[ExportBusinessObjectList] [varchar](max) NULL,
	[SaveAsBusinessObject] [varchar](255) NULL,
	[MaxRows] [int] NOT NULL CONSTRAINT [DF_ListEditor_MaxRows]  DEFAULT ((-1)),
	[Columns] [xml] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEditor_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFindTable_UserDefined]  DEFAULT ((1)),
	[AuditTableName] [varchar](50) NULL,
	[AddInUid] [uniqueidentifier] NULL,
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEditor_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MapMerge] [bit] NOT NULL CONSTRAINT [DF_ListFindTable_MapMerge]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormattingTemplate]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormattingTemplate](
	[FormattingTemplateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFormattingTemplate_FormattingTemplateUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormattingTemplate_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[RootObjectType] [varchar](256) NULL,
	[Template] [varchar](max) NULL,
	[TemplateParameters] [varchar](max) NULL,
	[FieldParameters] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[RequireAudit] [bit] NOT NULL CONSTRAINT [DF_ListFormattingTemplate_RequireAudit]  DEFAULT ((0)),
	[QualifiesAsClinicalSummary] [bit] NOT NULL CONSTRAINT [DF_ListFormattingTemplate_QualifiesAsClinicalSummary]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormattingTemplate_UserDefined]  DEFAULT ((1)),
	[IsTextCompatible] [bit] NOT NULL CONSTRAINT [DF_ListFormattingTemplate_IsTextCompatible]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormattingTemplate_LastModifiedDate]  DEFAULT (getutcdate()),
	[AuxiliaryLinkToPrimaryFormattingTemplateUid] [uniqueidentifier] NULL,
	[IsPersonNotification] [bit] NOT NULL CONSTRAINT [DF_ListFormattingTemplate_IsPersonNotification]  DEFAULT ((0)),
	[IsPersonNotificationConfigured] [bit] NOT NULL CONSTRAINT [DF_ListFormattingTemplate_IsPersonNotificationConfigured]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormLayout]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormLayout](
	[FormLayoutUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListFormLayout_FormLayoutUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormLayout_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormLayout_UserDefined]  DEFAULT ((1)),
	[UIControlUid] [uniqueidentifier] NOT NULL,
	[Data] [xml] NULL,
	[RequireDataTag] [bit] NOT NULL CONSTRAINT [DF_ListFormLayout_RequireDataTag]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[AllowMulti] [bit] NOT NULL CONSTRAINT [DF_ListFormLayout_AllowMulti]  DEFAULT ((0)),
	[TitleDefinition] [varchar](2048) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormLayout_LastModifiedDate]  DEFAULT (getutcdate()),
	[Abbreviation] [varchar](3) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormLayoutControlAction]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormLayoutControlAction](
	[FormLayoutControlActionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table_1_FormLayoutActionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormLayoutControlAction_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormLayoutControlAction_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormLayoutControlAction_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormLayoutControlActionEvent]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormLayoutControlActionEvent](
	[FormLayoutControlActionEventUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFormLayoutControlActionEvent_FormLayoutControlActionEventUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormLayoutControlActionEvent_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormLayoutControlActionEvent_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormLayoutControlActionEvent_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormTemplateType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormTemplateType](
	[FormTemplateTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormTitle]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormTitle](
	[FormTitleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFormTitle_FormTitleUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Columns] [xml] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormTitle_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormTitle_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormTitle_UserDefined]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFundType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFundType](
	[FundTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](2) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListGender]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListGender](
	[GenderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListGender_GenderUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListGender_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListGender_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListGender_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListGenderIdentity]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListGenderIdentity](
	[GenderIdentityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListGenderIdentity_GenderIdentityUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListGenderIdentity_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListGenderIdentity_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListGenderIdentity_LastModifiedDate]  DEFAULT (getutcdate()),
	[conceptId] [varchar](100) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListGeneralNote]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListGeneralNote](
	[GeneralNoteUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListGeneralNote_GeneralNoteUid]  DEFAULT (newid()),
	[GeneralNoteTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListGeneralNote_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListGeneralNote_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListGeneralNote_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListGeneralNoteType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListGeneralNoteType](
	[GeneralNoteTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListGeneralNoteType_GeneralNoteTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListGeneralNoteType_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListGeneralNoteType_UserDefined]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListGeneralNoteType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListGraphicNote]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListGraphicNote](
	[GraphicNoteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListGraphicNote_GraphicNoteUid]  DEFAULT (newid()),
	[AttachmentContent] [varbinary](max) NULL,
	[AttachmentContentType] [varchar](50) NULL,
	[AttachmentContentSize] [int] NULL,
	[ThumbnailAttachmentContent] [varbinary](max) NULL,
	[ThumbnailAttachmentContentType] [varchar](50) NULL,
	[DefaultIncludeInSummary] [bit] NOT NULL CONSTRAINT [DF_ListGraphicNote_DefaultIncludeInSummary]  DEFAULT ((0)),
	[FilePath] [varchar](255) NULL,
	[FileName] [varchar](100) NULL,
	[FileExtension] [varchar](10) NULL,
	[FileDate] [datetime] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListGraphicNote_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListGraphicNote_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListGraphicNote_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListGrowthChart]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListGrowthChart](
	[GrowthChartUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListGrowthChart_GrowthChartUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListGrowthChart_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Female] [bit] NOT NULL CONSTRAINT [DF_ListGrowthChart_Female]  DEFAULT ((0)),
	[Male] [bit] NOT NULL CONSTRAINT [DF_ListGrowthChart_Male]  DEFAULT ((0)),
	[AgeRangeUnit] [tinyint] NOT NULL CONSTRAINT [DF_ListGrowthChart_AgeRangeUnit]  DEFAULT ((1)),
	[AgeRangeMin] [int] NOT NULL CONSTRAINT [DF_ListGrowthChart_AgeRangeMin]  DEFAULT ((0)),
	[AgeRangeMax] [int] NOT NULL CONSTRAINT [DF_ListGrowthChart_AgeRangeMax]  DEFAULT ((36)),
	[VitalType] [int] NOT NULL CONSTRAINT [DF_ListGrowthChart_VitalType]  DEFAULT ((0)),
	[ShowSmooth] [bit] NOT NULL CONSTRAINT [DF_ListGrowthChart_ShowSmooth]  DEFAULT ((0)),
	[ShowLine] [bit] NOT NULL CONSTRAINT [DF_ListGrowthChart_ShowLine]  DEFAULT ((1)),
	[PlotingColor] [int] NOT NULL CONSTRAINT [DF_ListGrowthChart_PlotingColor]  DEFAULT ((-65536)),
	[PlotLeft] [int] NOT NULL CONSTRAINT [DF_ListGrowthChart_PlotLeft]  DEFAULT ((0)),
	[PlotTop] [int] NOT NULL CONSTRAINT [DF_ListGrowthChart_PlotTop]  DEFAULT ((0)),
	[PlotWidth] [int] NOT NULL CONSTRAINT [DF_ListGrowthChart_PlotWidth]  DEFAULT ((0)),
	[PlotHeight] [int] NOT NULL CONSTRAINT [DF_ListGrowthChart_PlotHeight]  DEFAULT ((0)),
	[GrowthChartImage] [varbinary](max) NULL,
	[GrowthChartImageType] [varchar](50) NULL,
	[GrowthChartImageSize] [int] NULL,
	[XAxisUnit] [tinyint] NOT NULL CONSTRAINT [DF_ListGrowthChart_XAxisUnit]  DEFAULT ((1)),
	[XAxisMax] [real] NULL,
	[XAxisMin] [real] NULL,
	[YAxisUnit] [tinyint] NOT NULL CONSTRAINT [DF_ListGrowthChart_YAxisUnit]  DEFAULT ((1)),
	[YAxisMax] [real] NULL,
	[YAxisMin] [real] NULL,
	[MasterGrowthChartDataType] [varchar](30) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListGrowthChart_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListGrowthChart_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHEDIS]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHEDIS](
	[HEDISUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListHEDIS_HEDISUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](4000) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DomainDescription] [varchar](4000) NULL,
	[SubDomainDescription] [varchar](4000) NULL,
	[HEDISCode] [varchar](255) NULL,
	[MeasureProcedure] [varchar](255) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHEDIS_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHEDIS_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHEDIS_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHiddenUserObjects]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHiddenUserObjects](
	[RowUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ObjectUid] [uniqueidentifier] NOT NULL,
	[ObjectTableName] [varchar](255) NULL,
	[ObjectUserUid] [uniqueidentifier] NOT NULL,
	[ObjectUserName] [varchar](1000) NULL,
	[IsHidden] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHIPAAReleaseInfo]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHIPAAReleaseInfo](
	[HIPAAReleaseInfoUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_HIPAAReleaseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHistorian]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHistorian](
	[HistorianUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHistorian_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHistorian_LastModifiedDate]  DEFAULT (getdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHistorian_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHistoryGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHistoryGroup](
	[HistoryGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListHistoryGroup_HistoryGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[QuestionHeader] [varchar](15) NULL,
	[AnswerHeader] [varchar](15) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHistoryGroup_Inactive]  DEFAULT ((0)),
	[RequireDateField] [bit] NOT NULL CONSTRAINT [DF_ListHistoryGroup_RequireDateField]  DEFAULT ((0)),
	[RequireStatusField] [bit] NOT NULL CONSTRAINT [DF_ListHistoryGroup_RequireStatusField]  DEFAULT ((0)),
	[AllowDuplicate] [bit] NOT NULL CONSTRAINT [DF_ListHistoryGroup_AllowDuplicate]  DEFAULT ((0)),
	[UseDiseases] [bit] NOT NULL CONSTRAINT [DF_ListHistoryGroup_UseDiseases]  DEFAULT ((0)),
	[UseTree] [bit] NOT NULL CONSTRAINT [DF_ListHistoryGroup_UseTree_1]  DEFAULT ((1)),
	[CanAcceptCPT] [bit] NOT NULL CONSTRAINT [DF_ListHistoryGroup_CanAcceptCPT]  DEFAULT ((0)),
	[ResultsAQN] [varchar](255) NULL,
	[GroupTypeID] [smallint] NOT NULL CONSTRAINT [DF_ListHistoryGroup_GroupTypeID]  DEFAULT ((1)),
	[ClassTypeID] [smallint] NOT NULL CONSTRAINT [DF_ListHistoryGroup_ClassTypeID]  DEFAULT ((0)),
	[DisplayTypeID] [smallint] NOT NULL CONSTRAINT [DF_ListHistoryGroup_DisplayTypeID]  DEFAULT ((1)),
	[StatusTypeID] [smallint] NOT NULL CONSTRAINT [DF_ListHistoryGroup_StatusTypeID]  DEFAULT ((0)),
	[SortTypeID] [smallint] NOT NULL CONSTRAINT [DF_ListHistoryGroup_SortTypeID]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHistoryGroup_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListHistoryGroup_DisplayOrder]  DEFAULT ((0)),
	[AnswerGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[ObservationDefaultSettingUid] [uniqueidentifier] NULL,
	[DeniesQuestionUid] [uniqueidentifier] NULL,
	[RequiredQuestionUid] [uniqueidentifier] NULL,
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHistoryGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHMRule]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHMRule](
	[HMRuleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListHMRule_HMRuleUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[AgeFrom] [int] NOT NULL CONSTRAINT [DF_ListHMRule_AgeFrom]  DEFAULT ((0)),
	[AgeTo] [int] NOT NULL CONSTRAINT [DF_ListHMRule_AgeTo]  DEFAULT ((0)),
	[AgeTimeTypeUid] [uniqueidentifier] NULL,
	[RuleState] [char](2) NULL,
	[RecurFrom] [smallint] NOT NULL CONSTRAINT [DF_ListHMRule_RecurFrom]  DEFAULT ((0)),
	[RecurTo] [smallint] NOT NULL CONSTRAINT [DF_ListHMRule_RecurTo]  DEFAULT ((0)),
	[RecurTimeTypeUid] [uniqueidentifier] NULL,
	[LimitRecurrences] [bit] NOT NULL CONSTRAINT [DF_ListHMRule_LimitRecurrences]  DEFAULT ((0)),
	[MaxRecurrence] [int] NOT NULL CONSTRAINT [DF_ListHMRule_MaxRecurrence]  DEFAULT ((0)),
	[AdvanceWarning] [int] NOT NULL CONSTRAINT [DF_ListHMRule_AdvanceWarning]  DEFAULT ((0)),
	[AdvanceWarningTimeTypeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[AlertText] [varchar](max) NULL,
	[AlertAcknowledgedDate] [datetime] NULL,
	[FollowVaccineSchedule] [bit] NOT NULL CONSTRAINT [DF_ListHMRule_FollowVaccineSchedule_1]  DEFAULT ((0)),
	[IsReportPreventativeFollowup] [bit] NOT NULL CONSTRAINT [DF_ListHMRule_IsReportPreventativeFollowup]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHMRule_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHMRule_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHMRule_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ReferenceURL] [varchar](500) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHMRuleDeclineReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHMRuleDeclineReason](
	[MHRuleDeclineReasonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListHMRuleDeclineReason_MHRuleDeclineReasonUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHMRuleDeclineReason_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHMRuleDeclineReason_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHMRuleDeclineReason_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHpi]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHpi](
	[HpiUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListHpi_HpiUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHpi_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHpi_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHpi_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHpiCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHpiCategory](
	[HpiCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListHpiCategory_HpiCategoryUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHpiCategory_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[HpiCategoryTypeUid] [uniqueidentifier] NULL,
	[NaturalLanguage] [varchar](100) NULL,
	[AllowImprove] [bit] NOT NULL CONSTRAINT [DF_ListHpiCategory_AllowImprove]  DEFAULT ((0)),
	[AllowWorsen] [bit] NOT NULL CONSTRAINT [DF_ListHpiCategory_AllowWorsen]  DEFAULT ((0)),
	[AllowUnchange] [bit] NOT NULL CONSTRAINT [DF_ListHpiCategory_AllowUnchange]  DEFAULT ((0)),
	[AllowResolve] [bit] NOT NULL CONSTRAINT [DF_ListHpiCategory_AllowResolve]  DEFAULT ((0)),
	[PositiveNegative] [bit] NOT NULL CONSTRAINT [DF_ListHpiCategory_PositiveNegative_1]  DEFAULT ((0)),
	[PositivePrefix] [varchar](50) NULL,
	[NegativePrefix] [varchar](50) NULL,
	[BoldFinding] [smallint] NOT NULL CONSTRAINT [DF_ListHpiCategory_BoldFinding_1]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHpiCategory_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHpiCategory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHpiCategoryType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHpiCategoryType](
	[HpiCategoryTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListHpiCategoryType_HpiCategoryTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHpiCategoryType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHpiCategoryType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHpiCategoryType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListHxRelationship]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListHxRelationship](
	[HxRelationshipUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListHxRelationship_HxRelationshipUid]  DEFAULT (newid()),
	[DegreeRelatedUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[AllowMaternalPaternal] [bit] NOT NULL CONSTRAINT [DF_ListHxRelationship_AllowMaternalPaternal]  DEFAULT ((0)),
	[AllowMultipleUsage] [bit] NOT NULL CONSTRAINT [DF_ListHxRelationship_AllowMultipleUsage]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[MaternalSnomedConceptID] [varchar](50) NULL,
	[MaternalDescriptionUid] [uniqueidentifier] NULL,
	[PaternalSnomedConceptID] [varchar](50) NULL,
	[PaternalDescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHxRelationship_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHxRelationship_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHxRelationship_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListImmzCompletion]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListImmzCompletion](
	[ImmzCompletionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListImmzCompletion_ImmzCompletionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Code] [varchar](50) NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListImmzCompletion_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListImmzCompletion_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListImmzCompletion_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListImmzCompletion_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListImmzContraindication]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListImmzContraindication](
	[ImmzContraindicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListImmzContraindication_ImmzContraindicationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[ConceptCode] [varchar](200) NULL,
	[ConceptName] [varchar](255) NULL,
	[Definition] [varchar](255) NULL,
	[HL7Table0396Code] [varchar](200) NULL,
	[V231_NIP004] [varchar](100) NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListImmzContraindication_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListImmzContraindication_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListImmzContraindication_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListImmzContraindication_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListImmzEvidenceOfImmunity]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListImmzEvidenceOfImmunity](
	[ImmzEvidenceOfImmunityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListImmzEvidenceOfImmunity_ImmzEvidenceOfImmunityUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[ConceptCode] [varchar](200) NULL,
	[ConceptName] [varchar](255) NULL,
	[Definition] [varchar](255) NULL,
	[HL7Table0396Code] [varchar](200) NULL,
	[V231_NIP004] [varchar](100) NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListImmzEvidenceOfImmunity_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListImmzEvidenceOfImmunity_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListImmzEvidenceOfImmunity_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListImmzEvidenceOfImmunity_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListImmzHistorySource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListImmzHistorySource](
	[ImmzHistorySourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListImmzHistorySource_ImmzHistorySourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Code] [varchar](50) NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListImmzHistorySource_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListImmzHistorySource_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListImmzHistorySource_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListImmzHistorySource_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListImmzReaction]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListImmzReaction](
	[ImmzReactionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[ConceptCode] [varchar](200) NULL,
	[ConceptName] [varchar](255) NULL,
	[Definition] [varchar](255) NULL,
	[HL7Table0396Code] [varchar](200) NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListImmzReaction_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListImmzReaction_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListImmzReaction_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListImmzReaction_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListImmzRefusal]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListImmzRefusal](
	[ImmzRefusalUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListImmzRefusal_ImmzRefusalUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Code] [varchar](50) NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListImmzRefusal_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListImmzRefusal_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListImmzRefusal_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListImmzRefusal_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListImmzReminderRecall]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListImmzReminderRecall](
	[ImmzReminderRecallUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListImmzReminderRecall_ImmzReminderRecallUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Code] [varchar](50) NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListImmzReminderRecall_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListImmzReminderRecall_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListImmzReminderRecall_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListImmzReminderRecall_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListImmzSpecialIndications]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListImmzSpecialIndications](
	[ImmzSpecialIndicationsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListImmzSpecialIndications_ImmzSpecialIndicationsUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[ConceptCode] [varchar](200) NULL,
	[ConceptName] [varchar](255) NULL,
	[Definition] [varchar](255) NULL,
	[HL7Table0396Code] [varchar](200) NULL,
	[V231_NIP004] [varchar](100) NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListImmzSpecialIndications_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListImmzSpecialIndications_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListImmzSpecialIndications_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListImmzSpecialIndications_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListIndustry]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListIndustry](
	[IndustryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListIndustry_IndustryUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListIndustry_Inactive]  DEFAULT ((0)),
	[Name] [varchar](max) NOT NULL,
	[IndustryCode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListIndustry_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListIndustry_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListInstantMessageServer]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListInstantMessageServer](
	[InstantMessageServerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Server] [varchar](255) NOT NULL,
	[Port] [int] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListInstantMessageStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListInstantMessageStatus](
	[InstantMessageStatusUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListInstantMessageStatus_InstantMessageStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListInstantMessageStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListInstantMessageStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListInstantMessageStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListInsuranceGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListInsuranceGroup](
	[InsuranceGroupUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListInsuranceLevelName]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListInsuranceLevelName](
	[InsuranceLevelNameUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListInsuranceLevelName_InsuranceLevelNameUid]  DEFAULT (newid()),
	[InsuranceLevel] [int] NOT NULL,
	[InsuranceLevelName] [varchar](10) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListInsuranceLevelName_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListInsuranceLevelName_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListInsuranceLevelName_LastModifiedDateDesc]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListIntegrationPartner]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListIntegrationPartner](
	[IntegrationPartnerUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ListIntegrationPartner]  DEFAULT (newid()),
	[Name] [varchar](250) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[FieldsEditorControlAQN] [varchar](512) NULL,
	[ActivationHandlerAQN] [varchar](512) NULL,
	[AdditionalOutboundXML] [varchar](max) NULL,
	[Notes] [text] NULL,
	[TestMode] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_TestMode]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_UserDefined]  DEFAULT ((1)),
	[OrganizationEditAQN] [varchar](512) NULL,
	[ProviderEditAQN] [varchar](512) NULL,
	[OrganizationEditDeleteAllowed] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_OrganizationEditDeleteAllowed]  DEFAULT ((0)),
	[ProviderEditDeleteAllowed] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ProviderEditDeleteAllowed]  DEFAULT ((0)),
	[SearchAvailable] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_DirectoryAvailable]  DEFAULT ((0)),
	[ConsentStatus] [smallint] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ConsentStatus]  DEFAULT ((2)),
	[ConsentRequired] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ConsentRequired]  DEFAULT ((0)),
	[ConsentSharingProtection] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ConsentSharingProtection]  DEFAULT ((0)),
	[UsesApi] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_UsesApi]  DEFAULT ((0)),
	[AllowApiUse] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_AllowApiUse]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListIntegrationPartnerType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListIntegrationPartnerType](
	[IntegrationPartnerUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListIntegrationPartnerType_IntegrationPartnerTypeUid]  DEFAULT (newid()),
	[Name] [varchar](250) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartnerType_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListIntegrationPartnerType_UserDefined]  DEFAULT ((1)),
	[InterfaceDetail] [xml] NULL,
	[UIAQN] [varchar](1024) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListIntegrationPartnerType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListInterfaceBusinessObject]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListInterfaceBusinessObject](
	[InterfaceBusinessObjectUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table1_GenderUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListInterfaceBusinessObject_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[BusinessObject] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListInterfaceBusinessObject_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListInterfaceBusinessObject_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListJob]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListJob](
	[JobUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListJob_JobUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](256) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListJob_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[AssemblyQualifiedName] [varchar](1024) NOT NULL,
	[UIAssemblyQualifiedName] [varchar](1024) NULL,
	[NotifyOnSuccess] [bit] NOT NULL CONSTRAINT [DF_ListJob_NotifyOnSuccess]  DEFAULT ((0)),
	[NotifyOnFailure] [bit] NOT NULL CONSTRAINT [DF_ListJob_NotifyOnFailure]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListJob_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListJob_UserDefined]  DEFAULT ((1)),
	[MemberUserUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListJobScheduleTimeBase]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListJobScheduleTimeBase](
	[JobScheduleTimeBaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListJobScheduleTimeBase_JobScheduleTimeBaseUid]  DEFAULT (newid()),
	[Name] [varchar](50) NULL,
	[EnumName] [varchar](50) NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListJobScheduleTimeBase_Inactive]  DEFAULT ((0)),
	[Value] [int] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListJobScheduleTimeBase_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListJobScheduleTimeBase_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListKdbConfiguration]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListKdbConfiguration](
	[KdbConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_KDBSettingsUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListKdbConfiguration_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListKdbConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListKdbConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListLabBillCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListLabBillCode](
	[LabBillCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[InsurancePlanUid] [uniqueidentifier] NOT NULL,
	[HL7PartnerUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListLaboratory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListLaboratory](
	[LaboratoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListLaboratory_LaboratoryUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListLaboratory_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListLaboratory_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListLaboratory_UserDefined]  DEFAULT ((1)),
	[Req] [bit] NOT NULL CONSTRAINT [DF_ListLaboratory_Req]  DEFAULT ((0)),
	[ReportUid] [uniqueidentifier] NULL,
	[SpecimenLabelUid] [uniqueidentifier] NULL,
	[BillCodeRequiredFlag] [bit] NOT NULL CONSTRAINT [DF_ListLaboratory_BillCodeRequiredFlag]  DEFAULT ((0)),
	[AllowCancelOrders] [bit] NOT NULL CONSTRAINT [DF_ListLaboratory_AllowCancelOrders]  DEFAULT ((0)),
	[SendFutureOrders] [bit] NOT NULL CONSTRAINT [DF_ListLaboratory_SendFutureOrders]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListLaboratoryOrder]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListLaboratoryOrder](
	[LaboratoryOrderUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListLaboratoryOrder_ListLaboratoryOrders]  DEFAULT (newid()),
	[LaboratoryUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListLaboratoryOrder_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LabOrderCode] [varchar](25) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListLaboratoryOrder_UserDefined]  DEFAULT ((1)),
	[CPTList] [varchar](8000) NULL,
	[Instructions] [varchar](max) NULL,
	[LaboratoryDataXml] [varchar](max) NULL,
	[AutoSendOrder] [bit] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListLaboratoryOrder_LastModifiedDate]  DEFAULT (getutcdate()),
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[LaboratoryOrderFormUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListLabSource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListLabSource](
	[LabSourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListLanguage]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListLanguage](
	[LanguageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListLanguage_LanguageUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Code] [varchar](50) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListLanguage_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListLanguage_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListLanguage_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListLetter]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListLetter](
	[LetterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[AttachmentGroupUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListLetterModel]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListLetterModel](
	[LetterModelUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListLetterModel_LetterModelUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListLetterModel_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListLetterModel_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListLetterModel_LastModifiedDate_1]  DEFAULT (getutcdate()),
	[Path] [varchar](250) NULL,
	[AttachmentGroupUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListLOINC]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListLOINC](
	[LOINCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListLOINC_LOINCUid]  DEFAULT (newid()),
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListLOINC_Inactive]  DEFAULT ((0)),
	[COMPONENT] [varchar](150) NOT NULL,
	[SYSTEM] [varchar](100) NULL,
	[CLASS] [varchar](50) NULL,
	[STATUS] [varchar](50) NULL,
	[MAP_TO] [varchar](50) NULL,
	[EX_US_UNITS] [varchar](50) NULL,
	[RelatedNames2] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListLOINC_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListLOINC_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMaritalStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMaritalStatus](
	[MaritalStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMaritalStatus_MaritalStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMaritalStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMaritalStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMaritalStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMeasurementQualifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMeasurementQualifier](
	[MeasurementQualifierUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_GenderUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMeasurementQualifier_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMeasurementQualifier_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMeasurementQualifier_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicalDeviceStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicalDeviceStatus](
	[MedicalDeviceStatusUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListPatientMedicalDeviceStatus_PatientMedicalDeviceStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPatientMedicalDeviceStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPatientMedicalDeviceStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPatientMedicalDeviceStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicalServicesType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicalServicesType](
	[MedicalServicesTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicalServicesType_MedicalServicesTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicalServicesType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMedicalServicesType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMedicalServicesType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicareSecondaryReasonCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicareSecondaryReasonCode](
	[MedicareSecondaryReasonCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicareSecondaryReasonCode_MedicareSecondaryReasonCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicareSecondaryReasonCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](150) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMedicareSecondaryReasonCode_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMedicareSecondaryReasonCode_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedication]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedication](
	[MedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedication_MedicationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[descdisplay] [varchar](125) NULL,
	[descsearch] [varchar](125) NULL,
	[RouteUid] [uniqueidentifier] NULL,
	[DoseFormUid] [uniqueidentifier] NULL,
	[Strength] [varchar](255) NULL,
	[StrengthUnits] [varchar](255) NULL,
	[RxNorm] [varchar](255) NULL,
	[RxNormQualifier] [varchar](10) NULL,
	[NDC] [varchar](11) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedication_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMedication_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMedication_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[medid] [int] NOT NULL CONSTRAINT [DF_ListMedication_medid]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationCategory](
	[MedicationCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationCategory_MedicationCategoryUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationCategory_Inactive]  DEFAULT ((0)),
	[Name] [varchar](20) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_MedicationCategory_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MedicationCategory_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MedicationCategory_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationDay]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationDay](
	[MedicationDayUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationDay_MedicationDayUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListMedicationDay_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMedicationDay_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationDay_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationFrequency]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationFrequency](
	[MedicationFrequencyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationFrequency_MedicationFrequencyUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationFrequency_Inactive]  DEFAULT ((0)),
	[Name] [varchar](20) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ProfessionalInstructions] [varchar](250) NULL,
	[PatientInstructions] [varchar](250) NULL,
	[PrescriptionText] [varchar](20) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListMedicationFrequency_DisplayOrder]  DEFAULT ((0)),
	[DosesPerDay] [money] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MedicationFrequency_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MedicationFrequency_UserDefined]  DEFAULT ((1)),
	[NumericValue] [int] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[InstructionsType] [tinyint] NOT NULL CONSTRAINT [DF_ListMedicationFrequency_SigTimingType]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationFundingSource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationFundingSource](
	[MedicationFundingSourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationFundingSource_MedicationFundingSourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListMedicationFundingSource_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMedicationFundingSource_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationFundingSource_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationMfr]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationMfr](
	[MedicationMfrUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationPRNReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationPRNReason](
	[MedicationPRNReasonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationPRNReason_MedicationPRNReasonUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationPRNReason_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MedicationPRNReason_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MedicationPRNReason_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationRefill]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationRefill](
	[MedicationRefillUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationRefill_MedicationRefillUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListMedicationRefill_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMedicationRefill_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationRefill_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationRoute]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationRoute](
	[MedicationRouteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationRoute_MedicationRouteUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationRoute_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ProfessionalInstructions] [varchar](250) NULL,
	[PatientInstructions] [varchar](250) NULL,
	[PrescriptionText] [varchar](20) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListMedicationRoute_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MedicationRoute_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MedicationRoute_UserDefined]  DEFAULT ((1)),
	[SnomedConceptID] [varchar](50) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationSite]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationSite](
	[MedicationSiteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationSite_MedicationSiteUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListMedicationSite_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMedicationSite_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationSite_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationStateScheduled]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationStateScheduled](
	[MedicationStateScheduledUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[State] [varchar](3) NOT NULL,
	[Schedule] [tinyint] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [text] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationStatus](
	[MedicationStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMedicationUnit]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMedicationUnit](
	[MedicationUnitUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationUnit_MedicationUnitUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationUnit_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ProfessionalInstructions] [varchar](250) NULL,
	[PatientInstructions] [varchar](250) NULL,
	[PrescriptionText] [varchar](20) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListMedicationUnit_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MedicationUnit_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MedicationUnit_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMessageRouting]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMessageRouting](
	[MessageRoutingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMessageRouting_MessageRoutingUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](250) NULL,
	[RoutingUserXML] [xml](CONTENT [UidList]) NULL,
	[RoutingUserGroupXML] [xml](CONTENT [UidList]) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMessageRouting_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMessageRouting_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMessageRouting_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMessageStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMessageStatus](
	[MessageStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageStatus_MessageStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_AppointmentStatus_IsEnabled]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListMessageStatus_DisplayOrder]  DEFAULT ((0)),
	[ReadOnly] [bit] NOT NULL CONSTRAINT [DF_AppointmentStatus_IsEditable]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMessageStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMessageSubType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMessageSubType](
	[MessageSubTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageSubType_MessageSubTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMessageSubType_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMessageSubType_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageSubType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[MessageTypeUid] [uniqueidentifier] NULL,
	[Color] [int] NOT NULL CONSTRAINT [DF_ListMessageSubType_Color]  DEFAULT ((0)),
	[ConfigurationXML] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMessageType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMessageType](
	[MessageTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageType_MessageTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMessageType_Inactive]  DEFAULT ((0)),
	[CompleteInMinutes] [int] NULL,
	[Notes] [varchar](max) NULL,
	[Color] [int] NOT NULL CONSTRAINT [DF_ListMessageType_Color]  DEFAULT ((0)),
	[AssemblyQualifiedName] [varchar](255) NOT NULL,
	[HeaderAQN] [varchar](255) NULL,
	[TabPagesAQN] [xml] NULL,
	[AQN] [xml](CONTENT [ListMessageTypeAQN]) NULL,
	[ConfigurationXML] [xml] NULL,
	[MessageDataXMLType] [varchar](100) NULL,
	[LoadStoredProcedure] [varchar](255) NULL,
	[UserCreatable] [bit] NOT NULL CONSTRAINT [DF_ListMessageType_UserCreatable]  DEFAULT ((1)),
	[PatientNewMenu] [bit] NOT NULL CONSTRAINT [DF_ListMessageType_PatientNewMenu]  DEFAULT ((0)),
	[IconIndex] [smallint] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMessageType_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListMessageType_DisplayOrder]  DEFAULT ((0)),
	[OrderActionTemplateXml] [xml] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMessageUrgency]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMessageUrgency](
	[MessageUrgencyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMessageUrgency_MessageUrgencyUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMessageUrgency_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Color] [int] NOT NULL CONSTRAINT [DF_ListMessageUrgency_Color]  DEFAULT ((0)),
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListMessageUrgency_DisplayOrder]  DEFAULT ((1)),
	[UrgentTypeID] [smallint] NULL CONSTRAINT [DF_ListMessageUrgency_UrgentTypeID]  DEFAULT ((2)),
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_ListMessageUrgency_IsDefault]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMessageUrgency_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMessageUrgency_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListMisc]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListMisc](
	[MiscUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMisc_MiscUid]  DEFAULT (newid()),
	[Name] [varchar](50) NOT NULL,
	[Val] [varchar](50) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListMisc_DisplayOrder]  DEFAULT ((0)),
	[ListType] [varchar](50) NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMisc_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMisc_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListNameFormat]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListNameFormat](
	[NameFormatUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListNameFormat_NameFormatUid]  DEFAULT (newid()),
	[NameFormatTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNameFormat_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NULL CONSTRAINT [DF_ListNameFormat_UserDefined]  DEFAULT ((1)),
	[NameFormat] [varchar](255) NULL,
	[TemplateProperties] [xml] NULL,
	[ValidationType] [smallint] NOT NULL CONSTRAINT [DF_ListNameFormat_ValidationType]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListNameFormat_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListNameFormatType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListNameFormatType](
	[NameFormatTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListNameFormatType_NameFormatTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[BusinessObject] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNameFormatType_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNameFormatType_UserDefined]  DEFAULT ((0)),
	[TypeProperties] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListNameFormatType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListNDCUnitMeasure]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListNDCUnitMeasure](
	[NDCUnitMeasureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListNDCUnitMeasure_NDCUnitMeasureUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNDCUnitMeasure_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNDCUnitMeasure_UserDefined]  DEFAULT ((1)),
	[ANSICode] [varchar](10) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListNDCUnitMeasure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListNegationReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListNegationReason](
	[NegationReasonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListNegationReason_NegationReasonUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNegationReason_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNegationReason_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListNegationReason_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListNoteFilter]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListNoteFilter](
	[NoteFilterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVisitNoteFilter_VisitNoteFilterUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVisitNoteFilter_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVisitNoteFilter_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[ShowIncomplete] [bit] NOT NULL CONSTRAINT [DF_ListNoteFilter_ShowIncomplete]  DEFAULT ((1)),
	[IncompleteScheduled] [bit] NOT NULL CONSTRAINT [DF_ListNoteFilter_IncompleteScheduled]  DEFAULT ((1)),
	[IncompleteLastModified] [bit] NOT NULL CONSTRAINT [DF_ListNoteFilter_IncompleteLastModified]  DEFAULT ((0)),
	[ShowApproval] [bit] NOT NULL CONSTRAINT [DF_ListNoteFilter_ShowApproval]  DEFAULT ((0)),
	[ApprovalStatus] [bit] NULL CONSTRAINT [DF_ListNoteFilter_ApprovalStatus]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNoteFilter_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListNotificationMethod]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListNotificationMethod](
	[NotificationMethodUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListNotificationMethod_NotificationMethodUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNotificationMethod_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNotificationMethod_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListNotificationMethod_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListObjectType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListObjectType](
	[ObjectTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ObjectType] [varchar](25) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListObservation]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListObservation](
	[ObservationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListObservation_ObservationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListObservation_Inactive]  DEFAULT ((0)),
	[ObservationTypeID] [smallint] NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LaboratoryUnitCode] [varchar](16) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[LaboratoryOrderUid] [uniqueidentifier] NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListObservation_UserDefined]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListObservation_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListObservationCustomUser]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListObservationCustomUser](
	[ObservationCustomUserUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListObservationCustomUser_ObservationCustomUserUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListObservationCustomUser_Inactive]  DEFAULT ((0)),
	[Name] [varchar](20) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IncludeDividingLine] [bit] NOT NULL CONSTRAINT [DF_ListObservationCustomUser_IncludeDividingLine]  DEFAULT ((1)),
	[ProviderUid] [uniqueidentifier] NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListObservationCustomUser_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListObservationCustomUser_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListObservationDefaultSetting]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListObservationDefaultSetting](
	[ObservationDefaultSettingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](50) NULL,
	[Name] [varchar](50) NOT NULL,
	[DisplayMetricValues] [bit] NOT NULL CONSTRAINT [DF_ListObservationDefaultSetting_DisplayMetricValues]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[MaxRows] [int] NOT NULL CONSTRAINT [DF_ListObservationDefaultSetting_MaxRows]  DEFAULT ((100)),
	[ReviewUnitOption] [int] NOT NULL CONSTRAINT [DF_ListObservationDefaultSetting_ReviewUnitOption]  DEFAULT ((0)),
	[WithPercent] [bit] NOT NULL CONSTRAINT [DF_ListObservationDefaultSetting_WithPercent]  DEFAULT ((0)),
	[UseWHO] [bit] NULL CONSTRAINT [DF_ListObservationDefaultSetting_WHOPercent]  DEFAULT ((0)),
	[IsMetric] [bit] NOT NULL CONSTRAINT [DF_ListObservationDefaultSetting_IsMetric]  DEFAULT ((0)),
	[ReviewAsFlow] [bit] NOT NULL CONSTRAINT [DF_ListObservationDefaultSetting_ReviewAsFlow]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListObservationDefaultSetting_Inactive]  DEFAULT ((0)),
	[TimespanUid] [uniqueidentifier] NULL,
	[ObservationCustomUserUid] [uniqueidentifier] NULL,
	[ObservationGroupUid] [uniqueidentifier] NULL,
	[XML_Setting] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListObservationDefaultSetting_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListObservationDefaultSetting_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListObservationGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListObservationGroup](
	[ObservationGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListObservationGroup_ObservationGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListObservationGroup_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListObservationGroup_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListObservationGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListObservationGroup_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListObservationItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListObservationItem](
	[ObservationItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ObservationItem_ObservationItemUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListObservationItem_Inactive]  DEFAULT ((0)),
	[Name] [varchar](255) NOT NULL CONSTRAINT [DF_ListObservationItem_Name]  DEFAULT ('unnamed'),
	[Header] [varchar](15) NULL,
	[Colwidth] [smallint] NULL,
	[ValueTypeID] [smallint] NULL,
	[DisplayTypeID] [smallint] NULL,
	[Measurement] [varchar](50) NULL,
	[AllowMultiple] [bit] NOT NULL CONSTRAINT [DF_ListObservationItem_AllowMultiple]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[IsVitals] [bit] NULL CONSTRAINT [DF_ListObservationItem_IsVitals]  DEFAULT ((0)),
	[ControlTypeUid] [uniqueidentifier] NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[DataTypeID] [smallint] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListObservationItem_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListObservationItem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListObservationOrderResultStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListObservationOrderResultStatus](
	[ObservationOrderResultStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListObservationOrderResultStatus_ObservationOrderResultStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[ResultStatusID] [smallint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListObservationOrderResultStatus_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListObservationOrderResultStatus_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListObservationOrderResultStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListObservationViewOption]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListObservationViewOption](
	[ObservationViewOptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListObservationViewOption_ObservationViewOptionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListObservationViewOption_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UrgentTypeID] [smallint] NULL,
	[WithinNum] [int] NULL,
	[WithinUnitID] [int] NULL,
	[LinkedWithinNum] [int] NULL,
	[LinkedWithinUnitID] [int] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListObservationViewOption_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListObservationViewOption_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListOccupation]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListOccupation](
	[OccupationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListOccupation_OccupationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListOccupation_Inactive]  DEFAULT ((0)),
	[Name] [varchar](max) NOT NULL,
	[OccupationCode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListOccupation_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListOccupation_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListOccurrenceCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListOccurrenceCode](
	[OccurrenceCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListOccurrenceCode_OccurrenceCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListOccurrenceCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListOccurrenceCode_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListOccurrenceCode_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListOptionType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListOptionType](
	[OptionTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPaperworkTransmissionCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPaperworkTransmissionCode](
	[PaperworkTransmissionCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPaperworkTransmissionCode_PaperworkTransmissionCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPaperworkTransmissionCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPaperworkTransmissionCode_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPaperworkTransmissionCode_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPaperworkType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPaperworkType](
	[PaperworkTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPaperworkType_PaperworkTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPaperworkType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPaperworkType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPaperworkType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientCareManagementStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientCareManagementStatus](
	[PatientCareManagementStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPatientCareManagementStatus_PatientCareManagementStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPatientCareManagementStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPatientCareManagementStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPatientCareManagementStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientCenter]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientCenter](
	[PatientCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientClass]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientClass](
	[PatientClassUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPatientClass_PatientClassUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPatientClass_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPatientClass_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPatientClass_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientCommunicationType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientCommunicationType](
	[PatientCommunicationTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListPatientCommunicationType_PatientCommunicationTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPatientCommunicationType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPatientCommunicationType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPatientCommunicationType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientCondition]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientCondition](
	[PatientConditionUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](50) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Color] [int] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientDashboard]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientDashboard](
	[PatientDashboardUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[PhoneConfigurationXml] [xml] NULL,
	[TabletConfigurationXml] [xml] NULL,
	[DesktopConfigurationXml] [xml] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPatientDashboard_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientProgram]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientProgram](
	[PatientProgramUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ToolbarText] [varchar](10) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Color] [int] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientStatus](
	[PatientStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPatientStatus_PatientStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](50) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPatientStatus_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPatientStatus_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPatientStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientStatusUB]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientStatusUB](
	[PatientStatusUBUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPatientStatusUB_PatientStatusUBUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPatientStatusUB_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPatientStatusUB_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPatientStatusUB_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPatientTrackingEventType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPatientTrackingEventType](
	[PatientTrackingEventTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPatientTrackingEventType_PatientTrackingEventTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[GraphByDefault] [bit] NOT NULL CONSTRAINT [DF_ListPatientTrackingEventType_GraphByDefault]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPatientTrackingEventType_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPatientTrackingEventType_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPatientTrackingEventType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPayerCreditRefundStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPayerCreditRefundStatus](
	[PayerCreditRefundStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPayerCreditRefundStatus_PayerCreditRefundStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPayerCreditRefundStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPayerCreditRefundStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPayerCreditRefundStatus_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF__ListPayerCreditRefundStatus_DisplayOrder]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPayerTypologySource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPayerTypologySource](
	[PayerTypologySourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPayerTypologySource_PayerTypologySourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Code] [varchar](10) NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPayerTypologySource_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPaymentType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPaymentType](
	[PaymentTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPaymentType_PaymentTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPaymentType_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPaymentType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPaymentType_UserDefined]  DEFAULT ((1)),
	[AllowsScanner] [bit] NULL,
	[InternalCardType] [char](2) NULL,
	[DefaultRefundPaymentTypeUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPEDescription]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPEDescription](
	[PEDescriptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPEDescription_PEDescriptionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPEDescription_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPEDescription_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPEDescription_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPEParentSystem]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPEParentSystem](
	[PEParentSystemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPEParentSystem_PEParentSystemUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPEParentSystem_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPEParentSystem_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListPEParentSystem_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPEParentSystem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPESymptom]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPESymptom](
	[PESymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPESymptom_PESymptomUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPESymptom_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPESymptom_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPESymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPESystem]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPESystem](
	[PESystemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPESystem_PESystemUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPESystem_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPESystem_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPESystem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPETemplate]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPETemplate](
	[PETemplateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPETemplate_PETemplateUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPETemplate_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[OriginalPETemplateUid] [uniqueidentifier] NULL,
	[EMExaminationDescriptionUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListPETemplate_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPETemplate_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LicenseCode] [varchar](50) NULL,
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPETemplate_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPharmacy]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPharmacy](
	[PharmacyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPharmacy_PharmacyUid]  DEFAULT (newid()),
	[Name] [varchar](256) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[MasterPharmacyUid] [uniqueidentifier] NULL,
	[Address] [xml](CONTENT [Address]) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Phone3] [xml](CONTENT [Phone]) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPharmacy_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPharmacy_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPharmacy_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Computed_Address1_Address1] [varchar](100) NULL,
	[Computed_Address1_Address2] [varchar](100) NULL,
	[Computed_Address1_City] [varchar](35) NULL,
	[Computed_Address1_State] [varchar](3) NULL,
	[Computed_Address1_Zip] [varchar](10) NULL,
	[Computed_Phone1_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone1_PhoneType] [varchar](50) NULL,
	[Computed_Phone2_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone2_PhoneType] [varchar](50) NULL,
	[Computed_Phone3_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone3_PhoneType] [varchar](50) NULL,
	[Computed_Address1_StreetAddress] [varchar](200) NULL,
	[Computed_Address1_Country] [varchar](50) NULL,
	[Computed_Phone1_Scrubbed] [varchar](80) NULL,
	[Computed_Phone2_Scrubbed] [varchar](80) NULL,
	[Computed_Phone3_Scrubbed] [varchar](80) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPharmacyClearinghouse]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPharmacyClearinghouse](
	[PharmacyClearinghouseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPharmacyClearinghouse_PharmacyClearinghouseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPharmacyClearinghouse_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[SenderID] [varchar](50) NULL,
	[SenderType] [varchar](5) NULL,
	[InactivateFaxOnly] [bit] NOT NULL CONSTRAINT [DF_ListPharmacyClearinghouse_InactivateFaxOnly]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[InterfaceDetails] [xml] NULL,
	[AssemblyQualifiedName] [varchar](512) NULL,
	[UIAQN] [varchar](512) NULL,
	[ClinicName] [varchar](35) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPharmacyClearinghouse_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPharmacyClearinghouse_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPhoneType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPhoneType](
	[PhoneTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPhoneType_PhoneTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPhoneType_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPhoneType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPhoneType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPlanDefaults]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPlanDefaults](
	[PlanDefaultsUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](500) NOT NULL,
	[PlanGroupUid] [uniqueidentifier] NOT NULL,
	[SelectionXML] [varchar](max) NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[PatientInstruction] [varchar](max) NULL,
	[PlanComment] [varchar](max) NULL,
	[PhysicianComment] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedBy] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPlanGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPlanGroup](
	[PlanGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[MaxNodeLevel] [int] NULL,
	[Node0Description] [varchar](25) NULL,
	[Node1Description] [varchar](25) NULL,
	[Node2Description] [varchar](25) NULL,
	[Node3Description] [varchar](25) NULL,
	[Node4Description] [varchar](25) NULL,
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPlanNode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPlanNode](
	[PlanNodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[NaturalLanguage] [varchar](100) NULL,
	[Conjunctor] [varchar](100) NULL,
	[ExcludeFromReport] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[FindTableUid] [uniqueidentifier] NULL,
	[FindUid] [uniqueidentifier] NULL,
	[SubFindTableUid] [uniqueidentifier] NULL,
	[AllowsBilaterality] [bit] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPlanPrnCondition]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPlanPrnCondition](
	[PlanPrnConditionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPlanPrnCondition_PlanPrnConditionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPlanPrnCondition_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPlanPrnCondition_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPlanPrnCondition_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPlanSymptomCondition]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPlanSymptomCondition](
	[PlanSymptomConditionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPlanSymptomCondition_PlanSymptomConditionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPlanSymptomCondition_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPlanSymptomCondition_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPlanSymptomCondition_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPQRIDiseaseGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPQRIDiseaseGroup](
	[PQRIDiseaseGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPQRIDiseaseGroup_PQRIDiseaseGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPQRIDiseaseGroup_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PQRIDiseaseGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PQRIDiseaseGroup_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPQRIGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPQRIGroup](
	[PQRIGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPQRIGroup_PQRIGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPQRIGroup_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PQRIGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PQRIGroup_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPQRIMeasure]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPQRIMeasure](
	[PQRIMeasureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPQRIMeasure_PQRIMeasureUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPQRIMeasure_Inactive]  DEFAULT ((0)),
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[AgeFrom] [int] NULL CONSTRAINT [DF_ListPQRIMeasure_AgeFrom]  DEFAULT ((18)),
	[AgeFromIsMonth] [bit] NOT NULL CONSTRAINT [DF_ListPQRIMeasure_AgeFromIsMonth]  DEFAULT ((0)),
	[AgeTo] [int] NULL CONSTRAINT [DF_ListPQRIMeasure_AgeTo]  DEFAULT ((75)),
	[AgeToIsMonth] [bit] NOT NULL CONSTRAINT [DF_ListPQRIMeasure_AgeToIsMonth]  DEFAULT ((0)),
	[RecurrenceInterval] [smallint] NULL CONSTRAINT [DF_ListPQRIMeasure_RecurrenceInterval]  DEFAULT ((0)),
	[PQRIDiseaseGroupUid] [uniqueidentifier] NULL,
	[RecurTimeTypeUid] [uniqueidentifier] NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PQRIMeasure_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PQRIMeasure_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPracticeForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPracticeForm](
	[PracticeFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[AttachmentGroupUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPrintSet]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPrintSet](
	[PrintSetUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPrintSet_PrintSetUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPrintSet_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPrintSet_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPrintSet_LastModifiedDate_1]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPrivacyPolicyAcceptance]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPrivacyPolicyAcceptance](
	[PrivacyPolicyAcceptanceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPrmAction]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPrmAction](
	[PrmActionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAction_Action Uid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[ActionAQN] [varchar](255) NOT NULL,
	[PrmRuleLevelUid] [uniqueidentifier] NULL,
	[UserDefinedControlGroupUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefinedControlParameters] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAction_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPrmAction_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAction_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPrmCondition]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPrmCondition](
	[PrmConditionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPrmCondition_PrmConditionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[PrmConditionAQN] [varchar](255) NOT NULL,
	[PrmRuleLevelUid] [uniqueidentifier] NULL,
	[UserDefinedControlGroupUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefinedControlParameters] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPrmCondition_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPrmCondition_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPrmCondition_ListModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPrmRule]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPrmRule](
	[PrmRuleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListRule_RuleUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[PrmRuleGroupUid] [uniqueidentifier] NULL,
	[Name] [varchar](50) NULL,
	[PrmRuleLevelUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListPrmRule_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListRule_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPrmRule_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListRule_ListModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPrmRuleGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPrmRuleGroup](
	[PrmRuleGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPrmRuleGroupp_PrmRuleGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPrmRuleGroup_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPrmRuleGroup_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPrmRuleGroupp_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListPrmRuleLevel]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListPrmRuleLevel](
	[PrmRuleLevelUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPrmRuleLevel_PrmRuleLevelUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NULL,
	[BusinessObject1AQN] [varchar](255) NULL,
	[BusinessObject2AQN] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPrmRuleLevel_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPrmRuleLevel_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListPrmRuleLevel_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPrmRuleLevel_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProblemStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProblemStatus](
	[ProblemStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProblemStatus_ProblemStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ActiveStatus] [bit] NOT NULL CONSTRAINT [DF_ListProblemStatus_ActiveStatus]  DEFAULT ((1)),
	[DurationType] [smallint] NOT NULL CONSTRAINT [DF_ListProblemStatus_DurationType]  DEFAULT ((1)),
	[ResolvedProblemStatusUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProblemStatus_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProblemStatus_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProblemStatus_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProcedure](
	[ProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedure_ProcedureUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_Inactive]  DEFAULT ((0)),
	[Code] [varchar](30) NOT NULL,
	[MasterProcedureUid] [uniqueidentifier] NULL,
	[ProcedureCodeTypeUid] [uniqueidentifier] NULL,
	[ProcedureServiceTypeUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[ProcedureGroupUid] [uniqueidentifier] NULL,
	[ShortDescription] [varchar](75) NOT NULL,
	[LongDescription] [varchar](1024) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IsEM] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_IsEM]  DEFAULT ((0)),
	[DefaultDontClaim] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_DefaultDontClaim]  DEFAULT ((0)),
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[Unit] [int] NULL CONSTRAINT [DF_ListProcedure_Unit]  DEFAULT ((1)),
	[ProcedureModifier1Uid] [uniqueidentifier] NULL,
	[ProcedureModifier2Uid] [uniqueidentifier] NULL,
	[ProcedureModifier3Uid] [uniqueidentifier] NULL,
	[ProcedureModifier4Uid] [uniqueidentifier] NULL,
	[FDB_MEDID] [int] NULL,
	[NDC] [varchar](50) NULL,
	[NDCUnitMeasureUid] [uniqueidentifier] NULL,
	[GenerateObservationOrder] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_GenerateObservationOrder]  DEFAULT ((0)),
	[RevenueCode] [varchar](10) NULL,
	[Cost] [money] NULL,
	[NDCQuantity] [varchar](15) NULL,
	[UsePracticeTaxableOption] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_UsePracticeTaxableOption]  DEFAULT ((1)),
	[TaxableOption] [smallint] NOT NULL CONSTRAINT [DF_ListProcedure_TaxableOption]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[IncludeInPatientProcedure] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_IncludeInPatientProcedure]  DEFAULT ((1)),
	[ShortDescriptionChangedFromMaster] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_ShortDescriptionChangedFromMaster]  DEFAULT ((0)),
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[SnomedConceptID2] [varchar](50) NULL,
	[DescriptionUid2] [uniqueidentifier] NULL,
	[ImageResultsDirectlyAccessible] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_ImageResultsDirectlyAccessible]  DEFAULT ((0)),
	[PurchasedServiceCharge] [money] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL,
	[RequireDpn] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_RequireDpn]  DEFAULT ((0)),
	[SortToBottom] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_SortAtBottom]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedure_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProcedureCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProcedureCategory](
	[ProcedureCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedureCategory_ProcedureCategoryUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[AQN] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedureCategory_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedureCategory_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [smallint] NULL,
	[UIControlUid] [uniqueidentifier] NULL,
	[UIControlData] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedureCategory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProcedureCodeType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProcedureCodeType](
	[ProcedureCodeTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedureCodeType_ProcedureCodeTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedureCodeType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedureCodeType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedureCodeType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProcedureGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProcedureGroup](
	[ProcedureGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedureGroup_ProcedureGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedureGroup_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedureGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedureGroup_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProcedureHistoryStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProcedureHistoryStatus](
	[ProcedureHistoryStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedureHistoryStatus_ProcedureHistoryStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedureHistoryStatus_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedureHistoryStatus_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedureHistoryStatus_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProcedureHistoryTerm]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProcedureHistoryTerm](
	[ProcedureHistoryTermUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedureHistoryTerm_ProcedureHistoryTermUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedureHistoryTerm_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedureHistoryTerm_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedureHistoryTerm_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProcedureModifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProcedureModifier](
	[ProcedureModifierUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedureModifier_ProcedureModifierUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedureModifier_Inactive]  DEFAULT ((0)),
	[Modifier] [char](2) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[ShortDescription] [varchar](50) NOT NULL,
	[LongDescription] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedureModifier_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedureModifier_UserDefined]  DEFAULT ((1)),
	[ProcedureCodeTypeUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProcedurePanel]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProcedurePanel](
	[ProcedurePanelUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedurePanel_ProcedurePanelUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedurePanel_Inactive]  DEFAULT ((0)),
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListProcedurePanel_DisplayOrder]  DEFAULT ((0)),
	[LaboratoryOrderUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedurePanel_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedurePanel_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProcedureServiceType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProcedureServiceType](
	[ProcedureServiceTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedureServiceType_ProcedureServiceTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedureServiceType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedureServiceType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedureServiceType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProductParameter]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProductParameter](
	[ProductParameterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProductParameter_ProductParameterUid]  DEFAULT (newid()),
	[ParameterName] [varchar](250) NOT NULL,
	[StringValue] [varchar](max) NULL,
	[GuidValue] [uniqueidentifier] NULL,
	[BoolValue] [bit] NULL,
	[IntegerValue] [int] NULL,
	[DateValue] [date] NULL,
	[DateTimeValue] [datetime] NULL,
	[DecimalValue] [decimal](18, 0) NULL,
	[RealValue] [real] NULL,
	[BinaryValue] [varbinary](max) NULL,
	[XMLValue] [xml] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProductParameter_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProductParameter_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProductParameter_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListProviderCareType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListProviderCareType](
	[ProviderCareTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProviderCareType_ProviderCareTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[CopayColumnTypeID] [smallint] NOT NULL CONSTRAINT [DF_ListProviderCareType_CopayColumnType]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProviderCareType_Inactive]  DEFAULT ((0)),
	[ExcludeFromReferrals] [bit] NOT NULL CONSTRAINT [DF_ListProviderCareType_ExcludeFromReferrals]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProviderCareType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProviderCareType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListQuestion]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListQuestion](
	[QuestionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListQuestion_QuestionUid]  DEFAULT (newid()),
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[AnswerGroupUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListQuestion_Inactive]  DEFAULT ((0)),
	[Name] [varchar](255) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListQuestion_UserDefined]  DEFAULT ((1)),
	[Header] [varchar](15) NULL,
	[Colwidth] [smallint] NULL,
	[AllowMultiple] [bit] NOT NULL CONSTRAINT [DF_ListQuestion_AllowMultiple]  DEFAULT ((0)),
	[RequiresAnswer] [bit] NOT NULL CONSTRAINT [DF_ListQuestion_RequiresAnswer]  DEFAULT ((0)),
	[SelectionTypeID] [smallint] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListQuestion_DisplayOrder]  DEFAULT ((0)),
	[FDB_HIC_SEQN] [int] NULL,
	[Notes] [varchar](max) NULL,
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[FDBIDType] [varchar](20) NULL,
	[UNII] [varchar](255) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[HL7Code] [varchar](50) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListQuestion_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListQuestionCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListQuestionCode](
	[QuestionCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListRace]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListRace](
	[RaceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListRace_RaceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListRace_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListRace_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListRace_UserDefined]  DEFAULT ((1)),
	[MidmarkCode] [tinyint] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReasonNotReviewingHx]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReasonNotReviewingHx](
	[ReasonNotReviewingHxUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListRecallMethod]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListRecallMethod](
	[RecallMethodUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListRecallType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListRecallType](
	[RecallTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListRecallType_RecallTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListRecallType_Inactive]  DEFAULT ((0)),
	[CDS] [bit] NOT NULL CONSTRAINT [DF_ListRecallType_CDS]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListRecallType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListRecallType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReferralSrc]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReferralSrc](
	[ReferralSrcUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListReferralSrc_ReferralSrcUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListReferralSrc_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListReferralSrc_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListReferralSrc_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReferralTrackingStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReferralTrackingStatus](
	[ReferralTrackingStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListReferralTrackingStatus_ReferralTrackingStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListReferralTrackingStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListReferralTrackingStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListReferralTrackingStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListRegion]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListRegion](
	[RegionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](2) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReimbursementRule]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReimbursementRule](
	[ReimbursementRuleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListReimbursementRule_ReimbursementRuleUid]  DEFAULT (newid()),
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ReimbursementRule_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListReimbursementRule_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListReimbursementRule_LastModifiedDate]  DEFAULT (getutcdate()),
	[ExternalID] [varchar](25) NULL,
	[LetterModelUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListRelatedCause]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListRelatedCause](
	[RelatedCauseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListRelatedCause_RelatedCauseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListRelatedCause_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListRelatedCause_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListRelatedCause_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListRelationalOperator]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListRelationalOperator](
	[RelationalOperatorUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[RelationalOperator] [varchar](15) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListRelationship]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListRelationship](
	[RelationshipUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListRelationship_RelationshipUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListRelationship_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListRelationship_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListRelationship_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListRelationship_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReplicationUpdateScript]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReplicationUpdateScript](
	[ReplicationUpdateScriptUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SqlScript] [varchar](max) NOT NULL,
	[CacheMachineUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReport]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReport](
	[ReportUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListReport_ReportUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListReport_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListReport_UserDefined]  DEFAULT ((1)),
	[ReportFolderUid] [uniqueidentifier] NULL,
	[UserDefinedControlGroupUid] [uniqueidentifier] NULL,
	[ContextReport] [bit] NOT NULL CONSTRAINT [DF_ListReport_ContextReport]  DEFAULT ((0)),
	[ReportParameters] [varchar](max) NULL,
	[UseBusinessObject] [bit] NOT NULL CONSTRAINT [DF_ListReport_UseBusinessObject]  DEFAULT ((0)),
	[RDLDesigner] [bit] NOT NULL CONSTRAINT [DF_ListReport_RDLDesigner]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListReport_LastModifiedDate_1]  DEFAULT (getutcdate()),
	[Modifier] [int] NOT NULL CONSTRAINT [DF_ListReport_Modifier]  DEFAULT ((0)),
	[AllowMaintenance] [bit] NOT NULL CONSTRAINT [DF_ListReport_AllowMaintenance]  DEFAULT ((1)),
	[HasSecurity] [bit] NOT NULL CONSTRAINT [DF_ListReport_HasSecurity]  DEFAULT ((1)),
	[SecurityGroupUid] [uniqueidentifier] NULL CONSTRAINT [DF_ListReport_SecurityGroupUid]  DEFAULT ('C6BC91BD-C909-4193-813E-B20EFB696F2E'),
	[PatientReport] [bit] NOT NULL CONSTRAINT [DF_LilstReport_PatientReport]  DEFAULT ((0)),
	[ActiveReportHandlerAssemblyQualifiedName] [varchar](512) NULL,
	[CreateAttachmentApproval] [bit] NOT NULL CONSTRAINT [DF_ListReport_CreateAttachmentApproval]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReportability]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReportability](
	[ReportabilityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListReportability_ReportabilityUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Description] [varchar](max) NOT NULL,
	[ICD9Code] [varchar](20) NULL,
	[ICD10Code] [varchar](20) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListReportability_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListReportability_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListReportability_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReportDesignerView]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReportDesignerView](
	[ReportDesignerViewUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListReportDesignerView_ReportDesignerViewUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListReportDesignerView_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DatabaseViewName] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListReportDesignerView_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListReportDesignerView_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReportFolder]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReportFolder](
	[ReportFolderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListReportFolder_ReportFolderUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListReportFolder_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListReportFolder_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListReportFolder_LastModifiedDate_1]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListReportRdl]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListReportRdl](
	[ReportRdlUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListReportRdl_ReportRdlUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[ReportDefinition] [varchar](max) NULL,
	[ReportUid] [uniqueidentifier] NOT NULL,
	[DefinitionSelected] [bit] NOT NULL CONSTRAINT [DF_ListReportRdl_DefinitionSelected]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListReportRdl_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListReportRdl_UserDefined]  DEFAULT ((1)),
	[RDLDesigner] [bit] NOT NULL CONSTRAINT [DF_ListReportRdl_RDLDesigner]  DEFAULT ((0)),
	[ExcelReport] [bit] NOT NULL CONSTRAINT [DF_ListReportRdl_ExcelReport_1]  DEFAULT ((0)),
	[IncludePracticeNameParameter] [bit] NOT NULL CONSTRAINT [DF_ListReportRdl_IncludePracticeNameParameter_1]  DEFAULT ((1)),
	[SQLRevision] [varchar](25) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListReportRdl_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListResidenceType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListResidenceType](
	[ResidenceTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListRPNOptions]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListRPNOptions](
	[RPNOptionsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListRPNOptions_RPNOptionsUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListRPNOptions_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Settings] [varchar](max) NULL,
	[UserPRMUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListRPNOptions_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListRPNOptions_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListRuleMeasure]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListRuleMeasure](
	[RuleMeasureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListRuleMeasure_ListRuleMeasureUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[EditAQN] [varchar](255) NULL,
	[Cat1_FieldMapping] [xml] NULL,
	[Cat1_XSLT] [xml] NULL,
	[Cat1_Validation] [xml] NULL,
	[Cat1_XSL] [xml] NULL,
	[Cat1_Configuration] [xml] NULL,
	[Cat1_ValidatorAQN] [varchar](1000) NULL,
	[Cat1_GeneratorAQN] [varchar](1000) NULL,
	[Cat1_DocumentAQN] [varchar](1000) NULL,
	[Cat1_LoadSpanXml] [xml] NULL,
	[Cat1_HintSectionGeneratorMethods] [xml] NULL,
	[Cat1_CompleteChartFieldMapping] [xml] NULL,
	[Cat1_DocumentType] [smallint] NOT NULL CONSTRAINT [DF_ListRuleMeasure_Cat1_DocumentType]  DEFAULT ((0)),
	[Cat3_FieldMapping] [xml] NULL,
	[Cat3_XSLT] [xml] NULL,
	[Cat3_Validation] [xml] NULL,
	[Cat3_XSL] [xml] NULL,
	[Cat3_Configuration] [xml] NULL,
	[Cat3_PatientDetail_FieldMapping] [xml] NULL,
	[Cat3_PatientDetail_XSLT] [xml] NULL,
	[Cat3_PatientDetail_XSL] [xml] NULL,
	[Cat3_GeneratorAQN] [varchar](1000) NULL,
	[Cat3_Final_XSLT] [xml] NULL,
	[Version] [xml] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListRuleMeasure_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListRuleMeasure_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListRuleMeasure_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[CustomMatchingQualifier] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListScanner]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListScanner](
	[ScannerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[MachineName] [varchar](100) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListScantronPublishedForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListScantronPublishedForm](
	[ScantronPublishedFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListScantronPublishedForm_ScantronPublishedFormUid]  DEFAULT (newid()),
	[FileContent] [varbinary](max) NULL,
	[FileType] [varchar](50) NULL,
	[FileSize] [int] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListScantronPublishedForm_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListScantronPublishedForm_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListScantronPublishedForm_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListScantronSurveyForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListScantronSurveyForm](
	[ScantronSurveyFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListScantronSurveyForm_ScantronSurveyFormUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListScantronSurveyForm_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[SurveyUid] [uniqueidentifier] NOT NULL,
	[SurveySectionUid] [uniqueidentifier] NULL,
	[FormID] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListScantronSurveyForm_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListScantronSurveyForm_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListScantronSurveyFormFields]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListScantronSurveyFormFields](
	[ScantronSurveyFormFieldsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListScantronSurveyFormFields_ScantronSurveyFormFieldsUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListScantronSurveyFormFields_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ScantronSurveyFormUid] [uniqueidentifier] NULL,
	[SurveyAnswerUid] [uniqueidentifier] NULL,
	[SurveyQuestionUid] [uniqueidentifier] NULL,
	[SurveySectionUid] [uniqueidentifier] NULL,
	[SurveyUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListScantronSurveyFormFields_DisplayOrder]  DEFAULT ((-1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListScantronSurveyFormFields_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListScantronSurveyFormFields_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListScrubItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListScrubItem](
	[ScrubItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListScrubItem_ScrubItemUid]  DEFAULT (newid()),
	[ScrubDescription] [varchar](255) NOT NULL,
	[ScrubType] [tinyint] NOT NULL CONSTRAINT [DF_ListScrubItem_ScrubType]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListScrubItem_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListScrubItem_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListScrubItem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListScrubProfile]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListScrubProfile](
	[ScrubProfileUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListScrubProfile_ScrubProfileUid]  DEFAULT (newid()),
	[Name] [varchar](255) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListScrubProfile_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListScrubProfile_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListScrubProfile_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSecurity]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSecurity](
	[SecurityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSecurityItem_SecurityItemUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSecurity_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Id] [varchar](50) NULL,
	[SecurityGroupUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSecurity_UserDefined]  DEFAULT ((1)),
	[ObjectSecurity] [bit] NOT NULL CONSTRAINT [DF_ListSecurity_ObjectSecurity]  DEFAULT ((0)),
	[ShowItem] [bit] NOT NULL CONSTRAINT [DF_ListSecurity_ShowItem]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSecurityItem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSecurityGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSecurityGroup](
	[SecurityGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSecurityGroup_SecurityGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSecurityGroup_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Permission] [int] NOT NULL CONSTRAINT [DF_ListSecurityGroup_SecurityTypeId]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSecurityGroup_UserDefined]  DEFAULT ((1)),
	[ShowInFindList] [bit] NOT NULL CONSTRAINT [DF_ListSecurityGroup_ShowInFindList]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSecurityGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSentMethod]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSentMethod](
	[SentMethodUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListServiceAuthorizationException]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListServiceAuthorizationException](
	[ServiceAuthorizationExceptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListServiceAuthorizationException_ServiceAuthorizationExceptionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListServiceAuthorizationException_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListServiceAuthorizationException_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListServiceAuthorizationException_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListServiceSite]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListServiceSite](
	[ServiceSiteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListServiceSite_ServiceSiteUid]  DEFAULT (newid()),
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[ServiceSiteTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListServiceSite_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[InternalSite] [bit] NOT NULL CONSTRAINT [DF_ListServiceSite_InternalSite]  DEFAULT ((0)),
	[PrimaryContact] [varchar](100) NULL,
	[SecondaryContact] [varchar](100) NULL,
	[Address] [xml](CONTENT [Address]) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Phone3] [xml](CONTENT [Phone]) NULL,
	[Phone4] [xml](CONTENT [Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[FormalName] [varchar](50) NULL,
	[TypeOfBill] [varchar](5) NULL,
	[TimeZone] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListServiceSite_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListServiceSiteType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListServiceSiteType](
	[ServiceSiteTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListServiceSiteType_ServiceSiteTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListServiceSiteType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListServiceSiteType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListServiceSiteType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSexualOrientation]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSexualOrientation](
	[SexualOrientationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSexualOrientation_SexualOrientationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSexualOrientation_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSexualOrientation_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSexualOrientation_LastModifiedDate]  DEFAULT (getutcdate()),
	[conceptId] [varchar](100) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSignatureSource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSignatureSource](
	[SignatureSourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSignatureSource_SignatureSourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSignatureSource_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSignatureSource_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSignatureSource_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSIGQuantityUnitOfMeasure]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSIGQuantityUnitOfMeasure](
	[SIGQuantityUnitOfMeasureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSIGQuantityUnitOfMeasure_SIGQuantityUnitOfMeasureUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSIGQuantityUnitOfMeasure_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Code] [varchar](250) NULL,
	[NCItCode] [varchar](50) NULL,
	[PrescriptionText] [varchar](20) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSIGQuantityUnitOfMeasure_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSIGQuantityUnitOfMeasure_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSnomedCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSnomedCategory](
	[SnomedCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSnomedCategory_SnomedCategoryUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSnomedCategory_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSnomedCategory_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSnomedCategory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSpecialProgramReason]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSpecialProgramReason](
	[SpecialProgramReasonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSpecialProgramReason_SpecialProgramReasonUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSpecialProgramReason_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSpecialProgramReason_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSpecialProgramReason_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSpecialty]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSpecialty](
	[SpecialtyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSpecialty_SpecialtyUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSpecialty_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSpecialty_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSpecialty_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSpecimenAction]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSpecimenAction](
	[SpecimenActionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListSpecimenAction_SpecimenActionUid]  DEFAULT (newid()),
	[Code] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSpecimenAction_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSpecimenAction_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSpecimenAction_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListState]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListState](
	[StateUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Abbreviation] [varchar](50) NOT NULL,
	[DriversLicenseOid] [varchar](50) NOT NULL CONSTRAINT [DF_ListState_DriversLicenseOid]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListStudentStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListStudentStatus](
	[StudentStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSuperbillStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSuperbillStatus](
	[SuperbillStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSuperbillStatus_SuperbillStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSuperbillStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSuperbillStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSuperbillStatus_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF__ListSuperbillStatus_DisplayOrder]  DEFAULT ((0)),
	[InsuranceOrder] [int] NOT NULL CONSTRAINT [DF__ListSuperbillStatus_InsuranceOrder]  DEFAULT ((0)),
	[ActionName] [varchar](50) NULL CONSTRAINT [DF__ListSuperbillStatus_ActionName]  DEFAULT (''),
	[AllowPosted] [bit] NOT NULL CONSTRAINT [DF_ListSuperbillStatus_AllowPosted]  DEFAULT ((1)),
	[AllowUnposted] [bit] NOT NULL CONSTRAINT [DF_ListSuperbillStatus_AllowUnposted]  DEFAULT ((1)),
	[AllowVisitSync] [bit] NOT NULL CONSTRAINT [DF_ListSuperbillStatus_AllowVisitSync]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSurvey]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSurvey](
	[SurveyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSurvey_SurveyUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSurvey_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[FormType] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSurvey_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSurvey_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSurveyAnswer]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSurveyAnswer](
	[SurveyAnswerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__ListSurve__Surve__3E5C2B84]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF__ListSurve__Inact__3F504FBD]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[ProblemStatusUid] [uniqueidentifier] NULL,
	[MedicationUid] [uniqueidentifier] NULL,
	[DrugName] [varchar](255) NULL,
	[Label] [varchar](255) NOT NULL,
	[TargetType] [varchar](50) NOT NULL CONSTRAINT [DF_ListSurveyAnswer_TargetType]  DEFAULT ('KDB'),
	[RosDenyFlag] [bit] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSurveyAnswer_UserDefined]  DEFAULT ((1)),
	[PredeterminedTargetType] [varchar](50) NULL,
	[PredeterminedQuestionUid] [uniqueidentifier] NULL,
	[PredeterminedDiseaseUid] [uniqueidentifier] NULL,
	[PredeterminedRelRosSystemSymptomUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__ListSurve__LastM__422CBC68]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSurveyAnswerGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSurveyAnswerGroup](
	[SurveyAnswerGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__ListSurve__Surve__45FD4D4C]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF__ListSurve__Inact__46F17185]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[AnswerGroupUid] [uniqueidentifier] NULL,
	[TargetType] [varchar](50) NOT NULL CONSTRAINT [DF_ListSurveyAnswerGroup_TargetType]  DEFAULT ('KDB'),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSurveyAnswerGroup_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__ListSurve__LastM__49CDDE30]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSurveyControlType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSurveyControlType](
	[SurveyControlTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__ListSurve__Surve__4D9E6F14]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF__ListSurve__Inact__4E92934D]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[ControlTypeUid] [uniqueidentifier] NULL,
	[DesignTimeClass] [varchar](255) NOT NULL,
	[RunTimeClass] [varchar](255) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSurveyControlType_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__ListSurve__LastM__516EFFF8]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSurveyQuestion]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSurveyQuestion](
	[SurveyQuestionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__ListSurve__Surve__553F90DC]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF__ListSurve__Inact__5633B515]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Label] [varchar](1024) NOT NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[SurveyAnswerGroupUid] [uniqueidentifier] NULL,
	[SurveyControlTypeUid] [uniqueidentifier] NOT NULL,
	[RelRosSystemSymptomUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[TargetType] [varchar](50) NOT NULL CONSTRAINT [DF_ListSurveyQuestion_TargetType]  DEFAULT ('KDB'),
	[RosName] [varchar](255) NULL,
	[ControlProperties] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSurveyQuestion_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__ListSurve__LastM__5BEC8E6B]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSurveySection]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSurveySection](
	[SurveySectionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__ListSurve__Surve__37AF2DF5]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF__ListSurve__Inact__38A3522E]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[ContainsPatientHxQuestion] [bit] NOT NULL CONSTRAINT [DF_ListSurveySection_ContainsPatientHxQuestion]  DEFAULT ((0)),
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[ProblemHxSubFindTableUid] [uniqueidentifier] NULL,
	[FamilyHxProblemSubFindTableUid] [uniqueidentifier] NULL,
	[FamilyHxRelationshipSubFindTableUid] [uniqueidentifier] NULL,
	[AdultVaccineAdminSubFindTableUid] [uniqueidentifier] NULL,
	[PediatricVaccineAdminSubFindTableUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSurveySection_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__ListSurve__LastM__3A8B9AA0]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSymptom]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSymptom](
	[SymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSymptom_SymptomUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSymptom_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSymptom_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListSystem]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListSystem](
	[SystemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSystem_SystemUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSystem_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSystem_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSystem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListTimeFrame]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListTimeFrame](
	[TimeFrameUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListTimeFrame_TimeFrameUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DefaultValue] [int] NOT NULL CONSTRAINT [DF_ListTimeFrame_DefaultValue]  DEFAULT ((0)),
	[UseBirthDate] [bit] NOT NULL CONSTRAINT [DF_ListTimeFrame_UseBirthDate]  DEFAULT ((1)),
	[AddToDate] [bit] NOT NULL CONSTRAINT [DF_ListTimeFrame_AddToDate]  DEFAULT ((1)),
	[TimespanUnitType] [smallint] NOT NULL CONSTRAINT [DF_ListTimeFrame_TimespanUnitType]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListTimeFrame_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTimeFrame_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListTimeFrame_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTimeFrame_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListTimespan]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListTimespan](
	[TimespanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListTimespan_TimespanUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DataXml] [varchar](1000) NULL,
	[ProcessorAQN] [varchar](1000) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListTimespan_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListTimespan_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTimespan_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTimespan_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[IsModified] [bit] NOT NULL CONSTRAINT [DF_ListTimespan_IsModified]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListTimeType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListTimeType](
	[TimeTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListTimeType_TimeTypeUid]  DEFAULT (newid()),
	[Name] [varchar](100) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListTimeType_DisplayOrder]  DEFAULT ((0)),
	[EnumValue] [int] NOT NULL CONSTRAINT [DF_ListTimeType_EnumValue]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListTimeType_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTimeType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTimeType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListTranscriptionStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListTranscriptionStatus](
	[TranscriptionStatusUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_MessageUrgencyUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListTranscriptionStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Color] [int] NOT NULL CONSTRAINT [DF_ListTranscriptionStatus_Color]  DEFAULT ((0)),
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListTranscriptionStatus_DisplayOrder]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTranscriptionStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTranscriptionStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListTranslationTemplate]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListTranslationTemplate](
	[TranslationTemplateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListTranslationTemplate_TranslationTemplateUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListTranslationTemplate_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTranslationTemplate_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTranslationTemplate_LastModifiedDate]  DEFAULT (getutcdate()),
	[Document] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListTransmissionHandling]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListTransmissionHandling](
	[ListTransmissionHandlingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListTransmissionHandling_ListTransmissionHandlingUid]  DEFAULT (newid()),
	[MessageTypeUid] [uniqueidentifier] NOT NULL,
	[OutboundReprocessorAQN] [varchar](1024) NULL,
	[UserDefined] [bit] NOT NULL CONSTRAINT [DF_ListTransmissionHandling_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTransmissionHandling_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListTypeofVaccine]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListTypeofVaccine](
	[TypeofVaccineUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListTypeofVaccine_TypeofVaccineUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListTypeofVaccine_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NULL,
	[Recurring] [bit] NULL CONSTRAINT [DF_ListTypeofVaccine_Recurring]  DEFAULT ((0)),
	[ComparerUid] [uniqueidentifier] NULL,
	[PeriodUid] [uniqueidentifier] NULL,
	[RouteUid] [uniqueidentifier] NULL,
	[SiteGivenUid] [uniqueidentifier] NULL,
	[SourceUid] [uniqueidentifier] NULL,
	[LotNo] [varchar](100) NULL,
	[ExpirationDate] [date] NULL,
	[DateOnVIS] [date] NULL,
	[ManufacturerUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTypeofVaccine_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[NonImmunization] [bit] NOT NULL CONSTRAINT [DF_ListTypeofVaccine_NonImmunization]  DEFAULT ((0)),
	[CVXCodeUid] [uniqueidentifier] NULL,
	[CVXCodeUnspecifiedUid] [uniqueidentifier] NULL,
	[CVXVISMapUid] [uniqueidentifier] NULL,
	[VaccineUnitUseUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTypeofVaccine_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListTypeofVaccineElement]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListTypeofVaccineElement](
	[TypeofVaccineElementUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListTypeofVaccineElement_TypeofVaccineElementUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NULL CONSTRAINT [DF_ListTypeofVaccineElement_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTypeofVaccineElement_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTypeofVaccineElement_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUIControl]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUIControl](
	[UIControlUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListUIControl_ListUIControl]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUIControl_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UIControlTypeUid] [uniqueidentifier] NOT NULL,
	[DisplayName] [varchar](100) NULL,
	[AQN] [varchar](255) NOT NULL,
	[ConfigurationAQN] [varchar](255) NULL,
	[ContentSourceFieldsAQN] [varchar](255) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUIControl_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUIControl_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUIControlType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUIControlType](
	[UIControlTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_2_ListUIControl]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUIControlType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUIControlType_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[AQNInterface] [varchar](100) NULL,
	[AQNInterfaceIsControl] [bit] NOT NULL CONSTRAINT [DF_ListUIControlType_AQNInterfaceIsControl]  DEFAULT ((1)),
	[ConfigurationAQNInterface] [varchar](100) NULL,
	[ConfigurationAQNInterfaceIsControl] [bit] NOT NULL CONSTRAINT [DF_ListUIControlType_ConfigurationAQNInterfaceIsControl]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUIControlType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUserDefinedControl]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUserDefinedControl](
	[UserDefinedControlUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListUserDefinedControl_UserDefinedControlUid]  DEFAULT (newid()),
	[Name] [varchar](100) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserDefinedControl_Inactive]  DEFAULT ((0)),
	[Label] [varchar](255) NOT NULL,
	[ControlTypeUid] [uniqueidentifier] NULL,
	[ControlProperties] [varchar](max) NULL,
	[UserDefinedControlGroupUid] [uniqueidentifier] NULL,
	[SortOrder] [int] NULL CONSTRAINT [DF_ListUserDefinedControl_SortOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserDefinedControl_UserDefined]  DEFAULT ((1)),
	[RDLDesigner] [bit] NOT NULL CONSTRAINT [DF_ListUserDefinedControl_RDLDesigner]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserDefinedControl_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUserDefinedControlGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUserDefinedControlGroup](
	[UserDefinedControlGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListUserDefinedControlGroup_UserDefinedControlGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Immunization] [bit] NOT NULL CONSTRAINT [DF_ListUserDefinedControlGroup_Immunization]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserDefinedControlGroup_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserDefinedControlGroup_UserDefined]  DEFAULT ((1)),
	[RDLDesigner] [bit] NOT NULL CONSTRAINT [DF_ListUserDefinedControlGroup_RDLDesigner]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserDefinedControlGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUserDefinedData]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUserDefinedData](
	[UserDefinedDataUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListUserDefinedData_UserDefinedDataUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserDefinedList_Inactive]  DEFAULT ((0)),
	[FindTableUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserDefinedData_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListUserDefinedData_SortOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserDefinedList_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUserDefinedFilter]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUserDefinedFilter](
	[UserDefinedFilterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListUserDefinedFilter_UserDefinedFilterUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserDefinedFilter_Inactive]  DEFAULT ((0)),
	[ReportUid] [uniqueidentifier] NULL,
	[FilterData] [varchar](max) NULL,
	[DefaultFilter] [bit] NOT NULL CONSTRAINT [DF_ListUserDefinedFilter_DefaultFilter]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserDefinedFilter_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserDefinedFilter_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUserDefinedTemplate]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUserDefinedTemplate](
	[UserDefinedTemplateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListUserDefinedTemplate_UserDefinedTemplateUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefinedControlGroupUid] [uniqueidentifier] NULL,
	[Layout] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserDefinedTemplate_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserDefinedTemplate_UserDefined]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserDefinedTemplate_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUserGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUserGroup](
	[UserGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListUserGroup_UserGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserGroup_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserGroupTypeUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserGroup_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUserGroupType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUserGroupType](
	[UserGroupTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListUserGroupType_UserGroupTypeUid]  DEFAULT (newid()),
	[Name] [varchar](50) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserGroupType_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserGroupType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserGroupType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListUserSetting]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListUserSetting](
	[UserSettingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListUserSetting_UserSettingUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[ClinicalNoteTypes] [xml](CONTENT [UidList]) NULL,
	[FormattingTemplateUid] [uniqueidentifier] NULL,
	[NoteSingleColumn] [nchar](10) NULL,
	[MinWidth] [int] NOT NULL CONSTRAINT [DF_ListUserSetting_MinWidth_1]  DEFAULT ((100)),
	[FontSize] [float] NOT NULL CONSTRAINT [DF_ListUserSetting_FontSize_1]  DEFAULT ((10.0)),
	[UseNewOPSRPN] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_UseNewOPSRPN_1]  DEFAULT ((1)),
	[AttachmentAddIns] [xml](CONTENT [UidList]) NULL,
	[PatientDemographicAddIns] [xml](CONTENT [UidList]) NULL,
	[NoteAddIns] [xml](CONTENT [UidList]) NULL,
	[AppointmentNoteAddIn] [xml] NULL,
	[VitalsAddIns] [xml](CONTENT [UidList]) NULL,
	[PatientToolbarAddIns] [xml](CONTENT [UidList]) NULL,
	[DesktopAddIns] [xml](CONTENT [UidList]) NULL,
	[AppointmentAddIns] [xml](CONTENT [UidList]) NULL,
	[SuperbillChargeProcessorAddInUid] [uniqueidentifier] NULL,
	[ServiceProcedureAddInUid] [uniqueidentifier] NULL,
	[VisitSaveAddInUid] [uniqueidentifier] NULL,
	[PatientDemographicsPrint] [xml](CONTENT [UidList]) NULL,
	[NotePrint] [xml](CONTENT [UidList]) NULL,
	[OPSPrint] [xml](CONTENT [UidList]) NULL,
	[RPNPrint] [xml](CONTENT [UidList]) NULL,
	[PatientPrint] [xml](CONTENT [UidList]) NULL,
	[JobEngineStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_JobEngineStatus_1]  DEFAULT ((0)),
	[MasterServerStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MasterServerStatus]  DEFAULT ((0)),
	[CacheServerStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CacheServerStatus_1]  DEFAULT ((0)),
	[AutoCapitalization] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoCapitalization_1]  DEFAULT ((1)),
	[AutoComplete] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoComplete_1]  DEFAULT ((1)),
	[TryDelete] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_TryDelete_1]  DEFAULT ((1)),
	[VoiceRecording] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_VoiceRecording_1]  DEFAULT ((1)),
	[InkInput] [smallint] NOT NULL CONSTRAINT [DF_ListUserSetting_InkInput_1]  DEFAULT ((0)),
	[DockingStyle] [smallint] NOT NULL CONSTRAINT [DF_ListUserSetting_DockingStyle_1]  DEFAULT ((0)),
	[StartupSound] [varchar](255) NULL,
	[SelectionColor] [xml](CONTENT [SelectionColor]) NULL,
	[RequiredColor] [xml](CONTENT [SelectionColor]) NULL,
	[PatientInputColor] [xml](CONTENT [SelectionColor]) NULL,
	[BorderColor] [xml](CONTENT [SelectionColor]) NULL,
	[AllowCPO] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AllowCPO_1]  DEFAULT ((0)),
	[AutoCheckCPOGeneration] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoCheckCPOGeneration]  DEFAULT ((0)),
	[WarnOnCancelNote] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_WarnOnCancelNote_1]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserSetting_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[MaximizeForms] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MaximizeForms]  DEFAULT ((0)),
	[BackgroundSave] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_BackgroundSave]  DEFAULT ((1)),
	[UseNewOPS] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_UseNewOPS]  DEFAULT ((0)),
	[DisplayPrinterDialog] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_DisplayRxPrinterDialog]  DEFAULT ((0)),
	[ProcessHMRulesOnNoteSave] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_ProcessHMRulesOnNoteSave_1]  DEFAULT ((1)),
	[CheckoutPlanTemplateUid] [uniqueidentifier] NULL,
	[RPNPrintButtonUid] [uniqueidentifier] NULL,
	[OPSPrintButtonUid] [uniqueidentifier] NULL,
	[RxConsentFormattingTemplateUid] [uniqueidentifier] NULL,
	[RxConsentAttachmentTypeUid] [uniqueidentifier] NULL,
	[RxConsentMedication] [xml](CONTENT [UidList]) NULL,
	[StandardHistoryDisplay] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_StandardHistoryDisplay]  DEFAULT ((0)),
	[OtherSettings] [xml] NULL,
	[ShowRVUSearchingCPTUid] [uniqueidentifier] NULL,
	[IncludeEMInMFU] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_IncludeEMInMFU_1]  DEFAULT ((0)),
	[MultiWindow] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MultiWindow_1]  DEFAULT ((1)),
	[CheckoutEducationForm] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutEducationForm]  DEFAULT ((0)),
	[CheckoutVisitReceipt] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutVisitReceipt]  DEFAULT ((0)),
	[CheckoutSuperbill] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutSuperbill]  DEFAULT ((0)),
	[CheckoutUncheckAll] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutUncheckAll]  DEFAULT ((0)),
	[EditorFont] [xml] NULL,
	[FncCompleteNoteValidatorAddIns] [xml](CONTENT [UidList]) NULL,
	[KdbConfigurationUid] [uniqueidentifier] NULL,
	[ReceiveCDASectionUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserSetting_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVaccine]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVaccine](
	[VaccineUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVaccine_VaccineUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVaccine_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NULL,
	[AgeGroupUid] [uniqueidentifier] NULL,
	[StartDay] [int] NULL,
	[EndDay] [int] NULL,
	[Recurring] [bit] NOT NULL CONSTRAINT [DF_ListVaccine_Recurring_1]  DEFAULT ((0)),
	[RecurringStartVal] [smallint] NOT NULL CONSTRAINT [DF_ListVaccine_RecurringStartVal_1]  DEFAULT ((0)),
	[RecurringDurationUid] [uniqueidentifier] NULL,
	[MinAge] [smallint] NOT NULL CONSTRAINT [DF_ListVaccine_MinAge_1]  DEFAULT ((0)),
	[MinAgeSpanUid] [uniqueidentifier] NULL,
	[MaxAge] [smallint] NOT NULL CONSTRAINT [DF_ListVaccine_MaxAge_1]  DEFAULT ((0)),
	[MaxAgeSpanUid] [uniqueidentifier] NULL,
	[RoutineDoses] [smallint] NOT NULL CONSTRAINT [DF_ListVaccine_RoutineDoses_1]  DEFAULT ((0)),
	[CatchUpDoses] [smallint] NOT NULL CONSTRAINT [DF_ListVaccine_CatchUpDoses_1]  DEFAULT ((0)),
	[Schedule] [varchar](max) NULL,
	[SuppressSchedule] [bit] NOT NULL CONSTRAINT [DF_ListVaccine_SuppressReminder_1]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListVaccine_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListVaccine_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVaccine_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVaccineAdmin]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVaccineAdmin](
	[VaccineAdminUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVaccineAdmin_VaccineAdminUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVaccineAdmin_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[VaccineAdminHeaderInfoUid] [uniqueidentifier] NULL,
	[PediatricAgeGroup] [bit] NOT NULL CONSTRAINT [DF_ListVaccineAdmin_PediatricAgeGroup]  DEFAULT ((0)),
	[AdultAgeGroup] [bit] NOT NULL CONSTRAINT [DF_ListVaccineAdmin_AdultAgeGroup_1]  DEFAULT ((0)),
	[MiscAgeGroup] [bit] NOT NULL CONSTRAINT [DF_ListVaccineAdmin_MiscAgeGroup]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListVaccineAdmin_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVaccineAdmin_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVaccineAdminHeaderInfo]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVaccineAdminHeaderInfo](
	[VaccineAdminHeaderInfoUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVaccineAdminHeaderInfo_VaccineAdminHeaderInfoUid]  DEFAULT (newid()),
	[Name] [varchar](100) NULL,
	[ExternalID] [varchar](25) NULL,
	[Header] [varchar](max) NULL,
	[Footer] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_VaccineAdminStatement_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VaccineAdminStatement_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_VaccineAdminStatement_UserDefined]  DEFAULT ((1)),
	[CenterHeader] [bit] NOT NULL CONSTRAINT [DF_ListVaccineAdminHeaderInfo_CenterHeader]  DEFAULT ((0)),
	[CenterFooter] [bit] NOT NULL CONSTRAINT [DF_ListVaccineAdminHeaderInfo_CenterFooter]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVaccineFundingSource]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVaccineFundingSource](
	[VaccineFundingSourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVaccineFundingSource_VaccineFundingSourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListVaccineFundingSource_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVaccineFundingSource_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVaccineFundingSource_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVaccineMfr]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVaccineMfr](
	[VaccineMfrUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVaccineMfr_VaccineMfrUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListVaccineMfr_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVaccineMfr_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVaccineMfr_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVaccineRoute]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVaccineRoute](
	[VaccineRouteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVaccineRoute_VaccineRouteUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListVaccineRoute_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVaccineRoute_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVaccineRoute_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVaccineSite]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVaccineSite](
	[VaccineSiteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVaccineSite_VaccineSiteUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListVaccineSite_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVaccineSite_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVaccineSite_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListValueCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListValueCode](
	[ValueCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListValueCode_ValueCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListValueCode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListValueCode_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListValueCode_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVFCEligibility]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVFCEligibility](
	[VFCEligibilityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVFCEligibility_VFCEligibilityUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Description] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVFCEligibility_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListVFCEligibility_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVFCEligibility_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVisitType]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVisitType](
	[VisitTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVisitType_VisitTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVisitType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListVisitType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVisitType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListVoiceTag]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListVoiceTag](
	[VoiceTagUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListVoiceTag_VoiceTagUid]  DEFAULT (newid()),
	[AttachmentContent] [varbinary](max) NULL,
	[AttachmentContentType] [varchar](50) NULL,
	[AttachmentContentSize] [int] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListVoiceTag_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListVoiceTag_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListVoiceTag_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListWaitingListPriority]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListWaitingListPriority](
	[WaitingListPriorityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListWaitingListPriority_WaitingListPriorityUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListWaitingListPriority_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Color] [char](6) NOT NULL CONSTRAINT [DF_ListWaitingListPriority_Color]  DEFAULT ('000000'),
	[Priority] [int] NOT NULL CONSTRAINT [DF_ListWaitingListPriority_Priority]  DEFAULT ((5)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListWaitingListPriority_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListWeightConditions]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListWeightConditions](
	[WeightConditionsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListWeightConditions_WeightConditionsUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListWeightConditions_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListWeightConditions_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListWeightConditions_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListZip]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListZip](
	[ZipUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListZip_ZipUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](10) NOT NULL,
	[City] [varchar](25) NULL,
	[CityCode] [varchar](20) NULL,
	[State] [varchar](3) NULL,
	[StateCode] [varchar](10) NULL,
	[Country] [varchar](100) NULL,
	[CountryCode] [varchar](10) NULL,
	[AreaCode] [varchar](4) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListZip_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListZip_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListZip_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Lock]') AND type in (N'U'))
BEGIN
CREATE TABLE [Lock](
	[LockUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[LockInstance] [uniqueidentifier] NULL,
	[LockedUid] [uniqueidentifier] NOT NULL,
	[LockByUid] [uniqueidentifier] NULL,
	[LockDate] [datetime] NOT NULL,
	[LockType] [varchar](200) NULL,
	[LockDateStart] [datetime] NOT NULL,
	[HostName] [varchar](256) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MaintenanceDrugClass]') AND type in (N'U'))
BEGIN
CREATE TABLE [MaintenanceDrugClass](
	[MaintenanceDrugClassUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[AHFSClassID] [varchar](6) NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MapItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [MapItem](
	[MapItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MapItem_MapItemUid]  DEFAULT (newid()),
	[MapSourceUid] [uniqueidentifier] NULL,
	[FindTableFromItemUid] [uniqueidentifier] NULL,
	[MapItemFromName] [varchar](100) NULL,
	[FindTableToItemUid] [uniqueidentifier] NULL,
	[MapItemToName] [varchar](100) NULL,
	[SubstitutionText] [varchar](200) NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_MapItem_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MapItem_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_MapItem_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MapItem_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MapSource]') AND type in (N'U'))
BEGIN
CREATE TABLE [MapSource](
	[MapSourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[FindTableFromUid] [uniqueidentifier] NULL,
	[FindTableToUid] [uniqueidentifier] NULL,
	[MapDirection] [tinyint] NOT NULL CONSTRAINT [DF_MapSource_MapDirection]  DEFAULT ((3)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MapSource_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_MapSource_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterLabProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterLabProcedure](
	[MasterLabProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[OrderCode] [nchar](10) NOT NULL,
	[Description] [nchar](1000) NULL,
	[TemperatureType] [nchar](2) NULL,
	[PrintRequisition] [nchar](1) NULL,
	[Garbage] [nchar](10) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[IsModified] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterLabProcedureSecondary]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterLabProcedureSecondary](
	[MasterLabProcedureSecondaryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MasterLabProcedureUid] [uniqueidentifier] NOT NULL,
	[OrderCode] [nchar](10) NOT NULL,
	[CptCode] [nchar](10) NOT NULL,
	[TemperatureType] [nchar](10) NULL,
	[Description] [nchar](1000) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[IsModified] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterPharmacy]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterPharmacy](
	[MasterPharmacyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MasterPharmacy_MasterPharmacyUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](256) NOT NULL,
	[Address] [xml](CONTENT [Address]) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Phone3] [xml](CONTENT [Phone]) NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[PharmacyID] [varchar](64) NOT NULL,
	[Email] [varchar](512) NULL,
	[CrossStreet] [varchar](256) NULL,
	[ServiceLevelCode] [int] NULL,
	[PartnerAccount] [varchar](64) NOT NULL CONSTRAINT [DF_MasterPharmacy_PartnerAccount]  DEFAULT (''),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MasterPharmacy_UserDefined]  DEFAULT ((1)),
	[NPI] [varchar](64) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_MasterPharmacy_Deleted]  DEFAULT ((0)),
	[MailOrderEnabled] [bit] NOT NULL CONSTRAINT [DF_MasterPharmacy_MailOrderEnabled]  DEFAULT ((0)),
	[IsFaxOnly] [bit] NOT NULL CONSTRAINT [DF_MasterPharmacy_IsFaxOnly]  DEFAULT ((0)),
	[SpecialtyID] [int] NULL,
	[FileID] [varchar](64) NULL,
	[StateLicenseNumber] [varchar](64) NULL,
	[MedicareNumber] [varchar](64) NULL,
	[MedicaidNumber] [varchar](64) NULL,
	[PPONumber] [varchar](64) NULL,
	[PayerID] [varchar](64) NULL,
	[BINLocationNumber] [varchar](64) NULL,
	[DEANumber] [varchar](64) NULL,
	[HIN] [varchar](64) NULL,
	[SecondaryCoverage] [varchar](64) NULL,
	[NAICCode] [varchar](64) NULL,
	[PromotionNumber] [varchar](64) NULL,
	[SocialSecurity] [varchar](64) NULL,
	[PriorAuthorization] [varchar](64) NULL,
	[MutuallyDefined] [varchar](64) NULL,
	[ServiceLevelCodeXML] [xml](CONTENT [DirectoryServiceLevel]) NULL,
	[SpecialtyTypeXML] [xml](CONTENT [DirectorySpecialtyType]) NULL,
	[OrganizationID] [varchar](64) NULL,
	[ParentOrganizationID] [varchar](64) NULL,
	[DirectAddress] [varchar](512) NULL,
	[DownloadXML] [xml] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MasterPharmacy_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterProcedureToLoinc]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterProcedureToLoinc](
	[MasterProcedureToLoincUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MasterProcedureToLoinc_MasterProcedureToLoincUid]  DEFAULT (newid()),
	[PROCIT_VOCAB_IMO_CODE] [varchar](15) NOT NULL,
	[SHORT_TEXT] [varchar](100) NOT NULL,
	[LOINC_CODE] [varchar](20) NOT NULL,
	[IMO_TEXT] [varchar](1000) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MasterProcedureToLoinc_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MasterProcedureToLoinc_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterReimbursementRule]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterReimbursementRule](
	[MasterReimbursementRuleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Name] [varchar](100) NULL,
	[ImportFilename] [varchar](1000) NULL,
	[ImportDate] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterReimbursementRuleTrigger]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterReimbursementRuleTrigger](
	[MasterReimbursementRuleTriggerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MasterReimbursementRuleUid] [uniqueidentifier] NOT NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[AgeRangeFrom] [int] NULL,
	[AgeRangeTo] [int] NULL,
	[DaysSinceLastTest] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterRelReimbursementRuleDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterRelReimbursementRuleDiagnosis](
	[MasterRelReimbursementRuleDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MasterReimbursementRuleTriggerUid] [uniqueidentifier] NOT NULL,
	[MasterDiagnosisUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterRelReimbursementRuleProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterRelReimbursementRuleProcedure](
	[MasterRelReimbursementRuleProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MasterReimbursementRuleTriggerUid] [uniqueidentifier] NOT NULL,
	[MasterProcedureUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MasterSnomedDescription]') AND type in (N'U'))
BEGIN
CREATE TABLE [MasterSnomedDescription](
	[DescriptionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MasterSnomedDescription_DescriptionUid]  DEFAULT (newid()),
	[id] [bigint] NOT NULL,
	[effectiveTime] [date] NOT NULL,
	[moduleId] [bigint] NOT NULL,
	[conceptId] [bigint] NOT NULL,
	[languageCode] [varchar](2) NOT NULL,
	[typeId] [bigint] NOT NULL,
	[term] [varchar](255) NOT NULL,
	[category] [varchar](255) NULL,
	[caseSignificanceId] [bigint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MasterSnomedDescription_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_MasterSnomedDescription_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MasterSnomedDescription_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MDOL_RPT2_ActiveReport]') AND type in (N'U'))
BEGIN
CREATE TABLE [MDOL_RPT2_ActiveReport](
	[ActiveReportUid] [uniqueidentifier] NOT NULL,
	[ReportUid] [uniqueidentifier] NOT NULL,
	[ActiveReportText] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MeaningfulUseCategoryDefinition]') AND type in (N'U'))
BEGIN
CREATE TABLE [MeaningfulUseCategoryDefinition](
	[CategoryUid] [uniqueidentifier] NOT NULL,
	[CategoryName] [varchar](100) NOT NULL,
	[CategoryNumber] [int] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MeaningfulUseItemDefinition]') AND type in (N'U'))
BEGIN
CREATE TABLE [MeaningfulUseItemDefinition](
	[ItemDefinitionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MeaningfulUseItemDefinition_ItemDefinitionUid]  DEFAULT (newid()),
	[StageUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MeaningfulUseItemDefinition_StageUid]  DEFAULT ('A787EE10-430D-4623-828B-2EF1C4A4EC0E'),
	[CategoryUid] [uniqueidentifier] NOT NULL,
	[MeasureNumber] [int] NOT NULL,
	[SubMeasureNumber] [int] NULL,
	[ObjectiveDesc] [varchar](500) NULL,
	[MeasureDesc] [varchar](600) NOT NULL,
	[MeasureDetailDesc] [varchar](600) NULL,
	[ExclusionDesc] [varchar](600) NULL,
	[DenominatorDesc] [varchar](500) NULL,
	[NumeratorDesc] [varchar](500) NULL,
	[YesNo] [varchar](50) NULL,
	[GoalDesc] [varchar](250) NULL,
	[GoalValue] [decimal](5, 2) NULL,
	[WorkflowNumeratorDefinitionUid] [uniqueidentifier] NULL,
	[WorkflowDenominatorDefinitionUid] [uniqueidentifier] NULL,
	[WorkflowReportDefinitionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MeaningfulUseItemDefinition_UserDefined]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MeaningfulUseItemDefinition_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MeaningfulUseStageDefinition]') AND type in (N'U'))
BEGIN
CREATE TABLE [MeaningfulUseStageDefinition](
	[StageUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MeaningfulUseStageDefinition_StageUid]  DEFAULT (newid()),
	[StageName] [varchar](100) NOT NULL,
	[StageNumber] [int] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MeaningfulUseStageDefinition_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MedicalServicesProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [MedicalServicesProvider](
	[CorporationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[MedicalServicesTypeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MedicationSIG]') AND type in (N'U'))
BEGIN
CREATE TABLE [MedicationSIG](
	[MedicationSIGUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MedicationSIG_MedicationUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[DiscontinueReasonUid] [uniqueidentifier] NULL,
	[PharmacyUid] [uniqueidentifier] NULL,
	[EduFormUid] [uniqueidentifier] NULL,
	[SIGQuantityUnitOfMeasureUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[MedicationCategoryUid] [uniqueidentifier] NULL,
	[MedicationPRNReasonUid] [uniqueidentifier] NULL,
	[FDB_MEDID] [int] NOT NULL CONSTRAINT [DF_MedicationSIG_FDB_MEDID]  DEFAULT ((0)),
	[FDB_GCN_SEQNO] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_GCN_SEQNO]  DEFAULT ((0)),
	[FDB_HIC_SEQN] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_HIC_SEQN]  DEFAULT ((0)),
	[FDB_MNID] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_MNID]  DEFAULT ((0)),
	[FDB_CLASSID] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_CLASSID]  DEFAULT ((0)),
	[FDB_RMID] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_RMID]  DEFAULT ((0)),
	[RefillQuantity] [smallint] NULL,
	[Name] [varchar](255) NULL,
	[DrugName] [varchar](255) NULL,
	[FederalDEAClassCode] [varchar](50) NULL,
	[Strength] [varchar](255) NULL,
	[StrengthUnits] [varchar](255) NULL,
	[Route] [varchar](255) NULL,
	[OverallStartDate] [date] NULL,
	[OverallStopDate] [date] NULL,
	[DiscontinueRecordDate] [date] NULL,
	[DispenseAsWritten] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_DispenseAsWritten]  DEFAULT ((0)),
	[IsSampleGiven] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsSampleGiven]  DEFAULT ((0)),
	[IsMaintenanceDrug] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsMaintenanceDrug]  DEFAULT ((0)),
	[IsAdministered] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsAdministrered]  DEFAULT ((0)),
	[IsRefill] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsRefill]  DEFAULT ((0)),
	[IsRevised] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsRevised]  DEFAULT ((0)),
	[IsPRN] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsPRN]  DEFAULT ((0)),
	[FullTextSIG] [varchar](max) NULL,
	[AuthorCode] [varchar](40) NULL,
	[HxSource] [varchar](50) NULL,
	[HxSourceNotes] [varchar](max) NULL,
	[HxProvider] [varchar](100) NULL,
	[ReasonForOverrideScreening] [varchar](max) NULL,
	[DrugScreeningResult] [varchar](max) NULL,
	[LotNumber] [varchar](50) NULL,
	[MedicationMfrUid] [uniqueidentifier] NULL,
	[Initials] [varchar](25) NULL,
	[MedicationSiteUid] [uniqueidentifier] NULL,
	[MedicationFundingSourceUid] [uniqueidentifier] NULL,
	[ExpirationDate] [date] NULL,
	[VISDateGiven] [date] NULL,
	[VISDate] [date] NULL,
	[PatienteRxEligibilityUid] [uniqueidentifier] NULL,
	[NDC] [varchar](11) NULL,
	[RXNORMCode] [varchar](15) NULL,
	[RXNORMQualifier] [varchar](10) NULL,
	[AdministeredDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[MedicationConsentInfo] [xml](CONTENT [MedicationConsentData]) NULL,
	[CreatedBy] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NULL CONSTRAINT [DF_MedicationSIG_CreatedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MedicationSIG_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MedicationSIG_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Message]') AND type in (N'U'))
BEGIN
CREATE TABLE [Message](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Message_MessageUid]  DEFAULT (newid()),
	[ParentMessageUid] [uniqueidentifier] NULL,
	[CreatedByUid] [uniqueidentifier] NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[MessageTypeUid] [uniqueidentifier] NOT NULL,
	[MessageSubTypeUid] [uniqueidentifier] NULL,
	[Header] [varchar](8000) NULL,
	[MessageUrgencyUid] [uniqueidentifier] NULL,
	[MessageStatusUid] [uniqueidentifier] NULL,
	[CreatedDate] [date] NOT NULL CONSTRAINT [DF_Message_CreatedDate]  DEFAULT (getdate()),
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_Message_DateCreated]  DEFAULT (getutcdate()),
	[DateToBeCompleted] [datetime] NULL,
	[AutoComplete] [bit] NOT NULL CONSTRAINT [DF_Message_AutoComplete]  DEFAULT ((0)),
	[DateCompleted] [datetime] NULL,
	[LastReadByUid] [uniqueidentifier] NULL,
	[CompletedByUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[StrikeOut] [bit] NOT NULL CONSTRAINT [DF_Message_StrikeOut_1]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Msgs_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageDataXML] [xml] NULL,
	[FirstReadDate] [datetime] NULL,
	[MessageXML] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageAA]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageAA](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RelAttachmentGroupUid] [uniqueidentifier] NULL,
	[VoiceAttachmentUid] [uniqueidentifier] NULL,
	[Phone] [xml](CONTENT [Phone]) NULL,
	[Approved] [bit] NOT NULL CONSTRAINT [DF_MessageAA_Approved]  DEFAULT ((0)),
	[Rejected] [bit] NOT NULL CONSTRAINT [DF_MessageAA_Rejected]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[HasClinicalDocument] [bit] NOT NULL CONSTRAINT [DF_MessageAA_HasClinicalDocument]  DEFAULT ((0)),
	[ElectronicSummaryOfCareReceived] [bit] NOT NULL CONSTRAINT [DF_MessageAA_ElectronicSummaryOfCareReceived]  DEFAULT ((0)),
	[SummaryOfCareReconciledDate] [date] NULL,
	[MedicationsReconciledDate] [date] NULL,
	[MedicationAllergiesReconciledDate] [date] NULL,
	[ProblemsReconciledDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageAA_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageAN]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageAN](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[Note] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageAttachHTML]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageAttachHTML](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AttachmentName] [nvarchar](50) NULL,
	[Notes] [varchar](max) NULL,
	[HTML] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageAuthorization]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageAuthorization](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageAuthorization_MessageUid]  DEFAULT (newid()),
	[RenderingProviderUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ReferringProviderUid] [uniqueidentifier] NULL,
	[ServiceDate] [date] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[CaseAuthorizationUid] [uniqueidentifier] NULL,
	[Note] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageAuthorization_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageBackfillQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageBackfillQueue](
	[MessageBackfillQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[HL7PartnerMessageUid] [uniqueidentifier] NULL,
	[HL7ActionTypeObjectUid] [uniqueidentifier] NULL,
	[TransmissionOutboundUid] [uniqueidentifier] NULL,
	[TransmissionType] [varchar](50) NULL,
	[ActionType] [varchar](50) NULL,
	[ObjectType] [varchar](50) NULL,
	[ObjectUid] [uniqueidentifier] NULL,
	[MessageContextXML] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ProcessingError] [bit] NOT NULL,
	[Status] [int] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageClaimError]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageClaimError](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageClaimError_MessageUid]  DEFAULT (newid()),
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageClaimError_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[DepositUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageCollection]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageCollection](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageCollection_MessageUid]  DEFAULT (newid()),
	[AccountResponsiblePartyUid] [uniqueidentifier] NULL,
	[InsurancePromiseUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageCollection_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageeRxEligibility]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageeRxEligibility](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Body] [varchar](max) NULL,
	[eRxEligibilityOutboundUid] [uniqueidentifier] NULL,
	[eRxInboundUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageeRxMedicationHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageeRxMedicationHistory](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Body] [varchar](max) NULL,
	[eRxMedicationHistoryOutboundUid] [uniqueidentifier] NULL,
	[eRxInboundUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageERxRefillRequest]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageERxRefillRequest](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Body] [varchar](max) NULL,
	[eRxInboundUid] [uniqueidentifier] NULL,
	[eRxOutboundUid] [uniqueidentifier] NULL,
	[AcceptRefillRequest] [tinyint] NULL,
	[eRxMessageDenyReasonUid] [uniqueidentifier] NULL,
	[ResponseComment] [varchar](max) NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[RelVisitMedicationUid] [uniqueidentifier] NULL,
	[DAW] [bit] NULL,
	[RefillQuantity] [smallint] NOT NULL,
	[MessageID] [varchar](50) NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[RespondingProviderUid] [uniqueidentifier] NULL,
	[MasterPharmacyUid] [uniqueidentifier] NULL,
	[MessageReceived] [varchar](max) NULL,
	[MessageXML] [xml] NULL,
	[SubmitByUid] [uniqueidentifier] NULL,
	[SupervisingProviderUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[RelatesToMessageID] [varchar](50) NULL,
	[RxReferenceNumber] [varchar](50) NULL,
	[PrescriberOrderNumber] [varchar](50) NULL,
	[OutboundRequestXML] [xml](CONTENT [eRxRequestXML]) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageFolderRoute]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageFolderRoute](
	[MessageFolderRouteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AssignToUserUid] [uniqueidentifier] NULL,
	[AssignToUserGroupUid] [uniqueidentifier] NULL,
	[MessageTypeUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageHL7]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageHL7](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ObservationOrderUid] [uniqueidentifier] NULL,
	[ReviewNotes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageHL7_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageInstantMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageInstantMessage](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[InstantMessageUid] [uniqueidentifier] NOT NULL,
	[SuperbillUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageInstantMessage_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageNote]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageNote](
	[MessageNoteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageNote_MessageNoteUid]  DEFAULT (newid()),
	[MessageUid] [uniqueidentifier] NOT NULL,
	[Note] [varchar](max) NOT NULL,
	[CreatedByUid] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_MessageNote_CreatedDate]  DEFAULT (getutcdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageNote_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessagePatientLabOrder]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessagePatientLabOrder](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessagePatientLabOrder_MessageUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NULL,
	[Note] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessagePatientLabOrder_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessagePatientReferral]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessagePatientReferral](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MessageXml] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Note] [varchar](max) NULL,
	[PatientReferralUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageRecipientHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageRecipientHistory](
	[MessageRecipientHistoryUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MessageRecipientHistory_MessageRecipientHistoryUid]  DEFAULT (newid()),
	[MessageUid] [uniqueidentifier] NOT NULL,
	[UserList] [varchar](max) NOT NULL,
	[Header] [varchar](8000) NOT NULL,
	[AssignmentDate] [datetime] NOT NULL CONSTRAINT [DF_MessageRecipientHistory_AssignmentDate]  DEFAULT (getutcdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageRecipientHistory_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageRx]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageRx](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Body] [varchar](max) NULL,
	[eRxOutboundUid] [uniqueidentifier] NULL,
	[eRxInboundUid] [uniqueidentifier] NULL,
	[VisitMedicationUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageXML] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageRxRefill]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageRxRefill](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageRxRefillRequest_MessageUid]  DEFAULT (newid()),
	[Body] [varchar](max) NULL,
	[Phone] [xml](CONTENT [Phone]) NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[PharmacyUid] [uniqueidentifier] NULL,
	[Medication] [varchar](max) NULL,
	[ResponseComment] [varchar](max) NULL,
	[AcceptRefillRequest] [tinyint] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[RelVisitMedicationUid] [uniqueidentifier] NULL,
	[DAW] [bit] NULL,
	[RefillQuantity] [smallint] NOT NULL CONSTRAINT [DF_MessageRxRefill_RefillQuantity]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageRxRefillRequest_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[SupervisingProviderUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[Computed_Phone_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone_PhoneType] [varchar](50) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageRxRefillMedication]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageRxRefillMedication](
	[MessageRxRefillMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageRxRefillMedication_MessageRxRefillMedicationUid]  DEFAULT (newid()),
	[MessageRxRefillUid] [uniqueidentifier] NOT NULL,
	[MedicationRequested] [varchar](max) NOT NULL,
	[RelPatientMedicationUid] [uniqueidentifier] NULL,
	[RequestComment] [varchar](max) NULL,
	[ResponseComment] [varchar](max) NULL,
	[AcceptRefillRequest] [tinyint] NULL,
	[RelVisitMedicationUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageRxRefillMedication_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageSurvey]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageSurvey](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MessageXml] [varchar](max) NULL,
	[CompleteHtml] [varchar](max) NULL,
	[CompleteRequest] [tinyint] NULL CONSTRAINT [DF_MessageSurvey_CompleteRequest]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__MessageSu__LastM__106CDA50]  DEFAULT (getutcdate()),
	[LastReadByPortalDate] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageTask]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageTask](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CPODate] [date] NULL,
	[CPOMinutes] [smallint] NULL,
	[CPOProviderUid] [uniqueidentifier] NULL,
	[CPOApproved] [bit] NULL,
	[PatientHMRuleUid] [uniqueidentifier] NULL,
	[Note] [varchar](max) NULL,
	[GenerationInstructions] [xml] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageTask_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageTC]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageTC](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Phone] [xml](CONTENT [Phone]) NULL,
	[Reason] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageTC_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Computed_Phone_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone_PhoneType] [varchar](50) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageUncomplete]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageUncomplete](
	[MessageUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageUncomplete_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageUser]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageUser](
	[MessageUserUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageUser_MessageUserUid]  DEFAULT (newid()),
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[MessageUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageUser_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageVaccineAdministration]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageVaccineAdministration](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MessageXml] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Note] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MessageVisitBilling]') AND type in (N'U'))
BEGIN
CREATE TABLE [MessageVisitBilling](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[Note] [varchar](max) NULL,
	[VisitChangesXML] [varchar](max) NULL,
	[SuperbillChangesXML] [varchar](max) NULL,
	[Approved] [bit] NOT NULL,
	[ApprovedByUid] [uniqueidentifier] NULL,
	[ApproveDate] [datetime] NULL,
	[DxChanged] [bit] NOT NULL,
	[SPChanged] [bit] NOT NULL,
	[UnitChanged] [bit] NOT NULL,
	[ModifierChanged] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MPIQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [MPIQueue](
	[MPIQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[SendFunction] [varchar](50) NULL,
	[InsertedDate] [datetime] NOT NULL,
	[MessageDate] [datetime] NULL,
	[Inactive] [bit] NOT NULL,
	[Error] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[MU2_InterfaceDataMapping]') AND type in (N'U'))
BEGIN
CREATE TABLE [MU2_InterfaceDataMapping](
	[InterfaceDataMappingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_InterfaceDataMappingUid]  DEFAULT (newid()),
	[Rootid] [varchar](40) NOT NULL,
	[Name] [varchar](100) NULL,
	[CCDCode] [varchar](25) NOT NULL,
	[PRMCode] [varchar](25) NULL,
	[CCDPrintName] [varchar](250) NULL,
	[IsDefault] [bit] NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_Default]  DEFAULT ((0)),
	[Inactive] [bit] NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[NCQMeasure] [varchar](10) NULL,
	[TopicIndicator] [varchar](50) NULL,
	[NQFNumber] [varchar](10) NULL,
	[DataElementName] [varchar](100) NULL,
	[Modifier] [varchar](25) NULL,
	[EndDate] [varchar](25) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_MU2Interface_DisplayOrder]  DEFAULT ((0)),
	[QRDASection] [varchar](50) NULL,
	[CQMVersion] [varchar](7) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NewSnomeds]') AND type in (N'U'))
BEGIN
CREATE TABLE [NewSnomeds](
	[id] [varchar](255) NULL,
	[effectiveTime] [varchar](50) NULL,
	[active] [varchar](50) NULL,
	[moduleId] [varchar](50) NULL,
	[conceptId] [varchar](50) NULL,
	[languageCode] [varchar](50) NULL,
	[typeId] [varchar](50) NULL,
	[term] [varchar](255) NULL,
	[caseSignificanceId] [varchar](50) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NoteFilterApprover]') AND type in (N'U'))
BEGIN
CREATE TABLE [NoteFilterApprover](
	[NoteFilterApproverUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[NoteFilterUid] [uniqueidentifier] NOT NULL,
	[ApproverUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NoteFilterForwarder]') AND type in (N'U'))
BEGIN
CREATE TABLE [NoteFilterForwarder](
	[NoteFilterForwarderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_NoteFilterForwarder_NoteFilterForwarderUid]  DEFAULT (newid()),
	[NoteFilterUid] [uniqueidentifier] NOT NULL,
	[ForwarderUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NoteFilterForwarder_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[NoteFilterUser]') AND type in (N'U'))
BEGIN
CREATE TABLE [NoteFilterUser](
	[NoteFilterUserUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_NoteFilterUser_NoteFilterUserUid]  DEFAULT (newid()),
	[NoteFilterUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_NoteFilterUser_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ObservationOrder]') AND type in (N'U'))
BEGIN
CREATE TABLE [ObservationOrder](
	[ObservationOrderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ObservationOrder_ObservationOrderUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ObservationUid] [uniqueidentifier] NULL,
	[OrderProviderUid] [uniqueidentifier] NULL,
	[PerformProviderUid] [uniqueidentifier] NULL,
	[LaboratoryUid] [uniqueidentifier] NULL,
	[LabSourceUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[ApproveProviderUid] [uniqueidentifier] NULL,
	[TrackingNum] [varchar](24) NULL,
	[OrderDate] [date] NULL,
	[OrderDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[PerformDate] [date] NULL,
	[PerformDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[ReceiveDate] [date] NULL,
	[ReceiveDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[ResultDate] [date] NULL,
	[ResultDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[ExtractDate] [date] NULL,
	[ExtractDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[CollectionDate] [date] NULL,
	[CollectionDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[ResultStatusID] [smallint] NULL,
	[ResultStatusCode] [char](2) NULL,
	[AbnormalFlagCode] [char](2) NULL,
	[ApproveDate] [date] NULL,
	[DueDate] [date] NULL,
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[CaseTypePhaseUid] [uniqueidentifier] NULL,
	[ElectronicResult] [bit] NOT NULL CONSTRAINT [DF_ObservationOrder_ElectronicResult]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_ObservationOrder_IsDelete]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_ObservationOrder_IsAddendum]  DEFAULT ((0)),
	[ImedicaAccessionNumber] [varchar](25) NULL,
	[LabAccessionNumber] [varchar](25) NULL,
	[Technician] [varchar](100) NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[BillTypeUid] [uniqueidentifier] NULL,
	[Fasting] [bit] NULL CONSTRAINT [DF_ObservationOrder_Fasting_1]  DEFAULT ((0)),
	[PSC] [bit] NULL CONSTRAINT [DF_ObservationOrder_DrawnInHouse_1]  DEFAULT ((0)),
	[LaboratoryOrderUid] [uniqueidentifier] NULL,
	[GenerateLabOrder] [bit] NOT NULL CONSTRAINT [DF_ObservationOrder_GenerateLabOrder]  DEFAULT ((0)),
	[ParentObservationOrderUid] [uniqueidentifier] NULL,
	[ResultingUserDefinedTemplateUid] [uniqueidentifier] NULL,
	[ResultingUserDefinedProcedureNoteText] [varchar](max) NULL,
	[ResultingUserDefinedProcedureNoteXml] [varchar](max) NULL,
	[ResultingDpnGroupUid] [uniqueidentifier] NULL,
	[ResultingDpnXml] [xml] NULL,
	[ResultingVisitUid] [uniqueidentifier] NULL,
	[ObservationOrderResultStatusUid] [uniqueidentifier] NULL CONSTRAINT [DF_ObservationOrder_ListObservationOrderResultStatusUid]  DEFAULT ('4AE36BB9-8A98-4EA6-AB4A-85BE6D95BDD4'),
	[MessageUrgencyUid] [uniqueidentifier] NULL CONSTRAINT [DF_ObservationOrder_MessageUrgencyUid]  DEFAULT ('C2A64D38-3BE1-4F8A-8947-EF9E9AD861A4'),
	[SpecimenTypeXML] [varchar](max) NULL,
	[SpecimenRejectReasonXML] [varchar](max) NULL,
	[SpecimenConditionXML] [varchar](max) NULL,
	[TimeQuantityStart] [datetime] NULL,
	[TimeQuantityEnd] [datetime] NULL,
	[RelevantClinicalXML] [varchar](max) NULL,
	[SpecimenActionUid] [uniqueidentifier] NULL,
	[PlacerGroupNumber] [varchar](100) NULL,
	[Cancel] [bit] NOT NULL CONSTRAINT [DF_ObservationOrder_Cancel]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ObservationOrder_Inactive]  DEFAULT ((0)),
	[CreatedBy] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NULL CONSTRAINT [DF_ObservationOrder_CreatedDate]  DEFAULT (getutcdate()),
	[PatientMessageDate] [date] NULL,
	[UserMessageDate] [date] NULL,
	[OverdueMessageDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ObservationOrder_LastModifiedDate]  DEFAULT (getutcdate()),
	[FirstReadDate] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ObservationOrderResultStatusHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ObservationOrderResultStatusHistory](
	[ObservationOrderResultStatusHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ObservationOrderResultStatusHistory_ObservationOrderResultStatusHistoryUid]  DEFAULT (newid()),
	[ObservationOrderUid] [uniqueidentifier] NOT NULL,
	[ObservationOrderResultStatusUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ObservationOrderResultStatusHistory_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ObservationValue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ObservationValue](
	[ObservationValueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ObservationValue_ObservationValueUid]  DEFAULT (newid()),
	[ObservationOrderUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[LaboratoryUid] [uniqueidentifier] NULL,
	[ObservationItemUid] [uniqueidentifier] NULL,
	[Name] [varchar](100) NULL,
	[ObservationValue] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ObservationValue_DisplayOrder]  DEFAULT ((0)),
	[StringValue] [varchar](max) NULL,
	[IntegerValue] [int] NULL,
	[FloatValue] [float] NULL,
	[DateValue] [date] NULL,
	[DateTimeValue] [datetime] NULL,
	[MetricValue1] [decimal](14, 6) NULL,
	[MetricValue2] [decimal](14, 6) NULL,
	[MetricUnits] [varchar](25) NULL,
	[Modifier1Uid] [uniqueidentifier] NULL,
	[Modifier1Name] [varchar](50) NULL,
	[Modifier2Uid] [uniqueidentifier] NULL,
	[Modifier2Name] [varchar](50) NULL,
	[Modifier3Uid] [uniqueidentifier] NULL,
	[Modifier3Name] [varchar](50) NULL,
	[ReferenceRange] [varchar](255) NULL,
	[ResultStatusCode] [char](2) NULL,
	[AbnormalFlagCode] [char](2) NULL,
	[Notes] [varchar](max) NULL,
	[ResultStatusID] [smallint] NULL,
	[IsVitals] [bit] NOT NULL CONSTRAINT [DF_ObservationValue_IsVitals]  DEFAULT ((0)),
	[LaboratoryLocationUid] [uniqueidentifier] NULL,
	[ApproveProviderUid] [uniqueidentifier] NULL,
	[ApproveDate] [datetime] NULL,
	[ReferenceMin] [varchar](100) NULL,
	[ReferenceMax] [varchar](100) NULL,
	[EnteredByUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ObservationValue_LastModifiedDate]  DEFAULT (getutcdate()),
	[MeasurementUnits] [varchar](50) NULL,
	[StringMin] [varchar](100) NULL,
	[StringMax] [varchar](100) NULL,
	[LOINC] [varchar](10) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[OptOut]') AND type in (N'U'))
BEGIN
CREATE TABLE [OptOut](
	[OptOutUid] [uniqueidentifier] NOT NULL,
	[EmailAddress] [varchar](255) NOT NULL,
	[AccessCode] [varchar](25) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[OrganizationDirectory]') AND type in (N'U'))
BEGIN
CREATE TABLE [OrganizationDirectory](
	[OrganizationDirectoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[OrganizationName] [varchar](255) NOT NULL,
	[OrganizationType] [varchar](255) NULL,
	[OrganizationID] [varchar](255) NOT NULL,
	[ParentOrganizationID] [varchar](255) NULL,
	[Address] [xml](CONTENT [Address]) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Phone3] [xml](CONTENT [Phone]) NULL,
	[Phone4] [xml](CONTENT [Phone]) NULL,
	[Phone5] [xml](CONTENT [Phone]) NULL,
	[Phone6] [xml](CONTENT [Phone]) NULL,
	[Phone7] [xml](CONTENT [Phone]) NULL,
	[Phone8] [xml](CONTENT [Phone]) NULL,
	[Email] [varchar](255) NULL,
	[ActiveStartTime] [varchar](255) NULL,
	[ActiveEndTime] [varchar](255) NULL,
	[ServiceLevelList] [varchar](max) NULL,
	[SpecialtyTypeList] [varchar](max) NULL,
	[DirectAddress] [varchar](2048) NULL,
	[NPI] [varchar](255) NULL,
	[DefaultLocationServiceLevel] [int] NULL,
	[Testflag] [varchar](255) NULL,
	[NCPDPID] [varchar](255) NULL,
	[StoreNumber] [varchar](255) NULL,
	[CrossStreet] [varchar](255) NULL,
	[FileID] [varchar](255) NULL,
	[StateLicenseNumber] [varchar](255) NULL,
	[MedicareNumber] [varchar](255) NULL,
	[MedicaidNumber] [varchar](255) NULL,
	[PPONumber] [varchar](255) NULL,
	[PayerID] [varchar](255) NULL,
	[BINLocationNumber] [varchar](255) NULL,
	[DEANumber] [varchar](255) NULL,
	[HIN] [varchar](255) NULL,
	[SecondaryCoverage] [varchar](255) NULL,
	[NAICCode] [varchar](255) NULL,
	[PromotionNumber] [varchar](255) NULL,
	[SocialSecurity] [varchar](255) NULL,
	[PriorAuthorization] [varchar](255) NULL,
	[MutuallyDefined] [varchar](255) NULL,
	[UseCases] [varchar](max) NULL,
	[DownloadXML] [xml] NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[InStoreNCPDPID] [varchar](255) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[OutlookSynchronized]') AND type in (N'U'))
BEGIN
CREATE TABLE [OutlookSynchronized](
	[OutlookSynchronizedUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AppointmentUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[OutlookEntryID] [nvarchar](max) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Patient]') AND type in (N'U'))
BEGIN
CREATE TABLE [Patient](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Patient_Inactive]  DEFAULT ((0)),
	[MedicalRecordNumber] [varchar](25) NULL,
	[PatientClassUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[DepartmentUid] [uniqueidentifier] NULL,
	[ReleaseInformation] [bit] NOT NULL CONSTRAINT [DF_Patient_ReleaseInformation]  DEFAULT ((0)),
	[ReleaseDate] [datetime] NULL,
	[SignatureOnFile] [bit] NOT NULL CONSTRAINT [DF_Patient_SignatureOnFile]  DEFAULT ((0)),
	[SignatureSourceUid] [uniqueidentifier] NULL,
	[AssignmentOfBenefitsUid] [uniqueidentifier] NULL,
	[PrivacyPolicyAcceptanceUid] [uniqueidentifier] NULL,
	[StudentStatusUid] [uniqueidentifier] NULL,
	[SchoolName] [varchar](50) NULL,
	[ResidenceTypeUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[eRXHPatientConsent] [bit] NOT NULL CONSTRAINT [DF_Patient_eRXHPatientConsent]  DEFAULT ((0)),
	[ScannedChartDate] [datetime] NULL,
	[UserDefinedXml] [xml] NULL,
	[ReferralSrcUid] [uniqueidentifier] NULL,
	[SupervisingProviderUid] [uniqueidentifier] NULL,
	[ImmzReminderRecallUid] [uniqueidentifier] NULL,
	[ActXStatus] [bit] NOT NULL CONSTRAINT [DF_Patient_ActXStatus]  DEFAULT ((0)),
	[ActXStatusCheckedDate] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Patient_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[BirthXml] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCareManagement]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCareManagement](
	[PatientCareManagementUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientCareManagement_PatientCareManagementUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Location] [varchar](500) NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[RequestDate] [date] NULL,
	[StatusUid] [uniqueidentifier] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[CareTypeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientCareManagement_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ForCertification] [bit] NOT NULL CONSTRAINT [DF_PatientCareManagement_ForCertification]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCareManagementLog]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCareManagementLog](
	[PatientCareManagementLogUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[LogDate] [date] NOT NULL,
	[LogMinutes] [int] NULL,
	[LoggedFromMessageUid] [uniqueidentifier] NULL,
	[LoggedFromVisitUid] [uniqueidentifier] NULL,
	[IsApproved] [bit] NULL,
	[IsCPO] [bit] NOT NULL,
	[IsCCM] [bit] NOT NULL,
	[Sent] [bit] NOT NULL,
	[Received] [bit] NOT NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MedicalDecisionComplexityHighOrMedium] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCase]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCase](
	[PatientCaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientCase_PatientCaseUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[CaseTypeUid] [uniqueidentifier] NULL,
	[CaseNum] [smallint] NULL,
	[Name] [varchar](100) NULL,
	[StartDate] [date] NULL,
	[EndDate] [date] NULL,
	[InitialVisitNum] [smallint] NOT NULL CONSTRAINT [DF_PatientCase_InitialVisitNum]  DEFAULT ((1)),
	[RemainingVisitNum] [smallint] NOT NULL CONSTRAINT [DF_PatientCase_RemainingVisitNum]  DEFAULT ((1)),
	[AuthorizationCode] [varchar](30) NULL,
	[AuthorizationExpirationDate] [date] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ReferredByProviderUid] [uniqueidentifier] NULL,
	[ReferringDate] [date] NULL,
	[CaseTypePhaseUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PatientCase_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientCase_LastModifiedDate]  DEFAULT (getutcdate()),
	[BillingDefaults] [xml] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCaseModuleData]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCaseModuleData](
	[PatientCaseModuleDataUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientCaseModuleData_PatientCaseModuleDataUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PatientCaseModuleData_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PatientCaseModuleData_UserDefined]  DEFAULT ((1)),
	[PatientCaseUid] [uniqueidentifier] NULL,
	[CaseTypeModuleUid] [uniqueidentifier] NULL,
	[ModuleData] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientCaseModuleData_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCP_CarePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCP_CarePlan](
	[PatientCP_CarePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[CP_CarePlanUid] [uniqueidentifier] NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[CreatedDate] [date] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[InactiveDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCP_CareTeam]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCP_CareTeam](
	[PatientCP_CareTeamUid] [uniqueidentifier] NOT NULL,
	[PatientCP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[UserUid] [uniqueidentifier] NULL,
	[PersonContactUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCP_GoalHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCP_GoalHistory](
	[PatientCP_GoalHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[CP_GoalUid] [uniqueidentifier] NULL,
	[ObservationItemUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[Achieved] [bit] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[Author] [smallint] NOT NULL,
	[Name] [varchar](100) NULL,
	[GoalValue] [varchar](max) NULL,
	[Value1] [decimal](14, 6) NULL,
	[Value2] [decimal](14, 6) NULL,
	[Operator] [smallint] NULL,
	[AchievedDateTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[AchievedDate] [date] NULL,
	[DateToAchieveTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[DateToAchieve] [date] NULL,
	[StartDateTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[StartDate] [date] NULL,
	[EndTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[EndDate] [date] NULL,
	[PatientPriority] [smallint] NOT NULL,
	[ProviderPriority] [smallint] NOT NULL,
	[StatusUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCP_GoalReviewHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCP_GoalReviewHistory](
	[PatientCP_GoalReviewHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_GoalHistoryUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[Comments] [varchar](max) NOT NULL,
	[Achieved] [bit] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCP_HealthConcernHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCP_HealthConcernHistory](
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[CP_HealthConcernUid] [uniqueidentifier] NULL,
	[Concern] [varchar](max) NULL,
	[PatientProblemDiagnosisUid] [uniqueidentifier] NULL,
	[PatientFamilyHistoryUid] [uniqueidentifier] NULL,
	[PatientProcedureHistoryUid] [uniqueidentifier] NULL,
	[PatientHistoryUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[IsRisk] [bit] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[PatientPriority] [smallint] NOT NULL,
	[ProviderPriority] [smallint] NOT NULL,
	[StatusUid] [uniqueidentifier] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientCP_InterventionHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientCP_InterventionHistory](
	[PatientCP_InterventionHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[Description] [varchar](max) NULL,
	[CompletedTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[CompletedDate] [date] NULL,
	[StatusUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientDefaultVisitAccess]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientDefaultVisitAccess](
	[PatientDefaultVisitAccessUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientDemographicsHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientDemographicsHistory](
	[PatientDemographicsHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientDemographicsHistory_PatientDemographicsHistoryUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Changes] [xml] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientDemographicsHistory_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatienteRxEligibility]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatienteRxEligibility](
	[PatienteRxEligibilityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[CoverageXML] [xml] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[PayorID] [varchar](100) NULL,
	[HealthPlanName] [varchar](100) NULL,
	[HealthPlanID] [varchar](50) NULL,
	[GroupName] [varchar](100) NULL,
	[GroupID] [varchar](50) NULL,
	[SubscriberID] [varchar](80) NULL,
	[FormularyOrgUid] [uniqueidentifier] NULL,
	[FormularyAlternativesOrgUid] [uniqueidentifier] NULL,
	[FormularyCoverageOrgUid] [uniqueidentifier] NULL,
	[FormularyCopayOrgUid] [uniqueidentifier] NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[EligibilityDate] [date] NULL,
	[MailOrderEligible] [bit] NOT NULL,
	[PharmacyEligible] [bit] NOT NULL,
	[LastDownloadedDateTime] [datetime] NULL,
	[FormularyID] [varchar](10) NULL,
	[AlternativesID] [varchar](10) NULL,
	[CopayID] [varchar](40) NULL,
	[CoverageID] [varchar](40) NULL,
	[InterchangeControlNumber] [varchar](50) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientFamilyHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientFamilyHistory](
	[PatientFamilyHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientFamilyHistory_PatientFamilyHistoryUid]  DEFAULT (newid()),
	[HxRelationshipUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[Name] [varchar](255) NULL,
	[BirthTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[BirthDate] [date] NULL,
	[DeathTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[DeathDate] [date] NULL,
	[IsMaternal] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistory_IsMaternal]  DEFAULT ((0)),
	[IsPaternal] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistory_IsPaternal]  DEFAULT ((0)),
	[NoKnownDisease] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistory_NoKnownDisease]  DEFAULT ((0)),
	[Unknown] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistory_Unknown]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistory_IsDelete]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientFamilyHistory_DisplayOrder]  DEFAULT ((0)),
	[RecordDateTime] [datetime] NULL CONSTRAINT [DF_PatientFamilyHistory_RecordDate]  DEFAULT (getutcdate()),
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistory_IsPatientInput]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientFamilyHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientFamilyHistoryDisease]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientFamilyHistoryDisease](
	[PatientFamilyHistoryDiseaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientFamilyHistoryDisease_PatientFamilyHistoryDiseaseUid]  DEFAULT (newid()),
	[PatientFamilyHistoryUid] [uniqueidentifier] NOT NULL,
	[DiseaseUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](255) NULL,
	[AgeAtOnsetTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[AgeAtOnsetDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistoryDisease_IsDelete]  DEFAULT ((0)),
	[IsCauseOfDeath] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistoryDisease_IsCauseOfDeath]  DEFAULT ((0)),
	[Denies] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistoryDisease_Denies]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientFamilyHistoryDisease_DisplayOrder]  DEFAULT ((0)),
	[RecordDateTime] [datetime] NULL CONSTRAINT [DF_PatientFamilyHistoryDisease_RecordDate]  DEFAULT (getutcdate()),
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_PatientFamilyHistoryDisease_IsPatientInput]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientFamilyHistoryDisease_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientHistory](
	[PatientHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientHistory_PatientHistoryUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[HistoryGroupName] [varchar](100) NULL,
	[HistoryGroupDisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientHistory_HistoryGroupDisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[OriginCreateTime] [datetime] NULL,
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_PatientHistory_IsPatientInput]  DEFAULT ((0)),
	[VisitUid] [uniqueidentifier] NULL,
	[ActiveStateUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_PatientHistory_ActiveStateUid]  DEFAULT ('506B5714-4DDA-4080-81AF-E2B37D4C4F19'),
	[IsLiving] [bit] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientHistoryComment]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientHistoryComment](
	[PatientHistoryCommentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HxComment_RowGuid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Comment] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientHistoryComment_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientHistoryDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientHistoryDetail](
	[PatientHistoryDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientHistoryDetail_PatientHistoryDetailUid]  DEFAULT (newid()),
	[PatientHistoryUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[QuestionName] [varchar](255) NULL,
	[AnswerName] [varchar](255) NULL,
	[AnswerTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[AnswerDate] [date] NULL,
	[QuestionDisplayOrder] [int] NULL,
	[RecordDateTime] [datetime] NULL,
	[Denies] [bit] NOT NULL CONSTRAINT [DF_PatientHistoryDetail_Denies]  DEFAULT ((0)),
	[ProcedureUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientHistoryDetail_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientHMRule]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientHMRule](
	[PatientHMRuleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientHMRule_PatientHMRuleUid]  DEFAULT (newid()),
	[HMRuleUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[IsDue] [bit] NOT NULL CONSTRAINT [DF_PatientHMRule_IsDue]  DEFAULT ((0)),
	[DueDate] [date] NULL,
	[PastDueDate] [date] NULL,
	[LastPerformDate] [date] NULL,
	[LastPerformProviderUid] [uniqueidentifier] NULL,
	[ReportPreventativeFollowupDate] [date] NULL,
	[Notes] [varchar](max) NULL CONSTRAINT [DF_PatientHMRule_Notes]  DEFAULT ('0'),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PatientHMRule_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientHMRule_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientHMRuleDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientHMRuleDetail](
	[PatientHMRuleDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientHMRuleDetail_PatientHMRuleDetailUid]  DEFAULT (newid()),
	[PatientHMRuleUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[PerformDate] [date] NULL,
	[PerformProviderUid] [uniqueidentifier] NULL,
	[RecordDateTime] [datetime] NULL,
	[PerformTypeID] [int] NOT NULL CONSTRAINT [DF_PatientHMRuleDetail_PerformTypeID]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientHMRuleDetail_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientHMRuleDetail_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientMedicalDeviceHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientMedicalDeviceHistory](
	[PatientMedicalDeviceHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[DeviceId] [varchar](50) NOT NULL,
	[BrandName] [varchar](200) NULL,
	[GmdnPTName] [varchar](200) NULL,
	[DeviceXml] [xml] NOT NULL,
	[UniqueDeviceId] [varchar](100) NULL,
	[UniqueDeviceXml] [xml] NULL,
	[DeviceActiveDate] [date] NULL,
	[DeviceActiveDateTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[DeviceInactiveDate] [date] NULL,
	[DeviceInactiveDateTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[MedicalDeviceStatusUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientNote]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientNote](
	[PatientNoteUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_PatientNote_PatientNoteUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Note] [varchar](max) NOT NULL,
	[CreatedByUid] [uniqueidentifier] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_PatientNote_CreatedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientNote_LastModifiedDate_1]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientOBCaseInfo]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientOBCaseInfo](
	[PatientOBCaseInfoUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCaseUid] [uniqueidentifier] NOT NULL,
	[DatLMP] [date] NULL,
	[DatInitExam] [date] NULL,
	[DatInitExamCurWk] [smallint] NULL,
	[DatInitExamCurDay] [smallint] NULL,
	[DatInitUltraSound] [datetime] NULL,
	[DatInitUltraSoundCurWk] [smallint] NULL,
	[DatInitUltraSoundCurDay] [smallint] NULL,
	[InitEDDCalcTypeID] [smallint] NULL,
	[InitDeterminedBy] [varchar](10) NULL,
	[DatQuicking] [date] NULL,
	[DatFundal] [date] NULL,
	[DatLastUltraSound1] [date] NULL,
	[DatLastUltraSound1CurWk] [smallint] NULL,
	[DatLastUltraSound1CurDay] [smallint] NULL,
	[DatLastUltraSound2] [date] NULL,
	[DatLastUltraSound2CurWk] [smallint] NULL,
	[DatLastUltraSound2CurDay] [smallint] NULL,
	[DatLastUltraSound3] [date] NULL,
	[DatLastUltraSound3CurWk] [tinyint] NULL,
	[DatLastUltraSound3CurDay] [tinyint] NULL,
	[FinalEDDCalcTypeID] [smallint] NULL,
	[FinalDeterminedByInitial] [varchar](10) NULL,
	[BloodTypeID] [smallint] NULL,
	[BloodAcceptable] [smallint] NULL,
	[PartnerName] [varchar](35) NULL,
	[PartnerTel] [varchar](20) NULL,
	[FatherName] [varchar](35) NULL,
	[FatherBloodTypeID] [smallint] NULL,
	[FatherTel] [varchar](20) NULL,
	[ContactName1] [varchar](35) NULL,
	[ContactTel1] [varchar](20) NULL,
	[ContactName2] [varchar](35) NULL,
	[ContactTel2] [varchar](20) NULL,
	[AnesthConsultPlanned] [smallint] NULL,
	[CSectionScheduled] [smallint] NULL,
	[CSectionInitial] [varchar](10) NULL,
	[CSectionDate] [date] NULL,
	[CSectionPhysician] [varchar](35) NULL,
	[CSectionAssistant] [varchar](35) NULL,
	[SterilizationConsentDate] [date] NULL,
	[SterilizationConsent] [varchar](35) NULL,
	[Pediatrician] [varchar](35) NULL,
	[PediatricianTel] [varchar](20) NULL,
	[PediatricianReferredBy] [varchar](35) NULL,
	[HospitalDelivered] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DatEDD] [date] NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientOBOverview]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientOBOverview](
	[PatientOBOverviewUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[NumPara] [smallint] NULL,
	[NumPreg] [smallint] NULL,
	[NumFullTerm] [smallint] NULL,
	[NumPremature] [smallint] NULL,
	[NumIA] [smallint] NULL,
	[NumSA] [smallint] NULL,
	[NumEctopics] [smallint] NULL,
	[NumMultipleBirth] [smallint] NULL,
	[NumLiving] [smallint] NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientOutsideProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientOutsideProvider](
	[PatientOutsideProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientOutsideProvider_PatientOutsideProviderUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientProvider_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientProvider_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientPartnerTransaction]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientPartnerTransaction](
	[PatientPartnerTransactionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[HL7PartnerUid] [uniqueidentifier] NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[SuperbillUid] [uniqueidentifier] NULL,
	[PlanID] [varchar](100) NULL,
	[TransactionUid] [uniqueidentifier] NOT NULL,
	[OriginalTransactionUid] [uniqueidentifier] NOT NULL,
	[Amount] [money] NOT NULL,
	[PaymentMethod] [varchar](50) NULL,
	[Action] [varchar](50) NULL,
	[TransactionTimeStamp] [datetime] NULL,
	[TransactionType] [varchar](50) NULL,
	[BranchID] [varchar](50) NULL,
	[ClientID] [varchar](50) NULL,
	[ReferenceNumber] [varchar](100) NULL,
	[EntryMethod] [varchar](50) NULL,
	[AccountType] [varchar](50) NULL,
	[AccountNumber] [varchar](100) NULL,
	[AccountName] [varchar](100) NULL,
	[Notes] [text] NULL,
	[AdditionalXML] [varchar](max) NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientPharmacy]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientPharmacy](
	[PatientPharmacyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientPharmacy_PatientPharmacyUid]  DEFAULT (newid()),
	[PharmacyUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientPharmacy_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientPharmacy_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientProblemDiagnosisHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientProblemDiagnosisHistory](
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_PatientProblemDiagnosisHistoryUid]  DEFAULT (newid()),
	[IsCurrentHistoryRow] [bit] NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsCurrentHistoryRow]  DEFAULT ((0)),
	[GroupingUid] [uniqueidentifier] NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[ProblemStatusUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ProblemGroupingUid] [uniqueidentifier] NULL,
	[OnsetTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[OnsetDate] [date] NULL,
	[ResolvedTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[ResolvedDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsDelete]  DEFAULT ((0)),
	[IsPatientProblem] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsPatientProblem]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsAddendum]  DEFAULT ((0)),
	[AddendumNotes] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_DisplayOrder]  DEFAULT ((0)),
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[Sequence] [datetime] NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_SortDate]  DEFAULT (getutcdate()),
	[LastDiagnosisDate] [date] NULL,
	[DSMAxis] [varchar](250) NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsPatientInput]  DEFAULT ((0)),
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_LifeLong]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_LastModifiedDate]  DEFAULT (getutcdate()),
	[HccModelCat] [int] NULL,
	[LexicalCode] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientProcedureHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientProcedureHistory](
	[PatientProcedureHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientProcedureHistory_PatientProcedureHistoryUid]  DEFAULT (newid()),
	[IsCurrentHistoryRow] [bit] NOT NULL CONSTRAINT [DF_PatientProcedureHistory_IsCurrentHistoryRow]  DEFAULT ((0)),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[Code] [varchar](30) NULL,
	[TermName] [varchar](255) NULL,
	[ShortDescription] [varchar](75) NULL,
	[ProcedureHistoryTermUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[ProcedureHistoryStatusUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[PerformTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[PerformDate] [date] NULL,
	[ResultTimeFrame] [xml](CONTENT [TimeFrame]) NULL,
	[ResultDate] [date] NULL,
	[OrderDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientProcedureHistory_IsDelete]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[Sequence] [datetime] NOT NULL CONSTRAINT [DF_PatientProcedureHistory_Sequence]  DEFAULT (getutcdate()),
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_PatientProcedureHistory_IsPatientInput]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientProcedureHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientProviderRelationship]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientProviderRelationship](
	[PatientProviderRelationshipUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientProviderRelationship_PatientProviderRelationshipUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL,
	[ProviderCareTypeUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[CareTypeActiveFrom] [date] NULL,
	[CareTypeActiveUntil] [date] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PatientProviderRelationship_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientProviderRelationship_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientRecall]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientRecall](
	[PatientRecallUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[RecallTypeUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[NotificationMethodUid] [uniqueidentifier] NULL,
	[NotificationUserUid] [uniqueidentifier] NULL,
	[DateSatisfied] [date] NULL,
	[DateDue] [date] NULL,
	[DateNotified] [date] NULL,
	[CreateDateTime] [datetime] NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[PatientHMRuleUid] [uniqueidentifier] NULL,
	[SatisfiedUserUid] [uniqueidentifier] NULL,
	[AppointmentUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[OriginVisitUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientRecordRelease]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientRecordRelease](
	[PatientRecordReleaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[RecipientName] [varchar](100) NULL,
	[SentMethodUid] [uniqueidentifier] NULL,
	[SentDate] [datetime] NULL,
	[SenderUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Inactive] [bit] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientReferral]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientReferral](
	[PatientReferralUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientReferral_PatientReferralUid]  DEFAULT (newid()),
	[PatientProviderRelationshipUid] [uniqueidentifier] NOT NULL,
	[ReferralTrackingStatusUid] [uniqueidentifier] NOT NULL,
	[ReferredByProviderUid] [uniqueidentifier] NULL,
	[AppointmentDate] [datetime] NULL,
	[Notes] [varchar](max) NULL,
	[BookingTime] [smallint] NOT NULL CONSTRAINT [DF_PatientReferral_BookingTime]  DEFAULT ((1)),
	[VisitUid] [uniqueidentifier] NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PatientReferral_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientReferral_LastModifiedDate]  DEFAULT (getutcdate()),
	[CreatedDate] [date] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientReferralHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientReferralHistory](
	[PatientReferralHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientReferralHistory_PatientReferralHistoryUid]  DEFAULT (newid()),
	[PatientReferralUid] [uniqueidentifier] NOT NULL,
	[ReferralTrackingStatusUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PatientReferralHistory_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientReferralHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PatientTrackingEvent]') AND type in (N'U'))
BEGIN
CREATE TABLE [PatientTrackingEvent](
	[PatientTrackingEventUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientTrackingEvent_PatientTrackingEventUid]  DEFAULT (newid()),
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PatientTrackingEvent_Inactive]  DEFAULT ((0)),
	[PatientTrackingEventTypeUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[EventDate] [date] NOT NULL CONSTRAINT [DF_PatientTrackingEvent_EventDate]  DEFAULT (getdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientTrackingEvent_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Person]') AND type in (N'U'))
BEGIN
CREATE TABLE [Person](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Person_PersonUid]  DEFAULT (newid()),
	[PatientCenterUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Person_Inactive]  DEFAULT ((0)),
	[Prefix] [varchar](25) NULL,
	[FirstName] [varchar](50) NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NOT NULL,
	[Suffix] [varchar](50) NULL,
	[Address1] [xml](CONTENT [Address]) NULL,
	[BadAddress1] [bit] NULL CONSTRAINT [DF_Person_BadAddress1]  DEFAULT ((0)),
	[Address2] [xml](CONTENT [Address]) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Phone3] [xml](CONTENT [Phone]) NULL,
	[Phone4] [xml](CONTENT [Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[LanguageUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[Hispanic] [bit] NOT NULL CONSTRAINT [DF_Person_Hispanic]  DEFAULT ((0)),
	[Birthdate] [date] NULL,
	[BirthTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[Deathdate] [date] NULL,
	[AkaFirstName] [varchar](50) NULL,
	[AkaLastName] [varchar](50) NULL,
	[SocialSecurityNumber] [varchar](11) NULL,
	[DriverLicenseNumber] [varchar](25) NULL,
	[DriverLicenseState] [varchar](3) NULL,
	[DriverLicenseAttachmentUid] [uniqueidentifier] NULL,
	[PhotoAttachmentUid] [uniqueidentifier] NULL,
	[LivesWithPersonUid] [uniqueidentifier] NULL,
	[MaritalStatusUid] [uniqueidentifier] NULL,
	[DominantHandUid] [uniqueidentifier] NULL,
	[PreferredContactMethod] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Person_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Person_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MaidenName] [varchar](50) NULL,
	[NotificationMethodUid] [uniqueidentifier] NULL,
	[EmailDirect] [varchar](200) NULL,
	[BirthPlace] [xml](CONTENT [Address]) NULL,
	[Computed_Address1_Address1] [varchar](100) NULL,
	[Computed_Address1_Address2] [varchar](100) NULL,
	[Computed_Address1_City] [varchar](35) NULL,
	[Computed_Address1_State] [varchar](3) NULL,
	[Computed_Address1_Zip] [varchar](10) NULL,
	[Computed_Phone1_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone1_PhoneType] [varchar](50) NULL,
	[Computed_Phone2_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone2_PhoneType] [varchar](50) NULL,
	[Computed_Phone3_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone3_PhoneType] [varchar](50) NULL,
	[Computed_Phone4_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone4_PhoneType] [varchar](50) NULL,
	[MotherMaidenName] [varchar](50) NULL,
	[MotherMaidenFirstName] [varchar](50) NULL,
	[IdentityVerification] [xml] NULL,
	[LastIdentityVerificationTransaction] [varchar](max) NULL,
	[TranslatorRequired] [bit] NULL CONSTRAINT [DF_Person_TranslatorRequired]  DEFAULT ((0)),
	[SexualOrientationUid] [uniqueidentifier] NULL,
	[GenderIdentityUid] [uniqueidentifier] NULL,
	[SendSms] [bit] NOT NULL CONSTRAINT [DF__Person_Sms]  DEFAULT ((0)),
	[SendEmail] [bit] NOT NULL CONSTRAINT [DF_Person_Email]  DEFAULT ((0)),
	[NoEmailAddressProvided] [bit] NOT NULL CONSTRAINT [DF_Person_NoEmailAddressProvided]  DEFAULT ((0)),
	[Email1MessagingAllowed] [bit] NULL,
	[Email2MessagingAllowed] [bit] NULL,
	[Phone1MessagingAllowed] [bit] NULL,
	[Phone2MessagingAllowed] [bit] NULL,
	[Phone3MessagingAllowed] [bit] NULL,
	[Phone4MessagingAllowed] [bit] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PersonContact]') AND type in (N'U'))
BEGIN
CREATE TABLE [PersonContact](
	[PersonContactUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PersonContact_PersonContactUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NOT NULL,
	[ContactPersonUid] [uniqueidentifier] NOT NULL,
	[ContactRelationshipUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PersonContact_DisplayOrder]  DEFAULT ((0)),
	[EmergencyContact] [bit] NOT NULL CONSTRAINT [DF_PersonContact_EmergencyContact]  DEFAULT ((0)),
	[AuthorizedToMakeMedicalDecisions] [bit] NOT NULL CONSTRAINT [DF_PersonContact_AuthorizedToMakeMedicalDecisions]  DEFAULT ((0)),
	[AllowHIPAARelease] [smallint] NOT NULL CONSTRAINT [DF_PersonContact_AllowHIPAARelease_1]  DEFAULT ((0)),
	[HIPAARelease] [xml] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PersonContact_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PersonEmployer]') AND type in (N'U'))
BEGIN
CREATE TABLE [PersonEmployer](
	[PersonEmployerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PersonEmployer_PersonEmployerUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NOT NULL,
	[EmployerUid] [uniqueidentifier] NULL,
	[EmploymentStatusUid] [uniqueidentifier] NULL,
	[IndustryUid] [uniqueidentifier] NULL,
	[OccupationUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PersonEmployer_DisplayOrder]  DEFAULT ((0)),
	[StartDate] [date] NULL,
	[StartFuzzyDate] [xml](CONTENT [TimeFrame]) NULL,
	[EndDate] [date] NULL,
	[EndFuzzyDate] [xml](CONTENT [TimeFrame]) NULL,
	[Department] [varchar](50) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PersonEmployer_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PersonInsurancePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [PersonInsurancePlan](
	[PersonInsurancePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PersonInsurancePlan_PersonInsurancePlanUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NULL,
	[CorporationUid] [uniqueidentifier] NULL,
	[InsurancePlanUid] [uniqueidentifier] NOT NULL,
	[CopayPrimary] [money] NULL,
	[CopaySpecialist] [money] NULL,
	[CopayOther] [money] NULL,
	[AuthorizeAssignment] [bit] NOT NULL CONSTRAINT [DF_PersonInsurancePlan_AuthorizeAssignment]  DEFAULT ((1)),
	[PlanMemberID] [varchar](50) NULL,
	[PlanGroupID] [varchar](50) NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[InsuranceCardAttachmentUid] [uniqueidentifier] NULL,
	[EligibilityStatusUid] [uniqueidentifier] NULL,
	[EligibilityCoverageLevelUid] [uniqueidentifier] NULL,
	[InNetworkCoinsurance] [decimal](18, 0) NULL,
	[InNetworkDeductible] [money] NULL,
	[InNetworkRemaining] [money] NULL,
	[InNetworkMet] [money] NULL,
	[OutNetworkCoinsurance] [decimal](18, 0) NULL,
	[OutNetworkDeductible] [money] NULL,
	[OutNetworkRemaining] [money] NULL,
	[OutNetworkMet] [money] NULL,
	[EligibilityEffectiveDate] [date] NULL,
	[EligibilityExpirationDate] [date] NULL,
	[EligibilityVerificationDateTime] [datetime] NULL,
	[EligibilityNotes] [varchar](8000) NULL,
	[EligibilityResponseXML] [xml] NULL,
	[EligibilityTransmissionInProcess] [bit] NULL,
	[EligibilityTransmissionStatus] [varchar](50) NULL,
	[ElectronicRequest] [bit] NOT NULL CONSTRAINT [DF_PersonInsurancePlan_ElectronicRequest]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PersonInsurancePlan_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[EligibilityResponseHTML] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PersonWeb]') AND type in (N'U'))
BEGIN
CREATE TABLE [PersonWeb](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[UserName] [varchar](50) NULL,
	[Password] [varchar](50) NULL,
	[RequireNew] [bit] NOT NULL CONSTRAINT [DF__PersonWeb__Requi__4327266E]  DEFAULT ((0)),
	[LimitedTimePassword] [bit] NOT NULL CONSTRAINT [DF_PersonWeb_LimitedTimePassword]  DEFAULT ((0)),
	[ExpirationDate] [date] NULL,
	[IncorrectLoginDateTime] [datetime] NULL,
	[IncorrectLoginCount] [tinyint] NOT NULL CONSTRAINT [DF__PersonWeb__Incor__441B4AA7]  DEFAULT ((0)),
	[PatientWebAccess] [bit] NOT NULL CONSTRAINT [DF__PersonWeb__Patie__450F6EE0]  DEFAULT ((0)),
	[UserPRMWebAccess] [bit] NOT NULL CONSTRAINT [DF__PersonWeb__UserP__46039319]  DEFAULT ((0)),
	[ProviderWebAccess] [bit] NOT NULL CONSTRAINT [DF__PersonWeb__Provi__46F7B752]  DEFAULT ((0)),
	[FacilityPortalWebAccess] [bit] NOT NULL CONSTRAINT [DF_PersonWeb_FacilityPortalWebAccess]  DEFAULT ((0)),
	[ProductConsentVersion] [int] NULL,
	[PracticeConsentVersion] [int] NULL,
	[ChartConsentVersion] [int] NULL,
	[PatientSecurityAnswerList] [xml](CONTENT [PatientPortalSecurityAnswers]) NULL,
	[IncorrectPasswordResetDateTime] [datetime] NULL,
	[IncorrectPasswordResetCount] [tinyint] NOT NULL CONSTRAINT [DF_PersonWeb_IncorrectPasswordReset]  DEFAULT ((0)),
	[CreatedDateTime] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__PersonWeb__LastM__47EBDB8B]  DEFAULT (getutcdate()),
	[LastLoginDate] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PlugInSettings]') AND type in (N'U'))
BEGIN
CREATE TABLE [PlugInSettings](
	[PlugInSettingsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PlugInSettings_PlugInSettingsUid]  DEFAULT (newid()),
	[ClaimClearingHouseUid] [uniqueidentifier] NULL,
	[PlugInId] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PlugInSettings_Inactive]  DEFAULT ((0)),
	[Type] [varchar](25) NULL,
	[Name] [varchar](50) NULL,
	[Value] [varchar](1024) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PlugInSettings_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PlugInSettings_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PQRIDenominator]') AND type in (N'U'))
BEGIN
CREATE TABLE [PQRIDenominator](
	[PQRIDenominatorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PQRIDenominator_PQRIDenominatorUid]  DEFAULT (newid()),
	[PQRIMeasureUid] [uniqueidentifier] NOT NULL,
	[CodeTypeMiscUid] [uniqueidentifier] NOT NULL,
	[OperativeMiscUid] [uniqueidentifier] NOT NULL,
	[Codes] [varchar](2048) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PQRIDenominator_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PQRIDenominator_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PQRIDenominator_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PQRIHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [PQRIHistory](
	[PQRIHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PQRIHistory_PQRIHistoryUid]  DEFAULT (newid()),
	[PQRIMeasureUid] [uniqueidentifier] NOT NULL,
	[PQRINumeratorUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[AutoSelected] [bit] NOT NULL CONSTRAINT [DF_PQRIHistory_PQRIAutoSelected]  DEFAULT ((0)),
	[UserOverrodeAutoSelect] [bit] NOT NULL CONSTRAINT [DF_PQRIHistory_UserOverrodeAutoSelect]  DEFAULT ((0)),
	[QualificationExpirationDate] [date] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PQRIHistory_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PQRIHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PQRINumerator]') AND type in (N'U'))
BEGIN
CREATE TABLE [PQRINumerator](
	[PQRINumeratorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PQRINumerator_PQRINumeratorUid]  DEFAULT (newid()),
	[PQRIMeasureUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[OperativeMiscUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PQRINumerator_DisplayOrder]  DEFAULT ((0)),
	[AutoSelect] [bit] NOT NULL CONSTRAINT [DF_PQRINumerator_AutoSelect]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PQRINumerator_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PQRINumerator_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PQRS_InterfaceDataMapping]') AND type in (N'U'))
BEGIN
CREATE TABLE [PQRS_InterfaceDataMapping](
	[InterfaceDataMappingUid] [uniqueidentifier] NOT NULL,
	[Rootid] [varchar](40) NOT NULL,
	[Name] [varchar](100) NULL,
	[CCDCode] [varchar](25) NOT NULL,
	[PRMCode] [varchar](25) NULL,
	[CCDPrintName] [varchar](250) NULL,
	[IsDefault] [bit] NULL,
	[Inactive] [bit] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[NCQMeasure] [varchar](10) NULL,
	[TopicIndicator] [varchar](50) NULL,
	[NQFNumber] [varchar](10) NULL,
	[DataElementName] [varchar](100) NULL,
	[Modifier] [varchar](25) NULL,
	[EndDate] [varchar](25) NULL,
	[DisplayOrder] [int] NOT NULL,
	[QRDASection] [varchar](50) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PracticeSettings]') AND type in (N'U'))
BEGIN
CREATE TABLE [PracticeSettings](
	[PracticeSettingsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PracticeSettings_PracticeSettingsUid]  DEFAULT (newid()),
	[Name] [varchar](100) NOT NULL,
	[MainAddress] [xml](CONTENT [Address]) NULL,
	[MainPhone] [xml](CONTENT [Phone]) NULL,
	[BillingAddress] [xml](CONTENT [Address]) NULL,
	[InTimeZoneAdj] [int] NOT NULL CONSTRAINT [DF_PracticeSettings_InTimeZoneAdj]  DEFAULT ((0)),
	[ObserveDaylightSavings] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_ObserveDaylightSavings]  DEFAULT ((1)),
	[StatementOnNewActivity] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_StatementOnNewActivity]  DEFAULT ((0)),
	[StatementCycle] [smallint] NOT NULL CONSTRAINT [DF_PracticeSettings_StatementCycle]  DEFAULT ((30)),
	[StatementDueDays] [smallint] NOT NULL CONSTRAINT [DF_PracticeSettings_StatementDueDays]  DEFAULT ((20)),
	[StatementPaymentPlanNote] [varchar](max) NULL,
	[StatementDunningOn] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_StatementDunningOn]  DEFAULT ((1)),
	[SendPaperlessStatements] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_SendPaperlessStatements]  DEFAULT ((0)),
	[NewPatientReleaseDefault] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_NewPatientReleaseDefault]  DEFAULT ((1)),
	[PatientReleaseOnEveryVisit] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_PatientReleaseOnEveryVisit]  DEFAULT ((0)),
	[FullPaymentRequired] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_FullPaymentRequired]  DEFAULT ((0)),
	[ClaimSubmitterServiceSiteUid] [uniqueidentifier] NULL,
	[PayToServiceSiteUid] [uniqueidentifier] NULL,
	[CurrentPeriodEnd] [date] NOT NULL,
	[FiscalYearEnd] [date] NOT NULL,
	[CurrentPeriodEndOfMonth] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EndOfMonthFlag]  DEFAULT ((1)),
	[FiscalYearEndOfYear] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EndOfYearFlag]  DEFAULT ((1)),
	[SystemFinancialsCloseThruDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PracticeSettings_LastModifiedByDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ElectronicSubmitterID] [varchar](50) NULL,
	[StatementMinimumAmount] [money] NOT NULL CONSTRAINT [DF_PracticeSettings_SatementMinimumAmount]  DEFAULT ((1)),
	[ReportServerBaseURL] [varchar](255) NULL,
	[ReportServerSOAPPath] [varchar](255) NULL,
	[ReportServerWebPath] [varchar](255) NULL,
	[RouteClaimErorrMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteDocumentFaxSendErrorToUserGroupUid] [uniqueidentifier] NULL,
	[RouteRxMessageSendErrorToUserGroupUid] [uniqueidentifier] NULL,
	[RouteSurveyMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteReplicationConflictMessageToUserGroupUid] [uniqueidentifier] NULL,
	[ReplicationAppointmentHours] [smallint] NOT NULL CONSTRAINT [DF__PracticeS__Repli__0303C7BD]  DEFAULT ((48)),
	[ReplicationRemovePatientHours] [smallint] NULL CONSTRAINT [DF__PracticeS__Repli__03F7EBF6]  DEFAULT ((48)),
	[ReplicationAttachmentSizeKB] [int] NOT NULL CONSTRAINT [DF__PracticeS__Repli__04EC102F]  DEFAULT ((100)),
	[ScanAppointmentSeconds] [smallint] NULL CONSTRAINT [DF__PracticeS__ScanA__05E03468]  DEFAULT ((300)),
	[TriggerRemovePatientSeconds] [smallint] NULL CONSTRAINT [DF__PracticeS__Trigg__06D458A1]  DEFAULT ((300)),
	[TriggerReplicationSeconds] [smallint] NULL CONSTRAINT [DF__PracticeS__Trigg__07C87CDA]  DEFAULT ((30)),
	[UseThirdPartyPM] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_UseThirdPartyPM]  DEFAULT ((0)),
	[UseFormulary] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_UseFormulary]  DEFAULT ((0)),
	[DisableExceptionIgnoreButtonCount] [int] NOT NULL CONSTRAINT [DF_PracticeSettings_DisableExceptionIgnoreButton]  DEFAULT ((5)),
	[RouteAuthorizationRequestMessageToUserGroupUid] [uniqueidentifier] NULL,
	[DrugScreeningCriteria] [varchar](max) NULL,
	[RxReportRdlUid] [uniqueidentifier] NULL,
	[ScheduleIIRxReportRdlUid] [uniqueidentifier] NULL,
	[PrintSampleRx] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_PrintSampleRx_1]  DEFAULT ((1)),
	[CodeValidationAtSuperbillEnabled] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_CodeValidationAtSuperbillEnabled]  DEFAULT ((0)),
	[CodeValidationMinimumErrorReport] [varchar](50) NULL,
	[CodeValidationErrorStopLevel] [varchar](50) NULL,
	[DefaultSystemARBatchOwnerUid] [uniqueidentifier] NULL,
	[AppointmentConfirmationEnabled] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AppointmentConfirmationEnabled]  DEFAULT ((0)),
	[StatementsByFinancialCenter] [bit] NULL CONSTRAINT [DF_PracticeSettings_StatementsByFinancialCenter]  DEFAULT ((0)),
	[DunningMsgsUid] [uniqueidentifier] NULL,
	[InsuranceBalanceOnlySuperbills] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_InsuranceBalanceOnlySuperbills]  DEFAULT ((0)),
	[AllowProcedureNotePopUp] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AllowProcedureNotePopUp]  DEFAULT ((0)),
	[eRxDownloadSetting] [varchar](2048) NULL,
	[FaxControlledSubstances] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_FaxControlledSubstances]  DEFAULT ((0)),
	[RxFooter] [varchar](50) NULL,
	[RoutePatientMessages] [xml](CONTENT [PatientMessagesToUserGroup]) NULL,
	[AutoInternetPatientMessagingEnabled] [bit] NULL,
	[CalculateTax] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_CalculateTax]  DEFAULT ((0)),
	[TaxableOption] [smallint] NOT NULL CONSTRAINT [DF_PracticeSettings_TaxableOption]  DEFAULT ((0)),
	[AllowUnsentLabOrdersForCompletedNotes] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AllowUnsentLabOrdersForCompletedNotes]  DEFAULT ((0)),
	[RequireLabOrderTaskMsg] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_RequireLabOrderTaskMsg_1]  DEFAULT ((1)),
	[AutoCheckLabsRdyToSendForCompletedNotes] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AutoCheckLabsRdyToSendForCompletedNotes_1]  DEFAULT ((1)),
	[ShowPatientBirthTime] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_ShowPatientBirthTime]  DEFAULT ((0)),
	[AppointmentEligibility] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AppointmentEligibility]  DEFAULT ((0)),
	[DaysEligibilityInAdvance] [smallint] NOT NULL CONSTRAINT [DF_PracticeSettings_DaysEligibilityInAdvance]  DEFAULT ((2)),
	[EligibilityIncludeWeekends] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EligibilityIncludeWeekends]  DEFAULT ((0)),
	[RouteVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteNUSBVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[MaxImportDocumentErrorUid] [uniqueidentifier] NULL,
	[MaxImportDocumentSize] [int] NULL CONSTRAINT [DF_PracticeSettings_MaxImportDocumentSize]  DEFAULT ((20)),
	[DisableIM] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_DisableIM]  DEFAULT ((0)),
	[RequireDiagnosisBeforeOrdersCanBeSent] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_RequireDiagnosisBeforeOrdersCanBeSent]  DEFAULT ((0)),
	[SQLCALUser] [bit] NULL,
	[IncludeReferringProvider] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludeReferringProvider]  DEFAULT ((1)),
	[SuppressZeroDollarProcedures] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_SuppressZeroDollarProcedures]  DEFAULT ((1)),
	[IncludeLastFileDate] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludeLastFileDate]  DEFAULT ((1)),
	[StatementFooter] [varchar](325) NULL,
	[IncludePaymentReferenceNumber] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludePaymentReferenceNumber]  DEFAULT ((1)),
	[IncludeProcedureCode] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludeProcedureCode]  DEFAULT ((1)),
	[EligibilityOncePerMonth] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EligibilityOncePerMonth]  DEFAULT ((0)),
	[EligibilityCheckOnMonthChange] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EligibilityCheckOnMonthChange]  DEFAULT ((0)),
	[HMRulesDeleteNonRelevantIsDueMessages] [bit] NULL,
	[HMRulesCompleteNonRelevantIsDueMessages] [bit] NULL,
	[HMRulesCompletedByUid] [uniqueidentifier] NULL,
	[IncludeCompletedOrClosed] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludeCompletedOrClosed]  DEFAULT ((0)),
	[WarnWhenEditingCompleteNote] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_WarnWhenEditingCompleteNote]  DEFAULT ((0)),
	[DisplayHistVaccOldestToRecent] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_DisplayHistVaccOldestToRecent]  DEFAULT ((1)),
	[VaccineCardPrintLandscape] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_VaccineCardPrintLandscape]  DEFAULT ((1)),
	[PatientEmails] [xml](CONTENT [PatientInternetEmails]) NULL,
	[DisplaySBStartStopTimes] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_DisplaySBStartStopTimes_1]  DEFAULT ((0)),
	[RoutePatientPortalErrorMessageToUserGroupUid] [uniqueidentifier] NULL,
	[AllowPracticeSettingsDiagnosisLinking] [bit] NULL,
	[ShowRVUSearchingCPTUid] [uniqueidentifier] NULL,
	[PatientPortalMessageRouting] [xml] NULL,
	[PCMHParticipant] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_PCMHParticipant]  DEFAULT ((0)),
	[StatementModelUid] [uniqueidentifier] NULL,
	[RequestSignatureOnCreditCardReceipt] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_RequestSignatureOnCreditCardReceipt]  DEFAULT ((0)),
	[AllowConcurrentReferringProviders] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AllowConcurrentReferringProviders]  DEFAULT ((0)),
	[OptOutStatementEmailUserGroupUid] [uniqueidentifier] NULL,
	[EnableEligibilityCheckFromTrackSuperbills] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EnableEligibilityCheckFromTrackSuperbills]  DEFAULT ((0)),
	[EnableDepositsByFinancialCenter] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EnableDepositsByFinancialCenter]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PrintSetDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [PrintSetDetail](
	[PrintSetDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PrintSetDetail_PrintSetDetailUid]  DEFAULT (newid()),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PrintSetDetail_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PrintSetDetail_UserDefined]  DEFAULT ((1)),
	[PrintSetUid] [uniqueidentifier] NULL,
	[ReportUid] [uniqueidentifier] NULL,
	[UseEducationForm] [bit] NOT NULL CONSTRAINT [DF_PrintSetDetail_UseEducationForm]  DEFAULT ((0)),
	[PrinterName] [varchar](100) NULL,
	[PrinterDeviceID] [varchar](100) NULL,
	[PrinterSettings] [varbinary](max) NULL,
	[OffsetTop] [numeric](9, 3) NOT NULL CONSTRAINT [DF_PrintSetDetail_OffsetTop]  DEFAULT ((0)),
	[OffsetLeft] [numeric](9, 3) NOT NULL CONSTRAINT [DF_PrintSetDetail_OffsetLeft]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PrintSetDetail_LastModifiedDate_1]  DEFAULT (getutcdate()),
	[CustomNotePrintUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[PRMModuleUpdate]') AND type in (N'U'))
BEGIN
CREATE TABLE [PRMModuleUpdate](
	[PRMModuleUpdateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Name] [varchar](128) NOT NULL,
	[RunDate] [datetime] NULL,
	[CreateScript] [varchar](max) NOT NULL,
	[Type] [varchar](2) NOT NULL,
	[TypeDesc] [varchar](60) NOT NULL,
	[CreateDate] [datetime] NOT NULL,
	[ModifyDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PRMModuleUpdate_UserDefined]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PRMModuleUpdate_LastModifiedDate]  DEFAULT (getdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProcedureNotePage]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProcedureNotePage](
	[ProcedureNotePageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PageNum] [int] NULL,
	[Name] [varchar](100) NULL,
	[Comment] [varchar](2000) NULL,
	[IsQAPage] [bit] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProcedureNoteQuestion]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProcedureNoteQuestion](
	[ProcedureNoteQuestionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProcedureNotePageUid] [uniqueidentifier] NULL,
	[Question] [varchar](2000) NULL,
	[QuestionNum] [int] NULL,
	[QuestionTypeUid] [uniqueidentifier] NULL,
	[MinSize] [int] NULL,
	[MaxSize] [int] NULL,
	[NumRows] [int] NULL,
	[NumCols] [int] NULL,
	[SelectionValueList] [varchar](2000) NULL,
	[DefaultValueList] [varchar](2000) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProcedureSpecialty]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProcedureSpecialty](
	[ProcedureSpecialtyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SpecialtyID] [int] NOT NULL,
	[Name] [varchar](100) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProductConcurrentLicenseUse]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProductConcurrentLicenseUse](
	[ProductConcurrentLicenseUseUid] [uniqueidentifier] NOT NULL,
	[MachineName] [varchar](25) NULL,
	[UserUid] [uniqueidentifier] NULL,
	[ProductCode] [varchar](100) NULL,
	[LastUsedDate] [datetime] NOT NULL,
	[ApplicationInstanceUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Provider]') AND type in (N'U'))
BEGIN
CREATE TABLE [Provider](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Provider_Inactive]  DEFAULT ((0)),
	[ProviderRoleID] [smallint] NOT NULL CONSTRAINT [DF_Provider_ProviderRoleID]  DEFAULT ((1)),
	[IsBillingProvider] [bit] NOT NULL CONSTRAINT [DF_Provider_IsBillingProvider]  DEFAULT ((1)),
	[IsReferringProvider] [bit] NOT NULL CONSTRAINT [DF_Provider_IsReferringProvider]  DEFAULT ((1)),
	[FTE] [smallint] NULL,
	[ProviderLicense] [smallint] NULL,
	[DefaultProviderCareTypeUid] [uniqueidentifier] NULL,
	[DefaultServiceSiteUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[FeeScheduleUid] [uniqueidentifier] NULL,
	[SignatureTypeId] [smallint] NOT NULL CONSTRAINT [DF_Provider_SignatureTypeId]  DEFAULT ((0)),
	[ReplicationAppointmentHours] [smallint] NOT NULL CONSTRAINT [DF_Provider_ReplicationAppointmentHours]  DEFAULT ((48)),
	[ReplicationRemovePatientHours] [smallint] NOT NULL CONSTRAINT [DF_Provider_ReplicationRemovePatientHours]  DEFAULT ((48)),
	[ReplicationAttachmentSizeKB] [smallint] NOT NULL CONSTRAINT [DF_Provider_ReplicationAttach5mentSizeKB]  DEFAULT ((50)),
	[AutoLearnCommonProblemPallet] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoLearnCommonProblemPallet_1]  DEFAULT ((1)),
	[EMCodeReminder] [bit] NOT NULL CONSTRAINT [DF_Provider_EMCodeReminder]  DEFAULT ((1)),
	[ePrescribeWarning] [bit] NOT NULL CONSTRAINT [DF_Provider_ePrescribeWarning]  DEFAULT ((1)),
	[PrintPrescriptionsOnCheckout] [bit] NOT NULL CONSTRAINT [DF_Provider_PrintPrescriptionsOnCheckout]  DEFAULT ((1)),
	[DefaultListInFNC] [smallint] NOT NULL CONSTRAINT [DF_Provider_DefaultListInFNC_1]  DEFAULT ((1)),
	[ROSOrder] [smallint] NOT NULL CONSTRAINT [DF_Provider_ROSOrder_1]  DEFAULT ((0)),
	[RxThermalPrinter] [bit] NOT NULL CONSTRAINT [DF_Provider_RxThermalPrinter]  DEFAULT ((0)),
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[TranscriptionistUid] [uniqueidentifier] NULL,
	[SpecialtyUid] [uniqueidentifier] NULL,
	[ETIN] [varchar](50) NULL,
	[EClaimSiteTaxID] [varchar](50) NULL,
	[MandatoryCosignature] [bit] NOT NULL CONSTRAINT [DF_Provider_MandatoryCosignature]  DEFAULT ((0)),
	[SupervisingPrescriptionSignatureSource] [bit] NOT NULL CONSTRAINT [DF_Provider_PrescriptionSignatureSource]  DEFAULT ((0)),
	[CanSignRx] [bit] NOT NULL CONSTRAINT [DF_Provider_CanSignRx]  DEFAULT ((0)),
	[DefaultReviewerUid] [uniqueidentifier] NULL,
	[RxReportRdlUid] [uniqueidentifier] NULL,
	[ScheduleIIRxReportRdlUid] [uniqueidentifier] NULL,
	[MedicationReportLastRun] [datetime] NULL,
	[UsePracticeSettingsBillingAddress] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePSPE]  DEFAULT ((1)),
	[UsePracticeSettingsMaintenaceDrugCls] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePracticeSettingsMaintenaceDrugCls]  DEFAULT ((0)),
	[ClaimProviderCorporationUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[ExternalID] [varchar](25) NULL,
	[AutoLinkDxCpt] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoLinkDxCpt_1]  DEFAULT ((0)),
	[SuperbillStatusID] [smallint] NOT NULL CONSTRAINT [DF_Provider_SuperbillStatusID]  DEFAULT ((0)),
	[ConsultingProvider] [bit] NOT NULL CONSTRAINT [DF_Provider_Consult]  DEFAULT ((0)),
	[AuthorizationGroupUid] [uniqueidentifier] NULL,
	[AuthorizationReviewerUid] [uniqueidentifier] NULL,
	[DrugScreeningCriteria] [varchar](max) NULL,
	[UseLDM] [bit] NOT NULL CONSTRAINT [DF_Provider_UseLDM]  DEFAULT ((1)),
	[AutoAddMedicationReport] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoAddMedicationReport]  DEFAULT ((1)),
	[EduFormAssociationUid] [uniqueidentifier] NULL,
	[PayToProviderCorporationUid] [uniqueidentifier] NULL,
	[Initials] [varchar](5) NULL,
	[DocumentFaxElection] [smallint] NOT NULL CONSTRAINT [DF_Provider_DocumentFaxElection]  DEFAULT ((0)),
	[RouteDocumentFaxErrorToUserUid] [uniqueidentifier] NULL,
	[DefaultCoverageTypeUid] [uniqueidentifier] NULL,
	[DefaultLabOrderTaskMsgRecvrUid] [uniqueidentifier] NULL,
	[AutoSendLabOrderMsgs] [bit] NULL CONSTRAINT [DF_Provider_AutoSendLabOrderMsgs_1]  DEFAULT ((0)),
	[UsePracticeSettingseRxDownloadSetting] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePracticeSettingseRxDownloadSetting]  DEFAULT ((1)),
	[eRxDownloadSetting] [varchar](2048) NULL,
	[AutoCheckNoteComplete] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoCheckNoteComplete]  DEFAULT ((0)),
	[RoutePatientMessages] [xml](CONTENT [PatientMessagesToUserGroup]) NULL,
	[DefaultCheckDischargePatient] [bit] NOT NULL CONSTRAINT [DF_Provider_DefaultCheckDischargePatient_1]  DEFAULT ((0)),
	[DefaultCheckSendPrescriptions] [bit] NOT NULL CONSTRAINT [DF_Provider_DefaultCheckSendPrescriptions_1]  DEFAULT ((0)),
	[DefaultCheckSendLabOrders] [bit] NOT NULL CONSTRAINT [DF_Provider_DefaultCheckSendLabOrders_1]  DEFAULT ((0)),
	[AllowProcedureWithoutDiag] [bit] NOT NULL CONSTRAINT [DF_Provider_AllowProcedureWithoutDiag]  DEFAULT ((0)),
	[RouteVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteNUSBVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[SendCanelServiceOrderMessage] [bit] NOT NULL CONSTRAINT [DF_Provider_SendCanelServiceOrderMessage]  DEFAULT ((0)),
	[UsePracticeSettingsPatientEmails] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePracticeSettingsPatientEmails]  DEFAULT ((1)),
	[PatientEmails] [xml](CONTENT [PatientInternetEmails]) NULL,
	[ValidateBillingTime] [bit] NOT NULL CONSTRAINT [DF_Provider_ValidateBillingTime_1]  DEFAULT ((0)),
	[AprimaDataExchangeRegistrationLastUpdate] [datetime] NULL,
	[AprimaDataExchangeProviderRegistrationUid] [uniqueidentifier] NULL,
	[DefaultEMPlaceofServiceID] [tinyint] NULL,
	[AutoLinkingDiagnosisProblem] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoLinkingDingnosisProblem]  DEFAULT ((1)),
	[DefaultBillingProviderUid] [uniqueidentifier] NULL,
	[IdentityVerification] [xml] NULL,
	[CDSCatalogUid] [uniqueidentifier] NULL,
	[DiagnosisRangePlanUid] [uniqueidentifier] NULL,
	[KdbConfigurationUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Provider_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Provider_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderAttachment]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderAttachment](
	[ProviderAttachmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[AttachmentUid] [uniqueidentifier] NOT NULL,
	[Hide] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderCpp]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderCpp](
	[ProviderCppUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ProviderCpp_ProviderCppUid]  DEFAULT (newid()),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ProviderCpp_Inactive]  DEFAULT ((0)),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[CppUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](250) NULL,
	[Hide] [bit] NOT NULL CONSTRAINT [DF_ProviderCpp_Hide]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ProviderCpp_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderDefaultConfidentialAccess]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderDefaultConfidentialAccess](
	[ProviderDefaultConfidentialAccessUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderDefaultServiceOrderMessages]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderDefaultServiceOrderMessages](
	[ProviderDefaultServiceOrderMessagesUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderDefaultSIG]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderDefaultSIG](
	[ProviderDefaultSIGUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ProviderDefaultSIG_ProviderDefaultSIGUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[KdbConfigurationUid] [uniqueidentifier] NOT NULL,
	[FDB_MEDID] [int] NULL,
	[FDB_HIC_SEQN] [int] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ProviderDefaultSIG_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ProviderDefaultSIG_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ProviderDefaultSIG_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderDefaultVisitAccess]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderDefaultVisitAccess](
	[ProviderDefaultVisitAccessUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderDirectory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderDirectory](
	[ProviderDirectoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PortalID] [varchar](255) NULL,
	[AccountID] [varchar](255) NULL,
	[BackupPortalID] [varchar](255) NULL,
	[FaxPortalName] [varchar](255) NULL,
	[ServiceLevel] [int] NOT NULL,
	[DefaultLocationServiceLevel] [int] NULL,
	[ActiveStartTime] [varchar](255) NULL,
	[ActiveEndTime] [varchar](255) NULL,
	[Testflag] [varchar](max) NULL,
	[SpecialtyID] [int] NULL,
	[InStoreNCPDPID] [varchar](255) NULL,
	[SPI] [varchar](255) NOT NULL,
	[FileID] [varchar](255) NULL,
	[StateLicenseNumber] [varchar](255) NULL,
	[MedicareNumber] [varchar](255) NULL,
	[MedicaidNumber] [varchar](255) NULL,
	[DentistLicenseNumber] [varchar](255) NULL,
	[UPIN] [varchar](255) NULL,
	[PPONumber] [varchar](255) NULL,
	[DEANumber] [varchar](255) NULL,
	[SocialSecurity] [varchar](255) NULL,
	[NPI] [varchar](255) NULL,
	[PriorAuthorization] [varchar](255) NULL,
	[MutuallyDefined] [varchar](255) NULL,
	[ClinicName] [varchar](255) NULL,
	[LastName] [varchar](255) NOT NULL,
	[FirstName] [varchar](255) NOT NULL,
	[MiddleName] [varchar](255) NULL,
	[Suffix] [varchar](255) NULL,
	[Prefix] [varchar](255) NULL,
	[SpecialtyQualifier] [varchar](255) NULL,
	[SpecialtyCode] [varchar](max) NULL,
	[Address] [xml](CONTENT [Address]) NULL,
	[Email] [varchar](100) NULL,
	[Phone1] [xml](CONTENT [Phone]) NULL,
	[Phone2] [xml](CONTENT [Phone]) NULL,
	[Phone3] [xml](CONTENT [Phone]) NULL,
	[Phone4] [xml](CONTENT [Phone]) NULL,
	[Phone5] [xml](CONTENT [Phone]) NULL,
	[Phone6] [xml](CONTENT [Phone]) NULL,
	[Phone7] [xml](CONTENT [Phone]) NULL,
	[Phone8] [xml](CONTENT [Phone]) NULL,
	[DEAAuthorizingName] [varchar](255) NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [text] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[StationType] [tinyint] NOT NULL,
	[TransmissionStatus] [varchar](max) NULL,
	[ServiceLevelList] [varchar](max) NULL,
	[SpecialtyTypeList] [varchar](max) NULL,
	[DirectAddress] [varchar](255) NULL,
	[OrganizationID] [varchar](255) NULL,
	[DownloadXML] [xml] NULL,
	[SpecialtyUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderEduForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderEduForm](
	[ProviderEduFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[EduFormUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[Hide] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderEPCS]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderEPCS](
	[ProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AuthenticationUserName] [varchar](255) NOT NULL,
	[LastName] [varchar](255) NOT NULL,
	[FirstName] [varchar](255) NOT NULL,
	[DEA] [varchar](255) NOT NULL,
	[DigitalSignatureXML] [xml] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderObservationItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderObservationItem](
	[ProviderObservationItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[RelObservationObservationItemUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[Hide] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderOption]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderOption](
	[ProviderOptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[OptionName] [varchar](50) NULL,
	[DisplayOrder] [int] NOT NULL,
	[OptionValue] [varchar](255) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderProcedureModifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderProcedureModifier](
	[ProviderProcedureModifierUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[ProcedureModifierUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[DisplayOrder] [int] NOT NULL,
	[Hide] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ProviderSignature]') AND type in (N'U'))
BEGIN
CREATE TABLE [ProviderSignature](
	[ProviderSignatureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ProviderSignature_ProviderSignatureUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[Signature] [varbinary](max) NOT NULL,
	[IsPermanentSignature] [bit] NOT NULL CONSTRAINT [DF_ProviderSignature_IsPermanentSignature]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ProviderSignature_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[IsImage] [bit] NOT NULL CONSTRAINT [DF_ProviderSignature_IsImage]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RecordDisclosureAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [RecordDisclosureAudit](
	[RecordDisclosureAuditUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DisclosureDate] [date] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[DisclosedBy] [varchar](1000) NOT NULL,
	[DisclosedTo] [varchar](1000) NOT NULL,
	[DisclosedToDescription] [varchar](1000) NOT NULL,
	[DisclosureDescription] [varchar](2000) NOT NULL,
	[DisclosurePurpose] [varchar](250) NOT NULL,
	[AttachmentGroupUid] [uniqueidentifier] NULL,
	[DocumentName] [varchar](50) NULL,
	[IsPortal] [tinyint] NOT NULL CONSTRAINT [DF_RecordDisclosureAudit_IsPortal]  DEFAULT ((0)),
	[DisclosureMethod] [tinyint] NOT NULL CONSTRAINT [DF_RecordDisclosureAudit_DisclosureMethod]  DEFAULT ((0)),
	[DisclosureType] [tinyint] NOT NULL CONSTRAINT [DF_RecordDisclosureAudit_DisclosureType]  DEFAULT ((0)),
	[RecipientType] [tinyint] NOT NULL CONSTRAINT [DF_RecordDisclosureAudit_RecipientType]  DEFAULT ((0)),
	[VisitUid] [uniqueidentifier] NULL,
	[PatientReferralUid] [uniqueidentifier] NULL,
	[Status] [tinyint] NOT NULL CONSTRAINT [DF_RecordDisclosureAudit_Status]  DEFAULT ((1)),
	[RequestedDate] [date] NOT NULL CONSTRAINT [DF_RecordDisclosureAudit_RequestedDate]  DEFAULT (getdate()),
	[RequestedOfProviderUid] [uniqueidentifier] NULL,
	[DisclosureReasonUid] [uniqueidentifier] NULL,
	[CustomNotePrintUid] [uniqueidentifier] NULL,
	[DisclosureRecipientUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RecurringAppointment]') AND type in (N'U'))
BEGIN
CREATE TABLE [RecurringAppointment](
	[RecurringAppointmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RecurrenceEvery] [int] NOT NULL,
	[TimeTypeUid] [uniqueidentifier] NOT NULL,
	[StartAt] [datetime] NOT NULL,
	[EndBy] [datetime] NULL,
	[EndAfter] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ReimbursementRuleTrigger]') AND type in (N'U'))
BEGIN
CREATE TABLE [ReimbursementRuleTrigger](
	[ReimbursementRuleTriggerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_ReimbursementRuleTriggerUid]  DEFAULT (newid()),
	[ReimbursementRuleUid] [uniqueidentifier] NULL,
	[Message] [varchar](1000) NULL,
	[PositiveTest] [bit] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_PositiveTest]  DEFAULT ((0)),
	[DaysSinceLastTest] [int] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_UserDefined]  DEFAULT ((1)),
	[AgeRangeFrom] [int] NULL,
	[AgeRangeTo] [int] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[DiagnosisSearchDefinition] [varchar](max) NULL,
	[ProcedureRequiresDiagnosis] [bit] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_ProcedureRequiresDiagnosis]  DEFAULT ((0)),
	[LastModifiedUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelAccountResponsiblePartyFinancialCenter]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelAccountResponsiblePartyFinancialCenter](
	[RelAccountResponsiblePartyFinancialCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[LastStatementDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelAddInType]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelAddInType](
	[RelAddInTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table2_RelUserPRMAddInUid_1]  DEFAULT (newid()),
	[AddInTypeUid] [uniqueidentifier] NOT NULL,
	[AddInUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelAddInType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelAddInType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelAlternateAccountPeriod]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelAlternateAccountPeriod](
	[RelAlternateAccountPeriodUid] [uniqueidentifier] NOT NULL,
	[MasterAccountPeriodUid] [uniqueidentifier] NOT NULL,
	[AlternateAccountPeriodUid] [uniqueidentifier] NOT NULL,
	[TargetInsurancePlanUid] [uniqueidentifier] NOT NULL,
	[Note] [varchar](2000) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelAnswerGroupAnswer]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelAnswerGroupAnswer](
	[RelAnswerGroupAnswerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelAnswerGroupAnswer_RelAnswerGroupAnswerUid]  DEFAULT (newid()),
	[AnswerGroupUid] [uniqueidentifier] NOT NULL,
	[AnswerUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelAnswerGroupAnswer_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelAnswerGroupAnswer_DisplayOrder]  DEFAULT ((0)),
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelAnswerGroupAnswer_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelAppointmentResourceAppointment]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelAppointmentResourceAppointment](
	[RelAppointmentResourceAppointmentUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelAppointmentResourceAppointment_RelAppointmentResourceAppointmentUid]  DEFAULT (newid()),
	[ResourceAppointmentUid] [uniqueidentifier] NOT NULL,
	[AppointmentUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelAppointmentResourceAppointment_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelAttachmentGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelAttachmentGroup](
	[RelAttachmentGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelAttachment_RelAttachmentGroupUid]  DEFAULT (newid()),
	[AttachmentGroupUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[ObservationOrderUid] [uniqueidentifier] NULL,
	[MessageUid] [uniqueidentifier] NULL,
	[PatientProcedureHistoryUid] [uniqueidentifier] NULL,
	[IncludeInSummary] [bit] NOT NULL CONSTRAINT [DF_RelAttachmentGroup_IncludeInSummary]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelAttachment_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelAttachment_LastModifiedDate]  DEFAULT (getutcdate()),
	[PatientProviderRelationshipUid] [uniqueidentifier] NULL,
	[PatientReferralUid] [uniqueidentifier] NULL,
	[PracticeFormUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelAuditSuperbill]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelAuditSuperbill](
	[AuditUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[Source] [varchar](64) NOT NULL CONSTRAINT [DF_RelAuditSuperbill_Source]  DEFAULT (' '),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelAuditSuperbill_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelBatchProcessDetailActionSummary]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelBatchProcessDetailActionSummary](
	[RelBatchProcessDetailActionSummaryUid] [uniqueidentifier] NOT NULL,
	[BatchProcessDetailUid] [uniqueidentifier] NOT NULL,
	[ActionType] [varchar](100) NOT NULL,
	[Summary] [varchar](1000) NULL,
	[Detail] [varchar](max) NULL,
	[Success] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCacheMachineAppointment]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCacheMachineAppointment](
	[CacheMachineAppointmentUid] [uniqueidentifier] NOT NULL,
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[AppointmentUid] [uniqueidentifier] NOT NULL,
	[Action] [smallint] NOT NULL,
	[CurrentAction] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCacheMachineFinancialCenter]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCacheMachineFinancialCenter](
	[RelCacheMachineFinancialCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCacheMachineMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCacheMachineMessage](
	[CacheMachineMessageUid] [uniqueidentifier] NOT NULL,
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[MessageUid] [uniqueidentifier] NOT NULL,
	[Action] [smallint] NOT NULL,
	[CurrentAction] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCacheMachinePatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCacheMachinePatient](
	[CacheMachinePatientUid] [uniqueidentifier] NOT NULL,
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Action] [smallint] NOT NULL,
	[CurrentAction] [smallint] NULL,
	[PurgeDate] [datetime] NULL,
	[LastPurgeSyncReceivedAnchor] [bigint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCacheMachineProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCacheMachineProvider](
	[CacheMachineProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CacheMachineProvider_CacheMachineProviderUid]  DEFAULT (newid()),
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CacheMachineProvider_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCacheMachineUserPRM]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCacheMachineUserPRM](
	[CacheMachineUserPRMUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCacheMachineUserPRMUid_CacheMachineUserPRMUid]  DEFAULT (newid()),
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[UserPRMUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCacheMachineUserPRMUid_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCalendarCalendarTemplateHead]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCalendarCalendarTemplateHead](
	[RelCalendarCalendarTemplateHeadUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCalendarCalendarTemplate_CalendarCalendarTemplateUid]  DEFAULT (newid()),
	[CalendarUid] [uniqueidentifier] NOT NULL,
	[CalendarTemplateHeadUid] [uniqueidentifier] NULL,
	[StartDate] [date] NOT NULL,
	[EndDate] [date] NULL,
	[ZIndex] [int] NOT NULL CONSTRAINT [DF_RelCalendarCalendarTemplateHead_ZIndex]  DEFAULT ((0)),
	[RecurrencePattern] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCalendarCalendarTemplate_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCalendarTemplateHeadDaySlotExclude]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCalendarTemplateHeadDaySlotExclude](
	[RelCalendarTemplateHeadDaySlotExcludeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCalendarTemplateHeadDaySlotExclude_RelCalendarTemplateHeadDaySlotExcludeUid]  DEFAULT (newid()),
	[RelCalendarCalendarTemplateHeadUid] [uniqueidentifier] NOT NULL,
	[Date] [date] NOT NULL,
	[StartTime] [smallint] NOT NULL,
	[Duration] [smallint] NULL,
	[AppointmentTypeUid] [uniqueidentifier] NULL,
	[AppointmentUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCalendarTemplateHeadDaySlotExclude_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCaseAuthorizationCodeSet]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCaseAuthorizationCodeSet](
	[RelCaseAuthorizationCodeSetUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCaseAuthorizationCodeSet_RelCaseAuthorizationCodeSetUid]  DEFAULT (newid()),
	[CaseAuthorizationUid] [uniqueidentifier] NULL,
	[CaseAuthorizationCodeSetUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCaseAuthorizationCodeSet_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelCaseAuthorization_Inactive]  DEFAULT ((0)),
	[Units] [int] NULL,
	[AuthorizationCode] [varchar](30) NULL,
	[ExpirationDate] [date] NULL,
	[DoNotDecrement] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCaseAuthorizationCodeSet_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCaseAuthorizationCodeSetProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCaseAuthorizationCodeSetProcedure](
	[RelCaseAuthorizationCodeSetProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCaseAuthorizationCodeSetProcedure_RelCaseAuthorizationCodeSetProcedureUid]  DEFAULT (newid()),
	[CaseAuthorizationCodeSetUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCaseAuthorizationCodeSetProcedure_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCaseAuthorizationDx]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCaseAuthorizationDx](
	[RelCaseAuthorizationDxUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCaseAuthorizationDx_RelCaseAuthorizationDxUid]  DEFAULT (newid()),
	[CaseAuthorizationUid] [uniqueidentifier] NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCaseAuthorizationDx_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelCaseAuthorizationDx_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCaseAuthorization_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCaseAuthorizationDxCodeSet]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCaseAuthorizationDxCodeSet](
	[RelCaseAuthorizationDxCodeSetUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCaseAuthorizationDxCodeSet_RelCaseAuthorizationDxCodeSetUid]  DEFAULT (newid()),
	[RelCaseAuthorizationDxUid] [uniqueidentifier] NOT NULL,
	[RelCaseAuthorizationCodeSetUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelCaseAuthorizationCodeSet_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCaseAuthorizationSet_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCaseAuthorizationDxProcRange]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCaseAuthorizationDxProcRange](
	[RelCaseAuthorizationDxProcRangeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RelCaseAuthorizationDxUid] [uniqueidentifier] NOT NULL,
	[RelCaseAuthorizationProcRangeUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCaseAuthorizationProcRange]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCaseAuthorizationProcRange](
	[RelCaseAuthorizationProcRangeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CaseAuthorizationUid] [uniqueidentifier] NOT NULL,
	[StartRangeProcedureUid] [uniqueidentifier] NOT NULL,
	[EndRangeProcedureUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[CaseAuthorizationCodeUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCaseAuthorizationProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCaseAuthorizationProvider](
	[RelCaseAuthorizationProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCaseAuthorizationProvider_RelCaseAuthorizationProviderUid]  DEFAULT (newid()),
	[CaseAuthorizationUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCaseAuthorizationProvider_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCaseTypePhaseEduForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCaseTypePhaseEduForm](
	[RelCaseTypePhaseEduFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCaseTypePhaseEduForm_RelCaseTypePhaseEduFormUid]  DEFAULT (newid()),
	[CaseTypePhaseUid] [uniqueidentifier] NULL,
	[EduFormUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCaseTypePhaseEduForm_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCaseTypePhaseEduForm_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCaseTypePhaseLabTemplate]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCaseTypePhaseLabTemplate](
	[RelCaseTypePhaseLabTemplateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCaseTypePhaseLabTemplate_RelCaseTypePhaseLabTemplateUid]  DEFAULT (newid()),
	[CaseTypePhaseUid] [uniqueidentifier] NULL,
	[ObservationUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCaseTypePhaseLabTemplate_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCaseTypePhaseLabTemplate_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCCSymptomHpi]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCCSymptomHpi](
	[RelCCSymptomHpiUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_RelCCSymptomHpiUid]  DEFAULT (newid()),
	[RelCCSymptomHpiCategoryUid] [uniqueidentifier] NOT NULL,
	[HpiUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[ProcedurePerformed] [bit] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_ProcedurePerformed_1]  DEFAULT ((1)),
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DiagnosisDescription] [varchar](255) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCCSymptomHpiCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCCSymptomHpiCategory](
	[RelCCSymptomHpiCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_RelCCSymptomHpiCategoryUid]  DEFAULT (newid()),
	[RelCCSystemSymptomUid] [uniqueidentifier] NOT NULL,
	[HpiCategoryUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_UserDefined]  DEFAULT ((1)),
	[NaturalLanguage] [varchar](100) NULL,
	[SingleSelect] [bit] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_SingleSelect_1]  DEFAULT ((0)),
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCCSystemSymptom]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCCSystemSymptom](
	[RelCCSystemSymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_RelCCSystemSymptomUid]  DEFAULT (newid()),
	[CCSystemUid] [uniqueidentifier] NOT NULL,
	[CCSymptomUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[Preposition] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_Inactive]  DEFAULT ((0)),
	[ShortcutRelCCSystemSymptomUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DiagnosisDescription] [varchar](255) NULL,
	[ClinicCenterOverride] [xml](CONTENT [KdbOverrideCC]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverrideCC]) NULL,
	[LicenseCode] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCDSCatalogClinicCenter]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCDSCatalogClinicCenter](
	[RelCDSCatalogClinicCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CDSCatalogUid] [uniqueidentifier] NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCDSCatalogProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCDSCatalogProvider](
	[RelCDSCatalogProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CDSCatalogUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelChargeTicketCategoryDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelChargeTicketCategoryDiagnosis](
	[RelChargeTicketCategoryDiagnosisUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelChargeTicketCategoryDiagnosisUid_RelChargeTicketCategoryDiagnosisUid]  DEFAULT (newid()),
	[ChargeTicketDiagnosisUid] [uniqueidentifier] NOT NULL,
	[DiagnosisCategoryUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategoryDiagnosisUid_DisplayOrder]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategoryDiagnosisUid_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketCategoryDiagnosisUid_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelChargeTicketCategorySO]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelChargeTicketCategorySO](
	[RelChargeTicketCategorySOUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySO_RelChargeTicketCategorySOUid]  DEFAULT (newid()),
	[ChargeTicketSOUid] [uniqueidentifier] NULL,
	[ProcedureCategoryUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySO_DisplayOrder]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySO_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySO_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelChargeTicketCategorySP]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelChargeTicketCategorySP](
	[RelChargeTicketCategorySPUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_RelChargeTicketSPUid]  DEFAULT (newid()),
	[ChargeTicketSPUid] [uniqueidentifier] NULL,
	[ProcedureCategoryUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySP_DisplayOrder]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySP_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySP_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelChargeTicketDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelChargeTicketDiagnosis](
	[RelChargeTicketDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_RelChargeTicketDiagnosisUid]  DEFAULT (newid()),
	[RelChargeTicketCategoryDiagnosisUid] [uniqueidentifier] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[SearchDefinition] [varchar](800) NULL,
	[DiagnosisPanelUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_Inactive]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelChargeTicketSO]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelChargeTicketSO](
	[RelChargeTicketSOUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelChargeTicketSO_RelChargeTicketSOUid]  DEFAULT (newid()),
	[RelChargeTicketCategorySOUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[ProcedurePanelUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketSO_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelChargeTicketSO_Inactive]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketSO_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketSO_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelChargeTicketSP]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelChargeTicketSP](
	[RelChargeTicketSPUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelChargeTicketSP_RelChargeTicketSPUid]  DEFAULT (newid()),
	[RelChargeTicketCategorySPUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[ProcedurePanelUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketSP_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelChargeTicketSP_Inactive]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketSP_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketSP_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelClaimFormatValueTypeMisc]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelClaimFormatValueTypeMisc](
	[RelClaimFormatValueTypeMiscUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table_1_RelClaimFormatValueTypeType]  DEFAULT (newid()),
	[ClaimFormatValueTypeUid] [uniqueidentifier] NOT NULL,
	[MiscUid] [uniqueidentifier] NOT NULL,
	[AllowDefault] [bit] NOT NULL CONSTRAINT [DF_RelClaimFormatValueTypeMisc_AllowDefault]  DEFAULT ((1)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelClaimFormatValueTypeMisc_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelClaimFormatValueTypeMisc_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelClaimFormatValueTypeMisc_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelCP_CarePlan_CP_Goal]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelCP_CarePlan_CP_Goal](
	[RelCP_CarePlan_CP_GoalUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[CP_GoalUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [nchar](10) NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDiagnosisDisease]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDiagnosisDisease](
	[RelDiagnosisDiseaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelDiagnosisDisease_RelDiagnosisDiseaseUid]  DEFAULT (newid()),
	[DiseaseUid] [uniqueidentifier] NULL CONSTRAINT [DF_RelDiagnosisDisease_DiseaseUid]  DEFAULT (newid()),
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelDiagnosisDisease_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelDiagnosisDisease_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDiagnosisDpn]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDiagnosisDpn](
	[RelDiagnosisDpnUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DpnGroupUid] [uniqueidentifier] NOT NULL,
	[DiagnosisSearchDefinition] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDiagnosisPanelDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDiagnosisPanelDiagnosis](
	[RelDiagnosisPanelDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelDiagnosisPanelDiagnosis_RelDiagnosisPanelDiagnosisUid]  DEFAULT (newid()),
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[DiagnosisPanelUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelDiagnosisPanelDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelDiagnosisPanelDiagnosis_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelDiagnosisPanelDiagnosis_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelDiagnosisPanelDiagnosis_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDiagnosisProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDiagnosisProcedure](
	[RelDiagnosisProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDiagnosisRangePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDiagnosisRangePlan](
	[RelDiagnosisRangePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DiagnosisRangePlanUid] [uniqueidentifier] NULL,
	[DiagnosisSearchDefinitionUid] [uniqueidentifier] NOT NULL,
	[DpnGroupUid] [uniqueidentifier] NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDiseaseGroupDisease]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDiseaseGroupDisease](
	[RelDiseaseGroupDiseaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DiseaseGroupUid] [uniqueidentifier] NOT NULL,
	[DiseaseUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDispensableRxCodes]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDispensableRxCodes](
	[RelDispensableRxCodesUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DispensableUid] [uniqueidentifier] NOT NULL,
	[RxNorm] [varchar](15) NULL,
	[RxNormQualifier] [varchar](10) NULL,
	[NDC] [varchar](11) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [text] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDpnGroupDpnNode]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDpnGroupDpnNode](
	[RelDpnGroupDpnNodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_RelDpnGroupDpnNodeUid]  DEFAULT (newid()),
	[ParentRelDpnGroupDpnNodeUid] [uniqueidentifier] NULL,
	[DpnGroupUid] [uniqueidentifier] NOT NULL,
	[DpnNodeUid] [uniqueidentifier] NOT NULL,
	[NodeLevel] [int] NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_NodeLevel]  DEFAULT ((0)),
	[IsNodeLeaf] [bit] NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_IsNodeLeaf]  DEFAULT ((1)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[PreSelected] [bit] NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_PreSelected]  DEFAULT ((0)),
	[DefaultFlag] [bit] NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_DefaultFlag]  DEFAULT ((0)),
	[SnomedDescriptionUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [KdbOverrideDpn]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverrideDpn]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_LastModifiedDate]  DEFAULT (getutcdate()),
	[IsMultiSelect] [bit] NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_IsMultiSelect]  DEFAULT ((1)),
	[RequiredFlag] [bit] NOT NULL CONSTRAINT [DF_RelDpnGroupDpnNode_RequiredFlag]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDpnGroupOrderAction]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDpnGroupOrderAction](
	[RelDpnGroupOrderActionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelDpnGroupOrderAction_RelDpnGroupOrderActionUid]  DEFAULT (newid()),
	[DpnGroupUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelDpnGroupOrderAction_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelDpnGroupOrderAction_UserDefined]  DEFAULT ((1)),
	[OrderActionTime] [smallint] NOT NULL CONSTRAINT [DF_RelDpnGroupOrderAction_OrderActionTime]  DEFAULT ((3)),
	[OrderActionTable] [smallint] NOT NULL CONSTRAINT [DF_RelDpnGroupOrderAction_OrderActionTable]  DEFAULT ((0)),
	[MessageTypeUid] [uniqueidentifier] NULL,
	[FaxServerUid] [uniqueidentifier] NULL,
	[HL7PartnerMessageUid] [uniqueidentifier] NULL,
	[MapOrderActionTemplateXml] [xml] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelDpnGroupOrderAction_LastModifiedDate]  DEFAULT (getutcdate()),
	[HeaderFormattingTemplateUid] [uniqueidentifier] NULL,
	[BodyFormattingTemplateUid] [uniqueidentifier] NULL,
	[MessageSubTypeUid] [uniqueidentifier] NULL,
	[ProductParameterUid] [uniqueidentifier] NULL,
	[FailureRelDpnGroupOrderActionUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelDpnGroupOrderAction_Display]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelDpnGroupOrderActionAttachment]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelDpnGroupOrderActionAttachment](
	[RelDpnGroupOrderActionAttachmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RelDpnGroupOrderActionUid] [uniqueidentifier] NOT NULL,
	[AttachmentFormattingTemplateUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelEduFormAssociation]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelEduFormAssociation](
	[RelEduFormAssociationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_RelEduFormAssociationUid]  DEFAULT (newid()),
	[EduFormAssociationUid] [uniqueidentifier] NOT NULL,
	[EduFormUid] [uniqueidentifier] NOT NULL,
	[Smoker] [bit] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_Smoker]  DEFAULT ((0)),
	[Underweight] [bit] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_Underweight]  DEFAULT ((0)),
	[Overweight] [bit] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_Overweight]  DEFAULT ((0)),
	[RecurrenceInterval] [smallint] NULL CONSTRAINT [DF_RelEduFormAssociation_RecurrenceInterval]  DEFAULT ((0)),
	[RecurTimeTypeUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[AgeFrom] [int] NULL,
	[AgeTo] [int] NULL,
	[AgeTimeTypeUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_UserDefined_1]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelEduFormGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelEduFormCCSymptom]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelEduFormCCSymptom](
	[RelEduFormCCSymptomUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelEduFormCCSymptom_RelEduFormCCSymptomUid]  DEFAULT (newid()),
	[RelEduFormAssociationUid] [uniqueidentifier] NOT NULL,
	[RelCCSystemSymptomUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelEduFormCCSymptom_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelEduFormCCSymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelEduFormDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelEduFormDiagnosis](
	[RelEduFormDiagnosisUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelEduFormDiagnosis_RelEduFormDiagnosisUid]  DEFAULT (newid()),
	[RelEduFormAssociationUid] [uniqueidentifier] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelEduFormDiagnosis_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelEduFormDiagnosis_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelEduFormObservationItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelEduFormObservationItem](
	[RelEduFormObservationItemUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelEduFormObservationItem_RelEduFormObservationItemUid]  DEFAULT (newid()),
	[RelEduFormAssociationUid] [uniqueidentifier] NOT NULL,
	[ObservationItemUid] [uniqueidentifier] NOT NULL,
	[RelationalOperatorUid] [uniqueidentifier] NOT NULL,
	[DataValue] [varchar](255) NULL,
	[Conjunctor] [bit] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelEduFormObservationItem_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelEduFormObservationItem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelEduFormProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelEduFormProcedure](
	[RelEduFormProcedureUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelEduFormProcedure_RelEduFormProcedureUid]  DEFAULT (newid()),
	[RelEduFormAssociationUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelEduFormProcedure_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelEduFormProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelEMKeyComponentBullet]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelEMKeyComponentBullet](
	[RelEMKeyComponentBulletUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelEMKeyComponentBullet_RelEMKeyComponentBulletUid]  DEFAULT (newid()),
	[EMKeyComponentUid] [uniqueidentifier] NOT NULL,
	[EMExaminationDescriptionUid] [uniqueidentifier] NULL,
	[EMSystemBodyAreaUid] [uniqueidentifier] NULL,
	[EMBulletUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelEMKeyComponentBullet_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelEMKeyComponentBullet_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelEmployerInsurancePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelEmployerInsurancePlan](
	[RelEmployerInsurancePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelEmployerInsurancePlan_RelEmployerInsurancePlanUid]  DEFAULT (newid()),
	[CorporationUid] [uniqueidentifier] NULL,
	[InsurancePlanUid] [uniqueidentifier] NULL,
	[InsurancePayerContactUid] [uniqueidentifier] NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelEmployerInsurancePlan_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFilterNotification]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFilterNotification](
	[FilterNotificationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table1_JobNotificationUid]  DEFAULT (newid()),
	[FilterUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelFilterNotification_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelFilterNotification_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFilterUserPRM]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFilterUserPRM](
	[RelFilterUserPRMUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelFilterUserPRM_RelFilterUserPRMUid]  DEFAULT (newid()),
	[Type] [varchar](50) NOT NULL,
	[SubType] [varchar](50) NOT NULL CONSTRAINT [DF_RelFilterUserPRM_SubType]  DEFAULT (''),
	[FilterUid] [uniqueidentifier] NOT NULL,
	[UserPrmUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelFilterUserPRM_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFinancialCenterSuperbillStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFinancialCenterSuperbillStatus](
	[RelFinancialCenterSuperbillStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[SuperbillStatusUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFindTableHide]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFindTableHide](
	[RelFindTableHideUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_RelFindHide]  DEFAULT (newid()),
	[FindTableUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[Uid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelFindTableHide_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFindTableHideDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFindTableHideDiagnosis](
	[RelFindTableHideDiagnosisUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[Code09] [varchar](15) NOT NULL,
	[Code10] [varchar](15) NULL,
	[CodeDescription] [varchar](512) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFindTableMFU]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFindTableMFU](
	[RelFindTableMFUUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelFindTableMFU_RelFindTableMFUUid]  DEFAULT (newid()),
	[FindTableUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[Uid] [uniqueidentifier] NOT NULL,
	[Count] [int] NOT NULL CONSTRAINT [DF_RelFindTableMFU_Count]  DEFAULT ((0)),
	[Exclude] [bit] NOT NULL CONSTRAINT [DF_RelFindTableMFU_Exclude]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelFindTableMFU_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFindTableMFUDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFindTableMFUDiagnosis](
	[RelFindTableMFUDiagnosisUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[LexCode] [bigint] NOT NULL,
	[Code09] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](512) NULL,
	[Count] [int] NOT NULL,
	[Exclude] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFindTableMRU]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFindTableMRU](
	[RelFindTableMRUUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelFindTableMRU_RelFindTableMRUUid]  DEFAULT (newid()),
	[FindTableUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[Uid] [uniqueidentifier] NOT NULL,
	[MRUOrder] [int] NOT NULL CONSTRAINT [DF_Table_1_Count]  DEFAULT ((0)),
	[Exclude] [bit] NOT NULL CONSTRAINT [DF_RelFindTableMRU_Exclude]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelFindTableMRU_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFindTableMRUDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFindTableMRUDiagnosis](
	[RelFindTableMRUDiagnosisUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[LexCode] [bigint] NOT NULL,
	[Code09] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](512) NULL,
	[MRUOrder] [int] NOT NULL,
	[Exclude] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFormLayoutClinicalNoteType]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFormLayoutClinicalNoteType](
	[RelFormLayoutClinicalNoteTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_RelFormLayoutClinicalNoteControl]  DEFAULT (newid()),
	[FormLayoutUid] [uniqueidentifier] NOT NULL,
	[ClinicalNoteTypeUid] [uniqueidentifier] NOT NULL,
	[Caption] [varchar](50) NOT NULL,
	[DataTag] [varchar](50) NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[IsSlider] [bit] NOT NULL CONSTRAINT [DF_RelFormLayoutClinicalNoteType_IsSlider]  DEFAULT ((0)),
	[UserDefined] [tinyint] NULL CONSTRAINT [DF_RelFormLayoutClinicalNoteType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelFormLayoutClinicalNoteType_LastModifiedDate]  DEFAULT (getutcdate()),
	[Abbreviation] [varchar](3) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFormLayoutProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFormLayoutProcedure](
	[RelFormLayoutProcedureUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelFormLayoutProcedure_RelFormLayoutProcedureUid]  DEFAULT (newid()),
	[FormLayoutUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelFormLayoutProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFormLayoutUserSetting]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFormLayoutUserSetting](
	[RelFormLayoutUserSettingUid] [uniqueidentifier] NOT NULL,
	[FormLayoutUid] [uniqueidentifier] NOT NULL,
	[UserSettingUid] [uniqueidentifier] NOT NULL,
	[Caption] [varchar](50) NOT NULL,
	[DataTag] [varchar](50) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[Type] [varchar](50) NOT NULL,
	[UserDefined] [tinyint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelFormTitleUserSetting]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelFormTitleUserSetting](
	[FormTitleUserSettingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelFormTitleUserSetting_FormTitleUserSettingUid]  DEFAULT (newid()),
	[FormTitleUid] [uniqueidentifier] NOT NULL,
	[UserSettingUid] [uniqueidentifier] NULL,
	[Columns] [xml] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelFormTitleUserSetting_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelFormTitleUserSetting_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelGroupAppointmentPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelGroupAppointmentPatient](
	[RelGroupAppointmentPatientUid] [uniqueidentifier] NOT NULL,
	[AppointmentUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[AppointmentStatusUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[PatientGroupUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHL7PartnerInsurancePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHL7PartnerInsurancePlan](
	[RelHL7PartnerInsurancePlanUid] [uniqueidentifier] NOT NULL,
	[HL7PartnerUid] [uniqueidentifier] NOT NULL,
	[InsurancePlanUid] [uniqueidentifier] NOT NULL,
	[LabCode] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHL7PartnerPatientConsent]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHL7PartnerPatientConsent](
	[RelHL7PartnerPatientConsentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[HL7PartnerUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[ConsentDate] [date] NULL,
	[ConsentAgreed] [bit] NULL,
	[ProtectionIndicator] [char](1) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleClinicCenter]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleClinicCenter](
	[HMRuleClinicCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHMRuleClinicCenter_HMRuleClinicCenterUid]  DEFAULT (newid()),
	[HMRuleUid] [uniqueidentifier] NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHMRuleClinicCenter_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleClinicCenterMsgRecipient]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleClinicCenterMsgRecipient](
	[HMRuleClinicCenterMsgRecipientUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHMRuleClinicCenterMsgRecipient_HMRuleClinicCenterMsgRecipientUid]  DEFAULT (newid()),
	[HMRuleClinicCenterUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHMRuleClinicCenterMsgRecipient_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleClinicCenterProviderOptOut]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleClinicCenterProviderOptOut](
	[HMRuleClinicCenterProviderOptOutUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHMRuleClinicCenterProviderOptOut_HMRuleClinicCenterProviderOptOutUid]  DEFAULT (newid()),
	[HMRuleClinicCenterUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHMRuleClinicCenterProviderOptOut_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleDisease]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleDisease](
	[RelHMRuleDiseaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHMRuleDisease_RelHMRuleDiseaseUid]  DEFAULT (newid()),
	[HMRuleUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[Name] [varchar](100) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelHMRuleDisease_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelHMRuleDisease_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHMRuleDisease_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleDrugAllergy]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleDrugAllergy](
	[RelHMRuleDrugAllergyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[HMRuleUid] [uniqueidentifier] NOT NULL,
	[QuestionUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[DisplayOrder] [int] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleDrugClass]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleDrugClass](
	[RelHMRuleDrugClassUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHMRuleDrugClass_RelHMRuleDrugClassUid]  DEFAULT (newid()),
	[HMRuleUid] [uniqueidentifier] NULL,
	[ClassUid] [uniqueidentifier] NULL,
	[FDB_CLASSID] [int] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelHMRuleDrugClass_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHMRuleDrugClass_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleDrugName]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleDrugName](
	[RelHMRuleDrugNameUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHMRuleDrug_RelHMRuleDrugUid]  DEFAULT (newid()),
	[HMRuleUid] [uniqueidentifier] NULL,
	[DrugNameUid] [uniqueidentifier] NULL,
	[FDB_MNID] [int] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelHMRuleDrugName_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHMRuleDrug_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleGender]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleGender](
	[RelHMRuleGenderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHMRuleGender_RelHMRuleGenderUid]  DEFAULT (newid()),
	[HMRuleUid] [uniqueidentifier] NULL,
	[PQRIMeasureUid] [uniqueidentifier] NULL,
	[VitalMinMaxUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelHMRuleGender_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHMRuleGender_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRulePatientOverride]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRulePatientOverride](
	[RelHMRulePatientOverrideUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[HMRuleUid] [uniqueidentifier] NOT NULL,
	[AgeFrom] [int] NOT NULL,
	[AgeTo] [int] NOT NULL,
	[AgeTimeTypeUid] [uniqueidentifier] NULL,
	[RecurFrom] [smallint] NOT NULL,
	[RecurTo] [smallint] NOT NULL,
	[RecurTimeTypeUid] [uniqueidentifier] NULL,
	[LimitRecurrences] [bit] NOT NULL,
	[MaxRecurrence] [int] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [int] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleProcedure](
	[RelHMRuleProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHMRuleProcedure_RelHMRuleProcedureUid]  DEFAULT (newid()),
	[HMRuleUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[Name] [varchar](100) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelHMRuleProcedure_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelHMRuleProcedure_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHMRuleProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHMRuleProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHMRuleProvider](
	[RelHMRuleProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[HMRuleUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHospitalRoundDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHospitalRoundDiagnosis](
	[RelHospitalRoundDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHospitalRoundDiagnosis_RelHospitalRoundDiagnosisUid]  DEFAULT (newid()),
	[HospitalRoundUid] [uniqueidentifier] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHospitalRoundDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelHospitalRoundProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelHospitalRoundProvider](
	[RelHospitalRoundProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelHospitalRoundProvider_RelHospitalRoundProviderUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[HospitalRoundUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelHospitalRoundProvider_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelICD10Transition]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelICD10Transition](
	[ObjectUid] [uniqueidentifier] NOT NULL,
	[TransitionStart] [date] NULL,
	[TransitionMandatory] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelInsuranceCarrierProviderExclusion]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelInsuranceCarrierProviderExclusion](
	[RelInsuranceCarrierProviderExclusion] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CorporationUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelInsurancePlanProviderInNetworkStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelInsurancePlanProviderInNetworkStatus](
	[RelInsurancePlanProviderInNetworkStatusUid] [uniqueidentifier] NOT NULL,
	[InsurancePlanUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelIntegrationPartnerDirectAddress]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelIntegrationPartnerDirectAddress](
	[RelIntegrationPartnerDirectAddressUid] [uniqueidentifier] NOT NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NOT NULL,
	[DirectAddress] [varchar](255) NOT NULL,
	[MessageRoutingUid] [uniqueidentifier] NULL,
	[AdditionalConfigurationXML] [xml](CONTENT [DirectAddressConfigurationData]) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelIntegrationPartnerServiceSite]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelIntegrationPartnerServiceSite](
	[RelIntegrationPartnerServiceSiteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelIntegrationPartnerServiceSite_RelIntegrationPartnerServiceSiteUid]  DEFAULT (newid()),
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelIntegrationPartnerServiceSite_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelIntegrationPartnerServiceSite_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelMedicationDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelMedicationDiagnosis](
	[RelMedicationDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitRelMedicationDiagnosis_VisitRelMedicationDiagnosisUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelMedicationDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelMedicationDiagnosis_Inactive]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_RelMedicationDiagnosis_IsDelete]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelMedicationDiagnosis_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelMedicationProblem]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelMedicationProblem](
	[RelMedicationProblemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[DiseaseUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[Inactive] [bit] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelMedicationStateScheduledDrugName]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelMedicationStateScheduledDrugName](
	[RelMedicationStateScheduledDrugNameUid] [uniqueidentifier] NOT NULL,
	[MedicationStateScheduledUid] [uniqueidentifier] NOT NULL,
	[DrugNameUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [text] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelMessageHL7ObservationOrder]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelMessageHL7ObservationOrder](
	[RelMessageHL7ObservationOrderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelMessageHL7ObservationOrder_RelMessageHL7ObservationOrderUid]  DEFAULT (newid()),
	[MessageUid] [uniqueidentifier] NOT NULL,
	[ObservationOrderUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelMessageHL7ObservationOrder_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelMessageTypeMessageSubType]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelMessageTypeMessageSubType](
	[RelMessageTypeMessageSubTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MessageTypeUid] [uniqueidentifier] NOT NULL,
	[MessageSubTypeUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelMessageVoiceAttachment]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelMessageVoiceAttachment](
	[RelMessageVoiceAttachmentUid] [uniqueidentifier] NOT NULL,
	[MessageUid] [uniqueidentifier] NOT NULL,
	[AttachmentUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationCustomUser]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationCustomUser](
	[RelObservationCustomUserUid] [uniqueidentifier] NOT NULL,
	[LabelText] [varchar](250) NULL,
	[ReviewDefined] [bit] NOT NULL CONSTRAINT [DF_RelObservationCustomUser_ReviewDefined]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelObservationCustomUser_DisplayOrder]  DEFAULT ((0)),
	[ObservationCustomUserUid] [uniqueidentifier] NOT NULL,
	[ObservationItemUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelObservationCustomUser_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationCustomUser_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationGroupObservation]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationGroupObservation](
	[RelObservationGroupObservationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelObservationGroupObservation_RelObservationGroupObservationUid]  DEFAULT (newid()),
	[CaseTypeUid] [uniqueidentifier] NULL,
	[ObservationGroupUid] [uniqueidentifier] NULL,
	[ObservationUid] [uniqueidentifier] NULL,
	[SpecialtyUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelObservationGroupObservation_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelObservationGroupObservation_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationGroupObservation_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelObservationGroupObservation_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationItemDisease]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationItemDisease](
	[RelObservationItemDiseaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ObservationItemUid] [uniqueidentifier] NOT NULL,
	[DiseaseUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationItemLaboratory]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationItemLaboratory](
	[RelObservationItemLaboratoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelObservationItemLaboratory_RelObservationItemLaboratoryUid]  DEFAULT (newid()),
	[ObservationItemUid] [uniqueidentifier] NULL,
	[LaboratoryUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[IntegerMin] [int] NULL,
	[IntegerMax] [int] NULL,
	[FloatMin] [float] NULL,
	[FloatMax] [float] NULL,
	[DateTimeMin] [datetime] NULL,
	[DateTimeMax] [datetime] NULL,
	[StringMin] [varchar](100) NULL,
	[StringMax] [varchar](100) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationItemLaboratory_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationObservationItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationObservationItem](
	[RelObservationObservationItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelObservationItem_RelObservationItemUid]  DEFAULT (newid()),
	[ObservationUid] [uniqueidentifier] NULL,
	[ObservationItemUid] [uniqueidentifier] NULL,
	[Optional] [bit] NOT NULL CONSTRAINT [DF_RelObservationObservationItem_Optional]  DEFAULT ((1)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelObservationObservationItem_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelObservationObservationItem_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationObservationItem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationProcedure](
	[RelObservationProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelObservationProcedure_RelObservationProcedureUid]  DEFAULT (newid()),
	[ObservationUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationViewOptionAttachmentType]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationViewOptionAttachmentType](
	[RelObservationViewOptionAttachmentTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelObservationViewOptionAttachmentType_RelObservationViewOptionAttachmentTypeUid]  DEFAULT (newid()),
	[ObservationViewOptionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelObservationViewOptionAttachmentType_ObservationViewOptionUid]  DEFAULT (newid()),
	[AttachmentTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelObservationViewOptionAttachmentType_AttachmentTypeUid]  DEFAULT (newid()),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelObservationViewOptionAttachmentType_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelObservationViewOptionAttachmentType_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationViewOptionAttachmentType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationViewOptionDefaultProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationViewOptionDefaultProvider](
	[RelObservationViewOptionDefaultProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelObservationViewOptionDefaultProvider_RelObservationViewOptionDefaultProviderUid]  DEFAULT (newid()),
	[ObservationViewOptionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelObservationViewOptionDefaultProvider_ObservationViewOptionUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelObservationViewOptionDefaultProvider_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelObservationViewOptionDefaultProvider_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationViewOptionDefaultProvider_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationViewOptionLaboratory]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationViewOptionLaboratory](
	[RelObservationViewOptionLaboratoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ObservationViewOptionUid] [uniqueidentifier] NOT NULL,
	[LaboratoryUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationViewOptionObservation]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationViewOptionObservation](
	[RelObservationViewOptionObservationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ObservationViewOptionUid] [uniqueidentifier] NOT NULL,
	[ObservationUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationViewOptionObservationGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationViewOptionObservationGroup](
	[RelObservationViewOptionObservationGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ObservationViewOptionUid] [uniqueidentifier] NOT NULL,
	[ObservationGroupUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationViewOptionProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationViewOptionProvider](
	[RelObservationViewOptionProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelObservationViewOptionProvider_RelObservationViewOptionProviderUid]  DEFAULT (newid()),
	[ObservationViewOptionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelObservationViewOptionProvider_ObservationViewOptionUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelObservationViewOptionProvider_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelObservationViewOptionProvider_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationViewOptionProvider_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelObservationViewOptionResultStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelObservationViewOptionResultStatus](
	[RelObservationViewOptionResultStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelObservationViewOptionResultStatus_RelObservationViewOptionResultStatusUid]  DEFAULT (newid()),
	[ObservationViewOptionUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelObservationViewOptionResultStatus_ObservationViewOptionUid]  DEFAULT (newid()),
	[ResultStatusID] [smallint] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelObservationViewOptionResultStatus_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelObservationViewOptionResultStatus_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationViewOptionResultStatus_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelOrderedProcedurePatientProcedureHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelOrderedProcedurePatientProcedureHistory](
	[RelOrderedProcedurePatientProcedureHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientProcedureHistoryUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientCareManagementDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientCareManagementDiagnosis](
	[RelPatientCareManagementDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCareManagementUid] [uniqueidentifier] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientCondition]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientCondition](
	[RelPatientConditionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientConditionUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientCP_Goal_PatientCP_HealthConcern]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientCP_Goal_PatientCP_HealthConcern](
	[RelPatientCP_Goal_PatientCP_HealthConcernUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_GoalHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientCP_Goal_PatientCP_Intervention]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientCP_Goal_PatientCP_Intervention](
	[RelPatientCP_Goal_PatientCP_InterventionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_GoalHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientCP_InterventionHistoryUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientCP_Goal_PatientProblemDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientCP_Goal_PatientProblemDiagnosis](
	[RelPatientCP_Goal_PatientProblemDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_GoalHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientCP_HealthConcern_ObservationItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientCP_HealthConcern_ObservationItem](
	[RelPatientCP_HealthConcern_ObservationItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] NOT NULL,
	[ObservationItemUid] [uniqueidentifier] NOT NULL,
	[ObservationOrderUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientCP_HealthConcern_PatientHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientCP_HealthConcern_PatientHistory](
	[RelPatientCP_HealthConcern_PatientHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientHistoryDetailUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientCP_HealthConcern_PatientProblemDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientCP_HealthConcern_PatientProblemDiagnosis](
	[RelPatientCP_HealthConcern_PatientProblemDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientMedication]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientMedication](
	[RelPatientMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPatientMedication_RelPatientMedicationUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[RelVisitMedicationUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ActiveDate] [date] NULL CONSTRAINT [DF_RelPatientMedication_ActiveTime]  DEFAULT (getdate()),
	[InactiveDate] [date] NULL,
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_RelPatientMedication_IsPatientInput]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[EnteredFromVisitUid] [uniqueidentifier] NULL,
	[Status] [tinyint] NOT NULL CONSTRAINT [DF_RelPatientMedication_Status]  DEFAULT ((0)),
	[StatusMessage] [varchar](max) NULL,
	[DataXML] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPatientMedication_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientPersonWeb]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientPersonWeb](
	[RelPatientPersonWebUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelPatientPersonWeb_RelPatientPersonWebUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[IgnoreAge] [bit] NOT NULL CONSTRAINT [DF_RelPatientPersonWeb_IgnoreAge]  DEFAULT ((0)),
	[Inactive] [smallint] NOT NULL CONSTRAINT [DF_RelPatientPersonWeb_Inactive]  DEFAULT ((0)),
	[PersonContactUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientProgram]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientProgram](
	[RelPatientProgramUid] [uniqueidentifier] NOT NULL,
	[PatientProgramUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientProgramPersonWeb]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientProgramPersonWeb](
	[RelPatientProgramPersonWebUid] [uniqueidentifier] NOT NULL,
	[PatientProgramUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[Inactive] [smallint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientProviderCDAFormatting]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientProviderCDAFormatting](
	[RelPatientProviderCDAFormattingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientProviderRelationshipUid] [uniqueidentifier] NOT NULL,
	[FormattingTemplateUid] [uniqueidentifier] NULL,
	[CDASectionUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPatientStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPatientStatus](
	[RelPatientStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPatientStatus_PatientStatusUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientStatusUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPatientStatus_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPerformProcedurePatientProcedureHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPerformProcedurePatientProcedureHistory](
	[RelPerformProcedurePatientProcedureHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPerformProcedurePatientProcedureHistory_RelPerformProcedurePatientProcedureHistoryUid]  DEFAULT (newid()),
	[PatientProcedureHistoryUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPersonEthnicity]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPersonEthnicity](
	[RelPersonEthnicityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPersonEthnicity_RelPersonEthnicityUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NOT NULL,
	[EthnicityUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPersonEthnicity2_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_RelPersonEthnicity2_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPersonRace]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPersonRace](
	[RelPersonRaceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPersonEthnicity_RelPersonRaceUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NOT NULL,
	[RaceUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPersonEthnicity_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_RelPersonEthnicity_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPETemplateDescription]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPETemplateDescription](
	[RelPETemplateDescriptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPETemplateDescription_RelPETemplateDescriptionUid]  DEFAULT (newid()),
	[RelPETemplateSymptomUid] [uniqueidentifier] NOT NULL,
	[PEDescriptionUid] [uniqueidentifier] NOT NULL,
	[RelEMKeyComponentBulletUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[NormalFlag] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_NormalFlag]  DEFAULT ((0)),
	[DefaultFlag] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_DefaultFlag]  DEFAULT ((0)),
	[CountAsBullet] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_CountAsBullet]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [KdbOverridePE]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverridePE]) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_LifeLong]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPETemplateParentSystem]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPETemplateParentSystem](
	[RelPETemplateParentSystemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPETemplateParentSystem_RelPETemplateParentSystemUid]  DEFAULT (newid()),
	[PETemplateUid] [uniqueidentifier] NOT NULL,
	[PEParentSystemUid] [uniqueidentifier] NOT NULL,
	[ColorID] [smallint] NOT NULL CONSTRAINT [DF_RelPETemplateParentSystem_ColorID]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[AllowsBilaterality] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateParentSystem_AllowsBilaterality_1]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPETemplateParentSystem_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPETemplateParentSystem_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPETemplateParentSystem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPETemplateSymptom]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPETemplateSymptom](
	[RelPETemplateSymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPETemplateSymptom_RelPETemplateSymptomUid]  DEFAULT (newid()),
	[RelPETemplateSystemUid] [uniqueidentifier] NULL,
	[PESymptomUid] [uniqueidentifier] NOT NULL,
	[RelEMKeyComponentBulletUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPETemplateSymptom_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[AllowsBilaterality] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateSymptom_AllowsBilaterality]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPETemplateSymptom_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPETemplateSymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPETemplateSystem]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPETemplateSystem](
	[RelPETemplateSystemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPETemplateSystem_RelPETemplateSystemUid]  DEFAULT (newid()),
	[RelPETemplateParentSystemUid] [uniqueidentifier] NOT NULL,
	[PESystemUid] [uniqueidentifier] NOT NULL,
	[ColorID] [smallint] NOT NULL CONSTRAINT [DF_RelPETemplateSystem_ColorID]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[AllowsBilaterality] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateSystem_AllowsBilaterality_1]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPETemplateSystem_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPETemplateSystem_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPETemplateSystem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPlanGroupPlanNode]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPlanGroupPlanNode](
	[RelPlanGroupPlanNodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ParentRelPlanGroupPlanNodeUid] [uniqueidentifier] NULL,
	[PlanGroupUid] [uniqueidentifier] NOT NULL,
	[PlanNodeUid] [uniqueidentifier] NOT NULL,
	[NodeLevel] [int] NOT NULL,
	[IsNodeLeaf] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[PreSelected] [bit] NOT NULL,
	[DefaultFlag] [bit] NOT NULL,
	[SnomedDescriptionUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[ClinicCenterOverride] [xml] NULL,
	[ProviderOverride] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsMultiSelect] [bit] NOT NULL,
	[RequiredFlag] [bit] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPlanProviderDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPlanProviderDiagnosis](
	[RelPlanProviderDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PlanGroupUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DefaultValuesXML] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPQRIMeasurePQRIGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPQRIMeasurePQRIGroup](
	[RelPQRIMeasurePQRIGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPQRIMeasurePQRIGroup_RelPQRIMeasurePQRIGroupUid]  DEFAULT (newid()),
	[PQRIGroupUid] [uniqueidentifier] NULL,
	[PQRIMeasureUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPQRIMeasurePQRIGroup_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPQRIMeasurePQRIGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPracticeEligibilityProviderExclude]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPracticeEligibilityProviderExclude](
	[RelPracticeEligibilityProviderExcludeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPracticeEligibilityProviderExclude_RelPracticeEligibilityProviderExcludeUid]  DEFAULT (newid()),
	[PracticeSettingsUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPracticeEligibilityProviderExclude_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPracticeEligibilityServiceType]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPracticeEligibilityServiceType](
	[RelPracticeEligibilityServiceTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PracticeSettingsUid] [uniqueidentifier] NOT NULL,
	[EligibilityServiceTypeUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPracticeFormPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPracticeFormPatient](
	[RelPracticeFormPatientUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PracticeFormUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[EffectiveDate] [datetime] NOT NULL,
	[ExpirationDate] [date] NULL,
	[LastViewedByPortalDate] [datetime] NULL,
	[LastDownloadedByPortalDate] [datetime] NULL,
	[LastUploadedByPortalDate] [datetime] NULL,
	[UploadedAttachmentGroupUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[MessageAAUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPracticeSettingsSuperbillStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPracticeSettingsSuperbillStatus](
	[RelPracticeSettingsSuperbillStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PracticeSettingsUid] [uniqueidentifier] NOT NULL,
	[SuperbillStatusUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPrmRulePrmAction]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPrmRulePrmAction](
	[RelPrmRulePrmActionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RuleAction_RuleActionUid]  DEFAULT (newid()),
	[PrmRuleUid] [uniqueidentifier] NOT NULL,
	[PrmActionUid] [uniqueidentifier] NOT NULL,
	[CaseOrder] [int] NOT NULL CONSTRAINT [DF_RelPrmRulePrmAction_CaseOrder]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPrmRulePrmAction_DisplayOrder]  DEFAULT ((0)),
	[UserDefinedControlParameters] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPrmRulePrmAction_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RuleAction_LastModifiedByDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelPrmRulePrmCondition]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelPrmRulePrmCondition](
	[RelPrmRulePrmConditionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPrmRulePrmCondition_RelPrmRulePrmConditionUid]  DEFAULT (newid()),
	[PrmRuleUid] [uniqueidentifier] NOT NULL,
	[PrmConditionUid] [uniqueidentifier] NOT NULL,
	[UserDefinedControlParameters] [varchar](max) NULL,
	[ConditionValue] [bit] NOT NULL CONSTRAINT [DF_RelPrmRulePrmCondition_ConditionValue]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPrmRulePrmCondition_UserDefined]  DEFAULT ((1)),
	[CaseOrder] [int] NOT NULL CONSTRAINT [DF_RelPrmRulePrmCondition_CaseOrder]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPrmRulePrmCondition_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPrmRulePrmCondition_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProcedureCaseAuthorizationCodeSet]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProcedureCaseAuthorizationCodeSet](
	[RelProcedureCaseAuthorizationCodeSetUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelProcedureCaseAuthorizationCodeSet_RelProcedureCaseAuthorizationCodeSetUid]  DEFAULT (newid()),
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[RelCaseAuthorizationCodeSetUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProcedureCaseAuthorizationCodeSet_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProcedureCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProcedureCategory](
	[RelProcedureCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProcedureCategoryUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProcedureDpn]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProcedureDpn](
	[RelProcedureDpnUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelProcedure_DpnRelProcedureDpnUid]  DEFAULT (newid()),
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[UserDefinedTemplateUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelProcedureDpn_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProcedureDpn_LastModifiedDate]  DEFAULT (getutcdate()),
	[ForResultingProcedures] [bit] NOT NULL CONSTRAINT [DF_RelProcedure_ForResultingProcedures]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProcedureHistoryTermProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProcedureHistoryTermProcedure](
	[RelProcedureHistoryTermProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelProcedureHistoryTermProcedure_RelProcedureHistoryTermProcedureUid]  DEFAULT (newid()),
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[ProcedureHistoryTermUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelProcedureHistoryTermProcedure_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProcedureHistoryTermProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProcedureLaboratoryOrder]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProcedureLaboratoryOrder](
	[RelProcedureLaboratoryOrderUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[LaboratoryOrderUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProcedureLaboratoryOrder_LastModifiedDate]  DEFAULT (getutcdate()),
	[OrderDefaults] [xml] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelProcedureLaboratoryOrder_DisplayOrder]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProcedureLink]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProcedureLink](
	[RelProcedureLinkUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[LinkProcedureUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProcedurePanelProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProcedurePanelProcedure](
	[RelProcedurePanelProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelProcedurePanelProcedure_RelProcedurePanelProcedureUid]  DEFAULT (newid()),
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[ProcedurePanelUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelProcedurePanelProcedure_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelProcedurePanelProcedure_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelProcedurePanelProcedure_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProcedurePanelProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProcedureSetProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProcedureSetProcedure](
	[RelProcedureSetProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[ProcedureInSetUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProcedureTypeofVaccine]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProcedureTypeofVaccine](
	[RelProcedureTypeofVaccineUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelProcedureTypeofVaccine_RelProcedureTypeofVaccineUid]  DEFAULT (newid()),
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[TypeofVaccineUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelProcedureTypeofVaccine_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProcedureTypeofVaccine_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProviderDiagnosisRangePlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProviderDiagnosisRangePlan](
	[RelProviderDiagnosisRangePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DiagnosisRangePlanUid] [uniqueidentifier] NOT NULL,
	[DiagnosisSearchDefinitionUid] [uniqueidentifier] NOT NULL,
	[DpnGroupUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProviderGraphicNoteCCHpi]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProviderGraphicNoteCCHpi](
	[RelProviderGraphicNoteCCHpiUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[GraphicNoteUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProviderGraphicNoteRosPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProviderGraphicNoteRosPE](
	[RelProviderGraphicNoteRosPEUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[GraphicNoteUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProviderIntegrationPartner]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProviderIntegrationPartner](
	[RelProviderIntegrationPartnerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NOT NULL,
	[Identifier] [varchar](255) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProviderMapping]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProviderMapping](
	[RelProviderMappingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[MapToProviderUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProviderMessageRouting]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProviderMessageRouting](
	[ProviderMessageRoutingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[MessageRoutingUid] [uniqueidentifier] NOT NULL,
	[ProviderOverrideXML] [xml] NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProviderPharmacyClearinghouse]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProviderPharmacyClearinghouse](
	[RelProviderPharmacyClearinghouseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelProviderPharmacyClearinghouse_RelProviderPharmacyClearinghouseUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProviderPharmacyClearinghouse_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelProviderSupervisor]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelProviderSupervisor](
	[RelProviderSupervisorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelProviderSupervisor_RelProviderSupervisorUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NULL,
	[SupervisorUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProviderSupervisor_LastModifiedDate]  DEFAULT (getutcdate()),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelProviderSupervisor_DisplayOrder]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelQuestionAnswerSnomed]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelQuestionAnswerSnomed](
	[RelQuestionAnswerSnomedUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelQuestionAnswerSnomed_RelQuestionAnswerSnomedUid]  DEFAULT (newid()),
	[QuestionUid] [uniqueidentifier] NOT NULL,
	[AnswerUid] [uniqueidentifier] NOT NULL,
	[AnswerSnomedDescriptionUid] [uniqueidentifier] NULL,
	[AnswerSnomedConceptID] [varchar](50) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelQuestionAnswerSnomed_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelQuestionAnswerSnomed_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelRecurringAppointmentAppointment]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelRecurringAppointmentAppointment](
	[RelRecurringAppointmentAppointmentUid] [uniqueidentifier] NOT NULL,
	[AppointmentUid] [uniqueidentifier] NOT NULL,
	[RecurringAppointmentUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelReimbursementRuleDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelReimbursementRuleDiagnosis](
	[RelReimbursementRuleDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelReimbursementRuleDiagnosis_RelReimbursementRuleDiagnosisUid]  DEFAULT (newid()),
	[ReimbursementRuleTriggerUid] [uniqueidentifier] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](max) NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelReimbursementRuleDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelReimbursementRuleDiagnosis_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelReimbursementRuleDiagnosis_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelReimbursementRuleDiagnosis_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelReimbursementRuleEnforced]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelReimbursementRuleEnforced](
	[RelReimbursementRuleEnforcedUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelReimbursementRuleEnforced_RelReimbursementRuleEnforcedUid]  DEFAULT (newid()),
	[ReimbursementRuleTriggerUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[LetterModelUid] [uniqueidentifier] NULL,
	[Message] [varchar](1000) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelReimbursementRuleEnforced_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelReimbursementRuleEnforced_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelReimbursementRuleEnforced_Inactive]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelReimbursementRuleLetterModel]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelReimbursementRuleLetterModel](
	[RelReimbursementRuleLetterModelUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelReimbursementRuleLetterModel_RelReimbursementRuleLetterModelUid]  DEFAULT (newid()),
	[ReimbursementRuleTriggerUid] [uniqueidentifier] NOT NULL,
	[LetterModelUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelReimbursementRuleLetterModel_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelReimbursementRuleLetterModel_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelReimbursementRuleLetterModel_Inactive]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelReimbursementRuleProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelReimbursementRuleProcedure](
	[RelReimbursementRuleProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelReimbursementRuleProcedure_RelReimbursementRuleProcedureUid]  DEFAULT (newid()),
	[ReimbursementRuleTriggerUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelReimbursementRuleProcedure_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelReimbursementRuleProcedure_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelReimbursementRuleProcedure_Inactive]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelReportContextReportType]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelReportContextReportType](
	[RelReportContextReportTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table2_RelUserPRMAddInUid]  DEFAULT (newid()),
	[ReportUid] [uniqueidentifier] NOT NULL,
	[ContextReportTypeUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelReportContextReportType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelReportContextReportType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelRosSystemSymptom]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelRosSystemSymptom](
	[RelRosSystemSymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_RelRosSystemSymptomUid]  DEFAULT (newid()),
	[RosSystemUid] [uniqueidentifier] NOT NULL,
	[RosSymptomUid] [uniqueidentifier] NOT NULL,
	[DenyFlag] [bit] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_Inactive]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[ClinicCenterOverride] [xml](CONTENT [KdbOverrideRos]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverrideRos]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelRPNOptionsUserPRM]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelRPNOptionsUserPRM](
	[RelRPNOptionsUserPRMUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelRPNOptionsUserPRM_RelRPNOptionsUserPRMUid]  DEFAULT (newid()),
	[Name] [varchar](50) NOT NULL,
	[RPNOptionsUid] [uniqueidentifier] NOT NULL,
	[UserPrmUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelRPNOptionsUserPRM_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelScheduledEduForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelScheduledEduForm](
	[RelScheduledEduFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ScheduledEduFormUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelScrubItemScrubProfile]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelScrubItemScrubProfile](
	[RelScrubItemScrubProfileUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelScrubItemScrubProfile_RelScrubItemScrubProfileUid]  DEFAULT (newid()),
	[ScrubItemUid] [uniqueidentifier] NULL,
	[ScrubProfileUid] [uniqueidentifier] NULL,
	[ScrubValue] [bit] NOT NULL CONSTRAINT [DF_RelScrubItemScrubProfile_ScrubValue]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelScrubItemScrubProfile_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelScrubItemScrubProfile_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelScrubItemScrubProfile_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelSenderDirectAddress]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelSenderDirectAddress](
	[RelSenderDirectAddressUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[IsDefault] [bit] NOT NULL,
	[RelIntegrationPartnerDirectAddressUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelServiceSiteFaxCoverSheetGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelServiceSiteFaxCoverSheetGroup](
	[RelServiceSiteFaxCoverSheetGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FaxCoverSheetGroupUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelServiceSiteLaboratory]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelServiceSiteLaboratory](
	[RelServiceSiteLaboratoryUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[LaboratoryUid] [uniqueidentifier] NOT NULL,
	[SiteLabId] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelServiceSitePersonWeb]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelServiceSitePersonWeb](
	[RelServiceSitePersonWebUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[Inactive] [smallint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelServiceSiteTaxRate]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelServiceSiteTaxRate](
	[RelServiceSiteTaxRateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[SalesTaxRate] [decimal](18, 3) NULL,
	[HealthcareTaxRate] [decimal](18, 3) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelServiceSiteTypeofVaccineDefault]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelServiceSiteTypeofVaccineDefault](
	[RelServiceSiteTypeofVaccineDefaultUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelServiceSiteTypofVaccineDefault_RelServiceSiteTypeofVaccineDefaultUid]  DEFAULT (newid()),
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[TypeofVaccineDefaultUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelServiceSiteTypofVaccineDefault_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelServiceSiteTypofVaccineDefault_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelSuperbillCombinedServices]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelSuperbillCombinedServices](
	[SuperbillCombinedServicesUid] [uniqueidentifier] NOT NULL,
	[TargetSuperbillUid] [uniqueidentifier] NOT NULL,
	[SourceSuperbillProcedureUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelSurveyAnswerGroupSurveyAnswer]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelSurveyAnswerGroupSurveyAnswer](
	[RelSurveyAnswerGroupSurveyAnswerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__RelSurvey__RelSu__797CF152]  DEFAULT (newid()),
	[SurveyAnswerGroupUid] [uniqueidentifier] NOT NULL,
	[SurveyAnswerUid] [uniqueidentifier] NOT NULL,
	[RequireSurveySectionUid] [uniqueidentifier] NULL,
	[NextSurveyQuestionUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF__RelSurvey__Displ__7E41A66F]  DEFAULT ((0)),
	[RequireExplanation] [bit] NOT NULL CONSTRAINT [DF__RelSurvey__Requi__7F35CAA8]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelSurveyAnswerGroupSurveyAnswer_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__RelSurvey__LastM__0029EEE1]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelSurveyAnswerGroupSurveyQuestion]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelSurveyAnswerGroupSurveyQuestion](
	[RelSurveyAnswerGroupSurveyQuestionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelSurveyAnswerGroupSurveyQuestion_RelSurveyAnswerGroupSurveyQuestionUid]  DEFAULT (newid()),
	[RelSurveyAnswerGroupSurveyAnswerUid] [uniqueidentifier] NOT NULL,
	[SurveyQuestionUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF__RelSurvey__UserD__6E118473]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__RelSurvey__LastM__6F05A8AC]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelSurveyPatient]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelSurveyPatient](
	[RelSurveyPatientUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__RelSurvey__RelSu__5FBD1F4F]  DEFAULT (newid()),
	[SurveyUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[EffectiveDate] [datetime] NOT NULL CONSTRAINT [DF__RelSurvey__Effec__62998BFA]  DEFAULT (getutcdate()),
	[ExpirationDate] [date] NULL,
	[CompletionDate] [date] NULL,
	[OneTime] [bit] NOT NULL CONSTRAINT [DF__RelSurvey__OneTi__638DB033]  DEFAULT ((0)),
	[Completed] [bit] NOT NULL CONSTRAINT [DF__RelSurvey__Compl__6481D46C]  DEFAULT ((0)),
	[Imported] [bit] NOT NULL CONSTRAINT [DF_RelSurveyPatient_Imported]  DEFAULT ((0)),
	[ResponseXML] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__RelSurvey__LastM__6575F8A5]  DEFAULT (getutcdate()),
	[LastModifiedByPatientDate] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelSurveySectionSurveyQuestion]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelSurveySectionSurveyQuestion](
	[RelSurveySectionSurveyQuestionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__RelSurvey__RelSu__71DBCF8A]  DEFAULT (newid()),
	[SurveySectionUid] [uniqueidentifier] NOT NULL,
	[SurveyQuestionUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF__RelSurvey__Displ__74B83C35]  DEFAULT ((0)),
	[QuestionOptional] [bit] NOT NULL CONSTRAINT [DF_RelSurveySectionSurveyQuestion_RelSurveySectionSurveyQuestion]  DEFAULT ((0)),
	[RequireAnswer] [bit] NOT NULL CONSTRAINT [DF_RelSurveySectionSurveyQuestion_]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelSurveySectionSurveyQuestion_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__RelSurvey__LastM__75AC606E]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelSurveySurveySection]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelSurveySurveySection](
	[RelSurveySurveySectionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__RelSurvey__RelSu__69468989]  DEFAULT (newid()),
	[SurveyUid] [uniqueidentifier] NOT NULL,
	[SurveySectionUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF__RelSurvey__Displ__6C22F634]  DEFAULT ((0)),
	[SectionOptional] [bit] NOT NULL CONSTRAINT [DF__RelSurvey__Secti__6D171A6D]  DEFAULT ((0)),
	[IsDependentSection] [bit] NOT NULL CONSTRAINT [DF_RelSurveySurveySection_IsDependentSection]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelSurveySurveySection_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__RelSurvey__LastM__6E0B3EA6]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelTypeofVaccineServiceSite]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelTypeofVaccineServiceSite](
	[TypeofVaccineServiceSiteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[TypeofVaccineUid] [uniqueidentifier] NOT NULL,
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelTypeofVaccineServiceSiteInfo]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelTypeofVaccineServiceSiteInfo](
	[TypeofVaccineServiceSiteInfoUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[TypeofVaccineServiceSiteUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelTypeofVaccineTypeofVaccineElement]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelTypeofVaccineTypeofVaccineElement](
	[RelTypeofVaccineTypeofVaccineElementUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelTypeofVaccineTypeofVaccineElement_RelTypeofVaccineTypeofVaccineElementUid]  DEFAULT (newid()),
	[VaccineUid] [uniqueidentifier] NULL,
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[TypeofVaccineElementUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelTypeofVaccineTypeofVaccineElement_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelTypeofVaccineTypeofVaccineElement_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelTypeofVaccineTypeofVaccineElement_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelUserPatientCenter]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelUserPatientCenter](
	[UserPatientCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[PatientCenterUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelUserPRMDesktopControl]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelUserPRMDesktopControl](
	[RelUserPRMDesktopControlUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table2_RelUserDesktop]  DEFAULT (newid()),
	[UserPrmUid] [uniqueidentifier] NOT NULL,
	[PrimaryDesktopControlUid] [uniqueidentifier] NOT NULL,
	[PrimaryRefreshInterval] [int] NOT NULL CONSTRAINT [DF_RelUserPRMDesktopControl_PrimaryRefreshInterval]  DEFAULT ((0)),
	[PrimaryData] [varchar](8000) NULL,
	[SecondaryDesktopControlUid] [uniqueidentifier] NULL,
	[SecondaryRefreshInterval] [int] NOT NULL CONSTRAINT [DF_RelUserPRMDesktopControl_SecondaryRefreshInterval]  DEFAULT ((0)),
	[SecondaryData] [varchar](8000) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelUserPRMDesktopControl_DisplayOrder]  DEFAULT ((0)),
	[ColumnNumber] [int] NOT NULL CONSTRAINT [DF_RelUserPRMDesktopControl_ColumnNumber]  DEFAULT ((1)),
	[Height] [int] NULL CONSTRAINT [DF_RelUserPRMDesktopControl_Height]  DEFAULT ((200)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelUserPRMDesktopControl_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelVaccineAdminClinicCenter]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelVaccineAdminClinicCenter](
	[RelVaccineAdminClinicCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelVaccineAdminClinicCenter_RelVaccineAdminClinicCenterUid]  DEFAULT (newid()),
	[VaccineAdminUid] [uniqueidentifier] NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelVaccineAdminClinicCenter_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelVaccineAdminClinicCenter_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelVaccineDisplayCols]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelVaccineDisplayCols](
	[RelVaccineDisplayColsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelVaccineDisplayCols_RelVaccineDisplayColsUid]  DEFAULT (newid()),
	[DisplayColsUid] [uniqueidentifier] NULL,
	[VaccineAdminUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelVaccineDisplayCols_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelVaccineDisplayCols_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelVaccineDisplayCols_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelVaccinePrintCols]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelVaccinePrintCols](
	[RelVaccinePrintColsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelVaccinePrintCols_RelVaccinePrintColsUid]  DEFAULT (newid()),
	[PrintColsUid] [uniqueidentifier] NULL,
	[VaccineAdminUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelVaccinePrintCols_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelVaccinePrintCols_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelVaccinePrintCols_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelVaccineTypeofVaccine]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelVaccineTypeofVaccine](
	[RelVaccineTypeofVaccineUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelVaccineTypeofVaccine_RelVaccineTypeofVaccineUid]  DEFAULT (newid()),
	[VaccineUid] [uniqueidentifier] NOT NULL,
	[TypeofVaccineUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelVaccineTypeofVaccine_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelVaccineTypeofVaccine_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelVaccineTypeofVaccine_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelVisitConfidentialNoteAccess]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelVisitConfidentialNoteAccess](
	[RelVisitConfidentialNoteAccessUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelVisitConfidentialNoteAccess_RelVisitConfidentialNoteAccessUid]  DEFAULT (newid()),
	[VisitCommentExtensionUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[UserPRMUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelVisitConfidentialNoteAccess_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelVisitMedication]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelVisitMedication](
	[RelVisitMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelVisitMedication_RelVisitMedicationUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[eRxStatusUid] [uniqueidentifier] NULL,
	[eRxEligibilityDownLoadDate] [datetime] NULL,
	[ReadyToPrescribe] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_ReadyToPrescribe]  DEFAULT ((0)),
	[Prescribed] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_MarkAsPrescribed]  DEFAULT ((0)),
	[ConsentCreated] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_ConsentCreated]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[ReprintReason] [varchar](max) NULL,
	[eRxRequest] [xml](CONTENT [eRxRequestXML]) NULL,
	[PreviousData] [xml](CONTENT [PreviousData]) NULL,
	[DigitalSignatureXML] [xml] NULL,
	[FormularyXML] [xml](CONTENT [FormularyData]) NULL,
	[FulfillmentMethod] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_FulfillmentMethod]  DEFAULT ((0)),
	[FulfillmentDateTime] [datetime] NULL,
	[FulfillmentSequentialNumber] [int] NULL,
	[ScriptSave] [bit] NULL CONSTRAINT [DF_RelVisitMedication_ScriptSave]  DEFAULT ((0)),
	[ePAStatus] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_ePASentRequest]  DEFAULT ((0)),
	[ePAMessageID] [varchar](50) NULL,
	[ePAResults] [varchar](max) NULL,
	[SpoStatus] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_SpoStatus]  DEFAULT ((0)),
	[SpoRequest] [varchar](max) NULL,
	[SpoResponse] [varchar](max) NULL,
	[Status] [tinyint] NOT NULL CONSTRAINT [DF_RelVisitMedication_Status]  DEFAULT ((0)),
	[StatusMessage] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelVisitMedication_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelVisitSuperbillGeneration]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelVisitSuperbillGeneration](
	[VisitSuperbillGenerationUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[SuperbillStatusMap] [varchar](2000) NULL,
	[GenerationStatus] [smallint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RelWaitingListWaitingListDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [RelWaitingListWaitingListDetail](
	[RelWaitingListWaitingListDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelWaitingListWaitingListDetail_RelWaitingListWaitingListDetailUid]  DEFAULT (newid()),
	[WaitingListUid] [uniqueidentifier] NULL,
	[WaitingListDetailUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelWaitingListWaitingListDetail_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Remark]') AND type in (N'U'))
BEGIN
CREATE TABLE [Remark](
	[RemarkUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Remarks_RemarkUid]  DEFAULT (newid()),
	[OwnerUid] [uniqueidentifier] NOT NULL,
	[OwnerType] [varchar](255) NOT NULL,
	[RemarkTypeUid] [uniqueidentifier] NOT NULL,
	[RemarkCategoryUid] [uniqueidentifier] NULL,
	[Message] [varchar](max) NULL,
	[Status] [int] NULL CONSTRAINT [DF_Remark_Status]  DEFAULT ((1)),
	[LastView] [datetime] NULL,
	[LastViewUserUid] [uniqueidentifier] NULL,
	[DismissDateTime] [datetime] NULL CONSTRAINT [DF_Remark_DismissDate]  DEFAULT (getutcdate()),
	[DismissByUid] [uniqueidentifier] NULL,
	[Owner2Uid] [uniqueidentifier] NULL,
	[Owner2Type] [varchar](255) NULL,
	[SchedulingType] [bit] NOT NULL CONSTRAINT [DF_Remark_SystemType]  DEFAULT ((0)),
	[BillingType] [bit] NOT NULL CONSTRAINT [DF_Remark_BillingType]  DEFAULT ((0)),
	[ClinicalType] [bit] NOT NULL CONSTRAINT [DF_Remark_ClinicalType]  DEFAULT ((0)),
	[DemographicType] [bit] NOT NULL CONSTRAINT [DF_Remark_DemographicType]  DEFAULT ((0)),
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Remark_Inactive]  DEFAULT ((0)),
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_Remarks_CreatedDate]  DEFAULT (getutcdate()),
	[CreatedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Remarks_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RemarkCategory]') AND type in (N'U'))
BEGIN
CREATE TABLE [RemarkCategory](
	[RemarkCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RemarkCategory_RemarkCategoryUid]  DEFAULT (newid()),
	[RemarkCategory] [varchar](25) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RemarkCategory_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RemarkCategory_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RemarkType]') AND type in (N'U'))
BEGIN
CREATE TABLE [RemarkType](
	[RemarkTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RemarkType_RemarkTypeUid]  DEFAULT (newid()),
	[RemarkType] [varchar](25) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RemarkType_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RemarkType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ReplicationConflictMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [ReplicationConflictMessage](
	[ReplicationConflictMessageUid] [uniqueidentifier] NOT NULL,
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[MasterServer] [varchar](255) NOT NULL,
	[TransferDirection] [bit] NOT NULL,
	[TableName] [varchar](255) NOT NULL,
	[ObjectUid] [uniqueidentifier] NULL,
	[ConflictDetailXML] [xml] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ReplicationFilter]') AND type in (N'U'))
BEGIN
CREATE TABLE [ReplicationFilter](
	[ReplicationFilterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[TableName] [varchar](256) NOT NULL,
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[PurgeDate] [dbo].[PRMDateTimeUnconverted] NULL,
	[EMRAdminTable] [bit] NOT NULL,
	[Priority] [int] NOT NULL,
	[LastSyncDate] [dbo].[PRMDateTimeUnconverted] NOT NULL,
	[LastSyncReceivedAnchor] [bigint] NOT NULL,
	[LastPurgeSyncReceivedAnchor] [bigint] NULL,
	[SyncDate] [dbo].[PRMDateTimeUnconverted] NULL,
	[SyncReceivedAnchor] [bigint] NULL,
	[LastExternalSyncDate] [dbo].[PRMDateTimeUnconverted] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ReplicationHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [ReplicationHistory](
	[ReplicationHistoryUid] [uniqueidentifier] NOT NULL,
	[EventDescription] [varchar](max) NOT NULL,
	[EventType] [int] NOT NULL,
	[ObjectUid] [uniqueidentifier] NULL,
	[TableName] [varchar](256) NULL,
	[OldLastSyncDate] [datetime] NULL,
	[NewLastSyncDate] [datetime] NULL,
	[OldLastSyncReceivedAnchor] [bigint] NULL,
	[NewLastSyncReceivedAnchor] [bigint] NULL,
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ReplicationQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ReplicationQueue](
	[ReplicationQueueUid] [uniqueidentifier] NULL,
	[Sequence] [bigint] IDENTITY(1,1) NOT NULL,
	[Action] [int] NOT NULL,
	[TableName] [varchar](256) NOT NULL,
	[LastCopiedObject] [varchar](256) NULL,
	[CacheMachineUid] [uniqueidentifier] NOT NULL,
	[ChangeDate] [dbo].[PRMDateTimeUnconverted] NOT NULL,
	[Status] [int] NOT NULL,
	[ObjectUid] [uniqueidentifier] NULL,
	[MergeNewObjectUid] [uniqueidentifier] NULL,
	[MergeOriginalName] [varchar](256) NULL,
	[MergeNewName] [varchar](256) NULL,
	[LastCopiedObjectSyncReceivedAnchor] [bigint] NULL,
	[LastCopiedObjectModifiedDate] [dbo].[PRMDateTimeUnconverted] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ReplicationSettings]') AND type in (N'U'))
BEGIN
CREATE TABLE [ReplicationSettings](
	[ReplicationSettingsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ReplicationSettings_ReplicationSettingsUid]  DEFAULT (newid()),
	[Name] [varchar](250) NOT NULL,
	[StringValue] [varchar](max) NULL,
	[GuidValue] [uniqueidentifier] NULL,
	[BoolValue] [bit] NULL,
	[IntegerValue] [int] NULL,
	[DateTimeValue] [datetime] NULL,
	[DecimalValue] [decimal](18, 0) NULL,
	[RealValue] [real] NULL,
	[BinaryValue] [varbinary](max) NULL,
	[XMLValue] [xml] NULL,
	[BigIntValue] [bigint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ReplicationSettings_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ReplicationSettings_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ReplicationSettings_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ReplicationStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [ReplicationStatus](
	[ReplicationStatusUid] [uniqueidentifier] NOT NULL,
	[InitialReplicationCompletedDate] [datetime] NULL,
	[LogonAt] [datetime] NULL,
	[ConnectionStatus] [varchar](max) NULL,
	[UploadStartAt] [datetime] NULL,
	[PatientsToUpload] [int] NULL,
	[MessagesToUpload] [int] NULL,
	[UploadPending] [int] NULL,
	[UploadFailures] [int] NULL,
	[UploadFailureDetail] [xml] NULL,
	[UploadTotal] [int] NULL,
	[UploadTableInProgress] [varchar](255) NULL,
	[LastCopiedObjectInUploadTableInProgress] [varchar](256) NULL,
	[UploadStatus] [varchar](max) NULL,
	[UploadProgressXML] [xml] NULL,
	[LastUploadCompletedFailures] [int] NULL,
	[LastUploadCompletedDate] [datetime] NULL,
	[DownloadStartAt] [datetime] NULL,
	[PatientsToDownload] [int] NULL,
	[MessagesToDownload] [int] NULL,
	[DownloadPending] [int] NULL,
	[DownloadFailures] [int] NULL,
	[DownloadFailureDetail] [xml] NULL,
	[DownloadTotal] [int] NULL,
	[DownloadTableInProgress] [varchar](255) NULL,
	[LastCopiedObjectInDownloadTableInProgress] [varchar](256) NULL,
	[DownloadStatus] [varchar](max) NULL,
	[DownloadProgressXML] [xml] NULL,
	[LastDownloadCompletedFailures] [int] NULL,
	[LastDownloadCompletedDate] [datetime] NULL,
	[MasterServerURI] [varchar](1024) NULL,
	[CacheServerURI] [varchar](1024) NULL,
	[ServerConfigXML] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RosSystem]') AND type in (N'U'))
BEGIN
CREATE TABLE [RosSystem](
	[RosSystemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RosSystem_DisplayOrder]  DEFAULT ((0)),
	[SystemDisplayOrder] [int] NOT NULL CONSTRAINT [DF_RosSystem_SystemDisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RosSystem_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RosSystem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RVUSchedule]') AND type in (N'U'))
BEGIN
CREATE TABLE [RVUSchedule](
	[RVUScheduleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[ConversionFactor] [money] NOT NULL,
	[WorkGPCI] [decimal](5, 3) NOT NULL,
	[PEGPCI] [decimal](5, 3) NOT NULL,
	[MPGPCI] [decimal](5, 3) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[RVUScheduleValue]') AND type in (N'U'))
BEGIN
CREATE TABLE [RVUScheduleValue](
	[RVUScheduleValueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RVUScheduleUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[WorkRVU] [decimal](5, 2) NOT NULL,
	[RBNonFacilityPERVU] [decimal](5, 2) NOT NULL,
	[RBFacilityPERVU] [decimal](5, 2) NOT NULL,
	[MPRVU] [decimal](5, 2) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ProcConversionFactor] [money] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ScantronDemographicsSurvey]') AND type in (N'U'))
BEGIN
CREATE TABLE [ScantronDemographicsSurvey](
	[ScantronDemographicsSurveyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ScantronDemographicsSurvey_ScantronDemographicsSurveyUid]  DEFAULT (newid()),
	[Prefix] [varchar](50) NULL,
	[FirstName] [varchar](50) NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NULL,
	[Suffix] [varchar](50) NULL,
	[Address1Line1] [varchar](50) NULL,
	[Address1Line2] [varchar](50) NULL,
	[Address1City] [varchar](50) NULL,
	[Address1State] [varchar](50) NULL,
	[Address1Zip] [varchar](50) NULL,
	[Address1Country] [varchar](50) NULL,
	[Address2Line1] [varchar](50) NULL,
	[Address2Line2] [varchar](50) NULL,
	[Address2City] [varchar](50) NULL,
	[Address2State] [varchar](50) NULL,
	[Address2Zip] [varchar](50) NULL,
	[Address2Country] [varchar](50) NULL,
	[MaritalStatus] [varchar](50) NULL,
	[Phone1Number] [varchar](50) NULL,
	[Phone2Number] [varchar](50) NULL,
	[Phone3Number] [varchar](50) NULL,
	[Phone4Number] [varchar](50) NULL,
	[Phone2Type] [varchar](50) NULL,
	[Phone3Type] [varchar](50) NULL,
	[Phone4Type] [varchar](50) NULL,
	[Phone1Type] [varchar](50) NULL,
	[Email1] [varchar](50) NULL,
	[Email2] [varchar](50) NULL,
	[Language] [varchar](50) NULL,
	[Gender] [varchar](50) NULL,
	[Race] [varchar](50) NULL,
	[Ethnicity] [varchar](50) NULL,
	[Hispanic] [varchar](50) NULL,
	[Birthdate] [varchar](50) NULL,
	[Deathdate] [varchar](50) NULL,
	[AkaFirstName] [varchar](50) NULL,
	[AkaLastName] [varchar](50) NULL,
	[SocialSecurityNumber] [varchar](50) NULL,
	[DriverLicenseNumber] [varchar](50) NULL,
	[DriverLicenseState] [varchar](50) NULL,
	[DominantHand] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ScantronDemographicsSurvey_UserDefined_1]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ScantronDemographicsSurvey_LastModifiedDate_1]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ScheduledEduForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [ScheduledEduForm](
	[ScheduledEduFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[EduFormUid] [uniqueidentifier] NOT NULL,
	[DisbursementDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ScheduledPQRIUpdate]') AND type in (N'U'))
BEGIN
CREATE TABLE [ScheduledPQRIUpdate](
	[ScheduledPQRIUpdateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ScheduledPQRIUpdate_ScheduledPQRIUpdateUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PQRIGroupUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ScheduledPQRIUpdate_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SecurityUserGroup]') AND type in (N'U'))
BEGIN
CREATE TABLE [SecurityUserGroup](
	[SecurityUserGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SecurityUserGroup_SecurityUserGroupUid]  DEFAULT (newid()),
	[SecurityUid] [uniqueidentifier] NOT NULL,
	[ParentObjectUid] [uniqueidentifier] NULL,
	[ObjectName] [varchar](50) NOT NULL,
	[ObjectUid] [uniqueidentifier] NOT NULL,
	[UserPRMUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[Permission] [int] NOT NULL CONSTRAINT [DF_SecurityUserGroup_Permission]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_SecurityUserGroup_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SecurityUserGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SeedTable]') AND type in (N'U'))
BEGIN
CREATE TABLE [SeedTable](
	[SeedTableUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SeedTable_SeedTableUid]  DEFAULT (newid()),
	[SeedName] [varchar](80) NULL,
	[SeedValue] [bigint] NULL CONSTRAINT [DF_SeedTable_SeedValue]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SeedTable_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SIGDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [SIGDetail](
	[SIGDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SIGDetail_SIGDetailUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NULL,
	[DispensableUid] [uniqueidentifier] NULL,
	[DosageQuantity] [varchar](60) NULL,
	[DosageUnit] [varchar](60) NULL,
	[Frequency] [varchar](255) NULL,
	[Quantity] [varchar](11) NULL,
	[ItemStartDate] [date] NULL,
	[ItemStopDate] [date] NULL,
	[Duration] [smallint] NULL,
	[Comment] [varchar](max) NULL,
	[SIGComment] [varchar](255) NULL,
	[InternalNote] [varchar](255) NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_SIGDetail_DisplayOrder]  DEFAULT ((0)),
	[Direction] [varchar](max) NULL,
	[SIGText] [varchar](max) NULL,
	[XML_SIG] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SIGDetail_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_SIGDetail_UserDefined]  DEFAULT ((1))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SMSReplyHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [SMSReplyHistory](
	[SMSReplyHistoryUid] [uniqueidentifier] NOT NULL,
	[ListenerAqn] [varchar](512) NULL,
	[ListenerArgs] [varchar](max) NULL,
	[ToCountry] [varchar](32) NULL,
	[ToState] [varchar](5) NULL,
	[SmsMessageSid] [varchar](34) NULL,
	[NumMedia] [smallint] NOT NULL,
	[ToCity] [varchar](32) NULL,
	[FromZip] [varchar](32) NULL,
	[SmsSid] [varchar](34) NULL,
	[FromState] [varchar](32) NULL,
	[SmsStatus] [varchar](32) NULL,
	[FromCity] [varchar](32) NULL,
	[Body] [varchar](max) NULL,
	[FromCountry] [varchar](32) NULL,
	[ToNumber] [varchar](32) NULL,
	[ToZip] [varchar](32) NULL,
	[NumSegments] [smallint] NOT NULL,
	[MessageSid] [varchar](34) NULL,
	[AccountSid] [varchar](34) NULL,
	[FromNumber] [varchar](32) NULL,
	[ApiVersion] [varchar](32) NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SMSSendHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [SMSSendHistory](
	[SMSSendHistoryUid] [uniqueidentifier] NOT NULL,
	[ListenerAqn] [varchar](512) NULL,
	[ListenerArgs] [varchar](max) NULL,
	[sid] [varchar](34) NULL,
	[account_sid] [varchar](34) NULL,
	[ToNumber] [varchar](32) NOT NULL,
	[FromNumber] [varchar](32) NOT NULL,
	[messaging_service_sid] [varchar](32) NULL,
	[body] [varchar](max) NOT NULL,
	[status] [varchar](100) NULL,
	[num_segments] [int] NOT NULL,
	[num_media] [int] NULL,
	[direction] [varchar](100) NULL,
	[version] [varchar](100) NULL,
	[error_code] [varchar](100) NULL,
	[error_message] [varchar](255) NULL,
	[uri] [varchar](255) NULL,
	[subresource_uris] [varchar](255) NULL,
	[date_created] [datetime] NOT NULL,
	[date_sent] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SpecialtyCpp]') AND type in (N'U'))
BEGIN
CREATE TABLE [SpecialtyCpp](
	[SpecialtyCppUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SpecialtyCpp_SpecialtyCppUid]  DEFAULT (newid()),
	[SpecialtyUid] [uniqueidentifier] NULL,
	[CppUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_SpecialtyCpp_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_SpecialtyCpp_Inactive]  DEFAULT ((0)),
	[Hide] [bit] NOT NULL CONSTRAINT [DF_SpecialtyCpp_Hide]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_SpecialtyCpp_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SpecialtyCpp_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[StatementAction]') AND type in (N'U'))
BEGIN
CREATE TABLE [StatementAction](
	[StatementActionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_StatementAction_StatementActionUid]  DEFAULT (newid()),
	[Name] [varchar](50) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_StatementAction_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_StatementAction_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[StatementBatch]') AND type in (N'U'))
BEGIN
CREATE TABLE [StatementBatch](
	[StatementBatchUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_StatementBatch_StatementBatchUid]  DEFAULT (newid()),
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[StatementActionUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_StatementBatch_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[StatementBatchDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [StatementBatchDetail](
	[StatementBatchDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_StatementBatchDetail_StatementBatchDetailUid]  DEFAULT (newid()),
	[StatementBatchUid] [uniqueidentifier] NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[DunningLevel] [smallint] NOT NULL CONSTRAINT [DF_StatementBatchDetail_DunningLevel]  DEFAULT ((0)),
	[AccessCode] [varchar](25) NULL,
	[StatementXml] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_StatementBatchDetail_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[AttachmentUid] [uniqueidentifier] NULL,
	[StatementDate] [date] NULL,
	[CompletionStatus] [smallint] NOT NULL CONSTRAINT [DF_StatementBatchDetail_CompletionStatus]  DEFAULT ((0)),
	[OnDemand] [smallint] NOT NULL CONSTRAINT [DF_StatementBatchDetail_OnDemand]  DEFAULT ((0)),
	[FirstViewed] [datetime] NULL,
	[LastViewed] [datetime] NULL,
	[StatementXmlDate] [date] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[StatementBatchDetailSuperbill]') AND type in (N'U'))
BEGIN
CREATE TABLE [StatementBatchDetailSuperbill](
	[StatementBatchDetailSuperbillUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_StatementBatchDetailSuperbill_StatementBatchDetailSuperbillUid]  DEFAULT (newid()),
	[StatementBatchDetailUid] [uniqueidentifier] NOT NULL,
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[InsuranceBalance] [money] NULL,
	[PatientBalance] [money] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_StatementBatchDetailSuperbill_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[StatsClientPerformance]') AND type in (N'U'))
BEGIN
CREATE TABLE [StatsClientPerformance](
	[StatsClientPerformanceUid] [uniqueidentifier] NOT NULL,
	[Client] [varchar](255) NOT NULL,
	[FormName] [varchar](100) NOT NULL,
	[ControlName] [varchar](100) NULL,
	[FunctionName] [varchar](100) NOT NULL,
	[Duration] [int] NOT NULL,
	[TotalDuration] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SubFindTable]') AND type in (N'U'))
BEGIN
CREATE TABLE [SubFindTable](
	[SubFindTableUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SubFindTable_SubFindTableUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_SubFindTable_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[FindTableUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_SubFindTable_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SubFindTable_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SubFindTableItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [SubFindTableItem](
	[SubFindTableItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SubFindTableItem_SubFindTableItemUid]  DEFAULT (newid()),
	[SubFindTableUid] [uniqueidentifier] NOT NULL,
	[ItemUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_SubFindTableItem_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SubFindTableItem_LastModifiedDate]  DEFAULT (getutcdate()),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_SubFindTableItem_DisplayOrder]  DEFAULT ((0))
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Superbill]') AND type in (N'U'))
BEGIN
CREATE TABLE [Superbill](
	[SuperbillUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Superbill_SuperbillUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[AccountUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[AppointmentUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[SuperbillStatusUid] [uniqueidentifier] NOT NULL,
	[CurrentCarrierOverride] [int] NULL,
	[ServiceDateStart] [date] NOT NULL,
	[ServiceDateEnd] [date] NOT NULL,
	[DefaultRenderingProviderUid] [uniqueidentifier] NULL,
	[DefaultClaimingProviderUid] [uniqueidentifier] NULL,
	[ProviderCareTypeUid] [uniqueidentifier] NULL,
	[ReferringProviderUid] [uniqueidentifier] NULL,
	[ReferringDate] [date] NULL,
	[DefaultServiceSiteUid] [uniqueidentifier] NULL,
	[DefaultFinancialCenterUid] [uniqueidentifier] NULL,
	[PriorAuthorizationCode] [varchar](30) NULL,
	[RelatedCauseUid] [uniqueidentifier] NULL,
	[RelatedCauseState] [char](2) NULL,
	[RelatedCauseDate] [date] NULL,
	[OnsetDate] [date] NULL,
	[OnsetFirstDate] [datetime] NULL,
	[NoWorkFromDate] [date] NULL,
	[NoWorkToDate] [date] NULL,
	[HospitalizationStartDate] [date] NULL,
	[HospitalizationEndDate] [date] NULL,
	[EPSDT] [bit] NOT NULL CONSTRAINT [DF_Superbill_EPSDT]  DEFAULT ((0)),
	[Emergency] [bit] NOT NULL CONSTRAINT [DF_Superbill_Emergency]  DEFAULT ((0)),
	[COB] [char](3) NULL CONSTRAINT [DF_Superbill_COB]  DEFAULT (''),
	[ClaimNote] [varchar](max) NULL,
	[ClaimPaper] [bit] NOT NULL CONSTRAINT [DF_Superbill_ClaimPaper]  DEFAULT ((0)),
	[SBReleaseMedicalRecords] [bit] NOT NULL CONSTRAINT [DF__Superbill__SBRel__58F12BAE]  DEFAULT ((0)),
	[AlertCodeResync] [bit] NOT NULL CONSTRAINT [DF__Superbill__Alert__59E54FE7]  DEFAULT ((0)),
	[ParentSuperbillUid] [uniqueidentifier] NULL,
	[UsePersonInsuranceAuthorizeAssignment] [bit] NOT NULL CONSTRAINT [DF_Superbill_UsePersonInsuranceAuthorizeAssignment ]  DEFAULT ((1)),
	[AuthorizeAssignment] [bit] NOT NULL CONSTRAINT [DF_Superbill_AuthorizeAssignment]  DEFAULT ((1)),
	[UsePrimaryPayerAcceptAssignment] [bit] NOT NULL CONSTRAINT [DF_Superbill_UsePrimaryPayerAcceptAssignment]  DEFAULT ((1)),
	[AcceptAssignmentLabOnly] [bit] NOT NULL CONSTRAINT [DF_Superbill_AcceptAssignmentLabOnly]  DEFAULT ((0)),
	[AcceptAssignment] [bit] NOT NULL CONSTRAINT [DF_Superbill_AcceptAssignment]  DEFAULT ((1)),
	[ExcludeFromAutomatedCollections] [bit] NOT NULL CONSTRAINT [DF_Superbill_ExcludeFromAutomatedCollection]  DEFAULT ((0)),
	[DateEnteredAutomatedCollections] [date] NULL,
	[DateLeftAutomatedCollections] [datetime] NULL,
	[EnteringCollectionsPatientBalance] [money] NOT NULL CONSTRAINT [DF_Superbill_EnteringCollectionsPatientBalance]  DEFAULT ((0)),
	[ABN] [bit] NOT NULL CONSTRAINT [DF_Superbill_ABN]  DEFAULT ((0)),
	[ARBatchUid] [uniqueidentifier] NULL,
	[PriorAuthorizationCode_InsuranceCarrier2] [varchar](50) NULL,
	[PriorAuthorizationCode_InsuranceCarrier3] [varchar](50) NULL,
	[ResubmissionCode] [varchar](50) NULL,
	[EmergencyIndicatorUid] [uniqueidentifier] NULL,
	[LMPDate] [date] NULL,
	[EstimatedDateOfBirth] [date] NULL,
	[DateLastSeenBySupervising] [date] NULL,
	[InitialTreatmentDate] [date] NULL,
	[FamilyPlanning] [bit] NOT NULL CONSTRAINT [DF_Superbill_FamilyPlanning]  DEFAULT ((0)),
	[DelayReasonUid] [uniqueidentifier] NULL,
	[EPSDTReferralCondIndicator1Uid] [uniqueidentifier] NULL,
	[EPSDTReferralCondIndicator2Uid] [uniqueidentifier] NULL,
	[EPSDTReferralCondIndicator3Uid] [uniqueidentifier] NULL,
	[EPSDTReferralCondIndicator4Uid] [uniqueidentifier] NULL,
	[ClaimHeaderNoteCodeUid] [uniqueidentifier] NULL,
	[Box10dNote] [varchar](max) NULL,
	[ManuallySetFeeAllowedSchedulePeriod] [bit] NOT NULL CONSTRAINT [DF_Superbill_ManuallySetFeeAllowedSchedulePeriod]  DEFAULT ((0)),
	[FeeSchedulePeriodUid] [uniqueidentifier] NULL,
	[AmountAllowedSchedulePeriodUid] [uniqueidentifier] NULL,
	[AmountAllowedAutoWriteoffOvercharge] [bit] NOT NULL CONSTRAINT [DF_Superbill_AmountAllowedAutoWriteoffOvercharge]  DEFAULT ((0)),
	[PayorPlanSetUid] [uniqueidentifier] NULL,
	[TypeOfBill] [varchar](5) NULL,
	[AuthReferralIndicator] [bit] NOT NULL CONSTRAINT [DF_Superbill_AuthReferralIndicator]  DEFAULT ((1)),
	[DateLastSeen] [date] NULL,
	[UserDefinedXml] [xml] NULL,
	[ReferralSrcUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Superbill_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[OnsetFirstQualifierUid] [uniqueidentifier] NULL,
	[OrderingProviderUid] [uniqueidentifier] NULL,
	[Box17ProviderUid] [uniqueidentifier] NULL,
	[PaperworkTypeUid] [uniqueidentifier] NULL,
	[PaperworkTransmissionCodeUid] [uniqueidentifier] NULL,
	[PaperworkControlNum] [varchar](50) NULL,
	[DFTQueuedDateTime] [datetime] NULL,
	[FinancialNoteUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SuperbillAggregate]') AND type in (N'U'))
BEGIN
CREATE TABLE [SuperbillAggregate](
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NULL CONSTRAINT [DF_SuperbillAggregate_Inactive]  DEFAULT ((0)),
	[FirstFiledDate] [date] NULL,
	[LastFiledDate] [date] NULL,
	[CodeValidationErrors] [bit] NOT NULL CONSTRAINT [DF_SuperbillAggregate_CodeValidationErrors]  DEFAULT ((0)),
	[IsPosted] [bit] NOT NULL CONSTRAINT [DF_SuperbillAggregate_IsPosted]  DEFAULT ((0)),
	[AccountPeriodUid] [uniqueidentifier] NULL,
	[PrimaryInsurancePlanUid] [uniqueidentifier] NULL,
	[CurrentInsurancePlanUid] [uniqueidentifier] NULL,
	[LiabilityOwner] [int] NULL CONSTRAINT [DF_SuperbillAggregate_LiabilityOwner]  DEFAULT ((0)),
	[CurrentLiabilityOwner] [int] NULL,
	[CurrentCarrier] [int] NULL,
	[LastPatientPaymentDate] [date] NULL,
	[LastPatientPaymentAmount] [money] NULL,
	[LastInsurancePaymentCarrierUid] [uniqueidentifier] NULL,
	[LastInsurancePaymentDate] [date] NULL,
	[LastInsurancePaymentAmount] [money] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[ClaimingProviderUid] [uniqueidentifier] NULL,
	[RenderingProviderUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SuperbillAggregate_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SuperbillDental]') AND type in (N'U'))
BEGIN
CREATE TABLE [SuperbillDental](
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[DSeriesFirstDate] [date] NULL,
	[DOrthodonticTreatment] [bit] NOT NULL CONSTRAINT [DF_SuperbillDental_DOrthodonticTreatment]  DEFAULT ((0)),
	[DRadiographsEnclosed] [bit] NOT NULL CONSTRAINT [DF_SuperbillDental_DRadiographsEnclosed]  DEFAULT ((0)),
	[DInitProsthesisPlacement] [bit] NOT NULL CONSTRAINT [DF_SuperbillDental_DInitProsthesisPlacement]  DEFAULT ((0)),
	[DProsthesisReplaceRsn] [varchar](50) NULL,
	[DUnusualSrvRemarks] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SuperbillDental_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SuperbillDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [SuperbillDiagnosis](
	[SuperbillDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SuperbillDiagnosis_SuperbillDiagnosisUid]  DEFAULT (newid()),
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_SuperbillDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[SourceVisitDiagnosisUid] [uniqueidentifier] NULL,
	[SourceFinancialNoteDiagnosisUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SuperbillDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SuperbillProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [SuperbillProcedure](
	[SuperbillProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SuperbillProcedure_SuperbillProcedureUid]  DEFAULT (newid()),
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DisplayOrder]  DEFAULT ((0)),
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_SuperbillProcedure_Inactive]  DEFAULT ((0)),
	[ProcedureCharge] [money] NOT NULL CONSTRAINT [DF_SuperbillProcedure_ProcedureCharge]  DEFAULT ((0)),
	[ProcedureAllowed] [money] NULL,
	[ProcedureAllowedFeeRuleFeedback] [varchar](max) NULL,
	[ProcedureAllowedFeeScheduleRuleUid] [uniqueidentifier] NULL,
	[Units] [decimal](20, 3) NOT NULL CONSTRAINT [DF_SuperbillProcedure_Units]  DEFAULT ((1)),
	[InsurancePercent] [smallint] NULL,
	[FixedCopayAmount] [money] NULL,
	[SubtotalCharge] [money] NULL,
	[TotalTax] [money] NULL,
	[TotalCharge] [money] NULL,
	[TotalAllowed] [money] NULL,
	[ManuallySetFeeAllowed] [bit] NOT NULL CONSTRAINT [DF_SuperbillProcedure_ManuallySetFeeAllowed]  DEFAULT ((0)),
	[ProcedureServiceDateStart] [date] NOT NULL,
	[ProcedureServiceDateEnd] [date] NOT NULL,
	[BillStartTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillEndTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillTimeXml] [varchar](max) NULL,
	[BillOdometerXml] [varchar](max) NULL,
	[DiagnosisPointer1] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer1]  DEFAULT ((0)),
	[DiagnosisPointer2] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer2]  DEFAULT ((0)),
	[DiagnosisPointer3] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer3]  DEFAULT ((0)),
	[DiagnosisPointer4] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer4]  DEFAULT ((0)),
	[DiagnosisPointer5] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer5]  DEFAULT ((0)),
	[DiagnosisPointer6] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer6]  DEFAULT ((0)),
	[DiagnosisPointer7] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer7]  DEFAULT ((0)),
	[DiagnosisPointer8] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer8]  DEFAULT ((0)),
	[DontClaim] [bit] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DontClaim]  DEFAULT ((0)),
	[GlobalPeriodDays] [int] NULL,
	[WorkRVU] [decimal](5, 2) NULL,
	[RVU] [decimal](5, 2) NULL,
	[NDC] [varchar](40) NULL,
	[NDCUnitMeasureUid] [uniqueidentifier] NULL,
	[FDB_MEDID] [int] NULL,
	[Cost] [money] NULL,
	[NDCQuantity] [varchar](15) NULL,
	[MedicationMeasurementValue] [decimal](5, 2) NULL,
	[MedicationMeasurementReference] [bit] NULL,
	[MedicationMeasurementQualifierUid] [uniqueidentifier] NULL,
	[MultiplyUnits] [bit] NOT NULL CONSTRAINT [DF_SuperbillProcedure_MultiplyUnits]  DEFAULT ((1)),
	[OverrideFundTypeUid] [uniqueidentifier] NULL,
	[OverrideEligibilityFundUid] [uniqueidentifier] NULL,
	[ContractTypeCodeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[FamilyPlanning] [bit] NOT NULL CONSTRAINT [DF_SuperbillProcedure_FamilyPlanning]  DEFAULT ((0)),
	[UserDefinedXml] [xml] NULL,
	[DFTGeneratedDateTime] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SuperbillProcedure_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[PaperworkTypeUid] [uniqueidentifier] NULL,
	[PaperworkTransmissionCodeUid] [uniqueidentifier] NULL,
	[PaperworkControlNum] [varchar](50) NULL,
	[DiagnosisPointer9] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer81]  DEFAULT ((0)),
	[DiagnosisPointer10] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer82]  DEFAULT ((0)),
	[DiagnosisPointer11] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer85]  DEFAULT ((0)),
	[DiagnosisPointer12] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer84]  DEFAULT ((0)),
	[DiagnosisPointer13] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer816]  DEFAULT ((0)),
	[DiagnosisPointer14] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer815]  DEFAULT ((0)),
	[DiagnosisPointer15] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer814]  DEFAULT ((0)),
	[DiagnosisPointer16] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer813]  DEFAULT ((0)),
	[DiagnosisPointer17] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer812]  DEFAULT ((0)),
	[DiagnosisPointer18] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer811]  DEFAULT ((0)),
	[DiagnosisPointer19] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer810]  DEFAULT ((0)),
	[DiagnosisPointer20] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer89]  DEFAULT ((0)),
	[DiagnosisPointer21] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer88]  DEFAULT ((0)),
	[DiagnosisPointer22] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer87]  DEFAULT ((0)),
	[DiagnosisPointer23] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer86]  DEFAULT ((0)),
	[DiagnosisPointer24] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedure_DiagnosisPointer231]  DEFAULT ((0)),
	[SourceVisitProcedureUid] [uniqueidentifier] NULL,
	[SourceFinancialNoteProcedureUid] [uniqueidentifier] NULL,
	[PurchasedServiceCharge] [money] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SuperbillProcedureDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [SuperbillProcedureDiagnosis](
	[SuperbillProcedureDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SuperbillProcedureUid] [uniqueidentifier] NOT NULL,
	[SuperbillDiagnosisUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SuperbillProcedureModifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [SuperbillProcedureModifier](
	[SuperbillProcedureModifierUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SuperbillProcedureModifier_SuperbillProcedureModifierUid]  DEFAULT (newid()),
	[SuperbillProcedureUid] [uniqueidentifier] NOT NULL,
	[ProcedureModifierUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_SuperbillProcedureModifier_DisplayOrder]  DEFAULT ((0)),
	[SourceFinancialNoteProcedureModifierUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_SuperbillProcedureModifier_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SuperbillProcedureModifier_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SuperbillUB]') AND type in (N'U'))
BEGIN
CREATE TABLE [SuperbillUB](
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[OperatingProviderUid] [uniqueidentifier] NULL,
	[SupervisingProviderUid] [uniqueidentifier] NULL,
	[AttendingProviderUid] [uniqueidentifier] NULL,
	[ServiceAuthorizationNumber] [varchar](50) NULL,
	[ServiceAuthorizationExceptionUid] [uniqueidentifier] NULL,
	[SpecialProgramReasonUid] [uniqueidentifier] NULL,
	[TypeOfBill] [varchar](5) NULL,
	[ValueCode1Uid] [uniqueidentifier] NULL,
	[ValueCode1Amount] [money] NULL,
	[ValueCode2Uid] [uniqueidentifier] NULL,
	[ValueCode2Amount] [money] NULL,
	[ValueCode3Uid] [uniqueidentifier] NULL,
	[ValueCode3Amount] [money] NULL,
	[ValueCode4Uid] [uniqueidentifier] NULL,
	[ValueCode4Amount] [money] NULL,
	[ValueCode5Uid] [uniqueidentifier] NULL,
	[ValueCode5Amount] [money] NULL,
	[ValueCode6Uid] [uniqueidentifier] NULL,
	[ValueCode6Amount] [money] NULL,
	[ValueCode7Uid] [uniqueidentifier] NULL,
	[ValueCode7Amount] [money] NULL,
	[ValueCode8Uid] [uniqueidentifier] NULL,
	[ValueCode8Amount] [money] NULL,
	[ValueCode9Uid] [uniqueidentifier] NULL,
	[ValueCode9Amount] [money] NULL,
	[ValueCode10Uid] [uniqueidentifier] NULL,
	[ValueCode10Amount] [money] NULL,
	[ValueCode11Uid] [uniqueidentifier] NULL,
	[ValueCode11Amount] [money] NULL,
	[ValueCode12Uid] [uniqueidentifier] NULL,
	[ValueCode12Amount] [money] NULL,
	[ConditionCode1Uid] [uniqueidentifier] NULL,
	[ConditionCode2Uid] [uniqueidentifier] NULL,
	[ConditionCode3Uid] [uniqueidentifier] NULL,
	[ConditionCode4Uid] [uniqueidentifier] NULL,
	[ConditionCode5Uid] [uniqueidentifier] NULL,
	[ConditionCode6Uid] [uniqueidentifier] NULL,
	[ConditionCode7Uid] [uniqueidentifier] NULL,
	[OccurrenceCode1Uid] [uniqueidentifier] NULL,
	[OccurrenceCode1Date] [date] NULL,
	[OccurrenceCode2Uid] [uniqueidentifier] NULL,
	[OccurrenceCode2Date] [date] NULL,
	[OccurrenceCode3Uid] [uniqueidentifier] NULL,
	[OccurrenceCode3Date] [date] NULL,
	[OccurrenceCode4Uid] [uniqueidentifier] NULL,
	[OccurrenceCode4Date] [date] NULL,
	[OccurrenceCode5Uid] [uniqueidentifier] NULL,
	[OccurrenceCode5Date] [date] NULL,
	[OccurrenceCode6Uid] [uniqueidentifier] NULL,
	[OccurrenceCode6Date] [date] NULL,
	[OccurrenceCode7Uid] [uniqueidentifier] NULL,
	[OccurrenceCode7Date] [date] NULL,
	[OccurrenceCode8Uid] [uniqueidentifier] NULL,
	[OccurrenceCode8Date] [date] NULL,
	[OccurrenceCodeSpan1Uid] [uniqueidentifier] NULL,
	[OccurrenceCodeSpan1FrDate] [date] NULL,
	[OccurrenceCodeSpan1ToDate] [date] NULL,
	[OccurrenceCodeSpan2Uid] [uniqueidentifier] NULL,
	[OccurrenceCodeSpan2FrDate] [date] NULL,
	[OccurrenceCodeSpan2ToDate] [date] NULL,
	[AdmissionTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[DischargeTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[AdmissionTypeUid] [uniqueidentifier] NULL,
	[AdmissionSourceUid] [uniqueidentifier] NULL,
	[PatientStatusUBUid] [uniqueidentifier] NULL,
	[CoverageDays] [int] NULL,
	[NonCoveredDays] [int] NULL,
	[CoInsuranceDays] [int] NULL,
	[LifetimeReserveDays] [int] NULL,
	[AdmittingDiagnosisCode9] [varchar](25) NULL,
	[AdmittingDiagnosisCode10] [varchar](25) NULL,
	[AdmittingDiagnosisCodeDescription] [varchar](255) NULL,
	[AdmittingDiagnosisSnomedCTConceptId] [bigint] NULL,
	[ExternalInjuryCode9] [varchar](25) NULL,
	[ExternalInjuryCode10] [varchar](25) NULL,
	[ExternalInjuryCodeDescription] [varchar](255) NULL,
	[ExternalInjurySnomedCTConceptId] [bigint] NULL,
	[CarePlanOversight] [varchar](25) NULL,
	[APGProcedureUid] [uniqueidentifier] NULL,
	[DRGProcedureUid] [uniqueidentifier] NULL,
	[OtherProcedure1Uid] [uniqueidentifier] NULL,
	[OtherProcedure1Date] [date] NULL,
	[OtherProcedure2Uid] [uniqueidentifier] NULL,
	[OtherProcedure2Date] [date] NULL,
	[OtherProcedure3Uid] [uniqueidentifier] NULL,
	[OtherProcedure3Date] [date] NULL,
	[OtherProcedure4Uid] [uniqueidentifier] NULL,
	[OtherProcedure4Date] [date] NULL,
	[TreatmentAuthorization1] [varchar](50) NULL,
	[TreatmentAuthorization2] [varchar](50) NULL,
	[TreatmentAuthorization3] [varchar](50) NULL,
	[CoveredPeriodFrDate] [date] NULL,
	[CoveredPeriodToDate] [date] NULL,
	[AssumedDate] [date] NULL,
	[RelinquishedDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SuperbillUB_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SurveyAttachment]') AND type in (N'U'))
BEGIN
CREATE TABLE [SurveyAttachment](
	[SurveyAttachmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__SurveyAtt__Surve__2D364EA1]  DEFAULT (newid()),
	[Name] [varchar](50) NOT NULL,
	[RelSurveyPatientUid] [uniqueidentifier] NOT NULL,
	[WebSurvey] [bit] NOT NULL CONSTRAINT [DF__SurveyAtt__WebSu__2F1E9713]  DEFAULT ((1)),
	[FileType] [varchar](10) NOT NULL,
	[AttachmentGroupType] [varchar](50) NOT NULL,
	[FileSize] [int] NOT NULL,
	[FileContents] [varbinary](max) NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__SurveyAtt__LastM__3106DF85]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SurveyPathInfo]') AND type in (N'U'))
BEGIN
CREATE TABLE [SurveyPathInfo](
	[SurveyPathInfoUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[PublishedFormsPath] [varchar](256) NULL,
	[ScannedImagesPath] [varchar](256) NULL,
	[XmlExportPath] [varchar](256) NULL,
	[InvalidSurveyFilesPath] [varchar](256) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[TemplateZipFoldersPath] [varchar](256) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SurveyResponse]') AND type in (N'U'))
BEGIN
CREATE TABLE [SurveyResponse](
	[SurveyResponseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF__SurveyRes__Surve__4CD6FBDC]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF__SurveyRes__Inact__4DCB2015]  DEFAULT ((0)),
	[Imported] [bit] NOT NULL CONSTRAINT [DF__SurveyRes__Impor__4EBF444E]  DEFAULT ((0)),
	[RelSurveyPatientUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[SurveyUid] [uniqueidentifier] NOT NULL,
	[SurveySectionUid] [uniqueidentifier] NOT NULL,
	[SurveyQuestionUid] [uniqueidentifier] NULL,
	[SurveyAnswerUid] [uniqueidentifier] NULL,
	[DependentSurveyAnswerUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[QuestionName] [varchar](255) NULL,
	[AnswerName] [varchar](255) NULL,
	[QuestionText] [varchar](max) NULL,
	[AnswerText] [varchar](max) NULL,
	[Explanation] [varchar](max) NULL,
	[ResponseXML] [varchar](max) NULL,
	[RecordDateTime] [datetime] NULL,
	[TargetType] [varchar](50) NOT NULL CONSTRAINT [DF_SurveyResponse_TargetType]  DEFAULT ('KDB'),
	[RelRosSystemSymptomUid] [uniqueidentifier] NULL,
	[RosDenyFlag] [bit] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[ProblemStatusUid] [uniqueidentifier] NULL,
	[PredeterminedTargetType] [varchar](50) NULL,
	[PredeterminedQuestionUid] [uniqueidentifier] NULL,
	[PredeterminedDiseaseUid] [uniqueidentifier] NULL,
	[PredeterminedRelRosSystemSymptomUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__SurveyRes__LastM__5848AE88]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SurveyResponseDiseaseHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [SurveyResponseDiseaseHistory](
	[SurveyResponseDiseaseHistoryUid] [uniqueidentifier] NOT NULL,
	[SurveyResponseUid] [uniqueidentifier] NOT NULL,
	[RelSurveyPatientUid] [uniqueidentifier] NOT NULL,
	[SurveyResponseFamilyHistoryUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[DiseaseUid] [uniqueidentifier] NOT NULL,
	[DiseaseName] [varchar](100) NOT NULL,
	[OnsetTimeFrameUid] [uniqueidentifier] NULL,
	[OnsetTimeFrameAnswer] [varchar](255) NULL,
	[OnSetTimeFrameValue] [varchar](255) NULL,
	[OnSetTimeFrameFuzzyDate] [datetime] NULL,
	[IsCauseOfDeath] [bit] NOT NULL,
	[Denies] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SurveyResponseFamilyHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [SurveyResponseFamilyHistory](
	[SurveyResponseFamilyHistoryUid] [uniqueidentifier] NOT NULL,
	[SurveyResponseUid] [uniqueidentifier] NOT NULL,
	[RelSurveyPatientUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[HxRelationshipUid] [uniqueidentifier] NULL,
	[RelationshipName] [varchar](50) NULL,
	[FirstName] [varchar](50) NULL,
	[LastName] [varchar](50) NULL,
	[BirthTimeFrameUid] [uniqueidentifier] NULL,
	[BirthTimeFrameAnswer] [varchar](255) NULL,
	[BirthTimeFrameValue] [varchar](255) NULL,
	[BirthTimeFrameFuzzyDate] [datetime] NULL,
	[DeathTimeFrameUid] [uniqueidentifier] NULL,
	[DeathTimeFrameAnswer] [varchar](255) NULL,
	[DeathTimeFrameValue] [varchar](255) NULL,
	[DeathTimeFrameFuzzyDate] [datetime] NULL,
	[IsMaternal] [bit] NOT NULL,
	[IsPaternal] [bit] NOT NULL,
	[NoKnownDisease] [bit] NOT NULL,
	[Unknown] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[PatientFamilyHistoryUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[SurveyResponseImmunizationHistory]') AND type in (N'U'))
BEGIN
CREATE TABLE [SurveyResponseImmunizationHistory](
	[SurveyResponseImmunizationHistoryUid] [uniqueidentifier] NOT NULL,
	[SurveyResponseUid] [uniqueidentifier] NOT NULL,
	[RelSurveyPatientUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VaccineAdminUid] [uniqueidentifier] NULL,
	[VaccineAdminName] [varchar](100) NULL,
	[VaccineUid] [uniqueidentifier] NULL,
	[VaccineName] [varchar](100) NULL,
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[TypeofVaccineName] [varchar](100) NULL,
	[AdminDateTimeFrameUid] [uniqueidentifier] NULL,
	[AdminDateTimeFrameAnswer] [varchar](255) NULL,
	[AdminDateTimeFrameValue] [varchar](255) NULL,
	[AdminTimeFrameFuzzyDate] [datetime] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TemporaryQuestLabOrder]') AND type in (N'U'))
BEGIN
CREATE TABLE [TemporaryQuestLabOrder](
	[TemporaryQuestLabOrderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[LabCode] [varchar](25) NOT NULL,
	[ProcedureCode] [varchar](30) NULL,
	[Description] [varchar](1024) NULL,
	[SplitCategory1] [varchar](2) NULL,
	[SplitCategory2] [varchar](1) NULL,
	[Prefix] [varchar](10) NULL,
	[Inactive] [bit] NOT NULL,
	[IsModified] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Transcriptionist]') AND type in (N'U'))
BEGIN
CREATE TABLE [Transcriptionist](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Transcriptionist_Inactive]  DEFAULT ((0)),
	[PathToDictatedFiles] [varchar](255) NULL,
	[PathToUrgentDictatedFiles] [varchar](255) NULL,
	[PathToTranscribledFiles] [varchar](255) NULL,
	[PathToUrgentTranscribedFiles] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Transcriptionist_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Translation]') AND type in (N'U'))
BEGIN
CREATE TABLE [Translation](
	[TranslationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Translation_TranslationUid]  DEFAULT (newsequentialid()),
	[TableName] [varchar](100) NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[Spanish] [varchar](255) NULL,
	[Verified] [bit] NOT NULL CONSTRAINT [DF_Translation_Verified]  DEFAULT ((0)),
	[AutoTranslationError] [bit] NOT NULL CONSTRAINT [DF_Translation_AutoTranslationError]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Translation_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Translation_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TransmissionConfiguration]') AND type in (N'U'))
BEGIN
CREATE TABLE [TransmissionConfiguration](
	[TransmissionConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_TransmissionConfigurationUid]  DEFAULT (newid()),
	[TransmissionType] [varchar](50) NOT NULL,
	[CorepointClientID] [varchar](100) NULL,
	[CorepointMachineID] [varchar](100) NULL,
	[CorepointInboundConnectionID] [varchar](100) NULL,
	[CorepointOutboundConnectionID] [varchar](100) NULL,
	[CorepointUsername] [varchar](100) NULL,
	[CorepointPassword] [varchar](100) NULL,
	[AdditionalOutboundXML] [varchar](max) NULL,
	[AprimaVaultURL] [varchar](512) NULL,
	[AprimaVaultSubmissionURL] [varchar](512) NULL,
	[OverrideAprimaVaultURL] [varchar](512) NULL,
	[AprimaVaultSyncURL] [varchar](512) NULL,
	[RegistrationURL] [varchar](512) NULL,
	[TestMode] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_TestMode]  DEFAULT ((0)),
	[TestAprimaVaultURL] [varchar](512) NULL,
	[TestAprimaVaultSubmissionURL] [varchar](512) NULL,
	[TestOverrideAprimaVaultURL] [varchar](512) NULL,
	[TestAprimaVaultSyncURL] [varchar](512) NULL,
	[TestRegistrationURL] [varchar](512) NULL,
	[AutoSend] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoSend]  DEFAULT ((1)),
	[AutoDownload] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoDownload]  DEFAULT ((1)),
	[AutoProcessDownloads] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoProcessDownloads]  DEFAULT ((1)),
	[AutoQueue] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoQueue]  DEFAULT ((0)),
	[MaxSendAttempts] [int] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_MaxSendAttempts]  DEFAULT ((8)),
	[CorepointDataExportGeneratorAQN] [varchar](512) NULL,
	[CorepointSenderAQN] [varchar](512) NULL,
	[CorepointDownloaderAQN] [varchar](512) NULL,
	[CorepointDownloadProcessorAQN] [varchar](512) NULL,
	[OutboundQueueGeneratorAQN] [varchar](512) NULL,
	[ExportXMLLayout] [varchar](max) NULL,
	[ExportBusinessObjectName] [varchar](250) NULL,
	[ExportKeyLookupFieldName] [varchar](250) NULL,
	[Description] [varchar](512) NULL,
	[AutoQueueIntervalSeconds] [int] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoQueueIntervalSeconds]  DEFAULT ((0)),
	[AutoQueueLastRun] [datetime] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoQueueLastRun]  DEFAULT (getutcdate()),
	[ForeignObjectUid] [uniqueidentifier] NULL,
	[ClaimClearingHouseUid] [uniqueidentifier] NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[TransmissionAQN] [varchar](1024) NULL,
	[AdditionalConfigurationXML] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageDisplayAQN] [varchar](500) NULL,
	[MessageParserAQN] [varchar](500) NULL,
	[MessageUpdatesAQN] [varchar](500) NULL,
	[UpdateableConfiguration] [varchar](max) NULL,
	[HighlightConfiguration] [varchar](max) NULL,
	[LegacyCreationDate] [datetime] NULL,
	[OriginalTransmissionConfigurationUid] [uniqueidentifier] NULL,
	[IdentityVerificationRequired] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_IdentityVerificationRequired]  DEFAULT ((0)),
	[ActionType] [varchar](500) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TransmissionData]') AND type in (N'U'))
BEGIN
CREATE TABLE [TransmissionData](
	[TransmissionDataUid] [uniqueidentifier] NOT NULL,
	[TransmissionType] [varchar](50) NOT NULL,
	[MessageProcessed] [bit] NOT NULL,
	[RequestId] [varchar](50) NULL,
	[ClaimBatchUid] [uniqueidentifier] NULL,
	[EligibilityRequestUid] [uniqueidentifier] NULL,
	[Filename] [varchar](255) NULL,
	[Description] [varchar](1000) NULL,
	[RawMessage] [varchar](max) NULL,
	[DataContent] [varchar](max) NULL,
	[IsUploadComplete] [bit] NOT NULL,
	[IsDownloadComplete] [bit] NOT NULL,
	[TransmissionReceivedDate] [datetime] NOT NULL,
	[IsError] [bit] NOT NULL,
	[LastError] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ClaimClearingHouseUid] [uniqueidentifier] NULL,
	[HL7PartnerUid] [uniqueidentifier] NULL,
	[ProcessingData] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TransmissionOutbound]') AND type in (N'U'))
BEGIN
CREATE TABLE [TransmissionOutbound](
	[TransmissionOutboundUid] [uniqueidentifier] NOT NULL,
	[TransmissionType] [varchar](50) NOT NULL,
	[Status] [smallint] NOT NULL,
	[Description] [varchar](1000) NULL,
	[RawMessage] [varchar](max) NULL,
	[TransmissionControlXML] [xml] NULL,
	[ForeignObjectUid] [uniqueidentifier] NULL,
	[EnqueuedTimestamp] [datetime] NOT NULL,
	[NextSendAttempt] [datetime] NOT NULL,
	[LastTransmissionAttempt] [datetime] NULL,
	[NumberOfTransmissionAttempts] [int] NOT NULL,
	[SuccessfulTransmissionTimestamp] [datetime] NULL,
	[LastError] [varchar](max) NULL,
	[IntermediateGenerationData] [varchar](max) NULL,
	[StatusHistory] [varchar](max) NULL,
	[ExternalStatus] [varchar](1000) NULL,
	[ExternalStatusDescription] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[TypeofVaccineDefault]') AND type in (N'U'))
BEGIN
CREATE TABLE [TypeofVaccineDefault](
	[TypeofVaccineDefaultUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_TypeofVaccineDefaultUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_Inactive]  DEFAULT ((0)),
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[VFCEligibilityUid] [uniqueidentifier] NULL,
	[VaccineDose] [varchar](50) NULL,
	[VaccineUnits] [varchar](60) NULL,
	[VaccineSiteUid] [uniqueidentifier] NULL,
	[VaccineRouteUid] [uniqueidentifier] NULL,
	[VaccineFundingSourceUid] [uniqueidentifier] NULL,
	[VaccineMfrUid] [uniqueidentifier] NULL,
	[VaccineLotNo] [varchar](255) NULL,
	[DateOnVIS] [date] NULL,
	[ExpirationDate] [date] NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_DisplayOrder]  DEFAULT ((-1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_TypeofVaccineDefault_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UB04Claim]') AND type in (N'U'))
BEGIN
CREATE TABLE [UB04Claim](
	[UB04ClaimUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SuperBillUId] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[ProviderUId] [uniqueidentifier] NULL,
	[FileAsGroup] [bit] NULL,
	[SendNPI] [bit] NULL,
	[ProviderName_FL1] [varchar](200) NULL,
	[ProviderAddress1_FL1] [varchar](200) NULL,
	[ProviderAddress2_FL1] [varchar](200) NULL,
	[ProviderCity_FL1] [varchar](25) NULL,
	[ProviderState_FL1] [varchar](3) NULL,
	[ProviderZip_FL1] [varchar](10) NULL,
	[ProviderPhone_FL1] [varchar](22) NULL,
	[PatientControlNumber_FL3a] [varchar](25) NULL,
	[MedicalRecordNumber_FL3b] [varchar](25) NULL,
	[TypeOfBill_FL4] [varchar](5) NULL,
	[FederalTaxID_FL5] [varchar](25) NULL,
	[StatementCoversPeriod_FL6From] [varchar](10) NULL,
	[StatementCoversPeriod_FL6To] [varchar](10) NULL,
	[PatientName_FL8b] [varchar](200) NULL,
	[PatientAddressStreet_FL9a] [varchar](200) NULL,
	[PatientAddressCity_FL9b] [varchar](25) NULL,
	[PatientAddressState_FL9c] [varchar](3) NULL,
	[PatientAddressZip_FL9d] [varchar](10) NULL,
	[PatientBirthDate_FL10] [varchar](10) NULL,
	[PatientSex_FL11] [varchar](1) NULL,
	[AdmissionDate_FL12] [varchar](10) NULL,
	[AdmissionHour_FL13] [varchar](10) NULL,
	[AdmissionType_FL14] [varchar](10) NULL,
	[AdmissionSource_FL15] [varchar](10) NULL,
	[DischargeHour_FL16] [varchar](10) NULL,
	[PatientDischargeStatus_FL17] [varchar](10) NULL,
	[ConditionCode_FL18] [varchar](10) NULL,
	[ConditionCode_FL19] [varchar](10) NULL,
	[ConditionCode_FL20] [varchar](10) NULL,
	[ConditionCode_FL21] [varchar](10) NULL,
	[ConditionCode_FL22] [varchar](10) NULL,
	[ConditionCode_FL23] [varchar](10) NULL,
	[ConditionCode_FL24] [varchar](10) NULL,
	[ConditionCode_FL25] [varchar](10) NULL,
	[ConditionCode_FL26] [varchar](10) NULL,
	[ConditionCode_FL27] [varchar](10) NULL,
	[ConditionCode_FL28] [varchar](10) NULL,
	[AccidentState_FL29] [varchar](3) NULL,
	[OccurrenceCode_FL31] [varchar](10) NULL,
	[OccurrenceDate_FL31] [varchar](10) NULL,
	[OccurrenceCode_FL32] [varchar](10) NULL,
	[OccurrenceDate_FL32] [varchar](10) NULL,
	[OccurrenceCode_FL33] [varchar](10) NULL,
	[OccurrenceDate_FL33] [varchar](10) NULL,
	[OccurrenceCode_FL34] [varchar](10) NULL,
	[OccurrenceDate_FL34] [varchar](10) NULL,
	[OccurrenceCode_FL31b] [varchar](10) NULL,
	[OccurrenceDate_FL31b] [varchar](10) NULL,
	[OccurrenceCode_FL32b] [varchar](10) NULL,
	[OccurrenceDate_FL32b] [varchar](10) NULL,
	[OccurrenceCode_FL33b] [varchar](10) NULL,
	[OccurrenceDate_FL33b] [varchar](10) NULL,
	[OccurrenceCode_FL34b] [varchar](10) NULL,
	[OccurrenceDate_FL34b] [varchar](10) NULL,
	[OccurrenceSpanCode_FL35] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL35] [varchar](10) NULL,
	[OccurrenceSpanTo_FL35] [varchar](10) NULL,
	[OccurrenceSpanCode_FL36] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL36] [varchar](10) NULL,
	[OccurrenceSpanTo_FL36] [varchar](10) NULL,
	[OccurrenceSpanCode_FL35b] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL35b] [varchar](10) NULL,
	[OccurrenceSpanTo_FL35b] [varchar](10) NULL,
	[OccurrenceSpanCode_FL36b] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL36b] [varchar](10) NULL,
	[OccurrenceSpanTo_FL36b] [varchar](10) NULL,
	[ResponsiblePartyName_IsCorporation] [bit] NULL,
	[ResponsiblePartyName_FL38] [varchar](200) NULL,
	[ResponsiblePartyAddress1_FL38] [varchar](200) NULL,
	[ResponsiblePartyAddress2_FL38] [varchar](200) NULL,
	[ResponsiblePartyCity_FL38] [varchar](25) NULL,
	[ResponsiblePartyState_FL38] [varchar](3) NULL,
	[ResponsiblePartyZip_FL38] [varchar](10) NULL,
	[ValueCode_FL39a] [varchar](10) NULL,
	[ValueCodeAmount_FL39a] [money] NULL,
	[ValueCode_FL39b] [varchar](10) NULL,
	[ValueCodeAmount_FL39b] [money] NULL,
	[ValueCode_FL39c] [varchar](10) NULL,
	[ValueCodeAmount_FL39c] [money] NULL,
	[ValueCode_FL39d] [varchar](10) NULL,
	[ValueCodeAmount_FL39d] [money] NULL,
	[ValueCode_FL40a] [varchar](10) NULL,
	[ValueCodeAmount_FL40a] [money] NULL,
	[ValueCode_FL40b] [varchar](10) NULL,
	[ValueCodeAmount_FL40b] [money] NULL,
	[ValueCode_FL40c] [varchar](10) NULL,
	[ValueCodeAmount_FL40c] [money] NULL,
	[ValueCode_FL40d] [varchar](10) NULL,
	[ValueCodeAmount_FL40d] [money] NULL,
	[ValueCode_FL41a] [varchar](10) NULL,
	[ValueCodeAmount_FL41a] [money] NULL,
	[ValueCode_FL41b] [varchar](10) NULL,
	[ValueCodeAmount_FL41b] [money] NULL,
	[ValueCode_FL41c] [varchar](10) NULL,
	[ValueCodeAmount_FL41c] [money] NULL,
	[ValueCode_FL41d] [varchar](10) NULL,
	[ValueCodeAmount_FL41d] [money] NULL,
	[PrimaryPayerName_FL50a] [varchar](200) NULL,
	[PrimaryPayerPlanType_FL50a] [varchar](25) NULL,
	[PrimaryPayerPlanName_FL50a] [varchar](200) NULL,
	[SecondaryPayerName_FL50b] [varchar](200) NULL,
	[SecondaryPayerPlanType_FL50b] [varchar](25) NULL,
	[SecondaryPayerPlanName_FL50b] [varchar](200) NULL,
	[TertiaryPayerName_FL50c] [varchar](200) NULL,
	[TertiaryPayerPlanType_FL50c] [varchar](25) NULL,
	[TertiaryPayerPlanName_FL50c] [varchar](200) NULL,
	[PrimaryHealthPlanIDType_FL51a] [varchar](10) NULL,
	[SecondaryHealthPlanIDType_FL51b] [varchar](10) NULL,
	[TertiaryHealthPlanIDType_FL51c] [varchar](10) NULL,
	[PrimaryHealthPlanID_FL51a] [varchar](50) NULL,
	[SecondaryHealthPlanID_FL51b] [varchar](50) NULL,
	[TertiaryHealthPlanID_FL51c] [varchar](50) NULL,
	[PrimaryPatReleaseInfo_FL52a] [varchar](1) NULL,
	[SecondaryPatReleaseInfo_FL52b] [varchar](1) NULL,
	[TertiaryPatReleaseInfo_FL52c] [varchar](1) NULL,
	[PrimaryAssignBenefits_FL53a] [varchar](1) NULL,
	[SecondaryAssignBenefits_FL53b] [varchar](1) NULL,
	[TertiaryAssignBenefits_FL53c] [varchar](1) NULL,
	[PrimaryPriorPmts_FL54a] [money] NULL,
	[SecondaryPriorPmts_FL54b] [money] NULL,
	[TertiaryPriorPmts_FL54c] [money] NULL,
	[PrimaryEstAmtDue_FL55a] [money] NULL,
	[SecondaryEstAmtDue_FL55b] [money] NULL,
	[TertiaryEstAmtDue_FL55c] [money] NULL,
	[BillingProviderNPI_FL56] [varchar](50) NULL,
	[ID_FL57] [varchar](50) NULL,
	[OtherID_FL57] [varchar](50) NULL,
	[ProviderID_FL57] [varchar](50) NULL,
	[PrimaryInsuredName_FL58a] [varchar](200) NULL,
	[SecondaryInsuredName_FL58b] [varchar](200) NULL,
	[TertiaryInsuredName_FL58c] [varchar](200) NULL,
	[PrimaryPatRelationship_FL59a] [varchar](2) NULL,
	[SecondaryPatRelationship_FL59b] [varchar](2) NULL,
	[TertiaryPatRelationship_FL59c] [varchar](2) NULL,
	[PrimaryInsuredPlanID_FL60a] [varchar](50) NULL,
	[SecondaryInsuredPlanID_FL60b] [varchar](50) NULL,
	[TertiaryInsuredPlanID_FL60c] [varchar](50) NULL,
	[PrimaryPlanGroupName_FL61a] [varchar](200) NULL,
	[SecondaryPlanGroupName_FL61b] [varchar](200) NULL,
	[TertiaryPlanGroupName_FL61c] [varchar](200) NULL,
	[PrimaryPlanGroupID_FL62a] [varchar](50) NULL,
	[SecondaryPlanGroupID_FL62b] [varchar](50) NULL,
	[TertiaryPlanGroupID_FL62c] [varchar](50) NULL,
	[PrimaryTreatmentAuth_FL63a] [varchar](50) NULL,
	[SecondaryTreatmentAuth_FL63b] [varchar](50) NULL,
	[TertiaryTreatmentAuth_FL63c] [varchar](50) NULL,
	[DocControlNo_FL64a] [varchar](50) NULL,
	[DocControlNo_FL64b] [varchar](26) NULL,
	[DocControlNo_FL64c] [varchar](26) NULL,
	[PrimaryEmployerName_FL65a] [varchar](200) NULL,
	[SecondaryEmployerName_FL65b] [varchar](200) NULL,
	[TertiaryEmployerName_FL65c] [varchar](200) NULL,
	[DiagnosisVersion_FL66] [varchar](1) NULL,
	[Diagnosis_FL67] [varchar](25) NULL,
	[Diagnosis_FL67a] [varchar](25) NULL,
	[Diagnosis_FL67b] [varchar](25) NULL,
	[Diagnosis_FL67c] [varchar](25) NULL,
	[Diagnosis_FL67d] [varchar](25) NULL,
	[Diagnosis_FL67e] [varchar](25) NULL,
	[Diagnosis_FL67f] [varchar](25) NULL,
	[Diagnosis_FL67g] [varchar](25) NULL,
	[Diagnosis_FL67h] [varchar](25) NULL,
	[Diagnosis_FL67i] [varchar](25) NULL,
	[Diagnosis_FL67j] [varchar](25) NULL,
	[Diagnosis_FL67k] [varchar](25) NULL,
	[Diagnosis_FL67l] [varchar](25) NULL,
	[Diagnosis_FL67m] [varchar](25) NULL,
	[Diagnosis_FL67n] [varchar](25) NULL,
	[Diagnosis_FL67o] [varchar](25) NULL,
	[Diagnosis_FL67p] [varchar](25) NULL,
	[Diagnosis_FL67q] [varchar](25) NULL,
	[AdmittingDiagnosis_FL69] [varchar](25) NULL,
	[PatientVisitRsnDiagnosis_FL70a] [varchar](25) NULL,
	[PatientVisitRsnDiagnosis_FL70b] [varchar](25) NULL,
	[PatientVisitRsnDiagnosis_FL70c] [varchar](25) NULL,
	[PrincipalProcCode_FL74] [varchar](30) NULL,
	[PrincipalProcDate_FL74] [varchar](10) NULL,
	[OtherProcCode_FL74a] [varchar](30) NULL,
	[OtherProcDate_FL74a] [varchar](10) NULL,
	[OtherProcCode_FL74b] [varchar](30) NULL,
	[OtherProcDate_FL74b] [varchar](10) NULL,
	[OtherProcCode_FL74c] [varchar](30) NULL,
	[OtherProcDate_FL74c] [varchar](10) NULL,
	[OtherProcCode_FL74d] [varchar](30) NULL,
	[OtherProcDate_FL74d] [varchar](10) NULL,
	[OtherProcCode_FL74e] [varchar](30) NULL,
	[OtherProcDate_FL74e] [varchar](10) NULL,
	[AttendingNPI_ID_FL76] [varchar](50) NULL,
	[AttendingNPI_IDType_FL76] [varchar](10) NULL,
	[AttendingLastName_FL76] [varchar](50) NULL,
	[AttendingFirstName_FL76] [varchar](50) NULL,
	[OperatingNPI_ID_FL77] [varchar](50) NULL,
	[OperatingNPI_IDType_FL77] [varchar](10) NULL,
	[OperatingLastName_FL77] [varchar](50) NULL,
	[OperatingFirstName_FL77] [varchar](50) NULL,
	[OtherNPI_ID_FL78] [varchar](50) NULL,
	[OtherNPI_IDType_FL78] [varchar](10) NULL,
	[OtherLastName_FL78] [varchar](50) NULL,
	[OtherFirstName_FL78] [varchar](50) NULL,
	[OtherNPI_ID_FL79] [varchar](50) NULL,
	[OtherNPI_IDType_FL79] [varchar](10) NULL,
	[OtherLastName_FL79] [varchar](50) NULL,
	[OtherFirstName_FL79] [varchar](50) NULL,
	[Remarks_FL80] [varchar](800) NULL,
	[ClaimBatchUID] [uniqueidentifier] NULL,
	[TotalCharge] [money] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Attending_ID_FL76] [varchar](10) NULL,
	[Other_ID_FL78] [varchar](10) NULL,
	[Other_IDType_FL78] [varchar](10) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UB04ClaimProcs]') AND type in (N'U'))
BEGIN
CREATE TABLE [UB04ClaimProcs](
	[UB04ClaimProcsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SuperBillUId] [uniqueidentifier] NULL,
	[RevenueCode_FL42_1] [varchar](10) NULL,
	[Description_FL43_1] [varchar](50) NULL,
	[HCPCS_FL44_1] [varchar](25) NULL,
	[DOSFrom_FL45_1] [varchar](10) NULL,
	[Units_FL46_1] [varchar](5) NULL,
	[Charges_FL47_1] [money] NULL,
	[NonCoveredCharges_FL48_1] [money] NULL,
	[RevenueCode_FL42_2] [varchar](10) NULL,
	[Description_FL43_2] [varchar](50) NULL,
	[HCPCS_FL44_2] [varchar](25) NULL,
	[DOSFrom_FL45_2] [varchar](10) NULL,
	[Units_FL46_2] [varchar](5) NULL,
	[Charges_FL47_2] [money] NULL,
	[NonCoveredCharges_FL48_2] [money] NULL,
	[RevenueCode_FL42_3] [varchar](10) NULL,
	[Description_FL43_3] [varchar](50) NULL,
	[HCPCS_FL44_3] [varchar](25) NULL,
	[DOSFrom_FL45_3] [varchar](10) NULL,
	[Units_FL46_3] [varchar](5) NULL,
	[Charges_FL47_3] [money] NULL,
	[NonCoveredCharges_FL48_3] [money] NULL,
	[RevenueCode_FL42_4] [varchar](10) NULL,
	[Description_FL43_4] [varchar](50) NULL,
	[HCPCS_FL44_4] [varchar](25) NULL,
	[DOSFrom_FL45_4] [varchar](10) NULL,
	[Units_FL46_4] [varchar](5) NULL,
	[Charges_FL47_4] [money] NULL,
	[NonCoveredCharges_FL48_4] [money] NULL,
	[RevenueCode_FL42_5] [varchar](10) NULL,
	[Description_FL43_5] [varchar](50) NULL,
	[HCPCS_FL44_5] [varchar](25) NULL,
	[DOSFrom_FL45_5] [varchar](10) NULL,
	[Units_FL46_5] [varchar](5) NULL,
	[Charges_FL47_5] [money] NULL,
	[NonCoveredCharges_FL48_5] [money] NULL,
	[RevenueCode_FL42_6] [varchar](10) NULL,
	[Description_FL43_6] [varchar](50) NULL,
	[HCPCS_FL44_6] [varchar](25) NULL,
	[DOSFrom_FL45_6] [varchar](10) NULL,
	[Units_FL46_6] [varchar](5) NULL,
	[Charges_FL47_6] [money] NULL,
	[NonCoveredCharges_FL48_6] [money] NULL,
	[RevenueCode_FL42_7] [varchar](10) NULL,
	[Description_FL43_7] [varchar](50) NULL,
	[HCPCS_FL44_7] [varchar](25) NULL,
	[DOSFrom_FL45_7] [varchar](10) NULL,
	[Units_FL46_7] [varchar](5) NULL,
	[Charges_FL47_7] [money] NULL,
	[NonCoveredCharges_FL48_7] [money] NULL,
	[RevenueCode_FL42_8] [varchar](10) NULL,
	[Description_FL43_8] [varchar](50) NULL,
	[HCPCS_FL44_8] [varchar](25) NULL,
	[DOSFrom_FL45_8] [varchar](10) NULL,
	[Units_FL46_8] [varchar](5) NULL,
	[Charges_FL47_8] [money] NULL,
	[NonCoveredCharges_FL48_8] [money] NULL,
	[RevenueCode_FL42_9] [varchar](10) NULL,
	[Description_FL43_9] [varchar](50) NULL,
	[HCPCS_FL44_9] [varchar](25) NULL,
	[DOSFrom_FL45_9] [varchar](10) NULL,
	[Units_FL46_9] [varchar](5) NULL,
	[Charges_FL47_9] [money] NULL,
	[NonCoveredCharges_FL48_9] [money] NULL,
	[RevenueCode_FL42_10] [varchar](10) NULL,
	[Description_FL43_10] [varchar](50) NULL,
	[HCPCS_FL44_10] [varchar](25) NULL,
	[DOSFrom_FL45_10] [varchar](10) NULL,
	[Units_FL46_10] [varchar](5) NULL,
	[Charges_FL47_10] [money] NULL,
	[NonCoveredCharges_FL48_10] [money] NULL,
	[RevenueCode_FL42_11] [varchar](10) NULL,
	[Description_FL43_11] [varchar](50) NULL,
	[HCPCS_FL44_11] [varchar](25) NULL,
	[DOSFrom_FL45_11] [varchar](10) NULL,
	[Units_FL46_11] [varchar](5) NULL,
	[Charges_FL47_11] [money] NULL,
	[NonCoveredCharges_FL48_11] [money] NULL,
	[RevenueCode_FL42_12] [varchar](10) NULL,
	[Description_FL43_12] [varchar](50) NULL,
	[HCPCS_FL44_12] [varchar](25) NULL,
	[DOSFrom_FL45_12] [varchar](10) NULL,
	[Units_FL46_12] [varchar](5) NULL,
	[Charges_FL47_12] [money] NULL,
	[NonCoveredCharges_FL48_12] [money] NULL,
	[RevenueCode_FL42_13] [varchar](10) NULL,
	[Description_FL43_13] [varchar](50) NULL,
	[HCPCS_FL44_13] [varchar](25) NULL,
	[DOSFrom_FL45_13] [varchar](10) NULL,
	[Units_FL46_13] [varchar](5) NULL,
	[Charges_FL47_13] [money] NULL,
	[NonCoveredCharges_FL48_13] [money] NULL,
	[RevenueCode_FL42_14] [varchar](10) NULL,
	[Description_FL43_14] [varchar](50) NULL,
	[HCPCS_FL44_14] [varchar](25) NULL,
	[DOSFrom_FL45_14] [varchar](10) NULL,
	[Units_FL46_14] [varchar](5) NULL,
	[Charges_FL47_14] [money] NULL,
	[NonCoveredCharges_FL48_14] [money] NULL,
	[RevenueCode_FL42_15] [varchar](10) NULL,
	[Description_FL43_15] [varchar](50) NULL,
	[HCPCS_FL44_15] [varchar](25) NULL,
	[DOSFrom_FL45_15] [varchar](10) NULL,
	[Units_FL46_15] [varchar](5) NULL,
	[Charges_FL47_15] [money] NULL,
	[NonCoveredCharges_FL48_15] [money] NULL,
	[RevenueCode_FL42_16] [varchar](10) NULL,
	[Description_FL43_16] [varchar](50) NULL,
	[HCPCS_FL44_16] [varchar](25) NULL,
	[DOSFrom_FL45_16] [varchar](10) NULL,
	[Units_FL46_16] [varchar](5) NULL,
	[Charges_FL47_16] [money] NULL,
	[NonCoveredCharges_FL48_16] [money] NULL,
	[RevenueCode_FL42_17] [varchar](10) NULL,
	[Description_FL43_17] [varchar](50) NULL,
	[HCPCS_FL44_17] [varchar](25) NULL,
	[DOSFrom_FL45_17] [varchar](10) NULL,
	[Units_FL46_17] [varchar](5) NULL,
	[Charges_FL47_17] [money] NULL,
	[NonCoveredCharges_FL48_17] [money] NULL,
	[RevenueCode_FL42_18] [varchar](10) NULL,
	[Description_FL43_18] [varchar](50) NULL,
	[HCPCS_FL44_18] [varchar](25) NULL,
	[DOSFrom_FL45_18] [varchar](10) NULL,
	[Units_FL46_18] [varchar](5) NULL,
	[Charges_FL47_18] [money] NULL,
	[NonCoveredCharges_FL48_18] [money] NULL,
	[RevenueCode_FL42_19] [varchar](10) NULL,
	[Description_FL43_19] [varchar](50) NULL,
	[HCPCS_FL44_19] [varchar](25) NULL,
	[DOSFrom_FL45_19] [varchar](10) NULL,
	[Units_FL46_19] [varchar](5) NULL,
	[Charges_FL47_19] [money] NULL,
	[NonCoveredCharges_FL48_19] [money] NULL,
	[RevenueCode_FL42_20] [varchar](10) NULL,
	[Description_FL43_20] [varchar](50) NULL,
	[HCPCS_FL44_20] [varchar](25) NULL,
	[DOSFrom_FL45_20] [varchar](10) NULL,
	[Units_FL46_20] [varchar](5) NULL,
	[Charges_FL47_20] [money] NULL,
	[NonCoveredCharges_FL48_20] [money] NULL,
	[RevenueCode_FL42_21] [varchar](10) NULL,
	[Description_FL43_21] [varchar](50) NULL,
	[HCPCS_FL44_21] [varchar](25) NULL,
	[DOSFrom_FL45_21] [varchar](10) NULL,
	[Units_FL46_21] [varchar](5) NULL,
	[Charges_FL47_21] [money] NULL,
	[NonCoveredCharges_FL48_21] [money] NULL,
	[RevenueCode_FL42_22] [varchar](10) NULL,
	[Description_FL43_22] [varchar](50) NULL,
	[HCPCS_FL44_22] [varchar](25) NULL,
	[DOSFrom_FL45_22] [varchar](10) NULL,
	[Units_FL46_22] [varchar](5) NULL,
	[Charges_FL47_22] [money] NULL,
	[NonCoveredCharges_FL48_22] [money] NULL,
	[ClaimBatchUID] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UB04ClaimUId] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UnlinkedDocument]') AND type in (N'U'))
BEGIN
CREATE TABLE [UnlinkedDocument](
	[UnlinkedDocumentUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_UnlinkedDocument_UnlinkedDocumentUid]  DEFAULT (newid()),
	[AttachmentUid] [uniqueidentifier] NOT NULL,
	[DocumentLinkingFolderTypeUid] [uniqueidentifier] NOT NULL,
	[UnlinkedDocumentLinkingLockUid] [uniqueidentifier] NULL,
	[RejectedByUid] [uniqueidentifier] NULL,
	[MessageUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_UnlinkedDocument_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_UnlinkedDocument_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_UnlinkedDocument_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UnlinkedDocumentLinkingLock]') AND type in (N'U'))
BEGIN
CREATE TABLE [UnlinkedDocumentLinkingLock](
	[UnlinkedDocumentLinkingLockUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[LockDateStart] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UserGroupMember]') AND type in (N'U'))
BEGIN
CREATE TABLE [UserGroupMember](
	[ExtentUserGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_UserGroupMember_ExtentUserGroupUid]  DEFAULT (newid()),
	[UserGroupUid] [uniqueidentifier] NOT NULL,
	[MemberUserUid] [uniqueidentifier] NULL,
	[MemberUserGroupUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_UserGroupMember_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_UserGroupMember_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UserMessageDefault]') AND type in (N'U'))
BEGIN
CREATE TABLE [UserMessageDefault](
	[UserMessageDefaultUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_UserMessageDefault_UserMessageDefaultUid]  DEFAULT (newid()),
	[UserUid] [uniqueidentifier] NOT NULL,
	[MessageTypeUid] [uniqueidentifier] NULL,
	[MessageSubTypeUid] [uniqueidentifier] NULL,
	[Defaults] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_UserMessageDefault_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UserPRM]') AND type in (N'U'))
BEGIN
CREATE TABLE [UserPRM](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_UserPRM_InActive]  DEFAULT ((0)),
	[ExternalID] [varchar](25) NULL,
	[Login] [varchar](50) NULL,
	[LocalLogin] [varchar](50) NULL,
	[SID] [varchar](100) NULL,
	[LocalSID] [varchar](100) NULL,
	[Settings] [xml] NULL,
	[UserSettingUid] [uniqueidentifier] NULL,
	[InstantMessageStatusUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_UserPRM_InstantMessageStatusUid]  DEFAULT ('5004E771-4FFD-4095-9ED2-BE38E690B70D'),
	[Initials] [varchar](25) NULL,
	[DefaultProviderUid] [uniqueidentifier] NULL,
	[ICSSigLicense] [bit] NOT NULL CONSTRAINT [DF_UserPRM_ICSSigLicense_1]  DEFAULT ((0)),
	[AprimaMobileLicense] [bit] NOT NULL CONSTRAINT [DF_UserPRM_AprimaMobileLicense_1]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_UserPRM_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_User_LastModifiedByDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LicensedHealthcareProfessional] [bit] NOT NULL CONSTRAINT [DF_UserPRM_LicensedHealthcareProfessional]  DEFAULT ((0)),
	[LicensedCPOCCMProfessional] [bit] NOT NULL CONSTRAINT [DF_UserPRM_LicensedCPOCCMProfessional]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[UserSession]') AND type in (N'U'))
BEGIN
CREATE TABLE [UserSession](
	[UserSessionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[ComputerName] [varchar](255) NULL,
	[SessionStartDate] [datetime] NULL,
	[SessionInfo] [varchar](7000) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VaccineAdminItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [VaccineAdminItem](
	[VaccineAdminItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table_1_VaccineItemUid]  DEFAULT (newid()),
	[VaccineAdminUid] [uniqueidentifier] NULL,
	[Tradename] [varchar](250) NULL,
	[VaccineUid] [uniqueidentifier] NULL,
	[MiscUid] [uniqueidentifier] NULL,
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_VaccineAdminItem_Inactive]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VaccineAdminItem_DisplayOrder]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_VaccineAdminItem_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VaccineAdminItem_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VaccineScheduleItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [VaccineScheduleItem](
	[VaccineScheduleItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RoutineType] [bit] NOT NULL,
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[DoseNum] [int] NOT NULL,
	[OccursAtVal] [int] NOT NULL,
	[OccursAtSpanUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VaccineUnitUse]') AND type in (N'U'))
BEGIN
CREATE TABLE [VaccineUnitUse](
	[VaccineUnitUseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VaccineUnitUse_VaccineUnitUseUid]  DEFAULT (newid()),
	[NDCInnerID] [float] NULL,
	[UseUnitLabeler] [varchar](255) NULL,
	[UseUnitProduct] [varchar](255) NULL,
	[UseUnitPackage] [varchar](255) NULL,
	[UseUnitPropName] [varchar](255) NULL,
	[UseUnitGenericName] [varchar](255) NULL,
	[UseUnitLabelerName] [varchar](255) NULL,
	[UseUnitstartDate] [varchar](255) NULL,
	[UseUnitEndDate] [varchar](255) NULL,
	[UseUnitPackForm] [varchar](255) NULL,
	[UseUnitGTIN] [varchar](255) NULL,
	[CVXCode] [varchar](255) NULL,
	[CVXShortDescription] [varchar](255) NULL,
	[NoInner] [bit] NOT NULL,
	[NDC11] [varchar](255) NULL,
	[LastUpdatedDate] [datetime] NULL,
	[GTIN] [varchar](255) NULL,
	[MVX] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_VaccineUnitUse_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_VaccineUnitUse_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VaccineUnitUse_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VersionPRM]') AND type in (N'U'))
BEGIN
CREATE TABLE [VersionPRM](
	[PRMVersion] [varchar](24) NOT NULL,
	[PRMSeq] [int] NOT NULL,
	[PRMBuild] [varchar](24) NULL,
	[ReleaseName] [varchar](50) NULL,
	[Vendor] [varchar](50) NULL,
	[Status] [int] NOT NULL CONSTRAINT [DF_VersionPRM_Status]  DEFAULT ((0)),
	[Message] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_VersionPRM_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VersionPRM_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[Visit]') AND type in (N'U'))
BEGIN
CREATE TABLE [Visit](
	[VisitUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Visit_VisitUid]  DEFAULT (newid()),
	[ClinicalNoteTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Visit_ClinicalNoteTypeUid]  DEFAULT ('10101010-1111-0000-0000-000000000001'),
	[AppointmentUid] [uniqueidentifier] NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[SuperbillRequired] [bit] NOT NULL CONSTRAINT [DF_Visit_SuperbillRequired]  DEFAULT ((1)),
	[VisitDate] [date] NOT NULL,
	[IsCompleted] [bit] NOT NULL CONSTRAINT [DF_Visit_IsCompleted]  DEFAULT ((0)),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[ProviderCareTypeUid] [uniqueidentifier] NULL,
	[RenderingProviderUid] [uniqueidentifier] NULL,
	[ProviderSignatureUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[ServiceSiteTypeUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[SupervisingProviderUid] [uniqueidentifier] NULL,
	[Emergency] [bit] NOT NULL CONSTRAINT [DF_Visit_Emergency]  DEFAULT ((0)),
	[AuthorizationCode] [varchar](30) NULL,
	[ReferredByProviderUid] [uniqueidentifier] NULL,
	[ReferringDate] [date] NULL,
	[PETemplateUid] [uniqueidentifier] NULL,
	[OriginalPETemplateUid] [uniqueidentifier] NULL,
	[CosignStatusID] [smallint] NOT NULL CONSTRAINT [DF_Visit_CosignStatusID]  DEFAULT ((0)),
	[VoiceAttachmentUid] [uniqueidentifier] NULL,
	[CaseTypePhaseUid] [uniqueidentifier] NULL,
	[CompletedDate] [datetime] NULL,
	[ABN] [bit] NOT NULL CONSTRAINT [DF_Visit_ABN]  DEFAULT ((0)),
	[VisitTypeUid] [uniqueidentifier] NULL,
	[DefaultStartTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[DefaultEndTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[DFTQueuedDateTime] [datetime] NULL,
	[ObservationTemplates] [xml](CONTENT [UidList]) NULL,
	[HistorianUid] [uniqueidentifier] NULL,
	[PatientDeclinedClinicalSummary] [bit] NOT NULL CONSTRAINT [DF_Visit_PatientDeclinedClinicalSummary]  DEFAULT ((0)),
	[HistorianRepName] [varchar](40) NULL,
	[LastSavedByUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Visit_LastModifiedDate]  DEFAULT (getutcdate()),
	[SavedByBillingProvider] [bit] NULL CONSTRAINT [DF_Visit_SavedByBillingProvider]  DEFAULT ((0)),
	[SavedByRenderingProvider] [bit] NULL CONSTRAINT [DF_Visit_SavedByRenderingProvider]  DEFAULT ((0)),
	[IsEM] [bit] NOT NULL CONSTRAINT [DF_Visit_IsEM]  DEFAULT ((0)),
	[HasPerformedProcedure] [bit] NOT NULL CONSTRAINT [DF_Visit_HasPerformedProcedures]  DEFAULT ((0))
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitAccess]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitAccess](
	[VisitAccessUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitAssessmentForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitAssessmentForm](
	[VisitAssessmentFormUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[AssessmentFormUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[Data] [xml] NULL,
	[Text] [varchar](max) NULL,
	[ObservationOrderUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitCC]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitCC](
	[VisitCCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitDtl_RowGuid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[RelCCSystemSymptomUid] [uniqueidentifier] NULL,
	[CCSystemUid] [uniqueidentifier] NOT NULL,
	[CCSystemName] [varchar](100) NULL,
	[CCSymptomUid] [uniqueidentifier] NOT NULL,
	[CCSymptomName] [varchar](100) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitCC_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[FollowupFlag] [smallint] NULL,
	[NeedToReview] [bit] NOT NULL CONSTRAINT [DF_VisitCC_NeedToReview]  DEFAULT ((0)),
	[ProviderReviewed] [bit] NOT NULL CONSTRAINT [DF_VisitCC_ProviderReviewed]  DEFAULT ((0)),
	[Preposition] [varchar](25) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitCC_IsDeleted]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitCC_IsAddendum]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitCC_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitComment]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitComment](
	[VisitCommentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitComment_VisitCommentUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[CCComment] [varchar](max) NULL,
	[HpiComment] [varchar](max) NULL,
	[RosComment] [varchar](max) NULL,
	[PEComment] [varchar](max) NULL,
	[DXComment] [varchar](max) NULL,
	[RXComment] [varchar](max) NULL,
	[SPComment] [varchar](max) NULL,
	[SOComment] [varchar](max) NULL,
	[PhysicianComment] [varchar](max) NULL,
	[PlanComment] [varchar](max) NULL,
	[EduFormComment] [varchar](max) NULL,
	[PatientInstruction] [varchar](max) NULL,
	[VitalComment] [varchar](max) NULL,
	[VisitComment] [varchar](max) NULL,
	[GeneralComment] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitComment_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitComment_LastModifiedDate]  DEFAULT (getutcdate()),
	[VisitTypeComment] [varchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitCommentExtension]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitCommentExtension](
	[VisitUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ConfidentialNote] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitCommentExtension_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitComplexity]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitComplexity](
	[VisitUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[InsuranceChanged] [bit] NOT NULL CONSTRAINT [DF_VisitComplexity_InsuranceChanged]  DEFAULT ((0)),
	[AddressChanged] [bit] NOT NULL CONSTRAINT [DF_VisitComplexity_AddressChanged]  DEFAULT ((0)),
	[OtherInfo] [varchar](50) NULL,
	[PmhReviewed] [bit] NOT NULL CONSTRAINT [DF_VisitComplexity_PmhReviewed]  DEFAULT ((0)),
	[FhReviewed] [bit] NOT NULL CONSTRAINT [DF_VisitComplexity_FhReviewed]  DEFAULT ((0)),
	[ShReviewed] [bit] NOT NULL CONSTRAINT [DF_VisitComplexity_ShReviewed]  DEFAULT ((0)),
	[PlaceCode] [varchar](10) NULL,
	[VisitTypeID] [int] NULL,
	[CategoryTypeID] [int] NULL,
	[TypeOfService] [smallint] NOT NULL CONSTRAINT [DF_VisitComplexity_TypeOfService]  DEFAULT ((0)),
	[LevelOfCare] [int] NULL,
	[CalculatedLevelOfService] [int] NOT NULL CONSTRAINT [DF_VisitComplexity_CalculatedLevelOfService]  DEFAULT ((0)),
	[BasedOnTypeID] [smallint] NULL,
	[FaceToFaceTime] [int] NULL,
	[CounselingTime] [int] NULL,
	[PlaceOfServiceDetail] [smallint] NULL CONSTRAINT [DF_VisitComplexity_PlaceOfServiceDetail]  DEFAULT ((0)),
	[CounselingDescription] [varchar](max) NULL,
	[ConfirmTimeLevel] [int] NULL,
	[DocumentMdmDx1] [int] NULL,
	[DocumentMdmDx2] [int] NULL,
	[DocumentMdmDx3] [int] NULL,
	[DocumentMdmDx4] [int] NULL,
	[DocumentMdmDx5] [int] NULL,
	[DocumentMdmData1] [int] NULL,
	[DocumentMdmData2] [int] NULL,
	[DocumentMdmData3] [int] NULL,
	[DocumentMdmData4] [int] NULL,
	[DocumentMdmData5] [int] NULL,
	[DocumentMdmData6] [int] NULL,
	[DocumentMdmData7] [int] NULL,
	[DocumentMdmRisk] [int] NULL,
	[DocumentMdmSelect] [int] NULL,
	[DocumentMdmBasedOn] [smallint] NULL,
	[DocumenConfirmLevel] [int] NULL,
	[DocumentMdmPeComprehensive] [int] NULL,
	[HpiCount] [int] NULL,
	[MedicalChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_MedicalChecked]  DEFAULT ((0)),
	[InfectionChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_InfectionChecked]  DEFAULT ((0)),
	[SurgeryChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_SurgeryChecked]  DEFAULT ((0)),
	[FamilyChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_FamilyChecked]  DEFAULT ((0)),
	[GeneticChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_GeneticChecked]  DEFAULT ((0)),
	[SocialChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_SocialChecked]  DEFAULT ((0)),
	[MedicationChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_MedicationChecked]  DEFAULT ((0)),
	[FoodAllergyChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_AllergyChecked]  DEFAULT ((0)),
	[DrugAllergyChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_DrugAllergyChecked]  DEFAULT ((0)),
	[EnvtAllergyChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_EnvtAllergyChecked]  DEFAULT ((0)),
	[ImmunizationChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_ImmunizationChecked]  DEFAULT ((0)),
	[SpecialtyQAChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_SpecialtyQAChecked]  DEFAULT ((0)),
	[MenstrualChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_MenstrualChecked]  DEFAULT ((0)),
	[PregnancyChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_PregnancyChecked]  DEFAULT ((0)),
	[ProblemDiagnosisChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_ProblemDiagnosisChecked]  DEFAULT ((0)),
	[VitalsChecked] [smallint] NULL CONSTRAINT [DF_VisitComplexity_VitalsChecked]  DEFAULT ((0)),
	[TransitionOfCare] [bit] NULL CONSTRAINT [DF_VisitComplexity_HasBeenSeenByAnotherProvider]  DEFAULT ((0)),
	[HistoryManualLevel] [smallint] NULL,
	[PEManualLevel] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitComplexity_LastModifiedDate]  DEFAULT (getutcdate()),
	[CustomHistoryChecked] [xml] NULL,
	[IsNewNote] [bit] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitCoSign]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitCoSign](
	[VisitCoSignUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitCoSign_RowGuid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[CosignUid] [uniqueidentifier] NOT NULL,
	[CompletedUid] [uniqueidentifier] NOT NULL,
	[CosignSignatureUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_VisitCoSign_Inactive]  DEFAULT ((0)),
	[ForwardDate] [datetime] NULL,
	[IsCompleted] [bit] NOT NULL CONSTRAINT [DF_VisitCoSign_IsCompleted]  DEFAULT ((0)),
	[IsApproved] [smallint] NOT NULL CONSTRAINT [DF_VisitCoSign_IsApproved]  DEFAULT ((0)),
	[IsMessage] [bit] NOT NULL CONSTRAINT [DF_VisitCoSign_IsMessage]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitCoSign_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitData]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitData](
	[VisitUid] [uniqueidentifier] NOT NULL,
	[Data] [xml] NULL,
	[Comment] [xml] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitData_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitDiagnosis](
	[VisitDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitDiagnosis_RowGuid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[DiagnosisPanelUid] [uniqueidentifier] NULL,
	[ProblemGroupingUid] [uniqueidentifier] NULL,
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] NULL,
	[Code] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[FollowupFlag] [smallint] NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[AddendumNotes] [varchar](max) NULL,
	[DSMAxis] [varchar](250) NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DpnXml] [xml] NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_LifeLong]  DEFAULT ((0)),
	[SortToBottom] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_SortToBottom]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_IsDelete]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_IsAddendum]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()),
	[HccModelCat] [int] NULL,
	[LexicalCode] [int] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitDiet]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitDiet](
	[VisitDietUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table_2_VisitExersiceUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[DietUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitDiet_DisplayOrder]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitDiet_IsDelete]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitDiet_IsAddendum]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitDiet_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitEduForm]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitEduForm](
	[VisitEduFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitEduForm_VisitEduFormUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[EduFormUid] [uniqueidentifier] NULL,
	[MedicationSIGUid] [uniqueidentifier] NULL,
	[ReportUid] [uniqueidentifier] NULL,
	[ReleaseProviderUid] [uniqueidentifier] NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitEduForm_IsDelete]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitEduForm_IsAddendum]  DEFAULT ((0)),
	[IsAssociationAdded] [bit] NOT NULL CONSTRAINT [DF_VisitEduForm_IsAssociationAdded]  DEFAULT ((0)),
	[PrintedDate] [datetime] NULL,
	[PrintedUserUid] [uniqueidentifier] NULL,
	[AddendumNotes] [varchar](max) NULL,
	[LDM_TransactionId] [int] NULL,
	[LDM_ProgramId] [int] NULL,
	[Data] [varbinary](max) NULL,
	[DataContentType] [varchar](25) NULL,
	[PatientCommunications] [xml](CONTENT [UidList]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitEduForm_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitExercise]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitExercise](
	[VisitExerciseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitExercise_VisitExerciseUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[ExerciseUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitExercise_DisplayOrder]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitExercise_IsDelete]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitExercise_IsAddendum]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitExercise_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitGraphicNotes]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitGraphicNotes](
	[VisitGraphicNotesUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[ImageContent] [varbinary](max) NULL,
	[BackGroundImageUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitHpi]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitHpi](
	[VisitHpiUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitHpi_RowGuid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[CCSystemUid] [uniqueidentifier] NULL,
	[CCSymptomUid] [uniqueidentifier] NOT NULL,
	[HpiCategoryUid] [uniqueidentifier] NOT NULL,
	[HpiUid] [uniqueidentifier] NOT NULL,
	[CCSymptomName] [varchar](100) NULL,
	[HpiCategoryName] [varchar](100) NULL,
	[HpiName] [varchar](255) NULL,
	[CCSymptomDisplayOrder] [int] NULL,
	[HpiCategoryDisplayOrder] [int] NULL,
	[HpiDisplayOrder] [int] NULL,
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[FollowupFlag] [smallint] NULL,
	[NeedToReview] [bit] NOT NULL CONSTRAINT [DF_VisitHpi_NeedToReview]  DEFAULT ((0)),
	[ProviderReviewed] [bit] NOT NULL CONSTRAINT [DF_VisitHpi_ProviderReviewed]  DEFAULT ((0)),
	[Denies] [bit] NOT NULL CONSTRAINT [DF_VisitHpi_Denies]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitHpi_IsDeleted]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitHpi_IsAddendum]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitHpi_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitOutsideProvider]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitOutsideProvider](
	[VisitOutsideProviderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitOutsideProvider_VisitOutsideProviderUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitOutsideProvider_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitOutsideProvider_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitPE]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitPE](
	[VisitPEUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitPE_RowGuid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[PETemplateUid] [uniqueidentifier] NOT NULL,
	[PEParentSystemUid] [uniqueidentifier] NOT NULL,
	[PESystemUid] [uniqueidentifier] NOT NULL,
	[PESymptomUid] [uniqueidentifier] NOT NULL,
	[PEDescriptionUid] [uniqueidentifier] NOT NULL,
	[RelEMKeyComponentBulletUid] [uniqueidentifier] NULL,
	[PETemplateName] [varchar](100) NULL,
	[PEParentSystemName] [varchar](100) NULL,
	[PESystemName] [varchar](100) NULL,
	[PESymptomName] [varchar](100) NULL,
	[PEDescriptionName] [varchar](255) NULL,
	[IsPEParentSystemBilateral] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsPEParentSystemBilateral]  DEFAULT ((0)),
	[IsPESystemBilateral] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsPESystemBilateral]  DEFAULT ((0)),
	[IsPESymptomBilateral] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsPESymptomBilateral]  DEFAULT ((0)),
	[PESystemColorID] [smallint] NULL CONSTRAINT [DF_VisitPE_PESystemColorID]  DEFAULT ((0)),
	[NormalFlag] [bit] NOT NULL CONSTRAINT [DF_VisitPE_NormalFlag]  DEFAULT ((0)),
	[FollowupFlag] [smallint] NULL,
	[PEParentSystemDisplayOrder] [int] NULL,
	[PESystemDisplayOrder] [int] NULL,
	[PESymptomDisplayOrder] [int] NULL,
	[PEDescriptionDisplayOrder] [int] NULL,
	[BilateralityValue] [smallint] NULL CONSTRAINT [DF_VisitPE_BilateralityValue]  DEFAULT ((0)),
	[CountAsBullet] [bit] NULL CONSTRAINT [DF_VisitPE_CountAsBullet]  DEFAULT ((1)),
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_VisitPE_LifeLong_1]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsDeleted]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsAddendum]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitPE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitPlan]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitPlan](
	[VisitUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FUAppointmentUid] [uniqueidentifier] NULL,
	[ReturnNum] [int] NULL,
	[ReturnUnitID] [int] NULL,
	[ExcerciseStyleID] [int] NULL,
	[PrnText] [varchar](50) NULL,
	[SymptomText] [varchar](50) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_VisitPlan_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitPlan_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitPlanDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitPlanDiagnosis](
	[VisitPlanDiagnosisUid] [uniqueidentifier] NOT NULL,
	[VisitDiagnosisUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DataXML] [xml] NULL,
	[TextXML] [xml] NULL,
	[DisplayOrder] [int] NOT NULL,
	[RecallUid] [uniqueidentifier] NULL,
	[Exclude] [bit] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitProcedure]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitProcedure](
	[VisitProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitProcedure_VisitProcedureUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[ProcedureCategoryUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[ProcedureModifier1Uid] [uniqueidentifier] NULL,
	[ProcedureModifier2Uid] [uniqueidentifier] NULL,
	[ProcedureModifier3Uid] [uniqueidentifier] NULL,
	[ProcedureModifier4Uid] [uniqueidentifier] NULL,
	[ProcedurePanelUid] [uniqueidentifier] NULL,
	[Code] [varchar](30) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitProcedure_DisplayOrder]  DEFAULT ((0)),
	[Unit] [int] NULL,
	[PatientImmunizationUid] [uniqueidentifier] NULL,
	[IsPerformed] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_IsPerformed]  DEFAULT ((0)),
	[IsEM] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_IsEM_1]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_IsDeleted]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_IsAddendum]  DEFAULT ((0)),
	[ServiceSiteTypeUid] [uniqueidentifier] NULL,
	[UserDefinedTemplateUid] [uniqueidentifier] NULL,
	[AddToHistoryGroupUid] [uniqueidentifier] NULL,
	[UserDefinedProcedureNoteText] [varchar](max) NULL,
	[UserDefinedProcedureNoteXml] [varchar](max) NULL,
	[GlobalPeriodDays] [int] NULL,
	[PQRIMeasureUid] [uniqueidentifier] NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DpnXml] [xml] NULL,
	[DpnOrderActionSaveFlag] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_DpnOrderActionSaveFlag]  DEFAULT ((0)),
	[DpnOrderActionCompleteFlag] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_DpnOrderActionCompleteFlag]  DEFAULT ((0)),
	[DpnOrderActionSendFlag] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_DpnOrderActionSendFlag]  DEFAULT ((0)),
	[DpnOrderActionCloseFlag] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_DpnOrderActionCloseFlag]  DEFAULT ((0)),
	[ReimbursementRuleTriggerUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[ReimbursementRuleDiagnosis] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_ReimbursementRuleDiagnosis]  DEFAULT ((0)),
	[ReimbursementRuleOverride] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_ReimbursementRuleOverride]  DEFAULT ((0)),
	[BillStartTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillEndTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillTransportOdoStart] [float] NULL,
	[BillTransportOdoEnd] [float] NULL,
	[BillOdometerXml] [xml] NULL,
	[BillTimeXml] [xml] NULL,
	[ABNStatusUid] [uniqueidentifier] NULL,
	[ABNEstimatedFee] [money] NOT NULL CONSTRAINT [DF_VisitProcedure_ABNEstimatedFee]  DEFAULT ((0)),
	[OrderInfo] [xml](CONTENT [OrderInfoData]) NULL,
	[OrderAQNData] [xml] NULL,
	[SortToBottom] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_SortToBottom]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitProcedureDiagnosis]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitProcedureDiagnosis](
	[VisitProcedureDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitProcedureDiagnosis_VisitProcedureDiagnosisUid]  DEFAULT (newid()),
	[VisitProcedureUid] [uniqueidentifier] NOT NULL,
	[VisitDiagnosisUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitProcedureDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_VisitProcedureDiagnosis_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitProcedureDiagnosis_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitProcedureOrderAction]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitProcedureOrderAction](
	[VisitProcedureOrderActionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NOT NULL,
	[RelDpnGroupOrderActionUid] [uniqueidentifier] NOT NULL,
	[MessageUid] [uniqueidentifier] NULL,
	[FaxQueueUid] [uniqueidentifier] NULL,
	[OrderActionXml] [xml] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[RelAttachmentGroupUid] [uniqueidentifier] NULL,
	[PrintFlag] [bit] NULL,
	[FailureOrderActionType] [tinyint] NULL,
	[FailureOrderActionUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitRos]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitRos](
	[VisitRosUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitRos_VisitRosUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[RosSystemUid] [uniqueidentifier] NOT NULL,
	[RosSymptomUid] [uniqueidentifier] NOT NULL,
	[RosSystemName] [varchar](100) NULL,
	[RosSymptomName] [varchar](100) NULL,
	[RosSystemDisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitRos_RosSystemDisplayOrder]  DEFAULT ((0)),
	[RosSystemSystemDisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitRos_RosSystemSystemDisplayOrder]  DEFAULT ((0)),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitRos_DisplayOrder]  DEFAULT ((0)),
	[DenyFlag] [bit] NOT NULL CONSTRAINT [DF_VisitRos_DenyFlag]  DEFAULT ((0)),
	[AllNormalFlag] [bit] NOT NULL CONSTRAINT [DF_VisitRos_AllNormalFlag]  DEFAULT ((0)),
	[FollowupFlag] [smallint] NULL,
	[NeedToReview] [bit] NOT NULL CONSTRAINT [DF_VisitRos_NeedToReview]  DEFAULT ((0)),
	[ProviderReviewed] [bit] NOT NULL CONSTRAINT [DF_VisitRos_ProviderReviewed]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitRos_IsDeleted]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitRos_IsAddendum]  DEFAULT ((0)),
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_VisitRos_IsPatientInput]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitRos_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitTranscription]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitTranscription](
	[VisitTranscriptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[RecordTypeID] [smallint] NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[AttachmentUid] [uniqueidentifier] NULL,
	[TranscriptionistUid] [uniqueidentifier] NULL,
	[Urgent] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitVoiceAttachment]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitVoiceAttachment](
	[VisitVoiceAttachmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[RecordTypeID] [smallint] NULL,
	[DisplayOrder] [int] NOT NULL,
	[VoiceContent] [varbinary](max) NULL,
	[RecordByUid] [uniqueidentifier] NULL,
	[AssignToUid] [uniqueidentifier] NULL,
	[Urgent] [bit] NOT NULL,
	[DateRecorded] [datetime] NULL,
	[DateSent] [datetime] NULL,
	[DateReceived] [datetime] NULL,
	[TranscribedFilename] [varchar](255) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VisitWatchItem]') AND type in (N'U'))
BEGIN
CREATE TABLE [VisitWatchItem](
	[VisitWatchItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Inactive] [bit] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VitalMinMax]') AND type in (N'U'))
BEGIN
CREATE TABLE [VitalMinMax](
	[VitalMinMaxUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ObservationItemUid] [uniqueidentifier] NOT NULL,
	[AgeFromInMonths] [int] NULL,
	[AgeFromIsYear] [bit] NOT NULL,
	[AgeToInMonths] [int] NULL,
	[AgeToIsYear] [bit] NOT NULL,
	[Min1] [decimal](14, 6) NULL,
	[Max1] [decimal](14, 6) NULL,
	[Min2] [decimal](14, 6) NULL,
	[Max2] [decimal](14, 6) NULL,
	[UserDefined] [tinyint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VoiceAttachment]') AND type in (N'U'))
BEGIN
CREATE TABLE [VoiceAttachment](
	[AttachmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Urgent] [bit] NOT NULL CONSTRAINT [DF_VoiceAttachment_Urgent]  DEFAULT ((0)),
	[DictationToTranscribedId] [varchar](50) NULL,
	[RecordedByUid] [uniqueidentifier] NULL,
	[TranscriptionistUid] [uniqueidentifier] NULL,
	[ReadyToTranscribe] [bit] NOT NULL CONSTRAINT [DF_VoiceAttachment_ReadyToTranscribe]  DEFAULT ((0)),
	[InNoteDictation] [bit] NOT NULL CONSTRAINT [DF_VoiceAttachment_InNoteDictation]  DEFAULT ((0)),
	[DateRecorded] [datetime] NULL CONSTRAINT [DF_VoiceAttachment_DateRecorded]  DEFAULT (getutcdate()),
	[DateSent] [datetime] NULL,
	[DateReceived] [datetime] NULL,
	[DateMerged] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VoiceAttachment_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[WaitingList]') AND type in (N'U'))
BEGIN
CREATE TABLE [WaitingList](
	[WaitingListUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_WaitingList_WaitingListUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_WaitingList_Inactive]  DEFAULT ((0)),
	[Name] [varchar](250) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_WaitingList_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[WaitingListDetail]') AND type in (N'U'))
BEGIN
CREATE TABLE [WaitingListDetail](
	[WaitingListDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_WaitingListDetail_WaitingListDetailUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_WaitingListDetail_Inactive]  DEFAULT ((0)),
	[StartDateTime] [datetime] NULL,
	[EndDateTime] [datetime] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Phone] [xml](CONTENT [Phone]) NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[AppointmentTypeUid] [uniqueidentifier] NULL,
	[WaitingListPriorityUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[ExpiredOn] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_WaitingListDetail_LastCreatedDate]  DEFAULT (getutcdate()),
	[Notes] [varchar](max) NULL,
	[AppointmentUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_WaitingListDetail_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[WebRegistration]') AND type in (N'U'))
BEGIN
CREATE TABLE [WebRegistration](
	[WebRegistrationUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[EmailAddress] [varchar](100) NULL,
	[PhoneNumber] [varchar](80) NULL,
	[BirthDate] [datetime] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[IsExpired] [bit] NOT NULL,
	[IsPasswordReset] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'AccessCode', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccessCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EnsureExternalId' , N'SCHEMA',N'dbo', N'TABLE',N'Account', N'COLUMN',N'ExternalID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.EnsureExternalId', @value=1 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account', @level2type=N'COLUMN',@level2name=N'ExternalID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Account', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of account. Pairs of Name, PersonID should be unique.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Account', N'COLUMN',N'PersonUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient or person who owns this account.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account', @level2type=N'COLUMN',@level2name=N'PersonUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Account', N'COLUMN',N'AccountResponsiblePartyUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Person or Corporation responsible for payments on this account.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account', @level2type=N'COLUMN',@level2name=N'AccountResponsiblePartyUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Account', N'COLUMN',N'ResponsiblePartyRelationshipUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Added for HL7 compatablility? NOT used for billing & claiming (see instead the AccountInsurance.RelationshipUid column which is used for claiming)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account', @level2type=N'COLUMN',@level2name=N'ResponsiblePartyRelationshipUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Account', N'COLUMN',N'IsMain'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Main (default) account indicator for each personID. ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account', @level2type=N'COLUMN',@level2name=N'IsMain'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Account', N'COLUMN',N'CycleTrigger'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 if a statement for this account should be printed on the next statement run. New account activity can trigger this.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account', @level2type=N'COLUMN',@level2name=N'CycleTrigger'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Account', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A financial account. At least one account per unmerged patient, though non-patients can also have accounts. Designed for family level billing by billing across all accounts with a common responsible party. the 6 balance fields are TO BE REMOVED as the by-FinancialCenter settings in table AccountBalance should be used eventually.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'Account', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_Account_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Provider' , N'SCHEMA',N'dbo', N'TABLE',N'Account', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'!FK_Appointment_Account' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Account'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', N'COLUMN',N'PersonInsurancePlanUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reference to the PersonInsurancePlan record (no longer shared) representing the insured party along with one of their insurances.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance', @level2type=N'COLUMN',@level2name=N'PersonInsurancePlanUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', N'COLUMN',N'AccountPeriodUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The AccountPeriod for this AccountInsurance.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance', @level2type=N'COLUMN',@level2name=N'AccountPeriodUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', N'COLUMN',N'DisplayOrder'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 for primary insurance, 2 for secondary insurance, and so on.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', N'COLUMN',N'RelationshipUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The patient''s relationship to the insured party.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance', @level2type=N'COLUMN',@level2name=N'RelationshipUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', N'COLUMN',N'PolicyNumberSuffix'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'NO LONGER USED, since we no longer share PersonInsurancePlans. Appended to the InsuranceEnrollment.PlanMemberID to determine the patient''s MemberID.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance', @level2type=N'COLUMN',@level2name=N'PolicyNumberSuffix'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', N'COLUMN',N'ParentAccountInsuranceUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'This is an alternate account insurance record, needs to be kept in sync with parent.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance', @level2type=N'COLUMN',@level2name=N'ParentAccountInsuranceUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Represents one insurance (primary, secondary, etc.) within a particular AccountPeriod for an Account. Note that the referenced PersonInsurancePlan may be shared among various patients, typically dependents.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_AccountInsurance_AccountPeriod,FK_AccountInsurance_PersonInsurancePlan}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'SaveTrigger' , N'SCHEMA',N'dbo', N'TABLE',N'AccountInsurance', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'SaveTrigger', @value=N'AggregateTrigger' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountInsurance'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountPeriod', N'COLUMN',N'AccountUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Account using this AccountPeriod.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountPeriod', @level2type=N'COLUMN',@level2name=N'AccountUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountPeriod', N'COLUMN',N'EffectiveDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Effective date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountPeriod', @level2type=N'COLUMN',@level2name=N'EffectiveDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountPeriod', N'COLUMN',N'ExpirationDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Termination date, or null for open ended.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountPeriod', @level2type=N'COLUMN',@level2name=N'ExpirationDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountPeriod', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Distinct (nonoverlapping) time periods within accounts.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountPeriod'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', N'COLUMN',N'PersonUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Responsible Person, if set. If not set (null), then CorporationID must be set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'PersonUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', N'COLUMN',N'CorporationUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Responsible Corporation, if set. If not set (null), then PersonUid must be set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'CorporationUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', N'COLUMN',N'SendStatement'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag to enable sending statements.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'SendStatement'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', N'COLUMN',N'CycleTrigger'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag to force inclusion in the next statement cycle.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'CycleTrigger'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', N'COLUMN',N'DunningOn'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag to enable dunning on statements.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'DunningOn'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', N'COLUMN',N'DunningLevel'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last dunning level used on a statement. As appropriate, this will be incremented before a new statement is generated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'DunningLevel'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EnsureExternalId' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', N'COLUMN',N'ExternalID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.EnsureExternalId', @value=1 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'ExternalID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Responsible party, a person or corporation, for family billing of accounts. SendStatement, MinimumPaymentDue, 	PlanInitiationDate, DunningOn, and DunningLevel TO BE REMOVED as the by-FinancialCenter settings in table AccountResponsiblePartySettings should be used eventually.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_Account_AccountResponsibleParty' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'SendPaperlessStatements' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'SendPaperlessStatements', @value=N'<System value="0" /><Yes value="1" /><No value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'SendStatement' , N'SCHEMA',N'dbo', N'TABLE',N'AccountResponsibleParty', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'SendStatement', @value=N'<System value="0" /><Yes value="1" /><No value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccountResponsibleParty'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'AppointmentStatusUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'AppointmentStatusUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EnsureExternalId' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'ExternalID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.EnsureExternalId', @value=N'True' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'ExternalID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'CreatedDateTime'))
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'CreatedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ListCalendar' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ListCalendar', @value=N'FK_Appointment_ListCalendar;PatientUid=NULL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_Appointment_Patient,FK_Appointment_Account,FK_RelGroupAppointmentPatient_Appointment}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Provider' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'FK_Appointment_Provider;PatientUid=NULL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.RootTableOfNonAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ScheduleType' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'ScheduleType', @value=N'<PatientVisit value="0" description="Patient Visit" /><Event value="1" description="Event" /><BlockingEvent value="2" description="Blocking Event" /><GroupVisit value="3" description="Group Visit" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'AR_Ledger', N'COLUMN',N'EntryType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0-Payment; 1-Charge; 2-Distribution; 3-Adjustment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AR_Ledger', @level2type=N'COLUMN',@level2name=N'EntryType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'AR_Ledger', N'COLUMN',N'CreatedDateTime'))
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'CreatedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AR_Ledger', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'EntryType' , N'SCHEMA',N'dbo', N'TABLE',N'AR_Ledger', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'EntryType', @value=N'<Payment value="0" /><Charge value="1" /><Distribution value="2" /><Adjustment value="3" /><Transfer value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AR_Ledger'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'AR_Ledger', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_AR_LedgerDetail_AR_Ledger' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AR_Ledger'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'AR_Ledger', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AR_Ledger'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'AR_LedgerDetail', N'COLUMN',N'CreatedDateTime'))
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'CreatedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AR_LedgerDetail', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'AR_LedgerDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_AR_LedgerDetail_SuperbillProcedure' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AR_LedgerDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'AR_LedgerDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AR_LedgerDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'SaveTrigger' , N'SCHEMA',N'dbo', N'TABLE',N'AR_LedgerDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'SaveTrigger', @value=N'AggregateTrigger' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=