SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSeed]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[GetSeed] AS' 
END
GO

ALTER PROC [dbo].[GetSeed]  -- by LGodolphin 8/16/05

  @SeedName varchar(255)

AS
BEGIN

DECLARE @SeedValue int
DECLARE @SeedTran varchar (20)
SELECT @SeedTran = 'seed_tran'

SELECT @SeedValue = SeedValue FROM SeedTable WHERE (SeedName = @SeedName)

IF (@SeedValue is NULL)
  BEGIN
    BEGIN TRANSACTION @SeedTran 
	INSERT INTO SeedTable 
	(
		SeedName,
		SeedValue
	) 
	VALUES 
	(
		@SeedName,
		1
	)

	SELECT @SeedValue = SeedValue FROM SeedTable WHERE (SeedName = @SeedName)
	--Print 'getSeed - New Seed: ' + convert(varchar(20), @SeedValue)
	COMMIT TRANSACTION @SeedTran
	RETURN @SeedValue
  END
ELSE 
  BEGIN
   BEGIN TRANSACTION @SeedTran		 
	UPDATE SeedTable 
		SET SeedValue = SeedValue + 1, LastModifiedDate = getutcdate()
		WHERE (SeedName = @SeedName)
	SELECT @SeedValue = SeedValue FROM SeedTable WHERE (SeedName = @SeedName)
	--Print 'getSeed - Update Seed: ' + convert(varchar(20), @SeedValue)
	COMMIT TRANSACTION @SeedTran
	RETURN @SeedValue
  END

END -- procedure

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetUniqueID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[GetUniqueID] AS' 
END
GO



ALTER PROC [dbo].[GetUniqueID] --by LGodolphin 08/16/05
@TableName 	varchar(255) = '',
@Constraint	varchar(255) = 'ExternalID'

AS
BEGIN

DECLARE 
@Seed		int,
@SeedString	varchar(80),
@Count		int,
@ParmDefinition nvarchar(255), 
@SQLString 	nvarchar(255)

--IF ((@TableName <> '') AND (EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[' + @TableName + ']') and OBJECTPROPERTY(id, N'IsUserTable') = 1)))
--BEGIN

  --print 'GetUniqueID - Begin'
  WHILE (@TableName<>'') 
  BEGIN
  
    EXEC @Seed = GetSeed @TableName
    SET @SeedString = CONVERT(varchar(80), @Seed)
    --print 'Seed: ' + @SeedString
    SET @ParmDefinition = N'@SeedValue varchar(80), @CountValue int OUT'
    SET @SQLString = N'SET @CountValue = (SELECT Count(*) FROM ' + @TableName + ' WHERE ' + @Constraint + ' = @SeedValue)'

    EXECUTE sp_executesql @SQLString, @ParmDefinition, @SeedValue = @SeedString,
                      @CountValue = @Count OUTPUT

      IF @Count = 0
        BEGIN
	  --print 'getUniqueID - Seed: ' + convert(varchar(20), @Seed)
	  SELECT @Seed as UniqueID
	  RETURN @Seed
	  BREAK
        END
  END --While

--END --IF @TableName<>''

END --Procedure




GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ManualCollectionStatusChange]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ManualCollectionStatusChange] AS' 
END
GO



ALTER PROCEDURE [dbo].[ManualCollectionStatusChange]
(
	@AccountResponsiblePartyUid		uniqueidentifier,
	@OldCollectionStatusUid				uniqueidentifier,
	@NewCollectionStatusUid				uniqueidentifier,
	@ChangedByUid									uniqueidentifier
)
AS
BEGIN
	DECLARE @Now															datetime
	SET @Now = GetUTCDate()

	DECLARE @CurrentCollectionStatusUid				uniqueidentifier
	DECLARE @CurrentCollectionStatusLevelUid	uniqueidentifier
	DECLARE @NewCollectionStatusLevelUid			uniqueidentifier
	DECLARE @CalculatedPaymentAmount					money
	DECLARE @IsExpireDayOfMonth								bit
	DECLARE @CurrentExpirationDate						datetime
	DECLARE @NewExpirationDate								datetime
	DECLARE @CurrentDateEnteredStatus					datetime
	DECLARE @CurrentDateEnteredStatusLevel		datetime
	DECLARE @NewDateEnteredStatus							datetime
	DECLARE @NewDateEnteredStatusLevel				datetime

	DECLARE	@GlobalSufficientPercentage				decimal(9,4)
	DECLARE @ChangedByName										varchar(100)
	SELECT
		@CurrentCollectionStatusUid = @OldCollectionStatusUid,
		@CurrentCollectionStatusLevelUid = CollectionStatusLevelUid
	FROM
		AccountResponsibleParty
	WHERE
		AccountResponsiblePartyUid = @AccountResponsiblePartyUid

	IF @CurrentCollectionStatusUid = @NewCollectionStatusUid
	BEGIN
		RETURN
	END

	SELECT
		@GlobalSufficientPercentage = GlobalSufficientPercentage
	FROM
		CollectionStatusGlobal

	SELECT
		@ChangedByName = dbo.UDF_getFormattedName('', p.Firstname, p.MiddleName, p.LastName, '')
	FROM
		Person p
	WHERE
		PersonUid = @ChangedByUid

	SELECT
		@CurrentExpirationDate = CollectionStatusExpirationDate,
		@CurrentDateEnteredStatus = DateEnteredStatus,
		@CurrentDateEnteredStatusLevel = DateEnteredStatusLevel
	FROM
		AccountResponsibleParty
	WHERE
		AccountResponsiblePartyUid = @AccountResponsiblePartyUid

	SET	@NewCollectionStatusLevelUid = dbo.GetCollectionStatusLevelForAccountResponsibleParty(@AccountResponsiblePartyUid,@NewCollectionStatusUid)
	SET @CalculatedPaymentAmount = dbo.GetAccountResponsiblePartyOriginalCollectionsBalance(@AccountResponsiblePartyUid) * (@GlobalSufficientPercentage / 100)

	IF @IsExpireDayOfMonth = 1
	BEGIN
		SET	@NewExpirationDate = DateAdd(month, 1, @CurrentExpirationDate)
	END
	ELSE
	BEGIN
		SET	@NewExpirationDate = DateAdd(day, (SELECT ExpirationNumberOfDays FROM CollectionStatusLevel WHERE CollectionStatusLevelUid = @NewCollectionStatusLevelUid), @Now)
	END

	IF @NewCollectionStatusUid <> @CurrentCollectionStatusUid
	BEGIN
		SET @NewDateEnteredStatus = @Now
	END
	ELSE
	BEGIN
		SET @NewDateEnteredStatus = @CurrentDateEnteredStatus
	END
		
	IF @NewCollectionStatusLevelUid <> @CurrentCollectionStatusLevelUid
	BEGIN
		SET @NewDateEnteredStatusLevel = @Now
	END
	ELSE
	BEGIN
		SET @NewDateEnteredStatusLevel = @CurrentDateEnteredStatusLevel
	END

	INSERT INTO
		CollectionHistory
	(
		AccountResponsiblePartyUid,
		InitialCollectionStatusUid,
		InitialCollectionStatusLevelUid,
		NewCollectionStatusUid,
		NewCollectionStatusLevelUid,
		CreatedDateTime,
		Reason,
		Notes
	)
	SELECT
		@AccountResponsiblePartyUid,
		@CurrentCollectionStatusUid,
		@CurrentCollectionStatusLevelUid,
		@NewCollectionStatusUid,
		@NewCollectionStatusLevelUid,
		@Now,
		'This Account Reponsible Party has been manually changed to this Collection Status by ' + isnull(@ChangedByName, 'Unknown'),
		''

	UPDATE
		AccountResponsibleParty
	SET
		CollectionStatusUid = @NewCollectionStatusUid,
		CollectionStatusLevelUid = @NewCollectionStatusLevelUid,
		CollectionStatusExpirationDate = @NewExpirationDate,
		CalculatedPaymentAmount = 
			CASE WHEN NOT @CalculatedPaymentAmount IS NULL THEN @CalculatedPaymentAmount ELSE 0 END,
		DateEnteredStatus = @NewDateEnteredStatus,
		DateEnteredStatusLevel = @NewDateEnteredStatusLevel,
		PaymentsLastProcessed = @Now,
		LastModifiedDate = @Now
	WHERE
		AccountResponsiblePartyUid = @AccountResponsiblePartyUid

END



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccessionNumber]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[GetAccessionNumber] AS' 
END
GO



ALTER PROCEDURE [dbo].[GetAccessionNumber] (@id as varchar(14) OUTPUT)
AS
BEGIN

declare @prefix varchar(255)
set @prefix = '00000'

declare @postfix varchar(255)
set @postfix = '0000000000'

declare @isCacheClient bit
if ( dbo.IsCacheClient() = 1 )
	set @isCacheClient = 1


-- Get the prefix
if ( @isCacheClient = 1 )
	Begin
		SELECT @prefix = @prefix + cast(ID AS varchar(5)) 
		FROM ListCacheMachine 
		 WHERE URL in (SERVERPROPERTY ('ServerName'), SERVERPROPERTY ('Machinename'))
	 End
-- Get the trailing portion
declare @seed varchar(14)
exec @seed = GetSeed 'AccessionNumber'

set @postfix = @postfix + cast(@seed as varchar(7))

-- And build the final
-- need to return on 11 digits because that is the limit in hl7GenerateAccessions
-- Split prefixing based on if it is cacheclient
if( @isCacheClient = 1)
	
	Begin
		set @id = right(@prefix, 5) + right(@postfix, 7)
		return;
	End

else
	
	Begin
		set @id = right(('00000000000'+ @seed), 12)
		return;
	End

END



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty_FixRPID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AccountResponsibleParty_FixRPID] AS' 
END
GO

-- =============================================
-- Author:		aprima ( David Wallace )
-- Create date: 05/13/2011
-- Modified: 05/17/2011 ( Kellye Bernecker ) - added check for '(Auto ID)' 
--                      and empty string in externalID and added @count parameter.
--						write data to temp table
-- Description:	Display or fix AccountResponsibleParties with null external IDs
-- =============================================
ALTER PROCEDURE [dbo].[AccountResponsibleParty_FixRPID]
AS
BEGIN

	SET NOCOUNT ON;
	
	DECLARE @id varchar(25)
	DECLARE @arpUid uniqueidentifier
	SET @arpUid = NULL 
    
	SELECT TOP 1 @arpUid = arp.AccountResponsiblePartyUid 
	FROM AccountResponsibleParty arp  
	WHERE arp.ExternalID IS NULL or arp.ExternalID = '' or arp.ExternalID = '(Auto ID)'
	
	declare @auditdesc varchar(500)
	declare @workstation varchar(250)
	declare @userName varchar(500)
	declare @modifier varchar(500)
	declare @userGroup varchar(500)
	
	WHILE (@arpUid IS NOT NULL)
	BEGIN
	  -- get unique id from seed table	
	  EXEC @id = GetUniqueID 'AccountResponsibleParty'
	  
	  -- Update accountResponsiblePartyRow
	  UPDATE AccountResponsibleParty
		SET ExternalID = @id
		WHERE AccountResponsiblePartyUid = @arpUid
		
	  set @auditdesc = 'SQL job detected and corrected an invalid ExternalID for AccountResponsibleParty ''' + convert(varchar(50),@arpUid) + '''.  The new ExternalID value is: ''' + @id + '''.'
	  set @workstation = convert(varchar(500),(select SERVERPROPERTY('MachineName')))
	
	  insert into audit (Type, Workstation, description)
	  values('Aprima-SQL', @workstation, @auditdesc)
	
	  -- Get next in line to be updated
	  SET @arpUid = NULL 
	  SELECT TOP 1 @arpUid = arp.AccountResponsiblePartyUid 
	  FROM AccountResponsibleParty arp 
	  WHERE arp.ExternalID IS NULL or arp.ExternalID = '' or arp.ExternalID = '(Auto ID)'
	END		
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsiblePartyAccountReport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AccountResponsiblePartyAccountReport] AS' 
END
GO
ALTER PROC [dbo].[AccountResponsiblePartyAccountReport] @AccountResponsiblePartyUid varchar(1000) AS
/*
	01/28/2008 - Qatalys - #13128 - Modified Balance with BalanceAll
	12/20/2013 - Pancratius		Removed dbo.UDF_utcToCurrent function from all date columns
*/
BEGIN
SELECT
	ARPAR.AccountResponsiblePartyUid,
	ARPAR.ARPName,
	ARPAR.Address1,
	ARPAR.Address2,
	ARPAR.City,
	ARPAR.State,
	ARPAR.Zip,
	ARPAR.PhoneNumber,
	ARPAR.CollectionStatus,
	ARPAR.CollectionStatusLevel,
	ARPAR.CollectionsBalance,
	PaymentDueDate,
	ARPAR.PaymentAmount,
    LGT.lastPaymentAmount AS LastPaymentAmount,
    LGT.lastPaymentDate AS LastPaymentDate,
	ARPAR.AccountUid,
	ARPAR.AccountName,
	ARPAR.PatientUid,
	ARPAR.PatientLastName,
	ARPAR.PatientFirstName,
	ARPAR.PatientBirthDate,
	ARPAR.PatientLiability,
	ARPAR.TotalBalance
FROM
	[MDOL_RPT2_VIEW_AccountResponsiblePartyAccountReport] ARPAR
LEFT JOIN
	MDOL_RPT2_VIEW_LedgerGetTransactions LGT
ON
	ARPAR.AccountUid = LGT.AccountUid	
WHERE
		ARPAR.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
ORDER BY LGT.LastPaymentdate desc		
END



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AddLOINCToProcedures]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AddLOINCToProcedures] AS' 
END
GO
ALTER PROCEDURE [dbo].[AddLOINCToProcedures]
AS
BEGIN
	IF EXISTS(select PRMCode
		   from MASTER_MU2_InterfaceDataMapping m WITH(NOLOCK)
		   inner join MasterProcedureToLoinc map WITH(NOLOCK) on m.PRMCode=map.LOINC_CODE
		   inner join ListProcedure p WITH(NOLOCK) on map.PROCIT_VOCAB_IMO_CODE=p.Code and p.MasterProcedureUid is not null and p.UserDefined IN(0,1,2)
		   inner join ListLOINC ll WITH(NOLOCK) on map.LOINC_CODE=ll.Name
		   where m.Rootid='2.16.840.1.113883.6.1'
		   AND p.LOINCUid IS NULL)
       BEGIN
	   update p set p.LOINCUid=ll.LOINCUid
       --select PRMCode
       from MASTER_MU2_InterfaceDataMapping m WITH(NOLOCK)
       inner join MasterProcedureToLoinc map WITH(NOLOCK) on m.PRMCode=map.LOINC_CODE
       inner join ListProcedure p WITH(NOLOCK) on map.PROCIT_VOCAB_IMO_CODE=p.Code and p.MasterProcedureUid is not null and p.UserDefined IN(0,1,2)
       inner join ListLOINC ll WITH(NOLOCK) on map.LOINC_CODE=ll.Name
       where m.Rootid='2.16.840.1.113883.6.1'
	   AND p.LOINCUid IS NULL
	   END
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AddRelCCSymptomMFU]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AddRelCCSymptomMFU] AS' 
END
GO

ALTER PROC [dbo].[AddRelCCSymptomMFU] (@providerUid uniqueidentifier, @ccSystemUid uniqueidentifier, @ccSymptomUid uniqueidentifier) AS
BEGIN
	DECLARE @relCCSystemSymptomUid uniqueidentifier
	SELECT	@relCCSystemSymptomUid = dbo.UDFGetRelCCSystemSymptom(@ccSystemUid, @ccSymptomUid)
	
	IF @relCCSystemSymptomUid IS NULL
		RETURN

	UPDATE	RelFindTableMFU
	SET		[Count] = [Count] + 1
	WHERE	FindTableUid = '9C4CA244-69D6-4FAF-A16F-60A7645B577C' AND
			UserUid = @providerUid AND
			[Uid] = @relCCSystemSymptomUid

    IF NOT EXISTS(SELECT * FROM UserPRM WHERE PersonUid = @providerUid)
       RETURN

	IF @@ROWCOUNT = 0 /* no row updated, so add new row */
		INSERT	RelFindTableMFU(FindTableUid, UserUid, [Uid], [Count])
		VALUES	('9C4CA244-69D6-4FAF-A16F-60A7645B577C', @providerUid, @relCCSystemSymptomUid, 1)
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AlterXmlSchema]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AlterXmlSchema] AS' 
END
GO
ALTER PROC [dbo].[AlterXmlSchema] @xmlSchemaName VARCHAR(255), @xmlSchema NVARCHAR(MAX) AS

DECLARE @table TABLE(	TableName VARCHAR(255),
						ColumnName VARCHAR(255)
					)
					
DECLARE @index TABLE(	TableName VARCHAR(255),
						ColumnName VARCHAR(255),
						IndexName VARCHAR(255)
					)

PRINT 'Getting list of tables with XML bound Schema'
			
INSERT	@table
SELECT	t.name AS [Table], c.name AS [Column]
FROM	sys.xml_schema_collections xsc INNER JOIN sys.columns c ON xsc.xml_collection_id = c.xml_collection_id
		INNER JOIN sys.objects t ON c.object_id = t.object_id AND t.Type = 'U'
WHERE	xsc.name = @xmlSchemaName

DECLARE @tableName VARCHAR(255)
DECLARE @columnName VARCHAR(255)

PRINT 'Removing Schema from the Columns'
DECLARE cur CURSOR FOR SELECT * FROM @table
OPEN cur

FETCH NEXT FROM cur INTO @tableName, @columnName
WHILE @@FETCH_STATUS = 0
BEGIN	
	PRINT 'Running DBCC CleanTable on ' + @tableName
	exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')

	PRINT 'Altering Column Removing Schema ' + @tableName + '.' + @columnName
	exec('ALTER TABLE ' + @tableName + ' ALTER COLUMN ' + @columnName + ' XML')

	PRINT 'Running DBCC CleanTable on ' + @tableName
	exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')

	FETCH NEXT FROM cur INTO @tableName, @columnName
END
CLOSE cur

PRINT 'Rebuilding Views to remove XML Schema'
DECLARE @views TABLE( value VARCHAR(MAX))
DECLARE @viewName VARCHAR(255)
DECLARE @views_text VARCHAR(MAX)
DECLARE vws CURSOR FOR SELECT t.name AS [View]
	FROM	sys.xml_schema_collections xsc INNER JOIN sys.columns c ON xsc.xml_collection_id = c.xml_collection_id
			INNER JOIN sys.objects t ON c.object_id = t.object_id AND t.Type = 'V'
	WHERE	xsc.name = @xmlSchemaName

OPEN vws
FETCH NEXT FROM vws INTO @viewName
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @views_text = ''
	DELETE FROM @views
	
	INSERT INTO @views exec sp_helptext @viewName
	
	SELECT @views_text = @views_text + value FROM @views

	exec('DROP VIEW ' + @viewName)
	
	exec(@views_text)	

	FETCH NEXT FROM vws INTO @viewName
END
CLOSE vws

IF EXISTS(SELECT * FROM sys.xml_schema_collections WHERE name = @xmlSchemaName)
BEGIN
	PRINT 'Dropping Xml Schema'
	exec('DROP XML SCHEMA COLLECTION ' + @xmlSchemaName)
END

PRINT 'Creating Xml Schema'
select 'CREATE XML SCHEMA COLLECTION ' + @xmlSchemaName + ' AS N''' + @xmlSchema + ''''
exec('CREATE XML SCHEMA COLLECTION ' + @xmlSchemaName + ' AS N''' + @xmlSchema + '''')

PRINT 'Adding Schema to the Columns'
OPEN cur
FETCH NEXT FROM cur INTO @tableName, @columnName
WHILE @@FETCH_STATUS = 0
BEGIN	
	PRINT 'Running DBCC CleanTable on ' + @tableName
	exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')
	
	PRINT 'Altering Column Adding Schema ' + @tableName + '.' + @columnName
	exec('ALTER TABLE ' + @tableName + ' ALTER COLUMN ' + @columnName + ' XML(' + @xmlSchemaName + ')')

	PRINT 'Running DBCC CleanTable on ' + @tableName
	exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')
	
	FETCH NEXT FROM cur INTO @tableName, @columnName
END
CLOSE cur
DEALLOCATE cur

PRINT 'Rebuilding Views for Schema'
OPEN vws
FETCH NEXT FROM vws INTO @viewName
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @views_text = ''
	DELETE FROM @views
	
	INSERT INTO @views exec sp_helptext @viewName
	
	SELECT @views_text = @views_text + value FROM @views

	exec('DROP VIEW ' + @viewName)
	
	exec(@views_text)	

	FETCH NEXT FROM vws INTO @viewName
END
CLOSE vws
DEALLOCATE vws

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientHasQualifyingObservation]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[PatientHasQualifyingObservation] AS' 
END
GO




ALTER PROC [dbo].[PatientHasQualifyingObservation]
	(@PatientUid uniqueidentifier,
	@HMRuleUid uniqueidentifier,
	@Result varchar(4000) OUTPUT)
	
AS  

BEGIN 
	declare @tempPK uniqueidentifier
	DECLARE @sql varchar(4000)
	DECLARE @ortext varchar(5)
	SET @ortext = ''
	SET @sql = ' SELECT COUNT(*), '''
	SET @sql += CAST(@PatientUid AS varchar(50)) + ''', ''' + CAST(@HMRuleUid AS varchar(50))
	SET @sql += ''' FROM ViewCDSObservationValue ov '
	SET @sql += ' WHERE ov.PatientUid = ''' + CAST(@PatientUid AS varchar(50)) + ''''
	SET @sql += ' AND ( '
	DECLARE @type int
	DECLARE @stringoiuid varchar(50)
	DECLARE @subtype varchar(50)
	DECLARE @decimalvalue decimal(16,4)
	DECLARE @decimalvalue2 decimal(16,4)
	DECLARE @testvalue varchar(50)
	
	declare  @temp table (
		PK uniqueidentifier,
		Done bit,
		TypeNum smallint, 
		ObservationItemUid uniqueidentifier, 
		SubType varchar(100),
		DecimalValue1 decimal,
		DecimalValue2 decimal,
		TestValue nvarchar(max)
	)

	insert into @temp
	SELECT
		NEWID(),
		0,
		[Type], 
		CAST(ObservationItemUid AS varchar(50)), 
		Subtype, 
		DecimalValue1,
		DecimalValue2,
		CASE 
			WHEN DecimalValue1 is null THEN '''' + StringValue + ''''
			ELSE '''' + ''''
		END
	FROM HMRuleObservationTest
	WHERE HMRuleUid = @HMRuleUid
	ORDER BY DisplayOrder;

	while(exists(select top 1 * from @temp where Done=0))
	begin
		--select @type=TypeNum, @stringoiuid, @subtype, @decimalvalue, @decimalvalue2, @testvalue
		select top 1 
		@tempPK=PK,
		@type=TypeNum,
		@stringoiuid=ObservationItemUid,
		@subtype=SubType,
		@decimalvalue=DecimalValue1,
		@decimalvalue2=DecimalValue2,
		@testvalue=TestValue
		from @temp where Done=0

		SET @sql +=
			CASE 
				WHEN @type = 1 OR @type = 2 
					THEN @subtype
				WHEN @stringoiuid = '00000000-0000-0000-7777-100000000073'  OR
					@stringoiuid = '00000000-0000-0000-7777-100000000074'  OR
					@stringoiuid = '00000000-0000-0000-7777-100000000075'  OR
					@stringoiuid = '00000000-0000-0000-7777-100000000076'
					THEN
						CASE 
							WHEN @subtype = '<' OR @subtype = '<='
								THEN
								'( observationitemuid = ''' + @stringoiuid + 
								''' and ( metricvalue1 ' + @subtype + ' ' + 
								cast(@decimalvalue as varchar(50)) + ' and ' +
								'metricvalue2 ' + @subtype + ' ' +
								cast(@decimalvalue2 as varchar(50)) + '))'
							ELSE
								'( observationitemuid = ''' + @stringoiuid + 
								''' and ( metricvalue1 ' + @subtype + ' ' + 
								cast(@decimalvalue as varchar(50)) + ' or ' +
								'metricvalue2 ' + @subtype + ' ' +
								cast(@decimalvalue2 as varchar(50)) + '))'
						END
				ELSE
						
					CASE WHEN @decimalvalue IS NULL 
						THEN
							'( observationitemuid = ''' + @stringoiuid +
							''' and observationvalue is not null and observationvalue ' + 
							@subtype + ' ' + @testvalue + ') ' 
						ELSE
							'( observationitemuid = ''' + @stringoiuid +
							''' and ((observationvaluedecimal is not null and observationvaluedecimal ' + 
							@subtype + ' ' + cast(@decimalvalue as varchar(50)) + ') or ' +
							' metricvalue1 ' + @subtype + ' ' + cast(@decimalvalue as varchar(50)) + '))'
					END
			END
		update @temp
		set Done=1
		where PK=@tempPK

	end
	SET @sql += ' )'
	SELECT @Result = @sql
END





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateHMRuleIsDueMessage]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[CreateHMRuleIsDueMessage] AS' 
END
GO
ALTER PROC [dbo].[CreateHMRuleIsDueMessage]
(
	@PatientHMRuleUid [uniqueidentifier]
)
AS
/************************************************************************************************/
/* Name:	CreateHMRuleIsDueMessage 							*/
/* Desc:	This stored procedure will create a message when a PatientHMRule becomes due	*/
/*		It will create one message and assign it to each message recipient related to	*/
/*		this HMRule									*/
/*												*/
/* DATE		MODIFIED BY		MODIFICATIONS						*/
/* 08/19/2005	Chip Pace		Created							*/
/* 06/26/2006	Ken Simone		Set IsModified for replication							*/
/* 09/25/2006	Ken Simone		Remove IsModified							*/
/*												*/
/************************************************************************************************/
BEGIN

	SET NOCOUNT ON;
	DECLARE @Inactive [bit] = 0

--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
	IF NOT EXISTS(
		SELECT TOP 1 *
		FROM [PatientHMRule] WITH(NOLOCK)
			JOIN [ListHMRule] WITH(NOLOCK) ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
			JOIN [RelHMRuleClinicCenter] WITH(NOLOCK) ON [RelHMRuleClinicCenter].[HMRuleUid] = [ListHMRule].[HMRuleUid]
			JOIN [RelHMRuleClinicCenterMsgRecipient] WITH(NOLOCK) ON [RelHMRuleClinicCenterMsgRecipient].[HMRuleClinicCenterUid] = [RelHMRuleClinicCenter].[HMRuleClinicCenterUid]
		WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
			AND [ListHMRule].[Inactive] = @Inactive
	)
	BEGIN
		RETURN
	END
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group

	BEGIN TRANSACTION

	/* Create a new MessageUid									*/
	/************************************************************************************************/
	DECLARE @NewGuid [uniqueidentifier] = NEWID()

	/* Get the current date										*/
	/************************************************************************************************/
	DECLARE @CurrentDate [datetime] = GETUTCDATE()	

	/* Get the default Message Urgency								*/
	/************************************************************************************************/
	DECLARE	@MessageUrgencyUid [uniqueidentifier]
	SELECT TOP 1 @MessageUrgencyUid = [MessageUrgencyUid]
	FROM [ListMessageUrgency]
	WHERE [IsDefault] = 1

	/* Insert the Message Record									*/
	/************************************************************************************************/
	INSERT INTO	[Message]
	(
		[MessageUid],
		[PersonUid],
		[MessageTypeUid],
		[MessageSubTypeUid],
		[Header],
		[MessageUrgencyUid],
		[CreatedDate],
		[CreatedDateTime],
		[DateToBeCompleted]
	)
	SELECT DISTINCT	@NewGuid,
		[PatientHMRule].[PatientUid],
		'10101010-0000-0000-0000-000000000005', -- Task Message Type
		'10101010-0000-0000-0000-000000000050', -- HMRule Message Sub Type
		[ListHMRule].[Name] + ' Is Due',
		@MessageUrgencyUid,
		CAST(GETDATE() AS DATE),
		@CurrentDate,
		[PatientHMRule].[DueDate]
	FROM [PatientHMRule]
		JOIN [ListHMRule] ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
		JOIN [RelHMRuleClinicCenter] ON [RelHMRuleClinicCenter].[HMRuleUid] = [ListHMRule].[HMRuleUid]
		JOIN [RelHMRuleClinicCenterMsgRecipient] ON [RelHMRuleClinicCenterMsgRecipient].[HMRuleClinicCenterUid] = [RelHMRuleClinicCenter].[HMRuleClinicCenterUid]
	WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
		AND [ListHMRule].[Inactive] = @Inactive


	/* Insert the MessageTask Record								*/
	/************************************************************************************************/
	INSERT INTO	[MessageTask]
	(
		[MessageUid],
		[Note],
		[PatientHMRuleUid]
	)
	SELECT @NewGuid,
		[ListHMRule].[Name] + ' Is Due',
		[PatientHMRule].[PatientHMRuleUid]
	FROM [PatientHMRule]
		JOIN [ListHMRule] ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
		JOIN [Message] ON [Message].[MessageUid] = @NewGuid
	WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
		AND [ListHMRule].[Inactive] = @Inactive

	/* Insert the "User" MessageUser record(s)							*/
	/************************************************************************************************/
	INSERT INTO	[MessageUser]
	(
		[UserUid],
		[MessageUid]
	)
	SELECT DISTINCT	[RelHMRuleClinicCenterMsgRecipient].[UserUid],
		@NewGuid
	FROM [RelHMRuleClinicCenterMsgRecipient]
		JOIN [RelHMRuleClinicCenter] ON [RelHMRuleClinicCenter].[HMRuleClinicCenterUid] = [RelHMRuleClinicCenterMsgRecipient].[HMRuleClinicCenterUid]
		JOIN [PatientHMRule] ON [PatientHMRule].[HMRuleUid] = [RelHMRuleClinicCenter].[HMRuleUid]
		JOIN [ListHMRule] ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
	WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
		AND [RelHMRuleClinicCenterMsgRecipient].[UserUid] IS NOT NULL
		AND [ListHMRule].[Inactive] = @Inactive

	/* Insert the "UserGroup" MessageUser record(s)							*/
	/************************************************************************************************/
	INSERT INTO	[MessageUser]
	(
		[UserGroupUid],
		[MessageUid]
	)
	SELECT DISTINCT	[RelHMRuleClinicCenterMsgRecipient].[UserGroupUid],
		@NewGuid
	FROM [RelHMRuleClinicCenterMsgRecipient]
		JOIN [RelHMRuleClinicCenter]  ON [RelHMRuleClinicCenter].[HMRuleClinicCenterUid] = [RelHMRuleClinicCenterMsgRecipient].[HMRuleClinicCenterUid]
		JOIN [PatientHMRule] ON [PatientHMRule].[HMRuleUid] = [RelHMRuleClinicCenter].[HMRuleUid]
		JOIN [ListHMRule] ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
	WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
		AND [RelHMRuleClinicCenterMsgRecipient].[UserGroupUid] IS NOT NULL
		AND [ListHMRule].[Inactive] = @Inactive

	COMMIT
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ApplyHMRulesToPatients]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ApplyHMRulesToPatients] AS' 
END
GO
ALTER  PROC [dbo].[ApplyHMRulesToPatients]
(
    @PatientUid uniqueidentifier,
    @HMRuleUid	uniqueidentifier,                  -- @HMRuleUid is required in order to inactivate patient rules that no longer meet criteria.
    @InactivateNonRelevantPatientRules bit = null,  -- If TRUE, then inactivate old patient rules that no longer meet the criteria 
														-- this flag only honored if PatientUid is null and HMRuleUid is not null
	@ShowDebug bit = 0
)
AS
BEGIN
	--This was completely rewritten in Mar 2013 for requirements related to Meaningful Use II
	--It now executes in two sections:  the first when @PatientUid is not null, meaning "update any rules for 
	--this patient"; the second executes for all patients.  
	--The second argument defines how many rules will be checked:  if a Uid is provided, only that rule
	--is checked.  If no Uid is provided, all rules are checked.
	--I also added a ShowDebug option to aid debugging this thing when all else fails.
	--Within each execution section, three processes are carried out.  1) Are there any new rules fired?
	--2) Should any existing rules that have been deactivated be reactivated?  3) Should any rules be removed?
	--The third section only actually removes rules when the @InactivateNonRelevantPatientRules argument is 1

	SET NOCOUNT ON;
	
	DECLARE @FALSE BIT
	SELECT @FALSE = 0

	DECLARE @TRUE BIT
	SELECT @TRUE = 1

	DECLARE @RuleCount int
	SET @RuleCount = 0
		
	DECLARE	@CurrentDate datetime

	DECLARE @Years 	uniqueidentifier
	DECLARE @Months	uniqueidentifier
	DECLARE @Weeks 	uniqueidentifier
	DECLARE @Days 	uniqueidentifier

	DECLARE @Mins	int
	
	DECLARE @RetestHMRuleUid uniqueidentifier
	DECLARE @RetestPatientUid uniqueidentifier
	DECLARE @Answer varchar(4000)

	declare @tempPatientRuleTable table
	(
		PK uniqueidentifier DEFAULT(newid()),
		PatientUid uniqueidentifier,
		HMRuleUid uniqueidentifier
	)
	declare @tempPK uniqueidentifier
	declare @tempObsPatientUid uniqueidentifier
	declare @tempObsHMRuleUid uniqueidentifier

	DECLARE @ObservationTestCount TABLE
	(
		[Found] [int] DEFAULT(0),
		[PatientUid] [uniqueidentifier],
		[HMRuleUid] [uniqueidentifier]
		primary key([PatientUid], [HMRuleUid])
	)
		

/* Determine the Current Date																	*/
/************************************************************************************************/
	SET	@CurrentDate = CAST(GETUTCDATE() AS DATE)
	SET	@Mins = DATEDIFF(n, GETDATE(), GETUTCDATE())

/* Determine the Time Type Uids 																*/
/************************************************************************************************/
	SELECT 	@Years = TimeTypeUid FROM ListTimeType WHERE Name = 'Years'
	SELECT 	@Months = TimeTypeUid FROM ListTimeType WHERE Name = 'Months'
	SELECT 	@Weeks = TimeTypeUid FROM ListTimeType WHERE Name = 'Weeks'
	SELECT 	@Days = TimeTypeUid FROM ListTimeType WHERE Name = 'Days'
	
	-- skip the process if there is no HMRule
	IF NOT EXISTS ( SELECT TOP 1 *
					FROM ListHMRule
					WHERE Inactive = 0
				  )
	BEGIN
		IF @PatientUid IS NOT NULL 
		BEGIN
			SELECT @RuleCount
		END
		RETURN
	END

	-- skip the process if the patient is inactive or dead.
	IF @PatientUid IS NOT NULL 
	BEGIN
		IF EXISTS ( SELECT TOP 1 *
				  FROM Patient AS pp INNER JOIN Person AS p
					ON pp.PersonUid = p.PersonUid 
					  AND (pp.Inactive <> 0 OR p.DeathDate IS NOT NULL)
			WHERE pp.PersonUid = @PatientUid)
		BEGIN
			SELECT @RuleCount
			RETURN
		END
	END

	-- skip the process if the HM Rule action is only to display an alert popup.
	IF @HMRuleUid IS NOT NULL
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 * FROM RelHMRuleProcedure WHERE RelHMRuleProcedure.HMRuleUid = @HMRuleUid)
		BEGIN 
			-- No Procedure to complete is associated with the HM Rule.  Therefore, rule only displays an alert message.
			SELECT @RuleCount
			RETURN
		END                
	END

	BEGIN TRANSACTION
	
	CREATE TABLE #NewRules
		(
		HMRuleName varchar(100),
		HMRuleUid uniqueidentifier,
		PatientName varchar(100),
		PatientUid uniqueidentifier,
		IsDue bit,
		DueDate datetime,
		PastDueDate datetime
		)

	DECLARE @patient TABLE
		(	
		Birthdate DATETIME NULL,
		GenderUid UNIQUEIDENTIFIER NULL,
		FirstName VARCHAR(100) NULL,
		LastName VARCHAR(100) NULL
		)

		-- temp tables used to cull inactive rules
	CREATE TABLE #NonRelevantPatientRules 
		(PatientHMRuleUid uniqueidentifier)  -- List of patient rules that no longer meet the criteria.
	CREATE TABLE #CurrentPatientRules 
		(PatientHMRuleUid uniqueidentifier)      -- Current list of patient rules that meet the criteria.
		
		-- working version of ListHMRule
	CREATE TABLE #RuleCriteria
			(
			HMRuleName varchar(100),
			HMRuleUid uniqueidentifier,
			AgeToDate datetime,
			AgeFromDate datetime,
			GenderUid uniqueidentifier,
			AgeFrom int,
			AgeTo int,
			AgeTimeTypeUid uniqueidentifier,
			RecurFrom int,
			RecurTo int,
			RecurTimeTypeUid uniqueidentifier,
			AdvanceWarning int,
			AdvanceWarningTimeTypeUid uniqueidentifier,
			DiseaseUid uniqueidentifier,
			FDB_MNID int,
			FDB_ClassID int,
			DrugAllergyQuestionUid uniqueidentifier,
			HasObservationCriteria int
			)

	IF @InactivateNonRelevantPatientRules IS NOT NULL
	BEGIN
	
		IF @InactivateNonRelevantPatientRules = @TRUE
		BEGIN
		
			IF @HMRuleUid IS NOT NULL
			BEGIN
			
				IF @PatientUid IS NOT NULL
				BEGIN
					INSERT INTO #NonRelevantPatientRules 
						(PatientHMRuleUid)
					SELECT PatientHMRuleUid 
						FROM PatientHMRule 
						WHERE HMRuleUid = @HMRuleUid AND PatientUid = @PatientUid    
				END
				ELSE
				BEGIN
					INSERT INTO #NonRelevantPatientRules 
						(PatientHMRuleUid)
					SELECT PatientHMRuleUid 
						FROM PatientHMRule 
						WHERE HMRuleUid = @HMRuleUid 
				END 
			END
		END
	END
	IF NOT EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)
	BEGIN
		--  No need to inactivate anything if no active ones are found for the input request
		SELECT @InactivateNonRelevantPatientRules = @FALSE
	END 


		--Populate the working copy of ListHMRule:  notice when the second arguement
		--to the stored proc is not null, only that one rule is added here
	INSERT INTO   #RuleCriteria
		(
			HMRuleName,
			HMRuleUid,
			AgeToDate,
			AgeFromDate,
			GenderUid,
			AgeFrom,
			AgeTo,
			AgeTimeTypeUid,
			RecurFrom,
			RecurTo,
			RecurTimeTypeUid,
			AdvanceWarning,
			AdvanceWarningTimeTypeUid,
			DiseaseUid,
			FDB_MNID,
			FDB_ClassID,
			DrugAllergyQuestionUid,
			HasObservationCriteria
		)
		SELECT 
			lhmr.Name,
			lhmr.HMRuleUid, 
			lhmr.AgeToDate,
			CASE lhmr.AdvanceWarningTimeTypeUid
				WHEN @Years THEN DATEADD(year, lhmr.AdvanceWarning,lhmr.AgeFromDate)
				WHEN @Months THEN DATEADD(month, lhmr.AdvanceWarning,lhmr.AgeFromDate)
				WHEN @Weeks THEN DATEADD(day, lhmr.AdvanceWarning * 7,lhmr.AgeFromDate)
				WHEN @Days THEN DATEADD(day, lhmr.AdvanceWarning,lhmr.AgeFromDate)
			END AS AgeFromDate,
			lhmr.GenderUid,
			lhmr.AgeFrom,
			lhmr.AgeTo,
			lhmr.AgeTimeTypeUid,
			lhmr.RecurFrom,
			lhmr.RecurTo,
			lhmr.RecurTimeTypeUid,
			lhmr.AdvanceWarning,
			lhmr.AdvanceWarningTimeTypeUid,
			lhmr.DiseaseUid,
			lhmr.FDB_MNID,
			lhmr.FDB_ClassID,
			lhmr.DrugAllergyQuestionUid,
			lhmr.HasObservationCriteria
		FROM  
			(SELECT DISTINCT	
				ListHMRule.Name,
				ListHMRule.HMRuleUid,
				CASE AgeTimeTypeUid
					WHEN @Years THEN DATEADD(day,1,DATEADD(year,-AgeTo -1,@CurrentDate))
					WHEN @Months THEN DATEADD(day,1,DATEADD(month,-AgeTo -1, @CurrentDate))
					WHEN @Weeks THEN DATEADD(day,1,DATEADD(day,(-AgeTo -1) * 7, @CurrentDate))
					WHEN @Days THEN DATEADD(day, -AgeTo, @CurrentDate)
				END AS AgeToDate,
				CASE AgeTimeTypeUid
					WHEN @Years THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-AgeFrom,@CurrentDate)))
					WHEN @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-AgeFrom, @CurrentDate)))
					WHEN @Weeks THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-AgeFrom * 7, @CurrentDate)))
					WHEN @Days THEN DATEADD(second,-1,DATEADD(day, -AgeFrom+1, @CurrentDate))
				END AS AgeFromDate,
				RelHMRuleGender.GenderUid,
				ListHMRule.AgeFrom,
				ListHMRule.AgeTo,
				ListHMRule.AgeTimeTypeUid,
				ListHMRule.RecurFrom,
				ListHMRule.RecurTo,
				ListHMRule.RecurTimeTypeUid,
				ListHMRule.AdvanceWarning,
				ListHMRule.AdvanceWarningTimeTypeUid,
				CASE WHEN RelHMRuleDisease.RelHMRuleDiseaseUid IS NOT NULL
					THEN RelHMRuleDisease.DiseaseUid
					ELSE NULL
					END
				AS DiseaseUid,
				CASE WHEN RelHMRuleDrugName.RelHMRuleDrugNameUid IS NOT NULL
					THEN RelHMRuleDrugName.FDB_MNID
					ELSE NULL
					END
				AS FDB_MNID,
				CASE WHEN RelHMRuleDrugClass.RelHMRuleDrugClassUid IS NOT NULL
					THEN RelHMRuleDrugClass.FDB_ClassID
					ELSE NULL
					END
				AS FDB_ClassID,
				CASE WHEN RelHMRuleDrugAllergy.RelHMRuleDrugAllergyUid IS NOT NULL
					THEN RelHMRuleDrugAllergy.QuestionUid
					ELSE NULL
					END
				AS DrugAllergyQuestionUid,
				(SELECT COUNT(*) FROM HMRuleObservationTest WHERE HMRuleUid = ListHMRule.HMRuleUid)
				AS HasObservationCriteria
			FROM  ListHMRule
				JOIN  RelHMRuleGender ON 
					1 = 
					(CASE WHEN @HMRuleUid IS NOT NULL THEN 
							(CASE WHEN ListHMRule.HMRuleUid = @HMRuleUid THEN 1 
							ELSE 0 END)
						  ELSE 1
					END)
					AND RelHMRuleGender.HMRuleUid = ListHMRule.HMRuleUid
					AND ListHMRule.Inactive = 0
				JOIN  ListGender ON 
					ListGender.GenderUid = RelHMRuleGender.GenderUid AND 
					ListGender.Inactive = 0	
				LEFT JOIN
					RelHMRuleDisease ON
						RelHMRuleDisease.HMRuleUid = ListHMRule.HMRuleUid
				LEFT JOIN
					RelHMRuleDrugName ON
						RelHMRuleDrugName.HMRuleUid = ListHMRule.HMRuleUid
				LEFT JOIN
					RelHMRuleDrugClass ON
						RelHMRuleDrugClass.HMRuleUid = ListHMRule.HMRuleUid
				LEFT JOIN
					RelHMRuleDrugAllergy ON
						RelHMRuleDrugAllergy.HMRuleUid = ListHMRule.HMRuleUid
			) AS lhmr
			
	IF @ShowDebug = 1
	BEGIN
		SELECT 'RuleCriteria'			
		SELECT * FROM #RuleCriteria
	END

		--Perform all setup logic to determine what needs to happen to the PatientHMRule table when
		--only one patient is processed
	IF @PatientUid IS NOT NULL
	BEGIN		            
		INSERT	@patient
		SELECT  
			per.Birthdate, 
			per.GenderUid, 
			per.FirstName, 
			per.LastName
		FROM	
			Patient pat INNER JOIN 
			Person per ON pat.PersonUid = per.PersonUid
		WHERE	
			pat.PersonUid = @PatientUid AND
			pat.Inactive = 0 AND
			per.Deathdate IS NULL
            
		--Nothing is done unless rules were found to process
		IF EXISTS ( SELECT TOP 1 * FROM #RuleCriteria )
		BEGIN

		--Determine any rules that have not had a PatientHMRUle made that need one
			INSERT INTO   #NewRules   
				(
					HMRuleName,
					HMRuleUid,
					PatientName,
					PatientUid,
					IsDue,
					DueDate
				)
				SELECT DISTINCT 
					#RuleCriteria.HMRuleName,
					#RuleCriteria.HMRuleUid,
					pat.FirstName + ' ' + pat.LastName,
					@PatientUid,
					1,
					CASE 
						WHEN PO.RelHMRulePatientOverrideUid IS NULL 
						THEN        
							CASE #RuleCriteria.AgeTimeTypeUid
								WHEN @Years THEN DATEADD(year,#RuleCriteria.AgeFrom,pat.BirthDate)
								WHEN @Months THEN DATEADD(month,#RuleCriteria.AgeFrom,pat.BirthDate)
								WHEN @Weeks THEN DATEADD(day,#RuleCriteria.AgeFrom * 7,pat.BirthDate)
								WHEN @Days THEN DATEADD(day,#RuleCriteria.AgeFrom,pat.BirthDate)
							END -- AS DueDate
						ELSE 
							CASE PO.AgeTimeTypeUid
								WHEN @Years THEN DATEADD(year,PO.AgeFrom,pat.BirthDate)
								WHEN @Months THEN DATEADD(month,PO.AgeFrom,pat.BirthDate)
								WHEN @Weeks THEN DATEADD(day,PO.AgeFrom * 7,pat.BirthDate)
								WHEN @Days THEN DATEADD(day,PO.AgeFrom,pat.BirthDate)
						END -- AS DueDate                       
					END AS DueDate                       
				FROM            
					@patient pat  JOIN            
					#RuleCriteria ON 
						pat.GenderUid = #RuleCriteria.GenderUid  LEFT JOIN            
					PatientHMRule ON 
						(PatientHMRule.PatientUid = @PatientUid  AND 
						PatientHMRule.HMRuleUid = #RuleCriteria.HMRuleUid AND 
						PatientHMRule.Inactive   = 0)  LEFT JOIN       
					#NewRules ON 
						(#RuleCriteria.HMRuleUid = #NewRules.HMRuleUid  AND 
						#NewRules.PatientUid = @PatientUid)  LEFT JOIN       
					RelHMRulePatientOverride PO ON 
						(PO.PatientUid = @PatientUid  AND 
						PO.HMRuleUid = #RuleCriteria.HMRuleUid)  LEFT JOIN
					ViewCDSPatientDisease ON
						ViewCDSPatientDisease.PatientUid = @PatientUid  AND
						ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
					ViewCDSPatientMedicationNameOrClass ON
						ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid  AND
						(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
						ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
					ViewCDSPatientDrugAllergy  ON
						ViewCDSPatientDrugAllergy.PersonUid = @PatientUid  AND
						ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid    
				WHERE           
					PatientHMRule.PatientHMRuleUid IS NULL  AND -- Ensure that this rule doesn't already exist for this patient
					#NewRules.HMRuleUid IS NULL  AND -- Ensure that this rule did not already get created for this patient
					pat.Birthdate 
						BETWEEN 
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeToDate
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
							END 
						AND 
							CASE WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeFromDate                                             
								 WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
								 WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
								 WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
								 WHEN PO.AgeTimeTypeUid = @Days THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
							END                       
					AND 
					(1 = (CASE 
							WHEN PO.Inactive IS NULL THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
							WHEN PO.Inactive = 1     THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
							WHEN PO.Inactive = 0     THEN 1  -- Override does exist.  Inactive flag for override is FALSE.  PatientRule is not disabled.
					END))                                             
					AND
					(1 = (CASE 
							WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDisease.PatientUid = @PatientUid
								AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid
								AND
								(
									(								
										(#RuleCriteria.FDB_MNID IS NOT NULL AND	ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
										OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
									)
									AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
								)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDrugAllergy.PersonUid = @PatientUid
								AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
							

			IF @ShowDebug = 1
			BEGIN
				SELECT 'NewRUles'
				SELECT COUNT(*) FROM #NewRules
				SELECT * FROM #NewRules
			END

			--Create a crossreference for any rules that include observation tests so the dynamic sql for those
			--tests can be built	

			insert into @tempPatientRuleTable(HMRuleUid, PatientUid)
			SELECT 
				DISTINCT #NewRules.HMRuleUid,
				#NewRules.PatientUid
			FROM 
				#RuleCriteria  JOIN
				#NewRules  ON	#NewRules.HMRuleUid = #RuleCriteria.HMRuleUid
			WHERE
				#RuleCriteria.HasObservationCriteria <> 0;

			while(exists(select top 1 * from @tempPatientRuleTable))
			begin
				select top 1 @tempPK=PK, @tempObsPatientUid=PatientUid, @tempObsHMRuleUid=HMRuleUid 
				from @tempPatientRuleTable

				IF @ShowDebug = 1
				BEGIN
					SELECT 'Observation HMRule/Patient Checks'
					SELECT @tempObsPatientUid
					SELECT @tempObsHMRuleUid
				END
						
				SET @Answer = NULL
				EXEC [PatientHasQualifyingObservation] 
					@tempObsPatientUid, @tempObsHMRuleUid, @Result = @Answer OUTPUT;
							
				IF @ShowDebug = 1
				BEGIN
					SELECT '@Answer for @tempObsHMRuleUid'
					SELECT @Answer
					SELECT @tempObsHMRuleUid
				END
						
				IF @Answer IS NOT NULL
				BEGIN
				--Create the dynamic sql to run the test, then exec it to load a count of
				--hits on the rule.  If the number is positive, the rule is fired.
					INSERT INTO @ObservationTestCount  ( Found, PatientUid, HMRuleUid )
					exec (@Answer)
							
				END

				delete @tempPatientRuleTable where PK=@tempPK
			end

			--If any observation tests had positive results, keep them, else delete the rules that failed their
			--observation test from the temp table.			
			IF EXISTS (SELECT TOP 1 * FROM @ObservationTestCount WHERE Found = 0 )
			BEGIN
				DELETE FROM #NewRules
					FROM #NewRules AS nr JOIN 
						@ObservationTestCount otc ON 
							nr.PatientUid = otc.PatientUid AND
							nr.HMRuleUid = otc.HMRuleUid 
					WHERE 
						otc.Found = 0
			END

			IF @ShowDebug = 1
			BEGIN
				SELECT 'NewRUles AFTER Observation Test Validation'
				SELECT * FROM @ObservationTestCount
				SELECT COUNT(*) FROM #NewRules
				SELECT * FROM #NewRules
			END
			
		--Review any pre-existing rules for this patient and make them due if their rules have refired.
			UPDATE   PatientHMRule
				SET		
					IsDue = 1, 
					LastModifiedDate = GETUTCDATE()
				FROM	    
					PatientHMRule JOIN	    
					#RuleCriteria ON 
						(PatientHMRule.PatientUid = @PatientUid AND 
						#RuleCriteria.HMRuleUid = PatientHMRule.HMRuleUid AND 
						PatientHMRule.Inactive  = @FALSE AND 
						PatientHMRule.IsDue = @FALSE) JOIN      
					@patient pat ON pat.GenderUid = #RuleCriteria.GenderUid LEFT JOIN 
					RelHMRulePatientOverride PO ON 
						(PO.PatientUid = @PatientUid AND 
						PO.HMRuleUid = PatientHMRule.HMRuleUid)LEFT JOIN
					ViewCDSPatientDisease ON
						ViewCDSPatientDisease.PatientUid = @PatientUid  AND
						ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
					ViewCDSPatientMedicationNameOrClass ON
						ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid  AND
						(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
						ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
					ViewCDSPatientDrugAllergy  ON
						ViewCDSPatientDrugAllergy.PersonUid = @PatientUid  AND
						ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid  LEFT JOIN
					@ObservationTestCount otc ON
						(otc.PatientUid = @PatientUid  AND
						otc.HMRuleUid = #RuleCriteria.HMRuleUid)
				WHERE 
					pat.Birthdate 
						BETWEEN 
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL 
									THEN #RuleCriteria.AgeToDate
								WHEN PO.AgeTimeTypeUid = @Years  
									THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Months 
									THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Weeks  
									THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Days   
									THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
							END 
						AND 
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL 
									THEN #RuleCriteria.AgeFromDate                                               
								WHEN PO.AgeTimeTypeUid = @Years  
									THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Months 
									THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Weeks  
									THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Days   
									THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
							END          
					AND 
					@CurrentDate >= 
						CASE #RuleCriteria.AdvanceWarningTimeTypeUid
							WHEN @Years 
								THEN DATEADD(year,-#RuleCriteria.AdvanceWarning,PatientHMRule.DueDate)
							WHEN @Months 
								THEN DATEADD(month,-#RuleCriteria.AdvanceWarning, PatientHMRule.DueDate)
							WHEN @Weeks 
								THEN DATEADD(day,-#RuleCriteria.AdvanceWarning * 7, PatientHMRule.DueDate)
							WHEN @Days 
								THEN DATEADD(day, -#RuleCriteria.AdvanceWarning, PatientHMRule.DueDate)
						END
					AND
					(1 = 
						(CASE 
							WHEN PO.Inactive IS NULL 
								THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
							WHEN PO.Inactive = 1     
								THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
							WHEN PO.Inactive = 0     
								THEN 1  -- Override does exist.  Inactive flag for override is FALSE.  PatientRule is not disabled.
						END)
					)                                              
					AND
					(1 = (CASE 
							WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDisease.PatientUid = @PatientUid 
								AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid
								AND
								(
									(
										(#RuleCriteria.FDB_MNID IS NOT NULL AND	ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
										OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
									)
									AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
								)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDrugAllergy.PersonUid = @PatientUid
								AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.HasObservationCriteria < 1  THEN 1
							WHEN otc.Found > 0 THEN 1
							ELSE 0
							END))

			--If we are deleting inactive rules, then find out which ones have gone inactive
			IF @InactivateNonRelevantPatientRules = @TRUE
			BEGIN
				INSERT INTO #CurrentPatientRules 
					(PatientHMRuleUid)
				SELECT 
					PatientHMRule.PatientHMRuleUid
				FROM   
					#RuleCriteria JOIN 
					@patient pat ON pat.GenderUid = #RuleCriteria.GenderUid JOIN 
					PatientHMRule ON 
						(PatientHMRule.PatientUid = @PatientUid AND 
						PatientHMRule.HMRuleUid  = #RuleCriteria.HMRuleUid AND 
						PatientHMRule.Inactive   = 0) LEFT JOIN 
					RelHMRulePatientOverride PO ON 
						(PO.PatientUid = @PatientUid AND
						PO.HMRuleUid = #RuleCriteria.HMRuleUid)LEFT JOIN
					ViewCDSPatientDisease ON
						ViewCDSPatientDisease.PatientUid = @PatientUid  AND
						ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
					ViewCDSPatientMedicationNameOrClass ON
						ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid  AND
						(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
						ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
					ViewCDSPatientDrugAllergy  ON
						ViewCDSPatientDrugAllergy.PersonUid = @PatientUid  AND
						ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid  LEFT JOIN
					@ObservationTestCount otc  ON
						(otc.PatientUid = @PatientUid  AND
						otc.HMRuleUid = #RuleCriteria.HMRuleUid)    
				WHERE  
					pat.Birthdate 
						BETWEEN 
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeToDate
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
							END 
						AND      
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeFromDate                                               
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
							END  
					AND
					(1 = 
						(CASE 
							WHEN PO.Inactive IS NULL THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
							WHEN PO.Inactive = 1     THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
							WHEN PO.Inactive = 0     THEN 1  -- Override does exist.  Inactive flag for override is FALSE.  PatientRule is not disabled.
						END))
					AND
					(1 = (CASE 
							WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDisease.PatientUid = @PatientUid 
								AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid
								AND 
								(
									(
										(#RuleCriteria.FDB_MNID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
										OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
									)
									AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
								)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDrugAllergy.PersonUid = @PatientUid
								AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.HasObservationCriteria < 1  THEN 1
							WHEN otc.Found > 0 THEN 1
							ELSE 0
							END))
							
			END  --  @InactivateNonRelevantPatientRules = @TRUE
			
		END  --  EXISTS ( SELECT TOP 1 * FROM #RuleCriteria )
							
	END   -- @PatientUid IS NOT NULL
	ELSE
	BEGIN

		--Process ALL patients
		IF EXISTS ( SELECT TOP 1 * FROM #RuleCriteria )
		BEGIN
		--For any patient, process the list of rules that have been selected		
			INSERT INTO   #NewRules   
				(
				HMRuleName,
				HMRuleUid,
				PatientName,
				PatientUid,
				IsDue,
				DueDate
				)
			SELECT DISTINCT 
				#RuleCriteria.HMRuleName,
				#RuleCriteria.HMRuleUid,
				Person.FirstName + ' ' + Person.LastName,
				Patient.PersonUid,		
				1,	
				CASE 
					WHEN PO.RelHMRulePatientOverrideUid IS NULL 
					THEN 
						CASE #RuleCriteria.AgeTimeTypeUid
							WHEN @Years THEN DATEADD(year,#RuleCriteria.AgeFrom,Person.BirthDate)
							WHEN @Months THEN DATEADD(month,#RuleCriteria.AgeFrom,Person.BirthDate)
							WHEN @Weeks THEN DATEADD(day,#RuleCriteria.AgeFrom * 7,Person.BirthDate)
							WHEN @Days THEN DATEADD(day,#RuleCriteria.AgeFrom,Person.BirthDate)
						END -- AS DueDate
					ELSE 
						CASE PO.AgeTimeTypeUid
							WHEN @Years THEN DATEADD(year,PO.AgeFrom,Person.BirthDate)
							WHEN @Months THEN DATEADD(month,PO.AgeFrom,Person.BirthDate)
							WHEN @Weeks THEN DATEADD(day,PO.AgeFrom * 7,Person.BirthDate)
							WHEN @Days THEN DATEADD(day,PO.AgeFrom,Person.BirthDate)
						END -- AS DueDate   
				END AS DueDate  
			FROM 
				Patient JOIN            
				Person ON 
					(Patient.Inactive  = 0 AND 
					Person.PersonUid = Patient.PersonUid AND 
					Person.DeathDate IS NULL) JOIN            
				#RuleCriteria ON 
					(Person.GenderUid = #RuleCriteria.GenderUid AND 
					Person.BirthDate 
						BETWEEN 
							#RuleCriteria.AgeToDate 
						AND 
							#RuleCriteria.AgeFromDate) LEFT JOIN       
				PatientHMRule ON 
					(PatientHMRule.HMRuleUid = #RuleCriteria.HMRuleUid AND 
					PatientHMRule.PatientUid = Patient.PersonUid AND 
					PatientHMRule.Inactive   = 0) LEFT JOIN       
				RelHMRulePatientOverride PO ON 
					(PO.PatientUid = Patient.PersonUid AND 
					PO.HMRuleUid = #RuleCriteria.HMRuleUid)  LEFT JOIN
				ViewCDSPatientDisease ON
					ViewCDSPatientDisease.PatientUid = Person.PersonUid  AND
					ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
				ViewCDSPatientMedicationNameOrClass ON
					ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid  AND
					(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
					ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
				ViewCDSPatientDrugAllergy  ON
					ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid  AND
					ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid    					
			WHERE           
				PatientHMRule.PatientHMRuleUid IS NULL AND
				Person.Birthdate 
					BETWEEN 
						CASE 
							WHEN PO.AgeTimeTypeUid IS NULL 
								THEN #RuleCriteria.AgeToDate
							WHEN PO.AgeTimeTypeUid = @Years  
								THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Months 
								THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Weeks  
								THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Days   
								THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
						END 
					AND 
						CASE 
							WHEN PO.AgeTimeTypeUid IS NULL 
								THEN #RuleCriteria.AgeFromDate                                               
							WHEN PO.AgeTimeTypeUid = @Years  
								THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Months 
								THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Weeks  
								THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Days   
								THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
						END
				AND
				(1 = 
					(CASE WHEN PO.Inactive IS NULL THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
						WHEN PO.Inactive = 1     THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
						WHEN PO.Inactive = 0     THEN 1  -- Override does exist.  Inactive flag for override is FALSE.  PatientRule is not disabled.
					END))  
				AND
				(1 = (CASE 
						WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientDisease.PatientUid = Person.PersonUid
							AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid
							AND 
							(
								(
									(#RuleCriteria.FDB_MNID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
									OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
								)
								AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
							)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid
							AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
						
			IF @ShowDebug = 1
			BEGIN
				SELECT 'NewRUles'
				SELECT COUNT(*) FROM #NewRules
				SELECT * FROM #NewRules
			END

			--If any rules have observation tests, generate the dynamic sql to make those tests,
			--then run that sql for all patients

			insert into @tempPatientRuleTable(HMRuleUid, PatientUid)
			SELECT 
				DISTINCT #NewRules.HMRuleUid,
				#NewRules.PatientUid
			FROM 
				#RuleCriteria  JOIN
				#NewRules  ON	#NewRules.HMRuleUid = #RuleCriteria.HMRuleUid
			WHERE
				#RuleCriteria.HasObservationCriteria <> 0;

			while(exists(select top 1 * from @tempPatientRuleTable))
			begin
				select top 1 @tempPK=PK, @tempObsPatientUid=PatientUid, @tempObsHMRuleUid=HMRuleUid 
				from @tempPatientRuleTable

				SET @Answer = NULL
				EXEC [PatientHasQualifyingObservation] 
					@tempObsPatientUid, @tempObsHMRuleUid, @Result = @Answer OUTPUT;
						
				IF @Answer IS NOT NULL
				BEGIN
				--Create the dynamic sql to run the test, then exec it to load a count of
				--hits on the rule.  If the number is positive, the rule is fired.
					INSERT INTO @ObservationTestCount  ( Found, PatientUid, HMRuleUid )
					exec (@Answer)
				END

				delete @tempPatientRuleTable where PK=@tempPK
			end

			--If any patients had observations outside the range desired, remove the rules 
			IF EXISTS (SELECT TOP 1 * FROM @ObservationTestCount WHERE Found = 0 )
			BEGIN
				DELETE FROM #NewRules
					FROM #NewRules AS nr JOIN 
						@ObservationTestCount otc ON 
							nr.PatientUid = otc.PatientUid AND
							nr.HMRuleUid = otc.HMRuleUid 
					WHERE 
						otc.Found = 0
			END
			
			IF @ShowDebug = 1
			BEGIN
				SELECT 'NewRUles AFTER Observation Test Validation'
				SELECT * FROM @ObservationTestCount
				SELECT COUNT(*) FROM #NewRules
				SELECT * FROM #NewRules
			END
			
			--Now review all existing rules that have gone inactive to see if they should be reactivated
			UPDATE   PatientHMRule
			SET       
				IsDue = 1, 
				LastModifiedDate = GETUTCDATE()
			FROM      
				PatientHMRule  JOIN      
				#RuleCriteria ON 
					(#RuleCriteria.HMRuleUid = PatientHMRule.HMRuleUid  AND 
					PatientHMRule.IsDue    = 0  AND 
					PatientHMRule.Inactive = 0)  JOIN  
				Patient ON 
					(Patient.PersonUid = PatientHMRule.PatientUid  AND 
					Patient.Inactive = 0)  JOIN      
				Person ON 
					(Person.PersonUid = Patient.PersonUid  AND 
					Person.DeathDate IS NULL  AND 
					Person.GenderUid = #RuleCriteria.GenderUid)  LEFT JOIN 
				RelHMRulePatientOverride PO ON 
					(PO.PatientUid = Patient.PersonUid  AND 
					PO.HMRuleUid = PatientHMRule.HMRuleUid)  LEFT JOIN
				ViewCDSPatientDisease ON
					ViewCDSPatientDisease.PatientUid = Person.PersonUid  AND
					ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
				ViewCDSPatientMedicationNameOrClass ON
					ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid  AND
					(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
					ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
				ViewCDSPatientDrugAllergy  ON
					ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid  AND
					ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid  LEFT JOIN
				@ObservationTestCount otc  ON
					(otc.PatientUid = Patient.PersonUid  AND
					otc.HMRuleUid = #RuleCriteria.HMRuleUid)    
			WHERE     
				Person.Birthdate 
					BETWEEN 
						CASE 
							WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeToDate
							WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
						END 
					AND 
						CASE 
							WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeFromDate                        
							WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Days THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
						END  
				AND       
                (@CurrentDate >= 
					CASE #RuleCriteria.AdvanceWarningTimeTypeUid
						WHEN @Years THEN DATEADD(year,-#RuleCriteria.AdvanceWarning,PatientHMRule.DueDate)
						WHEN @Months THEN DATEADD(month,-#RuleCriteria.AdvanceWarning, PatientHMRule.DueDate)
						WHEN @Weeks THEN DATEADD(day,-#RuleCriteria.AdvanceWarning * 7, PatientHMRule.DueDate)
						WHEN @Days THEN DATEADD(day, -#RuleCriteria.AdvanceWarning, PatientHMRule.DueDate)
					END)
				AND
				(1 = 
					(CASE
						WHEN PO.Inactive IS NULL THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
						WHEN PO.Inactive = 1     THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
						WHEN PO.Inactive = 0     THEN 1  -- Override does exist. Inactive flag for override is FALSE.  PatientRule is not disabled.
					END))
				AND
				(1 = (CASE 
						WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientDisease.PatientUid = Person.PersonUid
							AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid
							AND 
							(
								(
									(#RuleCriteria.FDB_MNID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
									OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
								)
								AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
							)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid
							AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.HasObservationCriteria < 1  THEN 1
						WHEN otc.Found > 0 THEN 1
						ELSE 0
						END))
				
				--Find any rules that should be deactivated
				INSERT INTO #CurrentPatientRules 
					(PatientHMRuleUid)
				SELECT 
					PatientHMRule.PatientHMRuleUid
				FROM   
					Patient  JOIN 
					Person ON 
						(Person.PersonUid = Patient.PersonUid  AND 
						Patient.Inactive = 0  AND 
						Person.DeathDate IS NULL)  JOIN 
					#RuleCriteria ON 
						Person.GenderUid = #RuleCriteria.GenderUid   JOIN 
					PatientHMRule ON 
						(PatientHMRule.HMRuleUid = #RuleCriteria.HMRuleUid  AND 
						PatientHMRule.PatientUid = Patient.PersonUid  AND 
						PatientHMRule.Inactive = 0)  LEFT JOIN 
					RelHMRulePatientOverride PO ON 
						(PO.PatientUid = Patient.PersonUid  AND 
						PO.HMRuleUid = #RuleCriteria.HMRuleUid)  LEFT JOIN
					ViewCDSPatientDisease ON
						ViewCDSPatientDisease.PatientUid = Person.PersonUid  AND
						ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
					ViewCDSPatientMedicationNameOrClass ON
						ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid  AND
						(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
						ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
					ViewCDSPatientDrugAllergy  ON
						ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid  AND
						ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid  LEFT JOIN
					@ObservationTestCount otc  ON
						(otc.PatientUid = Patient.PersonUid  AND
						otc.HMRuleUid = #RuleCriteria.HMRuleUid)
				WHERE  
					Person.Birthdate 
						BETWEEN 
							CASE
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeToDate
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
							END 
						AND     
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeFromDate                     
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
							END 
					AND         
					(1 = 
						(CASE 
							WHEN PO.Inactive IS NULL THEN 1 -- Override does not exist.  Therefore, PatientHMRule is not disabled.
							WHEN PO.Inactive = 1 THEN 0  -- Override does exist. Inactive flag for override is TRUE.   PatientRule is disabled.
							WHEN PO.Inactive = 0  THEN 1  -- Override does exist. Inactive flag for override is FALSE. PatientRule is not disabled.
						END))
					AND
					(1 = (CASE 
							WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDisease.PatientUid = Person.PersonUid
								AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
						END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid
								AND 
								(
									(
										(#RuleCriteria.FDB_MNID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
										OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
									)
									AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
									AND	(ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
								)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
						END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid
								AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.HasObservationCriteria < 1  THEN 1
							WHEN otc.Found > 0 THEN 1
							ELSE 0
							END))


								                                              
		END  --  EXISTS ( SELECT TOP 1 * FROM #RuleCriteria )
	END   -- @PatientUid IS  NULL
	

	IF @ShowDebug = 1
	BEGIN
		SELECT '#CurrentPatientRules'
		SELECT COUNT(*) FROM #CurrentPatientRules
		SELECT * FROM #CurrentPatientRules
	END

/************************************************************************************************/
/************************************************************************************************/
/* Insert the Selected Rules and clean up the temp tables										*/
/************************************************************************************************/
/************************************************************************************************/

	IF EXISTS ( SELECT TOP 1 * FROM #NewRules)
	BEGIN
	
/* Adjust the DueDate for CurrentDate															*/
/************************************************************************************************/
		UPDATE 	#NewRules
		SET 	    
			DueDate = @CurrentDate
		WHERE 	
			DueDate < @CurrentDate

/* Calculate the PastDueDate 																	*/
/************************************************************************************************/
		UPDATE #NewRules
		SET 
			PastDueDate = 
				CASE RecurTimeTypeUid
					WHEN @Years THEN DATEADD(year,RecurTo - RecurFrom,DueDate)
					WHEN @Months THEN DATEADD(month,RecurTo - RecurFrom,DueDate)
					WHEN @Weeks THEN DATEADD(day,(RecurTo - RecurFrom) * 7,DueDate)
					WHEN @Days THEN DATEADD(day,RecurTo - RecurFrom,DueDate)
				END -- AS PastDueDate
		FROM 
			#NewRules   JOIN 
			ListHMRule ON 
				ListHMRule.HMRuleUid = #NewRules.HMRuleUid


/* If recurring rule and max recurrences has been reached, then don't readd the rule */
/* Fix for TFS Bug #16606.                                                           */
/*************************************************************************************/   
		DELETE FROM #NewRules 
		WHERE 
			EXISTS 
				(SELECT 
					* 
				FROM   
					ListHMRule 
				WHERE  
					ListHMRule.HMRuleUid = #NewRules.HMRuleUid   AND 
					(
						(ListHMRule.LimitRecurrences = 1  AND 
							(SELECT	COUNT(*)    
								FROM   
									PatientHMRule   INNER JOIN 
									PatientHMRuleDetail ON 
										PatientHMRuleDetail.PatientHMRuleUid = PatientHMRule.PatientHMRuleUid
								WHERE  
									PatientHMRule.PatientUid = #NewRules.PatientUid   AND 
									PatientHMRule.HMRuleUid = #NewRules.HMRuleUid
							) >= ListHMRule.MaxRecurrence
						)  OR
						(ListHMRule.RecurFrom = 0 AND ListHMRule.RecurTo = 0  -- this is a one time rule
							AND EXISTS (SELECT *            
										FROM   PatientHMRule 
										WHERE  PatientHMRule.PatientUid = #NewRules.PatientUid 
											   AND PatientHMRule.HMRuleUid = #NewRules.HMRuleUid 
											   AND PatientHMRule.Inactive = 1   -- one time rule is inactive
											   AND PatientHMRule.IsDue = 0)      -- one time rule is not due
						) 
					) 
				)

/* Bug #10552 - HMR Rule pop-up based on actioning a recurring rule should not occur. */
/* Determine how many patient rules are being readded.                          */
		DECLARE @NumRulesBeingReAdded int 
		SET @NumRulesBeingReAdded = 0

		IF @PatientUid IS NOT NULL
		BEGIN
		
			SET @NumRulesBeingReAdded = 
				(SELECT 
					COUNT(*) 
				FROM  
					PatientHMRule phmr INNER JOIN 
					#NewRules nr ON  
						(phmr.HMRuleUid  = nr.HMRuleUid   AND 
						phmr.PatientUid = nr.PatientUid  AND 
						phmr.Inactive   = 1))

			IF @NumRulesBeingReAdded IS NULL
			BEGIN
			SET @NumRulesBeingReAdded = 0
			END   
			
		END   --@PatientUid IS NOT NULL

/* Insert the New Rules 																		*/
/************************************************************************************************/
		INSERT INTO [PatientHMRule]
		(
			[HMRuleUid],
			[PatientUid],
			[IsDue],
			[DueDate],
			[PastDueDate]
		)
		SELECT
			vphmr.[HMRuleUid],
			vphmr.[PatientUid],
			vphmr.[IsDue],
			DATEADD(n, @Mins, vphmr.[DueDate]),
			DATEADD(n, @Mins, vphmr.[PastDueDate])
		FROM #NewRules AS  vphmr
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
			LEFT OUTER JOIN [PatientHMRule] AS phmr ON vphmr.[HMRuleUid] = phmr.[HMRuleUid]
				AND vphmr.[PatientUid] = phmr.[PatientUid]
				AND vphmr.[IsDue] = phmr.[IsDue]
				AND phmr.[Inactive] = 0
		WHERE phmr.[PatientHMRuleUid] IS NULL
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group

/* Increment the Rule Count 																	*/
/**********************************************************************************************/
		SET @RuleCount = @@RowCount - @NumRulesBeingReAdded
		
	END  --EXISTS ( SELECT TOP 1 * FROM #NewRules)


-- =====================================================================================================================
-- Do not include any HM Rules that only display an alert popup message.  Alert popup messages are display on demand.
-- IF HMRuleUid is not in RelHMRuleProcedure,
--   THEN no procedure to complete is associated with the HM rule - therefore, rule only displays an alert message. 
-- =====================================================================================================================
	DECLARE @HMRuleToDelete_TBL TABLE
	(
		[HMRuleUid] [uniqueidentifier] primary key
	)

    IF @PatientUid IS NOT NULL
    BEGIN
		INSERT @HMRuleToDelete_TBL
		SELECT DISTINCT rhmrp.[HMRuleUid]
		FROM [RelHMRuleProcedure] AS rhmrp with(nolock)
			INNER JOIN [PatientHMRule] as phmr with(nolock) on rhmrp.[HMRuleUid] = phmr.[HMRuleUid]
		WHERE phmr.[PatientUid] = @PatientUid
    END
    ELSE
    BEGIN
		INSERT @HMRuleToDelete_TBL
		SELECT DISTINCT [HMRuleUid]
		FROM [RelHMRuleProcedure] with(nolock)
	END

	IF EXISTS(
		SELECT TOP 1 *
		FROM @HMRuleToDelete_TBL
	)
	BEGIN
		IF @PatientUid IS NOT NULL
		BEGIN
			DELETE FROM [PatientHMRule] 
			WHERE [PatientUid] = @PatientUid
				AND [HMRuleUid] NOT IN ( SELECT [HMRuleUid] FROM @HMRuleToDelete_TBL )
		END
		ELSE
		BEGIN
			DELETE FROM [PatientHMRule] 
			WHERE [HMRuleUid] NOT IN ( SELECT [HMRuleUid] FROM @HMRuleToDelete_TBL )
		END
	END

	IF @ShowDebug = 1
	BEGIN
		SELECT '@InactivateNonRelevantPatientRules'
		SELECT @InactivateNonRelevantPatientRules
	END

-- ===================================================
-- Inactivate patient rules that no long meet criteria
-- ===================================================
	IF @InactivateNonRelevantPatientRules = @TRUE
	BEGIN
		
		IF @ShowDebug = 1
		BEGIN
			SELECT '@InactivateNonRelevantPatientRules = @TRUE'
		END
	
		IF EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)
		BEGIN
		
			IF @ShowDebug = 1
			BEGIN
				SELECT 'EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)'
			END
		
			IF EXISTS (SELECT TOP 1 * FROM #CurrentPatientRules)
			BEGIN
			
				IF @ShowDebug = 1
				BEGIN
					SELECT '#NonRelevantPatientRules 1'
				END
-- Take initial list of patient rules and remove current list of patient rules.
-- Remaining list should be patient rules that no longer meet the criteria.
				DELETE FROM #NonRelevantPatientRules 
				WHERE 
					PatientHMRuleUid IN 
						(SELECT DISTINCT(PatientHMRuleUid) FROM #CurrentPatientRules)
			END   --EXISTS (SELECT TOP 1 * FROM #CurrentPatientRules)

-- Check if there are any patient rules that no longer meet patient rule criteria.
			IF EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)
			BEGIN
				IF @ShowDebug = 1
				BEGIN
					SELECT '#NonRelevantPatientRules 2'
				END
			
				DECLARE @DeleteIncompleteIsDueMsgs BIT      
				SET @DeleteIncompleteIsDueMsgs = 
					(SELECT TOP 1 HMRulesDeleteNonRelevantIsDueMessages FROM PracticeSettings)  

				DECLARE @CompleteIncompleteIsDueMsgs BIT
				SELECT @CompleteIncompleteIsDueMsgs = 
					(SELECT TOP 1 HMRulesCompleteNonRelevantIsDueMessages FROM PracticeSettings)   

				DECLARE @CompletedByUid UNIQUEIDENTIFIER
				SET @CompletedByUid = 
					(SELECT TOP 1 HMRulesCompletedByUid FROM PracticeSettings) 

				IF @DeleteIncompleteIsDueMsgs = @TRUE
				BEGIN
					IF @ShowDebug = 1
					BEGIN
						SELECT '#NonRelevantPatientRules 3'
					END
				
-- Delete any incomplete HMRuleIsDueAlert messages that are associated to patient rules that no longer meet rule criteria.  
-- Db trigger will delete MessageUser and MessageTask rows.
					DELETE FROM Message 
					WHERE 
						MessageUid IN 
							(SELECT DISTINCT 
								msg.MessageUid 
							FROM   
								#NonRelevantPatientRules nrpr   JOIN 
								MessageTask mt ON 
									mt.PatientHMRuleUid = nrpr.PatientHMRuleUid  	JOIN 
									Message msg ON 
										msg.MessageUid = mt.MessageUid 
							WHERE  
								mt.PatientHMRuleUid IS NOT NULL   AND 
								msg.CompletedByUid IS NULL   AND 
								msg.DateCompleted IS NULL) 
								
				END     --@DeleteIncompleteIsDueMsgs = @TRUE
				ELSE 
				BEGIN  
					IF @ShowDebug = 1
					BEGIN
						SELECT '#NonRelevantPatientRules 4'
					END
				
-- Complete any incomplete HMRuleIsDueAlert messages that are associated to patient rules that no longer meet rule criteria.

					IF @CompleteIncompleteIsDueMsgs = @TRUE   AND 
						@CompletedByUid IS NOT NULL   AND 
						@CompletedByUid <> CAST('00000000-0000-0000-0000-000000000000' AS UNIQUEIDENTIFIER)
					BEGIN     
					
						UPDATE Message 
						SET 
							CompletedByUid = @CompletedByUid, 
							DateCompleted = GETUTCDATE()
						WHERE 
							MessageUid IN 
								(SELECT DISTINCT 
									msg.MessageUid 
								FROM   
									#NonRelevantPatientRules nrpr   JOIN 
									MessageTask mt ON 
										mt.PatientHMRuleUid = nrpr.PatientHMRuleUid  JOIN 
									Message msg ON 
										msg.MessageUid = mt.MessageUid 
								WHERE  
									mt.PatientHMRuleUid IS NOT NULL   AND 
									msg.CompletedByUid IS NULL   AND 
									msg.DateCompleted IS NULL)
									
					END       --complex test starting @CompleteIncompleteIsDueMsgs = @TRUE   AND 
					
				END   --  NOT  @DeleteIncompleteIsDueMsgs = @TRUE

				IF @ShowDebug = 1
				BEGIN
					SELECT '#NonRelevantPatientRules 5'
				END
-- Delete any patient rules that no longer meet criteria and have no PatientHMRuleDetail and MessageTask rows.
				DELETE FROM PatientHMRule 
				WHERE 
					PatientHMRule.PatientHMRuleUid IN 
						(SELECT DISTINCT 
							nrpr.PatientHMRuleUid
						FROM   
							#NonRelevantPatientRules nrpr   LEFT JOIN 
							MessageTask mt ON 
								mt.PatientHMRuleUid = nrpr.PatientHMRuleUid  LEFT JOIN 
							PatientHMRuleDetail phmrd ON 
								phmrd.PatientHMRuleUid = nrpr.PatientHMRuleUid
						WHERE  
							mt.PatientHMRuleUid IS NULL   AND 
							phmrd.PatientHMRuleUid IS NULL)

-- Inactivate remaining patient rules that no longer meet criteria.
--   These patient rules probable have PatientHMRuleDetail and/or MessageTask rows. 
				UPDATE   PatientHMRule 
				SET 
					Inactive = @TRUE, 
					LastModifiedDate = GETUTCDATE()
				WHERE 
					PatientHMRuleUid IN 
						(SELECT DISTINCT 
							nrpr.PatientHMRuleUid 
						FROM   
							#NonRelevantPatientRules nrpr   LEFT JOIN 
							MessageTask mt ON 
								mt.PatientHMRuleUid = nrpr.PatientHMRuleUid  LEFT JOIN 
							PatientHMRuleDetail phmrd ON 
								phmrd.PatientHMRuleUid = nrpr.PatientHMRuleUid                                     
						WHERE  
							mt.PatientHMRuleUid IS NOT NULL   OR 
							phmrd.PatientHMRuleUid IS NOT NULL) 
					AND Inactive != @TRUE
					
			END   -- EXISTS (SELECT TOP 1 * FROM #CurrentPatientRules)
			
		END -- EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)
		
	END -- IF @InactivateNonRelevantPatientRules = @TRUE

	COMMIT TRAN

	DROP TABLE #RuleCriteria
	DROP TABLE #NewRules
	DROP TABLE #NonRelevantPatientRules
	DROP TABLE #CurrentPatientRules

/* RETURN the Rule Count 																		*/
/************************************************************************************************/
	IF @PatientUid IS NOT NULL
	BEGIN
	  SELECT @RuleCount
	END

END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RemoveDuplicateExternalID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RemoveDuplicateExternalID] AS' 
END
GO
ALTER PROC [dbo].[RemoveDuplicateExternalID]
@TableName	varchar(50)
AS

BEGIN
	DECLARE @SqlString nvarchar(1000)

	SET @SqlString = N'
	DECLARE @ExtID int

	DECLARE csrExternalID CURSOR DYNAMIC FOR 
	  SELECT ExternalID FROM [' + @TableName + ']
		WHERE ExternalID in 
		  (SELECT ExternalID FROM [' + @TableName + '] GROUP BY ExternalID HAVING COUNT(*) > 1) OR ExternalID is null
	FOR UPDATE

	OPEN csrExternalID
	FETCH NEXT FROM csrExternalID

	WHILE @@FETCH_STATUS = 0
	BEGIN
	  EXEC @ExtID = GetUniqueID ''' + @TableName + '''
	  UPDATE [' + @TableName + '] SET ExternalID = @ExtID WHERE CURRENT OF csrExternalID
	  FETCH NEXT FROM csrExternalID
	END

	CLOSE csrExternalID
	DEALLOCATE csrExternalID'

	EXECUTE sp_executesql @SqlString
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AddMissingRPsAndAccounts]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AddMissingRPsAndAccounts] AS' 
END
GO
ALTER PROC [dbo].[AR_AddMissingRPsAndAccounts]
AS

-- Add missing RPs and accounts as needed. Useful after incomplete migrations or HL7 inserts.
set nocount on
declare @ext int
select top 1 @ext = Seedvalue from SeedTable where SeedName = 'Account'
set @ext = coalesce(1 + @ext, 1)

insert into AccountResponsibleParty(PersonUid)
select PersonUid from Person 
where PersonUid not in (select PersonUid from Account WITH (NOLOCK)) 
and PersonUid not in (select PersonUid from AccountResponsibleParty WITH (NOLOCK) where PersonUid is not null)

insert into Account(Name, ExternalID, PersonUid, AccountResponsiblePartyUid, IsMain, ResponsiblePartyRelationshipUid)
select 'Main', @ext, PersonUid, AccountResponsiblePartyUid, 1, '7B4C63C7-FE13-48EF-81E5-3AFC963F3FEE' from AccountResponsibleParty 
where PersonUid is not null and PersonUid not in (select PersonUid from Account WITH (NOLOCK))

insert into AccountPeriod(AccountUid)
select AccountUid from Account 
where AccountUid not in (select AccountUid from AccountPeriod WITH (NOLOCK))

exec RemoveDuplicateExternalID 'Account'
exec RemoveDuplicateExternalID 'AccountResponsibleParty'

-- set RP relationship to self when misset
update Account set ResponsiblePartyRelationshipUid = '7B4C63C7-FE13-48EF-81E5-3AFC963F3FEE' 
from AccountResponsibleParty 
where Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid 
and (Account.ResponsiblePartyRelationshipUid is null or Account.ResponsiblePartyRelationshipUid != '7B4C63C7-FE13-48EF-81E5-3AFC963F3FEE')
and Account.PersonUid = AccountResponsibleParty.PersonUid

--set RP relationship to unknown when misset to self
update Account set ResponsiblePartyRelationshipUid = '11EADEE6-52DC-4FE1-BFD4-E1C03ABAAA51' 
from AccountResponsibleParty 
where Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid
and Account.ResponsiblePartyRelationshipUid = '7B4C63C7-FE13-48EF-81E5-3AFC963F3FEE'
and Account.PersonUid != AccountResponsibleParty.PersonUid

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ResetAccountInsuranceDisplayOrder]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ResetAccountInsuranceDisplayOrder] AS' 
END
GO



ALTER PROCEDURE [dbo].[ResetAccountInsuranceDisplayOrder]
	@accountUid uniqueidentifier = null 
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	-- This 'trick' is used in ControlAccount to deal with some save issues in the Display Orders 
	-- Do not remember details but is needed for way implemented in past
	-- Bug 33960 Updated 
	-- Also related to past CASE Case # 00187841
	-- 2014-12-02 BMR
	
	IF (@accountUid IS NULL) -- keeping old implementation but should not be called this way any longer -- bug 33960
		BEGIN
			UPDATE AccountInsurance SET DisplayOrder = DisplayOrder - 100
				WHERE DisplayOrder > 100;
		END
	ELSE
		BEGIN
			UPDATE AccountInsurance 
				SET AccountInsurance.DisplayOrder = AccountInsurance.DisplayOrder - 100
				FROM AccountInsurance 
					INNER JOIN AccountPeriod ON AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid
				WHERE AccountPeriod.AccountUid = @accountUid
					AND AccountInsurance.DisplayOrder > 100;
		END

END



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AuditAccountPeriods]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AuditAccountPeriods] AS' 
END
GO



ALTER PROC [dbo].[AR_AuditAccountPeriods]
	@AccountUid uniqueidentifier = null 
AS

	-- first, fix up display orders
	-- see notes in ResetAccountInsuranceDisplayOrder for details
	EXEC ResetAccountInsuranceDisplayOrder @accountUid = @AccountUid; -- this audit gets called by ControlAccount

--Audits the specified account, or all if not specified
	if @AccountUid is NULL
	begin

		--Any dupe or missing main accounts for persons with accounts?
		if exists(select PersonUid from Account where IsMain = 1 group by PersonUid having count(*) > 1)
			begin
				RAISERROR('There are persons with multiple main accounts', 16, 1)
				return
			end

		if exists(select PersonUid from Account where PersonUid not in (select a2.PersonUid from Account a2 where a2.IsMain = 1))
			begin
				RAISERROR('There are persons without main accounts', 16, 1)
				return
			end

		--Any out of order effective date and termination date?
		if exists(select * from AccountPeriod where EffectiveDate is not null and ExpirationDate is not null and EffectiveDate > ExpirationDate)
			begin
				RAISERROR('There is an invalid account period with effective date after its expiration date', 16, 1)
				return
			end

		--Any overlapping account periods?
		if exists(select * from AccountPeriod ap1, AccountPeriod ap2 where ap1.AccountUid = ap2.AccountUid and ap1.AccountPeriodUid != ap2.AccountPeriodUid and ((ap1.EffectiveDate is null and ap2.EffectiveDate is null) or (ap1.EffectiveDate is not null and ap2.EffectiveDate is not null and ap1.EffectiveDate = ap2.EffectiveDate)))
			begin
				RAISERROR('There are invalid overlapping account periods (duplicate effective dates)', 16, 1)
				return
			end
		if exists(select * from AccountPeriod ap1, AccountPeriod ap2 where ap1.AccountUid = ap2.AccountUid and ap1.AccountPeriodUid != ap2.AccountPeriodUid and ap2.EffectiveDate is not null and (ap1.EffectiveDate is null or ap1.EffectiveDate < ap2.EffectiveDate) and (ap1.ExpirationDate is null or dateadd(dd, 1, ap1.ExpirationDate) > ap2.EffectiveDate))
			begin
				RAISERROR('There are invalid overlapping account periods', 16, 1)
				return
			end

		--Any bad insurance orders?
		if exists(select * from AccountInsurance ai, AccountPeriod ap where ai.AccountPeriodUid = ap.AccountPeriodUid and ai.DisplayOrder < 1)
			begin
				RAISERROR('There is an invalid insurance order', 16, 1)
				return
			end
		if exists(select * from AccountInsurance ai1, AccountInsurance ai2, AccountPeriod ap where ai1.AccountPeriodUid = ap.AccountPeriodUid and ai2.AccountPeriodUid = ap.AccountPeriodUid and ai1.AccountInsuranceUid != ai2.AccountInsuranceUid and ai1.DisplayOrder = ai2.DisplayOrder)
			begin
				RAISERROR('There are duplicate insurance orders', 16, 1)
				return
			end
		if exists(select * from AccountInsurance ai1, AccountPeriod ap where ai1.AccountPeriodUid = ap.AccountPeriodUid and ai1.DisplayOrder > 1 and not exists(select * from AccountInsurance ai2 where ai2.AccountPeriodUid = ai1.AccountPeriodUid and ai2.DisplayOrder = (ai1.DisplayOrder - 1)))
			begin
				RAISERROR('There are missing insurance orders', 16, 1)
				return
			end
	end
	else --we have an accountuid
	begin

		--Any dupe or missing main accounts for persons with accounts?
		if exists(select PersonUid from Account where (AccountUid = @AccountUid) and IsMain = 1 group by PersonUid having count(*) > 1)
			begin
				RAISERROR('There are persons with multiple main accounts', 16, 1)
				return
			end

		if exists(select PersonUid from Account where (AccountUid = @AccountUid) and PersonUid not in (select a2.PersonUid from Account a2 where a2.IsMain = 1))
			begin
				RAISERROR('There are persons without main accounts', 16, 1)
				return
			end

		--Any out of order effective date and termination date?
		if exists(select * from AccountPeriod where (AccountUid = @AccountUid) and EffectiveDate is not null and ExpirationDate is not null and EffectiveDate > ExpirationDate)
			begin
				RAISERROR('There is an invalid account period with effective date after its expiration date', 16, 1)
				return
			end

		--Any overlapping account periods?
		if exists(select * from AccountPeriod ap1, AccountPeriod ap2 where (ap1.AccountUid = @AccountUid) and ap1.AccountUid = ap2.AccountUid and ap1.AccountPeriodUid != ap2.AccountPeriodUid and ((ap1.EffectiveDate is null and ap2.EffectiveDate is null) or (ap1.EffectiveDate is not null and ap2.EffectiveDate is not null and ap1.EffectiveDate = ap2.EffectiveDate)))
			begin
				RAISERROR('There are invalid overlapping account periods (duplicate effective dates)', 16, 1)
				return
			end
		if exists(select * from AccountPeriod ap1, AccountPeriod ap2 where (ap1.AccountUid = @AccountUid) and ap1.AccountUid = ap2.AccountUid and ap1.AccountPeriodUid != ap2.AccountPeriodUid and ap2.EffectiveDate is not null and (ap1.EffectiveDate is null or ap1.EffectiveDate < ap2.EffectiveDate) and (ap1.ExpirationDate is null or dateadd(dd, 1, ap1.ExpirationDate) > ap2.EffectiveDate))
			begin
				RAISERROR('There are invalid overlapping account periods', 16, 1)
				return
			end

		--Any bad insurance orders?
		if exists(select * from AccountInsurance ai, AccountPeriod ap where (ap.AccountUid = @AccountUid) and ai.AccountPeriodUid = ap.AccountPeriodUid and ai.DisplayOrder < 1)
			begin
				RAISERROR('There is an invalid insurance order', 16, 1)
				return
			end
		if exists(select * from AccountInsurance ai1, AccountInsurance ai2, AccountPeriod ap where (ap.AccountUid = @AccountUid) and ai1.AccountPeriodUid = ap.AccountPeriodUid and ai2.AccountPeriodUid = ap.AccountPeriodUid and ai1.AccountInsuranceUid != ai2.AccountInsuranceUid and ai1.DisplayOrder = ai2.DisplayOrder)
			begin
				RAISERROR('There are duplicate insurance orders', 16, 1)
				return
			end
		if exists(select * from AccountInsurance ai1, AccountPeriod ap where (ap.AccountUid = @AccountUid) and ai1.AccountPeriodUid = ap.AccountPeriodUid and ai1.DisplayOrder > 1 and not exists(select * from AccountInsurance ai2 where ai2.AccountPeriodUid = ai1.AccountPeriodUid and ai2.DisplayOrder = (ai1.DisplayOrder - 1)))
			begin
				RAISERROR('There are missing insurance orders', 16, 1)
				return
			end
	end


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AuditAggregates]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AuditAggregates] AS' 
END
GO



ALTER PROCEDURE [dbo].[AR_AuditAggregates]      
   
AS    

/*
	Using this SP to test the financials for consistancy ... 
	For each block added, document what it tests for, what the startup state should be and what the ending state is expected to be
*/  


/*
	This was an issue in MHUC
	BMR 20120822 - Added after found issue on site
*/
select distinct sb.ExternalID, CASE WHEN ISNULL(l.VoidLedgerUid, los.LedgerUid) IS NULL THEN 0 ELSE 1 END AS Voided
	--into #temp_MismatchedInsurancePlans
	from AR_LedgerDetail ld
		inner join AR_Ledger l on ld.LedgerUid = l.LedgerUid
		left join AR_Ledger los on l.LedgerUid = los.VoidLedgerUid
		--inner join AR_LedgerDetail ldos on ld.LedgerUid = ldos.LedgerUid and ld.IsCredit != ldos.IsCredit
		inner join SuperbillProcedure sbp on ld.SuperbillProcedureUid = sbp.SuperbillProcedureUid
		inner join ViewSuperbillInsurance sb on sbp.SuperbillUid = sb.SuperbillUid and ld.LiabilityOwner = sb.DisplayOrder
	where ld.LiabilityOwner > 0 -- insurance only
		and ld.InsurancePlanUid != sb.InsurancePlanUid -- mismatched plan
	order by sb.ExternalID

/*
select *
	from ViewSuperbillInsurance
	where externalid = 'FPZ4180'
*/



/*
OLD CONTENT
EXEC AR_SetSuperbillAggregate @processAll = 1 -- update Superbill Aggregate
EXEC AR_SetDepositAggregate  -- update Deposit Aggregate
EXEC AR_SetBatchIsClosedAggregate -- Update ARBatch.IsClosed
*/


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AuditFeeSchedulePeriods]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AuditFeeSchedulePeriods] AS' 
END
GO


ALTER PROC [dbo].[AR_AuditFeeSchedulePeriods] 
	@FeeScheduleUid uniqueidentifier = null 
AS
--Audits the specified FeeSchedule, or all if not specified

	DECLARE @ErrorMessage as varchar(100)
	DECLARE @ErrorMessage2 as varchar(100)
	SET @ErrorMessage = 'The Fee Schedule data in the database may be corrupted: '
	if  @FeeScheduleUid is not null
		SET @ErrorMessage2 = 'Click on the FIX button in the Fee Schedule Period Section to try and fix the problem.'

	--Any out of order effective date and termination date?
	if exists(select * from FeeSchedulePeriod where (@FeeScheduleUid is null or FeeScheduleUid = @FeeScheduleUid) and EffectiveDate is not null and ExpirationDate is not null and EffectiveDate > ExpirationDate)
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There is an invalid FeeSchedule period with effective date after its expiration date.', @ErrorMessage2)
			return
		end

	--Any overlapping FeeSchedule periods?
	if exists(select * from FeeSchedulePeriod ap1, FeeSchedulePeriod ap2 where (@FeeScheduleUid is null or ap1.FeeScheduleUid = @FeeScheduleUid) and ap1.FeeScheduleUid = ap2.FeeScheduleUid and ap1.FeeSchedulePeriodUid != ap2.FeeSchedulePeriodUid and ((ap1.EffectiveDate is null and ap2.EffectiveDate is null) or (ap1.EffectiveDate is not null and ap2.EffectiveDate is not null and ap1.EffectiveDate = ap2.EffectiveDate)))
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There are invalid overlapping FeeSchedule periods (duplicate effective dates).', @ErrorMessage2)
			return
		end
	if exists(select * from FeeSchedulePeriod ap1, FeeSchedulePeriod ap2 where (@FeeScheduleUid is null or ap1.FeeScheduleUid = @FeeScheduleUid) and ap1.FeeScheduleUid = ap2.FeeScheduleUid and ap1.FeeSchedulePeriodUid != ap2.FeeSchedulePeriodUid and ap2.EffectiveDate is not null and (ap1.EffectiveDate is null or ap1.EffectiveDate < ap2.EffectiveDate) and (ap1.ExpirationDate is null or dateadd(dd, 1, ap1.ExpirationDate) > ap2.EffectiveDate))
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There are invalid overlapping FeeSchedule periods.', @ErrorMessage2)
			return
		end

	--Any RVU schedules incorrectly set to allow auto update/populate?
	if exists(select * from FeeSchedule FS INNER JOIN FeeSchedulePeriod FSP ON FS.FeeScheduleUid = FSP.FeeScheduleUid  
			where (@FeeScheduleUid is null or FS.FeeScheduleUid = @FeeScheduleUid) and FSP.RVUScheduleUid is not null and FSP.IsAutoPopulated = 1)
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There is an RVU based FeeSchedule that is misset to allow automatic population from payment entry.', @ErrorMessage2)
			return
		end

	if exists(select * from FeeSchedule FS INNER JOIN FeeSchedulePeriod FSP ON FS.FeeScheduleUid = FSP.FeeScheduleUid 
			where (@FeeScheduleUid is null or FS.FeeScheduleUid = @FeeScheduleUid) and FSP.RVUScheduleUid is not null and FSP.IsAutoUpdated = 1)
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There is an RVU based FeeSchedulePeriod that is misset to allow automatic updates from payment entry.', @ErrorMessage2)
			return
		end

	--Any schedules have conflicting amount allowed settings?
	if exists(select * from FeeScheduleFee where (@FeeScheduleUid is null or FeeSchedulePeriodUid in (select FeeSchedulePeriodUid from FeeSchedulePeriod where FeeScheduleUid = @FeeScheduleUid)) and 1 < Convert(int, IsInsurancePlanPhysician) + Convert(int, IsInsurancePlanOther) + (case when FixedCopayAmount is null then 0 else 1 end) + (case when InsurancePercent is null then 0 else 1 end))
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There are schedules with conflicting amount allowed settings.', @ErrorMessage2)
			return
		end


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AutoUncompleteBatch]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AutoUncompleteBatch] AS' 
END
GO




ALTER PROC [dbo].[AR_AutoUncompleteBatch]
	@arBatchUid UNIQUEIDENTIFIER
AS

	UPDATE ARBatch SET IsLocked = 0, LastModifiedDate = GETUTCDATE()
		WHERE ARBatchUid = @arBatchUid




GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_ChangeBatch_SuperbillProcedures]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_ChangeBatch_SuperbillProcedures] AS' 
END
GO





ALTER PROCEDURE [dbo].[AR_ChangeBatch_SuperbillProcedures] 
(
	@arBatchUidTarget UNIQUEIDENTIFIER = NULL,
	@superbillProcedureUids VARCHAR(MAX) = NULL
)
AS
BEGIN 

	-- used by SuperbillProcedure.ChangeARBatch to change batch
	SELECT Element AS SuperbillProcedureUid
		INTO #tempSuperbillProceduresSelected
		FROM dbo.Split(@superbillProcedureUids,',');
	
	-- Audit Batch changes
	DECLARE @chgDesc VARCHAR(2000) -- LENGTH OF Audit.changes
	-- NOTE:  Using 'STUFF' to allow XML PATH to concatenate however I can't directly put results into @chgDesc.  STUFF works around that.
	SELECT @chgDesc = STUFF(
							',' + (select 'Superbill=''' + sb.ExternalID + ''', Procedure=''' + lp.Code + ''''
							from #tempSuperbillProceduresSelected tps
									left outer join SuperbillProcedure sbp with (nolock) on tps.SuperbillProcedureUid = sbp.SuperbillProcedureUid
									left outer join ListProcedure lp with (nolock) on sbp.ProcedureUid = lp.ProcedureUid
									left outer join Superbill sb with (nolock) on sbp.SuperbillUid = sb.SuperbillUid
							for XML PATH('AR_ChangeBatch_SuperbillProcedures')),
							1,1,'')	

	Insert into AuditCurrent(AuditUid, Type, Changes, Workstation, UserUid, ChangeDate, Description, LastModifiedDate )
	Values ( NEWID(), 'Aprima-SQL', 
			'<audit date="' + convert(nvarchar(30),GetUTCDate(), 120) +'"' +
				'<sql="' + 'AR_ChangeBatch_SuperbillProcedures @arBatchUidTarget=''' + CONVERT(varchar(max), @arBatchUidTarget) + ''', @superbillProcedureUids=''' + @superbillProcedureUids + '''' + '" />' +
				'</audit>', 
			'Unknown', null, GETUTCDATE(), 
			@chgDesc, 
			GETUTCDATE() )	
	-- End audit batch changes

	-- Actual batch change
	UPDATE AR_Ledger  
		SET AR_Ledger.ARBatchUid = @arBatchUidTarget
		FROM AR_Ledger 
			INNER JOIN AR_LedgerDetail LD ON AR_Ledger.LedgerUid = LD.LedgerUid
												AND AR_Ledger.EntryType = 1 -- Charge
			INNER JOIN ARBatch ARB ON AR_Ledger.ArBatchUid = ARB.ARBatchUid
			INNER JOIN #tempSuperbillProceduresSelected SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		WHERE ARB.IsLocked = 0 AND ARB.IsClosed = 0;

	DROP TABLE #tempSuperbillProceduresSelected;

	SELECT 'NameValuePair' -- blocking failure
	SELECT 'Return Info','None'

END








GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_ChangeBatch_Superbills]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_ChangeBatch_Superbills] AS' 
END
GO




ALTER PROCEDURE [dbo].[AR_ChangeBatch_Superbills] 
(
	@arBatchUidTarget UNIQUEIDENTIFIER = NULL,
	@superbillUids VARCHAR(MAX) = NULL
)
AS
BEGIN 
	-- used by Superbill.ChangeARBatch to change batch

	SELECT Element AS SuperbillUid
		INTO #tempSuperbillsSelected
		FROM dbo.Split(@superbillUids,',');

	-- Audit Batch changes
	DECLARE @chgDesc VARCHAR(2000) -- LENGTH OF Audit.changes
	-- NOTE:  Using 'STUFF' to allow XML PATH to concatenate however I can't directly put results into @chgDesc.  STUFF works around that.
	SELECT @chgDesc = STUFF(
							',' + (select 'Superbill=''' + sb.ExternalID + ''''
							from #tempSuperbillsSelected tps
									left outer join Superbill sb with (nolock) on tps.SuperbillUid = sb.SuperbillUid
							for XML PATH('AR_ChangeBatch_Superbills')),
							1,1,'')	

	Insert into AuditCurrent(AuditUid, Type, Changes, Workstation, UserUid, ChangeDate, Description, LastModifiedDate )
	Values ( NEWID(), 'Aprima-SQL', 
			'<audit date="' + convert(nvarchar(30),GetUTCDate(), 120) +'"' +
				'<sql="' + 'AR_ChangeBatch_Superbills @arBatchUidTarget=''' + CONVERT(varchar(max), @arBatchUidTarget) + ''', @superbillUids=''' + @superbillUids + '''' + '" />' +
				'</audit>', 
			'Unknown', null, GETUTCDATE(), 
			@chgDesc, 
			GETUTCDATE() )	
	-- End audit batch changes

	SELECT L.LedgerUid, SBP.SuperbillUid, SB.ExternalID, SBP.SuperbillProcedureUid,  LP.Code AS ProcedureCode, 
			CASE WHEN ARB.IsClosed = 1 OR ARB.IsLocked = 1 THEN 2 ELSE 1 END AS BatchStatus, -- 1 if open, 2 if closed or locked
			CASE WHEN ARB.IsClosed = 0 AND ARB.IsLocked = 0 THEN @arBatchUidTarget ELSE NULL END AS NewBatchUid
		INTO #tempLedgersAffected
		FROM AR_Ledger L
			INNER JOIN AR_LedgerDetail LD ON L.LedgerUid = LD.LedgerUid
			INNER JOIN ARBatch ARB ON L.ArBatchUid = ARB.ARBatchUid
			INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			INNER JOIN ListProcedure LP ON SBP.ProcedureUid = LP.ProcedureUid
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
			INNER JOIN #tempSuperbillsSelected TSS ON SBP.SuperbillUid = TSS.SuperbillUid
		WHERE (L.EntryType = 1) -- Charge
			OR (L.EntryType = 4 AND  -- Added For Bug 32123
				(SELECT COUNT(*) FROM AR_RelLedgerTag LT WHERE LT.Value = 'ChargeTransfer' AND LT.LedgerUid = L.LedgerUid)>0) 

	UPDATE AR_Ledger 
		SET AR_Ledger.ARBatchUid = #tempLedgersAffected.NewBatchUid
		FROM AR_Ledger 
			INNER JOIN #tempLedgersAffected ON AR_Ledger.LedgerUid = #tempLedgersAffected.LedgerUid
		WHERE NOT #tempLedgersAffected.NewBatchUid IS NULL

	SELECT 'NameValuePair' -- blocking failure
	SELECT CAST(SuperbillProcedureUid AS VARCHAR(50)),  ExternalID + ';' 
				+ CASE WHEN SumBatchStatus > 2 THEN 'Changed Partial'
						WHEN SumBatchStatus = 2 THEN 'Changed None'
						ELSE 'Changed All' END + ';' 
				+ ProcedureCode
			FROM (SELECT SuperbillProcedureUid, ProcedureCode, ExternalID, SUM(BatchStatus) AS SumBatchStatus
					FROM (SELECT DISTINCT SuperbillProcedureUid, ProcedureCode, ExternalID, BatchStatus
								FROM #tempLedgersAffected TLA) TLAD
						 GROUP BY SuperbillProcedureUid, ProcedureCode, ExternalID) TLADA
			ORDER BY ExternalID, ProcedureCode

	DROP TABLE #tempLedgersAffected;
	DROP TABLE #tempSuperbillsSelected;

END


/*
	AR_ChangeBatch_Superbills
	BMR 2013-02-28 - Changed Value Returned for Sucess
		
*/

-- EXEC AR_ChangeBatch_Superbills @arBatchUidTarget = 'a0cb3706-2124-42fb-9820-464419b80337', @superbillUids = 'a846ebe4-c1f6-4f88-bf14-00f360419b86'







GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_Cleanup_MoveEqualAndOppositeSBPLiabilities]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_Cleanup_MoveEqualAndOppositeSBPLiabilities] AS' 
END
GO



/*
We have cases where we have equal but opposite sign balances between insurance and patient
This script attemps to transfer liability for this amount over to the correct liability owner
Afterwards, for those 'fixed', sets Superbill Status to Completed where no remaining balance
Associated Podiatry initial target ... may need at other sites
BROY 20110817
*/


ALTER PROC [dbo].[AR_Cleanup_MoveEqualAndOppositeSBPLiabilities]
AS
BEGIN

DECLARE @BUID UNIQUEIDENTIFIER
DECLARE @BPrefix VARCHAR(50)
DECLARE @OwnerUid UNIQUEIDENTIFIER
DECLARE @superbillProcedureUid UNIQUEIDENTIFIER
DECLARE @liabilityBalance MONEY
DECLARE @assignedLiabilityBalance MONEY
DECLARE @ledgerDetailUidOverCharge UNIQUEIDENTIFIER
DECLARE @ledgerUidNew UNIQUEIDENTIFIER
DECLARE @sourceLedgerQuantity INT

GOTO PARTTWO

SELECT @BUID = ArBatchUid FROM ARBatch WHERE CAST(Notes AS VARCHAR(MAX)) = 'Balance Equal And Opposite SBP Liabilities'
IF (@BUID IS NULL)
BEGIN
	SET @BUID = NEWID()

	INSERT INTO ARBatch(ARBatchUid, Name, Notes, 
		  LastModifiedDate, GLDate, IsLocked, OwnerUID)
	  VALUES (@BUID,'Balance Equal And Opposite SBP Liabilities ' + CAST(GetDate() As VarChar(25)),'Balance Equal And Opposite SBP Liabilities',
		   GETUTCDATE(),DATEADD(hh,12,CAST(GETDATE() AS DATE)),0,@OwnerUid)
END
      
SELECT * FROM ARBatch WHERE ARBatchUid = @BUID

SELECT VSBPA.*
     FROM AR_ViewSuperbillProcedureAggregate VSBPA
          INNER JOIN SuperbillProcedure SBP ON VSBPA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
     WHERE VSBPA.LiabilityBalance = 0 and VSBPA.AssignedLiabilityBalance <> 0
          --AND VSBPA.SuperbillProcedureUid = 'B6D34B64-EB40-4D05-B3DE-0197CDD4F5F1'

SELECT SB.SuperbillUid, VSBA.LiabilityBalance,
          VSBA.AssignedLiabilityBalance
     INTO #targetSuperbillsExclueOthers
     FROM AR_ViewSuperbillAggregate VSBA
          INNER JOIN Superbill SB ON VSBA.SuperbillUid = SB.SuperbillUid
     WHERE VSBA.LiabilityBalance = 0 and VSBA.AssignedLiabilityBalance = 0 -- both patient and insurance are zero total on the superbill

SELECT SBP.SuperbillProcedureUid, VSBPA.LiabilityBalance,
          VSBPA.AssignedLiabilityBalance, SBP.SuperbillUid
     INTO #targetSuperbillProcedures
     FROM AR_ViewSuperbillProcedureAggregate VSBPA
          INNER JOIN SuperbillProcedure SBP ON VSBPA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
          INNER JOIN #targetSuperbillsExclueOthers TSB ON SBP.SuperbillUid = TSB.SuperbillUid -- limit to Superbills with both patient and insurance = 0
     WHERE VSBPA.LiabilityBalance = 0 and VSBPA.AssignedLiabilityBalance <> 0 
		--AND VSBPA.SuperbillProcedureUid = 'B6D34B64-EB40-4D05-B3DE-0197CDD4F5F1'
		
SELECT DISTINCT SuperbillUid
	INTO #targetSuperbills
	FROM #targetSuperbillProcedures

DECLARE @targetLiabilityOwner INT

WHILE EXISTS(SELECT SuperbillProcedureUid FROM #targetSuperbillProcedures)
BEGIN  
     SELECT TOP 1 @superbillProcedureUid = SuperbillProcedureUid, @liabilityBalance = LiabilityBalance,
              @assignedLiabilityBalance = AssignedLiabilityBalance
          FROM #targetSuperbillProcedures  
     SELECT TOP 1 @targetLiabilityOwner = LiabilityOwner 
		FROM (SELECT SBP.SuperbillUid, SBP.SuperbillProcedureUid, LD.LiabilityOwner, SUM(LD.Amount) AS Balance, COUNT_BIG(*) AS Count   
					FROM dbo.SuperbillProcedure SBP    
						INNER JOIN dbo.AR_LedgerDetail LD ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid
					GROUP BY SBP.SuperbillUid, SBP.SuperbillProcedureUid, LD.LiabilityOwner )  VSCLOACS
		WHERE VSCLOACS.SuperbillProcedureUid = @superbillProcedureUid AND VSCLOACS.LiabilityOwner > 0 AND VSCLOACS.Balance<>0 -- Update to insure correct LO
     SELECT TOP 1 @ledgerDetailUidOverCharge = LD.LedgerDetailUid, @sourceLedgerQuantity = L.Quantity
          FROM AR_LedgerDetail LD
              INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
          WHERE LD.LiabilityOwner > 0 AND LD.SuperbillProcedureUid = @superbillProcedureUid
              AND LD.IsCredit = 0 AND L.EntryType IN (1,4) AND LD.LiabilityOwner = @targetLiabilityOwner
          ORDER BY LD.LastModifiedDate DESC
       --SELECT '@ledgerDetailUidOverCharge', @ledgerDetailUidOverCharge
  --   SELECT LDOutside.* FROM AR_LedgerDetail LD
		--INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
		--INNER JOIN AR_LedgerDetail LDOutside ON L.LedgerUid = LDOutside.LedgerUid
		--WHERE LD.LedgerDetailUid = @ledgerDetailUidOverCharge ORDER BY IsCredit
     IF (@superbillProcedureUid=NULL OR @ledgerDetailUidOverCharge=NULL)
          CONTINUE
     SELECT @ledgerUidNew = NEWID()
     --SELECT '@ledgerUidNew', @ledgerUidNew
     INSERT INTO AR_Ledger(LedgerUid, EntryDate, ArBatchUid, ShortName, EntryType, Quantity, CreatedDateTime, LastModifiedDate)
          SELECT  @ledgerUidNew, CAST(GETDATE() AS DATE), @BUID, 'Balance Entry',
              4, @sourceLedgerQuantity, GETUTCDATE(), GETUTCDATE()
     -- DEBIT
     INSERT INTO AR_LedgerDetail(LedgerDetailUid, LedgerUid, Amount, LiabilityOwner, LedgerAccountUid, IncomeAccountUid,
              AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, InsurancePlanUid,
              RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, IsCredit, CreatedDateTIME, LastModifiedDate)
          SELECT  NEWID(), @ledgerUidNew, @assignedLiabilityBalance, 0,  LedgerAccountUid, IncomeAccountUid,
                   AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, NULL,
                   RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, 0, GETUTCDATE(), GETUTCDATE()
              FROM AR_LedgerDetail WHERE LedgerDetailUid = @ledgerDetailUidOverCharge
     -- CREDIT
     INSERT INTO AR_LedgerDetail(LedgerDetailUid, LedgerUid, Amount, LiabilityOwner, LedgerAccountUid, IncomeAccountUid,
              AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, InsurancePlanUid,
              RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, IsCredit, CreatedDateTime, LastModifiedDate)
          SELECT  NEWID(), @ledgerUidNew, 0-@assignedLiabilityBalance, LiabilityOwner,  LedgerAccountUid, IncomeAccountUid,
                   AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, InsurancePlanUid,
                   RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, 1, GETUTCDATE(), GETUTCDATE()
              FROM AR_LedgerDetail WHERE LedgerDetailUid = @ledgerDetailUidOverCharge
     DELETE FROM #targetSuperbillProcedures
          WHERE SuperbillProcedureUid = @superbillProcedureUid 
     SELECT @superbillProcedureUid = NULL, @ledgerDetailUidOverCharge = NULL  
     --SELECT * FROM AR_LedgerDetail WHERE LedgerUid = @ledgerUidNew ORDER BY IsCredit
END

SELECT VSBPA.*
     FROM AR_ViewSuperbillProcedureAggregate VSBPA
          INNER JOIN SuperbillProcedure SBP ON VSBPA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
     WHERE VSBPA.LiabilityBalance = 0 and VSBPA.AssignedLiabilityBalance <> 0
		--AND VSBPA.SuperbillProcedureUid = 'B6D34B64-EB40-4D05-B3DE-0197CDD4F5F1'

SELECT SB.ExternalID, VSA.*
     FROM AR_ViewSuperbillAggregate VSA
          inner join Superbill SB on VSA.SuperbillUid = SB.SuperbillUid
     WHERE VSA.LiabilityBalance = 0 and VSA.AssignedLiabilityBalance <> 0
     ORDER BY SB.ExternalID

IF NOT (EXISTS(SELECT ARBatchUid FROM AR_Ledger WHERE ArBatchUid = @BUID))
      DELETE FROM ArBatch WHERE ArBatchUid = @BUID
      
      SELECT * FROM ARBatch WHERE ARBatchUid = @BUID
      
UPDATE Superbill -- set fixed that went to $0 as complete
	SET SuperbillStatusUid = '30F64D66-55CB-4438-BB2F-7A6250399312' -- completed
	WHERE SuperbillUid IN
	(
		SELECT VSA.SuperbillUid 
			FROM AR_ViewSuperbillAggregate VSA
				INNER JOIN #targetSuperbills TS ON VSA.SuperbillUid = TS.SuperbillUid
			WHERE VSA.LiabilityBalance = 0 AND VSA.AssignedLiabilityBalance = 0
	)
  
DROP TABLE #targetSuperbills    
DROP TABLE #targetSuperbillProcedures

PARTTWO:

/*
	PART II - In 2009, Insurance Plan is determined via the superbill account and thus no historical is kept
	In 2011, the Ledger detail keeps this historical info ...
	Seems there is a problem in the migration and in the pre Patch4 code that tranfers and applies Insurance Plan
	liability incorrectly ... 
	This update, syncs the liability values to the CURRENT (non historical) data which is no worse than as pre-migration
	Patch4 fixes will also fix this in 'new' transfers 
*/

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_AR_LedgerDetail_LiabilityOwner_ForLRQ')
DROP INDEX [IX_AR_LedgerDetail_LiabilityOwner_ForLRQ] ON [dbo].[AR_LedgerDetail] WITH ( ONLINE = OFF )

CREATE NONCLUSTERED INDEX [IX_AR_LedgerDetail_LiabilityOwner_ForLRQ] ON [dbo].[AR_LedgerDetail] 
(
	[LiabilityOwner] ASC
)
INCLUDE ( [SuperbillProcedureUid],
[InsurancePlanUid]) 

UPDATE LD
	SET LD.InsurancePlanUid = PIP.InsurancePlanUid
	FROM AR_LedgerDetail LD 
		INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
		INNER JOIN SuperbillAggregate SBA ON SB.SuperbillUid = SBA.SuperbillUid
			INNER JOIN AccountInsurance AI ON SBA.AccountPeriodUid = AI.AccountPeriodUid AND AI.DisplayOrder = LD.LiabilityOwner
			INNER JOIN PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
	WHERE LD.InsurancePlanUid <> PIP.InsurancePlanUid

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_AR_LedgerDetail_LiabilityOwner_ForLRQ')
DROP INDEX [IX_AR_LedgerDetail_LiabilityOwner_ForLRQ] ON [dbo].[AR_LedgerDetail] WITH ( ONLINE = OFF )

END

/*
BEGIN TRANSACTION
EXEC dbo.AR_Cleanup_MoveEqualAndOppositeSBPLiabilities
ROLLBACK TRANSACTION
-- C0F97F46-8BD9-456A-A446-18E776D695B3
*/


/*
BEGIN TRANSACTION
DELETE
	FROM AR_Ledger 
	WHERE ShortName = 'Balance Entry'
		AND ARBatchUid IN (SELECT ARBatchUid FROM ARBatch WHERE CAST(Notes AS VARCHAR(MAX)) = 'Balance Equal And Opposite SBP Liabilities')
ROLLBACK TRANSACTION
*/






GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_finalizeEReportImport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_finalizeEReportImport] AS' 
END
GO

ALTER PROC [dbo].[AR_EC_finalizeEReportImport]
AS
UPDATE eReportRows SET
	superbillUid = eReportRows.patientAccountNumber,
	providerUid = ViewSuperbillPayer.ClaimingProviderUid,
	patientUid = account.personUID,
	insuredUid = COALESCE(ViewSuperbillPayer.InsuredPersonUid, ViewSuperbillPayer.InsuredCorporationUid),
	InsuranceCarrierUid = ViewSuperbillPayer.InsuranceCarrierUid,
	LastModifiedDate = GetUTCDate()
FROM eReportDetails
INNER JOIN eReportRows ON
	eReportRows.eReportDetailUid = eReportDetails.eReportDetailUid
INNER JOIN ViewSuperbillPayer ON
	ViewSuperbillPayer.superbillUid = eReportRows.patientAccountNumber AND
	ViewSuperbillPayer.InsuranceOrder = 1 

LEFT JOIN account ON
	account.accountUID = ViewSuperbillPayer.AccountUid 

WHERE
	eReportDetails.status = 'IMPORTING'

UPDATE eReportDetails 
	SET status = 'NEW' ,
	LastModifiedDate = GetUTCDate()
WHERE status = 'IMPORTING'


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_insertEReportDetail]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_insertEReportDetail] AS' 
END
GO

ALTER PROC [dbo].[AR_EC_insertEReportDetail]
	--@siteID int,
	@reportNumber varchar(50),
	@eReportDetailGUID uniqueidentifier = null output,
	@SBBatchRowGUID uniqueidentifier = null,
	@messageprocessDate datetime = null,
	@status varchar(50) = null,
	@totalCharge money = null,
	@totalClaims int = null,
	@acceptedCharges money = null,
	@acceptedClaims int = null
AS
SET @eReportDetailGUID = NEWID()

INSERT INTO eReportDetails
(eReportDetailUid, importDate, messageprocessDate, status, reportNumber, totalCharge, totalClaims, acceptedCharges, acceptedClaims,
	--siteID,
	ClaimBatchUid)
VALUES
(
	@eReportDetailGUID,
	GETUTCDATE(),
	ISNULL(@messageprocessDate,GETUTCDATE()),
	ISNULL(@status,'NEW'),
	@reportNumber,
	@totalCharge,
	@totalClaims,
	@acceptedCharges,
	@acceptedClaims,
	--@siteID,
	@SBBatchRowGUID)


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_insertEReportRow]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_insertEReportRow] AS' 
END
GO

ALTER PROC [dbo].[AR_EC_insertEReportRow]
	@eClaimBatchGUID uniqueidentifier,
	@type varchar(50),
	@messageDescription varchar(255),
	@additionalInformation varchar(255),
	@providerID varchar(50),
	@insuredID uniqueidentifier,
	@patientID uniqueidentifier,
	@superbillID uniqueidentifier,
	@payerID varchar(25),
	@ElectronicPayerUid uniqueidentifier
--	@siteID int
AS
INSERT INTO eReportRows
(	eReportDetailUid, superbillUid, providerUid, InsuranceCarrierUid, patientUid,  insuredUid,errorDescription, additionalClaimInformation,
	errorFlag,ClaimPayerId, eReportRowUid, epayerUid)	--	,new_eReportRowUid) --SiteID, --JW 11/03/05 Changed last column from ElectronicPayerUid to epayerUid as this matches our current schema.
VALUES
(	@eClaimBatchGUID, @superbillID,@providerID,NULL, @patientID,@insuredID, --@siteID, 
 	@messageDescription,@additionalInformation, 'E', @payerID, NEWID(), @ElectronicPayerUid )	--, NEWID())


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_markSBBatchFinished]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_markSBBatchFinished] AS' 
END
GO

ALTER  PROCEDURE [dbo].[AR_EC_markSBBatchFinished]
	@eClaimBatchGUID uniqueidentifier,
	@Status varchar(50),
	@LastModifiedByUid uniqueidentifier
AS
SET NOCOUNT ON
--	declare @submissionNumber INT
--	select @submissionNumber = Value from PluginSettings where Name like 'SubmissionNumber'
	UPDATE ClaimBatch 
		SET Status = @Status,
		LastModifiedByUid = @LastModifiedByUid,
		LastModifiedDate = GetUTCDAte()--,
--		SubmissionNumber = @submissionNumber
	WHERE ClaimBatchUid  = @eClaimBatchGUID

	
SET NOCOUNT OFF

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_updateSBBatchDetailStatus]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_updateSBBatchDetailStatus] AS' 
END
GO

ALTER PROC [dbo].[AR_EC_updateSBBatchDetailStatus]
	@eClaimBatchGUID uniqueidentifier,
	@superbillID uniqueidentifier,
	@Status varchar(50)
AS
SET NOCOUNT ON

	UPDATE ClaimBatchDetail
	SET status = @Status,
	LastModifiedDate = GetUTCDate()
	WHERE
		ClaimBatchDetail.SuperBillUid = @superbillID AND
		ClaimBatchUid = @eClaimBatchGUID

SET NOCOUNT OFF

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genSecondary_InfoCHC]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genSecondary_InfoCHC] AS' 
END
GO

ALTER PROCEDURE [dbo].[AR_genSecondary_InfoCHC] 
      @SuperBillUid uniqueidentifier,
      @DisplayOrder varchar(1) 
      
AS
BEGIN
	  -- CHC
	  --   NOTE:  Need the current insurance payer to determine if sending asCHC
	DECLARE @billingType int
	select @billingType = cap.BillingType
	FROM #XMLClaims_Sec_temp 
			INNER JOIN Superbill sb with (nolock) on #XMLClaims_Sec_temp.[OTHERPAYER!1!SuperBillID] = sb.SuperbillUid
			inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid= sba.SuperbillUid
			INNER JOIN ChcInsurancePlan cip with (nolock) on sba.CurrentInsurancePlanUid = cip.InsurancePlanUid
			INNER JOIN ChcListApprovalSetting cas with (nolock) on cip.ApprovalSettingUid = cas.ApprovalSettingUid
			INNER JOIN ChcApprovalPeriod cap with (nolock) on cas.ApprovalSettingUid = cap.ApprovalSettingUid
																AND (cap.EffectiveDate IS NULL OR sb.ServiceDateStart >= cap.EffectiveDate )
																AND (cap.ExpirationDate	IS NULL OR sb.ServiceDateStart <= cap.ExpirationDate )
	WHERE #XMLClaims_Sec_temp.tag = 1 -- OtherPayer
			AND #XMLClaims_Sec_temp.[OTHERPAYER!1!SuperBillID] = @SuperBillUid

	if ( @billingType IS NULL )			-- CHC?
		return ;
	if ( @billingType NOT IN ( 0, 3 ) ) -- FQHC or RHC
		return ;

	-- Creae a working table for all superbill procedures with FQHC revenue codes
	CREATE TABLE #fqhc_temp
	(
			[CLAIM!400!PID] UNIQUEIDENTIFIER,
			SuperbillProcedureUid UNIQUEIDENTIFIER,
			ProcedureUid UNIQUEIDENTIFIER,
			RevenueCode VARCHAR(10),
			RevenueCodeOrder int
	)

	-- Insert into working fqhc table ( Only those with billing type of 0 which is fqhc )
	--  Revenue code procedures based on:
	--     Superbill, SuperbillProcedureUid, RevenueCode
	--     (Include a revenueCodeOrder to allow grouping later )
	INSERT INTO #fqhc_temp( [CLAIM!400!PID], SuperbillProcedureUid, ProcedureUid, RevenueCode, RevenueCodeOrder)
		SELECT @SuperBillUid AS [CLAIM!400!PID],
			   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
			   sbp.ProcedureUid AS ProcedureUid,
			   lp.RevenueCode AS RevenueCode,
			   ROW_NUMBER() OVER( PARTITION BY lp.RevenueCode ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder
		FROM SuperbillProcedure sbp WITH (NOLOCK) 
				INNER JOIN ListProcedure lp WITH (NOLOCK) ON sbp.ProcedureUid = lp.ProcedureUid
		WHERE sbp.SuperbillUid = @SuperbillUid AND (ISNULL(sbp.DontClaim,0) = 0)
		ORDER BY sbp.DisplayOrder

	-- Update procedure revenue codes with RHC ( 3 ) revenue codes (Mapping Table for RHC)
	IF ( @billingType in ( 3 ) ) -- RHC
	BEGIN
		UPDATE #fqhc_temp
			SET #fqhc_temp.RevenueCode = mi.SubstitutionText
			FROM #fqhc_temp
					INNER JOIN MapItem mi WITH (NOLOCK) ON mi.MapSourceUid = '649D2F6A-D215-41F3-963F-E912AACAF335' -- RHC 
															AND #fqhc_temp.ProcedureUid = mi.FindTableFromItemUid
	END

	--For FQHC/RHC billing type, only want Procs with RevenueCodes
	-- Remove those without revenue codes
	-- PROCCOB
	DELETE #XMLClaims_Sec_temp 
	FROM #XMLClaims_Sec_temp
			LEFT OUTER JOIN #fqhc_temp ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = #fqhc_temp.SuperbillProcedureUid
	WHERE	#XMLClaims_Sec_temp.tag = 2  
			AND (IsNull(#fqhc_temp.RevenueCode,'0') = '0')
	-- PROCADJ
	DELETE #XMLClaims_Sec_temp 
	FROM #XMLClaims_Sec_temp
			LEFT OUTER JOIN #fqhc_temp ON #XMLClaims_Sec_temp.[PROCADJ!4!ProcID] = #fqhc_temp.SuperbillProcedureUid
	WHERE	#XMLClaims_Sec_temp.tag = 4
			AND (IsNull(#fqhc_temp.RevenueCode,'0') = '0')
	-- PROCCOBERA
	DELETE #XMLClaims_Sec_temp 
	FROM #XMLClaims_Sec_temp
			LEFT OUTER JOIN #fqhc_temp ON #XMLClaims_Sec_temp.[PROCCOBERA!5!ProcID] = #fqhc_temp.SuperbillProcedureUid
	WHERE	#XMLClaims_Sec_temp.tag = 5
			AND (IsNull(#fqhc_temp.RevenueCode,'0') = '0')

	---------------------------------------------------------------------------------------------------------------------
	-- PROCCOB - Payments
	-- "MOVE" all payments to the "rolled up" code, Need only one payment ( SVD ) so roll up to one payment
	;with myCTE AS
	(	-- 1.  Need to sum up "revenue code" procedures based on #fqhc_temp
		select f2.SuperbillProcedureUid, #XMLClaims_Sec_temp.[PROCCOB!2!LiabilityOwner], 
		SUM(CAST(#XMLClaims_Sec_temp.[PROCCOB!2!AmountPaid] AS FLOAT)) AS TotalAmountPaid
		from #XMLClaims_Sec_temp
			INNER JOIN #fqhc_temp f1 ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = f1.SuperbillProcedureUid   -- Matches on sbp in #fqhc_temp
			INNER JOIN #fqhc_temp f2 ON f1.RevenueCode = f2.RevenueCode AND f2.RevenueCodeOrder = 1			-- matches f1 sbp with it's "roll up" sbp where revenue code order is 1
		where #XMLClaims_Sec_temp.tag = 2
		group by f2.SuperbillProcedureUid, #XMLClaims_Sec_temp.[PROCCOB!2!LiabilityOwner]
	) -- 2.  Now update the "first-order" Revenue Code Order with the new total
	UPDATE #XMLClaims_Sec_temp
	SET #XMLClaims_Sec_temp.[PROCCOB!2!AmountPaid] = mc.TotalAmountPaid
	FROM #XMLClaims_Sec_temp
			INNER JOIN myCTE mc ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = mc.SuperbillProcedureUid
									AND #XMLClaims_Sec_temp.[PROCCOB!2!LiabilityOwner] = mc.[PROCCOB!2!LiabilityOwner]
	where #XMLClaims_Sec_temp.tag = 2  -- PROCCOB

	-- 3. Delete the "second-order" Revenue payments ( Revenue code order is 2 through n )
	DELETE #XMLClaims_Sec_temp
	FROM #XMLClaims_Sec_temp
			INNER JOIN #fqhc_temp f3 ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = f3.SuperbillProcedureUid
											AND f3.RevenueCodeOrder != 1
	WHERE #XMLClaims_Sec_temp.tag = 2

	---------------------------------------------------------------------------------------------------------------------
	-- PROCADJ ( Remarks )
	UPDATE #XMLClaims_Sec_temp
	SET #XMLClaims_Sec_temp.[PROCADJ!4!ProcID] = f2.SuperbillProcedureUid
	FROM #XMLClaims_Sec_temp
			INNER JOIN #fqhc_temp f1 ON #XMLClaims_Sec_temp.[PROCADJ!4!ProcID] = f1.SuperbillProcedureUid
			INNER JOIN #fqhc_temp f2 ON f1.RevenueCode = f2.RevenueCode AND f2.RevenueCodeOrder = 1
	WHERE #XMLClaims_Sec_temp.tag = 4
			AND f1.RevenueCodeOrder != 1

	---------------------------------------------------------------------------------------------------------------------
	-- PROCCOBERA ( Adjustments )
	UPDATE #XMLClaims_Sec_temp
	SET #XMLClaims_Sec_temp.[PROCCOBERA!5!ProcID] = f2.SuperbillProcedureUid
	FROM #XMLClaims_Sec_temp
			INNER JOIN #fqhc_temp f1 ON #XMLClaims_Sec_temp.[PROCCOBERA!5!ProcID] = f1.SuperbillProcedureUid
			INNER JOIN #fqhc_temp f2 ON f1.RevenueCode = f2.RevenueCode AND f2.RevenueCodeOrder = 1
	WHERE #XMLClaims_Sec_temp.tag = 5
			AND f1.RevenueCodeOrder != 1

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genSecondary_Info]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genSecondary_Info] AS' 
END
GO

ALTER PROCEDURE [dbo].[AR_genSecondary_Info] 
      @SuperBillUid uniqueidentifier,
      @DisplayOrder varchar(1) 
      
AS
BEGIN

SET NOCOUNT ON;

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

CREATE TABLE #XMLClaims_Sec_temp (
				  tag INT,
				  parent INT,
				  [OTHERPAYER!1!LiabilityOwner] SMALLINT,				-- Insurance 
				  [OTHERPAYER!1!displayorder] SMALLINT,					-- Procedure Order
				  [OTHERPAYER!1!orgName] VARCHAR(80),
				  [OTHERPAYER!1!payerResponsibility] VARCHAR(1),
				  [OTHERPAYER!1!isWCC] SMALLINT ,
				  [OTHERPAYER!1!CopayPrimary] VARCHAR(19), --Decimal(19,2), /*MONEY*/
				  [OTHERPAYER!1!LN] VARCHAR(40),
				  [OTHERPAYER!1!FN] VARCHAR(40),
				  [OTHERPAYER!1!suffix] VARCHAR(40),
				  [OTHERPAYER!1!birthdate] VARCHAR(10),
				  [OTHERPAYER!1!gender] VARCHAR(1),
				  [OTHERPAYER!1!PlanmemberID] VARCHAR(40),
				  [OTHERPAYER!1!groupID] VARCHAR(40),
				  [OTHERPAYER!1!Relationship]  VARCHAR(2),
				  [OTHERPAYER!1!groupName] VARCHAR (100),
				  [OTHERPAYER!1!planType] VARCHAR (2),
				  [OTHERPAYER!1!IDType] VARCHAR (2),
				  [OTHERPAYER!1!ID] VARCHAR (10),
				  [OTHERPAYER!1!ReimbursementRate] VARCHAR(8) ,
				  [OTHERPAYER!1!HCPCSPayableAmount] VARCHAR(19),  /*MONEY*/
				  [OTHERPAYER!1!MOARemarkCode1] VARCHAR(8),
				  [OTHERPAYER!1!MOARemarkCode2] VARCHAR(8),
				  [OTHERPAYER!1!MOARemarkCode3] VARCHAR(8),
				  [OTHERPAYER!1!MOARemarkCode4] VARCHAR(8),
				  [OTHERPAYER!1!MOARemarkCode5] VARCHAR(8),
				  [OTHERPAYER!1!ESRDPaymentAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!NonpayableProfessionalComponentAmount] VARCHAR(19),  /*MONEY*/
				  [OTHERPAYER!1!AdjudicationDate] datetime,
				  [OTHERPAYER!1!ICN] VARCHAR(50),
				  [OTHERPAYER!1!PayerPaidAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!PatientPaidAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!InsuranceAdjustment] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!AllowedAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!DiscountAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!PerDayLimitAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!PatientResponsibleAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!address1] VARCHAR(55),
				  [OTHERPAYER!1!address2] VARCHAR(55),
				  [OTHERPAYER!1!city] VARCHAR(30),
				  [OTHERPAYER!1!zip] VARCHAR(15),
				  [OTHERPAYER!1!state] VARCHAR(2),
				  [OTHERPAYER!1!elecPayerID] VARCHAR(55),
				  [OTHERPAYER!1!SuperBillID] UNIQUEIDENTIFIER,
				  [OTHERPAYER!1!insuranceplanuid] UNIQUEIDENTIFIER,   
				  [PROCCOB!2!ProcID] UNIQUEIDENTIFIER,
				  [PROCCOB!2!proc] VARCHAR(48),
				  [PROCCOB!2!AmountPaid] VARCHAR(19), /*MONEY*/
				  [PROCCOB!2!PatPaid] VARCHAR(19), /*MONEY*/
				  [PROCCOB!2!AmountAllowed] VARCHAR(19), /*MONEY*/
				  [PROCCOB!2!NDC] VARCHAR(15),
				  [PROCCOB!2!procM1] VARCHAR(8),
				  [PROCCOB!2!procM2] VARCHAR(8),
				  [PROCCOB!2!procM3] VARCHAR(8),
				  [PROCCOB!2!procM4] VARCHAR(8),
				  [PROCCOB!2!units] VARCHAR(10),
				  [PROCCOB!2!DatePaid] datetime,
				  [PROCCOB!2!TaxPaid] VARCHAR(19), /*MONEY*/
				  [PROCCOB!2!lineControlNo] VARCHAR(50),
				  [PROCCOB!2!LiabilityOwner] SMALLINT,
				  [CLAIMADJ!3!LiabilityOwner] SMALLINT,
				  [CLAIMADJ!3!CroupCodeEraCode] VARCHAR(8),
				  [CLAIMADJ!3!ReasonCodeEraCode] VARCHAR(8),
				  [CLAIMADJ!3!AdjMoney] VARCHAR(19), /*MONEY*/
				  [CLAIMADJ!3!Quantity] SMALLINT,
				  [PROCADJ!4!ProcID] UNIQUEIDENTIFIER,
				  [PROCADJ!4!LiabilityOwner] SMALLINT,
				  [PROCADJ!4!proc] VARCHAR(48) ,
				  [PROCADJ!4!CroupCodeEraCode] VARCHAR(8),
				  [PROCADJ!4!ReasonCodeEraCode] VARCHAR(8),
				  [PROCADJ!4!AdjMoney] VARCHAR(19), /*MONEY*/
				  [PROCADJ!4!Quantity] SMALLINT,
				  [PROCADJ!4!insuranceplanuid] UNIQUEIDENTIFIER,
				  [PROCCOBERA!5!ProcID] UNIQUEIDENTIFIER,
				  [PROCCOBERA!5!LiabilityOwner] SMALLINT,
				  [PROCCOBERA!5!proc] VARCHAR(48),
				  [PROCCOBERA!5!CroupCodeEraCode] VARCHAR(8),
				  [PROCCOBERA!5!ReasonCodeEraCode] VARCHAR(8),
				  [PROCCOBERA!5!AdjMoney] VARCHAR(19), /*MONEY*/
				  [PROCCOBERA!5!Quantity] SMALLINT,
				  [PROCCOBERA!5!insuranceplanuid] UNIQUEIDENTIFIER,
				  -- 3048 start
				  [INSURANCEPLAN!6!InsurancePlanUid] UNIQUEIDENTIFIER,
				  [INSURANCEPLAN!6!address1] VARCHAR(100),
				  [INSURANCEPLAN!6!address2] VARCHAR(100),
				  [INSURANCEPLAN!6!city] VARCHAR(50),
				  [INSURANCEPLAN!6!state] VARCHAR(10),
				  [INSURANCEPLAN!6!zip] VARCHAR(20)
					-- 3048 end
)
    
INSERT INTO #XMLClaims_Sec_temp
     (
                  tag,
                  parent,  
                  [OTHERPAYER!1!displayorder] , 
                  [OTHERPAYER!1!LiabilityOwner],    
				  [OTHERPAYER!1!orgName], --Corporation.NAME
				  [OTHERPAYER!1!payerResponsibility], --accountinsurance.Displayorder
                  [OTHERPAYER!1!isWCC] ,
                  [OTHERPAYER!1!CopayPrimary], --personInsurancePlan.copayprimary
				  [OTHERPAYER!1!LN],
                  [OTHERPAYER!1!FN],
                  [OTHERPAYER!1!suffix],
                  [OTHERPAYER!1!birthdate],
                  [OTHERPAYER!1!gender],
                  [OTHERPAYER!1!PlanmemberID] ,
                  [OTHERPAYER!1!groupID],
                  [OTHERPAYER!1!Relationship],  
                  [OTHERPAYER!1!groupName],
                  [OTHERPAYER!1!planType],
                  [OTHERPAYER!1!IDType],
                  [OTHERPAYER!1!ID],
                  [OTHERPAYER!1!ReimbursementRate] ,
                  [OTHERPAYER!1!HCPCSPayableAmount] ,
                  [OTHERPAYER!1!MOARemarkCode1] ,
                  [OTHERPAYER!1!MOARemarkCode2] ,
                  [OTHERPAYER!1!MOARemarkCode3] ,
                  [OTHERPAYER!1!MOARemarkCode4] ,
                  [OTHERPAYER!1!MOARemarkCode5] ,
                  [OTHERPAYER!1!ESRDPaymentAmount] ,
                  [OTHERPAYER!1!NonpayableProfessionalComponentAmount] ,
                  [OTHERPAYER!1!AdjudicationDate] ,
                  [OTHERPAYER!1!ICN],
                  [OTHERPAYER!1!DiscountAmount] ,
                  [OTHERPAYER!1!PerDayLimitAmount],
                  [OTHERPAYER!1!PatientResponsibleAmount] ,
                  [OTHERPAYER!1!address1] ,
                  [OTHERPAYER!1!address2],
                  [OTHERPAYER!1!city] ,
                  [OTHERPAYER!1!zip] ,
                  [OTHERPAYER!1!state] ,
                  [OTHERPAYER!1!elecPayerID],
                  [OTHERPAYER!1!SuperBillID],
                  [OTHERPAYER!1!insuranceplanuid]

            )

SELECT            
                  1 as tag,
                  NULL AS parent,  
                  AccountInsurance.DisplayOrder AS   [OTHERPAYER!1!LiabilityOwner] ,
                  AccountInsurance.DisplayOrder AS [OTHERPAYER!1!displayorder],
                  CONVERT(VARCHAR(80),Corporation.NAME) AS [OTHERPAYER!1!orgName], --Corporation.NAME
                   (CASE WHEN AccountInsurance.DisplayOrder = 1 THEN 'P'  
                         WHEN AccountInsurance.DisplayOrder = 2 THEN 'S'  
                         WHEN AccountInsurance.DisplayOrder = 3 THEN 'T' 
                         WHEN AccountInsurance.DisplayOrder = 4 THEN 'A'  
                         WHEN AccountInsurance.DisplayOrder = 5 THEN 'B'  
                         WHEN AccountInsurance.DisplayOrder = 6 THEN 'C'  
                         WHEN AccountInsurance.DisplayOrder = 7 THEN 'D'  
                         WHEN AccountInsurance.DisplayOrder = 8 THEN 'E'  
                         WHEN AccountInsurance.DisplayOrder = 9 THEN 'F'  
                         WHEN AccountInsurance.DisplayOrder = 10 THEN 'G'  
                         WHEN AccountInsurance.DisplayOrder = 22 THEN 'H'  
                        ELSE ''  
                        END)       AS [OTHERPAYER!1!payerResponsibility],
                    CASE WHEN PersonInsurancePlan.PersonUid IS NOT NULL THEN 0  
                    WHEN PersonInsurancePlan.CorporationUid IS NOT NULL THEN 1 END AS [OTHERPAYER!1!isWCC],
                  CONVERT( VARCHAR(19), CAST(personInsurancePlan.copayprimary AS float)) AS [OTHERPAYER!1!CopayPrimary], --personInsurancePlan.copayprimary
                  CONVERT( VARCHAR(40), person.lastname) AS [OTHERPAYER!1!LN],
CONVERT( VARCHAR(40), person.firstname) AS [OTHERPAYER!1!FN],
                  CONVERT( VARCHAR(40), person.suffix) AS [OTHERPAYER!1!suffix],
				  CONVERT( VARCHAR(10), Person.BirthDate,101) AS [OTHERPAYER!1!birthdate],
                  CONVERT( VARCHAR(1),  ListGender.ANSICode) As [OTHERPAYER!1!gender],
                  CONVERT( VARCHAR(40), PersonInsurancePlan.PlanMemberID) AS [OTHERPAYER!1!PlanmemberID],
                  CONVERT( VARCHAR(40), PersonInsurancePlan.PlanGroupID) AS [OTHERPAYER!1!groupID],
				  CONVERT( VARCHAR(2),  ListRelationship.ANSICode) AS [OTHERPAYER!1!Relationship],   
                  CONVERT( VARCHAR(100), Insuranceplan.Name) AS [OTHERPAYER!1!groupName],
                  CONVERT( VARCHAR(2),  COALESCE (ListAccountType.ANSICode, '')) AS [OTHERPAYER!1!planType],
                  'PI'                                AS [OTHERPAYER!1!IDType],
                  CONVERT(VARCHAR(10), ListElectronicPayer.ClearingHousePayerID)              AS [OTHERPAYER!1!ID],
                  COBClaimDetail.ReimbursementRate    AS [OTHERPAYER!1!ReimbursementRate] ,
                  --REPLACE(COBClaimDetail.HCPCSPayableAmount, '.00', '')    
				  CONVERT(VARCHAR(19), CAST(COBClaimDetail.HCPCSPayableAmount AS FLOAT)) AS [OTHERPAYER!1!HCPCSPayableAmount] ,
                  CONVERT( VARCHAR(8), lecRemark1.Code )   AS [OTHERPAYER!1!MOARemarkCode1] ,
                  CONVERT( VARCHAR(8), lecRemark2.Code )  AS [OTHERPAYER!1!MOARemarkCode2] ,
				  CONVERT( VARCHAR(8), lecRemark3.Code ) AS [OTHERPAYER!1!MOARemarkCode3] ,
				  CONVERT( VARCHAR(8), lecRemark4.Code ) AS [OTHERPAYER!1!MOARemarkCode4] ,
                  CONVERT( VARCHAR(8), lecRemark5.Code )   AS [OTHERPAYER!1!MOARemarkCode5] ,
                  CONVERT( VARCHAR(19), CAST(COBClaimDetail.ESRDPaymentAmount AS FLOAT))    AS [OTHERPAYER!1!ESRDPaymentAmount] ,
				  CONVERT( VARCHAR(19), CAST(COBClaimDetail.NonpayableProfessionalComponentAmount AS FLOAT))   AS [OTHERPAYER!1!NonpayableProfessionalComponentAmount] ,
                  COBClaimDetail.AdjudicationDate    AS [OTHERPAYER!1!AdjudicationDate],
                  CONVERT( VARCHAR(30), COBClaimDetail.ICN) AS [OTHERPAYER!1!ICN],
                  CONVERT(VARCHAR(19), CAST(COBClaimDetail.DiscountAmount AS FLOAT)) AS [OTHERPAYER!1!DiscountAmount],
                  CONVERT(VARCHAR(19), CAST(COBClaimDetail.PerDayLimitAmount AS FLOAT)) AS [OTHERPAYER!1!PerDayLimitAmount] ,
                  CONVERT(VARCHAR(19), CAST(COBClaimDetail.PatientResponsibleAmount AS FLOAT)) AS [OTHERPAYER!1!PatientResponsibleAmount] ,
                  Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!address1],
                  Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!address2],
                  Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!city] ,
                  Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!zip] ,
                  Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!state] ,
                  ISNULL(CAST(lep.PayerOrgID AS VARCHAR(50)),'')    AS [OTHERPAYER!1!elecPayerID],
                  @SuperBillUid AS [OTHERPAYER!1!SuperBillID],
                  InsurancePlan.InsurancecarrierUID AS [OTHERPAYER!1!insuranceplanuid]
      FROM         Superbill AS s 
                  INNER JOIN account ON  account.accountUid = s.accountUid  
                  INNER JOIN AccountResponsibleParty ON   Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
                  INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= s.serviceDateEnd)
                        OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= s.serviceDateEnd) 
                        OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= s.serviceDateEnd AND AccountPeriod.expirationDate >= s.serviceDateEnd) 
                        OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
                  INNER JOIN AccountInsurance  ON  AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  --AND AccountInsurance.DisplayOrder = 1--(AccountInsurance.DisplayOrder = 1 or AccountInsurance.DisplayOrder = 2 or AccountInsurance.DisplayOrder = 3)
                  INNER JOIN PersonInsurancePlan  ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
                  INNER JOIN InsurancePlan  ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
                  INNER JOIN InsuranceCarrier ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid 
                  LEFT JOIN Corporation ON Corporation.CorporationUid = InsuranceCarrier.CorporationUid
                  INNER JOIN Person  ON PersonInsurancePlan.PersonUid = Person.PersonUid  
                  INNER JOIN ListRelationShip  ON AccountInsurance.RelationShipUID = ListRelationShip.RelationShipUID  
                  LEFT JOIN ListAccountType ON ListAccountType.AccountTypeUid =-- InsuranceCarrier.AccountTypeUid     
                                          CASE WHEN InsurancePlan.UseInsuranceCarrierAccountType = 1 
                                               THEN InsuranceCarrier.AccountTypeUid           --Added by Aji 2006 03 22
                                               ELSE InsurancePlan.AccountTypeUid END    
                  LEFT JOIN listgender on listgender.genderuid = person.genderuid
                  LEFT JOIN ListElectronicPayer  ON ListElectronicPayer.ElectronicPayerUid = InsuranceCarrier.ElectronicPayerUid
                  LEFT JOIN COBClaimDetail on COBClaimDetail.superbilluid = s.superbilluid 
										AND (COBClaimDetail.InsuranceOrder <> @DisplayOrder AND COBClaimDetail.insuranceorder <> '0')
                                          and AccountInsurance.displayorder = COBClaimDetail.insuranceorder --COBClaimDetail.InsuranceOrder <> @DisplayOrder
                  LEFT JOIN ListERACode  lecRemark1 ON COBClaimDetail.MOARemarkCode1Uid = lecRemark1.ERACodeUID AND lecRemark1.TYPE = 'remark'
                  LEFT JOIN ListERACode  lecRemark2 ON COBClaimDetail.MOARemarkCode2Uid = lecRemark2.ERACodeUID AND lecRemark2.TYPE = 'remark'
                  LEFT JOIN ListERACode  lecRemark3 ON COBClaimDetail.MOARemarkCode3Uid = lecRemark3.ERACodeUID AND lecRemark3.TYPE = 'remark'
                  LEFT JOIN ListERACode  lecRemark4 ON COBClaimDetail.MOARemarkCode4Uid = lecRemark4.ERACodeUID AND lecRemark4.TYPE = 'remark'
                  LEFT JOIN ListERACode  lecRemark5 ON COBClaimDetail.MOARemarkCode5Uid = lecRemark5.ERACodeUID AND lecRemark5.TYPE = 'remark'
                  LEFT JOIN ListElectronicPayer lep ON lep.ElectronicPayerUid = InsuranceCarrier.ElectronicPayerUid

WHERE       s.superbilluid =  @SuperBillUid 
                  AND accountinsurance.Displayorder <> @DisplayOrder

-- OtherPayer ( Insurance )
--select * from #XMLClaims_Sec_temp
           
-- No need to send ( or calculate ) payments/adjustments if @DisplayOrder ( insurance we are NOT concerned with ) is primary
-- ASSUMING that when sending primary we don't have or don't need to send secondary( tertiary, ... ) info along
 
 -- NOTE:  REQUIRES EDI837Creator.dll built after 4/25/2013
if ( @DisplayOrder <> 1 )
BEGIN
	-- tag 2
	INSERT INTO #XMLClaims_Sec_temp
	(
	  tag,
	  parent,
	  [OTHERPAYER!1!LiabilityOwner],
	  [PROCCOB!2!ProcID],     
	  [PROCCOB!2!proc],
	  [PROCCOB!2!NDC],
	  [PROCCOB!2!procM1],
	  [PROCCOB!2!procM2],
	  [PROCCOB!2!procM3],
	  [PROCCOB!2!procM4],
	 [PROCCOB!2!units],
	  [PROCCOB!2!lineControlNo],
	  [PROCCOB!2!AmountPaid],
	  [PROCCOB!2!LiabilityOwner]	
	)
	SELECT   
	  2         AS tag,
	  1         AS parent,
	   COALESCE(AR_LedgerDetail.LiabilityOwner,1) AS [OTHERPAYER!1!LiabilityOwner],					  
			SuperbillProcedure.SuperbillProcedureUid          AS [PROCCOB!2!ProcID],
		ListProcedure.Code                        AS [PROCCOB!2!proc],
		ListProcedure.NDC AS [PROCCOB!2!NDC],
	  (CASE       WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1) = '' THEN
			NULL
			ELSE
			dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1)

	  END)        AS [PROCCOB!2!procM1],
	  (CASE       WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2) = '' THEN
			NULL
			ELSE
			dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2)
	  END)          AS [PROCCOB!2!procM2],
	  (CASE       WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3) = '' THEN
			NULL
			ELSE
			dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3)
	  END)                                AS [PROCCOB!2!procM3],
	  (CASE       WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4) = '' THEN
			NULL
			ELSE
			dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4)
	  END)                                AS [PROCCOB!2!procM4],
      
	  CONVERT(VARCHAR,SuperbillProcedure.Units) AS [PROCCOB!2!units],
	  Superbill.ExternalID +''+CONVERT(VARCHAR,SuperbillProcedure.DisplayOrder) AS  [PROCCOB!2!lineControlNo],
	  --	-sum(AR_LedgerDetail.amount) AS [PROCCOB!2!AmountPaid],
	  --CONVERT(VARCHAR(19), CAST(sum( CASE WHEN AR_Ledger.EntryType = 2 THEN -AR_LedgerDetail.amount ELSE 0 END ) AS FLOAT) ) AS [PROCCOB!2!AmountPaid],
	  [dbo].[UDF_TrimZeroes](sum( CASE WHEN AR_Ledger.EntryType = 2 THEN -AR_LedgerDetail.amount ELSE 0 END )) AS [PROCCOB!2!AmountPaid],
	  COALESCE(AR_LedgerDetail.LiabilityOwner,1) AS [PROCCOB!2!LiabilityOwner]
	FROM #XMLClaims_Sec_temp
		INNER JOIN SuperbillProcedure on SuperbillProcedure.superbillUid = @SuperBillUid AND (ISNULL(SuperbillProcedure.DontClaim,0) = 0)
		INNER JOIN ViewSuperbillProcedure_IsVoid on ViewSuperbillProcedure_IsVoid.SuperbillProcedureUid = SuperbillProcedure.SuperbillProcedureUid AND ViewSuperbillProcedure_IsVoid.IsVoid = '0' --added per bug 9450
		INNER JOIN ListProcedure ON ListProcedure.ProcedureUid = SuperbillProcedure.ProcedureUid
		--INNER JOIN ListProcedureCodeType ON ListProcedureCodeType.ProcedureCodeTypeUid = ListProcedure.ProcedureCodeTypeUid
												-- AND ListProcedureCodeType.Name IN ('CPT','HCPCS') 
		INNER JOIN Superbill on Superbill.superbillUid = SuperbillProcedure.superbillUid
		-- LEFT OUTER JOIN used just in case there is NOT a payment but there are adjustments, etc
		LEFT OUTER JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = SuperbillProcedure.superbillProcedureUID 
												AND AR_LedgerDetail.LiabilityOwner = #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner]
												AND AR_LedgerDetail.LiabilityOwner <> 0
		LEFT OUTER JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid and AR_Ledger.EntryType = 2	-- Distribution				
		LEFT OUTER JOIN listcredittype on listcredittype.credittypeuid = AR_LedgerDetail.IncomeAccountUid 
												AND ListCreditType.credittypeuid <> '914DD6FB-6EBB-43A5-A6FC-09FD156CCF26'
												AND ListCreditType.IsPayment = 1
	WHERE
		(#XMLClaims_Sec_temp.tag = 1 ) AND (SuperbillProcedure.superbilluid = @SuperBillUid)
	 GROUP BY Superbill.ExternalID, SuperbillProcedure.SuperbillProcedureUid,
				ListProcedure.Code, ListProcedure.NDC, 
				SuperbillProcedure.DisplayOrder, SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid,
				SuperbillProcedure.Units, 
				COALESCE(AR_LedgerDetail.LiabilityOwner,1)

	-- PROCCOB ( Superbill Procedures by Insurance )
	-- select * from #XMLClaims_Sec_temp
			            
	--**************************************************************************************************************************
	-- tag 3
	INSERT INTO #XMLClaims_Sec_temp
	(
					tag,
					parent,
					[OTHERPAYER!1!LiabilityOwner],
					[OTHERPAYER!1!DisplayOrder],					
					[CLAIMADJ!3!LiabilityOwner],
					[CLAIMADJ!3!CroupCodeEraCode],
					[CLAIMADJ!3!ReasonCodeEraCode] ,
					[CLAIMADJ!3!AdjMoney] ,
					[CLAIMADJ!3!Quantity] 
	)
	SELECT   
					3      AS Tag,
					1                                  AS parent, -- was 2
					COBClaimDetail.InsuranceOrder AS [OTHERPAYER!1!LiabilityOwner],
					0							  AS [OTHERPAYER!1!DisplayOrder],		-- Claim level adjustment not attached to specific procedure so set a 0
					COBClaimDetail.InsuranceOrder AS [CLAIMADJ!3!LiabilityOwner],
					lecGroup.Code  AS [CLAIMADJ!3!CroupCodeEraCode],
					lecReason.Code AS [CLAIMADJ!3!ReasonCodeEraCode] ,
					--CONVERT( VARCHAR(19), CAST( SUM(COBClaimAdjustments.Amount) AS FLOAT)) AS [CLAIMADJ!3!AdjMoney] ,
					[dbo].[UDF_TrimZeroes]( SUM(COBClaimAdjustments.Amount) ) AS [CLAIMADJ!3!AdjMoney] ,
					COBClaimAdjustments.Quantity AS [CLAIMADJ!3!Quantity] 

	FROM            #XMLClaims_Sec_temp
					RIGHT JOIN COBClaimDetail on COBClaimDetail.SuperBillUID = @SuperBillUid
					RIGHT JOIN COBClaimAdjustments on COBClaimAdjustments.COBClaimDetailUID = COBClaimDetail.COBClaimDetailUID
					RIGHT JOIN ListERACode  lecGroup ON  COBClaimAdjustments.GroupCodeERACodeUid = lecGroup.ERACodeUID AND lecGroup.TYPE = 'group'
					RIGHT JOIN ListERACode lecReason ON  COBClaimAdjustments.ReasonCodeERACodeUid = lecReason.ERACodeUID --AND lecReason.TYPE = 'status'
	WHERE
					#XMLClaims_Sec_temp.tag = 2 and COBClaimDetail.InsuranceOrder <> 0
					AND lecGroup.Code IS NOT NULL AND lecReason.Code IS NOT NULL
	GROUP BY COBClaimDetail.InsuranceOrder,
			 lecGroup.Code,
			 lecReason.Code,
			 COBClaimAdjustments.Quantity
	HAVING   SUM(COBClaimAdjustments.Amount) != 0

	-- CLAIMADJ ( CLAIM level procedure adjustments )
	-- select * from #XMLClaims_Sec_temp
	-- tag 4
	INSERT INTO #XMLClaims_Sec_temp
	(
							 tag,
							 parent,
							 [OTHERPAYER!1!LiabilityOwner],	-- Insurance payer
							 [OTHERPAYER!1!DisplayOrder],	-- procedure display order
							 [PROCADJ!4!ProcID] ,
							 [PROCADJ!4!LiabilityOwner],
							 [PROCADJ!4!proc] ,
							 [PROCADJ!4!CroupCodeEraCode],
							 [PROCADJ!4!ReasonCodeEraCode] ,
							 [PROCADJ!4!AdjMoney] ,
							 [PROCADJ!4!Quantity] ,
							 [PROCADJ!4!insuranceplanuid]
	)
	SELECT   
					4									AS Tag,
					1                                   AS parent, -- was 2
				    cobd.InsuranceOrder					AS [OTHERPAYER!1!LiabilityOwner],
					sbp.DisplayOrder					AS [OTHERPAYER!1!DisplayOrder],		-- procedure display order
					sbp.SuperbillProcedureUid			AS [PROCADJ!4!ProcID] ,
				    cobd.InsuranceOrder					AS [PROCADJ!4!LiabilityOwner] ,
					lp.Code								AS [PROCADJ!4!proc] ,
					grp.Code							AS [PROCADJ!4!CroupCodeEraCode],
					rsn.Code							AS [PROCADJ!4!ReasonCodeEraCode] ,
					--CONVERT(VARCHAR(19), CAST(SUM(-(cobl.Amount)) AS FLOAT))                 AS [PROCADJ!4!AdjMoney] ,
					[dbo].[UDF_TrimZeroes]( SUM(-(cobl.Amount)) ) AS [PROCADJ!4!AdjMoney] ,
					cobl.Quantity						AS [PROCADJ!4!Quantity] ,
					xClaimsIns.[OTHERPAYER!1!insuranceplanuid]                AS [PROCADJ!4!insuranceplanuid]    
	FROM #XMLClaims_Sec_temp 
			INNER JOIN SuperbillProcedure sbp ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = sbp.SuperbillProcedureUid -- was sbp.superbillUid = @SuperBillUid 
													AND ISNULL(sbp.DontClaim,0) = 0
			inner join ListProcedure lp on sbp.ProcedureUid = lp.ProcedureUid
			inner join COBLineAdjustments cobl on sbp.SuperbillProcedureUid = cobl.SuperbillProcedureUid -- All Remarks for this superbill/procedures
			inner join COBClaimDetail cobd on cobl.COBClaimDetailUid = cobd.COBClaimDetailUid
													AND #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner] = cobd.InsuranceOrder
			inner join Deposit d on cobl.DepositUid = d.DepositUid                -- Use deposit to determine liability owner
			INNER join ListERACode grp on cobl.GroupCodeERACodeUid = grp.ERACodeUid
			INNER join ListERACode rsn on cobl.ReasonCodeERACodeUid = rsn.ERACodeUid
			LEFT OUTER JOIN #XMLClaims_Sec_temp xClaimsIns ON xClaimsIns.tag = 1
																AND xClaimsIns.[OTHERPAYER!1!LiabilityOwner] = cobd.InsuranceOrder
	WHERE
		  (#XMLClaims_Sec_temp.tag = 2 and sbp.superbilluid = @SuperBillUid)
	GROUP BY cobd.InsuranceOrder,
			 sbp.DisplayOrder,
			 sbp.SuperbillProcedureUid,
			 lp.Code,
			 grp.Code,
			 rsn.Code,
			 cobl.Quantity,
			 xClaimsIns.[OTHERPAYER!1!insuranceplanuid]
	HAVING SUM(-(cobl.Amount)) != 0 

	-- PROCCOB ( Procedure remarks )

	--***********************************************************************************************
	-- tag 6

	INSERT INTO #XMLClaims_Sec_temp
		(
		   tag,
		   parent,
		   [OTHERPAYER!1!LiabilityOwner],
		   [OTHERPAYER!1!DisplayOrder],
		   [PROCCOB!2!ProcID],
		   [INSURANCEPLAN!6!address1],
			[INSURANCEPLAN!6!address2],
			[INSURANCEPLAN!6!city],
			[INSURANCEPLAN!6!state],
			[INSURANCEPLAN!6!zip],
			[INSURANCEPLAN!6!InsurancePlanUid]
		)
		SELECT   
			6 AS Tag,
			1 AS parent, 
			#XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner] AS [OTHERPAYER!1!LiabilityOwner],
			#XMLClaims_Sec_temp.[OTHERPAYER!1!DisplayOrder]   AS [OTHERPAYER!1!DisplayOrder],
			#XMLClaims_Sec_temp.[PROCCOB!2!ProcID]            AS [PROCCOB!2!ProcID],
			--InsurancePlan.InsurancePlanUid						  AS  [OTHERPAYER!1!insuranceplanuid],
			   InsurancePlan.Address.value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [INSURANCEPLAN!6!address1],
			   null AS [INSURANCEPLAN!6!address2],
			   InsurancePlan.Address.value('(/Address/City)[1]', 'VARCHAR(100)') AS [INSURANCEPLAN!6!city],
			   InsurancePlan.Address.value('(/Address/State)[1]', 'VARCHAR(100)') AS [INSURANCEPLAN!6!state],
			   InsurancePlan.Address.value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [INSURANCEPLAN!6!zip],
			   InsurancePlan.InsurancePlanUid AS [INSURANCEPLAN!6!InsurancePlanUid]

			FROM         #XMLClaims_Sec_temp 
						INNER JOIN Superbill s ON #XMLClaims_Sec_temp.[OTHERPAYER!1!SuperBillID] = s.SuperbillUid
						INNER JOIN account ON  account.accountUid = s.accountUid  
						INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= s.serviceDateEnd)
								OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= s.serviceDateEnd) 
								OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= s.serviceDateEnd AND AccountPeriod.expirationDate >= s.serviceDateEnd) 
								OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
						INNER JOIN AccountInsurance  ON  AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
															AND AccountInsurance.DisplayOrder <> @DisplayOrder
						INNER JOIN PersonInsurancePlan  ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
						INNER JOIN InsurancePlan  ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid 
		WHERE #XMLClaims_Sec_temp.tag = 1
				AND #XMLClaims_Sec_temp.[OTHERPAYER!1!SuperBillID] IS NOT NULL
	
	
	-- tag 5	
	INSERT INTO #XMLClaims_Sec_temp
	(
	  tag,
	  parent,
	  [OTHERPAYER!1!LiabilityOwner],		-- insurance payer
	  [OTHERPAYER!1!displayorder],			-- procedure display order
	  [PROCCOBERA!5!ProcID], 
	  [PROCCOBERA!5!LiabilityOwner], 
	  [PROCCOBERA!5!proc],
	  [PROCCOBERA!5!CroupCodeEraCode],
	  [PROCCOBERA!5!ReasonCodeEraCode],
	  [PROCCOBERA!5!AdjMoney],
	  [PROCCOBERA!5!insuranceplanuid]
	)
	SELECT   
	  5                                                       AS Tag,
	  1 AS parent, -- was 2
	  AR_LedgerDetail.LiabilityOwner AS [OTHERPAYER!1!LiabilityOwner],		-- insurance payer
	  SuperbillProcedure.DisplayOrder AS [OTHERPAYER!1!DisplayOrder],		-- procedure display order
	  SuperbillProcedure.SuperbillProcedureUid                AS [PROCCOBERA!5!ProcID],
	  AR_LedgerDetail.LiabilityOwner        AS [PROCCOBERA!5!LiabilityOwner] ,
	  ListProcedure.Code     AS [PROCCOBERA!5!proc],
	  lecGroup.Code    AS [PROCCOBERA!5!CroupCodeEraCode],
	  lecReason.Code                 AS [PROCCOBERA!5!ReasonCodeEraCode],
	  --CONVERT(VARCHAR(19), CAST(SUM(-AR_LedgerDetail.Amount) AS FLOAT))         AS [PROCCOBERA!5!AdjMoney],
	  dbo.UDF_TrimZeroes( SUM(-AR_LedgerDetail.Amount) ) AS [PROCCOBERA!5!AdjMoney],
	  --AR_LedgerDetail.InsurancePayerUid AS [PROCCOBERA!5!insuranceplanuid]--,  
	  #XMLClaims_Sec_temp.[OTHERPAYER!1!insuranceplanuid] AS [PROCCOBERA!5!insuranceplanuid]  
	FROM #XMLClaims_Sec_temp
			INNER JOIN SuperbillProcedure ON SuperbillProcedure.superbillUid = @SuperBillUid AND ISNULL(SuperbillProcedure.DontClaim,0) = 0
			INNER JOIN ListProcedure ON ListProcedure.ProcedureUid = SuperbillProcedure.ProcedureUid
			--LEFT JOIN ListProcedureCodeType ON ListProcedureCodeType.ProcedureCodeTypeUid = ListProcedure.ProcedureCodeTypeUid AND ListProcedureCodeType.Name IN ('CPT','HCPCS')
			--LEFT JOIN ListProcedureServiceType ON ListProcedureServiceType.ProcedureServiceTypeUid = ListProcedure.ProcedureServiceTypeUid
			INNER JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = SuperbillProcedure.SuperbillProcedureUid -- #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
			INNER JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid 
									AND AR_Ledger.EntryType = 3
									AND AR_Ledger.VoidLedgerUid IS NULL
									AND #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner] = AR_LedgerDetail.LiabilityOwner
			--LEFT JOIN listcredittype on listcredittype.credittypeuid = AR_LedgerDetail.IncomeAccountUid
			INNER JOIN ListERACode  lecGroup ON AR_Ledger.GroupERACodeUid = lecGroup.ERACodeUID AND lecGroup.TYPE = 'group'
			INNER JOIN ListERACode lecReason ON AR_Ledger.ReasonERACodeUid = lecReason.ERACodeUID AND (lecReason.TYPE = 'status' OR lecReason.TYPE = 'reason')
			LEFT OUTER JOIN AR_Ledger arlVoid on AR_Ledger.LedgerUid = arlVoid.VoidLedgerUid
			--LEFT OUTER JOIN #XMLClaims_Sec_temp xClaimsIns ON xClaimsIns.tag = 1
			--													AND xClaimsIns.[OTHERPAYER!1!LiabilityOwner] = AR_LedgerDetail.LiabilityOwner
	WHERE
			#XMLClaims_Sec_temp.tag = 1 --AND
			--(listcredittype.isAdjustment = '1' OR (listcredittype.isAdjustment = '0' AND listcredittype.IsPayment = '0' )))
			--ListCreditType.TransactionTypeUid = 'DFE2CDCD-F156-4C5C-A56E-52D7CD3105D3' -- Contractual Adjustment
			AND arlVoid.LedgerUid IS NULL
	GROUP BY AR_LedgerDetail.LiabilityOwner,
			 SuperbillProcedure.DisplayOrder,
			 SuperbillProcedure.SuperbillProcedureUid,
			 ListProcedure.Code,
			 lecGroup.Code,
			 lecReason.Code,
			 #XMLClaims_Sec_temp.[OTHERPAYER!1!insuranceplanuid]
	HAVING SUM(-AR_LedgerDetail.Amount) != 0 

	-- PROCCOBERA ( Contractual adjustments )
	-- select * from #XMLClaims_Sec_temp

	-- 3048 start
	INSERT INTO #XMLClaims_Sec_temp
	(
	  tag,
	  parent,
	  [INSURANCEPLAN!6!address1],
	  [INSURANCEPLAN!6!address2],
	  [INSURANCEPLAN!6!city],
	  [INSURANCEPLAN!6!state],
	  [INSURANCEPLAN!6!zip]
	)
	SELECT   
	  6                                                       AS Tag,
	  1 AS parent, 

	  'a' as [INSURANCEPLAN!6!address1],
	  'b' as [INSURANCEPLAN!6!address2],
	  'c' as [INSURANCEPLAN!6!city],
	  'd' as [INSURANCEPLAN!6!state],
	  'e' as[INSURANCEPLAN!6!zip]
      FROM #XMLClaims_Sec_temp
		   INNER JOIN InsurancePlan ON #XMLClaims_Sec_temp.[OTHERPAYER!1!insuranceplanuid] = InsurancePlan.InsurancePlanUid
	  WHERE tag = 1

	-- 3048 end


	--Tax Paid
	UPDATE				#XMLClaims_Sec_temp
	SET					[PROCCOB!2!TaxPaid] = CONVERT( VARCHAR(19), CAST(
												  (SELECT -sum(DISTINCT AR_LedgerDetail.amount)
												  FROM superbillprocedure
												   JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
												  
												   JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid and AR_Ledger.EntryType = 2
												  RIGHT JOIN listcredittype on listcredittype.credittypeuid = AR_LedgerDetail.IncomeAccountUid AND listcredittype.credittypeuid = '914DD6FB-6EBB-43A5-A6FC-09FD156CCF26'
												  WHERE superbillprocedure.superbillProcedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
												  AND listcredittype.IsPayment = 1) AS FLOAT))


	--Patient Paid
	UPDATE				#XMLClaims_Sec_temp
	SET					[PROCCOB!2!PatPaid] = CONVERT( VARCHAR(19), CAST(
												(SELECT -sum(DISTINCT AR_LedgerDetail.amount)
											   FROM superbillprocedure
											   JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
											   JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid and AR_Ledger.EntryType = 2
											   JOIN listcredittype on listcredittype.credittypeuid = AR_LedgerDetail.IncomeAccountUid
											   WHERE superbillprocedure.superbillProcedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] 
											   AND AR_LedgerDetail.accountresponsiblepartyuid is not null) AS FLOAT) )
	--*** Procedure Ammount allowed
	UPDATE				#XMLClaims_Sec_temp
	SET					[PROCCOB!2!AmountAllowed] = CONVERT( VARCHAR(19), CAST(
	                                                 (SELECT top 1 AR_RelLedgerDetailModifier.ActualAmountAllowed
							    					 FROM superbillprocedure
													 JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] AND AR_LedgerDetail.LiabilityOwner = #XMLClaims_Sec_temp.[PROCCOB!2!LiabilityOwner]
													 JOIN AR_RelLedgerDetailModifier on AR_RelLedgerDetailModifier.LedgerDetailUid = AR_LedgerDetail.LedgerDetailUid
													 WHERE superbillprocedure.superbillProcedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
													 order by AR_RelLedgerDetailModifier.LastModifiedDate desc) AS FLOAT))

	--*** Procedure date paid or Adjducated
	UPDATE				#XMLClaims_Sec_temp
	SET					[PROCCOB!2!DatePaid] = (SELECT top 1 CONVERT(VARCHAR, AR_Ledger.EntryDate, 101)    
												FROM Superbill 
												JOIN superbillprocedure on SuperbillProcedure.SuperbillUid = Superbill.SuperbillUid
												JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] 
												JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid and AR_Ledger.EntryType = 2 
												WHERE superbillprocedure.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] 
												ORDER BY AR_Ledger.EntryDate DESC)

	-- CHC
	EXEC AR_genSecondary_InfoCHC @SuperBillUid = @SuperBillUid, @DisplayOrder=@DisplayOrder
					                   
END  

--SELECT * FROM #XMLClaims_Sec_temp
--ORDER BY  #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner], tag, #XMLClaims_Sec_temp.[OTHERPAYER!1!DisplayOrder], #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]

SELECT * FROM #XMLClaims_Sec_temp
ORDER BY  #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner], tag, #XMLClaims_Sec_temp.[OTHERPAYER!1!DisplayOrder], #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
FOR XML EXPLICIT 
END
















GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_SERVICEFACILITY]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_SERVICEFACILITY] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_SERVICEFACILITY]
AS

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide], 	--Added by Shweta

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SERVICEFACILITY!430!PID],
	[SERVICEFACILITY!430!type],
	[SERVICEFACILITY!430!orgName],
	[SERVICEFACILITY!430!address1],
	[SERVICEFACILITY!430!address2],
	[SERVICEFACILITY!430!city],
	[SERVICEFACILITY!430!state],
	[SERVICEFACILITY!430!zip],
	[SERVICEFACILITY!430!phone],
	[SERVICEFACILITY!430!siteType],
	[SERVICEFACILITY!430!PrimaryIDType],
	[SERVICEFACILITY!430!PrimaryID],
	[SERVICEFACILITY!430!IDType],
	[SERVICEFACILITY!430!ID],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID] 
)
SELECT
	430 					AS Tag,
	400 					AS parent,
	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]			AS [CLAIM!400!PID],
	[PATIENT!300!PEID]			AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]		AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]	AS [PAYER!230!ID!hide],			-- added by Shweta

	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!ID!hide],
	[SERVICEFACILITY!430!PID]		AS [SERVICEFACILITY!430!PID],
	'FA'					AS [SERVICEFACILITY!430!type],		--'77'
    (CASE WHEN ListServiceSite.FormalName IS NOT NULL THEN ListServiceSite.FormalName
          ELSE ListServiceSite.Name
     END)	AS [SERVICEFACILITY!430!orgName],
	ListServiceSite.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!address1],
	ListServiceSite.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!address2],
	ListServiceSite.[Address].value('(/Address/City)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!city],
	UPPER(ListServiceSite.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')) AS [SERVICEFACILITY!430!state],
	ListServiceSite.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!zip],
	dbo.stripSpecialChars(ListServiceSite.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS [SERVICEFACILITY!430!phone],

	ListServiceSiteType.ANSICode		AS [SERVICEFACILITY!430!siteType],

	[CLAIM!400!facilityPrimaryIDType] 		AS [SERVICEFACILITY!430!PrimaryIDType],
	[CLAIM!400!facilityPrimaryID] 			AS [SERVICEFACILITY!430!PrimaryID],
	[CLAIM!400!facilityIDType] 		AS [SERVICEFACILITY!430!IDType],
	[CLAIM!400!facilityID] 			AS [SERVICEFACILITY!430!ID],
    [FINANCIALCENTER!105!FCID]     AS  [FINANCIALCENTER!105!FCID],
	#XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
	INNER JOIN ListServiceSite on ListServiceSite.ServiceSiteUid = #XMLClaims_temp.[SERVICEFACILITY!430!PID]
	LEFT JOIN ListServiceSiteType ON ListServiceSiteType.ServiceSiteTypeUid = ListServiceSite.ServiceSiteTypeUid
WHERE
	#XMLClaims_temp.tag = 400


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PROVIDER] AS' 
END
GO

/*
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/

ALTER PROC [dbo].[AR_genXMLClaims_PROVIDER]
AS
INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	--[CLAIM!400!PID],
	[PROVIDER!110!PID],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup],
	--[PAYTOPROVIDER!130!IDType],
	--[PAYTOPROVIDER!130!ID],
	
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType],
	[PAYTOPROVIDER!130!NPISecID],
	
	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID],
	
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID],
    [FINANCIALCENTER!105!FCID]
)
SELECT DISTINCT
	110 								AS	Tag,
	105 								AS	parent,
	[SITE!100!PID]						AS	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS	[SITE!100!payToAddressID!hide],
	--[CLAIM!400!PID]					AS	[CLAIM!400!PID],
	[RENDERER!410!ID!hide]				AS	[PROVIDER!110!PID],
	[RENDERER!410!ID!hide]				AS	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID]					AS	[RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID]			AS	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup]	AS	[BILLINGPROVIDER!120!FileAsGroup],
	--[PAYTOPROVIDER!130!IDType] 			AS	[PAYTOPROVIDER!130!IDType],
	--[PAYTOPROVIDER!130!ID] 				AS	[PAYTOPROVIDER!130!ID],
	
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
	[PAYTOPROVIDER!130!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],

	[BILLINGPROVIDER!120!IDType] 		AS	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID] 			AS	[BILLINGPROVIDER!120!ID],
	
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType]	AS	[BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID]		AS	[BILLINGPROVIDER!120!NPISecID],
    [FINANCIALCENTER!105!FCID]	        AS  [FINANCIALCENTER!105!FCID]
	
FROM #XMLClaims_temp
WHERE
	#XMLClaims_temp.tag = 400

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_SUBSCRIBER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_SUBSCRIBER] AS' 
END
GO


ALTER PROC [dbo].[AR_genXMLClaims_SUBSCRIBER]
AS

/*
Modified On: 20050823
Modifications Made:	1. For handling WCC Case... OP values from Person or Corporation table.
			Corporation Name is populated in OrgName element
*/
-- 2016-07-11 Bug 36412 - Country Code

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],
	[PAYER!230!planType!hide],
	[SUBSCRIBER!200!prefix],
	[SUBSCRIBER!200!LN],
	[SUBSCRIBER!200!FN],
	[SUBSCRIBER!200!MI],
	[SUBSCRIBER!200!suffix],
	[SUBSCRIBER!200!gender],
	[SUBSCRIBER!200!birthdate],
	[SUBSCRIBER!200!employer],
	[SUBSCRIBER!200!occupation],
	[SUBSCRIBER!200!address1],
	[SUBSCRIBER!200!address2],
	[SUBSCRIBER!200!city],
	[SUBSCRIBER!200!state],
	[SUBSCRIBER!200!zip],
	[SUBSCRIBER!200!country],
	[SUBSCRIBER!200!phoneNumber],
	[SUBSCRIBER!200!rIDType],
	[SUBSCRIBER!200!rID],
	[SUBSCRIBER!200!IDType],
	[SUBSCRIBER!200!ID],
	[SUBSCRIBER!200!payerResponsibility],
	[SUBSCRIBER!200!DISPLAYORDER],
	[SUBSCRIBER!200!Phone1],
	[SUBSCRIBER!200!Phone1Type],
	[SUBSCRIBER!200!Phone2],
	[SUBSCRIBER!200!Phone2Type],
	[SUBSCRIBER!200!Email1],
	[SUBSCRIBER!200!SpecialCase],
	[SUBSCRIBER!200!groupID],	
	[SUBSCRIBER!200!groupName],	-- Added for AK Medicaid by Qatalys	
	[SUBSCRIBER!200!isWCC],		-- added by SM for WCC handling
    [FINANCIALCENTER!105!FCID],
	[SUBSCRIBER!200!AccountID],
	[SUBSCRIBER!200!AccountPeriodID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]
)	
SELECT DISTINCT
	200 						AS tag,
	110 						AS parent,
	#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],

	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.personUId 
		WHEN [SUBSCRIBER!200!isWCC] = 1 THEN inc.CorporationUid END AS [SUBSCRIBER!200!PEID],

	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],
	#XMLClaims_temp.[PAYER!230!planType!hide]	AS [PAYER!230!planType!hide],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CAST( Person.prefix AS varchar(10))
		                                 ELSE NULL END AS [SUBSCRIBER!200!prefix],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN  UPPER(Person.LastName) 
		ELSE NULL END AS [SUBSCRIBER!200!LN],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN  UPPER(Person.FirstName) 
		ELSE NULL END AS [SUBSCRIBER!200!FN],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN UPPER(Person.MiddleName) 
		ELSE NULL END AS [SUBSCRIBER!200!MI],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.suffix
		ELSE NULL END AS [SUBSCRIBER!200!suffix],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN ListGender.ANSICode
		ELSE NULL END AS [SUBSCRIBER!200!gender],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CONVERT(VARCHAR, Person.birthdate,101)
		ELSE NULL END AS [SUBSCRIBER!200!birthdate],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Corporation.Name 
		ELSE  inc.Name END AS [SUBSCRIBER!200!employer],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CONVERT(VARCHAR(50),ListOccupation.Name) -- 57803
		ELSE NULL END AS [SUBSCRIBER!200!occupation],	

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!address1],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!address2],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!city],
	UPPER(CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
	END) AS [SUBSCRIBER!200!state],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!zip],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		UPPER(LEFT(Person.Address1.value('(/Address/Country)[1]', 'VARCHAR(100)'), 2))
	ELSE
		UPPER(LEFT( inc.[Address].value('(/Address/Country)[1]', 'VARCHAR(100)'), 2))
	END AS [SUBSCRIBER!200!country],
	dbo.stripSpecialChars (CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
	ELSE
		inc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
	END) AS [SUBSCRIBER!200!phoneNumber],

	'SY'						AS [SUBSCRIBER!200!rIDType],
	dbo.stripSpecialChars(Person.SocialSecurityNumber) AS [SUBSCRIBER!200!rID],

	'MI'						AS [SUBSCRIBER!200!IDType],
	dbo.stripSpecialChars([CLAIM!400!subscriberMemberID]) AS [SUBSCRIBER!200!ID],

	[SUBSCRIBER!200!payerResponsibility]		AS [SUBSCRIBER!200!payerResponsibility],
	[SUBSCRIBER!200!DISPLAYORDER] as [SUBSCRIBER!200!DISPLAYORDER],

	-- Phone1
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(20)')
	ELSE
		inc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(20)')
	END AS [SUBSCRIBER!200!Phone1],
	-- Phone1Type
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone1.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)')
	ELSE
		inc.Phone1.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)')
	END AS [SUBSCRIBER!200!Phone1Type],
	-- Phone2
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone2.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(20)')
	ELSE
		inc.Phone2.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(20)')
	END AS [SUBSCRIBER!200!Phone2],
	-- Phone2Type
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone2.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)')
	ELSE
		inc.Phone2.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)')
	END AS [SUBSCRIBER!200!Phone2Type],
	-- Email1
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.Email1 ELSE inc.Email1 END AS  [SUBSCRIBER!200!Email1],
    (Case WHEN ( pis.Value IS NOT NULL AND pis.Value like '%17667(True)%') THEN '31873' ELSE NULL END) AS [SUBSCRIBER!200!SpecialCase], -- See bug 31873

	[CLAIM!400!patientgroupID]			AS [SUBSCRIBER!200!groupID]
	,[CLAIM!400!patientgroupName]			As [SUBSCRIBER!200!groupName]	-- Added for AK Medicaid by Qatalys
	,[SUBSCRIBER!200!isWCC]			AS [SUBSCRIBER!200!isWCC],
    [FINANCIALCENTER!105!FCID]      AS  [FINANCIALCENTER!105!FCID],
	#XMLClaims_temp.[CLAIM!400!AccountID]			AS [SUBSCRIBER!200!ACCOUNTID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID]		AS [SUBSCRIBER!200!AccountPeriodID],
	#XMLClaims_temp.[CLAIM!400!AccountID]			AS [CLAIM!400!ACCOUNTID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID]		AS [CLAIM!400!AccountPeriodID]   

FROM #XMLClaims_temp
		INNER JOIN ClaimBatch cb with (nolock) on #XMLClaims_temp.[SITE!100!eClaimBatchGUID] = cb.ClaimBatchUid
		LEFT JOIN Person with (nolock) ON	Person.PersonUid = [SUBSCRIBER!200!PEID]
		LEFT JOIN ListGender with (nolock) ON	Person.GenderUid = ListGender.GenderUid
		-- in case Insured is an Organization
		LEFT JOIN Corporation inc with (nolock) ON 	inc.CorporationUid = [SUBSCRIBER!200!PEID]
		LEFT JOIN PersonEmployer (nolock)  ON	PersonEmployer.PersonUid = Person.PersonUid
		LEFT JOIN Corporation with (nolock) ON	PersonEmployer.EmployerUid = Corporation.CorporationUid
		LEFT JOIN ListOccupation with (nolock) ON PersonEmployer.OccupationUid = ListOccupation.OccupationUid
		LEFT OUTER JOIN PlugInSettings pis WITH (NOLOCK) on cb.ClaimClearingHouseUid = pis.ClaimClearingHouseUid															
																and pis.Name = 'SpecialCase'
WHERE
	#XMLClaims_temp.tag = 400 AND
	#XMLClaims_temp.[SUBSCRIBER!200!PEID] IS NOT NULL





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_SUPERVISING]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_SUPERVISING] AS' 
END
GO

/*  
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
				2014-05-29 Bug29864
*/  


ALTER PROC [dbo].[AR_genXMLClaims_SUPERVISING]
AS

--DEFECT #9657
DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'Provider NPI' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @EINUid UNIQUEIDENTIFIER
SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'ETIN' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @UPINUid UNIQUEIDENTIFIER
SELECT @UPINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'UPIN' AND ISNULL(cfvt1.Inactive, 0) = 0

DECLARE @SSNUid UNIQUEIDENTIFIER
SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0		

-- SUPERVISING!415
INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],		--added by Shweta
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	--[SUPERVISING!415!PEID],
	[SUPERVISING!415!PID],
	[SUPERVISING!415!LN],
	[SUPERVISING!415!FN],
	[SUPERVISING!415!MI],
	[SUPERVISING!415!orgName],
	[SUPERVISING!415!IDType],
	[SUPERVISING!415!ID],
	[SUPERVISING!415!rIDType],
	[SUPERVISING!415!rID],
	--[SUPERVISING!415!providerTaxonomyCode],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]    
)
SELECT
	415 						AS tag,
	400 						AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]				AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			-- added by Shweta

	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],

	--Provider.PersonUid				AS [SUPERVISING!415!PEID],

	Provider.PersonUid				AS [SUPERVISING!415!PID],

	UPPER(Person.LastName)			AS [SUPERVISING!415!LN],
	UPPER(Person.FirstName)			AS [SUPERVISING!415!FN],
	UPPER(Person.MiddleName)			AS [SUPERVISING!415!MI],

	NULL						AS [SUPERVISING!415!orgName],
    
	--DEFECT #9657
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'XX'
			 WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END	
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END			
	END
	AS [SUPERVISING!415!IDType],
	
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	END
	AS [SUPERVISING!415!ID],

--	'1G'						AS [REFERRER!420!rIDType],
--	dbo.stripSpecialChars(COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,NULL,NULL) ,Provider.UPIN))		AS [REFERRER!420!rID]

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN '1G'
  ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
    ELSE InsurancePlan.ElectronicClaimFormatUid END,  
     5,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
 END) AS [SUPERVISING!415!rIDType],

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) ,'')
ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) 
END) AS [SUPERVISING!415!rID] ,
--ISNULL(ListSpecialty.ANSICode,'')				AS [REFERRER!415!providerTaxonomyCode],
      [FINANCIALCENTER!105!FCID]  AS   [FINANCIALCENTER!105!FCID], 
	[CLAIM!400!AccountID]						AS [CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]					AS [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
INNER JOIN Provider ON
	Provider.PersonUid = #XMLClaims_temp.[SUPERVISING!415!PID]
INNER JOIN Person ON
	Provider.PersonUid = Person.PersonUid
LEFT JOIN ListSpecialty ON 
	Provider.SpecialtyUid = ListSpecialty.SpecialtyUid
INNER JOIN Superbill ON 
	/*Superbill.ReferringProviderUid = #XMLClaims_temp.[SUPERVISING!415!PID] AND */Superbill.SuperbillUid = [CLAIM!400!PID]
INNER JOIN ViewSuperbillFinancialDetails on ViewSuperbillFinancialDetails.SuperbillUid = Superbill.SuperbillUid 	
INNER JOIN SuperbillUB ON SuperbillUB.SuperBillUID = ViewSuperbillFinancialDetails.SuperBillUID and SuperbillUB.SUPERVISINGProviderUID = #XMLClaims_temp.[SUPERVISING!415!PID]
INNER JOIN Claimbatchdetail ON 
	Claimbatchdetail.SuperbillUid = SuperbillUB.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
  INNER JOIN account ON  
   account.accountUid = superbill.accountUid  
  INNER JOIN AccountResponsibleParty ON  
   Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
  INNER JOIN AccountPeriod ON  
   AccountPeriod.Accountuid = account.accountUid  
	AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
/*   AND (AccountPeriod.effectiveDate <= superbill.serviceDateEnd  
    AND (AccountPeriod.ExpirationDate IS NULL  
    OR AccountPeriod.ExpirationDate >= superbill.serviceDateEnd) OR AccountPeriod.effectiveDate IS NULL)  */
  INNER JOIN AccountInsurance  ON  
   AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
  INNER JOIN PersonInsurancePlan  
   ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
   AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
  INNER JOIN InsurancePlan  
   ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
  INNER JOIN InsuranceCarrier  
   ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  	

WHERE
	#XMLClaims_temp.tag = 400

-- ORDERING!425
INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],		--added by Shweta
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	--[ORDERING!425!PEID],
	[ORDERING!425!PID],
	[ORDERING!425!LN],
	[ORDERING!425!FN],
	[ORDERING!425!MI],
	[ORDERING!425!orgName],
	[ORDERING!425!IDType],
	[ORDERING!425!ID],
	[ORDERING!425!rIDType],
	[ORDERING!425!rID],
	--[SUPERVISING!415!providerTaxonomyCode],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]    
)
SELECT
	425 						AS tag,
	400 						AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]				AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			

	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],

	Provider.PersonUid				AS [ORDERING!425!PID],

	UPPER(Person.LastName)			AS [ORDERING!425!LN],
	UPPER(Person.FirstName)			AS [ORDERING!425!FN],
	UPPER(Person.MiddleName)		AS [ORDERING!425!MI],
	NULL							AS [ORDERING!425!orgName],
    
	--DEFECT #9657
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				'XX'
			 WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END	
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END			
	END
	AS [SUPERVISING!415!IDType],
	
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	END
	AS [SUPERVISING!415!ID],

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) = '' THEN '1G'
  ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
    ELSE InsurancePlan.ElectronicClaimFormatUid END,  
     5,provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid)
 END) AS [SUPERVISING!415!rIDType],

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) ,'')
ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) 
END) AS [SUPERVISING!415!rID] ,
      [FINANCIALCENTER!105!FCID]  AS   [FINANCIALCENTER!105!FCID], 
	[CLAIM!400!AccountID]						AS [CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]					AS [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
	INNER JOIN Provider ON Provider.PersonUid = #XMLClaims_temp.[ORDERING!425!PID]
	INNER JOIN Person ON Provider.PersonUid = Person.PersonUid
	INNER JOIN Superbill ON Superbill.SuperbillUid = [CLAIM!400!PID]
	INNER JOIN SuperbillAggregate sba ON Superbill.SuperbillUid = sba.SuperbillUid	
	INNER JOIN Claimbatchdetail ON Claimbatchdetail.SuperbillUid = sba.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
	INNER JOIN AccountPeriod ON sba.AccountPeriodUid = AccountPeriod.AccountPeriodUid
	  INNER JOIN AccountInsurance  ON  AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
	  INNER JOIN PersonInsurancePlan  ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
										   AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
	  INNER JOIN InsurancePlan ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
	  INNER JOIN InsuranceCarrier  ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  	
	--LEFT JOIN ListSpecialty ON Provider.SpecialtyUid = ListSpecialty.SpecialtyUid

WHERE
	#XMLClaims_temp.tag = 400



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_REFERRER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_REFERRER] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_REFERRER]
AS

DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'Provider NPI' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @EINUid UNIQUEIDENTIFIER
SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'ETIN' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @UPINUid UNIQUEIDENTIFIER
SELECT @UPINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'UPIN' AND ISNULL(cfvt1.Inactive, 0) = 0

DECLARE @SSNUid UNIQUEIDENTIFIER
SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0		

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],		
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[REFERRER!420!PEID],
	[REFERRER!420!PID],
	[REFERRER!420!LN],
	[REFERRER!420!FN],
	[REFERRER!420!MI],
	[REFERRER!420!orgName],
	[REFERRER!420!IDType],
	[REFERRER!420!ID],
	[REFERRER!420!rIDType],
	[REFERRER!420!rID],
	[REFERRER!420!providerTaxonomyCode],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]
)
SELECT
	420 						AS tag,
	400 						AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]				AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			
	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
	Provider.PersonUid				AS [REFERRER!420!PEID],
	Provider.PersonUid				AS [REFERRER!420!PID],
	UPPER(Person.LastName)			AS [REFERRER!420!LN],
	UPPER(Person.FirstName)			AS [REFERRER!420!FN],
	UPPER(Person.MiddleName)			AS [REFERRER!420!MI],
	NULL						AS [REFERRER!420!orgName],

	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'XX'
			 WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END	
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END			
	END
	AS [REFERRER!420!IDType],
	
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	END
	AS [REFERRER!420!ID],

	(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN '1G'
	  ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,  
		 5,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
	 END) AS [REFERRER!420!rIDType],

	(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) ,'')
	ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) 
	END) AS [REFERRER!420!rID] ,
	ISNULL(ListSpecialty.ANSICode,'')				AS [REFERRER!420!providerTaxonomyCode],
      [FINANCIALCENTER!105!FCID]  AS   [FINANCIALCENTER!105!FCID],
	  #XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
	  #XMLClaims_temp.[CLAIM!400!AccountPeriodID] AS [CLAIM!400!AccountPeriodID] 
FROM #XMLClaims_temp
	INNER JOIN Provider ON Provider.PersonUid = #XMLClaims_temp.[REFERRER!420!PID]
	INNER JOIN Person ON Provider.PersonUid = Person.PersonUid
	LEFT JOIN ListSpecialty ON Provider.SpecialtyUid = ListSpecialty.SpecialtyUid
	INNER JOIN Superbill ON Superbill.SuperbillUid = [CLAIM!400!PID]
	INNER JOIN Claimbatchdetail ON Claimbatchdetail.SuperbillUid = Superbill.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
	INNER JOIN ViewSuperbillFinancialDetails ON ViewSuperbillFinancialDetails.SuperbillUid = Claimbatchdetail.SuperbillUid	
	INNER JOIN account ON  account.accountUid = superbill.accountUid  
	INNER JOIN AccountResponsibleParty ON  Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
	INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  
									AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
										OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
										OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
										OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
	INNER JOIN AccountInsurance  ON  AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
	INNER JOIN PersonInsurancePlan ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
										AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
	INNER JOIN InsurancePlan ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
	INNER JOIN InsuranceCarrier  ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid   	
WHERE
	#XMLClaims_temp.tag = 400






GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_RENDERER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_RENDERER] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_RENDERER]
AS

DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'Provider NPI' AND ISNULL(cfvt1.Inactive, 0) = 0	

DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @EINUid UNIQUEIDENTIFIER
SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'ETIN' AND ISNULL(cfvt1.Inactive, 0) = 0	

DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

DECLARE @SSNUid UNIQUEIDENTIFIER
SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],				
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[RENDERER!410!LN],
	[RENDERER!410!FN],
	[RENDERER!410!MI],
	[RENDERER!410!address1],
	[RENDERER!410!address2],
	[RENDERER!410!city],
	[RENDERER!410!state],
	[RENDERER!410!zip],
	[RENDERER!410!dayPhone],
	[RENDERER!410!providerTaxonomyCode],
	[RENDERER!410!rIDType],
	[RENDERER!410!rID],
	[RENDERER!410!IDType],
	[RENDERER!410!ID],
	[RENDERER!410!CLIA],
	[RENDERER!410!MamographyCertNo],
	[RENDERER!410!SendCLIA],
	[RENDERER!410!SendMamographyCertNo],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]	
)
SELECT
	410 							AS tag,
	400 							AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]					AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			

	Provider.PersonUid				AS [RENDERER!410!ID!hide],
	Provider.PersonUid				AS [RENDERER!410!PEID],
	Person.LastName					AS [RENDERER!410!LN],
	Person.FirstName				AS [RENDERERE!410!FN],
	Person.MiddleName				AS [RENDERER!410!MI],
		Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [RENDERER!410!address1],
	Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [RENDERER!410!address2],
	Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') AS [RENDERER!410!city],
	UPPER(Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')) AS [RENDERER!410!state],
	Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [RENDERER!410!zip],
	dbo.stripSpecialChars(Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS [RENDERER!410!dayPhone],

	ISNULL(ListSpecialty.ANSICode,'')				AS [RENDERER!410!providerTaxonomyCode],
	[CLAIM!400!providerIDType]						AS [RENDERER!410!rIDType],
	[CLAIM!400!providerID]							AS [RENDERER!410!rID],

	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		(CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN
				'XX'
			  WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			  WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN 
				'34'
			  ELSE ''
		 END)	
	ELSE 
		(CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			  WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN 
				'34'
			  ELSE ''
		 END)	
	END AS [RENDERER!410!IDType],

	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
					ELSE	
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'')
				END
			ELSE ''
		END	
	ELSE 
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
					ELSE	
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'')
				END
			ELSE ''
		END
	END AS [RENDERER!410!ID], 

   dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,10,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid))
      AS [RENDERER!410!CLIA],
 
    dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,11,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid))
      AS [RENDERER!410!MamographyCertNo],	
 
    dbo.UDF_SendValue(CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,1,1,Superbill.SuperbillUid) AS [RENDERER!410!SendCLIA],

	dbo.UDF_SendValue(CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,1,2,Superbill.SuperbillUid) AS  [RENDERER!410!SendMamographyCertNo],

      [FINANCIALCENTER!105!FCID]  AS  [FINANCIALCENTER!105!FCID],
	#XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
	INNER JOIN Provider ON Provider.PersonUid = #XMLClaims_temp.[RENDERER!410!PEID]
	INNER JOIN Person ON Person.PersonUid = Provider.PersonUid
	LEFT JOIN ListSpecialty ON 	Provider.SpecialtyUid = ListSpecialty.SpecialtyUid
	LEFT JOIN ViewSuperbillFinancialDetails on ViewSuperbillFinancialDetails.SuperbillUid =  [CLAIM!400!PID] 
			AND ViewSuperbillFinancialDetails.ClaimingProviderUid = #XMLClaims_temp.[RENDERER!410!PEID] AND ViewSuperbillFinancialDetails.SuperbillUid = [CLAIM!400!PID]--2011 change
	LEFT JOIN Superbill ON Superbill.SuperbillUid = ViewSuperbillFinancialDetails.SuperbillUid --AND Superbill.SuperbillUid = [CLAIM!400!PID]	
	LEFT JOIN Claimbatchdetail ON Claimbatchdetail.SuperbillUid = Superbill.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
	INNER JOIN InsurancePlan ON Claimbatchdetail.InsuranceplanUid=InsurancePlan.InsuranceplanUid 
	INNER JOIN InsuranceCarrier ON InsuranceCarrier.CorporationUid = #XMLClaims_temp.[PAYER!230!ID!hide]
WHERE
	#XMLClaims_temp.tag = 400









GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_RESPONSIBLEPARTY]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_RESPONSIBLEPARTY] AS' 
END
GO

-- 2015-02-18 dsw 35524 (33744)- Remove validation check for Responsible Party information during EDI creation.

ALTER PROC [dbo].[AR_genXMLClaims_RESPONSIBLEPARTY]
AS
/*
	Note: Here we are assuming that ClaimPayerID is unique for all carriers. This conclusion has been deducted from 
		the PS - Stored Procedure
*/
	-- 35524 (33744)- Remove validation check for Responsible Party information during EDI creation.
	DECLARE @scrubResponsibleParty bit
	SELECT @scrubResponsibleParty = ( COALESCE( lpp.IntegerValue, 0 ) )
	FROM ListProductParameter lpp with (nolock) 
	WHERE lpp.ProductParameterUid = 'D913C232-E6B2-4D07-8231-043FD80609EF'
		AND lpp.ParameterName = 'Scrub.ResponsibleParty'

	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide],
		[RENDERER!410!PEID],
		[SUBSCRIBER!200!PEID],
		[RESPONSIBLEPARTY!240!ID!hide],
		[RESPONSIBLEPARTY!240!PEID],
		[RESPONSIBLEPARTY!240!prefix],
		[RESPONSIBLEPARTY!240!LN],
		[RESPONSIBLEPARTY!240!FN],
		[RESPONSIBLEPARTY!240!MI],
		[RESPONSIBLEPARTY!240!suffix],
		[RESPONSIBLEPARTY!240!address1],
		[RESPONSIBLEPARTY!240!address2],
		[RESPONSIBLEPARTY!240!city],
		[RESPONSIBLEPARTY!240!state],
		[RESPONSIBLEPARTY!240!zip],		
		[RESPONSIBLEPARTY!240!contactName],
		[RESPONSIBLEPARTY!240!contact1String],
		[RESPONSIBLEPARTY!240!isCorporation],
		[FINANCIALCENTER!105!FCID],
		[CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID] 
	)
	SELECT DISTINCT
		240 						AS tag,
		200 						AS parent,

		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID] 	AS [SUBSCRIBER!200!PEID],

		
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 0 THEN Person.personUId 
		WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 1 THEN Corporation.CorporationUid END 	[RESPONSIBLEPARTY!240!ID!hide],

		-- 35524 - Even though AccountResponsibleParty is different than subscriber, make it "appear" the same so Loop 2010BC does not output
		CASE WHEN @scrubResponsibleParty = 1                 THEN #XMLClaims_temp.[SUBSCRIBER!200!PEID] -- 35524 - 
		     WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 0 THEN Person.personUId 
		     WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 1 THEN Corporation.CorporationUid END 	AS [RESPONSIBLEPARTY!240!PEID],

		' '						AS [RESPONSIBLEPARTY!240!prefix],		-- As Medicare is rejecting the claims because of Mr and Mrs. now we are using as blank

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN  UPPER(Person.LastName) 
			ELSE UPPER(Corporation.Name) END 	  AS [RESPONSIBLEPARTY!240!LN],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN  UPPER(Person.FirstName) 
			ELSE NULL END 				  AS [RESPONSIBLEPARTY!240!FN],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN UPPER(Person.MiddleName) 
			ELSE NULL END 			 AS [RESPONSIBLEPARTY!240!MI],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN UPPER(Person.Suffix) 
			 ELSE NULL END 			 AS [RESPONSIBLEPARTY!240!suffix],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!address1],
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!address2],
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!city],
		UPPER(CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		END) AS [RESPONSIBLEPARTY!240!state],
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!zip],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN  UPPER(COALESCE(Person.FirstName +' '+ Person.LastName, '')) 
			WHEN [RESPONSIBLEPARTY!240!isCorporation] = 1 THEN UPPER(COALESCE(Corporation.PrimaryContact, Corporation.SecondaryContact, ''))  END 	  											AS [RESPONSIBLEPARTY!240!contactName],

		dbo.stripSpecialChars(CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		ELSE
			Corporation.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		END) AS [RESPONSIBLEPARTY!240!contact1String],

		[RESPONSIBLEPARTY!240!isCorporation]		AS [RESPONSIBLEPARTY!240!isCorporation],
        [FINANCIALCENTER!105!FCID]					AS [FINANCIALCENTER!105!FCID],   
		[CLAIM!400!AccountID] AS [CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID] AS [CLAIM!400!AccountPeriodID] 
	FROM #XMLClaims_temp
			LEFT JOIN Person ON Person.PersonUid = [RESPONSIBLEPARTY!240!PEID]
			LEFT JOIN Corporation ON Corporation.CorporationUid = [RESPONSIBLEPARTY!240!PEID]
	WHERE
		tag  = 400
		AND #XMLClaims_temp.[RESPONSIBLEPARTY!240!PEID] IS NOT NULL






GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_BILLINGPROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_BILLINGPROVIDER] AS' 
END
GO



/*
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/

ALTER PROC [dbo].[AR_genXMLClaims_BILLINGPROVIDER]
 AS
--1 BILLINGPROVIDER (claimSubmitter) / PAYTOPROVIDER (payToAddress)
-- payToSSID,billingSSID

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup],
	[BILLINGPROVIDER!120!PID],
	--[BILLINGPROVIDER!120!orgName],
	[BILLINGPROVIDER!120!LN],
	[BILLINGPROVIDER!120!FN],
	[BILLINGPROVIDER!120!MI],
	[BILLINGPROVIDER!120!address1],
	[BILLINGPROVIDER!120!address2],
	[BILLINGPROVIDER!120!city],
	[BILLINGPROVIDER!120!state],
	[BILLINGPROVIDER!120!zip],
	[BILLINGPROVIDER!120!phone],
	[BILLINGPROVIDER!120!siteType],
	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID],	
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType],
    [BILLINGPROVIDER!120!NPISecID],

	[BILLINGPROVIDER!120!LocationNo],
    [FINANCIALCENTER!105!FCID]
)
SELECT
	120 					AS Tag,
	110 					AS parent,

	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID]	AS [BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup]	AS	[BILLINGPROVIDER!120!FileAsGroup],

	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.FinancialCenterUid
			ELSE Per.PersonUid  END		AS [BILLINGPROVIDER!120!PID],
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] =  1 THEN  UPPER(Fc.Name)
			ELSE  UPPER(Per.LastName) END 	    AS [BILLINGPROVIDER!120!LN],	
	CASE [BILLINGPROVIDER!120!FileAsGroup] WHEN 1 THEN   NULL
			ELSE UPPER(Per.FirstName) END 	AS [BILLINGPROVIDER!120!FN],
	CASE [BILLINGPROVIDER!120!FileAsGroup] WHEN 1 THEN  NULL
			ELSE UPPER(Per.MiddleName)  END 	AS [BILLINGPROVIDER!120!MI],	

	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!address1],
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!address2],											
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!city],
	UPPER(CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/State)[1]', 'VARCHAR(100)') 
	END) AS [BILLINGPROVIDER!120!state],
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!zip],
	dbo.stripSpecialChars(COALESCE(CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)') ELSE per.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)') END,'')) AS [BILLINGPROVIDER!120!phone],
	ListServiceSiteType.ANSICode		AS [BILLINGPROVIDER!120!siteType],

	[BILLINGPROVIDER!120!IDType]		AS [BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID]			 AS [BILLINGPROVIDER!120!ID],	

	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType]	AS [BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID]  	AS [BILLINGPROVIDER!120!NPISecID],

	'0001'					AS [BILLINGPROVIDER!120!LocationNo],
    [FINANCIALCENTER!105!FCID] AS [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp

INNER JOIN dbo.claimsubmitter ON
	claimSubmitter.ClaimSubmitterUid = #XMLClaims_temp.[SITE!100!claimSubmitterID!hide]

INNER JOIN Person Per ON Per.PersonUid = [RENDERER!410!PEID]

INNER JOIN FinancialCenter Fc ON Fc.FinancialCenterUid = [BILLINGPROVIDER!120!FCID]



LEFT JOIN ListServiceSite ON
	ListServiceSite.serviceSiteUid = claimSubmitter.ClaimSubmitterServiceSiteUid


LEFT JOIN ListServiceSiteType ON
	ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
	
WHERE
	#XMLClaims_temp.tag = 110




GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_CLAIM]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_CLAIM] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_CLAIM]
 @ClaimBatchUid UniqueIdentifier,  
 @claimsFetched int = 0 output  
WITH RECOMPILE AS
/*  
********************************************************************
CYS SC 07/23/09 - Added for Service Site bug (CYS Case #22420):
	[CLAIM!400!BillingProvider_IDType] VARCHAR(50)
	[CLAIM!400!BillingProvider_ID] VARCHAR(50)
CYS SC 07/23/09 - Added logic for Service Site NPI Overrides to:
	[BILLINGPROVIDER!120!IDType] and [BILLINGPROVIDER!120!ID] 
********************************************************************
CYS SC 10/22/09 - Remove NF ContractTypeCodes from TotalBill calc
Modified On: 20051011  
Modifications Made: 2. Modified for Accident date  
   1. For handling WCC Case... setting isWCC column : 20050823  

Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/  
 
--DEFECT #9657
 DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
 SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK) 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @ServiceSiteNPIUid UNIQUEIDENTIFIER
 SELECT @ServiceSiteNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Service Site NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @PayToProviderNPIUid UNIQUEIDENTIFIER
 SELECT @PayToProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1  WITH (NOLOCK)  
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Pay To Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @SSNUid UNIQUEIDENTIFIER
 SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK) 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	
 
 DECLARE @EINUid UNIQUEIDENTIFIER  
 SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

 DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK) 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  
 
-- test
declare @scrubsubscriber int
set @scrubsubscriber = 0
select @scrubsubscriber = coalesce(lpp.IntegerValue,0) from ListProductParameter lpp
							where ParameterName = 'Scrub.Subscriber' 
-- end test
 
  Declare @ecf TABLE 
 ( 
   SuperbillUid uniqueidentifier, 
   ElectronicClaimFormatUid uniqueidentifier,
   GroupOrInd varchar(255),
   IsIndividual bit,
   filingTypeSSN bit, 
   SSN	varchar(255),
   NPIOverrideUid uniqueidentifier,		-- Guid of ClaimFormatValueType for NPI override on a specific ElectronicClaimFormat 
   NPIOverrideFixedValue varchar(255)	-- Fixed value for NPI override on a specific ElectronicClaimFormat
 ) ;
 INSERT INTO @ecf( SuperbillUid, ElectronicClaimFormatUid, filingTypeSSN )
	 SELECT sb.SuperbillUid,
	        CASE WHEN ip.UseCarrierElectronicClaimFormat = 1 
				 THEN ic.ElectronicClaimFormatUid  
 				 ELSE ip.ElectronicClaimFormatUid END AS ElectronicClaimFormatUid,
 			0 as filingTypeSSN			-- default is to file for EIN for both group and individual filing types
  FROM #XMLClaims_temp  
  INNER JOIN ClaimBatch cb WITH (NOLOCK) ON cb.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
  INNER JOIN ClaimBatchDetail cbd WITH (NOLOCK) ON cbd.ClaimBatchUid = cb.ClaimBatchUid   
  INNER JOIN superbill sb WITH (NOLOCK) on sb.SuperbillUid = cbd.SuperbillUid --2011 change 
  INNER JOIN SuperbillAggregate sba WITH (NOLOCK) ON sb.SuperbillUid = sba.SuperbillUid  
  INNER JOIN account act WITH (NOLOCK) ON act.accountUid = sb.accountUid  
  INNER JOIN AccountInsurance  ai WITH (NOLOCK) ON ai.AccountPeriodUid = sba.AccountPeriodUid --ap.AccountPeriodUid 
											AND sba.CurrentCarrier = ai.DisplayOrder   
  INNER JOIN PersonInsurancePlan pip WITH (NOLOCK) ON pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid  
											--AND pip.InsurancePlanUid = cbd.InsurancePlanUid  
  INNER JOIN InsurancePlan ip WITH (NOLOCK) ON ip.InsurancePlanUid = pip.InsurancePlanUid  
  INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ic.CorporationUid = ip.InsuranceCarrierUid   
  LEFT JOIN ViewSuperbillCurrentLiabilityOwnerAndCarrier cl WITH (NOLOCK) ON sb.superbillUid = cl.superbillUid
WHERE  
  #XMLClaims_temp.tag = 100  --and ai.DisplayOrder = cl.CurrentCarrier-- this will make sure that we select current carrier when primary and secondary are the same
 
  --select * from @ecf
  
  Update @ecf
	Set GroupOrInd=	dbo.UDF_getFormatVaribleValue (2, ecf.ElectronicClaimFormatUid ,9,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), -- Electronic==2, Filing Type = 9
	    filingTypeSSN = dbo.UDF_getFormatVariableValue2 (2, ecf.ElectronicClaimFormatUid ,9,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), -- Electronic==2, Filing Type=9, Get Value2 ( If 1 then SSN else EIN )
		SSN = COALESCE ( NULLIF(dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), ''),
		                 ISNULL(p.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,''))
 FROM @ecf ecf
	INNER JOIN superbill sb on ecf.SuperbillUid = sb.SuperbillUid 
    INNER JOIN ViewSuperbillFinancialDetails ON ViewSuperbillFinancialDetails.superbillUid = sb.SuperbillUid and sb.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
    INNER JOIN provider ON provider.PersonUID = ViewSuperbillFinancialDetails.ClaimingProviderUid    --We have to use RenderingProviderUid  :Aji 2005 10 21 
    INNER JOIN Person p on Provider.PersonUid = p.PersonUid 
	
  Update @ecf
	SET IsIndividual= CASE (ecf.GroupOrInd) WHEN '1' THEN 1
										    WHEN 'individual' THEN 1
										    ELSE 0 END
  FROM @ecf ecf 
  			
  --select * from @ecf
  
-- Find the NPI Override for the ListClaimFormat ( if one exists )
  UPDATE @ecf
	SET NPIOverrideUid = cfvt.ClaimFormatValueTypeUid,
		NPIOverrideFixedValue = cfo.FixedValue
	FROM @ecf ecf
			INNER JOIN ClaimFormatOption cfo WITH (NOLOCK) ON ecf.ElectronicClaimFormatUid = cfo.ClaimFormatUid
			INNER JOIN ListClaimFormatOptionType cfot WITH (NOLOCK) ON cfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			INNER JOIN ListClaimFormatValueType cfvt WITH (NOLOCK) on cfo.ClaimFormatValueTypeUid = cfvt.ClaimFormatValueTypeUid
	WHERE cfo.ClaimFormatUid = ecf.ElectronicClaimFormatUid								-- cf.Name = 'e-Medicare'
 			--and cfot.ClaimFormatOptionTypeUid = '39EAD079-2603-4D12-9D94-C96585C39185'	-- cfot.Name = 'NPI Override'
			and cfot.Name = 'NPI Override'
 
   --select * from @ecf
 
 -- end test
 SET @claimsFetched =0  
 INSERT INTO #XMLClaims_temp  
 (  
  tag,  
  parent,  
  [SITE!100!PID],  
  [SITE!100!eClaimBatchGUID],  
  [SITE!100!claimSubmitterID!hide],  
  [SITE!100!payToAddressID!hide],  
  [CLAIM!400!PID],  
  [CLAIM!400!accountNumber],  
  [CLAIM!400!MedicalRecordNumber], -- Added for Ak Medicaid by Qatalys
  [CLAIM!400!totalBill],  
  [CLAIM!400!diag1],  
  [CLAIM!400!diag2],  
  [CLAIM!400!diag3],  
  [CLAIM!400!diag4],  
  [CLAIM!400!diag5],  
  [CLAIM!400!diag6],  
  [CLAIM!400!diag7],  
  [CLAIM!400!diag8],  
  [CLAIM!400!diag9],  
  [CLAIM!400!diag10],  
  [CLAIM!400!diag11],  
  [CLAIM!400!diag12], 
  [PAYER!230!ID!hide],  
  [PAYER!230!planType!hide],  
  [PATIENT!300!PEID],  
  [SUBSCRIBER!200!PEID],  
  [RESPONSIBLEPARTY!240!ID!hide],
  [RESPONSIBLEPARTY!240!PEID],			--Added by AW for 2010BC loop  2006 03 15
  [SUBSCRIBER!200!payerResponsibility],
  [SUBSCRIBER!200!DisplayOrder], --ADDED FOR SECONDARY CLAIMS   
  [PATIENT!300!patientRelationToInsured],  
  [CLAIM!400!patientMemberID],  
  [CLAIM!400!patientgroupID],  
  [CLAIM!400!patientgroupName],			-- Added for AK Medicaid by Qatalys
  [CLAIM!400!subscriberMemberID],  
  [CLAIM!400!authorizeAssignment],  
  [RENDERER!410!ID!hide],  
  [RENDERER!410!PEID],  
  [SUPERVISING!415!PID], 
  [ORDERING!425!PID], 
  [BILLINGPROVIDER!120!FCID],
  [BILLINGPROVIDER!120!FileAsGroup], 
  [REFERRER!420!PID],  
  [CLAIM!400!providerID],  
  [CLAIM!400!providerIDType],  
  [CLAIM!400!providerGroupID],  
  [CLAIM!400!providerGroupIDType],
  [CLAIM!400!providerGroupID2],  
  [CLAIM!400!providerGroupIDType2],
  [CLAIM!400!facilityPrimaryID],
  [CLAIM!400!facilityPrimaryIDType],
  [CLAIM!400!facilityID],  
  [CLAIM!400!facilityIDType],
  [PAYTOPROVIDER!130!IDType],  
  [PAYTOPROVIDER!130!ID], 
  [PAYTOPROVIDER!130!NPISecIDType],
  [PAYTOPROVIDER!130!NPISecID],
  [BILLINGPROVIDER!120!IDType],  
  [BILLINGPROVIDER!120!ID],
  [BILLINGPROVIDER!120!NPISecIDType],
  [BILLINGPROVIDER!120!NPISecID],
  [PROC!450!emergency],  
  [CLAIM!400!claimFrequencyCode],  
  [CLAIM!400!providerSignatureOnFile],  
  [CLAIM!400!patientAcceptAssignment],  
  [CLAIM!400!releaseOfInformation],  
  [CLAIM!400!patientSignatureSource],  
  [CLAIM!400!patientSignatureDate],  
  [CLAIM!400!siteType],  
  [CLAIM!400!relatedCausesCode],  
  [CLAIM!400!accidentState],  
  [CLAIM!400!accidentDate],   
  [CLAIM!400!onsetCurrentDate],  
  [CLAIM!400!onsetFirstDate],  
  [CLAIM!400!onsetFirstDateQualifier], -- dsw 09/24/2018, 11329
  [CLAIM!400!noWorkFromDate],  
  [CLAIM!400!noWorkToDate],  
  [CLAIM!400!hospitalizationStartDate],  
  [CLAIM!400!hospitalizationEndDate],
  [CLAIM!400!InitialTreatmentDate],  
  [CLAIM!400!familyPlan], 
  [CLAIM!400!ClaimNote],	-- Added for AK Medicaid by Qatalys 
  [CLAIM!400!Note],      -- Igor 9/29/09 per 2517 had to add this so that AK Medicaid code will not be broken		
  [CLAIM!400!NoteReferenceCode],--2517 added 09/28/2009	
  [CLAIM!400!priorAuthorizationCode],	
  [CLAIM!400!SendNPI],
  [CLAIM!400!Dmerc], 	
  [CLAIM!400!SendPQRIproc],
  [CLAIM!400!Output2310D],
  [CLAIM!400!OutputAAE], --bug 5129
  [CLAIM!400!OutputPR], --added 5/9/2011
  [CLAIM!400!ICN],	--ADDED ICN NUMBER REPORTED IN LOOP 2300 6/19/08
  [CLAIM!400!EPSDT] ,   --added 07/21/09 bug 1430
  [CLAIM!400!EPSDTReferralCondIndicator1] ,--added 07/21/09  bug 1430
  [CLAIM!400!EPSDTReferralCondIndicator2],--added 07/21/09  bug 1430
  [CLAIM!400!EPSDTReferralCondIndicator3] ,--added 07/21/09 bug 1430
  [CLAIM!400!EPSDTReferralCondIndicator4] ,--added 07/21/09 bug 1430
  [CLAIM!400!InsuranceTypeCode],
  [CLAIM!400!AuthReferralIndicator] , --bug 2570
  [CLAIM!400!BillingProvider_IDType],  
  [CLAIM!400!BillingProvider_ID],		 
  [CLAIM!400!LMPDate],
  [CLAIM!400!UserDefinedXml],
  [CLAIM!400!ResubmissionCode],
  [CLAIM!400!DelayReasonCode] , --bug 869
  [CLAIM!400!DateLastSeenBySupervising] , --bug 249	
  [CLAIM!400!SecPayerID] ,
  [CLAIM!400!SecPayerCode],
  [CLAIM!400!AssumedDate],
  [CLAIM!400!RelinquishedDate],
  [CLAIM!400!PatientPaidAmount],  
  [SERVICEFACILITY!430!PID],  
  [PROC!450!serviceLocation] ,
  [PROC!450!lineControlNo],
  [SUBSCRIBER!200!isWCC],  -- added by SM   
  [RESPONSIBLEPARTY!240!isCorporation],			--Added by AW for 2010BC loop  2006 03 15
  [FINANCIALCENTER!105!FCID],
  [CLAIM!400!AccountID],
  [CLAIM!400!AccountName],
  [ClAIM!400!AccountPeriodID],
  [CLAIM!400!PaperworkTypeID],
  [CLAIM!400!PaperworkTransmissionCodeID],
  [CLAIM!400!PaperworkControlNum],
  [CLAIM!400!Allow5010Codes],
  [CLAIM!400!UseICD10],
  [CLAIM!400!ElectronicClaimFormatUid]
  )  
  SELECT DISTINCT  
  400     AS tag, 
  -- test
  -- (CASE WHEN account.personUID = COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) THEN 200 ELSE 300  END)      AS parent,  
  
  (CASE WHEN @scrubsubscriber = 2 and ListRelationship.ANSICode  = 18 THEN 200
        WHEN @scrubsubscriber = 2 and ListRelationship.ANSICode <> 18 THEN 300
        WHEN account.personUID = COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) THEN 200 
		ELSE 300  END)      AS parent,  
  [SITE!100!PID]    AS [SITE!100!PID],   
  [SITE!100!eClaimBatchGUID]  AS [SITE!100!eClaimBatchGUID],    
  [SITE!100!claimSubmitterID!hide] AS [SITE!100!claimSubmitterID!hide],   
  [SITE!100!payToAddressID!hide]  AS [SITE!100!payToAddressID!hide],   
  superbill.SuperbillUid   AS [CLAIM!400!PID],  --SuperbillUid  
  CONVERT(VARCHAR(50),superbill.externalID) AS [CLAIM!400!accountNumber],  
  CONVERT(VARCHAR(50),Patient.MedicalRecordNumber) AS [CLAIM!400!MedicalRecordNumber],
  --CAST((SELECT SUM(ISNULL(TotalCharge,0)) FROM SuperbillProcedure sbp   
		--	LEFT JOIN ListContractTypeCode ON ListContractTypeCode.ContractTypeCodeUid = sbp.ContractTypeCodeUid
		--	LEFT JOIN ListProcedure on ListProcedure.ProcedureUID = sbp.ProcedureUID
		--	INNER JOIN ViewSuperbillProcedure_IsVoid on ViewSuperbillProcedure_IsVoid.SuperbillProcedureUid = sbp.SuperbillProcedureUid  --added per bug 9450
		--	WHERE sbp.SuperbillUid = superbill.superbillUid AND /*--added per bug 9450*/ViewSuperbillProcedure_IsVoid.IsVoid = '0' AND 
		--		(ISNULL(ListContractTypeCode.Name,'') <> 'NF' AND ISNULL(ListContractTypeCode.ANSICode,'') <> 'NF') AND
		--			ISNULL(sbp.DontClaim, 0) = 0 ) 
		--AS VARCHAR(50)) AS [CLAIM!400!totalBill],  
	0 AS [CLAIM!400!totalBill],  -- Now calculated in AR_genXMLClaims_Proc
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd1.Code10, sbd1.Code9), '' ) ELSE NULLIF( sbd1.Code9, '' ) END AS [CLAIM!400!diag1],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd2.Code10, sbd2.Code9), '' ) ELSE NULLIF( sbd2.Code9, '' ) END AS [CLAIM!400!diag2],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd3.Code10, sbd3.Code9), '' ) ELSE NULLIF( sbd3.Code9, '' ) END AS [CLAIM!400!diag3],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd4.Code10, sbd4.Code9), '' ) ELSE NULLIF( sbd4.Code9, '' ) END AS [CLAIM!400!diag4],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd5.Code10, sbd5.Code9), '' ) ELSE NULLIF( sbd5.Code9, '' ) END AS [CLAIM!400!diag5],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd6.Code10, sbd6.Code9), '' ) ELSE NULLIF( sbd6.Code9, '' ) END AS [CLAIM!400!diag6],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd7.Code10, sbd7.Code9), '' ) ELSE NULLIF( sbd7.Code9, '' ) END AS [CLAIM!400!diag7],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd8.Code10, sbd8.Code9), '' ) ELSE NULLIF( sbd8.Code9, '' ) END AS [CLAIM!400!diag8],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd9.Code10, sbd9.Code9), '' ) ELSE NULLIF( sbd9.Code9, '' ) END AS [CLAIM!400!diag9],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd10.Code10, sbd10.Code9), '' ) ELSE NULLIF( sbd10.Code9, '' ) END AS [CLAIM!400!diag10],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd11.Code10, sbd11.Code9), '' ) ELSE NULLIF( sbd11.Code9, '' ) END AS [CLAIM!400!diag11],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd12.Code10, sbd12.Code9), '' ) ELSE NULLIF( sbd12.Code9, '' ) END AS [CLAIM!400!diag12],

  InsuranceCarrier.CorporationUid  AS [PAYER!230!ID!hide],  --InsuranceCarrier.CorporationUid  
  PersonInsurancePlan.InsurancePlanUid AS [PAYER!230!planType!hide],   --????payer.planType  
  Superbill.PatientUid    AS [PATIENT!300!PEID],  
  COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) AS [SUBSCRIBER!200!PEID],   
  COALESCE(AccountResponsibleParty.PersonUid, AccountResponsibleParty.CorporationUid)	AS  [RESPONSIBLEPARTY!240!ID!hide],				--Added by AW for 2010BC loop  2006 03 15
  COALESCE(AccountResponsibleParty.PersonUid, AccountResponsibleParty.CorporationUid)	AS  [RESPONSIBLEPARTY!240!PEID],				--Added by AW for 2010BC loop 2006 03 15  
  (CASE WHEN AccountInsurance.DisplayOrder = 1 THEN 'P'  
   WHEN AccountInsurance.DisplayOrder = 2 THEN 'S'  
        ELSE 'T' END)        AS [SUBSCRIBER!200!payerResponsibility],  
  AccountInsurance.DisplayOrder AS [SUBSCRIBER!200!DisplayOrder],
  ListRelationship.ANSICode      AS [PATIENT!300!patientRelationToInsured],    
  LTRIM(RTRIM((ISNULL(PersonInsurancePlan.PlanMemberID, '') + ISNULL(AccountInsurance.policyNumberSuffix, '')))) AS [CLAIM!400!patientMemberID],  
  PersonInsurancePlan.PlanGroupID    AS [CLAIM!400!patientgroupID],  
  InsurancePlan.Name				 AS [CLAIM!400!patientgroupName], -- Added for AK Medicaid by Qatalys
  UPPER(LTRIM(RTRIM((ISNULL(PersonInsurancePlan.PlanMemberID, '') + ISNULL(AccountInsurance.policyNumberSuffix, ''))))) AS [CLAIM!400!subscriberMemberID],  
  PersonInsurancePlan.AuthorizeAssignment   AS [CLAIM!400!authorizeAssignment],  
  LOWER(ViewSuperbillFinancialDetails.ClaimingProviderUid)     AS [RENDERER!410!ID!hide],  --2011 change
  ViewSuperbillFinancialDetails.ClaimingProviderUid      AS [RENDERER!410!PEID],			--2011 change
  ub.SupervisingProviderUid      AS [SUPERVISING!415!PID],	
  Superbill.OrderingProviderUid		 AS [ORDERING!425!PID],
  ViewSuperbillFinancialDetails.FinancialCenterUid	AS [BILLINGPROVIDER!120!FCID], --2011 change
  CASE WHEN ( ecf.IsIndividual=1 )
       THEN 0	   
	   ELSE 1	END AS [BILLINGPROVIDER!120!FileAsGroup], --2011 change

  COALESCE(pc.ReferredByProviderUid, superbill.referringProviderUid)     AS [REFERRER!420!PID],  --2011 change 
  dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid,  
      0,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerID],  
 
  dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,1,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerIDType],  
  
dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,CASE WHEN ( ecf.IsIndividual =1 )THEN 0 ELSE 2 END,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerGroupID],  
 
 dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,CASE WHEN ( ecf.IsIndividual=1) THEN 1 ELSE 3 END ,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerGroupIDType],  

dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,CASE WHEN (ecf.IsIndividual=1) THEN 0 ELSE 18 END,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerGroupID2],  
 
 dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,CASE WHEN (ecf.IsIndividual=1)
       THEN 1 ELSE 19 END ,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerGroupIDType2],  
 CASE WHEN lcf.SendNPI = 1 
      THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '')
	  ELSE '' END AS [CLAIM!400!facilityPrimaryID],

 CASE WHEN lcf.SendNPI = 1 THEN 'XX' ELSE '' END [CLAIM!400!facilityPrimaryIDType],
 
  -- Bug 33171 - Removed call to dbo.stripSpecialChars
 dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,6,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!facilityID],  
 
 dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,7,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!facilityIDType],  
  
  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @PayToProviderNPIUid
				ELSE @ServiceSiteNPIUid END ,0,NULL, NULL,ViewSuperbillFinancialDetails.ServiceSiteUid, NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' 
		THEN  'XX' 
		WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' 
		THEN  '24'  
		ELSE  '34'  END)     AS [PAYTOPROVIDER!130!IDType],  
  
  (CASE WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @PayToProviderNPIUid
				ELSE @ServiceSiteNPIUid END,0,NULL, NULL,ViewSuperbillFinancialDetails.ServiceSiteUid, NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
			dbo.UDF_getFormatVaribleValue (0, CASE WHEN  (ecf.IsIndividual=1 ) THEN @PayToProviderNPIUid
				ELSE @ServiceSiteNPIUid END,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid, NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
		WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
			dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
		WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
			dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
		ELSE	
			COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'')
  END)	AS [PAYTOPROVIDER!130!ID],  
 
  (CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
        THEN 'EI'
		ELSE ''
	    END)	AS [PAYTOPROVIDER!130!NPISecIDType],

  (CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
        THEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
		ELSE ''
		END)	AS [PAYTOPROVIDER!130!NPISecID],

  CASE WHEN lcf.SendNPI = 1 THEN		
		--CYS SC 07/23/09 - Added logic for Service Site NPI Overrides
		(CASE WHEN COALESCE(ecf.NPIOverrideFixedValue,
						    NULLIF( dbo.UDF_getFormatVaribleValue (0, ecf.NPIOverrideUid,0,NULL,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), ''),
						    '') <> '' 
			  THEN 'XX'
		ELSE
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN  
					'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN  
					'24'  
				WHEN (ecf.IsIndividual=1) THEN 
					'34'
				ELSE ''
			 END)  
		END)	--ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN  
				'24'  
			WHEN (ecf.IsIndividual=1) THEN 
				'34'
			ELSE ''
	      END)
	END	   
	AS [BILLINGPROVIDER!120!IDType],  
  
	CASE WHEN lcf.SendNPI = 1 THEN
		--CYS SC 07/23/09 - Added logic for Service Site NPI Overrides
		(CASE WHEN COALESCE(ecf.NPIOverrideFixedValue,
						    NULLIF( dbo.UDF_getFormatVaribleValue (0, ecf.NPIOverrideUid,0,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), ''),
						    '') <> '' 
			  THEN COALESCE(ecf.NPIOverrideFixedValue,
						    NULLIF( dbo.UDF_getFormatVaribleValue (0, ecf.NPIOverrideUid,0,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), ''),
						    '')
			ELSE 
			--CYS SC 07/23/09 - Service Site NPI Override - END
			  (CASE	  --DEFECT #9657
				WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid
						ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
				WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
						ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
				WHEN (ecf.IsIndividual=1) THEN 
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
							dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
						ELSE COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
				ELSE ''

		END) 
	  END) --ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
			WHEN (ecf.IsIndividual=1) THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
					ELSE	
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
			ELSE ''
		  END)
	END AS [BILLINGPROVIDER!120!ID],
	 
   CASE WHEN (lcf.SendNPI = 1 AND ecf.filingTypeSSN = 1 ) -- SendNPI AND use SSN
	    THEN
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0,
															 CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid ELSE @FinancialCenterNPIUid END,
															 0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' 
				THEN  ''
				WHEN dbo.UDF_getFormatVaribleValue (0, 
													CASE WHEN (ecf.IsIndividual=1) THEN @SSNUid ELSE @FinancialCenterEINUid END,
													0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
				THEN 'SY'
				ELSE ''
			END)	
	    WHEN (lcf.SendNPI = 1)							  -- SendNPI AND USE EIN ( DEFAULT )
	    THEN 
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, 
															 CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid ELSE @FinancialCenterNPIUid END,
															 0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' 
				THEN  ''
				WHEN dbo.UDF_getFormatVaribleValue (0, 
													CASE WHEN (ecf.IsIndividual=1) THEN @EINUid ELSE @FinancialCenterEINUid END,
													0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
				THEN 'EI'
				WHEN (ecf.IsIndividual=1) 
				THEN 'SY'
				ELSE ''
			END)	
	    ELSE ''
	END	AS [BILLINGPROVIDER!120!NPISecIDType],


   CASE 
        WHEN (lcf.SendNPI = 1 AND ecf.filingTypeSSN = 1) -- SendNPI AND USE SSN
        THEN 
		  --DEFECT #9657
		  (CASE WHEN (ecf.IsIndividual=1) 
				THEN 
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
						 THEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 				
						 ELSE COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
				ELSE
					''
			END)
        WHEN lcf.SendNPI = 1 -- SendNPI AND USE EIN ( DEFAULT )
        THEN 
	  --DEFECT #9657
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, 
	                                                     CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid ELSE @FinancialCenterNPIUid END,
														 0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' 
			THEN  ''
			WHEN dbo.UDF_getFormatVaribleValue (0, 
			                                    CASE WHEN (ecf.IsIndividual=1) THEN @EINUid ELSE @FinancialCenterEINUid END,
			                                    0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
			THEN dbo.UDF_getFormatVaribleValue (0, 
										        CASE WHEN (ecf.IsIndividual=1) THEN @EINUid ELSE @FinancialCenterEINUid END,
			                                    0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 					
			WHEN (ecf.IsIndividual=1) -- EIN not found so try SSN
			THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
					 THEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 				
					 ELSE COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
			ELSE
				''
		END)
	ELSE ''
	END	AS [BILLINGPROVIDER!120!NPISecID],

  (CASE WHEN superbill.emergency = 1 THEN  'Y' ELSE  ''  END)        AS [PROC!450!emergency],  
   1      AS [CLAIM!400!claimFrequencyCode],  
'Y'    AS [CLAIM!400!providerSignatureOnFile],  
  
  -- CLM08  
  (CASE WHEN PersonInsurancePlan.AuthorizeAssignment = 1 THEN  
   'Y'  
   ELSE  
   'N'  
  END)        AS [CLAIM!400!patientAcceptAssignment],  
		(CASE WHEN 1 = 1 -- JW 1/16/06 In GA4 we're going to assume the box is always check use this logic.
              THEN  'Y'  
              ELSE  '' --N  
			END)        AS [CLAIM!400!releaseOfInformation],  
  (CASE WHEN PersonInsurancePlan.AuthorizeAssignment = 1 THEN 'B' ELSE 'S' END) AS  [CLAIM!400!patientSignatureSource],
  CONVERT(VARCHAR,superbill.ServiceDateStart,101)   AS [CLAIM!400!patientSignatureDate],  
  ListServiceSiteType.ANSICode      AS [CLAIM!400!siteType],  
  ListRelatedCause.ANSICode     AS [CLAIM!400!relatedCausesCode],  
  superbill.RelatedCauseState     AS [CLAIM!400!accidentState],    
  ISNULL(superbill.RelatedCauseDate, superbill.OnsetDate)  AS [CLAIM!400!accidentDate],  
  superbill.onsetDate       AS [CLAIM!400!onsetCurrentDate],  
  superbill.onsetFirstDate      AS [CLAIM!400!onsetFirstDate],
  NULL AS [CLAIM!400!onsetFirstDateQualifier],  
  superbill.noWorkFromDate     AS [CLAIM!400!noWorkFromDate],  
  superbill.noWorkToDate      AS [CLAIM!400!noWorkToDate],  
  superbill.HospitalizationStartDate     AS [CLAIM!400!hospitalizationStartDate],  
  superbill.HospitalizationEndDate     AS [CLAIM!400!hospitalizationEndDate],  
  superbill.InitialTreatmentDate     AS [CLAIM!400!InitialTreatmentDate],
  superbill.EPSDT       AS [CLAIM!400!familyPlan],  
  ISNULL(CONVERT(VARCHAR(80),superbill.ClaimNote), '')		AS [CLAIM!400!ClaimNote], -- Add for AK Medicaid by Qatalys
  ISNULL(CONVERT(VARCHAR(80),superbill.ClaimNote), '')          AS [CLAIM!400!Note], -- Igor 9/29/09 per 2517 had to add this so that AK Medicaid code will not be broken
  listclaimheadernotecode.ANSICode      AS [CLAIM!400!NoteReferenceCode], -- 2517 added 9/28/09	  
 CASE WHEN Superbillaggregate.CurrentCarrier = 1 THEN COALESCE(superbill.PriorAuthorizationCode, '')						-- Primary
	     WHEN Superbillaggregate.CurrentCarrier = 2 THEN COALESCE(superbill.PriorAuthorizationCode_InsuranceCarrier2, '')		-- Secondary
	     WHEN Superbillaggregate.CurrentCarrier = 3 THEN COALESCE(superbill.PriorAuthorizationCode_InsuranceCarrier3, '')		-- Tertiary
	     ELSE '' END AS [CLAIM!400!priorAuthorizationCode],
  lcf.SendNPI AS [CLAIM!400!SendNPI],
  lcf.Dmerc AS [CLAIM!400!Dmerc],	
  lcf.SendPQRIproc	AS [CLAIM!400!SendPQRIproc],
  lcf.Output2310D	AS [CLAIM!400!Output2310D], --bug 1420
  lcf.OutputAAE	AS [CLAIM!400!OutputAAE], --bug 5129
  lcf.BHTTypePR	AS [CLAIM!400!OutputPR],--added 5/9/2011
CONVERT(VARCHAR(50), cobcd.ICN) AS [CLAIM!400!ICN], --ADDED ICN NUMBER REPORTDED IN LOOP 2300 6/19/08
  superbill.EPSDT       AS [CLAIM!400!EPSDT], --ADDED 07/21/09 bug 1430
  lepsdt1.ExternalID as EPSDTReferralCondIndicator1 ,--ADDED 07/21/09 bug 1430
  lepsdt2.ExternalID as EPSDTReferralCondIndicator2 ,--ADDED 07/21/09 bug 1430
  lepsdt3.ExternalID as EPSDTReferralCondIndicator3 ,--ADDED 07/21/09 bug 1430
  lepsdt4.ExternalID as EPSDTReferralCondIndicator4 ,--ADDED 07/21/09 bug 1430
  lmsrc.ANSICode AS [CLAIM!400!InsuranceTypeCode],
  (CASE WHEN superbill.AuthReferralIndicator = 1 THEN 'G1' ELSE '9F' END)        AS [CLAIM!400!AuthReferralIndicator],  --bug 2570	
  '' AS [CLAIM!400!BillingProvider_IDType],   
  '' AS [CLAIM!400!BillingProvider_ID],		
  superbill.LMPDate       AS [CLAIM!400!LMPDate], 
  convert(varchar(MAX),superbill.UserDefinedXml)        AS  [CLAIM!400!UserDefinedXml], -- Previously 300 rather than MAX
  superbill.ResubmissionCode AS [CLAIM!400!ResubmissionCode],
  ldr.ANSICode  AS [CLAIM!400!DelayReasonCode] , --869
  superbill.DateLastSeenBySupervising AS [CLAIM!400!DateLastSeenBySupervising] ,--249
  dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, ecf.ElectronicClaimFormatUid,18,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid))
      AS [CLAIM!400!SecPayerID],
 
dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, ecf.ElectronicClaimFormatUid,19,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid))      
AS [CLAIM!400!SecPayerCode],
  ub.AssumedDate AS   [CLAIM!400!AssumedDate],
  ub.RelinquishedDate AS   [CLAIM!400!RelinquishedDate],      
  (Case WHEN ( pis.Value IS NOT NULL AND pis.Value like '%17667(True)%') THEN vsa.UnAssignedDistribution ELSE NULL END) AS [CLAIM!400!PatientPaidAmount], -- See bug 17667
  ViewSuperbillFinancialDetails.serviceSiteUID      AS [SERVICEFACILITY!430!PID],  
  ListServiceSiteType.ANSICode     AS [PROC!450!serviceLocation],  
  Superbill.ExternalID	AS [PROC!450!lineControlNo],
  CASE WHEN PersonInsurancePlan.PersonUid IS NOT NULL THEN 0  
       WHEN PersonInsurancePlan.CorporationUid IS NOT NULL THEN 1 END AS [SUBSCRIBER!200!isWCC] ,
  CASE WHEN AccountResponsibleParty.PersonUid IS NOT NULL THEN 0  
       WHEN AccountResponsibleParty.CorporationUid IS NOT NULL THEN 1 END AS [RESPONSIBLEPARTY!240!isCorporation],  	--Added by AW for 2010BC loop  2006 03 15  
  ViewSuperbillFinancialDetails.FinancialCenterUid   AS  [FINANCIALCENTER!105!FCID],
  account.AccountUid AS [CLAIM!400!AccountID],
  account.Name AS [CLAIM!400!AccountName],
  SuperbillAggregate.AccountPeriodUid AS [CLAIM!400!AccountPeriodID],
  SUBSTRING(ISNULL( lpt.ANSICode, ''),1,2) as [CLAIM!400!PaperworkTypeID],
  SUBSTRING(ISNULL( lptc.ANSICode, ''),1,2) as [CLAIM!400!PaperworkTransmissionCodeID],
  SUBSTRING(ISNULL( superbill.PaperworkControlNum, ''),1,50)  as [CLAIM!400!PaperworkControlNum],
  0 as [CLAIM!400!Allow5010Codes],
  CASE WHEN InsuranceCarrier.ICD10Date <= Superbill.ServiceDateStart THEN 1 ELSE 0 END AS [CLAIM!400!UseICD10],
  ecf.[ElectronicClaimFormatUid] AS [CLAIM!400!ElectronicClaimFormatUid]
 FROM #XMLClaims_temp  
  INNER JOIN ClaimBatch WITH (NOLOCK) ON ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
  INNER JOIN ClaimBatchDetail WITH (NOLOCK) ON ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid   
  INNER JOIN superbill WITH (NOLOCK) on superbill.SuperbillUid = ClaimBatchDetail.SuperbillUid --2011 change 
  INNER JOIN SuperbillAggregate WITH (NOLOCK) ON superbill.SuperbillUid = SuperbillAggregate.SuperbillUid  
  INNER JOIN  ViewSuperbillFinancialDetails ON ViewSuperbillFinancialDetails.superbillUid = superbill.SuperbillUid and superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
  INNER JOIN account WITH (NOLOCK) ON account.accountUid = superbill.accountUid  
  INNER JOIN AccountResponsibleParty WITH (NOLOCK) ON Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
  INNER JOIN AccountPeriod WITH (NOLOCK) ON AccountPeriod.AccountPeriodUid = SuperbillAggregate.AccountPeriodUid 
  INNER JOIN AccountInsurance WITH (NOLOCK)  ON AccountInsurance.AccountPeriodUid = SuperbillAggregate.AccountPeriodUid -- AccountPeriod.AccountPeriodUid 
											AND SuperbillAggregate.CurrentCarrier = AccountInsurance.DisplayOrder   
  INNER JOIN PersonInsurancePlan WITH (NOLOCK) ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
											--AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
  INNER JOIN InsurancePlan WITH (NOLOCK) ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
  INNER JOIN InsuranceCarrier WITH (NOLOCK) ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  
  INNER JOIN AR_ViewSuperbillAggregate vsa WITH (NOLOCK) ON Superbill.SuperbillUid = vsa.SuperbillUid 	
  LEFT JOIN ListClaimFormat lcf WITH (NOLOCK) ON lcf.ClaimFormatUid = (CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 
															  THEN InsuranceCarrier.ElectronicClaimFormatUid
														  ELSE InsurancePlan.ElectronicClaimFormatUid END)	
  INNER JOIN @ecf ecf ON Superbill.SuperbillUid = ecf.SuperbillUid
  -- THIS WILL BE SENT AS THE CLAIM RENDERING PROVIDER  
  INNER JOIN provider WITH (NOLOCK) ON provider.PersonUID = ViewSuperbillFinancialDetails.ClaimingProviderUid    --We have to use RenderingProviderUid  :Aji 2005 10 21  
  INNER JOIN Person WITH (NOLOCK) ON Person.PersonUid = Provider.PersonUid  
  INNER JOIN ListServiceSite WITH (NOLOCK) ON  ListServiceSite.serviceSiteUID = ViewSuperbillFinancialDetails.serviceSiteUID   
  LEFT JOIN ListServiceSiteType ListServiceSiteType WITH (NOLOCK) ON ListServiceSiteType.ServiceSiteTypeUid = ListServiceSite.ServiceSiteTypeUid  
  LEFT JOIN ListRelationship ListRelationship WITH (NOLOCK) ON ListRelationship.RelationshipUid = AccountInsurance.RelationshipUid   
  LEFT JOIN ListRelatedCause ListRelatedCause WITH (NOLOCK) ON ListRelatedCause.RelatedCauseUid = superbill.RelatedCauseUid   
  INNER JOIN ListSuperBillStatus WITH (NOLOCK) ON Superbill.SuperbillStatusUid  = ListSuperBillStatus.SuperbillStatusUid  
  LEFT JOIN SuperbillDiagnosis sbd1 WITH (NOLOCK) ON sbd1.SuperBillUid = superbill.superbillUid AND sbd1.DisplayOrder =1  
  LEFT JOIN SuperbillDiagnosis sbd2 WITH (NOLOCK) ON sbd2.SuperBillUid = superbill.superbillUid AND sbd2.DisplayOrder =2  
  LEFT JOIN SuperbillDiagnosis sbd3 WITH (NOLOCK) ON sbd3.SuperBillUid = superbill.superbillUid AND sbd3.DisplayOrder =3  
LEFT JOIN SuperbillDiagnosis sbd4 WITH (NOLOCK) ON sbd4.SuperBillUid = superbill.superbillUid AND sbd4.DisplayOrder =4  
  LEFT JOIN SuperbillDiagnosis sbd5 WITH (NOLOCK) ON sbd5.SuperBillUid = superbill.superbillUid AND sbd5.DisplayOrder =5    
  LEFT JOIN SuperbillDiagnosis sbd6 WITH (NOLOCK) ON sbd6.SuperBillUid = superbill.superbillUid AND sbd6.DisplayOrder =6  
LEFT JOIN SuperbillDiagnosis sbd7 WITH (NOLOCK) ON sbd7.SuperBillUid = superbill.superbillUid AND sbd7.DisplayOrder =7  
  LEFT JOIN SuperbillDiagnosis sbd8 WITH (NOLOCK) ON sbd8.SuperBillUid = superbill.superbillUid AND sbd8.DisplayOrder =8  
  LEFT JOIN SuperbillDiagnosis sbd9 WITH (NOLOCK) ON sbd9.SuperBillUid = superbill.superbillUid AND sbd9.DisplayOrder =9  
  LEFT JOIN SuperbillDiagnosis sbd10 WITH (NOLOCK) ON sbd10.SuperBillUid = superbill.superbillUid AND sbd10.DisplayOrder =10  
  LEFT JOIN SuperbillDiagnosis sbd11 WITH (NOLOCK) ON sbd11.SuperBillUid = superbill.superbillUid AND sbd11.DisplayOrder =11  
  LEFT JOIN SuperbillDiagnosis sbd12 WITH (NOLOCK) ON sbd12.SuperBillUid = superbill.superbillUid AND sbd12.DisplayOrder =12  
  --LEFT JOIN ListDiagnosis Ld1 ON Ld1.DiagnosisUid = sbd1.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld2 ON Ld2.DiagnosisUid = sbd2.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld3 ON Ld3.DiagnosisUid = sbd3.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld4 ON Ld4.DiagnosisUid = sbd4.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld5 ON Ld5.DiagnosisUid = sbd5.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld6 ON Ld6.DiagnosisUid = sbd6.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld7 ON Ld7.DiagnosisUid = sbd7.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld8 ON Ld8.DiagnosisUid = sbd8.DiagnosisUid  
  LEFT JOIN COBClaimDetail  cobcd WITH (NOLOCK) ON cobcd.SuperBillUid = superbill.superbillUid AND cobcd.InsuranceOrder = AccountInsurance.DisplayOrder
  INNER JOIN Patient WITH (NOLOCK) ON Patient.PersonUid = Superbill.PatientUid  
  LEFT JOIN ListSignatureSource WITH (NOLOCK) ON Patient.SignatureSourceUid = ListSignatureSource.SignatureSourceUid  
  LEFT JOIN ViewSuperbillCurrentLiabilityOwnerAndCarrier WITH (NOLOCK) ON superbill.superbillUid = ViewSuperbillCurrentLiabilityOwnerAndCarrier.superbillUid
  LEFT JOIN listmedicaresecondaryreasoncode lmsrc WITH (NOLOCK) on lmsrc.MedicareSecondaryReasonCodeUID = Accountperiod.MedicareSecondaryReasonCodeUID
  LEFT JOIN ListDelayReason ldr WITH (NOLOCK) on ldr.DelayReasonUid = superbill.DelayReasonUid --869
  LEFT JOIN ListEPSDTReferralCondIndicator lepsdt1 WITH (NOLOCK) on lepsdt1.EPSDTReferralCondIndicatorUid = superbill.EPSDTReferralCondIndicator1Uid -- addd 07/21/09 bug 1430
  LEFT JOIN ListEPSDTReferralCondIndicator lepsdt2 WITH (NOLOCK) on lepsdt2.EPSDTReferralCondIndicatorUid = superbill.EPSDTReferralCondIndicator2Uid -- addd 07/21/09 bug 1430
  LEFT JOIN ListEPSDTReferralCondIndicator lepsdt3 WITH (NOLOCK) on lepsdt3.EPSDTReferralCondIndicatorUid = superbill.EPSDTReferralCondIndicator3Uid -- addd 07/21/09 bug 1430
  LEFT JOIN ListEPSDTReferralCondIndicator lepsdt4 WITH (NOLOCK) on lepsdt4.EPSDTReferralCondIndicatorUid = superbill.EPSDTReferralCondIndicator4Uid -- addd 07/21/09 bug 1430
  LEFT JOIN listclaimheadernotecode WITH (NOLOCK) on listclaimheadernotecode.claimheadernotecodeuid = superbill.claimheadernotecodeuid----2517
  LEFT JOIN PatientCase pc WITH (NOLOCK) on superbill.PatientCaseUid = pc.PatientCaseUid
  LEFT OUTER JOIN PlugInSettings pis WITH (NOLOCK) on ClaimBatch.ClaimClearingHouseUid = pis.ClaimClearingHouseUid AND pis.Name = 'SpecialCase'
LEFT OUTER JOIN SuperbillUB ub WITH (NOLOCK) ON ub.SuperbillUid = superbill.SuperbillUid  
  LEFT OUTER JOIN ListPaperworkType lpt with (nolock) on Superbill.PaperworkTypeUid = lpt.PaperworkTypeUid
  LEFT OUTER JOIN ListPaperworkTransmissionCode lptc with (nolock) on Superbill.PaperworkTransmissionCodeUid = lptc.PaperworkTransmissionCodeUid
 WHERE  
  #XMLClaims_temp.tag = 100  --and AccountInsurance.DisplayOrder = ViewSuperbillCurrentLiabilityOwnerAndCarrier.CurrentCarrier-- this will make sure that we select current carrier when primary and secondary are the same
  
 SET @claimsFetched = @@ROWCOUNT

	--CYS SC 07/23/09 - Added for Service Site bug (CYS Case #22420)
	UPDATE #XMLClaims_temp SET 
		[CLAIM!400!BillingProvider_IDType] = [BILLINGPROVIDER!120!IDType],
		[CLAIM!400!BillingProvider_ID] = [BILLINGPROVIDER!120!ID]
	WHERE tag = 400 ;

  -- Move primaryIC search to seperate query because it was causing excess reads 
  UPDATE #XMLClaims_temp
  SET #XMLClaims_temp.[CLAIM!400!providerAcceptAssignment] = -- CLM07
	  (CASE WHEN sb.UsePrimaryPayerAcceptAssignment = 1 
			THEN ( CASE WHEN primaryIC.AcceptAssignment = 1        THEN 'A'	-- Assigned
						WHEN primaryIC.AcceptAssignmentLabOnly = 1 THEN 'B'	-- Lab Only
						ELSE 'C' END )										-- Not Assigned
			ELSE
				( CASE WHEN sb.AcceptAssignment = 1		   THEN 'A'	-- Assigned  
						WHEN sb.AcceptAssignmentLabOnly = 1 THEN 'B'	-- Lab Only
						ELSE 'C' end )										-- Not Assigned
		END)           
  FROM #XMLClaims_temp 
		INNER JOIN Superbill sb with (NOLOCK) ON #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid 
		INNER JOIN SuperbillAggregate sba WITH (NOLOCK) ON sb.SuperbillUid = sba.SuperbillUid
		INNER JOIN AccountInsurance primaryAI WITH (NOLOCK) ON primaryAI.AccountPeriodUid = sba.AccountPeriodUid AND primaryAI.DisplayOrder = 1
		INNER JOIN PersonInsurancePlan primaryPIP WITH (NOLOCK) ON primaryAI.PersonInsurancePlanUid = primaryPIP.PersonInsurancePlanUid 
		INNER JOIN InsurancePlan primaryIP WITH (NOLOCK) ON primaryPIP.InsurancePlanUid = primaryIP.InsurancePlanUid
		INNER JOIN InsuranceCarrier primaryIC WITH (NOLOCK) ON primaryIP.InsuranceCarrierUid = primaryIC.CorporationUid
  WHERE #XMLClaims_temp.tag = 400
		AND primaryAI.DisplayOrder = 1

  -- Set "switch" to allow some 5010 functionality to go into 4010
  --    -  SBR05 ( 2320 ) - allow InsuranceTypeCode values
  UPDATE #XMLClaims_temp
  SET [CLAIM!400!Allow5010Codes] = CASE WHEN NULLIF(pis.Value, '0') IS NULL THEN 0 ELSE 1 END
  FROM #XMLClaims_temp
		INNER JOIN ClaimBatch WITH (NOLOCK) ON ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
		INNER JOIN PlugInSettings pis WITH (NOLOCK) ON ClaimBatch.ClaimClearingHouseUid = pis.ClaimClearingHouseUid AND pis.Name = 'Allow5010CodesIn4010'
  WHERE  #XMLClaims_temp.tag = 400 

  -- Bug 31476: EDI Requirements for Health Net payer Encounter
  DECLARE @moopClaims TABLE ( superbillUid UNIQUEIDENTIFIER, InsuranceOrder int ) ;
  INSERT INTO @moopClaims( superbillUid, InsuranceOrder )
  	SELECT #XMLClaims_temp.[CLAIM!400!PID] as superbillUid,
		   cb.InsuranceOrder as InsuranceOrder
	FROM #XMLClaims_temp
			INNER JOIN ClaimBatchDetail cbd with (nolock) on #XMLClaims_temp.[CLAIM!400!PID] = cbd.SuperbillUid
															and #XMLClaims_temp.[SITE!100!eClaimBatchGUID] = cbd.ClaimBatchUid
			INNER JOIN ClaimBatch cb with (nolock) on cbd.ClaimBatchUid = cb.ClaimBatchUid
			INNER JOIN SuperbillAggregate sba WITH (NOLOCK) ON cbd.SuperbillUid = sba.SuperbillUid  
			INNER JOIN AccountInsurance  ai WITH (NOLOCK) ON ai.AccountPeriodUid = sba.AccountPeriodUid --ap.AccountPeriodUid 
																AND sba.CurrentCarrier = ai.DisplayOrder   
			INNER JOIN PersonInsurancePlan pip WITH (NOLOCK) ON pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid  
			INNER JOIN InsurancePlan ip WITH (NOLOCK) ON pip.InsurancePlanUid = ip.InsurancePlanUid  
			INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ic.CorporationUid = ip.InsuranceCarrierUid 
																AND UPPER(ic.Notes) like '%MOOP_PATIENTPAIDAMOUNT_SUMPR%'
	WHERE #XMLClaims_temp.tag = 400 -- for each claim

  IF EXISTS ( SELECT * FROM @moopClaims )
  BEGIN		
	;with myCTE2 AS
	(
	SELECT mpc.superbillUid as superbillUid, SUM(cobl.Amount) as Amount
	FROM  @moopClaims mpc
			INNER JOIN COBClaimDetail cobd with (nolock) on mpc.superbillUid = cobd.SuperbillUid
																AND mpc.InsuranceOrder > cobd.InsuranceOrder -- assuming we want sum of all previous insurance
			INNER JOIN COBLineAdjustments cobl with (nolock) on cobd.COBClaimDetailUid = cobl.COBClaimDetailUid
			INNER JOIN ListERACode lec with (nolock) on cobl.GroupCodeERACodeUid = lec.ERACodeUid
		WHERE lec.Code = 'PR'		-- only PR codes
		GROUP BY mpc.superbillUid
	)
	Update #XMLClaims_temp
		SET [CLAIM!400!PatientPaidAmount] = CASE WHEN mc.Amount IS NULL THEN 0 ELSE -mc.Amount END
		FROM #XMLClaims_temp
			LEFT OUTER JOIN myCTE2 mc on mc.superbillUid = #XMLClaims_temp.[CLAIM!400!PID]
		WHERE #XMLClaims_temp.tag = 400   
  END

  -- CHC DSW 60093
Update #XMLClaims_temp
	Set [CLAIM!400!ChcBillingType] = cap.BillingType
FROM #XMLClaims_temp 
		INNER JOIN Superbill sb with (nolock) on #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid
		inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid= sba.SuperbillUid
		INNER JOIN ChcInsurancePlan cip with (nolock) on sba.CurrentInsurancePlanUid = cip.InsurancePlanUid
		INNER JOIN ChcListApprovalSetting cas with (nolock) on cip.ApprovalSettingUid = cas.ApprovalSettingUid
		INNER JOIN ChcApprovalPeriod cap with (nolock) on cas.ApprovalSettingUid = cap.ApprovalSettingUid
															AND (cap.EffectiveDate IS NULL OR sb.ServiceDateStart >= cap.EffectiveDate )
															AND (cap.ExpirationDate	IS NULL OR sb.ServiceDateStart <= cap.ExpirationDate )
WHERE #XMLClaims_temp.tag = 400


-- 11329, Acute Manifestation Date qualifier is not generating/transmitting in 837P in Loop 2300 DTP03 (453)
Update #XMLClaims_temp
  SET [CLAIM!400!onsetFirstDateQualifier] = lcfvt.ExternalId
  FROM #XMLClaims_temp
		INNER JOIN Superbill sb with (nolock) on #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid
		INNER JOIN ListClaimFormatValueType lcfvt On sb.OnsetFirstQualifierUid = lcfvt.ClaimFormatValueTypeUid



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_FINANCIALCENTER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_FINANCIALCENTER] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_FINANCIALCENTER]
AS

	/* Need to retrieve claim format for specific insurance on superbill */
	DECLARE @ClaimFormatUid uniqueidentifier
	SET @ClaimFormatUid = null;
	;with thisClaim
	as
	(
		select top 1 xt.[SITE!100!eClaimBatchGUID] AS batchGuid
		from #XMLClaims_temp xt
		where xt.[SITE!100!eClaimBatchGUID] IS NOT NULL
	)
	select @ClaimFormatUid = CASE IP.UseCarrierElectronicClaimFormat 
			WHEN 1 THEN IC.ElectronicClaimFormatUId
			ELSE IP.ElectronicClaimFormatUId END
			--@FinancialCenterUid = sba.FinancialCenterUid 
	from --ClaimBatch cb
		--	inner join ClaimBatchDetail cbd on cb.ClaimBatchUid = cbd.ClaimBatchUid
		 ClaimBatchDetail cbd 
			inner join thisClaim tc on cbd.ClaimBatchUid = tc.batchGuid
			inner join Superbill sb on cbd.SuperbillUid = sb.SuperbillUid
			inner join SuperbillAggregate sba on sb.SuperbillUid = sba.SuperbillUid -- Need current insurance liability owner
			inner join AccountPeriod ap on sb.AccountUid = ap.AccountUid
											AND (ap.EffectiveDate IS NULL OR (ap.EffectiveDate <= sb.ServiceDateStart) )
											AND (ap.ExpirationDate IS NULL OR (ap.ExpirationDate >= sb.ServiceDateStart) )
			inner join AccountInsurance ai on ap.AccountPeriodUid = ai.AccountPeriodUid
												and ai.DisplayOrder = 
														coalesce( sba.CurrentCarrier, sb.CurrentCarrierOverride, 1 ) 
														-- Order of preference
														-- 1) Current Carrier from aggregate
														-- 2) Superbill liability owner flag
														-- 3) Primary ( last resort )
			inner join PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			inner join InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
			inner join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
				
	-- Submitter ID 
	DECLARE @submitterIDClaimFormatValueTypeUid UNIQUEIDENTIFIER
	SET @submitterIDClaimFormatValueTypeUid = null
	select @submitterIDClaimFormatValueTypeUid=lcfvt.ClaimFormatValueTypeUid--, lcfvt.*
	from ListClaimFormatOptionType lcfot
			inner join ListClaimFormatType lcft on lcfot.ClaimFormatTypeUid = lcft.ClaimFormatTypeUid
			inner join ClaimFormatOption cfo on lcfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			inner join ListClaimFormat lcf on cfo.ClaimFormatUid = lcf.ClaimFormatUid
			inner join ListClaimFormatValueType lcfvt on cfo.ClaimFormatValueTypeUid = lcfvt.ClaimFormatValueTypeUid
	where lcfot.ClaimFormatOptionTypeUid = 'EC66D3D8-193B-416E-95B4-3A5DC1D088B4'		-- Submitter ID on electronic payer
			and cfo.ClaimFormatUid = @ClaimformatUid -- 'F43FD3CD-C30F-4CF3-A579-3759DA6441F0'				-- Claim Format ( i.e. e-Medicare )

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
    [FINANCIALCENTER!105!FCID],
    [FINANCIALCENTER!105!SubmitterID]

)
SELECT  DISTINCT 
    105 								    AS	Tag,
	100 								AS	parent,
	[SITE!100!PID]						AS	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS	[SITE!100!payToAddressID!hide],
    [FINANCIALCENTER!105!FCID]          AS  [FINANCIALCENTER!105!FCID],
   	dbo.UDF_getFormatVaribleValue(0, @submitterIDClaimFormatValueTypeUid, 0, NULL, NULL, NULL, NULL, [FINANCIALCENTER!105!FCID]) AS [FINANCIALCENTER!105!SubmitterID]   
FROM #XMLClaims_temp
WHERE
	#XMLClaims_temp.tag = 400

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PATIENT]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PATIENT] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_PATIENT]
AS

-- test
declare @scrubsubscriber int
set @scrubsubscriber = 0
select @scrubsubscriber = coalesce(lpp.IntegerValue,0) from ListProductParameter lpp
							where ParameterName = 'Scrub.Subscriber' 
-- end test

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[CLAIM!400!PID],
	[SUBSCRIBER!200!PEID],
	[PATIENT!300!PEID],
	[PATIENT!300!prefix],
	[PATIENT!300!LN],
	[PATIENT!300!FN],
	[PATIENT!300!MI],
	[PATIENT!300!suffix],
	[PATIENT!300!gender],
	[PATIENT!300!birthdate],
	[PATIENT!300!deathdate],
	[PATIENT!300!employer],
	[PATIENT!300!address1],
	[PATIENT!300!address2],
	[PATIENT!300!city],
	[PATIENT!300!state],
	[PATIENT!300!zip],
	[PATIENT!300!phoneNumber],
	[PATIENT!300!rIDType],
	[PATIENT!300!rID],
	[PATIENT!300!IDType],
	[PATIENT!300!ID],
	[PATIENT!300!patientRelationToInsured],
	[PAYER!230!ID!hide],					
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]
)
SELECT DISTINCT
	300 					AS tag,
	200 					AS parent,
	[SITE!100!PID]				AS  [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS  [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS  [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS  [SITE!100!payToAddressID!hide],

	[RENDERER!410!ID!hide]			AS  [RENDERER!410!ID!hide],
	[RENDERER!410!PEID] 			AS  [RENDERER!410!PEID],
	[CLAIM!400!PID]			AS  [CLAIM!400!PID],
	[SUBSCRIBER!200!PEID]		AS  [SUBSCRIBER!200!PEID],
	
	Person.PersonUid			AS  [PATIENT!300!PEID],		--[PATIENT!300!PEID]
	' '					AS  [PATIENT!300!prefix],		-- As Medicare is rejecting the claims because of Mr and Mrs. now we are using as blank
	UPPER(Person.LastName)		AS  [PATIENT!300!LN],
	UPPER(Person.FirstName)		AS  [PATIENT!300!FN],
	UPPER(Person.MiddleName)		AS  [PATIENT!300!MI],
	Person.Suffix				AS  [PATIENT!300!suffix],
	ListGender.ANSICode			AS  [PATIENT!300!gender],
	CONVERT(VARCHAR(10),Person.BirthDate,101)	AS  [PATIENT!300!birthdate],
	CONVERT(VARCHAR(10),Person.deathdate,101)	AS  [PATIENT!300!deathdate],
	Corporation.Name			AS  [PATIENT!300!employer],  
	Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') AS  [PATIENT!300!address1],
	Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') AS  [PATIENT!300!address2],
	Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') AS  [PATIENT!300!city],
	UPPER(Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')) AS  [PATIENT!300!state],
	Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [PATIENT!300!zip],
	dbo.stripSpecialChars(Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS  [PATIENT!300!phoneNumber],
	
	'SY'							AS  [PATIENT!300!rIDType],
	dbo.stripSpecialChars(Person.SocialSecurityNumber)	AS  [PATIENT!300!rID],
	'MI'							AS  [PATIENT!300!IDType],
	dbo.stripSpecialChars([CLAIM!400!patientMemberID])	AS  [PATIENT!300!ID],

	[PATIENT!300!patientRelationToInsured],
	[PAYER!230!ID!hide]					AS [PAYER!230!ID!hide],			-- added by Shweta
     [FINANCIALCENTER!105!FCID] AS  [FINANCIALCENTER!105!FCID], 
	#XMLClaims_temp.[CLAIM!400!AccountID] AS [CLAIM!400!AccountID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
		LEFT JOIN Person ON Person.PersonUid = #XMLClaims_temp.[PATIENT!300!PEID]
		LEFT JOIN ListGender ON Person.GenderUid = ListGender.GenderUid
		LEFT JOIN Employer ON Person.PersonUid = Employer.CorporationUid
		LEFT JOIN Corporation ON Employer.CorporationUid = Corporation.CorporationUid
WHERE
	#XMLClaims_temp.tag = 400
	AND #XMLClaims_temp.[PATIENT!300!PEID] <> #XMLClaims_temp.[SUBSCRIBER!200!PEID]
	AND (@scrubsubscriber = 0 OR #XMLCLaims_temp.[PATIENT!300!patientRelationToInsured] <> 18 )

--select * 
--from 
--#XMLClaims_temp




GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PAYER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PAYER] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_PAYER]
AS

/*
	Note: Here we are assuming that ClaimPayerID is unique for all carriers. This conclusion has been deducted from 
		the PS - Stored Procedure
*/

	/* Need to retrieve claim format for specific insurance on superbill */
	DECLARE @ClaimFormatUid uniqueidentifier
	--DECLARE @FinancialCenterUid uniqueidentifier
	DECLARE @taxonomyClaimFormatValueTypeUid uniqueidentifier
	DECLARE @submitterIDClaimFormatValueTypeUid uniqueidentifier
	
	SET @ClaimFormatUid = null;
	;with thisClaim
	as
	(
		select top 1 xt.[SITE!100!eClaimBatchGUID] AS batchGuid
		from #XMLClaims_temp xt
		where xt.[SITE!100!eClaimBatchGUID] IS NOT NULL
	)
	select @ClaimFormatUid = CASE IP.UseCarrierElectronicClaimFormat 
			WHEN 1 THEN IC.ElectronicClaimFormatUId
			ELSE IP.ElectronicClaimFormatUId END
	from  ClaimBatchDetail cbd 
			inner join thisClaim tc on cbd.ClaimBatchUid = tc.batchGuid
			inner join Superbill sb on cbd.SuperbillUid = sb.SuperbillUid
			inner join SuperbillAggregate sba on sb.SuperbillUid = sba.SuperbillUid -- Need current insurance liability owner
			inner join AccountPeriod ap on sb.AccountUid = ap.AccountUid
											AND (ap.EffectiveDate IS NULL OR (ap.EffectiveDate <= sb.ServiceDateStart) )
											AND (ap.ExpirationDate IS NULL OR (ap.ExpirationDate >= sb.ServiceDateStart) )
			inner join AccountInsurance ai on ap.AccountPeriodUid = ai.AccountPeriodUid
												and ai.DisplayOrder = 
														coalesce( sba.CurrentCarrier, sb.CurrentCarrierOverride, 1 ) 
														-- Order of preference
														-- 1) Current Carrier from aggregate
														-- 2) Superbill liability owner flag
														-- 3) Primary ( last resort )
			inner join PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			inner join InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
			inner join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
				
	--where cb.ClaimBatchUid = '64988181-5BF3-4DEA-BC65-77C5917F3898'
	SET @taxonomyClaimFormatValueTypeUid = null
	select @taxonomyClaimFormatValueTypeUid=lcfvt.ClaimFormatValueTypeUid--, lcfvt.*
	from ListClaimFormatOptionType lcfot
			inner join ListClaimFormatType lcft on lcfot.ClaimFormatTypeUid = lcft.ClaimFormatTypeUid
			inner join ClaimFormatOption cfo on lcfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			inner join ListClaimFormat lcf on cfo.ClaimFormatUid = lcf.ClaimFormatUid
			inner join ListClaimFormatValueType lcfvt on cfo.ClaimFormatValueTypeUid = lcfvt.ClaimFormatValueTypeUid
	where lcfot.ClaimFormatOptionTypeUid = '75FCD463-CDA2-46E9-8D12-DBAEFA9D953F'		-- Taxonomy Code for Professional
			and cfo.ClaimFormatUid = @ClaimformatUid -- 'F43FD3CD-C30F-4CF3-A579-3759DA6441F0'				-- Claim Format ( i.e. e-Medicare )
	-- Submitter ID 
	SET @submitterIDClaimFormatValueTypeUid = null
	select @submitterIDClaimFormatValueTypeUid=lcfvt.ClaimFormatValueTypeUid--, lcfvt.*
	from ListClaimFormatOptionType lcfot
			inner join ListClaimFormatType lcft on lcfot.ClaimFormatTypeUid = lcft.ClaimFormatTypeUid
			inner join ClaimFormatOption cfo on lcfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			inner join ListClaimFormat lcf on cfo.ClaimFormatUid = lcf.ClaimFormatUid
			inner join ListClaimFormatValueType lcfvt on cfo.ClaimFormatValueTypeUid = lcfvt.ClaimFormatValueTypeUid
	where lcfot.ClaimFormatOptionTypeUid = 'EC66D3D8-193B-416E-95B4-3A5DC1D088B4'		-- Submitter ID on electronic payer
			and cfo.ClaimFormatUid = @ClaimformatUid -- 'F43FD3CD-C30F-4CF3-A579-3759DA6441F0'				-- Claim Format ( i.e. e-Medicare )

	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide],
		[RENDERER!410!PEID],
		[SUBSCRIBER!200!PEID],
		[PAYER!230!ID!hide],
		[PAYER!230!CarrierID],
		[PAYER!230!planType],
		[PAYER!230!orgName],
		[PAYER!230!planName],
		[PAYER!230!address1],
		[PAYER!230!address2],
		[PAYER!230!city],
		[PAYER!230!state],
		[PAYER!230!zip],
		[PAYER!230!phone],
		[PAYER!230!capitated],
		[PAYER!230!acceptAssignment],
		[PAYER!230!Inactive],  --Added for Inactive Insurance Payer.
		[PAYER!230!codes] ,
		[PAYER!230!Mammcodes] ,--4974
		[PAYER!230!IDType],
		[PAYER!230!ID],
		[PAYER!230!elecPayerID],
		[PAYER!230!EPSDTCodes],--added 08/04/2009 for 1430
		[PAYER!230!PayerOrgID]	, --added 2418 9/29/09
		[PAYER!230!ClearingHouseName], --added 2418 9/29/09
		[PAYER!230!SuperiorMedicaid],--added 2418 and 2209 9/29/09
		[PAYER!230!TexasMedicaid], --added 2418 and 2209 9/29/09
		[PAYER!230!TaxonomyCode],  -- added for 13369, 13953 3/21/12
        [FINANCIALCENTER!105!FCID],
        [FINANCIALCENTER!105!SubmitterID],   
		[CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID] 
	)
	SELECT DISTINCT
		230 						AS tag,
		200 						AS parent,
		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID] 	AS [SUBSCRIBER!200!PEID],

		InsuranceCarrier.CorporationUid			AS [PAYER!230!ID!hide], --InsurancePlan.InsurancePlanUid
		InsuranceCarrier.CorporationUid			AS [PAYER!230!CarrierID],
		COALESCE (ListAccountType.ANSICode, '') AS [PAYER!230!planType],
		Corporation.Name				AS [PAYER!230!orgName],
		InsurancePlan.Name				AS [PAYER!230!planName],

		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!address1],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!address2],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!city],
		UPPER(CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		END) AS [PAYER!230!state],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!zip],
		dbo.stripSpecialChars(CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		ELSE
			InsurancePlan.Phone.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		END ) AS [PAYER!230!phone],

		InsurancePlan.IsCapitated			AS [PAYER!230!capitated],	

		(CASE WHEN InsuranceCarrier.AcceptAssignment = 1 THEN
			'A'
		ELSE
			'C'
		END)						AS [PAYER!230!acceptAssignment],
		--Added for Inactive Insurance Payer.
        InsuranceCarrier.Inactive  	AS [PAYER!230!Inactive],
		ISNULL(CAST(cfo.codes AS VARCHAR(50)),'')	 AS [PAYER!230!codes] ,
		ISNULL(CAST(cfo2.codes AS VARCHAR(50)),'')	[PAYER!230!Mammcodes] ,--4974
		'PI'						AS [PAYER!230!IDType],
		lep.ClearingHousePayerID 			AS [PAYER!230!ID],
		ISNULL(CAST(lep.ElectronicPayerUid AS VARCHAR(50)),'')			AS [PAYER!230!elecPayerID],
		--
		
		ISNULL(cfo1.Codes ,'')	 AS [PAYER!230!EPSDTCodes],
		lep.PayerOrgID 			AS [PAYER!230!PayerOrgID],--added 2418 9/29/09
		ListClaimClearinghouse.Name as [PAYER!230!ClearingHouseName],--added 2418 9/29/09
		--(CASE WHEN ListAccountType.ANSICode = 'MC'  AND (Corporation.Name LIKE '%Superior%') THEN '1' ELSE	'0' 	END) AS  [PAYER!230!SuperiorMedicaid],--added 2418 and 2209 9/29/09
		'0' AS  [PAYER!230!SuperiorMedicaid], --added 30369 07/24/2014

       --(CASE WHEN ListAccountType.ANSICode = 'MC' AND Corporation.[Address].value('(/Address/State)[1]', 'VARCHAR(2)') =  'TX'	THEN '1'	ELSE'0'	END) AS  [PAYER!230!TexasMedicaid],--added 2418 and 2209 9/29/09	
       '0' AS  [PAYER!230!TexasMedicaid],--added 30369 07/24/2014	
		dbo.UDF_getFormatVaribleValue(0, @taxonomyClaimFormatValueTypeUid, 0, NULL, NULL, NULL, NULL, [FINANCIALCENTER!105!FCID]) AS [PAYER!230!TaxonomyCode],
        [FINANCIALCENTER!105!FCID] AS   [FINANCIALCENTER!105!FCID],
   		[FINANCIALCENTER!105!SubmitterID] AS [FINANCIALCENTER!105!SubmitterID],
		#XMLClaims_temp.[CLAIM!400!AccountID] AS [CLAIM!400!AccountID],
		#XMLClaims_temp.[CLAIM!400!AccountPeriodID] AS [CLAIM!400!AccountPeriodID] 
	FROM #XMLClaims_temp
		INNER JOIN InsurancePlan ON InsurancePlan.InsurancePlanUid = [PAYER!230!planType!hide]	--ClaimBatchDetail.InsurancePlanUid
		INNER JOIN InsuranceCarrier ON InsuranceCarrier.CorporationUid = [PAYER!230!ID!hide]		--InsurancePlan.InsuranceCarrierUid --[PAYER!230!ID!hide]
		INNER JOIN Corporation ON Corporation.CorporationUid = InsuranceCarrier.CorporationUid
		LEFT JOIN ListAccountType ON ListAccountType.AccountTypeUid =  -- InsuranceCarrier.AccountTypeUid	
											CASE WHEN InsurancePlan.UseInsuranceCarrierAccountType = 1 THEN InsuranceCarrier.AccountTypeUid		--Added by Aji 2006 03 22
												ELSE InsurancePlan.AccountTypeUid END
		LEFT join claimformatoption cfo on cfo.claimformatuid = CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.electronicclaimformatuid		--Added by Aji 2006 03 22
		ELSE InsurancePlan.electronicclaimformatuid END and cfo.fixedvalue is null and cfo.claimformatvaluetypeuid = 'FFF19D24-8250-4355-9B4B-60333EAEF3E4'
		LEFT join listclaimformatvaluetype lcfvt on lcfvt.claimformatvaluetypeuid = cfo.claimformatvaluetypeuid 
		LEFT join claimformatoption cfo1 on cfo1.claimformatuid = CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.electronicclaimformatuid		
		ELSE InsurancePlan.electronicclaimformatuid END and cfo1.fixedvalue is null and cfo1.claimformatvaluetypeuid = 'FE1D5047-6059-4051-B041-08C33031BB9F'
		LEFT join listclaimformatvaluetype lcfvt1 on lcfvt1.claimformatvaluetypeuid = cfo1.claimformatvaluetypeuid 

		LEFT join claimformatoption cfo2 on cfo1.claimformatuid = CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.electronicclaimformatuid		
		ELSE InsurancePlan.electronicclaimformatuid END and cfo1.fixedvalue is null and cfo2.claimformatvaluetypeuid = 'E8BC8BFD-D327-48B3-8188-1A166BBD4906'
		LEFT join listclaimformatvaluetype lcfvt2 on lcfvt2.claimformatvaluetypeuid = cfo2.claimformatvaluetypeuid 

		LEFT JOIN ListElectronicPayer lep ON lep.ElectronicPayerUid = InsuranceCarrier.ElectronicPayerUid
		left join ListClaimClearinghouse on ListClaimClearinghouse.ClaimClearinghouseUID = lep.ClaimClearinghouseUID--added 2418 9/29/09
	WHERE
		tag IN (200)	
		AND [PAYER!230!ID!hide] IS NOT NULL 
	


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PAYTOPROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PAYTOPROVIDER] AS' 
END
GO



/*
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/


ALTER PROC [dbo].[AR_genXMLClaims_PAYTOPROVIDER]
AS

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[PAYTOPROVIDER!130!PID],
	[PAYTOPROVIDER!130!PEID],
	[PAYTOPROVIDER!130!orgName],
	[PAYTOPROVIDER!130!FN],
	[PAYTOPROVIDER!130!LN],
	[PAYTOPROVIDER!130!address1],
	[PAYTOPROVIDER!130!address2],
	[PAYTOPROVIDER!130!city],
	[PAYTOPROVIDER!130!state],
	[PAYTOPROVIDER!130!zip],
	[PAYTOPROVIDER!130!phone],
	[PAYTOPROVIDER!130!IDType],
	[PAYTOPROVIDER!130!ID],

	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType],
    [PAYTOPROVIDER!130!NPISecID],

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
     [FINANCIALCENTER!105!FCID] 
)

SELECT DISTINCT
	130 								AS Tag,
	110 								AS parent,
	[SITE!100!PID]						AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	ListServiceSite.ServiceSiteUid		AS [PAYTOPROVIDER!130!PID],

	NULL								AS [PAYTOPROVIDER!130!PEID],

	-- BILLINGPROVIDER!120!FileAsGroup not used to determine ListServiceSite or Corporation.  
	-- ALWAYS assume corporation
	--CASE [BILLINGPROVIDER!120!FileAsGroup] WHEN 0 
	--                                       THEN ListServiceSite.Name	
	--									   ELSE Corporation.Name END	AS [PAYTOPROVIDER!130!orgName],
	ListServiceSite.Name AS [PAYTOPROVIDER!130!orgName],
	NULL								AS [PAYTOPROVIDER!130!FN],  
	NULL								AS [PAYTOPROVIDER!130!LN], -- Assumes always orgName
	ListServiceSite.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!address1],
	ListServiceSite.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!address2],
	ListServiceSite.[Address].value('(/Address/City)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!city],
	UPPER( ListServiceSite.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')) AS [PAYTOPROVIDER!130!state],
	ListServiceSite.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!zip],
	dbo.stripSpecialChars( ListServiceSite.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS [PAYTOPROVIDER!130!phone],

	--[PAYTOPROVIDER!130!IDType] 			AS [PAYTOPROVIDER!130!IDType],
	--[PAYTOPROVIDER!130!ID]				AS [PAYTOPROVIDER!130!ID],	
	--[PAYTOPROVIDER!130!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
    --[PAYTOPROVIDER!130!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],
    -- Use Billing provider identification
	[BILLINGPROVIDER!120!IDType] 			AS [PAYTOPROVIDER!130!IDType],
	[BILLINGPROVIDER!120!ID]				AS [PAYTOPROVIDER!130!ID],	
	[BILLINGPROVIDER!120!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
    [BILLINGPROVIDER!120!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],
	
	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]					AS [RENDERER!410!PEID],
    [FINANCIALCENTER!105!FCID]          AS  [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp
	INNER JOIN dbo.claimsubmitter ON #XMLClaims_temp.[SITE!100!claimSubmitterID!hide] = claimSubmitter.ClaimSubmitterUid 
	LEFT JOIN ListServiceSite ON claimSubmitter.PayToServiceSiteUid = ListServiceSite.ServiceSiteUid 
	INNER JOIN Provider ON Provider.PersonUid = [RENDERER!410!PEID]
	LEFT JOIN Corporation ON Provider.PayToProviderCorporationUid = Corporation.CorporationUid
	LEFT JOIN ListServiceSiteType ON ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
WHERE
	#XMLClaims_temp.tag = 110 AND
	#XMLClaims_temp.[SITE!100!payToAddressID!hide] IS NOT NULL
	AND LEN(#XMLClaims_temp.[SITE!100!payToAddressID!hide]) > 0

UNION ALL

SELECT DISTINCT
	130 							AS Tag,
	110 							AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	NULL					AS [PAYTOPROVIDER!130!PID],
	Provider.PersonUid		AS [PAYTOPROVIDER!130!PEID],
	NULL					AS [PAYTOPROVIDER!130!orgName],
	NULL					AS [PAYTOPROVIDER!130!FN],
	NULL					AS [PAYTOPROVIDER!130!LN],
	NULL					AS [PAYTOPROVIDER!130!address1],
	NULL					AS [PAYTOPROVIDER!130!address2],
	NULL					AS [PAYTOPROVIDER!130!city],
	NULL					AS [PAYTOPROVIDER!130!state],
	NULL					AS [PAYTOPROVIDER!130!zip],
	NULL					AS [PAYTOPROVIDER!130!phone],
	-- Use billing provider's identification
-- 24 = Employers Identification Number | 34 = Social Security Number
	--[PAYTOPROVIDER!130!IDType] 		AS [PAYTOPROVIDER!130!IDType],
	--[PAYTOPROVIDER!130!ID]			AS [PAYTOPROVIDER!130!ID],
	[BILLINGPROVIDER!120!IDType] 		AS [PAYTOPROVIDER!130!IDType],
	[BILLINGPROVIDER!120!ID]			AS [PAYTOPROVIDER!130!ID],
    NULL	 AS 	[PAYTOPROVIDER!130!NPISecIDType],
    NULL	 AS	    [PAYTOPROVIDER!130!NPISecID],
    
	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
    [FINANCIALCENTER!105!FCID]          AS  [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp
	INNER JOIN Provider ON #XMLClaims_temp.[RENDERER!410!ID!hide] = Provider.PersonUid 
WHERE
	#XMLClaims_temp.tag = 110 AND
	#XMLClaims_temp.[SITE!100!payToAddressID!hide] IS NULL




GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PROC_ExciseTax]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PROC_ExciseTax] AS' 
END
GO

-- Modifications:
-- 2016-10-24 dsw - 51952:Hawaii Tax Changes to be handled in Claims and ERA processing

ALTER proc [dbo].[AR_genXMLClaims_PROC_ExciseTax]
AS

	-- Retrieve all procedures with an excise tax
	--   1)  Electronic Claim Format has an "Excise Tax Code" option type specified
	--   2)  Procedure has tax ( [PROC!450!TotalTax]  != 0 )
	-- NOTE:  UDF_getFormatVaribleValue retrieves the excise procedure code.  If there is no excise procedure code and/or there is not tax then there is nothing to do so just return
	 DECLARE @exciseProcs TABLE 
	 (
	   [PROC!450!ID!hide] UNIQUEIDENTIFIER,		-- superbillProcedureUid
	   [PROC!450!count] SMALLINT,				-- display order
	   [CLAIM!400!PID] UNIQUEIDENTIFIER,		-- superbillUid
	   exciseProc VARCHAR(25),					-- excise tax procedure code
	   codeDesc VARCHAR(1024),					-- excise tax procedure code desc
	   codeType VARCHAR(50),					-- excise tax procedure code type
	   codeName VARCHAR(50)						-- excise tax 
	 ) ;
	 INSERT INTO @exciseProcs( [PROC!450!ID!hide], [PROC!450!count], [CLAIM!400!PID], exciseProc )
		SELECT	#XMLClaims_temp.[PROC!450!ID!hide],
				#XMLClaims_temp.[PROC!450!count],
				#XMLClaims_temp.[CLAIM!400!PID],
				dbo.UDF_getFormatVaribleValue(2, #XMLClaims_temp.[CLAIM!400!ElectronicClaimFormatUid],  
												20,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS exciseProc 
		FROM #XMLClaims_temp
				INNER JOIN  ViewSuperbillFinancialDetails ON #XMLClaims_temp.[CLAIM!400!PID] = ViewSuperbillFinancialDetails.superbillUid   -- gets information for UDF_getFormatVaribleValue function
		WHERE #XMLClaims_temp.TAG = '450' -- Procedures
				and #XMLClaims_temp.[PROC!450!TotalTax] != 0 -- MUST HAVE TAX to add an excise tax procedure

	-- Remove ANY procedure WITHOUT an excise procedure code
	DELETE FROM @exciseProcs
	WHERE exciseProc IS NULL

	-- short-circuit if no excise procs and nothing to do
	if (NOT EXISTS ( SELECT * FROM @exciseProcs )) return 

	-- Retrieve excise code description
	-- Since exciseProc is just a string it does not point to a specific procedure code.
	--  MUST find one procedure code if multiple exist.  The following ranks the excise procedure code and orders by last modified date
	;with myCTE AS
	(	-- 1) Get distinct excise procedure codes
		select DISTINCT exciseProc from @exciseProcs
	),
	myCTE2 AS
	(   -- 2) Rank by LastModifiedDate just in case there are duplicates
		select mc.exciseProc,
				ROW_NUMBER() OVER( PARTITION BY mc.exciseProc ORDER BY lp.LastModifiedDate DESC) as ranking,
				lp.ProcedureUid,
				lp.LongDescription,
				lp.ProcedureCodeTypeUid
		from myCTE mc
				INNER JOIN ListProcedure lp WITH (NOLOCK) ON mc.exciseProc = lp.Code
	)
	UPDATE @exciseProcs 
		SET codeDesc = mc2.LongDescription,
			codeType = pct.ExternalID,
			codeName = pct.Name
	FROM @exciseProcs ep
			INNER JOIN myCTE2 mc2 on ep.exciseProc = mc2.exciseProc
										AND mc2.ranking = 1				-- Upate @excise proces with #1 ranked procedure code
			INNER JOIN ListProcedureCodeType pct WITH (NOLOCK) ON mc2.ProcedureCodeTypeUid = pct.ProcedureCodeTypeUid

/*
	select #XMLClaims_temp.[PROC!450!ID!hide], #XMLClaims_temp.[PROC!450!proc], #XMLClaims_temp.[PROC!450!count] 
	from @exciseProcs ep
			INNER JOIN #XMLClaims_temp on ep.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
											AND  #XMLClaims_temp.TAG = '450'
											AND  #XMLClaims_temp.[PROC!450!count] > ep.[PROC!450!count]
*/
	-- Move current procedures display order to allow for tax procedures under each one
	;with myCTE AS
	(   -- This calculates via procCount how much to move procedures following the excise procedures
		--   i.e.  If there are 3 procedures and procedure #1 and #2 both have an excise tax then procedure #3 must be moved down 2 spaces to allow for the 
		--         additional excise procedure on #1 and #2
		select #XMLClaims_temp.[PROC!450!ID!hide], COUNT(#XMLClaims_temp.[PROC!450!ID!hide]) as procCount--#XMLClaims_temp.[PROC!450!proc], #XMLClaims_temp.[PROC!450!count], 
		from @exciseProcs ep
				INNER JOIN #XMLClaims_temp on ep.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
												AND  #XMLClaims_temp.TAG = '450'
												AND  #XMLClaims_temp.[PROC!450!count] > ep.[PROC!450!count] -- finds "following" procedures to the excise procedure
		group by #XMLClaims_temp.[PROC!450!ID!hide]
	)
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!count] += mc.procCount	-- adds the amount to be moved to the displayorder
		FROM myCTE mc
				INNER JOIN #XMLClaims_temp ON mc.[PROC!450!ID!hide] = #XMLClaims_temp.[PROC!450!ID!hide]
		WHERE #XMLClaims_temp.TAG = '450' -- Procedures

	-- Create "Tax" procedures for each taxed procedure
	--   Does this by duplicating the current procedure with the tax, modifying the duplicate, and then inserting back into #XMLClaims_temp
	SELECT #XMLClaims_temp.*
	INTO #XMLClaims_HTaxProcs
	from @exciseProcs ep
			INNER JOIN #XMLClaims_temp on ep.[PROC!450!ID!hide] = #XMLClaims_temp.[PROC!450!ID!hide]
			
	-- Set displayOrder, procedure code and charge (tax) on new tax procedures
	UPDATE #XMLClaims_HTaxProcs
		SET [PROC!450!ID!hide] = newid(),
			[PROC!450!count] = #XMLClaims_HTaxProcs.[PROC!450!count] + 1,
			[PROC!450!proc] = ep.exciseProc,
			[PROC!450!description] = ep.codeDesc,
			[PROC!450!charge] = [PROC!450!TotalTax],
			[PROC!450!procCodeType] = ep.codeType,
			[PROC!450!procCodeName] = ep.codeName
		FROM #XMLClaims_HTaxProcs
				INNER JOIN @exciseProcs ep ON #XMLClaims_HTaxProcs.[PROC!450!ID!hide] = ep.[PROC!450!ID!hide]

	-- Update existing procedures to remove tax
	UPDATE #XMLClaims_temp
		SET [PROC!450!charge] -= [PROC!450!TotalTax]
		FROM #XMLClaims_temp
				INNER JOIN @exciseProcs ep ON #XMLClaims_Temp.[PROC!450!ID!hide] = ep.[PROC!450!ID!hide]
		WHERE #XMLClaims_temp.TAG = '450' -- Procedures

	-- Add excise tax procedures to procedures on #XMLClaims_temp
	INSERT INTO #XMLClaims_temp
		SELECT *
		FROM #XMLClaims_HTaxProcs

	/*
	INSERT INTO #XMLClaims_temp
		select	[PROC!450!ID!hide] = newid()--,
				--[PROC!450!count] = #XMLClaims_temp.[PROC!450!count]+1,
				--[PROC!450!proc] = 'S9999',
				--[PROC!450!procM1] = #XMLClaims_temp.[PROC!450!procM1],
				--[PROC!450!procM2] = #XMLClaims_temp.[PROC!450!procM2],
				--[PROC!450!procM3] = #XMLClaims_temp.[PROC!450!procM3],
				--[PROC!450!procM4] = #XMLClaims_temp.[PROC!450!procM4],
				--[PROC!450!diag1] = #XMLClaims_temp.[PROC!450!diag1],
				--[PROC!450!diag2] = #XMLClaims_temp.[PROC!450!diag2],
				--[PROC!450!diag3] = #XMLClaims_temp.[PROC!450!diag3],
				--[PROC!450!diag4] = #XMLClaims_temp.[PROC!450!diag4],
				--[PROC!450!diag5] = #XMLClaims_temp.[PROC!450!diag5],
				--[PROC!450!diag6] = #XMLClaims_temp.[PROC!450!diag6],
				--[PROC!450!diag7] = #XMLClaims_temp.[PROC!450!diag7],
				--[PROC!450!diag8] = #XMLClaims_temp.[PROC!450!diag8],
				--[PROC!450!diag9] = #XMLClaims_temp.[PROC!450!diag9],
				--[PROC!450!diag10] = #XMLClaims_temp.[PROC!450!diag10],
				--[PROC!450!diag11] = #XMLClaims_temp.[PROC!450!diag11],
				--[PROC!450!diag12] = #XMLClaims_temp.[PROC!450!diag12],
				--[PROC!450!unitType] = #XMLClaims_temp.[PROC!450!unitType], --='UN'
				--[PROC!450!units] = #XMLClaims_temp.[PROC!450!units],
				--[PROC!450!charge] = #XMLClaims_temp.[PROC!450!TotalTax],
				--[PROC!450!procedureType] = #XMLClaims_temp.[PROC!450!procedureType],
				--[PROC!450!procCodeType] = #XMLClaims_temp.[PROC!450!procCodeType],
				--[PROC!450!procCodeName] = #XMLClaims_temp.[PROC!450!procCodeName],
				--[PROC!450!description] = #XMLClaims_temp.[PROC!450!description],
				--[PROC!450!serviceDate] = #XMLClaims_temp.[PROC!450!serviceDate],
				--[PROC!450!serviceDateEnd] = #XMLClaims_temp.[PROC!450!serviceDateEnd],
				--[PROC!450!emergency] = #XMLClaims_temp.[PROC!450!emergency],
				--[PROC!450!serviceLocation] = #XMLClaims_temp.[PROC!450!serviceLocation],
				--[PROC!450!lineControlNo] = #XMLClaims_temp.[PROC!450!lineControlNo],
				--[PROC!450!TotalTax] = #XMLClaims_temp.[PROC!450!TotalTax],
				--[PROC!450!ProcID] = #XMLClaims_temp.[PROC!450!ProcID]
	from #XMLClaims_temp
	WHERE #XMLClaims_temp.TAG = '450' -- Procedures
*/
	
	/*
	select 
		[PROC!450!ID!hide] ,
		[PROC!450!count] ,
		[PROC!450!proc] ,
		[PROC!450!procM1] ,
		[PROC!450!procM2] ,
		[PROC!450!procM3] ,
		[PROC!450!procM4] ,
		[PROC!450!diag1] ,
		[PROC!450!diag2] ,
		[PROC!450!diag3] ,
		[PROC!450!diag4] ,
		[PROC!450!diag5] ,
		[PROC!450!diag6] ,
		[PROC!450!diag7] ,
		[PROC!450!diag8] ,
		[PROC!450!diag9] ,
		[PROC!450!diag10] ,
		[PROC!450!diag11] ,
		[PROC!450!diag12] ,
		[PROC!450!unitType] , --='UN'
		[PROC!450!units] ,
		[PROC!450!charge] ,
		[PROC!450!procedureType] ,
		[PROC!450!procCodeType] ,
		[PROC!450!procCodeName],
		[PROC!450!description] ,
		[PROC!450!serviceDate],
		[PROC!450!serviceDateEnd] ,
		[PROC!450!emergency] ,
		[PROC!450!serviceLocation] ,
		[PROC!450!lineControlNo] ,
		[PROC!450!TotalTax] ,
		[PROC!450!ProcID] 
	from #XMLClaims_HTaxProcs
	WHERE #XMLClaims_HTaxProcs.TAG = '450' -- Procedures
	ORDER BY [PROC!450!count] ASC
	*/

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PROC]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PROC] AS' 
END
GO

-- Modifications:
--CYS SC 10/22/09 - Remove NF ContractTypeCodes
--                  adds [PROC!450!ContractTypeCodeName], [PROC!450!ContractTypeCodeAnsi]
-- 2014-05-02  dsw Performance Improvements
--					Replaced ViewSuperbillProcedure_IsVoid with ViewSuperbillProcedure_NonVoidedWithLedgers
-- 2014-07-31  dsw 16026
--                  Added PURCHASEDSERVICE
-- 2014-09-02 dsw - Added code to sum procedure charges for claim
-- 2015-03-06 dsw - Added 	[PROC!450!FamilyPlanning] BIT
-- 2016-01-08 dsw - 44998, Changed float to decimal(10,2) when summing charge.  Got imprecision otherwise
-- 2016-10-26 dsw - 51952: Hawaii Tax Changes to be handled in Claims and ERA Processing

ALTER proc [dbo].[AR_genXMLClaims_PROC]
AS


	-- Find/Map procedure substitution text
	DECLARE @ProcedureAliases TABLE -- As defined by the map items table
	(
	  superbillProcedureUid uniqueidentifier,
	  aliasText varchar(200),
	  rowNo int
	)
	INSERT INTO @ProcedureAliases(superbillProcedureUid, aliasText, rowNo)
		select sbp.SuperbillProcedureUid, mi.SubstitutionText, ROW_NUMBER() OVER( PARTITION BY sbp.SuperbillProcedureUid ORDER BY mi.LastModifiedDate desc)
		FROM #XMLClaims_temp
			  INNER JOIN SuperbillProcedure sbp ON sbp.superbillUid = #XMLClaims_temp.[CLAIM!400!PID]
												AND ISNULL(sbp.DontClaim,0) = 0
			  INNER JOIN Superbill sb on 	sbp.SuperbillUid = sb.SuperbillUid
			  INNER JOIN SuperbillAggregate sa on sb.SuperbillUid = sa.SuperbillUid
			  INNER JOIN Account act on sb.AccountUid = act.AccountUid
			  INNER JOIN AccountPeriod ap on act.AccountUid = ap.AccountUid
	  										and (ap.EffectiveDate IS NULL OR ( ap.EffectiveDate <= sb.ServiceDateEnd))
	  										and (ap.ExpirationDate IS NULL OR ( ap.ExpirationDate >= sb.ServiceDateEnd))
			  INNER JOIN AccountInsurance ai on ap.AccountPeriodUid = ai.AccountPeriodUid
												and sa.CurrentCarrier = ai.DisplayOrder
			  INNER JOIN PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			  INNER JOIN InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
			  INNER JOIN MapItem mi on ip.InsuranceCarrierUid = mi.FindTableFromItemUid
											and sbp.ProcedureUid = mi.FindTableToItemUid 
														
	--SELECT *
	--FROM @ProcedureAliases

	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide],
		[RENDERER!410!PEID],
		[CLAIM!400!PID],
	    [CLAIM!400!ChcBillingType],								-- DSW, 60093
		[PATIENT!300!PEID],
		[SUBSCRIBER!200!PEID],
		[PAYER!230!ID!hide],			
		[PROC!450!ID!hide],
		[PROC!450!count],
		[PROC!450!proc],
		[PROC!450!revenueCode],
		[PROC!450!procM1],
		[PROC!450!procM2],
		[PROC!450!procM3],
		[PROC!450!procM4],
		[PROC!450!diag1],
		[PROC!450!diag2],
		[PROC!450!diag3],
		[PROC!450!diag4],
		[PROC!450!diag5],
		[PROC!450!diag6],
		[PROC!450!diag7],
		[PROC!450!diag8],
		[PROC!450!diag9],
		[PROC!450!diag10],
		[PROC!450!diag11],
		[PROC!450!diag12],
		[PROC!450!unitType], --='UN'
		[PROC!450!units],
		[PROC!450!charge],
		[PROC!450!procedureType],
		[PROC!450!procCodeType],
		[PROC!450!procCodeName],
		[PROC!450!description],
		[PROC!450!serviceDate],
		[PROC!450!serviceDateEnd],
		[PROC!450!emergency],
		[PROC!450!serviceLocation],
		[PROC!450!lineControlNo],
		[PROC!450!TotalTax],
		[PROC!450!ProcID] ,
		[PROC!450!NoteReferenceCode],
		[PROC!450!Note],
		[PROC!450!NDC],
		[PROC!450!MedicationMeasurementValue],
		[PROC!450!MedicationMeasurementReference],
		[PROC!450!MedicationMeasurementQualifier],
		[PROC!450!COST],
		[PROC!450!NDCQuantity],
		[PROC!450!NDCUnitMeasure] ,
		[PROC!450!ContractTypeCodeName],
		[PROC!450!ContractTypeCodeAnsi],
	    [PROC!450!PaperworkTypeID],
	    [PROC!450!PaperworkTransmissionCodeID],
	    [PROC!450!PaperworkControlNum],

		[PROC!450!UserDefinedXml],

		[FINANCIALCENTER!105!FCID],
		[CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID],
		[CLAIM!400!ElectronicClaimFormatUid]
	)
	SELECT DISTINCT

		450 						AS Tag,
		400 						AS parent,
		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
		#XMLClaims_temp.[CLAIM!400!PID]		AS [CLAIM!400!PID],
		#XMLClaims_temp.[CLAIM!400!ChcBillingType] AS [CLAIM!400!ChcBillingType], -- DSW 60093
		#XMLClaims_temp.[PATIENT!300!PEID]		AS [PATIENT!300!PEID],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID]	AS [SUBSCRIBER!200!PEID],
		#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],


		SuperbillProcedure.SuperbillProcedureUid		AS [PROC!450!ID!hide],
		dbo.GetSuperbillProcedureRowNumber(SuperbillProcedure.SuperbillProcedureUid) AS [PROC!450!count],
		COALESCE( al.aliasText, ListProcedure.Code ) AS [PROC!450!proc],
		ListProcedure.RevenueCode               AS [PROC!450!revenueCode], -- 60093
		(CASE 	WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1) = '' 
		        THEN NULL
			    ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1) END)						AS [PROC!450!procM1],
		(CASE 	WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2) = '' 
		        THEN NULL
			    ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2) END)						AS [PROC!450!procM2],
		(CASE 	WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3) = '' 
		        THEN NULL
			    ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3) END)						AS [PROC!450!procM3],
		(CASE 	WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4) = '' 
		        THEN NULL
			    ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4) END)						AS [PROC!450!procM4],
		
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer1 = 0 THEN NULL	ELSE SuperbillProcedure.DiagnosisPointer1 END)						AS [PROC!450!diag1],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer2 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer2 END)						AS [PROC!450!diag2],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer3 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer3 END)						AS [PROC!450!diag3],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer4 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer4 END)						AS [PROC!450!diag4],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer5 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer5 END)						AS [PROC!450!diag5],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer6 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer6 END)						AS [PROC!450!diag6],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer7 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer7 END)						AS [PROC!450!diag7],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer8 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer8 END)						AS [PROC!450!diag8],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer9 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer9 END)						AS [PROC!450!diag9],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer10 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer10 END)						AS [PROC!450!diag10],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer11 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer11 END)						AS [PROC!450!diag11],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer12 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer12 END)						AS [PROC!450!diag12],

		'UN'						AS [PROC!450!unitType],
		CONVERT(VARCHAR,SuperbillProcedure.Units)	AS [PROC!450!units],
		CONVERT(VARCHAR,SuperbillProcedure.TotalCharge,0) AS [PROC!450!charge],
		ListProcedureServiceType.ANSICode		AS [PROC!450!procedureType],
		'HC'						AS [PROC!450!procCodeType],
		ListProcedureCodeType.Name AS [PROC!450!procCodeName],
		ListProcedure.ShortDescription			AS [PROC!450!description],
		CONVERT(VARCHAR, SuperbillProcedure.ProcedureServiceDateStart, 101)			AS [PROC!450!serviceDate],
		CONVERT(VARCHAR, SuperbillProcedure.ProcedureServiceDateEnd, 101)			AS [PROC!450!serviceDateEnd],
		[PROC!450!emergency]				AS [PROC!450!emergency],
		[PROC!450!serviceLocation]			AS [PROC!450!serviceLocation],
		[PROC!450!lineControlNo]+''+CONVERT(VARCHAR,SuperbillProcedure.DisplayOrder)	AS [PROC!450!lineControlNo],
		SuperbillProcedure.TotalTax		AS [PROC!450!TotalTax],
		SuperbillProcedure.SuperbillProcedureUID AS [PROC!450!ProcID] ,
 		'ADD'                    AS  [PROC!450!NoteReferenceCode],
		CASE WHEN COALESCE(SuperbillProcedure.NDC,'') = '' 
		     THEN CONVERT(VARCHAR(80),SUBSTRING(COALESCE(SuperbillProcedure.Notes,''),1,80),80)
			 WHEN SuperbillProcedure.NDC IS NOT NULL AND disp.MedDesc IS NOT NULL 
			 THEN SUBSTRING( (Convert(varchar(80), disp.MedDesc) + ' ' + Convert(varchar(80), COALESCE(SuperbillProcedure.Notes,''))), 1, 80)
			 WHEN SuperbillProcedure.NDC IS NOT NULL AND listProcedure.LongDescription IS NOT NULL 
			 THEN SUBSTRING( (Convert(varchar(80), listProcedure.LongDescription) + ' ' + Convert(varchar(80), COALESCE(SuperbillProcedure.Notes,''))), 1, 80)
			 ELSE CONVERT(VARCHAR(80),SUBSTRING(COALESCE(SuperbillProcedure.Notes,''),1,80),80) END  AS  [PROC!450!Note],
		COALESCE(SuperbillProcedure.NDC,'') AS  [PROC!450!NDC],
		SuperbillProcedure.MedicationMeasurementValue AS [PROC!450!MedicationMeasurementValue],
		SuperbillProcedure.MedicationMeasurementReference AS [PROC!450!MedicationMeasurementReference],
		ListMeasurementQualifier.ANSICode AS [PROC!450!MedicationMeasurementQualifier]	,
		SuperbillProcedure.COST AS [PROC!450!COST],
		SuperbillProcedure.NDCQuantity AS [PROC!450!NDCQuantity],
		CONVERT(VARCHAR(2),listNDCUnitMeasure.ANSICode)  AS[PROC!450!NDCUnitMeasure] ,
		ISNULL(ListContractTypeCode.Name,'') AS [PROC!450!ContractTypeCodeName],
		ISNULL(ListContractTypeCode.ANSICode,'') AS [PROC!450!ContractTypeCodeAnsi],
	    SUBSTRING(ISNULL(lpt.ANSICode, ''), 1, 2) AS [PROC!450!PaperworkTypeID],
	    SUBSTRING(ISNULL(lptc.ANSICode, ''), 1, 2) AS  [PROC!450!PaperworkTransmissionCodeID],
	    SUBSTRING(ISNULL(SuperbillProcedure.PaperworkControlNum, ''), 1, 50) AS  [PROC!450!PaperworkControlNum],
		convert(varchar(8000),SuperbillProcedure.UserDefinedXml) AS [PROC!450!UserDefinedXml],
		 [FINANCIALCENTER!105!FCID]   AS  [FINANCIALCENTER!105!FCID],
		 #XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
		 #XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID],
		 #XMLClaims_temp.[CLAIM!400!ElectronicClaimFormatUid] AS [CLAIM!400!ElectronicClaimFormatUid]
	FROM #XMLClaims_temp
			INNER JOIN SuperbillProcedure ON SuperbillProcedure.superbillUid = #XMLClaims_temp.[CLAIM!400!PID]
												AND ISNULL(SuperbillProcedure.DontClaim,0) = 0
												AND ISNULL(SuperbillProcedure.Inactive,0) = 0
			INNER JOIN ViewSuperbillProcedure_NonVoidedWithLedgers sbpnv with (nolock) on SuperbillProcedure.SuperbillProcedureUid = sbpnv.superbillProcedureUid
			INNER JOIN ListProcedure ON	ListProcedure.ProcedureUid = SuperbillProcedure.ProcedureUid
			LEFT JOIN ListProcedureCodeType ON ListProcedureCodeType.ProcedureCodeTypeUid = ListProcedure.ProcedureCodeTypeUid
													AND ListProcedureCodeType.Name IN ('CPT','HCPCS', 'PQRI')
			LEFT JOIN ListProcedureServiceType ON ListProcedureServiceType.ProcedureServiceTypeUid = ListProcedure.ProcedureServiceTypeUid
			LEFT JOIN listNDCUnitMeasure on listNDCUnitMeasure.NDCUnitMeasureUID = SuperbillProcedure.NDCUnitMeasureUID
			LEFT JOIN ListMeasurementQualifier ON ListMeasurementQualifier.MeasurementQualifierUid = SuperbillProcedure.MedicationMeasurementQualifierUID
			LEFT JOIN ListContractTypeCode ON ListContractTypeCode.ContractTypeCodeUid = SuperbillProcedure.ContractTypeCodeUid
			LEFT OUTER JOIN dbo.NDD_SearchDispensable disp on disp.IsDelete = 0 AND SuperbillProcedure.FDB_MEDID = disp.medid
			LEFT OUTER JOIN @ProcedureAliases al on superbillProcedure.SuperbillProcedureUid = al.superbillProcedureUid
														AND al.rowNo = 1
			LEFT OUTER JOIN ListPaperworkType lpt on superbillProcedure.PaperworkTypeUid = lpt.PaperworkTypeUid
			LEFT OUTER JOIN ListPaperworkTransmissionCode lptc on SuperbillProcedure.PaperworkTransmissionCodeUid = lptc.PaperworkTransmissionCodeUid
	WHERE
		#XMLClaims_temp.tag = 400 
	DELETE #XMLClaims_temp WHERE TAG = '450' AND
		([PROC!450!ContractTypeCodeName] = 'NF' OR [PROC!450!ContractTypeCodeAnsi] = 'NF')

	-- PurchasedServiceCharge
	--  Purchased Service / Outside Lab for this specific procedure
	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[FINANCIALCENTER!105!FCID],
		[RENDERER!410!ID!hide],
		[SUBSCRIBER!200!PEID],
		[CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID] ,
		[PATIENT!300!PEID],
		[CLAIM!400!PID],
		[PROC!450!ID!hide],
		[PROC!450!count],
		[PROC!450!proc],
		[PURCHASEDSERVICE!455!PURCHASEDSERVICEUID],
		[PURCHASEDSERVICE!455!Charge] ,
		[PURCHASEDSERVICE!455!Name] ,
		[PURCHASEDSERVICE!455!NPI],
		[PURCHASEDSERVICE!455!orgName],
		[PURCHASEDSERVICE!455!ID2] ,	-- 4010, Loop 2310C, Purchased Service Provider Secondary Identification
		[PURCHASEDSERVICE!455!IDType2] 		-- 4010, Loop 2310C, Purchased Service Provider Secondary Identification		 
	)
	SELECT DISTINCT
		455 						AS Tag,			-- PURCHASEDSERVICE
		450 						AS parent,		-- PROC
		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		#XMLClaims_temp.[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		#XMLClaims_temp.[FINANCIALCENTER!105!FCID]   AS  [FINANCIALCENTER!105!FCID],
		#XMLClaims_temp.[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID]		AS [SUBSCRIBER!200!PEID],
		#XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
		#XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID],
		#XMLClaims_temp.[PATIENT!300!PEID]		AS [PATIENT!300!PEID],
		#XMLClaims_temp.[CLAIM!400!PID]		AS [CLAIM!400!PID],
		#XMLClaims_temp.[PROC!450!ID!hide]  AS [PROC!450!ID!hide],
		#XMLClaims_temp.[PROC!450!count]	AS [PROC!450!count],
		#XMLClaims_temp.[PROC!450!proc]		AS [PROC!450!proc],

		msp.CorporationUid					AS [PURCHASEDSERVICE!455!PURCHASEDSERVICEUID],
		CONVERT(VARCHAR, sbp.PurchasedServiceCharge, 0)			AS   [PURCHASEDSERVICE!455!Charge] ,
		corp.Name							AS   [PURCHASEDSERVICE!455!Name] ,	
		dbo.UDF_getFormatVariableValueByMedicalServicesProviderUid(	'C9BB7DB2-26B1-40C5-BF4D-52FD702100FA', -- C9BB7DB2-26B1-40C5-BF4D-52FD702100FA==Medical Services Provider NPI
																	sbp.MedicalServicesProviderUid,
																	sba.ServiceSiteUid,
																	sba.FinancialCenterUid)
																	AS [PURCHASEDSERVICE!455!NPI] , 
		corp.Name								AS [PURCHASEDSERVICE!455!orgName],
		dbo.UDF_getFormatVariableValueByMedicalServicesProvider( #XMLClaims_temp.[CLAIM!400!ElectronicClaimFormatUid], 
		                                                         2, 0, -- ElectronicClaimFormat, 'Purchased Service ID'
																 sbp.MedicalServicesProviderUid, sba.ServiceSiteUid, sba.FinancialCenterUid
															    ) AS [PURCHASEDSERVICE!455!ID2],
		dbo.UDF_getFormatVariableValueByMedicalServicesProvider( #XMLClaims_temp.[CLAIM!400!ElectronicClaimFormatUid], 
		                                                         2, 1, -- ElectronicClaimFormat, 'Purchased Service ID Type'
																 sbp.MedicalServicesProviderUid, sba.ServiceSiteUid, sba.FinancialCenterUid
															    ) AS [PURCHASEDSERVICE!455!IDType2]
	FROM #XMLClaims_temp
			INNER JOIN SuperbillProcedure sbp with (nolock) ON  #XMLClaims_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid
			INNER JOIN MedicalServicesProvider msp with (nolock) ON sbp.MedicalServicesProviderUid = msp.CorporationUid
			INNER JOIN Corporation corp with (nolock) on msp.CorporationUid = corp.CorporationUid
			INNER JOIN SuperbillAggregate sba with (nolock) on sbp.SuperbillUid = sba.SuperbillUid
	WHERE
		#XMLClaims_temp.tag = 450  -- PROC 

	-- SET #XMLClaims_temp.[Claim!400!totalBill] by summing procedure charges
	-- Bug 44998 - Changed float to decimal(10,2)	01/08/2016
	;with myCTE as
	(
		select #XMLClaims_temp.[CLAIM!400!PID] as uid,
				sum(cast(coalesce(#XMLClaims_temp.[PROC!450!charge], '0') as decimal(10,2))) as total
		from #XMLClaims_temp
		WHERE tag = 450
		group by #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[Claim!400!totalBill] = 
			CASE WHEN mc.total = 0 THEN '0' ELSE CONVERT(varchar(12), mc.total, 128) END  -- new
	From #XMLClaims_temp		
			INNER JOIN myCTE mc ON #XMLClaims_temp.[CLAIM!400!PID] = mc.uid
	WHERE #XMLClaims_temp.tag = 400


	UPDATE #XMLClaims_temp
	Set #XMLClaims_temp.[PROC!450!FamilyPlanning] = fsf.FamilyPlanning
	from #XMLClaims_temp
			INNER JOIN SuperbillProcedure sbp with (nolock) ON #XMLClaims_temp.[PROC!450!ProcID] = sbp.SuperbillProcedureUid
			INNER JOIN Superbill sb with (nolock) on sbp.superbillUid = sb.SuperbillUid
			INNER JOIN ListProcedure lp with (nolock) ON sbp.ProcedureUid = lp.ProcedureUid
			INNER JOIN FeeSchedulePeriod fsp with (nolock) on sb.AmountAllowedSchedulePeriodUid = fsp.FeeSchedulePeriodUid
			INNER JOIN FeeScheduleFee fsf with (nolock) on fsp.FeeSchedulePeriodUid = fsf.FeeSchedulePeriodUid
							and lp.ProcedureUid = fsf.ProcedureUid
							and fsf.FamilyPlanning = 1
	WHERE #XMLClaims_temp.TAG = '450' -- Procedures

	-- Bug 51952: Hawaii Tax Changes to be handled in Claims and ERA Processing
	exec AR_genxmlclaims_PROC_ExciseTax



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PROC_MA]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PROC_MA] AS' 
END
GO


-- Modifications:
--CYS SC 10/22/09 - Remove NF ContractTypeCodes
--                  adds [PROC!450!ContractTypeCodeName], [PROC!450!ContractTypeCodeAnsi]
-- 2014-05-02  dsw Performance Improvements
--					Replaced ViewSuperbillProcedure_IsVoid with ViewSuperbillProcedure_NonVoidedWithLedgers
-- 2014-07-31  dsw 16026
--                  Added PURCHASEDSERVICE
-- 2014-09-02 dsw - Added code to sum procedure charges for claim
-- 2015-03-06 dsw - Added 	[PROC!450!FamilyPlanning] BIT
-- 2016-01-08 dsw - 44998, Changed float to decimal(10,2) when summing charge.  Got imprecision otherwise
-- 2016-10-26 dsw - 51952: Hawaii Tax Changes to be handled in Claims and ERA Processing

ALTER proc [dbo].[AR_genXMLClaims_PROC_MA]
AS

-- CHC Changes
/***** Medicare A Rollup Logic ********************************************
MA SP Rolls up the revenue codes - all fees for a specific rev code are rolled into a single Proc for that Rev Code
Any procs with missing Rev Codes are deleted

*/

------------------------------------------------------------------------------------------------------------------------------
-- FQHC solution
-- RHC Solution ( Works like FQHC BUT ALSO uses a mapping table to override revenue codes )

-- FQHC ( chcBillingType == 0 ), RHC ( chcBillingType == 3 )
-- Groups ( Rolls Up ) procedures by revenue code
-- NOTE:  Throws out procedures with no revenue code

-- Creae a working table for all superbill procedures with FQHC revenue codes
CREATE TABLE #fqhc_temp
(
		[CLAIM!400!PID] UNIQUEIDENTIFIER,
		SuperbillProcedureUid UNIQUEIDENTIFIER,
		ProcedureUid UNIQUEIDENTIFIER,
		RevenueCode VARCHAR(10),
		RevenueCodeOrder int,
		Charge MONEY
)


-- Insert into working fqhc table ( Only those with billing type of 0 which is fqhc )
--  Revenue code procedures based on:
--     Superbill, SuperbillProcedureUid, RevenueCode
--     (Include a revenueCodeOrder to allow grouping later )
INSERT INTO #fqhc_temp( [CLAIM!400!PID], SuperbillProcedureUid, ProcedureUid, RevenueCode, Charge)
	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
		   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
		   sbp.ProcedureUid AS ProcedureUid,
		   #XMLClaims_temp.[PROC!450!revenueCode] AS RevenueCode,
		   --ROW_NUMBER() OVER( PARTITION BY #xmlClaims_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder,
		   CASE WHEN (ISNUMERIC(#XMLClaims_temp.[PROC!450!Charge]) = 1 ) THEN CONVERT( MONEY, #XMLClaims_temp.[PROC!450!Charge]) ELSE 0 END AS Charge
	FROM #XMLClaims_temp
			INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = #XMLClaims_temp.[PROC!450!ID!hide]
	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] IN (0,3) -- FQHC==0, RHC=3
			AND (IsNull([PROC!450!revenueCode],'0') != '0') -- anything WITH a revenue code
	ORDER BY sbp.DisplayOrder

----???
--	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
--		   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
--		   sbp.ProcedureUid AS ProcedureUid,
--		   #XMLClaims_temp.[PROC!450!revenueCode] AS RevenueCode,#XMLClaims_temp.[PROC!450!Charge], #XMLClaims_temp.[PROC!450!proc],
--		   --ROW_NUMBER() OVER( PARTITION BY #xmlClaims_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder,
--		   CASE WHEN (ISNUMERIC(#XMLClaims_temp.[PROC!450!Charge]) = 1 ) THEN CONVERT( MONEY, #XMLClaims_temp.[PROC!450!Charge]) ELSE 0 END AS Charge
--	FROM #XMLClaims_temp
--			INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = #XMLClaims_temp.[PROC!450!ID!hide]
--	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
--			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] IN (0,3) -- FQHC==0, RHC=3


--select *
--from #fqhc_temp
---- ???

IF ( EXISTS( SELECT * FROM #fqhc_temp ) )
BEGIN

	-- Update procedure revenue codes with RHC ( 3 ) revenue codes (Mapping Table for RHC)
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!revenueCode] = mi.SubstitutionText
		FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #xmlClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
				INNER JOIN MapItem mi WITH (NOLOCK) ON mi.MapSourceUid = '649D2F6A-D215-41F3-963F-E912AACAF335' -- RHC 
														AND #fqhc_temp.ProcedureUid = mi.FindTableFromItemUid
		WHERE #XMLClaims_temp.tag = 450 -- PROC
				AND #XMLClaims_temp.[PROC!450!revenueCode] IS NOT NULL
			    AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 3 -- RHC=3 ( ONLY for RHC, NOT FOR FQHC )

	--For FQHC/RHC billing type, only want Procs with RevenueCodes
	-- Remove those without revenue codes
	DELETE #XMLClaims_temp 
	WHERE	(tag = '450') AND 
			([CLAIM!400!ChcBillingType] IN (0,3)) AND -- FQHC==0, RHC=3
			(IsNull([PROC!450!revenueCode],'0') = '0')

	-- Create a revenueCodeOrder based on "substituted" revenue code
	;with myCTE as
	(
		SELECT #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.SuperbillProcedureUid, #XMLClaims_temp.[PROC!450!revenueCode] as RevenueCode,
				ROW_NUMBER() OVER( PARTITION BY #fqhc_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) as RevenueCodeOrder
		FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #fqhc_temp.SuperbillProcedureUid = sbp.SuperbillProcedureUid
		WHERE #XMLClaims_temp.tag = 450 -- PROC
	)
	Update #fqhc_temp
		SET RevenueCode = mc.RevenueCode,
			RevenueCodeOrder = mc.RevenueCodeOrder
	FROM #fqhc_temp
			INNER JOIN myCTE mc on #fqhc_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID] 
									AND #fqhc_temp.SuperbillProcedureUid = mc.SuperbillProcedureUid

	--
	-- select * from #fqhc_temp order by RevenueCodeOrder asc
	--

	-- Now create a common table expression summing up like revenue codes based on 
	--  superbill and revenueCode
	-- Then
	--  Update the working table with the total for each revenue code
	--   NOTE:  only change the first revenue code entry since others are duplicates and will be thrown out later
	;with myCTE AS
	(
		select #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode, Sum( #fqhc_temp.Charge) as TotalRevCodeCharge
		from #fqhc_temp
		group by #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode
	)
	UPDATE #fqhc_temp
		SET #fqhc_temp.Charge = myCTE.TotalRevCodeCharge
	FROM #fqhc_temp
			INNER JOIN myCTE ON #fqhc_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
									AND #fqhc_temp.RevenueCode = myCTE.RevenueCode
	WHERE #fqhc_temp.RevenueCodeOrder = 1 -- Only change the 1st entry of this revenue code

	-- Now delete all "duplicate" revenue codes
	--   Those in working table with a revenueCodeOrder > 1
	DELETE #XMLClaims_temp
	FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid	
	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] IN ( 0, 3) -- FQHC==0, RHC==3
			AND #fqhc_temp.RevenueCodeOrder > 1		-- Only delete the duplicate revenue codes after the first one

	-- Now update the "first" revenue code with the new sum of all revenue codes
	Update #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!Charge] = CONVERT(VARCHAR(10), #fqhc_temp.Charge)
	FROM #XMLClaims_temp
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	WHERE #XMLClaims_temp.tag = 450 -- proc
	-- only thing left should be thos with RevenueCodeOrder of 1

	--
	-- select * from #fqhc_temp order by RevenueCodeOrder asc
	--

	-- Update claim "Total Charge" now that everything is rolled up
	;WITH myCTE AS
	(
		select #XMLClaims_temp.[CLAIM!400!PID], SUM( CONVERT(MONEY,#XMLClaims_temp.[PROC!450!Charge])) AS TotalCharge	
		from #XMLClaims_temp
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	    WHERE #XMLClaims_temp.tag = 450 -- proc
		GROUP BY #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp 
		SET [CLAIM!400!totalBill] = CONVERT(VARCHAR(10),  mc.TotalCharge)
	FROM #XMLClaims_temp
			INNER JOIN myCTE mc on #XMLClaims_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID]
	WHERE #XMLClaims_temp.tag = 400

END

TRUNCATE TABLE 	#fqhc_temp  -- don't drop yet because used in RHC "legacy" detail ( treats RHC like FQHC )

-----------------------------------------------------------------------------------------------------------------------------------
-- RHC Detail solution
CREATE TABLE #rhc_temp
(
		[CLAIM!400!PID] UNIQUEIDENTIFIER,
		ServiceDateStart DATETIME,							-- Superbill service date
		MinDisplayOrder int,					-- minimum procedure display order on claim
		totalBill money										-- sum of charges on claim
)

-- Insert into working rhc table ( Only thos with billing type of 0 which is rhc )
INSERT INTO #rhc_temp( [CLAIM!400!PID], ServiceDateStart, totalBill)
	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID], sb.ServiceDateStart AS ServiceDateStart, 0 as totalBill
	FROM #XMLClaims_temp
			INNER JOIN Superbill sb WITH (NOLOCK) ON #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid
	WHERE #XMLClaims_temp.tag = 400 -- CLAIMS
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 2 -- RHC

IF ( EXISTS( SELECT * FROM #rhc_temp ) )
BEGIN
	-- For RHC,
	-- If "Legacy RHC" then convert revenue codes to older version
	--    Part A: Get RHC Legacy Date from MapSource Notes
	DECLARE @rhcLegacyDate date
	declare @rhcLegacyInfo varchar(500)
	declare @endIndex int
	SELECT @rhcLegacyInfo = Notes FROM MapSource WITH (NOLOCK) WHERE MapSourceUid = 'A2D729F2-F416-4528-BE63-B27A0F95F001'

	select @endindex = CHARINDEX(', RHCs are required to report', @rhcLegacyInfo)
	if ( @endIndex > 14 )
	begin
		select @rhcLegacyDate = CONVERT(date, SUBSTRING(@rhcLegacyInfo, 13, (@endIndex-13)), 104)
	end
	else
	begin
		select @rhcLegacyDate = '2016-04-01' -- If unable to "decipher" date use hard-coded date
	end

	-- test     select @rhcLegacyDate as RHCLegacyDate, 'A2D729F2-F416-4528-BE63-B27A0F95F001' AS MapSource

	-- Part B:  Update procedure revenue codes with legacy revenue codes only if before legacy date
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!revenueCode] = mi.SubstitutionText
		FROM #XMLClaims_temp
				INNER JOIN #rhc_temp ON #xmlClaims_temp.[CLAIM!400!PID] = #rhc_temp.[CLAIM!400!PID]
											AND #rhc_temp.ServiceDateStart < @rhcLegacyDate
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #XMLClaims_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid 
				INNER JOIN MapItem mi WITH (NOLOCK) ON mi.MapSourceUid = 'A2D729F2-F416-4528-BE63-B27A0F95F001' -- RHC Detail
														AND sbp.ProcedureUid = mi.FindTableFromItemUid
		WHERE #XMLClaims_temp.tag = 450 -- PROC
				AND #XMLClaims_temp.[PROC!450!revenueCode] IS NOT NULL

	--For RHC billing type, only want Procs with RevenueCodes
	-- Remove those without revenue codes
	DELETE #XMLClaims_temp 
	WHERE	(tag = '450') AND 
			([CLAIM!400!ChcBillingType] = 2) AND
			(IsNull([PROC!450!revenueCode],'0') = '0')

	;with myCTE AS
	(
		select #rhc_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
				SUM( CONVERT(MONEY,#XMLClaims_temp.[PROC!450!charge])) as [PROC!450!charge]
		from #rhc_temp
				INNER JOIN #XMLClaims_temp ON #rhc_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
	    WHERE #XMLClaims_temp.tag = 450 -- proc
		GROUP BY #rhc_temp.[CLAIM!400!PID]
	)
	UPDATE #rhc_temp
		SET totalBill = mc.[PROC!450!charge]
		FROM #rhc_temp
				INNER JOIN myCTE mc ON #rhc_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID]

	-----------------------------------------------------------------------------------------------
	-- Post Legacy claims ( After legacy date claims )
	-----------------------------------------------------------------------------------------------
	-- Part C: For "post" legacy RHC claims....
	--  The first superbill procedure contains the sum of all procedures on the claim
	--  Subsequent procedures are not changed
	;with myCTE AS
	(
		-- Retrieve the minimum superbill procedure for each rhc claim and total bill on claim so we don't have to calculate it
		SELECT #rhc_temp.[CLAIM!400!PID] as [CLAIM!400!PID], #rhc_temp.totalBill, MIN( sbp.DisplayOrder ) as minDisplayOrder
		FROM #rhc_temp
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #rhc_temp. [CLAIM!400!PID] = sbp.SuperbillUid
																	and sbp.DontClaim = 0
		WHERE #rhc_temp.ServiceDateStart >= @rhcLegacyDate
		GROUP BY #rhc_temp.[CLAIM!400!PID], #rhc_temp.totalBill
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[PROC!450!charge] = myCTE.totalBill
	FROM #XMLClaims_temp
			INNER JOIN myCTE ON #xmlClaims_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
			INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #XMLClaims_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid 
																and myCTE.minDisplayOrder = sbp.DisplayOrder
	WHERE #XMLClaims_temp.tag = 450 -- PROC

	-- PartD: For "post" legacy RHC Claims
	-- Now that the first procedure has changed, change the total billed amount on the claim
	;with myCTE as
	(
		select #XMLClaims_temp.[CLAIM!400!PID] as uid,
				sum(cast(coalesce(#XMLClaims_temp.[PROC!450!charge], '0') as decimal(10,2))) as total
		from #XMLClaims_temp
				INNER JOIN #rhc_temp ON #xmlClaims_temp.[CLAIM!400!PID] = #rhc_temp.[CLAIM!400!PID]
											AND #rhc_temp.ServiceDateStart >= @rhcLegacyDate
		WHERE #XMLClaims_temp.tag = 450
		group by #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[Claim!400!totalBill] = 
			CASE WHEN mc.total = 0 THEN '0' ELSE CONVERT(varchar(12), mc.total, 128) END  -- new
	From #XMLClaims_temp		
			INNER JOIN myCTE mc ON #XMLClaims_temp.[CLAIM!400!PID] = mc.uid
	WHERE #XMLClaims_temp.tag = 400;
	
	-----------------------------------------------------------------------------------------------
	-- Legacy claims ( before legacy date claims )
	-- 
	-----------------------------------------------------------------------------------------------
	-- Part E: Insert into working fqhc/rhc table 
	-- Treat like FQHC FOR LEGACY ITEMS
	INSERT INTO #fqhc_temp( [CLAIM!400!PID], SuperbillProcedureUid, RevenueCode, RevenueCodeOrder, Charge)
		SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
			   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
			   #XMLClaims_temp.[PROC!450!revenueCode] AS RevenueCode,
			   ROW_NUMBER() OVER( PARTITION BY #xmlClaims_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder,
			   CASE WHEN (ISNUMERIC(#XMLClaims_temp.[PROC!450!Charge]) = 1 ) THEN CONVERT( MONEY, #XMLClaims_temp.[PROC!450!Charge]) ELSE 0 END AS Charge
		FROM #rhc_temp  -- Only grabs those with legacy items
				INNER JOIN #XMLClaims_temp ON #rhc_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
				INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = #XMLClaims_temp.[PROC!450!ID!hide]
		WHERE #rhc_temp.ServiceDateStart < @rhcLegacyDate
			    AND #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
				AND (IsNull([PROC!450!revenueCode],'0') != '0') -- anything WITH a revenue code
		ORDER BY sbp.DisplayOrder

	-- NOTE: #fqhc_temp contains only those procedures with a "legacy" rhc date
	-- test select * from #fqhc_temp

	-- Part F: Remove those without revenue codes (rhc/fqhc)
	DELETE #XMLClaims_temp
	FROM #rhc_temp
			INNER JOIN #XMLClaims_temp ON  #rhc_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
											AND #rhc_temp.ServiceDateStart < @rhcLegacyDate
	WHERE	(#XMLClaims_temp.tag = '450') AND 
			(IsNull(#XMLClaims_temp.[PROC!450!revenueCode],'0') = '0')

	-- 	-- Now create a common table expression summing up like revenue codes based on 
	--  superbill and revenueCode
	-- Then
	--  Update the working table with the total for each revenue code
	--   NOTE:  only change the first revenue code entry since others are duplicates and will be thrown out later
	;with myCTE AS
	(
		select #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode, Sum( #fqhc_temp.Charge) as TotalRevCodeCharge
		from #fqhc_temp
		group by #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode
	)
	UPDATE #fqhc_temp
		SET #fqhc_temp.Charge = myCTE.TotalRevCodeCharge
	FROM #fqhc_temp 
				INNER JOIN myCTE ON #fqhc_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
									AND #fqhc_temp.RevenueCode = myCTE.RevenueCode
	WHERE #fqhc_temp.RevenueCodeOrder = 1 -- Only change the 1st entry of this revenue code

	-- test select * from #fqhc_temp

	-- Now delete all "duplicate" revenue codes
	-- Those in working table with a revenueCodeOrder > 1
	DELETE #XMLClaims_temp
	FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid	
	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
			--AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 0 -- FQHC
			AND #fqhc_temp.RevenueCodeOrder > 1		-- Only delete the duplicate revenue codes after the first one

	--Part G:  Now update the "first" revenue code with the new sum of all revenue codes
	Update #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!Charge] = CONVERT(VARCHAR(10), #fqhc_temp.Charge)
	FROM #XMLClaims_temp 
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	WHERE #XMLClaims_temp.tag = 450 -- proc

	-- Part F: Update claim "Total Charge" now that everything is rolled up
	;WITH myCTE AS
	(
		select #XMLClaims_temp.[CLAIM!400!PID], SUM( CONVERT(MONEY,#XMLClaims_temp.[PROC!450!Charge])) AS TotalCharge 
		from #XMLClaims_temp
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	    WHERE #XMLClaims_temp.tag = 450 -- proc
		GROUP BY #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp 
		SET [CLAIM!400!totalBill] = CONVERT(VARCHAR(10),  mc.TotalCharge)
	FROM #XMLClaims_temp
			INNER JOIN myCTE mc on #XMLClaims_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID]
	WHERE #XMLClaims_temp.tag = 400
	
END
DROP TABLE #rhc_temp
DROP TABLE #fqhc_temp

-----------------------------------------------------------------------------------------------------------------------------------
-- PPS solution
CREATE TABLE #pps_temp
(
		[CLAIM!400!PID] UNIQUEIDENTIFIER		
)
-- Insert into working rhc table ( Only thos with billing type of 0 which is rhc )
INSERT INTO #pps_temp( [CLAIM!400!PID] )
	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID]
	FROM #XMLClaims_temp
	WHERE #XMLClaims_temp.tag = 400 -- CLAIMS
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 1 -- PPS

IF ( EXISTS( SELECT * FROM #pps_temp ) )
BEGIN

	-- Working temp table for pps with claim, sbp, and chcRelApprovalSetting
	CREATE TABLE #ppsProc_temp
	(
			[CLAIM!400!PID] UNIQUEIDENTIFIER,
			[PROC!450!ID!hide] UNIQUEIDENTIFIER,
			InsurancePlanUid UNIQUEIDENTIFIER,
			PostingType int,
			Rate MONEY,
			UseFeeSchedule bit,
			UseAllowedAmount bit
	)	
	
	-- Find ALL PPS procedures from #pps_temp claim table
	--  Get PostingType	( 0 == Post to Financials, 1 == Claim Reference Only
	--		Rate			Rate for now is hard-set rate from CHC settings ( may change based on Posting Type, UseFeeSchedule, UseAllowedAmoount)
	--      UseFeeSchedule	Get Rate value from FeeSchedule ( ClaimingProvider or InsurancePlan or InsuranceCarrier)
	--		UseAllowedAmount  Get Rate value from Amount Allowed Schedule ( InsurancePlan or Insurance Carrier )
	--      
	INSERT INTO #ppsProc_temp([CLAIM!400!PID], [PROC!450!ID!hide], InsurancePlanUid, PostingType, Rate, UseFeeSchedule, UseAllowedAmount)
		SELECT #pps_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!ID!hide], cip.InsurancePlanUid as InsurancePlanUid,
			    coalesce(cras.PostingType,0) as PostingType,
				cras.Rate, COALESCE(cras.UseFeeSchedule,0) AS UseFeeSchedule, COALESCE(cras.UseAllowedAmount,0) AS UseAllowedAmount
		FROM #pps_temp
			INNER JOIN Superbill sb with (nolock) ON #pps_temp.[CLAIM!400!PID] = sb.SuperbillUid
			inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid = sba.SuperbillUid
			INNER JOIN ChcInsurancePlan cip with (nolock) on sba.CurrentInsurancePlanUid = cip.InsurancePlanUid
			INNER JOIN ChcListApprovalSetting cas with (nolock) on cip.ApprovalSettingUid = cas.ApprovalSettingUid
			INNER JOIN ChcApprovalPeriod cap with (nolock) on cas.ApprovalSettingUid = cap.ApprovalSettingUid
																AND (cap.EffectiveDate IS NULL OR sb.ServiceDateStart >= cap.EffectiveDate )
																AND (cap.ExpirationDate	IS NULL OR sb.ServiceDateStart <= cap.ExpirationDate )
			INNER JOIN ChcRelApprovalSetting cras with (nolock) on cap.ApprovalPeriodUid = cras.ApprovalPeriodUid
																AND sba.ServiceSiteUid = cras.ServiceSiteUid
			INNER JOIN #XMLClaims_temp ON #XMLClaims_temp.tag = 450
											AND #pps_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID] 
			INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #XMLClaims_temp.[PROC!450!ProcID] = sbp.SuperbillProcedureUid
																AND sbp.ProcedureUid = cras.ProcedureUid

	-- Reorder procedure "display Order" moving PPS procedures to "top"
	;WITH myCTE AS
	(
		SELECT #pps_temp.[CLAIM!400!PID],  #XMLClaims_temp.[PROC!450!ProcID] as ProcID, #XMLClaims_temp.[PROC!450!count] as OriginalCount,
				CASE WHEN #ppsProc_temp.[PROC!450!ID!hide] IS NULL THEN 0 ELSE 1 END AS ppsProc,
				ROW_NUMBER() OVER( PARTITION BY #pps_temp.[CLAIM!400!PID] 
									ORDER BY CASE WHEN #ppsProc_temp.[PROC!450!ID!hide] IS NULL THEN 0 ELSE 1 END desc,
											 #XMLClaims_temp.[PROC!450!count] asc) AS procOrder

		FROM #pps_temp
			INNER JOIN #XMLClaims_temp ON #XMLClaims_temp.tag = 450
											AND #pps_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID] 
			LEFT OUTER JOIN #ppsProc_temp ON #XMLClaims_temp.[PROC!450!ProcID] = #ppsProc_temp.[PROC!450!ID!hide]
	)
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!count] = mc.procOrder
		FROM #XMLClaims_temp
				INNER JOIN myCTE mc ON #XMLClaims_temp.[PROC!450!ProcID] = mc.ProcID
										AND #XMLClaims_temp.tag = 450

	-- Set rate for any procedure that has posting type of "Claim Reference Only" ( PostingType == 1 )
	-- DEBUGHelp  select * from #ppsProc_temp where #ppsProc_temp.PostingType = 1 -- Claim Reference Only

	-- Posting Type == Claim Reference Only, UseAllowedAmount =1
	UPDATE #ppsProc_temp
		SET #ppsProc_temp.Rate = CASE WHEN ( COALESCE(ip.UseCarrierAmountAllowedFeeSchedule,0) = 0 )
												 THEN COALESCE(fsf.Fee, #ppsProc_temp.Rate, 0)				-- Insurance Amount Allowed or rate or 0
													 ELSE COALESCE(fsfip.Fee, fsf.Fee, #ppsProc_temp.Rate, 0) END	-- Plan Amount Allowed or Insurance Amount allowed or rate or 0
		FROM #ppsProc_temp 
				-- Superbill Procedures
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #ppsProc_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid
				-- Insurance tables
				INNER JOIN InsurancePlan ip WITH (NOLOCK) ON #ppsProc_temp.InsurancePlanUid = ip.InsurancePlanUid
				INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ip.InsuranceCarrierUid = ic.CorporationUid
				-- Amount Allowed - Insurance Carrier Fee
				left outer join FeeSchedule fsAA with (nolock) on ic.AmountAllowedFeeScheduleUid = fsAA.FeeScheduleUid
				left outer join FeeSchedulePeriod fsp with (nolock) on fsAA.FeeScheduleUid = fsp.FeeScheduleUid
															and (fsp.EffectiveDate IS NULL OR sbp.ProcedureServiceDateStart >= fsp.EffectiveDate) 
															and (fsp.ExpirationDate IS NULL OR sbp.ProcedureServiceDateStart <= fsp.ExpirationDate)
				left outer join FeeScheduleFee fsf with (nolock) on fsp.FeeSchedulePeriodUid = fsf.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsf.ProcedureUid
				-- Amount Allowed - Insurance Plan Fee
				left outer join FeeSchedule fsAAip with (nolock) on ip.AmountAllowedFeeScheduleUid = fsAAip.FeeScheduleUid
				left outer join FeeSchedulePeriod fspip with (nolock) on fsAAip.FeeScheduleUid = fspip.FeeScheduleUid
															and (fspip.EffectiveDate IS NULL OR sbp.ProcedureServiceDateStart >= fspip.EffectiveDate) 
															and (fspip.ExpirationDate IS NULL OR sbp.ProcedureServiceDateStart <= fspip.ExpirationDate)
				left outer join FeeScheduleFee fsfip with (nolock) on fspip.FeeSchedulePeriodUid = fsfip.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfip.ProcedureUid
		WHERE #ppsProc_temp.PostingType = 1				-- Claim Reference Only
				AND #ppsProc_temp.UseAllowedAmount = 1  -- Allowed Amount

	-- Posting Type == Claim Reference Only, UseFeeSchedule =1
	UPDATE #ppsProc_temp
		SET #ppsProc_temp.Rate = CASE   WHEN (COALESCE(ip.UseProviderFeeSchedule,0) = 1) 							-- Use Provider Fee Schedule
										THEN COALESCE(fsfPR.Fee, #ppsProc_temp.Rate, 0) 							-- Provider Fee or Rate or 0
										WHEN (COALESCE(ip.UseCarrierFeeSchedule,0) = 0)  
										THEN COALESCE(fsfic.Fee, #ppsProc_temp.Rate, 0)				-- Insurance Carrier Fee  or rate or 0
										ELSE COALESCE(fsfip.Fee, fsfic.Fee, #ppsProc_temp.Rate, 0) END	-- Insurance Plan Fee or Insurance Carrier Fee or rate or 0
		FROM #ppsProc_temp 
				-- Superbill Procedures
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #ppsProc_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid
				-- Superbill Aggregate
				INNER JOIN SuperbillAggregate sba WITH (NOLOCK) ON #ppsProc_temp.[CLAIM!400!PID] = sba.SuperbillUid
				-- Insurance tables
				INNER JOIN InsurancePlan ip WITH (NOLOCK) ON #ppsProc_temp.InsurancePlanUid = ip.InsurancePlanUid
				INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ip.InsuranceCarrierUid = ic.CorporationUid
				INNER JOIN Provider cPR WITH (NOLOCK) ON sba.ClaimingProviderUid = cPR.PersonUid
				-- Fee Schedule - Insurance Carrier fee
				left outer join FeeSchedule fsic with (nolock) on ic.FeeScheduleUid = fsic.FeeScheduleUid
				left outer join FeeSchedulePeriod fspic with (nolock) on fsic.FeeScheduleUid = fspic.FeeScheduleUid
															and (sbp.ProcedureServiceDateStart >= fspic.EffectiveDate or fspic.EffectiveDate is null) 
															and (sbp.ProcedureServiceDateStart <= fspic.ExpirationDate or fspic.ExpirationDate is null)
				left outer join FeeScheduleFee fsfic with (nolock) on fspic.FeeSchedulePeriodUid = fsfic.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfic.ProcedureUid
				-- Fee Schedule - Insurance Plan fee
				left outer join FeeSchedule fsip with (nolock) on ip.FeeScheduleUid = fsip.FeeScheduleUid
				left outer join FeeSchedulePeriod fspip with (nolock) on fsip.FeeScheduleUid = fspip.FeeScheduleUid
															and (sbp.ProcedureServiceDateStart >= fspip.EffectiveDate or fspip.EffectiveDate is null) 
															and (sbp.ProcedureServiceDateStart <= fspip.ExpirationDate or fspip.ExpirationDate is null)
				left outer join FeeScheduleFee fsfip with (nolock) on fspip.FeeSchedulePeriodUid = fsfip.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfip.ProcedureUid
				-- Fee Schedule - Provider
				left outer join FeeSchedule fsPR with (nolock) on cPR.FeeScheduleUid = fsPR.FeeScheduleUid
				left outer join FeeSchedulePeriod fspPR with (nolock) on fsPR.FeeScheduleUid = fspPR.FeeScheduleUid
															and (sbp.ProcedureServiceDateStart >= fspPR.EffectiveDate or fspPR.EffectiveDate is null) 
															and (sbp.ProcedureServiceDateStart <= fspPR.ExpirationDate or fspPR.ExpirationDate is null)
				left outer join FeeScheduleFee fsfPR with (nolock) on fspPR.FeeSchedulePeriodUid = fsfPR.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfPR.ProcedureUid
		WHERE #ppsProc_temp.PostingType = 1				-- Claim Reference Only
				AND #ppsProc_temp.UseFeeSchedule = 1	-- FeeSchedule

	-- DEBUGHelp  select * from #ppsProc_temp where #ppsProc_temp.PostingType = 1 -- Claim Reference Only

	-- Posting Type == Claim Reference Only, Rate specified  in either CHC settings, FeeSchedule or AmountAllowed
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!charge] = #ppsProc_temp.Rate
		FROM #XMLClaims_temp
				INNER JOIN #ppsProc_temp on #XMLClaims_temp.[PROC!450!ProcID] = #ppsProc_temp.[PROC!450!ID!hide]
												AND #ppsProc_temp.PostingType = 1 -- Claim Reference
		WHERE #XMLClaims_temp.tag = 450

	-- Now that the first procedure has changed, change the total billed amount on the claim
	;with myCTE as
	(
		select DISTINCT [CLAIM!400!PID] FROM #ppsProc_temp WHERE PostingType = 1 -- Claim Reference Only
	)
	,myCTE2 as
	(
		select #XMLClaims_temp.[CLAIM!400!PID] as uid,
				sum(cast(coalesce(#XMLClaims_temp.[PROC!450!charge], '0') as decimal(10,2))) as total
		from #XMLClaims_temp
				INNER JOIN myCTE ON #XMLClaims_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
		WHERE #XMLClaims_temp.tag = 450
		group by #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[Claim!400!totalBill] = 
			CASE WHEN mc.total = 0 THEN '0' ELSE CONVERT(varchar(12), mc.total, 128) END  -- new
	From #XMLClaims_temp		
			INNER JOIN myCTE2 mc ON #XMLClaims_temp.[CLAIM!400!PID] = mc.uid
	WHERE #XMLClaims_temp.tag = 400
	
	-- DEBUG  select * from #XMLClaims_temp

	DROP TABLE #ppsProc_temp
END
DROP TABLE #pps_temp
--- CHC Changes end




GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims] AS' 
END
GO


-- 2014-05-29 Bug 29864
-- 2015-02-27 bUG 35706
-- 2015-03-06 Bug 34673
-- 2016-03-09 Task 47436 RHC Detail, dsw, Add CHCBillingtype
-- 2017-04-13 Bug 56452:Patient Name versus Insurance Subscriber Name when Relationship is Self
-- 2016-07-11 Bug 36412 - Country Code

ALTER PROC [dbo].[AR_genXMLClaims]
	@ClaimBatchuid uniqueidentifier,
	@InstanceID uniqueidentifier = null output
AS
/*  
********************************************************************
CYS SC 07/23/09 - Added for Service Site bug (CYS Case #22420):
	[CLAIM!400!BillingProvider_IDType] VARCHAR(50)
	[CLAIM!400!BillingProvider_ID] VARCHAR(50)
********************************************************************
Modified On: 20051011
Modifications Made:	2. For Accident date
			1. For handling WCC Case... added isWCC column to temp table: 20050823

Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
				33768 - Allow ICD10 codes in 4010 837 xml
*/
-- 

/*
General Structure of the return document:
	<PROVIDER>
		<BILLINGPROVIDER/>
		<PAYTOPROVIDER/>
		<SUBSCRIBER>
			<SUBSCRIBER/>
			<PAYER/>
			<PATIENT>
				<PATIENT/>
				<CLAIMS>
					<CLAIM/>
					<RENDERER/>
					<SITE/>
					<PROC/>
					<PROC/>
				</CLAIMS>
			</PATIENT>
		</SUBSCRIBER>
	</PROVIDER>
*/
SET NOCOUNT ON

DECLARE @claimsFetched INT

DECLARE @eClaimFileUID UNIQUEIDENTIFIER
SET @eClaimFileUID = NEWID()

---------------------------------------------------------------------------------------------------------------
-- ICD10 table for payers wanting ICD10 codes
--CREATE TABLE #icd10Payers ( payerUid UNIQUEIDENTIFIER ) ;
--;with myCTE as
--(
--  SELECT COALESCE(XMLValue, '') as XMLValue
--	from ListProductParameter
--	where ProductParameterUid = '38E0B6D3-7421-4172-B4E6-EC94F167DF64'	-- Temp_ICD10_Implementation
--)
--INSERT INTO #icd10Payers
--	SELECT --c.query('.') AS XMLFragment,
--			c.value('(@guid)','UNIQUEIDENTIFIER') AS payerUid
--	FROM myCTE
--		CROSS APPLY XMLValue.nodes('/ICD10Transition/Payer') as t(c)
----SELECT * FROM #icd10Payers

----------------------------------------------------------------------------------------------------------------
CREATE TABLE #XMLClaims_temp (
	tag INT,
	parent INT,
	[SITE!100!PID] UNIQUEIDENTIFIER,
	[SITE!100!eClaimBatchGUID] UNIQUEIDENTIFIER,
	[SITE!100!claimSubmitterID!hide] UNIQUEIDENTIFIER,
	[SITE!100!payToAddressID!hide] UNIQUEIDENTIFIER,
	[PROVIDER!110!PID] VARCHAR(50),
	[CLAIM!400!PID] UNIQUEIDENTIFIER,
	[CLAIM!400!accountNumber] VARCHAR(50),
	[CLAIM!400!MedicalRecordNumber] VARCHAR(50), -- Added for Ak Medicaid by Qatalys
	[CLAIM!400!totalBill] VARCHAR(12),
	[CLAIM!400!diag1] VARCHAR(50),
	[CLAIM!400!diag2] VARCHAR(50),
	[CLAIM!400!diag3] VARCHAR(50),
	[CLAIM!400!diag4] VARCHAR(50),
	[CLAIM!400!diag5] VARCHAR(50),
	[CLAIM!400!diag6] VARCHAR(50),
	[CLAIM!400!diag7] VARCHAR(50),
	[CLAIM!400!diag8] VARCHAR(50),
	[CLAIM!400!diag9] VARCHAR(50),
	[CLAIM!400!diag10] VARCHAR(50),
	[CLAIM!400!diag11] VARCHAR(50),
	[CLAIM!400!diag12] VARCHAR(50),
	[CLAIM!400!patientMemberID] VARCHAR(110),
	[CLAIM!400!patientgroupID] VARCHAR(50),
	[CLAIM!400!patientgroupName] VARCHAR(110),			-- Added for AK Medicadi by Qatalys
	[CLAIM!400!subscriberMemberID] VARCHAR(50),
	[CLAIM!400!authorizeAssignment] TINYINT,
	[CLAIM!400!providerID] VARCHAR(50),
	[CLAIM!400!providerIDType] VARCHAR(50),
	[CLAIM!400!providerGroupID] VARCHAR(50),
	[CLAIM!400!providerGroupIDType] VARCHAR(50),
    [CLAIM!400!providerGroupID2] VARCHAR(50),
	[CLAIM!400!providerGroupIDType2] VARCHAR(50),
	[CLAIM!400!facilityPrimaryID] VARCHAR(50),
	[CLAIM!400!facilityPrimaryIDType] VARCHAR(50),
	[CLAIM!400!facilityID] VARCHAR(50),
	[CLAIM!400!facilityIDType] VARCHAR(50),
	[CLAIM!400!claimFrequencyCode] INT,
	[CLAIM!400!providerSignatureOnFile] VARCHAR(1),
	[CLAIM!400!providerAcceptAssignment] VARCHAR(1),
	[CLAIM!400!patientAcceptAssignment] VARCHAR(1),
	[CLAIM!400!releaseOfInformation] VARCHAR(1),
	[CLAIM!400!patientSignatureSource] VARCHAR(1),
	[CLAIM!400!patientSignatureDate] VARCHAR(20),
	[CLAIM!400!siteType] VARCHAR(2),
	[CLAIM!400!onsetCurrentDate] DATETIME,
	[CLAIM!400!onsetFirstDate] DATETIME,
	[CLAIM!400!onsetFirstDateQualifier] VARCHAR(3), -- dsw 9/24/2018 11329
	[CLAIM!400!noWorkFromDate] DATETIME,
	[CLAIM!400!noWorkToDate] DATETIME,
	[CLAIM!400!hospitalizationStartDate] DATETIME,
	[CLAIM!400!hospitalizationEndDate] DATETIME,
	[CLAIM!400!InitialTreatmentDate] DATETIME,
	[CLAIM!400!familyPlan] INT,
	[CLAIM!400!ClaimNote] VARCHAR(150),	-- Added for AK Medicaid by Qatalys
	[CLAIM!400!Note] VARCHAR(150),	-- Igor 9/29/09 per 2517 had to add this so that AK Medicaid code will not be broken
    [CLAIM!400!NoteReferenceCode] VARCHAR(4),	-- 2517 added 09/28/2009
	[CLAIM!400!relatedCausesCode] VARCHAR(2),
	[CLAIM!400!accidentState] VARCHAR(2),
	[CLAIM!400!accidentDate] DATETIME,
	[CLAIM!400!priorAuthorizationCode] VARCHAR(30),
	[CLAIM!400!SendNPI] BIT,
	[CLAIM!400!Dmerc] BIT,
	[CLAIM!400!SendPQRIproc] BIT,
	[CLAIM!400!Output2310D] BIT, --bug 1420
	[CLAIM!400!OutputAAE] BIT, --bug 5129
	[CLAIM!400!OutputPR] BIT,--added 5/9/2011
	[CLAIM!400!ICN] VARCHAR(80),	--ADDED ICN NUMBER REPORTDED IN LOOP 2300 6/19/08
	[CLAIM!400!EPSDT] BIT, --added 07/21/09
	[CLAIM!400!EPSDTReferralCondIndicator1] VARCHAR(2),--added 07/21/09
	[CLAIM!400!EPSDTReferralCondIndicator2] VARCHAR(2),--added 07/21/09
	[CLAIM!400!EPSDTReferralCondIndicator3] VARCHAR(2),--added 07/21/09
	[CLAIM!400!EPSDTReferralCondIndicator4] VARCHAR(2),--added 07/21/09
	[CLAIM!400!InsuranceTypeCode]VARCHAR(2),
	[CLAIM!400!AuthReferralIndicator] VARCHAR(2), --bug 2570
	[CLAIM!400!DelayReasonCode] VARCHAR(30), --bug 869
	[CLAIM!400!DateLastSeenBySupervising] DATETIME, --bug 249

	--CYS SC 07/23/09 - Added for Service Site bug (CYS Case #22420)
	[CLAIM!400!BillingProvider_IDType] VARCHAR(50),  
	[CLAIM!400!BillingProvider_ID] VARCHAR(50),	
	[CLAIM!400!LMPDate] DATETIME,	
	[CLAIM!400!UserDefinedXml] VARCHAR(8000),
	[CLAIM!400!ResubmissionCode] VARCHAR(50),	 
    [CLAIM!400!SecPayerID] VARCHAR(50),
	[CLAIM!400!SecPayerCode] VARCHAR(50),
	[CLAIM!400!AssumedDate] DATETIME,
	[CLAIM!400!RelinquishedDate] DATETIME,
	[CLAIM!400!PatientPaidAmount] MONEY,
	[CLAIM!400!AccountID] UNIQUEIDENTIFIER,
	[CLAIM!400!AccountName] VARCHAR(50),
	[CLAIM!400!AccountPeriodID] UNIQUEIDENTIFIER,	
	[CLAIM!400!PaperworkTypeID] VARCHAR(2),
	[CLAIM!400!PaperworkTransmissionCodeID] VARCHAR(2),
	[CLAIM!400!PaperworkControlNum] VARCHAR(50),
	[CLAIM!400!Allow5010Codes] BIT,
	[CLAIM!400!UseICD10] BIT,
	[CLAIM!400!ElectronicClaimFormatUid] UNIQUEIDENTIFIER,
	[CLAIM!400!ChcBillingType] int,								-- DSW, ADDED 3/8/2016

	[BILLINGPROVIDER!120!PID] UNIQUEIDENTIFIER,
	[BILLINGPROVIDER!120!LN]	VARCHAR(60),
	[BILLINGPROVIDER!120!FN]	VARCHAR(50),
	[BILLINGPROVIDER!120!MI]	VARCHAR(50),
	[BILLINGPROVIDER!120!address1] VARCHAR(100),
	[BILLINGPROVIDER!120!address2] VARCHAR(100),
	[BILLINGPROVIDER!120!city] VARCHAR(50),
	[BILLINGPROVIDER!120!state] VARCHAR(10),
	[BILLINGPROVIDER!120!zip] VARCHAR(20),
	[BILLINGPROVIDER!120!phone] VARCHAR(30),
	[BILLINGPROVIDER!120!siteType] SMALLINT,
	[BILLINGPROVIDER!120!IDType] VARCHAR(50),
	[BILLINGPROVIDER!120!ID] VARCHAR(50),	
	[BILLINGPROVIDER!120!FCID] UNIQUEIDENTIFIER,
	[BILLINGPROVIDER!120!FileAsGroup] BIT,
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType] VARCHAR(50),
	[BILLINGPROVIDER!120!NPISecID] VARCHAR(50),

	[BILLINGPROVIDER!120!LocationNo] VARCHAR(10),

	[PATIENT!300!PEID] UNIQUEIDENTIFIER,
	[PATIENT!300!PEID2!hide] UNIQUEIDENTIFIER, -- added for #46452
	[PATIENT!300!prefix] VARCHAR(10),
	[PATIENT!300!LN] VARCHAR(50),
	[PATIENT!300!FN] VARCHAR(50),
	[PATIENT!300!MI] VARCHAR(50),
	[PATIENT!300!suffix] VARCHAR(20),
	[PATIENT!300!gender] VARCHAR(50),
	[PATIENT!300!birthdate] VARCHAR(12),
	[PATIENT!300!deathdate] VARCHAR(12),	--Added for AK Medicaid
	[PATIENT!300!employer] VARCHAR(100),
	[PATIENT!300!occupation] VARCHAR(50),
	[PATIENT!300!address1] VARCHAR(100),
	[PATIENT!300!address2] VARCHAR(100),
	[PATIENT!300!city] VARCHAR(50),
	[PATIENT!300!state] VARCHAR(10),
	[PATIENT!300!zip] VARCHAR(20),
	[PATIENT!300!phoneNumber] VARCHAR(30),
	[PATIENT!300!rIDType] VARCHAR(50),
	[PATIENT!300!rID] VARCHAR(50),
	[PATIENT!300!IDType] VARCHAR(50),
	[PATIENT!300!ID] VARCHAR(50),
	[PATIENT!300!patientRelationToInsured] VARCHAR(4),

	[PAYER!230!ID!hide] UNIQUEIDENTIFIER,
	[PAYER!230!CarrierID] UNIQUEIDENTIFIER,
	[PAYER!230!planType!hide] UNIQUEIDENTIFIER,
	[PAYER!230!planType] VARCHAR(4),
	[PAYER!230!orgName] VARCHAR(100),
	[PAYER!230!planName] VARCHAR(100),
	[PAYER!230!address1] VARCHAR(100),
	[PAYER!230!address2] VARCHAR(100),
	[PAYER!230!city] VARCHAR(50),	
    [PAYER!230!Inactive] BIT,       --Added for Inactive Payers
	[PAYER!230!codes] VARCHAR(50), --added for loop2310A
	[PAYER!230!Mammcodes] VARCHAR(50),--added per bug 4974
	[PAYER!230!state] VARCHAR(10),
	[PAYER!230!zip] VARCHAR(20),
	[PAYER!230!phone] VARCHAR(30),
	[PAYER!230!capitated] BIT,
	[PAYER!230!acceptAssignment] VARCHAR(1),
	[PAYER!230!IDType] VARCHAR(50),
	[PAYER!230!ID] VARCHAR(50),
	[PAYER!230!elecPayerID] VARCHAR(50),
	[PAYER!230!rIDType] VARCHAR(50),
	[PAYER!230!rID] VARCHAR(50),
	[PAYER!230!EPSDTCodes] VARCHAR(100), --added for 1430 DMERC
	[PAYER!230!PayerOrgID]	VARCHAR(50), --added 2418 9/29/09
	[PAYER!230!ClearingHouseName] VARCHAR(50), --added 2418 9/29/09
	[PAYER!230!SuperiorMedicaid]VARCHAR(1), -- ADDED FOR 2418 AND 2209
	[PAYER!230!TexasMedicaid] VARCHAR(1), -- ADDED FOR 2418 AND 2209
    [PAYER!230!TaxonomyCode] VARCHAR(50), -- Added for 13369, 13953
   
	[PAYTOPROVIDER!130!PID] UNIQUEIDENTIFIER,
	[PAYTOPROVIDER!130!PEID] UNIQUEIDENTIFIER,
	[PAYTOPROVIDER!130!FN] VARCHAR(50),
	[PAYTOPROVIDER!130!LN] VARCHAR(50),
	[PAYTOPROVIDER!130!orgName] VARCHAR(50),
	[PAYTOPROVIDER!130!address1] VARCHAR(100),
	[PAYTOPROVIDER!130!address2] VARCHAR(100),
	[PAYTOPROVIDER!130!city] VARCHAR(50),
	[PAYTOPROVIDER!130!state] VARCHAR(10),
	[PAYTOPROVIDER!130!zip] VARCHAR(20),
	[PAYTOPROVIDER!130!phone] VARCHAR(30),
	[PAYTOPROVIDER!130!siteType] SMALLINT,
	[PAYTOPROVIDER!130!IDType] VARCHAR(50),
	[PAYTOPROVIDER!130!ID] VARCHAR(50),
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType] VARCHAR(50),
	[PAYTOPROVIDER!130!NPISecID] VARCHAR(50),
	
	[PROC!450!ID!hide] UNIQUEIDENTIFIER,
	[PROC!450!count] SMALLINT,
	[PROC!450!proc] VARCHAR(48),
	[PROC!450!revenueCode] VARCHAR(10), --60093
	[PROC!450!procM1] VARCHAR(8),
	[PROC!450!procM2] VARCHAR(8),
	[PROC!450!procM3] VARCHAR(8),
	[PROC!450!procM4] VARCHAR(8),
	[PROC!450!diag1] SMALLINT,
	[PROC!450!diag2] SMALLINT,
	[PROC!450!diag3] SMALLINT,
	[PROC!450!diag4] SMALLINT,
	[PROC!450!diag5] SMALLINT,
	[PROC!450!diag6] SMALLINT,
	[PROC!450!diag7] SMALLINT,
	[PROC!450!diag8] SMALLINT,
	[PROC!450!diag9] SMALLINT,
	[PROC!450!diag10] SMALLINT,
	[PROC!450!diag11] SMALLINT,
	[PROC!450!diag12] SMALLINT,
	[PROC!450!unitType] VARCHAR(2), --='UN'
	[PROC!450!units] VARCHAR(10),
	[PROC!450!charge] VARCHAR(13),
	[PROC!450!procedureType] VARCHAR(10),
	[PROC!450!procCodeType] VARCHAR(50),
	[PROC!450!procCodeName]VARCHAR(15),
	[PROC!450!description] VARCHAR(255),
	[PROC!450!serviceDate] VARCHAR(12),
	[PROC!450!serviceDateEnd] VARCHAR(12),
	[PROC!450!emergency] VARCHAR(1),
	[PROC!450!serviceLocation] VARCHAR(10),
	[PROC!450!lineControlNo] VARCHAR(50),
	[PROC!450!TotalTax] MONEY,
	[PROC!450!ProcID] UNIQUEIDENTIFIER,
	
    --Defect #11325
    [PROC!450!NoteReferenceCode] VARCHAR(3),
    [PROC!450!Note] VARCHAR(80),
    [PROC!450!NDC]VARCHAR(48),

	[PROC!450!MedicationMeasurementValue] DECIMAL(5,2),
	[PROC!450!MedicationMeasurementReference] BIT,
	[PROC!450!MedicationMeasurementQualifier] VARCHAR(10),
	  -- 2060
    [PROC!450!COST]MONEY,
	[PROC!450!NDCQuantity]varchar(15),
	[PROC!450!NDCUnitMeasure] varchar(2),
	--CYS SC 10/22/09
    [PROC!450!ContractTypeCodeName] VARCHAR(50),
    [PROC!450!ContractTypeCodeAnsi] VARCHAR(10),
	[PROC!450!PaperworkTypeID] VARCHAR(2),
	[PROC!450!PaperworkTransmissionCodeID] VARCHAR(2),
	[PROC!450!PaperworkControlNum] VARCHAR(50),
    [PROC!450!UserDefinedXml] VARCHAR(8000),
	[PROC!450!FamilyPlanning] BIT,

	[PURCHASEDSERVICE!455!PURCHASEDSERVICEUID] UNIQUEIDENTIFIER,
	[PURCHASEDSERVICE!455!Charge] VARCHAR(13),
	[PURCHASEDSERVICE!455!Name] VARCHAR(100),	
	[PURCHASEDSERVICE!455!NPI] VARCHAR(50),
	[PURCHASEDSERVICE!455!orgName] VARCHAR(50),
	[PURCHASEDSERVICE!455!IDType2] VARCHAR(3),	-- 4010, Loop 2310C, Purchased Service Provider Secondary Identification
	[PURCHASEDSERVICE!455!ID2] VARCHAR(50),		-- 4010, Loop 2310C, Purchased Service Provider Secondary Identification
	----	
	[RENDERER!410!ID!hide] UNIQUEIDENTIFIER,	--(50),
	[RENDERER!410!PEID] UNIQUEIDENTIFIER,
	[RENDERER!410!LN] VARCHAR(50),
	[RENDERER!410!FN] VARCHAR(50),
	[RENDERER!410!MI] VARCHAR(50),
	[RENDERER!410!address1] VARCHAR(100),
	[RENDERER!410!address2] VARCHAR(100),
	[RENDERER!410!city] VARCHAR(50),
	[RENDERER!410!state] VARCHAR(10),
	[RENDERER!410!zip] VARCHAR(20),
	[RENDERER!410!dayPhone] VARCHAR(30),
	[RENDERER!410!providerTaxonomyCode] VARCHAR(15),
	[RENDERER!410!rIDType] VARCHAR(50),
	[RENDERER!410!rID] VARCHAR(50),
	[RENDERER!410!IDType] VARCHAR(50),
	[RENDERER!410!ID] VARCHAR(50),
	[RENDERER!410!CLIA] VARCHAR(50),
--  Added for Defect#12625
    [RENDERER!410!MamographyCertNo] VARCHAR(50),
	[RENDERER!410!SendCLIA] BIT,
	[RENDERER!410!SendMamographyCertNo] BIT,
	
 	[SUPERVISING!415!PID] UNIQUEIDENTIFIER,--
	[SUPERVISING!415!LN] VARCHAR(50),--
	[SUPERVISING!415!FN] VARCHAR(50),--
	[SUPERVISING!415!MI] VARCHAR(50),--
	[SUPERVISING!415!orgName] VARCHAR(50),
	[SUPERVISING!415!dayPhone] VARCHAR(30),--
	[SUPERVISING!415!rIDType] VARCHAR(50),--
	[SUPERVISING!415!rID] VARCHAR(50),--
	[SUPERVISING!415!IDType] VARCHAR(50),--
	[SUPERVISING!415!ID] VARCHAR(50),--

-- Added on 6/3/2009 new Supervising Provider
	[REFERRER!420!PEID] UNIQUEIDENTIFIER,
	[REFERRER!420!PID] UNIQUEIDENTIFIER,
	[REFERRER!420!LN] VARCHAR(50),
	[REFERRER!420!FN] VARCHAR(50),
	[REFERRER!420!MI] VARCHAR(50),
	[REFERRER!420!orgName] VARCHAR(50),
	[REFERRER!420!rIDType] VARCHAR(50),
	[REFERRER!420!rID] VARCHAR(50),
	[REFERRER!420!IDType] VARCHAR(50),
	[REFERRER!420!ID] VARCHAR(50),
	[REFERRER!420!providerTaxonomyCode] VARCHAR(15),

 	[ORDERING!425!PID] UNIQUEIDENTIFIER,--
	[ORDERING!425!LN] VARCHAR(50),--
	[ORDERING!425!FN] VARCHAR(50),--
	[ORDERING!425!MI] VARCHAR(50),--
	[ORDERING!425!orgName] VARCHAR(50),
	[ORDERING!425!dayPhone] VARCHAR(30),--
	[ORDERING!425!rIDType] VARCHAR(50),--
	[ORDERING!425!rID] VARCHAR(50),--
	[ORDERING!425!IDType] VARCHAR(50),--
	[ORDERING!425!ID] VARCHAR(50),--

	[SERVICEFACILITY!430!PID] UNIQUEIDENTIFIER,
	[SERVICEFACILITY!430!type] VARCHAR(50),
	[SERVICEFACILITY!430!orgName] VARCHAR(50),
	[SERVICEFACILITY!430!address1] VARCHAR(100),
	[SERVICEFACILITY!430!address2] VARCHAR(100),
	[SERVICEFACILITY!430!city] VARCHAR(50),
	[SERVICEFACILITY!430!state] VARCHAR(10),
	[SERVICEFACILITY!430!zip] VARCHAR(20),
	[SERVICEFACILITY!430!phone] VARCHAR(30),
	[SERVICEFACILITY!430!siteType] SMALLINT,
	[SERVICEFACILITY!430!PrimaryIDType] VARCHAR(50),
	[SERVICEFACILITY!430!PrimaryID] VARCHAR(50),
	[SERVICEFACILITY!430!IDType] VARCHAR(50),
	[SERVICEFACILITY!430!ID] VARCHAR(50),

	[SUBSCRIBER!200!PEID] UNIQUEIDENTIFIER,
	[SUBSCRIBER!200!SSN] VARCHAR(50),
	[SUBSCRIBER!200!prefix] VARCHAR(10),
	[SUBSCRIBER!200!LN] VARCHAR(50),
	[SUBSCRIBER!200!FN] VARCHAR(50),
	[SUBSCRIBER!200!MI] VARCHAR(50),
	[SUBSCRIBER!200!suffix] VARCHAR(20),
	[SUBSCRIBER!200!gender] VARCHAR(50),
	[SUBSCRIBER!200!birthdate] VARCHAR(12),
	[SUBSCRIBER!200!employer] VARCHAR(100),
	[SUBSCRIBER!200!occupation] VARCHAR(50),
	[SUBSCRIBER!200!address1] VARCHAR(100),
	[SUBSCRIBER!200!address2] VARCHAR(100),
	[SUBSCRIBER!200!city] VARCHAR(50),
	[SUBSCRIBER!200!state] VARCHAR(10),
	[SUBSCRIBER!200!zip] VARCHAR(20),
	[SUBSCRIBER!200!country] VARCHAR(2),
	[SUBSCRIBER!200!phoneNumber] VARCHAR(30),
	[SUBSCRIBER!200!rIDType] VARCHAR(50),
	[SUBSCRIBER!200!rID] VARCHAR(50),
	[SUBSCRIBER!200!IDType] VARCHAR(50),
	[SUBSCRIBER!200!ID] VARCHAR(50),
	[SUBSCRIBER!200!payerResponsibility] VARCHAR(4),
	[SUBSCRIBER!200!DisplayOrder] SMALLINT,
	[SUBSCRIBER!200!groupID] VARCHAR(50),
	[SUBSCRIBER!200!groupName] VARCHAR(100),
	[SUBSCRIBER!200!isWCC] BIT,					-- by SM for WCC handling
	[SUBSCRIBER!200!AccountID] UNIQUEIDENTIFIER,
	[SUBSCRIBER!200!AccountPeriodID] UNIQUEIDENTIFIER,
	[SUBSCRIBER!200!Phone1] varchar(20),
	[SUBSCRIBER!200!Phone1Type] varchar(50),
	[SUBSCRIBER!200!Phone2] varchar(20),
	[SUBSCRIBER!200!Phone2Type] varchar(50),
	[SUBSCRIBER!200!Email1] varchar(50),
	[SUBSCRIBER!200!SpecialCase] varchar(50),

	[RESPONSIBLEPARTY!240!ID!hide] UNIQUEIDENTIFIER,
	[RESPONSIBLEPARTY!240!PEID] UNIQUEIDENTIFIER,			--Added by AW for 2010BC loop  2006 03 15
	[RESPONSIBLEPARTY!240!prefix] VARCHAR(10),
	[RESPONSIBLEPARTY!240!LN] VARCHAR(50),
	[RESPONSIBLEPARTY!240!FN] VARCHAR(50),
	[RESPONSIBLEPARTY!240!MI] VARCHAR(50),
	[RESPONSIBLEPARTY!240!suffix] VARCHAR(20),
	[RESPONSIBLEPARTY!240!address1] VARCHAR(100),
	[RESPONSIBLEPARTY!240!address2] VARCHAR(100),
	[RESPONSIBLEPARTY!240!city] VARCHAR(50),
	[RESPONSIBLEPARTY!240!state] VARCHAR(10),
	[RESPONSIBLEPARTY!240!zip] VARCHAR(50),	
	[RESPONSIBLEPARTY!240!contactName] VARCHAR(100),
	[RESPONSIBLEPARTY!240!contact1String] VARCHAR(22),
	[RESPONSIBLEPARTY!240!isCorporation] BIT,
    [FINANCIALCENTER!105!FCID] UNIQUEIDENTIFIER, 	
[FINANCIALCENTER!105!SubmitterID] VARCHAR(50) 	
)

SET @InstanceID = NEWID()

--SELECT CB.ClaimBatchUid, CB.[Status] -- collect up the original to resotre on CATCH if neeed
--	INTO #tempClaimBatchProcessing
--	FROM ClaimBatch CB
--	WHERE ClaimBatchUid = @ClaimBatchuid 
--		AND (CB.[Status] IS NULL OR CB.[Status] = 'Exporting')
	
--BEGIN TRY ------------------------  BEGIN TRY ----------------------------------------

UPDATE ClaimBatch 
	SET Status =  CAST(@InstanceID AS VARCHAR(50)),
		LastModifiedDate = GetUTCDate()
	WHERE ClaimBatchUid = @ClaimBatchuid 
		AND (Status IS NULL OR Status = 'Exporting')

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]
)
SELECT
	100 AS tag,
	NULL AS parent,
	NULL 					AS [SITE!100!PID],
	@ClaimBatchuid				AS [SITE!100!eClaimBatchGUID],
	claimSubmitter.claimSubmitterUid	AS [SITE!100!claimSubmitterID!hide],
	claimSubmitter.PayToServiceSiteUid	AS [SITE!100!payToAddressID!hide]
FROM  claimSubmitter, ClaimBatch
	WHERE ClaimBatch.Status = CAST(@InstanceID AS VARCHAR(50))

EXEC AR_genXMLClaims_CLAIM @ClaimBatchuid, @claimsFetched = @claimsFetched OUTPUT

IF(@claimsFetched > 0)
BEGIN
	EXEC AR_genXMLClaims_FINANCIALCENTER
	EXEC AR_genXMLClaims_PROVIDER
	EXEC AR_genXMLClaims_BILLINGPROVIDER
	EXEC AR_genXMLClaims_PAYTOPROVIDER
	EXEC AR_genXMLClaims_SUBSCRIBER
	EXEC AR_genXMLClaims_PATIENT
	EXEC AR_genXMLClaims_PAYER
	EXEC AR_genXmlClaims_RESPONSIBLEPARTY
	EXEC AR_genXMLClaims_PROC
	EXEC AR_genXMLClaims_PROC_MA -- 60093
	EXEC AR_genXMLClaims_REFERRER
	EXEC AR_genXMLClaims_SUPERVISING
	EXEC AR_genXMLClaims_RENDERER
	EXEC AR_genXMLClaims_SERVICEFACILITY
	SET NOCOUNT OFF

-- Bug 56452:Patient Name versus Insurance Subscriber Name when Relationship is Self
UPDATE #XMLClaims_temp
set [PATIENT!300!PEID2!hide] = [PATIENT!300!PEID]

declare @scrubsubscriber int
set @scrubsubscriber = 0
select @scrubsubscriber = coalesce(lpp.IntegerValue,0) from ListProductParameter lpp
							where ParameterName = 'Scrub.Subscriber' 
if @scrubsubscriber > 0
	UPDATE #XMLClaims_temp
	set  [PATIENT!300!PEID]= [SUBSCRIBER!200!PEID]
	WHERE [PATIENT!300!patientRelationToInsured] = 18
	AND TAG = 300
-- Bug 56452:end changes


	SELECT
	*
	FROM #XMLClaims_temp
	ORDER BY
    [SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
    [FINANCIALCENTER!105!FCID],
	[RENDERER!410!ID!hide],
	[SUBSCRIBER!200!PEID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID],
	[PATIENT!300!PEID2!hide],
	[CLAIM!400!PID],
	[PROC!450!count],
	parent,
	tag
	FOR XML EXPLICIT
END
ELSE
BEGIN
	SELECT
	*
	FROM #XMLClaims_temp
	ORDER BY
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
    [FINANCIALCENTER!105!FCID],
	[RENDERER!410!ID!hide],
	[SUBSCRIBER!200!PEID],
	[PATIENT!300!PEID2!hide],
	[CLAIM!400!PID],
	[PROC!450!count],
	parent,
	tag
	FOR XML EXPLICIT
END

--END TRY ------------------------  END TRY ----------------------------------------

--BEGIN CATCH ------------------------  BEGIN CATCH ----------------------------------------

--UPDATE ClaimBatch -- don't use alias, DBCheck barks on it ... 
--	SET ClaimBatch.[Status] = #tempClaimBatchProcessing.[Status]
--	FROM #tempClaimBatchProcessing
--		INNER JOIN ClaimBatch ON #tempClaimBatchProcessing.ClaimBatchUid = ClaimBatch.ClaimBatchUid

--END CATCH ------------------------  BEGIN CATCH ----------------------------------------


--DROP TABLE #tempClaimBatchProcessing;




GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_SERVICEFACILITY]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_SERVICEFACILITY] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_Inst_SERVICEFACILITY]
AS

--1 SERVICEFACILITY

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide], 	--Added by Shweta

	[PROVIDER!110!PID],			--CYS SC 11/03/08

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SERVICEFACILITY!430!PID],
	[SERVICEFACILITY!430!type],
	[SERVICEFACILITY!430!orgName],
	[SERVICEFACILITY!430!address1],
	[SERVICEFACILITY!430!address2],
	[SERVICEFACILITY!430!city],
	[SERVICEFACILITY!430!state],
	[SERVICEFACILITY!430!zip],
	[SERVICEFACILITY!430!phone],
	[SERVICEFACILITY!430!siteType],
	[SERVICEFACILITY!430!PrimaryIDType],
	[SERVICEFACILITY!430!PrimaryID],
	[SERVICEFACILITY!430!IDType],
	[SERVICEFACILITY!430!ID],
    [FINANCIALCENTER!105!FCID] 
)
SELECT
	430 					AS Tag,
	400 					AS parent,
	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]			AS [CLAIM!400!PID],
	[PATIENT!300!PEID]			AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]		AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]	AS [PAYER!230!ID!hide],			-- added by Shweta

	[PROVIDER!110!PID]		AS [PROVIDER!110!PID],			--CYS SC 11/03/08

	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!ID!hide],
	[SERVICEFACILITY!430!PID]		AS [SERVICEFACILITY!430!PID],
	--FIX ME: I ASsume that this is the Service Facility -NOT- An Idependent Lab or Testing Lab AS we don't capture that information in the app. (ANSIX12N doc p304)
	'FA'					AS [SERVICEFACILITY!430!type],		--'77'
    --Added for Defect #11471
    (CASE WHEN ListServiceSite.FormalName IS NOT NULL THEN ListServiceSite.FormalName
          ELSE ListServiceSite.Name
     END)	AS [SERVICEFACILITY!430!orgName],
     --
	ListServiceSite.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!address1],
	ListServiceSite.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')AS [SERVICEFACILITY!430!address2],
	ListServiceSite.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')AS [SERVICEFACILITY!430!city],
	UPPER(ListServiceSite.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')) AS [SERVICEFACILITY!430!state],
	ListServiceSite.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!zip],
	dbo.stripSpecialChars(ListServiceSite.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS [SERVICEFACILITY!430!phone],			

	ListServiceSiteType.ANSICode		AS [SERVICEFACILITY!430!siteType],
	--FIX ME: I ASsume that the Facility ID is of some special type. We'll probably have to add a setting for this later (see ANSIX12N 837 X098 docs p305)
--	'24'					AS [SERVICEFACILITY!430!IDType],			--XX As it is decided to use ETIN  hence changed to '24'
--	ListServiceSite.FacilityID			AS [SERVICEFACILITY!430!ID]
	[CLAIM!400!facilityPrimaryIDType] 		AS [SERVICEFACILITY!430!PrimaryIDType],
	[CLAIM!400!facilityPrimaryID] 			AS [SERVICEFACILITY!430!PrimaryID],
	[CLAIM!400!facilityIDType] 		AS [SERVICEFACILITY!430!IDType],
	[CLAIM!400!facilityID] 			AS [SERVICEFACILITY!430!ID],
    [FINANCIALCENTER!105!FCID]     AS  [FINANCIALCENTER!105!FCID]
	

/*	  dbo.UDF_getFormatVaribleValue(4,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
      ELSE InsurancePlan.ElectronicClaimFormatUid END,  
      0,provider.PersonUid,NULL,superbill.serviceSiteUID,NULL) AS [CLAIM!400!providerID],  
  dbo.UDF_getFormatVaribleValue(4,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
      ELSE InsurancePlan.ElectronicClaimFormatUid END  
      ,1,provider.PersonUid,NULL,superbill.serviceSiteUID,NULL) AS [CLAIM!400!providerIDType],  */

FROM #XMLClaims_temp
INNER JOIN ListServiceSite on
	ListServiceSite.ServiceSiteUid = #XMLClaims_temp.[SERVICEFACILITY!430!PID]
LEFT JOIN ListServiceSiteType ON
	ListServiceSiteType.ServiceSiteTypeUid = ListServiceSite.ServiceSiteTypeUid
WHERE
	#XMLClaims_temp.tag = 400

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_PROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_PROVIDER] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_Inst_PROVIDER]
AS
BEGIN
	DECLARE @zeroGuid as UniqueIdentifier
	SET @zeroGuid = '00000000-0000-0000-0000-000000000000'

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	--[CLAIM!400!PID],
	[PROVIDER!110!PID],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	
	--CYS SC 10/31/08
--	[ATTENDING!140!PID],
--	[ATTENDING!140!PEID],
--	[ATTENDING!140!FCID],
--	[ATTENDING!140!FileAsGroup],
--	[SUPERVISING!150!PID],
--	[SUPERVISING!150!PEID],
--	[SUPERVISING!150!FCID],
--	[SUPERVISING!150!FileAsGroup],
--	
	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup],
	[PAYTOPROVIDER!130!IDType],
	[PAYTOPROVIDER!130!ID],
	
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType],
	[PAYTOPROVIDER!130!NPISecID],
	
	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID],

/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!IDType_Dr],
	[BILLINGPROVIDER!120!ID_Dr],	
	
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!NPISecIDType_Dr],
	[BILLINGPROVIDER!120!NPISecID_Dr],

    [FINANCIALCENTER!105!FCID]
)
SELECT DISTINCT
	110 								AS	Tag,
	105 								AS	parent,
	[SITE!100!PID]						AS	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS	[SITE!100!payToAddressID!hide],
	--[CLAIM!400!PID]					AS	[CLAIM!400!PID],
	
-- CYS 10/31/08	
	CASE 
		WHEN ISNULL([SUPERVISING!150!PEID],@zeroGuid) <> @zeroGuid THEN [SUPERVISING!150!PEID]
        WHEN ISNULL([ATTENDING!140!PEID] ,@zeroGuid) <> @zeroGuid THEN [ATTENDING!140!PEID]
        ELSE [RENDERER!410!ID!hide]
	END AS [PROVIDER!110!PID],	

	[RENDERER!410!ID!hide]				AS	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID]					AS	[RENDERER!410!PEID],

	--CYS SC 10/31/08
--	[ATTENDING!140!PID]					AS  [ATTENDING!140!PID],
--	[ATTENDING!140!PEID]				AS  [ATTENDING!140!PEID],
--	[ATTENDING!140!FCID]				AS  [ATTENDING!140!FCID],
--	[ATTENDING!140!FileAsGroup]			AS  [ATTENDING!140!FileAsGroup],
--
--	[SUPERVISING!150!PID]				AS	[SUPERVISING!150!PID],
--	[SUPERVISING!150!PEID]				AS	[SUPERVISING!150!PEID],
--	[SUPERVISING!150!FCID]				AS	[SUPERVISING!150!FCID],
--	[SUPERVISING!150!FileAsGroup]		AS	[SUPERVISING!150!FileAsGroup],
	

	[BILLINGPROVIDER!120!FCID]			AS	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup]	AS	[BILLINGPROVIDER!120!FileAsGroup],
	[PAYTOPROVIDER!130!IDType] 			AS	[PAYTOPROVIDER!130!IDType],
	[PAYTOPROVIDER!130!ID] 				AS	[PAYTOPROVIDER!130!ID],
	
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
	[PAYTOPROVIDER!130!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],

	[BILLINGPROVIDER!120!IDType] 		AS	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID] 			AS	[BILLINGPROVIDER!120!ID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!IDType_Dr]		AS [BILLINGPROVIDER!120!IDType_Dr],
	[BILLINGPROVIDER!120!ID_Dr]			AS [BILLINGPROVIDER!120!ID_Dr],	

	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType]	AS	[BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID]		AS	[BILLINGPROVIDER!120!NPISecID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!NPISecIDType_Dr]	AS [BILLINGPROVIDER!120!NPISecIDType_Dr],
	[BILLINGPROVIDER!120!NPISecID_Dr]		AS [BILLINGPROVIDER!120!NPISecID_Dr],

    [FINANCIALCENTER!105!FCID]	        AS  [FINANCIALCENTER!105!FCID]
	
FROM #XMLClaims_temp
WHERE
	#XMLClaims_temp.tag = '400'
END
 

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_REFERRER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_REFERRER] AS' 
END
GO




/*
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/


ALTER PROC [dbo].[AR_genXMLClaims_Inst_REFERRER]
AS

--DEFECT #9657
DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'Provider NPI' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @EINUid UNIQUEIDENTIFIER
SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'ETIN' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @UPINUid UNIQUEIDENTIFIER
SELECT @UPINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'UPIN' AND ISNULL(cfvt1.Inactive, 0) = 0

DECLARE @SSNUid UNIQUEIDENTIFIER
SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0		


INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],		--added by Shweta

	[PROVIDER!110!PID],			--CYS SC 11/03/08

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[REFERRER!420!PEID],
	[REFERRER!420!PID],
	[REFERRER!420!LN],
	[REFERRER!420!FN],
	[REFERRER!420!MI],
	[REFERRER!420!orgName],
	[REFERRER!420!IDType],
	[REFERRER!420!ID],
	[REFERRER!420!rIDType],
	[REFERRER!420!rID],
	[REFERRER!420!providerTaxonomyCode],
    [FINANCIALCENTER!105!FCID]
)
SELECT
	420 						AS tag,
	400 						AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]				AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			-- added by Shweta

	[PROVIDER!110!PID],			--CYS SC 11/03/08

	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],

	Provider.PersonUid				AS [REFERRER!420!PEID],

	Provider.PersonUid				AS [REFERRER!420!PID],

	UPPER(Person.LastName)			AS [REFERRER!420!LN],
	UPPER(Person.FirstName)			AS [REFERRER!420!FN],
	UPPER(Person.MiddleName)			AS [REFERRER!420!MI],

	NULL						AS [REFERRER!420!orgName],
    
	--DEFECT #9657
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				'XX'
			 WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END	
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END			
	END
	AS [REFERRER!420!IDType],
	
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	END
	AS [REFERRER!420!ID],

--	'1G'						AS [REFERRER!420!rIDType],
--	dbo.stripSpecialChars(COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,NULL,NULL) ,Provider.UPIN))		AS [REFERRER!420!rID]

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) = '' THEN '1G'
  ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
    ELSE InsurancePlan.ElectronicClaimFormatUid END,  
     5,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)
 END) AS [REFERRER!420!rIDType],

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) ,'')
ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) 
END) AS [REFERRER!420!rID] ,
ISNULL(ListSpecialty.ANSICode,'')				AS [REFERRER!420!providerTaxonomyCode],
      [FINANCIALCENTER!105!FCID]  AS   [FINANCIALCENTER!105!FCID] 



FROM #XMLClaims_temp
	INNER JOIN Provider ON Provider.PersonUid = #XMLClaims_temp.[REFERRER!420!PID]
	INNER JOIN Person ON Provider.PersonUid = Person.PersonUid
	LEFT JOIN ListSpecialty ON Provider.SpecialtyUid = ListSpecialty.SpecialtyUid
	INNER JOIN Superbill ON Superbill.SuperbillUid = [CLAIM!400!PID]
	INNER JOIN  ViewSuperbillFinancialDetails ON  
		ViewSuperbillFinancialDetails.superbillUid = superbill.SuperbillUid and  
		   superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set. 
INNER JOIN Claimbatchdetail ON 
	Claimbatchdetail.SuperbillUid = Superbill.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
  INNER JOIN account ON  
   account.accountUid = superbill.accountUid  
  INNER JOIN AccountResponsibleParty ON  
   Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
  INNER JOIN AccountPeriod ON  
   AccountPeriod.Accountuid = account.accountUid  
	AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
/*   AND (AccountPeriod.effectiveDate <= superbill.serviceDateEnd  
    AND (AccountPeriod.ExpirationDate IS NULL  
    OR AccountPeriod.ExpirationDate >= superbill.serviceDateEnd) OR AccountPeriod.effectiveDate IS NULL)  */
  INNER JOIN AccountInsurance  ON  
   AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
  INNER JOIN PersonInsurancePlan  
   ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
   AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
  INNER JOIN InsurancePlan  
   ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
  INNER JOIN InsuranceCarrier  
   ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  	

WHERE
	#XMLClaims_temp.tag = 400





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_RENDERER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_RENDERER] AS' 
END
GO


/*  
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/  


ALTER PROC [dbo].[AR_genXMLClaims_Inst_RENDERER]
AS

--DEFECT #9657
DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'Provider NPI' AND ISNULL(cfvt1.Inactive, 0) = 0	

DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @EINUid UNIQUEIDENTIFIER
SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'ETIN' AND ISNULL(cfvt1.Inactive, 0) = 0	

DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

DECLARE @SSNUid UNIQUEIDENTIFIER
SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],				-- added by Shweta
	
	[PROVIDER!110!PID],			--CYS SC 11/03/08
	
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[RENDERER!410!LN],
	[RENDERER!410!FN],
	[RENDERER!410!MI],
	[RENDERER!410!address1],
	[RENDERER!410!address2],
	[RENDERER!410!city],
	[RENDERER!410!state],
	[RENDERER!410!zip],
	[RENDERER!410!dayPhone],
	[RENDERER!410!providerTaxonomyCode],
	[RENDERER!410!rIDType],
	[RENDERER!410!rID],
	[RENDERER!410!IDType],
	[RENDERER!410!ID],
	[RENDERER!410!CLIA],
    --Defect#12625 
	[RENDERER!410!MamographyCertNo],
	[RENDERER!410!SendCLIA],
	[RENDERER!410!SendMamographyCertNo],
    [FINANCIALCENTER!105!FCID]	
)
SELECT
	410 							AS tag,
	400 							AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]					AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			--added by Shweta

	[PROVIDER!110!PID]				AS [PROVIDER!110!PID],	--CYS SC 11/03/08

	Provider.PersonUid				AS [RENDERER!410!ID!hide],
	Provider.PersonUid				AS [RENDERER!410!PEID],
	Person.LastName					AS [RENDERER!410!LN],
	Person.FirstName				AS [RENDERERE!410!FN],
	Person.MiddleName				AS [RENDERER!410!MI],
	Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [RENDERER!410!address1],
	Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [RENDERER!410!address2],
	Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') AS [RENDERER!410!city],
	Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)') AS [RENDERER!410!state],
	Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [RENDERER!410!zip],
	Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)') AS [RENDERER!410!dayPhone],

	ISNULL(ListSpecialty.ANSICode,'')				AS [RENDERER!410!providerTaxonomyCode],
	[CLAIM!400!providerIDType]						AS [RENDERER!410!rIDType],
	[CLAIM!400!providerID]							AS [RENDERER!410!rID],

--[CLAIM!400!SendNPI]
--[BILLINGPROVIDER!120!FileAsGroup]
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		(CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' THEN
				'XX'
			  WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				'24'
			  WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN 
				'34'
			  ELSE ''
		 END)	
	ELSE 
		(CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				'24'
			  WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN 
				'34'
			  ELSE ''
		 END)	
	END AS [RENDERER!410!IDType],

	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
					ELSE	
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'')
				END
			ELSE ''
		END	
	ELSE 
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
					ELSE	
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'')
				END
			ELSE ''
		END
	END AS [RENDERER!410!ID], 
    --Added for Defect# 11482
   dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,10,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid))
      AS [RENDERER!410!CLIA],
 --Defect#12625 
    dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,11,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid))
      AS [RENDERER!410!MamographyCertNo],	
   -- For CLIA#    
    dbo.UDF_SendValue(CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,1,1,Superbill.SuperbillUid) AS [RENDERER!410!SendCLIA],
    --For MAMAOGRAPHY CERT#
	dbo.UDF_SendValue(CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,1,2,Superbill.SuperbillUid) AS  [RENDERER!410!SendMamographyCertNo],

	--dbo.UDFGetProviderCLIA(Provider.PersonUid) 	AS [RENDERER!410!CLIA]
      [FINANCIALCENTER!105!FCID]  AS  [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp
INNER JOIN Provider ON
	Provider.PersonUid = #XMLClaims_temp.[RENDERER!410!PEID]
INNER JOIN Person ON
	Person.PersonUid = Provider.PersonUid
LEFT JOIN ListSpecialty ON 
	Provider.SpecialtyUid = ListSpecialty.SpecialtyUid
LEFT JOIN Superbill ON 
	Superbill.SuperbillUid = [CLAIM!400!PID]
INNER JOIN  ViewSuperbillFinancialDetails ON  
		ViewSuperbillFinancialDetails.superbillUid = superbill.SuperbillUid and  
		   superbill.claimPaper=0 
		and ViewSuperbillFinancialDetails.ClaimingProviderUid = #XMLClaims_temp.[RENDERER!410!PEID] -- Confirm that the drop to paper override isn't set.
LEFT JOIN Claimbatchdetail ON 
	Claimbatchdetail.SuperbillUid = Superbill.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
--Added for Defect # 11482
INNER JOIN InsurancePlan ON 
    Claimbatchdetail.InsuranceplanUid=InsurancePlan.InsuranceplanUid 
INNER JOIN InsuranceCarrier ON
    InsuranceCarrier.CorporationUid = #XMLClaims_temp.[PAYER!230!ID!hide]
--
WHERE
	#XMLClaims_temp.tag = 400






GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_RESPONSIBLEPARTY]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_RESPONSIBLEPARTY] AS' 
END
GO


-- 2015-02-18 dsw 35524 (33744)- Remove validation check for Responsible Party information during EDI creation.

ALTER PROC [dbo].[AR_genXMLClaims_Inst_RESPONSIBLEPARTY]
AS

/*
	Note: Here we are assuming that ClaimPayerID is unique for all carriers. This conclusion has been deducted from 
		the PS - Stored Procedure
*/
	-- 35524 (33744)- Remove validation check for Responsible Party information during EDI creation.
	DECLARE @scrubResponsibleParty bit
	SELECT @scrubResponsibleParty = ( COALESCE( lpp.IntegerValue, 0 ) )
	FROM ListProductParameter lpp with (nolock) 
	WHERE lpp.ProductParameterUid = 'D913C232-E6B2-4D07-8231-043FD80609EF'
		AND lpp.ParameterName = 'Scrub.ResponsibleParty'

	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide],

		[PROVIDER!110!PID],			-- SC 11/03/08

		[RENDERER!410!ID!hide],
		[RENDERER!410!PEID],
		[SUBSCRIBER!200!PEID],
		[RESPONSIBLEPARTY!240!ID!hide],
		[RESPONSIBLEPARTY!240!PEID],
		[RESPONSIBLEPARTY!240!prefix],
		[RESPONSIBLEPARTY!240!LN],
		[RESPONSIBLEPARTY!240!FN],
		[RESPONSIBLEPARTY!240!MI],
		[RESPONSIBLEPARTY!240!suffix],
		[RESPONSIBLEPARTY!240!address1],
		[RESPONSIBLEPARTY!240!address2],
		[RESPONSIBLEPARTY!240!city],
		[RESPONSIBLEPARTY!240!state],
		[RESPONSIBLEPARTY!240!zip],		
		[RESPONSIBLEPARTY!240!contactName],
		[RESPONSIBLEPARTY!240!contact1String],
--		[RESPONSIBLEPARTY!240!IDType],
--		[RESPONSIBLEPARTY!240!ID],
		[RESPONSIBLEPARTY!240!isCorporation],
		[FINANCIALCENTER!105!FCID] 
	)
	SELECT DISTINCT
		240 						AS tag,
		200 						AS parent,

		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],

		[PROVIDER!110!PID],			-- SC 11/03/08

		[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID] 	AS [SUBSCRIBER!200!PEID],

		
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 0 THEN Person.personUId 
		WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 1 THEN Corporation.CorporationUid END 	[RESPONSIBLEPARTY!240!ID!hide],

		-- 35524 - Even though AccountResponsibleParty is different than subscriber, make it "appear" the same so Loop 2010BC does not output
		CASE WHEN @scrubResponsibleParty = 1                 THEN #XMLClaims_temp.[SUBSCRIBER!200!PEID] -- 35524 - 
		     WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 0 THEN Person.personUId 
		     WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 1 THEN Corporation.CorporationUid END 	AS [RESPONSIBLEPARTY!240!PEID],

		' '						AS [RESPONSIBLEPARTY!240!prefix],		-- As Medicare is rejecting the claims because of Mr and Mrs. now we are using as blank

	/*	CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN Person.prefix 
			ELSE NULL END AS [RESPONSIBLEPARTY!240!prefix],*/

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN  UPPER(Person.LastName) 
			ELSE UPPER(Corporation.Name) END 	  AS [RESPONSIBLEPARTY!240!LN],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN  UPPER(Person.FirstName) 
			ELSE NULL END 				  AS [RESPONSIBLEPARTY!240!FN],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN UPPER(Person.MiddleName) 
			ELSE NULL END 			 AS [RESPONSIBLEPARTY!240!MI],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN UPPER(Person.Suffix) 
			 ELSE NULL END 			 AS [RESPONSIBLEPARTY!240!suffix],


	/*	CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN Person.suffix
			ELSE NULL END AS AS [RESPONSIBLEPARTY!240!suffix],		*/ -- As Medicare is rejecting the claims because of Mr and Mrs. now we are using as blank

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN 
			Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!address1],
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN 
			Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!address2],
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN 
			Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!city],
		UPPER(CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN 
			Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		END) AS [RESPONSIBLEPARTY!240!state],
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN 
			Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!zip],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN  UPPER(COALESCE(Person.FirstName +' '+ Person.LastName, '')) 
			WHEN [RESPONSIBLEPARTY!240!isCorporation] = 1 THEN UPPER(COALESCE(Corporation.PrimaryContact, Corporation.SecondaryContact, ''))  END 	  											AS [RESPONSIBLEPARTY!240!contactName],

		--Corporation.Name				AS [RESPONSIBLEPARTY!240!contactName],
		dbo.stripSpecialChars(CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN 
			Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(100)')
		END) AS [RESPONSIBLEPARTY!240!contact1String],
--		'SY'						AS [RESPONSIBLEPARTY!240!IDType],
--		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN dbo.stripSpecialChars(Person.SocialSecurityNumber)
--		ELSE Corporation.ExternalID 	END		 AS [RESPONSIBLEPARTY!240!ID],

--		dbo.stripSpecialChars(Person.SocialSecurityNumber)		AS [RESPONSIBLEPARTY!240!ID],
		[RESPONSIBLEPARTY!240!isCorporation]		AS [RESPONSIBLEPARTY!240!isCorporation],
        [FINANCIALCENTER!105!FCID]					AS [FINANCIALCENTER!105!FCID]   



	FROM #XMLClaims_temp
	LEFT JOIN Person ON
		Person.PersonUid = [RESPONSIBLEPARTY!240!PEID]

	LEFT JOIN Corporation ON
		Corporation.CorporationUid = [RESPONSIBLEPARTY!240!PEID]


-- get address
/*	LEFT JOIN PersonContact ON
		PersonContact.PersonUid = Person.PersonUid
	INNER JOIN Person P ON
		P.PersonUid = PersonContact.ContactPersonUid
*/
	WHERE
		tag  = 400
		AND #XMLClaims_temp.[RESPONSIBLEPARTY!240!PEID] IS NOT NULL





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_OPERATING]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_OPERATING] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_Inst_OPERATING] AS

 -- GET electronicClaimFormat specific info ( group or individual; ssn; etc )
 BEGIN
   Declare @ecf TABLE 
 ( 
   SuperbillUid uniqueidentifier, 
   ElectronicClaimFormatUid uniqueidentifier,
   GroupOrInd varchar(255),
   IsIndividual bit,
   filingTypeSSN bit, 
   NPIOverrideUid uniqueidentifier,		-- Guid of ClaimFormatValueType for NPI override on a specific ElectronicClaimFormat 
   NPIOverrideFixedValue varchar(255)	-- Fixed value for NPI override on a specific ElectronicClaimFormat
 ) ;
 INSERT INTO @ecf( SuperbillUid, ElectronicClaimFormatUid, filingTypeSSN )
	 SELECT sb.SuperbillUid,
	        CASE WHEN ip.UseCarrierElectronicClaimFormat = 1 
				 THEN ic.ElectronicClaimFormatUid  
 				 ELSE ip.ElectronicClaimFormatUid END AS ElectronicClaimFormatUid,
 			0 as filingTypeSSN			-- default is to file for EIN for both group and individual filing types
  FROM #XMLClaims_temp  
  INNER JOIN ClaimBatch cb ON cb.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
  INNER JOIN ClaimBatchDetail cbd ON cbd.ClaimBatchUid = cb.ClaimBatchUid   
  INNER JOIN superbill sb on sb.SuperbillUid = cbd.SuperbillUid --2011 change 
  INNER JOIN SuperbillAggregate sba ON sb.SuperbillUid = sba.SuperbillUid  
  INNER JOIN account act ON act.accountUid = sb.accountUid  
  INNER JOIN AccountPeriod ap ON ap.Accountuid = act.accountUid  
						AND ((ap.effectiveDate IS NOT NULL AND ap.ExpirationDate IS NULL AND ap.effectiveDate <= sb.serviceDateEnd)
						OR (ap.effectiveDate IS NULL AND ap.ExpirationDate IS NOT NULL AND ap.expirationDate >= sb.serviceDateEnd) 
						OR (ap.effectiveDate IS NOT NULL AND ap.ExpirationDate IS NOT NULL AND ap.effectiveDate <= sb.serviceDateEnd
						AND ap.expirationDate >= sb.serviceDateEnd) 
						OR (ap.effectiveDate IS NULL AND ap.ExpirationDate IS NULL))
  INNER JOIN AccountInsurance  ai ON ai.AccountPeriodUid = ap.AccountPeriodUid 
											AND sba.CurrentCarrier = ai.DisplayOrder   
  INNER JOIN PersonInsurancePlan pip ON pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid  
											AND pip.InsurancePlanUid = cbd.InsurancePlanUid  
  INNER JOIN InsurancePlan ip ON ip.InsurancePlanUid = pip.InsurancePlanUid  
  INNER JOIN InsuranceCarrier ic ON ic.CorporationUid = ip.InsuranceCarrierUid   
  LEFT JOIN ViewSuperbillCurrentLiabilityOwnerAndCarrier cl ON sb.superbillUid = cl.superbillUid
WHERE  
  #XMLClaims_temp.tag = 100  and ai.DisplayOrder = cl.CurrentCarrier-- this will make sure that we select current carrier when primary and secondary are the same
 
  --select * from @ecf
  
  Update @ecf
	Set GroupOrInd=	dbo.UDF_getFormatVaribleValue (2, ecf.ElectronicClaimFormatUid ,9,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), -- Electronic==2, Filing Type = 9
	    filingTypeSSN = dbo.UDF_getFormatVariableValue2 (2, ecf.ElectronicClaimFormatUid ,9,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) -- Electronic==2, Filing Type=9, Get Value2 ( If 1 then SSN else EIN )
 FROM @ecf ecf
	INNER JOIN superbill sb on ecf.SuperbillUid = sb.SuperbillUid 
    INNER JOIN ViewSuperbillFinancialDetails ON ViewSuperbillFinancialDetails.superbillUid = sb.SuperbillUid and sb.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
    INNER JOIN provider ON provider.PersonUID = ViewSuperbillFinancialDetails.ClaimingProviderUid    --We have to use RenderingProviderUid  :Aji 2005 10 21 
    INNER JOIN Person p on Provider.PersonUid = p.PersonUid 
	
  Update @ecf
	SET IsIndividual= CASE (ecf.GroupOrInd) WHEN '1' THEN 1
										    WHEN 'individual' THEN 1
										    ELSE 0 END
  FROM @ecf ecf 
  			
  --select * from @ecf
  
  -- Find the NPI Override for the ListClaimFormat ( if one exists )
  UPDATE @ecf
	SET NPIOverrideUid = cfvt.ClaimFormatValueTypeUid,
		NPIOverrideFixedValue = cfo.FixedValue
	FROM @ecf ecf
			INNER JOIN ClaimFormatOption cfo ON ecf.ElectronicClaimFormatUid = cfo.ClaimFormatUid
			INNER JOIN ListClaimFormatOptionType cfot ON cfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			INNER JOIN ListClaimFormatValueType cfvt on cfo.ClaimFormatValueTypeUid = cfvt.ClaimFormatValueTypeUid
	WHERE cfo.ClaimFormatUid = ecf.ElectronicClaimFormatUid								-- cf.Name = 'e-Medicare'
 			--and cfot.ClaimFormatOptionTypeUid = '39EAD079-2603-4D12-9D94-C96585C39185'	-- cfot.Name = 'NPI Override'
			and cfot.Name = 'NPI Override'
 
   --select * from @ecf
 END

DECLARE @mainFinancialCenter as UNIQUEIDENTIFIER
SET @mainFinancialCenter = '14B99C94-EDAC-47BD-97B9-CF421AC16018'

 DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
 SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @ServiceSiteNPIUid UNIQUEIDENTIFIER
 SELECT @ServiceSiteNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Service Site NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @PayToProviderNPIUid UNIQUEIDENTIFIER
 SELECT @PayToProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Pay To Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @SSNUid UNIQUEIDENTIFIER
 SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	
 
 DECLARE @EINUid UNIQUEIDENTIFIER  
 SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

 DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

DECLARE @UPINUid UNIQUEIDENTIFIER
SELECT @UPINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'UPIN' AND ISNULL(cfvt1.Inactive, 0) = 0

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID],		--CYS SC 11/03/08

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[OPERATING!160!PEID],
	[OPERATING!160!FCID],
	[OPERATING!160!FileAsGroup],
	[OPERATING!160!PID],
	--[OPERATING!160!orgName],
	[OPERATING!160!LN],
	[OPERATING!160!FN],
	[OPERATING!160!MI],

	[OPERATING!160!address1],
	[OPERATING!160!address2],
	[OPERATING!160!city],
	[OPERATING!160!state],
	[OPERATING!160!zip],
	[OPERATING!160!phone],
	[OPERATING!160!siteType],
	[OPERATING!160!IDType],
	[OPERATING!160!ID],	

	/* CYS SC - Individual Dr ID regardless of filing type */
	[OPERATING!160!IDType_Dr],
	[OPERATING!160!ID_Dr],	

	--DEFECT #9657
	[OPERATING!160!NPISecIDType],
    [OPERATING!160!NPISecID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[OPERATING!160!NPISecIDType_Dr],
	[OPERATING!160!NPISecID_Dr],

	[OPERATING!160!LocationNo],
    [FINANCIALCENTER!105!FCID],
	[OPERATING!160!SuperbillUid]		--CYS SC 11/04/08
)
SELECT
	160 					AS Tag,
	110 					AS parent,

	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID]				AS [PROVIDER!110!PID],	--CYS SC 11/03/08

	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!PEID],
	[OPERATING!160!PEID] AS [OPERATING!160!PEID],
	[OPERATING!160!FCID]	AS [OPERATING!160!FCID],
	[OPERATING!160!FileAsGroup]	AS	[OPERATING!160!FileAsGroup],
	[OPERATING!160!PID] AS [OPERATING!160!PID],
	[OPERATING!160!LN] AS [OPERATING!160!LN],
	[OPERATING!160!FN] AS [OPERATING!160!FN],
	[OPERATING!160!MI] AS [OPERATING!160!MI],
	[OPERATING!160!address1] AS [OPERATING!160!address1],
	[OPERATING!160!address2] AS [OPERATING!160!address2],
	[OPERATING!160!city] AS [OPERATING!160!city],
	[OPERATING!160!state] AS [OPERATING!160!state],
	[OPERATING!160!zip] AS [OPERATING!160!zip],	
	[OPERATING!160!phone] AS [OPERATING!160!phone],
	
	ListServiceSiteType.ANSICode		AS [OPERATING!160!siteType],

	[OPERATING!160!IDType]		AS [OPERATING!160!IDType],
	[OPERATING!160!ID]			 AS [OPERATING!160!ID],	

	[OPERATING!160!IDType_Dr]		AS [OPERATING!160!IDType_Dr],
	[OPERATING!160!ID_Dr]			AS [OPERATING!160!ID_Dr],	

	--DEFECT #9657
	[OPERATING!160!NPISecIDType]	AS [OPERATING!160!NPISecIDType],
	[OPERATING!160!NPISecID]  	AS [OPERATING!160!NPISecID],

	[OPERATING!160!NPISecIDType_Dr]	AS [OPERATING!160!NPISecIDType_Dr],
	[OPERATING!160!NPISecID_Dr]		AS [OPERATING!160!NPISecID_Dr],

	'0001'					AS [OPERATING!160!LocationNo],
    [FINANCIALCENTER!105!FCID] AS [FINANCIALCENTER!105!FCID],
	[CLAIM!400!PID] AS [OPERATING!160!SuperbillUid]		--CYS SC 11/04/08

FROM #XMLClaims_temp
INNER JOIN dbo.claimsubmitter ON
	claimSubmitter.ClaimSubmitterUid = #XMLClaims_temp.[SITE!100!claimSubmitterID!hide]
LEFT JOIN ListServiceSite ON
	ListServiceSite.serviceSiteUid = claimSubmitter.ClaimSubmitterServiceSiteUid
LEFT JOIN ListServiceSiteType ON
	ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
WHERE
	--#XMLClaims_temp.tag = 110
#XMLClaims_temp.tag = 400


UPDATE #XMLClaims_temp SET [OPERATING!160!FCID] = @mainFinancialCenter
	WHERE tag = '160' AND [OPERATING!160!FCID] IS NULL

UPDATE #XMLClaims_temp SET 

	[OPERATING!160!FileAsGroup] = CASE WHEN (ecf.IsIndividual =1) THEN 0 ELSE 1	 END,
	
	-- Operating should always look at individual rather than "File as Group" -- Bug 24472
	[OPERATING!160!IDType] =
	CASE WHEN lcf.SendNPI = 1 
	     THEN  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' 
					 THEN  'XX'
					 WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' 
					 THEN  '24'  
					 WHEN (ecf.IsIndividual =1) 
					 THEN '34'
					 ELSE ''
				END)  
	ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' 
			   THEN '24'  
			   WHEN (ecf.IsIndividual =1) 
			   THEN '34'
			   ELSE ''
	      END)
	END,	   

	[OPERATING!160!ID] =
	CASE WHEN lcf.SendNPI = 1 
	     THEN (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
		            THEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
			        WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
					THEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
			        WHEN (ecf.IsIndividual =1) 
					THEN CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
							  THEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					          ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') 
						 END
					ELSE ''
			  END) 
		 ELSE (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
					THEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
			        WHEN (ecf.IsIndividual =1) 
					THEN CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
					          THEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					          ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
			         ELSE ''
		        END)
	END,

	/* Individual Dr ID regardless of filing type */
	[OPERATING!160!IDType_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN		
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid, 0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN 'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN  	'24'  
				ELSE '34'
		   END)  
		ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN '24'  
				ELSE '34'
				END)
	END,	   

	[OPERATING!160!ID_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN
		(CASE	WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
					dbo.UDF_getFormatVaribleValue (0,  @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
				WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 	
					dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
				ELSE				
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
		END) 
	ELSE 
		(CASE	
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 	
						dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
			ELSE				
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
  		END)
	END,

	[OPERATING!160!rIDType] = 
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid, 4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN '1G'
	  ELSE 
		dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid, 5,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
	END,

	[OPERATING!160!rID] =
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid,	4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' 
	     THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) ,'')
		 ELSE dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid,	4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) 
	END,
	
	/* Individual Dr ID regardless of filing type */
	/* 12 = OPERATING Physician ID, 13 = OPERATING Physician ID Type in ListClaimFormatOptionType */
	[OPERATING!160!rIDType_Dr] =  
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid, 12,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN '1G'
	  ELSE dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid, 13,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
	END,

	[OPERATING!160!rID_Dr] =	
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid,	12,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' 
	     THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) ,'')
	      ELSE dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid,12,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) 
	END, 

	[OPERATING!160!NPISecIDType] =
	CASE WHEN lcf.SendNPI = 1 
		 THEN 
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' 
				THEN  ''
				WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
				THEN 'EI'
				WHEN (ecf.IsIndividual =1) 
				THEN 'SY'
				ELSE ''
			END)	
    ELSE ''
	END,	

	[OPERATING!160!NPISecID] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 					
			WHEN (ecf.IsIndividual =1) THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 				
					ELSE
						COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
			ELSE
				''
		END)
	ELSE ''
	END,

	/* Individual Dr ID regardless of filing type */
	[OPERATING!160!NPISecIDType_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'EI'
			ELSE 'SY'
		END)	
    ELSE ''
	END,	
	
	/* Individual Dr ID regardless of filing type */
	[OPERATING!160!NPISecID_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 					
			ELSE
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
					dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 				
				ELSE
					COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
		END)
	ELSE ''
	END,
	[OPERATING!160!providerTaxonomyCode] =	ISNULL(ListSpecialty.ANSICode,'')	
FROM #XMLClaims_temp 
	INNER JOIN ClaimBatch ON  ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
	INNER JOIN ClaimBatchDetail ON  ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid   
	INNER JOIN superbill ON superbill.superbillUid = ClaimBatchDetail.SuperBillUid 
				and   superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
	INNER JOIN  ViewSuperbillFinancialDetails ON  ViewSuperbillFinancialDetails.superbillUid = superbill.SuperbillUid 
				and  superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set. 
	INNER JOIN Person Per ON Per.PersonUid = #XMLClaims_temp.[OPERATING!160!PEID]
	INNER JOIN Provider provider on provider.PersonUid = #XMLClaims_temp.[OPERATING!160!PEID]
	LEFT JOIN ListSpecialty ON provider.SpecialtyUid = ListSpecialty.SpecialtyUid
	INNER JOIN account ON  account.accountUid = superbill.accountUid  
	INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  
				AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
				  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
				  OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
				  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
	INNER JOIN AccountInsurance  ON  AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid -- AND AccountInsurance.DisplayOrder = 1
	INNER JOIN PersonInsurancePlan ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
				AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
	INNER JOIN InsurancePlan ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
	INNER JOIN InsuranceCarrier  ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  
	INNER JOIN @ecf ecf ON Superbill.SuperbillUid = ecf.SuperbillUid
	LEFT JOIN ListClaimFormat lcf ON lcf.ClaimFormatUid = (CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid
							ELSE InsurancePlan.ElectronicClaimFormatUid END)	

WHERE TAG = '160'

UPDATE #XMLClaims_temp SET 
	[OPERATING!160!PID] = Per.PersonUid,
	[OPERATING!160!LN]  = UPPER(Per.LastName) ,
	[OPERATING!160!FN]  = UPPER(Per.FirstName) ,
	[OPERATING!160!MI]  = UPPER(Per.MiddleName)  ,
	/*CYS SC */
	[OPERATING!160!LN_Dr] = UPPER(Per.LastName),
	[OPERATING!160!FN_Dr] = UPPER(Per.FirstName),
	[OPERATING!160!MI_Dr] = UPPER(Per.MiddleName),
	/*CYS SC */
	[OPERATING!160!address1] = CASE WHEN [OPERATING!160!FileAsGroup] =  1 THEN fc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') END,
	[OPERATING!160!address2] = CASE WHEN [OPERATING!160!FileAsGroup] =  1 THEN fc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') END,
	[OPERATING!160!city] = CASE WHEN [OPERATING!160!FileAsGroup] =  1 THEN fc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') END,
	[OPERATING!160!state] = UPPER(CASE WHEN [OPERATING!160!FileAsGroup] =  1 THEN fc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/State)[1]', 'VARCHAR(100)') END),
	[OPERATING!160!zip] = CASE WHEN [OPERATING!160!FileAsGroup] =  1 THEN fc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') END,
	[OPERATING!160!phone] = dbo.stripSpecialChars(CASE WHEN [OPERATING!160!FileAsGroup] =  1 THEN fc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)') ELSE Per.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)') END)
FROM #XMLClaims_temp 
	INNER JOIN Person Per ON Per.PersonUid = #XMLClaims_temp.[OPERATING!160!PEID]
	INNER JOIN FinancialCenter Fc ON Fc.FinancialCenterUid = #XMLClaims_temp.[OPERATING!160!FCID]
WHERE tag = '160' 

--We do not want any 150 recs if there is not a SuberbillUB.OPERATINGProviderUid
DECLARE @blankUid AS UNIQUEIDENTIFIER
SET @blankUid = '00000000-0000-0000-0000-000000000000'
DELETE #XMLClaims_temp
WHERE tag = '160' AND ISNULL(#XMLClaims_temp.[OPERATING!160!PEID],@blankUid) = @blankUid

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_PATIENT]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_PATIENT] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_Inst_PATIENT]
AS
-- test
declare @scrubsubscriber int
set @scrubsubscriber = 0
select @scrubsubscriber = coalesce(lpp.IntegerValue,0) from ListProductParameter lpp
							where ParameterName = 'Scrub.Subscriber' 
-- end test

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID],			-- SC 11/03/08

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[CLAIM!400!PID],
	[SUBSCRIBER!200!PEID],
	[PATIENT!300!PEID],
--	[PATIENT!300!SSN],
	[PATIENT!300!prefix],
	[PATIENT!300!LN],
	[PATIENT!300!FN],
	[PATIENT!300!MI],
	[PATIENT!300!suffix],
	[PATIENT!300!gender],
	[PATIENT!300!birthdate],
	[PATIENT!300!employer],
	[PATIENT!300!occupation],
	[PATIENT!300!address1],
	[PATIENT!300!address2],
	[PATIENT!300!city],
	[PATIENT!300!state],
	[PATIENT!300!zip],
	[PATIENT!300!phoneNumber],
	[PATIENT!300!rIDType],
	[PATIENT!300!rID],
	[PATIENT!300!IDType],
	[PATIENT!300!ID],
	[PATIENT!300!patientRelationToInsured],
	[PAYER!230!ID!hide],					-- added by Shweta
    [FINANCIALCENTER!105!FCID]
)
SELECT DISTINCT

	300 					AS tag,
	200 					AS parent,

	[SITE!100!PID]				AS  [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS  [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS  [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS  [SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID],			-- SC 11/03/08

	[RENDERER!410!ID!hide]			AS  [RENDERER!410!ID!hide],
	[RENDERER!410!PEID] 			AS  [RENDERER!410!PEID],
	[CLAIM!400!PID]			AS  [CLAIM!400!PID],
	[SUBSCRIBER!200!PEID]		AS  [SUBSCRIBER!200!PEID],
	
	Person.PersonUid			AS  [PATIENT!300!PEID],		--[PATIENT!300!PEID]
--	Person.SocialSecurityNumber		AS  [PATIENT!300!SSN],

--	Person.Prefix				AS  [PATIENT!300!prefix],
	' '					AS  [PATIENT!300!prefix],		-- As Medicare is rejecting the claims because of Mr and Mrs. now we are using as blank
	UPPER(Person.LastName)		AS  [PATIENT!300!LN],
	UPPER(Person.FirstName)		AS  [PATIENT!300!FN],
	UPPER(Person.MiddleName)		AS  [PATIENT!300!MI],
	Person.Suffix				AS  [PATIENT!300!suffix],
--	' '					AS  [PATIENT!300!suffix],		-- As Medicare is rejecting the claims because of Mr and Mrs. now we are using as blank

	ListGender.ANSICode			AS  [PATIENT!300!gender],
	CONVERT(VARCHAR(10),Person.BirthDate,101)	AS  [PATIENT!300!birthdate],
	Corporation.Name			AS  [PATIENT!300!employer],  
	ListOccupation.Name		AS  [PATIENT!300!occupation],

	Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [PATIENT!300!address1],
	Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') AS  [PATIENT!300!address2],
	Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') AS  [PATIENT!300!city],
	Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)') AS  [PATIENT!300!state],
	Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') AS  [PATIENT!300!zip],
	dbo.stripSpecialChars(Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS  [PATIENT!300!phoneNumber],
	
	'SY'							AS  [PATIENT!300!rIDType],
	dbo.stripSpecialChars(Person.SocialSecurityNumber)	AS  [PATIENT!300!rID],
	'MI'							AS  [PATIENT!300!IDType],
	dbo.stripSpecialChars([CLAIM!400!patientMemberID])	AS  [PATIENT!300!ID],

	[PATIENT!300!patientRelationToInsured],
	[PAYER!230!ID!hide]					AS [PAYER!230!ID!hide],			-- added by Shweta
     [FINANCIALCENTER!105!FCID] AS  [FINANCIALCENTER!105!FCID] 

FROM #XMLClaims_temp

LEFT JOIN Person ON
	Person.PersonUid = #XMLClaims_temp.[PATIENT!300!PEID]
--	AND #XMLClaims_temp.[PATIENT!300!PEID] <> #XMLClaims_temp.[SUBSCRIBER!200!PEID]

LEFT JOIN ListGender ON
	Person.GenderUid = ListGender.GenderUid

LEFT JOIN PersonEmployer ON
	Person.PersonUid = PersonEmployer.PersonUid

LEFT JOIN Employer ON
	PersonEmployer.PersonUid = Employer.CorporationUid

LEFT JOIN Corporation ON
	Employer.CorporationUid = Corporation.CorporationUid

LEFT JOIN ListOccupation ON
	PersonEmployer.OccupationUid = ListOccupation.OccupationUid

WHERE
	#XMLClaims_temp.tag = 400

	AND #XMLClaims_temp.[PATIENT!300!PEID] <> #XMLClaims_temp.[SUBSCRIBER!200!PEID]
	AND (@scrubsubscriber = 0 OR #XMLCLaims_temp.[PATIENT!300!patientRelationToInsured] <> 18 )








GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_PAYER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_PAYER] AS' 
END
GO




ALTER PROC [dbo].[AR_genXMLClaims_Inst_PAYER]
AS

/*
	Note: Here we are assuming that ClaimPayerID is unique for all carriers. This conclusion has been deducted from 
		the PS - Stored Procedure
*/

/* Need to retrieve */
	DECLARE @ClaimFormatUid uniqueidentifier
	--DECLARE @FinancialCenterUid uniqueidentifier
	DECLARE @taxonomyClaimFormatValueTypeUid uniqueidentifier
	DECLARE @submitterIDClaimFormatValueTypeUid uniqueidentifier
	
	SET @ClaimFormatUid = null;
	;with thisClaim
	as
	(
		select top 1 xt.[SITE!100!eClaimBatchGUID] AS batchGuid
		from #XMLClaims_temp xt
		where xt.[SITE!100!eClaimBatchGUID] IS NOT NULL
	)
	select @ClaimFormatUid = CASE IP.UseCarrierElectronicClaimFormat 
			WHEN 1 THEN IC.ElectronicClaimFormatUId
			ELSE IP.ElectronicClaimFormatUId END
			--@FinancialCenterUid = sba.FinancialCenterUid 
	from --ClaimBatch cb
		--	inner join ClaimBatchDetail cbd on cb.ClaimBatchUid = cbd.ClaimBatchUid
		 ClaimBatchDetail cbd 
			inner join thisClaim tc on cbd.ClaimBatchUid = tc.batchGuid
			inner join Superbill sb on cbd.SuperbillUid = sb.SuperbillUid
			inner join SuperbillAggregate sba on sb.SuperbillUid = sba.SuperbillUid -- Need current insurance liability owner
			inner join AccountPeriod ap on sb.AccountUid = ap.AccountUid
											AND (ap.EffectiveDate IS NULL OR (ap.EffectiveDate <= sb.ServiceDateStart) )
											AND (ap.ExpirationDate IS NULL OR (ap.ExpirationDate >= sb.ServiceDateStart) )
			inner join AccountInsurance ai on ap.AccountPeriodUid = ai.AccountPeriodUid
												and ai.DisplayOrder = 
														coalesce( sba.CurrentCarrier, sb.CurrentCarrierOverride, 1 ) 
														-- Order of preference
														-- 1) Current Carrier from aggregate
														-- 2) Superbill liability owner flag
														-- 3) Primary ( last resort )
			inner join PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			inner join InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
			inner join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
				
	--where cb.ClaimBatchUid = '64988181-5BF3-4DEA-BC65-77C5917F3898'
	SET @taxonomyClaimFormatValueTypeUid = null
	select @taxonomyClaimFormatValueTypeUid=lcfvt.ClaimFormatValueTypeUid--, lcfvt.*
	from ListClaimFormatOptionType lcfot
			inner join ListClaimFormatType lcft on lcfot.ClaimFormatTypeUid = lcft.ClaimFormatTypeUid
			inner join ClaimFormatOption cfo on lcfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			inner join ListClaimFormat lcf on cfo.ClaimFormatUid = lcf.ClaimFormatUid
			inner join ListClaimFormatValueType lcfvt on cfo.ClaimFormatValueTypeUid = lcfvt.ClaimFormatValueTypeUid
	where lcfot.ClaimFormatOptionTypeUid = 'B177D193-3402-4C0C-96DE-B4D11BE60346'		-- Taxonomy Code ( Institutional )
			and cfo.ClaimFormatUid = @ClaimformatUid -- 'F43FD3CD-C30F-4CF3-A579-3759DA6441F0'				-- Claim Format ( i.e. e-Medicare )
	-- Submitter ID 
	SET @submitterIDClaimFormatValueTypeUid = null
	select @submitterIDClaimFormatValueTypeUid=lcfvt.ClaimFormatValueTypeUid--, lcfvt.*
	from ListClaimFormatOptionType lcfot
			inner join ListClaimFormatType lcft on lcfot.ClaimFormatTypeUid = lcft.ClaimFormatTypeUid
			inner join ClaimFormatOption cfo on lcfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			inner join ListClaimFormat lcf on cfo.ClaimFormatUid = lcf.ClaimFormatUid
			inner join ListClaimFormatValueType lcfvt on cfo.ClaimFormatValueTypeUid = lcfvt.ClaimFormatValueTypeUid
	where lcfot.ClaimFormatOptionTypeUid = 'EC66D3D8-193B-416E-95B4-3A5DC1D088B4'		-- Submitter ID on electronic payer
			and cfo.ClaimFormatUid = @ClaimformatUid -- 'F43FD3CD-C30F-4CF3-A579-3759DA6441F0'				-- Claim Format ( i.e. e-Medicare )

		

	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide],

		[PROVIDER!110!PID],			-- SC 11/03/08		

		[RENDERER!410!ID!hide],
		[RENDERER!410!PEID],
		[SUBSCRIBER!200!PEID],
		[PAYER!230!ID!hide],
		[PAYER!230!CarrierID],
		[PAYER!230!planType],
		[PAYER!230!orgName],
		[PAYER!230!planName],
		[PAYER!230!address1],
		[PAYER!230!address2],
		[PAYER!230!city],
		[PAYER!230!state],
		[PAYER!230!zip],
		[PAYER!230!phone],
		[PAYER!230!capitated],
		[PAYER!230!acceptAssignment],
		[PAYER!230!Inactive],  --Added for Inactive Insurance Payer.
		[PAYER!230!IDType],
		[PAYER!230!ID],
		[PAYER!230!elecPayerID],
		--[PAYER!230!rIDType],
		--[PAYER!230!rID]
		--,[SUBSCRIBER!200!SBUid!Hide]
		[PAYER!230!TaxonomyCode],  -- added for 13369, 13953 3/21/12
         [FINANCIALCENTER!105!FCID],
         [FINANCIALCENTER!105!SubmitterID]   
	)
	SELECT DISTINCT
		230 						AS tag,
		200 						AS parent,

		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
		
		[PROVIDER!110!PID],			-- SC 11/03/08

		[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID] 	AS [SUBSCRIBER!200!PEID],

		InsuranceCarrier.CorporationUid			AS [PAYER!230!ID!hide], --InsurancePlan.InsurancePlanUid
		InsuranceCarrier.CorporationUid			AS [PAYER!230!CarrierID],
--		'ZZ'						AS [PAYER!230!planType], --Default to 'other' AS I don't think Per-Se uses this.
--		ISNULL(ListAccountType.ExternalId, 'ZZ')		AS [PAYER!230!planType], 
--CYS SC
--		COALESCE (ListAccountType.ExternalId, '') AS [PAYER!230!planType],
--CYS SC 04/03/09
--		Corporation.ExternalId			AS [PAYER!230!planType],		/*MA for Medicare A, or MB for Medicare B */
		SUBSTRING(COALESCE (ListAccountType.ANSICode, ''), 1, 4) AS [PAYER!230!planType],
		Corporation.Name				AS [PAYER!230!orgName],
		InsurancePlan.Name				AS [PAYER!230!planName],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN
			Corporation.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!address1],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN
			Corporation.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!address2],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN
			Corporation.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!city],
		UPPER(CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN
			Corporation.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		END) AS [PAYER!230!state],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN
			Corporation.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!zip],
		dbo.stripSpecialChars(CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN
			Corporation.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		ELSE
			InsurancePlan.Phone.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		END) AS [PAYER!230!phone],
		InsurancePlan.IsCapitated			AS [PAYER!230!capitated],	

		(CASE WHEN InsuranceCarrier.AcceptAssignment = 1 THEN
			'A'
		ELSE
			'C'
		END)						AS [PAYER!230!acceptAssignment],
		--Added for Inactive Insurance Payer.
        InsuranceCarrier.Inactive  	AS [PAYER!230!Inactive],

		'PI'						AS [PAYER!230!IDType],
--		ISNULL(lep.ClearingHousePayerID,'9999999')	AS [PAYER!230!ID],
		lep.ClearingHousePayerID 			AS [PAYER!230!ID],
		ISNULL(CAST(lep.ElectronicPayerUid AS VARCHAR(50)),'')			AS [PAYER!230!elecPayerID],
		dbo.UDF_getFormatVaribleValue(0, @taxonomyClaimFormatValueTypeUid, 0, NULL, NULL, NULL, NULL, [FINANCIALCENTER!105!FCID]) AS [PAYER!230!TaxonomyCode],
        [FINANCIALCENTER!105!FCID] AS   [FINANCIALCENTER!105!FCID],	
   		[FINANCIALCENTER!105!SubmitterID] AS [FINANCIALCENTER!105!SubmitterID]
	FROM #XMLClaims_temp
	INNER JOIN InsurancePlan ON InsurancePlan.InsurancePlanUid = [PAYER!230!planType!hide]	--ClaimBatchDetail.InsurancePlanUid
	INNER JOIN InsuranceCarrier ON InsuranceCarrier.CorporationUid = [PAYER!230!ID!hide]		--InsurancePlan.InsuranceCarrierUid --[PAYER!230!ID!hide]
	INNER JOIN Corporation ON Corporation.CorporationUid = InsuranceCarrier.CorporationUid

	LEFT JOIN ListAccountType ON ListAccountType.AccountTypeUid =-- InsuranceCarrier.AccountTypeUid	
	CASE WHEN InsurancePlan.UseInsuranceCarrierAccountType = 1 THEN InsuranceCarrier.AccountTypeUid		--Added by Aji 2006 03 22
		ELSE InsurancePlan.AccountTypeUid END

	LEFT JOIN ListElectronicPayer lep ON lep.ElectronicPayerUid = InsuranceCarrier.ElectronicPayerUid

--	INNER JOIN ClaimBatchDetail ON ClaimBatchDetail.ClaimBatchUId = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]
		--AND ClaimBatchDetail.SuperbillUid =  #XMLClaims_temp.[SUBSCRIBER!200!SBUid!Hide]

	WHERE
		tag IN (200)	
		AND [PAYER!230!ID!hide] IS NOT NULL






GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_PAYTOPROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_PAYTOPROVIDER] AS' 
END
GO



ALTER PROC [dbo].[AR_genXMLClaims_Inst_PAYTOPROVIDER] AS

	DECLARE @zeroGuid as UniqueIdentifier
	SET @zeroGuid = '00000000-0000-0000-0000-000000000000'
	
INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[PAYTOPROVIDER!130!PID],
	[PAYTOPROVIDER!130!PEID],
	[PAYTOPROVIDER!130!orgName],
	[PAYTOPROVIDER!130!FN],
	[PAYTOPROVIDER!130!LN],
	[PAYTOPROVIDER!130!address1],
	[PAYTOPROVIDER!130!address2],
	[PAYTOPROVIDER!130!city],
	[PAYTOPROVIDER!130!state],
	[PAYTOPROVIDER!130!zip],
	[PAYTOPROVIDER!130!phone],
	[PAYTOPROVIDER!130!IDType],
	[PAYTOPROVIDER!130!ID],

	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType],
    [PAYTOPROVIDER!130!NPISecID],

	[Provider!110!PID],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
     [FINANCIALCENTER!105!FCID] 
)

SELECT DISTINCT
	130 								AS Tag,
	110 								AS parent,
	[SITE!100!PID]						AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	ListServiceSite.ServiceSiteUid		AS [PAYTOPROVIDER!130!PID],

	NULL								AS [PAYTOPROVIDER!130!PEID],

	-- BILLINGPROVIDER!120!FileAsGroup not used to determine ListServiceSite or Corporation.  
	-- ALWAYS assume corporation
	--CASE [BILLINGPROVIDER!120!FileAsGroup] WHEN 0 
	--                                       THEN ListServiceSite.Name	
	--									   ELSE Corporation.Name END	AS [PAYTOPROVIDER!130!orgName],
	ListServiceSite.Name AS [PAYTOPROVIDER!130!orgName],
	NULL								AS [PAYTOPROVIDER!130!FN],  
	NULL								AS [PAYTOPROVIDER!130!LN], -- Assumes always orgName
	ListServiceSite.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!address1],
	ListServiceSite.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!address2],
	ListServiceSite.[Address].value('(/Address/City)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!city],
	UPPER( ListServiceSite.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')) AS [PAYTOPROVIDER!130!state],
	ListServiceSite.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!zip],
	dbo.stripSpecialChars( ListServiceSite.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS [PAYTOPROVIDER!130!phone],

    -- Use Billing provider identification
	--[PAYTOPROVIDER!130!IDType] 						AS [PAYTOPROVIDER!130!IDType],
	--[PAYTOPROVIDER!130!ID]							AS [PAYTOPROVIDER!130!ID],	
	--[PAYTOPROVIDER!130!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
 --   [PAYTOPROVIDER!130!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],
	[BILLINGPROVIDER!120!IDType] 		AS [PAYTOPROVIDER!130!IDType],
	[BILLINGPROVIDER!120!ID]			AS [PAYTOPROVIDER!130!ID],	
	[BILLINGPROVIDER!120!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
    [BILLINGPROVIDER!120!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],
    
    #XMLClaims_temp.[PROVIDER!110!PID]	AS [PROVIDER!110!PID], -- #XMLClaim_temp where tag is 110 ( Provider )
    
	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]					AS [RENDERER!410!PEID],
    [FINANCIALCENTER!105!FCID]          AS  [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp
	INNER JOIN dbo.claimsubmitter ON #XMLClaims_temp.[SITE!100!claimSubmitterID!hide] = claimSubmitter.ClaimSubmitterUid 
	LEFT JOIN ListServiceSite ON claimSubmitter.PayToServiceSiteUid = ListServiceSite.ServiceSiteUid 
	INNER JOIN Provider ON Provider.PersonUid = [RENDERER!410!PEID]
	LEFT JOIN Corporation ON Provider.PayToProviderCorporationUid = Corporation.CorporationUid
	LEFT JOIN ListServiceSiteType ON ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
WHERE
	#XMLClaims_temp.tag = 110 AND
	#XMLClaims_temp.[SITE!100!payToAddressID!hide] IS NOT NULL
	AND LEN(#XMLClaims_temp.[SITE!100!payToAddressID!hide]) > 0

UNION ALL

SELECT DISTINCT
	130 							AS Tag,
	110 							AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	NULL					AS [PAYTOPROVIDER!130!PID],
	Provider.PersonUid		AS [PAYTOPROVIDER!130!PEID],
	NULL					AS [PAYTOPROVIDER!130!orgName],
	NULL					AS [PAYTOPROVIDER!130!FN],
	NULL					AS [PAYTOPROVIDER!130!LN],
	NULL					AS [PAYTOPROVIDER!130!address1],
	NULL					AS [PAYTOPROVIDER!130!address2],
	NULL					AS [PAYTOPROVIDER!130!city],
	NULL					AS [PAYTOPROVIDER!130!state],
	NULL					AS [PAYTOPROVIDER!130!zip],
	NULL					AS [PAYTOPROVIDER!130!phone],
-- 24 = Employers Identification Number | 34 = Social Security Number
	[PAYTOPROVIDER!130!IDType] 		AS [PAYTOPROVIDER!130!IDType],
	[PAYTOPROVIDER!130!ID]			AS [PAYTOPROVIDER!130!ID],

    NULL	 AS 	[PAYTOPROVIDER!130!NPISecIDType],
    NULL	 AS	    [PAYTOPROVIDER!130!NPISecID],
    #XMLClaims_temp.[PROVIDER!110!PID]	AS [PROVIDER!110!PID], -- #XMLClaim_temp where tag is 110 ( Provider )
	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
    [FINANCIALCENTER!105!FCID]          AS  [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp
	INNER JOIN Provider ON #XMLClaims_temp.[RENDERER!410!ID!hide] = Provider.PersonUid 
WHERE
	#XMLClaims_temp.tag = 110 AND
	#XMLClaims_temp.[SITE!100!payToAddressID!hide] IS NULL





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_getClaimFormatProcedureOverrideValues]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_getClaimFormatProcedureOverrideValues] AS' 
END
GO


ALTER PROC [dbo].[AR_getClaimFormatProcedureOverrideValues]
(	@ClaimFormatUid  UNIQUEIDENTIFIER,
	@ClaimFormatValueTypeTypeUid UNIQUEIDENTIFIER,
	@iProcedureUid UNIQUEIDENTIFIER,
	@Value VARCHAR(255) OUT,
	@Value2 VARCHAR(255) OUT,
	@Value3 VARCHAR(255) OUT,
	@Value4 VARCHAR(255) OUT, 
	@Value5 VARCHAR(255) OUT, 
	@Value6 VARCHAR(255) OUT 

)
 AS
BEGIN

--Procedure Override Format Value
If @ClaimFormatValueTypeTypeUid Is NULL
	SET @ClaimFormatValueTypeTypeUid = 'ae114249-40bc-49dd-a0e6-702fe4b7aab1'

DECLARE @ClaimFormatTypeUid AS UNIQUEIDENTIFIER
SELECT @ClaimFormatTypeUid = ClaimFormatTypeUid
FROM ListClaimFormat 
WHERE ClaimFormatUid = @ClaimFormatUid

DECLARE @ClaimFormatOptionTypeUid AS UNIQUEIDENTIFIER
SELECT @ClaimFormatOptionTypeUid = ClaimFormatOptionTypeUid
FROM ListClaimFormatOptionType 
WHERE ClaimFormatTypeUid = @ClaimFormatTypeUid AND 
	ClaimFormatValueTypeTypeUid = @ClaimFormatValueTypeTypeUid

DECLARE @ClaimFormatValueTypeUid   AS UNIQUEIDENTIFIER
SELECT @ClaimFormatValueTypeUid = ClaimFormatValueTypeUid
	FROM ClaimFormatOption
WHERE ClaimFormatUid = @ClaimFormatUid AND 
	  ClaimFormatOptionTypeUid = @ClaimFormatOptionTypeUid

SELECT	@Value = ISNULL(ClaimFormatValue.value,''),	
		@Value2 = ISNULL(ClaimFormatValue.value2,''),
		@Value3 = ISNULL(ClaimFormatValue.value3,''),
		@Value4 = ISNULL(ClaimFormatValue.value4,''),
		@Value5 = ISNULL(ClaimFormatValue.value5,''),
		@Value6 = ISNULL(ClaimFormatValue.value6,'')
FROM ClaimFormatValue
WHERE ClaimFormatValueTypeUid = @ClaimFormatValueTypeUid AND 
	  ProcedureUid = @iProcedureUid

END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_PROC]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_PROC] AS' 
END
GO
-- 2014-09-02 dsw - Added code to sum procedure charges for claim
-- 2014-12-05 dsw - 34159 Performance improvements by using SuperbillAggregate.AccountPeriod
-- 2016-01-08 dsw - 44998, Changed float to decimal(10,2) when summing charge.  Got imprecision otherwise
-- 2016-03-09 dsw - 47436, Added ChcBillingType
-- 2016-07-28 dsw - 49368 - 5th digit on Rev Code needs to be suppressed.
-- 2016-10-27 dsw - 51952 - Added TotalTax, [CLAIM!400!ElectronicClaimFormatUid], [PROC!450!procCodeName

ALTER PROC [dbo].[AR_genXMLClaims_Inst_PROC]
AS
	-- Find/Map procedure substitution text
	DECLARE @ProcedureAliases TABLE -- As defined by the map items table
	(
	  superbillProcedureUid uniqueidentifier,
	  aliasText varchar(200),
	  rowNo int
	)
	INSERT INTO @ProcedureAliases(superbillProcedureUid, aliasText, rowNo)
		select sbp.SuperbillProcedureUid, mi.SubstitutionText, ROW_NUMBER() OVER( PARTITION BY sbp.SuperbillProcedureUid ORDER BY mi.LastModifiedDate desc)
		FROM #XMLClaims_temp
			  INNER JOIN SuperbillProcedure sbp ON sbp.superbillUid = #XMLClaims_temp.[CLAIM!400!PID]
												AND ISNULL(sbp.DontClaim,0) = 0
			  INNER JOIN Superbill sb on 	sbp.SuperbillUid = sb.SuperbillUid
			  INNER JOIN SuperbillAggregate sa on sb.SuperbillUid = sa.SuperbillUid
			  INNER JOIN Account act on sb.AccountUid = act.AccountUid
			  --INNER JOIN AccountPeriod ap on act.AccountUid = ap.AccountUid
	  		--								and (ap.EffectiveDate IS NULL OR ( ap.EffectiveDate <= sb.ServiceDateEnd) ) 
	  		--								and (ap.ExpirationDate IS NULL OR ( ap.ExpirationDate >= sb.ServiceDateEnd))
			  INNER JOIN AccountInsurance ai on sa.AccountPeriodUid = ai.AccountPeriodUid
												and sa.CurrentCarrier = ai.DisplayOrder
			  INNER JOIN PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			  INNER JOIN InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
			  INNER JOIN MapItem mi on ip.InsuranceCarrierUid = mi.FindTableFromItemUid
											and sbp.ProcedureUid = mi.FindTableToItemUid 

	--SELECT *
	--FROM @ProcedureAliases

	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide],

		[PROVIDER!110!PID],         -- SC 11/03/08  

		[RENDERER!410!ID!hide],
		[RENDERER!410!PEID],
		[CLAIM!400!PID],
	    [CLAIM!400!ChcBillingType],								-- DSW, ADDED 3/8/2016
		[PATIENT!300!PEID],
		[SUBSCRIBER!200!PEID],
		[PAYER!230!ID!hide],            -- addedby Shweta
		[PROC!450!ID!hide],
		[PROC!450!count],
		[PROC!450!proc],
		[PROC!450!revenueCode],         /* CYS SC */
		[PROC!450!procM1],
		[PROC!450!procM2],
		[PROC!450!procM3],
		[PROC!450!procM4],
		[PROC!450!diag1],
		[PROC!450!diag2],
		[PROC!450!diag3],
		[PROC!450!diag4],
		[PROC!450!diag5],
		[PROC!450!diag6],
		[PROC!450!diag7],
		[PROC!450!diag8],
		[PROC!450!unitType], --='UN'
		[PROC!450!units],
		[PROC!450!charge],
		[PROC!450!procedureType],
		[PROC!450!procCodeType],
		[PROC!450!procCodeName],
		[PROC!450!description],
		[PROC!450!serviceDate],
		[PROC!450!serviceDateEnd],
		[PROC!450!emergency],
		[PROC!450!serviceLocation],
		[PROC!450!lineControlNo],
		[PROC!450!TotalTax],
	--Added for Defect #11325
		[PROC!450!NoteReferenceCode],
		--CYS SC 12/06/08
		--[PROC!450!Note],
		[PROC!450!Notes],
		[PROC!450!NDC],
		[PROC!450!NDCUnitofMeasureANSI],
		[PROC!450!ProcID],
		[FINANCIALCENTER!105!FCID] ,
		[CLAIM!400!ElectronicClaimFormatUid] 
	)
	SELECT DISTINCT
		450                         AS Tag,
		400                         AS parent,
		#XMLClaims_temp.[SITE!100!PID]      AS [SITE!100!PID],
		[SITE!100!eClaimBatchGUID]          AS [SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide]        AS [SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide]          AS [SITE!100!payToAddressID!hide],
	    
		[PROVIDER!110!PID],         -- SC 11/03/08

		[RENDERER!410!ID!hide]              AS [RENDERER!410!ID!hide],
		[RENDERER!410!PEID]             AS [RENDERER!410!PEID],
		#XMLClaims_temp.[CLAIM!400!PID]     AS [CLAIM!400!PID],
		#XMLClaims_temp.[CLAIM!400!ChcBillingType] AS [CLAIM!400!ChcBillingType],
		#XMLClaims_temp.[PATIENT!300!PEID]      AS [PATIENT!300!PEID],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID]   AS [SUBSCRIBER!200!PEID],
		#XMLClaims_temp.[PAYER!230!ID!hide]     AS [PAYER!230!ID!hide],

		SuperbillProcedure.SuperbillProcedureUid        AS [PROC!450!ID!hide],
		dbo.GetSuperbillProcedureRowNumber(SuperbillProcedure.SuperbillProcedureUid) AS [PROC!450!count],
		COALESCE( al.aliasText, ListProcedure.Code ) AS [PROC!450!proc],
		ListProcedure.RevenueCode               AS [PROC!450!revenueCode],

		(CASE   WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1) = '' 
				THEN NULL
				ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1)	END)                        AS [PROC!450!procM1],
		(CASE   WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2) = '' 
				THEN NULL
				ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2)	END)                        AS [PROC!450!procM2],
		(CASE   WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3) = '' 
				THEN NULL
				ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3)	END)                        AS [PROC!450!procM3],
		(CASE   WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4) = '' 
				THEN NULL
				ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4)	END)                        AS [PROC!450!procM4],
				
		(CASE   WHEN SuperbillProcedure.DiagnosisPointer1 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer1	END)                        AS [PROC!450!diag1],
		(CASE   WHEN SuperbillProcedure.DiagnosisPointer2 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer2 	END)                        AS [PROC!450!diag2],
		(CASE   WHEN SuperbillProcedure.DiagnosisPointer3 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer3 	END)                        AS [PROC!450!diag3],
		(CASE   WHEN SuperbillProcedure.DiagnosisPointer4 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer4 	END)                        AS [PROC!450!diag4],
		(CASE   WHEN SuperbillProcedure.DiagnosisPointer5 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer5 	END)                        AS [PROC!450!diag5],
		(CASE   WHEN SuperbillProcedure.DiagnosisPointer6 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer6 	END)                        AS [PROC!450!diag6],
		(CASE   WHEN SuperbillProcedure.DiagnosisPointer7 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer7 	END)                        AS [PROC!450!diag7],
		(CASE   WHEN SuperbillProcedure.DiagnosisPointer8 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer8 	END)                        AS [PROC!450!diag8],

		'UN'                        AS [PROC!450!unitType],
		CONVERT(VARCHAR,SuperbillProcedure.Units)   AS [PROC!450!units],
		CONVERT(VARCHAR,SuperbillProcedure.TotalCharge,0)   AS [PROC!450!charge],

		ListProcedureServiceType.ANSICode       AS [PROC!450!procedureType],
		--CYS SC 07/09/09 - per LP for all Inst
		'HC'                        AS [PROC!450!procCodeType],
		ListProcedureCodeType.Name AS [PROC!450!procCodeName],
		ListProcedure.ShortDescription          AS [PROC!450!description],
		CONVERT(VARCHAR, SuperbillProcedure.ProcedureServiceDateStart, 101)         AS [PROC!450!serviceDate],
		CONVERT(VARCHAR, SuperbillProcedure.ProcedureServiceDateEnd, 101)           AS [PROC!450!serviceDateEnd],
		[PROC!450!emergency]                AS [PROC!450!emergency],
		[PROC!450!serviceLocation]          AS [PROC!450!serviceLocation],
		[PROC!450!lineControlNo]+''+CONVERT(VARCHAR,SuperbillProcedure.DisplayOrder)    AS [PROC!450!lineControlNo],
		SuperbillProcedure.TotalTax		AS [PROC!450!TotalTax],
	 --Added for Defect#11325   
		'ADD'         AS  [PROC!450!NoteReferenceCode],
	    
		--CYS SC 12/16/08
		CASE WHEN COALESCE(SuperbillProcedure.NDC,'') = '' 
             THEN CONVERT(VARCHAR(80),SUBSTRING(COALESCE(SuperbillProcedure.Notes,''),1,80),80)
			 WHEN SuperbillProcedure.NDC IS NOT NULL AND disp.MedDesc IS NOT NULL 
			 THEN SUBSTRING( (Convert(varchar(80), disp.MedDesc) + ' ' + Convert(varchar(80), COALESCE(SuperbillProcedure.Notes,''))), 1, 80)
			 WHEN SuperbillProcedure.NDC IS NOT NULL AND listProcedure.LongDescription IS NOT NULL 
			 THEN SUBSTRING( (Convert(varchar(80), listProcedure.LongDescription) + ' ' + Convert(varchar(80), COALESCE(SuperbillProcedure.Notes,''))), 1, 80)
			 ELSE CONVERT(VARCHAR(80),SUBSTRING(COALESCE(SuperbillProcedure.Notes,''),1,80),80) END  AS  [PROC!450!Note],
		COALESCE(SuperbillProcedure.NDC,'') AS  [PROC!450!NDC],
		CONVERT( VARCHAR(2), ListNDCUnitMeasure.ANSICode ) AS  [PROC!450!NDCUnitofMeasureANSI],    /* CYS SC Added */
		SuperbillProcedure.SuperbillProcedureUid        AS [PROC!450!ProcID],		 
		 [FINANCIALCENTER!105!FCID]   AS  [FINANCIALCENTER!105!FCID],
        [CLAIM!400!ElectronicClaimFormatUid] AS [CLAIM!400!ElectronicClaimFormatUid]
	FROM #XMLClaims_temp
			INNER JOIN SuperbillProcedure ON SuperbillProcedure.superbillUid = #XMLClaims_temp.[CLAIM!400!PID]
												AND ISNULL(SuperbillProcedure.DontClaim,0) = 0
												AND ISNULL(SuperbillProcedure.Inactive,0) = 0
			INNER JOIN ListProcedure ON	ListProcedure.ProcedureUid = SuperbillProcedure.ProcedureUid
			inner JOIN AR_LedgerDetail ld on SuperbillProcedure.SuperbillProcedureUid = ld.SuperbillProcedureUid		-- LedgerDetail entries for this procedure
			inner JOIN AR_Ledger arl on ld.LedgerUid = arl.LedgerUid												    -- BUT only those with
										and arl.EntryType = 1															--		type of Charge
										and arl.VoidLedgerUid is NULL													--		AND is NOT the reversing entry
			LEFT JOIN ListProcedureCodeType ON ListProcedureCodeType.ProcedureCodeTypeUid = ListProcedure.ProcedureCodeTypeUid
		/* SC - Remove this AND ListProcedureCodeType.Name IN ('CPT','HCPCS') */
			LEFT JOIN ListProcedureServiceType ON ListProcedureServiceType.ProcedureServiceTypeUid = ListProcedure.ProcedureServiceTypeUid
		/* CYS SC - Added */
			LEFT JOIN ListNDCUnitMeasure ON  ListNDCUnitMeasure.NDCUnitMeasureUid = SuperbillProcedure.NDCUnitMeasureUid
			LEFT OUTER JOIN dbo.NDD_SearchDispensable disp on disp.IsDelete = 0 AND SuperbillProcedure.FDB_MEDID = disp.medid
		LEFT OUTER JOIN @ProcedureAliases al on superbillProcedure.SuperbillProcedureUid = al.superbillProcedureUid
													AND al.rowNo = 1
		LEFT OUTER JOIN AR_Ledger arlv on arl.LedgerUid = arlv.VoidLedgerUid						-- Find a reversing entry ( in case it needs to be thrown out later )
	WHERE
		#XMLClaims_temp.tag = 400 
			AND arlv.VoidLedgerUid IS NULL

	--Getting ready to call 
	--exec AR_getClaimFormatProcedureOverrideValues 

	CREATE TABLE #Procs_temp 
		(
			[CLAIM!400!PID] UNIQUEIDENTIFIER,
			[PROC!450!ID!hide] UNIQUEIDENTIFIER,
			ProcedureUid UNIQUEIDENTIFIER,
			ClaimFormatUid UNIQUEIDENTIFIER
		)
	INSERT INTO #Procs_temp
		(
		[CLAIM!400!PID],
		[PROC!450!ID!hide],
		ProcedureUid,   
		ClaimFormatUid
		)
	SELECT  [CLAIM!400!PID] AS [CLAIM!400!PID], 
			[PROC!450!ID!hide] AS [PROC!450!ID!hide],
			SuperbillProcedure.ProcedureUid AS ProcedureUId,
			[CLAIM!400!ElectronicClaimFormatUid] AS ClaimFormatUid
	FROM #XMLClaims_temp 
			INNER JOIN ClaimBatch ON  ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
			INNER JOIN ClaimBatchDetail ON  ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid   
			INNER JOIN superbill ON superbill.superbillUid = ClaimBatchDetail.SuperBillUid and  
										superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
			--INNER JOIN SuperbillAggregate sba on superbill.SuperbillUid = sba.SuperbillUid 
			INNER JOIN SuperbillProcedure ON SuperbillProcedure.SuperbillProcedureUid = #XMLClaims_temp.[PROC!450!ID!hide]
			--INNER JOIN account ON account.accountUid = superbill.accountUid  
			--INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  
			--			AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
			--			OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
			--			OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
			--			OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
			--INNER JOIN AccountInsurance  ON AccountInsurance.AccountPeriodUid = sba.AccountPeriodUid -- AND AccountInsurance.DisplayOrder = 1
			--INNER JOIN PersonInsurancePlan ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid 
			--									-- AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
			--INNER JOIN InsurancePlan ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
			--INNER JOIN InsuranceCarrier ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  
	WHERE tag = '450' 

	--UPDATE #Procs_temp
	--  SET ProcedureUid = SuperbillProcedure.ProcedureUid
	--FROM #Procs_temp

	DECLARE @csrProcs CURSOR

	SET @csrProcs = CURSOR FOR 
		SELECT  [CLAIM!400!PID],
				[PROC!450!ID!hide],
				ProcedureUid,
				ClaimFormatUid
	 FROM #Procs_temp


	DECLARE @CLAIM_PID UNIQUEIDENTIFIER
	DECLARE @PROC_PID UNIQUEIDENTIFIER
	DECLARE @ProcedureUid UNIQUEIDENTIFIER
	DECLARE @ClaimFormatUid  UNIQUEIDENTIFIER

	DECLARE @CPTCode VARCHAR(255), @RevenueCode VARCHAR(255), @Modifier1 VARCHAR(255)
	DECLARE @Modifier2 VARCHAR(255), @Modifier3 VARCHAR(255), @Modifier4 VARCHAR(255)

	-- a system guid ClaimFormatValueTypeTypeProcedureOverrideFormatValue 
	-- Name = "Procedure Override Format Value"
	DECLARE @ClaimFormatValueTypeTypeUid AS UNIQUEIDENTIFIER
	SET @ClaimFormatValueTypeTypeUid = 'ae114249-40bc-49dd-a0e6-702fe4b7aab1'

	OPEN @csrProcs
	FETCH NEXT FROM @csrProcs INTO @CLAIM_PID, @PROC_PID, @ProcedureUid, @ClaimFormatUid
	WHILE (@@FETCH_STATUS=0)
	BEGIN

		--CYS SC - added was not clearing prior vars contents
		SET @CPTCode = ''
		SET @RevenueCode = ''
		SET @Modifier1 = ''
		SET @Modifier2 = ''
		SET @Modifier3 = ''
		SET @Modifier4 = ''

		EXEC AR_getClaimFormatProcedureOverrideValues @ClaimFormatUid, @ClaimFormatValueTypeTypeUid, @ProcedureUid, 
				@CPTCode OUT, @RevenueCode OUT, @Modifier1 OUT,
				@Modifier2 OUT, @Modifier3 OUT, @Modifier4 OUT
	    
		If (@CPTCode IS NOT NULL) AND (@CPTCode != '')
			UPDATE #XMLClaims_temp 
				SET [PROC!450!proc] = @CPTCode
				FROM #XMLClaims_temp tmp
				WHERE tmp.[CLAIM!400!PID] = @CLAIM_PID AND tmp.[PROC!450!ID!hide] = @PROC_PID

		If (@RevenueCode IS NOT NULL) AND (@RevenueCode != '')
			UPDATE #XMLClaims_temp 
				SET [PROC!450!revenueCode] = @RevenueCode
				FROM #XMLClaims_temp tmp
				WHERE tmp.[CLAIM!400!PID] = @CLAIM_PID AND tmp.[PROC!450!ID!hide] = @PROC_PID

		If (@Modifier1 IS NOT NULL) AND (@Modifier1 != '')
			UPDATE #XMLClaims_temp 
				SET [PROC!450!procM1] = @Modifier1
				FROM #XMLClaims_temp tmp
				WHERE tmp.[CLAIM!400!PID] = @CLAIM_PID AND tmp.[PROC!450!ID!hide] = @PROC_PID

		If (@Modifier2 IS NOT NULL) AND (@Modifier2 != '')
		   UPDATE #XMLClaims_temp 
					SET [PROC!450!procM2] = @Modifier2
					FROM #XMLClaims_temp tmp
					WHERE tmp.[CLAIM!400!PID] = @CLAIM_PID AND tmp.[PROC!450!ID!hide] = @PROC_PID

		If (@Modifier3 IS NOT NULL) AND (@Modifier3 != '')
			UPDATE #XMLClaims_temp 
				SET [PROC!450!procM3] = @Modifier3
				FROM #XMLClaims_temp tmp
				WHERE tmp.[CLAIM!400!PID] = @CLAIM_PID AND tmp.[PROC!450!ID!hide] = @PROC_PID

		If (@Modifier4 IS NOT NULL) AND (@Modifier4 != '')
			UPDATE #XMLClaims_temp 
				SET [PROC!450!procM4] = @Modifier4
				FROM #XMLClaims_temp tmp
				WHERE tmp.[CLAIM!400!PID] = @CLAIM_PID AND tmp.[PROC!450!ID!hide] = @PROC_PID

		FETCH NEXT FROM @csrProcs INTO @CLAIM_PID, @PROC_PID, @ProcedureUid, @ClaimFormatUid
	END
	CLOSE @csrProcs
	DEALLOCATE @csrProcs

	DROP TABLE #Procs_temp

	-- SET #XMLClaims_temp.[Claim!400!totalBill] by summing procedure charges
	-- Bug 44998 - Changed float to decimal(10,2)	01/08/2016
	;with myCTE as
	(
		select #XMLClaims_temp.[CLAIM!400!PID] as uid,
				sum(cast(coalesce(#XMLClaims_temp.[PROC!450!charge], '0') as decimal(10,2))) as total
		from #XMLClaims_temp
		WHERE tag = 450
		group by #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[Claim!400!totalBill] = 
			CASE WHEN mc.total = 0 THEN '0' ELSE CONVERT(varchar(12), mc.total, 128) END  -- new
	From #XMLClaims_temp		
			INNER JOIN myCTE mc ON #XMLClaims_temp.[CLAIM!400!PID] = mc.uid
	WHERE #XMLClaims_temp.tag = 400

-----------------------------------------------------------------------------------------------------------------------------------
-- For every solution, Only allow 4 digits for revenue code ( Bug 49368 )
	Update #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!revenueCode] = LEFT( #XMLClaims_temp.[PROC!450!revenueCode], 4)
	FROM #XMLClaims_temp
	WHERE #XMLClaims_temp.tag = 450 -- proc

-----------------------------------------------------------------------------------------------------------------------------------
-- Product Backlog Item 51952:Hawaii Tax Changes to be handled in Claims and ERA processing
exec AR_genXMLClaims_PROC_ExciseTax

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_ATTENDING]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_ATTENDING] AS' 
END
GO


ALTER PROC [dbo].[AR_genXMLClaims_Inst_ATTENDING]
 AS

--CYS SC 12/01/08 - added logic to [ATTENDING!140!IDType] and [ATTENDING!140!ID] 
-- for Service Site NPI Overrides.

DECLARE @mainFinancialCenter as UNIQUEIDENTIFIER
SET @mainFinancialCenter = '14B99C94-EDAC-47BD-97B9-CF421AC16018'

 DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
 SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @ServiceSiteNPIUid UNIQUEIDENTIFIER
 SELECT @ServiceSiteNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Service Site NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @PayToProviderNPIUid UNIQUEIDENTIFIER
 SELECT @PayToProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Pay To Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @SSNUid UNIQUEIDENTIFIER
 SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	
 
 DECLARE @EINUid UNIQUEIDENTIFIER  
 SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

 DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

DECLARE @UPINUid UNIQUEIDENTIFIER
SELECT @UPINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'UPIN' AND ISNULL(cfvt1.Inactive, 0) = 0

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID],		--CYS SC 11/03/08

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[ATTENDING!140!PEID],
	[ATTENDING!140!FCID],
	[ATTENDING!140!FileAsGroup],
	[ATTENDING!140!PID],
	--[ATTENDING!140!orgName],
	[ATTENDING!140!LN],
	[ATTENDING!140!FN],
	[ATTENDING!140!MI],

	[ATTENDING!140!address1],
	[ATTENDING!140!address2],
	[ATTENDING!140!city],
	[ATTENDING!140!state],
	[ATTENDING!140!zip],
	[ATTENDING!140!phone],
	[ATTENDING!140!siteType],
	[ATTENDING!140!IDType],
	[ATTENDING!140!ID],	

	/* CYS SC - Individual Dr ID regardless of filing type */
	[ATTENDING!140!IDType_Dr],
	[ATTENDING!140!ID_Dr],	

	--DEFECT #9657
	[ATTENDING!140!NPISecIDType],
    [ATTENDING!140!NPISecID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[ATTENDING!140!NPISecIDType_Dr],
	[ATTENDING!140!NPISecID_Dr],

	[ATTENDING!140!LocationNo],
    [FINANCIALCENTER!105!FCID],
	[ATTENDING!140!SuperbillUid]		--CYS SC 11/04/08
)
SELECT
	140 					AS Tag,
	110 					AS parent,

	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID]				AS [PROVIDER!110!PID],	--CYS SC 11/03/08

	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!PEID],
	[ATTENDING!140!PEID] AS [ATTENDING!140!PEID],
	[ATTENDING!140!FCID]	AS [ATTENDING!140!FCID],
	[ATTENDING!140!FileAsGroup]	AS	[ATTENDING!140!FileAsGroup],
	[ATTENDING!140!PID] AS [ATTENDING!140!PID],
	[ATTENDING!140!LN] AS [ATTENDING!140!LN],
	[ATTENDING!140!FN] AS [ATTENDING!140!FN],
	[ATTENDING!140!MI] AS [ATTENDING!140!MI],
	[ATTENDING!140!address1] AS [ATTENDING!140!address1],
	[ATTENDING!140!address2] AS [ATTENDING!140!address2],
	[ATTENDING!140!city] AS [ATTENDING!140!city],
	[ATTENDING!140!state] AS [ATTENDING!140!state],
	[ATTENDING!140!zip] AS [ATTENDING!140!zip],	
	[ATTENDING!140!phone] AS [ATTENDING!140!phone],
	
	ListServiceSiteType.ANSICode		AS [ATTENDING!140!siteType],

	[ATTENDING!140!IDType]		AS [ATTENDING!140!IDType],
	[ATTENDING!140!ID]			 AS [ATTENDING!140!ID],	

	[ATTENDING!140!IDType_Dr]		AS [ATTENDING!140!IDType_Dr],
	[ATTENDING!140!ID_Dr]			AS [ATTENDING!140!ID_Dr],	

	--DEFECT #9657
	[ATTENDING!140!NPISecIDType]	AS [ATTENDING!140!NPISecIDType],
	[ATTENDING!140!NPISecID]  	AS [ATTENDING!140!NPISecID],

	[ATTENDING!140!NPISecIDType_Dr]	AS [ATTENDING!140!NPISecIDType_Dr],
	[ATTENDING!140!NPISecID_Dr]		AS [ATTENDING!140!NPISecID_Dr],

	'0001'					AS [ATTENDING!140!LocationNo],
    [FINANCIALCENTER!105!FCID] AS [FINANCIALCENTER!105!FCID],
	[CLAIM!400!PID] AS [ATTENDING!140!SuperbillUid]		--CYS SC 11/04/08

FROM #XMLClaims_temp
INNER JOIN dbo.claimsubmitter ON
	claimSubmitter.ClaimSubmitterUid = #XMLClaims_temp.[SITE!100!claimSubmitterID!hide]
LEFT JOIN ListServiceSite ON
	ListServiceSite.serviceSiteUid = claimSubmitter.ClaimSubmitterServiceSiteUid
LEFT JOIN ListServiceSiteType ON
	ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
WHERE
	--#XMLClaims_temp.tag = 110
#XMLClaims_temp.tag = 400


UPDATE #XMLClaims_temp SET [ATTENDING!140!FCID] = @mainFinancialCenter
	WHERE tag = '140' AND [ATTENDING!140!FCID] IS NULL

UPDATE #XMLClaims_temp SET 
	[ATTENDING!140!FileAsGroup] =
	CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, 
		CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual')  OR 
            (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) ='1'  ))
       THEN 0	   
       ELSE 1	
	END,
	
	[ATTENDING!140!IDType] =
	CASE WHEN lcf.SendNPI = 1 THEN		
		--CYS SC - Service Site NPI Override
		(CASE WHEN Exists(SELECT * FROM ClaimFormatOption cfo
				INNER JOIN [ListClaimFormatOptionType] ot ON ot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid 
					WHERE (ClaimFormatUid = 
					CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END) 
					AND (ot.Name = 'NPI Override'))
				AND COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' 
			THEN 'XX'
		ELSE 
		--CYS SC - Service Site NPI Override End
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') <> '' THEN  
					'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') <> '' THEN  
					'24'  
				WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN 
					'34'
				ELSE ''
		   END)  
		END) --ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') <> '' THEN  
				'24'  
			WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN 
				'34'
			ELSE ''
	      END)
	END,	   

	[ATTENDING!140!ID] =
	CASE WHEN lcf.SendNPI = 1 THEN
		--CYS SC - Service Site NPI Override
		(CASE WHEN Exists(SELECT * FROM ClaimFormatOption cfo
				INNER JOIN [ListClaimFormatOptionType] ot ON ot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid 
					WHERE (ClaimFormatUid = 
					CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END) 
					AND (ot.Name = 'NPI Override'))
				AND COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' 
			THEN dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)
		--CYS SC - Service Site NPI Override End		
		ELSE 
		
		  (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
						ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid)
				WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
						ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
				WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN 
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 
							dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
						ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
				ELSE ''
			END) 
		END) --ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
			WHEN (( dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR ( dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE	
						COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
			ELSE ''
		  END)
	END,

	/* Individual Dr ID regardless of filing type */
	[ATTENDING!140!IDType_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN		
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid, 0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') <> '' THEN 'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') <> '' THEN  	'24'  
				ELSE '34'
		   END)  
		ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') <> '' THEN '24'  
				ELSE '34'
				END)
	END,	   

	[ATTENDING!140!ID_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN
		(CASE	WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 
					dbo.UDF_getFormatVaribleValue (0,  @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid)
				WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 	
					dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
				ELSE				
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
		END) 
	ELSE 
		(CASE	
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 	
						dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
			ELSE				
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
  		END)
	END,

	[ATTENDING!140!rIDType] = 
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '' THEN '1G'
	  ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,  
		 5,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid)
	END,

	[ATTENDING!140!rID] =
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,
		4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) ,'')
	ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,
			4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) 
	END,
	
	/* Individual Dr ID regardless of filing type */
	/* 12 = Attending Physician ID, 13 = Attending Physician ID Type in ListClaimFormatOptionType */
	[ATTENDING!140!rIDType_Dr] =  
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 12,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '' THEN '1G'
	  ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,  
		 13,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid)
	END,

	[ATTENDING!140!rID_Dr] =	
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,
		12,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) ,'')
	ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,
			12,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) 
	END, 

	[ATTENDING!140!NPISecIDType] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
				ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN
				'EI'
			WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN 
				'SY'
			ELSE ''
		END)	
    ELSE ''
	END,	

	[ATTENDING!140!NPISecID] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
				ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 					
			WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) = '1' )) THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 				
					ELSE
						COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
			ELSE
				''
		END)
	ELSE ''
	END,

	/* Individual Dr ID regardless of filing type */
	[ATTENDING!140!NPISecIDType_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN
				'EI'
			ELSE 'SY'
		END)	
    ELSE ''
	END,	
	
	/* Individual Dr ID regardless of filing type */
	[ATTENDING!140!NPISecID_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 					
			ELSE
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) <> '' THEN 
					dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.servicesiteuid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 				
				ELSE
					COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
		END)
	ELSE ''
	END,
	[ATTENDING!140!providerTaxonomyCode] =	ISNULL(ListSpecialty.ANSICode,'')	
FROM #XMLClaims_temp 
INNER JOIN ClaimBatch ON  ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
INNER JOIN ClaimBatchDetail ON  ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid   
INNER JOIN superbill ON 
	superbill.superbillUid = ClaimBatchDetail.SuperBillUid and  
	superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
		  INNER JOIN  ViewSuperbillFinancialDetails ON  
		ViewSuperbillFinancialDetails.superbillUid = superbill.SuperbillUid and  
		   superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set. 
INNER JOIN Person Per ON Per.PersonUid = #XMLClaims_temp.[ATTENDING!140!PEID]
INNER JOIN Provider provider on provider.PersonUid = #XMLClaims_temp.[ATTENDING!140!PEID]
LEFT JOIN ListSpecialty ON provider.SpecialtyUid = ListSpecialty.SpecialtyUid

INNER JOIN account ON  
   account.accountUid = superbill.accountUid  
INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  
	AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
INNER JOIN AccountInsurance  ON  
   AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid -- AND AccountInsurance.DisplayOrder = 1
INNER JOIN PersonInsurancePlan  
   ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
   AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
INNER JOIN InsurancePlan  
   ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
INNER JOIN InsuranceCarrier  
   ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  

LEFT JOIN ListClaimFormat lcf
	ON lcf.ClaimFormatUid = (CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid
						ELSE InsurancePlan.ElectronicClaimFormatUid END)	

WHERE TAG = '140'

UPDATE #XMLClaims_temp SET 
	[ATTENDING!140!PID] =
		CASE WHEN [ATTENDING!140!FileAsGroup] = 1 THEN Fc.FinancialCenterUid
				ELSE Per.PersonUid  END,
	[ATTENDING!140!LN] =
		CASE WHEN [ATTENDING!140!FileAsGroup] =  1 THEN  UPPER(Fc.Name)
		ELSE  UPPER(Per.LastName) END,
	[ATTENDING!140!FN] = 
		CASE [ATTENDING!140!FileAsGroup] WHEN 1 THEN   NULL
		ELSE UPPER(Per.FirstName) END,
	[ATTENDING!140!MI] = 
		CASE [ATTENDING!140!FileAsGroup] WHEN 1 THEN  NULL
		ELSE UPPER(Per.MiddleName)  END,
	/*CYS SC */
	[ATTENDING!140!LN_Dr] = UPPER(Per.LastName),
	[ATTENDING!140!FN_Dr] = UPPER(Per.FirstName),
	[ATTENDING!140!MI_Dr] =UPPER(Per.MiddleName),
	/*CYS SC */
	[ATTENDING!140!address1] = CASE WHEN [ATTENDING!140!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') END,
	[ATTENDING!140!address2] = CASE WHEN [ATTENDING!140!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') END,
	[ATTENDING!140!city] = CASE WHEN [ATTENDING!140!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') END,
	[ATTENDING!140!state] = CASE WHEN [ATTENDING!140!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/State)[1]', 'VARCHAR(100)') END,
	[ATTENDING!140!zip] = CASE WHEN [ATTENDING!140!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)') ELSE Per.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') END,
	[ATTENDING!140!phone] = dbo.stripSpecialChars(CASE WHEN [ATTENDING!140!FileAsGroup] = 1 THEN Fc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(100)') ELSE Per.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(100)') END)
FROM #XMLClaims_temp 
	INNER JOIN Person Per ON Per.PersonUid = #XMLClaims_temp.[ATTENDING!140!PEID]
	INNER JOIN FinancialCenter Fc ON Fc.FinancialCenterUid = #XMLClaims_temp.[ATTENDING!140!FCID]
WHERE tag = '140' 

--We do not want any 150 recs if there is not a SuberbillUB.AttendingProviderUid
DECLARE @blankUid AS UNIQUEIDENTIFIER
SET @blankUid = '00000000-0000-0000-0000-000000000000'
DELETE #XMLClaims_temp
WHERE tag = '140' AND ISNULL(#XMLClaims_temp.[ATTENDING!140!PEID],@blankUid) = @blankUid

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_BILLINGPROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_BILLINGPROVIDER] AS' 
END
GO

--CYS SC 07/31/09 - not getting the correct BP on LN_Dr - Fixed.
/*
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/

ALTER PROC [dbo].[AR_genXMLClaims_Inst_BILLINGPROVIDER]
 AS
--1 BILLINGPROVIDER (claimSubmitter) / PAYTOPROVIDER (payToAddress)
-- payToSSID,billingSSID
--CYS SC - _Dr fields = Individual Dr ID regardless of filing type for Loop2310A

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[PROVIDER!110!PID],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup],
	[BILLINGPROVIDER!120!PID],
	--[BILLINGPROVIDER!120!orgName],
	[BILLINGPROVIDER!120!LN],
	[BILLINGPROVIDER!120!FN],
	[BILLINGPROVIDER!120!MI],

	[BILLINGPROVIDER!120!address1],
	[BILLINGPROVIDER!120!address2],
	[BILLINGPROVIDER!120!city],
	[BILLINGPROVIDER!120!state],
	[BILLINGPROVIDER!120!zip],
	[BILLINGPROVIDER!120!phone],
	[BILLINGPROVIDER!120!siteType],
	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID],	

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!IDType_Dr],
	[BILLINGPROVIDER!120!ID_Dr],	

	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType],
    [BILLINGPROVIDER!120!NPISecID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!NPISecIDType_Dr],
	[BILLINGPROVIDER!120!NPISecID_Dr],

	[BILLINGPROVIDER!120!LocationNo],
    [FINANCIALCENTER!105!FCID]
)
SELECT
	120 					AS Tag,
	110 					AS parent,

	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[PROVIDER!110!PID] AS [PROVIDER!110!PID],		--CYS SC 11/03/08
	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID]	AS [BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup]	AS	[BILLINGPROVIDER!120!FileAsGroup],

	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.FinancialCenterUid
			ELSE Per.PersonUid  END		AS [BILLINGPROVIDER!120!PID],
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] =  1 THEN  UPPER(Fc.Name)
			ELSE  UPPER(Per.LastName) END 	    AS [BILLINGPROVIDER!120!LN],	
	CASE [BILLINGPROVIDER!120!FileAsGroup] WHEN 1 THEN   NULL
			ELSE UPPER(Per.FirstName) END 	AS [BILLINGPROVIDER!120!FN],
	CASE [BILLINGPROVIDER!120!FileAsGroup] WHEN 1 THEN  NULL
			ELSE UPPER(Per.MiddleName)  END 	AS [BILLINGPROVIDER!120!MI],	

	/*CASE Pr.UsePracticeSettingsBillingAddress WHEN 1 THEN claimSubmitter.ClaimSubmitterUid ELSE C.CorporationUid END
						AS [BILLINGPROVIDER!120!PID],
	CASE Pr.UsePracticeSettingsBillingAddress WHEN 1 THEN claimSubmitter.groupName ELSE C.Name END
						AS [BILLINGPROVIDER!120!orgName],*/
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN fc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!address1],
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN fc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!address2], 
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN fc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!city],
	UPPER(CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN fc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/State)[1]', 'VARCHAR(100)') 
	END) AS [BILLINGPROVIDER!120!state],
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN fc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!zip],

/*	ListServiceSite.ServiceSiteUid		AS [BILLINGPROVIDER!120!PID],	
	ListServiceSite.Name			AS [BILLINGPROVIDER!120!orgName],
	Address.Address1			AS [BILLINGPROVIDER!120!address1],
	Address.Address2			AS [BILLINGPROVIDER!120!address2],
	Address.City				AS [BILLINGPROVIDER!120!city],
	UPPER(Address.State)			AS [BILLINGPROVIDER!120!state],
	Address.Zip				AS [BILLINGPROVIDER!120!zip],*/

	dbo.stripSpecialChars(COALESCE(CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN fc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)') ELSE Per.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)') END,'')) AS [BILLINGPROVIDER!120!phone],
	ListServiceSiteType.ANSICode		AS [BILLINGPROVIDER!120!siteType],

	[BILLINGPROVIDER!120!IDType]		AS [BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID]			 AS [BILLINGPROVIDER!120!ID],	

	[BILLINGPROVIDER!120!IDType_Dr]		AS [BILLINGPROVIDER!120!IDType_Dr],
	[BILLINGPROVIDER!120!ID_Dr]			AS [BILLINGPROVIDER!120!ID_Dr],	

	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType]	AS [BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID]  	AS [BILLINGPROVIDER!120!NPISecID],

	[BILLINGPROVIDER!120!NPISecIDType_Dr]	AS [BILLINGPROVIDER!120!NPISecIDType_Dr],
	[BILLINGPROVIDER!120!NPISecID_Dr]		AS [BILLINGPROVIDER!120!NPISecID_Dr],

	'0001'					AS [BILLINGPROVIDER!120!LocationNo],
    [FINANCIALCENTER!105!FCID] AS [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp

INNER JOIN dbo.claimsubmitter ON
	claimSubmitter.ClaimSubmitterUid = #XMLClaims_temp.[SITE!100!claimSubmitterID!hide]

INNER JOIN Person Per ON Per.PersonUid = [RENDERER!410!PEID]
--INNER JOIN Provider Pr ON Pr.PersonUid = [RENDERER!410!PEID]
INNER JOIN FinancialCenter Fc ON Fc.FinancialCenterUid = [BILLINGPROVIDER!120!FCID]
--LEFT JOIN Corporation C ON C.CorporationUid = Pr.ClaimProviderCorporationUid

/*LEFT JOIN Address  ON Address.AddressUid = 
	CASE Pr.UsePracticeSettingsBillingAddress WHEN 1 THEN claimSubmitter.BillingAddressUid ELSE C.AddressUid END

LEFT JOIN Phone p1 ON p1.PhoneUid = 
	CASE Pr.UsePracticeSettingsBillingAddress WHEN 1 THEN claimSubmitter.MainPhoneUid ELSE C.PhoneUid1 END

LEFT JOIN ListPhoneType pt1 ON
	p1.PhoneTypeUid = pt1.PhoneTypeUid AND
	pt1.Name LIKE 'work'

LEFT JOIN Phone p2 ON p2.PhoneUid = 
	CASE Pr.UsePracticeSettingsBillingAddress WHEN 1 THEN claimSubmitter.MainPhoneUid ELSE C.PhoneUid2 END

LEFT JOIN ListPhoneType pt2 ON
	p2.PhoneTypeUid = pt2.PhoneTypeUid AND
	pt2.Name LIKE 'work'

LEFT JOIN Phone p3 ON p3.PhoneUid = 
	CASE Pr.UsePracticeSettingsBillingAddress WHEN 1 THEN claimSubmitter.MainPhoneUid ELSE C.PhoneUid3 END

LEFT JOIN ListPhoneType pt3 ON
	p3.PhoneTypeUid = pt3.PhoneTypeUid AND
	pt3.Name LIKE 'work'

LEFT JOIN Phone p4 ON p4.PhoneUid = 
	CASE Pr.UsePracticeSettingsBillingAddress WHEN 1 THEN claimSubmitter.MainPhoneUid ELSE C.PhoneUid4 END

LEFT JOIN ListPhoneType pt4 ON
	p4.PhoneTypeUid = pt4.PhoneTypeUid AND
	pt4.Name LIKE 'work'*/

LEFT JOIN ListServiceSite ON
	ListServiceSite.serviceSiteUid = claimSubmitter.ClaimSubmitterServiceSiteUid
/*
LEFT JOIN Address ON
	ListServiceSite.AddressUid = Address.AddressUid

LEFT JOIN Phone p1 ON
	ListServiceSite.PhoneUid1 = p1.PhoneUid  

LEFT JOIN ListPhoneType pt1 ON
	p1.PhoneTypeUid = pt1.PhoneTypeUid AND
	pt1.Name LIKE 'work'

LEFT JOIN Phone p2 ON
	ListServiceSite.PhoneUid2 = p2.PhoneUid  

LEFT JOIN ListPhoneType pt2 ON
	p2.PhoneTypeUid = pt2.PhoneTypeUid AND
	pt2.Name LIKE 'work'

LEFT JOIN Phone p3 ON
	ListServiceSite.PhoneUid3 = p3.PhoneUid  

LEFT JOIN ListPhoneType pt3 ON
	p3.PhoneTypeUid = pt3.PhoneTypeUid AND
	pt3.Name LIKE 'work'

LEFT JOIN Phone p4 ON
	ListServiceSite.PhoneUid4 = p4.PhoneUid  

LEFT JOIN ListPhoneType pt4 ON
	p4.PhoneTypeUid = pt4.PhoneTypeUid AND
	pt4.Name LIKE 'work'*/

LEFT JOIN ListServiceSiteType ON
	ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
	
WHERE
	#XMLClaims_temp.tag = 110

--CYS SC 07/31/09 - not getting the correct BP
-- chgd to use [RENDERER!410!PEID] which is actually the BP (ClaimingProviderUid)
UPDATE #XMLClaims_temp SET 
	[BILLINGPROVIDER!120!LN_Dr] = UPPER(Per.LastName),
	[BILLINGPROVIDER!120!FN_Dr] = UPPER(Per.FirstName),
	[BILLINGPROVIDER!120!MI_Dr] = UPPER(Per.MiddleName)
FROM #XMLClaims_temp 
--INNER JOIN ClaimBatch ON  ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
--INNER JOIN ClaimBatchDetail ON  ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid   
--INNER JOIN superbill ON 
--	superbill.superbillUid = ClaimBatchDetail.SuperBillUid and  
--	superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
--INNER JOIN Person Per ON Per.PersonUid = superbill.ClaimingProviderUid
--CYS SC 07/31/09														  
INNER JOIN Person Per ON Per.PersonUid = #XMLClaims_temp.[RENDERER!410!PEID]
WHERE TAG = '120'



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_CLAIM]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_CLAIM] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_Inst_CLAIM]  
 @ClaimBatchUid UniqueIdentifier,  
 @claimsFetched int = 0 output  
AS

--CYS SC 07/08/09 - Add [CLAIM!400!BillingProvider_IDType] for Service Site bug (CYS Case #22420)
--CYS SC 07/08/09 - Add [CLAIM!400!BillingProvider_ID] for Service Site bug (CYS Case #22420)
--CYS SC 05/21/09 - add [CLAIM!400!EPSDT] for CLM12
--CYS SC 05/21/09 - add [CLAIM!400!delayReasonCode] for CLM20 
--CYS SC 12/01/08 - added logic to [BILLINGPROVIDER!120!IDType] and [BILLINGPROVIDER!120!ID] 
-- for Service Site NPI Overrides.
--CYS SC 10/31/08 - chgs to pullin ProviderID for XML file sorting
-- 2014-09-02 dsw Removed code to retrieve totalBill and moved it to _Proc procedure
-- 2014-12-01 dsw Allow ICD-10 codes in 4010. Bug 34065
-- 2014-12-05 dsw - 34159 Performance improvements by using SuperbillAggregate.AccountPeriod
-- 2014-02-27 dsw - 35706 - ICD-10 with start date in insurance
-- 2016-03-09 dsw - 47436 - RHC Detail
-- 2016-10-26 51952 Hawaii Tax Changes to be handled in Claims and ERA processing ( added electronicClaimFormatUid, TotalTax )

/*  
Modified On: 20051011  
Modifications Made: 2. Modified for Accident date  
   1. For handling WCC Case... setting isWCC column : 20050823  

Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/  

DECLARE @zeroGuid as UniqueIdentifier
SET @zeroGuid = '00000000-0000-0000-0000-000000000000'

-- GET ListClaimformatValueType specific items ( Provider NPI, Service Site NPI, etc )
BEGIN
--DEFECT #9657
 DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
 SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 with (nolock)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt with (nolock) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @ServiceSiteNPIUid UNIQUEIDENTIFIER
 SELECT @ServiceSiteNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 with (nolock)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt with (nolock) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Service Site NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @PayToProviderNPIUid UNIQUEIDENTIFIER
 SELECT @PayToProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 with (nolock)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt with (nolock) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Pay To Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 with (nolock)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt with (nolock) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @SSNUid UNIQUEIDENTIFIER
 SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 with (nolock) 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt with (nolock) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	
 
 DECLARE @EINUid UNIQUEIDENTIFIER  
 SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 with (nolock)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt with (nolock) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

 DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 with (nolock)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt with (nolock) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  
-- test
declare @scrubsubscriber int
set @scrubsubscriber = 0
select @scrubsubscriber = coalesce(lpp.IntegerValue,0) from ListProductParameter lpp
							where ParameterName = 'Scrub.Subscriber' 
-- end test

 END

 -- GET electronicClaimFormat specific info ( group or individual; ssn; etc )
 BEGIN
   Declare @ecf TABLE 
 ( 
   SuperbillUid uniqueidentifier, 
   ElectronicClaimFormatUid uniqueidentifier,
   GroupOrInd varchar(255),
   IsIndividual bit,
   filingTypeSSN bit, 
   SSN	varchar(255),
   NPIOverrideUid uniqueidentifier,		-- Guid of ClaimFormatValueType for NPI override on a specific ElectronicClaimFormat 
   NPIOverrideFixedValue varchar(255)	-- Fixed value for NPI override on a specific ElectronicClaimFormat
 ) ;
 INSERT INTO @ecf( SuperbillUid, ElectronicClaimFormatUid, filingTypeSSN )
	 SELECT sb.SuperbillUid,
	        CASE WHEN ip.UseCarrierElectronicClaimFormat = 1 
				 THEN ic.ElectronicClaimFormatUid  
 				 ELSE ip.ElectronicClaimFormatUid END AS ElectronicClaimFormatUid,
 			0 as filingTypeSSN			-- default is to file for EIN for both group and individual filing types
  FROM #XMLClaims_temp  
  INNER JOIN ClaimBatch cb with (nolock) ON cb.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
  INNER JOIN ClaimBatchDetail cbd with (nolock) ON cbd.ClaimBatchUid = cb.ClaimBatchUid   
  INNER JOIN superbill sb with (nolock) on sb.SuperbillUid = cbd.SuperbillUid --2011 change 
  INNER JOIN SuperbillAggregate sba with (nolock) ON sb.SuperbillUid = sba.SuperbillUid  
  INNER JOIN account act with (nolock) ON act.accountUid = sb.accountUid  
  --INNER JOIN AccountPeriod ap with (nolock) ON ap.Accountuid = act.accountUid  
		--				AND ((ap.effectiveDate IS NOT NULL AND ap.ExpirationDate IS NULL AND ap.effectiveDate <= sb.serviceDateEnd)
		--				OR (ap.effectiveDate IS NULL AND ap.ExpirationDate IS NOT NULL AND ap.expirationDate >= sb.serviceDateEnd) 
		--				OR (ap.effectiveDate IS NOT NULL AND ap.ExpirationDate IS NOT NULL AND ap.effectiveDate <= sb.serviceDateEnd
		--				AND ap.expirationDate >= sb.serviceDateEnd) 
		--				OR (ap.effectiveDate IS NULL AND ap.ExpirationDate IS NULL))
  INNER JOIN AccountInsurance  ai with (nolock) ON sba.AccountPeriodUid = ai.AccountPeriodUid 
											AND sba.CurrentCarrier = ai.DisplayOrder   
  INNER JOIN PersonInsurancePlan pip with (nolock) ON pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid  
											AND pip.InsurancePlanUid = cbd.InsurancePlanUid  
  INNER JOIN InsurancePlan ip with (nolock) ON ip.InsurancePlanUid = pip.InsurancePlanUid  
  INNER JOIN InsuranceCarrier ic with (nolock) ON ic.CorporationUid = ip.InsuranceCarrierUid   
  LEFT JOIN ViewSuperbillCurrentLiabilityOwnerAndCarrier cl with (nolock) ON sb.superbillUid = cl.superbillUid
WHERE  
  #XMLClaims_temp.tag = 100  and ai.DisplayOrder = cl.CurrentCarrier-- this will make sure that we select current carrier when primary and secondary are the same
 
  --select * from @ecf
  
  Update @ecf
	Set GroupOrInd=	dbo.UDF_getFormatVaribleValue (2, ecf.ElectronicClaimFormatUid ,9,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), -- Electronic==2, Filing Type = 9
	    filingTypeSSN = dbo.UDF_getFormatVariableValue2 (2, ecf.ElectronicClaimFormatUid ,9,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), -- Electronic==2, Filing Type=9, Get Value2 ( If 1 then SSN else EIN )
		SSN = COALESCE ( NULLIF(dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), ''),
		                 ISNULL(p.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,''))
 FROM @ecf ecf
	INNER JOIN superbill sb with (nolock) on ecf.SuperbillUid = sb.SuperbillUid 
    INNER JOIN ViewSuperbillFinancialDetails with (nolock) ON ViewSuperbillFinancialDetails.superbillUid = sb.SuperbillUid and sb.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
INNER JOIN provider with (nolock) ON provider.PersonUID = ViewSuperbillFinancialDetails.ClaimingProviderUid    --We have to use RenderingProviderUid  :Aji 2005 10 21 
    INNER JOIN Person p with (nolock) on Provider.PersonUid = p.PersonUid 
	
  Update @ecf
	SET IsIndividual= CASE (ecf.GroupOrInd) WHEN '1' THEN 1
										    WHEN 'individual' THEN 1
										    ELSE 0 END
  FROM @ecf ecf 
			
  --select * from @ecf
  
  -- Find the NPI Override for the ListClaimFormat ( if one exists )
  UPDATE @ecf
	SET NPIOverrideUid = cfvt.ClaimFormatValueTypeUid,
		NPIOverrideFixedValue = cfo.FixedValue
	FROM @ecf ecf
			INNER JOIN ClaimFormatOption cfo with (nolock) ON ecf.ElectronicClaimFormatUid = cfo.ClaimFormatUid
			INNER JOIN ListClaimFormatOptionType cfot with (nolock) ON cfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			INNER JOIN ListClaimFormatValueType cfvt with (nolock) on cfo.ClaimFormatValueTypeUid = cfvt.ClaimFormatValueTypeUid
	WHERE cfo.ClaimFormatUid = ecf.ElectronicClaimFormatUid								-- cf.Name = 'e-Medicare'
 			--and cfot.ClaimFormatOptionTypeUid = '39EAD079-2603-4D12-9D94-C96585C39185'	-- cfot.Name = 'NPI Override'
			and cfot.Name = 'NPI Override'
 
   --select * from @ecf
 END

SET @claimsFetched =0  
INSERT INTO #XMLClaims_temp 
( 
	tag,  
	parent,  
	[SITE!100!PID],  
	[SITE!100!eClaimBatchGUID],  
	[SITE!100!claimSubmitterID!hide],  
	[SITE!100!payToAddressID!hide],  
	[CLAIM!400!PID],  
	[CLAIM!400!accountNumber],  
	[CLAIM!400!totalBill],  
	[CLAIM!400!diag1],  
	[CLAIM!400!diag2],  
	[CLAIM!400!diag3],  
	[CLAIM!400!diag4],  
	[CLAIM!400!diag5],  
	[CLAIM!400!diag6],  
	[CLAIM!400!diag7],  
	[CLAIM!400!diag8],  
	[PAYER!230!ID!hide],  
	[PAYER!230!planType!hide],  
	[PATIENT!300!PEID],  
	[SUBSCRIBER!200!PEID],  
	[RESPONSIBLEPARTY!240!ID!hide],
	[RESPONSIBLEPARTY!240!PEID],			--Added by AW for 2010BC loop  2006 03 15
	[SUBSCRIBER!200!payerResponsibility],
	[SUBSCRIBER!200!DisplayOrder], --ADDED FOR SECONDARY CLAIMS   
	[PATIENT!300!patientRelationToInsured],  
	[CLAIM!400!patientMemberID],  
	[CLAIM!400!patientgroupID],  
	[CLAIM!400!subscriberMemberID],  
	[CLAIM!400!authorizeAssignment],  
	[RENDERER!410!ID!hide],  
	[RENDERER!410!PEID],  
	[PROVIDER!110!PID],	
	[ATTENDING!140!PID],		
	[ATTENDING!140!PEID],
	[ATTENDING!140!FCID],
	[ATTENDING!140!FileAsGroup],
	[SUPERVISING!150!PID],		
	[SUPERVISING!150!PEID],
	[SUPERVISING!150!FCID],
	[SUPERVISING!150!FileAsGroup],
	[OPERATING!160!PID],		
	[OPERATING!160!PEID],
	[OPERATING!160!FCID],
	[OPERATING!160!FileAsGroup],
	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup], 
	[REFERRER!420!PID],  
	[CLAIM!400!providerID],  
	[CLAIM!400!providerIDType],  
	[CLAIM!400!providerGroupID],  
	[CLAIM!400!providerGroupIDType],
	[CLAIM!400!facilityPrimaryID],
	[CLAIM!400!facilityPrimaryIDType],
	[CLAIM!400!facilityID],  
	[CLAIM!400!facilityIDType],
	[PAYTOPROVIDER!130!IDType],  
	[PAYTOPROVIDER!130!ID], 
	[PAYTOPROVIDER!130!NPISecIDType],
	[PAYTOPROVIDER!130!NPISecID],
	[CLAIMCOB!401!COBID],------------
	[BILLINGPROVIDER!120!IDType],  
	[BILLINGPROVIDER!120!ID],
	[BILLINGPROVIDER!120!IDType_Dr],
	[BILLINGPROVIDER!120!ID_Dr],	
	[BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID],
	[BILLINGPROVIDER!120!NPISecIDType_Dr],
	[BILLINGPROVIDER!120!NPISecID_Dr],
	[PROC!450!emergency],  
	[CLAIM!400!claimFrequencyCode],  
	[CLAIM!400!providerSignatureOnFile],  
	[CLAIM!400!providerAcceptAssignment],  
	[CLAIM!400!patientAcceptAssignment],  
	[CLAIM!400!releaseOfInformation],  
	[CLAIM!400!patientSignatureSource],  
	[CLAIM!400!patientSignatureDate],  
	[CLAIM!400!siteType],  
	[CLAIM!400!relatedCausesCode],  
	[CLAIM!400!accidentState],  
	[CLAIM!400!accidentDate],   
	[CLAIM!400!onsetCurrentDate],  
	[CLAIM!400!onsetFirstDate],  
	[CLAIM!400!noWorkFromDate],  
	[CLAIM!400!noWorkToDate],  
	[CLAIM!400!hospitalizationStartDate],  
	[CLAIM!400!hospitalizationEndDate],  
	[CLAIM!400!familyPlan], 
	[CLAIM!400!priorAuthorizationCode],	
	[CLAIM!400!SendNPI],
	[CLAIM!400!Dmerc], 	
	[CLAIM!400!ICN],				--ADDED ICN NUMBER REPORTED IN LOOP 2300 6/19/08
	[CLAIM!400!EPSDT],				--SC Added for CLM12 05/21/09
	[CLAIM!400!delayReasonCode],	--SC Added for CLM20 05/21/09
	[CLAIM!400!BillingProvider_IDType],  
	[CLAIM!400!BillingProvider_ID],		 
	[CLAIM!400!primaryCarrierUID],
	[CLAIM!400!currentCarrierUID],
    [CLAIM!400!PatientPaidAmount],	
    [CLAIM!400!ResubmissionCode],
 	[SERVICEFACILITY!430!PID],  
	[PROC!450!serviceLocation] ,
	[PROC!450!lineControlNo],
	[SUBSCRIBER!200!isWCC],  -- added by SM   
	[RESPONSIBLEPARTY!240!isCorporation],			--Added by AW for 2010BC loop  2006 03 15
	[FINANCIALCENTER!105!FCID],
	[CLAIM!400!UseICD10],
    [CLAIM!400!ElectronicClaimFormatUid]
	)  
	SELECT DISTINCT  
	400     AS tag,  
--	(CASE WHEN account.personUID = COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) THEN 200 ELSE 300 END)      AS parent, 
  -- test
  
  (CASE WHEN @scrubsubscriber = 2 and ListRelationship.ANSICode  = 18 THEN 200
        WHEN @scrubsubscriber = 2 and ListRelationship.ANSICode <> 18 THEN 300
        WHEN account.personUID = COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) THEN 200 
		ELSE 300  END)      AS parent,  
 
	[SITE!100!PID]    AS [SITE!100!PID],   
	[SITE!100!eClaimBatchGUID]  AS [SITE!100!eClaimBatchGUID],    
	[SITE!100!claimSubmitterID!hide] AS [SITE!100!claimSubmitterID!hide],   
	[SITE!100!payToAddressID!hide]  AS [SITE!100!payToAddressID!hide],   
	superbill.SuperbillUid   AS [CLAIM!400!PID],  --SuperbillUid  
	CONVERT(VARCHAR(50),superbill.externalID) AS [CLAIM!400!accountNumber],  
    --CAST((SELECT SUM(ISNULL(TotalCharge,0)) FROM SuperbillProcedure sbp   
				--LEFT JOIN ListContractTypeCode ON ListContractTypeCode.ContractTypeCodeUid = sbp.ContractTypeCodeUid
				--LEFT JOIN ListProcedure on ListProcedure.ProcedureUID = sbp.ProcedureUID
				--INNER JOIN ViewSuperbillProcedure_IsVoid on ViewSuperbillProcedure_IsVoid.SuperbillProcedureUid = sbp.SuperbillProcedureUid  --added per bug 9450
				--WHERE sbp.SuperbillUid = superbill.superbillUid AND /*--added per bug 9450*/ViewSuperbillProcedure_IsVoid.IsVoid = '0' AND 
				--	(ISNULL(ListContractTypeCode.Name,'') <> 'NF' AND ISNULL(ListContractTypeCode.ANSICode,'') <> 'NF') AND
				--		ISNULL(sbp.DontClaim, 0) = 0 ) 
				-- AS VARCHAR(50))  
			 --  AS [CLAIM!400!totalBill],  
    0 AS [CLAIM!400!totalBill],      -- Now calculated in AR_genXMLClaims_Proc
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd1.Code10, sbd1.Code9), '' ) ELSE NULLIF( sbd1.Code9, '' ) END AS [CLAIM!400!diag1],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd2.Code10, sbd2.Code9), '' ) ELSE NULLIF( sbd2.Code9, '' ) END AS [CLAIM!400!diag2],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd3.Code10, sbd3.Code9), '' ) ELSE NULLIF( sbd3.Code9, '' ) END AS [CLAIM!400!diag3],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd4.Code10, sbd4.Code9), '' ) ELSE NULLIF( sbd4.Code9, '' ) END AS [CLAIM!400!diag4],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd5.Code10, sbd5.Code9), '' ) ELSE NULLIF( sbd5.Code9, '' ) END AS [CLAIM!400!diag5],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd6.Code10, sbd6.Code9), '' ) ELSE NULLIF( sbd6.Code9, '' ) END AS [CLAIM!400!diag6],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd7.Code10, sbd7.Code9), '' ) ELSE NULLIF( sbd7.Code9, '' ) END AS [CLAIM!400!diag7],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd8.Code10, sbd8.Code9), '' ) ELSE NULLIF( sbd8.Code9, '' ) END AS [CLAIM!400!diag8],
	InsuranceCarrier.CorporationUid  AS [PAYER!230!ID!hide],  --InsuranceCarrier.CorporationUid  
	Claimbatchdetail.InsurancePlanUid AS [PAYER!230!planType!hide],   --????payer.planType  
	Superbill.PatientUid    AS [PATIENT!300!PEID],  
	COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) AS [SUBSCRIBER!200!PEID],   
	COALESCE(AccountResponsibleParty.PersonUid, AccountResponsibleParty.CorporationUid)	AS  [RESPONSIBLEPARTY!240!ID!hide],				--Added by AW for 2010BC loop  2006 03 15
	COALESCE(AccountResponsibleParty.PersonUid, AccountResponsibleParty.CorporationUid)	AS  [RESPONSIBLEPARTY!240!PEID],				--Added by AW for 2010BC loop  2006 03 15
  
	(CASE WHEN AccountInsurance.DisplayOrder = 1 THEN 'P'  
		  WHEN AccountInsurance.DisplayOrder = 2 THEN 'S'  
	      ELSE 'T'  END)        AS [SUBSCRIBER!200!payerResponsibility],  
	AccountInsurance.DisplayOrder AS [SUBSCRIBER!200!DisplayOrder],
	ListRelationship.ANSICode      AS [PATIENT!300!patientRelationToInsured],  
	LTRIM(RTRIM((ISNULL(PersonInsurancePlan.PlanMemberID, '') + ISNULL(AccountInsurance.policyNumberSuffix, '')))) AS [CLAIM!400!patientMemberID],  
	PersonInsurancePlan.PlanGroupID    AS [CLAIM!400!patientgroupID],  
	UPPER(LTRIM(RTRIM((ISNULL(PersonInsurancePlan.PlanMemberID, '') + ISNULL(AccountInsurance.policyNumberSuffix, ''))))) AS [CLAIM!400!subscriberMemberID],  
	PersonInsurancePlan.AuthorizeAssignment   AS [CLAIM!400!authorizeAssignment],  
	LOWER(ViewSuperbillFinancialDetails.ClaimingProviderUid)     AS [RENDERER!410!ID!hide],  --DEFECT #10494
	ViewSuperbillFinancialDetails.ClaimingProviderUid      AS [RENDERER!410!PEID],			--DEFECT #10494
	CASE 
		WHEN ISNULL(ub.SupervisingProviderUid,@zeroGuid) <> @zeroGuid THEN ub.SupervisingProviderUid
        WHEN ISNULL(ub.AttendingProviderUid,@zeroGuid) <> @zeroGuid THEN ub.AttendingProviderUid
        ELSE ViewSuperbillFinancialDetails.ClaimingProviderUid END AS [PROVIDER!110!PID],	
	LOWER(ub.AttendingProviderUid) AS 	[ATTENDING!140!PID],		
	ub.AttendingProviderUid AS [ATTENDING!140!PEID],
	ViewSuperbillFinancialDetails.financialCenterUid AS [ATTENDING!140!FCID],	
	CASE WHEN (ecf.IsIndividual =1)
	   THEN 0	   
	   ELSE 1	END AS [ATTENDING!140!FileAsGroup],
	LOWER(ub.SupervisingProviderUid) AS [SUPERVISING!150!PID],
	ub.SupervisingProviderUid AS [SUPERVISING!150!PEID],
	ViewSuperbillFinancialDetails.financialCenterUid AS [SUPERVISING!150!FCID],
	CASE WHEN (ecf.IsIndividual =1)
       THEN 0	   
	     ELSE 1	END AS [SUPERVISING!150!FileAsGroup],
	LOWER(ub.OperatingProviderUid) AS [OPERATING!160!PID],
	ub.OperatingProviderUid AS [OPERATING!160!PEID],
	ViewSuperbillFinancialDetails.financialCenterUid AS [OPERATING!160!FCID],
	CASE WHEN (ecf.IsIndividual =1)
       THEN 0	   
	     ELSE 1	END AS [OPERATING!160!FileAsGroup],
	ViewSuperbillFinancialDetails.financialCenterUid	AS [BILLINGPROVIDER!120!FCID],
	CASE WHEN (ecf.IsIndividual =1)
	   THEN 0	   
		 ELSE 1	END AS [BILLINGPROVIDER!120!FileAsGroup],
    COALESCE(pc.ReferredByProviderUid, superbill.referringProviderUid)     AS [REFERRER!420!PID],  
	dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid,  
	  0,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) AS [CLAIM!400!providerID],  
 
	dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
	  ,1,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) AS [CLAIM!400!providerIDType],  
  
	dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
	  ,CASE WHEN (ecf.IsIndividual =1)
		  THEN 0 ELSE 2 END,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) AS [CLAIM!400!providerGroupID],  
 
	dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  ,CASE WHEN (ecf.IsIndividual =1)
		THEN 1 ELSE 3 END ,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) AS [CLAIM!400!providerGroupIDType],  

	CASE WHEN lcf.SendNPI = 1 THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '')
		 ELSE '' END AS [CLAIM!400!facilityPrimaryID],

	CASE WHEN lcf.SendNPI = 1 THEN 'XX' ELSE '' END [CLAIM!400!facilityPrimaryIDType],
 
	dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
	  ,6,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)) AS [CLAIM!400!facilityID],  
 
	dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid,7,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) AS [CLAIM!400!facilityIDType],  
 
	(CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @PayToProviderNPIUid
				ELSE @ServiceSiteNPIUid END ,0,NULL, NULL,ViewSuperbillFinancialDetails.ServiceSiteUid, NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' THEN  
			'XX' 
		WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' THEN  
			'24'  
		ELSE  
			'34'  
	END)     AS [PAYTOPROVIDER!130!IDType],  
  
	--DEFECT #9657
	(CASE WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @PayToProviderNPIUid
				ELSE @ServiceSiteNPIUid END,0,NULL, NULL,ViewSuperbillFinancialDetails.ServiceSiteUid, NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
			dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @PayToProviderNPIUid
				ELSE @ServiceSiteNPIUid END,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid, NULL,ViewSuperbillFinancialDetails.financialCenterUid)
		WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
			dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
		WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN 
			dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
		ELSE	
			COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'')
	END)	AS [PAYTOPROVIDER!130!ID],  
 
	--DEFECT #9657
	(CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
			'EI'
		ELSE 
			''
	END)	AS [PAYTOPROVIDER!130!NPISecIDType],
	--DEFECT #9657
	(CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
			dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)
		ELSE
			''
	END)	AS [PAYTOPROVIDER!130!NPISecID],

-- [CLAIM!400!PID] AS [CLAIMCOB!401!COBID],-------------
	superbill.superbillUid AS [CLAIMCOB!401!COBID],-------------

	CASE WHEN lcf.SendNPI = 1 THEN		
		--CYS SC - Service Site NPI Override
		(CASE WHEN Exists(SELECT * FROM ClaimFormatOption cfo
				INNER JOIN [ListClaimFormatOptionType] ot ON ot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid 
					WHERE (ClaimFormatUid = ecf.ElectronicClaimFormatUid) 
					AND (ot.Name = 'NPI Override'))
				AND COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' 
			THEN 'XX'
		ELSE
		--CYS SC - Service Site NPI Override
			--DEFECT #9657
			(CASE 
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @ProviderNPIUid
					ELSE @ServiceSiteNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' THEN  
					'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' THEN  
					'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' THEN  
					'24'  
				WHEN (ecf.IsIndividual =1) THEN 
					'34'
				ELSE ''
		   END)  
		END)	--ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' THEN  
				'24'  
			WHEN (ecf.IsIndividual =1) THEN 
				'34'
			ELSE ''
	      END)
	END	   
	AS [BILLINGPROVIDER!120!IDType],  
  
	CASE WHEN lcf.SendNPI = 1 THEN
		--CYS SC - Service Site NPI Override End
		(CASE WHEN Exists(SELECT * FROM ClaimFormatOption cfo
				INNER JOIN [ListClaimFormatOptionType] ot ON ot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid 
					WHERE (ClaimFormatUid = ecf.ElectronicClaimFormatUid) 
					AND (ot.Name = 'NPI Override'))
				AND COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' 
			THEN dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)
		ELSE 
		--CYS SC - Service Site NPI Override	
		  (CASE	
				WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @ProviderNPIUid
						ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)
				WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @EINUid
						ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
				WHEN (ecf.IsIndividual =1) THEN 
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN 
							dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
						ELSE COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
				ELSE ''

			END) 
		END) --ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
			WHEN (ecf.IsIndividual =1) THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
					ELSE	
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
			ELSE ''
		  END)
	END AS [BILLINGPROVIDER!120!ID],

	--Get Individual Dr IDs regardless of Filing Type 
	CASE WHEN lcf.SendNPI = 1 THEN		
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid, 0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN 'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN  	'24'  
				ELSE '34'
		   END)  
		ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN '24'  
				ELSE '34'
				END)
	END	   
	AS [BILLINGPROVIDER!120!IDType_Dr],

	CASE WHEN lcf.SendNPI = 1 THEN
		(CASE	WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
					dbo.UDF_getFormatVaribleValue (0,  @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid)
				WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 	
					dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
				ELSE				
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE COALESCE(Person.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
		END) 
	ELSE 
		(CASE	
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 	
						dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
			ELSE				
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE COALESCE(Person.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
  		END)
	END 
	 AS [BILLINGPROVIDER!120!ID_Dr],	
	 
   CASE WHEN lcf.SendNPI = 1 THEN 
	  --DEFECT #9657
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @ProviderNPIUid
				ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
				'EI'
			WHEN (ecf.IsIndividual =1) THEN 
				'SY'
			ELSE ''
		END)	
    ELSE ''
	END	AS [BILLINGPROVIDER!120!NPISecIDType],


   CASE WHEN lcf.SendNPI = 1 THEN 
	  --DEFECT #9657
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @ProviderNPIUid
				ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual =1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 					
			WHEN (ecf.IsIndividual =1) THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 				
					ELSE
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
			ELSE
				''
		END)
	ELSE ''
	END	AS [BILLINGPROVIDER!120!NPISecID],

	/* Individual Dr ID regardless of filing type */
   CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN
				'EI'
			ELSE 'SY'
		END)	
    ELSE ''
	END	AS [BILLINGPROVIDER!120!NPISecIDType_Dr],

	/* Individual Dr ID regardless of filing type */
   CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 					
			ELSE
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
					dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 				
				ELSE
					COALESCE(Person.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
		END)
	ELSE ''
	END	AS [BILLINGPROVIDER!120!NPISecID_Dr],

   (CASE WHEN superbill.emergency = 1 THEN 'Y' END)        AS [PROC!450!emergency],  
    -- use sb.ResubmissionCode 1st then try TypeOfBill 
    COALESCE(  SUBSTRING(superbill.ResubmissionCode, 1, nullif(charindex(';', superbill.ResubmissionCode)-1, -1)), -- 1) ResubmissionCode frequency value ( i.e. 7;ICN12345 )
			   SUBSTRING(ub.TypeOfBill, 3, 1)														 -- 1st == Type of facility; 2nd == bill classification; 3rd == frequency
		    ) AS [CLAIM!400!claimFrequencyCode],
    'Y'    AS [CLAIM!400!providerSignatureOnFile],  
  
  -- CLM07
  (CASE WHEN superbill.UsePrimaryPayerAcceptAssignment = 1 
		THEN ( CASE WHEN primaryIC.AcceptAssignment = 1        THEN 'A'	-- Assigned
					WHEN primaryIC.AcceptAssignmentLabOnly = 1 THEN 'B'	-- Lab Only
					ELSE 'C' END )										-- Not Assigned
		ELSE
			( CASE WHEN superbill.AcceptAssignment = 1		   THEN 'A'	-- Assigned  
					WHEN superbill.AcceptAssignmentLabOnly = 1 THEN 'B'	-- Lab Only
					ELSE 'C' end )										-- Not Assigned
	END)        AS [CLAIM!400!providerAcceptAssignment],  -- CLM07
   
    -- CLM08 
    (CASE WHEN PersonInsurancePlan.AuthorizeAssignment = 1 THEN 'Y' ELSE 'N' END)        AS [CLAIM!400!patientAcceptAssignment], 
    -- JW 1/16/06 In GA4 we're going to assume the box is always check use this logic. 	
    (CASE WHEN 1 = 1 THEN 'Y' ELSE  '' END)        AS [CLAIM!400!releaseOfInformation],   
    (CASE WHEN PersonInsurancePlan.AuthorizeAssignment = 1 THEN 'B' ELSE 'S' END) AS  [CLAIM!400!patientSignatureSource],   
    CONVERT(VARCHAR,superbill.ServiceDateStart,101)   AS [CLAIM!400!patientSignatureDate],  
    ListServiceSiteType.ANSICode      AS [CLAIM!400!siteType],  
	ListRelatedCause.ANSICode     AS [CLAIM!400!relatedCausesCode],  
	superbill.RelatedCauseState     AS [CLAIM!400!accidentState],    
	ISNULL(superbill.RelatedCauseDate, superbill.OnsetDate)  AS [CLAIM!400!accidentDate],  
	superbill.onsetDate       AS [CLAIM!400!onsetCurrentDate],  
	superbill.onsetFirstDate      AS [CLAIM!400!onsetFirstDate],  
	superbill.noWorkFromDate     AS [CLAIM!400!noWorkFromDate],  
	superbill.noWorkToDate      AS [CLAIM!400!noWorkToDate],  
	superbill.HospitalizationStartDate     AS [CLAIM!400!hospitalizationStartDate],  
	superbill.HospitalizationEndDate     AS [CLAIM!400!hospitalizationEndDate],  
	superbill.EPSDT       AS [CLAIM!400!familyPlan],  
 CASE WHEN Superbillaggregate.CurrentCarrier = 1 THEN COALESCE(superbill.PriorAuthorizationCode, '')						-- Primary
	     WHEN Superbillaggregate.CurrentCarrier = 2 THEN COALESCE(superbill.PriorAuthorizationCode_InsuranceCarrier2, '')		-- Secondary
	     WHEN Superbillaggregate.CurrentCarrier = 3 THEN COALESCE(superbill.PriorAuthorizationCode_InsuranceCarrier3, '')		-- Tertiary
	     ELSE '' END AS [CLAIM!400!priorAuthorizationCode],
	lcf.SendNPI AS [CLAIM!400!SendNPI],
	lcf.Dmerc AS [CLAIM!400!Dmerc],	
	CONVERT(VARCHAR(50),cobcd.ICN) AS [CLAIM!400!ICN],				--ADDED ICN NUMBER REPORTDED IN LOOP 2300 6/19/08
	
	superbill.EPSDT AS [CLAIM!400!EPSDT],								--CYS SC 05/21/09 - Added for CLM12  
	ISNULL(ListDelayReason.ANSICode,'') AS [CLAIM!400!delayReasonCode],	--CYS SC 05/21/09 - Added for CLM20  
	'' AS [CLAIM!400!BillingProvider_IDType],   
	'' AS [CLAIM!400!BillingProvider_ID],		
	superbillaggregate.PrimaryInsurancePlanUID AS [CLAIM!400!primaryCarrierUID] ,
	superbillaggregate.CurrentInsurancePlanUID AS [CLAIM!400!currentCarrierUID] ,
    (Case WHEN ( pis.Value IS NOT NULL AND pis.Value like '%17667(True)%') THEN vsa.UnAssignedDistribution ELSE NULL END) AS [CLAIM!400!PatientPaidAmount], -- See bug 17667	
    superbill.ResubmissionCode AS [CLAIM!400!ResubmissionCode],
  	ViewSuperbillFinancialDetails.ServiceSiteUid      AS [SERVICEFACILITY!430!PID],  
	ListServiceSiteType.ANSICode     AS [PROC!450!serviceLocation],  
	Superbill.ExternalID	AS [PROC!450!lineControlNo],
    CASE WHEN PersonInsurancePlan.PersonUid IS NOT NULL THEN 0  
         WHEN PersonInsurancePlan.CorporationUid IS NOT NULL THEN 1 END AS [SUBSCRIBER!200!isWCC] ,
    CASE WHEN AccountResponsibleParty.PersonUid IS NOT NULL THEN 0  
         WHEN AccountResponsibleParty.CorporationUid IS NOT NULL THEN 1 END AS [RESPONSIBLEPARTY!240!isCorporation],  	--Added by AW for 2010BC loop  2006 03 15  
    ViewSuperbillFinancialDetails.financialCenterUid   AS  [FINANCIALCENTER!105!FCID],
    CASE WHEN InsuranceCarrier.ICD10Date <= Superbill.ServiceDateStart THEN 1 ELSE 0 END AS [CLAIM!400!UseICD10],
    ecf.[ElectronicClaimFormatUid] AS [CLAIM!400!ElectronicClaimFormatUid]
	FROM #XMLClaims_temp  
		INNER JOIN ClaimBatch with (nolock) ON  
		ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
		INNER JOIN ClaimBatchDetail with (nolock) ON ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid   
		INNER JOIN superbill with (nolock) ON superbill.superbillUid = ClaimBatchDetail.SuperBillUid 
									and  superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
		INNER JOIN Superbillaggregate with (nolock) ON superbill.SuperbillUid = SuperbillAggregate.SuperbillUid  
		INNER JOIN  ViewSuperbillFinancialDetails with (nolock) ON  ViewSuperbillFinancialDetails.superbillUid = superbill.SuperbillUid and superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
		INNER JOIN account with (nolock) ON account.accountUid = superbill.accountUid  
		INNER JOIN AccountResponsibleParty with (nolock) ON Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
		--INNER JOIN AccountPeriod with (nolock) ON	AccountPeriod.Accountuid = account.accountUid  
		--				AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
		--				  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
		--				  OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
		--				  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
		INNER JOIN AccountInsurance with (nolock)  ON  AccountInsurance.AccountPeriodUid = Superbillaggregate.AccountPeriodUid 
											AND SuperbillAggregate.CurrentCarrier = AccountInsurance.DisplayOrder
		INNER JOIN PersonInsurancePlan with (nolock) ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
											-- AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
		INNER JOIN InsurancePlan with (nolock) ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
		INNER JOIN InsuranceCarrier with (nolock) ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  
		INNER JOIN @ecf ecf ON Superbill.SuperbillUid = ecf.SuperbillUid
		LEFT JOIN ListClaimFormat lcf with (nolock) ON lcf.ClaimFormatUid = (ecf.ElectronicClaimFormatUid)	
	    INNER JOIN AccountInsurance primaryAI with (nolock) ON primaryAI.AccountPeriodUid = Superbillaggregate.AccountPeriodUid AND primaryAI.DisplayOrder = 1
	    INNER JOIN PersonInsurancePlan primaryPIP with (nolock) ON primaryAI.PersonInsurancePlanUid = primaryPIP.PersonInsurancePlanUid 
	    INNER JOIN InsurancePlan primaryIP with (nolock) ON primaryPIP.InsurancePlanUid = primaryIP.InsurancePlanUid
	    INNER JOIN InsuranceCarrier primaryIC with (nolock) ON primaryIP.InsuranceCarrierUid = primaryIC.CorporationUid
        INNER JOIN AR_ViewSuperbillAggregate vsa with (nolock) ON Superbill.SuperbillUid = vsa.SuperbillUid
		-- THIS WILL BE SENT AS THE CLAIM RENDERING PROVIDER         
		INNER JOIN provider with (nolock) ON provider.PersonUID = ViewSuperbillFinancialDetails.ClaimingProviderUid    --We have to use RenderingProviderUid  :Aji 2005 10 21  
		INNER JOIN Person with (nolock) ON Person.PersonUid = Provider.PersonUid  
		INNER JOIN ListServiceSite with (nolock) ON ListServiceSite.serviceSiteUID = ViewSuperbillFinancialDetails.ServiceSiteUid   
		LEFT JOIN ListServiceSiteType ListServiceSiteType with (nolock) ON ListServiceSiteType.ServiceSiteTypeUid = ListServiceSite.ServiceSiteTypeUid  
		LEFT JOIN ListRelationship ListRelationship with (nolock) ON ListRelationship.RelationshipUid = AccountInsurance.RelationshipUid   
		LEFT JOIN ListRelatedCause ListRelatedCause with (nolock) ON ListRelatedCause.RelatedCauseUid = superbill.RelatedCauseUid   
		LEFT JOIN ListDelayReason ListDelayReason with (nolock) ON ListDelayReason.DelayReasonUid = superbill.DelayReasonUid
		INNER JOIN ListSuperBillStatus with (nolock) ON Superbill.SuperbillStatusUid  = ListSuperBillStatus.SuperbillStatusUid  
		LEFT JOIN SuperbillDiagnosis sbd1 with (nolock) ON sbd1.SuperBillUid = superbill.superbillUid AND sbd1.DisplayOrder =1  
		LEFT JOIN SuperbillDiagnosis sbd2 with (nolock) ON sbd2.SuperBillUid = superbill.superbillUid AND sbd2.DisplayOrder =2  
		LEFT JOIN SuperbillDiagnosis sbd3 with (nolock) ON sbd3.SuperBillUid = superbill.superbillUid AND sbd3.DisplayOrder =3  
		LEFT JOIN SuperbillDiagnosis sbd4 with (nolock) ON sbd4.SuperBillUid = superbill.superbillUid AND sbd4.DisplayOrder =4  
		LEFT JOIN SuperbillDiagnosis sbd5 with (nolock) ON sbd5.SuperBillUid = superbill.superbillUid AND sbd5.DisplayOrder =5    
		LEFT JOIN SuperbillDiagnosis sbd6 with (nolock) ON sbd6.SuperBillUid = superbill.superbillUid AND sbd6.DisplayOrder =6  
		LEFT JOIN SuperbillDiagnosis sbd7 with (nolock) ON sbd7.SuperBillUid = superbill.superbillUid AND sbd7.DisplayOrder =7  
		LEFT JOIN SuperbillDiagnosis sbd8 with (nolock) ON sbd8.SuperBillUid = superbill.superbillUid AND sbd8.DisplayOrder =8  
		LEFT JOIN COBClaimDetail  cobcd with (nolock) ON cobcd.SuperBillUid = superbill.superbillUid AND cobcd.InsuranceOrder = AccountInsurance.DisplayOrder
		INNER JOIN Patient with (nolock) ON Patient.PersonUid = Superbill.PatientUid  
		LEFT JOIN ListSignatureSource with (nolock) ON Patient.SignatureSourceUid = ListSignatureSource.SignatureSourceUid  
		LEFT JOIN PatientCase pc with (nolock) on superbill.PatientCaseUid = pc.PatientCaseUid
        LEFT OUTER JOIN PlugInSettings pis with (nolock) on ClaimBatch.ClaimClearingHouseUid = pis.ClaimClearingHouseUid AND pis.Name = 'SpecialCase'
        LEFT OUTER JOIN SuperbillUB ub with (nolock) ON ub.SuperbillUid = superbill.SuperbillUid
 	 WHERE  
	  #XMLClaims_temp.tag = 100  

	SET @claimsFetched = @@ROWCOUNT

	--CYS SC 07/08/09 - Added for Service Site bug (CYS Case #22420)
	UPDATE #XMLClaims_temp SET 
		[CLAIM!400!BillingProvider_IDType] = [BILLINGPROVIDER!120!IDType],
		[CLAIM!400!BillingProvider_ID] = [BILLINGPROVIDER!120!ID]
	WHERE tag = 400

  -- CHC
Update #XMLClaims_temp
	Set [CLAIM!400!ChcBillingType] = cap.BillingType
FROM #XMLClaims_temp 
		INNER JOIN Superbill sb with (nolock) on #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid
		inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid= sba.SuperbillUid
		INNER JOIN ChcInsurancePlan cip with (nolock) on sba.CurrentInsurancePlanUid = cip.InsurancePlanUid
		INNER JOIN ChcListApprovalSetting cas with (nolock) on cip.ApprovalSettingUid = cas.ApprovalSettingUid
		INNER JOIN ChcApprovalPeriod cap with (nolock) on cas.ApprovalSettingUid = cap.ApprovalSettingUid
															AND (cap.EffectiveDate IS NULL OR sb.ServiceDateStart >= cap.EffectiveDate )
															AND (cap.ExpirationDate	IS NULL OR sb.ServiceDateStart <= cap.ExpirationDate )
WHERE #XMLClaims_temp.tag = 400



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_CLAIM_UB]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_CLAIM_UB] AS' 
END
GO
-- 2014-12-05 dsw - 34159 Performance improvements by using SuperbillAggregate.AccountPeriod
-- 2015-11-12 dsw - Bug 43559: Admitting and E-Code Dx on UB tab are sending out ICD-9 instead of ICD-10

ALTER PROC [dbo].[AR_genXMLClaims_Inst_CLAIM_UB]  
 @ClaimBatchUid UniqueIdentifier  
AS

DECLARE @zeroGuid as UniqueIdentifier
SET @zeroGuid = '00000000-0000-0000-0000-000000000000'

 INSERT INTO #XMLClaims_temp  
 (  
	/* Sort */
	tag,  
	parent,  
	[SITE!100!PID],  
	[SITE!100!eClaimBatchGUID],		
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
		
	[CLAIM!400!PID],    
	[PATIENT!300!PEID],  
	[SUBSCRIBER!200!PEID],  

	[PROVIDER!110!PID],			--CYS SC 11/03/08

	[RENDERER!410!ID!hide],		
	[RENDERER!410!PEID],
	[FINANCIALCENTER!105!FCID],	
	/* Sort */

/* CYS SC */	  
	[CLAIMUB!405!typeOfBill],		
	[CLAIMUB!405!dischargeTime],
	[CLAIMUB!405!admissionTime],
	[CLAIMUB!405!coveredPeriodFrDate],
	[CLAIMUB!405!coveredPeriodToDate],
	[CLAIMUB!405!admissionTypeANSI],
	[CLAIMUB!405!admissionSourceANSI],
	[CLAIMUB!405!patientStatusUBANSI],	
	[CLAIMUB!405!claimHeaderNoteCodeANSI],
	[CLAIMUB!405!claimNote],
	[CLAIMUB!405!serviceAuthorizationExceptionANSI],
	[CLAIMUB!405!admittingDiag],
	[CLAIMUB!405!externalInjuryDiag],
	[CLAIMUB!405!drgProc],
    [CLAIMUB!405!otherProc1],
	[CLAIMUB!405!otherProc1ANSI],
	[CLAIMUB!405!otherProc1Date],
	[CLAIMUB!405!otherProc2],
	[CLAIMUB!405!otherProc2ANSI],
	[CLAIMUB!405!otherProc2Date],
	[CLAIMUB!405!otherProc3],
	[CLAIMUB!405!otherProc3ANSI],
	[CLAIMUB!405!otherProc3Date],
	[CLAIMUB!405!otherProc4],
	[CLAIMUB!405!otherProc4ANSI],
	[CLAIMUB!405!otherProc4Date],
	[CLAIMUB!405!occurrenceSpan1ANSI],
	[CLAIMUB!405!occurrenceSpan1FrDate],
	[CLAIMUB!405!occurrenceSpan1ToDate],
	[CLAIMUB!405!occurrenceSpan2ANSI],
	[CLAIMUB!405!occurrenceSpan2FrDate],
	[CLAIMUB!405!occurrenceSpan2ToDate],
	[CLAIMUB!405!occurrenceCode1ANSI],
	[CLAIMUB!405!occurrenceCode1Date],
	[CLAIMUB!405!occurrenceCode2ANSI],
	[CLAIMUB!405!occurrenceCode2Date],
	[CLAIMUB!405!occurrenceCode3ANSI],
	[CLAIMUB!405!occurrenceCode3Date],
	[CLAIMUB!405!occurrenceCode4ANSI],
	[CLAIMUB!405!occurrenceCode4Date],
	[CLAIMUB!405!occurrenceCode5ANSI],
	[CLAIMUB!405!occurrenceCode5Date],
	[CLAIMUB!405!occurrenceCode6ANSI],
	[CLAIMUB!405!occurrenceCode6Date],
	[CLAIMUB!405!occurrenceCode7ANSI],
	[CLAIMUB!405!occurrenceCode7Date],
	[CLAIMUB!405!occurrenceCode8ANSI],
	[CLAIMUB!405!occurrenceCode8Date],
	[CLAIMUB!405!valueCode1ANSI],
	[CLAIMUB!405!valueCode1Amount],
	[CLAIMUB!405!valueCode2ANSI],
	[CLAIMUB!405!valueCode2Amount],
	[CLAIMUB!405!valueCode3ANSI],
	[CLAIMUB!405!valueCode3Amount],
	[CLAIMUB!405!valueCode4ANSI],
	[CLAIMUB!405!valueCode4Amount],
	[CLAIMUB!405!conditionCode1ANSI],
	[CLAIMUB!405!conditionCode2ANSI],
	[CLAIMUB!405!conditionCode3ANSI],
	[CLAIMUB!405!conditionCode4ANSI],
	[CLAIMUB!405!coverageDays],
	[CLAIMUB!405!nonCoveredDays],
	[CLAIMUB!405!coInsuranceDays],
	[CLAIMUB!405!lifetimeReserveDays]
   /* CYS SC */	

  )  
  SELECT DISTINCT  
	/* Sort */  
	405     AS tag,  
	400  	AS parent,
    [SITE!100!PID]    AS [SITE!100!PID],				
	[SITE!100!eClaimBatchGUID]  AS [SITE!100!eClaimBatchGUID],		
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],

	superbill.SuperbillUid   AS [CLAIM!400!PID],  
	Superbill.PatientUid    AS [PATIENT!300!PEID],  
	NULL AS [SUBSCRIBER!200!PEID],
	--[SUBSCRIBER!200!PEID] AS [SUBSCRIBER!200!PEID],
	--COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) AS [SUBSCRIBER!200!PEID],   
	
	--???[PROVIDER!110!PID] AS [PROVIDER!110!PID],			--CYS SC 11/03/08
	CASE 
		WHEN ISNULL(superbillUB.SupervisingProviderUid,@zeroGuid) <> @zeroGuid THEN superbillUB.SupervisingProviderUid
        WHEN ISNULL(superbillUB.AttendingProviderUid,@zeroGuid) <> @zeroGuid THEN superbillUB.AttendingProviderUid
        ELSE ViewSuperbillFinancialDetails.ClaimingProviderUid END AS [PROVIDER!110!PID],	

	LOWER(ViewSuperbillFinancialDetails.ClaimingProviderUid)     AS [RENDERER!410!ID!hide],  --DEFECT #10494
	ViewSuperbillFinancialDetails.ClaimingProviderUid			 AS [RENDERER!410!PEID],
	ViewSuperbillFinancialDetails.financialCenterUid   AS  [FINANCIALCENTER!105!FCID],
  /* Sort */	
	
	/* CYS SC */ 		
	superbillUB.TypeOfBill				AS [CLAIMUB!405!typeOfBill],		
	superbillUB.DischargeTime			AS [CLAIMUB!405!dischargeTime],
	superbillUB.AdmissionTime			AS [CLAIMUB!405!admissionTime],
	COALESCE(superbillUB.CoveredPeriodFrDate, superbill.ServiceDateStart)		AS [CLAIMUB!405!coveredPeriodFrDate],
	COALESCE(superbillUB.CoveredPeriodToDate, superbill.ServiceDateEnd) 		AS [CLAIMUB!405!coveredPeriodToDate],
	ListAdmissionType.ANSICode			AS [CLAIMUB!405!admissionTypeANSI],
	ListAdmissionSource.ANSICode		AS [CLAIMUB!405!admissionSourceANSI],
	ListPatientStatusUB.ANSICode		AS [CLAIMUB!405!patientStatusUBANSI],	
	ListClaimHeaderNoteCode.ANSICode	AS [CLAIMUB!405!claimHeaderNoteCodeANSI],
	--superbill.ClaimNote				AS [CLAIMUB!405!claimNote],
	null								AS [CLAIMUB!405!claimNote],
	ListServiceAuthorizationException.ANSICode AS [CLAIMUB!405!serviceAuthorizationExceptionANSI],
	--superbillUB.AdmittingDiagnosisCode9 			AS [CLAIMUB!405!admittingDiag],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart 
	     THEN NULLIF( COALESCE(superbillUB.AdmittingDiagnosisCode10, superbillUB.AdmittingDiagnosisCode9), '' ) 
		 ELSE NULLIF( superbillUB.AdmittingDiagnosisCode9, '' ) END AS [CLAIMUB!405!admittingDiag],

	--superbillUB.ExternalInjuryCode9 		AS [CLAIMUB!405!externalInjuryDiag],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart 
	     THEN NULLIF( COALESCE(superbillUB.ExternalInjuryCode10, superbillUB.ExternalInjuryCode9), '' ) 
		 ELSE NULLIF( superbillUB.ExternalInjuryCode9, '' ) END AS [CLAIMUB!405!externalInjuryDiag],
	ListProcedure.Code					AS [CLAIMUB!405!drgProc],
    
	lpop1.Code						    AS [CLAIMUB!405!otherProc1],
	CASE WHEN lpct1.ExternalID = 'CPT' and lpct1.ANSICode Is Null THEN 'HC' ELSE lpct1.ANSICode END 
										AS [CLAIMUB!405!otherProc1ANSI],
	superbillUB.OtherProcedure1Date		AS [CLAIMUB!405!otherProc1Date],
	lpop2.Code						    AS [CLAIMUB!405!otherProc2],
	CASE WHEN lpct2.ExternalID = 'CPT' and lpct2.ANSICode Is Null THEN 'HC' ELSE lpct2.ANSICode END 
										AS [CLAIMUB!405!otherProc2ANSI],
	superbillUB.OtherProcedure2Date		AS [CLAIMUB!405!otherProc2Date],
	lpop3.Code						    AS [CLAIMUB!405!otherProc3],
	CASE WHEN lpct3.ExternalID = 'CPT' and lpct3.ANSICode Is Null THEN 'HC' ELSE lpct3.ANSICode END 
										AS [CLAIMUB!405!otherProc3ANSI],
	superbillUB.OtherProcedure3Date		AS [CLAIMUB!405!otherProc3Date],
	lpop4.Code						    AS [CLAIMUB!405!otherProc4],
	CASE WHEN lpct4.ExternalID = 'CPT' and lpct4.ANSICode Is Null THEN 'HC' ELSE lpct4.ANSICode END 
										AS [CLAIMUB!405!otherProc4ANSI],
	superbillUB.OtherProcedure4Date		AS [CLAIMUB!405!otherProc4Date],

	Null AS [CLAIMUB!405!occurrenceSpan1ANSI],		Null AS [CLAIMUB!405!occurrenceSpan1FrDate],
	Null AS [CLAIMUB!405!occurrenceSpan1ToDate],	Null AS [CLAIMUB!405!occurrenceSpan2ANSI],
	Null AS [CLAIMUB!405!occurrenceSpan2FrDate],	Null AS [CLAIMUB!405!occurrenceSpan2ToDate],
	Null AS [CLAIMUB!405!occurrenceCode1ANSI],		Null AS [CLAIMUB!405!occurrenceCode1Date],
	Null AS [CLAIMUB!405!occurrenceCode2ANSI],		Null AS [CLAIMUB!405!occurrenceCode2Date],
	Null AS [CLAIMUB!405!occurrenceCode3ANSI],		Null AS [CLAIMUB!405!occurrenceCode3Date],
	Null AS [CLAIMUB!405!occurrenceCode4ANSI],		Null AS [CLAIMUB!405!occurrenceCode4Date],	
	Null AS [CLAIMUB!405!occurrenceCode5ANSI],		Null AS [CLAIMUB!405!occurrenceCode5Date],
	Null AS [CLAIMUB!405!occurrenceCode6ANSI],		Null AS [CLAIMUB!405!occurrenceCode6Date],
	Null AS [CLAIMUB!405!occurrenceCode7ANSI],		Null AS [CLAIMUB!405!occurrenceCode7Date],
	Null AS [CLAIMUB!405!occurrenceCode8ANSI],		Null AS [CLAIMUB!405!occurrenceCode8Date],
	Null AS [CLAIMUB!405!valueCode1ANSI],			Null AS [CLAIMUB!405!valueCode1Amount],
	Null AS [CLAIMUB!405!valueCode2ANSI],			Null AS [CLAIMUB!405!valueCode2Amount],
	Null AS [CLAIMUB!405!valueCode3ANSI],			Null AS [CLAIMUB!405!valueCode3Amount],
	Null AS [CLAIMUB!405!valueCode4ANSI],			Null AS [CLAIMUB!405!valueCode4Amount],
	Null AS [CLAIMUB!405!conditionCode1ANSI],
	Null AS [CLAIMUB!405!conditionCode2ANSI],
	Null AS [CLAIMUB!405!conditionCode3ANSI],
	Null AS [CLAIMUB!405!conditionCode4ANSI],
	superbillUB.CoverageDays AS [CLAIMUB!405!coverageDays],
	superbillUB.NonCoveredDays AS [CLAIMUB!405!nonCoveredDays],
	superbillUB.CoInsuranceDays AS [CLAIMUB!405!coInsuranceDays],
	superbillUB.LifetimeReserveDays AS [CLAIMUB!405!lifetimeReserveDays]
	/* CYS SC */ 		
  
	FROM #XMLClaims_temp  
	/* CYS SC */
	INNER JOIN Superbill superbill ON #XMLClaims_temp.[CLAIM!400!PID] = superbill.SuperbillUid
	INNER JOIN  ViewSuperbillFinancialDetails ON  ViewSuperbillFinancialDetails.superbillUid = superbill.SuperbillUid and  
		   superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set. 
	INNER JOIN Superbillaggregate WITH (NOLOCK) ON superbill.SuperbillUid = SuperbillAggregate.SuperbillUid  
	INNER JOIN AccountInsurance WITH (NOLOCK)  ON  AccountInsurance.AccountPeriodUid = Superbillaggregate.AccountPeriodUid 
										AND SuperbillAggregate.CurrentCarrier = AccountInsurance.DisplayOrder
	INNER JOIN PersonInsurancePlan WITH (NOLOCK) ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
	INNER JOIN InsurancePlan WITH (NOLOCK) ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
	INNER JOIN InsuranceCarrier WITH (NOLOCK) ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  
    LEFT JOIN SuperbillUB superbillUB ON superbillUB.SuperbillUid = superbill.SuperbillUid
	LEFT JOIN ListAdmissionType ON ListAdmissionType.AdmissionTypeUid =	superbillUB.AdmissionTypeUid
	LEFT JOIN ListAdmissionSource ON ListAdmissionSource.AdmissionSourceUid =	superbillUB.AdmissionSourceUid
	LEFT JOIN ListPatientStatusUB ON ListPatientStatusUB.PatientStatusUBUid = superbillUB.PatientStatusUBUid
	LEFT JOIN ListClaimHeaderNoteCode ON ListClaimHeaderNoteCode.ClaimHeaderNoteCodeUid = superbill.ClaimHeaderNoteCodeUid
	LEFT JOIN ListServiceAuthorizationException ON ListServiceAuthorizationException.ServiceAuthorizationExceptionUid = superbillUB.ServiceAuthorizationExceptionUid
	LEFT JOIN ListProcedure ON ListProcedure.ProcedureUid = superbillUB.DRGProcedureUid
	LEFT JOIN ListProcedure lpop1 ON lpop1.ProcedureUid = superbillUB.OtherProcedure1Uid
	LEFT JOIN ListProcedureCodeType lpct1 ON lpct1.ProcedureCodeTypeUid = lpop1.ProcedureCodeTypeUid
	LEFT JOIN ListProcedure lpop2 ON lpop2.ProcedureUid = superbillUB.OtherProcedure2Uid
	LEFT JOIN ListProcedureCodeType lpct2 ON lpct2.ProcedureCodeTypeUid = lpop2.ProcedureCodeTypeUid
	LEFT JOIN ListProcedure lpop3 ON lpop3.ProcedureUid = superbillUB.OtherProcedure3Uid
	LEFT JOIN ListProcedureCodeType lpct3 ON lpct3.ProcedureCodeTypeUid = lpop3.ProcedureCodeTypeUid
	LEFT JOIN ListProcedure lpop4 ON lpop4.ProcedureUid = superbillUB.OtherProcedure4Uid
	LEFT JOIN ListProcedureCodeType lpct4 ON lpct4.ProcedureCodeTypeUid = lpop4.ProcedureCodeTypeUid
 WHERE  
  #XMLClaims_temp.tag = 400  

CREATE TABLE #ClaimIDS (
	[CLAIM!400!PID] UNIQUEIDENTIFIER, 
	[SUBSCRIBER!200!PEID] UNIQUEIDENTIFIER,
	[PROVIDER!110!PID] UNIQUEIDENTIFIER
)

INSERT #ClaimIDS 
	SELECT [CLAIM!400!PID], [SUBSCRIBER!200!PEID], [PROVIDER!110!PID]
	FROM #XMLClaims_temp 
	WHERE tag = '400' 

UPDATE #XMLClaims_temp 
	SET [SUBSCRIBER!200!PEID] = ci.[SUBSCRIBER!200!PEID],
	[PROVIDER!110!PID] = ci.[PROVIDER!110!PID]
FROM #XMLClaims_temp 
INNER JOIN #ClaimIDS ci on ci.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
WHERE tag = '405' 

DROP TABLE #ClaimIDS

--Billing Provider Individual IDs

----Occurrence Span Codes
UPDATE #XMLClaims_temp SET 
	[CLAIMUB!405!occurrenceSpan1ANSI] = loc1.ANSICode, 
	[CLAIMUB!405!occurrenceSpan1FrDate] = superbillUB.OccurrenceCodeSpan1FrDate,
	[CLAIMUB!405!occurrenceSpan1ToDate] = superbillUB.OccurrenceCodeSpan1ToDate,
	[CLAIMUB!405!occurrenceSpan2ANSI] = loc2.ANSICode,
	[CLAIMUB!405!occurrenceSpan2FrDate] = superbillUB.OccurrenceCodeSpan2FrDate,
	[CLAIMUB!405!occurrenceSpan2ToDate] = superbillUB.OccurrenceCodeSpan2ToDate
FROM #XMLClaims_temp 
LEFT JOIN SuperbillUB superbillUB ON superbillUB.SuperbillUid = #XMLClaims_temp.[CLAIM!400!PID]
LEFT JOIN ListOccurrenceCode loc1 ON loc1.OccurrenceCodeUid = superbillUB.OccurrenceCodeSpan1Uid
LEFT JOIN ListOccurrenceCode loc2 ON loc2.OccurrenceCodeUid = superbillUB.OccurrenceCodeSpan2Uid
WHERE tag = '405' 

----Occurrence Codes
UPDATE #XMLClaims_temp SET 
	[CLAIMUB!405!occurrenceCode1ANSI] = loc1.ANSICode, 
	[CLAIMUB!405!occurrenceCode1Date] = superbillUB.OccurrenceCode1Date,
	[CLAIMUB!405!occurrenceCode2ANSI] = loc2.ANSICode,
	[CLAIMUB!405!occurrenceCode2Date] = superbillUB.OccurrenceCode2Date,
	[CLAIMUB!405!occurrenceCode3ANSI] = loc3.ANSICode,
	[CLAIMUB!405!occurrenceCode3Date] = superbillUB.OccurrenceCode3Date,
	[CLAIMUB!405!occurrenceCode4ANSI] = loc4.ANSICode,
	[CLAIMUB!405!occurrenceCode4Date] = superbillUB.OccurrenceCode4Date,
	[CLAIMUB!405!occurrenceCode5ANSI] = loc5.ANSICode,
	[CLAIMUB!405!occurrenceCode5Date] = superbillUB.OccurrenceCode5Date,
	[CLAIMUB!405!occurrenceCode6ANSI] = loc6.ANSICode,
	[CLAIMUB!405!occurrenceCode6Date] = superbillUB.OccurrenceCode6Date,
	[CLAIMUB!405!occurrenceCode7ANSI] = loc7.ANSICode,
	[CLAIMUB!405!occurrenceCode7Date] = superbillUB.OccurrenceCode7Date,
	[CLAIMUB!405!occurrenceCode8ANSI] = loc8.ANSICode,
	[CLAIMUB!405!occurrenceCode8Date] = superbillUB.OccurrenceCode8Date
FROM #XMLClaims_temp 
	LEFT JOIN SuperbillUB superbillUB ON superbillUB.SuperbillUid = #XMLClaims_temp.[CLAIM!400!PID]
	LEFT JOIN ListOccurrenceCode loc1 ON loc1.OccurrenceCodeUid = superbillUB.OccurrenceCode1Uid
	LEFT JOIN ListOccurrenceCode loc2 ON loc2.OccurrenceCodeUid = superbillUB.OccurrenceCode2Uid
	LEFT JOIN ListOccurrenceCode loc3 ON loc3.OccurrenceCodeUid = superbillUB.OccurrenceCode3Uid
	LEFT JOIN ListOccurrenceCode loc4 ON loc4.OccurrenceCodeUid = superbillUB.OccurrenceCode4Uid
	LEFT JOIN ListOccurrenceCode loc5 ON loc5.OccurrenceCodeUid = superbillUB.OccurrenceCode5Uid
	LEFT JOIN ListOccurrenceCode loc6 ON loc6.OccurrenceCodeUid = superbillUB.OccurrenceCode6Uid
	LEFT JOIN ListOccurrenceCode loc7 ON loc7.OccurrenceCodeUid = superbillUB.OccurrenceCode7Uid
	LEFT JOIN ListOccurrenceCode loc8 ON loc8.OccurrenceCodeUid = superbillUB.OccurrenceCode8Uid
WHERE tag = '405' 

----Value Codes
UPDATE #XMLClaims_temp SET 
	[CLAIMUB!405!valueCode1ANSI] = SUBSTRING(COALESCE(lvc1.ANSICode,''),1,3), 
	[CLAIMUB!405!valueCode1Amount] = superbillUB.ValueCode1Amount,
	[CLAIMUB!405!valueCode2ANSI] = SUBSTRING(COALESCE(lvc2.ANSICode,''),1,3),
	[CLAIMUB!405!valueCode2Amount] = superbillUB.ValueCode2Amount,
	[CLAIMUB!405!valueCode3ANSI] = SUBSTRING(COALESCE(lvc3.ANSICode,''),1,3),
	[CLAIMUB!405!valueCode3Amount] = superbillUB.ValueCode3Amount,
	[CLAIMUB!405!valueCode4ANSI] = SUBSTRING(COALESCE(lvc4.ANSICode,''),1,3),
	[CLAIMUB!405!valueCode4Amount] = superbillUB.ValueCode4Amount
FROM #XMLClaims_temp 
LEFT JOIN SuperbillUB superbillUB ON superbillUB.SuperbillUid = #XMLClaims_temp.[CLAIM!400!PID]
LEFT JOIN ListValueCode lvc1 ON lvc1.ValueCodeUid = superbillUB.ValueCode1Uid
LEFT JOIN ListValueCode lvc2 ON lvc2.ValueCodeUid = superbillUB.ValueCode2Uid
LEFT JOIN ListValueCode lvc3 ON lvc3.ValueCodeUid = superbillUB.ValueCode3Uid
LEFT JOIN ListValueCode lvc4 ON lvc4.ValueCodeUid = superbillUB.ValueCode4Uid
WHERE tag = '405' 

UPDATE #XMLClaims_temp SET 
	[CLAIMUB!405!conditionCode1ANSI] = lcc1.ANSICode, 
	[CLAIMUB!405!conditionCode2ANSI] = lcc2.ANSICode,
	[CLAIMUB!405!conditionCode3ANSI] = lcc3.ANSICode,
	[CLAIMUB!405!conditionCode4ANSI] = lcc4.ANSICode
FROM #XMLClaims_temp 
LEFT JOIN SuperbillUB superbillUB ON superbillUB.SuperbillUid = #XMLClaims_temp.[CLAIM!400!PID]
LEFT JOIN ListConditionCode lcc1 ON lcc1.ConditionCodeUid = superbillUB.ConditionCode1Uid
LEFT JOIN ListConditionCode lcc2 ON lcc2.ConditionCodeUid = superbillUB.ConditionCode2Uid
LEFT JOIN ListConditionCode lcc3 ON lcc3.ConditionCodeUid = superbillUB.ConditionCode3Uid
LEFT JOIN ListConditionCode lcc4 ON lcc4.ConditionCodeUid = superbillUB.ConditionCode4Uid
WHERE tag = '405' 

--CYS SC 12/16/08
--superbill.ClaimNote					AS [CLAIMUB!405!claimNote],
UPDATE #XMLClaims_temp SET 
	--[CLAIMUB!405!claimNote] = Superbill.ClaimNote
	[CLAIMUB!405!claimNote] = CAST(Superbill.ClaimNote AS VARCHAR(80))	
FROM #XMLClaims_temp 
INNER JOIN Superbill on Superbill.SuperbillUid = [CLAIM!400!PID]
WHERE tag = '405' 
--





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_COB]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_COB] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_Inst_COB]
AS

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
----	[SITE!100!PID],
----	[SITE!100!eClaimBatchGUID],
----	[SITE!100!claimSubmitterID!hide],
----	[SITE!100!payToAddressID!hide],
----	[CLAIM!400!PID],
----	[PATIENT!300!PEID],
----	[SUBSCRIBER!200!PEID],
----	[PAYER!230!ID!hide],
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide], 	

	[PROVIDER!110!PID],			--CYS SC 11/03/08

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[CLAIMCOB!401!COBID],				
	[CLAIMCOB!401!CroupCodeEraCode], 
	[CLAIMCOB!401!ReasonCodeEraCode],
	[CLAIMCOB!401!Money],
	[CLAIMCOB!401!Quantity],
	[CLAIMCOB!401!Order],
--	[CLAIMCOB!401!ReimbursementRate] ,
--    [CLAIMCOB!401!HCPCSPayableAmount] ,
--    [CLAIMCOB!401!MOARemarkCode1] ,
--    [CLAIMCOB!401!MOARemarkCode2] ,
--    [CLAIMCOB!401!MOARemarkCode3] ,
--    [CLAIMCOB!401!MOARemarkCode4] ,
--    [CLAIMCOB!401!MOARemarkCode5] ,
--    [CLAIMCOB!401!ESRDPaymentAmount] ,
--    [CLAIMCOB!401!NonpayableProfessionalComponentAmount] ,
--    [CLAIMCOB!401!AdjudicationDate] ,

	[FINANCIALCENTER!105!FCID] 

)
SELECT
	401 							AS tag,
	400 							AS parent,
----	[SITE!100!PID]					AS [SITE!100!PID],
----	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
----	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
----	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
----	[CLAIM!400!PID]					AS [CLAIM!400!PID],
----	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
----	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
----	[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],	
			[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]			AS [CLAIM!400!PID],
	[PATIENT!300!PEID]			AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]		AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]	AS [PAYER!230!ID!hide],			

	[PROVIDER!110!PID]			AS [PROVIDER!110!PID],			--CYS SC 11/03/08

	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!ID!hide],
    [CLAIMCOB!401!COBID] AS [CLAIMCOB!401!COBID], --NEWID() 
	lecGroup.Code			AS [CLAIMCOB!401!CroupCodeEraCode],
	lecReason.Code				AS [CLAIMCOB!401!ReasonCodeEraCode],
	COBClaimAdjustments.Amount				AS [CLAIMCOB!401!Money],
	COBClaimAdjustments.Quantity			AS [CLAIMCOB!401!Quantity],
	COBClaimDetail.InsuranceOrder	AS [CLAIMCOB!401!Order],
--	COBClaimDetail.ReimbursementRate AS [CLAIMCOB!401!ReimbursementRate] ,
--    COBClaimDetail.HCPCSPayableAmount AS [CLAIMCOB!401!HCPCSPayableAmount] ,
--    lecRemark1.Code AS [CLAIMCOB!401!MOARemarkCode1] ,
--    lecRemark2.Code AS [CLAIMCOB!401!MOARemarkCode2] ,
--    lecRemark3.Code AS [CLAIMCOB!401!MOARemarkCode3] ,
--    lecRemark4.Code AS [CLAIMCOB!401!MOARemarkCode4] ,
--    lecRemark5.Code AS [CLAIMCOB!401!MOARemarkCode5] ,
--    COBClaimDetail.ESRDPaymentAmount AS [CLAIMCOB!401!ESRDPaymentAmount] ,
--    COBClaimDetail.NonpayableProfessionalComponentAmount AS [CLAIMCOB!401!NonpayableProfessionalComponentAmount] ,
--    COBClaimDetail.AdjudicationDate AS [CLAIMCOB!401!AdjudicationDate] ,--,
	[FINANCIALCENTER!105!FCID]  AS  [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp-- ,

INNER JOIN COBClaimDetail ON
	 COBClaimDetail.SuperbillUid = COBClaimDetail.SuperbillUid --#XMLClaims_temp.[CLAIM!400!PID]
--INNER JOIN Superbill ON
--Superbill.SuperbillUid = COBClaimDetail.SuperbillUid --[CLAIM!400!PID]
INNER JOIN COBClaimAdjustments ON
COBClaimDetail.COBClaimDetailUID = COBClaimAdjustments.COBClaimDetailUID
LEFT JOIN ListERACode  lecGroup ON
COBClaimAdjustments.GroupCodeERACodeUid = lecGroup.ERACodeUID AND lecGroup.TYPE = 'group'
--CYS SC 04/03/09 added reason 
--LEFT JOIN ListERACode lecReason ON
--COBClaimAdjustments.ReasonCodeERACodeUid = lecReason.ERACodeUID AND lecReason.TYPE = 'status'
LEFT JOIN ListERACode lecReason ON
COBClaimAdjustments.ReasonCodeERACodeUid = lecReason.ERACodeUID AND (lecReason.TYPE = 'reason' or lecReason.TYPE = 'status')
--LEFT JOIN ListERACode  lecRemark1 ON
--COBClaimDetail.MOARemarkCode1Uid = lecRemark1.ERACodeUID AND lecRemark1.TYPE = 'remark'
--LEFT JOIN ListERACode  lecRemark2 ON
--COBClaimDetail.MOARemarkCode2Uid = lecRemark2.ERACodeUID AND lecRemark2.TYPE = 'remark'
--LEFT JOIN ListERACode  lecRemark3 ON
--COBClaimDetail.MOARemarkCode3Uid = lecRemark3.ERACodeUID AND lecRemark3.TYPE = 'remark'
--LEFT JOIN ListERACode  lecRemark4 ON
--COBClaimDetail.MOARemarkCode4Uid = lecRemark4.ERACodeUID AND lecRemark4.TYPE = 'remark'
--LEFT JOIN ListERACode  lecRemark5 ON
--COBClaimDetail.MOARemarkCode5Uid = lecRemark5.ERACodeUID AND lecRemark5.TYPE = 'remark'
WHERE
	#XMLClaims_temp.tag = 400 AND
   COBClaimDetail.SuperbillUid = #XMLClaims_temp.[CLAIMCOB!401!COBID] AND
	COBClaimDetail.InsuranceOrder <> [SUBSCRIBER!200!DISPLAYORDER] 
	





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_SUBSCRIBER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_SUBSCRIBER] AS' 
END
GO



ALTER PROC [dbo].[AR_genXMLClaims_Inst_SUBSCRIBER]
AS

/*
Modified On: 20050823
Modifications Made:	1. For handling WCC Case... OP values from Person or Corporation table.
			Corporation Name is populated in OrgName element
*/
-- 2016-07-11 Bug 36412 - Country Code

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID],			--CYS SC 11/03/08		

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],
	[PAYER!230!planType!hide],
--	[PATIENT!300!PEID],			-- if populated, generates one subscriber per patient. DOES NOT group them.
	[SUBSCRIBER!200!prefix],
	[SUBSCRIBER!200!LN],
	[SUBSCRIBER!200!FN],
	[SUBSCRIBER!200!MI],
	[SUBSCRIBER!200!suffix],
	[SUBSCRIBER!200!gender],
	[SUBSCRIBER!200!birthdate],
	[SUBSCRIBER!200!employer],
	[SUBSCRIBER!200!occupation],
	[SUBSCRIBER!200!address1],
	[SUBSCRIBER!200!address2],
	[SUBSCRIBER!200!city],
	[SUBSCRIBER!200!state],
	[SUBSCRIBER!200!zip],
	[SUBSCRIBER!200!country],
	[SUBSCRIBER!200!phoneNumber],
	[SUBSCRIBER!200!rIDType],
	[SUBSCRIBER!200!rID],
	[SUBSCRIBER!200!IDType],
	[SUBSCRIBER!200!ID],
	[SUBSCRIBER!200!payerResponsibility],
	[SUBSCRIBER!200!DISPLAYORDER],
	[SUBSCRIBER!200!groupID],	
	[SUBSCRIBER!200!isWCC],		-- added by SM for WCC handling
    [FINANCIALCENTER!105!FCID]
)	
SELECT DISTINCT
	200 						AS tag,
	110 						AS parent,
	#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID] AS			[PROVIDER!110!PID],	--CYS SC 11/03/08

	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.personUId 
		WHEN [SUBSCRIBER!200!isWCC] = 1 THEN inc.CorporationUid END AS [SUBSCRIBER!200!PEID],

	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],
	#XMLClaims_temp.[PAYER!230!planType!hide]	AS [PAYER!230!planType!hide],
--	#XMLClaims_temp.[PATIENT!300!PEID]		AS [PATIENT!300!PEID],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CAST( Person.prefix AS varchar(10))
		                                 ELSE NULL END AS [SUBSCRIBER!200!prefix],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN  UPPER(Person.LastName) 
		ELSE NULL END AS [SUBSCRIBER!200!LN],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN  UPPER(Person.FirstName) 
		ELSE NULL END AS [SUBSCRIBER!200!FN],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN UPPER(Person.MiddleName) 
		ELSE NULL END AS [SUBSCRIBER!200!MI],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.suffix
		ELSE NULL END AS [SUBSCRIBER!200!suffix],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN ListGender.ANSICode
		ELSE NULL END AS [SUBSCRIBER!200!gender],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CONVERT(VARCHAR, Person.birthdate,101)
		ELSE NULL END AS [SUBSCRIBER!200!birthdate],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Corporation.Name 
		ELSE  inc.Name END AS [SUBSCRIBER!200!employer],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN ListOccupation.Name
		ELSE NULL END AS [SUBSCRIBER!200!occupation],	

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!address1],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!address2],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!city],
	UPPER(CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
	END) AS [SUBSCRIBER!200!state],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!zip],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		UPPER(LEFT(Person.Address1.value('(/Address/Country)[1]', 'VARCHAR(100)'), 2))
	ELSE
		UPPER(LEFT( inc.[Address].value('(/Address/Country)[1]', 'VARCHAR(100)'), 2))
	END AS [SUBSCRIBER!200!country],

	dbo.stripSpecialChars (CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
	ELSE
		inc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
	END) AS [SUBSCRIBER!200!phoneNumber],

	'SY'						AS [SUBSCRIBER!200!rIDType],
	dbo.stripSpecialChars(Person.SocialSecurityNumber) AS [SUBSCRIBER!200!rID],

	'MI'						AS [SUBSCRIBER!200!IDType],
	dbo.stripSpecialChars([CLAIM!400!subscriberMemberID]) AS [SUBSCRIBER!200!ID],

	[SUBSCRIBER!200!payerResponsibility]		AS [SUBSCRIBER!200!payerResponsibility],
	[SUBSCRIBER!200!DISPLAYORDER] as [SUBSCRIBER!200!DISPLAYORDER],
	[CLAIM!400!patientgroupID]			AS [SUBSCRIBER!200!groupID]
--	,[CLAIM!400!PID] 				AS [SUBSCRIBER!200!SBUid!Hide]	-- added by SM for PAYER NODE JOINS
	,[SUBSCRIBER!200!isWCC]			AS [SUBSCRIBER!200!isWCC],
    [FINANCIALCENTER!105!FCID]      AS  [FINANCIALCENTER!105!FCID]   

FROM #XMLClaims_temp 

LEFT JOIN Person ON
	Person.PersonUid = [SUBSCRIBER!200!PEID]
LEFT JOIN ListGender ON
	Person.GenderUid = ListGender.GenderUid

-- in case Insured is an Organization
LEFT JOIN Corporation inc ON 
	inc.CorporationUid = [SUBSCRIBER!200!PEID]

LEFT JOIN PersonEmployer ON
	PersonEmployer.PersonUid = Person.PersonUid
LEFT JOIN Corporation ON
	PersonEmployer.EmployerUid = Corporation.CorporationUid
LEFT JOIN ListOccupation ON
	PersonEmployer.OccupationUid = ListOccupation.OccupationUid

-- get the phone number depending upon person or corporatiob

WHERE
	#XMLClaims_temp.tag = 400 AND
	#XMLClaims_temp.[SUBSCRIBER!200!PEID] IS NOT NULL










GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_SUPERVISING]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_SUPERVISING] AS' 
END
GO



ALTER PROC [dbo].[AR_genXMLClaims_Inst_SUPERVISING]
 AS

--CYS SC 12/01/08 - added logic to [SUPERVISING!150!IDType] and [SUPERVISING!150!ID] 
-- for Service Site NPI Overrides.

DECLARE @mainFinancialCenter AS UNIQUEIDENTIFIER
SET @mainFinancialCenter = '14B99C94-EDAC-47BD-97B9-CF421AC16018'

 DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
 SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @ServiceSiteNPIUid UNIQUEIDENTIFIER
 SELECT @ServiceSiteNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Service Site NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @PayToProviderNPIUid UNIQUEIDENTIFIER
 SELECT @PayToProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Pay To Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @SSNUid UNIQUEIDENTIFIER
 SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	
 
 DECLARE @EINUid UNIQUEIDENTIFIER  
 SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

 DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

DECLARE @UPINUid UNIQUEIDENTIFIER
SELECT @UPINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'UPIN' AND ISNULL(cfvt1.Inactive, 0) = 0

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID],	--CYS SC 11/03/08

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SUPERVISING!150!PEID],
	[SUPERVISING!150!FCID],
	[SUPERVISING!150!FileAsGroup],
	[SUPERVISING!150!PID],
	--[SUPERVISING!150!orgName],
	[SUPERVISING!150!LN],
	[SUPERVISING!150!FN],
	[SUPERVISING!150!MI],

	[SUPERVISING!150!address1],
	[SUPERVISING!150!address2],
	[SUPERVISING!150!city],
	[SUPERVISING!150!state],
	[SUPERVISING!150!zip],
	[SUPERVISING!150!phone],
	[SUPERVISING!150!siteType],
	[SUPERVISING!150!IDType],
	[SUPERVISING!150!ID],	

	/* CYS SC - Individual Dr ID regardless of filing type */
	[SUPERVISING!150!IDType_Dr],
	[SUPERVISING!150!ID_Dr],	

	--DEFECT #9657
	[SUPERVISING!150!NPISecIDType],
    [SUPERVISING!150!NPISecID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[SUPERVISING!150!NPISecIDType_Dr],
	[SUPERVISING!150!NPISecID_Dr],

	[SUPERVISING!150!LocationNo],
    [FINANCIALCENTER!105!FCID],
	[SUPERVISING!150!SuperbillUid]		--CYS SC 11/04/08
)
SELECT
	150 					AS Tag,
	110 					AS parent,

	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID]				AS [PROVIDER!110!PID],	--CYS SC 11/03/08

	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!PEID],
	[SUPERVISING!150!PEID] AS [SUPERVISING!150!PEID],
	[SUPERVISING!150!FCID]	AS [SUPERVISING!150!FCID],
	[SUPERVISING!150!FileAsGroup]	AS	[SUPERVISING!150!FileAsGroup],
	[SUPERVISING!150!PID] AS [SUPERVISING!150!PID],
	[SUPERVISING!150!LN] AS [SUPERVISING!150!LN],
	[SUPERVISING!150!FN] AS [SUPERVISING!150!FN],
	[SUPERVISING!150!MI] AS [SUPERVISING!150!MI],
	[SUPERVISING!150!address1] AS [SUPERVISING!150!address1],
	[SUPERVISING!150!address2] AS [SUPERVISING!150!address2],
	[SUPERVISING!150!city] AS [SUPERVISING!150!city],
	[SUPERVISING!150!state] AS [SUPERVISING!150!state],
	[SUPERVISING!150!zip] AS [SUPERVISING!150!zip],	
	[SUPERVISING!150!phone] AS [SUPERVISING!150!phone],
	
	ListServiceSiteType.ANSICode		AS [SUPERVISING!150!siteType],

	[SUPERVISING!150!IDType]		AS [SUPERVISING!150!IDType],
	[SUPERVISING!150!ID]			 AS [SUPERVISING!150!ID],	

	[SUPERVISING!150!IDType_Dr]		AS [SUPERVISING!150!IDType_Dr],
	[SUPERVISING!150!ID_Dr]			AS [SUPERVISING!150!ID_Dr],	

	--DEFECT #9657
	[SUPERVISING!150!NPISecIDType]	AS [SUPERVISING!150!NPISecIDType],
	[SUPERVISING!150!NPISecID]  	AS [SUPERVISING!150!NPISecID],

	[SUPERVISING!150!NPISecIDType_Dr]	AS [SUPERVISING!150!NPISecIDType_Dr],
	[SUPERVISING!150!NPISecID_Dr]		AS [SUPERVISING!150!NPISecID_Dr],

	'0001'					AS [SUPERVISING!150!LocationNo],
    [FINANCIALCENTER!105!FCID] AS [FINANCIALCENTER!105!FCID],
	[CLAIM!400!PID] AS [SUPERVISING!150!SuperbillUid]		--CYS SC 11/04/08

FROM #XMLClaims_temp
INNER JOIN dbo.claimsubmitter ON
	claimSubmitter.ClaimSubmitterUid = #XMLClaims_temp.[SITE!100!claimSubmitterID!hide]

LEFT JOIN ListServiceSite ON
	ListServiceSite.serviceSiteUid = claimSubmitter.ClaimSubmitterServiceSiteUid
LEFT JOIN ListServiceSiteType ON
	ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
WHERE
	--#XMLClaims_temp.tag = 110
	#XMLClaims_temp.tag = 400

UPDATE #XMLClaims_temp SET [SUPERVISING!150!FCID] = @mainFinancialCenter
	WHERE tag = '150' AND [SUPERVISING!150!FCID] IS NULL

UPDATE #XMLClaims_temp SET 
	[SUPERVISING!150!FileAsGroup] =
	CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, 
		CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual')  OR 
            (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) ='1'  ))
       THEN 0	   
       ELSE 1	
	END,
	
	[SUPERVISING!150!IDType] =
	CASE WHEN lcf.SendNPI = 1 THEN		
		--CYS SC - Service Site NPI Override
		(CASE WHEN Exists(SELECT * FROM ClaimFormatOption cfo
				INNER JOIN [ListClaimFormatOptionType] ot ON ot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid 
					WHERE (ClaimFormatUid = 
					CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END) 
					AND (ot.Name = 'NPI Override'))
				AND COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' 
			THEN 'XX'
		ELSE 
		--CYS SC - Service Site NPI Override End
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN  
					'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN  
					'24'  
				WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN 
					'34'
				ELSE ''
		   END)  
		END)	--ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN  
				'24'  
			WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN 
				'34'
			ELSE ''
	      END)
	END,	   

	[SUPERVISING!150!ID] =
	CASE WHEN lcf.SendNPI = 1 THEN
		--CYS SC - Service Site NPI Override
		(CASE WHEN Exists(SELECT * FROM ClaimFormatOption cfo
				INNER JOIN [ListClaimFormatOptionType] ot ON ot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid 
					WHERE (ClaimFormatUid = 
					CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END) 
					AND (ot.Name = 'NPI Override'))
				AND COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' 
			THEN dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)
		ELSE 
		--CYS SC - Service Site NPI Override End
		  (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
						ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid)
				WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
						ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
				WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN 
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
							dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
						ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
				ELSE ''
			END) 
		END) --ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
			WHEN (( dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR ( dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE	
						COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
			ELSE ''
		  END)
	END,

	/* Individual Dr ID regardless of filing type */
	/* Individual Dr ID regardless of filing type */
	[SUPERVISING!150!IDType_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN		
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid, 0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN 'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN  	'24'  
				ELSE '34'
		   END)  
		ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN '24'  
				ELSE '34'
				END)
	END,	   

	[SUPERVISING!150!ID_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN
		(CASE	WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
					dbo.UDF_getFormatVaribleValue (0,  @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid)
				WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 	
					dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
				ELSE				
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
		END) 
	ELSE 
		(CASE	
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 	
						dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
			ELSE				
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 
					ELSE COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
  		END)
	END,

	[SUPERVISING!150!rIDType] = 
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '' THEN '1G'
	  ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,  
		 5,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid)
	END,

	[SUPERVISING!150!rID] =
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,
		4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) ,'')
	ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,
			4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) 
	END,
	
	/* Individual Dr ID regardless of filing type */
	/* 12 = SUPERVISING Physician ID, 13 = SUPERVISING Physician ID Type in ListClaimFormatOptionType */
	[SUPERVISING!150!rIDType_Dr] =  
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 12,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '' THEN '1G'
	  ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,  
		 13,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid)
	END,

	[SUPERVISING!150!rID_Dr] =	
	CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,
		12,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) ,'')
	ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,
			12,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) 
	END, 

	[SUPERVISING!150!NPISecIDType] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
				ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN
				'EI'
			WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN 
				'SY'
			ELSE ''
		END)	
    ELSE ''
	END,	

	[SUPERVISING!150!NPISecID] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
				ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 					
			WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1' )) THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 				
					ELSE
						COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
			ELSE
				''
		END)
	ELSE ''
	END,

	/* Individual Dr ID regardless of filing type */
	[SUPERVISING!150!NPISecIDType_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN
				'EI'
			ELSE 'SY'
		END)	
    ELSE ''
	END,	
	
	/* Individual Dr ID regardless of filing type */
	[SUPERVISING!150!NPISecID_Dr] =
	CASE WHEN lcf.SendNPI = 1 THEN 
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') = '' THEN  
				''
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, @EINUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 					
			ELSE
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) <> '' THEN 
					dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) + ISNULL(provider.eClaimSiteTaxID,'') 				
				ELSE
					COALESCE(Per.SocialSecurityNumber,'') + ISNULL(provider.eClaimSiteTaxID,'') END
		END)
	ELSE ''
	END,
	[SUPERVISING!150!providerTaxonomyCode] =	ISNULL(ListSpecialty.ANSICode,'')	
FROM #XMLClaims_temp 
INNER JOIN ClaimBatch ON  ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
INNER JOIN ClaimBatchDetail ON  ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid   
INNER JOIN superbill ON 
	superbill.superbillUid = ClaimBatchDetail.SuperBillUid and  
	superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.
			  INNER JOIN  ViewSuperbillFinancialDetails ON  
		ViewSuperbillFinancialDetails.superbillUid = superbill.SuperbillUid and  
		   superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.   
INNER JOIN Person Per ON Per.PersonUid = #XMLClaims_temp.[SUPERVISING!150!PEID]
INNER JOIN Provider provider on provider.PersonUid = #XMLClaims_temp.[SUPERVISING!150!PEID]
LEFT JOIN ListSpecialty ON provider.SpecialtyUid = ListSpecialty.SpecialtyUid

INNER JOIN account ON  
   account.accountUid = superbill.accountUid  
INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  
	AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
INNER JOIN AccountInsurance  ON  
   AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid -- AND AccountInsurance.DisplayOrder = 1
INNER JOIN PersonInsurancePlan  
   ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
   AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
INNER JOIN InsurancePlan  
   ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
INNER JOIN InsuranceCarrier  
   ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  

LEFT JOIN ListClaimFormat lcf
	ON lcf.ClaimFormatUid = (CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid
						ELSE InsurancePlan.ElectronicClaimFormatUid END)	

WHERE TAG = '150'

UPDATE #XMLClaims_temp SET 
	[SUPERVISING!150!PID] =
		CASE WHEN [SUPERVISING!150!FileAsGroup] = 1 THEN Fc.FinancialCenterUid
				ELSE Per.PersonUid  END,
	[SUPERVISING!150!LN] =
		CASE WHEN [SUPERVISING!150!FileAsGroup] =  1 THEN  UPPER(Fc.Name)
		ELSE  UPPER(Per.LastName) END,
	[SUPERVISING!150!FN] = 
		CASE [SUPERVISING!150!FileAsGroup] WHEN 1 THEN   NULL
		ELSE UPPER(Per.FirstName) END,
	[SUPERVISING!150!MI] = 
		CASE [SUPERVISING!150!FileAsGroup] WHEN 1 THEN  NULL
		ELSE UPPER(Per.MiddleName)  END,
	/*CYS SC */
	[SUPERVISING!150!LN_Dr] = UPPER(Per.LastName),
	[SUPERVISING!150!FN_Dr] = UPPER(Per.FirstName),
	[SUPERVISING!150!MI_Dr] =UPPER(Per.MiddleName),
	/*CYS SC */
	[SUPERVISING!150!address1] = 
		CASE WHEN [SUPERVISING!150!FileAsGroup] = 1 THEN 
			Fc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		ELSE
			Per.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)')
		END,		
	[SUPERVISING!150!address2] = 		
		CASE WHEN [SUPERVISING!150!FileAsGroup] = 1 THEN 
			Fc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		ELSE
			Per.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)')
		END,
	[SUPERVISING!150!city] = 		
		CASE WHEN [SUPERVISING!150!FileAsGroup] = 1 THEN 
			Fc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		ELSE
			Per.Address1.value('(/Address/City)[1]', 'VARCHAR(100)')
		END,
	[SUPERVISING!150!state] = 
		UPPER(CASE WHEN [SUPERVISING!150!FileAsGroup] = 1 THEN 
			Fc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		ELSE
			Per.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')
		END),
	[SUPERVISING!150!zip] = 
		CASE WHEN [SUPERVISING!150!FileAsGroup] = 1 THEN 
			Fc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		ELSE
			Per.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)')
		END,
	[SUPERVISING!150!phone] = dbo.stripSpecialChars(
		CASE WHEN [SUPERVISING!150!FileAsGroup] = 1 THEN 
			Fc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		ELSE
			Per.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		END)
FROM #XMLClaims_temp 
	INNER JOIN Person Per ON Per.PersonUid = #XMLClaims_temp.[SUPERVISING!150!PEID]
	INNER JOIN FinancialCenter Fc ON Fc.FinancialCenterUid = #XMLClaims_temp.[SUPERVISING!150!FCID]
WHERE tag = '150' 

--We do not want any 150 recs if there is not a SuberbillUB.SupervisingProviderUid
DECLARE @blankUid AS UNIQUEIDENTIFIER
SET @blankUid = '00000000-0000-0000-0000-000000000000'
DELETE #XMLClaims_temp
WHERE tag = '150' AND ISNULL(#XMLClaims_temp.[SUPERVISING!150!PEID],@blankUid) = @blankUid

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_Inst]
	@ClaimBatchuid uniqueidentifier,
	@InstanceID uniqueidentifier = null output
AS
--CYS SC 07/08/09 - Add [CLAIM!400!BillingProvider_IDType] VARCHAR(50) for Service Site bug (CYS Case #22420)
--CYS SC 07/08/09 - Add [CLAIM!400!BillingProvider_ID] VARCHAR(50) for Service Site bug (CYS Case #22420)
--CYS SC 05/21/09 - add [CLAIM!400!EPSDT] for CLM12
--CYS SC 05/21/09 - add [CLAIM!400!delayReasonCode] for CLM20 
--dsw    12/1/2014 - allow ICD-10 codes in 4010. Bug 34065
-- 2014-12-05 dsw - 34159 Performance improvements by using SuperbillAggregate.AccountPeriod, Removed ICD-10 based on bad performance
-- 2014-02-27 dsw - 35706 - ICD-10 with start date in insurance
-- 2016-07-11 Bug 36412 - Country Code
-- 2016-10-26 51952 Hawaii Tax Changes to be handled in Claims and ERA processing ( added electronicClaimFormatUid, TotalTax, [PROC!450!procCodeName] )

/* 
Modified On: 20051011
Modifications Made:	2. For Accident date
			1. For handling WCC Case... added isWCC column to temp table: 20050823
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
--CYS SC - _Dr fields = Individual Dr ID regardless of filing type for Loop2310A
-- 2017-04-13 Bug 56452:Patient Name versus Insurance Subscriber Name when Relationship is Self

*/
BEGIN TRANSACTION

/*
General Structure of the return document:
	<PROVIDER>
		<BILLINGPROVIDER/>
		<PAYTOPROVIDER/>
		<ATTENDING/>
		<SUBSCRIBER>
			<SUBSCRIBER/>
			<PAYER/>
			<PATIENT>
				<PATIENT/>
				<CLAIMS>
					<CLAIM/>
					<RENDERER/>
					<SITE/>
					<PROC/>
					<PROC/>
				</CLAIMS>
			</PATIENT>
		</SUBSCRIBER>
	</PROVIDER>
*/
SET NOCOUNT ON

DECLARE @claimsFetched INT

DECLARE @eClaimFileUID UNIQUEIDENTIFIER
SET @eClaimFileUID = NEWID()

--DELETE FROM #XMLClaims_temp

--DROP TABLE #XMLClaims_temp

CREATE TABLE #XMLClaims_temp (
	tag INT,
	parent INT,
	[SITE!100!PID] UNIQUEIDENTIFIER,
	[SITE!100!eClaimBatchGUID] UNIQUEIDENTIFIER,
	[SITE!100!claimSubmitterID!hide] UNIQUEIDENTIFIER,
	[SITE!100!payToAddressID!hide] UNIQUEIDENTIFIER,
	[PROVIDER!110!PID] VARCHAR(50),
	[CLAIM!400!PID] UNIQUEIDENTIFIER,
	[CLAIM!400!accountNumber] VARCHAR(50),
	[CLAIM!400!totalBill] VARCHAR(12),
	[CLAIM!400!diag1] VARCHAR(50),
	[CLAIM!400!diag2] VARCHAR(50),
	[CLAIM!400!diag3] VARCHAR(50),
	[CLAIM!400!diag4] VARCHAR(50),
	[CLAIM!400!diag5] VARCHAR(50),
	[CLAIM!400!diag6] VARCHAR(50),
	[CLAIM!400!diag7] VARCHAR(50),
	[CLAIM!400!diag8] VARCHAR(50),
	[CLAIM!400!patientMemberID] VARCHAR(110),
	[CLAIM!400!patientgroupID] VARCHAR(50),
	[CLAIM!400!subscriberMemberID] VARCHAR(50),
	[CLAIM!400!authorizeAssignment] TINYINT,
	[CLAIM!400!providerID] VARCHAR(50),
	[CLAIM!400!providerIDType] VARCHAR(50),
	[CLAIM!400!providerGroupID] VARCHAR(50),
	[CLAIM!400!providerGroupIDType] VARCHAR(50),
	[CLAIM!400!facilityPrimaryID] VARCHAR(50),
	[CLAIM!400!facilityPrimaryIDType] VARCHAR(50),
	[CLAIM!400!facilityID] VARCHAR(50),
	[CLAIM!400!facilityIDType] VARCHAR(50),
	[CLAIM!400!claimFrequencyCode] INT,
	[CLAIM!400!providerSignatureOnFile] VARCHAR(1),
	[CLAIM!400!providerAcceptAssignment] VARCHAR(1),
	[CLAIM!400!patientAcceptAssignment] VARCHAR(1),
	[CLAIM!400!releaseOfInformation] VARCHAR(1),
	[CLAIM!400!patientSignatureSource] VARCHAR(1),
	[CLAIM!400!patientSignatureDate] VARCHAR(20),
	[CLAIM!400!siteType] VARCHAR(2),
	[CLAIM!400!onsetCurrentDate] DATETIME,
	[CLAIM!400!onsetFirstDate] DATETIME,
	[CLAIM!400!noWorkFromDate] DATETIME,
	[CLAIM!400!noWorkToDate] DATETIME,
	[CLAIM!400!hospitalizationStartDate] DATETIME,
	[CLAIM!400!hospitalizationEndDate] DATETIME,
	[CLAIM!400!familyPlan] INT,
	[CLAIM!400!relatedCausesCode] VARCHAR(2),
	[CLAIM!400!accidentState] VARCHAR(2),
	[CLAIM!400!accidentDate] DATETIME,
	[CLAIM!400!priorAuthorizationCode] VARCHAR(20),
	[CLAIM!400!SendNPI] BIT,
	[CLAIM!400!Dmerc] BIT,
	[CLAIM!400!ICN] VARCHAR(50),			--ADDED ICN NUMBER REPORTDED IN LOOP 2300 6/19/08
	[CLAIM!400!EPSDT] BIT,                  --SC Added for CLM12 05/21/09
    [CLAIM!400!delayReasonCode] VARCHAR(2), --SC Added for CLM20 05/21/09

	--CYS SC 07/08/09 - Added for Service Site bug (CYS Case #22420)
	[CLAIM!400!BillingProvider_IDType] VARCHAR(50),  
	[CLAIM!400!BillingProvider_ID] VARCHAR(50),		 

	-- added by IR for primary and current carrier
    [CLAIM!400!primaryCarrierUID] UNIQUEIDENTIFIER,
	[CLAIM!400!currentCarrierUID] UNIQUEIDENTIFIER,
	[CLAIM!400!PatientPaidAmount] MONEY,
	[CLAIM!400!ResubmissionCode] VARCHAR(50),
	[CLAIM!400!UseICD10] BIT,
	[CLAIM!400!ElectronicClaimFormatUid] UNIQUEIDENTIFIER,
	[CLAIM!400!ChcBillingType] int,

--***************************************************************************
--SCOTT CLAIM UB LINE

	/* CYS SC */	
	[CLAIMUB!405!typeOfBill] VARCHAR(5),		
	[CLAIMUB!405!dischargeTime] DATETIME,
	[CLAIMUB!405!admissionTime] DATETIME,
	[CLAIMUB!405!coveredPeriodFrDate] DATETIME,
	[CLAIMUB!405!coveredPeriodToDate] DATETIME,
	[CLAIMUB!405!admissionTypeANSI] VARCHAR(1),
	[CLAIMUB!405!admissionSourceANSI] VARCHAR(1),		
	[CLAIMUB!405!patientStatusUBANSI] VARCHAR(2),		
	[CLAIMUB!405!claimHeaderNoteCodeANSI] VARCHAR(3),
	[CLAIMUB!405!claimNote] VARCHAR(80),
	[CLAIMUB!405!serviceAuthorizationExceptionANSI] VARCHAR(1),		
	[CLAIMUB!405!admittingDiag] VARCHAR(50),
	[CLAIMUB!405!externalInjuryDiag] VARCHAR(50),
	[CLAIMUB!405!drgProc] VARCHAR(30),
    [CLAIMUB!405!otherProc1] VARCHAR(30),
	[CLAIMUB!405!otherProc1ANSI] VARCHAR(3),
	[CLAIMUB!405!otherProc1Date] DATETIME,
	[CLAIMUB!405!otherProc2] VARCHAR(30),
	[CLAIMUB!405!otherProc2ANSI] VARCHAR(3),
	[CLAIMUB!405!otherProc2Date] DATETIME,
	[CLAIMUB!405!otherProc3] VARCHAR(30),
	[CLAIMUB!405!otherProc3ANSI] VARCHAR(3),
	[CLAIMUB!405!otherProc3Date] DATETIME,
	[CLAIMUB!405!otherProc4] VARCHAR(30),
	[CLAIMUB!405!otherProc4ANSI] VARCHAR(3),
	[CLAIMUB!405!otherProc4Date] DATETIME,
	[CLAIMUB!405!occurrenceSpan1ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceSpan1FrDate] DATETIME,
	[CLAIMUB!405!occurrenceSpan1ToDate] DATETIME,
	[CLAIMUB!405!occurrenceSpan2ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceSpan2FrDate] DATETIME,
	[CLAIMUB!405!occurrenceSpan2ToDate] DATETIME,
	[CLAIMUB!405!occurrenceCode1ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode1Date] DATETIME,
	[CLAIMUB!405!occurrenceCode2ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode2Date] DATETIME,
	[CLAIMUB!405!occurrenceCode3ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode3Date] DATETIME,
	[CLAIMUB!405!occurrenceCode4ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode4Date] DATETIME,
	[CLAIMUB!405!occurrenceCode5ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode5Date] DATETIME,
	[CLAIMUB!405!occurrenceCode6ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode6Date] DATETIME,
	[CLAIMUB!405!occurrenceCode7ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode7Date] DATETIME,
	[CLAIMUB!405!occurrenceCode8ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode8Date] DATETIME,
	[CLAIMUB!405!valueCode1ANSI] VARCHAR(3),
	[CLAIMUB!405!valueCode1Amount] VARCHAR(12),
	[CLAIMUB!405!valueCode2ANSI] VARCHAR(3),
	[CLAIMUB!405!valueCode2Amount] VARCHAR(12),
	[CLAIMUB!405!valueCode3ANSI] VARCHAR(3),
	[CLAIMUB!405!valueCode3Amount] VARCHAR(12),
	[CLAIMUB!405!valueCode4ANSI] VARCHAR(3),
	[CLAIMUB!405!valueCode4Amount] VARCHAR(12),
	[CLAIMUB!405!conditionCode1ANSI] VARCHAR(3),
	[CLAIMUB!405!conditionCode2ANSI] VARCHAR(3),
	[CLAIMUB!405!conditionCode3ANSI] VARCHAR(3),
	[CLAIMUB!405!conditionCode4ANSI] VARCHAR(3),
	[CLAIMUB!405!coverageDays] INT,
	[CLAIMUB!405!nonCoveredDays] INT,
	[CLAIMUB!405!coInsuranceDays] INT,
	[CLAIMUB!405!lifetimeReserveDays] INT,

	/* CYS SC */
--***************************************************************************

	[BILLINGPROVIDER!120!PID] UNIQUEIDENTIFIER,
	[BILLINGPROVIDER!120!LN]	VARCHAR(60),
	[BILLINGPROVIDER!120!FN]	VARCHAR(50),
	[BILLINGPROVIDER!120!MI]	VARCHAR(50),

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!LN_Dr]	VARCHAR(60),
	[BILLINGPROVIDER!120!FN_Dr]	VARCHAR(50),
	[BILLINGPROVIDER!120!MI_Dr]	VARCHAR(50),

	[BILLINGPROVIDER!120!address1] VARCHAR(100),
	[BILLINGPROVIDER!120!address2] VARCHAR(100),
	[BILLINGPROVIDER!120!city] VARCHAR(50),
	[BILLINGPROVIDER!120!state] VARCHAR(10),
	[BILLINGPROVIDER!120!zip] VARCHAR(20),
	[BILLINGPROVIDER!120!phone] VARCHAR(30),
	[BILLINGPROVIDER!120!siteType] SMALLINT,
	[BILLINGPROVIDER!120!IDType] VARCHAR(50),
	[BILLINGPROVIDER!120!ID] VARCHAR(50),	

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!IDType_Dr] VARCHAR(50),
	[BILLINGPROVIDER!120!ID_Dr] VARCHAR(50),	
	
	[BILLINGPROVIDER!120!FCID] UNIQUEIDENTIFIER,
	[BILLINGPROVIDER!120!FileAsGroup] BIT,
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType] VARCHAR(50),
	[BILLINGPROVIDER!120!NPISecID] VARCHAR(50),

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!NPISecIDType_Dr] VARCHAR(50),
	[BILLINGPROVIDER!120!NPISecID_Dr] VARCHAR(50),

	[BILLINGPROVIDER!120!LocationNo] VARCHAR(10),

	[PATIENT!300!PEID] UNIQUEIDENTIFIER,
	[PATIENT!300!prefix] VARCHAR(10),
	[PATIENT!300!LN] VARCHAR(50),
	[PATIENT!300!FN] VARCHAR(50),
	[PATIENT!300!MI] VARCHAR(50),
	[PATIENT!300!suffix] VARCHAR(20),
	[PATIENT!300!gender] VARCHAR(50),
	[PATIENT!300!birthdate] VARCHAR(12),
	[PATIENT!300!employer] VARCHAR(100),
	[PATIENT!300!occupation] VARCHAR(50),
	[PATIENT!300!address1] VARCHAR(100),
	[PATIENT!300!address2] VARCHAR(100),
	[PATIENT!300!city] VARCHAR(50),
	[PATIENT!300!state] VARCHAR(10),
	[PATIENT!300!zip] VARCHAR(20),
	[PATIENT!300!phoneNumber] VARCHAR(30),
	[PATIENT!300!rIDType] VARCHAR(50),
	[PATIENT!300!rID] VARCHAR(50),
	[PATIENT!300!IDType] VARCHAR(50),
	[PATIENT!300!ID] VARCHAR(50),
	[PATIENT!300!patientRelationToInsured] VARCHAR(4),

	[PAYER!230!ID!hide] UNIQUEIDENTIFIER,
	[PAYER!230!CarrierID] UNIQUEIDENTIFIER,
	[PAYER!230!planType!hide] UNIQUEIDENTIFIER,
	[PAYER!230!planType] VARCHAR(4),
	[PAYER!230!orgName] VARCHAR(100),
	[PAYER!230!planName] VARCHAR(100),
	[PAYER!230!address1] VARCHAR(100),
	[PAYER!230!address2] VARCHAR(100),
	[PAYER!230!city] VARCHAR(50),	
    [PAYER!230!Inactive] BIT,       --Added for Inactive Payers

	[PAYER!230!state] VARCHAR(10),
	[PAYER!230!zip] VARCHAR(20),
	[PAYER!230!phone] VARCHAR(30),
	[PAYER!230!capitated] BIT,
	[PAYER!230!acceptAssignment] VARCHAR(1),
	[PAYER!230!IDType] VARCHAR(50),
	[PAYER!230!ID] VARCHAR(50),
	[PAYER!230!elecPayerID] VARCHAR(50),
	[PAYER!230!rIDType] VARCHAR(50),
	[PAYER!230!rID] VARCHAR(50),
    [PAYER!230!TaxonomyCode] VARCHAR(50), -- Added for 13369, 13953

	[PAYTOPROVIDER!130!PID] UNIQUEIDENTIFIER,
	[PAYTOPROVIDER!130!PEID] UNIQUEIDENTIFIER,
	[PAYTOPROVIDER!130!FN] VARCHAR(50),
	[PAYTOPROVIDER!130!LN] VARCHAR(50),
	[PAYTOPROVIDER!130!orgName] VARCHAR(50),
	[PAYTOPROVIDER!130!address1] VARCHAR(100),
	[PAYTOPROVIDER!130!address2] VARCHAR(100),
	[PAYTOPROVIDER!130!city] VARCHAR(50),
	[PAYTOPROVIDER!130!state] VARCHAR(10),
	[PAYTOPROVIDER!130!zip] VARCHAR(20),
	[PAYTOPROVIDER!130!phone] VARCHAR(30),
	[PAYTOPROVIDER!130!siteType] SMALLINT,
	[PAYTOPROVIDER!130!IDType] VARCHAR(50),
	[PAYTOPROVIDER!130!ID] VARCHAR(50),
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType] VARCHAR(50),
	[PAYTOPROVIDER!130!NPISecID] VARCHAR(50),
	
--CYS SC - Inst Attending 
	[ATTENDING!140!PID] UNIQUEIDENTIFIER,
	[ATTENDING!140!PEID] UNIQUEIDENTIFIER,
	[ATTENDING!140!FCID] UNIQUEIDENTIFIER,
	[ATTENDING!140!LN]	VARCHAR(60),
	[ATTENDING!140!FN]	VARCHAR(50),
	[ATTENDING!140!MI]	VARCHAR(50),
	[ATTENDING!140!LN_Dr]	VARCHAR(60),
	[ATTENDING!140!FN_Dr]	VARCHAR(50),
	[ATTENDING!140!MI_Dr]	VARCHAR(50),
	[ATTENDING!140!address1] VARCHAR(100),
	[ATTENDING!140!address2] VARCHAR(100),
	[ATTENDING!140!city] VARCHAR(50),
	[ATTENDING!140!state] VARCHAR(10),
	[ATTENDING!140!zip] VARCHAR(20),
	[ATTENDING!140!phone] VARCHAR(30),
	[ATTENDING!140!siteType] SMALLINT,
	[ATTENDING!140!IDType] VARCHAR(50),
	[ATTENDING!140!ID] VARCHAR(50),	
	[ATTENDING!140!IDType_Dr] VARCHAR(50),	
	[ATTENDING!140!ID_Dr] VARCHAR(50),
	[ATTENDING!140!rIDType] VARCHAR(50),
	[ATTENDING!140!rID] VARCHAR(50),
	[ATTENDING!140!rIDType_Dr] VARCHAR(50),
	[ATTENDING!140!rID_Dr] VARCHAR(50),
	[ATTENDING!140!NPISecIDType] VARCHAR(50),	
	[ATTENDING!140!NPISecID] VARCHAR(50),	
	[ATTENDING!140!NPISecIDType_Dr] VARCHAR(50),	
	[ATTENDING!140!NPISecID_Dr] VARCHAR(50),	
	[ATTENDING!140!providerTaxonomyCode] VARCHAR(15),
	[ATTENDING!140!FileAsGroup] BIT,
	[ATTENDING!140!LocationNo] VARCHAR(10),
	[ATTENDING!140!SuperbillUid] UNIQUEIDENTIFIER,		--CYS SC 11/04/08

----CYS SC - Inst Supervising 
	[SUPERVISING!150!PID] UNIQUEIDENTIFIER,
	[SUPERVISING!150!PEID] UNIQUEIDENTIFIER,
	[SUPERVISING!150!FCID] UNIQUEIDENTIFIER,
	[SUPERVISING!150!LN]	VARCHAR(60),
	[SUPERVISING!150!FN]	VARCHAR(50),
	[SUPERVISING!150!MI]	VARCHAR(50),
	[SUPERVISING!150!LN_Dr]	VARCHAR(60),
	[SUPERVISING!150!FN_Dr]	VARCHAR(50),
	[SUPERVISING!150!MI_Dr]	VARCHAR(50),
	[SUPERVISING!150!address1] VARCHAR(100),
	[SUPERVISING!150!address2] VARCHAR(100),
	[SUPERVISING!150!city] VARCHAR(50),
	[SUPERVISING!150!state] VARCHAR(10),
	[SUPERVISING!150!zip] VARCHAR(20),
	[SUPERVISING!150!phone] VARCHAR(30),
	[SUPERVISING!150!siteType] SMALLINT,
	[SUPERVISING!150!IDType] VARCHAR(50),
	[SUPERVISING!150!ID] VARCHAR(50),	
	[SUPERVISING!150!IDType_Dr] VARCHAR(50),
	[SUPERVISING!150!ID_Dr] VARCHAR(50),	
	[SUPERVISING!150!rIDType] VARCHAR(50),
	[SUPERVISING!150!rID] VARCHAR(50),
	[SUPERVISING!150!rIDType_Dr] VARCHAR(50),
	[SUPERVISING!150!rID_Dr] VARCHAR(50),
	[SUPERVISING!150!NPISecIDType] VARCHAR(50),	
	[SUPERVISING!150!NPISecID] VARCHAR(50),	
	[SUPERVISING!150!NPISecIDType_Dr] VARCHAR(50),	
	[SUPERVISING!150!NPISecID_Dr] VARCHAR(50),	
	[SUPERVISING!150!providerTaxonomyCode] VARCHAR(15),
	[SUPERVISING!150!FileAsGroup] BIT,
	[SUPERVISING!150!LocationNo] VARCHAR(10),
	[SUPERVISING!150!SuperbillUid] UNIQUEIDENTIFIER,		--CYS SC 11/04/08

--
----CYS SC - Inst Operating
	[OPERATING!160!PID] UNIQUEIDENTIFIER,
	[OPERATING!160!PEID] UNIQUEIDENTIFIER,
	[OPERATING!160!FCID] UNIQUEIDENTIFIER,
	[OPERATING!160!LN]	VARCHAR(60),
	[OPERATING!160!FN]	VARCHAR(50),
	[OPERATING!160!MI]	VARCHAR(50),
	[OPERATING!160!LN_Dr]	VARCHAR(60),
	[OPERATING!160!FN_Dr]	VARCHAR(50),
	[OPERATING!160!MI_Dr]	VARCHAR(50),
	[OPERATING!160!address1] VARCHAR(100),
	[OPERATING!160!address2] VARCHAR(100),
	[OPERATING!160!city] VARCHAR(50),
	[OPERATING!160!state] VARCHAR(10),
	[OPERATING!160!zip] VARCHAR(20),
	[OPERATING!160!phone] VARCHAR(30),
	[OPERATING!160!siteType] SMALLINT,
	[OPERATING!160!IDType] VARCHAR(50),
	[OPERATING!160!ID] VARCHAR(50),	
	[OPERATING!160!IDType_Dr] VARCHAR(50),
	[OPERATING!160!ID_Dr] VARCHAR(50),	
	[OPERATING!160!rIDType] VARCHAR(50),
	[OPERATING!160!rID] VARCHAR(50),
	[OPERATING!160!rIDType_Dr] VARCHAR(50),
	[OPERATING!160!rID_Dr] VARCHAR(50),
	[OPERATING!160!NPISecIDType] VARCHAR(50),	
	[OPERATING!160!NPISecID] VARCHAR(50),	
	[OPERATING!160!NPISecIDType_Dr] VARCHAR(50),	
	[OPERATING!160!NPISecID_Dr] VARCHAR(50),	
	[OPERATING!160!providerTaxonomyCode] VARCHAR(15),
	[OPERATING!160!FileAsGroup] BIT,
	[OPERATING!160!LocationNo] VARCHAR(10),
	[OPERATING!160!SuperbillUid] UNIQUEIDENTIFIER,		--CYS SC 11/04/08

--
	[CLAIMCOB!401!COBID] UNIQUEIDENTIFIER,
	[CLAIMCOB!401!CroupCodeEraCode] VARCHAR(8),
	[CLAIMCOB!401!ReasonCodeEraCode] VARCHAR(8),
	[CLAIMCOB!401!Money] MONEY,
	[CLAIMCOB!401!Quantity] SMALLINT,
	[CLAIMCOB!401!Order] SMALLINT,

	[PROC!450!ID!hide] UNIQUEIDENTIFIER,
	[PROC!450!count] SMALLINT,
	[PROC!450!proc] VARCHAR(48),
	[PROC!450!revenueCode] VARCHAR(10),			/* CYS SC */
	[PROC!450!procM1] VARCHAR(8),
	[PROC!450!procM2] VARCHAR(8),
	[PROC!450!procM3] VARCHAR(8),
	[PROC!450!procM4] VARCHAR(8),
	[PROC!450!diag1] SMALLINT,
	[PROC!450!diag2] SMALLINT,
	[PROC!450!diag3] SMALLINT,
	[PROC!450!diag4] SMALLINT,
	[PROC!450!diag5] SMALLINT,
	[PROC!450!diag6] SMALLINT,
	[PROC!450!diag7] SMALLINT,
	[PROC!450!diag8] SMALLINT,
	[PROC!450!unitType] VARCHAR(2), --='UN'
	[PROC!450!units] VARCHAR(10),
	[PROC!450!charge] VARCHAR(13),
	[PROC!450!procedureType] VARCHAR(4),
	[PROC!450!procCodeType] VARCHAR(50),
	[PROC!450!procCodeName]VARCHAR(15),
	[PROC!450!description] VARCHAR(255),
	[PROC!450!serviceDate] VARCHAR(12),
	[PROC!450!serviceDateEnd] VARCHAR(12),
	[PROC!450!emergency] VARCHAR(1),
	[PROC!450!serviceLocation] VARCHAR(4),
	[PROC!450!lineControlNo] VARCHAR(50),
    --Defect #11325
    [PROC!450!NoteReferenceCode] VARCHAR(3),
    --[PROC!450!Note] VARCHAR(80),
	[PROC!450!Notes] VARCHAR(80),
    [PROC!450!NDC]VARCHAR(48),
	[PROC!450!NDCUnitofMeasureANSI] VARCHAR(3),		--CYS SC
	[PROC!450!TotalTax] MONEY,
    [PROC!450!ProcID] UNIQUEIDENTIFIER,

	[RENDERER!410!ID!hide] UNIQUEIDENTIFIER,	--(50),
	[RENDERER!410!PEID] UNIQUEIDENTIFIER,
	[RENDERER!410!LN] VARCHAR(50),
	[RENDERER!410!FN] VARCHAR(50),
	[RENDERER!410!MI] VARCHAR(50),
	[RENDERER!410!address1] VARCHAR(100),
	[RENDERER!410!address2] VARCHAR(100),
	[RENDERER!410!city] VARCHAR(50),
	[RENDERER!410!state] VARCHAR(10),
	[RENDERER!410!zip] VARCHAR(20),
	[RENDERER!410!dayPhone] VARCHAR(30),
	[RENDERER!410!providerTaxonomyCode] VARCHAR(15),
	[RENDERER!410!rIDType] VARCHAR(50),
	[RENDERER!410!rID] VARCHAR(50),
	[RENDERER!410!IDType] VARCHAR(50),
	[RENDERER!410!ID] VARCHAR(50),
	[RENDERER!410!CLIA] VARCHAR(50),
    [RENDERER!410!MamographyCertNo] VARCHAR(50),
	[RENDERER!410!SendCLIA] BIT,
	[RENDERER!410!SendMamographyCertNo] BIT,
	[REFERRER!420!PEID] UNIQUEIDENTIFIER,
	[REFERRER!420!PID] UNIQUEIDENTIFIER,
	[REFERRER!420!LN] VARCHAR(50),
	[REFERRER!420!FN] VARCHAR(50),
	[REFERRER!420!MI] VARCHAR(50),
	[REFERRER!420!orgName] VARCHAR(50),
	[REFERRER!420!rIDType] VARCHAR(50),
	[REFERRER!420!rID] VARCHAR(50),
	[REFERRER!420!IDType] VARCHAR(50),
	[REFERRER!420!ID] VARCHAR(50),
	[REFERRER!420!providerTaxonomyCode] VARCHAR(15),

	[SERVICEFACILITY!430!PID] UNIQUEIDENTIFIER,
	[SERVICEFACILITY!430!type] VARCHAR(50),
	[SERVICEFACILITY!430!orgName] VARCHAR(50),
	[SERVICEFACILITY!430!address1] VARCHAR(100),
	[SERVICEFACILITY!430!address2] VARCHAR(100),
	[SERVICEFACILITY!430!city] VARCHAR(50),
	[SERVICEFACILITY!430!state] VARCHAR(10),
	[SERVICEFACILITY!430!zip] VARCHAR(20),
	[SERVICEFACILITY!430!phone] VARCHAR(30),
	[SERVICEFACILITY!430!siteType] SMALLINT,
	[SERVICEFACILITY!430!PrimaryIDType] VARCHAR(50),
	[SERVICEFACILITY!430!PrimaryID] VARCHAR(50),
	[SERVICEFACILITY!430!IDType] VARCHAR(50),
	[SERVICEFACILITY!430!ID] VARCHAR(50),

	[SUBSCRIBER!200!PEID] UNIQUEIDENTIFIER,
	[SUBSCRIBER!200!SSN] VARCHAR(50),
	[SUBSCRIBER!200!prefix] VARCHAR(10),
	[SUBSCRIBER!200!LN] VARCHAR(50),
	[SUBSCRIBER!200!FN] VARCHAR(50),
	[SUBSCRIBER!200!MI] VARCHAR(50),
	[SUBSCRIBER!200!suffix] VARCHAR(20),
	[SUBSCRIBER!200!gender] VARCHAR(50),
	[SUBSCRIBER!200!birthdate] VARCHAR(12),
	[SUBSCRIBER!200!employer] VARCHAR(100),
	[SUBSCRIBER!200!occupation] VARCHAR(50),
	[SUBSCRIBER!200!address1] VARCHAR(100),
	[SUBSCRIBER!200!address2] VARCHAR(100),
	[SUBSCRIBER!200!city] VARCHAR(50),
	[SUBSCRIBER!200!state] VARCHAR(10),
	[SUBSCRIBER!200!zip] VARCHAR(20),
	[SUBSCRIBER!200!country] VARCHAR(2),
	[SUBSCRIBER!200!phoneNumber] VARCHAR(30),
	[SUBSCRIBER!200!rIDType] VARCHAR(50),
	[SUBSCRIBER!200!rID] VARCHAR(50),
	[SUBSCRIBER!200!IDType] VARCHAR(50),
	[SUBSCRIBER!200!ID] VARCHAR(50),
	[SUBSCRIBER!200!payerResponsibility] VARCHAR(4),
	[SUBSCRIBER!200!DisplayOrder] SMALLINT,
	[SUBSCRIBER!200!groupID] VARCHAR(50),
	[SUBSCRIBER!200!groupName] VARCHAR(50),
	[SUBSCRIBER!200!isWCC] BIT,					-- by SM for WCC handling

	[RESPONSIBLEPARTY!240!ID!hide] UNIQUEIDENTIFIER,
	[RESPONSIBLEPARTY!240!PEID] UNIQUEIDENTIFIER,			--Added by AW for 2010BC loop  2006 03 15
	[RESPONSIBLEPARTY!240!prefix] VARCHAR(10),
	[RESPONSIBLEPARTY!240!LN] VARCHAR(50),
	[RESPONSIBLEPARTY!240!FN] VARCHAR(50),
	[RESPONSIBLEPARTY!240!MI] VARCHAR(50),
	[RESPONSIBLEPARTY!240!suffix] VARCHAR(20),
	[RESPONSIBLEPARTY!240!address1] VARCHAR(100),
	[RESPONSIBLEPARTY!240!address2] VARCHAR(100),
	[RESPONSIBLEPARTY!240!city] VARCHAR(50),
	[RESPONSIBLEPARTY!240!state] VARCHAR(10),
	[RESPONSIBLEPARTY!240!zip] VARCHAR(50),	
	[RESPONSIBLEPARTY!240!contactName] VARCHAR(50),
	[RESPONSIBLEPARTY!240!contact1String] VARCHAR(22),
	[RESPONSIBLEPARTY!240!isCorporation] BIT,
    [FINANCIALCENTER!105!FCID] UNIQUEIDENTIFIER, 	
	[FINANCIALCENTER!105!SubmitterID] VARCHAR(50)     
)

SET @InstanceID = NEWID()

UPDATE ClaimBatch 
	SET Status =  CAST(@InstanceID AS VARCHAR(50)),
	LastModifiedDate = GetUTCDate()
WHERE ClaimBatchUid = @ClaimBatchuid 
		AND (Status IS NULL OR Status = 'Exporting')

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]
)
SELECT
	100 AS tag,
	NULL AS parent,
	NULL 					AS [SITE!100!PID],
	@ClaimBatchuid				AS [SITE!100!eClaimBatchGUID],
	claimSubmitter.claimSubmitterUid	AS [SITE!100!claimSubmitterID!hide],
	claimSubmitter.PayToServiceSiteUid	AS [SITE!100!payToAddressID!hide]
FROM  claimSubmitter, ClaimBatch
	WHERE ClaimBatch.Status = CAST(@InstanceID AS VARCHAR(50))

EXEC AR_genXMLClaims_Inst_CLAIM @ClaimBatchuid, @claimsFetched = @claimsFetched OUTPUT


IF(@claimsFetched > 0)
BEGIN

	EXEC AR_genXMLClaims_FINANCIALCENTER

	EXEC AR_genXMLClaims_Inst_PROVIDER

	EXEC AR_genXMLClaims_Inst_BILLINGPROVIDER

	EXEC AR_genXMLClaims_Inst_PAYTOPROVIDER

	EXEC AR_genXMLClaims_Inst_ATTENDING

	EXEC AR_genXMLClaims_Inst_SUPERVISING

	EXEC AR_genXMLClaims_Inst_OPERATING

	EXEC AR_genXMLClaims_Inst_SUBSCRIBER

	EXEC AR_genXMLClaims_Inst_PATIENT
	
	EXEC AR_genXMLClaims_Inst_PAYER
			
	EXEC AR_genXMLClaims_Inst_RESPONSIBLEPARTY
	
	EXEC AR_genXMLClaims_Inst_PROC
	
	EXEC AR_genXMLClaims_Inst_REFERRER
			
	EXEC AR_genXMLClaims_Inst_RENDERER
			
	EXEC AR_genXMLClaims_Inst_SERVICEFACILITY
			    
	EXEC AR_genXMLClaims_Inst_COB
	
	EXEC AR_genXMLClaims_Inst_CLAIM_UB @ClaimBatchuid		-- , @claimsFetched = @claimsFetched OUTPUT			

	SET NOCOUNT OFF

	SELECT
	*
	FROM #XMLClaims_temp
	ORDER BY
    	[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
    	[FINANCIALCENTER!105!FCID],
		[PROVIDER!110!PID],		--CYS SC 11/03/08
		[RENDERER!410!ID!hide],
		[SUBSCRIBER!200!PEID],
		[PATIENT!300!PEID],
		[CLAIM!400!PID],
		[PROC!450!count],
		parent,
		tag

	FOR XML EXPLICIT
END
ELSE
BEGIN
	SELECT
	*
	FROM #XMLClaims_temp
	ORDER BY
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
    [FINANCIALCENTER!105!FCID],
	[PROVIDER!110!PID],		--CYS SC 11/03/08
	[RENDERER!410!ID!hide],
	[SUBSCRIBER!200!PEID],
	[PATIENT!300!PEID],
	[CLAIM!400!PID],
	[PROC!450!count],
	parent,
	tag
	
	FOR XML EXPLICIT
END

DROP TABLE #XMLClaims_temp

COMMIT TRANSACTION


-- ================================================
SET ANSI_NULLS ON


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_PROC_MA]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_PROC_MA] AS' 
END
GO

ALTER PROC [dbo].[AR_genXMLClaims_Inst_PROC_MA]
AS

--CYS SC 10/22/09 - Note - NF Procs are now excluded
--CYS SC 04/29/09 - chgs to Sum rolled up Procs into Claim 400 TotalBill
--DSW    05/08/2015 - 38245 - CHC/RHC processing   Preventative Service codes should not roll up when billed on RHC claims.
-- DSW   03/16/2016 - RHC detail - complete rewrite to handle FQHC, PPS, and RHC Detail
-- DSW   04/06/2016	- RHC - Allow for RHC type ( Like FQHC but also has a mapping table )
-- DSW  04/20/2016 - 48789 - RHC payer setting is not rolling up
-- DSW  04/20/2016 - 48805 - Need to remove procedures without revenue codes for RHC also
-- DSW  05/31/2016 - 49368 - 5th digit on Rev Code needs to be suppressed.

/***** Medicare A Rollup Logic ********************************************
MA SP Rolls up the revenue codes - all fees for a specific rev code are rolled into a single Proc for that Rev Code
Any procs with missing Rev Codes are deleted

*/

------------------------------------------------------------------------------------------------------------------------------
-- FQHC solution
-- RHC Solution ( Works like FQHC BUT ALSO uses a mapping table to override revenue codes )

-- FQHC ( chcBillingType == 0 ), RHC ( chcBillingType == 3 )
-- Groups ( Rolls Up ) procedures by revenue code
-- NOTE:  Throws out procedures with no revenue code

-- Creae a working table for all superbill procedures with FQHC revenue codes
CREATE TABLE #fqhc_temp
(
		[CLAIM!400!PID] UNIQUEIDENTIFIER,
		SuperbillProcedureUid UNIQUEIDENTIFIER,
		ProcedureUid UNIQUEIDENTIFIER,
		RevenueCode VARCHAR(10),
		RevenueCodeOrder int,
		Charge MONEY
)

-- Insert into working fqhc table ( Only those with billing type of 0 which is fqhc )
--  Revenue code procedures based on:
--     Superbill, SuperbillProcedureUid, RevenueCode
--     (Include a revenueCodeOrder to allow grouping later )
INSERT INTO #fqhc_temp( [CLAIM!400!PID], SuperbillProcedureUid, ProcedureUid, RevenueCode, Charge)
	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
		   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
		   sbp.ProcedureUid AS ProcedureUid,
		   #XMLClaims_temp.[PROC!450!revenueCode] AS RevenueCode,
		   --ROW_NUMBER() OVER( PARTITION BY #xmlClaims_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder,
		   CASE WHEN (ISNUMERIC(#XMLClaims_temp.[PROC!450!Charge]) = 1 ) THEN CONVERT( MONEY, #XMLClaims_temp.[PROC!450!Charge]) ELSE 0 END AS Charge
	FROM #XMLClaims_temp
			INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = #XMLClaims_temp.[PROC!450!ID!hide]
	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] IN (0,3) -- FQHC==0, RHC=3
			AND (IsNull([PROC!450!revenueCode],'0') != '0') -- anything WITH a revenue code
	ORDER BY sbp.DisplayOrder

IF ( EXISTS( SELECT * FROM #fqhc_temp ) )
BEGIN

	-- Update procedure revenue codes with RHC ( 3 ) revenue codes (Mapping Table for RHC)
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!revenueCode] = mi.SubstitutionText
		FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #xmlClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
				INNER JOIN MapItem mi WITH (NOLOCK) ON mi.MapSourceUid = '649D2F6A-D215-41F3-963F-E912AACAF335' -- RHC 
														AND #fqhc_temp.ProcedureUid = mi.FindTableFromItemUid
		WHERE #XMLClaims_temp.tag = 450 -- PROC
				AND #XMLClaims_temp.[PROC!450!revenueCode] IS NOT NULL
			    AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 3 -- RHC=3 ( ONLY for RHC, NOT FOR FQHC )

	--For FQHC/RHC billing type, only want Procs with RevenueCodes
	-- Remove those without revenue codes
	DELETE #XMLClaims_temp 
	WHERE	(tag = '450') AND 
			([CLAIM!400!ChcBillingType] IN (0,3)) AND -- FQHC==0, RHC=3
			(IsNull([PROC!450!revenueCode],'0') = '0')

	-- Create a revenueCodeOrder based on "substituted" revenue code
	;with myCTE as
	(
		SELECT #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.SuperbillProcedureUid, #XMLClaims_temp.[PROC!450!revenueCode] as RevenueCode,
				ROW_NUMBER() OVER( PARTITION BY #fqhc_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) as RevenueCodeOrder
		FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #fqhc_temp.SuperbillProcedureUid = sbp.SuperbillProcedureUid
		WHERE #XMLClaims_temp.tag = 450 -- PROC
	)
	Update #fqhc_temp
		SET RevenueCode = mc.RevenueCode,
			RevenueCodeOrder = mc.RevenueCodeOrder
	FROM #fqhc_temp
			INNER JOIN myCTE mc on #fqhc_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID] 
									AND #fqhc_temp.SuperbillProcedureUid = mc.SuperbillProcedureUid

	--
	-- select * from #fqhc_temp order by RevenueCodeOrder asc
	--

	-- Now create a common table expression summing up like revenue codes based on 
	--  superbill and revenueCode
	-- Then
	--  Update the working table with the total for each revenue code
	--   NOTE:  only change the first revenue code entry since others are duplicates and will be thrown out later
	;with myCTE AS
	(
		select #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode, Sum( #fqhc_temp.Charge) as TotalRevCodeCharge
		from #fqhc_temp
		group by #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode
	)
	UPDATE #fqhc_temp
		SET #fqhc_temp.Charge = myCTE.TotalRevCodeCharge
	FROM #fqhc_temp
			INNER JOIN myCTE ON #fqhc_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
									AND #fqhc_temp.RevenueCode = myCTE.RevenueCode
	WHERE #fqhc_temp.RevenueCodeOrder = 1 -- Only change the 1st entry of this revenue code

	-- Now delete all "duplicate" revenue codes
	--   Those in working table with a revenueCodeOrder > 1
	DELETE #XMLClaims_temp
	FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid	
	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] IN ( 0, 3) -- FQHC==0, RHC==3
			AND #fqhc_temp.RevenueCodeOrder > 1		-- Only delete the duplicate revenue codes after the first one

	-- Now update the "first" revenue code with the new sum of all revenue codes
	Update #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!Charge] = CONVERT(VARCHAR(10), #fqhc_temp.Charge)
	FROM #XMLClaims_temp
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	WHERE #XMLClaims_temp.tag = 450 -- proc
	-- only thing left should be thos with RevenueCodeOrder of 1

	--
	-- select * from #fqhc_temp order by RevenueCodeOrder asc
	--

	-- Update claim "Total Charge" now that everything is rolled up
	;WITH myCTE AS
	(
		select #XMLClaims_temp.[CLAIM!400!PID], SUM( CONVERT(MONEY,#XMLClaims_temp.[PROC!450!Charge])) AS TotalCharge	
		from #XMLClaims_temp
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	    WHERE #XMLClaims_temp.tag = 450 -- proc
		GROUP BY #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp 
		SET [CLAIM!400!totalBill] = CONVERT(VARCHAR(10),  mc.TotalCharge)
	FROM #XMLClaims_temp
			INNER JOIN myCTE mc on #XMLClaims_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID]
	WHERE #XMLClaims_temp.tag = 400

END

TRUNCATE TABLE 	#fqhc_temp  -- don't drop yet because used in RHC "legacy" detail ( treats RHC like FQHC )

-----------------------------------------------------------------------------------------------------------------------------------
-- RHC Detail solution
CREATE TABLE #rhc_temp
(
		[CLAIM!400!PID] UNIQUEIDENTIFIER,
		ServiceDateStart DATETIME,							-- Superbill service date
		MinDisplayOrder int,					-- minimum procedure display order on claim
		totalBill money										-- sum of charges on claim
)

-- Insert into working rhc table ( Only thos with billing type of 0 which is rhc )
INSERT INTO #rhc_temp( [CLAIM!400!PID], ServiceDateStart, totalBill)
	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID], sb.ServiceDateStart AS ServiceDateStart, 0 as totalBill
	FROM #XMLClaims_temp
			INNER JOIN Superbill sb WITH (NOLOCK) ON #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid
	WHERE #XMLClaims_temp.tag = 400 -- CLAIMS
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 2 -- RHC

IF ( EXISTS( SELECT * FROM #rhc_temp ) )
BEGIN
	-- For RHC,
	-- If "Legacy RHC" then convert revenue codes to older version
	--    Part A: Get RHC Legacy Date from MapSource Notes
	DECLARE @rhcLegacyDate date
	declare @rhcLegacyInfo varchar(500)
	declare @endIndex int
	SELECT @rhcLegacyInfo = Notes FROM MapSource WITH (NOLOCK) WHERE MapSourceUid = 'A2D729F2-F416-4528-BE63-B27A0F95F001'

	select @endindex = CHARINDEX(', RHCs are required to report', @rhcLegacyInfo)
	if ( @endIndex > 14 )
	begin
		select @rhcLegacyDate = CONVERT(date, SUBSTRING(@rhcLegacyInfo, 13, (@endIndex-13)), 104)
	end
	else
	begin
		select @rhcLegacyDate = '2016-04-01' -- If unable to "decipher" date use hard-coded date
	end

	-- test     select @rhcLegacyDate as RHCLegacyDate, 'A2D729F2-F416-4528-BE63-B27A0F95F001' AS MapSource

	-- Part B:  Update procedure revenue codes with legacy revenue codes only if before legacy date
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!revenueCode] = mi.SubstitutionText
		FROM #XMLClaims_temp
				INNER JOIN #rhc_temp ON #xmlClaims_temp.[CLAIM!400!PID] = #rhc_temp.[CLAIM!400!PID]
											AND #rhc_temp.ServiceDateStart < @rhcLegacyDate
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #XMLClaims_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid 
				INNER JOIN MapItem mi WITH (NOLOCK) ON mi.MapSourceUid = 'A2D729F2-F416-4528-BE63-B27A0F95F001' -- RHC Detail
														AND sbp.ProcedureUid = mi.FindTableFromItemUid
		WHERE #XMLClaims_temp.tag = 450 -- PROC
				AND #XMLClaims_temp.[PROC!450!revenueCode] IS NOT NULL

	--For RHC billing type, only want Procs with RevenueCodes
	-- Remove those without revenue codes
	DELETE #XMLClaims_temp 
	WHERE	(tag = '450') AND 
			([CLAIM!400!ChcBillingType] = 2) AND
			(IsNull([PROC!450!revenueCode],'0') = '0')

	;with myCTE AS
	(
		select #rhc_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
				SUM( CONVERT(MONEY,#XMLClaims_temp.[PROC!450!charge])) as [PROC!450!charge]
		from #rhc_temp
				INNER JOIN #XMLClaims_temp ON #rhc_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
	    WHERE #XMLClaims_temp.tag = 450 -- proc
		GROUP BY #rhc_temp.[CLAIM!400!PID]
	)
	UPDATE #rhc_temp
		SET totalBill = mc.[PROC!450!charge]
		FROM #rhc_temp
				INNER JOIN myCTE mc ON #rhc_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID]

	-----------------------------------------------------------------------------------------------
	-- Post Legacy claims ( After legacy date claims )
	-----------------------------------------------------------------------------------------------
	-- Part C: For "post" legacy RHC claims....
	--  The first superbill procedure contains the sum of all procedures on the claim
	--  Subsequent procedures are not changed
	;with myCTE AS
	(
		-- Retrieve the minimum superbill procedure for each rhc claim and total bill on claim so we don't have to calculate it
		SELECT #rhc_temp.[CLAIM!400!PID] as [CLAIM!400!PID], #rhc_temp.totalBill, MIN( sbp.DisplayOrder ) as minDisplayOrder
		FROM #rhc_temp
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #rhc_temp. [CLAIM!400!PID] = sbp.SuperbillUid
																	and sbp.DontClaim = 0
		WHERE #rhc_temp.ServiceDateStart >= @rhcLegacyDate
		GROUP BY #rhc_temp.[CLAIM!400!PID], #rhc_temp.totalBill
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[PROC!450!charge] = myCTE.totalBill
	FROM #XMLClaims_temp
			INNER JOIN myCTE ON #xmlClaims_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
			INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #XMLClaims_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid 
																and myCTE.minDisplayOrder = sbp.DisplayOrder
	WHERE #XMLClaims_temp.tag = 450 -- PROC

	-- PartD: For "post" legacy RHC Claims
	-- Now that the first procedure has changed, change the total billed amount on the claim
	;with myCTE as
	(
		select #XMLClaims_temp.[CLAIM!400!PID] as uid,
				sum(cast(coalesce(#XMLClaims_temp.[PROC!450!charge], '0') as decimal(10,2))) as total
		from #XMLClaims_temp
				INNER JOIN #rhc_temp ON #xmlClaims_temp.[CLAIM!400!PID] = #rhc_temp.[CLAIM!400!PID]
											AND #rhc_temp.ServiceDateStart >= @rhcLegacyDate
		WHERE #XMLClaims_temp.tag = 450
		group by #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[Claim!400!totalBill] = 
			CASE WHEN mc.total = 0 THEN '0' ELSE CONVERT(varchar(12), mc.total, 128) END  -- new
	From #XMLClaims_temp		
			INNER JOIN myCTE mc ON #XMLClaims_temp.[CLAIM!400!PID] = mc.uid
	WHERE #XMLClaims_temp.tag = 400;
	
	-----------------------------------------------------------------------------------------------
	-- Legacy claims ( before legacy date claims )
	-- 
	-----------------------------------------------------------------------------------------------
	-- Part E: Insert into working fqhc/rhc table 
	-- Treat like FQHC FOR LEGACY ITEMS
	INSERT INTO #fqhc_temp( [CLAIM!400!PID], SuperbillProcedureUid, RevenueCode, RevenueCodeOrder, Charge)
		SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
			   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
			   #XMLClaims_temp.[PROC!450!revenueCode] AS RevenueCode,
			   ROW_NUMBER() OVER( PARTITION BY #xmlClaims_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder,
			   CASE WHEN (ISNUMERIC(#XMLClaims_temp.[PROC!450!Charge]) = 1 ) THEN CONVERT( MONEY, #XMLClaims_temp.[PROC!450!Charge]) ELSE 0 END AS Charge
		FROM #rhc_temp  -- Only grabs those with legacy items
				INNER JOIN #XMLClaims_temp ON #rhc_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
				INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = #XMLClaims_temp.[PROC!450!ID!hide]
		WHERE #rhc_temp.ServiceDateStart < @rhcLegacyDate
			    AND #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
				AND (IsNull([PROC!450!revenueCode],'0') != '0') -- anything WITH a revenue code
		ORDER BY sbp.DisplayOrder

	-- NOTE: #fqhc_temp contains only those procedures with a "legacy" rhc date
	-- test select * from #fqhc_temp

	-- Part F: Remove those without revenue codes (rhc/fqhc)
	DELETE #XMLClaims_temp
	FROM #rhc_temp
			INNER JOIN #XMLClaims_temp ON  #rhc_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
											AND #rhc_temp.ServiceDateStart < @rhcLegacyDate
	WHERE	(#XMLClaims_temp.tag = '450') AND 
			(IsNull(#XMLClaims_temp.[PROC!450!revenueCode],'0') = '0')

	-- 	-- Now create a common table expression summing up like revenue codes based on 
	--  superbill and revenueCode
	-- Then
	--  Update the working table with the total for each revenue code
	--   NOTE:  only change the first revenue code entry since others are duplicates and will be thrown out later
	;with myCTE AS
	(
		select #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode, Sum( #fqhc_temp.Charge) as TotalRevCodeCharge
		from #fqhc_temp
		group by #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode
	)
	UPDATE #fqhc_temp
		SET #fqhc_temp.Charge = myCTE.TotalRevCodeCharge
	FROM #fqhc_temp 
				INNER JOIN myCTE ON #fqhc_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
									AND #fqhc_temp.RevenueCode = myCTE.RevenueCode
	WHERE #fqhc_temp.RevenueCodeOrder = 1 -- Only change the 1st entry of this revenue code

	-- test select * from #fqhc_temp

	-- Now delete all "duplicate" revenue codes
	-- Those in working table with a revenueCodeOrder > 1
	DELETE #XMLClaims_temp
	FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid	
	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
			--AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 0 -- FQHC
			AND #fqhc_temp.RevenueCodeOrder > 1		-- Only delete the duplicate revenue codes after the first one

	--Part G:  Now update the "first" revenue code with the new sum of all revenue codes
	Update #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!Charge] = CONVERT(VARCHAR(10), #fqhc_temp.Charge)
	FROM #XMLClaims_temp 
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	WHERE #XMLClaims_temp.tag = 450 -- proc

	-- Part F: Update claim "Total Charge" now that everything is rolled up
	;WITH myCTE AS
	(
		select #XMLClaims_temp.[CLAIM!400!PID], SUM( CONVERT(MONEY,#XMLClaims_temp.[PROC!450!Charge])) AS TotalCharge 
		from #XMLClaims_temp
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	    WHERE #XMLClaims_temp.tag = 450 -- proc
		GROUP BY #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp 
		SET [CLAIM!400!totalBill] = CONVERT(VARCHAR(10),  mc.TotalCharge)
	FROM #XMLClaims_temp
			INNER JOIN myCTE mc on #XMLClaims_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID]
	WHERE #XMLClaims_temp.tag = 400
	
END
DROP TABLE #rhc_temp
DROP TABLE #fqhc_temp

-----------------------------------------------------------------------------------------------------------------------------------
-- PPS solution
CREATE TABLE #pps_temp
(
		[CLAIM!400!PID] UNIQUEIDENTIFIER		
)
-- Insert into working rhc table ( Only thos with billing type of 0 which is rhc )
INSERT INTO #pps_temp( [CLAIM!400!PID] )
	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID]
	FROM #XMLClaims_temp
	WHERE #XMLClaims_temp.tag = 400 -- CLAIMS
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 1 -- PPS

IF ( EXISTS( SELECT * FROM #pps_temp ) )
BEGIN

	-- Working temp table for pps with claim, sbp, and chcRelApprovalSetting
	CREATE TABLE #ppsProc_temp
	(
			[CLAIM!400!PID] UNIQUEIDENTIFIER,
			[PROC!450!ID!hide] UNIQUEIDENTIFIER,
			InsurancePlanUid UNIQUEIDENTIFIER,
			PostingType int,
			Rate MONEY,
			UseFeeSchedule bit,
			UseAllowedAmount bit
	)	
	
	-- Find ALL PPS procedures from #pps_temp claim table
	--  Get PostingType	( 0 == Post to Financials, 1 == Claim Reference Only
	--		Rate			Rate for now is hard-set rate from CHC settings ( may change based on Posting Type, UseFeeSchedule, UseAllowedAmoount)
	--      UseFeeSchedule	Get Rate value from FeeSchedule ( ClaimingProvider or InsurancePlan or InsuranceCarrier)
	--		UseAllowedAmount  Get Rate value from Amount Allowed Schedule ( InsurancePlan or Insurance Carrier )
	--      
	INSERT INTO #ppsProc_temp([CLAIM!400!PID], [PROC!450!ID!hide], InsurancePlanUid, PostingType, Rate, UseFeeSchedule, UseAllowedAmount)
		SELECT #pps_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!ID!hide], cip.InsurancePlanUid as InsurancePlanUid,
			    coalesce(cras.PostingType,0) as PostingType,
				cras.Rate, COALESCE(cras.UseFeeSchedule,0) AS UseFeeSchedule, COALESCE(cras.UseAllowedAmount,0) AS UseAllowedAmount
		FROM #pps_temp
			INNER JOIN Superbill sb with (nolock) ON #pps_temp.[CLAIM!400!PID] = sb.SuperbillUid
			inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid = sba.SuperbillUid
			INNER JOIN ChcInsurancePlan cip with (nolock) on sba.CurrentInsurancePlanUid = cip.InsurancePlanUid
			INNER JOIN ChcListApprovalSetting cas with (nolock) on cip.ApprovalSettingUid = cas.ApprovalSettingUid
			INNER JOIN ChcApprovalPeriod cap with (nolock) on cas.ApprovalSettingUid = cap.ApprovalSettingUid
																AND (cap.EffectiveDate IS NULL OR sb.ServiceDateStart >= cap.EffectiveDate )
																AND (cap.ExpirationDate	IS NULL OR sb.ServiceDateStart <= cap.ExpirationDate )
			INNER JOIN ChcRelApprovalSetting cras with (nolock) on cap.ApprovalPeriodUid = cras.ApprovalPeriodUid
																AND sba.ServiceSiteUid = cras.ServiceSiteUid
			INNER JOIN #XMLClaims_temp ON #XMLClaims_temp.tag = 450
											AND #pps_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID] 
			INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #XMLClaims_temp.[PROC!450!ProcID] = sbp.SuperbillProcedureUid
																AND sbp.ProcedureUid = cras.ProcedureUid

	-- Reorder procedure "display Order" moving PPS procedures to "top"
	;WITH myCTE AS
	(
		SELECT #pps_temp.[CLAIM!400!PID],  #XMLClaims_temp.[PROC!450!ProcID] as ProcID, #XMLClaims_temp.[PROC!450!count] as OriginalCount,
				CASE WHEN #ppsProc_temp.[PROC!450!ID!hide] IS NULL THEN 0 ELSE 1 END AS ppsProc,
				ROW_NUMBER() OVER( PARTITION BY #pps_temp.[CLAIM!400!PID] 
									ORDER BY CASE WHEN #ppsProc_temp.[PROC!450!ID!hide] IS NULL THEN 0 ELSE 1 END desc,
											 #XMLClaims_temp.[PROC!450!count] asc) AS procOrder

		FROM #pps_temp
			INNER JOIN #XMLClaims_temp ON #XMLClaims_temp.tag = 450
											AND #pps_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID] 
			LEFT OUTER JOIN #ppsProc_temp ON #XMLClaims_temp.[PROC!450!ProcID] = #ppsProc_temp.[PROC!450!ID!hide]
	)
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!count] = mc.procOrder
		FROM #XMLClaims_temp
				INNER JOIN myCTE mc ON #XMLClaims_temp.[PROC!450!ProcID] = mc.ProcID
										AND #XMLClaims_temp.tag = 450

	-- Set rate for any procedure that has posting type of "Claim Reference Only" ( PostingType == 1 )
	-- DEBUGHelp  select * from #ppsProc_temp where #ppsProc_temp.PostingType = 1 -- Claim Reference Only

	-- Posting Type == Claim Reference Only, UseAllowedAmount =1
	UPDATE #ppsProc_temp
		SET #ppsProc_temp.Rate = CASE WHEN ( COALESCE(ip.UseCarrierAmountAllowedFeeSchedule,0) = 0 )
												 THEN COALESCE(fsf.Fee, #ppsProc_temp.Rate, 0)				-- Insurance Amount Allowed or rate or 0
													 ELSE COALESCE(fsfip.Fee, fsf.Fee, #ppsProc_temp.Rate, 0) END	-- Plan Amount Allowed or Insurance Amount allowed or rate or 0
		FROM #ppsProc_temp 
				-- Superbill Procedures
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #ppsProc_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid
				-- Insurance tables
				INNER JOIN InsurancePlan ip WITH (NOLOCK) ON #ppsProc_temp.InsurancePlanUid = ip.InsurancePlanUid
				INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ip.InsuranceCarrierUid = ic.CorporationUid
				-- Amount Allowed - Insurance Carrier Fee
				left outer join FeeSchedule fsAA with (nolock) on ic.AmountAllowedFeeScheduleUid = fsAA.FeeScheduleUid
				left outer join FeeSchedulePeriod fsp with (nolock) on fsAA.FeeScheduleUid = fsp.FeeScheduleUid
															and (fsp.EffectiveDate IS NULL OR sbp.ProcedureServiceDateStart >= fsp.EffectiveDate) 
															and (fsp.ExpirationDate IS NULL OR sbp.ProcedureServiceDateStart <= fsp.ExpirationDate)
				left outer join FeeScheduleFee fsf with (nolock) on fsp.FeeSchedulePeriodUid = fsf.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsf.ProcedureUid
				-- Amount Allowed - Insurance Plan Fee
				left outer join FeeSchedule fsAAip with (nolock) on ip.AmountAllowedFeeScheduleUid = fsAAip.FeeScheduleUid
				left outer join FeeSchedulePeriod fspip with (nolock) on fsAAip.FeeScheduleUid = fspip.FeeScheduleUid
															and (fspip.EffectiveDate IS NULL OR sbp.ProcedureServiceDateStart >= fspip.EffectiveDate) 
															and (fspip.ExpirationDate IS NULL OR sbp.ProcedureServiceDateStart <= fspip.ExpirationDate)
				left outer join FeeScheduleFee fsfip with (nolock) on fspip.FeeSchedulePeriodUid = fsfip.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfip.ProcedureUid
		WHERE #ppsProc_temp.PostingType = 1				-- Claim Reference Only
				AND #ppsProc_temp.UseAllowedAmount = 1  -- Allowed Amount

	-- Posting Type == Claim Reference Only, UseFeeSchedule =1
	UPDATE #ppsProc_temp
		SET #ppsProc_temp.Rate = CASE   WHEN (COALESCE(ip.UseProviderFeeSchedule,0) = 1) 							-- Use Provider Fee Schedule
										THEN COALESCE(fsfPR.Fee, #ppsProc_temp.Rate, 0) 							-- Provider Fee or Rate or 0
										WHEN (COALESCE(ip.UseCarrierFeeSchedule,0) = 0)  
										THEN COALESCE(fsfic.Fee, #ppsProc_temp.Rate, 0)				-- Insurance Carrier Fee  or rate or 0
										ELSE COALESCE(fsfip.Fee, fsfic.Fee, #ppsProc_temp.Rate, 0) END	-- Insurance Plan Fee or Insurance Carrier Fee or rate or 0
		FROM #ppsProc_temp 
				-- Superbill Procedures
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #ppsProc_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid
				-- Superbill Aggregate
				INNER JOIN SuperbillAggregate sba WITH (NOLOCK) ON #ppsProc_temp.[CLAIM!400!PID] = sba.SuperbillUid
				-- Insurance tables
				INNER JOIN InsurancePlan ip WITH (NOLOCK) ON #ppsProc_temp.InsurancePlanUid = ip.InsurancePlanUid
				INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ip.InsuranceCarrierUid = ic.CorporationUid
				INNER JOIN Provider cPR WITH (NOLOCK) ON sba.ClaimingProviderUid = cPR.PersonUid
				-- Fee Schedule - Insurance Carrier fee
				left outer join FeeSchedule fsic with (nolock) on ic.FeeScheduleUid = fsic.FeeScheduleUid
				left outer join FeeSchedulePeriod fspic with (nolock) on fsic.FeeScheduleUid = fspic.FeeScheduleUid
															and (sbp.ProcedureServiceDateStart >= fspic.EffectiveDate or fspic.EffectiveDate is null) 
															and (sbp.ProcedureServiceDateStart <= fspic.ExpirationDate or fspic.ExpirationDate is null)
				left outer join FeeScheduleFee fsfic with (nolock) on fspic.FeeSchedulePeriodUid = fsfic.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfic.ProcedureUid
				-- Fee Schedule - Insurance Plan fee
				left outer join FeeSchedule fsip with (nolock) on ip.FeeScheduleUid = fsip.FeeScheduleUid
				left outer join FeeSchedulePeriod fspip with (nolock) on fsip.FeeScheduleUid = fspip.FeeScheduleUid
															and (sbp.ProcedureServiceDateStart >= fspip.EffectiveDate or fspip.EffectiveDate is null) 
															and (sbp.ProcedureServiceDateStart <= fspip.ExpirationDate or fspip.ExpirationDate is null)
				left outer join FeeScheduleFee fsfip with (nolock) on fspip.FeeSchedulePeriodUid = fsfip.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfip.ProcedureUid
				-- Fee Schedule - Provider
				left outer join FeeSchedule fsPR with (nolock) on cPR.FeeScheduleUid = fsPR.FeeScheduleUid
				left outer join FeeSchedulePeriod fspPR with (nolock) on fsPR.FeeScheduleUid = fspPR.FeeScheduleUid
															and (sbp.ProcedureServiceDateStart >= fspPR.EffectiveDate or fspPR.EffectiveDate is null) 
															and (sbp.ProcedureServiceDateStart <= fspPR.ExpirationDate or fspPR.ExpirationDate is null)
				left outer join FeeScheduleFee fsfPR with (nolock) on fspPR.FeeSchedulePeriodUid = fsfPR.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfPR.ProcedureUid
		WHERE #ppsProc_temp.PostingType = 1				-- Claim Reference Only
				AND #ppsProc_temp.UseFeeSchedule = 1	-- FeeSchedule

	-- DEBUGHelp  select * from #ppsProc_temp where #ppsProc_temp.PostingType = 1 -- Claim Reference Only

	-- Posting Type == Claim Reference Only, Rate specified  in either CHC settings, FeeSchedule or AmountAllowed
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!charge] = #ppsProc_temp.Rate
		FROM #XMLClaims_temp
				INNER JOIN #ppsProc_temp on #XMLClaims_temp.[PROC!450!ProcID] = #ppsProc_temp.[PROC!450!ID!hide]
												AND #ppsProc_temp.PostingType = 1 -- Claim Reference
		WHERE #XMLClaims_temp.tag = 450

	-- Now that the first procedure has changed, change the total billed amount on the claim
	;with myCTE as
	(
		select DISTINCT [CLAIM!400!PID] FROM #ppsProc_temp WHERE PostingType = 1 -- Claim Reference Only
	)
	,myCTE2 as
	(
		select #XMLClaims_temp.[CLAIM!400!PID] as uid,
				sum(cast(coalesce(#XMLClaims_temp.[PROC!450!charge], '0') as decimal(10,2))) as total
		from #XMLClaims_temp
				INNER JOIN myCTE ON #XMLClaims_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
		WHERE #XMLClaims_temp.tag = 450
		group by #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[Claim!400!totalBill] = 
			CASE WHEN mc.total = 0 THEN '0' ELSE CONVERT(varchar(12), mc.total, 128) END  -- new
	From #XMLClaims_temp		
			INNER JOIN myCTE2 mc ON #XMLClaims_temp.[CLAIM!400!PID] = mc.uid
	WHERE #XMLClaims_temp.tag = 400
	
	-- DEBUG  select * from #XMLClaims_temp

	DROP TABLE #ppsProc_temp
END
DROP TABLE #pps_temp

-----------------------------------------------------------------------------------------------------------------------------------
-- For every solution, Only allow 4 digits for revenue code ( Bug 49368 )
	Update #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!revenueCode] = LEFT( #XMLClaims_temp.[PROC!450!revenueCode], 4)
	FROM #XMLClaims_temp
	WHERE #XMLClaims_temp.tag = 450 -- proc

			


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_MA]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_MA] AS' 
END
GO





ALTER PROC [dbo].[AR_genXMLClaims_Inst_MA]
	@ClaimBatchuid uniqueidentifier,
	@InstanceID uniqueidentifier = null output
AS
--CYS SC 12/02/09 - add ServiceDateStart, ServiceDateEnd to ClaimUB for Inst Loop2300 DTP 434. 
--CYS 10/22/09 - add [CLAIM!400!MedicalRecordNumber] field in case we need it later.
--               add [PROC!450!ContractTypeCodeName], [PROC!450!ContractTypeCodeAnsi]
--               add [PROC!450!ProcID] UNIQUEIDENTIFIER
--CYS SC 07/08/09 - Add [CLAIM!400!BillingProvider_IDType] VARCHAR(50) for Service Site bug (CYS Case #22420)
--CYS SC 07/08/09 - Add [CLAIM!400!BillingProvider_ID] VARCHAR(50) for Service Site bug (CYS Case #22420)
--CYS SC 05/21/09 - add [CLAIM!400!EPSDT] for CLM12
--CYS SC 05/21/09 - add [CLAIM!400!delayReasonCode] for CLM20 
--DSW    03/09/2016 - add [CLAIM!400!ChcBillingType] for RHC Detail
--DSW    2016-07-11 Bug 36412 - Country Code
/* 
Modified On: 20051011
Modifications Made:	2. For Accident date
			1. For handling WCC Case... added isWCC column to temp table: 20050823
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
--CYS SC - _Dr fields = Individual Dr ID regardless of filing type for Loop2310A

*/
BEGIN TRANSACTION

/*
General Structure of the return document:
	<PROVIDER>
		<BILLINGPROVIDER/>
		<PAYTOPROVIDER/>
		<ATTENDING/>
		<SUBSCRIBER>
			<SUBSCRIBER/>
			<PAYER/>
			<PATIENT>
				<PATIENT/>
				<CLAIMS>
					<CLAIM/>
					<RENDERER/>
					<SITE/>
					<PROC/>
					<PROC/>
				</CLAIMS>
			</PATIENT>
		</SUBSCRIBER>
	</PROVIDER>
*/
SET NOCOUNT ON

DECLARE @claimsFetched INT

DECLARE @eClaimFileUID UNIQUEIDENTIFIER
SET @eClaimFileUID = NEWID()

--DELETE FROM #XMLClaims_temp

--DROP TABLE #XMLClaims_temp

CREATE TABLE #XMLClaims_temp (
	tag INT,
	parent INT,
	[SITE!100!PID] UNIQUEIDENTIFIER,
	[SITE!100!eClaimBatchGUID] UNIQUEIDENTIFIER,
	[SITE!100!claimSubmitterID!hide] UNIQUEIDENTIFIER,
	[SITE!100!payToAddressID!hide] UNIQUEIDENTIFIER,
	[PROVIDER!110!PID] VARCHAR(50),
	[CLAIM!400!PID] UNIQUEIDENTIFIER,
	[CLAIM!400!accountNumber] VARCHAR(50),
    [CLAIM!400!MedicalRecordNumber] VARCHAR(50), --CYS SC 10/22/09 -- Added for Ak Medicaid by Qatalys
	[CLAIM!400!totalBill] VARCHAR(12),
	[CLAIM!400!diag1] VARCHAR(50),
	[CLAIM!400!diag2] VARCHAR(50),
	[CLAIM!400!diag3] VARCHAR(50),
	[CLAIM!400!diag4] VARCHAR(50),
	[CLAIM!400!diag5] VARCHAR(50),
	[CLAIM!400!diag6] VARCHAR(50),
	[CLAIM!400!diag7] VARCHAR(50),
	[CLAIM!400!diag8] VARCHAR(50),
	[CLAIM!400!patientMemberID] VARCHAR(110),
	[CLAIM!400!patientgroupID] VARCHAR(50),
	[CLAIM!400!subscriberMemberID] VARCHAR(50),
	[CLAIM!400!authorizeAssignment] TINYINT,
	[CLAIM!400!providerID] VARCHAR(50),
	[CLAIM!400!providerIDType] VARCHAR(50),
	[CLAIM!400!providerGroupID] VARCHAR(50),
	[CLAIM!400!providerGroupIDType] VARCHAR(50),
	[CLAIM!400!facilityPrimaryID] VARCHAR(50),
	[CLAIM!400!facilityPrimaryIDType] VARCHAR(50),
	[CLAIM!400!facilityID] VARCHAR(50),
	[CLAIM!400!facilityIDType] VARCHAR(50),
	[CLAIM!400!claimFrequencyCode] INT,
	[CLAIM!400!providerSignatureOnFile] VARCHAR(1),
	[CLAIM!400!providerAcceptAssignment] VARCHAR(1),
	[CLAIM!400!patientAcceptAssignment] VARCHAR(1),
	[CLAIM!400!releaseOfInformation] VARCHAR(1),
	[CLAIM!400!patientSignatureSource] VARCHAR(1),
	[CLAIM!400!patientSignatureDate] VARCHAR(20),
	[CLAIM!400!siteType] VARCHAR(2),
	[CLAIM!400!onsetCurrentDate] DATETIME,
	[CLAIM!400!onsetFirstDate] DATETIME,
	[CLAIM!400!noWorkFromDate] DATETIME,
	[CLAIM!400!noWorkToDate] DATETIME,
	[CLAIM!400!hospitalizationStartDate] DATETIME,
	[CLAIM!400!hospitalizationEndDate] DATETIME,
	[CLAIM!400!familyPlan] INT,
	[CLAIM!400!relatedCausesCode] VARCHAR(2),
	[CLAIM!400!accidentState] VARCHAR(2),
	[CLAIM!400!accidentDate] DATETIME,
	[CLAIM!400!priorAuthorizationCode] VARCHAR(20),
	[CLAIM!400!SendNPI] BIT,
	[CLAIM!400!Dmerc] BIT,
	[CLAIM!400!ICN] VARCHAR(30),	--ADDED ICN NUMBER REPORTDED IN LOOP 2300 6/19/08
	[CLAIM!400!EPSDT] BIT,                  --SC Added for CLM12 05/21/09
    [CLAIM!400!delayReasonCode] VARCHAR(2), --SC Added for CLM20 05/21/09
	
	--CYS SC 07/08/09 - Added for Service Site bug (CYS Case #22420)
	[CLAIM!400!BillingProvider_IDType] VARCHAR(50),  
	[CLAIM!400!BillingProvider_ID] VARCHAR(50),		 

	-- added by IR for primary and current carrier
    [CLAIM!400!primaryCarrierUID] UNIQUEIDENTIFIER,
	[CLAIM!400!currentCarrierUID] UNIQUEIDENTIFIER,
	[CLAIM!400!PatientPaidAmount] MONEY,
	[CLAIM!400!ResubmissionCode] VARCHAR(50),
	[CLAIM!400!UseICD10] BIT,
	[CLAIM!400!ElectronicClaimFormatUid] UNIQUEIDENTIFIER,
	[CLAIM!400!ChcBillingType] int,

--***************************************************************************

	/* CYS SC */	
	[CLAIMUB!405!typeOfBill] VARCHAR(5),		
	[CLAIMUB!405!dischargeTime] DATETIME,
	[CLAIMUB!405!admissionTime] DATETIME,
	[CLAIMUB!405!coveredPeriodFrDate] DATETIME,
	[CLAIMUB!405!coveredPeriodToDate] DATETIME,
	[CLAIMUB!405!admissionTypeANSI] VARCHAR(1),
	[CLAIMUB!405!admissionSourceANSI] VARCHAR(1),		
	[CLAIMUB!405!patientStatusUBANSI] VARCHAR(2),		
	[CLAIMUB!405!claimHeaderNoteCodeANSI] VARCHAR(3),
	[CLAIMUB!405!claimNote] VARCHAR(80),
	[CLAIMUB!405!serviceAuthorizationExceptionANSI] VARCHAR(1),		
	[CLAIMUB!405!admittingDiag] VARCHAR(50),
	[CLAIMUB!405!externalInjuryDiag] VARCHAR(50),
	[CLAIMUB!405!drgProc] VARCHAR(30),
    [CLAIMUB!405!otherProc1] VARCHAR(30),
	[CLAIMUB!405!otherProc1ANSI] VARCHAR(3),
	[CLAIMUB!405!otherProc1Date] DATETIME,
	[CLAIMUB!405!otherProc2] VARCHAR(30),
	[CLAIMUB!405!otherProc2ANSI] VARCHAR(3),
	[CLAIMUB!405!otherProc2Date] DATETIME,
	[CLAIMUB!405!otherProc3] VARCHAR(30),
	[CLAIMUB!405!otherProc3ANSI] VARCHAR(3),
	[CLAIMUB!405!otherProc3Date] DATETIME,
	[CLAIMUB!405!otherProc4] VARCHAR(30),
	[CLAIMUB!405!otherProc4ANSI] VARCHAR(3),
	[CLAIMUB!405!otherProc4Date] DATETIME,
	[CLAIMUB!405!occurrenceSpan1ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceSpan1FrDate] DATETIME,
	[CLAIMUB!405!occurrenceSpan1ToDate] DATETIME,
	[CLAIMUB!405!occurrenceSpan2ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceSpan2FrDate] DATETIME,
	[CLAIMUB!405!occurrenceSpan2ToDate] DATETIME,
	[CLAIMUB!405!occurrenceCode1ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode1Date] DATETIME,
	[CLAIMUB!405!occurrenceCode2ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode2Date] DATETIME,
	[CLAIMUB!405!occurrenceCode3ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode3Date] DATETIME,
	[CLAIMUB!405!occurrenceCode4ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode4Date] DATETIME,
	[CLAIMUB!405!occurrenceCode5ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode5Date] DATETIME,
	[CLAIMUB!405!occurrenceCode6ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode6Date] DATETIME,
	[CLAIMUB!405!occurrenceCode7ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode7Date] DATETIME,
	[CLAIMUB!405!occurrenceCode8ANSI] VARCHAR(3),
	[CLAIMUB!405!occurrenceCode8Date] DATETIME,
	[CLAIMUB!405!valueCode1ANSI] VARCHAR(3),
	[CLAIMUB!405!valueCode1Amount] VARCHAR(12),
	[CLAIMUB!405!valueCode2ANSI] VARCHAR(3),
	[CLAIMUB!405!valueCode2Amount] VARCHAR(12),
	[CLAIMUB!405!valueCode3ANSI] VARCHAR(3),
	[CLAIMUB!405!valueCode3Amount] VARCHAR(12),
	[CLAIMUB!405!valueCode4ANSI] VARCHAR(3),
	[CLAIMUB!405!valueCode4Amount] VARCHAR(12),
	[CLAIMUB!405!conditionCode1ANSI] VARCHAR(3),
	[CLAIMUB!405!conditionCode2ANSI] VARCHAR(3),
	[CLAIMUB!405!conditionCode3ANSI] VARCHAR(3),
	[CLAIMUB!405!conditionCode4ANSI] VARCHAR(3),
	[CLAIMUB!405!coverageDays] INT,
	[CLAIMUB!405!nonCoveredDays] INT,
	[CLAIMUB!405!coInsuranceDays] INT,
	[CLAIMUB!405!lifetimeReserveDays] INT,
    --CYS SC 12/02/09 add ServiceDateStart, ServiceDateEnd to ClaimUB for Inst Loop2300 DTP 434 
    [CLAIMUB!405!ServiceDateStart] VARCHAR(20),
    [CLAIMUB!405!ServiceDateEnd] VARCHAR(20),
	/* CYS SC */
--***************************************************************************

	[BILLINGPROVIDER!120!PID] UNIQUEIDENTIFIER,
	[BILLINGPROVIDER!120!LN]	VARCHAR(60),
	[BILLINGPROVIDER!120!FN]	VARCHAR(50),
	[BILLINGPROVIDER!120!MI]	VARCHAR(50),

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!LN_Dr]	VARCHAR(60),
	[BILLINGPROVIDER!120!FN_Dr]	VARCHAR(50),
	[BILLINGPROVIDER!120!MI_Dr]	VARCHAR(50),

	[BILLINGPROVIDER!120!address1] VARCHAR(100),
	[BILLINGPROVIDER!120!address2] VARCHAR(100),
	[BILLINGPROVIDER!120!city] VARCHAR(50),
	[BILLINGPROVIDER!120!state] VARCHAR(10),
	[BILLINGPROVIDER!120!zip] VARCHAR(20),
	[BILLINGPROVIDER!120!phone] VARCHAR(30),
	[BILLINGPROVIDER!120!siteType] SMALLINT,
	[BILLINGPROVIDER!120!IDType] VARCHAR(50),
	[BILLINGPROVIDER!120!ID] VARCHAR(50),	

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!IDType_Dr] VARCHAR(50),
	[BILLINGPROVIDER!120!ID_Dr] VARCHAR(50),	
	
	[BILLINGPROVIDER!120!FCID] UNIQUEIDENTIFIER,
	[BILLINGPROVIDER!120!FileAsGroup] BIT,
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType] VARCHAR(50),
	[BILLINGPROVIDER!120!NPISecID] VARCHAR(50),

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!NPISecIDType_Dr] VARCHAR(50),
	[BILLINGPROVIDER!120!NPISecID_Dr] VARCHAR(50),

	[BILLINGPROVIDER!120!LocationNo] VARCHAR(10),

	[PATIENT!300!PEID] UNIQUEIDENTIFIER,
	[PATIENT!300!prefix] VARCHAR(10),
	[PATIENT!300!LN] VARCHAR(50),
	[PATIENT!300!FN] VARCHAR(50),
	[PATIENT!300!MI] VARCHAR(50),
	[PATIENT!300!suffix] VARCHAR(20),
	[PATIENT!300!gender] VARCHAR(50),
	[PATIENT!300!birthdate] VARCHAR(12),
	[PATIENT!300!employer] VARCHAR(100),
	[PATIENT!300!occupation] VARCHAR(50),
	[PATIENT!300!address1] VARCHAR(100),
	[PATIENT!300!address2] VARCHAR(100),
	[PATIENT!300!city] VARCHAR(50),
	[PATIENT!300!state] VARCHAR(10),
	[PATIENT!300!zip] VARCHAR(20),
	[PATIENT!300!phoneNumber] VARCHAR(30),
	[PATIENT!300!rIDType] VARCHAR(50),
	[PATIENT!300!rID] VARCHAR(50),
	[PATIENT!300!IDType] VARCHAR(50),
	[PATIENT!300!ID] VARCHAR(50),
	[PATIENT!300!patientRelationToInsured] VARCHAR(4),

	[PAYER!230!ID!hide] UNIQUEIDENTIFIER,
	[PAYER!230!CarrierID] UNIQUEIDENTIFIER,
	[PAYER!230!planType!hide] UNIQUEIDENTIFIER,
	[PAYER!230!planType] VARCHAR(4),
	[PAYER!230!orgName] VARCHAR(100),
	[PAYER!230!planName] VARCHAR(100),
	[PAYER!230!address1] VARCHAR(100),
	[PAYER!230!address2] VARCHAR(100),
	[PAYER!230!city] VARCHAR(50),	
    [PAYER!230!Inactive] BIT,       --Added for Inactive Payers

	[PAYER!230!state] VARCHAR(10),
	[PAYER!230!zip] VARCHAR(20),
	[PAYER!230!phone] VARCHAR(30),
	[PAYER!230!capitated] BIT,
	[PAYER!230!acceptAssignment] VARCHAR(1),
	[PAYER!230!IDType] VARCHAR(50),
	[PAYER!230!ID] VARCHAR(50),
	[PAYER!230!elecPayerID] VARCHAR(50),
	[PAYER!230!rIDType] VARCHAR(50),
	[PAYER!230!rID] VARCHAR(50),
    [PAYER!230!TaxonomyCode] VARCHAR(50), -- Added for 13369, 13953

	[PAYTOPROVIDER!130!PID] UNIQUEIDENTIFIER,
	[PAYTOPROVIDER!130!PEID] UNIQUEIDENTIFIER,
	[PAYTOPROVIDER!130!FN] VARCHAR(50),
	[PAYTOPROVIDER!130!LN] VARCHAR(50),
	[PAYTOPROVIDER!130!orgName] VARCHAR(50),
	[PAYTOPROVIDER!130!address1] VARCHAR(100),
	[PAYTOPROVIDER!130!address2] VARCHAR(100),
	[PAYTOPROVIDER!130!city] VARCHAR(50),
	[PAYTOPROVIDER!130!state] VARCHAR(10),
	[PAYTOPROVIDER!130!zip] VARCHAR(20),
	[PAYTOPROVIDER!130!phone] VARCHAR(30),
	[PAYTOPROVIDER!130!siteType] SMALLINT,
	[PAYTOPROVIDER!130!IDType] VARCHAR(50),
	[PAYTOPROVIDER!130!ID] VARCHAR(50),
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType] VARCHAR(50),
	[PAYTOPROVIDER!130!NPISecID] VARCHAR(50),
	
--CYS SC - Inst Attending 
	[ATTENDING!140!PID] UNIQUEIDENTIFIER,
	[ATTENDING!140!PEID] UNIQUEIDENTIFIER,
	[ATTENDING!140!FCID] UNIQUEIDENTIFIER,
	[ATTENDING!140!LN]	VARCHAR(60),
	[ATTENDING!140!FN]	VARCHAR(50),
	[ATTENDING!140!MI]	VARCHAR(50),
	[ATTENDING!140!LN_Dr]	VARCHAR(60),
	[ATTENDING!140!FN_Dr]	VARCHAR(50),
	[ATTENDING!140!MI_Dr]	VARCHAR(50),
	[ATTENDING!140!address1] VARCHAR(100),
	[ATTENDING!140!address2] VARCHAR(100),
	[ATTENDING!140!city] VARCHAR(50),
	[ATTENDING!140!state] VARCHAR(10),
	[ATTENDING!140!zip] VARCHAR(20),
	[ATTENDING!140!phone] VARCHAR(30),
	[ATTENDING!140!siteType] SMALLINT,
	[ATTENDING!140!IDType] VARCHAR(50),
	[ATTENDING!140!ID] VARCHAR(50),	
	[ATTENDING!140!IDType_Dr] VARCHAR(50),	
	[ATTENDING!140!ID_Dr] VARCHAR(50),
	[ATTENDING!140!rIDType] VARCHAR(50),
	[ATTENDING!140!rID] VARCHAR(50),
	[ATTENDING!140!rIDType_Dr] VARCHAR(50),
	[ATTENDING!140!rID_Dr] VARCHAR(50),
	[ATTENDING!140!NPISecIDType] VARCHAR(50),	
	[ATTENDING!140!NPISecID] VARCHAR(50),	
	[ATTENDING!140!NPISecIDType_Dr] VARCHAR(50),	
	[ATTENDING!140!NPISecID_Dr] VARCHAR(50),	
	[ATTENDING!140!providerTaxonomyCode] VARCHAR(15),
	[ATTENDING!140!FileAsGroup] BIT,
	[ATTENDING!140!LocationNo] VARCHAR(10),
	[ATTENDING!140!SuperbillUid] UNIQUEIDENTIFIER,		--CYS SC 11/04/08

----CYS SC - Inst Supervising 
	[SUPERVISING!150!PID] UNIQUEIDENTIFIER,
	[SUPERVISING!150!PEID] UNIQUEIDENTIFIER,
	[SUPERVISING!150!FCID] UNIQUEIDENTIFIER,
	[SUPERVISING!150!LN]	VARCHAR(60),
	[SUPERVISING!150!FN]	VARCHAR(50),
	[SUPERVISING!150!MI]	VARCHAR(50),
	[SUPERVISING!150!LN_Dr]	VARCHAR(60),
	[SUPERVISING!150!FN_Dr]	VARCHAR(50),
	[SUPERVISING!150!MI_Dr]	VARCHAR(50),
	[SUPERVISING!150!address1] VARCHAR(100),
	[SUPERVISING!150!address2] VARCHAR(100),
	[SUPERVISING!150!city] VARCHAR(50),
	[SUPERVISING!150!state] VARCHAR(10),
	[SUPERVISING!150!zip] VARCHAR(20),
	[SUPERVISING!150!phone] VARCHAR(30),
	[SUPERVISING!150!siteType] SMALLINT,
	[SUPERVISING!150!IDType] VARCHAR(50),
	[SUPERVISING!150!ID] VARCHAR(50),	
	[SUPERVISING!150!IDType_Dr] VARCHAR(50),
	[SUPERVISING!150!ID_Dr] VARCHAR(50),	
	[SUPERVISING!150!rIDType] VARCHAR(50),
	[SUPERVISING!150!rID] VARCHAR(50),
	[SUPERVISING!150!rIDType_Dr] VARCHAR(50),
	[SUPERVISING!150!rID_Dr] VARCHAR(50),
	[SUPERVISING!150!NPISecIDType] VARCHAR(50),	
	[SUPERVISING!150!NPISecID] VARCHAR(50),	
	[SUPERVISING!150!NPISecIDType_Dr] VARCHAR(50),	
	[SUPERVISING!150!NPISecID_Dr] VARCHAR(50),	
	[SUPERVISING!150!providerTaxonomyCode] VARCHAR(15),
	[SUPERVISING!150!FileAsGroup] BIT,
	[SUPERVISING!150!LocationNo] VARCHAR(10),
	[SUPERVISING!150!SuperbillUid] UNIQUEIDENTIFIER,		--CYS SC 11/04/08

--
----CYS SC - Inst Operating
	[OPERATING!160!PID] UNIQUEIDENTIFIER,
	[OPERATING!160!PEID] UNIQUEIDENTIFIER,
	[OPERATING!160!FCID] UNIQUEIDENTIFIER,
	[OPERATING!160!LN]	VARCHAR(60),
	[OPERATING!160!FN]	VARCHAR(50),
	[OPERATING!160!MI]	VARCHAR(50),
	[OPERATING!160!LN_Dr]	VARCHAR(60),
	[OPERATING!160!FN_Dr]	VARCHAR(50),
	[OPERATING!160!MI_Dr]	VARCHAR(50),
	[OPERATING!160!address1] VARCHAR(100),
	[OPERATING!160!address2] VARCHAR(100),
	[OPERATING!160!city] VARCHAR(50),
	[OPERATING!160!state] VARCHAR(10),
	[OPERATING!160!zip] VARCHAR(20),
	[OPERATING!160!phone] VARCHAR(30),
	[OPERATING!160!siteType] SMALLINT,
	[OPERATING!160!IDType] VARCHAR(50),
	[OPERATING!160!ID] VARCHAR(50),	
	[OPERATING!160!IDType_Dr] VARCHAR(50),
	[OPERATING!160!ID_Dr] VARCHAR(50),	
	[OPERATING!160!rIDType] VARCHAR(50),
	[OPERATING!160!rID] VARCHAR(50),
	[OPERATING!160!rIDType_Dr] VARCHAR(50),
	[OPERATING!160!rID_Dr] VARCHAR(50),
	[OPERATING!160!NPISecIDType] VARCHAR(50),	
	[OPERATING!160!NPISecID] VARCHAR(50),	
	[OPERATING!160!NPISecIDType_Dr] VARCHAR(50),	
	[OPERATING!160!NPISecID_Dr] VARCHAR(50),	
	[OPERATING!160!providerTaxonomyCode] VARCHAR(15),
	[OPERATING!160!FileAsGroup] BIT,
	[OPERATING!160!LocationNo] VARCHAR(10),
	[OPERATING!160!SuperbillUid] UNIQUEIDENTIFIER,		--CYS SC 11/04/08

--
	[CLAIMCOB!401!COBID] UNIQUEIDENTIFIER,
	[CLAIMCOB!401!CroupCodeEraCode] VARCHAR(8),
	[CLAIMCOB!401!ReasonCodeEraCode] VARCHAR(8),
	[CLAIMCOB!401!Money] MONEY,
	[CLAIMCOB!401!Quantity] SMALLINT,
	[CLAIMCOB!401!Order] SMALLINT,

	[PROC!450!ID!hide] UNIQUEIDENTIFIER,
	[PROC!450!count] SMALLINT,
	[PROC!450!proc] VARCHAR(48),
	[PROC!450!revenueCode] VARCHAR(10),			/* CYS SC */
	[PROC!450!procM1] VARCHAR(8),
	[PROC!450!procM2] VARCHAR(8),
	[PROC!450!procM3] VARCHAR(8),
	[PROC!450!procM4] VARCHAR(8),
	[PROC!450!diag1] SMALLINT,
	[PROC!450!diag2] SMALLINT,
	[PROC!450!diag3] SMALLINT,
	[PROC!450!diag4] SMALLINT,
	[PROC!450!diag5] SMALLINT,
	[PROC!450!diag6] SMALLINT,
	[PROC!450!diag7] SMALLINT,
	[PROC!450!diag8] SMALLINT,
	[PROC!450!unitType] VARCHAR(2), --='UN'
	[PROC!450!units] VARCHAR(10),
	[PROC!450!charge] VARCHAR(13),
	[PROC!450!procedureType] VARCHAR(4),
	[PROC!450!procCodeType] VARCHAR(50),
	[PROC!450!procCodeName]VARCHAR(15),
	[PROC!450!description] VARCHAR(255),
	[PROC!450!serviceDate] VARCHAR(12),
	[PROC!450!serviceDateEnd] VARCHAR(12),
	[PROC!450!emergency] VARCHAR(1),
	[PROC!450!serviceLocation] VARCHAR(4),
	[PROC!450!lineControlNo] VARCHAR(50),
 
    --Defect #11325
    [PROC!450!NoteReferenceCode] VARCHAR(3),
    --[PROC!450!Note] VARCHAR(80),
	[PROC!450!Notes] VARCHAR(80),
    [PROC!450!NDC]VARCHAR(48),
	[PROC!450!NDCUnitofMeasureANSI] VARCHAR(3),		--CYS SC
 	[PROC!450!TotalTax] MONEY,
   [PROC!450!ProcID] UNIQUEIDENTIFIER,
    --CYS SC 10/22/09
    [PROC!450!ContractTypeCodeName] VARCHAR(50),
    [PROC!450!ContractTypeCodeAnsi] VARCHAR(10),

	[RENDERER!410!ID!hide] UNIQUEIDENTIFIER,	--(50),
	[RENDERER!410!PEID] UNIQUEIDENTIFIER,
	[RENDERER!410!LN] VARCHAR(50),
	[RENDERER!410!FN] VARCHAR(50),
	[RENDERER!410!MI] VARCHAR(50),
	[RENDERER!410!address1] VARCHAR(100),
	[RENDERER!410!address2] VARCHAR(100),
	[RENDERER!410!city] VARCHAR(50),
	[RENDERER!410!state] VARCHAR(10),
	[RENDERER!410!zip] VARCHAR(20),
	[RENDERER!410!dayPhone] VARCHAR(30),
	[RENDERER!410!providerTaxonomyCode] VARCHAR(15),
	[RENDERER!410!rIDType] VARCHAR(50),
	[RENDERER!410!rID] VARCHAR(50),
	[RENDERER!410!IDType] VARCHAR(50),
	[RENDERER!410!ID] VARCHAR(50),
	[RENDERER!410!CLIA] VARCHAR(50),
    [RENDERER!410!MamographyCertNo] VARCHAR(50),
	[RENDERER!410!SendCLIA] BIT,
	[RENDERER!410!SendMamographyCertNo] BIT,
	[REFERRER!420!PEID] UNIQUEIDENTIFIER,
	[REFERRER!420!PID] UNIQUEIDENTIFIER,
	[REFERRER!420!LN] VARCHAR(50),
	[REFERRER!420!FN] VARCHAR(50),
	[REFERRER!420!MI] VARCHAR(50),
	[REFERRER!420!orgName] VARCHAR(50),
	[REFERRER!420!rIDType] VARCHAR(50),
	[REFERRER!420!rID] VARCHAR(50),
	[REFERRER!420!IDType] VARCHAR(50),
	[REFERRER!420!ID] VARCHAR(50),
	[REFERRER!420!providerTaxonomyCode] VARCHAR(15),

	[SERVICEFACILITY!430!PID] UNIQUEIDENTIFIER,
	[SERVICEFACILITY!430!type] VARCHAR(50),
	[SERVICEFACILITY!430!orgName] VARCHAR(50),
	[SERVICEFACILITY!430!address1] VARCHAR(100),
	[SERVICEFACILITY!430!address2] VARCHAR(100),
	[SERVICEFACILITY!430!city] VARCHAR(50),
	[SERVICEFACILITY!430!state] VARCHAR(10),
	[SERVICEFACILITY!430!zip] VARCHAR(20),
	[SERVICEFACILITY!430!phone] VARCHAR(30),
	[SERVICEFACILITY!430!siteType] SMALLINT,
	[SERVICEFACILITY!430!PrimaryIDType] VARCHAR(50),
	[SERVICEFACILITY!430!PrimaryID] VARCHAR(50),
	[SERVICEFACILITY!430!IDType] VARCHAR(50),
	[SERVICEFACILITY!430!ID] VARCHAR(50),

	[SUBSCRIBER!200!PEID] UNIQUEIDENTIFIER,
	[SUBSCRIBER!200!SSN] VARCHAR(50),
	[SUBSCRIBER!200!prefix] VARCHAR(10),
	[SUBSCRIBER!200!LN] VARCHAR(50),
	[SUBSCRIBER!200!FN] VARCHAR(50),
	[SUBSCRIBER!200!MI] VARCHAR(50),
	[SUBSCRIBER!200!suffix] VARCHAR(20),
	[SUBSCRIBER!200!gender] VARCHAR(50),
	[SUBSCRIBER!200!birthdate] VARCHAR(12),
	[SUBSCRIBER!200!employer] VARCHAR(100),
	[SUBSCRIBER!200!occupation] VARCHAR(50),
	[SUBSCRIBER!200!address1] VARCHAR(100),
	[SUBSCRIBER!200!address2] VARCHAR(100),
	[SUBSCRIBER!200!city] VARCHAR(50),
	[SUBSCRIBER!200!state] VARCHAR(10),
	[SUBSCRIBER!200!zip] VARCHAR(20),
	[SUBSCRIBER!200!country] VARCHAR(2),
	[SUBSCRIBER!200!phoneNumber] VARCHAR(30),
	[SUBSCRIBER!200!rIDType] VARCHAR(50),
	[SUBSCRIBER!200!rID] VARCHAR(50),
	[SUBSCRIBER!200!IDType] VARCHAR(50),
	[SUBSCRIBER!200!ID] VARCHAR(50),
	[SUBSCRIBER!200!payerResponsibility] VARCHAR(4),
	[SUBSCRIBER!200!DisplayOrder] SMALLINT,
	[SUBSCRIBER!200!groupID] VARCHAR(50),
	[SUBSCRIBER!200!groupName] VARCHAR(50),
	[SUBSCRIBER!200!isWCC] BIT,					-- by SM for WCC handling

	[RESPONSIBLEPARTY!240!ID!hide] UNIQUEIDENTIFIER,
	[RESPONSIBLEPARTY!240!PEID] UNIQUEIDENTIFIER,			--Added by AW for 2010BC loop  2006 03 15
	[RESPONSIBLEPARTY!240!prefix] VARCHAR(10),
	[RESPONSIBLEPARTY!240!LN] VARCHAR(50),
	[RESPONSIBLEPARTY!240!FN] VARCHAR(50),
	[RESPONSIBLEPARTY!240!MI] VARCHAR(50),
	[RESPONSIBLEPARTY!240!suffix] VARCHAR(20),
	[RESPONSIBLEPARTY!240!address1] VARCHAR(100),
	[RESPONSIBLEPARTY!240!address2] VARCHAR(100),
	[RESPONSIBLEPARTY!240!city] VARCHAR(50),
	[RESPONSIBLEPARTY!240!state] VARCHAR(10),
	[RESPONSIBLEPARTY!240!zip] VARCHAR(50),	
	[RESPONSIBLEPARTY!240!contactName] VARCHAR(50),
	[RESPONSIBLEPARTY!240!contact1String] VARCHAR(22),
	[RESPONSIBLEPARTY!240!isCorporation] BIT,
    [FINANCIALCENTER!105!FCID] UNIQUEIDENTIFIER,
	[FINANCIALCENTER!105!SubmitterID] VARCHAR(50)    	 	
)

SET @InstanceID = NEWID()

UPDATE ClaimBatch 
	SET Status =  CAST(@InstanceID AS VARCHAR(50)),
	LastModifiedDate = GetUTCDate()
WHERE ClaimBatchUid = @ClaimBatchuid 
		AND (Status IS NULL OR Status = 'Exporting')

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]
)
SELECT
	100 AS tag,
	NULL AS parent,
	NULL 					AS [SITE!100!PID],
	@ClaimBatchuid				AS [SITE!100!eClaimBatchGUID],
	claimSubmitter.claimSubmitterUid	AS [SITE!100!claimSubmitterID!hide],
	claimSubmitter.PayToServiceSiteUid	AS [SITE!100!payToAddressID!hide]
FROM  claimSubmitter, ClaimBatch
	WHERE ClaimBatch.Status = CAST(@InstanceID AS VARCHAR(50))

EXEC AR_genXMLClaims_Inst_CLAIM @ClaimBatchuid, @claimsFetched = @claimsFetched OUTPUT


IF(@claimsFetched > 0)
BEGIN

	EXEC AR_genXMLClaims_FINANCIALCENTER

	EXEC AR_genXMLClaims_Inst_PROVIDER

	EXEC AR_genXMLClaims_Inst_BILLINGPROVIDER

	EXEC AR_genXMLClaims_Inst_PAYTOPROVIDER

	EXEC AR_genXMLClaims_Inst_ATTENDING

	EXEC AR_genXMLClaims_Inst_SUPERVISING

	EXEC AR_genXMLClaims_Inst_OPERATING

	EXEC AR_genXMLClaims_Inst_SUBSCRIBER

	EXEC AR_genXMLClaims_Inst_PATIENT

	EXEC AR_genXMLClaims_Inst_PAYER
		
	EXEC AR_genXMLClaims_Inst_RESPONSIBLEPARTY

	EXEC AR_genXMLClaims_Inst_PROC

	--****************************************
	-- Rolls Up The Revenue Codes
	EXEC AR_genXMLClaims_Inst_PROC_MA
	--****************************************
	
	EXEC AR_genXMLClaims_Inst_REFERRER
			
	EXEC AR_genXMLClaims_Inst_RENDERER
			
	EXEC AR_genXMLClaims_Inst_SERVICEFACILITY
			    
	EXEC AR_genXMLClaims_Inst_COB
	
	EXEC AR_genXMLClaims_Inst_CLAIM_UB @ClaimBatchuid		-- , @claimsFetched = @claimsFetched OUTPUT			

	SET NOCOUNT OFF


--SCOTT TEST
/*
SELECT
	*
	FROM #XMLClaims_temp
	ORDER BY
    	[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
    	[FINANCIALCENTER!105!FCID],
		[PROVIDER!110!PID],		--CYS SC 11/03/08
		[RENDERER!410!ID!hide],
		[SUBSCRIBER!200!PEID],
		[PATIENT!300!PEID],
		[CLAIM!400!PID],
		[PROC!450!count],
		parent,
		tag
		*/
--SCOTT TEST



	SELECT
	*
	FROM #XMLClaims_temp
	ORDER BY
    	[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
    	[FINANCIALCENTER!105!FCID],
		[PROVIDER!110!PID],		--CYS SC 11/03/08
		[RENDERER!410!ID!hide],
		[SUBSCRIBER!200!PEID],
		[PATIENT!300!PEID],
		[CLAIM!400!PID],
		[PROC!450!count],
		parent,
		tag
	FOR XML EXPLICIT

END
ELSE
BEGIN
	SELECT
	*
	FROM #XMLClaims_temp
	ORDER BY
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
    [FINANCIALCENTER!105!FCID],
	[PROVIDER!110!PID],		--CYS SC 11/03/08
	[RENDERER!410!ID!hide],
	[SUBSCRIBER!200!PEID],
	[PATIENT!300!PEID],
	[CLAIM!400!PID],
	[PROC!450!count],
	parent,
	tag
	
	FOR XML EXPLICIT
END


DROP TABLE #XMLClaims_temp

COMMIT TRANSACTION








GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GenXMLClaims_SubRecInfo]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_GenXMLClaims_SubRecInfo] AS' 
END
GO



-- 50570 dsw 2016-07-25 Getting duplicate submission numbers for multiple clearinghouses

ALTER PROC [dbo].[AR_GenXMLClaims_SubRecInfo]

@claimbatchUid UNIQUEIDENTIFIER

AS
/*
Purpose: This SP is used to return Submitter & Receiver information to the .net based code.
	It is implemented to remove the App.Config file based hard coding.
Created On: 20050701
Modified On: 20060419
Modifications Made:	
	Modified for handling the MultipleClearinghouse conditions.
	-- Bug 59421:Not all claims are not going to Practice Insight and are staying in Filed Status
	-- Bug 59610:Submission number issue with NEW database and first claims submission to PI

Special Comment: Data is returned in XML format only.
	For Beta 2 hard coded values are returned as Interface for clearinghouse etc is not ready.
	
Structure:
	<SUBMITTER
		OrgName
		IdType
		Id
		Contactname
		Contact1Type
		Contact1String
		Contact2Type
		Contact2String
	/>

	<RECEIVER
		orgName
		IdType
		Id
	/>

*/



SET NOCOUNT ON

	DECLARE @ClaimFormatValueTypeUid UNIQUEIDENTIFIER
	DECLARE @ClaimClearinghouseUid UNIQUEIDENTIFIER
	DECLARE @BillingProviderUid UNIQUEIDENTIFIER     
    DECLARE @FinancialCenterUid VARCHAR(50) 
    DECLARE @ClaimFormatTypeUid UNIQUEIDENTIFIER 
	DECLARE @ClaimFormatSubmitterID VARCHAR(255)	
	DECLARE @ClearingHouseSubmitterID VARCHAR(255)

-- 59421 -- determine correct submission number for claim
--          move away from uwing pluginsettings to store submission number
	DECLARE @submissionNumber int
	BEGIN TRAN
		select @submissionNumber = max(coalesce(cb.submissionNumber,0)) + 1 FROM ClaimBatch cb
		UPDATE Claimbatch 
			SET SubmissionNumber = @submissionNumber,
			LastModifiedDate = GetUTCDate()
		WHERE ClaimbatchUid = @claimbatchUid
	COMMIT TRAN

-- 59421 , move away from using submission number in pluginsettings, but set for legacy code which might use
	UPDATE PluginSettings SET Value = @submissionNumber + 1 WHERE ClaimClearingHouseUid = @ClaimClearinghouseUid AND Name LIKE 'SubmissionNumber'


	SELECT @ClaimFormatValueTypeUid = ClaimFormatValueTypeUid,  -- ClaimFormatValueType for clearinghouse
		@ClaimClearinghouseUid = LCCH.ClaimClearingHouseUid,
		@BillingProviderUid = CB.BillingProviderUid,
		@ClaimFormatTypeUid = CB.ClaimFormatTypeUid
		FROM ListClaimClearinghouse LCCH 
		INNER JOIN ClaimBatch CB ON CB.ClaimClearingHouseUid = LCCH.ClaimClearingHouseUid
		WHERE CB.ClaimbatchUid = @claimbatchUid
/*As for the Submission Number there is no UI it is possible that SubmissionNumber for a ClearingHouse will be absent
The SubmissionNumber is required for Claimbatch, So if it is not exists insert it as 1. Then onwards it will increment*/
	IF NOT EXISTS (SELECT TOP 1 Value FROM PluginSettings WHERE ClaimClearingHouseUid = @ClaimClearinghouseUid AND Name LIKE 'SubmissionNumber')
		INSERT INTO PluginSettings(ClaimClearingHouseUid, Name, Value) VALUES (@ClaimClearinghouseUid, 'SubmissionNumber', @submissionNumber)
      
    SELECT @FinancialCenterUid=ViewSuperbillFinancialDetails.FinancialCenterUid FROM ClaimBatch cb INNER JOIN ClaimBatchDetail cbd ON cb.ClaimBatchUid= cbd.ClaimBatchUid 
           INNER JOIN Superbill s ON cbd.SuperbillUid=s.SuperbillUid
           INNER JOIN ViewSuperbillFinancialDetails on ViewSuperbillFinancialDetails.SuperbillUid = s.SuperbillUid
            WHERE cb.ClaimbatchUid = @claimbatchUid
     -- 
	SET @ClaimFormatSubmitterID=''
	SET @ClaimFormatSubmitterID=dbo.UDF_CheckFor1000A(@claimbatchUid) -- Retrieves from Claim format
	
	SET @ClearingHouseSubmitterID=''
    SET @ClearingHouseSubmitterID=CASE ISNULL(@FinancialCenterUid,'') 
										WHEN '' 
										THEN ISNULL(dbo.UDF_getFormatVaribleValue (1, @ClaimFormatValueTypeUid, NULL, @BillingProviderUid, NULL, NULL, NULL, NULL), '')  
										ELSE ISNULL(dbo.UDF_getFormatVaribleValue (1, @ClaimFormatValueTypeUid, NULL, @BillingProviderUid, NULL, NULL, NULL, @FinancialCenterUid), '')
								   END --as [SUBMITTER!1!ElectonicSubmitterID],
	

	SELECT 1 as Tag,
		NULL as Parent,
		Name as [SUBMITTER!1!orgName],
		'46' as [SUBMITTER!1!IDType],
		
		--CASE ISNULL(@SubmitterID,'') WHEN '' THEN	--Amit	 
  --            ISNULL(dbo.UDF_getFormatVaribleValue (1, @ClaimFormatValueTypeUid, NULL, @BillingProviderUid, NULL, NULL, NULL, NULL), '')			  
  --          ELSE
		--	  ISNULL(@SubmitterID,'') END as [SUBMITTER!1!ID],
		@ClaimFormatSubmitterID as [SUBMITTER!1!ID],
       
		--ISNULL(dbo.UDF_getFormatVaribleValue (1, @ClaimFormatValueTypeUid, NULL, @BillingProviderUid, NULL, NULL, NULL), '')  as [SUBMITTER!1!ID],
		--dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,NULL,NULL) as [SUBMITTER!1!ID],
		PS.Name as [SUBMITTER!1!contactName],					--'Jason White'
		'TE' as [SUBMITTER!1!contact1Type],
			dbo.stripSpecialChars(PS.MainPhone.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) as [SUBMITTER!1!contact1String],			--'4084943004'
		(CASE WHEN @ClaimClearinghouseUid = 'FB2DEAB7-78CB-4771-8AC2-95FEF6F7A19A' OR @ClaimClearinghouseUid = '7FE0D2AB-FF21-4258-819E-7C7C1B26EF5E' THEN
			'ED'
		 ELSE
			'' END)as [SUBMITTER!1!contact2Type],			--'EM'
		(CASE WHEN @ClaimClearinghouseUid = 'FB2DEAB7-78CB-4771-8AC2-95FEF6F7A19A' OR @ClaimClearinghouseUid = '7FE0D2AB-FF21-4258-819E-7C7C1B26EF5E' THEN
			'V07194'
		 ELSE
		    '' END)as [SUBMITTER!1!contact2String],			--'jwhite@juel.com'
  
		-- Financial center so need the claim format one here.  This is the claimFormatSubmitterID
     --   CASE ISNULL(@FinancialCenterUid,'') WHEN '' THEN
		   --ISNULL(dbo.UDF_getFormatVaribleValue (1, @ClaimFormatValueTypeUid, NULL, @BillingProviderUid, NULL, NULL, NULL, NULL), '')  
     --     ELSE
     --      ISNULL(dbo.UDF_getFormatVaribleValue (1, @ClaimFormatValueTypeUid, NULL, @BillingProviderUid, NULL, NULL, NULL, @FinancialCenterUid), '')
     --   END as [SUBMITTER!1!ElectonicSubmitterID],
		@ClearingHouseSubmitterID as [SUBMITTER!1!ElectonicSubmitterID],
        PS.CalculateTax as   [SUBMITTER!1!CalculateTax]   
        
		FROM PracticeSettings PS
		
	FOR XML EXPLICIT

	SELECT 2 as Tag,
		NULL as Parent,
		OrganizationName as [RECEIVER!2!orgName],
		'46' as [RECEIVER!2!IDType],
		ReceiverID as [RECEIVER!2!ID],
		ReceiverID as [RECEIVER!2!ReceiverID]
		--dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,NULL,NULL)as [RECEIVER!2!ID]
	FROM ListClaimClearinghouse WHERE ClaimClearinghouseUid = @ClaimClearinghouseUid
	FOR XML EXPLICIT

	SELECT TOP 1 
		3 AS Tag,
		NULL AS Parent,
		LCCH.ClaimClearingHouseUid 	AS [CLEARINGHSGSETTINGS!3!ClaimClearingHouseUid],
		LCCH.Name 			AS [CLEARINGHSGSETTINGS!3!ClaimClearingHouseName],
		CB.BillingProviderUid		AS [CLEARINGHSGSETTINGS!3!BillingProviderUid],
		CASE WHEN LCCH.ConnectionType IS NULL THEN ISNULL(LCCH.ClaimCreatorAQN, 'EDI837Creator.PerSe_Creator, EDI837Creator')
		     WHEN LCCH.ConnectionType = 'AprimaVault' THEN 'EDI837Creator.CorepointCreator,EDI837Creator'
			 WHEN ( @ClaimFormatTypeUid = 'F1DA9C15-39BA-49C0-AE4F-C6311CFA5D98' ) THEN 'CySolutions.CHCApplicationServer.I837Creator_MedicareA, EDI837Creator' -- CHC Specific
		     ELSE ISNULL(LCCH.ClaimCreatorAQN, 'EDI837Creator.PerSe_Creator, EDI837Creator') END AS [CLEARINGHSGSETTINGS!3!ClaimCreatorAQN],
		PS.Value			AS [CLEARINGHSGSETTINGS!3!SubmissionMode],
		@submissionNumber   AS [CLEARINGHSGSETTINGS!3!TransactionID], -- 59421
--		ISNULL(PS1.Value, 1)			AS [CLEARINGHSGSETTINGS!3!TransactionID],
		ISNULL(PS2.Value, '')			AS [CLEARINGHSGSETTINGS!3!TestLoginID],
		ISNULL(PS3.Value, '')			AS [CLEARINGHSGSETTINGS!3!LoginID]
		FROM Claimbatch CB 
		INNER JOIN ListClaimClearingHouse LCCH ON CB.ClaimClearingHouseUid = LCCH.ClaimClearingHouseUid 
		LEFT JOIN PluginSettings PS ON PS.ClaimClearingHouseUid = LCCH.ClaimClearingHouseUid AND PS.Name LIKE 'SubmissionMode'
--		LEFT JOIN PluginSettings PS1 ON PS1.ClaimClearingHouseUid = LCCH.ClaimClearingHouseUid AND PS1.Name LIKE 'SubmissionNumber'
		LEFT JOIN PluginSettings PS2 ON PS2.ClaimClearingHouseUid = LCCH.ClaimClearingHouseUid AND PS2.Name LIKE 'TestFTPUsername'
		LEFT JOIN PluginSettings PS3 ON PS3.ClaimClearingHouseUid = LCCH.ClaimClearingHouseUid AND PS3.Name LIKE 'FTPUsername'
		WHERE ClaimbatchUid = @claimbatchUid
	FOR XML EXPLICIT

 
	SET NOCOUNT OFF












GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetGLDates]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_GetGLDates] AS' 
END
GO



ALTER PROC [dbo].[AR_GetGLDates]
	@GLDateStart DATE output,
	@GLDateEnd DATE output
AS
BEGIN
	declare @currentPeriodEnd datetime, @tempDate datetime

	select top 1 @currentPeriodEnd = currentPeriodEnd from PracticeSettings

	if (@GLDateStart > @GLDateEnd) -- Start date should always be before End Date!
	BEGIN
		set @tempDate = @GLDateStart
		set @GLDateStart = @GLDateEnd
		set @GLDateEnd = @GLDateStart		
	END

	if (@GLDateStart is null and @GLDateEnd is null) -- Then we assume that they want us to setup everything and we'll use the current period
	BEGIN
		set @GLDateEnd = @currentPeriodEnd
	END

	if(@GLDateStart is null) -- Just default it to one month before the @GLDateStart
	BEGIN
		set @GLDateStart = dateAdd(mm, -1, @GLDateEnd)

		--set @glDate = dbo.PAFN_getTimelessDate(getDate()) -- Start with today
		--if (@glDate >= @currentPeriodEnd) -- JW 6/2, This covers the case where they haven't closed the current month and they want to see statistics for the currently open period (not next month which is empty).
		--	set @glDateEnd = @currentPeriodEnd
	END

	if(@GLDateEnd is null) -- Just default it to one month before the @GLDateStart
	BEGIN
		set @GLDateEnd = dateAdd(mm, 1, @GLDateStart)
	END

	-- This just gets the times right so if we're doing a datetime compare everything is ok.
	set @GLDateStart = @GLDateStart
	set @GLDateEnd = @GLDateEnd

END

		





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetViewARBatchFromBatchFilter]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_GetViewARBatchFromBatchFilter] AS' 
END
GO



ALTER PROCEDURE [dbo].[AR_GetViewARBatchFromBatchFilter]
(
	@arbatchFilterXml XML
)

AS
BEGIN

	/*
	DBCC DROPCLEANBUFFERS
	DBCC FREEPROCCACHE 

	DECLARE @arbatchFilterXml XML
	SET @arbatchFilterXml = (SELECT TOP 10 ARBatchUid FROM ARBatch WHERE Name LIKE '%7%' FOR XML RAW('ARBatch'), ROOT('ARBatches'))
	SELECT x.n.value ('@ARBatchUid', 'UNIQUEIDENTIFIER') AS ArBatchUid
			FROM @arbatchFilterXml.nodes('ARBatches/ARBatch') AS x(n)
	EXEC AR_GetViewARBatchFromBatchFilter @arbatchFilterXml

	SELECT * FROM ViewARBatch WHERE ARBatchUid IN (SELECT ARBatchUid FROM ARBatch WHERE Islocked = 0) 
	*/

	SELECT 'ViewARBatch'

	SELECT x.n.value ('@ARBatchUid', 'UNIQUEIDENTIFIER') AS ArBatchUid
		INTO #arBatchFilter
			FROM @arbatchFilterXml.nodes('ARBatches/ARBatch') AS x(n)

	SELECT L.ARBatchUid, ARB.GLDate AS PostingDate, LD.DepositUid, LD.PayerCreditUid, LD.SuperbillProcedureUid,
			LD.Amount, L.EntryType, LD.IsCredit  
		INTO #cteVLS
		FROM AR_LedgerDetail LD 
			INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
			INNER JOIN ARBatch ARB ON L.ARBatchUid = ARB.ArBatchUid
		WHERE L.ARBatchUid IN (SELECT	ARBatchUid FROM #arBatchFilter)
			AND L.EntryType IN (0,1,4) 
			AND (NOT LD.DepositUid IS NULL OR NOT LD.PayerCreditUid IS NULL OR NOT LD.SuperbillProcedureUid IS NULL)
			
	SELECT VLS.ArBatchUid,
			COUNT(DISTINCT VLS.DepositUid) AS DepositCount,
			SUM(VLS.Amount) as DepositAmount,  
			SUM(VDA.Receipt - VDA.ReceiptBalance) as DepositAllocatedAmount  
		INTO #cteDeposit
		FROM #cteVLS VLS 
			INNER JOIN AR_ViewDepositAggregate VDA ON VLS.DepositUid = VDA.DepositUid 
		WHERE VLS.EntryType = 0 -- payment
			AND VLS.IsCredit = 1
			AND NOT VLS.DepositUid IS NULL 
		GROUP BY VLS.ArBatchUid   

	SELECT VLS.ArBatchUid, -- PayerCredits can have multiple Ledger Entries.  Only get 1st entry based on batch, payer credit
		   VLS.PayerCreditUid,
		   Row_Number() OVER (PARTITION BY VLS.ArBatchUid, VLS.PayerCreditUid ORDER BY vls.PostingDate desc) as apcCount
		INTO #ctePayerCreditSub
		FROM #cteVLS VLS
		WHERE VLS.EntryType = 0 -- payment
			AND VLS.IsCredit = 1
			AND NOT VLS.PayerCreditUid IS NULL

	SELECT mbc.ArBatchUid, mbc.PayerCreditUid, VPCA.Receipt, VPCA.ReceiptBalance
		INTO #ctePayerCreditSubWithBalances
		FROM #ctePayerCreditSub mbc
			INNER JOIN AR_ViewPayerCreditAggregate VPCA ON mbc.PayerCreditUid = VPCA.PayerCreditUid	
		where mbc.apcCount = 1 -- strip out the duplicates of batch/pc

	SELECT mbc.ArBatchUid, 
		   COUNT(mbc.ArBatchUid) as PayerCreditCount,
		   SUM(-mbc.Receipt) as PayerCreditAmount,
		   SUM(mbc.Receipt  - mbc.ReceiptBalance) as PayerCreditAllocatedAmount
		INTO #ctePayerCredit
		FROM #ctePayerCreditSubWithBalances mbc
		GROUP BY mbc.ArBatchUid

	SELECT VLS.ARBatchUid,
			   SBP.SuperbillUid, 
			   sum(VLS.Amount) AS SuperbillTotalAmount
		  INTO #cteSuperbillSub
		  FROM #cteVLS  VLS 
				inner join dbo.SuperbillProcedure SBP ON VLS.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		  WHERE NOT VLS.SuperbillProcedureUid IS NULL
				AND  (VLS.EntryType = 1 OR VLS.EntryType = 4) -- Charge/Transfer
				AND ((VLS.EntryType <> 4 AND VLS.IsCredit = 0) OR (VLS.EntryType = 4)) -- the Charge/Transfer side (include BOTH sides on a Transfer)
		  GROUP BY VLS.ARBatchUid, SBP.SuperbillUid


	SELECT ARBatchUid,
		   count( distinct SuperbillUid) as SuperbillCount,
		   sum(SuperbillTotalAmount) as SuperbillTotalAmount
		INTO #cteSuperbill
		FROM #cteSuperbillSub 
		GROUP BY ARBatchUid

	SELECT      
		ARB.ARBatchUid,      
		ARB.ExternalID,      
		ARB.Name,      
		ARB.Inactive,      
		ARB.Notes,      
		ARB.LastModifiedDate,      
		ARB.LastModifiedByUid,      
		ARB.GLDate,      
		ARB.IsLocked,    
		ARBC.IsClosed,
		CASE ARBC.IsClosed 
			WHEN 1 THEN 'Closed'
			ELSE CASE ARB.IsLocked WHEN 1 THEN 'Completed' ELSE 'Open' END
		END AS [Status],
		CAST(CASE ARBC.IsClosed 
			WHEN 1 THEN 3
			ELSE CASE ARB.IsLocked WHEN 1 THEN 2 ELSE 1 END
		END AS [SmallInt]) AS [ARBatchState], -- Maps to ARBatchStateEnum
		ARB.OwnerUid,  
		p.FormattedName as OwnerName,  
		isNull(d.DepositCount,0) as DepositCount,          
		isNull(0 - d.DepositAmount,0) as DepositAmount,
		ISNULL(d.DepositAllocatedAmount,0) as DepositAllocatedAmount,      
		(0 - (isNull(d.DepositAmount,0) + isNull(d.DepositAllocatedAmount,0))) as DepositUnallocatedAmount,          
		isNull(pc.PayerCreditCount,0) as PayerCreditCount,          
		isNull(0 - pc.PayerCreditAmount,0) as PayerCreditAmount,
		ISNULL(pc.PayerCreditAllocatedAmount,0) as PayerCreditAllocatedAmount,      
		(0 - (isNull(pc.PayerCreditAmount,0) + isNull(pc.PayerCreditAllocatedAmount,0))) as PayerCreditUnallocatedAmount,          
		isNull(sb.SuperbillCount,0) as SuperbillCount,          
		isNull(sb.SuperbillTotalAmount,0) as SuperbillTotalAmount          
	FROM ARBatch ARB 
		INNER JOIN #arBatchFilter BF ON ARB.ARBatchUid = BF.ARBatchUid   
		INNER JOIN AR_ViewBatchClosingsLockedClosed ARBC ON ARB.ARBatchUid = ARBC.ArBatchUid     
		LEFT JOIN #cteDeposit d ON d.ARBatchUid = ARB.ARBatchUid     
		LEFT JOIN #ctePayerCredit pc ON pc.ARBatchUid = ARB.ARBatchUid        
		LEFT JOIN #cteSuperbill sb ON  sb.ARBatchUid = ARB.ARBatchUid  
		LEFT JOIN ViewPerson (NOEXPAND) p ON ARB.OwnerUid = p.PersonUid 

	DROP TABLE #cteSuperbill
	DROP TABLE #cteSuperbillSub 
	DROP TABLE #ctePayerCredit
	DROP TABLE #ctePayerCreditSubWithBalances
	DROP TABLE #ctePayerCreditSub
	DROP TABLE #cteDeposit
	DROP TABLE #cteVLS
	DROP TABLE #arBatchFilter

END



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_InsertSBNote]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_InsertSBNote] AS' 
END
GO

ALTER PROC [dbo].[AR_InsertSBNote]
	@SuperbillUid uniqueidentifier, 
	@Note varchar(255), 
	@UserUid uniqueidentifier 
AS
BEGIN
	/*	Adds an informational superbill note to the superbill history.
		Duplicates functionality in the business object Superbill method AddSuperbillNote,
		used in process method of Client.UI.DailyUpdate.ControlTrackSuperbillHistoryFilter.cs

		For use in migration and audit scripts, such as the stored proc 
		AR_AuditSBStatus, for example.
	*/
	set nocount on

	declare @eReportDetailUid uniqueidentifier, @PatientUid uniqueidentifier, @ReviewedStatusUid uniqueidentifier
	set @eReportDetailUid = newid()
	select @PatientUid = PatientUid from Superbill where SuperbillUid = @SuperbillUid
	if (@@rowcount = 0)
		begin
			raiserror('Superbill not found', 18, 1)
			return
		end

	select @ReviewedStatusUid = ClaimReportStatusUid from ListClaimReportStatus where ClaimReportStatusUid = '00000000-0000-0000-0000-000000000011'
	if (@@rowcount = 0)
		begin
			raiserror('Reviewed claim report status not found', 18, 1)
			return
		end

	if (@UserUid is not null and not exists (select * from UserPRM where PersonUid = @UserUid))
		begin
			raiserror('User not found', 18, 1)
			return
		end

	insert into eReportDetails (eReportDetailUid, importDate, reportNumber, totalCharge, totalClaims, LastModifiedByUid)
	values (@eReportDetailUid, getutcdate(), 'SB Note', 0, 0, @UserUid)

	insert into eReportRows (eReportDetailUid, ClaimReportStatusUid, superbillUid, patientUid, errorDescription, LastModifiedByUid)
	values (@eReportDetailUid, @ReviewedStatusUid, @SuperbillUid, @PatientUid, @Note, @UserUid)

END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SetBatchIsClosedAggregate]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SetBatchIsClosedAggregate] AS' 
END
GO



ALTER PROCEDURE [dbo].[AR_SetBatchIsClosedAggregate] 
AS

SELECT TOP 1 ISNULL(SystemFinancialsCloseThruDate, '01/01/1901') AS SystemFinancialsCloseThruDate
     INTO #systemCloseDate
     FROM PracticeSettings

SELECT L.ArBatchUid, LD.FinancialCenterUid, ARB.GLDate, FC.ARClosedThroughDate
     INTO #financialCenterRelations       
     FROM dbo.AR_LedgerDetail LD              
          INNER JOIN dbo.AR_Ledger L ON LD.LedgerUid = L.LedgerUid              
          INNER JOIN dbo.FinancialCenter FC ON LD.FinancialCenterUid = FC.FinancialCenterUid              
          INNER JOIN dbo.ARBatch ARB ON L.ArBatchUid = ARB.ARBatchUid        
     WHERE NOT LD.FinancialCenterUid IS NULL        
     GROUP BY L.ArBatchUid, LD.FinancialCenterUid, ARB.GLDate, FC.ARClosedThroughDate 

SELECT VBFCR.ArBatchUid, VBFCR.FinancialCenterUid,  
          CASE WHEN ISNULL(VBFCR.ARClosedThroughDate, '01/01/1901') >= PS.SystemFinancialsCloseThruDate 
          THEN ISNULL(VBFCR.ARClosedThroughDate, '01/01/1901') ELSE PS.SystemFinancialsCloseThruDate END AS ARClosedThroughDate
     INTO #fcr
     FROM #financialCenterRelations  VBFCR
          INNER JOIN (SELECT SystemFinancialsCloseThruDate FROM #systemCloseDate) PS ON 1=1

SELECT ARB.ArBatchUid, ARB.Name, ARB.IsLocked, ARB.GLDate, FCR.FinancialCenterUid, 
          COALESCE(FCR.ARClosedThroughDate, PS.SystemFinancialsCloseThruDate) AS ARClosedThroughDate,
          ROW_NUMBER() OVER (PARTITION BY ARB.ArBatchUid ORDER BY FCR.ARClosedThroughDate DESC) AS Row,
          (SystemFinancialsCloseThruDate) AS SystemCloseDate
     INTO #iv
     FROM ARBatch ARB
          INNER JOIN (SELECT SystemFinancialsCloseThruDate FROM #systemCloseDate) PS ON 1=1
          LEFT JOIN #fcr FCR ON ARB.ARBatchUid = FCR.ARBatchUid

SELECT DISTINCT IV.ArBatchUid, IV.Name AS ArBatchName, IV.GlDate, IV.IsLocked,  
              CAST(CASE WHEN IV.GLDate IS NULL OR 
                   IV.ARClosedThroughDate IS NULL OR
                   IV.GLDate > IV.ARClosedThroughDate 
                   THEN 0 ELSE 1 END AS BIT) AS IsClosed
      INTO #aggregatedBatchInfo
      FROM #iv IV
      WHERE IV.Row = 1;

DISABLE TRIGGER ALL ON ARBatch; -- BMR 2016-11-03 - No Need to Protect the change here

UPDATE ARBatch SET IsClosed = 1
     WHERE IsClosed = 0
          AND ARBatchUid IN (SELECT ARBatchUid FROM #aggregatedBatchInfo WHERE IsClosed = 1);

ENABLE TRIGGER ALL ON ARBatch; -- BMR 2016-11-03 - No Need to Protect the change here

	/*
	DBCC DROPCLEANBUFFERS
	DBCC FREEPROCCACHE 

	EXEC AR_SetBatchIsClosedAggregate
	*/



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_LoadFinancialCenterClosingSummary]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_LoadFinancialCenterClosingSummary] AS' 
END
GO



ALTER PROC [dbo].[AR_LoadFinancialCenterClosingSummary]
	  @financialCenterClosingSummaryUid UNIQUEIDENTIFIER = '00000000-0000-0000-0000-000000000000', -- default to none if so gen first thing
      @arCloseThroughDate DATETIME = NULL, -- if not set, will simply do a load, if set, will attempt to close the selected financial centers on the noted date
      @financialCenterUids VARCHAR(8000) = '', -- can use to adjust blocking on load based upon what is 'checked'
      @arBatchUids VARCHAR(8000) = '' -- used for individual batch completions if @arCloseThroughDate and @financialCenterUids not selected
AS
BEGIN

	  DECLARE @completeOnly INT = 0; -- may be able to remove
      DECLARE @guidEmpty UNIQUEIDENTIFIER = '00000000-0000-0000-0000-000000000000';

	  IF (@financialCenterClosingSummaryUid = @guidEmpty)
		SET @financialCenterClosingSummaryUid = NEWID();
      
      -- fix up to be a date only (12:00)
      SELECT @arCloseThroughDate = CAST(CONVERT(VARCHAR, @arCloseThroughDate, 101) + ' 12:00:00' AS DATETIME)

      SELECT Element AS FinancialCenterUid
            INTO #tempFinancialCentersSelected
            FROM dbo.Split(@financialCenterUids,',')
      -- SELECT * FROM #tempFinancialCentersSelected

	  /* Use for debug
      SELECT FinancialCenterUid
            INTO #tempFinancialCentersSelected
            FROM FinancialCenter
	  INSERT INTO #tempFinancialCentersSelected
		SELECT @guidEmpty
	  */
      
	  -- BUG 44879 Performance Enhancement 
      SELECT CAST(Element AS UNIQUEIDENTIFIER) AS ARBatchUid
            INTO #tempARBatchesSelected
            FROM dbo.Split(@arBatchUids,',')
       IF (@arBatchUids='')
       BEGIN
          INSERT INTO #tempARBatchesSelected (ARBatchUid)
              SELECT ArBatchUid FROM AR_ViewBatchClosingsLockedClosed
                   WHERE IsClosed = 0
       END
      -- SELECT * FROM #tempARBatchesSelected

	  	-- BUG 44879 Performance Enhancement      
		CREATE CLUSTERED INDEX [IX_tempARBatchesSelected] ON #tempARBatchesSelected
		(
			[ArBatchUid] ASC
		);

      SELECT ISNULL(VLE.FinancialCenterUid,'00000000-0000-0000-0000-000000000000') AS FinancialCenterUid, 
                     ISNULL(VLE.FinancialCenterName,'System') AS FinancialCenterName,
                     VLE.ArBatchUid, VLE.PostingDate AS ARBatchGlDate,
                  VLE.ArBatchName, VLE.SuperbillUid, VLE.ExternalID AS SuperbillExternalId, 
                  VSA.Liability AS SuperbillLiability, VSA.LiabilityBalance AS SuperbillLiabilityBalance, 
                  VLE.DepositUid, ISNULL(VLE.DepositReferenceNumber,'(NA)') AS DepositReferenceNumber, 
                  ISNULL(VDA.Receipt,0) AS DepositReceipt, ISNULL(VDA.ReceiptBalance,0) AS DepositReceiptBalance,
                  VLE.PayerCreditUid, VLE.PayerCreditNote,
                  ISNULL(VPCA.Receipt,0) AS PayerCreditReceipt, ISNULL(VPCA.ReceiptBalance,0) AS PayerCreditReceiptBalance,
                  CAST(0 AS INT) AS Blocking
            INTO #tempFinancialCenterClosingSummaryDetail
            FROM AR_ViewLedgerExtended VLE 
                     INNER JOIN #tempARBatchesSelected BS ON VLE.ArBatchUid = BS.ARBatchUid
                     LEFT JOIN AR_ViewSuperbillAggregate VSA WITH (NOLOCK) ON VLE.SuperbillUid = VSA.SuperbillUid
                  LEFT JOIN AR_ViewDepositAggregate VDA WITH (NOLOCK) ON VLE.DepositUid = VDA.DepositUid
                  LEFT JOIN AR_ViewPayerCreditAggregate VPCA WITH (NOLOCK) ON VLE.PayerCreditUid = VPCA.PayerCreditUid
                  INNER JOIN AR_ViewBatchClosingsLockedClosed VBCLC WITH (NOLOCK) ON VLE.ARBatchUid = VBCLC.ArBatchUid
            WHERE  VBCLC.IsClosed = 0 AND NOT -- filter OUT already closed and filter OUT LockBox, Income, and Expense
                  ((VLE.EntryType=0 AND VLE.IsCredit=0) OR (VLE.EntryType=1 AND VLE.IsCredit=1) OR (VLE.EntryType=3 AND VLE.IsCredit=0))
            GROUP BY VLE.FinancialCenterUid, VLE.FinancialCenterName, VLE.ArBatchUid, VLE.PostingDate, VLE.ArBatchName, VLE.SuperbillUid, 
                                    VLE.ExternalID, VSA.Liability, VSA.LiabilityBalance, 
									VLE.DepositUid, VLE.DepositReferenceNumber, VLE.DepositUid, VDA.Receipt, VDA.ReceiptBalance,
									VLE.PayerCreditUid, VLE.PayerCreditNote, VPCA.Receipt, VPCA.ReceiptBalance, 
									VLE.EntryType, VLE.TransactionReferenceNumber, VLE.ReferenceDescription
		
		-- BUG 44879 Performance Enhancement 
		CREATE CLUSTERED INDEX [IX_tempFinancialCenterClosingSummaryDetail] ON #tempFinancialCenterClosingSummaryDetail
		(
			[ArBatchUid] ASC
		);

      -- SELECT 'All', * FROM #tempFinancialCenterClosingSummaryDetail

      UPDATE #tempFinancialCenterClosingSummaryDetail 
            SET Blocking = 1
            WHERE ISNULL(DepositReceiptBalance,0) <> 0 -- blocked by undistributed deposits
      -- SELECT 'All', * FROM #tempFinancialCenterClosingSummaryDetail where Blocking = 1
      
       IF (NOT EXISTS(SELECT * FROM #tempARBatchesSelected)) -- can not 'cross block' on a complete since FC is not included
      BEGIN
            UPDATE #tempFinancialCenterClosingSummaryDetail
                        SET Blocking = 1
                        FROM #tempFinancialCenterClosingSummaryDetail FCCSD
                             INNER JOIN (SELECT ArBatchUid, FinancialCenterName FROM #tempFinancialCenterClosingSummaryDetail 
                                                WHERE NOT FinancialCenterUid IN (SELECT FinancialCenterUid FROM #tempFinancialCentersSelected 
                                                UNION SELECT @guidEmpty)) BLOCK ON FCCSD.ArBatchUid = BLOCK.ArBatchUid
                  WHERE Blocking = 0  -- Pure deposits (@guidEmpty), will never block in this way across batches
                  -- arbatch part deals with this ... I want all batches, not associated with the financial centers to close ... these will block
                  -- catches where a batch is in more than one FC and one FC is not closing in this session
      END
      --SELECT 'Blocking', * FROM #tempClosingData WHERE Blocking = 1
                        
       UPDATE #tempFinancialCenterClosingSummaryDetail
              SET Blocking = 1
              FROM #tempFinancialCenterClosingSummaryDetail FCCSD
                   INNER JOIN (SELECT ArBatchUid FROM #tempFinancialCenterClosingSummaryDetail WHERE Blocking = 1) BLOCK ON FCCSD.ArBatchUid = BLOCK.ArBatchUid
              WHERE Blocking = 0    

          
      SELECT DISTINCT FC.FinancialCenterUid, CAST(0 AS BIT) AS EvaluatedAsSelected,  FC.ExternalID AS FinancialCenterExternalId, 
                  FC.Name AS FinancialCenterName, FC.ARClosedThroughDate, CAST(NULL AS DATETIME) AS ARCanCloseThroughDate,  
                  CAST(0 AS INT) AS AllBatchCount, CAST(0 AS INT) AS BlockingBatchCount, CAST(0 AS INT) AS AllPaymentCount, CAST(0 AS INT) AS BlockingPaymentCount,
                  CAST(0 AS MONEY) AS TotalDepositReceipt, CAST(0 AS MONEY) AS TotalDepositReceiptBalance,
                  CAST(0 AS INT) AS SuperbillCount, CAST(0 AS MONEY) AS TotalSuperbillLiability, CAST(0 AS MONEY) AS TotalSuperbillLiabilityBalance,
                  CAST(0 AS INT) AS PayerCreditCount, CAST(0 AS MONEY) AS TotalPayerCreditReceipt, CAST(0 AS MONEY) AS TotalPayerCreditReceiptBalance
			INTO #tempFinancialCenterClosingSummary
            FROM (SELECT FinancialCenterUid, ExternalID, Name, ARClosedThroughDate FROM FinancialCenter UNION -- in list + system
                        SELECT @guidEmpty, NULL, 'System', (SELECT TOP 1 SystemFinancialsCloseThruDate from PracticeSettings)) FC   
                  
      UPDATE #tempFinancialCenterClosingSummary -- set the selected flag based upon financial centers selected
            SET EvaluatedAsSelected = 1
            WHERE FinancialCenterUid IN (SELECT FinancialCenterUid FROM #tempFinancialCentersSelected)
      -- SELECT 'FC', * FROM #tempFinancialCenterClosingSummary WHERE FinancialCenterUid IS NULL
            
      UPDATE #tempFinancialCenterClosingSummary -- set CanCloseDate
			SET #tempFinancialCenterClosingSummary.ARCanCloseThroughDate = CAST(CONVERT(VARCHAR, DATEADD(d,-1,CD.CanCloseDatePlusOne), 101) + ' 12:00:00' AS DATETIME)
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT FinancialCenterUid AS FinancialCenterUid, MIN(ARBatchGlDate) AS CanCloseDatePlusOne 
                        FROM #tempFinancialCenterClosingSummaryDetail WHERE Blocking = 1 GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      UPDATE #tempFinancialCenterClosingSummary -- set CanCloseDate where no blocking
            SET ARCanCloseThroughDate = CAST(CONVERT(VARCHAR, GETDATE(), 101) + ' 12:00:00' AS DATETIME)
            WHERE ARCanCloseThroughDate IS NULL
            
      UPDATE #tempFinancialCenterClosingSummary -- override Can Close Date based upon minimum date over selected (if selected more than one fc, must take lowest one)
            SET #tempFinancialCenterClosingSummary.ARCanCloseThroughDate = 
                  CAST(CONVERT(VARCHAR, (SELECT MIN(ARCanCloseThroughDate) AS MinCloseDate FROM #tempFinancialCenterClosingSummary WHERE EvaluatedAsSelected = 1), 101) + ' 12:00:00' AS DATETIME)
            WHERE #tempFinancialCenterClosingSummary.EvaluatedAsSelected = 1
            
      UPDATE #tempFinancialCenterClosingSummary -- set all batch count  
              SET #tempFinancialCenterClosingSummary.AllBatchCount = CD.ARBatchCount
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT A.FinancialCenterUid AS FinancialCenterUid, COUNT(A.ArBatchUid) AS ARBatchCount 
                        FROM (SELECT DISTINCT FinancialCenterUid, ArBatchUid  FROM #tempFinancialCenterClosingSummaryDetail) A GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      UPDATE #tempFinancialCenterClosingSummary -- set blocking batch count   
            SET #tempFinancialCenterClosingSummary.BlockingBatchCount = CD.ARBatchCount
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT A.FinancialCenterUid AS FinancialCenterUid, COUNT(A.ArBatchUid) AS ARBatchCount 
                        FROM (SELECT DISTINCT FinancialCenterUid, ArBatchUid FROM #tempFinancialCenterClosingSummaryDetail WHERE Blocking = 1) A GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      UPDATE #tempFinancialCenterClosingSummary -- set all payment count      
            SET #tempFinancialCenterClosingSummary.AllPaymentCount = CD.PaymentCount
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT A.FinancialCenterUid AS FinancialCenterUid, COUNT(A.DepositUid) AS PaymentCount 
                        FROM (SELECT DISTINCT FinancialCenterUid, DepositUid FROM #tempFinancialCenterClosingSummaryDetail) A WHERE NOT DepositUid IS NULL GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      UPDATE #tempFinancialCenterClosingSummary -- set blocking payment count 
			SET #tempFinancialCenterClosingSummary.BlockingPaymentCount = CD.PaymentCount
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT A.FinancialCenterUid AS FinancialCenterUid, COUNT(A.DepositUid) AS PaymentCount 
                        FROM (SELECT DISTINCT FinancialCenterUid, DepositUid FROM #tempFinancialCenterClosingSummaryDetail WHERE Blocking = 1) A  WHERE NOT DepositUid IS NULL GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      UPDATE #tempFinancialCenterClosingSummary -- set payment receipt balances     
            SET #tempFinancialCenterClosingSummary.TotalDepositReceipt = CD.TotalDepositReceipt, #tempFinancialCenterClosingSummary.TotalDepositReceiptBalance = CD.TotalDepositReceiptBalance
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT FinancialCenterUid AS FinancialCenterUid, 
                              SUM(DepositReceipt) AS TotalDepositReceipt, SUM(DepositReceiptBalance) AS TotalDepositReceiptBalance
                        FROM #tempFinancialCenterClosingSummaryDetail WHERE NOT DepositUid IS NULL GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      UPDATE #tempFinancialCenterClosingSummary -- set all Superbill count    
            SET #tempFinancialCenterClosingSummary.SuperbillCount = CD.SuperbillCount
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT A.FinancialCenterUid AS FinancialCenterUid, COUNT(A.SuperbillUid) AS SuperbillCount 
                        FROM (SELECT DISTINCT FinancialCenterUid, SuperbillUid FROM #tempFinancialCenterClosingSummaryDetail) A  WHERE NOT SuperbillUid IS NULL GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      UPDATE #tempFinancialCenterClosingSummary -- set Superbill receipt balances   
            SET #tempFinancialCenterClosingSummary.TotalSuperbillLiability = CD.TotalSuperbillLiability, #tempFinancialCenterClosingSummary.TotalSuperbillLiabilityBalance = CD.TotalSuperbillLiabilityBalance
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT FinancialCenterUid, 
                              SUM(SuperbillLiability) AS TotalSuperbillLiability, SUM(SuperbillLiabilityBalance) AS TotalSuperbillLiabilityBalance
                        FROM #tempFinancialCenterClosingSummaryDetail WHERE NOT SuperbillUid IS NULL GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      UPDATE #tempFinancialCenterClosingSummary -- set all PayerCredit count  
            SET #tempFinancialCenterClosingSummary.PayerCreditCount = CD.PayerCreditCount
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT A.FinancialCenterUid AS FinancialCenterUid, COUNT(A.PayerCreditUid) AS PayerCreditCount 
                        FROM (SELECT DISTINCT FinancialCenterUid, PayerCreditUid FROM #tempFinancialCenterClosingSummaryDetail) A  WHERE NOT PayerCreditUid IS NULL GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      UPDATE #tempFinancialCenterClosingSummary -- set payer credit receipt balances      
            SET #tempFinancialCenterClosingSummary.TotalPayerCreditReceipt = CD.TotalPayerCreditReceipt, #tempFinancialCenterClosingSummary.TotalPayerCreditReceiptBalance = CD.TotalPayerCreditReceiptBalance
            FROM #tempFinancialCenterClosingSummary, 
                  (SELECT FinancialCenterUid AS FinancialCenterUid, 
                              SUM(PayerCreditReceipt) AS TotalPayerCreditReceipt, SUM(PayerCreditReceiptBalance) AS TotalPayerCreditReceiptBalance
            FROM #tempFinancialCenterClosingSummaryDetail WHERE NOT PayerCreditUid IS NULL GROUP BY FinancialCenterUid) CD
            WHERE #tempFinancialCenterClosingSummary.FinancialCenterUid = CD.FinancialCenterUid
            
      -- adjustment ... remove blocking and 'can close through' on items that are not selected ... no point and makes UI confusing
      UPDATE #tempFinancialCenterClosingSummary -- set CanCloseDate where no blocking
            SET ARCanCloseThroughDate = NULL, BlockingBatchCount = NULL, BlockingPaymentCount = NULL
            WHERE EvaluatedAsSelected = 0

-- insure that system 'can close date' never exceeds the earliest financial center close date
      DECLARE @maxSystemCloseDate datetime
      SELECT @maxSystemCloseDate = (SELECT MIN(ISNULL(ISNULL(ARCanCloseThroughDate, ARClosedThroughDate), '1764/10/01')) -- force a valid low date if both null
            FROM #tempFinancialCenterClosingSummary WHERE NOT FinancialCenterUid = @guidEmpty)
      IF (@maxSystemCloseDate = '1764/10/01')
            SELECT @maxSystemCloseDate = NULL
      UPDATE #tempFinancialCenterClosingSummary
            SET ARCanCloseThroughDate = CAST(CONVERT(VARCHAR, @maxSystemCloseDate, 101) + ' 12:00:00' AS DATETIME)
                  WHERE FinancialCenterUid = @guidEmpty AND NOT ARCanCloseThroughDate IS NULL
                        AND (@maxSystemCloseDate IS NULL OR ARCanCloseThroughDate>@maxSystemCloseDate)
                    
      -- Data collected, can now process if all good
        IF (NOT @arCloseThroughDate IS NULL) -- deals with a Completing or Updating an entire FC
        BEGIN
                IF (NOT EXISTS (SELECT FinancialCenterUid FROM #tempFinancialCenterClosingSummary -- can just use the summary at this point to decide
                                                    WHERE EvaluatedAsSelected = 1
                                                            AND (ARCanCloseThroughDate IS NULL OR  ARCanCloseThroughDate<@arCloseThroughDate)))
                BEGIN
                        IF (@completeOnly=0) -- UPDATE Financial Center
                        BEGIN
                                UPDATE FinancialCenter -- Update Financial Centers
                                    SET ARClosedThroughDate = @arCloseThroughDate -- where does this directly from the summary
                                    WHERE FinancialCenterUid IN (SELECT FinancialCenterUid FROM #tempFinancialCenterClosingSummary WHERE EvaluatedAsSelected = 1)
                                            AND (ARClosedThroughDate IS NULL OR ARClosedThroughDate < @arCloseThroughDate)
                                IF EXISTS(SELECT FinancialCenterUid FROM #tempFinancialCenterClosingSummary WHERE EvaluatedAsSelected = 1 AND FinancialCenterUid = @guidEmpty)
                                    UPDATE PracticeSettings SET SystemFinancialsCloseThruDate = @arCloseThroughDate
                                            WHERE SystemFinancialsCloseThruDate IS NULL OR SystemFinancialsCloseThruDate < @arCloseThroughDate
                                EXEC dbo.AR_SetBatchIsClosedAggregate
                        END
                        ELSE
                        BEGIN
                                UPDATE ARBatch SET IsLocked = 1
                                    WHERE ARBatchUid IN (SELECT TCD.ARBatchUid FROM #tempFinancialCenterClosingSummaryDetail TCD WHERE TCD.ARBatchGlDate <=@arCloseThroughDate 
                                    AND TCD.FinancialCenterUid IN (SELECT FinancialCenterUid FROM #tempFinancialCenterClosingSummary WHERE EvaluatedAsSelected = 1))
                        END
						RETURN
				END
                ELSE
                BEGIN
                    SELECT 'NameValuePair' -- blocking failure
					SELECT 'Closing Blocked','' 
				END
		END
		ELSE -- deals with Completing individual Batches
        BEGIN 
                IF ((LEN(@arBatchUids)>0) AND EXISTS(SELECT * FROM #tempARBatchesSelected) -- make certain the temoBatchesSelected in this case came from the call
                        AND NOT EXISTS (SELECT ARBatchUid FROM #tempFinancialCenterClosingSummaryDetail 
                                                            WHERE ArBatchUid IN (SELECT ArBatchUid FROM #tempARBatchesSelected)
                                                            AND Blocking = 1)) -- only complete ANY when ALL can be completed
                BEGIN
                        UPDATE ARBatch SET IsLocked = 1
						WHERE ARBatchUid IN (SELECT TARBS.ARBatchUid FROM #tempARBatchesSelected TARBS)
                                AND NOT ARBatchUid IN (SELECT ARBatchUid FROM #tempFinancialCenterClosingSummaryDetail WHERE Blocking = 1)
                END
				ELSE
                BEGIN
                    SELECT 'NameValuePair' -- blocking failure
                    SELECT 'Closing Blocked','' 
                END
        END

      			   
      SELECT 'AR_ViewFinancialCenterClosingSummary' -- defined in PRMObjects
      SELECT * FROM #tempFinancialCenterClosingSummary ORDER BY CASE WHEN FinancialCenterName='System' THEN 'zzzzz' ELSE FinancialCenterName END
  
	  -- this allows the ui to fetch basic batch, deposit, and superbill lists without a trip back to the database
	  --SELECT 'AR_ViewFinancialCenterClosingSummaryDetail' -- defined in PRMObjects
	  IF (EXISTS(SELECT * FROM #tempARBatchesSelected)) -- same query for both, filter for only batches if batch list sent
		  DELETE FROM #tempFinancialCenterClosingSummaryDetail
			  WHERE NOT ArBatchUid IN (SELECT ArBatchUid FROM #tempARBatchesSelected) 

		SELECT FinancialCenterUid, Type, ObjectUid, SUM(Blocking) AS Blocking
		INTO #tempObjectList
		FROM (
				SELECT DISTINCT FinancialCenterUid AS FinancialCenterUid, 'B' AS Type, ARBatchUid AS ObjectUid, Blocking
				FROM #tempFinancialCenterClosingSummaryDetail
				WHERE NOT ARBatchUid IS NULL
				UNION 
				SELECT DISTINCT FinancialCenterUid AS FinancialCenterUid, 'D' AS Type, DepositUid AS ObjectUid, Blocking
				FROM #tempFinancialCenterClosingSummaryDetail
				WHERE NOT DepositUid IS NULL
				UNION 
				SELECT DISTINCT FinancialCenterUid AS FinancialCenterUid, 'S' AS Type, SuperbillUid AS ObjectUid, Blocking
				FROM #tempFinancialCenterClosingSummaryDetail
				WHERE NOT SuperbillUid IS NULL
				UNION 
				SELECT DISTINCT FinancialCenterUid AS FinancialCenterUid, 'C' AS Type, PayerCreditUid AS ObjectUid, Blocking
				FROM #tempFinancialCenterClosingSummaryDetail
				WHERE NOT PayerCreditUid IS NULL
			) AS INOBJ
		GROUP BY FinancialCenterUid, Type, ObjectUid

		--SELECT 'AR_ViewFinancialCenterClosingSummary_ObjectLinks'
		INSERT INTO AR_ViewFinancialCenterClosingSummary_ObjectLinks (FinancialCenterClosingSummaryUid,ObjectUid, Type, FinancialCenterUid, Blocking)
		SELECT DISTINCT @financialCenterClosingSummaryUid AS FinancialCenterClosingSummaryUid, ObjectUid, Type, FinancialCenterUid, CAST(CASE WHEN Blocking = 0 THEN 0 ELSE 1 END AS BIT) AS Blocking
		FROM #tempObjectList;

		--SELECT 'AR_ViewFinancialCenterClosingSummary_DepositsWithBalance' -- this does need to be seperate as a deposit could be in multiple batches 
		INSERT INTO AR_ViewFinancialCenterClosingSummary_DepositsWithBalance (FinancialCenterClosingSummaryUid, DepositUid, DepositReferenceNumber, DepositReceiptBalance, ArBatchName)
		SELECT DISTINCT @financialCenterClosingSummaryUid AS FinancialCenterClosingSummaryUid, DepositUid, DepositReferenceNumber, DepositReceiptBalance, ArBatchName
		FROM #tempFinancialCenterClosingSummaryDetail
		WHERE DepositReceiptBalance <> 0;

		--SELECT 'AR_ViewFinancialCenterClosingSummary_BatchInfo';
		INSERT INTO AR_ViewFinancialCenterClosingSummary_BatchInfo(FinancialCenterClosingSummaryUid, ARBatchUid, BatchName, GLDate, Complete)
		SELECT @financialCenterClosingSummaryUid AS FinancialCenterClosingSummaryUid,ARB.ARBatchUid, ARB.Name AS BatchName, ARB.GLDate, ARB.IsLocked AS Complete
			FROM ARBatch ARB
				INNER JOIN dbo.Split(@arBatchUids,',') SPL ON ARB.ARBatchUid = CAST(SPL.Element AS UNIQUEIDENTIFIER);

	  DROP TABLE #tempObjectList;
      DROP TABLE #tempFinancialCenterClosingSummary
      DROP TABLE #tempFinancialCenterClosingSummaryDetail
      DROP TABLE #tempARBatchesSelected
      DROP TABLE #tempFinancialCentersSelected
      
/*
update FinancialCenter set ARClosedThroughDate = null
update PracticeSettings set SystemFinancialsCloseThruDate = null
exec dbo.[AR_LoadFinancialCenterClosingSummary] null, '56025905-109C-4405-9EFD-56383309036C'
exec dbo.[AR_LoadFinancialCenterClosingSummary] null, '00000000-0000-0000-0000-000000000000'
exec dbo.[AR_LoadFinancialCenterClosingSummary] null, '14B99C94-EDAC-47BD-97B9-CF421AC16018'
exec dbo.[AR_LoadFinancialCenterClosingSummary] null, '00000000-0000-0000-0000-000000000000,14B99C94-EDAC-47BD-97B9-CF421AC16018'
exec dbo.[AR_LoadFinancialCenterClosingSummary] '2010-07-02', 'EDDC0113-6296-4CE5-A7A9-AD9A39D36DB6', 1

-- report only 
select * from ARBatch
exec dbo.[AR_LoadFinancialCenterClosingSummary] @arBatchUids='33F9C40E-3CF5-482B-AD0A-0D9F6C397F03', @reportOnly=1

EXEC [AR_LoadFinancialCenterClosingSummary_BMR] @arCloseThroughDate = '2012-10-31', @reportOnly=1

*/

END




















GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_LoadFinancialCenterClosingSummary_AdditonalDetails]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_LoadFinancialCenterClosingSummary_AdditonalDetails] AS' 
END
GO





ALTER PROC [dbo].[AR_LoadFinancialCenterClosingSummary_AdditonalDetails]
@financialCenterClosingSummaryUid UNIQUEIDENTIFIER,
@returnObjectLinks BIT = 0,
@objectLinkType VARCHAR(1) = '',
@objectLinkBlockingOnly BIT = 0,
@financialCenterUid UNIQUEIDENTIFIER, 
@returnDepositsWithBalance BIT = 0,
@returnBatchInfo BIT = 0
AS

BEGIN

	IF (@financialCenterUid IS NULL)
		SET @financialCenterUid = '00000000-0000-0000-0000-000000000000';

		-- Trim Old Data - Should not be much of it so no problem with performance
		DELETE FROM AR_ViewFinancialCenterClosingSummary_ObjectLinks
			WHERE CreatedDateTime < DATEADD(d,-1,GETDATE());
		DELETE FROM AR_ViewFinancialCenterClosingSummary_DepositsWithBalance
			WHERE CreatedDateTime < DATEADD(d,-1,GETDATE());
		DELETE FROM AR_ViewFinancialCenterClosingSummary_BatchInfo
			WHERE CreatedDateTime < DATEADD(d,-1,GETDATE());

		SELECT 'NameValuePair'
		IF (@returnObjectLinks=1)
			SELECT TOP 600 CAST(ObjectUid AS VARCHAR(100)) AS Name, '' AS Value
				FROM AR_ViewFinancialCenterClosingSummary_ObjectLinks
				WHERE FinancialCenterClosingSummaryUid = @financialCenterClosingSummaryUid
					AND (@objectLinkType = ''
							OR [Type] = @objectLinkType)
					AND (@objectLinkBlockingOnly = 0
						OR Blocking = 1)
					AND (FinancialCenterUid = @financialCenterUid);
		ELSE
			SELECT TOP 0 CAST(ObjectUid AS VARCHAR(100)) AS Name, '' AS Value
				FROM AR_ViewFinancialCenterClosingSummary_ObjectLinks

		SELECT 'AR_ViewFinancialCenterClosingSummary_DepositsWithBalance' 
		IF (@returnDepositsWithBalance=1)
			SELECT *
				FROM AR_ViewFinancialCenterClosingSummary_DepositsWithBalance
				WHERE FinancialCenterClosingSummaryUid = @financialCenterClosingSummaryUid;
		ELSE
			SELECT TOP 0 *
				FROM AR_ViewFinancialCenterClosingSummary_DepositsWithBalance

		SELECT 'AR_ViewFinancialCenterClosingSummary_BatchInfo';
		IF (@returnBatchInfo=1)
			SELECT *
				FROM AR_ViewFinancialCenterClosingSummary_BatchInfo
				WHERE FinancialCenterClosingSummaryUid = @financialCenterClosingSummaryUid;
		ELSE
			SELECT TOP 0 *
				FROM AR_ViewFinancialCenterClosingSummary_BatchInfo
/*

DECLARE @financialCenterClosingSummaryUid UNIQUEIDENTIFIER;
SET @financialCenterClosingSummaryUid = '80474B0C-2CB7-4C25-BCFB-B3EB2E5F7961'
EXEC dbo.AR_LoadFinancialCenterClosingSummary_AdditonalDetails
	@financialCenterClosingSummaryUid=@financialCenterClosingSummaryUid,
	@returnObjectLinks = 1,
	@objectLinkType = 'D',
	@returnDepositsWithBalance = 1,
	@returnBatchInfo = 1


*/

END
























GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_LoadLedgerExtended]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_LoadLedgerExtended] AS' 
END
GO



ALTER PROC [dbo].[AR_LoadLedgerExtended]
	@maxReturn int = 100, -- if nothing specified
	@depositUid UNIQUEIDENTIFIER = null,
	@accountResponsiblePartyUid UNIQUEIDENTIFIER = null,
	@insurancePayerUid UNIQUEIDENTIFIER = null,
	@superbillUid UNIQUEIDENTIFIER = null,
	@serviceSiteUid UNIQUEIDENTIFIER = null,
	@financialCenterUid UNIQUEIDENTIFIER = null,
	@claimingProviderUid UNIQUEIDENTIFIER = null,
	@renderingProviderUid UNIQUEIDENTIFIER = null
AS
BEGIN
	CREATE TABLE #tempLedgerExtended
	(
		RC INT IDENTITY(1,1) NOT NULL,
		LedgerDetailUid UNIQUEIDENTIFIER NOT NULL,
		LedgerUid UNIQUEIDENTIFIER NOT NULL,
		TransactionUid UNIQUEIDENTIFIER NULL,
		TransactionReferenceNumber VARCHAR(250) NULL,
		VoidLedgerUid UNIQUEIDENTIFIER NULL,
		ReversalPartnerUid UNIQUEIDENTIFIER NULL,
		EntryDate DATETIME NOT NULL,
		EntryType INT NOT NULL,
		ArBatchUid UNIQUEIDENTIFIER NOT NULL,
		PostingDate DATETIME NOT NULL,
		ShortName VARCHAR(50) NOT NULL,
		Reconciled BIT NOT NULL,
		Debit MONEY NOT NULL,
		Credit MONEY NOT NULL,
		IsCredit BIT NOT NULL,
		Amount MONEY NOT NULL,
		LedgerAccountUid UNIQUEIDENTIFIER NULL,
		IncomeAccountUid UNIQUEIDENTIFIER NULL,
		AccountResponsiblePartyUid UNIQUEIDENTIFIER NULL,
		InsurancePayerUid UNIQUEIDENTIFIER NULL,
		DepositUid UNIQUEIDENTIFIER NULL,
		PayerCreditUid UNIQUEIDENTIFIER NULL,
		PayerCreditNote VARCHAR(250) NULL,
		SuperbillProcedureUid UNIQUEIDENTIFIER NULL,
		LiabilityOwner INT NULL,
		InsurancePlanUid UNIQUEIDENTIFIER NULL,
		ClaimingProviderUid UNIQUEIDENTIFIER NULL,
		RenderingProviderUid UNIQUEIDENTIFIER NULL,
		FinancialCenterUid UNIQUEIDENTIFIER NULL,
		ServiceSiteUid UNIQUEIDENTIFIER NULL,
		CreatedDateTime DATETIME NOT NULL,
		ResponsibleAccountResponsiblePartyUid UNIQUEIDENTIFIER NULL,
		ResponsibleInsurancePayerUid UNIQUEIDENTIFIER NULL,
		LastModifiedByUid UNIQUEIDENTIFIER NULL,
		ArBatchName VARCHAR(255) NOT NULL,
		ArBatchIsLocked BIT NOT NULL,
		ArBatchIsClosed BIT NOT NULL,
		DepositReferenceNumber VARCHAR(50) NULL,
		SuperbillUid UNIQUEIDENTIFIER NULL,
		ExternalID VARCHAR(25) NULL,
		RenderingProviderFullName VARCHAR(255) NULL,
		ClaimingProviderFullName VARCHAR(255) NULL,
		InsurancePayerPlanName VARCHAR(255) NULL,
		ServiceSiteName VARCHAR(50) NULL,
		FinancialCenterName VARCHAR(255) NULL,
		PayerName VARCHAR(255) NULL,
		Description VARCHAR(500) NOT NULL,
		ReferenceDescription VARCHAR(263) NOT NULL,
		SearchResult BIT NOT NULL
	)
	
	CREATE TABLE #Ledger 
	(
		LedgerUid UNIQUEIDENTIFIER,
		LedgerDetailUid UNIQUEIDENTIFIER
	)
	
	IF (@depositUid IS NULL AND @accountResponsiblePartyUid IS NULL AND @insurancePayerUid IS NULL AND @superbillUid IS NULL 
			AND @serviceSiteUid IS NULL AND @financialCenterUid IS NULL AND @claimingProviderUid IS NULL AND @renderingProviderUid IS NULL)
	BEGIN
		SELECT 'AR_ViewLedgerExtended'
		SELECT AR_ViewLedgerExtended.* FROM AR_ViewLedgerExtended WHERE LedgerDetailUid IS NULL -- NONE
		RETURN
	END
	
	DECLARE @sql NVARCHAR (MAX)
	SELECT @sql =
		N'SELECT DISTINCT LD.LedgerUid, LD.LedgerDetailUid ' + CHAR (10) +
		N'FROM AR_LedgerDetail LD ' + CHAR (10) +
		CASE WHEN NOT @superbillUid IS NULL OR  NOT @accountResponsiblePartyUid IS NULL 
			THEN N'LEFT JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid ' ELSE N''
		END + CHAR (10) +
		CASE WHEN NOT @accountResponsiblePartyUid IS NULL 
			THEN N'LEFT JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid ' +
				 N'LEFT JOIN Account AC ON SB.AccountUid = AC.AccountUid '  ELSE N''
		END + CHAR (10) +
		N' WHERE 1=1 ' + CHAR (10) +
		CASE WHEN NOT @superbillUid IS NULL THEN N' AND SBP.SuperbillUid = @psuperbillUid ' ELSE N'' END	+ CHAR (10) +
		CASE WHEN NOT @depositUid IS NULL THEN N' AND LD.DepositUid = @pdepositUid ' ELSE N'' END	+ CHAR (10) +
		CASE WHEN NOT @serviceSiteUid IS NULL THEN N' AND LD.ServiceSiteUid = @pserviceSiteUid ' ELSE N'' END	+ CHAR (10) +
		CASE WHEN NOT @insurancePayerUid IS NULL THEN N' AND LD.InsurancePayerUid = @pinsurancePayerUid ' ELSE N'' END	+ CHAR (10) +
		CASE WHEN NOT @financialCenterUid IS NULL THEN N' AND LD.FinancialCenterUid = @pfinancialCenterUid ' ELSE N'' END	+ CHAR (10) +
		CASE WHEN NOT @claimingProviderUid IS NULL THEN N' AND LD.ClaimingProviderUid = @pclaimingProviderUid ' ELSE N'' END	+ CHAR (10) +
		CASE WHEN NOT @renderingProviderUid IS NULL THEN N' AND LD.RenderingProviderUid = @prenderingProviderUid ' ELSE N'' END	+ CHAR (10) +
		CASE WHEN NOT @accountResponsiblePartyUid IS NULL THEN N' AND AC.AccountResponsiblePartyUid = @paccountResponsiblePartyUid ' ELSE N'' END	+ CHAR (10) +
		CHAR (10)  -- clean ending
		
	INSERT INTO #Ledger
	EXEC sp_executesql @sql, N'@psuperbillUid UNIQUEIDENTIFIER, @pdepositUid UNIQUEIDENTIFIER,
		@pserviceSiteUid UNIQUEIDENTIFIER, @pinsurancePayerUid UNIQUEIDENTIFIER, @pfinancialCenterUid UNIQUEIDENTIFIER, @pclaimingProviderUid UNIQUEIDENTIFIER,
		@prenderingProviderUid UNIQUEIDENTIFIER, @paccountResponsiblePartyUid UNIQUEIDENTIFIER ', @psuperbillUid = @superbillUid, @pdepositUid = @depositUid,
		@pserviceSiteUid = @serviceSiteUid, @pinsurancePayerUid = @insurancePayerUid, @pfinancialCenterUid = @financialCenterUid, 
		@pclaimingProviderUid = @claimingProviderUid, @prenderingProviderUid = @renderingProviderUid, @paccountResponsiblePartyUid = @accountResponsiblePartyUid
	
	SELECT LE.*
	INTO #LedgerExtended
	FROM AR_ViewLedgerExtended LE
		INNER JOIN #Ledger L ON LE.LedgerUid = L.LedgerUid;
		
	INSERT INTO #tempLedgerExtended (LedgerDetailUid, LedgerUid, TransactionUid, VoidLedgerUid, ReversalPartnerUid, EntryDate, EntryType, 
			ArBatchUid, PostingDate, ShortName, Reconciled, Debit, Credit, IsCredit, Amount, LedgerAccountUid, IncomeAccountUid, 
			AccountResponsiblePartyUid, InsurancePayerUid, DepositUid, PayerCreditUid, SuperbillProcedureUid, LiabilityOwner, InsurancePlanUid, 
			ClaimingProviderUid, RenderingProviderUid, FinancialCenterUid, ServiceSiteUid, CreatedDateTime, 
			ResponsibleAccountResponsiblePartyUid, ResponsibleInsurancePayerUid, LastModifiedByUid, 
			ArBatchName, ArBatchIsLocked, ArBatchIsClosed, DepositReferenceNumber, SuperbillUid, ExternalID, RenderingProviderFullName, 
			ClaimingProviderFullName, InsurancePayerPlanName, ServiceSiteName, FinancialCenterName, PayerName, Description, ReferenceDescription, SearchResult)
	SELECT DISTINCT LE.LedgerDetailUid, LE.LedgerUid, LE.TransactionUid, LE.VoidLedgerUid, LE.ReversalPartnerUid, LE.EntryDate, LE.EntryType, LE.ArBatchUid, LE.PostingDate, LE.ShortName, 
		LE.Reconciled, LE.Debit, LE.Credit, LE.IsCredit, LE.Amount, LE.LedgerAccountUid, LE.IncomeAccountUid, LE.AccountResponsiblePartyUid, LE.InsurancePayerUid,
		LE.DepositUid, LE.PayerCreditUid, LE.SuperbillProcedureUid, LE.LiabilityOwner, LE.InsurancePlanUid, LE.ClaimingProviderUid, LE.RenderingProviderUid, LE.FinancialCenterUid, 
		LE.ServiceSiteUid, LE.CreatedDateTime, LE.ResponsibleAccountResponsiblePartyUid,
		LE.ResponsibleInsurancePayerUid, LE.LastModifiedByUid, LE.ArBatchName, LE.ArBatchIsLocked, LE.ArBatchIsClosed, 
		CASE WHEN LEN(LE.DepositReferenceNumber)>50 THEN SUBSTRING(LE.DepositReferenceNumber,1,50) ELSE LE.DepositReferenceNumber END, 
		LE.SuperbillUid, LE.ExternalID,
		LE.RenderingProviderFullName, LE.ClaimingProviderFullName, LE.InsurancePayerPlanName, LE.ServiceSiteName, LE.FinancialCenterName, 
		CASE WHEN ISNULL(LE.PayerName,'') != '' THEN LE.PayerName
			ELSE LE2.PayerName END AS PayerName,  
		ISNULL(LE2.[Description],''), '' AS ReferenceDescription,
		CAST(CASE WHEN L2.LedgerDetailUid IS NULL THEN 0 ELSE 1 END AS BIT) AS SearchResult 
	FROM #LedgerExtended LE
		LEFT JOIN #Ledger L2 ON LE.LedgerDetailUid = L2.LedgerDetailUid
		INNER JOIN #LedgerExtended LE2 ON LE.LedgerUid = LE2.LedgerUid AND LE.LedgerDetailUid != LE2.LedgerDetailUid
	ORDER BY LE.PostingDate, LE.CreatedDateTime, LE.EntryType, LE.IsCredit DESC
	
	IF (@maxReturn <> -1)
		SET ROWCOUNT @maxReturn

	SELECT 'AR_ViewLedgerExtended'
	SELECT 	LedgerDetailUid,LedgerUid,TransactionUid, TransactionReferenceNumber,VoidLedgerUid, ReversalPartnerUid,EntryDate,EntryType,
		ArBatchUid,PostingDate,ShortName,Reconciled,Debit,Credit,IsCredit,Amount,
		LedgerAccountUid,IncomeAccountUid,AccountResponsiblePartyUid,InsurancePayerUid,
		DepositUid,PayerCreditUid, PayerCreditNote, SuperbillProcedureUid,LiabilityOwner,InsurancePlanUid,ClaimingProviderUid,RenderingProviderUid,
		FinancialCenterUid,ServiceSiteUid,CreatedDateTime,ResponsibleAccountResponsiblePartyUid,ResponsibleInsurancePayerUid, LastModifiedByUid,
		ArBatchName,ArBatchIsLocked,ArBatchIsClosed,DepositReferenceNumber,SuperbillUid,ExternalID,
		RenderingProviderFullName,ClaimingProviderFullName, InsurancePayerPlanName, ServiceSiteName,FinancialCenterName,PayerName, 
		Description,'' AS ReferenceDescription,
		ISNULL((SELECT SUM(ISNULL(LE2.Amount,0)) AS Balance
				FROM #tempLedgerExtended LE2
				WHERE LE2.RC <= LE1.RC
					AND LE2.SearchResult = LE1.SearchResult
					AND (NOT LE2.InsurancePlanUid IS NULL OR NOT LE2.InsurancePayerUid IS NULL)),0) AS InsuranceBalance,
		ISNULL((SELECT SUM(ISNULL(LE3.Amount,0)) AS Balance
			FROM #tempLedgerExtended LE3
			WHERE LE3.RC <= LE1.RC
				AND LE3.SearchResult = LE1.SearchResult),0) AS TotalBalance,
		SearchResult
	FROM #tempLedgerExtended LE1
	ORDER BY LE1.RC DESC
	
	SET ROWCOUNT 0
	
	DROP TABLE #Ledger
	DROP TABLE #LedgerExtended
	DROP TABLE #tempLedgerExtended
	
/*
exec AR_LoadLedgerExtended  @superbillUid='E567267E-F216-4E36-B2C4-00139C34D318'
select * from AR_ViewLedgerExtended
SELECT * FROM Superbill WHERE ExternalID = '10'
*/
	
END


























GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_LoadMigrateProceduresWithLiabilityInMultipleCarriers]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_LoadMigrateProceduresWithLiabilityInMultipleCarriers] AS' 
END
GO
ALTER PROC [dbo].[AR_LoadMigrateProceduresWithLiabilityInMultipleCarriers]
AS
BEGIN
	-- get master list
	SELECT SuperbillProcedureUid
	INTO #proceduresWithLiabilityInMultipleCarriers
	FROM (
	SELECT DISTINCT SuperbillProcedureUid, LiabilityOwner
		   FROM (SELECT SBP.SuperbillUid, SBP.SuperbillProcedureUid, LD.LiabilityOwner, SUM(LD.Amount) AS Balance, COUNT_BIG(*) AS Count   
					FROM dbo.SuperbillProcedure SBP    
					INNER JOIN dbo.AR_LedgerDetail LD ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid
		GROUP BY SBP.SuperbillUid, SBP.SuperbillProcedureUid, LD.LiabilityOwner ) VSCLOACS 
		   WHERE Balance <> 0 AND LiabilityOwner > 0) VS
		   GROUP BY VS.SuperbillProcedureUid
		   HAVING COUNT(SuperbillProcedureUid) > 1;
	
	-- remove records that do not have an insurance record
	SELECT SBP.SuperbillProcedureUid, SB.SuperbillUid 
		INTO #tempSuperbillProceduresToIgnore
		FROM #proceduresWithLiabilityInMultipleCarriers PWLIMC
			INNER JOIN SuperbillProcedure SBP ON PWLIMC.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
			LEFT JOIN AccountPeriod AP ON SB.AccountUid = AP.AccountUid
				AND ISNULL(AP.EffectiveDate,'1900-01-01') <= SB.ServiceDateStart
				AND ISNULL(AP.ExpirationDate, '2400-01-01') >= SB.ServiceDateEnd
			LEFT JOIN AccountInsurance AI ON AP.AccountPeriodUid = AI.AccountPeriodUid
							AND AI.DisplayOrder = 1
		WHERE AI.AccountInsuranceUid IS NULL;
		
	-- remove where there is no original charge to transfer from, on ANY Liability Owner	
	INSERT INTO #tempSuperbillProceduresToIgnore 	 
		SELECT LD.SuperbillProcedureUid, SBP.SuperbillUid
			FROM #proceduresWithLiabilityInMultipleCarriers PWLIMC
				INNER JOIN AR_LedgerDetail LD ON PWLIMC.SuperbillProcedureUid = LD.SuperbillProcedureUid
				INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid 
				INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			WHERE LD.LiabilityOwner>1 
			GROUP BY LD.SuperbillProcedureUid, SBP.SuperbillUid, LD.LiabilityOwner
			HAVING SUM(CASE WHEN IsCredit = 0 AND L.EntryType IN (1,4) THEN 1 ELSE 0 END) = 0;
			
	-- overlapping account periods -- toss out related superbill procedures		
	WITH cteAccountPeriods AS
	(
		SELECT AC.AccountUid, AP.AccountPeriodUid, 
				ISNULL(AP.EffectiveDate, '1900-01-01') AS EffectiveDate, ISNULL(AP.ExpirationDate, '2400-01-01') AS ExpirationDate
			FROM Account AC
				INNER JOIN AccountPeriod AP ON AC.AccountUid = AP.AccountUid
	), cteBadAccounts AS
	(
	SELECT DISTINCT APM.AccountUid
		FROM cteAccountPeriods APM
			LEFT JOIN cteAccountPeriods APC ON APM.AccountUid = APC.AccountUid AND APM.AccountPeriodUid <> APC.AccountPeriodUid
		WHERE APM.EffectiveDate <= APC.ExpirationDate AND APC.EffectiveDate <= APM.ExpirationDate
	)
	INSERT INTO #tempSuperbillProceduresToIgnore	
		SELECT SBP.SuperbillProcedureUid, SBP.SuperbillUid
				FROM #proceduresWithLiabilityInMultipleCarriers PWLIMC
					INNER JOIN SuperbillProcedure SBP ON PWLIMC.SuperbillProcedureUid = SBP.SuperbillProcedureUid
					INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
					INNER JOIN cteBadAccounts BA ON SB.AccountUid = BA.AccountUid;
					
	UPDATE Superbill SET SuperbillStatusUid = 'B4D6B17E-A8A1-425D-95D3-5D29B465D682' --Insurance Action
		WHERE SuperbillUid IN 
		(
			SELECT SuperbillUid
				FROM #tempSuperbillProceduresToIgnore
		)

	DELETE FROM #proceduresWithLiabilityInMultipleCarriers -- remove records that do not have an insurance record
		WHERE SuperbillProcedureUid IN
		(
			SELECT SuperbillProcedureUid
				FROM #tempSuperbillProceduresToIgnore
		)

	DECLARE @countOfSuperbillProcedures INT
	SELECT @countOfSuperbillProcedures = COUNT(*) FROM #proceduresWithLiabilityInMultipleCarriers
	
	SELECT 'NameValuePair'
	SELECT 'ProceduresWithLiabilityInMultipleCarriers' AS Name, CAST(@countOfSuperbillProcedures AS VARCHAR(5)) AS Value
	
	SELECT 'SuperbillProcedure'
	SELECT TOP 100 * FROM SuperbillProcedure -- USE 100 to breeak up the batches, code calls this numberous times to get through them all
		WHERE SuperbillProcedureUid IN (SELECT SuperbillProcedureUid FROM #proceduresWithLiabilityInMultipleCarriers)
	
	DROP TABLE #proceduresWithLiabilityInMultipleCarriers
	
	/*
		Loads up any SuperbillProcedures with a non-zero liability balance across more than one insurance liability owner
		BEGIN TRANSACTION
		EXEC dbo.[AR_LoadMigrateProceduresWithLiabilityInMultipleCarriers]
		ROLLBACK TRANSACTION
	*/
	
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_LoadPayerCreditCandidate]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_LoadPayerCreditCandidate] AS' 
END
GO

ALTER PROCEDURE [dbo].[AR_LoadPayerCreditCandidate] @SuperbillUid UNIQUEIDENTIFIER = NULL

AS
   -- get list of ledgers to return
   DECLARE @Ledgers TABLE(LedgerUid UNIQUEIDENTIFIER PRIMARY KEY NOT NULL)
   INSERT INTO @Ledgers
   SELECT arl.LedgerUid
   FROM AR_PayerCreditCandidate_DistributionLedger pcc
   INNER JOIN AR_Ledger arl ON arl.LedgerUid = pcc.LedgerUid
   WHERE pcc.SuperbillUid = @SuperbillUid
   UNION
   SELECT ard.LedgerUid
   FROM AR_LedgerDetail ard
   INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = ard.SuperbillProcedureUid
   WHERE sbp.SuperbillUid = @SuperbillUid
   
   SELECT 'AR_PayerCreditCandidate'
   SELECT *
   FROM AR_PayerCreditCandidate
   WHERE SuperbillUid = @SuperbillUid
   ORDER BY LiabilityOwner

   SELECT 'AR_PayerCreditCandidate_Procedure'
   SELECT *
   FROM AR_PayerCreditCandidate_Procedure
   WHERE SuperbillUid = @SuperbillUid
   ORDER BY LiabilityOwner, DisplayOrder, ProcedureName

   SELECT 'AR_PayerCreditCandidate_Deposit'
   SELECT *
   FROM AR_PayerCreditCandidate_Deposit
   WHERE SuperbillUid = @SuperbillUid
   ORDER BY LiabilityOwner, DepositCreateDateTime

   SELECT 'AR_PayerCreditCandidate_DistributionLedger'
   SELECT *
   FROM AR_PayerCreditCandidate_DistributionLedger
   WHERE SuperbillUid = @SuperbillUid
   ORDER BY DepositUid, PayerPaid DESC

   SELECT 'AR_Ledger'
   SELECT arl.*
   FROM @Ledgers tmp
   INNER JOIN AR_Ledger arl ON arl.LedgerUid = tmp.LedgerUid

   SELECT 'AR_LedgerDetail'
   SELECT ard.*
   FROM @Ledgers tmp
   INNER JOIN AR_LedgerDetail ard ON ard.LedgerUid = tmp.LedgerUid

   SELECT 'AR_PayerCredit'
   SELECT apc.*
   FROM @Ledgers tmp
   INNER JOIN AR_LedgerDetail ard ON ard.LedgerUid = tmp.LedgerUid
   INNER JOIN AR_PayerCredit apc ON apc.PayerCreditUid = ard.PayerCreditUid
   UNION
   SELECT apc.*
   FROM @Ledgers tmp
   INNER JOIN AR_LedgerDetail ard ON ard.LedgerUid = tmp.LedgerUid
   INNER JOIN AR_PayerCredit apc ON apc.DepositUid = ard.DepositUid

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_MarkLedgerAsReconciled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_MarkLedgerAsReconciled] AS' 
END
GO



ALTER PROCEDURE [dbo].[AR_MarkLedgerAsReconciled]                        
      @ledgerUids VARCHAR(8000) = ''                   
AS                        
                                                      
SET NOCOUNT ON            
                      
	UPDATE AR_Ledger SET Reconciled = 1 
		WHERE LedgerUid IN (SELECT Element FROM SPLIT(@ledgerUids,','))


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_ReorderAccountInsuranceOrders]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_ReorderAccountInsuranceOrders] AS' 
END
GO

ALTER PROC [dbo].[AR_ReorderAccountInsuranceOrders]
	@AccountPeriodUid uniqueidentifier = null 
AS
begin
	-- Reorders the insurances within the specified accountperiod as needed, 
	-- or any that need it if accountperiod is not specified
	declare @badones table (apuid uniqueidentifier) 
	insert into @badones(apuid) 
	select distinct ai1.AccountPeriodUid 
		from AccountInsurance ai1, AccountInsurance ai2, AccountPeriod ap 
		where ai1.AccountPeriodUid = ap.AccountPeriodUid and ai2.AccountPeriodUid = ap.AccountPeriodUid 
			and ai1.AccountInsuranceUid != ai2.AccountInsuranceUid and ai1.DisplayOrder = ai2.DisplayOrder 
			and (@AccountPeriodUid is null or ap.AccountPeriodUid = @AccountPeriodUid) 

	declare @apuid uniqueidentifier, @order int, @acctinsuid uniqueidentifier, @lastapuid uniqueidentifier
	declare curAP cursor for select ai.AccountPeriodUid, ai.AccountInsuranceUid 
		from @badones bo, AccountInsurance ai 
		where bo.apuid = ai.AccountPeriodUid 
		order by ai.AccountPeriodUid, ai.DisplayOrder asc, ai.LastModifiedDate asc 
	open curAP
	fetch curAP into @apuid, @acctinsuid
	while (@@fetch_status = 0)
		begin
			if (@order is null or @lastapuid is null or @lastapuid != @apuid)
				set @order = 0 
			set @order = @order + 1 
			set @lastapuid = @apuid 
			update AccountInsurance 
			set DisplayOrder = @order, LastModifiedDate = GetUTCDate() 
			where AccountInsuranceUid = @acctinsuid
			fetch curAP into @apuid, @acctinsuid
		end
	close curAP
	deallocate curAP

end

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_RPT_FinancialSummary]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_RPT_FinancialSummary] AS' 
END
GO




ALTER PROC [dbo].[AR_RPT_FinancialSummary]
	@groupBy VARCHAR(100)='Provider',  -- or Financial Center, Service Site 
	@typeofProviders VARCHAR(100) = 'Rendering Providers', -- or Claiming Providers
	@glDateFrom DATETIME = NULL,
	@glDateTo DATETIME = NULL,
	@monthlyView bit=0, -- 1 for monthly view
	@providerUidList  VARCHAR(MAX) = NULL,    
	@financialCenterUidList VARCHAR(MAX) = NULL,    
	@serviceSiteUidList VARCHAR(MAX) = NULL
AS
BEGIN

	CREATE TABLE #financialSummmary                        
	(     
		LineItemUid UNIQUEIDENTIFIER,                   
		LineItemName VARCHAR(50), 
		StartDate DATETIME,
		EndDate DATETIME,
		MonthlyGroup VARCHAR(50),
		BeginingAr MONEY,                        
		Charges MONEY,                        
		Receipts MONEY,                        
		Adjustments MONEY,                        
		EndingAr MONEY,                        
		Units INT,                        
		ColPercent MONEY                        
	)  
	
	DECLARE @uidFilter VARCHAR(MAX)
	DECLARE @ledgerGroupingForeignTableNameColumnName VARCHAR(255)
	DECLARE @ledgerGroupingForeignTableName VARCHAR(255)
	DECLARE @ledgerGroupingForeignTableUidColumnName VARCHAR(255)
	DECLARE @ledgerGroupingUidColumnName VARCHAR(255)
	IF (@groupBy = 'Financial Center')
	BEGIN
		SELECT @ledgerGroupingForeignTableNameColumnName = 'Name', @ledgerGroupingForeignTableName = 'FinancialCenter'
		SELECT @ledgerGroupingForeignTableUidColumnName = 'FinancialCenterUid', @ledgerGroupingUidColumnName = 'FinancialCenterUid'
		SELECT @uidFilter = @financialCenterUidList
	END
	ELSE IF (@groupBy = 'Service Site')
	BEGIN
		SELECT @ledgerGroupingForeignTableNameColumnName = 'Name', @ledgerGroupingForeignTableName = 'ListServiceSite'
		SELECT @ledgerGroupingForeignTableUidColumnName = 'ServiceSiteUid', @ledgerGroupingUidColumnName = 'ServiceSiteUid'
		SELECT @uidFilter = @serviceSiteUidList
	END
	ELSE IF (@typeofProviders = 'Claiming Providers')
	BEGIN
		SELECT @ledgerGroupingForeignTableNameColumnName = 'FullName', @ledgerGroupingForeignTableName = 'ViewProvider'
		SELECT @ledgerGroupingForeignTableUidColumnName = 'PersonUid'
		SELECT @ledgerGroupingUidColumnName = 'ClaimingProviderUid', @uidFilter = @providerUidList
	END
	ELSE 
	BEGIN
		SELECT @ledgerGroupingForeignTableNameColumnName = 'FullName', @ledgerGroupingForeignTableName = 'ViewProvider'
		SELECT @ledgerGroupingForeignTableUidColumnName = 'PersonUid'
		SELECT @ledgerGroupingUidColumnName = 'RenderingProviderUid', @uidFilter = @providerUidList
	END

	SELECT @glDateFrom = cast(convert(varchar, @glDateFrom, 101) + ' 12:00:00' AS datetime)
	SELECT @glDateTo = cast(convert(varchar, @glDateTo, 101) + ' 12:00:00' AS datetime)
	
	CREATE TABLE  #tempDateTable
	(
		StartDate DATETIME,
		EndDate DATETIME,
		MonthlyGroup VARCHAR(50)
	)
	DECLARE @tempDate DATETIME
	SET @tempDate= @glDateFrom - DATEPART(day,@glDateFrom) + 1
	IF (@monthlyView=0)
		INSERT INTO #tempDateTable VALUES (@glDateFrom,  @glDateTo,
			CAST(DATENAME(MONTH,(@glDateFrom)) as varchar(20)) + ' ' + CAST(YEAR(@glDateFrom) as varchar(4)))
	ELSE
	BEGIN
		WHILE @tempdate <= @glDateTo
		BEGIN
			INSERT INTO #tempDateTable VALUES (@tempDate, DATEADD(MONTH,1,@tempdate),
				CAST(DATENAME(MONTH,(@tempdate)) as varchar(20)) + ' ' + CAST(YEAR(@tempdate) as varchar(4)))
			SET @tempdate = DATEADD(MONTH,1,@tempdate)
		END
		UPDATE #tempDateTable SET StartDate = @glDateFrom WHERE StartDate = (SELECT TOP 1 StartDate FROM #tempDateTable ORDER BY StartDate ASC)
		UPDATE #tempDateTable SET EndDate = @glDateTo WHERE EndDate = (SELECT TOP 1 EndDate FROM #tempDateTable ORDER BY EndDate DESC)
	END
	
	DECLARE @sql VARCHAR(MAX)
	
	DECLARE @sqlGroupingValues VARCHAR(MAX)
	SELECT @sqlGroupingValues = 'INSERT INTO #financialSummmary (LineItemName, LineItemUid, MonthlyGroup, StartDate, EndDate) ' + 
		' SELECT	LIT.<<<LedgerGroupingForeignTableNameColumnName>>>, LIT.<<<LedgerGroupingForeignTableUidColumnName>>>, ' + 
			' TDT.MonthlyGroup, TDT.StartDate, TDT.EndDate ' +
			' FROM <<<LedgerGroupingForeignTableName>>> LIT, #tempDateTable TDT ' +
			' WHERE LIT.Inactive = 0 ' 
		IF (NOT @uidFilter IS NULL) 
			SELECT @sqlGroupingValues = @sqlGroupingValues + ' AND LIT.<<<LedgerGroupingForeignTableUidColumnName>>> ' +
				' IN (SELECT Element FROM Split(''' + @uidFilter + ''', '',''))' 
	SELECT @sqlGroupingValues = @sqlGroupingValues + ' ORDER BY LIT.<<<LedgerGroupingForeignTableNameColumnName>>>'	
			
	-- LINE ITEMS
	SELECT @sql = REPLACE(@sqlGroupingValues, '<<<LedgerGroupingForeignTableNameColumnName>>>', @ledgerGroupingForeignTableNameColumnName)
	SELECT @sql = REPLACE(@sql, '<<<LedgerGroupingForeignTableName>>>', @ledgerGroupingForeignTableName)
	SELECT @sql = REPLACE(@sql, '<<<LedgerGroupingForeignTableUidColumnName>>>', @ledgerGroupingForeignTableUidColumnName)
	EXEC (@sql)
	
	DECLARE @sqlCalcInner VARCHAR(MAX)
	SELECT @sqlCalcInner = ' FROM AR_LedgerDetail LD ' +
								' INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid ' +
								' INNER JOIN ARBatch ARB ON L.ArBatchUid = ARB.ARBatchUid ' 
	DECLARE @sqlCalcFilter VARCHAR(MAX)
	SELECT @sqlCalcFilter = ''
	IF (NOT @financialCenterUidList IS NULL)
		SELECT @sqlCalcFilter = @sqlCalcFilter + ' AND LD.FinancialCenterUid IN (SELECT Element FROM Split(''' + @financialCenterUidList + ''', '',''))'
	ELSE IF (NOT @serviceSiteUidList IS NULL)
		SELECT @sqlCalcFilter = @sqlCalcFilter + ' AND LD.FinancialCenterUid IN (SELECT Element FROM Split(''' + @financialCenterUidList + ''', '',''))'
	ELSE IF (NOT @providerUidList IS NULL)
	BEGIN
		IF (@typeofProviders = 'Rendering Providers')
			SELECT @sqlCalcFilter = @sqlCalcFilter + ' AND LD.RenderingProviderUid IN (SELECT Element FROM Split(''' + @providerUidList + ''', '',''))'	
		ELSE
			SELECT @sqlCalcFilter = @sqlCalcFilter + ' AND LD.ClaimingProviderUid IN (SELECT Element FROM Split(''' + @providerUidList + ''', '',''))'	
	END
	
	DECLARE @sqlTest VARCHAR(MAX)
	SELECT @sqlTest = ' UPDATE #financialSummmary SET ' +
						' #financialSummmary.BeginingAr = (SELECT SUM(Amount) ' + @sqlCalcInner +
							' WHERE LD.<<<LedgerGroupingUidColumnName>>> = #financialSummmary.LineItemUid ' +
								' AND ARB.GLDate < #financialSummmary.StartDate ' + @sqlCalcFilter + ' ), ' +
						' #financialSummmary.EndingAr = (SELECT SUM(Amount) ' + @sqlCalcInner +
							' WHERE LD.<<<LedgerGroupingUidColumnName>>> = #financialSummmary.LineItemUid ' +
								' AND ARB.GLDate <= #financialSummmary.EndDate ' + @sqlCalcFilter + ' ), ' +
						' #financialSummmary.Charges = (SELECT SUM(CASE WHEN L.EntryType=1 THEN ISNULL(LD.Amount,0) ELSE 0 END) ' + @sqlCalcInner +
							' WHERE LD.<<<LedgerGroupingUidColumnName>>> = #financialSummmary.LineItemUid ' +
								' AND ARB.GLDate >= #financialSummmary.StartDate AND ARB.GLDate <= #financialSummmary.EndDate ' + @sqlCalcFilter + ' ), ' +
						' #financialSummmary.Receipts = (SELECT SUM(CASE WHEN L.EntryType=2 THEN ISNULL(LD.Amount,0) ELSE 0 END) '  + @sqlCalcInner +
							' WHERE LD.<<<LedgerGroupingUidColumnName>>> = #financialSummmary.LineItemUid ' +
								' AND ARB.GLDate >= #financialSummmary.StartDate AND ARB.GLDate <= #financialSummmary.EndDate ' + @sqlCalcFilter + ' ), '  +
						' #financialSummmary.Adjustments = (SELECT SUM(CASE WHEN L.EntryType=3 THEN ISNULL(LD.Amount,0) ELSE 0 END) '  + @sqlCalcInner ++
							' WHERE LD.<<<LedgerGroupingUidColumnName>>> = #financialSummmary.LineItemUid ' +
								' AND ARB.GLDate >= #financialSummmary.StartDate AND ARB.GLDate <= #financialSummmary.EndDate ' + @sqlCalcFilter + ' ), ' +
						' #financialSummmary.Units = (SELECT COUNT(LD.Amount) '  + @sqlCalcInner +
							' WHERE LD.<<<LedgerGroupingUidColumnName>>> = #financialSummmary.LineItemUid ' +
								' AND ARB.GLDate >= #financialSummmary.StartDate AND ARB.GLDate <= #financialSummmary.EndDate ' + @sqlCalcFilter + ' ) ' 
								
	SELECT @sqlTest = REPLACE(@sqlTest, '<<<LedgerGroupingUidColumnName>>>', @ledgerGroupingUidColumnName)
	EXEC(@sqlTest)
	
	CLEANUP:

	UPDATE #financialSummmary SET BeginingAr = ISNULL(BeginingAr,0), Charges = ISNULL(Charges,0),
		Receipts = ISNULL(Receipts,0), Adjustments = ISNULL(Adjustments,0), EndingAr = ISNULL(EndingAr,0)
		
	SELECT * FROM #financialSummmary
	
	DROP TABLE #tempDateTable
	DROP TABLE #financialSummmary


/*
	EXEC dbo.[AR_RPT_FinancialSummary] 'Provider', 'Rendering Providers',
	 '01/01/2009', '12/31/2009'
	EXEC dbo.[AR_RPT_FinancialSummary] 'Provider', 'Claiming Providers',
	 '01/01/2009', '12/31/2009', 1
	 
	EXEC dbo.[AR_RPT_FinancialSummary] 'Provider', 'Rendering Providers',
	 '09/14/2009', '09/14/2009'
	 
	 	EXEC dbo.[AR_RPT_FinancialSummary] 'Service Site', '',
	 '09/14/2008', '09/14/2009', 1, null, null, 'DFEBC04D-F47C-490A-81DF-05F74FA31D0E,C013035A-364C-4739-8F81-5743035D89A1'
	 
EXEC dbo.[MDOL_RPT2_FinancialSummary] '01/01/2009', '12/31/2009', 'Claiming Providers', null, null, null, 1

select * from listservicesite

*/


END







GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SetDepositAggregate]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SetDepositAggregate] AS' 
END
GO

ALTER PROCEDURE [dbo].[AR_SetDepositAggregate] 
(
@depositUid UNIQUEIDENTIFIER = NULL
)
AS
RETURN -- no longer needed


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SetSuperbillAggregate]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SetSuperbillAggregate] AS' 
END
GO



ALTER PROCEDURE [dbo].[AR_SetSuperbillAggregate] 
(
	@superbillUids VARCHAR(MAX) = NULL,
	@superbillProcedureUids VARCHAR(MAX) = NULL,
	@ledgerDetailUids VARCHAR(MAX) = NULL,
	@arbatchUids VARCHAR(MAX) = NULL,
	@transactionUids VARCHAR(MAX) = NULL,
	@accountInsuranceUids VARCHAR(MAX) = NULL,
	@processAll BIT = NULL
)
AS

-- this should be getting called ONLY by AR_SetFinancialAggregates

DECLARE @uidFilter TABLE
(
	TableUid UNIQUEIDENTIFIER NOT NULL
);
DECLARE @superbillFilter TABLE
(
	SuperbillUid UNIQUEIDENTIFIER NOT NULL
);

-- strip uids into variable table
DECLARE @uidList VARCHAR(MAX);
SELECT @uidList = COALESCE(@superbillUids, @superbillProcedureUids, @ledgerDetailUids, 
		@arbatchUids, @transactionUids, @accountInsuranceUids,'');
IF (LEN(@uidList)>0)
	INSERT INTO @uidFilter (TableUid)
	SELECT Element AS TableUid
		FROM dbo.Split(@uidList,',');

IF NOT(@superbillUids IS NULL)
	INSERT INTO @superbillFilter
	SELECT TableUid 
		FROM @uidFilter UF
			INNER JOIN Superbill SB WITH (NOLOCK) ON UF.TableUid = SB.SuperbillUid
		WHERE NOT SB.SuperbillUid IS NULL;

IF NOT(@superbillProcedureUids IS NULL)
	INSERT INTO @superbillFilter
	SELECT SBP.SuperbillUid 
		FROM @uidFilter UF
			INNER JOIN SuperbillProcedure SBP WITH (NOLOCK) ON UF.TableUid = SBP.SuperbillProcedureUid
		WHERE NOT SBP.SuperbillUid  IS NULL;
				
IF NOT(@ledgerDetailUids IS NULL)
	INSERT INTO @superbillFilter
	SELECT SBP.SuperbillUid 
		FROM @uidFilter UF 
			INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON UF.TableUid = LD.LedgerDetailUid
			INNER JOIN SuperbillProcedure SBP WITH (NOLOCK) ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		WHERE NOT SBP.SuperbillUid  IS NULL;
			
			
IF NOT(@arbatchUids IS NULL)
	INSERT INTO @superbillFilter
	SELECT SBP.SuperbillUid 
		FROM @uidFilter UF 
			INNER JOIN ARBatch ARB WITH (NOLOCK) ON UF.TableUid = ARB.ARBatchUid
			INNER JOIN AR_Ledger L WITH (NOLOCK)  ON ARB.ARBatchUid = L.ARBatchUid
			INNER JOIN AR_LedgerDetail LD WITH (NOLOCK)  ON L.LedgerUid = LD.LedgerUid
			INNER JOIN SuperbillProcedure SBP WITH (NOLOCK)  ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		WHERE NOT SBP.SuperbillUid  IS NULL;
			
IF NOT(@transactionUids IS NULL)
	INSERT INTO @superbillFilter
	SELECT SBP.SuperbillUid 
		FROM @uidFilter UF 
			INNER JOIN AR_Transaction TR WITH (NOLOCK) ON UF.TableUid = TR.TransactionUid
			INNER JOIN AR_Ledger L WITH (NOLOCK) ON TR.TransactionUid = L.TransactionUid
			INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON L.LedgerUid = LD.LedgerUid
			INNER JOIN SuperbillProcedure SBP WITH (NOLOCK) ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		WHERE NOT SBP.SuperbillUid  IS NULL;

IF NOT(@accountInsuranceUids IS NULL)
	INSERT INTO @superbillFilter
	SELECT SB.SuperbillUid 
		FROM @uidFilter UF 
			INNER JOIN AccountInsurance AI WITH (NOLOCK) ON UF.TableUid = AI.AccountInsuranceUid
			INNER JOIN AccountPeriod AP WITH (NOLOCK) ON AI.AccountPeriodUid = AP.AccountPeriodUid
			INNER JOIN Superbill SB WITH (NOLOCK) ON AP.AccountUid = SB.AccountUid
		WHERE NOT SB.SuperbillUid  IS NULL;

IF NOT EXISTS(SELECT * FROM @superbillFilter) -- if empty, then return except if wish to process all
BEGIN
	IF (@processAll=1)
		INSERT INTO @superbillFilter
			SELECT SuperbillUid FROM Superbill WITH (NOLOCK);
	ELSE
		RETURN;
END

SELECT DISTINCT SuperbillUid
	INTO #distinctSuperbillFilter	
	FROM @superbillFilter;

SELECT SBP.SuperbillUid, SBP.SuperbillProcedureUid, LD.LiabilityOwner, SUM(LD.Amount) AS Balance
	INTO #currentLiabilityOwnerAndCarrierSub 
	FROM #distinctSuperbillFilter SF 
		INNER JOIN SuperbillProcedure SBP WITH (NOLOCK) ON SF.SuperbillUid = SBP.SuperbillUid   
		INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid
	GROUP BY SBP.SuperbillUid, SBP.SuperbillProcedureUid, LD.LiabilityOwner;

	
SELECT SuperbillUid, ISNULL(LiabilityOwner,0) AS LiabilityOwner, SUM(ISNULL(Balance,0)) AS Balance, 
		CASE WHEN ISNULL(LiabilityOwner,0) > 0 THEN ISNULL(CLOCS.LiabilityOwner,0) ELSE 10000000 END AS SortOrder,
		CASE WHEN ISNULL(LiabilityOwner,0) > 0 AND SUM(ISNULL(CLOCS.Balance,0))<>0 THEN 1 -- preferred
			WHEN ISNULL(LiabilityOwner,0) > 0 THEN 2 -- next
			ELSE 3 -- finally
		END AS Preference 
	INTO #sortedSuperbillBalancesByLiability
	FROM #currentLiabilityOwnerAndCarrierSub CLOCS  
	GROUP BY CLOCS.SuperbillUid, ISNULL(CLOCS.LiabilityOwner,0)
	HAVING SUM(ISNULL(Balance,0)) <> 0; -- not interested in zero balance records


SELECT SB.SuperbillUid, ISNULL(PA.LiabilityOwner,0) AS CurrentLiabilityOwner, 
		CASE WHEN ISNULL(PA.LiabilityOwner,0) > 0 AND ISNULL(PA.Balance,0) <> 0 THEN PA.LiabilityOwner 
			WHEN NOT SB.CurrentCarrierOverride IS NULL AND SB.CurrentCarrierOverride > 0 THEN SB.CurrentCarrierOverride
			WHEN EXISTS(SELECT SuperbillUid FROM ViewSuperbillInsurance WHERE SuperbillUid = SB.SuperbillUid AND DisplayOrder=1) THEN 1
			ELSE NULL END AS CurrentCarrier
	INTO #currentLiabilityOwnerAndCarrier
	FROM Superbill SB WITH (NOLOCK)
		INNER JOIN #distinctSuperbillFilter SF ON SB.SuperbillUid = SF.SuperbillUid
		LEFT JOIN (SELECT VS.SuperbillUid, VS.LiabilityOwner, VS.Balance,
							ROW_NUMBER() OVER (PARTITION BY VS.SuperbillUid ORDER BY VS.SuperbillUid, VS.Preference, VS.SortOrder) AS RankOrder
						FROM #sortedSuperbillBalancesByLiability VS
				   ) PA ON SB.SuperbillUid = PA.SuperbillUid  
	WHERE ISNULL(PA.RankOrder,1) = 1; -- CurrentLiabilityOwner

SELECT CASE WHEN VLB.LiabilityOwner=0 THEN 0 ELSE 1 END AS IsInsurancePayer,
						VLB.Amount, SBP.SuperbillUid, VLB.GLDate, VLB.InsurancePayerUid, VLB.TransactionUid
					INTO #distributionAggregate
					FROM AR_ViewLedgerBase_RestrictedUse VLB WITH (NOEXPAND)
						INNER JOIN SuperbillProcedure SBP WITH (NOLOCK) ON VLB.SuperbillProcedureUid = SBP.SuperbillProcedureUid
						INNER JOIN #distinctSuperbillFilter TA ON SBP.SuperbillUid = TA.SuperbillUid
					WHERE VLB.EntryType = 2 -- distribution
						AND NOT VLB.SuperbillProcedureUid IS NULL;

SELECT GLDate AS EffectiveDate, 0-VTA.PatientDistribution AS PatientDistribution, 0-VTA.InsDistribution AS InsDistribution, 
			SuperbillUid, IsInsurancePayer, InsurancePayerUid
		INTO #lastDistributions
	FROM (SELECT GLDate, Amount, SuperbillUid, IsInsurancePayer, InsurancePayerUid, TransactionUid, 
				ROW_NUMBER() OVER (PARTITION BY SuperbillUid, IsInsurancePayer ORDER BY GLDate DESC) As RowNumber
			FROM #distributionAggregate AG) AGO
		INNER JOIN AR_ViewTransactionAggregateSub VTA ON AGO.TransactionUid = VTA.TransactionUid
	WHERE RowNumber = 1;

		
SELECT LedgerDetailUid, IsCredit, L.LedgerUid, L.EntryType, L.VoidLedgerUid, LD.SuperbillProcedureUid, 
		FinancialCenterUid, ServiceSiteUid, ClaimingProviderUid, RenderingProviderUid,L.ArBatchUid  
	INTO #superbillAttributeRecords 
	FROM AR_LedgerDetail LD WITH (NOLOCK)   
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid 
		INNER JOIN SuperbillProcedure SBP WITH (NOLOCK) ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		INNER JOIN #distinctSuperbillFilter DSF ON SBP.SuperbillUid = DSF.SuperbillUid
		LEFT JOIN AR_Ledger VL WITH (NOLOCK) ON L.LedgerUid = VL.VoidLedgerUid   
	WHERE ((L.EntryType = 1 AND LD.IsCredit = 0) OR (L.EntryType = 4 AND LD.IsCredit = 0)) AND  -- consider both charge and (xfer if no charge) - see bug 25797
		L.VoidLedgerUid IS NULL AND VL.LedgerUid IS NULL;

	
SELECT DISTINCT SB.SuperbillUid, 
         CASE WHEN NOT VSFDS.FinancialCenterUid IS NULL THEN 3  
                  WHEN NOT V.FinancialCenterUid IS NULL THEN 2 
                  WHEN NOT AP.FinancialCenterUid IS NULL THEN 1 
                  WHEN NOT SB.DefaultFinancialCenterUid IS NULL THEN 0 
            END AS Priority,
			CASE WHEN VSFDS.EntryType = 1 THEN 1 ELSE 0 END AS EntryTypePriority,
       COALESCE(VSFDS.FinancialCenterUid,V.FinancialCenterUid, AP.FinancialCenterUid, SB.DefaultFinancialCenterUid) AS FinancialCenterUid, 
       COALESCE(VSFDS.ServiceSiteUid,V.ServiceSiteUid, AP.ServiceSiteUid, SB.DefaultServiceSiteUid) AS ServiceSiteUid, 
       COALESCE(VSFDS.ClaimingProviderUid,V.ProviderUid, AP.ProviderUid, SB.DefaultClaimingProviderUid) AS ClaimingProviderUid, 
       COALESCE(VSFDS.RenderingProviderUid,V.RenderingProviderUid, AP.ProviderUid, SB.DefaultRenderingProviderUid) AS RenderingProviderUid
	INTO #prioritySuperbillAttributeRecords
	FROM Superbill SB WITH (NOLOCK) 
		   INNER JOIN #distinctSuperbillFilter DSF ON SB.SuperbillUid = DSF.SuperbillUid
		   LEFT JOIN SuperbillProcedure SBP WITH (NOLOCK) ON SB.SuperbillUid = SBP.SuperbillUid
		   LEFT JOIN #superbillAttributeRecords VSFDS ON SBP.SuperbillProcedureUid = VSFDS.SuperbillProcedureUid
		   LEFT JOIN Visit V WITH (NOLOCK) ON SB.VisitUid = V.VisitUid
		   LEFT JOIN Appointment AP WITH (NOLOCK) ON SB.AppointmentUid = AP.AppointmentUid;

		   
SELECT SuperbillUid, MAX(priority) AS Priority, MAX(EntryTypePriority) AS EntryTypePriority
	INTO #maxPrioritySuperbillAttributeRecords
	FROM #prioritySuperbillAttributeRecords
	GROUP BY SuperbillUid;

	
SELECT DISTINCT P.* 
	INTO #superbillFinancialDetails
	FROM #prioritySuperbillAttributeRecords P
      INNER JOIN #maxPrioritySuperbillAttributeRecords M ON P.SuperbillUid = M.SuperbillUid
	WHERE  P.Priority = M.Priority AND P.EntryTypePriority = M.EntryTypePriority;

	
INSERT INTO SuperbillAggregate  (SuperbillUid)
	SELECT SF.SuperbillUid
		FROM #distinctSuperbillFilter SF
			LEFT JOIN SuperbillAggregate SA WITH (NOLOCK) ON SF.SuperbillUid = SA.SuperbillUid
		WHERE SA.SuperbillUid IS NULL;

SELECT SA.*
	INTO #tempSuperbillAggregate
	FROM SuperbillAggregate SA WITH (NOLOCK)
		INNER JOIN #distinctSuperbillFilter DSF ON SA.SuperbillUid = DSF.SuperbillUid;

UPDATE #tempSuperbillAggregate -- clear existing
	SET LastPatientPaymentDate = null, LastPatientPaymentAmount = 0,
		LastInsurancePaymentDate = null, LastInsurancePaymentAmount = 0, LastInsurancePaymentCarrierUid = null,
		CurrentLiabilityOwner = 0, CurrentCarrier = 0,
		LastModifiedDate = GETUTCDATE()
	FROM #tempSuperbillAggregate 
		INNER JOIN #distinctSuperbillFilter TA ON #tempSuperbillAggregate.SuperbillUid = TA.SuperbillUid;

	
UPDATE #tempSuperbillAggregate -- patient payment
		SET LastPatientPaymentDate = LASTDIST.EffectiveDate, LastPatientPaymentAmount = LASTDIST.PatientDistribution
	FROM #tempSuperbillAggregate 
		INNER JOIN (SELECT * FROM #lastDistributions WHERE IsInsurancePayer = 0) LASTDIST ON #tempSuperbillAggregate.SuperbillUid = LASTDIST.SuperbillUid;

	
UPDATE #tempSuperbillAggregate -- insurance payment
		SET LastInsurancePaymentDate = LASTDIST.EffectiveDate, LastInsurancePaymentAmount = LASTDIST.InsDistribution,
			LastInsurancePaymentCarrierUid = LASTDIST.InsurancePayerUid
	FROM #tempSuperbillAggregate
		INNER JOIN (SELECT * FROM #lastDistributions WHERE IsInsurancePayer = 1) LASTDIST ON #tempSuperbillAggregate.SuperbillUid = LASTDIST.SuperbillUid;

	
UPDATE #tempSuperbillAggregate
	SET CurrentLiabilityOwner = CLOC.CurrentLiabilityOwner,
		CurrentCarrier = CLOC.CurrentCarrier
	FROM #tempSuperbillAggregate SA
		INNER JOIN #currentLiabilityOwnerAndCarrier CLOC ON SA.SuperbillUid = CLOC.SuperbillUid;

	
UPDATE #tempSuperbillAggregate
	SET FinancialCenterUid = SFD.FinancialCenterUid,
		ServiceSiteUid = SFD.ServiceSiteUid,
		ClaimingProviderUid = SFD.ClaimingProviderUid,
		RenderingProviderUid = SFD.RenderingProviderUid
	FROM #tempSuperbillAggregate SA
		INNER JOIN #superbillFinancialDetails SFD ON SA.SuperbillUid = SFD.SuperbillUid;

		
UPDATE      sa
      SET         AccountPeriodUid = ap.AccountPeriodUid,
                  PrimaryInsurancePlanUid = pipp.InsurancePlanUid,
    CurrentInsurancePlanUid = pipc.InsurancePlanUid,
                  LiabilityOwner = ss.InsuranceOrder
      FROM  #distinctSuperbillFilter SF
  INNER JOIN Superbill s WITH (NOLOCK) ON SF.SuperbillUid = S.SuperbillUid
       INNER JOIN AccountPeriod ap WITH (NOLOCK) ON s.AccountUid = ap.AccountUid
   INNER JOIN #tempSuperbillAggregate sa ON s.SuperbillUid = sa.SuperbillUid
                  LEFT JOIN ListSuperbillStatus ss WITH (NOLOCK) ON s.SuperbillStatusUid = ss.SuperbillStatusUid
                  LEFT JOIN AccountInsurance aip WITH (NOLOCK) ON ap.AccountPeriodUid = aip.AccountPeriodUid AND aip.DisplayOrder = 1
                  LEFT JOIN PersonInsurancePlan pipp WITH (NOLOCK) ON aip.PersonInsurancePlanUid = pipp.PersonInsurancePlanUid
                  LEFT JOIN AccountInsurance aic WITH (NOLOCK) ON ap.AccountPeriodUid = aic.AccountPeriodUid AND (aic.DisplayOrder = sa.currentcarrier AND sa.currentcarrier > 0 OR aic.DisplayOrder = 1 AND sa.currentcarrier = 0)
                  LEFT JOIN PersonInsurancePlan pipc WITH (NOLOCK) ON aic.PersonInsurancePlanUid = pipc.PersonInsurancePlanUid
      WHERE (ap.EffectiveDate is null or ap.EffectiveDate <= s.ServiceDateEnd) AND
                  (ap.ExpirationDate is null or DATEADD(dd, 1, ap.ExpirationDate) > s.ServiceDateEnd);

------ FirstFiledDate
;with myCTE AS
(
	select sb.ExternalID, 
	cbd.SuperbillUid, 
	MIN(cb.ClaimDate) as MinClaimDate
	from ClaimBatchDetail cbd with (nolock)
	inner join Superbill sb with (nolock) on cbd.SuperbillUid = sb.SuperbillUid
	inner join ClaimBatch cb with (nolock) on cbd.ClaimBatchUid = cb.ClaimBatchUid
	inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid = sba.SuperbillUid
	inner join #distinctSuperbillFilter dsf on sb.superbilluid = dsf.SuperbillUid
	where sba.FirstFiledDate is null 
	and cb.Status is not null
	and cb.Status in ( 'SENT', 'Filed Primary', 'READY TO SEND', 'Filed' )
	and cb.ClaimDate < '2013-11-20'
	group by cbd.SuperbillUid, sb.ExternalID 
)        
Update #tempSuperbillAggregate
	Set FirstFiledDate = ct.MinClaimDate
	from #tempSuperbillAggregate sba
	inner join myCTE ct on sba.SuperbillUid = ct.SuperbillUid
	where FirstFiledDate IS NULL;

------ LastFiledDate

with myCTE AS
(
	select sb.ExternalID, 
	cbd.SuperbillUid, 
	MAX(cb.ClaimDate) as MaxClaimDate
	from ClaimBatchDetail cbd with (nolock)
	inner join Superbill sb with (nolock) on cbd.SuperbillUid = sb.SuperbillUid
	inner join ClaimBatch cb with (nolock) on cbd.ClaimBatchUid = cb.ClaimBatchUid
	inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid = sba.SuperbillUid
	inner join #distinctSuperbillFilter dsf on sb.superbilluid = dsf.SuperbillUid
	where sba.LastFiledDate is null 
	and cb.Status is not null
	and cb.Status in ( 'SENT', 'Filed Primary', 'READY TO SEND', 'Filed' )
	and cb.ClaimDate < '2013-11-20'
	group by cbd.SuperbillUid, sb.ExternalID 
)        
Update #tempSuperbillAggregate
	Set LastFiledDate = ct.MaxClaimDate
	from #tempSuperbillAggregate sba
	inner join myCTE ct on sba.SuperbillUid = ct.SuperbillUid
	where LastFiledDate IS NULL;

IF NOT EXISTS(
	SELECT * 
	FROM   SuperbillAggregate SA
		   INNER JOIN #tempSuperbillAggregate TSA
			 ON SA.SuperbillUid = TSA.SuperbillUid 
				AND EXISTS(SELECT SA.LiabilityOwner,  SA.CurrentInsurancePlanUid, SA.PrimaryInsurancePlanUid, SA.AccountPeriodUid, SA.RenderingProviderUid, SA.ClaimingProviderUid, 
								SA.ServiceSiteUid, SA.FinancialCenterUid, SA.CurrentCarrier, SA.CurrentLiabilityOwner, SA.LastInsurancePaymentCarrierUid, SA.LastInsurancePaymentAmount, 
								SA.LastInsurancePaymentDate, SA.LastPatientPaymentAmount, SA.LastPatientPaymentDate
						   EXCEPT 
						   SELECT TSA.LiabilityOwner,  TSA.CurrentInsurancePlanUid, TSA.PrimaryInsurancePlanUid, TSA.AccountPeriodUid, TSA.RenderingProviderUid, TSA.ClaimingProviderUid, 
								TSA.ServiceSiteUid, TSA.FinancialCenterUid, TSA.CurrentCarrier, TSA.CurrentLiabilityOwner, TSA.LastInsurancePaymentCarrierUid, TSA.LastInsurancePaymentAmount, 
								TSA.LastInsurancePaymentDate, TSA.LastPatientPaymentAmount, TSA.LastPatientPaymentDate)
			) -- end of outer EXISTS
	GOTO CLEANUP;


UPDATE SuperbillAggregate -- BMRSetSuperbillAggregate
	SET LastModifiedDate = GETUTCDATE(),
		LastPatientPaymentDate = #tempSuperbillAggregate.LastPatientPaymentDate, 
		LastPatientPaymentAmount = #tempSuperbillAggregate.LastPatientPaymentAmount,
		LastInsurancePaymentDate = #tempSuperbillAggregate.LastInsurancePaymentDate, 
		LastInsurancePaymentAmount = #tempSuperbillAggregate.LastInsurancePaymentAmount,
		LastInsurancePaymentCarrierUid = #tempSuperbillAggregate.LastInsurancePaymentCarrierUid,
		CurrentLiabilityOwner = #tempSuperbillAggregate.CurrentLiabilityOwner,
		CurrentCarrier = #tempSuperbillAggregate.CurrentCarrier,
		FinancialCenterUid = #tempSuperbillAggregate.FinancialCenterUid,
		ServiceSiteUid = #tempSuperbillAggregate.ServiceSiteUid,
		ClaimingProviderUid = #tempSuperbillAggregate.ClaimingProviderUid,
		RenderingProviderUid = #tempSuperbillAggregate.RenderingProviderUid,
		AccountPeriodUid = #tempSuperbillAggregate.AccountPeriodUid,
		PrimaryInsurancePlanUid = #tempSuperbillAggregate.PrimaryInsurancePlanUid,
		CurrentInsurancePlanUid = #tempSuperbillAggregate.CurrentInsurancePlanUid,
		LiabilityOwner = #tempSuperbillAggregate.LiabilityOwner,
		FirstFiledDate = #tempSuperbillAggregate.FirstFiledDate,
		LastFiledDate = #tempSuperbillAggregate.LastFiledDate
	FROM SuperbillAggregate 
		INNER JOIN #tempSuperbillAggregate ON SuperbillAggregate.SuperbillUid = #tempSuperbillAggregate.SuperbillUid;

CLEANUP:

DROP TABLE #distributionAggregate;
DROP TABLE #superbillFinancialDetails;
DROP TABLE #maxPrioritySuperbillAttributeRecords;
DROP TABLE #prioritySuperbillAttributeRecords;
DROP TABLE #superbillAttributeRecords;

DROP TABLE #distinctSuperbillFilter;
DROP TABLE #currentLiabilityOwnerAndCarrier;
DROP TABLE #currentLiabilityOwnerAndCarrierSub;
DROP TABLE #sortedSuperbillBalancesByLiability;
DROP TABLE #lastDistributions;

DROP TABLE #tempSuperbillAggregate;

/*
	DBCC DROPCLEANBUFFERS
	DBCC FREEPROCCACHE 
	
	EXEC AR_SetSuperbillAggregate @processAll = 1
	
	select * from superbill where superbilluid = '56859564-62D6-4E30-87D7-0095F0B577C5'
	SELECT * from superbillaggregate where superbilluid = '56859564-62D6-4E30-87D7-0095F0B577C5'
	DELETE from superbillaggregate where superbilluid = '56859564-62D6-4E30-87D7-0095F0B577C5' -- 99D49033-8E51-429A-B9A3-7D40B9A3543E
	EXEC AR_SetSuperbillAggregate @visitUids='99D49033-8E51-429A-B9A3-7D40B9A3543E'
*/






















GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SetFinancialAggregates]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SetFinancialAggregates] AS' 
END
GO

ALTER PROCEDURE [dbo].[AR_SetFinancialAggregates] 
(
	@superbillUids VARCHAR(MAX) = NULL,
	@superbillProcedureUids VARCHAR(MAX) = NULL,
	@ledgerDetailUids VARCHAR(MAX) = NULL,
	@arbatchUids VARCHAR(MAX) = NULL,
	@transactionUids VARCHAR(MAX) = NULL,
	@accountInsuranceUids VARCHAR(MAX) = NULL,
	@depositUids VARCHAR(MAX) = NULL
)
AS

IF (@superbillUids = NULL AND @superbillProcedureUids = NULL AND
		@ledgerDetailUids = NULL AND @arbatchUids = NULL AND
		@transactionUids = NULL AND @accountInsuranceUids = NULL AND
		@depositUids = NULL)
	RETURN -- not enough info, just return
	
IF NOT(@superbillUids IS NULL)
	BEGIN
		EXEC dbo.AR_SetSuperbillAggregate @superbillUids=@superbillUids
	END
ELSE IF NOT(@superbillProcedureUids IS NULL)
	BEGIN
		EXEC dbo.AR_SetSuperbillAggregate @superbillProcedureUids=@superbillProcedureUids
	END
ELSE IF NOT(@ledgerDetailUids IS NULL)
	BEGIN
		EXEC dbo.AR_SetSuperbillAggregate @ledgerDetailUids=@ledgerDetailUids
	END
ELSE IF NOT(@arbatchUids IS NULL)
	BEGIN
		EXEC dbo.AR_SetSuperbillAggregate @arbatchUids=@arbatchUids
	END
ELSE IF NOT(@transactionUids IS NULL)
	BEGIN
		EXEC dbo.AR_SetSuperbillAggregate @transactionUids=@transactionUids
	END
ELSE IF NOT(@accountInsuranceUids IS NULL)
	BEGIN
		EXEC dbo.AR_SetSuperbillAggregate @accountInsuranceUids=@accountInsuranceUids
	END
	
-- EXEC dbo.AR_SetDepositAggregate -- do this directly from LedgerDetails only

/*
	EXEC dbo.AR_SetFinancialAggregates @ledgerDetailUids = '3412FAE1-0AD7-4F26-891F-0018A6CA800D,A7E0BE84-5800-4E13-84AB-0031661855B7'
	SELECT TOP 10 * FROM AR_LedgerDetail
*/

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SetFinancialAggregates_Job]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SetFinancialAggregates_Job] AS' 
END
GO

ALTER PROCEDURE [dbo].[AR_SetFinancialAggregates_Job] 
AS
RETURN -- disable at this time


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SetSuperbillAggregate_ForReplication]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SetSuperbillAggregate_ForReplication] AS' 
END
GO

ALTER PROCEDURE [dbo].[AR_SetSuperbillAggregate_ForReplication] 
AS

/*
	We have gotten rid of the SetSuperbillAggregates job for Patch4 but need a job for Replication until SuperbillAggregate is LIVE
	Probably live by SP1 where we will remove this job
	Start by running every hour ... can adjust later if not needed ...
	Call it AggregatesJob_Replication ... plan is to create the job manually
*/

EXEC AR_SetSuperbillAggregate @processAll=1


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SmallBalanceWriteoff_WriteoffAdjustmentFromProcedure]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SmallBalanceWriteoff_WriteoffAdjustmentFromProcedure] AS' 
END
GO


/*
     Need ability to write off small balances as adjustments
*/

ALTER PROC [dbo].[AR_SmallBalanceWriteoff_WriteoffAdjustmentFromProcedure]
     @superbillProcedureUid UNIQUEIDENTIFIER = NULL,
     @liabilityOwner INT = 0, -- default to patient
     @adjustmentCreditTypeUid UNIQUEIDENTIFIER = NULL,
     @transactionUid UNIQUEIDENTIFIER = NULL,
     @adjustmentAmount MONEY = 0,
     @arBatchUid UNIQUEIDENTIFIER = NULL
AS
BEGIN

DECLARE @chargeLedgerDetailUid UNIQUEIDENTIFIER
DECLARE @ledgerUidNew UNIQUEIDENTIFIER
DECLARE @sourceLedgerQuantity INT

IF @superbillProcedureUid IS NULL OR NOT EXISTS(SELECT SuperbillProcedureUid FROM SuperbillProcedure WHERE SuperbillProcedureUid = @superbillProcedureUid)
BEGIN
     PRINT 'Invalid SuperbillProcedure specified'
     RETURN
END

IF @transactionUid IS NULL OR NOT EXISTS(SELECT TransactionUid FROM AR_Transaction WHERE TransactionUid = @transactionUid)
BEGIN
     PRINT 'Invalid Transaction specified'
     RETURN
END

IF NOT EXISTS(SELECT CreditTypeUid FROM ListCreditType WHERE (TransactionTypeUid IN ('DFE2CDCD-F156-4C5C-A56E-52D7CD3105D3','9CCEB99C-727A-48FD-9474-F91F14F22A97')) AND CreditTypeUid = @adjustmentCreditTypeUid)
BEGIN
     PRINT 'Invalid AdjustmentCreditType specified'
     RETURN
END

IF @arBatchUid IS NULL OR NOT EXISTS(SELECT ARBatchUid FROM ARBatch WHERE ARBatchUid = @arBatchUid AND IsLocked=0 AND IsClosed=0)
BEGIN
     PRINT 'Invalid ARBatch specified'
     RETURN
END

SELECT TOP 1 @chargeLedgerDetailUid = LD.LedgerDetailUid
     FROM AR_LedgerDetail LD
          INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
     WHERE L.EntryType IN (1,4)
          AND LD.SuperbillProcedureUid = @superbillProcedureUid 
          AND LD.LiabilityOwner = @liabilityOwner
     ORDER BY LD.CreatedDateTime DESC
     
IF (@chargeLedgerDetailUid IS NULL) -- nothing to adjust off of
     RETURN

SELECT @ledgerUidNew = NEWID()
INSERT INTO AR_Ledger(LedgerUid, EntryDate, ArBatchUid, TransactionUid, ShortName, EntryType, Quantity, CreatedDateTime, LastModifiedDate)
  SELECT  @ledgerUidNew, CAST(GETDATE() AS DATE), @arBatchUid, @transactionUid, 'Small Balance Writeoff Adjustment',
       3, @sourceLedgerQuantity, GETUTCDATE(), GETUTCDATE()
-- DEBIT
INSERT INTO AR_LedgerDetail(LedgerDetailUid, LedgerUid, Amount, LiabilityOwner, LedgerAccountUid, IncomeAccountUid,
       AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, InsurancePlanUid,
       RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, IsCredit, CreatedDateTime, LastModifiedDate)
  SELECT  NEWID(), @ledgerUidNew, @adjustmentAmount, NULL,  NULL, @adjustmentCreditTypeUid,
             NULL, NULL, NULL, NULL, NULL,
             RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, 0, GETUTCDATE(), GETUTCDATE()
       FROM AR_LedgerDetail WHERE LedgerDetailUid = @chargeLedgerDetailUid
-- CREDIT
INSERT INTO AR_LedgerDetail(LedgerDetailUid, LedgerUid, Amount, LiabilityOwner, LedgerAccountUid, IncomeAccountUid,
       AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, InsurancePlanUid,
       RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, IsCredit, CreatedDateTime, LastModifiedDate)
  SELECT  NEWID(), @ledgerUidNew, 0-@adjustmentAmount, LiabilityOwner,  LedgerAccountUid, @adjustmentCreditTypeUid,
             AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, InsurancePlanUid,
             RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, 1, GETUTCDATE(), GETUTCDATE()
       FROM AR_LedgerDetail WHERE LedgerDetailUid = @chargeLedgerDetailUid

END



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SmallBalanceWriteoff]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SmallBalanceWriteoff] AS' 
END
GO

/*
     Need ability to write off small balances as adjustments
*/


ALTER PROC [dbo].[AR_SmallBalanceWriteoff]
     @adjustmentCreditTypeUid UNIQUEIDENTIFIER = NULL,
     @writeoffRange MONEY = 0,
     @writeoffType INT = 2, -- 0 = Patient 1 = Insurance  
     @depositUid UNIQUEIDENTIFIER = NULL, -- filter for superbills with distributions from this 
     @processWriteoffs BIT = 0 -- 0 = just report 1 = actually process writeoffs
AS
BEGIN

IF NOT @depositUid IS NULL AND NOT EXISTS(SELECT DepositUid FROM Deposit WHERE DepositUid = @depositUid)
BEGIN
     PRINT 'Invalid Deposit specified'
     RETURN
END

IF NOT EXISTS(SELECT CreditTypeUid FROM ListCreditType WHERE IsAdjustment = 1 AND CreditTypeUid = @adjustmentCreditTypeUid)
BEGIN
     PRINT 'Invalid AdjustmentCreditType specified'
     RETURN
END

SELECT @writeoffRange = ABS(@writeoffRange)

DECLARE @adustmentCreditType VARCHAR(MAX)
SELECT @adustmentCreditType = Name FROM ListCreditType WHERE CreditTypeUid = @adjustmentCreditTypeUid
PRINT 'Writeoff Range: ' + CAST((0-@writeoffRange) AS VARCHAR(MAX)) + ' to ' + CAST(@writeoffRange AS VARCHAR(MAX))
     + ' using Adjustment Type: ' + @adustmentCreditType
     
SELECT * 
     INTO #superbillsWithSmallBalances
     FROM AR_ViewSuperbillAggregate
     WHERE  (ABS(LiabilityBalance-AssignedLiabilityBalance) <= @writeoffRange AND ABS(LiabilityBalance-AssignedLiabilityBalance)>0 AND @writeoffType = 0)
              OR (ABS(AssignedLiabilityBalance) <= @writeoffRange AND ABS(AssignedLiabilityBalance)>0 AND @writeoffType = 1)
SELECT * 
     INTO #superbillProceduresWithSmallBalances -- create blank temp table
     FROM AR_ViewSuperbillProcedureAggregate
     WHERE  SuperbillProcedureUid IS NULL
          
IF (NOT @depositUid IS NULL)
BEGIN 
     DELETE FROM #superbillsWithSmallBalances
          WHERE NOT SuperbillUid IN (
              SELECT SBP.SuperbillUid 
                   FROM AR_LedgerDetail LD 
                        INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
                        INNER JOIN AR_LedgerDetail LDOtherSide ON L.LedgerUid = LDOtherSide.LedgerUid AND LDOtherSide.LedgerDetailUid <> LD.LedgerDetailUid
                        INNER JOIN SuperbillProcedure SBP ON LDOtherSide.SuperbillProcedureUid = SBP.SuperbillProcedureUid
                   WHERE LD.DepositUid = @depositUid
                        AND L.EntryType = 2 -- Distribution
              )
END

SELECT 'AR_ViewSuperbillAggregate'
SELECT * FROM #superbillsWithSmallBalances

IF (@processWriteoffs = 1)
BEGIN
     DECLARE @newTransactionUid UNIQUEIDENTIFIER
     DECLARE @batchUid UNIQUEIDENTIFIER
     SELECT @batchUid = NEWID()
     INSERT INTO ARBatch(ARBatchUid, Name, Notes, 
              LastModifiedDate, GLDate, IsLocked, IsClosed, OwnerUID)
          VALUES (@batchUid,'Small Balance Writeoff ' + CAST(GetDate() As VarChar(25)),'Small Balance Writeoff',
               GETUTCDATE(),DATEADD(hh,12,CAST(GETUTCDATE() AS DATE)),0,0,NULL)
     
     DECLARE @superbillCurrentlyWorkingOnUid UNIQUEIDENTIFIER
     WHILE EXISTS(SELECT SuperbillUid FROM #superbillsWithSmallBalances)
     BEGIN
          SELECT TOP 1 @superbillCurrentlyWorkingOnUid = SuperbillUid
              FROM #superbillsWithSmallBalances

          SET @newTransactionUid = NEWID()
          INSERT INTO AR_Transaction (TransactionUid, ReferenceNumber, SuperbillUid, CreatedDateTime, LastModifiedDate)
              SELECT @newTransactionUid, 'Test SBA', @superbillCurrentlyWorkingOnUid,  GETUTCDATE(), GETUTCDATE()
              
          INSERT INTO #superbillProceduresWithSmallBalances
          SELECT * 
              FROM AR_ViewSuperbillProcedureAggregate
              WHERE  (ABS(LiabilityBalance-AssignedLiabilityBalance) > 0 AND ABS(LiabilityBalance-AssignedLiabilityBalance)>0 AND @writeoffType = 0)
                        OR (ABS(AssignedLiabilityBalance) > 0 AND ABS(AssignedLiabilityBalance)>0 AND @writeoffType = 1)

          DECLARE @superbillProcedureCurrentlyWorkingOnUid UNIQUEIDENTIFIER          
          DECLARE @adjustmentAmount MONEY       
          WHILE EXISTS (SELECT SuperbillProcedureUid FROM #superbillProceduresWithSmallBalances)
          BEGIN
               SELECT TOP 1 @superbillProcedureCurrentlyWorkingOnUid = SuperbillProcedureUid,
                   @adjustmentAmount = CASE WHEN @writeoffType = 0 THEN LiabilityBalance - AssignedLiabilityBalance
                        ELSE AssignedLiabilityBalance END 
                   FROM #superbillProceduresWithSmallBalances

              EXEC dbo.AR_SmallBalanceWriteoff_WriteoffAdjustmentFromProcedure
                   @superbillProcedureUid = @superbillProcedureCurrentlyWorkingOnUid,
                   @liabilityOwner  = @writeoffType, 
                   @adjustmentCreditTypeUid = @adjustmentCreditTypeUid,
                   @transactionUid = @newTransactionUid,
                   @adjustmentAmount = @adjustmentAmount,
                   @arBatchUid = @batchUid 
                   
              DELETE FROM #superbillProceduresWithSmallBalances
                   WHERE SuperbillProcedureUid = @superbillProcedureCurrentlyWorkingOnUid
          END
          
          DELETE FROM #superbillsWithSmallBalances
              WHERE SuperbillUid = @superbillCurrentlyWorkingOnUid
     END
     
     IF NOT (EXISTS(SELECT ARBatchUid FROM AR_Ledger WHERE ArBatchUid = @batchUid))
            DELETE FROM ARBatch WHERE ARBatchUid = @batchUid
END

DROP TABLE #superbillsWithSmallBalances

/*
     AR_SmallBalanceWriteoff 
          @adjustmentCreditTypeUid = '07329074-3AF5-46CB-8A01-FAD56DE1BAAA',
          @writeoffRange=1,
          @writeoffType = 0,
          @processWriteoffs = 1
     SELECT TOP 1 * FROM Superbill
     SELECT * FROM ListCreditType
     SELECT TOP 1 * FROM Deposit
     SELECT VSBPA.*
          FROM AR_ViewSuperbillAggregate VSBPA
              WHERE VSBPA.SuperbillUid = '26E0DFF6-5527-4D7B-9647-B4643235BF40'
     SELECT VSBPA.*
          FROM AR_ViewSuperbillProcedureAggregate VSBPA
              INNER JOIN SuperbillProcedure SBP ON VSBPA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
              WHERE SBP.SuperbillUid = '26E0DFF6-5527-4D7B-9647-B4643235BF40'
              
     BEGIN TRANSACTION
     EXEC dbo.AR_SmallBalanceWriteoff 
          @adjustmentCreditTypeUid = '07329074-3AF5-46CB-8A01-FAD56DE1BAAA',
          @writeoffRange=1,
          @writeoffType = 0,
          @processWriteoffs = 1
     SELECT VSBPA.*
          FROM AR_ViewSuperbillAggregate VSBPA
              WHERE VSBPA.SuperbillUid = '26E0DFF6-5527-4D7B-9647-B4643235BF40'
     ROLLBACK TRANSACTION              

*/

END








GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillAddNote]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SuperbillAddNote] AS' 
END
GO




ALTER PROCEDURE [dbo].[SuperbillAddNote]
(
	@externalId VARCHAR(100) = '',
	@superbillUid UNIQUEIDENTIFIER = NULL,
    @note varchar(MAX) = '',
	@currentUserUid UNIQUEIDENTIFIER = NULL
)
AS
BEGIN

	IF (@externalId!='')
		SELECT @superbillUid = SuperbillUid 
			FROM Superbill
			WHERE ExternalId = @externalId;
	
	IF NOT EXISTS(SELECT SuperbillUid FROM Superbill WHERE SuperbillUid = @superbillUid)
			OR (@note IS NULL OR @note='')
		RETURN;
	
	DECLARE @eReportDetailUid UNIQUEIDENTIFIER;
	DECLARE @patientUid UNIQUEIDENTIFIER;
	SELECT @eReportDetailUid = NEWID();
	SELECT @patientUid = PatientUid 
		FROM Superbill
		WHERE SuperbillUid = @superbillUid;
	
	INSERT INTO eReportDetails (eReportDetailUid, importDate, reportNumber, LastModifiedDate)
		SELECT @eReportDetailUid, GETUTCDATE(), 'SB Note', GETUTCDATE();
    
	INSERT INTO eReportRows (eReportRowUid, eReportDetailUid, ClaimReportStatusUid, SuperbillUid, PatientUid, 
			errorDescription, LastModifiedDate, LastModifiedByUid)
		SELECT NEWID(), @eReportDetailUid, '00000000-0000-0000-0000-000000000011', @superbillUid, @patientUid, 
			@note, GETUTCDATE(), @currentUserUid;

END

/*
	EXEC dbo.[SuperbillAddNote] @externalId = '798', @note = 'This is the note'
*/



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SuperbillBalanceWriteoff]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SuperbillBalanceWriteoff] AS' 
END
GO




ALTER PROC [dbo].[AR_SuperbillBalanceWriteoff]
	 @insuranceWriteoffCreditTypeUid UNIQUEIDENTIFIER = NULL,
	 @patientWriteoffCreditTypeUid UNIQUEIDENTIFIER = NULL,
	 @batchUid UNIQUEIDENTIFIER = NULL,
	 @superbillUidList VARCHAR(MAX) = '',
	 @throughAndIncludingSuperbillServiceDateStart DATETIME = NULL, -- if specified, will override superbillUidList
	 @financialCenterUidsToInclude VARCHAR(MAX) = '',
	 @processWriteoffs BIT = 0, -- 0 = just report 1 = actually process writeoffs
	 @currentUserUid UNIQUEIDENTIFIER = NULL,
	 @workstation VARCHAR(MAX) = NULL,
	 @SuperBillHistoryNote VARCHAR(2500) = NULL,
	 @SuperBillFollowup BIT = 0

AS
BEGIN

DISABLE TRIGGER ALL ON AR_Ledger;

IF (@insuranceWriteoffCreditTypeUid IS NULL) AND (@patientWriteoffCreditTypeUid IS NULL)
BEGIN
	 PRINT 'Either Insurance Or Patient Writeoff Type is required'
	 RETURN
END

IF (NOT @insuranceWriteoffCreditTypeUid IS NULL) AND
	(NOT EXISTS(SELECT CreditTypeUid FROM ListCreditType WHERE (TransactionTypeUid IN ('DFE2CDCD-F156-4C5C-A56E-52D7CD3105D3','9CCEB99C-727A-48FD-9474-F91F14F22A97')) AND CreditTypeUid = @insuranceWriteoffCreditTypeUid))
BEGIN
	 PRINT 'Invalid InsuranceWriteoffCreditTypeUid specified'
	 RETURN
END

IF (NOT @patientWriteoffCreditTypeUid IS NULL) AND
	(NOT EXISTS(SELECT CreditTypeUid FROM ListCreditType WHERE (TransactionTypeUid IN ('DFE2CDCD-F156-4C5C-A56E-52D7CD3105D3','9CCEB99C-727A-48FD-9474-F91F14F22A97')) AND CreditTypeUid = @patientWriteoffCreditTypeUid))
BEGIN
	 PRINT 'Invalid PatientWriteoffCreditTypeUid specified'
	 RETURN
END

IF NOT EXISTS(SELECT ArBatchUid FROM ArBatch WHERE ArBatchUid = @batchUid AND IsLocked=0 AND IsClosed = 0)
BEGIN
	 PRINT 'Invalid Batch specified'
	 RETURN
END

DECLARE @tempSuperbillUidsSelected TABLE
(
	SuperbillUid UNIQUEIDENTIFIER NOT NULL
)

IF (@throughAndIncludingSuperbillServiceDateStart IS NULL)
	INSERT INTO @tempSuperbillUidsSelected
	SELECT Element AS SuperbillUid
		FROM dbo.Split(@superbillUidList,',');
ELSE
	INSERT INTO @tempSuperbillUidsSelected
	SELECT SB.SuperbillUid
		FROM Superbill SB
			INNER JOIN AR_ViewSuperbillAggregate VSA ON SB.SuperbillUid = VSA.SuperbillUid
		WHERE SB.ServiceDateStart <= @throughAndIncludingSuperbillServiceDateStart
			AND (VSA.UnassignedLiabilityBalance<>0 OR VSA.AssignedLiabilityBalance<>0);

IF NOT EXISTS(SELECT * FROM @tempSuperbillUidsSelected)
BEGIN
	 PRINT 'No Superbills specified'
	 RETURN
END

--DECLARE @msg VARCHAR(MAX)
--SELECT @msg = Name FROM ListCreditType WHERE CreditTypeUid = @insuranceWriteoffCreditTypeUid
--SELECT 'Writeoff using Insurance Adjustment Type: ' + ISNULL(@msg,'<NA>') AS Insurance

--SELECT @msg = NULL
--SELECT @msg = Name FROM ListCreditType WHERE CreditTypeUid = @patientWriteoffCreditTypeUid
--SELECT 'Writeoff using Patient Adjustment Type: ' + ISNULL(@msg,'<NA>') AS Patient

--SELECT @msg = Name FROM ArBatch WHERE ArBatchUid = @batchUid
--SELECT 'Writeoff using Batch: ' + @msg AS Batch

SELECT VSBPA.SuperbillProcedureUid, VSBPA.AssignedLiabilityBalance, VSBPA.LiabilityBalance,
		SBP.SuperbillUid, SBA.CurrentLiabilityOwner, SB.PatientUid, LP.Code AS ProcedureCode, SB.ExternalID, SB.ServiceDateStart, SB.SuperbillStatusUid
	 INTO #tempSuperbillProceduresWithBalances
	 FROM AR_ViewSuperbillProcedureAggregate VSBPA
		INNER JOIN SuperbillProcedure SBP ON VSBPA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		INNER JOIN ListProcedure LP ON SBP.ProcedureUid = LP.ProcedureUid
		INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
		INNER JOIN (SELECT DISTINCT SuperbillUid FROM @tempSuperbillUidsSelected) SEIDSO ON SB.SuperbillUid = SEIDSO.SuperbillUid
		INNER JOIN SuperbillAggregate SBA ON SBP.SuperbillUid = SBA.SuperbillUid
	 WHERE VSBPA.LiabilityBalance > 0 -- with a balance

DECLARE @tempFinancialCenterUidsSelected TABLE
(
	FinancialCenterUid UNIQUEIDENTIFIER NOT NULL
)

IF (@financialCenterUidsToInclude<>'')
BEGIN
	INSERT INTO @tempFinancialCenterUidsSelected
	SELECT Element AS FinancialCenterUid
		FROM dbo.Split(@financialCenterUidsToInclude,',');
	DELETE FROM #tempSuperbillProceduresWithBalances
		WHERE NOT SuperbillProcedureUid IN
		(
			SELECT LD.SuperbillProcedureUid
				FROM AR_LedgerDetail LD
					INNER JOIN @tempFinancialCenterUidsSelected FC ON LD.FinancialCenterUid = FC.FinancialCenterUid
				WHERE NOT SuperbillProcedureUid IS NULL
		)
END

--SELECT '@tempSuperbillUidsSelected' AS Info, *
--	FROM @tempSuperbillUidsSelected

DECLARE @tempUpdatedSuperbills TABLE
(
		SuperbillUid UNIQUEIDENTIFIER NOT NULL,
		PatientUid    UNIQUEIDENTIFIER NOT NULL
)

DECLARE @tempSuperbills Table
(
   SuperbillUid UniqueIdentifier,
   ExternalID   varchar(25),
   PatientUid   UniqueIdentifier,
   ServiceDate  DateTime,
   OldAssignedLibility decimal(16,2),
   OldPatientLibility decimal(16,2),
   NewAssignedLibility decimal(16,2),
   NewPatientLibility decimal(16,2),
   OldSuperbillStatus varchar(100),
   NewSuperbillStatus varchar(100),
   InsuranceWriteoffCreditType varchar(100),
   PatientWriteoffCreditType varchar(100)
)

DECLARE @PatientCreditType varchar(100)
select @PatientCreditType  = ct.Name
  from ListCreditType ct
  where ct.CreditTypeUid = @patientWriteoffCreditTypeUid

DECLARE @InsuranceCreditType varchar(100)
select @InsuranceCreditType = ct.Name
  from ListCreditType ct
  where ct.CreditTypeUid = @insuranceWriteoffCreditTypeUid


--SELECT '#tempSuperbillProceduresWithBalances' AS Info,  * 	FROM #tempSuperbillProceduresWithBalances

IF (@processWriteoffs = 1) AND (EXISTS(SELECT SuperbillUid FROM #tempSuperbillProceduresWithBalances))
BEGIN
	 DECLARE @newTransactionUid UNIQUEIDENTIFIER
	 DECLARE @patientUid UNIQUEIDENTIFIER
	 DECLARE @currentLiabilityOwner INT
	 DECLARE @assignedLiability MONEY
	 DECLARE @patientLiability MONEY
	 DECLARE @assignedLiabilityOld MONEY
	 DECLARE @patientLiabilityOld MONEY
	 DECLARE @procedureCode VARCHAR(50)
	 DECLARE @historyNote VARCHAR(100)
	 DECLARE @startDate DateTime
	 DECLARE @superbillID VARCHAR(25)
     DECLARE @superbillStatusUidOld UNIQUEIDENTIFIER   
     DECLARE @superbillStatusUidNew UNIQUEIDENTIFIER
	 DECLARE @superbillCurrentlyWorkingOnUid UNIQUEIDENTIFIER

	 -- Only insert a history note if there is a note or if the follow up is set.
	 -- Use @InsertHistoryNote to detect this condition and make it more manageable in code below.
	 DECLARE @TODAY as DateTime
	 Set @TODAY = getutcdate()
	 DECLARE @ClaimReportStatusUid as UniqueIdentifier
	 SET @ClaimReportStatusUid = '00000000-0000-0000-0000-000000000011'

	 WHILE EXISTS(SELECT SuperbillUid FROM #tempSuperbillProceduresWithBalances)
	 BEGIN -- superbill loop
		  SELECT TOP 1 @superbillCurrentlyWorkingOnUid = SuperbillUid -- pick up SB to focus on next
			  FROM #tempSuperbillProceduresWithBalances

		  SET @newTransactionUid = NEWID()
		  INSERT INTO AR_Transaction (TransactionUid, ReferenceNumber, SuperbillUid, CreatedDateTime, LastModifiedDate)
			  SELECT @newTransactionUid, 'Superbill Balance Writeoff', @superbillCurrentlyWorkingOnUid,  GETUTCDATE(), GETUTCDATE()

		 SELECT @assignedLiabilityOld = AssignedLiabilityBalance, -- get starting superbill balances
						@patientLiabilityOld =  LiabilityBalance - AssignedLiabilityBalance
			   FROM AR_ViewSuperbillAggregate
			   WHERE SuperbillUid = @superbillCurrentlyWorkingOnUid

		  DECLARE @superbillProcedureCurrentlyWorkingOnUid UNIQUEIDENTIFIER
		  DECLARE @adjustmentAmount MONEY
		  WHILE EXISTS (SELECT SuperbillProcedureUid FROM #tempSuperbillProceduresWithBalances WHERE SuperbillUid = @superbillCurrentlyWorkingOnUid)
		  BEGIN -- superbill procedure loop
			--WAITFOR DELAY '00:00:01';
			   SELECT TOP 1 @superbillProcedureCurrentlyWorkingOnUid = SuperbillProcedureUid, -- pick up SBP to focus on next
						@assignedLiability = AssignedLiabilityBalance,
						@patientLiability =  LiabilityBalance - AssignedLiabilityBalance,
						@currentLiabilityOwner = CurrentLiabilityOwner,
						@procedureCode = ProcedureCode,
						@patientUid = PatientUid,
						@startDate = ServiceDateStart,
						@superbillID = ExternalID,
                        @superbillStatusUidOld = SuperbillStatusUid
					 FROM #tempSuperbillProceduresWithBalances
							   WHERE SuperbillUid = @superbillCurrentlyWorkingOnUid

			  --SELECT '@superbillProcedureCurrentlyWorkingOnUid', @superbillProcedureCurrentlyWorkingOnUid, 'INS', @assignedLiability, 'PAT', @patientLiability, 'CLO', @currentLiabilityOwner

			  IF (@assignedLiability<>0 AND NOT @insuranceWriteoffCreditTypeUid IS NULL)
				  EXEC dbo.AR_SmallBalanceWriteoff_WriteoffAdjustmentFromProcedure
					   @superbillProcedureUid = @superbillProcedureCurrentlyWorkingOnUid,
					   @liabilityOwner  = @currentLiabilityOwner,
					   @adjustmentCreditTypeUid = @insuranceWriteoffCreditTypeUid,
					   @transactionUid = @newTransactionUid,
					   @adjustmentAmount = @assignedLiability,
					   @arBatchUid = @batchUid

			  IF (@patientLiability<>0 AND NOT @patientWriteoffCreditTypeUid IS NULL)
				  EXEC dbo.AR_SmallBalanceWriteoff_WriteoffAdjustmentFromProcedure
					   @superbillProcedureUid = @superbillProcedureCurrentlyWorkingOnUid,
					   @liabilityOwner  = 0,
					   @adjustmentCreditTypeUid = @patientWriteoffCreditTypeUid,
					   @transactionUid = @newTransactionUid,
					   @adjustmentAmount = @patientLiability,
					   @arBatchUid = @batchUid

			  SELECT @historyNote = 'Superbill Balance Writeoff (' + @procedureCode + ')'
			  EXEC dbo.SuperbillAddNote @superbillUid = @superbillCurrentlyWorkingOnUid, @note = @historyNote, @currentUserUid = @currentUserUid

			  INSERT INTO @tempUpdatedSuperbills (SuperbillUid, PatientUid) values (@superbillCurrentlyWorkingOnUid, @patientUid)

			  IF @SuperBillHistoryNote IS NOT NULL
			  BEGIN
					DECLARE @eReportDetailUid uniqueidentifier
					DECLARE @eReportRowUid    uniqueidentifier
					SET     @eReportDetailUid = newid()
					SET     @eReportRowUid    = newid()
					INSERT INTO eReportDetails ( eReportDetailUid, importDate, reportNumber, LastModifiedByUid, LastModifiedDate)
					                    VALUES (@eReportDetailUid, @TODAY,     'SB Note',    @currentUserUid,   @TODAY)
					INSERT INTO eReportRows ( eReportRowUid,  eReportDetailUid,  ClaimReportStatusUid, superbillUid,                     patientUid, errorDescription,      LastModifiedByUid, LastModifiedDate, followUp)
					                 VALUES (@eReportRowUid, @eReportDetailUid, @ClaimReportStatusUid, @superbillCurrentlyWorkingOnUid, @PatientUid, @SuperBillHistoryNote, @currentUserUid,   @TODAY,           @SuperBillFollowup)
			  END

			  DELETE FROM #tempSuperbillProceduresWithBalances
				   WHERE SuperbillProcedureUid = @superbillProcedureCurrentlyWorkingOnUid
		  END -- superbill procedure loop

		SELECT @assignedLiability = AssignedLiabilityBalance, -- get superbill balances
				@patientLiability =  LiabilityBalance - AssignedLiabilityBalance
			FROM AR_ViewSuperbillAggregate
			WHERE SuperbillUid = @superbillCurrentlyWorkingOnUid

		IF (@assignedLiability = 0 AND @patientLiability = 0) -- all $0, set to complete
			UPDATE Superbill SET SuperbillStatusUid = '30F64D66-55CB-4438-BB2F-7A6250399312', LastModifiedDate = GETUTCDATE()
				WHERE SuperbillUid = @superbillCurrentlyWorkingOnUid
		ELSE IF (@assignedLiability = 0) -- insurance $0 but patient has balance, set to pendingpatient
			UPDATE Superbill SET SuperbillStatusUid = 'D2BF0F3C-6E03-478F-BDAE-4DCAC5EB9410', LastModifiedDate = GETUTCDATE()
				WHERE SuperbillUid = @superbillCurrentlyWorkingOnUid
										-- otherwise has insurance ... keep status

    SELECT @superbillStatusUidNew = sb.SuperbillStatusUid
    FROM Superbill sb
    WHERE sb.SuperbillUid = @superbillCurrentlyWorkingOnUid

    DECLARE @superbillStatusOld VARCHAR(100)
    DECLARE @superbillStatusNew VARCHAR(100)
    SELECT @superbillStatusOld = sbs.Name
    FROM ListSuperbillStatus sbs
    WHERE sbs.SuperbillStatusUid = @superbillStatusUidOld

    SELECT @superbillStatusNew = sbs.Name
    FROM ListSuperbillStatus sbs
    WHERE sbs.SuperbillStatusUid = @superbillStatusUidNew

		insert into @tempSuperbills (SuperbillUid, ExternalID, PatientUid, ServiceDate, OldAssignedLibility, OldPatientLibility, NewAssignedLibility, NewPatientLibility, OldSuperbillStatus, NewSuperbillStatus, InsuranceWriteoffCreditType, PatientWriteoffCreditType)
			values (@superbillCurrentlyWorkingOnUid, @superbillID, @patientUid, cast(@startDate as date), @assignedLiabilityOld, @patientLiabilityOld, @assignedLiability, @patientLiability, @superbillStatusOld, @superbillStatusNew, @InsuranceCreditType, @PatientCreditType)

	 END -- superbill loop

	declare @changes varchar(max)
	SELECT @changes =
	(
		select
		sb.SuperbillUid as 'audited/@primaryKey',
		sb.ExternalID as 'audited/SuperbillID/@new',
		dbo.UDF_getFormattedName(per.Prefix, per.FirstName, per.MiddleName, per.LastName, per.Suffix)   as 'audited/Patient/@new',
		cast(sb.ServiceDate as date) as 'audited/ServiceDate/@new',
		sb.OldPatientLibility as 'audited/PatientLibility/@old',
		sb.NewPatientLibility as 'audited/PatientLibility/@new',
		sb.OldAssignedLibility as 'audited/AssignedLibility/@old',
		sb.NewAssignedLibility as 'audited/AssignedLibility/@new',
    sb.OldSuperbillStatus as 'audited/SuperbillStatus/@old',    
    sb.NewSuperbillStatus as 'audited/SuperbillStatus/@new',
		sb.PatientWriteoffCreditType as 'audited/PatientWriteoffCreditType/@new',
		sb.InsuranceWriteoffCreditType as 'audited/InsuranceWriteoffCreditType/@new'
	FROM @tempSuperbills sb
	INNER JOIN Person per ON per.PersonUid = sb.PatientUid
	ORDER By sb.PatientUid, sb.ExternalID ASC
	FOR XML PATH( 'Superbill'), ROOT('audit' )
	)

	if (@changes IS NOT NULL)
	BEGIN

    DECLARE @userFullName VARCHAR(255)
    SET @userFullName = ''    
    if (@currentUserUid IS NOT NULL)
    BEGIN
      SELECT @userFullName = dbo.UDF_getFormattedName(null, per.FirstName, null, per.LastName, null)
      FROM Person per
      WHERE per.PersonUid = @currentUserUid
    END

		INSERT INTO Audit (TYPE, Changes, Workstation, UserUid, ChangeDate, Description)
		VALUES ('user', @changes, @workstation, @currentUserUid, GETDATE(), 'Writeoff Superbill by  ' +  @userFullName)
	END

END

select 'ViewSuperbillWithBalanceWrittenOff'
select * from @tempUpdatedSuperbills

DROP TABLE #tempSuperbillProceduresWithBalances;

ENABLE TRIGGER ALL ON AR_Ledger;

END





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SuperbillBalanceWriteoff_SelectSuperbills]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SuperbillBalanceWriteoff_SelectSuperbills] AS' 
END
GO



ALTER PROC [dbo].[AR_SuperbillBalanceWriteoff_SelectSuperbills]
	 @providerUidList VARCHAR(MAX) = NULL, -- , delimited
	 @claimingProvider bit = 1, -- default to claiming (above @providerUidList)
     @financialCenterUidList VARCHAR(MAX) = NULL, -- , delimited
     @payersToBeExcludedUidList VARCHAR(MAX) = NULL, -- , delimited
     @ageMinDays INT = NULL,
     @balanceMin MONEY = NULL
AS
BEGIN

	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	WITH cteSBPLimitLiabilityDate AS
	(
		SELECT LD.SuperbillProcedureUid, LD.LiabilityOwner, LD.InsurancePlanUid,       
					SUM(Amount) AS LiabilityAmount
			  FROM AR_LedgerDetail LD        
					INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid  
					INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
					INNER JOIN ARBatch ARB ON L.ArbatchUid = ARB.ArbatchUid 
			  WHERE NOT LD.SuperbillProcedureUid IS NULL   
					AND ARB.GLDate <= GETDATE() 
			  GROUP BY LD.SuperbillProcedureUid, LD.LiabilityOwner, LD.InsurancePlanUid
			  HAVING SUM(Amount) <> 0	
	)
	SELECT DISTINCT
			LD.LedgerDetailUid, LD.LedgerUid, L.EntryType,LD.SuperbillProcedureUid, SBP.SuperbillUid, LD.Amount AS Liability, LD.LiabilityOwner, 
			CASE WHEN LD.LiabilityOwner = 0 THEN NULL ELSE LD.InsurancePlanUid END AS InsurancePlanUid,	
			LD.IsCredit, LD.CreatedDateTime, ARB.IsClosed AS IsBatchClosed,	 	 		
			ARB.GLDate AS AgeByDate,
			DATEDIFF(d, ARB.GLDate, GETDATE()) as AgingDays 	
		FROM cteSBPLimitLiabilityDate SBPL
			INNER JOIN SuperbillProcedure SBP ON SBP.SuperbillProcedureUid = SBPL.SuperbillProcedureUid	
			INNER JOIN AR_LedgerDetail LD ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid 
			INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid 
			INNER JOIN ARBatch ARB ON L.ArbatchUid = ARB.ArbatchUid 
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid 	
			INNER JOIN SuperbillAggregate SBA ON SBP.SuperbillUid = SBA.SuperbillUid 
		WHERE (@providerUidList is NULL  -- filter by provider 
					OR (@claimingProvider=1 AND LD.ClaimingProviderUid in (Select Element from dbo.Split(@providerUidList,',')))  
					OR (@claimingProvider=0 AND LD.RenderingProviderUid in (Select Element from dbo.Split(@providerUidList,','))))
			AND (@financialCenterUidList is NULL  -- filter by finanical center 
					OR (LD.FinancialCenterUid in (Select Element from dbo.Split(@financialCenterUidList,','))))
			AND (@payersToBeExcludedUidList is NULL  -- filter by finanical center 
					OR (LD.FinancialCenterUid in (Select Element from dbo.Split(@payersToBeExcludedUidList,','))))
		ORDER BY AgeByDate, SuperbillUid, SuperbillProcedureUid, LiabilityOwner, CreatedDateTime 
	


	SELECT 'NameValuePair' -- SuperbillUid and External ID
	SELECT TOP 10 SuperbillUid, ExternalId	
		FROM Superbill

END















GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SyncCreditAsAdjustmentToLedger]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SyncCreditAsAdjustmentToLedger] AS' 
END
GO









ALTER PROC [dbo].[AR_SyncCreditAsAdjustmentToLedger]
	@depositDate DATETIME,
	@batchUid UNIQUEIDENTIFIER,
	@amount MONEY,
	@transactionUid UNIQUEIDENTIFIER,
	@superbillProcedureUid UNIQUEIDENTIFIER,
	@insurancePlanUid UNIQUEIDENTIFIER,
	@expenseAccountUid UNIQUEIDENTIFIER, -- creditType
	@creditUid UNIQUEIDENTIFIER,
	@chargeUid UNIQUEIDENTIFIER, -- must have this as need to know which specific charge we are working on (transfers)
	@groupEraCodeUid UNIQUEIDENTIFIER,
	@reasonEraCodeUid UNIQUEIDENTIFIER,
	@statementNote VARCHAR(300),
	@quantity DECIMAL(18,0),
	@notes VARCHAR(MAX)
AS
BEGIN

	DECLARE @newLedgerUid UNIQUEIDENTIFIER -- temp hold
	DECLARE @tempLedgerUid UNIQUEIDENTIFIER -- temp hold
	DECLARE @tempAmount MONEY -- temp hold
	DECLARE @tempPostingDate DATETIME -- temp hold
	DECLARE @procedureInfo varchar(50)
	
	-- get current superbillProcedure/insurancepayer transaction
	DECLARE @superbillProcedureDebitLedgerDetailUid UNIQUEIDENTIFIER 
	SELECT TOP 1 @superbillProcedureDebitLedgerDetailUid =  LD.ledgerDetailUid
	FROM AR_LedgerDetail LD
		INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
	WHERE LD.IsCredit = 0 AND LD.MigrationUid = @chargeUid

	IF (@superbillProcedureDebitLedgerDetailUid IS NULL)
		RETURN -- can not apply without a superbill in the ledger

	SELECT TOP 1 @tempLedgerUid = L.LedgerUid, @tempPostingDate = ARB.GLDate
	FROM AR_LedgerDetail LD
		INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
		INNER JOIN ARBatch ARB ON L.ArBatchUid = ARB.ArBatchUid
	WHERE LD.MigrationUid = @creditUid
		AND LD.IsCredit = 0
	
	DECLARE @responsiblePartyName VARCHAR(50)
	IF (@insurancePlanUid IS NULL)
		SELECT @responsiblePartyName = VP.FullName FROM ViewPerson VP 
				INNER JOIN AccountResponsibleParty ARP ON VP.PersonUid = ARP.PersonUid
				INNER JOIN Account A ON ARP.AccountResponsiblePartyUid = A.AccountResponsiblePartyUid
				INNER JOIN Superbill SB ON A.AccountUid = SB.AccountUid
				INNER JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid
			WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid
	ELSE
		SELECT @responsiblePartyName = IPL.Name FROM InsurancePlan IPL
			WHERE IPL.InsurancePlanUid = @insurancePlanUid

	SELECT @procedureInfo = ISNULL(SB.ExternalId,'<NID>') + '-' + ISNULL(LP.Code, '<NC>') + '-' + @responsiblePartyName 
		FROM SuperbillProcedure SBP 
			INNER JOIN ListProcedure LP ON SBP.ProcedureUid = LP.ProcedureUid
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
			WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid 

	IF (@tempLedgerUid IS NULL) -- if null, create a new pair
	BEGIN
		SELECT @newLedgerUid = NEWID()
		INSERT INTO AR_Ledger (LedgerUid, EntryDate, ArBatchUid, ShortName, EntryType, TransactionUid, GroupEraCodeUid, ReasonEraCodeUid,
					StatementNote, Quantity)
			SELECT @newLedgerUid, cast(convert(varchar, @depositDate, 101) + ' 12:00:00' AS datetime), @batchUid,
				'Adjustment  ' + @procedureInfo + '', 3, @transactionUid, -- Adjustment
				@groupEraCodeUid, @reasonEraCodeUid, @statementNote, @quantity
		INSERT INTO AR_LedgerDetail (LedgerDetailUid, LedgerUid, Amount, IncomeAccountUid, LiabilityOwner, LedgerAccountUid, InsurancePayerUid, AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, 
				DepositUid, InsurancePlanUid, FinancialCenterUid, ServiceSiteUid, RenderingProviderUid, ClaimingProviderUid, IsCredit, MigrationUid)
			SELECT NEWID(), @newLedgerUid, @amount*-1, @expenseAccountUid, LD.LiabilityOwner,
				LD.LedgerAccountUid, LD.InsurancePayerUid, LD.AccountResponsiblePartyUid, LD.SuperbillProcedureUid, LD.SuperbillProcedureUnits,
				LD.DepositUid, LD.InsurancePlanUid, LD.FinancialCenterUid, LD.ServiceSiteUid, LD.RenderingProviderUid, 
				LD.ClaimingProviderUid, 1, @creditUid
			FROM AR_LedgerDetail LD
			WHERE LD.LedgerDetailUid = @superbillProcedureDebitLedgerDetailUid
		INSERT INTO AR_LedgerDetail(LedgerDetailUid, LedgerUid, IsCredit, Amount, IncomeAccountUid, MigrationUid,
				FinancialCenterUid, ServiceSiteUid, RenderingProviderUid, ClaimingProviderUid) -- create new debit
			SELECT NEWID(), @newLedgerUid, 0, @amount, @expenseAccountUid, @creditUid,
				FinancialCenterUid, ServiceSiteUid, RenderingProviderUid, ClaimingProviderUid
				FROM AR_LedgerDetail LD
					WHERE LD.LedgerDetailUid = @superbillProcedureDebitLedgerDetailUid
			
	END
	ELSE -- update the exiting pair
	BEGIN
		UPDATE AR_LedgerDetail SET Amount = CASE WHEN IsCredit = 1 THEN @amount*-1 ELSE @amount END 
		WHERE LedgerUid = @tempLedgerUid
	END

	UPDATE AR_Ledger SET AR_Ledger.EntryDate = cast(convert(varchar, @depositDate, 101) + ' 12:00:00' AS datetime), 
			AR_Ledger.Reconciled = 0,
			AR_Ledger.StatementNote = @statementNote,
			AR_Ledger.Notes = @notes,
			AR_Ledger.GroupERACodeUid = @groupEraCodeUid,
			AR_Ledger.ReasonERACodeUid = @reasonEraCodeUid,
			AR_Ledger.Quantity = @quantity 
		FROM AR_Ledger
		WHERE LedgerUid = @tempLedgerUid
	
END









































GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SyncCreditAsPaymentToLedger]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SyncCreditAsPaymentToLedger] AS' 
END
GO











ALTER PROC [dbo].[AR_SyncCreditAsPaymentToLedger]
	@depositDate DATETIME,
	@batchUid UNIQUEIDENTIFIER,
	@amount MONEY,
	@transactionUid UNIQUEIDENTIFIER,
	@superbillProcedureUid UNIQUEIDENTIFIER,
	@insurancePlanUid UNIQUEIDENTIFIER,
	@depositUid UNIQUEIDENTIFIER,
	@expenseAccountUid UNIQUEIDENTIFIER, -- creditType
	@creditUid UNIQUEIDENTIFIER,
	@chargeUid UNIQUEIDENTIFIER, -- must have this as need to know which specific charge we are working on (transfers)
	@groupEraCodeUid UNIQUEIDENTIFIER,
	@reasonEraCodeUid UNIQUEIDENTIFIER,
	@statementNote VARCHAR(300),
	@quantity DECIMAL(18,0),
	@notes VARCHAR(MAX)
AS
BEGIN

	DECLARE @newLedgerUid UNIQUEIDENTIFIER -- temp hold
	DECLARE @tempLedgerUid UNIQUEIDENTIFIER -- temp hold
	DECLARE @tempAmount MONEY -- temp hold
	DECLARE @tempPostingDate DATETIME -- temp hold
	DECLARE @procedureInfo varchar(50)
	
	-- try to find existing first based upon credituid
	SELECT TOP 1 @tempLedgerUid = L.LedgerUid, @tempPostingDate = ARB.GLDate
	FROM AR_LedgerDetail LD
		INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
		INNER JOIN ARBatch ARB ON L.ArBatchUid = ARB.ArBatchUid
	WHERE LD.MigrationUid = @creditUid
		AND LD.IsCredit = 0 AND (L.EntryType = 2 or L.EntryType = 3) -- Distribution or Adjustment
	
	IF (@tempLedgerUid IS NULL) -- if null, create a new pair
	BEGIN
		-- get current deposit transaction
		DECLARE @depositCreditLedgerDetailUid UNIQUEIDENTIFIER 
		SELECT TOP 1 @depositCreditLedgerDetailUid =  LD.ledgerDetailUid
		FROM AR_LedgerDetail LD
		WHERE LD.MigrationUid = @depositUid
			AND LD.IsCredit = 1
	
		-- get current superbillProcedure/insurancepayer transaction
		DECLARE @superbillProcedureDebitLedgerDetailUid UNIQUEIDENTIFIER 
		DECLARE @superbillProcedureDebitFinancialCenterUid UNIQUEIDENTIFIER 
		DECLARE @superbillProcedureDebitServiceSiteUid UNIQUEIDENTIFIER 
		DECLARE @superbillProcedureDebitRenderingProviderUid UNIQUEIDENTIFIER 
		DECLARE @superbillProcedureDebitClaimingProviderUid UNIQUEIDENTIFIER 
		SELECT TOP 1 @superbillProcedureDebitLedgerDetailUid =  LD.ledgerDetailUid, @superbillProcedureDebitFinancialCenterUid = LD.FinancialCenterUid,
			@superbillProcedureDebitServiceSiteUid = LD.ServiceSiteUid, @superbillProcedureDebitRenderingProviderUid = LD.RenderingProviderUid,
			@superbillProcedureDebitClaimingProviderUid = LD.ClaimingProviderUid
		FROM AR_LedgerDetail LD
		WHERE LD.IsCredit = 0 and LD.MigrationUid = @chargeUid
	
		IF (@depositCreditLedgerDetailUid IS NULL OR @superbillProcedureDebitLedgerDetailUid IS NULL)
			RETURN -- can not apply without both a superbill and deposit in the ledger
			
		DECLARE @responsiblePartyName VARCHAR(50)
		IF (@insurancePlanUid IS NULL)
			SELECT @responsiblePartyName = VP.FullName FROM ViewPerson VP 
					INNER JOIN AccountResponsibleParty ARP ON VP.PersonUid = ARP.PersonUid
					INNER JOIN Account A ON ARP.AccountResponsiblePartyUid = A.AccountResponsiblePartyUid
					INNER JOIN Superbill SB ON A.AccountUid = SB.AccountUid
					INNER JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid
				WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid
		ELSE
			SELECT @responsiblePartyName = IPL.Name FROM InsurancePlan IPL
				WHERE IPL.InsurancePlanUid = @insurancePlanUid

		SELECT @procedureInfo = ISNULL(SB.ExternalId,'<NID>') + ' - ' + ISNULL(LP.Code, '<NC>') + ' - ' + @responsiblePartyName 
			FROM SuperbillProcedure SBP 
				INNER JOIN ListProcedure LP ON SBP.ProcedureUid = LP.ProcedureUid
				INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
				WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid 

		SELECT @newLedgerUid = NEWID()
		INSERT INTO AR_Ledger (LedgerUid, EntryDate, ArBatchUid, ShortName, EntryType, TransactionUid, GroupEraCodeUid, ReasonEraCodeUid,
					StatementNote, Quantity)
			SELECT @newLedgerUid, cast(convert(varchar, @depositDate, 101) + ' 12:00:00' AS datetime), @batchUid,
				LEFT('Distribution  ' + @procedureInfo,50), 2, @transactionUid,
				@groupEraCodeUid, @reasonEraCodeUid, @statementNote, @quantity -- Distribution
		INSERT INTO AR_LedgerDetail (LedgerDetailUid, LedgerUid, Amount, LiabilityOwner, InsurancePayerUid, AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, 
				DepositUid, InsurancePlanUid, FinancialCenterUid, ServiceSiteUid, RenderingProviderUid, ClaimingProviderUid, IsCredit, 
				IncomeAccountUid, MigrationUid) 
			SELECT NEWID(), @newLedgerUid, CASE WHEN LD.IsCredit = 0 THEN @amount*-1 ELSE @amount END, LD.LiabilityOwner,
				LD.InsurancePayerUid, LD.AccountResponsiblePartyUid, LD.SuperbillProcedureUid, LD.SuperbillProcedureUnits,
				LD.DepositUid, LD.InsurancePlanUid, @superbillProcedureDebitFinancialCenterUid, @superbillProcedureDebitServiceSiteUid, 
				@superbillProcedureDebitRenderingProviderUid, @superbillProcedureDebitClaimingProviderUid, 
				CASE WHEN LD.IsCredit = 1 THEN 0 ELSE 1 END, @expenseAccountUid, @creditUid
			FROM AR_LedgerDetail LD
			WHERE LD.LedgerDetailUid IN (@depositCreditLedgerDetailUid, @superbillProcedureDebitLedgerDetailUid)
			
	END
	ELSE -- update the exiting pair
	BEGIN
		UPDATE AR_LedgerDetail SET Amount = CASE WHEN IsCredit = 1 THEN @amount*-1 ELSE @amount END 
		WHERE LedgerUid = @tempLedgerUid
	END

	UPDATE AR_Ledger 
		SET AR_Ledger.EntryDate = cast(convert(varchar, @depositDate, 101) + ' 12:00:00' AS datetime), 
			AR_Ledger.Reconciled = 0 ,
			AR_Ledger.StatementNote = @statementNote,
			AR_Ledger.Notes = @notes,
			AR_Ledger.GroupERACodeUid = @groupEraCodeUid,
			AR_Ledger.ReasonERACodeUid = @reasonEraCodeUid,
			AR_Ledger.Quantity = @quantity
		FROM AR_Ledger
		WHERE LedgerUid = @tempLedgerUid
	
END


















































GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SyncDepositToLedger]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_SyncDepositToLedger] AS' 
END
GO







ALTER PROC [dbo].[AR_SyncDepositToLedger]
	@depositDate DATETIME,
	@batchUid UNIQUEIDENTIFIER,
	@amount MONEY,
	@accountResponsiblePartyUid UNIQUEIDENTIFIER,
	@insurancePayerUid UNIQUEIDENTIFIER,
	@depositUid UNIQUEIDENTIFIER
AS
BEGIN
	DECLARE @lockboxAccountUid UNIQUEIDENTIFIER
	SELECT @lockboxAccountUid = 'E9B016E2-1DA6-4C1F-AAC0-05E4C4D3F2A2'

	DECLARE @newLedgerUid UNIQUEIDENTIFIER -- temp hold
	DECLARE @tempLedgerUid UNIQUEIDENTIFIER -- temp hold
	DECLARE @tempAmount MONEY -- temp hold
	DECLARE @tempPostingDate DATETIME -- temp hold
	DECLARE @depositInfo VARCHAR(50)
	
	DECLARE @creditLedgerDetailUid UNIQUEIDENTIFIER -- right side credit - deposit is liability to site
	DECLARE @debitLedgerDetailUid UNIQUEIDENTIFIER -- left side debit - deposit brings in an asset (cash)
	
	
	-- Audit Batch changes
	Insert into AuditCurrent(AuditUid, Type, Changes, Workstation, UserUid, ChangeDate, Description, LastModifiedDate )
	Values ( NEWID(), 'Aprima-SQL', 
			'<audit date="' + convert(nvarchar(30),GetUTCDate(), 120) +'"' +
				'<sql="' + 'AR_SyncDepositToLedger @depositDate=''' + convert(nvarchar(30),@depositDate, 120) + 
				                              ''', @batchUid=''' + CONVERT(nvarchar(50),@batchUid) + 
				                              ''', @amount='''      + CONVERT(varchar, @amount)   +
				                              ''', @accountResponsiblePartyUid=''' + CONVERT(nvarchar(50), @accountResponsiblePartyUid) +
				                              ''', @insurancePayerUid=''' + CONVERT(nvarchar(50), @insurancePayerUid) +
				                              ''', @depositUid=''' + CONVERT(nvarchar(50), @depositUid) +
				                              '''" />' +
				'</audit>', 
			'Unknown', null, GETUTCDATE(), 
			'AR_SyncDepositToLedger', 
			GETUTCDATE() )	
	-- End audit batch changes
		
	SELECT TOP 1 @creditLedgerDetailUid =  LD.ledgerDetailUid, @tempLedgerUid = LD.LedgerUid, @tempAmount = LD.Amount, 
		@tempPostingDate = ARB.GLDate
	FROM AR_LedgerDetail LD
		INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
			INNER JOIN ARBatch ARB ON L.ArBatchUid = ARB.ARBatchUid
	WHERE LD.DepositUid = @depositUid 
		AND LD.IsCredit = 1
	ORDER BY L.CreatedDateTime DESC
	
	SELECT @depositInfo = ISNULL(DEP.ReferenceNumber, '<NRN>') + ' - ' + COALESCE(VC.Name, VP.FullName,'??') FROM Deposit DEP
		LEFT JOIN InsuranceCarrier IC ON DEP.WhoPaidInsuranceCarrierUid = IC.CorporationUid
			LEFT JOIN ViewCorporation VC ON IC.CorporationUid = VC.CorporationUid
		LEFT JOIN ViewPerson VP ON DEP.WhoPaidPersonUid = VP.PersonUid
		WHERE DEP.DepositUid = @depositUid -- cant pull above ... may not currently be in ledger
	IF (LEN(@depositInfo)>40)
		SELECT @depositInfo = SUBSTRING(@depositInfo,1,40)
		
	IF (NOT @creditLedgerDetailUid IS NULL)
	BEGIN
		SELECT TOP 1 @debitLedgerDetailUid = LD.LedgerDetailUid
		FROM AR_LedgerDetail LD
		WHERE LD.LedgerUid = @tempLedgerUid
			AND LD.LedgerAccountUid = @lockboxAccountUid
			AND Amount = -@tempAmount
			AND LD.IsCredit = 0
	END
	
	IF (@creditLedgerDetailUid IS NULL) -- if null, create a new pair
	BEGIN
		SELECT @newLedgerUid = NEWID()
		INSERT INTO AR_Ledger (LedgerUid, EntryDate, ArBatchUid, ShortName, EntryType)
			SELECT @newLedgerUid, cast(convert(varchar, @depositDate, 101) + ' 12:00:00' AS datetime), @batchUid, 
				'Payment  ' + @depositInfo + '', 0 -- Payment
		SELECT @creditLedgerDetailUid = NEWID(), @debitLedgerDetailUid = NEWID() 
		INSERT INTO AR_LedgerDetail(LedgerDetailUid, LedgerUid, IsCredit, Amount, AccountResponsiblePartyUid, InsurancePayerUid, 
				DepositUid, MigrationUid) -- create new credit
			SELECT @creditLedgerDetailUid, @newLedgerUid, 1, -@amount, @accountResponsiblePartyUid, @insurancePayerUid,
				@depositUid, @depositUid
		INSERT INTO AR_LedgerDetail(LedgerDetailUid, LedgerUid, IsCredit, Amount, LedgerAccountUid, MigrationUid) -- create new debit
			SELECT @debitLedgerDetailUid, @newLedgerUid, 0, @amount, @lockboxAccountUid, @depositUid
	END
	ELSE -- update the exiting pair
	BEGIN
		UPDATE AR_LedgerDetail SET Amount = -@amount, AccountResponsiblePartyUid = @accountResponsiblePartyUid, InsurancePayerUid = @insurancePayerUid, 
			DepositUid = @depositUid
		WHERE LedgerDetailUid = @creditLedgerDetailUid
		
		UPDATE AR_LedgerDetail SET Amount = @amount
		WHERE LedgerDetailUid = @debitLedgerDetailUid
	END

	UPDATE AR_Ledger SET AR_Ledger.EntryDate = cast(convert(varchar, @depositDate, 101) + ' 12:00:00' AS datetime),
			AR_Ledger.ArBatchUid = @batchUid, AR_Ledger.Reconciled = 0 
		FROM AR_LedgerDetail WHERE AR_LedgerDetail.LedgerUid = AR_Ledger.LedgerUid AND AR_LedgerDetail.LedgerDetailUid = @creditLedgerDetailUid
	
END



























GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_VoidLedger]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_VoidLedger] AS' 
END
GO






ALTER PROC [dbo].[AR_VoidLedger]
	@batchUid UNIQUEIDENTIFIER,
	@ledgerUid UNIQUEIDENTIFIER,
	@voidInfo VARCHAR(50) = ''
AS
BEGIN

	DECLARE @newLedgerUid UNIQUEIDENTIFIER

	SELECT @newLedgerUid = NEWID()
	INSERT INTO AR_Ledger (LedgerUid, EntryDate, ArBatchUid, ShortName)
		SELECT @newLedgerUid, cast(convert(varchar, GETUTCDATE(), 101) + ' 12:00:00' AS datetime), @batchUid, @voidInfo
	-- void with negative amount entries
	INSERT INTO AR_LedgerDetail (LedgerDetailUid, LedgerUid, Amount, LedgerAccountUid, InsurancePayerUid, AccountResponsiblePartyUid, SuperbillProcedureUid, 
			DepositUid, InsurancePlanUid, FinancialCenterUid, ServiceSiteUid, RenderingProviderUid, ClaimingProviderUid, IsCredit)
		SELECT NEWID(), @newLedgerUid, -LD.Amount, LD.LedgerAccountUid, LD.InsurancePayerUid, LD.AccountResponsiblePartyUid, LD.SuperbillProcedureUid, 
			LD.DepositUid, LD.InsurancePlanUid, LD.FinancialCenterUid, LD.ServiceSiteUid, LD.RenderingProviderUid, LD.ClaimingProviderUid, LD.IsCredit
		FROM AR_LedgerDetail LD
		WHERE LD.LedgerUid = @ledgerUid

END

		









GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_VoidLedgerDetailPair]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_VoidLedgerDetailPair] AS' 
END
GO




ALTER PROC [dbo].[AR_VoidLedgerDetailPair]
	@newLedgerUid UNIQUEIDENTIFIER,
	@debitLedgerDetailUid UNIQUEIDENTIFIER,
	@creditLedgerDetailUid UNIQUEIDENTIFIER
AS
BEGIN

	-- did not break out - although could save a few lines of code, makes more sense when you look at the entire thing

	-- void debit
	INSERT INTO AR_LedgerDetail (LedgerDetailUid, LedgerUid, Amount, LedgerAccountUid, InsurancePayerUid, AccountResponsiblePartyUid, SuperbillProcedureUid, 
			DepositUid, InsurancePlanUid, FinancialCenterUid, ServiceSiteUid, RenderingProviderUid, ClaimingProviderUid, IsCredit)
		SELECT NEWID(), @newLedgerUid, -LD.Amount, LD.LedgerAccountUid, LD.InsurancePayerUid, LD.AccountResponsiblePartyUid, LD.SuperbillProcedureUid, 
			LD.DepositUid, LD.InsurancePlanUid, LD.FinancialCenterUid, LD.ServiceSiteUid, LD.RenderingProviderUid, LD.ClaimingProviderUid, LD.IsCredit
		FROM AR_LedgerDetail LD
		WHERE LedgerDetailUid = @debitLedgerDetailUid
	
	-- void credit
	INSERT INTO AR_LedgerDetail (LedgerDetailUid, LedgerUid, Amount, LedgerAccountUid, InsurancePayerUid, AccountResponsiblePartyUid, SuperbillProcedureUid, 
			DepositUid, InsurancePlanUid, FinancialCenterUid, ServiceSiteUid, RenderingProviderUid, ClaimingProviderUid, IsCredit)
		SELECT NEWID(), @newLedgerUid, -LD.Amount, LD.LedgerAccountUid, LD.InsurancePayerUid, LD.AccountResponsiblePartyUid, LD.SuperbillProcedureUid, 
			LD.DepositUid, LD.InsurancePlanUid, LD.FinancialCenterUid, LD.ServiceSiteUid, LD.RenderingProviderUid, LD.ClaimingProviderUid, LD.IsCredit
		FROM AR_LedgerDetail LD
		WHERE LedgerDetailUid = @creditLedgerDetailUid

END

		







GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARBatch_DeleteIfUnreferenced]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARBatch_DeleteIfUnreferenced] AS' 
END
GO





ALTER PROC [dbo].[ARBatch_DeleteIfUnreferenced] 
	@arBatchUid UNIQUEIDENTIFIER
AS
BEGIN

	DECLARE @preExist BIT;
	DECLARE @postExist BIT;
	
	IF EXISTS(SELECT * FROM ARBatch WHERE ARBatchUid = @arBatchUid)
		SET @preExist = 1;
	ELSE
		SET @preExist = 0;

	DELETE 
		FROM ARBatch 
		WHERE ARBatchUid = @arBatchUid
			AND NOT EXISTS(SELECT ARBatchUid FROM Deposit WHERE ARBatchUid = @arBatchUid)
			AND NOT EXISTS(SELECT ARBatchUid FROM AR_Ledger WHERE ARBatchUid = @arBatchUid)
			
	IF EXISTS(SELECT * FROM ARBatch WHERE ARBatchUid = @arBatchUid)
		SET @postExist = 1;
	ELSE
		SET @postExist = 0;

	SELECT 'ARBatch'  -- check OC to se if worked
	SELECT *
		FROM ARBatch
		WHERE ARBatchUid = @arBatchUid
		
	SELECT 'NameValuePair' -- blocking failure
	SELECT 'PreExist' AS Name, CAST(@preExist AS VARCHAR(25)) AS Value
	UNION 
	SELECT 'PostExist' AS Name, CAST(@postExist AS VARCHAR(25)) AS Value
END

/*

*/	













GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0013_HypertensionBloodPressureMeasurement]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0013_HypertensionBloodPressureMeasurement] AS' 
END
GO

ALTER PROCEDURE [dbo].[ARRA_0013_HypertensionBloodPressureMeasurement] (@StartDate DATETIME, @EndDate DATETIME)
AS
BEGIN

--declare @StartDate DATETIME
--declare @EndDate DATETIME

--set @StartDate = '1/1/2000'
--set @EndDate = '12/31/2010'

DECLARE @PatientUid uniqueidentifier

declare @TotalPatients int
declare @QualifiedCount int
declare @Exclusions int
declare @percent float
declare @IsPregnant bit
declare @metDenominator bit
declare @metNumerator bit
declare @metExclusion bit
declare @tempCnt int

declare @MetricValue1 float
declare @MetricValue2 float

declare @18YearsAgo DateTime

declare @i int
declare @tempList varchar(MAX)
SET NOCOUNT ON

DECLARE @Visit TABLE
(
	VisitUid uniqueidentifier
)

-- load ICD9 codes for Hypertension encounter
declare @HypertensionICD9 table
(
	Code varchar(255)
)

SET @tempList = '401.0, 401.1, 401.9, 402.00, 402.01, 402.10, 402.11, 402.90, 402.91, ' +
				'403.00, 403.01, 403.10, 403.11, 403.90, 403.91, 404.00, 404.01, 404.02, ' +
				'404.03, 404.10, 404.11, 404.12, 404.13, 404.90, 404.91, 404.92, 404.93'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @HypertensionICD9 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @HypertensionICD9 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for Encounter Outpatient & Nursing Facility
declare @LevelOfService table
(
	Code varchar(255)
)

SET @tempList = '99304, 99305, 99306, 99307, 99308, 99309, 99310, ' + -- Nursing Facility
				'99201, 99202, 99203, 99204, 99205, 99212, 99213, 99214, 99215, 99241, ' +  -- Outpatient
				'99242, 99243, 99244, 99245, 99324, 99325, 99326, 99327, 99328, 99334, ' +
				'99335, 99336, 99337, 99341, 99342, 99343, 99344, 99345, 99347, 99348, 99349, 99350'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

SET @18YearsAgo = CONVERT(varchar, DATEADD(year, -18, @EndDate), 101)

SET @Exclusions = 0
SET @TotalPatients = 0
SET @QualifiedCount = 0

DECLARE _cursorOutside CURSOR FOR 
	SELECT DISTINCT pl.PatientUid, pl.IsPregnant
	FROM #PatientList pl
	WHERE pl.BirthDate <= @18YearsAgo AND
				((pl.DeathDate is null) or (pl.DeathDate > @EndDate))
		
OPEN _cursorOutside
FETCH NEXT FROM _cursorOutside INTO @PatientUid, @IsPregnant

WHILE (@@fetch_status <> -1)
BEGIN
	IF (@@fetch_status <> -2)
	BEGIN
		SET @metNumerator = 0
		SET @metExclusion = 0
		SET @metDenominator = 0
		SET @tempCnt = 0
						
		DELETE @Visit
		-- get all visit uids that are not struck out
		INSERT INTO @Visit
			SELECT VisitUid FROM Visit 
				WHERE PatientUid = @PatientUid AND 
					(VisitTypeUid is null OR VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
					
		-- BEGIN denominator
			-- does the patient have a history of Hypertension
			SELECT @tempCnt = COUNT(*) FROM PatientProblemDiagnosisHistory pdx 
				INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid AND lps.ActiveStatus = 1 
				INNER JOIN @HypertensionICD9 dia ON pdx.Code9 = dia.Code
			WHERE pdx.PatientUid = @PatientUid AND pdx.IsDelete = 0 AND pdx.IsPatientProblem = 0
					
			IF (@tempCnt = 0)
			BEGIN
				-- if not found in patient history; see if there is an active diagnosis for Hypertension		
				SET @tempCnt = 0
				SELECT @tempCnt = COUNT(*) 
				FROM @Visit v INNER JOIN 
					VisitDiagnosis vd ON v.VisitUid = vd.VisitUid AND vd.IsDelete = 0
					INNER JOIN @HypertensionICD9 dia ON vd.Code = dia.Code
			END
							
			IF (@tempCnt > 0)
			BEGIN
				SET @tempCnt = 0
				-- must have an outpatient level of service
				SELECT @tempCnt = COUNT(*) 
				FROM @Visit v 
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid 
						AND vp.IsDelete = 0 
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @LevelOfService code ON lp.Code = code.Code
					
				IF (@tempCnt > 1)
				BEGIN
					SET @metDenominator = 1
				END
			END
				-- does the patient have a history of hypertension and a level of service
		-- END denominator
		
		IF (@metDenominator = 1)
		BEGIN -- numerator
			SET @MetricValue1 = 0
			SET @MetricValue2 = 0
			
			-- get the most recent blood pressure
			SELECT TOP 1 @MetricValue1 = ov.MetricValue1, @MetricValue2 = ov.MetricValue2 
			FROM @Visit v 
				INNER JOIN ObservationOrder oo ON v.VisitUid = oo.VisitUid
					AND oo.IsDelete = 0
				INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
						AND	ov.ObservationItemUid IN 
					(
						'00000000-0000-0000-7777-100000000073', -- Blood pressure 1
						'00000000-0000-0000-7777-100000000074', -- Blood pressure 2
						'00000000-0000-0000-7777-100000000075', -- Blood pressure 3
						'00000000-0000-0000-7777-100000000076'  -- Blood pressure 4
					)
			--ORDER BY COALESCE(ExtractDate, ResultDate, ReceiveDate, PerformDate, OrderDate, ov.LastModifiedDate, oo.LastModifiedDate) DESC

			IF (@MetricValue1 > 0 AND @MetricValue2 > 0)
			BEGIN
				SET @metNumerator = 1
			END
		END -- of numerator
		
		-- no exclusions
		
		-- adjust counts
		IF (@metDenominator = 1)
		BEGIN
			SET @TotalPatients = @TotalPatients + 1
			IF (@metExclusion =	1)
			BEGIN
				SET @Exclusions = @Exclusions + 1
				IF (@metNumerator = 0)
				BEGIN
					SET @TotalPatients = @TotalPatients - 1
				END
			END
			
			IF (@metNumerator = 1)
			BEGIN
				SET @QualifiedCount = @QualifiedCount + 1
			END
		END -- of IF (@metDenominator = 1)
	END -- of IF (@@fetch_status <> -2)
	
	FETCH NEXT FROM _cursorOutside INTO @PatientUid, @IsPregnant
END -- of while
CLOSE _cursorOutside
DEALLOCATE _cursorOutside

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

DECLARE @Description varchar(MAX)

SELECT @Description = Name FROM ListARRAReports WHERE ARRAReportsUid = '7CDFAD84-D69E-4CC9-B5C3-6532E47660C1'

--SELECT '0013' as [NQF], '1' as [Population Criteria], '1' as [Numerator],
--	@TotalPatients as [TotalPatients], @Exclusions as [Exclusions],  @QualifiedCount as [QualifiedCount], 
--	@percent as [Percent],
--	@Description as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0013',
		'1',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description
	)

END





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0018_ControlingHighBloodPressure]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0018_ControlingHighBloodPressure] AS' 
END
GO

ALTER PROCEDURE [dbo].[ARRA_0018_ControlingHighBloodPressure] (@StartDate DATETIME, @EndDate DATETIME)
AS
BEGIN

--declare @StartDate DATETIME
--declare @EndDate DATETIME

--set @StartDate = '1/1/2000'
--set @EndDate = '12/31/2011'

SET NOCOUNT ON

DECLARE @PatientUid uniqueidentifier

declare @TotalPatients int
declare @QualifiedCount int
declare @Exclusions int
declare @percent float
declare @IsPregnant bit
declare @metDenominator bit
declare @metNumerator bit
declare @metExclusion bit
declare @tempCnt int

declare @MetricValue1 float
declare @MetricValue2 float

declare @18YearsAgo DateTime
declare @75YearsAgo DateTime
declare @2YearsAgo DateTime

declare @i int
declare @tempList varchar(MAX)

DECLARE @Visit TABLE
(
	VisitUid uniqueidentifier
)

-- load ICD9 codes for ESRD
declare @ESRD_ICD9 table
(
	Code varchar(255)
)

SET @tempList = '38.95, 39.27, 39.42, 39.43, 39.53, 39.93, 39.94, 39.95, 54.98, 55.6, ' +
		'55.61, 55.69, 585.5, 585.6, V42.0, V45.1, V45.11, V45.12, V56, V56.0, V56.1, V56.2, V56.3, V56.31, V56.32, V56.8'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @ESRD_ICD9 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @ESRD_ICD9 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for procedures indicative of ESRD 
declare @ESRD_CPT table
(
	Code varchar(255)
)

SET @tempList = '36145, 36147, 36148, 36800, 36810, 36815, 36818, 36819, 36820, 36821, ' +
		'36831, 36832, 36833, 50300, 50320, 50340, 50360, 50365, 50370, 50380, 90920, ' +
		'90921, 90924, 90925, 90935, 90937, 90940, 90945, 90947, 90957, 90958, 90959, ' +
		'90960, 90961, 90962, 90965, 90966, 90969, 90970, 90989, 90993, 90997, 90999, 99512'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @ESRD_CPT (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @ESRD_CPT (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

SET @18YearsAgo = CONVERT(varchar, DATEADD(year, -18, @EndDate), 101)
SET @75YearsAgo = CONVERT(varchar, DATEADD(year, -75, @StartDate), 101)
SET @2YearsAgo = CONVERT(varchar, DATEADD(year, -2, @EndDate), 101)

SET @Exclusions = 0
SET @TotalPatients = 0
SET @QualifiedCount = 0

DECLARE _cursorOutside CURSOR FOR 
	SELECT DISTINCT pl.PatientUid, pl.IsPregnant
	FROM #PatientList pl
	WHERE pl.BirthDate <= @18YearsAgo AND BirthDate >= @75YearsAgo AND
				((pl.DeathDate is null) or (pl.DeathDate > @EndDate))
		
OPEN _cursorOutside
FETCH NEXT FROM _cursorOutside INTO @PatientUid, @IsPregnant

WHILE (@@fetch_status <> -1)
BEGIN
	IF (@@fetch_status <> -2)
	BEGIN
		SET @metNumerator = 0
		SET @metExclusion = 0
		SET @metDenominator = 0
		SET @tempCnt = 0
					
		IF (@IsPregnant = 0) -- cannot be pregnant
		BEGIN
		
			DELETE @Visit
			-- get all visit uids that are not struck out
			INSERT INTO @Visit
				SELECT VisitUid FROM Visit 
					WHERE PatientUid = @PatientUid AND 
						(VisitTypeUid is null OR VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
					
			--BEGIN denominator
			BEGIN -- does the patient have a history of ESRD
				SET @tempCnt = 0
				SELECT @tempCnt = COUNT(*) FROM PatientProblemDiagnosisHistory pdx 
					INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid AND lps.ActiveStatus = 1 
					INNER JOIN @ESRD_ICD9 dia ON pdx.Code9 = dia.Code
				WHERE pdx.PatientUid = @PatientUid AND pdx.IsDelete = 0 AND pdx.IsPatientProblem = 0
				
				IF (@tempCnt = 0)
				BEGIN
					-- if not found in patient history; see if there is an active diagnosis for diabetes and 
					-- at less one acute encounters or at less two non-acute encounters
					SET @tempCnt = 0
					SELECT @tempCnt = COUNT(*) 
					FROM @Visit v 
						INNER JOIN VisitDiagnosis vd ON vd.VisitUid = v.VisitUid
							AND vd.IsDelete = 0
						INNER JOIN @ESRD_ICD9 dia ON vd.Code = dia.Code
				END
				IF (@tempCnt = 0)
				BEGIN
					-- look for ESRD procedures
					SELECT @tempCnt = COUNT(*) 
					FROM @Visit v
						INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
						INNER JOIN @ESRD_CPT cpt ON lp.Code = cpt.Code
					
				END
			END -- does the patient have a history of ESRD
			
			IF (@tempCnt = 0) -- zero when patient does not have ESRD
			BEGIN -- does the patient have a history of hypertension and a level of service
				SET @tempCnt = 0
				SELECT @tempCnt = COUNT(*) FROM PatientProblemDiagnosisHistory pdx 
					INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid 
							AND lps.ActiveStatus = 1
							AND pdx.IsDelete = 0
					INNER JOIN dbo.ARRR_HypertensionICD9() dia ON pdx.Code9 = dia.ICD9Code
				WHERE pdx.PatientUid = @PatientUid AND pdx.IsPatientProblem = 0
				
				IF (@tempCnt = 0)
				BEGIN
					-- if not found in patient history; see if there is an active diagnosis for diabetes and 
					-- at less one acute encounters or at less two non-acute encounters
					SET @tempCnt = 0
					SELECT @tempCnt = COUNT(*) 
					FROM @Visit v
						INNER JOIN VisitDiagnosis vd ON v.VisitUid = vd.VisitUid
							AND vd.IsDelete = 0
						INNER JOIN dbo.ARRR_HypertensionICD9() dia ON vd.Code = dia.ICD9Code
				END
				
				IF (@tempCnt > 0)
				BEGIN
					SET @tempCnt = 0
					-- must have an outpatient level of service
					SELECT @tempCnt = COUNT(*) 
					FROM @Visit v
						INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
						INNER JOIN dbo.ARRR_OutpatientLevelOfServiceCodes() outpat ON lp.Code = outpat.Code
				
					IF (@tempCnt > 0)
					BEGIN
						SET @metDenominator = 1
					END
				END
			END -- does the patient have a history of hypertension and a level of service
			--END denominator
		
			IF (@metDenominator = 1)
			BEGIN -- numerator
				SET @MetricValue1 = 0
				SET @MetricValue2 = 0
				-- get the most recent blood pressure
				SELECT TOP 1 @MetricValue1 = ov.MetricValue1, @MetricValue2 = ov.MetricValue2 
				FROM @Visit v 
					INNER JOIN ObservationOrder oo ON v.VisitUid = oo.VisitUid
						AND oo.IsDelete = 0
					INNER JOIN ObservationValue ov ON  oo.ObservationOrderUid = ov.ObservationOrderUid
						AND	ov.ObservationItemUid IN 
						(
							'00000000-0000-0000-7777-100000000073', -- Blood pressure 1
							'00000000-0000-0000-7777-100000000074', -- Blood pressure 2
							'00000000-0000-0000-7777-100000000075', -- Blood pressure 3
							'00000000-0000-0000-7777-100000000076'  -- Blood pressure 4
						)
				ORDER BY COALESCE(ExtractDate, ResultDate, ReceiveDate, PerformDate, OrderDate, ov.LastModifiedDate, oo.LastModifiedDate) DESC

				IF (@MetricValue1 > 0 AND @MetricValue2 > 0 AND @MetricValue1 < 140 AND @MetricValue2 < 90)
				BEGIN
					SET @metNumerator = 1
				END
			END -- of numerator
			
			-- no exclusions
			
			-- adjust counts
			IF (@metDenominator = 1)
			BEGIN
				SET @TotalPatients = @TotalPatients + 1
				IF (@metExclusion =	1)
				BEGIN
					SET @Exclusions = @Exclusions + 1
					IF (@metNumerator = 0)
					BEGIN
						SET @TotalPatients = @TotalPatients - 1
					END
				END
				
				IF (@metNumerator = 1)
				BEGIN
					SET @QualifiedCount = @QualifiedCount + 1
				END
			END -- of IF (@metDenominator = 1)
		END -- of IF (@IsPregnant = 0)
	END -- of IF (@@fetch_status <> -2)
	
	FETCH NEXT FROM _cursorOutside INTO @PatientUid, @IsPregnant
END -- of while
CLOSE _cursorOutside
DEALLOCATE _cursorOutside

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

DECLARE @Description varchar(MAX)

SELECT @Description = Name FROM ListARRAReports WHERE ARRAReportsUid = '2611CA59-D220-4073-8916-D756A8D84F67'

--SELECT '0018' as [NQF], '1' as [Population Criteria], '1' as [Numerator],
--	@TotalPatients as [TotalPatients], @Exclusions as [Exclusions],  @QualifiedCount as [QualifiedCount], 
--	@percent as [Percent],
--	@Description as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0018',
		'1',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description
	)

END





GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0024_WeightAssessmentCounselingForChildrenAdolescents]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0024_WeightAssessmentCounselingForChildrenAdolescents] AS' 
END
GO



ALTER PROCEDURE [dbo].[ARRA_0024_WeightAssessmentCounselingForChildrenAdolescents] (@StartDate DATETIME, @EndDate DATETIME)
AS
BEGIN


-- NOTE: strike out visit are removed by store procedure ARRA_LoadPatientList


--declare @StartDate DATETIME
--declare @EndDate DATETIME

--set @StartDate = '1/1/2010'
--set @EndDate = '12/31/2011'

declare @TotalPatients int
declare @QualifiedCount int
declare @Exclusions int
declare @percent float

declare @2YearsAgo DateTime
declare @16YearsAgo DateTime
declare @10YearsAgo DateTime
declare @11YearsAgo DateTime

SET @2YearsAgo = CONVERT(varchar, DATEADD(year, -2, @EndDate), 101)
SET @16YearsAgo = CONVERT(varchar, DATEADD(year, -16, @EndDate), 101)
SET @10YearsAgo = CONVERT(varchar, DATEADD(year, -10, @EndDate), 101)
SET @11YearsAgo = CONVERT(varchar, DATEADD(year, -11, @EndDate), 101)


declare @i int
declare @tempList varchar(MAX)


-- load CPT codes for Encounter Outpatient
declare @OutPatientEncounterCPT table
(
	Code varchar(255)
)

SET @tempList = '99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, 99215, 99217, ' +
				'99218, 99219, 99220, 99241, 99242, 99243, 99244, 99245, 99341, 99342, 99343, ' +
				'99344, 99345, 99347, 99348, 99349, 99350, 99384, 99385, 99386, 99387, 99394, ' +
				'99395, 99396, 99397, 99401, 99402, 99403, 99404, 99411, 99412, 99420, 99429, ' +
				'99455, 99456'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @OutPatientEncounterCPT (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @OutPatientEncounterCPT (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load ICD9 codes for Encounter Outpatient
declare @OutPatientEncounterICD9 table
(
	Code varchar(255)
)

SET @tempList = 'V70.0, V70.3, V70.5, V70.6, V70.8, V70.9'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @OutPatientEncounterICD9 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @OutPatientEncounterICD9 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

declare @InitialPatientPopulation table
(
	PatientUid uniqueidentifier null
)

-- load patient's that have had an out patient encounter
INSERT INTO @InitialPatientPopulation
	SELECT DISTINCT PatientUid 
	FROM #PatientList pl
	INNER JOIN VisitProcedure vp ON vp.VisitUid = pl.VisitUid AND vp.IsDelete = 0
	INNER JOIN ListProcedure lp ON lp.ProcedureUid = vp.ProcedureUid 
		AND lp.Code IN (SELECT Code FROM @OutPatientEncounterCPT)
	WHERE pl.IsPregnant = 0 AND pl.PatientUid NOT IN (SELECT PatientUid FROM @InitialPatientPopulation)


-- load patient's that have had an out patient encounter
INSERT INTO @InitialPatientPopulation
	SELECT DISTINCT PatientUid 
	FROM #PatientList pl
	INNER JOIN VisitDiagnosis vd ON vd.VisitUid = pl.VisitUid 
	INNER JOIN ListDiagnosis ld ON ld.DiagnosisUid = vd.DiagnosisUid 
		AND ld.DiagnosisCode9 IN (SELECT Code FROM @OutPatientEncounterICD9)	
	WHERE pl.IsPregnant = 0 AND pl.PatientUid NOT IN (SELECT PatientUid FROM @InitialPatientPopulation)
	

DECLARE @PatientPopulation TABLE
(
	BirthDate DateTime,
	BMI float,
	PhysicalActivity bit default (0),
	Nutrition bit default (0)
)

INSERT INTO @PatientPopulation
SELECT DISTINCT
	pl.BirthDate,
	IsNull((SELECT Max(IsNull (ov.MetricValue1, convert(float, convert(varchar(max), ov.ObservationValue))))
			FROM ObservationOrder oo 
	INNER JOIN ObservationValue ov ON ov.ObservationOrderUid = oo.ObservationOrderUid
		AND ov.ObservationItemUid = '00000000-0000-0000-7777-100000000007' -- guid for observation item "BMI"
	WHERE oo.IsDelete = 0 AND oo.VisitUid IN (SELECT VisitUid FROM Visit v WHERE v.PatientUid = pl.PatientUid)), 0) 
		as BMI,
		 
	 ISNULL
	 (
		ISNULL((SELECT DISTINCT '1' FROM VisitDiagnosis vd INNER JOIN ListDiagnosis ld ON ld.DiagnosisUid = vd.DiagnosisUid
						and ld.DiagnosisCode9 = 'V65.41' 
					WHERE vd.VisitUid  IN (SELECT VisitUid FROM Visit v WHERE v.PatientUid = pl.PatientUid)),
		ISNULL((SELECT DISTINCT '1' FROM VisitProcedure vp INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
						and lp.Code in ('S9451') WHERE vp.VisitUid IN (SELECT VisitUid FROM Visit v WHERE v.PatientUid = pl.PatientUid)),
		(SELECT DISTINCT '1'	FROM VisitEduForm vef INNER JOIN ListEduForm lef ON lef.EduFormUid = vef.EduFormUid
						AND convert(varchar(MAX), lef.PatientCommunications) like '%8B0798AF-346D-4DE5-ABB9-2C29D59B8325%'
					WHERE vef.VisitUid = pl.VisitUid)))
	 ,0
	 )
	 as PhysicalActivity,

	 ISNULL
	 (
		ISNULL((SELECT DISTINCT '1' FROM VisitDiagnosis vd INNER JOIN ListDiagnosis ld ON ld.DiagnosisUid = vd.DiagnosisUid
						and ld.DiagnosisCode9 = 'V65.3' WHERE vd.VisitUid  IN (SELECT VisitUid FROM Visit v WHERE v.PatientUid = pl.PatientUid)),
		ISNULL((SELECT DISTINCT '1' FROM VisitProcedure vp INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
						and lp.Code in ('97802', '97803', '97804') WHERE vp.VisitUid IN (SELECT VisitUid FROM Visit v WHERE v.PatientUid = pl.PatientUid)),
				(SELECT DISTINCT '1'	FROM VisitEduForm vef INNER JOIN ListEduForm lef ON lef.EduFormUid = vef.EduFormUid
						AND convert(varchar(MAX), lef.PatientCommunications) like '%84B0C475-EF42-4988-B00A-D0B1D6E352FE%'
					WHERE vef.VisitUid = pl.VisitUid)))
	 ,0
	 )
	 as Nutrition
	
FROM #PatientList pl
INNER JOIN @InitialPatientPopulation ipp ON pl.PatientUid = ipp.PatientUid
SET @Exclusions = 0

-- population criteria 1 ********************************************************************
SELECT @TotalPatients = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @2YearsAgo AND BirthDate >= @16YearsAgo

SELECT @QualifiedCount = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @2YearsAgo AND BirthDate >= @16YearsAgo
  AND BMI > 0

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

DECLARE @Description varchar(MAX)

SELECT @Description = Name FROM ListARRAReports WHERE ARRAReportsUid = '06512944-BAFE-4BD5-8CEC-75E3793E9EC1'

-- patient population 1, numerator 1
--SELECT '0024' as [NQF], '1' as [Population Criteria], '1' as [Numerator],
--		@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description + ' (age between 2 and 16 - BMI percentile)' as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0024',
		'1',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description + ' (population 1 - age between 2 and 16 - BMI percentile)'
	)
	
SELECT @QualifiedCount = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @2YearsAgo AND BirthDate >= @16YearsAgo
  AND Nutrition = 1

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

-- patient population 1, numerator 2
--SELECT '0024' as [NQF], '1' as [Population Criteria], '2' as [Numerator],
--		@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description + ' (age between 2 and 16 - counseling for nutrition)' as [Description]

INSERT INTO #Results 
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0024',
		'1',
		'2',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description + ' (population 1 - age between 2 and 16 - counseling for nutrition)'
	)
	
SELECT @QualifiedCount = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @2YearsAgo AND BirthDate >= @16YearsAgo
  AND PhysicalActivity = 1

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

-- patient population 1,  numerator 3
--SELECT '0024' as [NQF], '1' as [Population Criteria], '3' as [Numerator],
--		@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description + ' (age between 2 and 16 - counseling for physical activity)' as [Description]

INSERT INTO #Results 
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0024',
		'1',
		'3',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description + ' (population 1 - age between 2 and 16 - counseling for physical activity)'
	)
	
-- population criteria 2 ********************************************************************
SELECT @TotalPatients = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @2YearsAgo AND BirthDate >= @10YearsAgo

SELECT @QualifiedCount = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @2YearsAgo AND BirthDate >= @10YearsAgo
  AND BMI > 0

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

-- patient population 2, numerator 1
--SELECT '0024' as [NQF], '2' as [Population Criteria], '1' as [Numerator],
--		@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description + ' (age between 2 and 10 - BMI percentile)' as [Description]

INSERT INTO #Results 
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0024',
		'2',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description + ' (population 2 - age between 2 and 10 - BMI percentile)'
	)

SELECT @QualifiedCount = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @2YearsAgo AND BirthDate >= @10YearsAgo
  AND Nutrition = 1

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

-- patient population 2, numerator 2
--SELECT '0024' as [NQF], '2' as [Population Criteria], '2' as [Numerator],
--		@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description + ' (age between 2 and 10 - counseling for nutrition)' as [Description]

INSERT INTO #Results 
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0024',
		'2',
		'2',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description + ' (population 2 - age between 2 and 10 - counseling for nutrition)'
	)

SELECT @QualifiedCount = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @2YearsAgo AND BirthDate >= @10YearsAgo
  AND PhysicalActivity = 1

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

-- patient population 2,  numerator 3
--SELECT '0024' as [NQF], '2' as [Population Criteria], '3' as [Numerator],
--		@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description + ' (age between 2 and 10 - counseling for physical activity)' as [Description]

INSERT INTO #Results 
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0024',
		'2',
		'3',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description + ' population 2 - age between 2 and 10 - counseling for physical activity)'
	)
	
-- population criteria 3 ********************************************************************
SELECT @TotalPatients = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @11YearsAgo AND BirthDate >= @16YearsAgo

SELECT @QualifiedCount = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @11YearsAgo AND BirthDate >= @16YearsAgo
  AND BMI > 0

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

-- patient population 3, numerator 1
--SELECT '0024' as [NQF], '3' as [Population Criteria], '1' as [Numerator],
--		@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description + ' (age between 11 and 16 - BMI percentile)' as [Description]

INSERT INTO #Results 
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0024',
		'3',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description + ' (population 3 - age between 11 and 16 - BMI percentile)'
	)
	
SELECT @QualifiedCount = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @11YearsAgo AND BirthDate >= @16YearsAgo
  AND Nutrition = 1

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

-- patient population 3, numerator 2
--SELECT '0024' as [NQF], '3' as [Population Criteria], '2' as [Numerator],
--		@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description + ' (age between 11 and 16 - counseling for nutrition)' as [Description]

INSERT INTO #Results 
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0024',
		'3',
		'2',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description + ' (population 3 - age between 11 and 16 - counseling for nutrition)'
	)
	
SELECT @QualifiedCount = COUNT(*) 
FROM @PatientPopulation
WHERE BirthDate <= @11YearsAgo AND BirthDate >= @16YearsAgo
  AND PhysicalActivity = 1

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

 --patient population 3,  numerator 3
--SELECT '0024' as [NQF], '3' as [Population Criteria], '3' as [Numerator],
--		@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description  + ' (age between 11 and 16 - counseling for physical activity)' as [Description]

INSERT INTO #Results 
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0024',
		'3',
		'3',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description + ' (population 3 - age between 11 and 16 - counseling for physical activity)'
	)
			
END



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0027_SmokingAndTobaccoUse]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0027_SmokingAndTobaccoUse] AS' 
END
GO
ALTER PROCEDURE [dbo].[ARRA_0027_SmokingAndTobaccoUse] (@StartDate DATE, @EndDate DATE)
AS
BEGIN

--declare @StartDate DATETIME
--declare @EndDate DATETIME

--set @StartDate = '1/1/2000'
--set @EndDate = '12/31/2011'

SET NOCOUNT ON

DECLARE @PatientUid uniqueidentifier

declare @TotalPatients int
declare @QualifiedCount1 int
declare @QualifiedCount2 int
declare @Exclusions int
declare @percent float
declare @metDenominator bit
declare @metNumerator1 bit
declare @metNumerator2 bit
declare @metExclusion bit
declare @tempCnt int

declare @1YearsAgo DateTime
declare @2YearsAgo DateTime
declare @17YearsAgo DateTime

declare @i int
declare @tempList varchar(MAX)

-- load CPT codes for Encounter Office & Outpatient Consult
declare @LevelOfService table
(
	Code varchar(255)
)

SET @tempList = '99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, 99215, 99217, ' +
				'99218, 99219, 99220, 99241, 99242, 99243, 99244, 99245, 99341, 99342, 99343, ' +
				'99344, 99345, 99347, 99348, 99349, 99350, 99384, 99385, 99386, 99387, 99394, ' +
				'99395, 99396, 99397, 99401, 99402, 99403, 99404, 99411, 99412, 99420, 99429, 99455, 99456'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for procedures indicative of Tobacco Use Cessation Counseling
declare @TobaccoCounselingCPT table
(
	Code varchar(255)
)

SET @tempList = '99406, 99407'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @TobaccoCounselingCPT (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @TobaccoCounselingCPT (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

SET @1YearsAgo = CONVERT(varchar, DATEADD(year, -1, @StartDate), 101)
SET @2YearsAgo = CONVERT(varchar, DATEADD(year, -2, @StartDate), 101)
SET @17YearsAgo = CONVERT(varchar, DATEADD(year, -17, @StartDate), 101)

SET @Exclusions = 0
SET @TotalPatients = 0
SET @QualifiedCount1 = 0
SET @QualifiedCount2 = 0

DECLARE _cursorOutside CURSOR FOR 
	SELECT DISTINCT pl.PatientUid
	FROM #PatientList pl
	WHERE pl.BirthDate <= @17YearsAgo AND
				((pl.DeathDate is null) or (pl.DeathDate > @EndDate))
		
OPEN _cursorOutside
FETCH NEXT FROM _cursorOutside INTO @PatientUid

WHILE (@@fetch_status <> -1)
BEGIN
	IF (@@fetch_status <> -2)
	BEGIN
		SET @metNumerator1 = 0
		SET @metNumerator2 = 0
		SET @metExclusion = 0
		SET @metDenominator = 0
		SET @tempCnt = 0
										
		BEGIN -- denominator
	
			-- must have office or outpatient consult within the last two years
			SELECT @tempCnt = COUNT(*) 
			FROM Visit v
				INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
					AND v.PatientUid = @PatientUid AND v.VisitDate >= @2YearsAgo 
					AND (VisitTypeUid is null OR VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
				INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
				INNER JOIN @LevelOfService cpt ON lp.Code = cpt.Code
		
			IF (@tempCnt > 0)
			BEGIN
				SET @metDenominator = 1
			END	
		
		END -- denominator
		
		IF (@metDenominator = 1)
		BEGIN -- numerator
			-- Numerator 1
			SET @tempCnt = 0
			
			-- does the patient have a social history of tobacco use
			SELECT @tempCnt = COUNT(*)
			FROM PatientHistory ph 
			INNER JOIN PatientHistoryDetail phd ON phd.PatientHistoryUid = ph.PatientHistoryUid
			AND ph.PatientUid = @PatientUid
			AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000106' -- SocialHistoryUid 
			AND phd.AnswerUid IN 
				('83569607-629E-4F31-A10B-AF2A34326E1E', -- SocialHistory_TobaccoHistory_CurrentlySmokeless
				 '00000000-0000-0000-0000-000000000048', -- SocialHistory_TobaccoHistory_CurrentlySmokes
				 '292F21B1-9CA3-4ACE-B5CD-FE73BF1B3A31', -- SocialHistory_TobaccoHistory_EverydaySmoker
				 '809D9F30-5E2C-4552-A7A9-A70E2EEB6031'  -- SocialHistory_TobaccoHistory_SomeDaySmoker
				 )
			AND ActiveDate >= @1YearsAgo AND (InactiveDate is null OR InactiveDate > @StartDate)
			
			IF (@tempCnt > 0)
			BEGIN
				SET @metNumerator1 = 1
			END	
			
			-- Numerator 2
			SET @tempCnt = 0
			
			-- look for a printed education form for PQRI measure 115 - Advising Smokers to Quit; active or not active
			SELECT @tempCnt = COUNT(*)
			FROM Visit v
			INNER JOIN VisitEduForm vef ON v.VisitUid = vef.VisitUid 
				AND v.PatientUid = @PatientUid --AND v.VisitDate >= @1YearsAgo
				AND (VisitTypeUid is null OR VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
			INNER JOIN ListEduForm lef ON vef.EduFormUid = lef.EduFormUid
				AND vef.PrintedDate is not null
				AND lef.PQRIMeasureUid IN (SELECT PQRIMeasureUid FROM ListPQRIMeasure lpm WHERE lpm.ExternalID like '%115%')
				
			IF (@tempCnt = 0)
			BEGIN
				-- look in visit sp	for a Tobacco Counseling CPT
				SELECT @tempCnt = COUNT(*) 
				FROM Visit v
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						AND v.PatientUid = @PatientUid AND v.VisitDate >= @1YearsAgo
						AND (VisitTypeUid is null OR VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @TobaccoCounselingCPT cpt ON lp.Code = cpt.Code
							
			END
			
			IF (@tempCnt > 0)
			BEGIN
				SET @metNumerator2 = 1
			END	
			
		END -- of numerator
		
		-- no exclusions
		
		-- adjust counts
		IF (@metDenominator = 1)
		BEGIN
			SET @TotalPatients = @TotalPatients + 1
			-- no exclusion; remark out
			--IF (@metExclusion =	1)
			--BEGIN
			--	SET @Exclusions = @Exclusions + 1
			--	IF (@metNumerator = 0)
			--	BEGIN
			--		SET @TotalPatients = @TotalPatients - 1
			--	END
			--END
			
			IF (@metNumerator1 = 1)
			BEGIN
				SET @QualifiedCount1 = @QualifiedCount1 + 1
			END
			IF (@metNumerator2 = 1)
			BEGIN
				SET @QualifiedCount2 = @QualifiedCount2 + 1
			END
		END -- of IF (@metDenominator = 1)
	END -- of IF (@@fetch_status <> -2)
	
	FETCH NEXT FROM _cursorOutside INTO @PatientUid
END -- of while
CLOSE _cursorOutside
DEALLOCATE _cursorOutside

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount1
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

DECLARE @Description varchar(MAX)

SELECT @Description = Name FROM ListARRAReports WHERE ARRAReportsUid = 'D3BAF227-562E-4F85-8A08-4E90E39FDDB7'

--SELECT '0027' as [NQF], '1' as [Population Criteria], '1' as [Numerator],
--	@TotalPatients as [TotalPatients], @Exclusions as [Exclusions],  @QualifiedCount1 as [QualifiedCount], 
--	@percent as [Percent],
--	@Description + ' (tobacco user)' as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0027',
		'1',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount1,
		@percent,
		@Description + ' (tobacco user)'
	)

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount2
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

--SELECT '0027' as [NQF], '1' as [Population Criteria], '2' as [Numerator],
--	@TotalPatients as [TotalPatients], @Exclusions as [Exclusions],  @QualifiedCount2 as [QualifiedCount],
--	@percent as [Percent],
--	@Description + ' (tobacco use cessation counseling)' as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0027',
		'1',
		'2',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount2,
		@percent,
		@Description + ' (tobacco use cessation counseling)'
	)

END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0028a_TobaccoUseAssessment]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0028a_TobaccoUseAssessment] AS' 
END
GO
ALTER PROCEDURE [dbo].[ARRA_0028a_TobaccoUseAssessment](@StartDate DATETIME, @EndDate DATETIME)
AS
BEGIN

--declare @StartDate DATETIME
--declare @EndDate DATETIME

--set @StartDate = '8/1/2010'
--set @EndDate = '12/31/2010'

DECLARE @PatientUid uniqueidentifier

declare @TotalPatients int
declare @QualifiedCount int
declare @Exclusions int
declare @percent float
declare @IsPregnant bit
declare @metDenominator bit
declare @metNumerator bit
declare @metExclusion bit
declare @tempCnt int


declare @24MonthsAgo DateTime
declare @18YearsAgo DateTime

declare @i int
declare @tempList varchar(MAX)
SET NOCOUNT ON

-- load CPT codes for Encounter 2 or more visit
declare @LevelOfService2 table
(
	Code varchar(255)
)

SET @tempList = '96150, 96152, ' + -- Encounter Health and Behavior Assessment
				'97003, 97004, ' + -- Encounter Occupational Therapy
				'99201, 99202, 99203, 99204, 99205, 99212, 99213, 99214, 99215, ' + -- Encounter Office Visit
				'90801, 90802, 90804, 90805, 90806, 90807, 90808, 90809, ' + -- Encounter Psychiatric & Psychologic
				'90810, 90811, 90812, 90813, 90814, 90815, 90845, 90862'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LevelOfService2 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LevelOfService2 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for Encounter 1 or more visit
declare @LevelOfService1 table
(
	Code varchar(255)
)

SET @tempList = '99411, 99412, ' + -- Encounter Prev Med Group Counseling
				'99420, 99429, ' + -- Encounter Prev Med Other Services
				'99385, 99386, 99387, 99395, 99396, 99397, ' + -- Encounter Prev Med Services 18 and Older
				'99401, 99402, 99403, 99404' -- Encounter Prev Med-Individual counseling

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LevelOfService1 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LevelOfService1 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

DECLARE @TobaccoHistoryAnswers TABLE (AnswerUid UNIQUEIDENTIFIER NOT NULL)

INSERT INTO @TobaccoHistoryAnswers
	SELECT rel.AnswerUid 
	FROM ListQuestion lq 
	INNER JOIN RelAnswerGroupAnswer rel ON lq.AnswerGroupUid = rel.AnswerGroupUid
		AND lq.HistoryGroupUid = '00000000-0000-0000-0000-000000000106' -- HistoryGroupSocialHistory
		AND lq.AnswerGroupUid = '00000000-0000-0000-0000-000000000008' -- Tobacco history

SET @24MonthsAgo = CONVERT(varchar, DATEADD(month, -24, @StartDate), 101)
SET @18YearsAgo = CONVERT(varchar, DATEADD(year, -18, @EndDate), 101)

SET @Exclusions = 0
SET @TotalPatients = 0
SET @QualifiedCount = 0

DECLARE _cursorOutside CURSOR FOR 
	SELECT DISTINCT pl.PatientUid, pl.IsPregnant
	FROM #PatientList pl
	WHERE pl.BirthDate <= @18YearsAgo AND
				((pl.DeathDate is null) or (pl.DeathDate > @EndDate))
		
OPEN _cursorOutside
FETCH NEXT FROM _cursorOutside INTO @PatientUid, @IsPregnant

WHILE (@@fetch_status <> -1)
BEGIN
	IF (@@fetch_status <> -2)
	BEGIN
		SET @metNumerator = 0
		SET @metExclusion = 0
		SET @metDenominator = 0
		SET @tempCnt = 0
					
		-- BEGIN denominator
			-- does the physician have a relationship with the patient?
			-- two or more "encounters"
			SELECT @tempCnt = COUNT(*) 
			FROM Visit v
				INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
					AND v.PatientUid = @PatientUid
					AND (VisitTypeUid is null OR VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
				INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
				INNER JOIN @LevelOfService2 code ON lp.Code = code.Code
		
			IF (@tempCnt < 2)
			BEGIN
				-- if the patient has fewer than 2 visit try the Encounter codes for one or more visits
				SELECT @tempCnt = COUNT(*) 
				FROM Visit v
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						AND v.PatientUid = @PatientUid
						AND (VisitTypeUid is null OR VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @LevelOfService1 code ON lp.Code = code.Code
			END
		
			IF (@tempCnt > 0)
			BEGIN
				SET @metDenominator = 1
			END	
		-- END denominator
		
		IF (@metDenominator = 1)
		BEGIN -- numerator
			-- has social history about "tobacco use" or "tobacco non-use" be collected in last 24 months
			SELECT @tempCnt = COUNT(*) 
			FROM PatientHistory ph 
			INNER JOIN PatientHistoryDetail phd ON ph.PatientHistoryUid = phd.PatientHistoryUid
				AND ph.PatientUid = @PatientUid
				AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000106' -- HistoryGroupSocialHistory
				AND (InactiveDate is null OR ActiveDate >= @24MonthsAgo) AND (InactiveDate is null OR InactiveDate > @StartDate)
				AND phd.QuestionUid = '00000000-0000-0000-0000-000000000008' -- Tobacco history
				AND phd.AnswerUid IN (SELECT AnswerUid FROM @TobaccoHistoryAnswers)
				
			IF (@tempCnt > 0)
			BEGIN
				SET @metNumerator = 1
			END
		END -- of numerator
		
		-- no exclusions
		
		-- adjust counts
		IF (@metDenominator = 1)
		BEGIN
			SET @TotalPatients = @TotalPatients + 1
			IF (@metExclusion =	1)
			BEGIN
				SET @Exclusions = @Exclusions + 1
				IF (@metNumerator = 0)
				BEGIN
					SET @TotalPatients = @TotalPatients - 1
				END
			END
			
			IF (@metNumerator = 1)
			BEGIN
				SET @QualifiedCount = @QualifiedCount + 1
			END
		END -- of IF (@metDenominator = 1)
	END -- of IF (@@fetch_status <> -2)
	
	FETCH NEXT FROM _cursorOutside INTO @PatientUid, @IsPregnant
END -- of while
CLOSE _cursorOutside
DEALLOCATE _cursorOutside

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

DECLARE @Description varchar(MAX)

SELECT @Description = Name FROM ListARRAReports WHERE ARRAReportsUid = '98F73F32-EF7C-428F-9711-77A5CB962468'

--SELECT '0028a' as [NQF], '1' as [Population Criteria], '1' as [Numerator],
--	@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0028a',
		'1',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description
	)

END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0028b_TobaccoCessationIntervention]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0028b_TobaccoCessationIntervention] AS' 
END
GO
ALTER PROCEDURE [dbo].[ARRA_0028b_TobaccoCessationIntervention] (@StartDate DATETIME, @EndDate DATETIME)
AS
BEGIN

--declare @StartDate DATETIME
--declare @EndDate DATETIME

--set @StartDate = '1/1/2000'
--set @EndDate = '12/31/2011'

SET NOCOUNT ON

DECLARE @PatientUid uniqueidentifier

declare @TotalPatients int
declare @QualifiedCount int
declare @Exclusions int
declare @percent float
declare @metDenominator bit
declare @metNumerator bit
declare @metExclusion bit
declare @tempCnt int

declare @18YearsAgo DateTime
declare @24MonthsAgo DateTime

declare @i int
declare @tempList varchar(MAX)

-- load CPT codes for Encounter 2 or more visit
declare @LevelOfService2 table
(
	Code varchar(255)
)

SET @tempList = '96150, 96152, ' + -- Encounter Health and Behavior Assessment
				'97003, 97004, ' + -- Encounter Occupational Therapy
				'99201, 99202, 99203, 99204, 99205, 99212, 99213, 99214, 99215, ' + -- Encounter Office Visit
				'90801, 90802, 90804, 90805, 90806, 90807, 90808, 90809, ' + -- Encounter Psychiatric & Psychologic
				'90810, 90811, 90812, 90813, 90814, 90815, 90845, 90862'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LevelOfService2 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LevelOfService2 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for Encounter 1 or more visit
declare @LevelOfService1 table
(
	Code varchar(255)
)

SET @tempList = '99411, 99412, ' + -- Encounter Prev Med Group Counseling
				'99420, 99429, ' + -- Encounter Prev Med Other Services
				'99385, 99386, 99387, 99395, 99396, 99397, ' + -- Encounter Prev Med Services 18 and Older
				'99401, 99402, 99403, 99404' -- Encounter Prev Med-Individual counseling

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LevelOfService1 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LevelOfService1 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for procedures indicative of Tobacco Use Cessation Counseling
declare @TobaccoCounselingCPT table
(
	Code varchar(255)
)

SET @tempList = '99406, 99407'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @TobaccoCounselingCPT (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @TobaccoCounselingCPT (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

DECLARE @RxNorm table
(
	RxNormCode varchar(255)
)

SET @tempList = '105075, 198029, 198030, 198031, 198406, 198407, 199677, 227177, 250983, ' +
				'311975, 314119, 359817, 359818, 388082, 636353' -- Smoking Cessation Agents

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @RxNorm (RxNormCode) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @RxNorm (RxNormCode) VALUES ((RTRIM(LTRIM(@tempList))))		
		SET @tempList = ''
	END
END	
	
SET @18YearsAgo = CONVERT(varchar, DATEADD(year, -18, @StartDate), 101)
SET @24MonthsAgo = CONVERT(varchar, DATEADD(month, -24, @StartDate), 101)

SET @Exclusions = 0
SET @TotalPatients = 0
SET @QualifiedCount = 0

DECLARE _cursorOutside CURSOR FOR 
	SELECT DISTINCT pl.PatientUid
	FROM #PatientList pl
	WHERE pl.BirthDate <= @18YearsAgo AND
				((pl.DeathDate is null) or (pl.DeathDate > @EndDate))
		
OPEN _cursorOutside
FETCH NEXT FROM _cursorOutside INTO @PatientUid

WHILE (@@fetch_status <> -1)
BEGIN
	IF (@@fetch_status <> -2)
	BEGIN
		SET @metNumerator = 0
		SET @metExclusion = 0
		SET @metDenominator = 0
		SET @tempCnt = 0
							
		-- BEGIN denominator
			-- does the physician have a relationship with the patient?
			-- two or more "encounters"
			SELECT @tempCnt = COUNT(*) 
			FROM Visit v
				INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
					AND v.PatientUid = @PatientUid
					AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
					AND vp.IsDelete = 0
				INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
				INNER JOIN @LevelOfService2 code ON lp.Code = code.Code
		
			IF (@tempCnt < 2)
			BEGIN
				-- if the patient has fewer than 2 visit try the Encounter codes for one or more visits
				SELECT @tempCnt = COUNT(*) 
				FROM Visit v
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						AND v.PatientUid = @PatientUid
						AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
						AND vp.IsDelete = 0
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @LevelOfService1 code ON lp.Code = code.Code
			END
			
			IF (@tempCnt > 0)
			BEGIN
				-- does the patient have a social history of tobacco use
				SELECT @tempCnt = COUNT(*)
				FROM PatientHistory ph 
				INNER JOIN PatientHistoryDetail phd ON phd.PatientHistoryUid = ph.PatientHistoryUid
				AND ph.PatientUid = @PatientUid
				AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000106' -- SocialHistoryUid 
				AND phd.AnswerUid IN 
					('83569607-629E-4F31-A10B-AF2A34326E1E', -- SocialHistory_TobaccoHistory_CurrentlySmokeless
					 '00000000-0000-0000-0000-000000000048', -- SocialHistory_TobaccoHistory_CurrentlySmokes
					 '292F21B1-9CA3-4ACE-B5CD-FE73BF1B3A31', -- SocialHistory_TobaccoHistory_EverydaySmoker
					 '809D9F30-5E2C-4552-A7A9-A70E2EEB6031'  -- SocialHistory_TobaccoHistory_SomeDaySmoker
					 )
				AND (InactiveDate is null OR ActiveDate >= @24MonthsAgo) AND (InactiveDate is null OR InactiveDate > @StartDate)
				
				IF (@tempCnt > 0)
				BEGIN
					SET @metDenominator = 1
				END	
			END
		-- END denominator
		
		IF (@metDenominator = 1)
		BEGIN -- numerator
			
			SET @tempCnt = 0
						
			-- look for a printed education form for PQRI measure 115 - Advising Smokers to Quit; active or not active
			SELECT @tempCnt = COUNT(*)
			FROM Visit v
			INNER JOIN VisitEduForm vef ON v.VisitUid = vef.VisitUid 
				AND v.PatientUid = @PatientUid AND v.VisitDate >= @24MonthsAgo
				AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
				AND vef.IsDelete = 0
				AND vef.PrintedDate is not null
			INNER JOIN ListEduForm lef ON vef.EduFormUid = lef.EduFormUid
				AND lef.PQRIMeasureUid IN (SELECT PQRIMeasureUid FROM ListPQRIMeasure lpm WHERE lpm.ExternalID like '%115%')
				
			IF (@tempCnt = 0)
			BEGIN
				-- look in visit sp	for a Tobacco Counseling CPT
				SELECT @tempCnt = COUNT(*) 
				FROM Visit v
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						AND v.PatientUid = @PatientUid AND v.VisitDate >= @24MonthsAgo
						AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
						AND vp.IsDelete = 0
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @TobaccoCounselingCPT cpt ON lp.Code = cpt.Code
			END
			
			IF (@tempCnt = 0)
			BEGIN
				-- is the patient currently taking any Smoking Cessation Agents
				
				-- try dispensable first
				SELECT @tempCnt = COUNT(*)
				FROM RelPatientMedication rel
					INNER JOIN MedicationSIG sig ON rel.MedicationSIGUid = sig.MedicationSIGUid
												AND rel.PatientUid = @PatientUid
												AND sig.DiscontinueReasonUid is null
												AND sig.OverallStartDate >= @24MonthsAgo
					CROSS APPLY (
					   SELECT TOP 1 rev.*
					   FROM dbo.NDD_SearchRxNorm rev 
					   INNER JOIN @RxNorm norm ON norm.RxNormCode = rev.RxNormCode
					   WHERE rev.IsDelete = 0 
					     AND rev.medid = sig.FDB_MEDID) rxn			
			END 
			
			IF (@tempCnt > 0)
			BEGIN
				SET @metNumerator = 1
			END	
			
			
		END -- of numerator
		
		-- no exclusions
		
		-- adjust counts
		IF (@metDenominator = 1)
		BEGIN
			SET @TotalPatients = @TotalPatients + 1
			-- no exclusion; remark out
			--IF (@metExclusion =	1)
			--BEGIN
			--	SET @Exclusions = @Exclusions + 1
			--	IF (@metNumerator = 0)
			--	BEGIN
			--		SET @TotalPatients = @TotalPatients - 1
			--	END
			--END
			
			IF (@metNumerator = 1)
			BEGIN
				SET @QualifiedCount = @QualifiedCount + 1
			END
		END -- of IF (@metDenominator = 1)
	END -- of IF (@@fetch_status <> -2)
	
	FETCH NEXT FROM _cursorOutside INTO @PatientUid
END -- of while
CLOSE _cursorOutside
DEALLOCATE _cursorOutside

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

DECLARE @Description varchar(MAX)

SELECT @Description = Name FROM ListARRAReports WHERE ARRAReportsUid = 'BCBEC66D-4542-446F-B647-D9FF84F82421'

--SELECT '0028b' as [NQF], '1' as [Population Criteria], '1' as [Numerator],
--	@TotalPatients as [TotalPatients], @Exclusions as [Exclusions],  @QualifiedCount as [QualifiedCount], 
--	@percent as [Percent],
--	@Description as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0028b',
		'1',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description
	)

END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0031_BreastCancerScreening]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0031_BreastCancerScreening] AS' 
END
GO

ALTER PROCEDURE [dbo].[ARRA_0031_BreastCancerScreening](@StartDate DATETIME, @EndDate DATETIME)
AS
BEGIN

--declare @StartDate DATETIME
--declare @EndDate DATETIME

--set @StartDate = '09/06/2011'
--set @EndDate = '09/06/2011'

SET NOCOUNT ON

DECLARE @PatientUid uniqueidentifier

declare @TotalPatients int
declare @QualifiedCount int
declare @Exclusions int
declare @percent float
declare @metDenominator bit
declare @metNumerator bit
declare @metExclusion bit
declare @tempCnt int

declare @2YearsAgo DateTime
declare @41YearsAgo DateTime
declare @68YearsAgo DateTime

declare @i int
declare @tempList varchar(MAX)

-- load CPT codes for out patient
declare @LevelOfService table
(
	Code varchar(255)
)

SET @tempList = '99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, 99215, ' +
				'99217, 99218, 99219, 99220, 99241, 99242, 99243, 99244, 99245, 99341, ' +
				'99342, 99343, 99344, 99345, 99347, 99348, 99349, 99350, 99384, 99385, ' +
				'99386, 99387, 99394, 99395, 99396, 99397, 99401, 99402, 99403, 99404, ' +
				'99411, 99412, 99420, 99429, 99455, 99456'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes Bilateral Mastectomy
declare @BilateralMastectomyCPT table
(
	Code varchar(255)
)

SET @tempList = '19180, 19200, 19220, 19240, 19303, 19304, 19305, 19306, 19307'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @BilateralMastectomyCPT (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @BilateralMastectomyCPT (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END


-- load CPT codes Unilateral Mastectomy
declare @UnilateralMastectomyCPT table
(
	Code varchar(255)
)

SET @tempList = '19180, 19200, 19220, 19240, 19303, 19304, 19305, 19306, 19307'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @UnilateralMastectomyCPT (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @UnilateralMastectomyCPT (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END


-- load ICD9 codes Bilateral Mastectomy
declare @BilateralMastectomyICD9 table
(
	Code varchar(255)
)

SET @tempList = '85.42, 85.44, 85.46, 85.48'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @BilateralMastectomyICD9 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @BilateralMastectomyICD9 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load ICD9 codes Unilateral Mastectomy
declare @UnilateralMastectomyICD9 table
(
	Code varchar(255)
)

SET @tempList = '85.41, 85.43, 85.45, 85.47'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @UnilateralMastectomyICD9 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @UnilateralMastectomyICD9 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for breast cancer screening
declare @BreastCancerScreeningCPT table
(
	Code varchar(255)
)

SET @tempList = '76090, 76091, 76092, 77055, 77056, 77057'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @BreastCancerScreeningCPT (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @BreastCancerScreeningCPT (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

---- load ICD9 codes for breast cancer screening
--declare @BreastCancerScreeningICD9 table
--(
--	Code varchar(255)
--)

--INSERT INTO @BreastCancerScreeningICD9
--	SELECT DiagnosisCode9 FROM ListDiagnosis 
--		WHERE LongDescription like '%mammogram%' or LongDescription like '%mammography%'

-- cannot found any ICD9 code in document for 0031
--SET @tempList = ''

--WHILE len(@tempList) > 0
--BEGIN
--	SET @i = CHARINDEX(',', @tempList)
	
--	if (@i > 0)
--	BEGIN
--		INSERT INTO @BreastCancerScreeningICD9 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
--		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
--	END
--	ELSE BEGIN
--		INSERT INTO @BreastCancerScreeningICD9 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
--		SET @tempList = ''
--	END
--END


DECLARE @Visit TABLE
(
	VisitUid  uniqueidentifier
)

SET @2YearsAgo = CONVERT(varchar, DATEADD(year, -2, @StartDate), 101)
SET @41YearsAgo = CONVERT(varchar, DATEADD(year, -41, @StartDate), 101)
SET @68YearsAgo = CONVERT(varchar, DATEADD(year, -68, @StartDate), 101)

SET @Exclusions = 0
SET @TotalPatients = 0
SET @QualifiedCount = 0

DECLARE _cursorOutside CURSOR FOR 
	SELECT DISTINCT pl.PatientUid 
	FROM #PatientList pl
	WHERE pl.IsFemale = 1 AND pl.BirthDate <= @41YearsAgo AND pl.BirthDate >= @68YearsAgo 
		AND ((pl.DeathDate is null) or (pl.DeathDate > @EndDate))
		
OPEN _cursorOutside
FETCH NEXT FROM _cursorOutside INTO @PatientUid

WHILE (@@fetch_status <> -1)
BEGIN
	IF (@@fetch_status <> -2)
	BEGIN
		SET @metNumerator = 0
		SET @metDenominator = 0
		SET @metExclusion = 0
		SET @tempCnt = 0
		
		begin -- denominator
			DELETE @Visit
			-- get visits for the last two years
			INSERT INTO @Visit
			SELECT VisitUid FROM Visit 
				WHERE PatientUid = @PatientUid AND VisitDate >= @2YearsAgo
						AND (VisitTypeUid is null OR VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
			
			-- does the patient have a history of bilateral mastectomy
			SELECT @tempCnt = COUNT(*) 
			FROM PatientProblemDiagnosisHistory pdx 
				INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid AND lps.ActiveStatus = 1 
				INNER JOIN @BilateralMastectomyICD9 dia ON pdx.Code9 = dia.Code
			WHERE pdx.PatientUid = @PatientUid AND pdx.IsDelete = 0 AND pdx.IsPatientProblem = 0
			
			IF (@tempCnt = 0)
			BEGIN
				-- if not, has the patient had a bilateral mastectomy procedure
				SELECT @tempCnt = COUNT(*) 
				FROM Visit v
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						AND v.PatientUid = @PatientUid
						AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
						AND vp.IsDelete = 0
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @BilateralMastectomyCPT cpt ON lp.Code = cpt.Code
			END
			
			IF (@tempCnt = 0)
			BEGIN
				-- if not look in surgical history for mastectomy
				SELECT @tempCnt = COUNT(*) 
				FROM PatientHistory ph
				INNER JOIN PatientHistoryDetail phd ON ph.PatientHistoryUid = phd.PatientHistoryUid
				AND ph.PatientUid = @PatientUid
				AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000103' -- Surgical History
				AND phd.QuestionUid = '00000000-0000-0000-0000-000000103078' -- mastectomy
			END
			
			IF (@tempCnt = 0)
			BEGIN
				-- does the patient have a history of more than one unilateral mastectomy
				SELECT @tempCnt = COUNT(*) 
				FROM PatientProblemDiagnosisHistory pdx 
					INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid AND lps.ActiveStatus = 1 
					INNER JOIN @UnilateralMastectomyICD9 dia ON pdx.Code9 = dia.Code
				WHERE pdx.PatientUid = @PatientUid AND pdx.IsDelete = 0 AND pdx.IsPatientProblem = 0
				
				IF (@tempCnt < 2)
				BEGIN
					SET @tempCnt = 0
				END
			END
			
			IF (@tempCnt = 0)
			BEGIN
				-- if not, has the patient had a more than one unilateral mastectomy procedure
				SELECT @tempCnt = COUNT(*) 
				FROM Visit v
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						AND v.PatientUid = @PatientUid
						AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
						AND vp.IsDelete = 0
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @UnilateralMastectomyCPT cpt ON lp.Code = cpt.Code
					
				IF (@tempCnt < 2)
				BEGIN
					SET @tempCnt = 0
				END
			END
			
			IF (@tempCnt = 0)
			BEGIN
				SET @tempCnt = 0
				-- must have an outpatient level of service
				SELECT @tempCnt = COUNT(*) 
				FROM @Visit v 
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid 
						AND vp.IsDelete = 0 
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @LevelOfService code ON lp.Code = code.Code
					
				IF (@tempCnt > 0)
				BEGIN
					SET @metDenominator = 1
				END
			END
		end -- of denominator
		
		IF (@metDenominator = 1)
		BEGIN -- numerator
	
			-- look in services provided to see if a breast cancer screening has been performed
			SELECT @tempCnt = COUNT(*)
			FROM @Visit v
			INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid AND vp.IsPerformed = 1 AND vp.IsDelete = 0
			INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
			INNER JOIN @BreastCancerScreeningCPT screening ON lp.Code = screening.Code
			
			IF (@tempCnt = 0)
			BEGIN
				-- look in services order to see if a breast cancer screening has been performed
				SELECT @tempCnt = COUNT(*)
				FROM @Visit v
				INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid AND vp.IsDelete = 0
				INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
				INNER JOIN @BreastCancerScreeningCPT screening ON lp.Code = screening.Code
				INNER JOIN ObservationOrder oo ON vp.VisitProcedureUid = oo.VisitProcedureUid
					AND oo.ResultStatusID IN (7, 8, 9)
			END
			
			--IF (@tempCnt = 0)
			--BEGIN
			--	-- look for visit diagnosis to see if a breast cancer screening has been performed
			--	SELECT @tempCnt = COUNT(*)
			--	FROM @Visit v
			--	INNER JOIN VisitDiagnosis vd ON v.VisitUid = vd.VisitUid
			--		AND vd.IsDelete = 0
			--	INNER JOIN ListDiagnosis ld ON ld.DiagnosisUid = vd.DiagnosisUid
			--	INNER JOIN @BreastCancerScreeningICD9 screening ON screening.Code = ld.DiagnosisCode9
			--END

			IF (@tempCnt > 0)
			BEGIN
				SET @metNumerator = 1
			END
			
		END -- of numerator
		
		--IF (@metDenominator = 1)
		--BEGIN -- exclusion	
		--		no exclusions
		--END -- of exclusion
		
		-- adjust counts
		IF (@metDenominator = 1)
		BEGIN
			SET @TotalPatients = @TotalPatients + 1
			IF (@metExclusion =	1)
			BEGIN
				SET @Exclusions = @Exclusions + 1
				IF (@metNumerator = 0)
				BEGIN
					SET @TotalPatients = @TotalPatients - 1
				END
			END
			
			IF (@metNumerator = 1)
			BEGIN
				SET @QualifiedCount = @QualifiedCount + 1
			END
		END -- of IF (@metDenominator = 1)
	END -- of IF (@@fetch_status <> -2)
	
	FETCH NEXT FROM _cursorOutside INTO @PatientUid
END -- of while
CLOSE _cursorOutside
DEALLOCATE _cursorOutside

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

DECLARE @Description varchar(MAX)

SELECT @Description = Name FROM ListARRAReports WHERE ARRAReportsUid = '5318365A-B224-4C9F-BFD3-C5265C369E03'

--SELECT '0031' as [NQF], '1' as [Population Criteria], '1' as [Numerator],
--	@TotalPatients as [TotalPatients], @Exclusions as [Exclusions],  @QualifiedCount as [QualifiedCount], 
--	@percent as [Percent],
--	@Description as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0031',
		'1',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description
	)

END



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0032_CervicalCancerScreening]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0032_CervicalCancerScreening] AS' 
END
GO



ALTER PROCEDURE [dbo].[ARRA_0032_CervicalCancerScreening] (@StartDate DATETIME, @EndDate DATETIME)
AS
BEGIN

--declare @StartDate DATETIME
--declare @EndDate DATETIME

--set @StartDate = '1/1/2000'
--set @EndDate = '12/31/2010'

SET NOCOUNT ON

DECLARE @PatientUid uniqueidentifier

declare @TotalPatients int
declare @QualifiedCount int
declare @Exclusions int
declare @percent float
declare @metDenominator bit
declare @metNumerator bit
declare @metExclusion bit
declare @tempCnt int

declare @2YearsAgo DateTime
declare @3YearsAgo DateTime
declare @23YearsAgo DateTime
declare @64YearsAgo DateTime

declare @i int
declare @tempList varchar(MAX)

SET @2YearsAgo = CONVERT(varchar, DATEADD(year, -2, @EndDate), 101)
SET @3YearsAgo = CONVERT(varchar, DATEADD(year, -3, @EndDate), 101)
SET @23YearsAgo = CONVERT(varchar, DATEADD(year, -23, @EndDate), 101)
SET @64YearsAgo = CONVERT(varchar, DATEADD(year, -64, @EndDate), 101)

SET @Exclusions = 0
SET @TotalPatients = 0
SET @QualifiedCount = 0

DECLARE @Visit TABLE
(
	VisitUid uniqueidentifier
)

-- load ICD9 codes for OB/GYN encounter
declare @OBGYN_ICD9 table
(
	Code varchar(255)
)

SET @tempList = 'V24, V25, V26, V27, V28, V45.5, V61.5, V61.6, V61.7, V69.2, V72.3, V72.4'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @OBGYN_ICD9 (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @OBGYN_ICD9 (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for Encounter Office & Outpatient Consult
declare @LevelOfService table
(
	Code varchar(255)
)

SET @tempList = '99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, 99215, 99217, ' + 
				'99218, 99219, 99220, 99241, 99242, 99243, 99244, 99245, 99341, 99342, 99343, ' +
				'99344, 99345, 99347, 99348, 99349, 99350, 99384, 99385, 99386, 99387, 99394, ' +
				'99395, 99396, 99397, 99401, 99402, 99403, 99404, 99411, 99412, 99420, 99429, 99455, 99456'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for a hysterectomy
declare @HysterectomyCPT table
(
	Code varchar(255)
)
SET @tempList = '51925, 56308, 58150, 58152, 58200, 58210, 58240, 58260, 58262, 58263, 58267, ' +
				'58270, 58275, 58280, 58285, 58290, 58291, 58292, 58293, 58294, 58550, 58552, ' +
				'58553, 58554, 58570, 58571, 58572, 58573, 58951, 58953, 58954, 58956, 59135'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @HysterectomyCPT (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @HysterectomyCPT (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for PAP test
declare @PAPCPT table
(
	Code varchar(255)
)
SET @tempList = '88141, 88142, 88143, 88147, 88148, 88150, 88152, 88153, 88154, 88155, 88164, 88165, 88166, 88167, 88174, 88175,G0123, G0124, G0141, G0143, G0144, G0145, G0147, G0148, P3000, P3001, Q0091'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @PAPCPT (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @PAPCPT (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END


declare @LOINC table
(
	LOINCCode varchar(255)
)

-- load uid for loinc codes for Cervical Cancer Screening
SET @tempList = '10524-7, 18500-9, 19762-4, 19764-0, 19765-7, 19766-5, 19774-9, 33717-0, 47527-7, 47528-5'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LOINC (LOINCCode) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LOINC (LOINCCode) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

declare @ObservationItem table
(
	ObservationItemUid uniqueidentifier
)

INSERT INTO @ObservationItem 
	SELECT loi.ObservationItemUid 
	FROM ListObservationItem loi 
		INNER JOIN ListLOINC ll ON loi.LOINCUid = ll.LOINCUid
		INNER JOIN @LOINC loinc ON ll.Name = loinc.LOINCCode

		
DECLARE _cursorOutside CURSOR FOR 
	SELECT DISTINCT pl.PatientUid 
	FROM #PatientList pl
	WHERE pl.IsFemale = 1 
			AND pl.BirthDate <= @23YearsAgo AND pl.BirthDate >= @64YearsAgo AND ((pl.DeathDate is null) or (pl.DeathDate > @EndDate))
		
OPEN _cursorOutside
FETCH NEXT FROM _cursorOutside INTO @PatientUid

WHILE (@@fetch_status <> -1)
BEGIN
	IF (@@fetch_status <> -2)
	BEGIN
		SET @metNumerator = 0
		SET @metDenominator = 0
		SET @metExclusion = 0
		SET @tempCnt = 0
			
		begin -- denominator
	
			-- look in surgical history for a hysterectomy 
			SELECT @tempCnt = COUNT(*) 
			FROM PatientHistory ph
			INNER JOIN PatientHistoryDetail phd ON ph.PatientHistoryUid = phd.PatientHistoryUid
			AND ph.PatientUid = @PatientUid
			AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000103' -- Surgical History
			AND phd.QuestionUid = '00000000-0000-0000-0000-000000103076' -- Hysterectomy
				
			IF (@tempCnt = 0)
			BEGIN
				-- has the patient had a hysterectomy procedure
				SELECT @tempCnt = COUNT(*) 
				FROM Visit v
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						AND v.PatientUid = @PatientUid
						AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
						AND vp.IsDelete = 0
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @HysterectomyCPT non ON lp.Code = non.Code
			END
			
			-- if a history a hysterectomy has been found no need to continue with any other denominator test
			IF (@tempCnt = 0)
			BEGIN
				-- test is there at less one office visit
				SELECT @tempCnt = COUNT(*) 
				FROM Visit v
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						AND v.PatientUid = @PatientUid
						AND v.VisitDate >= @2YearsAgo
						AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
						AND vp.IsDelete = 0
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @LevelOfService non ON lp.Code = non.Code
				
				IF (@tempCnt = 0)
				BEGIN
					
					DELETE @Visit
					-- get all visit
					INSERT INTO @Visit
						SELECT VisitUid 
						FROM Visit v
						WHERE v.PatientUid = @PatientUid AND v.VisitDate >= @2YearsAgo
						AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
					
					SELECT @tempCnt = COUNT(*) 
					FROM VisitDiagnosis vd
					INNER JOIN @OBGYN_ICD9 icd9 ON vd.Code like icd9.Code + '%'
					WHERE vd.VisitUid IN (SELECT VisitUid FROM @Visit) 

				END
				
				IF (@tempCnt > 0)
				BEGIN
					SET @metDenominator = 1
				END
			END
		end -- of denominator
				
		IF (@metDenominator = 1)
		BEGIN -- numerator	
			SET @tempCnt = 0

			-- had a PAP lab test results within the last 3 years
			SELECT @tempCnt = COUNT(*)
			FROM Visit v
				INNER JOIN ObservationOrder oo ON v.VisitUid = oo.VisitUid and v.PatientUid=@PatientUid
						AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
						AND oo.IsDelete = 0
				INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
				AND ov.ObservationItemUid IN (SELECT ObservationItemUid FROM @ObservationItem)
				AND COALESCE(ExtractDate, ResultDate, ReceiveDate, PerformDate, 
								OrderDate, ov.LastModifiedDate, oo.LastModifiedDate) >= @3YearsAgo
				
			IF (@tempCnt = 0)
			BEGIN
				-- had a PAP test procedure within the last 3 years
				SELECT @tempCnt = COUNT(*) 
				FROM Visit v
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
						AND v.PatientUid = @PatientUid AND v.VisitDate >= @3YearsAgo
						AND (v.VisitTypeUid is null OR v.VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
						AND vp.IsDelete = 0
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
					INNER JOIN @PAPCPT non ON lp.Code = non.Code
			END		
		
			IF (@tempCnt > 0)
			BEGIN
				-- met numerator; had either a lab PAP test results or a PAP test procedure
				SET @metNumerator = 1
			END
		END -- of numerator
		
		--IF (@metDenominator = 1)
		--BEGIN -- exclusion	
				-- no exclusions
		--END -- of exclusion
		
		-- adjust counts
		IF (@metDenominator = 1)
		BEGIN
			SET @TotalPatients = @TotalPatients + 1
			IF (@metExclusion =	1)
			BEGIN
				SET @Exclusions = @Exclusions + 1
				IF (@metNumerator = 0)
				BEGIN
					SET @TotalPatients = @TotalPatients - 1
				END
			END
			
			IF (@metNumerator = 1)
			BEGIN
				SET @QualifiedCount = @QualifiedCount + 1
			END
		END -- of IF (@metDenominator = 1)
	END -- of IF (@@fetch_status <> -2)
	
	FETCH NEXT FROM _cursorOutside INTO @PatientUid
END -- of while
CLOSE _cursorOutside
DEALLOCATE _cursorOutside

if (@TotalPatients > 0)
BEGIN
	SET @percent = @QualifiedCount
	SET @percent = (@percent / @TotalPatients) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

DECLARE @Description varchar(MAX)

SELECT @Description = Name FROM ListARRAReports WHERE ARRAReportsUid = '0852E77A-6F06-4164-A5F7-4160A100DBD0'

--SELECT '0032' as [NQF], '1' as [Population Criteria], '1' as [Numerator],
--	@TotalPatients as [TotalPatients], @Exclusions as [Exclusions],  @QualifiedCount as [QualifiedCount], 
--	@percent as [Percent],
--	@Description as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0032',
		'1',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description
	)

END



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0034_ColorectalCancerScreening]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0034_ColorectalCancerScreening] AS' 
END
GO

ALTER PROCEDURE [dbo].[ARRA_0034_ColorectalCancerScreening](@StartDate DATETIME, @EndDate DATETIME)
AS
BEGIN

--declare @StartDate DATETIME
--declare @EndDate DATETIME

--set @StartDate = '1/1/2000'
--set @EndDate = '12/31/2010'

DECLARE @PatientUid uniqueidentifier

declare @TotalPatients int
declare @QualifiedCount int
declare @Exclusions int
declare @percent float
declare @IsPregnant bit
declare @metDenominator bit
declare @metNumerator bit
declare @metExclusion bit
declare @tempCnt int

declare @50YearsAgo DateTime
declare @75YearsAgo DATETIME
declare @10YearsAgo DATETIME
declare @5YearsAgo DATETIME

declare @i int
declare @tempList varchar(MAX)

SET NOCOUNT ON

DECLARE @Visit TABLE
(
	VisitUid uniqueidentifier,
	VisitDate DateTime
)

-- load CPT codes for Encounter Outpatient & Nursing Facility
declare @LevelOfService table
(
	Code varchar(255)
)

SET @tempList = '99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, 99215, ' +
				'99217, 99218, 99219, 99220, 99241, 99242, 99243, 99244, 99245, 99341, ' +
				'99342, 99343, 99344, 99345, 99347, 99348, 99349, 99350, 99384, 99385, ' +
				'99386, 99387, 99394, 99395, 99396, 99397, 99401, 99402, 99403, 99404, ' +
				'99411, 99412, 99420, 99429, 99455, 99456'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LevelOfService (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load ICD9 codes for total colectomy
declare @ICD9CodeTotalColectomy table
(
	Code varchar(255)
)

SET @tempList = '45.8, 45.81, 45.82, 45.83'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @ICD9CodeTotalColectomy (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @ICD9CodeTotalColectomy (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for total colectomy
declare @CPTCodeTotalColectomy table
(
	Code varchar(255)
)

SET @tempList = '44150, 44151, 44152, 44153, 44155, 44156, 44157, 44158, 44210, 44211, 44212'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @CPTCodeTotalColectomy (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @CPTCodeTotalColectomy (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load ICD9 codes for colonoscopy
declare @ColonoscopyICD9Codes table
(
	Code varchar(255)
)

SET @tempList = '45.22, 45.23, 45.25, 45.42, 45.43'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @ColonoscopyICD9Codes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @ColonoscopyICD9Codes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for colonoscopy
declare @ColonoscopyCPTCodes table
(
	Code varchar(255)
)

SET @tempList = '44388, 44389, 44390, 44391, 44392, 44393, 44394, 44397, ' +
				'45355, 45378, 45379, 45380, 45381, 45382, 45383, 45384, ' +
				'45385, 45386, 45387, 45391, 45392, ' +  -- cpt code
				'G0105, G0121' -- HCPCS

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @ColonoscopyCPTCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @ColonoscopyCPTCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load ICD9 codes for flexible sigmoidoscopy
declare @FlexibleSigmoidoscopyICD9Codes table
(
	Code varchar(255)
)

SET @tempList = '45.24'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @FlexibleSigmoidoscopyICD9Codes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @FlexibleSigmoidoscopyICD9Codes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for flexible sigmoidoscopy
declare @FlexibleSigmoidoscopyCPTCodes table
(
	Code varchar(255)
)

SET @tempList = '45330, 45331, 45332, 45333, 45334, 45335, 45337, 45338, 45339, 45340, 45341, 45342, 45345'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @FlexibleSigmoidoscopyCPTCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @FlexibleSigmoidoscopyCPTCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load ICD9 codes for colorectal cancer
declare @ColorectalCancerICD9Codes table
(
	Code varchar(255)
)

SET @tempList = '153, 153.0, 153.1, 153.2, 153.3, 153.4, 153.5, 153.6, 153.7, 153.8, 153.9, 154.0, 154.1, 197.5, V10.05'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @ColorectalCancerICD9Codes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @ColorectalCancerICD9Codes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

-- load CPT codes for FOBT
declare @FOBTCPTCodes table
(
	Code varchar(255)
)

SET @tempList = 'G0328, G0394'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @FOBTCPTCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @FOBTCPTCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

declare @LOINC table
(
	LOINCCode varchar(255)
)
-- load uid for loinc codes for FOBT
SET @tempList = '12503-9, 12504-7, 14563-1, 14564-9, 14565-6, 2335-8, 27396-1, 27401-9, 27925-7, 27926-5, 29771-3'

WHILE len(@tempList) > 0
BEGIN
	SET @i = CHARINDEX(',', @tempList)
	
	if (@i > 0)
	BEGIN
		INSERT INTO @LOINC (LOINCCode) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
		SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
	END
	ELSE BEGIN
		INSERT INTO @LOINC (LOINCCode) VALUES ((RTRIM(LTRIM(@tempList))))
		SET @tempList = ''
	END
END

declare @ObservationItem table
(
	ObservationItemUid uniqueidentifier
)

INSERT INTO @ObservationItem 
	SELECT loi.ObservationItemUid 
	FROM ListObservationItem loi 
		INNER JOIN ListLOINC ll ON loi.LOINCUid = ll.LOINCUid
		INNER JOIN @LOINC loinc ON ll.Name = loinc.LOINCCode
		
SET @50YearsAgo = CONVERT(varchar, DATEADD(year, -50, @StartDate), 101)
SET @75YearsAgo = CONVERT(varchar, DATEADD(year, -75, @StartDate), 101)
SET @10YearsAgo = CONVERT(varchar, DATEADD(year, -10, @StartDate), 101)
SET @5YearsAgo = CONVERT(varchar, DATEADD(year, -5, @StartDate), 101)

SET @Exclusions = 0
SET @TotalPatients = 0
SET @QualifiedCount = 0

DECLARE _cursorOutside CURSOR FOR 
	SELECT DISTINCT pl.PatientUid 
	FROM #PatientList pl
	WHERE pl.BirthDate <= @50YearsAgo AND BirthDate >= @75YearsAgo 
		AND ((pl.DeathDate is null) or (pl.DeathDate > @EndDate))
		
OPEN _cursorOutside
FETCH NEXT FROM _cursorOutside INTO @PatientUid

WHILE (@@fetch_status <> -1)
BEGIN
	IF (@@fetch_status <> -2)
	BEGIN
		SET @metExclusion = 0
		SET @metNumerator = 0
		SET @metDenominator = 0
		
		DELETE @Visit
		-- get all visit uids that are not struck out
		INSERT INTO @Visit
			SELECT VisitUid, VisitDate FROM Visit 
				WHERE PatientUid = @PatientUid AND 
					(VisitTypeUid is null OR VisitTypeUid <> 'FB954167-9D1C-43B7-9F5B-A76260654C96') -- Strike Out
					
		-- BEGIN denominator
			SET @tempCnt = 0
			-- must have an outpatient level of service
			SELECT @tempCnt = COUNT(*) 
			FROM @Visit v 
				INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid 
					AND vp.IsDelete = 0 
				INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
				INNER JOIN @LevelOfService code ON lp.Code = code.Code

			IF (@tempCnt > 0)
			BEGIN
				SET @metDenominator = 1
				SET @tempCnt = 0
				
				-- look in surgical history for a total colectomy
				SELECT @tempCnt = COUNT(*) FROM PatientHistory ph
				INNER JOIN PatientHistoryDetail phd ON phd.PatientHistoryUid = ph.PatientHistoryUid
					AND phd.QuestionUid = '332D638B-FAE5-4795-AE47-375B46C18676' -- Total Colectomy
				WHERE ph.PatientUid = @PatientUid
				AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000103' -- Surgical History
				
				IF (@tempCnt = 0)
				BEGIN
					-- look in PatientProblemDiagnosisHistory for a total colectomy diagnosis
					SELECT @tempCnt = COUNT(*) FROM PatientProblemDiagnosisHistory pdx
					INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid 
							AND lps.ActiveStatus = 1 AND pdx.IsDelete = 0
						AND pdx.Code9 IN (SELECT Code FROM @ICD9CodeTotalColectomy)
					WHERE (pdx.PatientUid = @PatientUid AND pdx.IsPatientProblem = 0)
				END
				
				IF (@tempCnt = 0)
				BEGIN
					-- look in VisitDiagnosis for a total colectomy diagnosis
					SELECT @tempCnt = COUNT(*) FROM @Visit v
					INNER JOIN VisitDiagnosis vd ON  v.VisitUid = vd.VisitUid
						AND vd.IsDelete = 0
					WHERE vd.Code IN (SELECT Code FROM @ICD9CodeTotalColectomy)
				END
				
				IF (@tempCnt = 0)
				BEGIN
					-- look in VisitProcedure for a total colectomy procedure
					SELECT @tempCnt = COUNT(*) FROM @Visit v
					INNER JOIN VisitProcedure vp ON  v.VisitUid = vp.VisitUid
						AND vp.IsDelete = 0
					INNER JOIN ListProcedure lp ON lp.ProcedureUid = vp.ProcedureUid
						AND lp.Code IN (SELECT Code FROM @CPTCodeTotalColectomy)
				END
				
				IF (@tempCnt > 0)
				BEGIN
					SET @metDenominator = 0
				END
			END -- IF (@tempCnt > 0) have a level of service
		-- END denominator
		
		IF (@metDenominator = 1)
		BEGIN -- numerator
		
			SET @tempCnt = 0
			
			-- look for FOBT CPT codes
			SELECT @tempCnt = COUNT(*) FROM @Visit v
			INNER JOIN VisitProcedure vp ON  v.VisitUid = vp.VisitUid
				AND vp.IsDelete = 0
			INNER JOIN ListProcedure lp ON lp.ProcedureUid = vp.ProcedureUid
				AND lp.Code IN (SELECT Code FROM @FOBTCPTCodes)
						
			IF (@tempCnt = 0)
			BEGIN
				-- get lab result for FOBT
				SELECT TOP 1 @tempCnt = COUNT(*)
				FROM ObservationValue ov
				INNER JOIN ObservationOrder oo ON oo.ObservationOrderUid = ov.ObservationOrderUid
				    AND oo.IsDelete = 0
					AND oo.PatientUid = @PatientUid
					AND ov.ObservationItemUid IN (SELECT ObservationItemUid FROM @ObservationItem)
			END
			
			
			IF (@tempCnt = 0)
			BEGIN
				-- look in Dx history for patients that had a colonoscopy in the last 10 years
				SELECT @tempCnt = COUNT(*) FROM PatientProblemDiagnosisHistory pdx
				INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid 
							AND lps.ActiveStatus = 1 AND pdx.IsDelete = 0
					AND pdx.Code9 IN (SELECT Code FROM @ColonoscopyICD9Codes)
				WHERE (pdx.PatientUid = @PatientUid AND pdx.IsPatientProblem = 0)
					AND (pdx.ActiveDate >= @10YearsAgo)
			END
			
			-- look in visit procedure SP for a colonoscopy procedure in the last 10 years		
			IF (@tempCnt = 0)
			BEGIN
				SELECT @tempCnt = COUNT(*) 
				FROM @Visit v 
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid 
						AND vp.IsDelete = 0
						AND vp.IsPerformed = 1
						AND v.VisitDate >= @10YearsAgo 
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
						AND lp.Code IN (SELECT Code FROM @ColonoscopyCPTCodes)
			END
		
			-- look in visit procedure SO for a colonoscopy procedure in the last 10 years		
			IF (@tempCnt = 0)
			BEGIN
				SELECT @tempCnt = COUNT(*) 
				FROM @Visit v 
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid 
						AND vp.IsDelete = 0
						AND v.VisitDate >= @10YearsAgo 
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
						AND lp.Code IN (SELECT Code FROM @ColonoscopyCPTCodes)
					INNER JOIN ObservationOrder oo ON vp.VisitProcedureUid = oo.VisitProcedureUid
						AND oo.ResultStatusID IN (7, 8, 9)
			END
			
			if (@tempCnt = 0)
			BEGIN
				-- look in Dx history for patients that had a flexible sigmoidoscopy in the last 5 years
				SELECT @tempCnt = COUNT(*) FROM PatientProblemDiagnosisHistory pdx
				INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid 
							AND lps.ActiveStatus = 1 AND pdx.IsDelete = 0
					AND pdx.Code9 IN (SELECT Code FROM @FlexibleSigmoidoscopyICD9Codes)
				WHERE (pdx.PatientUid = @PatientUid AND pdx.IsPatientProblem = 0)
					AND (pdx.ActiveDate >= @5YearsAgo)
			END
			
			-- look in visit procedure SP for a flexible sigmoidoscopy procedure in the last 5 years		
			IF (@tempCnt = 0)
			BEGIN
				SELECT @tempCnt = COUNT(*) 
				FROM @Visit v 
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid 
						AND vp.IsDelete = 0
						AND vp.IsPerformed = 1
						AND v.VisitDate >= @5YearsAgo 
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
						AND lp.Code IN (SELECT Code FROM @FlexibleSigmoidoscopyCPTCodes)
			END
			
			-- look in visit procedure SO for a flexible sigmoidoscopy procedure in the last 5 years		
			IF (@tempCnt = 0)
			BEGIN
				SELECT @tempCnt = COUNT(*) 
				FROM @Visit v 
					INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid 
						AND vp.IsDelete = 0
						AND v.VisitDate >= @5YearsAgo 
					INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
						AND lp.Code IN (SELECT Code FROM @FlexibleSigmoidoscopyCPTCodes)
					INNER JOIN ObservationOrder oo ON vp.VisitProcedureUid = oo.VisitProcedureUid
						AND oo.ResultStatusID IN (7, 8, 9)
			END
			
			IF (@tempCnt > 0)
			BEGIN
				SET @metNumerator = 1
			END
		END -- numerator
		
		-- no need to test for exclusions if both the denominator and numerator have been met
		IF ((@metDenominator = 1) AND (@metNumerator = 0))
		BEGIN -- exclusions
			SET @tempCnt = 0	
			-- look in PatientProblemDiagnosisHistory for patients with colon cancer
			SELECT @tempCnt = COUNT(*) FROM PatientProblemDiagnosisHistory pdx
					WHERE pdx.PatientUid = @PatientUid 
					AND pdx.IsPatientProblem = 0
					AND pdx.Code9 IN (SELECT Code FROM @ColorectalCancerICD9Codes)
			IF (@tempCnt = 0)
			BEGIN
				-- look in VisitDiagnosis for patients with colon cancer
				SELECT @tempCnt = COUNT(*) FROM VisitDiagnosis vd
				WHERE vd.IsDelete = 0
					AND vd.VisitUid IN (SELECT VisitUid FROM Visit WHERE PatientUid = @PatientUid)
					AND vd.Code IN (SELECT Code FROM @ColorectalCancerICD9Codes)
			END
			
			IF (@tempCnt > 0)
			BEGIN
				SET @metExclusion = 1
			END
		END -- of exclusions
	
		-- adjust counts
		IF (@metDenominator = 1)
		BEGIN
			SET @TotalPatients = @TotalPatients + 1
			IF (@metExclusion =	1)
			BEGIN
				SET @Exclusions = @Exclusions + 1
				IF (@metNumerator = 0)
				BEGIN
					SET @TotalPatients = @TotalPatients - 1
				END
			END
			
			IF (@metNumerator = 1)
			BEGIN
				SET @QualifiedCount = @QualifiedCount + 1
			END
		END -- of IF (@metDenominator = 1)
	END -- of IF (@@fetch_status <> -2)
	
	FETCH NEXT FROM _cursorOutside INTO @PatientUid
END -- of while
CLOSE _cursorOutside
DEALLOCATE _cursorOutside
	
-- report Colorectal Cancer Screening
IF (@TotalPatients > 0)
BEGIN
	SET @percent = @TotalPatients
	SET @percent = (@QualifiedCount / @percent) * 100.0
END
ELSE BEGIN
	SET @percent = 0
END

DECLARE @Description varchar(MAX)

SELECT @Description = Name FROM ListARRAReports WHERE ARRAReportsUid = '6C7F5868-F84E-45B9-AED1-18F707EC0FF1'

--SELECT '0034' as [NQF], '1' as [Population Criteria], '1' as [Numerator],
--	@TotalPatients as [Total Patients], @Exclusions as [Exclusions], @QualifiedCount as [Qualified Count], 
--	@percent as [Percent],
--	@Description as [Description]

INSERT INTO #Results
	(
		NQF,
		PopulationCriteria,
		Numerator,
		TotalPatients,
		Exclusions,
		QualifiedCount,
		[Percent],
		[Description]
	) 
VALUES 
	(
		'0034',
		'1',
		'1',
		@TotalPatients,
		@Exclusions,
		@QualifiedCount,
		@percent,
		@Description
	)

END




GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_0038_ChildhoodImmunizationStatus]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ARRA_0038_ChildhoodImmunizationStatus] AS' 
END
GO
ALTER PROCEDURE [dbo].[ARRA_0038_ChildhoodImmunizationStatus](@StartDate DATE, @EndDate DATE)
AS
BEGIN

-- Strike out visit are filter out by store procedure ARRA_LoadPatientList

---- temp code
--declare @StartDate DATE
--declare @EndDate DATE

--set @StartDate = '1/1/2010'
--set @EndDate = '12/31/2010'

--delete Results

---- end of temp code

DECLARE @TotalPatients int
DECLARE @QualifiedCount int
DECLARE @Exclusions int
DECLARE @percent float

DECLARE @PatientUid uniqueidentifier
DECLARE @AdminDate DATETIME
DECLARE @lastPatientUid uniqueidentifier
DECLARE @lastAdminDate DATETIME

DECLARE @1YearsAgo DATE
DECLARE @2YearsAgo DATE
DECLARE @42DaysAgo DATE
DECLARE @180DaysAgo DATE

SET @TotalPatients = 0
SET @QualifiedCount = 0
SET @Exclusions = 0
SET @percent = 0


SET @180DaysAgo = DATEADD(day, -180, @EndDate)
SET @42DaysAgo = DATEADD(day, -42, @EndDate)
SET @1YearsAgo = DATEADD(year, -1, @EndDate)
SET @2YearsAgo = DATEADD(year, -2, @EndDate)

DECLARE @TypeofVaccineElement TABLE 
(
	TypeofVaccineElementUid UNIQUEIDENTIFIER NOT NULL
)

declare @Diagnosis table
(
	ICD9Code varchar(255)
)

DECLARE @PatientPopulation TABLE
(
	PatientUid uniqueidentifier null,
	VisitUid uniqueidentifier null,
	VisitDate DATETIME,
	BirthDate DATETIME,
	HasAnAllergy bit default (0),
	HasDiagnosis bit default (0),
	EncounterCount int default (0),
	Processed bit default (0)
)

INSERT INTO @PatientPopulation
SELECT DISTINCT pl.PatientUid, pl.VisitUid, pl.VisitDate, pl.BirthDate, 0, 0, 0, 0
FROM #PatientList pl
WHERE BirthDate <= @1YearsAgo 
AND BirthDate > @2YearsAgo
AND ((pl.DeathDate is null) or (pl.DeathDate > @EndDate))

SELECT @TotalPatients = COUNT(*)
FROM @PatientPopulation

-- populate table DTaPVaccineResults ***********************************************************
DECLARE @DTaPVaccineResults TABLE
(
	PatientUid uniqueidentifier null
)

-- zero encounter count
UPDATE @PatientPopulation SET EncounterCount = 0, HasAnAllergy = 0, HasDiagnosis = 0, Processed = 0

-- set type of vaccine element
DELETE @TypeofVaccineElement
INSERT INTO @TypeofVaccineElement (TypeofVaccineElementUid) VALUES ('6CBEAD22-68C5-4BA7-87BE-E81241060F86') -- DTaP

-- set diagnosis
DELETE @Diagnosis
INSERT INTO @Diagnosis
SELECT MD.DiagnosisCode9 FROM MasterDiagnosis md where LongDescription like '%encephalopathy%'

DELETE @Diagnosis
INSERT INTO @Diagnosis
SELECT MD.DiagnosisCode9 FROM MasterDiagnosis md where LongDescription like '%neurological disorder%'

-- look in VisitDiagnosis
UPDATE @PatientPopulation SET HasDiagnosis = 1
WHERE PatientUid IN
	(
		SELECT DISTINCT pp.PatientUid 
		FROM @PatientPopulation pp 
		INNER JOIN VisitDiagnosis vd ON vd.VisitUid = pp.VisitUid AND vd.IsDelete = 0
		INNER JOIN @Diagnosis diag ON vd.Code = diag.ICD9Code
	)

-- look in PatientProblemDiagnosisHistory
UPDATE @PatientPopulation SET HasDiagnosis = 1
WHERE PatientUid IN
	(
		SELECT DISTINCT pp.PatientUid 
		FROM @PatientPopulation pp 
		INNER JOIN PatientProblemDiagnosisHistory pdx ON pp.PatientUid = pdx.PatientUid 
			AND (pdx.IsDelete = 0)
			AND pdx.IsPatientProblem = 0
		INNER JOIN @Diagnosis diag ON pdx.Code9 = diag.ICD9Code
		INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid AND lps.ActiveStatus = 1 
		WHERE (pp.HasDiagnosis = 0) AND
			(pdx.ActiveDate <= pp.VisitDate) AND 
			((pdx.InactiveDate IS NULL) OR (pdx.InactiveDate > pp.VisitDate))
	)

-- set last vars to some that will not be in data set
SET @lastAdminDate = '1/1/1753' 
SET @lastPatientUid = '00000000-0000-0000-0000-000000000000'

DECLARE _cursor CURSOR FOR SELECT pat.PatientUid, ih.AdministeredDateTime
			FROM @PatientPopulation pat
			INNER JOIN ImmunizationHistory ih ON pat.PatientUid = ih.PatientUid AND ih.IsDelete = 0
			--INNER JOIN ListVaccine lv on ih.VaccineUid = lv.VaccineUid
			--INNER JOIN RelTypeofVaccineTypeofVaccineElement reltype on lv.VaccineUid = reltype.VaccineUid
			INNER JOIN RelTypeofVaccineTypeofVaccineElement reltype on ih.TypeofVaccineUid = reltype.TypeofVaccineUid
			INNER JOIN ListTypeofVaccineElement ltve on reltype.TypeofVaccineElementUid = ltve.TypeofVaccineElementUid
				AND ltve.TypeofVaccineElementUid IN (SELECT TypeofVaccineElementUid FROM @TypeofVaccineElement)
			WHERE pat.BirthDate <= @42DaysAgo AND pat.HasAnAllergy = 0 AND pat.HasDiagnosis = 0
			ORDER BY pat.PatientUid, ih.AdministeredDateTime
		
OPEN _cursor
FETCH NEXT FROM _cursor INTO @PatientUid, @AdminDate

WHILE (@@fetch_status <> -1)
BEGIN
	 IF (@@fetch_status <> -2)
	 BEGIN
		IF ((@lastPatientUid = @PatientUid) AND (@lastAdminDate <> @AdminDate))
		BEGIN
			UPDATE @PatientPopulation SET EncounterCount = EncounterCount + 1
			WHERE PatientUid = @PatientUid	

			SET @lastAdminDate = @AdminDate
			SET @lastPatientUid = @PatientUid
			
		END
		ELSE BEGIN
			IF (@lastPatientUid <> @PatientUid)
			BEGIN
				UPDATE @PatientPopulation SET EncounterCount = EncounterCount + 1
				WHERE PatientUid = @PatientUid
			END
			SET @lastAdminDate = @AdminDate
			SET @lastPatientUid = @PatientUid
		END
	 END
	 
	FETCH NEXT FROM _cursor INTO @PatientUid, @AdminDate
END 
CLOSE _cursor
DEALLOCATE _cursor

INSERT INTO @DTaPVaccineResults (PatientUid)
SELECT PatientUid
FROM @PatientPopulation
WHERE EncounterCount > 3
-- end populate table DTaPVaccineResults ***********************************************************

-- populate table IPVVaccineResults ***********************************************************
DECLARE @IPVVaccineResults TABLE
(
	PatientUid uniqueidentifier null
)
---- set type of vaccine element
DELETE @TypeofVaccineElement
INSERT INTO @TypeofVaccineElement (TypeofVaccineElementUid) VALUES ('1DEBDB54-3A75-4147-A3BB-4DA9A5B7950A') -- IPV
-- zero encounter count
UPDATE @PatientPopulation SET EncounterCount = 0, HasAnAllergy = 0, HasDiagnosis = 0, Processed = 0

-- test allergies
UPDATE @PatientPopulation SET HasAnAllergy = 1
WHERE PatientUid IN
	(
		SELECT pat.PatientUid 
		FROM @PatientPopulation pat
		INNER JOIN PatientHistory ph ON pat.PatientUid = ph.PatientUid
		INNER JOIN PatientHistoryDetail phd ON ph.PatientHistoryUid = phd.PatientHistoryUid
			AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000109' -- Drug Allergy
			AND ((phd.QuestionName IN ('neomycin', 'streptomycin')) OR (phd.QuestionName like 'polymyxin%'))
			AND (ph.ActiveDate <= pat.VisitDate)
			AND ((ph.InactiveDate is null) OR (ph.InactiveDate > pat.VisitDate))
		WHERE pat.BirthDate <= @42DaysAgo	
	)

-- set last vars to some that will not be in data set
SET @lastAdminDate = '1/1/1753' 
SET @lastPatientUid = '00000000-0000-0000-0000-000000000000'

DECLARE _cursor CURSOR FOR SELECT pat.PatientUid, ih.AdministeredDateTime
			FROM @PatientPopulation pat
			INNER JOIN ImmunizationHistory ih ON pat.PatientUid = ih.PatientUid AND ih.IsDelete = 0
			--INNER JOIN ListVaccine lv on ih.VaccineUid = lv.VaccineUid
			--INNER JOIN RelTypeofVaccineTypeofVaccineElement reltype on lv.VaccineUid = reltype.VaccineUid
			INNER JOIN RelTypeofVaccineTypeofVaccineElement reltype on ih.TypeofVaccineUid = reltype.TypeofVaccineUid
			INNER JOIN ListTypeofVaccineElement ltve on reltype.TypeofVaccineElementUid = ltve.TypeofVaccineElementUid
				AND ltve.TypeofVaccineElementUid IN (SELECT TypeofVaccineElementUid FROM @TypeofVaccineElement)
			WHERE pat.BirthDate <= @42DaysAgo AND pat.HasAnAllergy = 0 AND pat.HasDiagnosis = 0
			ORDER BY pat.PatientUid, ih.AdministeredDateTime
		
OPEN _cursor
FETCH NEXT FROM _cursor INTO @PatientUid, @AdminDate

WHILE (@@fetch_status <> -1)
BEGIN
	 IF (@@fetch_status <> -2)
	 BEGIN
		IF ((@lastPatientUid = @PatientUid) AND (@lastAdminDate <> @AdminDate))
		BEGIN
			UPDATE @PatientPopulation SET EncounterCount = EncounterCount + 1
			WHERE PatientUid = @PatientUid	

			SET @lastAdminDate = @AdminDate
			SET @lastPatientUid = @PatientUid
			
		END
		ELSE BEGIN
			IF (@lastPatientUid <> @PatientUid)
			BEGIN
				UPDATE @PatientPopulation SET EncounterCount = EncounterCount + 1
				WHERE PatientUid = @PatientUid
			END
			SET @lastAdminDate = @AdminDate
			SET @lastPatientUid = @PatientUid
		END
	 END
	 
	FETCH NEXT FROM _cursor INTO @PatientUid, @AdminDate
END 
CLOSE _cursor
DEALLOCATE _cursor

INSERT INTO @IPVVaccineResults (PatientUid)
SELECT PatientUid
FROM @PatientPopulation
WHERE EncounterCount > 2
-- end populate table IPVVaccineResults ***********************************************************

-- populate table MMRVaccineResults ***********************************************************

-- zero encounter count
UPDATE @PatientPopulation SET EncounterCount = 0, HasAnAllergy = 0, HasDiagnosis = 0, Processed = 0

DECLARE @MMRVaccineResults TABLE
(
	PatientUid uniqueidentifier null
)

-- test for MMR 
-- set type of vaccine element
DELETE @TypeofVaccineElement
INSERT INTO @TypeofVaccineElement (TypeofVaccineElementUid) VALUES ('36DA73A1-3EC2-4D09-8C8D-DFD1947185A4') -- MMR

-- filter out active or inactive diagnosis for Malignant Neoplasms of Lymphoid and Histiocytic Tissue
DELETE @Diagnosis
INSERT INTO @Diagnosis
SELECT MD.DiagnosisCode9 FROM MasterDiagnosis md WHERE md.DiagnosisCode9 like '202.9%'

-- look in VisitDiagnosis
UPDATE @PatientPopulation SET Processed = 1
WHERE PatientUid IN
	(
		SELECT DISTINCT pp.PatientUid 
		FROM @PatientPopulation pp 
		INNER JOIN VisitDiagnosis vd ON vd.VisitUid = pp.VisitUid AND vd.IsDelete = 0
		INNER JOIN @Diagnosis diag ON vd.Code = diag.ICD9Code
	)

-- look in PatientProblemDiagnosisHistory
UPDATE @PatientPopulation SET Processed = 1
WHERE PatientUid IN
	(
		SELECT DISTINCT pp.PatientUid 
		FROM @PatientPopulation pp 
		INNER JOIN PatientProblemDiagnosisHistory pdx ON pp.PatientUid = pdx.PatientUid 
				AND (pdx.IsDelete = 0)
				AND pdx.IsPatientProblem = 0
		INNER JOIN @Diagnosis diag ON pdx.Code9 = diag.ICD9Code
	)

-- additional filter out diagnosis and allergies
DELETE @Diagnosis
INSERT INTO @Diagnosis (ICD9Code) VALUES ('V08') -- asymptomatic HIV
INSERT INTO @Diagnosis
SELECT MD.DiagnosisCode9 FROM MasterDiagnosis md WHERE md.DiagnosisCode9 like '203%'
INSERT INTO @Diagnosis
SELECT MD.DiagnosisCode9 FROM MasterDiagnosis md WHERE md.LongDescription like '%leukemia%' and substring (md.DiagnosisCode9, 1, 2) = '20'

-- look in VisitDiagnosis
UPDATE @PatientPopulation SET Processed = 1
WHERE PatientUid IN
	(
		SELECT DISTINCT pp.PatientUid 
		FROM @PatientPopulation pp 
		INNER JOIN VisitDiagnosis vd ON vd.VisitUid = pp.VisitUid AND vd.IsDelete = 0
		INNER JOIN @Diagnosis diag ON vd.Code = diag.ICD9Code
	)

-- look in PatientProblemDiagnosisHistory
UPDATE @PatientPopulation SET Processed = 1
WHERE PatientUid IN
	(
		SELECT DISTINCT pp.PatientUid 
		FROM @PatientPopulation pp 
		INNER JOIN PatientProblemDiagnosisHistory pdx ON pp.PatientUid = pdx.PatientUid 
				AND (pdx.IsDelete = 0)
				AND pdx.IsPatientProblem = 0
		INNER JOIN @Diagnosis diag ON pdx.Code9 = diag.ICD9Code
		INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid AND lps.ActiveStatus = 1 
		WHERE (pp.HasDiagnosis = 0) AND
			(pdx.ActiveDate <= pp.VisitDate) AND 
			((pdx.InactiveDate IS NULL) OR (pdx.InactiveDate > pp.VisitDate))
	)

-- filter out allergies
UPDATE @PatientPopulation SET Processed = 1
WHERE PatientUid IN
	(
		SELECT pat.PatientUid 
		FROM @PatientPopulation pat
		INNER JOIN PatientHistory ph ON pat.PatientUid = ph.PatientUid
		INNER JOIN PatientHistoryDetail phd1 ON ph.PatientHistoryUid = phd1.PatientHistoryUid
			AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000109' -- Drug Allergy
			AND (phd1.QuestionName = 'MUMPS')
			AND (ph.ActiveDate <= pat.VisitDate)
			AND ((ph.InactiveDate is null) OR (ph.InactiveDate > pat.VisitDate))
		INNER JOIN PatientHistoryDetail phd2 ON ph.PatientHistoryUid = phd2.PatientHistoryUid
			AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000109' -- Drug Allergy
			AND (phd1.QuestionName = 'MEASLES (RUBEOLA)')
			AND (ph.ActiveDate <= pat.VisitDate)
			AND (ph.InactiveDate is null OR ph.InactiveDate > pat.VisitDate)
		INNER JOIN PatientHistoryDetail phd3 ON ph.PatientHistoryUid = phd3.PatientHistoryUid
			AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000109' -- Drug Allergy
			AND (phd1.QuestionName = 'RUBELLA (GERMAN MEASLES)')
			AND (ph.ActiveDate <= pat.VisitDate)
			AND ((ph.InactiveDate is null) OR (ph.InactiveDate > pat.VisitDate))
		WHERE pat.BirthDate <= @42DaysAgo	
	)

-- end of filter out

-- set diagnosis
DELETE @Diagnosis
INSERT INTO @Diagnosis
SELECT MD.DiagnosisCode9 FROM MasterDiagnosis md WHERE md.LongDescription like '%MUMPS%' and substring (md.DiagnosisCode9, 1, 3) = '072'

INSERT INTO @Diagnosis
SELECT MD.DiagnosisCode9 FROM MasterDiagnosis md WHERE md.LongDescription like '%MEASLES%' and substring (md.DiagnosisCode9, 1, 3) = '055'

INSERT INTO @Diagnosis
SELECT MD.DiagnosisCode9 FROM MasterDiagnosis md WHERE md.LongDescription like '%RUBELLA%' and substring (md.DiagnosisCode9, 1, 3) = '056'

-- test allergies
UPDATE @PatientPopulation SET HasAnAllergy = 1
WHERE PatientUid IN
	(
		SELECT pp.PatientUid 
		FROM @PatientPopulation pp
		INNER JOIN PatientHistory ph ON pp.PatientUid = ph.PatientUid
		INNER JOIN PatientHistoryDetail phd ON ph.PatientHistoryUid = phd.PatientHistoryUid
			AND ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000109' -- Drug Allergy
			AND (phd.QuestionName