-- clean up for new FK
delete from [RelHospitalRoundProvider] where HospitalRoundUid NOT IN (select HospitalRoundUid from [HospitalRound]) 
GO
UPDATE [ImmunizationHistory] SET [VaccinatorUid] = NULL
FROM [ImmunizationHistory] T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN [UserPRM] T2 ON T1.[VaccinatorUid] = T2.[PersonUid]
	WHERE T1.[VaccinatorUid] IS NOT NULL AND T2.[PersonUid] IS NULL;
GO
UPDATE [ObservationValue] SET [EnteredByUid] = NULL
FROM [ObservationValue] T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN [UserPRM] T2 ON T1.[EnteredByUid] = T2.[PersonUid]
	WHERE T1.[EnteredByUid] IS NOT NULL AND T2.[PersonUid] IS NULL;
GO

-- Pre Migration for bug #55140  -- there is no POST script for this
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	SET NOCOUNT ON

	if (EXISTS (select * from sys.columns WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND [Name] = 'RaceUid'))
	begin
		declare @sql nvarchar(4000) =
N'declare @tempRelRace table
	(
		RaceUid uniqueidentifier
		,PersonUid  uniqueidentifier
	)

-- populate @tempRelRace
insert into @tempRelRace (RaceUid, PersonUid) 
	select RaceUid, PersonUid from Person where RaceUid is not null

declare @RaceUid uniqueidentifier
declare @PersonUid  uniqueidentifier
declare @cnt int = 0
declare @cnt2 int = 0

select @cnt2 = Count(*) from @tempRelRace

while @cnt2 > 0
begin
	select top 1 @RaceUid = RaceUid, @PersonUid = PersonUid from @tempRelRace
	
	select @cnt = Count(*) from RelPersonRace where RaceUid = @RaceUid and PersonUid = @PersonUid
	if (@cnt = 0)
	begin
		insert into RelPersonRace (PersonUid, RaceUid, LastModifiedDate)
		values
			(@PersonUid, @RaceUid, GetDate())
	end

	-- get next row
	delete from @tempRelRace where RaceUid = @RaceUid and PersonUid = @PersonUid

	select @cnt2 = Count(*) from @tempRelRace
end -- end of while @cnt2 > 0'
		
		exec (@sql)
	end
END
GO

-- Pre Migration for bug #55371
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	SET NOCOUNT ON

	if (EXISTS (select * from sys.columns WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND [Name] = 'EthnicityUid'))
	begin

		IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_MigrateEthnicity]') AND type in (N'U'))
			DROP TABLE [dbo].[cus_MigrateEthnicity]

		create table cus_MigrateEthnicity
		(
			EthnicityUid uniqueidentifier,
			PersonUid  uniqueidentifier
		)

		declare @sql nvarchar(4000) =
N'insert into cus_MigrateEthnicity (EthnicityUid, PersonUid)
			select EthnicityUid, PersonUid from Person where EthnicityUid is not null'
		exec (@sql)
	end
END
GO

-- 57720  Remove cus_VisitDiagnosis20170531.sql
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_VisitDiagnosis20170531]') AND type in (N'U'))
begin
	drop table cus_VisitDiagnosis20170531
end
GO

-- Pre migration for #57682
IF (dbo.Replication_IsReplicatedDB() = 0)
	AND (EXISTS (SELECT c.name AS column_name 
					FROM sys.tables AS t INNER JOIN sys.columns c ON t.OBJECT_ID = c.OBJECT_ID 
					WHERE t.name = 'RelAttachmentGroup' and c.name = 'PatientProcedureUid'))
BEGIN

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_PatientProcedureHistory]') AND type in (N'U'))
	BEGIN
		exec sp_executesql N'SELECT * INTO cus_PatientProcedureHistory FROM PatientProcedureHistory'
	END
	
	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_PatientProcedure]') AND type in (N'U'))
	BEGIN
		exec sp_executesql N'SELECT * INTO cus_PatientProcedure FROM PatientProcedure'
	END

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_RelAttachmentGroup]') AND type in (N'U'))
	BEGIN
		exec sp_executesql N'SELECT * INTO cus_RelAttachmentGroup FROM RelAttachmentGroup'
	END
	
	declare @sql nvarchar(4000)
	set @sql = 'update RelAttachmentGroup set PatientProcedureUid = null'
	exec sp_executesql @sql

END
GO

-- Pre migration for #57684
IF (dbo.Replication_IsReplicatedDB() = 0)
	AND (EXISTS (SELECT name FROM sys.tables WHERE name = 'PatientProblemDiagnosis' ))
BEGIN

	-- IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_57684PatientProblemDiagnosisHistory]') AND type in (N'U'))
	-- BEGIN
		-- exec sp_executesql N'SELECT * INTO cus_57684PatientProblemDiagnosisHistory FROM PatientProblemDiagnosisHistory'
	-- END
	
	-- IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_57684PatientProblemDiagnosis]') AND type in (N'U'))
	-- BEGIN
		-- exec sp_executesql N'SELECT * INTO cus_57684PatientProblemDiagnosis FROM PatientProblemDiagnosis'
	-- END
	
	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_57684VisitDiagnosis]') AND type in (N'U'))
	BEGIN
		exec sp_executesql N'SELECT * INTO cus_57684VisitDiagnosis FROM VisitDiagnosis'
	END
END
GO

-- #1894 CMR - Make sure PatientInstructions has a value  1894-PreMigrationScript-ListMedicationFrequency.sql
UPDATE ListMedicationFrequency
SET PatientInstructions = CASE
                             WHEN Name = 'PRN Q6hR' THEN 'every six hours as needed'
                             ELSE COALESCE(PrescriptionText, Name)
                          END
FROM ListMedicationFrequency
WHERE PatientInstructions IS NULL
GO

-- #1894 CMR - Make sure PatientInstructions has a value	1894-PreMigrationScript-ListMedicationRoute.sql
UPDATE ListMedicationRoute
SET PatientInstructions = COALESCE(PrescriptionText, Name)
FROM ListMedicationRoute
WHERE PatientInstructions IS NULL
GO

