-- moved here from the 2016 migration path
/*	Scenario 39252 
   Migration Script for Scenario 39252 - Ability to set custom paper claim layout on payer
	Adds a ListClaimFormatValueType for each ListClaimFormLayout
	Intended to be executed as Post Migration script ( can be either )
	Can be executed multiple times ( reentrant ) without causing problems

*/
INSERT INTO ListClaimFormatValueType( ClaimFormatValueTypeUid, ExternalID, Name, Notes, IsPerProviderValue, IsPerFinancialCenterValue, Inactive, LastModifiedDate, LastModifiedByUid, ClaimFormatValueTypeTypeUid, UserDefined)
	SELECT cfl.ClaimFormLayoutUid as ClaimFormatValueTypeUid, -- ClaimFormatValueTypeUid
			cfl.ExternalID, -- ExternalID
			cfl.Name, -- Name
			cfl.Notes, -- Notes
			0, -- IsPerProviderValue
			0, -- IsPerFinancialCenterValue
			0, -- Inactive
			cfl.LastModifiedDate, -- LastModifiedDate
			cfl.LastModifiedByUid, -- LastModifiedByUid
			cft.ClaimFormatTypeUid, -- -- ListClaimFormatTypeUid for paper claims purposely set to ListClaimFormatValueType.ClaimFormatValueTypeTypeUid
			0 -- UserDefined
	FROM ListClaimFormLayout cfl
		INNER JOIN ListClaimFormatType cft on cfl.ClaimFormatTypeUid = cft.ClaimFormatTypeUid
													AND cft.IsPaper = 1
		LEFT OUTER JOIN ListClaimFormatValueType cfvt on cfl.ClaimFormLayoutUid = cfvt.ClaimFormatValueTypeUid
	WHERE cfvt.ClaimFormatValueTypeUid IS NULL
GO

-- Post Migration for bug #55371
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	SET NOCOUNT ON

	if (EXISTS (select * from sys.columns WHERE object_id = OBJECT_ID(N'[dbo].[cus_MigrateEthnicity]') AND [Name] = 'EthnicityUid'))
	begin
		declare @sql nvarchar(4000) =
			N'insert into RelPersonEthnicity (EthnicityUid, PersonUid)
			select EthnicityUid, PersonUid from cus_MigrateEthnicity'
		exec (@sql)
		
		IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_MigrateEthnicity]') AND type in (N'U'))
			DROP TABLE [dbo].[cus_MigrateEthnicity]

	end
END
GO

--	#57682
IF (dbo.Replication_IsReplicatedDB() = 0)
	AND (EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_PatientProcedureHistory]') AND type in (N'U')))
	AND (EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_PatientProcedure]') AND type in (N'U')))
	AND	(EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_RelAttachmentGroup]') AND type in (N'U')))
	AND (EXISTS (SELECT c.name AS column_name 
					FROM sys.tables AS t INNER JOIN sys.columns c ON t.OBJECT_ID = c.OBJECT_ID 
					WHERE t.name = 'cus_PatientProcedureHistory' and c.name = 'OrderedVisitProcedureUid'))
BEGIN
	declare @sql nvarchar(4000)
	-- fix null Sequence
	UPDATE PatientProcedureHistory SET Sequence = LastModifiedDate

	-- migrate observation orders
	set @sql = 'INSERT INTO RelOrderedProcedurePatientProcedureHistory (PatientProcedureHistoryUid, VisitProcedureUid, LastModifiedDate) ' +
				'SELECT PatientProcedureHistoryUid, OrderedVisitProcedureUid, LastModifiedDate ' +
				'FROM cus_PatientProcedureHistory cus ' +
				'WHERE OrderedVisitProcedureUid is not null ' +
				'AND NOT exists(select * from RelOrderedProcedurePatientProcedureHistory ' +
				'where VisitProcedureUid = cus.OrderedVisitProcedureUid)'
	exec sp_executesql @sql


	-- migrate observation performs
	set @sql = 'INSERT INTO RelPerformProcedurePatientProcedureHistory (PatientProcedureHistoryUid, VisitProcedureUid, LastModifiedDate) ' +
				'SELECT PatientProcedureHistoryUid, PerformVisitProcedureUid, LastModifiedDate ' +
				'FROM cus_PatientProcedureHistory cus WHERE PerformVisitProcedureUid is not null ' +
				'AND NOT exists(select * from RelPerformProcedurePatientProcedureHistory ' +
				'where VisitProcedureUid = cus.PerformVisitProcedureUid)'
	exec sp_executesql @sql

	-- migrate attachments
	set @sql = 'WITH cet (PatientProcedureHistoryUid, RelAttachmentGroupUid) ' +
				'AS ( ' +
				'SELECT cpph.PatientProcedureHistoryUid, crag.RelAttachmentGroupUid ' +
				'FROM cus_RelAttachmentGroup crag ' +
				'inner join cus_PatientProcedure cpp on cpp.PatientProcedureUid = crag.PatientProcedureUid '+
				'inner join cus_PatientProcedureHistory cpph on cpph.PatientProcedureUid = cpp.PatientProcedureUid ' +
				'WHERE crag.PatientProcedureUid is not null ' +
				'AND crag.RelAttachmentGroupUid = RelAttachmentGroupUid ' +
				') UPDATE rag SET PatientProcedureHistoryUid = c.PatientProcedureHistoryUid ' +
				'FROM RelAttachmentGroup rag ' +
				'inner join cet c on rag.RelAttachmentGroupUid = c.RelAttachmentGroupUid '
	exec sp_executesql @sql

	-- set IsCurrentHistoryRow and GroupingUid
	declare @PatientProcedureHistoryUid uniqueidentifier
	declare @PatientUid uniqueidentifier
	declare @HistoryGroupUid uniqueidentifier
	declare @ProcedureHistoryTermUid uniqueidentifier
	declare @ProcedureUid uniqueidentifier
	declare @GroupingUid uniqueidentifier
	declare @LastPatientUid uniqueidentifier
	declare @LastHistoryGroupUid uniqueidentifier
	declare @LastProcedureHistoryTermUid uniqueidentifier
	declare @LastProcedureUid uniqueidentifier

	declare @LastPatientProcedureHistoryUid uniqueidentifier
	declare @cnt int

	DECLARE a_cursor CURSOR FAST_FORWARD FOR 
				select PatientProcedureHistoryUid, PatientUid, HistoryGroupUid, ProcedureHistoryTermUid, ProcedureUid
				from PatientProcedureHistory 
				order by PatientUid, HistoryGroupUid, ProcedureHistoryTermUid, ProcedureUid, [Sequence]
				
	OPEN a_cursor
	FETCH NEXT FROM a_cursor INTO @PatientProcedureHistoryUid, @PatientUid, @HistoryGroupUid, @ProcedureHistoryTermUid, @ProcedureUid

	set @LastPatientUid = @PatientUid
	set @LastHistoryGroupUid = @HistoryGroupUid
	set @LastProcedureHistoryTermUid = @ProcedureHistoryTermUid
	set @LastProcedureUid = @ProcedureUid

	WHILE (@@fetch_status <> -1)
	BEGIN
		IF (@@fetch_status <> -2)
		BEGIN
			if (
				(@LastPatientUid <> @PatientUid) OR
				(@LastHistoryGroupUid <> @HistoryGroupUid) OR
				((@LastProcedureHistoryTermUid is not null) and (@LastProcedureHistoryTermUid <> @ProcedureHistoryTermUid)) OR
				((@LastProcedureHistoryTermUid is null) and (isnull(@LastProcedureUid, '00000000-0000-0000-0000-000000000000') <> isnull(@ProcedureUid, '00000000-0000-0000-0000-000000000000')))
				 )
			begin
				if (@LastPatientProcedureHistoryUid is not null)
				begin
					update PatientProcedureHistory SET IsCurrentHistoryRow = 1, GroupingUid = @GroupingUid where PatientProcedureHistoryUid = @LastPatientProcedureHistoryUid
				end
				set @cnt= 1
				set @LastPatientUid = @PatientUid
				set @LastHistoryGroupUid = @HistoryGroupUid
				set @LastProcedureHistoryTermUid = @ProcedureHistoryTermUid
				set @LastProcedureUid = @ProcedureUid
				set @GroupingUid = @PatientProcedureHistoryUid

				update PatientProcedureHistory SET IsCurrentHistoryRow = 0, GroupingUid = @GroupingUid where PatientProcedureHistoryUid = @PatientProcedureHistoryUid
			end
			else begin
				update PatientProcedureHistory SET IsCurrentHistoryRow = 0, GroupingUid = @GroupingUid where PatientProcedureHistoryUid = @PatientProcedureHistoryUid
			end
		
			set @LastPatientProcedureHistoryUid = @PatientProcedureHistoryUid
			set @cnt = @cnt + 1

		END -- of IF (@@fetch_status <> -2)
		
		FETCH NEXT FROM a_cursor INTO @PatientProcedureHistoryUid, @PatientUid, @HistoryGroupUid, @ProcedureHistoryTermUid, @ProcedureUid

	END -- of while...
	if (@LastPatientProcedureHistoryUid is not null)
	begin
		update PatientProcedureHistory SET IsCurrentHistoryRow = 1 where PatientProcedureHistoryUid = @LastPatientProcedureHistoryUid
	end
	CLOSE a_cursor
	DEALLOCATE a_cursor

END
GO

-- #58474-RelPatientMedication-ActiveDate.sql
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
   IF NOT EXISTS(SELECT * FROM ListDiscontinueReason WHERE DiscontinueReasonUid = 'CE0BDF49-A79C-4C46-B434-4D612918B422')
   BEGIN
      INSERT INTO ListDiscontinueReason(DiscontinueReasonUid, ExternalID, Name, UserDefined, LastModifiedDate)
      VALUES('CE0BDF49-A79C-4C46-B434-4D612918B422', 'Obsolete', 'Obsolete History', 0, '2017-09-08 17:11:27.043')
   END

   -- set the stop date on MedicationSIG so that these will not show currently active
   UPDATE sig
   SET
      DiscontinueReasonUid = 'CE0BDF49-A79C-4C46-B434-4D612918B422',
      OverallStopDate      = COALESCE(sig.OverallStopDate, CASE WHEN det.MaxStopDate < '01/01/2018' THEN det.MaxStopDate ELSE NULL END, vis.VisitDate, sig.LastModifiedDate),
      LastModifiedDate     = DATEADD(MI, 10, sig.LastModifiedDate)
   FROM RelPatientMedication rpm
   INNER JOIN MedicationSIG sig ON sig.MedicationSIGUid = rpm.MedicationSIGUid
   LEFT JOIN RelVisitMedication rvm ON rvm.RelVisitMedicationUid = rpm.RelVisitMedicationUid
   LEFT JOIN Visit vis ON vis.VisitUid = ISNULL(sig.VisitUid, rvm.VisitUid)
   OUTER APPLY (
      SELECT
        MedicationSIGUid = det.MedicationSIGUid,
        MinStartDate     = MIN(ISNULL(det.ItemStartDate, '01/01/1900')),
        MaxStopDate      = MAX(ISNULL(det.ItemStopDate, '01/01/9999')),
        MinDisplayOrder  = MIN(det.DisplayOrder)
      FROM SIGDetail det
      WHERE det.MedicationSIGUid = rpm.MedicationSIGUid
      GROUP BY det.MedicationSIGUid) det
   WHERE rpm.ActiveDate IS NULL

   -- set the ActiveDate on RelPatientMedication so that these will show up in the Hx tab (they already show in formatting model / Rx Slider)
   UPDATE rpm
   SET
      ActiveDate       = COALESCE(vis.VisitDate, sig.OverallStartDate, CASE WHEN det.MinStartDate > '01/01/2000' THEN det.MinStartDate ELSE NULL END, sig.LastModifiedDate),
      LastModifiedDate = DATEADD(MI, 10, rpm.LastModifiedDate)
   FROM RelPatientMedication rpm
   INNER JOIN MedicationSIG sig ON sig.MedicationSIGUid = rpm.MedicationSIGUid
   LEFT JOIN RelVisitMedication rvm ON rvm.RelVisitMedicationUid = rpm.RelVisitMedicationUid
   LEFT JOIN Visit vis ON vis.VisitUid = ISNULL(sig.VisitUid, rvm.VisitUid)
   OUTER APPLY (
      SELECT
        MedicationSIGUid = det.MedicationSIGUid,
        MinStartDate     = MIN(ISNULL(det.ItemStartDate, '01/01/1900')),
        MaxStopDate      = MAX(ISNULL(det.ItemStopDate, '01/01/9999')),
        MinDisplayOrder  = MIN(det.DisplayOrder)
      FROM SIGDetail det
      WHERE det.MedicationSIGUid = rpm.MedicationSIGUid
      GROUP BY det.MedicationSIGUid) det
   WHERE rpm.ActiveDate IS NULL
END
GO

-- #59259-ListUIControl-SIGWriter.sql
DELETE ListUIControl
WHERE Name LIKE 'SIGWriter%'
  AND UIControlUid IN('2E227430-4A95-4229-B013-99C6F17C9D73',
                      'CC909E26-2269-4A46-99BA-48EA6207443F',
                      'CE90C702-E844-4D5A-8098-B1D0C1554DA6',
                      '697E434E-60C2-4F0A-A439-3DA12ED8B9F7',
                      'CCCBEE5E-9F4A-48A6-A988-AC7E42FFA8B7',
                      'A5990239-7D4B-4210-8610-917C94951BEE',
                      'DA22F01B-BF7F-4CC2-A3C3-DDD68F15B6C7',
                      'B26CB576-B381-4223-80F3-56A5D7866CFD',
                      '6A9341E3-14CD-4683-9C64-27F4945E379E')
GO

-- post migration for #57682
IF (dbo.Replication_IsReplicatedDB() = 0)
	AND (EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_PatientProcedureHistory]') AND type in (N'U')))
	AND (EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_PatientProcedure]') AND type in (N'U')))
	AND	(EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_RelAttachmentGroup]') AND type in (N'U')))
	AND (EXISTS (SELECT c.name AS column_name 
					FROM sys.tables AS t INNER JOIN sys.columns c ON t.OBJECT_ID = c.OBJECT_ID 
					WHERE t.name = 'cus_PatientProcedureHistory' and c.name = 'OrderedVisitProcedureUid'))
BEGIN
	declare @sql nvarchar(4000)
	-- fix null Sequence
	UPDATE PatientProcedureHistory SET Sequence = LastModifiedDate

	-- migrate observation orders
	set @sql = 'INSERT INTO RelOrderedProcedurePatientProcedureHistory (PatientProcedureHistoryUid, VisitProcedureUid, LastModifiedDate) ' +
				'SELECT PatientProcedureHistoryUid, OrderedVisitProcedureUid, LastModifiedDate ' +
				'FROM cus_PatientProcedureHistory cus ' +
				'WHERE OrderedVisitProcedureUid is not null ' +
				'AND NOT exists(select * from RelOrderedProcedurePatientProcedureHistory ' +
				'where VisitProcedureUid = cus.OrderedVisitProcedureUid)'
	exec sp_executesql @sql


	-- migrate observation performs
	set @sql = 'INSERT INTO RelPerformProcedurePatientProcedureHistory (PatientProcedureHistoryUid, VisitProcedureUid, LastModifiedDate) ' +
				'SELECT PatientProcedureHistoryUid, PerformVisitProcedureUid, LastModifiedDate ' +
				'FROM cus_PatientProcedureHistory cus WHERE PerformVisitProcedureUid is not null ' +
				'AND NOT exists(select * from RelPerformProcedurePatientProcedureHistory ' +
				'where VisitProcedureUid = cus.PerformVisitProcedureUid)'
	exec sp_executesql @sql

	-- migrate attachments
	set @sql = 'WITH cet (PatientProcedureHistoryUid, RelAttachmentGroupUid) ' +
				'AS ( ' +
				'SELECT cpph.PatientProcedureHistoryUid, crag.RelAttachmentGroupUid ' +
				'FROM cus_RelAttachmentGroup crag ' +
				'inner join cus_PatientProcedure cpp on cpp.PatientProcedureUid = crag.PatientProcedureUid '+
				'inner join cus_PatientProcedureHistory cpph on cpph.PatientProcedureUid = cpp.PatientProcedureUid ' +
				'WHERE crag.PatientProcedureUid is not null ' +
				'AND crag.RelAttachmentGroupUid = RelAttachmentGroupUid ' +
				') UPDATE rag SET PatientProcedureHistoryUid = c.PatientProcedureHistoryUid ' +
				'FROM RelAttachmentGroup rag ' +
				'inner join cet c on rag.RelAttachmentGroupUid = c.RelAttachmentGroupUid '
	exec sp_executesql @sql

	-- set IsCurrentHistoryRow and GroupingUid
	declare @PatientProcedureHistoryUid uniqueidentifier
	declare @PatientUid uniqueidentifier
	declare @HistoryGroupUid uniqueidentifier
	declare @ProcedureHistoryTermUid uniqueidentifier
	declare @ProcedureUid uniqueidentifier
	declare @GroupingUid uniqueidentifier
	declare @LastPatientUid uniqueidentifier
	declare @LastHistoryGroupUid uniqueidentifier
	declare @LastProcedureHistoryTermUid uniqueidentifier
	declare @LastProcedureUid uniqueidentifier

	declare @LastPatientProcedureHistoryUid uniqueidentifier
	declare @cnt int

	DECLARE a_cursor CURSOR FAST_FORWARD FOR 
				select PatientProcedureHistoryUid, PatientUid, HistoryGroupUid, ProcedureHistoryTermUid, ProcedureUid
				from PatientProcedureHistory 
				order by PatientUid, HistoryGroupUid, ProcedureHistoryTermUid, ProcedureUid, [Sequence]
				
	OPEN a_cursor
	FETCH NEXT FROM a_cursor INTO @PatientProcedureHistoryUid, @PatientUid, @HistoryGroupUid, @ProcedureHistoryTermUid, @ProcedureUid

	set @GroupingUid = @PatientProcedureHistoryUid
	set @LastPatientUid = @PatientUid
	set @LastHistoryGroupUid = @HistoryGroupUid
	set @LastProcedureHistoryTermUid = @ProcedureHistoryTermUid
	set @LastProcedureUid = @ProcedureUid

	WHILE (@@fetch_status <> -1)
	BEGIN
		IF (@@fetch_status <> -2)
		BEGIN
			if (
				(@LastPatientUid <> @PatientUid) OR
				(@LastHistoryGroupUid <> @HistoryGroupUid) OR
				((@LastProcedureHistoryTermUid is not null) and (@LastProcedureHistoryTermUid <> @ProcedureHistoryTermUid)) OR
				((@LastProcedureHistoryTermUid is null) and (isnull(@LastProcedureUid, '00000000-0000-0000-0000-000000000000') <> isnull(@ProcedureUid, '00000000-0000-0000-0000-000000000000')))
				 )
			begin
				if (@LastPatientProcedureHistoryUid is not null)
				begin
					update PatientProcedureHistory SET IsCurrentHistoryRow = 1, GroupingUid = @GroupingUid where PatientProcedureHistoryUid = @LastPatientProcedureHistoryUid
				end
				set @cnt= 1
				set @LastPatientUid = @PatientUid
				set @LastHistoryGroupUid = @HistoryGroupUid
				set @LastProcedureHistoryTermUid = @ProcedureHistoryTermUid
				set @LastProcedureUid = @ProcedureUid
				set @GroupingUid = @PatientProcedureHistoryUid

				update PatientProcedureHistory SET IsCurrentHistoryRow = 0, GroupingUid = @GroupingUid where PatientProcedureHistoryUid = @PatientProcedureHistoryUid
			end
			else begin
				update PatientProcedureHistory SET IsCurrentHistoryRow = 0, GroupingUid = @GroupingUid where PatientProcedureHistoryUid = @PatientProcedureHistoryUid
			end
		
			set @LastPatientProcedureHistoryUid = @PatientProcedureHistoryUid
			set @cnt = @cnt + 1

		END -- of IF (@@fetch_status <> -2)
		
		FETCH NEXT FROM a_cursor INTO @PatientProcedureHistoryUid, @PatientUid, @HistoryGroupUid, @ProcedureHistoryTermUid, @ProcedureUid

	END -- of while...
	if (@LastPatientProcedureHistoryUid is not null)
	begin
		update PatientProcedureHistory SET IsCurrentHistoryRow = 1 where PatientProcedureHistoryUid = @LastPatientProcedureHistoryUid
	end
	CLOSE a_cursor
	DEALLOCATE a_cursor

END
GO

-- post migration for #57684
IF (dbo.Replication_IsReplicatedDB() = 0)
	-- AND (EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_57684PatientProblemDiagnosisHistory]') AND type in (N'U')))
	-- AND (EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_57684PatientProblemDiagnosis]') AND type in (N'U')))
	AND (EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_57684VisitDiagnosis	]') AND type in (N'U')))	

BEGIN
	declare @sql nvarchar(4000)
	
	-- set @sql = 'update ppdh set ppdh.Sequence = cus.SortDate ' +
				-- 'from cus_57684PatientProblemDiagnosisHistory cus ' +
				-- 'inner join PatientProblemDiagnosisHistory ppdh on cus.PatientProblemDiagnosisHistoryUid = ppdh.PatientProblemDiagnosisHistoryUid'
	
	-- exec sp_executesql @sql

	-- set IsCurrentHistoryRow and GroupingUid
	declare @PatientProblemDiagnosisHistoryUid uniqueidentifier
	declare @PatientUid uniqueidentifier
	declare @GroupingUid uniqueidentifier
	declare @DiseaseUid uniqueidentifier
	declare @Code9 varchar (1024)
	declare @Code10 varchar (1024)
	
	declare @LastPatientProblemDiagnosisHistoryUid uniqueidentifier
	declare @LastPatientUid uniqueidentifier
	declare @LastDiseaseUid uniqueidentifier
	declare @LastCode9 varchar (1024)
	declare @LastCode10 varchar (1024)
	declare @cnt int

	DECLARE a_cursor CURSOR FAST_FORWARD FOR 
				select PatientProblemDiagnosisHistoryUid, PatientUid, Code9, Code10, DiseaseUid
				from PatientProblemDiagnosisHistory 
				order by IsPatientProblem, PatientUid, Code9, Code10, DiseaseUid, [Sequence]
				
	OPEN a_cursor
	FETCH NEXT FROM a_cursor INTO @PatientProblemDiagnosisHistoryUid, @PatientUid, @Code9, @Code10, @DiseaseUid
	
	set @GroupingUid = @PatientProblemDiagnosisHistoryUid
	set @LastPatientUid = @PatientUid
	set @LastCode9 = @Code9
	set @LastCode10 = @Code10
	set @LastDiseaseUid = @DiseaseUid

	WHILE (@@fetch_status <> -1)
	BEGIN
		IF (@@fetch_status <> -2)
		BEGIN
			if (
				(@LastPatientUid <> @PatientUid) OR
				(ISNULL(@LastDiseaseUid, '00000000-0000-0000-0000-000000000000') <> ISNULL(@DiseaseUid, '00000000-0000-0000-0000-000000000000')) OR
				(ISNULL(@LastCode9, '') <> ISNULL(@Code9, '')) OR
				(ISNULL(@LastCode10, '') <> ISNULL(@Code10, ''))
				 )
			begin
				if (@LastPatientProblemDiagnosisHistoryUid is not null)
				begin
					update PatientProblemDiagnosisHistory SET IsCurrentHistoryRow = 1, GroupingUid = @GroupingUid where PatientProblemDiagnosisHistoryUid = @LastPatientProblemDiagnosisHistoryUid
				end
				set @cnt= 1
				
				set @LastPatientUid = @PatientUid
				set @LastCode9 = @Code9
				set @LastCode10 = @Code10
				set @LastDiseaseUid = @DiseaseUid
				set @GroupingUid = @PatientProblemDiagnosisHistoryUid
				set @LastPatientProblemDiagnosisHistoryUid = @PatientProblemDiagnosisHistoryUid

				update PatientProblemDiagnosisHistory SET IsCurrentHistoryRow = 0, GroupingUid = @GroupingUid where PatientProblemDiagnosisHistoryUid = @PatientProblemDiagnosisHistoryUid
			end
			else begin
				update PatientProblemDiagnosisHistory SET IsCurrentHistoryRow = 0, GroupingUid = @GroupingUid where PatientProblemDiagnosisHistoryUid = @PatientProblemDiagnosisHistoryUid
			end
		
			set @LastPatientProblemDiagnosisHistoryUid = @PatientProblemDiagnosisHistoryUid
			set @cnt = @cnt + 1

		END -- of IF (@@fetch_status <> -2)
		
		FETCH NEXT FROM a_cursor INTO @PatientProblemDiagnosisHistoryUid, @PatientUid, @Code9, @Code10, @DiseaseUid

	END -- of while...
	if (@LastPatientProblemDiagnosisHistoryUid is not null)
	begin
		update PatientProcedureHistory SET IsCurrentHistoryRow = 1 where PatientProcedureHistoryUid = @LastPatientProblemDiagnosisHistoryUid
	end
	CLOSE a_cursor
	DEALLOCATE a_cursor

	set @sql = 'update vd ' +
				'set vd.PatientProblemDiagnosisHistoryUid = ppdh.PatientProblemDiagnosisHistoryUid, vd.ProblemGroupingUid = ppdh.GroupingUid ' +
				'from VisitDiagnosis vd ' +
				'inner join cus_57684VisitDiagnosis cus_vd on vd.VisitDiagnosisUid = cus_vd.VisitDiagnosisUid ' +
				'inner join PatientProblemDiagnosisHistory ppdh on cus_vd.PatientProblemUid = ppdh.PatientProblemDiagnosisHistoryUid ' +
				'where cus_vd.PatientProblemUid is not null'
	
	exec sp_executesql @sql

END
GO

-- 60777_RemoveOldQuestionnaires.sql
--Medical Diseases Section
IF (EXISTS (SELECT * FROM ListSurveySection WHERE SurveySectionUid = '7181CBE2-9641-4945-99E0-CA1811EE1FF2'))
BEGIN 
update ListSurveySection set Inactive = 1 where SurveySectionUid = '7181CBE2-9641-4945-99E0-CA1811EE1FF2'
END

--Immunization Section
IF (EXISTS (SELECT * FROM ListSurveySection WHERE SurveySectionUid = '3DA78D87-BD4A-4C5A-9BBE-FEDB329D05C5'))
BEGIN 
update ListSurveySection set Inactive = 1 where SurveySectionUid = '3DA78D87-BD4A-4C5A-9BBE-FEDB329D05C5'
END

--Family Diseases Section
IF (EXISTS (SELECT * FROM ListSurveySection WHERE SurveySectionUid = 'B662B708-55FC-4C24-83F0-1B31A9195470'))
BEGIN 
update ListSurveySection set Inactive = 1 where SurveySectionUid = 'B662B708-55FC-4C24-83F0-1B31A9195470'
END

--Disables ALL questions related to Medical History
update ListSurveyQuestion set inactive = 1 where TargetType = 'Problem' 

--Disables ALL questions related to Family History
update ListSurveyQuestion set inactive = 1 where HistoryGroupUid = '00000000-0000-0000-0000-000000000104' 

--Disables ALL questions related to Immunization History
update ListSurveyQuestion set inactive = 1 where HistoryGroupUid = '00000000-0000-0000-0000-000000000111'
GO


-- #61017_AbilityToDefinePatientProviderTrackingRelationshipAsReferTo.sql
-- Bug Number : 61017 - Ability to define a patient provider tracking relationship as a refer to. 
--
-- Purpose    : For Referring Provider, set the default value for ExcludeFromReferrals to 1.
--              And, update ListFindTable FindControlClass and EditFormType for ListProviderCareType.
--
-- History of Changes
--                                        
--   Name      Date            Description
--   =========================================================================================
--   DJOST     2017.Nov.30     Script created
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	IF EXISTS (SELECT * 
			   FROM ListProviderCareType 
			   WHERE ProviderCareTypeUid = '9ED1CC47-1E90-41C1-81E4-16110078F9FE'  -- Referring Provider
					 AND ExcludeFromReferrals != 1
					 AND UserDefined != 1)
	BEGIN
		UPDATE ListProviderCareType 
		SET ExcludeFromReferrals = 1, 
			LastModifiedDate = DateAdd(MINUTE, 5, LastModifiedDate)
		WHERE ProviderCareTypeUid = '9ED1CC47-1E90-41C1-81E4-16110078F9FE'  -- Referring Provider
	END


	IF EXISTS (SELECT * 
	           FROM ListFindTable 
			   WHERE FindTableUid = '402d4bbd-5435-4fb9-a00a-c055f0f842b5'  -- ListProviderCareType
			         AND (FindControlClass != 'iMedica.Prm.Client.UI.PrmGeneralControls.Find.ControlFindProviderCareType' 
					      OR FindControlClass IS NULL
					      OR EditFormType != 'iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ControlProviderCareTypeList' 
						  OR EditFormType IS NULL))
	BEGIN
		UPDATE ListFindTable 
		SET  FindControlClass = 'iMedica.Prm.Client.UI.PrmGeneralControls.Find.ControlFindProviderCareType'
		    ,EditFormType     = 'iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ControlProviderCareTypeList'
			,LastModifiedDate  = DateAdd(MINUTE, 5, LastModifiedDate)
		WHERE FindTableUid = '402d4bbd-5435-4fb9-a00a-c055f0f842b5'  -- ListProviderCareType
	END     
END 
GO

-- #58403 Find RelPatientMedication records that are missing for electronic refill requests Accepted in the Mobile App
-- 58403-Missing-RelPatientMedication.sql
DECLARE @MissingRPM TABLE(
   RelVisitMedicationUid UNIQUEIDENTIFIER PRIMARY KEY,
   CloneMedicationSIGUid UNIQUEIDENTIFIER DEFAULT(NEWID()))

INSERT INTO @MissingRPM(RelVisitMedicationUid)
SELECT DISTINCT rvm.RelVisitMedicationUid
FROM RelVisitMedication rvm
INNER JOIN MessageERxRefillRequest mrx ON mrx.RelVisitMedicationUid = rvm.RelVisitMedicationUid
INNER JOIN Message msg ON msg.MessageUid = mrx.MessageUid
INNER JOIN MedicationSIG sig ON sig.MedicationSIGUid = rvm.MedicationSIGUid
INNER JOIN SIGDetail det ON det.MedicationSIGUid = rvm.MedicationSIGUid
LEFT JOIN RelPatientMedication rpm ON rpm.RelVisitMedicationUid = rvm.RelVisitMedicationUid
WHERE rvm.Prescribed = 1
  AND rpm.RelPatientMedicationUid IS NULL
  AND msg.MessageUid IS NOT NULL
  AND msg.CreatedDate > '20150101'
  AND mrx.AcceptRefillRequest = 1

-- if there any are missing then reconstruct them
IF EXISTS(SELECT * FROM @MissingRPM)
BEGIN
   -- PRINT 'clone the RelVisitMedication.MedicationSIG rows'
   SELECT sig.* INTO CUS_tMedicationSIG
   FROM @MissingRPM tmp
   INNER JOIN RelVisitMedication rvm ON rvm.RelVisitMedicationUid = tmp.RelVisitMedicationUid
   INNER JOIN MedicationSIG sig ON sig.MedicationSIGUid = rvm.MedicationSIGUid

   -- PRINT 'change the MedicationSIGUid'
   UPDATE sig
   SET
      MedicationSIGUid         = tmp.CloneMedicationSIGUid,
      IsRevised                = 0,
      UserDefined              = 1,
      PatienteRxEligibilityUid = null,
      CreatedBy                = rvm.LastModifiedByUid,
      CreatedDateTime          = rvm.LastModifiedDate
   FROM @MissingRPM tmp
   INNER JOIN RelVisitMedication rvm ON rvm.RelVisitMedicationUid = tmp.RelVisitMedicationUid
   INNER JOIN CUS_tMedicationSIG sig ON sig.MedicationSIGUid = rvm.MedicationSIGUid

   -- PRINT 'insert the cloned MedicationSIG rows'
   INSERT INTO MedicationSIG SELECT * FROM CUS_tMedicationSIG

   -- PRINT 'clone the RelVisitMedication.MedicationSIG.SIGDetail rows'
   SELECT det.* INTO CUS_tSIGDetail
   FROM @MissingRPM tmp
   INNER JOIN RelVisitMedication rvm ON rvm.RelVisitMedicationUid = tmp.RelVisitMedicationUid
   INNER JOIN SIGDetail det ON det.MedicationSIGUid = rvm.MedicationSIGUid

   -- PRINT 'change the SIGDetailUid and MedicationSIGUid'
   UPDATE det
   SET
      SIGDetailUid     = NEWID(),
      MedicationSIGUid = tmp.CloneMedicationSIGUid,
      UserDefined      = 1
   FROM @MissingRPM tmp
   INNER JOIN RelVisitMedication rvm ON rvm.RelVisitMedicationUid = tmp.RelVisitMedicationUid
   INNER JOIN CUS_tSIGDetail det ON det.MedicationSIGUid = rvm.MedicationSIGUid

   -- PRINT 'insert the cloned SIGDetail rows'
   INSERT INTO SIGDetail SELECT * FROM CUS_tSIGDetail

   -- PRINT 'clone the RelPatientMedication table'
   SELECT * INTO CUS_tRelPatientMedication FROM RelPatientMedication WHERE 1 = 0

   -- PRINT 'clone the RelPatientMedication rows'
   INSERT INTO CUS_tRelPatientMedication(
      RelPatientMedicationUid,
      MedicationSIGUid,
      RelVisitMedicationUid,
      PatientUid,
      ActiveDate,
      IsPatientInput,
      EnteredFromVisitUid,
      LastModifiedByUid,
      LastModifiedDate)
   SELECT
      RelPatientMedicationUid = rvm.RelVisitMedicationUid,
      MedicationSIGUid        = tmp.CloneMedicationSIGUid,
      RelVisitMedicationUid   = rvm.RelVisitMedicationUid,
      PatientUid              = vis.PatientUid,
      ActiveDate              = COALESCE(sig.OverallStartDate, det.ItemStartDate, rvm.LastModifiedDate),
      IsPatientInput          = 0,
      EnteredFromVisitUid     = vis.VisitUid,
      LastModifiedByUid       = rvm.LastModifiedByUid,
      LastModifiedDate        = rvm.LastModifiedDate
   FROM @MissingRPM tmp
   INNER JOIN RelVisitMedication rvm ON rvm.RelVisitMedicationUid = tmp.RelVisitMedicationUid
   INNER JOIN Visit vis ON vis.VisitUid = rvm.VisitUid
   LEFT JOIN MedicationSIG sig ON sig.MedicationSIGUid = rvm.MedicationSIGUid
   OUTER APPLY (SELECT ItemStartDate = MIN(det.ItemStartDate) FROM SIGDetail det WHERE det.MedicationSIGUid = sig.MedicationSIGUid) det

   -- PRINT 'insert the cloned RelPatientMedication rows'
   INSERT INTO RelPatientMedication SELECT * FROM CUS_tRelPatientMedication

   -- Drop the tables that were used as temp tables
   DROP TABLE CUS_tRelPatientMedication
   DROP TABLE CUS_tSIGDetail
   DROP TABLE CUS_tMedicationSIG
END
GO

-- 61218 UnassignedMessages.sql
-- Create UserGroup form Unassigned Messages
IF NOT EXISTS(SELECT * FROM ListUserGroup WHERE UserGroupUid = 'A5EB5C14-DE31-4C2D-95D5-6DCA55D8EFEB')
BEGIN
   INSERT INTO ListUserGroup(UserGroupUid, Name, UserGroupTypeUid, UserDefined, LastModifiedDate)
   VALUES('A5EB5C14-DE31-4C2D-95D5-6DCA55D8EFEB', 'Unassigned Messages', '10101010-0000-0000-0000-000000000003', 0, '2018-01-02 21:24:19.910')
END

-- Assign Administrators/Clinical Administrators to this new group
IF NOT EXISTS(SELECT * FROM UserGroupMember WHERE UserGroupUid = 'A5EB5C14-DE31-4C2D-95D5-6DCA55D8EFEB')
BEGIN
   INSERT INTO UserGroupMember(ExtentUserGroupUid, UserGroupUid, MemberUserGroupUid, UserDefined, LastModifiedDate)
   VALUES('15301E84-06C8-4BD1-BDE8-E88F2010AAD7', 'A5EB5C14-DE31-4C2D-95D5-6DCA55D8EFEB', '00000101-0000-0000-0000-000000000001', 1, '2018-01-02 21:24:19.910')

   INSERT INTO UserGroupMember(ExtentUserGroupUid, UserGroupUid, MemberUserGroupUid, UserDefined, LastModifiedDate)
   VALUES('F1183180-D362-4E74-BD3A-D0A9F7972E19', 'A5EB5C14-DE31-4C2D-95D5-6DCA55D8EFEB', '00000101-0000-0000-0000-000000000003', 1, '2018-01-02 21:24:19.910')
END

-- Give them permission to see the messsages
IF NOT EXISTS(SELECT * FROM SecurityUserGroup WHERE ParentObjectUid = 'A5EB5C14-DE31-4C2D-95D5-6DCA55D8EFEB' AND ObjectName = 'messagesecurity')
BEGIN
   INSERT INTO SecurityUserGroup(SecurityUserGroupUid, SecurityUid, ParentObjectUid, ObjectName, ObjectUid, UserGroupUid, Permission, UserDefined, LastModifiedDate)
   VALUES('C7E955F5-E2FE-456C-93F4-6BAD8C977B5D', '10101010-0000-0000-0000-100000000100', 'A5EB5C14-DE31-4C2D-95D5-6DCA55D8EFEB', 'messagesecurity', '10101010-0000-0000-0000-100000000100', 'A5EB5C14-DE31-4C2D-95D5-6DCA55D8EFEB', '134', 0, '2018-01-02 21:33:29.883')
END

--Assign all the unasssigned messages to this user group
INSERT INTO MessageUser(UserGroupUid, MessageUid)
SELECT 'A5EB5C14-DE31-4C2D-95D5-6DCA55D8EFEB', msg.MessageUid
FROM Message msg
LEFT JOIN MessageUser usr on usr.MessageUid = msg.MessageUid
WHERE usr.MessageUserUid IS NULL
GO

-- #64055 upPharmacyClearinghouse_V18_qry.sql
DECLARE @PharmacyClearinghouseUid [uniqueidentifier] = '118422AA-C165-4A2E-8389-E5B7E89636EA',
	@InterfaceDetail [xml],
	@updateInterfaceDetail[tinyint] = 0,
	@PRMVersion [varchar](24),
	@PRMSeq [int],
	@PRMBuild [varchar](24),
	@PRMVersion_New [varchar](24) = '18.0.0',
	@PRMSeq_New [int] = 1,
	@PRMBuild_New [varchar](24) = 'Common 18'

SELECT @InterfaceDetail = [InterfaceDetails]
FROM [ListPharmacyClearinghouse]
WHERE PharmacyClearinghouseUid = @PharmacyClearinghouseUid

IF @InterfaceDetail IS NOT NULL 
	AND CAST(@InterfaceDetail AS [varchar](max)) LIKE '<root%'
BEGIN
	SELECT
		@PRMVersion = x.n.value('@PRMVersion', '[varchar](24)'),
		@PRMSeq = x.n.value('@PRMSeq', '[int]'),
		@PRMBuild = x.n.value('@PRMBuild', '[varchar](24)')
	FROM @InterfaceDetail.nodes('root/VersionCommonFormulary') AS x(n)

	IF @PRMVersion IS NULL
		SET @updateInterfaceDetail = 1

	IF @PRMVersion < @PRMVersion_New
		SET @updateInterfaceDetail = 2

	IF @updateInterfaceDetail = 1
	BEGIN
		SET @InterfaceDetail.modify('insert <VersionCommonFormulary></VersionCommonFormulary> as first
			into (root)[1]')

		SET @InterfaceDetail.modify('insert attribute PRMBuild {sql:variable("@PRMBuild_New") }             
			into (root/VersionCommonFormulary)[1] ');
		SET @InterfaceDetail.modify('insert attribute PRMSeq {sql:variable("@PRMSeq_New") }             
			into (root/VersionCommonFormulary)[1] ');
		SET @InterfaceDetail.modify('insert attribute PRMVersion {sql:variable("@PRMVersion_New") }             
			into (root/VersionCommonFormulary)[1] ');
  	END
	IF @updateInterfaceDetail = 2
	BEGIN
		SET @InterfaceDetail.modify('replace value of (root/VersionCommonFormulary/@PRMVersion)[1] with sql:variable("@PRMVersion_New")')
		SET @InterfaceDetail.modify('replace value of (root/VersionCommonFormulary/@PRMSeq)[1] with sql:variable("@PRMSeq_New")')
		SET @InterfaceDetail.modify('replace value of (root/VersionCommonFormulary/@PRMBuild)[1] with sql:variable("@PRMBuild_New")')
	END

	IF @updateInterfaceDetail IN (1, 2)
	BEGIN
		UPDATE [ListPharmacyClearinghouse]
			SET [InterfaceDetails] = @InterfaceDetail
		WHERE [PharmacyClearinghouseUid] = @PharmacyClearinghouseUid
	END
END
GO

-- #64108 MigrationScript-Provider-CanSignRx.sql
UPDATE prv
SET prv.CanSignRx = 1
FROM Provider prv
INNER JOIN Person per ON per.PersonUid = prv.PersonUid
INNER JOIN UserPRM usr ON usr.PersonUid = prv.PersonUid
CROSS APPLY (
   SELECT TOP 1 *
   FROM ProviderDirectory pd
   WHERE pd.Inactive = 0
     AND pd.ProviderUid = prv.PersonUid
	 AND CONVERT(VARCHAR(MAX), ServiceLevelList) LIKE '%"NEW"%') ss
WHERE prv.Inactive = 0
  AND per.Inactive = 0
  AND usr.Inactive = 0
  AND prv.CanSignRx = 0
GO

-- Neil ListKdbConfiguration/ProviderDefaultSIG
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[temp_ListKdbConfiguration]') AND type in (N'U'))
begin
	declare @sql nvarchar(4000) =
	N'	UPDATE	p
	SET		KdbConfigurationUid = p.PersonUid
	FROM	[Provider] p
	WHERE	p.PersonUid IN (SELECT KdbConfigurationUid FROM ListKdbConfiguration)
	DROP TABLE temp_ListKdbConfiguration
	'
	exec (@sql)
end			
GO

-- #2952 Update Visit for new bit columns.sql
UPDATE	v
SET		IsEM = 1
FROM	Visit v INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
WHERE	vp.IsEM = 1

UPDATE	v
SET		HasPerformedProcedure = 1
FROM	Visit v INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
WHERE	vp.IsPerformed = 1
GO

-- #2019  2019_NotificationEmailMigrationScript_V2.sql
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	/*
		Task #2336 (Backlog item #2019) Migration script to Enable Notification Email
	
		1) Enable SendGrid ListIntegrationPartner
		2) Enable Notification Email Sender Job
		3) Enable Notification Email Sender Job Schedule
		4) Copy Practice From Email or Practice Email to Notification Email Integration Partner

		The following must be true:
			1) SendGrid Email License must be configured in ListProductParameter table (see RegistrationCustomerLicense)
			2) Notification Email ListIntegrationPartner is inactive
			3) Notification Email ListIntegrationPartner has no EmailAddress configured
			4) AprimaVault Downloader Job Schedule is active.
			5) EmailAddress has been specified for either the PracticeFromEmailAddress or the PracticeEmailAddress
	*/
	
	DECLARE @PracticeEmailAddressUid uniqueidentifier = 'ECDF36FC-D8AE-460C-AD3D-8EBBDEF9ABE1';
	DECLARE @PracticeFromEmailAddressUid uniqueidentifier = 'EFBB66F7-AFBB-421D-8A99-697D36FF5625';
	DECLARE @NotificationEmailIntegrationPartnerUid uniqueidentifier = 'DA632AE6-F2E2-44D6-A70C-1F14B3562376';	
	DECLARE @AprimaVaultDownloaderJobScheduleUid uniqueidentifier = 'BC972548-7BCF-4FE4-B1E3-B24D1ADF9503';	
	DECLARE @NotificationEmailSenderJobUid uniqueidentifier = 'DF8A3B2E-A8BD-4F4A-886E-8422A5F46223';
	DECLARE @NotificationEmailSenderJobScheduleUid uniqueidentifier = '3B65485D-54C5-4F01-9313-07F70399BC78';
	
	-- Get PracticeEmailAddress
	DECLARE @PracticeEmailAddress varchar(1000)
	SET @PracticeEmailAddress = (SELECT StringValue FROM ListProductParameter WHERE ProductParameterUid=@PracticeEmailAddressUid)
	--select @PracticeEmailAddress AS PracticeEmailAddress

	-- Get PracticeFromEmailAddress
	DECLARE @PracticeFromEmailAddress varchar(1000)
	SET @PracticeFromEmailAddress = (SELECT StringValue FROM ListProductParameter WHERE ProductParameterUid=@PracticeFromEmailAddressUid)
	--select @PracticeFromEmailAddress AS PracticeFromEmailAddress

	-- Get EmailAddress (if configured) from Notification Email ListIntegrationPartner
	DECLARE @LipEmailAddress varchar(1000)
	SET @LipEmailAddress = (SELECT convert(xml,AdditionalOutboundXML).value('(/Credentials/Site/EmailAddress)[1]', 'varchar(1000)') FROM ListIntegrationPartner WHERE IntegrationPartnerUid=@NotificationEmailIntegrationPartnerUid)

	-- Determine if we have a "from EmailAddress to use" (if not will not do update)
	DECLARE @SourceEmailAddress varchar(1000)
	SET @SourceEmailAddress = (SELECT COALESCE(NULLIF(@PracticeFromEmailAddress, ''), NULLIF(@PracticeEmailAddress,''),  null))
	--SELECT @SourceEmailAddress AS SourceEmailAddress

	DECLARE @LicenseKey varchar(1000)
	SET @LicenseKey = (SELECT XMLValue.value('(/License/Asset[@Name="EMAILNOTIFICATION"]/@LicenseKey)[1]', 'varchar(1000)') FROM ListProductParameter WHERE ParameterName='RegistrationCustomerLicense')
	--select @LicenseKey AS LicenseKey

	IF ((@LicenseKey IS NOT NULL) AND
		(@LipEmailAddress IS NULL) AND
		(@SourceEmailAddress IS NOT NULL) AND
		(EXISTS(select Inactive FROM JobSchedule WHERE JobScheduleUid=@AprimaVaultDownloaderJobScheduleUid AND Inactive=0)) AND
		(EXISTS(select Inactive FROM ListIntegrationPartner WHERE IntegrationPartnerUid=@NotificationEmailIntegrationPartnerUid AND Inactive=1)))
	BEGIN
		-- Set Notification Email ListIntegrationPartner active
		UPDATE ListIntegrationPartner 
			SET 
				Inactive=0,
				LastModifiedDate = GETUTCDATE()
			WHERE IntegrationPartnerUid=@NotificationEmailIntegrationPartnerUid
		-- Set Notification Email Sender Job to Active
		UPDATE ListJob 
			SET 
				Inactive=0,
				LastModifiedDate = GETUTCDATE()
			WHERE JobUid=@NotificationEmailSenderJobUid
		-- Set Notification Email Sender Job Schedule to Active
		UPDATE JobSchedule 
			SET 
				Inactive=0,
				LastModifiedDate = GETUTCDATE()
			WHERE JobScheduleUid=@NotificationEmailSenderJobScheduleUid

		-- Set From EmailAddress in ListIntegrationPartner (insert into AdditionalOutboundXML)
		DECLARE @tempXML XML
		SELECT @tempXML = CAST(AdditionalOutboundXML AS XML)
			FROM ListIntegrationPartner
			WHERE IntegrationPartnerUid = @NotificationEmailIntegrationPartnerUid 

		SET @tempXML.modify('insert <EmailAddress>{sql:variable("@SourceEmailAddress")}</EmailAddress> into (/Credentials/Site)[1]')

		Update ListIntegrationPartner
			SET 
				AdditionalOutboundXML = CAST(CAST (@tempXML AS VARCHAR (MAX)) AS TEXT),
				LastModifiedDate = GETUTCDATE()
			WHERE IntegrationPartnerUid = @NotificationEmailIntegrationPartnerUid 

		--SELECT 'Bug #2336 Notification Email migration has been done'
	END

	--SELECT inactive,* FROM listjob WHERE JobUid=@NotificationEmailSenderJobUid
	--SELECT inactive,* FROM JobSchedule WHERE JobScheduleUid=@NotificationEmailSenderJobScheduleUid
	--SELECT inactive,* FROM JobSchedule WHERE JobScheduleUid=@AprimaVaultDownloaderJobScheduleUid
	--SELECT Inactive,CONVERT(xml,AdditionalOutboundXML),* FROM ListIntegrationPartner WHERE IntegrationPartnerUid='DA632AE6-F2E2-44D6-A70C-1F14B3562376'
END
GO

-- #148 FmTemplate.Migration.sql
update  listformattingtemplate
    set
      IsPersonNotification = 1,
      IsPersonNotificationConfigured = 1
    where 
      formattingtemplateuid in
      ( 'C1608427-2FBD-4660-8931-54B990C449B7')
GO	  

-- #8144 Update of Test URLs  8144_Migration.sql
update TransmissionConfiguration
set TestAprimaVaultURL = 'https://cpdev01.aprima.corp:8443/communityexchange/partner/partnerService'
where TransmissionType in ('elgreq', 'rxhreq')

update TransmissionConfiguration
set TestOverrideAprimaVaultURL = 'https://cpdev01.aprima.corp:39020/AprimaService/InboundMessage.asmx'
where TransmissionType in ('elgreq', 'rxhreq')

update TransmissionConfiguration
set TestAprimaVaultURL = 'https://tiran.aprima.corp:8443/communityexchange/partner/PartnerService'
where TransmissionType in ('ePATransport','INBOUND','ProviderDirectory','SurescriptsDirectMessage','NEWRX','PRVUPD::Prescriber Download','REFRES')

update TransmissionConfiguration
set TestAprimaVaultSubmissionURL = 'https://tiran.aprima.corp:51375/communityexchange/partner/PartnerService'
where TransmissionType = 'PRVUPD::Prescriber Download'

update TransmissionConfiguration
set TestAprimaVaultSubmissionURL = 'https://tiran.aprima.corp:40049/communityexchange/partner/PartnerService'
where TransmissionType = 'SurescriptsDirectMessage'

update TransmissionConfiguration
set TestAprimaVaultSyncURL = 'https://cpdev01.aprima.corp:32110/'
where TransmissionType = 'SpecialtyPatientOnboard'

update TransmissionConfiguration
set TestAprimaVaultSyncURL = 'https://tiran.aprima.corp:40015/communityexchange/partner/PartnerService'
where TransmissionType in ('eRxOneTimePassword','PMBC','RFS','eRxAuditSearch','eRxProviderDirectory','eRxAuditRecord','SurescriptsDirectMessage','eRxOrganizationDirectory')

update TransmissionConfiguration
set TestAprimaVaultSyncURL = 'https://tiran.aprima.corp:51375/communityexchange/partner/PartnerService'
where TransmissionType = 'InboundMessageRoutingRegistration'

update TransmissionConfiguration
set TestAprimaVaultSyncURL = 'https://tiran.aprima.corp:40045/communityexchange/partner/PartnerService'
where TransmissionType = 'ePATransport'

update transmissionconfiguration
set TestRegistrationURL = 'https://tiran.aprima.corp:8443/communityexchange/partner/PartnerService'
where TransmissionType in ('ELGREQ','INBOUND','ProviderDirectory','RXHREQ','NEWRX','REFRES')

update TransmissionConfiguration
set TestRegistrationURL = 'https://tiran.aprima.corp:40015/communityexchange/partner/PartnerService'
where TransmissionType in ('eRxOneTimePassword','PMBC','RFS','eRxAuditSearch','eRxProviderDirectory','eRxAuditRecord','SurescriptsDirectMessage','eRxOrganizationDirectory')

update TransmissionConfiguration
set TestRegistrationURL = 'https://tiran.aprima.corp:51375/communityexchange/partner/PartnerService'
where TransmissionType = 'InboundMessageRoutingRegistration'

update TransmissionConfiguration
set TestRegistrationURL = ''
where TransmissionType = 'SpecialtyPatientOnboard'

update TransmissionConfiguration
set TestRegistrationURL = 'https://tiran.aprima.corp:40049/communityexchange/partner/PartnerService'
where TransmissionType = 'SurescriptsDirectMessage'

update transmissionconfiguration
set TestAprimaVaultSyncURL = 'https://cpdev01.aprima.corp:31060/hds'
where TransmissionType in ('HDSInterface')

update transmissionconfiguration
set TestAprimaVaultSyncURL = 'https://cpdev01.aprima.corp:31050/exp'
where TransmissionType in ('ExpInterface')
GO

/*
	#7664 #7664_ListFormattingTemplate_UpdateStatementBatchEmailTemplate.sql
*/
DECLARE @templateWithOutUnsubscribeLink VARCHAR(MAX)= '{\rtf1\ansi\ansicpg1252\uc1\deff0\adeff0\deflang0\deflangfe0\adeflang0{\fonttbl  {\f0\fswiss\fcharset0\fprq2{\*\panose 020B0604020202020204}Arial;}  {\f1\froman\fcharset2\fprq2{\*\panose 05050102010706020507}Symbol;}}  {\colortbl;\red0\green0\blue0;\red0\green0\blue255;\red25\green25\blue25;}  {\stylesheet{\s0\ltrpar\itap0\nowidctlpar\ql\li0\ri0\lin0\rin0\cbpat0\rtlch\af0\afs24\ltrch\f0\fs24 [Normal];}{\*\cs10\additive Default Paragraph Font;}{\s17\ltrpar\itap0\nowidctlpar\ql\li0\ri0\lin0\rin0\cbpat0\rtlch\af0\afs24\ltrch\f0\fs24\sbasedon0 BODY;}{\*\cs18\rtlch\aul\acf2\ltrch\ul\cf2\additive\sbasedon10 A;}}  {\info  {\*\txInfo{\txVer 24.0.712.500}}}  \paperw13296\paperh16838\margl720\margt1138\margr720\margb1138\deftab1134\widowctrl\lytexcttp\formshade\sectd  \headery567\footery567\pgwsxn13296\pghsxn16838\marglsxn720\margtsxn1138\margrsxn720\margbsxn1138\pgbrdropt32\pard\ltrpar\itap0\nowidctlpar\ql\li0\ri0\lin0\rin0\tx720\tx1440\tx2160\tx2880\tx3600\tx4320\tx5040\tx5760\tx6480\tx7200\tx7920\tx8640\tx9360\tx10080\plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0 A new statement is available for \plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0{\txfielddef{\*\txfieldstart\txfieldtype0\txfieldflags154\txfielddataval6\txfielddata   4100630063006f0075006e007400200052006500730070006f006e007300690062006c006500200050006100720074007900  20005300740061006e006400610072006400200044006100740061002e004100630063006f0075006e007400520065007300  70006f006e007300690062006c006500500061007200740079004e0061006d006500730020003c0046006f0072006d006100  740020005300750062004e006f00640065003d0022004100630063006f0075006e00740052006500730070006f006e007300  690062006c00650050006100720074007900460075006c006c004e0061006d006500220020002f003e000000}{\*\txfieldtext [[Account Responsible Party Standard Data.AccountResponsiblePartyNames]]{\*\txfieldend}}[[Account Responsible Party Standard Data.AccountResponsiblePartyNames]]}\plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0 . Please click the link below to access your new statement and your billing history. If this link does not work, copy and paste the link into your internet browser.\par\plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0{\txfielddef{\*\txfieldstart\txfieldtype0\txfieldflags154\txfielddataval5\txfielddata   4100630063006f0075006e007400200052006500730070006f006e007300690062006c006500200050006100720074007900  20005300740061006e006400610072006400200044006100740061002e00500061007400690065006e00740050006f007200  740061006c00550052004c00530074006100740065006d0065006e0074004c006f00670069006e0020003c0046006f007200  6d006100740020002000440065006600610075006c00740054006500780074003d00220055006e00610062006c0065002000  74006f002000670065006e00650072006100740065002000550052004c00220020002f003e000000}{\*\txfieldtext [[Account Responsible Party Standard Data.PatientPortalURLStatementLogin]]{\*\txfieldend}}[[Account Responsible Party Standard Data.PatientPortalURLStatementLogin]]}\plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0\par\par\plain\rtlch\af0\afs24\alang0\acf3\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0\cf3 You will need to enter the following code to access the statement. You may copy and paste this code in the login window.\plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0\par Access Code: \plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0{\txfielddef{\*\txfieldstart\txfieldtype0\txfieldflags154\txfielddataval6\txfielddata   4100630063006f0075006e007400200052006500730070006f006e007300690062006c006500200050006100720074007900  20005300740061006e006400610072006400200044006100740061002e0041006300630065007300730043006f0064006500  20003c0046006f0072006d006100740020004e00650077006c0069006e0065003d002200660061006c007300650022002000  2f003e000000}{\*\txfieldtext [[Account Responsible Party Standard Data.AccessCode]]{\*\txfieldend}}[[Account Responsible Party Standard Data.AccessCode]]}\plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0\par\pard\ltrpar\itap0\nowidctlpar\ql\li0\ri0\lin0\rin0  \par\pard\ltrpar\itap0\nowidctlpar\ql\li0\ri0\lin0\rin0\tx720\tx1440\tx2160\tx2880\tx3600\tx4320\tx5040\tx5760\tx6480\tx7200\tx7920\tx8640\tx9360\tx10080 If you have an account for our Patient Portal, you may access your full account information at this link. \plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0{\txfielddef{\*\txfieldstart\txfieldtype0\txfieldflags154\txfielddataval5\txfielddata   5300740061006e006400610072006400200044006100740061002e0050007200610063007400690063006500530065007400  740069006e0067007300500061007400690065006e00740050006f007200740061006c00550052004c000000}{\*\txfieldtext [[Standard Data.PracticeSettingsPatientPortalURL]]{\*\txfieldend}}[[Standard Data.PracticeSettingsPatientPortalURL]]}\plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0\par\par Thank you,\par\plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0{\txfielddef{\*\txfieldstart\txfieldtype0\txfieldflags154\txfielddataval5\txfielddata   5300740061006e006400610072006400200044006100740061002e0050007200610063007400690063006500530065007400  740069006e00670073004e0061006d0065000000}{\*\txfieldtext [[Standard Data.PracticeSettingsName]]{\*\txfieldend}}[[Standard Data.PracticeSettingsName]]}\plain\rtlch\af0\afs24\alang0\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0\par\plain\rtlch\af0\afs24\alang0\acf3\ltrch\f0\fs24\lang0\langnp0\langfe0\langfenp0\cf3\par\pard\ltrpar\s17\itap0\nowidctlpar\ql\li0\ri0\lin0\rin0\par }';
UPDATE ListFormattingTemplate
  SET
      Template = @templateWithOutUnsubscribeLink,
      LastModifiedDate = GETUTCDATE()
WHERE FormattingTemplateUid = 'C1608427-2FBD-4660-8931-54B990C449B7';
GO

