-------------------------------------------------------------------------
-- SP_DropSynonym - moved to first 5/13/15
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SP_DropSynonym]') and xtype in (N'P'))
drop procedure [dbo].[SP_DropSynonym]
GO
 
CREATE PROCEDURE dbo.SP_DropSynonym
AS
Declare @pk VARCHAR(128), @tb VARCHAR(128), @sql nvarchar(1000)

DECLARE CursorQuery CURSOR FAST_FORWARD FOR  
	SELECT name from sysobjects 
	WHERE type = 'SN' AND xtype = 'SN' AND name  not like 'cus!_%' escape '!' 
	ORDER BY name 

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'DROP SYNONYM [' + @pk + ']'
	exec sp_executesql @sql
    FETCH NEXT FROM CursorQuery INTO @pk
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN
GO

exec SP_DropSynonym
GO

-------------------------------------------------------------------------
-- SP_DropFK
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].SP_DropFK') and xtype in (N'P'))
drop procedure [dbo].[SP_DropFK]
GO

CREATE PROCEDURE dbo.SP_DropFK
AS
Declare @pk VARCHAR(128), @tb VARCHAR(128), @sql nvarchar(1000)

DECLARE CursorQuery CURSOR FAST_FORWARD FOR
	SELECT A.NAME, B.NAME 
	FROM SYSOBJECTS A, SYSOBJECTS B
	JOIN _migtemp_AllTableChanges mt ON B.name = mt.TableName
	WHERE A.PARENT_OBJ = B.ID AND A.xtype = 'F' AND A.NAME not like 'cus!_%' escape '!'

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk, @tb
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'ALTER TABLE [' + @tb + '] DROP CONSTRAINT [' + @pk + ']'
	exec sp_executesql @sql
	FETCH NEXT FROM CursorQuery INTO @pk, @tb
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN

GO

exec SP_DropFK
GO

-------------------------------------------------------------------------
-- SP_DropFKR  -- FK Reverse
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].SP_DropFKR') and xtype in (N'P'))
drop procedure [dbo].[SP_DropFKR]
GO

CREATE PROCEDURE dbo.SP_DropFKR
AS
Declare @pk VARCHAR(128), @tb VARCHAR(128), @sql nvarchar(1000)
DECLARE CursorQuery CURSOR FAST_FORWARD FOR
	SELECT object_name(fkeyid) AS [Name], object_name(constid) AS [Key]
	FROM sysreferences sr, _migtemp_AllTableChanges mt 
	WHERE rkeyid = object_id(mt.tableName)

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @tb, @pk
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'ALTER TABLE [' + @tb + '] DROP CONSTRAINT [' + @pk + ']'
	exec sp_executesql @sql
	FETCH NEXT FROM CursorQuery INTO @tb, @pk
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN

GO

exec SP_DropFKR
GO

-------------------------------------------------------------------------
-- SP_DropPK
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SP_DropPK]') and xtype in (N'P'))
drop procedure [dbo].[SP_DropPK]
GO

CREATE PROCEDURE dbo.SP_DropPK
AS
Declare @pk VARCHAR(128), @tb VARCHAR(128), @sql nvarchar(1000)

DECLARE CursorQuery CURSOR FAST_FORWARD FOR
	SELECT A.NAME, B.NAME 
	FROM SYSOBJECTS A, SYSOBJECTS B 
	JOIN _migtemp_AllTableChanges mt ON B.name = mt.TableName
	WHERE A.PARENT_OBJ = B.ID AND (A.xtype = 'PK'or A.xtype = 'UQ') and B.name <> 'dtproperties'  
	AND A.NAME not like 'cus!_%' escape '!' AND B.xtype = 'U'

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk, @tb
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'ALTER TABLE [' + @tb + '] DROP CONSTRAINT [' + @pk + ']'
	exec sp_executesql @sql
	FETCH NEXT FROM CursorQuery INTO @pk, @tb
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN
GO

-- exec SP_DropPK
GO
 
-------------------------------------------------------------------------
-- SP_DropTR
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SP_DropTR]') and xtype in (N'P'))
drop procedure [dbo].[SP_DropTR]
GO
 
CREATE PROCEDURE dbo.SP_DropTR
AS
Declare @pk VARCHAR(128), @tb VARCHAR(128), @sql nvarchar(1000)

DECLARE CursorQuery CURSOR FAST_FORWARD FOR  
	SELECT A.NAME, B.NAME 
	FROM SYSOBJECTS A, SYSOBJECTS B 
	WHERE A.PARENT_OBJ = B.ID AND A.xtype = 'TR' and B.xtype = 'U' AND A.NAME not like 'cus!_%' escape '!'

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk, @tb
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'DROP TRIGGER [' + @pk + ']'
	exec sp_executesql @sql
	FETCH NEXT FROM CursorQuery INTO @pk, @tb
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN
GO

exec SP_DropTR
GO

-------------------------------------------------------------------------
-- SP_DropDF
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SP_DropDF]') and xtype in (N'P'))
drop procedure [dbo].[SP_DropDF]
GO

CREATE PROCEDURE dbo.SP_DropDF
AS
Declare @pk VARCHAR(128), @tb VARCHAR(128), @sql nvarchar(1000)

DECLARE CursorQuery CURSOR FAST_FORWARD FOR
	SELECT A.NAME, B.NAME 
	FROM SYSOBJECTS A, SYSOBJECTS B 
	JOIN _migtemp_AllTableChanges mt ON B.name = mt.TableName
	WHERE A.PARENT_OBJ = B.ID AND A.xtype = 'D' and B.name <> 'dtproperties'  AND A.NAME not like 'cus!_%' escape '!'

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk, @tb
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'ALTER TABLE [' + @tb + '] DROP CONSTRAINT [' + @pk + ']'  
	exec sp_executesql @sql
	FETCH NEXT FROM CursorQuery INTO @pk, @tb
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN
GO

exec SP_DropDF
GO

-------------------------------------------------------------------------
-- SP_DropSP
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sp_dropSP]') and xtype in (N'P'))
drop procedure [dbo].[sp_dropSP]
GO

CREATE PROCEDURE dbo.sp_dropSP
AS
Declare @pk VARCHAR(128), @tb VARCHAR(128), @sql nvarchar(1000)

DECLARE CursorQuery CURSOR FAST_FORWARD FOR  
	SELECT name from sysobjects 
	WHERE xtype = 'p' and status >= 0 and name not like 'sp_drop%' AND NAME not like 'cus!_%' escape '!'

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'DROP PROCEDURE [' + @pk + ']'
	exec sp_executesql @sql
	FETCH NEXT FROM CursorQuery INTO @pk
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN
GO

exec sp_dropSP
GO

-------------------------------------------------------------------------
-- SP_DropVW
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SP_DropVW]') and xtype in (N'P'))
drop procedure [dbo].[SP_DropVW]
GO

CREATE PROCEDURE dbo.SP_DropVW
AS  Declare @pk VARCHAR(128), @sql nvarchar(1000), @nest int

DECLARE CursorQuery CURSOR FAST_FORWARD FOR  
WITH DepTree AS ( SELECT  o.name ,o.[object_id] AS referencing_id ,0 AS NestLevel
	FROM  sys.objects o WHERE o.is_ms_shipped = 0 AND o.type = 'V' AND o.name not like 'cus!_%' escape '!'
	AND o.name not like 'dbo.sysextendedarticlesview'
	AND o.name not like 'ViewListCacheMachine'  -- need this to prevent migration on cache machines
UNION ALL
	SELECT r.name ,d1.referencing_id ,NestLevel + 1
    FROM  sys.sql_expression_dependencies d1 JOIN DepTree r ON d1.referenced_id =  r.referencing_id
)
SELECT name as ViewName, MAX(NestLevel) AS MaxNestLevel FROM DepTree  GROUP BY name  ORDER BY MAX(NestLevel) ASC; 

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk, @nest
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'DROP VIEW [' + @pk + ']'
	exec sp_executesql @sql
    FETCH NEXT FROM CursorQuery INTO @pk, @nest
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN
GO

exec SP_DropVW
GO

-------------------------------------------------------------------------
-- SP_DropUF
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SP_DropUF]') and xtype in (N'P'))
drop procedure [dbo].[SP_DropUF]
GO

CREATE PROCEDURE dbo.SP_DropUF
AS
Declare @pk VARCHAR(128), @tb VARCHAR(128), @sql nvarchar(1000)

DECLARE CursorQuery CURSOR FAST_FORWARD FOR  
	SELECT name from sysobjects 
	WHERE (xtype = 'FN' or xtype = 'TF' or xtype = 'IF') AND NAME not like 'cus!_%' escape '!'
	AND name not like 'Replication_IsReplicatedDB'  -- need this to prevent migration on cache machines
OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'DROP FUNCTION [' + @pk + ']'
	exec sp_executesql @sql
	FETCH NEXT FROM CursorQuery INTO @pk
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN
GO

exec SP_DropUF
GO

 
-------------------------------------------------------------------------
-- SP_DropIX
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SP_DropIX]') and xtype in (N'P'))
drop procedure [dbo].[SP_DropIX]
GO

CREATE PROCEDURE dbo.SP_DropIX
AS
Declare @pk sysname, @tb sysname, @sql nvarchar(1000)

DECLARE CursorQuery CURSOR FAST_FORWARD FOR  
	SELECT si.name as [Index], so.Name as [Table] 
	FROM sysindexes si inner join sysobjects so on si.id = so.id 
	JOIN _migtemp_AllTableChanges mt ON so.Name = mt.TableName
	WHERE (si.indid > 0 and si.indid < 255) AND (si.Status & 64) = 0  and so.xtype = 'U' 
	and (si.status & 0x800) <> 0x800   and si.status & 4096 <> 4096 
	and si.name not like 'cus!_%' escape '!'
	and so.Name not like 'AuditArchive'

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk, @tb
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'DROP INDEX [' + @tb + '].[' + @pk + ']'
	exec sp_executesql @sql
	FETCH NEXT FROM CursorQuery INTO @pk, @tb
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN
GO

exec SP_DropIX
GO

-------------------------------------------------------------------------
-- SP_DropMigtemp
-------------------------------------------------------------------------
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SP_DropMigtemp]') and xtype in (N'P'))
drop procedure [dbo].[SP_DropMigtemp]
GO
 
CREATE PROCEDURE dbo.SP_DropMigtemp
AS
Declare @pk VARCHAR(128), @tb VARCHAR(128), @sql nvarchar(1000)

DECLARE CursorQuery CURSOR FAST_FORWARD FOR  
	SELECT name from sysobjects 
	WHERE type = 'U' AND xtype = 'U' AND name like 'migtemp!_%' escape '!' 
	ORDER BY name 

OPEN CursorQuery
FETCH NEXT FROM CursorQuery
INTO @pk
WHILE @@FETCH_STATUS = 0
BEGIN
	set @sql = 'DROP TABLE [' + @pk + ']'
	exec sp_executesql @sql
    FETCH NEXT FROM CursorQuery INTO @pk
END
CLOSE CursorQuery
DEALLOCATE CursorQuery
RETURN
GO

exec SP_DropMigtemp
GO

