-- clean up for new FK
delete from [RelHospitalRoundProvider] where HospitalRoundUid NOT IN (select HospitalRoundUid from [HospitalRound]) 
GO
UPDATE [ImmunizationHistory] SET [VaccinatorUid] = NULL
FROM [ImmunizationHistory] T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN [UserPRM] T2 ON T1.[VaccinatorUid] = T2.[PersonUid]
	WHERE T1.[VaccinatorUid] IS NOT NULL AND T2.[PersonUid] IS NULL;
GO
UPDATE [ObservationValue] SET [EnteredByUid] = NULL
FROM [ObservationValue] T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN [UserPRM] T2 ON T1.[EnteredByUid] = T2.[PersonUid]
	WHERE T1.[EnteredByUid] IS NOT NULL AND T2.[PersonUid] IS NULL;
GO

 -- =========================================================================
-- Pre migration for table "VisitDiagnosis"  Scenario 40188.  45282
-- =========================================================================
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_VisitDiagnosis]') AND type in (N'U'))
DROP TABLE [dbo].[cus_VisitDiagnosis]
GO

IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	select *  into cus_VisitDiagnosis from VisitDiagnosis
END
GO

-- 47402
--Prescript to copy values from Patient.PatientConditionUid to a temp table
IF EXISTS(SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('Patient') AND Name = 'PatientConditionUid')
BEGIN
	IF object_id('cus_RelPatientCondition') IS NULL
		CREATE TABLE [dbo].[cus_RelPatientCondition](
			[RelPatientConditionUid] [uniqueidentifier] NOT NULL,
			[PatientUid] [uniqueidentifier] NOT NULL,
			[PatientConditionUid] [uniqueidentifier] NOT NULL,
			[DisplayOrder] [int] NOT NULL,
			[LastModifiedByUid] [uniqueidentifier] NULL,
			[LastModifiedDate] [datetime] NOT NULL
		)
	ELSE
		DELETE FROM cus_RelPatientCondition
	EXEC dbo.sp_executesql @statement = N'	      
		INSERT INTO cus_RelPatientCondition (RelPatientConditionUid, PatientUid, PatientConditionUid, DisplayOrder, LastModifiedByUid, LastModifiedDate)
		Select distinct newid(), pat.PersonUid, pat.PatientConditionUid, 0, pat.LastModifiedByUid, pat.LastModifiedDate FROM Patient pat WHERE pat.PatientConditionUid IS NOT NULL 
		AND NOT EXISTS (SELECT rpc.PatientUid, rpc.PatientConditionUid from cus_RelPatientCondition rpc WHERE pat.PersonUid = rpc.PatientUid AND pat.PatientConditionUid = rpc.PatientConditionUid)
	'		
END
GO

-- 43435
if  exists(select * from sys.columns where name = N'Occupation' and Object_ID = Object_ID(N'personemployer'))
begin
	EXEC ('select pe.PersonEmployerUid, pe.Occupation into temp_tmpPersonEmployer from PersonEmployer pe')
end
GO

-- 49305 CMR: Eliminate duplicates in UOM table - 79305
DECLARE @systemUOM TABLE(
   SIGQuantityUnitOfMeasureUid   UNIQUEIDENTIFIER  ROWGUIDCOL NOT NULL PRIMARY KEY,
   ExternalID                    VARCHAR(25)       NULL,
   Inactive                      BIT               NOT NULL,
   Name                          VARCHAR(50)       NOT NULL,
   Notes                         VARCHAR(MAX)      NULL,
   Code                          VARCHAR(250)      NULL,
   NCItCode                      VARCHAR(50)       NULL,
   PrescriptionText              VARCHAR(20)       NULL,
   LastModifiedByUid             UNIQUEIDENTIFIER  NULL,
   LastModifiedDate              DATETIME          NOT NULL,
   UserDefined                   TINYINT           NOT NULL)

-- ListSIGQuantityUOM system defined entries
INSERT INTO @systemUOM VALUES('95B3F023-A3F7-424E-BCB5-991AAF21B184',NULL,0,'Ampule',NULL,NULL,'C48473','Ampule',NULL,'2014-07-09T15:34:11.687','0')
INSERT INTO @systemUOM VALUES('77782921-9BD1-40BD-B29F-6A58840FAA5F',NULL,0,'Applicator',NULL,NULL,'C62412','Applicator',NULL,'2014-07-09T15:34:11.687','0')
INSERT INTO @systemUOM VALUES('8736BF8D-0375-4523-8855-27FA99E86D8F',NULL,0,'Applicatorful',NULL,NULL,'C78783','Applicatorful',NULL,'2014-07-09T15:34:11.687','0')
INSERT INTO @systemUOM VALUES('F357636F-085B-41B9-8443-0504E7650728',NULL,0,'Bag',NULL,'BG','C48474','Bag',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('2D57C1EA-A563-4A57-8169-E08E868A7478',NULL,0,'Bar',NULL,NULL,'C48475','Bar',NULL,'2014-07-09T15:34:11.690','0')
INSERT INTO @systemUOM VALUES('7AD0B0F1-CB47-4054-AF20-9E033040657A',NULL,0,'Bead',NULL,NULL,'C53495','Bead',NULL,'2014-07-09T15:34:11.693','0')
INSERT INTO @systemUOM VALUES('8CB3F0E0-9153-4FCE-A840-CE14B821421A',NULL,0,'Blister',NULL,NULL,'C54564','Blister',NULL,'2014-07-09T15:34:11.693','0')
INSERT INTO @systemUOM VALUES('75BF2F96-078E-415A-B48D-8C42D1A7EB6B',NULL,0,'Block',NULL,NULL,'C53498','Block',NULL,'2014-07-09T15:34:11.697','0')
INSERT INTO @systemUOM VALUES('9A733194-4876-49D6-9170-3436758CEB95',NULL,0,'Bolus',NULL,NULL,'C48476','Bolus',NULL,'2014-07-09T15:34:11.700','0')
INSERT INTO @systemUOM VALUES('B11ECEA7-3715-494D-979B-7D2120D83E10',NULL,0,'Bottle',NULL,'BO','C48477','Bottle',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('50472086-7654-4CEF-A734-41922B3C4D08',NULL,0,'Box',NULL,'BX','C48478','Box',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('B709949A-6DD3-4D59-9562-620BCE8A774A',NULL,0,'Can',NULL,NULL,'C48479','Can',NULL,'2014-07-09T15:34:11.700','0')
INSERT INTO @systemUOM VALUES('09F101F1-EDC9-4CE7-A112-B387B70164C2',NULL,0,'Canister',NULL,NULL,'C62413','Canister',NULL,'2014-07-09T15:34:11.700','0')
INSERT INTO @systemUOM VALUES('7AC3D4B2-424B-4A75-B281-5C618BE25CCF',NULL,0,'Caplet',NULL,NULL,'C64696','Caplet',NULL,'2014-07-09T15:34:11.703','0')
INSERT INTO @systemUOM VALUES('74972C03-9C7F-4AF0-B3D9-4030EB8B3C82',NULL,0,'Capsule',NULL,'AV','C48480','Capsule',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('7C2A890A-DED7-4894-ACAF-8B3AA2623992',NULL,0,'Carton',NULL,NULL,'C54702','Carton',NULL,'2014-07-09T15:34:11.703','0')
INSERT INTO @systemUOM VALUES('0BDD7D87-DFEE-4F03-89F7-9E216172BCFF',NULL,0,'Cartridge',NULL,'CQ','C48481','Cartridge',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('56B4F051-639C-41AC-ABF5-91400FD5BCA7',NULL,0,'Case',NULL,NULL,'C62414','Case',NULL,'2014-07-09T15:34:11.707','0')
INSERT INTO @systemUOM VALUES('48E2ED7A-BE41-4525-A36B-DF9C588FBE81',NULL,0,'Cassette',NULL,NULL,'C69093','Cassette',NULL,'2014-07-09T15:34:11.710','0')
INSERT INTO @systemUOM VALUES('AF5603BD-DA99-46B9-9C33-E938319A94B9',NULL,0,'Container',NULL,'CH','C48484','Container',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('6BD21DFB-1A57-448C-AF35-54513A8BD896',NULL,0,'Cylinder',NULL,NULL,'C48489','Cylinder',NULL,'2014-07-09T15:34:11.710','0')
INSERT INTO @systemUOM VALUES('DCF38CD4-BCB4-4A20-993A-BF957D09B84E',NULL,0,'Device',NULL,NULL,'C16830','Device',NULL,'2016-04-28T20:44:50.450','0')
INSERT INTO @systemUOM VALUES('C9211FA1-B363-48F4-BF38-0E791E2711E2',NULL,0,'Disk',NULL,NULL,'C48490','Disk',NULL,'2014-07-09T15:34:11.717','0')
INSERT INTO @systemUOM VALUES('1D06CB0C-AB9A-4577-B929-F7DB28C9F805',NULL,0,'Dose Pack',NULL,NULL,'C62417','Dose Pack',NULL,'2014-07-09T15:34:11.717','0')
INSERT INTO @systemUOM VALUES('0420F9B5-2D4D-42AB-9180-F7306BA69276',NULL,1,'Drop',NULL,'X4',NULL,'Drop',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('55F4AB2C-EB07-4641-9930-201B886773AB',NULL,0,'Dual Pack',NULL,NULL,'C96265','Dual Pack',NULL,'2014-07-09T15:34:11.717','0')
INSERT INTO @systemUOM VALUES('D67C35A2-BBC7-48AB-BEAD-9D4AD1C54545',NULL,0,'Each',NULL,'EA','C64933','Each',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('5CFF081E-8F12-484C-980A-0CEF347BB3B5',NULL,0,'Film',NULL,NULL,'C53499','Film',NULL,'2014-07-09T15:34:11.717','0')
INSERT INTO @systemUOM VALUES('BC5F8D76-313F-4389-9A63-FA790093DC6E',NULL,0,'Fluid Ounce',NULL,'FO','C48494','Fluid Ounce',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('7FE05A74-E4DB-42D6-962F-59AFAD663BE8',NULL,0,'French',NULL,NULL,'C101680','French',NULL,'2014-07-09T15:34:11.740','0')
INSERT INTO @systemUOM VALUES('0C7B083C-D480-4F13-877F-F483AC829AB8',NULL,0,'Gallon',NULL,NULL,'C48580','Gallon',NULL,'2014-07-09T15:34:11.717','0')
INSERT INTO @systemUOM VALUES('56D508CE-5352-49C7-9559-65FF73AC5717',NULL,0,'Gram',NULL,'GR','C48155','Gram',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('352C9425-7C67-407D-A111-870757F019CB',NULL,0,'Gum',NULL,'Y7','C69124','Gum',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('A1BAE621-FAF0-4DBE-AC07-5779C689AE5C',NULL,0,'Implant',NULL,NULL,'C48499','Implant',NULL,'2014-07-09T15:34:11.717','0')
INSERT INTO @systemUOM VALUES('0CA4F9E9-9F20-4A9C-9FD6-294C264816DA',NULL,0,'Inhalation',NULL,NULL,'C48501','Inhalation',NULL,'2014-07-09T15:34:11.720','0')
INSERT INTO @systemUOM VALUES('90CC0864-AAAF-40FA-B39E-E472783FA9F6',NULL,0,'Inhaler',NULL,'IH','C62275','Inhaler',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('FDFF439B-3DDD-45E8-9440-F6BCD8536AA8',NULL,0,'Inhaler Refill',NULL,NULL,'C62418','Inhaler Refill',NULL,'2014-07-09T15:34:11.720','0')
INSERT INTO @systemUOM VALUES('C4346864-8479-4F6E-BB36-2AA6C81876F7',NULL,0,'Insert',NULL,NULL,'C62276','Insert',NULL,'2014-07-09T15:34:11.720','0')
INSERT INTO @systemUOM VALUES('CFD4D6AA-4FB2-44A8-BCA8-57C5B88975CC',NULL,1,'International Unit',NULL,'F2',NULL,'International Unit',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('89955F0E-90C0-4FDA-98F9-4AED67706AAA',NULL,0,'Intravenous Bag',NULL,NULL,'C67283','Intravenous Bag',NULL,'2014-07-09T15:34:11.720','0')
INSERT INTO @systemUOM VALUES('DCEA225C-9658-4EB1-B828-3EFD6BE493EC',NULL,0,'Kilogram',NULL,NULL,'C28252','Kilogram',NULL,'2014-07-09T15:34:11.720','0')
INSERT INTO @systemUOM VALUES('FAEB9B7F-C4B3-441A-B16D-DC089C472CB5',NULL,0,'Kit',NULL,'KT','C48504','Kit',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('10452109-CA3C-4521-8019-5B159B4AE0FA',NULL,0,'Lancet',NULL,NULL,'C120263','Lancet',NULL,'2016-04-28T20:44:50.450','0')
INSERT INTO @systemUOM VALUES('214A89B8-3C62-4A02-B83D-F55E640A23AB',NULL,0,'Liter',NULL,'LT','C48505','Liter',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('B020244F-DCBF-4F74-96C8-E20D07A24928',NULL,0,'Lozenge',NULL,'UU','C48506','Lozenge',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('DCB25539-C46E-440C-80CA-036E5E3B2BFB',NULL,0,'Metric Drop',NULL,NULL,'C48491','Metric Drop',NULL,'2014-07-09T15:34:11.720','0')
INSERT INTO @systemUOM VALUES('6F4FA67C-6431-4D4C-A68E-9E3CEC99AC53',NULL,0,'Milliequivalent',NULL,NULL,'C48512','Milliequivalent',NULL,'2014-07-09T15:34:11.740','0')
INSERT INTO @systemUOM VALUES('320D118F-4918-47BB-8B8B-0BB721A5509A',NULL,0,'Milligram',NULL,'ME','C28253','Milligram',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('B2B811B0-2AD8-4324-A909-A885936F1460',NULL,0,'Milliliter',NULL,'ML','C28254','Mililiter',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('41950CB1-F202-4914-93FD-7D8F66B316A8',NULL,0,'Millimeter',NULL,NULL,'C28251','Millimeter',NULL,'2014-07-09T15:34:11.720','0')
INSERT INTO @systemUOM VALUES('EF38CC93-541E-4191-BE5C-164CA672BC44',NULL,1,'Million Units',NULL,'UM',NULL,'Million Units',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('74F4E982-5C50-4DB1-BF79-3BE0C6748FD7',NULL,1,'Mutually Defined',NULL,'ZZ',NULL,'Mutually Defined',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('204B28FC-651D-44A1-A05D-3584B86D3E05',NULL,0,'Nebule',NULL,NULL,'C71204','Nebule',NULL,'2014-07-09T15:34:11.720','0')
INSERT INTO @systemUOM VALUES('8C172BC9-7FFE-434F-85F3-A22195F53E2F',NULL,0,'Needle Free Injection',NULL,NULL,'C100052','Needle Free Inject',NULL,'2014-07-09T15:34:11.723','0')
INSERT INTO @systemUOM VALUES('A1EF67ED-010E-45F1-A292-38B1FD03419D',NULL,0,'Not Specified',NULL,'00','C38046','Not Specified',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('46C1AA3B-77CC-4A34-92D7-5A5031FEA2E4',NULL,0,'Ocular System',NULL,NULL,'C69086','Ocular System',NULL,'2014-07-09T15:34:11.723','0')
INSERT INTO @systemUOM VALUES('C52CBD5C-15A4-49E8-A1FA-7D444121F59C',NULL,0,'Ounce',NULL,NULL,'C48519','Ounce',NULL,'2014-07-09T15:34:11.723','0')
INSERT INTO @systemUOM VALUES('35ED2374-2444-4086-A59E-F056F846D1F3',NULL,1,'Pack',NULL,'PH',NULL,'Pack',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('CC1A346E-0879-43F2-BB1D-E9C5D2CB83AA',NULL,0,'Package',NULL,NULL,'C48520','Package',NULL,'2014-07-09T15:34:11.727','0')
INSERT INTO @systemUOM VALUES('3E7CB1B6-FBF8-4626-B327-0B064E68BA72',NULL,0,'Packet',NULL,'12','C48521','Packet',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('0DB7C4C7-981B-4951-A5F5-29481B6797CD',NULL,0,'Pad',NULL,NULL,'C65032','Pad',NULL,'2014-07-09T15:34:11.727','0')
INSERT INTO @systemUOM VALUES('3DD2FBFA-B547-491C-B02B-30211DF8AFAD',NULL,0,'Paper',NULL,NULL,'C82484','Paper',NULL,'2014-07-09T15:34:11.727','0')
INSERT INTO @systemUOM VALUES('DA2A923D-EA5E-43E6-A11E-E9CC47230FA6',NULL,0,'Pen Needle',NULL,NULL,'C120216','Pen Needle',NULL,'2016-04-28T20:44:50.450','0')
INSERT INTO @systemUOM VALUES('7D30D2B2-1ADE-45F7-9790-F9F6970E889B',NULL,0,'Pint',NULL,'PT','C48529','Pint',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('17048F46-01CB-4334-A0B5-E6AB954B65FA',NULL,0,'Pouch',NULL,NULL,'C48530','Pouch',NULL,'2014-07-09T15:34:11.727','0')
INSERT INTO @systemUOM VALUES('3965F1C7-9037-4E23-9681-68CED7E3F69D',NULL,0,'Pound',NULL,NULL,'C48531','Pound',NULL,'2014-07-09T15:34:11.727','0')
INSERT INTO @systemUOM VALUES('A77502B9-37C8-4D39-904B-9620A329947D',NULL,0,'Pre-filled Pen Syringe',NULL,NULL,'C97717','Pen Syringe',NULL,'2014-07-09T15:34:11.740','0')
INSERT INTO @systemUOM VALUES('55CFD8A9-C129-48B0-B44C-9CA23304CC74',NULL,0,'Puff',NULL,NULL,'C65060','Puff',NULL,'2014-07-09T15:34:11.727','0')
INSERT INTO @systemUOM VALUES('F6DAF415-230B-4239-B0D5-6DA825FE8236',NULL,0,'Pump',NULL,NULL,'C111984','Pump',NULL,'2014-07-09T15:34:11.740','0')
INSERT INTO @systemUOM VALUES('6918BE82-027B-4803-AD82-536C7C7F4C13',NULL,0,'Quart',NULL,NULL,'C48534','Quart',NULL,'2014-07-09T15:34:11.730','0')
INSERT INTO @systemUOM VALUES('7CF420F6-FAE8-4541-803E-D0D9C052CEE1',NULL,0,'Ring',NULL,NULL,'C62609','Ring',NULL,'2014-07-09T15:34:11.730','0')
INSERT INTO @systemUOM VALUES('6BB0AA69-16EA-4E42-B4E5-5F6732EEB661',NULL,0,'Sachet',NULL,NULL,'C71324','Sachet',NULL,'2014-07-09T15:34:11.730','0')
INSERT INTO @systemUOM VALUES('ECD189AD-ADAD-47AE-B678-6C7D6F8D6979',NULL,0,'Scoopful',NULL,NULL,'C48536','Scoopful',NULL,'2014-07-09T15:34:11.730','0')
INSERT INTO @systemUOM VALUES('BD66BB68-365F-48E4-848D-E02F6D05330C',NULL,0,'Sponge',NULL,NULL,'C53502','Sponge',NULL,'2014-07-09T15:34:11.730','0')
INSERT INTO @systemUOM VALUES('32F73A67-741E-4983-9C1E-31AC8A9A088C',NULL,0,'Spray',NULL,NULL,'C48537','Spray',NULL,'2014-07-09T15:34:11.733','0')
INSERT INTO @systemUOM VALUES('95A1BBB0-1162-4DD5-B903-39D50075560D',NULL,0,'Stick',NULL,NULL,'C53503','Stick',NULL,'2014-07-09T15:34:11.733','0')
INSERT INTO @systemUOM VALUES('1B02BC97-DA5A-47D5-A9D4-93F64D081C78',NULL,0,'Strip',NULL,NULL,'C48538','Strip',NULL,'2014-07-09T15:34:11.737','0')
INSERT INTO @systemUOM VALUES('E8357870-A050-494D-94FC-391B7ECE24E3',NULL,0,'Suppository',NULL,'AR','C48539','Suppository',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('C2065642-436F-47A2-871F-D74865943C6B',NULL,0,'Swab',NULL,NULL,'C53504','Swab',NULL,'2014-07-09T15:34:11.737','0')
INSERT INTO @systemUOM VALUES('D68DE1E5-5836-4BD9-85C2-F5D275F637FC',NULL,0,'Syringe',NULL,'SZ','C48540','Syringe',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('83C4B10C-6933-4438-BCC0-B322DADA5A33',NULL,0,'Tablespoon',NULL,'Y2','C48541','Tablespoon',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('3720A2AF-50EA-4BBE-968D-90434F08CB8C',NULL,0,'Tablet',NULL,'U2','C48542','Tablet',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('0B664021-99CC-438B-B1D1-5D8AFA2D93E7',NULL,0,'Tabminder',NULL,NULL,'C62421','Tabminder',NULL,'2014-07-09T15:34:11.737','0')
INSERT INTO @systemUOM VALUES('71EA77A4-6A22-4028-9773-BE05FC95B8CB',NULL,0,'Tampon',NULL,NULL,'C48543','Tampon',NULL,'2014-07-09T15:34:11.737','0')
INSERT INTO @systemUOM VALUES('CCEC57E0-431F-48EE-A146-4AF1829C4B72',NULL,0,'Teaspoon',NULL,'Y3','C48544','Teaspoon',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('1A9D23BD-7EA8-48DF-805D-015451D90939',NULL,0,'Transdermal Patch',NULL,'FG','C48524','Patch',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('D41B6CE1-620D-47A4-81E9-8F339A52736C',NULL,0,'Tray',NULL,NULL,'C54704','Tray',NULL,'2014-07-09T15:34:11.737','0')
INSERT INTO @systemUOM VALUES('E87A026F-3275-40D6-A3EE-3177E4B4F02E',NULL,0,'Troche',NULL,NULL,'C48548','Troche',NULL,'2014-07-09T15:34:11.737','0')
INSERT INTO @systemUOM VALUES('2AE10A36-9595-4739-A719-8CE9171E0398',NULL,0,'Tube',NULL,'TB','C48549','Tube',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('24401A56-521E-467A-85C2-B0E6267A4B3C',NULL,1,'Unit',NULL,'UN',NULL,'Unit',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('90033E04-1D05-4E3C-AE49-D5B5C229B697',NULL,0,'Vial',NULL,'VI','C48551','Vial',NULL,'2008-06-20T00:00:00','0')
INSERT INTO @systemUOM VALUES('41BDDDA6-133B-45AC-B764-0FE1DD768A50',NULL,0,'Wafer',NULL,NULL,'C48552','Wafer',NULL,'2014-07-09T15:34:11.740','0')

-- since we are in the pre-script, we need to make sure all the rows are in the table so that duplicates don't come in after the pre-migration is finished
INSERT INTO ListSIGQuantityUnitOfMeasure(SIGQuantityUnitOfMeasureUid,ExternalID,Inactive,Name,Notes,Code,NCItCode,PrescriptionText,LastModifiedByUid,LastModifiedDate,UserDefined)
SELECT tmp.*
FROM @systemUOM tmp
LEFT JOIN ListSIGQuantityUnitOfMeasure uom ON uom.SIGQuantityUnitOfMeasureUid = tmp.SIGQuantityUnitOfMeasureUid
WHERE uom.SIGQuantityUnitOfMeasureUid IS NULL

-- just in case some crept in that are no longer active
UPDATE ListSIGQuantityUnitOfMeasure
SET UserDefined = 1
WHERE UserDefined != 1
  AND SIGQuantityUnitOfMeasureUid NOT IN(SELECT SIGQuantityUnitOfMeasureUid FROM @systemUOM)

-- now merge any duplicates
IF EXISTS(SELECT Name, COUNT(*)
          FROM ListSIGQuantityUnitOfMeasure
          GROUP BY Name
          HAVING COUNT(*) > 1)
BEGIN
   DECLARE @mergeUOM TABLE(dupUid UNIQUEIDENTIFIER NOT NULL PRIMARY KEY, mrgUid UNIQUEIDENTIFIER NOT NULL)

   -- fix the UserDefined that are same as SystemDefined
   INSERT INTO @mergeUOM
   SELECT
      dupUid = uom.SIGQuantityUnitOfMeasureUid,
      mrgUid = tmp.SIGQuantityUnitOfMeasureUid
   FROM ListSIGQuantityUnitOfMeasure uom
   INNER JOIN @systemUOM tmp ON tmp.Name = uom.Name
   WHERE uom.UserDefined = 1

   -- fix the UserDefined that are same as UserDefined - Using upper case to favor
   INSERT INTO @mergeUOM
   SELECT
      dupUid = uom.SIGQuantityUnitOfMeasureUid,
      mrgUid = ref.SIGQuantityUnitOfMeasureUid
   FROM ListSIGQuantityUnitOfMeasure uom
   CROSS APPLY(
      SELECT TOP 1 *
      FROM ListSIGQuantityUnitOfMeasure tab
     WHERE tab.Name = uom.Name
        AND tab.UserDefined = 1
       AND tab.SIGQuantityUnitOfMeasureUid != uom.SIGQuantityUnitOfMeasureUid
     ORDER BY CONVERT(VARBINARY(250), tab.Name)) ref
   WHERE uom.UserDefined = 1
    AND CONVERT(VARBINARY(250), ref.Name) < CONVERT(VARBINARY(250), uom.Name)
     AND uom.SIGQuantityUnitOfMeasureUid NOT IN(SELECT dupUid FROM @mergeUOM)

   -- fix the UserDefined that are same as UserDefined - Using code/case/uid to favor
   INSERT INTO @mergeUOM
   SELECT
      dupUid = uom.SIGQuantityUnitOfMeasureUid,
      mrgUid = ref.SIGQuantityUnitOfMeasureUid
   FROM ListSIGQuantityUnitOfMeasure uom
   CROSS APPLY(
      SELECT TOP 1 *
      FROM ListSIGQuantityUnitOfMeasure tab
     WHERE tab.Name = uom.Name
        AND tab.UserDefined = 1
     ORDER BY NCItCode DESC, CONVERT(VARBINARY(250), tab.Name), tab.SIGQuantityUnitOfMeasureUid) ref
   WHERE uom.UserDefined = 1
    AND uom.SIGQuantityUnitOfMeasureUid != ref.SIGQuantityUnitOfMeasureUid
     AND uom.SIGQuantityUnitOfMeasureUid NOT IN(SELECT dupUid FROM @mergeUOM)

   -- merge the reference to the survivor in foreign key references
   UPDATE sig
   SET SIGQuantityUnitOfMeasureUid = mrg.mrgUid
   FROM MedicationSIG sig
   INNER JOIN @mergeUOM mrg ON mrg.dupUid = sig.SIGQuantityUnitOfMeasureUid

   -- remove the duplicate
   DELETE uom
   FROM ListSIGQuantityUnitOfMeasure uom
   INNER JOIN @mergeUOM mrg ON mrg.dupUid = uom.SIGQuantityUnitOfMeasureUid

END
GO

-- 51561 split AuditWorkflowLog pre script
-- but first clean it out
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_AuditWorkflowLog]') AND type in (N'U'))
	drop table migtemp_AuditWorkflowLog
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AuditWorkflowLog]') AND type in (N'U'))
BEGIN
	TRUNCATE TABLE AuditWorkflowLog
	select * into migtemp_AuditWorkflowLog from AuditWorkflowLog
END	
GO

--Bug 51160:AR Active Write Off report (Excel Spreadsheet) generates patient balances when insurance only is selected
--delete ListUserDefinedControl entries
IF EXISTS (SELECT TOP 1 UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlGroupUid = 'f41e9591-057d-439e-bbb1-0606a5de8c43' and LastModifiedDate < '2016-09-30 00:00:00.000')
BEGIN
	DELETE ListUserDefinedControl WHERE UserDefinedControlGroupUid = 'f41e9591-057d-439e-bbb1-0606a5de8c43'
END
GO

-- =========================================================================
-- Pre migration for table "RelPatientPersonWeb"  Backlog Item #52862
-- created 11/9/2016
-- =========================================================================
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[temp_RelPatientPersonWeb]') AND type in (N'U'))
BEGIN
	DROP TABLE [dbo].[temp_RelPatientPersonWeb]
END
GO

IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	IF EXISTS(SELECT * FROM sys.columns WHERE Name = N'ResponsiblePartyWebAccess' AND Object_ID = Object_ID(N'Account'))
	EXEC dbo.sp_executesql @statement = N'
	BEGIN    
		CREATE TABLE [dbo].[temp_RelPatientPersonWeb](
			[RelPatientPersonWebUid] [uniqueidentifier] NOT NULL DEFAULT (newid()),
			[PersonUid] [uniqueidentifier] NOT NULL,
			[PatientUid] [uniqueidentifier] NOT NULL,
			[IgnoreAge] [bit] NOT NULL  DEFAULT ((0)),
			[Inactive] [smallint] NOT NULL  DEFAULT ((0)),
			[PersonContactUid] [uniqueidentifier] NULL,
			[LastModifiedDate] [datetime] NULL,
			[LastModifiedByUid] [uniqueidentifier] NULL)
			 
		insert into temp_RelPatientPersonWeb (PersonUid, PatientUid, Inactive, PersonContactUid, LastModifiedDate, LastModifiedByUid)
			select distinct AccountResponsibleParty.PersonUid as PersonUid,
							Account.PersonUid as PatientUid,
							0 as Inactive,
							null as PersonContactUid,
							GETUTCDATE() as LastModifiedDate,
							null as LastModifiedByUid 
			from Account 
				inner join (select * from AccountResponsibleParty  					
								where AccountResponsibleParty.PersonUid is not null)AccountResponsibleParty 
							on Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid
			where Account.ResponsiblePartyWebAccess = 1
		union
			select			personweb.PersonUid as PersonUid,
							personweb.PersonUid as PatientUid,
							0 as Inactive,
							null as PersonContactUid,
							GETUTCDATE() as LastModifiedDate,
							null as LastModifiedByUid  
			from PersonWeb
			where PersonWeb.PatientWebAccess = 1
	END
	'
END
GO

-- 20161114 kculberth Superbill Charge Analysis
-- Bug 52979:Application Error on SB Charge Analysis after HF and weekly maintenance
-- Bug 52986:Application Error received when generating the Superbill charge Analysis Report for a DX for a Specific Provider
-- Bug 52989:Application Error received when generating the Superbill charge Analysis Report for a DX
-- Bug 53044:Superbill Charge Analysis report header shows ALL, when filtering by procedure code
-- Bug 53610:Application Error when running Superbill Charge Analysis
-- Task 45848:Superbill Charge Analysis  add criteria for superbill status
--pre-migration script
IF EXISTS (SELECT TOP 1 UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlGroupUid = '84BAE892-3D6D-4D4A-B352-8945F73DEC24' and LastModifiedDate < '2016-11-14 00:00:00.000')
BEGIN
	DELETE ListUserDefinedControl WHERE UserDefinedControlGroupUid = '84BAE892-3D6D-4D4A-B352-8945F73DEC24'
END
GO

--20161028 kculberth Bug 48539:Getting Out of Memory application error when generating Reimbursement Analysis Report
--pre-migration script
IF EXISTS (SELECT TOP 1 UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlGroupUid = 'FF99BAAB-16B3-4864-9D6A-49732BBAC318' and LastModifiedDate < '2016-10-28 00:00:00.000')
BEGIN
	DELETE ListUserDefinedControl WHERE UserDefinedControlGroupUid = 'FF99BAAB-16B3-4864-9D6A-49732BBAC318'
END
IF EXISTS (SELECT TOP 1 UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlGroupUid = 'e564420d-cf91-42b9-976c-458f88623285' and LastModifiedDate < '2016-10-28 00:00:00.000')
BEGIN
	DELETE ListUserDefinedControl WHERE UserDefinedControlGroupUid = 'e564420d-cf91-42b9-976c-458f88623285'
END
GO

-- 56556: Issue with installing replication
DECLARE @ReplicationRuleConfigSetting [varchar](512) = 'ReplicationRuleConfig'

DELETE
FROM [ReplicationSettings]
WHERE [Name] = @ReplicationRuleConfigSetting
GO

-- 56342
--pre(CommonWellPatient) - copy stuff
IF (NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'temp_CommonWellPatient')
	AND EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'CommonWellPatient'))
BEGIN
select * into temp_CommonWellPatient from CommonWellPatient
END
--End pre

--pre(CommonWellDocument) - copy
IF (NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'temp_CommonWellDocument')
	AND EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'CommonWellDocument'))
BEGIN
select * into temp_CommonWellDocument from CommonWellDocument
END
--end pre
GO

-- 58479 ListAttachmentHandler -- PreScript
IF NOT EXISTS (SELECT * FROM ListAttachmentHandler where AttachmentHandlerUid='5DF0760B-2791-4ECD-8A56-6FB52B2F093A')
   AND dbo.Replication_IsReplicatedDB() = 0
BEGIN
   IF EXISTS(SELECT * FROM sys.objects WHERE object_id = OBJECT_ID('CUS_ListAttachmentHandler_58479') AND type IN('U'))
      DROP TABLE CUS_ListAttachmentHandler_58479
   SELECT * INTO CUS_ListAttachmentHandler_58479 FROM ListAttachmentHandler where AttachmentHandlerUid = '698415E1-9AAD-45AC-A5B1-90E0F8CBC4B1'
END
GO

/*
	Bug 59512:Database Migration Periodically Fails On Duplicate Key in Index PK_AR_ViewFinancialCenterClosingSummary_BatchInfo
	20170920	BRoy	Periodically (not very often) get error on migration
						Supplying sql so can run before migration if needed
						Below function as 'cache' tables on Financial Batch Closing
*/
DELETE FROM AR_ViewFinancialCenterClosingSummary_ObjectLinks;
DELETE FROM AR_ViewFinancialCenterClosingSummary_DepositsWithBalance;
DELETE FROM AR_ViewFinancialCenterClosingSummary_BatchInfo;
GO

-- #58646 
delete from ListUserDefinedControl
where UserDefinedControlGroupUid = '0a319a8b-b659-4295-a125-82c42344e3e4'--Adjustments Summary
GO
delete from ListUserDefinedControl
where UserDefinedControlUid = '9E795423-CB5F-4089-AE37-EA233241C04F' --Adjustments Detail Comparison Dates
GO
