
/****** Object:  Index [PK_IMO_ProblemIT_Custom_Word_Index]    Script Date: 10/24/2018 10:57:09 AM ******/
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_Custom_Word_Index]') AND name = N'PK_IMO_ProblemIT_Custom_Word_Index')
ALTER TABLE [dbo].[IMO_ProblemIT_Custom_Word_Index] DROP CONSTRAINT [PK_IMO_ProblemIT_Custom_Word_Index] WITH ( ONLINE = OFF )
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AccessCode]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[AccessCode](
	[AccessCodeUid] [uniqueidentifier] NOT NULL,
	[Code] [varchar](25) NOT NULL,
	[CreatedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccessCode'

ALTER TABLE [AccessCode] ADD  CONSTRAINT [DF_AccessCode_CreatedDate]  DEFAULT (getutcdate()) FOR [CreatedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_AccessionTracking]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_AccessionTracking](
	[AccessionTrackingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[LaboratoryUid] [uniqueidentifier] NULL,
	[IMedicaAccessionNumber] [varchar](25) NOT NULL,
	[QueueState] [int] NOT NULL CONSTRAINT [DF_AccessionTracking_QueueState]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_AccessionTracking_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
Truncate Table migtemp_AccessionTracking
INSERT [migtemp_AccessionTracking]([AccessionTrackingUid],[LaboratoryUid],[IMedicaAccessionNumber],[QueueState],[LastModifiedDate],[LastModifiedByUid])
SELECT [AccessionTrackingUid],[LaboratoryUid],[IMedicaAccessionNumber],[QueueState],[LastModifiedDate],[LastModifiedByUid]
FROM [AccessionTracking]

DROP TABLE [AccessionTracking]

exec  sp_rename 'migtemp_AccessionTracking', 'AccessionTracking'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Appointment]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Appointment](
	[AppointmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Appointment_AppointmentUid]  DEFAULT (newid()),
	[AppointmentTypeUid] [uniqueidentifier] NULL,
	[AppointmentStatusUid] [uniqueidentifier] NULL,
	[CheckinDateTime] [datetime] NULL,
	[DischargeDateTime] [datetime] NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[CalendarUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ProviderCareTypeUid] [uniqueidentifier] NULL,
	[ReferredbyProviderUid] [uniqueidentifier] NULL,
	[ReferringDate] [date] NULL,
	[Phone] [xml](CONTENT [dbo].[Phone]) NULL,
	[CallConfirmStatusUid] [uniqueidentifier] NULL,
	[CallConfirmStatusDetail] [varchar](max) NULL,
	[Reason] [varchar](max) NULL,
	[AuthorizationReminder] [bit] NOT NULL CONSTRAINT [DF_Appointment_AuthorizationReminder]  DEFAULT ((0)),
	[AuthorizationCode] [varchar](30) NULL,
	[StartDateTime] [datetime] NULL,
	[EndDateTime] [datetime] NULL,
	[ExternalID] [varchar](50) NULL,
	[Notes] [varchar](max) NULL,
	[CreatedByUid] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NULL CONSTRAINT [DF_Appointment_CreatedDate]  DEFAULT (getutcdate()),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Appointment_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[TriggerOverride] [bit] NOT NULL CONSTRAINT [DF_Appointment_TriggerOverride]  DEFAULT ((0)),
	[ReferralSrcUid] [uniqueidentifier] NULL,
	[ScheduleType] [tinyint] NOT NULL CONSTRAINT [DF_Appointment_ScheduleType]  DEFAULT ((0)),
	[PatientGroupUid] [uniqueidentifier] NULL,
	[RecurringInstanceUid] [uniqueidentifier] NULL,
	[AppointmentReplicationDataXml] [xml] NULL,
	[BillingProviderUid] [uniqueidentifier] NULL,
	[ClipboardUserUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment', @level2type=N'COLUMN',@level2name=N'AppointmentStatusUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.EnsureExternalId', @value=N'True' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'CreatedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'Replication.ListCalendar', @value=N'FK_Appointment_ListCalendar;PatientUid=NULL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_Appointment_Patient,FK_Appointment_Account,FK_RelGroupAppointmentPatient_Appointment}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'FK_Appointment_Provider;PatientUid=NULL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'
EXEC sys.sp_addextendedproperty @name=N'ScheduleType', @value=N'<PatientVisit value="0" description="Patient Visit" /><Event value="1" description="Event" /><BlockingEvent value="2" description="Blocking Event" /><GroupVisit value="3" description="Group Visit" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'


END
Truncate Table migtemp_Appointment
INSERT [migtemp_Appointment]([AppointmentUid],[AppointmentTypeUid],[AppointmentStatusUid],[CheckinDateTime],[DischargeDateTime],[PatientCaseUid],[PatientUid],[AccountUid],[CalendarUid],[ServiceSiteUid],[FinancialCenterUid],[ProviderUid],[ProviderCareTypeUid],[ReferredbyProviderUid],[ReferringDate],[Phone],[CallConfirmStatusUid],[CallConfirmStatusDetail],[Reason],[AuthorizationReminder],[AuthorizationCode],[StartDateTime],[EndDateTime],[ExternalID],[Notes],[CreatedByUid],[CreatedDateTime],[LastModifiedDate],[LastModifiedByUid],[TriggerOverride],[ReferralSrcUid],[ScheduleType],[PatientGroupUid],[RecurringInstanceUid],[AppointmentReplicationDataXml],[BillingProviderUid],[ClipboardUserUid])
SELECT [AppointmentUid],[AppointmentTypeUid],[AppointmentStatusUid],[CheckinDateTime],[DischargeDateTime],[PatientCaseUid],[PatientUid],[AccountUid],[CalendarUid],[ServiceSiteUid],[FinancialCenterUid],[ProviderUid],[ProviderCareTypeUid],[ReferredbyProviderUid],[ReferringDate],CONVERT(nvarchar(max), [Phone]),[CallConfirmStatusUid],[CallConfirmStatusDetail],[Reason],[AuthorizationReminder],[AuthorizationCode],[StartDateTime],[EndDateTime],[ExternalID],[Notes],[CreatedByUid],[CreatedDateTime],[LastModifiedDate],[LastModifiedByUid],[TriggerOverride],[ReferralSrcUid],[ScheduleType],[PatientGroupUid],[RecurringInstanceUid],CONVERT(nvarchar(max), [AppointmentReplicationDataXml]),[BillingProviderUid],[ClipboardUserUid]
FROM [Appointment]

DROP TABLE [Appointment]

exec  sp_rename 'migtemp_Appointment', 'Appointment'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_BatchProcess]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_BatchProcess](
	[BatchProcessUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_BatchProcess_BatchProcessUid]  DEFAULT (newid()),
	[BatchProcessTypeUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[Status] [smallint] NOT NULL CONSTRAINT [DF_BatchProcess_Status]  DEFAULT ((0)),
	[Parameters] [xml] NULL,
	[IntermediateXml] [xml] NULL,
	[SummaryXml] [xml] NULL,
	[ExportXml] [xml] NULL,
	[Error] [varchar](max) NULL,
	[Archive] [bit] NOT NULL CONSTRAINT [DF_BatchProcess_Archive]  DEFAULT ((0)),
	[AutoStartDetail] [bit] NOT NULL CONSTRAINT [DF_BatchProcess_AutoStart_1]  DEFAULT ((0)),
	[RunApplicationServer] [varchar](255) NULL,
	[RunMode] [smallint] NOT NULL CONSTRAINT [DF_BatchProcess_RunMode]  DEFAULT ((0)),
	[RunStartDateTime] [datetime] NULL,
	[RunStatus] [varchar](200) NULL,
	[RunCurrentItem] [int] NULL,
	[RunTotalItems] [int] NULL,
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_BatchProcess_CreatedDateTime]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_BatchProcess_LastModifiedDate]  DEFAULT (getutcdate()),
	[DisableParametersReset] [bit] NOT NULL CONSTRAINT [DF_BatchProcess_DisableParametersReset]  DEFAULT ((0)),
	[NameFormatUid] [uniqueidentifier] NULL,
	[Stage] [varchar](100) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_BatchProcess'
EXEC sys.sp_addextendedproperty @name=N'RunMode', @value=N'<NotRunning value="0" /><Summary value="1" /><Detail value="2" /><Staging value="6" /><Resetting value="98" /><Deleting value="99" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_BatchProcess'
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<NotStarted value="0" /><Summary value="1" /><Detail value="2" /><Transmitting value="3" /><Transmitted value="4" /><Error value="-1" /><Processing value="5" /><Staging value="6" /><OnDemand value="99" /><Completed value="100" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_BatchProcess'


END
Truncate Table migtemp_BatchProcess
INSERT [migtemp_BatchProcess]([BatchProcessUid],[BatchProcessTypeUid],[Name],[Status],[Parameters],[IntermediateXml],[SummaryXml],[ExportXml],[Error],[Archive],[AutoStartDetail],[RunApplicationServer],[RunMode],[RunStartDateTime],[RunStatus],[RunCurrentItem],[RunTotalItems],[CreatedDateTime],[LastModifiedByUid],[LastModifiedDate])
SELECT [BatchProcessUid],[BatchProcessTypeUid],[Name],[Status],CONVERT(nvarchar(max), [Parameters]),CONVERT(nvarchar(max), [IntermediateXml]),CONVERT(nvarchar(max), [SummaryXml]),CONVERT(nvarchar(max), [ExportXml]),[Error],[Archive],[AutoStartDetail],[RunApplicationServer],[RunMode],[RunStartDateTime],[RunStatus],[RunCurrentItem],[RunTotalItems],[CreatedDateTime],[LastModifiedByUid],[LastModifiedDate]
FROM [BatchProcess]

DROP TABLE [BatchProcess]

exec  sp_rename 'migtemp_BatchProcess', 'BatchProcess'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_BatchProcessDetail]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_BatchProcessDetail](
	[BatchProcessDetailUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_BatchProcessDetail_BatchProcessDetailUid]  DEFAULT (newid()),
	[Selected] [bit] NOT NULL CONSTRAINT [DF_BatchProcessDetail_Selected]  DEFAULT ((1)),
	[BatchProcessUid] [uniqueidentifier] NOT NULL,
	[IntermediateXml] [xml] NULL,
	[DetailXml] [xml] NULL,
	[ExportXml] [xml] NULL,
	[Error] [varchar](max) NULL,
	[Uid] [uniqueidentifier] NOT NULL,
	[Uid2] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_BatchProcessDetail_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_BatchProcessDetail'


END
Truncate Table migtemp_BatchProcessDetail
INSERT [migtemp_BatchProcessDetail]([BatchProcessDetailUid],[Selected],[BatchProcessUid],[IntermediateXml],[DetailXml],[ExportXml],[Error],[Uid],[LastModifiedByUid],[LastModifiedDate])
SELECT [BatchProcessDetailUid],[Selected],[BatchProcessUid],CONVERT(nvarchar(max), [IntermediateXml]),CONVERT(nvarchar(max), [DetailXml]),CONVERT(nvarchar(max), [ExportXml]),[Error],[Uid],[LastModifiedByUid],[LastModifiedDate]
FROM [BatchProcessDetail]

DROP TABLE [BatchProcessDetail]

exec  sp_rename 'migtemp_BatchProcessDetail', 'BatchProcessDetail'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ChargeCapture]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ChargeCapture](
	[ChargeCaptureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ExternalId] [varchar](25) NULL,
	[Notes] [varchar](max) NULL,
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[IsInvalid] [bit] NULL,
	[IsOpen] [bit] NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient that the Charge Capture is associated with' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChargeCapture', @level2type=N'COLUMN',@level2name=N'PatientUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Service Site where the services were performed on the Charge Capture' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChargeCapture', @level2type=N'COLUMN',@level2name=N'ServiceSiteUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Provider that created the Charge Capture' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChargeCapture', @level2type=N'COLUMN',@level2name=N'ProviderUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChargeCapture'

ALTER TABLE [migtemp_ChargeCapture] ADD  CONSTRAINT [df_ChargeCapture_ChargeCaptureUid]  DEFAULT (newid()) FOR [ChargeCaptureUid]
ALTER TABLE [migtemp_ChargeCapture] ADD  CONSTRAINT [df_ChargeCapture_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ChargeCapture
INSERT [migtemp_ChargeCapture]([ChargeCaptureUid],[PatientUid],[ExternalId],[Notes],[ServiceSiteUid],[IsInvalid],[IsOpen],[ProviderUid],[LastModifiedDate],[LastModifiedByUid])
SELECT [ChargeCaptureUid],[PatientUid],[ExternalId],[Notes],[ServiceSiteUid],[IsInvalid],[IsOpen],[ProviderUid],[LastModifiedDate],[LastModifiedByUid]
FROM [ChargeCapture]

DROP TABLE [ChargeCapture]

exec  sp_rename 'migtemp_ChargeCapture', 'ChargeCapture'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ChargeCapturePatientDiagnosisHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ChargeCapturePatientDiagnosisHistory](
	[ChargeCapturePatientDiagnosisHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[DateSaved] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ChargeCapturePatientDiagnosisHistory'

ALTER TABLE [ChargeCapturePatientDiagnosisHistory] ADD  CONSTRAINT [DF_ChargeCapturePatientDiagnosisHistory_ChargeCapturePatientDiagnosisHistoryUid]  DEFAULT (newid()) FOR [ChargeCapturePatientDiagnosisHistoryUid]
ALTER TABLE [ChargeCapturePatientDiagnosisHistory] ADD  CONSTRAINT [DF_ChargeCapturePatientDiagnosisHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [ChargeCapturePatientDiagnosisHistory] ADD  CONSTRAINT [DF_ChargeCapturePatientDiagnosisHistory_DateSaved]  DEFAULT (getdate()) FOR [DateSaved]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ChcAccountResponsibleParty]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ChcAccountResponsibleParty](
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[FamilySize] [tinyint] NOT NULL,
	[MonthlyIncome] [money] NOT NULL,
	[NoIncome] [bit] NOT NULL,
	[SFCorporationUid] [uniqueidentifier] NULL,
	[SFScheduleDetailUid] [uniqueidentifier] NULL,
	[SFFormOfDeclarationUid] [uniqueidentifier] NULL,
	[SFEffectiveDate] [date] NULL,
	[NotFedSFQual] [bit] NOT NULL,
	[RefusedFSMI] [bit] NOT NULL,
	[UseSFClass] [bit] NOT NULL,
	[SFNote] [text] NULL,
	[PayFrequency] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChcAccountResponsibleParty'

ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_FamilySize]  DEFAULT ((0)) FOR [FamilySize]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_MonthlyIncome]  DEFAULT ((0)) FOR [MonthlyIncome]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_NoIncome]  DEFAULT ((1)) FOR [NoIncome]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_NotFedSFQual]  DEFAULT ((0)) FOR [NotFedSFQual]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_RefusedFSMI]  DEFAULT ((0)) FOR [RefusedFSMI]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_UseSFClass]  DEFAULT ((0)) FOR [UseSFClass]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ChcAccountResponsibleParty
INSERT [migtemp_ChcAccountResponsibleParty]([AccountResponsiblePartyUid],[PersonUid],[FamilySize],[MonthlyIncome],[NoIncome],[SFCorporationUid],[SFScheduleDetailUid],[SFFormOfDeclarationUid],[SFEffectiveDate],[NotFedSFQual],[RefusedFSMI],[UseSFClass],[SFNote],[LastModifiedByUid],[LastModifiedDate])
SELECT [AccountResponsiblePartyUid],[PersonUid],[FamilySize],[MonthlyIncome],[NoIncome],[SFCorporationUid],[SFScheduleDetailUid],[SFFormOfDeclarationUid],[SFEffectiveDate],[NotFedSFQual],[RefusedFSMI],[UseSFClass],[SFNote],[LastModifiedByUid],[LastModifiedDate]
FROM [ChcAccountResponsibleParty]

DROP TABLE [ChcAccountResponsibleParty]

exec  sp_rename 'migtemp_ChcAccountResponsibleParty', 'ChcAccountResponsibleParty'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ClinicCenterChargeTicketDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ClinicCenterChargeTicketDiagnosis](
	[ClinicCenterChargeTicketDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[ChargeTicketDiagnosisUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'care team id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketDiagnosis', @level2type=N'COLUMN',@level2name=N'ClinicCenterUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Charge Ticket ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketDiagnosis', @level2type=N'COLUMN',@level2name=N'ChargeTicketDiagnosisUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Charge Ticket renamed Name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketDiagnosis', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ICD9 Charge Ticket for  care team' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketDiagnosis'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketDiagnosis'

ALTER TABLE [migtemp_ClinicCenterChargeTicketDiagnosis] ADD  CONSTRAINT [DF_ClinicCenterChargeTicketDiagnosis_ClinicCenterChargeTicketDiagnosisUid]  DEFAULT (newid()) FOR [ClinicCenterChargeTicketDiagnosisUid]
ALTER TABLE [migtemp_ClinicCenterChargeTicketDiagnosis] ADD  CONSTRAINT [DF_ClinicCenterChargeTicketDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ClinicCenterChargeTicketDiagnosis
INSERT [migtemp_ClinicCenterChargeTicketDiagnosis]([ClinicCenterChargeTicketDiagnosisUid],[ClinicCenterUid],[ChargeTicketDiagnosisUid],[Name],[LastModifiedByUid],[LastModifiedDate])
SELECT [ClinicCenterChargeTicketDiagnosisUid],[ClinicCenterUid],[ChargeTicketDiagnosisUid],[Name],[LastModifiedByUid],[LastModifiedDate]
FROM [ClinicCenterChargeTicketDiagnosis]

DROP TABLE [ClinicCenterChargeTicketDiagnosis]

exec  sp_rename 'migtemp_ClinicCenterChargeTicketDiagnosis', 'ClinicCenterChargeTicketDiagnosis'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ClinicCenterChargeTicketSO]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ClinicCenterChargeTicketSO](
	[ClinicCenterChargeTicketSOUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[ChargeTicketSOUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'care team id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSO', @level2type=N'COLUMN',@level2name=N'ClinicCenterUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'SO Charge Ticket ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSO', @level2type=N'COLUMN',@level2name=N'ChargeTicketSOUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Charge Ticket renamed Name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSO', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSO', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSO', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'SO Charge Ticket for  care team' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSO'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSO'

ALTER TABLE [migtemp_ClinicCenterChargeTicketSO] ADD  CONSTRAINT [DF_ClinicCenterChargeTicketSO_ClinicCenterChargeTicketSOUid]  DEFAULT (newid()) FOR [ClinicCenterChargeTicketSOUid]
ALTER TABLE [migtemp_ClinicCenterChargeTicketSO] ADD  CONSTRAINT [DF_ClinicCenterChargeTicketSO_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ClinicCenterChargeTicketSO
INSERT [migtemp_ClinicCenterChargeTicketSO]([ClinicCenterChargeTicketSOUid],[ClinicCenterUid],[ChargeTicketSOUid],[Name],[LastModifiedByUid],[LastModifiedDate])
SELECT [ClinicCenterChargeTicketSOUid],[ClinicCenterUid],[ChargeTicketSOUid],[Name],[LastModifiedByUid],[LastModifiedDate]
FROM [ClinicCenterChargeTicketSO]

DROP TABLE [ClinicCenterChargeTicketSO]

exec  sp_rename 'migtemp_ClinicCenterChargeTicketSO', 'ClinicCenterChargeTicketSO'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ClinicCenterChargeTicketSP]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ClinicCenterChargeTicketSP](
	[ClinicCenterChargeTicketSPUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NOT NULL,
	[ChargeTicketSPUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'care team id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSP', @level2type=N'COLUMN',@level2name=N'ClinicCenterUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'SP Charge Ticket ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSP', @level2type=N'COLUMN',@level2name=N'ChargeTicketSPUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Charge Ticket renamed Name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSP', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSP', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSP', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'SP Charge Ticket for  care team' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSP'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ClinicCenterChargeTicketSP'

ALTER TABLE [migtemp_ClinicCenterChargeTicketSP] ADD  CONSTRAINT [DF_ClinicCenterChargeTicketSP_ClinicCenterChargeTicketSPUid]  DEFAULT (newid()) FOR [ClinicCenterChargeTicketSPUid]
ALTER TABLE [migtemp_ClinicCenterChargeTicketSP] ADD  CONSTRAINT [DF_ClinicCenterChargeTicketSP_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ClinicCenterChargeTicketSP
INSERT [migtemp_ClinicCenterChargeTicketSP]([ClinicCenterChargeTicketSPUid],[ClinicCenterUid],[ChargeTicketSPUid],[Name],[LastModifiedByUid],[LastModifiedDate])
SELECT [ClinicCenterChargeTicketSPUid],[ClinicCenterUid],[ChargeTicketSPUid],[Name],[LastModifiedByUid],[LastModifiedDate]
FROM [ClinicCenterChargeTicketSP]

DROP TABLE [ClinicCenterChargeTicketSP]

exec  sp_rename 'migtemp_ClinicCenterChargeTicketSP', 'ClinicCenterChargeTicketSP'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CMSCodeXml]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[CMSCodeXml](
	[FilePath] [varchar](max) NULL,
	[Measure] [varchar](10) NULL,
	[Content] [varbinary](max) NULL,
	[XMLContent] [xml] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_CppAssessmentForm]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_CppAssessmentForm](
	[CppAssessmentFormUid] [uniqueidentifier] NOT NULL,
	[CppUid] [uniqueidentifier] NOT NULL,
	[AssessmentFormUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[Data] [xml] NULL,
	[Text] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_CppAssessmentForm', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_CppAssessmentForm', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_CppAssessmentForm'

ALTER TABLE [migtemp_CppAssessmentForm] ADD  CONSTRAINT [DF_CppAssessmentForm_CppAssessmentFormUid]  DEFAULT (newid()) FOR [CppAssessmentFormUid]
ALTER TABLE [migtemp_CppAssessmentForm] ADD  CONSTRAINT [DF_CppAssessmentForm_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_CppAssessmentForm] ADD  CONSTRAINT [DF_CppAssessmentForm_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_CppAssessmentForm
INSERT [migtemp_CppAssessmentForm]([CppAssessmentFormUid],[CppUid],[AssessmentFormUid],[Name],[Data],[Text],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate])
SELECT [CppAssessmentFormUid],[CppUid],[AssessmentFormUid],[Name],CONVERT(nvarchar(max), [Data]),[Text],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate]
FROM [CppAssessmentForm]

DROP TABLE [CppAssessmentForm]

exec  sp_rename 'migtemp_CppAssessmentForm', 'CppAssessmentForm'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[decileTemp]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[decileTemp](
	[ListDecileCQMUID] [uniqueidentifier] NOT NULL,
	[Measure_ID] [varchar](20) NOT NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_EligibilityRequest]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_EligibilityRequest](
	[EligibilityRequestUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_EligibilityRequest_EligibilityRequestUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PersonInsurancePlanUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[RequestDateTime] [datetime] NOT NULL CONSTRAINT [DF_EligibilityRequest_RequestDate]  DEFAULT (getutcdate()),
	[DateOfService] [date] NOT NULL,
	[MainAccountOnly] [bit] NOT NULL CONSTRAINT [DF_EligibilityRequest_MainAccountOnly]  DEFAULT ((1)),
	[TransmitDateTime] [datetime] NULL,
	[TransmitStatus] [varchar](50) NULL,
	[SubmissionID] [int] NULL,
	[RequestXML] [varchar](max) NULL,
	[RequestX12] [varchar](max) NULL,
	[ResponseXML] [varchar](max) NULL,
	[ResponseX12] [varchar](max) NULL,
	[Error] [varchar](max) NULL,
	[EligibilityStatusUid] [uniqueidentifier] NULL,
	[CopayPrimary] [money] NULL,
	[CopaySpecialist] [money] NULL,
	[CopayOther] [money] NULL,
	[InNetworkCoinsurance] [decimal](18, 0) NULL,
	[InNetworkDeductible] [money] NULL,
	[InNetworkRemaining] [money] NULL,
	[InNetworkMet] [money] NULL,
	[OutNetworkCoinsurance] [decimal](18, 0) NULL,
	[OutNetworkDeductible] [money] NULL,
	[OutNetworkRemaining] [money] NULL,
	[OutNetworkMet] [money] NULL,
	[EligibilityEffectiveDate] [date] NULL,
	[EligibilityExpirationDate] [date] NULL,
	[EligibilityNotes] [varchar](8000) NULL,
	[RequestType] [varchar](10) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_EligibilityRequest_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ResponseHTML] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RequestDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'RequestDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'TransmitDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'TransmitDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay amount.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'CopayPrimary'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay to use if provider is acting as a specialist.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'CopaySpecialist'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay to use if provider is not acting as primary or specialist.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'CopayOther'
EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest'


END
Truncate Table migtemp_EligibilityRequest
INSERT [migtemp_EligibilityRequest]([EligibilityRequestUid],[PatientUid],[PersonInsurancePlanUid],[ProviderUid],[RequestDateTime],[DateOfService],[MainAccountOnly],[TransmitDateTime],[TransmitStatus],[SubmissionID],[RequestXML],[RequestX12],[ResponseXML],[ResponseX12],[Error],[EligibilityStatusUid],[CopayPrimary],[CopaySpecialist],[CopayOther],[InNetworkCoinsurance],[InNetworkDeductible],[InNetworkRemaining],[InNetworkMet],[OutNetworkCoinsurance],[OutNetworkDeductible],[OutNetworkRemaining],[OutNetworkMet],[EligibilityEffectiveDate],[EligibilityExpirationDate],[EligibilityNotes],[RequestType],[LastModifiedDate],[LastModifiedByUid])
SELECT [EligibilityRequestUid],[PatientUid],[PersonInsurancePlanUid],[ProviderUid],[RequestDateTime],[DateOfService],[MainAccountOnly],[TransmitDateTime],[TransmitStatus],[SubmissionID],[RequestXML],[RequestX12],[ResponseXML],[ResponseX12],[Error],[EligibilityStatusUid],[CopayPrimary],[CopaySpecialist],[CopayOther],[InNetworkCoinsurance],[InNetworkDeductible],[InNetworkRemaining],[InNetworkMet],[OutNetworkCoinsurance],[OutNetworkDeductible],[OutNetworkRemaining],[OutNetworkMet],[EligibilityEffectiveDate],[EligibilityExpirationDate],[EligibilityNotes],[RequestType],[LastModifiedDate],[LastModifiedByUid]
FROM [EligibilityRequest]

DROP TABLE [EligibilityRequest]

exec  sp_rename 'migtemp_EligibilityRequest', 'EligibilityRequest'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ERAClaimPaymentInfoError]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ERAClaimPaymentInfoError](
	[ERAClaimPaymentInfoErrorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ERAClaimPaymentInfoUid] [uniqueidentifier] NOT NULL,
	[ErrorText] [varchar](max) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Sequence] [bigint] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ERAClaimPaymentInfoError'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ERAClaimPaymentInfoError'

ALTER TABLE [migtemp_ERAClaimPaymentInfoError] ADD  CONSTRAINT [DF_ERAClaimPaymentInfoError_ERAClaimPaymentInfoErrorUid]  DEFAULT (newid()) FOR [ERAClaimPaymentInfoErrorUid]
ALTER TABLE [migtemp_ERAClaimPaymentInfoError] ADD  CONSTRAINT [DF_ERAClaimPaymentInfoError_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ERAClaimPaymentInfoError
INSERT [migtemp_ERAClaimPaymentInfoError]([ERAClaimPaymentInfoErrorUid],[ERAClaimPaymentInfoUid],[ErrorText],[LastModifiedDate],[Sequence])
SELECT [ERAClaimPaymentInfoErrorUid],[ERAClaimPaymentInfoUid],[ErrorText],[LastModifiedDate],[Sequence]
FROM [ERAClaimPaymentInfoError]

DROP TABLE [ERAClaimPaymentInfoError]

exec  sp_rename 'migtemp_ERAClaimPaymentInfoError', 'ERAClaimPaymentInfoError'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ErrorReport]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ErrorReport](
	[ErrorReportUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Version] [varchar](24) NULL,
	[UserName] [varchar](100) NULL,
	[ComputerName] [varchar](100) NULL,
	[Message] [varchar](max) NULL,
	[Text] [varchar](max) NULL,
	[ScreenImage] [varbinary](max) NULL,
	[Notes] [varchar](max) NULL,
	[Uploaded] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[TextXML] [xml] NULL,
	[Origin] [int] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Origin', @value=N'<Unknown value="0" /><ClientUI value="1" /><ClientNoUI value="2" /><Appserver value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ErrorReport'
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ErrorReport'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ErrorReport'

ALTER TABLE [migtemp_ErrorReport] ADD  CONSTRAINT [DF_ErrorReport_ErrorReportUid]  DEFAULT (newid()) FOR [ErrorReportUid]
ALTER TABLE [migtemp_ErrorReport] ADD  CONSTRAINT [DF_ErrorReport_Uploaded]  DEFAULT ((0)) FOR [Uploaded]
ALTER TABLE [migtemp_ErrorReport] ADD  CONSTRAINT [DF_ErrorReport_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_ErrorReport] ADD  CONSTRAINT [DF_ErrorReport_Origin]  DEFAULT ((0)) FOR [Origin]

END
Truncate Table migtemp_ErrorReport
INSERT [migtemp_ErrorReport]([ErrorReportUid],[Version],[UserName],[ComputerName],[Message],[Text],[ScreenImage],[Notes],[Uploaded],[LastModifiedDate])
SELECT [ErrorReportUid],[Version],[UserName],[ComputerName],[Message],[Text],[ScreenImage],[Notes],[Uploaded],[LastModifiedDate]
FROM [ErrorReport]

DROP TABLE [ErrorReport]

exec  sp_rename 'migtemp_ErrorReport', 'ErrorReport'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_eRxMedicationHistoryOutbound]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_eRxMedicationHistoryOutbound](
	[eRxMedicationHistoryOutboundUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_eRxMedicationHistoryOutboundUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[eRxMessageTypeUid] [uniqueidentifier] NOT NULL,
	[eRxStatusUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientConsent] [bit] NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_PatientConsent]  DEFAULT ((0)),
	[RequestDateFrom] [dbo].[PRMDateTimeUnconverted] NULL,
	[RequestDateTo] [dbo].[PRMDateTimeUnconverted] NULL,
	[MessageXML] [varchar](max) NOT NULL,
	[MessageSent] [varchar](max) NULL,
	[SendResponse] [varchar](max) NULL,
	[Processed] [bit] NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_Processed]  DEFAULT ((0)),
	[Successful] [bit] NULL,
	[OrderNumber] [varchar](35) NULL,
	[OrderDateTime] [datetime] NULL,
	[eMedHxSource] [varchar](80) NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_eMedHxSource]  DEFAULT ('XXXXX'),
	[eMedHxRequestType] [varchar](8) NULL,
	[SubmitByUid] [uniqueidentifier] NULL,
	[PatienteRxEligibilityUid] [uniqueidentifier] NULL,
	[RelatesToMessageID] [varchar](35) NULL,
	[RequestXML] [xml] NULL,
	[RequestNCPDP] [varchar](max) NULL,
	[ResponseXML] [xml] NULL,
	[ResponseNCPDP] [varchar](max) NULL,
	[ProcessStatus] [varchar](max) NULL,
	[TransmissionConfigurationUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eRxMedicationHistoryOutbound_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_eRxMedicationHistoryOutbound'


END
Truncate Table migtemp_eRxMedicationHistoryOutbound
INSERT [migtemp_eRxMedicationHistoryOutbound]([eRxMedicationHistoryOutboundUid],[ProviderUid],[PharmacyClearinghouseUid],[eRxMessageTypeUid],[eRxStatusUid],[ServiceSiteUid],[PatientUid],[PatientConsent],[RequestDateFrom],[RequestDateTo],[MessageXML],[MessageSent],[SendResponse],[Processed],[Successful],[OrderNumber],[OrderDateTime],[eMedHxSource],[eMedHxRequestType],[SubmitByUid],[PatienteRxEligibilityUid],[RelatesToMessageID],[RequestXML],[RequestNCPDP],[ResponseXML],[ResponseNCPDP],[ProcessStatus],[TransmissionConfigurationUid],[LastModifiedDate],[LastModifiedByUid])
SELECT [eRxMedicationHistoryOutboundUid],[ProviderUid],[PharmacyClearinghouseUid],[eRxMessageTypeUid],[eRxStatusUid],[ServiceSiteUid],[PatientUid],[PatientConsent],[RequestDateFrom],[RequestDateTo],[MessageXML],[MessageSent],[SendResponse],[Processed],[Successful],[OrderNumber],[OrderDateTime],[eMedHxSource],[eMedHxRequestType],[SubmitByUid],[PatienteRxEligibilityUid],[RelatesToMessageID],CONVERT(nvarchar(max), [RequestXML]),[RequestNCPDP],CONVERT(nvarchar(max), [ResponseXML]),[ResponseNCPDP],[ProcessStatus],[TransmissionConfigurationUid],[LastModifiedDate],[LastModifiedByUid]
FROM [eRxMedicationHistoryOutbound]

DROP TABLE [eRxMedicationHistoryOutbound]

exec  sp_rename 'migtemp_eRxMedicationHistoryOutbound', 'eRxMedicationHistoryOutbound'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_eRxOutbound]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_eRxOutbound](
	[eRxOutboundUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_eRxOutbound_eRxOutboundUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[PharmacyClearinghouseUid] [uniqueidentifier] NOT NULL,
	[PharmacyUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[RelVisitMedicationUid] [uniqueidentifier] NULL,
	[SIGDetailUid] [uniqueidentifier] NULL,
	[eRxMessageTypeUid] [uniqueidentifier] NOT NULL,
	[MessageXML] [varchar](max) NOT NULL,
	[MessageSent] [varchar](max) NULL,
	[SendResponse] [varchar](max) NULL,
	[Processed] [bit] NOT NULL CONSTRAINT [DF_eRxOutbound_Processed]  DEFAULT ((0)),
	[Successful] [bit] NULL,
	[RelatesToMessageID] [varchar](35) NULL,
	[SubmitByUid] [uniqueidentifier] NULL,
	[RequestXML] [xml] NULL,
	[RequestNCPDP] [varchar](max) NULL,
	[ResponseXML] [xml] NULL,
	[ResponseNCPDP] [varchar](max) NULL,
	[ProcessStatus] [varchar](max) NULL,
	[TransmissionConfigurationUid] [uniqueidentifier] NULL,
	[OrderNumber] [varchar](35) NULL,
	[OrderDateTime] [datetime] NULL,
	[DigitalSignatureDigestValue] [varchar](max) NULL,
	[DigitalSignatureSignatureValue] [varchar](max) NULL,
	[DigitalSignatureX509Data] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_eRxOutbound_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_eRxOutbound'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_eRxOutbound_Visit,FK_eRxOutbound_SIGDetail,FK_eRxOutbound_RelVisitMedication,FK_MessageERxChangeRequest_eRxOutbound,FK_MessageERxRefillRequest_eRxOutbound,FK_MessageRx_eRxOutbound}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_eRxOutbound'
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'!FK_eRxOutbound_Provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_eRxOutbound'


END
Truncate Table migtemp_eRxOutbound
INSERT [migtemp_eRxOutbound]([eRxOutboundUid],[ProviderUid],[PharmacyClearinghouseUid],[PharmacyUid],[VisitUid],[RelVisitMedicationUid],[SIGDetailUid],[eRxMessageTypeUid],[MessageXML],[MessageSent],[SendResponse],[Processed],[Successful],[RelatesToMessageID],[SubmitByUid],[RequestXML],[RequestNCPDP],[ResponseXML],[ResponseNCPDP],[ProcessStatus],[TransmissionConfigurationUid],[OrderNumber],[OrderDateTime],[DigitalSignatureDigestValue],[DigitalSignatureSignatureValue],[DigitalSignatureX509Data],[LastModifiedDate],[LastModifiedByUid],[PatientUid],[ServiceSiteUid])
SELECT [eRxOutboundUid],[ProviderUid],[PharmacyClearinghouseUid],[PharmacyUid],[VisitUid],[RelVisitMedicationUid],[SIGDetailUid],[eRxMessageTypeUid],[MessageXML],[MessageSent],[SendResponse],[Processed],[Successful],[RelatesToMessageID],[SubmitByUid],CONVERT(nvarchar(max), [RequestXML]),[RequestNCPDP],CONVERT(nvarchar(max), [ResponseXML]),[ResponseNCPDP],[ProcessStatus],[TransmissionConfigurationUid],[OrderNumber],[OrderDateTime],[DigitalSignatureDigestValue],[DigitalSignatureSignatureValue],[DigitalSignatureX509Data],[LastModifiedDate],[LastModifiedByUid],[PatientUid],[ServiceSiteUid]
FROM [eRxOutbound]

DROP TABLE [eRxOutbound]

exec  sp_rename 'migtemp_eRxOutbound', 'eRxOutbound'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_FaxQueue]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_FaxQueue](
	[FaxQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[TransactionID] [decimal](18, 0) NULL,
	[StatusID] [int] NULL,
	[Submitted] [bit] NULL,
	[Message] [varchar](max) NULL,
	[StatusDetail] [varchar](max) NULL,
	[FaxNumber] [varchar](15) NULL,
	[RetryFaxNumber] [varchar](15) NULL,
	[FaxType] [varchar](10) NULL,
	[FaxSubType] [varchar](20) NULL,
	[FaxReceipientName] [varchar](500) NULL,
	[MsgReceipient] [uniqueidentifier] NULL,
	[SubmitTime] [datetime] NULL,
	[CompletionTime] [datetime] NULL,
	[Duration] [int] NULL,
	[Contact] [varchar](100) NULL,
	[JobID] [varchar](20) NULL,
	[PagesSent] [smallint] NULL,
	[PagesSubmitted] [smallint] NULL,
	[Subject] [varchar](200) NULL,
	[Units] [decimal](18, 2) NULL,
	[CostPerUnit] [decimal](18, 2) NULL,
	[PageSize] [varchar](10) NULL,
	[SenderCSID] [varchar](20) NULL,
	[RemoteCSID] [varchar](20) NULL,
	[PageOrientation] [varchar](20) NULL,
	[PageResolution] [varchar](20) NULL,
	[RenderingQuality] [varchar](20) NULL,
	[PageHeader] [varchar](500) NULL,
	[RetriesToPerform] [smallint] NULL,
	[TrialsPerformed] [smallint] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[Parameters] [varchar](max) NULL,
	[Parameters2] [varchar](500) NULL,
	[SequentialNumber] [int] NULL,
	[FaxCoverSheetUid] [uniqueidentifier] NULL,
	[XDN] [varchar](50) NULL,
	[ServicedBy] [varchar](20) NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[UserUid] [uniqueidentifier] NULL,
	[FaxServerUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FaxQueue'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FaxQueue'

ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_FaxQueueUid]  DEFAULT (newid()) FOR [FaxQueueUid]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_TransactionID]  DEFAULT ((0)) FOR [TransactionID]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_StatusID]  DEFAULT ((-1)) FOR [StatusID]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_Submitted]  DEFAULT ((0)) FOR [Submitted]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_SequentialNumber]  DEFAULT ((-1)) FOR [SequentialNumber]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_FaxQueue
INSERT [migtemp_FaxQueue]([FaxQueueUid],[TransactionID],[StatusID],[Submitted],[Message],[FaxNumber],[RetryFaxNumber],[FaxType],[FaxSubType],[FaxReceipientName],[MsgReceipient],[SubmitTime],[CompletionTime],[Duration],[Contact],[JobID],[PagesSent],[PagesSubmitted],[Subject],[Units],[CostPerUnit],[PageSize],[SenderCSID],[RemoteCSID],[PageOrientation],[PageResolution],[RenderingQuality],[PageHeader],[RetriesToPerform],[TrialsPerformed],[VisitUid],[Parameters],[Parameters2],[SequentialNumber],[FaxCoverSheetUid],[XDN],[ServicedBy],[PatientUid],[UserUid],[FaxServerUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [FaxQueueUid],[TransactionID],[StatusID],[Submitted],[Message],[FaxNumber],[RetryFaxNumber],[FaxType],[FaxSubType],[FaxReceipientName],[MsgReceipient],[SubmitTime],[CompletionTime],[Duration],[Contact],[JobID],[PagesSent],[PagesSubmitted],[Subject],[Units],[CostPerUnit],[PageSize],[SenderCSID],[RemoteCSID],[PageOrientation],[PageResolution],[RenderingQuality],[PageHeader],[RetriesToPerform],[TrialsPerformed],[VisitUid],[Parameters],[Parameters2],[SequentialNumber],[FaxCoverSheetUid],[XDN],[ServicedBy],[PatientUid],[UserUid],[FaxServerUid],[LastModifiedByUid],[LastModifiedDate]
FROM [FaxQueue]

DROP TABLE [FaxQueue]

exec  sp_rename 'migtemp_FaxQueue', 'FaxQueue'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_FeeScheduleFee]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_FeeScheduleFee](
	[FeeScheduleFeeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_FeeScheduleFee_FeeScheduleFeeUid]  DEFAULT (newid()),
	[FeeSchedulePeriodUid] [uniqueidentifier] NOT NULL,
	[Fee] [money] NULL,
	[IsInsurancePlanPhysician] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_IsInsurancePlanPhysician]  DEFAULT ((0)),
	[IsInsurancePlanOther] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_IsInsurancePlanOther]  DEFAULT ((0)),
	[FixedCopayAmount] [money] NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[InsurancePercent] [smallint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UserDefined]  DEFAULT ((1)),
	[GlobalPeriodDays] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_FeeListFee_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MultiplyUnits] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_MultiplyUnits]  DEFAULT ((1)),
	[ContractTypeCodeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[PayorPlanSetUid] [uniqueidentifier] NULL,
	[FamilyPlanning] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_FamilyPlanning]  DEFAULT ((0)),
	[UseProcedureTaxableOption] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseProcedureTaxableOption]  DEFAULT ((1)),
	[TaxableOption] [smallint] NOT NULL CONSTRAINT [DF_FeeScheduleFee_TaxableOption]  DEFAULT ((0)),
	[UseAlternateInsurancePlan] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseAlternateInsurancePlan]  DEFAULT ((0)),
	[UseBillTimeRule] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseBillTimeRule]  DEFAULT ((0)),
	[BillTimeRuleUid] [uniqueidentifier] NULL,
	[BillTimeRuleConfigData] [varchar](max) NULL,
	[UseFeeScheduleRule] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseFeeScheduleRule_1]  DEFAULT ((0)),
	[BillFeeRuleUid] [uniqueidentifier] NULL,
	[BillFeeRuleConfigData] [varchar](max) NULL,
	[BillTransportationRuleConfigData] [varchar](max) NULL,
	[UseTransportationRule] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseTransportationRule_1]  DEFAULT ((0)),
	[DoNotClaim] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_DoNotClaim]  DEFAULT ((0)),
	[ModifierRequired] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_ModifierRequired]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Fee list fees.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FeeScheduleFee'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FeeScheduleFee'


END
Truncate Table migtemp_FeeScheduleFee
INSERT [migtemp_FeeScheduleFee]([FeeScheduleFeeUid],[FeeSchedulePeriodUid],[Fee],[IsInsurancePlanPhysician],[IsInsurancePlanOther],[FixedCopayAmount],[ProcedureUid],[InsurancePercent],[Inactive],[UserDefined],[GlobalPeriodDays],[LastModifiedDate],[LastModifiedByUid],[MultiplyUnits],[ContractTypeCodeUid],[Notes],[PayorPlanSetUid],[FamilyPlanning],[UseProcedureTaxableOption],[TaxableOption],[UseAlternateInsurancePlan],[UseBillTimeRule],[BillTimeRuleUid],[BillTimeRuleConfigData],[UseFeeScheduleRule],[BillFeeRuleUid],[BillFeeRuleConfigData],[BillTransportationRuleConfigData],[UseTransportationRule],[DoNotClaim])
SELECT [FeeScheduleFeeUid],[FeeSchedulePeriodUid],[Fee],[IsInsurancePlanPhysician],[IsInsurancePlanOther],[FixedCopayAmount],[ProcedureUid],[InsurancePercent],[Inactive],[UserDefined],[GlobalPeriodDays],[LastModifiedDate],[LastModifiedByUid],[MultiplyUnits],[ContractTypeCodeUid],[Notes],[PayorPlanSetUid],[FamilyPlanning],[UseProcedureTaxableOption],[TaxableOption],[UseAlternateInsurancePlan],[UseBillTimeRule],[BillTimeRuleUid],[BillTimeRuleConfigData],[UseFeeScheduleRule],[BillFeeRuleUid],[BillFeeRuleConfigData],[BillTransportationRuleConfigData],[UseTransportationRule],[DoNotClaim]
FROM [FeeScheduleFee]

DROP TABLE [FeeScheduleFee]

exec  sp_rename 'migtemp_FeeScheduleFee', 'FeeScheduleFee'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HIEPatient]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[HIEPatient](
	[HIEPatientUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[PatientId] [nvarchar](max) NOT NULL,
	[DocumentList] [varchar](max) NULL,
	[DocumentListDate] [datetime] NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [HIEPatient] ADD  CONSTRAINT [DF_HIEPatient_UserDefined]  DEFAULT ((0)) FOR [UserDefined]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HIEPatientDocument]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[HIEPatientDocument](
	[HIEPatientDocumentUid] [uniqueidentifier] NOT NULL,
	[HIEPatientUid] [uniqueidentifier] NOT NULL,
	[DocumentId] [varchar](max) NOT NULL,
	[DocumentStatusUid] [uniqueidentifier] NOT NULL,
	[AttachmentUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [HIEPatientDocument] ADD  CONSTRAINT [DF_HIEPatientDocument_UserDefined]  DEFAULT ((0)) FOR [UserDefined]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ImmunizationHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ImmunizationHistory](
	[ImmunizationHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ImmunizationHistory_ImmunizationHistoryUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VaccineUid] [uniqueidentifier] NULL,
	[VaccineName] [varchar](255) NULL,
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[TypeofVaccineName] [varchar](255) NULL,
	[VaccineDose] [varchar](50) NULL,
	[VaccineUnits] [varchar](60) NULL,
	[AdministeredDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[AdministeredDateName] [varchar](255) NULL,
	[VaccineSiteUid] [uniqueidentifier] NULL,
	[VaccineSiteName] [varchar](255) NULL,
	[VaccineRouteUid] [uniqueidentifier] NULL,
	[VaccineRouteName] [varchar](255) NULL,
	[VaccineFundingSourceUid] [uniqueidentifier] NULL,
	[VaccineFundingSourceName] [varchar](255) NULL,
	[VFCEligibilityUid] [uniqueidentifier] NULL,
	[DateOnVIS] [date] NULL,
	[DateOnVISName] [varchar](255) NULL,
	[ExpirationDate] [date] NULL,
	[ExpirationDateName] [varchar](255) NULL,
	[VaccineMfrUid] [uniqueidentifier] NULL,
	[VaccineMfrName] [varchar](255) NULL,
	[VaccineLotNo] [varchar](255) NULL,
	[DateVISGiven] [date] NULL,
	[DateVISGivenName] [varchar](255) NULL,
	[Initials] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[VaccinatorUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ImmzHistorySourceUid] [uniqueidentifier] NULL,
	[ImmzReminderRecallUid] [uniqueidentifier] NULL,
	[ImmzRefusalUid] [uniqueidentifier] NULL,
	[ImmzCompletionUid] [uniqueidentifier] NULL,
	[ImmzReactionUid] [uniqueidentifier] NULL,
	[PatientRefused] [bit] NOT NULL CONSTRAINT [DF_ImmunizationHistory_PatientRefused_1]  DEFAULT ((0)),
	[ImedicaAccessionNumber] [varchar](25) NULL,
	[OriginCreateTime] [datetime] NULL,
	[InactiveDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_ImmunizationHistory_IsDelete_1]  DEFAULT ((0)),
	[HistoryAdministeredDate] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[HistoryAdministeredFuzzyDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ImmunizationHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'AdministeredDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'AdministeredDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Orignal Create Time' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'OriginCreateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'InactiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'


END
Truncate Table migtemp_ImmunizationHistory
INSERT [migtemp_ImmunizationHistory]([ImmunizationHistoryUid],[PatientUid],[VaccineUid],[VaccineName],[TypeofVaccineUid],[TypeofVaccineName],[VaccineDose],[VaccineUnits],[AdministeredDateTime],[AdministeredDateName],[VaccineSiteUid],[VaccineSiteName],[VaccineRouteUid],[VaccineRouteName],[VaccineFundingSourceUid],[VaccineFundingSourceName],[VFCEligibilityUid],[DateOnVIS],[DateOnVISName],[ExpirationDate],[ExpirationDateName],[VaccineMfrUid],[VaccineMfrName],[VaccineLotNo],[DateVISGiven],[DateVISGivenName],[Initials],[Notes],[VisitProcedureUid],[VaccinatorUid],[VisitUid],[ImmzHistorySourceUid],[ImmzReminderRecallUid],[ImmzRefusalUid],[ImmzCompletionUid],[ImmzReactionUid],[PatientRefused],[ImedicaAccessionNumber],[OriginCreateTime],[InactiveDate],[IsDelete],[HistoryAdministeredDate],[HistoryAdministeredFuzzyDate],[LastModifiedByUid],[LastModifiedDate])
SELECT [ImmunizationHistoryUid],[PatientUid],[VaccineUid],[VaccineName],[TypeofVaccineUid],[TypeofVaccineName],[VaccineDose],[VaccineUnits],[AdministeredDateTime],[AdministeredDateName],[VaccineSiteUid],[VaccineSiteName],[VaccineRouteUid],[VaccineRouteName],[VaccineFundingSourceUid],[VaccineFundingSourceName],[VFCEligibilityUid],[DateOnVIS],[DateOnVISName],[ExpirationDate],[ExpirationDateName],[VaccineMfrUid],[VaccineMfrName],[VaccineLotNo],[DateVISGiven],[DateVISGivenName],[Initials],[Notes],[VisitProcedureUid],[VaccinatorUid],[VisitUid],[ImmzHistorySourceUid],[ImmzReminderRecallUid],[ImmzRefusalUid],[ImmzCompletionUid],[ImmzReactionUid],[PatientRefused],[ImedicaAccessionNumber],[OriginCreateTime],[InactiveDate],[IsDelete],CONVERT(nvarchar(max), [HistoryAdministeredDate]),[HistoryAdministeredFuzzyDate],[LastModifiedByUid],[LastModifiedDate]
FROM [ImmunizationHistory]

DROP TABLE [ImmunizationHistory]

exec  sp_rename 'migtemp_ImmunizationHistory', 'ImmunizationHistory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_IMO_ProblemIT_Attribute]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_IMO_ProblemIT_Attribute](
	[IMO_ProblemIT_AttributeUid] [uniqueidentifier] NOT NULL,
	[Range] [varchar](25) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IncludeInPatientDiagnosis] [bit] NULL,
	[DSMAxis] [varchar](25) NULL,
	[LifeLong] [bit] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_IMO_ProblemIT_Attribute'

ALTER TABLE [migtemp_IMO_ProblemIT_Attribute] ADD  CONSTRAINT [DF_IMO_ProblemIT_Attribute_IMO_ProblemIT_AttributeUid]  DEFAULT (newid()) FOR [IMO_ProblemIT_AttributeUid]
ALTER TABLE [migtemp_IMO_ProblemIT_Attribute] ADD  CONSTRAINT [DF_IMO_ProblemIT_Attribute_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_IMO_ProblemIT_Attribute] ADD  CONSTRAINT [DF_IMO_ProblemIT_Attribute_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_IMO_ProblemIT_Attribute] ADD  CONSTRAINT [DF_IMO_ProblemIT_Attribute_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_IMO_ProblemIT_Attribute
INSERT [migtemp_IMO_ProblemIT_Attribute]([IMO_ProblemIT_AttributeUid],[Range],[DisplayOrder],[IncludeInPatientDiagnosis],[DSMAxis],[Notes],[Inactive],[LastModifiedByUid],[LastModifiedDate])
SELECT [IMO_ProblemIT_AttributeUid],[Range],[DisplayOrder],[IncludeInPatientDiagnosis],[DSMAxis],[Notes],[Inactive],[LastModifiedByUid],[LastModifiedDate]
FROM [IMO_ProblemIT_Attribute]

DROP TABLE [IMO_ProblemIT_Attribute]

exec  sp_rename 'migtemp_IMO_ProblemIT_Attribute', 'IMO_ProblemIT_Attribute'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ProblemIT_Custom_Word_Index' AND COLUMN_NAME = 'WORD_TEXT')
ALTER TABLE [IMO_ProblemIT_Custom_Word_Index]  ALTER COLUMN [WORD_TEXT] nvarchar(75) NOT NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_SearchQualifier]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IMO_ProblemIT_SearchQualifier](
	[IMO_ProblemIT_SearchQualifierUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_IMO_ProblemIT_SearchQualifierUid]  DEFAULT (newid()),
	[Qualifier] [nvarchar](75) NOT NULL,
	[SearchOrder] [bigint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_UserDefined]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IMO_ProblemIT_SearchQualifier'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IMO_ProblemIT_SearchQualifier'


END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ProblemIT_SearchResult' AND COLUMN_NAME = 'LexCode')
ALTER TABLE [IMO_ProblemIT_SearchResult]  ALTER COLUMN [LexCode] bigint NOT NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListAnswerGroup]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListAnswerGroup](
	[AnswerGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAnswerGroup_AnswerGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAnswerGroup_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAnswerGroup_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UseDiseases] [bit] NOT NULL CONSTRAINT [DF_ListAnswerGroup_UseDiseases]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAnswerGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'answer group id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAnswerGroup', @level2type=N'COLUMN',@level2name=N'AnswerGroupUid'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelAnswerGroupAnswer' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAnswerGroup'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'answer group' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAnswerGroup'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAnswerGroup'


END
Truncate Table migtemp_ListAnswerGroup
INSERT [migtemp_ListAnswerGroup]([AnswerGroupUid],[ExternalID],[Name],[UserDefined],[Inactive],[Notes],[UseDiseases],[LastModifiedByUid],[LastModifiedDate])
SELECT [AnswerGroupUid],[ExternalID],[Name],[UserDefined],[Inactive],[Notes],[UseDiseases],[LastModifiedByUid],[LastModifiedDate]
FROM [ListAnswerGroup]

DROP TABLE [ListAnswerGroup]

exec  sp_rename 'migtemp_ListAnswerGroup', 'ListAnswerGroup'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListAppointmentStatus]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListAppointmentStatus](
	[AppointmentStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAppointmentStatus_AppointmentStatusUid]  DEFAULT (newid()),
	[AppointmentStatusTypeUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[Color] [int] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_Color]  DEFAULT ((0)),
	[ShowOnSchedule] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_ShowOnSchedule]  DEFAULT ((1)),
	[ShowOnDesktop] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_ShowOnDesktop]  DEFAULT ((1)),
	[ChargeCancelationFee] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_ChargeCancelationFee]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_UserDefined]  DEFAULT ((1)),
	[IsCanceledStatus] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_IsCanceledStatus]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetSortBy', @value=N'ASC' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentStatus', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentStatus', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Appointment statuses.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentStatus'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentStatus'


END
Truncate Table migtemp_ListAppointmentStatus
INSERT [migtemp_ListAppointmentStatus]([AppointmentStatusUid],[AppointmentStatusTypeUid],[ExternalID],[Inactive],[Name],[DisplayOrder],[Notes],[Color],[ShowOnSchedule],[ShowOnDesktop],[LastModifiedDate],[LastModifiedByUid],[UserDefined],[IsCanceledStatus])
SELECT [AppointmentStatusUid],[AppointmentStatusTypeUid],[ExternalID],[Inactive],[Name],[DisplayOrder],[Notes],[Color],[ShowOnSchedule],[ShowOnDesktop],[LastModifiedDate],[LastModifiedByUid],[UserDefined],[IsCanceledStatus]
FROM [ListAppointmentStatus]

DROP TABLE [ListAppointmentStatus]

exec  sp_rename 'migtemp_ListAppointmentStatus', 'ListAppointmentStatus'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListAppointmentType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListAppointmentType](
	[AppointmentTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAppointmentType_AppointmentTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_IsEnabled]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Color] [char](6) NOT NULL CONSTRAINT [DF_ListAppointmentType_Color]  DEFAULT ('FFFFFF'),
	[Duration] [int] NOT NULL CONSTRAINT [DF_ListAppointmentType_Duration]  DEFAULT ((5)),
	[Blocking] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_IsBlocking]  DEFAULT ((0)),
	[AllowBlockOverride] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_Warn]  DEFAULT ((0)),
	[AllowPatientRequest] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_AllowPatientRequest]  DEFAULT ((0)),
	[ChargeCancelationProcedureUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAppointmentType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[GroupVisit] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentType_GroupVisit]  DEFAULT ((0)),
	[Description] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Color'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Duration'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Blocking'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Only applied if this is a Blocking appointment type.  If set to true, warns the user but still let them schedule an appointment.  If set to false, do not allow user to schedule an appointment.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'AllowBlockOverride'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Appointment types.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType'


END
Truncate Table migtemp_ListAppointmentType
INSERT [migtemp_ListAppointmentType]([AppointmentTypeUid],[ExternalID],[Inactive],[Name],[Notes],[Color],[Duration],[Blocking],[AllowBlockOverride],[AllowPatientRequest],[LastModifiedDate],[LastModifiedByUid],[GroupVisit],[Description])
SELECT [AppointmentTypeUid],[ExternalID],[Inactive],[Name],[Notes],[Color],[Duration],[Blocking],[AllowBlockOverride],[AllowPatientRequest],[LastModifiedDate],[LastModifiedByUid],[GroupVisit],[Description]
FROM [ListAppointmentType]

DROP TABLE [ListAppointmentType]

exec  sp_rename 'migtemp_ListAppointmentType', 'ListAppointmentType'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListBatchProcessType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListBatchProcessType](
	[BatchProcessTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ConfigurationAQN] [varchar](255) NULL,
	[ProcessAQN] [varchar](255) NULL,
	[SummaryXSLT] [xml] NULL,
	[SummaryRouting] [varchar](255) NULL,
	[DetailXSLT] [xml] NULL,
	[DetailRouting] [varchar](255) NULL,
	[MaxConcurrency] [smallint] NOT NULL CONSTRAINT [DF_ListBatchProcessType_MaxConcurrency]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListBatchProcessType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListBatchProcessType_UserDefined]  DEFAULT ((1)),
	[AutoStartDetail] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_AutoStartDetail]  DEFAULT ((0)),
	[Hide] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_Hide]  DEFAULT ((1)),
	[AllowIsCached] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_AllowIsCached]  DEFAULT ((0))
) ON [PRIMARY]



END
Truncate Table migtemp_ListBatchProcessType
INSERT [migtemp_ListBatchProcessType]([BatchProcessTypeUid],[ExternalID],[Name],[Notes],[ConfigurationAQN],[ProcessAQN],[SummaryXSLT],[SummaryRouting],[DetailXSLT],[DetailRouting],[MaxConcurrency],[Inactive],[LastModifiedByUid],[LastModifiedDate],[UserDefined],[AutoStartDetail],[Hide])
SELECT [BatchProcessTypeUid],[ExternalID],[Name],[Notes],[ConfigurationAQN],[ProcessAQN],CONVERT(nvarchar(max), [SummaryXSLT]),[SummaryRouting],CONVERT(nvarchar(max), [DetailXSLT]),[DetailRouting],[MaxConcurrency],[Inactive],[LastModifiedByUid],[LastModifiedDate],[UserDefined],[AutoStartDetail],[Hide]
FROM [ListBatchProcessType]

DROP TABLE [ListBatchProcessType]

exec  sp_rename 'migtemp_ListBatchProcessType', 'ListBatchProcessType'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListCaseType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListCaseType](
	[CaseTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCaseType_CaseTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCaseType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCaseType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCaseType_LastModifiedDate]  DEFAULT (getutcdate()),
	[DisplayAlertsOnVisits] [bit] NOT NULL CONSTRAINT [DisplayAlertsOnVisitsNoNull]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'CaseTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'ListCaseTypeModule;ListCaseTypePhase' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'case type' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType'


END
Truncate Table migtemp_ListCaseType
INSERT [migtemp_ListCaseType]([CaseTypeUid],[ExternalID],[Inactive],[Name],[Notes],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [CaseTypeUid],[ExternalID],[Inactive],[Name],[Notes],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListCaseType]

DROP TABLE [ListCaseType]

exec  sp_rename 'migtemp_ListCaseType', 'ListCaseType'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListDecileCQM]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListDecileCQM](
	[DecileCQMUID] [uniqueidentifier] NOT NULL CONSTRAINT [df_ListDecileCQM_DecileCQMUID]  DEFAULT (newsequentialid()),
	[MeasureName] [varchar](max) NOT NULL,
	[Measure_ID] [varchar](20) NOT NULL,
	[CQMUID] [uniqueidentifier] NOT NULL,
	[CQMYear] [varchar](7) NOT NULL,
	[Decile3_Low] [numeric](6, 3) NULL,
	[Decile3_High] [numeric](6, 3) NULL,
	[Decile4_Low] [numeric](6, 3) NULL,
	[Decile4_High] [numeric](6, 3) NULL,
	[Decile5_Low] [numeric](6, 3) NULL,
	[Decile5_High] [numeric](6, 3) NULL,
	[Decile6_Low] [numeric](6, 3) NULL,
	[Decile6_High] [numeric](6, 3) NULL,
	[Decile7_Low] [numeric](6, 3) NULL,
	[Decile7_High] [numeric](6, 3) NULL,
	[Decile8_Low] [numeric](6, 3) NULL,
	[Decile8_High] [numeric](6, 3) NULL,
	[Decile9_Low] [numeric](6, 3) NULL,
	[Decile9_High] [numeric](6, 3) NULL,
	[Decile10_Low] [numeric](6, 3) NULL,
	[Decile10_High] [numeric](6, 3) NULL,
	[Inactive] [bit] NULL CONSTRAINT [df_ListDecileCQM_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [df_ListDecileCQM_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NULL CONSTRAINT [df_ListDecileCQM_UserDefined]  DEFAULT ((0)),
	[LastModifiedByUID] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListFaxServer]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListFaxServer](
	[FaxServerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFaxServer_FaxServerUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](10) NOT NULL,
	[UserName] [varchar](100) NULL,
	[Password] [varchar](100) NULL,
	[DocType] [varchar](10) NULL,
	[DocName] [varchar](100) NULL,
	[DocData] [varbinary](max) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFaxServer_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFaxServer_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFaxServer_LastModifiedDate]  DEFAULT (getutcdate()),
	[AQN] [varchar](512) NULL,
	[ServiceURL] [varchar](200) NULL,
	[OrderActionTemplateXml] [xml] NULL,
	[OutboundFolder] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFaxServer'


END
Truncate Table migtemp_ListFaxServer
INSERT [migtemp_ListFaxServer]([FaxServerUid],[ExternalID],[Name],[UserName],[Password],[DocType],[DocName],[DocData],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate],[AQN],[ServiceURL],[OrderActionTemplateXml])
SELECT [FaxServerUid],[ExternalID],[Name],[UserName],[Password],[DocType],[DocName],[DocData],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate],[AQN],[ServiceURL],CONVERT(nvarchar(max), [OrderActionTemplateXml])
FROM [ListFaxServer]

DROP TABLE [ListFaxServer]

exec  sp_rename 'migtemp_ListFaxServer', 'ListFaxServer'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'iforeignkey' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Cache.Required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelFilterNotification' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ExcludeRowIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', N'COLUMN',N'JobScheduleUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.ExcludeRowIfValueSet', @value=N'is not null' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter', @level2type=N'COLUMN',@level2name=N'JobScheduleUid'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListFormLayout]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListFormLayout](
	[FormLayoutUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListFormLayout_FormLayoutUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormLayout_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormLayout_UserDefined]  DEFAULT ((1)),
	[UIControlUid] [uniqueidentifier] NOT NULL,
	[Data] [xml] NULL,
	[RequireDataTag] [bit] NOT NULL CONSTRAINT [DF_ListFormLayout_RequireDataTag]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[AllowMulti] [bit] NOT NULL CONSTRAINT [DF_ListFormLayout_AllowMulti]  DEFAULT ((0)),
	[TitleDefinition] [varchar](2048) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormLayout_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
Truncate Table migtemp_ListFormLayout
INSERT [migtemp_ListFormLayout]([FormLayoutUid],[ExternalID],[Name],[Inactive],[Notes],[UserDefined],[UIControlUid],[Data],[RequireDataTag],[LicenseCode],[AllowMulti],[TitleDefinition],[LastModifiedByUid],[LastModifiedDate])
SELECT [FormLayoutUid],[ExternalID],[Name],[Inactive],[Notes],[UserDefined],[UIControlUid],CONVERT(nvarchar(max), [Data]),[RequireDataTag],[LicenseCode],[AllowMulti],[TitleDefinition],[LastModifiedByUid],[LastModifiedDate]
FROM [ListFormLayout]

DROP TABLE [ListFormLayout]

exec  sp_rename 'migtemp_ListFormLayout', 'ListFormLayout'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListHIPAAReleaseInfo]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListHIPAAReleaseInfo](
	[HIPAAReleaseInfoUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_HIPAAReleaseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListHIPAAReleaseInfo', @level2type=N'COLUMN',@level2name=N'UserDefined'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListMedicalServicesType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListMedicalServicesType](
	[MedicalServicesTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicalServicesType_MedicalServicesTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicalServicesType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMedicalServicesType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMedicalServicesType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
Truncate Table migtemp_ListMedicalServicesType
INSERT [migtemp_ListMedicalServicesType]([MedicalServicesTypeUid],[ExternalID],[Inactive],[Name],[Notes],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [MedicalServicesTypeUid],[ExternalID],[Inactive],[Name],[Notes],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListMedicalServicesType]

DROP TABLE [ListMedicalServicesType]

exec  sp_rename 'migtemp_ListMedicalServicesType', 'ListMedicalServicesType'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListNameFormat]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListNameFormat](
	[NameFormatUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListNameFormat_NameFormatUid]  DEFAULT (newid()),
	[NameFormatTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNameFormat_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNameFormat_UserDefined]  DEFAULT ((1)),
	[NameFormat] [varchar](255) NULL,
	[TemplateProperties] [xml] NULL,
	[ValidationType] [smallint] NOT NULL CONSTRAINT [DF_ListNameFormat_ValidationType]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListNameFormat_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'ValidationType', @value=N'<None value="0" /><FileName value="1"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListNameFormat'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListNameFormatType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListNameFormatType](
	[NameFormatTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListNameFormatType_NameFormatTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[BusinessObject] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNameFormatType_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNameFormatType_UserDefined]  DEFAULT ((0)),
	[TypeProperties] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListNameFormatType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListProcedure](
	[ProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedure_ProcedureUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_Inactive]  DEFAULT ((0)),
	[Code] [varchar](30) NOT NULL,
	[MasterProcedureUid] [uniqueidentifier] NULL,
	[ProcedureCodeTypeUid] [uniqueidentifier] NULL,
	[ProcedureServiceTypeUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[ProcedureGroupUid] [uniqueidentifier] NULL,
	[ShortDescription] [varchar](75) NOT NULL,
	[LongDescription] [varchar](1024) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IsEM] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_IsEM]  DEFAULT ((0)),
	[DefaultDontClaim] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_DefaultDontClaim]  DEFAULT ((0)),
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[Unit] [int] NULL CONSTRAINT [DF_ListProcedure_Unit]  DEFAULT ((1)),
	[ProcedureModifier1Uid] [uniqueidentifier] NULL,
	[ProcedureModifier2Uid] [uniqueidentifier] NULL,
	[ProcedureModifier3Uid] [uniqueidentifier] NULL,
	[ProcedureModifier4Uid] [uniqueidentifier] NULL,
	[FDB_MEDID] [int] NULL,
	[NDC] [varchar](50) NULL,
	[NDCUnitMeasureUid] [uniqueidentifier] NULL,
	[GenerateObservationOrder] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_GenerateObservationOrder]  DEFAULT ((0)),
	[RevenueCode] [varchar](10) NULL,
	[Cost] [money] NULL,
	[NDCQuantity] [varchar](15) NULL,
	[UsePracticeTaxableOption] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_UsePracticeTaxableOption]  DEFAULT ((1)),
	[TaxableOption] [smallint] NOT NULL CONSTRAINT [DF_ListProcedure_TaxableOption]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[IncludeInPatientProcedure] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_IncludeInPatientProcedure]  DEFAULT ((1)),
	[ShortDescriptionChangedFromMaster] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_ShortDescriptionChangedFromMaster]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedure_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedure_LastModifiedDate]  DEFAULT (getutcdate()),
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[SnomedConceptID2] [varchar](50) NULL,
	[DescriptionUid2] [uniqueidentifier] NULL,
	[ImageResultsDirectlyAccessible] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_ImageResultsDirectlyAccessible]  DEFAULT ((0)),
	[PurchasedServiceCharge] [money] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL,
	[RequireDpn] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_RequireDpn]  DEFAULT ((0)),
	[SortToBottom] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_SortCodeAtEnd]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ShowInLabResults' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure', @level2type=N'COLUMN',@level2name=N'GenerateObservationOrder'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelProcedureSetProcedure;RelProcedureCategory;RelProcedureLaboratoryOrder;RelProcedurePanelProcedure;RelProcedureTypeofVaccine;VisitProcedure' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure'


END
Truncate Table migtemp_ListProcedure
INSERT [migtemp_ListProcedure]([ProcedureUid],[ExternalID],[Inactive],[Code],[MasterProcedureUid],[ProcedureCodeTypeUid],[ProcedureServiceTypeUid],[ServiceSiteUid],[ProcedureGroupUid],[ShortDescription],[LongDescription],[Notes],[IsEM],[DefaultDontClaim],[EffectiveDate],[ExpirationDate],[Unit],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[FDB_MEDID],[NDC],[NDCUnitMeasureUid],[GenerateObservationOrder],[RevenueCode],[Cost],[NDCQuantity],[UsePracticeTaxableOption],[TaxableOption],[SnomedConceptID],[LOINCUid],[DescriptionUid],[IncludeInPatientProcedure],[ShortDescriptionChangedFromMaster],[UserDefined],[LastModifiedByUid],[LastModifiedDate],[HistoryGroupUid],[SnomedConceptID2],[DescriptionUid2],[ImageResultsDirectlyAccessible],[PurchasedServiceCharge],[MedicalServicesProviderUid],[RequireDpn])
SELECT [ProcedureUid],[ExternalID],[Inactive],[Code],[MasterProcedureUid],[ProcedureCodeTypeUid],[ProcedureServiceTypeUid],[ServiceSiteUid],[ProcedureGroupUid],[ShortDescription],[LongDescription],[Notes],[IsEM],[DefaultDontClaim],[EffectiveDate],[ExpirationDate],[Unit],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[FDB_MEDID],[NDC],[NDCUnitMeasureUid],[GenerateObservationOrder],[RevenueCode],[Cost],[NDCQuantity],[UsePracticeTaxableOption],[TaxableOption],[SnomedConceptID],[LOINCUid],[DescriptionUid],[IncludeInPatientProcedure],[ShortDescriptionChangedFromMaster],[UserDefined],[LastModifiedByUid],[LastModifiedDate],[HistoryGroupUid],[SnomedConceptID2],[DescriptionUid2],[ImageResultsDirectlyAccessible],[PurchasedServiceCharge],[MedicalServicesProviderUid],[RequireDpn]
FROM [ListProcedure]

DROP TABLE [ListProcedure]

exec  sp_rename 'migtemp_ListProcedure', 'ListProcedure'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ExcludeRowIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ListProductParameter', N'COLUMN',N'ParameterName'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ExcludeRowIfValueSet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProductParameter', @level2type=N'COLUMN',@level2name=N'ParameterName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ExcludeRowIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ListProductParameter', N'COLUMN',N'ParameterName'))
EXEC sys.sp_addextendedproperty @name=N'Replication.ExcludeRowIfValueSet', @value=N'CommonDatabase;Update;Weekly Updates' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProductParameter', @level2type=N'COLUMN',@level2name=N'ParameterName'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListQuestion]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListQuestion](
	[QuestionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListQuestion_QuestionUid]  DEFAULT (newid()),
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[AnswerGroupUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListQuestion_Inactive]  DEFAULT ((0)),
	[Name] [varchar](255) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListQuestion_UserDefined]  DEFAULT ((1)),
	[Header] [varchar](15) NULL,
	[Colwidth] [smallint] NULL,
	[AllowMultiple] [bit] NOT NULL CONSTRAINT [DF_ListQuestion_AllowMultiple]  DEFAULT ((0)),
	[RequiresAnswer] [bit] NOT NULL CONSTRAINT [DF_ListQuestion_RequiresAnswer]  DEFAULT ((0)),
	[SelectionTypeID] [smallint] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListQuestion_DisplayOrder]  DEFAULT ((0)),
	[FDB_HIC_SEQN] [int] NULL,
	[Notes] [varchar](max) NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[FDBIDType] [varchar](20) NULL,
	[UNII] [varchar](255) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[HL7Code] [varchar](50) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListQuestion_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'ListHistoryGroup' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListQuestion'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListQuestion'


END
Truncate Table migtemp_ListQuestion
INSERT [migtemp_ListQuestion]([QuestionUid],[HistoryGroupUid],[AnswerGroupUid],[DiseaseUid],[ExternalID],[Inactive],[Name],[UserDefined],[Header],[Colwidth],[AllowMultiple],[RequiresAnswer],[SelectionTypeID],[DisplayOrder],[FDB_HIC_SEQN],[Notes],[ClinicCenterOverride],[ProviderOverride],[FDBIDType],[UNII],[SnomedConceptID],[DescriptionUid],[HL7Code],[LOINCUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [QuestionUid],[HistoryGroupUid],[AnswerGroupUid],[DiseaseUid],[ExternalID],[Inactive],[Name],[UserDefined],[Header],[Colwidth],[AllowMultiple],[RequiresAnswer],[SelectionTypeID],[DisplayOrder],[FDB_HIC_SEQN],[Notes],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[FDBIDType],[UNII],[SnomedConceptID],[DescriptionUid],[HL7Code],[LOINCUid],[LastModifiedByUid],[LastModifiedDate]
FROM [ListQuestion]

DROP TABLE [ListQuestion]

exec  sp_rename 'migtemp_ListQuestion', 'ListQuestion'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Cache.Required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Cache.Required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'Permission'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'Permission'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'Permission'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'Permission'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListSpecialty]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListSpecialty](
	[SpecialtyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSpecialty_SpecialtyUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSpecialty_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSpecialty_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSpecialty_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListSpecialty', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Provider specialties' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListSpecialty'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListSpecialty'


END
Truncate Table migtemp_ListSpecialty
INSERT [migtemp_ListSpecialty]([SpecialtyUid],[ExternalID],[Inactive],[Name],[ANSICode],[Notes],[LastModifiedByUid],[LastModifiedDate],[UserDefined])
SELECT [SpecialtyUid],[ExternalID],[Inactive],[Name],[ANSICode],[Notes],[LastModifiedByUid],[LastModifiedDate],[UserDefined]
FROM [ListSpecialty]

DROP TABLE [ListSpecialty]

exec  sp_rename 'migtemp_ListSpecialty', 'ListSpecialty'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'iforeignkey' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'UserGroupMember' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListUserSetting]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListUserSetting](
	[UserSettingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListUserSetting_UserSettingUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[ClinicalNoteTypes] [xml](CONTENT [dbo].[UidList]) NULL,
	[FormattingTemplateUid] [uniqueidentifier] NULL,
	[NoteSingleColumn] [nchar](10) NULL,
	[MinWidth] [int] NOT NULL CONSTRAINT [DF_ListUserSetting_MinWidth_1]  DEFAULT ((100)),
	[FontSize] [float] NOT NULL CONSTRAINT [DF_ListUserSetting_FontSize_1]  DEFAULT ((10.0)),
	[UseNewOPSRPN] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_UseNewOPSRPN_1]  DEFAULT ((1)),
	[AttachmentAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientDemographicAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[NoteAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[AppointmentNoteAddIn] [xml] NULL,
	[VitalsAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientToolbarAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[DesktopAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[AppointmentAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[SuperbillChargeProcessorAddInUid] [uniqueidentifier] NULL,
	[ServiceProcedureAddInUid] [uniqueidentifier] NULL,
	[VisitSaveAddInUid] [uniqueidentifier] NULL,
	[PatientDemographicsPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[NotePrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[OPSPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[RPNPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[JobEngineStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_JobEngineStatus_1]  DEFAULT ((0)),
	[MasterServerStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MasterServerStatus]  DEFAULT ((0)),
	[CacheServerStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CacheServerStatus_1]  DEFAULT ((0)),
	[AutoCapitalization] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoCapitalization_1]  DEFAULT ((1)),
	[AutoComplete] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoComplete_1]  DEFAULT ((1)),
	[TryDelete] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_TryDelete_1]  DEFAULT ((1)),
	[VoiceRecording] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_VoiceRecording_1]  DEFAULT ((1)),
	[InkInput] [smallint] NOT NULL CONSTRAINT [DF_ListUserSetting_InkInput_1]  DEFAULT ((0)),
	[DockingStyle] [smallint] NOT NULL CONSTRAINT [DF_ListUserSetting_DockingStyle_1]  DEFAULT ((0)),
	[StartupSound] [varchar](255) NULL,
	[SelectionColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[RequiredColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[PatientInputColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[BorderColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[AllowCPO] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AllowCPO_1]  DEFAULT ((0)),
	[AutoCheckCPOGeneration] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoCheckCPOGeneration]  DEFAULT ((0)),
	[WarnOnCancelNote] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_WarnOnCancelNote_1]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserSetting_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[MaximizeForms] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MaximizeForms]  DEFAULT ((0)),
	[BackgroundSave] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_BackgroundSave]  DEFAULT ((1)),
	[UseNewOPS] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_UseNewOPS]  DEFAULT ((0)),
	[DisplayPrinterDialog] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_DisplayRxPrinterDialog]  DEFAULT ((0)),
	[ProcessHMRulesOnNoteSave] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_ProcessHMRulesOnNoteSave_1]  DEFAULT ((1)),
	[CheckoutPlanTemplateUid] [uniqueidentifier] NULL,
	[RPNPrintButtonUid] [uniqueidentifier] NULL,
	[OPSPrintButtonUid] [uniqueidentifier] NULL,
	[RxConsentFormattingTemplateUid] [uniqueidentifier] NULL,
	[RxConsentAttachmentTypeUid] [uniqueidentifier] NULL,
	[RxConsentMedication] [xml](CONTENT [dbo].[UidList]) NULL,
	[StandardHistoryDisplay] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_StandardHistoryDisplay]  DEFAULT ((0)),
	[OtherSettings] [xml] NULL,
	[ShowRVUSearchingCPTUid] [uniqueidentifier] NULL,
	[IncludeEMInMFU] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_IncludeEMInMFU_1]  DEFAULT ((0)),
	[MultiWindow] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MultiWindow_1]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserSetting_LastModifiedDate]  DEFAULT (getutcdate()),
	[CheckoutEducationForm] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutEducationForm]  DEFAULT ((0)),
	[CheckoutVisitReceipt] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutVisitReceipt]  DEFAULT ((0)),
	[CheckoutSuperbill] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutSuperbill]  DEFAULT ((0)),
	[CheckoutUncheckAll] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutUncheckAll]  DEFAULT ((0)),
	[EditorFont] [xml] NULL,
	[FncCompleteNoteValidatorAddIns] [xml](CONTENT [dbo].[UidList]) NULL
) ON [PRIMARY]



END
Truncate Table migtemp_ListUserSetting
INSERT [migtemp_ListUserSetting]([UserSettingUid],[ExternalID],[Inactive],[Name],[ClinicCenterUid],[ClinicalNoteTypes],[FormattingTemplateUid],[NoteSingleColumn],[MinWidth],[FontSize],[UseNewOPSRPN],[AttachmentAddIns],[PatientDemographicAddIns],[NoteAddIns],[AppointmentNoteAddIn],[VitalsAddIns],[PatientToolbarAddIns],[DesktopAddIns],[AppointmentAddIns],[SuperbillChargeProcessorAddInUid],[ServiceProcedureAddInUid],[VisitSaveAddInUid],[PatientDemographicsPrint],[NotePrint],[OPSPrint],[RPNPrint],[PatientPrint],[JobEngineStatus],[MasterServerStatus],[CacheServerStatus],[AutoCapitalization],[AutoComplete],[TryDelete],[VoiceRecording],[InkInput],[DockingStyle],[StartupSound],[SelectionColor],[RequiredColor],[PatientInputColor],[BorderColor],[AllowCPO],[AutoCheckCPOGeneration],[WarnOnCancelNote],[UserDefined],[Notes],[MaximizeForms],[BackgroundSave],[UseNewOPS],[DisplayPrinterDialog],[ProcessHMRulesOnNoteSave],[CheckoutPlanTemplateUid],[RPNPrintButtonUid],[OPSPrintButtonUid],[RxConsentFormattingTemplateUid],[RxConsentAttachmentTypeUid],[RxConsentMedication],[StandardHistoryDisplay],[OtherSettings],[ShowRVUSearchingCPTUid],[IncludeEMInMFU],[MultiWindow],[LastModifiedByUid],[LastModifiedDate],[CheckoutEducationForm],[CheckoutVisitReceipt],[CheckoutSuperbill],[CheckoutUncheckAll])
SELECT [UserSettingUid],[ExternalID],[Inactive],[Name],[ClinicCenterUid],CONVERT(nvarchar(max), [ClinicalNoteTypes]),[FormattingTemplateUid],[NoteSingleColumn],[MinWidth],[FontSize],[UseNewOPSRPN],CONVERT(nvarchar(max), [AttachmentAddIns]),CONVERT(nvarchar(max), [PatientDemographicAddIns]),CONVERT(nvarchar(max), [NoteAddIns]),CONVERT(nvarchar(max), [AppointmentNoteAddIn]),CONVERT(nvarchar(max), [VitalsAddIns]),CONVERT(nvarchar(max), [PatientToolbarAddIns]),CONVERT(nvarchar(max), [DesktopAddIns]),CONVERT(nvarchar(max), [AppointmentAddIns]),[SuperbillChargeProcessorAddInUid],[ServiceProcedureAddInUid],[VisitSaveAddInUid],CONVERT(nvarchar(max), [PatientDemographicsPrint]),CONVERT(nvarchar(max), [NotePrint]),CONVERT(nvarchar(max), [OPSPrint]),CONVERT(nvarchar(max), [RPNPrint]),CONVERT(nvarchar(max), [PatientPrint]),[JobEngineStatus],[MasterServerStatus],[CacheServerStatus],[AutoCapitalization],[AutoComplete],[TryDelete],[VoiceRecording],[InkInput],[DockingStyle],[StartupSound],CONVERT(nvarchar(max), [SelectionColor]),CONVERT(nvarchar(max), [RequiredColor]),CONVERT(nvarchar(max), [PatientInputColor]),CONVERT(nvarchar(max), [BorderColor]),[AllowCPO],[AutoCheckCPOGeneration],[WarnOnCancelNote],[UserDefined],[Notes],[MaximizeForms],[BackgroundSave],[UseNewOPS],[DisplayPrinterDialog],[ProcessHMRulesOnNoteSave],[CheckoutPlanTemplateUid],[RPNPrintButtonUid],[OPSPrintButtonUid],[RxConsentFormattingTemplateUid],[RxConsentAttachmentTypeUid],CONVERT(nvarchar(max), [RxConsentMedication]),[StandardHistoryDisplay],CONVERT(nvarchar(max), [OtherSettings]),[ShowRVUSearchingCPTUid],[IncludeEMInMFU],[MultiWindow],[LastModifiedByUid],[LastModifiedDate],[CheckoutEducationForm],[CheckoutVisitReceipt],[CheckoutSuperbill],[CheckoutUncheckAll]
FROM [ListUserSetting]

DROP TABLE [ListUserSetting]

exec  sp_rename 'migtemp_ListUserSetting', 'ListUserSetting'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_MedicalServicesProvider]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_MedicalServicesProvider](
	[CorporationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[MedicalServicesTypeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'True' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_MedicalServicesProvider'
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'!FK_UserPRM_Provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_MedicalServicesProvider'

ALTER TABLE [migtemp_MedicalServicesProvider] ADD  CONSTRAINT [DF_MedicalServicesProvider_CorporationUid]  DEFAULT (newid()) FOR [CorporationUid]
ALTER TABLE [migtemp_MedicalServicesProvider] ADD  CONSTRAINT [DF_MedicalServicesProvider_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_MedicalServicesProvider] ADD  CONSTRAINT [DF_MedicalServicesProvider_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_MedicalServicesProvider
INSERT [migtemp_MedicalServicesProvider]([CorporationUid],[ExternalID],[Inactive],[MedicalServicesTypeUid],[Notes],[LastModifiedByUid],[LastModifiedDate])
SELECT [CorporationUid],[ExternalID],[Inactive],[MedicalServicesTypeUid],[Notes],[LastModifiedByUid],[LastModifiedDate]
FROM [MedicalServicesProvider]

DROP TABLE [MedicalServicesProvider]

exec  sp_rename 'migtemp_MedicalServicesProvider', 'MedicalServicesProvider'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Message]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Message](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Message_MessageUid]  DEFAULT (newid()),
	[ParentMessageUid] [uniqueidentifier] NULL,
	[CreatedByUid] [uniqueidentifier] NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[MessageTypeUid] [uniqueidentifier] NOT NULL,
	[MessageSubTypeUid] [uniqueidentifier] NULL,
	[Header] [varchar](8000) NULL,
	[MessageUrgencyUid] [uniqueidentifier] NULL,
	[MessageStatusUid] [uniqueidentifier] NULL,
	[CreatedDate] [date] NOT NULL CONSTRAINT [DF_Message_CreatedDate]  DEFAULT (getdate()),
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_Message_DateCreated]  DEFAULT (getutcdate()),
	[DateToBeCompleted] [datetime] NULL,
	[AutoComplete] [bit] NOT NULL CONSTRAINT [DF_Message_AutoComplete]  DEFAULT ((0)),
	[DateCompleted] [datetime] NULL,
	[LastReadByUid] [uniqueidentifier] NULL,
	[CompletedByUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[StrikeOut] [bit] NOT NULL CONSTRAINT [DF_Message_StrikeOut_1]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Msgs_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageDataXML] [xml](CONTENT [dbo].[MessageData]) NULL,
	[FirstReadDate] [datetime] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the guid of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the guid of the message that is the parent. This is used when a message is split into multiple messages. Each of the new messages will have its parent set to the message from which it originated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'ParentMessageUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the person that created the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the patient with whom  the message is associated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the type of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the string used to display the message in a list' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'Header'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the urgency of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageUrgencyUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the status of the message. A message that is completed can be archived.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageStatusUid'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'DateCreated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the message was created' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'DateCreated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the message was completed' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CompletedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores message envelopes. The context of a message is stored in a separate table, e.g. MessageTask or MessageRx' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'DateCompleted,LastReadByUid,CompletedByUid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.Lock', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_Message_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'


END
Truncate Table migtemp_Message
INSERT [migtemp_Message]([MessageUid],[ParentMessageUid],[CreatedByUid],[PersonUid],[MessageTypeUid],[MessageSubTypeUid],[Header],[MessageUrgencyUid],[MessageStatusUid],[CreatedDate],[CreatedDateTime],[DateToBeCompleted],[AutoComplete],[DateCompleted],[LastReadByUid],[CompletedByUid],[VisitUid],[StrikeOut],[LastModifiedDate],[LastModifiedByUid],[MessageDataXML],[FirstReadDate])
SELECT [MessageUid],[ParentMessageUid],[CreatedByUid],[PersonUid],[MessageTypeUid],[MessageSubTypeUid],[Header],[MessageUrgencyUid],[MessageStatusUid],[CreatedDate],[CreatedDateTime],[DateToBeCompleted],[AutoComplete],[DateCompleted],[LastReadByUid],[CompletedByUid],[VisitUid],[StrikeOut],[LastModifiedDate],[LastModifiedByUid],CONVERT(nvarchar(max), [MessageDataXML]),[FirstReadDate]
FROM [Message]

DROP TABLE [Message]

exec  sp_rename 'migtemp_Message', 'Message'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MessageBackfillQueue]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MessageBackfillQueue](
	[MessageBackfillQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[HL7PartnerMessageUid] [uniqueidentifier] NULL,
	[HL7ActionTypeObjectUid] [uniqueidentifier] NULL,
	[TransmissionOutboundUid] [uniqueidentifier] NULL,
	[TransmissionType] [varchar](50) NULL,
	[ActionType] [varchar](50) NULL,
	[ObjectType] [varchar](50) NULL,
	[ObjectUid] [uniqueidentifier] NULL,
	[MessageContextXML] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ProcessingError] [bit] NOT NULL,
	[Status] [int] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MessageBackfillQueue'

ALTER TABLE [MessageBackfillQueue] ADD  CONSTRAINT [DF_MessageBackfillQueue_HL7BackfillQueue]  DEFAULT (newid()) FOR [MessageBackfillQueueUid]
ALTER TABLE [MessageBackfillQueue] ADD  CONSTRAINT [DF_MessageBackfillQueue_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [MessageBackfillQueue] ADD  CONSTRAINT [DF_MessageBackfillQueue_ProcessingError]  DEFAULT ((0)) FOR [ProcessingError]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_MU2_InterfaceDataMapping]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_MU2_InterfaceDataMapping](
	[InterfaceDataMappingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_InterfaceDataMappingUid]  DEFAULT (newid()),
	[Rootid] [varchar](40) NOT NULL,
	[Name] [varchar](100) NULL,
	[CCDCode] [varchar](25) NOT NULL,
	[PRMCode] [varchar](25) NULL,
	[CCDPrintName] [varchar](250) NULL,
	[IsDefault] [bit] NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_Default]  DEFAULT ((0)),
	[Inactive] [bit] NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[NCQMeasure] [varchar](10) NULL,
	[TopicIndicator] [varchar](50) NULL,
	[NQFNumber] [varchar](10) NULL,
	[DataElementName] [varchar](100) NULL,
	[Modifier] [varchar](25) NULL,
	[EndDate] [varchar](25) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_MU2Interface_DisplayOrder]  DEFAULT ((0)),
	[QRDASection] [varchar](50) NULL,
	[CQMVersion] [varchar](7) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_MU2_InterfaceDataMapping'


END
Truncate Table migtemp_MU2_InterfaceDataMapping
INSERT [migtemp_MU2_InterfaceDataMapping]([InterfaceDataMappingUid],[Rootid],[Name],[CCDCode],[PRMCode],[CCDPrintName],[IsDefault],[Inactive],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[NCQMeasure],[TopicIndicator],[NQFNumber],[DataElementName],[Modifier],[EndDate],[DisplayOrder],[QRDASection],[CQMVersion])
SELECT [InterfaceDataMappingUid],[Rootid],[Name],[CCDCode],[PRMCode],[CCDPrintName],[IsDefault],[Inactive],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[NCQMeasure],[TopicIndicator],[NQFNumber],[DataElementName],[Modifier],[EndDate],[DisplayOrder],[QRDASection],[CQMVersion]
FROM [MU2_InterfaceDataMapping]

DROP TABLE [MU2_InterfaceDataMapping]

exec  sp_rename 'migtemp_MU2_InterfaceDataMapping', 'MU2_InterfaceDataMapping'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ObservationValue]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ObservationValue](
	[ObservationValueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ObservationValue_ObservationValueUid]  DEFAULT (newid()),
	[ObservationOrderUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[LaboratoryUid] [uniqueidentifier] NULL,
	[ObservationItemUid] [uniqueidentifier] NULL,
	[Name] [varchar](100) NULL,
	[ObservationValue] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ObservationValue_DisplayOrder]  DEFAULT ((0)),
	[StringValue] [varchar](max) NULL,
	[IntegerValue] [int] NULL,
	[FloatValue] [float] NULL,
	[DateValue] [date] NULL,
	[DateTimeValue] [datetime] NULL,
	[MetricValue1] [decimal](14, 6) NULL,
	[MetricValue2] [decimal](14, 6) NULL,
	[MetricUnits] [varchar](25) NULL,
	[Modifier1Uid] [uniqueidentifier] NULL,
	[Modifier1Name] [varchar](50) NULL,
	[Modifier2Uid] [uniqueidentifier] NULL,
	[Modifier2Name] [varchar](50) NULL,
	[Modifier3Uid] [uniqueidentifier] NULL,
	[Modifier3Name] [varchar](50) NULL,
	[ReferenceRange] [varchar](255) NULL,
	[ResultStatusCode] [char](2) NULL,
	[AbnormalFlagCode] [char](2) NULL,
	[Notes] [varchar](max) NULL,
	[ResultStatusID] [smallint] NULL,
	[IsVitals] [bit] NOT NULL CONSTRAINT [DF_ObservationValue_IsVitals]  DEFAULT ((0)),
	[LaboratoryLocationUid] [uniqueidentifier] NULL,
	[ApproveProviderUid] [uniqueidentifier] NULL,
	[ApproveDate] [datetime] NULL,
	[ReferenceMin] [varchar](100) NULL,
	[ReferenceMax] [varchar](100) NULL,
	[EnteredByUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ObservationValue_LastModifiedDate]  DEFAULT (getutcdate()),
	[MeasurementUnits] [varchar](50) NULL,
	[StringMin] [varchar](100) NULL,
	[StringMax] [varchar](100) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'points to ObservationOrder table' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'ObservationOrderUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'lab id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Lab template item id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'ObservationItemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Sequence; reserved for the order change or item  is not defined in the ObservationItem table' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'result value' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'StringValue'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reference range: 3.8-19.8' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'ReferenceRange'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Result status code: "F": final' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusCode'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'"L": low; "H": high; blank: normal' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'AbnormalFlagCode'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 = Ordered; 2 = Pending; 3 = Pending\Collected; 4= Pending\Received; 5 = Pending\Performed; 6 = Pending\Resulted; 7 = Resulted; 8 = Resulted\Reviewed; 9 = Resulted\Approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetColumnReference', @value=N'<reference foreignTable="ListMisc" searchColumn="ListType" searchValue="ResultStatusID" valueColumn="Val" sortColumn="DisplayOrder" sortBy="ASC" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetOverrideValue', @value=N'<OverrideValues><OverrideValue oldValue="9" newValue="7" /></OverrideValues>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'getutcdate() for LastModifiedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'lab result detail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue'
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'ApproveProviderUid,ApproveDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_ObservationValue_ObservationOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationValue'


END
Truncate Table migtemp_ObservationValue
INSERT [migtemp_ObservationValue]([ObservationValueUid],[ObservationOrderUid],[VisitUid],[LaboratoryUid],[ObservationItemUid],[Name],[ObservationValue],[DisplayOrder],[StringValue],[IntegerValue],[FloatValue],[DateValue],[DateTimeValue],[MetricValue1],[MetricValue2],[MetricUnits],[Modifier1Uid],[Modifier1Name],[Modifier2Uid],[Modifier2Name],[Modifier3Uid],[Modifier3Name],[ReferenceRange],[ResultStatusCode],[AbnormalFlagCode],[Notes],[ResultStatusID],[IsVitals],[LaboratoryLocationUid],[ApproveProviderUid],[ApproveDate],[ReferenceMin],[ReferenceMax],[EnteredByUid],[LastModifiedByUid],[LastModifiedDate],[MeasurementUnits],[StringMin],[StringMax])
SELECT [ObservationValueUid],[ObservationOrderUid],[VisitUid],[LaboratoryUid],[ObservationItemUid],[Name],[ObservationValue],[DisplayOrder],[StringValue],[IntegerValue],[FloatValue],[DateValue],[DateTimeValue],[MetricValue1],[MetricValue2],[MetricUnits],[Modifier1Uid],[Modifier1Name],[Modifier2Uid],[Modifier2Name],[Modifier3Uid],[Modifier3Name],[ReferenceRange],[ResultStatusCode],[AbnormalFlagCode],[Notes],[ResultStatusID],[IsVitals],[LaboratoryLocationUid],[ApproveProviderUid],[ApproveDate],[ReferenceMin],[ReferenceMax],[EnteredByUid],[LastModifiedByUid],[LastModifiedDate],[MeasurementUnits],[StringMin],[StringMax]
FROM [ObservationValue]

DROP TABLE [ObservationValue]

exec  sp_rename 'migtemp_ObservationValue', 'ObservationValue'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OptOut]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[OptOut](
	[OptOutUid] [uniqueidentifier] NOT NULL,
	[EmailAddress] [varchar](255) NOT NULL,
	[AccessCode] [varchar](25) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [OptOut] ADD  CONSTRAINT [DF_OptOut_OptOutUid]  DEFAULT (newid()) FOR [OptOutUid]
ALTER TABLE [OptOut] ADD  CONSTRAINT [DF_OptOut_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientCareManagement]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientCareManagement](
	[PatientCareManagementUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientCareManagement_PatientCareManagementUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Location] [varchar](500) NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[RequestDate] [date] NULL,
	[StatusUid] [uniqueidentifier] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[CareTypeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientCareManagement_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ForCertification] [bit] NOT NULL CONSTRAINT [DF_PatientCareManagement_ForCertification]  DEFAULT ((0))
) ON [PRIMARY]



END
Truncate Table migtemp_PatientCareManagement
INSERT [migtemp_PatientCareManagement]([PatientCareManagementUid],[PatientUid],[Location],[EffectiveDate],[ExpirationDate],[RequestDate],[StatusUid],[MedicalServicesProviderUid],[ProviderUid],[CareTypeUid],[Notes],[LastModifiedDate],[LastModifiedByUid],[ForCertification])
SELECT [PatientCareManagementUid],[PatientUid],[Location],[EffectiveDate],[ExpirationDate],[RequestDate],[StatusUid],[MedicalServicesProviderUid],[ProviderUid],[CareTypeUid],[Notes],[LastModifiedDate],[LastModifiedByUid],[ForCertification]
FROM [PatientCareManagement]

DROP TABLE [PatientCareManagement]

exec  sp_rename 'migtemp_PatientCareManagement', 'PatientCareManagement'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientCareManagementLog]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientCareManagementLog](
	[PatientCareManagementLogUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[LogDate] [date] NOT NULL,
	[LogMinutes] [int] NULL,
	[LoggedFromMessageUid] [uniqueidentifier] NULL,
	[LoggedFromVisitUid] [uniqueidentifier] NULL,
	[IsApproved] [bit] NULL,
	[IsCPO] [bit] NOT NULL,
	[IsCCM] [bit] NOT NULL,
	[Sent] [bit] NOT NULL,
	[Received] [bit] NOT NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MedicalDecisionComplexityHighOrMedium] [bit] NOT NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_LogDate]  DEFAULT (getutcdate()) FOR [LogDate]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_IsCPO]  DEFAULT ((0)) FOR [IsCPO]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_IsCCM]  DEFAULT ((0)) FOR [IsCCM]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_Sent]  DEFAULT ((0)) FOR [Sent]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_Received]  DEFAULT ((0)) FOR [Received]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_MedicalDecisionComplexityHighOrMedium]  DEFAULT ((0)) FOR [MedicalDecisionComplexityHighOrMedium]

END
Truncate Table migtemp_PatientCareManagementLog
INSERT [migtemp_PatientCareManagementLog]([PatientCareManagementLogUid],[PatientUid],[ProviderUid],[LogDate],[LogMinutes],[LoggedFromMessageUid],[LoggedFromVisitUid],[IsApproved],[IsCPO],[IsCCM],[Sent],[Received],[IntegrationPartnerUid],[LastModifiedDate],[LastModifiedByUid])
SELECT [PatientCareManagementLogUid],[PatientUid],[ProviderUid],[LogDate],[LogMinutes],[LoggedFromMessageUid],[LoggedFromVisitUid],[IsApproved],[IsCPO],[IsCCM],[Sent],[Received],[IntegrationPartnerUid],[LastModifiedDate],[LastModifiedByUid]
FROM [PatientCareManagementLog]

DROP TABLE [PatientCareManagementLog]

exec  sp_rename 'migtemp_PatientCareManagementLog', 'PatientCareManagementLog'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientDXHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientDXHistory](
	[PatientDXHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientDXHistory_PatientDXHistoryUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientProblemUid] [uniqueidentifier] NULL,
	[ProblemStatusUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[Code] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[OnsetTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResolvedTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientDXHistory_IsDelete]  DEFAULT ((0)),
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[RecordDateTime] [datetime] NULL,
	[LastDiagnosisDate] [date] NULL,
	[DSMAxis] [varchar](250) NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientDXHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'patient dx history id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'PatientDXHistoryUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'diagnosis name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'active time : active visit date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ActiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'inactive time: deactive visit date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'InactiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'record date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'RecordDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RecordDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'RecordDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 - Differential, 2 - PreOp, 3 - PostOp; use enum VisitDiagnosisTypes in business object VisitDiagnosis' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'VisitDiagnosisType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify time' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientDXHistory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'


END
Truncate Table migtemp_PatientDXHistory
INSERT [migtemp_PatientDXHistory]([PatientDXHistoryUid],[PatientUid],[PatientProblemUid],[ProblemStatusUid],[ProviderUid],[VisitUid],[Code],[Code10],[Name],[Notes],[SnomedCTConceptId],[OnsetTimeFrame],[ResolvedTimeFrame],[IsDelete],[ActiveDate],[InactiveDate],[RecordDateTime],[LastDiagnosisDate],[DSMAxis],[VisitDiagnosisType],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientDXHistoryUid],[PatientUid],[PatientProblemUid],[ProblemStatusUid],[ProviderUid],[VisitUid],[Code],[Code10],[Name],[Notes],[SnomedCTConceptId],CONVERT(nvarchar(max), [OnsetTimeFrame]),CONVERT(nvarchar(max), [ResolvedTimeFrame]),[IsDelete],[ActiveDate],[InactiveDate],[RecordDateTime],[LastDiagnosisDate],[DSMAxis],[VisitDiagnosisType],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientDXHistory]

DROP TABLE [PatientDXHistory]

exec  sp_rename 'migtemp_PatientDXHistory', 'PatientDXHistory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientProblemDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientProblemDiagnosis](
	[PatientProblemDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientProblemDiagnosis_PatientProblemDiagnosisUid]  DEFAULT (newid()),
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[ProblemStatusUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientProblemUid] [uniqueidentifier] NULL,
	[OnsetTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[OnsetDate] [date] NULL,
	[ResolvedTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResolvedDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosis_IsDelete]  DEFAULT ((0)),
	[IsPatientProblem] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosis_IsPatientProblem]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosis_IsAddendum]  DEFAULT ((0)),
	[AddendumNotes] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[RecordDateTime] [datetime] NULL CONSTRAINT [DF_PatientProblemDiagnosis_RecordDate]  DEFAULT (getutcdate()),
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[SortDate] [datetime] NULL CONSTRAINT [DF_PatientProblemDiagnosis_SortDate]  DEFAULT (getutcdate()),
	[LastDiagnosisDate] [date] NULL,
	[DSMAxis] [varchar](250) NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosis_IsPatientInput]  DEFAULT ((0)),
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosis_LifeLong]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()),
	[HccCommunityFactors] [decimal](4, 3) NULL
) ON [PRIMARY]



END
Truncate Table migtemp_PatientProblemDiagnosis
INSERT [migtemp_PatientProblemDiagnosis]([PatientProblemDiagnosisUid],[Code9],[Code10],[Name],[PatientUid],[VisitUid],[DiseaseUid],[ProblemStatusUid],[ProviderUid],[PatientProblemUid],[OnsetTimeFrame],[OnsetDate],[ResolvedTimeFrame],[ResolvedDate],[IsDelete],[IsPatientProblem],[IsAddendum],[AddendumNotes],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[SortDate],[LastDiagnosisDate],[DSMAxis],[VisitDiagnosisType],[SnomedCTConceptId],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientProblemDiagnosisUid],[Code9],[Code10],[Name],[PatientUid],[VisitUid],[DiseaseUid],[ProblemStatusUid],[ProviderUid],[PatientProblemUid],CONVERT(nvarchar(max), [OnsetTimeFrame]),[OnsetDate],CONVERT(nvarchar(max), [ResolvedTimeFrame]),[ResolvedDate],[IsDelete],[IsPatientProblem],[IsAddendum],[AddendumNotes],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[SortDate],[LastDiagnosisDate],[DSMAxis],[VisitDiagnosisType],[SnomedCTConceptId],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientProblemDiagnosis]

DROP TABLE [PatientProblemDiagnosis]

exec  sp_rename 'migtemp_PatientProblemDiagnosis', 'PatientProblemDiagnosis'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientProblemDiagnosisHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientProblemDiagnosisHistory](
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_PatientProblemDiagnosisHistoryUid]  DEFAULT (newid()),
	[PatientProblemDiagnosisUid] [uniqueidentifier] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[ProblemStatusUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientProblemUid] [uniqueidentifier] NULL,
	[OnsetTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[OnsetDate] [date] NULL,
	[ResolvedTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResolvedDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsDelete]  DEFAULT ((0)),
	[IsPatientProblem] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsPatientProblem]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsAddendum]  DEFAULT ((0)),
	[AddendumNotes] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_DisplayOrder]  DEFAULT ((0)),
	[RecordDateTime] [datetime] NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_RecordDate]  DEFAULT (getutcdate()),
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[SortDate] [datetime] NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_SortDate]  DEFAULT (getutcdate()),
	[LastDiagnosisDate] [date] NULL,
	[DSMAxis] [varchar](250) NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsPatientInput]  DEFAULT ((0)),
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_LifeLong]  DEFAULT ((0)),
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientProblemDiagnosisHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
Truncate Table migtemp_PatientProblemDiagnosisHistory
INSERT [migtemp_PatientProblemDiagnosisHistory]([PatientProblemDiagnosisHistoryUid],[PatientProblemDiagnosisUid],[GroupingUid],[Code9],[Code10],[Name],[PatientUid],[VisitUid],[DiseaseUid],[ProblemStatusUid],[ProviderUid],[PatientProblemUid],[OnsetTimeFrame],[OnsetDate],[ResolvedTimeFrame],[ResolvedDate],[IsDelete],[IsPatientProblem],[IsAddendum],[AddendumNotes],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[SortDate],[LastDiagnosisDate],[DSMAxis],[VisitDiagnosisType],[SnomedCTConceptId],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientProblemDiagnosisHistoryUid],[PatientProblemDiagnosisUid],[GroupingUid],[Code9],[Code10],[Name],[PatientUid],[VisitUid],[DiseaseUid],[ProblemStatusUid],[ProviderUid],[PatientProblemUid],CONVERT(nvarchar(max), [OnsetTimeFrame]),[OnsetDate],CONVERT(nvarchar(max), [ResolvedTimeFrame]),[ResolvedDate],[IsDelete],[IsPatientProblem],[IsAddendum],[AddendumNotes],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[SortDate],[LastDiagnosisDate],[DSMAxis],[VisitDiagnosisType],[SnomedCTConceptId],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientProblemDiagnosisHistory]

DROP TABLE [PatientProblemDiagnosisHistory]

exec  sp_rename 'migtemp_PatientProblemDiagnosisHistory', 'PatientProblemDiagnosisHistory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientProcedure](
	[PatientProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientProcedure_PatientProcedureUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Code] [varchar](30) NULL,
	[TermName] [varchar](255) NULL,
	[ShortDescription] [varchar](75) NULL,
	[ProcedureHistoryTermUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[PerformVisitProcedureUid] [uniqueidentifier] NULL,
	[OrderedVisitProcedureUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[ProcedureHistoryStatusUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[PerformTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[PerformDate] [date] NULL,
	[ResultTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResultDate] [date] NULL,
	[OrderDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientProcedure_IsDelete]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientProcedure_DisplayOrder]  DEFAULT ((0)),
	[RecordDateTime] [datetime] NULL CONSTRAINT [DF_PatientProcedure_RecordDate]  DEFAULT (getutcdate()),
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[SortDate] [datetime] NULL CONSTRAINT [DF_PatientProcedure_SortDate]  DEFAULT (getutcdate()),
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_PatientProcedure_IsPatientInput]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RecordDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProcedure', @level2type=N'COLUMN',@level2name=N'RecordDateTime'


END
Truncate Table migtemp_PatientProcedure
INSERT [migtemp_PatientProcedure]([PatientProcedureUid],[PatientUid],[Code],[TermName],[ShortDescription],[ProcedureHistoryTermUid],[VisitUid],[PerformVisitProcedureUid],[OrderedVisitProcedureUid],[ProcedureUid],[HistoryGroupUid],[ProcedureHistoryStatusUid],[NegationReasonUid],[PerformTimeFrame],[PerformDate],[ResultTimeFrame],[ResultDate],[OrderDate],[IsDelete],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[SortDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientProcedureUid],[PatientUid],[Code],[TermName],[ShortDescription],[ProcedureHistoryTermUid],[VisitUid],[PerformVisitProcedureUid],[OrderedVisitProcedureUid],[ProcedureUid],[HistoryGroupUid],[ProcedureHistoryStatusUid],[NegationReasonUid],CONVERT(nvarchar(max), [PerformTimeFrame]),[PerformDate],CONVERT(nvarchar(max), [ResultTimeFrame]),[ResultDate],[OrderDate],[IsDelete],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[SortDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientProcedure]

DROP TABLE [PatientProcedure]

exec  sp_rename 'migtemp_PatientProcedure', 'PatientProcedure'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientProcedureHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientProcedureHistory](
	[PatientProcedureHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientProcedureHistory_PatientProcedureHistoryUid]  DEFAULT (newid()),
	[PatientProcedureUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[Code] [varchar](30) NULL,
	[TermName] [varchar](255) NULL,
	[ShortDescription] [varchar](75) NULL,
	[ProcedureHistoryTermUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[PerformVisitProcedureUid] [uniqueidentifier] NULL,
	[OrderedVisitProcedureUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[ProcedureHistoryStatusUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[PerformTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[PerformDate] [date] NULL,
	[ResultTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResultDate] [date] NULL,
	[OrderDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientProcedureHistory_IsDelete]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PatientProcedureHistory_DisplayOrder]  DEFAULT ((0)),
	[RecordDateTime] [datetime] NULL CONSTRAINT [DF_PatientProcedureHistory_RecordDate]  DEFAULT (getutcdate()),
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[SortDate] [datetime] NULL CONSTRAINT [DF_PatientProcedureHistory_SortDate]  DEFAULT (getutcdate()),
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_PatientProcedureHistory_IsPatientInput]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientProcedureHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RecordDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProcedureHistory', @level2type=N'COLUMN',@level2name=N'RecordDateTime'


END
Truncate Table migtemp_PatientProcedureHistory
INSERT [migtemp_PatientProcedureHistory]([PatientProcedureHistoryUid],[PatientProcedureUid],[PatientUid],[GroupingUid],[Code],[TermName],[ShortDescription],[ProcedureHistoryTermUid],[VisitUid],[PerformVisitProcedureUid],[OrderedVisitProcedureUid],[ProcedureUid],[HistoryGroupUid],[ProcedureHistoryStatusUid],[NegationReasonUid],[PerformTimeFrame],[PerformDate],[ResultTimeFrame],[ResultDate],[OrderDate],[IsDelete],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[SortDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientProcedureHistoryUid],[PatientProcedureUid],[PatientUid],[GroupingUid],[Code],[TermName],[ShortDescription],[ProcedureHistoryTermUid],[VisitUid],[PerformVisitProcedureUid],[OrderedVisitProcedureUid],[ProcedureUid],[HistoryGroupUid],[ProcedureHistoryStatusUid],[NegationReasonUid],CONVERT(nvarchar(max), [PerformTimeFrame]),[PerformDate],CONVERT(nvarchar(max), [ResultTimeFrame]),[ResultDate],[OrderDate],[IsDelete],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[SortDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientProcedureHistory]

DROP TABLE [PatientProcedureHistory]

exec  sp_rename 'migtemp_PatientProcedureHistory', 'PatientProcedureHistory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Person]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Person](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Person_PersonUid]  DEFAULT (newid()),
	[PatientCenterUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Person_Inactive]  DEFAULT ((0)),
	[Prefix] [varchar](25) NULL,
	[FirstName] [varchar](50) NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NOT NULL,
	[Suffix] [varchar](50) NULL,
	[Address1] [xml](CONTENT [dbo].[Address]) NULL,
	[BadAddress1] [bit] NULL CONSTRAINT [DF_Person_BadAddress1]  DEFAULT ((0)),
	[Address2] [xml](CONTENT [dbo].[Address]) NULL,
	[Phone1] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone2] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone3] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone4] [xml](CONTENT [dbo].[Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[LanguageUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[RaceUid] [uniqueidentifier] NULL,
	[EthnicityUid] [uniqueidentifier] NULL,
	[Hispanic] [bit] NOT NULL CONSTRAINT [DF_Person_Hispanic]  DEFAULT ((0)),
	[Birthdate] [date] NULL,
	[BirthTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[Deathdate] [date] NULL,
	[AkaFirstName] [varchar](50) NULL,
	[AkaLastName] [varchar](50) NULL,
	[SocialSecurityNumber] [varchar](11) NULL,
	[DriverLicenseNumber] [varchar](25) NULL,
	[DriverLicenseState] [varchar](3) NULL,
	[DriverLicenseAttachmentUid] [uniqueidentifier] NULL,
	[PhotoAttachmentUid] [uniqueidentifier] NULL,
	[LivesWithPersonUid] [uniqueidentifier] NULL,
	[MaritalStatusUid] [uniqueidentifier] NULL,
	[DominantHandUid] [uniqueidentifier] NULL,
	[PreferredContactMethod] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Person_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Person_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MaidenName] [varchar](50) NULL,
	[NotificationMethodUid] [uniqueidentifier] NULL,
	[EmailDirect] [varchar](200) NULL,
	[BirthPlace] [xml](CONTENT [dbo].[Address]) NULL,
	[Computed_Address1_Address1] [varchar](100) NULL,
	[Computed_Address1_Address2] [varchar](100) NULL,
	[Computed_Address1_City] [varchar](35) NULL,
	[Computed_Address1_State] [varchar](3) NULL,
	[Computed_Address1_Zip] [varchar](10) NULL,
	[Computed_Phone1_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone1_PhoneType] [varchar](50) NULL,
	[Computed_Phone2_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone2_PhoneType] [varchar](50) NULL,
	[Computed_Phone3_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone3_PhoneType] [varchar](50) NULL,
	[Computed_Phone4_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone4_PhoneType] [varchar](50) NULL,
	[MotherMaidenName] [varchar](50) NULL,
	[MotherMaidenFirstName] [varchar](50) NULL,
	[IdentityVerification] [xml] NULL,
	[LastIdentityVerificationTransaction] [varchar](max) NULL,
	[TranslatorRequired] [bit] NULL CONSTRAINT [DF_Person_TranslatorRequired]  DEFAULT ((0)),
	[SexualOrientationUid] [uniqueidentifier] NULL,
	[GenderIdentityUid] [uniqueidentifier] NULL,
	[SendSms] [bit] NOT NULL CONSTRAINT [DF__Person_Sms]  DEFAULT ((0)),
	[SendEmail] [bit] NOT NULL CONSTRAINT [DF__Person_Email]  DEFAULT ((0)),
	[NoEmailAddressProvided] [bit] NOT NULL CONSTRAINT [DF_Person_NoEmailAddressProvided]  DEFAULT ((0)),
	[Phone1AllowsMessages] [bit] NOT NULL CONSTRAINT [DF_Person_Phone1_AM]  DEFAULT ((0)),
	[Phone2AllowsMessages] [bit] NOT NULL CONSTRAINT [DF_Person_Phone2_AM]  DEFAULT ((0)),
	[Phone3AllowsMessages] [bit] NOT NULL CONSTRAINT [DF_Person_Phone3_AM]  DEFAULT ((0)),
	[Phone4AllowsMessages] [bit] NOT NULL CONSTRAINT [DF_Person_Phone4_AM]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Email address used to transmit data (CCDs, CCDAs, etc) using the Direct Method' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'EmailDirect'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Address1'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Address2'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_City'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_State'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Zip'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Replication.ObjectCache', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{FK_Patient_Person,!FK_PersonRawUnencrypted_Photo}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'


END
Truncate Table migtemp_Person
INSERT [migtemp_Person]([PersonUid],[PatientCenterUid],[Inactive],[Prefix],[FirstName],[MiddleName],[LastName],[Suffix],[Address1],[BadAddress1],[Address2],[Phone1],[Phone2],[Phone3],[Phone4],[Email1],[Email2],[Notes],[LanguageUid],[GenderUid],[RaceUid],[EthnicityUid],[Hispanic],[Birthdate],[BirthTime],[Deathdate],[AkaFirstName],[AkaLastName],[SocialSecurityNumber],[DriverLicenseNumber],[DriverLicenseState],[DriverLicenseAttachmentUid],[PhotoAttachmentUid],[LivesWithPersonUid],[MaritalStatusUid],[DominantHandUid],[PreferredContactMethod],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MaidenName],[NotificationMethodUid],[EmailDirect],[BirthPlace],[Computed_Address1_Address1],[Computed_Address1_Address2],[Computed_Address1_City],[Computed_Address1_State],[Computed_Address1_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType],[MotherMaidenName],[MotherMaidenFirstName],[IdentityVerification],[LastIdentityVerificationTransaction],[TranslatorRequired],[SexualOrientationUid],[GenderIdentityUid])
SELECT [PersonUid],[PatientCenterUid],[Inactive],[Prefix],[FirstName],[MiddleName],[LastName],[Suffix],CONVERT(nvarchar(max), [Address1]),[BadAddress1],CONVERT(nvarchar(max), [Address2]),CONVERT(nvarchar(max), [Phone1]),CONVERT(nvarchar(max), [Phone2]),CONVERT(nvarchar(max), [Phone3]),CONVERT(nvarchar(max), [Phone4]),[Email1],[Email2],[Notes],[LanguageUid],[GenderUid],[RaceUid],[EthnicityUid],[Hispanic],[Birthdate],[BirthTime],[Deathdate],[AkaFirstName],[AkaLastName],[SocialSecurityNumber],[DriverLicenseNumber],[DriverLicenseState],[DriverLicenseAttachmentUid],[PhotoAttachmentUid],[LivesWithPersonUid],[MaritalStatusUid],[DominantHandUid],[PreferredContactMethod],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MaidenName],[NotificationMethodUid],[EmailDirect],CONVERT(nvarchar(max), [BirthPlace]),[Computed_Address1_Address1],[Computed_Address1_Address2],[Computed_Address1_City],[Computed_Address1_State],[Computed_Address1_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType],[MotherMaidenName],[MotherMaidenFirstName],CONVERT(nvarchar(max), [IdentityVerification]),[LastIdentityVerificationTransaction],[TranslatorRequired],[SexualOrientationUid],[GenderIdentityUid]
FROM [Person]

DROP TABLE [Person]

exec  sp_rename 'migtemp_Person', 'Person'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PersonContact]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PersonContact](
	[PersonContactUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PersonContact_PersonContactUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NOT NULL,
	[ContactPersonUid] [uniqueidentifier] NOT NULL,
	[ContactRelationshipUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PersonContact_DisplayOrder]  DEFAULT ((0)),
	[EmergencyContact] [bit] NOT NULL CONSTRAINT [DF_PersonContact_EmergencyContact]  DEFAULT ((0)),
	[AuthorizedToMakeMedicalDecisions] [bit] NOT NULL CONSTRAINT [DF_PersonContact_AuthorizedToMakeMedicalDecisions]  DEFAULT ((0)),
	[AllowHIPAARelease] [smallint] NOT NULL CONSTRAINT [DF_PersonContact_AllowHIPAARelease]  DEFAULT ((0)),
	[HIPAARelease] [xml] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PersonContact_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Main person with contact.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contact.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'ContactPersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Relationship of contact to main person.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'ContactRelationshipUid'
EXEC sys.sp_addextendedproperty @name=N'AllowHIPAARelease', @value=N'<NA value="0" /><All value="1" /><Only value="2" /><Except value="3" /><None value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contacts for a person. (Single directional.)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_PersonContact_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'


END
Truncate Table migtemp_PersonContact
INSERT [migtemp_PersonContact]([PersonContactUid],[PersonUid],[ContactPersonUid],[ContactRelationshipUid],[DisplayOrder],[EmergencyContact],[AuthorizedToMakeMedicalDecisions],[Notes],[LastModifiedDate],[LastModifiedByUid])
SELECT [PersonContactUid],[PersonUid],[ContactPersonUid],[ContactRelationshipUid],[DisplayOrder],[EmergencyContact],[AuthorizedToMakeMedicalDecisions],[Notes],[LastModifiedDate],[LastModifiedByUid]
FROM [PersonContact]

DROP TABLE [PersonContact]

exec  sp_rename 'migtemp_PersonContact', 'PersonContact'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PersonInsurancePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PersonInsurancePlan](
	[PersonInsurancePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PersonInsurancePlan_PersonInsurancePlanUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NULL,
	[CorporationUid] [uniqueidentifier] NULL,
	[InsurancePlanUid] [uniqueidentifier] NOT NULL,
	[CopayPrimary] [money] NULL,
	[CopaySpecialist] [money] NULL,
	[CopayOther] [money] NULL,
	[AuthorizeAssignment] [bit] NOT NULL CONSTRAINT [DF_PersonInsurancePlan_AuthorizeAssignment]  DEFAULT ((1)),
	[PlanMemberID] [varchar](50) NULL,
	[PlanGroupID] [varchar](50) NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[InsuranceCardAttachmentUid] [uniqueidentifier] NULL,
	[EligibilityStatusUid] [uniqueidentifier] NULL,
	[EligibilityCoverageLevelUid] [uniqueidentifier] NULL,
	[InNetworkCoinsurance] [decimal](18, 0) NULL,
	[InNetworkDeductible] [money] NULL,
	[InNetworkRemaining] [money] NULL,
	[InNetworkMet] [money] NULL,
	[OutNetworkCoinsurance] [decimal](18, 0) NULL,
	[OutNetworkDeductible] [money] NULL,
	[OutNetworkRemaining] [money] NULL,
	[OutNetworkMet] [money] NULL,
	[EligibilityEffectiveDate] [date] NULL,
	[EligibilityExpirationDate] [date] NULL,
	[EligibilityVerificationDateTime] [datetime] NULL,
	[EligibilityNotes] [varchar](8000) NULL,
	[EligibilityResponseXML] [xml] NULL,
	[EligibilityTransmissionInProcess] [bit] NULL,
	[EligibilityTransmissionStatus] [varchar](50) NULL,
	[ElectronicRequest] [bit] NOT NULL CONSTRAINT [DF_PersonInsurancePlan_ElectronicRequest]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PersonInsurancePlan_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[EligibilityResponseHTML] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Insured Person, if set. If not set (null), then CorporationUid must be set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Insured Corporation, if set. If not set (null), then PersonUid must be set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'CorporationUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Insurance plan.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'InsurancePlanUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay amount.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'CopayPrimary'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay to use if provider is acting as a specialist.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'CopaySpecialist'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay to use if provider is not acting as primary or specialist.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'CopayOther'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag to authorize assignment of payment directly to physician. (If false, the patient is typically liable for charges immediately.)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'AuthorizeAssignment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Prepended to AccountInsurance.PolicyNumberSuffix to determine a patient''s policy number or memberID.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'PlanMemberID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'GroupID.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'PlanGroupID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Effective date of insured''s coverage, if set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'EffectiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Expiration date of the insured''s coverage, if set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'ExpirationDate'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'EligibilityVerificationDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'EligibilityVerificationDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An insured Person or Corporation along with their InsurancePlan. Now owned by one AccountInsurance record. (Was once shared among AccountInsurance records for various patients and insurance orders (primary, secondary, and so on.))' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_PersonInsurancePlan_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan'


END
Truncate Table migtemp_PersonInsurancePlan
INSERT [migtemp_PersonInsurancePlan]([PersonInsurancePlanUid],[PersonUid],[CorporationUid],[InsurancePlanUid],[CopayPrimary],[CopaySpecialist],[CopayOther],[AuthorizeAssignment],[PlanMemberID],[PlanGroupID],[EffectiveDate],[ExpirationDate],[InsuranceCardAttachmentUid],[EligibilityStatusUid],[EligibilityCoverageLevelUid],[InNetworkCoinsurance],[InNetworkDeductible],[InNetworkRemaining],[InNetworkMet],[OutNetworkCoinsurance],[OutNetworkDeductible],[OutNetworkRemaining],[OutNetworkMet],[EligibilityEffectiveDate],[EligibilityExpirationDate],[EligibilityVerificationDateTime],[EligibilityNotes],[EligibilityResponseXML],[EligibilityTransmissionInProcess],[EligibilityTransmissionStatus],[ElectronicRequest],[LastModifiedDate],[LastModifiedByUid])
SELECT [PersonInsurancePlanUid],[PersonUid],[CorporationUid],[InsurancePlanUid],[CopayPrimary],[CopaySpecialist],[CopayOther],[AuthorizeAssignment],[PlanMemberID],[PlanGroupID],[EffectiveDate],[ExpirationDate],[InsuranceCardAttachmentUid],[EligibilityStatusUid],[EligibilityCoverageLevelUid],[InNetworkCoinsurance],[InNetworkDeductible],[InNetworkRemaining],[InNetworkMet],[OutNetworkCoinsurance],[OutNetworkDeductible],[OutNetworkRemaining],[OutNetworkMet],[EligibilityEffectiveDate],[EligibilityExpirationDate],[EligibilityVerificationDateTime],[EligibilityNotes],CONVERT(nvarchar(max), [EligibilityResponseXML]),[EligibilityTransmissionInProcess],[EligibilityTransmissionStatus],[ElectronicRequest],[LastModifiedDate],[LastModifiedByUid]
FROM [PersonInsurancePlan]

DROP TABLE [PersonInsurancePlan]

exec  sp_rename 'migtemp_PersonInsurancePlan', 'PersonInsurancePlan'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PersonWeb]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PersonWeb](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[UserName] [varchar](50) NULL,
	[Password] [varchar](50) NULL,
	[RequireNew] [bit] NOT NULL CONSTRAINT [DF__PersonWeb__Requi__4327266E]  DEFAULT ((0)),
	[LimitedTimePassword] [bit] NOT NULL CONSTRAINT [DF_PersonWeb_LimitedTimePassword]  DEFAULT ((0)),
	[ExpirationDate] [date] NULL,
	[IncorrectLoginDateTime] [datetime] NULL,
	[IncorrectLoginCount] [tinyint] NOT NULL CONSTRAINT [DF__PersonWeb__Incor__441B4AA7]  DEFAULT ((0)),
	[PatientWebAccess] [bit] NOT NULL CONSTRAINT [DF__PersonWeb__Patie__450F6EE0]  DEFAULT ((0)),
	[UserPRMWebAccess] [bit] NOT NULL CONSTRAINT [DF__PersonWeb__UserP__46039319]  DEFAULT ((0)),
	[ProviderWebAccess] [bit] NOT NULL CONSTRAINT [DF__PersonWeb__Provi__46F7B752]  DEFAULT ((0)),
	[FacilityPortalWebAccess] [bit] NOT NULL CONSTRAINT [DF_PersonWeb_FacilityPortalWebAccess]  DEFAULT ((0)),
	[ProductConsentVersion] [int] NULL,
	[PracticeConsentVersion] [int] NULL,
	[ChartConsentVersion] [int] NULL,
	[PatientSecurityAnswerList] [xml](CONTENT [dbo].[PatientPortalSecurityAnswers]) NULL,
	[IncorrectPasswordResetDateTime] [datetime] NULL,
	[IncorrectPasswordResetCount] [tinyint] NOT NULL CONSTRAINT [DF_PersonWeb_IncorrectPasswordReset]  DEFAULT ((0)),
	[CreatedDateTime] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF__PersonWeb__LastM__47EBDB8B]  DEFAULT (getutcdate()),
	[LastLoginDate] [datetime] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'IncorrectLoginDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonWeb', @level2type=N'COLUMN',@level2name=N'IncorrectLoginDateTime'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonWeb'


END
Truncate Table migtemp_PersonWeb
INSERT [migtemp_PersonWeb]([PersonUid],[UserName],[Password],[RequireNew],[LimitedTimePassword],[ExpirationDate],[IncorrectLoginDateTime],[IncorrectLoginCount],[PatientWebAccess],[UserPRMWebAccess],[ProviderWebAccess],[ProductConsentVersion],[PracticeConsentVersion],[ChartConsentVersion],[PatientSecurityAnswerList],[IncorrectPasswordResetDateTime],[IncorrectPasswordResetCount],[CreatedDateTime],[LastModifiedByUid],[LastModifiedDate],[LastLoginDate])
SELECT [PersonUid],[UserName],[Password],[RequireNew],[LimitedTimePassword],[ExpirationDate],[IncorrectLoginDateTime],[IncorrectLoginCount],[PatientWebAccess],[UserPRMWebAccess],[ProviderWebAccess],[ProductConsentVersion],[PracticeConsentVersion],[ChartConsentVersion],CONVERT(nvarchar(max), [PatientSecurityAnswerList]),[IncorrectPasswordResetDateTime],[IncorrectPasswordResetCount],[CreatedDateTime],[LastModifiedByUid],[LastModifiedDate],[LastLoginDate]
FROM [PersonWeb]

DROP TABLE [PersonWeb]

exec  sp_rename 'migtemp_PersonWeb', 'PersonWeb'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PracticeSettings]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PracticeSettings](
	[PracticeSettingsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PracticeSettings_PracticeSettingsUid]  DEFAULT (newid()),
	[Name] [varchar](100) NOT NULL,
	[MainAddress] [xml](CONTENT [dbo].[Address]) NULL,
	[MainPhone] [xml](CONTENT [dbo].[Phone]) NULL,
	[BillingAddress] [xml](CONTENT [dbo].[Address]) NULL,
	[InTimeZoneAdj] [int] NOT NULL CONSTRAINT [DF_PracticeSettings_InTimeZoneAdj]  DEFAULT ((0)),
	[ObserveDaylightSavings] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_ObserveDaylightSavings]  DEFAULT ((1)),
	[StatementOnNewActivity] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_StatementOnNewActivity]  DEFAULT ((0)),
	[StatementCycle] [smallint] NOT NULL CONSTRAINT [DF_PracticeSettings_StatementCycle]  DEFAULT ((30)),
	[StatementDueDays] [smallint] NOT NULL CONSTRAINT [DF_PracticeSettings_StatementDueDays]  DEFAULT ((20)),
	[StatementPaymentPlanNote] [varchar](max) NULL,
	[StatementDunningOn] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_StatementDunningOn]  DEFAULT ((1)),
	[SendPaperlessStatements] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_SendPaperlessStatements]  DEFAULT ((0)),
	[NewPatientReleaseDefault] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_NewPatientReleaseDefault]  DEFAULT ((1)),
	[PatientReleaseOnEveryVisit] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_PatientReleaseOnEveryVisit]  DEFAULT ((0)),
	[FullPaymentRequired] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_FullPaymentRequired]  DEFAULT ((0)),
	[ClaimSubmitterServiceSiteUid] [uniqueidentifier] NULL,
	[PayToServiceSiteUid] [uniqueidentifier] NULL,
	[CurrentPeriodEnd] [date] NOT NULL,
	[FiscalYearEnd] [date] NOT NULL,
	[CurrentPeriodEndOfMonth] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EndOfMonthFlag]  DEFAULT ((1)),
	[FiscalYearEndOfYear] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EndOfYearFlag]  DEFAULT ((1)),
	[SystemFinancialsCloseThruDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PracticeSettings_LastModifiedByDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ElectronicSubmitterID] [varchar](50) NULL,
	[StatementMinimumAmount] [money] NOT NULL CONSTRAINT [DF_PracticeSettings_SatementMinimumAmount]  DEFAULT ((1)),
	[ReportServerBaseURL] [varchar](255) NULL,
	[ReportServerSOAPPath] [varchar](255) NULL,
	[ReportServerWebPath] [varchar](255) NULL,
	[RouteClaimErorrMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteDocumentFaxSendErrorToUserGroupUid] [uniqueidentifier] NULL,
	[RouteRxMessageSendErrorToUserGroupUid] [uniqueidentifier] NULL,
	[RouteSurveyMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteReplicationConflictMessageToUserGroupUid] [uniqueidentifier] NULL,
	[ReplicationAppointmentHours] [smallint] NOT NULL CONSTRAINT [DF__PracticeS__Repli__0303C7BD]  DEFAULT ((48)),
	[ReplicationRemovePatientHours] [smallint] NULL CONSTRAINT [DF__PracticeS__Repli__03F7EBF6]  DEFAULT ((48)),
	[ReplicationAttachmentSizeKB] [int] NOT NULL CONSTRAINT [DF__PracticeS__Repli__04EC102F]  DEFAULT ((100)),
	[ScanAppointmentSeconds] [smallint] NULL CONSTRAINT [DF__PracticeS__ScanA__05E03468]  DEFAULT ((300)),
	[TriggerRemovePatientSeconds] [smallint] NULL CONSTRAINT [DF__PracticeS__Trigg__06D458A1]  DEFAULT ((300)),
	[TriggerReplicationSeconds] [smallint] NULL CONSTRAINT [DF__PracticeS__Trigg__07C87CDA]  DEFAULT ((30)),
	[UseThirdPartyPM] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_UseThirdPartyPM]  DEFAULT ((0)),
	[UseFormulary] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_UseFormulary]  DEFAULT ((0)),
	[DisableExceptionIgnoreButtonCount] [int] NOT NULL CONSTRAINT [DF_PracticeSettings_DisableExceptionIgnoreButton]  DEFAULT ((5)),
	[RouteAuthorizationRequestMessageToUserGroupUid] [uniqueidentifier] NULL,
	[DrugScreeningCriteria] [varchar](max) NULL,
	[RxReportRdlUid] [uniqueidentifier] NULL,
	[ScheduleIIRxReportRdlUid] [uniqueidentifier] NULL,
	[PrintSampleRx] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_PrintSampleRx_1]  DEFAULT ((1)),
	[CodeValidationAtSuperbillEnabled] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_CodeValidationAtSuperbillEnabled]  DEFAULT ((0)),
	[CodeValidationMinimumErrorReport] [varchar](50) NULL,
	[CodeValidationErrorStopLevel] [varchar](50) NULL,
	[DefaultSystemARBatchOwnerUid] [uniqueidentifier] NULL,
	[AppointmentConfirmationEnabled] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AppointmentConfirmationEnabled]  DEFAULT ((0)),
	[StatementsByFinancialCenter] [bit] NULL CONSTRAINT [DF_PracticeSettings_StatementsByFinancialCenter]  DEFAULT ((0)),
	[DunningMsgsUid] [uniqueidentifier] NULL,
	[InsuranceBalanceOnlySuperbills] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_InsuranceBalanceOnlySuperbills]  DEFAULT ((0)),
	[AllowProcedureNotePopUp] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AllowProcedureNotePopUp]  DEFAULT ((0)),
	[eRxDownloadSetting] [varchar](2048) NULL,
	[FaxControlledSubstances] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_FaxControlledSubstances]  DEFAULT ((0)),
	[RxFooter] [varchar](50) NULL,
	[RoutePatientMessages] [xml](CONTENT [dbo].[PatientMessagesToUserGroup]) NULL,
	[AutoInternetPatientMessagingEnabled] [bit] NULL,
	[CalculateTax] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_CalculateTax]  DEFAULT ((0)),
	[TaxableOption] [smallint] NOT NULL CONSTRAINT [DF_PracticeSettings_TaxableOption]  DEFAULT ((0)),
	[AllowUnsentLabOrdersForCompletedNotes] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AllowUnsentLabOrdersForCompletedNotes]  DEFAULT ((0)),
	[RequireLabOrderTaskMsg] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_RequireLabOrderTaskMsg_1]  DEFAULT ((1)),
	[AutoCheckLabsRdyToSendForCompletedNotes] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AutoCheckLabsRdyToSendForCompletedNotes_1]  DEFAULT ((1)),
	[ShowPatientBirthTime] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_ShowPatientBirthTime]  DEFAULT ((0)),
	[AppointmentEligibility] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AppointmentEligibility]  DEFAULT ((0)),
	[DaysEligibilityInAdvance] [smallint] NOT NULL CONSTRAINT [DF_PracticeSettings_DaysEligibilityInAdvance]  DEFAULT ((2)),
	[EligibilityIncludeWeekends] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EligibilityIncludeWeekends]  DEFAULT ((0)),
	[RouteVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteNUSBVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[MaxImportDocumentErrorUid] [uniqueidentifier] NULL,
	[MaxImportDocumentSize] [int] NULL CONSTRAINT [DF_PracticeSettings_MaxImportDocumentSize]  DEFAULT ((20)),
	[DisableIM] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_DisableIM]  DEFAULT ((0)),
	[RequireDiagnosisBeforeOrdersCanBeSent] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_RequireDiagnosisBeforeOrdersCanBeSent]  DEFAULT ((0)),
	[SQLCALUser] [bit] NULL,
	[IncludeReferringProvider] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludeReferringProvider]  DEFAULT ((1)),
	[SuppressZeroDollarProcedures] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_SuppressZeroDollarProcedures]  DEFAULT ((1)),
	[IncludeLastFileDate] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludeLastFileDate]  DEFAULT ((1)),
	[StatementFooter] [varchar](325) NULL,
	[IncludePaymentReferenceNumber] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludePaymentReferenceNumber]  DEFAULT ((1)),
	[IncludeProcedureCode] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludeProcedureCode]  DEFAULT ((1)),
	[EligibilityOncePerMonth] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EligibilityOncePerMonth]  DEFAULT ((0)),
	[EligibilityCheckOnMonthChange] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_EligibilityCheckOnMonthChange]  DEFAULT ((0)),
	[HMRulesDeleteNonRelevantIsDueMessages] [bit] NULL,
	[HMRulesCompleteNonRelevantIsDueMessages] [bit] NULL,
	[HMRulesCompletedByUid] [uniqueidentifier] NULL,
	[IncludeCompletedOrClosed] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_IncludeCompletedOrClosed]  DEFAULT ((0)),
	[WarnWhenEditingCompleteNote] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_WarnWhenEditingCompleteNote]  DEFAULT ((0)),
	[DisplayHistVaccOldestToRecent] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_DisplayHistVaccOldestToRecent]  DEFAULT ((1)),
	[VaccineCardPrintLandscape] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_VaccineCardPrintLandscape]  DEFAULT ((1)),
	[PatientEmails] [xml](CONTENT [dbo].[PatientInternetEmails]) NULL,
	[DisplaySBStartStopTimes] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_DisplaySBStartStopTimes_1]  DEFAULT ((0)),
	[RoutePatientPortalErrorMessageToUserGroupUid] [uniqueidentifier] NULL,
	[AllowPracticeSettingsDiagnosisLinking] [bit] NULL,
	[ShowRVUSearchingCPTUid] [uniqueidentifier] NULL,
	[PatientPortalMessageRouting] [xml] NULL,
	[PCMHParticipant] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_PCMHParticipant]  DEFAULT ((0)),
	[StatementModelUid] [uniqueidentifier] NULL,
	[RequestSignatureOnCreditCardReceipt] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_RequestSignatureOnCreditCardReceipt]  DEFAULT ((0)),
	[AllowConcurrentReferringProviders] [bit] NOT NULL CONSTRAINT [DF_PracticeSettings_AllowConcurrentReferringProviders]  DEFAULT ((0)),
	[OptOutStatementEmailUserGroupUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PracticeSettings'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PracticeSettings'


END
Truncate Table migtemp_PracticeSettings
INSERT [migtemp_PracticeSettings]([PracticeSettingsUid],[Name],[MainAddress],[MainPhone],[BillingAddress],[InTimeZoneAdj],[ObserveDaylightSavings],[StatementOnNewActivity],[StatementCycle],[StatementDueDays],[StatementPaymentPlanNote],[StatementDunningOn],[SendPaperlessStatements],[NewPatientReleaseDefault],[PatientReleaseOnEveryVisit],[FullPaymentRequired],[ClaimSubmitterServiceSiteUid],[PayToServiceSiteUid],[CurrentPeriodEnd],[FiscalYearEnd],[CurrentPeriodEndOfMonth],[FiscalYearEndOfYear],[SystemFinancialsCloseThruDate],[LastModifiedDate],[LastModifiedByUid],[ElectronicSubmitterID],[StatementMinimumAmount],[ReportServerBaseURL],[ReportServerSOAPPath],[ReportServerWebPath],[RouteClaimErorrMessageToUserGroupUid],[RouteDocumentFaxSendErrorToUserGroupUid],[RouteRxMessageSendErrorToUserGroupUid],[RouteSurveyMessageToUserGroupUid],[RouteReplicationConflictMessageToUserGroupUid],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[ScanAppointmentSeconds],[TriggerRemovePatientSeconds],[TriggerReplicationSeconds],[UseThirdPartyPM],[UseFormulary],[DisableExceptionIgnoreButtonCount],[RouteAuthorizationRequestMessageToUserGroupUid],[DrugScreeningCriteria],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[PrintSampleRx],[CodeValidationAtSuperbillEnabled],[CodeValidationMinimumErrorReport],[CodeValidationErrorStopLevel],[DefaultSystemARBatchOwnerUid],[AppointmentConfirmationEnabled],[StatementsByFinancialCenter],[DunningMsgsUid],[InsuranceBalanceOnlySuperbills],[AllowProcedureNotePopUp],[eRxDownloadSetting],[FaxControlledSubstances],[RxFooter],[RoutePatientMessages],[AutoInternetPatientMessagingEnabled],[CalculateTax],[TaxableOption],[AllowUnsentLabOrdersForCompletedNotes],[RequireLabOrderTaskMsg],[AutoCheckLabsRdyToSendForCompletedNotes],[ShowPatientBirthTime],[AppointmentEligibility],[DaysEligibilityInAdvance],[EligibilityIncludeWeekends],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[MaxImportDocumentErrorUid],[MaxImportDocumentSize],[DisableIM],[RequireDiagnosisBeforeOrdersCanBeSent],[SQLCALUser],[IncludeReferringProvider],[SuppressZeroDollarProcedures],[IncludeLastFileDate],[StatementFooter],[IncludePaymentReferenceNumber],[IncludeProcedureCode],[EligibilityOncePerMonth],[EligibilityCheckOnMonthChange],[HMRulesDeleteNonRelevantIsDueMessages],[HMRulesCompleteNonRelevantIsDueMessages],[HMRulesCompletedByUid],[IncludeCompletedOrClosed],[WarnWhenEditingCompleteNote],[DisplayHistVaccOldestToRecent],[VaccineCardPrintLandscape],[PatientEmails],[DisplaySBStartStopTimes],[RoutePatientPortalErrorMessageToUserGroupUid],[AllowPracticeSettingsDiagnosisLinking],[ShowRVUSearchingCPTUid],[PatientPortalMessageRouting],[PCMHParticipant],[StatementModelUid],[RequestSignatureOnCreditCardReceipt],[AllowConcurrentReferringProviders])
SELECT [PracticeSettingsUid],[Name],CONVERT(nvarchar(max), [MainAddress]),CONVERT(nvarchar(max), [MainPhone]),CONVERT(nvarchar(max), [BillingAddress]),[InTimeZoneAdj],[ObserveDaylightSavings],[StatementOnNewActivity],[StatementCycle],[StatementDueDays],[StatementPaymentPlanNote],[StatementDunningOn],[SendPaperlessStatements],[NewPatientReleaseDefault],[PatientReleaseOnEveryVisit],[FullPaymentRequired],[ClaimSubmitterServiceSiteUid],[PayToServiceSiteUid],[CurrentPeriodEnd],[FiscalYearEnd],[CurrentPeriodEndOfMonth],[FiscalYearEndOfYear],[SystemFinancialsCloseThruDate],[LastModifiedDate],[LastModifiedByUid],[ElectronicSubmitterID],[StatementMinimumAmount],[ReportServerBaseURL],[ReportServerSOAPPath],[ReportServerWebPath],[RouteClaimErorrMessageToUserGroupUid],[RouteDocumentFaxSendErrorToUserGroupUid],[RouteRxMessageSendErrorToUserGroupUid],[RouteSurveyMessageToUserGroupUid],[RouteReplicationConflictMessageToUserGroupUid],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[ScanAppointmentSeconds],[TriggerRemovePatientSeconds],[TriggerReplicationSeconds],[UseThirdPartyPM],[UseFormulary],[DisableExceptionIgnoreButtonCount],[RouteAuthorizationRequestMessageToUserGroupUid],[DrugScreeningCriteria],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[PrintSampleRx],[CodeValidationAtSuperbillEnabled],[CodeValidationMinimumErrorReport],[CodeValidationErrorStopLevel],[DefaultSystemARBatchOwnerUid],[AppointmentConfirmationEnabled],[StatementsByFinancialCenter],[DunningMsgsUid],[InsuranceBalanceOnlySuperbills],[AllowProcedureNotePopUp],[eRxDownloadSetting],[FaxControlledSubstances],[RxFooter],CONVERT(nvarchar(max), [RoutePatientMessages]),[AutoInternetPatientMessagingEnabled],[CalculateTax],[TaxableOption],[AllowUnsentLabOrdersForCompletedNotes],[RequireLabOrderTaskMsg],[AutoCheckLabsRdyToSendForCompletedNotes],[ShowPatientBirthTime],[AppointmentEligibility],[DaysEligibilityInAdvance],[EligibilityIncludeWeekends],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[MaxImportDocumentErrorUid],[MaxImportDocumentSize],[DisableIM],[RequireDiagnosisBeforeOrdersCanBeSent],[SQLCALUser],[IncludeReferringProvider],[SuppressZeroDollarProcedures],[IncludeLastFileDate],[StatementFooter],[IncludePaymentReferenceNumber],[IncludeProcedureCode],[EligibilityOncePerMonth],[EligibilityCheckOnMonthChange],[HMRulesDeleteNonRelevantIsDueMessages],[HMRulesCompleteNonRelevantIsDueMessages],[HMRulesCompletedByUid],[IncludeCompletedOrClosed],[WarnWhenEditingCompleteNote],[DisplayHistVaccOldestToRecent],[VaccineCardPrintLandscape],CONVERT(nvarchar(max), [PatientEmails]),[DisplaySBStartStopTimes],[RoutePatientPortalErrorMessageToUserGroupUid],[AllowPracticeSettingsDiagnosisLinking],[ShowRVUSearchingCPTUid],CONVERT(nvarchar(max), [PatientPortalMessageRouting]),[PCMHParticipant],[StatementModelUid],[RequestSignatureOnCreditCardReceipt],[AllowConcurrentReferringProviders]
FROM [PracticeSettings]

DROP TABLE [PracticeSettings]

exec  sp_rename 'migtemp_PracticeSettings', 'PracticeSettings'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PrintSetDetail]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PrintSetDetail](
	[PrintSetDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PrintSetDetail_PrintSetDetailUid]  DEFAULT (newid()),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_PrintSetDetail_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_PrintSetDetail_UserDefined]  DEFAULT ((1)),
	[PrintSetUid] [uniqueidentifier] NULL,
	[ReportUid] [uniqueidentifier] NULL,
	[UseEducationForm] [bit] NOT NULL CONSTRAINT [DF_PrintSetDetail_UseEducationForm]  DEFAULT ((0)),
	[PrinterName] [varchar](100) NULL,
	[PrinterDeviceID] [varchar](100) NULL,
	[PrinterSettings] [varbinary](max) NULL,
	[OffsetTop] [numeric](9, 3) NOT NULL CONSTRAINT [DF_PrintSetDetail_OffsetTop]  DEFAULT ((0)),
	[OffsetLeft] [numeric](9, 3) NOT NULL CONSTRAINT [DF_PrintSetDetail_OffsetLeft]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PrintSetDetail_LastModifiedDate_1]  DEFAULT (getutcdate()),
	[CustomNotePrintUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PrintSetDetail'


END
Truncate Table migtemp_PrintSetDetail
INSERT [migtemp_PrintSetDetail]([PrintSetDetailUid],[Inactive],[UserDefined],[PrintSetUid],[ReportUid],[PrinterName],[PrinterDeviceID],[PrinterSettings],[OffsetTop],[OffsetLeft],[LastModifiedByUid],[LastModifiedDate],[CustomNotePrintUid])
SELECT [PrintSetDetailUid],[Inactive],[UserDefined],[PrintSetUid],[ReportUid],[PrinterName],[PrinterDeviceID],[PrinterSettings],[OffsetTop],[OffsetLeft],[LastModifiedByUid],[LastModifiedDate],[CustomNotePrintUid]
FROM [PrintSetDetail]

DROP TABLE [PrintSetDetail]

exec  sp_rename 'migtemp_PrintSetDetail', 'PrintSetDetail'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Provider]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Provider](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Provider_Inactive]  DEFAULT ((0)),
	[ProviderRoleID] [smallint] NOT NULL CONSTRAINT [DF_Provider_ProviderRoleID]  DEFAULT ((1)),
	[IsBillingProvider] [bit] NOT NULL CONSTRAINT [DF_Provider_IsBillingProvider]  DEFAULT ((1)),
	[IsReferringProvider] [bit] NOT NULL CONSTRAINT [DF_Provider_IsReferringProvider]  DEFAULT ((1)),
	[FTE] [smallint] NULL,
	[ProviderLicense] [smallint] NULL,
	[DefaultProviderCareTypeUid] [uniqueidentifier] NULL,
	[DefaultServiceSiteUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[FeeScheduleUid] [uniqueidentifier] NULL,
	[SignatureTypeId] [smallint] NOT NULL CONSTRAINT [DF_Provider_SignatureTypeId]  DEFAULT ((0)),
	[ReplicationAppointmentHours] [smallint] NOT NULL CONSTRAINT [DF_Provider_ReplicationAppointmentHours]  DEFAULT ((48)),
	[ReplicationRemovePatientHours] [smallint] NOT NULL CONSTRAINT [DF_Provider_ReplicationRemovePatientHours]  DEFAULT ((48)),
	[ReplicationAttachmentSizeKB] [smallint] NOT NULL CONSTRAINT [DF_Provider_ReplicationAttach5mentSizeKB]  DEFAULT ((50)),
	[AutoLearnCommonProblemPallet] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoLearnCommonProblemPallet_1]  DEFAULT ((1)),
	[EMCodeReminder] [bit] NOT NULL CONSTRAINT [DF_Provider_EMCodeReminder]  DEFAULT ((1)),
	[ePrescribeWarning] [bit] NOT NULL CONSTRAINT [DF_Provider_ePrescribeWarning]  DEFAULT ((1)),
	[PrintPrescriptionsOnCheckout] [bit] NOT NULL CONSTRAINT [DF_Provider_PrintPrescriptionsOnCheckout]  DEFAULT ((1)),
	[DefaultListInFNC] [smallint] NOT NULL CONSTRAINT [DF_Provider_DefaultListInFNC_1]  DEFAULT ((1)),
	[ROSOrder] [smallint] NOT NULL CONSTRAINT [DF_Provider_ROSOrder_1]  DEFAULT ((0)),
	[RxThermalPrinter] [bit] NOT NULL CONSTRAINT [DF_Provider_RxThermalPrinter]  DEFAULT ((0)),
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[TranscriptionistUid] [uniqueidentifier] NULL,
	[SpecialtyUid] [uniqueidentifier] NULL,
	[ETIN] [varchar](50) NULL,
	[EClaimSiteTaxID] [varchar](50) NULL,
	[MandatoryCosignature] [bit] NOT NULL CONSTRAINT [DF_Provider_MandatoryCosignature]  DEFAULT ((0)),
	[SupervisingPrescriptionSignatureSource] [bit] NOT NULL CONSTRAINT [DF_Provider_PrescriptionSignatureSource]  DEFAULT ((0)),
	[CanSignRx] [bit] NOT NULL CONSTRAINT [DF_Provider_CanSignRx]  DEFAULT ((0)),
	[DefaultReviewerUid] [uniqueidentifier] NULL,
	[RxReportRdlUid] [uniqueidentifier] NULL,
	[ScheduleIIRxReportRdlUid] [uniqueidentifier] NULL,
	[MedicationReportLastRun] [datetime] NULL,
	[UsePracticeSettingsBillingAddress] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePSPE]  DEFAULT ((1)),
	[UsePracticeSettingsMaintenaceDrugCls] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePracticeSettingsMaintenaceDrugCls]  DEFAULT ((0)),
	[ClaimProviderCorporationUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[ExternalID] [varchar](25) NULL,
	[AutoLinkDxCpt] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoLinkDxCpt_1]  DEFAULT ((0)),
	[SuperbillStatusID] [smallint] NOT NULL CONSTRAINT [DF_Provider_SuperbillStatusID]  DEFAULT ((0)),
	[ConsultingProvider] [bit] NOT NULL CONSTRAINT [DF_Provider_Consult]  DEFAULT ((0)),
	[AuthorizationGroupUid] [uniqueidentifier] NULL,
	[AuthorizationReviewerUid] [uniqueidentifier] NULL,
	[DrugScreeningCriteria] [varchar](max) NULL,
	[UseLDM] [bit] NOT NULL CONSTRAINT [DF_Provider_UseLDM]  DEFAULT ((1)),
	[AutoAddMedicationReport] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoAddMedicationReport]  DEFAULT ((1)),
	[EduFormAssociationUid] [uniqueidentifier] NULL,
	[PayToProviderCorporationUid] [uniqueidentifier] NULL,
	[Initials] [varchar](5) NULL,
	[DocumentFaxElection] [smallint] NOT NULL CONSTRAINT [DF_Provider_DocumentFaxElection]  DEFAULT ((0)),
	[RouteDocumentFaxErrorToUserUid] [uniqueidentifier] NULL,
	[DefaultCoverageTypeUid] [uniqueidentifier] NULL,
	[DefaultLabOrderTaskMsgRecvrUid] [uniqueidentifier] NULL,
	[AutoSendLabOrderMsgs] [bit] NULL CONSTRAINT [DF_Provider_AutoSendLabOrderMsgs_1]  DEFAULT ((0)),
	[UsePracticeSettingseRxDownloadSetting] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePracticeSettingseRxDownloadSetting]  DEFAULT ((1)),
	[eRxDownloadSetting] [varchar](2048) NULL,
	[AutoCheckNoteComplete] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoCheckNoteComplete]  DEFAULT ((0)),
	[RoutePatientMessages] [xml](CONTENT [dbo].[PatientMessagesToUserGroup]) NULL,
	[DefaultCheckDischargePatient] [bit] NOT NULL CONSTRAINT [DF_Provider_DefaultCheckDischargePatient_1]  DEFAULT ((0)),
	[DefaultCheckSendPrescriptions] [bit] NOT NULL CONSTRAINT [DF_Provider_DefaultCheckSendPrescriptions_1]  DEFAULT ((0)),
	[DefaultCheckSendLabOrders] [bit] NOT NULL CONSTRAINT [DF_Provider_DefaultCheckSendLabOrders_1]  DEFAULT ((0)),
	[AllowProcedureWithoutDiag] [bit] NOT NULL CONSTRAINT [DF_Provider_AllowProcedureWithoutDiag]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Provider_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Provider_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[RouteVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteNUSBVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[SendCanelServiceOrderMessage] [bit] NOT NULL CONSTRAINT [DF_Provider_SendCanelServiceOrderMessage]  DEFAULT ((0)),
	[UsePracticeSettingsPatientEmails] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePracticeSettingsPatientEmails]  DEFAULT ((1)),
	[PatientEmails] [xml](CONTENT [dbo].[PatientInternetEmails]) NULL,
	[ValidateBillingTime] [bit] NOT NULL CONSTRAINT [DF_Provider_ValidateBillingTime_1]  DEFAULT ((0)),
	[AprimaDataExchangeRegistrationLastUpdate] [datetime] NULL,
	[AprimaDataExchangeProviderRegistrationUid] [uniqueidentifier] NULL,
	[DefaultEMPlaceofServiceID] [tinyint] NULL,
	[AutoLinkingDiagnosisProblem] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoLinkingDingnosisProblem]  DEFAULT ((1)),
	[DefaultBillingProviderUid] [uniqueidentifier] NULL,
	[IdentityVerification] [xml] NULL,
	[CDSCatalogUid] [uniqueidentifier] NULL,
	[DiagnosisRangePlanUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The full time equivalent percentage for this provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider', @level2type=N'COLUMN',@level2name=N'FTE'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 - Head to Toe; 1 - Alphabetical; 2 - User Defined' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider', @level2type=N'COLUMN',@level2name=N'ROSOrder'
EXEC sys.sp_addextendedproperty @name=N'DefaultEMPlaceofServiceID', @value=N'<Office value="0" description="Office" /><NursingFacility value="1" description="Nursing Facility" /><HomeServices value="2" description="Home Services" /><RestHome value="3" description="Rest Home" /><Observation value="4" description="Observation" /><Inpatient value="5" description="Inpatient" /><CriticalCare value="6" description="Critical Care" /><ER value="7" description="ER" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'DocumentFaxElection', @value=N'<NoFax value="0" />
<AutoFax value="1" />
<Prompt value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'UserPRM' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'ProviderLicense', @value=N'<None value="0" />
<EMR value="1" />
<PM value="2" />
<PRM value="3" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'ProviderRoleID', @value=N'<Physician value="1" />
<OtherProvider value="2" />
<TestProvider value="3" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'!FK_Provider_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'ROSOrder', @value=N'<HeadToToe value="0" />
<Alphabetical value="1" />
<UserDefined value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'SignatureTypeId', @value=N'<None value="0" />
<Permanent value="1" />
<OncePerDay value="2" />
<OncePerLogin value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'


END
Truncate Table migtemp_Provider
INSERT [migtemp_Provider]([PersonUid],[Inactive],[ProviderRoleID],[IsBillingProvider],[IsReferringProvider],[FTE],[ProviderLicense],[DefaultProviderCareTypeUid],[DefaultServiceSiteUid],[FinancialCenterUid],[FeeScheduleUid],[SignatureTypeId],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[AutoLearnCommonProblemPallet],[EMCodeReminder],[ePrescribeWarning],[PrintPrescriptionsOnCheckout],[DefaultListInFNC],[ROSOrder],[RxThermalPrinter],[ClinicCenterUid],[TranscriptionistUid],[SpecialtyUid],[ETIN],[EClaimSiteTaxID],[MandatoryCosignature],[SupervisingPrescriptionSignatureSource],[CanSignRx],[DefaultReviewerUid],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[MedicationReportLastRun],[UsePracticeSettingsBillingAddress],[UsePracticeSettingsMaintenaceDrugCls],[ClaimProviderCorporationUid],[Notes],[ExternalID],[AutoLinkDxCpt],[SuperbillStatusID],[ConsultingProvider],[AuthorizationGroupUid],[AuthorizationReviewerUid],[DrugScreeningCriteria],[UseLDM],[AutoAddMedicationReport],[EduFormAssociationUid],[PayToProviderCorporationUid],[Initials],[DocumentFaxElection],[RouteDocumentFaxErrorToUserUid],[DefaultCoverageTypeUid],[DefaultLabOrderTaskMsgRecvrUid],[AutoSendLabOrderMsgs],[UsePracticeSettingseRxDownloadSetting],[eRxDownloadSetting],[AutoCheckNoteComplete],[RoutePatientMessages],[DefaultCheckDischargePatient],[DefaultCheckSendPrescriptions],[DefaultCheckSendLabOrders],[AllowProcedureWithoutDiag],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[SendCanelServiceOrderMessage],[UsePracticeSettingsPatientEmails],[PatientEmails],[ValidateBillingTime],[AprimaDataExchangeRegistrationLastUpdate],[AprimaDataExchangeProviderRegistrationUid],[DefaultEMPlaceofServiceID],[AutoLinkingDiagnosisProblem],[DefaultBillingProviderUid],[IdentityVerification],[CDSCatalogUid],[DiagnosisRangePlanUid])
SELECT [PersonUid],[Inactive],[ProviderRoleID],[IsBillingProvider],[IsReferringProvider],[FTE],[ProviderLicense],[DefaultProviderCareTypeUid],[DefaultServiceSiteUid],[FinancialCenterUid],[FeeScheduleUid],[SignatureTypeId],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[AutoLearnCommonProblemPallet],[EMCodeReminder],[ePrescribeWarning],[PrintPrescriptionsOnCheckout],[DefaultListInFNC],[ROSOrder],[RxThermalPrinter],[ClinicCenterUid],[TranscriptionistUid],[SpecialtyUid],[ETIN],[EClaimSiteTaxID],[MandatoryCosignature],[SupervisingPrescriptionSignatureSource],[CanSignRx],[DefaultReviewerUid],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[MedicationReportLastRun],[UsePracticeSettingsBillingAddress],[UsePracticeSettingsMaintenaceDrugCls],[ClaimProviderCorporationUid],[Notes],[ExternalID],[AutoLinkDxCpt],[SuperbillStatusID],[ConsultingProvider],[AuthorizationGroupUid],[AuthorizationReviewerUid],[DrugScreeningCriteria],[UseLDM],[AutoAddMedicationReport],[EduFormAssociationUid],[PayToProviderCorporationUid],[Initials],[DocumentFaxElection],[RouteDocumentFaxErrorToUserUid],[DefaultCoverageTypeUid],[DefaultLabOrderTaskMsgRecvrUid],[AutoSendLabOrderMsgs],[UsePracticeSettingseRxDownloadSetting],[eRxDownloadSetting],[AutoCheckNoteComplete],CONVERT(nvarchar(max), [RoutePatientMessages]),[DefaultCheckDischargePatient],[DefaultCheckSendPrescriptions],[DefaultCheckSendLabOrders],[AllowProcedureWithoutDiag],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[SendCanelServiceOrderMessage],[UsePracticeSettingsPatientEmails],CONVERT(nvarchar(max), [PatientEmails]),[ValidateBillingTime],[AprimaDataExchangeRegistrationLastUpdate],[AprimaDataExchangeProviderRegistrationUid],[DefaultEMPlaceofServiceID],[AutoLinkingDiagnosisProblem],[DefaultBillingProviderUid],CONVERT(nvarchar(max), [IdentityVerification]),[CDSCatalogUid],[DiagnosisRangePlanUid]
FROM [Provider]

DROP TABLE [Provider]

exec  sp_rename 'migtemp_Provider', 'Provider'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureMethod' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DisclosureMethod' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DisclosureType' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'RecipientType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'RecipientType' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ForcedUploadProcessOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Status' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Status' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureMethod' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DisclosureMethod', @value=N'<None value="0"/><DirectCommunicationEmail value="1"/><Fax value="2" /><Print value="3" /><SaveToFile value="4" /><Portal value="5" /><FacilityPortal value="6" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DisclosureType', @value=N'<None value="0"/><CompleteChart value="1" />  <ClinicalSummary value="2" />  <LabResult value="3" /> <Medication value="4" /> <MedicationAllergies value="5" /> <Immunizations value="6" /> <Procedures value="7" /> <MedicalHistory value="8" /> <EducationMaterial value="9" /> <Demographics value="10" /> <ContinuityOfCareDocument value="11" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'RecipientType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'RecipientType', @value=N'<None value="0"/><Provider value="1"/><MedicalServiceProvider value="2" /><ServiceSite value="3" /><Patient value="4" /><OtherRecipient value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Status' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<Sent value="1"/><Error value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ReimbursementRuleTrigger]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ReimbursementRuleTrigger](
	[ReimbursementRuleTriggerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_ReimbursementRuleTriggerUid]  DEFAULT (newid()),
	[ReimbursementRuleUid] [uniqueidentifier] NULL,
	[Message] [varchar](1000) NULL,
	[PositiveTest] [bit] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_PositiveTest]  DEFAULT ((0)),
	[DaysSinceLastTest] [int] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_UserDefined]  DEFAULT ((1)),
	[AgeRangeFrom] [int] NULL,
	[AgeRangeTo] [int] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[DiagnosisSearchDefinition] [varchar](max) NULL,
	[ProcedureRequiresDiagnosis] [bit] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_ProcedureRequiresDiagnosis]  DEFAULT ((0)),
	[LastModifiedUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ReimbursementRuleTrigger_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ReimbursementRuleTrigger'


END
Truncate Table migtemp_ReimbursementRuleTrigger
INSERT [migtemp_ReimbursementRuleTrigger]([ReimbursementRuleTriggerUid],[ReimbursementRuleUid],[Message],[PositiveTest],[DaysSinceLastTest],[Inactive],[UserDefined],[AgeRangeFrom],[AgeRangeTo],[GenderUid],[DiagnosisSearchDefinition],[ProcedureRequiresDiagnosis],[LastModifiedUid],[LastModifiedDate])
SELECT [ReimbursementRuleTriggerUid],[ReimbursementRuleUid],[Message],[PositiveTest],[DaysSinceLastTest],[Inactive],[UserDefined],[AgeRangeFrom],[AgeRangeTo],[GenderUid],[DiagnosisSearchDefinition],[ProcedureRequiresDiagnosis],[LastModifiedUid],[LastModifiedDate]
FROM [ReimbursementRuleTrigger]

DROP TABLE [ReimbursementRuleTrigger]

exec  sp_rename 'migtemp_ReimbursementRuleTrigger', 'ReimbursementRuleTrigger'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelAttachmentGroup]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelAttachmentGroup](
	[RelAttachmentGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelAttachment_RelAttachmentGroupUid]  DEFAULT (newid()),
	[AttachmentGroupUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[ObservationOrderUid] [uniqueidentifier] NULL,
	[MessageUid] [uniqueidentifier] NULL,
	[PatientProcedureUid] [uniqueidentifier] NULL,
	[IncludeInSummary] [bit] NOT NULL CONSTRAINT [DF_RelAttachmentGroup_IncludeInSummary]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelAttachment_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelAttachment_LastModifiedDate]  DEFAULT (getutcdate()),
	[PatientProviderRelationshipUid] [uniqueidentifier] NULL,
	[PatientReferralUid] [uniqueidentifier] NULL,
	[PracticeFormUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedRelationships', @value=N'Attachment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'AttachmentGroupUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSize', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'AttachmentGroupUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'ObservationOrderUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'MessageUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_RelAttachmentGroup_Person,FK_RelAttachmentGroup_Visit,FK_RelAttachmentGroup_ObservationOrder,FK_RelAttachmentGroup_Message,FK_RelAttachmentGroup_AccountResponsibleParty,FK_MessageAA_RelAttachmentGroup}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup'


END
Truncate Table migtemp_RelAttachmentGroup
INSERT [migtemp_RelAttachmentGroup]([RelAttachmentGroupUid],[AttachmentGroupUid],[PersonUid],[VisitUid],[AccountResponsiblePartyUid],[DepositUid],[ObservationOrderUid],[MessageUid],[PatientProcedureUid],[IncludeInSummary],[Inactive],[LastModifiedByUid],[LastModifiedDate],[PatientProviderRelationshipUid],[PatientReferralUid])
SELECT [RelAttachmentGroupUid],[AttachmentGroupUid],[PersonUid],[VisitUid],[AccountResponsiblePartyUid],[DepositUid],[ObservationOrderUid],[MessageUid],[PatientProcedureUid],[IncludeInSummary],[Inactive],[LastModifiedByUid],[LastModifiedDate],[PatientProviderRelationshipUid],[PatientReferralUid]
FROM [RelAttachmentGroup]

DROP TABLE [RelAttachmentGroup]

exec  sp_rename 'migtemp_RelAttachmentGroup', 'RelAttachmentGroup'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelBatchProcessDetailActionSummary]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelBatchProcessDetailActionSummary](
	[RelBatchProcessDetailActionSummaryUid] [uniqueidentifier] NOT NULL,
	[BatchProcessDetailUid] [uniqueidentifier] NOT NULL,
	[ActionType] [varchar](100) NOT NULL,
	[Summary] [varchar](1000) NULL,
	[Detail] [varchar](max) NULL,
	[Success] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelBatchProcessDetailActionSummary'

ALTER TABLE [RelBatchProcessDetailActionSummary] ADD  CONSTRAINT [DF_RelBatchProcessDetailActionSummary_RelBatchProcessDetailActionSummaryUid]  DEFAULT (newid()) FOR [RelBatchProcessDetailActionSummaryUid]
ALTER TABLE [RelBatchProcessDetailActionSummary] ADD  CONSTRAINT [DF_RelBatchProcessDetailActionSummary_Success]  DEFAULT ((0)) FOR [Success]
ALTER TABLE [RelBatchProcessDetailActionSummary] ADD  CONSTRAINT [DF_RelBatchProcessDetailActionSummary_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelCCSymptomHpi]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelCCSymptomHpi](
	[RelCCSymptomHpiUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_RelCCSymptomHpiUid]  DEFAULT (newid()),
	[RelCCSymptomHpiCategoryUid] [uniqueidentifier] NOT NULL,
	[HpiUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[ProcedurePerformed] [bit] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_ProcedurePerformed]  DEFAULT ((1)),
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DiagnosisDescription] [varchar](255) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hpi id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi', @level2type=N'COLUMN',@level2name=N'HpiUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'sequence' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'age group 1: adult; 2: child < 18' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi', @level2type=N'COLUMN',@level2name=N'AgeGroupUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPI description list of the CC symptom' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi'


END
Truncate Table migtemp_RelCCSymptomHpi
INSERT [migtemp_RelCCSymptomHpi]([RelCCSymptomHpiUid],[RelCCSymptomHpiCategoryUid],[HpiUid],[DisplayOrder],[AgeGroupUid],[SnomedConceptID],[DescriptionUid],[UserDefined],[ClinicCenterOverride],[ProviderOverride],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelCCSymptomHpiUid],[RelCCSymptomHpiCategoryUid],[HpiUid],[DisplayOrder],[AgeGroupUid],[SnomedConceptID],[DescriptionUid],[UserDefined],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LastModifiedByUid],[LastModifiedDate]
FROM [RelCCSymptomHpi]

DROP TABLE [RelCCSymptomHpi]

exec  sp_rename 'migtemp_RelCCSymptomHpi', 'RelCCSymptomHpi'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelCCSymptomHpiCategory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelCCSymptomHpiCategory](
	[RelCCSymptomHpiCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_RelCCSymptomHpiCategoryUid]  DEFAULT (newid()),
	[RelCCSystemSymptomUid] [uniqueidentifier] NOT NULL,
	[HpiCategoryUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_UserDefined]  DEFAULT ((1)),
	[NaturalLanguage] [varchar](100) NULL,
	[SingleSelect] [bit] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_SingleSelect]  DEFAULT ((0)),
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'HpiCategoryUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'AgeGroupUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hpi category list of the CC symptom' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory'


END
Truncate Table migtemp_RelCCSymptomHpiCategory
INSERT [migtemp_RelCCSymptomHpiCategory]([RelCCSymptomHpiCategoryUid],[RelCCSystemSymptomUid],[HpiCategoryUid],[DisplayOrder],[AgeGroupUid],[UserDefined],[NaturalLanguage],[ClinicCenterOverride],[ProviderOverride],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelCCSymptomHpiCategoryUid],[RelCCSystemSymptomUid],[HpiCategoryUid],[DisplayOrder],[AgeGroupUid],[UserDefined],[NaturalLanguage],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LastModifiedByUid],[LastModifiedDate]
FROM [RelCCSymptomHpiCategory]

DROP TABLE [RelCCSymptomHpiCategory]

exec  sp_rename 'migtemp_RelCCSymptomHpiCategory', 'RelCCSymptomHpiCategory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelCCSystemSymptom]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelCCSystemSymptom](
	[RelCCSystemSymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_RelCCSystemSymptomUid]  DEFAULT (newid()),
	[CCSystemUid] [uniqueidentifier] NOT NULL,
	[CCSymptomUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_UserDefined]  DEFAULT ((1)),
	[Preposition] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_Inactive]  DEFAULT ((0)),
	[ShortcutRelCCSystemSymptomUid] [uniqueidentifier] NULL,
	[LicenseCode] [varchar](50) NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverrideCC]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverrideCC]) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DiagnosisDescription] [varchar](255) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'System ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'CCSystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Symptom ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'CCSymptomUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Seq (Order)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Age Group (1: > 18yrs; 2: <= 18 yrs)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'AgeGroupUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CC list associates with the body system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom'


END
Truncate Table migtemp_RelCCSystemSymptom
INSERT [migtemp_RelCCSystemSymptom]([RelCCSystemSymptomUid],[CCSystemUid],[CCSymptomUid],[DisplayOrder],[AgeGroupUid],[UserDefined],[Preposition],[Inactive],[ShortcutRelCCSystemSymptomUid],[LicenseCode],[ClinicCenterOverride],[ProviderOverride],[SnomedConceptID],[DescriptionUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelCCSystemSymptomUid],[CCSystemUid],[CCSymptomUid],[DisplayOrder],[AgeGroupUid],[UserDefined],[Preposition],[Inactive],[ShortcutRelCCSystemSymptomUid],[LicenseCode],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[SnomedConceptID],[DescriptionUid],[LastModifiedByUid],[LastModifiedDate]
FROM [RelCCSystemSymptom]

DROP TABLE [RelCCSystemSymptom]

exec  sp_rename 'migtemp_RelCCSystemSymptom', 'RelCCSystemSymptom'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelChargeTicketCategoryDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelChargeTicketCategoryDiagnosis](
	[RelChargeTicketCategoryDiagnosisUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelChargeTicketCategoryDiagnosisUid_RelChargeTicketCategoryDiagnosisUid]  DEFAULT (newid()),
	[ChargeTicketDiagnosisUid] [uniqueidentifier] NOT NULL,
	[DiagnosisCategoryUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategoryDiagnosisUid_DisplayOrder]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategoryDiagnosisUid_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketCategoryDiagnosisUid_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'charge ticket id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategoryDiagnosis', @level2type=N'COLUMN',@level2name=N'ChargeTicketDiagnosisUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'category id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategoryDiagnosis', @level2type=N'COLUMN',@level2name=N'DiagnosisCategoryUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategoryDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategoryDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategoryDiagnosis'


END
Truncate Table migtemp_RelChargeTicketCategoryDiagnosis
INSERT [migtemp_RelChargeTicketCategoryDiagnosis]([RelChargeTicketCategoryDiagnosisUid],[ChargeTicketDiagnosisUid],[DiagnosisCategoryUid],[DisplayOrder],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelChargeTicketCategoryDiagnosisUid],[ChargeTicketDiagnosisUid],[DiagnosisCategoryUid],[DisplayOrder],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [RelChargeTicketCategoryDiagnosis]

DROP TABLE [RelChargeTicketCategoryDiagnosis]

exec  sp_rename 'migtemp_RelChargeTicketCategoryDiagnosis', 'RelChargeTicketCategoryDiagnosis'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelChargeTicketCategorySO]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelChargeTicketCategorySO](
	[RelChargeTicketCategorySOUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySO_RelChargeTicketCategorySOUid]  DEFAULT (newid()),
	[ChargeTicketSOUid] [uniqueidentifier] NULL,
	[ProcedureCategoryUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySO_DisplayOrder]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySO_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySO_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'charge ticket id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategorySO', @level2type=N'COLUMN',@level2name=N'ChargeTicketSOUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'category id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategorySO', @level2type=N'COLUMN',@level2name=N'ProcedureCategoryUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategorySO'


END
Truncate Table migtemp_RelChargeTicketCategorySO
INSERT [migtemp_RelChargeTicketCategorySO]([RelChargeTicketCategorySOUid],[ChargeTicketSOUid],[ProcedureCategoryUid],[DisplayOrder],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelChargeTicketCategorySOUid],[ChargeTicketSOUid],[ProcedureCategoryUid],[DisplayOrder],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [RelChargeTicketCategorySO]

DROP TABLE [RelChargeTicketCategorySO]

exec  sp_rename 'migtemp_RelChargeTicketCategorySO', 'RelChargeTicketCategorySO'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelChargeTicketCategorySP]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelChargeTicketCategorySP](
	[RelChargeTicketCategorySPUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Table_1_RelChargeTicketSPUid]  DEFAULT (newid()),
	[ChargeTicketSPUid] [uniqueidentifier] NULL,
	[ProcedureCategoryUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySP_DisplayOrder]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySP_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketCategorySP_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategorySP', @level2type=N'COLUMN',@level2name=N'RelChargeTicketCategorySPUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'charge ticket id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategorySP', @level2type=N'COLUMN',@level2name=N'ChargeTicketSPUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'category id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategorySP', @level2type=N'COLUMN',@level2name=N'ProcedureCategoryUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategorySP', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategorySP', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketCategorySP'


END
Truncate Table migtemp_RelChargeTicketCategorySP
INSERT [migtemp_RelChargeTicketCategorySP]([RelChargeTicketCategorySPUid],[ChargeTicketSPUid],[ProcedureCategoryUid],[DisplayOrder],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelChargeTicketCategorySPUid],[ChargeTicketSPUid],[ProcedureCategoryUid],[DisplayOrder],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [RelChargeTicketCategorySP]

DROP TABLE [RelChargeTicketCategorySP]

exec  sp_rename 'migtemp_RelChargeTicketCategorySP', 'RelChargeTicketCategorySP'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelChargeTicketDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelChargeTicketDiagnosis](
	[RelChargeTicketDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_RelChargeTicketDiagnosisUid]  DEFAULT (newid()),
	[RelChargeTicketCategoryDiagnosisUid] [uniqueidentifier] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[SearchDefinition] [varchar](800) NULL,
	[DiagnosisPanelUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_Inactive]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketDiagnosis_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketDiagnosis', @level2type=N'COLUMN',@level2name=N'RelChargeTicketDiagnosisUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketDiagnosis', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ICD9 charge ticket detail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketDiagnosis'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketDiagnosis'


END
Truncate Table migtemp_RelChargeTicketDiagnosis
INSERT [migtemp_RelChargeTicketDiagnosis]([RelChargeTicketDiagnosisUid],[RelChargeTicketCategoryDiagnosisUid],[Code9],[Code10],[CodeDescription],[SearchDefinition],[DiagnosisPanelUid],[DisplayOrder],[SnomedCTConceptId],[Inactive],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelChargeTicketDiagnosisUid],[RelChargeTicketCategoryDiagnosisUid],[Code9],[Code10],[CodeDescription],[SearchDefinition],[DiagnosisPanelUid],[DisplayOrder],[SnomedCTConceptId],[Inactive],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [RelChargeTicketDiagnosis]

DROP TABLE [RelChargeTicketDiagnosis]

exec  sp_rename 'migtemp_RelChargeTicketDiagnosis', 'RelChargeTicketDiagnosis'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelChargeTicketSO]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelChargeTicketSO](
	[RelChargeTicketSOUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelChargeTicketSO_RelChargeTicketSOUid]  DEFAULT (newid()),
	[RelChargeTicketCategorySOUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[ProcedurePanelUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketSO_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelChargeTicketSO_Inactive]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketSO_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketSO_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'SO procedure id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSO', @level2type=N'COLUMN',@level2name=N'ProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'SO charge ticket detail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSO'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSO'


END
Truncate Table migtemp_RelChargeTicketSO
INSERT [migtemp_RelChargeTicketSO]([RelChargeTicketSOUid],[RelChargeTicketCategorySOUid],[ProcedureUid],[ProcedurePanelUid],[DisplayOrder],[Inactive],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelChargeTicketSOUid],[RelChargeTicketCategorySOUid],[ProcedureUid],[ProcedurePanelUid],[DisplayOrder],[Inactive],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [RelChargeTicketSO]

DROP TABLE [RelChargeTicketSO]

exec  sp_rename 'migtemp_RelChargeTicketSO', 'RelChargeTicketSO'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelChargeTicketSP]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelChargeTicketSP](
	[RelChargeTicketSPUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelChargeTicketSP_RelChargeTicketSPUid]  DEFAULT (newid()),
	[RelChargeTicketCategorySPUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[ProcedurePanelUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_RelChargeTicketSP_DisplayOrder]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelChargeTicketSP_Inactive]  DEFAULT ((0)),
	[Color] [int] NULL,
	[Font] [varchar](50) NULL,
	[Size] [float] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelChargeTicketSP_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelChargeTicketSP_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSP', @level2type=N'COLUMN',@level2name=N'RelChargeTicketSPUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'SP procedure id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSP', @level2type=N'COLUMN',@level2name=N'ProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSP', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSP', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSP', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'SP charge ticket detail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSP'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelChargeTicketSP'


END
Truncate Table migtemp_RelChargeTicketSP
INSERT [migtemp_RelChargeTicketSP]([RelChargeTicketSPUid],[RelChargeTicketCategorySPUid],[ProcedureUid],[ProcedurePanelUid],[DisplayOrder],[Inactive],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelChargeTicketSPUid],[RelChargeTicketCategorySPUid],[ProcedureUid],[ProcedurePanelUid],[DisplayOrder],[Inactive],[Color],[Font],[Size],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [RelChargeTicketSP]

DROP TABLE [RelChargeTicketSP]

exec  sp_rename 'migtemp_RelChargeTicketSP', 'RelChargeTicketSP'

exec sp_dropDF
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelDiagnosisDpn', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelDiagnosisDpn'
GO
BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RelFindTableMFUDiagnosis' AND COLUMN_NAME = 'LexCode')
ALTER TABLE [RelFindTableMFUDiagnosis]  ALTER COLUMN [LexCode] bigint NOT NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RelFindTableMRUDiagnosis' AND COLUMN_NAME = 'LexCode')
ALTER TABLE [RelFindTableMRUDiagnosis]  ALTER COLUMN [LexCode] bigint NOT NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelGroupAppointmentPatient]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelGroupAppointmentPatient](
	[RelGroupAppointmentPatientUid] [uniqueidentifier] NOT NULL,
	[AppointmentUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[AppointmentStatusUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[PatientGroupUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_RelGroupAppointmentPatient] ADD  CONSTRAINT [DF_RelGroupAppointmentPatient_RelGroupAppointmentPatientUid]  DEFAULT (newid()) FOR [RelGroupAppointmentPatientUid]
ALTER TABLE [migtemp_RelGroupAppointmentPatient] ADD  CONSTRAINT [DF_RelGroupAppointmentPatient_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelGroupAppointmentPatient
INSERT [migtemp_RelGroupAppointmentPatient]([RelGroupAppointmentPatientUid],[AppointmentUid],[PatientUid],[AppointmentStatusUid],[AccountUid],[LastModifiedDate],[LastModifiedByUid],[PatientGroupUid])
SELECT [RelGroupAppointmentPatientUid],[AppointmentUid],[PatientUid],[AppointmentStatusUid],[AccountUid],[LastModifiedDate],[LastModifiedByUid],[PatientGroupUid]
FROM [RelGroupAppointmentPatient]

DROP TABLE [RelGroupAppointmentPatient]

exec  sp_rename 'migtemp_RelGroupAppointmentPatient', 'RelGroupAppointmentPatient'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelMedicationProblem]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelMedicationProblem](
	[RelMedicationProblemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[DiseaseUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[Inactive] [bit] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_RelMedicationProblem] ADD  CONSTRAINT [DF_RelMedicationProblem_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_RelMedicationProblem] ADD  CONSTRAINT [DF_RelMedicationProblem_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_RelMedicationProblem] ADD  CONSTRAINT [DF_RelMedicationProblem_IsDelete]  DEFAULT ((0)) FOR [IsDelete]

END
Truncate Table migtemp_RelMedicationProblem
INSERT [migtemp_RelMedicationProblem]([RelMedicationProblemUid],[MedicationSIGUid],[DiseaseUid],[DisplayOrder],[SnomedCTConceptId],[Inactive],[IsDelete],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelMedicationProblemUid],[MedicationSIGUid],[DiseaseUid],[DisplayOrder],[SnomedCTConceptId],[Inactive],[IsDelete],[LastModifiedByUid],[LastModifiedDate]
FROM [RelMedicationProblem]

DROP TABLE [RelMedicationProblem]

exec  sp_rename 'migtemp_RelMedicationProblem', 'RelMedicationProblem'

exec sp_dropDF
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelMedicationStateScheduledDrugName', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelMedicationStateScheduledDrugName'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'ObservationViewOptionUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'ObservationViewOptionUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LaboratoryUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'DisplayOrder'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'Inactive'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'ObservationViewOptionUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'View Option Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'ObservationViewOptionUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LaboratoryUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'laboratory id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'DisplayOrder'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'display order' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'Inactive'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 = Inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'getutcdate() for LastModifiedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelPatientCondition]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelPatientCondition](
	[RelPatientConditionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientConditionUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_RelPatientCondition] ADD  CONSTRAINT [DF_RelPatientCondition_RelPatientConditionUid]  DEFAULT (newid()) FOR [RelPatientConditionUid]
ALTER TABLE [migtemp_RelPatientCondition] ADD  CONSTRAINT [DF_RelPatientCondition_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_RelPatientCondition] ADD  CONSTRAINT [DF_RelPatientCondition_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelPatientCondition
INSERT [migtemp_RelPatientCondition]([RelPatientConditionUid],[PatientUid],[PatientConditionUid],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelPatientConditionUid],[PatientUid],[PatientConditionUid],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate]
FROM [RelPatientCondition]

DROP TABLE [RelPatientCondition]

exec  sp_rename 'migtemp_RelPatientCondition', 'RelPatientCondition'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelPatientMedication]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelPatientMedication](
	[RelPatientMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPatientMedication_RelPatientMedicationUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[RelVisitMedicationUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ActiveDate] [date] NULL CONSTRAINT [DF_RelPatientMedication_ActiveTime]  DEFAULT (getdate()),
	[InactiveDate] [date] NULL,
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_RelPatientMedication_IsPatientInput]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[EnteredFromVisitUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPatientMedication_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ActiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPatientMedication', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'InactiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPatientMedication', @level2type=N'COLUMN',@level2name=N'InactiveDate'


END
Truncate Table migtemp_RelPatientMedication
INSERT [migtemp_RelPatientMedication]([RelPatientMedicationUid],[MedicationSIGUid],[RelVisitMedicationUid],[PatientUid],[ActiveDate],[InactiveDate],[IsPatientInput],[Notes],[EnteredFromVisitUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelPatientMedicationUid],[MedicationSIGUid],[RelVisitMedicationUid],[PatientUid],[ActiveDate],[InactiveDate],[IsPatientInput],[Notes],[EnteredFromVisitUid],[LastModifiedByUid],[LastModifiedDate]
FROM [RelPatientMedication]

DROP TABLE [RelPatientMedication]

exec  sp_rename 'migtemp_RelPatientMedication', 'RelPatientMedication'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelPatientPersonWeb]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelPatientPersonWeb](
	[RelPatientPersonWebUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelPatientPersonWeb_RelPatientPersonWebUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[IgnoreAge] [bit] NOT NULL CONSTRAINT [DF_RelPatientPersonWeb_IgnoreAge]  DEFAULT ((0)),
	[Inactive] [smallint] NOT NULL CONSTRAINT [DF_RelPatientPersonWeb_Inactive]  DEFAULT ((0)),
	[PersonContactUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 - False; 1 - True; 2 - Deactivated_Due_To_Age; 3 - Deactivated_From_Contact; 4 - Deactivated_From_RP;' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPatientPersonWeb', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" /><Deactivated_Due_To_Age value="2" /><Deactivated_From_Contact value="3" /><Deactivated_From_RP value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPatientPersonWeb'


END
Truncate Table migtemp_RelPatientPersonWeb
INSERT [migtemp_RelPatientPersonWeb]([RelPatientPersonWebUid],[PersonUid],[PatientUid],[Inactive],[PersonContactUid],[LastModifiedDate],[LastModifiedByUid])
SELECT [RelPatientPersonWebUid],[PersonUid],[PatientUid],[Inactive],[PersonContactUid],[LastModifiedDate],[LastModifiedByUid]
FROM [RelPatientPersonWeb]

DROP TABLE [RelPatientPersonWeb]

exec  sp_rename 'migtemp_RelPatientPersonWeb', 'RelPatientPersonWeb'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientProgramPersonWeb]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientProgramPersonWeb](
	[RelPatientProgramPersonWebUid] [uniqueidentifier] NOT NULL,
	[PatientProgramUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[Inactive] [smallint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'

ALTER TABLE [RelPatientProgramPersonWeb] ADD  CONSTRAINT [DF_RelPatientProgramPersonWeb_Inactive]  DEFAULT ((0)) FOR [Inactive]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelPETemplateDescription]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelPETemplateDescription](
	[RelPETemplateDescriptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPETemplateDescription_RelPETemplateDescriptionUid]  DEFAULT (newid()),
	[RelPETemplateSymptomUid] [uniqueidentifier] NOT NULL,
	[PEDescriptionUid] [uniqueidentifier] NOT NULL,
	[RelEMKeyComponentBulletUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[NormalFlag] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_NormalFlag]  DEFAULT ((0)),
	[DefaultFlag] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_DefaultFlag]  DEFAULT ((0)),
	[CountAsBullet] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_CountAsBullet]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverridePE]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverridePE]) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_LifeLong_1]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPETemplateDescription'


END
Truncate Table migtemp_RelPETemplateDescription
INSERT [migtemp_RelPETemplateDescription]([RelPETemplateDescriptionUid],[RelPETemplateSymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[NormalFlag],[DefaultFlag],[CountAsBullet],[UserDefined],[ClinicCenterOverride],[ProviderOverride],[SnomedConceptID],[DescriptionUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelPETemplateDescriptionUid],[RelPETemplateSymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[NormalFlag],[DefaultFlag],[CountAsBullet],[UserDefined],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[SnomedConceptID],[DescriptionUid],[LastModifiedByUid],[LastModifiedDate]
FROM [RelPETemplateDescription]

DROP TABLE [RelPETemplateDescription]

exec  sp_rename 'migtemp_RelPETemplateDescription', 'RelPETemplateDescription'

exec sp_dropDF
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelPlanProviderDiagnosis', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPlanProviderDiagnosis'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelPracticeFormPatient]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelPracticeFormPatient](
	[RelPracticeFormPatientUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PracticeFormUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[EffectiveDate] [datetime] NOT NULL,
	[ExpirationDate] [date] NULL,
	[LastViewedByPortalDate] [datetime] NULL,
	[LastDownloadedByPortalDate] [datetime] NULL,
	[LastUploadedByPortalDate] [datetime] NULL,
	[UploadedAttachmentGroupUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[MessageAAUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_RelPracticeFormPatient] ADD  CONSTRAINT [DF_RelPracticeFormPatient_RelPracticeFormPatientUid]  DEFAULT (newid()) FOR [RelPracticeFormPatientUid]
ALTER TABLE [migtemp_RelPracticeFormPatient] ADD  CONSTRAINT [DF_RelPracticeFormPatient_EffectiveDate]  DEFAULT (getutcdate()) FOR [EffectiveDate]
ALTER TABLE [migtemp_RelPracticeFormPatient] ADD  CONSTRAINT [DF_RelPracticeFormPatient_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelPracticeFormPatient
INSERT [migtemp_RelPracticeFormPatient]([RelPracticeFormPatientUid],[PracticeFormUid],[PersonUid],[EffectiveDate],[ExpirationDate],[LastViewedByPortalDate],[LastDownloadedByPortalDate],[LastUploadedByPortalDate],[UploadedAttachmentGroupUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelPracticeFormPatientUid],[PracticeFormUid],[PersonUid],[EffectiveDate],[ExpirationDate],[LastViewedByPortalDate],[LastDownloadedByPortalDate],[LastUploadedByPortalDate],[UploadedAttachmentGroupUid],[LastModifiedByUid],[LastModifiedDate]
FROM [RelPracticeFormPatient]

DROP TABLE [RelPracticeFormPatient]

exec  sp_rename 'migtemp_RelPracticeFormPatient', 'RelPracticeFormPatient'

exec sp_dropDF
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelProcedureHistoryTermProcedure', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelProcedureHistoryTermProcedure'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelProcedureTypeofVaccine]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelProcedureTypeofVaccine](
	[RelProcedureTypeofVaccineUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelProcedureTypeofVaccine_RelProcedureTypeofVaccineUid]  DEFAULT (newid()),
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[TypeofVaccineUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelProcedureTypeofVaccine_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProcedureTypeofVaccine_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'cpt id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelProcedureTypeofVaccine', @level2type=N'COLUMN',@level2name=N'ProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'type of vaccine id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelProcedureTypeofVaccine', @level2type=N'COLUMN',@level2name=N'TypeofVaccineUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelProcedureTypeofVaccine'


END
Truncate Table migtemp_RelProcedureTypeofVaccine
INSERT [migtemp_RelProcedureTypeofVaccine]([RelProcedureTypeofVaccineUid],[ProcedureUid],[TypeofVaccineUid],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelProcedureTypeofVaccineUid],[ProcedureUid],[TypeofVaccineUid],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [RelProcedureTypeofVaccine]

DROP TABLE [RelProcedureTypeofVaccine]

exec  sp_rename 'migtemp_RelProcedureTypeofVaccine', 'RelProcedureTypeofVaccine'

exec sp_dropDF
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelQuestionAnswerSnomed', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelQuestionAnswerSnomed'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelRosSystemSymptom]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelRosSystemSymptom](
	[RelRosSystemSymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_RelRosSystemSymptomUid]  DEFAULT (newid()),
	[RosSystemUid] [uniqueidentifier] NOT NULL,
	[RosSymptomUid] [uniqueidentifier] NOT NULL,
	[DenyFlag] [bit] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_Inactive]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverrideRos]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverrideRos]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ros system id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom', @level2type=N'COLUMN',@level2name=N'RosSystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ros symptom id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom', @level2type=N'COLUMN',@level2name=N'RosSymptomUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'To indicate if this item is for ROS deny list. For v44, this is 
from kdb_dict_normal. In V50, we merge into the same table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom', @level2type=N'COLUMN',@level2name=N'DenyFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Ros System Symptom mapping' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom'


END
Truncate Table migtemp_RelRosSystemSymptom
INSERT [migtemp_RelRosSystemSymptom]([RelRosSystemSymptomUid],[RosSystemUid],[RosSymptomUid],[DenyFlag],[DisplayOrder],[AgeGroupUid],[UserDefined],[Inactive],[ClinicCenterOverride],[ProviderOverride],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelRosSystemSymptomUid],[RosSystemUid],[RosSymptomUid],[DenyFlag],[DisplayOrder],[AgeGroupUid],[UserDefined],[Inactive],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LastModifiedByUid],[LastModifiedDate]
FROM [RelRosSystemSymptom]

DROP TABLE [RelRosSystemSymptom]

exec  sp_rename 'migtemp_RelRosSystemSymptom', 'RelRosSystemSymptom'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelServiceSitePersonWeb]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelServiceSitePersonWeb](
	[RelServiceSitePersonWebUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[Inactive] [smallint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'

ALTER TABLE [RelServiceSitePersonWeb] ADD  CONSTRAINT [DF_RelServiceSitePersonWeb_Inactive]  DEFAULT ((0)) FOR [Inactive]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelVisitMedication]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelVisitMedication](
	[RelVisitMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelVisitMedication_RelVisitMedicationUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[eRxStatusUid] [uniqueidentifier] NULL,
	[eRxEligibilityDownLoadDate] [datetime] NULL,
	[ReadyToPrescribe] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_ReadyToPrescribe]  DEFAULT ((0)),
	[Prescribed] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_MarkAsPrescribed]  DEFAULT ((0)),
	[ConsentCreated] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_ConsentCreated]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[ReprintReason] [varchar](max) NULL,
	[eRxRequest] [xml](CONTENT [dbo].[eRxRequestXML]) NULL,
	[PreviousData] [xml](CONTENT [dbo].[PreviousData]) NULL,
	[DigitalSignatureXML] [xml] NULL,
	[FormularyXML] [xml](CONTENT [dbo].[FormularyData]) NULL,
	[FulfillmentMethod] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_FulfillmentMethod]  DEFAULT ((0)),
	[FulfillmentDateTime] [datetime] NULL,
	[FulfillmentSequentialNumber] [int] NULL,
	[ScriptSave] [bit] NULL CONSTRAINT [DF_RelVisitMedication_ScriptSave]  DEFAULT ((0)),
	[ePAStatus] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_ePASentRequest]  DEFAULT ((0)),
	[ePAMessageID] [varchar](50) NULL,
	[ePAResults] [varchar](max) NULL,
	[SpoStatus] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_SpoStatus]  DEFAULT ((0)),
	[SpoRequest] [varchar](max) NULL,
	[SpoResponse] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelVisitMedication_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'ePAStatus', @value=N'<None value ="0"/><Ready value="1"/><Sent value="2"/><Error value="3"/><Acknowledged value="4"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'FulfillmentMethod', @value=N'<None value="0" /><ePrescribe value="1" /><Fax value="2" /><Print value="3" /><SampleGiven value="4" /><Administered value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_RelVisitMedication_Visit' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'SpoStatus', @value=N'<None value ="0"/><Ready value="1"/><Sent value="2"/><Error value="3"/><Acknowledged value="4"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'


END
Truncate Table migtemp_RelVisitMedication
INSERT [migtemp_RelVisitMedication]([RelVisitMedicationUid],[MedicationSIGUid],[VisitUid],[VisitProcedureUid],[eRxStatusUid],[eRxEligibilityDownLoadDate],[ReadyToPrescribe],[Prescribed],[ConsentCreated],[Notes],[ReprintReason],[eRxRequest],[PreviousData],[DigitalSignatureXML],[FormularyXML],[FulfillmentMethod],[FulfillmentDateTime],[FulfillmentSequentialNumber],[ScriptSave],[ePAStatus],[ePAMessageID],[ePAResults],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelVisitMedicationUid],[MedicationSIGUid],[VisitUid],[VisitProcedureUid],[eRxStatusUid],[eRxEligibilityDownLoadDate],[ReadyToPrescribe],[Prescribed],[ConsentCreated],[Notes],[ReprintReason],CONVERT(nvarchar(max), [eRxRequest]),CONVERT(nvarchar(max), [PreviousData]),CONVERT(nvarchar(max), [DigitalSignatureXML]),CONVERT(nvarchar(max), [FormularyXML]),[FulfillmentMethod],[FulfillmentDateTime],[FulfillmentSequentialNumber],[ScriptSave],[ePAStatus],[ePAMessageID],[ePAResults],[LastModifiedByUid],[LastModifiedDate]
FROM [RelVisitMedication]

DROP TABLE [RelVisitMedication]

exec  sp_rename 'migtemp_RelVisitMedication', 'RelVisitMedication'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerationStatus' , N'SCHEMA',N'dbo', N'TABLE',N'RelVisitSuperbillGeneration', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'GenerationStatus' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelVisitSuperbillGeneration'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'RelVisitSuperbillGeneration', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ToAvoid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelVisitSuperbillGeneration'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'RelVisitSuperbillGeneration', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelVisitSuperbillGeneration'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerationStatus' , N'SCHEMA',N'dbo', N'TABLE',N'RelVisitSuperbillGeneration', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerationStatus', @value=N'<Success value="0" /><FailedSingle value="1" /><FailedMultiple value="2" /><InProgress value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelVisitSuperbillGeneration'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'RelVisitSuperbillGeneration', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelVisitSuperbillGeneration'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ToAvoid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', N'COLUMN',N'FinancialCenterUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch', @level2type=N'COLUMN',@level2name=N'FinancialCenterUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Statement batches in which many statements are generated during a statement run.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_StatementBatchDetail_StatementBatch' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', N'COLUMN',N'FinancialCenterUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch', @level2type=N'COLUMN',@level2name=N'FinancialCenterUid'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_StatementBatchDetail]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_StatementBatchDetail](
	[StatementBatchDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_StatementBatchDetail_StatementBatchDetailUid]  DEFAULT (newid()),
	[StatementBatchUid] [uniqueidentifier] NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[DunningLevel] [smallint] NOT NULL CONSTRAINT [DF_StatementBatchDetail_DunningLevel]  DEFAULT ((0)),
	[AccessCode] [varchar](25) NULL,
	[StatementXml] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_StatementBatchDetail_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[AttachmentUid] [uniqueidentifier] NULL,
	[StatementDate] [date] NULL,
	[CompletionStatus] [smallint] NOT NULL CONSTRAINT [DF_StatementBatchDetail_CompletionStatus]  DEFAULT ((0)),
	[OnDemand] [smallint] NOT NULL CONSTRAINT [DF_StatementBatchDetail_OnDemand]  DEFAULT ((0)),
	[FirstViewed] [datetime] NULL,
	[LastViewed] [datetime] NULL,
	[StatementXmlDate] [date] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'CompletionStatus', @value=N'<None value="0" /><Printed value="1" /><PortalOnly value="2" /><Etactics value="3" /><PracticeInsight value="4" /><Excluded value="99" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_StatementBatchDetail'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Individual responsible-party statements in a statement batch' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_StatementBatchDetail'
EXEC sys.sp_addextendedproperty @name=N'OnDemand', @value=N'<None value="0" /><All value="1" /><MainAccountOnly value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_StatementBatchDetail'
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_StatementBatchDetail'


END
Truncate Table migtemp_StatementBatchDetail
INSERT [migtemp_StatementBatchDetail]([StatementBatchDetailUid],[StatementBatchUid],[AccountResponsiblePartyUid],[DunningLevel],[StatementXml],[LastModifiedDate],[LastModifiedByUid],[FinancialCenterUid],[AttachmentUid],[StatementDate],[CompletionStatus],[OnDemand],[FirstViewed],[LastViewed],[StatementXmlDate])
SELECT [StatementBatchDetailUid],[StatementBatchUid],[AccountResponsiblePartyUid],[DunningLevel],[StatementXml],[LastModifiedDate],[LastModifiedByUid],[FinancialCenterUid],[AttachmentUid],[StatementDate],[CompletionStatus],[OnDemand],[FirstViewed],[LastViewed],[StatementXmlDate]
FROM [StatementBatchDetail]

DROP TABLE [StatementBatchDetail]

exec  sp_rename 'migtemp_StatementBatchDetail', 'StatementBatchDetail'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetailSuperbill', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ToAvoid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetailSuperbill'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetailSuperbill', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetailSuperbill'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetailSuperbill', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetailSuperbill'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_SubFindTable]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_SubFindTable](
	[SubFindTableUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SubFindTable_SubFindTableUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_SubFindTable_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[FindTableUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_SubFindTable_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SubFindTable_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_SubFindTable'


END
Truncate Table migtemp_SubFindTable
INSERT [migtemp_SubFindTable]([SubFindTableUid],[ExternalID],[Inactive],[Name],[FindTableUid],[Notes],[LastModifiedByUid],[LastModifiedDate])
SELECT [SubFindTableUid],[ExternalID],[Inactive],[Name],[FindTableUid],[Notes],[LastModifiedByUid],[LastModifiedDate]
FROM [SubFindTable]

DROP TABLE [SubFindTable]

exec  sp_rename 'migtemp_SubFindTable', 'SubFindTable'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_SubFindTableItem]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_SubFindTableItem](
	[SubFindTableItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SubFindTableItem_SubFindTableItemUid]  DEFAULT (newid()),
	[SubFindTableUid] [uniqueidentifier] NOT NULL,
	[ItemUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_SubFindTableItem_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SubFindTableItem_LastModifiedDate]  DEFAULT (getutcdate()),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_SubFindTableItem_DisplayOrder]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_SubFindTableItem'


END
Truncate Table migtemp_SubFindTableItem
INSERT [migtemp_SubFindTableItem]([SubFindTableItemUid],[SubFindTableUid],[ItemUid],[Name],[LastModifiedByUid],[LastModifiedDate],[DisplayOrder])
SELECT [SubFindTableItemUid],[SubFindTableUid],[ItemUid],[Name],[LastModifiedByUid],[LastModifiedDate],[DisplayOrder]
FROM [SubFindTableItem]

DROP TABLE [SubFindTableItem]

exec  sp_rename 'migtemp_SubFindTableItem', 'SubFindTableItem'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_TransmissionOutbound]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_TransmissionOutbound](
	[TransmissionOutboundUid] [uniqueidentifier] NOT NULL,
	[TransmissionType] [varchar](50) NOT NULL,
	[Status] [smallint] NOT NULL,
	[Description] [varchar](1000) NULL,
	[RawMessage] [varchar](max) NULL,
	[TransmissionControlXML] [xml] NULL,
	[ForeignObjectUid] [uniqueidentifier] NULL,
	[EnqueuedTimestamp] [datetime] NOT NULL,
	[NextSendAttempt] [datetime] NOT NULL,
	[LastTransmissionAttempt] [datetime] NULL,
	[NumberOfTransmissionAttempts] [int] NOT NULL,
	[SuccessfulTransmissionTimestamp] [datetime] NULL,
	[LastError] [varchar](max) NULL,
	[IntermediateGenerationData] [varchar](max) NULL,
	[StatusHistory] [varchar](max) NULL,
	[ExternalStatus] [varchar](1000) NULL,
	[ExternalStatusDescription] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionOutbound'
EXEC sys.sp_addextendedproperty @name=N'Replication.Sequence', @value=N'8410' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionOutbound'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionOutbound'
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<Unprocessed value="0" /> <ReadyToTransmit value="25" /> <TransmissionFailed value="35" /> <Transmitted value="50" /> <Successful value="100" />  <Failed value="500" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionOutbound'

ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_TransmissionOutbound_TransmissionOutboundUid]  DEFAULT (newid()) FOR [TransmissionOutboundUid]
ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_TransmissionOutbound_Status]  DEFAULT ((0)) FOR [Status]
ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_Table_1_InitialQueueTimestamp]  DEFAULT (getutcdate()) FOR [EnqueuedTimestamp]
ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_TransmissionOutbound_NextSendAttempt]  DEFAULT (getutcdate()) FOR [NextSendAttempt]
ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_TransmissionOutbound_NumberOfTransmissionAttempts]  DEFAULT ((0)) FOR [NumberOfTransmissionAttempts]

END
Truncate Table migtemp_TransmissionOutbound
INSERT [migtemp_TransmissionOutbound]([TransmissionOutboundUid],[TransmissionType],[Status],[Description],[RawMessage],[TransmissionControlXML],[ForeignObjectUid],[EnqueuedTimestamp],[NextSendAttempt],[LastTransmissionAttempt],[NumberOfTransmissionAttempts],[SuccessfulTransmissionTimestamp],[LastError],[IntermediateGenerationData],[StatusHistory],[ExternalStatus],[ExternalStatusDescription],[LastModifiedDate],[LastModifiedByUid],[ProviderUid],[PatientUid],[ServiceSiteUid])
SELECT [TransmissionOutboundUid],[TransmissionType],[Status],[Description],[RawMessage],CONVERT(nvarchar(max), [TransmissionControlXML]),[ForeignObjectUid],[EnqueuedTimestamp],[NextSendAttempt],[LastTransmissionAttempt],[NumberOfTransmissionAttempts],[SuccessfulTransmissionTimestamp],[LastError],[IntermediateGenerationData],[StatusHistory],[ExternalStatus],[ExternalStatusDescription],[LastModifiedDate],[LastModifiedByUid],[ProviderUid],[PatientUid],[ServiceSiteUid]
FROM [TransmissionOutbound]

DROP TABLE [TransmissionOutbound]

exec  sp_rename 'migtemp_TransmissionOutbound', 'TransmissionOutbound'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_UB04Claim]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_UB04Claim](
	[UB04ClaimUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SuperBillUId] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[ProviderUId] [uniqueidentifier] NULL,
	[FileAsGroup] [bit] NULL,
	[SendNPI] [bit] NULL,
	[ProviderName_FL1] [varchar](200) NULL,
	[ProviderAddress1_FL1] [varchar](200) NULL,
	[ProviderAddress2_FL1] [varchar](200) NULL,
	[ProviderCity_FL1] [varchar](25) NULL,
	[ProviderState_FL1] [varchar](3) NULL,
	[ProviderZip_FL1] [varchar](10) NULL,
	[ProviderPhone_FL1] [varchar](22) NULL,
	[PatientControlNumber_FL3a] [varchar](25) NULL,
	[MedicalRecordNumber_FL3b] [varchar](25) NULL,
	[TypeOfBill_FL4] [varchar](5) NULL,
	[FederalTaxID_FL5] [varchar](25) NULL,
	[StatementCoversPeriod_FL6From] [varchar](10) NULL,
	[StatementCoversPeriod_FL6To] [varchar](10) NULL,
	[PatientName_FL8b] [varchar](200) NULL,
	[PatientAddressStreet_FL9a] [varchar](200) NULL,
	[PatientAddressCity_FL9b] [varchar](25) NULL,
	[PatientAddressState_FL9c] [varchar](3) NULL,
	[PatientAddressZip_FL9d] [varchar](10) NULL,
	[PatientBirthDate_FL10] [varchar](10) NULL,
	[PatientSex_FL11] [varchar](1) NULL,
	[AdmissionDate_FL12] [varchar](10) NULL,
	[AdmissionHour_FL13] [varchar](10) NULL,
	[AdmissionType_FL14] [varchar](10) NULL,
	[AdmissionSource_FL15] [varchar](10) NULL,
	[DischargeHour_FL16] [varchar](10) NULL,
	[PatientDischargeStatus_FL17] [varchar](10) NULL,
	[ConditionCode_FL18] [varchar](10) NULL,
	[ConditionCode_FL19] [varchar](10) NULL,
	[ConditionCode_FL20] [varchar](10) NULL,
	[ConditionCode_FL21] [varchar](10) NULL,
	[ConditionCode_FL22] [varchar](10) NULL,
	[ConditionCode_FL23] [varchar](10) NULL,
	[ConditionCode_FL24] [varchar](10) NULL,
	[ConditionCode_FL25] [varchar](10) NULL,
	[ConditionCode_FL26] [varchar](10) NULL,
	[ConditionCode_FL27] [varchar](10) NULL,
	[ConditionCode_FL28] [varchar](10) NULL,
	[AccidentState_FL29] [varchar](3) NULL,
	[OccurrenceCode_FL31] [varchar](10) NULL,
	[OccurrenceDate_FL31] [varchar](10) NULL,
	[OccurrenceCode_FL32] [varchar](10) NULL,
	[OccurrenceDate_FL32] [varchar](10) NULL,
	[OccurrenceCode_FL33] [varchar](10) NULL,
	[OccurrenceDate_FL33] [varchar](10) NULL,
	[OccurrenceCode_FL34] [varchar](10) NULL,
	[OccurrenceDate_FL34] [varchar](10) NULL,
	[OccurrenceCode_FL31b] [varchar](10) NULL,
	[OccurrenceDate_FL31b] [varchar](10) NULL,
	[OccurrenceCode_FL32b] [varchar](10) NULL,
	[OccurrenceDate_FL32b] [varchar](10) NULL,
	[OccurrenceCode_FL33b] [varchar](10) NULL,
	[OccurrenceDate_FL33b] [varchar](10) NULL,
	[OccurrenceCode_FL34b] [varchar](10) NULL,
	[OccurrenceDate_FL34b] [varchar](10) NULL,
	[OccurrenceSpanCode_FL35] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL35] [varchar](10) NULL,
	[OccurrenceSpanTo_FL35] [varchar](10) NULL,
	[OccurrenceSpanCode_FL36] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL36] [varchar](10) NULL,
	[OccurrenceSpanTo_FL36] [varchar](10) NULL,
	[OccurrenceSpanCode_FL35b] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL35b] [varchar](10) NULL,
	[OccurrenceSpanTo_FL35b] [varchar](10) NULL,
	[OccurrenceSpanCode_FL36b] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL36b] [varchar](10) NULL,
	[OccurrenceSpanTo_FL36b] [varchar](10) NULL,
	[ResponsiblePartyName_IsCorporation] [bit] NULL,
	[ResponsiblePartyName_FL38] [varchar](200) NULL,
	[ResponsiblePartyAddress1_FL38] [varchar](200) NULL,
	[ResponsiblePartyAddress2_FL38] [varchar](200) NULL,
	[ResponsiblePartyCity_FL38] [varchar](25) NULL,
	[ResponsiblePartyState_FL38] [varchar](3) NULL,
	[ResponsiblePartyZip_FL38] [varchar](10) NULL,
	[ValueCode_FL39a] [varchar](10) NULL,
	[ValueCodeAmount_FL39a] [money] NULL,
	[ValueCode_FL39b] [varchar](10) NULL,
	[ValueCodeAmount_FL39b] [money] NULL,
	[ValueCode_FL39c] [varchar](10) NULL,
	[ValueCodeAmount_FL39c] [money] NULL,
	[ValueCode_FL39d] [varchar](10) NULL,
	[ValueCodeAmount_FL39d] [money] NULL,
	[ValueCode_FL40a] [varchar](10) NULL,
	[ValueCodeAmount_FL40a] [money] NULL,
	[ValueCode_FL40b] [varchar](10) NULL,
	[ValueCodeAmount_FL40b] [money] NULL,
	[ValueCode_FL40c] [varchar](10) NULL,
	[ValueCodeAmount_FL40c] [money] NULL,
	[ValueCode_FL40d] [varchar](10) NULL,
	[ValueCodeAmount_FL40d] [money] NULL,
	[ValueCode_FL41a] [varchar](10) NULL,
	[ValueCodeAmount_FL41a] [money] NULL,
	[ValueCode_FL41b] [varchar](10) NULL,
	[ValueCodeAmount_FL41b] [money] NULL,
	[ValueCode_FL41c] [varchar](10) NULL,
	[ValueCodeAmount_FL41c] [money] NULL,
	[ValueCode_FL41d] [varchar](10) NULL,
	[ValueCodeAmount_FL41d] [money] NULL,
	[PrimaryPayerName_FL50a] [varchar](200) NULL,
	[PrimaryPayerPlanType_FL50a] [varchar](25) NULL,
	[PrimaryPayerPlanName_FL50a] [varchar](200) NULL,
	[SecondaryPayerName_FL50b] [varchar](200) NULL,
	[SecondaryPayerPlanType_FL50b] [varchar](25) NULL,
	[SecondaryPayerPlanName_FL50b] [varchar](200) NULL,
	[TertiaryPayerName_FL50c] [varchar](200) NULL,
	[TertiaryPayerPlanType_FL50c] [varchar](25) NULL,
	[TertiaryPayerPlanName_FL50c] [varchar](200) NULL,
	[PrimaryHealthPlanIDType_FL51a] [varchar](10) NULL,
	[SecondaryHealthPlanIDType_FL51b] [varchar](10) NULL,
	[TertiaryHealthPlanIDType_FL51c] [varchar](10) NULL,
	[PrimaryHealthPlanID_FL51a] [varchar](50) NULL,
	[SecondaryHealthPlanID_FL51b] [varchar](50) NULL,
	[TertiaryHealthPlanID_FL51c] [varchar](50) NULL,
	[PrimaryPatReleaseInfo_FL52a] [varchar](1) NULL,
	[SecondaryPatReleaseInfo_FL52b] [varchar](1) NULL,
	[TertiaryPatReleaseInfo_FL52c] [varchar](1) NULL,
	[PrimaryAssignBenefits_FL53a] [varchar](1) NULL,
	[SecondaryAssignBenefits_FL53b] [varchar](1) NULL,
	[TertiaryAssignBenefits_FL53c] [varchar](1) NULL,
	[PrimaryPriorPmts_FL54a] [money] NULL,
	[SecondaryPriorPmts_FL54b] [money] NULL,
	[TertiaryPriorPmts_FL54c] [money] NULL,
	[PrimaryEstAmtDue_FL55a] [money] NULL,
	[SecondaryEstAmtDue_FL55b] [money] NULL,
	[TertiaryEstAmtDue_FL55c] [money] NULL,
	[BillingProviderNPI_FL56] [varchar](50) NULL,
	[ID_FL57] [varchar](50) NULL,
	[OtherID_FL57] [varchar](50) NULL,
	[ProviderID_FL57] [varchar](50) NULL,
	[PrimaryInsuredName_FL58a] [varchar](200) NULL,
	[SecondaryInsuredName_FL58b] [varchar](200) NULL,
	[TertiaryInsuredName_FL58c] [varchar](200) NULL,
	[PrimaryPatRelationship_FL59a] [varchar](2) NULL,
	[SecondaryPatRelationship_FL59b] [varchar](2) NULL,
	[TertiaryPatRelationship_FL59c] [varchar](2) NULL,
	[PrimaryInsuredPlanID_FL60a] [varchar](50) NULL,
	[SecondaryInsuredPlanID_FL60b] [varchar](50) NULL,
	[TertiaryInsuredPlanID_FL60c] [varchar](50) NULL,
	[PrimaryPlanGroupName_FL61a] [varchar](200) NULL,
	[SecondaryPlanGroupName_FL61b] [varchar](200) NULL,
	[TertiaryPlanGroupName_FL61c] [varchar](200) NULL,
	[PrimaryPlanGroupID_FL62a] [varchar](50) NULL,
	[SecondaryPlanGroupID_FL62b] [varchar](50) NULL,
	[TertiaryPlanGroupID_FL62c] [varchar](50) NULL,
	[PrimaryTreatmentAuth_FL63a] [varchar](50) NULL,
	[SecondaryTreatmentAuth_FL63b] [varchar](50) NULL,
	[TertiaryTreatmentAuth_FL63c] [varchar](50) NULL,
	[DocControlNo_FL64a] [varchar](50) NULL,
	[DocControlNo_FL64b] [varchar](26) NULL,
	[DocControlNo_FL64c] [varchar](26) NULL,
	[PrimaryEmployerName_FL65a] [varchar](200) NULL,
	[SecondaryEmployerName_FL65b] [varchar](200) NULL,
	[TertiaryEmployerName_FL65c] [varchar](200) NULL,
	[DiagnosisVersion_FL66] [varchar](1) NULL,
	[Diagnosis_FL67] [varchar](25) NULL,
	[Diagnosis_FL67a] [varchar](25) NULL,
	[Diagnosis_FL67b] [varchar](25) NULL,
	[Diagnosis_FL67c] [varchar](25) NULL,
	[Diagnosis_FL67d] [varchar](25) NULL,
	[Diagnosis_FL67e] [varchar](25) NULL,
	[Diagnosis_FL67f] [varchar](25) NULL,
	[Diagnosis_FL67g] [varchar](25) NULL,
	[Diagnosis_FL67h] [varchar](25) NULL,
	[Diagnosis_FL67i] [varchar](25) NULL,
	[Diagnosis_FL67j] [varchar](25) NULL,
	[Diagnosis_FL67k] [varchar](25) NULL,
	[Diagnosis_FL67l] [varchar](25) NULL,
	[Diagnosis_FL67m] [varchar](25) NULL,
	[Diagnosis_FL67n] [varchar](25) NULL,
	[Diagnosis_FL67o] [varchar](25) NULL,
	[Diagnosis_FL67p] [varchar](25) NULL,
	[Diagnosis_FL67q] [varchar](25) NULL,
	[AdmittingDiagnosis_FL69] [varchar](25) NULL,
	[PatientVisitRsnDiagnosis_FL70a] [varchar](25) NULL,
	[PatientVisitRsnDiagnosis_FL70b] [varchar](25) NULL,
	[PatientVisitRsnDiagnosis_FL70c] [varchar](25) NULL,
	[PrincipalProcCode_FL74] [varchar](30) NULL,
	[PrincipalProcDate_FL74] [varchar](10) NULL,
	[OtherProcCode_FL74a] [varchar](30) NULL,
	[OtherProcDate_FL74a] [varchar](10) NULL,
	[OtherProcCode_FL74b] [varchar](30) NULL,
	[OtherProcDate_FL74b] [varchar](10) NULL,
	[OtherProcCode_FL74c] [varchar](30) NULL,
	[OtherProcDate_FL74c] [varchar](10) NULL,
	[OtherProcCode_FL74d] [varchar](30) NULL,
	[OtherProcDate_FL74d] [varchar](10) NULL,
	[OtherProcCode_FL74e] [varchar](30) NULL,
	[OtherProcDate_FL74e] [varchar](10) NULL,
	[AttendingNPI_ID_FL76] [varchar](50) NULL,
	[AttendingNPI_IDType_FL76] [varchar](10) NULL,
	[AttendingLastName_FL76] [varchar](50) NULL,
	[AttendingFirstName_FL76] [varchar](50) NULL,
	[OperatingNPI_ID_FL77] [varchar](50) NULL,
	[OperatingNPI_IDType_FL77] [varchar](10) NULL,
	[OperatingLastName_FL77] [varchar](50) NULL,
	[OperatingFirstName_FL77] [varchar](50) NULL,
	[OtherNPI_ID_FL78] [varchar](50) NULL,
	[OtherNPI_IDType_FL78] [varchar](10) NULL,
	[OtherLastName_FL78] [varchar](50) NULL,
	[OtherFirstName_FL78] [varchar](50) NULL,
	[OtherNPI_ID_FL79] [varchar](50) NULL,
	[OtherNPI_IDType_FL79] [varchar](10) NULL,
	[OtherLastName_FL79] [varchar](50) NULL,
	[OtherFirstName_FL79] [varchar](50) NULL,
	[Remarks_FL80] [varchar](800) NULL,
	[ClaimBatchUID] [uniqueidentifier] NULL,
	[TotalCharge] [money] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Attending_ID_FL76] [varchar](10) NULL,
	[Other_ID_FL78] [varchar](10) NULL,
	[Other_IDType_FL78] [varchar](10) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A temporary table used to store UB04 Claim information before it is printed. If paper claim printing is in progress this table should be empty.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_UB04Claim'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_UB04Claim'

ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_UB04ClaimUid]  DEFAULT (newid()) FOR [UB04ClaimUid]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__FileAsGroup]  DEFAULT ((0)) FOR [FileAsGroup]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SendNPI]  DEFAULT ((0)) FOR [SendNPI]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderName_FL1]  DEFAULT ('') FOR [ProviderName_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderAddress1_FL1]  DEFAULT ('') FOR [ProviderAddress1_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderAddress2_FL1]  DEFAULT ('') FOR [ProviderAddress2_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderCity_FL1]  DEFAULT ('') FOR [ProviderCity_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderState_FL1]  DEFAULT ('') FOR [ProviderState_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderZip_FL1]  DEFAULT ('') FOR [ProviderZip_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderPhone_FL1]  DEFAULT ('') FOR [ProviderPhone_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientControlNumber_FL3a]  DEFAULT ('') FOR [PatientControlNumber_FL3a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__MedicalRecordNumber_FL3b]  DEFAULT ('') FOR [MedicalRecordNumber_FL3b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TypeOfBill_FL4]  DEFAULT ('') FOR [TypeOfBill_FL4]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__FederalTaxID_FL5]  DEFAULT ('') FOR [FederalTaxID_FL5]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__StatementCoversPeriod_FL6From]  DEFAULT ('') FOR [StatementCoversPeriod_FL6From]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__StatementCoversPeriod_FL6To]  DEFAULT ('') FOR [StatementCoversPeriod_FL6To]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientName_FL8b]  DEFAULT ('') FOR [PatientName_FL8b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientAddressStreet_FL9a]  DEFAULT ('') FOR [PatientAddressStreet_FL9a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientAddressCity_FL9b]  DEFAULT ('') FOR [PatientAddressCity_FL9b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientAddressState_FL9c]  DEFAULT ('') FOR [PatientAddressState_FL9c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientAddressZip_FL9d]  DEFAULT ('') FOR [PatientAddressZip_FL9d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientBirthDate_FL10]  DEFAULT ('') FOR [PatientBirthDate_FL10]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientSex_FL11]  DEFAULT ('') FOR [PatientSex_FL11]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AdmissionDate_FL12]  DEFAULT ('') FOR [AdmissionDate_FL12]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AdmissionHour_FL13]  DEFAULT ('') FOR [AdmissionHour_FL13]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AdmissionType_FL14]  DEFAULT ('') FOR [AdmissionType_FL14]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AdmissionSource_FL15]  DEFAULT ('') FOR [AdmissionSource_FL15]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DischargeHour_FL16]  DEFAULT ('') FOR [DischargeHour_FL16]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientDischargeStatus_FL17]  DEFAULT ('') FOR [PatientDischargeStatus_FL17]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL18]  DEFAULT ('') FOR [ConditionCode_FL18]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL19]  DEFAULT ('') FOR [ConditionCode_FL19]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL20]  DEFAULT ('') FOR [ConditionCode_FL20]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL21]  DEFAULT ('') FOR [ConditionCode_FL21]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL22]  DEFAULT ('') FOR [ConditionCode_FL22]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL23]  DEFAULT ('') FOR [ConditionCode_FL23]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL24]  DEFAULT ('') FOR [ConditionCode_FL24]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL25]  DEFAULT ('') FOR [ConditionCode_FL25]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL26]  DEFAULT ('') FOR [ConditionCode_FL26]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL27]  DEFAULT ('') FOR [ConditionCode_FL27]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL28]  DEFAULT ('') FOR [ConditionCode_FL28]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AccidentState_FL29]  DEFAULT ('') FOR [AccidentState_FL29]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceCode_FL31]  DEFAULT ('') FOR [OccurrenceCode_FL31]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceDate_FL31]  DEFAULT ('') FOR [OccurrenceDate_FL31]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceCode_FL32]  DEFAULT ('') FOR [OccurrenceCode_FL32]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceDate_FL32]  DEFAULT ('') FOR [OccurrenceDate_FL32]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceCode_FL33]  DEFAULT ('') FOR [OccurrenceCode_FL33]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceDate_FL33]  DEFAULT ('') FOR [OccurrenceDate_FL33]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceCode_FL34]  DEFAULT ('') FOR [OccurrenceCode_FL34]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceDate_FL34]  DEFAULT ('') FOR [OccurrenceDate_FL34]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceCode_FL311]  DEFAULT ('') FOR [OccurrenceCode_FL31b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceDate_FL311]  DEFAULT ('') FOR [OccurrenceDate_FL31b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceCode_FL321]  DEFAULT ('') FOR [OccurrenceCode_FL32b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceDate_FL321]  DEFAULT ('') FOR [OccurrenceDate_FL32b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceCode_FL331]  DEFAULT ('') FOR [OccurrenceCode_FL33b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceDate_FL331]  DEFAULT ('') FOR [OccurrenceDate_FL33b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceCode_FL341]  DEFAULT ('') FOR [OccurrenceCode_FL34b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceDate_FL341]  DEFAULT ('') FOR [OccurrenceDate_FL34b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanCode_FL35]  DEFAULT ('') FOR [OccurrenceSpanCode_FL35]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanFrom_FL35]  DEFAULT ('') FOR [OccurrenceSpanFrom_FL35]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanTo_FL35]  DEFAULT ('') FOR [OccurrenceSpanTo_FL35]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanCode_FL36]  DEFAULT ('') FOR [OccurrenceSpanCode_FL36]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanFrom_FL36]  DEFAULT ('') FOR [OccurrenceSpanFrom_FL36]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanTo_FL36]  DEFAULT ('') FOR [OccurrenceSpanTo_FL36]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanCode_FL351]  DEFAULT ('') FOR [OccurrenceSpanCode_FL35b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanFrom_FL351]  DEFAULT ('') FOR [OccurrenceSpanFrom_FL35b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanTo_FL351]  DEFAULT ('') FOR [OccurrenceSpanTo_FL35b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanCode_FL361]  DEFAULT ('') FOR [OccurrenceSpanCode_FL36b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanFrom_FL361]  DEFAULT ('') FOR [OccurrenceSpanFrom_FL36b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanTo_FL361]  DEFAULT ('') FOR [OccurrenceSpanTo_FL36b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyName_IsCorporation]  DEFAULT ((0)) FOR [ResponsiblePartyName_IsCorporation]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyName_FL38]  DEFAULT ('') FOR [ResponsiblePartyName_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyAddress1_FL38]  DEFAULT ('') FOR [ResponsiblePartyAddress1_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyAddress2_FL38]  DEFAULT ('') FOR [ResponsiblePartyAddress2_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyCity_FL38]  DEFAULT ('') FOR [ResponsiblePartyCity_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyState_FL38]  DEFAULT ('') FOR [ResponsiblePartyState_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyZip_FL38]  DEFAULT ('') FOR [ResponsiblePartyZip_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL39a]  DEFAULT ('') FOR [ValueCode_FL39a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL39a]  DEFAULT ((0)) FOR [ValueCodeAmount_FL39a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL39b]  DEFAULT ('') FOR [ValueCode_FL39b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL39b]  DEFAULT ((0)) FOR [ValueCodeAmount_FL39b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL39c]  DEFAULT ('') FOR [ValueCode_FL39c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL39c]  DEFAULT ((0)) FOR [ValueCodeAmount_FL39c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL39d]  DEFAULT ('') FOR [ValueCode_FL39d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL39d]  DEFAULT ((0)) FOR [ValueCodeAmount_FL39d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL40a]  DEFAULT ('') FOR [ValueCode_FL40a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL40a]  DEFAULT ((0)) FOR [ValueCodeAmount_FL40a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL40b]  DEFAULT ('') FOR [ValueCode_FL40b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL40b]  DEFAULT ((0)) FOR [ValueCodeAmount_FL40b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL40c]  DEFAULT ('') FOR [ValueCode_FL40c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL40c]  DEFAULT ((0)) FOR [ValueCodeAmount_FL40c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL40d]  DEFAULT ('') FOR [ValueCode_FL40d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL40d]  DEFAULT ((0)) FOR [ValueCodeAmount_FL40d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL41a]  DEFAULT ('') FOR [ValueCode_FL41a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL41a]  DEFAULT ((0)) FOR [ValueCodeAmount_FL41a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL41b]  DEFAULT ('') FOR [ValueCode_FL41b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL41b]  DEFAULT ((0)) FOR [ValueCodeAmount_FL41b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL41c]  DEFAULT ('') FOR [ValueCode_FL41c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL41c]  DEFAULT ((0)) FOR [ValueCodeAmount_FL41c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL41d]  DEFAULT ('') FOR [ValueCode_FL41d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL41d]  DEFAULT ((0)) FOR [ValueCodeAmount_FL41d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPayerName_FL50a]  DEFAULT ('') FOR [PrimaryPayerName_FL50a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPayerPlanType_FL50a]  DEFAULT ('') FOR [PrimaryPayerPlanType_FL50a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPayerPlanName_FL50a]  DEFAULT ('') FOR [PrimaryPayerPlanName_FL50a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPayerName_FL50b]  DEFAULT ('') FOR [SecondaryPayerName_FL50b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPayerPlanType_FL50b]  DEFAULT ('') FOR [SecondaryPayerPlanType_FL50b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPayerPlanName_FL50b]  DEFAULT ('') FOR [SecondaryPayerPlanName_FL50b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPayerName_FL50c]  DEFAULT ('') FOR [TertiaryPayerName_FL50c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPayerPlanType_FL50c]  DEFAULT ('') FOR [TertiaryPayerPlanType_FL50c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPayerPlanName_FL50c]  DEFAULT ('') FOR [TertiaryPayerPlanName_FL50c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryHealthPlanIDType_FL51a]  DEFAULT ('') FOR [PrimaryHealthPlanIDType_FL51a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryHealthPlanIDType_FL51b]  DEFAULT ('') FOR [SecondaryHealthPlanIDType_FL51b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryHealthPlanIDType_FL51c]  DEFAULT ('') FOR [TertiaryHealthPlanIDType_FL51c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryHealthPlanID_FL51a]  DEFAULT ('') FOR [PrimaryHealthPlanID_FL51a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryHealthPlanID_FL51b]  DEFAULT ('') FOR [SecondaryHealthPlanID_FL51b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryHealthPlanID_FL51c]  DEFAULT ('') FOR [TertiaryHealthPlanID_FL51c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPatReleaseInfo_FL52a]  DEFAULT ('Y') FOR [PrimaryPatReleaseInfo_FL52a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPatReleaseInfo_FL52b]  DEFAULT (' ') FOR [SecondaryPatReleaseInfo_FL52b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPatReleaseInfo_FL52c]  DEFAULT (' ') FOR [TertiaryPatReleaseInfo_FL52c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryAssignBenefits_FL53a]  DEFAULT (' ') FOR [PrimaryAssignBenefits_FL53a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryAssignBenefits_FL53b]  DEFAULT (' ') FOR [SecondaryAssignBenefits_FL53b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryAssignBenefits_FL53c]  DEFAULT (' ') FOR [TertiaryAssignBenefits_FL53c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPriorPmts_FL54a]  DEFAULT ((0)) FOR [PrimaryPriorPmts_FL54a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPriorPmts_FL54b]  DEFAULT ((0)) FOR [SecondaryPriorPmts_FL54b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPriorPmts_FL54c]  DEFAULT ((0)) FOR [TertiaryPriorPmts_FL54c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryEstAmtDue_FL55a]  DEFAULT ((0)) FOR [PrimaryEstAmtDue_FL55a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryEstAmtDue_FL55b]  DEFAULT ((0)) FOR [SecondaryEstAmtDue_FL55b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryEstAmtDue_FL55c]  DEFAULT ((0)) FOR [TertiaryEstAmtDue_FL55c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__BillingProviderNPI_FL56]  DEFAULT ('') FOR [BillingProviderNPI_FL56]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ID_FL57]  DEFAULT ('') FOR [ID_FL57]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherID_FL57]  DEFAULT ('') FOR [OtherID_FL57]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderID_FL57]  DEFAULT ('') FOR [ProviderID_FL57]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryInsuredName_FL58a]  DEFAULT ('') FOR [PrimaryInsuredName_FL58a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryInsuredName_FL58b]  DEFAULT ('') FOR [SecondaryInsuredName_FL58b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryInsuredName_FL58c]  DEFAULT ('') FOR [TertiaryInsuredName_FL58c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPatRelationship_FL59a]  DEFAULT ('') FOR [PrimaryPatRelationship_FL59a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPatRelationship_FL59b]  DEFAULT ('') FOR [SecondaryPatRelationship_FL59b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPatRelationship_FL59c]  DEFAULT ('') FOR [TertiaryPatRelationship_FL59c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryInsuredPlanID_FL60a]  DEFAULT ('') FOR [PrimaryInsuredPlanID_FL60a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryInsuredPlanID_FL60b]  DEFAULT ('') FOR [SecondaryInsuredPlanID_FL60b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryInsuredPlanID_FL60c]  DEFAULT ('') FOR [TertiaryInsuredPlanID_FL60c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPlanGroupName_FL61a]  DEFAULT ('') FOR [PrimaryPlanGroupName_FL61a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPlanGroupName_FL61b]  DEFAULT ('') FOR [SecondaryPlanGroupName_FL61b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPlanGroupName_FL61c]  DEFAULT ('') FOR [TertiaryPlanGroupName_FL61c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPlanGroupID_FL62a]  DEFAULT ('') FOR [PrimaryPlanGroupID_FL62a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPlanGroupID_FL62b]  DEFAULT ('') FOR [SecondaryPlanGroupID_FL62b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPlanGroupID_FL62c]  DEFAULT ('') FOR [TertiaryPlanGroupID_FL62c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryTreatmentAuth_FL63a]  DEFAULT ('') FOR [PrimaryTreatmentAuth_FL63a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryTreatmentAuth_FL63b]  DEFAULT ('') FOR [SecondaryTreatmentAuth_FL63b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryTreatmentAuth_FL63c]  DEFAULT ('') FOR [TertiaryTreatmentAuth_FL63c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DocControlNo_FL64a]  DEFAULT ('') FOR [DocControlNo_FL64a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DocControlNo_FL64b]  DEFAULT ('') FOR [DocControlNo_FL64b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DocControlNo_FL64c]  DEFAULT ('') FOR [DocControlNo_FL64c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryEmployerName_FL65a]  DEFAULT ('') FOR [PrimaryEmployerName_FL65a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryEmployerName_FL65b]  DEFAULT ('') FOR [SecondaryEmployerName_FL65b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryEmployerName_FL65c]  DEFAULT ('') FOR [TertiaryEmployerName_FL65c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DiagnosisVersion_FL66]  DEFAULT ('9') FOR [DiagnosisVersion_FL66]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67]  DEFAULT ('') FOR [Diagnosis_FL67]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67a]  DEFAULT ('') FOR [Diagnosis_FL67a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67b]  DEFAULT ('') FOR [Diagnosis_FL67b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67c]  DEFAULT ('') FOR [Diagnosis_FL67c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67d]  DEFAULT ('') FOR [Diagnosis_FL67d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67r]  DEFAULT ('') FOR [Diagnosis_FL67e]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67f]  DEFAULT ('') FOR [Diagnosis_FL67f]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67g]  DEFAULT ('') FOR [Diagnosis_FL67g]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67h]  DEFAULT ('') FOR [Diagnosis_FL67h]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67i]  DEFAULT ('') FOR [Diagnosis_FL67i]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67j]  DEFAULT ('') FOR [Diagnosis_FL67j]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67k]  DEFAULT ('') FOR [Diagnosis_FL67k]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67l]  DEFAULT ('') FOR [Diagnosis_FL67l]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67m]  DEFAULT ('') FOR [Diagnosis_FL67m]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67n]  DEFAULT ('') FOR [Diagnosis_FL67n]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67o]  DEFAULT ('') FOR [Diagnosis_FL67o]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67p]  DEFAULT ('') FOR [Diagnosis_FL67p]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67q]  DEFAULT ('') FOR [Diagnosis_FL67q]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL69]  DEFAULT ('') FOR [AdmittingDiagnosis_FL69]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientVisitRsnDiagnosis_FL70a]  DEFAULT ('') FOR [PatientVisitRsnDiagnosis_FL70a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientVisitRsnDiagnosis_FL70b]  DEFAULT ('') FOR [PatientVisitRsnDiagnosis_FL70b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientVisitRsnDiagnosis_FL70c]  DEFAULT ('') FOR [PatientVisitRsnDiagnosis_FL70c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrincipalProcCode_FL74]  DEFAULT ('') FOR [PrincipalProcCode_FL74]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrincipalProcDate_FL74]  DEFAULT ('') FOR [PrincipalProcDate_FL74]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74a]  DEFAULT ('') FOR [OtherProcCode_FL74a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74a]  DEFAULT ('') FOR [OtherProcDate_FL74a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74b]  DEFAULT ('') FOR [OtherProcCode_FL74b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74b]  DEFAULT ('') FOR [OtherProcDate_FL74b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74c]  DEFAULT ('') FOR [OtherProcCode_FL74c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74c]  DEFAULT ('') FOR [OtherProcDate_FL74c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74d]  DEFAULT ('') FOR [OtherProcCode_FL74d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74d]  DEFAULT ('') FOR [OtherProcDate_FL74d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74e]  DEFAULT ('') FOR [OtherProcCode_FL74e]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74e]  DEFAULT ('') FOR [OtherProcDate_FL74e]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AttendingNPI_ID_FL76]  DEFAULT ('') FOR [AttendingNPI_ID_FL76]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AttendingNPI_IDType_FL76]  DEFAULT ('') FOR [AttendingNPI_IDType_FL76]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AttendingLastName_FL76]  DEFAULT ('') FOR [AttendingLastName_FL76]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AttendingFirstName_FL76]  DEFAULT ('') FOR [AttendingFirstName_FL76]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OperatingNPI_ID_FL77]  DEFAULT ('') FOR [OperatingNPI_ID_FL77]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OperatingNPI_IDType_FL77]  DEFAULT ('') FOR [OperatingNPI_IDType_FL77]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OperatingLastName_FL77]  DEFAULT ('') FOR [OperatingLastName_FL77]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OperatingFirstName_FL77]  DEFAULT ('') FOR [OperatingFirstName_FL77]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherNPI_ID_FL78]  DEFAULT ('') FOR [OtherNPI_ID_FL78]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherNPI_IDType_FL78]  DEFAULT ('') FOR [OtherNPI_IDType_FL78]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherLastName_FL78]  DEFAULT ('') FOR [OtherLastName_FL78]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherFirstName_FL78]  DEFAULT ('') FOR [OtherFirstName_FL78]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherNPI_ID_FL79]  DEFAULT ('') FOR [OtherNPI_ID_FL79]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherNPI_IDType_FL79]  DEFAULT ('') FOR [OtherNPI_IDType_FL79]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherLastName_FL79]  DEFAULT ('') FOR [OtherLastName_FL79]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherFirstName_FL79]  DEFAULT ('') FOR [OtherFirstName_FL79]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Remarks_FL80]  DEFAULT ('') FOR [Remarks_FL80]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TotalCharge]  DEFAULT ((0)) FOR [TotalCharge]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_UB04Claim
INSERT [migtemp_UB04Claim]([UB04ClaimUid],[SuperBillUId],[FinancialCenterUid],[ProviderUId],[FileAsGroup],[SendNPI],[ProviderName_FL1],[ProviderAddress1_FL1],[ProviderAddress2_FL1],[ProviderCity_FL1],[ProviderState_FL1],[ProviderZip_FL1],[ProviderPhone_FL1],[PatientControlNumber_FL3a],[MedicalRecordNumber_FL3b],[TypeOfBill_FL4],[FederalTaxID_FL5],[StatementCoversPeriod_FL6From],[StatementCoversPeriod_FL6To],[PatientName_FL8b],[PatientAddressStreet_FL9a],[PatientAddressCity_FL9b],[PatientAddressState_FL9c],[PatientAddressZip_FL9d],[PatientBirthDate_FL10],[PatientSex_FL11],[AdmissionDate_FL12],[AdmissionHour_FL13],[AdmissionType_FL14],[AdmissionSource_FL15],[DischargeHour_FL16],[PatientDischargeStatus_FL17],[ConditionCode_FL18],[ConditionCode_FL19],[ConditionCode_FL20],[ConditionCode_FL21],[ConditionCode_FL22],[ConditionCode_FL23],[ConditionCode_FL24],[ConditionCode_FL25],[ConditionCode_FL26],[ConditionCode_FL27],[ConditionCode_FL28],[AccidentState_FL29],[OccurrenceCode_FL31],[OccurrenceDate_FL31],[OccurrenceCode_FL32],[OccurrenceDate_FL32],[OccurrenceCode_FL33],[OccurrenceDate_FL33],[OccurrenceCode_FL34],[OccurrenceDate_FL34],[OccurrenceCode_FL31b],[OccurrenceDate_FL31b],[OccurrenceCode_FL32b],[OccurrenceDate_FL32b],[OccurrenceCode_FL33b],[OccurrenceDate_FL33b],[OccurrenceCode_FL34b],[OccurrenceDate_FL34b],[OccurrenceSpanCode_FL35],[OccurrenceSpanFrom_FL35],[OccurrenceSpanTo_FL35],[OccurrenceSpanCode_FL36],[OccurrenceSpanFrom_FL36],[OccurrenceSpanTo_FL36],[OccurrenceSpanCode_FL35b],[OccurrenceSpanFrom_FL35b],[OccurrenceSpanTo_FL35b],[OccurrenceSpanCode_FL36b],[OccurrenceSpanFrom_FL36b],[OccurrenceSpanTo_FL36b],[ResponsiblePartyName_IsCorporation],[ResponsiblePartyName_FL38],[ResponsiblePartyAddress1_FL38],[ResponsiblePartyAddress2_FL38],[ResponsiblePartyCity_FL38],[ResponsiblePartyState_FL38],[ResponsiblePartyZip_FL38],[ValueCode_FL39a],[ValueCodeAmount_FL39a],[ValueCode_FL39b],[ValueCodeAmount_FL39b],[ValueCode_FL39c],[ValueCodeAmount_FL39c],[ValueCode_FL39d],[ValueCodeAmount_FL39d],[ValueCode_FL40a],[ValueCodeAmount_FL40a],[ValueCode_FL40b],[ValueCodeAmount_FL40b],[ValueCode_FL40c],[ValueCodeAmount_FL40c],[ValueCode_FL40d],[ValueCodeAmount_FL40d],[ValueCode_FL41a],[ValueCodeAmount_FL41a],[ValueCode_FL41b],[ValueCodeAmount_FL41b],[ValueCode_FL41c],[ValueCodeAmount_FL41c],[ValueCode_FL41d],[ValueCodeAmount_FL41d],[PrimaryPayerName_FL50a],[PrimaryPayerPlanType_FL50a],[PrimaryPayerPlanName_FL50a],[SecondaryPayerName_FL50b],[SecondaryPayerPlanType_FL50b],[SecondaryPayerPlanName_FL50b],[TertiaryPayerName_FL50c],[TertiaryPayerPlanType_FL50c],[TertiaryPayerPlanName_FL50c],[PrimaryHealthPlanIDType_FL51a],[SecondaryHealthPlanIDType_FL51b],[TertiaryHealthPlanIDType_FL51c],[PrimaryHealthPlanID_FL51a],[SecondaryHealthPlanID_FL51b],[TertiaryHealthPlanID_FL51c],[PrimaryPatReleaseInfo_FL52a],[SecondaryPatReleaseInfo_FL52b],[TertiaryPatReleaseInfo_FL52c],[PrimaryAssignBenefits_FL53a],[SecondaryAssignBenefits_FL53b],[TertiaryAssignBenefits_FL53c],[PrimaryPriorPmts_FL54a],[SecondaryPriorPmts_FL54b],[TertiaryPriorPmts_FL54c],[PrimaryEstAmtDue_FL55a],[SecondaryEstAmtDue_FL55b],[TertiaryEstAmtDue_FL55c],[BillingProviderNPI_FL56],[ID_FL57],[OtherID_FL57],[ProviderID_FL57],[PrimaryInsuredName_FL58a],[SecondaryInsuredName_FL58b],[TertiaryInsuredName_FL58c],[PrimaryPatRelationship_FL59a],[SecondaryPatRelationship_FL59b],[TertiaryPatRelationship_FL59c],[PrimaryInsuredPlanID_FL60a],[SecondaryInsuredPlanID_FL60b],[TertiaryInsuredPlanID_FL60c],[PrimaryPlanGroupName_FL61a],[SecondaryPlanGroupName_FL61b],[TertiaryPlanGroupName_FL61c],[PrimaryPlanGroupID_FL62a],[SecondaryPlanGroupID_FL62b],[TertiaryPlanGroupID_FL62c],[PrimaryTreatmentAuth_FL63a],[SecondaryTreatmentAuth_FL63b],[TertiaryTreatmentAuth_FL63c],[DocControlNo_FL64a],[DocControlNo_FL64b],[DocControlNo_FL64c],[PrimaryEmployerName_FL65a],[SecondaryEmployerName_FL65b],[TertiaryEmployerName_FL65c],[DiagnosisVersion_FL66],[Diagnosis_FL67],[Diagnosis_FL67a],[Diagnosis_FL67b],[Diagnosis_FL67c],[Diagnosis_FL67d],[Diagnosis_FL67e],[Diagnosis_FL67f],[Diagnosis_FL67g],[Diagnosis_FL67h],[Diagnosis_FL67i],[Diagnosis_FL67j],[Diagnosis_FL67k],[Diagnosis_FL67l],[Diagnosis_FL67m],[Diagnosis_FL67n],[Diagnosis_FL67o],[Diagnosis_FL67p],[Diagnosis_FL67q],[AdmittingDiagnosis_FL69],[PatientVisitRsnDiagnosis_FL70a],[PatientVisitRsnDiagnosis_FL70b],[PatientVisitRsnDiagnosis_FL70c],[PrincipalProcCode_FL74],[PrincipalProcDate_FL74],[OtherProcCode_FL74a],[OtherProcDate_FL74a],[OtherProcCode_FL74b],[OtherProcDate_FL74b],[OtherProcCode_FL74c],[OtherProcDate_FL74c],[OtherProcCode_FL74d],[OtherProcDate_FL74d],[OtherProcCode_FL74e],[OtherProcDate_FL74e],[AttendingNPI_ID_FL76],[AttendingNPI_IDType_FL76],[AttendingLastName_FL76],[AttendingFirstName_FL76],[OperatingNPI_ID_FL77],[OperatingNPI_IDType_FL77],[OperatingLastName_FL77],[OperatingFirstName_FL77],[OtherNPI_ID_FL78],[OtherNPI_IDType_FL78],[OtherLastName_FL78],[OtherFirstName_FL78],[OtherNPI_ID_FL79],[OtherNPI_IDType_FL79],[OtherLastName_FL79],[OtherFirstName_FL79],[Remarks_FL80],[ClaimBatchUID],[TotalCharge],[LastModifiedDate])
SELECT [UB04ClaimUid],[SuperBillUId],[FinancialCenterUid],[ProviderUId],[FileAsGroup],[SendNPI],[ProviderName_FL1],[ProviderAddress1_FL1],[ProviderAddress2_FL1],[ProviderCity_FL1],[ProviderState_FL1],[ProviderZip_FL1],[ProviderPhone_FL1],[PatientControlNumber_FL3a],[MedicalRecordNumber_FL3b],[TypeOfBill_FL4],[FederalTaxID_FL5],[StatementCoversPeriod_FL6From],[StatementCoversPeriod_FL6To],[PatientName_FL8b],[PatientAddressStreet_FL9a],[PatientAddressCity_FL9b],[PatientAddressState_FL9c],[PatientAddressZip_FL9d],[PatientBirthDate_FL10],[PatientSex_FL11],[AdmissionDate_FL12],[AdmissionHour_FL13],[AdmissionType_FL14],[AdmissionSource_FL15],[DischargeHour_FL16],[PatientDischargeStatus_FL17],[ConditionCode_FL18],[ConditionCode_FL19],[ConditionCode_FL20],[ConditionCode_FL21],[ConditionCode_FL22],[ConditionCode_FL23],[ConditionCode_FL24],[ConditionCode_FL25],[ConditionCode_FL26],[ConditionCode_FL27],[ConditionCode_FL28],[AccidentState_FL29],[OccurrenceCode_FL31],[OccurrenceDate_FL31],[OccurrenceCode_FL32],[OccurrenceDate_FL32],[OccurrenceCode_FL33],[OccurrenceDate_FL33],[OccurrenceCode_FL34],[OccurrenceDate_FL34],[OccurrenceCode_FL31b],[OccurrenceDate_FL31b],[OccurrenceCode_FL32b],[OccurrenceDate_FL32b],[OccurrenceCode_FL33b],[OccurrenceDate_FL33b],[OccurrenceCode_FL34b],[OccurrenceDate_FL34b],[OccurrenceSpanCode_FL35],[OccurrenceSpanFrom_FL35],[OccurrenceSpanTo_FL35],[OccurrenceSpanCode_FL36],[OccurrenceSpanFrom_FL36],[OccurrenceSpanTo_FL36],[OccurrenceSpanCode_FL35b],[OccurrenceSpanFrom_FL35b],[OccurrenceSpanTo_FL35b],[OccurrenceSpanCode_FL36b],[OccurrenceSpanFrom_FL36b],[OccurrenceSpanTo_FL36b],[ResponsiblePartyName_IsCorporation],[ResponsiblePartyName_FL38],[ResponsiblePartyAddress1_FL38],[ResponsiblePartyAddress2_FL38],[ResponsiblePartyCity_FL38],[ResponsiblePartyState_FL38],[ResponsiblePartyZip_FL38],[ValueCode_FL39a],[ValueCodeAmount_FL39a],[ValueCode_FL39b],[ValueCodeAmount_FL39b],[ValueCode_FL39c],[ValueCodeAmount_FL39c],[ValueCode_FL39d],[ValueCodeAmount_FL39d],[ValueCode_FL40a],[ValueCodeAmount_FL40a],[ValueCode_FL40b],[ValueCodeAmount_FL40b],[ValueCode_FL40c],[ValueCodeAmount_FL40c],[ValueCode_FL40d],[ValueCodeAmount_FL40d],[ValueCode_FL41a],[ValueCodeAmount_FL41a],[ValueCode_FL41b],[ValueCodeAmount_FL41b],[ValueCode_FL41c],[ValueCodeAmount_FL41c],[ValueCode_FL41d],[ValueCodeAmount_FL41d],[PrimaryPayerName_FL50a],[PrimaryPayerPlanType_FL50a],[PrimaryPayerPlanName_FL50a],[SecondaryPayerName_FL50b],[SecondaryPayerPlanType_FL50b],[SecondaryPayerPlanName_FL50b],[TertiaryPayerName_FL50c],[TertiaryPayerPlanType_FL50c],[TertiaryPayerPlanName_FL50c],[PrimaryHealthPlanIDType_FL51a],[SecondaryHealthPlanIDType_FL51b],[TertiaryHealthPlanIDType_FL51c],[PrimaryHealthPlanID_FL51a],[SecondaryHealthPlanID_FL51b],[TertiaryHealthPlanID_FL51c],[PrimaryPatReleaseInfo_FL52a],[SecondaryPatReleaseInfo_FL52b],[TertiaryPatReleaseInfo_FL52c],[PrimaryAssignBenefits_FL53a],[SecondaryAssignBenefits_FL53b],[TertiaryAssignBenefits_FL53c],[PrimaryPriorPmts_FL54a],[SecondaryPriorPmts_FL54b],[TertiaryPriorPmts_FL54c],[PrimaryEstAmtDue_FL55a],[SecondaryEstAmtDue_FL55b],[TertiaryEstAmtDue_FL55c],[BillingProviderNPI_FL56],[ID_FL57],[OtherID_FL57],[ProviderID_FL57],[PrimaryInsuredName_FL58a],[SecondaryInsuredName_FL58b],[TertiaryInsuredName_FL58c],[PrimaryPatRelationship_FL59a],[SecondaryPatRelationship_FL59b],[TertiaryPatRelationship_FL59c],[PrimaryInsuredPlanID_FL60a],[SecondaryInsuredPlanID_FL60b],[TertiaryInsuredPlanID_FL60c],[PrimaryPlanGroupName_FL61a],[SecondaryPlanGroupName_FL61b],[TertiaryPlanGroupName_FL61c],[PrimaryPlanGroupID_FL62a],[SecondaryPlanGroupID_FL62b],[TertiaryPlanGroupID_FL62c],[PrimaryTreatmentAuth_FL63a],[SecondaryTreatmentAuth_FL63b],[TertiaryTreatmentAuth_FL63c],[DocControlNo_FL64a],[DocControlNo_FL64b],[DocControlNo_FL64c],[PrimaryEmployerName_FL65a],[SecondaryEmployerName_FL65b],[TertiaryEmployerName_FL65c],[DiagnosisVersion_FL66],[Diagnosis_FL67],[Diagnosis_FL67a],[Diagnosis_FL67b],[Diagnosis_FL67c],[Diagnosis_FL67d],[Diagnosis_FL67e],[Diagnosis_FL67f],[Diagnosis_FL67g],[Diagnosis_FL67h],[Diagnosis_FL67i],[Diagnosis_FL67j],[Diagnosis_FL67k],[Diagnosis_FL67l],[Diagnosis_FL67m],[Diagnosis_FL67n],[Diagnosis_FL67o],[Diagnosis_FL67p],[Diagnosis_FL67q],[AdmittingDiagnosis_FL69],[PatientVisitRsnDiagnosis_FL70a],[PatientVisitRsnDiagnosis_FL70b],[PatientVisitRsnDiagnosis_FL70c],[PrincipalProcCode_FL74],[PrincipalProcDate_FL74],[OtherProcCode_FL74a],[OtherProcDate_FL74a],[OtherProcCode_FL74b],[OtherProcDate_FL74b],[OtherProcCode_FL74c],[OtherProcDate_FL74c],[OtherProcCode_FL74d],[OtherProcDate_FL74d],[OtherProcCode_FL74e],[OtherProcDate_FL74e],[AttendingNPI_ID_FL76],[AttendingNPI_IDType_FL76],[AttendingLastName_FL76],[AttendingFirstName_FL76],[OperatingNPI_ID_FL77],[OperatingNPI_IDType_FL77],[OperatingLastName_FL77],[OperatingFirstName_FL77],[OtherNPI_ID_FL78],[OtherNPI_IDType_FL78],[OtherLastName_FL78],[OtherFirstName_FL78],[OtherNPI_ID_FL79],[OtherNPI_IDType_FL79],[OtherLastName_FL79],[OtherFirstName_FL79],[Remarks_FL80],[ClaimBatchUID],[TotalCharge],[LastModifiedDate]
FROM [UB04Claim]

DROP TABLE [UB04Claim]

exec  sp_rename 'migtemp_UB04Claim', 'UB04Claim'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User group member' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VaccineUnitUse]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[VaccineUnitUse](
	[VaccineUnitUseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VaccineUnitUse_VaccineUnitUseUid]  DEFAULT (newid()),
	[NDCInnerID] [float] NULL,
	[UseUnitLabeler] [varchar](255) NULL,
	[UseUnitProduct] [varchar](255) NULL,
	[UseUnitPackage] [varchar](255) NULL,
	[UseUnitPropName] [varchar](255) NULL,
	[UseUnitGenericName] [varchar](255) NULL,
	[UseUnitLabelerName] [varchar](255) NULL,
	[UseUnitstartDate] [varchar](255) NULL,
	[UseUnitEndDate] [varchar](255) NULL,
	[UseUnitPackForm] [varchar](255) NULL,
	[UseUnitGTIN] [varchar](255) NULL,
	[CVXCode] [varchar](255) NULL,
	[CVXShortDescription] [varchar](255) NULL,
	[NoInner] [bit] NOT NULL,
	[NDC11] [varchar](255) NULL,
	[LastUpdatedDate] [datetime] NULL,
	[GTIN] [varchar](255) NULL,
	[MVX] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_VaccineUnitUse_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_VaccineUnitUse_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VaccineUnitUse_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VaccineUnitUse'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitDiagnosis](
	[VisitDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitDiagnosis_RowGuid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[PatientProblemUid] [uniqueidentifier] NULL,
	[DiagnosisPanelUid] [uniqueidentifier] NULL,
	[PatientProblemDiagnosisUid] [uniqueidentifier] NULL,
	[Code] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[FollowupFlag] [smallint] NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_IsDelete]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_IsAddendum]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()),
	[AddendumNotes] [varchar](max) NULL,
	[DSMAxis] [varchar](250) NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DpnXml] [xml] NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[SortToBottom] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_SortToBottom]  DEFAULT ((0)),
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_LifeLong]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1:improve; 2:worsen; 3: unchange; 4: resolve' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'FollowupFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 - Differential, 2 - PreOp, 3 - PostOp' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'VisitDiagnosisType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for Diagnosis' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis'
EXEC sys.sp_addextendedproperty @name=N'VisitDiagnosisType', @value=N'<None value="0"/><Differential value="1" /><PreOp value="2"/><PostOp value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis'


END
Truncate Table migtemp_VisitDiagnosis
INSERT [migtemp_VisitDiagnosis]([VisitDiagnosisUid],[VisitUid],[PatientProblemUid],[DiagnosisPanelUid],[PatientProblemDiagnosisUid],[Code],[Code10],[Name],[Notes],[DisplayOrder],[SnomedCTConceptId],[FollowupFlag],[VisitDiagnosisType],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate],[AddendumNotes],[DSMAxis],[DpnGroupUid],[DpnXml])
SELECT [VisitDiagnosisUid],[VisitUid],[PatientProblemUid],[DiagnosisPanelUid],[PatientProblemDiagnosisUid],[Code],[Code10],[Name],[Notes],[DisplayOrder],[SnomedCTConceptId],[FollowupFlag],[VisitDiagnosisType],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate],[AddendumNotes],[DSMAxis],[DpnGroupUid],CONVERT(nvarchar(max), [DpnXml])
FROM [VisitDiagnosis]

DROP TABLE [VisitDiagnosis]

exec  sp_rename 'migtemp_VisitDiagnosis', 'VisitDiagnosis'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitPE]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitPE](
	[VisitPEUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitPE_RowGuid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[PETemplateUid] [uniqueidentifier] NOT NULL,
	[PEParentSystemUid] [uniqueidentifier] NOT NULL,
	[PESystemUid] [uniqueidentifier] NOT NULL,
	[PESymptomUid] [uniqueidentifier] NOT NULL,
	[PEDescriptionUid] [uniqueidentifier] NOT NULL,
	[RelEMKeyComponentBulletUid] [uniqueidentifier] NULL,
	[PETemplateName] [varchar](100) NULL,
	[PEParentSystemName] [varchar](100) NULL,
	[PESystemName] [varchar](100) NULL,
	[PESymptomName] [varchar](100) NULL,
	[PEDescriptionName] [varchar](255) NULL,
	[IsPEParentSystemBilateral] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsPEParentSystemBilateral]  DEFAULT ((0)),
	[IsPESystemBilateral] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsPESystemBilateral]  DEFAULT ((0)),
	[IsPESymptomBilateral] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsPESymptomBilateral]  DEFAULT ((0)),
	[PESystemColorID] [smallint] NULL CONSTRAINT [DF_VisitPE_PESystemColorID]  DEFAULT ((0)),
	[NormalFlag] [bit] NOT NULL CONSTRAINT [DF_VisitPE_NormalFlag]  DEFAULT ((0)),
	[FollowupFlag] [smallint] NULL,
	[PEParentSystemDisplayOrder] [int] NULL,
	[PESystemDisplayOrder] [int] NULL,
	[PESymptomDisplayOrder] [int] NULL,
	[PEDescriptionDisplayOrder] [int] NULL,
	[BilateralityValue] [smallint] NULL CONSTRAINT [DF_VisitPE_BilateralityValue]  DEFAULT ((0)),
	[CountAsBullet] [bit] NULL CONSTRAINT [DF_VisitPE_CountAsBullet]  DEFAULT ((1)),
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_VisitPE_Lifelong]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsDeleted]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitPE_IsAddendum]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitPE_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'VisitPEUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe template id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PETemplateUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe subsystem' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEParentSystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe system id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe symptom id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESymptomUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe description id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEDescriptionUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEParentSystemName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE sub system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESystemName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE finding' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESymptomName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEDescriptionName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1: blue; 2: black' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESystemColorID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'normal flag: 1: normal; 0: abnormal' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'NormalFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1:improve; 2:worsen; 3: unchange; 4: resolve' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'FollowupFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE description sequence' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEDescriptionDisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bilaterality values: 0 - not defined, 1 - left, 2 - right, 3 - bilateral' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'BilateralityValue'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'user comment on the description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'BilateralityValue', @value=N'<NotDefined value="0" /><Left value="1" description="Left side of the patient" /><Right value="2" description="Right side of the patient" /><Bilateral value="3" description="Both sides of the patient" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for physical exam' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE'


END
Truncate Table migtemp_VisitPE
INSERT [migtemp_VisitPE]([VisitPEUid],[VisitUid],[PETemplateUid],[PEParentSystemUid],[PESystemUid],[PESymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[PETemplateName],[PEParentSystemName],[PESystemName],[PESymptomName],[PEDescriptionName],[IsPEParentSystemBilateral],[IsPESystemBilateral],[IsPESymptomBilateral],[PESystemColorID],[NormalFlag],[FollowupFlag],[PEParentSystemDisplayOrder],[PESystemDisplayOrder],[PESymptomDisplayOrder],[PEDescriptionDisplayOrder],[BilateralityValue],[CountAsBullet],[Notes],[AddendumNotes],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate])
SELECT [VisitPEUid],[VisitUid],[PETemplateUid],[PEParentSystemUid],[PESystemUid],[PESymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[PETemplateName],[PEParentSystemName],[PESystemName],[PESymptomName],[PEDescriptionName],[IsPEParentSystemBilateral],[IsPESystemBilateral],[IsPESymptomBilateral],[PESystemColorID],[NormalFlag],[FollowupFlag],[PEParentSystemDisplayOrder],[PESystemDisplayOrder],[PESymptomDisplayOrder],[PEDescriptionDisplayOrder],[BilateralityValue],[CountAsBullet],[Notes],[AddendumNotes],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate]
FROM [VisitPE]

DROP TABLE [VisitPE]

exec  sp_rename 'migtemp_VisitPE', 'VisitPE'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitProcedure](
	[VisitProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitProcedure_VisitProcedureUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[ProcedureCategoryUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[ProcedureModifier1Uid] [uniqueidentifier] NULL,
	[ProcedureModifier2Uid] [uniqueidentifier] NULL,
	[ProcedureModifier3Uid] [uniqueidentifier] NULL,
	[ProcedureModifier4Uid] [uniqueidentifier] NULL,
	[ProcedurePanelUid] [uniqueidentifier] NULL,
	[Code] [varchar](30) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitProcedure_DisplayOrder]  DEFAULT ((0)),
	[Unit] [int] NULL,
	[PatientImmunizationUid] [uniqueidentifier] NULL,
	[IsPerformed] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_IsPerformed]  DEFAULT ((0)),
	[IsEM] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_IsEM_1]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_IsDeleted]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_IsAddendum]  DEFAULT ((0)),
	[ServiceSiteTypeUid] [uniqueidentifier] NULL,
	[UserDefinedTemplateUid] [uniqueidentifier] NULL,
	[AddToHistoryGroupUid] [uniqueidentifier] NULL,
	[UserDefinedProcedureNoteText] [varchar](max) NULL,
	[UserDefinedProcedureNoteXml] [varchar](max) NULL,
	[GlobalPeriodDays] [int] NULL,
	[PQRIMeasureUid] [uniqueidentifier] NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DpnXml] [xml] NULL,
	[DpnOrderActionSaveFlag] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_DpnOrderActionSaveFlag]  DEFAULT ((0)),
	[DpnOrderActionCompleteFlag] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_DpnOrderActionCompleteFlag]  DEFAULT ((0)),
	[DpnOrderActionSendFlag] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_DpnOrderActionSendFlag]  DEFAULT ((0)),
	[DpnOrderActionCloseFlag] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_DpnOrderActionCloseFlag]  DEFAULT ((0)),
	[ReimbursementRuleTriggerUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[ReimbursementRuleDiagnosis] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_ReimbursementRuleDiagnosis]  DEFAULT ((0)),
	[ReimbursementRuleOverride] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_ReimbursementRuleOverride]  DEFAULT ((0)),
	[BillStartTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillEndTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillTransportOdoStart] [float] NULL,
	[BillTransportOdoEnd] [float] NULL,
	[BillOdometerXml] [xml] NULL,
	[BillTimeXml] [xml] NULL,
	[ABNStatusUid] [uniqueidentifier] NULL,
	[ABNEstimatedFee] [money] NOT NULL CONSTRAINT [DF_VisitProcedure_ABNEstimatedFee]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitProcedure_LastModifiedDate]  DEFAULT (getutcdate()),
	[OrderInfo] [xml](CONTENT [dbo].[OrderInfoData]) NULL,
	[OrderAQNData] [xml] NULL,
	[SortToBottom] [bit] NOT NULL CONSTRAINT [DF_VisitProcedure_SortToBottom]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'VisitProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CPT id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'ProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'user comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DisplayOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'number of times of  service' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'Unit'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'waiting for spec: The table has been changed to PatientHistoryDetail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'PatientImmunizationUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for service perform' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure'


END
Truncate Table migtemp_VisitProcedure
INSERT [migtemp_VisitProcedure]([VisitProcedureUid],[VisitUid],[ProcedureCategoryUid],[ProcedureUid],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[ProcedurePanelUid],[Code],[Name],[Notes],[AddendumNotes],[DisplayOrder],[Unit],[PatientImmunizationUid],[IsPerformed],[IsEM],[IsDelete],[IsAddendum],[ServiceSiteTypeUid],[UserDefinedTemplateUid],[AddToHistoryGroupUid],[UserDefinedProcedureNoteText],[UserDefinedProcedureNoteXml],[GlobalPeriodDays],[PQRIMeasureUid],[DpnGroupUid],[DpnXml],[DpnOrderActionSaveFlag],[DpnOrderActionCompleteFlag],[DpnOrderActionSendFlag],[DpnOrderActionCloseFlag],[ReimbursementRuleTriggerUid],[NegationReasonUid],[ReimbursementRuleDiagnosis],[ReimbursementRuleOverride],[BillStartTime],[BillEndTime],[BillTransportOdoStart],[BillTransportOdoEnd],[BillOdometerXml],[BillTimeXml],[ABNStatusUid],[ABNEstimatedFee],[LastModifiedByUid],[LastModifiedDate],[OrderInfo],[OrderAQNData])
SELECT [VisitProcedureUid],[VisitUid],[ProcedureCategoryUid],[ProcedureUid],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[ProcedurePanelUid],[Code],[Name],[Notes],[AddendumNotes],[DisplayOrder],[Unit],[PatientImmunizationUid],[IsPerformed],[IsEM],[IsDelete],[IsAddendum],[ServiceSiteTypeUid],[UserDefinedTemplateUid],[AddToHistoryGroupUid],[UserDefinedProcedureNoteText],[UserDefinedProcedureNoteXml],[GlobalPeriodDays],[PQRIMeasureUid],[DpnGroupUid],CONVERT(nvarchar(max), [DpnXml]),[DpnOrderActionSaveFlag],[DpnOrderActionCompleteFlag],[DpnOrderActionSendFlag],[DpnOrderActionCloseFlag],[ReimbursementRuleTriggerUid],[NegationReasonUid],[ReimbursementRuleDiagnosis],[ReimbursementRuleOverride],[BillStartTime],[BillEndTime],[BillTransportOdoStart],[BillTransportOdoEnd],CONVERT(nvarchar(max), [BillOdometerXml]),CONVERT(nvarchar(max), [BillTimeXml]),[ABNStatusUid],[ABNEstimatedFee],[LastModifiedByUid],[LastModifiedDate],CONVERT(nvarchar(max), [OrderInfo]),CONVERT(nvarchar(max), [OrderAQNData])
FROM [VisitProcedure]

DROP TABLE [VisitProcedure]

exec  sp_rename 'migtemp_VisitProcedure', 'VisitProcedure'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[atest]') AND type in (N'U'))
DROP TABLE [atest]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[btest]') AND type in (N'U'))
DROP TABLE [btest]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[CommonWellDocument]') AND type in (N'U'))
DROP TABLE [CommonWellDocument]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[CommonWellPatient]') AND type in (N'U'))
DROP TABLE [CommonWellPatient]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[HL7BackfillQueue]') AND type in (N'U'))
DROP TABLE [HL7BackfillQueue]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[SuperbillTargetCreditCardApplyConsents]') AND type in (N'U'))
DROP TABLE [SuperbillTargetCreditCardApplyConsents]
COMMIT TRAN

GO


