
/****** Object:  Index [PK_IMO_ProblemIT_Custom_Word_Index]    Script Date: 10/24/2018 10:57:09 AM ******/
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_Custom_Word_Index]') AND name = N'PK_IMO_ProblemIT_Custom_Word_Index')
ALTER TABLE [dbo].[IMO_ProblemIT_Custom_Word_Index] DROP CONSTRAINT [PK_IMO_ProblemIT_Custom_Word_Index] WITH ( ONLINE = OFF )
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AccessCode]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[AccessCode](
	[AccessCodeUid] [uniqueidentifier] NOT NULL,
	[Code] [varchar](25) NOT NULL,
	[CreatedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AccessCode'

ALTER TABLE [AccessCode] ADD  CONSTRAINT [DF_AccessCode_CreatedDate]  DEFAULT (getutcdate()) FOR [CreatedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Account]') AND name = 'ResponsiblePartyWebAccess')
ALTER TABLE [Account] DROP COLUMN [ResponsiblePartyWebAccess] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_AccountResponsibleParty]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_AccountResponsibleParty](
	[AccountResponsiblePartyUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[CorporationUid] [uniqueidentifier] NULL,
	[SendStatement] [tinyint] NULL,
	[LastStatementDate] [date] NULL,
	[SendPaperlessStatements] [tinyint] NOT NULL,
	[CycleTrigger] [bit] NOT NULL,
	[DunningOn] [bit] NOT NULL,
	[DunningLevel] [smallint] NOT NULL,
	[CollectionStatusUid] [uniqueidentifier] NULL,
	[CollectionStatusLevelUid] [uniqueidentifier] NULL,
	[CollectionStatusExpirationDate] [date] NULL,
	[IsCollectionExpireDayOfMonth] [bit] NOT NULL,
	[OverrideSufficient] [bit] NOT NULL,
	[OverridePaymentAmount] [money] NOT NULL,
	[CalculatedPaymentAmount] [money] NOT NULL,
	[DateEnteredCollections] [date] NULL,
	[DateEnteredStatus] [date] NULL,
	[DateEnteredStatusLevel] [date] NULL,
	[ExcludeFromAutomatedCollections] [bit] NOT NULL,
	[PaymentsLastProcessed] [date] NULL,
	[ScheduledPaymentAllowed] [bit] NOT NULL,
	[ScheduledPayCardholderName] [varchar](255) NULL,
	[ScheduledPayCardTypeUid] [uniqueidentifier] NULL,
	[ScheduledPayCardExpirationMonth] [int] NULL,
	[ScheduledPayCardExpirationYear] [int] NULL,
	[ScheduledPayCardNumberMasked] [varchar](255) NULL,
	[ScheduledPayFieldOne] [varchar](255) NULL,
	[ScheduledPayFieldTwo] [varchar](255) NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Responsible Person, if set. If not set (null), then CorporationID must be set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Responsible Corporation, if set. If not set (null), then PersonUid must be set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'CorporationUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag to enable sending statements.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'SendStatement'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag to force inclusion in the next statement cycle.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'CycleTrigger'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag to enable dunning on statements.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'DunningOn'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last dunning level used on a statement. As appropriate, this will be incremented before a new statement is generated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'DunningLevel'
EXEC sys.sp_addextendedproperty @name=N'Replication.EnsureExternalId', @value=1 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Responsible party, a person or corporation, for family billing of accounts. SendStatement, MinimumPaymentDue, 	PlanInitiationDate, DunningOn, and DunningLevel TO BE REMOVED as the by-FinancialCenter settings in table AccountResponsiblePartySettings should be used eventually.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_Account_AccountResponsibleParty' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty'
EXEC sys.sp_addextendedproperty @name=N'SendPaperlessStatements', @value=N'<System value="0" /><Yes value="1" /><No value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty'
EXEC sys.sp_addextendedproperty @name=N'SendStatement', @value=N'<System value="0" /><Yes value="1" /><No value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_AccountResponsibleParty'

ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_AccountResponsiblePartyUid]  DEFAULT (newid()) FOR [AccountResponsiblePartyUid]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_SendStatement]  DEFAULT ((0)) FOR [SendStatement]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_SendPaperlessStatements]  DEFAULT ((0)) FOR [SendPaperlessStatements]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_CycleTrigger]  DEFAULT ((0)) FOR [CycleTrigger]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_DunningOn]  DEFAULT ((0)) FOR [DunningOn]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_DunningLevel]  DEFAULT ((0)) FOR [DunningLevel]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_IsCollectionExpireDayOfMonth]  DEFAULT ((0)) FOR [IsCollectionExpireDayOfMonth]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_OverrideSufficient]  DEFAULT ((0)) FOR [OverrideSufficient]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_OverridePaymentAmount]  DEFAULT ((0)) FOR [OverridePaymentAmount]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_CalculatedPaymentAmount]  DEFAULT ((0)) FOR [CalculatedPaymentAmount]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_ExcludeFromAutomatedCollections]  DEFAULT ((0)) FOR [ExcludeFromAutomatedCollections]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_ScheduledPaymentAllowed]  DEFAULT ((0)) FOR [ScheduledPaymentAllowed]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_AccountResponsibleParty] ADD  CONSTRAINT [DF_AccountResponsibleParty_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_AccountResponsibleParty
INSERT [migtemp_AccountResponsibleParty]([AccountResponsiblePartyUid],[PersonUid],[CorporationUid],[SendStatement],[LastStatementDate],[CycleTrigger],[DunningOn],[DunningLevel],[CollectionStatusUid],[CollectionStatusLevelUid],[CollectionStatusExpirationDate],[IsCollectionExpireDayOfMonth],[OverrideSufficient],[OverridePaymentAmount],[CalculatedPaymentAmount],[DateEnteredCollections],[DateEnteredStatus],[DateEnteredStatusLevel],[ExcludeFromAutomatedCollections],[PaymentsLastProcessed],[ScheduledPaymentAllowed],[ScheduledPayCardholderName],[ScheduledPayCardTypeUid],[ScheduledPayCardExpirationMonth],[ScheduledPayCardExpirationYear],[ScheduledPayCardNumberMasked],[ScheduledPayFieldOne],[ScheduledPayFieldTwo],[ExternalID],[Inactive],[LastModifiedDate],[LastModifiedByUid])
SELECT [AccountResponsiblePartyUid],[PersonUid],[CorporationUid],[SendStatement],[LastStatementDate],[CycleTrigger],[DunningOn],[DunningLevel],[CollectionStatusUid],[CollectionStatusLevelUid],[CollectionStatusExpirationDate],[IsCollectionExpireDayOfMonth],[OverrideSufficient],[OverridePaymentAmount],[CalculatedPaymentAmount],[DateEnteredCollections],[DateEnteredStatus],[DateEnteredStatusLevel],[ExcludeFromAutomatedCollections],[PaymentsLastProcessed],[ScheduledPaymentAllowed],[ScheduledPayCardholderName],[ScheduledPayCardTypeUid],[ScheduledPayCardExpirationMonth],[ScheduledPayCardExpirationYear],[ScheduledPayCardNumberMasked],[ScheduledPayFieldOne],[ScheduledPayFieldTwo],[ExternalID],[Inactive],[LastModifiedDate],[LastModifiedByUid]
FROM [AccountResponsibleParty]

DROP TABLE [AccountResponsibleParty]

exec  sp_rename 'migtemp_AccountResponsibleParty', 'AccountResponsibleParty'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_AccountResponsiblePartyCreditCardAuthorizationCache]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_AccountResponsiblePartyCreditCardAuthorizationCache](
	[AccountResponsiblePartyCreditCardAuthorizationCacheUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NULL,
	[LastRefreshDate] [date] NOT NULL,
	[TotalAuthorizationAmount] [money] NOT NULL,
	[ConsentDetails] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
Truncate Table migtemp_AccountResponsiblePartyCreditCardAuthorizationCache
INSERT [migtemp_AccountResponsiblePartyCreditCardAuthorizationCache]([AccountResponsiblePartyCreditCardAuthorizationCacheUid],[AccountResponsiblePartyUid],[LastRefreshDate],[TotalAuthorizationAmount],[LastModifiedDate],[LastModifiedByUid])
SELECT [AccountResponsiblePartyCreditCardAuthorizationCacheUid],[AccountResponsiblePartyUid],[LastRefreshDate],[TotalAuthorizationAmount],[LastModifiedDate],[LastModifiedByUid]
FROM [AccountResponsiblePartyCreditCardAuthorizationCache]

DROP TABLE [AccountResponsiblePartyCreditCardAuthorizationCache]

exec  sp_rename 'migtemp_AccountResponsiblePartyCreditCardAuthorizationCache', 'AccountResponsiblePartyCreditCardAuthorizationCache'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AddressHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[AddressHistory](
	[AddressHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](50) NULL,
	[StartDate] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[StartDateTime] [datetime] NULL,
	[EndDate] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[EndDateTime] [datetime] NULL,
	[AddressTypeUid] [uniqueidentifier] NULL,
	[Address1] [xml](CONTENT [dbo].[Address]) NULL,
	[Address2] [xml](CONTENT [dbo].[Address]) NULL,
	[DisplayOrder] [int] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [AddressHistory] ADD  CONSTRAINT [DF_AddressHistory_AddressHistoryUid]  DEFAULT (newid()) FOR [AddressHistoryUid]
ALTER TABLE [AddressHistory] ADD  CONSTRAINT [DF_AddressHistory_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [AddressHistory] ADD  CONSTRAINT [DF_AddressHistory_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [AddressHistory] ADD  CONSTRAINT [DF_AddressHistory_UserDefined]  DEFAULT ((0)) FOR [UserDefined]
ALTER TABLE [AddressHistory] ADD  CONSTRAINT [DF_AddressHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Appointment]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Appointment](
	[AppointmentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AppointmentTypeUid] [uniqueidentifier] NULL,
	[AppointmentStatusUid] [uniqueidentifier] NULL,
	[CheckinDateTime] [datetime] NULL,
	[DischargeDateTime] [datetime] NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[CalendarUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ProviderCareTypeUid] [uniqueidentifier] NULL,
	[ReferredbyProviderUid] [uniqueidentifier] NULL,
	[ReferringDate] [date] NULL,
	[Phone] [xml](CONTENT [dbo].[Phone]) NULL,
	[CallConfirmStatusUid] [uniqueidentifier] NULL,
	[CallConfirmStatusDetail] [varchar](max) NULL,
	[Reason] [varchar](max) NULL,
	[AuthorizationReminder] [bit] NOT NULL,
	[AuthorizationCode] [varchar](30) NULL,
	[StartDateTime] [datetime] NULL,
	[EndDateTime] [datetime] NULL,
	[ExternalID] [varchar](50) NULL,
	[Notes] [varchar](max) NULL,
	[CreatedByUid] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[TriggerOverride] [bit] NOT NULL,
	[ReferralSrcUid] [uniqueidentifier] NULL,
	[ScheduleType] [tinyint] NOT NULL,
	[PatientGroupUid] [uniqueidentifier] NULL,
	[RecurringInstanceUid] [uniqueidentifier] NULL,
	[AppointmentReplicationDataXml] [xml] NULL,
	[BillingProviderUid] [uniqueidentifier] NULL,
	[ClipboardUserUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment', @level2type=N'COLUMN',@level2name=N'AppointmentStatusUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.EnsureExternalId', @value=N'True' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'CreatedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'Replication.ListCalendar', @value=N'FK_Appointment_ListCalendar;PatientUid=NULL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_Appointment_Patient,FK_Appointment_Account,FK_RelGroupAppointmentPatient_Appointment}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'FK_Appointment_Provider;PatientUid=NULL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'
EXEC sys.sp_addextendedproperty @name=N'ScheduleType', @value=N'<PatientVisit value="0" description="Patient Visit" /><Event value="1" description="Event" /><BlockingEvent value="2" description="Blocking Event" /><GroupVisit value="3" description="Group Visit" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Appointment'

ALTER TABLE [migtemp_Appointment] ADD  CONSTRAINT [DF_Appointment_AppointmentUid]  DEFAULT (newid()) FOR [AppointmentUid]
ALTER TABLE [migtemp_Appointment] ADD  CONSTRAINT [DF_Appointment_AuthorizationReminder]  DEFAULT ((0)) FOR [AuthorizationReminder]
ALTER TABLE [migtemp_Appointment] ADD  CONSTRAINT [DF_Appointment_CreatedDate]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [migtemp_Appointment] ADD  CONSTRAINT [DF_Appointment_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_Appointment] ADD  CONSTRAINT [DF_Appointment_TriggerOverride]  DEFAULT ((0)) FOR [TriggerOverride]
ALTER TABLE [migtemp_Appointment] ADD  CONSTRAINT [DF_Appointment_ScheduleType]  DEFAULT ((0)) FOR [ScheduleType]

END
Truncate Table migtemp_Appointment
INSERT [migtemp_Appointment]([AppointmentUid],[AppointmentTypeUid],[AppointmentStatusUid],[CheckinDateTime],[DischargeDateTime],[PatientCaseUid],[PatientUid],[AccountUid],[CalendarUid],[ServiceSiteUid],[FinancialCenterUid],[ProviderUid],[ProviderCareTypeUid],[ReferredbyProviderUid],[ReferringDate],[Phone],[CallConfirmStatusUid],[CallConfirmStatusDetail],[Reason],[AuthorizationReminder],[AuthorizationCode],[StartDateTime],[EndDateTime],[ExternalID],[Notes],[CreatedByUid],[CreatedDateTime],[LastModifiedDate],[LastModifiedByUid],[TriggerOverride],[ReferralSrcUid],[ScheduleType],[PatientGroupUid],[RecurringInstanceUid],[AppointmentReplicationDataXml],[BillingProviderUid],[ClipboardUserUid])
SELECT [AppointmentUid],[AppointmentTypeUid],[AppointmentStatusUid],[CheckinDateTime],[DischargeDateTime],[PatientCaseUid],[PatientUid],[AccountUid],[CalendarUid],[ServiceSiteUid],[FinancialCenterUid],[ProviderUid],[ProviderCareTypeUid],[ReferredbyProviderUid],[ReferringDate],CONVERT(nvarchar(max), [Phone]),[CallConfirmStatusUid],[CallConfirmStatusDetail],[Reason],[AuthorizationReminder],[AuthorizationCode],[StartDateTime],[EndDateTime],[ExternalID],[Notes],[CreatedByUid],[CreatedDateTime],[LastModifiedDate],[LastModifiedByUid],[TriggerOverride],[ReferralSrcUid],[ScheduleType],[PatientGroupUid],[RecurringInstanceUid],CONVERT(nvarchar(max), [AppointmentReplicationDataXml]),[BillingProviderUid],[ClipboardUserUid]
FROM [Appointment]

DROP TABLE [Appointment]

exec  sp_rename 'migtemp_Appointment', 'Appointment'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'AR_ViewFinancialCenterClosingSummary_BatchInfo' AND COLUMN_NAME = 'FinancialCenterClosingSummaryUid')
ALTER TABLE [AR_ViewFinancialCenterClosingSummary_BatchInfo]  ALTER COLUMN [FinancialCenterClosingSummaryUid] uniqueidentifier NOT NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'AR_ViewFinancialCenterClosingSummary_DepositsWithBalance' AND COLUMN_NAME = 'FinancialCenterClosingSummaryUid')
ALTER TABLE [AR_ViewFinancialCenterClosingSummary_DepositsWithBalance]  ALTER COLUMN [FinancialCenterClosingSummaryUid] uniqueidentifier NOT NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'AR_ViewFinancialCenterClosingSummary_DepositsWithBalance' AND COLUMN_NAME = 'DepositUid')
ALTER TABLE [AR_ViewFinancialCenterClosingSummary_DepositsWithBalance]  ALTER COLUMN [DepositUid] uniqueidentifier NOT NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'AR_ViewFinancialCenterClosingSummary_ObjectLinks' AND COLUMN_NAME = 'FinancialCenterClosingSummaryUid')
ALTER TABLE [AR_ViewFinancialCenterClosingSummary_ObjectLinks]  ALTER COLUMN [FinancialCenterClosingSummaryUid] uniqueidentifier NOT NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'AR_ViewFinancialCenterClosingSummary_ObjectLinks' AND COLUMN_NAME = 'ObjectUid')
ALTER TABLE [AR_ViewFinancialCenterClosingSummary_ObjectLinks]  ALTER COLUMN [ObjectUid] uniqueidentifier NOT NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ARContext]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ARContext](
	[ARContextUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ShortDescription] [varchar](20) NULL,
	[LongDescription] [varchar](255) NULL,
	[Inactive] [bit] NOT NULL,
	[RenderingProviderUid] [uniqueidentifier] NULL,
	[ClaimingProviderUid] [uniqueidentifier] NULL,
	[AccountUid] [uniqueidentifier] NOT NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[SuperbillUid] [uniqueidentifier] NULL,
	[SuperbillProcedureUid] [uniqueidentifier] NULL,
	[NonReversedSuperbillProcedureUid] [uniqueidentifier] NULL,
	[SuperbillProcedureUnits] [decimal](20, 1) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Short description of ARContext, such as the CPT Code.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ARContext', @level2type=N'COLUMN',@level2name=N'ShortDescription'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Long description of ARContext, such as procedure description.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ARContext', @level2type=N'COLUMN',@level2name=N'LongDescription'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 if this row is of historical interest only. If 1 this row should be ignored in more queries.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ARContext', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Account subject to the ARContext.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ARContext', @level2type=N'COLUMN',@level2name=N'AccountUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Superbill associated with the ARContext.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ARContext', @level2type=N'COLUMN',@level2name=N'SuperbillUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'SuperbillProcedure from which the ARContext was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ARContext', @level2type=N'COLUMN',@level2name=N'SuperbillProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Represent the first accounting entries for buisness events which generate an amount owed. Superbill Procedures, No-Show fees, late fees, etc.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ARContext'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ARContext'
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ARContext'

ALTER TABLE [migtemp_ARContext] ADD  CONSTRAINT [DF_ARContext_ARContextUid]  DEFAULT (newid()) FOR [ARContextUid]
ALTER TABLE [migtemp_ARContext] ADD  CONSTRAINT [DF_ARContext_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ARContext] ADD  CONSTRAINT [DF_ARContext_SuperbillProcedureUnits]  DEFAULT ((1)) FOR [SuperbillProcedureUnits]
ALTER TABLE [migtemp_ARContext] ADD  CONSTRAINT [DF_ARContext_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ARContext
INSERT [migtemp_ARContext]([ARContextUid],[ShortDescription],[LongDescription],[Inactive],[RenderingProviderUid],[ClaimingProviderUid],[AccountUid],[FinancialCenterUid],[SuperbillUid],[SuperbillProcedureUid],[NonReversedSuperbillProcedureUid],[SuperbillProcedureUnits],[LastModifiedDate],[LastModifiedByUid],[ServiceSiteUid])
SELECT [ARContextUid],[ShortDescription],[LongDescription],[Inactive],[RenderingProviderUid],[ClaimingProviderUid],[AccountUid],[FinancialCenterUid],[SuperbillUid],[SuperbillProcedureUid],[NonReversedSuperbillProcedureUid],[SuperbillProcedureUnits],[LastModifiedDate],[LastModifiedByUid],[ServiceSiteUid]
FROM [ARContext]

DROP TABLE [ARContext]

exec  sp_rename 'migtemp_ARContext', 'ARContext'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_BatchProcess]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_BatchProcess](
	[BatchProcessUid] [uniqueidentifier] NOT NULL,
	[BatchProcessTypeUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[Status] [smallint] NOT NULL,
	[Parameters] [xml] NULL,
	[IntermediateXml] [xml] NULL,
	[SummaryXml] [xml] NULL,
	[ExportXml] [xml] NULL,
	[Error] [varchar](max) NULL,
	[Archive] [bit] NOT NULL,
	[AutoStartDetail] [bit] NOT NULL,
	[RunApplicationServer] [varchar](255) NULL,
	[RunMode] [smallint] NOT NULL,
	[RunStartDateTime] [datetime] NULL,
	[RunStatus] [varchar](200) NULL,
	[RunCurrentItem] [int] NULL,
	[RunTotalItems] [int] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[DisableParametersReset] [bit] NOT NULL,
	[NameFormatUid] [uniqueidentifier] NULL,
	[Stage] [varchar](100) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_BatchProcess'
EXEC sys.sp_addextendedproperty @name=N'RunMode', @value=N'<NotRunning value="0" /><Summary value="1" /><Detail value="2" /><Staging value="6" /><Resetting value="98" /><Deleting value="99" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_BatchProcess'
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<NotStarted value="0" /><Summary value="1" /><Detail value="2" /><Transmitting value="3" /><Transmitted value="4" /><Error value="-1" /><Processing value="5" /><Staging value="6" /><OnDemand value="99" /><Completed value="100" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_BatchProcess'

ALTER TABLE [migtemp_BatchProcess] ADD  CONSTRAINT [DF_BatchProcess_BatchProcessUid]  DEFAULT (newid()) FOR [BatchProcessUid]
ALTER TABLE [migtemp_BatchProcess] ADD  CONSTRAINT [DF_BatchProcess_Status]  DEFAULT ((0)) FOR [Status]
ALTER TABLE [migtemp_BatchProcess] ADD  CONSTRAINT [DF_BatchProcess_Archive]  DEFAULT ((0)) FOR [Archive]
ALTER TABLE [migtemp_BatchProcess] ADD  CONSTRAINT [DF_BatchProcess_AutoStart_1]  DEFAULT ((0)) FOR [AutoStartDetail]
ALTER TABLE [migtemp_BatchProcess] ADD  CONSTRAINT [DF_BatchProcess_RunMode]  DEFAULT ((0)) FOR [RunMode]
ALTER TABLE [migtemp_BatchProcess] ADD  CONSTRAINT [DF_BatchProcess_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [migtemp_BatchProcess] ADD  CONSTRAINT [DF_BatchProcess_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_BatchProcess] ADD  CONSTRAINT [DF_BatchProcess_DisableParametersReset]  DEFAULT ((0)) FOR [DisableParametersReset]

END
Truncate Table migtemp_BatchProcess
INSERT [migtemp_BatchProcess]([BatchProcessUid],[BatchProcessTypeUid],[Name],[Status],[Parameters],[IntermediateXml],[SummaryXml],[ExportXml],[Error],[Archive],[AutoStartDetail],[RunApplicationServer],[RunMode],[RunStartDateTime],[RunStatus],[RunCurrentItem],[RunTotalItems],[CreatedDateTime],[LastModifiedByUid],[LastModifiedDate])
SELECT [BatchProcessUid],[BatchProcessTypeUid],[Name],[Status],CONVERT(nvarchar(max), [Parameters]),CONVERT(nvarchar(max), [IntermediateXml]),CONVERT(nvarchar(max), [SummaryXml]),CONVERT(nvarchar(max), [ExportXml]),[Error],[Archive],[AutoStartDetail],[RunApplicationServer],[RunMode],[RunStartDateTime],[RunStatus],[RunCurrentItem],[RunTotalItems],[CreatedDateTime],[LastModifiedByUid],[LastModifiedDate]
FROM [BatchProcess]

DROP TABLE [BatchProcess]

exec  sp_rename 'migtemp_BatchProcess', 'BatchProcess'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_BatchProcessDetail]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_BatchProcessDetail](
	[BatchProcessDetailUid] [uniqueidentifier] NOT NULL,
	[Selected] [bit] NOT NULL,
	[BatchProcessUid] [uniqueidentifier] NOT NULL,
	[IntermediateXml] [xml] NULL,
	[DetailXml] [xml] NULL,
	[ExportXml] [xml] NULL,
	[Error] [varchar](max) NULL,
	[Uid] [uniqueidentifier] NOT NULL,
	[Uid2] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_BatchProcessDetail'

ALTER TABLE [migtemp_BatchProcessDetail] ADD  CONSTRAINT [DF_BatchProcessDetail_BatchProcessDetailUid]  DEFAULT (newid()) FOR [BatchProcessDetailUid]
ALTER TABLE [migtemp_BatchProcessDetail] ADD  CONSTRAINT [DF_BatchProcessDetail_Selected]  DEFAULT ((1)) FOR [Selected]
ALTER TABLE [migtemp_BatchProcessDetail] ADD  CONSTRAINT [DF_BatchProcessDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_BatchProcessDetail
INSERT [migtemp_BatchProcessDetail]([BatchProcessDetailUid],[BatchProcessUid],[IntermediateXml],[DetailXml],[ExportXml],[Error],[Uid],[LastModifiedByUid],[LastModifiedDate])
SELECT [BatchProcessDetailUid],[BatchProcessUid],CONVERT(nvarchar(max), [IntermediateXml]),CONVERT(nvarchar(max), [DetailXml]),CONVERT(nvarchar(max), [ExportXml]),[Error],[Uid],[LastModifiedByUid],[LastModifiedDate]
FROM [BatchProcessDetail]

DROP TABLE [BatchProcessDetail]

exec  sp_rename 'migtemp_BatchProcessDetail', 'BatchProcessDetail'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ChargeCaptureDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ChargeCaptureDiagnosis](
	[ChargeCaptureDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ChargeCaptureUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[DateApplied] [datetime] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Parent Charge Capture' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChargeCaptureDiagnosis', @level2type=N'COLUMN',@level2name=N'ChargeCaptureUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChargeCaptureDiagnosis'

ALTER TABLE [migtemp_ChargeCaptureDiagnosis] ADD  CONSTRAINT [df_ChargeCaptureDiagnosis_ChargeCaptureDiagnosisUid]  DEFAULT (newid()) FOR [ChargeCaptureDiagnosisUid]
ALTER TABLE [migtemp_ChargeCaptureDiagnosis] ADD  CONSTRAINT [df_ChargeCaptureDiagnosis_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_ChargeCaptureDiagnosis] ADD  CONSTRAINT [df_ChargeCaptureDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ChargeCaptureDiagnosis
INSERT [migtemp_ChargeCaptureDiagnosis]([ChargeCaptureDiagnosisUid],[ChargeCaptureUid],[DisplayOrder],[Code9],[Code10],[CodeDescription],[LastModifiedDate],[LastModifiedByUid])
SELECT [ChargeCaptureDiagnosisUid],[ChargeCaptureUid],[DisplayOrder],[Code9],[Code10],[CodeDescription],[LastModifiedDate],[LastModifiedByUid]
FROM [ChargeCaptureDiagnosis]

DROP TABLE [ChargeCaptureDiagnosis]

exec  sp_rename 'migtemp_ChargeCaptureDiagnosis', 'ChargeCaptureDiagnosis'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ChargeCapturePatientDiagnosisHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ChargeCapturePatientDiagnosisHistory](
	[ChargeCapturePatientDiagnosisHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[CodeDescription] [varchar](255) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[DateSaved] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ChargeCapturePatientDiagnosisHistory'

ALTER TABLE [ChargeCapturePatientDiagnosisHistory] ADD  CONSTRAINT [DF_ChargeCapturePatientDiagnosisHistory_ChargeCapturePatientDiagnosisHistoryUid]  DEFAULT (newid()) FOR [ChargeCapturePatientDiagnosisHistoryUid]
ALTER TABLE [ChargeCapturePatientDiagnosisHistory] ADD  CONSTRAINT [DF_ChargeCapturePatientDiagnosisHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [ChargeCapturePatientDiagnosisHistory] ADD  CONSTRAINT [DF_ChargeCapturePatientDiagnosisHistory_DateSaved]  DEFAULT (getdate()) FOR [DateSaved]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ChargeCaptureProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ChargeCaptureProcedure](
	[ChargeCaptureProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ChargeCaptureUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[DiagnosesList] [varchar](1500) NULL,
	[DateApplied] [datetime] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Parent Charge Capture' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChargeCaptureProcedure', @level2type=N'COLUMN',@level2name=N'ChargeCaptureUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChargeCaptureProcedure'

ALTER TABLE [migtemp_ChargeCaptureProcedure] ADD  CONSTRAINT [df_ChargeCaptureProcedure_ChargeCaptureProcedureUid]  DEFAULT (newid()) FOR [ChargeCaptureProcedureUid]
ALTER TABLE [migtemp_ChargeCaptureProcedure] ADD  CONSTRAINT [df_ChargeCaptureProcedure_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_ChargeCaptureProcedure] ADD  CONSTRAINT [df_ChargeCaptureProcedure_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ChargeCaptureProcedure
INSERT [migtemp_ChargeCaptureProcedure]([ChargeCaptureProcedureUid],[ChargeCaptureUid],[ProcedureUid],[DisplayOrder],[LastModifiedDate],[LastModifiedByUid],[DiagnosesList])
SELECT [ChargeCaptureProcedureUid],[ChargeCaptureUid],[ProcedureUid],[DisplayOrder],[LastModifiedDate],[LastModifiedByUid],[DiagnosesList]
FROM [ChargeCaptureProcedure]

DROP TABLE [ChargeCaptureProcedure]

exec  sp_rename 'migtemp_ChargeCaptureProcedure', 'ChargeCaptureProcedure'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ChcAccountResponsibleParty]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ChcAccountResponsibleParty](
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[FamilySize] [tinyint] NOT NULL,
	[MonthlyIncome] [money] NOT NULL,
	[NoIncome] [bit] NOT NULL,
	[SFCorporationUid] [uniqueidentifier] NULL,
	[SFScheduleDetailUid] [uniqueidentifier] NULL,
	[SFFormOfDeclarationUid] [uniqueidentifier] NULL,
	[SFEffectiveDate] [date] NULL,
	[NotFedSFQual] [bit] NOT NULL,
	[RefusedFSMI] [bit] NOT NULL,
	[UseSFClass] [bit] NOT NULL,
	[SFNote] [text] NULL,
	[PayFrequency] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChcAccountResponsibleParty'

ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_FamilySize]  DEFAULT ((0)) FOR [FamilySize]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_MonthlyIncome]  DEFAULT ((0)) FOR [MonthlyIncome]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_NoIncome]  DEFAULT ((1)) FOR [NoIncome]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_NotFedSFQual]  DEFAULT ((0)) FOR [NotFedSFQual]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_RefusedFSMI]  DEFAULT ((0)) FOR [RefusedFSMI]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_UseSFClass]  DEFAULT ((0)) FOR [UseSFClass]
ALTER TABLE [migtemp_ChcAccountResponsibleParty] ADD  CONSTRAINT [DF_ChcAccountResponsibleParty_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ChcAccountResponsibleParty
INSERT [migtemp_ChcAccountResponsibleParty]([AccountResponsiblePartyUid],[PersonUid],[FamilySize],[MonthlyIncome],[NoIncome],[SFCorporationUid],[SFScheduleDetailUid],[SFFormOfDeclarationUid],[SFEffectiveDate],[NotFedSFQual],[RefusedFSMI],[UseSFClass],[SFNote],[LastModifiedByUid],[LastModifiedDate])
SELECT [AccountResponsiblePartyUid],[PersonUid],[FamilySize],[MonthlyIncome],[NoIncome],[SFCorporationUid],[SFScheduleDetailUid],[SFFormOfDeclarationUid],[SFEffectiveDate],[NotFedSFQual],[RefusedFSMI],[UseSFClass],[SFNote],[LastModifiedByUid],[LastModifiedDate]
FROM [ChcAccountResponsibleParty]

DROP TABLE [ChcAccountResponsibleParty]

exec  sp_rename 'migtemp_ChcAccountResponsibleParty', 'ChcAccountResponsibleParty'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CMSCodeXml]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[CMSCodeXml](
	[FilePath] [varchar](max) NULL,
	[Measure] [varchar](10) NULL,
	[Content] [varbinary](max) NULL,
	[XMLContent] [xml] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_CollectionStatusGlobal]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_CollectionStatusGlobal](
	[CollectionStatusGlobalUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CollectionStatusGlobal_CollectionStatusGlobalUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL CONSTRAINT [DF_CollectionStatusGlobal_Name]  DEFAULT ('Global Settings'),
	[InitialCollectionStatusUid] [uniqueidentifier] NULL,
	[GlobalSufficientPercentage] [int] NULL,
	[PatientLiabilityDays] [int] NULL CONSTRAINT [DF_CollectionStatusGlobal_PatientLiabilityDays]  DEFAULT ((60)),
	[OverrideProcedureUid] [uniqueidentifier] NULL,
	[FeeDefaultProcedureUid] [uniqueidentifier] NULL,
	[FeeDefaultProviderUid] [uniqueidentifier] NULL,
	[FeeDefaultFinancialCenterUid] [uniqueidentifier] NULL,
	[FeeDefaultServiceSiteUid] [uniqueidentifier] NULL,
	[FeeBatchOwnerUid] [uniqueidentifier] NULL,
	[FeeNamingPrefix] [varchar](25) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CollectionStatusGlobal_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CollectionStatusGlobal_LastModifiedDate]  DEFAULT (getutcdate()),
	[UseStatementCountSinceLastPayment] [bit] NULL,
	[StatmentCountSinceLastPayment] [int] NULL,
	[NumberOfDaysForResponseAfterLastStatmentDate] [int] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_CollectionStatusGlobal'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_CollectionStatusGlobal'


END
Truncate Table migtemp_CollectionStatusGlobal
INSERT [migtemp_CollectionStatusGlobal]([CollectionStatusGlobalUid],[ExternalID],[Name],[InitialCollectionStatusUid],[GlobalSufficientPercentage],[PatientLiabilityDays],[OverrideProcedureUid],[FeeDefaultProcedureUid],[FeeDefaultProviderUid],[FeeDefaultFinancialCenterUid],[FeeDefaultServiceSiteUid],[FeeBatchOwnerUid],[FeeNamingPrefix],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [CollectionStatusGlobalUid],[ExternalID],[Name],[InitialCollectionStatusUid],[GlobalSufficientPercentage],[PatientLiabilityDays],[OverrideProcedureUid],[FeeDefaultProcedureUid],[FeeDefaultProviderUid],[FeeDefaultFinancialCenterUid],[FeeDefaultServiceSiteUid],[FeeBatchOwnerUid],[FeeNamingPrefix],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [CollectionStatusGlobal]

DROP TABLE [CollectionStatusGlobal]

exec  sp_rename 'migtemp_CollectionStatusGlobal', 'CollectionStatusGlobal'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Corporation]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Corporation](
	[CorporationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Corporation_CorporationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Corporation_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Address] [xml](CONTENT [dbo].[Address]) NULL,
	[BadAddress] [bit] NOT NULL CONSTRAINT [DF_Corporation_BadAddress]  DEFAULT ((0)),
	[PrimaryContact] [varchar](50) NULL,
	[SecondaryContact] [varchar](50) NULL,
	[Phone1] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone2] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone3] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone4] [xml](CONTENT [dbo].[Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Internal] [bit] NOT NULL CONSTRAINT [DF_Corporation_Internal]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Corporation_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Corporation_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Computed_Address_Address1] [varchar](100) NULL,
	[Computed_Address_Address2] [varchar](100) NULL,
	[Computed_Address_City] [varchar](35) NULL,
	[Computed_Address_State] [varchar](3) NULL,
	[Computed_Address_Zip] [varchar](10) NULL,
	[Computed_Phone1_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone1_PhoneType] [varchar](50) NULL,
	[Computed_Phone2_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone2_PhoneType] [varchar](50) NULL,
	[Computed_Phone3_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone3_PhoneType] [varchar](50) NULL,
	[Computed_Phone4_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone4_PhoneType] [varchar](50) NULL,
	[CorpNotes] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary contact name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'PrimaryContact'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Secondary contact name.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'SecondaryContact'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Email address.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Email1'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Email address.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Email2'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Address_Address1'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Address_Address2'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Address_City'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Address_State'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Address_Zip'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Corporations.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation'
EXEC sys.sp_addextendedproperty @name=N'Replication.ObjectCache', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Corporation'


END
Truncate Table migtemp_Corporation
INSERT [migtemp_Corporation]([CorporationUid],[ExternalID],[Inactive],[Name],[Address],[PrimaryContact],[SecondaryContact],[Phone1],[Phone2],[Phone3],[Phone4],[Email1],[Email2],[Internal],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[Computed_Address_Address1],[Computed_Address_Address2],[Computed_Address_City],[Computed_Address_State],[Computed_Address_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType])
SELECT [CorporationUid],[ExternalID],[Inactive],[Name],CONVERT(nvarchar(max), [Address]),[PrimaryContact],[SecondaryContact],CONVERT(nvarchar(max), [Phone1]),CONVERT(nvarchar(max), [Phone2]),CONVERT(nvarchar(max), [Phone3]),CONVERT(nvarchar(max), [Phone4]),[Email1],[Email2],[Internal],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[Computed_Address_Address1],[Computed_Address_Address2],[Computed_Address_City],[Computed_Address_State],[Computed_Address_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType]
FROM [Corporation]

DROP TABLE [Corporation]

exec  sp_rename 'migtemp_Corporation', 'Corporation'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CppAssessmentForm]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[CppAssessmentForm](
	[CppAssessmentFormUid] [uniqueidentifier] NOT NULL,
	[CppUid] [uniqueidentifier] NOT NULL,
	[AssessmentFormUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[Data] [xml] NULL,
	[Text] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CppAssessmentForm', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CppAssessmentForm', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CppAssessmentForm'

ALTER TABLE [CppAssessmentForm] ADD  CONSTRAINT [DF_CppAssessmentForm_CppAssessmentFormUid]  DEFAULT (newid()) FOR [CppAssessmentFormUid]
ALTER TABLE [CppAssessmentForm] ADD  CONSTRAINT [DF_CppAssessmentForm_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [CppAssessmentForm] ADD  CONSTRAINT [DF_CppAssessmentForm_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[CppDiagnosis]') AND name = 'DiagnosisUid')
ALTER TABLE [CppDiagnosis] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[decileTemp]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[decileTemp](
	[ListDecileCQMUID] [uniqueidentifier] NOT NULL,
	[Measure_ID] [varchar](20) NOT NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_EligibilityRequest]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_EligibilityRequest](
	[EligibilityRequestUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PersonInsurancePlanUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[RequestDateTime] [datetime] NOT NULL,
	[DateOfService] [date] NOT NULL,
	[MainAccountOnly] [bit] NOT NULL,
	[TransmitDateTime] [datetime] NULL,
	[TransmitStatus] [varchar](50) NULL,
	[SubmissionID] [int] NULL,
	[RequestXML] [varchar](max) NULL,
	[RequestX12] [varchar](max) NULL,
	[ResponseXML] [varchar](max) NULL,
	[ResponseX12] [varchar](max) NULL,
	[Error] [varchar](max) NULL,
	[EligibilityStatusUid] [uniqueidentifier] NULL,
	[CopayPrimary] [money] NULL,
	[CopaySpecialist] [money] NULL,
	[CopayOther] [money] NULL,
	[InNetworkCoinsurance] [decimal](18, 0) NULL,
	[InNetworkDeductible] [money] NULL,
	[InNetworkRemaining] [money] NULL,
	[InNetworkMet] [money] NULL,
	[OutNetworkCoinsurance] [decimal](18, 0) NULL,
	[OutNetworkDeductible] [money] NULL,
	[OutNetworkRemaining] [money] NULL,
	[OutNetworkMet] [money] NULL,
	[EligibilityEffectiveDate] [date] NULL,
	[EligibilityExpirationDate] [date] NULL,
	[EligibilityNotes] [varchar](8000) NULL,
	[RequestType] [varchar](10) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ResponseHTML] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RequestDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'RequestDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'TransmitDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'TransmitDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay amount.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'CopayPrimary'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay to use if provider is acting as a specialist.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'CopaySpecialist'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay to use if provider is not acting as primary or specialist.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest', @level2type=N'COLUMN',@level2name=N'CopayOther'
EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_EligibilityRequest'

ALTER TABLE [migtemp_EligibilityRequest] ADD  CONSTRAINT [DF_EligibilityRequest_EligibilityRequestUid]  DEFAULT (newid()) FOR [EligibilityRequestUid]
ALTER TABLE [migtemp_EligibilityRequest] ADD  CONSTRAINT [DF_EligibilityRequest_RequestDate]  DEFAULT (getutcdate()) FOR [RequestDateTime]
ALTER TABLE [migtemp_EligibilityRequest] ADD  CONSTRAINT [DF_EligibilityRequest_MainAccountOnly]  DEFAULT ((1)) FOR [MainAccountOnly]
ALTER TABLE [migtemp_EligibilityRequest] ADD  CONSTRAINT [DF_EligibilityRequest_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_EligibilityRequest
INSERT [migtemp_EligibilityRequest]([EligibilityRequestUid],[PatientUid],[PersonInsurancePlanUid],[ProviderUid],[RequestDateTime],[DateOfService],[MainAccountOnly],[TransmitDateTime],[TransmitStatus],[SubmissionID],[RequestXML],[RequestX12],[ResponseXML],[ResponseX12],[Error],[EligibilityStatusUid],[CopayPrimary],[CopaySpecialist],[CopayOther],[InNetworkCoinsurance],[InNetworkDeductible],[InNetworkRemaining],[InNetworkMet],[OutNetworkCoinsurance],[OutNetworkDeductible],[OutNetworkRemaining],[OutNetworkMet],[EligibilityEffectiveDate],[EligibilityExpirationDate],[EligibilityNotes],[RequestType],[LastModifiedDate],[LastModifiedByUid])
SELECT [EligibilityRequestUid],[PatientUid],[PersonInsurancePlanUid],[ProviderUid],[RequestDateTime],[DateOfService],[MainAccountOnly],[TransmitDateTime],[TransmitStatus],[SubmissionID],[RequestXML],[RequestX12],[ResponseXML],[ResponseX12],[Error],[EligibilityStatusUid],[CopayPrimary],[CopaySpecialist],[CopayOther],[InNetworkCoinsurance],[InNetworkDeductible],[InNetworkRemaining],[InNetworkMet],[OutNetworkCoinsurance],[OutNetworkDeductible],[OutNetworkRemaining],[OutNetworkMet],[EligibilityEffectiveDate],[EligibilityExpirationDate],[EligibilityNotes],[RequestType],[LastModifiedDate],[LastModifiedByUid]
FROM [EligibilityRequest]

DROP TABLE [EligibilityRequest]

exec  sp_rename 'migtemp_EligibilityRequest', 'EligibilityRequest'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_eReportRows]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_eReportRows](
	[eReportRowUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[eReportDetailUid] [uniqueidentifier] NOT NULL,
	[ClaimReportStatusUid] [uniqueidentifier] NULL,
	[providerUid] [varchar](50) NULL,
	[superbillUid] [uniqueidentifier] NULL,
	[patientUid] [uniqueidentifier] NULL,
	[insuredUid] [uniqueidentifier] NULL,
	[InsuranceCarrierUid] [uniqueidentifier] NULL,
	[providerName] [varchar](50) NULL,
	[payerName] [varchar](50) NULL,
	[claimProcessDate] [datetime] NULL,
	[claimID] [varchar](20) NULL,
	[claimSequenceID] [int] NULL,
	[claimType] [varchar](5) NULL,
	[patientAccountNumber] [varchar](20) NULL,
	[patientLastName] [varchar](50) NULL,
	[patientFirstName] [varchar](25) NULL,
	[patientBirthDate] [date] NULL,
	[patientPhone] [varchar](20) NULL,
	[insuredIDNumber] [varchar](20) NULL,
	[insuredGroupNumber] [varchar](20) NULL,
	[insuredLastName] [varchar](50) NULL,
	[insuredFirstName] [varchar](20) NULL,
	[primaryDiagnosisCode] [varchar](10) NULL,
	[serviceLine1FromDate] [date] NULL,
	[serviceLine1ToDate] [date] NULL,
	[serviceLine1PlaceOfService] [varchar](2) NULL,
	[primaryProcedureCode] [varchar](10) NULL,
	[serviceLine1Modifier1] [varchar](5) NULL,
	[serviceLine1Units] [varchar](5) NULL,
	[serviceLine1Charge] [money] NULL,
	[renderingDoctorUid] [varchar](50) NULL,
	[renderingPhysicianName] [varchar](50) NULL,
	[providerIDNumber] [varchar](20) NULL,
	[payerClaimControlNumber] [varchar](30) NULL,
	[payerPaidAmount] [money] NULL,
	[updateDate] [date] NULL,
	[errorDescription] [varchar](2500) NULL,
	[additionalClaimInformation] [varchar](255) NULL,
	[correspondenceContact] [varchar](50) NULL,
	[correspondencePhone] [varchar](20) NULL,
	[correspondenceName] [varchar](50) NULL,
	[correspondenceAddress] [varchar](50) NULL,
	[correspondenceCity] [varchar](30) NULL,
	[correspondenceState] [varchar](2) NULL,
	[correspondenceZip] [varchar](9) NULL,
	[clientClaimControlNumber] [varchar](30) NULL,
	[transmissionTrackingNumber] [varchar](25) NULL,
	[formType] [varchar](1) NULL,
	[perSeErrorCode] [varchar](25) NULL,
	[errorFlag] [varchar](1) NULL,
	[epayerUid] [uniqueidentifier] NULL,
	[ClaimPayerId] [varchar](25) NULL,
	[new_eReportRowUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[followUp] [bit] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_eReportRows'

ALTER TABLE [migtemp_eReportRows] ADD  CONSTRAINT [DF_eReportRows_eReportRowUid]  DEFAULT (newid()) FOR [eReportRowUid]
ALTER TABLE [migtemp_eReportRows] ADD  CONSTRAINT [DF_eReportRows_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_eReportRows] ADD  CONSTRAINT [DF_eReportRows_followUp]  DEFAULT ((1)) FOR [followUp]

END
Truncate Table migtemp_eReportRows
INSERT [migtemp_eReportRows]([eReportRowUid],[eReportDetailUid],[ClaimReportStatusUid],[providerUid],[superbillUid],[patientUid],[insuredUid],[InsuranceCarrierUid],[providerName],[payerName],[claimProcessDate],[claimID],[claimSequenceID],[claimType],[patientAccountNumber],[patientLastName],[patientFirstName],[patientBirthDate],[patientPhone],[insuredIDNumber],[insuredGroupNumber],[insuredLastName],[insuredFirstName],[primaryDiagnosisCode],[serviceLine1FromDate],[serviceLine1ToDate],[serviceLine1PlaceOfService],[primaryProcedureCode],[serviceLine1Modifier1],[serviceLine1Units],[serviceLine1Charge],[renderingDoctorUid],[renderingPhysicianName],[providerIDNumber],[payerClaimControlNumber],[payerPaidAmount],[updateDate],[errorDescription],[additionalClaimInformation],[correspondenceContact],[correspondencePhone],[correspondenceName],[correspondenceAddress],[correspondenceCity],[correspondenceState],[correspondenceZip],[clientClaimControlNumber],[transmissionTrackingNumber],[formType],[perSeErrorCode],[errorFlag],[epayerUid],[ClaimPayerId],[new_eReportRowUid],[LastModifiedDate],[LastModifiedByUid])
SELECT [eReportRowUid],[eReportDetailUid],[ClaimReportStatusUid],[providerUid],[superbillUid],[patientUid],[insuredUid],[InsuranceCarrierUid],[providerName],[payerName],[claimProcessDate],[claimID],[claimSequenceID],[claimType],[patientAccountNumber],[patientLastName],[patientFirstName],[patientBirthDate],[patientPhone],[insuredIDNumber],[insuredGroupNumber],[insuredLastName],[insuredFirstName],[primaryDiagnosisCode],[serviceLine1FromDate],[serviceLine1ToDate],[serviceLine1PlaceOfService],[primaryProcedureCode],[serviceLine1Modifier1],[serviceLine1Units],[serviceLine1Charge],[renderingDoctorUid],[renderingPhysicianName],[providerIDNumber],[payerClaimControlNumber],[payerPaidAmount],[updateDate],[errorDescription],[additionalClaimInformation],[correspondenceContact],[correspondencePhone],[correspondenceName],[correspondenceAddress],[correspondenceCity],[correspondenceState],[correspondenceZip],[clientClaimControlNumber],[transmissionTrackingNumber],[formType],[perSeErrorCode],[errorFlag],[epayerUid],[ClaimPayerId],[new_eReportRowUid],[LastModifiedDate],[LastModifiedByUid]
FROM [eReportRows]

DROP TABLE [eReportRows]

exec  sp_rename 'migtemp_eReportRows', 'eReportRows'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ErrorReport]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ErrorReport](
	[ErrorReportUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Version] [varchar](24) NULL,
	[UserName] [varchar](100) NULL,
	[ComputerName] [varchar](100) NULL,
	[Message] [varchar](max) NULL,
	[Text] [varchar](max) NULL,
	[ScreenImage] [varbinary](max) NULL,
	[Notes] [varchar](max) NULL,
	[Uploaded] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[TextXML] [xml] NULL,
	[Origin] [int] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Origin', @value=N'<Unknown value="0" /><ClientUI value="1" /><ClientNoUI value="2" /><Appserver value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ErrorReport'
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ErrorReport'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ErrorReport'

ALTER TABLE [migtemp_ErrorReport] ADD  CONSTRAINT [DF_ErrorReport_ErrorReportUid]  DEFAULT (newid()) FOR [ErrorReportUid]
ALTER TABLE [migtemp_ErrorReport] ADD  CONSTRAINT [DF_ErrorReport_Uploaded]  DEFAULT ((0)) FOR [Uploaded]
ALTER TABLE [migtemp_ErrorReport] ADD  CONSTRAINT [DF_ErrorReport_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_ErrorReport] ADD  CONSTRAINT [DF_ErrorReport_Origin]  DEFAULT ((0)) FOR [Origin]

END
Truncate Table migtemp_ErrorReport
INSERT [migtemp_ErrorReport]([ErrorReportUid],[Version],[UserName],[ComputerName],[Message],[Text],[ScreenImage],[Notes],[Uploaded],[LastModifiedDate])
SELECT [ErrorReportUid],[Version],[UserName],[ComputerName],[Message],[Text],[ScreenImage],[Notes],[Uploaded],[LastModifiedDate]
FROM [ErrorReport]

DROP TABLE [ErrorReport]

exec  sp_rename 'migtemp_ErrorReport', 'ErrorReport'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_FaxQueue]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_FaxQueue](
	[FaxQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[TransactionID] [decimal](18, 0) NULL,
	[StatusID] [int] NULL,
	[Submitted] [bit] NULL,
	[Message] [varchar](max) NULL,
	[StatusDetail] [varchar](max) NULL,
	[FaxNumber] [varchar](15) NULL,
	[RetryFaxNumber] [varchar](15) NULL,
	[FaxType] [varchar](10) NULL,
	[FaxSubType] [varchar](20) NULL,
	[FaxReceipientName] [varchar](500) NULL,
	[MsgReceipient] [uniqueidentifier] NULL,
	[SubmitTime] [datetime] NULL,
	[CompletionTime] [datetime] NULL,
	[Duration] [int] NULL,
	[Contact] [varchar](100) NULL,
	[JobID] [varchar](20) NULL,
	[PagesSent] [smallint] NULL,
	[PagesSubmitted] [smallint] NULL,
	[Subject] [varchar](200) NULL,
	[Units] [decimal](18, 2) NULL,
	[CostPerUnit] [decimal](18, 2) NULL,
	[PageSize] [varchar](10) NULL,
	[SenderCSID] [varchar](20) NULL,
	[RemoteCSID] [varchar](20) NULL,
	[PageOrientation] [varchar](20) NULL,
	[PageResolution] [varchar](20) NULL,
	[RenderingQuality] [varchar](20) NULL,
	[PageHeader] [varchar](500) NULL,
	[RetriesToPerform] [smallint] NULL,
	[TrialsPerformed] [smallint] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[Parameters] [varchar](max) NULL,
	[Parameters2] [varchar](500) NULL,
	[SequentialNumber] [int] NULL,
	[FaxCoverSheetUid] [uniqueidentifier] NULL,
	[XDN] [varchar](50) NULL,
	[ServicedBy] [varchar](20) NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[UserUid] [uniqueidentifier] NULL,
	[FaxServerUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FaxQueue'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FaxQueue'

ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_FaxQueueUid]  DEFAULT (newid()) FOR [FaxQueueUid]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_TransactionID]  DEFAULT ((0)) FOR [TransactionID]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_StatusID]  DEFAULT ((-1)) FOR [StatusID]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_Submitted]  DEFAULT ((0)) FOR [Submitted]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_SequentialNumber]  DEFAULT ((-1)) FOR [SequentialNumber]
ALTER TABLE [migtemp_FaxQueue] ADD  CONSTRAINT [DF_FaxQueue_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_FaxQueue
INSERT [migtemp_FaxQueue]([FaxQueueUid],[TransactionID],[StatusID],[Submitted],[Message],[FaxNumber],[RetryFaxNumber],[FaxType],[FaxSubType],[FaxReceipientName],[MsgReceipient],[SubmitTime],[CompletionTime],[Duration],[Contact],[JobID],[PagesSent],[PagesSubmitted],[Subject],[Units],[CostPerUnit],[PageSize],[SenderCSID],[RemoteCSID],[PageOrientation],[PageResolution],[RenderingQuality],[PageHeader],[RetriesToPerform],[TrialsPerformed],[VisitUid],[Parameters],[Parameters2],[SequentialNumber],[FaxCoverSheetUid],[XDN],[ServicedBy],[PatientUid],[UserUid],[FaxServerUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [FaxQueueUid],[TransactionID],[StatusID],[Submitted],[Message],[FaxNumber],[RetryFaxNumber],[FaxType],[FaxSubType],[FaxReceipientName],[MsgReceipient],[SubmitTime],[CompletionTime],[Duration],[Contact],[JobID],[PagesSent],[PagesSubmitted],[Subject],[Units],[CostPerUnit],[PageSize],[SenderCSID],[RemoteCSID],[PageOrientation],[PageResolution],[RenderingQuality],[PageHeader],[RetriesToPerform],[TrialsPerformed],[VisitUid],[Parameters],[Parameters2],[SequentialNumber],[FaxCoverSheetUid],[XDN],[ServicedBy],[PatientUid],[UserUid],[FaxServerUid],[LastModifiedByUid],[LastModifiedDate]
FROM [FaxQueue]

DROP TABLE [FaxQueue]

exec  sp_rename 'migtemp_FaxQueue', 'FaxQueue'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_FeeScheduleFee]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_FeeScheduleFee](
	[FeeScheduleFeeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_FeeScheduleFee_FeeScheduleFeeUid]  DEFAULT (newid()),
	[FeeSchedulePeriodUid] [uniqueidentifier] NOT NULL,
	[Fee] [money] NULL,
	[IsInsurancePlanPhysician] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_IsInsurancePlanPhysician]  DEFAULT ((0)),
	[IsInsurancePlanOther] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_IsInsurancePlanOther]  DEFAULT ((0)),
	[FixedCopayAmount] [money] NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[InsurancePercent] [smallint] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UserDefined]  DEFAULT ((1)),
	[GlobalPeriodDays] [int] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_FeeListFee_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MultiplyUnits] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_MultiplyUnits]  DEFAULT ((1)),
	[ContractTypeCodeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[PayorPlanSetUid] [uniqueidentifier] NULL,
	[FamilyPlanning] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_FamilyPlanning]  DEFAULT ((0)),
	[UseProcedureTaxableOption] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseProcedureTaxableOption]  DEFAULT ((1)),
	[TaxableOption] [smallint] NOT NULL CONSTRAINT [DF_FeeScheduleFee_TaxableOption]  DEFAULT ((0)),
	[UseAlternateInsurancePlan] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseAlternateInsurancePlan]  DEFAULT ((0)),
	[UseBillTimeRule] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseBillTimeRule]  DEFAULT ((0)),
	[BillTimeRuleUid] [uniqueidentifier] NULL,
	[BillTimeRuleConfigData] [varchar](max) NULL,
	[UseFeeScheduleRule] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseFeeScheduleRule_1]  DEFAULT ((0)),
	[BillFeeRuleUid] [uniqueidentifier] NULL,
	[BillFeeRuleConfigData] [varchar](max) NULL,
	[BillTransportationRuleConfigData] [varchar](max) NULL,
	[UseTransportationRule] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_UseTransportationRule_1]  DEFAULT ((0)),
	[DoNotClaim] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_DoNotClaim]  DEFAULT ((0)),
	[ModifierRequired] [bit] NOT NULL CONSTRAINT [DF_FeeScheduleFee_ModifierRequired]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Fee list fees.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FeeScheduleFee'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FeeScheduleFee'


END
Truncate Table migtemp_FeeScheduleFee
INSERT [migtemp_FeeScheduleFee]([FeeScheduleFeeUid],[FeeSchedulePeriodUid],[Fee],[IsInsurancePlanPhysician],[IsInsurancePlanOther],[FixedCopayAmount],[ProcedureUid],[InsurancePercent],[Inactive],[UserDefined],[GlobalPeriodDays],[LastModifiedDate],[LastModifiedByUid],[MultiplyUnits],[ContractTypeCodeUid],[Notes],[PayorPlanSetUid],[FamilyPlanning],[UseProcedureTaxableOption],[TaxableOption],[UseAlternateInsurancePlan],[UseBillTimeRule],[BillTimeRuleUid],[BillTimeRuleConfigData],[UseFeeScheduleRule],[BillFeeRuleUid],[BillFeeRuleConfigData],[BillTransportationRuleConfigData],[UseTransportationRule],[DoNotClaim])
SELECT [FeeScheduleFeeUid],[FeeSchedulePeriodUid],[Fee],[IsInsurancePlanPhysician],[IsInsurancePlanOther],[FixedCopayAmount],[ProcedureUid],[InsurancePercent],[Inactive],[UserDefined],[GlobalPeriodDays],[LastModifiedDate],[LastModifiedByUid],[MultiplyUnits],[ContractTypeCodeUid],[Notes],[PayorPlanSetUid],[FamilyPlanning],[UseProcedureTaxableOption],[TaxableOption],[UseAlternateInsurancePlan],[UseBillTimeRule],[BillTimeRuleUid],[BillTimeRuleConfigData],[UseFeeScheduleRule],[BillFeeRuleUid],[BillFeeRuleConfigData],[BillTransportationRuleConfigData],[UseTransportationRule],[DoNotClaim]
FROM [FeeScheduleFee]

DROP TABLE [FeeScheduleFee]

exec  sp_rename 'migtemp_FeeScheduleFee', 'FeeScheduleFee'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_FinancialCenter]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_FinancialCenter](
	[FinancialCenterUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_FinancialCenter_FinancialCenterUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Address] [xml](CONTENT [dbo].[Address]) NULL,
	[Phone1] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone2] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone3] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone4] [xml](CONTENT [dbo].[Phone]) NULL,
	[Email1] [varchar](255) NULL,
	[Email2] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_FinancialCenter_UserDefined]  DEFAULT ((1)),
	[ARClosedThroughDate] [date] NULL,
	[SuperbillIDPrefix] [varchar](3) NULL,
	[StatementCycle] [smallint] NOT NULL CONSTRAINT [DF_FinancialCenter_StatementCycle]  DEFAULT ((30)),
	[StatementDueDays] [smallint] NOT NULL CONSTRAINT [DF_FinancialCenter_StatementDueDays]  DEFAULT ((20)),
	[DunningMsgsUid] [uniqueidentifier] NULL,
	[StatementOnNewActivity] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_StatementOnNewActivity]  DEFAULT ((0)),
	[StatementMinimumAmount] [money] NOT NULL CONSTRAINT [DF_FinancialCenter_StatementMinimumAmount]  DEFAULT ((1)),
	[InsuranceBalanceOnlySuperbills] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_InsuranceBalanceOnlySuperbills]  DEFAULT ((0)),
	[IncludeReferringProvider] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludeReferringProvider]  DEFAULT ((1)),
	[SuppressZeroDollarProcedures] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_SuppressZeroDollarProcedures]  DEFAULT ((1)),
	[IncludeLastFileDate] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludeLastFileDate]  DEFAULT ((1)),
	[StatementFooter] [varchar](325) NULL,
	[IncludePaymentReferenceNumber] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludePaymentReferenceNumber]  DEFAULT ((1)),
	[IncludeProcedureCode] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludeProcedureCode]  DEFAULT ((1)),
	[IncludeCompletedOrClosed] [bit] NOT NULL CONSTRAINT [DF_FinancialCenter_IncludeCompletedOrClosed]  DEFAULT ((0)),
	[BlockSuperbillCreationThroughVisitDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_FinancialCenter_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[StatementModelUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Financial centers for segregating accounting and all financials.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FinancialCenter'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_FinancialCenter'


END
Truncate Table migtemp_FinancialCenter
INSERT [migtemp_FinancialCenter]([FinancialCenterUid],[ExternalID],[Name],[Address],[Phone1],[Phone2],[Phone3],[Phone4],[Email1],[Email2],[Notes],[Inactive],[UserDefined],[ARClosedThroughDate],[SuperbillIDPrefix],[StatementCycle],[StatementDueDays],[DunningMsgsUid],[StatementOnNewActivity],[StatementMinimumAmount],[InsuranceBalanceOnlySuperbills],[IncludeReferringProvider],[SuppressZeroDollarProcedures],[IncludeLastFileDate],[StatementFooter],[IncludePaymentReferenceNumber],[IncludeProcedureCode],[IncludeCompletedOrClosed],[BlockSuperbillCreationThroughVisitDate],[LastModifiedDate],[LastModifiedByUid])
SELECT [FinancialCenterUid],[ExternalID],[Name],CONVERT(nvarchar(max), [Address]),CONVERT(nvarchar(max), [Phone1]),CONVERT(nvarchar(max), [Phone2]),CONVERT(nvarchar(max), [Phone3]),CONVERT(nvarchar(max), [Phone4]),[Email1],[Email2],[Notes],[Inactive],[UserDefined],[ARClosedThroughDate],[SuperbillIDPrefix],[StatementCycle],[StatementDueDays],[DunningMsgsUid],[StatementOnNewActivity],[StatementMinimumAmount],[InsuranceBalanceOnlySuperbills],[IncludeReferringProvider],[SuppressZeroDollarProcedures],[IncludeLastFileDate],[StatementFooter],[IncludePaymentReferenceNumber],[IncludeProcedureCode],[IncludeCompletedOrClosed],[BlockSuperbillCreationThroughVisitDate],[LastModifiedDate],[LastModifiedByUid]
FROM [FinancialCenter]

DROP TABLE [FinancialCenter]

exec  sp_rename 'migtemp_FinancialCenter', 'FinancialCenter'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HIEPatient]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[HIEPatient](
	[HIEPatientUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[PatientId] [nvarchar](max) NOT NULL,
	[DocumentList] [varchar](max) NULL,
	[DocumentListDate] [datetime] NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [HIEPatient] ADD  CONSTRAINT [DF_HIEPatient_UserDefined]  DEFAULT ((0)) FOR [UserDefined]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HIEPatientDocument]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[HIEPatientDocument](
	[HIEPatientDocumentUid] [uniqueidentifier] NOT NULL,
	[HIEPatientUid] [uniqueidentifier] NOT NULL,
	[DocumentId] [varchar](max) NOT NULL,
	[DocumentStatusUid] [uniqueidentifier] NOT NULL,
	[AttachmentUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [HIEPatientDocument] ADD  CONSTRAINT [DF_HIEPatientDocument_UserDefined]  DEFAULT ((0)) FOR [UserDefined]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_HL7Partner]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_HL7Partner](
	[HL7PartnerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HL7Partner_HL7PartnerUid]  DEFAULT (newid()),
	[Name] [varchar](50) NULL,
	[ExternalId] [varchar](25) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_Inactive]  DEFAULT ((0)),
	[TestMode] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_TestMode]  DEFAULT ((0)),
	[SendPort] [smallint] NULL,
	[SendMessageDirectory] [varchar](255) NULL,
	[ReceivePort] [smallint] NULL,
	[ReceiveMessageDirectory] [varchar](255) NULL,
	[IpAddress] [varchar](50) NULL,
	[QueueLength] [smallint] NULL,
	[SendAck] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_SendAck]  DEFAULT ((0)),
	[ReceiveAck] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_ReceiveAck]  DEFAULT ((0)),
	[AckMessage] [varchar](255) NULL,
	[SegmentSeparator] [varchar](255) NULL,
	[BeginMessagePartOfMessage] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_BeginMessagePartOfMessage]  DEFAULT ((0)),
	[BeginMessage] [varchar](255) NULL,
	[EndMessage] [varchar](255) NULL,
	[HL7XmlStructure] [varchar](max) NULL,
	[FindTableMappingXml] [varchar](max) NULL,
	[KeepAliveInterval] [int] NULL,
	[MessageTypeMapping] [varchar](1024) NULL,
	[InboundFilePrefix] [varchar](50) NULL,
	[InboundFileSuffix] [varchar](50) NULL,
	[OutboundFilePrefix] [varchar](50) NULL,
	[OutboundFileSuffix] [varchar](50) NULL,
	[FTPAddress] [varchar](50) NULL,
	[FTPUser] [varchar](50) NULL,
	[FTPPassword] [varchar](250) NULL,
	[TranslatorAQN] [varchar](512) NULL,
	[TransmissionAQN] [varchar](512) NULL,
	[TransmissionSettings] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_HL7Partner_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HL7Partner_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[FTPDownloadPath] [varchar](255) NULL,
	[FTPInboundFilePrefix] [varchar](50) NULL,
	[FTPInboundFileSuffix] [varchar](50) NULL,
	[FTPSecureServer] [bit] NULL,
	[FTPPort] [smallint] NULL,
	[FTPProtocol] [uniqueidentifier] NULL,
	[ConsentStatus] [smallint] NOT NULL CONSTRAINT [DF_HL7Partner_ConsentStatus_1]  DEFAULT ((0)),
	[ConsentRequired] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_ConsentRequired_1]  DEFAULT ((0)),
	[ConsentSharingProtection] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_ConsentSharingProtection]  DEFAULT ((0)),
	[UseICD10] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_UseICD10]  DEFAULT ((0)),
	[SendError] [bit] NOT NULL CONSTRAINT [DF_HL7Partner_ZeroSendError]  DEFAULT ((0)),
	[AlertUserUid] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_HL7Partner'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_HL7Partner'


END
Truncate Table migtemp_HL7Partner
INSERT [migtemp_HL7Partner]([HL7PartnerUid],[Name],[ExternalId],[Notes],[Inactive],[TestMode],[SendPort],[SendMessageDirectory],[ReceivePort],[ReceiveMessageDirectory],[IpAddress],[QueueLength],[SendAck],[ReceiveAck],[AckMessage],[SegmentSeparator],[BeginMessagePartOfMessage],[BeginMessage],[EndMessage],[HL7XmlStructure],[FindTableMappingXml],[KeepAliveInterval],[MessageTypeMapping],[InboundFilePrefix],[InboundFileSuffix],[OutboundFilePrefix],[OutboundFileSuffix],[FTPAddress],[FTPUser],[FTPPassword],[TranslatorAQN],[TransmissionAQN],[TransmissionSettings],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[FTPDownloadPath],[FTPInboundFilePrefix],[FTPInboundFileSuffix],[FTPSecureServer],[FTPPort],[FTPProtocol],[ConsentStatus],[ConsentRequired],[ConsentSharingProtection],[UseICD10])
SELECT [HL7PartnerUid],[Name],[ExternalId],[Notes],[Inactive],[TestMode],[SendPort],[SendMessageDirectory],[ReceivePort],[ReceiveMessageDirectory],[IpAddress],[QueueLength],[SendAck],[ReceiveAck],[AckMessage],[SegmentSeparator],[BeginMessagePartOfMessage],[BeginMessage],[EndMessage],[HL7XmlStructure],[FindTableMappingXml],[KeepAliveInterval],[MessageTypeMapping],[InboundFilePrefix],[InboundFileSuffix],[OutboundFilePrefix],[OutboundFileSuffix],[FTPAddress],[FTPUser],[FTPPassword],[TranslatorAQN],[TransmissionAQN],[TransmissionSettings],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[FTPDownloadPath],[FTPInboundFilePrefix],[FTPInboundFileSuffix],[FTPSecureServer],[FTPPort],[FTPProtocol],[ConsentStatus],[ConsentRequired],[ConsentSharingProtection],[UseICD10]
FROM [HL7Partner]

DROP TABLE [HL7Partner]

exec  sp_rename 'migtemp_HL7Partner', 'HL7Partner'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[HospitalRound]') AND name = 'ForCertification')
ALTER TABLE [HospitalRound] DROP COLUMN [ForCertification] 
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[HospitalRound]') AND name = 'MedicalServiceProviderUid')
ALTER TABLE [HospitalRound] DROP COLUMN [MedicalServiceProviderUid] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ImmunizationHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ImmunizationHistory](
	[ImmunizationHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VaccineUid] [uniqueidentifier] NULL,
	[VaccineName] [varchar](255) NULL,
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[TypeofVaccineName] [varchar](255) NULL,
	[VaccineDose] [varchar](50) NULL,
	[VaccineUnits] [varchar](60) NULL,
	[AdministeredDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[AdministeredDateName] [varchar](255) NULL,
	[VaccineSiteUid] [uniqueidentifier] NULL,
	[VaccineSiteName] [varchar](255) NULL,
	[VaccineRouteUid] [uniqueidentifier] NULL,
	[VaccineRouteName] [varchar](255) NULL,
	[VaccineFundingSourceUid] [uniqueidentifier] NULL,
	[VaccineFundingSourceName] [varchar](255) NULL,
	[VFCEligibilityUid] [uniqueidentifier] NULL,
	[DateOnVIS] [date] NULL,
	[DateOnVISName] [varchar](255) NULL,
	[ExpirationDate] [date] NULL,
	[ExpirationDateName] [varchar](255) NULL,
	[VaccineMfrUid] [uniqueidentifier] NULL,
	[VaccineMfrName] [varchar](255) NULL,
	[VaccineLotNo] [varchar](255) NULL,
	[DateVISGiven] [date] NULL,
	[DateVISGivenName] [varchar](255) NULL,
	[Initials] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[VaccinatorUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ImmzHistorySourceUid] [uniqueidentifier] NULL,
	[ImmzReminderRecallUid] [uniqueidentifier] NULL,
	[ImmzRefusalUid] [uniqueidentifier] NULL,
	[ImmzCompletionUid] [uniqueidentifier] NULL,
	[ImmzReactionUid] [uniqueidentifier] NULL,
	[PatientRefused] [bit] NOT NULL,
	[ImedicaAccessionNumber] [varchar](25) NULL,
	[OriginCreateTime] [datetime] NULL,
	[InactiveDate] [date] NULL,
	[IsDelete] [bit] NOT NULL,
	[HistoryAdministeredDate] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[HistoryAdministeredFuzzyDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'AdministeredDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'AdministeredDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Orignal Create Time' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'OriginCreateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'InactiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'

ALTER TABLE [migtemp_ImmunizationHistory] ADD  CONSTRAINT [DF_ImmunizationHistory_ImmunizationHistoryUid]  DEFAULT (newid()) FOR [ImmunizationHistoryUid]
ALTER TABLE [migtemp_ImmunizationHistory] ADD  CONSTRAINT [DF_ImmunizationHistory_PatientRefused_1]  DEFAULT ((0)) FOR [PatientRefused]
ALTER TABLE [migtemp_ImmunizationHistory] ADD  CONSTRAINT [DF_ImmunizationHistory_IsDelete_1]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_ImmunizationHistory] ADD  CONSTRAINT [DF_ImmunizationHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ImmunizationHistory
INSERT [migtemp_ImmunizationHistory]([ImmunizationHistoryUid],[PatientUid],[VaccineUid],[VaccineName],[TypeofVaccineUid],[TypeofVaccineName],[VaccineDose],[VaccineUnits],[AdministeredDateTime],[AdministeredDateName],[VaccineSiteUid],[VaccineSiteName],[VaccineRouteUid],[VaccineRouteName],[VaccineFundingSourceUid],[VaccineFundingSourceName],[VFCEligibilityUid],[DateOnVIS],[DateOnVISName],[ExpirationDate],[ExpirationDateName],[VaccineMfrUid],[VaccineMfrName],[VaccineLotNo],[DateVISGiven],[DateVISGivenName],[Initials],[Notes],[VisitProcedureUid],[VaccinatorUid],[VisitUid],[ImmzHistorySourceUid],[ImmzReminderRecallUid],[ImmzRefusalUid],[ImmzCompletionUid],[ImmzReactionUid],[PatientRefused],[ImedicaAccessionNumber],[OriginCreateTime],[InactiveDate],[IsDelete],[HistoryAdministeredDate],[LastModifiedByUid],[LastModifiedDate])
SELECT [ImmunizationHistoryUid],[PatientUid],[VaccineUid],[VaccineName],[TypeofVaccineUid],[TypeofVaccineName],[VaccineDose],[VaccineUnits],[AdministeredDateTime],[AdministeredDateName],[VaccineSiteUid],[VaccineSiteName],[VaccineRouteUid],[VaccineRouteName],[VaccineFundingSourceUid],[VaccineFundingSourceName],[VFCEligibilityUid],[DateOnVIS],[DateOnVISName],[ExpirationDate],[ExpirationDateName],[VaccineMfrUid],[VaccineMfrName],[VaccineLotNo],[DateVISGiven],[DateVISGivenName],[Initials],[Notes],[VisitProcedureUid],[VaccinatorUid],[VisitUid],[ImmzHistorySourceUid],[ImmzReminderRecallUid],[ImmzRefusalUid],[ImmzCompletionUid],[ImmzReactionUid],[PatientRefused],[ImedicaAccessionNumber],[OriginCreateTime],[InactiveDate],[IsDelete],CONVERT(nvarchar(max), [HistoryAdministeredDate]),[LastModifiedByUid],[LastModifiedDate]
FROM [ImmunizationHistory]

DROP TABLE [ImmunizationHistory]

exec  sp_rename 'migtemp_ImmunizationHistory', 'ImmunizationHistory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_IMO_ProblemIT_Attribute]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_IMO_ProblemIT_Attribute](
	[IMO_ProblemIT_AttributeUid] [uniqueidentifier] NOT NULL,
	[Range] [varchar](25) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IncludeInPatientDiagnosis] [bit] NULL,
	[DSMAxis] [varchar](25) NULL,
	[LifeLong] [bit] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_IMO_ProblemIT_Attribute'

ALTER TABLE [migtemp_IMO_ProblemIT_Attribute] ADD  CONSTRAINT [DF_IMO_ProblemIT_Attribute_IMO_ProblemIT_AttributeUid]  DEFAULT (newid()) FOR [IMO_ProblemIT_AttributeUid]
ALTER TABLE [migtemp_IMO_ProblemIT_Attribute] ADD  CONSTRAINT [DF_IMO_ProblemIT_Attribute_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_IMO_ProblemIT_Attribute] ADD  CONSTRAINT [DF_IMO_ProblemIT_Attribute_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_IMO_ProblemIT_Attribute] ADD  CONSTRAINT [DF_IMO_ProblemIT_Attribute_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_IMO_ProblemIT_Attribute
INSERT [migtemp_IMO_ProblemIT_Attribute]([IMO_ProblemIT_AttributeUid],[Range],[DisplayOrder],[IncludeInPatientDiagnosis],[DSMAxis],[Notes],[Inactive],[LastModifiedByUid],[LastModifiedDate])
SELECT [IMO_ProblemIT_AttributeUid],[Range],[DisplayOrder],[IncludeInPatientDiagnosis],[DSMAxis],[Notes],[Inactive],[LastModifiedByUid],[LastModifiedDate]
FROM [IMO_ProblemIT_Attribute]

DROP TABLE [IMO_ProblemIT_Attribute]

exec  sp_rename 'migtemp_IMO_ProblemIT_Attribute', 'IMO_ProblemIT_Attribute'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ProblemIT_Custom_Word_Index' AND COLUMN_NAME = 'WORD_TEXT')
ALTER TABLE [IMO_ProblemIT_Custom_Word_Index]  ALTER COLUMN [WORD_TEXT] nvarchar(75) NOT NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_SearchQualifier]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IMO_ProblemIT_SearchQualifier](
	[IMO_ProblemIT_SearchQualifierUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_IMO_ProblemIT_SearchQualifierUid]  DEFAULT (newid()),
	[Qualifier] [nvarchar](75) NOT NULL,
	[SearchOrder] [bigint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_UserDefined]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_SearchQualifier_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IMO_ProblemIT_SearchQualifier'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IMO_ProblemIT_SearchQualifier'


END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ProblemIT_SearchResult' AND COLUMN_NAME = 'LexCode')
ALTER TABLE [IMO_ProblemIT_SearchResult]  ALTER COLUMN [LexCode] bigint NOT NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_InsurancePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_InsurancePlan](
	[InsurancePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[InsuranceCarrierUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[IsCapitated] [bit] NOT NULL,
	[UseCarrierAddress] [bit] NOT NULL,
	[Address] [xml](CONTENT [dbo].[Address]) NULL,
	[Phone] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone2] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone3] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone4] [xml](CONTENT [dbo].[Phone]) NULL,
	[UseProviderFeeSchedule] [bit] NOT NULL,
	[UseCarrierFeeSchedule] [bit] NOT NULL,
	[FeeScheduleUid] [uniqueidentifier] NULL,
	[UseInsuranceCarrierAccountType] [bit] NOT NULL,
	[AccountTypeUid] [uniqueidentifier] NULL,
	[UseCarrierAmountAllowedFeeSchedule] [bit] NOT NULL,
	[AmountAllowedFeeScheduleUid] [uniqueidentifier] NULL,
	[UseCarrierNoNetwork] [bit] NOT NULL,
	[NoNetwork] [bit] NOT NULL,
	[UseCarrierPaperClaimFormat] [bit] NOT NULL,
	[PaperClaimFormatUid] [uniqueidentifier] NULL,
	[UseCarrierElectronicClaimFormat] [bit] NOT NULL,
	[ElectronicClaimFormatUid] [uniqueidentifier] NULL,
	[UseCarrierPaperClaimDefaultOption] [bit] NOT NULL,
	[PaperClaimDefaultOptionUid] [uniqueidentifier] NULL,
	[UseCarrierMemberIDFormat] [bit] NOT NULL,
	[MemberIDFormat] [varchar](50) NULL,
	[UseCarrierGroupIDFormat] [bit] NOT NULL,
	[GroupIDFormat] [varchar](50) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ReimbursementRuleUid] [uniqueidentifier] NULL,
	[UseCarrierAutoWriteoffCreditType] [bit] NOT NULL,
	[AutoWriteoffCreditTypeUid] [uniqueidentifier] NULL,
	[CodeValidationCarrierMapUid] [uniqueidentifier] NULL,
	[UseCarrierCodeValidation] [bit] NOT NULL,
	[ReferralRequired] [bit] NULL,
	[UserCarrierReferralRequired] [bit] NOT NULL,
	[Notes] [varchar](8000) NULL,
	[OrderDefaults] [xml] NULL,
	[PayerTypologySourceUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_InsurancePlan'

ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_InsurancePlanUid]  DEFAULT (newid()) FOR [InsurancePlanUid]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_IsCapitated]  DEFAULT ((0)) FOR [IsCapitated]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierAddress]  DEFAULT ((1)) FOR [UseCarrierAddress]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseProviderFeeSchedule]  DEFAULT ((0)) FOR [UseProviderFeeSchedule]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierFeeSchedule]  DEFAULT ((1)) FOR [UseCarrierFeeSchedule]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseInsuranceCarrierAccountType]  DEFAULT ((1)) FOR [UseInsuranceCarrierAccountType]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierAmountAllowedFeeSchedule]  DEFAULT ((1)) FOR [UseCarrierAmountAllowedFeeSchedule]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierNoNetwork]  DEFAULT ((1)) FOR [UseCarrierNoNetwork]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_NoNetwork]  DEFAULT ((1)) FOR [NoNetwork]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierPaperClaimFormat]  DEFAULT ((1)) FOR [UseCarrierPaperClaimFormat]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierElectronicClaimFormat]  DEFAULT ((1)) FOR [UseCarrierElectronicClaimFormat]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierPaperClaimDefaultOption_1]  DEFAULT ((1)) FOR [UseCarrierPaperClaimDefaultOption]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierMemberIDFormat]  DEFAULT ((1)) FOR [UseCarrierMemberIDFormat]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierGroupIDformat]  DEFAULT ((1)) FOR [UseCarrierGroupIDFormat]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierAutoWriteoffCreditType]  DEFAULT ((1)) FOR [UseCarrierAutoWriteoffCreditType]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UseCarrierCodeValidation]  DEFAULT ((1)) FOR [UseCarrierCodeValidation]
ALTER TABLE [migtemp_InsurancePlan] ADD  CONSTRAINT [DF_InsurancePlan_UserCarrierReferralRequired]  DEFAULT ((1)) FOR [UserCarrierReferralRequired]

END
Truncate Table migtemp_InsurancePlan
INSERT [migtemp_InsurancePlan]([InsurancePlanUid],[InsuranceCarrierUid],[ExternalID],[Name],[Inactive],[IsCapitated],[UseCarrierAddress],[Address],[Phone],[Phone2],[Phone3],[Phone4],[UseProviderFeeSchedule],[UseCarrierFeeSchedule],[FeeScheduleUid],[UseInsuranceCarrierAccountType],[AccountTypeUid],[UseCarrierAmountAllowedFeeSchedule],[AmountAllowedFeeScheduleUid],[UseCarrierNoNetwork],[NoNetwork],[UseCarrierPaperClaimFormat],[PaperClaimFormatUid],[UseCarrierElectronicClaimFormat],[ElectronicClaimFormatUid],[UseCarrierPaperClaimDefaultOption],[PaperClaimDefaultOptionUid],[UseCarrierMemberIDFormat],[MemberIDFormat],[UseCarrierGroupIDFormat],[GroupIDFormat],[LastModifiedDate],[LastModifiedByUid],[ReimbursementRuleUid],[UseCarrierAutoWriteoffCreditType],[AutoWriteoffCreditTypeUid],[CodeValidationCarrierMapUid],[UseCarrierCodeValidation],[ReferralRequired],[UserCarrierReferralRequired],[Notes],[OrderDefaults])
SELECT [InsurancePlanUid],[InsuranceCarrierUid],[ExternalID],[Name],[Inactive],[IsCapitated],[UseCarrierAddress],CONVERT(nvarchar(max), [Address]),CONVERT(nvarchar(max), [Phone]),CONVERT(nvarchar(max), [Phone2]),CONVERT(nvarchar(max), [Phone3]),CONVERT(nvarchar(max), [Phone4]),[UseProviderFeeSchedule],[UseCarrierFeeSchedule],[FeeScheduleUid],[UseInsuranceCarrierAccountType],[AccountTypeUid],[UseCarrierAmountAllowedFeeSchedule],[AmountAllowedFeeScheduleUid],[UseCarrierNoNetwork],[NoNetwork],[UseCarrierPaperClaimFormat],[PaperClaimFormatUid],[UseCarrierElectronicClaimFormat],[ElectronicClaimFormatUid],[UseCarrierPaperClaimDefaultOption],[PaperClaimDefaultOptionUid],[UseCarrierMemberIDFormat],[MemberIDFormat],[UseCarrierGroupIDFormat],[GroupIDFormat],[LastModifiedDate],[LastModifiedByUid],[ReimbursementRuleUid],[UseCarrierAutoWriteoffCreditType],[AutoWriteoffCreditTypeUid],[CodeValidationCarrierMapUid],[UseCarrierCodeValidation],[ReferralRequired],[UserCarrierReferralRequired],[Notes],CONVERT(nvarchar(max), [OrderDefaults])
FROM [InsurancePlan]

DROP TABLE [InsurancePlan]

exec  sp_rename 'migtemp_InsurancePlan', 'InsurancePlan'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JobSchedule' AND COLUMN_NAME = 'Name')
ALTER TABLE [JobSchedule]  ALTER COLUMN [Name] varchar(255) NOT NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListAppointmentStatus]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListAppointmentStatus](
	[AppointmentStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListAppointmentStatus_AppointmentStatusUid]  DEFAULT (newid()),
	[AppointmentStatusTypeUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_DisplayOrder]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[Color] [int] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_Color]  DEFAULT ((0)),
	[ShowOnSchedule] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_ShowOnSchedule]  DEFAULT ((1)),
	[ShowOnDesktop] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_ShowOnDesktop]  DEFAULT ((1)),
	[ChargeCancelationFee] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_ChargeCancelationFee]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_UserDefined]  DEFAULT ((1)),
	[IsCanceledStatus] [bit] NOT NULL CONSTRAINT [DF_ListAppointmentStatus_IsCanceledStatus]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetSortBy', @value=N'ASC' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentStatus', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentStatus', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Appointment statuses.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentStatus'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentStatus'


END
Truncate Table migtemp_ListAppointmentStatus
INSERT [migtemp_ListAppointmentStatus]([AppointmentStatusUid],[AppointmentStatusTypeUid],[ExternalID],[Inactive],[Name],[DisplayOrder],[Notes],[Color],[ShowOnSchedule],[ShowOnDesktop],[LastModifiedDate],[LastModifiedByUid],[UserDefined],[IsCanceledStatus])
SELECT [AppointmentStatusUid],[AppointmentStatusTypeUid],[ExternalID],[Inactive],[Name],[DisplayOrder],[Notes],[Color],[ShowOnSchedule],[ShowOnDesktop],[LastModifiedDate],[LastModifiedByUid],[UserDefined],[IsCanceledStatus]
FROM [ListAppointmentStatus]

DROP TABLE [ListAppointmentStatus]

exec  sp_rename 'migtemp_ListAppointmentStatus', 'ListAppointmentStatus'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListAppointmentType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListAppointmentType](
	[AppointmentTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Color] [char](6) NOT NULL,
	[Duration] [int] NOT NULL,
	[Blocking] [bit] NOT NULL,
	[AllowBlockOverride] [bit] NOT NULL,
	[AllowPatientRequest] [bit] NOT NULL,
	[ChargeCancelationProcedureUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[GroupVisit] [bit] NOT NULL,
	[Description] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Color'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Duration'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'Blocking'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Only applied if this is a Blocking appointment type.  If set to true, warns the user but still let them schedule an appointment.  If set to false, do not allow user to schedule an appointment.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'AllowBlockOverride'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Appointment types.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListAppointmentType'

ALTER TABLE [migtemp_ListAppointmentType] ADD  CONSTRAINT [DF_ListAppointmentType_AppointmentTypeUid]  DEFAULT (newid()) FOR [AppointmentTypeUid]
ALTER TABLE [migtemp_ListAppointmentType] ADD  CONSTRAINT [DF_ListAppointmentType_IsEnabled]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ListAppointmentType] ADD  CONSTRAINT [DF_ListAppointmentType_Color]  DEFAULT ('FFFFFF') FOR [Color]
ALTER TABLE [migtemp_ListAppointmentType] ADD  CONSTRAINT [DF_ListAppointmentType_Duration]  DEFAULT ((5)) FOR [Duration]
ALTER TABLE [migtemp_ListAppointmentType] ADD  CONSTRAINT [DF_ListAppointmentType_IsBlocking]  DEFAULT ((0)) FOR [Blocking]
ALTER TABLE [migtemp_ListAppointmentType] ADD  CONSTRAINT [DF_ListAppointmentType_Warn]  DEFAULT ((0)) FOR [AllowBlockOverride]
ALTER TABLE [migtemp_ListAppointmentType] ADD  CONSTRAINT [DF_ListAppointmentType_AllowPatientRequest]  DEFAULT ((0)) FOR [AllowPatientRequest]
ALTER TABLE [migtemp_ListAppointmentType] ADD  CONSTRAINT [DF_ListAppointmentType_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_ListAppointmentType] ADD  CONSTRAINT [DF_ListAppointmentType_GroupVisit]  DEFAULT ((0)) FOR [GroupVisit]

END
Truncate Table migtemp_ListAppointmentType
INSERT [migtemp_ListAppointmentType]([AppointmentTypeUid],[ExternalID],[Inactive],[Name],[Notes],[Color],[Duration],[Blocking],[AllowBlockOverride],[AllowPatientRequest],[LastModifiedDate],[LastModifiedByUid],[GroupVisit])
SELECT [AppointmentTypeUid],[ExternalID],[Inactive],[Name],[Notes],[Color],[Duration],[Blocking],[AllowBlockOverride],[AllowPatientRequest],[LastModifiedDate],[LastModifiedByUid],[GroupVisit]
FROM [ListAppointmentType]

DROP TABLE [ListAppointmentType]

exec  sp_rename 'migtemp_ListAppointmentType', 'ListAppointmentType'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListBatchProcessType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListBatchProcessType](
	[BatchProcessTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ConfigurationAQN] [varchar](255) NULL,
	[ProcessAQN] [varchar](255) NULL,
	[SummaryXSLT] [xml] NULL,
	[SummaryRouting] [varchar](255) NULL,
	[DetailXSLT] [xml] NULL,
	[DetailRouting] [varchar](255) NULL,
	[MaxConcurrency] [smallint] NOT NULL CONSTRAINT [DF_ListBatchProcessType_MaxConcurrency]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListBatchProcessType_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListBatchProcessType_UserDefined]  DEFAULT ((1)),
	[AutoStartDetail] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_AutoStartDetail]  DEFAULT ((0)),
	[Hide] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_Hide]  DEFAULT ((1)),
	[AllowIsCached] [bit] NOT NULL CONSTRAINT [DF_ListBatchProcessType_AllowIsCached]  DEFAULT ((0))
) ON [PRIMARY]



END
Truncate Table migtemp_ListBatchProcessType
INSERT [migtemp_ListBatchProcessType]([BatchProcessTypeUid],[ExternalID],[Name],[Notes],[ConfigurationAQN],[ProcessAQN],[SummaryXSLT],[SummaryRouting],[DetailXSLT],[DetailRouting],[MaxConcurrency],[Inactive],[LastModifiedByUid],[LastModifiedDate],[UserDefined])
SELECT [BatchProcessTypeUid],[ExternalID],[Name],[Notes],[ConfigurationAQN],[ProcessAQN],CONVERT(nvarchar(max), [SummaryXSLT]),[SummaryRouting],CONVERT(nvarchar(max), [DetailXSLT]),[DetailRouting],[MaxConcurrency],[Inactive],[LastModifiedByUid],[LastModifiedDate],[UserDefined]
FROM [ListBatchProcessType]

DROP TABLE [ListBatchProcessType]

exec  sp_rename 'migtemp_ListBatchProcessType', 'ListBatchProcessType'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListCaseModule]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListCaseModule](
	[CaseModuleUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCaseModule_CaseModuleUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCaseModule_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ControlClass] [varchar](255) NULL,
	[RequiresUserDefinedControlGroup] [bit] NOT NULL CONSTRAINT [DF_ListCaseModule_RequiresUserDefinedControlGroup]  DEFAULT ((0)),
	[RequiresFormLayout] [bit] NOT NULL CONSTRAINT [DF_ListCaseModule_RequiresFormLayout]  DEFAULT ((0)),
	[RequiresControlClass] [bit] NOT NULL CONSTRAINT [DF_ListCaseModule_RequiresControlClass]  DEFAULT ((0)),
	[UserDefinedControlGroupUid] [uniqueidentifier] NULL,
	[FormLayoutUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCaseModule_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCaseModule_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseModule'


END
Truncate Table migtemp_ListCaseModule
INSERT [migtemp_ListCaseModule]([CaseModuleUid],[ExternalID],[Inactive],[Name],[Notes],[ControlClass],[RequiresUserDefinedControlGroup],[UserDefinedControlGroupUid],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [CaseModuleUid],[ExternalID],[Inactive],[Name],[Notes],[ControlClass],[RequiresUserDefinedControlGroup],[UserDefinedControlGroupUid],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListCaseModule]

DROP TABLE [ListCaseModule]

exec  sp_rename 'migtemp_ListCaseModule', 'ListCaseModule'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListCaseType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListCaseType](
	[CaseTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCaseType_CaseTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCaseType_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCaseType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCaseType_LastModifiedDate]  DEFAULT (getutcdate()),
	[DisplayAlertsOnVisits] [bit] NOT NULL CONSTRAINT [DisplayAlertsOnVisitsNoNull]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'CaseTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'ListCaseTypeModule;ListCaseTypePhase' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'case type' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType'


END
Truncate Table migtemp_ListCaseType
INSERT [migtemp_ListCaseType]([CaseTypeUid],[ExternalID],[Inactive],[Name],[Notes],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [CaseTypeUid],[ExternalID],[Inactive],[Name],[Notes],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListCaseType]

DROP TABLE [ListCaseType]

exec  sp_rename 'migtemp_ListCaseType', 'ListCaseType'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListCollectionStatus]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListCollectionStatus](
	[CollectionStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListCollectionStatus_CollectionStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](150) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListCollectionStatus_InActive]  DEFAULT ((0)),
	[SendStatement] [bit] NOT NULL CONSTRAINT [DF_ListCollectionStatus_SendStatement]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListCollectionStatus_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListCollectionStatus_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'CollectionStatusLevel' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCollectionStatus'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCollectionStatus'


END
Truncate Table migtemp_ListCollectionStatus
INSERT [migtemp_ListCollectionStatus]([CollectionStatusUid],[ExternalID],[Name],[Inactive],[LastModifiedByUid],[LastModifiedDate],[UserDefined])
SELECT [CollectionStatusUid],[ExternalID],[Name],[Inactive],[LastModifiedByUid],[LastModifiedDate],[UserDefined]
FROM [ListCollectionStatus]

DROP TABLE [ListCollectionStatus]

exec  sp_rename 'migtemp_ListCollectionStatus', 'ListCollectionStatus'

exec sp_dropDF
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListCVXCode', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListCVXCode'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListDecileCQM]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListDecileCQM](
	[DecileCQMUID] [uniqueidentifier] NOT NULL CONSTRAINT [df_ListDecileCQM_DecileCQMUID]  DEFAULT (newsequentialid()),
	[MeasureName] [varchar](max) NOT NULL,
	[Measure_ID] [varchar](20) NOT NULL,
	[CQMUID] [uniqueidentifier] NOT NULL,
	[CQMYear] [varchar](7) NOT NULL,
	[Decile3_Low] [numeric](6, 3) NULL,
	[Decile3_High] [numeric](6, 3) NULL,
	[Decile4_Low] [numeric](6, 3) NULL,
	[Decile4_High] [numeric](6, 3) NULL,
	[Decile5_Low] [numeric](6, 3) NULL,
	[Decile5_High] [numeric](6, 3) NULL,
	[Decile6_Low] [numeric](6, 3) NULL,
	[Decile6_High] [numeric](6, 3) NULL,
	[Decile7_Low] [numeric](6, 3) NULL,
	[Decile7_High] [numeric](6, 3) NULL,
	[Decile8_Low] [numeric](6, 3) NULL,
	[Decile8_High] [numeric](6, 3) NULL,
	[Decile9_Low] [numeric](6, 3) NULL,
	[Decile9_High] [numeric](6, 3) NULL,
	[Decile10_Low] [numeric](6, 3) NULL,
	[Decile10_High] [numeric](6, 3) NULL,
	[Inactive] [bit] NULL CONSTRAINT [df_ListDecileCQM_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [df_ListDecileCQM_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NULL CONSTRAINT [df_ListDecileCQM_UserDefined]  DEFAULT ((0)),
	[LastModifiedByUID] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosisRangePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListDiagnosisRangePlan](
	[DiagnosisRangePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListDiagnosisRangePlan'

ALTER TABLE [ListDiagnosisRangePlan] ADD  CONSTRAINT [DF_ListDiagnosisRangePlan_DiagnosisRangePlanUid]  DEFAULT (newid()) FOR [DiagnosisRangePlanUid]
ALTER TABLE [ListDiagnosisRangePlan] ADD  CONSTRAINT [DF_ListDiagnosisRangePlan_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListDiagnosisRangePlan] ADD  CONSTRAINT [DF_ListDiagnosisRangePlan_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListDiagnosisRangePlan] ADD  CONSTRAINT [DF_ListDiagnosisPlan_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosisSearchDefinition]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListDiagnosisSearchDefinition](
	[DiagnosisSearchDefinitionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDiagnosisSearchDefinition_DiagnosisSearchDefinitionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Definition] [varchar](max) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDiagnosisSearchDefinition_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDiagnosisSearchDefinition_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDiagnosisSearchDefinition_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListDiagnosisSearchDefinition'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListDpnGroup]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListDpnGroup](
	[DpnGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDpnGroup_DpnGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDpnGroup_Inactive]  DEFAULT ((0)),
	[IsPlan] [bit] NOT NULL CONSTRAINT [DF_ListDpnGroup_IsPlan]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDpnGroup_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListDpnGroup_DisplayOrder]  DEFAULT ((0)),
	[MaxNodeLevel] [int] NULL CONSTRAINT [DF_ListDpnGroup_MaxNodeLevel]  DEFAULT ((1)),
	[Node0Description] [varchar](25) NULL,
	[Node1Description] [varchar](25) NULL,
	[Node2Description] [varchar](25) NULL,
	[Node3Description] [varchar](25) NULL,
	[Node4Description] [varchar](25) NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[PatientDashboardUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDpnGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelDpnGroupDpnNode;RelDpnGroupOrderAction;ObservationOrder;VisitProcedure;RelProcedureDpn' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListDpnGroup'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListDpnGroup'


END
Truncate Table migtemp_ListDpnGroup
INSERT [migtemp_ListDpnGroup]([DpnGroupUid],[ExternalID],[Inactive],[Name],[UserDefined],[Notes],[DisplayOrder],[MaxNodeLevel],[Node0Description],[Node1Description],[Node2Description],[Node3Description],[Node4Description],[ClinicCenterOverride],[ProviderOverride],[LastModifiedByUid],[LastModifiedDate])
SELECT [DpnGroupUid],[ExternalID],[Inactive],[Name],[UserDefined],[Notes],[DisplayOrder],[MaxNodeLevel],[Node0Description],[Node1Description],[Node2Description],[Node3Description],[Node4Description],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LastModifiedByUid],[LastModifiedDate]
FROM [ListDpnGroup]

DROP TABLE [ListDpnGroup]

exec  sp_rename 'migtemp_ListDpnGroup', 'ListDpnGroup'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListDpnNode]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListDpnNode](
	[DpnNodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDpnNode_DpnNodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDpnNode_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[NaturalLanguage] [varchar](100) NULL,
	[Conjunctor] [varchar](100) NULL,
	[ExcludeFromReport] [bit] NOT NULL CONSTRAINT [DF_ListDpnNode_ExcludeFromReport]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDpnNode_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListDpnNode_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDpnNode_LastModifiedDate]  DEFAULT (getutcdate()),
	[FindTableUid] [uniqueidentifier] NULL,
	[FindUid] [uniqueidentifier] NULL,
	[SubFindTableUid] [uniqueidentifier] NULL,
	[AllowsBilaterality] [bit] NOT NULL CONSTRAINT [DF_ListDpnNode_AllowsBilaterality]  DEFAULT ((0)),
	[IsPlan] [bit] NOT NULL CONSTRAINT [DF_ListDpnNode_IsPlan]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListDpnNode'


END
Truncate Table migtemp_ListDpnNode
INSERT [migtemp_ListDpnNode]([DpnNodeUid],[ExternalID],[Inactive],[Name],[NaturalLanguage],[Conjunctor],[ExcludeFromReport],[UserDefined],[Notes],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate],[FindTableUid],[FindUid],[SubFindTableUid],[AllowsBilaterality])
SELECT [DpnNodeUid],[ExternalID],[Inactive],[Name],[NaturalLanguage],[Conjunctor],[ExcludeFromReport],[UserDefined],[Notes],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate],[FindTableUid],[FindUid],[SubFindTableUid],[AllowsBilaterality]
FROM [ListDpnNode]

DROP TABLE [ListDpnNode]

exec  sp_rename 'migtemp_ListDpnNode', 'ListDpnNode'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'iforeignkey' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.MaxRows' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.MaxRows' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'EduFormUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'EduFormUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'Inactive'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'Name'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'VisitEduForm' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'education form' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.MaxRows' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.MaxRows', @value=N'100' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'EduFormUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'EduFormUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'Inactive'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 for inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name or description of attachment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListEduForm', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEduForm', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'ClaimClearingHouseUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'ClaimClearingHouseUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'ClearingHousePayerID'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'ClearingHousePayerID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'PayerOrgID'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'PayerOrgID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'Name'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'RegistrationRequired'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'RegistrationRequired'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Electronic payers for the clearinghouse indicated and to be chosen by the insurance payer (carrier) when wishing to send claims electronically.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'ClaimClearingHouseUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The clearinghouse to which this payer belongs' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'ClaimClearingHouseUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'ClearingHousePayerID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The electronic payer ID used by the clearing house' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'ClearingHousePayerID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'PayerOrgID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The electronic payer ID found on patient''s insurance card, typically the NAIC' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'PayerOrgID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'electronic payer name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListElectronicPayer', N'COLUMN',N'RegistrationRequired'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates whether the payer requires practice to sign up before sending claims electronically' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListElectronicPayer', @level2type=N'COLUMN',@level2name=N'RegistrationRequired'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListFaxServer]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListFaxServer](
	[FaxServerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFaxServer_FaxServerUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](10) NOT NULL,
	[UserName] [varchar](100) NULL,
	[Password] [varchar](100) NULL,
	[DocType] [varchar](10) NULL,
	[DocName] [varchar](100) NULL,
	[DocData] [varbinary](max) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFaxServer_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFaxServer_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFaxServer_LastModifiedDate]  DEFAULT (getutcdate()),
	[AQN] [varchar](512) NULL,
	[ServiceURL] [varchar](200) NULL,
	[OrderActionTemplateXml] [xml] NULL,
	[OutboundFolder] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListFaxServer'


END
Truncate Table migtemp_ListFaxServer
INSERT [migtemp_ListFaxServer]([FaxServerUid],[ExternalID],[Name],[UserName],[Password],[DocType],[DocName],[DocData],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate],[AQN],[ServiceURL],[OrderActionTemplateXml])
SELECT [FaxServerUid],[ExternalID],[Name],[UserName],[Password],[DocType],[DocName],[DocData],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate],[AQN],[ServiceURL],CONVERT(nvarchar(max), [OrderActionTemplateXml])
FROM [ListFaxServer]

DROP TABLE [ListFaxServer]

exec  sp_rename 'migtemp_ListFaxServer', 'ListFaxServer'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'iforeignkey' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Cache.Required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelFilterNotification' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ExcludeRowIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ListFilter', N'COLUMN',N'JobScheduleUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.ExcludeRowIfValueSet', @value=N'is not null' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFilter', @level2type=N'COLUMN',@level2name=N'JobScheduleUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'AllowDelete' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'AllowDelete' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Prepopulate' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Prepopulate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Cache.Required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', N'COLUMN',N'AllowDelete'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable', @level2type=N'COLUMN',@level2name=N'AllowDelete'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', N'COLUMN',N'ExportBusinessObjectList'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable', @level2type=N'COLUMN',@level2name=N'ExportBusinessObjectList'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'AllowDelete' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'AllowDelete', @value=N'<None value="0" />
<Delete value="1" />
<Merge value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Prepopulate' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Prepopulate', @value=N'<None value="0" />
<All value="1" />
<MFU_Frequency value="2" />
<MRU value="3" />
<MFU_Alpha value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', N'COLUMN',N'AllowDelete'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 - Don''t allow delete or merge; 1 - allow Delete; 2 - allow Merge' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable', @level2type=N'COLUMN',@level2name=N'AllowDelete'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListFindTable', N'COLUMN',N'ExportBusinessObjectList'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Semicolon separated list of BusinessObjects to include when exporting this BusinessObject' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindTable', @level2type=N'COLUMN',@level2name=N'ExportBusinessObjectList'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListFormLayout]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListFormLayout](
	[FormLayoutUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListFormLayout_FormLayoutUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormLayout_Inactive]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormLayout_UserDefined]  DEFAULT ((1)),
	[UIControlUid] [uniqueidentifier] NOT NULL,
	[Data] [xml] NULL,
	[RequireDataTag] [bit] NOT NULL CONSTRAINT [DF_ListFormLayout_RequireDataTag]  DEFAULT ((1)),
	[LicenseCode] [varchar](50) NULL,
	[AllowMulti] [bit] NOT NULL CONSTRAINT [DF_ListFormLayout_AllowMulti]  DEFAULT ((0)),
	[TitleDefinition] [varchar](2048) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormLayout_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
Truncate Table migtemp_ListFormLayout
INSERT [migtemp_ListFormLayout]([FormLayoutUid],[ExternalID],[Name],[Inactive],[Notes],[UserDefined],[UIControlUid],[Data],[RequireDataTag],[LicenseCode],[LastModifiedByUid],[LastModifiedDate])
SELECT [FormLayoutUid],[ExternalID],[Name],[Inactive],[Notes],[UserDefined],[UIControlUid],CONVERT(nvarchar(max), [Data]),[RequireDataTag],[LicenseCode],[LastModifiedByUid],[LastModifiedDate]
FROM [ListFormLayout]

DROP TABLE [ListFormLayout]

exec  sp_rename 'migtemp_ListFormLayout', 'ListFormLayout'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListFormLayoutControlAction]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListFormLayoutControlAction](
	[FormLayoutControlActionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Table_1_FormLayoutActionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormLayoutControlAction_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormLayoutControlAction_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormLayoutControlAction_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFormLayoutControlAction', @level2type=N'COLUMN',@level2name=N'UserDefined'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListFormLayoutControlActionEvent]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListFormLayoutControlActionEvent](
	[FormLayoutControlActionEventUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFormLayoutControlActionEvent_FormLayoutControlActionEventUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormLayoutControlActionEvent_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormLayoutControlActionEvent_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormLayoutControlActionEvent_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFormLayoutControlActionEvent', @level2type=N'COLUMN',@level2name=N'UserDefined'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListGenderIdentity]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListGenderIdentity](
	[GenderIdentityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListGenderIdentity_GenderIdentityUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListGenderIdentity_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListGenderIdentity_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListGenderIdentity_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListGenderIdentity', @level2type=N'COLUMN',@level2name=N'UserDefined'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListHIPAAReleaseInfo]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListHIPAAReleaseInfo](
	[HIPAAReleaseInfoUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_HIPAAReleaseUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListHIPAAReleaseInfo_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListHIPAAReleaseInfo', @level2type=N'COLUMN',@level2name=N'UserDefined'


END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzCompletion' AND COLUMN_NAME = 'Name')
ALTER TABLE [ListImmzCompletion]  ALTER COLUMN [Name] varchar(255) NOT NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzContraindication' AND COLUMN_NAME = 'ConceptName')
ALTER TABLE [ListImmzContraindication]  ALTER COLUMN [ConceptName] varchar(255) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzContraindication' AND COLUMN_NAME = 'Definition')
ALTER TABLE [ListImmzContraindication]  ALTER COLUMN [Definition] varchar(255) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzEvidenceOfImmunity' AND COLUMN_NAME = 'ConceptName')
ALTER TABLE [ListImmzEvidenceOfImmunity]  ALTER COLUMN [ConceptName] varchar(255) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzEvidenceOfImmunity' AND COLUMN_NAME = 'Definition')
ALTER TABLE [ListImmzEvidenceOfImmunity]  ALTER COLUMN [Definition] varchar(255) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzHistorySource' AND COLUMN_NAME = 'Name')
ALTER TABLE [ListImmzHistorySource]  ALTER COLUMN [Name] varchar(255) NOT NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzReaction' AND COLUMN_NAME = 'ConceptName')
ALTER TABLE [ListImmzReaction]  ALTER COLUMN [ConceptName] varchar(255) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzReaction' AND COLUMN_NAME = 'Definition')
ALTER TABLE [ListImmzReaction]  ALTER COLUMN [Definition] varchar(255) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzRefusal' AND COLUMN_NAME = 'Name')
ALTER TABLE [ListImmzRefusal]  ALTER COLUMN [Name] varchar(255) NOT NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzReminderRecall' AND COLUMN_NAME = 'Name')
ALTER TABLE [ListImmzReminderRecall]  ALTER COLUMN [Name] varchar(255) NOT NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzSpecialIndications' AND COLUMN_NAME = 'ConceptName')
ALTER TABLE [ListImmzSpecialIndications]  ALTER COLUMN [ConceptName] varchar(255) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListImmzSpecialIndications' AND COLUMN_NAME = 'Definition')
ALTER TABLE [ListImmzSpecialIndications]  ALTER COLUMN [Definition] varchar(255) NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListIndustry]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListIndustry](
	[IndustryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListIndustry_IndustryUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListIndustry_Inactive]  DEFAULT ((0)),
	[Name] [varchar](max) NOT NULL,
	[IndustryCode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListIndustry_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListIndustry_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListIndustry', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Industries' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListIndustry'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListIndustry'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListIntegrationPartner]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListIntegrationPartner](
	[IntegrationPartnerUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ListIntegrationPartner]  DEFAULT (newid()),
	[Name] [varchar](250) NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[FieldsEditorControlAQN] [varchar](512) NULL,
	[ActivationHandlerAQN] [varchar](512) NULL,
	[AdditionalOutboundXML] [varchar](max) NULL,
	[Notes] [text] NULL,
	[TestMode] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_TestMode]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_UserDefined]  DEFAULT ((1)),
	[OrganizationEditAQN] [varchar](512) NULL,
	[ProviderEditAQN] [varchar](512) NULL,
	[OrganizationEditDeleteAllowed] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_OrganizationEditDeleteAllowed]  DEFAULT ((0)),
	[ProviderEditDeleteAllowed] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ProviderEditDeleteAllowed]  DEFAULT ((0)),
	[SearchAvailable] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_DirectoryAvailable]  DEFAULT ((0)),
	[ConsentStatus] [smallint] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ConsentStatus]  DEFAULT ((2)),
	[ConsentRequired] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ConsentRequired]  DEFAULT ((0)),
	[ConsentSharingProtection] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_ConsentSharingProtection]  DEFAULT ((0)),
	[UsesApi] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_UsesApi]  DEFAULT ((0)),
	[AllowApiUse] [bit] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_AllowApiUse]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListIntegrationPartner_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListIntegrationPartner'


END
Truncate Table migtemp_ListIntegrationPartner
INSERT [migtemp_ListIntegrationPartner]([IntegrationPartnerUid],[Name],[ExternalID],[FieldsEditorControlAQN],[ActivationHandlerAQN],[AdditionalOutboundXML],[Notes],[TestMode],[Inactive],[UserDefined],[OrganizationEditAQN],[ProviderEditAQN],[OrganizationEditDeleteAllowed],[ProviderEditDeleteAllowed],[SearchAvailable],[ConsentStatus],[ConsentRequired],[ConsentSharingProtection],[LastModifiedDate],[LastModifiedByUid])
SELECT [IntegrationPartnerUid],[Name],[ExternalID],[FieldsEditorControlAQN],[ActivationHandlerAQN],[AdditionalOutboundXML],[Notes],[TestMode],[Inactive],[UserDefined],[OrganizationEditAQN],[ProviderEditAQN],[OrganizationEditDeleteAllowed],[ProviderEditDeleteAllowed],[SearchAvailable],[ConsentStatus],[ConsentRequired],[ConsentSharingProtection],[LastModifiedDate],[LastModifiedByUid]
FROM [ListIntegrationPartner]

DROP TABLE [ListIntegrationPartner]

exec  sp_rename 'migtemp_ListIntegrationPartner', 'ListIntegrationPartner'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListLOINC', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListLOINC'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListLOINC', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListLOINC'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListLOINC', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListLOINC'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListLOINC', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListLOINC'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListLOINC', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListLOINC'
GO
BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListMessageRouting' AND COLUMN_NAME = 'Name')
ALTER TABLE [ListMessageRouting]  ALTER COLUMN [Name] varchar(250) NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListNameFormat]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListNameFormat](
	[NameFormatUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListNameFormat_NameFormatUid]  DEFAULT (newid()),
	[NameFormatTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNameFormat_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNameFormat_UserDefined]  DEFAULT ((1)),
	[NameFormat] [varchar](255) NULL,
	[TemplateProperties] [xml] NULL,
	[ValidationType] [smallint] NOT NULL CONSTRAINT [DF_ListNameFormat_ValidationType]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListNameFormat_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'ValidationType', @value=N'<None value="0" /><FileName value="1"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListNameFormat'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListNameFormatType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListNameFormatType](
	[NameFormatTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListNameFormatType_NameFormatTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[BusinessObject] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNameFormatType_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNameFormatType_UserDefined]  DEFAULT ((0)),
	[TypeProperties] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListNameFormatType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListOccupation]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListOccupation](
	[OccupationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListOccupation_OccupationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListOccupation_Inactive]  DEFAULT ((0)),
	[Name] [varchar](max) NOT NULL,
	[OccupationCode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListOccupation_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListOccupation_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListOccupation', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Occupations' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListOccupation'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListOccupation'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListPatientDashboard]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListPatientDashboard](
	[PatientDashboardUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[PhoneConfigurationXml] [xml] NULL,
	[TabletConfigurationXml] [xml] NULL,
	[DesktopConfigurationXml] [xml] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListPatientDashboard_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]



END
Truncate Table migtemp_ListPatientDashboard
INSERT [migtemp_ListPatientDashboard]([PatientDashboardUid],[ExternalID],[Name],[DisplayOrder],[UserDefined],[PhoneConfigurationXml],[TabletConfigurationXml],[DesktopConfigurationXml],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientDashboardUid],[ExternalID],[Name],[DisplayOrder],[UserDefined],CONVERT(nvarchar(max), [PhoneConfigurationXml]),CONVERT(nvarchar(max), [TabletConfigurationXml]),CONVERT(nvarchar(max), [DesktopConfigurationXml]),[LastModifiedByUid],[LastModifiedDate]
FROM [ListPatientDashboard]

DROP TABLE [ListPatientDashboard]

exec  sp_rename 'migtemp_ListPatientDashboard', 'ListPatientDashboard'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientProgram]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListPatientProgram](
	[PatientProgramUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[ToolbarText] [varchar](10) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Color] [int] NOT NULL
) ON [PRIMARY]


ALTER TABLE [ListPatientProgram] ADD  CONSTRAINT [DF_ListPatientProgram_PatientProgramUid]  DEFAULT (newid()) FOR [PatientProgramUid]
ALTER TABLE [ListPatientProgram] ADD  CONSTRAINT [DF_ListPatientProgram_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListPatientProgram] ADD  CONSTRAINT [DF_ListPatientProgram_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListPatientProgram] ADD  CONSTRAINT [DF_ListPatientProgram_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [ListPatientProgram] ADD  CONSTRAINT [PP_ListPatientProgram_Color]  DEFAULT ((0)) FOR [Color]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListPayerTypologySource]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListPayerTypologySource](
	[PayerTypologySourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPayerTypologySource_PayerTypologySourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Code] [varchar](10) NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPayerTypologySource_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListPlanDefaults]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListPlanDefaults](
	[PlanDefaultsUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](500) NOT NULL,
	[PlanGroupUid] [uniqueidentifier] NOT NULL,
	[SelectionXML] [varchar](max) NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[PatientInstruction] [varchar](max) NULL,
	[PlanComment] [varchar](max) NULL,
	[PhysicianComment] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedBy] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [ListPlanDefaults] ADD  CONSTRAINT [DF_ListPlanDefaults_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListPlanGroup]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListPlanGroup](
	[PlanGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[MaxNodeLevel] [int] NULL,
	[Node0Description] [varchar](25) NULL,
	[Node1Description] [varchar](25) NULL,
	[Node2Description] [varchar](25) NULL,
	[Node3Description] [varchar](25) NULL,
	[Node4Description] [varchar](25) NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelPlanGroupPlanNode;RelPlanGroupOrderAction;ObservationOrder;VisitProcedure;RelProcedurePlan' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListPlanGroup'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListPlanGroup'

ALTER TABLE [ListPlanGroup] ADD  CONSTRAINT [DF_ListPlanGroup_PlanGroupUid]  DEFAULT (newid()) FOR [PlanGroupUid]
ALTER TABLE [ListPlanGroup] ADD  CONSTRAINT [DF_ListPlanGroup_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListPlanGroup] ADD  CONSTRAINT [DF_ListPlanGroup_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListPlanGroup] ADD  CONSTRAINT [DF_ListPlanGroup_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [ListPlanGroup] ADD  CONSTRAINT [DF_ListPlanGroup_MaxNodeLevel]  DEFAULT ((1)) FOR [MaxNodeLevel]
ALTER TABLE [ListPlanGroup] ADD  CONSTRAINT [DF_ListPlanGroup_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListPlanNode]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListPlanNode](
	[PlanNodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[NaturalLanguage] [varchar](100) NULL,
	[Conjunctor] [varchar](100) NULL,
	[ExcludeFromReport] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[FindTableUid] [uniqueidentifier] NULL,
	[FindUid] [uniqueidentifier] NULL,
	[SubFindTableUid] [uniqueidentifier] NULL,
	[AllowsBilaterality] [bit] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListPlanNode'

ALTER TABLE [ListPlanNode] ADD  CONSTRAINT [DF_ListPlanNode_PlanNodeUid]  DEFAULT (newid()) FOR [PlanNodeUid]
ALTER TABLE [ListPlanNode] ADD  CONSTRAINT [DF_ListPlanNode_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListPlanNode] ADD  CONSTRAINT [DF_ListPlanNode_ExcludeFromReport]  DEFAULT ((0)) FOR [ExcludeFromReport]
ALTER TABLE [ListPlanNode] ADD  CONSTRAINT [DF_ListPlanNode_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListPlanNode] ADD  CONSTRAINT [DF_ListPlanNode_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [ListPlanNode] ADD  CONSTRAINT [DF_ListPlanNode_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [ListPlanNode] ADD  CONSTRAINT [DF_ListPlanNode_AllowsBilaterality]  DEFAULT ((0)) FOR [AllowsBilaterality]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListPracticeForm]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListPracticeForm](
	[PracticeFormUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[AttachmentGroupUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [ListPracticeForm] ADD  CONSTRAINT [DF_ListPracticeForm_PracticeFormUid]  DEFAULT (newid()) FOR [PracticeFormUid]
ALTER TABLE [ListPracticeForm] ADD  CONSTRAINT [DF_ListPracticeForm_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListPracticeForm] ADD  CONSTRAINT [DF_ListPracticeForm_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListPracticeForm] ADD  CONSTRAINT [DF_ListPracticeForm_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListProcedure](
	[ProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedure_ProcedureUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_Inactive]  DEFAULT ((0)),
	[Code] [varchar](30) NOT NULL,
	[MasterProcedureUid] [uniqueidentifier] NULL,
	[ProcedureCodeTypeUid] [uniqueidentifier] NULL,
	[ProcedureServiceTypeUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[ProcedureGroupUid] [uniqueidentifier] NULL,
	[ShortDescription] [varchar](75) NOT NULL,
	[LongDescription] [varchar](1024) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IsEM] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_IsEM]  DEFAULT ((0)),
	[DefaultDontClaim] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_DefaultDontClaim]  DEFAULT ((0)),
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[Unit] [int] NULL CONSTRAINT [DF_ListProcedure_Unit]  DEFAULT ((1)),
	[ProcedureModifier1Uid] [uniqueidentifier] NULL,
	[ProcedureModifier2Uid] [uniqueidentifier] NULL,
	[ProcedureModifier3Uid] [uniqueidentifier] NULL,
	[ProcedureModifier4Uid] [uniqueidentifier] NULL,
	[FDB_MEDID] [int] NULL,
	[NDC] [varchar](50) NULL,
	[NDCUnitMeasureUid] [uniqueidentifier] NULL,
	[GenerateObservationOrder] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_GenerateObservationOrder]  DEFAULT ((0)),
	[RevenueCode] [varchar](10) NULL,
	[Cost] [money] NULL,
	[NDCQuantity] [varchar](15) NULL,
	[UsePracticeTaxableOption] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_UsePracticeTaxableOption]  DEFAULT ((1)),
	[TaxableOption] [smallint] NOT NULL CONSTRAINT [DF_ListProcedure_TaxableOption]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[IncludeInPatientProcedure] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_IncludeInPatientProcedure]  DEFAULT ((1)),
	[ShortDescriptionChangedFromMaster] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_ShortDescriptionChangedFromMaster]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedure_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedure_LastModifiedDate]  DEFAULT (getutcdate()),
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[SnomedConceptID2] [varchar](50) NULL,
	[DescriptionUid2] [uniqueidentifier] NULL,
	[ImageResultsDirectlyAccessible] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_ImageResultsDirectlyAccessible]  DEFAULT ((0)),
	[PurchasedServiceCharge] [money] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL,
	[RequireDpn] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_RequireDpn]  DEFAULT ((0)),
	[SortToBottom] [bit] NOT NULL CONSTRAINT [DF_ListProcedure_SortCodeAtEnd]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ShowInLabResults' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure', @level2type=N'COLUMN',@level2name=N'GenerateObservationOrder'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelProcedureSetProcedure;RelProcedureCategory;RelProcedureLaboratoryOrder;RelProcedurePanelProcedure;RelProcedureTypeofVaccine;VisitProcedure' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure'


END
Truncate Table migtemp_ListProcedure
INSERT [migtemp_ListProcedure]([ProcedureUid],[ExternalID],[Inactive],[Code],[MasterProcedureUid],[ProcedureCodeTypeUid],[ProcedureServiceTypeUid],[ServiceSiteUid],[ProcedureGroupUid],[ShortDescription],[LongDescription],[Notes],[IsEM],[DefaultDontClaim],[EffectiveDate],[ExpirationDate],[Unit],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[FDB_MEDID],[NDC],[NDCUnitMeasureUid],[GenerateObservationOrder],[RevenueCode],[Cost],[NDCQuantity],[UsePracticeTaxableOption],[TaxableOption],[SnomedConceptID],[LOINCUid],[DescriptionUid],[IncludeInPatientProcedure],[ShortDescriptionChangedFromMaster],[UserDefined],[LastModifiedByUid],[LastModifiedDate],[HistoryGroupUid],[SnomedConceptID2],[DescriptionUid2],[ImageResultsDirectlyAccessible],[PurchasedServiceCharge],[MedicalServicesProviderUid],[RequireDpn])
SELECT [ProcedureUid],[ExternalID],[Inactive],[Code],[MasterProcedureUid],[ProcedureCodeTypeUid],[ProcedureServiceTypeUid],[ServiceSiteUid],[ProcedureGroupUid],[ShortDescription],[LongDescription],[Notes],[IsEM],[DefaultDontClaim],[EffectiveDate],[ExpirationDate],[Unit],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[FDB_MEDID],[NDC],[NDCUnitMeasureUid],[GenerateObservationOrder],[RevenueCode],[Cost],[NDCQuantity],[UsePracticeTaxableOption],[TaxableOption],[SnomedConceptID],[LOINCUid],[DescriptionUid],[IncludeInPatientProcedure],[ShortDescriptionChangedFromMaster],[UserDefined],[LastModifiedByUid],[LastModifiedDate],[HistoryGroupUid],[SnomedConceptID2],[DescriptionUid2],[ImageResultsDirectlyAccessible],[PurchasedServiceCharge],[MedicalServicesProviderUid],[RequireDpn]
FROM [ListProcedure]

DROP TABLE [ListProcedure]

exec  sp_rename 'migtemp_ListProcedure', 'ListProcedure'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureHistoryStatus]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListProcedureHistoryStatus](
	[ProcedureHistoryStatusUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedureHistoryStatus_ProcedureHistoryStatusUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedureHistoryStatus_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedureHistoryStatus_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedureHistoryStatus_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1: user-defined' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProcedureHistoryStatus', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProcedureHistoryStatus', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'getutcdate() for LastModifiedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProcedureHistoryStatus', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProcedureHistoryStatus'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureHistoryTerm]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListProcedureHistoryTerm](
	[ProcedureHistoryTermUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListProcedureHistoryTerm_ProcedureHistoryTermUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](255) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListProcedureHistoryTerm_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListProcedureHistoryTerm_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListProcedureHistoryTerm_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1: user-defined' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProcedureHistoryTerm', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProcedureHistoryTerm', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'getutcdate() for LastModifiedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProcedureHistoryTerm', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProcedureHistoryTerm'


END
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'ListProductParameter', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverReplicate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProductParameter'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ExcludeRowIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ListProductParameter', N'COLUMN',N'ParameterName'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ExcludeRowIfValueSet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProductParameter', @level2type=N'COLUMN',@level2name=N'ParameterName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ExcludeRowIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ListProductParameter', N'COLUMN',N'ParameterName'))
EXEC sys.sp_addextendedproperty @name=N'Replication.ExcludeRowIfValueSet', @value=N'CommonDatabase;Update;Weekly Updates' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProductParameter', @level2type=N'COLUMN',@level2name=N'ParameterName'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListReport', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'iforeignkey' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReport'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListReport', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReport'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListReport', N'COLUMN',N'UseBusinessObject'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReport', @level2type=N'COLUMN',@level2name=N'UseBusinessObject'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListReport', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReport'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListReport', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'ListReportRdl' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReport'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListReport', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReport'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListReport', N'COLUMN',N'UseBusinessObject'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'When "true" (1) the business object context data set will be used for the data source of the report.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReport', @level2type=N'COLUMN',@level2name=N'UseBusinessObject'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListReportability]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListReportability](
	[ReportabilityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListReportability_ReportabilityUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Description] [varchar](max) NOT NULL,
	[ICD9Code] [varchar](20) NULL,
	[ICD10Code] [varchar](20) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListReportability_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListReportability_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_ListReportability_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReportability', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reportabilitys' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReportability'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReportability'


END
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListReportRdl', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReportRdl'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.MaxRows' , N'SCHEMA',N'dbo', N'TABLE',N'ListReportRdl', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.MaxRows' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReportRdl'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListReportRdl', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReportRdl'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListReportRdl', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReportRdl'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.MaxRows' , N'SCHEMA',N'dbo', N'TABLE',N'ListReportRdl', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.MaxRows', @value=100 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListReportRdl'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListScantronSurveyFormFields', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListScantronSurveyFormFields'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListScantronSurveyFormFields', N'COLUMN',N'Name'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListScantronSurveyFormFields', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListScantronSurveyFormFields', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListScantronSurveyFormFields'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListScantronSurveyFormFields', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListScantronSurveyFormFields'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListScantronSurveyFormFields', N'COLUMN',N'Name'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the field in the scantron form.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListScantronSurveyFormFields', @level2type=N'COLUMN',@level2name=N'Name'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Cache.Required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurity', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurity', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Cache.Required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'Permission'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'Permission'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'Permission'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'Permission'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ListSecurityGroup', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSecurityGroup', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListServiceSite]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListServiceSite](
	[ServiceSiteUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[ServiceSiteTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[InternalSite] [bit] NOT NULL,
	[PrimaryContact] [varchar](100) NULL,
	[SecondaryContact] [varchar](100) NULL,
	[Address] [xml](CONTENT [dbo].[Address]) NULL,
	[Phone1] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone2] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone3] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone4] [xml](CONTENT [dbo].[Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[FormalName] [varchar](50) NULL,
	[TypeOfBill] [varchar](5) NULL,
	[TimeZone] [varchar](30) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelServiceSiteTaxRate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListServiceSite'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Clinical service sites used by the practice (hospitals, nursing homes, etc)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListServiceSite'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListServiceSite'

ALTER TABLE [migtemp_ListServiceSite] ADD  CONSTRAINT [DF_ListServiceSite_ServiceSiteUid]  DEFAULT (newid()) FOR [ServiceSiteUid]
ALTER TABLE [migtemp_ListServiceSite] ADD  CONSTRAINT [DF_ListServiceSite_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ListServiceSite] ADD  CONSTRAINT [DF_ListServiceSite_InternalSite]  DEFAULT ((0)) FOR [InternalSite]
ALTER TABLE [migtemp_ListServiceSite] ADD  CONSTRAINT [DF_ListServiceSite_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ListServiceSite
INSERT [migtemp_ListServiceSite]([ServiceSiteUid],[FinancialCenterUid],[ServiceSiteTypeUid],[ExternalID],[Inactive],[Name],[InternalSite],[PrimaryContact],[SecondaryContact],[Address],[Phone1],[Phone2],[Phone3],[Phone4],[Email1],[Email2],[Notes],[FormalName],[TypeOfBill],[TimeZone],[LastModifiedDate],[LastModifiedByUid])
SELECT [ServiceSiteUid],[FinancialCenterUid],[ServiceSiteTypeUid],[ExternalID],[Inactive],[Name],[InternalSite],[PrimaryContact],[SecondaryContact],CONVERT(nvarchar(max), [Address]),CONVERT(nvarchar(max), [Phone1]),CONVERT(nvarchar(max), [Phone2]),CONVERT(nvarchar(max), [Phone3]),CONVERT(nvarchar(max), [Phone4]),[Email1],[Email2],[Notes],[FormalName],[TypeOfBill],[TimeZone],[LastModifiedDate],[LastModifiedByUid]
FROM [ListServiceSite]

DROP TABLE [ListServiceSite]

exec  sp_rename 'migtemp_ListServiceSite', 'ListServiceSite'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListSexualOrientation]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListSexualOrientation](
	[SexualOrientationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListSexualOrientation_SexualOrientationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListSexualOrientation_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[ANSICode] [varchar](10) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListSexualOrientation_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListSexualOrientation_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListSexualOrientation', @level2type=N'COLUMN',@level2name=N'UserDefined'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListState]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListState](
	[StateUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Abbreviation] [varchar](50) NOT NULL,
	[DriversLicenseOid] [varchar](50) NOT NULL CONSTRAINT [DF_ListState_DriversLicenseOid]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListSurveySection' AND COLUMN_NAME = 'ContainsPatientHxQuestion')
ALTER TABLE [ListSurveySection]  ALTER COLUMN [ContainsPatientHxQuestion] bit NOT NULL 
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListUIControl', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUIControl'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserDefinedControl', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserDefinedControl'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserDefinedControl', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserDefinedControl'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserDefinedControl', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserDefinedControl'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserDefinedControlGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'iforeignkey' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserDefinedControlGroup'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserDefinedControlGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserDefinedControlGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserDefinedControlGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserDefinedControlGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserDefinedControlGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'ListUserDefinedControl' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserDefinedControlGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserDefinedControlGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserDefinedControlGroup'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'iforeignkey' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'UserGroupMember' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ListUserGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUserGroup'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListUserSetting]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListUserSetting](
	[UserSettingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListUserSetting_UserSettingUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[ClinicalNoteTypes] [xml](CONTENT [dbo].[UidList]) NULL,
	[FormattingTemplateUid] [uniqueidentifier] NULL,
	[NoteSingleColumn] [nchar](10) NULL,
	[MinWidth] [int] NOT NULL CONSTRAINT [DF_ListUserSetting_MinWidth_1]  DEFAULT ((100)),
	[FontSize] [float] NOT NULL CONSTRAINT [DF_ListUserSetting_FontSize_1]  DEFAULT ((10.0)),
	[UseNewOPSRPN] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_UseNewOPSRPN_1]  DEFAULT ((1)),
	[AttachmentAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientDemographicAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[NoteAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[AppointmentNoteAddIn] [xml] NULL,
	[VitalsAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientToolbarAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[DesktopAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[AppointmentAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[SuperbillChargeProcessorAddInUid] [uniqueidentifier] NULL,
	[ServiceProcedureAddInUid] [uniqueidentifier] NULL,
	[VisitSaveAddInUid] [uniqueidentifier] NULL,
	[PatientDemographicsPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[NotePrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[OPSPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[RPNPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[JobEngineStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_JobEngineStatus_1]  DEFAULT ((0)),
	[MasterServerStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MasterServerStatus]  DEFAULT ((0)),
	[CacheServerStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CacheServerStatus_1]  DEFAULT ((0)),
	[AutoCapitalization] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoCapitalization_1]  DEFAULT ((1)),
	[AutoComplete] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoComplete_1]  DEFAULT ((1)),
	[TryDelete] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_TryDelete_1]  DEFAULT ((1)),
	[VoiceRecording] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_VoiceRecording_1]  DEFAULT ((1)),
	[InkInput] [smallint] NOT NULL CONSTRAINT [DF_ListUserSetting_InkInput_1]  DEFAULT ((0)),
	[DockingStyle] [smallint] NOT NULL CONSTRAINT [DF_ListUserSetting_DockingStyle_1]  DEFAULT ((0)),
	[StartupSound] [varchar](255) NULL,
	[SelectionColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[RequiredColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[PatientInputColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[BorderColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[AllowCPO] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AllowCPO_1]  DEFAULT ((0)),
	[AutoCheckCPOGeneration] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoCheckCPOGeneration]  DEFAULT ((0)),
	[WarnOnCancelNote] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_WarnOnCancelNote_1]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserSetting_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[MaximizeForms] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MaximizeForms]  DEFAULT ((0)),
	[BackgroundSave] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_BackgroundSave]  DEFAULT ((1)),
	[UseNewOPS] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_UseNewOPS]  DEFAULT ((0)),
	[DisplayPrinterDialog] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_DisplayRxPrinterDialog]  DEFAULT ((0)),
	[ProcessHMRulesOnNoteSave] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_ProcessHMRulesOnNoteSave_1]  DEFAULT ((1)),
	[CheckoutPlanTemplateUid] [uniqueidentifier] NULL,
	[RPNPrintButtonUid] [uniqueidentifier] NULL,
	[OPSPrintButtonUid] [uniqueidentifier] NULL,
	[RxConsentFormattingTemplateUid] [uniqueidentifier] NULL,
	[RxConsentAttachmentTypeUid] [uniqueidentifier] NULL,
	[RxConsentMedication] [xml](CONTENT [dbo].[UidList]) NULL,
	[StandardHistoryDisplay] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_StandardHistoryDisplay]  DEFAULT ((0)),
	[OtherSettings] [xml] NULL,
	[ShowRVUSearchingCPTUid] [uniqueidentifier] NULL,
	[IncludeEMInMFU] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_IncludeEMInMFU_1]  DEFAULT ((0)),
	[MultiWindow] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MultiWindow_1]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserSetting_LastModifiedDate]  DEFAULT (getutcdate()),
	[CheckoutEducationForm] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutEducationForm]  DEFAULT ((0)),
	[CheckoutVisitReceipt] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutVisitReceipt]  DEFAULT ((0)),
	[CheckoutSuperbill] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutSuperbill]  DEFAULT ((0)),
	[CheckoutUncheckAll] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutUncheckAll]  DEFAULT ((0)),
	[EditorFont] [xml] NULL,
	[FncCompleteNoteValidatorAddIns] [xml](CONTENT [dbo].[UidList]) NULL
) ON [PRIMARY]



END
Truncate Table migtemp_ListUserSetting
INSERT [migtemp_ListUserSetting]([UserSettingUid],[ExternalID],[Inactive],[Name],[ClinicCenterUid],[ClinicalNoteTypes],[FormattingTemplateUid],[NoteSingleColumn],[MinWidth],[FontSize],[UseNewOPSRPN],[AttachmentAddIns],[PatientDemographicAddIns],[NoteAddIns],[AppointmentNoteAddIn],[VitalsAddIns],[PatientToolbarAddIns],[DesktopAddIns],[AppointmentAddIns],[SuperbillChargeProcessorAddInUid],[ServiceProcedureAddInUid],[VisitSaveAddInUid],[PatientDemographicsPrint],[NotePrint],[OPSPrint],[RPNPrint],[PatientPrint],[JobEngineStatus],[MasterServerStatus],[CacheServerStatus],[AutoCapitalization],[AutoComplete],[TryDelete],[VoiceRecording],[InkInput],[DockingStyle],[StartupSound],[SelectionColor],[RequiredColor],[PatientInputColor],[BorderColor],[AllowCPO],[AutoCheckCPOGeneration],[WarnOnCancelNote],[UserDefined],[Notes],[MaximizeForms],[BackgroundSave],[UseNewOPS],[DisplayPrinterDialog],[ProcessHMRulesOnNoteSave],[CheckoutPlanTemplateUid],[RPNPrintButtonUid],[OPSPrintButtonUid],[RxConsentFormattingTemplateUid],[RxConsentAttachmentTypeUid],[RxConsentMedication],[StandardHistoryDisplay],[OtherSettings],[ShowRVUSearchingCPTUid],[IncludeEMInMFU],[MultiWindow],[LastModifiedByUid],[LastModifiedDate])
SELECT [UserSettingUid],[ExternalID],[Inactive],[Name],[ClinicCenterUid],CONVERT(nvarchar(max), [ClinicalNoteTypes]),[FormattingTemplateUid],[NoteSingleColumn],[MinWidth],[FontSize],[UseNewOPSRPN],CONVERT(nvarchar(max), [AttachmentAddIns]),CONVERT(nvarchar(max), [PatientDemographicAddIns]),CONVERT(nvarchar(max), [NoteAddIns]),CONVERT(nvarchar(max), [AppointmentNoteAddIn]),CONVERT(nvarchar(max), [VitalsAddIns]),CONVERT(nvarchar(max), [PatientToolbarAddIns]),CONVERT(nvarchar(max), [DesktopAddIns]),CONVERT(nvarchar(max), [AppointmentAddIns]),[SuperbillChargeProcessorAddInUid],[ServiceProcedureAddInUid],[VisitSaveAddInUid],CONVERT(nvarchar(max), [PatientDemographicsPrint]),CONVERT(nvarchar(max), [NotePrint]),CONVERT(nvarchar(max), [OPSPrint]),CONVERT(nvarchar(max), [RPNPrint]),CONVERT(nvarchar(max), [PatientPrint]),[JobEngineStatus],[MasterServerStatus],[CacheServerStatus],[AutoCapitalization],[AutoComplete],[TryDelete],[VoiceRecording],[InkInput],[DockingStyle],[StartupSound],CONVERT(nvarchar(max), [SelectionColor]),CONVERT(nvarchar(max), [RequiredColor]),CONVERT(nvarchar(max), [PatientInputColor]),CONVERT(nvarchar(max), [BorderColor]),[AllowCPO],[AutoCheckCPOGeneration],[WarnOnCancelNote],[UserDefined],[Notes],[MaximizeForms],[BackgroundSave],[UseNewOPS],[DisplayPrinterDialog],[ProcessHMRulesOnNoteSave],[CheckoutPlanTemplateUid],[RPNPrintButtonUid],[OPSPrintButtonUid],[RxConsentFormattingTemplateUid],[RxConsentAttachmentTypeUid],CONVERT(nvarchar(max), [RxConsentMedication]),[StandardHistoryDisplay],CONVERT(nvarchar(max), [OtherSettings]),[ShowRVUSearchingCPTUid],[IncludeEMInMFU],[MultiWindow],[LastModifiedByUid],[LastModifiedDate]
FROM [ListUserSetting]

DROP TABLE [ListUserSetting]

exec  sp_rename 'migtemp_ListUserSetting', 'ListUserSetting'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListVaccineMfr', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListVaccineMfr'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListVaccineMfr', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListVaccineMfr'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListVaccineMfr', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListVaccineMfr'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListVFCEligibility', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListVFCEligibility'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListVoiceTag', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListVoiceTag'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CanTranslate' , N'SCHEMA',N'dbo', N'TABLE',N'ListVoiceTag', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListVoiceTag'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListVoiceTag', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListVoiceTag'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListZip]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListZip](
	[ZipUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListZip_ZipUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](10) NOT NULL,
	[City] [varchar](25) NULL,
	[CityCode] [varchar](20) NULL,
	[State] [varchar](3) NULL,
	[StateCode] [varchar](10) NULL,
	[Country] [varchar](100) NULL,
	[CountryCode] [varchar](10) NULL,
	[AreaCode] [varchar](4) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListZip_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListZip_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListZip_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'CanTranslate', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListZip'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListZip'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListZip'


END
Truncate Table migtemp_ListZip
INSERT [migtemp_ListZip]([ZipUid],[ExternalID],[Name],[City],[State],[AreaCode],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [ZipUid],[ExternalID],[Name],[City],[State],[AreaCode],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListZip]

DROP TABLE [ListZip]

exec  sp_rename 'migtemp_ListZip', 'ListZip'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Message]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Message](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ParentMessageUid] [uniqueidentifier] NULL,
	[CreatedByUid] [uniqueidentifier] NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[MessageTypeUid] [uniqueidentifier] NOT NULL,
	[MessageSubTypeUid] [uniqueidentifier] NULL,
	[Header] [varchar](8000) NULL,
	[MessageUrgencyUid] [uniqueidentifier] NULL,
	[MessageStatusUid] [uniqueidentifier] NULL,
	[CreatedDate] [date] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[DateToBeCompleted] [datetime] NULL,
	[AutoComplete] [bit] NOT NULL,
	[DateCompleted] [datetime] NULL,
	[LastReadByUid] [uniqueidentifier] NULL,
	[CompletedByUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[StrikeOut] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageDataXML] [xml](CONTENT [dbo].[MessageData]) NULL,
	[FirstReadDate] [datetime] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the guid of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the guid of the message that is the parent. This is used when a message is split into multiple messages. Each of the new messages will have its parent set to the message from which it originated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'ParentMessageUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the person that created the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the patient with whom  the message is associated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the type of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the string used to display the message in a list' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'Header'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the urgency of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageUrgencyUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the status of the message. A message that is completed can be archived.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageStatusUid'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'DateCreated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the message was created' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'DateCreated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the message was completed' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CompletedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores message envelopes. The context of a message is stored in a separate table, e.g. MessageTask or MessageRx' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'DateCompleted,LastReadByUid,CompletedByUid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.Lock', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_Message_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'

ALTER TABLE [migtemp_Message] ADD  CONSTRAINT [DF_Message_MessageUid]  DEFAULT (newid()) FOR [MessageUid]
ALTER TABLE [migtemp_Message] ADD  CONSTRAINT [DF_Message_CreatedDate]  DEFAULT (getdate()) FOR [CreatedDate]
ALTER TABLE [migtemp_Message] ADD  CONSTRAINT [DF_Message_DateCreated]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [migtemp_Message] ADD  CONSTRAINT [DF_Message_AutoComplete]  DEFAULT ((0)) FOR [AutoComplete]
ALTER TABLE [migtemp_Message] ADD  CONSTRAINT [DF_Message_StrikeOut_1]  DEFAULT ((0)) FOR [StrikeOut]
ALTER TABLE [migtemp_Message] ADD  CONSTRAINT [DF_Msgs_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_Message
INSERT [migtemp_Message]([MessageUid],[ParentMessageUid],[CreatedByUid],[PersonUid],[MessageTypeUid],[MessageSubTypeUid],[Header],[MessageUrgencyUid],[MessageStatusUid],[CreatedDate],[CreatedDateTime],[DateToBeCompleted],[AutoComplete],[DateCompleted],[LastReadByUid],[CompletedByUid],[VisitUid],[StrikeOut],[LastModifiedDate],[LastModifiedByUid],[MessageDataXML])
SELECT [MessageUid],[ParentMessageUid],[CreatedByUid],[PersonUid],[MessageTypeUid],[MessageSubTypeUid],[Header],[MessageUrgencyUid],[MessageStatusUid],[CreatedDate],[CreatedDateTime],[DateToBeCompleted],[AutoComplete],[DateCompleted],[LastReadByUid],[CompletedByUid],[VisitUid],[StrikeOut],[LastModifiedDate],[LastModifiedByUid],CONVERT(nvarchar(max), [MessageDataXML])
FROM [Message]

DROP TABLE [Message]

exec  sp_rename 'migtemp_Message', 'Message'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MessageBackfillQueue]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MessageBackfillQueue](
	[MessageBackfillQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[HL7PartnerMessageUid] [uniqueidentifier] NULL,
	[HL7ActionTypeObjectUid] [uniqueidentifier] NULL,
	[TransmissionOutboundUid] [uniqueidentifier] NULL,
	[TransmissionType] [varchar](50) NULL,
	[ActionType] [varchar](50) NULL,
	[ObjectType] [varchar](50) NULL,
	[ObjectUid] [uniqueidentifier] NULL,
	[MessageContextXML] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ProcessingError] [bit] NOT NULL,
	[Status] [int] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MessageBackfillQueue'

ALTER TABLE [MessageBackfillQueue] ADD  CONSTRAINT [DF_MessageBackfillQueue_HL7BackfillQueue]  DEFAULT (newid()) FOR [MessageBackfillQueueUid]
ALTER TABLE [MessageBackfillQueue] ADD  CONSTRAINT [DF_MessageBackfillQueue_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [MessageBackfillQueue] ADD  CONSTRAINT [DF_MessageBackfillQueue_ProcessingError]  DEFAULT ((0)) FOR [ProcessingError]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_MU2_InterfaceDataMapping]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_MU2_InterfaceDataMapping](
	[InterfaceDataMappingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_InterfaceDataMappingUid]  DEFAULT (newid()),
	[Rootid] [varchar](40) NOT NULL,
	[Name] [varchar](100) NULL,
	[CCDCode] [varchar](25) NOT NULL,
	[PRMCode] [varchar](25) NULL,
	[CCDPrintName] [varchar](250) NULL,
	[IsDefault] [bit] NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_Default]  DEFAULT ((0)),
	[Inactive] [bit] NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [DF_MU2_InterfaceDataMapping1_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[NCQMeasure] [varchar](10) NULL,
	[TopicIndicator] [varchar](50) NULL,
	[NQFNumber] [varchar](10) NULL,
	[DataElementName] [varchar](100) NULL,
	[Modifier] [varchar](25) NULL,
	[EndDate] [varchar](25) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_MU2Interface_DisplayOrder]  DEFAULT ((0)),
	[QRDASection] [varchar](50) NULL,
	[CQMVersion] [varchar](7) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_MU2_InterfaceDataMapping'


END
Truncate Table migtemp_MU2_InterfaceDataMapping
INSERT [migtemp_MU2_InterfaceDataMapping]([InterfaceDataMappingUid],[Rootid],[Name],[CCDCode],[PRMCode],[CCDPrintName],[IsDefault],[Inactive],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[NCQMeasure],[TopicIndicator],[NQFNumber],[DataElementName],[Modifier],[EndDate],[DisplayOrder],[QRDASection])
SELECT [InterfaceDataMappingUid],[Rootid],[Name],[CCDCode],[PRMCode],[CCDPrintName],[IsDefault],[Inactive],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[NCQMeasure],[TopicIndicator],[NQFNumber],[DataElementName],[Modifier],[EndDate],[DisplayOrder],[QRDASection]
FROM [MU2_InterfaceDataMapping]

DROP TABLE [MU2_InterfaceDataMapping]

exec  sp_rename 'migtemp_MU2_InterfaceDataMapping', 'MU2_InterfaceDataMapping'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ObservationOrder]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ObservationOrder](
	[ObservationOrderUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ObservationUid] [uniqueidentifier] NULL,
	[OrderProviderUid] [uniqueidentifier] NULL,
	[PerformProviderUid] [uniqueidentifier] NULL,
	[LaboratoryUid] [uniqueidentifier] NULL,
	[LabSourceUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[ApproveProviderUid] [uniqueidentifier] NULL,
	[TrackingNum] [varchar](24) NULL,
	[OrderDate] [date] NULL,
	[OrderDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[PerformDate] [date] NULL,
	[PerformDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[ReceiveDate] [date] NULL,
	[ReceiveDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[ResultDate] [date] NULL,
	[ResultDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[ExtractDate] [date] NULL,
	[ExtractDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[CollectionDate] [date] NULL,
	[CollectionDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[ResultStatusID] [smallint] NULL,
	[ResultStatusCode] [char](2) NULL,
	[AbnormalFlagCode] [char](2) NULL,
	[ApproveDate] [date] NULL,
	[DueDate] [date] NULL,
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[CaseTypePhaseUid] [uniqueidentifier] NULL,
	[ElectronicResult] [bit] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[ImedicaAccessionNumber] [varchar](25) NULL,
	[LabAccessionNumber] [varchar](25) NULL,
	[Technician] [varchar](100) NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[BillTypeUid] [uniqueidentifier] NULL,
	[Fasting] [bit] NULL,
	[PSC] [bit] NULL,
	[LaboratoryOrderUid] [uniqueidentifier] NULL,
	[GenerateLabOrder] [bit] NOT NULL,
	[ParentObservationOrderUid] [uniqueidentifier] NULL,
	[ResultingUserDefinedTemplateUid] [uniqueidentifier] NULL,
	[ResultingUserDefinedProcedureNoteText] [varchar](max) NULL,
	[ResultingUserDefinedProcedureNoteXml] [varchar](max) NULL,
	[ResultingDpnGroupUid] [uniqueidentifier] NULL,
	[ResultingDpnXml] [xml] NULL,
	[ResultingVisitUid] [uniqueidentifier] NULL,
	[ObservationOrderResultStatusUid] [uniqueidentifier] NULL,
	[MessageUrgencyUid] [uniqueidentifier] NULL,
	[SpecimenTypeXML] [varchar](max) NULL,
	[SpecimenRejectReasonXML] [varchar](max) NULL,
	[SpecimenConditionXML] [varchar](max) NULL,
	[TimeQuantityStart] [datetime] NULL,
	[TimeQuantityEnd] [datetime] NULL,
	[RelevantClinicalXML] [varchar](max) NULL,
	[SpecimenActionUid] [uniqueidentifier] NULL,
	[PlacerGroupNumber] [varchar](100) NULL,
	[Cancel] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[CreatedBy] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NULL,
	[PatientMessageDate] [date] NULL,
	[UserMessageDate] [date] NULL,
	[OverdueMessageDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[FirstReadDate] [datetime] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'PatientUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'order doctor id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'OrderProviderUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'perform doctor id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'PerformProviderUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Laboratory id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'source for DCH only, entered at the time ordering the lab' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'LabSourceUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'approve provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveProviderUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'tracking number (machine id + yymmddhhmmssmm)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'TrackingNum'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Lab Ordered Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'OrderDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Lab Test Performed date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'PerformDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'result received date (after lab test done)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ReceiveDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Actual resulted date after the test finished' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of test sample extracted from patient ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ExtractDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 = Ordered; 2 = Pending; 3 = Pending\Collected; 4= Pending\Received; 5 = Pending\Performed; 6 = Pending\Resulted; 7 = Resulted; 8 = Resulted\Reviewed; 9 = Resulted\Approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetColumnReference', @value=N'<reference foreignTable="ListMisc" searchColumn="ListType" searchValue="ResultStatusID" valueColumn="Val" sortColumn="DisplayOrder" sortBy="ASC" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetOverrideValue', @value=N'<OverrideValues><OverrideValue oldValue="9" newValue="7" /></OverrideValues>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'"F": final' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusCode'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'"A": abnormal; "L": low abnormal; "H": high abnormal; blank: normal' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'AbnormalFlagCode'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'approve date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveDate'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'due date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'DueDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 = false; 1 = true (when true, this result came in from Interface and cannot be modified by user)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ElectronicResult'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Results In Visit Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultingVisitUid'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'CreatedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Observation orders' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_ObservationOrder_Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder'
EXEC sys.sp_addextendedproperty @name=N'Replication.ProcessorAQN', @value=N'iMedica.Prm.BusinessObject.ObservationOrderProcessor, iMedica.Prm.BusinessObject' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ObservationOrder'

ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_ObservationOrderUid]  DEFAULT (newid()) FOR [ObservationOrderUid]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_ElectronicResult]  DEFAULT ((0)) FOR [ElectronicResult]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_Fasting_1]  DEFAULT ((0)) FOR [Fasting]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_DrawnInHouse_1]  DEFAULT ((0)) FOR [PSC]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_GenerateLabOrder]  DEFAULT ((0)) FOR [GenerateLabOrder]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_ListObservationOrderResultStatusUid]  DEFAULT ('4AE36BB9-8A98-4EA6-AB4A-85BE6D95BDD4') FOR [ObservationOrderResultStatusUid]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_MessageUrgencyUid]  DEFAULT ('C2A64D38-3BE1-4F8A-8947-EF9E9AD861A4') FOR [MessageUrgencyUid]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_Cancel]  DEFAULT ((0)) FOR [Cancel]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_CreatedDate]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [migtemp_ObservationOrder] ADD  CONSTRAINT [DF_ObservationOrder_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ObservationOrder
INSERT [migtemp_ObservationOrder]([ObservationOrderUid],[PatientUid],[ObservationUid],[OrderProviderUid],[PerformProviderUid],[LaboratoryUid],[LabSourceUid],[VisitUid],[VisitProcedureUid],[ApproveProviderUid],[TrackingNum],[OrderDate],[OrderDateTime],[PerformDate],[PerformDateTime],[ReceiveDate],[ReceiveDateTime],[ResultDate],[ResultDateTime],[ExtractDate],[ExtractDateTime],[CollectionDate],[CollectionDateTime],[ResultStatusID],[ResultStatusCode],[AbnormalFlagCode],[ApproveDate],[DueDate],[Notes],[AddendumNotes],[AttachmentTypeUid],[CaseTypePhaseUid],[ElectronicResult],[IsDelete],[IsAddendum],[ImedicaAccessionNumber],[LabAccessionNumber],[Technician],[PatientCaseUid],[BillTypeUid],[Fasting],[PSC],[LaboratoryOrderUid],[GenerateLabOrder],[ParentObservationOrderUid],[ResultingUserDefinedTemplateUid],[ResultingUserDefinedProcedureNoteText],[ResultingUserDefinedProcedureNoteXml],[ResultingDpnGroupUid],[ResultingDpnXml],[ResultingVisitUid],[ObservationOrderResultStatusUid],[MessageUrgencyUid],[SpecimenTypeXML],[SpecimenRejectReasonXML],[SpecimenConditionXML],[TimeQuantityStart],[TimeQuantityEnd],[RelevantClinicalXML],[SpecimenActionUid],[PlacerGroupNumber],[Cancel],[Inactive],[CreatedBy],[CreatedDateTime],[PatientMessageDate],[UserMessageDate],[OverdueMessageDate],[LastModifiedByUid],[LastModifiedDate])
SELECT [ObservationOrderUid],[PatientUid],[ObservationUid],[OrderProviderUid],[PerformProviderUid],[LaboratoryUid],[LabSourceUid],[VisitUid],[VisitProcedureUid],[ApproveProviderUid],[TrackingNum],[OrderDate],[OrderDateTime],[PerformDate],[PerformDateTime],[ReceiveDate],[ReceiveDateTime],[ResultDate],[ResultDateTime],[ExtractDate],[ExtractDateTime],[CollectionDate],[CollectionDateTime],[ResultStatusID],[ResultStatusCode],[AbnormalFlagCode],[ApproveDate],[DueDate],[Notes],[AddendumNotes],[AttachmentTypeUid],[CaseTypePhaseUid],[ElectronicResult],[IsDelete],[IsAddendum],[ImedicaAccessionNumber],[LabAccessionNumber],[Technician],[PatientCaseUid],[BillTypeUid],[Fasting],[PSC],[LaboratoryOrderUid],[GenerateLabOrder],[ParentObservationOrderUid],[ResultingUserDefinedTemplateUid],[ResultingUserDefinedProcedureNoteText],[ResultingUserDefinedProcedureNoteXml],[ResultingDpnGroupUid],CONVERT(nvarchar(max), [ResultingDpnXml]),[ResultingVisitUid],[ObservationOrderResultStatusUid],[MessageUrgencyUid],[SpecimenTypeXML],[SpecimenRejectReasonXML],[SpecimenConditionXML],[TimeQuantityStart],[TimeQuantityEnd],[RelevantClinicalXML],[SpecimenActionUid],[PlacerGroupNumber],[Cancel],[Inactive],[CreatedBy],[CreatedDateTime],[PatientMessageDate],[UserMessageDate],[OverdueMessageDate],[LastModifiedByUid],[LastModifiedDate]
FROM [ObservationOrder]

DROP TABLE [ObservationOrder]

exec  sp_rename 'migtemp_ObservationOrder', 'ObservationOrder'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OptOut]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[OptOut](
	[OptOutUid] [uniqueidentifier] NOT NULL,
	[EmailAddress] [varchar](255) NOT NULL,
	[AccessCode] [varchar](25) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [OptOut] ADD  CONSTRAINT [DF_OptOut_OptOutUid]  DEFAULT (newid()) FOR [OptOutUid]
ALTER TABLE [OptOut] ADD  CONSTRAINT [DF_OptOut_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Patient]') AND name = 'PatientConditionUid')
ALTER TABLE [Patient] DROP COLUMN [PatientConditionUid] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientCareManagement]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientCareManagement](
	[PatientCareManagementUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Location] [varchar](500) NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[RequestDate] [date] NULL,
	[StatusUid] [uniqueidentifier] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[CareTypeUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ForCertification] [bit] NOT NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_PatientCareManagement] ADD  CONSTRAINT [DF_PatientCareManagement_PatientCareManagementUid]  DEFAULT (newid()) FOR [PatientCareManagementUid]
ALTER TABLE [migtemp_PatientCareManagement] ADD  CONSTRAINT [DF_PatientCareManagement_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_PatientCareManagement] ADD  CONSTRAINT [DF_PatientCareManagement_ForCertification]  DEFAULT ((0)) FOR [ForCertification]

END
Truncate Table migtemp_PatientCareManagement
INSERT [migtemp_PatientCareManagement]([PatientCareManagementUid],[PatientUid],[Location],[EffectiveDate],[ExpirationDate],[RequestDate],[StatusUid],[MedicalServicesProviderUid],[ProviderUid],[CareTypeUid],[Notes],[LastModifiedDate],[LastModifiedByUid],[ForCertification])
SELECT [PatientCareManagementUid],[PatientUid],[Location],[EffectiveDate],[ExpirationDate],[RequestDate],[StatusUid],[MedicalServicesProviderUid],[ProviderUid],[CareTypeUid],[Notes],[LastModifiedDate],[LastModifiedByUid],[ForCertification]
FROM [PatientCareManagement]

DROP TABLE [PatientCareManagement]

exec  sp_rename 'migtemp_PatientCareManagement', 'PatientCareManagement'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientCareManagementLog]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientCareManagementLog](
	[PatientCareManagementLogUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[LogDate] [date] NOT NULL,
	[LogMinutes] [int] NULL,
	[LoggedFromMessageUid] [uniqueidentifier] NULL,
	[LoggedFromVisitUid] [uniqueidentifier] NULL,
	[IsApproved] [bit] NULL,
	[IsCPO] [bit] NOT NULL,
	[IsCCM] [bit] NOT NULL,
	[Sent] [bit] NOT NULL,
	[Received] [bit] NOT NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MedicalDecisionComplexityHighOrMedium] [bit] NOT NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_LogDate]  DEFAULT (getutcdate()) FOR [LogDate]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_IsCPO]  DEFAULT ((0)) FOR [IsCPO]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_IsCCM]  DEFAULT ((0)) FOR [IsCCM]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_Sent]  DEFAULT ((0)) FOR [Sent]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_Received]  DEFAULT ((0)) FOR [Received]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_PatientCareManagementLog] ADD  CONSTRAINT [DF_PatientCareManagementLog_MedicalDecisionComplexityHighOrMedium]  DEFAULT ((0)) FOR [MedicalDecisionComplexityHighOrMedium]

END
Truncate Table migtemp_PatientCareManagementLog
INSERT [migtemp_PatientCareManagementLog]([PatientCareManagementLogUid],[PatientUid],[ProviderUid],[LogDate],[LogMinutes],[LoggedFromMessageUid],[LoggedFromVisitUid],[IsApproved],[IsCPO],[IsCCM],[LastModifiedDate],[LastModifiedByUid])
SELECT [PatientCareManagementLogUid],[PatientUid],[ProviderUid],[LogDate],[LogMinutes],[LoggedFromMessageUid],[LoggedFromVisitUid],[IsApproved],[IsCPO],[IsCCM],[LastModifiedDate],[LastModifiedByUid]
FROM [PatientCareManagementLog]

DROP TABLE [PatientCareManagementLog]

exec  sp_rename 'migtemp_PatientCareManagementLog', 'PatientCareManagementLog'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PatientDXHistory]') AND name = 'DiagnosisUid')
ALTER TABLE [PatientDXHistory] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientFamilyHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientFamilyHistory](
	[PatientFamilyHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[HxRelationshipUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[Name] [varchar](255) NULL,
	[BirthTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[BirthDate] [date] NULL,
	[DeathTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[DeathDate] [date] NULL,
	[IsMaternal] [bit] NOT NULL,
	[IsPaternal] [bit] NOT NULL,
	[NoKnownDisease] [bit] NOT NULL,
	[Unknown] [bit] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[RecordDateTime] [datetime] NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[IsPatientInput] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RecordDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientFamilyHistory', @level2type=N'COLUMN',@level2name=N'RecordDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ActiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientFamilyHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'InactiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientFamilyHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'

ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_PatientFamilyHistoryUid]  DEFAULT (newid()) FOR [PatientFamilyHistoryUid]
ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_IsMaternal]  DEFAULT ((0)) FOR [IsMaternal]
ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_IsPaternal]  DEFAULT ((0)) FOR [IsPaternal]
ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_NoKnownDisease]  DEFAULT ((0)) FOR [NoKnownDisease]
ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_Unknown]  DEFAULT ((0)) FOR [Unknown]
ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_RecordDate]  DEFAULT (getutcdate()) FOR [RecordDateTime]
ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_IsPatientInput]  DEFAULT ((0)) FOR [IsPatientInput]
ALTER TABLE [migtemp_PatientFamilyHistory] ADD  CONSTRAINT [DF_PatientFamilyHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PatientFamilyHistory
INSERT [migtemp_PatientFamilyHistory]([PatientFamilyHistoryUid],[HxRelationshipUid],[PatientUid],[VisitUid],[ProviderUid],[Name],[BirthTimeFrame],[DeathTimeFrame],[IsMaternal],[IsPaternal],[NoKnownDisease],[Unknown],[IsDelete],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientFamilyHistoryUid],[HxRelationshipUid],[PatientUid],[VisitUid],[ProviderUid],[Name],CONVERT(nvarchar(max), [BirthTimeFrame]),CONVERT(nvarchar(max), [DeathTimeFrame]),[IsMaternal],[IsPaternal],[NoKnownDisease],[Unknown],[IsDelete],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientFamilyHistory]

DROP TABLE [PatientFamilyHistory]

exec  sp_rename 'migtemp_PatientFamilyHistory', 'PatientFamilyHistory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientFamilyHistoryDisease]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientFamilyHistoryDisease](
	[PatientFamilyHistoryDiseaseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientFamilyHistoryUid] [uniqueidentifier] NOT NULL,
	[DiseaseUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](255) NULL,
	[AgeAtOnsetTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[AgeAtOnsetDate] [date] NULL,
	[IsDelete] [bit] NOT NULL,
	[IsCauseOfDeath] [bit] NOT NULL,
	[Denies] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[RecordDateTime] [datetime] NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[IsPatientInput] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RecordDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientFamilyHistoryDisease', @level2type=N'COLUMN',@level2name=N'RecordDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ActiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientFamilyHistoryDisease', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'InactiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientFamilyHistoryDisease', @level2type=N'COLUMN',@level2name=N'InactiveDate'

ALTER TABLE [migtemp_PatientFamilyHistoryDisease] ADD  CONSTRAINT [DF_PatientFamilyHistoryDisease_PatientFamilyHistoryDiseaseUid]  DEFAULT (newid()) FOR [PatientFamilyHistoryDiseaseUid]
ALTER TABLE [migtemp_PatientFamilyHistoryDisease] ADD  CONSTRAINT [DF_PatientFamilyHistoryDisease_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_PatientFamilyHistoryDisease] ADD  CONSTRAINT [DF_PatientFamilyHistoryDisease_IsCauseOfDeath]  DEFAULT ((0)) FOR [IsCauseOfDeath]
ALTER TABLE [migtemp_PatientFamilyHistoryDisease] ADD  CONSTRAINT [DF_PatientFamilyHistoryDisease_Denies]  DEFAULT ((0)) FOR [Denies]
ALTER TABLE [migtemp_PatientFamilyHistoryDisease] ADD  CONSTRAINT [DF_PatientFamilyHistoryDisease_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_PatientFamilyHistoryDisease] ADD  CONSTRAINT [DF_PatientFamilyHistoryDisease_RecordDate]  DEFAULT (getutcdate()) FOR [RecordDateTime]
ALTER TABLE [migtemp_PatientFamilyHistoryDisease] ADD  CONSTRAINT [DF_PatientFamilyHistoryDisease_IsPatientInput]  DEFAULT ((0)) FOR [IsPatientInput]
ALTER TABLE [migtemp_PatientFamilyHistoryDisease] ADD  CONSTRAINT [DF_PatientFamilyHistoryDisease_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PatientFamilyHistoryDisease
INSERT [migtemp_PatientFamilyHistoryDisease]([PatientFamilyHistoryDiseaseUid],[PatientFamilyHistoryUid],[DiseaseUid],[Name],[AgeAtOnsetTimeFrame],[IsDelete],[IsCauseOfDeath],[Denies],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientFamilyHistoryDiseaseUid],[PatientFamilyHistoryUid],[DiseaseUid],[Name],CONVERT(nvarchar(max), [AgeAtOnsetTimeFrame]),[IsDelete],[IsCauseOfDeath],[Denies],[Notes],[DisplayOrder],[RecordDateTime],[ActiveDate],[InactiveDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientFamilyHistoryDisease]

DROP TABLE [PatientFamilyHistoryDisease]

exec  sp_rename 'migtemp_PatientFamilyHistoryDisease', 'PatientFamilyHistoryDisease'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientHistoryDetail]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientHistoryDetail](
	[PatientHistoryDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientHistoryUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[QuestionName] [varchar](255) NULL,
	[AnswerName] [varchar](255) NULL,
	[AnswerTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[AnswerDate] [date] NULL,
	[QuestionDisplayOrder] [int] NULL,
	[RecordDateTime] [datetime] NULL,
	[Denies] [bit] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'points to PatientHistory table' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail', @level2type=N'COLUMN',@level2name=N'PatientHistoryUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'question id (can point to ListQuestion or ListDisease)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail', @level2type=N'COLUMN',@level2name=N'QuestionUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'answer id (can point to ListAnswer or ListDisease)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail', @level2type=N'COLUMN',@level2name=N'AnswerUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'question' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail', @level2type=N'COLUMN',@level2name=N'QuestionName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'answer' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail', @level2type=N'COLUMN',@level2name=N'AnswerName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'record date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail', @level2type=N'COLUMN',@level2name=N'RecordDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RecordDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail', @level2type=N'COLUMN',@level2name=N'RecordDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'patient history detail information' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_PatientHistoryDetail_PatientHistory' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientHistoryDetail'

ALTER TABLE [migtemp_PatientHistoryDetail] ADD  CONSTRAINT [DF_PatientHistoryDetail_PatientHistoryDetailUid]  DEFAULT (newid()) FOR [PatientHistoryDetailUid]
ALTER TABLE [migtemp_PatientHistoryDetail] ADD  CONSTRAINT [DF_PatientHistoryDetail_Denies]  DEFAULT ((0)) FOR [Denies]
ALTER TABLE [migtemp_PatientHistoryDetail] ADD  CONSTRAINT [DF_PatientHistoryDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PatientHistoryDetail
INSERT [migtemp_PatientHistoryDetail]([PatientHistoryDetailUid],[PatientHistoryUid],[QuestionUid],[AnswerUid],[QuestionName],[AnswerName],[AnswerTimeFrame],[QuestionDisplayOrder],[RecordDateTime],[Denies],[ProcedureUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientHistoryDetailUid],[PatientHistoryUid],[QuestionUid],[AnswerUid],[QuestionName],[AnswerName],CONVERT(nvarchar(max), [AnswerTimeFrame]),[QuestionDisplayOrder],[RecordDateTime],[Denies],[ProcedureUid],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientHistoryDetail]

DROP TABLE [PatientHistoryDetail]

exec  sp_rename 'migtemp_PatientHistoryDetail', 'PatientHistoryDetail'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientProblemDiagnosis](
	[PatientProblemDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[ProblemStatusUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientProblemUid] [uniqueidentifier] NULL,
	[OnsetTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[OnsetDate] [date] NULL,
	[ResolvedTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResolvedDate] [date] NULL,
	[IsDelete] [bit] NOT NULL,
	[IsPatientProblem] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[AddendumNotes] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[RecordDateTime] [datetime] NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[SortDate] [datetime] NULL,
	[LastDiagnosisDate] [date] NULL,
	[DSMAxis] [varchar](250) NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[IsPatientInput] [bit] NOT NULL,
	[LifeLong] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL
) ON [PRIMARY]


ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_PatientProblemDiagnosisUid]  DEFAULT (newid()) FOR [PatientProblemDiagnosisUid]
ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_IsPatientProblem]  DEFAULT ((0)) FOR [IsPatientProblem]
ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_RecordDate]  DEFAULT (getutcdate()) FOR [RecordDateTime]
ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_SortDate]  DEFAULT (getutcdate()) FOR [SortDate]
ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_IsPatientInput]  DEFAULT ((0)) FOR [IsPatientInput]
ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_LifeLong]  DEFAULT ((0)) FOR [LifeLong]
ALTER TABLE [PatientProblemDiagnosis] ADD  CONSTRAINT [DF_PatientProblemDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientProblemDiagnosisHistory](
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientProblemDiagnosisUid] [uniqueidentifier] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[ProblemStatusUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientProblemUid] [uniqueidentifier] NULL,
	[OnsetTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[OnsetDate] [date] NULL,
	[ResolvedTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResolvedDate] [date] NULL,
	[IsDelete] [bit] NOT NULL,
	[IsPatientProblem] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[AddendumNotes] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[RecordDateTime] [datetime] NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[SortDate] [datetime] NULL,
	[LastDiagnosisDate] [date] NULL,
	[DSMAxis] [varchar](250) NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[IsPatientInput] [bit] NOT NULL,
	[LifeLong] [bit] NOT NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_PatientProblemDiagnosisHistoryUid]  DEFAULT (newid()) FOR [PatientProblemDiagnosisHistoryUid]
ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsPatientProblem]  DEFAULT ((0)) FOR [IsPatientProblem]
ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_RecordDate]  DEFAULT (getutcdate()) FOR [RecordDateTime]
ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_SortDate]  DEFAULT (getutcdate()) FOR [SortDate]
ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsPatientInput]  DEFAULT ((0)) FOR [IsPatientInput]
ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_LifeLong]  DEFAULT ((0)) FOR [LifeLong]
ALTER TABLE [PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientProcedure](
	[PatientProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[Code] [varchar](30) NULL,
	[TermName] [varchar](255) NULL,
	[ShortDescription] [varchar](75) NULL,
	[ProcedureHistoryTermUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[PerformVisitProcedureUid] [uniqueidentifier] NULL,
	[OrderedVisitProcedureUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[ProcedureHistoryStatusUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[PerformTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[PerformDate] [date] NULL,
	[ResultTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResultDate] [date] NULL,
	[OrderDate] [date] NULL,
	[IsDelete] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[RecordDateTime] [datetime] NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[SortDate] [datetime] NULL,
	[IsPatientInput] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RecordDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientProcedure', @level2type=N'COLUMN',@level2name=N'RecordDateTime'

ALTER TABLE [PatientProcedure] ADD  CONSTRAINT [DF_PatientProcedure_PatientProcedureUid]  DEFAULT (newid()) FOR [PatientProcedureUid]
ALTER TABLE [PatientProcedure] ADD  CONSTRAINT [DF_PatientProcedure_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientProcedure] ADD  CONSTRAINT [DF_PatientProcedure_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [PatientProcedure] ADD  CONSTRAINT [DF_PatientProcedure_RecordDate]  DEFAULT (getutcdate()) FOR [RecordDateTime]
ALTER TABLE [PatientProcedure] ADD  CONSTRAINT [DF_PatientProcedure_SortDate]  DEFAULT (getutcdate()) FOR [SortDate]
ALTER TABLE [PatientProcedure] ADD  CONSTRAINT [DF_PatientProcedure_IsPatientInput]  DEFAULT ((0)) FOR [IsPatientInput]
ALTER TABLE [PatientProcedure] ADD  CONSTRAINT [DF_PatientProcedure_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientProcedureHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientProcedureHistory](
	[PatientProcedureHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientProcedureUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[Code] [varchar](30) NULL,
	[TermName] [varchar](255) NULL,
	[ShortDescription] [varchar](75) NULL,
	[ProcedureHistoryTermUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[PerformVisitProcedureUid] [uniqueidentifier] NULL,
	[OrderedVisitProcedureUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[ProcedureHistoryStatusUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[PerformTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[PerformDate] [date] NULL,
	[ResultTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResultDate] [date] NULL,
	[OrderDate] [date] NULL,
	[IsDelete] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[RecordDateTime] [datetime] NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[SortDate] [datetime] NULL,
	[IsPatientInput] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'RecordDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientProcedureHistory', @level2type=N'COLUMN',@level2name=N'RecordDateTime'

ALTER TABLE [PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_PatientProcedureHistoryUid]  DEFAULT (newid()) FOR [PatientProcedureHistoryUid]
ALTER TABLE [PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_RecordDate]  DEFAULT (getutcdate()) FOR [RecordDateTime]
ALTER TABLE [PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_SortDate]  DEFAULT (getutcdate()) FOR [SortDate]
ALTER TABLE [PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_IsPatientInput]  DEFAULT ((0)) FOR [IsPatientInput]
ALTER TABLE [PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Person]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Person](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Person_PersonUid]  DEFAULT (newid()),
	[PatientCenterUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Person_Inactive]  DEFAULT ((0)),
	[Prefix] [varchar](25) NULL,
	[FirstName] [varchar](50) NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NOT NULL,
	[Suffix] [varchar](50) NULL,
	[Address1] [xml](CONTENT [dbo].[Address]) NULL,
	[BadAddress1] [bit] NULL CONSTRAINT [DF_Person_BadAddress1]  DEFAULT ((0)),
	[Address2] [xml](CONTENT [dbo].[Address]) NULL,
	[Phone1] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone2] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone3] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone4] [xml](CONTENT [dbo].[Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[LanguageUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[RaceUid] [uniqueidentifier] NULL,
	[EthnicityUid] [uniqueidentifier] NULL,
	[Hispanic] [bit] NOT NULL CONSTRAINT [DF_Person_Hispanic]  DEFAULT ((0)),
	[Birthdate] [date] NULL,
	[BirthTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[Deathdate] [date] NULL,
	[AkaFirstName] [varchar](50) NULL,
	[AkaLastName] [varchar](50) NULL,
	[SocialSecurityNumber] [varchar](11) NULL,
	[DriverLicenseNumber] [varchar](25) NULL,
	[DriverLicenseState] [varchar](3) NULL,
	[DriverLicenseAttachmentUid] [uniqueidentifier] NULL,
	[PhotoAttachmentUid] [uniqueidentifier] NULL,
	[LivesWithPersonUid] [uniqueidentifier] NULL,
	[MaritalStatusUid] [uniqueidentifier] NULL,
	[DominantHandUid] [uniqueidentifier] NULL,
	[PreferredContactMethod] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Person_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Person_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MaidenName] [varchar](50) NULL,
	[NotificationMethodUid] [uniqueidentifier] NULL,
	[EmailDirect] [varchar](200) NULL,
	[BirthPlace] [xml](CONTENT [dbo].[Address]) NULL,
	[Computed_Address1_Address1] [varchar](100) NULL,
	[Computed_Address1_Address2] [varchar](100) NULL,
	[Computed_Address1_City] [varchar](35) NULL,
	[Computed_Address1_State] [varchar](3) NULL,
	[Computed_Address1_Zip] [varchar](10) NULL,
	[Computed_Phone1_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone1_PhoneType] [varchar](50) NULL,
	[Computed_Phone2_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone2_PhoneType] [varchar](50) NULL,
	[Computed_Phone3_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone3_PhoneType] [varchar](50) NULL,
	[Computed_Phone4_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone4_PhoneType] [varchar](50) NULL,
	[MotherMaidenName] [varchar](50) NULL,
	[MotherMaidenFirstName] [varchar](50) NULL,
	[IdentityVerification] [xml] NULL,
	[LastIdentityVerificationTransaction] [varchar](max) NULL,
	[TranslatorRequired] [bit] NULL CONSTRAINT [DF_Person_TranslatorRequired]  DEFAULT ((0)),
	[SexualOrientationUid] [uniqueidentifier] NULL,
	[GenderIdentityUid] [uniqueidentifier] NULL,
	[SendSms] [bit] NOT NULL CONSTRAINT [DF__Person_Sms]  DEFAULT ((0)),
	[SendEmail] [bit] NOT NULL CONSTRAINT [DF__Person_Email]  DEFAULT ((0)),
	[NoEmailAddressProvided] [bit] NOT NULL CONSTRAINT [DF_Person_NoEmailAddressProvided]  DEFAULT ((0)),
	[Phone1AllowsMessages] [bit] NOT NULL CONSTRAINT [DF_Person_Phone1_AM]  DEFAULT ((0)),
	[Phone2AllowsMessages] [bit] NOT NULL CONSTRAINT [DF_Person_Phone2_AM]  DEFAULT ((0)),
	[Phone3AllowsMessages] [bit] NOT NULL CONSTRAINT [DF_Person_Phone3_AM]  DEFAULT ((0)),
	[Phone4AllowsMessages] [bit] NOT NULL CONSTRAINT [DF_Person_Phone4_AM]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Email address used to transmit data (CCDs, CCDAs, etc) using the Direct Method' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'EmailDirect'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Address1'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Address2'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_City'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_State'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Zip'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Replication.ObjectCache', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{FK_Patient_Person,!FK_PersonRawUnencrypted_Photo}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'


END
Truncate Table migtemp_Person
INSERT [migtemp_Person]([PersonUid],[PatientCenterUid],[Inactive],[Prefix],[FirstName],[MiddleName],[LastName],[Suffix],[Address1],[Address2],[Phone1],[Phone2],[Phone3],[Phone4],[Email1],[Email2],[Notes],[LanguageUid],[GenderUid],[RaceUid],[EthnicityUid],[Hispanic],[Birthdate],[BirthTime],[Deathdate],[AkaFirstName],[AkaLastName],[SocialSecurityNumber],[DriverLicenseNumber],[DriverLicenseState],[DriverLicenseAttachmentUid],[PhotoAttachmentUid],[LivesWithPersonUid],[MaritalStatusUid],[DominantHandUid],[PreferredContactMethod],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MaidenName],[NotificationMethodUid],[EmailDirect],[BirthPlace],[Computed_Address1_Address1],[Computed_Address1_Address2],[Computed_Address1_City],[Computed_Address1_State],[Computed_Address1_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType],[MotherMaidenName],[IdentityVerification],[LastIdentityVerificationTransaction])
SELECT [PersonUid],[PatientCenterUid],[Inactive],[Prefix],[FirstName],[MiddleName],[LastName],[Suffix],CONVERT(nvarchar(max), [Address1]),CONVERT(nvarchar(max), [Address2]),CONVERT(nvarchar(max), [Phone1]),CONVERT(nvarchar(max), [Phone2]),CONVERT(nvarchar(max), [Phone3]),CONVERT(nvarchar(max), [Phone4]),[Email1],[Email2],[Notes],[LanguageUid],[GenderUid],[RaceUid],[EthnicityUid],[Hispanic],[Birthdate],[BirthTime],[Deathdate],[AkaFirstName],[AkaLastName],[SocialSecurityNumber],[DriverLicenseNumber],[DriverLicenseState],[DriverLicenseAttachmentUid],[PhotoAttachmentUid],[LivesWithPersonUid],[MaritalStatusUid],[DominantHandUid],[PreferredContactMethod],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MaidenName],[NotificationMethodUid],[EmailDirect],CONVERT(nvarchar(max), [BirthPlace]),[Computed_Address1_Address1],[Computed_Address1_Address2],[Computed_Address1_City],[Computed_Address1_State],[Computed_Address1_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType],[MotherMaidenName],CONVERT(nvarchar(max), [IdentityVerification]),[LastIdentityVerificationTransaction]
FROM [Person]

DROP TABLE [Person]

exec  sp_rename 'migtemp_Person', 'Person'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PersonContact]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PersonContact](
	[PersonContactUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[ContactPersonUid] [uniqueidentifier] NOT NULL,
	[ContactRelationshipUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[EmergencyContact] [bit] NOT NULL,
	[AuthorizedToMakeMedicalDecisions] [bit] NOT NULL,
	[AllowHIPAARelease] [smallint] NOT NULL,
	[HIPAARelease] [xml] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Main person with contact.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contact.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'ContactPersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Relationship of contact to main person.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'ContactRelationshipUid'
EXEC sys.sp_addextendedproperty @name=N'AllowHIPAARelease', @value=N'<NA value="0" /><All value="1" /><Only value="2" /><Except value="3" /><None value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contacts for a person. (Single directional.)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_PersonContact_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'

ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_PersonContactUid]  DEFAULT (newid()) FOR [PersonContactUid]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_EmergencyContact]  DEFAULT ((0)) FOR [EmergencyContact]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_AuthorizedToMakeMedicalDecisions]  DEFAULT ((0)) FOR [AuthorizedToMakeMedicalDecisions]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_AllowHIPAARelease]  DEFAULT ((0)) FOR [AllowHIPAARelease]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PersonContact
INSERT [migtemp_PersonContact]([PersonContactUid],[PersonUid],[ContactPersonUid],[ContactRelationshipUid],[DisplayOrder],[EmergencyContact],[AuthorizedToMakeMedicalDecisions],[Notes],[LastModifiedDate],[LastModifiedByUid])
SELECT [PersonContactUid],[PersonUid],[ContactPersonUid],[ContactRelationshipUid],[DisplayOrder],[EmergencyContact],[AuthorizedToMakeMedicalDecisions],[Notes],[LastModifiedDate],[LastModifiedByUid]
FROM [PersonContact]

DROP TABLE [PersonContact]

exec  sp_rename 'migtemp_PersonContact', 'PersonContact'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PersonEmployer]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PersonEmployer](
	[PersonEmployerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[EmployerUid] [uniqueidentifier] NULL,
	[EmploymentStatusUid] [uniqueidentifier] NULL,
	[IndustryUid] [uniqueidentifier] NULL,
	[OccupationUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[StartDate] [date] NULL,
	[StartFuzzyDate] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[EndDate] [date] NULL,
	[EndFuzzyDate] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[Department] [varchar](50) NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Person and employer pairs and period of employment.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonEmployer'

ALTER TABLE [migtemp_PersonEmployer] ADD  CONSTRAINT [DF_PersonEmployer_PersonEmployerUid]  DEFAULT (newid()) FOR [PersonEmployerUid]
ALTER TABLE [migtemp_PersonEmployer] ADD  CONSTRAINT [DF_PersonEmployer_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_PersonEmployer] ADD  CONSTRAINT [DF_PersonEmployer_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PersonEmployer
INSERT [migtemp_PersonEmployer]([PersonEmployerUid],[PersonUid],[EmployerUid],[EmploymentStatusUid],[DisplayOrder],[StartDate],[EndDate],[Department],[Notes],[LastModifiedDate],[LastModifiedByUid])
SELECT [PersonEmployerUid],[PersonUid],[EmployerUid],[EmploymentStatusUid],[DisplayOrder],[StartDate],[EndDate],[Department],[Notes],[LastModifiedDate],[LastModifiedByUid]
FROM [PersonEmployer]

DROP TABLE [PersonEmployer]

exec  sp_rename 'migtemp_PersonEmployer', 'PersonEmployer'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PersonInsurancePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PersonInsurancePlan](
	[PersonInsurancePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[CorporationUid] [uniqueidentifier] NULL,
	[InsurancePlanUid] [uniqueidentifier] NOT NULL,
	[CopayPrimary] [money] NULL,
	[CopaySpecialist] [money] NULL,
	[CopayOther] [money] NULL,
	[AuthorizeAssignment] [bit] NOT NULL,
	[PlanMemberID] [varchar](50) NULL,
	[PlanGroupID] [varchar](50) NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[InsuranceCardAttachmentUid] [uniqueidentifier] NULL,
	[EligibilityStatusUid] [uniqueidentifier] NULL,
	[EligibilityCoverageLevelUid] [uniqueidentifier] NULL,
	[InNetworkCoinsurance] [decimal](18, 0) NULL,
	[InNetworkDeductible] [money] NULL,
	[InNetworkRemaining] [money] NULL,
	[InNetworkMet] [money] NULL,
	[OutNetworkCoinsurance] [decimal](18, 0) NULL,
	[OutNetworkDeductible] [money] NULL,
	[OutNetworkRemaining] [money] NULL,
	[OutNetworkMet] [money] NULL,
	[EligibilityEffectiveDate] [date] NULL,
	[EligibilityExpirationDate] [date] NULL,
	[EligibilityVerificationDateTime] [datetime] NULL,
	[EligibilityNotes] [varchar](8000) NULL,
	[EligibilityResponseXML] [xml] NULL,
	[EligibilityTransmissionInProcess] [bit] NULL,
	[EligibilityTransmissionStatus] [varchar](50) NULL,
	[ElectronicRequest] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[EligibilityResponseHTML] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Insured Person, if set. If not set (null), then CorporationUid must be set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Insured Corporation, if set. If not set (null), then PersonUid must be set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'CorporationUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Insurance plan.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'InsurancePlanUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay amount.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'CopayPrimary'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay to use if provider is acting as a specialist.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'CopaySpecialist'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Copay to use if provider is not acting as primary or specialist.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'CopayOther'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag to authorize assignment of payment directly to physician. (If false, the patient is typically liable for charges immediately.)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'AuthorizeAssignment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Prepended to AccountInsurance.PolicyNumberSuffix to determine a patient''s policy number or memberID.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'PlanMemberID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'GroupID.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'PlanGroupID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Effective date of insured''s coverage, if set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'EffectiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Expiration date of the insured''s coverage, if set.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'ExpirationDate'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'EligibilityVerificationDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan', @level2type=N'COLUMN',@level2name=N'EligibilityVerificationDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An insured Person or Corporation along with their InsurancePlan. Now owned by one AccountInsurance record. (Was once shared among AccountInsurance records for various patients and insurance orders (primary, secondary, and so on.))' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_PersonInsurancePlan_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonInsurancePlan'

ALTER TABLE [migtemp_PersonInsurancePlan] ADD  CONSTRAINT [DF_PersonInsurancePlan_PersonInsurancePlanUid]  DEFAULT (newid()) FOR [PersonInsurancePlanUid]
ALTER TABLE [migtemp_PersonInsurancePlan] ADD  CONSTRAINT [DF_PersonInsurancePlan_AuthorizeAssignment]  DEFAULT ((1)) FOR [AuthorizeAssignment]
ALTER TABLE [migtemp_PersonInsurancePlan] ADD  CONSTRAINT [DF_PersonInsurancePlan_ElectronicRequest]  DEFAULT ((0)) FOR [ElectronicRequest]
ALTER TABLE [migtemp_PersonInsurancePlan] ADD  CONSTRAINT [DF_PersonInsurancePlan_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PersonInsurancePlan
INSERT [migtemp_PersonInsurancePlan]([PersonInsurancePlanUid],[PersonUid],[CorporationUid],[InsurancePlanUid],[CopayPrimary],[CopaySpecialist],[CopayOther],[AuthorizeAssignment],[PlanMemberID],[PlanGroupID],[EffectiveDate],[ExpirationDate],[InsuranceCardAttachmentUid],[EligibilityStatusUid],[EligibilityCoverageLevelUid],[InNetworkCoinsurance],[InNetworkDeductible],[InNetworkRemaining],[InNetworkMet],[OutNetworkCoinsurance],[OutNetworkDeductible],[OutNetworkRemaining],[OutNetworkMet],[EligibilityEffectiveDate],[EligibilityExpirationDate],[EligibilityVerificationDateTime],[EligibilityNotes],[EligibilityResponseXML],[EligibilityTransmissionInProcess],[EligibilityTransmissionStatus],[ElectronicRequest],[LastModifiedDate],[LastModifiedByUid])
SELECT [PersonInsurancePlanUid],[PersonUid],[CorporationUid],[InsurancePlanUid],[CopayPrimary],[CopaySpecialist],[CopayOther],[AuthorizeAssignment],[PlanMemberID],[PlanGroupID],[EffectiveDate],[ExpirationDate],[InsuranceCardAttachmentUid],[EligibilityStatusUid],[EligibilityCoverageLevelUid],[InNetworkCoinsurance],[InNetworkDeductible],[InNetworkRemaining],[InNetworkMet],[OutNetworkCoinsurance],[OutNetworkDeductible],[OutNetworkRemaining],[OutNetworkMet],[EligibilityEffectiveDate],[EligibilityExpirationDate],[EligibilityVerificationDateTime],[EligibilityNotes],CONVERT(nvarchar(max), [EligibilityResponseXML]),[EligibilityTransmissionInProcess],[EligibilityTransmissionStatus],[ElectronicRequest],[LastModifiedDate],[LastModifiedByUid]
FROM [PersonInsurancePlan]

DROP TABLE [PersonInsurancePlan]

exec  sp_rename 'migtemp_PersonInsurancePlan', 'PersonInsurancePlan'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PersonWeb]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PersonWeb](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[UserName] [varchar](50) NULL,
	[Password] [varchar](50) NULL,
	[RequireNew] [bit] NOT NULL,
	[LimitedTimePassword] [bit] NOT NULL,
	[ExpirationDate] [date] NULL,
	[IncorrectLoginDateTime] [datetime] NULL,
	[IncorrectLoginCount] [tinyint] NOT NULL,
	[PatientWebAccess] [bit] NOT NULL,
	[UserPRMWebAccess] [bit] NOT NULL,
	[ProviderWebAccess] [bit] NOT NULL,
	[FacilityPortalWebAccess] [bit] NOT NULL,
	[ProductConsentVersion] [int] NULL,
	[PracticeConsentVersion] [int] NULL,
	[ChartConsentVersion] [int] NULL,
	[PatientSecurityAnswerList] [xml](CONTENT [dbo].[PatientPortalSecurityAnswers]) NULL,
	[IncorrectPasswordResetDateTime] [datetime] NULL,
	[IncorrectPasswordResetCount] [tinyint] NOT NULL,
	[CreatedDateTime] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastLoginDate] [datetime] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'IncorrectLoginDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonWeb', @level2type=N'COLUMN',@level2name=N'IncorrectLoginDateTime'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonWeb'

ALTER TABLE [migtemp_PersonWeb] ADD  CONSTRAINT [DF__PersonWeb__Requi__4327266E]  DEFAULT ((0)) FOR [RequireNew]
ALTER TABLE [migtemp_PersonWeb] ADD  CONSTRAINT [DF_PersonWeb_LimitedTimePassword]  DEFAULT ((0)) FOR [LimitedTimePassword]
ALTER TABLE [migtemp_PersonWeb] ADD  CONSTRAINT [DF__PersonWeb__Incor__441B4AA7]  DEFAULT ((0)) FOR [IncorrectLoginCount]
ALTER TABLE [migtemp_PersonWeb] ADD  CONSTRAINT [DF__PersonWeb__Patie__450F6EE0]  DEFAULT ((0)) FOR [PatientWebAccess]
ALTER TABLE [migtemp_PersonWeb] ADD  CONSTRAINT [DF__PersonWeb__UserP__46039319]  DEFAULT ((0)) FOR [UserPRMWebAccess]
ALTER TABLE [migtemp_PersonWeb] ADD  CONSTRAINT [DF__PersonWeb__Provi__46F7B752]  DEFAULT ((0)) FOR [ProviderWebAccess]
ALTER TABLE [migtemp_PersonWeb] ADD  CONSTRAINT [DF_PersonWeb_FacilityPortalWebAccess]  DEFAULT ((0)) FOR [FacilityPortalWebAccess]
ALTER TABLE [migtemp_PersonWeb] ADD  CONSTRAINT [DF_PersonWeb_IncorrectPasswordReset]  DEFAULT ((0)) FOR [IncorrectPasswordResetCount]
ALTER TABLE [migtemp_PersonWeb] ADD  CONSTRAINT [DF__PersonWeb__LastM__47EBDB8B]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PersonWeb
INSERT [migtemp_PersonWeb]([PersonUid],[UserName],[Password],[RequireNew],[LimitedTimePassword],[ExpirationDate],[IncorrectLoginDateTime],[IncorrectLoginCount],[PatientWebAccess],[UserPRMWebAccess],[ProviderWebAccess],[ProductConsentVersion],[PracticeConsentVersion],[ChartConsentVersion],[PatientSecurityAnswerList],[IncorrectPasswordResetDateTime],[IncorrectPasswordResetCount],[CreatedDateTime],[LastModifiedByUid],[LastModifiedDate])
SELECT [PersonUid],[UserName],[Password],[RequireNew],[LimitedTimePassword],[ExpirationDate],[IncorrectLoginDateTime],[IncorrectLoginCount],[PatientWebAccess],[UserPRMWebAccess],[ProviderWebAccess],[ProductConsentVersion],[PracticeConsentVersion],[ChartConsentVersion],CONVERT(nvarchar(max), [PatientSecurityAnswerList]),[IncorrectPasswordResetDateTime],[IncorrectPasswordResetCount],[CreatedDateTime],[LastModifiedByUid],[LastModifiedDate]
FROM [PersonWeb]

DROP TABLE [PersonWeb]

exec  sp_rename 'migtemp_PersonWeb', 'PersonWeb'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PracticeSettings]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PracticeSettings](
	[PracticeSettingsUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[MainAddress] [xml](CONTENT [dbo].[Address]) NULL,
	[MainPhone] [xml](CONTENT [dbo].[Phone]) NULL,
	[BillingAddress] [xml](CONTENT [dbo].[Address]) NULL,
	[InTimeZoneAdj] [int] NOT NULL,
	[ObserveDaylightSavings] [bit] NOT NULL,
	[StatementOnNewActivity] [bit] NOT NULL,
	[StatementCycle] [smallint] NOT NULL,
	[StatementDueDays] [smallint] NOT NULL,
	[StatementPaymentPlanNote] [varchar](max) NULL,
	[StatementDunningOn] [bit] NOT NULL,
	[SendPaperlessStatements] [bit] NOT NULL,
	[NewPatientReleaseDefault] [bit] NOT NULL,
	[PatientReleaseOnEveryVisit] [bit] NOT NULL,
	[FullPaymentRequired] [bit] NOT NULL,
	[ClaimSubmitterServiceSiteUid] [uniqueidentifier] NULL,
	[PayToServiceSiteUid] [uniqueidentifier] NULL,
	[CurrentPeriodEnd] [date] NOT NULL,
	[FiscalYearEnd] [date] NOT NULL,
	[CurrentPeriodEndOfMonth] [bit] NOT NULL,
	[FiscalYearEndOfYear] [bit] NOT NULL,
	[SystemFinancialsCloseThruDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ElectronicSubmitterID] [varchar](50) NULL,
	[StatementMinimumAmount] [money] NOT NULL,
	[ReportServerBaseURL] [varchar](255) NULL,
	[ReportServerSOAPPath] [varchar](255) NULL,
	[ReportServerWebPath] [varchar](255) NULL,
	[RouteClaimErorrMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteDocumentFaxSendErrorToUserGroupUid] [uniqueidentifier] NULL,
	[RouteRxMessageSendErrorToUserGroupUid] [uniqueidentifier] NULL,
	[RouteSurveyMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteReplicationConflictMessageToUserGroupUid] [uniqueidentifier] NULL,
	[ReplicationAppointmentHours] [smallint] NOT NULL,
	[ReplicationRemovePatientHours] [smallint] NULL,
	[ReplicationAttachmentSizeKB] [int] NOT NULL,
	[ScanAppointmentSeconds] [smallint] NULL,
	[TriggerRemovePatientSeconds] [smallint] NULL,
	[TriggerReplicationSeconds] [smallint] NULL,
	[UseThirdPartyPM] [bit] NOT NULL,
	[UseFormulary] [bit] NOT NULL,
	[DisableExceptionIgnoreButtonCount] [int] NOT NULL,
	[RouteAuthorizationRequestMessageToUserGroupUid] [uniqueidentifier] NULL,
	[DrugScreeningCriteria] [varchar](max) NULL,
	[RxReportRdlUid] [uniqueidentifier] NULL,
	[ScheduleIIRxReportRdlUid] [uniqueidentifier] NULL,
	[PrintSampleRx] [bit] NOT NULL,
	[CodeValidationAtSuperbillEnabled] [bit] NOT NULL,
	[CodeValidationMinimumErrorReport] [varchar](50) NULL,
	[CodeValidationErrorStopLevel] [varchar](50) NULL,
	[DefaultSystemARBatchOwnerUid] [uniqueidentifier] NULL,
	[AppointmentConfirmationEnabled] [bit] NOT NULL,
	[StatementsByFinancialCenter] [bit] NULL,
	[DunningMsgsUid] [uniqueidentifier] NULL,
	[InsuranceBalanceOnlySuperbills] [bit] NOT NULL,
	[AllowProcedureNotePopUp] [bit] NOT NULL,
	[eRxDownloadSetting] [varchar](2048) NULL,
	[FaxControlledSubstances] [bit] NOT NULL,
	[RxFooter] [varchar](50) NULL,
	[RoutePatientMessages] [xml](CONTENT [dbo].[PatientMessagesToUserGroup]) NULL,
	[AutoInternetPatientMessagingEnabled] [bit] NULL,
	[CalculateTax] [bit] NOT NULL,
	[TaxableOption] [smallint] NOT NULL,
	[AllowUnsentLabOrdersForCompletedNotes] [bit] NOT NULL,
	[RequireLabOrderTaskMsg] [bit] NOT NULL,
	[AutoCheckLabsRdyToSendForCompletedNotes] [bit] NOT NULL,
	[ShowPatientBirthTime] [bit] NOT NULL,
	[AppointmentEligibility] [bit] NOT NULL,
	[DaysEligibilityInAdvance] [smallint] NOT NULL,
	[EligibilityIncludeWeekends] [bit] NOT NULL,
	[RouteVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteNUSBVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[MaxImportDocumentErrorUid] [uniqueidentifier] NULL,
	[MaxImportDocumentSize] [int] NULL,
	[DisableIM] [bit] NOT NULL,
	[RequireDiagnosisBeforeOrdersCanBeSent] [bit] NOT NULL,
	[SQLCALUser] [bit] NULL,
	[IncludeReferringProvider] [bit] NOT NULL,
	[SuppressZeroDollarProcedures] [bit] NOT NULL,
	[IncludeLastFileDate] [bit] NOT NULL,
	[StatementFooter] [varchar](325) NULL,
	[IncludePaymentReferenceNumber] [bit] NOT NULL,
	[IncludeProcedureCode] [bit] NOT NULL,
	[EligibilityOncePerMonth] [bit] NOT NULL,
	[EligibilityCheckOnMonthChange] [bit] NOT NULL,
	[HMRulesDeleteNonRelevantIsDueMessages] [bit] NULL,
	[HMRulesCompleteNonRelevantIsDueMessages] [bit] NULL,
	[HMRulesCompletedByUid] [uniqueidentifier] NULL,
	[IncludeCompletedOrClosed] [bit] NOT NULL,
	[WarnWhenEditingCompleteNote] [bit] NOT NULL,
	[DisplayHistVaccOldestToRecent] [bit] NOT NULL,
	[VaccineCardPrintLandscape] [bit] NOT NULL,
	[PatientEmails] [xml](CONTENT [dbo].[PatientInternetEmails]) NULL,
	[DisplaySBStartStopTimes] [bit] NOT NULL,
	[RoutePatientPortalErrorMessageToUserGroupUid] [uniqueidentifier] NULL,
	[AllowPracticeSettingsDiagnosisLinking] [bit] NULL,
	[ShowRVUSearchingCPTUid] [uniqueidentifier] NULL,
	[PatientPortalMessageRouting] [xml] NULL,
	[PCMHParticipant] [bit] NOT NULL,
	[StatementModelUid] [uniqueidentifier] NULL,
	[RequestSignatureOnCreditCardReceipt] [bit] NOT NULL,
	[AllowConcurrentReferringProviders] [bit] NOT NULL,
	[OptOutStatementEmailUserGroupUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PracticeSettings'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PracticeSettings'

ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_PracticeSettingsUid]  DEFAULT (newid()) FOR [PracticeSettingsUid]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_InTimeZoneAdj]  DEFAULT ((0)) FOR [InTimeZoneAdj]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_ObserveDaylightSavings]  DEFAULT ((1)) FOR [ObserveDaylightSavings]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_StatementOnNewActivity]  DEFAULT ((0)) FOR [StatementOnNewActivity]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_StatementCycle]  DEFAULT ((30)) FOR [StatementCycle]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_StatementDueDays]  DEFAULT ((20)) FOR [StatementDueDays]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_StatementDunningOn]  DEFAULT ((1)) FOR [StatementDunningOn]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_SendPaperlessStatements]  DEFAULT ((0)) FOR [SendPaperlessStatements]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_NewPatientReleaseDefault]  DEFAULT ((1)) FOR [NewPatientReleaseDefault]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_PatientReleaseOnEveryVisit]  DEFAULT ((0)) FOR [PatientReleaseOnEveryVisit]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_FullPaymentRequired]  DEFAULT ((0)) FOR [FullPaymentRequired]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_EndOfMonthFlag]  DEFAULT ((1)) FOR [CurrentPeriodEndOfMonth]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_EndOfYearFlag]  DEFAULT ((1)) FOR [FiscalYearEndOfYear]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_LastModifiedByDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_SatementMinimumAmount]  DEFAULT ((1)) FOR [StatementMinimumAmount]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF__PracticeS__Repli__0303C7BD]  DEFAULT ((48)) FOR [ReplicationAppointmentHours]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF__PracticeS__Repli__03F7EBF6]  DEFAULT ((48)) FOR [ReplicationRemovePatientHours]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF__PracticeS__Repli__04EC102F]  DEFAULT ((100)) FOR [ReplicationAttachmentSizeKB]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF__PracticeS__ScanA__05E03468]  DEFAULT ((300)) FOR [ScanAppointmentSeconds]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF__PracticeS__Trigg__06D458A1]  DEFAULT ((300)) FOR [TriggerRemovePatientSeconds]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF__PracticeS__Trigg__07C87CDA]  DEFAULT ((30)) FOR [TriggerReplicationSeconds]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_UseThirdPartyPM]  DEFAULT ((0)) FOR [UseThirdPartyPM]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_UseFormulary]  DEFAULT ((0)) FOR [UseFormulary]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_DisableExceptionIgnoreButton]  DEFAULT ((5)) FOR [DisableExceptionIgnoreButtonCount]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_PrintSampleRx_1]  DEFAULT ((1)) FOR [PrintSampleRx]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_CodeValidationAtSuperbillEnabled]  DEFAULT ((0)) FOR [CodeValidationAtSuperbillEnabled]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_AppointmentConfirmationEnabled]  DEFAULT ((0)) FOR [AppointmentConfirmationEnabled]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_StatementsByFinancialCenter]  DEFAULT ((0)) FOR [StatementsByFinancialCenter]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_InsuranceBalanceOnlySuperbills]  DEFAULT ((0)) FOR [InsuranceBalanceOnlySuperbills]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_AllowProcedureNotePopUp]  DEFAULT ((0)) FOR [AllowProcedureNotePopUp]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_FaxControlledSubstances]  DEFAULT ((0)) FOR [FaxControlledSubstances]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_CalculateTax]  DEFAULT ((0)) FOR [CalculateTax]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_TaxableOption]  DEFAULT ((0)) FOR [TaxableOption]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_AllowUnsentLabOrdersForCompletedNotes]  DEFAULT ((0)) FOR [AllowUnsentLabOrdersForCompletedNotes]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_RequireLabOrderTaskMsg_1]  DEFAULT ((1)) FOR [RequireLabOrderTaskMsg]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_AutoCheckLabsRdyToSendForCompletedNotes_1]  DEFAULT ((1)) FOR [AutoCheckLabsRdyToSendForCompletedNotes]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_ShowPatientBirthTime]  DEFAULT ((0)) FOR [ShowPatientBirthTime]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_AppointmentEligibility]  DEFAULT ((0)) FOR [AppointmentEligibility]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_DaysEligibilityInAdvance]  DEFAULT ((2)) FOR [DaysEligibilityInAdvance]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_EligibilityIncludeWeekends]  DEFAULT ((0)) FOR [EligibilityIncludeWeekends]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_MaxImportDocumentSize]  DEFAULT ((20)) FOR [MaxImportDocumentSize]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_DisableIM]  DEFAULT ((0)) FOR [DisableIM]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_RequireDiagnosisBeforeOrdersCanBeSent]  DEFAULT ((0)) FOR [RequireDiagnosisBeforeOrdersCanBeSent]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_IncludeReferringProvider]  DEFAULT ((1)) FOR [IncludeReferringProvider]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_SuppressZeroDollarProcedures]  DEFAULT ((1)) FOR [SuppressZeroDollarProcedures]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_IncludeLastFileDate]  DEFAULT ((1)) FOR [IncludeLastFileDate]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_IncludePaymentReferenceNumber]  DEFAULT ((1)) FOR [IncludePaymentReferenceNumber]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_IncludeProcedureCode]  DEFAULT ((1)) FOR [IncludeProcedureCode]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_EligibilityOncePerMonth]  DEFAULT ((0)) FOR [EligibilityOncePerMonth]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_EligibilityCheckOnMonthChange]  DEFAULT ((0)) FOR [EligibilityCheckOnMonthChange]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_IncludeCompletedOrClosed]  DEFAULT ((0)) FOR [IncludeCompletedOrClosed]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_WarnWhenEditingCompleteNote]  DEFAULT ((0)) FOR [WarnWhenEditingCompleteNote]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_DisplayHistVaccOldestToRecent]  DEFAULT ((1)) FOR [DisplayHistVaccOldestToRecent]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_VaccineCardPrintLandscape]  DEFAULT ((1)) FOR [VaccineCardPrintLandscape]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_DisplaySBStartStopTimes_1]  DEFAULT ((0)) FOR [DisplaySBStartStopTimes]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_PCMHParticipant]  DEFAULT ((0)) FOR [PCMHParticipant]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_RequestSignatureOnCreditCardReceipt]  DEFAULT ((0)) FOR [RequestSignatureOnCreditCardReceipt]
ALTER TABLE [migtemp_PracticeSettings] ADD  CONSTRAINT [DF_PracticeSettings_AllowConcurrentReferringProviders]  DEFAULT ((0)) FOR [AllowConcurrentReferringProviders]

END
Truncate Table migtemp_PracticeSettings
INSERT [migtemp_PracticeSettings]([PracticeSettingsUid],[Name],[MainAddress],[MainPhone],[BillingAddress],[InTimeZoneAdj],[ObserveDaylightSavings],[StatementOnNewActivity],[StatementCycle],[StatementDueDays],[StatementPaymentPlanNote],[StatementDunningOn],[NewPatientReleaseDefault],[PatientReleaseOnEveryVisit],[FullPaymentRequired],[ClaimSubmitterServiceSiteUid],[PayToServiceSiteUid],[CurrentPeriodEnd],[FiscalYearEnd],[CurrentPeriodEndOfMonth],[FiscalYearEndOfYear],[SystemFinancialsCloseThruDate],[LastModifiedDate],[LastModifiedByUid],[ElectronicSubmitterID],[StatementMinimumAmount],[ReportServerBaseURL],[ReportServerSOAPPath],[ReportServerWebPath],[RouteClaimErorrMessageToUserGroupUid],[RouteDocumentFaxSendErrorToUserGroupUid],[RouteRxMessageSendErrorToUserGroupUid],[RouteSurveyMessageToUserGroupUid],[RouteReplicationConflictMessageToUserGroupUid],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[ScanAppointmentSeconds],[TriggerRemovePatientSeconds],[TriggerReplicationSeconds],[UseThirdPartyPM],[UseFormulary],[DisableExceptionIgnoreButtonCount],[RouteAuthorizationRequestMessageToUserGroupUid],[DrugScreeningCriteria],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[PrintSampleRx],[CodeValidationAtSuperbillEnabled],[CodeValidationMinimumErrorReport],[CodeValidationErrorStopLevel],[DefaultSystemARBatchOwnerUid],[AppointmentConfirmationEnabled],[StatementsByFinancialCenter],[DunningMsgsUid],[InsuranceBalanceOnlySuperbills],[AllowProcedureNotePopUp],[eRxDownloadSetting],[FaxControlledSubstances],[RxFooter],[RoutePatientMessages],[AutoInternetPatientMessagingEnabled],[CalculateTax],[TaxableOption],[AllowUnsentLabOrdersForCompletedNotes],[RequireLabOrderTaskMsg],[AutoCheckLabsRdyToSendForCompletedNotes],[ShowPatientBirthTime],[AppointmentEligibility],[DaysEligibilityInAdvance],[EligibilityIncludeWeekends],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[MaxImportDocumentErrorUid],[MaxImportDocumentSize],[DisableIM],[RequireDiagnosisBeforeOrdersCanBeSent],[SQLCALUser],[IncludeReferringProvider],[SuppressZeroDollarProcedures],[IncludeLastFileDate],[StatementFooter],[IncludePaymentReferenceNumber],[IncludeProcedureCode],[EligibilityOncePerMonth],[EligibilityCheckOnMonthChange],[HMRulesDeleteNonRelevantIsDueMessages],[HMRulesCompleteNonRelevantIsDueMessages],[HMRulesCompletedByUid],[IncludeCompletedOrClosed],[WarnWhenEditingCompleteNote],[DisplayHistVaccOldestToRecent],[VaccineCardPrintLandscape],[PatientEmails],[DisplaySBStartStopTimes],[RoutePatientPortalErrorMessageToUserGroupUid],[AllowPracticeSettingsDiagnosisLinking],[ShowRVUSearchingCPTUid],[PatientPortalMessageRouting])
SELECT [PracticeSettingsUid],[Name],CONVERT(nvarchar(max), [MainAddress]),CONVERT(nvarchar(max), [MainPhone]),CONVERT(nvarchar(max), [BillingAddress]),[InTimeZoneAdj],[ObserveDaylightSavings],[StatementOnNewActivity],[StatementCycle],[StatementDueDays],[StatementPaymentPlanNote],[StatementDunningOn],[NewPatientReleaseDefault],[PatientReleaseOnEveryVisit],[FullPaymentRequired],[ClaimSubmitterServiceSiteUid],[PayToServiceSiteUid],[CurrentPeriodEnd],[FiscalYearEnd],[CurrentPeriodEndOfMonth],[FiscalYearEndOfYear],[SystemFinancialsCloseThruDate],[LastModifiedDate],[LastModifiedByUid],[ElectronicSubmitterID],[StatementMinimumAmount],[ReportServerBaseURL],[ReportServerSOAPPath],[ReportServerWebPath],[RouteClaimErorrMessageToUserGroupUid],[RouteDocumentFaxSendErrorToUserGroupUid],[RouteRxMessageSendErrorToUserGroupUid],[RouteSurveyMessageToUserGroupUid],[RouteReplicationConflictMessageToUserGroupUid],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[ScanAppointmentSeconds],[TriggerRemovePatientSeconds],[TriggerReplicationSeconds],[UseThirdPartyPM],[UseFormulary],[DisableExceptionIgnoreButtonCount],[RouteAuthorizationRequestMessageToUserGroupUid],[DrugScreeningCriteria],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[PrintSampleRx],[CodeValidationAtSuperbillEnabled],[CodeValidationMinimumErrorReport],[CodeValidationErrorStopLevel],[DefaultSystemARBatchOwnerUid],[AppointmentConfirmationEnabled],[StatementsByFinancialCenter],[DunningMsgsUid],[InsuranceBalanceOnlySuperbills],[AllowProcedureNotePopUp],[eRxDownloadSetting],[FaxControlledSubstances],[RxFooter],CONVERT(nvarchar(max), [RoutePatientMessages]),[AutoInternetPatientMessagingEnabled],[CalculateTax],[TaxableOption],[AllowUnsentLabOrdersForCompletedNotes],[RequireLabOrderTaskMsg],[AutoCheckLabsRdyToSendForCompletedNotes],[ShowPatientBirthTime],[AppointmentEligibility],[DaysEligibilityInAdvance],[EligibilityIncludeWeekends],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[MaxImportDocumentErrorUid],[MaxImportDocumentSize],[DisableIM],[RequireDiagnosisBeforeOrdersCanBeSent],[SQLCALUser],[IncludeReferringProvider],[SuppressZeroDollarProcedures],[IncludeLastFileDate],[StatementFooter],[IncludePaymentReferenceNumber],[IncludeProcedureCode],[EligibilityOncePerMonth],[EligibilityCheckOnMonthChange],[HMRulesDeleteNonRelevantIsDueMessages],[HMRulesCompleteNonRelevantIsDueMessages],[HMRulesCompletedByUid],[IncludeCompletedOrClosed],[WarnWhenEditingCompleteNote],[DisplayHistVaccOldestToRecent],[VaccineCardPrintLandscape],CONVERT(nvarchar(max), [PatientEmails]),[DisplaySBStartStopTimes],[RoutePatientPortalErrorMessageToUserGroupUid],[AllowPracticeSettingsDiagnosisLinking],[ShowRVUSearchingCPTUid],CONVERT(nvarchar(max), [PatientPortalMessageRouting])
FROM [PracticeSettings]

DROP TABLE [PracticeSettings]

exec  sp_rename 'migtemp_PracticeSettings', 'PracticeSettings'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PrintSetDetail]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PrintSetDetail](
	[PrintSetDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[PrintSetUid] [uniqueidentifier] NULL,
	[ReportUid] [uniqueidentifier] NULL,
	[UseEducationForm] [bit] NOT NULL,
	[PrinterName] [varchar](100) NULL,
	[PrinterDeviceID] [varchar](100) NULL,
	[PrinterSettings] [varbinary](max) NULL,
	[OffsetTop] [numeric](9, 3) NOT NULL,
	[OffsetLeft] [numeric](9, 3) NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[CustomNotePrintUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PrintSetDetail'

ALTER TABLE [migtemp_PrintSetDetail] ADD  CONSTRAINT [DF_PrintSetDetail_PrintSetDetailUid]  DEFAULT (newid()) FOR [PrintSetDetailUid]
ALTER TABLE [migtemp_PrintSetDetail] ADD  CONSTRAINT [DF_PrintSetDetail_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_PrintSetDetail] ADD  CONSTRAINT [DF_PrintSetDetail_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_PrintSetDetail] ADD  CONSTRAINT [DF_PrintSetDetail_UseEducationForm]  DEFAULT ((0)) FOR [UseEducationForm]
ALTER TABLE [migtemp_PrintSetDetail] ADD  CONSTRAINT [DF_PrintSetDetail_OffsetTop]  DEFAULT ((0)) FOR [OffsetTop]
ALTER TABLE [migtemp_PrintSetDetail] ADD  CONSTRAINT [DF_PrintSetDetail_OffsetLeft]  DEFAULT ((0)) FOR [OffsetLeft]
ALTER TABLE [migtemp_PrintSetDetail] ADD  CONSTRAINT [DF_PrintSetDetail_LastModifiedDate_1]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PrintSetDetail
INSERT [migtemp_PrintSetDetail]([PrintSetDetailUid],[Inactive],[UserDefined],[PrintSetUid],[ReportUid],[PrinterName],[PrinterDeviceID],[PrinterSettings],[OffsetTop],[OffsetLeft],[LastModifiedByUid],[LastModifiedDate],[CustomNotePrintUid])
SELECT [PrintSetDetailUid],[Inactive],[UserDefined],[PrintSetUid],[ReportUid],[PrinterName],[PrinterDeviceID],[PrinterSettings],[OffsetTop],[OffsetLeft],[LastModifiedByUid],[LastModifiedDate],[CustomNotePrintUid]
FROM [PrintSetDetail]

DROP TABLE [PrintSetDetail]

exec  sp_rename 'migtemp_PrintSetDetail', 'PrintSetDetail'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Provider]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Provider](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_Provider_Inactive]  DEFAULT ((0)),
	[ProviderRoleID] [smallint] NOT NULL CONSTRAINT [DF_Provider_ProviderRoleID]  DEFAULT ((1)),
	[IsBillingProvider] [bit] NOT NULL CONSTRAINT [DF_Provider_IsBillingProvider]  DEFAULT ((1)),
	[IsReferringProvider] [bit] NOT NULL CONSTRAINT [DF_Provider_IsReferringProvider]  DEFAULT ((1)),
	[FTE] [smallint] NULL,
	[ProviderLicense] [smallint] NULL,
	[DefaultProviderCareTypeUid] [uniqueidentifier] NULL,
	[DefaultServiceSiteUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[FeeScheduleUid] [uniqueidentifier] NULL,
	[SignatureTypeId] [smallint] NOT NULL CONSTRAINT [DF_Provider_SignatureTypeId]  DEFAULT ((0)),
	[ReplicationAppointmentHours] [smallint] NOT NULL CONSTRAINT [DF_Provider_ReplicationAppointmentHours]  DEFAULT ((48)),
	[ReplicationRemovePatientHours] [smallint] NOT NULL CONSTRAINT [DF_Provider_ReplicationRemovePatientHours]  DEFAULT ((48)),
	[ReplicationAttachmentSizeKB] [smallint] NOT NULL CONSTRAINT [DF_Provider_ReplicationAttach5mentSizeKB]  DEFAULT ((50)),
	[AutoLearnCommonProblemPallet] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoLearnCommonProblemPallet_1]  DEFAULT ((1)),
	[EMCodeReminder] [bit] NOT NULL CONSTRAINT [DF_Provider_EMCodeReminder]  DEFAULT ((1)),
	[ePrescribeWarning] [bit] NOT NULL CONSTRAINT [DF_Provider_ePrescribeWarning]  DEFAULT ((1)),
	[PrintPrescriptionsOnCheckout] [bit] NOT NULL CONSTRAINT [DF_Provider_PrintPrescriptionsOnCheckout]  DEFAULT ((1)),
	[DefaultListInFNC] [smallint] NOT NULL CONSTRAINT [DF_Provider_DefaultListInFNC_1]  DEFAULT ((1)),
	[ROSOrder] [smallint] NOT NULL CONSTRAINT [DF_Provider_ROSOrder_1]  DEFAULT ((0)),
	[RxThermalPrinter] [bit] NOT NULL CONSTRAINT [DF_Provider_RxThermalPrinter]  DEFAULT ((0)),
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[TranscriptionistUid] [uniqueidentifier] NULL,
	[SpecialtyUid] [uniqueidentifier] NULL,
	[ETIN] [varchar](50) NULL,
	[EClaimSiteTaxID] [varchar](50) NULL,
	[MandatoryCosignature] [bit] NOT NULL CONSTRAINT [DF_Provider_MandatoryCosignature]  DEFAULT ((0)),
	[SupervisingPrescriptionSignatureSource] [bit] NOT NULL CONSTRAINT [DF_Provider_PrescriptionSignatureSource]  DEFAULT ((0)),
	[CanSignRx] [bit] NOT NULL CONSTRAINT [DF_Provider_CanSignRx]  DEFAULT ((0)),
	[DefaultReviewerUid] [uniqueidentifier] NULL,
	[RxReportRdlUid] [uniqueidentifier] NULL,
	[ScheduleIIRxReportRdlUid] [uniqueidentifier] NULL,
	[MedicationReportLastRun] [datetime] NULL,
	[UsePracticeSettingsBillingAddress] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePSPE]  DEFAULT ((1)),
	[UsePracticeSettingsMaintenaceDrugCls] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePracticeSettingsMaintenaceDrugCls]  DEFAULT ((0)),
	[ClaimProviderCorporationUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[ExternalID] [varchar](25) NULL,
	[AutoLinkDxCpt] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoLinkDxCpt_1]  DEFAULT ((0)),
	[SuperbillStatusID] [smallint] NOT NULL CONSTRAINT [DF_Provider_SuperbillStatusID]  DEFAULT ((0)),
	[ConsultingProvider] [bit] NOT NULL CONSTRAINT [DF_Provider_Consult]  DEFAULT ((0)),
	[AuthorizationGroupUid] [uniqueidentifier] NULL,
	[AuthorizationReviewerUid] [uniqueidentifier] NULL,
	[DrugScreeningCriteria] [varchar](max) NULL,
	[UseLDM] [bit] NOT NULL CONSTRAINT [DF_Provider_UseLDM]  DEFAULT ((1)),
	[AutoAddMedicationReport] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoAddMedicationReport]  DEFAULT ((1)),
	[EduFormAssociationUid] [uniqueidentifier] NULL,
	[PayToProviderCorporationUid] [uniqueidentifier] NULL,
	[Initials] [varchar](5) NULL,
	[DocumentFaxElection] [smallint] NOT NULL CONSTRAINT [DF_Provider_DocumentFaxElection]  DEFAULT ((0)),
	[RouteDocumentFaxErrorToUserUid] [uniqueidentifier] NULL,
	[DefaultCoverageTypeUid] [uniqueidentifier] NULL,
	[DefaultLabOrderTaskMsgRecvrUid] [uniqueidentifier] NULL,
	[AutoSendLabOrderMsgs] [bit] NULL CONSTRAINT [DF_Provider_AutoSendLabOrderMsgs_1]  DEFAULT ((0)),
	[UsePracticeSettingseRxDownloadSetting] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePracticeSettingseRxDownloadSetting]  DEFAULT ((1)),
	[eRxDownloadSetting] [varchar](2048) NULL,
	[AutoCheckNoteComplete] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoCheckNoteComplete]  DEFAULT ((0)),
	[RoutePatientMessages] [xml](CONTENT [dbo].[PatientMessagesToUserGroup]) NULL,
	[DefaultCheckDischargePatient] [bit] NOT NULL CONSTRAINT [DF_Provider_DefaultCheckDischargePatient_1]  DEFAULT ((0)),
	[DefaultCheckSendPrescriptions] [bit] NOT NULL CONSTRAINT [DF_Provider_DefaultCheckSendPrescriptions_1]  DEFAULT ((0)),
	[DefaultCheckSendLabOrders] [bit] NOT NULL CONSTRAINT [DF_Provider_DefaultCheckSendLabOrders_1]  DEFAULT ((0)),
	[AllowProcedureWithoutDiag] [bit] NOT NULL CONSTRAINT [DF_Provider_AllowProcedureWithoutDiag]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Provider_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Provider_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[RouteVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteNUSBVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[SendCanelServiceOrderMessage] [bit] NOT NULL CONSTRAINT [DF_Provider_SendCanelServiceOrderMessage]  DEFAULT ((0)),
	[UsePracticeSettingsPatientEmails] [bit] NOT NULL CONSTRAINT [DF_Provider_UsePracticeSettingsPatientEmails]  DEFAULT ((1)),
	[PatientEmails] [xml](CONTENT [dbo].[PatientInternetEmails]) NULL,
	[ValidateBillingTime] [bit] NOT NULL CONSTRAINT [DF_Provider_ValidateBillingTime_1]  DEFAULT ((0)),
	[AprimaDataExchangeRegistrationLastUpdate] [datetime] NULL,
	[AprimaDataExchangeProviderRegistrationUid] [uniqueidentifier] NULL,
	[DefaultEMPlaceofServiceID] [tinyint] NULL,
	[AutoLinkingDiagnosisProblem] [bit] NOT NULL CONSTRAINT [DF_Provider_AutoLinkingDingnosisProblem]  DEFAULT ((1)),
	[DefaultBillingProviderUid] [uniqueidentifier] NULL,
	[IdentityVerification] [xml] NULL,
	[CDSCatalogUid] [uniqueidentifier] NULL,
	[DiagnosisRangePlanUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The full time equivalent percentage for this provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider', @level2type=N'COLUMN',@level2name=N'FTE'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 - Head to Toe; 1 - Alphabetical; 2 - User Defined' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider', @level2type=N'COLUMN',@level2name=N'ROSOrder'
EXEC sys.sp_addextendedproperty @name=N'DefaultEMPlaceofServiceID', @value=N'<Office value="0" description="Office" /><NursingFacility value="1" description="Nursing Facility" /><HomeServices value="2" description="Home Services" /><RestHome value="3" description="Rest Home" /><Observation value="4" description="Observation" /><Inpatient value="5" description="Inpatient" /><CriticalCare value="6" description="Critical Care" /><ER value="7" description="ER" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'DocumentFaxElection', @value=N'<NoFax value="0" />
<AutoFax value="1" />
<Prompt value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'UserPRM' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'ProviderLicense', @value=N'<None value="0" />
<EMR value="1" />
<PM value="2" />
<PRM value="3" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'ProviderRoleID', @value=N'<Physician value="1" />
<OtherProvider value="2" />
<TestProvider value="3" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'!FK_Provider_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'ROSOrder', @value=N'<HeadToToe value="0" />
<Alphabetical value="1" />
<UserDefined value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'SignatureTypeId', @value=N'<None value="0" />
<Permanent value="1" />
<OncePerDay value="2" />
<OncePerLogin value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'


END
Truncate Table migtemp_Provider
INSERT [migtemp_Provider]([PersonUid],[Inactive],[ProviderRoleID],[IsBillingProvider],[IsReferringProvider],[FTE],[ProviderLicense],[DefaultProviderCareTypeUid],[DefaultServiceSiteUid],[FinancialCenterUid],[FeeScheduleUid],[SignatureTypeId],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[AutoLearnCommonProblemPallet],[EMCodeReminder],[ePrescribeWarning],[PrintPrescriptionsOnCheckout],[DefaultListInFNC],[ROSOrder],[RxThermalPrinter],[ClinicCenterUid],[TranscriptionistUid],[SpecialtyUid],[ETIN],[EClaimSiteTaxID],[MandatoryCosignature],[SupervisingPrescriptionSignatureSource],[CanSignRx],[DefaultReviewerUid],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[MedicationReportLastRun],[UsePracticeSettingsBillingAddress],[UsePracticeSettingsMaintenaceDrugCls],[ClaimProviderCorporationUid],[Notes],[ExternalID],[AutoLinkDxCpt],[SuperbillStatusID],[ConsultingProvider],[AuthorizationGroupUid],[AuthorizationReviewerUid],[DrugScreeningCriteria],[UseLDM],[AutoAddMedicationReport],[EduFormAssociationUid],[PayToProviderCorporationUid],[Initials],[DocumentFaxElection],[RouteDocumentFaxErrorToUserUid],[DefaultCoverageTypeUid],[DefaultLabOrderTaskMsgRecvrUid],[AutoSendLabOrderMsgs],[UsePracticeSettingseRxDownloadSetting],[eRxDownloadSetting],[AutoCheckNoteComplete],[RoutePatientMessages],[DefaultCheckDischargePatient],[DefaultCheckSendPrescriptions],[DefaultCheckSendLabOrders],[AllowProcedureWithoutDiag],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[SendCanelServiceOrderMessage],[UsePracticeSettingsPatientEmails],[PatientEmails],[ValidateBillingTime],[AprimaDataExchangeRegistrationLastUpdate],[AprimaDataExchangeProviderRegistrationUid],[DefaultEMPlaceofServiceID],[AutoLinkingDiagnosisProblem],[DefaultBillingProviderUid],[IdentityVerification],[CDSCatalogUid])
SELECT [PersonUid],[Inactive],[ProviderRoleID],[IsBillingProvider],[IsReferringProvider],[FTE],[ProviderLicense],[DefaultProviderCareTypeUid],[DefaultServiceSiteUid],[FinancialCenterUid],[FeeScheduleUid],[SignatureTypeId],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[AutoLearnCommonProblemPallet],[EMCodeReminder],[ePrescribeWarning],[PrintPrescriptionsOnCheckout],[DefaultListInFNC],[ROSOrder],[RxThermalPrinter],[ClinicCenterUid],[TranscriptionistUid],[SpecialtyUid],[ETIN],[EClaimSiteTaxID],[MandatoryCosignature],[SupervisingPrescriptionSignatureSource],[CanSignRx],[DefaultReviewerUid],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[MedicationReportLastRun],[UsePracticeSettingsBillingAddress],[UsePracticeSettingsMaintenaceDrugCls],[ClaimProviderCorporationUid],[Notes],[ExternalID],[AutoLinkDxCpt],[SuperbillStatusID],[ConsultingProvider],[AuthorizationGroupUid],[AuthorizationReviewerUid],[DrugScreeningCriteria],[UseLDM],[AutoAddMedicationReport],[EduFormAssociationUid],[PayToProviderCorporationUid],[Initials],[DocumentFaxElection],[RouteDocumentFaxErrorToUserUid],[DefaultCoverageTypeUid],[DefaultLabOrderTaskMsgRecvrUid],[AutoSendLabOrderMsgs],[UsePracticeSettingseRxDownloadSetting],[eRxDownloadSetting],[AutoCheckNoteComplete],CONVERT(nvarchar(max), [RoutePatientMessages]),[DefaultCheckDischargePatient],[DefaultCheckSendPrescriptions],[DefaultCheckSendLabOrders],[AllowProcedureWithoutDiag],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[SendCanelServiceOrderMessage],[UsePracticeSettingsPatientEmails],CONVERT(nvarchar(max), [PatientEmails]),[ValidateBillingTime],[AprimaDataExchangeRegistrationLastUpdate],[AprimaDataExchangeProviderRegistrationUid],[DefaultEMPlaceofServiceID],[AutoLinkingDiagnosisProblem],[DefaultBillingProviderUid],CONVERT(nvarchar(max), [IdentityVerification]),[CDSCatalogUid]
FROM [Provider]

DROP TABLE [Provider]

exec  sp_rename 'migtemp_Provider', 'Provider'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureMethod' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DisclosureMethod' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DisclosureType' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'RecipientType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'RecipientType' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ForcedUploadProcessOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Status' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Status' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureMethod' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DisclosureMethod', @value=N'<None value="0"/><DirectCommunicationEmail value="1"/><Fax value="2" /><Print value="3" /><SaveToFile value="4" /><Portal value="5" /><FacilityPortal value="6" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DisclosureType', @value=N'<None value="0"/><CompleteChart value="1" />  <ClinicalSummary value="2" />  <LabResult value="3" /> <Medication value="4" /> <MedicationAllergies value="5" /> <Immunizations value="6" /> <Procedures value="7" /> <MedicalHistory value="8" /> <EducationMaterial value="9" /> <Demographics value="10" /> <ContinuityOfCareDocument value="11" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'RecipientType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'RecipientType', @value=N'<None value="0"/><Provider value="1"/><MedicalServiceProvider value="2" /><ServiceSite value="3" /><Patient value="4" /><OtherRecipient value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Status' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<Sent value="1"/><Error value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelAttachmentGroup]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelAttachmentGroup](
	[RelAttachmentGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AttachmentGroupUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[ObservationOrderUid] [uniqueidentifier] NULL,
	[MessageUid] [uniqueidentifier] NULL,
	[PatientProcedureUid] [uniqueidentifier] NULL,
	[IncludeInSummary] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[PatientProviderRelationshipUid] [uniqueidentifier] NULL,
	[PatientReferralUid] [uniqueidentifier] NULL,
	[PracticeFormUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedRelationships', @value=N'Attachment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'AttachmentGroupUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSize', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'AttachmentGroupUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'ObservationOrderUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'MessageUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_RelAttachmentGroup_Person,FK_RelAttachmentGroup_Visit,FK_RelAttachmentGroup_ObservationOrder,FK_RelAttachmentGroup_Message,FK_RelAttachmentGroup_AccountResponsibleParty,FK_MessageAA_RelAttachmentGroup}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup'

ALTER TABLE [migtemp_RelAttachmentGroup] ADD  CONSTRAINT [DF_RelAttachment_RelAttachmentGroupUid]  DEFAULT (newid()) FOR [RelAttachmentGroupUid]
ALTER TABLE [migtemp_RelAttachmentGroup] ADD  CONSTRAINT [DF_RelAttachmentGroup_IncludeInSummary]  DEFAULT ((0)) FOR [IncludeInSummary]
ALTER TABLE [migtemp_RelAttachmentGroup] ADD  CONSTRAINT [DF_RelAttachment_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_RelAttachmentGroup] ADD  CONSTRAINT [DF_RelAttachment_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelAttachmentGroup
INSERT [migtemp_RelAttachmentGroup]([RelAttachmentGroupUid],[AttachmentGroupUid],[PersonUid],[VisitUid],[AccountResponsiblePartyUid],[DepositUid],[ObservationOrderUid],[MessageUid],[IncludeInSummary],[Inactive],[LastModifiedByUid],[LastModifiedDate],[PatientProviderRelationshipUid],[PatientReferralUid])
SELECT [RelAttachmentGroupUid],[AttachmentGroupUid],[PersonUid],[VisitUid],[AccountResponsiblePartyUid],[DepositUid],[ObservationOrderUid],[MessageUid],[IncludeInSummary],[Inactive],[LastModifiedByUid],[LastModifiedDate],[PatientProviderRelationshipUid],[PatientReferralUid]
FROM [RelAttachmentGroup]

DROP TABLE [RelAttachmentGroup]

exec  sp_rename 'migtemp_RelAttachmentGroup', 'RelAttachmentGroup'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelBatchProcessDetailActionSummary]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelBatchProcessDetailActionSummary](
	[RelBatchProcessDetailActionSummaryUid] [uniqueidentifier] NOT NULL,
	[BatchProcessDetailUid] [uniqueidentifier] NOT NULL,
	[ActionType] [varchar](100) NOT NULL,
	[Summary] [varchar](1000) NULL,
	[Detail] [varchar](max) NULL,
	[Success] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelBatchProcessDetailActionSummary'

ALTER TABLE [RelBatchProcessDetailActionSummary] ADD  CONSTRAINT [DF_RelBatchProcessDetailActionSummary_RelBatchProcessDetailActionSummaryUid]  DEFAULT (newid()) FOR [RelBatchProcessDetailActionSummaryUid]
ALTER TABLE [RelBatchProcessDetailActionSummary] ADD  CONSTRAINT [DF_RelBatchProcessDetailActionSummary_Success]  DEFAULT ((0)) FOR [Success]
ALTER TABLE [RelBatchProcessDetailActionSummary] ADD  CONSTRAINT [DF_RelBatchProcessDetailActionSummary_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelCaseAuthorizationDx]') AND name = 'DiagnosisUid')
ALTER TABLE [RelCaseAuthorizationDx] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelCCSymptomHpi]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelCCSymptomHpi](
	[RelCCSymptomHpiUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_RelCCSymptomHpiUid]  DEFAULT (newid()),
	[RelCCSymptomHpiCategoryUid] [uniqueidentifier] NOT NULL,
	[HpiUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[ProcedurePerformed] [bit] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_ProcedurePerformed]  DEFAULT ((1)),
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DiagnosisDescription] [varchar](255) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCCSymptomHpi_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hpi id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi', @level2type=N'COLUMN',@level2name=N'HpiUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'sequence' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'age group 1: adult; 2: child < 18' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi', @level2type=N'COLUMN',@level2name=N'AgeGroupUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPI description list of the CC symptom' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi'


END
Truncate Table migtemp_RelCCSymptomHpi
INSERT [migtemp_RelCCSymptomHpi]([RelCCSymptomHpiUid],[RelCCSymptomHpiCategoryUid],[HpiUid],[DisplayOrder],[AgeGroupUid],[SnomedConceptID],[DescriptionUid],[UserDefined],[ClinicCenterOverride],[ProviderOverride],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelCCSymptomHpiUid],[RelCCSymptomHpiCategoryUid],[HpiUid],[DisplayOrder],[AgeGroupUid],[SnomedConceptID],[DescriptionUid],[UserDefined],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LastModifiedByUid],[LastModifiedDate]
FROM [RelCCSymptomHpi]

DROP TABLE [RelCCSymptomHpi]

exec  sp_rename 'migtemp_RelCCSymptomHpi', 'RelCCSymptomHpi'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelCCSymptomHpiCategory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelCCSymptomHpiCategory](
	[RelCCSymptomHpiCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_RelCCSymptomHpiCategoryUid]  DEFAULT (newid()),
	[RelCCSystemSymptomUid] [uniqueidentifier] NOT NULL,
	[HpiCategoryUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_UserDefined]  DEFAULT ((1)),
	[NaturalLanguage] [varchar](100) NULL,
	[SingleSelect] [bit] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_SingleSelect]  DEFAULT ((0)),
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCCSymptomHpiCategory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'HpiCategoryUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'AgeGroupUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hpi category list of the CC symptom' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory'


END
Truncate Table migtemp_RelCCSymptomHpiCategory
INSERT [migtemp_RelCCSymptomHpiCategory]([RelCCSymptomHpiCategoryUid],[RelCCSystemSymptomUid],[HpiCategoryUid],[DisplayOrder],[AgeGroupUid],[UserDefined],[NaturalLanguage],[ClinicCenterOverride],[ProviderOverride],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelCCSymptomHpiCategoryUid],[RelCCSystemSymptomUid],[HpiCategoryUid],[DisplayOrder],[AgeGroupUid],[UserDefined],[NaturalLanguage],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LastModifiedByUid],[LastModifiedDate]
FROM [RelCCSymptomHpiCategory]

DROP TABLE [RelCCSymptomHpiCategory]

exec  sp_rename 'migtemp_RelCCSymptomHpiCategory', 'RelCCSymptomHpiCategory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelCCSystemSymptom]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelCCSystemSymptom](
	[RelCCSystemSymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_RelCCSystemSymptomUid]  DEFAULT (newid()),
	[CCSystemUid] [uniqueidentifier] NOT NULL,
	[CCSymptomUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_UserDefined]  DEFAULT ((1)),
	[Preposition] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_Inactive]  DEFAULT ((0)),
	[ShortcutRelCCSystemSymptomUid] [uniqueidentifier] NULL,
	[LicenseCode] [varchar](50) NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverrideCC]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverrideCC]) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DiagnosisDescription] [varchar](255) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelCCSystemSymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'System ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'CCSystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Symptom ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'CCSymptomUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Seq (Order)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Age Group (1: > 18yrs; 2: <= 18 yrs)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'AgeGroupUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CC list associates with the body system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom'


END
Truncate Table migtemp_RelCCSystemSymptom
INSERT [migtemp_RelCCSystemSymptom]([RelCCSystemSymptomUid],[CCSystemUid],[CCSymptomUid],[DisplayOrder],[AgeGroupUid],[UserDefined],[Preposition],[Inactive],[ShortcutRelCCSystemSymptomUid],[LicenseCode],[ClinicCenterOverride],[ProviderOverride],[SnomedConceptID],[DescriptionUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelCCSystemSymptomUid],[CCSystemUid],[CCSymptomUid],[DisplayOrder],[AgeGroupUid],[UserDefined],[Preposition],[Inactive],[ShortcutRelCCSystemSymptomUid],[LicenseCode],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[SnomedConceptID],[DescriptionUid],[LastModifiedByUid],[LastModifiedDate]
FROM [RelCCSystemSymptom]

DROP TABLE [RelCCSystemSymptom]

exec  sp_rename 'migtemp_RelCCSystemSymptom', 'RelCCSystemSymptom'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RelChargeTicketDiagnosis' AND COLUMN_NAME = 'SearchDefinition')
ALTER TABLE [RelChargeTicketDiagnosis]  ALTER COLUMN [SearchDefinition] varchar(800) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelChargeTicketDiagnosis]') AND name = 'DiagnosisUid')
ALTER TABLE [RelChargeTicketDiagnosis] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelDiagnosisDisease]') AND name = 'DiagnosisUid')
ALTER TABLE [RelDiagnosisDisease] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelDiagnosisDpn]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelDiagnosisDpn](
	[RelDiagnosisDpnUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DpnGroupUid] [uniqueidentifier] NOT NULL,
	[DiagnosisSearchDefinition] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelDiagnosisDpn'

ALTER TABLE [RelDiagnosisDpn] ADD  CONSTRAINT [DF_RelProcedure_DpnRelDiagnosisDpnUid]  DEFAULT (newid()) FOR [RelDiagnosisDpnUid]
ALTER TABLE [RelDiagnosisDpn] ADD  CONSTRAINT [DF_RelDiagnosisDpn_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [RelDiagnosisDpn] ADD  CONSTRAINT [DF_RelDiagnosisDpn_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelDiagnosisPanelDiagnosis]') AND name = 'DiagnosisUid')
ALTER TABLE [RelDiagnosisPanelDiagnosis] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelDiagnosisProcedure]') AND name = 'DiagnosisUid')
ALTER TABLE [RelDiagnosisProcedure] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelDiagnosisRangePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelDiagnosisRangePlan](
	[RelDiagnosisRangePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DiagnosisRangePlanUid] [uniqueidentifier] NULL,
	[DiagnosisSearchDefinitionUid] [uniqueidentifier] NOT NULL,
	[DpnGroupUid] [uniqueidentifier] NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelDiagnosisRangePlan'

ALTER TABLE [RelDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelDiagnosisSearchPlan_RelDiagnosisRangePlanUid]  DEFAULT (newid()) FOR [RelDiagnosisRangePlanUid]
ALTER TABLE [RelDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelDiagnosisRangePlan_DisplayOrder1]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [RelDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelDiagnosisRangePlan_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [RelDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelDiagnosisSearchPlan_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [RelDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelDiagnosisSearchPlan_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelEduFormAssociation]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelEduFormAssociation](
	[RelEduFormAssociationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_RelEduFormAssociationUid]  DEFAULT (newid()),
	[EduFormAssociationUid] [uniqueidentifier] NOT NULL,
	[EduFormUid] [uniqueidentifier] NOT NULL,
	[Smoker] [bit] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_Smoker]  DEFAULT ((0)),
	[Underweight] [bit] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_Underweight]  DEFAULT ((0)),
	[Overweight] [bit] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_Overweight]  DEFAULT ((0)),
	[RecurrenceInterval] [smallint] NULL CONSTRAINT [DF_RelEduFormAssociation_RecurrenceInterval]  DEFAULT ((0)),
	[RecurTimeTypeUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[AgeFrom] [int] NULL,
	[AgeTo] [int] NULL,
	[AgeTimeTypeUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelEduFormAssociation_UserDefined_1]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelEduFormGroup_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelEduFormAssociation'


END
Truncate Table migtemp_RelEduFormAssociation
INSERT [migtemp_RelEduFormAssociation]([RelEduFormAssociationUid],[EduFormAssociationUid],[EduFormUid],[Smoker],[Underweight],[Overweight],[RecurrenceInterval],[RecurTimeTypeUid],[GenderUid],[AgeFrom],[AgeTo],[AgeTimeTypeUid],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelEduFormAssociationUid],[EduFormAssociationUid],[EduFormUid],[Smoker],[Underweight],[Overweight],[RecurrenceInterval],[RecurTimeTypeUid],[GenderUid],[AgeFrom],[AgeTo],[AgeTimeTypeUid],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [RelEduFormAssociation]

DROP TABLE [RelEduFormAssociation]

exec  sp_rename 'migtemp_RelEduFormAssociation', 'RelEduFormAssociation'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelEduFormDiagnosis]') AND name = 'DiagnosisUid')
ALTER TABLE [RelEduFormDiagnosis] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RelFindTableMFUDiagnosis' AND COLUMN_NAME = 'LexCode')
ALTER TABLE [RelFindTableMFUDiagnosis]  ALTER COLUMN [LexCode] bigint NOT NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RelFindTableMFUDiagnosis' AND COLUMN_NAME = 'Code09')
ALTER TABLE [RelFindTableMFUDiagnosis]  ALTER COLUMN [Code09] varchar(25) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RelFindTableMFUDiagnosis' AND COLUMN_NAME = 'Code10')
ALTER TABLE [RelFindTableMFUDiagnosis]  ALTER COLUMN [Code10] varchar(25) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RelFindTableMRUDiagnosis' AND COLUMN_NAME = 'LexCode')
ALTER TABLE [RelFindTableMRUDiagnosis]  ALTER COLUMN [LexCode] bigint NOT NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RelFindTableMRUDiagnosis' AND COLUMN_NAME = 'Code09')
ALTER TABLE [RelFindTableMRUDiagnosis]  ALTER COLUMN [Code09] varchar(25) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RelFindTableMRUDiagnosis' AND COLUMN_NAME = 'Code10')
ALTER TABLE [RelFindTableMRUDiagnosis]  ALTER COLUMN [Code10] varchar(25) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelHospitalRoundDiagnosis]') AND name = 'DiagnosisUid')
ALTER TABLE [RelHospitalRoundDiagnosis] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelMedicationDiagnosis]') AND name = 'DiagnosisUid')
ALTER TABLE [RelMedicationDiagnosis] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelMedicationStateScheduledDrugName', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelMedicationStateScheduledDrugName'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'ObservationViewOptionUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'ObservationViewOptionUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LaboratoryUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'DisplayOrder'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'Inactive'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'ObservationViewOptionUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'View Option Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'ObservationViewOptionUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LaboratoryUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'laboratory id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'DisplayOrder'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'display order' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'Inactive'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 = Inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'RelObservationViewOptionLaboratory', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'getutcdate() for LastModifiedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationViewOptionLaboratory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCondition]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientCondition](
	[RelPatientConditionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[PatientConditionUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelPatientCondition] ADD  CONSTRAINT [DF_RelPatientCondition_RelPatientConditionUid]  DEFAULT (newid()) FOR [RelPatientConditionUid]
ALTER TABLE [RelPatientCondition] ADD  CONSTRAINT [DF_RelPatientCondition_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [RelPatientCondition] ADD  CONSTRAINT [DF_RelPatientCondition_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientPersonWeb]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientPersonWeb](
	[RelPatientPersonWebUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[IgnoreAge] [bit] NOT NULL,
	[Inactive] [smallint] NOT NULL,
	[PersonContactUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 - False; 1 - True; 2 - Deactivated_Due_To_Age; 3 - Deactivated_From_Contact; 4 - Deactivated_From_RP;' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientPersonWeb', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" /><Deactivated_Due_To_Age value="2" /><Deactivated_From_Contact value="3" /><Deactivated_From_RP value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientPersonWeb'

ALTER TABLE [RelPatientPersonWeb] ADD  CONSTRAINT [DF_RelPatientPersonWeb_RelPatientPersonWebUid]  DEFAULT (newid()) FOR [RelPatientPersonWebUid]
ALTER TABLE [RelPatientPersonWeb] ADD  CONSTRAINT [DF_RelPatientPersonWeb_IgnoreAge]  DEFAULT ((0)) FOR [IgnoreAge]
ALTER TABLE [RelPatientPersonWeb] ADD  CONSTRAINT [DF_RelPatientPersonWeb_Inactive]  DEFAULT ((0)) FOR [Inactive]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientProgram]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientProgram](
	[RelPatientProgramUid] [uniqueidentifier] NOT NULL,
	[PatientProgramUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelPatientProgram] ADD  CONSTRAINT [DF_RelPatientProgram_RelPatientProgram]  DEFAULT (newid()) FOR [RelPatientProgramUid]
ALTER TABLE [RelPatientProgram] ADD  CONSTRAINT [DF_RelPatientProgram_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientProgramPersonWeb]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientProgramPersonWeb](
	[RelPatientProgramPersonWebUid] [uniqueidentifier] NOT NULL,
	[PatientProgramUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[Inactive] [smallint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'

ALTER TABLE [RelPatientProgramPersonWeb] ADD  CONSTRAINT [DF_RelPatientProgramPersonWeb_Inactive]  DEFAULT ((0)) FOR [Inactive]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelPETemplateDescription]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelPETemplateDescription](
	[RelPETemplateDescriptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPETemplateDescription_RelPETemplateDescriptionUid]  DEFAULT (newid()),
	[RelPETemplateSymptomUid] [uniqueidentifier] NOT NULL,
	[PEDescriptionUid] [uniqueidentifier] NOT NULL,
	[RelEMKeyComponentBulletUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[NormalFlag] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_NormalFlag]  DEFAULT ((0)),
	[DefaultFlag] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_DefaultFlag]  DEFAULT ((0)),
	[CountAsBullet] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_CountAsBullet]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_UserDefined]  DEFAULT ((1)),
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverridePE]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverridePE]) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_LifeLong_1]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPETemplateDescription_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPETemplateDescription'


END
Truncate Table migtemp_RelPETemplateDescription
INSERT [migtemp_RelPETemplateDescription]([RelPETemplateDescriptionUid],[RelPETemplateSymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[NormalFlag],[DefaultFlag],[CountAsBullet],[UserDefined],[ClinicCenterOverride],[ProviderOverride],[SnomedConceptID],[DescriptionUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelPETemplateDescriptionUid],[RelPETemplateSymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[NormalFlag],[DefaultFlag],[CountAsBullet],[UserDefined],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[SnomedConceptID],[DescriptionUid],[LastModifiedByUid],[LastModifiedDate]
FROM [RelPETemplateDescription]

DROP TABLE [RelPETemplateDescription]

exec  sp_rename 'migtemp_RelPETemplateDescription', 'RelPETemplateDescription'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPlanGroupPlanNode]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPlanGroupPlanNode](
	[RelPlanGroupPlanNodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ParentRelPlanGroupPlanNodeUid] [uniqueidentifier] NULL,
	[PlanGroupUid] [uniqueidentifier] NOT NULL,
	[PlanNodeUid] [uniqueidentifier] NOT NULL,
	[NodeLevel] [int] NOT NULL,
	[IsNodeLeaf] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[PreSelected] [bit] NOT NULL,
	[DefaultFlag] [bit] NOT NULL,
	[SnomedDescriptionUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[ClinicCenterOverride] [xml] NULL,
	[ProviderOverride] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[IsMultiSelect] [bit] NOT NULL,
	[RequiredFlag] [bit] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPlanGroupPlanNode'

ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_RelPlanGroupPlanNodeUid]  DEFAULT (newid()) FOR [RelPlanGroupPlanNodeUid]
ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_NodeLevel]  DEFAULT ((0)) FOR [NodeLevel]
ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_IsNodeLeaf]  DEFAULT ((1)) FOR [IsNodeLeaf]
ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_PreSelected]  DEFAULT ((0)) FOR [PreSelected]
ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_DefaultFlag]  DEFAULT ((0)) FOR [DefaultFlag]
ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_IsMultiSelect]  DEFAULT ((1)) FOR [IsMultiSelect]
ALTER TABLE [RelPlanGroupPlanNode] ADD  CONSTRAINT [DF_RelPlanGroupPlanNode_RequiredFlag]  DEFAULT ((0)) FOR [RequiredFlag]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPlanProviderDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPlanProviderDiagnosis](
	[RelPlanProviderDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PlanGroupUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DefaultValuesXML] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPlanProviderDiagnosis'

ALTER TABLE [RelPlanProviderDiagnosis] ADD  CONSTRAINT [DF_RelPlanProviderDiagnosis_RelPlanProviderDiagnosisUid]  DEFAULT (newid()) FOR [RelPlanProviderDiagnosisUid]
ALTER TABLE [RelPlanProviderDiagnosis] ADD  CONSTRAINT [DF_RelPlanProviderDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPracticeFormPatient]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPracticeFormPatient](
	[RelPracticeFormPatientUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PracticeFormUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[EffectiveDate] [datetime] NOT NULL,
	[ExpirationDate] [date] NULL,
	[LastViewedByPortalDate] [datetime] NULL,
	[LastDownloadedByPortalDate] [datetime] NULL,
	[LastUploadedByPortalDate] [datetime] NULL,
	[UploadedAttachmentGroupUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[MessageAAUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [RelPracticeFormPatient] ADD  CONSTRAINT [DF_RelPracticeFormPatient_RelPracticeFormPatientUid]  DEFAULT (newid()) FOR [RelPracticeFormPatientUid]
ALTER TABLE [RelPracticeFormPatient] ADD  CONSTRAINT [DF_RelPracticeFormPatient_EffectiveDate]  DEFAULT (getutcdate()) FOR [EffectiveDate]
ALTER TABLE [RelPracticeFormPatient] ADD  CONSTRAINT [DF_RelPracticeFormPatient_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelProcedureHistoryTermProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelProcedureHistoryTermProcedure](
	[RelProcedureHistoryTermProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelProcedureHistoryTermProcedure_RelProcedureHistoryTermProcedureUid]  DEFAULT (newid()),
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[ProcedureHistoryTermUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelProcedureHistoryTermProcedure_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelProcedureHistoryTermProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelProcedureHistoryTermProcedure'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelProviderDiagnosisRangePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelProviderDiagnosisRangePlan](
	[RelProviderDiagnosisRangePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[DiagnosisRangePlanUid] [uniqueidentifier] NOT NULL,
	[DiagnosisSearchDefinitionUid] [uniqueidentifier] NOT NULL,
	[DpnGroupUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelProviderDiagnosisRangePlan'

ALTER TABLE [RelProviderDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelProviderDiagnosisRangePlan_RelProviderDiagnosisRangePlanUid]  DEFAULT (newid()) FOR [RelProviderDiagnosisRangePlanUid]
ALTER TABLE [RelProviderDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelProviderDiagnosisRangePlan_DisplayOrder]  DEFAULT ((1)) FOR [DisplayOrder]
ALTER TABLE [RelProviderDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelProviderDiagnosisRangePlan_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [RelProviderDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelProviderDiagnosisRangePlan_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [RelProviderDiagnosisRangePlan] ADD  CONSTRAINT [DF_RelProviderDiagnosisRangePlan_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelQuestionAnswerSnomed', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelQuestionAnswerSnomed'
GO
BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelReimbursementRuleDiagnosis]') AND name = 'DiagnosisUid')
ALTER TABLE [RelReimbursementRuleDiagnosis] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelRosSystemSymptom]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelRosSystemSymptom](
	[RelRosSystemSymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_RelRosSystemSymptomUid]  DEFAULT (newid()),
	[RosSystemUid] [uniqueidentifier] NOT NULL,
	[RosSymptomUid] [uniqueidentifier] NOT NULL,
	[DenyFlag] [bit] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_DisplayOrder]  DEFAULT ((0)),
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_Inactive]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverrideRos]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverrideRos]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelRosSystemSymptom_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ros system id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom', @level2type=N'COLUMN',@level2name=N'RosSystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ros symptom id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom', @level2type=N'COLUMN',@level2name=N'RosSymptomUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'To indicate if this item is for ROS deny list. For v44, this is 
from kdb_dict_normal. In V50, we merge into the same table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom', @level2type=N'COLUMN',@level2name=N'DenyFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Ros System Symptom mapping' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelRosSystemSymptom'


END
Truncate Table migtemp_RelRosSystemSymptom
INSERT [migtemp_RelRosSystemSymptom]([RelRosSystemSymptomUid],[RosSystemUid],[RosSymptomUid],[DenyFlag],[DisplayOrder],[AgeGroupUid],[UserDefined],[Inactive],[ClinicCenterOverride],[ProviderOverride],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelRosSystemSymptomUid],[RosSystemUid],[RosSymptomUid],[DenyFlag],[DisplayOrder],[AgeGroupUid],[UserDefined],[Inactive],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LastModifiedByUid],[LastModifiedDate]
FROM [RelRosSystemSymptom]

DROP TABLE [RelRosSystemSymptom]

exec  sp_rename 'migtemp_RelRosSystemSymptom', 'RelRosSystemSymptom'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelServiceSitePersonWeb]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelServiceSitePersonWeb](
	[RelServiceSitePersonWebUid] [uniqueidentifier] NOT NULL,
	[ServiceSiteUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[Inactive] [smallint] NOT NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'

ALTER TABLE [RelServiceSitePersonWeb] ADD  CONSTRAINT [DF_RelServiceSitePersonWeb_Inactive]  DEFAULT ((0)) FOR [Inactive]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelVisitMedication]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelVisitMedication](
	[RelVisitMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[eRxStatusUid] [uniqueidentifier] NULL,
	[eRxEligibilityDownLoadDate] [datetime] NULL,
	[ReadyToPrescribe] [bit] NOT NULL,
	[Prescribed] [bit] NOT NULL,
	[ConsentCreated] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ReprintReason] [varchar](max) NULL,
	[eRxRequest] [xml](CONTENT [dbo].[eRxRequestXML]) NULL,
	[PreviousData] [xml](CONTENT [dbo].[PreviousData]) NULL,
	[DigitalSignatureXML] [xml] NULL,
	[FormularyXML] [xml](CONTENT [dbo].[FormularyData]) NULL,
	[FulfillmentMethod] [smallint] NOT NULL,
	[FulfillmentDateTime] [datetime] NULL,
	[FulfillmentSequentialNumber] [int] NULL,
	[ScriptSave] [bit] NULL,
	[ePAStatus] [smallint] NOT NULL,
	[ePAMessageID] [varchar](50) NULL,
	[ePAResults] [varchar](max) NULL,
	[SpoStatus] [smallint] NOT NULL,
	[SpoRequest] [varchar](max) NULL,
	[SpoResponse] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'ePAStatus', @value=N'<None value ="0"/><Ready value="1"/><Sent value="2"/><Error value="3"/><Acknowledged value="4"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'FulfillmentMethod', @value=N'<None value="0" /><ePrescribe value="1" /><Fax value="2" /><Print value="3" /><SampleGiven value="4" /><Administered value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_RelVisitMedication_Visit' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'SpoStatus', @value=N'<None value ="0"/><Ready value="1"/><Sent value="2"/><Error value="3"/><Acknowledged value="4"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'

ALTER TABLE [migtemp_RelVisitMedication] ADD  CONSTRAINT [DF_RelVisitMedication_RelVisitMedicationUid]  DEFAULT (newid()) FOR [RelVisitMedicationUid]
ALTER TABLE [migtemp_RelVisitMedication] ADD  CONSTRAINT [DF_RelVisitMedication_ReadyToPrescribe]  DEFAULT ((0)) FOR [ReadyToPrescribe]
ALTER TABLE [migtemp_RelVisitMedication] ADD  CONSTRAINT [DF_RelVisitMedication_MarkAsPrescribed]  DEFAULT ((0)) FOR [Prescribed]
ALTER TABLE [migtemp_RelVisitMedication] ADD  CONSTRAINT [DF_RelVisitMedication_ConsentCreated]  DEFAULT ((0)) FOR [ConsentCreated]
ALTER TABLE [migtemp_RelVisitMedication] ADD  CONSTRAINT [DF_RelVisitMedication_FulfillmentMethod]  DEFAULT ((0)) FOR [FulfillmentMethod]
ALTER TABLE [migtemp_RelVisitMedication] ADD  CONSTRAINT [DF_RelVisitMedication_ScriptSave]  DEFAULT ((0)) FOR [ScriptSave]
ALTER TABLE [migtemp_RelVisitMedication] ADD  CONSTRAINT [DF_RelVisitMedication_ePASentRequest]  DEFAULT ((0)) FOR [ePAStatus]
ALTER TABLE [migtemp_RelVisitMedication] ADD  CONSTRAINT [DF_RelVisitMedication_SpoStatus]  DEFAULT ((0)) FOR [SpoStatus]
ALTER TABLE [migtemp_RelVisitMedication] ADD  CONSTRAINT [DF_RelVisitMedication_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelVisitMedication
INSERT [migtemp_RelVisitMedication]([RelVisitMedicationUid],[MedicationSIGUid],[VisitUid],[VisitProcedureUid],[eRxStatusUid],[eRxEligibilityDownLoadDate],[ReadyToPrescribe],[Prescribed],[ConsentCreated],[Notes],[ReprintReason],[eRxRequest],[PreviousData],[DigitalSignatureXML],[FormularyXML],[FulfillmentMethod],[FulfillmentDateTime],[FulfillmentSequentialNumber],[ScriptSave],[ePAStatus],[ePAMessageID],[ePAResults],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelVisitMedicationUid],[MedicationSIGUid],[VisitUid],[VisitProcedureUid],[eRxStatusUid],[eRxEligibilityDownLoadDate],[ReadyToPrescribe],[Prescribed],[ConsentCreated],[Notes],[ReprintReason],CONVERT(nvarchar(max), [eRxRequest]),CONVERT(nvarchar(max), [PreviousData]),CONVERT(nvarchar(max), [DigitalSignatureXML]),CONVERT(nvarchar(max), [FormularyXML]),[FulfillmentMethod],[FulfillmentDateTime],[FulfillmentSequentialNumber],[ScriptSave],[ePAStatus],[ePAMessageID],[ePAResults],[LastModifiedByUid],[LastModifiedDate]
FROM [RelVisitMedication]

DROP TABLE [RelVisitMedication]

exec  sp_rename 'migtemp_RelVisitMedication', 'RelVisitMedication'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelVisitSuperbillGeneration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelVisitSuperbillGeneration](
	[VisitSuperbillGenerationUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[SuperbillStatusMap] [varchar](2000) NULL,
	[GenerationStatus] [smallint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'GenerationStatus', @value=N'<Success value="0" /><FailedSingle value="1" /><FailedMultiple value="2" /><InProgress value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitSuperbillGeneration'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitSuperbillGeneration'

ALTER TABLE [migtemp_RelVisitSuperbillGeneration] ADD  CONSTRAINT [DF_RelVisitSuperbillGeneration_VisitSuperbillGenerationUid]  DEFAULT (newid()) FOR [VisitSuperbillGenerationUid]
ALTER TABLE [migtemp_RelVisitSuperbillGeneration] ADD  CONSTRAINT [DF_RelVisitSuperbillGeneration_GenerationStatus]  DEFAULT ((0)) FOR [GenerationStatus]
ALTER TABLE [migtemp_RelVisitSuperbillGeneration] ADD  CONSTRAINT [DF_RelVisitSuperbillGeneration_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelVisitSuperbillGeneration
INSERT [migtemp_RelVisitSuperbillGeneration]([VisitSuperbillGenerationUid],[VisitUid],[GenerationStatus],[LastModifiedDate],[LastModifiedByUid])
SELECT [VisitSuperbillGenerationUid],[VisitUid],[GenerationStatus],[LastModifiedDate],[LastModifiedByUid]
FROM [RelVisitSuperbillGeneration]

DROP TABLE [RelVisitSuperbillGeneration]

exec  sp_rename 'migtemp_RelVisitSuperbillGeneration', 'RelVisitSuperbillGeneration'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ToAvoid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', N'COLUMN',N'FinancialCenterUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch', @level2type=N'COLUMN',@level2name=N'FinancialCenterUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Statement batches in which many statements are generated during a statement run.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_StatementBatchDetail_StatementBatch' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatch', N'COLUMN',N'FinancialCenterUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatch', @level2type=N'COLUMN',@level2name=N'FinancialCenterUid'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_StatementBatchDetail]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_StatementBatchDetail](
	[StatementBatchDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[StatementBatchUid] [uniqueidentifier] NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[DunningLevel] [smallint] NOT NULL,
	[AccessCode] [varchar](25) NULL,
	[StatementXml] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[AttachmentUid] [uniqueidentifier] NULL,
	[StatementDate] [date] NULL,
	[CompletionStatus] [smallint] NOT NULL,
	[OnDemand] [smallint] NOT NULL,
	[FirstViewed] [datetime] NULL,
	[LastViewed] [datetime] NULL,
	[StatementXmlDate] [date] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'CompletionStatus', @value=N'<None value="0" /><Printed value="1" /><PortalOnly value="2" /><Etactics value="3" /><PracticeInsight value="4" /><Excluded value="99" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_StatementBatchDetail'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Individual responsible-party statements in a statement batch' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_StatementBatchDetail'
EXEC sys.sp_addextendedproperty @name=N'OnDemand', @value=N'<None value="0" /><All value="1" /><MainAccountOnly value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_StatementBatchDetail'
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_StatementBatchDetail'

ALTER TABLE [migtemp_StatementBatchDetail] ADD  CONSTRAINT [DF_StatementBatchDetail_StatementBatchDetailUid]  DEFAULT (newid()) FOR [StatementBatchDetailUid]
ALTER TABLE [migtemp_StatementBatchDetail] ADD  CONSTRAINT [DF_StatementBatchDetail_DunningLevel]  DEFAULT ((0)) FOR [DunningLevel]
ALTER TABLE [migtemp_StatementBatchDetail] ADD  CONSTRAINT [DF_StatementBatchDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_StatementBatchDetail] ADD  CONSTRAINT [DF_StatementBatchDetail_CompletionStatus]  DEFAULT ((0)) FOR [CompletionStatus]
ALTER TABLE [migtemp_StatementBatchDetail] ADD  CONSTRAINT [DF_StatementBatchDetail_OnDemand]  DEFAULT ((0)) FOR [OnDemand]

END
Truncate Table migtemp_StatementBatchDetail
INSERT [migtemp_StatementBatchDetail]([StatementBatchDetailUid],[StatementBatchUid],[AccountResponsiblePartyUid],[DunningLevel],[StatementXml],[LastModifiedDate],[LastModifiedByUid],[FinancialCenterUid])
SELECT [StatementBatchDetailUid],[StatementBatchUid],[AccountResponsiblePartyUid],[DunningLevel],[StatementXml],[LastModifiedDate],[LastModifiedByUid],[FinancialCenterUid]
FROM [StatementBatchDetail]

DROP TABLE [StatementBatchDetail]

exec  sp_rename 'migtemp_StatementBatchDetail', 'StatementBatchDetail'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetailSuperbill', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ToAvoid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetailSuperbill'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetailSuperbill', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetailSuperbill'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetailSuperbill', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetailSuperbill'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_SubFindTable]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_SubFindTable](
	[SubFindTableUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SubFindTable_SubFindTableUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_SubFindTable_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[FindTableUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_SubFindTable_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SubFindTable_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_SubFindTable'


END
Truncate Table migtemp_SubFindTable
INSERT [migtemp_SubFindTable]([SubFindTableUid],[ExternalID],[Inactive],[Name],[FindTableUid],[Notes],[LastModifiedByUid],[LastModifiedDate])
SELECT [SubFindTableUid],[ExternalID],[Inactive],[Name],[FindTableUid],[Notes],[LastModifiedByUid],[LastModifiedDate]
FROM [SubFindTable]

DROP TABLE [SubFindTable]

exec  sp_rename 'migtemp_SubFindTable', 'SubFindTable'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_SubFindTableItem]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_SubFindTableItem](
	[SubFindTableItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_SubFindTableItem_SubFindTableItemUid]  DEFAULT (newid()),
	[SubFindTableUid] [uniqueidentifier] NOT NULL,
	[ItemUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_SubFindTableItem_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_SubFindTableItem_LastModifiedDate]  DEFAULT (getutcdate()),
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_SubFindTableItem_DisplayOrder]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_SubFindTableItem'


END
Truncate Table migtemp_SubFindTableItem
INSERT [migtemp_SubFindTableItem]([SubFindTableItemUid],[SubFindTableUid],[ItemUid],[Name],[LastModifiedByUid],[LastModifiedDate],[DisplayOrder])
SELECT [SubFindTableItemUid],[SubFindTableUid],[ItemUid],[Name],[LastModifiedByUid],[LastModifiedDate],[DisplayOrder]
FROM [SubFindTableItem]

DROP TABLE [SubFindTableItem]

exec  sp_rename 'migtemp_SubFindTableItem', 'SubFindTableItem'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[SuperbillDiagnosis]') AND name = 'DiagnosisUid')
ALTER TABLE [SuperbillDiagnosis] DROP COLUMN [DiagnosisUid] 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[SuperbillUB]') AND name = 'AdmittingDiagnosisUid')
ALTER TABLE [SuperbillUB] DROP COLUMN [AdmittingDiagnosisUid] 
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[SuperbillUB]') AND name = 'ExternalInjuryUid')
ALTER TABLE [SuperbillUB] DROP COLUMN [ExternalInjuryUid] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Translation]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[Translation](
	[TranslationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_Translation_TranslationUid]  DEFAULT (newsequentialid()),
	[TableName] [varchar](100) NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[Spanish] [varchar](255) NULL,
	[Verified] [bit] NOT NULL CONSTRAINT [DF_Translation_Verified]  DEFAULT ((0)),
	[AutoTranslationError] [bit] NOT NULL CONSTRAINT [DF_Translation_AutoTranslationError]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_Translation_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Translation_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Translation'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Translation'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_TransmissionConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_TransmissionConfiguration](
	[TransmissionConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_TransmissionConfigurationUid]  DEFAULT (newid()),
	[TransmissionType] [varchar](50) NOT NULL,
	[CorepointClientID] [varchar](100) NULL,
	[CorepointMachineID] [varchar](100) NULL,
	[CorepointInboundConnectionID] [varchar](100) NULL,
	[CorepointOutboundConnectionID] [varchar](100) NULL,
	[CorepointUsername] [varchar](100) NULL,
	[CorepointPassword] [varchar](100) NULL,
	[AdditionalOutboundXML] [varchar](max) NULL,
	[AprimaVaultURL] [varchar](512) NULL,
	[AprimaVaultSubmissionURL] [varchar](512) NULL,
	[OverrideAprimaVaultURL] [varchar](512) NULL,
	[AprimaVaultSyncURL] [varchar](512) NULL,
	[RegistrationURL] [varchar](512) NULL,
	[TestMode] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_TestMode]  DEFAULT ((0)),
	[TestAprimaVaultURL] [varchar](512) NULL,
	[TestAprimaVaultSubmissionURL] [varchar](512) NULL,
	[TestOverrideAprimaVaultURL] [varchar](512) NULL,
	[TestAprimaVaultSyncURL] [varchar](512) NULL,
	[TestRegistrationURL] [varchar](512) NULL,
	[AutoSend] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoSend]  DEFAULT ((1)),
	[AutoDownload] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoDownload]  DEFAULT ((1)),
	[AutoProcessDownloads] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoProcessDownloads]  DEFAULT ((1)),
	[AutoQueue] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoQueue]  DEFAULT ((0)),
	[MaxSendAttempts] [int] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_MaxSendAttempts]  DEFAULT ((8)),
	[CorepointDataExportGeneratorAQN] [varchar](512) NULL,
	[CorepointSenderAQN] [varchar](512) NULL,
	[CorepointDownloaderAQN] [varchar](512) NULL,
	[CorepointDownloadProcessorAQN] [varchar](512) NULL,
	[OutboundQueueGeneratorAQN] [varchar](512) NULL,
	[ExportXMLLayout] [varchar](max) NULL,
	[ExportBusinessObjectName] [varchar](250) NULL,
	[ExportKeyLookupFieldName] [varchar](250) NULL,
	[Description] [varchar](512) NULL,
	[AutoQueueIntervalSeconds] [int] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoQueueIntervalSeconds]  DEFAULT ((0)),
	[AutoQueueLastRun] [datetime] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_AutoQueueLastRun]  DEFAULT (getutcdate()),
	[ForeignObjectUid] [uniqueidentifier] NULL,
	[ClaimClearingHouseUid] [uniqueidentifier] NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[TransmissionAQN] [varchar](1024) NULL,
	[AdditionalConfigurationXML] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageDisplayAQN] [varchar](500) NULL,
	[MessageParserAQN] [varchar](500) NULL,
	[MessageUpdatesAQN] [varchar](500) NULL,
	[UpdateableConfiguration] [varchar](max) NULL,
	[HighlightConfiguration] [varchar](max) NULL,
	[LegacyCreationDate] [datetime] NULL,
	[OriginalTransmissionConfigurationUid] [uniqueidentifier] NULL,
	[IdentityVerificationRequired] [bit] NOT NULL CONSTRAINT [DF_TransmissionConfiguration_IdentityVerificationRequired]  DEFAULT ((0)),
	[ActionType] [varchar](500) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionConfiguration'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionConfiguration'


END
Truncate Table migtemp_TransmissionConfiguration
INSERT [migtemp_TransmissionConfiguration]([TransmissionConfigurationUid],[TransmissionType],[CorepointClientID],[CorepointMachineID],[CorepointInboundConnectionID],[CorepointOutboundConnectionID],[CorepointUsername],[CorepointPassword],[AdditionalOutboundXML],[AprimaVaultURL],[AprimaVaultSubmissionURL],[OverrideAprimaVaultURL],[AprimaVaultSyncURL],[RegistrationURL],[TestMode],[TestAprimaVaultURL],[TestAprimaVaultSubmissionURL],[TestOverrideAprimaVaultURL],[TestAprimaVaultSyncURL],[TestRegistrationURL],[AutoSend],[AutoDownload],[AutoProcessDownloads],[AutoQueue],[MaxSendAttempts],[CorepointDataExportGeneratorAQN],[CorepointSenderAQN],[CorepointDownloaderAQN],[CorepointDownloadProcessorAQN],[OutboundQueueGeneratorAQN],[ExportXMLLayout],[ExportBusinessObjectName],[ExportKeyLookupFieldName],[Description],[AutoQueueIntervalSeconds],[AutoQueueLastRun],[ForeignObjectUid],[ClaimClearingHouseUid],[IntegrationPartnerUid],[TransmissionAQN],[AdditionalConfigurationXML],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MessageDisplayAQN],[MessageParserAQN],[MessageUpdatesAQN],[UpdateableConfiguration],[HighlightConfiguration],[LegacyCreationDate],[OriginalTransmissionConfigurationUid],[IdentityVerificationRequired])
SELECT [TransmissionConfigurationUid],[TransmissionType],[CorepointClientID],[CorepointMachineID],[CorepointInboundConnectionID],[CorepointOutboundConnectionID],[CorepointUsername],[CorepointPassword],[AdditionalOutboundXML],[AprimaVaultURL],[AprimaVaultSubmissionURL],[OverrideAprimaVaultURL],[AprimaVaultSyncURL],[RegistrationURL],[TestMode],[TestAprimaVaultURL],[TestAprimaVaultSubmissionURL],[TestOverrideAprimaVaultURL],[TestAprimaVaultSyncURL],[TestRegistrationURL],[AutoSend],[AutoDownload],[AutoProcessDownloads],[AutoQueue],[MaxSendAttempts],[CorepointDataExportGeneratorAQN],[CorepointSenderAQN],[CorepointDownloaderAQN],[CorepointDownloadProcessorAQN],[OutboundQueueGeneratorAQN],[ExportXMLLayout],[ExportBusinessObjectName],[ExportKeyLookupFieldName],[Description],[AutoQueueIntervalSeconds],[AutoQueueLastRun],[ForeignObjectUid],[ClaimClearingHouseUid],[IntegrationPartnerUid],[TransmissionAQN],[AdditionalConfigurationXML],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MessageDisplayAQN],[MessageParserAQN],[MessageUpdatesAQN],[UpdateableConfiguration],[HighlightConfiguration],[LegacyCreationDate],[OriginalTransmissionConfigurationUid],[IdentityVerificationRequired]
FROM [TransmissionConfiguration]

DROP TABLE [TransmissionConfiguration]

exec  sp_rename 'migtemp_TransmissionConfiguration', 'TransmissionConfiguration'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_TransmissionOutbound]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_TransmissionOutbound](
	[TransmissionOutboundUid] [uniqueidentifier] NOT NULL,
	[TransmissionType] [varchar](50) NOT NULL,
	[Status] [smallint] NOT NULL,
	[Description] [varchar](1000) NULL,
	[RawMessage] [varchar](max) NULL,
	[TransmissionControlXML] [xml] NULL,
	[ForeignObjectUid] [uniqueidentifier] NULL,
	[EnqueuedTimestamp] [datetime] NOT NULL,
	[NextSendAttempt] [datetime] NOT NULL,
	[LastTransmissionAttempt] [datetime] NULL,
	[NumberOfTransmissionAttempts] [int] NOT NULL,
	[SuccessfulTransmissionTimestamp] [datetime] NULL,
	[LastError] [varchar](max) NULL,
	[IntermediateGenerationData] [varchar](max) NULL,
	[StatusHistory] [varchar](max) NULL,
	[ExternalStatus] [varchar](1000) NULL,
	[ExternalStatusDescription] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionOutbound'
EXEC sys.sp_addextendedproperty @name=N'Replication.Sequence', @value=N'8410' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionOutbound'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionOutbound'
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<Unprocessed value="0" /> <ReadyToTransmit value="25" /> <TransmissionFailed value="35" /> <Transmitted value="50" /> <Successful value="100" />  <Failed value="500" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_TransmissionOutbound'

ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_TransmissionOutbound_TransmissionOutboundUid]  DEFAULT (newid()) FOR [TransmissionOutboundUid]
ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_TransmissionOutbound_Status]  DEFAULT ((0)) FOR [Status]
ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_Table_1_InitialQueueTimestamp]  DEFAULT (getutcdate()) FOR [EnqueuedTimestamp]
ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_TransmissionOutbound_NextSendAttempt]  DEFAULT (getutcdate()) FOR [NextSendAttempt]
ALTER TABLE [migtemp_TransmissionOutbound] ADD  CONSTRAINT [DF_TransmissionOutbound_NumberOfTransmissionAttempts]  DEFAULT ((0)) FOR [NumberOfTransmissionAttempts]

END
Truncate Table migtemp_TransmissionOutbound
INSERT [migtemp_TransmissionOutbound]([TransmissionOutboundUid],[TransmissionType],[Status],[Description],[RawMessage],[TransmissionControlXML],[ForeignObjectUid],[EnqueuedTimestamp],[NextSendAttempt],[LastTransmissionAttempt],[NumberOfTransmissionAttempts],[SuccessfulTransmissionTimestamp],[LastError],[IntermediateGenerationData],[StatusHistory],[ExternalStatus],[ExternalStatusDescription],[LastModifiedDate],[LastModifiedByUid])
SELECT [TransmissionOutboundUid],[TransmissionType],[Status],[Description],[RawMessage],CONVERT(nvarchar(max), [TransmissionControlXML]),[ForeignObjectUid],[EnqueuedTimestamp],[NextSendAttempt],[LastTransmissionAttempt],[NumberOfTransmissionAttempts],[SuccessfulTransmissionTimestamp],[LastError],[IntermediateGenerationData],[StatusHistory],[ExternalStatus],[ExternalStatusDescription],[LastModifiedDate],[LastModifiedByUid]
FROM [TransmissionOutbound]

DROP TABLE [TransmissionOutbound]

exec  sp_rename 'migtemp_TransmissionOutbound', 'TransmissionOutbound'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_UB04Claim]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_UB04Claim](
	[UB04ClaimUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[SuperBillUId] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[ProviderUId] [uniqueidentifier] NULL,
	[FileAsGroup] [bit] NULL,
	[SendNPI] [bit] NULL,
	[ProviderName_FL1] [varchar](200) NULL,
	[ProviderAddress1_FL1] [varchar](200) NULL,
	[ProviderAddress2_FL1] [varchar](200) NULL,
	[ProviderCity_FL1] [varchar](25) NULL,
	[ProviderState_FL1] [varchar](3) NULL,
	[ProviderZip_FL1] [varchar](10) NULL,
	[ProviderPhone_FL1] [varchar](22) NULL,
	[PatientControlNumber_FL3a] [varchar](25) NULL,
	[MedicalRecordNumber_FL3b] [varchar](25) NULL,
	[TypeOfBill_FL4] [varchar](5) NULL,
	[FederalTaxID_FL5] [varchar](25) NULL,
	[StatementCoversPeriod_FL6From] [varchar](10) NULL,
	[StatementCoversPeriod_FL6To] [varchar](10) NULL,
	[PatientName_FL8b] [varchar](200) NULL,
	[PatientAddressStreet_FL9a] [varchar](200) NULL,
	[PatientAddressCity_FL9b] [varchar](25) NULL,
	[PatientAddressState_FL9c] [varchar](3) NULL,
	[PatientAddressZip_FL9d] [varchar](10) NULL,
	[PatientBirthDate_FL10] [varchar](10) NULL,
	[PatientSex_FL11] [varchar](1) NULL,
	[AdmissionDate_FL12] [varchar](10) NULL,
	[AdmissionHour_FL13] [varchar](10) NULL,
	[AdmissionType_FL14] [varchar](10) NULL,
	[AdmissionSource_FL15] [varchar](10) NULL,
	[DischargeHour_FL16] [varchar](10) NULL,
	[PatientDischargeStatus_FL17] [varchar](10) NULL,
	[ConditionCode_FL18] [varchar](10) NULL,
	[ConditionCode_FL19] [varchar](10) NULL,
	[ConditionCode_FL20] [varchar](10) NULL,
	[ConditionCode_FL21] [varchar](10) NULL,
	[ConditionCode_FL22] [varchar](10) NULL,
	[ConditionCode_FL23] [varchar](10) NULL,
	[ConditionCode_FL24] [varchar](10) NULL,
	[ConditionCode_FL25] [varchar](10) NULL,
	[ConditionCode_FL26] [varchar](10) NULL,
	[ConditionCode_FL27] [varchar](10) NULL,
	[ConditionCode_FL28] [varchar](10) NULL,
	[AccidentState_FL29] [varchar](3) NULL,
	[OccurrenceCode_FL31] [varchar](10) NULL,
	[OccurrenceDate_FL31] [varchar](10) NULL,
	[OccurrenceCode_FL32] [varchar](10) NULL,
	[OccurrenceDate_FL32] [varchar](10) NULL,
	[OccurrenceCode_FL33] [varchar](10) NULL,
	[OccurrenceDate_FL33] [varchar](10) NULL,
	[OccurrenceCode_FL34] [varchar](10) NULL,
	[OccurrenceDate_FL34] [varchar](10) NULL,
	[OccurrenceCode_FL31b] [varchar](10) NULL,
	[OccurrenceDate_FL31b] [varchar](10) NULL,
	[OccurrenceCode_FL32b] [varchar](10) NULL,
	[OccurrenceDate_FL32b] [varchar](10) NULL,
	[OccurrenceCode_FL33b] [varchar](10) NULL,
	[OccurrenceDate_FL33b] [varchar](10) NULL,
	[OccurrenceCode_FL34b] [varchar](10) NULL,
	[OccurrenceDate_FL34b] [varchar](10) NULL,
	[OccurrenceSpanCode_FL35] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL35] [varchar](10) NULL,
	[OccurrenceSpanTo_FL35] [varchar](10) NULL,
	[OccurrenceSpanCode_FL36] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL36] [varchar](10) NULL,
	[OccurrenceSpanTo_FL36] [varchar](10) NULL,
	[OccurrenceSpanCode_FL35b] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL35b] [varchar](10) NULL,
	[OccurrenceSpanTo_FL35b] [varchar](10) NULL,
	[OccurrenceSpanCode_FL36b] [varchar](10) NULL,
	[OccurrenceSpanFrom_FL36b] [varchar](10) NULL,
	[OccurrenceSpanTo_FL36b] [varchar](10) NULL,
	[ResponsiblePartyName_IsCorporation] [bit] NULL,
	[ResponsiblePartyName_FL38] [varchar](200) NULL,
	[ResponsiblePartyAddress1_FL38] [varchar](200) NULL,
	[ResponsiblePartyAddress2_FL38] [varchar](200) NULL,
	[ResponsiblePartyCity_FL38] [varchar](25) NULL,
	[ResponsiblePartyState_FL38] [varchar](3) NULL,
	[ResponsiblePartyZip_FL38] [varchar](10) NULL,
	[ValueCode_FL39a] [varchar](10) NULL,
	[ValueCodeAmount_FL39a] [money] NULL,
	[ValueCode_FL39b] [varchar](10) NULL,
	[ValueCodeAmount_FL39b] [money] NULL,
	[ValueCode_FL39c] [varchar](10) NULL,
	[ValueCodeAmount_FL39c] [money] NULL,
	[ValueCode_FL39d] [varchar](10) NULL,
	[ValueCodeAmount_FL39d] [money] NULL,
	[ValueCode_FL40a] [varchar](10) NULL,
	[ValueCodeAmount_FL40a] [money] NULL,
	[ValueCode_FL40b] [varchar](10) NULL,
	[ValueCodeAmount_FL40b] [money] NULL,
	[ValueCode_FL40c] [varchar](10) NULL,
	[ValueCodeAmount_FL40c] [money] NULL,
	[ValueCode_FL40d] [varchar](10) NULL,
	[ValueCodeAmount_FL40d] [money] NULL,
	[ValueCode_FL41a] [varchar](10) NULL,
	[ValueCodeAmount_FL41a] [money] NULL,
	[ValueCode_FL41b] [varchar](10) NULL,
	[ValueCodeAmount_FL41b] [money] NULL,
	[ValueCode_FL41c] [varchar](10) NULL,
	[ValueCodeAmount_FL41c] [money] NULL,
	[ValueCode_FL41d] [varchar](10) NULL,
	[ValueCodeAmount_FL41d] [money] NULL,
	[PrimaryPayerName_FL50a] [varchar](200) NULL,
	[PrimaryPayerPlanType_FL50a] [varchar](25) NULL,
	[PrimaryPayerPlanName_FL50a] [varchar](200) NULL,
	[SecondaryPayerName_FL50b] [varchar](200) NULL,
	[SecondaryPayerPlanType_FL50b] [varchar](25) NULL,
	[SecondaryPayerPlanName_FL50b] [varchar](200) NULL,
	[TertiaryPayerName_FL50c] [varchar](200) NULL,
	[TertiaryPayerPlanType_FL50c] [varchar](25) NULL,
	[TertiaryPayerPlanName_FL50c] [varchar](200) NULL,
	[PrimaryHealthPlanIDType_FL51a] [varchar](10) NULL,
	[SecondaryHealthPlanIDType_FL51b] [varchar](10) NULL,
	[TertiaryHealthPlanIDType_FL51c] [varchar](10) NULL,
	[PrimaryHealthPlanID_FL51a] [varchar](50) NULL,
	[SecondaryHealthPlanID_FL51b] [varchar](50) NULL,
	[TertiaryHealthPlanID_FL51c] [varchar](50) NULL,
	[PrimaryPatReleaseInfo_FL52a] [varchar](1) NULL,
	[SecondaryPatReleaseInfo_FL52b] [varchar](1) NULL,
	[TertiaryPatReleaseInfo_FL52c] [varchar](1) NULL,
	[PrimaryAssignBenefits_FL53a] [varchar](1) NULL,
	[SecondaryAssignBenefits_FL53b] [varchar](1) NULL,
	[TertiaryAssignBenefits_FL53c] [varchar](1) NULL,
	[PrimaryPriorPmts_FL54a] [money] NULL,
	[SecondaryPriorPmts_FL54b] [money] NULL,
	[TertiaryPriorPmts_FL54c] [money] NULL,
	[PrimaryEstAmtDue_FL55a] [money] NULL,
	[SecondaryEstAmtDue_FL55b] [money] NULL,
	[TertiaryEstAmtDue_FL55c] [money] NULL,
	[BillingProviderNPI_FL56] [varchar](50) NULL,
	[ID_FL57] [varchar](50) NULL,
	[OtherID_FL57] [varchar](50) NULL,
	[ProviderID_FL57] [varchar](50) NULL,
	[PrimaryInsuredName_FL58a] [varchar](200) NULL,
	[SecondaryInsuredName_FL58b] [varchar](200) NULL,
	[TertiaryInsuredName_FL58c] [varchar](200) NULL,
	[PrimaryPatRelationship_FL59a] [varchar](2) NULL,
	[SecondaryPatRelationship_FL59b] [varchar](2) NULL,
	[TertiaryPatRelationship_FL59c] [varchar](2) NULL,
	[PrimaryInsuredPlanID_FL60a] [varchar](50) NULL,
	[SecondaryInsuredPlanID_FL60b] [varchar](50) NULL,
	[TertiaryInsuredPlanID_FL60c] [varchar](50) NULL,
	[PrimaryPlanGroupName_FL61a] [varchar](200) NULL,
	[SecondaryPlanGroupName_FL61b] [varchar](200) NULL,
	[TertiaryPlanGroupName_FL61c] [varchar](200) NULL,
	[PrimaryPlanGroupID_FL62a] [varchar](50) NULL,
	[SecondaryPlanGroupID_FL62b] [varchar](50) NULL,
	[TertiaryPlanGroupID_FL62c] [varchar](50) NULL,
	[PrimaryTreatmentAuth_FL63a] [varchar](50) NULL,
	[SecondaryTreatmentAuth_FL63b] [varchar](50) NULL,
	[TertiaryTreatmentAuth_FL63c] [varchar](50) NULL,
	[DocControlNo_FL64a] [varchar](50) NULL,
	[DocControlNo_FL64b] [varchar](26) NULL,
	[DocControlNo_FL64c] [varchar](26) NULL,
	[PrimaryEmployerName_FL65a] [varchar](200) NULL,
	[SecondaryEmployerName_FL65b] [varchar](200) NULL,
	[TertiaryEmployerName_FL65c] [varchar](200) NULL,
	[DiagnosisVersion_FL66] [varchar](1) NULL,
	[Diagnosis_FL67] [varchar](25) NULL,
	[Diagnosis_FL67a] [varchar](25) NULL,
	[Diagnosis_FL67b] [varchar](25) NULL,
	[Diagnosis_FL67c] [varchar](25) NULL,
	[Diagnosis_FL67d] [varchar](25) NULL,
	[Diagnosis_FL67e] [varchar](25) NULL,
	[Diagnosis_FL67f] [varchar](25) NULL,
	[Diagnosis_FL67g] [varchar](25) NULL,
	[Diagnosis_FL67h] [varchar](25) NULL,
	[Diagnosis_FL67i] [varchar](25) NULL,
	[Diagnosis_FL67j] [varchar](25) NULL,
	[Diagnosis_FL67k] [varchar](25) NULL,
	[Diagnosis_FL67l] [varchar](25) NULL,
	[Diagnosis_FL67m] [varchar](25) NULL,
	[Diagnosis_FL67n] [varchar](25) NULL,
	[Diagnosis_FL67o] [varchar](25) NULL,
	[Diagnosis_FL67p] [varchar](25) NULL,
	[Diagnosis_FL67q] [varchar](25) NULL,
	[AdmittingDiagnosis_FL69] [varchar](25) NULL,
	[PatientVisitRsnDiagnosis_FL70a] [varchar](25) NULL,
	[PatientVisitRsnDiagnosis_FL70b] [varchar](25) NULL,
	[PatientVisitRsnDiagnosis_FL70c] [varchar](25) NULL,
	[PrincipalProcCode_FL74] [varchar](30) NULL,
	[PrincipalProcDate_FL74] [varchar](10) NULL,
	[OtherProcCode_FL74a] [varchar](30) NULL,
	[OtherProcDate_FL74a] [varchar](10) NULL,
	[OtherProcCode_FL74b] [varchar](30) NULL,
	[OtherProcDate_FL74b] [varchar](10) NULL,
	[OtherProcCode_FL74c] [varchar](30) NULL,
	[OtherProcDate_FL74c] [varchar](10) NULL,
	[OtherProcCode_FL74d] [varchar](30) NULL,
	[OtherProcDate_FL74d] [varchar](10) NULL,
	[OtherProcCode_FL74e] [varchar](30) NULL,
	[OtherProcDate_FL74e] [varchar](10) NULL,
	[AttendingNPI_ID_FL76] [varchar](50) NULL,
	[AttendingNPI_IDType_FL76] [varchar](10) NULL,
	[AttendingLastName_FL76] [varchar](50) NULL,
	[AttendingFirstName_FL76] [varchar](50) NULL,
	[OperatingNPI_ID_FL77] [varchar](50) NULL,
	[OperatingNPI_IDType_FL77] [varchar](10) NULL,
	[OperatingLastName_FL77] [varchar](50) NULL,
	[OperatingFirstName_FL77] [varchar](50) NULL,
	[OtherNPI_ID_FL78] [varchar](50) NULL,
	[OtherNPI_IDType_FL78] [varchar](10) NULL,
	[OtherLastName_FL78] [varchar](50) NULL,
	[OtherFirstName_FL78] [varchar](50) NULL,
	[OtherNPI_ID_FL79] [varchar](50) NULL,
	[OtherNPI_IDType_FL79] [varchar](10) NULL,
	[OtherLastName_FL79] [varchar](50) NULL,
	[OtherFirstName_FL79] [varchar](50) NULL,
	[Remarks_FL80] [varchar](800) NULL,
	[ClaimBatchUID] [uniqueidentifier] NULL,
	[TotalCharge] [money] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[Attending_ID_FL76] [varchar](10) NULL,
	[Other_ID_FL78] [varchar](10) NULL,
	[Other_IDType_FL78] [varchar](10) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A temporary table used to store UB04 Claim information before it is printed. If paper claim printing is in progress this table should be empty.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_UB04Claim'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_UB04Claim'

ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_UB04ClaimUid]  DEFAULT (newid()) FOR [UB04ClaimUid]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__FileAsGroup]  DEFAULT ((0)) FOR [FileAsGroup]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SendNPI]  DEFAULT ((0)) FOR [SendNPI]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderName_FL1]  DEFAULT ('') FOR [ProviderName_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderAddress1_FL1]  DEFAULT ('') FOR [ProviderAddress1_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderAddress2_FL1]  DEFAULT ('') FOR [ProviderAddress2_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderCity_FL1]  DEFAULT ('') FOR [ProviderCity_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderState_FL1]  DEFAULT ('') FOR [ProviderState_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderZip_FL1]  DEFAULT ('') FOR [ProviderZip_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderPhone_FL1]  DEFAULT ('') FOR [ProviderPhone_FL1]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientControlNumber_FL3a]  DEFAULT ('') FOR [PatientControlNumber_FL3a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__MedicalRecordNumber_FL3b]  DEFAULT ('') FOR [MedicalRecordNumber_FL3b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TypeOfBill_FL4]  DEFAULT ('') FOR [TypeOfBill_FL4]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__FederalTaxID_FL5]  DEFAULT ('') FOR [FederalTaxID_FL5]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__StatementCoversPeriod_FL6From]  DEFAULT ('') FOR [StatementCoversPeriod_FL6From]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__StatementCoversPeriod_FL6To]  DEFAULT ('') FOR [StatementCoversPeriod_FL6To]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientName_FL8b]  DEFAULT ('') FOR [PatientName_FL8b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientAddressStreet_FL9a]  DEFAULT ('') FOR [PatientAddressStreet_FL9a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientAddressCity_FL9b]  DEFAULT ('') FOR [PatientAddressCity_FL9b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientAddressState_FL9c]  DEFAULT ('') FOR [PatientAddressState_FL9c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientAddressZip_FL9d]  DEFAULT ('') FOR [PatientAddressZip_FL9d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientBirthDate_FL10]  DEFAULT ('') FOR [PatientBirthDate_FL10]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientSex_FL11]  DEFAULT ('') FOR [PatientSex_FL11]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AdmissionDate_FL12]  DEFAULT ('') FOR [AdmissionDate_FL12]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AdmissionHour_FL13]  DEFAULT ('') FOR [AdmissionHour_FL13]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AdmissionType_FL14]  DEFAULT ('') FOR [AdmissionType_FL14]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AdmissionSource_FL15]  DEFAULT ('') FOR [AdmissionSource_FL15]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DischargeHour_FL16]  DEFAULT ('') FOR [DischargeHour_FL16]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientDischargeStatus_FL17]  DEFAULT ('') FOR [PatientDischargeStatus_FL17]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL18]  DEFAULT ('') FOR [ConditionCode_FL18]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL19]  DEFAULT ('') FOR [ConditionCode_FL19]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL20]  DEFAULT ('') FOR [ConditionCode_FL20]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL21]  DEFAULT ('') FOR [ConditionCode_FL21]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL22]  DEFAULT ('') FOR [ConditionCode_FL22]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL23]  DEFAULT ('') FOR [ConditionCode_FL23]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL24]  DEFAULT ('') FOR [ConditionCode_FL24]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL25]  DEFAULT ('') FOR [ConditionCode_FL25]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL26]  DEFAULT ('') FOR [ConditionCode_FL26]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL27]  DEFAULT ('') FOR [ConditionCode_FL27]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ConditionCode_FL28]  DEFAULT ('') FOR [ConditionCode_FL28]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AccidentState_FL29]  DEFAULT ('') FOR [AccidentState_FL29]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceCode_FL31]  DEFAULT ('') FOR [OccurrenceCode_FL31]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceDate_FL31]  DEFAULT ('') FOR [OccurrenceDate_FL31]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceCode_FL32]  DEFAULT ('') FOR [OccurrenceCode_FL32]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceDate_FL32]  DEFAULT ('') FOR [OccurrenceDate_FL32]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceCode_FL33]  DEFAULT ('') FOR [OccurrenceCode_FL33]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceDate_FL33]  DEFAULT ('') FOR [OccurrenceDate_FL33]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceCode_FL34]  DEFAULT ('') FOR [OccurrenceCode_FL34]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceDate_FL34]  DEFAULT ('') FOR [OccurrenceDate_FL34]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceCode_FL311]  DEFAULT ('') FOR [OccurrenceCode_FL31b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceDate_FL311]  DEFAULT ('') FOR [OccurrenceDate_FL31b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceCode_FL321]  DEFAULT ('') FOR [OccurrenceCode_FL32b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceDate_FL321]  DEFAULT ('') FOR [OccurrenceDate_FL32b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceCode_FL331]  DEFAULT ('') FOR [OccurrenceCode_FL33b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceDate_FL331]  DEFAULT ('') FOR [OccurrenceDate_FL33b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceCode_FL341]  DEFAULT ('') FOR [OccurrenceCode_FL34b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceDate_FL341]  DEFAULT ('') FOR [OccurrenceDate_FL34b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanCode_FL35]  DEFAULT ('') FOR [OccurrenceSpanCode_FL35]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanFrom_FL35]  DEFAULT ('') FOR [OccurrenceSpanFrom_FL35]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanTo_FL35]  DEFAULT ('') FOR [OccurrenceSpanTo_FL35]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanCode_FL36]  DEFAULT ('') FOR [OccurrenceSpanCode_FL36]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanFrom_FL36]  DEFAULT ('') FOR [OccurrenceSpanFrom_FL36]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OccurrenceSpanTo_FL36]  DEFAULT ('') FOR [OccurrenceSpanTo_FL36]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanCode_FL351]  DEFAULT ('') FOR [OccurrenceSpanCode_FL35b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanFrom_FL351]  DEFAULT ('') FOR [OccurrenceSpanFrom_FL35b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanTo_FL351]  DEFAULT ('') FOR [OccurrenceSpanTo_FL35b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanCode_FL361]  DEFAULT ('') FOR [OccurrenceSpanCode_FL36b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanFrom_FL361]  DEFAULT ('') FOR [OccurrenceSpanFrom_FL36b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_OccurrenceSpanTo_FL361]  DEFAULT ('') FOR [OccurrenceSpanTo_FL36b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyName_IsCorporation]  DEFAULT ((0)) FOR [ResponsiblePartyName_IsCorporation]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyName_FL38]  DEFAULT ('') FOR [ResponsiblePartyName_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyAddress1_FL38]  DEFAULT ('') FOR [ResponsiblePartyAddress1_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyAddress2_FL38]  DEFAULT ('') FOR [ResponsiblePartyAddress2_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyCity_FL38]  DEFAULT ('') FOR [ResponsiblePartyCity_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyState_FL38]  DEFAULT ('') FOR [ResponsiblePartyState_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ResponsiblePartyZip_FL38]  DEFAULT ('') FOR [ResponsiblePartyZip_FL38]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL39a]  DEFAULT ('') FOR [ValueCode_FL39a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL39a]  DEFAULT ((0)) FOR [ValueCodeAmount_FL39a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL39b]  DEFAULT ('') FOR [ValueCode_FL39b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL39b]  DEFAULT ((0)) FOR [ValueCodeAmount_FL39b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL39c]  DEFAULT ('') FOR [ValueCode_FL39c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL39c]  DEFAULT ((0)) FOR [ValueCodeAmount_FL39c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL39d]  DEFAULT ('') FOR [ValueCode_FL39d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL39d]  DEFAULT ((0)) FOR [ValueCodeAmount_FL39d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL40a]  DEFAULT ('') FOR [ValueCode_FL40a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL40a]  DEFAULT ((0)) FOR [ValueCodeAmount_FL40a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL40b]  DEFAULT ('') FOR [ValueCode_FL40b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL40b]  DEFAULT ((0)) FOR [ValueCodeAmount_FL40b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL40c]  DEFAULT ('') FOR [ValueCode_FL40c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL40c]  DEFAULT ((0)) FOR [ValueCodeAmount_FL40c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL40d]  DEFAULT ('') FOR [ValueCode_FL40d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL40d]  DEFAULT ((0)) FOR [ValueCodeAmount_FL40d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL41a]  DEFAULT ('') FOR [ValueCode_FL41a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL41a]  DEFAULT ((0)) FOR [ValueCodeAmount_FL41a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL41b]  DEFAULT ('') FOR [ValueCode_FL41b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL41b]  DEFAULT ((0)) FOR [ValueCodeAmount_FL41b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL41c]  DEFAULT ('') FOR [ValueCode_FL41c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL41c]  DEFAULT ((0)) FOR [ValueCodeAmount_FL41c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCode_FL41d]  DEFAULT ('') FOR [ValueCode_FL41d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ValueCodeAmount_FL41d]  DEFAULT ((0)) FOR [ValueCodeAmount_FL41d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPayerName_FL50a]  DEFAULT ('') FOR [PrimaryPayerName_FL50a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPayerPlanType_FL50a]  DEFAULT ('') FOR [PrimaryPayerPlanType_FL50a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPayerPlanName_FL50a]  DEFAULT ('') FOR [PrimaryPayerPlanName_FL50a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPayerName_FL50b]  DEFAULT ('') FOR [SecondaryPayerName_FL50b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPayerPlanType_FL50b]  DEFAULT ('') FOR [SecondaryPayerPlanType_FL50b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPayerPlanName_FL50b]  DEFAULT ('') FOR [SecondaryPayerPlanName_FL50b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPayerName_FL50c]  DEFAULT ('') FOR [TertiaryPayerName_FL50c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPayerPlanType_FL50c]  DEFAULT ('') FOR [TertiaryPayerPlanType_FL50c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPayerPlanName_FL50c]  DEFAULT ('') FOR [TertiaryPayerPlanName_FL50c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryHealthPlanIDType_FL51a]  DEFAULT ('') FOR [PrimaryHealthPlanIDType_FL51a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryHealthPlanIDType_FL51b]  DEFAULT ('') FOR [SecondaryHealthPlanIDType_FL51b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryHealthPlanIDType_FL51c]  DEFAULT ('') FOR [TertiaryHealthPlanIDType_FL51c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryHealthPlanID_FL51a]  DEFAULT ('') FOR [PrimaryHealthPlanID_FL51a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryHealthPlanID_FL51b]  DEFAULT ('') FOR [SecondaryHealthPlanID_FL51b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryHealthPlanID_FL51c]  DEFAULT ('') FOR [TertiaryHealthPlanID_FL51c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPatReleaseInfo_FL52a]  DEFAULT ('Y') FOR [PrimaryPatReleaseInfo_FL52a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPatReleaseInfo_FL52b]  DEFAULT (' ') FOR [SecondaryPatReleaseInfo_FL52b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPatReleaseInfo_FL52c]  DEFAULT (' ') FOR [TertiaryPatReleaseInfo_FL52c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryAssignBenefits_FL53a]  DEFAULT (' ') FOR [PrimaryAssignBenefits_FL53a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryAssignBenefits_FL53b]  DEFAULT (' ') FOR [SecondaryAssignBenefits_FL53b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryAssignBenefits_FL53c]  DEFAULT (' ') FOR [TertiaryAssignBenefits_FL53c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPriorPmts_FL54a]  DEFAULT ((0)) FOR [PrimaryPriorPmts_FL54a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPriorPmts_FL54b]  DEFAULT ((0)) FOR [SecondaryPriorPmts_FL54b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPriorPmts_FL54c]  DEFAULT ((0)) FOR [TertiaryPriorPmts_FL54c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryEstAmtDue_FL55a]  DEFAULT ((0)) FOR [PrimaryEstAmtDue_FL55a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryEstAmtDue_FL55b]  DEFAULT ((0)) FOR [SecondaryEstAmtDue_FL55b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryEstAmtDue_FL55c]  DEFAULT ((0)) FOR [TertiaryEstAmtDue_FL55c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__BillingProviderNPI_FL56]  DEFAULT ('') FOR [BillingProviderNPI_FL56]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ID_FL57]  DEFAULT ('') FOR [ID_FL57]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherID_FL57]  DEFAULT ('') FOR [OtherID_FL57]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__ProviderID_FL57]  DEFAULT ('') FOR [ProviderID_FL57]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryInsuredName_FL58a]  DEFAULT ('') FOR [PrimaryInsuredName_FL58a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryInsuredName_FL58b]  DEFAULT ('') FOR [SecondaryInsuredName_FL58b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryInsuredName_FL58c]  DEFAULT ('') FOR [TertiaryInsuredName_FL58c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPatRelationship_FL59a]  DEFAULT ('') FOR [PrimaryPatRelationship_FL59a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPatRelationship_FL59b]  DEFAULT ('') FOR [SecondaryPatRelationship_FL59b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPatRelationship_FL59c]  DEFAULT ('') FOR [TertiaryPatRelationship_FL59c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryInsuredPlanID_FL60a]  DEFAULT ('') FOR [PrimaryInsuredPlanID_FL60a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryInsuredPlanID_FL60b]  DEFAULT ('') FOR [SecondaryInsuredPlanID_FL60b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryInsuredPlanID_FL60c]  DEFAULT ('') FOR [TertiaryInsuredPlanID_FL60c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPlanGroupName_FL61a]  DEFAULT ('') FOR [PrimaryPlanGroupName_FL61a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPlanGroupName_FL61b]  DEFAULT ('') FOR [SecondaryPlanGroupName_FL61b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPlanGroupName_FL61c]  DEFAULT ('') FOR [TertiaryPlanGroupName_FL61c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryPlanGroupID_FL62a]  DEFAULT ('') FOR [PrimaryPlanGroupID_FL62a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryPlanGroupID_FL62b]  DEFAULT ('') FOR [SecondaryPlanGroupID_FL62b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryPlanGroupID_FL62c]  DEFAULT ('') FOR [TertiaryPlanGroupID_FL62c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryTreatmentAuth_FL63a]  DEFAULT ('') FOR [PrimaryTreatmentAuth_FL63a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryTreatmentAuth_FL63b]  DEFAULT ('') FOR [SecondaryTreatmentAuth_FL63b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryTreatmentAuth_FL63c]  DEFAULT ('') FOR [TertiaryTreatmentAuth_FL63c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DocControlNo_FL64a]  DEFAULT ('') FOR [DocControlNo_FL64a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DocControlNo_FL64b]  DEFAULT ('') FOR [DocControlNo_FL64b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DocControlNo_FL64c]  DEFAULT ('') FOR [DocControlNo_FL64c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrimaryEmployerName_FL65a]  DEFAULT ('') FOR [PrimaryEmployerName_FL65a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__SecondaryEmployerName_FL65b]  DEFAULT ('') FOR [SecondaryEmployerName_FL65b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TertiaryEmployerName_FL65c]  DEFAULT ('') FOR [TertiaryEmployerName_FL65c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__DiagnosisVersion_FL66]  DEFAULT ('9') FOR [DiagnosisVersion_FL66]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67]  DEFAULT ('') FOR [Diagnosis_FL67]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67a]  DEFAULT ('') FOR [Diagnosis_FL67a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67b]  DEFAULT ('') FOR [Diagnosis_FL67b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67c]  DEFAULT ('') FOR [Diagnosis_FL67c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67d]  DEFAULT ('') FOR [Diagnosis_FL67d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67r]  DEFAULT ('') FOR [Diagnosis_FL67e]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67f]  DEFAULT ('') FOR [Diagnosis_FL67f]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67g]  DEFAULT ('') FOR [Diagnosis_FL67g]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67h]  DEFAULT ('') FOR [Diagnosis_FL67h]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67i]  DEFAULT ('') FOR [Diagnosis_FL67i]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67j]  DEFAULT ('') FOR [Diagnosis_FL67j]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67k]  DEFAULT ('') FOR [Diagnosis_FL67k]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67l]  DEFAULT ('') FOR [Diagnosis_FL67l]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67m]  DEFAULT ('') FOR [Diagnosis_FL67m]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67n]  DEFAULT ('') FOR [Diagnosis_FL67n]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67o]  DEFAULT ('') FOR [Diagnosis_FL67o]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67p]  DEFAULT ('') FOR [Diagnosis_FL67p]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL67q]  DEFAULT ('') FOR [Diagnosis_FL67q]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Diagnosis_FL69]  DEFAULT ('') FOR [AdmittingDiagnosis_FL69]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientVisitRsnDiagnosis_FL70a]  DEFAULT ('') FOR [PatientVisitRsnDiagnosis_FL70a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientVisitRsnDiagnosis_FL70b]  DEFAULT ('') FOR [PatientVisitRsnDiagnosis_FL70b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PatientVisitRsnDiagnosis_FL70c]  DEFAULT ('') FOR [PatientVisitRsnDiagnosis_FL70c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrincipalProcCode_FL74]  DEFAULT ('') FOR [PrincipalProcCode_FL74]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__PrincipalProcDate_FL74]  DEFAULT ('') FOR [PrincipalProcDate_FL74]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74a]  DEFAULT ('') FOR [OtherProcCode_FL74a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74a]  DEFAULT ('') FOR [OtherProcDate_FL74a]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74b]  DEFAULT ('') FOR [OtherProcCode_FL74b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74b]  DEFAULT ('') FOR [OtherProcDate_FL74b]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74c]  DEFAULT ('') FOR [OtherProcCode_FL74c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74c]  DEFAULT ('') FOR [OtherProcDate_FL74c]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74d]  DEFAULT ('') FOR [OtherProcCode_FL74d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74d]  DEFAULT ('') FOR [OtherProcDate_FL74d]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcCode_FL74e]  DEFAULT ('') FOR [OtherProcCode_FL74e]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherProcDate_FL74e]  DEFAULT ('') FOR [OtherProcDate_FL74e]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AttendingNPI_ID_FL76]  DEFAULT ('') FOR [AttendingNPI_ID_FL76]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AttendingNPI_IDType_FL76]  DEFAULT ('') FOR [AttendingNPI_IDType_FL76]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AttendingLastName_FL76]  DEFAULT ('') FOR [AttendingLastName_FL76]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__AttendingFirstName_FL76]  DEFAULT ('') FOR [AttendingFirstName_FL76]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OperatingNPI_ID_FL77]  DEFAULT ('') FOR [OperatingNPI_ID_FL77]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OperatingNPI_IDType_FL77]  DEFAULT ('') FOR [OperatingNPI_IDType_FL77]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OperatingLastName_FL77]  DEFAULT ('') FOR [OperatingLastName_FL77]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OperatingFirstName_FL77]  DEFAULT ('') FOR [OperatingFirstName_FL77]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherNPI_ID_FL78]  DEFAULT ('') FOR [OtherNPI_ID_FL78]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherNPI_IDType_FL78]  DEFAULT ('') FOR [OtherNPI_IDType_FL78]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherLastName_FL78]  DEFAULT ('') FOR [OtherLastName_FL78]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherFirstName_FL78]  DEFAULT ('') FOR [OtherFirstName_FL78]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherNPI_ID_FL79]  DEFAULT ('') FOR [OtherNPI_ID_FL79]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherNPI_IDType_FL79]  DEFAULT ('') FOR [OtherNPI_IDType_FL79]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherLastName_FL79]  DEFAULT ('') FOR [OtherLastName_FL79]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__OtherFirstName_FL79]  DEFAULT ('') FOR [OtherFirstName_FL79]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__Remarks_FL80]  DEFAULT ('') FOR [Remarks_FL80]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF__UB04Claim__TotalCharge]  DEFAULT ((0)) FOR [TotalCharge]
ALTER TABLE [migtemp_UB04Claim] ADD  CONSTRAINT [DF_UB04Claim_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_UB04Claim
INSERT [migtemp_UB04Claim]([UB04ClaimUid],[SuperBillUId],[FinancialCenterUid],[ProviderUId],[FileAsGroup],[SendNPI],[ProviderName_FL1],[ProviderAddress1_FL1],[ProviderAddress2_FL1],[ProviderCity_FL1],[ProviderState_FL1],[ProviderZip_FL1],[ProviderPhone_FL1],[PatientControlNumber_FL3a],[MedicalRecordNumber_FL3b],[TypeOfBill_FL4],[FederalTaxID_FL5],[StatementCoversPeriod_FL6From],[StatementCoversPeriod_FL6To],[PatientName_FL8b],[PatientAddressStreet_FL9a],[PatientAddressCity_FL9b],[PatientAddressState_FL9c],[PatientAddressZip_FL9d],[PatientBirthDate_FL10],[PatientSex_FL11],[AdmissionDate_FL12],[AdmissionHour_FL13],[AdmissionType_FL14],[AdmissionSource_FL15],[DischargeHour_FL16],[PatientDischargeStatus_FL17],[ConditionCode_FL18],[ConditionCode_FL19],[ConditionCode_FL20],[ConditionCode_FL21],[ConditionCode_FL22],[ConditionCode_FL23],[ConditionCode_FL24],[ConditionCode_FL25],[ConditionCode_FL26],[ConditionCode_FL27],[ConditionCode_FL28],[AccidentState_FL29],[OccurrenceCode_FL31],[OccurrenceDate_FL31],[OccurrenceCode_FL32],[OccurrenceDate_FL32],[OccurrenceCode_FL33],[OccurrenceDate_FL33],[OccurrenceCode_FL34],[OccurrenceDate_FL34],[OccurrenceCode_FL31b],[OccurrenceDate_FL31b],[OccurrenceCode_FL32b],[OccurrenceDate_FL32b],[OccurrenceCode_FL33b],[OccurrenceDate_FL33b],[OccurrenceCode_FL34b],[OccurrenceDate_FL34b],[OccurrenceSpanCode_FL35],[OccurrenceSpanFrom_FL35],[OccurrenceSpanTo_FL35],[OccurrenceSpanCode_FL36],[OccurrenceSpanFrom_FL36],[OccurrenceSpanTo_FL36],[OccurrenceSpanCode_FL35b],[OccurrenceSpanFrom_FL35b],[OccurrenceSpanTo_FL35b],[OccurrenceSpanCode_FL36b],[OccurrenceSpanFrom_FL36b],[OccurrenceSpanTo_FL36b],[ResponsiblePartyName_IsCorporation],[ResponsiblePartyName_FL38],[ResponsiblePartyAddress1_FL38],[ResponsiblePartyAddress2_FL38],[ResponsiblePartyCity_FL38],[ResponsiblePartyState_FL38],[ResponsiblePartyZip_FL38],[ValueCode_FL39a],[ValueCodeAmount_FL39a],[ValueCode_FL39b],[ValueCodeAmount_FL39b],[ValueCode_FL39c],[ValueCodeAmount_FL39c],[ValueCode_FL39d],[ValueCodeAmount_FL39d],[ValueCode_FL40a],[ValueCodeAmount_FL40a],[ValueCode_FL40b],[ValueCodeAmount_FL40b],[ValueCode_FL40c],[ValueCodeAmount_FL40c],[ValueCode_FL40d],[ValueCodeAmount_FL40d],[ValueCode_FL41a],[ValueCodeAmount_FL41a],[ValueCode_FL41b],[ValueCodeAmount_FL41b],[ValueCode_FL41c],[ValueCodeAmount_FL41c],[ValueCode_FL41d],[ValueCodeAmount_FL41d],[PrimaryPayerName_FL50a],[PrimaryPayerPlanType_FL50a],[PrimaryPayerPlanName_FL50a],[SecondaryPayerName_FL50b],[SecondaryPayerPlanType_FL50b],[SecondaryPayerPlanName_FL50b],[TertiaryPayerName_FL50c],[TertiaryPayerPlanType_FL50c],[TertiaryPayerPlanName_FL50c],[PrimaryHealthPlanIDType_FL51a],[SecondaryHealthPlanIDType_FL51b],[TertiaryHealthPlanIDType_FL51c],[PrimaryHealthPlanID_FL51a],[SecondaryHealthPlanID_FL51b],[TertiaryHealthPlanID_FL51c],[PrimaryPatReleaseInfo_FL52a],[SecondaryPatReleaseInfo_FL52b],[TertiaryPatReleaseInfo_FL52c],[PrimaryAssignBenefits_FL53a],[SecondaryAssignBenefits_FL53b],[TertiaryAssignBenefits_FL53c],[PrimaryPriorPmts_FL54a],[SecondaryPriorPmts_FL54b],[TertiaryPriorPmts_FL54c],[PrimaryEstAmtDue_FL55a],[SecondaryEstAmtDue_FL55b],[TertiaryEstAmtDue_FL55c],[BillingProviderNPI_FL56],[ID_FL57],[OtherID_FL57],[ProviderID_FL57],[PrimaryInsuredName_FL58a],[SecondaryInsuredName_FL58b],[TertiaryInsuredName_FL58c],[PrimaryPatRelationship_FL59a],[SecondaryPatRelationship_FL59b],[TertiaryPatRelationship_FL59c],[PrimaryInsuredPlanID_FL60a],[SecondaryInsuredPlanID_FL60b],[TertiaryInsuredPlanID_FL60c],[PrimaryPlanGroupName_FL61a],[SecondaryPlanGroupName_FL61b],[TertiaryPlanGroupName_FL61c],[PrimaryPlanGroupID_FL62a],[SecondaryPlanGroupID_FL62b],[TertiaryPlanGroupID_FL62c],[PrimaryTreatmentAuth_FL63a],[SecondaryTreatmentAuth_FL63b],[TertiaryTreatmentAuth_FL63c],[DocControlNo_FL64a],[DocControlNo_FL64b],[DocControlNo_FL64c],[PrimaryEmployerName_FL65a],[SecondaryEmployerName_FL65b],[TertiaryEmployerName_FL65c],[DiagnosisVersion_FL66],[Diagnosis_FL67],[Diagnosis_FL67a],[Diagnosis_FL67b],[Diagnosis_FL67c],[Diagnosis_FL67d],[Diagnosis_FL67e],[Diagnosis_FL67f],[Diagnosis_FL67g],[Diagnosis_FL67h],[Diagnosis_FL67i],[Diagnosis_FL67j],[Diagnosis_FL67k],[Diagnosis_FL67l],[Diagnosis_FL67m],[Diagnosis_FL67n],[Diagnosis_FL67o],[Diagnosis_FL67p],[Diagnosis_FL67q],[AdmittingDiagnosis_FL69],[PatientVisitRsnDiagnosis_FL70a],[PatientVisitRsnDiagnosis_FL70b],[PatientVisitRsnDiagnosis_FL70c],[PrincipalProcCode_FL74],[PrincipalProcDate_FL74],[OtherProcCode_FL74a],[OtherProcDate_FL74a],[OtherProcCode_FL74b],[OtherProcDate_FL74b],[OtherProcCode_FL74c],[OtherProcDate_FL74c],[OtherProcCode_FL74d],[OtherProcDate_FL74d],[OtherProcCode_FL74e],[OtherProcDate_FL74e],[AttendingNPI_ID_FL76],[AttendingNPI_IDType_FL76],[AttendingLastName_FL76],[AttendingFirstName_FL76],[OperatingNPI_ID_FL77],[OperatingNPI_IDType_FL77],[OperatingLastName_FL77],[OperatingFirstName_FL77],[OtherNPI_ID_FL78],[OtherNPI_IDType_FL78],[OtherLastName_FL78],[OtherFirstName_FL78],[OtherNPI_ID_FL79],[OtherNPI_IDType_FL79],[OtherLastName_FL79],[OtherFirstName_FL79],[Remarks_FL80],[ClaimBatchUID],[TotalCharge],[LastModifiedDate])
SELECT [UB04ClaimUid],[SuperBillUId],[FinancialCenterUid],[ProviderUId],[FileAsGroup],[SendNPI],[ProviderName_FL1],[ProviderAddress1_FL1],[ProviderAddress2_FL1],[ProviderCity_FL1],[ProviderState_FL1],[ProviderZip_FL1],[ProviderPhone_FL1],[PatientControlNumber_FL3a],[MedicalRecordNumber_FL3b],[TypeOfBill_FL4],[FederalTaxID_FL5],[StatementCoversPeriod_FL6From],[StatementCoversPeriod_FL6To],[PatientName_FL8b],[PatientAddressStreet_FL9a],[PatientAddressCity_FL9b],[PatientAddressState_FL9c],[PatientAddressZip_FL9d],[PatientBirthDate_FL10],[PatientSex_FL11],[AdmissionDate_FL12],[AdmissionHour_FL13],[AdmissionType_FL14],[AdmissionSource_FL15],[DischargeHour_FL16],[PatientDischargeStatus_FL17],[ConditionCode_FL18],[ConditionCode_FL19],[ConditionCode_FL20],[ConditionCode_FL21],[ConditionCode_FL22],[ConditionCode_FL23],[ConditionCode_FL24],[ConditionCode_FL25],[ConditionCode_FL26],[ConditionCode_FL27],[ConditionCode_FL28],[AccidentState_FL29],[OccurrenceCode_FL31],[OccurrenceDate_FL31],[OccurrenceCode_FL32],[OccurrenceDate_FL32],[OccurrenceCode_FL33],[OccurrenceDate_FL33],[OccurrenceCode_FL34],[OccurrenceDate_FL34],[OccurrenceCode_FL31b],[OccurrenceDate_FL31b],[OccurrenceCode_FL32b],[OccurrenceDate_FL32b],[OccurrenceCode_FL33b],[OccurrenceDate_FL33b],[OccurrenceCode_FL34b],[OccurrenceDate_FL34b],[OccurrenceSpanCode_FL35],[OccurrenceSpanFrom_FL35],[OccurrenceSpanTo_FL35],[OccurrenceSpanCode_FL36],[OccurrenceSpanFrom_FL36],[OccurrenceSpanTo_FL36],[OccurrenceSpanCode_FL35b],[OccurrenceSpanFrom_FL35b],[OccurrenceSpanTo_FL35b],[OccurrenceSpanCode_FL36b],[OccurrenceSpanFrom_FL36b],[OccurrenceSpanTo_FL36b],[ResponsiblePartyName_IsCorporation],[ResponsiblePartyName_FL38],[ResponsiblePartyAddress1_FL38],[ResponsiblePartyAddress2_FL38],[ResponsiblePartyCity_FL38],[ResponsiblePartyState_FL38],[ResponsiblePartyZip_FL38],[ValueCode_FL39a],[ValueCodeAmount_FL39a],[ValueCode_FL39b],[ValueCodeAmount_FL39b],[ValueCode_FL39c],[ValueCodeAmount_FL39c],[ValueCode_FL39d],[ValueCodeAmount_FL39d],[ValueCode_FL40a],[ValueCodeAmount_FL40a],[ValueCode_FL40b],[ValueCodeAmount_FL40b],[ValueCode_FL40c],[ValueCodeAmount_FL40c],[ValueCode_FL40d],[ValueCodeAmount_FL40d],[ValueCode_FL41a],[ValueCodeAmount_FL41a],[ValueCode_FL41b],[ValueCodeAmount_FL41b],[ValueCode_FL41c],[ValueCodeAmount_FL41c],[ValueCode_FL41d],[ValueCodeAmount_FL41d],[PrimaryPayerName_FL50a],[PrimaryPayerPlanType_FL50a],[PrimaryPayerPlanName_FL50a],[SecondaryPayerName_FL50b],[SecondaryPayerPlanType_FL50b],[SecondaryPayerPlanName_FL50b],[TertiaryPayerName_FL50c],[TertiaryPayerPlanType_FL50c],[TertiaryPayerPlanName_FL50c],[PrimaryHealthPlanIDType_FL51a],[SecondaryHealthPlanIDType_FL51b],[TertiaryHealthPlanIDType_FL51c],[PrimaryHealthPlanID_FL51a],[SecondaryHealthPlanID_FL51b],[TertiaryHealthPlanID_FL51c],[PrimaryPatReleaseInfo_FL52a],[SecondaryPatReleaseInfo_FL52b],[TertiaryPatReleaseInfo_FL52c],[PrimaryAssignBenefits_FL53a],[SecondaryAssignBenefits_FL53b],[TertiaryAssignBenefits_FL53c],[PrimaryPriorPmts_FL54a],[SecondaryPriorPmts_FL54b],[TertiaryPriorPmts_FL54c],[PrimaryEstAmtDue_FL55a],[SecondaryEstAmtDue_FL55b],[TertiaryEstAmtDue_FL55c],[BillingProviderNPI_FL56],[ID_FL57],[OtherID_FL57],[ProviderID_FL57],[PrimaryInsuredName_FL58a],[SecondaryInsuredName_FL58b],[TertiaryInsuredName_FL58c],[PrimaryPatRelationship_FL59a],[SecondaryPatRelationship_FL59b],[TertiaryPatRelationship_FL59c],[PrimaryInsuredPlanID_FL60a],[SecondaryInsuredPlanID_FL60b],[TertiaryInsuredPlanID_FL60c],[PrimaryPlanGroupName_FL61a],[SecondaryPlanGroupName_FL61b],[TertiaryPlanGroupName_FL61c],[PrimaryPlanGroupID_FL62a],[SecondaryPlanGroupID_FL62b],[TertiaryPlanGroupID_FL62c],[PrimaryTreatmentAuth_FL63a],[SecondaryTreatmentAuth_FL63b],[TertiaryTreatmentAuth_FL63c],[DocControlNo_FL64a],[DocControlNo_FL64b],[DocControlNo_FL64c],[PrimaryEmployerName_FL65a],[SecondaryEmployerName_FL65b],[TertiaryEmployerName_FL65c],[DiagnosisVersion_FL66],[Diagnosis_FL67],[Diagnosis_FL67a],[Diagnosis_FL67b],[Diagnosis_FL67c],[Diagnosis_FL67d],[Diagnosis_FL67e],[Diagnosis_FL67f],[Diagnosis_FL67g],[Diagnosis_FL67h],[Diagnosis_FL67i],[Diagnosis_FL67j],[Diagnosis_FL67k],[Diagnosis_FL67l],[Diagnosis_FL67m],[Diagnosis_FL67n],[Diagnosis_FL67o],[Diagnosis_FL67p],[Diagnosis_FL67q],[AdmittingDiagnosis_FL69],[PatientVisitRsnDiagnosis_FL70a],[PatientVisitRsnDiagnosis_FL70b],[PatientVisitRsnDiagnosis_FL70c],[PrincipalProcCode_FL74],[PrincipalProcDate_FL74],[OtherProcCode_FL74a],[OtherProcDate_FL74a],[OtherProcCode_FL74b],[OtherProcDate_FL74b],[OtherProcCode_FL74c],[OtherProcDate_FL74c],[OtherProcCode_FL74d],[OtherProcDate_FL74d],[OtherProcCode_FL74e],[OtherProcDate_FL74e],[AttendingNPI_ID_FL76],[AttendingNPI_IDType_FL76],[AttendingLastName_FL76],[AttendingFirstName_FL76],[OperatingNPI_ID_FL77],[OperatingNPI_IDType_FL77],[OperatingLastName_FL77],[OperatingFirstName_FL77],[OtherNPI_ID_FL78],[OtherNPI_IDType_FL78],[OtherLastName_FL78],[OtherFirstName_FL78],[OtherNPI_ID_FL79],[OtherNPI_IDType_FL79],[OtherLastName_FL79],[OtherFirstName_FL79],[Remarks_FL80],[ClaimBatchUID],[TotalCharge],[LastModifiedDate]
FROM [UB04Claim]

DROP TABLE [UB04Claim]

exec  sp_rename 'migtemp_UB04Claim', 'UB04Claim'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User group member' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'UserGroupMember', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserGroupMember'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VaccineUnitUse]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[VaccineUnitUse](
	[VaccineUnitUseUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VaccineUnitUse_VaccineUnitUseUid]  DEFAULT (newid()),
	[NDCInnerID] [float] NULL,
	[UseUnitLabeler] [varchar](255) NULL,
	[UseUnitProduct] [varchar](255) NULL,
	[UseUnitPackage] [varchar](255) NULL,
	[UseUnitPropName] [varchar](255) NULL,
	[UseUnitGenericName] [varchar](255) NULL,
	[UseUnitLabelerName] [varchar](255) NULL,
	[UseUnitstartDate] [varchar](255) NULL,
	[UseUnitEndDate] [varchar](255) NULL,
	[UseUnitPackForm] [varchar](255) NULL,
	[UseUnitGTIN] [varchar](255) NULL,
	[CVXCode] [varchar](255) NULL,
	[CVXShortDescription] [varchar](255) NULL,
	[NoInner] [bit] NOT NULL,
	[NDC11] [varchar](255) NULL,
	[LastUpdatedDate] [datetime] NULL,
	[GTIN] [varchar](255) NULL,
	[MVX] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_VaccineUnitUse_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_VaccineUnitUse_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VaccineUnitUse_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VaccineUnitUse'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Visit]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Visit](
	[VisitUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ClinicalNoteTypeUid] [uniqueidentifier] NOT NULL,
	[AppointmentUid] [uniqueidentifier] NULL,
	[PatientCaseUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[AccountUid] [uniqueidentifier] NULL,
	[SuperbillRequired] [bit] NOT NULL,
	[VisitDate] [date] NOT NULL,
	[IsCompleted] [bit] NOT NULL,
	[ProviderUid] [uniqueidentifier] NOT NULL,
	[ProviderCareTypeUid] [uniqueidentifier] NULL,
	[RenderingProviderUid] [uniqueidentifier] NULL,
	[ProviderSignatureUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[ServiceSiteTypeUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NOT NULL,
	[SupervisingProviderUid] [uniqueidentifier] NULL,
	[Emergency] [bit] NOT NULL,
	[AuthorizationCode] [varchar](30) NULL,
	[ReferredByProviderUid] [uniqueidentifier] NULL,
	[ReferringDate] [date] NULL,
	[PETemplateUid] [uniqueidentifier] NULL,
	[OriginalPETemplateUid] [uniqueidentifier] NULL,
	[CosignStatusID] [smallint] NOT NULL,
	[VoiceAttachmentUid] [uniqueidentifier] NULL,
	[CaseTypePhaseUid] [uniqueidentifier] NULL,
	[CompletedDate] [datetime] NULL,
	[ABN] [bit] NOT NULL,
	[VisitTypeUid] [uniqueidentifier] NULL,
	[DefaultStartTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[DefaultEndTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[DFTQueuedDateTime] [datetime] NULL,
	[ObservationTemplates] [xml](CONTENT [dbo].[UidList]) NULL,
	[HistorianUid] [uniqueidentifier] NULL,
	[PatientDeclinedClinicalSummary] [bit] NOT NULL,
	[HistorianRepName] [varchar](40) NULL,
	[LastSavedByUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[SavedByBillingProvider] [bit] NULL,
	[SavedByRenderingProvider] [bit] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'id for each visit' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Appointment for visit' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'AppointmentUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient case' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'PatientCaseUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N' Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'PatientUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient account' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'AccountUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag to allow setting visit to require no superbill or HL7 bill to outside PMS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'SuperbillRequired'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Visit date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'VisitDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1: completed note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'IsCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'IsCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'IsCompleted'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'billing provider id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'ProviderUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Initialized (overrides) provider.DefaultCareTypeUid for claiming provider, used to calculate copa depending on whether primary care, specialist or other' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'ProviderCareTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'rendering provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'RenderingProviderUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'provider signature id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'ProviderSignatureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'service site where service performed' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'ServiceSiteUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'if service site not specified, can specify the service site type' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'ServiceSiteTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'flag telling whether visit is for an emergency' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'Emergency'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'authorization code' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'AuthorizationCode'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Refer doctor id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'ReferredByProviderUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'date of referal, if any' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'ReferringDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'selected pe template id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'PETemplateUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'selected pe template originated pe template id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'OriginalPETemplateUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Cosign status, 1: pending; 2: cosigned' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'CosignStatusID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'in note voice, FK to VoiceAttachment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'VoiceAttachmentUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of the note is completed' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'CompletedDate'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'CompletedDate'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'DFTQueueDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'DFTQueuedDateTime'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'DFTQueuedDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Has the note been saved by the Billing Provider ?' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'SavedByBillingProvider'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Has the note been saved by the Rendering Provider ?' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit', @level2type=N'COLUMN',@level2name=N'SavedByRenderingProvider'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Visit main information' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit'
EXEC sys.sp_addextendedproperty @name=N'Replication.BeginTransaction', @value=N'Visit=VisitUid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit'
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'IsCompleted,CompletedDate,SuperbillStatusID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit'
EXEC sys.sp_addextendedproperty @name=N'Replication.Lock', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit'
EXEC sys.sp_addextendedproperty @name=N'Replication.ProcessorAQN', @value=N'iMedica.Prm.BusinessObject.VisitSuperbillFinancialsProcessor, iMedica.Prm.BusinessObject' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Visit'

ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_VisitUid]  DEFAULT (newid()) FOR [VisitUid]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_ClinicalNoteTypeUid]  DEFAULT ('10101010-1111-0000-0000-000000000001') FOR [ClinicalNoteTypeUid]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_SuperbillRequired]  DEFAULT ((1)) FOR [SuperbillRequired]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_IsCompleted]  DEFAULT ((0)) FOR [IsCompleted]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_Emergency]  DEFAULT ((0)) FOR [Emergency]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_CosignStatusID]  DEFAULT ((0)) FOR [CosignStatusID]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_ABN]  DEFAULT ((0)) FOR [ABN]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_PatientDeclinedClinicalSummary]  DEFAULT ((0)) FOR [PatientDeclinedClinicalSummary]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_SavedByBillingProvider]  DEFAULT ((0)) FOR [SavedByBillingProvider]
ALTER TABLE [migtemp_Visit] ADD  CONSTRAINT [DF_Visit_SavedByRenderingProvider]  DEFAULT ((0)) FOR [SavedByRenderingProvider]

END
Truncate Table migtemp_Visit
INSERT [migtemp_Visit]([VisitUid],[ClinicalNoteTypeUid],[AppointmentUid],[PatientCaseUid],[PatientUid],[AccountUid],[SuperbillRequired],[VisitDate],[IsCompleted],[ProviderUid],[ProviderCareTypeUid],[RenderingProviderUid],[ProviderSignatureUid],[ServiceSiteUid],[ServiceSiteTypeUid],[FinancialCenterUid],[SupervisingProviderUid],[Emergency],[AuthorizationCode],[ReferredByProviderUid],[ReferringDate],[PETemplateUid],[OriginalPETemplateUid],[CosignStatusID],[VoiceAttachmentUid],[CaseTypePhaseUid],[CompletedDate],[ABN],[VisitTypeUid],[DefaultStartTime],[DefaultEndTime],[DFTQueuedDateTime],[ObservationTemplates],[HistorianUid],[PatientDeclinedClinicalSummary],[HistorianRepName],[LastSavedByUid],[LastModifiedByUid],[LastModifiedDate],[SavedByBillingProvider],[SavedByRenderingProvider])
SELECT [VisitUid],[ClinicalNoteTypeUid],[AppointmentUid],[PatientCaseUid],[PatientUid],[AccountUid],[SuperbillRequired],[VisitDate],[IsCompleted],[ProviderUid],[ProviderCareTypeUid],[RenderingProviderUid],[ProviderSignatureUid],[ServiceSiteUid],[ServiceSiteTypeUid],[FinancialCenterUid],[SupervisingProviderUid],[Emergency],[AuthorizationCode],[ReferredByProviderUid],[ReferringDate],[PETemplateUid],[OriginalPETemplateUid],[CosignStatusID],[VoiceAttachmentUid],[CaseTypePhaseUid],[CompletedDate],[ABN],[VisitTypeUid],[DefaultStartTime],[DefaultEndTime],[DFTQueuedDateTime],CONVERT(nvarchar(max), [ObservationTemplates]),[HistorianUid],[PatientDeclinedClinicalSummary],[HistorianRepName],[LastSavedByUid],[LastModifiedByUid],[LastModifiedDate],[SavedByBillingProvider],[SavedByRenderingProvider]
FROM [Visit]

DROP TABLE [Visit]

exec  sp_rename 'migtemp_Visit', 'Visit'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitAssessmentForm]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitAssessmentForm](
	[VisitAssessmentFormUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[AssessmentFormUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[Data] [xml] NULL,
	[Text] [varchar](max) NULL,
	[ObservationOrderUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitAssessmentForm', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitAssessmentForm', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [migtemp_VisitAssessmentForm] ADD  CONSTRAINT [DF_VisitAssessmentForm_VisitAssessmentFormUid]  DEFAULT (newid()) FOR [VisitAssessmentFormUid]
ALTER TABLE [migtemp_VisitAssessmentForm] ADD  CONSTRAINT [DF_VisitAssessmentForm_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_VisitAssessmentForm] ADD  CONSTRAINT [DF_VisitAssessmentForm_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_VisitAssessmentForm
INSERT [migtemp_VisitAssessmentForm]([VisitAssessmentFormUid],[VisitUid],[AssessmentFormUid],[Name],[Data],[Text],[ObservationOrderUid],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate])
SELECT [VisitAssessmentFormUid],[VisitUid],[AssessmentFormUid],[Name],CONVERT(nvarchar(max), [Data]),[Text],[ObservationOrderUid],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate]
FROM [VisitAssessmentForm]

DROP TABLE [VisitAssessmentForm]

exec  sp_rename 'migtemp_VisitAssessmentForm', 'VisitAssessmentForm'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'BasedOnTypeID' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'BasedOnTypeID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DocumentMdmBasedOn' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DocumentMdmBasedOn' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'PlaceOfServiceDetail' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'PlaceOfServiceDetail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'TypeOfService' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'TypeOfService' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', N'COLUMN',N'MedicalChecked'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity', @level2type=N'COLUMN',@level2name=N'MedicalChecked'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', N'COLUMN',N'TransitionOfCare'))
EXEC sys.sp_dropextendedproperty @name=N'oldname' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity', @level2type=N'COLUMN',@level2name=N'TransitionOfCare'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'BasedOnTypeID' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'BasedOnTypeID', @value=N'<None value="0" /><Time value="2" /><Documentation value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DocumentMdmBasedOn' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DocumentMdmBasedOn', @value=N'<None value="0" />
<Guideline value="1" />
<Selected value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'PlaceOfServiceDetail' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'PlaceOfServiceDetail', @value=N'<None value="0" />
<DOM value="1" />
<ALF value="2" />
<AFC value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'TypeOfService' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'TypeOfService', @value=N'<None value="0" />
<OfficeNewPatient value="1" />
<OfficeEstablishedPatient value="2" />
<OfficeConsult value="3" />
<NursingFaclityInitial value="4" />
<NursingFaclitySubsequent value="5" />
<HospitalObervationInitial value="6" />
<HospitalObervationDischarge value="7" />
<HospitalObervationInpatient value="8" />
<HospitalInpatientInitial value="9" />
<HospitalInpatientSubsequent value="10" />
<HospitalInpatientDischarge value="11" />
<HospitalInpatientInpatient value="12" />
<HospitalInpatientConsultation value="13" />
<HospitalCriticalCareAdult value="14" />
<HospitalCriticalCarePediatric value="15" />
<HospitalCriticalCareNeonatal value="16" />
<HospitalERVisit value="17" />
<HospitalERAdvancedLifeSupport value="18" />
<HomeServicesNewPatient value="19" />
<HomeServicesEstablishedPatient value="20" />
<RestHomeNewPatient value="21" />
<RestHomeEstablishedPatient value="22" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', N'COLUMN',N'MedicalChecked'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hx CheckedFlag: 0: none; 1: checked; 2: modified; 3: checked + modified' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity', @level2type=N'COLUMN',@level2name=N'MedicalChecked'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitDiagnosis](
	[VisitDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[PatientProblemUid] [uniqueidentifier] NULL,
	[DiagnosisPanelUid] [uniqueidentifier] NULL,
	[PatientProblemDiagnosisUid] [uniqueidentifier] NULL,
	[Code] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[FollowupFlag] [smallint] NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[IsDelete] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[AddendumNotes] [varchar](max) NULL,
	[DSMAxis] [varchar](250) NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DpnXml] [xml] NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[SortToBottom] [bit] NOT NULL,
	[LifeLong] [bit] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1:improve; 2:worsen; 3: unchange; 4: resolve' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'FollowupFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 - Differential, 2 - PreOp, 3 - PostOp' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'VisitDiagnosisType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for Diagnosis' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis'
EXEC sys.sp_addextendedproperty @name=N'VisitDiagnosisType', @value=N'<None value="0"/><Differential value="1" /><PreOp value="2"/><PostOp value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis'

ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_RowGuid]  DEFAULT (newid()) FOR [VisitDiagnosisUid]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_SortToBottom]  DEFAULT ((0)) FOR [SortToBottom]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_LifeLong]  DEFAULT ((0)) FOR [LifeLong]

END
Truncate Table migtemp_VisitDiagnosis
INSERT [migtemp_VisitDiagnosis]([VisitDiagnosisUid],[VisitUid],[PatientProblemUid],[DiagnosisPanelUid],[Code],[Code10],[Name],[Notes],[DisplayOrder],[SnomedCTConceptId],[FollowupFlag],[VisitDiagnosisType],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate],[AddendumNotes],[DSMAxis])
SELECT [VisitDiagnosisUid],[VisitUid],[PatientProblemUid],[DiagnosisPanelUid],[Code],[Code10],[Name],[Notes],[DisplayOrder],[SnomedCTConceptId],[FollowupFlag],[VisitDiagnosisType],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate],[AddendumNotes],[DSMAxis]
FROM [VisitDiagnosis]

DROP TABLE [VisitDiagnosis]

exec  sp_rename 'migtemp_VisitDiagnosis', 'VisitDiagnosis'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitPE]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitPE](
	[VisitPEUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[PETemplateUid] [uniqueidentifier] NOT NULL,
	[PEParentSystemUid] [uniqueidentifier] NOT NULL,
	[PESystemUid] [uniqueidentifier] NOT NULL,
	[PESymptomUid] [uniqueidentifier] NOT NULL,
	[PEDescriptionUid] [uniqueidentifier] NOT NULL,
	[RelEMKeyComponentBulletUid] [uniqueidentifier] NULL,
	[PETemplateName] [varchar](100) NULL,
	[PEParentSystemName] [varchar](100) NULL,
	[PESystemName] [varchar](100) NULL,
	[PESymptomName] [varchar](100) NULL,
	[PEDescriptionName] [varchar](255) NULL,
	[IsPEParentSystemBilateral] [bit] NOT NULL,
	[IsPESystemBilateral] [bit] NOT NULL,
	[IsPESymptomBilateral] [bit] NOT NULL,
	[PESystemColorID] [smallint] NULL,
	[NormalFlag] [bit] NOT NULL,
	[FollowupFlag] [smallint] NULL,
	[PEParentSystemDisplayOrder] [int] NULL,
	[PESystemDisplayOrder] [int] NULL,
	[PESymptomDisplayOrder] [int] NULL,
	[PEDescriptionDisplayOrder] [int] NULL,
	[BilateralityValue] [smallint] NULL,
	[CountAsBullet] [bit] NULL,
	[LifeLong] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[IsDelete] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'VisitPEUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe template id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PETemplateUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe subsystem' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEParentSystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe system id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe symptom id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESymptomUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe description id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEDescriptionUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEParentSystemName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE sub system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESystemName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE finding' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESymptomName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEDescriptionName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1: blue; 2: black' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESystemColorID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'normal flag: 1: normal; 0: abnormal' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'NormalFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1:improve; 2:worsen; 3: unchange; 4: resolve' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'FollowupFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE description sequence' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEDescriptionDisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bilaterality values: 0 - not defined, 1 - left, 2 - right, 3 - bilateral' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'BilateralityValue'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'user comment on the description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'BilateralityValue', @value=N'<NotDefined value="0" /><Left value="1" description="Left side of the patient" /><Right value="2" description="Right side of the patient" /><Bilateral value="3" description="Both sides of the patient" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for physical exam' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE'

ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_RowGuid]  DEFAULT (newid()) FOR [VisitPEUid]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsPEParentSystemBilateral]  DEFAULT ((0)) FOR [IsPEParentSystemBilateral]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsPESystemBilateral]  DEFAULT ((0)) FOR [IsPESystemBilateral]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsPESymptomBilateral]  DEFAULT ((0)) FOR [IsPESymptomBilateral]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_PESystemColorID]  DEFAULT ((0)) FOR [PESystemColorID]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_NormalFlag]  DEFAULT ((0)) FOR [NormalFlag]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_BilateralityValue]  DEFAULT ((0)) FOR [BilateralityValue]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_CountAsBullet]  DEFAULT ((1)) FOR [CountAsBullet]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_Lifelong]  DEFAULT ((0)) FOR [LifeLong]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsDeleted]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_VisitPE
INSERT [migtemp_VisitPE]([VisitPEUid],[VisitUid],[PETemplateUid],[PEParentSystemUid],[PESystemUid],[PESymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[PETemplateName],[PEParentSystemName],[PESystemName],[PESymptomName],[PEDescriptionName],[IsPEParentSystemBilateral],[IsPESystemBilateral],[IsPESymptomBilateral],[PESystemColorID],[NormalFlag],[FollowupFlag],[PEParentSystemDisplayOrder],[PESystemDisplayOrder],[PESymptomDisplayOrder],[PEDescriptionDisplayOrder],[BilateralityValue],[CountAsBullet],[Notes],[AddendumNotes],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate])
SELECT [VisitPEUid],[VisitUid],[PETemplateUid],[PEParentSystemUid],[PESystemUid],[PESymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[PETemplateName],[PEParentSystemName],[PESystemName],[PESymptomName],[PEDescriptionName],[IsPEParentSystemBilateral],[IsPESystemBilateral],[IsPESymptomBilateral],[PESystemColorID],[NormalFlag],[FollowupFlag],[PEParentSystemDisplayOrder],[PESystemDisplayOrder],[PESymptomDisplayOrder],[PEDescriptionDisplayOrder],[BilateralityValue],[CountAsBullet],[Notes],[AddendumNotes],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate]
FROM [VisitPE]

DROP TABLE [VisitPE]

exec  sp_rename 'migtemp_VisitPE', 'VisitPE'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VisitPlanDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[VisitPlanDiagnosis](
	[VisitPlanDiagnosisUid] [uniqueidentifier] NOT NULL,
	[VisitDiagnosisUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DataXML] [xml] NULL,
	[TextXML] [xml] NULL,
	[DisplayOrder] [int] NOT NULL,
	[RecallUid] [uniqueidentifier] NULL,
	[Exclude] [bit] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitPlanDiagnosis', @level2type=N'COLUMN',@level2name=N'IsDelete'

ALTER TABLE [VisitPlanDiagnosis] ADD  CONSTRAINT [DF_VisitPlanDiagnosis_VisitPlanDiagnosisUid]  DEFAULT (newid()) FOR [VisitPlanDiagnosisUid]
ALTER TABLE [VisitPlanDiagnosis] ADD  CONSTRAINT [DF_VisitPlanDiagnosis_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [VisitPlanDiagnosis] ADD  CONSTRAINT [DF_VisitPlanDiagnosis_Exclude]  DEFAULT ((0)) FOR [Exclude]
ALTER TABLE [VisitPlanDiagnosis] ADD  CONSTRAINT [DF_VisitPlanDiagnosis_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [VisitPlanDiagnosis] ADD  CONSTRAINT [DF_VisitPlanDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitProcedure](
	[VisitProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[ProcedureCategoryUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[ProcedureModifier1Uid] [uniqueidentifier] NULL,
	[ProcedureModifier2Uid] [uniqueidentifier] NULL,
	[ProcedureModifier3Uid] [uniqueidentifier] NULL,
	[ProcedureModifier4Uid] [uniqueidentifier] NULL,
	[ProcedurePanelUid] [uniqueidentifier] NULL,
	[Code] [varchar](30) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[Unit] [int] NULL,
	[PatientImmunizationUid] [uniqueidentifier] NULL,
	[IsPerformed] [bit] NOT NULL,
	[IsEM] [bit] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[ServiceSiteTypeUid] [uniqueidentifier] NULL,
	[UserDefinedTemplateUid] [uniqueidentifier] NULL,
	[AddToHistoryGroupUid] [uniqueidentifier] NULL,
	[UserDefinedProcedureNoteText] [varchar](max) NULL,
	[UserDefinedProcedureNoteXml] [varchar](max) NULL,
	[GlobalPeriodDays] [int] NULL,
	[PQRIMeasureUid] [uniqueidentifier] NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DpnXml] [xml] NULL,
	[DpnOrderActionSaveFlag] [bit] NOT NULL,
	[DpnOrderActionCompleteFlag] [bit] NOT NULL,
	[DpnOrderActionSendFlag] [bit] NOT NULL,
	[DpnOrderActionCloseFlag] [bit] NOT NULL,
	[ReimbursementRuleTriggerUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[ReimbursementRuleDiagnosis] [bit] NOT NULL,
	[ReimbursementRuleOverride] [bit] NOT NULL,
	[BillStartTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillEndTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillTransportOdoStart] [float] NULL,
	[BillTransportOdoEnd] [float] NULL,
	[BillOdometerXml] [xml] NULL,
	[BillTimeXml] [xml] NULL,
	[ABNStatusUid] [uniqueidentifier] NULL,
	[ABNEstimatedFee] [money] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[OrderInfo] [xml](CONTENT [dbo].[OrderInfoData]) NULL,
	[OrderAQNData] [xml] NULL,
	[SortToBottom] [bit] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'VisitProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CPT id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'ProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'user comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DisplayOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'number of times of  service' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'Unit'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'waiting for spec: The table has been changed to PatientHistoryDetail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'PatientImmunizationUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for service perform' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure'

ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_VisitProcedureUid]  DEFAULT (newid()) FOR [VisitProcedureUid]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_IsPerformed]  DEFAULT ((0)) FOR [IsPerformed]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_IsEM_1]  DEFAULT ((0)) FOR [IsEM]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_IsDeleted]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DpnOrderActionSaveFlag]  DEFAULT ((0)) FOR [DpnOrderActionSaveFlag]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DpnOrderActionCompleteFlag]  DEFAULT ((0)) FOR [DpnOrderActionCompleteFlag]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DpnOrderActionSendFlag]  DEFAULT ((0)) FOR [DpnOrderActionSendFlag]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DpnOrderActionCloseFlag]  DEFAULT ((0)) FOR [DpnOrderActionCloseFlag]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_ReimbursementRuleDiagnosis]  DEFAULT ((0)) FOR [ReimbursementRuleDiagnosis]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_ReimbursementRuleOverride]  DEFAULT ((0)) FOR [ReimbursementRuleOverride]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_ABNEstimatedFee]  DEFAULT ((0)) FOR [ABNEstimatedFee]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_SortToBottom]  DEFAULT ((0)) FOR [SortToBottom]

END
Truncate Table migtemp_VisitProcedure
INSERT [migtemp_VisitProcedure]([VisitProcedureUid],[VisitUid],[ProcedureCategoryUid],[ProcedureUid],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[ProcedurePanelUid],[Code],[Name],[Notes],[AddendumNotes],[DisplayOrder],[Unit],[PatientImmunizationUid],[IsPerformed],[IsEM],[IsDelete],[IsAddendum],[ServiceSiteTypeUid],[UserDefinedTemplateUid],[AddToHistoryGroupUid],[UserDefinedProcedureNoteText],[UserDefinedProcedureNoteXml],[GlobalPeriodDays],[PQRIMeasureUid],[DpnGroupUid],[DpnXml],[DpnOrderActionSaveFlag],[DpnOrderActionCompleteFlag],[DpnOrderActionSendFlag],[DpnOrderActionCloseFlag],[ReimbursementRuleTriggerUid],[NegationReasonUid],[ReimbursementRuleDiagnosis],[ReimbursementRuleOverride],[BillStartTime],[BillEndTime],[BillTransportOdoStart],[BillTransportOdoEnd],[BillOdometerXml],[BillTimeXml],[ABNStatusUid],[ABNEstimatedFee],[LastModifiedByUid],[LastModifiedDate],[OrderInfo],[OrderAQNData])
SELECT [VisitProcedureUid],[VisitUid],[ProcedureCategoryUid],[ProcedureUid],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[ProcedurePanelUid],[Code],[Name],[Notes],[AddendumNotes],[DisplayOrder],[Unit],[PatientImmunizationUid],[IsPerformed],[IsEM],[IsDelete],[IsAddendum],[ServiceSiteTypeUid],[UserDefinedTemplateUid],[AddToHistoryGroupUid],[UserDefinedProcedureNoteText],[UserDefinedProcedureNoteXml],[GlobalPeriodDays],[PQRIMeasureUid],[DpnGroupUid],CONVERT(nvarchar(max), [DpnXml]),[DpnOrderActionSaveFlag],[DpnOrderActionCompleteFlag],[DpnOrderActionSendFlag],[DpnOrderActionCloseFlag],[ReimbursementRuleTriggerUid],[NegationReasonUid],[ReimbursementRuleDiagnosis],[ReimbursementRuleOverride],[BillStartTime],[BillEndTime],[BillTransportOdoStart],[BillTransportOdoEnd],CONVERT(nvarchar(max), [BillOdometerXml]),CONVERT(nvarchar(max), [BillTimeXml]),[ABNStatusUid],[ABNEstimatedFee],[LastModifiedByUid],[LastModifiedDate],CONVERT(nvarchar(max), [OrderInfo]),CONVERT(nvarchar(max), [OrderAQNData])
FROM [VisitProcedure]

DROP TABLE [VisitProcedure]

exec  sp_rename 'migtemp_VisitProcedure', 'VisitProcedure'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_WebRegistration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_WebRegistration](
	[WebRegistrationUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[EmailAddress] [varchar](100) NULL,
	[PhoneNumber] [varchar](80) NULL,
	[BirthDate] [datetime] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[IsExpired] [bit] NOT NULL,
	[IsPasswordReset] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_WebRegistration] ADD  CONSTRAINT [DF_WebRegistration_WebRegistrationUid]  DEFAULT (newid()) FOR [WebRegistrationUid]
ALTER TABLE [migtemp_WebRegistration] ADD  CONSTRAINT [DF_WebRegistration_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [migtemp_WebRegistration] ADD  CONSTRAINT [DF_WebRegistration_IsExpired]  DEFAULT ((0)) FOR [IsExpired]
ALTER TABLE [migtemp_WebRegistration] ADD  CONSTRAINT [DF_WebRegistration_IsPasswordReset]  DEFAULT ((0)) FOR [IsPasswordReset]
ALTER TABLE [migtemp_WebRegistration] ADD  CONSTRAINT [DF_WebRegistration_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_WebRegistration
INSERT [migtemp_WebRegistration]([WebRegistrationUid],[PersonUid],[EmailAddress],[BirthDate],[CreatedDateTime],[IsExpired],[IsPasswordReset],[LastModifiedByUid],[LastModifiedDate])
SELECT [WebRegistrationUid],[PersonUid],[EmailAddress],[BirthDate],[CreatedDateTime],[IsExpired],[IsPasswordReset],[LastModifiedByUid],[LastModifiedDate]
FROM [WebRegistration]

DROP TABLE [WebRegistration]

exec  sp_rename 'migtemp_WebRegistration', 'WebRegistration'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[ProviderCDSCatalog]') AND type in (N'U'))
DROP TABLE [ProviderCDSCatalog]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[SuperbillTargetCreditCardApplyConsents]') AND type in (N'U'))
DROP TABLE [SuperbillTargetCreditCardApplyConsents]
COMMIT TRAN

GO


