-- Migration for bug #44221.
update ListDesktopControl set Name = 'Electronic Prior Authorization/Medication Management' where DesktopControlUid = '29499A20-DDD2-4EFF-8826-82F920BB3D20'
GO
--
-- Surescripts ePA update #4
--
update ListProductParameter set 
	XMLValue = '<root>' +
				'<Payor><Name>Caremark</Name><ID>P00000000001002</ID></Payor>' +
				'<Payor><Name>Express Scripts</Name><ID>P00000000001001</ID></Payor>' +
				'<Payor><Name>Navitus</Name><ID>P00000000020198</ID></Payor>' +
				'<Payor><Name>MedImpact Healthcare</Name><ID>P00000000020127</ID></Payor>' +
				'<Payor><Name>Argus Health System</Name><ID>P00000000020062</ID></Payor>' +
				'<Payor><Name>EnvisionRx</Name><ID>P00000000020299</ID></Payor>' +
				'<Payor><Name>OptumRX Commercial</Name><ID>P00000000022009</ID></Payor>' +
				'<Payor><Name>OptumRX Part D</Name><ID>P00000000020123</ID></Payor>' +
				'</root>',
	LastModifiedDate = '02/10/2016'
where ProductParameterUid = '5397BB02-9803-4639-9C85-DBFF48739E88'
GO

-- 42306
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN

	declare @finalInquiryTemplate varchar(max)
	select @finalInquiryTemplate = 
	'<NetConnectRequest xmlns="http://www.experian.com/NetConnect" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.experian.com/NetConnect NetConnect.xsd">
	  <EAI>11111111</EAI>
	  <DBHost>PRECISE_ID</DBHost>
	  <ReferenceId>Reference Id</ReferenceId>
	  <Request xmlns="http://www.experian.com/WebDelivery" version="1.0">
		<Products>
		  <PreciseIDServer xmlns:xsi="http://www.w3.org/XMLSchema-instance" xsi:noNamespaceScemaLocation="GradedAnswers.xsd">
			<XMLVersion>5.0</XMLVersion>
			<KBAAnswers>
			  <OutWalletAnswerData>
				<SessionID>##SESSIONID##</SessionID>
				<OutWalletAnswers>##ANSWERS##</OutWalletAnswers>
			  </OutWalletAnswerData>
			</KBAAnswers>
		  </PreciseIDServer>
		</Products>
	  </Request>
	</NetConnectRequest>'

	if not exists (select * from ListProductParameter where parametername = 'ExperianValidationUtil.FinalInquiryTemplate')
	begin
		insert into ListProductParameter(ProductParameterUid, ParameterName, UserDefined, StringValue)
		select 'F7F7274B-E82C-42AA-B885-1CEBE25A1B0A', 'ExperianValidationUtil.FinalInquiryTemplate', 0, @finalInquiryTemplate
	end
	else
	begin
		update listproductparameter set StringValue = @finalInquiryTemplate where parametername = 'ExperianValidationUtil.FinalInquiryTemplate'
	end



	declare @initialInquiryTemplate varchar(max)
	select @initialInquiryTemplate = 
	'<NetConnectRequest xmlns="http://www.experian.com/NetConnect" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.experian.com/NetConnect NetConnect.xsd">
	  <EAI>11111111</EAI>
	  <DBHost>PRECISE_ID</DBHost>
	  <ReferenceId>Reference Id</ReferenceId>
	  <Request xmlns="http://www.experian.com/WebDelivery" version="1.0">
		<Products>
		  <PreciseIDServer>
			<XMLVersion>5.0</XMLVersion>
			<Subscriber>
			  <Preamble>TTX1</Preamble>
			  <OpInitials>AC</OpInitials>
			  <SubCode>2455200</SubCode>
			</Subscriber>
			<PrimaryApplicant>
			  <Name>
				<Surname>##LASTNAME##</Surname>
				<First>##FIRSTNAME##</First>
				<Middle>##MIDDLENAME##</Middle>
			  </Name>
			  <SSN>##SSN##</SSN>
			  <CurrentAddress>
				<Street>##STREET##</Street>
				<City>##CITY##</City>
				<State>##STATE##</State>
				<Zip>##ZIP##</Zip>
			  </CurrentAddress>
			  <DOB>##DOB##</DOB>
			</PrimaryApplicant>
			<Verbose>Y</Verbose>
			<Vendor>
			  <VendorNumber>ABC</VendorNumber>
			  <VendorVersion>123456</VendorVersion>
			</Vendor>
			<Options>
			  <BrokerNumber />
			  <FreezeKeyPIN />
			  <ReferenceNumber>ABC1234567</ReferenceNumber>
			  <OFAC>Y</OFAC>
			  <OFACMSG>Y</OFACMSG>
			  <PreciseIDType>24</PreciseIDType>
			  <DetailRequest>D</DetailRequest>
			  <InquiryChannel>INTE</InquiryChannel>
			</Options>
		  </PreciseIDServer>
		</Products>
	  </Request>
	</NetConnectRequest>'

	if not exists (select * from ListProductParameter where parametername = 'ExperianValidationUtil.RequestTemplate')
	begin
		insert into ListProductParameter(ProductParameterUid, ParameterName, UserDefined, StringValue)
		select '341C7654-0F14-473F-81C6-FAF4B59B433F', 'ExperianValidationUtil.RequestTemplate', 0, @initialInquiryTemplate
	end
	else
	begin
		update listproductparameter set StringValue = @initialInquiryTemplate where parametername = 'ExperianValidationUtil.RequestTemplate'
	end

	if exists (select * from transmissionconfiguration where TransmissionType = 'ExpInterface')
	begin
		update TransmissionConfiguration set AprimaVaultSyncURL = 'https://cpproviderlookup.aprima.com/exp', AprimaVaultURL = null where TransmissionType = 'ExpInterface'
	end

	if exists (select * from transmissionconfiguration where TransmissionType = 'HdsInterface')
	begin
		update TransmissionConfiguration set AprimaVaultSyncURL = 'https://cpproviderlookup.aprima.com/hds', AprimaVaultURL = null where TransmissionType = 'HdsInterface'
	end
END
GO

-- Bug #44156 - set OtherSettings "IncludeRxCoupons" to "True"
update ListUserSetting set OtherSettings = 
		convert(xml,replace(convert(varchar(max),OtherSettings), 'IncludeRxCoupons="False"', 'IncludeRxCoupons="True"')) 
where convert(varchar(max),OtherSettings) like '%IncludeRxCoupons="False"%'
GO

--  43026 Updating Race and Ethnicity ANSICodes for MUII to ensure the proper ANSI codes are sent out for the below default values
UPDATE ListRace
SET ANSICode = '2131-1'
WHERE RaceUid = '7D0934B8-71C9-439D-9EEA-0C4485D87843'

UPDATE ListRace
SET ANSICode = '2131-1'
WHERE RaceUid = '3DEF1D31-A3B0-4039-BE9B-472C790826E7'

UPDATE ListRace
SET ANSICode = '2131-1'
WHERE RaceUid = '02AE2FBC-689E-41AB-8020-776F88C21A59'

UPDATE ListRace
SET ANSICode = '2131-1'
WHERE RaceUid = 'B816B6EB-42B3-4239-8121-C5761DC00209'

UPDATE ListEthnicity
SET ANSICode = '2186-5'
WHERE EthnicityUid = 'C1E1CB67-8070-4C01-9B15-99244DA2BE95'

UPDATE ListEthnicity
SET ANSICode = '2186-5'
WHERE ANSICode IS NULL AND Name NOT IN ('Hispanic or Latino','Hispanic','Latino')

UPDATE ListEthnicity
SET ANSICode = '2135-2'
WHERE ANSICode IS NULL AND Name IN ('Hispanic or Latino','Hispanic','Latino')
GO

/*	45758
	Task 46000:Create logic to handle all new send statement options
	Task 46145:Modify Send Statements on Account Responsible Party Screen - Statements to Support 3 State Options
	Migrate existing data
	20160127	BMR		Created
*/
IF NOT EXISTS(SELECT * FROM ListProductParameter 
	WHERE ProductParameterUid = '81040B12-0FBC-4E88-A575-6DCDA12B2C7A') -- Check if already done (Ex. RC3-->RC4)
BEGIN
      -- Collection Processing, Create Collection Letters
      UPDATE AccountResponsibleParty
		SET SendStatement = CASE WHEN SendStatement = 1 THEN 0 ELSE 2 END;

      INSERT INTO ListProductParameter (ProductParameterUid, ParameterName, BoolValue, UserDefined, Inactive, LastModifiedDate) -- Flag As Done
           VALUES ('81040B12-0FBC-4E88-A575-6DCDA12B2C7A', 'Migrate ARP SendStatments To TinyInt', 1, 0, 0, GETUTCDATE());
END

-- 46782
Update ListCaseModule Set RequiresControlClass = '1' 
WHERE CaseModuleUid in 
(
'4F28033F-028D-4B9C-A073-0BF979AE45A0',
'91CA634F-BDCD-4C7D-9D06-2440546C3C7B',
'99B10E26-2061-4C61-9710-28DD55646749',
'63339308-53A0-4D42-8BC6-5CB03E83F635'
)
GO

-- 46399
IF dbo.Replication_IsReplicatedDB() = 0 
BEGIN
	DECLARE @ReplicationSettings_TBL TABLE(
		[ReplicationSettingsUid] [uniqueidentifier],
		[Name] [varchar](250) NOT NULL,
		[UserDefined] [tinyint],
		[LastModifiedDate] [datetime],
		[XMLValue] [xml]
	)

	INSERT @ReplicationSettings_TBL
	VALUES ('6DE7606A-7DE1-4A45-B172-41AD1AA0E0B0', 'Replication.MaxRowsToRetry', 0, '2012-10-26T12:29:17.107',
	'<tables>
		<MaxRows Sequence="0" value="500" RowToFetchFromSql="250" />
		<MaxRows Sequence="1" value="250" RowToFetchFromSql="125" />
		<MaxRows Sequence="2" value="150" RowToFetchFromSql="75" />
		<MaxRows Sequence="3" value="50" RowToFetchFromSql="25" />
		<MaxRows Sequence="4" value="20" RowToFetchFromSql="10" />
		<table name="RawAttachment">
		<MaxRows Sequence="0" value="20" RowToFetchFromSql="10" />
		<MaxRows Sequence="1" value="15" RowToFetchFromSql="7" />
		<MaxRows Sequence="2" value="10" RowToFetchFromSql="5" />
		<MaxRows Sequence="3" value="5" RowToFetchFromSql="2" />
		<MaxRows Sequence="4" value="1" RowToFetchFromSql="1" />
		</table>
		<table name="Attachment">
		<MaxRows Sequence="0" value="20" RowToFetchFromSql="10" />
		<MaxRows Sequence="1" value="15" RowToFetchFromSql="7" />
		<MaxRows Sequence="2" value="10" RowToFetchFromSql="5" />
		<MaxRows Sequence="3" value="5" RowToFetchFromSql="2" />
		<MaxRows Sequence="4" value="1" RowToFetchFromSql="1" />
		</table>
		<table name="ListGraphicNote">
		<MaxRows Sequence="0" value="20" RowToFetchFromSql="10" />
		<MaxRows Sequence="1" value="15" RowToFetchFromSql="7" />
		<MaxRows Sequence="2" value="10" RowToFetchFromSql="5" />
		<MaxRows Sequence="3" value="5" RowToFetchFromSql="2" />
		<MaxRows Sequence="4" value="1" RowToFetchFromSql="1" />
		</table>
		<table name="UserPRM">
		<MaxRows Sequence="0" value="250" RowToFetchFromSql="250" />
		<MaxRows Sequence="1" value="100" RowToFetchFromSql="100" />
		<MaxRows Sequence="2" value="75" RowToFetchFromSql="75" />
		<MaxRows Sequence="3" value="25" RowToFetchFromSql="25" />
		<MaxRows Sequence="4" value="1" RowToFetchFromSql="1" />
		</table>
		<table name="ListFormattingTemplate">
		<MaxRows Sequence="0" value="20" RowToFetchFromSql="10" />
		<MaxRows Sequence="1" value="15" RowToFetchFromSql="7" />
		<MaxRows Sequence="2" value="10" RowToFetchFromSql="5" />
		<MaxRows Sequence="3" value="5" RowToFetchFromSql="2" />
		<MaxRows Sequence="4" value="1" RowToFetchFromSql="1" />
		</table>
		<table name="PatientHistoryComment">
			<MaxRows Sequence="0" value="20" RowToFetchFromSql="10" />
			<MaxRows Sequence="1" value="15" RowToFetchFromSql="7" />
			<MaxRows Sequence="2" value="10" RowToFetchFromSql="5" />
			<MaxRows Sequence="3" value="5" RowToFetchFromSql="2" />
			<MaxRows Sequence="4" value="1" RowToFetchFromSql="1" />
		</table>
	</tables>'
	)

	IF EXISTS (
		SELECT TOP 1 *
		FROM @ReplicationSettings_TBL AS vrs
			INNER JOIN [ReplicationSettings] AS rs ON vrs.[ReplicationSettingsUid] = rs.[ReplicationSettingsUid]
	)
	BEGIN
		UPDATE [ReplicationSettings]
			SET [XMLValue] = vrs.[XMLValue]
		FROM @ReplicationSettings_TBL AS vrs
			INNER JOIN [ReplicationSettings] AS rs ON vrs.[ReplicationSettingsUid] = rs.[ReplicationSettingsUid]
		WHERE CAST (vrs.[XMLValue] AS [varchar](max)) <> CAST (rs.[XMLValue] AS [varchar](max))
	END
	ELSE
	BEGIN
		INSERT [ReplicationSettings] ([ReplicationSettingsUid], [Name], [XMLValue], [UserDefined], [LastModifiedDate])
		SELECT vrs.[ReplicationSettingsUid],
			   vrs.[Name],
			   vrs.[XMLValue],
			   vrs.[UserDefined],
			   vrs.[LastModifiedDate]
		FROM @ReplicationSettings_TBL AS vrs
			LEFT OUTER JOIN [ReplicationSettings] AS rs ON vrs.[ReplicationSettingsUid] = rs.[ReplicationSettingsUid]
		WHERE rs.[ReplicationSettingsUid] IS NULL
	END

END

-- #48737 - correct registrion url
IF EXISTS(SELECT *
          FROM TransmissionConfiguration
          WHERE TransmissionType IN('INBOUND','ProviderDirectory', 'ELGREQ', 'RXHREQ')
            AND RegistrationURL IN('https://integration.aprima.com/communityexchange/partner/PartnerService',
                                   'https://cprxmedhist.aprima.com/communityexchange/partner/PartnerService'))
BEGIN
   UPDATE TransmissionConfiguration
   SET RegistrationURL = 'https://cpintegrationservice.aprima.com/communityexchange/partner/PartnerService'
   WHERE TransmissionType IN('INBOUND')
     AND RegistrationURL = 'https://integration.aprima.com/communityexchange/partner/PartnerService'

   -- No registration service currently exposed on the Benefits/MedHx Server
   UPDATE TransmissionConfiguration
   SET RegistrationURL = NULL
   WHERE TransmissionType IN('ELGREQ', 'RXHREQ')
     AND RegistrationURL = 'https://cprxmedhist.aprima.com/communityexchange/partner/PartnerService'

   UPDATE TransmissionConfiguration
   SET RegistrationURL = 'https://cpssdirectoryservice.aprima.com/communityexchange/partner/PartnerService'
   WHERE TransmissionType IN('ProviderDirectory')
     AND RegistrationURL = 'https://integration.aprima.com/communityexchange/partner/PartnerService'

   -- reset all mailbox creation counters
   DELETE ListProductParameter where ParameterName = 'CreateCorepointMailboxAttempt'
END
GO

-- 49454
UPDATE ListProductParameter
SET XMLValue = '<BeaconPDS>'
             +    '<Staging>'
             +       '<SoapURL>https://svcslbs-stage.beaconlbs.com:7010/lbs-integ-service_v2/services</SoapURL>'
             +       '<BrowseURL>https://stage.beaconlbs.com/lbs-integ-web/lbs/ds/order/outcome?redirectUrl=http://localhost</BrowseURL>'
             +       '<UserName>sys_aprima</UserName>'
             +       '<Password>Wf6Rr9Vz5</Password>'
             +    '</Staging>'
             +    '<Production>'
             +       '<SoapURL>https://svcslbs.beaconlbs.com:7010/lbs-integ-service_v2/services</SoapURL>'
             +       '<BrowseURL>https://www.beaconlbs.com/lbs-integ-web/lbs/ds/order/outcome?redirectUrl=http://localhost</BrowseURL>'
             +       '<UserName>sys_aprima</UserName>'
             +       '<Password>Gr2Dn6Zw4</Password>'
             +    '</Production>'
             + '</BeaconPDS>'
WHERE ProductParameterUid = '04D9DEFA-7FAA-41D4-BE71-8A185686561B'
GO

-- 45532 this script can be rerun without issues, but the update must run before the delete
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	update hospitalround set ExternalTypeUid = null
	where ExternalTypeUid = 'CDB32BB9-25B8-4598-85C2-ECA33D3B854C'

	delete from listmisc
	where miscuid = 'CDB32BB9-25B8-4598-85C2-ECA33D3B854C'
END	
GO

-- Bug 49355 dhurtig migration: RecordDisclosureAudit PatientReferralUid if not set and AttachmentGroupUid is not null
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	UPDATE RecordDisclosureAudit
	  SET
		LastModifiedDate = GETUTCDATE(),
		PatientReferralUid = rag.PatientReferralUid
	  FROM RecordDisclosureAudit rda
	  JOIN RelAttachmentGroup rag ON rag.AttachmentGroupUid = rda.AttachmentGroupUid
	  WHERE rda. PatientReferralUid IS NULL AND rda.AttachmentGroupUid IS NOT NULL AND rag.PatientReferralUid IS NOT NULL
 END
 GO
 
 -- dhurtig Bug 48951 Allow Provider Directory instnaces to be deleted for Nitor
update ListIntegrationPartner set ProviderEditDeleteAllowed=1, LastModifiedDate = GETUTCDATE() where  IntegrationPartnerUid='8053BC8F-0BEA-41DA-8A2F-4FC7D6DA65D5' AND ProviderEditDeleteAllowed != 1
update ListIntegrationPartner set ProviderEditDeleteAllowed=1, LastModifiedDate = GETUTCDATE() where  IntegrationPartnerUid='C13EC1BC-6D2E-4C4C-A6C4-732CA1AE1D14' AND ProviderEditDeleteAllowed != 1
GO

-- Bug 48951 dhurtig Add index attribute to Inactive 
update listfindtable set columns ='<FindColumn name="RelSenderDirectAddressUid" index="guid" visible="false" />
<FindColumn name="DirectAddress" caption="Direct Address" index="name" visible="true" width="300" />
<FindColumn name="Name" caption="Name" visible="true" width="150" />
<FindColumn name="IntegrationPartnerName" caption="IntegrationPartnerName" visible="true" width="100" />
<FindColumn name="IntegrationPartnerUid" caption="IntegrationPartner" visible="false" />
<FindColumn name="MessageRoutingName" caption="Message Routing Name" visible="true" width="100" />
<FindColumn name="IsDefault" caption="IsDefault" visible="true" width="50" />
<FindColumn name="IsProvider" caption="IsProvider" visible="true" width="50" />
<FindColumn name="IsOrganization" caption="IsOrganization" visible="false" width="50" />
<FindColumn name="Inactive" caption="Inactive" index="inactive" visible="true" width="50" />',
LastModifiedDate = GETUTCDATE()
where FindTableUid  ='28157F6D-CDED-4C76-993E-A384CE93BABA' AND
	(select CONVERT(XML, Columns).exist('//FindColumn[@name="Inactive" and @index="inactive"]')) = 0  
--select * from listfindtable where FindTableUid='28157F6D-CDED-4C76-993E-A384CE93BABA'
GO

-- Bug 45552 fix AdditionalOutboundXML for Nitor entries in TransmissionConfiguration
IF EXISTS(SELECT * FROM TransmissionConfiguration WHERE AdditionalOutboundXML IS NULL AND TransmissionType IN('NitorTestDirectMessage','NitorDirectMessage', 'NitorWithCertificateDirectMessage', 'NitorTestWithCertificateDirectMessage') AND dbo.Replication_IsReplicatedDB() = 0)
BEGIN
   UPDATE TransmissionConfiguration
   SET AdditionalOutboundXML = '<DirectMessage Name="Version" Value="1"/>'
                             + '<DirectMessage Name="DomainUserName" Value="aprima2@direct.aprima.com" />'
                             + '<DirectMessage Name="DomainPassword" Value="eFkrVXVkc2c2elk2M051bkY5Q0Y2QFch" />'
   WHERE TransmissionType = 'NitorWithCertificateDirectMessage'
     AND TransmissionConfigurationUid = 'EC8D81E2-FECD-4F25-A1A8-4806A77F077D'
     AND AdditionalOutboundXML IS NULL

   UPDATE TransmissionConfiguration
   SET AdditionalOutboundXML = '<DirectMessage Name="Version" Value="1"/>'
                             + '<DirectMessage Name="DomainUserName" Value="aprima@direct.aprima.com" />'
                             + '<DirectMessage Name="DomainPassword" Value="WXZwNWV6MzcyVkdmYXI5OA==" />'
   WHERE TransmissionType = 'NitorDirectMessage'
     AND TransmissionConfigurationUid = 'DCDC91FC-F650-4FC2-B0F5-46531D92B1B4'
     AND AdditionalOutboundXML IS NULL

   UPDATE TransmissionConfiguration
   SET AdditionalOutboundXML = '<DirectMessage Name="Version" Value="1"/>'
                             + '<DirectMessage Name="DomainUserName" Value="aprima@direct.test.hispdirect.com" />'
                             + '<DirectMessage Name="DomainPassword" Value="MjY3WHJDcFVCeA==" />'
   WHERE TransmissionType = 'NitorTestDirectMessage'
     AND TransmissionConfigurationUid = '1EE4E9AB-0AA6-4A89-B94F-043F691D8A40'
     AND AdditionalOutboundXML IS NULL

   UPDATE TransmissionConfiguration
   SET AdditionalOutboundXML = '<DirectMessage Name="Version" Value="1"/>'
                             + '<DirectMessage Name="DomainUserName" Value="aprima@direct.test.hispdirect.com" />'
                             + '<DirectMessage Name="DomainPassword" Value="MjY3WHJDcFVCeA==" />'
   WHERE TransmissionType = 'NitorTestWithCertificateDirectMessage'
     AND TransmissionConfigurationUid = 'EA0C57A2-F1BE-40C3-B2F7-CA9F9E1A9618'
     AND AdditionalOutboundXML IS NULL
END
GO

-- 51199  2016.Jul.19 DJOST Make patient portal message routing default to ServiceSite/Provider
IF EXISTS(SELECT * FROM ListProductParameter WHERE ProductParameterUid = 'BA5D6DF9-8124-4A90-94C3-2FE739597F1C')
BEGIN
  UPDATE ListProductParameter 
  SET BoolValue = 1, UserDefined = 0, LastModifiedDate = getutcdate() 
  WHERE ProductParameterUid = 'BA5D6DF9-8124-4A90-94C3-2FE739597F1C'
END
GO

-- 51207 - update find table entry for find batch process type 
update ListFindTable 
	set FindControlClass = 'iMedica.Prm.Client.UI.PrmGeneralControls.Find.ControlFindBatchProcessType',
	CustomDBAccessClassName = 'iMedica.Prm.Client.UI.PrmGeneralControls.Find.ControlFindBatchProcessTypeFindDBAccess',
	AllowNew = 0,
	AllowDelete = 0
	where FindTableUid = '7F96DBE4-648E-46CE-BAFD-997B78660726'
GO

-- Bug 51824 Unable to setup provider direct mail address in the provider directory because the system is reading the client has allocated the 2 direct address
-- provider: dangling direct address
delete sda
from RelSenderDirectAddress sda 
inner join RelIntegrationPartnerDirectAddress ipa on ipa.RelIntegrationPartnerDirectAddressUid = sda.RelIntegrationPartnerDirectAddressUid
left join ProviderDirectory ssd on ssd.ProviderUid = sda.ProviderUid
                               and ssd.DirectAddress = ipa.DirectAddress
where ipa.IntegrationPartnerUid = '4D1BC44B-31F5-4B41-8F50-A95047266FFC'
  and sda.ProviderUid IS NOT NULL
  and ssd.ProviderDirectoryUid IS NULL

-- practice and servicesite: dangling direct address
delete sda
from RelSenderDirectAddress sda 
inner join RelIntegrationPartnerDirectAddress ipa on ipa.RelIntegrationPartnerDirectAddressUid = sda.RelIntegrationPartnerDirectAddressUid
left join OrganizationDirectory ssd on ISNULL(ssd.ServiceSiteUid, '00000000-0000-0000-0000-000000000000') = ISNULL(sda.ServiceSiteUid, '00000000-0000-0000-0000-000000000000')
                               and ssd.DirectAddress = ipa.DirectAddress
where ipa.IntegrationPartnerUid = '4D1BC44B-31F5-4B41-8F50-A95047266FFC'
  and sda.ProviderUid IS NULL
  and ssd.OrganizationDirectoryUid IS NULL

-- duplicate entries - retain oldest entry
delete sda
from RelSenderDirectAddress sda
inner join RelSenderDirectAddress dup on dup.RelIntegrationPartnerDirectAddressUid = sda.RelIntegrationPartnerDirectAddressUid
where sda.LastModifiedDate > dup.LastModifiedDate
  and ISNULL(sda.ProviderUid, '00000000-0000-0000-0000-000000000000') = ISNULL(dup.ProviderUid, '00000000-0000-0000-0000-000000000000')
  and ISNULL(sda.ServiceSiteUid, '00000000-0000-0000-0000-000000000000') = ISNULL(dup.ServiceSiteUid, '00000000-0000-0000-0000-000000000000')

-- if still duplicate - then retain lowest uid
delete sda
from RelSenderDirectAddress sda
inner join RelSenderDirectAddress dup on dup.RelIntegrationPartnerDirectAddressUid = sda.RelIntegrationPartnerDirectAddressUid
where sda.RelSenderDirectAddressUid > dup.RelSenderDirectAddressUid
  and ISNULL(sda.ProviderUid, '00000000-0000-0000-0000-000000000000') = ISNULL(dup.ProviderUid, '00000000-0000-0000-0000-000000000000')
  and ISNULL(sda.ServiceSiteUid, '00000000-0000-0000-0000-000000000000') = ISNULL(dup.ServiceSiteUid, '00000000-0000-0000-0000-000000000000')
GO

-- 50475 fix for bug #50475
update ListAgeGroup SET StartDays = 7666 where AgeGroupUid =  '00000000-0000-0000-0000-000000000001'
go
update ListAgeGroup SET EndDays = 7665 where AgeGroupUid =  '00000000-0000-0000-0000-000000000002'
go

-- 52230
IF NOT EXISTS(SELECT * FROM ListObservationItem WHERE ObservationItemUid = '4C580E21-46F4-4BEA-962B-2582B43B4434')
BEGIN
	INSERT INTO ListObservationItem
	VALUES
	('4C580E21-46F4-4BEA-962B-2582B43B4434',NULL,0,'Feeling down, depressed or hopeless.',NULL,	NULL,2,4,'',0,NULL,1,'49468EA1-FF76-45F9-9613-9EC775A1CC3B',NULL,171207006,'00000000-0000-0000-0000-000553243016',2,0,NULL,'2014-10-14 11:02:02.703')
END
IF NOT EXISTS(SELECT * FROM ListObservationItem WHERE ObservationItemUid = 'B3341801-B7CC-45BE-9CEE-0DE801021E2C')
BEGIN
	INSERT INTO ListObservationItem
	VALUES
	('B3341801-B7CC-45BE-9CEE-0DE801021E2C',NULL,0,'Little interest in doing things.',NULL,NULL,2,4,'',0,NULL,1,'49468EA1-FF76-45F9-9613-9EC775A1CC3B',NULL,171207006,'00000000-0000-0000-0000-000553243016',2,0,NULL,'2014-10-14 11:02:02.703')
END
GO

-- 53253 Associate Patient Dashboard Widgets to Plan Category Nodes
IF(NOT(EXISTS(SELECT [PatientDashboardUid] FROM [ListPatientDashboard] WHERE [PatientDashboardUid] = '23A63F6D-1FD1-4BF0-888E-000000000003')))
	INSERT [dbo].[ListPatientDashboard]
		([PatientDashboardUid], [ExternalID], [Name], [DisplayOrder], [UserDefined], [PhoneConfigurationXml], [TabletConfigurationXml], [DesktopConfigurationXml], [LastModifiedByUid], [LastModifiedDate])
	VALUES
		(
			N'23a63f6d-1fd1-4bf0-888e-000000000003', NULL, N'Plan', 2, 0,
			N'<ConfigurationDto xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema"><Tiles><TileDto><Id>8a981a34-7e34-4aa3-bcdc-07742b1b9d7b</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000006</TileDescriptorId><Name>medications</Name><Heading>Active Medications</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>5ca010ff-8019-43ee-9194-987b573f367b</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000008</TileDescriptorId><Name>orders</Name><Heading>Outstanding Orders</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>e0224f4a-6221-4903-b942-b79d6b4fee0b</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000007</TileDescriptorId><Name>observationResults</Name><Heading>Observation Results</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>a7c96976-5370-4b9d-a550-b5ea8d7795e6</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000013</TileDescriptorId><Name>attachments</Name><Heading>Attachments</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>f050a485-c4c3-43c4-83cb-1bbe290ec66f</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000002</TileDescriptorId><Name>appointments</Name><Heading>Appointments</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>23a63f6d-1fd1-4bf0-8881-479146955138</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000005</TileDescriptorId><Name>healthMaintenanceReminders</Name><Heading>Health Reminders</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>false</IsCollapsed></TileDto><TileDto><Id>23a63f6d-1fd1-4bf0-8881-479146957589</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000016</TileDescriptorId><Name>recalls</Name><Heading>Recalls</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>false</IsCollapsed></TileDto></Tiles></ConfigurationDto>', 
			N'<ConfigurationDto xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema"><Tiles><TileDto><Id>8a981a34-7e34-4aa3-bcdc-07742b1b9d7b</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000006</TileDescriptorId><Name>medications</Name><Heading>Active Medications</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>5ca010ff-8019-43ee-9194-987b573f367b</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000008</TileDescriptorId><Name>orders</Name><Heading>Outstanding Orders</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>e0224f4a-6221-4903-b942-b79d6b4fee0b</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000007</TileDescriptorId><Name>observationResults</Name><Heading>Observation Results</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>a7c96976-5370-4b9d-a550-b5ea8d7795e6</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000013</TileDescriptorId><Name>attachments</Name><Heading>Attachments</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>f050a485-c4c3-43c4-83cb-1bbe290ec66f</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000002</TileDescriptorId><Name>appointments</Name><Heading>Appointments</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>23a63f6d-1fd1-4bf0-8881-479146955138</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000005</TileDescriptorId><Name>healthMaintenanceReminders</Name><Heading>Health Reminders</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>false</IsCollapsed></TileDto><TileDto><Id>23a63f6d-1fd1-4bf0-8881-479146957589</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000016</TileDescriptorId><Name>recalls</Name><Heading>Recalls</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>false</IsCollapsed></TileDto></Tiles></ConfigurationDto>',
			N'<ConfigurationDto xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema"><Tiles><TileDto><Id>8a981a34-7e34-4aa3-bcdc-07742b1b9d7b</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000006</TileDescriptorId><Name>medications</Name><Heading>Active Medications</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>5ca010ff-8019-43ee-9194-987b573f367b</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000008</TileDescriptorId><Name>orders</Name><Heading>Outstanding Orders</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>e0224f4a-6221-4903-b942-b79d6b4fee0b</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000007</TileDescriptorId><Name>observationResults</Name><Heading>Observation Results</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>a7c96976-5370-4b9d-a550-b5ea8d7795e6</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000013</TileDescriptorId><Name>attachments</Name><Heading>Attachments</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>f050a485-c4c3-43c4-83cb-1bbe290ec66f</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000002</TileDescriptorId><Name>appointments</Name><Heading>Appointments</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>true</IsCollapsed></TileDto><TileDto><Id>23a63f6d-1fd1-4bf0-8881-479146955138</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000005</TileDescriptorId><Name>healthMaintenanceReminders</Name><Heading>Health Reminders</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>false</IsCollapsed></TileDto><TileDto><Id>23a63f6d-1fd1-4bf0-8881-479146957589</Id><TileDescriptorId>259e6a7b-64a8-437c-82b7-000000000016</TileDescriptorId><Name>recalls</Name><Heading>Recalls</Heading><ColumnSpan>1</ColumnSpan><IsCollapsed>false</IsCollapsed></TileDto></Tiles></ConfigurationDto>',
			NULL, getdate()
		)
GO

-- Bug 54987:Batch Statement XML - Update version number in the ListProductParameter table.
IF EXISTS (SELECT ProductParameterUid FROM ListProductParameter WHERE ProductParameterUid = 'A4E1DB3A-5473-48B8-88E4-0ECCCBC728E5' and ParameterName = 'eStatement.Version')
BEGIN
	UPDATE ListProductParameter
	SET StringValue = '201702'
	WHERE ProductParameterUid = 'A4E1DB3A-5473-48B8-88E4-0ECCCBC728E5' and ParameterName = 'eStatement.Version'
END
GO

-- 55321 Enable CCDA Type batch Process
if  EXISTS(select * from ListBatchProcessType where BatchProcessTypeUid='10000101-0000-0000-0000-000000000001')
BEGIN
	update ListBatchProcessType set Hide=0, 
        AutoStartDetail=1,
        ProcessAQN='FrameworkBO.BatchProcessHandlers.PatientDocuments.GenerateCCDA'
        where BatchProcessTypeUid='10000101-0000-0000-0000-000000000001'
END
GO

-- fix bug #55410 - Mark shipped ListFormLayout AllowMulti false
update ListFormLayout set AllowMulti = 0  where UserDefined = 0
GO

-- #55543 Disable login of parent when patient turns X age old
IF (NOT EXISTS (SELECT * FROM ListProductParameter WHERE ProductParameterUid = 'D399A32D-5ECE-4063-914B-8CF77BC02F9A'))
BEGIN 
insert into ListProductParameter values('D399A32D-5ECE-4063-914B-8CF77BC02F9A', 'PatientPortal LegalAgeToConsent', null, null, null, -1, null, null, null, null, null, null, 0, 0, GETDATE(), null)
END
IF (NOT EXISTS (SELECT * FROM ListJob WHERE JobUid = 'B64F80B0-87E6-4260-A9DE-22ABF9F16165'))
BEGIN 
insert into ListJob values('B64F80B0-87E6-4260-A9DE-22ABF9F16165', null, 'Patient Portal Age Transition', 0, '', 'iMedica.Framework.Utility.PatientPortalAgeTransitionJob', 'iMedica.Prm.Client.UI.JobEngine.ControlPatientPortalAgeTransitionJob', 0, 0, null, GETDATE(), 0, null)
END

-- #56026  Adding CCM procedure codes to database should not duplicate if already in user's database
if(not exists(select * from ListProcedure where Code='99487'))--ProcedureUid='7DBA8CD6-FFF4-4167-8223-0AE9A52361D5'))
begin
insert into ListProcedure(ProcedureUid, ExternalID, Inactive, Code, MasterProcedureUid, ProcedureCodeTypeUid, ShortDescription, LongDescription,
IsEM, DefaultDontClaim, EffectiveDate, Unit, GenerateObservationOrder, UsePracticeTaxableOption, TaxableOption, IncludeInPatientProcedure,
ShortDescriptionChangedFromMaster, UserDefined, LastModifiedDate, ImageResultsDirectlyAccessible, RequireDpn)
select '7DBA8CD6-FFF4-4167-8223-0AE9A52361D5', '99487', 0, '99487', '1B6D3304-B3E7-4BAA-A2BA-3DC9E18CE4F6',
'00000000-0000-0000-0000-000000000001', 'CMPLX CHRON CARE W/O PT VSIT', 'Complex chronic care management services, with the following required elements: multiple (two or more) chronic conditions expected to last at least 12 months, or until the death of the patient, chronic conditions place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline, establishment or substantial revision of a comprehensive care plan, moderate or high complexity medical decision making; 60 minutes of clinical staff time directed by a physician or other qualified health care professional, per calendar month.;',
1, 0, '2012-12-05', 1, 0, 1, 0, 1, 0, 0, GETUTCDATE(), 0, 0
end

if(not exists(select * from ListProcedure where Code='99489'))--ProcedureUid='DF8EAC0B-A311-4AB6-A826-6135C7D34214'))
begin
insert into ListProcedure(ProcedureUid, ExternalID, Inactive, Code, MasterProcedureUid, ProcedureCodeTypeUid, ShortDescription, LongDescription,
IsEM, DefaultDontClaim, EffectiveDate, Unit, GenerateObservationOrder, UsePracticeTaxableOption, TaxableOption, IncludeInPatientProcedure,
ShortDescriptionChangedFromMaster, UserDefined, LastModifiedDate, ImageResultsDirectlyAccessible, RequireDpn)
select 'DF8EAC0B-A311-4AB6-A826-6135C7D34214', '99489', 0, '99489', 'EBD5D842-CD35-4593-AC95-F9C780FEF22B',
'00000000-0000-0000-0000-000000000001', 'CMPLX CHRON CARE ADDL 30 MIN', 'Complex chronic care management services, with the following required elements: multiple (two or more) chronic conditions expected to last at least 12 months, or until the death of the patient, chronic conditions place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline, establishment or substantial revision of a comprehensive care plan, moderate or high complexity medical decision making; 60 minutes of clinical staff time directed by a physician or other qualified health care professional, per calendar month.; each additional 30 minutes of clinical staff time directed by a physician or other qualified health care professional, per calendar month (list separately in addition to code for primary procedure)',
1, 0, '2012-12-05', 1, 0, 1, 0, 1, 0, 0, GETUTCDATE(), 0, 0
end

if(not exists(select * from ListProcedure where Code='99490'))--ProcedureUid='91C3BFB0-587A-4763-9DE9-9C0B76DABD61'))
begin
insert into ListProcedure(ProcedureUid, ExternalID, Inactive, Code, MasterProcedureUid, ProcedureCodeTypeUid, ShortDescription, LongDescription,
IsEM, DefaultDontClaim, EffectiveDate, Unit, GenerateObservationOrder, UsePracticeTaxableOption, TaxableOption, IncludeInPatientProcedure,
ShortDescriptionChangedFromMaster, UserDefined, LastModifiedDate, ImageResultsDirectlyAccessible, RequireDpn)
select '91C3BFB0-587A-4763-9DE9-9C0B76DABD61', '99490', 0, '99490', '2615D86B-5F1B-4DEE-B704-6696192FB75F',
'00000000-0000-0000-0000-000000000001', 'CHRON CARE MGMT SRVC 20 MIN', 'Chronic care management services, at least 20 minutes of clinical staff time directed by a physician or other qualified health care professional, per calendar month, with the following required elements: multiple (two or more) chronic conditions expected to last at least 12 months, or until the death of the patient; chronic conditions place the patient at significant risk of death, acute exacerbation/decompensation, or functional decline; comprehensive care plan established, implemented, revised, or monitored.',
0, 0, '2014-11-18', 1, 0, 1, 0, 1, 0 , 0, GETUTCDATE(), 0, 0
end
GO

--  #55063 - Voice transcription columns not resizing
if (not exists(select * from ListFindTable where FindTableUid = 'F2D43416-1007-466D-B017-4B619FFA0143'))
begin

	INSERT INTO [dbo].[ListFindTable]
			   ([FindTableUid]
			   ,[ExternalId]
			   ,[Name]
			   ,[SecurityGroupUid]
			   ,[Id]
			   ,[ShowInListEditor]
			   ,[LoadPriority]
			   ,[Prepopulate]
			   ,[HasSecurity]
			   ,[AllowMaintenance]
			   ,[AllowNew]
			   ,[AllowDelete]
			   ,[AllowImport]
			   ,[AllowExport]
			   ,[AllowHide]
			   ,[LimitMaintenanceOnNonUserDefined]
			   ,[ExternalIdWildcard]
			   ,[BeginningWildcard]
			   ,[SizableFindDialog]
			   ,[BusinessObjectRequired]
			   ,[LoadStoredProcedure]
			   ,[CustomDBAccessClassName]
			   ,[FindControlClass]
			   ,[EditFormType]
			   ,[BusinessObject]
			   ,[BusinessObjectSpans]
			   ,[EditBusinessObject]
			   ,[ExportBusinessObjectList]
			   ,[SaveAsBusinessObject]
			   ,[MaxRows]
			   ,[Columns]
			   ,[Notes]
			   ,[Inactive]
			   ,[UserDefined]
			   ,[AuditTableName]
			   ,[AddInUid]
			   ,[LicenseCode]
			   ,[LastModifiedDate]
			   ,[LastModifiedByUid]
			   ,[MapMerge])
		 VALUES
			   (
			   'F2D43416-1007-466D-B017-4B619FFA0143' --<FindTableUid, uniqueidentifier,>
			   ,null --<ExternalId, varchar(25),>
			   ,'VoiceTranscriptionReoprt' --<Name, varchar(50),>
			   ,null --<SecurityGroupUid, uniqueidentifier,>
			   ,'VoiceTranscriptionReoprt' --<Id, varchar(50),>
			   ,0 --<ShowInListEditor, bit,>
			   ,0 --<LoadPriority, smallint,>
			   ,0 --<Prepopulate, smallint,>
			   ,0 --<HasSecurity, bit,>
			   ,0 --<AllowMaintenance, bit,>
			   ,0 --<AllowNew, bit,>
			   ,0 --<AllowDelete, smallint,>
			   ,0 --<AllowImport, bit,>
			   ,0 --<AllowExport, bit,>
			   ,0 --<AllowHide, bit,>
			   ,0 --<LimitMaintenanceOnNonUserDefined, bit,>
			   ,0 --<ExternalIdWildcard, bit,>
			   ,0 --<BeginningWildcard, bit,>
			   ,0 --<SizableFindDialog, bit,>
			   ,0 --<BusinessObjectRequired, bit,>
			   ,null --<LoadStoredProcedure, varchar(255),>
			   ,null --<CustomDBAccessClassName, varchar(255),>
			   ,null --<FindControlClass, varchar(255),>
			   ,null --<EditFormType, varchar(255),>
			   ,null --<BusinessObject, varchar(255),>
			   ,null --<BusinessObjectSpans, varchar(255),>
			   ,null --<EditBusinessObject, varchar(255),>
			   ,null --<ExportBusinessObjectList, varchar(max),>
			   ,null --<SaveAsBusinessObject, varchar(255),>
			   ,100 --<MaxRows, int,>
			   ,'<FindColumn name="Urgent" caption="" visible="true" width="22" resizable="false" /><FindColumn name="Status" visible="true" caption="Status" width="65" /><FindColumn name="Recorded" caption="Recorded" visible="true" width="90" /><FindColumn name="Merged" caption="Merged" visible="true" width="80" /><FindColumn name="Send" visible="true" caption="Send" width="65" /><FindColumn name="Received" visible="true" caption="Received" width="90" /><FindColumn name="Patient" visible="true" caption="Patient" width="110" /><FindColumn name="Provider" visible="true" caption="Recorded By" width="110" /><FindColumn name="Transcriptionist" visible="true" caption="Transcriptionist" resizable="true" width="130" /><FindColumn name="AttachmentType" visible="true" caption="Attachment Type" resizable="true" width="140" /><FindColumn name="InNoteDictation" visible="true" caption="In note" width="75" /><FindColumn name="Filename" visible="true" caption="Filename" resizable="true" width="110" />' --<Columns, xml,>
			   ,null --<Notes, varchar(max),>
			   ,0 --<Inactive, bit,>
			   ,0 --<UserDefined, tinyint,>
			   ,null --<AuditTableName, varchar(50),>
			   ,null --<AddInUid, uniqueidentifier,>
			   ,null --<LicenseCode, varchar(50),>
			   ,'03/14/2017' --<LastModifiedDate, datetime,>
			   ,null --<LastModifiedByUid, uniqueidentifier,>
			   ,0 --<MapMerge, bit,>
			   )
end
go


-- Fixed bug #56059 - medication frequency shipping with incorrect information
update ListMedicationFrequency set PatientInstructions = 'every night at bedtime', LastModifiedDate = '03/09/2017'  where MedicationFrequencyUid = 'B5C1C641-B5C7-4D85-B38F-10845DA18DC6'
go

-- fix bug #56277 - Linked problems not showing in 'related' field for Diagnosis in Patient Problem/diagnosis history
update ListFindTable set [Columns] = '<FindColumn name="Name" caption="Problem" index="name" visible="true" width="300" /><FindColumn name="PatientProblemDiagnosisUid" index="guid" visible="false" />',
	BusinessObject = 'PatientProblemDiagnosis'
	where FindTableUid = 'B006033A-36BD-4D29-912B-BFB788C64D7D'
go

-- #56367 - Update the PMBC information for V2.0
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
UPDATE ListProductParameter
SET
  LastModifiedDate = GETUTCDATE(),   -- force replication
  XMLValue = '<PatientMedicationBenefitCheck>
    <Field Description="NDC" Property="MedicationSIG.NDC" XPath="/Results/RelVisitMedication/MedicationSIG" XAttribute="NDC" Required="True" />
    <Field Description="Patient Eligibility" Property="MedicationSIG.PatienteRxEligibilityUid" XPath="/Results/RelVisitMedication/MedicationSIG" XAttribute="PatienteRxEligibilityUid" Required="True" />
    <Field Description="Pharmacy" Property="MedicationSIG.PharmacyUid" XPath="/Results/RelVisitMedication/MedicationSIG/Pharmacy" XAttribute="PharmacyUid" Required="True" />
    <!-- C48542=Tablet; C64696=Caplet C48480=Capsule -->
    <Field Description="Quantity" Property="MedicationSIG.FirstSIGDetail.QuantityTrim" XPath="/Results/RelVisitMedication/MedicationSIG/SIGDetail" XAttribute="Quantity" Required="True" Default="1">
      <Default Attribute="UOM" Code="C48542" Value="30" />
      <Default Attribute="UOM" Code="C64696" Value="30" />
      <Default Attribute="UOM" Code="C48480" Value="30" />
   </Field>
    <Field Description="Days Supply" Property="MedicationSIG.FirstSIGDetail.Duration" XPath="/Results/RelVisitMedication/MedicationSIG/SIGDetail" XAttribute="Duration" Required="True" Default="1" NullValue="0">
      <Default Attribute="UOM" Code="C48542" Value="30" />
      <Default Attribute="UOM" Code="C64696" Value="30" />
      <Default Attribute="UOM" Code="C48480" Value="30" />
   </Field>
    <Field Description="UOM" Property="MedicationSIG.PotencyUnitCode" XPath="/Results/RelVisitMedication/MedicationSIG" XAttribute="PotencyUnitCode" Required="True" />
</PatientMedicationBenefitCheck>'
WHERE ParameterName = 'Surescripts.PatientMedicationBenefitCheck'
END
GO

-- 
-- Date        : 2017.May.8
-- TFS Bug     : #57072 : Update Easy Pay service reference in Application Server to
--                        to ApiCardProcAprimaR201
-- Description : Update service reference in Application Server (WSDL) to R201
--               and respective ListProductParameter entry to 
--               https://easypay5.com/APIcardProcAprimaR201/   
--
IF EXISTS (SELECT * 
           FROM  [dbo].[ListProductParameter] 
		   WHERE [ProductParameterUid] = 'D3B3B2B8-1670-4CCD-9520-FCA769FD9E7D' 
		           AND [StringValue] IS NOT NULL 
                           AND [StringValue] != ''
                           AND [StringValue] != 'https://easypay5.com/APIcardProcAprimaR201/')
BEGIN
  UPDATE [dbo].[ListProductParameter] 
    SET  [StringValue]         = 'https://easypay5.com/APIcardProcAprimaR201/',
	 [LastModifiedDate]    = GETUTCDATE(),
         [UserDefined]         = 2
  WHERE  [ProductParameterUid] = 'D3B3B2B8-1670-4CCD-9520-FCA769FD9E7D'
END
GO

--- bug #58002 Change lable for 'Patient Survey' portal message to 'Patient Questionnaire'
IF EXISTS(select * from ListMessageSubType where MessageSubTypeUid='0266BE8E-73D2-452C-89FB-E16786EBDD94')
update ListMessageSubType set name='Patient Questionnaire' where MessageSubTypeUid='0266BE8E-73D2-452C-89FB-E16786EBDD94'
GO

-- #59476
if exists(select * from ListIntegrationPartner where IntegrationPartnerUid = '4ABFF2CF-606F-4A2A-9C45-71055B94C36E')
begin
update ListIntegrationPartner
set AdditionalOutboundXML = '<settings baseUrl="https://cp02.colo.com:32080/REST/RXCoupon" portalBaseUrl="https://www.samplemd.com/samplemd/resources/getResource/61/">
  <AutoPrintOptOut />
  <PortalOptOut />
</settings>', TestMode = 0
where IntegrationPartnerUid = '4ABFF2CF-606F-4A2A-9C45-71055B94C36E'
end

-- #60128
update hpm
      set fieldmappingtable = replace(FieldMappingTable,'UserPRMPerson.','')
      from HL7PartnerMessage hpm
      join hl7partner hp
      on hpm.hl7partneruid=hp.hl7partneruid
      where MessageType='VXU' and FieldMappingTable like '%userprmperson%'
GO

-- #60035
if exists(select * from ListIntegrationPartner where IntegrationPartnerUid = '4ABFF2CF-606F-4A2A-9C45-71055B94C36E')
begin
update ListIntegrationPartner
set AdditionalOutboundXML = '<settings corepointTestBaseUrl="https://cp02.colo.com:32080/REST/RXCoupon" corepointProdBaseUrl="https://integration.aprima.com/REST/RXCoupon" portalTestBaseUrl="https://stage.samplemd.com/samplemd/resources/getResource/61/" portalProdBaseUrl="https://www.samplemd.com/samplemd/resources/getResource/61/">
  <AutoPrintOptOut />
  <PortalOptOut />
</settings>'
where IntegrationPartnerUid = '4ABFF2CF-606F-4A2A-9C45-71055B94C36E'
end
GO