-- 45566 Script to activate Direct Mail Address capability (if it was not already activated)
IF dbo.Replication_IsReplicatedDB() = 0 AND EXISTS(SELECT * FROM TransmissionConfiguration WHERE TransmissionType = 'eRxProviderDirectory' AND ExportXMLLayout = 'eProviderDirectoryRequest.eRxService')
BEGIN
   UPDATE TransmissionConfiguration
   SET
      ExportXMLLayout  = 'eProviderDirectoryRequest_V4R6.eRxService',
      LastModifiedDate = DATEADD(MI, 10, LastModifiedDate)
   WHERE TransmissionType = 'eRxProviderDirectory'
     AND ExportXMLLayout = 'eProviderDirectoryRequest.eRxService'

   -- 10
   DECLARE @InterfaceDetails [xml]
   SELECT @InterfaceDetails = [InterfaceDetails]
   FROM [ListPharmacyClearinghouse]
   WHERE [PharmacyClearinghouseUid] = '118422AA-C165-4A2E-8389-E5B7E89636EA'

   SET @InterfaceDetails.modify('replace value of (/root/@fullPharmacyList)[1] with ''true''')
   SET @InterfaceDetails.modify('replace value of (/root/@fullPrescriberList)[1] with ''true''')

   UPDATE [ListPharmacyClearinghouse]
   SET
      [InterfaceDetails] = @InterfaceDetails,
      [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [PharmacyClearinghouseUid] = '118422AA-C165-4A2E-8389-E5B7E89636EA'

   -- 11
   DECLARE @LastModifiedDate [datetime] = '2015-07-08 14:25:26.100',
      @eRxMessageTypeUid [uniqueidentifier] = 'CE675E1B-3B82-4EC3-8D7B-3B1A027E42B4',  -- InboundMessageRoutingRegistration
      @IntegrationPartnerUid [uniqueidentifier] = '118422AA-C165-4A2E-8389-E5B7E89636EA'

   DECLARE @TransmissionConfiguration_TBL TABLE (
      [TransmissionConfigurationUid] [uniqueidentifier],
      [TransmissionType] [varchar](50),
      [CorepointClientID] [varchar](100),
      [CorepointMachineID] [varchar](100),
      [CorepointInboundConnectionID] [varchar](100),
      [CorepointOutboundConnectionID] [varchar](100),
      [CorepointUsername] [varchar](100),
      [CorepointPassword] [varchar](100),
      [AdditionalOutboundXML] [varchar](max),
      [AprimaVaultURL] [varchar](512),
      [AprimaVaultSubmissionURL] [varchar](512),
      [OverrideAprimaVaultURL] [varchar](512),
      [AprimaVaultSyncURL] [varchar](512),
      [RegistrationURL] [varchar](512),
      [TestMode] [bit],
      [TestAprimaVaultURL] [varchar](512),
      [TestAprimaVaultSubmissionURL] [varchar](512),
      [TestOverrideAprimaVaultURL] [varchar](512),
      [TestAprimaVaultSyncURL] [varchar](512),
      [TestRegistrationURL] [varchar](512),
      [AutoSend] [bit],
      [AutoDownload] [bit],
      [AutoProcessDownloads] [bit],
      [AutoQueue] [bit],
      [MaxSendAttempts] [int],
      [CorepointDataExportGeneratorAQN] [varchar](512),
      [CorepointSenderAQN] [varchar](512),
      [CorepointDownloaderAQN] [varchar](512),
      [CorepointDownloadProcessorAQN] [varchar](512),
      [OutboundQueueGeneratorAQN] [varchar](512),
      [ExportXMLLayout] [varchar](max),
      [ExportBusinessObjectName] [varchar](250),
      [ExportKeyLookupFieldName] [varchar](250),
      [Description] [varchar](512),
      [AutoQueueIntervalSeconds] [int],
      [AutoQueueLastRun] [datetime],
      [ForeignObjectUid] [uniqueidentifier],
      [ClaimClearingHouseUid] [uniqueidentifier],
      [IntegrationPartnerUid] [uniqueidentifier],
      [TransmissionAQN] [varchar](1024),
      [AdditionalConfigurationXML] [varchar](max),
      [UserDefined] [tinyint],
      [MessageDisplayAQN] [varchar](500),
      [MessageParserAQN] [varchar](500),
      [MessageUpdatesAQN] [varchar](500),
      [UpdateableConfiguration] [varchar](max),
      [HighlightConfiguration] [varchar](max),
      [LastModifiedDate] [datetime]
   )

   INSERT @TransmissionConfiguration_TBL(
      [TransmissionConfigurationUid],
      [TransmissionType],
      [CorepointMachineID],
      [CorepointInboundConnectionID],
      [CorepointOutboundConnectionID],
      --[TestAprimaVaultURL],
      [TestAprimaVaultSyncURL],
      [TestRegistrationURL],
      [AutoDownload],
      [AutoProcessDownloads],
      [MaxSendAttempts],
      --[CorepointDataExportGeneratorAQN],
      --[CorepointSenderAQN],
      --[CorepointDownloaderAQN],
      [CorepointDownloadProcessorAQN],
      --[OutboundQueueGeneratorAQN],
      [ExportXMLLayout],
      [ExportBusinessObjectName],
      [ExportKeyLookupFieldName],
      [Description],
      [IntegrationPartnerUid],
      [UserDefined],
      [MessageDisplayAQN],
      [MessageParserAQN],
      [MessageUpdatesAQN],
      [UpdateableConfiguration],
      [HighlightConfiguration],
      [LastModifiedDate]
   )
   SELECT
      [eRxMessageTypeUid] AS  [TransmissionConfigurationUid],
      [ExternalID] AS [TransmissionType],
      'InboundRoutingRegistration.eRxService' AS [CorepointMachineID],
      'IB' AS [CorepointInboundConnectionID],
      'OB' AS [CorepointOutboundConnectionID],
      'https://tiran:51375/communityexchange/partner/PartnerService' AS [TestAprimaVaultSyncURL],
      'https://tiran:51375/communityexchange/partner/PartnerService' AS [TestRegistrationURL],
      1 AS [AutoDownload],
      1 AS [AutoProcessDownloads],
      10 AS [MaxSendAttempts],
      --[CorepointDataExportGeneratorAQN],
      --[CorepointSenderAQN],
      --[CorepointDownloaderAQN],
      'iMedica.Framework.eRxCorepoint.Transmission.eRxInboundMessageDownloadProcessor, eRxCorepoint' AS [CorepointDownloadProcessorAQN],
      --[OutboundQueueGeneratorAQN],
      'InboundMessageRoutingRegistrationRequest.eRxService' AS [ExportXMLLayout],
      'eRxPRVBRDOutbound' AS [ExportBusinessObjectName],
      'eRxPRVBRDOutboundUid' AS [ExportKeyLookupFieldName],
      'eRx inbound message routing registration' AS [Description],
      @IntegrationPartnerUid AS [IntegrationPartnerUid],
      0 AS [UserDefined],
      'iMedica.Prm.Client.UI.EDI.eRx.ControleRxDisplay,iMedica.Prm.Client.UI' AS [MessageDisplayAQN],
      'iMedica.Prm.Client.UI.EDI.eRx.eRxParser,iMedica.Prm.Client.UI' AS [MessageParserAQN],
      'iMedica.Prm.Client.UI.EDI.eRx.ControleRxUpdates,iMedica.Prm.Client.UI' AS [MessageUpdatesAQN],
      '<update><element node="patient" attribute="lastName"/><element node="patient" attribute="firstname"/><element node="patient" attribute="middleName"/><element node="patient" attribute="prefix"/><element node="patient" attribute="suffix"/><element node="patient" attribute="DOB"/><element node="patient" attribute="gender"/><element node="patient" attribute="address1"/><element node="patient" attribute="address2"/><element node="patient" attribute="city"/><element node="patient" attribute="state"/><element node="patient" attribute="zip"/><element node="pharmacy" attribute="name"/><element node="pharmacy" attribute="phone"/><element node="med" attribute="dosageAmount"/><element node="med" attribute="quantity"/><element node="med" attribute="frequency"/><element node="med" attribute="startDate"/><element node="med" attribute="numRefills"/></update>' AS [UpdateableConfiguration],
      '<highlight><patient><element node="patient" attribute="lastName"/><element node="patient" attribute="firstName"/><element node="patient" attribute="DOB"/></patient><provider><element node="provider" attribute="lastName"/></provider><pharmacy><element node="pharmacy" attribute="name"/></pharmacy><servicesite/></highlight>' AS [HighlightConfiguration],
      @LastModifiedDate AS [LastModifiedDate]
   FROM [ListeRxMessageType]
   WHERE [eRxMessageTypeUid] = @eRxMessageTypeUid

   INSERT [TransmissionConfiguration](
      [TransmissionConfigurationUid],
      [TransmissionType],
      [CorepointMachineID],
      [CorepointInboundConnectionID],
      [CorepointOutboundConnectionID],
      --[TestAprimaVaultURL],
      [TestAprimaVaultSyncURL],
      [TestRegistrationURL],
      [AutoDownload],
      [AutoProcessDownloads],
      [MaxSendAttempts],
      --[CorepointDataExportGeneratorAQN],
      --[CorepointSenderAQN],
      --[CorepointDownloaderAQN],
      [CorepointDownloadProcessorAQN],
      --[OutboundQueueGeneratorAQN],
      [ExportXMLLayout],
      [ExportBusinessObjectName],
      [ExportKeyLookupFieldName],
      [Description],
      [IntegrationPartnerUid],
      [UserDefined],
      [MessageDisplayAQN],
      [MessageParserAQN],
      [MessageUpdatesAQN],
      [UpdateableConfiguration],
      [HighlightConfiguration],
      [LastModifiedDate]
   )
   SELECT
      vtc.[TransmissionConfigurationUid],
      vtc.[TransmissionType],
      vtc.[CorepointMachineID],
      vtc.[CorepointInboundConnectionID],
      vtc.[CorepointOutboundConnectionID],
      --vtc.[TestAprimaVaultURL],
      vtc.[TestAprimaVaultSyncURL],
      vtc.[TestRegistrationURL],
      vtc.[AutoDownload],
      vtc.[AutoProcessDownloads],
      vtc.[MaxSendAttempts],
      --[CorepointDataExportGeneratorAQN],
      --[CorepointSenderAQN],
      --[CorepointDownloaderAQN],
      vtc.[CorepointDownloadProcessorAQN],
      --[OutboundQueueGeneratorAQN],
      vtc.[ExportXMLLayout],
      vtc.[ExportBusinessObjectName],
      vtc.[ExportKeyLookupFieldName],
      vtc.[Description],
      vtc.[IntegrationPartnerUid],
      vtc.[UserDefined],
      vtc.[MessageDisplayAQN],
      vtc.[MessageParserAQN],
      vtc.[MessageUpdatesAQN],
      vtc.[UpdateableConfiguration],
      vtc.[HighlightConfiguration],
      vtc.[LastModifiedDate]
   FROM @TransmissionConfiguration_TBL AS vtc
      LEFT OUTER JOIN [TransmissionConfiguration] AS tc ON vtc.[TransmissionConfigurationUid] = tc.[TransmissionConfigurationUid]
   WHERE tc.[TransmissionConfigurationUid] IS NULL

   UPDATE [TransmissionConfiguration]
      SET [AutoDownload] = 0,
         [AutoProcessDownloads] = 0,
         [AutoQueue] = 0,
         [AutoSend] = 0,
         [MaxSendAttempts] = 10,
         [TestAprimaVaultURL] = null,
         [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [TransmissionConfigurationUid] = @eRxMessageTypeUid

   SET @eRxMessageTypeUid = 'B0484716-EA09-4EB3-BA50-CBD352D4351F'   -- PRVUPD::Prescriber Download

   INSERT TransmissionConfiguration(
      [TransmissionConfigurationUid],
      [TransmissionType],
      [CorepointMachineID],
      [CorepointInboundConnectionID],
      [CorepointOutboundConnectionID],
      [AprimaVaultURL],
      --[AprimaVaultSubmissionURL],
      --[RegistrationURL],
      [TestAprimaVaultURL],
      [TestAprimaVaultSubmissionURL],
      [TestRegistrationURL],
      [AutoSend],
      [AutoDownload],
      [AutoProcessDownloads],
      [AutoQueue],
      [MaxSendAttempts],
      [CorepointSenderAQN],
      [CorepointDownloadProcessorAQN],
      [OutboundQueueGeneratorAQN],
      [ExportXMLLayout],
      [ExportBusinessObjectName],
      [ExportKeyLookupFieldName],
      [Description],
      --[AutoQueueIntervalSeconds],
      --[AutoQueueLastRun],
      --[ForeignObjectUid],
      --[ClaimClearingHouseUid],
      [IntegrationPartnerUid],
      --[TransmissionAQN],
      --[AdditionalConfigurationXML],
      [UserDefined],
      [MessageDisplayAQN],
      [MessageParserAQN],
      [MessageUpdatesAQN],
      [UpdateableConfiguration],
      [HighlightConfiguration],
      [LastModifiedDate]
   )
   SELECT
      [eRxMessageTypeUid] AS [TransmissionConfigurationUid],
      [ExternalID] AS [TransmissionType],
      'PrescriberDirectoryDownload.eRxService' AS [CorepointMachineID],
      'IB' AS [CorepointInboundConnectionID],
      'OB' AS [CorepointOutboundConnectionID],
      'https://integration.aprima.com/communityexchange/partner/PartnerService' AS [AprimaVaultURL],
      --[AprimaVaultSubmissionURL],
      --[RegistrationURL],
      'http://tiran:8080/communityexchange/partner/PartnerService' AS [TestAprimaVaultURL],
      'https://tiran:51375/communityexchange/partner/PartnerService' AS [TestAprimaVaultSubmissionURL],
      'https://tiran:51375/communityexchange/partner/PartnerService' AS [TestRegistrationURL],
      1 AS [AutoSend],
      1 AS [AutoDownload],
      1 AS [AutoProcessDownloads],
      1 AS [AutoQueue],
      10 AS [MaxSendAttempts],
      'iMedica.Framework.eRxCorepoint.Transmission.PrescriberDownloadSender, eRxCorepoint' AS [CorepointSenderAQN],
      'iMedica.Framework.eRxCorepoint.Transmission.PrescriberDownloadProcessor, eRxCorepoint' AS [CorepointDownloadProcessorAQN],
      'iMedica.Framework.eRxCorepoint.Generator.eRxPRVBRDOutboundQueueGenerator,  eRxCorepoint' AS [OutboundQueueGeneratorAQN],
      'PrescriberDirectoryDownload_V4R6.eRxService' AS [ExportXMLLayout],
      'eRxPRVBRDOutbound' AS [ExportBusinessObjectName],
      'eRxPRVBRDOutboundUid' AS [ExportKeyLookupFieldName],
      [Name] AS [Description],
      @IntegrationPartnerUid AS [IntegrationPartnerUid],
      0 AS [UserDefined],
      'iMedica.Prm.Client.UI.EDI.eRx.ControleRxDisplay,iMedica.Prm.Client.UI' AS [MessageDisplayAQN],
      'iMedica.Prm.Client.UI.EDI.eRx.eRxParser,iMedica.Prm.Client.UI' AS [MessageParserAQN],
      'iMedica.Prm.Client.UI.EDI.eRx.ControleRxUpdates,iMedica.Prm.Client.UI' AS [MessageUpdatesAQN],
      '<update><element node="patient" attribute="lastName"/><element node="patient" attribute="firstname"/><element node="patient" attribute="middleName"/><element node="patient" attribute="prefix"/><element node="patient" attribute="suffix"/><element node="patient" attribute="DOB"/><element node="patient" attribute="gender"/><element node="patient" attribute="address1"/><element node="patient" attribute="address2"/><element node="patient" attribute="city"/><element node="patient" attribute="state"/><element node="patient" attribute="zip"/><element node="pharmacy" attribute="name"/><element node="pharmacy" attribute="phone"/><element node="med" attribute="dosageAmount"/><element node="med" attribute="quantity"/><element node="med" attribute="frequency"/><element node="med" attribute="startDate"/><element node="med" attribute="numRefills"/></update>' AS [UpdateableConfiguration],
      '<highlight><patient><element node="patient" attribute="lastName"/><element node="patient" attribute="firstName"/><element node="patient" attribute="DOB"/></patient><provider><element node="provider" attribute="lastName"/></provider><pharmacy><element node="pharmacy" attribute="name"/></pharmacy><servicesite/></highlight>' AS [HighlightConfiguration],
      @LastModifiedDate AS [LastModifiedDate]
   FROM [ListeRxMessageType] AS lmt
      LEFT OUTER JOIN [TransmissionConfiguration] AS tc ON lmt.[ExternalID] = tc.[TransmissionType]
   WHERE [eRxMessageTypeUid] = @eRxMessageTypeUid
      AND tc.[TransmissionConfigurationUid] IS NULL

   -- 12
   UPDATE [ListJob]
      SET [Name] = 'eRxService: Job Monitor',
         [AssemblyQualifiedName] = 'iMedica.Framework.eRxCorepoint.JobTask.ERxJobMonitor, eRxCorepoint',
         [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [JobUid] = '77273479-374B-4A09-A828-992742A664DC'
      AND [Name] = 'eRx: Job Monitor'

   UPDATE [JobSchedule]
      SET [Name] = 'eRxService: Job Monitor',
          [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [JobScheduleUid] = 'FBC47409-4DDA-4457-BD3E-2C2666B45D98'
      AND [Name] = 'eRx: Job Monitor'

   UPDATE [ListJob]
      SET [Name] = 'eRxService: Create Rx Benefits Messages from Calendar',
         [AssemblyQualifiedName] = 'iMedica.Framework.eRxCorepoint.JobTask.CreateEligibilityMessagesFromCalendar, eRxCorepoint',
         [NotifyOnFailure] = 1,
         [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [JobUid] = 'A9B1EC6A-C4AC-44BF-846D-69A3CD13AEDF'
      AND [Name] = 'eRx: Create Rx Benefits Messages'

   UPDATE [JobSchedule]
      SET [Name] = 'eRxService: Create Rx Benefits Messages from Calendar',
          [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [JobScheduleUid] = 'C45AA546-ACF7-4496-A2CC-9DA49D173E27'
      AND [Name] = 'eRx: Create Rx Benefits Messages'

   UPDATE [ListJob]
      SET [Name] = 'eRxService: Create e-Med Hx Messages from Calendar',
         [AssemblyQualifiedName] = 'iMedica.Framework.eRxCorepoint.JobTask.CreateMedicationHistoryMessagesFromCalendar, eRxCorepoint',
         [NotifyOnFailure] = 1,
         [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [JobUid] = '160C2F70-EFD0-476A-8CA9-8A97340AF073'
      AND [Name] = 'eRx: Create e-Med Hx Messages'

   UPDATE [JobSchedule]
      SET [Name] = 'eRxService: Create e-Med Hx Messages from Calendar',
          [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [JobScheduleUid] = '54556FEE-0696-4C52-A4E3-4E9D4E9A3FB3'
      AND [Name] = 'eRx: Create e-Med Hx Messages'

   DECLARE @Job_TBL TABLE (
      [JobUid] [uniqueidentifier],
      [Name] [varchar](256),
      [Inactive] [bit],
      [AssemblyQualifiedName] [varchar](1024),
      [UIAssemblyQualifiedName] [varchar](1024),
      [NotifyOnSuccess] [bit],
      [NotifyOnFailure] [bit],
      [UserDefined] [tinyint],
      [MemberUserUid] [uniqueidentifier],
      [LastModifiedDate] [datetime]
   )

   INSERT @Job_TBL
   SELECT js.[JobScheduleUid],
      'eRxService: Download Prescriber/Organization Directory' AS [Name],
      lj.[Inactive],
      'iMedica.Framework.eRxCorepoint.JobTask.eRxCorepointDownloadPrescriberDirectory, eRxCorepoint' AS [AssemblyQualifiedName],
      NULL AS [UIAssemblyQualifiedName],
      lj.[NotifyOnSuccess],
      lj.[NotifyOnFailure],
      0 AS [UserDefined],
      lj.[MemberUserUid],
      '2015-07-06 14:28:39.263' AS [LastModifiedDate]
   FROM [JobSchedule] AS js
      INNER JOIN [ListJob] AS lj ON js.[JobUid] = lj.[JobUid]
   WHERE js.[JobScheduleUid] = '4BDA1F87-B348-4404-BFBE-5560BEE4235D'   -- eRx: Poll Mailbox for Prescriber Updates

   INSERT [ListJob] (
      [JobUid],
      [Name],
      [Inactive],
      [AssemblyQualifiedName],
      [UIAssemblyQualifiedName],
      [NotifyOnSuccess],
      [NotifyOnFailure],
      [UserDefined],
      [MemberUserUid],
      [LastModifiedDate]
   )
   SELECT
      vj.[JobUid],
      vj.[Name],
      vj.[Inactive],
      vj.[AssemblyQualifiedName],
      vj.[UIAssemblyQualifiedName],
      vj.[NotifyOnSuccess],
      vj.[NotifyOnFailure],
      vj.[UserDefined],
      vj.[MemberUserUid],
      vj.[LastModifiedDate]
   FROM @Job_TBL AS vj
      LEFT OUTER JOIN [ListJob] AS lj ON vj.[JobUid] = lj.[JobUid]
   WHERE lj.[JobUid] IS NULL

   UPDATE [JobSchedule]
      SET [JobUid] = [JobScheduleUid],
         [Name] = 'eRxService: Download Prescriber/Organization Directory', /*,
         [MethodParams] = '<Control Name="ControlPrescriberDownloadParameter" ControlType="ControlPrescriberDownloadParameter" />
   <Control Name="_groupBoxPrescriberDirectory" ControlType="PrmGroupBox" />
   <Control Name="_findDateLastSuccessfullDownloadDate" ControlType="FindDateBox" Value="" Label="Last Successfull Download Date" Display="false" />
   <Control Name="_checkBoxFulldownload" ControlType="PrmCheckBox" Value="true" Label="Full download" />' */
         [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [JobScheduleUid] = '4BDA1F87-B348-4404-BFBE-5560BEE4235D'
      AND [Name] = 'eRx: Poll Mailbox for Prescriber Updates'

   DELETE @Job_TBL

   INSERT @Job_TBL
   SELECT js.[JobScheduleUid],
      'eRxService: Download Pharmacy Directory' AS [Name],
      lj.[Inactive],
      'iMedica.Framework.eRx.JobTask.GetERxMessages, eRx' AS [AssemblyQualifiedName],
      'iMedica.Prm.Client.UI.JobEngine.ControlPolleRxMessage' AS [UIAssemblyQualifiedName],
      lj.[NotifyOnSuccess],
      lj.[NotifyOnFailure],
      0 AS [UserDefined],
      lj.[MemberUserUid],
      '2015-07-06 14:28:39.263' AS [LastModifiedDate]
   FROM [JobSchedule] AS js
      INNER JOIN [ListJob] AS lj ON js.[JobUid] = lj.[JobUid]
   WHERE js.[JobScheduleUid] = 'EAFF3043-E1AE-437A-833E-B24295B12B69'   -- eRx: Poll Mailbox for Pharmacy Updates

   INSERT [ListJob] (
      [JobUid],
      [Name],
      [Inactive],
      [AssemblyQualifiedName],
      [UIAssemblyQualifiedName],
      [NotifyOnSuccess],
      [NotifyOnFailure],
      [UserDefined],
      [MemberUserUid],
      [LastModifiedDate]
   )
   SELECT
      vj.[JobUid],
      vj.[Name],
      vj.[Inactive],
      vj.[AssemblyQualifiedName],
      vj.[UIAssemblyQualifiedName],
      vj.[NotifyOnSuccess],
      vj.[NotifyOnFailure],
      vj.[UserDefined],
      vj.[MemberUserUid],
      vj.[LastModifiedDate]
   FROM @Job_TBL AS vj
      LEFT OUTER JOIN [ListJob] AS lj ON vj.[JobUid] = lj.[JobUid]
   WHERE lj.[JobUid] IS NULL

   UPDATE [JobSchedule]
      SET [JobUid] = [JobScheduleUid],
         [Name] = 'eRxService: Download Pharmacy Directory',
         [MethodParams] = '<Control Name="ControlPolleRxMessage" ControlType="ControlPolleRxMessage" /><Control Name="_findTextMessageType" ControlType="FindTextControl" Guid="6545bcbf-f85d-4f13-b480-10273968ab52" Value="Pharmacy" Tag="pharmacy" ForeignKeyIndex="0" FindTableUid="a84768bd-706b-4e2b-ad30-f261c4444a60" ExternalId="" Label="Message Type" />',
         [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [JobScheduleUid] = 'EAFF3043-E1AE-437A-833E-B24295B12B69'
      AND [Name] = 'eRx: Poll Mailbox for Pharmacy Updates'

   UPDATE [JobSchedule]
      SET [MethodParams] = null,
          [LastModifiedDate] = DATEADD(MI, 10, LastModifiedDate)
   WHERE [JobScheduleUid] IN(
   '54556FEE-0696-4C52-A4E3-4E9D4E9A3FB3',   -- eRxService: Create e-Med Hx Messages
   '4BDA1F87-B348-4404-BFBE-5560BEE4235D',   -- eRxService: Download Prescriber Directory
   'C45AA546-ACF7-4496-A2CC-9DA49D173E27'--,   -- eRxService: Create Rx Benefits Messages
   --'EAFF3043-E1AE-437A-833E-B24295B12B69' -- eRxService: Download Pharmacy Directory
   )

   DELETE [JobSchedule]
   WHERE [JobUid] IN (
   --'FDEE0DA3-1319-430A-9164-63BF273CC4B2', -- eRx: Process Pharmacy/Prescriber Messages
   '38684974-E91A-494B-9F0D-64765F4E0196', -- eRx: Send Rx Benefits Messages
   'E95EBECE-E069-44A6-9A5F-7566DB1785E7', -- eRx: Process X12 Script Messages
   'C7491DF5-12B6-4A94-AC8A-7E238D2E3AC7', -- eRx: Poll for Messages
   --'5A696DB7-0632-4979-981E-8460BC6FF8BE', -- eRx: Process PRVBRD Messages
   '592F87EC-356C-484D-924B-9229D769FA87', -- eRx: Send Messages
   'C0C5DAB1-ABC4-4A44-9DF0-CB97E6013B51', -- eRx: Send e-Med Hx Messages
   '183495CC-9B64-4F1B-A3C9-E3B728621079',   -- eRx: Process Script Messages
   'A0010916-897A-4FF1-8E3D-BD567054A7A5' -- eRx: Process ePrescribing Activity Report
   )

   DELETE [ListJob]
   WHERE [JobUid] IN (
   --'FDEE0DA3-1319-430A-9164-63BF273CC4B2', -- eRx: Process Pharmacy/Prescriber Messages
   '38684974-E91A-494B-9F0D-64765F4E0196', -- eRx: Send Rx Benefits Messages
   'E95EBECE-E069-44A6-9A5F-7566DB1785E7', -- eRx: Process X12 Script Messages
   'C7491DF5-12B6-4A94-AC8A-7E238D2E3AC7', -- eRx: Poll for Messages
   --'5A696DB7-0632-4979-981E-8460BC6FF8BE', -- eRx: Process PRVBRD Messages
   '592F87EC-356C-484D-924B-9229D769FA87', -- eRx: Send Messages
   'C0C5DAB1-ABC4-4A44-9DF0-CB97E6013B51', -- eRx: Send e-Med Hx Messages
   '183495CC-9B64-4F1B-A3C9-E3B728621079',   -- eRx: Process Script Messages
   'A0010916-897A-4FF1-8E3D-BD567054A7A5' -- eRx: Process ePrescribing Activity Report
   )

   UPDATE [JobSchedule]
      SET [Name] = 'eRxService: Process Pharmacy Messages'
   WHERE [JobUid] = 'FDEE0DA3-1319-430A-9164-63BF273CC4B2'
      AND [Name] = 'eRx: Process Pharmacy/Prescriber Messages'

   UPDATE [ListJob]
      SET [Name] = 'eRxService: Process Pharmacy Messages'
   WHERE JobUid = 'FDEE0DA3-1319-430A-9164-63BF273CC4B2'
      AND [Name] = 'eRx: Process Pharmacy/Prescriber Messages'


   UPDATE [JobSchedule]
      SET [Name] = 'eRxService: Process PRVBRD Update Messages'
   WHERE [JobUid] = '5A696DB7-0632-4979-981E-8460BC6FF8BE'
      AND [Name] = 'eRx: Process PRVBRD Update Messages'

   UPDATE [ListJob]
      SET [Name] = 'eRxService: Process PRVBRD Messages'
   WHERE JobUid = '5A696DB7-0632-4979-981E-8460BC6FF8BE'
      AND [Name] = 'eRx: Process PRVBRD Messages'


   -- Revised URLs
   UPDATE TransmissionConfiguration
   SET
     AprimaVaultSyncURL       = 'https://cpssdirectoryservice.aprima.com/communityexchange/partner/PartnerService',
     RegistrationURL          = 'https://cpssdirectoryservice.aprima.com/communityexchange/partner/PartnerService',
     LastModifiedDate         = GETUTCDATE()
   WHERE TransmissionType in('eRxProviderDirectory','eRxOrganizationDirectory')

   UPDATE TransmissionConfiguration
   SET
     AprimaVaultSyncURL       = 'https://cpdirectoryservice.aprima.com/communityexchange/partner/PartnerService',
     RegistrationURL          = 'https://cpdirectoryservice.aprima.com/communityexchange/partner/PartnerService',
     LastModifiedDate         = GETUTCDATE()
   WHERE TransmissionType in('InboundMessageRoutingRegistration')

   UPDATE TransmissionConfiguration
   SET
     AprimaVaultURL           = 'https://cpcedirectoryservice.aprima.com/communityexchange/partner/PartnerService',
     AprimaVaultSubmissionURL = 'https://cpdirectoryservice.aprima.com/communityexchange/partner/PartnerService',
     RegistrationURL          = 'https://cpdirectoryservice.aprima.com/communityexchange/partner/PartnerService',
     LastModifiedDate         = GETUTCDATE()
   WHERE TransmissionType in('PRVUPD::Pharmacy Download','PRVUPD::Prescriber Download')

   UPDATE TransmissionConfiguration
   SET
     AprimaVaultURL           = 'https://cpdirectmail.aprima.com/communityexchange/partner/PartnerService',
     AprimaVaultSubmissionURL = 'https://cpsenddirectmail.aprima.com/communityexchange/partner/PartnerService',
     AprimaVaultSyncURL       = 'https://cpssdirectoryservice.aprima.com/communityexchange/partner/PartnerService',
     RegistrationURL          = 'https://cpssdirectoryservice.aprima.com/communityexchange/partner/PartnerService',
     LastModifiedDate         = GETUTCDATE()
   WHERE TransmissionType in('SurescriptsDirectMessage')


   -- make sure everything is in the right testmode setting
   UPDATE tc
   SET
      TestMode         = lip.TestMode,
      LastModifiedDate = GETUTCDATE()
   FROM TransmissionConfiguration tc
   INNER JOIN ListIntegrationPartner lip ON lip.IntegrationPartnerUid = tc.IntegrationPartnerUid
   WHERE tc.TestMode <> lip.TestMode AND lip.Inactive=0

   -- 45715 -- make sure Registration URL for NEWRX/REFRES is correct
   UPDATE TransmissionConfiguration
   SET RegistrationURL = 'https://IntegrationService.Mednetworx.net/communityexchange/partner/PartnerService'
   WHERE TransmissionType IN('REFRES', 'NEWRX')
     AND RegistrationURL = 'https://cperx.Mednetworx.net/communityexchange/partner/PartnerService'

   -- reset all mailbox creation counters
   DELETE ListProductParameter where ParameterName = 'CreateCorepointMailboxAttempt'
END
