GUID_EMPTY = "00000000-0000-0000-0000-000000000000";

function escapeHTML(str)
{
    var objRegExpSingle = new RegExp("'", "gi");
    var strReplaceTextSingle = "&#8216";
    str = str.replace(objRegExpSingle, strReplaceTextSingle);

    var objRegExpDouble = new RegExp('"', "gi");
    var strReplaceTextDouble = "&#8220";
    str = str.replace(objRegExpDouble, strReplaceTextDouble);

    var objRegExpLT = new RegExp("<", "gi");
    var strReplaceTextLT = "&lt;";
    str = str.replace(objRegExpLT, strReplaceTextLT);

    var objRegExpGT = new RegExp(">", "gi");
    var strReplaceTextGT = "&gt";
    str = str.replace(objRegExpGT, strReplaceTextGT);

    return str;
}

function setSingleCalendar(sCalendarUid, iMinInterval, lngOpenHrMin, lngCloseHrMin)
{
	iMedica.DrawSchedule.FindCalendar(sCalendarUid);
	if (iMinInterval == 0)
		this.iMinInterval = iMedica.DrawSchedule.DisplayInterval;
	else
		this.iMinInterval = iMinInterval;
	this.initClass(lngOpenHrMin/60, lngCloseHrMin/60, iMinInterval)
	return this.iMinInterval;
}

function setCalendarDay(sCalendarUid, sDate)
{
	iMedica.DrawSchedule.FindCalendarWithDate(sCalendarUid, sDate);
	this.lngOpenHrMin = iMedica.DrawSchedule.StartTime/60;
	this.lngCloseHrMin = iMedica.DrawSchedule.EndTime/60;
	this.iOpenHr = Math.floor(this.lngOpenHrMin);
	this.iCloseHr = Math.ceil(this.lngCloseHrMin);
}

function setCalendarTemplate(sCalendarTemplateUid)
{
	iMedica.DrawSchedule.FindCalendarTemplateHead(sCalendarTemplateUid);
	this.initClass(iMedica.DrawSchedule.StartTime/60, iMedica.DrawSchedule.EndTime/60, iMedica.DrawSchedule.DisplayInterval)
}

function initClass(lngOpenHrMin, lngCloseHrMin, iMinInterval)
{
	this.lngOpenHrMin = lngOpenHrMin;
	this.lngCloseHrMin = lngCloseHrMin;
	this.iOpenHr = Math.floor(this.lngOpenHrMin);
	this.iCloseHr = Math.ceil(this.lngCloseHrMin);
	this.iStartHr = this.bDisplay24Hours ? 0 : this.iOpenHr;
	this.iEndHr = this.bDisplay24Hours ? 24 : this.iCloseHr;

	//if (this.lngCloseHrMin < this.iCloseHr && !this.bDisplay24Hours)
	//	this.iEndHr++;
	this.iMinInterval = iMinInterval;
	this.iNumMinInterval = Math.ceil((this.iEndHr - this.iStartHr)*60/this.iMinInterval);
}

function setCalendarAttribute(iStartHr, iEndHr, iMinInterval)
{
	this.iStartHr = this.bDisplay24Hours ? 0 : iStartHr;
	this.iEndHr = this.bDisplay24Hours ? 24 : iEndHr;

	//if (this.lngCloseHrMin < this.iCloseHr && !this.bDisplay24Hours && this.iEndHr < this.iCloseHr)
	//	this.iEndHr++;
	this.iMinInterval = iMinInterval;

	this.iNumMinInterval = Math.ceil((this.iEndHr - this.iStartHr)*60/this.iMinInterval);
}

function schedule(iIntervalHeight, bDisplay24Hours, bDefaultColorScheme)
{
	this.iIntervalHeight = iIntervalHeight;
	this.bDisplay24Hours = bDisplay24Hours;
	this.bDefaultColorScheme = bDefaultColorScheme;
}

function drawTime()
{
	var bAllowOverbookAppt = typeof(overbookAppt) == "function";
	var iMinute;
	var str = new Array();
	var sIndex = 0;

	str[sIndex++] = '<TABLE ID="scheduleTime" cellpadding="0" cellspacing="1" STYLE="table-layout:fixed" ';
	if (bAllowOverbookAppt)
		str[sIndex++] = 'class="handCursor" title="Click here to schedule an appointment"';
	str[sIndex++] = '>';
	for (var iHour = this.iStartHr; iHour < this.iEndHr; iHour++)
	{
	    str[sIndex++] = '<TR HEIGHT="' + this.iIntervalHeight + '"><TD CLASS="scheduleHour" ROWSPAN="' + (60 / this.iMinInterval) + '" ';
		if (bAllowOverbookAppt)
			str[sIndex++] = 'onclick="overbookAppt(' + iHour + ', 0)"';
		str[sIndex++] = '>' + (iHour == 0 ? '12' : ((iHour > 12) ? iHour - 12 : iHour)) + '</TD>';
		str[sIndex++] = '<TD CLASS="scheduleMin" ';
		if (bAllowOverbookAppt)
			str[sIndex++] = 'onclick="overbookAppt(' + iHour + ', 0)"';
		str[sIndex++] = '>' + (iHour < 12 ? 'am' : 'pm') + '</TD></TR>';
		for (iMinute = this.iMinInterval; iMinute < 60; iMinute += this.iMinInterval)
		{
		    str[sIndex++] = '<TR HEIGHT="' + this.iIntervalHeight + '"><TD CLASS="scheduleMin" ';
			if (bAllowOverbookAppt)
				str[sIndex++] = 'onclick="overbookAppt(' + iHour + ', ' + iMinute + ')"';
			str[sIndex++] = '>' + (iMinute < 10 ? '0' + iMinute : iMinute) + '</TD></TR>';
		}
	}
	str[sIndex++] = '</TABLE>';
	scheduleTime.outerHTML = str.join('');
	delete str;
}

function initArray(bOpen)
{
	var iOpenMinInterval = Math.floor(Math.ceil((this.lngOpenHrMin - this.iStartHr)*60)/this.iMinInterval);
	var iCloseMinInterval = Math.ceil((this.lngCloseHrMin - this.iStartHr)*60/this.iMinInterval);
	for (i = 0; i < this.iNumMinInterval; i++)
		if (bOpen && i >= iOpenMinInterval && i < iCloseMinInterval)
			this.arrSchedule[i] = new Array('o');  // open office hours
		else
			this.arrSchedule[i] = new Array('c'); // closed office hours
}

function checkApptPos()
{
	if (!this.bDisplay24Hours)
	{
		this.iStartPos -= this.iStartHr*60/this.iMinInterval;
		this.iEndPos -= this.iStartHr*60/this.iMinInterval;
		if (this.iStartPos < 0)
		{
			this.bMoreAppts = true;
			this.iStartPos = 0;
		}
		if (this.iStartPos > this.iNumMinInterval)
		{
			this.bMoreAppts = true;
			this.iStartPos = 0;
			this.iEndPos = 0;
		}
		else
		{
			if (this.iEndPos < 0)
			{
				this.bMoreAppts = true;
				this.iEndPos = 0;
			}
			if (this.iEndPos > this.iNumMinInterval)
			{
				this.bMoreAppts = true;
				this.iEndPos = this.iNumMinInterval;
			}
		}
	}
	return (this.iStartPos < this.iEndPos);
}

function checkMaxCols(iLength)
{
	var i, j;
	if (iLength > this.iMaxCols)
		this.iMaxCols = iLength;
	for (i = 1; i < iLength - 1; i++)
	{
		if (this.arrSchedule[this.iStartPos][i].substr(0, 1) == 'x')
		{
			for (j = this.iStartPos - 1; j >= 0; j--)
			{
				if (this.arrSchedule[j][i].substr(0, 1) != 'x')
				{
					this.arrSchedule[j][i] += 'xO';
					break;
				}
			}
		}
	}
}

function extendColumn(strType, iLength, iCurrentArrPos, iCurrentPos)
{
	var i, j;
	for (i = this.iStartPos + 1; i < this.iEndPos; i++)
	{
		for (j = this.arrSchedule[i].length; j < iCurrentPos; j++)
			this.arrSchedule[i][j] = 'a';
		this.arrSchedule[i][iCurrentPos] = strType + 'x' + (--iLength).toString() + 'x' + iCurrentArrPos.toString();
	}
}

function populateArrayApptSlots()
{
	this.iMaxCols = 1;
	var i, j, k, l;
	var numXMLNodes = iMedica.DrawSchedule.SlotCount;
	var tempMaxCols, tempArrLen;
	var apptLen;
	var bOpenSpot = true;
	for (i = 0; i < numXMLNodes; i++)
	{
		iMedica.DrawSchedule.CurrentSlotIndex = i;
		this.iStartPos = Math.floor(iMedica.DrawSchedule.SlotStartTime / this.iMinInterval);
		this.iEndPos = Math.ceil(iMedica.DrawSchedule.SlotEndTime / this.iMinInterval);
		// display this slot or skip it if it is outside the viewable area.
		if (!this.checkApptPos())
			continue;
		apptLen = this.iEndPos - this.iStartPos;
		tempArrLen = this.arrSchedule[this.iStartPos].length;
		for (j = 1; j < tempArrLen; j++)
		{
			bOpenSpot = true;
			if (this.arrSchedule[this.iStartPos][j] == 'a')
			{
				for (k = this.iStartPos + 1; k < apptLen; k++)
					if (!(this.arrSchedule[k][j] != 't'))
					{
						bOpenSpot = false;
						break;
					}
				if (bOpenSpot)
					break;
				bOpenSpot = false;
			}
			else
				bOpenSpot = false;
		}
		if (bOpenSpot)
			this.arrSchedule[this.iStartPos][j] = 's' + iMedica.DrawSchedule.SlotAppointmentTypeUid + "~" + iMedica.DrawSchedule.CalendarTemplateDaySlotUid + 'x' + apptLen.toString() + 'x' + i.toString();
		else
			this.arrSchedule[this.iStartPos][tempArrLen] = 's' + iMedica.DrawSchedule.SlotAppointmentTypeUid + "~" + iMedica.DrawSchedule.CalendarTemplateDaySlotUid + 'x' + apptLen.toString() + 'x' + i.toString();
		this.checkMaxCols(this.arrSchedule[this.iStartPos].length);
		this.extendColumn('xs' + iMedica.DrawSchedule.SlotAppointmentTypeUid, apptLen, i, j);
	}
}

function MatchesType(apptTypeUid, i, j, arr, tempSlotArr)
{
    //bug 27305, 27306 - array bounds needs to be checked before accessing. bug 34076 - need to check the column index [j] to make sure it is not out of bounds
    if (i > arr.length - 1 ||  j > arr[i].length - 1 || arr[i][j] == null)
        return 0;

    if (arr[i][j].substr(0, 1) == 's' || arr[i][j].substr(0, 2) == 'xs')
    {
        if (arr[i][j].substr(0, 1) == 's')
            tempSlotArr = arr[i][j].substr(1).split('x');
        else
            tempSlotArr = arr[i][j].substr(2).split('x');

        if (tempSlotArr[0].split('~')[0] == apptTypeUid)
        {
            return arr[i].length;  //fix for bug 33245
            //return tempSlotArr[1];
        }
    }

    return 0;
}

function populateArrayAppts(dDate, xmlApptsNode)
{
	iBeginDate = dDate.getTime();
	iEndDate = iBeginDate + MS_IN_DAY;
	var i, j, k, l, m, n, bLastCol, iEndRow, ixOIndex;
	var numXMLNodes = xmlApptsNode.length;
	var tempMaxCols, tempArr, tempArrLen, tempSlotArr, tempSlotBegin;
	var apptLen, bOpenSpot, dStartDT, dEndDT;
	var apptTypeUid, bEvent;
	for (i = 0; i < numXMLNodes; i++)
	{
		dStartDT = convertXMLDateTimeToJSDateObj(xmlApptsNode[i].getAttribute("startDT"));
		dEndDT = convertXMLDateTimeToJSDateObj(xmlApptsNode[i].getAttribute("endDT"));
		if (dStartDT.getTime() < iBeginDate)
			this.iStartPos = 0;
		else
			this.iStartPos = Math.floor((dStartDT.getHours()*60 + dStartDT.getMinutes()) / this.iMinInterval);
		if (dEndDT.getTime() > iEndDate)
			this.iEndPos = (24*60) / this.iMinInterval;
		else
			this.iEndPos = Math.ceil((dEndDT.getHours()*60 + dEndDT.getMinutes()) / this.iMinInterval);
		if (!this.checkApptPos())
			continue;
		apptLen = this.iEndPos - this.iStartPos;
		apptTypeUid = xmlApptsNode[i].getAttribute("apptTypeUid");
		bScheduleType = xmlApptsNode[i].getAttribute("scheduleType");
		bEvent = (xmlApptsNode[i].getAttribute("scheduleType") == "BlockingEvent");
		tempArrLen = this.arrSchedule[this.iStartPos].length;
		bOpenSpot = false;

		for (j = 1; j < tempArrLen; j++)
		{
		    iMedica.DrawSchedule.DebugOutput(j);
		    var len = MatchesType(apptTypeUid, this.iStartPos, j, this.arrSchedule, tempSlotArr);
		    if (len > 0)
		    {
		        iMedica.DrawSchedule.DebugOutput("Match");
		        if (len > apptLen)
		        {
		            bOpenSpot = true;
		            break;
		        }
		        else
		        {
		            iMedica.DrawSchedule.DebugOutput(apptLen);
		            allOpen = true;
		            for (x = 1; x <= apptLen;)
		            {
		                len = MatchesType(apptTypeUid, this.iStartPos + x, j, this.arrSchedule, tempSlotArr);
		                if (len == 0) {
		                    allOpen = false;
		                    break;
		                }
		                else
		                    x += len;
		            }
		            if (allOpen) {
		                bOpenSpot = true;
		                break;
		            }
		        }
		    }

            //fix for bug 28108 - need to check against null before attempting to check the array index's string value
		    if (this.arrSchedule[this.iStartPos][j] != null &&
               (this.arrSchedule[this.iStartPos][j].substr(0, 1) == 's' || this.arrSchedule[this.iStartPos][j].substr(0, 2) == 'xs'))
			{
				if (this.arrSchedule[this.iStartPos][j].substr(0, 1) == 's')
					tempSlotArr = this.arrSchedule[this.iStartPos][j].substr(1).split('x');
				else
					tempSlotArr = this.arrSchedule[this.iStartPos][j].substr(2).split('x');

				if (tempSlotArr[0].split('~')[0] == apptTypeUid)
				{
				    if (tempSlotArr[1] >= apptLen)
				    {
				        bOpenSpot = true;
				        break;
				    }
				    else
				    {
				        iMedica.DrawSchedule.DebugOutput(this.arrSchedule[this.iStartPos][j]);
				        iMedica.DrawSchedule.DebugOutput(this.arrSchedule[this.iStartPos][j + 1]);
				        iMedica.DrawSchedule.DebugOutput(this.arrSchedule[this.iStartPos + 1][j]);
				    }
				}
			}
		}
		iMedica.DrawSchedule.DebugOutput(bOpenSpot);
		if (!bOpenSpot || bEvent)
		{
			bLastCol = false;
			iEndRow = this.iStartPos + apptLen;
			while (!bLastCol && tempArrLen < this.iMaxCols)
			{
				for (m = this.iStartPos; m < iEndRow; m++)
					if (this.arrSchedule[m][tempArrLen] != null)
					{
						tempArrLen++;
						break;
					}
				if (m == iEndRow)
					bLastCol = true;
			}
			for (m = this.iStartPos; m < iEndRow; m++)
				for (n = 1; n < tempArrLen; n++)
					if (this.arrSchedule[m][n] == null)
						this.arrSchedule[m][n] = 'a';
			this.arrSchedule[this.iStartPos][tempArrLen] = (bEvent ? 'e' : (bScheduleType == "GroupVisit" ? 'g' : 'p')) + xmlApptsNode[i].getAttribute("apptUid") + 'x' + apptLen.toString() + 'x' + i.toString();
			j = tempArrLen;
			this.checkMaxCols(this.arrSchedule[this.iStartPos].length);
			this.extendColumn((bEvent ? 'xe' : 'xp') + xmlApptsNode[i].getAttribute("apptUid"), apptLen, i, j)
			continue;
		}

		tempSlotBegin = this.arrSchedule[this.iStartPos][j];
		ixOIndex = tempSlotBegin.indexOf("xO");
		this.arrSchedule[this.iStartPos][j] = 'p' + xmlApptsNode[i].getAttribute("apptUid") + 'x' + apptLen.toString() + 'x' + i.toString() +
											(ixOIndex != -1 ? tempSlotBegin.substr(ixOIndex) : '');

		for (l = this.iStartPos + 1; l < this.iEndPos; l++)
			this.arrSchedule[l][j] = 'xp' + xmlApptsNode[i].getAttribute("apptUid") + 'x' + (--apptLen).toString() + 'x' + i.toString();
		k = 1;
		if (tempSlotBegin.substr(0, 2) == 'xs')
		{
			for (l = this.iStartPos - 1; l >= 0; l--)
			{
				if (this.arrSchedule[l][j].substr(0, 2) == 'xs')
				{
					tempArr = this.arrSchedule[l][j].substr(1).split('x')
					tempArr[1] = k++;
					this.arrSchedule[l][j] = 'x' + tempArr.join('x');
				}
				else if (this.arrSchedule[l][j].substr(0, 1) == 's')
				{
					tempArr = this.arrSchedule[l][j].split('x')
					tempArr[1] = k++;
					this.arrSchedule[l][j] = tempArr.join('x');
					tempSlotBegin = this.arrSchedule[l][j];
					break;
				}
				else
					break;
			}
		}
		if (this.arrSchedule[this.iEndPos] != null)
			if (this.arrSchedule[this.iEndPos][j] != null)
			{
				if (apptTypeUid == this.arrSchedule[this.iEndPos][j].substr(2).split('x')[0])
				{
					tempArr = tempSlotBegin.split('x');
					tempArr[1] = this.arrSchedule[this.iEndPos][j].substr(1).split('x')[1];
					this.arrSchedule[this.iEndPos][j] = tempArr.join('x');
				}
			}
	}
}

function drawDay(xmlAppts, sXMLDay)
{
    var sDate = xmlAppts.getAttribute("date");
    var oDiv = document.all['scheduleDay' + sXMLDay];

    if (oDiv==null)
        return;

    this.bMoreAppts = false;
    iMedica.DrawSchedule.FindCalendarTemplateSlot(sDate);
    this.arrSchedule = new Array();
    this.initArray(iMedica.DrawSchedule.IsCalendarDayOpen(sDate));
    this.populateArrayApptSlots();
    var xmlApptNodes = xmlAppts.childNodes;
    this.populateArrayAppts(new Date(sDate), xmlApptNodes);
    var str = new Array();
    var sIndex = 0;

	str[sIndex++] = '<TABLE ID="' + oDiv.id + '" cellpadding="2" cellspacing="1" STYLE="table-layout:fixed;">';
	if (this.iMaxCols > 1)
	{
		for (i = 1; i < this.iMaxCols; i++)
			str[sIndex++] = '<COL VALIGN="top">';
		str[sIndex++] = '<COL WIDTH="7">';
	}
	var i, j, k, xmlNode, strApptTypeCaption, strDisplay;
	var isReminder, hasArpBalance, sPersonUid, sAccountUid, strPhone, strCopay, strReason, dStartDT, dEndDT, strCallConfirm, strEligStatus, bAllowCheckout;
	var strCaption, iRowSpan, strColor, calendarColor, strStartTime, strEndTime, strToolTip, strPayerName, strPlanName, strAppointmentStatus;
	var strOtherPayerTypeCode, strPlanMemberID, strEligibilitySubscriberID, isNoted;
	var tempArr, tempArrLen, tempAppt, tempApptlen, tempColSpan, openSpaceColSpan;
	var tempApptTypeUid, sApptUid, xmlDay, sApptDateTime;
	var xmlDay = document.all['xmlDay' + sXMLDay].documentElement;
    var sCalendarUid = xmlDay.getAttribute("calendarUid");
    var collectionStatusName;
    var collectionAlerted;

	for (i = 0; i < this.iNumMinInterval; i++)
	{
		bAllowCheckout = false;
		str[sIndex++] = '<TR HEIGHT="' + this.iIntervalHeight + '">';
		tempArr = this.arrSchedule[i];
		tempArrLen = tempArr.length;
		openSpaceColSpan = this.iMaxCols;
		sApptDateTime = apptDateTime(sXMLDay, i);

		for (j = 1; j < tempArrLen; j++)
		{
		    tempColSpan = 1;

            //bug 31890 - not checking for nulls before accessing substring
		    if (tempArr[j] != null)
		    switch (tempArr[j].substr(0, 1))
			{
				case 'a': //available
				    if (tempArr[0] == 'o' && tempArrLen == 1)
					    str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + sApptUid + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';111;0;0\')"' +
                                            ' CLASS="openTime" ';
					else
					    str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + sApptUid + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';222;0;0\')"' +
                                            ' CLASS="closeTime" ';
				    str[sIndex++] = 'onclick="addAppt(' + sXMLDay + ',' + i + ', null)">&nbsp;</TD>';

					iMedica.DrawSchedule.DebugOutput("**********AVAILABLE*********************************");

					break;
				case 'x': // continuation of an appt, event, or appt slot
					for (k = i - 1; k >= 0; k--)
					{
						if (this.arrSchedule[k][j].substr(0, 1) != 'x')
						{
							tempAppt = this.arrSchedule[k][j].split('x');
							tempColSpan = tempAppt[tempAppt.length - 1];
							break;
						}
					}
					break;
		        case 's': //template slot

                    iMedica.DrawSchedule.DebugOutput("**********TEMPLATE SLOT********************************");

					tempAppt = tempArr[j].split('x');
					tempColSpan = (tempAppt.length > 3 ? 1 : (tempArrLen == 2 ? (this.iMaxCols - 1) : (j == tempArrLen - 1 ? (this.iMaxCols - j) : 1)));
					tempUidArr = tempAppt[0].substr(1).split('~');
					tempApptTypeUid = tempUidArr[0];
					//tempCalendarTimeSlotUid = tempUidArr[1];

					var bBlockApptType = false;
					if (!iMedica.AppointmentType.FindAppointmentType(tempApptTypeUid))
					{
						strApptTypeCaption = "Unknown/Deleted Appointment Type";
						strColor = "red";
					}
					else
					{
					    strApptTypeCaption = escapeHTML(iMedica.AppointmentType.Name);
						strColor = iMedica.AppointmentType.Color;
						bBlockApptType = iMedica.AppointmentType.Blocking;
					}
					iRowSpan = parseInt(tempAppt[1], 10);
					iMedica.DrawSchedule.CurrentSlotIndex = parseInt(tempAppt[2], 10);
					strStartTime = convertMinsToTimeStr(iMedica.DrawSchedule.SlotStartTime);
					strEndTime = convertMinsToTimeStr(iMedica.DrawSchedule.SlotEndTime);
					strToolTip = strApptTypeCaption  + '\n' + strStartTime + '-' + strEndTime;
					if (iRowSpan > 1)
					{
					    if (bBlockApptType)
					        str[sIndex++] = '<TD ';
                        else
					        str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + GUID_EMPTY + ";" + sCalendarUid + ';' + tempApptTypeUid + ';' + sDate + ';' + sApptDateTime + ';333;1;0\')"';

					    str[sIndex++] = ' COLSPAN="' + tempColSpan + '" ROWSPAN="' + iRowSpan + '" title="' + strToolTip + '"';
						if (this.bDefaultColorScheme || strColor == '')
							str[sIndex++] = ' CLASS="apptTypeDefaultColor handCursor"><DIV CLASS="small"';
						else
							str[sIndex++] = ' CLASS="handCursor" style="background-color:' + strColor + '"><DIV CLASS="small" style="background-color:' + strColor + '"';
						str[sIndex++] = ' style="overflow: hidden; height: ' + (iRowSpan*(this.iIntervalHeight - 3)) +
											'">' + SetDeleteIcon(sXMLDay, i, tempApptTypeUid, strStartTime, strEndTime) +
                                            '<EM ' +
                                            (tempApptTypeUid != GUID_EMPTY && !bBlockApptType ?
                                                ' onMouseOver="this.className=' + "'apptTypeHighlite handCursor small'" + '" onMouseOut="this.className=' + "'handCursor small'" + '"' :
                                                 ""
                                            ) +
                                            (tempApptTypeUid != GUID_EMPTY && !bBlockApptType ?
                                                '" onclick="addAppt(' + sXMLDay + ',' + i + ',\'' + tempApptTypeUid + '\', null, \'' + strStartTime + '\')"' :
                                                '" onclick="removeSlot(' + sXMLDay + ',' + i + ',\'' + tempApptTypeUid + '\', \'' + strStartTime + '\',\'' + strEndTime + '\')"'
                                            ) +
                                            '>' + strApptTypeCaption + '</EM></DIV></TD>'; //bug 42553 - modify addAppt to pass in a starttime
					}
					else
					{
					    str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + GUID_EMPTY + ";" + sCalendarUid + ';' + tempApptTypeUid + ';' + sDate + ';' + sApptDateTime + ';444;1;0\')"' +
					                    ' NOWRAP="true" COLSPAN="' + tempColSpan + '" title="' + strToolTip + '"';
						if (this.bDefaultColorScheme || strColor == '')
							str[sIndex++] = ' CLASS="apptTypeDefaultColor handCursor small">';
						else
							str[sIndex++] = ' CLASS="handCursor small" style="background-color:' + strColor + '">';
						str[sIndex++] = SetDeleteIcon(sXMLDay, i, tempApptTypeUid, strStartTime, strEndTime) +
                                        '<EM ' +
                                        (tempApptTypeUid != GUID_EMPTY && !bBlockApptType ?
                                            ' onMouseOver="this.className=' + "'apptTypeHighlite handCursor small'" + '" onMouseOut="this.className=' + "'handCursor small'" + '"' :
                                             ""
                                        ) +
                                        (tempApptTypeUid != GUID_EMPTY && !bBlockApptType ?
                                              '" onclick="addAppt(' + sXMLDay + ',' + i + ',\'' + tempApptTypeUid + '\', null, \'' + strStartTime + '\')"' :
                                              '" onclick="removeSlot(' + sXMLDay + ',' + i + ',\'' + tempApptTypeUid + '\', \'' + strStartTime + '\',\'' + strEndTime + '\')"'
                                        ) +
                                        '>' + strApptTypeCaption + '</EM></TD>';    //bug 42553 - modify addAppt to pass in a starttime
					}
					// lets the following rows know how many cols this table cell spans
					tempArr[j] += 'x' + tempColSpan;
					break;
		        case 'p': //beginning of an appt


	                iMedica.DrawSchedule.DebugOutput("**********BEGINNING OF AN APPT*********************************");


	                tempAppt = tempArr[j].split('x');
	                tempColSpan = (tempAppt.length > 3 ? 1 : (tempArrLen == 2 ? (this.iMaxCols - 1) : (j == tempArrLen - 1 ? (this.iMaxCols - j) : 1)));
	                xmlNode = xmlApptNodes[parseInt(tempAppt[2])];
	                sApptUid = xmlNode.getAttribute("apptUid");

	                var appTypeUid = xmlNode.getAttribute("apptTypeUid");
	                var bBlocking = false;
	                var CaptionNode = xmlNode.selectSingleNode("caption");
	                strCaption = CaptionNode == null ? "" : escapeHTML(CaptionNode.text);
	                if (!iMedica.AppointmentType.FindAppointmentType(appTypeUid == null ? "" : appTypeUid)) {
	                    strApptTypeCaption = '';
	                    strColor = '#FFCC99';
	                }
	                else {
	                    strApptTypeCaption = escapeHTML(iMedica.AppointmentType.Name) + ": ";
	                    bBlocking = iMedica.AppointmentType.Blocking;
	                    if (bBlocking)
	                        strCaption = strApptTypeCaption + strCaption;

	                    strColor = '#' + iMedica.AppointmentType.Color;
	                    if (strColor == '#')
	                        strColor = '#FFCC99';
	                }

	                var foreColor;
	                foreColor = 'black';

	                bAllowCheckout = xmlNode.getAttribute("checkout") == "1";
	                isReminder = xmlNode.getAttribute("reminder");
                    hasArpBalance = xmlNode.getAttribute("hasArpBalance");
                    collectionStatusName = xmlNode.getAttribute("collectionStatusName");
                    collectionAlerted = xmlNode.getAttribute("collectionAlerted");
	                sPersonUid = xmlNode.getAttribute("personUid");
	                sAccountUid = xmlNode.getAttribute("accountUid");
	                strPhone = xmlNode.getAttribute("phone");
	                strCopay = xmlNode.getAttribute("copay");
	                strPayerName = xmlNode.getAttribute("payerName");
	                strPayerName = strPayerName == null || strPayerName == '' ? "unspecified" : strPayerName;
	                strPlanName = xmlNode.getAttribute("planName");
	                strPlanName = strPlanName == null || strPlanName == '' ? "unspecified" : strPlanName;
	                strCallConfirm = xmlNode.getAttribute("callConfirm");
	                strEligStatus = xmlNode.getAttribute("eligibilityStatus").toLowerCase();
	                strOtherPayerTypeCode = xmlNode.getAttribute("OtherPayerTypeCode");
	                strPlanMemberID = xmlNode.getAttribute("PlanMemberID");
	                strEligibilitySubscriberID = xmlNode.getAttribute("eligibilitySubscriberID");
	                isNoted = altString(strPlanMemberID, strEligibilitySubscriberID, strOtherPayerTypeCode);

	                if (strCopay == "-$0.00")
	                    strCopay = "$0.00";
	                strReason = strApptTypeCaption + escapeHTML(xmlNode.selectSingleNode("reason").text);
	                iRowSpan = parseInt(tempAppt[1], 10);
	                dStartDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("startDT"));
	                dEndDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("endDT"));
	                strStartTime = convertDateObjToDateStr(dStartDT, '/') + ' ' + convertDateObjTo12HRTime(dStartDT);
	                strEndTime = convertDateObjToDateStr(dEndDT, '/') + ' ' + convertDateObjTo12HRTime(dEndDT);
	                strAppointmentStatus = xmlNode.selectSingleNode("status").text;
	                if (strAppointmentStatus != '')
	                    foreColor = convertXMLColor(xmlNode.selectSingleNode("statusColor").text);

	                strToolTip = strCaption + '\nStart: ' + strStartTime + '\nEnd: ' + strEndTime;
	                if (!bBlocking)
	                    strToolTip += '\nStatus: ' + strAppointmentStatus;
	                //					strToolTip += '\nInsurance: ' + strPayerName + '/' + strPlanName;
	                // TODO: disabled for beta1
	                if (false) {
	                    strToolTip += '\nCopay: ';
	                    if (strCopay != "$0.00")
	                        if (strCopay.substr(0, 1) == '-')
	                            strToolTip += strCopay.substr(1);
	                        else
	                            strToolTip += strCopay + 'PD';
	                    else
	                        strToolTip += strCopay;
	                }
	                if (strPhone != null && strPhone != "")
	                    strToolTip += '\nPhone: ' + strPhone;
	                strToolTip += '\n' + strReason;
	                if (iRowSpan > 1) {
	                    str[sIndex++] =
                                        '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + sApptUid + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';aaa;1;0\')"' +
                                                    ' COLSPAN="' + tempColSpan + '" ROWSPAN="' + iRowSpan + '" title="' + strToolTip + '"' +
										            ' CLASS="handCursor" onMouseOver="this.className=' + "'apptTypeHighlite handCursor'" +
										            '" onMouseOut="this.className=' + "'handCursor'" + '" style="background-color:' + strColor + ';border-color:' + foreColor + ';border-style:solid;border-width:1px' +
										            '">' + '<DIV CLASS="small" style="background-color:' + strColor + '; overflow: hidden; height: ' + (iRowSpan * (this.iIntervalHeight - 3)) +
										            '">' + setIconDropDown(sXMLDay, sApptUid, bAllowCheckout) + setCallConfirm(strCallConfirm) + setEligibilityStatus(strEligStatus, sAccountUid, isNoted) +
										            ' ' + '<span onclick="updateAppt(' + sXMLDay + ',\'' + sApptUid + '\')">' +
                        createDivText(isReminder, hasArpBalance, strCaption, strCopay, strReason, strPhone, strAppointmentStatus, foreColor, sApptUid, collectionStatusName, collectionAlerted) + '</span></DIV></TD>';
	                }
	                else {
	                    str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + sApptUid + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';bbb;1;0\')"' +
                                                    ' NOWRAP="true" COLSPAN="' + tempColSpan + '" title="' + strToolTip + '"' +
										            ' CLASS="handCursor small" onMouseOver="this.className=' + "'apptTypeHighlite handCursor small'" +
										            '" onMouseOut="this.className=' + "'handCursor small'" + '" style="background-color:' + strColor + ';border-color:' + foreColor + ';border-style:solid;border-width:1px' +
										            '" >' + setIconDropDown(sXMLDay, sApptUid, bAllowCheckout) + setCallConfirm(strCallConfirm) + setEligibilityStatus(strEligStatus, sAccountUid, isNoted) +
                            ' ' + '<span onclick="updateAppt(' + sXMLDay + ',\'' + sApptUid + '\')">' + createDivText(isReminder, hasArpBalance, strCaption, strCopay, strReason, strPhone, strAppointmentStatus, foreColor, sApptUid, collectionStatusName, collectionAlerted) + '</span></TD>';
                    }
	                // lets the following rows know how many cols this table cell spans
	                tempArr[j] += 'x' + tempColSpan;
	                break;
	            case 'g': //group
	                tempAppt = tempArr[j].split('x');
	                tempColSpan = (tempAppt.length > 3 ? 1 : (tempArrLen == 2 ? (this.iMaxCols - 1) : (j == tempArrLen - 1 ? (this.iMaxCols - j) : 1)));
	                xmlNode = xmlApptNodes[parseInt(tempAppt[2])];
	                sApptUid = xmlNode.getAttribute("apptUid");

	                var appTypeUid = xmlNode.getAttribute("apptTypeUid");
	                var bBlocking = false;
	                var CaptionNode = xmlNode.selectSingleNode("caption");
	                strCaption = CaptionNode == null ? "" : escapeHTML(CaptionNode.text);
	                if (!iMedica.AppointmentType.FindAppointmentType(appTypeUid == null ? "" : appTypeUid)) {
	                    strApptTypeCaption = '';
	                    strColor = '#FFCC99';
	                }
	                else {
	                    strApptTypeCaption = escapeHTML(iMedica.AppointmentType.Name) + ": ";
	                    bBlocking = iMedica.AppointmentType.Blocking;
	                    if (bBlocking)
	                        strCaption = strApptTypeCaption + strCaption;

	                    strColor = '#' + iMedica.AppointmentType.Color;
	                    if (strColor == '#')
	                        strColor = '#FFCC99';
	                }

	                var foreColor;
	                foreColor = 'black';

	                bAllowCheckout = xmlNode.getAttribute("checkout") == "1";
	                isReminder = xmlNode.getAttribute("reminder");
	                strReason = strApptTypeCaption + escapeHTML(xmlNode.selectSingleNode("reason").text);
	                iRowSpan = parseInt(tempAppt[1], 10);
	                dStartDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("startDT"));
	                dEndDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("endDT"));
	                strStartTime = convertDateObjToDateStr(dStartDT, '/') + ' ' + convertDateObjTo12HRTime(dStartDT);
	                strEndTime = convertDateObjToDateStr(dEndDT, '/') + ' ' + convertDateObjTo12HRTime(dEndDT);
	                strAppointmentStatus = xmlNode.selectSingleNode("status").text;
	                if (strAppointmentStatus != '')
	                    foreColor = convertXMLColor(xmlNode.selectSingleNode("statusColor").text);

	                strToolTip = strCaption + '\nStart: ' + strStartTime + '\nEnd: ' + strEndTime;
	                if (!bBlocking)
	                    strToolTip += '\nStatus: ' + strAppointmentStatus;
	                if (iRowSpan > 1) {
	                    str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + sApptUid + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';ccc;1;0\')"' +
                                                    ' COLSPAN="' + tempColSpan + '" ROWSPAN="' + iRowSpan + '" title="' + strToolTip + '"' +
										            ' CLASS="handCursor" onMouseOver="this.className=' + "'apptTypeHighlite handCursor'" +
										            '" onMouseOut="this.className=' + "'handCursor'" + '" style="background-color:' + strColor + ';border-color:' + foreColor + ';border-style:solid;border-width:1px' +
										            '"><DIV CLASS="small" style="background-color:' + strColor + '; overflow: hidden; height: ' + (iRowSpan * (this.iIntervalHeight - 3)) +
										            '">' + setIconDropDown(sXMLDay, sApptUid, bAllowCheckout) +
                            ' ' + '<span onclick="updateAppt(' + sXMLDay + ',\'' + sApptUid + '\')">' + createDivText(isReminder, hasArpBalance, strCaption, strCopay, strReason, strPhone, strAppointmentStatus, foreColor, sApptUid, collectionStatusName, collectionAlerted) + '</span></DIV></TD>';
	                }
	                else {
	                    str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + sApptUid + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';ddd;1;0\')"' +
                                                    ' NOWRAP="true" COLSPAN="' + tempColSpan + '" title="' + strToolTip + '"' +
										            ' CLASS="handCursor small" onMouseOver="this.className=' + "'apptTypeHighlite handCursor small'" +
										            '" onMouseOut="this.className=' + "'handCursor small'" + '" style="background-color:' + strColor + ';border-color:' + foreColor + ';border-style:solid;border-width:1px' +
										            '" >' + setIconDropDown(sXMLDay, sApptUid, bAllowCheckout) +
                            ' ' + '<span onclick="updateAppt(' + sXMLDay + ',\'' + sApptUid + '\')">' + createDivText(isReminder, hasArpBalance, strCaption, strCopay, strReason, strPhone, strAppointmentStatus, foreColor, sApptUid, collectionStatusName, collectionAlerted) + '</span></TD>';
	                }
	                // lets the following rows know how many cols this table cell spans
	                tempArr[j] += 'x' + tempColSpan;
	                break;
	            case 'e': //blocking
	                tempAppt = tempArr[j].split('x');
	                tempColSpan = (tempAppt.length > 3 ? 1 : (tempArrLen == 2 ? (this.iMaxCols - 1) : (j == tempArrLen - 1 ? (this.iMaxCols - j) : 1)));
	                xmlNode = xmlApptNodes[parseInt(tempAppt[2])];
	                sApptUid = xmlNode.getAttribute("apptUid");
	                appTypeUid = xmlNode.getAttribute("apptTypeUid");
	                strApptTypeCaption = "";
	                var strEventColorClass = "eventDefaultColor ";
	                var blocking = 0;
	                if (iMedica.AppointmentType.FindAppointmentType(appTypeUid == null ? "" : appTypeUid)) {
	                    if (!iMedica.AppointmentType.AllowBlockingOverride)
	                        blocking = 1;
	                    strApptTypeCaption = "<B>" + escapeHTML(iMedica.AppointmentType.Name) + "</B><I>(blocking)</I>: ";
	                    strColor = '#' + iMedica.AppointmentType.Color;
	                    if (strColor != '#')
	                        strEventColorClass = "";
	                    else
	                        strColor = "";
	                }
	                else
	                    strColor = "";

	                isReminder = xmlNode.getAttribute("reminder");
	                strReason = escapeHTML(xmlNode.selectSingleNode("reason").text);
	                strPhone = xmlNode.getAttribute("phone");
	                if (isReminder == '1')
	                    strCaption = '<FONT COLOR="purple"><B>' + strReason + '</B></FONT>, ' + strPhone;
	                else
	                    strCaption = '<B>' + strReason + '</B>, ' + strPhone;
	                iRowSpan = parseInt(tempAppt[1], 10);
	                dStartDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("startDT"));
	                dEndDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("endDT"));
	                strStartTime = convertDateObjToDateStr(dStartDT, '/') + ' ' + convertDateObjTo12HRTime(dStartDT);
	                strEndTime = convertDateObjToDateStr(dEndDT, '/') + ' ' + convertDateObjTo12HRTime(dEndDT);
	                strToolTip = strReason + '\nStart: ' + strStartTime + '\nEnd: ' + strEndTime;
	                if (strPhone != null && strPhone != "")
	                    strToolTip += '\nPhone: ' + strPhone;

	                if (iRowSpan > 1) {
	                    str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + sApptUid + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';eee;1;' + blocking + '\')"' +
	                                                ' COLSPAN="' + tempColSpan + '" ROWSPAN="' + iRowSpan + '" title="' + strToolTip + '"' + 'style="background-color:' + strColor + '"' +
										            ' CLASS="' + strEventColorClass + 'handCursor" onMouseOver="this.className=' + "'apptTypeHighlite " + strEventColorClass + "handCursor'" +
										            '" onMouseOut="this.className=' + "'" + strEventColorClass + "handCursor'" +
										            '" onclick="updateAppt(' + sXMLDay + ',\'' + sApptUid + '\')"><DIV CLASS="' + strEventColorClass + ' small" style="overflow: hidden; height: ' +
										            (iRowSpan * (this.iIntervalHeight - 3)) + ';background-color:' + strColor + '">' +
                                                    '<a href="#calendar' + sApptUid + '" style="color:black" onclick="return false" ondragstart="dragStart(event)">' +
                                                    strApptTypeCaption + strCaption + '</a></DIV></TD>';
	                }
	                else {
	                    str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + sApptUid + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';fff;1;' + blocking + '\')"' +
	                                                ' NOWRAP="true" COLSPAN="' + tempColSpan + '" title="' + strToolTip + '"' + 'style="background-color:' + strColor + '"' +
										            ' CLASS="' + strEventColorClass + 'handCursor small" onMouseOver="this.className=' + "'apptTypeHighlite " + strEventColorClass + "handCursor small'" +
										            '" onMouseOut="this.className=' + "'" + strEventColorClass + "handCursor small'" +
										            '" onclick="updateAppt(' + sXMLDay + ',\'' + sApptUid + '\')">' +
                                                    '<a href="#calendar' + sApptUid + '" style="color:black" onclick="return false" ondragstart="dragStart(event)">' +
                                                    strApptTypeCaption + strCaption + '</a></TD>';
	                }
	                // lets the following rows know how many cols this table cell spans
	                tempArr[j] += 'x' + tempColSpan;
	                break;
			}
			openSpaceColSpan -= tempColSpan;
		}
        calendarColor = '#' + iMedica.DrawSchedule.CalendarColor;
        if (calendarColor == '#')
            calendarColor = '#FFFFCC';

        if (tempArr[0] == 'o' && tempArrLen == 1)
            str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + GUID_EMPTY + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';ggg;0;0\')" ' +
                            ' COLSPAN="' + openSpaceColSpan + '" CLASS="openTime" style="background-color:' + calendarColor + '" onclick="addAppt(' + sXMLDay + ',' + i + ', null)">&nbsp;</TD>';
		else
            str[sIndex++] = '<TD ondrop="drop(event)" ondragover="dragOver(event,\'calendar' + GUID_EMPTY + ";" + sCalendarUid + ';' + GUID_EMPTY + ';' + sDate + ';' + sApptDateTime + ';hhh;0;0\')" ' +
                            ' COLSPAN="' + openSpaceColSpan + '" CLASS="closeTime" onclick="addAppt(' + sXMLDay + ',' + i + ', null)">&nbsp;</TD>';
		str[sIndex++] = '</TR>';
	}
	str[sIndex++] = '</TABLE>';
	oDiv.outerHTML = str.join('');

	//iMedica.DrawSchedule.DebugOutput(str);

	//str = "";

	//for (i = 0; i < this.iNumMinInterval; i++) {
	//    tempArr = this.arrSchedule[i];
	//    tempArrLen = tempArr.length;

	//    for (j = 0; j < tempArrLen; j++) {
	//        str += tempArr[j] + "#";
	//    }
	//    str += "\r\n";
	//}
    //iMedica.DrawSchedule.DebugOutput(str);

	delete str;
}

function drawDayCustomize(sXmlDay)
{
    var oDiv = document.all['scheduleDay' + sXmlDay];
    var iDay = parseInt(sXmlDay, 10);
	this.bMoreAppts = false;
	iMedica.DrawSchedule.FindDaySlots(iDay);
	this.lngOpenHrMin = iMedica.DrawSchedule.StartTime/60;
	this.lngCloseHrMin = iMedica.DrawSchedule.EndTime/60;
	this.iOpenHr = Math.floor(this.lngOpenHrMin);
	this.iCloseHr = Math.ceil(this.lngCloseHrMin);
	this.arrSchedule = new Array();
	this.initArray(iMedica.DrawSchedule.IsCalendarTemplateDayOpen(iDay));
	this.populateArrayApptSlots();
	var str = new Array();
	var sIndex = 0;
	str[sIndex++] = '<TABLE ID="' + oDiv.id + '" cellpadding="2" cellspacing="1" STYLE="table-layout:fixed;">';
	if (this.iMaxCols > 1)
	{
		for (i = 1; i < this.iMaxCols; i++)
			str[sIndex++] = '<COL VALIGN="top">';
		str[sIndex++] = '<COL WIDTH="7">';
	}
	var i, j, k, xmlNode, strApptTypeCaption, strDisplay;
	var isReminder, sPersonUid, strPhone, strCopay, strReason, dStartDT, dEndDT, strCallConfirm, strEligStatus;
	var strCaption, iRowSpan, strColor, strStartTime, strEndTime, strToolTip, strPayerName, strPlanName;
	var tempArr, tempArrLen, tempAppt, tempColSpan, openSpaceColSpan;
	var tempApptTypeUid, tempCalendarTimeSlotUid, sApptUid;
	for (i = 0; i < this.iNumMinInterval; i++)
	{
	    str[sIndex++] = '<TR HEIGHT="' + this.iIntervalHeight + '">';
		tempArr = this.arrSchedule[i];
		tempArrLen = tempArr.length;
		openSpaceColSpan = this.iMaxCols;
		for (j = 1; j < tempArrLen; j++)
		{
		    tempColSpan = 1;
		    tempApptlen = tempArr.length;

		    //bug 31890 - not checking for nulls before accessing substring
		    if(tempArr[j] != null)
		    switch (tempArr[j].substr(0, 1))
			{
				case 'a': // avaliable slot
					if (tempArr == "o")
						str[sIndex++] = '<TD CLASS="openTime" ';
					else
						str[sIndex++] = '<TD CLASS="closeTime" ';

					str[sIndex++] = 'onclick="ConfigureCalendarTemplateEmptySlot(' + sXmlDay + ',' + i + ')">&nbsp;</TD>';
					break;
				case 'x': // continuation of an appt, event, or appt slot
					for (k = i - 1; k >= 0; k--)
					{
						if (this.arrSchedule[k][j].substr(0, 1) != 'x')
						{
							tempAppt = this.arrSchedule[k][j].split('x');
							tempColSpan = tempAppt[tempAppt.length - 1];
							break;
						}
					}
					break;
				case 's': // beginning of an appt slot
					tempAppt = tempArr[j].split('x');
					tempColSpan = (tempAppt.length > 3 ? 1 : (tempArrLen == 2 ? (this.iMaxCols - 1) : (j == tempArrLen - 1 ? (this.iMaxCols - j) : 1)));
					tempUidArr = tempAppt[0].substr(1).split('~');
					tempApptTypeUid = tempUidArr[0];
					tempCalendarTimeSlotUid = tempUidArr[1];

					if (!iMedica.AppointmentType.FindAppointmentType(tempApptTypeUid))
					{
						strApptTypeCaption = "Unknown/Deleted Appointment Type";
						strColor = "red";
					}
					else
					{
						strApptTypeCaption = escapeHTML(iMedica.AppointmentType.Name);
						strColor = iMedica.AppointmentType.Color;
					}
					iRowSpan = parseInt(tempAppt[1], 10);

					iMedica.DrawSchedule.CurrentSlotIndex = parseInt(tempAppt[2], 10);
					strStartTime = convertMinsToTimeStr(iMedica.DrawSchedule.SlotStartTime);
					strEndTime = convertMinsToTimeStr(iMedica.DrawSchedule.SlotEndTime);
					strToolTip = strApptTypeCaption  + '\n' + strStartTime + '-' + strEndTime;
					if (iRowSpan > 1)
					{
						str[sIndex++] = '<TD COLSPAN="' + tempColSpan + '" ROWSPAN="' + iRowSpan + '" title="' + strToolTip + '"';
						if (this.bDefaultColorScheme || strColor == '')
							str[sIndex++] = ' CLASS="apptTypeDefaultColor handCursor" onMouseOver="this.className=' + "'apptTypeDefaultColor apptTypeHighlite handCursor'" +
											'" onMouseOut="this.className=' + "'apptTypeDefaultColor handCursor'" + '"' + (tempApptTypeUid != GUID_EMPTY ? ' onclick="ConfigureCalendarTimeSlot(\'' + tempCalendarTimeSlotUid + '\')"' : '') + '><DIV CLASS="small"';
						else
							str[sIndex++] = ' CLASS="handCursor" onMouseOver="this.className=' + "'apptTypeHighlite handCursor'" +
											'" onMouseOut="this.className=' + "'handCursor'" +
											'" style="background-color:' + strColor + (tempApptTypeUid != GUID_EMPTY ? '" onclick="ConfigureCalendarTemplateAppointmentSlot(\'' + tempCalendarTimeSlotUid +
											'\')"': '') + '"><DIV CLASS="small" style="background-color:' + strColor + '"';
						str[sIndex++] = ' style="overflow: hidden; height: ' + (iRowSpan*(this.iIntervalHeight - 3)) +
											'"><EM>' + strApptTypeCaption + '</EM></DIV></TD>';
					}
					else
					{
						str[sIndex++] = '<TD NOWRAP="true" COLSPAN="' + tempColSpan + '" title="' + strToolTip + '"';
						if (this.bDefaultColorScheme || strColor == '')
							str[sIndex++] = ' CLASS="apptTypeDefaultColor handCursor small" onMouseOver="this.className=' + "'apptTypeHighlite apptTypeDefaultColor handCursor small'" +
											'" onMouseOut="this.className=' + "'apptTypeDefaultColor handCursor small'" + '"' + (tempApptTypeUid != GUID_EMPTY ? ' onclick="ConfigureCalendarTimeSlot(\'' + tempCalendarTimeSlotUid + '\')"': '') + '>';
						else
							str[sIndex++] = ' CLASS="handCursor small" onMouseOver="this.className=' + "'apptTypeHighlite handCursor small'" +
											'" onMouseOut="this.className=' + "'handCursor small'" +
											'" style="background-color:' + strColor + '"' + (tempApptTypeUid != GUID_EMPTY ? ' onclick="ConfigureCalendarTemplateAppointmentSlot(\'' + tempCalendarTimeSlotUid + '\')"' : '') + '>';
						str[sIndex++] = '<EM>' + strApptTypeCaption + '</EM></TD>';
					}
					// lets the following rows know how many cols this table cell spans
					tempArr[j] += 'x' + tempColSpan;
					break;
			}
			openSpaceColSpan -= tempColSpan;
		}
		if (tempArr[0] == "o")
			str[sIndex++] = '<TD COLSPAN="' + openSpaceColSpan + '" CLASS="openTime" ';
		else
			str[sIndex++] = '<TD COLSPAN="' + openSpaceColSpan + '" CLASS="closeTime" ';
		str[sIndex++] = 'onclick="ConfigureCalendarTemplateEmptySlot(' + sXmlDay + ',' + i + ')">&nbsp;</TD></TR>';
		//alert(tempArr[0] + "(" + tempApptlen+ ") " + str[sIndex - 2] + " " + str[sIndex - 1]);
	}
	str[sIndex++] = '</TABLE>';
	oDiv.outerHTML = str.join('');
	delete str;
}

function drawDayPrint(oDiv, xmlAppts, iDay)
{
    var sDate = xmlAppts.getAttribute("date");
	this.bMoreAppts = false;
	iMedica.DrawSchedule.FindCalendarSlotAll(iDay);
	this.arrSchedule = new Array();
	this.initArray(iMedica.DrawSchedule.IsOpen(iDay));
	this.populateArrayApptSlots();
	var xmlApptNodes = xmlAppts.childNodes;
	this.populateArrayAppts(new Date(sDate), xmlApptNodes);
	var str = new Array();
	var sIndex = 0;
	str[sIndex++] = '<TABLE ID="' + oDiv.id + '" border="1" cellpadding="2" cellspacing="1" STYLE="table-layout:fixed;">';
	if (this.iMaxCols > 1)
	{
		for (i = 1; i < this.iMaxCols; i++)
			str[sIndex++] = '<COL VALIGN="top">';
		str[sIndex++] = '<COL WIDTH="7">';
	}
	var i, j, k, xmlNode, strApptTypeCaption, strDisplay;
	var strPhone, strCopay, strReason, dStartDT, dEndDT;
	var strCaption, iRowSpan, strStartTime, strEndTime;
	var tempArr, tempArrLen, tempAppt, tempApptlen, tempColSpan, openSpaceColSpan;
	var tempApptTypeUid, sApptUid;
	for (i = 0; i < this.iNumMinInterval; i++)
	{
	    str[sIndex++] = '<TR HEIGHT="' + this.iIntervalHeight + '">';
		tempArr = this.arrSchedule[i];
		tempArrLen = tempArr.length;
		openSpaceColSpan = this.iMaxCols;
		for (j = 1; j < tempArrLen; j++)
		{
		    tempColSpan = 1;

		    //bug 31890 - not checking for nulls before accessing substring
		    if(tempArr[j] != null)
			switch (tempArr[j].substr(0,1))
			{
				case 'a': // avaliable slot
					if (tempArr[0] == 'o' && tempArrLen == 1)
						str[sIndex++] = '<TD CLASS="openTime">&nbsp;</TD>';
					else
						str[sIndex++] = '<TD CLASS="closeTime">&nbsp;</TD>';
					break;
				case 'x': // continuation of an appt, event, or appt slot
					for (k = i - 1; k >= 0; k--)
					{
						if (this.arrSchedule[k][j].substr(0, 1) != 'x')
						{
							tempAppt = this.arrSchedule[k][j].split('x');
							tempColSpan = tempAppt[tempAppt.length - 1];
							break;
						}
					}
					break;
				case 's': // beginning of an appt slot
					tempAppt = tempArr[j].split('x');
					tempColSpan = (tempAppt.length > 3 ? 1 : (tempArrLen == 2 ? this.iMaxCols : (j == tempArrLen - 1 ? (this.iMaxCols - j) : 1)));
					tempUidArr = tempAppt[0].substr(1).split('~');
					tempApptTypeUid = tempUidArr[0];
					//tempCalendarTimeSlotUid = tempUidArr[1];

					if (!iMedica.AppointmentType.FindAppointmentType(tempApptTypeUid))
						strApptTypeCaption = "Unknown/Deleted Appointment Type";
					else
						strApptTypeCaption = escapeHTML(iMedica.AppointmentType.Name);
					iRowSpan = parseInt(tempAppt[1], 10);
					iMedica.DrawSchedule.CurrentSlotIndex = parseInt(tempAppt[2], 10);
					strStartTime = convertMinsToTimeStr(iMedica.DrawSchedule.SlotStartTime);
					strEndTime = convertMinsToTimeStr(iMedica.DrawSchedule.SlotEndTime);
					if (iRowSpan > 1)
						str[sIndex++] = '<TD COLSPAN="' + tempColSpan + '" ROWSPAN="' + iRowSpan + '"><DIV CLASS="small"' +
										' style="overflow: hidden; height: ' + (iRowSpan*(this.iIntervalHeight - 3)) +
										'"><EM>' + strApptTypeCaption + '</EM></DIV></TD>';
					else
						str[sIndex++] = '<TD NOWRAP="true" COLSPAN="' + tempColSpan + '" CLASS="small">' +
										'<EM>' + strApptTypeCaption + '</EM></TD>';
					// lets the following rows know how many cols this table cell spans
					tempArr[j] += 'x' + tempColSpan;
					break;
				case 'p': // beginning of an appt
					tempAppt = tempArr[j].split('x');
					tempColSpan = (tempAppt.length > 3 ? 1 : (tempArrLen == 2 ? this.iMaxCols : (j == tempArrLen - 1 ? (this.iMaxCols - j) : 1)));
					xmlNode = xmlApptNodes[parseInt(tempAppt[2])];
					sApptUid = xmlNode.getAttribute("apptUid");
					if (!iMedica.AppointmentType.FindAppointmentType(xmlNode.getAttribute("apptTypeUid")))
						strApptTypeCaption = '';
					else
						strApptTypeCaption = escapeHTML(iMedica.AppointmentType.Name) + ": ";
					strCaption = escapeHTML(xmlNode.getAttribute("caption"));
					strPhone = xmlNode.getAttribute("phone");
					strCopay = xmlNode.getAttribute("copay");
					if (strCopay == "$0.00" || strCopay == "-$0.00")
						strCopay = '';
					strReason = strApptTypeCaption + escapeHTML(xmlNode.getAttribute("reason"));
					iRowSpan = parseInt(tempAppt[1], 10);
					dStartDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("startDT"));
					dEndDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("endDT"));
					strStartTime = convertDateObjToDateStr(dStartDT, '/') + ' ' + convertDateObjTo12HRTime(dStartDT);
					strEndTime = convertDateObjToDateStr(dEndDT, '/') + ' ' + convertDateObjTo12HRTime(dEndDT);
					if (iRowSpan > 1)
						str[sIndex++] = '<TD COLSPAN="' + tempColSpan + '" ROWSPAN="' + iRowSpan + '"><DIV CLASS="small" style="overflow: hidden; height: ' + (iRowSpan*(this.iIntervalHeight - 3)) +
										'">' + createDivText(null, null, strCaption, strCopay, strReason, strPhone, strAppointmentStatus, null, sApptUid, null) + '</DIV></TD>';
					else
						str[sIndex++] = '<TD NOWRAP="true" COLSPAN="' + tempColSpan + '" CLASS="small">' +
										createDivText(null, null,  strCaption, strCopay, strReason, strPhone, strAppointmentStatus, null, sApptUid, null) + '</TD>';
					// lets the following rows know how many cols this table cell spans
					tempArr[j] += 'x' + tempColSpan;
					break;
				case 'e': // beginning of an event
					tempAppt = tempArr[j].split('x');
					tempColSpan = (tempAppt.length > 3 ? 1 : (tempArrLen == 2 ? this.iMaxCols : (j == tempArrLen - 1 ? (this.iMaxCols - j) : 1)));
					xmlNode = xmlApptNodes[parseInt(tempAppt[2])];
					sApptUid = xmlNode.getAttribute("apptUid");
					strReason = escapeHTML(xmlNode.selectSingleNode("reason").text);
					strPhone = xmlNode.getAttribute("phone");
					strCaption = '<B>' + strReason + '</B>, ' + strPhone;
					iRowSpan = parseInt(tempAppt[1], 10);
					dStartDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("startDT"));
					dEndDT = convertXMLDateTimeToJSDateObj(xmlNode.getAttribute("endDT"));
					strStartTime = convertDateObjToDateStr(dStartDT, '/') + ' ' + convertDateObjTo12HRTime(dStartDT);
					strEndTime = convertDateObjToDateStr(dEndDT, '/') + ' ' + convertDateObjTo12HRTime(dEndDT);
					if (iRowSpan > 1)
						str[sIndex++] = '<TD COLSPAN="' + tempColSpan + '" ROWSPAN="' + iRowSpan + '"><DIV CLASS="small" style="overflow: hidden; height: ' +
										(iRowSpan*(this.iIntervalHeight - 3)) + '">' + strCaption + '</DIV></TD>';
					else
						str[sIndex++] = '<TD NOWRAP="true" COLSPAN="' + tempColSpan + '" CLASS="small">' + strCaption + '</TD>';
					// lets the following rows know how many cols this table cell spans
					tempArr[j] += 'x' + tempColSpan;
					break;
			}
			openSpaceColSpan -= tempColSpan;
		}
		if (tempArrLen == 1)
			if (tempArr[0] == 'o' && tempArrLen == 1)
				str[sIndex++] = '<TD COLSPAN="' + openSpaceColSpan + '" CLASS="openTime">&nbsp;</TD>';
			else
				str[sIndex++] = '<TD COLSPAN="' + openSpaceColSpan + '" CLASS="closeTime">&nbsp;</TD>';
		str[sIndex++] = '</TR>';
	}
	str[sIndex++] = '</TABLE>';
	oDiv.outerHTML = str.join('');
	delete str;
}

function setCallConfirm(strCallConfirm)
{
	switch (strCallConfirm)
	{
		case "call":
			return '&nbsp;<img src="../images/phoneCall.gif" width="14" height="12" BORDER="0" title="Call to confirm appointment" />';
		case "confirmed":
			return '&nbsp;<img src="../images/phoneConfirmed.gif" width="14" height="12" BORDER="0" title="Appointment confirmed" />';
		case "leftMessage":
			return '&nbsp;<img src="../images/phoneMessage.gif" width="14" height="12" BORDER="0" title="Left appointment confirmation message" />';
		case "error":
			return '&nbsp;<img src="../images/phoneFailed.gif" width="14" height="12" BORDER="0" title="Appointment confirmation failed" />';
	}
	return '';
}

function setEligibilityStatus(strEligStatus, accountUid, isNoted)
{
	var sRealStatus = strEligStatus;
	var sReturn = "";
	switch (sRealStatus)
	{
        case "processing":
            sReturn = '&nbsp;<img class="handCursor" src="../Prm.Client/iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityProcessing.png" width="13" height="13" BORDER="0" title="Eligibility is downloading" onclick="iMedica.Common.OpenEligibility(\'' + accountUid + '\')" />&#xa0;';
            break;
	    case "activecoverage":
	        if (isNoted.length > 0)
	            sReturn = '&nbsp;<img class="handCursor" src="../Prm.Client/iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityActiveNote.png" width="13" height="13" BORDER="0" title="Patient is eligible\r\n\r\n' + isNoted + '" onclick="iMedica.Common.OpenEligibility(\'' + accountUid + '\')" />&#xa0;';
            else
		        sReturn = '&nbsp;<img class="handCursor" src="../Prm.Client/iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityActive.png" width="13" height="13" BORDER="0" title="Patient is eligible" onclick="iMedica.Common.OpenEligibility(\'' + accountUid + '\')" />&#xa0;';
            break;
		case "inactivecoverage":
		    sReturn = '&nbsp;<img class="handCursor" src="../Prm.Client/iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityInactive.png" width="13" height="13" BORDER="0" title="Patient is NOT eligible" onclick="iMedica.Common.OpenEligibility(\'' + accountUid + '\')" />&#xa0;';
            break;
		case "error":
		    sReturn = '&nbsp;<img class="handCursor" src="../Prm.Client/iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityError.png" width="13" height="13" BORDER="0" title="Eligibility return an Error" onclick="iMedica.Common.OpenEligibility(\'' + accountUid + '\')" />&#xa0;';
            break;
		case "unknown":
		    sReturn = '&nbsp;<img class="handCursor" src="../Prm.Client/iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityUnknown.png" width="13" height="13" BORDER="0" title="Patient eligibility is unknown" onclick="iMedica.Common.OpenEligibility(\'' + accountUid + '\')" />&#xa0;';
            break;
        case "expired":
            sReturn = '&nbsp;<img class="handCursor" src="../Prm.Client/iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityExpired.png" width="13" height="13" BORDER="0" title="Patient eligibility is unknown" onclick="iMedica.Common.OpenEligibility(\'' + accountUid + '\')" />&#xa0;';
            break;
        default:
			break;
	}
    return sReturn;
}

function SetDeleteIcon(sXMLDay, i, appointmentTypeUid, startTime, endTime)
{
    return '&nbsp;<img class="handCursor" src="../Prm.Client/iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/Delete.png" width="13" height="13" BORDER="0" title="Delete Allocation" onclick="removeAllocation(\'' + sXMLDay + '\',' + i + ',\'' + appointmentTypeUid + '\',\'' + startTime + '\',\'' + endTime + '\')" />&#xa0;';
}

function setIconDropDown(sXMLDay, sApptUid, bAllowCheckout)
{
    var sHTML = '';
	if (bAllowCheckout)
		sHTML = sHTML + '<img id="CO' + sApptUid + '" src="../images/checkout.gif" class="handCursor" width="19" height="13" onclick="navigateToCheckout(\'' + sApptUid + '\');" title="Complete patient checkout" />&#xa0;'

	return sHTML + '<img id="MO' + sApptUid + '" src="../Prm.Client/iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/moreArrow.gif" class="handCursor" width="19" height="13" onclick="showContextMenu(\'' + sApptUid + '\');" title="Click here for more options" STYLE="filter: FlipH" />';
}

function navigateToCheckout(sApptUid)
{
	event.cancelBubble = true;
	iMedica.Common.NavigateToCheckout(sApptUid);
}

function showContextMenu(sApptUid)
{
	event.cancelBubble = true;
	iMedica.Appointment.ShowContextMenu(sApptUid, event.clientX, event.clientY);
}

function getApptNode(sXMLDay, sApptUid)
{
	return document.all['xmlDay' + sXMLDay].documentElement.selectSingleNode('aps[@apptUid="' + sApptUid + '"]');
}

function createDivText(isReminder, hasArpBalance, caption, copay, reason, phone, status, forecolor, apptUid, collectionStatusName, collectionAlerted) {
    var str = '<a href="#calendar' + apptUid + '" style="color:black" onclick="return false" ondragstart="dragStart(event)">';
    var i = 0;
    if (caption != null && caption != "") {
        if (isReminder == '1')
            str += '<FONT COLOR="purple"><B>' + caption + '</B></FONT>, ';
        else
            str += '<B>' + caption + '</B>, ';
    }
    if (status != null && status != '') {
        if (forecolor != null) {
            str += '<FONT COLOR="' + forecolor + '">' + status + '</FONT>, ';
        }
        else
            str += status + ', ';
    }
    if (collectionStatusName !== '')
        str = '<img src="../images/dollarsignRed.png" width="13" height="13" border="0" alt=\'' + collectionStatusName + '\' /> ' + str;
    else if (collectionAlerted == '1')
        str = '<img src="../images/dollarsignYellow.png" width="13" height="13" border="0" alt="Alerted"/> ' + str;
    else if (hasArpBalance == '1')
        str = '<img src="../images/dollarsign.png" width="13" height="13" border="0" alt="Responsible Party Balance"/> ' + str;
    if (phone != null && phone != '')
        str += phone + ', ';
    // TODO: disable copay for beta1
    if (false) {
        if (isPracticeBasicBilling(parent.fnPracticeBillingLevel())) {
            if (copay == "$0.00" || copay == "-$0.00" || copay == '')
                str += ", ";
            else {
                if (copay.substr(0, 1) == '-')
                    str += '<FONT COLOR="red">' + copay.substr(1) + '</FONT>, ';
                else
                    str += copay + 'PD, ';
            }
        }
    }
    str += reason;
    str += '</a>';
    return str;
}

function convertXMLColor(strColor) {
    var num = parseInt(strColor, 10) & 0xFFFFFF;
    var i = 0; var j = 20;
    var str = "#";

    while (j >= 0) {
        i = (num >> j) % 16;
        if (i >= 10) {
            if (i == 10) str += "A";
            else if (i == 11) str += "B";
            else if (i == 12) str += "C";
            else if (i == 13) str += "D";
            else if (i == 14) str += "E";
            else str += "F";
        }
        else
            str += i;
        j -= 4;
    }
    return str;
}

function altString(strPlanMemberID, strEligibilitySubscriberID, strOtherPayerTypeCode) {
    var retVal = "";
    if (strPlanMemberID != strEligibilitySubscriberID) {
        retVal += "Plan Member ID (" + strPlanMemberID + ") does not match eligibility Subscriber ID (" + strEligibilitySubscriberID + ")\r\n\r\n";
    }

    if (strOtherPayerTypeCode) {
        retVal += 'Other or Additional Payer\r\n';

        switch (strOtherPayerTypeCode) {
            case "12": retVal += "12 Medicare Secondary Working Aged Beneficiary or Spouse with Employer Group Health Plan"; break;
            case "13": retVal += "13 Medicare Secondary End-Stage Renal Disease Beneficiary in the Mandated Coordination Period with an Employers Group Health Plan"; break;
            case "14": retVal += "14 Medicare Secondary, No-fault Insurance including Auto is Primary"; break;
            case "15": retVal += "15 Medicare Secondary Workers Compensation"; break;
            case "16": retVal += "16 Medicare Secondary Public Health Service (PHS)or Other Federal Agency"; break;
            case "41": retVal += "41 Medicare Secondary Black Lung"; break;
            case "42": retVal += "42 Medicare Secondary Veterans Administration"; break;
            case "43": retVal += "43 Medicare Secondary Disabled Beneficiary Under Age 65 with Large Group Health Plan (LGHP)"; break;
            case "47": retVal += "47 Medicare Secondary, Other Liability Insurance is Primary"; break;
            case "AP": retVal += "AP Auto Insurance Policy"; break;
            case "C1": retVal += "C1 Commercial"; break;
            case "CO": retVal += "CO Consolidated Omnibus Budget Reconciliation Act (COBRA)"; break;
            case "CP": retVal += "CP Medicare Conditionally Primary"; break;
            case "D": retVal += "D  Disability"; break;
            case "DB": retVal += "DB Disability Benefits"; break;
            case "EP": retVal += "EP Exclusive Provider Organization"; break;
            case "FF": retVal += "FF Family or Friends"; break;
            case "GP": retVal += "GP Group Policy"; break;
            case "HM": retVal += "HM Health Maintenance Organization (HMO)"; break;
            case "HN": retVal += "HN Health Maintenance Organization (HMO) - Medicare Risk"; break;
            case "HS": retVal += "HS Special Low Income Medicare Beneficiary"; break;
            case "IN": retVal += "IN Indemnity"; break;
            case "IP": retVal += "IP Individual Policy"; break;
            case "LC": retVal += "LC Long Term Care"; break;
            case "LD": retVal += "LD Long Term Policy"; break;
            case "LI": retVal += "LI Life Insurance"; break;
            case "LT": retVal += "LT Litigation"; break;
            case "MA": retVal += "MA Medicare Part A"; break;
            case "MB": retVal += "MB Medicare Part B"; break;
            case "MC": retVal += "MC Medicaid"; break;
            case "MH": retVal += "MH Medigap Part A"; break;
            case "MI": retVal += "MI Medigap Part B"; break;
            case "MP": retVal += "MP Medicare Primary"; break;
            case "OT": retVal += "OT Other"; break;
            case "PE": retVal += "PE Property Insurance - Personal"; break;
            case "PL": retVal += "PL Personal"; break;
            case "PP": retVal += "PP Personal Payment (Cash - No Insurance)"; break;
            case "PR": retVal += "PR Preferred Provider Organization (PPO)"; break;
            case "PS": retVal += "PS Point of Service (POS)"; break;
            case "QM": retVal += "QM Qualified Medicare Beneficiary"; break;
            case "RP": retVal += "RP Property Insurance - Real"; break;
            case "SP": retVal += "SP Supplemental Policy"; break;
            case "TF": retVal += "TF Tax Equity Fiscal Responsibility Act (TEFRA)"; break;
            case "WC": retVal += "WC Workers Compensation"; break;
            case "WU": retVal += "WU Wrap Up Policy"; break;
            default: break;
        }
    }

    return retVal;
}


schedule.prototype.setSingleCalendar = setSingleCalendar;
schedule.prototype.setCalendarDay = setCalendarDay;
schedule.prototype.setCalendarTemplate = setCalendarTemplate;
schedule.prototype.setCalendarAttribute = setCalendarAttribute;
schedule.prototype.drawTime = drawTime;
schedule.prototype.drawDay = drawDay;
schedule.prototype.drawDayCustomize = drawDayCustomize;
schedule.prototype.drawDayPrint = drawDayPrint;
schedule.prototype.initArray = initArray;
schedule.prototype.checkApptPos = checkApptPos;
schedule.prototype.checkMaxCols = checkMaxCols;
schedule.prototype.extendColumn = extendColumn;
schedule.prototype.populateArrayApptSlots = populateArrayApptSlots;
schedule.prototype.populateArrayAppts = populateArrayAppts;
schedule.prototype.initClass = initClass;