<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
 xmlns:user="urn:schemas-physicianaccess.com:paweb" >
  <xsl:strip-space elements="*"/>
  <xsl:param name="ForPrinting" select="0" />
  <xsl:output method="html" version="4.0"/>
  <xsl:template match="ViewAppointments">
    <xsl:variable name="showCalendar" select="@showCalendar"/>
    <xsl:variable name="checkinStatusName" select="@checkinStatusName"/>
    <xsl:variable name="checkinStatusColor" select="@checkinStatusColor"/>
    <xsl:variable name="dischargeStatusName" select="@dischargeStatusName"/>
    <xsl:variable name="dischargeStatusColor" select="@dischargeStatusColor"/>
    <xsl:variable name="ReadyToDischargeUid" select="@ReadyToDischargeUid"/>
    <xsl:for-each select="ViewAppointment">
      <table cellpadding="1" cellspacing="0" width="100%" style="table-layout: fixed">
        <xsl:if test="$ForPrinting = 0">
          <xsl:attribute name="onmouseover">EnableAlphaFilter(this);</xsl:attribute>
          <xsl:attribute name="onmouseout">DisableAlphaFilter(this);</xsl:attribute>
        </xsl:if>
        <xsl:attribute name="id">
          a<xsl:value-of select="position()"/>b<xsl:value-of select="user:convertXMLDateTimeToMins(string(@StartDateTime))"/>
        </xsl:attribute>
        <xsl:attribute name="bgcolor">
          <xsl:choose>
            <xsl:when test="position() mod 2 = 0">whitesmoke</xsl:when>
            <xsl:otherwise>white</xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <col width="60"/>
        <col width="34"/>
        <col/>
        <tr valign="top">
                  <xsl:variable name="PlanMemberID" select="user:UCString(string(ViewAccountPeriodEligibilityDate/@PlanMemberID))" />
                  <xsl:variable name="eligibilitySubscriberID" select="user:UCString(string(ViewAccountPeriodEligibilityDate/@eligibilitySubscriberID))" />
          <xsl:variable name="abc" select="user:altString(string(@PlanMemberID),string(@eligibilitySubscriberID), string(@OtherPayerTypeCode))" />
          <td>
            <xsl:choose>
              <xsl:when test="$ForPrinting = 0">
                <a href="#" class="std" title="Click here to edit this appointment">
                  <xsl:attribute name="onclick">
                    iMedica.Appointment.EditAppointment('<xsl:value-of select="@AppointmentUid"/>');
                  </xsl:attribute>
                  <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@StartDateTime))"/>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <span class="std">
                  <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@StartDateTime))"/>
                </span>
              </xsl:otherwise>
            </xsl:choose>
            <br/>
            <xsl:choose>
              <xsl:when test="$ForPrinting = 0">
                <span style="COLOR:{user:convertXMLColor (string (@ApptStatusColor))};" class="small">
                  <xsl:value-of select="string(@AppointmentStatusName)"/>
                  <xsl:text> </xsl:text>
                </span>
              </xsl:when>
              <xsl:otherwise>
                <span class="small">
                  <xsl:value-of select="string(@AppointmentStatusName)"/>
                  <xsl:text> </xsl:text>
                </span>
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td>
            <xsl:choose>
              <xsl:when test="string(@CollectionStatusUid) != ''">
                <img src="../images/dollarsignRed.png" width="16" height="16" border="0" alt="{@CollectionStatusName}" />
              </xsl:when>
              <xsl:when test="string(@CollectionAlerted) = 'True'">
                <img src="../images/dollarsignYellow.png" width="16" height="16" border="0" alt="Alerted" />
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="@HasArpBalance = 'True'">
                    <img src="../images/dollarsign.png" width="16" height="16" border="0" alt="Responsible Party Balance"/>
                  </xsl:when>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
              <xsl:when test="@isCommitted = 'True'">
                <img src="../images/VisitNoteLock.png" width="16" height="16" border="0" alt="Medical record complete"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="@EligibilityStatus = 'Processing'">
                    <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityProcessing.png" width="16" height="16" border="0" alt="Eligibility Processing" >
                      <xsl:attribute name="onclick">
                        iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                      </xsl:attribute>
                    </img>
                  </xsl:when>
                  <xsl:when test="@EligibilityStatus = 'ActiveCoverage'">
                    <xsl:choose>
                      <xsl:when 
						test="(($PlanMemberID != $eligibilitySubscriberID)and (string($eligibilitySubscriberID))) or (string(@OtherPayerTypeCode) and string-length(@OtherPayerTypeCode) > 0)">
                        <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityActiveNote.png" width="16" height="16" border="0" alt="{$abc}" >
                          <xsl:attribute name="onclick">
                            iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                          </xsl:attribute>
                        </img>
                      </xsl:when>
                      <xsl:otherwise>
                        <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityActive.png" width="16" height="16" border="0" alt="Eligibility Active Coverage" >
                          <xsl:attribute name="onclick">
                            iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                          </xsl:attribute>
                        </img>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:when test="@EligibilityStatus = 'InactiveCoverage'">
                    <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityInactive.png" width="16" height="16" border="0" alt="Eligibility Inactive Coverage">
                      <xsl:attribute name="onclick">
                        iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                      </xsl:attribute>
                    </img>
                  </xsl:when>
                  <xsl:when test="@EligibilityStatus = 'Error'">
                    <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityError.png" width="16" height="16" border="0" alt="Eligibility Error">
                      <xsl:attribute name="onclick">
                        iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                      </xsl:attribute>
                    </img>
                  </xsl:when>
                  <xsl:when test="@EligibilityStatus = 'Unknown'">
                    <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityUnknown.png" width="16" height="16" border="0" alt="Eligibility Unknown">
                      <xsl:attribute name="onclick">
                        iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                      </xsl:attribute>
                    </img>
                  </xsl:when>
                  <xsl:when test="@EligibilityStatus = 'Expired'">
                    <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/EligibilityExpired.png" width="16" height="16" border="0" alt="Eligibility Expired">
                      <xsl:attribute name="onclick">
                        iMedica.Common.OpenEligibility('<xsl:value-of select="@AccountUid"/>')
                      </xsl:attribute>
                    </img>
                  </xsl:when>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </td>
          <td class="std">
						<xsl:choose>
              <!-- this is an event appointment -->
							<xsl:when test="string(@ScheduleType) = 'Event'">
                <xsl:if test="string(@AppointmentTypeUid) != ''">
                  <span style="COLOR:{user:convertXMLColorHex (string (@ApptTypeColor))};">
                    <xsl:value-of select="string(@AppointmentTypeName)"/>
                  </span>:<xsl:text> </xsl:text>
                </xsl:if>
                <xsl:value-of select="@Reason"/>
                <xsl:if test="string(@PhoneNumber) != ''">
                  <xsl:text> </xsl:text>
                  <xsl:value-of select="@PhoneNumber"/>
                  <xsl:text> </xsl:text>
                </xsl:if>

              </xsl:when>
              <!-- this is an blockingevent appointment -->
              <xsl:when test="string(@ScheduleType) = 'BlockingEvent'">
                <xsl:if test="string(@AppointmentTypeUid) != ''">
                  <span style="COLOR:{user:convertXMLColorHex (string (@ApptTypeColor))};">
                    <xsl:value-of select="string(@AppointmentTypeName)"/>
                  </span>:<xsl:text> </xsl:text>
                </xsl:if>
                <xsl:value-of select="@Reason"/>
                <xsl:if test="string(@PhoneNumber) != ''">
                  <xsl:text> </xsl:text>
                  <xsl:value-of select="@PhoneNumber"/>
                  <xsl:text> </xsl:text>
                </xsl:if>

              </xsl:when>

              <!-- this is a group visit appointment -->
              <xsl:when test="string(@ScheduleType) = 'GroupVisit'">
                <xsl:if test="string(@AppointmentTypeUid) != ''">
                  <span style="COLOR:{user:convertXMLColorHex (string (@ApptTypeColor))};">
                    <xsl:value-of select="string(@AppointmentTypeName)"/>
                  </span>:<xsl:text> </xsl:text>
                </xsl:if>
                <xsl:if test="$ForPrinting = 0">
                  <!-- need to do redo this icon as create the visitNote for all patients -->
                  <xsl:if test="string(@CanCreateGroupVisit) != 'False'">
                    <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/patientVisitNoteOpen.png" width="18" height="11" border="0" alt="Open/Create Note">
                      <xsl:attribute name="onclick">
                        iMedica.Common.NavigateToGroupNote('<xsl:value-of select="@AppointmentUid"/>')
                      </xsl:attribute>
                    </img>
                  </xsl:if>
                  <xsl:if test="string(@PhoneNumber) != ''">
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="@PhoneNumber"/>
                    <xsl:text> </xsl:text>
                  </xsl:if>
                  <img src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/moreArrow.gif" width="19" height="13" class="handcursor" title="Click here for more options">
                    <xsl:attribute name="onclick">
                      showContextMenu('<xsl:value-of select="@AppointmentUid"/>', 'a<xsl:value-of select="position()"/>b<xsl:value-of select="user:convertXMLDateTimeToMins(string(@StartDateTime))"/>')
                    </xsl:attribute>
                  </img>
                </xsl:if>
                <br/>
                <xsl:value-of select="@Reason"/>
              </xsl:when>

              <!-- this is an patientvisit appointment -->
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="$ForPrinting = 0">
                    <a href="#" title="Click here to view this patient's demographics">
                      <xsl:attribute name="onclick">
                        iMedica.Common.NavigateToDemographic("<xsl:value-of select="@PatientUid"/>");
                      </xsl:attribute>
                      <xsl:value-of select="@FullName"/>
                    </a>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@FullName"/>
                  </xsl:otherwise>
                </xsl:choose> (<xsl:choose>
                  <xsl:when test="string(@Birthdate) = ''">?</xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="user:convertXMLDateTimeToDateStr(string(@Birthdate))"/>
                  </xsl:otherwise>
                </xsl:choose>, <xsl:choose>
                  <xsl:when test="string(@MedicalRecordNumber) = ''">?</xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="@MedicalRecordNumber"/>
                  </xsl:otherwise>
                </xsl:choose>) : <xsl:if test="string(@PhoneNumber) != ''">
                <xsl:text> </xsl:text><xsl:value-of select="@PhoneNumber"/><xsl:text> </xsl:text>
                </xsl:if>
                <xsl:if test="$ForPrinting = 0">
                  <xsl:if test="string(@AppointmentStatusUid) = $ReadyToDischargeUid">
                    <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/checkout.gif" width="19" height="13" title="Complete patient checkout">
                      <xsl:attribute name="onclick">
                        iMedica.Common.NavigateToCheckout('<xsl:value-of select="@AppointmentUid"/>')
                      </xsl:attribute>
                    </img>
                    <xsl:text> </xsl:text>
                  </xsl:if>
                  <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/PatientInformation.gif" width="18" height="11" border="0">
                    <xsl:attribute name="onclick">
                      iMedica.Common.NavigateToPatientInformation('<xsl:value-of select="@PatientUid"/>', '<xsl:value-of select="@AppointmentUid"/>')
                    </xsl:attribute>
                    <xsl:attribute name="alt">
                      <xsl:value-of select="@AddressString"/>
                    </xsl:attribute>
                  </img>
                  <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/onepagesummary.png" width="18" height="11" border="0" alt="Open One Page Summary">
                    <xsl:attribute name="onclick">
                      iMedica.Common.NavigateToOPS('<xsl:value-of select="@PatientUid"/>')
                    </xsl:attribute>
                  </img>
                  <img class="handCursor" src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/patientVisitNoteOpen.png" width="18" height="11" border="0" alt="Open/Create Note">
                    <xsl:attribute name="onclick">
                      iMedica.Common.NavigateToNote('<xsl:value-of select="@PatientUid"/>', '<xsl:value-of select="@AppointmentUid"/>', '<xsl:value-of select="@AssociatedWithVisit"/>')
                    </xsl:attribute>
                  </img>
                  <img src="..\Prm.Client\iMedica.Prm.Client.Web.PageHandlers.EmbeddedResource.aspx?FileName=../images/moreArrow.gif" width="19" height="13" class="handcursor" title="Click here for more options">
                    <xsl:attribute name="onclick">
                      showContextMenu('<xsl:value-of select="@AppointmentUid"/>', 'a<xsl:value-of select="position()"/>b<xsl:value-of select="user:convertXMLDateTimeToMins(string(@StartDateTime))"/>')
                    </xsl:attribute>
                  </img>
                </xsl:if>
                <br/>
                <xsl:if test="(string(@AppointmentTypeUid) != '') or (@Reason != '')">
                  <xsl:if test="string(@AppointmentTypeUid) != ''">
                    <span style="COLOR:{user:convertXMLColorHex (string (@ApptTypeColor))};">
                      <xsl:value-of select="string(@AppointmentTypeName)"/>
                    </span>:<xsl:text> </xsl:text>
                  </xsl:if>
                  <xsl:value-of select="@Reason"/>
                  <br/>
                </xsl:if>
              </xsl:otherwise>
            </xsl:choose>
            
            <xsl:if test="$showCalendar = '1'">
              <span class="std">
                Calendar:<xsl:text> </xsl:text>
              </span>
              <span class="std">
                <xsl:value-of select="string(@Calendar)"/>
                <xsl:text> </xsl:text>
                <xsl:if test="@TimeZone != ''">
                  <xsl:text> - </xsl:text>
                  <span style="color:red">
                    <xsl:value-of select ="@TimeZone" />
                  </span>
                  <xsl:text> </xsl:text>
                </xsl:if>
              </span>
            </xsl:if>

            <!--table class="small" border="0" cellpadding="0" cellspacing="0" width="100%">
						<xsl:for-each select="sb">
							<tr>
								<td class="link" onmouseover="this.className='handCursor linkmouseover'" onmouseout="this.className='paxlink'" title="Go to superbill">
									<xsl:attribute name="onclick">gotoSuperbill(getSBNode(<xsl:value-of select="@ID"/>))</xsl:attribute>
									Superbill: <xsl:value-of select="user:convertXMLDateTimeToDateStr(string(@serviceDate))"/>, <xsl:value-of select="@status"/>
								</td>
							</tr>
						</xsl:for-each>
					</table-->
          </td>
          <td align="right">
            <xsl:choose>
              <xsl:when test="@CheckinDateTime">
                <xsl:choose>
                  <xsl:when test="$ForPrinting = 0">
                    <span class="small" style="COLOR:{user:convertXMLColor (string ($checkinStatusColor))};">
                      <xsl:value-of select="$checkinStatusName"/>
                      <xsl:text>: </xsl:text>
                      <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@CheckinDateTime))"/>
                      <xsl:if test="@DischargeDateTime">
                        <br/>
                        <span class="small" style="COLOR:{user:convertXMLColor (string ($dischargeStatusColor))};">
                          <xsl:value-of select="$dischargeStatusName"/>
                          <xsl:text>: </xsl:text>
                          <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@DischargeDateTime))"/>
                        </span>
                      </xsl:if>
                    </span>
                  </xsl:when>
                  <xsl:otherwise>
                    <span class="small" >
                      <xsl:value-of select="$checkinStatusName"/>
                      <xsl:text>: </xsl:text>
                      <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@CheckinDateTime))"/>
                      <xsl:if test="@DischargeDateTime">
                        <br/>
                        <span class="small" >
                          <xsl:value-of select="$dischargeStatusName"/>
                          <xsl:text>: </xsl:text>
                          <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@DischargeDateTime))"/>
                        </span>
                      </xsl:if>
                    </span>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="$ForPrinting = 0">
                    <xsl:if test="@DischargeDateTime">
                      <span class="small" style="COLOR:{user:convertXMLColor (string ($dischargeStatusColor))};">
                        <xsl:value-of select="$dischargeStatusName"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@DischargeDateTime))"/>
                      </span>
                    </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:if test="@DischargeDateTime">
                      <span class="small" >
                        <xsl:value-of select="$dischargeStatusName"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="user:convertXMLDateTimeTo12HRTime(string(@DischargeDateTime))"/>
                      </span>
                    </xsl:if>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr height='5'>
          <td/>
        </tr>
      </table>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="error">
    <table class="std" border="0" cellpadding="1" cellspacing="0" width="100%" style="table-layout: fixed">
      <tr>
        <td>
          <b>Server Error: </b>
          <xsl:value-of select="."/>
          <br/>
        </td>
      </tr>
    </table>
  </xsl:template>
  <msxsl:script language="Jscript" implements-prefix="user">
    <![CDATA[
function convertXMLDateTimeTo12HRTime(strDate)
{
  var oDate = new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
  var hour = parseInt(oDate.getHours(), 10);
  var mins = parseInt(oDate.getMinutes(), 10);
  return '' + (hour == 0 ? 12 : (hour > 12 ? hour - 12 : hour)) + ':' +  (mins < 10 ? ('0' + mins) : mins) + (hour < 12 ? ' AM' : ' PM');
}

function convertXMLDateTimeToDateStr(strDate)
{
  var oDate = new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
  return '' + (oDate.getMonth() + 1) + '/' + oDate.getDate() + '/' + oDate.getFullYear();
}

function convertXMLDateTimeToMins(strDate)
{
  var oDate = new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
  var hour = parseInt(oDate.getHours(), 10);
  var mins = parseInt(oDate.getMinutes(), 10);
  return hour * 60 + mins;
}

function convertXMLColorHex (strColor)
{
  if (strColor == "FFFFFF")
    return "#000000"
  return '#' + strColor;
}

/* Convert ARGB to RGB */
function convertXMLColor (strColor)
{
  var num = parseInt (strColor, 10) & 0xFFFFFF;
  var i = 0; var j = 20;
  var str = "#";

  while(j >= 0)
  {
    i = (num >> j)%16;
    if(i >= 10)
    {
      if(i == 10) str = str + "A";
      else if(i == 11) str = str + "B";
      else if(i == 12) str = str + "C";
      else if(i == 13) str = str + "D";
      else if(i == 14) str = str + "E";
      else str = str + "F";
    }
    else
      str += i;
    j -= 4;
  }
  return str;
}
   function UCString( strID) {
     var retVal = strID.toUpperCase() ;
    return retVal ;
    }
function altString(strPlanMemberID, strEligibilitySubscriberID, strOtherPayerTypeCode) {
  var retVal = 'Eligibility Active Coverage\r\n\r\n';
  if ( strPlanMemberID.toUpperCase() != strEligibilitySubscriberID.toUpperCase() ) {
    retVal = retVal + 'Plan Member ID (' + strPlanMemberID.toUpperCase() + ') does not match eligibility Subscriber ID (' + strEligibilitySubscriberID.toUpperCase() + ')\r\n\r\n' ;
  }

  if (strOtherPayerTypeCode) {
	  retVal += 'Eligibility or benefit code indicates contact the following entity for other or additional benefit information\r\n' ;
    switch (strOtherPayerTypeCode) {
        case "12": retVal = retVal + "12 Medicare Secondary Working Aged Beneficiary or Spouse with Employer Group Health Plan"; break;
        case "13": retVal = retVal + "13 Medicare Secondary End-Stage Renal Disease Beneficiary in the Mandated Coordination Period with an Employer’s Group Health Plan"; break;
        case "14": retVal = retVal + "14 Medicare Secondary, No-fault Insurance including Auto is Primary"; break;
        case "15": retVal = retVal + "15 Medicare Secondary Worker’s Compensation"; break;
        case "16": retVal = retVal + "16 Medicare Secondary Public Health Service (PHS)or Other Federal Agency"; break;
        case "41": retVal = retVal + "41 Medicare Secondary Black Lung"; break;
        case "42": retVal = retVal + "42 Medicare Secondary Veteran’s Administration"; break;
        case "43": retVal = retVal + "43 Medicare Secondary Disabled Beneficiary Under Age 65 with Large Group Health Plan (LGHP)"; break;
        case "47": retVal = retVal + "47 Medicare Secondary, Other Liability Insurance is Primary"; break;
        case "AP": retVal = retVal + "AP Auto Insurance Policy"; break;
        case "C1": retVal = retVal + "C1 Commercial"; break;
        case "CO": retVal = retVal + "CO Consolidated Omnibus Budget Reconciliation Act (COBRA)"; break;
        case "CP": retVal = retVal + "CP Medicare Conditionally Primary"; break;
        case "D" : retVal = retVal + "D  Disability"; break;
        case "DB": retVal = retVal + "DB Disability Benefits"; break;
        case "EP": retVal = retVal + "EP Exclusive Provider Organization"; break;
        case "FF": retVal = retVal + "FF Family or Friends"; break;
        case "GP": retVal = retVal + "GP Group Policy"; break;
        case "HM": retVal = retVal + "HM Health Maintenance Organization (HMO)"; break;
        case "HN": retVal = retVal + "HN Health Maintenance Organization (HMO) - Medicare Risk"; break;
        case "HS": retVal = retVal + "HS Special Low Income Medicare Beneficiary"; break;
        case "IN": retVal = retVal + "IN Indemnity"; break;
        case "IP": retVal = retVal + "IP Individual Policy"; break;
        case "LC": retVal = retVal + "LC Long Term Care"; break;
        case "LD": retVal = retVal + "LD Long Term Policy"; break;
        case "LI": retVal = retVal + "LI Life Insurance"; break;
        case "LT": retVal = retVal + "LT Litigation"; break;
        case "MA": retVal = retVal + "MA Medicare Part A"; break;
        case "MB": retVal = retVal + "MB Medicare Part B"; break;
        case "MC": retVal = retVal + "MC Medicaid"; break;
        case "MH": retVal = retVal + "MH Medigap Part A"; break;
        case "MI": retVal = retVal + "MI Medigap Part B"; break;
        case "MP": retVal = retVal + "MP Medicare Primary"; break;
        case "OT": retVal = retVal + "OT Other"; break;
        case "PE": retVal = retVal + "PE Property Insurance - Personal"; break;
        case "PL": retVal = retVal + "PL Personal"; break;
        case "PP": retVal = retVal + "PP Personal Payment (Cash - No Insurance)"; break;
        case "PR": retVal = retVal + "PR Preferred Provider Organization (PPO)"; break;
        case "PS": retVal = retVal + "PS Point of Service (POS)"; break;
        case "QM": retVal = retVal + "QM Qualified Medicare Beneficiary"; break;
        case "RP": retVal = retVal + "RP Property Insurance - Real"; break;
        case "SP": retVal = retVal + "SP Supplemental Policy"; break;
        case "TF": retVal = retVal + "TF Tax Equity Fiscal Responsibility Act (TEFRA)"; break;
        case "WC": retVal = retVal + "WC Workers Compensation"; break;
        case "WU": retVal = retVal + "WU Wrap Up Policy"; break ;
        default: break ;
      }
  }
  return retVal ; 
}
]]>
  </msxsl:script>

</xsl:stylesheet>