﻿var app = angular.module('app', ['lodash', 'ngSanitize']);
app.controller("PersiviaCarePlanCtrl",
    ['$scope',
    function ($scope) {

        $scope.activeList = ["Active", "Pending", "Completed"]; //interventions

        $scope.appointmentStatuses = ["Scheduled", "Confirmed", "No show", "Done"]; //appointment

        $scope.goalStatuses = ["Active", "Behind", "Completed"]; //goals

        $scope.diagnosisStatuses = ["Active", "Inactive", "Resolved"]; //statuses / allergy

        $scope.medicationStatuses = ["Active", "Completed"]; //medications

        $scope.appointmentTypes = ["Phone", "Office visit", "Follow up", "Procedure"];
        $scope.appointmentReoccurrences = ["Never", "Daily", "Monthly"];

        $scope.goalUnits = ["kg", "lb", "mmHg", "%", "/min", "/day", "/week", "mg/dL", "C", "F", "in", "cm"];

        $scope.carePlan = setCarePlan();

        $scope.patientName = getPatientName();

        function setCarePlan() {
            var careplan = getCarePlan();
            var temp = careplan.status;
            temp = temp.toLowerCase();
            careplan.status = capitalizeFirstLetter(temp);

            var i = 0;
            for (i = 0; i < careplan.diagnoses.length; i++) {
                var stat = careplan.diagnoses[i].diagnosis.status;
                if (!stat) {
                    careplan.diagnoses[i].diagnosis.status = $scope.diagnosisStatuses[0];
                }
            }

            if (careplan.allergies) {
                for (i = 0; i < careplan.allergies.length; i++) {
                    if (careplan.allergies[i].allergy.type != null) {
                        if (!careplan.allergies[i].allergy.type.display) {
                            careplan.allergies[i].allergy.type.display = "1";
                        }
                    }
                    if (careplan.allergies[i].allergy.code != null) {
                        if (!careplan.allergies[i].allergy.code.display) {
                            careplan.allergies[i].allergy.code.display = "1";
                        }
                    } else {
                        careplan.allergies[i].allergy.code = { "display": "1" };
                    }
                }
            }
            if (careplan.careTeam) {
                for (i = 0; i < careplan.careTeam.length; i++) {
                    if (careplan.careTeam[i].careTeamMember.startDate) {
                        careplan.careTeam[i].careTeamMember.startDate = new Date(careplan.careTeam[i].careTeamMember.startDate);
                    }
                    if (careplan.careTeam[i].careTeamMember.endDate) {
                        careplan.careTeam[i].careTeamMember.endDate = new Date(careplan.careTeam[i].careTeamMember.endDate);
                    }
                }
            }
            if (careplan.goals) {
                for (i = 0; i < careplan.goals.length; i++) {
                    if (careplan.goals[i].goal.status) {
                        careplan.goals[i].goal.status = capitalizeFirstLetter(careplan.goals[i].goal.status);
                    } else {
                        careplan.goals[i].goal.status = "Active";
                    }
                }
            }
            if (careplan.interventions) {
                for (i = 0; i < careplan.interventions.length; i++) {
                    if (careplan.interventions[i].intervention.status) {
                        careplan.interventions[i].intervention.status = capitalizeFirstLetter(careplan.interventions[i].intervention.status);
                    } else {
                        careplan.interventions[i].intervention.status = "Active";
                    }

                }
            }


            return careplan;
        }

        window.getUpdatedCarePlan = function getUpgetUpdatedCarePlan() {
            updateCarePlan();
        };

        $scope.addGoal = function addGoal() {
            var goal = { "goal": { "code": { "display": "" }, "creationDate": new Date().toISOString(), "goalMeasure": { "unit": "lb" }, "priority": "low", "status": "Active", "comment": "" } };
            if ($scope.carePlan.goals == null) {
                $scope.carePlan.goals = [];
            }
            $scope.carePlan.goals.push(goal);
        };

        $scope.deleteGoal = function deleteGoal(index) {
            $scope.carePlan.goals.splice(index, 1);
        }

        $scope.addIntervention = function addIntervention() {
            var intervention = { "intervention": { "code": { "display": "" }, "status": "Active", "createdDate": new Date().toISOString() } };
            if ($scope.carePlan.interventions == null) {
                $scope.carePlan.interventions = [];
            }
            $scope.carePlan.interventions.push(intervention);
        }

        $scope.deleteIntervention = function deleteIntervention(index) {
            $scope.carePlan.interventions.splice(index, 1);
        }

        $scope.addAppointment = function addAppoitment() {
            var appointment = {
                "appointment": {
                    "participants": [{
                        "name": { "lastName": "1", "firstName": "1" },
                        "dateTime": new Date().toISOString()
                    }], "startDateTime": new Date().toISOString(),
                    "endDateTime": new Date().toISOString(),
                    "type": "Phone",
                    "status": "Scheduled",
                    "reoccurrence": "Never"
                }
            };
            if ($scope.carePlan.appointments == null) {
                $scope.carePlan.appointments = [];
            }
            $scope.carePlan.appointments.push(appointment);
        }

        $scope.deleteAppointment = function deleteAppointment(index) {
            $scope.carePlan.appointments.splice(index, 1);
        }

        $scope.addQuestionAnswer = function addQuestionAnswer() {
            var assessment = { "question": { "code": { "display": "" } }, "answer": { "code": { "display": "" } } };
            if ($scope.carePlan.assessments == null) {
                $scope.carePlan.assessments = { "questionAnswers": [] };
            }
            if ($scope.carePlan.assessments.questionAnswers == null) {
                $scope.carePlan.assessments.questionAnswers = [];
            }
            $scope.carePlan.assessments.questionAnswers.push(assessment);
        }

        $scope.deleteQuestionAnswer = function deleteQuestionAnswer(index) {
            $scope.carePlan.assessments.questionAnswers.splice(index, 1);
        }

        $scope.addCareMember = function addCareMember() {
            var careMember = { "name": "", "role": "", "phone": "", "startDate": "", "endDate": "" };
            if ($scope.carePlan.careTeam == null) {
                $scope.carePlan.careTeam = [];
            }
            $scope.carePlan.careTeam.push(careMember);
        };

        $scope.deleteCareMember = function deleteCareMember(index) {
            $scope.carePlan.careTeam.splice(index, 1);
        };

        $scope.statuses = ["Approved", "Draft", "Rejected"];

        function capitalizeFirstLetter(string) {
            return string.charAt(0).toUpperCase() + string.slice(1);
        }

        function getPatientName() {
            return window.PersiviaCarePlanService.getPatientName();
        }

        function getCarePlan() {
            return JSON.parse(window.PersiviaCarePlanService.getCarePlan());
        }

        function updateCarePlan() {
            window.PersiviaCarePlanService.setCarePlan(JSON.stringify($scope.carePlan));
        }

        $scope.formatDate = function formatDate(myDate) {
            if (myDate === "") {
                return "";
            }
            var date = new Date(myDate);
            return date.toLocaleDateString("en-US");
        };

    }]);