var app = angular.module('app', ['lodash', 'ngSanitize']);
app.filter('unsafe', function ($sce) {
    return $sce.trustAsHtml;
});
app.directive('tooltip', function () {
    return {
        restrict: 'A',
        link: function (scope, element, attrs) {
            $(element).hover(function () {
                // on mouseenter
                $(element).tooltip('show');
            }, function () {
                // on mouseleave
                $(element).tooltip('hide');
            });
        }
    };
});
app.controller("CommonWellCtrl",
    ['$scope', '$q', '_', '$sce', '$timeout',
    function ($scope, $q, _, $sce, $timeout) {

        $scope.needsLink = true;
        $scope.hasLink = false;
        $scope.loading = true;
        $scope.lolaLoading = false;

        $scope.unableToCreatePerson = false;

        $scope.consented = false;

        $scope.saving = false;

        $scope.viewDocument = "";
        $scope.docLoading = false;

        $scope.$watch('needsLink', function () {
            $scope.unableToCreatePerson = false;
        });

        $scope.currentPatient = null;
        $scope.returnedPersons = null;
        $scope.returnedDocuments = null;
        $scope.options = null;
        $scope.documentOptions = null;
        $scope.connectedPatients = null;

        $scope.showPatientData = false;

        var patientExists = false;

        window.apply = function apply() {
            $scope.loading = false;
            $scope.$apply();
        };

        $scope.updateDocument = function updateDocument(doc) {
            window.CommonWellService.updateDocuments(JSON.stringify(doc));
        };

        function upgradeNetworkLink(patient) {
            window.CommonWellService.upgradeNetworkLink(JSON.stringify(patient));
        }

        function downgradeNetworkLink(patient) {
            window.CommonWellService.downgradeNetworkLink(JSON.stringify(patient));
        }

        $scope.setConsent = function(consent) {
            window.CommonWellService.updatePatientConsent(consent);
        };

        function getPerson() {
            return JSON.parse(window.CommonWellService.getPerson());
        }

        function downgradePromise() {
            $scope.lolaLoading = true;
            var deferred = $q.defer();
            var downgraded = window.CommonWellService.downgrade();
            deferred.resolve(downgraded);
            return deferred.promise;
        }

        $scope.downgrade = function downgrade() {
            var promise = downgradePromise();
            promise.then(function () {
                $scope.returnedPersons = getPerson();
                $scope.lolaLoading = false;
            });
        };

        function upgradePromise() {
            $scope.lolaLoading = true;
            var deferred = $q.defer();
            var upgraded = window.CommonWellService.upgrade();
            deferred.resolve(upgraded);
            return deferred.promise;
        }

        $scope.getStrongIdTypes = function (identifierList) {
            if (!identifierList) {
                return "";
            }
            var idArray = [];
            var i = 0;
            for (i = 0; i < identifierList.length; i++) {
                var temp = window.CommonWellService.getStrongIdType(identifierList[i].assigner);
                if (temp !== "") {
                    idArray.push(temp);
                }
            }

            if (idArray.length === 1) {
                return idArray[0];
            }
            else if (idArray.length > 1) {
                var idListTypes = idArray[0];
                for (i = 1; i < idArray.length; i++) {
                    idListTypes += ", \n" + idArray[i];
                }
            }
            return "";
        }

        $scope.getStrongIdType = function(oid) {
            var s = window.CommonWellService.getStrongIdType(oid);
            return s;
        };

        $scope.upgrade = function upgrade() {
            var promise = upgradePromise();
            promise.then(function () {
                $scope.returnedPersons = getPerson();
                $scope.lolaLoading = false;
            });
        };

        $scope.sayIfBlank = function sayIfBlank(string) {
            return string ? string : "No Name Given";
        };

        //start unlink
        $scope.unlink = function unlink(person) {
            if (patientExists) {
                $scope.loading = true;
                window.CommonWellService.startUnlink(JSON.stringify(person));
                $scope.hasLink = false;
            }
        };
        //end unlink

        //start link to new person
        $scope.newPerson = function newPerson() {
            $scope.loading = true;
            window.CommonWellService.startNewPerson();
        };

        window.newPersonFailed = function newPersonFailed(failedToCreate) {
            $scope.unableToCreatePerson = failedToCreate;
        };
        //end link to new person

        $scope.viewDocuments = function viewDocuments() {
            $scope.needsLink = false;
        };

        //start Link Person
        $scope.link = function link(person) {
            if (patientExists) {
                $scope.loading = true;
                window.CommonWellService.startLink(JSON.stringify(person));
            }
        };
        //end Link Person

        //start view Document
        var currentDoc;

        $scope.view = function view(doc) {
            currentDoc = doc;
            $scope.docLoading = true;
            currentDoc.loading = true;
            window.CommonWellService.loadDocumentView(JSON.stringify(doc));
        };
        
        window.setDocumentView = function setDocumentView() {
            setDocView();
        };

        function setDocView() {
            $scope.viewDocument = window.CommonWellService.getDocView();
        }

        window.finshedLoadingDoc = function finshedLoadingDoc() {
            currentDoc.loading = false;
            $scope.docLoading = false;
        };
        //end view document

        $scope.goBack = function goBack() {
            $scope.needsLink = true;
        };

        $scope.togglePatientDataShow = function togglePatientDataShow() {
            $scope.showPatientData = !$scope.showPatientData;
        };

        $scope.toggleShowPersonDetails = function toggleShowPersonDetails(person) {
            person.showDetails = !person.showDetails;
        };

        //Network Link management
        $scope.upgradeNetworkLink = function(patient) {
            patient.loading = true;
            upgradeNetworkLink(patient);
        };

        $scope.downgradeNetworkLink = function (patient) {
            patient.loading = true;
            downgradeNetworkLink(patient);
        };

        window.setDocuments = function setDocuments(documents) {
            $scope.returnedDocuments = documents;
        };

        window.setConnectedPatients = function setConnectedPatients(patients) {
            $scope.connectedPatients = patients;
        };
        //End Network Link Management

        $scope.options = JSON.parse(window.CommonWellService.getStatusActions());

        $scope.sortType = -1; // set the default sort type
        $scope.sortReverse = true;  // set the default sort order
        //$scope.searchFish = '';     // set the default search/filter term

        $scope.sort = function sort(field) {
            $scope.sortType = field;

            $scope.returnedDocuments = _.sortBy($scope.returnedDocuments, function (item) {
                if (field === 0) {
                    return $scope.sayIfBlank(item.content.description);
                }
                else if (field === 1) {
                    return $scope.formatDate(item.content.created);
                }
                else if (field === 2) {
                    for (var i = 0; i < item.content.contained.length; i++)
                    {
                        if ((typeof item.content.contained[i].name) === "string" && item.content.contained[i].resourceType === "Organization") {
                            return item.content.contained[i].name;
                        }
                    }
                    return ""; //"Test Clinic";
                }
                else if (field === 3) {
                    return item.Type;
                }
                return $scope.formatDocType(item.content.mimeType);
            });

            $scope.sortReverse = !$scope.sortReverse;
            if ($scope.sortReverse) {
                $scope.returnedDocuments = $scope.returnedDocuments.reverse();
            }
        };

        $scope.getDocumentOrganization = function getDocumentOrganization(contained) {
            for (var i = 0; i < contained.length; i++) {
                if ((typeof contained[i].name) === "string" && contained[i].resourceType === "Organization") {
                    return contained[i].name;
                }
            }
            return "";
        };

        function populateDocumentOptions() {
            $scope.documentOptions = {
                "None": $scope.options[0],
                "Ignore": $scope.options[1],
                "Approve": $scope.options[2],
                "SendForApporval": $scope.options[3]
            };
        }

        //on load
        $(document).ready(function () {
            $scope.loading = true;
            populateDocumentOptions();
            pageLoad();
        });

        window.setInitialDocuments = function setInitialDocuments(documents) {
            $scope.returnedDocuments = documents;
            for (var i = 0; i < $scope.returnedDocuments.length; i++) {
                $scope.returnedDocuments[i].loading = false;
                if ($scope.returnedDocuments[i].Action === $scope.documentOptions.None || $scope.returnedDocuments[i].Action === $scope.documentOptions.Ignore) {
                    $scope.returnedDocuments[i].disabled = false;
                } else {
                    $scope.returnedDocuments[i].disabled = true;
                }
            }
        };

        window.goToDocuments = function goToDocuments() {
            $scope.hasLink = true;
            $scope.needsLink = false;
        };

        window.consented = function consented(consent) {
            $scope.loading = true;
            $scope.$apply();
            $scope.consented = (consent === "true");
            if (consent !== "true") {
                $scope.loading = false;
            }
        };

        window.setPatient = function setPatient(patient) {
            patientExists = true;
            $scope.currentPatient = patient;
        };

        window.setPersons = function setPersons(persons) {
            $scope.returnedPersons = persons;
        };

        function pageLoad() {
            window.CommonWellService.loadPage();
        }

        window.endPageLoad = function endPageLoad() {
            _.assign($scope.returnedPersons, function (obj) {
                $scope.docLoading = false;
                obj.loading = false;
            });

            $scope.loading = false;
        };

        //end page load

        $scope.getFullName = function getFullName(name) {
            return name.given[0] + " " + name.family[0];
        };

        $scope.formatDate = function formatDate(myDate) {
            var date = new Date(myDate);
            return date.toLocaleDateString("en-US");
        };

        $scope.formatAddress = function formatAddress(address) {
            var addressString = address.line[0];
            addressString += ", " + address.city;
            addressString += ", " + address.state;
            addressString += " " + address.zip;
            return addressString;
        };

        $scope.formatDocType = function formatDocType(type) {
            if (type === 'text/xml') {
                return 'CCD';
            }
            return type;
        };

        $scope.getAge = function getAge(date) {
            var today = new Date();
            var birthDate = new Date(date);
            var age = today.getFullYear() - birthDate.getFullYear();
            var m = today.getMonth() - birthDate.getMonth();
            if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
                age--;
            }
            return age;
        };

        $scope.getNones = function() {
            var count = 0;
            if (!$scope.returnedDocuments) {
                return 0;
            }
            for (var i = 0; i < $scope.returnedDocuments.length; i++) {
                if ($scope.returnedDocuments[i].Action === $scope.documentOptions.None) {
                    count++;
                }
            }
            return count;
        };
        $scope.getOthers = function() {
            var count = 0;
            if (!$scope.returnedDocuments) {
                return 0;
            }
            for (var i = 0; i < $scope.returnedDocuments.length; i++) {
                if ($scope.returnedDocuments[i].Action !== $scope.documentOptions.None) {
                    count++;
                }
            }
            return count;
        };
    }]);