var giIntervalHeight = 17;
var	oSchedule = new schedule(giIntervalHeight, iMedica.Schedule.Display24HoursView, iMedica.Schedule.DefaultColorScheme);

var gbOverAnchor = false; // used to prevent the onclick event of the TD from executing if an image was clicked

function fnInit()
{
	iMedica.Schedule.Init(myBody);
}

function MoveCalendarDate(iDays)
{
	iMedica.Schedule.MoveCalendarDT(iDays);
}

function SetCalendarAttribute(str)
{
	var strArr = str.split(';');
	oSchedule.setCalendarAttribute(parseInt(strArr[0], 10), parseInt(strArr[1], 10), iMedica.Schedule.DisplayInterval);
}

function SetSingleCalendar(str)
{
	var strArr = str.split(';');
	iMedica.Schedule.DisplayInterval = oSchedule.setSingleCalendar(strArr[0], parseInt(strArr[1], 10), parseInt(strArr[2], 10), parseInt(strArr[3], 10));
}

var iRequestRetries = 0;
function LoadXmlDayObject(str)
{
	if (str.indexOf("error;") == 0) // if there was an error, try the request again.
	{
		if (iRequestRetries < 3)
		{
			iRequestRetries++;
			iMedica.Schedule.MoveCalendarDT(0);
		}
		else
		{
			scheduleShell.outerHTML = "<table id='scheduleShell' class='std'><tr><td><b>Server Error: </b>" + str.substring(7) + "</td></tr></table>";
			iRequestRetries = 0;
		}
		return;
	}

	iRequestRetries = 0;
	var strArr = str.split(';');
	var sCalendarUid = strArr[0];
	var sDate = strArr[1];
	var sXmlDay = strArr[2];
	document.all['xmlDay' + sXmlDay].loadXML(iMedica.Schedule.GetAppointments(sCalendarUid, sDate));
    oSchedule.setCalendarDay(sCalendarUid, sDate);
	oSchedule.drawDay(document.all['xmlDay' + sXmlDay].documentElement, sXmlDay);	
	iMedica.Schedule.IsMoreAppts = oSchedule.bMoreAppts;
}

function overbookAppt(iHour, iMinute)
{
	var sCalendarUid = iMedica.Schedule.CalendarUid;
	var dApptDateTime = new Date(iMedica.Schedule.CalendarDate);
	dApptDateTime.setHours(iHour);
	dApptDateTime.setMinutes(iMinute);
	iMedica.Appointment.AddAppointmentJSScheduler(sCalendarUid, getXMLFormattedDateTime(dApptDateTime), "");	
}


function addAppt(iDay, iTimeSlot, sApptTypeUid, sOldApptUid, sApptSlotStartTime)
{
    if (gbOverAnchor)
        return;
    var xmlDay = document.all['xmlDay' + iDay].documentElement;
    var sCalendarUid = xmlDay.getAttribute("calendarUid");
    var dApptDateTime = new Date(xmlDay.getAttribute("date"));

    //get the slot start time hour	
    var iHour; // = iTimeSlot * iMedica.Schedule.DisplayInterval / 60;
    var iMinute; // = iTimeSlot * iMedica.Schedule.DisplayInterval % 60;

    iMedica.DrawSchedule.DebugOutput("**********addAppt()*********************************");
    iMedica.DrawSchedule.DebugOutput("**********SLOT START TIME IS =" + sApptSlotStartTime + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********Appt Date =" + dApptDateTime + "*********************************");
        
    iHour = iTimeSlot * iMedica.Schedule.DisplayInterval / 60;
        
    //(Bug 42553 & 44889) there is sApptSlotStartTime provided which is the actual time inside of the templated slot. The templated slot will appear in a cell on the scheduler but its actual time could differ from the cell it occupies.
    //For example, the templated slot is set for a 15 minute interval set to start at 1:02 - 1:1:17 PM but occurpies the 1:00 PM slot on the scheduler (bug 42553) which means the appt time needs to start at 1:02 PM.
    //get the iMinute from the sApptSlotStartTime
    if (sApptSlotStartTime != null)
    {
        var colonIdx = sApptSlotStartTime.indexOf(":");
        var apptDateNumChars = sApptSlotStartTime.length;
        var charsAfterColon = apptDateNumChars - colonIdx - 1;            
        iMinute = sApptSlotStartTime.substring(colonIdx + 1, charsAfterColon);
    }
    else
        iMinute = iTimeSlot * iMedica.Schedule.DisplayInterval % 60;

    if (!iMedica.Schedule.Display24HoursView)
    	iHour += oSchedule.iStartHr;
    dApptDateTime.setHours(Math.floor(iHour));
	
    if (iMedica.Schedule.DisplayInterval==60)
        iMinute = iMedica.Schedule.CalendarStartTime%60;

    if (iMedica.AppointmentType.FindAppointmentType(sApptTypeUid))
    {
        var iApptInterval = iMedica.AppointmentType.Duration;            
        if (sApptSlotStartTime == null)
            dApptDateTime.setMinutes(iMinute + Math.floor(window.event.offsetY / ((iApptInterval / iMedica.Schedule.DisplayInterval) * giIntervalHeight)) * iApptInterval); //iMinute computed by position of the slot cell.
        else
            dApptDateTime.setMinutes(iMinute); //iMinute already computed from sApptSlotStarttTime
    }
    else
    	dApptDateTime.setMinutes(iMinute);	

    iMedica.DrawSchedule.DebugOutput("**********iTimeSlot = " + iTimeSlot + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********iMinute = " + iMinute + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********computed iHour = " + iHour + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********computed iMinute = " + iMinute + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********apptdateTime = " + dApptDateTime + "*********************************");

	if (sApptTypeUid == null)
		sApptTypeUid = "";		

	iMedica.Appointment.AddAppointmentJSScheduler(sCalendarUid, getXMLFormattedDateTime(dApptDateTime), sApptTypeUid);
}

function removeSlot(iDay, iTimeSlot, sApptTypeUid, sStartTime, sEndTime)
{
    debugger;

	if (gbOverAnchor)
		return;
	var xmlDay = document.all['xmlDay' + iDay].documentElement;
	var sCalendarUid = xmlDay.getAttribute("calendarUid");
	var dApptDateTime = new Date(xmlDay.getAttribute("date"));
	var iHour; // = iTimeSlot * iMedica.Schedule.DisplayInterval / 60;
	var iMinute; // = iTimeSlot * iMedica.Schedule.DisplayInterval % 60;

	if (sApptTypeUid == null)
		sApptTypeUid = "";

    //Bug 42553 - a slot may not actually start based on the cell start time. If it is a templated slot, it may have a start/stop time that is within the boundary of the actual painted slot 
    //(e.g. slot time falls on 1:00 AM but the actual templated time is internally set at 10:05 AM). So, it is safest to use the sStartTime value instead of the iTimeSlot to determine the start time to be removed.
    //create the correct hr & mins for a starttime date which is stored in dApptDateTime.
	var colonIdx = sStartTime.indexOf(":");
	var apptDateNumChars = sStartTime.length;
	var charsAfterColon = apptDateNumChars - colonIdx - 1;
	var isPM = sStartTime.indexOf("PM");
	var iHour = sStartTime.substring(0, colonIdx);
	var iMinute = sStartTime.substring(colonIdx + 1, charsAfterColon);
    //set hrs & minutes and be cognizant of AM vs PM
	if (isPM > -1) {
	    iMedica.DrawSchedule.DebugOutput("**********PM*****************");
	    dApptDateTime.setHours(iHour + 12);
	}
	else {
	    iMedica.DrawSchedule.DebugOutput("**********AM******************");
	    dApptDateTime.setHours(iHour);
	}
	dApptDateTime.setMinutes(iMinute);

	iMedica.DrawSchedule.DebugOutput("**********removeSlot()*********************************");
	iMedica.DrawSchedule.DebugOutput("**********iStartHr = " + oSchedule.iStartHr + "*********************************");
	iMedica.DrawSchedule.DebugOutput("**********start time = " + sStartTime + "*********************************");
	iMedica.DrawSchedule.DebugOutput("**********computed iHour = " + iHour + "*********************************");
	iMedica.DrawSchedule.DebugOutput("**********computed iMinute = " + iMinute + "*********************************");
	iMedica.DrawSchedule.DebugOutput("**********computed datetime = " + dApptDateTime + "*********************************");
		
	iMedica.Appointment.RemoveBlockedSlot(sCalendarUid, getXMLFormattedDateTime(dApptDateTime), sApptTypeUid, sStartTime, sEndTime);
}


function removeAllocation(iDay, iTimeSlot, sApptTypeUid, sStartTime, sEndTime)
{
    debugger;

    if (gbOverAnchor)
        return;
    var xmlDay = document.all['xmlDay' + iDay].documentElement;
    var sCalendarUid = xmlDay.getAttribute("calendarUid");
    var dApptDateTime = new Date(xmlDay.getAttribute("date"));
    if (sApptTypeUid == null)
        sApptTypeUid = "";

    //Bug 42553 - a slot may not actually start based on the cell start time. If it is a templated slot, it may have a start/stop time that is within the boundary of the actual painted slot 
    //(e.g. slot time falls on 1:00 AM but the actual templated time is internally set at 10:05 AM). So, it is safest to use the sStartTime value instead of the iTimeSlot to determine the start time to be removed.
    //create the correct hr & mins for a starttime date which is stored in dApptDateTime.
    var colonIdx = sStartTime.indexOf(":");
    var apptDateNumChars = sStartTime.length;
    var charsAfterColon = apptDateNumChars - colonIdx - 1;
    var isPM = sStartTime.indexOf("PM");
    var iHour = parseInt(sStartTime.substring(0, colonIdx));
    var iMinute = sStartTime.substring(colonIdx + 1, charsAfterColon);    

    iMedica.DrawSchedule.DebugOutput("**********iHour = " + iHour + "*********************************");


    //set hrs & minutes and be cognizant of AM vs PM
    if (isPM > -1)
    {
        iMedica.DrawSchedule.DebugOutput("**********PM*****************");

        //Bug 46349 - if a templated slot occurs at 12 pm leave it alone else add 12 hours to it to compute appt starttime
        if( iHour != 12)
            dApptDateTime.setHours(iHour + 12);
        else
            dApptDateTime.setHours(iHour);
    }
    else
    {
        iMedica.DrawSchedule.DebugOutput("**********AM******************");

        //Bug 46349 - if a templated slot occurs at 12 am, substract 12 hrs from it else leave it alone to compute appt starttime
        if (iHour == 12)
            dApptDateTime.setHours(iHour - 12);
        else
           dApptDateTime.setHours(iHour);
    }
    iMedica.DrawSchedule.DebugOutput("**********dApptdateTime.Hours = " + dApptDateTime.getHours() + "*****************");
    dApptDateTime.setMinutes(iMinute);

    iMedica.DrawSchedule.DebugOutput("**********removeAllocation()*********************************");
    iMedica.DrawSchedule.DebugOutput("**********iStartHr = " + oSchedule.iStartHr + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********start time = " + sStartTime + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********end time = " + sEndTime + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********computed iHour = " + iHour + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********computed iMinute = " + iMinute + "*********************************");
    iMedica.DrawSchedule.DebugOutput("**********computed datetime = " + dApptDateTime + "*********************************");

    iMedica.Appointment.RemoveBlockedSlot(sCalendarUid, getXMLFormattedDateTime(dApptDateTime), sApptTypeUid, sStartTime, sEndTime);
}


function updateAppt(iDay, sApptUid)
{
	if (gbOverAnchor)
		return;
		
	iMedica.DrawSchedule.DebugOutput("**********updateAppt*********************************");

	iMedica.Appointment.EditAppointment(sApptUid);
}

function apptDateTime(iDay, iTimeSlot) {
    var xmlDay = document.all['xmlDay' + iDay].documentElement;
    var dApptDateTime = new Date(iMedica.Schedule.CalendarDate);
    var iHour = iTimeSlot * iMedica.Schedule.DisplayInterval / 60;
    var iMinute = iTimeSlot * iMedica.DrawSchedule.DisplayInterval % 60;
    if (!iMedica.Schedule.Display24HoursView)
        iHour += oSchedule.iStartHr;
    dApptDateTime
    dApptDateTime.setHours(Math.floor(iHour));
    dApptDateTime.setMinutes(iMinute);
    return getXMLFormattedDateTime(dApptDateTime);
}

