
function sleep(ms) {
    var start = new Date().getTime();
    for (var i = 0; i < 1e7; i++) {
        if ((new Date().getTime() - start) > ms) {
            break;
        }
    }
}
function allowDrop(ev) {
    (ev.preventDefault) ? ev.preventDefault() : ev.returnValue = false;
}

function preventDrop(ev) {
    (ev.preventDefault) ? ev.preventDefault() : ev.returnValue = true;
}

function dragOver(ev, args) {
    if (args == 'clipboard') {
        allowDrop(ev);
        sessionStorage.setItem("toArgs", args);
        ev.dataTransfer.dropEffect = "copy";
    }
    else if (args.indexOf("clipboard") >= 0) {
        preventDrop(ev);
        ev.dataTransfer.dropEffect = "none";
    }
    else if (args.indexOf("calendar") >= 0) {
        allowDrop(ev);
        sessionStorage.setItem("toArgs", args);
        ev.dataTransfer.dropEffect = "copy";
    }
}

function dragStart(ev) {
    ev.dataTransfer.setData("text", ev.srcElement.id);
}

function drop(ev) {
    var fromArgs = ev.dataTransfer.getData("text");
    var toArgs = sessionStorage.getItem("toArgs");

    if (toArgs === '' ||
        toArgs === null ||
        toArgs === undefined ||
        fromArgs === '' ||
        fromArgs === null ||
        fromArgs === undefined)
        return;

    allowDrop(ev);
    var button = sessionStorage.getItem("button");

    if (fromArgs.indexOf("cbmain") >= 0) {
        var list = fromArgs.split(";");
        button = list[1];
    }
    if (toArgs.indexOf("clipboard") >= 0 || toArgs.indexOf("calendar") >= 0) {
        try {
            iMedica.AppointmentClipboard.DropAppointment(fromArgs, toArgs, button);
        }
        catch (e) {}
    }
}

function saveButton() {
    var button = event.button;
    var ieVersion = version();

    //ie >8  - 0 left 1 wheel 2 right
    //ie <=8 - 1 left 2 right 4 wheel
    if (ieVersion <= 8) {
        if (button == 1)
            button = 0
        else if (button == 4)
            button = 1
    }
    sessionStorage.setItem("button", button);
}

function version() {
    var version;
    if (document.all && document.querySelector && !document.addEventListener) {
        version = 7;
    }
    else if (document.all && !document.querySelector) {
        version = 8;
    }
    else if (!document.all) {
        version = 11;
    }
}

