<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
 xmlns:user="urn:schemas-imedica.com:prm">
	<xsl:template match="ROOT/Person">
	<xsl:element name="DIV">
	  <xsl:attribute name="ID">printDiv</xsl:attribute>
	  <xsl:attribute name="name">Contacts</xsl:attribute>
		<table border="0" cellpadding="2" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
		  <col width="15%"/>    <!-- Relation -->
      <col width="20%"/>    <!-- Name -->
      <col width="30%"/>    <!-- Address -->
      <col width="15%"/>    <!-- Phone -->
      <col width="70"/>     <!-- Medical Decisions -->
      <col width="70"/>     <!-- Power of Attorney -->
      <col width="80"/>     <!-- HIPAA Release -->
      <col width="80"/>     <!-- Emergency Contact -->
      <col width="80"/>     <!-- Join Telehealth Call -->
      <col width="20%"/>    <!-- Notes -->
      <col width="20"/>     <!-- Delete Button -->
      <col width="0%"/>     <!-- -->
			<TR class="insideGreyHeader">
				<TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">Relation</SPAN></TD>
				<TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">Name</SPAN></TD>
				<TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">Address</SPAN></TD>
				<TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">Phone</SPAN></TD>
        <TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">Medical<br/>Decisions</SPAN></TD>
        <TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">Power of Attorney</SPAN></TD>
        <TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">HIPAA<br/>Release</SPAN></TD>
        <TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">Emergency<br/>Contact</SPAN></TD>
        <TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">Allow Join<br/>Telehealth Call</SPAN></TD>
        <TD align="left" nowrap="true" valign="center"><SPAN class="smallHeader">Notes</SPAN></TD>
        <TD></TD>
        <TD></TD>
			</TR>
		</table>
		<table border="0" cellpadding="2" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
		  <col width="15%"/>
      <col width="20%"/>
      <col width="30%"/>
      <col width="15%"/>
      <col width="70"/>
      <col width="70"/>
      <col width="80"/>
      <col width="80"/>
      <col width="80"/>
      <col width="20%"/>
      <col width="0%"/>
			<xsl:choose>
			<xsl:when test="PersonContact/@ContactPersonUid[.!='']">
			<xsl:for-each select="PersonContact">
			<TR class="picklist" ID="MyRow" NAME="MyRow" style="cursor:hand">
				<xsl:if test="position() mod 2 = 0">
					<xsl:attribute name="bgcolor">whitesmoke</xsl:attribute>
				</xsl:if>
				<xsl:if test="position() mod 2 = 1">
					<xsl:attribute name="bgcolor">white</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="onClick">if(iMedica.Patient.EditContact('<xsl:value-of select="@PersonContactUid"/>')) init1();</xsl:attribute>
				<xsl:attribute name="onMouseOver">hiliteRow("picklist","#cccccc");</xsl:attribute>
				<xsl:attribute name="onMouseOut">setTrBgColor(this);</xsl:attribute>

        <!-- Relation -->
				<TD align="left" valign="top">
          <span class="small"><xsl:value-of select="@Relationship"/>&#xa0;</span>
          <!--
					<span class="FindControl small" BusinessObject="ListRelationshipFactory" fcReadOnly="true"><xsl:attribute name="fcForeignKeyUid"><xsl:value-of select="@ContactRelationshipUid"/></xsl:attribute>&#xa0;</span>
          -->
				</TD>

        <!-- Name (Prefix) LastName, FirstName (MiddleName) (, Suffix) -->
				<TD align="left" valign="top">
					<SPAN class="small">
					<xsl:if test="Person/@Suffix">
						<xsl:value-of select="Person/@Prefix"/>&#xa0;
					</xsl:if>
					<xsl:value-of select="Person/@LastName"/>, <xsl:value-of select="Person/@FirstName"/>
					<xsl:if test="Person/@MiddleName">
						&#xa0;<xsl:value-of select="Person/@MiddleName"/>
					</xsl:if>
					<xsl:if test="Person/@Suffix">
						, <xsl:value-of select="Person/@Suffix"/>
					</xsl:if>
					</SPAN>
				</TD>

        <!-- Address -->
				<TD align="left" valign="top">
					<SPAN class="small">
            <xsl:choose>
              <xsl:when test="Person/Address1/Address/Address1[.!='']">
                <xsl:value-of select="Person/Address1/Address/Address1"/>
                <xsl:if test="Person/Address1/Address/Address2">
                  <br/><xsl:value-of select="Person/Address1/Address/Address2"/>
                </xsl:if>
                <xsl:if test="user:FormatCityStateZip(string(Person/Address1/Address/City),string(Person/Address1/Address/State),string(Person/Address1/Address/Zip))">
                  <br/><xsl:value-of select="user:FormatCityStateZip(string(Person/Address1/Address/City),string(Person/Address1/Address/State),string(Person/Address1/Address/Zip))"/>
                </xsl:if>
              </xsl:when>
                      
              <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="Person/Address1/Address/Address2[.!='']">
                    <xsl:value-of select="Person/Address1/Address/Address2"/>
                    <xsl:if test="user:FormatCityStateZip(string(Person/Address1/Address/City),string(Person/Address1/Address/State),string(Person/Address1/Address/Zip))">
                      <br/><xsl:value-of select="user:FormatCityStateZip(string(Person/Address1/Address/City),string(Person/Address1/Address/State),string(Person/Address1/Address/Zip))"/>
                    </xsl:if>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:if test="user:FormatCityStateZip(string(Person/Address1/Address/City),string(Person/Address1/Address/State),string(Person/Address1/Address/Zip))">
                      <xsl:value-of select="user:FormatCityStateZip(string(Person/Address1/Address/City),string(Person/Address1/Address/State),string(Person/Address1/Address/Zip))"/>
                    </xsl:if>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
					</SPAN>
				</TD>

        <!-- Phone -->
				<TD align="left" valign="top">
					<SPAN class="small">
						<xsl:choose>
							<xsl:when test="Person/@PersonUid[.!='']">
								<xsl:value-of select="Person/Phone1/Phone/PhoneNumber"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="//Person/Phone1/Phone/PhoneNumber"/>
							</xsl:otherwise>
						</xsl:choose>
					</SPAN>
				</TD>

        <!-- Medical Decisions -->
        <TD align="left" valign="top">
          <SPAN class="small">
            <xsl:value-of select="user:CanMakeMedicalDecisions(string(@AuthorizedToMakeMedicalDecisions))"/>
          </SPAN>
        </TD>

        <!-- POA -->
        <TD align="left" valign="top">
          <SPAN class="small">
            <xsl:value-of select="user:PowerOfAttorney(string(@PowerOfAttorney))"/>
          </SPAN>
        </TD>
        
        <!-- HIPAA -->
        <TD align="left" valign="top">
          <SPAN class="small">
            <xsl:attribute name="title">
              <xsl:value-of select="HIPAARelease" />
            </xsl:attribute>
            <xsl:value-of select="string(@AllowHIPAARelease)"/>
          </SPAN>
        </TD>
        
        <!-- Emergency Contact -->
        <TD align="left" valign="top">
          <SPAN class="small">
            <xsl:value-of select="user:IsEmergencyContact(string(@EmergencyContact))"/>
          </SPAN>
        </TD>
        
        <!-- JoinTelehealthCall -->
        <TD align="left" valign="top">
          <SPAN class="small">
            <xsl:value-of select="user:CanJoinTelehealthCall(string(@JoinTelehealthCall))"/>
          </SPAN>
        </TD>
        
        <!-- Notes -->
        <TD align="left" valign="top">
          <SPAN class="small">
            <xsl:value-of select="user:FormatNotes(string(@Notes))"/>
          </SPAN>
        </TD>

        <!-- Delete Button -->
        <TD width="20" valign="top">
          <button type="button" title="Click here to delete this contact" style="height 10px">
            <xsl:attribute name="onClick">
              if (iMedica.Patient.DeleteContact('<xsl:value-of select="@PersonContactUid"/>')) init1();
            </xsl:attribute>
            <b>X</b>
          </button>
        </TD>

        <!-- Hidden Uid attributes -->
        <TD width="0" valign="top">
					<xsl:element name="INPUT">
						<xsl:attribute name="TYPE">hidden</xsl:attribute>
						<xsl:attribute name="ID">contactUUID<xsl:value-of select="UUID"/></xsl:attribute>
						<xsl:attribute name="NAME">contactUUID<xsl:value-of select="UUID"/></xsl:attribute>
						<xsl:attribute name="VALUE"><xsl:value-of select="UUID"/></xsl:attribute>
					</xsl:element>
				</TD>
			</TR>
			</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
			<TR ID="MyRow" NAME="MyRow" CLASS="picklist" bgcolor="white">
				<TD width="598" colspan="9" align="center" nowrap="true" valign="top">
					<SPAN class="hint">(No contacts listed for this patient.)</SPAN>
				</TD>
			</TR>
			</xsl:otherwise>
			</xsl:choose>
		</table><br/>
		</xsl:element><!--printDIV-->
		<table width="98%" align="center" border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed;">
			<TR>
				<TD width="90%" valign="top">
					<SPAN class="hint">Click on a Contact to view/edit the contact or click '<B>Add</B>' to add a new contact.</SPAN>
				</TD>
				<TD width="10%" align="right">
					<input id="btnPrintDemographics" type="button" class="blueBtn" value="Add" >
						<xsl:attribute name="onClick">if(iMedica.Patient.AddContact('<xsl:value-of select="//@PersonUid"/>')) init1();</xsl:attribute>
					</input>
					<!--input type="button" class="blueBtn" disabled="true" value="Add" onclick="add_Contact();event.cancelBubble=true;" /-->
				</TD>
			</TR>
		</table>
		<!--table width="98%" align="center" border="0" cellpadding="0" cellspacing="0">
			<tr align="center">
				<td width="100%">
					<input type="button" class="blueBtn" disabled="true" onClick="formatForPrinting('contactsPrint.htm','Contacts','685px','375px');" value="Print Contacts" />
					<input type="button" class="blueBtn" disabled="true" onClick="formatForPrinting('identificationPrint.htm','Identification','685px','406px');" value="Print Identification" />
				</td>
			</tr>
		</table-->
	</xsl:template>

<msxsl:script language="Jscript" implements-prefix="user">
	<![CDATA[

  function FormatNotes(sNotes)
  {
    return sNotes;
  }

  function FormatCityStateZip(sCity, sState, sZip)
  {
    var addr = "";

    if ( (sCity.length > 0) || (sState.length > 0) || (sZip.length > 0) )
    {
      if (sCity.length > 0)
      {
        addr = sCity;
      }

      if (sState.length > 0)
      {
        if (addr.length > 0)
        {
          addr = addr + ", ";
        }
        addr = addr + sState;
      }

      if (sZip.length > 0)
      {
        addr = addr + "  ";
      }
      addr = addr + sZip;
    }

    return addr;
  }

  function IsEmergencyContact(sFlag)
  {
    if (sFlag.toUpperCase() == "TRUE")
      return "Yes";
    
    if (sFlag.toUpperCase() == "1")
      return "Yes";
    
    if (sFlag.toUpperCase() == "YES")
      return "Yes";
    
    return "No";    
  }

  function CanMakeMedicalDecisions(sFlag)
  {
    if (sFlag.toUpperCase() == "TRUE")
      return "Yes";
    
    if (sFlag.toUpperCase() == "1")
      return "Yes";
    
    if (sFlag.toUpperCase() == "YES")
      return "Yes";
    
    return "No"; 
  }
  function PowerOfAttorney(sFlag)
  {
    if (sFlag.toUpperCase() == "TRUE")
      return "Yes";
    
    if (sFlag.toUpperCase() == "1")
      return "Yes";
    
    if (sFlag.toUpperCase() == "YES")
      return "Yes";
    
    return "No"; 
  }
  function CanJoinTelehealthCall(sFlag)
  {
    if (sFlag.toUpperCase() == "TRUE")
      return "Yes";
    
    if (sFlag.toUpperCase() == "1")
      return "Yes";
    
    if (sFlag.toUpperCase() == "YES")
      return "Yes";
    
    return "No"; 
  }

 ]]>
</msxsl:script>

</xsl:stylesheet>