function fnInit()
{
	fnGetWaitingList();
}

var iRequestRetries = 0;
function fnGetWaitingList()
{
	spanWaitingListCount.innerText = "Loading...";
	var str = iMedica.WaitingList.OverviewXMLString;
	if (str.indexOf("<error>") == 0 && iRequestRetries < 3) // if there was an error, try the request again.
	{
		iRequestRetries++;
		fnGetWaitingList();
		return;
	}
	
	iRequestRetries = 0;
	xmlWaitingList.loadXML(str);
}

function fnDisplayWaitingList()
{
	divWaitingLists.innerHTML = xmlWaitingList.transformNode(xslWaitingList);
	if (xmlWaitingList.xml.indexOf("<error>") == 0)
	{
		spanWaitingListCount.innerText = "Server Error";
		divWaitingLists.style.visibility = "visible";
	}
	else
	{
		spanWaitingListCount.innerText = xmlWaitingList.documentElement.childNodes.length;
		if (xmlWaitingList.documentElement.childNodes.length == 0)
			divWaitingLists.style.visibility = "hidden";
		else
		{
			divWaitingLists.style.visibility = "visible";
			divWaitingLists.focus();
			
			// This block of code will automatically scroll the waitinglists
			// closes to the current time into view.  It tries to place that waitinglist
			// as close to the middle of the screen as possible.
			var iTime = getCurrentTimeInMins();
			var waitingLists = divWaitingLists.children;
			var iWaitingListToScrollTo = waitingLists.length - 1;
			for (var i = 0; i < waitingLists.length; i++)
			{
			    var iWaitingListTime = getWaitingListTime(waitingLists[i].id);			    
			    if ((iMedica.WaitingListSlider.IsSortDirectionAscending && iWaitingListTime > iTime) // compare using this condition when the waitinglists are sorted ascending
			        || (!iMedica.WaitingListSlider.IsSortDirectionAscending && iWaitingListTime < iTime)) // otherwise sort using this condition
                {
                    if (i == waitingLists.length - 2)
                        break;
                        
                    if (i > 1)
                    {
                        iWaitingListToScrollTo = i - 2;
                        break;
                    }
                    else
                    	return;
                }
			}
			// I had to call the scrollIntoView method in a different thread otherwise 
			// it did not work correctly for no apparent reason.
			setTimeout("scrollToWaitingList(" + iWaitingListToScrollTo.toString() + ")", 100);
		}
	}
}

function showContextMenu(srwlwldUid, sTableID)
{
	gbContextMenuClick = true;
	iMedica.WaitingList.ShowContextMenu(srwlwldUid, event.clientX, event.clientY);
	gbContextMenuClick = false;
	DisableAlphaFilter(sTableID);
}

function scrollToWaitingList(iWaitingListToScrollTo)
{
	divWaitingLists.children[iWaitingListToScrollTo].scrollIntoView(true);
}

function getCurrentTimeInMins()
{
    var oDate = new Date();
    var hour = parseInt(oDate.getHours(), 10);
	var mins = parseInt(oDate.getMinutes(), 10);
	return hour * 60 + mins;
}

function getWaitingListTime(sID)
{
    var sArr = sID.split("b");
    return parseInt(sArr[1], 10);
}
