function fnInit()
{
	fnGetAppts();
}

var iRequestRetries = 0;
function fnGetAppts()
{
	spanVisitCount.innerText = "Loading...";
	var str = iMedica.Appointment.OverviewAppointmentXMLString;
	if (str.indexOf("<error>") == 0 && iRequestRetries < 3) // if there was an error, try the request again.
	{
		iRequestRetries++;
		fnGetAppts();
		return;
	}
	
	iRequestRetries = 0;
    spanVisitCount.innerText = "0";
	xmlAppts.loadXML(str);
}

function fnDisplayAppointments()
{
	divAppts.innerHTML = xmlAppts.transformNode(xslAppts);
	spanDay.innerText = iMedica.Calendar.DayOfWeek;
	if (xmlAppts.xml.indexOf("<error>") == 0)
	{
		spanVisitCount.innerText = "Server Error";
		divAppts.style.visibility = "visible";
	}
	else
	{
        spanVisitCount.innerText = xmlAppts.documentElement.getAttribute("patientAppointmentCount");
		if (xmlAppts.documentElement.childNodes.length == 0)
			divAppts.style.visibility = "hidden";
		else
		{
			divAppts.style.visibility = "visible";
			divAppts.focus();
			
			if (iMedica.Appointment.LastScrollPosition != -1) {
			    oDiv.scrollTop = iMedica.Appointment.LastScrollPosition;
			    return;
			}
			// This block of code will automatically scroll the appointments
			// closes to the current time into view.  It tries to place that appointment
			// as close to the middle of the screen as possible.
			var iTime = getCurrentTimeInMins();
			var appts = divAppts.children;
			var iApptToScrollTo = appts.length - 1;
			for (var i = 0; i < appts.length; i++)
			{
			    var iApptTime = getApptTime(appts[i].id);			    
			    if ((iMedica.Calendar.IsSortDirectionAscending && iApptTime > iTime) // compare using this condition when the appointments are sorted ascending
			        || (!iMedica.Calendar.IsSortDirectionAscending && iApptTime < iTime)) // otherwise sort using this condition
                {
                    if (i == appts.length - 2)
                        break;
                    if (i > 1)
                    {
                        iApptToScrollTo = i - 2;
                        break;
                    }
                    else
                    	return;
                }
			}
			// I had to call the scrollIntoView method in a different thread otherwise 
			// it did not work correctly for no apparent reason.
			setTimeout("scrollToAppt(" + iApptToScrollTo.toString() + ")", 100);
		}
	}
}

function showContextMenu(sAppointmentUid, sTableID)
{
	gbContextMenuClick = true;
	iMedica.Appointment.ShowContextMenu(sAppointmentUid, event.clientX, event.clientY);
	gbContextMenuClick = false;
	DisableAlphaFilter(sTableID);
}

function scrollToAppt(iApptToScrollTo)
{
	divAppts.children[iApptToScrollTo].scrollIntoView(true);
}

function getCurrentTimeInMins()
{
    var oDate = new Date();
    var hour = parseInt(oDate.getHours(), 10);
	var mins = parseInt(oDate.getMinutes(), 10);
	return hour * 60 + mins;
}

function getApptTime(sID)
{
    var sArr = sID.split("b");
    return parseInt(sArr[1], 10);
}

function saveScroll(div)
{
    iMedica.Appointment.LastScrollPosition = div.scrollTop;
}