function fnInit()
{
	fnGetAppointmentClipboard();
}

var iRequestRetries = 0;
function fnGetAppointmentClipboard()
{
	spanAppointmentClipboardCount.innerText = "Loading...";
	var str = iMedica.AppointmentClipboard.OverviewXMLString;
	if (str.indexOf("<error>") == 0 && iRequestRetries < 3) // if there was an error, try the request again.
	{
		iRequestRetries++;
		fnGetAppointmentClipboard();
		return;
	}
	
	iRequestRetries = 0;
	xmlAppointmentClipboard.loadXML(str);
}

function fnDisplayAppointmentClipboard()
{
	divAppointmentClipboards.innerHTML = xmlAppointmentClipboard.transformNode(xslAppointmentClipboard);
	if (xmlAppointmentClipboard.xml.indexOf("<error>") == 0)
	{
		spanAppointmentClipboardCount.innerText = "Server Error";
		divAppointmentClipboards.style.visibility = "visible";
	}
	else
	{
		spanAppointmentClipboardCount.innerText = xmlAppointmentClipboard.documentElement.childNodes.length;
		if (xmlAppointmentClipboard.documentElement.childNodes.length == 0)
			divAppointmentClipboards.style.visibility = "hidden";
		else
		{
			divAppointmentClipboards.style.visibility = "visible";
			divAppointmentClipboards.focus();
			
			// This block of code will automatically scroll the AppointmentClipboards
			// closes to the current time into view.  It tries to place that AppointmentClipboard
		    // as close to the middle of the screen as possible.
			var iTime = getCurrentTimeInMins();
			var AppointmentClipboards = divAppointmentClipboards.children;
			var iAppointmentClipboardToScrollTo = AppointmentClipboards.length - 1;
			for (var i = 0; i < AppointmentClipboards.length; i++)
			{
			    var iAppointmentClipboardTime = getAppointmentClipboardTime(AppointmentClipboards[i].id);

			    if ((iMedica.AppointmentClipboardSlider.IsSortDirectionAscending && iAppointmentClipboardTime > iTime) // compare using this condition when the AppointmentClipboards are sorted ascending
			        || (!iMedica.AppointmentClipboardSlider.IsSortDirectionAscending && iAppointmentClipboardTime < iTime)) // otherwise sort using this condition
                {
                    if (i == AppointmentClipboards.length - 2)
                        break;
                        
                    if (i > 1)
                    {
                        iAppointmentClipboardToScrollTo = i - 2;
                        break;
                    }
                    else
                    	return;
                }
            }
			// I had to call the scrollIntoView method in a different thread otherwise 
			// it did not work correctly for no apparent reason.
			setTimeout("scrollToAppointmentClipboard(" + iAppointmentClipboardToScrollTo.toString() + ")", 100);
		}
	}
}

function showContextMenu(srwlwldUid, sTableID)
{
	gbContextMenuClick = true;
	iMedica.AppointmentClipboard.ShowContextMenu(srwlwldUid, event.clientX, event.clientY);
	gbContextMenuClick = false;
	DisableAlphaFilter(sTableID);
}

function scrollToAppointmentClipboard(iAppointmentClipboardToScrollTo)
{
    //divAppointmentClipboards.children[iAppointmentClipboardToScrollTo].scrollIntoView(true);
}

function getCurrentTimeInMins()
{
    var oDate = new Date();
    var hour = parseInt(oDate.getHours(), 10);
	var mins = parseInt(oDate.getMinutes(), 10);
	return hour * 60 + mins;
}

function getAppointmentClipboardTime(sID)
{
    var sArr = sID.split("b");
    return parseInt(sArr[1], 10);
}
