angular.module('apEasyScroller', []);

angular.module('apEasyScroller').directive('apEasyScroller',
    ['$window', '_', 'ScrollerService', 'debounce',
        function ($window, _, ScrollerService, debounce) {
            'use strict';

            var keyboardOpen=false;
            var focused=false;
            var keyboardHeight=0;

            var easyScrollerListener = function (eScroll, elm) {
                var viewHeight = $window.innerHeight;
                var eleHeight = elm.scrollHeight;
                elm.style.height = '0px';
                if (eleHeight - viewHeight > 0 || (eleHeight-viewHeight+keyboardHeight > 0 && keyboardOpen)) {
                    if(keyboardOpen){
                        elm.style.height = (elm.scrollHeight - viewHeight + keyboardHeight) + 'px';
                    }
                    else {
                        elm.style.height = (elm.scrollHeight - viewHeight) + 'px';
                    }
                }
                eScroll.reflow();
                //change to correct height for backdrop
                elm.style.height = elm.scrollHeight + 'px';
            };

            return {
                restrict: 'EA',
                link: function ($scope, elm, attr) {
                    elm = elm[0];
                    var eScroll = new EasyScroller(elm, {
                        scrollingY: true,
                        scrollingX: false
                    });

                    var updateFn = function () {
                        easyScrollerListener(eScroll, elm);
                    };

                    ScrollerService.addScroller(attr.id, eScroll, updateFn);

                    var scrollFn = function () {
                        if(keyboardOpen && focused) {
                            var fixedElement = document.getElementsByClassName('fixed-element')[0];
                            fixedElement.style.top = (parseInt(fixedElement.style.top.substring(0, fixedElement.style.top.length - 2)) - fixedElement.getBoundingClientRect().top) + 'px';
                        }
                    };

                    var scrollFnSetup = function () {
                        if(keyboardOpen && focused) {
                            //window.alert('hi');
                            var fixedElement = document.getElementsByClassName('fixed-element')[0];
                            fixedElement.style.top = -1 * fixedElement.getBoundingClientRect().top + 'px';
                        }
                    };

                    //watches for subtree changes on the DOM and will update the height whenever that happens
                    if(MutationObserver){
                        var mutationObserver = new MutationObserver(debounce(50, updateFn));
                        mutationObserver.observe(eScroll.container, {attributes: true, subtree: true, childList: true, characterData: true});
                    }

                    $window.addEventListener('scroll', scrollFn, false);
                    $window.addEventListener('touchmove', scrollFn, false);
                    $window.addEventListener('touchstart', updateFn, false);
                    $window.addEventListener('mousedown', updateFn, false);
                    $window.addEventListener('mousewheel', updateFn, false);

                    $scope.$on('$destroy', function(){
                        if(mutationObserver) {
                            mutationObserver.disconnect();
                        }
                        $window.removeEventListener('scroll', scrollFn, false);
                        $window.removeEventListener('touchmove', scrollFn, false);
                        $window.removeEventListener('touchstart', updateFn, false);
                        $window.removeEventListener('mousedown', updateFn, false);
                        $window.removeEventListener('mousewheel', updateFn, false);
                        ScrollerService.removeScroller(attr.id);
                        dereg();
                    });

                    var dereg = $scope.$on('es-page-height-change', function(){
                        eScroll.scrollTo(0, 0, false);
                        elm.style.height='0px';
                    });

                    $scope.$on('keyboard-focus', function (){
                        keyboardOpen=true;
                        focused=true;
                        scrollFnSetup();
                    });

                    $scope.$on('keyboard-opened', function(event, data) {
                        keyboardOpen=true;
                        focused=false;
                        keyboardHeight=data.keyboardHeight;
                        updateFn();
                    });

                    $scope.$on('keyboard-closed', function(){
                        var fixedElement = document.getElementsByClassName('fixed-element')[0];
                        fixedElement.style.top='0px';
                        keyboardOpen=false;
                        focused=false;
                        updateFn();
                    });
                }
            };
        }]);