'use strict';
module.exports = function (grunt) {

    grunt.registerMultiTask('imagestoless', 'Takes images and puts them into less file as classes that use responsive media queries', function () {
        var options = this.options();
        this.files.forEach(function (file) {

            var finalString = '',
                contents = grunt.file.read(file.dest),
                newpath = file.dest.replace(/\.lesstemplate$/i, ''),
                attributes = {};
            grunt.log.writeln('Creating file ' + newpath + ' for directory ' + file.src[0].substring(0, file.src[0].lastIndexOf('/')+1) + ':');

            file.src.forEach(function (fileName) {
                var relativePath = '../' + fileName.substring(4, fileName.length),
                    splitFile = fileName.split('/'),
                    imageName = splitFile[splitFile.length-1],
                    regex = new RegExp('[' + options.nameSizeDelims + options.otherDelims  + ']+'),
                    splitImageName = imageName.split(regex),
                    shortName = imageName.substring(0, imageName.lastIndexOf(options.nameSizeDelims)),
                    width = splitImageName[splitImageName.length-3],
                    height = splitImageName[splitImageName.length-2];

                if(!attributes[shortName]){
                    attributes[shortName] = {
                        Contents: contents.valueOf(),
                        TopHeight: height,
                        Height: height,
                        Width: width,
                        Image1Path: relativePath,
                        Image2Path: relativePath,
                        Image3Path: relativePath,
                        ImageName: shortName
                    };

                }
                else {
                    if(!attributes[shortName].Height || parseInt(height) < parseInt(attributes[shortName].Height)){
                        attributes[shortName].Height = height;
                        attributes[shortName].Width = width;
                        attributes[shortName].Image2Path = attributes[shortName].Image1Path;
                        attributes[shortName].Image1Path = relativePath;
                    }
                    else if(parseInt(height) > parseInt(attributes[shortName].TopHeight)){
                        attributes[shortName].TopHeight = height;
                        if(attributes[shortName].Image1Path === attributes[shortName].Image2Path){
                            attributes[shortName].Image2Path = relativePath;
                            attributes[shortName].Image3Path = relativePath;
                        }
                        else {
                            attributes[shortName].Image3Path = relativePath;
                        }
                    }
                    else {
                        attributes[shortName].Image3Path = attributes[shortName].Image2Path;
                        attributes[shortName].Image2Path = relativePath;
                    }
                }


            });
            for (var prop in attributes) {
                if (attributes.hasOwnProperty(prop)) {
                    var obj = attributes[prop];
                    for (var child in obj) {
                        var regex = new RegExp('<' + child + '>', 'g');
                        obj.Contents = obj.Contents.replace(regex, obj[child]);
                    }
                    finalString += obj.Contents + '\n';
                }
                grunt.log.write('.');
            }
            grunt.log.ok();
            grunt.log.ok('Used ' + Object.keys(attributes).length + ' unique images from ' + file.src.length + ' files');
            grunt.file.write(newpath, finalString);
        });
    });
};


