/*
Cleanup duplicate rows from a table.
This script as written will clear out any duplicate rows from the VisitPE table.
It can be modified to cleanup any table that has duplicate PK Uids by
changing the table name and the PK UID name.  
The order by LMD desc will force it to delete the older rows and keep the newest one.
*/
;WITH DuplicateCTE(PKUid, RowNumber) AS
(
SELECT VisitPEUid, RowNumber = ROW_NUMBER() OVER(PARTITION 	
	BY VisitPEUid ORDER BY LastModifiedDate DESC) FROM VisitPE
)  
select * from DuplicateCTE WHERE RowNumber > 1
-- delete from DuplicateCTE WHERE RowNumber > 1

-- duplicates for [IdxUniqueClaimFormatValue] ON [dbo].[ClaimFormatValue] 
;WITH DuplicateCTE(PKUid, RowNumber) AS
(
SELECT [ClaimFormatValueTypeUid], RowNumber = ROW_NUMBER() OVER(PARTITION 	
	BY [ClaimFormatValueTypeUid] ORDER BY LastModifiedDate DESC) FROM [ClaimFormatValue]
)  
select * from DuplicateCTE WHERE RowNumber > 1
-- delete from DuplicateCTE WHERE RowNumber > 1


/*
       MMW Migration where Charge.ARBatchUid FK not in effect 
       Instead, pull missing batch from Charge's Superbill (should be available so not dealing with it ALSO missing here)
       BMR 20121129 
*/
UPDATE Charge 
SET Charge.ARBatchUid = FIX_C.ARBatchUid
FROM Charge CH
INNER JOIN (SELECT CH.ChargeUid, SB.ARBatchUid
           FROM Charge CH
           INNER JOIN ARContext ARC ON CH.ARContextUid = ARC.ARContextUid
           INNER JOIN Superbill SB ON ARC.SuperbillUid = SB.SuperbillUid
           WHERE CH.ARBatchUid IS NULL) FIX_C ON CH.ChargeUid = FIX_C.ChargeUid;


/*
	AMW Migration from 2009-2011
	No referential integrity and have AccountPeriods with no valid Accounts associated
	This deletes those AccountPeriods so that 
		referential integrity can be reapplied in the migration ...
	BROY 20121227 @ 10:37 AM
	BROY 21121227 @ 11:51 AM Added similar for Appointment
	BROY 21121228 @ 10:05 AM Added similar for AccountInsurance, PersonInsurancePlan, StatementBatchDetail
				And modified form of existing DELETES to be consistant
*/
DELETE AP FROM AccountPeriod AP LEFT JOIN Account AC ON AP.AccountUid = AC.AccountUid
	WHERE NOT AP.AccountUid IS NULL AND AC.AccountUid IS NULL;

DELETE AP FROM Appointment AP LEFT JOIN Account AC ON AP.AccountUid = AC.AccountUid
	WHERE NOT AP.AccountUid IS NULL AND AC.AccountUid IS NULL;
		
ALTER TABLE [CreditGroup] NOCHECK CONSTRAINT ALL;
DISABLE TRIGGER ALL ON Deposit;
DELETE DP FROM Deposit DP
	LEFT JOIN Person PR ON DP.WhoPaidPersonUid = PR.PersonUid
	LEFT JOIN InsuranceCarrier IPPU ON DP.WhoPaidInsuranceCarrierUid = IPPU.CorporationUid
	LEFT JOIN InsuranceCarrier IPCU ON DP.WhoPaidInsuranceCarrierUid = IPCU.CorporationUid
	WHERE (NOT DP.WhoPaidPersonUid IS NULL AND PR.PersonUid IS NULL)
		OR (NOT DP.WhoPaidInsuranceCarrierUid IS NULL AND IPPU.CorporationUid IS NULL)
		OR (NOT DP.WhoPaidInsuranceCarrierUid IS NULL AND IPCU.CorporationUid IS NULL)
		
DELETE AI FROM AccountInsurance AI
	INNER JOIN PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
	LEFT JOIN Person PR ON PIP.PersonUid = PR.PersonUid
	WHERE NOT PIP.PersonUid IS NULL AND  PR.PersonUid IS NULL;

DELETE PIP FROM PersonInsurancePlan PIP 
	LEFT JOIN Person PR ON PIP.PersonUid = PR.PersonUid
	WHERE NOT PIP.PersonUid IS NULL AND PR.PersonUid IS NULL;
	
DELETE SBD FROM StatementBatchDetail SBD
	LEFT JOIN AccountResponsibleParty ARP ON SBD.AccountResponsiblePartyUid = ARP.AccountResponsiblePartyUid
	WHERE NOT SBD.AccountResponsiblePartyUid IS NULL AND ARP.AccountResponsiblePartyUid IS NULL;

-- Lonny added these 2	
DELETE eRR FROM eReportRows eRR LEFT JOIN Person PR ON eRR.insuredUid = PR.PersonUid
	WHERE NOT eRR.insuredUid IS NULL AND PR.PersonUid IS NULL;

DELETE RAG FROM RelAttachmentGroup RAG LEFT JOIN Person PR ON RAG.PersonUid = PR.PersonUid
	WHERE NOT RAG.PersonUid IS NULL AND PR.PersonUid IS NULL;

DELETE RAG FROM RelAttachmentGroup RAG LEFT JOIN AttachmentGroup AG ON RAG.AttachmentGroupUid = AG.AttachmentGroupUid
	WHERE NOT RAG.AttachmentGroupUid IS NULL AND AG.AttachmentGroupUid IS NULL;

DELETE FROM ObservationOrder WHERE PatientUid is null

DELETE RFT FROM RelFindTableMFU RFT LEFT JOIN ListFindTable LFT ON RFT.FindTableUid = LFT.FindTableUid
	WHERE NOT RFT.FindTableUid IS NULL AND LFT.FindTableUid IS NULL;

-- AccountInsurance errors
update AccountInsurance set DisplayOrder = 2
where AccountPeriodUid = '08eced07-0411-4742-ba75-2dbe3bfee880' AND AccountInsuranceUid = '30D33AEE-6C1D-43E2-84A7-8EF35BCD7404'

update AccountInsurance set DisplayOrder = 2
where AccountPeriodUid = 'c323f6fb-c63a-4ebf-a81c-366ffe825722' AND AccountInsuranceUid = 'F1EE8AAE-DBA8-4531-90B5-A09BFB809628'

update AccountInsurance set DisplayOrder = 2
where AccountPeriodUid = '6e4cb89d-9a89-4a45-8030-99d6b420afb9' AND AccountInsuranceUid = '67A09627-8D86-4330-9ED2-8C8D1590E15A'

-- GrowthChart error
update ListGrowthChart set XAxisMax = 5, XAxisMin = 2, YAxisMin = 5 where GrowthChartUid = 'BC7096FE-FE44-44C3-8B4D-BDFCF226E7AE'

/* Used to find any columns that have errors when translated to XML */
-- First, create this Function
IF EXISTS(SELECT * FROM sysobjects WHERE name = 'EscapeXml')
	DROP FUNCTION EscapeXml
GO
CREATE FUNCTION [dbo].[EscapeXml](@xml VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN

	SET @xml = REPLACE(@xml, '&', '&amp;')
	SET @xml = REPLACE(@xml, '>', '&gt;')
	SET @xml = REPLACE(@xml, '<', '&lt;')
	SET @xml = REPLACE(@xml, '"', '&quot;')
	SET @xml = REPLACE(@xml, '''', '&apos;')
	RETURN @xml
END
-- Now run this 
DECLARE cur CURSOR FOR
SELECT  a.AddressUid  FROM  AddressRawUnencrypted a  -- Change the table and table PK Uid here
DECLARE @uid UNIQUEIDENTIFIER
DECLARE @xml XML
OPEN cur

FETCH NEXT FROM cur INTO @uid
WHILE @@FETCH_STATUS = 0
BEGIN
BEGIN TRY
	SELECT @xml = CAST(dbo.EscapeXml(City) AS XML)  -- change the column that is being parsed here
	FROM  AddressRawUnencrypted  
	WHERE  AddressUid = @uid
END TRY
BEGIN cATCH
	PRINT '''' + CONVERT(varchar(40), @uid) + ''','
	SELECT @uid AS Error_PrimaryKey, dbo.EscapeXml(City)   --  and here
	FROM  AddressRawUnencrypted  
	WHERE AddressUid = @uid
	PRINT  ERROR_MESSAGE()
	END CATCH
FETCH NEXT FROM cur INTO @uid
END

CLOSE cur
DEALLOCATE cur

-- VisitROS FK errors.
DELETE VROS FROM VisitRos VROS LEFT JOIN RosSystem RS ON VROS.RosSystemUid = RS.RosSystemUid
      WHERE NOT VROS.RosSystemUid IS NULL AND RS.RosSystemUid IS NULL;

-- Cleanup RelFindTableXXX
DELETE r
FROM   RelFindTableMFU r
WHERE  FindTableUid NOT IN (SELECT FindTableUid FROM ListFindTable)

DELETE r
FROM   RelFindTableMRU r
WHERE  FindTableUid NOT IN (SELECT FindTableUid FROM ListFindTable)

DELETE r
FROM   RelFindTableHide r
WHERE  FindTableUid NOT IN (SELECT FindTableUid FROM ListFindTable)


-- clean up duplicate RelCCSystemSymptom
;WITH DuplicateCTE(PKUid, RowNumber) AS
(
SELECT [RelCCSystemSymptomUid], RowNumber = ROW_NUMBER() OVER(PARTITION               
                BY [CCSystemUid], [CCSymptomUid] ORDER BY LastModifiedDate DESC) FROM RelCCSystemSymptom
)  
-- select * from DuplicateCTE WHERE RowNumber > 1
-- delete from DuplicateCTE WHERE RowNumber > 1

;WITH DuplicateCTE(PKUid, AccountPeriodUid, RowNumber) AS
(
SELECT AccountInsuranceUid, AccountPeriodUid, RowNumber = ROW_NUMBER() OVER(PARTITION 	
	BY AccountPeriodUid, DisplayOrder ORDER BY LastModifiedDate DESC) FROM AccountInsurance
)  -- select * from DuplicateCTE WHERE RowNumber > 1
delete from DuplicateCTE WHERE RowNumber > 1

DELETE T1 FROM PersonInsurancePlan T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN InsurancePlan T2 ON T1.InsurancePlanUid = T2.InsurancePlanUid
	WHERE T1.InsurancePlanUid IS NOT NULL AND T2.InsurancePlanUid IS NULL;

DELETE AI FROM AccountInsurance AI
	LEFT JOIN AccountPeriod AP ON AI.AccountPeriodUid = AP.AccountPeriodUid
	WHERE AI.AccountPeriodUid IS NOT NULL AND AP.AccountPeriodUid IS NULL;

DELETE AI FROM AccountInsurance AI
	LEFT JOIN PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
	WHERE AI.PersonInsurancePlanUid IS NOT NULL AND PIP.PersonInsurancePlanUid IS NULL;

DELETE T1 FROM CaseAuthorization T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN AccountPeriod T2 ON T1.AccountPeriodUid = T2.AccountPeriodUid
	WHERE T1.AccountPeriodUid IS NOT NULL AND T2.AccountPeriodUid IS NULL;

DELETE T1 FROM MessageAA T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN RelAttachmentGroup T2 ON T1.RelAttachmentGroupUid = T2.RelAttachmentGroupUid
	WHERE T1.RelAttachmentGroupUid IS NOT NULL AND T2.RelAttachmentGroupUid IS NULL;

DELETE T1 FROM MessageERxRefillRequest T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN eRxInbound T2 ON T1.eRxInboundUid = T2.eRxInboundUid
	WHERE T1.eRxInboundUid IS NOT NULL AND T2.eRxInboundUid IS NULL;

DELETE T1 FROM MessageRx T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN eRxInbound T2 ON T1.eRxInboundUid = T2.eRxInboundUid
	WHERE T1.eRxInboundUid IS NOT NULL AND T2.eRxInboundUid IS NULL;

DELETE T1 FROM PatientPharmacy T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN Patient T2 ON T1.PatientUid = T2.PersonUid
	WHERE T1.PatientUid IS NOT NULL AND T2.PersonUid IS NULL;

DELETE T1 FROM RelPatientMedication T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN RelVisitMedication T2 ON T1.RelVisitMedicationUid = T2.RelVisitMedicationUid
	WHERE T1.RelVisitMedicationUid IS NOT NULL AND T2.RelVisitMedicationUid IS NULL;

DELETE T1 FROM SuperbillProcedureModifier T1  -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
	LEFT JOIN SuperbillProcedure T2 ON T1.SuperbillProcedureUid = T2.SuperbillProcedureUid
	WHERE T1.SuperbillProcedureUid IS NOT NULL AND T2.SuperbillProcedureUid IS NULL;

-- 19.0 migration added unique index and there were dups
;WITH DuplicateCTE AS
(
SELECT PersonUid, IntegrationPartnerUid, RowNumber = ROW_NUMBER() OVER(PARTITION 	
	BY PersonUid, IntegrationPartnerUid ORDER BY LastModifiedDate DESC) FROM CommunicationPreference
)  
select * from DuplicateCTE WHERE RowNumber > 1
-- delete from DuplicateCTE WHERE RowNumber > 1
