SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllowFinancialBatchOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE function [dbo].[AllowFinancialBatchOverride]
	()
	returns bit as
begin

	declare @ret bit
	declare @var int
	set @var  = cast(substring(context_info(),1,4) as int) -- get current context info value
	-- MergeData (32), ARMigration (16), PatientMerge (8), Replication UP (1) and DOWN (2) TODO: Modify process once 2011 financials stable to deal with UP conflicts (DOWN does not matter)
	-- Bit 3 (4), reserved for replication OVERRIDE - catch anyway below
	if ((@var & 32 = 32) OR (@var & 16 = 16) OR (@var & 8 = 8) OR (@var & 4 = 4) OR (@var & 2 = 2) OR (@var & 1 = 1)) -- set flags to capture bit on or off
		set @ret = 1
	else
		set @ret = 0
		
	return @ret
end

/*
 
DECLARE @testFlag INT
SET @testFlag = ??? -- which bit are we testing?
 
-- init CONTEXT_INFO for testing
DECLARE @contextInfo int
SET @contextInfo  = 128
SET CONTEXT_INFO @contextInfo

 
-- set CONTEXT_INFO (turn on bit)
DECLARE @currentContextInfo int
DECLARE @newContextInfo int
SET @currentContextInfo  = CAST(SUBSTRING(ISNULL(CONTEXT_INFO(),0),1,4) AS INT)
SET @newContextInfo = @currentContextInfo | @testFlag -- turn on bit
SET CONTEXT_INFO @newContextInfo

-- check CONTEXT_INFO
DECLARE @var int
SET @var  = CAST(SUBSTRING(ISNULL(CONTEXT_INFO(),0),1,4) AS INT)
IF (@var & @testFlag = @testFlag)
      SELECT ''SET''
ELSE
      SELECT ''NOT SET''
 
SELECT ''Allow'', dbo.AllowFinancialBatchOverride()

*/


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_Uids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList_Uids] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '';'')  
RETURNS @table TABLE ( Value UNIQUEIDENTIFIER ) AS
	BEGIN     
		DECLARE @position INT,   
				@previous INT     
		
		SET @list = @list + @separator     
		
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (CONVERT(UNIQUEIDENTIFIER, LTRIM(RTRIM(SUBSTRING(@list, @previous, @position - @previous)))))
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
	END     
	RETURN  
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsCacheClient]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[IsCacheClient] ()
	returns bit as
begin

	declare @ret bit
	IF EXISTS ( SELECT 1 FROM ReplicationSettings where Name = ''Replication.IsCacheServer'' and BoolValue = 1 )
	BEGIN
		SET @ret = 1
	END
	ELSE
	BEGIN
		SET @ret = 0
	END

	return @ret

end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsReplicating]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE function [dbo].[IsReplicating]
	()
	returns bit as
begin

	DECLARE @var int
	SET @var  = CAST(SUBSTRING(ISNULL(CONTEXT_INFO(),0),1,4) AS INT)

	IF (@var & 7 > 0) -- up, down, or override state 
		RETURN 1
	ELSE
		RETURN 0 
		
	RETURN 0 -- will never get here ... must have a closing return

end


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SystemGuid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- function returning a Prm system Guid
CREATE FUNCTION [dbo].[SystemGuid] (@SystemId int)
RETURNS uniqueidentifier AS  

BEGIN  

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier

  if (@SystemId < 0) 
	set @SystemId = -1 * @SystemId
  set @Wrk = convert (varchar(200), @SystemId)
  while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

  set @Wrk = ''10101010'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
  set @Wrk = ''{'' + @Wrk + ''}''
  set @NewGUID = @Wrk
  return (@NewGUID)
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Split]
 (	@vcDelimitedString VARCHAR(max),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetChangeTrackingContextFromContextInfo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetChangeTrackingContextFromContextInfo]()
RETURNS VARBINARY(128)
BEGIN

	DECLARE @extractedContextInfo VARBINARY(128);
	DECLARE @extractedContextInfoString VARCHAR(MAX)
	DECLARE @retVal VARBINARY(128);
	
	SELECT @extractedContextInfo = CAST(SUBSTRING(CONTEXT_INFO(),33, 128) AS VARBINARY(128));
	IF (NOT @extractedContextInfo IS NULL AND @extractedContextInfo<>CAST('''' AS VARBINARY(128)))
		SET @retVal = @extractedContextInfo;
		
	RETURN @retVal;
	
END

/*
	DECLARE @contextInfo VARBINARY(128);
	DECLARE @contextInfoString VARCHAR(MAX);
	DECLARE @changeTrackingContextString VARCHAR(MAX);
	DECLARE @bitField INT;

	SELECT @bitField = 128;
	SELECT @changeTrackingContextString = '''';
	--SELECT @changeTrackingContextString = ''BrettBrettBrettBrettBret'';

	SET @contextInfoString = CAST(CAST(@bitField AS BINARY(4)) AS VARCHAR(MAX)) 
		+ CAST(CAST('''' AS BINARY(28)) AS VARCHAR(MAX))
		+ CAST(CAST(@changeTrackingContextString AS BINARY(24)) AS VARCHAR(MAX)); 
	SET @contextInfo = CAST(@contextInfoString AS BINARY(128));

	SET CONTEXT_INFO @contextInfo;
	SELECT CONTEXT_INFO()
	
	SELECT dbo.GetChangeTrackingContextFromContextInfo(), CAST(dbo.GetChangeTrackingContextFromContextInfo() AS VARCHAR(MAX))
*/




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_IsReplicatedDB]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_IsReplicatedDB]
(
)
RETURNS BIT
AS
BEGIN
	DECLARE @Inactive BIT,
			@ReplicatedDB BIT,
			@URL VARCHAR (255)
			
	SELECT @Inactive = 0,
		   @URL = CAST (SERVERPROPERTY (''MachineName'') AS VARCHAR (255))
		
	SELECT TOP 1 @ReplicatedDB =
		CASE WHEN URL = @URL
				OR EXISTS ( 
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.IsCacheServer''
									AND t.CacheMachineUid = t1.GuidValue
									AND t1.BoolValue <> 0
						  )
				OR EXISTS (
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.STSReconfigInfo''
									AND t.CacheMachineUid = t1.GuidValue
						  )
				OR NOT EXISTS (
								SELECT TOP 1 *
								FROM ReplicationFilter
								WHERE CacheMachineUid = t.CacheMachineUid
									AND TableName = ''ListCacheMachine''
							   )
			 THEN CAST (1 AS BIT)
			 ELSE CAST (0 AS BIT)
		END
	FROM ViewListCacheMachine AS t
	WHERE URL = @URL
		AND Inactive = @Inactive

	RETURN COALESCE (@ReplicatedDB, 0)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFPatientConditions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


/********************************************************************************************/
/* UDFCaseVisits																			*/
/* Collates the PatientConditions associated with a patient as a comma delimited string.		*/
/********************************************************************************************/
CREATE FUNCTION [dbo].[UDFPatientConditions]
(
	 @patientUid uniqueidentifier
)
RETURNS varchar(MAX)
AS
begin

  declare @condition varchar(500)	
  declare @conditionBuilder varchar(MAX)
  set @conditionBuilder = ''''

  IF @patientUid IS NOT NULL
  BEGIN

	--Create a cursor on ListPatientCondition
	declare pc_cursor cursor FAST_FORWARD for 
	SELECT Name 
	FROM ListPatientCondition lpc
	INNER JOIN dbo.RelPatientCondition rpc ON rpc.PatientConditionUid = lpc.PatientConditionUid
	WHERE  rpc.PatientUid = @patientUid
	ORDER BY rpc.DisplayOrder asc

    open pc_cursor
    fetch next from pc_cursor INTO @condition

    while (@@fetch_status <> -1)
    begin
      if (@@fetch_status <> -2)
      begin
        if len(@condition) > 0 AND LEN(@conditionBuilder) > 0
        begin
          set @conditionBuilder = @conditionBuilder + '', ''
        end

        set @conditionBuilder = @conditionBuilder + @condition 

       end
     fetch next from pc_cursor INTO @condition
    end
    close pc_cursor
    deallocate pc_cursor
  END
  return @conditionBuilder	
end




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPatientStatusNamesByPatient]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPatientStatusNamesByPatient](@patientUid as uniqueidentifier) RETURNS VARCHAR(500) AS
BEGIN
	IF @patientUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(500)
	select @retVal = stuff( (SELECT DISTINCT '', '' + convert(VARCHAR(50),LPS.Name)
								FROM RelPatientStatus RPS WITH (NOLOCK)
									INNER JOIN ListPatientStatus LPS WITH (NOLOCK) ON RPS.PatientStatusUid = LPS.PatientStatusUid
								WHERE rps.PatientUid = @patientUid
								FOR XML PATH('''')), 1, 1, '''' )
	return @retVal
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountRPBalanceInCollections]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAccountRPBalanceInCollections]  
(  
 @AccountResponsiblePartyUid UNIQUEIDENTIFIER  
)  
RETURNS  
	MONEY  
AS  
BEGIN  
	DECLARE @AccountBalance money  
	SELECT @AccountBalance = Sum(VSA.LiabilityBalance - VSA.AssignedLiabilityBalance)  
		FROM AR_ViewSuperbillAggregate VSA
			INNER JOIN Superbill SB ON VSA.SuperbillUid =SB.SuperbillUid AND (NOT SB.DateEnteredAutomatedCollections IS NULL 
				AND SB.DateLeftAutomatedCollections IS NULL)
			INNER JOIN Account A ON SB.AccountUid = A.AccountUid 
		WHERE 
			A.AccountResponsiblePartyUid = @AccountResponsiblePartyUid 
		
	RETURN ISNULL(@AccountBalance, 0)  
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCollectionStatusLevelForAccountResponsibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetCollectionStatusLevelForAccountResponsibleParty]
(
	@AccountResponsiblePartyUid uniqueidentifier,
	@CollectionStatusUid				uniqueidentifier
)
RETURNS uniqueidentifier
AS
BEGIN
DECLARE @CurrentBalance money
SET @CurrentBalance = dbo.GetAccountRPBalanceInCollections(@AccountResponsiblePartyUid)
DECLARE @CollectionStatusLevelUid uniqueidentifier
SELECT
	@CollectionStatusLevelUid = CollectionStatusLevelUid
FROM
	CollectionStatusLevel
WHERE
		CollectionStatusUid = @CollectionStatusUid AND Inactive=0
AND	(
			@CurrentBalance >= BalanceFrom
			AND
			(
				(
						GreaterThan = 0
					AND
						@CurrentBalance <= BalanceTo
				)
				OR
				(
						GreaterThan = 1
				)
			)
		)
RETURN @CollectionStatusLevelUid
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyOriginalCollectionsBalance]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetAccountResponsiblePartyOriginalCollectionsBalance]
(
	@AccountResponsiblePartyUid uniqueidentifier
)
RETURNS
	money
AS
BEGIN
DECLARE	@AccountBalance money
SELECT
	@AccountBalance = Sum(EnteringCollectionsPatientBalance)
FROM
	SuperbillsInAutomatedCollections sic
INNER JOIN
	Superbill s ON
		sic.SuperbillUid = s.SuperbillUid
WHERE
	sic.AccountResponsiblePartyUid = @AccountResponsiblePartyUid

RETURN isnull(@AccountBalance, 0)
END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertUTCToLocalTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertUTCToLocalTime](@utcTime [datetime])
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertUTCToLocalTime]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsWeekDay]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	Returns "1" when the current date is "Monday" thur
--				"Friday" and "0" when "Sunday" or "Saturday".
--
--				For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				function "IsWeekDay(DateTime oDate)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[IsWeekDay](
		@currentDate DATE
		)

RETURNS bit
AS
begin
	declare @isWeekDay bit = 1

	declare @DayOfWeek int = DATEPART(WEEKDAY, @currentDate) -- 1 = Sunday; 2 = Monday; 3 = Tuesday...Saturday = 7

	if ((@DayOfWeek = 1) or (@DayOfWeek = 7))
	begin
		set @isWeekDay = 0
	end

	return @isWeekDay
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNDayofMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";	
--				functions "GetNDayofMonth(int iN, DateTime currentDate, bool isWeekDay)"
--				and "GetNDayofMonth(int iN, DateTime currentDate, DayOfWeek dow)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetNDayofMonth](
		@iN int,
		@currentDate DATE,
		@isWeekDay bit,
		@dayOfWeek int
		)

RETURNS
	DateTime
AS
begin
	
	if (@isWeekDay is not null)
	begin
		set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
								CONVERT(varchar(20), DATEPART(year, @currentDate))
		
		while (((@isWeekDay = 1) and (dbo.IsWeekDay(@currentDate) = 0))
				OR
			  ((@isWeekDay = 0) and (dbo.IsWeekDay(@currentDate) = 1)))
		begin
			set @currentDate = DATEADD(day, 1, @currentDate)
		end -- of while

		while (@iN > 0)
		begin
			set @currentDate = DATEADD(day, 1, @currentDate)
			if (((@isWeekDay = 1) and (dbo.IsWeekDay(@currentDate) = 1))
				 OR
			   ((@isWeekDay = 0) and (dbo.IsWeekDay(@currentDate) = 0)))
			begin
				set @iN = @iN - 1
			end
		end -- of while
	end -- of if (@isWeekDay is not null)
	else if (@dayOfWeek is not null)
	begin
		declare @oldCurrentDate DateTime = @currentDate
		set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
								CONVERT(varchar(20), DATEPART(year, @currentDate))

		while (DATEPART(WEEKDAY, @currentDate) <> @dayOfWeek)
		begin
			set @currentDate = DATEADD(day, 1, @currentDate)
		end

		while (@iN > 0)
		begin
			set @currentDate = DATEADD(day, 7, @currentDate)
			set @iN = @iN - 1
		end -- of while
	end -- if (@dayOfWeek is not null)

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastDayofMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";	
--				functions "GetLastDayofMonth(DateTime currentDate, bool isWeekDay)"
--				and "GetLastDayofMonth(DateTime currentDate, DayOfWeek dow)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetLastDayofMonth](
		@currentDate DATE,
		@isWeekDay bit,
		@dayOfWeek int
		)

RETURNS DATE
AS
begin
	set @currentDate = DATEADD (month, 1, @currentDate)
	set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
							CONVERT(varchar(20), DATEPART(year, @currentDate))
	set @currentDate = DATEADD(day, -1, @currentDate)

	if (@isWeekDay is not null)
	begin
		while (((@isWeekDay = 1) and (dbo.IsWeekDay(@currentDate) = 0))
				OR
			   ((@isWeekDay = 0) and (dbo.IsWeekDay(@currentDate) = 1)))
		begin
			set @currentDate = DATEADD(day, -1, @currentDate)
		end -- of while
	end -- of if (@isWeekDay is not null)
	else if (@dayOfWeek is not null)
	begin
		while ((DATEPART(WEEKDAY, @currentDate) <> @dayOfWeek))
		begin
			set @currentDate = DATEADD(day, -1, @currentDate)
		end
	end

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDateForMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";	
--				functions "GetDateForMonth(int iPrefix, DateTime currentDate, bool isWeekDay)"
--				and "GetDateForMonth(int iPrefix, DateTime currentDate, DayOfWeek dow)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetDateForMonth](
		@iPrefix int,
		@currentDate DATE,
		@isWeekDay bit,
		@dayOfWeek int,
		@StartDate DATE
		)

RETURNS DATE
AS
begin
if (@iPrefix = 0) -- last
	begin
		set @currentDate = dbo.GetLastDayofMonth(@currentDate, @isWeekDay, @dayOfWeek)
		if (@currentDate < @StartDate)
		begin
			set @currentDate = dbo.GetLastDayofMonth(DATEADD(month, 1, @currentDate), @isWeekDay, @dayOfWeek)
		end
		else begin
			set @currentDate = dbo.GetNDayofMonth(@iPrefix - 1, @currentDate, @isWeekDay, @isWeekDay)
		end
	end

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNextDateForMonthOption2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				method "GetNextDateForMonthOption2(int iPrefix, Guid gUnit, DateTime currentDate)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetNextDateForMonthOption2](
		@iPrefix int,
		@gUnit uniqueidentifier,
		@currentDate DATE,
		@StartDate DATE
		)

RETURNS DATE
AS
begin
	if (@gUnit = CONVERT(uniqueidentifier, ''F1E71F1B-8025-4875-9DFC-141BCEAF3444'')) -- day
	begin
		if (@iPrefix = 0) -- last day of the month
		begin
			set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
									CONVERT(varchar(20), DATEPART(year, @currentDate))
			set @currentDate = DATEADD(month, 1, @currentDate)
			set @currentDate = DATEADD(day, -1, @currentDate)
		end
		else begin
			if (@iPrefix < DATEPART(day, @currentDate))
			begin
				set @currentDate = DATEADD(month, 1, @currentDate)
			end
			set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
					CONVERT(varchar(20), DATEPART(year, @currentDate))
			
			set @currentDate = DATEADD(day, @iPrefix - 1, @currentDate)
		end
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''B3121D9E-9769-4831-8F4E-0678E3F49C13'')) -- weekday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, 1, null, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''EED139E3-4D95-45B4-95BE-50F6B619D43B'')) -- weekday day
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, 0, null, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''F0917C45-D974-46D5-B914-57B8E602362B'')) -- Sunday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 1, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''B4658BCB-78BF-46DD-A1F8-52021AC160E1'')) -- Monday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 2, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''F5B6EC8F-FFA2-4489-A916-9916BE193ECC'')) -- Tuesday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 3, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''DA34F712-ED05-455F-97C8-0C6B8DC49C4F'')) -- Wednesday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 4, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''F15B441F-054F-4A74-BB14-4441BA6DE158'')) -- Thursday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 5, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''CF007109-4E97-435A-A37C-F0DAFBFD7DBE'')) -- Friday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 6, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''3C47E0D9-0A04-4420-99B7-496E319900C5'')) -- Saturday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 7, @StartDate);
	end
	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckMonthlyAssignmentStateOption2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description: For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				function "CheckMonthlyAssignmentStateOption2
--					(XmlDocument xmlDoc, DateTime oDate, out int offset)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[CheckMonthlyAssignmentStateOption2](
		@SearchDate DATE,
		@NumDays int,
		@iMonth int,
		@gPrefix uniqueidentifier,
		@gUnit uniqueidentifier,
		@StartDate Date,
		@EndDate Date
		)

RETURNS
@Result Table
	(
		Found bit default (0),
		DaysOffset int default (-1)
	)
begin
	declare @daysOffset int = -1
	declare @found bit = 0
	declare @i int
	declare @iPrefix int
	declare @nextDate DATE
	declare @currentMonthDate DATE
	declare @currentDate DATE = @StartDate
	
	set @currentDate = @StartDate

	set @iPrefix = 1 -- first - CalendarTemplateAssignmentDayPrefix
	if (@gPrefix = CONVERT(uniqueidentifier, ''F933AF8A-D703-499A-B940-827A0D2224A2''))
	begin
		set @iPrefix = 2 -- second - CalendarTemplateAssignmentDayPrefix
	end
	else if (@gPrefix = CONVERT(uniqueidentifier, ''23E2E9F2-8496-475B-85F8-9F70768E68D4''))
	begin
		set @iPrefix = 3 -- third - CalendarTemplateAssignmentDayPrefix
	end
	else if (@gPrefix = CONVERT(uniqueidentifier, ''423085E1-8C4E-4542-A95F-C205B16D524C''))
	begin
		set @iPrefix = 4 -- fourth - CalendarTemplateAssignmentDayPrefix
	end 
	else if (@gPrefix = CONVERT(uniqueidentifier, ''57D0D8DA-8EC6-40DD-BFBC-FCE228ABF107''))
	begin
		set @iPrefix = 5 -- fifth - CalendarTemplateAssignmentDayPrefix
	end 
	else if (@gPrefix = CONVERT(uniqueidentifier, ''8036F9D3-E596-4830-88BB-A247500805AA''))
	begin
		set @iPrefix = 0 -- last - CalendarTemplateAssignmentDayPrefix
	end

	-- goto the first valid Start Date based on the parameters
	set @currentDate = dbo.GetNextDateForMonthOption2(@iPrefix, @gUnit, @currentDate, @StartDate)
	
	declare @stopWhile bit = 0
	while ((@stopWhile = 0) and ((@EndDate is null) OR (@currentDate <= @EndDate)))
	begin
		set @nextDate = dbo.GetNextDateForMonthOption2(@iPrefix, @gUnit, DATEADD(month, @iMonth, @currentDate), @StartDate)

		if (@SearchDate > @nextDate)
		begin
			set @currentDate = @nextDate
		end
		else if (@SearchDate < @currentDate)
		begin
			set @stopWhile = 1
			break
		end
		else begin
			set @i = 0
			while ((@i < @NumDays) and (@stopWhile = 0))
			begin
				set @currentMonthDate = DATEADD(day, @i, @currentDate)

				if ((@SearchDate >= @currentMonthDate) and (@SearchDate < DATEADD(day, @NumDays, @currentDate)))
				begin
					if ((@gPrefix = CONVERT(uniqueidentifier, ''57D0D8DA-8EC6-40DD-BFBC-FCE228ABF107'')) and 
						(
							(@gUnit =  CONVERT(uniqueidentifier, ''F0917C45-D974-46D5-B914-57B8E602362B'')) -- Sunday
							or (@gUnit =  CONVERT(uniqueidentifier, ''B4658BCB-78BF-46DD-A1F8-52021AC160E1'')) -- Monday
							or (@gUnit =  CONVERT(uniqueidentifier, ''F5B6EC8F-FFA2-4489-A916-9916BE193ECC'')) -- Tuesday
							or (@gUnit =  CONVERT(uniqueidentifier, ''DA34F712-ED05-455F-97C8-0C6B8DC49C4F'')) -- Wednesday
							or (@gUnit =  CONVERT(uniqueidentifier, ''F15B441F-054F-4A74-BB14-4441BA6DE158'')) -- Thursday
							or (@gUnit =  CONVERT(uniqueidentifier, ''CF007109-4E97-435A-A37C-F0DAFBFD7DBE'')) -- Friday
							or (@gUnit =  CONVERT(uniqueidentifier, ''3C47E0D9-0A04-4420-99B7-496E319900C5'')) -- Saturday
						)
					   )
					begin
						declare @tempMonthDate DATE = DATEADD(day, -28, @SearchDate)
						if (DATEPART(month, @tempMonthDate) = DATEPART(month, @SearchDate))
						begin
							set @daysOffset = DATEDIFF(day, @SearchDate, @currentMonthDate)
							set @found = 1
							set @stopWhile = 1
							break
						end
						else begin
							set @stopWhile = 1
						end
					end -- of if ((@gPrefix = CONVERT(uniqueidentifier, ''57D0D8DA-8EC6-40DD-BFBC-FCE228ABF107'')) and ...
					else begin			
						set @daysOffset = DATEDIFF(day, @SearchDate, @currentMonthDate) + 1
						set @found = 1
						set @stopWhile = 1
					end
				end -- of if ((@SearchDate >= @currentMonthDate) and (@SearchDate < DATEADD(day, @NumDays, @currentDate)))

				set @i = @i + 1
			end -- of while ((@i < @NumDays) and (@stopWhile = 0))

			set @currentDate = @nextDate
		end

	end -- of while ((@stopWhile = 0) and ((@EndDate is null) OR (@currentDate <= @EndDate)))

	insert into @Result (Found, DaysOffset) values (@found, @daysOffset)

	return 
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNextDateForMonthOption1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				method "GetNextDateForMonthOption1(int iDay, DateTime currentDate)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetNextDateForMonthOption1](
		@iDay int,
		@currentDate DATE
		)

RETURNS DATE
AS
begin
	declare @iCurrentMonth int

	if (@iDay < DATEPART(day, @currentDate))
	begin
		set @currentDate = DATEADD(month, 1, @currentDate)
	end

	set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
					CONVERT(varchar(20), DATEPART(year, @currentDate))
					
	set @iCurrentMonth = DATEPART(month, @currentDate)
	set @currentDate = DATEADD(day, @iDay - 1, @currentDate)

	if (DATEPART(month, @currentDate) > @iCurrentMonth)
	begin
		set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
					CONVERT(varchar(20), DATEPART(year, @currentDate))
		set @currentDate = DATEADD(day, -1, @currentDate)
	end

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckMonthlyAssignmentStateOption1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object
--				"RelCalendarCalendarTemplateHead.cs";
--				function "CheckMonthlyAssignmentStateOption1
--					(XmlDocument xmlDoc, DateTime oDate, out int offset)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[CheckMonthlyAssignmentStateOption1](
		@SearchDate DATE,
		@NumDays int,
		@iDay int,
		@iMonth int,
		@StartDate Date,
		@EndDate Date
		)

RETURNS
@Result Table
	(
		Found bit default (0),
		DaysOffset int default (-1)
	)
begin

	declare @daysOffset int = -1
	declare @found bit = 0
	declare @i int
	declare @currentDate Date = @StartDate

	set @currentDate = dbo.GetNextDateForMonthOption1(@iDay, @currentDate)

	while ((@EndDate is null) or (@currentDate <= @EndDate))
	begin
		declare @nextDate DATE= dbo.GetNextDateForMonthOption1(@iDay, DATEADD(month, @iMonth, @currentDate))
						
		if (@SearchDate > @nextDate)
		begin
			set @currentDate = @nextDate -- skip to next occurrence
		end
		else if (@SearchDate < @currentDate)
		begin
			break
		end
		else begin
			set @i = 0
			while (@i < @NumDays)
			begin
				declare @currentMonthDate DATE = DATEADD(day, @i, @currentDate)
				if ((@SearchDate >= @currentMonthDate) and (@SearchDate < DATEADD(day, @NumDays, @currentDate)))
				begin
					set @DaysOffset = DATEDIFF(day, @currentMonthDate, @SearchDate) + 1
					set @found = 1
					break
				end

				set @i = @i + 1
			end -- of while (@i < @NumDays)
		end
					
		if (@found = 1)
		begin
			break
		end	
		set @currentDate = @nextDate

	end -- while ((@EndDate is null) or (@SearchDate <= @EndDate))

	insert into @Result (Found, DaysOffset) values (@found, @daysOffset)

	return 
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckWeeklyAssignmentState]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				function "CheckWeeklyAssignmentState(DateTime oDate, out int offset)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[CheckWeeklyAssignmentState](
		@SearchDate DATE,
		@NumDays int,
		@RecurrencePattern varchar(max),
		@StartDate Date,
		@EndDate Date
		)

RETURNS
@Result Table
	(
		Found bit default (0),
		DaysOffset int default (-1)
	)
begin
	-- <monthly radio="1" day="1" month="1" />
	declare @daysOffset int = -1
	declare @found bit = 0
	declare @i int
	declare @currentDate Date = @StartDate
	
	declare @iWeeks int
	declare @bMonday int
	declare @bTusesday int
	declare @bWednesday int
	declare @bThursday int
	declare @bFriday int
	declare @bSaturday int
	declare @bSunday int

	-- this is a weekly assigment, need to get xml values
	declare @xmlDay xml = @RecurrencePattern
	SELECT  
		@iWeeks = Tbl.Col.value(''@weeks'', ''smallint''),
		@bMonday = Tbl.Col.value(''@mon'', ''smallint''),
		@bTusesday = Tbl.Col.value(''@tue'', ''smallint''),
		@bWednesday = Tbl.Col.value(''@wed'', ''smallint''),
		@bThursday = Tbl.Col.value(''@thu'', ''smallint''),
		@bFriday = Tbl.Col.value(''@fri'', ''smallint''),
		@bSaturday = Tbl.Col.value(''@sat'', ''smallint''),
		@bSunday = Tbl.Col.value(''@sun'', ''smallint'')
	FROM   @xmlDay.nodes(''//weekly'') Tbl(Col)
	
	while ((@EndDate is null) or (@currentDate <= @EndDate))
	begin
		if (@SearchDate > DATEADD(day, 7 + @NumDays, @currentDate))
		begin
			set @currentDate = DATEADD(day, 7 * @iWeeks, @currentDate) -- skip to the next occurrence
		end
		else if (@SearchDate < @currentDate)
		begin
			set @found = 0
			break
		end
		else begin
			set @i = 0
			while (@i < 7)
			begin
				declare @currentWeekDate Date = DATEADD(day, @i, @currentDate)
				declare @dayOfWeek int = DATEPART(WEEKDAY, @currentWeekDate)
				if (@dayOfWeek = 1 and @bSunday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 2 and @bMonday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 3 and @bTusesday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 4 and @bWednesday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 5 and @bThursday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 6 and @bFriday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 7 and @bSaturday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end

				if (@found = 1)
				begin
					set @daysOffset = DATEDIFF(day, @currentWeekDate, @SearchDate) + 1
					break
				end
				set @i = @i + 1
			end -- of while (@i < 7)
			
			set @currentDate = DATEADD(day, 7 * @iWeeks, @currentDate)
		end
						
		if (@found = 1)
			break

	end -- of while ((@EndDate is null) or (@SearchDate <= @EndDate))

	insert into @Result (Found, DaysOffset) values (@found, @daysOffset)

	return 
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetStartEndTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/11/2016
-- Description:	Returns the start time and end time and are the 
--				number of minutes after mid night.
--
--				The below function is a emulation of the C# code 
--				found in “CalendarUtilities.cs”; functions 
--				“GetStartTime” and “GetEndTime”.
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetStartEndTime](
		@CalendarUid uniqueidentifier,	-- calendar to be searched
		@SearchDate DATE				-- date to find start time and end time
		)

RETURNS
@StartEndTime table
(
	StartTime int,			-- number of minutes after mid night
	EndTime int,			-- number of minutes after mid night
	DisplayInterval int,	-- number of minutes in an appointment slot
	IsOpen bit default (0),
	CalendarTemplateDayUid uniqueidentifier
)
AS
begin
	declare @found bit = 0
	declare @RecurrencePattern varchar(max)
	declare @StartDate Date
	declare @EndDate Date
	declare @NumDays int
	declare @CalendarTemplateHeadUid uniqueidentifier
	declare @DaysOffset int = -1

	declare rel_cursor cursor for 
			select rel.RecurrencePattern, rel.StartDate, rel.EndDate, lcth.NumDays, lcth.CalendarTemplateHeadUid
			from RelCalendarCalendarTemplateHead rel
				inner join ListCalendarTemplateHead lcth on rel.CalendarTemplateHeadUid = lcth.CalendarTemplateHeadUid
			where rel.CalendarUid = @CalendarUid 
				and rel.StartDate <= @SearchDate 
				and (rel.EndDate >= @SearchDate or rel.EndDate is null)
			order by rel.ZIndex desc

	open rel_cursor

	fetch NEXT from rel_cursor into @RecurrencePattern, @StartDate, @EndDate, @NumDays, @CalendarTemplateHeadUid

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			-- While loop is based on C# code: see business object "RelCalendarCalendarTemplateHead.cs";
			-- function "GetCalendarTemplateDay(DateTime oDate)"

			if (@RecurrencePattern is null) -- continuous
			begin
				set @DaysOffset = DATEDIFF(day, @StartDate, @SearchDate) + 1
				if (@DaysOffset > @NumDays)
				begin
					set @DaysOffset = @DaysOffset % @NumDays
					if (@DaysOffset = 0)
					begin
						set @DaysOffset = @NumDays
					end
				end
				set @found = 1
			end
			else if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<w'') -- weekly
			begin
				select @found = Found, @DaysOffset = DaysOffset 
						from dbo.CheckWeeklyAssignmentState(@SearchDate, @NumDays, @RecurrencePattern, @StartDate, @EndDate)
			end
			else if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<m'') -- monthly
			begin
				set @DaysOffset = -1;
				declare @xmlMonthly xml = @RecurrencePattern

				declare @option1 int
				declare @iDay int
				declare @iMonth int
				declare @gPrefix uniqueidentifier
				declare @gUnit uniqueidentifier
				
				-- get xml data
				SELECT 
					@option1 = Tbl.Col.value(''@radio'', ''smallint''),
					@iDay = Tbl.Col.value(''@day'', ''smallint''),
					@iMonth = Tbl.Col.value(''@month'', ''smallint''),
					@gPrefix = Tbl.Col.value(''@prefix'', ''uniqueidentifier''),
					@gUnit = Tbl.Col.value(''@unit'', ''uniqueidentifier'')
				FROM @xmlMonthly.nodes(''//monthly'') Tbl(Col)

				if (@option1 = 1)
				begin
					select @found = Found, @DaysOffset = DaysOffset 
						from dbo.CheckMonthlyAssignmentStateOption1(@SearchDate, @NumDays, @iDay, @iMonth, @StartDate, @EndDate)
				end
				else begin
					-- <monthly radio="2" month="1" prefix="2a68f31d-1a22-4384-8ae7-ace1488bbd72" unit="b3121d9e-9769-4831-8f4e-0678e3f49c13" />
					select @found = Found, @DaysOffset = DaysOffset 
						from dbo.CheckMonthlyAssignmentStateOption2(@SearchDate, @NumDays, @iMonth, @gPrefix, @gUnit, @StartDate, @EndDate)
				end

			end -- of if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<m'')
			else if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<d'')
			begin
				set @found = 1
				break
			end -- of if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<d'')
		end
	
		if (@found = 1)
			break

		fetch NEXT from rel_cursor into @RecurrencePattern, @StartDate, @EndDate, @NumDays, @CalendarTemplateHeadUid

	end -- of while
		
	close rel_cursor
	deallocate rel_cursor

	declare @StartTime int
	declare @EndTime int
	declare @DisplayInterval int
	declare @IsOpen bit = 1
	declare @CalendarTemplateDayUid uniqueidentifier

	select @StartTime = lctd.StartTime, @IsOpen = lctd.IsOpen, @CalendarTemplateDayUid = lctd.CalendarTemplateDayUid
		from ListCalendarTemplateDay lctd
		where lctd.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
			and lctd.Inactive = 0
			and lctd.TemplateDay = @DaysOffset
	
	if (@StartTime is null)
	begin
		select @StartTime = lcth.StartTime
		from ListCalendarTemplateHead lcth
		where lcth.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
		and lcth.Inactive = 0
	end

	if (@StartTime is null)
	begin
		select @StartTime = lc.StartTime
		from ListCalendar lc 
		where lc.CalendarUid = @CalendarUid
			and lc.Inactive = 0
	end

	select @EndTime = lctd.EndTime, @IsOpen = lctd.IsOpen
		from ListCalendarTemplateDay lctd
		where lctd.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
			and lctd.Inactive = 0
			and lctd.TemplateDay = @DaysOffset
	
	if (@EndTime is null)
	begin
		select @EndTime = lcth.EndTime
		from ListCalendarTemplateHead lcth
		where lcth.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
		and lcth.Inactive = 0
	end

	if (@EndTime is null)
	begin
		select @EndTime = lc.EndTime
		from ListCalendar lc 
		where lc.CalendarUid = @CalendarUid
			and lc.Inactive = 0
	end

	select @DisplayInterval = lcth.DisplayInterval
	from ListCalendarTemplateHead lcth
	where lcth.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
		and lcth.Inactive = 0

	if (@DisplayInterval is null)
	begin
		select @DisplayInterval = lc.DisplayInterval
		from ListCalendar lc 
		where lc.CalendarUid = @CalendarUid
			and lc.Inactive = 0
	end

	insert into @StartEndTime (StartTime, EndTime, DisplayInterval, IsOpen, CalendarTemplateDayUid)
		values (@StartTime, @EndTime, @DisplayInterval, @isOpen, @CalendarTemplateDayUid)

	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindOpenSlotOnCalendar]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/11/2016
-- Description:	
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[FindOpenSlotOnCalendar](
		@CalendarUid uniqueidentifier,			-- calendar to be searched
		@AppointmentTypeUid uniqueidentifier,	-- appointment type
		@SearchDate DATETIME,					-- if null will be populated with the current date
		@LookForAppoinmentTypeOnly bit,			-- when this value is null or zero this function
												-- will return any appointment type that has the
												-- the correct duration
		@LastEndDateTime datetime
		)

RETURNS
@OpenSlotResults table
(
	StartDateTime datetime,
	EndDateTime datetime,
	Duration int, -- in minutes
	AppointmentTypeUid uniqueidentifier,
	IsCalendarActive bit default (1)
)
AS
begin

	declare @startTime int -- minutes after mid-night
	declare @endTime int -- minutes after mid-night
	declare @displayInterval int -- time slot intervals in minutes

	if (@SearchDate is null)
		set @SearchDate = GetDate()

	declare @isOpen bit = 1
	declare @CalendarTemplateDayUid uniqueidentifier
	
	-- find one day''s calendar
	select	@isOpen = IsOpen, 
			@startTime = StartTime, 
			@endTime = EndTime, 
			@displayInterval = DisplayInterval, 
			@CalendarTemplateDayUid = CalendarTemplateDayUid
			from dbo.GetStartEndTime(@CalendarUid, @SearchDate)

	-- create temp working table
	declare @AvailableAppointmentTimeSlots table
	(
		StartTime int, -- minutes after mid-night
		EndTime int, -- minutes after mid-night
		StartDateTime datetime,
		EndDateTime datetime,
		Duration int, -- in minutes
		IsOpen bit default (0),
		Blocked bit default (0),
		AppointmentTypeUid uniqueidentifier,
		AppointmentStatusUid uniqueidentifier
	)

	-- fill in all possible time slots
	declare @timeCnt int = @startTime
	while @timeCnt + @displayInterval < @endTime
	begin
		insert into @AvailableAppointmentTimeSlots 
					(
						StartTime,
						EndTime,
						StartDateTime, 
						EndDateTime,
						Duration,
						IsOpen,
						Blocked
					)
			values	(
						@timeCnt,
						@timeCnt + @displayInterval,
						DATEADD(MINUTE, @timeCnt, convert(datetime, convert(date, @searchDate))), 
						DATEADD(MINUTE, @timeCnt + @displayInterval, convert(datetime, convert(date, @searchDate))),
						@displayInterval,
						@IsOpen,
						0
					)
		set @timeCnt = @timeCnt + @displayInterval
	end
	
	-- populate day slots; if they exists
	if (@CalendarTemplateDayUid is not null)
	begin

		declare @daySlotStartTime int
		declare @daySlotEndTime int
		declare @daySlotAppointmentTypeUid uniqueidentifier
		declare @daySlotBlocking bit
	
		declare dayslot_cursor cursor for 		
			select	lctds.StartTime, lctds.EndTime, lctds.AppointmentTypeUid
			from ListCalendarTemplateDaySlot lctds 
			where CalendarTemplateDayUid = @CalendarTemplateDayUid

		open dayslot_cursor
		fetch NEXT from dayslot_cursor into @daySlotStartTime, @daySlotEndTime, @daySlotAppointmentTypeUid

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				select @daySlotBlocking = lpt.Blocking from ListAppointmentType lpt where lpt.AppointmentTypeUid = @daySlotAppointmentTypeUid
	
				declare @nextEndTime int = @daySlotStartTime

				while @nextEndTime < @daySlotEndTime
				begin
					set @nextEndTime = @nextEndTime + @displayInterval
				end 

				update aapts SET aapts.AppointmentTypeUid = @daySlotAppointmentTypeUid, aapts.Blocked = ISNULL(@daySlotBlocking, 0)
					from @AvailableAppointmentTimeSlots aapts
					where aapts.StartTime >= @daySlotStartTime and aapts.EndTime <= @nextEndTime
			end
			fetch NEXT from dayslot_cursor into @daySlotStartTime, @daySlotEndTime, @daySlotAppointmentTypeUid
		end -- of while
		
		close dayslot_cursor
		deallocate dayslot_cursor

	end

	-- populate appointments
	update aats SET AppointmentStatusUid = a.AppointmentStatusUid
		from Appointment a 
			inner join @AvailableAppointmentTimeSlots aats on dbo.ConvertUTCToLocalTime(a.StartDateTime) >= aats.StartDateTime
				and dbo.ConvertUTCToLocalTime(a.EndDateTime) <= aats.EndDateTime 
		where a.CalendarUid = @CalendarUid

	-- remove any canceled appointment status
	update aats SET AppointmentStatusUid = null
		from @AvailableAppointmentTimeSlots aats
			inner join ListAppointmentStatus lps on lps.AppointmentStatusUid = aats.AppointmentStatusUid
		where lps.IsCanceledStatus = 1
	
	-- find an open slot
	-- get the time required for the appointment type
	declare @RequiredDuration int

	select @RequiredDuration = Duration from ListAppointmentType where AppointmentTypeUid = @AppointmentTypeUid

	-- find "back to back" appointment slots that match the required time for the appointment type

	declare @foundStartDateTime datetime
	declare @foundAppointmentTypeUid uniqueidentifier

	declare @testDuration int = 0
	declare @loopStartDateTime datetime
	declare @loopEndDateTime datetime
	declare @loopDuration int
	declare @loopAppointmentStatusUid uniqueidentifier
	declare @loopAppointmentTypeUid uniqueidentifier
	declare @loopIsOpen bit = 0
	declare @loopBlocked bit = 0

	declare search_cursor cursor for 
		select StartDateTime, EndDateTime, Duration, AppointmentTypeUid, AppointmentStatusUid, IsOpen, Blocked
		from @AvailableAppointmentTimeSlots
		where (@LastEndDateTime is null) or ((@LastEndDateTime is not null) and (EndDateTime > @LastEndDateTime))
	
	open search_cursor
	fetch NEXT from search_cursor into @loopStartDateTime, @loopEndDateTime, @loopDuration, @loopAppointmentTypeUid,
								@loopAppointmentStatusUid, @loopIsOpen, @loopBlocked

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			if ((@loopAppointmentStatusUid is null) and (@loopIsOpen = 1) and (ISNULL(@loopBlocked, 0) = 0))
			begin
				if (@testDuration = 0)
				begin
					set @foundStartDateTime = @loopStartDateTime
					set @foundAppointmentTypeUid = @loopAppointmentTypeUid
				end

				if ((ISNULL(@LookForAppoinmentTypeOnly, 0) = 0) OR
					((ISNULL(@LookForAppoinmentTypeOnly, 0) = 1) and (@loopAppointmentTypeUid = @AppointmentTypeUid)))
				begin
					set @testDuration = @testDuration + @loopDuration
				end
			end
			else begin
				set @testDuration = 0
				set @foundStartDateTime = null
				set @foundAppointmentTypeUid = null
			end
		end
	
		if ((@loopAppointmentStatusUid is null) and (@testDuration >= @RequiredDuration))
		begin
			break
		end
		
		fetch NEXT from search_cursor into @loopStartDateTime, @loopEndDateTime, @loopDuration, @loopAppointmentTypeUid,
									@loopAppointmentStatusUid, @loopIsOpen, @loopBlocked

	end -- of while
		
	close search_cursor
	deallocate search_cursor

	if (@testDuration > 0)
	begin
		insert into @OpenSlotResults(StartDateTime, EndDateTime, Duration, AppointmentTypeUid)
			values (@foundStartDateTime, dateadd(minute, @RequiredDuration, @foundStartDateTime), @RequiredDuration, @foundAppointmentTypeUid)
	end

	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OpenSlotCalendarAppointment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =================================================================
-- Author:		CHM
-- Create date: 02/17/2016
-- Description:	Returns an open slot for a calendar and appointment
--				type.
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[OpenSlotCalendarAppointment](
	@SearchStartDate DateTime,				-- date to "begin" looking for an open appointment
											-- if "null" will be today
	@SearchEndDate DateTime,				-- date to "end" looking for an open appointment
											-- if "null" will be a 365 days after the "begin" date
	@LookForAppoinmentTypeOnly bit,			-- when this value is null or zero this function
											-- will return any appointment type that has the
											-- the correct duration
	@CalendarUid uniqueidentifier,			-- calendar to be searched
	@AppointmentTypeUid uniqueidentifier,	-- appointment type to look for an open slot
	@OpenSlotOption int,					-- "1" = found first slot; "2" = found second slot;
											-- "3" = found third slot
											-- when "ReturnAllOpenSlots" is not "1" and "OpenSlotOption"
											-- is "null" or greater than "3" then it will be set to 
											-- a default value of "3" 
	@ReturnAllOpenSlots bit                 -- when "1" will return the number of open appointment
											-- slots defined in "OpenSlotOption" max return is "50"
		)

RETURNS
@Results table
	(
		CalendarName varchar(255),
		AppointmentTypeName varchar(255),
		AppointmentStartDateTime datetime,
		WaitTimeInDays decimal(14,3),
		ResultText varchar(30)
	)
AS
begin

	declare @ResultText varchar(30)
	declare @CalendarName varchar(255) = (select Name from ListCalendar where CalendarUid = @CalendarUid)
	declare @AppointmentTypeName varchar(255) = (select Name from ListAppointmentType where AppointmentTypeUid = @AppointmentTypeUid)
	declare @SearchDate datetime = @SearchStartDate
	declare @StartDateTime datetime
	declare @LastEndDateTime datetime
	declare @OpenSlotCount int = 0
	declare @found bit = 0

	if (@SearchStartDate is null)
	begin
		set @SearchStartDate = GETDATE()
	end
	if (@SearchEndDate is null)
	begin
		set @SearchEndDate = DATEADD(day, 365, @SearchStartDate)
	end


	if ((ISNULL(@ReturnAllOpenSlots, 0) = 0) and ((@OpenSlotOption is null) or (@OpenSlotOption > 3)))
	begin
		set @OpenSlotOption = 3
	end
	if ((ISNULL(@ReturnAllOpenSlots, 0) = 1) and (@OpenSlotOption is null))
	begin
		set @OpenSlotOption = 3
	end
	if ((ISNULL(@ReturnAllOpenSlots, 0) = 1) and (@OpenSlotOption > 50))
	begin
		set @OpenSlotOption = 50
	end

	if ((ISNULL(@LookForAppoinmentTypeOnly, 0) = 1) 
		AND (@AppointmentTypeUid is not null)
		AND (@CalendarUid is not null))
	begin
		declare @tempCnt int

		---- is appointment type in calendar
		select @tempCnt = COUNT(*) from ListCalendarTemplateDaySlot lctds
		inner join ListCalendarTemplateDay lctd on lctds.CalendarTemplateDayUid = lctd.CalendarTemplateDayUid
		inner join RelCalendarCalendarTemplateHead rccth on lctd.CalendarTemplateHeadUid = rccth.CalendarTemplateHeadUid
		where rccth.CalendarUid = @CalendarUid and lctds.AppointmentTypeUid = @AppointmentTypeUid 
				and ((rccth.StartDate <= @SearchStartDate and rccth.EndDate is null)
				or (rccth.StartDate <= @SearchStartDate and rccth.EndDate >= @SearchEndDate))

		-- not in calendar; no need to continue
		if (@tempCnt = 0)
		begin
			insert into @Results (
					CalendarName,
					AppointmentTypeName,
					ResultText
				)
			values (
					@CalendarName,
					@AppointmentTypeName,
					''not found''
				)

			return
		end
	end
		
	--declare @dayCount int = 0

	if (ISNULL(@ReturnAllOpenSlots, 0) = 0)
	begin
		if (@OpenSlotOption = 1)
			set @ResultText = ''slot 1''
		else if (@OpenSlotOption = 2)
			set @ResultText = ''slot 2''
		else
			set @ResultText = ''slot 3''
	end
	while ((@SearchDate <= @SearchEndDate) and (@OpenSlotCount < @OpenSlotOption))
	begin
		--set @dayCount = @dayCount + 1
		set @found = 0
		set @StartDateTime = null
		select @StartDateTime = StartDateTime, @LastEndDateTime = EndDateTime 
			from dbo.FindOpenSlotOnCalendar (@CalendarUid, @AppointmentTypeUid, @SearchDate, @LookForAppoinmentTypeOnly, @LastEndDateTime)

		if (@StartDateTime is not null)
		begin
			-- skip times of day that have already passed
			if (CONVERT(decimal(14,3), DATEDIFF(SECOND, @SearchStartDate, @StartDateTime) / 86400.0) > 0)
			begin
				set @OpenSlotCount = @OpenSlotCount + 1 
				if ((@OpenSlotCount = @OpenSlotOption) or (ISNULL(@ReturnAllOpenSlots, 0) = 1))
				begin
					if (ISNULL(@ReturnAllOpenSlots, 0) = 1)
					begin
						set @ResultText = ''slot '' + convert(varchar(20), @OpenSlotCount)
					end

					insert into @Results (
						CalendarName,
						AppointmentTypeName,
						AppointmentStartDateTime,
						WaitTimeInDays,
						ResultText
						)
					values (
						@CalendarName,
						@AppointmentTypeName,
						@StartDateTime,
						CONVERT(decimal(14,3), DATEDIFF(SECOND, @SearchStartDate, @StartDateTime) / 86400.0),
						@ResultText
						)
					set @found = 1
				end
			end 
		end
		if (@found = 0)
		begin
			-- try the next day
			set @SearchDate = DATEADD(day, 1, @SearchDate)
			-- when looking for an appointment type and none is found in the first 30 days; exit
			--if ((ISNULL(@LookForAppoinmentTypeOnly, 0) = 1) and (@dayCount > 30))
			--begin
			--	break
			--end
		end
	end -- end of while ((@SearchDate <= @SearchEndDate) and (@OpenSlotCount < @OpenSlotOption))

	if ((select count(*) from @Results) = 0)
	begin		
		insert into @Results (
			CalendarName,
			AppointmentTypeName,
			ResultText
		)
		values (
			@CalendarName,
			@AppointmentTypeName,
			''not found''
		)
	end

	return
end



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AppointmentAvailabilityReport]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/22/2016
-- Description:	Returns a table of Appointment Availability Report
--				based on supplied parameters.
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[AppointmentAvailabilityReport](
	@SearchStartDate Date,					-- date to "begin" looking for an open appointment
											-- if "null" will be today
	@SearchEndDate Date,					-- date to "end" looking for an open appointment
											-- if "null" will be a 365 days after the "begin" date
	@LookForAppoinmentTypeOnly bit,			-- when this value is null or zero this function
											-- will return any appointment type that has the
											-- the correct duration
	@CalendarUidList varchar(max),			-- list of calendar uids (separated by a semicolon)
											-- to be searched, when null will search all calendars
	@AppointmentTypeUidList varchar(max),	-- list of appointment type uids (separated by a semicolon)
											-- to be searched, when null will search all appointment types
	@OpenSlotOption int,					-- "1" = found first slot; "2" = found second slot;
											-- "3" = found third slot
											-- when "ReturnAllOpenSlots" is not "1" and "OpenSlotOption"
											-- is "null" or greater than "3" then it will be set to 
											-- a default value of "3" 
	@ReturnAllOpenSlots bit                 -- when "1" will return the number of open appointment
											-- slots defined in "OpenSlotOption" max return is "50"
											)
RETURNS
@Results table
	(
		CalendarName varchar(255),
		AppointmentTypeName varchar(255),
		AppointmentStartDateTime datetime,
		WaitTimeInDays decimal(14,3),
		ResultText varchar(30)
	)
AS BEGIN

	declare @CalendarUids table
	(
		CalendarUid uniqueidentifier
	)

	INSERT		@CalendarUids
	SELECT		* 
	FROM		dbo.SplitList_Uids(@CalendarUidList, '','')
	
	declare @AppointmentTypeUids table
	(
		AppointmentTypeUid uniqueidentifier
	)

	INSERT		@AppointmentTypeUids
	SELECT		* 
	FROM		dbo.SplitList_Uids(@AppointmentTypeUidList, '','')
	
	declare @CalendarUid uniqueidentifier
	declare @AppointmentTypeUid uniqueidentifier

	if (@SearchStartDate is null)
	begin
		set @SearchStartDate = GETDATE()
	end
	if (@SearchEndDate is null)
	begin
		set @SearchEndDate = DATEADD(day, 365, @SearchStartDate)
	end

	declare cal_cursor cursor for 
		select CalendarUid 
		from ListCalendar 
		where Inactive = 0
		and ((@CalendarUidList is null) or (CalendarUid in (select CalendarUid from @CalendarUids)))
		order by Name
			
	open cal_cursor

	fetch NEXT from cal_cursor into @CalendarUid

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
		
			declare type_cursor cursor for 
				select AppointmentTypeUid 
				from ListAppointmentType 
				where Inactive = 0 and Blocking = 0
				and ((@AppointmentTypeUidList is null) or (AppointmentTypeUid in (select AppointmentTypeUid from @AppointmentTypeUids)))
				order by Name
			
			open type_cursor

			fetch NEXT from type_cursor into @AppointmentTypeUid

			while (@@fetch_status <> -1)
			begin
				if (@@fetch_status <> -2)
				begin			
					insert into @Results (CalendarName, AppointmentTypeName, AppointmentStartDateTime, WaitTimeInDays, ResultText)
						select CalendarName, AppointmentTypeName, AppointmentStartDateTime, WaitTimeInDays, ResultText 
						from dbo.OpenSlotCalendarAppointment(@SearchStartDate, @SearchEndDate, @LookForAppoinmentTypeOnly, 
										@CalendarUid, @AppointmentTypeUid, @OpenSlotOption, @ReturnAllOpenSlots)
				end

				fetch NEXT from type_cursor into @AppointmentTypeUid
			end -- of while

			close type_cursor
			deallocate type_cursor
		end
		
		fetch NEXT from cal_cursor into @CalendarUid
	end -- of while

	close cal_cursor
	deallocate cal_cursor

	return
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetTransactionAggregate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_GetTransactionAggregate](@transactionUid uniqueidentifier)
RETURNS @retTable TABLE 
(
    InsAdjustment MONEY,
    PatientAdjustment MONEY,
    PatientTransfer MONEY,
	InsTransfer MONEY
)
AS
BEGIN

	-- Bug 55495:Opening an existing deposit takes about 30seconds to 1 minute top open
	-- Changed call to AR_ViewTransactionsByDeposit to use this so can optimize fetch of transaction aggregates
	-- Otherwise query below and AR_ViewTransactionDeposits pull ALL financials before doing join in AR_ViewTransactionsByDeposit

	INSERT @retTable (InsAdjustment, PatientAdjustment, PatientTransfer, InsTransfer)
		SELECT InsAdjustment, PatientAdjustment, PatientTransfer, InsTransfer FROM AR_ViewTransactionAggregateSub 
		WHERE TransactionUid = @transactionUid
	 
	RETURN ;
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetTransactionBatches]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_GetTransactionBatches](@transactionUid uniqueidentifier)
RETURNS @retTable TABLE 
(
    transactionUid uniqueidentifier,
    BatchUids varchar(250),
	BatchNames varchar(250),
	BatchStates varchar(80)
)
AS
BEGIN

	DECLARE @ARBatchUids varchar(MAX) 
	DECLARE @ARBatchNames varchar(MAX)
	DECLARE @ARBatchStates varchar(MAX)
	
	
	 -- Get all ledger entries associated with this superbill''s procedures
	 DECLARE @batchTable TABLE
	 (
	   ARBatchUid uniqueidentifier,
	   Name varchar(255),
	   IsLocked bit,
	   IsClosed bit,
	   GLDate datetime
	 ) ;
	 
	 -- Find batch ledger entries
	 INSERT @batchTable(ARBatchUid, Name, IsLocked, IsClosed, GLDate)
		select distinct arb.ARBatchUid, arb.Name, arb.IsClosed, arb.IsLocked, arb.GLDate
		from AR_LedgerDetail ld
			inner join AR_Ledger l on ld.ledgerUid = l.ledgeruid 
				inner join ARBatch arb on l.ArBatchUid = arb.ARBatchUid
		where l.TransactionUid = @transactionUid
		
	 -- Loop 
	 DECLARE @uid uniqueidentifier
	 DECLARE @name VARCHAR(255)
	 DECLARE @isLocked bit
	 DECLARE @isClosed bit
	 DECLARE @isOpen bit
	 
	 select @ARBatchUids = null,
	        @ARBatchNames = null,
	        @isLocked = 0,  -- Complete
	        @isClosed = 0,  -- Closed
	        @isOpen = 0     -- Open

	 select @ARBatchUids = CASE WHEN @ARBatchUids IS NULL THEN CONVERT(VARCHAR(36), bt.ARBatchUid) ELSE '','' + CONVERT(VARCHAR(36), bt.ARBatchUid) END,
	        @ARBatchNames = CASE WHEN @ARBatchNames IS NULL THEN CONVERT(VARCHAR(255), bt.Name) ELSE '','' + CONVERT(VARCHAR(255), bt.Name) END,
	        @isOpen   = CASE WHEN (bt.IsLocked = 0 AND bt.IsClosed = 0) THEN 1 ELSE @isOpen END,
	        @isLocked = CASE WHEN bt.IsLocked = 1 THEN 1 ELSE @isLocked END,
	        @isClosed = CASE WHEN bt.IsClosed = 1 THEN 1 ELSE @isClosed END
	 FROM @batchTable bt
	 ORDER BY GLDate DESC
	 
	 DECLARE @batchStates varchar(80)
	 select @batchStates = CASE WHEN @isOpen = 1 THEN ''Open'' ELSE '''' END
	 SELECT @batchStates = CASE WHEN @isLocked = 1 AND @batchStates = '''' THEN ''Locked''
	                            WHEN @isLocked = 1 AND @batchStates != '''' THEN '', Locked'' 
	                            ELSE @batchStates END
	 SELECT @batchStates = CASE WHEN @isClosed = 1 AND @batchStates = '''' THEN ''Closed''
	                            WHEN @isClosed = 1 AND @batchStates != '''' THEN '', Closed'' 
	                            ELSE @batchStates END
	 
	 INSERT @retTable(transactionUid, BatchUids,BatchNames, BatchStates)
	   SELECT @transactionUid, @ARBatchUids, @ARBatchNames, @batchStates
	 
  return ;
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetTransactionDeposits]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_GetTransactionDeposits](@transactionUid uniqueidentifier)
RETURNS @retTable TABLE 
(
    transactionUid uniqueidentifier,
    depositUids varchar(250),
    depositNames varchar(250)
)
AS
BEGIN

	DECLARE @depositUids varchar(MAX) 
	DECLARE @depositNames varchar(MAX)
	
	 -- Get all ledger entries associated with this superbill''s procedures
	 DECLARE @dTable TABLE
	 (
	   depositUid uniqueidentifier,
	   Name varchar(255),
	   depositDate datetime
	 ) ;
	 
	 -- Find batch ledger entries
	 INSERT @dTable(depositUid, Name, depositDate)
		select distinct ld.DepositUid, d.ReferenceNumber, d.DepositDate
		from AR_LedgerDetail ld
			inner join AR_Ledger l on ld.ledgerUid = l.ledgeruid 
				inner join Deposit d on ld.DepositUid = d.DepositUid
		where l.TransactionUid = @transactionUid
			 
	 select @depositUids = null,
	        @depositNames = null

	 select @depositUids = CASE WHEN @depositUids IS NULL THEN CONVERT(VARCHAR(36), dt.depositUid) ELSE '','' + CONVERT(VARCHAR(36), dt.depositUid) END,
	        @depositNames = CASE WHEN @depositNames IS NULL THEN CONVERT(VARCHAR(255), dt.Name) ELSE '','' + CONVERT(VARCHAR(255), dt.Name) END
	 FROM @dTable dt
	 ORDER BY dt.depositDate DESC
	 	 
	 INSERT @retTable(transactionUid, depositUids, depositNames)
	   SELECT @transactionUid, @depositUids, @depositNames
	 
  return ;
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SuperbillProcedureBatch]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_SuperbillProcedureBatch]
(
	@superbillFilterXml XML
)
RETURNS 
@SuperbillProcedureBatchTable TABLE 
(
	SuperbillUid UNIQUEIDENTIFIER, 
	SuperbillProcedureUid UNIQUEIDENTIFIER, 
	ArBatchUid UNIQUEIDENTIFIER, 
	ArBatchName VARCHAR(255), 
	ArBatchPostingDate DATETIME
)
AS
BEGIN

	DECLARE @SuperbillFilterTable TABLE
	(
		SuperbillUid UNIQUEIDENTIFIER
	)
	INSERT @SuperbillFilterTable
		SELECT	x.n.value (''@SuperbillUid'', ''UNIQUEIDENTIFIER'') AS SuperbillUid
			FROM @superbillFilterXml.nodes(''Superbills/Superbill'') AS x(n)

	INSERT INTO @SuperbillProcedureBatchTable
		SELECT SuperbillUid, SuperbillProcedureUid, ArBatchUid, 
						ArBatchName, ArBatchPostingDate
			FROM (SELECT VSPBS.SuperbillUid, VSPBS.SuperbillProcedureUid, VSPBS.ArBatchUid, 
							VSPBS.ArBatchName, VSPBS.ArBatchPostingDate,
						RANK() OVER (PARTITION BY SuperbillProcedureUid, CreatedDateTime ORDER BY CreatedDateTime DESC) AS RankValue    
						FROM @SuperbillFilterTable SBFT
							INNER JOIN AR_ViewSuperbillProcedureBatchSub (NOEXPAND) VSPBS ON SBFT.SuperbillUid = VSPBS.SuperbillUid) RANKED 
			WHERE RANKED.RankValue = 1

	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getBatchFinancialStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[ARFN_getBatchFinancialStatus]  
(  
 @endDate DATETIME,   
 @financialCenterUids VARCHAR(8000)      
)   
RETURNS INT   
AS  
BEGIN  
   
 /*   
 For an end date and optional Financial Center filter (otherwise uses all)  
  returns ...  
    -1 - All Specified Financial Centers Closed Through End Date  
  0 - All Batches Closed Through End Date  
  1 - Not Closed But No Unallocated  
  2 - Not Closed And Unallocated Exist  
 */  
  
 DECLARE @retVal INT  
 SELECT @retVal = 2 -- default to worst case  
  
 DECLARE @ArBatches TABLE                       
 (                            
  ArBatchUid UNIQUEIDENTIFIER                         
 )     
  
 IF  @endDate IS NULL  
  SELECT @endDate = GetDate()  
SELECT @endDate =  DATEADD(DAY,1,@endDate)

 IF NOT (@financialCenterUids IS NULL OR @financialCenterUids = '''')  
 BEGIN  
  IF NOT EXISTS(SELECT FC.FinancialCenterUid FROM FinancialCenter FC  
   WHERE (FC.FinancialCenterUid IN (SELECT Element FROM Split(@financialCenterUids, '',''))) -- get only the specified financial centers  
    --AND cast(convert(varchar, ISNULL(ArClosedThroughDate,''1900-01-01''), 101) AS datetime) < @endDate) -- where close date < end date  
    and (ArClosedThroughDate is null or ArClosedThroughDate <@endDate))
  BEGIN  
   SELECT @retVal = -1  
  END  
 END  
  
 IF @retVal > -1 -- did not pass preliminary financial center test  
 BEGIN      
  INSERT INTO @ArBatches -- get open batches <= end date               
  SELECT ARB.ARBatchUid  
  FROM ArBatch ARB                      
  WHERE ARB.IsClosed = 0 --and cast(convert(varchar, ARB.GlDate, 101) AS datetime) <= @endDate  
  and ARB.GlDate <= @endDate
                         
  IF NOT EXISTS(SELECT ARBatchUid FROM @ArBatches) -- all batches are closed  
   SELECT @retVal = 0  
  ELSE  
  BEGIN  
   IF NOT EXISTS(SELECT DP.DepositUid FROM Deposit DP  
    LEFT JOIN AR_ViewDepositAggregate VD ON DP.DepositUid=VD.DepositUid          
    INNER JOIN @ArBatches ARBLIST ON DP.ArBatchUid = ARBLIST.ArBatchUid                          
    WHERE DP.Amount != (VD.Receipt - VD.ReceiptBalance) AND (DP.Void is null or DP.Void != 1)) -- no unallocated amounts  
    SELECT @retVal = 1   
   ELSE  
    SELECT @retVal = 2  
  END    
 END  
  
 RETURN @retVal  
  
 /* Testing  
  SELECT dbo.ARFN_getBatchFinancialStatus(null, null)  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', null)  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', '''')  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', ''C0414713-2185-4603-B4D7-1ED361C6951D'')  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', ''14B99C94-EDAC-47BD-97B9-CF421AC16018'')  
  SELECT dbo.ARFN_getBatchFinancialStatus(''2008-08-01'', ''14B99C94-EDAC-47BD-97B9-CF421AC16018'')  
  SELECT * FROM FinancialCenter  
 */  
  
END  
  


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getFeeScheduleFee]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ARFN_getFeeScheduleFee]
	(@feeSchedulePeriodUid uniqueidentifier, 
	@procedureUid uniqueidentifier) 
returns money as
begin
	/*	Returns the unit fee for the given fee schedule period and procedure.

		Equivalent to the code in the biz object FeeScheduleFee.cs property Fee.
	*/

	declare @fee money

	select top 1 @fee = (CASE WHEN fsp.RVUScheduleUid is not null 
							and rsv.RVUScheduleValueUid is not null 
							THEN (((rsv.WorkRVU * rs.WorkGPCI) 
								+ (rsv.RBNonFacilityPERVU * rs.PEGPCI) 
								+ (rsv.MPRVU * rs.MPGPCI)) * rs.ConversionFactor)
							ELSE fsf.Fee END) 
	from 
	FeeSchedule fs 
		inner join FeeSchedulePeriod fsp on fsp.FeeScheduleUid = fs.FeeScheduleUid 
		inner join FeeScheduleFee fsf on fsf.FeeSchedulePeriodUid = fsp.FeeSchedulePeriodUid 
			and fsf.Inactive = 0 
		left join RVUSchedule rs on rs.RVUScheduleUid = fsp.RVUScheduleUid 
		left join RVUScheduleValue rsv on rsv.RVUScheduleUid = rs.RVUScheduleUid 
			and rsv.ProcedureUid = @procedureUid 
			and rsv.Inactive = 0 
	where fsp.FeeSchedulePeriodUid = @feeSchedulePeriodUid 
		and fsf.ProcedureUid = @procedureUid 

	return isnull(round(@fee, 2), 0.00)
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getFeeSchedulePeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getFeeSchedulePeriod]
	(@feeScheduleUid uniqueidentifier, 
	@utcDate datetime) 
returns uniqueidentifier as
begin
	/*	Returns the fee schedule period for the given fee schedule on the given UTC date.

		Equivalent to the code in the biz object FeeSchedule.cs method GetFeeSchedulePeriod.
	*/
	declare @FeeSchedulePeriodUid uniqueidentifier 

	select top 1 @FeeSchedulePeriodUid = FeeSchedulePeriodUid 
	from FeeSchedulePeriod 
	where FeeScheduleUid = @feeScheduleUid 
		and (EffectiveDate is null or EffectiveDate <= @utcDate) 
		and (ExpirationDate is null or ExpirationDate > @utcDate) 
	order by EffectiveDate desc

	return @FeeSchedulePeriodUid
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getFinancialCenterStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ARFN_getFinancialCenterStatus]  
(  
 @endDate DATETIME,   
 @financialCenterUids VARCHAR(8000)      
)   
RETURNS INT   
AS  
BEGIN  
   
 /*   
 For an end date and optional Financial Center filter (otherwise uses all)  
  returns ...  
  -1 - All Specified Financial Centers Closed Through End Date  
   2 - Not Closed
 */  
  
 DECLARE @retVal INT  
 SELECT @retVal = 1 -- default to worst case  
  
 DECLARE @ArBatches TABLE                       
 (                            
  ArBatchUid UNIQUEIDENTIFIER                         
 )     
  
 IF  @endDate IS NULL  
  SELECT @endDate = GetDate()  
SELECT @endDate =  DATEADD(DAY,1,@endDate)

 IF NOT (@financialCenterUids IS NULL OR @financialCenterUids = '''')  
 BEGIN  
  IF NOT EXISTS(SELECT FC.FinancialCenterUid FROM FinancialCenter FC  
   WHERE (FC.FinancialCenterUid IN (SELECT Element FROM Split(@financialCenterUids, '',''))) -- get only the specified financial centers  
    --AND cast(convert(varchar, ISNULL(ArClosedThroughDate,''1900-01-01''), 101) AS datetime) < @endDate) -- where close date < end date  
    and (ArClosedThroughDate is null or ArClosedThroughDate <@endDate))
  BEGIN  
   SELECT @retVal = -1  
  END  
 END  
 RETURN @retVal  
 END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getGLDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[ARFN_getGLDate] (@dtCreateDate DATE, @dtCurrentPeriodEnd DATE)
RETURNS DATETIME AS 

BEGIN
	DECLARE @theGLDate DATE
	
	IF (@dtCurrentPeriodEnd > @dtCreateDate) 
		SELECT @theGLDate = @dtCreateDate 
	ELSE 
		SELECT @theGLDate = @dtCurrentPeriodEnd 
	
	RETURN @theGLDate
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getInsLevelName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getInsLevelName]
	(@insLevel INT)
RETURNS VARCHAR(10) AS 
BEGIN
	RETURN (CASE @insLevel 
		WHEN Null THEN '''' 
		WHEN 0 THEN '''' 
		WHEN 1 THEN ''Primary'' 
		WHEN 2 THEN ''Secondary'' 
		WHEN 3 THEN ''Tertiary'' 
		WHEN 4 THEN ''Quaternary'' 
		WHEN 5 THEN ''Quinary'' 
		WHEN 6 THEN ''Senary'' 
		WHEN 7 THEN ''Septary'' 
		WHEN 8 THEN ''Ogdoad'' 
		WHEN 9 THEN ''Ennead'' 
		WHEN 10 THEN ''Decad'' 
		ELSE (CONVERT(VARCHAR(8), @insLevel) + ''th'') END)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getLiabilityName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[ARFN_getLiabilityName]
	(@liabilityOwner SMALLINT)
RETURNS VARCHAR(10) AS 
BEGIN
	DECLARE @return VARCHAR(10)
	SELECT @return = Upper(dbo.ARFN_getInsLevelName(@liabilityOwner))
	IF (@return = '''') SELECT @return = ''PATIENT''
	RETURN @return
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getPlanProviderFeeSchedule]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getPlanProviderFeeSchedule]
	(@insurancePlanUid uniqueidentifier, 
	@providerUid uniqueidentifier)
returns uniqueidentifier as
begin
	/*	Returns the fee schedule (carrier schedule, plan schedule, or provider schedule) 
		indicated for the given insurance plan and provider.

		Equivalent to the code in the biz object FeeSchedule.cs method GetPlanProviderFeeSchedule.
	*/
	declare @FeeScheduleUid uniqueidentifier 

	-- Use Carrier Fee Schedule
	select @FeeScheduleUid = ic.FeeScheduleUid 
	from InsurancePlan ip, InsuranceCarrier ic 
	where ip.InsuranceCarrierUid = ic.CorporationUid 
		and ip.UseCarrierFeeSchedule = 1 
		and ic.UseProviderFeeSchedule = 0 

	if (@@rowcount > 0)
		return @FeeScheduleUid

	-- Use Plan Fee Schedule
	select @FeeScheduleUid = ip.FeeScheduleUid 
	from InsurancePlan ip, InsuranceCarrier ic 
	where ip.InsuranceCarrierUid = ic.CorporationUid 
		and ip.UseCarrierFeeSchedule = 0 
		and ip.UseProviderFeeSchedule = 0 

	if (@@rowcount > 0)
		return @FeeScheduleUid

	-- Use Provider Fee Schedule
	select @FeeScheduleUid = FeeScheduleUid from Provider where PersonUid = @providerUid
	return @FeeScheduleUid
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getClaimFormatUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_AR_getClaimFormatUid] (@ClaimPaper bit, 
												 @PlanUseCarrierElectronicClaimFormat bit, @PlanUseCarrierPaperClaimFormat bit, 
												 @PlanElectronicClaimFormatUid uniqueidentifier, @CarrierElectronicClaimFormatUid uniqueidentifier, 
												 @PlanPaperClaimFormatUid uniqueidentifier, @CarrierPaperClaimFormatUid uniqueidentifier,
												 @PlanUseCarrierPaperClaimDefaultOption bit = 1, @PlanPaperClaimDefaultOptionUid uniqueidentifier = null, @CarrierPaperClaimDefaultOptionUid uniqueidentifier = null, 
												 @insuranceOrder int)
RETURNS uniqueidentifier AS
BEGIN
	declare @ElectronicClaimFormatUid uniqueidentifier, @PaperClaimFormatUid uniqueidentifier, @ClaimFormatUid uniqueidentifier, @PaperClaimDefaultOptionUid uniqueidentifier

	-- ElectronicClaimFormatUid
	if (@PlanUseCarrierElectronicClaimFormat = 1)
		set @ElectronicClaimFormatUid = @CarrierElectronicClaimFormatUid
	else
		set @ElectronicClaimFormatUid = @PlanElectronicClaimFormatUid

	-- PaperClaimformatUid
	if (@PlanUseCarrierPaperClaimFormat = 1)
		set @PaperClaimFormatUid = @CarrierPaperClaimFormatUid
	else
		set @PaperClaimFormatUid = @PlanPaperClaimFormatUid

	-- PaperClaimDefaultOptionUid
	if (@PlanUseCarrierPaperClaimDefaultOption = 1)
		SET @PaperClaimDefaultOptionUid = @CarrierPaperClaimDefaultOptionUid
	else
		SET @PaperClaimDefaultOptionUid = @PlanPaperClaimDefaultOptionUid
	if (@PaperClaimDefaultOptionUid IS NULL)
		SET @PaperClaimDefaultOptionUid = ''5B36F9C3-B1CF-4E80-8541-11397058B723''		-- if not set default is None ( Claims default to electronic )
	
	--
	-- PaperClaimDefaultOption ( from ListMisc.ListType == ''PaperClaimOptions'' )
	--		5B36F9C3-B1CF-4E80-8541-11397058B723	None (Claims default to electronic)
	-- 		9CB84C44-19F5-4F32-809C-3350BBE99ACA	Secondary (Non-primary claims will print)
	-- 		09AA94E4-E72B-499E-BF6E-E5FE9E05D8B8	All (All claims will print)
		
	-- Assume electronic unless told to go to paper
	if ( @ClaimPaper = 1 )		-- claim paper set specifically for superbill
		SET @ClaimFormatUid = @PaperClaimFormatUid
	else
	if ( @PaperClaimDefaultOptionUid = ''09AA94E4-E72B-499E-BF6E-E5FE9E05D8B8'' )		-- All ( All claims will print )
		SET @ClaimFormatUid = @PaperClaimFormatUid
	else
	if ( @PaperClaimDefaultOptionUid = ''5B36F9C3-B1CF-4E80-8541-11397058B723'' )  	-- None ( Claims default to Electronic )
		SET @ClaimFormatUid = @ElectronicClaimFormatUid
	else
	if ( @PaperClaimDefaultOptionUid = ''9CB84C44-19F5-4F32-809C-3350BBE99ACA'' AND	-- Secondary ( Non-primary claims will print )
		 @insuranceOrder != 1 )														-- Current Insurance is Non-primary
		SET @ClaimFormatUid = @PaperClaimFormatUid
	else
		SET @ClaimFormatUid = @ElectronicClaimFormatUid

	return @ClaimFormatUid
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getSuperbillFeeSchedulePeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getSuperbillFeeSchedulePeriod]
	(@superbillUid uniqueidentifier) 
returns uniqueidentifier as
begin
	/*	Returns the fee schedule in force for the given superbill.

		Equivalent to the code in the biz object Superbille.cs property FeeSchedulePeriod.
	*/
	declare @InsurancePlanUid uniqueidentifier, @ProviderUid uniqueidentifier, @SBDate datetime 
	declare @FeeScheduleUid uniqueidentifier, @FeeSchedulePeriodUid uniqueidentifier 

	select @InsurancePlanUid = InsurancePlanUid, 
		@ProviderUid = ClaimingProviderUid, 
		@SBDate = ServiceDateEnd 
	from ViewSuperbillPayer 
	where SuperbillUid = @superbillUid and InsuranceOrder = 1

	if (@@rowcount = 0)
		return null

	set @FeeScheduleUid = dbo.ARFN_getPlanProviderFeeSchedule(@InsurancePlanUid, @ProviderUid) 

	if (@FeeScheduleUid is null)
		return null

	return dbo.ARFN_getFeeSchedulePeriod(@FeeScheduleUid, @SBDate)
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getSuperbillProcedureUnitFee]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ARFN_getSuperbillProcedureUnitFee]
	(@superbillUid uniqueidentifier, 
	@procedureUid uniqueidentifier) 
returns money as 

begin
	/*	Returns the unit fee for the given superbill and procedure.

		Equivalent to the code in the biz object SuperbillProcedure.cs property SetProcedureCharge.
	*/
	declare @FeeSchedulePeriodUid uniqueidentifier 

	set @FeeSchedulePeriodUid = dbo.ARFN_getSuperbillFeeSchedulePeriod(@superbillUid)
	return dbo.ARFN_getFeeScheduleFee(@FeeSchedulePeriodUid, @procedureUid)
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsLabProcedure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsLabProcedure]
(
	@procedureUid UNIQUEIDENTIFIER
)
RETURNS BIT
AS
BEGIN

	DECLARE @isLabProcedure BIT
	SELECT @isLabProcedure = 0

	IF EXISTS(SELECT 1 
			FROM ListProcedure
			WHERE ProcedureUid = @procedureUid
				AND ProcedureCodeTypeUid = ''00000000-0000-0000-0000-000000000001'' -- CPT Code
				AND LEN(Code)=5 AND SUBSTRING(Code,1,1)=''8'')
		SELECT @isLabProcedure = 1

	RETURN @isLabProcedure
	
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountPeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetAccountPeriod] (@accountuid uniqueidentifier, @date DATE) RETURNS UNIQUEIDENTIFIER AS
	BEGIN
	
		DECLARE	@accountPeriodUid uniqueidentifier
	
		SELECT TOP 1	@accountPeriodUid = ap.AccountPeriodUid
		FROM		AccountPeriod ap
		WHERE		ap.AccountUid = @accountUid AND
					(ap.EffectiveDate <= @date OR ap.EffectiveDate IS NULL) AND
					(ap.ExpirationDate >= @date OR ap.ExpirationDate IS NULL)
		
	RETURN @accountPeriodUid
	END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_SuperbillProcedure_InitialPatientLiabilityTrue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_SuperbillProcedure_InitialPatientLiabilityTrue]
(
	@superbillProcedureUid UNIQUEIDENTIFIER
)
RETURNS MONEY 
AS
BEGIN

	DECLARE @totalCharge MONEY -- same initially but needed at end to make certain patient portion does not exceed total
	DECLARE @patientLiability MONEY

	-- default case - patient owes it all
	SELECT @patientLiability = ISNULL(SBP.TotalCharge, 0), @totalCharge = ISNULL(SBP.TotalCharge, 0)
		FROM dbo.SuperbillProcedure SBP 
		WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid
		
	-- Patient typically gets no liability if insured authorizes assignment and practice accepts assignment from plan, etc.
	IF EXISTS(SELECT SBP.SuperbillProcedureUid
				FROM dbo.SuperbillProcedure SBP 
				INNER JOIN dbo.Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
				INNER JOIN dbo.Account A ON SB.AccountUid = A.AccountUid
				INNER JOIN dbo.AccountPeriod AP ON A.AccountUid = AP.AccountUid
				INNER JOIN dbo.AccountInsurance AI ON AP.AccountPeriodUid = AI.AccountPeriodUid
				INNER JOIN dbo.PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
				INNER JOIN dbo.InsurancePlan IP ON PIP.InsurancePlanUid = IP.InsurancePlanUid
				INNER JOIN dbo.InsuranceCarrier IC ON IP.InsuranceCarrierUid = IC.CorporationUid
				INNER JOIN dbo.ListProcedure LP ON SBP.ProcedureUid = LP.ProcedureUid
				WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid 
					AND AP.AccountPeriodUid = dbo.GetAccountPeriod(SB.AccountUid, ISNULL(SB.ServiceDateEnd, GetDate()))
					AND AI.DisplayOrder = 1 -- primary
					AND  SBP.DontClaim = 0 -- NOT SB.CurrentPrimaryAccountInsurance IS NULL
					AND ((SB.UsePersonInsuranceAuthorizeAssignment=1 AND PIP.AuthorizeAssignment=1) 
						OR (SB.UsePersonInsuranceAuthorizeAssignment=0 AND SB.AuthorizeAssignment=1))
					AND ((SB.UsePrimaryPayerAcceptAssignment=1 AND IC.AcceptAssignment=1)
						OR (SB.UsePrimaryPayerAcceptAssignment=1 AND IC.AcceptAssignmentLabOnly=1 AND dbo.IsLabProcedure(LP.ProcedureUid)=1)
						OR (SB.UsePrimaryPayerAcceptAssignment=0 AND SB.AcceptAssignment=1)
						OR (SB.UsePrimaryPayerAcceptAssignment=0 AND SB.AcceptAssignmentLabOnly=1 AND dbo.IsLabProcedure(LP.ProcedureUid)=1)))
		SELECT @patientLiability = 0
		
        IF @patientLiability = 0 -- If insurance seems to owe it all, check for any patient liability 
        BEGIN
        
			DECLARE @copay MONEY 
			DECLARE @insurancePercent SMALLINT
			DECLARE @procedureAllowed MONEY 
			DECLARE @units DECIMAL(20,1)
			DECLARE @multiplyUnits BIT
			DECLARE @coinsurance MONEY 
			
			SELECT @copay = COALESCE(FixedCopayAmount, 0), @insurancePercent = InsurancePercent, @procedureAllowed = ProcedureAllowed, 
				@units = ISNULL(Units, 1), @multiplyUnits = MultiplyUnits
				FROM dbo.SuperbillProcedure 
				WHERE SuperbillProcedureUid = @superbillProcedureUid -- pull seperate to be able to charge for sep in future
				
			IF @multiplyUnits = 0 AND @units<>1
				SELECT @units = 1
			SELECT @coinsurance = ROUND(ISNULL(@procedureAllowed, 0) * ISNULL(100-@insurancePercent, 0)/100, 2) * @units --default coinsurance amount
				-- ATTN ATTN ATTN - This is how impl in code, however, should not use the potentially LARGER Allowed value, right??  
			IF EXISTS(SELECT IC.AcceptAssignment 
					FROM dbo.SuperbillProcedure SBP 
					INNER JOIN dbo.Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
					INNER JOIN dbo.Account A ON SB.AccountUid = A.AccountUid
					INNER JOIN dbo.AccountPeriod AP ON A.AccountUid = AP.AccountUid
					INNER JOIN dbo.AccountInsurance AI ON AP.AccountPeriodUid = AI.AccountPeriodUid
					INNER JOIN dbo.PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
					INNER JOIN dbo.InsurancePlan IP ON PIP.InsurancePlanUid = IP.InsurancePlanUid
					INNER JOIN dbo.InsuranceCarrier IC ON IP.InsuranceCarrierUid = IC.CorporationUid
					WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid 
						AND AP.AccountPeriodUid = dbo.GetAccountPeriod(SB.AccountUid, ISNULL(SB.ServiceDateEnd, GetDate()))
						AND AI.DisplayOrder = 2 -- secondary
						AND IC.AcceptAssignment = 1)
				SELECT @coinsurance = 0

            SELECT @patientLiability = @copay + @coinsurance -- apply together - future if both are nonn-zero, will bill as sep charges potentially
        END

	IF (@totalCharge < @patientLiability) -- make sure does not exceed total
		SELECT @patientLiability = @totalCharge
		
	RETURN @patientLiability
	
/* Test

SELECT dbo.ARFN_SuperbillProcedure_InitialPatientLiabilityTrue(''1F6FA2D5-20D6-4D17-B094-0539FE20CFC2'')

*/

END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesAcuteLevelOfServiceCodes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list acute level of service CPT codes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesAcuteLevelOfServiceCodes]()
RETURNS 
@AcuteEMCodes TABLE
(
	Code varchar(255)
)

AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load acute CPT level service E/M codes
	SET @tempList = 
	''99221, 99222, 99223, 99231, 99232, 99233, 99238, 99239, 99251, 99252, 99253, 99254, 99255, 99291, '' + -- encounter acute inpt
	''99281, 99282, 99283, 99284, 99285'' -- encounter ED
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list of ICD9 code for diabetes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesICD9]()
RETURNS 
@DiabetesICD9 table
(
	ICD9Code varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load all ICD9 codes for diabetes
	SET @tempList = 
	''250, 250.0, 250.00, 250.01, 250.02, 250.03, 250.10, 250.11, 250.12, 250.13, 250.20, 250.21, 250.22, '' +
	''250.23, 250.30, 250.31, 250.32, 250.33, 250.4, 250.40, 250.41, 250.42, 250.43, 250.50, 250.51, 250.52, '' +
	''250.53, 250.60, 250.61, 250.62, 250.63, 250.7, 250.70, 250.71, 250.72, 250.73, 250.8, 250.80, 250.81, '' +
	''250.82, 250.83, 250.9, 250.90, 250.91, 250.92, 250.93, 357.2, 362.0, 362.01, 362.02, 362.03, 362.04, '' +
	''362.05, 362.06, 362.07, 366.41, 648.0, 648.00, 648.01, 648.02, 648.03, 648.04''
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @DiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @DiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(@tempList))))		
			SET @tempList = ''''
		END
	END
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesLevelOfServiceCodes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list non-acute level of service CPT codes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesLevelOfServiceCodes]()
RETURNS 
@AcuteEMCodes TABLE
(
	Code varchar(255)
)

AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load non-acute CPT level service E/M codes
	SET @tempList = 
	''99304, 99305, 99306, 99307, 99308, 99309, 99310, 99315, 99316,'' +
		'' 99318, 99324, 99325, 99326, 99327, 99328, 99334, 99335, 99336, 99337, '' + -- encounter non-acute inpatient
	''99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, '' +
		''99215, 99217, 99218, 99219, 99220, 99241, 99242, 99243, 99244, '' +
		''99245, 99341, 99342, 99343, 99344, 99345, 99347, 99348, 99349, '' +
		''99350, 99384, 99385, 99386, 99387, 99394, 99395, 99396, 99397, '' +
		''99401, 99402, 99403, 99404, 99411, 99412, 99420, 99429, 99455, 99456, '' + -- encounter outpatient
	''92002, 92003, 92004, 92005, 92006, 92007, 92008, 92009, 92010, 92011, 92012, 92013, 92014'' -- encounter outpatient - opthamological services
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesRxNorm]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list of RxNormCodes for diabetes medications.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesRxNorm]()
RETURNS 
@RxNorm table
(
	RxNormCode varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)
	
	SET @tempList = 
	''199149, 199150, 200132, 205329, 205330, 205331, 401938, '' + -- Alph-glucosidas inhibitors
	''200256, 200257, 200258, 311919, 314142, 389139, 861035, 861039, 861042, 861044, 861787, 861790, '' + -- Amylin analogs
	''744863 , 847910, 847915, '' + -- Antidiabetic agents
		''602544, 602549, 602550, 647237, 647239, 706895, 706896, 861731, 861736, 861740, 861743, 861748, '' +
	''861753, 861760, 861763, 861769, 861783, 861787, 861790, 861795, 861806, 861816, 861819, 861822, '' + -- Antidiabetic-combinations
		''665033, 665038, 665042, 860975, 860978, 860981, 860984, 860996, 860999, 861004, 861007, '' +
		''861010, 861021, 861025, 861731, 861736, 861740, 861743, 861748, 861753, 861760, 861763, '' +
	''861769, 861783, 861787, 861790, 861795, 861806, 861816, 861819, 861822, '' + -- Biguanides
	''205314, 237527, 242120, 242916, 242917, 259111, 260265, 283394, 311040, 311041, '' +
	''311053, 311054, 311055, 311056, 311057, 311058, 311059, 311060, 311061, 314038, '' +
	''317800, 351297, 358349, 484322, 485210, 544614, 763002, 763007, 763013, 763014, '' +
	''833159, 847191, 847207, 847211, 847230, 847239, 847252, 847259, 847263, 847416, '' + -- Insulin
	''105374, 153842, 197306, 197307, 197495, 197496, 197737, 198291, 198292, 198293, '' +
	''198294, 199245, 199246, 199247, 199825, 199984, 199985, 200065, 252960, 310488, '' +
	''310489, 310490, 310534, 310536, 310537, 310539, 312440, 312441, 312859, 312860, '' +
	''312861, 313418, 313419, 314000, 314006, 315107, 315239, 317573, 379804, 389137, '' +
	''602544, 602549, 602550, 647237, 647239, 706895, 706896, 757710, 757712, 844809, '' +
	''844824, 844827, 861731, 861736, 861740, 861743, '' +
	''861748, 861753, 861760, 861763, 861783, 861795, 861806, 861816, 861822, '' + -- Sulfonylureas
	''312440, 312441, 312859, 312860, 312861, 317573'' -- Thiazolidinediones

	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @RxNorm (RxNormCode) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @RxNorm (RxNormCode) VALUES ((RTRIM(LTRIM(@tempList))))		
			SET @tempList = ''''
		END
	END	
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_DiabetesDenominator]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- ===================================================================
-- Author:		chm
-- Create date: 03/02/2011
-- Description:	This function returns the deominator results for the
--				following ARRA rules: 0055, 0056, 0059, 0061, 0062, 
--				0064, 0575
-- ===================================================================
CREATE FUNCTION [dbo].[ARRA_DiabetesDenominator] (
	@PatientUid UNIQUEIDENTIFIER
	,@2YearsAgo DATETIME
	)
RETURNS INT
AS
BEGIN
	-- Change History :
	--
	-- Date			Edited By	Change
	-- ========================================
	-- 2013.Oct.14	JRB		Update SP to not use old diagnosis table
	--
	DECLARE @tempCnt INT
	DECLARE @metDenominator INT
	DECLARE @Visit TABLE (VisitUid UNIQUEIDENTIFIER)

	SET @metDenominator = 0

	-- is the patient currently taking any medications for diabetes
	SELECT @tempCnt = COUNT(*)
	FROM RelPatientMedication rel
	INNER JOIN MedicationSIG sig ON rel.MedicationSIGUid = sig.MedicationSIGUid
		AND rel.PatientUid = @PatientUid
		AND sig.DiscontinueReasonUid IS NULL
		AND sig.OverallStartDate >= @2YearsAgo
	CROSS APPLY (
		SELECT TOP 1 rev.*
		FROM dbo.NDD_SearchRxNorm rev
		INNER JOIN dbo.ARRR_DiabetesRxNorm() norm ON norm.RxNormCode = rev.RxNormCode
		WHERE rev.IsDelete = 0
		  AND (rev.medid = sig.FDB_MEDID OR rev.mnid = sig.FDB_MNID)) rxn

	IF (@tempCnt = 0)
	BEGIN -- no diabetes medications found
		-- does the patient have a history of diabetes
		SET @tempCnt = 0

		SELECT @tempCnt = COUNT(*)
		FROM PatientDXHistory pdx
		INNER JOIN ListProblemStatus lps ON pdx.ProblemStatusUid = lps.ProblemStatusUid
			AND lps.ActiveStatus = 1
			AND pdx.IsDelete = 0
		--INNER JOIN ListOldDiagnosis ld ON pdx.DiagnosisUid = ld.DiagnosisUid
		--INNER JOIN dbo.ARRR_DiabetesICD9() dia ON ld.DiagnosisCode9 = dia.ICD9Code
		INNER JOIN dbo.ARRR_DiabetesICD9() dia ON pdx.Code = dia.ICD9Code
		WHERE pdx.PatientUid = @PatientUid

		IF (@tempCnt = 0)
		BEGIN
			-- if not found in patient history; see if there is an active diagnosis for diabetes and 
			-- at less one acute encounters or at less two non-acute encounters
			DELETE @Visit

			-- get all visit
			INSERT INTO @Visit
			SELECT VisitUid
			FROM Visit
			WHERE PatientUid = @PatientUid
				AND (
					VisitTypeUid IS NULL
					OR VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
					) -- Strike Out

			SET @tempCnt = 0

			SELECT @tempCnt = COUNT(*)
			FROM VisitDiagnosis vd
			--INNER JOIN LisOldtDiagnosis ld ON vd.DiagnosisUid = ld.DiagnosisUid
			--	AND vd.IsDelete = 0
			--INNER JOIN dbo.ARRR_DiabetesICD9() dia ON ld.DiagnosisCode9 = dia.ICD9Code
			INNER JOIN dbo.ARRR_DiabetesICD9() dia ON vd.Code = dia.ICD9Code
			WHERE vd.IsDelete = 0
				AND vd.VisitUid IN (
					SELECT VisitUid
					FROM @Visit
					)
		END

		IF (@tempCnt > 0)
		BEGIN
			SET @tempCnt = 0

			-- test is there at less two an non-acute visit; test first most likely to found something
			SELECT @tempCnt = COUNT(*)
			FROM Visit v
			INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
				AND v.PatientUid = @PatientUid
				AND (
					v.VisitTypeUid IS NULL
					OR v.VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
					) -- Strike Out
				AND vp.IsDelete = 0
			INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
			INNER JOIN dbo.ARRR_DiabetesLevelOfServiceCodes() non ON lp.Code = non.Code

			IF (@tempCnt < 2)
			BEGIN
				SET @tempCnt = 0

				-- test is there at less one an acute visit
				SELECT @tempCnt = COUNT(*)
				FROM Visit v
				INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
					AND v.PatientUid = @PatientUid
					AND (
						v.VisitTypeUid IS NULL
						OR v.VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
						) -- Strike Out
					AND vp.IsDelete = 0
				INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
				INNER JOIN dbo.ARRR_DiabetesAcuteLevelOfServiceCodes() acute ON lp.Code = acute.Code
			END
		END
	END -- no diabetes medications found

	IF (@tempCnt > 0)
	BEGIN
		SET @metDenominator = 1
	END

	RETURN @metDenominator
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_ExcludeDiabetesICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list of all excluded ICD9 codes for diabetes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_ExcludeDiabetesICD9]()
RETURNS 
@ExcludeDiabetesICD9 table
(
	ICD9Code varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load exclude ICD9 codes for diabetes
	SET @tempList = 
	''648.0, 648.00, 648.01, 648.02, 648.03, 648.04, '' + -- gestational diabetes
	''256.4, '' + -- polycystic ovaries
	''249, 249.0, 249.00, 249.01, 249.1, 249.10, 249.11, 249.2, 249.20, 249.21, 249.3, '' +
	''249.30, 249.31, 249.4, 249.40, 249.41, 249.5, 249.50, 249.51, 249.6, 249.60, 249.61, '' +
	''249.7, 249.70, 249.71, 249.8, 249.80, 249.81, 249.9, 249.90, 249.91, 251.8, 962.0'' -- steroid induced diabetes

	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @ExcludeDiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @ExcludeDiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end	
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_DiabetesExclusions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- ===================================================================
-- Author:		chm
-- Create date: 03/12/2011
-- Description:	This function returns the exclusions results for the
--				following ARRA rules: 0059, 0061
-- ===================================================================
CREATE FUNCTION [dbo].[ARRA_DiabetesExclusions] 
(
	@PatientUid uniqueidentifier
)
RETURNS int
AS
BEGIN
	DECLARE @tempCnt int
	DECLARE @metExclusion int
		
	DECLARE @Visit TABLE
	(
		VisitUid uniqueidentifier
	)
	SET @metExclusion = 0
		
	-- does the patient have any excluded diabetes icd9 codes
	SET @tempCnt = 0
	SELECT @tempCnt = COUNT(*) FROM PatientDXHistory pdx 
		INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid 
			AND lps.ActiveStatus = 1 AND pdx.IsDelete = 0
		INNER JOIN dbo.ARRR_ExcludeDiabetesICD9() dia ON pdx.Code = dia.ICD9Code
	WHERE pdx.PatientUid = @PatientUid

	IF (@tempCnt = 0)
	BEGIN
		-- if not found in patient history; see if there is an active diagnosis for diabetes
		DELETE @Visit
		-- get all visit
		INSERT INTO @Visit
		SELECT VisitUid FROM Visit 
			WHERE PatientUid = @PatientUid 
					AND (VisitTypeUid is null OR VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96'') -- Strike Out
		
		SELECT @tempCnt = COUNT(*) FROM VisitDiagnosis vd
		INNER JOIN dbo.ARRR_ExcludeDiabetesICD9() dia ON vd.Code = dia.ICD9Code
		WHERE vd.IsDelete = 0 AND vd.VisitUid IN (SELECT VisitUid FROM @Visit)
	END
	
	IF (@tempCnt > 0)
	BEGIN
		SET @metExclusion = 1
	END
		
	RETURN @metExclusion
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_HypertensionICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =================================================================
-- Author:		CHM
-- Create date: 03/03/2011
-- Description:	Returns a list of ICD9 code for Hypertension.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_HypertensionICD9]()
RETURNS 
@HypertensionICD9 table
(
	ICD9Code varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load all ICD9 codes for hypertension
	SET @tempList = ''401, 401.0, 401.1, 401.9''
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @HypertensionICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @HypertensionICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(@tempList))))		
			SET @tempList = ''''
		END
	END
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_OutpatientLevelOfServiceCodes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/03/2011
-- Description:	Returns a list outpatient level of service CPT codes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_OutpatientLevelOfServiceCodes]()
RETURNS 
@OutpatientEMCodes TABLE
(
	Code varchar(255)
)

AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load outpatient CPT level service E/M codes
	SET @tempList = ''99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, 99215, '' +
		''99217, 99218, 99219, 99220, 99241, 99242, 99243, 99244, 99245, 99341, 99342, 99343, '' +
		''99344, 99345, 99347, 99348, 99349, 99350, 99384, 99385, 99386, 99387, 99394, 99395, '' +
		''99396, 99397, 99401, 99402, 99403, 99404, 99411, 99412, 99420, 99429, 99455, 99456''
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @OutpatientEMCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @OutpatientEMCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AttachmentHandlerFileNameWildcards]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[AttachmentHandlerFileNameWildcards]()

RETURNS @AttachmentHandlersFNW TABLE (	AttachmentHandlerUid UNIQUEIDENTIFIER,
										FileNameWildcard VARCHAR(255),
										CompressionUid UNIQUEIDENTIFIER NULL,
										Priority SMALLINT							
									 )
AS
BEGIN
	DECLARE @attachmentHandlerUid UNIQUEIDENTIFIER
	DECLARE @fileNameWildcard VARCHAR(255)
	DECLARE @compressionUid UNIQUEIDENTIFIER
	DECLARE @priority SMALLINT

	DECLARE	cur CURSOR FORWARD_ONLY FOR SELECT AttachmentHandlerUid, FileNameWildcard, CompressionUid, Priority FROM ListAttachmentHandler ORDER BY Priority
	OPEN cur
	FETCH NEXT FROM cur INTO @attachmentHandlerUid, @fileNameWildcard, @compressionUid, @priority
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT	@AttachmentHandlersFNW
		SELECT	@attachmentHandlerUid, Element, @compressionUid, @priority
		FROM	dbo.Split(@fileNameWildcard, '';'')

		FETCH NEXT FROM cur INTO @attachmentHandlerUid, @fileNameWildcard, @compressionUid, @priority
	END
	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsPortalOnlyCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsPortalOnlyCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd with(nolock) 
  LEFT JOIN BatchProcessDetail bpd with(nolock) ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL AND sbd.CompletionStatus = 2

  return @Completed
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsPrintedCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsPrintedCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd with(nolock) 
  LEFT JOIN BatchProcessDetail bpd with(nolock) ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL AND sbd.CompletionStatus = 1

  return @Completed
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsSubmittedCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[BatchProcessStatementsSubmittedCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd with(nolock) 
  LEFT JOIN BatchProcessDetail bpd with(nolock) ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL AND (sbd.CompletionStatus = 3 or sbd.CompletionStatus = 4 or sbd.CompletionStatus = 6)

  return @Completed
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsWithAttachmentCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsWithAttachmentCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd with(nolock)
  LEFT JOIN BatchProcessDetail bpd with(nolock) ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL

  return @Completed
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BigIntToGUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BigIntToGUID](@PK_ID bigint)
RETURNS uniqueidentifier AS

BEGIN

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier
  declare @Neg bit

  if @PK_ID = 0
   return ''00000000-0000-0000-0000-00000000FFFF''

  if @PK_ID is not null
    begin
      if (@PK_ID < 0)
        begin
         set @Neg = 1
          set @PK_ID = -1 * @PK_ID
        end
      set @Wrk = convert (varchar(200), @PK_ID)
      while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

      if (@Neg = 1 )
             set @Wrk = ''FFFFFFFF'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4)
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      else
             set @Wrk = SUBSTRING(@Wrk, 1, 8) + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4)
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      set @Wrk = ''{'' + @Wrk + ''}''
      set @NewGUID = @Wrk
    end

  return (@NewGUID)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CanAccessFacilityPatient]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[CanAccessFacilityPatient] (@facilityPortalUserUid UNIQUEIDENTIFIER, @patientUid UNIQUEIDENTIFIER, @asOfDate DATE = null) 
  RETURNS BIT
  AS 
  BEGIN
	RETURN CASE WHEN EXISTS (
		SELECT * 
		FROM Patient
			OUTER APPLY dbo.GetFacilityActiveServiceSite(Patient.ServiceSiteUid, @facilityPortalUserUid, 0) ActiveServiceSite
			OUTER APPLY dbo.GetFacilityActivePatientPrograms(Patient.PersonUid, @facilityPortalUserUid, 0, @asOfDate) ActivePatientProgram

		WHERE Patient.PersonUid = @patientUid
			AND (ActiveServiceSite.ServiceSiteUid IS NOT NULL OR ActivePatientProgram.PatientProgramUid IS NOT NULL)
			AND Patient.Inactive = 0
				
	)
	THEN CAST(1 AS BIT)
	ELSE CAST(0 AS BIT)
	END
  END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CanAccessFacilityMessage]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE   FUNCTION [dbo].[CanAccessFacilityMessage] (@facilityPortalUserUid UNIQUEIDENTIFIER, @messsageUid UNIQUEIDENTIFIER) 
  RETURNS BIT
  AS 
  BEGIN
	DECLARE @patientUid UNIQUEIDENTIFIER
	DECLARE @asOfDate DATE
	SELECT 
		@patientUid = m.PersonUid,
		@asOfDate = m.CreatedDate
	FROM Message m
	WHERE m.MessageUid = @messsageUid

	RETURN dbo.CanAccessFacilityPatient(@facilityPortalUserUid, @patientUid, @asOfDate)
  END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CanDeleteVisitAfterDeleteObservationOrder]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[CanDeleteVisitAfterDeleteObservationOrder](@ObservationOrderUid UNIQUEIDENTIFIER, @VisitUid UNIQUEIDENTIFIER = ''00000000-0000-0000-0000-000000000000'', @ForFNCDelete bit = 0) RETURNS BIT AS
BEGIN
   DECLARE 
      @VisitProcedureUid UNIQUEIDENTIFIER

	IF (@ForFNCDelete = 0)
	BEGIN
		SELECT 
			@VisitUid          = VisitUid,
			@VisitProcedureUid = VisitProcedureUid
		FROM ObservationOrder 
		WHERE ObservationOrderUid = @ObservationOrderUid
	END
   
   IF (@VisitProcedureUid IS NULL) SELECT @VisitProcedureUid = ''00000000-0000-0000-0000-000000000000''

   IF (@VisitUid IS NULL) RETURN 0
   IF EXISTS(SELECT * FROM Visit tab WHERE tab.VisitUid = @VisitUid AND tab.IsCompleted = 1) RETURN 0

   IF (@ForFNCDelete = 0)
   BEGIN
		IF NOT EXISTS(SELECT * FROM Visit tab WHERE tab.VisitUid = @VisitUid AND tab.VisitTypeUid = ''6A18A657-B912-4C12-828E-A3DF8571D205'') RETURN 0
		
		IF EXISTS(SELECT * FROM RelAttachmentGroup tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM ObservationOrder tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM ObservationOrder tab WHERE tab.ResultingVisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM ObservationValue tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitAssessmentForm tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * 
             FROM Message tab 
             LEFT JOIN MessageHL7 mhl ON mhl.MessageUid = tab.MessageUid AND mhl.ObservationOrderUid = @ObservationOrderUid
             LEFT JOIN  RelMessageHL7ObservationOrder mrl ON mrl.MessageUid = tab.MessageUid AND mrl.ObservationOrderUid = @ObservationOrderUid
             WHERE tab.VisitUid = @VisitUid 
               AND mhl.MessageUid IS NULL 
               AND mrl.MessageUid IS NULL) RETURN 0
		IF EXISTS(SELECT * FROM Superbill tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitCC tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitComplexity tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitComment tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitCoSign tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitData tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitEduForm tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitPlan tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM PQRIHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   END
   ELSE BEGIN -- for FNC delete
		IF EXISTS(SELECT * FROM ObservationOrder oo 
						INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid 
						INNER JOIN ListObservationItem loi ON ov.ObservationItemUid = loi.ObservationItemUid
							AND loi.Name <> ''BMI''
					WHERE loi.IsVitals <> 1 and oo.VisitUid = @visitUid) RETURN 0
   END

   IF EXISTS(SELECT * FROM ClinicalDecisionSupportResults tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM eRxOutbound tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM FaxQueue tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM ImmunizationHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MedicationSIG tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageAN tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageAuthorization tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageERxRefillRequest tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageInstantMessage tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessagePatientLabOrder tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageRxRefill tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageVisitBilling tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientCareManagementLog tab WHERE tab.LoggedFromVisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientFamilyHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientProblemDiagnosisHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientProcedureHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientRecall tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientRecall tab WHERE tab.OriginVisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientReferral tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RecordDisclosureAudit tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RelPatientMedication tab WHERE tab.EnteredFromVisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RelScheduledEduForm tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RelVisitMedication tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM ScheduledPQRIUpdate tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitAccess tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitCommentExtension tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * 
             FROM VisitDiagnosis tab 
			 LEFT JOIN VisitProcedureDiagnosis org ON org.VisitDiagnosisUid = tab.VisitDiagnosisUid
			 WHERE tab.VisitUid = @VisitUid
			   and (org.VisitProcedureDiagnosisUid IS NULL OR org.VisitProcedureUid != @VisitProcedureUid)) RETURN 0
   IF EXISTS(SELECT * FROM VisitGraphicNotes tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitHpi tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitWatchItem tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitOutsideProvider tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitPE tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitProcedure tab WHERE tab.VisitUid = @VisitUid AND tab.VisitProcedureUid != @VisitProcedureUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitRos tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitTranscription tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitVoiceAttachment tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   
   RETURN 1
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetAge](@birthdate DATE, @date DATE) RETURNS INT AS
BEGIN
	DECLARE @age INT
	
	SET @age = FLOOR(DATEDIFF(day, @birthdate, @date) / 365.25)
	
	RETURN @age
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CHCGetAgeLevel]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CHCGetAgeLevel](@personUid UNIQUEIDENTIFIER, @date DATE) RETURNS VARCHAR(50) AS
BEGIN
	DECLARE @birthdate DATE
	SELECT @birthdate = Birthdate FROM Person p WHERE p.PersonUid = @personUid
	DECLARE @age SMALLINT
	SET @age = dbo.GetAge(@birthdate, CASE WHEN @date IS NULL THEN GETDATE() ELSE @date END)
	
	IF @age < 1 
		RETURN ''0 - 1''
	IF @age < 4 
		RETURN ''1 - 4''
	IF @age < 7 
		RETURN ''4 - 7''
	IF @age < 12 
		RETURN ''8 - 12''
	IF @age < 17 
		RETURN ''13 - 17''
	IF @age < 26 
		RETURN ''18 - 26''
	IF @age < 39 
		RETURN ''27 - 39''
	IF @age < 49 
		RETURN ''40 - 49''
	IF @age < 64 
		RETURN ''50 - 64''
	RETURN ''65+''	
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CHCGetInsuranceType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CHCGetInsuranceType](@SuperbillUid UNIQUEIDENTIFIER) 
  RETURNS UNIQUEIDENTIFIER 
AS
BEGIN
	DECLARE @retUid UNIQUEIDENTIFIER
	set @retUid = ''10101010-0000-7777-0000-000000000001'' -- Primary Insurance Carrier
	return @retUid ;
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CHCGetPovertyLevel]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CHCGetPovertyLevel](@accountUid UNIQUEIDENTIFIER, @date DATE) RETURNS VARCHAR(50) AS
BEGIN
	DECLARE @unitedStates AS UNIQUEIDENTIFIER, 
			@alaska AS UNIQUEIDENTIFIER, 
			@hawaii AS UNIQUEIDENTIFIER, 
			@region  AS UNIQUEIDENTIFIER 
	DECLARE @state VARCHAR(3)
	DECLARE @accountResponsiblePartyUid UNIQUEIDENTIFIER
	
	SELECT	@state = p.Address1.value(''(/Address/State)[1]'', ''varchar(100)''),
			@accountResponsiblePartyUid = a.AccountResponsiblePartyUid
	FROM	Account a INNER JOIN AccountResponsibleParty arp ON a.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
			INNER JOIN Person p ON arp.PersonUid = p.PersonUid
	WHERE	a.AccountUid = @accountUid

	SET @unitedStates = ''10101010-0000-0000-1001-000000000001''
	SET @alaska = ''10101010-0000-0000-1001-000000000002''
	SET @hawaii = ''10101010-0000-0000-1001-000000000003''
	
	IF @state = ''AK''
		SET @region = @alaska
	ELSE IF @state = ''HI''
		SET @region = @hawaii
	ELSE 
		SET @region = @unitedStates
	
	DECLARE @baseAmount MONEY
	DECLARE @incrementalAmount MONEY
	SET @baseAmount = -1.00
	
	SELECT TOP 1	@baseAmount = BaseAmount, @incrementalAmount = IncrementalAmount
	FROM			ChcListFPLSchedule
	WHERE			FPLRegionUid = @region AND
					CAST(EffectiveDate AS DATE) < @date
	ORDER BY		EffectiveDate DESC
	
	DECLARE @familySize SMALLINT
	DECLARE @annualIncome MONEY
	SELECT	@familySize = FamilySize, @annualIncome = MonthlyIncome * 12.0
	FROM	CHCAccountResponsibleParty
	WHERE	AccountResponsiblePartyUid = @accountResponsiblePartyUid
	
	IF @familySize = 0 OR @baseAmount = -1
		RETURN ''Unknown/Not Provided''
		
	DECLARE @FPL_FamSz_Amount MONEY 
	DECLARE @dPercentPoverty DECIMAL (8,2)
	DECLARE @nPercentPoverty INT
	
	IF @familySize = 1 OR @incrementalAmount = 0
		SET @FPL_FamSz_Amount = @baseAmount 
	ELSE
		SET @FPL_FamSz_Amount = @baseAmount + (@incrementalAmount * (@familySize - 1))
		
	SET @dPercentPoverty = (@annualIncome / @FPL_FamSz_Amount)  * 100
	SET @nPercentPoverty = ROUND(@dPercentPoverty, 0)
	
	IF @nPercentPoverty <= 100 
		RETURN ''100% of less''
	IF @nPercentPoverty <= 150
		RETURN ''100-150%''
	IF @nPercentPoverty <= 200
		RETURN ''150-200%''
	IF @nPercentPoverty <= 250
		RETURN ''200-250%''
	IF @nPercentPoverty <= 300
		RETURN ''250-300%''
	IF @nPercentPoverty > 300
		RETURN ''Above 300%''
	
	RETURN ''Unknown/Not Provided''
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckANDGetDateFormat]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[CheckANDGetDateFormat]
(
	@Date VARCHAR(50)
)RETURNS VARCHAR(50)
BEGIN

	IF(ISDATE(@Date)=0)
	BEGIN
		If(LTRIM(RTRIM(@Date))='''')
			SET @Date=''-2''
		ELSE
		BEGIN
			DECLARE
			@IDate			INT,
			@C				INT

			SET @IDate=0
			SET @C=0
			
			WHILE @C<LEN(@Date)
			BEGIN	
				If(Substring(@Date,@C,1)=''/'' OR Substring(@Date,@C,1)=''-'')
				BEGIN
					SET @IDATE=@IDATE+1
				END
				SET @C=@C+1
			END
			
			IF (@IDate=0)
--				SET @Date=''-1''
				SET @Date=''01/01/'' + @Date
			ELSE IF (@IDate=1)
				SET @Date=''01/'' + @Date
		END
	END
	
	RETURN @Date		
END

' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckPath]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CheckPath](@path [nvarchar](4000))
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[CheckPath]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckRecurTimeType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE function [dbo].[CheckRecurTimeType]
(
	@RecurTimeTypeUID UNIQUEIDENTIFIER,
	@dt DateTime,
	@recurValue smallint
)
Returns datetime
begin
	Declare @retDate DateTime
	Declare @str varchar(20)

	Select @str=[Name] from ListTimeType where TimeTypeuid = @RecurTimeTypeUID
	
	set @retDate=@dt

	if 	@str = ''Days'' 	
		Set @retDate = DateAdd(day,@recurValue,@dt)
	else if @str = ''Weeks'' 
	begin
		Set @recurValue = @recurValue * 7
		Set @retDate = DateAdd(day,@recurValue,@dt)
	end
	else if @str = ''Months''  
		Set @retDate = DateAdd(month,@recurValue,@dt)
	else if @str = ''Years'' 
		Set @retDate = DateAdd(year,@recurValue,@dt)

	return @retDate 

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CombineList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CombineList]
	(
		@filter varchar(max)
	)
RETURNS varchar(max)
AS
BEGIN
	declare @orderlist varchar(max)
	select @orderlist = ''''

	select @orderlist =  convert(varchar(10), displayorder) + '','' + @orderlist   from ListMisc where ListType = @filter order by DisplayOrder desc
	select @orderlist = left(@orderlist, len(@orderlist)-1)

	RETURN @orderlist
end
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComparePRMVersion]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ComparePRMVersion](@VersionA [nvarchar](32), @VersionB [nvarchar](32))
RETURNS [int] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ComparePRMVersion]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_ConvertDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Date_ConvertDate]
	(
	@date datetime
	)
RETURNS datetime
AS
	BEGIN
	RETURN cast(convert(varchar, @date, 101) AS datetime)
	END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertDateOnly]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ConvertDateOnly]
	(
	@date datetime
	)
RETURNS datetime
AS
	BEGIN
	RETURN dbo.Date_ConvertDate(@date)
	END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[convertFractionToDecimal]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[convertFractionToDecimal](@STR VARCHAR(50))
RETURNS decimal(18,2)
AS
BEGIN
        DECLARE @L VARCHAR(50) = ''''
        DECLARE @A DECIMAL(18,10) = 0
        SET @STR = LTRIM(RTRIM(@STR)); -- Remove extra spaces
        IF ISNUMERIC(@STR) > 0 SET @A = CONVERT(DECIMAL(18,10), @STR) -- Check to see if already real number
        IF CHARINDEX('' '',@STR,0) > 0
        BEGIN
            SET @L = SUBSTRING(@STR,1,CHARINDEX('' '',@STR,0) - 1 )
            SET @STR = SUBSTRING(@STR,CHARINDEX('' '',@STR,0) + 1 ,50 )
            SET @A = CONVERT(DECIMAL(18,10), @L)
        END
        IF CHARINDEX(''/'',@STR,0) > 0
        BEGIN
            SET @L = SUBSTRING(@STR,1,CHARINDEX(''/'',@STR,0) - 1 )
            SET @STR = SUBSTRING(@STR,CHARINDEX(''/'',@STR,0) + 1 ,50 )
            SET @A =  @A + ( CONVERT(DECIMAL(18,10), @L) / CONVERT(DECIMAL(18,10), @STR)  )
        END
        RETURN @A
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertLocalToUTCTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertLocalToUTCTime](@localTime [datetime])
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertLocalToUTCTime]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertStringToNumeric]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertStringToNumeric] (@Value TEXT)
RETURNS NUMERIC(12, 2)
AS
BEGIN
	DECLARE @string VARCHAR(max)

	SET @string = CONVERT(VARCHAR(MAX), @Value)

	--set @string=''abc93.3ad4''
	DECLARE @IncorrectCharLoc SMALLINT

	SET @IncorrectCharLoc = PATINDEX(''%[^0-9.-]%'', @string)

	WHILE @IncorrectCharLoc > 0
	BEGIN
		SET @string = STUFF(@string, @IncorrectCharLoc, 1, '''')
		SET @IncorrectCharLoc = PATINDEX(''%[^0-9.-]%'', @string)
	END

	SET @string = @string

	IF ISNUMERIC(LEFT(@string,30)) = 1
		AND LEN(@string) > 0
		AND @string != ''.''
		AND @string != ''-''
		AND @string != ''.-''
		AND Len(@string) <= 9
		AND @string != ''-.''
	BEGIN
		RETURN CONVERT(NUMERIC(10, 2), @string)
	END

	RETURN - 1
END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertTimeByTimezone]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertTimeByTimezone](@datetime [datetime], @timezone [nvarchar](max))
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertTimeByTimezone]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertTimeToTimezone]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertTimeToTimezone](@datetime [datetime], @timezone [nvarchar](max))
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertTimeToTimezone]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertToBytes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ConvertToBytes](@input varchar(50)) RETURNS BIGINT AS
BEGIN
	IF SUBSTRING(@input, DATALENGTH(@input) - 1, 2) = ''KB''
		RETURN convert(BIGINT, SUBSTRING(@input, 0, DATALENGTH(@input) - 2)) * 1024
	
	RETURN convert(BIGINT, SUBSTRING(@input, 0, DATALENGTH(@input) - 2)) * 1024 * 1024
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertToTimeZonePracticeSettings]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertToTimeZonePracticeSettings](@dt DATETIME) RETURNS DATETIME AS
BEGIN
	DECLARE @timezone VARCHAR(30)
	DECLARE @timeZoneAdj smallint
	DECLARE @daylightsavings bit

	SELECT @timezone = StringValue FROM ListProductParameter WHERE ParameterName = ''TimeZoneString''
	IF @timezone IS NULL
	BEGIN
		SELECT @timeZoneAdj = InTimeZoneAdj, @daylightsavings = ObserveDaylightSavings FROM PracticeSettings

		IF @timeZoneAdj = -5
			SET @timezone = ''Eastern Standard Time''
		ELSE IF @timeZoneAdj = -6
			SET @timezone = ''Central Standard Time''
		ELSE IF @timeZoneAdj = -7 AND @daylightsavings = 0
			SET @timezone = ''US Mountain Standard Time''
		ELSE IF @timeZoneAdj = -7
			SET @timezone = ''Mountain Standard Time''
		ELSE IF @timeZoneAdj = -8
			SET @timezone = ''Pacific Standard Time''
		ELSE IF @timeZoneAdj = -9
			SET @timezone = ''Alaskan Standard Time''
		ELSE IF @timeZoneAdj = -10
			SET @timezone = ''Hawaiian Standard Time''
		ELSE 
			SET @timezone = ''local''
		END

	RETURN dbo.ConvertTimeByTimezone(@dt, @timezone)
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CopyKDBOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CopyKDBOverride](@src [xml], @srcUid [uniqueidentifier], @dst [xml], @dstUid [uniqueidentifier])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[CopyKDBOverride]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CorrectVMCProviderExternalID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[CorrectVMCProviderExternalID] (@ExternalID varchar(200))  
 returns varchar(200) as
begin
	declare @returnID varchar(200)
	declare @i int

	set @returnID = @ExternalID	
	set @i = 0

	while (@i <= len(@ExternalID))
	begin
		set @i = @i + 1
 		if ((substring(@ExternalID, @i, 1) > ''9'') or (substring(@ExternalID, @i, 1) < ''0''))
		begin
			set @returnID = substring (@ExternalID, 1, @i - 1)
			break
		end
	end

	return @returnID
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_EndOfMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[Date_EndOfMonth]
	(@dtCurrent DATETIME) 
RETURNS DATETIME
AS
BEGIN
	RETURN DATEADD(DD, -1, CONVERT(DATETIME, CONVERT(VARCHAR, DATEPART(MM, DATEADD(MM, 1, @dtCurrent))) + ''/1/'' + CONVERT(VARCHAR, DATEPART(YY, DATEADD(MM, 1, @dtCurrent)))))
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_LocalToUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[Date_LocalToUTC]  
 (@inLocaleDateTime datetime,  -- the time to convert to local (should be a local datetime value)  
 @inTimeZoneAdj int,   -- the number of hours to adjust for the local timezone  
 @bObserveDaylightSavings tinyint) -- whether or not the local area observes US daylight savings time  
 returns datetime as
BEGIN

declare @outLocalDateTime datetime  
set @outLocalDateTime = dateadd(hh, -1 * @inTimeZoneAdj, @inLocaleDateTime)  
if (@bObserveDaylightSavings = 1) -- figure in daylight savings time  
BEGIN 
	declare @yearToCheck int  
	set @yearToCheck = datepart(yyyy, @outLocalDateTime)  
	declare @DSstart datetime, @DSend datetime  

	-- If 2k7 or greater...
	if ( @yearToCheck >= 2007 )
	BEGIN
	-- determine if we''re in daylight savings time (second Sunday in march through first Sunday in november)  
	   set @DSstart = convert(varchar(4), @yearToCheck) + ''-03-08 02:00:00.000''  
	   set @DSend = convert(varchar(4), @yearToCheck) + ''-11-1 02:00:00.000''  
	   -- figure out the first sunday in April  
	   while (datepart(dw, @DSstart) <> 1) -- dw is 1 for Sunday  
		set @DSstart = dateadd(dd, 1, @DSstart)  
	   -- figure out the last sunday in October  
	   while (datepart(dw, @DSend) <> 1) -- dw is 1 for Sunday  
		set @DSend = dateadd(dd, 1, @DSend)  
	END
	ELSE -- if less than 2k7
	BEGIN
		-- determine if we''re in daylight savings time (1st Sunday in April through last Sunday in October)  
		set @DSstart = convert(varchar(4), @yearToCheck) + ''-04-01 02:00:00.000''  
		set @DSend = convert(varchar(4), @yearToCheck) + ''-10-31 02:00:00.000''  
		-- figure out the first sunday in April  
		while (datepart(dw, @DSstart) <> 1) -- dw is 1 for Sunday  
			set @DSstart = dateadd(dd, 1, @DSstart)  
		-- figure out the last sunday in October  
		while (datepart(dw, @DSend) <> 1) -- dw is 1 for Sunday  
			set @DSend = dateadd(dd, -1, @DSend)  
	END

	-- If in daylight savings, adjust
	if ((@outLocalDateTime >= @DSstart) and (@outLocalDateTime < @DSend))  
		set @outLocalDateTime = dateadd(hh, -1, @outLocalDateTime)  

END -- if observe daylight savings
return @outLocalDateTime  

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_MMDDYY]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



-- the function returns date in MMDDYY format
CREATE    FUNCTION [dbo].[Date_MMDDYY]
(
	@pDate DATETIME
)
RETURNS VARCHAR(6)
AS
BEGIN

	DECLARE @retDate VARCHAR(6)	
	SET @retDate =
		CASE WHEN @pDate <> '''' THEN
			 
			CASE WHEN DATEPART(mm,@pDate) < 10 THEN 
				''0'' + CONVERT(varchar,DATEPART(mm,@pDate)) + CASE WHEN DATEPART(dd,@pDate) < 10 THEN ''0'' + CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) ELSE CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) END
			ELSE
				CONVERT(varchar,DATEPART(mm,@pDate)) +  CASE WHEN DATEPART(dd,@pDate) < 10 THEN ''0'' + CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) ELSE CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) END
			END
		ELSE
			''''
		END
	RETURN @retDate

END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getEndOfMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[getEndOfMonth]
	(@dtCurrent DATETIME) 
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_EndOfMonth(@dtCurrent)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_RelativeFiscalMonthEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[Date_RelativeFiscalMonthEnd]
(
	@dtCurrent DATETIME
)
RETURNS DATETIME
AS
BEGIN
	-- Returns the end of the fiscal month containing the given date
	DECLARE @currentPeriodEnd DATETIME 
	DECLARE @relativePeriodEnd DATETIME
	DECLARE @endOfMonthFlag SMALLINT

	SELECT @currentPeriodEnd = CurrentPeriodEnd, @endOfMonthFlag = CurrentPeriodEndOfMonth FROM PracticeSettings

	IF (@endOfMonthFlag = 1)
		SET @relativePeriodEnd = dbo.getEndOfMonth(@dtCurrent)
	ELSE
		BEGIN
			SET @relativePeriodEnd = DATEADD(MM, DATEDIFF(MM, @currentPeriodEnd, @dtCurrent), @currentPeriodEnd)
			IF (@relativePeriodEnd < @dtCurrent)
				SET @relativePeriodEnd = DATEADD(MM, 1, @relativePeriodEnd)
		END
	RETURN @relativePeriodEnd
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_RelativeFiscalYearEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[Date_RelativeFiscalYearEnd]
(
	@dtCurrent datetime
)
RETURNS DATETIME
AS
BEGIN
	-- Returns the end of the fiscal year containing the given date 

	DECLARE @currentFiscalYearEnd DATETIME
	DECLARE @fiscalYearEnd DATETIME
	SELECT @currentFiscalYearEnd = FiscalYearEnd FROM PracticeSettings
 
	SET @fiscalYearEnd = DATEADD(YY, DATEDIFF(YY, @currentFiscalYearEnd, @dtCurrent), @currentFiscalYearEnd)

	IF (@fiscalYearEnd < @dtCurrent)
		SET @fiscalYearEnd = DATEADD(YY, 1, @fiscalYearEnd)
	RETURN @fiscalYearEnd
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_SameDay]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[Date_SameDay] (@dtDate1 DATE, @dtDate2 DATE)
RETURNS int AS
BEGIN
RETURN(select (CASE WHEN @dtDate1 = @dtDate2 THEN 1 ELSE 0 END))
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_Sunday]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[Date_Sunday]
 (@dateForSunday DATETIME,
 @isAPR INT)  

RETURNS DATETIME 
 AS  

BEGIN 
	DECLARE	 @date1 	 AS	DATETIME
	DECLARE	 @year 		AS	 INT

	SET	 @year=YEAR(@dateForSunday)		
	IF @isAPR = 0				--Firt Sunday of April
	BEGIN 
		SET	 @date1=CONVERT(DATETIME, CAST(@year AS VARCHAR)+''-4-1 02:00'')
			--print @date1
			WHILE 1 = 1
			BEGIN
				IF DATEPART(dw, @date1) = 1
				   BREAK			--First sunday of April
				ELSE
				   SET	 @date1=DATEADD(DAY, 1, @date1)
			END
			--print @date1
	END
	ELSE				--Last Sunday of October
	BEGIN
		SET	 @date1=CONVERT(DATETIME, cast(@year AS VARCHAR)+''-10-31 02:00'')
	
	--print @date1
	WHILE 1 = 1
	BEGIN
		IF DATEPART(dw, @date1) = 1
		   BREAK			--Last sunday of October
		ELSE
		   SET @date1=DATEADD(DAY, -1, @date1)
	END
	
	--print @date1
	END
	RETURN (@date1)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_UTCToLocal]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[Date_UTCToLocal] 
	(	
		@utcDate DATETIME,
		@inTimeZoneAdj INT,					-- the number of hours to adjust for the local timezone
		@bObserveDaylightSavings TINYINT	-- whether or not the local area observes US daylight savings time
	)  
RETURNS 
	DATETIME
AS  
BEGIN 
	RETURN	DATEADD(mi,DATEDIFF(mi, dbo.Date_LocalToUTC(@utcDate, @inTimeZoneAdj, @bObserveDaylightSavings) ,@utcDate ),@utcDate)--Orignal
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPracticeUTCDateTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE  function [dbo].[getPracticeUTCDateTime]
	(@inUTCDateTime datetime)		-- the time to convert to UTC (should be a local datetime value)
	returns datetime as
begin
	declare @inTimeZoneAdj int			-- the number of hours to adjust for the local timezone
	declare @bObserveDaylightSavings tinyint	-- whether or not the local area observes US daylight savings time

	select top 1 @inTimeZoneAdj=InTimeZoneAdj, @bObserveDaylightSavings=ObserveDaylightSavings from PracticeSettings
	return dbo.Date_LocalToUTC(@inUTCDateTime, @inTimeZoneAdj, @bObserveDaylightSavings)
end





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_UTCToLocal_Practice]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[Date_UTCToLocal_Practice] 
(@utcDate DATETIME)  
RETURNS 
	DATETIME
AS  
BEGIN 
Return	DateAdd(mi,dateDiff(mi, dbo.getPracticeUTCDateTime(@utcDate) ,@utcDate ),@utcDate)--Orignal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DateAsYYYYMMInt]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[DateAsYYYYMMInt]
(@Date date)
RETURNS INT
AS
BEGIN
RETURN (YEAR(@Date) * 100) + MONTH(@Date)

END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeleteKDBOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DeleteKDBOverride](@kdb [xml], @uid [uniqueidentifier])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[DeleteKDBOverride]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Diagnosis_GetCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[Diagnosis_GetCode] (@code9 varchar(25), @code10 varchar(25))
RETURNS varchar(25) AS
BEGIN

-- MIRRORS IMO_ICD_Helper in code

IF(NOT @code10 IS NULL)
	RETURN @code10;

IF (NOT @code9 IS NULL)
	RETURN @code9;

RETURN NULL; 

END 



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Diagnosis_GetFullDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[Diagnosis_GetFullDescription] (@code9 varchar(25), @code10 varchar(25), @description varchar(255))
RETURNS varchar(512) AS
BEGIN

-- MIRRORS IMO_ICD_Helper in code

DECLARE @codePortion VARCHAR(100);

IF(@code10 IS NULL OR @code10='''')
	SET @codePortion = @code9;

IF(NOT @code10 IS NULL AND NOT @code10='''')
	SET @codePortion = @code10 + ''-'' + @code9;

IF (NOT @codePortion IS NULL AND NOT @codePortion='''')
	RETURN ''('' + @codePortion + '') '' + ISNULL(@description,''<DISC NOT DEFINED>''); -- DISC NOT DEFINED should never happen

RETURN ''''; 

END 





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DispensableDrugTypeDesc]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DispensableDrugTypeDesc](@medid INT,
                                               @pmid VARCHAR(20),
                                               @federaldeaclasscode VARCHAR(1),
                                               @nametypecode VARCHAR(1),
                                               @refmultisourcecode VARCHAR(1),
                                               @reffederallegendcode VARCHAR(1),
                                               @medicaldeviceind SMALLINT,
                                               @refgenericdrugnamecode VARCHAR(1))  RETURNS VARCHAR(100)
AS
BEGIN
   RETURN CASE
             WHEN @medid IS NULL OR @medid < 1 THEN ''User Defined Drug''
             WHEN (@pmid IS NULL OR @pmid = '''') AND @medicaldeviceind <> 1 THEN ''NDC Required for non-supply Rx/''
             WHEN @federaldeaclasscode = ''0'' THEN ''''
             WHEN @federaldeaclasscode = ''1'' THEN ''DEA Schedule I/''
             WHEN @federaldeaclasscode = ''2'' THEN ''DEA Schedule II/''
             WHEN @federaldeaclasscode = ''3'' THEN ''DEA Schedule III/''
             WHEN @federaldeaclasscode = ''4'' THEN ''DEA Schedule IV/''
             WHEN @federaldeaclasscode = ''5'' THEN ''DEA Schedule V/''
             WHEN @federaldeaclasscode = ''6'' THEN ''Related products span multiple DEA Schedules/''
             ELSE ''Unknown DEA Schedule/''
          END +
          CASE
             WHEN @refmultisourcecode IN(''1'',''3'') AND @nametypecode = ''1'' THEN ''Multi Source Brand''
             WHEN @refmultisourcecode IN(''1'',''3'') AND @nametypecode = ''2'' THEN ''Multi Source Generic''
             WHEN @refmultisourcecode IN(''1'',''3'')                         THEN ''Multi Source''
             WHEN @refmultisourcecode = ''2''       AND @nametypecode = ''1'' THEN ''Single Source Brand''
             WHEN @refmultisourcecode = ''2''       AND @nametypecode = ''2'' THEN ''Single Source Generic''
             WHEN @refmultisourcecode = ''2''                               THEN ''Single Source''
             WHEN @nametypecode = ''1''                                     THEN ''Brand''
             WHEN @nametypecode = ''2''                                     THEN ''Generic''
             ELSE ''''
          END +
          CASE
             WHEN @reffederallegendcode = ''1'' THEN ''/Rx''
             WHEN @reffederallegendcode = ''2'' THEN ''/OTC''
             WHEN @reffederallegendcode = ''3'' THEN ''/Rx-OTC''
             ELSE ''''
          END +
          CASE
             WHEN @medicaldeviceind = 1         THEN ''/Supply''
             WHEN @refgenericdrugnamecode = ''0'' THEN ''/Compound''
             ELSE ''''
          END
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DispensablePA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DispensablePA](@medid INT,
                              @daw BIT,
                              @FormularyCoverageOrgUid UNIQUEIDENTIFIER)  RETURNS BIT
AS
BEGIN
   -- if no ePA for the dispensable drug, then no ePA
   IF NOT EXISTS(SELECT *
                 FROM FormularyCoverageNDC fcn (NOLOCK)
                 WHERE fcn.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                   AND fcn.medid = @medid
                   AND fcn.CoverageListType = ''PA'')
   BEGIN
      RETURN 0
   END

   -- if not allow checking generic alternatives, then ePA required (DAW or generic ePA disabled)
   IF (@daw = 1) RETURN 1

   -- get a list of generic alternatives
   DECLARE @Alternatives TABLE(medid INT NOT NULL PRIMARY KEY)
   INSERT INTO @Alternatives
   SELECT DISTINCT dis.medid
   FROM dbo.NDD_SearchDispensable dis
   INNER JOIN dbo.NDD_SearchDispensable lnk ON lnk.IsDelete = 0 AND lnk.medid = @medid AND lnk.gcnseqno = dis.gcnseqno
   WHERE dis.IsDelete = 0
     AND dis.statuscode = ''0''
     AND dis.medid != @medid
     AND dis.medid > 0
     AND dis.gcnseqno > 0
     AND dis.mnid != -1
     AND dis.DrugNameTypeCode = 2
     AND dis.Ndc != ''''

   -- if there are no generic alternatives, then ePA required
   IF (0 = (SELECT COUNT(*) FROM @Alternatives)) RETURN 1

   -- if one or more of the generic drugs does not require ePA, then ePA not required
   IF NOT EXISTS(SELECT *
                 FROM @Alternatives alt
                 LEFT JOIN dbo.FormularyCoverageNDC fcn (NOLOCK) ON fcn.medid = alt.medid
                                                             AND fcn.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                                                                AND fcn.CoverageListType = ''PA''
                 WHERE fcn.FormularyCoverageNDCUid IS NULL)
   BEGIN
      RETURN 0
   END

   -- all generics require ePA as well
   RETURN 1
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAllUsersInGroup]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- create UDF to allow Neo query to select objects visible to a user
CREATE FUNCTION [dbo].[GetAllUsersInGroup]
	(
	@UserGroupUid UniqueIdentifier
	)
RETURNS @retTable TABLE (UserUid UniqueIdentifier)
AS

BEGIN
	DECLARE @lUserGroupUid UniqueIdentifier

	DECLARE RetrieveUserGroups CURSOR STATIC LOCAL FOR
		SELECT DISTINCT MemberUserGroupUid FROM UserGroupMember WHERE UserGroupUid = @UserGroupUid AND MemberUserGroupUid IS NOT NULL

	INSERT INTO @retTable 
		SELECT DISTINCT MemberUserUid 
		FROM			UserGroupMember 
		WHERE			UserGroupUid = @UserGroupUid AND 
						MemberUserUid IS NOT NULL AND
						MemberUserUid NOT IN (SELECT UserUid FROM @retTable)

	OPEN RetrieveUserGroups

	FETCH NEXT FROM RetrieveUserGroups
	INTO @lUserGroupUid

	WHILE (@@FETCH_STATUS = 0) 
	BEGIN
		
		INSERT INTO @retTable
		select * from dbo.GetAllUsersInGroup(@lUserGroupUid)
   
		FETCH NEXT FROM RetrieveUserGroups INTO @lUserGroupUid
	END
	
	CLOSE RetrieveUserGroups
	DEALLOCATE RetrieveUserGroups

RETURN
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsUserInGroup]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[IsUserInGroup](@UserGroupUid [uniqueidentifier], @UserUid [uniqueidentifier])
RETURNS [int] 
AS

begin
    declare @retValue int
	set @retValue=0

	select @retValue=1 from dbo.GetAllUsersInGroup(@UserGroupUid) u where u.UserUid = @UserUid
	return @retValue
end



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DoesUserUidHaveAccessToPatientChart]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[DoesUserUidHaveAccessToPatientChart] ( 
  @in_UserUid    [uniqueidentifier],
  @in_PatientUid [uniqueidentifier])
RETURNS [int]
AS
BEGIN
    DECLARE @retValue INT
	SET @retValue = 0

	--If user is specifially denied
	IF EXISTS(SELECT * FROM ChartAccessDeny WHERE ChartAccessDeny.PatientUid = @in_PatientUid and ChartAccessDeny.UserUid = @in_UserUid)
	BEGIN
		RETURN @retValue
	END

	DECLARE @cUserGroupUid uniqueidentifier
	DECLARE @found bit = 0;

	DECLARE curChartAccessDeny CURSOR FOR
		SELECT distinct UserGroupUid
		FROM ChartAccessDeny
		WHERE ChartAccessDeny.PatientUid = @in_PatientUid and ChartAccessDeny.UserGroupUid is not null

	OPEN curChartAccessDeny
	FETCH NEXT FROM curChartAccessDeny INTO @cUserGroupUid
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF(dbo.IsUserInGroup(@cUserGroupUid, @in_UserUid) = 1)
		BEGIN
			SET @found = 1
			BREAK;
		END
		FETCH NEXT FROM curChartAccessDeny INTO @cUserGroupUid
	END

	CLOSE curChartAccessDeny
	DEALLOCATE curChartAccessDeny 

	if (@found = 1)
	BEGIN
		RETURN @retValue
	END
	
	IF NOT EXISTS (SELECT * FROM ChartAccess WHERE ChartAccess.PatientUid = @in_PatientUid)
	BEGIN
	  SET @retValue = 1
	  RETURN @retValue
	END

	DECLARE @cChartAccessUid uniqueidentifier
	DECLARE @cPatientUid uniqueidentifier
	DECLARE @cUserUid uniqueidentifier

	DECLARE curChartAccess CURSOR FOR
	  SELECT ChartAccessUid, PatientUid, UserUid, UserGroupUid
	  FROM ChartAccess
	  WHERE ChartAccess.PatientUid = @in_PatientUid
	  
	OPEN curChartAccess
	FETCH NEXT FROM curChartAccess INTO @cChartAccessUid, @cPatientUid, @cUserUid, @cUserGroupUid
	WHILE @@FETCH_STATUS = 0
	BEGIN
	  IF (@cUserUid = @in_UserUid)
	  BEGIN
	    SET @retValue = 1
	    BREAK
	  END
	  
	  IF (@cUserGroupUid is not null)
	  BEGIN
	    IF (dbo.IsUserInGroup(@cUserGroupUid, @in_UserUid) = 1)
	    BEGIN
	      SET @retValue = 1
	      BREAK	    
	    END 	  
	  END
	  
	  FETCH NEXT FROM curChartAccess INTO @cChartAccessUid, @cPatientUid, @cUserUid, @cUserGroupUid  
	END   
	
	CLOSE curChartAccess
	DEALLOCATE curChartAccess 
	
	RETURN @retValue
END 




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DoesUserUidHaveAccessToVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[DoesUserUidHaveAccessToVisit] ( 
  @userUid [uniqueidentifier],
  @visitUid [uniqueidentifier])
RETURNS [int]
AS
BEGIN
    DECLARE @retValue INT
	SET @retValue=0
	
	IF NOT EXISTS (SELECT * FROM VisitAccess WHERE VisitAccess.VisitUid = @visitUid)
    BEGIN
      SET @retValue = 1
      RETURN @retValue  
    END	
	
	DECLARE @curVisitAccessUid uniqueidentifier
	DECLARE @curVisitUid uniqueidentifier
	DECLARE @curUserUid uniqueidentifier
	DECLARE @curUserGroupUid uniqueidentifier
	
	DECLARE cursorVisitAccess CURSOR FOR
	  SELECT VisitAccessUid, VisitUid, UserUid, UserGroupUid 
	  FROM VisitAccess 
	  WHERE VisitAccess.VisitUid = @visitUid
	
	OPEN cursorVisitAccess
	FETCH NEXT FROM cursorVisitAccess INTO @curVisitAccessUid, @curVisitUid, @curUserUid, @curUserGroupUid
	WHILE @@FETCH_STATUS = 0
	BEGIN 
	  IF (@curUserUid = @userUid)
	  BEGIN
	    SET @retValue = 1
	    BREAK  
	  END
	  
	  IF (@curUserGroupUid is not null)
	  BEGIN
	    IF (dbo.IsUserInGroup(@curUserGroupUid, @userUid) = 1)
	    BEGIN
	      SET @retValue = 1
	      BREAK	    
	    END 
	  END
	  
	  FETCH NEXT FROM cursorVisitAccess INTO @curVisitAccessUid, @curVisitUid, @curUserUid, @curUserGroupUid 
	END
    	  
    CLOSE cursorVisitAccess
    DEALLOCATE cursorVisitAccess 	
	
	RETURN @retValue
END 


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DoesVisitHaveFormLayout]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DoesVisitHaveFormLayout] (
	@VisitUid [uniqueidentifier], 
	@FormLayoutUid [uniqueidentifier])
RETURNS INT
AS
BEGIN
	declare @retValue int
	set @retValue=0

	SELECT @retValue=1
	FROM Visit v
	INNER JOIN RelFormLayoutClinicalNoteType rel on rel.ClinicalNoteTypeUid = v.ClinicalNoteTypeUid
	WHERE v.VisitUid = @VisitUid AND rel.FormLayoutUid = @FormLayoutUid
	
	return @retValue
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DrugStrengthSortValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DrugStrengthSortValue](@med_strength VARCHAR(50), @n INT = 1)
RETURNS FLOAT
AS
BEGIN
   DECLARE @s VARCHAR(50) = REPLACE(REPLACE(@med_strength, ''-'', '' ''), '','', '''')
   WHILE (@n > 0)
   BEGIN
      IF (@s IS NULL) RETURN NULL
      IF (PATINDEX(''%[0-9]%'', @s) = 0) RETURN null
      SET @s = SUBSTRING(@s, PATINDEX(''%[0-9\.]%'', @s), 50)
      DECLARE @i INT = PATINDEX(''%[^0-9\.]%'', @s) - 1
      IF (@i <= 0) SET @i = 50
      IF (@n = 1) RETURN CONVERT(FLOAT, SUBSTRING(@s, 1, @i))
      SET @s = SUBSTRING(@s, @i + 1, 50)
      SET @n = @n - 1
   END
   RETURN NULL
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitStrings]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitStrings](@str VARCHAR(MAX), @sep CHAR(1))
RETURNS @returns TABLE(idx INT PRIMARY KEY CLUSTERED, val VARCHAR(MAX))
AS
BEGIN
   DECLARE 
      @name VARCHAR(MAX),
      @pos  INT,
      @i    INT
   SET @i = -1
   WHILE CHARINDEX(@sep, @str) > 0
      BEGIN
         SELECT @pos  = CHARINDEX(@sep, @str)
         SELECT @name = SUBSTRING(@str, 1, @pos-1)
         
         SET @i = @i + 1
         INSERT INTO @returns 
         SELECT @i, @name
         
         SELECT @str = SUBSTRING(@str, @pos+1, LEN(@str)-@pos)
      END

   INSERT INTO @returns
   SELECT @i+1, @str
   
   RETURN   
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ParseEDI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ParseEDI](@edi VARCHAR(MAX), @ediSegment VARCHAR(100))
RETURNS @parse TABLE(
      tag                  VARCHAR(100)   NOT NULL,
      segment              INT            NOT NULL,
      element              INT            NOT NULL,
      repitition           INT            NOT NULL,
      field                INT            NOT NULL,
      val                  VARCHAR(MAX)   NULL,
                                          PRIMARY KEY CLUSTERED(tag, segment),
                                          UNIQUE NONCLUSTERED(segment, element, repitition, field))
AS
BEGIN
   DECLARE
      @UNA_010_01          CHAR(1)        = SUBSTRING(@edi, 4, 1),
      @UNA_010_02          CHAR(1)        = SUBSTRING(@edi, 5, 1),
      @UNA_010_03          CHAR(1)        = SUBSTRING(@edi, 6, 1),
      @UNA_010_04          CHAR(1)        = SUBSTRING(@edi, 7, 1),
      @UNA_010_05          CHAR(1)        = SUBSTRING(@edi, 8, 1),
      @UNA_010_06          CHAR(1)        = SUBSTRING(@edi, 9, 1)

   DECLARE
      @tag                 VARCHAR(100),
      @segment             INT,
      @element             INT,
      @repitition          INT,
      @field               INT,
      @val                 VARCHAR(MAX)

   -- divide up the top level segments
   INSERT INTO @parse
   SELECT
      tag                = SUBSTRING(val, 1, 3) + CASE
                                                     WHEN SUBSTRING(val, 1, 3) = '''' THEN ''EOF''
                                                     WHEN val LIKE ''PVD'' + @UNA_010_02 + ''P2%'' THEN ''P2''
                                                     WHEN val LIKE ''PVD'' + @UNA_010_02 + ''PC%'' THEN ''PC''
                                                     WHEN val LIKE ''PVD'' + @UNA_010_02 + ''SU%'' THEN ''SU''
                                                     WHEN val LIKE ''DRU'' + @UNA_010_02 + ''D%'' THEN ''D''
                                                     ELSE ''''
                                                  END,
      segment            = idx+1,
      element            = 0,
      repitition         = 0,
      field              = 0,
      val                = val
   FROM dbo.SplitStrings(@edi, @UNA_010_06)
   WHERE @ediSegment IS NULL OR SUBSTRING(val, 1, 3) = @ediSegment

   -- parse segments
   DECLARE segmentCursor CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element = 0 ORDER BY segment, element, repitition, field
   OPEN segmentCursor
   FETCH NEXT FROM segmentCursor INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         INSERT INTO @parse
         SELECT
          tag                = @tag + ''_'' + CASE
                                               WHEN idx < 10 THEN ''0''
                                               ELSE ''''
                                            END + CONVERT(VARCHAR(2), idx) + ''0'',
          segment            = @segment,
          element            = idx+1,
          repitition         = 0,
          field              = 0,
          val                = val
         FROM dbo.SplitStrings(@val, @UNA_010_02)
         FETCH NEXT FROM segmentCursor INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentCursor
   DEALLOCATE segmentCursor

   -- parse elements
   DECLARE segmentElement CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition = 0 ORDER BY segment, element, repitition, field
   OPEN segmentElement
   FETCH NEXT FROM segmentElement INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         INSERT INTO @parse
         SELECT
          tag                = @tag + ''_'' + CASE
                                               WHEN idx < 10 THEN ''X0''
                                               ELSE ''X''
    END + CONVERT(VARCHAR(2), idx+1),
          segment            = @segment,
          element            = @element,
          repitition         = idx+1,
          field              = 0,
          val                = val
         FROM dbo.SplitStrings(@val, @UNA_010_05)
         FETCH NEXT FROM segmentElement INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentElement
   DEALLOCATE segmentElement

   -- parse repititions
   DECLARE segmentRepitition CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition > 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentRepitition
   FETCH NEXT FROM segmentRepitition INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         INSERT INTO @parse
         SELECT
          tag                = SUBSTRING(@tag, 1, LEN(@tag) -4) + ''_'' +
                                         CASE
                                            WHEN idx+1 < 10 THEN ''0'' + CONVERT(VARCHAR(2), idx+1)
                                            ELSE CONVERT(VARCHAR(2), idx+1)
                                         END +
                                         CASE
                                            WHEN @repitition > 1 THEN ''_'' + CONVERT(VARCHAR(2), @repitition)
                                            ELSE ''''
                                         END,
          segment            = @segment,
          element            = @element,
          repitition         = @repitition,
          field              = idx + 1,
          val                = val
         FROM dbo.SplitStrings(@val, @UNA_010_01)
         FETCH NEXT FROM segmentRepitition INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentRepitition
   DEALLOCATE segmentRepitition

   RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EscapeXml]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[EscapeXml](@xml VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN

	SET @xml = REPLACE(@xml, ''&'', ''&amp;'')
	SET @xml = REPLACE(@xml, ''>'', ''&gt;'')
	SET @xml = REPLACE(@xml, ''<'', ''&lt;'')
	SET @xml = REPLACE(@xml, ''"'', ''&quot;'')
	SET @xml = REPLACE(@xml, '''''''', ''&apos;'')
	RETURN @xml
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EDI2Xml]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[EDI2Xml](@edi VARCHAR(MAX)) RETURNS XML
AS
BEGIN
   -- Data Not Done (not comprehensive list yet
   --     <DrugCoverageStatusCode>PR</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>AP</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>PA</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>NF</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>NR</DrugCoverageStatusCode>
   --     <PriorAuthorizationStatus>A</PriorAuthorizationStatus>

   DECLARE
      @UNA_010_01          CHAR(1)        = SUBSTRING(@edi, 4, 1),
      @UNA_010_02          CHAR(1)        = SUBSTRING(@edi, 5, 1),
      @UNA_010_03          CHAR(1)        = SUBSTRING(@edi, 6, 1),
      @UNA_010_04          CHAR(1)        = SUBSTRING(@edi, 7, 1),
      @UNA_010_05          CHAR(1)        = SUBSTRING(@edi, 8, 1),
      @UNA_010_06          CHAR(1)        = SUBSTRING(@edi, 9, 1)

   DECLARE
      @MessageXML          VARCHAR(MAX),
      @tag                 VARCHAR(20),
      @segment             INT,
      @element             INT,
      @repitition          INT,
      @field               INT,
      @val                 VARCHAR(MAX)

   DECLARE @parse TABLE(
      tag                  VARCHAR(20)    NOT NULL PRIMARY KEY CLUSTERED,
      segment              INT            NOT NULL,
      element              INT            NOT NULL,
      repitition           INT            NOT NULL,
      field                INT            NOT NULL,
      val                  VARCHAR(MAX)   NULL,
                                          UNIQUE NONCLUSTERED(segment, element, repitition, field))
   INSERT INTO @parse SELECT * FROM dbo.ParseEDI(@edi, null)

   -- strip the SPI out of PVDPC identifiers
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
      BEGIN
         DELETE @parse
       WHERE segment    = (SELECT segment    FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
         AND element    = (SELECT element    FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
         AND repitition = (SELECT repitition FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
         AND field > 0
      END

   -- Provider Specialty
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDPC_040_01'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDPC_040_01''
      END
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDPC_040_02'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDPC_040_02''
      END
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDSU_040_01'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDSU_040_01''
      END
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDSU_040_02'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDSU_040_02''
      END

   -- Convert State Codes to Upper Case
   UPDATE @parse
   SET val = UPPER(val)
   WHERE tag IN(''PVDP2_080_03'', ''PVDPC_080_03'', ''PVDSU_080_03'', ''PTT_060_03'')

   -- Make sure the telephone is TE
   UPDATE @parse
   SET val = ''TE''
   WHERE tag IN(''PTT_070_02'')
     AND val != ''TE''

   -- DRU Form Code
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_03'')
      BEGIN
         -- NDC
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_03'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_02''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_04'')
      BEGIN
         -- NDC Code
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_04'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''ND''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_03''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_05'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_05'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_04''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_06'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_06'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_05''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_07'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_07'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_06''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_08'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_08'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_07''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_09'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_09'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_08''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_10'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_10'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_09''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_11'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_11'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_10''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_12'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_12'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_11''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_13'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_13'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''AA''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_12''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_14'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_14'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''C38046''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_13''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_15'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_15'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''AB''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_14''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_16'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_16'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''C38046''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_15''
      END

   UPDATE @parse
   SET val = ''AA''
   WHERE tag = ''DRU_010_13''
     AND val != ''AA''

   UPDATE @parse
   SET val = ''C38046''
   WHERE tag = ''DRU_010_14''
     AND val != ''C38046''

   UPDATE @parse
   SET val = ''AB''
   WHERE tag = ''DRU_010_15''
     AND val != ''AB''

   UPDATE @parse
   SET val = ''C38046''
   WHERE tag = ''DRU_010_16''
     AND val != ''C38046''

   -- Quantity Code
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_020_03'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_020_03'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''38''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_020_02''
      END

   UPDATE @parse
   SET val = ''38''
   WHERE tag = ''DRU_020_03''
     AND val != ''38''

   -- Potency Unit Code
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_020_04'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_020_04'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''AC''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_020_03''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_020_05'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_020_05'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''C38046''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_020_04''
      END
      
   UPDATE @parse
   SET val = ''AC''
   WHERE tag = ''DRU_020_04''
     AND val != ''AC''

   UPDATE @parse
   SET val = ISNULL((SELECT CASE qty.val
                               WHEN ''12'' THEN ''C48521''
                               WHEN ''AR'' THEN ''C48539''
                               WHEN ''AV'' THEN ''C48480''
                               WHEN ''BG'' THEN ''C48474''
                               WHEN ''BO'' THEN ''C48477''
                               WHEN ''BX'' THEN ''C48478''
                               WHEN ''CH'' THEN ''C48484''
                               WHEN ''CQ'' THEN ''C48481''
                               WHEN ''EA'' THEN ''C64933''
                               WHEN ''FO'' THEN ''C48494''
                               WHEN ''GR'' THEN ''C48155''
                               WHEN ''IH'' THEN ''C62275''
                               WHEN ''KT'' THEN ''C48504''
                               WHEN ''LT'' THEN ''C48505''
                               WHEN ''ME'' THEN ''C28253''
                               WHEN ''ML'' THEN ''C28254''
                               WHEN ''PT'' THEN ''C48529''
                               WHEN ''SZ'' THEN ''C48540''
                               WHEN ''TB'' THEN ''C48549''
                               WHEN ''U2'' THEN ''C48542''
                               WHEN ''UU'' THEN ''C48506''
                               WHEN ''VI'' THEN ''C48551''
                               WHEN ''Y2'' THEN ''C48541''
                               WHEN ''Y3'' THEN ''C48544''
                               WHEN ''Y7'' THEN ''C69124''
                               ELSE ''C38046''
                            END
                     FROM @parse qty
                     WHERE qty.tag = ''DRU_020_01''
                       AND qty.val != ''''), ''C38046'')
   WHERE tag = ''DRU_020_05''

   -- Quantity Qualifier
   UPDATE @parse
   SET val = ''''
   WHERE tag = ''DRU_020_01''
     AND val != ''''

   -- X fields in 10.6
   UPDATE @parse
   SET val = ''''
   WHERE tag IN(''DRU_010_05'',
                ''DRU_010_07'',
                ''DRU-020-01'',
                ''DRU-030-01'',
                ''DRUD_010_05'',
                ''DRUD_010_07'',
                ''DRUD-020-01'',
                ''DRUD-030-01'',
                ''UIB-010-03'',
                ''UIB-010-04'',
                ''UIB-020'',
                ''UIB-040'',
                ''UIB-050'',
                ''UIB-080-03'',
                ''UIB-090'',
                ''UIH-010-05'',
                ''UIH-040'',
                ''UIH-050-03'',
                ''UIH-060'',
                ''REQ-040'',
                ''REQ-050'',
                ''PVDP2-030'',
                ''PVDP2-040-02'',
                ''PVDP2-060'',
                ''PVDP2-100'',
                ''PVDPC-030'',
                ''PVDPC-040-02'',
                ''PVDPC-060'',
                ''PVDSU-030'',
                ''PVDSU-040-02'',
                ''PVDSU-060'',
                ''OBS-010-03'',
                ''COO-030'',
                ''COO-040-02'',
                ''COO-090'',
                ''COO-110'',
                ''COO-120'',
                ''COO-130'',
                ''COO-140'',
                ''UIZ-010'',
                ''UIZ-030'')

   -- Make sure there is a MedicationDispensed segment (clone MedicationPrescribed if not)
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRUD'')
      BEGIN
         UPDATE @parse
         SET segment = segment + 1
         FROM @parse
         WHERE segment > (SELECT segment FROM @parse WHERE tag = ''DRU'')

         INSERT INTO @parse
         SELECT
            tag = REPLACE(tag, ''DRU'', ''DRUD''),
            segment = segment + 1,
            element = element,
            repitition = repitition,
            field      = field,
            val        = CASE (tag)
                            WHEN ''DRU_010_01'' THEN ''D''
                            ELSE val
                         END
         FROM @parse
         WHERE tag = ''DRU'' OR tag LIKE ''DRU_%''

         UPDATE @parse
         SET val = CONVERT(VARCHAR(MAX), 1 + CONVERT(INT, val))
         WHERE tag = ''UIT_020_01''
      END

   -- Now Reconstruct the EDI
   UPDATE @parse SET val = '''' WHERE field = 0

   -- reconstruct repititions
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition > 0 AND field > 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         UPDATE @parse
         SET val = val + CASE WHEN @field = 1 THEN '''' ELSE @UNA_010_01 END + @val
         WHERE segment = @segment
AND element = @element
           AND repitition = @repitition
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- reconstruct elements
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition > 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         UPDATE @parse
         SET val = val + CASE WHEN @repitition = 1 THEN '''' ELSE @UNA_010_05 END + @val
         WHERE segment = @segment
           AND element = @element
           AND repitition = 0
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- reconstruct segments
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition = 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         UPDATE @parse
         SET val = val + CASE WHEN @element = 1 THEN '''' ELSE @UNA_010_02 END + @val
         WHERE segment = @segment
      AND element = 0
           AND repitition = 0
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- reconstruct edi
   DECLARE @oldedi VARCHAR(MAX) = @edi
   SELECT @edi = ''''
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element = 0 AND repitition = 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         SELECT @edi = @edi + CASE WHEN @segment = 1 THEN '''' ELSE @UNA_010_06 END + val
         FROM @parse
         WHERE segment = @segment
           AND element = 0
           AND repitition = 0
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- Now reconstruct the XML using the modified EDI as starting point
   DELETE @parse
   INSERT INTO @parse SELECT * FROM dbo.ParseEDI(@edi, null) ORDER BY segment, element, repitition, field

   DECLARE @binary TABLE(data VARBINARY(MAX))
   INSERT INTO @binary VALUES(CAST(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(@edi, ''&'', ''&amp;''), ''<'', ''&lt;''), ''>'', ''&gt;''), ''"'', ''&quot;''), '''''''', ''&apos;'') AS VARBINARY(MAX)))

   SET @MessageXML =
      ''<RefillRequest.eRxService xmlns="http://www.ncpdp.org/schema/SCRIPT" version="010" release="006"''
    + '' MessageID="''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_030_01''), '''') + ''"''
    +    '' RelatesToMessageID="''          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_030_02''), '''') + ''"''
    +    '' RxReferenceNumber="''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIH_020_01''), '''') + ''"''
    +    '' SentTime="''                    + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_01''), 1, 4) + ''-''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_01''), 5, 2) + ''-''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_01''), 7, 2) + ''T''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 1, 2) + '':''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 3, 2) + '':''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 5, 2)
                                                 + CASE WHEN ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 8, 1), '''') != ''''
                                                      THEN ''.'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 8, 1) ELSE '''' END
                                                 + ''Z'', '''') + ''">''
    +    ''<To Qualifier="D">''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_070_01''), '''') + ''</To>''
    +    ''<From Qualifier="P">''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_060_01''), '''') + ''</From>''
    +    ''<Request>''
    +       ''<ReturnReceipt>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''REQ_020''), ''0'') + ''</ReturnReceipt>''
    +       ''<RequestReferenceNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''REQ_030''), '''') + ''</RequestReferenceNumber>''
    +    ''</Request>''
    +    ''<Pharmacy>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</NPI>''
 WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</MedicaidNumber>''
   WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Specialty>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_040_01''), '''') + ''</Specialty>''
    +       ''<Pharmacist>''
    +          ''<LastName>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_05''), '''') + ''</Prefix>''
    +       ''</Pharmacist>''
    +       ''<StoreName>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_070''), '''') + ''</StoreName>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_05'') = ''AD2''
                                                THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_06''), '''')
                                                ELSE ''''
                                            END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_02''), '''') + ''</City>''
    +          ''<State>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +       ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01'' ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +    ''</Pharmacy>''
    +    ''<Prescriber>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</FileID>''
     WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</PriorAuthorization>''
                WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</BINLocationNumber>''
 WHEN ''DH'' THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Specialty>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_040_01''), '''') + ''</Specialty>''
    +       ''<ClinicName>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_070''), '''') + ''</ClinicName>''
    +       ''<Name>''
    +          ''<LastName>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_05''), '''') + ''</Prefix>''
    +       ''</Name>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_05'') = ''AD2'' THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_06''), '''') ELSE '''' END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_02''), '''') + ''</City>''
    +          ''<State>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +   ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01''  ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +  CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +       CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_01''), '''') != ''''
               THEN ''<PrescriberAgent>''
                  +    ''<LastName>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_01''), '''') + ''</LastName>''
                  +    ''<FirstName>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_02''), '''') + ''</FirstName>''
                  + ''<MiddleName>''     + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_03''), '''') + ''</MiddleName>''
                  +    ''<Suffix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_04''), '''') + ''</Suffix>''
                  +    ''<Prefix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_05''), '''') + ''</Prefix>''
                  + ''</PrescriberAgent>''
               ELSE ''''
            END
    +    ''</Prescriber>''
    + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU'') IS NOT NULL THEN
         ''<Supervisor>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''     + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</NCPDPID>''
      WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Specialty>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_040_01''), '''') + ''</Specialty>''
    +       ''<ClinicName>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_070''), '''') + ''</ClinicName>''
    +       ''<Name>''
    +          ''<LastName>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_05''), '''') + ''</Prefix>''
    +       ''</Name>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_05'') = ''AD2'' THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_06''), '''') ELSE '''' END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_02''), '''') + ''</City>''
  +    ''<State>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +       ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01''  ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +     CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_01''), '''') != ''''
         THEN ''<PrescriberAgent>''
            +    ''<LastName>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_01''), '''') + ''</LastName>''
                  +    ''<FirstName>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_02''), '''') + ''</FirstName>''
                  +    ''<MiddleName>''     + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_03''), '''') + ''</MiddleName>''
                  +    ''<Suffix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_04''), '''') + ''</Suffix>''
                  +    ''<Prefix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_05''), '''') + ''</Prefix>''
                  + ''</PrescriberAgent>''
               ELSE ''''
            END
    +    ''</Supervisor>''
         ELSE '''' END
    +    ''<Patient>''
    +       ''<PatientRelationship>1</PatientRelationship>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</FileID>''
                WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</SPI>''
WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</NCPDPID>''
  WHEN ''94''  THEN ''<FileID>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</PayerID>''
          WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Name>''
    +          ''<LastName>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_05''), '''') + ''</Prefix>''
    +       ''</Name>''
    +       ''<Gender>''                    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_040''), '''') + ''</Gender>''
    +       ''<DateOfBirth><Date>''         + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_020''), 1, 4) + ''-''
                                                     + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_020''), 5, 2) + ''-''
                                                     + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_020''), 7, 2) + ''</Date></DateOfBirth>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_05'') = ''AD2'' THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_06''), '''') ELSE '''' END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_02''), '''') + ''</City>''
    +          ''<State>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +       ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01''  ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +    ''</Patient>''
    +    ''<MedicationPrescribed>''
    +       CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_12''), '''') != ''''
               THEN ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_12''), '''') + ''</DrugDescription>''
               ELSE ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_02''), '''') + ''</DrugDescription>''
            END
    +       ''<DrugCoded>''
    +          ''<ProductCode>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_03''), '''') + ''</ProductCode>''
    +          ''<ProductCodeQualifier>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_04''), '''') + ''</ProductCodeQualifier>''
    +          ''<Strength>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_06''), '''') + ''</Strength>''
    +       ''<DrugDBCode>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_08''), '''') + ''</DrugDBCode>''
    +          ''<DrugDBCodeQualifier>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_09''), '''') + ''</DrugDBCodeQualifier>''
    +          ''<FormSourceCode/>''
    +          ''<FormCode>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_05''), '''') + ''</FormCode>''
    +          ''<StrengthSourceCode/>''
    +          ''<StrengthCode>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_07''), '''') + ''</StrengthCode>''
    +       ''</DrugCoded>''
    +       ''<Quantity>''
    +          ''<Value>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_02''), '''') + ''</Value>''
    +          ''<CodeListQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_03''), '''') + ''</CodeListQualifier>''
    +          ''<UnitSourceCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_04''), '''') + ''</UnitSourceCode>''
    +          ''<PotencyUnitCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_05''), '''') + ''</PotencyUnitCode>''            -- CMR??? we need to look this one up
    +       ''</Quantity>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01''  ) = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_2'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_3'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), '''') + ''</DaysSupply>''
               ELSE ''''
            END
    +       ''<Directions>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_030_02''), '''') + ''</Directions>''
    +       ''<Note>''                      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_090_01''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_090_01_2''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_090_01_3''), '''')
    +       ''</Note>''
    +       ''<Refills>''
    +         ''<Qualifier>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_060_01''), '''') + ''</Qualifier>''
    +         ''<Value>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_060_02''), '''') + ''</Value>''
    +       ''</Refills>''
    +       ''<Substitutions>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_050''), '''') + ''</Substitutions>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01''  ) = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_2'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_3'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 1, 4), '''') + ''</WrittenDate>''
               ELSE ''''
            END
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01''  ) = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_2'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_3'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 1, 4), '''') + ''</LastFillDate>''
               ELSE ''''
            END
    +    ''</MedicationPrescribed>''
    +    ''<MedicationDispensed>'' +
    +     CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_12''), '''') != ''''
               THEN ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_12''), '''') + ''</DrugDescription>''
               ELSE ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_02''), '''') + ''</DrugDescription>''
            END
    +       ''<DrugCoded>''
    +          ''<ProductCode>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_03''), '''') + ''</ProductCode>''
    +          ''<ProductCodeQualifier>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_04''), '''') + ''</ProductCodeQualifier>''
    +          ''<Strength>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_06''), '''') + ''</Strength>''
    +          ''<DrugDBCode>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_08''), '''') + ''</DrugDBCode>''
    +          ''<DrugDBCodeQualifier>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_09''), '''') + ''</DrugDBCodeQualifier>''
    +          ''<FormSourceCode/>''
    +          ''<FormCode>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_05''), '''') + ''</FormCode>''
    +          ''<StrengthSourceCode/>''
    +          ''<StrengthCode>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_07''), '''') + ''</StrengthCode>''
    +       ''</DrugCoded>''
    +       ''<Quantity>''
    +          ''<Value>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_02''), '''') + ''</Value>''
    +          ''<CodeListQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_03''), '''') + ''</CodeListQualifier>''
    +          ''<UnitSourceCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_04''), '''') + ''</UnitSourceCode>''
    +          ''<PotencyUnitCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_05''), '''') + ''</PotencyUnitCode>''            -- CMR??? we need to look this one up
    +       ''</Quantity>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01''  ) = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_2'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_3'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), '''') + ''</DaysSupply>''
               ELSE ''''
            END
    +       ''<Directions>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_030_02''), '''') + ''</Directions>''
    +       ''<Note>''                      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_090_01''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_090_01_2''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_090_01_3''), '''')
    +       ''</Note>''
    +       ''<Refills>''
    +         ''<Qualifier>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_060_01''), '''') + ''</Qualifier>''
    +         ''<Value>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_060_02''), '''') + ''</Value>''
    +       ''</Refills>''
    +       ''<Substitutions>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_050''), '''') + ''</Substitutions>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01''  ) = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_2'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_3'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 1, 4), '''') + ''</WrittenDate>''
               ELSE ''''
            END
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01''  ) = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_2'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_3'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 1, 4), '''') + ''</LastFillDate>''
               ELSE ''''
            END
    +    ''</MedicationDispensed>'' +
    +    ''<EDIFACTMessage>'' + (SELECT CAST('''' AS XML).value(''xs:base64Binary(xs:hexBinary(sql:column("data")))'' , ''VARCHAR(MAX)'') FROM @binary) + ''</EDIFACTMessage>''
    + ''</RefillRequest.eRxService>''

   RETURN CONVERT(XML, @MessageXML)
--SELECT CONVERT(XML, @MessageXML)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EncryptPHI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[EncryptPHI]
	()
	returns bit as
begin

	declare @ret bit
	IF EXISTS ( SELECT 1 FROM ListProductParameter where ParameterName = ''EncryptPHI'' and BoolValue = 1 )
		SET @ret = 1
	ELSE
		SET @ret = 0

	return @ret

end




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetClaimAdjustments]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetClaimAdjustments](@ERAClaimPaymentInfoUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @list VARCHAR(50)

	select @list = ISNULL((@list + ''; ''), '''') + 
	                cadj.GroupCode + ''-'' + cadj.ReasonCode + 
	                case when cadj.Amount < 0 then '' ($'' + convert(varchar,-(cadj.Amount),1) + '')'' 
	                     else '' $'' + convert(varchar,cadj.Amount,1) + '''' end 
	from ERAClaimAdjustment cadj
	Where cadj.ERAClaimPaymentInfoUid = @ERAClaimPaymentInfoUid
	ORDER BY cadj.GroupCode, cadj.ReasonCode, cadj.Amount

	return ISNULL(@list, '''')
END


        

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetCoinsuranceAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetCoinsuranceAmount](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY

	SELECT  @ReturnValue = SUM(Amount) FROM ERAServiceAdjustment 
	WHERE ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid AND GroupCode = ''PR'' AND ReasonCode = ''2'' and Amount is not null
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetDeductibleAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetDeductibleAmount](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY

	SELECT  @ReturnValue = SUM(Amount) FROM ERAServiceAdjustment 
	WHERE ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid AND GroupCode = ''PR'' AND ReasonCode = ''1'' and Amount is not null
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetGroupReasonCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ERAGetGroupReasonCode](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @list VARCHAR(50)
	SELECT @list = ISNULL((@list + '', ''), '''') + sa.GroupCode + ''-'' + sa.ReasonCode
	FROM ERAServiceAdjustment sa
	WHERE sa.ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid AND
		  sa.ReasonCode NOT IN (''1'', ''2'') AND 
          sa.GroupCode is not NULL AND 
          sa.ReasonCode is not NULL
	ORDER BY sa.LastModifiedDate

	return ISNULL(@list, '''')
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetLateFilingCharge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetLateFilingCharge](@ERAClaimPaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY
	
	SELECT @ReturnValue = SUM(sa.Amount)
	FROM ERAServicePaymentInfo spi 
			INNER JOIN ERAServiceAmount sa on spi.ERAClaimPaymentInfoUid = @ERAClaimPaymentInfoUid
												AND spi.ERAServicePaymentInfoUid = sa.ERAServicePaymentInfoUid
												AND sa.QualifierCode = ''KH'' -- Deduction Amount Late Filing Reduction
	GROUP BY spi.ERAClaimPaymentInfouID
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetLQRemarks]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ERAGetLQRemarks](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @list VARCHAR(50)

	select @list = ISNULL((@list + '', ''), '''') + hrc.IndustryCode
	from ERAHealthCareRemarkCode hrc
	Where hrc.ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid
	ORDER BY hrc.IndustryCode

	return ISNULL(@list, '''')
END


        
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetReasonCodeAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetReasonCodeAmount](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY

	SELECT  @ReturnValue = SUM(Amount) FROM ERAServiceAdjustment 
	WHERE ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid 
		  AND ReasonCode NOT IN (''1'',''2'') and Amount is not null
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetTransactionError]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ERAGetTransactionError](@ERATransactionSetUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(1024)
AS
BEGIN
	DECLARE @retVal VARCHAR(1024)
	SET @retVal = NULL
	
	SELECT top 1 @retVal = tse.ErrorText 
    FROM ERATransactionSetError tse with (nolock)
    where tse.ERATransactionSetUid = @ERATransactionSetUid
    ORDER BY tse.LastModifiedDate asc
    
    IF ( @retVal IS NULL )
    BEGIN
	 SELECT top 1 @retVal = cpie.ErrorText 
	 FROM ERAHeader h with (nolock) 
		JOIN ERAClaimPaymentInfo cpi with (nolock) ON h.ERATransactionSetUid = @ERATransactionSetUid
										AND h.ERAHeaderUid = cpi.ERAHeaderUid
		JOIN ERAClaimPaymentInfoError cpie with (nolock) ON cpie.ERAClaimPaymentInfoUid = cpi.ERAClaimPaymentInfoUid
	 ORDER BY cpie.LastModifiedDate asc	  
    END
    
    IF ( @retVal IS NULL )
    BEGIN  
	 SELECT top 1 @retVal = spie.ErrorText 
	 FROM ERAHeader h with (nolock) 
			JOIN ERAClaimPaymentInfo cpi with (nolock) ON h.ERATransactionSetUid = @ERATransactionSetUid
												AND h.ERAHeaderUid = cpi.ERAHeaderUid
			JOIN ERAServicePaymentInfo spi with (nolock) ON spi.ERAClaimPaymentInfoUid = cpi.ERAClaimPaymentInfoUid
			JOIN ERAServicePaymentInfoError spie with (nolock) ON spie.ERAServicePaymentInfoUid = spi.ERAServicePaymentInfoUid
     ORDER BY spie.LastModifiedDate asc
    END
	
	return ISNULL(@retVal, '''')
END


        


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxCoverageFromXML]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxCoverageFromXML]
(
	@coverageXML XML
)
RETURNS @eRxCoverage TABLE
(
	Payor VARCHAR (100),
	PayorID VARCHAR (100),
	LastName VARCHAR (50),
	FirstName VARCHAR (50),
	MiddleName VARCHAR (50),
	Prefix VARCHAR (25),
	Suffix VARCHAR (50),
	DOB DATETIME,
	Gender VARCHAR (1),
	Address1 VARCHAR (100),
	Address2 VARCHAR (100),
	City VARCHAR (25),
	State VARCHAR (3),
	Zip VARCHAR (10),
	RelationshipCode VARCHAR (2),
	Relationship VARCHAR (100),
	StudentStatus VARCHAR (100),
	SubcriberID VARCHAR (100),
	HealthPlanName VARCHAR (100),
	HealthPlanID VARCHAR (100),
	CardholderName VARCHAR (100),
	CardholderID VARCHAR (100),
	PersonCode VARCHAR (25),
	GroupName VARCHAR (100),
	GroupID VARCHAR (100),
	BIN VARCHAR (100),
	PCN VARCHAR (100),
	FormularyID VARCHAR (100),
	AlternativesID VARCHAR (100),
	CoverageID VARCHAR (100),
	CopayID VARCHAR (100),
	ServiceDate DATETIME,
	EligibilityDate DATETIME,
	PharmacyEligible BIT,
	MailOrderEligible BIT
)
AS
BEGIN
	DECLARE @subcriberXML XML,
		@dependentXML XML,
		@coverageInfoXML XML
	
	SELECT 
		@subcriberXML = x.n.query(''subcriber''),
		@dependentXML = x.n.query(''dependent'')
	FROM @coverageXML.nodes(''//coverage'') AS x(n)
	
	SET	@coverageInfoXML =	CASE WHEN @dependentXML IS NOT NULL AND LEN (CAST (@dependentXML AS VARCHAR (MAX))) > 0 THEN @dependentXML
								 ELSE @subcriberXML
							END;
	
	WITH cteeRxCoverage AS
	(
		SELECT 
	-- Payor information
			(SELECT x.n.value(''@organizationName'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//payor'') AS x(n)) AS Payor,
			(SELECT x.n.value(''@ParticipantID'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//payor'') AS x(n)) AS PayorID,

	-- subcriber information
			(SELECT x.n.value(''@lastName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberLastName,
			(SELECT x.n.value(''@firstName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberFirstName,
			(SELECT x.n.value(''@middleName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberMiddleName,
			(SELECT x.n.value(''@prefix'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberPrefix,
			(SELECT x.n.value(''@suffix'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberSuffix,
			(SELECT x.n.value(''@DOB'',''datetime'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberDOB,
			(SELECT x.n.value(''@gender'',''varchar(1)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberGender,
			(SELECT x.n.value(''@address1'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberAddress1,
			(SELECT x.n.value(''@address2'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberAddress2,
			(SELECT x.n.value(''@city'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberCity,
			(SELECT x.n.value(''@state'',''varchar(3)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberState,
			(SELECT x.n.value(''@zip'',''varchar(10)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberZip,
			(SELECT x.n.value(''@relationshipCode'',''varchar(2)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberRelationshipCode,
			(SELECT x.n.value(''@relationship'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberRelationship,
			(SELECT x.n.value(''@studentStatus'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberStudentStatus,
			 
	-- dependent information
			(SELECT x.n.value(''@lastName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentLastName,
			(SELECT x.n.value(''@firstName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentFirstName,
			(SELECT x.n.value(''@middleName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentMiddleName,
			(SELECT x.n.value(''@prefix'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentPrefix,
			(SELECT x.n.value(''@suffix'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentSuffix,
			(SELECT x.n.value(''@DOB'',''datetime'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentDOB,
			(SELECT x.n.value(''@gender'',''varchar(1)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentGender,
			(SELECT x.n.value(''@address1'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentAddress1,
			(SELECT x.n.value(''@address2'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentAddress2,
			(SELECT x.n.value(''@city'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentCity,
			(SELECT x.n.value(''@state'',''varchar(3)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentState,
			(SELECT x.n.value(''@zip'',''varchar(10)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentZip,
			(SELECT x.n.value(''@relationshipCode'',''varchar(2)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentRelationshipCode,
			(SELECT x.n.value(''@relationship'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentRelationship,
			(SELECT x.n.value(''@studentStatus'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentStudentStatus,
			 
	-- Coverage information
			(SELECT x.n.value(''@SubcriberID'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS SubcriberID,
			 
			(SELECT x.n.value(''@HealthPlanName'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''18'''']'') AS x(n)) AS HealthPlanName,
			(SELECT x.n.value(''@HealthPlanID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''18'''']'') AS x(n)) AS HealthPlanID,
			(SELECT x.n.value(''@CardholderName'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''1W'''']'') AS x(n)) AS CardholderName,
			(SELECT x.n.value(''@CardholderID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''1W'''']'') AS x(n)) AS CardholderID,
			(SELECT x.n.value(''@PersonCode'',''varchar(25)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''49'''']'') AS x(n)) AS PersonCode,
			(SELECT x.n.value(''@GroupName'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''6P'''']'') AS x(n)) AS GroupName,
			(SELECT x.n.value(''@GroupID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''6P'''']'') AS x(n)) AS GroupID,
			(SELECT x.n.value(''@BIN'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''N6'''']'') AS x(n)) AS BIN,
			(SELECT x.n.value(''@PCN'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''N6'''']'') AS x(n)) AS PCN,
			(SELECT x.n.value(''@FormularyID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''IF'''']'') AS x(n)) AS FormularyID,
			(SELECT x.n.value(''@AlternativesID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''IF'''']'') AS x(n)) AS AlternativesID,
			(SELECT x.n.value(''@CoverageID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''1L'''']'') AS x(n)) AS CoverageID,
			(SELECT x.n.value(''@CopayID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''IG'''']'') AS x(n)) AS CopayID,
			(SELECT x.n.value(''@ServiceDate'',''datetime'')
			 FROM @coverageInfoXML.nodes(''//subcriberDates/subcriberDate[@dtpQualifier = ''''472'''']'') AS x(n)) AS ServiceDate,
			(SELECT x.n.value(''@EligibilityDate'',''datetime'')
			 FROM @coverageInfoXML.nodes(''//subcriberDates/subcriberDate[@dtpQualifier = ''''307'''']'') AS x(n)) AS EligibilityDate,
			(SELECT x.n.value(''@coverageTypeCode'',''varchar(10)'')
			 FROM @coverageInfoXML.nodes(''//eligibility[@serviceTypeCode = ''''88'''']'') AS x(n)) AS PharmacyEligible,
			(SELECT x.n.value(''@coverageTypeCode'',''varchar(10)'')
			 FROM @coverageInfoXML.nodes(''//eligibility[@serviceTypeCode = ''''90'''']'') AS x(n)) AS MailOrderEligible
	)
	INSERT @eRxCoverage
	SELECT
		CASE WHEN Payor = '''' THEN NULL ELSE Payor END AS Payor,
		CASE WHEN PayorID = '''' THEN NULL ELSE PayorID END AS PayorID,
		COALESCE (dependentLastName, subcriberLastName) AS LastName,
		COALESCE (dependentFirstName, subcriberFirstName) AS FirstName,
		CASE WHEN COALESCE (dependentMiddleName, subcriberMiddleName) = '''' THEN NULL
			ELSE COALESCE (dependentMiddleName, subcriberMiddleName) END AS MiddleName,
		CASE WHEN COALESCE (dependentPrefix, subcriberPrefix) = '''' THEN NULL
			ELSE COALESCE (dependentPrefix, subcriberPrefix) END AS Prefix,
		CASE WHEN COALESCE (dependentSuffix, subcriberSuffix) = '''' THEN NULL
			ELSE COALESCE (dependentSuffix, subcriberSuffix) END AS Suffix,
		COALESCE (dependentDOB, subcriberDOB) AS DOB,
		COALESCE (dependentGender, subcriberGender) AS Gender,
		COALESCE (dependentAddress1, subcriberAddress1) AS Address1,
		CASE WHEN COALESCE (dependentAddress2, subcriberAddress2) = '''' THEN NULL
			ELSE COALESCE (dependentAddress2, subcriberAddress2) END AS Address2,
		COALESCE (dependentCity, subcriberCity) AS City,
		COALESCE (dependentState, subcriberState) AS State,
		COALESCE (dependentZip, subcriberZip) AS Zip,
		COALESCE (dependentRelationshipCode, subcriberRelationshipCode) AS RelationshipCode,
		COALESCE (dependentRelationship, subcriberRelationship) AS Relationship,
		COALESCE (dependentStudentStatus, subcriberStudentStatus) AS StudentStatus,
		CASE WHEN SubcriberID = '''' THEN NULL ELSE SubcriberID END AS SubcriberID,
		CASE WHEN HealthPlanName = '''' THEN NULL ELSE HealthPlanName END AS HealthPlanName,
		CASE WHEN HealthPlanID = '''' THEN NULL ELSE HealthPlanID END AS HealthPlanID,
		CASE WHEN CardholderName = '''' THEN NULL ELSE CardholderName END AS CardholderName,
		CASE WHEN CardholderID = '''' THEN NULL ELSE CardholderID END AS CardholderID,
		CASE WHEN PersonCode = '''' THEN NULL ELSE PersonCode END AS PersonCode,
		CASE WHEN GroupName = '''' THEN NULL ELSE GroupName END AS GroupName,
		CASE WHEN GroupID = '''' THEN NULL ELSE GroupID END AS GroupID,
		CASE WHEN BIN = '''' THEN NULL ELSE BIN END AS BIN,
		CASE WHEN PCN = '''' THEN NULL ELSE PCN END AS PCN,
		CASE WHEN FormularyID = '''' THEN NULL ELSE FormularyID END AS FormularyID,
		CASE WHEN AlternativesID = '''' THEN NULL ELSE AlternativesID END AS AlternativesID,
		CASE WHEN CoverageID = '''' THEN NULL ELSE CoverageID END AS CoverageID,
		CASE WHEN CopayID = '''' THEN NULL ELSE CopayID END AS CopayID,
		CASE WHEN ServiceDate = '''' THEN NULL ELSE ServiceDate END AS ServiceDate,
		CASE WHEN EligibilityDate = '''' THEN NULL ELSE EligibilityDate END AS EligibilityDate,
		CASE WHEN PharmacyEligible = ''1'' THEN PharmacyEligible ELSE 0 END AS PharmacyEligible,
		CASE WHEN MailOrderEligible = ''1'' THEN MailOrderEligible ELSE 0 END AS MailOrderEligible
	FROM cteeRxCoverage
	
	RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound_getRecent]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxOutbound_getRecent] 
(
	@Guid UNIQUEIDENTIFIER
)
RETURNS UNIQUEIDENTIFIER
AS  
BEGIN 

DECLARE @ReturnGuid UNIQUEIDENTIFIER

set @ReturnGuid = null

SELECT TOP 1 @ReturnGuid = eRxOutbound.eRxOutboundUid 
from eRxOutbound 
where (RelVisitMedicationUid = @Guid)
order by LastModifiedDate desc

RETURN @ReturnGuid

END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound_getRecentLastModifiedDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxOutbound_getRecentLastModifiedDate] 
(
	@Guid UNIQUEIDENTIFIER
)
RETURNS DATETIME
AS  
BEGIN 

DECLARE @Return DATETIME

set @Return = null

SELECT TOP 1 @Return = eRxOutbound.LastModifiedDate 
from eRxOutbound 
where (RelVisitMedicationUid = @Guid)
order by LastModifiedDate desc

RETURN @Return

END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound_getRecentSuccessful]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxOutbound_getRecentSuccessful] 
(
	@Guid UNIQUEIDENTIFIER
)
RETURNS BIT
AS  
BEGIN 

DECLARE @Return BIT

set @Return = null

SELECT TOP 1 @Return = eRxOutbound.Successful 
from eRxOutbound 
where (RelVisitMedicationUid = @Guid)
order by LastModifiedDate desc

RETURN @Return

END
 
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EscapeXmlElementName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[EscapeXmlElementName](@xml VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN
	SET @xml = REPLACE(@xml, ''&'', '''')
	SET @xml = REPLACE(@xml, ''>'', '''')
	SET @xml = REPLACE(@xml, ''<'', '''')
	SET @xml = REPLACE(@xml, ''"'', '''')
	SET @xml = REPLACE(@xml, '''''''', '''')
	SET @xml = REPLACE(@xml, ''+'', '''')
	SET @xml = REPLACE(@xml, ''|'', '''')
    SET @xml = REPLACE(@xml,'' '','''')

    DECLARE @FirstChar VARCHAR = NULL
    SET @FirstChar = LEFT(@xml,1)
	IF ASCII(UPPER(@FirstChar)) NOT BETWEEN 65 AND 90
	BEGIN
	    IF ASCII(@FirstChar) BETWEEN 48 AND 57
		BEGIN
            SET @xml = ''NUM_'' + @xml
		END
		ELSE
		BEGIN
			SET @xml = ''SCHAR_'' + @xml
		END
	END

	RETURN @xml
END

/*
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''9'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''_game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''&game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''"game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''>game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''<game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''+ga-me'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''-|game'')+'' />'')
*/' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EZPAY_getNextDetailRec]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- =============================================
-- Author:		Patrick Pappenfus, Wiregrass Solutions,  LLC
-- Create date: 1/22/2008
-- Description:	Function for retrieving next Settlement Detail RecNo.
-- =============================================
CREATE FUNCTION [dbo].[EZPAY_getNextDetailRec] 
(
)
RETURNS int
AS
BEGIN
	DECLARE @nextrec int

    SELECT @nextrec = case when max(recno) is null then 1 else MAX(RECNO) + 1 end FROM EZPAYSETTLEMENT_DETAILS
	RETURN @nextrec 
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EZPAY_getNextHistoryRecNo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =============================================
-- Author:		Patrick Pappenfus, Wiregrass Solutions,  LLC
-- Create date: 1/22/2008
-- Description:	Function for retrieving next History RecNo.
-- =============================================
CREATE FUNCTION [dbo].[EZPAY_getNextHistoryRecNo] 
(
)
RETURNS int
AS
BEGIN
	DECLARE @nextrec int

	SELECT @nextrec = MAX(RECNO) + 1 FROM EZPAYSETTLEMENT_HISTORY
    IF @nextrec IS NULL SELECT @nextrec = 1 

	RETURN @nextrec
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EZPAY_getNextMerchRec]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		Patrick Pappenfus, Wiregrass Solutions,  LLC
-- Create date: 1/22/2008
-- Description:	Function for retrieving next merchant rec no.
-- =============================================
CREATE FUNCTION [dbo].[EZPAY_getNextMerchRec] 
(
)
RETURNS int
AS
BEGIN
	DECLARE @nextrec int

	SELECT @nextrec = MAX(MERCH_REC) + 1 FROM EZPAYMERCHANT_SETTINGS

	RETURN @nextrec
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FDBSearchString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[FDBSearchString](@MedDesc VARCHAR(125)) RETURNS VARCHAR(125) AS
BEGIN
   RETURN UPPER(RTRIM(LTRIM((
                   REPLACE(REPLACE(REPLACE(
                   REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                   REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(@MedDesc, ''.'', ''''), '''''''', ''''), ''"'', ''''), ''#'', ''''), ''!'', ''''), ''%'', ''''),
                                                                             ''/'', '' ''), ''+'', '' ''), ''-'', '' ''), ''_'', '' ''), ''('', '' ''), '')'', '' ''), ''<'', '' ''), ''>'', '' ''), '','', '' ''), '':'', '' ''),
                                                                             ''  '', '' ''), ''  '', '' ''), ''  '', '' '')))))
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FirstDayOfWeek]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[FirstDayOfWeek] 
(
    @date DATETIME
)
RETURNS DATETIME
AS
BEGIN
	DECLARE @dtFirstDayOfWeek DATETIME
    SET @dtFirstDayOfWeek = CAST (CONVERT (VARCHAR (16), DATEADD(DD, 1 - DATEPART(DW, @date), @date), 101) AS DATETIME)
	RETURN @dtFirstDayOfWeek
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_GetCQMSystemCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[fn_GetCQMSystemCode]()
RETURNS @CodeSystem TABLE
(
	RootID		VARCHAR(50),
	CodeSystem	VARCHAR(50)
)
--SELECT * FROM DBO.fn_GetCQMSystemCOde()
/*
Since we do not store the name assocaited to a root ID anywhere, I created a table valued function that 
can be used by whatever code needs to have that name.
*/
AS
BEGIN
	INSERT INTO @CodeSystem
	VALUES
	(''2.16.840.1.113883.6.96''		,''SNOMED''				),
	(''2.16.840.1.113883.6.4''		,''LOINC''				),
	(''2.16.840.1.113883.3.221.5''	,''SOP''					),  
	(''2.16.840.1.113883.6.13''		,''CDT''					),
	(''2.16.840.1.113883.6.285''		,''HCPCS''				),
	(''2.16.840.1.113883.6.104''		,''ICD-9-PCS''			),
	(''2.16.840.1.113883.6.90''		,''ICD-10-CM''			),
	(''2.16.840.1.113883.6.12''		,''CPT''					),
	(''2.16.840.1.113883.6.238''		,''CDCREC Race/Ethnicity''),
	(''2.16.840.1.113883.6.1''		,''LOINC''				),
	(''2.16.840.1.113883.12.292''		,''CVX''					),
	(''2.16.840.1.113883.6.103''		,''ICD-9-CM''				),
	(''2.16.840.1.113883.5.1''		,''AdministrativeGender''	),
	(''2.16.840.1.113883.6.88''		,''RxNorm''				),
	(''2.16.840.1.113883.18.2''		,''AdministrativeSex''	)
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCopayDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[FormularyCopayDescription](
   @FlatCopayAmount       VARCHAR(10),
   @PercentCopayRate      VARCHAR(10),
   @FirstCopayTerm        VARCHAR(1),
   @MinimumCopay          VARCHAR(10),
   @MaximumCopay          VARCHAR(10),
   @DaysSupplyPerCopay    VARCHAR(3),
   @CopayTier             VARCHAR(2),
   @MaximumCopayTier      VARCHAR(2),
   @OutOfPocketRangeStart VARCHAR(10),
   @OutOfPocketRangeEnd   VARCHAR(10)) RETURNS VARCHAR(MAX) AS
BEGIN
   RETURN CASE
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') != ''P'' AND @PercentCopayRate IS NOT NULL THEN ''$'' + @FlatCopayAmount + '' + ''
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') != ''P'' THEN ''$'' + @FlatCopayAmount
              ELSE ''''
           END +
           CASE
              WHEN @PercentCopayRate IS NOT NULL THEN CONVERT(VARCHAR(10), CONVERT(INT, CONVERT(MONEY, @PercentCopayRate) * 100)) + ''%''
              ELSE ''''
           END +
           CASE
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') = ''P'' AND @PercentCopayRate IS NOT NULL THEN '' + $'' + @FlatCopayAmount
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') = ''P'' THEN ''$'' + @FlatCopayAmount
              ELSE ''''
           END +
           CASE
              WHEN @PercentCopayRate IS NOT NULL THEN
                   CASE
                      WHEN @MinimumCopay IS NOT NULL AND @MaximumCopay IS NOT NULL
                         THEN '' (Min:$'' + @MinimumCopay  + '' Max:$'' + @MaximumCopay + '')''
                      WHEN @MinimumCopay IS NOT NULL
                         THEN '' (Min:$'' + @MinimumCopay  + '')''
                      WHEN @MaximumCopay IS NOT NULL
                         THEN '' (Max:$'' + @MaximumCopay  + '')''
                      ELSE ''''
                   END
              ELSE ''''
           END +
           CASE
              WHEN @CopayTier IS NOT NULL AND (@FlatCopayAmount IS NOT NULL OR @PercentCopayRate IS NOT NULL) THEN '', Tier '' + @CopayTier
              WHEN @CopayTier IS NOT NULL THEN ''Tier '' + @CopayTier
              ELSE ''''
           END +
           CASE
              WHEN @MaximumCopayTier IS NOT NULL THEN '', Max Tier '' + @MaximumCopayTier
              ELSE ''''
           END +
           CASE WHEN @DaysSupplyPerCopay IS NOT NULL
              THEN '', '' + @DaysSupplyPerCopay + '' Days Supply''
              ELSE ''''
           END +
           CASE WHEN @OutOfPocketRangeStart IS NOT NULL AND @OutOfPocketRangeEnd IS NOT NULL
              THEN '' With Out Of Pocket Range ($'' + @OutOfPocketRangeStart + '' - $'' + @OutOfPocketRangeEnd + '')''
              ELSE ''''
           END +
           CASE WHEN @OutOfPocketRangeStart IS NOT NULL AND @OutOfPocketRangeEnd IS NULL
              THEN '' With Out Of Pocket Range ($'' + @OutOfPocketRangeStart + '' with no upper range)''
              ELSE ''''
           END
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FromASCII]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[FromASCII](@src [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[FromASCII]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FromBase64]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[FromBase64]
(
	@data [VARCHAR](MAX)
)
RETURNS [VARCHAR](MAX)
AS
BEGIN
	IF @data IS NOT NULL AND LEN(@data) > 0
	BEGIN
		RETURN (SELECT CAST(CAST(N'''' AS XML).value(''xs:base64Binary(sql:variable("@data"))'', ''VARBINARY(MAX)'') AS VARCHAR(MAX)))
	END
	RETURN NULL
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Get_ElectronicPayer_Conversion_From_PracticeSolutions_To_eMEDIX]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Get_ElectronicPayer_Conversion_From_PracticeSolutions_To_eMEDIX]()
RETURNS @resultTable TABLE
(
  Payer_Name Varchar(150),
  eMEDIX_Payer_Code VarChar(25),
  PracticeInsights_Payer_Code VarChar(25),
  Type Varchar(20)
)
AS
BEGIN
  INSERT INTO @resultTable (Payer_Name, eMEDIX_Payer_Code, PracticeInsights_Payer_Code, Type)
  select * from 
  ( VALUES 
(''1199 National Benefit Fund'', ''13162'', ''13162'', ''Institutional''),
(''1199 National Benefit Fund'', ''13162'', ''13162'', ''Professional''),
(''1st Auto & Casualty'', ''J1585'', ''J1585'', ''Institutional''),
(''1st Auto & Casualty'', ''J1585'', ''J1585'', ''Professional''),
(''2020 Eyecare'', ''2020E'', ''2020E'', ''Professional''),
(''21st Century Insurance'', ''41556'', ''41556'', ''Institutional''),
(''21st Century Insurance'', ''41556'', ''41556'', ''Professional''),
(''22125 Roscoe Corp.'', ''41556'', ''41556'', ''Institutional''),
(''22125 Roscoe Corp.'', ''41556'', ''41556'', ''Professional''),
(''6 Degrees Health, Inc.'', ''20446'', ''20446'', ''Institutional''),
(''6 Degrees Health, Inc.'', ''20446'', ''20446'', ''Professional''),
(''90 Degree Benefits - Covenant Administrators, Inc. - Atlanta, GA'', ''58102'', ''58102'', ''Institutional''),
(''90 Degree Benefits - Covenant Administrators, Inc. - Atlanta, GA'', ''58102'', ''58102'', ''Professional''),
(''A & I Benefit Plan Administrators'', ''93044'', ''93044'', ''Institutional''),
(''A & I Benefit Plan Administrators'', ''93044'', ''93044'', ''Professional''),
(''A. W. Holdings LLC dba Benchmark'', ''J1976'', ''J1976'', ''Institutional''),
(''A. W. Holdings LLC dba Benchmark'', ''LS444'', ''J1976'', ''Professional''),
(''AAA Minnesota'', ''11983'', ''11983'', ''Institutional''),
(''AAA Minnesota'', ''11983'', ''11983'', ''Professional''),
(''AAA Northern California, Nevada & Utah Insurance Exchange'', ''41556'', ''41556'', ''Institutional''),
(''AAA Northern California, Nevada & Utah Insurance Exchange'', ''41556'', ''41556'', ''Professional''),
(''AAG Benefit Plan Administrators'', ''75240'', ''75240'', ''Institutional''),
(''AAG Benefit Plan Administrators'', ''75240'', ''75240'', ''Professional''),
(''AARP Medicare Complete'', ''87726'', ''87726'', ''Institutional''),
(''AARP Medicare Complete'', ''87726'', ''87726'', ''Professional''),
(''AARP United Healthcare Supplemental Plan Only'', ''36273'', ''36273'', ''Institutional''),
(''AARP United Healthcare Supplemental Plan Only'', ''36273'', ''36273'', ''Professional''),
(''ABC Const. Company'', ''41556'', ''41556'', ''Institutional''),
(''ABC Const. Company'', ''41556'', ''41556'', ''Professional''),
(''Absolute Total Care - South Carolina'', ''68069'', ''68069'', ''Institutional''),
(''Absolute Total Care - South Carolina'', ''68069'', ''68069'', ''Professional''),
(''Acadia Insurance Company'', ''J1477'', ''J1477'', ''Institutional''),
(''Acadia Insurance Company'', ''J1477'', ''J1477'', ''Professional''),
(''Access Administrators (Texas)'', ''AHS01'', ''AHS01'', ''Institutional''),
(''Access Administrators (Texas)'', ''AHS01'', ''AHS01'', ''Professional''),
(''Access Health Services - Arkansas Superior Select'', ''61184'', ''61184'', ''Institutional''),
(''Access Health Services - Arkansas Superior Select'', ''61184'', ''61184'', ''Professional''),
(''Access Medical Group'', ''AMG02'', ''AMG02'', ''Institutional''),
(''Access Medical Group'', ''AMG02'', ''AMG02'', ''Professional''),
(''Access Santa Monica (Access Medical Group)'', ''AMG02'', ''AMG02'', ''Institutional''),
(''Access Santa Monica (Access Medical Group)'', ''AMG02'', ''AMG02'', ''Professional''),
(''Accident Fund Insurance Co of America'', ''J1790'', ''J1790'', ''Institutional''),
(''Accident Fund Insurance Co of America'', ''J1790'', ''J1790'', ''Professional''),
(''Acclaim'', ''64071'', ''64071'', ''Institutional''),
(''Acclaim'', ''64071'', ''64071'', ''Professional''),
(''Acclaim IPA'', ''MHIPA'', ''MHIPA'', ''Professional''),
(''Acclaim IPA (MHCAC)'', ''MHIPA'', ''MHIPA'', ''Professional''),
(''Accountable Health Plan of Ohio (AHPO)'', ''31138'', ''31138'', ''Institutional''),
(''Accountable Health Plan of Ohio (AHPO)'', ''31138'', ''31138'', ''Professional''),
(''Accountable HealthCare IPA'', ''AHIPA'', ''AHIPA'', ''Professional''),
(''Accountable IPA'', ''AHIPA'', ''AHIPA'', ''Institutional''),
(''Accountable IPA'', ''AHIPA'', ''AHIPA'', ''Professional''),
(''Accuride Corporation'', ''J1024'', ''J1024'', ''Institutional''),
(''Accuride Corporation'', ''J1024'', ''J1024'', ''Professional''),
(''Ace Property & Casualty Ins Co'', ''41556'', ''41556'', ''Institutional''),
(''Ace Property & Casualty Ins Co'', ''41556'', ''41556'', ''Professional''),
(''ACIG  Insurance Company'', ''J1578'', ''J1578'', ''Institutional''),
(''ACIG  Insurance Company'', ''J1578'', ''J1578'', ''Professional''),
(''ACS Benefit & Consulting Services, Inc.'', ''72467'', ''72467'', ''Institutional''),
(''ACS Benefit & Consulting Services, Inc.'', ''72467'', ''72467'', ''Professional''),
(''ACS Benefits / Payer Compass'', ''PA331'', ''PA331'', ''Institutional''),
(''ACS Benefits / Payer Compass'', ''PA331'', ''PA331'', ''Professional''),
(''Active Care, Inc'', ''66310'', ''J3840'', ''Professional''),
(''Active Care, Inc'', ''J3840'', ''J3840'', ''Institutional''),
(''ActivHealthCare'', ''AHC01'', ''AHC01'', ''Professional''),
(''Acuity, A Mutual Insurance Company'', ''J1240'', ''J1240'', ''Institutional''),
(''Acuity, A Mutual Insurance Company'', ''J1240'', ''J1240'', ''Professional''),
(''AD-COMP'', ''J1667'', ''J1667'', ''Institutional''),
(''AD-COMP'', ''J1667'', ''J1667'', ''Professional''),
(''Adelanto Correctional Facility (CA)'', ''J1798'', ''J1798'', ''Institutional''),
(''Adelanto Correctional Facility (CA)'', ''J1798'', ''J1798'', ''Professional''),
(''Adelanto School District (CA)'', ''J1690'', ''J1690'', ''Institutional''),
(''Adelanto School District (CA)'', ''J1690'', ''J1690'', ''Professional''),
(''Administaff'', ''J1241'', ''J1241'', ''Institutional''),
(''Administaff'', ''J1241'', ''J1241'', ''Professional''),
(''Administration Services, Inc. (ASI)'', ''ADSER'', ''PAPER'', ''Institutional''),
(''Administration Services, Inc. (ASI)'', ''ADSER'', ''PAPER'', ''Professional''),
(''Administration Systems Research Corporation (ASR)'', ''38265'', ''38265'', ''Institutional''),
(''Administration Systems Research Corporation (ASR)'', ''38265'', ''38265'', ''Professional''),
(''Administrative Claim Service, Inc'', ''J1005'', ''J1005'', ''Institutional''),
(''Administrative Claim Service, Inc'', ''J1005'', ''J1005'', ''Professional''),
(''Administrative Concepts, Inc.'', ''22384'', ''22384'', ''Institutional''),
(''Administrative Concepts, Inc.'', ''22384'', ''22384'', ''Professional''),
(''Administrative Services, Inc'', ''59141'', ''59141'', ''Institutional''),
(''Administrative Services, Inc'', ''59141'', ''59141'', ''Professional''),
(''Administrative Solutions, Inc.'', ''ADSOL'', ''PAPER'', ''Institutional''),
(''Administrative Solutions, Inc.'', ''ADSOL'', ''PAPER'', ''Professional''),
(''ADP Total Source Inc.'', ''J1242'', ''J1242'', ''Professional''),
(''Advance America Cash Advance Centers'', ''J1843'', ''J1843'', ''Institutional''),
(''Advance America Cash Advance Centers'', ''J1843'', ''J1843'', ''Professional''),
(''Advance Services, Inc.'', ''J1608'', ''J1608'', ''Institutional''),
(''Advance Services, Inc.'', ''J1608'', ''J1608'', ''Professional''),
(''Advanced Benefit Solutions - Tribal Health'', ''ADVTH'', ''ADVTH'', ''Professional''),
(''Advanced Data Solutions, Inc.'', ''58202'', ''58202'', ''Institutional''),
(''Advanced Data Solutions, Inc.'', ''58202'', ''58202'', ''Professional''),
(''Advanced Medical Doctors of California'', ''AMDC1'', ''AMDC1'', ''Institutional''),
(''Advanced Medical Doctors of California'', ''AMDC1'', ''AMDC1'', ''Professional''),
(''Advantage Care IPA'', ''ACIPA'', ''ACIPA'', ''Institutional''),
(''Advantage Care IPA'', ''ACIPA'', ''ACIPA'', ''Professional''),
(''Advantage Health Network IPA'', ''NMM01'', ''NMM01'', ''Professional''),
(''Advantek Benefit Administrators'', ''83077'', ''83077'', ''Institutional''),
(''Advantek Benefit Administrators'', ''83077'', ''83077'', ''Professional''),
(''Advantica Benefits'', ''59374'', ''59374'', ''Institutional''),
(''Advantica Benefits'', ''59374'', ''59374'', ''Professional''),
(''Adventist Health Hanford AHP'', ''MPM36'', ''MPM36'', ''Institutional''),
(''Adventist Health Plan'', ''MPM37'', ''MPM37'', ''Institutional''),
(''Adventist Health Plan'', ''MPM37'', ''MPM37'', ''Professional''),
(''Adventist Health Plan Provider Network (AHPPN)'', ''MPM37'', ''MPM38'', ''Professional''),
(''Adventist Health System (Bunch CareSolutions)'', ''J1973'', ''J1973'', ''Institutional''),
(''Adventist Health System (Bunch CareSolutions)'', ''J1973'', ''J1973'', ''Professional''),
(''Adventist Health System West'', ''95340'', ''95340'', ''Institutional''),
(''Adventist Health System West'', ''95340'', ''95340'', ''Professional''),
(''Adventist White Memorial - Crown City Medical Group'', ''MPM33'', ''MPM33'', ''Institutional''),
(''Adventist White Memorial - Crown City Medical Group'', ''MPM33'', ''MPM33'', ''Professional''),
(''Adventist White Memorial - Southland San Gabriel Valley'', ''MPM34'', ''MPM34'', ''Institutional''),
(''Adventist White Memorial - Southland San Gabriel Valley'', ''MPM34'', ''MPM34'', ''Professional''),
(''Advocare MCO, Inc'', ''J1896'', ''J1896'', ''Institutional''),
(''Advocare MCO, Inc'', ''J1896'', ''J1896'', ''Professional''),
(''Advocate Health Partners (PHO''''s)'', ''65093'', ''65093'', ''Institutional''),
(''Advocate Health Partners (PHO''''s)'', ''65093'', ''65093'', ''Professional''),
(''Advocate Medical Group'', ''36320'', ''36320'', ''Institutional''),
(''Advocate Medical Group'', ''36320'', ''36320'', ''Professional''),
(''Aegis Administrative Services'', ''CB637'', ''CB637'', ''Institutional''),
(''Aegis Administrative Services'', ''CB637'', ''CB637'', ''Professional''),
(''Aetna (Encounters Only)'', ''60055'', ''60055'', ''Professional''),
(''Aetna - Innovation Health Leap'', ''60054'', ''60054'', ''Institutional''),
(''Aetna - Innovation Health Leap'', ''60054'', ''60054'', ''Professional''),
(''Aetna - Mail Handlers Benefit Plan (MBHP)'', ''60054'', ''60054'', ''Institutional''),
(''Aetna - Mail Handlers Benefit Plan (MBHP)'', ''60054'', ''60054'', ''Professional''),
(''Aetna / US Healthcare (All Plans)'', ''60054'', ''60054'', ''Institutional''),
(''Aetna / US Healthcare (All Plans)'', ''60054'', ''60054'', ''Professional''),
(''Aetna Affordable Health Choices - SRC'', ''57604'', ''57604'', ''Institutional''),
(''Aetna Affordable Health Choices - SRC'', ''57604'', ''57604'', ''Professional''),
(''Aetna Better Health Illinois - Medicaid'', ''68024'', ''68024'', ''Institutional''),
(''Aetna Better Health Illinois - Medicaid'', ''68024'', ''68024'', ''Professional''),
(''Aetna Better Health Illinois - Premier Plan MMAI'', ''26337'', ''26337'', ''Institutional''),
(''Aetna Better Health Illinois - Premier Plan MMAI'', ''26337'', ''26337'', ''Professional''),
(''Aetna Better Health of California'', ''128CA'', ''128CA'', ''Institutional''),
(''Aetna Better Health of California'', ''128CA'', ''128CA'', ''Professional''),
(''Aetna Better Health of Florida'', ''128FL'', ''128FL'', ''Institutional''),
(''Aetna Better Health of Florida'', ''128FL'', ''128FL'', ''Professional''),
(''Aetna Better Health of Kansas'', ''128KS'', ''128KS'', ''Institutional''),
(''Aetna Better Health of Kansas'', ''128KS'', ''128KS'', ''Professional''),
(''Aetna Better Health of Kentucky'', ''128KY'', ''128KY'', ''Institutional''),
(''Aetna Better Health of Kentucky'', ''128KY'', ''128KY'', ''Professional''),
(''Aetna Better Health of Louisiana'', ''128LA'', ''128LA'', ''Institutional''),
(''Aetna Better Health of Louisiana'', ''128LA'', ''128LA'', ''Professional''),
(''Aetna Better Health of Maryland'', ''128MD'', ''128MD'', ''Institutional''),
(''Aetna Better Health of Maryland'', ''128MD'', ''128MD'', ''Professional''),
(''Aetna Better Health of Michigan'', ''128MI'', ''128MI'', ''Institutional''),
(''Aetna Better Health of Michigan'', ''128MI'', ''128MI'', ''Professional''),
(''Aetna Better Health of New Jersey'', ''46320'', ''46320'', ''Institutional''),
(''Aetna Better Health of New Jersey'', ''46320'', ''46320'', ''Professional''),
(''Aetna Better Health of New York'', ''34734'', ''34734'', ''Institutional''),
(''Aetna Better Health of New York'', ''34734'', ''34734'', ''Professional''),
(''Aetna Better Health of Ohio'', ''50023'', ''50023'', ''Institutional''),
(''Aetna Better Health of Ohio'', ''50023'', ''50023'', ''Professional''),
(''Aetna Better Health of Texas Medicaid and CHIP'', ''38692'', ''38692'', ''Institutional''),
(''Aetna Better Health of Texas Medicaid and CHIP'', ''38692'', ''38692'', ''Professional''),
(''Aetna Better Health of Virginia'', ''128VA'', ''128VA'', ''Institutional''),
(''Aetna Better Health of Virginia'', ''128VA'', ''128VA'', ''Professional''),
(''Aetna Better Health of West Virginia'', ''128WV'', ''128WV'', ''Institutional''),
(''Aetna Better Health of West Virginia'', ''128WV'', ''128WV'', ''Professional''),
(''Aetna Better Health Pennsylvania Medicaid'', ''23228'', ''23228'', ''Institutional''),
(''Aetna Better Health Pennsylvania Medicaid'', ''23228'', ''23228'', ''Professional''),
(''Aetna Leap'', ''60054'', ''60054'', ''Institutional''),
(''Aetna Leap'', ''60054'', ''60054'', ''Professional''),
(''Affiliated Doctors of Orange County'', ''ADOCS'', ''ADOCS'', ''Institutional''),
(''Affiliated Doctors of Orange County'', ''ADOCS'', ''ADOCS'', ''Professional''),
(''Affiliated Partners IPA'', ''POP09'', ''POP09'', ''Professional''),
(''Affiliated Physicians Group'', ''APG01'', ''APG01'', ''Institutional''),
(''Affiliated Physicians Group'', ''APG01'', ''APG01'', ''Professional''),
(''Affinity Health Plan'', ''13334'', ''13334'', ''Institutional''),
(''Affinity Health Plan'', ''13334'', ''13334'', ''Professional''),
(''Affinity Medical Group'', ''46594'', ''46594'', ''Institutional''),
(''Affinity Medical Group'', ''46594'', ''46594'', ''Professional''),
(''Affordable Benefit Administrators'', ''95426'', ''95426'', ''Institutional''),
(''Affordable Benefit Administrators'', ''95426'', ''95426'', ''Professional''),
(''AG Facilities Operations, LLC'', ''41556'', ''41556'', ''Institutional''),
(''AG Facilities Operations, LLC'', ''41556'', ''41556'', ''Professional''),
(''AgeRight Advantage'', ''ARA01'', ''ARA01'', ''Institutional''),
(''AgeRight Advantage'', ''ARA01'', ''ARA01'', ''Professional''),
(''AgeWell New York'', ''AWNY6'', ''AWNY6'', ''Institutional''),
(''AgeWell New York'', ''AWNY6'', ''AWNY6'', ''Professional''),
(''Agri Beef Co.'', ''41556'', ''41556'', ''Institutional''),
(''Agri Beef Co.'', ''41556'', ''41556'', ''Professional''),
(''Agua Caliente'', ''AGUA1'', ''AGUA1'', ''Professional''),
(''Agua Dulce ISD'', ''AGUA1'', ''AGUA1'', ''Professional''),
(''AIG-Chartis (Except WA and HI)'', ''19402'', ''19402'', ''Institutional''),
(''AIG-Chartis (Except WA and HI)'', ''19402'', ''19402'', ''Professional''),
(''Aither Health'', ''64884'', ''64884'', ''Institutional''),
(''Aither Health'', ''64884'', ''64884'', ''Professional''),
(''AKM Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''AKM Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Alameda Alliance for Health'', ''95327'', ''95327'', ''Institutional''),
(''Alameda Alliance for Health'', ''95327'', ''95327'', ''Professional''),
(''Alamitos IPA'', ''AIPAZ'', ''AIPAZ'', ''Professional''),
(''Alamitos IPA'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Alamitos IPA'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Alaska Children''''s Services, Inc.'', ''91136'', ''91136'', ''Institutional''),
(''Alaska Children''''s Services, Inc.'', ''91136'', ''91136'', ''Professional''),
(''Alaska Electrical Health & Welfare Fund'', ''60054'', ''60054'', ''Institutional''),
(''Alaska Electrical Health & Welfare Fund'', ''60054'', ''60054'', ''Professional''),
(''Alaska Laborers Construction Industry Trust'', ''91136'', ''91136'', ''Institutional''),
(''Alaska Laborers Construction Industry Trust'', ''91136'', ''91136'', ''Professional''),
(''Alaska National Insurance'', ''J1577'', ''J1577'', ''Institutional''),
(''Alaska National Insurance'', ''J1577'', ''J1577'', ''Professional''),
(''Alaska Pipe Trades Local 375'', ''91136'', ''91136'', ''Institutional''),
(''Alaska Pipe Trades Local 375'', ''91136'', ''91136'', ''Professional''),
(''Alaska State Employee Association (ASEA) Local 52'', ''ASEA1'', ''PAPER'', ''Institutional''),
(''Alaska State Employee Association (ASEA) Local 52'', ''ASEA1'', ''PAPER'', ''Professional''),
(''Alaska United Food & Commercial Workers Health & Welfare Trust'', ''91136'', ''91136'', ''Institutional''),
(''Alaska United Food & Commercial Workers Health & Welfare Trust'', ''91136'', ''91136'', ''Professional''),
(''Alcoa Fasteners Systems'', ''J1244'', ''J1244'', ''Professional''),
(''Alexian Brothers Community Services PACE'', ''44423'', ''44423'', ''Institutional''),
(''Alexian Brothers Community Services PACE'', ''44423'', ''44423'', ''Professional''),
(''Align Networks (One Call Physical Therapy)'', ''J1716'', ''J1716'', ''Institutional''),
(''Align Networks (One Call Physical Therapy)'', ''J1716'', ''J1716'', ''Professional''),
(''Align Senior Care (MI)'', ''ASMI1'', ''ASMI1'', ''Institutional''),
(''Align Senior Care (MI)'', ''ASMI1'', ''ASMI1'', ''Professional''),
(''Align Senior Care (VA)'', ''ASVA1'', ''ASVA1'', ''Institutional''),
(''Align Senior Care (VA)'', ''ASVA1'', ''ASVA1'', ''Professional''),
(''Aligned Community Physicians'', ''ACP17'', ''ACP17'', ''Institutional''),
(''Aligned Community Physicians'', ''ACP17'', ''ACP17'', ''Professional''),
(''Alignment Health Care'', ''CCHPC'', ''CCHPC'', ''Institutional''),
(''Alignment Health Care'', ''CCHPC'', ''CCHPC'', ''Professional''),
(''AllCare Advantage - Caresource Oregon'', ''MRCHP'', ''MRCHP'', ''Institutional''),
(''AllCare Advantage - Caresource Oregon'', ''MRCHP'', ''MRCHP'', ''Professional''),
(''AllCare Health CCO - Mid Rogue'', ''MRIPA'', ''MRIPA'', ''Institutional''),
(''AllCare Health CCO - Mid Rogue'', ''MRIPA'', ''MRIPA'', ''Professional''),
(''Allegeant'', ''52193'', ''52193'', ''Institutional''),
(''Allegeant'', ''52193'', ''52193'', ''Professional''),
(''Allegheny Technologies'', ''J1245'', ''J1245'', ''Professional''),
(''Allegiance Benefit Plan Management Inc'', ''81040'', ''81040'', ''Institutional''),
(''Allegiance Benefit Plan Management Inc'', ''81040'', ''81040'', ''Professional''),
(''Allen Canning'', ''J1740'', ''J1740'', ''Institutional''),
(''Allen Canning'', ''J1740'', ''J1740'', ''Professional''),
(''Alliance - Alpha Care Gold'', ''ADSL1'', ''ADSL1'', ''Institutional''),
(''Alliance - Alpha Care Gold'', ''ADSL1'', ''ADSL1'', ''Professional''),
(''Alliance Coal Health Plan'', ''93658'', ''93658'', ''Institutional''),
(''Alliance Coal Health Plan'', ''93658'', ''93658'', ''Professional''),
(''Alliance Health System'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Alliance Physicians of the High Desert'', ''22417'', ''22417'', ''Professional''),
(''Alliant Energy'', ''J1619'', ''J1619'', ''Institutional''),
(''Alliant Energy'', ''J1619'', ''J1619'', ''Professional''),
(''Alliant Health Plans of Georgia'', ''58234'', ''58234'', ''Institutional''),
(''Alliant Health Plans of Georgia'', ''58234'', ''58234'', ''Professional''),
(''Allianz Global Assistance'', ''50749'', ''50749'', ''Professional''),
(''Allied Benefit Systems'', ''37308'', ''37308'', ''Institutional''),
(''Allied Benefit Systems'', ''37308'', ''37308'', ''Professional''),
(''Allied Claims Administration, Inc.'', ''J1733'', ''J1733'', ''Institutional''),
(''Allied Claims Administration, Inc.'', ''J1733'', ''J1733'', ''Professional''),
(''Allied Construction (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Allied Construction (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Allied Insurance Companies'', ''J1550'', ''J1550'', ''Institutional''),
(''Allied Insurance Companies'', ''J1550'', ''J1550'', ''Professional''),
(''Allied Pacific of California IPA'', ''NMM01'', ''NMM01'', ''Professional''),
(''Allied Property and Casualty Ins Co'', ''J1550'', ''J1550'', ''Institutional''),
(''Allied Property and Casualty Ins Co'', ''J1550'', ''J1550'', ''Professional''),
(''Allina Health Aetna'', ''54398'', ''54398'', ''Institutional''),
(''Allina Health Aetna'', ''54398'', ''54398'', ''Professional''),
(''Allmerica Financial Benefits Insurance Company'', ''J1589'', ''J1589'', ''Institutional''),
(''Allmerica Financial Benefits Insurance Company'', ''J1589'', ''J1589'', ''Professional''),
(''Allstate - Except New Jersey'', ''C1037'', ''C1037'', ''Institutional''),
(''Allstate - Except New Jersey'', ''C1037'', ''C1037'', ''Professional''),
(''Allstate - NJ Only'', ''C1089'', ''C1089'', ''Institutional''),
(''Allstate - NJ Only'', ''LU610'', ''C1089'', ''Professional''),
(''Allways Health Partners'', ''04293'', ''04293'', ''Institutional''),
(''Allways Health Partners'', ''04293'', ''04293'', ''Professional''),
(''Allwell'', ''68069'', ''68069'', ''Institutional''),
(''Allwell'', ''68069'', ''68069'', ''Professional''),
(''Allwell from Superior HealthPlan (HMO and HMO SNP)'', ''68069'', ''68069'', ''Institutional''),
(''Allwell from Superior HealthPlan (HMO and HMO SNP)'', ''68069'', ''68069'', ''Professional''),
(''AlohaCare'', ''ALOHA'', ''ALOHA'', ''Institutional''),
(''AlohaCare'', ''ALOHA'', ''ALOHA'', ''Professional''),
(''AlohaCare - Medicare Advantage'', ''ALOHA'', ''ALOHA'', ''Institutional''),
(''AlohaCare - Medicare Advantage'', ''ALOHA'', ''ALOHA'', ''Professional''),
(''AlohaCare - Quest'', ''ALOHA'', ''ALOHA'', ''Institutional''),
(''AlohaCare - Quest'', ''ALOHA'', ''ALOHA'', ''Professional''),
(''AlphaCare Medical Group'', ''NMM04'', ''NMM04'', ''Institutional''),
(''AlphaCare Medical Group'', ''NMM04'', ''NMM04'', ''Professional''),
(''Alta Bates Medical Group'', ''A0701'', ''A0701'', ''Institutional''),
(''Alta Bates Medical Group'', ''A0701'', ''A0701'', ''Professional''),
(''Alta Healthcare'', ''41556'', ''41556'', ''Institutional''),
(''Alta Healthcare'', ''41556'', ''41556'', ''Professional''),
(''AltaMed Health Plan'', ''95712'', ''95712'', ''Institutional''),
(''AltaMed Health Plan'', ''95712'', ''95712'', ''Professional''),
(''AltaMed Health Plan'', ''ALTAM'', ''ALTAM'', ''Institutional''),
(''AltaMed Health Plan'', ''ALTAM'', ''ALTAM'', ''Professional''),
(''Alvey Systems (AON Risk)'', ''J1025'', ''J1025'', ''Institutional''),
(''Alvey Systems (AON Risk)'', ''J1025'', ''J1025'', ''Professional''),
(''Alvey Systems (AON Risk) (AUTO ONLY)'', ''J1248'', ''J1248'', ''Institutional''),
(''Alvey Systems (AON Risk) (AUTO ONLY)'', ''J1248'', ''J1248'', ''Professional''),
(''AMA Insurance Agency (American Medical Association)'', ''AMAIA'', ''AMAIA'', ''Institutional''),
(''Amalgamated Life'', ''13550'', ''13550'', ''Institutional''),
(''Amalgamated Life'', ''13550'', ''13550'', ''Professional''),
(''Ambetter Arizona Complete Health'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter Arizona Complete Health'', ''68069'', ''68069'', ''Professional''),
(''Ambetter by Buckeye - Ohio'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter by Buckeye - Ohio'', ''68069'', ''68069'', ''Professional''),
(''Ambetter by CeltiCare - Massachusetts'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter by CeltiCare - Massachusetts'', ''68069'', ''68069'', ''Professional''),
(''Ambetter by Coordinated Care - Washington'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter by Coordinated Care - Washington'', ''68069'', ''68069'', ''Professional''),
(''Ambetter by Magnolia - Mississippi'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter by Magnolia - Mississippi'', ''68069'', ''68069'', ''Professional''),
(''Ambetter by MHS - Indiana'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter by MHS - Indiana'', ''68069'', ''68069'', ''Professional''),
(''Ambetter by Peach State - Georgia'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter by Peach State - Georgia'', ''68069'', ''68069'', ''Professional''),
(''Ambetter by Sunshine - Florida'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter by Sunshine - Florida'', ''68069'', ''68069'', ''Professional''),
(''Ambetter by Superior - Texas'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter by Superior - Texas'', ''68069'', ''68069'', ''Professional''),
(''Ambetter from Sunflower Health Plan'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter from Sunflower Health Plan'', ''68069'', ''68069'', ''Professional''),
(''Ambetter of Arkansas'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter of Arkansas'', ''68069'', ''68069'', ''Professional''),
(''Ambetter of North Carolina'', ''68069'', ''68069'', ''Institutional''),
(''Ambetter of North Carolina'', ''68069'', ''68069'', ''Professional''),
(''AMCO Ins Co'', ''J1550'', ''J1550'', ''Institutional''),
(''AMCO Ins Co'', ''J1550'', ''J1550'', ''Professional''),
(''AmeriBen Solutions, Inc.'', ''75137'', ''75137'', ''Institutional''),
(''AmeriBen Solutions, Inc.'', ''75137'', ''75137'', ''Professional''),
(''America First'', ''J1427'', ''J1427'', ''Institutional''),
(''America First'', ''J1427'', ''J1427'', ''Professional''),
(''America''''s 1st Choice Health Plans of North Carolina'', ''AMER1'', ''PAPER'', ''Institutional''),
(''America''''s 1st Choice Health Plans of North Carolina'', ''AMER1'', ''PAPER'', ''Professional''),
(''America''''s 1st Choice of South Carolina, Inc.'', ''55349'', ''55349'', ''Institutional''),
(''America''''s 1st Choice of South Carolina, Inc.'', ''55349'', ''55349'', ''Professional''),
(''America''''s Choice'', ''20029'', ''20029'', ''Professional''),
(''America''''s Health Plan'', ''AHP01'', ''AHP01'', ''Institutional''),
(''America''''s Health Plan'', ''AHP01'', ''AHP01'', ''Professional''),
(''America''''s PPO'', ''16120'', ''16120'', ''Institutional''),
(''America''''s PPO'', ''16120'', ''16120'', ''Professional''),
(''America''''s TPA'', ''41178'', ''41178'', ''Institutional''),
(''America''''s TPA'', ''41178'', ''41178'', ''Professional''),
(''American Administrative Group (AAG)'', ''37283'', ''37283'', ''Institutional''),
(''American Administrative Group (AAG)'', ''37283'', ''37283'', ''Professional''),
(''American Administrative Group (AAG) - Gallagher Benefit Administrators'', ''37283'', ''37283'', ''Institutional''),
(''American Administrative Group (AAG) - Gallagher Benefit Administrators'', ''37283'', ''37283'', ''Professional''),
(''American Behavioral'', ''63103'', ''63103'', ''Institutional''),
(''American Behavioral'', ''63103'', ''63103'', ''Professional''),
(''American Benefit Plan Administrators'', ''59140'', ''59140'', ''Institutional''),
(''American Benefit Plan Administrators'', ''59140'', ''59140'', ''Professional''),
(''American Benefit Plan Administrators (ABPA)'', ''95170'', ''95170'', ''Institutional''),
(''American Benefit Plan Administrators (ABPA)'', ''95170'', ''95170'', ''Professional''),
(''American Claims Management (ACM)'', ''J1236'', ''J1236'', ''Institutional''),
(''American Claims Management (ACM)'', ''J1236'', ''J1236'', ''Professional''),
(''American Coin Merchandising, Inc'', ''J1026'', ''J1026'', ''Institutional''),
(''American Coin Merchandising, Inc'', ''J1026'', ''J1026'', ''Professional''),
(''American Cyanamid'', ''J1027'', ''J1027'', ''Institutional''),
(''American Cyanamid'', ''J1027'', ''J1027'', ''Professional''),
(''American Family Health Providers (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''American Family Health Providers (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''American Family Insurance Company'', ''AMF11'', ''AMF11'', ''Institutional''),
(''American Family Insurance Company'', ''AMF11'', ''AMF11'', ''Professional''),
(''American Family Medicare Supplement and PPO Policies'', ''56071'', ''56071'', ''Institutional''),
(''American Family Medicare Supplement and PPO Policies'', ''56071'', ''56071'', ''Professional''),
(''American Furniture Warehouse'', ''41556'', ''41556'', ''Institutional''),
(''American Furniture Warehouse'', ''41556'', ''41556'', ''Professional''),
(''American General'', ''62030'', ''62030'', ''Institutional''),
(''American General'', ''62030'', ''62030'', ''Professional''),
(''American Health Advantage of Mississippi'', ''31135'', ''31135'', ''Institutional''),
(''American Health Advantage of Mississippi'', ''31135'', ''31135'', ''Professional''),
(''American Health Advantage of Missouri'', ''MMS01'', ''MMS01'', ''Institutional''),
(''American Health Advantage of Missouri'', ''MMS01'', ''MMS01'', ''Professional''),
(''American Health Advantage of Oklahoma'', ''31125'', ''31125'', ''Institutional''),
(''American Health Advantage of Oklahoma'', ''31125'', ''31125'', ''Professional''),
(''American Health Advantage of Tennessee'', ''31130'', ''31130'', ''Institutional''),
(''American Health Advantage of Tennessee'', ''31130'', ''31130'', ''Professional''),
(''American Healthcare Alliance - Corporate Plan Management'', ''01066'', ''01066'', ''Institutional''),
(''American Healthcare Alliance - Corporate Plan Management'', ''01066'', ''01066'', ''Professional''),
(''American Home Craft'', ''J1250'', ''J1250'', ''Institutional''),
(''American Home Craft'', ''J1250'', ''J1250'', ''Professional''),
(''American Insurance Company of Texas'', ''81949'', ''81949'', ''Professional''),
(''American International Group, Inc. (AIG)'', ''87726'', ''87726'', ''Professional''),
(''American Liberty Insurance Company'', ''41556'', ''41556'', ''Institutional''),
(''American Liberty Insurance Company'', ''41556'', ''41556'', ''Professional''),
(''American Medical Security (AMS)'', ''81400'', ''81400'', ''Institutional''),
(''American Medical Security (AMS)'', ''81400'', ''81400'', ''Professional''),
(''American Mining Insurance Group, LLC'', ''J1524'', ''J1524'', ''Institutional''),
(''American Mining Insurance Group, LLC'', ''J1524'', ''J1524'', ''Professional''),
(''American National'', ''J2295'', ''J2295'', ''Institutional''),
(''American National'', ''J2295'', ''J2295'', ''Professional''),
(''American National Insurance Company'', ''74048'', ''74048'', ''Institutional''),
(''American National Insurance Company'', ''74048'', ''74048'', ''Professional''),
(''American Plan Administrators'', ''95606'', ''95606'', ''Institutional''),
(''American Plan Administrators'', ''95606'', ''95606'', ''Professional''),
(''American Primary Care Alliance IPA'', ''APCA1'', ''APCA1'', ''Institutional''),
(''American Primary Care Alliance IPA'', ''APCA1'', ''APCA1'', ''Professional''),
(''American Public Life (APL)'', ''60801'', ''60801'', ''Institutional''),
(''American Public Life (APL)'', ''60801'', ''60801'', ''Professional''),
(''American Republic Insurance Company'', ''42011'', ''42011'', ''Institutional''),
(''American Republic Insurance Company'', ''42011'', ''42011'', ''Professional''),
(''American Retirement Life Ins Co Medicare Supplement'', ''13193'', ''13193'', ''Institutional''),
(''American Retirement Life Ins Co Medicare Supplement'', ''13193'', ''13193'', ''Professional''),
(''American Specialty Companies'', ''J1028'', ''J1028'', ''Institutional''),
(''American Specialty Companies'', ''J1028'', ''J1028'', ''Professional''),
(''American Specialty Health'', ''ASHP1'', ''ASHP1'', ''Professional''),
(''American Specialty Ins. / MIB'', ''J1029'', ''J1029'', ''Institutional''),
(''American Specialty Ins. / MIB'', ''J1029'', ''J1029'', ''Professional''),
(''American Worker Health Plan'', ''37322'', ''37322'', ''Institutional''),
(''American Worker Health Plan'', ''37322'', ''37322'', ''Professional''),
(''AmeriChoice of Florida'', ''87726'', ''87726'', ''Professional''),
(''AmeriChoice of Illinois'', ''87726'', ''87726'', ''Professional''),
(''AmeriChoice of Pennsylvania Personal Care Plus (Pennsylvania Medicare)'', ''87726'', ''87726'', ''Institutional''),
(''AmeriChoice of Pennsylvania Personal Care Plus (Pennsylvania Medicare)'', ''87726'', ''87726'', ''Professional''),
(''AmeriChoice of Rhode Island'', ''87726'', ''87726'', ''Professional''),
(''Americhoice San Diego County - Co Medical Svcs (CMS)'', ''AMCH1'', ''AMCH1'', ''Institutional''),
(''Americhoice San Diego County - Co Medical Svcs (CMS)'', ''AMCH1'', ''AMCH1'', ''Professional''),
(''Americhoice San Diego County - Physicians Emergency Svcs (PES)'', ''AMCH2'', ''AMCH2'', ''Institutional''),
(''Americhoice San Diego County - Physicians Emergency Svcs (PES)'', ''AMCH2'', ''AMCH2'', ''Professional''),
(''Americhoice San Diego County - Ryan Care Act'', ''AMCH3'', ''AMCH3'', ''Institutional''),
(''Americhoice San Diego County - Ryan Care Act'', ''AMCH3'', ''AMCH3'', ''Professional''),
(''Americhoice San Diego County - SD Co Sheriff''''s Dept'', ''AMCH5'', ''AMCH5'', ''Institutional''),
(''Americhoice San Diego County - SD Co Sheriff''''s Dept'', ''AMCH5'', ''AMCH5'', ''Professional''),
(''Americhoice San Diego County - SD Primary Care Services'', ''AMCH4'', ''AMCH4'', ''Institutional''),
(''Americhoice San Diego County - SD Primary Care Services'', ''AMCH4'', ''AMCH4'', ''Professional''),
(''Amerigroup District of Columbia'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup District of Columbia'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup Florida'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup Florida'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup Georgia'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup Georgia'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup Iowa'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup Iowa'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup Kansas - Kancare'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup Kansas - Kancare'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup Louisiana - Healthy Blue'', ''00661'', ''00661'', ''Institutional''),
(''Amerigroup Louisiana - Healthy Blue'', ''00661'', ''00661'', ''Professional''),
(''Amerigroup Maryland'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup Maryland'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup Nevada'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup Nevada'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup New Jersey'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup New Jersey'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup New Mexico'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup New Mexico'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup RealSolutions'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup RealSolutions'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup Tennessee'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup Tennessee'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup Texas'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup Texas'', ''27514'', ''27514'', ''Professional''),
(''Amerigroup Washington'', ''27514'', ''27514'', ''Institutional''),
(''Amerigroup Washington'', ''27514'', ''27514'', ''Professional''),
(''AmeriHealth Administrators'', ''54763'', ''54763'', ''Institutional''),
(''AmeriHealth Administrators'', ''54763'', ''54763'', ''Professional''),
(''AmeriHealth Administrators PPO (Delaware)'', ''93688'', ''93688'', ''Professional''),
(''AmeriHealth Administrators PPO (New Jersey)'', ''60061'', ''60061'', ''Institutional''),
(''AmeriHealth Administrators PPO (New Jersey)'', ''60061'', ''60061'', ''Professional''),
(''AmeriHealth Caritas Delaware'', ''77799'', ''77799'', ''Institutional''),
(''AmeriHealth Caritas Delaware'', ''77799'', ''77799'', ''Professional''),
(''AmeriHealth Caritas District of Columbia'', ''77002'', ''77002'', ''Institutional''),
(''AmeriHealth Caritas District of Columbia'', ''77002'', ''77002'', ''Professional''),
(''AmeriHealth Caritas Louisiana'', ''27357'', ''27357'', ''Institutional''),
(''AmeriHealth Caritas Louisiana'', ''27357'', ''27357'', ''Professional''),
(''Amerihealth Caritas New Hampshire'', ''87716'', ''87716'', ''Institutional''),
(''Amerihealth Caritas New Hampshire'', ''87716'', ''87716'', ''Professional''),
(''AmeriHealth Caritas Northeast'', ''77001'', ''77001'', ''Institutional''),
(''AmeriHealth Caritas Northeast'', ''77001'', ''77001'', ''Professional''),
(''AmeriHealth Caritas PA Community HealthChoices'', ''77062'', ''77062'', ''Institutional''),
(''AmeriHealth Caritas PA Community HealthChoices'', ''77062'', ''77062'', ''Professional''),
(''AmeriHealth Caritas Pennsylvania'', ''22248'', ''22248'', ''Institutional''),
(''AmeriHealth Caritas Pennsylvania'', ''22248'', ''22248'', ''Professional''),
(''AmeriHealth Caritas VIP Care'', ''77062'', ''77062'', ''Institutional''),
(''AmeriHealth Caritas VIP Care'', ''77062'', ''77062'', ''Professional''),
(''AmeriHealth Caritas VIP Care Plus (Michigan)'', ''77013'', ''77013'', ''Institutional''),
(''AmeriHealth Caritas VIP Care Plus (Michigan)'', ''77013'', ''77013'', ''Professional''),
(''Amerihealth Casualty Services'', ''J3969'', ''J3969'', ''Institutional''),
(''Amerihealth Casualty Services'', ''J3969'', ''J3969'', ''Professional''),
(''AmeriHealth HMO (New Jersey, Delaware, Pennsylvania)'', ''95044'', ''95044'', ''Institutional''),
(''AmeriHealth HMO (New Jersey, Delaware, Pennsylvania)'', ''95044'', ''95044'', ''Professional''),
(''AmeriHealth Mercy Health Plan'', ''22248'', ''22248'', ''Institutional''),
(''AmeriHealth Mercy Health Plan'', ''22248'', ''22248'', ''Professional''),
(''Ameriprise - NJ'', ''C1097'', ''C1097'', ''Institutional''),
(''Ameriprise - NJ'', ''C1097'', ''C1097'', ''Professional''),
(''Ameriprise Auto & Home Insurance'', ''12504'', ''12504'', ''Institutional''),
(''Ameriprise Auto & Home Insurance'', ''12504'', ''12504'', ''Professional''),
(''Amerisafe'', ''J1447'', ''J1447'', ''Institutional''),
(''Amerisafe'', ''J1447'', ''J1447'', ''Professional''),
(''Amerisafe Risk Services'', ''J1447'', ''J1447'', ''Institutional''),
(''Amerisafe Risk Services'', ''J1447'', ''J1447'', ''Professional''),
(''Amerisure Insurance'', ''J1206'', ''J1206'', ''Institutional''),
(''Amerisure Insurance'', ''J1206'', ''J1206'', ''Professional''),
(''Amerisure Mutual Insurance'', ''J1205'', ''J1205'', ''Institutional''),
(''Amerisure Mutual Insurance'', ''J1205'', ''J1205'', ''Professional''),
(''AmFirst Insurance Company'', ''64090'', ''64090'', ''Institutional''),
(''AmFirst Insurance Company'', ''64090'', ''64090'', ''Professional''),
(''AmGuard Insurance Company - Guard DBA'', ''J1453'', ''J1453'', ''Institutional''),
(''AmGuard Insurance Company - Guard DBA'', ''J1453'', ''J1453'', ''Professional''),
(''Amica Insurance Co.'', ''C1098'', ''C1098'', ''Institutional''),
(''Amica Insurance Co.'', ''C1098'', ''C1098'', ''Professional''),
(''Amica Mutual Insurance Company'', ''12287'', ''12287'', ''Institutional''),
(''Amica Mutual Insurance Company'', ''12287'', ''12287'', ''Professional''),
(''Amida Care - Medicaid'', ''24818'', ''24818'', ''Institutional''),
(''Amida Care - Medicaid'', ''24818'', ''24818'', ''Professional''),
(''Amida Care - Medicare Advantage'', ''79966'', ''79966'', ''Institutional''),
(''Amida Care - Medicare Advantage'', ''79966'', ''79966'', ''Professional''),
(''Amtrust Insurance Company North America'', ''J1868'', ''J1868'', ''Institutional''),
(''Amtrust Insurance Company North America'', ''J1868'', ''J1868'', ''Professional''),
(''AMVI Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''AMVI Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''AMVI/Prospect Health Network (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Institutional''),
(''AMVI/Prospect Health Network (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Professional''),
(''ANACO'', ''41556'', ''41556'', ''Institutional''),
(''ANACO'', ''41556'', ''41556'', ''Professional''),
(''Anaheim Memorial IPA (MHCAN)'', ''IP095'', ''MHIPA'', ''Professional''),
(''ANAIC Cibus'', ''41556'', ''41556'', ''Institutional''),
(''ANAIC Cibus'', ''41556'', ''41556'', ''Professional''),
(''Anchor Benefit Consulting, Inc.'', ''53085'', ''53085'', ''Institutional''),
(''Anchor Benefit Consulting, Inc.'', ''53085'', ''53085'', ''Professional''),
(''Ancillary Care Management - ACM'', ''03172'', ''03172'', ''Professional''),
(''Angel Medical Group'', ''ECMSO'', ''ECMSO'', ''Institutional''),
(''Angel Medical Group'', ''SCPR1'', ''ECMSO'', ''Professional''),
(''Angeles IPA'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Angeles IPA'', ''HSM01'', ''HSM01'', ''Professional''),
(''Anheuser Busch'', ''J1620'', ''J1620'', ''Institutional''),
(''Anheuser Busch'', ''J1620'', ''J1620'', ''Professional''),
(''ANPAC'', ''43101'', ''43101'', ''Institutional''),
(''ANPAC'', ''43101'', ''43101'', ''Professional''),
(''Antelope Valley Medical Associates'', ''SMG01'', ''SMG01'', ''Professional''),
(''Antelope Valley Ret.'', ''41556'', ''41556'', ''Institutional''),
(''Antelope Valley Ret.'', ''41556'', ''41556'', ''Professional''),
(''Anthem Blue Cross and Blue Shield Healthcare Solutions Nevada'', ''00265'', ''NVBLU'', ''Institutional''),
(''Anthem Blue Cross and Blue Shield Healthcare Solutions Nevada'', ''00265'', ''NVBLU'', ''Professional''),
(''Anthem Healthkeepers'', ''00423'', ''VABLU'', ''Institutional''),
(''Anthem Healthkeepers'', ''VABLU'', ''VABLU'', ''Professional''),
(''APAC (Pinnacle Health Resources) (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Institutional''),
(''APAC (Pinnacle Health Resources) (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Professional''),
(''Apex Benefit Services'', ''34196'', ''34196'', ''Institutional''),
(''Apex Benefit Services'', ''34196'', ''34196'', ''Professional''),
(''Apostrophe'', ''81312'', ''81312'', ''Institutional''),
(''Apostrophe'', ''81312'', ''81312'', ''Professional''),
(''AppleCare Medical Management'', ''APP01'', ''APP01'', ''Institutional''),
(''AppleCare Medical Management'', ''APP01'', ''APP01'', ''Professional''),
(''Applied Underwriters'', ''J1775'', ''J1775'', ''Institutional''),
(''Applied Underwriters'', ''J1775'', ''J1775'', ''Professional''),
(''APS Healthcare'', ''66056'', ''66056'', ''Institutional''),
(''APS Healthcare'', ''66056'', ''66056'', ''Professional''),
(''Arcadian Management Services'', ''61101'', ''61101'', ''Professional''),
(''Arch Health Partners Pomerado'', ''SCMG1'', ''SCMG1'', ''Institutional''),
(''Arch Health Partners Pomerado'', ''SCMG1'', ''SCMG1'', ''Professional''),
(''ArchCare - Peak Pace TPA'', ''27034'', ''27034'', ''Institutional''),
(''ArchCare - Peak Pace TPA'', ''27034'', ''27034'', ''Professional''),
(''ARCMI Claims Management'', ''J3977'', ''J3977'', ''Institutional''),
(''ARCMI Claims Management'', ''J3977'', ''J3977'', ''Professional''),
(''Areas USA, Inc.'', ''J1944'', ''J1944'', ''Institutional''),
(''Areas USA, Inc.'', ''J1944'', ''J1944'', ''Professional''),
(''Argent (Subsidiary of West Bend but this route is Argent only)'', ''J1420'', ''J1420'', ''Institutional''),
(''Argent (Subsidiary of West Bend but this route is Argent only)'', ''J1420'', ''J1420'', ''Professional''),
(''Argonaut Insurance Company(ARGO)'', ''19801'', ''19801'', ''Institutional''),
(''Argonaut Insurance Company(ARGO)'', ''19801'', ''19801'', ''Professional''),
(''Argus Dental Plan'', ''ARGUS'', ''ARGUS'', ''Institutional''),
(''Argus Dental Plan'', ''ARGUS'', ''ARGUS'', ''Professional''),
(''Arise Health Plan - WPS'', ''39185'', ''ARISE'', ''Institutional''),
(''Arise Health Plan - WPS'', ''39185'', ''ARISE'', ''Professional''),
(''Arizona & 21st Corp. DBA Berkley East Conv. Hospital'', ''41556'', ''41556'', ''Institutional''),
(''Arizona & 21st Corp. DBA Berkley East Conv. Hospital'', ''41556'', ''41556'', ''Professional''),
(''Arizona Foundation for Medical Care'', ''86062'', ''86062'', ''Institutional''),
(''Arizona Foundation for Medical Care'', ''86062'', ''86062'', ''Professional''),
(''Arizona Priority Care Plus'', ''27154'', ''27154'', ''Institutional''),
(''Arizona Priority Care Plus'', ''27154'', ''27154'', ''Professional''),
(''Arkansas Best Corp. - Choice Benefits'', ''62308'', ''62308'', ''Institutional''),
(''Arkansas Best Corp. - Choice Benefits'', ''62308'', ''62308'', ''Professional''),
(''Arkansas Empower Health'', ''12956'', ''12956'', ''Institutional''),
(''Arkansas Empower Health'', ''12956'', ''12956'', ''Professional''),
(''Arkansas Total Care'', ''68069'', ''68069'', ''Institutional''),
(''Arkansas Total Care'', ''68069'', ''68069'', ''Professional''),
(''ARM, Ltd.'', ''63240'', ''63240'', ''Institutional''),
(''ARM, Ltd.'', ''63240'', ''63240'', ''Professional''),
(''Arnett Health Plans'', ''87726'', ''87726'', ''Institutional''),
(''Arnett Health Plans'', ''87726'', ''87726'', ''Professional''),
(''Arrowpoint'', ''J1564'', ''J1564'', ''Institutional''),
(''Arrowpoint'', ''J1564'', ''J1564'', ''Professional''),
(''Arroyo Vista Family Health Center (CA)'', ''NMM01'', ''NMM01'', ''Professional''),
(''Ascension Complete'', ''68069'', ''68069'', ''Institutional''),
(''Ascension Complete'', ''68069'', ''68069'', ''Professional''),
(''Asian American Medical Group'', ''AAMG1'', ''AAMG1'', ''Institutional''),
(''Asian American Medical Group'', ''AAMG1'', ''AAMG1'', ''Professional''),
(''Asian Community Medical Group'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Asian Community Medical Group'', ''HSM01'', ''HSM01'', ''Professional''),
(''Aspire Health Plan'', ''46156'', ''46156'', ''Institutional''),
(''Aspire Health Plan'', ''46156'', ''46156'', ''Professional''),
(''ASRM Corp'', ''ASRM1'', ''ASRM1'', ''Professional''),
(''Associated Dignity Medical Group'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Associated Dignity Medical Group'', ''HSM01'', ''HSM01'', ''Professional''),
(''Associated Hispanic Physicians of Southern CA IPA'', ''MPM44'', ''MPM44'', ''Institutional''),
(''Associated Hispanic Physicians of Southern CA IPA'', ''MPM44'', ''MPM44'', ''Professional''),
(''Associated Third Party Administration (ATPA)'', ''ATPA1'', ''ATPA1'', ''Professional''),
(''Associates for Health Care, Inc (AHC)'', ''36326'', ''36326'', ''Institutional''),
(''Associates for Health Care, Inc (AHC)'', ''36326'', ''36326'', ''Professional''),
(''Association County Commissioners of Georgia (ACCG).'', ''J1869'', ''J1869'', ''Institutional''),
(''Association County Commissioners of Georgia (ACCG).'', ''J1869'', ''J1869'', ''Professional''),
(''Assurance Company of America (Commercial Only)'', ''C1034'', ''C1034'', ''Institutional''),
(''Assurance Company of America (Commercial Only)'', ''C1034'', ''C1034'', ''Professional''),
(''Assurant Health Self Funded'', ''75068'', ''75068'', ''Institutional''),
(''Assurant Health Self Funded'', ''75068'', ''75068'', ''Professional''),
(''Assurant Health Supplemental Coverage - National General'', ''ASHC1'', ''ASHC1'', ''Institutional''),
(''Assurant Health Supplemental Coverage - National General'', ''ASHC1'', ''ASHC1'', ''Professional''),
(''Assurecare of Minnesota ARM Group'', ''88035'', ''88035'', ''Institutional''),
(''Assurecare of Minnesota ARM Group'', ''88035'', ''88035'', ''Professional''),
(''Assured Benefits Administrators'', ''74240'', ''74240'', ''Institutional''),
(''Assured Benefits Administrators'', ''74240'', ''74240'', ''Professional''),
(''Asuris Northwest Health'', ''SX179'', ''SX179'', ''Institutional''),
(''Asuris Northwest Health'', ''SX179'', ''SX179'', ''Professional''),
(''Athens'', ''J1914'', ''J1914'', ''Institutional''),
(''Athens'', ''J1914'', ''J1914'', ''Professional''),
(''Atlantic Coast Life Insurance'', ''87020'', ''87020'', ''Institutional''),
(''Atlantic Coast Life Insurance'', ''87020'', ''87020'', ''Professional''),
(''Atlantic Medical Insurance'', ''22285'', ''22285'', ''Institutional''),
(''Atlantic Medical Insurance'', ''22285'', ''22285'', ''Professional''),
(''Atlantic PPO to Mercury Insurance'', ''J2047'', ''J2047'', ''Institutional''),
(''Atlantic PPO to Mercury Insurance'', ''J2047'', ''J2047'', ''Professional''),
(''Atlantis Eyecare'', ''AEC01'', ''AEC01'', ''Professional''),
(''Atlantis Health Plan'', ''AHP1C'', ''PAPER'', ''Professional''),
(''Atlas Life Insurance Company'', ''90956'', ''90956'', ''Institutional''),
(''Atlas Life Insurance Company'', ''90956'', ''90956'', ''Professional''),
(''Atrio Health Plans'', ''ATRIO'', ''ATRIO'', ''Institutional''),
(''Atrio Health Plans'', ''ATRIO'', ''ATRIO'', ''Professional''),
(''AultCare of Ohio'', ''AULOH'', ''AULOH'', ''Institutional''),
(''AultCare of Ohio'', ''AULOH'', ''AULOH'', ''Professional''),
(''Aultra Administrative Group'', ''37242'', ''37242'', ''Institutional''),
(''Aultra Administrative Group'', ''37242'', ''37242'', ''Professional''),
(''Austin Mutual Ins'', ''J1682'', ''J1682'', ''Institutional''),
(''Austin Mutual Ins'', ''J1682'', ''J1682'', ''Professional''),
(''Austin Regional Clinic Employee Benefit Plan'', ''CMSEB'', ''CMSEB'', ''Institutional''),
(''Austin Regional Clinic Employee Benefit Plan'', ''CMSEB'', ''CMSEB'', ''Professional''),
(''Auto Club Group'', ''11983'', ''11983'', ''Institutional''),
(''Auto Club Group'', ''11983'', ''11983'', ''Professional''),
(''Auto Club Group Insurance Company'', ''11983'', ''11983'', ''Institutional''),
(''Auto Club Group Insurance Company'', ''11983'', ''11983'', ''Professional''),
(''Auto Club Insurance (ACIA)'', ''11983'', ''11983'', ''Institutional''),
(''Auto Club Insurance (ACIA)'', ''11983'', ''11983'', ''Professional''),
(''Auto Club Insurance Association'', ''11983'', ''11983'', ''Professional''),
(''Auto Club Insurance Association - WC only'', ''11983'', ''11983'', ''Institutional''),
(''Auto Club Insurance Association - WC only'', ''11983'', ''11983'', ''Professional''),
(''Auto Club Property-Casualty Insurance Company'', ''11983'', ''11983'', ''Institutional''),
(''Auto Club Property-Casualty Insurance Company'', ''11983'', ''11983'', ''Professional''),
(''Auto One Insurance'', ''C1082'', ''C1082'', ''Institutional''),
(''Auto One Insurance'', ''C1082'', ''C1082'', ''Professional''),
(''Auto-Owners \ Home-Owners Insurance Company'', ''J1580'', ''J1580'', ''Institutional''),
(''Auto-Owners \ Home-Owners Insurance Company'', ''J1580'', ''J1580'', ''Professional''),
(''Auto-Owners \ Owners Insurance Company'', ''J1583'', ''J1583'', ''Institutional''),
(''Auto-Owners \ Owners Insurance Company'', ''J1583'', ''J1583'', ''Professional''),
(''Auto-Owners \ Property-Owners Insurance Co'', ''J1699'', ''J1699'', ''Institutional''),
(''Auto-Owners \ Property-Owners Insurance Co'', ''J1699'', ''J1699'', ''Professional''),
(''Auto-Owners \ Southern-Owners Company'', ''J1688'', ''J1688'', ''Institutional''),
(''Auto-Owners \ Southern-Owners Company'', ''J1688'', ''J1688'', ''Professional''),
(''Auto-Owners Insurance Company'', ''J1556'', ''J1556'', ''Institutional''),
(''Auto-Owners Insurance Company'', ''J1556'', ''J1556'', ''Professional''),
(''Auto-Owners Life Insurance Company'', ''J1596'', ''J1596'', ''Institutional''),
(''Auto-Owners Life Insurance Company'', ''J1596'', ''J1596'', ''Professional''),
(''Automated Benefit Services (ABS)'', ''38259'', ''38259'', ''Institutional''),
(''Automated Benefit Services (ABS)'', ''38259'', ''38259'', ''Professional''),
(''Automated Group Administration, Inc. (AGA)'', ''37280'', ''37280'', ''Institutional''),
(''Automated Group Administration, Inc. (AGA)'', ''37280'', ''37280'', ''Professional''),
(''Automobile Dealers Insurance Company Inc'', ''J1861'', ''J1861'', ''Institutional''),
(''Automobile Dealers Insurance Company Inc'', ''J1861'', ''J1861'', ''Professional''),
(''Avalon IPA (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Avalon IPA (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Avante Health'', ''AH001'', ''AH001'', ''Professional''),
(''Avera Health Plans'', ''46045'', ''46045'', ''Institutional''),
(''Avera Health Plans'', ''46045'', ''46045'', ''Professional''),
(''Avera Health Plans for John Morrell'', ''38310'', ''38310'', ''Institutional''),
(''Avera Health Plans for John Morrell'', ''38310'', ''38310'', ''Professional''),
(''Avesis Third Party Administrators - Phoenix, Arizona'', ''87098'', ''87098'', ''Professional''),
(''AVIR Inc.'', ''41556'', ''41556'', ''Institutional''),
(''AVIR Inc.'', ''41556'', ''41556'', ''Professional''),
(''Avizent'', ''J1415'', ''J1415'', ''Institutional''),
(''Avizent'', ''J1415'', ''J1415'', ''Professional''),
(''AvMed, Inc.'', ''59274'', ''59274'', ''Institutional''),
(''AvMed, Inc.'', ''59274'', ''59274'', ''Professional''),
(''AXA Assistance USA'', ''65101'', ''65101'', ''Institutional''),
(''AXA Assistance USA'', ''65101'', ''65101'', ''Professional''),
(''Axminster Medical Group'', ''AXM01'', ''AXM01'', ''Professional''),
(''Ayers Trucking'', ''J1018'', ''J1018'', ''Institutional''),
(''Ayers Trucking'', ''J1018'', ''J1018'', ''Professional''),
(''Baker Tanks, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Baker Tanks, Inc.'', ''41556'', ''41556'', ''Professional''),
(''Bakersfield Family Medical Center (California)'', ''BKRFM'', ''BKRFM'', ''Institutional''),
(''Bakersfield Family Medical Center (California)'', ''BKRFM'', ''BKRFM'', ''Professional''),
(''Bank of America'', ''J1729'', ''J1729'', ''Institutional''),
(''Bank of America'', ''J1729'', ''J1729'', ''Professional''),
(''Bankers Life'', ''61263'', ''PAPER'', ''Institutional''),
(''Bankers Life'', ''61263'', ''PAPER'', ''Professional''),
(''Banner Health & Aetna Health Insurance Company'', ''67895'', ''67895'', ''Institutional''),
(''Banner Health & Aetna Health Insurance Company'', ''67895'', ''67895'', ''Professional''),
(''Banner Health Co - Antero Greeley'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Antero High Plains'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Antero Mountain Shadows'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Choice Plus'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - HMO Greeley'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - HMO High Plains'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - HMO Mountain Shadows'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Pacificare Greeley'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Pacificare High Plains'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Pacificare Mountain Shadows'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Rocky Mountain HMO Greeley'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Rocky Mountain HMO High Plains'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Secure Horizons Greeley'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Secure Horizons High Plains'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Co - Secure Horizons Mountain Shadows'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Health Company'', ''SX145'', ''SX145'', ''Professional''),
(''Banner Plan Administration'', ''12X42'', ''12X42'', ''Institutional''),
(''Banner Plan Administration'', ''12X42'', ''12X42'', ''Professional''),
(''Banner- University Family Care LTC'', ''66901'', ''66901'', ''Institutional''),
(''Banner- University Family Care LTC'', ''66901'', ''66901'', ''Professional''),
(''Baptist Health South Florida'', ''65026'', ''65026'', ''Professional''),
(''Barnes (Bunch CareSolutions)'', ''J1503'', ''J1503'', ''Institutional''),
(''Barnes (Bunch CareSolutions)'', ''J1503'', ''J1503'', ''Professional''),
(''Barrett Business Services Inc (BBSI)'', ''J1686'', ''J1686'', ''Institutional''),
(''Barrett Business Services Inc (BBSI)'', ''J1686'', ''J1686'', ''Professional''),
(''BART - San Francisco Bay Area Rapid Transit'', ''J1770'', ''J1770'', ''Institutional''),
(''BART - San Francisco Bay Area Rapid Transit'', ''J1770'', ''J1770'', ''Professional''),
(''Basic Plus (TCC)'', ''41204'', ''41204'', ''Institutional''),
(''Basic Plus (TCC)'', ''41204'', ''41204'', ''Professional''),
(''Basic Resources, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Basic Resources, Inc.'', ''41556'', ''41556'', ''Professional''),
(''Bass Pro Group, LLC'', ''J1770'', ''J1958'', ''Institutional''),
(''Bass Pro Group, LLC'', ''J1958'', ''J1958'', ''Professional''),
(''BayCare Select Health Plans Inc.'', ''81079'', ''81079'', ''Institutional''),
(''BayCare Select Health Plans Inc.'', ''81079'', ''81079'', ''Professional''),
(''BCBS -  South Carolina,  Total Medicare Advantage'', ''C63'', ''C63'', ''Institutional''),
(''BCBS -  South Carolina,  Total Medicare Advantage'', ''C63'', ''C63'', ''Professional''),
(''BCBS - Alabama'', ''00510BC'', ''ALBLU'', ''Institutional''),
(''BCBS - Alabama'', ''00510BS'', ''ALBLU'', ''Professional''),
(''BCBS - Arizona'', ''53589'', ''AZBLU'', ''Institutional''),
(''BCBS - Arizona'', ''53589'', ''AZBLU'', ''Professional''),
(''BCBS - Arizona Medicare Advantage (formerly Banner Medisun)'', ''77078'', ''77078'', ''Institutional''),
(''BCBS - Arizona Medicare Advantage (formerly Banner Medisun)'', ''77078'', ''77078'', ''Professional''),
(''BCBS - Arizona Medicare Advantage - Maricopa County'', ''53589'', ''AZBLU'', ''Institutional''),
(''BCBS - Arizona Medicare Advantage - Maricopa County'', ''53589'', ''AZBLU'', ''Professional''),
(''BCBS - Arizona Medicare Advantage Pima and Santa Cruz County (P3 Health)'', ''58375'', ''58375'', ''Institutional''),
(''BCBS - Arizona Medicare Advantage Pima and Santa Cruz County (P3 Health)'', ''58375'', ''58375'', ''Professional''),
(''BCBS - Arkansas'', ''00520'', ''ARBLU'', ''Institutional''),
(''BCBS - Arkansas'', ''00520'', ''ARBLU'', ''Professional''),
(''BCBS - Blue Cross Medicare Advantage Plans (HCSC)'', ''66006'', ''66006'', ''Institutional''),
(''BCBS - Blue Cross Medicare Advantage Plans (HCSC)'', ''66006'', ''66006'', ''Professional''),
(''BCBS - Colorado, Anthem'', ''00050'', ''COBLU'', ''Institutional''),
(''BCBS - Colorado, Anthem'', ''00050'', ''COBLU'', ''Professional''),
(''BCBS - Connecticut, Anthem Northeast'', ''00060'', ''CTBLU'', ''Professional''),
(''BCBS - Connecticut, Anthem Northeast'', ''12B04'', ''CTBLU'', ''Institutional''),
(''BCBS - Delaware, Highmark'', ''47181'', ''DEBLU'', ''Institutional''),
(''BCBS - Delaware, Highmark'', ''SB570'', ''DEBLU'', ''Professional''),
(''BCBS - District of Columbia, CareFirst'', ''12000'', ''12000'', ''Institutional''),
(''BCBS - District of Columbia, CareFirst'', ''SB580'', ''SB580'', ''Professional''),
(''BCBS - Florida'', ''00590'', ''00590'', ''Institutional''),
(''BCBS - Florida'', ''00590'', ''00590'', ''Professional''),
(''BCBS - Georgia, Anthem'', ''00101'', ''GABLU'', ''Institutional''),
(''BCBS - Georgia, Anthem'', ''00601'', ''GABLU'', ''Professional''),
(''BCBS - Hawaii, HMSA'', ''12B62'', ''HIBLU'', ''Institutional''),
(''BCBS - Hawaii, HMSA'', ''SB971'', ''HIBLU'', ''Professional''),
(''BCBS - Illinois (HCSC)'', ''00621'', ''ILBLU'', ''Institutional''),
(''BCBS - Illinois (HCSC)'', ''00621'', ''ILBLU'', ''Professional''),
(''BCBS - Illinois, Blue Cross Community Options (MMAI, ICP or FHP)'', ''MCDIL'', ''MCDIL'', ''Institutional''),
(''BCBS - Illinois, Blue Cross Community Options (MMAI, ICP or FHP)'', ''MCDIL'', ''MCDIL'', ''Professional''),
(''BCBS - Indiana, Anthem'', ''00630'', ''INXBC'', ''Professional''),
(''BCBS - Indiana, Anthem'', ''12B09'', ''INXBC'', ''Institutional''),
(''BCBS - Iowa'', ''88848'', ''IABLU'', ''Institutional''),
(''BCBS - Iowa'', ''88848'', ''IABLU'', ''Professional''),
(''BCBS - Iowa - Medicare Secondary Only'', ''88848'', ''888MC'', ''Professional''),
(''BCBS - Iowa - Medicare Secondary Only'', ''888MC'', ''888MC'', ''Institutional''),
(''BCBS - Kansas, ASK'', ''47163'', ''47163'', ''Institutional''),
(''BCBS - Kansas, ASK'', ''47163'', ''47163'', ''Professional''),
(''BCBS - Kentucky, Anthem'', ''00160'', ''KYXBC'', ''Institutional''),
(''BCBS - Kentucky, Anthem'', ''00660'', ''KYXBC'', ''Professional''),
(''BCBS - Louisiana'', ''12B12'', ''LABLU'', ''Institutional''),
(''BCBS - Louisiana'', ''53120'', ''LABLU'', ''Professional''),
(''BCBS - Maine, Anthem Northeast'', ''00180'', ''MEBLU'', ''Institutional''),
(''BCBS - Maine, Anthem Northeast'', ''00180'', ''MEBLU'', ''Professional''),
(''BCBS - Maryland, CareFirst'', ''12011'', ''12011'', ''Institutional''),
(''BCBS - Maryland, CareFirst'', ''SB690'', ''SB690'', ''Professional''),
(''BCBS - Massachusetts'', ''12B14'', ''MABLU'', ''Institutional''),
(''BCBS - Massachusetts'', ''SB700'', ''MABLU'', ''Professional''),
(''BCBS - Michigan'', ''00710'', ''00710'', ''Institutional''),
(''BCBS - Michigan'', ''00710'', ''00710'', ''Professional''),
(''BCBS - Michigan, Blue Cross Complete of Michigan'', ''00710'', ''00710'', ''Institutional''),
(''BCBS - Michigan, Blue Cross Complete of Michigan'', ''00710'', ''00710'', ''Professional''),
(''BCBS - Michigan, Medicare Advantage DME (DMEnsions)'', ''00710'', ''710MA'', ''Professional''),
(''BCBS - Michigan, Medicare Plus Blue'', ''00710'', ''710MA'', ''Professional''),
(''BCBS - Michigan, Medicare Plus Blue'', ''710MA'', ''710MA'', ''Institutional''),
(''BCBS - Minnesota'', ''00720'', ''MNBLU'', ''Professional''),
(''BCBS - Minnesota'', ''12B16'', ''MNBLU'', ''Institutional''),
(''BCBS - Minnesota  Blue Plus Medicaid'', ''00562'', ''00562'', ''Institutional''),
(''BCBS - Minnesota  Blue Plus Medicaid'', ''00562'', ''00562'', ''Professional''),
(''BCBS - Minnesota  Blue Plus Medicaid Non-Emergent Transportation (NEMT)'', ''A5143'', ''A5143'', ''Professional''),
(''BCBS - Mississippi'', ''00230'', ''MSBLU'', ''Institutional''),
(''BCBS - Mississippi'', ''00230'', ''MSBLU'', ''Professional''),
(''BCBS - Mississippi (State Employees/Teachers Health Plan'', ''00230'', ''MSBTH'', ''Professional''),
(''BCBS - Mississippi (State Employees/Teachers Health Plan'', ''MSBTH'', ''MSBTH'', ''Institutional''),
(''BCBS - Missouri, Anthem'', ''00241'', ''MOBLU'', ''Institutional''),
(''BCBS - Missouri, Anthem'', ''00241'', ''MOBLU'', ''Professional''),
(''BCBS - Montana'', ''00751'', ''MTBLU'', ''Professional''),
(''BCBS - Montana'', ''12B77'', ''MTBLU'', ''Institutional''),
(''BCBS - Nebraska'', ''00760'', ''NEBLU'', ''Institutional''),
(''BCBS - Nebraska'', ''00760'', ''NEBLU'', ''Professional''),
(''BCBS - Nevada, Anthem'', ''00265'', ''NVBLU'', ''Institutional''),
(''BCBS - Nevada, Anthem'', ''00265'', ''NVBLU'', ''Professional''),
(''BCBS - New Hampshire, Anthem Northeast'', ''00270'', ''NHBLU'', ''Institutional''),
(''BCBS - New Hampshire, Anthem Northeast'', ''00770'', ''NHBLU'', ''Professional''),
(''BCBS - New Jersey, Horizon'', ''22099'', ''22099'', ''Institutional''),
(''BCBS - New Jersey, Horizon'', ''22099'', ''22099'', ''Professional''),
(''BCBS - New Mexico (HCSC)'', ''00790'', ''NMBLU'', ''Professional''),
(''BCBS - New Mexico (HCSC)'', ''12B22'', ''NMBLU'', ''Institutional''),
(''BCBS - New York, Empire, Anthem'', ''00303'', ''SB803'', ''Institutional''),
(''BCBS - New York, Empire, Anthem'', ''SB803'', ''SB803'', ''Professional''),
(''BCBS - New York, Excellus, Central'', ''SB805'', ''SB805'', ''Institutional''),
(''BCBS - New York, Excellus, Central'', ''SB805'', ''SB805'', ''Professional''),
(''BCBS - New York, Excellus, Rochester'', ''SB804'', ''SB804'', ''Institutional''),
(''BCBS - New York, Excellus, Rochester'', ''SB804'', ''SB804'', ''Professional''),
(''BCBS - New York, Excellus, Utica-Watertown'', ''SB806'', ''SB806'', ''Institutional''),
(''BCBS - New York, Excellus, Utica-Watertown'', ''SB806'', ''SB806'', ''Professional''),
(''BCBS - New York, Northeastern, ASK'', ''12B68'', ''00800'', ''Institutional''),
(''BCBS - New York, Northeastern, ASK'', ''SB800'', ''00800'', ''Professional''),
(''BCBS - New York, Western, ASK'', ''12B39'', ''00301'', ''Institutional''),
(''BCBS - New York, Western, ASK'', ''SB801'', ''00301'', ''Professional''),
(''BCBS - North Carolina'', ''00247'', ''NCBLU'', ''Institutional''),
(''BCBS - North Carolina'', ''00247'', ''NCBLU'', ''Professional''),
(''BCBS - North Carolina MedAdvantage'', ''56152'', ''56152'', ''Institutional''),
(''BCBS - North Carolina MedAdvantage'', ''56152'', ''56152'', ''Professional''),
(''BCBS - Ohio, Anthem'', ''00332'', ''OHBLU'', ''Institutional''),
(''BCBS - Ohio, Anthem'', ''00834'', ''OHBLU'', ''Professional''),
(''BCBS - Oklahoma (HCSC)'', ''00840'', ''OKBLU'', ''Professional''),
(''BCBS - Oklahoma (HCSC)'', ''12B59'', ''OKBLU'', ''Institutional''),
(''BCBS - Oregon, Regence'', ''00851'', ''ORBLU'', ''Professional''),
(''BCBS - Oregon, Regence'', ''12B41'', ''ORBLU'', ''Institutional''),
(''BCBS - Pennsylvania Central, Highmark'', ''54771C'', ''5477C'', ''Institutional''),
(''BCBS - Pennsylvania Western, Highmark'', ''54771W'', ''5477W'', ''Institutional''),
(''BCBS - Pennsylvania, Highmark'', ''54771'', ''54771'', ''Professional''),
(''BCBS - Rhode Island'', ''00870'', ''RIBLU'', ''Professional''),
(''BCBS - South Carolina'', ''401'', ''SCBLU'', ''Institutional''),
(''BCBS - South Carolina'', ''401'', ''SCBLU'', ''Professional''),
(''BCBS - South Carolina Federal Employee Plan Blue Cross'', ''402'', ''402'', ''Institutional''),
(''BCBS - South Carolina Federal Employee Plan Blue Cross'', ''402'', ''402'', ''Professional''),
(''BCBS - South Carolina, BlueChoice Health Plan'', ''922'', ''922'', ''Institutional''),
(''BCBS - South Carolina, BlueChoice Health Plan'', ''922'', ''922'', ''Professional''),
(''BCBS - South Carolina, Carolina Benefit Administrators'', ''401'', ''498'', ''Professional''),
(''BCBS - South Carolina, Carolina Benefit Administrators'', ''498'', ''498'', ''Institutional''),
(''BCBS - South Carolina, Planned Administrators'', ''886'', ''886'', ''Institutional''),
(''BCBS - South Carolina, Planned Administrators'', ''886'', ''886'', ''Professional''),
(''BCBS - South Carolina, Preferred Blue'', ''481'', ''481'', ''Institutional''),
(''BCBS - South Carolina, Preferred Blue'', ''481'', ''481'', ''Professional''),
(''BCBS - South Carolina, State Employee Plan BlueCross'', ''400'', ''400'', ''Institutional''),
(''BCBS - South Carolina, State Employee Plan BlueCross'', ''400'', ''400'', ''Professional''),
(''BCBS - South Carolina, Thomas Cooper Agency'', ''315'', ''315'', ''Institutional''),
(''BCBS - South Carolina, Thomas Cooper Agency'', ''315'', ''315'', ''Professional''),
(''BCBS - South Dakota'', ''12B33'', ''SDBLU'', ''Institutional''),
(''BCBS - South Dakota'', ''SB889'', ''SDBLU'', ''Professional''),
(''BCBS - Tennessee, Includes TennCare Select & BlueCare'', ''00390'', ''TNXBC'', ''Institutional''),
(''BCBS - Tennessee, Includes TennCare Select & BlueCare'', ''00390'', ''TNXBC'', ''Professional''),
(''BCBS - Texas (HCSC)'', ''84980'', ''TXBLU'', ''Institutional''),
(''BCBS - Texas (HCSC)'', ''84980'', ''TXBLU'', ''Professional''),
(''BCBS - Texas STAR and CHIP Medicaid'', ''66001'', ''66001'', ''Institutional''),
(''BCBS - Texas STAR and CHIP Medicaid'', ''66001'', ''66001'', ''Professional''),
(''BCBS - US Virgin Islands Triple-S'', ''SB980'', ''VIBLU'', ''Professional''),
(''BCBS - US Virgin Islands Triple-S'', ''VIBLU'', ''VIBLU'', ''Institutional''),
(''BCBS - Utah, Regence'', ''00910'', ''UTBLU'', ''Professional''),
(''BCBS - Utah, Regence'', ''12B42'', ''UTBLU'', ''Institutional''),
(''BCBS - Vermont'', ''12B32'', ''VTBLU'', ''Institutional''),
(''BCBS - Vermont'', ''SB915'', ''VTBLU'', ''Professional''),
(''BCBS - Virginia, Anthem'', ''00423'', ''VABLU'', ''Institutional''),
(''BCBS - Virginia, Anthem'', ''00423'', ''VABLU'', ''Professional''),
(''BCBS - West Virginia, Highmark Health Insurance Co (HHIC)'', ''54828'', ''54828'', ''Institutional''),
(''BCBS - West Virginia, Highmark Health Insurance Co (HHIC)'', ''SB941'', ''54828'', ''Professional''),
(''BCBS - Wisconsin, Anthem'', ''00950'', ''WIBLU'', ''Institutional''),
(''BCBS - Wisconsin, Anthem'', ''00950'', ''WIBLU'', ''Professional''),
(''Beacon Health Options - Commercial'', ''BEACON963116116'', ''VOCOM'', ''Professional''),
(''Beacon Health Options - Commercial'', ''VOCOM'', ''VOCOM'', ''Institutional''),
(''Beacon Health Options - Medicaid Colorado'', ''BEACON963116116'', ''VOMCO'', ''Professional''),
(''Beacon Health Options - Medicaid Colorado'', ''VOMCO'', ''VOMCO'', ''Institutional''),
(''Beacon Health Options - Medicaid Massachusetts'', ''BEACON963116116'', ''VOMMA'', ''Professional''),
(''Beacon Health Options - Medicaid Massachusetts'', ''VOMMA'', ''VOMMA'', ''Institutional''),
(''Beacon Health Options - Medicaid Pennsylvania'', ''BEACON963116116'', ''VOMPA'', ''Professional''),
(''Beacon Health Strategies'', ''43324'', ''43324'', ''Institutional''),
(''Beacon Health Strategies'', ''43324'', ''43324'', ''Professional''),
(''Beacon Mutual'', ''J1234'', ''J1234'', ''Institutional''),
(''Beacon Mutual'', ''J1234'', ''J1234'', ''Professional''),
(''Beacon of Life (Acutecare)'', ''65432'', ''65432'', ''Institutional''),
(''Beacon of Life (Acutecare)'', ''65432'', ''65432'', ''Professional''),
(''Beall''''s Inc / Midwest Employers'', ''J1030'', ''J1030'', ''Institutional''),
(''Beall''''s Inc / Midwest Employers'', ''J1030'', ''J1030'', ''Professional''),
(''Bear Valley Unified School District (CA)'', ''J1690'', ''J1690'', ''Institutional''),
(''Bear Valley Unified School District (CA)'', ''J1690'', ''J1690'', ''Professional''),
(''Beaver Medical Group'', ''45967'', ''45967'', ''Institutional''),
(''Beaver Medical Group'', ''45967'', ''45967'', ''Professional''),
(''Beeville ISD'', ''41556'', ''41556'', ''Institutional''),
(''Beeville ISD'', ''41556'', ''41556'', ''Professional''),
(''Behavioral Health Systems'', ''63100'', ''63100'', ''Institutional''),
(''Behavioral Health Systems'', ''63100'', ''63100'', ''Professional''),
(''Bella Vista Medical Group IPA (MedPOINT) California'', ''MPM10'', ''MPM10'', ''Professional''),
(''Benecorp National Corporation'', ''33192'', ''33192'', ''Institutional''),
(''Benecorp National Corporation'', ''33192'', ''33192'', ''Professional''),
(''Benefit & Risk Management Services'', ''99320'', ''99320'', ''Institutional''),
(''Benefit & Risk Management Services'', ''99320'', ''99320'', ''Professional''),
(''Benefit Administration Services (BAS LTD)'', ''41205'', ''41205'', ''Institutional''),
(''Benefit Administration Services (BAS LTD)'', ''41205'', ''41205'', ''Professional''),
(''Benefit Administrative Systems'', ''36149'', ''36149'', ''Institutional''),
(''Benefit Administrative Systems'', ''36149'', ''36149'', ''Professional''),
(''Benefit Coordinators Corporation - Pittsburgh, Pennsylvania'', ''25145'', ''25145'', ''Institutional''),
(''Benefit Coordinators Corporation - Pittsburgh, Pennsylvania'', ''25145'', ''25145'', ''Professional''),
(''Benefit Management Group, Inc.'', ''20018'', ''20018'', ''Institutional''),
(''Benefit Management Group, Inc.'', ''20018'', ''20018'', ''Professional''),
(''Benefit Management, Inc of KS'', ''48611'', ''48611'', ''Institutional''),
(''Benefit Management, Inc of KS'', ''48611'', ''48611'', ''Professional''),
(''Benefit Plan Administrators (BPA)'', ''88027'', ''88027'', ''Institutional''),
(''Benefit Plan Administrators (BPA)'', ''88027'', ''88027'', ''Professional''),
(''Benefit Plan Administrators (Eagan, MN)'', ''19753'', ''19753'', ''Institutional''),
(''Benefit Plan Administrators (Eagan, MN)'', ''19753'', ''19753'', ''Professional''),
(''Benefit Plan Administrators Company - Eau Claire, Winconsin'', ''39081'', ''39081'', ''Institutional''),
(''Benefit Plan Administrators Company - Eau Claire, Winconsin'', ''39081'', ''39081'', ''Professional''),
(''Benefit Plan Administrators, Inc. - Roanoke, Virginia'', ''37118'', ''37118'', ''Institutional''),
(''Benefit Plan Administrators, Inc. - Roanoke, Virginia'', ''37118'', ''37118'', ''Professional''),
(''Benefit Plan Management, Inc.'', ''44273'', ''44273'', ''Institutional''),
(''Benefit Plan Management, Inc.'', ''44273'', ''44273'', ''Professional''),
(''Benefit Plan Services'', ''BPS77'', ''BPS77'', ''Institutional''),
(''Benefit Plan Services'', ''BPS77'', ''BPS77'', ''Professional''),
(''Benefit Planners, Inc.'', ''39026'', ''39026'', ''Institutional''),
(''Benefit Planners, Inc.'', ''39026'', ''39026'', ''Professional''),
(''Benefit Solutions'', ''42148'', ''42148'', ''Professional''),
(''Benefit Systems & Services, Inc (BSSI)'', ''36342'', ''36342'', ''Institutional''),
(''Benefit Systems & Services, Inc (BSSI)'', ''36342'', ''36342'', ''Professional''),
(''Benefits Administrative Solutions (BAS)'', ''U8053'', ''U8053'', ''Professional''),
(''Benesight'', ''87265'', ''87265'', ''Professional''),
(''Benesys Inc.'', ''38238'', ''38238'', ''Professional''),
(''Bergen Risk'', ''J3997'', ''J3997'', ''Institutional''),
(''Bergen Risk'', ''J3997'', ''J3997'', ''Professional''),
(''Berkley Agribusiness Risk Specialists'', ''J1477'', ''J1477'', ''Institutional''),
(''Berkley Agribusiness Risk Specialists'', ''J1477'', ''J1477'', ''Professional''),
(''Berkley National Insurance Company'', ''J1477'', ''J1477'', ''Institutional''),
(''Berkley National Insurance Company'', ''J1477'', ''J1477'', ''Professional''),
(''Berkley Net Underwriters, LLC'', ''J1523'', ''J1523'', ''Institutional''),
(''Berkley Net Underwriters, LLC'', ''J1523'', ''J1523'', ''Professional''),
(''Berkley Regional Insurance Company'', ''J1477'', ''J1477'', ''Institutional''),
(''Berkley Regional Insurance Company'', ''J1477'', ''J1477'', ''Professional''),
(''Berkley Risk Administrators Company, LLC'', ''J1526'', ''J1526'', ''Institutional''),
(''Berkley Risk Administrators Company, LLC'', ''J1526'', ''J1526'', ''Professional''),
(''Berkley Specialty Underwriters'', ''TP019'', ''TP019'', ''Institutional''),
(''Berkley Specialty Underwriters'', ''TP019'', ''TP019'', ''Professional''),
(''Berkley Valley Conv Hospital'', ''41556'', ''41556'', ''Institutional''),
(''Berkley Valley Conv Hospital'', ''41556'', ''41556'', ''Professional''),
(''Berkshire Hathaway Homestate Companies (BHHC)'', ''20044'', ''20044'', ''Institutional''),
(''Berkshire Hathaway Homestate Companies (BHHC)'', ''20044'', ''20044'', ''Professional''),
(''Berkshire Intergroup'', ''10956'', ''10956'', ''Institutional''),
(''Berkshire Intergroup'', ''10956'', ''10956'', ''Professional''),
(''Bernardo H. Co. Club'', ''41556'', ''41556'', ''Institutional''),
(''Bernardo H. Co. Club'', ''41556'', ''41556'', ''Professional''),
(''Berwind Corporation'', ''J1031'', ''J1031'', ''Institutional''),
(''Berwind Corporation'', ''J1031'', ''J1031'', ''Professional''),
(''Best Life & Health Insurance Company  (Irvine, CA)'', ''95604'', ''95604'', ''Institutional''),
(''Best Life & Health Insurance Company  (Irvine, CA)'', ''95604'', ''95604'', ''Professional''),
(''Better Health Plan of Florida'', ''SMPLY'', ''SMPLY'', ''Institutional''),
(''Better Health Plan of Florida'', ''SMPLY'', ''SMPLY'', ''Professional''),
(''Beverly Alianza IPA'', ''NMM06'', ''NMM06'', ''Institutional''),
(''Beverly Alianza IPA'', ''NMM06'', ''NMM06'', ''Professional''),
(''Beverly Hills Carmel'', ''41556'', ''41556'', ''Institutional''),
(''Beverly Hills Carmel'', ''41556'', ''41556'', ''Professional''),
(''Beverly Hospital BEVAHISP'', ''MPM42'', ''MPM42'', ''Institutional''),
(''Beverly Hospital BEVAHISP'', ''MPM42'', ''MPM42'', ''Professional''),
(''Bienvivir'', ''BSHS1'', ''BSHS1'', ''Professional''),
(''Bienvivir Senior Health Services'', ''12X40'', ''12X40'', ''Institutional''),
(''Big 5 Corp'', ''J1738'', ''J1738'', ''Institutional''),
(''Big 5 Corp'', ''J1738'', ''J1738'', ''Professional''),
(''Big Lots Associate Benefit Plan (EBMC)'', ''31074'', ''31074'', ''Institutional''),
(''Big Lots Associate Benefit Plan (EBMC)'', ''31074'', ''31074'', ''Professional''),
(''Bighorn Construction'', ''41556'', ''41556'', ''Institutional''),
(''Bighorn Construction'', ''41556'', ''41556'', ''Professional''),
(''BIND (UHC Choice Plus Multiplan)'', ''25463'', ''25463'', ''Institutional''),
(''BIND (UHC Choice Plus Multiplan)'', ''25463'', ''25463'', ''Professional''),
(''Bituminous Fire and Marine'', ''J1691'', ''J1691'', ''Institutional''),
(''Bituminous Fire and Marine'', ''J1691'', ''J1691'', ''Professional''),
(''Bituminous Insurance Company'', ''J1579'', ''J1579'', ''Institutional''),
(''Bituminous Insurance Company'', ''J1579'', ''J1579'', ''Professional''),
(''Block Vision - Versant'', ''BV001'', ''BV001'', ''Professional''),
(''Bloomingdale''''s'', ''J1347'', ''J1347'', ''Institutional''),
(''Bloomingdale''''s'', ''J1347'', ''J1347'', ''Professional''),
(''Blue Benefit Administrators of MA'', ''03036'', ''03036'', ''Institutional''),
(''Blue Benefit Administrators of MA'', ''03036'', ''03036'', ''Professional''),
(''Blue Cross - Alaska, Premera'', ''00934'', ''AKBLU'', ''Professional''),
(''Blue Cross - Alaska, Premera'', ''12B47'', ''AKBLU'', ''Institutional''),
(''Blue Cross - California County Medical Services Program (CMSP)'', ''CMSPI'', ''CMSPI'', ''Institutional''),
(''Blue Cross - California, Anthem'', ''47198'', ''CABLC'', ''Institutional''),
(''Blue Cross - California, Anthem'', ''47198'', ''CABLC'', ''Professional''),
(''Blue Cross - Idaho'', ''BLUEC'', ''IDBLC'', ''Institutional''),
(''Blue Cross - Idaho'', ''BLUEC'', ''IDBLC'', ''Professional''),
(''Blue Cross - North Dakota'', ''12B78'', ''NDBLC'', ''Institutional''),
(''Blue Cross - Pennsylvania, Capital'', ''12B61'', ''PABLC'', ''Institutional''),
(''Blue Cross - Pennsylvania, Capital'', ''24705'', ''PABLC'', ''Professional''),
(''Blue Cross - Washington, Premera'', ''00934'', ''WABLU'', ''Professional''),
(''Blue Cross - Washington, Premera'', ''12B27'', ''WABLU'', ''Institutional''),
(''Blue Cross Community Centennial (New Mexico)'', ''MC721'', ''MC721'', ''Institutional''),
(''Blue Cross Community Centennial (New Mexico)'', ''MC721'', ''MC721'', ''Professional''),
(''Blue Plus Medical Assistance MNCARE'', ''00562'', ''MNADV'', ''Professional''),
(''Blue Plus Medical Assistance MNCARE'', ''MNADV'', ''MNADV'', ''Institutional''),
(''Blue Shield - California'', ''94036'', ''CABLS'', ''Institutional''),
(''Blue Shield - California'', ''94036'', ''CABLS'', ''Professional''),
(''Blue Shield - Idaho, Regence'', ''00611'', ''IDBLS'', ''Professional''),
(''Blue Shield - Idaho, Regence'', ''12B88'', ''IDBLS'', ''Institutional''),
(''Blue Shield - New York, Northeastern, ASK'', ''12B68'', ''00800'', ''Institutional''),
(''Blue Shield - New York, Northeastern, ASK'', ''SB800'', ''00800'', ''Professional''),
(''Blue Shield - North Dakota'', ''55891'', ''NDBLS'', ''Professional''),
(''Blue Shield - Puerto Rico Triple-S'', ''PRBLS'', ''PRBLS'', ''Institutional''),
(''Blue Shield - Puerto Rico Triple-S'', ''SB980'', ''PRBLS'', ''Professional''),
(''Blue Shield - Puerto Rico Triple-S Medicare Advantage'', ''973MA'', ''973MA'', ''Institutional''),
(''Blue Shield - Puerto Rico Triple-S Medicare Advantage'', ''973MA'', ''973MA'', ''Professional''),
(''Blue Shield - Washington, Regence'', ''00932'', ''WABLS'', ''Institutional''),
(''Blue Shield - Washington, Regence'', ''00932'', ''WABLS'', ''Professional''),
(''Blue Shield - Wyoming, Noridian'', ''SB960'', ''WYBLU'', ''Professional''),
(''Blue Shield of California Promise Health Plan'', ''57115'', ''57115'', ''Institutional''),
(''Blue Shield of California Promise Health Plan'', ''57115'', ''57115'', ''Professional''),
(''Blue Shield of California Promise Health Plan'', ''C1SCA'', ''C1SCA'', ''Institutional''),
(''Blue Shield of California Promise Health Plan'', ''C1SCA'', ''C1SCA'', ''Professional''),
(''Blue Shield of California Promise Health Plan (Encounters)'', ''EC1CA'', ''EC1CA'', ''Institutional''),
(''Blue Shield of California Promise Health Plan (Encounters)'', ''EC1CA'', ''EC1CA'', ''Professional''),
(''BlueChoice HealthPlan of South Carolina Medicaid, Anthem'', ''00403'', ''SCBCH'', ''Professional''),
(''BMW Manufacturing Corp.'', ''J1258'', ''J1258'', ''Professional''),
(''BMW North America'', ''J1259'', ''J1259'', ''Professional''),
(''Bobrick Washroom'', ''41556'', ''41556'', ''Institutional''),
(''Bobrick Washroom'', ''41556'', ''41556'', ''Professional''),
(''Boeing Company - AUTO ONLY'', ''C1054'', ''C1054'', ''Institutional''),
(''Boeing Company - AUTO ONLY'', ''C1054'', ''C1054'', ''Professional''),
(''Boeing Company - WC ONLY'', ''J1964'', ''J1964'', ''Institutional''),
(''Boeing Company - WC ONLY'', ''J1964'', ''J1964'', ''Professional''),
(''Boilermakers National Health & Welfare'', ''62308'', ''62308'', ''Institutional''),
(''Boilermakers National Health & Welfare'', ''62308'', ''62308'', ''Professional''),
(''Boise Cascade Company'', ''J1801'', ''J1801'', ''Institutional''),
(''Boise Cascade Company'', ''J1801'', ''J1801'', ''Professional''),
(''Boler Company'', ''J1870'', ''J1870'', ''Institutional''),
(''Boler Company'', ''J1870'', ''J1870'', ''Professional''),
(''Boncura Health Solutions - Ingalls Provider Group'', ''66727'', ''66727'', ''Institutional''),
(''Boncura Health Solutions - Ingalls Provider Group'', ''66727'', ''66727'', ''Professional''),
(''Boon Administrative Services, Inc. - The Boon Group'', ''BOONG'', ''BOONG'', ''Institutional''),
(''Boon Administrative Services, Inc. - The Boon Group'', ''BOONG'', ''BOONG'', ''Professional''),
(''Boon-Chapman Benefit Administrators'', ''74238'', ''74238'', ''Institutional''),
(''Boon-Chapman Benefit Administrators'', ''74238'', ''74238'', ''Professional''),
(''Boston Medical Center Health Plan, Inc. (BMC HealthNet Plan)'', ''13337'', ''13337'', ''Institutional''),
(''Boston Medical Center Health Plan, Inc. (BMC HealthNet Plan)'', ''13337'', ''13337'', ''Professional''),
(''Boulder Administration Services - BASI - UCS'', ''18768'', ''18768'', ''Institutional''),
(''Boulder Administration Services - BASI - UCS'', ''18768'', ''18768'', ''Professional''),
(''Boulder Community Hospital'', ''41556'', ''41556'', ''Institutional''),
(''Boulder Community Hospital'', ''41556'', ''41556'', ''Professional''),
(''Brand New Day (Encounters)'', ''UC002'', ''UC002'', ''Institutional''),
(''Brand New Day (Encounters)'', ''UC002'', ''UC002'', ''Professional''),
(''Brand New Day (FFS)'', ''UC001'', ''UC001'', ''Institutional''),
(''Brand New Day (FFS)'', ''UC001'', ''UC001'', ''Professional''),
(''Bravo Health'', ''52192'', ''52192'', ''Institutional''),
(''Bravo Health'', ''52192'', ''52192'', ''Professional''),
(''Bravo Health Star Plus'', ''52192'', ''52192'', ''Institutional''),
(''Bravo Health Star Plus'', ''52192'', ''52192'', ''Professional''),
(''Breathco/CSL Pulmonary'', ''65005'', ''65005'', ''Professional''),
(''Bremco Construction'', ''41556'', ''41556'', ''Institutional''),
(''Bremco Construction'', ''41556'', ''41556'', ''Professional''),
(''Brickstreet'', ''J1761'', ''J1761'', ''Institutional''),
(''Brickstreet'', ''J1761'', ''J1761'', ''Professional''),
(''BridgeSpan Health'', ''BRIDG'', ''BRIDG'', ''Institutional''),
(''BridgeSpan Health'', ''BRIDG'', ''BRIDG'', ''Professional''),
(''Bridgeview Company'', ''FS802'', ''FS802'', ''Professional''),
(''Bridgeway Health Solutions - Arizona'', ''68069'', ''68069'', ''Institutional''),
(''Bridgeway Health Solutions - Arizona'', ''68069'', ''68069'', ''Professional''),
(''Bright Health (Commercial)'', ''CB186'', ''CB186'', ''Institutional''),
(''Bright Health (Commercial)'', ''CB186'', ''CB186'', ''Professional''),
(''Bright Health Plan - Medicare Advantage'', ''BRT01'', ''BRT01'', ''Institutional''),
(''Bright Health Plan - Medicare Advantage'', ''BRT01'', ''BRT01'', ''Professional''),
(''Bristol Park Medical Group'', ''MMFMC'', ''MMFMC'', ''Professional''),
(''Bristol West'', ''J1764'', ''J1764'', ''Institutional''),
(''Bristol West'', ''J1764'', ''J1764'', ''Professional''),
(''Broadspire, a Crawford Company'', ''TP021'', ''TP021'', ''Institutional''),
(''Broadspire, a Crawford Company'', ''TP021'', ''TP021'', ''Professional''),
(''Brokerage Concepts, Inc.'', ''51037'', ''51037'', ''Institutional''),
(''Brokerage Concepts, Inc.'', ''51037'', ''51037'', ''Professional''),
(''Brookshire IPA'', ''BIPAZ'', ''BIPAZ'', ''Professional''),
(''Brookshire IPA'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Brotherhood Mutual Insurance'', ''J1445'', ''J1445'', ''Institutional''),
(''Brotherhood Mutual Insurance'', ''J1445'', ''J1445'', ''Professional''),
(''Brown &  Toland Group'', ''BTSS1'', ''BTSS1'', ''Professional''),
(''Brown & Toland Health Services'', ''BTHS1'', ''BTHS1'', ''Institutional''),
(''Brown & Toland Health Services'', ''BTHS1'', ''BTHS1'', ''Professional''),
(''Brown & Toland Medical Group'', ''94316'', ''94316'', ''Institutional''),
(''Brown & Toland Medical Group'', ''94316'', ''94316'', ''Professional''),
(''Brownsville Independent School District'', ''41556'', ''41556'', ''Institutional''),
(''Brownsville Independent School District'', ''41556'', ''41556'', ''Professional''),
(''Brownyard Group Inc. (Arch Insurance)'', ''11150'', ''11150'', ''Institutional''),
(''Brownyard Group Inc. (Arch Insurance)'', ''11150'', ''11150'', ''Professional''),
(''Brunswick Corporation'', ''J1032'', ''J1032'', ''Institutional''),
(''Brunswick Corporation'', ''J1032'', ''J1032'', ''Professional''),
(''Bryan Independent School District'', ''BRISD'', ''BRISD'', ''Institutional''),
(''Bryan Independent School District'', ''BRISD'', ''BRISD'', ''Professional''),
(''Buckeye Community Health Plan - Ohio'', ''68069'', ''68069'', ''Institutional''),
(''Buckeye Community Health Plan - Ohio'', ''68069'', ''68069'', ''Professional''),
(''Buffets Inc (Old Country Buffett, Ryan''''s, HomeTown Buffet, Fire Mountain, Country Buffett, Granny''''s Buffett) (Bunch CareSolutions)'', ''J1501'', ''J1501'', ''Institutional''),
(''Buffets Inc (Old Country Buffett, Ryan''''s, HomeTown Buffet, Fire Mountain, Country Buffett, Granny''''s Buffett) (Bunch CareSolutions)'', ''J1501'', ''J1501'', ''Professional''),
(''Builders Group of MN'', ''J1391'', ''J1391'', ''Institutional''),
(''Builders Group of MN'', ''J1391'', ''J1391'', ''Professional''),
(''Builders Insurance Group (GA only)'', ''J3975'', ''J3975'', ''Institutional''),
(''Builders Insurance Group (GA only)'', ''J3975'', ''J3975'', ''Professional''),
(''Builders Mutual Insurance'', ''J1968'', ''J1968'', ''Institutional''),
(''Builders Mutual Insurance'', ''J1968'', ''J1968'', ''Professional''),
(''Bunch CareSolutions'', ''J1435'', ''J1435'', ''Institutional''),
(''Bunch CareSolutions'', ''J1435'', ''J1435'', ''Professional''),
(''Bureau for Children with Medical Handicaps'', ''BCMH1'', ''BCMH1'', ''Professional''),
(''Burlington Coat Factory Wareho'', ''J1033'', ''J1033'', ''Institutional''),
(''Burlington Coat Factory Wareho'', ''J1033'', ''J1033'', ''Professional''),
(''Burton Way Carmel'', ''41556'', ''41556'', ''Institutional''),
(''Burton Way Carmel'', ''41556'', ''41556'', ''Professional''),
(''Butler Benefit'', ''42150'', ''42150'', ''Institutional''),
(''Butler Benefit'', ''42150'', ''42150'', ''Professional''),
(''Bycor Gen Contract'', ''41556'', ''41556'', ''Institutional''),
(''Bycor Gen Contract'', ''41556'', ''41556'', ''Professional''),
(''C&O Employees Hospital Association'', ''23708'', ''23708'', ''Professional''),
(''Cadet Uniform Supply'', ''41556'', ''41556'', ''Institutional''),
(''Cadet Uniform Supply'', ''41556'', ''41556'', ''Professional''),
(''Caduceus Medical Group (Regal)'', ''REGAL'', ''REGAL'', ''Institutional''),
(''Caduceus Medical Group (Regal)'', ''REGAL'', ''REGAL'', ''Professional''),
(''Cal Care IPA Claims'', ''PPM01'', ''PPM01'', ''Institutional''),
(''Cal Care IPA Claims'', ''PPM01'', ''PPM01'', ''Professional''),
(''Cal Care IPA Encounters'', ''PPM02'', ''PPM02'', ''Institutional''),
(''Cal Care IPA Encounters'', ''PPM02'', ''PPM02'', ''Professional''),
(''California Alcohol & Drug Program - Non-perinatal Services'', ''CAADP'', ''CAADP'', ''Professional''),
(''California Alcohol & Drug Program - Perinatal Services'', ''CAADP'', ''CAADP'', ''Professional''),
(''California Department of Mental Health'', ''CADMH'', ''CADMH'', ''Professional''),
(''California Eye Care'', ''CEC01'', ''CEC01'', ''Professional''),
(''California Fair Services Authority'', ''J1535'', ''J1535'', ''Institutional''),
(''California Fair Services Authority'', ''J1535'', ''J1535'', ''Professional''),
(''California Health & Wellness'', ''68047'', ''68047'', ''Institutional''),
(''California Health & Wellness'', ''68047'', ''68047'', ''Professional''),
(''California Insurance Guarantee Assoc - CIGA'', ''J1532'', ''J1532'', ''Institutional''),
(''California Insurance Guarantee Assoc - CIGA'', ''J1532'', ''J1532'', ''Professional''),
(''California IPA'', ''AMM14'', ''CAIPA'', ''Institutional''),
(''California IPA'', ''AMM14'', ''CAIPA'', ''Professional''),
(''California Kids Care (CKC)'', ''CKC01'', ''CKC01'', ''Institutional''),
(''California Kids Care (CKC)'', ''CKC01'', ''CKC01'', ''Professional''),
(''California Pacific Medical Center'', ''94056'', ''94056'', ''Professional''),
(''California Pacific Physicians Medical Group'', ''HSM01'', ''HSM01'', ''Institutional''),
(''California Pacific Physicians Medical Group'', ''HSM01'', ''HSM01'', ''Professional''),
(''California Rural Indian Health Board - CRIHB Care'', ''CRIHB'', ''CRIHB'', ''Institutional''),
(''California Rural Indian Health Board - CRIHB Care'', ''CRIHB'', ''CRIHB'', ''Professional''),
(''California Rural Indian Health Board - CRIHB Options'', ''CRIHB'', ''CRIHB'', ''Institutional''),
(''California Rural Indian Health Board - CRIHB Options'', ''CRIHB'', ''CRIHB'', ''Professional''),
(''California Water Service Company'', ''41556'', ''41556'', ''Institutional''),
(''California Water Service Company'', ''41556'', ''41556'', ''Professional''),
(''Callahan, McCune'', ''41556'', ''41556'', ''Institutional''),
(''Callahan, McCune'', ''41556'', ''41556'', ''Professional''),
(''CalOptima Direct - Commercial'', ''CALOP'', ''CALOP'', ''Institutional''),
(''CalOptima Direct - Commercial'', ''CALOP'', ''CALOP'', ''Professional''),
(''CalOptima LTC'', ''COLTC'', ''COLTC'', ''Institutional''),
(''Cambridge Integrated Services'', ''J1819'', ''J1819'', ''Institutional''),
(''Cambridge Integrated Services'', ''J1819'', ''J1819'', ''Professional''),
(''Cameron & Associates'', ''CAMAA'', ''CAMAA'', ''Professional''),
(''Campbell Union School District'', ''41556'', ''41556'', ''Institutional''),
(''Campbell Union School District'', ''41556'', ''41556'', ''Professional''),
(''Cannon Cochran Management Services, Inc.'', ''37105'', ''37105'', ''Institutional''),
(''Cannon Cochran Management Services, Inc.'', ''37105'', ''37105'', ''Professional''),
(''Cap Management Systems'', ''95399'', ''95399'', ''Institutional''),
(''Cap Management Systems'', ''95399'', ''95399'', ''Professional''),
(''Cape Health Plan'', ''38245'', ''38245'', ''Institutional''),
(''Cape Health Plan'', ''38245'', ''38245'', ''Professional''),
(''Capistrano Unified School District (CA)'', ''J1637'', ''J1637'', ''Institutional''),
(''Capistrano Unified School District (CA)'', ''J1637'', ''J1637'', ''Professional''),
(''Capital Advantage Insurance Company (CAIC)'', ''23045'', ''23045'', ''Professional''),
(''Capital Community Health Plan'', ''87726'', ''87726'', ''Institutional''),
(''Capital District Physicians Health Plan (CDPHP)'', ''95491'', ''95491'', ''Institutional''),
(''Capital District Physicians Health Plan (CDPHP)'', ''SX065'', ''95491'', ''Professional''),
(''Capital Health Plan'', ''95112'', ''95112'', ''Professional''),
(''Capitol Administrators'', ''68011'', ''68011'', ''Institutional''),
(''Capitol Administrators'', ''68011'', ''68011'', ''Professional''),
(''Capitol Indemnity'', ''J1262'', ''J1262'', ''Institutional''),
(''Capitol Indemnity'', ''J1262'', ''J1262'', ''Professional''),
(''Capitol Insurance Companies'', ''J1809'', ''J1809'', ''Institutional''),
(''Capitol Insurance Companies'', ''J1809'', ''J1809'', ''Professional''),
(''Caprock Health Plan'', ''CAPHP'', ''CAPHP'', ''Institutional''),
(''Caprock Health Plan'', ''CAPHP'', ''CAPHP'', ''Professional''),
(''CapRock Health Plan - Verity'', ''CAPH2'', ''CAPH2'', ''Institutional''),
(''CapRock Health Plan - Verity'', ''CAPH2'', ''CAPH2'', ''Professional''),
(''CAPS-SIG'', ''41556'', ''41556'', ''Institutional''),
(''CAPS-SIG'', ''41556'', ''41556'', ''Professional''),
(''Cardinal Innovations'', ''06607'', ''06607'', ''Institutional''),
(''Cardinal Innovations'', ''06607'', ''06607'', ''Professional''),
(''Cardiovascular Care Providers Inc. (CVCP)'', ''GCVCP'', ''GCVCP'', ''Institutional''),
(''Cardiovascular Care Providers Inc. (CVCP)'', ''GCVCP'', ''GCVCP'', ''Professional''),
(''Care 1st Health Plan (Arizona)'', ''57116'', ''57116'', ''Institutional''),
(''Care 1st Health Plan (Arizona)'', ''57116'', ''57116'', ''Professional''),
(''Care Access PSN'', ''65063'', ''65063'', ''Institutional''),
(''Care Access PSN'', ''65063'', ''65063'', ''Professional''),
(''Care Improvement Plus'', ''87726'', ''87726'', ''Institutional''),
(''Care Improvement Plus'', ''87726'', ''87726'', ''Professional''),
(''Care N'''' Care'', ''66010'', ''66010'', ''Institutional''),
(''Care N'''' Care'', ''66010'', ''66010'', ''Professional''),
(''Care Provider Network'', ''42148'', ''42148'', ''Professional''),
(''Care to Care'', ''41222'', ''41222'', ''Institutional''),
(''Care to Care'', ''41222'', ''41222'', ''Professional''),
(''Care Wisconsin Health Plans'', ''27004'', ''27004'', ''Institutional''),
(''Care Wisconsin Health Plans'', ''27004'', ''27004'', ''Professional''),
(''CareCentrix'', ''11345'', ''11345'', ''Institutional''),
(''CareCentrix'', ''11345'', ''11345'', ''Professional''),
(''CareCentrix Cigna'', ''11346'', ''11346'', ''Institutional''),
(''CareCentrix Cigna'', ''11346'', ''11346'', ''Professional''),
(''CareCentrix Florida Blue'', ''11347'', ''11347'', ''Institutional''),
(''CareCentrix Florida Blue'', ''11347'', ''11347'', ''Professional''),
(''CareCentrix Horizon'', ''11348'', ''11348'', ''Institutional''),
(''CareCentrix Horizon'', ''11348'', ''11348'', ''Professional''),
(''CareCore - Wellcare New York'', ''14188'', ''14188'', ''Institutional''),
(''CareCore - Wellcare New York'', ''14188'', ''14188'', ''Professional''),
(''CareCore National, LLC (GHI-HIP Radiology Claims)'', ''14182'', ''14182'', ''Professional''),
(''CareCore National, LLC (Oxford Radiology Claims)'', ''14180'', ''14180'', ''Professional''),
(''CareFirst Administrators/NCAS, Charlotte NC'', ''75191'', ''75191'', ''Institutional''),
(''CareFirst Administrators/NCAS, Charlotte NC'', ''75191'', ''75191'', ''Professional''),
(''CareFirst Administrators/NCAS, Fairfax, VA'', ''75190'', ''75190'', ''Institutional''),
(''CareFirst Administrators/NCAS, Fairfax, VA'', ''75190'', ''75190'', ''Professional''),
(''CareFirst BCBS Community Health Plan DC, fka Trusted Health Plan'', ''L0230'', ''L0230'', ''Institutional''),
(''CareFirst BCBS Community Health Plan DC, fka Trusted Health Plan'', ''L0230'', ''L0230'', ''Professional''),
(''CareMore Health Plan'', ''CARMO'', ''CARMO'', ''Institutional''),
(''CareMore Health Plan'', ''CARMO'', ''CARMO'', ''Professional''),
(''CareOregon'', ''93975'', ''93975'', ''Institutional''),
(''CareOregon'', ''93975'', ''93975'', ''Professional''),
(''CarePartners of Connecticut (CPCT)'', ''16307'', ''16307'', ''Institutional''),
(''CarePartners of Connecticut (CPCT)'', ''16307'', ''16307'', ''Professional''),
(''CarePlus Health Plans, Inc.'', ''65031'', ''65031'', ''Professional''),
(''CareSource Georgia'', ''GACS1'', ''GACS1'', ''Institutional''),
(''CareSource Georgia'', ''GACS1'', ''GACS1'', ''Professional''),
(''CareSource Indiana'', ''INCS1'', ''INCS1'', ''Institutional''),
(''CareSource Indiana'', ''INCS1'', ''INCS1'', ''Professional''),
(''CareSource Kentucky'', ''KYCS1'', ''KYCS1'', ''Institutional''),
(''CareSource Kentucky'', ''KYCS1'', ''KYCS1'', ''Professional''),
(''CareSource Ohio'', ''31114'', ''31114'', ''Institutional''),
(''CareSource Ohio'', ''31114'', ''31114'', ''Professional''),
(''CareSource West Virginia'', ''WVCS1'', ''WVCS1'', ''Institutional''),
(''CareSource West Virginia'', ''WVCS1'', ''WVCS1'', ''Professional''),
(''Careworks'', ''10010'', ''10010'', ''Institutional''),
(''Careworks'', ''10010'', ''10010'', ''Professional''),
(''CareWorks Consultants, Inc. (aka CareWorks USA and CCI) - OHIO ONLY'', ''J1866'', ''J1866'', ''Institutional''),
(''CareWorks Consultants, Inc. (aka CareWorks USA and CCI) - OHIO ONLY'', ''J1866'', ''J1866'', ''Professional''),
(''Carhartt'', ''J1931'', ''J1931'', ''Institutional''),
(''Carhartt'', ''J1931'', ''J1931'', ''Professional''),
(''Carisk Imaging to City of Jersey City'', ''J3998'', ''J3998'', ''Institutional''),
(''Carisk Imaging to City of Jersey City'', ''J3998'', ''J3998'', ''Professional''),
(''Carolina Behavioral Health Alliance'', ''56215'', ''56215'', ''Institutional''),
(''Carolina Behavioral Health Alliance'', ''56215'', ''56215'', ''Professional''),
(''Carolina Care Plan'', ''29076'', ''29076'', ''Institutional''),
(''Carolina Care Plan'', ''29076'', ''29076'', ''Professional''),
(''Carolina Summit Healthcare, Inc.'', ''56195'', ''56195'', ''Institutional''),
(''Carolina Summit Healthcare, Inc.'', ''56195'', ''56195'', ''Professional''),
(''Carpenter''''s Health & Welfare Fund (Philadelphia, PA)'', ''CX101'', ''CX101'', ''Professional''),
(''Cascade East Health Plans'', ''93040'', ''93040'', ''Institutional''),
(''Cascade East Health Plans'', ''93040'', ''93040'', ''Professional''),
(''Cascade Health Alliance, Inc.'', ''CHA01'', ''CHA01'', ''Institutional''),
(''Cascade Health Alliance, Inc.'', ''CHA01'', ''CHA01'', ''Professional''),
(''Casitas Municipal Water District (CA)'', ''J1630'', ''J1630'', ''Institutional''),
(''Casitas Municipal Water District (CA)'', ''J1630'', ''J1630'', ''Professional''),
(''Castlepoint Insurance Company'', ''J3963'', ''J3963'', ''Institutional''),
(''Castlepoint Insurance Company'', ''J3963'', ''J3963'', ''Professional''),
(''Castlepoint National Insurance Company'', ''J3964'', ''J3964'', ''Institutional''),
(''Castlepoint National Insurance Company'', ''J3964'', ''J3964'', ''Professional''),
(''Catholic Diocese of San Diego'', ''41556'', ''41556'', ''Institutional''),
(''Catholic Diocese of San Diego'', ''41556'', ''41556'', ''Professional''),
(''Catholic Life Ins - United Financial'', ''87020'', ''87020'', ''Institutional''),
(''Catholic Life Ins - United Financial'', ''87020'', ''87020'', ''Professional''),
(''Catholic Mutual - Preferred Professional Insurance Company'', ''41556'', ''41556'', ''Institutional''),
(''Catholic Mutual - Preferred Professional Insurance Company'', ''41556'', ''41556'', ''Professional''),
(''Catholic Mutual - Virginia Surety Company, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Catholic Mutual - Virginia Surety Company, Inc.'', ''41556'', ''41556'', ''Professional''),
(''CC-Development Group, Inc.'', ''J1900'', ''J1900'', ''Institutional''),
(''CC-Development Group, Inc.'', ''J1900'', ''J1900'', ''Professional''),
(''CCMSI'', ''J1010'', ''J1010'', ''Institutional''),
(''CCMSI'', ''J1010'', ''J1010'', ''Professional''),
(''Cedar Valley Community HealthCare (CVCH)'', ''42558'', ''42558'', ''Professional''),
(''Cedars-Sinai Health System'', ''41556'', ''41556'', ''Institutional''),
(''Cedars-Sinai Health System'', ''41556'', ''41556'', ''Professional''),
(''Cedars-Sinai Medical Network Services'', ''95166'', ''95166'', ''Professional''),
(''Cedars-Sinai Medical Network Services'', ''95167'', ''95167'', ''Professional''),
(''Celtic Insurance'', ''68063'', ''68063'', ''Institutional''),
(''Celtic Insurance'', ''68063'', ''68063'', ''Professional''),
(''Celticare Health Plan - Massachusetts'', ''68069'', ''68069'', ''Institutional''),
(''Celticare Health Plan - Massachusetts'', ''68069'', ''68069'', ''Professional''),
(''Cement Masons & Plasterers Health & Welfare Trust'', ''91136'', ''91136'', ''Institutional''),
(''Cement Masons & Plasterers Health & Welfare Trust'', ''91136'', ''91136'', ''Professional''),
(''CenCal Health fka Santa Barbara Regional Health Authority'', ''SBRHA'', ''SBRHA'', ''Institutional''),
(''CenCal Health fka Santa Barbara Regional Health Authority'', ''SBRHA'', ''SBRHA'', ''Professional''),
(''Cendant Corporation'', ''J1034'', ''J1034'', ''Institutional''),
(''Cendant Corporation'', ''J1034'', ''J1034'', ''Professional''),
(''Cenpatico  - Kentucky'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico  - Kentucky'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Arizona'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Arizona'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Florida'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Florida'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Georgia'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Georgia'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Indiana'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Indiana'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Kansas'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Kansas'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Louisiana'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Louisiana'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Massachusetts'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Massachusetts'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Ohio'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Ohio'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - South Carolina'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - South Carolina'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Texas'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Texas'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico - Wisconsin'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico - Wisconsin'', ''68068'', ''68068'', ''Professional''),
(''Cenpatico Behavioral Health'', ''68068'', ''68068'', ''Institutional''),
(''Cenpatico Behavioral Health'', ''68068'', ''68068'', ''Professional''),
(''Center for Elders Independence'', ''94312'', ''94312'', ''Institutional''),
(''Center for Elders Independence'', ''94312'', ''94312'', ''Professional''),
(''Center for Sight'', ''CFS01'', ''CFS01'', ''Professional''),
(''Center IPA'', ''POP01'', ''POP01'', ''Professional''),
(''CenterCare'', ''11315'', ''11315'', ''Institutional''),
(''CenterCare'', ''11315'', ''11315'', ''Professional''),
(''CenterLight Healthcare'', ''13360'', ''13360'', ''Institutional''),
(''CenterLight Healthcare'', ''13360'', ''13360'', ''Professional''),
(''Centers Plan for Healthy Living'', ''CPHL1'', ''CPHL1'', ''Institutional''),
(''Centers Plan for Healthy Living'', ''CPHL1'', ''CPHL1'', ''Professional''),
(''Centinela Valley IPA (Encounters)'', ''UC002'', ''UC002'', ''Institutional''),
(''Centinela Valley IPA (Encounters)'', ''UC002'', ''UC002'', ''Professional''),
(''Centinela Valley IPA (MedPOINT) California'', ''MPM03'', ''MPM03'', ''Professional''),
(''Centivo'', ''45564'', ''45564'', ''Institutional''),
(''Centivo'', ''45564'', ''45564'', ''Professional''),
(''Central California Alliance for Health - CCAH'', ''CCA01'', ''95311'', ''Institutional''),
(''Central California Alliance for Health - CCAH'', ''CCA01'', ''95311'', ''Professional''),
(''Central Contra Costa Transit Authority'', ''J1605'', ''J1605'', ''Institutional''),
(''Central Contra Costa Transit Authority'', ''J1605'', ''J1605'', ''Professional''),
(''Central DuPage Medical Group - Boncura Health'', ''DMG01'', ''DMG01'', ''Institutional''),
(''Central DuPage Medical Group - Boncura Health'', ''DMG01'', ''DMG01'', ''Professional''),
(''Central Health Medicare Plan'', ''CHCPI'', ''CHCPI'', ''Institutional''),
(''Central Health Medicare Plan'', ''CHCPI'', ''CHCPI'', ''Professional''),
(''Central Hockey League'', ''J1035'', ''J1035'', ''Institutional''),
(''Central Hockey League'', ''J1035'', ''J1035'', ''Professional''),
(''Central Mass Health Care (CMHC)'', ''02041'', ''02041'', ''Institutional''),
(''Central Mass Health Care (CMHC)'', ''02041'', ''02041'', ''Professional''),
(''Central Reserve Life'', ''34097'', ''34097'', ''Institutional''),
(''Central Reserve Life'', ''34097'', ''34097'', ''Professional''),
(''Central Reserve Life Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Institutional''),
(''Central Reserve Life Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Professional''),
(''Central States Health & Welfare Funds'', ''36215'', ''36215'', ''Institutional''),
(''Central States Health & Welfare Funds'', ''36215'', ''36215'', ''Professional''),
(''Centurion'', ''42140'', ''42140'', ''Institutional''),
(''Centurion'', ''42140'', ''42140'', ''Professional''),
(''Century PHO, Inc'', ''36393'', ''36393'', ''Institutional''),
(''Century PHO, Inc'', ''36393'', ''36393'', ''Professional''),
(''CHA - Commonwealth Health Alliance'', ''23171'', ''23171'', ''Institutional''),
(''CHA - Commonwealth Health Alliance'', ''23171'', ''23171'', ''Professional''),
(''Chaffey Joint Union H. S. District (CA)'', ''J1646'', ''J1646'', ''Institutional''),
(''Chaffey Joint Union H. S. District (CA)'', ''J1646'', ''J1646'', ''Professional''),
(''CHAMPVA - HAC'', ''84146'', ''84146'', ''Institutional''),
(''CHAMPVA - HAC'', ''84146'', ''84146'', ''Professional''),
(''Chandler''''s P. Verdes'', ''41556'', ''41556'', ''Institutional''),
(''Chandler''''s P. Verdes'', ''41556'', ''41556'', ''Professional''),
(''Chapman Convalescent'', ''41556'', ''41556'', ''Institutional''),
(''Chapman Convalescent'', ''41556'', ''41556'', ''Professional''),
(''Charming Shoppes, Inc.'', ''J1036'', ''J1036'', ''Institutional''),
(''Charming Shoppes, Inc.'', ''J1036'', ''J1036'', ''Professional''),
(''Chautauqua County Healthcare Plan - Mayville, New York'', ''16600'', ''16600'', ''Institutional''),
(''Chautauqua County Healthcare Plan - Mayville, New York'', ''16600'', ''16600'', ''Professional''),
(''CHCcares of South Carolina'', ''25151'', ''25151'', ''Institutional''),
(''CHCcares of South Carolina'', ''25151'', ''25151'', ''Professional''),
(''Cherokee Insurance'', ''J1970'', ''J1970'', ''Institutional''),
(''Cherokee Insurance'', ''J1970'', ''J1970'', ''Professional''),
(''Chesapeake Insurance'', ''J1908'', ''J1908'', ''Institutional''),
(''Chesapeake Insurance'', ''J1908'', ''J1908'', ''Professional''),
(''Chesterfield Resources'', ''34154'', ''34154'', ''Institutional''),
(''Chesterfield Resources'', ''34154'', ''34154'', ''Professional''),
(''Chesterfield Services, Inc.'', ''J1479'', ''J1479'', ''Institutional''),
(''Chesterfield Services, Inc.'', ''J1479'', ''J1479'', ''Professional''),
(''Chico''''s Fas Inc.'', ''J2315'', ''J2315'', ''Institutional''),
(''Chico''''s Fas Inc.'', ''J2315'', ''J2315'', ''Professional''),
(''Childhealth Plus by Healthfirst (CHP)'', ''80141'', ''80141'', ''Institutional''),
(''Childhealth Plus by Healthfirst (CHP)'', ''80141'', ''80141'', ''Professional''),
(''Children First Medical Group'', ''94321'', ''94321'', ''Professional''),
(''Children of Women Vietnam Veterans - VA HAC'', ''84146'', ''84146'', ''Institutional''),
(''Children of Women Vietnam Veterans - VA HAC'', ''84146'', ''84146'', ''Professional''),
(''Children''''s Hospital Colorado'', ''41556'', ''41556'', ''Institutional''),
(''Children''''s Hospital Colorado'', ''41556'', ''41556'', ''Professional''),
(''Children''''s Hospital of Orange County - First Aid'', ''41556'', ''41556'', ''Institutional''),
(''Children''''s Hospital of Orange County - First Aid'', ''41556'', ''41556'', ''Professional''),
(''Children''''s Hospital Orange County (CHOC) Health Alliance'', ''33065'', ''33065'', ''Institutional''),
(''Children''''s Hospital Orange County (CHOC) Health Alliance'', ''33065'', ''33065'', ''Professional''),
(''Children''''s Medical Center Health Plan'', ''CMCHP'', ''CMCHP'', ''Institutional''),
(''Children''''s Medical Center Health Plan'', ''CMCHP'', ''CMCHP'', ''Professional''),
(''Children''''s Physician Medical Group'', ''CPMG1'', ''CPMG1'', ''Institutional''),
(''Children''''s Physician Medical Group'', ''CPMG1'', ''CPMG1'', ''Professional''),
(''Chinese Community Health Plan'', ''94302'', ''94302'', ''Institutional''),
(''Chinese Community Health Plan'', ''94302'', ''94302'', ''Professional''),
(''Chino Valley Medical Group'', ''CVMC1'', ''CVMC1'', ''Institutional''),
(''Chino Valley Medical Group'', ''CVMC1'', ''CVMC1'', ''Professional''),
(''CHIP - Community First'', ''COMMF'', ''COMMF'', ''Institutional''),
(''CHIP - Community First'', ''COMMF'', ''COMMF'', ''Professional''),
(''CHIP - Teens to Tots/Texas University Health'', ''TTPCH'', ''TTPCH'', ''Professional''),
(''Chiropractic Associates of SD - Dakotacare (CASD)'', ''CASD1'', ''CASD1'', ''Professional''),
(''Chiropractic Associates of SD - Stanford (CASD)'', ''CASD2'', ''CASD2'', ''Professional''),
(''Chiropractic Health Plans (CHP) - Deseret Mutual Benefits Administration'', ''U1439'', ''U1439'', ''Institutional''),
(''Chiropractic Health Plans (CHP) - Deseret Mutual Benefits Administration'', ''U1439'', ''U1439'', ''Professional''),
(''Chiropractic Health Plans (CHP) - University of Utah Health Plans'', ''U1439'', ''U1439'', ''Institutional''),
(''Chiropractic Health Plans (CHP) - University of Utah Health Plans'', ''U1439'', ''U1439'', ''Professional''),
(''Choice Medical Group'', ''CMG01'', ''CMG01'', ''Institutional''),
(''Choice Medical Group'', ''CMG01'', ''CMG01'', ''Professional''),
(''Choice Physicians Net First Choice'', ''CPNFC'', ''CPNFC'', ''Institutional''),
(''Choice Physicians Net First Choice'', ''CPNFC'', ''CPNFC'', ''Professional''),
(''Choice Physicians Net QualCare'', ''CPNQC'', ''CPNQC'', ''Institutional''),
(''Choice Physicians Net QualCare'', ''CPNQC'', ''CPNQC'', ''Professional''),
(''Choice Physicians Network'', ''CPN01'', ''CPN01'', ''Institutional''),
(''Choice Physicians Network'', ''CPN01'', ''CPN01'', ''Professional''),
(''Christian Brothers Services'', ''38308'', ''38308'', ''Institutional''),
(''Christian Brothers Services'', ''38308'', ''38308'', ''Professional''),
(''Christian Care Ministries'', ''59355'', ''59355'', ''Institutional''),
(''Christian Care Ministries'', ''59355'', ''59355'', ''Professional''),
(''Christus Health Medicare Advantage'', ''10629'', ''10629'', ''Institutional''),
(''Christus Health Medicare Advantage'', ''10629'', ''10629'', ''Professional''),
(''Christus Health New Mexico HIX'', ''21062'', ''21062'', ''Institutional''),
(''Christus Health New Mexico HIX'', ''21062'', ''21062'', ''Professional''),
(''Christus Health Plan TX HIX'', ''52106'', ''52106'', ''Institutional''),
(''Christus Health Plan TX HIX'', ''52106'', ''52106'', ''Professional''),
(''Christus Spohn Health Network'', ''SPOHN'', ''SPOHN'', ''Institutional''),
(''Christus Spohn Health Network'', ''SPOHN'', ''SPOHN'', ''Professional''),
(''Chubb  (Work Comp Only)'', ''J1554'', ''J1554'', ''Institutional''),
(''Chubb  (Work Comp Only)'', ''J1554'', ''J1554'', ''Professional''),
(''Chubb & Son (Auto Only)'', ''C1052'', ''C1052'', ''Institutional''),
(''Chubb & Son (Auto Only)'', ''C1052'', ''C1052'', ''Professional''),
(''Chubb Services - Gallagher Basset'', ''J1561'', ''J1561'', ''Institutional''),
(''Chubb Services - Gallagher Basset'', ''J1561'', ''J1561'', ''Professional''),
(''Church Mutual Insurance Company (WC ONLY)'', ''J1265'', ''J1265'', ''Institutional''),
(''Church Mutual Insurance Company (WC ONLY)'', ''J1265'', ''J1265'', ''Professional''),
(''CIGNA'', ''62308'', ''62308'', ''Institutional''),
(''CIGNA'', ''62308'', ''62308'', ''Professional''),
(''CIGNA - Behavioral Health'', ''62308'', ''MCCBV'', ''Professional''),
(''CIGNA - Behavioral Health'', ''MCCBV'', ''MCCBV'', ''Institutional''),
(''Cigna - Great West Health'', ''62308'', ''62308'', ''Institutional''),
(''Cigna - Great West Health'', ''62308'', ''62308'', ''Professional''),
(''Cigna - Healthspring'', ''52192'', ''52192'', ''Institutional''),
(''Cigna - Healthspring'', ''52192'', ''52192'', ''Professional''),
(''Cigna Medicare Access'', ''86033'', ''86033'', ''Institutional''),
(''Cigna Medicare Access'', ''86033'', ''86033'', ''Professional''),
(''Cigna Medicare Advantage'', ''62308'', ''62308'', ''Institutional''),
(''Cigna Medicare Advantage'', ''62308'', ''62308'', ''Professional''),
(''Cigna Medicare Select Advantage'', ''86033'', ''86033'', ''Institutional''),
(''Cigna Medicare Select Advantage'', ''86033'', ''86033'', ''Professional''),
(''CIM Insurance Corporation'', ''C1028'', ''C1028'', ''Institutional''),
(''CIM Insurance Corporation'', ''C1028'', ''C1028'', ''Professional''),
(''Cincinnati Insurance'', ''J1562'', ''J1562'', ''Institutional''),
(''Cincinnati Insurance'', ''J1562'', ''J1562'', ''Professional''),
(''Cities Group'', ''CITG1'', ''WCPAP'', ''Institutional''),
(''Cities Group'', ''CITG1'', ''WCPAP'', ''Professional''),
(''Citizens Insurance Company of America'', ''J1582'', ''J1582'', ''Institutional''),
(''Citizens Insurance Company of America'', ''J1582'', ''J1582'', ''Professional''),
(''Citrus Health Care'', ''10207'', ''10207'', ''Institutional''),
(''Citrus Health Care'', ''10207'', ''10207'', ''Professional''),
(''Citrus Valley Health Partners'', ''J1613'', ''J1613'', ''Institutional''),
(''Citrus Valley Health Partners'', ''J1613'', ''J1613'', ''Professional''),
(''Citrus Valley Independent Physicians IPA'', ''NMM01'', ''NMM01'', ''Professional''),
(''Citrus Valley Physicians Group'', ''PDT01'', ''PDT01'', ''Institutional''),
(''Citrus Valley Physicians Group'', ''PDT01'', ''PDT01'', ''Professional''),
(''Citrus World, Inc.'', ''J1945'', ''J1945'', ''Institutional''),
(''Citrus World, Inc.'', ''J1945'', ''J1945'', ''Professional''),
(''City and County of San Francisco (CCSF)'', ''J1885'', ''J1885'', ''Institutional''),
(''City and County of San Francisco (CCSF)'', ''J1885'', ''J1885'', ''Professional''),
(''City of Ames (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''City of Ames (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''City of Arlington'', ''A0033'', ''A0033'', ''Institutional''),
(''City of Arlington'', ''A0033'', ''A0033'', ''Professional''),
(''City of Ashland'', ''41556'', ''41556'', ''Institutional''),
(''City of Ashland'', ''41556'', ''41556'', ''Professional''),
(''City of Banning (CA)'', ''J1792'', ''J1792'', ''Institutional''),
(''City of Banning (CA)'', ''J1792'', ''J1792'', ''Professional''),
(''City of Barstow (CA)'', ''J1793'', ''J1793'', ''Institutional''),
(''City of Barstow (CA)'', ''J1793'', ''J1793'', ''Professional''),
(''City of Beaverton'', ''41556'', ''41556'', ''Institutional''),
(''City of Beaverton'', ''41556'', ''41556'', ''Professional''),
(''City of Belmont (Self Insured)'', ''41556'', ''41556'', ''Institutional''),
(''City of Belmont (Self Insured)'', ''41556'', ''41556'', ''Professional''),
(''City of Blythe (CA)'', ''J1794'', ''J1794'', ''Institutional''),
(''City of Blythe (CA)'', ''J1794'', ''J1794'', ''Professional''),
(''City of Brea'', ''J1880'', ''J1880'', ''Institutional''),
(''City of Brea'', ''J1880'', ''J1880'', ''Professional''),
(''City of Campbell'', ''41556'', ''41556'', ''Institutional''),
(''City of Campbell'', ''41556'', ''41556'', ''Professional''),
(''City of Carlsbad'', ''41556'', ''41556'', ''Institutional''),
(''City of Carlsbad'', ''41556'', ''41556'', ''Professional''),
(''City of Carmel By The Sea'', ''41556'', ''41556'', ''Institutional''),
(''City of Carmel By The Sea'', ''41556'', ''41556'', ''Professional''),
(''City of Carson'', ''41556'', ''41556'', ''Institutional''),
(''City of Carson'', ''41556'', ''41556'', ''Professional''),
(''City Of Chino'', ''J2306'', ''J2306'', ''Institutional''),
(''City Of Chino'', ''J2306'', ''J2306'', ''Professional''),
(''City of Colton'', ''41556'', ''41556'', ''Institutional''),
(''City of Colton'', ''41556'', ''41556'', ''Professional''),
(''City of Coronado'', ''41556'', ''41556'', ''Institutional''),
(''City of Coronado'', ''41556'', ''41556'', ''Professional''),
(''City of Dallas'', ''J1441'', ''J1441'', ''Institutional''),
(''City of Dallas'', ''J1441'', ''J1441'', ''Professional''),
(''City of Del Mar'', ''41556'', ''41556'', ''Institutional''),
(''City of Del Mar'', ''41556'', ''41556'', ''Professional''),
(''City of Des Moines (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''City of Des Moines (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''City of Desert Hot Springs (CA)'', ''J1799'', ''J1799'', ''Institutional''),
(''City of Desert Hot Springs (CA)'', ''J1799'', ''J1799'', ''Professional''),
(''City of Edinburg, Texas'', ''41556'', ''41556'', ''Institutional''),
(''City of Edinburg, Texas'', ''41556'', ''41556'', ''Professional''),
(''City of El Paso'', ''A0046'', ''A0046'', ''Institutional''),
(''City of El Paso'', ''A0046'', ''A0046'', ''Professional''),
(''City of Encinitas'', ''41556'', ''41556'', ''Institutional''),
(''City of Encinitas'', ''41556'', ''41556'', ''Professional''),
(''City of Escondido'', ''41556'', ''41556'', ''Institutional''),
(''City of Escondido'', ''41556'', ''41556'', ''Professional''),
(''City of Fort Worth (TX)'', ''J1680'', ''J1680'', ''Institutional''),
(''City of Fort Worth (TX)'', ''J1680'', ''J1680'', ''Professional''),
(''City of Fountain Valley (CA)'', ''J1632'', ''J1632'', ''Institutional''),
(''City of Fountain Valley (CA)'', ''J1632'', ''J1632'', ''Professional''),
(''City of Gardena (CA)'', ''J1634'', ''J1634'', ''Institutional''),
(''City of Gardena (CA)'', ''J1634'', ''J1634'', ''Professional''),
(''City of Glendale (AZ)'', ''J1800'', ''J1800'', ''Institutional''),
(''City of Glendale (AZ)'', ''J1800'', ''J1800'', ''Professional''),
(''City of Grand Junction'', ''41556'', ''41556'', ''Institutional''),
(''City of Grand Junction'', ''41556'', ''41556'', ''Professional''),
(''City of Hillsboro'', ''41556'', ''41556'', ''Institutional''),
(''City of Hillsboro'', ''41556'', ''41556'', ''Professional''),
(''City of Houston'', ''J1444'', ''J1444'', ''Institutional''),
(''City of Houston'', ''J1444'', ''J1444'', ''Professional''),
(''City of Imperial Beach'', ''41556'', ''41556'', ''Institutional''),
(''City of Imperial Beach'', ''41556'', ''41556'', ''Professional''),
(''City of Imperial Beach (Voucher)'', ''41556'', ''41556'', ''Institutional''),
(''City of Imperial Beach (Voucher)'', ''41556'', ''41556'', ''Professional''),
(''City of Irving'', ''41556'', ''41556'', ''Institutional''),
(''City of Irving'', ''41556'', ''41556'', ''Professional''),
(''City of La Mesa 11 (CA)'', ''J1711'', ''J1711'', ''Institutional''),
(''City of La Mesa 11 (CA)'', ''J1711'', ''J1711'', ''Professional''),
(''City of Laguna Hills (CA)'', ''J1653'', ''J1653'', ''Institutional''),
(''City of Laguna Hills (CA)'', ''J1653'', ''J1653'', ''Professional''),
(''City of Lemon Grove'', ''41556'', ''41556'', ''Institutional''),
(''City of Lemon Grove'', ''41556'', ''41556'', ''Professional''),
(''City of Los Altos'', ''41556'', ''41556'', ''Institutional''),
(''City of Los Altos'', ''41556'', ''41556'', ''Professional''),
(''City of Los Angeles'', ''J1536'', ''J1536'', ''Institutional''),
(''City of Los Angeles'', ''J1536'', ''J1536'', ''Professional''),
(''City of Merced'', ''41556'', ''41556'', ''Institutional''),
(''City of Merced'', ''41556'', ''41556'', ''Professional''),
(''City of Miami Beach (FL)'', ''J1946'', ''J1946'', ''Institutional''),
(''City of Miami Beach (FL)'', ''J1946'', ''J1946'', ''Professional''),
(''City of Minneapolis'', ''J1269'', ''J1269'', ''Institutional''),
(''City of Minneapolis'', ''J1269'', ''J1269'', ''Professional''),
(''City of Monrovia (CA)'', ''J1714'', ''J1714'', ''Institutional''),
(''City of Monrovia (CA)'', ''J1714'', ''J1714'', ''Professional''),
(''City of National City'', ''41556'', ''41556'', ''Institutional''),
(''City of National City'', ''41556'', ''41556'', ''Professional''),
(''City Of New Orleans (LA)'', ''J2309'', ''J2309'', ''Institutional''),
(''City Of New Orleans (LA)'', ''J2309'', ''J2309'', ''Professional''),
(''City of Oceanside'', ''41556'', ''41556'', ''Institutional''),
(''City of Oceanside'', ''41556'', ''41556'', ''Professional''),
(''City of Omaha (NE)'', ''J1721'', ''J1721'', ''Institutional''),
(''City of Omaha (NE)'', ''J1721'', ''J1721'', ''Professional''),
(''City of Ontario'', ''41556'', ''41556'', ''Institutional''),
(''City of Ontario'', ''41556'', ''41556'', ''Professional''),
(''City of Orange'', ''J1881'', ''J1881'', ''Institutional''),
(''City of Orange'', ''J1881'', ''J1881'', ''Professional''),
(''City of Perris (CA)'', ''J1795'', ''J1795'', ''Institutional''),
(''City of Perris (CA)'', ''J1795'', ''J1795'', ''Professional''),
(''City of Pompano Beach (FL)'', ''J1947'', ''J1947'', ''Institutional''),
(''City of Pompano Beach (FL)'', ''J1947'', ''J1947'', ''Professional''),
(''City of Raleigh'', ''J2391'', ''J2391'', ''Institutional''),
(''City of Raleigh'', ''J2391'', ''J2391'', ''Professional''),
(''City of Redding (CA)'', ''J1617'', ''J1617'', ''Institutional''),
(''City of Redding (CA)'', ''J1617'', ''J1617'', ''Professional''),
(''City of Rialto, CA'', ''J1901'', ''J1901'', ''Institutional''),
(''City of Rialto, CA'', ''J1901'', ''J1901'', ''Professional''),
(''City of Richardson'', ''41556'', ''41556'', ''Institutional''),
(''City of Richardson'', ''41556'', ''41556'', ''Professional''),
(''City of Salinas'', ''J1849'', ''J1849'', ''Institutional''),
(''City of Salinas'', ''J1849'', ''J1849'', ''Professional''),
(''City of San Diego'', ''J1497'', ''J1497'', ''Institutional''),
(''City of San Diego'', ''J1497'', ''J1497'', ''Professional''),
(''City of San Jacinto (CA)'', ''J1796'', ''J1796'', ''Institutional''),
(''City of San Jacinto (CA)'', ''J1796'', ''J1796'', ''Professional''),
(''City of San Mateo (CA)'', ''J1727'', ''J1727'', ''Institutional''),
(''City of San Mateo (CA)'', ''J1727'', ''J1727'', ''Professional''),
(''City of Santee'', ''41556'', ''41556'', ''Institutional''),
(''City of Santee'', ''41556'', ''41556'', ''Professional''),
(''City of Snyder (TX)'', ''J1598'', ''J1598'', ''Institutional''),
(''City of Snyder (TX)'', ''J1598'', ''J1598'', ''Professional''),
(''City of Solana Beach'', ''41556'', ''41556'', ''Institutional''),
(''City of Solana Beach'', ''41556'', ''41556'', ''Professional''),
(''City of South San Francisco'', ''41556'', ''41556'', ''Institutional''),
(''City of South San Francisco'', ''41556'', ''41556'', ''Professional''),
(''City of St. Paul (MN)'', ''J1602'', ''J1602'', ''Institutional''),
(''City of St. Paul (MN)'', ''J1602'', ''J1602'', ''Professional''),
(''City of Stanton (CA)'', ''J1636'', ''J1636'', ''Institutional''),
(''City of Stanton (CA)'', ''J1636'', ''J1636'', ''Professional''),
(''City of Stockton (CA)'', ''J1664'', ''J1664'', ''Institutional''),
(''City of Stockton (CA)'', ''J1664'', ''J1664'', ''Professional''),
(''City of Topeka (KS)'', ''J1607'', ''J1607'', ''Institutional''),
(''City of Topeka (KS)'', ''J1607'', ''J1607'', ''Professional''),
(''City of Upland (CA)'', ''J1645'', ''J1645'', ''Institutional''),
(''City of Upland (CA)'', ''J1645'', ''J1645'', ''Professional''),
(''City of Visalia'', ''TKFMC'', ''TKFMC'', ''Professional''),
(''City of Vista'', ''41556'', ''41556'', ''Institutional''),
(''City of Vista'', ''41556'', ''41556'', ''Professional''),
(''City of Waco'', ''41556'', ''41556'', ''Institutional''),
(''City of Waco'', ''41556'', ''41556'', ''Professional''),
(''City of West Des Moines (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''City of West Des Moines (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''City of West Palm Beach (FL)'', ''J1948'', ''J1948'', ''Institutional''),
(''City of West Palm Beach (FL)'', ''J1948'', ''J1948'', ''Professional''),
(''City of Yorba Linda (CA)'', ''J1708'', ''J1708'', ''Institutional''),
(''City of Yorba Linda (CA)'', ''J1708'', ''J1708'', ''Professional''),
(''City of Yuma'', ''41556'', ''41556'', ''Institutional''),
(''City of Yuma'', ''41556'', ''41556'', ''Professional''),
(''Civil Constructors'', ''41556'', ''41556'', ''Institutional''),
(''Civil Constructors'', ''41556'', ''41556'', ''Professional''),
(''CL Frates and Company/OSMA Health'', ''73071'', ''73071'', ''Institutional''),
(''CL Frates and Company/OSMA Health'', ''73071'', ''73071'', ''Professional''),
(''ClaimChoice Administrators'', ''38219'', ''38219'', ''Institutional''),
(''ClaimChoice Administrators'', ''38219'', ''38219'', ''Professional''),
(''Claims Administrative Services (CAS)'', ''J1271'', ''J1271'', ''Institutional''),
(''Claims Administrative Services (CAS)'', ''J1271'', ''J1271'', ''Professional''),
(''Claims Development Corporation'', ''43056'', ''43056'', ''Professional''),
(''Claimsbridge West'', ''11752'', ''11752'', ''Institutional''),
(''Claimsbridge West'', ''11752'', ''11752'', ''Professional''),
(''ClaimsWare, Inc. DBA ManageMed'', ''57080'', ''57080'', ''Institutional''),
(''ClaimsWare, Inc. DBA ManageMed'', ''57080'', ''57080'', ''Professional''),
(''Classic Residence By Hyatt'', ''J1037'', ''J1037'', ''Institutional''),
(''Classic Residence By Hyatt'', ''J1037'', ''J1037'', ''Professional''),
(''Clear Health Alliance'', ''CLEAR'', ''CLEAR'', ''Institutional''),
(''Clear Health Alliance'', ''CLEAR'', ''CLEAR'', ''Professional''),
(''Clear Spring Health of Illinois'', ''66009'', ''66009'', ''Institutional''),
(''Clear Spring Health of Illinois'', ''66009'', ''66009'', ''Professional''),
(''Clearchoice Health Plan / COIHS'', ''77201'', ''77201'', ''Professional''),
(''Client First'', ''41201'', ''41201'', ''Institutional''),
(''Client First'', ''41201'', ''41201'', ''Professional''),
(''Clinica Medica San Miguel'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Clinica Medica San Miguel'', ''PROSP'', ''PROSP'', ''Professional''),
(''Clinical Resource Group'', ''CRGMN'', ''CRGMN'', ''Professional''),
(''Clinical Specialities, Inc'', ''CSI01'', ''CSI01'', ''Institutional''),
(''Clinical Specialities, Inc'', ''CSI01'', ''CSI01'', ''Professional''),
(''Clinicas del Camino Real'', ''CDCR1'', ''CDCR1'', ''Institutional''),
(''Clinicas del Camino Real'', ''CDCR1'', ''CDCR1'', ''Professional''),
(''Clougherty Packing, LLC'', ''J1739'', ''J1739'', ''Institutional''),
(''Clougherty Packing, LLC'', ''J1739'', ''J1739'', ''Professional''),
(''Clover Health'', ''77023'', ''77023'', ''Institutional''),
(''Clover Health'', ''77023'', ''77023'', ''Professional''),
(''Clover Health Network'', ''13285'', ''13285'', ''Institutional''),
(''Clover Health Network'', ''13285'', ''13285'', ''Professional''),
(''CM Administrators, Inc.'', ''56211'', ''56211'', ''Institutional''),
(''CM Administrators, Inc.'', ''56211'', ''56211'', ''Professional''),
(''CNA Insurance'', ''20443'', ''20443'', ''Institutional''),
(''CNA Insurance'', ''20443'', ''20443'', ''Professional''),
(''CNA Insurance (AUTO ONLY)'', ''C1035'', ''C1035'', ''Institutional''),
(''CNA Insurance (AUTO ONLY)'', ''C1035'', ''C1035'', ''Professional''),
(''Co Grande Casino'', ''41556'', ''41556'', ''Institutional''),
(''Co Grande Casino'', ''41556'', ''41556'', ''Professional''),
(''Co-Ordinated Benefit Plans'', ''14829'', ''14829'', ''Institutional''),
(''Co-Ordinated Benefit Plans'', ''14829'', ''14829'', ''Professional''),
(''Coach USA'', ''J1272'', ''J1272'', ''Professional''),
(''Coachella Valley Water District (CA)'', ''J1902'', ''J1902'', ''Institutional''),
(''Coachella Valley Water District (CA)'', ''J1902'', ''J1902'', ''Professional''),
(''Coast Converters'', ''41556'', ''41556'', ''Institutional''),
(''Coast Converters'', ''41556'', ''41556'', ''Professional''),
(''Coastal Administrative Services'', ''77052'', ''77052'', ''Institutional''),
(''Coastal Administrative Services'', ''77052'', ''77052'', ''Professional''),
(''Coastal Care Services, Inc.'', ''47394'', ''47394'', ''Professional''),
(''Coastal Communities Physician Network (CCPN)'', ''51579'', ''51579'', ''Institutional''),
(''Coastal Communities Physician Network (CCPN)'', ''51579'', ''51579'', ''Professional''),
(''Coca-Cola Enterprises Inc.'', ''J1038'', ''J1038'', ''Institutional''),
(''Coca-Cola Enterprises Inc.'', ''J1038'', ''J1038'', ''Professional''),
(''College Health IPA (CHIPA)'', ''CHIPA'', ''CHIPA'', ''Professional''),
(''Collin County'', ''41556'', ''41556'', ''Institutional''),
(''Collin County'', ''41556'', ''41556'', ''Professional''),
(''Colonial Medical'', ''22284'', ''22284'', ''Institutional''),
(''Colonial Medical'', ''22284'', ''22284'', ''Professional''),
(''Colorado Access Behavioral Health'', ''COACC'', ''COACC'', ''Institutional''),
(''Colorado Access Behavioral Health'', ''COACC'', ''COACC'', ''Professional''),
(''Colorado Access CHP +'', ''COACC'', ''COACC'', ''Institutional''),
(''Colorado Access CHP +'', ''COACC'', ''COACC'', ''Professional''),
(''Colorado Access HMO'', ''COACC'', ''COACC'', ''Institutional''),
(''Colorado Access HMO'', ''COACC'', ''COACC'', ''Professional''),
(''Colorado Casualty'', ''J1428'', ''J1428'', ''Institutional''),
(''Colorado Casualty'', ''J1428'', ''J1428'', ''Professional''),
(''Colorado Community Health Alliance'', ''COCHA'', ''COCHA'', ''Institutional''),
(''Colorado Community Health Alliance'', ''COCHA'', ''COCHA'', ''Professional''),
(''Colorado Contractors Program'', ''41556'', ''41556'', ''Institutional''),
(''Colorado Contractors Program'', ''41556'', ''41556'', ''Professional''),
(''Colorado Health OP'', ''49718'', ''49718'', ''Institutional''),
(''Colorado Health OP'', ''49718'', ''49718'', ''Professional''),
(''Colorado HealthCare Assoc. - Safety National Casualty Corp.'', ''41556'', ''41556'', ''Institutional''),
(''Colorado HealthCare Assoc. - Safety National Casualty Corp.'', ''41556'', ''41556'', ''Professional''),
(''Colorado Prime Corp.'', ''41556'', ''41556'', ''Institutional''),
(''Colorado Prime Corp.'', ''41556'', ''41556'', ''Professional''),
(''Columbia Sussex Corporation'', ''J1039'', ''J1039'', ''Institutional''),
(''Columbia Sussex Corporation'', ''J1039'', ''J1039'', ''Professional''),
(''Columbine Health Plan'', ''CHP02'', ''CHP02'', ''Professional''),
(''Columbine Health Systems'', ''41556'', ''41556'', ''Institutional''),
(''Columbine Health Systems'', ''41556'', ''41556'', ''Professional''),
(''Come Care de Puerto Rico'', ''20231'', ''20231'', ''Institutional''),
(''Come Care de Puerto Rico'', ''20231'', ''20231'', ''Professional''),
(''Commercial Travelers'', ''88091'', ''88091'', ''Institutional''),
(''Commercial Travelers'', ''88091'', ''88091'', ''Professional''),
(''Common Ground Healthcare Cooperative'', ''77170'', ''77170'', ''Institutional''),
(''Common Ground Healthcare Cooperative'', ''77170'', ''77170'', ''Professional''),
(''Commonwealth Care Alliance'', ''14315'', ''14315'', ''Institutional''),
(''Commonwealth Care Alliance'', ''14315'', ''14315'', ''Professional''),
(''Community Blue Medicare Plus PPO'', ''15460'', ''15460'', ''Institutional''),
(''Community Blue Medicare Plus PPO'', ''15460'', ''15460'', ''Professional''),
(''Community Blue Medicare PPO'', ''15460'', ''15460'', ''Institutional''),
(''Community Blue Medicare PPO'', ''15460'', ''15460'', ''Professional''),
(''Community Care Alliance of Illinois'', ''66012'', ''66012'', ''Institutional''),
(''Community Care Alliance of Illinois'', ''66012'', ''66012'', ''Professional''),
(''Community Care Associates'', ''17902'', ''17902'', ''Professional''),
(''Community Care BHO (PA)'', ''23282'', ''23282'', ''Institutional''),
(''Community Care BHO (PA)'', ''23282'', ''23282'', ''Professional''),
(''Community Care Inc, Family Care (Wisconsin)'', ''60995'', ''60995'', ''Institutional''),
(''Community Care Inc, Family Care (Wisconsin)'', ''60995'', ''60995'', ''Professional''),
(''Community Care IPA'', ''AMM12'', ''CCIPA'', ''Professional''),
(''Community Care IPA'', ''MPM48'', ''MPM48'', ''Professional''),
(''Community Care Managed Health Care Plans of OK'', ''73143'', ''73143'', ''Institutional''),
(''Community Care Managed Health Care Plans of OK'', ''73143'', ''73143'', ''Professional''),
(''Community Care Organization'', ''39126'', ''39126'', ''Institutional''),
(''Community Care Organization'', ''39126'', ''39126'', ''Professional''),
(''Community Care Plan (Commercial)'', ''59064'', ''59064'', ''Institutional''),
(''Community Care Plan (Commercial)'', ''59064'', ''59064'', ''Professional''),
(''Community Care Plan (Medicaid)'', ''59065'', ''59065'', ''Institutional''),
(''Community Care Plan (Medicaid)'', ''59065'', ''59065'', ''Professional''),
(''Community Care Plan (Palm Beach Health District)'', ''PBHD1'', ''PBHD1'', ''Institutional''),
(''Community Care Plan (Palm Beach Health District)'', ''PBHD1'', ''PBHD1'', ''Professional''),
(''Community Development Commission (CA)'', ''J1655'', ''J1655'', ''Institutional''),
(''Community Development Commission (CA)'', ''J1655'', ''J1655'', ''Professional''),
(''Community Family Care'', ''NMM05'', ''NMM05'', ''Institutional''),
(''Community Family Care'', ''NMM05'', ''NMM05'', ''Professional''),
(''Community Health Alliance'', ''35193'', ''35193'', ''Institutional''),
(''Community Health Alliance'', ''35193'', ''35193'', ''Professional''),
(''Community Health Center Network - CHCN (for CA providers only)'', ''CHCN1'', ''CHCN1'', ''Professional''),
(''Community Health Choice - Health Insurance Marketplace'', ''60495'', ''60495'', ''Institutional''),
(''Community Health Choice - Health Insurance Marketplace'', ''60495'', ''60495'', ''Professional''),
(''Community Health Choice - STAR/CHIP Medicaid'', ''48145'', ''48145'', ''Institutional''),
(''Community Health Choice - STAR/CHIP Medicaid'', ''48145'', ''48145'', ''Professional''),
(''Community Health Electronic Claims (CHEC - webTPA)'', ''75261'', ''75261'', ''Institutional''),
(''Community Health Electronic Claims (CHEC - webTPA)'', ''75261'', ''75261'', ''Professional''),
(''Community Health Group  (Capitated)'', ''66171'', ''CHGRP'', ''Institutional''),
(''Community Health Group  (Capitated)'', ''66171'', ''CHGRP'', ''Professional''),
(''Community Health Group (FFS)'', ''66170'', ''CHGFF'', ''Institutional''),
(''Community Health Group (FFS)'', ''66170'', ''CHGFF'', ''Professional''),
(''Community Health Plan of Washington (CHPW)'', ''CHPWA'', ''CHPWA'', ''Institutional''),
(''Community Health Plan of Washington (CHPW)'', ''CHPWA'', ''CHPWA'', ''Professional''),
(''Community Medical Group of the West Valley'', ''LMG01'', ''LMG01'', ''Institutional''),
(''Community Medical Group of the West Valley'', ''LMG01'', ''LMG01'', ''Professional''),
(''Communtiy First - Star Health Plan'', ''COMMF'', ''COMMF'', ''Institutional''),
(''Communtiy First - Star Health Plan'', ''COMMF'', ''COMMF'', ''Professional''),
(''Comp West'', ''J1925'', ''J1925'', ''Institutional''),
(''Comp West'', ''J1925'', ''J1925'', ''Professional''),
(''Companion Property and Casualty Insurance Company (dba Sussex Insurance Company)'', ''J1829'', ''J1829'', ''Institutional''),
(''Companion Property and Casualty Insurance Company (dba Sussex Insurance Company)'', ''J1829'', ''J1829'', ''Professional''),
(''Compass Group Usa, Inc.'', ''J1040'', ''J1040'', ''Institutional''),
(''Compass Group Usa, Inc.'', ''J1040'', ''J1040'', ''Professional''),
(''Complementary Healthcare Plan (CHP)'', ''CHP01'', ''CHP01'', ''Professional''),
(''Complete Senior Care Peak PACE'', ''27034'', ''27034'', ''Institutional''),
(''Complete Senior Care Peak PACE'', ''27034'', ''27034'', ''Professional''),
(''Comprehensive Benefits Administrator, Inc. (CBA)'', ''03036'', ''03036'', ''Institutional''),
(''Comprehensive Benefits Administrator, Inc. (CBA)'', ''03036'', ''03036'', ''Professional''),
(''Comprehensive Medical and Dental Program (CMDP)'', ''86600'', ''86600'', ''Professional''),
(''Compsych'', ''37363'', ''37363'', ''Institutional''),
(''Compsych'', ''37363'', ''37363'', ''Professional''),
(''Compton Unified School District (CA)'', ''J1652'', ''J1652'', ''Institutional''),
(''Compton Unified School District (CA)'', ''J1652'', ''J1652'', ''Professional''),
(''CompuSys of Colorado'', ''COMPU'', ''COMPU'', ''Professional''),
(''Con-Way Inc.'', ''J1844'', ''J1844'', ''Institutional''),
(''Con-Way Inc.'', ''J1844'', ''J1844'', ''Professional''),
(''Concert Health Plan'', ''36434'', ''36434'', ''Professional''),
(''Concordia Care'', ''33632'', ''33632'', ''Institutional''),
(''Concordia Care'', ''33632'', ''33632'', ''Professional''),
(''Confed Admin Services, Inc.'', ''62308'', ''80667'', ''Institutional''),
(''Confed Admin Services, Inc.'', ''62308'', ''80667'', ''Professional''),
(''Conifer Health Solutions'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Conifer Health Solutions'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''ConnectiCare - Commercial'', ''06105'', ''06105'', ''Institutional''),
(''ConnectiCare - Commercial'', ''06105'', ''06105'', ''Professional''),
(''ConnectiCare - VIP Medicare Advantage'', ''78375'', ''78375'', ''Institutional''),
(''ConnectiCare - VIP Medicare Advantage'', ''78375'', ''78375'', ''Professional''),
(''Connecticut Carpenters Health Fund'', ''37307'', ''37307'', ''Institutional''),
(''Connecticut Carpenters Health Fund'', ''37307'', ''37307'', ''Professional''),
(''Connecticut General, Cigna'', ''62308'', ''62308'', ''Institutional''),
(''Connecticut General, Cigna'', ''62308'', ''62308'', ''Professional''),
(''Connecticut Indemnity Company'', ''J3965'', ''J3965'', ''Institutional''),
(''Connecticut Indemnity Company'', ''J3965'', ''J3965'', ''Professional''),
(''Consociate Group'', ''37135'', ''37135'', ''Institutional''),
(''Consociate Group'', ''37135'', ''37135'', ''Professional''),
(''Consolidated Associates Railroad'', ''75284'', ''75284'', ''Institutional''),
(''Consolidated Associates Railroad'', ''75284'', ''75284'', ''Professional''),
(''Consolidated Group/HPS'', ''04274'', ''04274'', ''Professional''),
(''Consolidated Health Plans'', ''87843'', ''87843'', ''Institutional''),
(''Consolidated Health Plans'', ''87843'', ''87843'', ''Professional''),
(''Constellation Health'', ''L0260'', ''L0260'', ''Professional''),
(''Consumers Choice Health'', ''45321'', ''45321'', ''Institutional''),
(''Consumers Choice Health'', ''45321'', ''45321'', ''Professional''),
(''Consumers Life Insurance Company'', ''29076'', ''29076'', ''Institutional''),
(''Consumers Life Insurance Company'', ''29076'', ''29076'', ''Professional''),
(''Contech Construction Products'', ''J1041'', ''J1041'', ''Institutional''),
(''Contech Construction Products'', ''J1041'', ''J1041'', ''Professional''),
(''Continental Airlines'', ''J1042'', ''J1042'', ''Institutional''),
(''Continental Airlines'', ''J1042'', ''J1042'', ''Professional''),
(''Continental General Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Institutional''),
(''Continental General Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Professional''),
(''Continental Western Insurance Co (CWG)'', ''J1274'', ''J1274'', ''Institutional''),
(''Continental Western Insurance Co (CWG)'', ''J1274'', ''J1274'', ''Professional''),
(''Continuum ABC MSO'', ''13397'', ''13397'', ''Professional''),
(''Contra Coastal County Schools Insurance Group (CCCSIG)'', ''J1715'', ''J1715'', ''Institutional''),
(''Contra Coastal County Schools Insurance Group (CCCSIG)'', ''J1715'', ''J1715'', ''Professional''),
(''Contra Costa Health Plan'', ''CCHPL'', ''CCHP'', ''Institutional''),
(''Contra Costa Health Plan'', ''CCHPL'', ''CCHP'', ''Professional''),
(''Contractors Laborers Teamsters & Engineers'', ''47046'', ''47046'', ''Institutional''),
(''Contractors Laborers Teamsters & Engineers'', ''47046'', ''47046'', ''Professional''),
(''Convergys Corporation'', ''J1043'', ''J1043'', ''Institutional''),
(''Convergys Corporation'', ''J1043'', ''J1043'', ''Professional''),
(''Cook & Solis Const.'', ''41556'', ''41556'', ''Institutional''),
(''Cook & Solis Const.'', ''41556'', ''41556'', ''Professional''),
(''Cook Children''''s Health Plan'', ''CCHP1'', ''CCHP1'', ''Institutional''),
(''Cook Children''''s Health Plan'', ''CCHP1'', ''CCHP1'', ''Professional''),
(''Cook Children''''s Star Plan'', ''CCHP9'', ''CCHP9'', ''Institutional''),
(''Cook Children''''s Star Plan'', ''CCHP9'', ''CCHP9'', ''Professional''),
(''Cook CountyCare Illinois - Cenpatico'', ''42138'', ''42138'', ''Institutional''),
(''Cook CountyCare Illinois - Cenpatico'', ''42138'', ''42138'', ''Professional''),
(''Cook Group Health Plan'', ''35149'', ''35149'', ''Institutional''),
(''Cook Group Health Plan'', ''35149'', ''35149'', ''Professional''),
(''Cook Medical Group'', ''60065'', ''60065'', ''Institutional''),
(''Cook Medical Group'', ''60065'', ''60065'', ''Professional''),
(''Cooperative Benefit Administrators (CBA)'', ''39026'', ''39026'', ''Institutional''),
(''Cooperative Benefit Administrators (CBA)'', ''39026'', ''39026'', ''Professional''),
(''Cooperative Managed Care Services'', ''35199'', ''35199'', ''Institutional''),
(''Cooperative Managed Care Services'', ''35199'', ''35199'', ''Professional''),
(''CoOportunity Health'', ''07003'', ''07003'', ''Institutional''),
(''CoOportunity Health'', ''07003'', ''07003'', ''Professional''),
(''Coordinated Care - Washington'', ''68069'', ''68069'', ''Institutional''),
(''Coordinated Care - Washington'', ''68069'', ''68069'', ''Professional''),
(''Coordinated Medical Specialists'', ''58204'', ''58204'', ''Professional''),
(''Copperpoint Mutual Insurance Company'', ''J2093'', ''J2093'', ''Institutional''),
(''Copperpoint Mutual Insurance Company'', ''J2093'', ''J2093'', ''Professional''),
(''Core Management Resources Group'', ''58231'', ''58231'', ''Professional''),
(''CoreSource - Internal - Trustmark Health Benefits'', ''35187'', ''35187'', ''Institutional''),
(''CoreSource - Internal - Trustmark Health Benefits'', ''35187'', ''35187'', ''Professional''),
(''CoreSource Arizona, Minnesota - Trustmark Health Benefits'', ''35182'', ''35182'', ''Institutional''),
(''CoreSource Arizona, Minnesota - Trustmark Health Benefits'', ''35182'', ''35182'', ''Professional''),
(''CoreSource Detroit'', ''38225'', ''38225'', ''Institutional''),
(''CoreSource Detroit'', ''38225'', ''38225'', ''Professional''),
(''Coresource KC - Trustmark Health Benefits'', ''48117'', ''48117'', ''Institutional''),
(''Coresource KC - Trustmark Health Benefits'', ''48117'', ''48117'', ''Professional''),
(''CoreSource Little Rock, Arkansas - Trustmark Health Benefits'', ''75136'', ''75136'', ''Institutional''),
(''CoreSource Little Rock, Arkansas - Trustmark Health Benefits'', ''75136'', ''75136'', ''Professional''),
(''CoreSource Maryland, Pennsylvania, Illinois - Trustmark Health Benefits'', ''35182'', ''35182'', ''Institutional''),
(''CoreSource Maryland, Pennsylvania, Illinois - Trustmark Health Benefits'', ''35182'', ''35182'', ''Professional''),
(''CoreSource North Carolina, Indiana - Trustmark Health Benefits'', ''35182'', ''35182'', ''Institutional''),
(''CoreSource North Carolina, Indiana - Trustmark Health Benefits'', ''35182'', ''35182'', ''Professional''),
(''CoreSource Ohio - Trustmark Health Benefits'', ''35183'', ''35183'', ''Institutional''),
(''CoreSource Ohio - Trustmark Health Benefits'', ''35183'', ''35183'', ''Professional''),
(''Corizon Inc'', ''43160'', ''43160'', ''Institutional''),
(''Corizon Inc'', ''43160'', ''43160'', ''Professional''),
(''Cornerstone Benefit Administrators'', ''35202'', ''35202'', ''Institutional''),
(''Cornerstone Benefit Administrators'', ''35202'', ''35202'', ''Professional''),
(''Cornerstone Preferred Resources'', ''CB268'', ''CB268'', ''Institutional''),
(''Cornerstone Preferred Resources'', ''CB268'', ''CB268'', ''Professional''),
(''Corporate Benefit Services'', ''56116'', ''56116'', ''Institutional''),
(''Corporate Benefit Services'', ''56116'', ''56116'', ''Professional''),
(''Corporate Benefit Services of America (CBSA)'', ''41124'', ''41124'', ''Institutional''),
(''Corporate Benefit Services of America (CBSA)'', ''41124'', ''41124'', ''Professional''),
(''CorrectCare - California Prison Health Care Services'', ''CCIH'', ''CCIH1'', ''Institutional''),
(''CorrectCare - California Prison Health Care Services'', ''CCIH1'', ''CCIH1'', ''Professional''),
(''Correction Health Partners'', ''PHPMC'', ''PHPMC'', ''Institutional''),
(''Correction Health Partners'', ''PHPMC'', ''PHPMC'', ''Professional''),
(''Correctional Management Service'', ''J1044'', ''J1044'', ''Institutional''),
(''Correctional Management Service'', ''J1044'', ''J1044'', ''Professional''),
(''Correctional Medical Services'', ''43160'', ''43160'', ''Institutional''),
(''Correctional Medical Services'', ''43160'', ''43160'', ''Professional''),
(''Corrections Corp of America'', ''J1045'', ''J1045'', ''Institutional''),
(''Corrections Corp of America'', ''J1045'', ''J1045'', ''Professional''),
(''Corrections Corporation of America (CCA)'', ''J1942'', ''J1942'', ''Institutional''),
(''Corrections Corporation of America (CCA)'', ''J1942'', ''J1942'', ''Professional''),
(''CorSolutions'', ''48146'', ''48146'', ''Professional''),
(''Cosvi'', ''31517'', ''31517'', ''Institutional''),
(''Cosvi'', ''31517'', ''31517'', ''Professional''),
(''Cottingham & Butler Claim Services, Inc.'', ''J1683'', ''J1683'', ''Institutional''),
(''Cottingham & Butler Claim Services, Inc.'', ''J1683'', ''J1683'', ''Professional''),
(''Country Casualty Insurance Company'', ''J1684'', ''J1684'', ''Institutional''),
(''Country Casualty Insurance Company'', ''J1684'', ''J1684'', ''Professional''),
(''Country Insurance \ Modern Service Casualty Insur Co'', ''J1712'', ''J1712'', ''Institutional''),
(''Country Insurance \ Modern Service Casualty Insur Co'', ''J1712'', ''J1712'', ''Professional''),
(''Country Insurance \ Mountain States Insurance'', ''J1572'', ''J1572'', ''Institutional''),
(''Country Insurance \ Mountain States Insurance'', ''J1572'', ''J1572'', ''Professional''),
(''Country Insurance \ MSI Preferred Insurance Company'', ''J1591'', ''J1591'', ''Institutional''),
(''Country Insurance \ MSI Preferred Insurance Company'', ''J1591'', ''J1591'', ''Professional''),
(''Country Mutual Insurance Company'', ''J1702'', ''J1702'', ''Institutional''),
(''Country Mutual Insurance Company'', ''J1702'', ''J1702'', ''Professional''),
(''Country Preferred Insurance Company'', ''J1705'', ''J1705'', ''Institutional''),
(''Country Preferred Insurance Company'', ''J1705'', ''J1705'', ''Professional''),
(''Country Villa Health Services - SNCC'', ''41556'', ''41556'', ''Institutional''),
(''Country Villa Health Services - SNCC'', ''41556'', ''41556'', ''Professional''),
(''Country Villa Ox Hlth'', ''41556'', ''41556'', ''Institutional''),
(''Country Villa Ox Hlth'', ''41556'', ''41556'', ''Professional''),
(''Countryway Insurance Company'', ''C1083'', ''C1083'', ''Institutional''),
(''Countryway Insurance Company'', ''C1083'', ''C1083'', ''Professional''),
(''County Care Health Plan'', ''06541'', ''06541'', ''Institutional''),
(''County Care Health Plan'', ''06541'', ''06541'', ''Professional''),
(''County Medical Services Program (CA) (CMSP)'', ''AMM15'', ''CMSP'', ''Institutional''),
(''County Medical Services Program (CA) (CMSP)'', ''AMM15'', ''CMSP'', ''Professional''),
(''County Of Alameda/AIG'', ''41556'', ''41556'', ''Institutional''),
(''County Of Alameda/AIG'', ''41556'', ''41556'', ''Professional''),
(''County of Chesterfield, VA'', ''J1525'', ''J1525'', ''Institutional''),
(''County of Chesterfield, VA'', ''J1525'', ''J1525'', ''Professional''),
(''County of Humboldt (CA)'', ''J1603'', ''J1603'', ''Institutional''),
(''County of Humboldt (CA)'', ''J1603'', ''J1603'', ''Professional''),
(''County of Imperial'', ''J1961'', ''J1961'', ''Institutional''),
(''County of Imperial'', ''J1961'', ''J1961'', ''Professional''),
(''County of Kern'', ''J1935'', ''J1935'', ''Institutional''),
(''County of Kern'', ''J1935'', ''J1935'', ''Professional''),
(''County of Kern POS'', ''22149'', ''CABLC'', ''Institutional''),
(''County of Kern POS'', ''22149'', ''CABLC'', ''Professional''),
(''County of Los Angeles (1000)'', ''J1625'', ''J1625'', ''Institutional''),
(''County of Los Angeles (1000)'', ''J1625'', ''J1625'', ''Professional''),
(''County of Los Angeles (2000)'', ''J1722'', ''J1722'', ''Institutional''),
(''County of Los Angeles (2000)'', ''J1722'', ''J1722'', ''Professional''),
(''County of Los Angeles (3000)'', ''J1967'', ''J1967'', ''Institutional''),
(''County of Los Angeles (3000)'', ''J1967'', ''J1967'', ''Professional''),
(''County of Los Angeles (4000/5000)'', ''J1723'', ''J1723'', ''Institutional''),
(''County of Los Angeles (4000/5000)'', ''J1723'', ''J1723'', ''Professional''),
(''County Of Marin'', ''41556'', ''41556'', ''Institutional''),
(''County Of Marin'', ''41556'', ''41556'', ''Professional''),
(''County of San Diego'', ''J1513'', ''J1513'', ''Institutional''),
(''County of San Diego'', ''J1513'', ''J1513'', ''Professional''),
(''County of Santa Barbara (CA)'', ''J1631'', ''J1631'', ''Institutional''),
(''County of Santa Barbara (CA)'', ''J1631'', ''J1631'', ''Professional''),
(''County of Santa Barbara-CSAC (CA)'', ''J1631'', ''J1631'', ''Institutional''),
(''County of Santa Barbara-CSAC (CA)'', ''J1631'', ''J1631'', ''Professional''),
(''County of Santa Barbara-Non-CSAC (CA)'', ''J1631'', ''J1631'', ''Institutional''),
(''County of Santa Barbara-Non-CSAC (CA)'', ''J1631'', ''J1631'', ''Professional''),
(''County of Shasta (CA)'', ''J1616'', ''J1616'', ''Institutional''),
(''County of Shasta (CA)'', ''J1616'', ''J1616'', ''Professional''),
(''County of Sonoma (CA)'', ''J1662'', ''J1662'', ''Institutional''),
(''County of Sonoma (CA)'', ''J1662'', ''J1662'', ''Professional''),
(''County of Tulare (CA)'', ''J1666'', ''J1666'', ''Institutional''),
(''County of Tulare (CA)'', ''J1666'', ''J1666'', ''Professional''),
(''Courtyard Health C.'', ''41556'', ''41556'', ''Institutional''),
(''Courtyard Health C.'', ''41556'', ''41556'', ''Professional''),
(''Covenant Management Systems Employee Benefit Plan'', ''CMSEB'', ''CMSEB'', ''Institutional''),
(''Covenant Management Systems Employee Benefit Plan'', ''CMSEB'', ''CMSEB'', ''Professional''),
(''Coventry - Advantra (Texas, New Mexico & Arizona)'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Advantra (Texas, New Mexico & Arizona)'', ''25133'', ''25133'', ''Professional''),
(''Coventry - Advantra Freedom/Advantra Savings'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Advantra Freedom/Advantra Savings'', ''25133'', ''25133'', ''Professional''),
(''Coventry - Altius'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Altius'', ''25133'', ''25133'', ''Professional''),
(''Coventry - American Postal Workers Union Health Plan (APWU)'', ''44444'', ''44444'', ''Institutional''),
(''Coventry - American Postal Workers Union Health Plan (APWU)'', ''44444'', ''44444'', ''Professional''),
(''Coventry - Association Benefit Plan'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Association Benefit Plan'', ''25133'', ''25133'', ''Professional''),
(''Coventry - Carelink Health Plan'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Carelink Health Plan'', ''25133'', ''25133'', ''Professional''),
(''Coventry - Carelink Medicaid'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Carelink Medicaid'', ''25133'', ''25133'', ''Professional''),
(''Coventry - Carenet'', ''25133'', ''25133'', ''Professional''),
(''Coventry - First Health Network'', ''73159'', ''73159'', ''Institutional''),
(''Coventry - First Health Network'', ''73159'', ''73159'', ''Professional''),
(''Coventry - Foreign Service Benefit Plan'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Foreign Service Benefit Plan'', ''25133'', ''25133'', ''Professional''),
(''Coventry - Health America/Health Assurance'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Health America/Health Assurance'', ''25133'', ''25133'', ''Professional''),
(''Coventry - Healthcare USA'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Healthcare USA'', ''25133'', ''25133'', ''Professional''),
(''Coventry - Missouri Dept of Transportation/MODOT & St. Louis University'', ''25133'', ''25133'', ''Institutional''),
(''Coventry - Missouri Dept of Transportation/MODOT & St. Louis University'', ''25133'', ''25133'', ''Professional''),
(''Coventry Diamond Plan'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Diamond Plan'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health & Life - Tennessee'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health & Life - Tennessee'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health Care National Network'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health Care National Network'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health Care of Delaware'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health Care of Delaware'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health Care of Georgia'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health Care of Georgia'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health Care of Iowa'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health Care of Iowa'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health Care of Kansas'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health Care of Kansas'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health Care of Louisiana'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health Care of Louisiana'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health Care of Nebraska'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health Care of Nebraska'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health Care of Nevada'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health Care of Nevada'', ''25133'', ''25133'', ''Professional''),
(''Coventry Health Plan of Florida'', ''25133'', ''25133'', ''Institutional''),
(''Coventry Health Plan of Florida'', ''25133'', ''25133'', ''Professional''),
(''CoventryCares of Kentucky'', ''25133'', ''25133'', ''Institutional''),
(''CoventryCares of Kentucky'', ''25133'', ''25133'', ''Professional''),
(''CoventryCares of Michigan'', ''25133'', ''25133'', ''Institutional''),
(''CoventryCares of Michigan'', ''25133'', ''25133'', ''Professional''),
(''CoventryCares of Nebraska'', ''25133'', ''25133'', ''Institutional''),
(''CoventryCares of Nebraska'', ''25133'', ''25133'', ''Professional''),
(''CoventryCares of Virginia'', ''25133'', ''25133'', ''Institutional''),
(''CoventryCares of Virginia'', ''25133'', ''25133'', ''Professional''),
(''CoventryCares of West Virginia'', ''25133'', ''25133'', ''Institutional''),
(''CoventryCares of West Virginia'', ''25133'', ''25133'', ''Professional''),
(''COVID19 HRSA Uninsured Testing and Treatment Fund'', ''95964'', ''95964'', ''Institutional''),
(''COVID19 HRSA Uninsured Testing and Treatment Fund'', ''95964'', ''95964'', ''Professional''),
(''Coworx Staffing, LLC'', ''J1046'', ''J1046'', ''Institutional''),
(''Coworx Staffing, LLC'', ''J1046'', ''J1046'', ''Professional''),
(''Cox Construction Co'', ''41556'', ''41556'', ''Institutional''),
(''Cox Construction Co'', ''41556'', ''41556'', ''Professional''),
(''Cox Health Plan'', ''00019'', ''00019'', ''Professional''),
(''CPS Security Solutions'', ''41556'', ''41556'', ''Institutional''),
(''CPS Security Solutions'', ''41556'', ''41556'', ''Professional''),
(''Create'', ''CREA8'', ''CREA8'', ''Institutional''),
(''Create'', ''CREA8'', ''CREA8'', ''Professional''),
(''Creative Medical Systems'', ''64068'', ''64068'', ''Institutional''),
(''Creative Medical Systems'', ''64068'', ''64068'', ''Professional''),
(''Creative Plan Administrators'', ''37320'', ''37320'', ''Institutional''),
(''Creative Plan Administrators'', ''37320'', ''37320'', ''Professional''),
(''Crescent Crown Distributing'', ''J1965'', ''J1965'', ''Institutional''),
(''Crescent Crown Distributing'', ''J1965'', ''J1965'', ''Professional''),
(''Crescent Health Solutions'', ''56213'', ''56213'', ''Institutional''),
(''Crescent Health Solutions'', ''56213'', ''56213'', ''Professional''),
(''Crestbrook Insurance Company'', ''J1550'', ''J1550'', ''Institutional''),
(''Crestbrook Insurance Company'', ''J1550'', ''J1550'', ''Professional''),
(''Crown City Medical Group (CCMG)'', ''MPM35'', ''MPM35'', ''Institutional''),
(''Crown City Medical Group (CCMG)'', ''MPM35'', ''MPM35'', ''Professional''),
(''Croy-Hall Management, Inc.'', ''37266'', ''37266'', ''Institutional''),
(''Croy-Hall Management, Inc.'', ''37266'', ''37266'', ''Professional''),
(''Crum & Forster Indemnity Co'', ''31348'', ''31348'', ''Institutional''),
(''Crum & Forster Indemnity Co'', ''31348'', ''31348'', ''Professional''),
(''Crystal Run Health Plans'', ''46430'', ''46430'', ''Institutional''),
(''Crystal Run Health Plans'', ''46430'', ''46430'', ''Professional''),
(''CSAA Insurance Company'', ''LU539'', ''C1090'', ''Institutional''),
(''CSAA Insurance Company'', ''LU539'', ''C1090'', ''Professional''),
(''CSI Network Services'', ''34186'', ''34186'', ''Institutional''),
(''CSI Network Services'', ''34186'', ''34186'', ''Professional''),
(''Cucamonga School District (CA)'', ''J1690'', ''J1690'', ''Institutional''),
(''Cucamonga School District (CA)'', ''J1690'', ''J1690'', ''Professional''),
(''Cumberland Insurance Group'', ''LU549'', ''C1091'', ''Institutional''),
(''Cumberland Insurance Group'', ''LU549'', ''C1091'', ''Professional''),
(''Cure Auto Insurance For NJ Auto'', ''LU552'', ''C1092'', ''Institutional''),
(''Cure Auto Insurance For NJ Auto'', ''LU552'', ''C1092'', ''Professional''),
(''Custom Design Benefits, Inc'', ''82056'', ''82056'', ''Institutional''),
(''Custom Design Benefits, Inc'', ''82056'', ''82056'', ''Professional''),
(''CVS Pharmacy (CAREMARK) (WC Only)'', ''J3973'', ''J3973'', ''Institutional''),
(''CVS Pharmacy (CAREMARK) (WC Only)'', ''J3973'', ''J3973'', ''Professional''),
(''CWIBENEFITS'', ''57080'', ''57080'', ''Institutional''),
(''CWIBENEFITS'', ''57080'', ''57080'', ''Professional''),
(''Cypress Benefit Admin'', ''88056'', ''88056'', ''Institutional''),
(''Cypress Benefit Admin'', ''88056'', ''88056'', ''Professional''),
(''Cypress Insurance Company (Member of BHHC)'', ''20044'', ''20044'', ''Institutional''),
(''Cypress Insurance Company (Member of BHHC)'', ''20044'', ''20044'', ''Professional''),
(''Dahl''''s Foods (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Dahl''''s Foods (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''DaimlerChrysler Corporation'', ''41556'', ''41556'', ''Institutional''),
(''DaimlerChrysler Corporation'', ''41556'', ''41556'', ''Professional''),
(''Dairyland Insurance Company'', ''C1033'', ''C1033'', ''Institutional''),
(''Dairyland Insurance Company'', ''C1033'', ''C1033'', ''Professional''),
(''Dakota Fire'', ''21415'', ''21415'', ''Institutional''),
(''Dakota Fire'', ''21415'', ''21415'', ''Professional''),
(''Dakota Fire'', ''C1029'', ''C1029'', ''Institutional''),
(''Dakota Fire'', ''C1029'', ''C1029'', ''Professional''),
(''Dakota Fire'', ''J1433'', ''J1433'', ''Institutional''),
(''Dakota Fire'', ''J1433'', ''J1433'', ''Professional''),
(''DakotaCare'', ''DAK01'', ''DAK01'', ''Institutional''),
(''DakotaCare'', ''DAK01'', ''DAK01'', ''Professional''),
(''Dallas County Community College District'', ''41556'', ''41556'', ''Institutional''),
(''Dallas County Community College District'', ''41556'', ''41556'', ''Professional''),
(''Dallas Independent School District'', ''J1494'', ''J1494'', ''Institutional''),
(''Dallas Independent School District'', ''J1494'', ''J1494'', ''Professional''),
(''Danaher Corporation'', ''J1051'', ''J1051'', ''Institutional''),
(''Danaher Corporation'', ''J1051'', ''J1051'', ''Professional''),
(''Darigold'', ''J1936'', ''J1936'', ''Institutional''),
(''Darigold'', ''J1936'', ''J1936'', ''Professional''),
(''Dart Member Care'', ''CB987'', ''CB987'', ''Institutional''),
(''Dart Member Care'', ''CB987'', ''CB987'', ''Professional''),
(''Davis Mech Systems'', ''41556'', ''41556'', ''Institutional''),
(''Davis Mech Systems'', ''41556'', ''41556'', ''Professional''),
(''Davis Vision'', ''00157'', ''00157'', ''Professional''),
(''Daylight Transport'', ''41556'', ''41556'', ''Institutional''),
(''Daylight Transport'', ''41556'', ''41556'', ''Professional''),
(''De Bartolos, Inc'', ''J1058'', ''J1058'', ''Institutional''),
(''De Bartolos, Inc'', ''J1058'', ''J1058'', ''Professional''),
(''Dean Health Plan'', ''39113'', ''39113'', ''Institutional''),
(''Dean Health Plan'', ''39113'', ''39113'', ''Professional''),
(''Del Taco, LLC'', ''J1681'', ''J1681'', ''Institutional''),
(''Del Taco, LLC'', ''J1681'', ''J1681'', ''Professional''),
(''Delano IPA'', ''77124'', ''77124'', ''Professional''),
(''Delano Regional Medical Group (Managed Care Systems)'', ''MCS03'', ''MCS03'', ''Institutional''),
(''Delano Regional Medical Group (Managed Care Systems)'', ''MCS03'', ''MCS03'', ''Professional''),
(''Delaware Health Plan Consortium'', ''63081'', ''63081'', ''Institutional''),
(''Delaware Health Plan Consortium'', ''63081'', ''63081'', ''Professional''),
(''DelawareCare'', ''25137'', ''25137'', ''Institutional''),
(''DelawareCare'', ''25137'', ''25137'', ''Professional''),
(''Dell Children''''s Health Plan'', ''74272'', ''27182'', ''Institutional''),
(''Dell Children''''s Health Plan'', ''74272'', ''27182'', ''Professional''),
(''Delos'', ''J1955'', ''J1955'', ''Institutional''),
(''Delos'', ''J1955'', ''J1955'', ''Professional''),
(''Delta Health Systems'', ''94235'', ''94235'', ''Institutional''),
(''Delta Health Systems'', ''94235'', ''94235'', ''Professional''),
(''Dental Guard Preferred'', ''64246'', ''64246'', ''Institutional''),
(''Dental Guard Preferred'', ''64246'', ''64246'', ''Professional''),
(''Denver Health - Indigent'', ''84134'', ''84134'', ''Institutional''),
(''Denver Health - Indigent'', ''84134'', ''84134'', ''Professional''),
(''Denver Health and Hospital Authority'', ''84133'', ''84133'', ''Institutional''),
(''Denver Health and Hospital Authority'', ''84133'', ''84133'', ''Professional''),
(''Denver Health Medicaid Choice (DHMC)'', ''84133'', ''84133'', ''Institutional''),
(''Denver Health Medicaid Choice (DHMC)'', ''84133'', ''84133'', ''Professional''),
(''Denver Health Medical Plan'', ''84135'', ''84135'', ''Institutional''),
(''Denver Health Medical Plan'', ''84135'', ''84135'', ''Professional''),
(''Denver Health Medical Plan Inc.'', ''65456'', ''65456'', ''Institutional''),
(''Denver Health Medical Plan Inc.'', ''65456'', ''65456'', ''Professional''),
(''Denver Health Medical Plan, Inc. - Medicare Choice'', ''84131'', ''84131'', ''Institutional''),
(''Denver Health Medical Plan, Inc. - Medicare Choice'', ''84131'', ''84131'', ''Professional''),
(''Denver Public Schools'', ''41556'', ''41556'', ''Institutional''),
(''Denver Public Schools'', ''41556'', ''41556'', ''Professional''),
(''Department of Corrections & Rehabilitative Services - Oklahoma'', ''71065'', ''71065'', ''Institutional''),
(''Department of Corrections & Rehabilitative Services - Oklahoma'', ''71065'', ''71065'', ''Professional''),
(''Department of Labor'', ''J1438'', ''J1438'', ''Institutional''),
(''Department of Labor'', ''J1438'', ''J1438'', ''Professional''),
(''Department of Labor Energy'', ''J1449'', ''J1449'', ''Institutional''),
(''Department of Labor Energy'', ''J1449'', ''J1449'', ''Professional''),
(''Department of Water and Power of the City of Los Angeles (LADWP)'', ''J1514'', ''J1514'', ''Institutional''),
(''Department of Water and Power of the City of Los Angeles (LADWP)'', ''J1514'', ''J1514'', ''Professional''),
(''Depositors Ins Co'', ''J1550'', ''J1550'', ''Institutional''),
(''Depositors Ins Co'', ''J1550'', ''J1550'', ''Professional''),
(''Deseret Mutual Benefit Administration'', ''SX105'', ''SX105'', ''Institutional''),
(''Deseret Mutual Benefit Administration'', ''SX105'', ''SX105'', ''Professional''),
(''Desert Hospital District'', ''41556'', ''41556'', ''Institutional''),
(''Desert Hospital District'', ''41556'', ''41556'', ''Professional''),
(''Desert Medical Group (California)'', ''DESRT'', ''DESRT'', ''Professional''),
(''Desert Princess'', ''41556'', ''41556'', ''Institutional''),
(''Desert Princess'', ''41556'', ''41556'', ''Professional''),
(''Desert Valley Medical Group'', ''DVMC1'', ''DVMC1'', ''Institutional''),
(''Desert Valley Medical Group'', ''DVMC1'', ''DVMC1'', ''Professional''),
(''Devon Health Services'', ''68423'', ''68423'', ''Institutional''),
(''Devon Health Services'', ''68423'', ''68423'', ''Professional''),
(''Devoted Health Plan'', ''DEVOT'', ''DEVOT'', ''Institutional''),
(''Devoted Health Plan'', ''DEVOT'', ''DEVOT'', ''Professional''),
(''Diamond Farming Company'', ''41556'', ''41556'', ''Institutional''),
(''Diamond Farming Company'', ''41556'', ''41556'', ''Professional''),
(''Diploma Joint Insurance Fund (SEL)'', ''LU571'', ''J3934'', ''Institutional''),
(''Diploma Joint Insurance Fund (SEL)'', ''LU571'', ''J3934'', ''Professional''),
(''Direct Care Administrators - Health West Admin'', ''DCA62'', ''DCA62'', ''Institutional''),
(''Direct Care Administrators - Health West Admin'', ''DCA62'', ''DCA62'', ''Professional''),
(''Directors Guild of America - Producer Health Plan'', ''DGA01'', ''PAPER'', ''Institutional''),
(''Directors Guild of America - Producer Health Plan'', ''DGA01'', ''PAPER'', ''Professional''),
(''Directory Distributing Assoc.'', ''J1059'', ''J1059'', ''Institutional''),
(''Directory Distributing Assoc.'', ''J1059'', ''J1059'', ''Professional''),
(''DirigoChoice PPO'', ''44273'', ''44273'', ''Institutional''),
(''DirigoChoice PPO'', ''44273'', ''44273'', ''Professional''),
(''Discount Tire'', ''J1611'', ''J1611'', ''Institutional''),
(''Discount Tire'', ''J1611'', ''J1611'', ''Professional''),
(''Discover Re (Burger King)'', ''J1060'', ''J1060'', ''Institutional''),
(''Discover Re (Burger King)'', ''J1060'', ''J1060'', ''Professional''),
(''Discovery Hy-Vee (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Discovery Hy-Vee (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Disneyland Resorts (Bunch CareSolutions)'', ''J1933'', ''J1933'', ''Institutional''),
(''Disneyland Resorts (Bunch CareSolutions)'', ''J1933'', ''J1933'', ''Professional''),
(''Diversified Administration'', ''06102'', ''06102'', ''Institutional''),
(''Diversified Administration'', ''06102'', ''06102'', ''Professional''),
(''Diversified Group Administration'', ''25160'', ''25160'', ''Professional''),
(''DME Jurisdiction A, CEDI'', ''16013'', ''16013'', ''Professional''),
(''DME Jurisdiction B, CEDI'', ''17013'', ''17013'', ''Professional''),
(''DME Jurisdiction C, CEDI'', ''18003'', ''18003'', ''Professional''),
(''DME Jurisdiction D, CEDI'', ''19003'', ''19003'', ''Professional''),
(''Doctors Healthcare Plan'', ''DRHCP'', ''DRHCP'', ''Institutional''),
(''Doctors Healthcare Plan'', ''DRHCP'', ''DRHCP'', ''Professional''),
(''Douglas County'', ''41556'', ''41556'', ''Institutional''),
(''Douglas County'', ''41556'', ''41556'', ''Professional''),
(''Downey Select IPA'', ''APP01'', ''APP01'', ''Institutional''),
(''Downey Select IPA'', ''APP01'', ''APP01'', ''Professional''),
(''Dreyer Health'', ''DREYR'', ''DREYR'', ''Professional''),
(''Dreyer Medical'', ''DREYR'', ''DREYR'', ''Professional''),
(''Driscoll Children''''s Health Plan (CHIP) (Texas)'', ''74284'', ''74284'', ''Institutional''),
(''Driscoll Children''''s Health Plan (CHIP) (Texas)'', ''74284'', ''74284'', ''Professional''),
(''Dunn & Associates Benefit Administrators'', ''35186'', ''35186'', ''Institutional''),
(''Dunn & Associates Benefit Administrators'', ''35186'', ''35186'', ''Professional''),
(''Dunn-Edwards Corporation'', ''J1061'', ''J1061'', ''Institutional''),
(''Dunn-Edwards Corporation'', ''J1061'', ''J1061'', ''Professional''),
(''Durango Coffee Co.'', ''41556'', ''41556'', ''Institutional''),
(''Durango Coffee Co.'', ''41556'', ''41556'', ''Professional''),
(''Dustrol (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Dustrol (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Dynamex, Inc.'', ''J1062'', ''J1062'', ''Institutional''),
(''Dynamex, Inc.'', ''J1062'', ''J1062'', ''Professional''),
(''E.S. Beveridge & Associates'', ''34108'', ''34108'', ''Institutional''),
(''E.S. Beveridge & Associates'', ''34108'', ''34108'', ''Professional''),
(''Eagle Claims'', ''J1934'', ''J1934'', ''Institutional''),
(''Eagle Claims'', ''J1934'', ''J1934'', ''Professional''),
(''Eagle Pass ISD'', ''41556'', ''41556'', ''Institutional''),
(''Eagle Pass ISD'', ''41556'', ''41556'', ''Professional''),
(''Early Intervention Central Billing'', ''36434'', ''36434'', ''Professional''),
(''East Carolina Behavioral Health, Trillium Health Resources'', ''56089'', ''56089'', ''Institutional''),
(''East Carolina Behavioral Health, Trillium Health Resources'', ''56089'', ''56089'', ''Professional''),
(''East San Gabriel Valley ROP (CA)'', ''J1690'', ''J1690'', ''Institutional''),
(''East San Gabriel Valley ROP (CA)'', ''J1690'', ''J1690'', ''Professional''),
(''Eastern Iowa Community Healthcare (EICH)'', ''23861'', ''23861'', ''Institutional''),
(''Eastern Iowa Community Healthcare (EICH)'', ''23861'', ''23861'', ''Professional''),
(''EastGUARD Insurance Company - Guard DBA'', ''J1453'', ''J1453'', ''Institutional''),
(''EastGUARD Insurance Company - Guard DBA'', ''J1453'', ''J1453'', ''Professional''),
(''Eastland Medical Group IPA'', ''LMG01'', ''EMG11'', ''Institutional''),
(''Eastland Medical Group IPA'', ''LMG01'', ''EMG11'', ''Professional''),
(''Eastman Kodak Company'', ''J1903'', ''J1903'', ''Institutional''),
(''Eastman Kodak Company'', ''J1903'', ''J1903'', ''Professional''),
(''Easy Care MSO, LLC'', ''ECMSO'', ''ECMSO'', ''Institutional''),
(''Easy Care MSO, LLC'', ''ECMSO'', ''ECMSO'', ''Professional''),
(''Easy Choice Health Plan of California (Fee for Service)'', ''20532'', ''20532'', ''Institutional''),
(''Easy Choice Health Plan of California (Fee for Service)'', ''20532'', ''20532'', ''Professional''),
(''EBC, Inc. (EBSO)'', ''37257'', ''37257'', ''Institutional''),
(''EBC, Inc. (EBSO)'', ''37257'', ''37257'', ''Professional''),
(''EBS of Louisiana'', ''EBSL1'', ''PAPER'', ''Institutional''),
(''EBS of Louisiana'', ''EBSL1'', ''PAPER'', ''Professional''),
(''Echo Pacific Develop'', ''41556'', ''41556'', ''Institutional''),
(''Echo Pacific Develop'', ''41556'', ''41556'', ''Professional''),
(''Edinburg Consolidated Independent School District'', ''41556'', ''41556'', ''Institutional''),
(''Edinburg Consolidated Independent School District'', ''41556'', ''41556'', ''Professional''),
(''Edinger Medical Group'', ''GNPMG'', ''GNPMG'', ''Professional''),
(''EDS Administrative Services'', ''22521'', ''22521'', ''Institutional''),
(''EDS Administrative Services'', ''22521'', ''22521'', ''Professional''),
(''Educators Mutual Insurance (EMIA)'', ''SX110'', ''SX110'', ''Professional''),
(''Edwards Claim Administration'', ''J1204'', ''J1204'', ''Institutional''),
(''Edwards Claim Administration'', ''J1204'', ''J1204'', ''Professional''),
(''EHS Employee Health Systems'', ''SYMED'', ''SYMED'', ''Professional''),
(''EHS Medical Group - Fresno'', ''SYMED'', ''SYMED'', ''Professional''),
(''Eighth District Electrical Benefit Fund'', ''74234'', ''74234'', ''Professional''),
(''El Paso Community College (TX Jur)'', ''A0106'', ''A0106'', ''Institutional''),
(''El Paso Community College (TX Jur)'', ''A0106'', ''A0106'', ''Professional''),
(''El Paso First - CHIP'', ''EPF03'', ''EPF03'', ''Institutional''),
(''El Paso First - CHIP'', ''EPF03'', ''EPF03'', ''Professional''),
(''El Paso First EPCCS'', ''EPF37'', ''EPF37'', ''Institutional''),
(''El Paso First EPCCS'', ''EPF37'', ''EPF37'', ''Professional''),
(''El Paso First Preferred Administrators Childrens Hospital'', ''EPF11'', ''EPF11'', ''Institutional''),
(''El Paso First Preferred Administrators Childrens Hospital'', ''EPF11'', ''EPF11'', ''Professional''),
(''El Paso First Preferred Administrators UMC'', ''EPF10'', ''EPF10'', ''Institutional''),
(''El Paso First Preferred Administrators UMC'', ''EPF10'', ''EPF10'', ''Professional''),
(''El Paso First Premier Plan (STAR)'', ''EPF02'', ''EPF02'', ''Institutional''),
(''El Paso First Premier Plan (STAR)'', ''EPF02'', ''EPF02'', ''Professional''),
(''El Paso Water Util TX Jur'', ''J1017'', ''J1017'', ''Institutional''),
(''El Paso Water Util TX Jur'', ''J1017'', ''J1017'', ''Professional''),
(''El Pollo Loco'', ''J1737'', ''J1737'', ''Institutional''),
(''El Pollo Loco'', ''J1737'', ''J1737'', ''Professional''),
(''El Proyecto del Barrio (MedPOINT) California'', ''MPM04'', ''MPM04'', ''Professional''),
(''ELC Electric Inc'', ''41556'', ''41556'', ''Institutional''),
(''ELC Electric Inc'', ''41556'', ''41556'', ''Professional''),
(''ElderPlan, Inc.'', ''31625'', ''31625'', ''Institutional''),
(''ElderPlan, Inc.'', ''31625'', ''31625'', ''Professional''),
(''Elderwood Health'', ''03964'', ''03964'', ''Institutional''),
(''Elderwood Health'', ''03964'', ''03964'', ''Professional''),
(''Electric Insurance Company'', ''LU546'', ''C1093'', ''Institutional''),
(''Electric Insurance Company'', ''LU546'', ''C1093'', ''Professional''),
(''Electrical Workers Insurance Fund Local 5800'', ''93235'', ''93235'', ''Institutional''),
(''Electrical Workers Insurance Fund Local 5800'', ''93235'', ''93235'', ''Professional''),
(''Element Care'', ''04326'', ''04326'', ''Institutional''),
(''Element Care'', ''04326'', ''04326'', ''Professional''),
(''Elite Comp'', ''41556'', ''41556'', ''Institutional''),
(''Elite Comp'', ''41556'', ''41556'', ''Professional''),
(''Ellis Consultants Inc.'', ''ECISF'', ''ECISF'', ''Institutional''),
(''Ellis Consultants Inc.'', ''ECISF'', ''ECISF'', ''Professional''),
(''EMC Property and Casualty - AUTO ONLY'', ''C1029'', ''C1029'', ''Institutional''),
(''EMC Property and Casualty - AUTO ONLY'', ''C1029'', ''C1029'', ''Professional''),
(''EMC Property and Casualty - LIAB ONLY'', ''J1433'', ''J1433'', ''Institutional''),
(''EMC Property and Casualty - LIAB ONLY'', ''J1433'', ''J1433'', ''Professional''),
(''EMC Property and Casualty - WC ONLY'', ''21415'', ''21415'', ''Institutional''),
(''EMC Property and Casualty - WC ONLY'', ''21415'', ''21415'', ''Professional''),
(''EMCASCO Insurance Co - AUTO ONLY'', ''C1029'', ''C1029'', ''Institutional''),
(''EMCASCO Insurance Co - AUTO ONLY'', ''C1029'', ''C1029'', ''Professional''),
(''EMCASCO Insurance Co - LIAB ONLY'', ''J1433'', ''J1433'', ''Institutional''),
(''EMCASCO Insurance Co - LIAB ONLY'', ''J1433'', ''J1433'', ''Professional''),
(''EMCASCO Insurance Co - WC ONLY'', ''21407'', ''21407'', ''Institutional''),
(''EMCASCO Insurance Co - WC ONLY'', ''21407'', ''21407'', ''Professional''),
(''Emerald Health Network Inc (all PPO)'', ''34167'', ''34167'', ''Institutional''),
(''Emerald Health Network Inc (all PPO)'', ''34167'', ''34167'', ''Professional''),
(''Emeritus Corporation'', ''J1679'', ''J1679'', ''Institutional''),
(''Emeritus Corporation'', ''J1679'', ''J1679'', ''Professional''),
(''EMHS Employee Health Plan'', ''16565'', ''16565'', ''Institutional''),
(''EMHS Employee Health Plan'', ''16565'', ''16565'', ''Professional''),
(''EMI-KP Ambulance Claims'', ''59299'', ''59299'', ''Professional''),
(''Empire Blue Cross Blue Shield HealthPlus, Anthem'', ''SB803'', ''SB803'', ''Institutional''),
(''Empire Blue Cross Blue Shield HealthPlus, Anthem'', ''SB803'', ''SB803'', ''Professional''),
(''Empire Healthcare IPA'', ''PDT01'', ''PDT01'', ''Institutional''),
(''Empire Healthcare IPA'', ''PDT01'', ''PDT01'', ''Professional''),
(''Empire Physicians MG'', ''EMP01'', ''EMP01'', ''Professional''),
(''Employee Benefit Administration & Management (EBA&M)'', ''95288'', ''95288'', ''Professional''),
(''Employee Benefit Concepts - Farmington Hills, Michigan'', ''38241'', ''38241'', ''Institutional''),
(''Employee Benefit Concepts - Farmington Hills, Michigan'', ''38241'', ''38241'', ''Professional''),
(''Employee Benefit Consultants'', ''37257'', ''37257'', ''Institutional''),
(''Employee Benefit Consultants'', ''37257'', ''37257'', ''Professional''),
(''Employee Benefit Logistics (EBL)'', ''92135'', ''92135'', ''Institutional''),
(''Employee Benefit Logistics (EBL)'', ''92135'', ''92135'', ''Professional''),
(''Employee Benefit Management Corporation  (Ohio) (EBMC)'', ''31074'', ''31074'', ''Institutional''),
(''Employee Benefit Management Corporation  (Ohio) (EBMC)'', ''31074'', ''31074'', ''Professional''),
(''Employee Benefit Management Services, Inc. (EBMS)'', ''81039'', ''81039'', ''Institutional''),
(''Employee Benefit Management Services, Inc. (EBMS)'', ''81039'', ''81039'', ''Professional''),
(''Employee Benefit Services - Ft. Mill, South Carolina'', ''37216'', ''37216'', ''Institutional''),
(''Employee Benefit Services - Ft. Mill, South Carolina'', ''37216'', ''37216'', ''Professional''),
(''Employee Benefit Services of Louisiana, Inc. (EBS)'', ''EBSL1'', ''PAPER'', ''Institutional''),
(''Employee Benefit Services of Louisiana, Inc. (EBS)'', ''EBSL1'', ''PAPER'', ''Professional''),
(''Employee Benefit Services, Inc. (EBSI)'', ''60221'', ''60221'', ''Institutional''),
(''Employee Benefit Services, Inc. (EBSI)'', ''60221'', ''60221'', ''Professional''),
(''Employee Benefit Systems'', ''42149'', ''42149'', ''Institutional''),
(''Employee Benefit Systems'', ''42149'', ''42149'', ''Professional''),
(''Employee Benefits Administrators (EBA)'', ''EBA42'', ''EBA42'', ''Institutional''),
(''Employee Benefits Administrators (EBA)'', ''EBA42'', ''EBA42'', ''Professional''),
(''Employee Benefits Plan Administration, Inc (EBPA)'', ''03036'', ''03036'', ''Institutional''),
(''Employee Benefits Plan Administration, Inc (EBPA)'', ''03036'', ''03036'', ''Professional''),
(''Employee Plans, LLC'', ''35112'', ''35112'', ''Institutional''),
(''Employee Plans, LLC'', ''35112'', ''35112'', ''Professional''),
(''Employee Security, Inc.'', ''54098'', ''54098'', ''Institutional''),
(''Employee Security, Inc.'', ''54098'', ''54098'', ''Professional''),
(''Employer Driven Insurance Service (EDIS)'', ''48888'', ''48888'', ''Institutional''),
(''Employer Driven Insurance Service (EDIS)'', ''48888'', ''48888'', ''Professional''),
(''Employer Insurance Group (EIG)'', ''J1232'', ''J1232'', ''Institutional''),
(''Employer Insurance Group (EIG)'', ''J1232'', ''J1232'', ''Professional''),
(''EMPLOYER''''S CLAIM SERVICE, INC - City of Naperville'', ''J1559'', ''J1559'', ''Institutional''),
(''EMPLOYER''''S CLAIM SERVICE, INC - City of Naperville'', ''J1559'', ''J1559'', ''Professional''),
(''Employers Assurance Company'', ''J1232'', ''J1232'', ''Institutional''),
(''Employers Assurance Company'', ''J1232'', ''J1232'', ''Professional''),
(''Employers Coalition on Health (ECOH)'', ''36335'', ''27008'', ''Professional''),
(''Employers Compensation Insurance Company'', ''J1232'', ''J1232'', ''Institutional''),
(''Employers Compensation Insurance Company'', ''J1232'', ''J1232'', ''Professional''),
(''Employers Direct Health'', ''75232'', ''75232'', ''Institutional''),
(''Employers Direct Health'', ''75232'', ''75232'', ''Professional''),
(''Employers Direct Health (Employee Plan)'', ''75236'', ''75236'', ''Institutional''),
(''Employers Direct Health (Employee Plan)'', ''75236'', ''75236'', ''Professional''),
(''Employers Direct Health (Fully Insured)'', ''75235'', ''75235'', ''Institutional''),
(''Employers Direct Health (Fully Insured)'', ''75235'', ''75235'', ''Professional''),
(''Employers Direct Health (Self-Funded Plan)'', ''75233'', ''75233'', ''Institutional''),
(''Employers Direct Health (Self-Funded Plan)'', ''75233'', ''75233'', ''Professional''),
(''Employers General Insurance Group'', ''J1696'', ''J1696'', ''Institutional''),
(''Employers General Insurance Group'', ''J1696'', ''J1696'', ''Professional''),
(''Employers Insurance (Bunch CareSolutions)'', ''J1912'', ''J1912'', ''Institutional''),
(''Employers Insurance (Bunch CareSolutions)'', ''J1912'', ''J1912'', ''Professional''),
(''Employers Mutual Casualty - AUTO ONLY'', ''C1029'', ''C1029'', ''Institutional''),
(''Employers Mutual Casualty - AUTO ONLY'', ''C1029'', ''C1029'', ''Professional''),
(''Employers Mutual Casualty - LIAB ONLY'', ''J1433'', ''J1433'', ''Institutional''),
(''Employers Mutual Casualty - LIAB ONLY'', ''J1433'', ''J1433'', ''Professional''),
(''Employers Mutual Casualty - WC ONLY'', ''21415'', ''21415'', ''Institutional''),
(''Employers Mutual Casualty - WC ONLY'', ''21415'', ''21415'', ''Professional''),
(''Employers Mutual, Inc - Jacksonville, Florida'', ''59298'', ''59298'', ''Institutional''),
(''Employers Mutual, Inc - Jacksonville, Florida'', ''59298'', ''59298'', ''Professional''),
(''Employers Mutual, Inc - Stuart, Florida'', ''59331'', ''59331'', ''Institutional''),
(''Employers Mutual, Inc - Stuart, Florida'', ''59331'', ''59331'', ''Professional''),
(''Employers Preferred Insurance Company'', ''J1232'', ''J1232'', ''Institutional''),
(''Employers Preferred Insurance Company'', ''J1232'', ''J1232'', ''Professional''),
(''Encircle PPO'', ''35206'', ''35206'', ''Institutional''),
(''Encircle PPO'', ''35206'', ''35206'', ''Professional''),
(''Encore Health Networks'', ''35206'', ''35206'', ''Institutional''),
(''Encore Health Networks'', ''35206'', ''35206'', ''Professional''),
(''Enstar Natural Gas'', ''91136'', ''91136'', ''Institutional''),
(''Enstar Natural Gas'', ''91136'', ''91136'', ''Professional''),
(''Enterprise Group Planning'', ''EGPIN'', ''EGPIN'', ''Professional''),
(''Entrust Inc'', ''36878'', ''36878'', ''Institutional''),
(''Entrust Inc'', ''36878'', ''36878'', ''Professional''),
(''Envirosource'', ''J1063'', ''J1063'', ''Institutional''),
(''Envirosource'', ''J1063'', ''J1063'', ''Professional''),
(''Envision Radiology, LLC'', ''41556'', ''41556'', ''Institutional''),
(''Envision Radiology, LLC'', ''41556'', ''41556'', ''Professional''),
(''Envolve Benefit Options'', ''56190'', ''56190'', ''Professional''),
(''EON Health'', ''66011'', ''66011'', ''Institutional''),
(''EON Health'', ''66011'', ''66011'', ''Professional''),
(''EON Health'', ''73780'', ''73780'', ''Institutional''),
(''EON Health'', ''73780'', ''73780'', ''Professional''),
(''Eplica, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Eplica, Inc.'', ''41556'', ''41556'', ''Professional''),
(''Equitable Life & Casualty Insurance'', ''ELCI1'', ''PAPER'', ''Institutional''),
(''Equitable Life & Casualty Insurance'', ''ELCI1'', ''PAPER'', ''Professional''),
(''Ergon, Inc.'', ''J1952'', ''J1952'', ''Institutional''),
(''Ergon, Inc.'', ''J1952'', ''J1952'', ''Professional''),
(''Erickson-Hall Constr'', ''41556'', ''41556'', ''Institutional''),
(''Erickson-Hall Constr'', ''41556'', ''41556'', ''Professional''),
(''ERMC'', ''J1022'', ''J1022'', ''Institutional''),
(''ERMC'', ''J1022'', ''J1022'', ''Professional''),
(''ESIS'', ''TP043'', ''TP043'', ''Institutional''),
(''ESIS'', ''TP043'', ''TP043'', ''Professional''),
(''ESIS - First American Insurance Co'', ''J1064'', ''J1064'', ''Institutional''),
(''ESIS - First American Insurance Co'', ''J1064'', ''J1064'', ''Professional''),
(''ESIS - Kelly Services'', ''J1451'', ''J1451'', ''Institutional''),
(''ESIS - Kelly Services'', ''J1451'', ''J1451'', ''Professional''),
(''ESIS - Lockheed Martin Corporation'', ''J1454'', ''J1454'', ''Institutional''),
(''ESIS - Lockheed Martin Corporation'', ''J1454'', ''J1454'', ''Professional''),
(''Esperanza IPA'', ''EIPA8'', ''EIPA8'', ''Institutional''),
(''Esperanza IPA'', ''EIPA8'', ''EIPA8'', ''Professional''),
(''Essence Healthcare'', ''20818'', ''20818'', ''Institutional''),
(''Essence Healthcare'', ''20818'', ''20818'', ''Professional''),
(''EssentiaCare'', ''55413'', ''55413'', ''Institutional''),
(''EssentiaCare'', ''55413'', ''55413'', ''Professional''),
(''Essential Health Partners'', ''EHPSC'', ''EHPSC'', ''Institutional''),
(''Essential Health Partners'', ''EHPSC'', ''EHPSC'', ''Professional''),
(''Esurance Insurance Company'', ''25712'', ''25712'', ''Institutional''),
(''Esurance Insurance Company'', ''25712'', ''25712'', ''Professional''),
(''EverCare Star Plus (all states)'', ''87726'', ''87726'', ''Institutional''),
(''EverCare Star Plus (all states)'', ''87726'', ''87726'', ''Professional''),
(''Everence'', ''35605'', ''35605'', ''Institutional''),
(''Everence'', ''35605'', ''35605'', ''Professional''),
(''Everest National Ins Co. - CA1'', ''J2678'', ''J2678'', ''Institutional''),
(''Everest National Ins Co. - CA1'', ''J2678'', ''J2678'', ''Professional''),
(''eviCore - MedSolutions, Inc.'', ''62160'', ''62160'', ''Institutional''),
(''eviCore - MedSolutions, Inc.'', ''62160'', ''62160'', ''Professional''),
(''Evolution Insurance Company'', ''J1065'', ''J1065'', ''Institutional''),
(''Evolution Insurance Company'', ''J1065'', ''J1065'', ''Professional''),
(''Evolutions Healthcare Systems (New Port Richey, FL)'', ''59313'', ''59313'', ''Institutional''),
(''Evolutions Healthcare Systems (New Port Richey, FL)'', ''59313'', ''59313'', ''Professional''),
(''Excel MSO'', ''EXC01'', ''EXC01'', ''Professional''),
(''Exceptional Care Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Exceptional Care Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''ExclusiCare (UCCI)'', ''71412'', ''71412'', ''Institutional''),
(''ExclusiCare (UCCI)'', ''71412'', ''71412'', ''Professional''),
(''Exclusive Care - County of Riverside'', ''EC999'', ''EC999'', ''Institutional''),
(''Exclusive Care - County of Riverside'', ''EC999'', ''EC999'', ''Professional''),
(''Exemplar Health'', ''83383'', ''83383'', ''Institutional''),
(''Exemplar Health'', ''83383'', ''83383'', ''Professional''),
(''Extended Care MLTC'', ''46166'', ''46166'', ''Institutional''),
(''Extended Care MLTC'', ''46166'', ''46166'', ''Professional''),
(''ExxonMobil Corporation'', ''J1606'', ''J1606'', ''Institutional''),
(''ExxonMobil Corporation'', ''J1606'', ''J1606'', ''Professional''),
(''EyeMed'', ''85431'', ''85431'', ''Professional''),
(''EyeQuest'', ''63740'', ''63740'', ''Institutional''),
(''EyeQuest'', ''63740'', ''63740'', ''Professional''),
(''F&G Guaranty Ins Co/Main Street Program Colorado'', ''41556'', ''41556'', ''Institutional''),
(''F&G Guaranty Ins Co/Main Street Program Colorado'', ''41556'', ''41556'', ''Professional''),
(''FABOH (CHP/RPU)'', ''39112'', ''39112'', ''Institutional''),
(''FABOH (CHP/RPU)'', ''39112'', ''39112'', ''Professional''),
(''Facey Medical Foundation'', ''95432'', ''95432'', ''Professional''),
(''FACS Group'', ''37300'', ''37300'', ''Institutional''),
(''FACS Group'', ''37300'', ''37300'', ''Professional''),
(''Factory 2 U'', ''J1019'', ''J1019'', ''Institutional''),
(''Factory 2 U'', ''J1019'', ''J1019'', ''Professional''),
(''Fairchild Fasteners'', ''J1624'', ''J1624'', ''Institutional''),
(''Fairchild Fasteners'', ''J1624'', ''J1624'', ''Professional''),
(''Fairfax County Government'', ''J1884'', ''J1884'', ''Institutional''),
(''Fairfax County Government'', ''J1884'', ''J1884'', ''Professional''),
(''Fairmont Specialty Insurance Company - TX'', ''J1697'', ''J1697'', ''Institutional''),
(''Fairmont Specialty Insurance Company - TX'', ''J1697'', ''J1697'', ''Professional''),
(''Fairview Health Services'', ''J1618'', ''J1618'', ''Institutional''),
(''Fairview Health Services'', ''J1618'', ''J1618'', ''Professional''),
(''Falling Colors'', ''FCC20'', ''FCC20'', ''Institutional''),
(''Falling Colors'', ''FCC20'', ''FCC20'', ''Professional''),
(''Fallon Community Health Plan'', ''22254'', ''22254'', ''Institutional''),
(''Fallon Community Health Plan'', ''22254'', ''22254'', ''Professional''),
(''Family Care Medicaid Mental Health'', ''FCM01'', ''FCM01'', ''Professional''),
(''Family Care Medicare'', ''PHR01'', ''PHR01'', ''Institutional''),
(''Family Care Medicare'', ''PHR01'', ''PHR01'', ''Professional''),
(''Family Care Specialists'', ''MPM40'', ''MPM40'', ''Institutional''),
(''Family Care Specialists'', ''MPM40'', ''MPM40'', ''Professional''),
(''Family Choice Medical Group'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Family Choice Medical Group'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Family Health & Housing'', ''41556'', ''41556'', ''Institutional''),
(''Family Health & Housing'', ''41556'', ''41556'', ''Professional''),
(''Family Health Alliance (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Family Health Alliance (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Family Health Network (IL)'', ''66012'', ''66012'', ''Institutional''),
(''Family Health Network (IL)'', ''66012'', ''66012'', ''Professional''),
(''Family Practice Associates'', ''14163'', ''14163'', ''Institutional''),
(''Family Practice Associates'', ''14163'', ''14163'', ''Professional''),
(''FAMSA, Inc.'', ''J1807'', ''J1807'', ''Institutional''),
(''FAMSA, Inc.'', ''J1807'', ''J1807'', ''Professional''),
(''Farm Bureau Mutual Insurance Company (MN Only)'', ''J1853'', ''J1853'', ''Institutional''),
(''Farm Bureau Mutual Insurance Company (MN Only)'', ''J1853'', ''J1853'', ''Professional''),
(''Farm Family'', ''14140'', ''14140'', ''Institutional''),
(''Farm Family'', ''14140'', ''14140'', ''Professional''),
(''Farmers \ Civic Property and Casualty Company'', ''J1687'', ''J1687'', ''Institutional''),
(''Farmers \ Civic Property and Casualty Company'', ''J1687'', ''J1687'', ''Professional''),
(''Farmers \ Exact Property and Casualty Company'', ''J1703'', ''J1703'', ''Institutional''),
(''Farmers \ Exact Property and Casualty Company'', ''J1703'', ''J1703'', ''Professional''),
(''Farmers \ Fire Insurance Exchange'', ''J1706'', ''J1706'', ''Institutional''),
(''Farmers \ Fire Insurance Exchange'', ''J1706'', ''J1706'', ''Professional''),
(''Farmers \ Mid-Century Insurance Company'', ''J1710'', ''J1710'', ''Institutional''),
(''Farmers \ Mid-Century Insurance Company'', ''J1710'', ''J1710'', ''Professional''),
(''Farmers \ Neighborhood Spirit Property and Casualty Company'', ''J1701'', ''J1701'', ''Institutional''),
(''Farmers \ Neighborhood Spirit Property and Casualty Company'', ''J1701'', ''J1701'', ''Professional''),
(''Farmers \ Truck Insurance Exchange'', ''J1713'', ''J1713'', ''Institutional''),
(''Farmers \ Truck Insurance Exchange'', ''J1713'', ''J1713'', ''Professional''),
(''Farmers Insurance (AUTO only)'', ''C1025'', ''C1025'', ''Institutional''),
(''Farmers Insurance (AUTO only)'', ''C1025'', ''C1025'', ''Professional''),
(''Farmers Insurance Commercial (Commercial Only)'', ''C1034'', ''C1034'', ''Institutional''),
(''Farmers Insurance Commercial (Commercial Only)'', ''C1034'', ''C1034'', ''Professional''),
(''Farmers Insurance Exchange (Commercial Only) (AUTO ONLY)'', ''C1034'', ''C1034'', ''Institutional''),
(''Farmers Insurance Exchange (Commercial Only) (AUTO ONLY)'', ''C1034'', ''C1034'', ''Professional''),
(''Farmers Insurance Exchange (WC ONLY)'', ''J1563'', ''J1563'', ''Institutional''),
(''Farmers Insurance Exchange (WC ONLY)'', ''J1563'', ''J1563'', ''Professional''),
(''Farmland Mutual Ins Co'', ''J1551'', ''J1551'', ''Institutional''),
(''Farmland Mutual Ins Co'', ''J1551'', ''J1551'', ''Professional''),
(''FCCI'', ''J1830'', ''J1830'', ''Institutional''),
(''FCCI'', ''J1830'', ''J1830'', ''Professional''),
(''FCE Benefit Administrators, Inc.'', ''33033'', ''33033'', ''Institutional''),
(''FCE Benefit Administrators, Inc.'', ''33033'', ''33033'', ''Professional''),
(''Federal Employees Health Benefit Plan (MHBP) (Coventry)'', ''25133'', ''25133'', ''Institutional''),
(''Federal Employees Health Benefit Plan (MHBP) (Coventry)'', ''25133'', ''25133'', ''Professional''),
(''Federated Benefits'', ''37300'', ''37300'', ''Institutional''),
(''Federated Benefits'', ''37300'', ''37300'', ''Professional''),
(''Federated Claims Service Corp (Macy''''s)'', ''J1297'', ''J1297'', ''Institutional''),
(''Federated Claims Service Corp (Macy''''s)'', ''J1297'', ''J1297'', ''Professional''),
(''Federated Department Stores, Inc'', ''J1297'', ''J1297'', ''Institutional''),
(''Federated Department Stores, Inc'', ''J1297'', ''J1297'', ''Professional''),
(''Federated Human Resource Services'', ''37300'', ''37300'', ''Institutional''),
(''Federated Human Resource Services'', ''37300'', ''37300'', ''Professional''),
(''Federated Linen & Uniform'', ''41556'', ''41556'', ''Institutional''),
(''Federated Linen & Uniform'', ''41556'', ''41556'', ''Professional''),
(''Federated Mutual Insurance Company'', ''13935'', ''13935'', ''Institutional''),
(''Federated Mutual Insurance Company'', ''13935'', ''13935'', ''Professional''),
(''Federated Rural Electric (TX)'', ''11118'', ''11118'', ''Institutional''),
(''Federated Rural Electric (TX)'', ''11118'', ''11118'', ''Professional''),
(''Federated Services Insurance Company'', ''28304'', ''28304'', ''Institutional''),
(''Federated Services Insurance Company'', ''28304'', ''28304'', ''Professional''),
(''FFVA Mutual Insurance'', ''J1909'', ''J1909'', ''Institutional''),
(''FFVA Mutual Insurance'', ''J1909'', ''J1909'', ''Professional''),
(''Fidelis Care New York'', ''11315'', ''11315'', ''Institutional''),
(''Fidelis Care New York'', ''11315'', ''11315'', ''Professional''),
(''Fireman''''s Fund Insurance Company'', ''21873'', ''21873'', ''Institutional''),
(''Fireman''''s Fund Insurance Company'', ''21873'', ''21873'', ''Professional''),
(''Fireman''''s Fund Insurance Company'', ''21873'', ''J2332'', ''Professional''),
(''Fireman''''s Fund Insurance Company'', ''J2332'', ''J2332'', ''Institutional''),
(''Firemen''''s Insurance Company'', ''J1274'', ''J1274'', ''Institutional''),
(''Firemen''''s Insurance Company'', ''J1274'', ''J1274'', ''Professional''),
(''First + Plus Puerto Rico'', ''L0210'', ''MCMMM'', ''Professional''),
(''First Agency'', ''88055'', ''88055'', ''Institutional''),
(''First Agency'', ''88055'', ''88055'', ''Professional''),
(''First Carolina Care'', ''56196'', ''56196'', ''Institutional''),
(''First Carolina Care'', ''56196'', ''56196'', ''Professional''),
(''First Choice Health Network'', ''91131'', ''91131'', ''Institutional''),
(''First Choice Health Network'', ''91131'', ''91131'', ''Professional''),
(''First Choice Medical Group'', ''FCMG1'', ''FCMG1'', ''Institutional''),
(''First Choice Medical Group'', ''FCMG1'', ''FCMG1'', ''Professional''),
(''First Choice of Midwest (PPO)'', ''75138'', ''75138'', ''Institutional''),
(''First Choice of Midwest (PPO)'', ''75138'', ''75138'', ''Professional''),
(''First Choice VIP Care Plus (Medicare/Medicaid) Select Health of South Carolina'', ''77009'', ''77009'', ''Institutional''),
(''First Choice VIP Care Plus (Medicare/Medicaid) Select Health of South Carolina'', ''77009'', ''77009'', ''Professional''),
(''First Keystone Risk Retention Group'', ''C1084'', ''C1084'', ''Institutional''),
(''First Keystone Risk Retention Group'', ''C1084'', ''C1084'', ''Professional''),
(''First Managed Care Option, Inc.'', ''40270'', ''J3839'', ''Professional''),
(''First Managed Care Option, Inc.'', ''J3839'', ''J3839'', ''Institutional''),
(''First Medical (International Medical Card)'', ''37624'', ''37624'', ''Institutional''),
(''First Medical (International Medical Card)'', ''37624'', ''37624'', ''Professional''),
(''First Medical (International Medical Card) - GHP Reforma'', ''66053'', ''66053'', ''Professional''),
(''First Medical (International Medical Card) - GHP Reforma'', ''66064'', ''66053'', ''Institutional''),
(''First Responder Joint Insurance Fund'', ''LU567'', ''J3935'', ''Institutional''),
(''First Responder Joint Insurance Fund'', ''LU567'', ''J3935'', ''Professional''),
(''First Seniority Freedom'', ''87726'', ''87726'', ''Professional''),
(''FirstCare'', ''94999'', ''94999'', ''Institutional''),
(''FirstCare'', ''94999'', ''94999'', ''Professional''),
(''FirstCare Star Medicaid'', ''94998'', ''94998'', ''Institutional''),
(''FirstCare Star Medicaid'', ''94998'', ''94998'', ''Professional''),
(''Firstcomp'', ''J1011'', ''J1011'', ''Institutional''),
(''Firstcomp'', ''J1011'', ''J1011'', ''Professional''),
(''FKI Industries, Inc.'', ''J1047'', ''J1047'', ''Institutional''),
(''FKI Industries, Inc.'', ''J1047'', ''J1047'', ''Professional''),
(''Florida Community Care'', ''FLCCR'', ''FLCCR'', ''Institutional''),
(''Florida Community Care'', ''FLCCR'', ''FLCCR'', ''Professional''),
(''Florida Fruit and Vegetable Association'', ''J1910'', ''J1910'', ''Institutional''),
(''Florida Fruit and Vegetable Association'', ''J1910'', ''J1910'', ''Professional''),
(''Florida Health Care Plans'', ''59322'', ''59322'', ''Institutional''),
(''Florida Health Care Plans'', ''59322'', ''59322'', ''Professional''),
(''Florida Hospital Waterman - Coresource'', ''48116'', ''48116'', ''Institutional''),
(''Florida Hospital Waterman - Coresource'', ''48116'', ''48116'', ''Professional''),
(''Florida League of Cities'', ''59698'', ''59698'', ''Institutional''),
(''Florida League of Cities'', ''59698'', ''59698'', ''Professional''),
(''Florists Insurance Company'', ''C1033'', ''C1033'', ''Institutional''),
(''Florists Insurance Company'', ''C1033'', ''C1033'', ''Professional''),
(''Ford Meter Box Company Inc'', ''37305'', ''37305'', ''Institutional''),
(''Ford Meter Box Company Inc'', ''37305'', ''37305'', ''Professional''),
(''Foremost'', ''11185'', ''11185'', ''Institutional''),
(''Foremost'', ''11185'', ''11185'', ''Professional''),
(''Foremost - Automobile medical claims only'', ''11185'', ''11185'', ''Institutional''),
(''Foremost - Automobile medical claims only'', ''11185'', ''11185'', ''Professional''),
(''Forest County Potawatomi Insurance Department'', ''25059'', ''25059'', ''Institutional''),
(''Forest County Potawatomi Insurance Department'', ''25059'', ''25059'', ''Professional''),
(''Forge Industrial Staffing'', ''J1529'', ''J1529'', ''Institutional''),
(''Forge Industrial Staffing'', ''J1529'', ''J1529'', ''Professional''),
(''Formax, Inc.'', ''87066'', ''87066'', ''Institutional''),
(''Formax, Inc.'', ''87066'', ''87066'', ''Professional''),
(''Foundation Benefit Administrators'', ''BOONG'', ''BOONG'', ''Institutional''),
(''Foundation Benefit Administrators'', ''BOONG'', ''BOONG'', ''Professional''),
(''Foundation for Medical Care of Tulare & Kings County'', ''TKFMC'', ''TKFMC'', ''Professional''),
(''Foundation Health HMO'', ''FH001'', ''FH001'', ''Professional''),
(''Fountain Valley Premier IPA'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Fountain Valley Premier IPA'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Fox Valley Medicine Site 199'', ''FVMCH'', ''FVMCH'', ''Professional''),
(''Fox-Everett, Inc.'', ''64069'', ''64069'', ''Institutional''),
(''Fox-Everett, Inc.'', ''64069'', ''64069'', ''Professional''),
(''Franciscan Alliance'', ''J1883'', ''J1883'', ''Institutional''),
(''Franciscan Alliance'', ''J1883'', ''J1883'', ''Professional''),
(''Franco Construction'', ''41556'', ''41556'', ''Institutional''),
(''Franco Construction'', ''41556'', ''41556'', ''Professional''),
(''Frankenmuth Mutual'', ''J1440'', ''J1440'', ''Institutional''),
(''Frankenmuth Mutual'', ''J1440'', ''J1440'', ''Professional''),
(''Freedom First'', ''FREEF1'', ''PAPER'', ''Institutional''),
(''Freedom First'', ''FREEF1'', ''PAPER'', ''Professional''),
(''Freedom Health Plan'', ''41212'', ''41212'', ''Institutional''),
(''Freedom Health Plan'', ''41212'', ''41212'', ''Professional''),
(''Freedom Life Insurance Company of America'', ''62324'', ''62324'', ''Professional''),
(''Freedom Network'', ''31478'', ''31478'', ''Institutional''),
(''Freedom Network'', ''31478'', ''31478'', ''Professional''),
(''Freedom Network Select'', ''31478'', ''31478'', ''Institutional''),
(''Freedom Network Select'', ''31478'', ''31478'', ''Professional''),
(''FreedomCare'', ''FDMCR'', ''FDMCR'', ''Institutional''),
(''FreedomCare'', ''FDMCR'', ''FDMCR'', ''Professional''),
(''Fresenius Health Partners'', ''43197'', ''43197'', ''Institutional''),
(''Fresenius Health Partners'', ''43197'', ''43197'', ''Professional''),
(''Fresno County Office of Education'', ''41556'', ''41556'', ''Institutional''),
(''Fresno County Office of Education'', ''41556'', ''41556'', ''Professional''),
(''Fresno County Self Insurance Group'', ''41556'', ''41556'', ''Institutional''),
(''Fresno County Self Insurance Group'', ''41556'', ''41556'', ''Professional''),
(''Fresno PACE'', ''99660'', ''99660'', ''Institutional''),
(''Fresno PACE'', ''99660'', ''99660'', ''Professional''),
(''Friant Water Users'', ''TKFMC'', ''TKFMC'', ''Professional''),
(''Friday Health Plans of Colorado'', ''H0657'', ''H0657'', ''Institutional''),
(''Friday Health Plans of Colorado'', ''H0657'', ''H0657'', ''Professional''),
(''Fringe Benefits Coordinators'', ''59204'', ''59204'', ''Institutional''),
(''Fringe Benefits Coordinators'', ''59204'', ''59204'', ''Professional''),
(''FrontPath Health Coalition'', ''34171'', ''34171'', ''Institutional''),
(''FrontPath Health Coalition'', ''34171'', ''34171'', ''Professional''),
(''Fullerton Union High School District (CA)'', ''J1633'', ''J1633'', ''Institutional''),
(''Fullerton Union High School District (CA)'', ''J1633'', ''J1633'', ''Professional''),
(''Future Care Medical Associates IPA'', ''POP02'', ''POP02'', ''Professional''),
(''Futurecomp'', ''J3353'', ''J3353'', ''Professional''),
(''Futurecomp'', ''LT881'', ''J3353'', ''Institutional''),
(''GAB Robbins, Inc.'', ''TP117'', ''TP117'', ''Institutional''),
(''GAB Robbins, Inc.'', ''TP117'', ''TP117'', ''Professional''),
(''GAB Robins (For Van Tuyl Companies ONLY)'', ''TP117'', ''TP117'', ''Institutional''),
(''GAB Robins (For Van Tuyl Companies ONLY)'', ''TP117'', ''TP117'', ''Professional''),
(''Gainsco'', ''C1085'', ''C1085'', ''Institutional''),
(''Gainsco'', ''C1085'', ''C1085'', ''Professional''),
(''Gallagher Bassett'', ''TP057'', ''TP057'', ''Institutional''),
(''Gallagher Bassett'', ''TP057'', ''TP057'', ''Professional''),
(''Galveston County Indigent Health Care'', ''30005'', ''30005'', ''Institutional''),
(''Galveston County Indigent Health Care'', ''30005'', ''30005'', ''Professional''),
(''Garden Grove Unified School District'', ''J1519'', ''J1519'', ''Institutional''),
(''Garden Grove Unified School District'', ''J1519'', ''J1519'', ''Professional''),
(''Garden Regional Hospital & Med Center, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Garden Regional Hospital & Med Center, Inc.'', ''41556'', ''41556'', ''Professional''),
(''Gategourmet #836'', ''J1302'', ''J1302'', ''Institutional''),
(''Gategourmet #836'', ''J1302'', ''J1302'', ''Professional''),
(''Gates Corp DBA Gates Rubber Co'', ''J1066'', ''J1066'', ''Institutional''),
(''Gates Corp DBA Gates Rubber Co'', ''J1066'', ''J1066'', ''Professional''),
(''Gates O''''Doherty'', ''41556'', ''41556'', ''Institutional''),
(''Gates O''''Doherty'', ''41556'', ''41556'', ''Professional''),
(''Gates O''''Doherty G&G'', ''41556'', ''41556'', ''Institutional''),
(''Gates O''''Doherty G&G'', ''41556'', ''41556'', ''Professional''),
(''Gateway Health Plan - Medicare Assured'', ''60550'', ''60550'', ''Institutional''),
(''Gateway Health Plan - Medicare Assured'', ''60550'', ''60550'', ''Professional''),
(''Gateway Health Plan Medicaid Pennsylvania'', ''25169'', ''25169'', ''Institutional''),
(''Gateway Health Plan Medicaid Pennsylvania'', ''25169'', ''25169'', ''Professional''),
(''Gateway Health Plan Ohio - Medicare Assured'', ''91741'', ''91741'', ''Institutional''),
(''Gateway Health Plan Ohio - Medicare Assured'', ''91741'', ''91741'', ''Professional''),
(''Gateway Health Plan Vision - Highmark'', ''54771'', ''54771'', ''Professional''),
(''Gateway IPA (Pinnacle Health Resources) (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Gateway IPA (Pinnacle Health Resources) (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Professional''),
(''Gateway Trans., Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Gateway Trans., Inc.'', ''41556'', ''41556'', ''Professional''),
(''GE Auto'', ''J1557'', ''J1557'', ''Institutional''),
(''GE Auto'', ''J1557'', ''J1557'', ''Professional''),
(''GEHA (Government Employees Hospital Association)'', ''44054'', ''44054'', ''Institutional''),
(''GEHA (Government Employees Hospital Association)'', ''44054'', ''44054'', ''Professional''),
(''GEHA (Government Employees Hospital Association) Federal'', ''57254'', ''57254'', ''Institutional''),
(''GEHA (Government Employees Hospital Association) Federal'', ''57254'', ''57254'', ''Professional''),
(''GEHA - ASA (Aetna Signature Administrators)'', ''06603'', ''06603'', ''Institutional''),
(''GEHA - ASA (Aetna Signature Administrators)'', ''06603'', ''06603'', ''Professional''),
(''GEHA Group Health Nevada Medicaid'', ''GEHA9'', ''GEHA9'', ''Institutional''),
(''GEHA Group Health Nevada Medicaid'', ''GEHA9'', ''GEHA9'', ''Professional''),
(''Geico'', ''J1747'', ''J1747'', ''Institutional''),
(''Geico'', ''J1747'', ''J1747'', ''Professional''),
(''Geisinger Health Plan'', ''75273'', ''75273'', ''Institutional''),
(''Geisinger Health Plan'', ''75273'', ''75273'', ''Professional''),
(''Gemcare (Managed Care Systems)'', ''MCS03'', ''MCS03'', ''Professional''),
(''Gemcare Health Plan'', ''20376'', ''20376'', ''Institutional''),
(''Gemcare Health Plan'', ''20376'', ''20376'', ''Professional''),
(''GemCare Health Plan, Kern County EPO (Managed Care Systems)'', ''MCS03'', ''MCS03'', ''Institutional''),
(''GemCare Health Plan, Kern County EPO (Managed Care Systems)'', ''MCS03'', ''MCS03'', ''Professional''),
(''Gemcare IPA'', ''27133'', ''27133'', ''Institutional''),
(''Gemcare IPA'', ''27133'', ''27133'', ''Professional''),
(''General Parts International'', ''J1678'', ''J1678'', ''Institutional''),
(''General Parts International'', ''J1678'', ''J1678'', ''Professional''),
(''Generations Healthcare'', ''46050'', ''46050'', ''Institutional''),
(''Generations Healthcare'', ''46050'', ''46050'', ''Professional''),
(''Genesis Construction'', ''41556'', ''41556'', ''Institutional''),
(''Genesis Construction'', ''41556'', ''41556'', ''Professional''),
(''Genex Care for Ohio'', ''J1895'', ''J1895'', ''Institutional''),
(''Genex Care for Ohio'', ''J1895'', ''J1895'', ''Professional''),
(''GEO (Bunch CareSolutions)'', ''J1461'', ''J1461'', ''Institutional''),
(''GEO (Bunch CareSolutions)'', ''J1461'', ''J1461'', ''Professional''),
(''Georgia Health Advantage'', ''31140'', ''31140'', ''Professional''),
(''Georgia Health Advantage'', ''A2327'', ''31140'', ''Institutional''),
(''Gettysburg Health'', ''23274'', ''23274'', ''Institutional''),
(''Gettysburg Health'', ''23274'', ''23274'', ''Professional''),
(''GHI - Group Health Inc'', ''25531'', ''25531'', ''Institutional''),
(''GHI - Group Health Inc'', ''25531'', ''25531'', ''Professional''),
(''GHI - Medicare Private Fee for Service'', ''55247'', ''55247'', ''Institutional''),
(''GHI - Medicare Private Fee for Service'', ''55247'', ''55247'', ''Professional''),
(''GI Innovative Management'', ''58204'', ''58204'', ''Professional''),
(''GIC Indemnity Plan'', ''80314'', ''80314'', ''Institutional''),
(''GIC Indemnity Plan'', ''80314'', ''80314'', ''Professional''),
(''Gillette Childrens Specialty Healthcare'', ''J1927'', ''J1927'', ''Institutional''),
(''Gillette Childrens Specialty Healthcare'', ''J1927'', ''J1927'', ''Professional''),
(''Gilsbar, Inc.'', ''07205'', ''07205'', ''Institutional''),
(''Gilsbar, Inc.'', ''07205'', ''07205'', ''Professional''),
(''Glendale Adventist Medical Center'', ''NMM01'', ''NMM01'', ''Professional''),
(''Glendale Elementary School District #40'', ''41556'', ''41556'', ''Institutional''),
(''Glendale Elementary School District #40'', ''41556'', ''41556'', ''Professional''),
(''Glendale Physicians Alliance'', ''AMM02'', ''AMM02'', ''Institutional''),
(''Glendale Physicians Alliance'', ''AMM02'', ''AMM02'', ''Professional''),
(''Glendale Physicians Alliance (Regal)'', ''REGAL'', ''REGAL'', ''Institutional''),
(''Glendale Physicians Alliance (Regal)'', ''REGAL'', ''REGAL'', ''Professional''),
(''Global Care - Boulder Administration'', ''07689'', ''07689'', ''Institutional''),
(''Global Care - Boulder Administration'', ''07689'', ''07689'', ''Professional''),
(''Global Care Medical Group IPA (MedPOINT) California'', ''MPM05'', ''MPM05'', ''Professional''),
(''Global Excel Management'', ''GEM01'', ''GEM01'', ''Institutional''),
(''Global Excel Management'', ''GEM01'', ''GEM01'', ''Professional''),
(''Global Health'', ''GHOKC'', ''GHOKC'', ''Institutional''),
(''Global Health'', ''GHOKC'', ''GHOKC'', ''Professional''),
(''Global One Ventures'', ''GLOBAL1'', ''GLOB1'', ''Institutional''),
(''Global One Ventures'', ''GLOBAL1'', ''GLOB1'', ''Professional''),
(''GMAC Insurance Company Online, Inc.'', ''C1028'', ''C1028'', ''Institutional''),
(''GMAC Insurance Company Online, Inc.'', ''C1028'', ''C1028'', ''Professional''),
(''GMAC Insurance Management Corporation'', ''C1028'', ''C1028'', ''Institutional''),
(''GMAC Insurance Management Corporation'', ''C1028'', ''C1028'', ''Professional''),
(''GMR Healthcare'', ''85664'', ''85664'', ''Institutional''),
(''GMR Healthcare'', ''85664'', ''85664'', ''Professional''),
(''GMS, Inc'', ''47083'', ''47083'', ''Institutional''),
(''GMS, Inc'', ''47083'', ''47083'', ''Professional''),
(''Gold Coast Health Plan'', ''77160'', ''77160'', ''Institutional''),
(''Gold Coast Health Plan'', ''77160'', ''77160'', ''Professional''),
(''Golden Corral Corporation'', ''J1067'', ''J1067'', ''Institutional''),
(''Golden Corral Corporation'', ''J1067'', ''J1067'', ''Professional''),
(''Golden Eagle'', ''J1430'', ''J1430'', ''Institutional''),
(''Golden Eagle'', ''J1430'', ''J1430'', ''Professional''),
(''Golden Physicians Medical Group'', ''PDT01'', ''PDT01'', ''Institutional''),
(''Golden Physicians Medical Group'', ''PDT01'', ''PDT01'', ''Professional''),
(''Golden State Physicians Medical Group'', ''MBADM'', ''MBADM'', ''Professional''),
(''Golden State Supply'', ''J1306'', ''J1306'', ''Institutional''),
(''Golden State Supply'', ''J1306'', ''J1306'', ''Professional''),
(''Golden Triangle Physician Alliance (GTPA) Selectcare TX'', ''14163'', ''14163'', ''Institutional''),
(''Golden Triangle Physician Alliance (GTPA) Selectcare TX'', ''14163'', ''14163'', ''Professional''),
(''Good Samaritan Hospital'', ''J1647'', ''J1647'', ''Institutional''),
(''Good Samaritan Hospital'', ''J1647'', ''J1647'', ''Professional''),
(''Good Samaritan Medical Practice Assn'', ''GSMPA'', ''GSMPA'', ''Institutional''),
(''Good Samaritan Medical Practice Assn'', ''GSMPA'', ''GSMPA'', ''Professional''),
(''Good Shepherd Hospice, Inc'', ''76923'', ''76923'', ''Institutional''),
(''Good Shepherd Hospice, Inc'', ''76923'', ''76923'', ''Professional''),
(''Good2go Insurance (aka Personal Service Insurance)'', ''LU547'', ''C1094'', ''Institutional''),
(''Good2go Insurance (aka Personal Service Insurance)'', ''LU547'', ''C1094'', ''Professional''),
(''Goodrich (Bunch CareSolutions)'', ''J1462'', ''J1462'', ''Institutional''),
(''Goodrich (Bunch CareSolutions)'', ''J1462'', ''J1462'', ''Professional''),
(''Goodwill Industries'', ''J1621'', ''J1621'', ''Institutional''),
(''Goodwill Industries'', ''J1621'', ''J1621'', ''Professional''),
(''Gordmans (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Gordmans (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Grand River Insurance (AUTO Only)'', ''C1038'', ''C1038'', ''Institutional''),
(''Grand River Insurance (AUTO Only)'', ''C1038'', ''C1038'', ''Professional''),
(''Grand River Insurance (WC Only)'', ''J1566'', ''J1566'', ''Institutional''),
(''Grand River Insurance (WC Only)'', ''J1566'', ''J1566'', ''Professional''),
(''Grand Valley Health Plan'', ''95453'', ''95453'', ''Institutional''),
(''Grand Valley Health Plan'', ''95453'', ''95453'', ''Professional''),
(''Grange Mutual Casualty Company'', ''10322'', ''10322'', ''Institutional''),
(''Grange Mutual Casualty Company'', ''10322'', ''10322'', ''Professional''),
(''Grange WC'', ''14060'', ''14060'', ''Institutional''),
(''Grange WC'', ''14060'', ''14060'', ''Professional''),
(''Granite State Health Plan - New Hampshire'', ''68069'', ''68069'', ''Institutional''),
(''Granite State Health Plan - New Hampshire'', ''68069'', ''68069'', ''Professional''),
(''Grant Physicians Practice Association'', ''37234'', ''37234'', ''Institutional''),
(''Grant Physicians Practice Association'', ''37234'', ''37234'', ''Professional''),
(''Graphic Arts Mutual'', ''25984'', ''25984'', ''Institutional''),
(''Graphic Arts Mutual'', ''25984'', ''25984'', ''Professional''),
(''Great American Alliance Ins Co.'', ''26832'', ''26832'', ''Institutional''),
(''Great American Alliance Ins Co.'', ''26832'', ''26832'', ''Professional''),
(''Great American Assurance Co.'', ''26344'', ''26344'', ''Institutional''),
(''Great American Assurance Co.'', ''26344'', ''26344'', ''Professional''),
(''Great American Ins. Co.'', ''16691'', ''16691'', ''Institutional''),
(''Great American Ins. Co.'', ''16691'', ''16691'', ''Professional''),
(''Great American Ins. Co. of N.Y.'', ''22136'', ''22136'', ''Institutional''),
(''Great American Ins. Co. of N.Y.'', ''22136'', ''22136'', ''Professional''),
(''Great American Life Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Institutional''),
(''Great American Life Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Professional''),
(''Great Divide Insurance'', ''25224'', ''25224'', ''Institutional''),
(''Great Divide Insurance'', ''25224'', ''25224'', ''Professional''),
(''Great Lakes Health Plan'', ''95467'', ''95467'', ''Institutional''),
(''Great Lakes Health Plan'', ''95467'', ''95467'', ''Professional''),
(''Great Lakes PACE'', ''39640'', ''39640'', ''Institutional''),
(''Great Lakes PACE'', ''39640'', ''39640'', ''Professional''),
(''Great Plains Medicare Advantage Nebraska'', ''GPNE1'', ''GPNE1'', ''Institutional''),
(''Great Plains Medicare Advantage Nebraska'', ''GPNE1'', ''GPNE1'', ''Professional''),
(''Great Plains Medicare Advantage North Dakota'', ''GPND1'', ''GPND1'', ''Institutional''),
(''Great Plains Medicare Advantage North Dakota'', ''GPND1'', ''GPND1'', ''Professional''),
(''Great Plains Medicare Advantage South Dakota'', ''GPSD1'', ''GPSD1'', ''Institutional''),
(''Great Plains Medicare Advantage South Dakota'', ''GPSD1'', ''GPSD1'', ''Professional''),
(''Great West Casualty'', ''J1820'', ''J1820'', ''Institutional''),
(''Great West Casualty'', ''J1820'', ''J1820'', ''Professional''),
(''Great West Healthcare'', ''80705'', ''80705'', ''Professional''),
(''Greater Covina Medical Group'', ''99284'', ''GCMG1'', ''Institutional''),
(''Greater Covina Medical Group'', ''99284'', ''GCMG1'', ''Professional''),
(''Greater Dayton Senior Care Advantage'', ''AGL02'', ''AGL02'', ''Institutional''),
(''Greater Dayton Senior Care Advantage'', ''AGL02'', ''AGL02'', ''Professional''),
(''Greater LA Healthcare (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Greater LA Healthcare (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Greater Newport Physicians'', ''GNPMG'', ''GNPMG'', ''Professional''),
(''Greater Orange County Medical Group (CA)'', ''NMM01'', ''NMM01'', ''Professional''),
(''Greater San Gabriel Valley Physicians (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Greater San Gabriel Valley Physicians (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Greater San Gabriel Valley Physicians IPA'', ''NMM01'', ''NMM01'', ''Professional''),
(''Greater TriCities IPA'', ''PDT01'', ''PDT01'', ''Institutional''),
(''Greater TriCities IPA'', ''PDT01'', ''PDT01'', ''Professional''),
(''Green Diamond WA'', ''J1642'', ''J1642'', ''Institutional''),
(''Green Diamond WA'', ''J1642'', ''J1642'', ''Professional''),
(''Greene Rad Maloney'', ''41556'', ''41556'', ''Institutional''),
(''Greene Rad Maloney'', ''41556'', ''41556'', ''Professional''),
(''Greer Constructon CO'', ''41556'', ''41556'', ''Institutional''),
(''Greer Constructon CO'', ''41556'', ''41556'', ''Professional''),
(''Greif Brothers Corporation'', ''41556'', ''41556'', ''Institutional''),
(''Greif Brothers Corporation'', ''41556'', ''41556'', ''Professional''),
(''Greve Clifford Wengel & Paras'', ''41556'', ''41556'', ''Institutional''),
(''Greve Clifford Wengel & Paras'', ''41556'', ''41556'', ''Professional''),
(''Grimmway Enterprises, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Grimmway Enterprises, Inc.'', ''41556'', ''41556'', ''Professional''),
(''Grinnell Reinsurance Company'', ''J1571'', ''J1571'', ''Institutional''),
(''Grinnell Reinsurance Company'', ''J1571'', ''J1571'', ''Professional''),
(''Grinnell Select'', ''J1541'', ''J1541'', ''Institutional''),
(''Grinnell Select'', ''J1541'', ''J1541'', ''Professional''),
(''Group & Pension Administrators'', ''48143'', ''48143'', ''Institutional''),
(''Group & Pension Administrators'', ''48143'', ''48143'', ''Professional''),
(''Group Administrators Ltd.'', ''36338'', ''36338'', ''Institutional''),
(''Group Administrators Ltd.'', ''36338'', ''36338'', ''Professional''),
(''Group Benefit Services, Inc'', ''CB951'', ''CB951'', ''Institutional''),
(''Group Benefit Services, Inc'', ''CB951'', ''CB951'', ''Professional''),
(''Group Health Coop South Central (Wisconsin-Claims)'', ''39167'', ''39167'', ''Institutional''),
(''Group Health Coop South Central (Wisconsin-Claims)'', ''39167'', ''39167'', ''Professional''),
(''Group Health Coop South Central (Wisconsin-Encounters)'', ''39168'', ''39168'', ''Institutional''),
(''Group Health Coop South Central (Wisconsin-Encounters)'', ''39168'', ''39168'', ''Professional''),
(''Group Health Cooperative of Eau Claire'', ''95192'', ''95192'', ''Institutional''),
(''Group Health Cooperative of Eau Claire'', ''95192'', ''95192'', ''Professional''),
(''Group Health Inc. - New York (GHI) - Emblem Health'', ''13551'', ''13551'', ''Institutional''),
(''Group Health Inc. - New York (GHI) - Emblem Health'', ''13551'', ''13551'', ''Professional''),
(''Group Insurance Service Center, Inc.'', ''37276'', ''37276'', ''Institutional''),
(''Group Insurance Service Center, Inc.'', ''37276'', ''37276'', ''Professional''),
(''Group Management Services, Inc.'', ''OBA16'', ''OBA16'', ''Institutional''),
(''Group Management Services, Inc.'', ''OBA16'', ''OBA16'', ''Professional''),
(''Group Marketing Services, Inc.'', ''66701'', ''66701'', ''Institutional''),
(''Group Marketing Services, Inc.'', ''66701'', ''66701'', ''Professional''),
(''Group Resources'', ''42049'', ''42049'', ''Institutional''),
(''Group Resources'', ''42049'', ''42049'', ''Professional''),
(''Grundfos Manufacturing Corporation'', ''41556'', ''41556'', ''Institutional''),
(''Grundfos Manufacturing Corporation'', ''41556'', ''41556'', ''Professional''),
(''GS Metals'', ''41556'', ''41556'', ''Institutional''),
(''GS Metals'', ''41556'', ''41556'', ''Professional''),
(''Gse Lining Technology, Inc.'', ''J1068'', ''J1068'', ''Institutional''),
(''Gse Lining Technology, Inc.'', ''J1068'', ''J1068'', ''Professional''),
(''Guard'', ''J1453'', ''J1453'', ''Institutional''),
(''Guard'', ''J1453'', ''J1453'', ''Professional''),
(''Guardian Life Insurance Company of America'', ''64246'', ''64246'', ''Institutional''),
(''Guardian Life Insurance Company of America'', ''64246'', ''64246'', ''Professional''),
(''GuideOne Elite Insurance'', ''J1590'', ''J1590'', ''Institutional''),
(''GuideOne Elite Insurance'', ''J1590'', ''J1590'', ''Professional''),
(''GuideOne Mutual Insurance'', ''J1574'', ''J1574'', ''Institutional''),
(''GuideOne Mutual Insurance'', ''J1574'', ''J1574'', ''Professional''),
(''Gulfstream--General Dynamics'', ''CB624'', ''CB624'', ''Institutional''),
(''Gulfstream--General Dynamics'', ''CB624'', ''CB624'', ''Professional''),
(''H & R Block'', ''J1672'', ''J1672'', ''Institutional''),
(''H & R Block'', ''J1672'', ''J1672'', ''Professional''),
(''H.E.R.E.I.U Welfare Pension Funds'', ''37114'', ''37114'', ''Institutional''),
(''H.E.R.E.I.U Welfare Pension Funds'', ''37114'', ''37114'', ''Professional''),
(''HAA Preferred Partners'', ''65101'', ''65101'', ''Institutional''),
(''HAA Preferred Partners'', ''65101'', ''65101'', ''Professional''),
(''Halcyon Behavioral Health'', ''HALCY'', ''HALCY'', ''Institutional''),
(''Halcyon Behavioral Health'', ''HALCY'', ''HALCY'', ''Professional''),
(''Hamaspik Choice'', ''47738'', ''47738'', ''Institutional''),
(''Hamaspik Choice'', ''47738'', ''47738'', ''Professional''),
(''Hamilton Mutual - AUTO'', ''C1029'', ''C1029'', ''Institutional''),
(''Hamilton Mutual - AUTO'', ''C1029'', ''C1029'', ''Professional''),
(''Hamilton Mutual - LIAB'', ''J1433'', ''J1433'', ''Institutional''),
(''Hamilton Mutual - LIAB'', ''J1433'', ''J1433'', ''Professional''),
(''Hamilton Mutual - WC'', ''21415'', ''21415'', ''Institutional''),
(''Hamilton Mutual - WC'', ''21415'', ''21415'', ''Professional''),
(''Hannaford (Bunch CareSolutions)'', ''J1463'', ''J1463'', ''Institutional''),
(''Hannaford (Bunch CareSolutions)'', ''J1463'', ''J1463'', ''Professional''),
(''Hanover Insurance Company'', ''J1693'', ''J1693'', ''Institutional''),
(''Hanover Insurance Company'', ''J1693'', ''J1693'', ''Professional''),
(''Hanover Lloyd''''s Insurance Company'', ''J1588'', ''J1588'', ''Institutional''),
(''Hanover Lloyd''''s Insurance Company'', ''J1588'', ''J1588'', ''Professional''),
(''HAP/AHL/Curanet (Health Alliance Plan of MI)'', ''38224'', ''38224'', ''Institutional''),
(''HAP/AHL/Curanet (Health Alliance Plan of MI)'', ''38224'', ''38224'', ''Professional''),
(''Harleysville Insurance Company'', ''J1595'', ''J1595'', ''Institutional''),
(''Harleysville Insurance Company'', ''J1595'', ''J1595'', ''Professional''),
(''Harmony Health Plan of Illinois'', ''36406'', ''36406'', ''Institutional''),
(''Harmony Health Plan of Illinois'', ''36406'', ''36406'', ''Professional''),
(''Harmony Health Plan of Indiana'', ''36405'', ''36405'', ''Institutional''),
(''Harmony Health Plan of Indiana'', ''36405'', ''36405'', ''Professional''),
(''Harpeth IPA - Amerivantage (SRRIPA)'', ''75126'', ''75126'', ''Professional''),
(''Harrington Health - Kansas (Formerly known as Fiserv Health)'', ''62061'', ''62061'', ''Institutional''),
(''Harrington Health - Kansas (Formerly known as Fiserv Health)'', ''62061'', ''62061'', ''Professional''),
(''Harrington Health Non-EPO'', ''59143'', ''59143'', ''Institutional''),
(''Harrington Health Non-EPO'', ''59143'', ''59143'', ''Professional''),
(''Hartford Accident and Indemnity Company'', ''C1046'', ''C1046'', ''Institutional''),
(''Hartford Accident and Indemnity Company'', ''C1046'', ''C1046'', ''Professional''),
(''Hartford Casualty Insurance Company'', ''C1041'', ''C1041'', ''Institutional''),
(''Hartford Casualty Insurance Company'', ''C1041'', ''C1041'', ''Professional''),
(''Hartford Dealership Advantage Program - WC'', ''41556'', ''41556'', ''Institutional''),
(''Hartford Dealership Advantage Program - WC'', ''41556'', ''41556'', ''Professional''),
(''Hartford Fire Insurance Company'', ''C1040'', ''C1040'', ''Institutional''),
(''Hartford Fire Insurance Company'', ''C1040'', ''C1040'', ''Professional''),
(''Hartford Ins Co Of Illinois'', ''C1040'', ''C1040'', ''Institutional''),
(''Hartford Ins Co Of Illinois'', ''C1040'', ''C1040'', ''Professional''),
(''Hartford Ins Co of the Southeast'', ''C1040'', ''C1040'', ''Institutional''),
(''Hartford Ins Co of the Southeast'', ''C1040'', ''C1040'', ''Professional''),
(''Hartford Insurance Company of the Midwest'', ''C1043'', ''C1043'', ''Institutional''),
(''Hartford Insurance Company of the Midwest'', ''C1043'', ''C1043'', ''Professional''),
(''Hartford Life and Accident Insurance Company'', ''C1044'', ''C1044'', ''Institutional''),
(''Hartford Life and Accident Insurance Company'', ''C1044'', ''C1044'', ''Professional''),
(''Hartford Life and Annuity Insurance Company'', ''C1047'', ''C1047'', ''Institutional''),
(''Hartford Life and Annuity Insurance Company'', ''C1047'', ''C1047'', ''Professional''),
(''Hartford Life Insurance Company'', ''C1045'', ''C1045'', ''Institutional''),
(''Hartford Life Insurance Company'', ''C1045'', ''C1045'', ''Professional''),
(''Hartford Underwriters Insurance Company'', ''C1042'', ''C1042'', ''Institutional''),
(''Hartford Underwriters Insurance Company'', ''C1042'', ''C1042'', ''Professional''),
(''Harvard Pilgrim Health Care'', ''04271'', ''04271'', ''Institutional''),
(''Harvard Pilgrim Health Care'', ''04271'', ''04271'', ''Professional''),
(''Harvard Pilgrim Stride (HMO)'', ''04245'', ''04245'', ''Institutional''),
(''Harvard Pilgrim Stride (HMO)'', ''04245'', ''04245'', ''Professional''),
(''Hastings College of the Law'', ''41556'', ''41556'', ''Institutional''),
(''Hastings College of the Law'', ''41556'', ''41556'', ''Professional''),
(''Hawaii Management Alliance Assoc (HMAA)'', ''48330'', ''48330'', ''Institutional''),
(''Hawaii Management Alliance Assoc (HMAA)'', ''48330'', ''48330'', ''Professional''),
(''Hawkeye'', ''J1426'', ''J1426'', ''Institutional''),
(''Hawkeye'', ''J1426'', ''J1426'', ''Professional''),
(''Hayhoe Construction'', ''41556'', ''41556'', ''Institutional''),
(''Hayhoe Construction'', ''41556'', ''41556'', ''Professional''),
(''HCA-Hosptial Corporation of America'', ''J1450'', ''J1450'', ''Institutional''),
(''HCA-Hosptial Corporation of America'', ''J1450'', ''J1450'', ''Professional''),
(''HCC Life Insurance'', ''HCCMI'', ''HCCMI'', ''Professional''),
(''HCH Administration - Illinois'', ''37111'', ''37111'', ''Institutional''),
(''HCH Administration - Illinois'', ''37111'', ''37111'', ''Professional''),
(''HCHA Albuquerque - Self Funded'', ''37329'', ''37329'', ''Institutional''),
(''HCHA Albuquerque - Self Funded'', ''37329'', ''37329'', ''Professional''),
(''HCS - Health Claims Service - Boise, Idaho'', ''82018'', ''82018'', ''Institutional''),
(''HCS - Health Claims Service - Boise, Idaho'', ''82018'', ''82018'', ''Professional''),
(''HDM Benefit Solutions'', ''HDMCO'', ''HDMCO'', ''Institutional''),
(''HDM Benefit Solutions'', ''HDMCO'', ''HDMCO'', ''Professional''),
(''Health Alliance Medical Plans, Inc.'', ''77950'', ''77950'', ''Institutional''),
(''Health Alliance Medical Plans, Inc.'', ''77950'', ''77950'', ''Professional''),
(''Health Care District Palm Beach County'', ''95828'', ''95828'', ''Professional''),
(''Health Care Facilities of Missouri, Inc. - CORVEL'', ''J3959'', ''J3959'', ''Institutional''),
(''Health Care Facilities of Missouri, Inc. - CORVEL'', ''J3959'', ''J3959'', ''Professional''),
(''Health Care Los Angeles IPA (MedPOINT) California'', ''MPM06'', ''MPM06'', ''Institutional''),
(''Health Care Los Angeles IPA (MedPOINT) California'', ''MPM06'', ''MPM06'', ''Professional''),
(''Health Care Network of Wisconsin (HCN)'', ''42102'', ''42102'', ''Institutional''),
(''Health Care Network of Wisconsin (HCN)'', ''42102'', ''42102'', ''Professional''),
(''Health Care Payer''''s Coalition - Toledo, Ohio'', ''34193'', ''34193'', ''Institutional''),
(''Health Care Payer''''s Coalition - Toledo, Ohio'', ''34193'', ''34193'', ''Professional''),
(''Health Cost Solutions'', ''62111'', ''62111'', ''Institutional''),
(''Health Cost Solutions'', ''62111'', ''62111'', ''Professional''),
(''Health Designs Plus - Hudson, Ohio'', ''34158'', ''34158'', ''Institutional''),
(''Health Designs Plus - Hudson, Ohio'', ''34158'', ''34158'', ''Professional''),
(''Health Excel IPA'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Health Excel IPA'', ''PROSP'', ''PROSP'', ''Professional''),
(''Health First (FL)'', ''95019'', ''95019'', ''Professional''),
(''Health First of Austin'', ''75289'', ''75289'', ''Institutional''),
(''Health First of Austin'', ''75289'', ''75289'', ''Professional''),
(''Health Net of Arizona'', ''38309'', ''38309'', ''Institutional''),
(''Health Net of Arizona'', ''38309'', ''38309'', ''Professional''),
(''Health Net of California & Oregon'', ''95567'', ''95567'', ''Institutional''),
(''Health Net of California & Oregon'', ''95567'', ''95567'', ''Professional''),
(''Health Net of California & Oregon-Medicare Advantage (MA) and Individual Family Plan (IFP)'', ''68069'', ''68069'', ''Institutional''),
(''Health Net of California & Oregon-Medicare Advantage (MA) and Individual Family Plan (IFP)'', ''68069'', ''68069'', ''Professional''),
(''Health Net of California (Institutional encounters)'', ''95568'', ''95568'', ''Institutional''),
(''Health Net of California (professional encounters)'', ''95570'', ''95570'', ''Professional''),
(''Health Network One'', ''65062'', ''65062'', ''Institutional''),
(''Health Network One'', ''65062'', ''65062'', ''Professional''),
(''Health Network Solutions (HNS) - Absolute Total Care SC'', ''HAT02'', ''HAT02'', ''Professional''),
(''Health Network Solutions (HNS) - BCBS NC'', ''HBC01'', ''HBC01'', ''Professional''),
(''Health Network Solutions (HNS) - Cigna NC'', ''HCI01'', ''HCI01'', ''Professional''),
(''Health Network Solutions (HNS) - Cigna SC'', ''HCI02'', ''HCI02'', ''Professional''),
(''Health Network Solutions (HNS) - HealthSpring NC'', ''HHS01'', ''HHS01'', ''Professional''),
(''Health Network Solutions (HNS) - HealthSpring SC'', ''HHS02'', ''HHS02'', ''Professional''),
(''Health Network Solutions (HNS) - MedCost NC'', ''HMC01'', ''HMC01'', ''Professional''),
(''Health Network Solutions (HNS) - MedCost SC'', ''HMC02'', ''HMC02'', ''Professional''),
(''Health Network Solutions (HNS) - Select Health NC'', ''HSH01'', ''HSH01'', ''Professional''),
(''Health Network Solutions (HNS) - Select Health SC'', ''HSH02'', ''HSH02'', ''Professional''),
(''Health New England'', ''04286'', ''04286'', ''Institutional''),
(''Health New England'', ''04286'', ''04286'', ''Professional''),
(''Health Options of Illinois'', ''36368'', ''PAPER'', ''Institutional''),
(''Health Options of Illinois'', ''36368'', ''PAPER'', ''Professional''),
(''Health Partners - Jackson, Tennessee'', ''62157'', ''62157'', ''Institutional''),
(''Health Partners - Jackson, Tennessee'', ''62157'', ''62157'', ''Professional''),
(''Health Partners - Pennsylvania'', ''80142'', ''80142'', ''Institutional''),
(''Health Partners - Pennsylvania'', ''80142'', ''80142'', ''Professional''),
(''Health Partners of KS'', ''31478'', ''31478'', ''Institutional''),
(''Health Partners of KS'', ''31478'', ''31478'', ''Professional''),
(''Health Payment Systems, Inc.'', ''20270'', ''20270'', ''Institutional''),
(''Health Payment Systems, Inc.'', ''20270'', ''20270'', ''Professional''),
(''Health Plan of Nevada'', ''76342'', ''76342'', ''Institutional''),
(''Health Plan of Nevada'', ''76342'', ''76342'', ''Professional''),
(''Health Plan of San Joaquin/San Joaquin Health Administrators'', ''68035'', ''68035'', ''Institutional''),
(''Health Plan of San Joaquin/San Joaquin Health Administrators'', ''68035'', ''68035'', ''Professional''),
(''Health Plan of San Mateo'', ''HPSM1'', ''HPSM1'', ''Institutional''),
(''Health Plan of San Mateo'', ''HPSM1'', ''HPSM1'', ''Professional''),
(''Health Plans Inc.'', ''44273'', ''44273'', ''Institutional''),
(''Health Plans Inc.'', ''44273'', ''44273'', ''Professional''),
(''Health Plus of Louisiana'', ''95009'', ''95009'', ''Professional''),
(''Health Safety Net - Massachusetts Medicaid, HSN'', ''SKMA2'', ''MAHSN'', ''Professional''),
(''Health Select IPA'', ''HSIPA'', ''HSIPA'', ''Institutional''),
(''Health Select IPA'', ''HSIPA'', ''HSIPA'', ''Professional''),
(''Health Services for Children with Special Needs'', ''37290'', ''37290'', ''Institutional''),
(''Health Services for Children with Special Needs'', ''37290'', ''37290'', ''Professional''),
(''Health Services Management - HSM (MN)'', ''41150'', ''41150'', ''Professional''),
(''Health Services Preferred (HSP) - Emerald Health'', ''34167'', ''34167'', ''Institutional''),
(''Health Services Preferred (HSP) - Emerald Health'', ''34167'', ''34167'', ''Professional''),
(''Health Special Risk, Inc'', ''65449'', ''65449'', ''Institutional''),
(''Health Special Risk, Inc'', ''65449'', ''65449'', ''Professional''),
(''Health Texas Medical Group'', ''HTHTX'', ''HTHTX'', ''Professional''),
(''Health Texas Medical Group'', ''HTMG1'', ''PAPER'', ''Institutional''),
(''Health Traditions Health Plan'', ''HLTHT'', ''HLTHT'', ''Institutional''),
(''Health Traditions Health Plan'', ''HLTHT'', ''HLTHT'', ''Professional''),
(''Healthcare Highways'', ''HCH01'', ''HCH01'', ''Institutional''),
(''Healthcare Highways'', ''HCH01'', ''HCH01'', ''Professional''),
(''Healthcare Management Administrator (HMA)'', ''HMA01'', ''HMA01'', ''Institutional''),
(''Healthcare Management Administrator (HMA)'', ''HMA01'', ''HMA01'', ''Professional''),
(''HealthCare Partners of Nevada'', ''20501'', ''20501'', ''Institutional''),
(''HealthCare Partners of Nevada'', ''20501'', ''20501'', ''Professional''),
(''HealthCare Partners, IPA (New York)'', ''11328'', ''11328'', ''Institutional''),
(''HealthCare Partners, IPA (New York)'', ''11328'', ''11328'', ''Professional''),
(''Healthcare Resources NW'', ''56731'', ''56731'', ''Institutional''),
(''Healthcare Resources NW'', ''56731'', ''56731'', ''Professional''),
(''Healthcare Solutions Group'', ''73147'', ''73147'', ''Institutional''),
(''Healthcare Solutions Group'', ''73147'', ''73147'', ''Professional''),
(''Healthcare''''s Finest Network (HFN)'', ''36335'', ''36335'', ''Institutional''),
(''Healthcare''''s Finest Network (HFN)'', ''36335'', ''36335'', ''Professional''),
(''HealthChoice - Oklahoma'', ''71064'', ''71064'', ''Institutional''),
(''HealthChoice - Oklahoma'', ''71064'', ''71064'', ''Professional''),
(''HealthComp  (CA)'', ''85729'', ''85729'', ''Institutional''),
(''HealthComp  (CA)'', ''85729'', ''85729'', ''Professional''),
(''HealthEase/WellCare of Florida'', ''14163'', ''59608'', ''Professional''),
(''HealthEase/WellCare of Florida'', ''59608'', ''59608'', ''Institutional''),
(''HealthEdge Administrators'', ''95213'', ''95213'', ''Institutional''),
(''HealthEdge Administrators'', ''95213'', ''95213'', ''Professional''),
(''HealthEZ'', ''41178'', ''41178'', ''Institutional''),
(''HealthEZ'', ''41178'', ''41178'', ''Professional''),
(''Healthfirst  TPA - Tyler, Texas'', ''75234'', ''75234'', ''Institutional''),
(''Healthfirst  TPA - Tyler, Texas'', ''75234'', ''75234'', ''Professional''),
(''Healthfirst 65 Plus'', ''80141'', ''80141'', ''Institutional''),
(''Healthfirst 65 Plus'', ''80141'', ''80141'', ''Professional''),
(''Healthfirst Health Plan of New Jersey'', ''80141'', ''80141'', ''Institutional''),
(''Healthfirst Health Plan of New Jersey'', ''80141'', ''80141'', ''Professional''),
(''Healthfirst Inc. (New York)'', ''80141'', ''80141'', ''Institutional''),
(''Healthfirst Inc. (New York)'', ''80141'', ''80141'', ''Professional''),
(''Healthgram'', ''56144'', ''56144'', ''Institutional''),
(''Healthgram'', ''56144'', ''56144'', ''Professional''),
(''HealthHelp Network, Inc (HHNI)'', ''59087'', ''59087'', ''Institutional''),
(''HealthHelp Network, Inc (HHNI)'', ''59087'', ''59087'', ''Professional''),
(''Healthlink HMO'', ''96475'', ''96475'', ''Institutional''),
(''Healthlink HMO'', ''96475'', ''96475'', ''Professional''),
(''HealthLink Iowa'', ''87726'', ''87726'', ''Institutional''),
(''HealthLink Iowa'', ''87726'', ''87726'', ''Professional''),
(''Healthlink PPO'', ''90001'', ''90001'', ''Institutional''),
(''Healthlink PPO'', ''90001'', ''90001'', ''Professional''),
(''HealthNet Cal Care'', ''SYMED'', ''SYMED'', ''Professional''),
(''HealthNow New York'', ''55204'', ''55204'', ''Institutional''),
(''HealthNow New York'', ''55204'', ''55204'', ''Professional''),
(''HealthPartners'', ''44547'', ''44547'', ''Institutional''),
(''HealthPartners'', ''44547'', ''44547'', ''Professional''),
(''HealthPartners - Minnesota'', ''07003'', ''07003'', ''Institutional''),
(''HealthPartners - Minnesota'', ''07003'', ''07003'', ''Professional''),
(''HealthPlan Services (Tampa)'', ''59140'', ''59140'', ''Institutional''),
(''HealthPlan Services (Tampa)'', ''59140'', ''59140'', ''Professional''),
(''HealthScope Benefits (HSB)'', ''71084'', ''71084'', ''Institutional''),
(''HealthScope Benefits (HSB)'', ''71084'', ''71084'', ''Professional''),
(''HealthSCOPE Benefits - Community Health Alliance TN'', ''27905'', ''27905'', ''Institutional''),
(''HealthSCOPE Benefits - Community Health Alliance TN'', ''27905'', ''27905'', ''Professional''),
(''HealthSCOPE Benefits, Inc. (formerly known as CNA Health Partners)'', ''71063'', ''71063'', ''Institutional''),
(''HealthSCOPE Benefits, Inc. (formerly known as CNA Health Partners)'', ''71063'', ''71063'', ''Professional''),
(''Healthselect BCBS of Florida'', ''M3IL1'', ''M3IL1'', ''Professional''),
(''Healthsmart'', ''J1481'', ''J1481'', ''Institutional''),
(''Healthsmart'', ''J1481'', ''J1481'', ''Professional''),
(''HealthSmart ACCEL'', ''75237'', ''75237'', ''Institutional''),
(''HealthSmart ACCEL'', ''75237'', ''75237'', ''Professional''),
(''Healthsmart Benefit Solutions'', ''37224'', ''37224'', ''Professional''),
(''HealthSmart Benefit Solutions'', ''37272'', ''37272'', ''Institutional''),
(''HealthSmart Benefit Solutions'', ''37272'', ''37272'', ''Professional''),
(''HealthSmart Benefit Solutions'', ''37283'', ''37283'', ''Institutional''),
(''HealthSmart Benefit Solutions'', ''37283'', ''37283'', ''Professional''),
(''HealthSmart Benefit Solutions, Inc.'', ''87815'', ''87815'', ''Institutional''),
(''HealthSmart Benefit Solutions, Inc.'', ''87815'', ''87815'', ''Professional''),
(''HealthSmart Management Services Organization'', ''HSM01'', ''HSM01'', ''Institutional''),
(''HealthSmart Management Services Organization'', ''HSM01'', ''HSM01'', ''Professional''),
(''HealthSmart Preferred Care (HSPC)'', ''75250'', ''75250'', ''Institutional''),
(''HealthSmart Preferred Care (HSPC)'', ''75250'', ''75250'', ''Professional''),
(''Healthsource - Arkansas'', ''71074'', ''71074'', ''Professional''),
(''Healthsource - Arkansas'', ''71075'', ''71074'', ''Institutional''),
(''Healthsource - Arkansas Medicare HMO , Cigna'', ''71075'', ''71075'', ''Institutional''),
(''Healthsource - Arkansas Medicare HMO , Cigna'', ''71075'', ''71075'', ''Professional''),
(''Healthsource - Georgia, Cigna'', ''58210'', ''58210'', ''Institutional''),
(''Healthsource - Georgia, Cigna'', ''58210'', ''58210'', ''Professional''),
(''Healthsource - Kentucky'', ''61127'', ''61127'', ''Institutional''),
(''Healthsource - Kentucky'', ''61127'', ''61127'', ''Professional''),
(''Healthsource - Maine'', ''01041'', ''01041'', ''Institutional''),
(''Healthsource - Maine'', ''01041'', ''01041'', ''Professional''),
(''Healthsource - Massachusetts (CMHC)'', ''02041'', ''02041'', ''Institutional''),
(''Healthsource - Massachusetts (CMHC)'', ''02041'', ''02041'', ''Professional''),
(''Healthsource - N. Texas, Cigna'', ''75255'', ''75255'', ''Institutional''),
(''Healthsource - N. Texas, Cigna'', ''75255'', ''75255'', ''Professional''),
(''Healthsource - New Hampshire'', ''02038'', ''02038'', ''Institutional''),
(''Healthsource - New Hampshire'', ''02038'', ''02038'', ''Professional''),
(''Healthsource - North Carolina, Cigna'', ''56147'', ''56147'', ''Institutional''),
(''Healthsource - North Carolina, Cigna'', ''56147'', ''56147'', ''Professional''),
(''Healthsource - Ohio'', ''31141'', ''31141'', ''Institutional''),
(''Healthsource - Ohio'', ''31141'', ''31141'', ''Professional''),
(''Healthsource - South Carolina'', ''06119'', ''06119'', ''Institutional''),
(''Healthsource - South Carolina'', ''06119'', ''06119'', ''Professional''),
(''Healthsource - Tennessee, Cigna'', ''62129'', ''62129'', ''Institutional''),
(''Healthsource - Tennessee, Cigna'', ''62129'', ''62129'', ''Professional''),
(''Healthsource Provident, Cigna'', ''68195'', ''68195'', ''Institutional''),
(''Healthsource Provident, Cigna'', ''68195'', ''68195'', ''Professional''),
(''HealthSpring - Star +'', ''52192'', ''52192'', ''Institutional''),
(''HealthSpring - Star +'', ''52192'', ''52192'', ''Professional''),
(''HealthSpring HMO Medicare + Choice'', ''63092'', ''63092'', ''Institutional''),
(''HealthSpring HMO Medicare + Choice'', ''63092'', ''63092'', ''Professional''),
(''HealthSun'', ''HESUN'', ''HESUN'', ''Institutional''),
(''HealthSun'', ''HESUN'', ''HESUN'', ''Professional''),
(''HealthTeam Advantage'', ''88250'', ''88250'', ''Institutional''),
(''HealthTeam Advantage'', ''88250'', ''88250'', ''Professional''),
(''HealthTeam Advantage Diabetes and Heart Care'', ''88350'', ''88350'', ''Institutional''),
(''HealthTeam Advantage Diabetes and Heart Care'', ''88350'', ''88350'', ''Professional''),
(''Healthways WholeHealth Networks'', ''58213'', ''58213'', ''Professional''),
(''Healthy Blue Dual Advantage Louisiana'', ''00551'', ''00551'', ''Institutional''),
(''Healthy Blue Dual Advantage Louisiana'', ''00551'', ''00551'', ''Professional''),
(''Healthy Blue Louisiana'', ''00661'', ''00661'', ''Institutional''),
(''Healthy Blue Louisiana'', ''00661'', ''00661'', ''Professional''),
(''Healthy Texas'', ''68069'', ''68069'', ''Institutional''),
(''Healthy Texas'', ''68069'', ''68069'', ''Professional''),
(''Healthy York Network'', ''22251'', ''22251'', ''Institutional''),
(''Healthy York Network'', ''22251'', ''22251'', ''Professional''),
(''Heartland Employment Services, LLC'', ''41556'', ''41556'', ''Institutional''),
(''Heartland Employment Services, LLC'', ''41556'', ''41556'', ''Professional''),
(''Heartland Express'', ''J1677'', ''J1677'', ''Institutional''),
(''Heartland Express'', ''J1677'', ''J1677'', ''Professional''),
(''Helmsman Management Services'', ''33600'', ''33600'', ''Institutional''),
(''Helmsman Management Services'', ''33600'', ''33600'', ''Professional''),
(''Hemet Unified School District (CA)'', ''J1654'', ''J1654'', ''Institutional''),
(''Hemet Unified School District (CA)'', ''J1654'', ''J1654'', ''Professional''),
(''Hennepin Health'', ''60058'', ''60058'', ''Institutional''),
(''Hennepin Health'', ''60058'', ''60058'', ''Professional''),
(''Heritage Consultants'', ''59230'', ''59230'', ''Professional''),
(''Heritage Group'', ''J1069'', ''J1069'', ''Institutional''),
(''Heritage Group'', ''J1069'', ''J1069'', ''Professional''),
(''Heritage Physician Network  (HPN) (Houston)'', ''14163'', ''14163'', ''Institutional''),
(''Heritage Physician Network  (HPN) (Houston)'', ''14163'', ''14163'', ''Professional''),
(''Heritage Provider Network (Regal)'', ''REGAL'', ''REGAL'', ''Institutional''),
(''Heritage Provider Network (Regal)'', ''REGAL'', ''REGAL'', ''Professional''),
(''HHH Choices Gold'', ''20552'', ''20552'', ''Institutional''),
(''HHH Choices Gold'', ''20552'', ''20552'', ''Professional''),
(''High Desert Medical Group'', ''95393'', ''HDMDG'', ''Institutional''),
(''High Desert Medical Group'', ''95393'', ''HDMDG'', ''Professional''),
(''Highland Golf'', ''41556'', ''41556'', ''Institutional''),
(''Highland Golf'', ''41556'', ''41556'', ''Professional''),
(''Highline Medical Service Organization - HMSO'', ''91164'', ''91164'', ''Institutional''),
(''Highline Medical Service Organization - HMSO'', ''91164'', ''91164'', ''Professional''),
(''Highmark BCBS'', ''54771'', ''54771'', ''Professional''),
(''Highmark BCBS DE Health Options'', ''47181'', ''47181'', ''Institutional''),
(''Highmark BCBS DE Health Options'', ''47181'', ''47181'', ''Professional''),
(''Highmark Vision'', ''54771'', ''54771'', ''Professional''),
(''Hill Physicians Blue Cross PPO'', ''HLPBC'', ''HLPBC'', ''Professional''),
(''Hill Physicians Blue Shield PPO'', ''HLPBS'', ''HLPBS'', ''Professional''),
(''Hill Physicians Cigna PPO'', ''HLPCG'', ''HLPCG'', ''Institutional''),
(''Hill Physicians Cigna PPO'', ''HLPCG'', ''HLPCG'', ''Professional''),
(''Hill Physicians Health Net PPO'', ''HLPHN'', ''HLPHN'', ''Professional''),
(''Hill Physicians Medical Group'', ''00046'', ''HIL01'', ''Institutional''),
(''Hill Physicians Medical Group'', ''HIL01'', ''HIL01'', ''Professional''),
(''Hill Physicians United Healthcare PPO'', ''HLPUH'', ''HLPUH'', ''Professional''),
(''Hillshire Brands'', ''J1959'', ''J1959'', ''Institutional''),
(''Hillshire Brands'', ''J1959'', ''J1959'', ''Professional''),
(''Hilmar Cheese Company'', ''J1833'', ''J1833'', ''Institutional''),
(''Hilmar Cheese Company'', ''J1833'', ''J1833'', ''Professional''),
(''Hinsdale Physicians Healthcare'', ''37105'', ''37105'', ''Institutional''),
(''Hinsdale Physicians Healthcare'', ''37105'', ''37105'', ''Professional''),
(''HIP Healthy Indiana Plan - Anthem'', ''00630'', ''INXBC'', ''Professional''),
(''HIP Healthy Indiana Plan - Anthem'', ''12B09'', ''INXBC'', ''Institutional''),
(''HIP-Health Insurance Plan of Greater New York'', ''55247'', ''55247'', ''Institutional''),
(''HIP-Health Insurance Plan of Greater New York'', ''55247'', ''55247'', ''Professional''),
(''Hispanic Physician IPA (claims only)'', ''HPFFS'', ''HPFFS'', ''Institutional''),
(''Hispanic Physician IPA (claims only)'', ''HPFFS'', ''HPFFS'', ''Professional''),
(''Hispanic Physician IPA (encounters only)'', ''HPIPA'', ''HPIPA'', ''Institutional''),
(''Hispanic Physician IPA (encounters only)'', ''HPIPA'', ''HPIPA'', ''Professional''),
(''HMA - Healthcare Management Administration'', ''HMA01'', ''HMA01'', ''Institutional''),
(''HMA - Healthcare Management Administration'', ''HMA01'', ''HMA01'', ''Professional''),
(''HMA Hawaii (Hawaii-Mainland Administrators)'', ''86066'', ''86066'', ''Institutional''),
(''HMA Hawaii (Hawaii-Mainland Administrators)'', ''86066'', ''86066'', ''Professional''),
(''HMC HealthWorks aka Health Management Co'', ''75318'', ''75318'', ''Institutional''),
(''HMC HealthWorks aka Health Management Co'', ''75318'', ''75318'', ''Professional''),
(''HMO Louisiana Inc. - Blue Medicare Advantage'', ''84555'', ''84555'', ''Institutional''),
(''HMO Louisiana Inc. - Blue Medicare Advantage'', ''84555'', ''84555'', ''Professional''),
(''HMO of Colorado'', ''COHMO'', ''COHMO'', ''Professional''),
(''HMSHost'', ''J1612'', ''J1612'', ''Institutional''),
(''HMSHost'', ''J1612'', ''J1612'', ''Professional''),
(''Hogan Motor Leasing'', ''41556'', ''41556'', ''Institutional''),
(''Hogan Motor Leasing'', ''41556'', ''41556'', ''Professional''),
(''Hogan Personell'', ''41556'', ''41556'', ''Institutional''),
(''Hogan Personell'', ''41556'', ''41556'', ''Professional''),
(''Holista, LLC'', ''ATHAL'', ''ATHAL'', ''Institutional''),
(''Holista, LLC'', ''ATHAL'', ''ATHAL'', ''Professional''),
(''Holly Farms Corp.'', ''J1070'', ''J1070'', ''Institutional''),
(''Holly Farms Corp.'', ''J1070'', ''J1070'', ''Professional''),
(''Hollywood Presbyterian Medical Group'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Home State Health Plan - Missouri'', ''68069'', ''68069'', ''Institutional''),
(''Home State Health Plan - Missouri'', ''68069'', ''68069'', ''Professional''),
(''Home Sweet Home'', ''41556'', ''41556'', ''Institutional''),
(''Home Sweet Home'', ''41556'', ''41556'', ''Professional''),
(''Homeland Security - INS Health Service (AKA ICE Health)'', ''VAICE'', ''VAICE'', ''Institutional''),
(''Homeland Security - INS Health Service (AKA ICE Health)'', ''VAICE'', ''VAICE'', ''Professional''),
(''Hometown Health Plan -  Nevada'', ''88023'', ''88023'', ''Institutional''),
(''Hometown Health Plan -  Nevada'', ''88023'', ''88023'', ''Professional''),
(''Hopkins Health Advantage'', ''66003'', ''66003'', ''Institutional''),
(''Hopkins Health Advantage'', ''66003'', ''66003'', ''Professional''),
(''Horizon Casualty'', ''WB419'', ''J4007'', ''Institutional''),
(''Horizon Casualty'', ''WB419'', ''J4007'', ''Professional''),
(''Horizon Healthcare of New York'', ''22099'', ''22099'', ''Institutional''),
(''Horizon Healthcare of New York'', ''22099'', ''22099'', ''Professional''),
(''Horizon New Jersey Health'', ''22326'', ''22326'', ''Institutional''),
(''Horizon New Jersey Health'', ''22326'', ''22326'', ''Professional''),
(''Horizon Valley Medical Group'', ''HVMG1'', ''HVMG1'', ''Professional''),
(''Hortica Florist Mutual Insurance'', ''13978'', ''13978'', ''Institutional''),
(''Hortica Florist Mutual Insurance'', ''13978'', ''13978'', ''Professional''),
(''Hotel Employees & Restaurant Employees Health & Trust'', ''91136'', ''91136'', ''Institutional''),
(''Hotel Employees & Restaurant Employees Health & Trust'', ''91136'', ''91136'', ''Professional''),
(''Household Merch Nni'', ''J1071'', ''J1071'', ''Institutional''),
(''Household Merch Nni'', ''J1071'', ''J1071'', ''Professional''),
(''Housing Authority El Paso (TX)'', ''A0107'', ''A0107'', ''Institutional''),
(''Housing Authority El Paso (TX)'', ''A0107'', ''A0107'', ''Professional''),
(''Houston Hunters Patrol, Inc'', ''J1020'', ''J1020'', ''Institutional''),
(''Houston Hunters Patrol, Inc'', ''J1020'', ''J1020'', ''Professional''),
(''Howard County Government (MD)'', ''J1888'', ''J1888'', ''Institutional''),
(''Howard County Government (MD)'', ''J1888'', ''J1888'', ''Professional''),
(''HPMC - Alta Med Clinics'', ''38828'', ''AMM16'', ''Institutional''),
(''HPMC - Alta Med Clinics'', ''38828'', ''AMM16'', ''Professional''),
(''HPMC - Preferred Medical Group'', ''10910'', ''AMM18'', ''Institutional''),
(''HPMC - Preferred Medical Group'', ''10910'', ''AMM18'', ''Professional''),
(''HPMC - San Judas IPA'', ''73331'', ''AMM17'', ''Institutional''),
(''HPMC - San Judas IPA'', ''73331'', ''AMM17'', ''Professional''),
(''HSA Health Plan'', ''84095'', ''84095'', ''Institutional''),
(''HSA Health Plan'', ''84095'', ''84095'', ''Professional''),
(''HSBS Oklahoma City'', ''37256'', ''37256'', ''Institutional''),
(''HSBS Oklahoma City'', ''37256'', ''37256'', ''Professional''),
(''HSBS World Trade Center Health Program'', ''31172'', ''31172'', ''Institutional''),
(''HSBS World Trade Center Health Program'', ''31172'', ''31172'', ''Professional''),
(''HSHS Medical Group IPA'', ''37137'', ''37137'', ''Institutional''),
(''HSHS Medical Group IPA'', ''37137'', ''37137'', ''Professional''),
(''Hudson Health Plan'', ''14165'', ''14165'', ''Institutional''),
(''Hudson Health Plan'', ''14165'', ''14165'', ''Professional''),
(''Hughes Tool Company'', ''J1072'', ''J1072'', ''Institutional''),
(''Hughes Tool Company'', ''J1072'', ''J1072'', ''Professional''),
(''Human Behavior Institute'', ''HBI01'', ''HBI01'', ''Professional''),
(''Humana'', ''61101'', ''61101'', ''Institutional''),
(''Humana'', ''61101'', ''61101'', ''Professional''),
(''Humana (Encounters)'', ''61102'', ''61102'', ''Professional''),
(''Humana American Eldercare Long Term Care'', ''61115'', ''61115'', ''Institutional''),
(''Humana American Eldercare Long Term Care'', ''61115'', ''61115'', ''Professional''),
(''Humana Employers Health Insurance (EHI)'', ''61101'', ''61101'', ''Institutional''),
(''Humana Employers Health Insurance (EHI)'', ''61101'', ''61101'', ''Professional''),
(''Humana Health Plans of Ohio'', ''95348'', ''95348'', ''Professional''),
(''Humana Lifesynch'', ''61104'', ''61104'', ''Institutional''),
(''Humana Lifesynch'', ''61104'', ''61104'', ''Professional''),
(''Humboldt-Del Norte Foundation for Medical Care'', ''94154'', ''94154'', ''Professional''),
(''Huntington Park Mission Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Huntington Park Mission Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Huron PACE'', ''54750'', ''54750'', ''Institutional''),
(''Huron PACE'', ''54750'', ''54750'', ''Professional''),
(''Hutchinson Technology'', ''J1626'', ''J1626'', ''Institutional''),
(''Hutchinson Technology'', ''J1626'', ''J1626'', ''Professional''),
(''Hy-Vee (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Hy-Vee (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''I.E. Shaffer - West Trenton, New Jersey'', ''22175'', ''22175'', ''Institutional''),
(''I.E. Shaffer - West Trenton, New Jersey'', ''22175'', ''22175'', ''Professional''),
(''IBEW Western Utilities Health & Welfare'', ''38238'', ''38238'', ''Professional''),
(''IBG Administrators, LLC'', ''81810'', ''81810'', ''Institutional''),
(''IBG Administrators, LLC'', ''81810'', ''81810'', ''Professional''),
(''ICARE (Independent Care Health Plan) WI'', ''11695'', ''11695'', ''Institutional''),
(''ICARE (Independent Care Health Plan) WI'', ''11695'', ''11695'', ''Professional''),
(''iCARE Health Solutions'', ''26054'', ''26054'', ''Professional''),
(''iCircle of New York'', ''33884'', ''33884'', ''Institutional''),
(''iCircle of New York'', ''33884'', ''33884'', ''Professional''),
(''ICW (Insurance Co of the West)'', ''27847'', ''27847'', ''Institutional''),
(''ICW (Insurance Co of the West)'', ''27847'', ''27847'', ''Professional''),
(''IdealCare by Sendero'', ''SCS17'', ''SCS17'', ''Institutional''),
(''IdealCare by Sendero'', ''SCS17'', ''SCS17'', ''Professional''),
(''IDS Property Casualty'', ''C1099'', ''C1099'', ''Institutional''),
(''IDS Property Casualty'', ''C1099'', ''C1099'', ''Professional''),
(''IDS Property Casualty Insurance Company'', ''12504'', ''12504'', ''Institutional''),
(''IDS Property Casualty Insurance Company'', ''12504'', ''12504'', ''Professional''),
(''IHG Direct'', ''75274'', ''75274'', ''Institutional''),
(''IHG Direct'', ''75274'', ''75274'', ''Professional''),
(''ILCBH (IL Community Behavioral Healthcare)'', ''68068'', ''68068'', ''Institutional''),
(''ILCBH (IL Community Behavioral Healthcare)'', ''68068'', ''68068'', ''Professional''),
(''Illinois Casualty'', ''J1575'', ''J1575'', ''Institutional''),
(''Illinois Casualty'', ''J1575'', ''J1575'', ''Professional''),
(''Illinois EMCASCO'', ''21415'', ''21415'', ''Institutional''),
(''Illinois EMCASCO'', ''21415'', ''21415'', ''Professional''),
(''Illinois EMCASCO'', ''C1029'', ''C1029'', ''Institutional''),
(''Illinois EMCASCO'', ''C1029'', ''C1029'', ''Professional''),
(''Illinois EMCASCO'', ''J1433'', ''J1433'', ''Institutional''),
(''Illinois EMCASCO'', ''J1433'', ''J1433'', ''Professional''),
(''Illinois Health Partner'', ''DMG01'', ''DMG01'', ''Institutional''),
(''Illinois Health Partner'', ''DMG01'', ''DMG01'', ''Professional''),
(''Illinois Physicians Alliance IPA'', ''IPA99'', ''IPA99'', ''Institutional''),
(''Illinois Physicians Alliance IPA'', ''IPA99'', ''IPA99'', ''Professional''),
(''IMA Management, Inc. (Louisiana)'', ''72091'', ''72091'', ''Institutional''),
(''IMA Management, Inc. (Louisiana)'', ''72091'', ''72091'', ''Professional''),
(''IMA, Inc. - 90 Degree Benefits'', ''64556'', ''64556'', ''Institutional''),
(''IMA, Inc. - 90 Degree Benefits'', ''64556'', ''64556'', ''Professional''),
(''Imagework Technologies Corp. - City of New York'', ''40043'', ''40043'', ''Institutional''),
(''Imagework Technologies Corp. - City of New York'', ''40043'', ''40043'', ''Professional''),
(''Imagine Health'', ''43123'', ''43123'', ''Institutional''),
(''Imagine Health'', ''43123'', ''43123'', ''Professional''),
(''IMcare'', ''41600'', ''41600'', ''Institutional''),
(''IMcare'', ''41600'', ''41600'', ''Professional''),
(''Imperial Health Holdings Medical Group'', ''IHHMG'', ''IHHMG'', ''Institutional''),
(''Imperial Health Holdings Medical Group'', ''IHHMG'', ''IHHMG'', ''Professional''),
(''Imperial Insurance Companies'', ''IICTX'', ''IICTX'', ''Institutional''),
(''Imperial Insurance Companies'', ''IICTX'', ''IICTX'', ''Professional''),
(''Imperial Irrigation District'', ''41556'', ''41556'', ''Institutional''),
(''Imperial Irrigation District'', ''41556'', ''41556'', ''Professional''),
(''IMS-Trial Card'', ''56155'', ''56155'', ''Institutional''),
(''IMS-Trial Card'', ''56155'', ''56155'', ''Professional''),
(''Inconen Corporation'', ''41556'', ''41556'', ''Institutional''),
(''Inconen Corporation'', ''41556'', ''41556'', ''Professional''),
(''INDECS Corporation'', ''40585'', ''40585'', ''Institutional''),
(''INDECS Corporation'', ''40585'', ''40585'', ''Professional''),
(''Independence Administrators'', ''TA720'', ''TA720'', ''Institutional''),
(''Independence Administrators'', ''TA720'', ''TA720'', ''Professional''),
(''Independence American Insurance Co.'', ''CB231'', ''CB231'', ''Institutional''),
(''Independence American Insurance Co.'', ''CB231'', ''CB231'', ''Professional''),
(''Independence Blue Cross (IBC) Highmark'', ''54704'', ''54704'', ''Institutional''),
(''Independence Blue Cross (IBC) Highmark'', ''54704'', ''54704'', ''Professional''),
(''Independence Medical Group - Kern County'', ''IMG01'', ''IMG01'', ''Professional''),
(''Independence Medical Group - Kern County - MCS'', ''MCS03'', ''MCS03'', ''Institutional''),
(''Independence Medical Group - Kern County - MCS'', ''MCS03'', ''MCS03'', ''Professional''),
(''Independence Medical Group - Tulare County'', ''IMG02'', ''IMG02'', ''Professional''),
(''Independence Medical Group - Tulare County - MCS'', ''MCS03'', ''MCS03'', ''Institutional''),
(''Independence Medical Group - Tulare County - MCS'', ''MCS03'', ''MCS03'', ''Professional''),
(''Independent Health NY'', ''95308'', ''95308'', ''Institutional''),
(''Independent Health NY'', ''95308'', ''95308'', ''Professional''),
(''Independent Living Systems'', ''45048'', ''45048'', ''Institutional''),
(''Independent Living Systems'', ''45048'', ''45048'', ''Professional''),
(''Independent Physicians at Mercy'', ''INDPM'', ''INDPM'', ''Institutional''),
(''Independent Physicians at Mercy'', ''INDPM'', ''INDPM'', ''Professional''),
(''Indian Health Services'', ''SX171'', ''SX171'', ''Professional''),
(''Indiana Dept of Health - Children''''s Health, claims'', ''35600'', ''35600'', ''Institutional''),
(''Indiana Dept of Health - Children''''s Health, claims'', ''35600'', ''35600'', ''Professional''),
(''Indiana Farmers Mutual - CORVEL'', ''J3960'', ''J3960'', ''Institutional''),
(''Indiana Farmers Mutual - CORVEL'', ''J3960'', ''J3960'', ''Professional''),
(''Indiana Hoosier Healthwise HHW - Anthem'', ''00630'', ''INXBC'', ''Professional''),
(''Indiana Hoosier Healthwise HHW - Anthem'', ''12B09'', ''INXBC'', ''Institutional''),
(''Indiana Insurance'', ''J1425'', ''J1425'', ''Institutional''),
(''Indiana Insurance'', ''J1425'', ''J1425'', ''Professional''),
(''Indiana ProHealth Network'', ''35161'', ''35161'', ''Institutional''),
(''Indiana ProHealth Network'', ''35161'', ''35161'', ''Professional''),
(''Indiana Teamsters Health Benefit Funds'', ''INTE1'', ''PAPER'', ''Institutional''),
(''Indiana Teamsters Health Benefit Funds'', ''INTE1'', ''PAPER'', ''Professional''),
(''Indiana University Health Plans - Commercial/Marketplace (IUHPLNS)'', ''26212'', ''26212'', ''Institutional''),
(''Indiana University Health Plans - Commercial/Marketplace (IUHPLNS)'', ''26212'', ''26212'', ''Professional''),
(''Indiana University Health Plans - Medicare Advantage'', ''95444'', ''95444'', ''Institutional''),
(''Indiana University Health Plans - Medicare Advantage'', ''95444'', ''95444'', ''Professional''),
(''Individual Assurance Company (IAC)'', ''30360'', ''30360'', ''Institutional''),
(''Individual Assurance Company (IAC)'', ''30360'', ''30360'', ''Professional''),
(''Individual Health Division'', ''31053'', ''31053'', ''Institutional''),
(''Individual Health Division'', ''31053'', ''31053'', ''Professional''),
(''Inetico - Valenz'', ''43471'', ''43471'', ''Institutional''),
(''Inetico - Valenz'', ''43471'', ''43471'', ''Professional''),
(''Infinity IPA'', ''INFIN'', ''INFIN'', ''Institutional''),
(''Infinity IPA'', ''INFIN'', ''INFIN'', ''Professional''),
(''InforMed UHC Compass Rose Health Plan'', ''39026'', ''39026'', ''Institutional''),
(''InforMed UHC Compass Rose Health Plan'', ''39026'', ''39026'', ''Professional''),
(''Ingham Health Plan'', ''38343'', ''38343'', ''Institutional''),
(''Ingham Health Plan'', ''38343'', ''38343'', ''Professional''),
(''Ingles Markets'', ''J1907'', ''J1907'', ''Institutional''),
(''Ingles Markets'', ''J1907'', ''J1907'', ''Professional''),
(''InHealth Mutual of Ohio'', ''74431'', ''74431'', ''Institutional''),
(''InHealth Mutual of Ohio'', ''74431'', ''74431'', ''Professional''),
(''Inland Empire Health Plan'', ''IEHP1'', ''IEHP1'', ''Institutional''),
(''Inland Empire Health Plan'', ''IEHP1'', ''IEHP1'', ''Professional''),
(''Inland Faculty Medical Group'', ''MVMM1'', ''MVMM1'', ''Professional''),
(''Inland Faculty Medical Group - Encounters'', ''MVMM2'', ''MVMM2'', ''Professional''),
(''Inland Valley - Redlands IPA (San Bernardino)'', ''SYMED'', ''SYMED'', ''Professional''),
(''Inland Valley Hospice'', ''41556'', ''41556'', ''Institutional''),
(''Inland Valley Hospice'', ''41556'', ''41556'', ''Professional''),
(''Innovage - Total Community Care'', ''31182'', ''31182'', ''Institutional''),
(''Innovage - Total Community Care'', ''31182'', ''31182'', ''Professional''),
(''Innovante Benefit Administrators aka HealthTrans'', ''31172'', ''31172'', ''Institutional''),
(''Innovante Benefit Administrators aka HealthTrans'', ''31172'', ''31172'', ''Professional''),
(''Innovation Health'', ''40025'', ''40025'', ''Institutional''),
(''Innovation Health'', ''40025'', ''40025'', ''Professional''),
(''Innovative Claim Solutions (ICS) - Rancho Cordova'', ''J1599'', ''J1599'', ''Institutional''),
(''Innovative Claim Solutions (ICS) - Rancho Cordova'', ''J1599'', ''J1599'', ''Professional''),
(''Innovative Claim Solutions (ICS) - San Ramon'', ''J1601'', ''J1601'', ''Institutional''),
(''Innovative Claim Solutions (ICS) - San Ramon'', ''J1601'', ''J1601'', ''Professional''),
(''Innovative Healthware Solutions'', ''04320'', ''04320'', ''Institutional''),
(''Innovative Healthware Solutions'', ''04320'', ''04320'', ''Professional''),
(''Innovative Physician Associates'', ''80087'', ''80087'', ''Institutional''),
(''Innovative Physician Associates'', ''80087'', ''80087'', ''Professional''),
(''Insight Benefit Administrators'', ''38254'', ''38254'', ''Institutional''),
(''Insight Benefit Administrators'', ''38254'', ''38254'', ''Professional''),
(''Insilco Corp'', ''J1073'', ''J1073'', ''Institutional''),
(''Insilco Corp'', ''J1073'', ''J1073'', ''Professional''),
(''Instil Health HMO'', ''C60'', ''C60'', ''Professional''),
(''Instil Health PPO'', ''C61'', ''C61'', ''Professional''),
(''Insurance Administrators of America, Inc. (IAA)'', ''37279'', ''37279'', ''Institutional''),
(''Insurance Administrators of America, Inc. (IAA)'', ''37279'', ''37279'', ''Professional''),
(''Insurance Design Administrators'', ''13315'', ''13315'', ''Institutional''),
(''Insurance Design Administrators'', ''13315'', ''13315'', ''Professional''),
(''Insurance Management Administrators of Louisiana'', ''72091'', ''72091'', ''Professional''),
(''Insurance Management Services - Amarillo'', ''15688'', ''15688'', ''Institutional''),
(''Insurance Management Services - Amarillo'', ''15688'', ''15688'', ''Professional''),
(''Insurance Management Services of Texas (IMS)'', ''IMSMS'', ''IMSMS'', ''Institutional''),
(''Insurance Management Services of Texas (IMS)'', ''IMSMS'', ''IMSMS'', ''Professional''),
(''Insurance Program Managers Group (IPMG)'', ''36342'', ''36342'', ''Institutional''),
(''Insurance Program Managers Group (IPMG)'', ''36342'', ''36342'', ''Professional''),
(''Insurance Services of Lubbock'', ''ISL11'', ''ISL11'', ''Professional''),
(''Insurance Systems - Health Systems, Inc. (HSIM)'', ''11889'', ''11889'', ''Institutional''),
(''Insurance Systems - Health Systems, Inc. (HSIM)'', ''11889'', ''11889'', ''Professional''),
(''Insurers Administrative Corp - Phoenix, Arizona'', ''86304'', ''86304'', ''Institutional''),
(''Insurers Administrative Corp - Phoenix, Arizona'', ''86304'', ''86304'', ''Professional''),
(''Integon Casualty Insurance Co.'', ''C1028'', ''C1028'', ''Institutional''),
(''Integon Casualty Insurance Co.'', ''C1028'', ''C1028'', ''Professional''),
(''Integon General Insurance Corp.'', ''C1028'', ''C1028'', ''Institutional''),
(''Integon General Insurance Corp.'', ''C1028'', ''C1028'', ''Professional''),
(''Integon Indemnity Corp.'', ''C1028'', ''C1028'', ''Institutional''),
(''Integon Indemnity Corp.'', ''C1028'', ''C1028'', ''Professional''),
(''Integon National Insurance Co.'', ''C1028'', ''C1028'', ''Institutional''),
(''Integon National Insurance Co.'', ''C1028'', ''C1028'', ''Professional''),
(''Integon Preferred Insurance Co.'', ''C1028'', ''C1028'', ''Institutional''),
(''Integon Preferred Insurance Co.'', ''C1028'', ''C1028'', ''Professional''),
(''Integra Administrative Group -Seaford, Delaware'', ''51020'', ''51020'', ''Institutional''),
(''Integra Administrative Group -Seaford, Delaware'', ''51020'', ''51020'', ''Professional''),
(''Integra Group'', ''31127'', ''31127'', ''Institutional''),
(''Integra Group'', ''31127'', ''31127'', ''Professional''),
(''Integra Group-CHA'', ''31129'', ''31129'', ''Professional''),
(''Integra Managed Long Term Care - MLTC'', ''45302'', ''45302'', ''Institutional''),
(''Integra Managed Long Term Care - MLTC'', ''45302'', ''45302'', ''Professional''),
(''Integranet Health'', ''INET1'', ''INET1'', ''Institutional''),
(''Integranet Health'', ''INET1'', ''INET1'', ''Professional''),
(''Integrated Care Network by Emerald'', ''34167'', ''34167'', ''Institutional''),
(''Integrated Care Network by Emerald'', ''34167'', ''34167'', ''Professional''),
(''Integrated Health Partners (IHP) (MedPOINT) California'', ''MPM26'', ''MPM26'', ''Institutional''),
(''Integrated Health Partners (IHP) (MedPOINT) California'', ''MPM26'', ''MPM26'', ''Professional''),
(''Integrated Health Partners (IHP) (MedPOINT) California Single Scrub'', ''MPMIH'', ''MPMIH'', ''Institutional''),
(''Integrated Health Partners (IHP) (MedPOINT) California Single Scrub'', ''MPMIH'', ''MPMIH'', ''Professional''),
(''Integrated Medical Solutions'', ''20050'', ''20050'', ''Institutional''),
(''Integrated Medical Solutions'', ''20050'', ''20050'', ''Professional''),
(''Integrity Mutual Insurance Company (AUTO ONLY)'', ''10322'', ''10322'', ''Institutional''),
(''Integrity Mutual Insurance Company (AUTO ONLY)'', ''10322'', ''10322'', ''Professional''),
(''Integrity Mutual Insurance Company (WC ONLY)'', ''14303'', ''14303'', ''Institutional''),
(''Integrity Mutual Insurance Company (WC ONLY)'', ''14303'', ''14303'', ''Professional''),
(''Intercare'', ''J1542'', ''J1542'', ''Institutional''),
(''Intercare'', ''J1542'', ''J1542'', ''Professional''),
(''Intercare - Sussex'', ''J1957'', ''J1957'', ''Institutional''),
(''Intercare - Sussex'', ''J1957'', ''J1957'', ''Professional''),
(''Intercare Health Plans, Inc.'', ''39026'', ''39026'', ''Institutional''),
(''Intercare Health Plans, Inc.'', ''39026'', ''39026'', ''Professional''),
(''InterCommunity Health Net'', ''CP001'', ''CP001'', ''Institutional''),
(''InterCommunity Health Net'', ''CP001'', ''CP001'', ''Professional''),
(''Interface EAP'', ''60280'', ''60280'', ''Institutional''),
(''Interface EAP'', ''60280'', ''60280'', ''Professional''),
(''Intergroup Service Corporation'', ''23287'', ''23287'', ''Institutional''),
(''Intergroup Service Corporation'', ''23287'', ''23287'', ''Professional''),
(''Interinsurance Exchange of the Automobile Club'', ''J1810'', ''J1810'', ''Institutional''),
(''Interinsurance Exchange of the Automobile Club'', ''J1810'', ''J1810'', ''Professional''),
(''International Benefit Administrator'', ''11329'', ''11329'', ''Institutional''),
(''International Benefit Administrator'', ''11329'', ''11329'', ''Professional''),
(''International Brotherhood of Boilermakers'', ''36609'', ''36609'', ''Professional''),
(''International Educational Exchange Services (IEES)'', ''16158'', ''16158'', ''Institutional''),
(''International Educational Exchange Services (IEES)'', ''16158'', ''16158'', ''Professional''),
(''International Funding, LTD  (ITPA)'', ''39182'', ''39182'', ''Institutional''),
(''International Funding, LTD  (ITPA)'', ''39182'', ''39182'', ''Professional''),
(''International Medical Group'', ''IMGIN'', ''IMGIN'', ''Institutional''),
(''International Medical Group'', ''IMGIN'', ''IMGIN'', ''Professional''),
(''InterWest Health PPO'', ''84137'', ''84137'', ''Institutional''),
(''InterWest Health PPO'', ''84137'', ''84137'', ''Professional''),
(''InTotal Health'', ''35115'', ''35115'', ''Institutional''),
(''InTotal Health'', ''35115'', ''35115'', ''Professional''),
(''Iowa Benefits, Inc. (IBI)'', ''41124'', ''41124'', ''Institutional''),
(''Iowa Benefits, Inc. (IBI)'', ''41124'', ''41124'', ''Professional''),
(''Iowa Total Care'', ''68069'', ''68069'', ''Institutional''),
(''Iowa Total Care'', ''68069'', ''68069'', ''Professional''),
(''IPA of Kane County'', ''IPAK1'', ''IPAK1'', ''Institutional''),
(''IPA of Kane County'', ''IPAK1'', ''IPAK1'', ''Professional''),
(''IPMG Claims Management Services (Insurance Program Managers Group)'', ''J1887'', ''J1887'', ''Institutional''),
(''IPMG Claims Management Services (Insurance Program Managers Group)'', ''J1887'', ''J1887'', ''Professional''),
(''Irex Corporation'', ''J1074'', ''J1074'', ''Institutional''),
(''Irex Corporation'', ''J1074'', ''J1074'', ''Professional''),
(''Ironworking Contract I.P.'', ''J1075'', ''J1075'', ''Institutional''),
(''Ironworking Contract I.P.'', ''J1075'', ''J1075'', ''Professional''),
(''Island Home Insurance Co - Staywell Guam'', ''85502'', ''85502'', ''Institutional''),
(''Island Home Insurance Co - Staywell Guam'', ''85502'', ''85502'', ''Professional''),
(''ISOL'', ''ISL11'', ''ISL11'', ''Professional''),
(''iSurity'', ''J1911'', ''J1911'', ''Professional''),
(''J B Hunt Transport Inc.'', ''A0138'', ''A0138'', ''Institutional''),
(''J B Hunt Transport Inc.'', ''A0138'', ''A0138'', ''Professional''),
(''J. F. Molloy and Associates, Inc.'', ''61271'', ''61271'', ''Professional''),
(''J.H. Mccormack Const'', ''41556'', ''41556'', ''Institutional''),
(''J.H. Mccormack Const'', ''41556'', ''41556'', ''Professional''),
(''Jai Medical Systems'', ''JAI01'', ''JAI01'', ''Institutional''),
(''Jai Medical Systems'', ''JAI01'', ''JAI01'', ''Professional''),
(''JD Mechanical'', ''41556'', ''41556'', ''Institutional''),
(''JD Mechanical'', ''41556'', ''41556'', ''Professional''),
(''Jefferson County Texas'', ''41556'', ''41556'', ''Institutional''),
(''Jefferson County Texas'', ''41556'', ''41556'', ''Professional''),
(''JI Specialty Services'', ''J1006'', ''J1006'', ''Institutional''),
(''JI Specialty Services'', ''J1006'', ''J1006'', ''Professional''),
(''JLS Family Enterprises (dba League Medical Concepts)'', ''JLSFE'', ''JLSFE'', ''Institutional''),
(''JLS Family Enterprises (dba League Medical Concepts)'', ''JLSFE'', ''JLSFE'', ''Professional''),
(''John Muir Health'', ''41556'', ''41556'', ''Institutional''),
(''John Muir Health'', ''41556'', ''41556'', ''Professional''),
(''John Muir Physician Network'', ''68036'', ''68036'', ''Professional''),
(''John P Pearl & Associates, Ltd'', ''37215'', ''37215'', ''Institutional''),
(''John P Pearl & Associates, Ltd'', ''37215'', ''37215'', ''Professional''),
(''Johns Hopkins Healthcare (USFHP)'', ''52123'', ''52123'', ''Institutional''),
(''Johns Hopkins Healthcare (USFHP)'', ''52123'', ''52123'', ''Professional''),
(''Johns Hopkins Healthcare - Priority Partners'', ''52189'', ''52189'', ''Institutional''),
(''Johns Hopkins Healthcare - Priority Partners'', ''52189'', ''52189'', ''Professional''),
(''Johnston Schools (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Johnston Schools (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Jones Truck Lines,Inc.'', ''J1076'', ''J1076'', ''Institutional''),
(''Jones Truck Lines,Inc.'', ''J1076'', ''J1076'', ''Professional''),
(''Joplin Claims'', ''43178'', ''43178'', ''Institutional''),
(''Joplin Claims'', ''43178'', ''43178'', ''Professional''),
(''JP Farley Corporation'', ''34136'', ''34136'', ''Institutional''),
(''JP Farley Corporation'', ''34136'', ''34136'', ''Professional''),
(''Judson ISD'', ''41556'', ''41556'', ''Institutional''),
(''Judson ISD'', ''41556'', ''41556'', ''Professional''),
(''Juvenile Jail Facility Managem'', ''J1077'', ''J1077'', ''Institutional''),
(''Juvenile Jail Facility Managem'', ''J1077'', ''J1077'', ''Professional''),
(''Kaiser Foundation Health Plan of Colorado'', ''91617'', ''91617'', ''Institutional''),
(''Kaiser Foundation Health Plan of Colorado'', ''91617'', ''91617'', ''Professional''),
(''Kaiser Foundation Health Plan of Georgia'', ''21313'', ''21313'', ''Institutional''),
(''Kaiser Foundation Health Plan of Georgia'', ''21313'', ''21313'', ''Professional''),
(''Kaiser Foundation Health Plan of Northern California'', ''94135'', ''94135'', ''Institutional''),
(''Kaiser Foundation Health Plan of Northern California'', ''94135'', ''94135'', ''Professional''),
(''Kaiser Foundation Health Plan of Southern California'', ''94134'', ''94134'', ''Institutional''),
(''Kaiser Foundation Health Plan of Southern California'', ''94134'', ''94134'', ''Professional''),
(''Kaiser Foundation Health Plan of the Mid-Atlantic States'', ''52095'', ''52095'', ''Institutional''),
(''Kaiser Foundation Health Plan of the Mid-Atlantic States'', ''52095'', ''52095'', ''Professional''),
(''Kaiser Foundation Health Plan of the Northwest'', ''93079'', ''93079'', ''Institutional''),
(''Kaiser Foundation Health Plan of the Northwest'', ''93079'', ''93079'', ''Professional''),
(''Kaiser Foundation Health Plan of Washington'', ''91051'', ''91051'', ''Institutional''),
(''Kaiser Foundation Health Plan of Washington'', ''91051'', ''91051'', ''Professional''),
(''Kaiser Permanente Health Plan of Hawaii'', ''94123'', ''94123'', ''Institutional''),
(''Kaiser Permanente Health Plan of Hawaii'', ''94123'', ''94123'', ''Professional''),
(''Kaiser Self Funded'', ''94320'', ''94320'', ''Institutional''),
(''Kaiser Self Funded'', ''94320'', ''94320'', ''Professional''),
(''Kalos Gold Health Plan'', ''61185'', ''61185'', ''Institutional''),
(''Kalos Gold Health Plan'', ''61185'', ''61185'', ''Professional''),
(''Kalos Health'', ''40137'', ''40137'', ''Institutional''),
(''Kalos Health'', ''40137'', ''40137'', ''Professional''),
(''Kane County IPA'', ''KCIPA'', ''KCIPA'', ''Institutional''),
(''Kane County IPA'', ''KCIPA'', ''KCIPA'', ''Professional''),
(''Kansas City Blue Cross Blue Shield, ASK'', ''47171'', ''47171'', ''Institutional''),
(''Kansas City Blue Cross Blue Shield, ASK'', ''47171'', ''47171'', ''Professional''),
(''Kansas Health Advantage'', ''71066'', ''71066'', ''Institutional''),
(''Kansas Health Advantage'', ''71066'', ''71066'', ''Professional''),
(''Kansas Superior Select'', ''71066'', ''71066'', ''Institutional''),
(''Kansas Superior Select'', ''71066'', ''71066'', ''Professional''),
(''Kautz Vinyards'', ''41556'', ''41556'', ''Institutional''),
(''Kautz Vinyards'', ''41556'', ''41556'', ''Professional''),
(''Kaweah Delta'', ''TKFMC'', ''TKFMC'', ''Professional''),
(''Kaweah Delta HC District Employee Plan'', ''IP085'', ''IP085'', ''Institutional''),
(''Kaweah Delta HC District Employee Plan'', ''IP085'', ''IP085'', ''Professional''),
(''Kaweah Delta Medicare Advantage'', ''IP084'', ''IP084'', ''Institutional''),
(''Kaweah Delta Medicare Advantage'', ''IP084'', ''IP084'', ''Professional''),
(''KCI Holdings USA'', ''J1078'', ''J1078'', ''Institutional''),
(''KCI Holdings USA'', ''J1078'', ''J1078'', ''Professional''),
(''Keenan & Associates'', ''KEE01'', ''KEE01'', ''Institutional''),
(''Keenan & Associates'', ''KEE01'', ''KEE01'', ''Professional''),
(''Keenan and Associates (See note for exclusions)'', ''J1498'', ''J1498'', ''Institutional''),
(''Keenan and Associates (See note for exclusions)'', ''J1498'', ''J1498'', ''Professional''),
(''Keenan Associates'', ''95279'', ''95279'', ''Institutional''),
(''Keenan Associates'', ''95279'', ''95279'', ''Professional''),
(''Kellogg Companies'', ''J1803'', ''J1803'', ''Institutional''),
(''Kellogg Companies'', ''J1803'', ''J1803'', ''Professional''),
(''Kelsey Seybold'', ''KELSE'', ''KELSE'', ''Professional''),
(''Kelsey Seybold'', ''KELSI'', ''KELSI'', ''Institutional''),
(''Kemper Benefits'', ''61453'', ''61453'', ''Institutional''),
(''Kemper Benefits'', ''61453'', ''61453'', ''Professional''),
(''Kemper Health (Reserve National Insurance Company)'', ''73066'', ''73066'', ''Institutional''),
(''Kemper Health (Reserve National Insurance Company)'', ''73066'', ''73066'', ''Professional''),
(''Kemper Preferred'', ''C1030'', ''C1030'', ''Institutional''),
(''Kemper Preferred'', ''C1030'', ''C1030'', ''Professional''),
(''Kempton Company'', ''73100'', ''73100'', ''Institutional''),
(''Kempton Company'', ''73100'', ''73100'', ''Professional''),
(''Kempton Group Administrators'', ''73100'', ''73100'', ''Institutional''),
(''Kempton Group Administrators'', ''73100'', ''73100'', ''Professional''),
(''Ken Davis Industries Inc.'', ''J1079'', ''J1079'', ''Institutional''),
(''Ken Davis Industries Inc.'', ''J1079'', ''J1079'', ''Professional''),
(''Kent County Health Plan'', ''KENT1'', ''KENT1'', ''Professional''),
(''Kentucky Health Administrators'', ''27215'', ''27215'', ''Professional''),
(''Kern County CDCR'', ''28021'', ''28021'', ''Professional''),
(''Kern Health Systems'', ''77039'', ''77039'', ''Institutional''),
(''Kern Health Systems'', ''77039'', ''77039'', ''Professional''),
(''Kern Legacy Health Plan'', ''89890'', ''89890'', ''Institutional''),
(''Kern Legacy Health Plan'', ''89890'', ''89890'', ''Professional''),
(''Kern Medical Center Health Plan'', ''KMCHP'', ''KMCHP'', ''Professional''),
(''Key Benefit Administrators'', ''37217'', ''37217'', ''Institutional''),
(''Key Benefit Administrators'', ''37217'', ''37217'', ''Professional''),
(''Key Benefit Solutions'', ''37323'', ''37323'', ''Institutional''),
(''Key Benefit Solutions'', ''37323'', ''37323'', ''Professional''),
(''Key Gap'', ''35317'', ''35317'', ''Institutional''),
(''Key Gap'', ''35317'', ''35317'', ''Professional''),
(''Key Health Medical Solutions, Inc'', ''95460'', ''95460'', ''Professional''),
(''Key Medical Group'', ''IP082'', ''IP082'', ''Institutional''),
(''Key Medical Group'', ''IP082'', ''IP082'', ''Professional''),
(''Key Medical Group - Medicare Advantage'', ''IP083'', ''IP083'', ''Institutional''),
(''Key Medical Group - Medicare Advantage'', ''IP083'', ''IP083'', ''Professional''),
(''Key Risk Management Services LLC'', ''J1521'', ''J1521'', ''Institutional''),
(''Key Risk Management Services LLC'', ''J1521'', ''J1521'', ''Professional''),
(''Key Select'', ''37321'', ''37321'', ''Institutional''),
(''Key Select'', ''37321'', ''37321'', ''Professional''),
(''KeyCare (MD)'', ''KCMD1'', ''KCMD1'', ''Institutional''),
(''KeyCare (MD)'', ''KCMD1'', ''KCMD1'', ''Professional''),
(''Keystone First Community Health Choices - Medicare Advantage'', ''42344'', ''42344'', ''Institutional''),
(''Keystone First Community Health Choices - Medicare Advantage'', ''42344'', ''42344'', ''Professional''),
(''Keystone First Health Plan'', ''23284'', ''23284'', ''Institutional''),
(''Keystone First Health Plan'', ''23284'', ''23284'', ''Professional''),
(''Keystone First VIP Choices'', ''77741'', ''77741'', ''Institutional''),
(''Keystone First VIP Choices'', ''77741'', ''77741'', ''Professional''),
(''Keystone Health Plan East'', ''95056'', ''95056'', ''Professional''),
(''King Pak Potato Company LLC'', ''41556'', ''41556'', ''Institutional''),
(''King Pak Potato Company LLC'', ''41556'', ''41556'', ''Professional''),
(''King Ranch'', ''41556'', ''41556'', ''Institutional''),
(''King Ranch'', ''41556'', ''41556'', ''Professional''),
(''Kirkland''''s, Inc.'', ''J1614'', ''J1614'', ''Institutional''),
(''Kirkland''''s, Inc.'', ''J1614'', ''J1614'', ''Professional''),
(''Klais & Company'', ''34145'', ''34145'', ''Institutional''),
(''Klais & Company'', ''34145'', ''34145'', ''Professional''),
(''Korean American Medical Group'', ''A0067'', ''PAPER'', ''Professional''),
(''Korean American Medical Group'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Korean American Medical Group'', ''HSM01'', ''HSM01'', ''Professional''),
(''KPIC (Kaiser Permanente Insurance Company)'', ''KPIC1'', ''KPIC1'', ''Institutional''),
(''KPIC (Kaiser Permanente Insurance Company)'', ''KPIC1'', ''KPIC1'', ''Professional''),
(''KTA Construction (COSD2)'', ''41556'', ''41556'', ''Institutional''),
(''KTA Construction (COSD2)'', ''41556'', ''41556'', ''Professional''),
(''L. Arrowhead C. Club'', ''41556'', ''41556'', ''Institutional''),
(''L. Arrowhead C. Club'', ''41556'', ''41556'', ''Professional''),
(''LACare Health Plan (Los Angeles)'', ''LACAR'', ''LACAR'', ''Institutional''),
(''LACare Health Plan (Los Angeles)'', ''LACAR'', ''LACAR'', ''Professional''),
(''LaCare Louisiana'', ''27357'', ''27357'', ''Institutional''),
(''LaCare Louisiana'', ''27357'', ''27357'', ''Professional''),
(''Laclede Chain'', ''41556'', ''41556'', ''Institutional''),
(''Laclede Chain'', ''41556'', ''41556'', ''Professional''),
(''Laclede Steel'', ''41556'', ''41556'', ''Institutional''),
(''Laclede Steel'', ''41556'', ''41556'', ''Professional''),
(''Lafayette Consolidated Government'', ''71037'', ''71037'', ''Professional''),
(''Lake Elsinore School District'', ''41556'', ''41556'', ''Institutional''),
(''Lake Elsinore School District'', ''41556'', ''41556'', ''Professional''),
(''Lakes Area Community Health Plan (LACH)'', ''52511'', ''52511'', ''Institutional''),
(''Lakes Area Community Health Plan (LACH)'', ''52511'', ''52511'', ''Professional''),
(''Lakeside Medical Group aka Regal Lakeside'', ''LMG01'', ''LMG01'', ''Institutional''),
(''Lakeside Medical Group aka Regal Lakeside'', ''LMG01'', ''LMG01'', ''Professional''),
(''Lakewood IPA'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Lakewood IPA'', ''LIPAZ'', ''LIPAZ'', ''Professional''),
(''Lamar Consolidated ISD'', ''41556'', ''41556'', ''Institutional''),
(''Lamar Consolidated ISD'', ''41556'', ''41556'', ''Professional''),
(''Lamesa ISD'', ''41556'', ''41556'', ''Institutional''),
(''Lamesa ISD'', ''41556'', ''41556'', ''Professional''),
(''Lancaster General Health (LGH)'', ''16109'', ''16109'', ''Institutional''),
(''Lancaster General Health (LGH)'', ''16109'', ''16109'', ''Professional''),
(''Landmark Golf Co'', ''41556'', ''41556'', ''Institutional''),
(''Landmark Golf Co'', ''41556'', ''41556'', ''Professional''),
(''Landmark Grad&Paving'', ''41556'', ''41556'', ''Institutional''),
(''Landmark Grad&Paving'', ''41556'', ''41556'', ''Professional''),
(''Landmark Healthcare'', ''LNDMK'', ''LNDMK'', ''Professional''),
(''Landry''''s'', ''J1889'', ''J1889'', ''Institutional''),
(''Landry''''s'', ''J1889'', ''J1889'', ''Professional''),
(''Landstar Bco Wc Program'', ''J1080'', ''J1080'', ''Institutional''),
(''Landstar Bco Wc Program'', ''J1080'', ''J1080'', ''Professional''),
(''Lane County'', ''41556'', ''41556'', ''Institutional''),
(''Lane County'', ''41556'', ''41556'', ''Professional''),
(''LaneCare'', ''LCMMH'', ''LCMMH'', ''Professional''),
(''LAPSIP (Los Angeles Physician Services for Indigents Program)'', ''MAP03'', ''MAP03'', ''Professional''),
(''Larimer County - WC'', ''41556'', ''41556'', ''Institutional''),
(''Larimer County - WC'', ''41556'', ''41556'', ''Professional''),
(''LaSalle Medical Associates (Network Medical Management) California'', ''NMM02'', ''NMM02'', ''Professional''),
(''Lasso Healthcare MSA'', ''10550'', ''10550'', ''Institutional''),
(''Lasso Healthcare MSA'', ''10550'', ''10550'', ''Professional''),
(''LB Auto/Pacific Part'', ''41556'', ''41556'', ''Institutional''),
(''LB Auto/Pacific Part'', ''41556'', ''41556'', ''Professional''),
(''LB Auto/Pacific Supp'', ''41556'', ''41556'', ''Institutional''),
(''LB Auto/Pacific Supp'', ''41556'', ''41556'', ''Professional''),
(''League of Minnesota Cities Insurance Trust'', ''J1527'', ''J1527'', ''Institutional''),
(''League of Minnesota Cities Insurance Trust'', ''J1527'', ''J1527'', ''Professional''),
(''Leisure World Managed Care'', ''LWMC1'', ''LWMC1'', ''Professional''),
(''Lekos Electric'', ''41556'', ''41556'', ''Institutional''),
(''Lekos Electric'', ''41556'', ''41556'', ''Professional''),
(''Leon Medical Center Plan -  Miami, Florida'', ''37316'', ''37316'', ''Institutional''),
(''Leon Medical Center Plan -  Miami, Florida'', ''37316'', ''37316'', ''Professional''),
(''Levin Enterprises, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Levin Enterprises, Inc.'', ''41556'', ''41556'', ''Professional''),
(''LFP Corporation'', ''J1650'', ''J1650'', ''Institutional''),
(''LFP Corporation'', ''J1650'', ''J1650'', ''Professional''),
(''LHS/MedCost Solutions, LLC (Liberty Healthshare)'', ''90753'', ''90753'', ''Professional''),
(''Liberty Advantage'', ''LIB01'', ''LIB01'', ''Institutional''),
(''Liberty Advantage'', ''LIB01'', ''LIB01'', ''Professional''),
(''Liberty Health Advantage'', ''87071'', ''87071'', ''Institutional''),
(''Liberty Health Advantage'', ''87071'', ''87071'', ''Professional''),
(''Liberty Mutual'', ''33600'', ''33600'', ''Institutional''),
(''Liberty Mutual'', ''33600'', ''33600'', ''Professional''),
(''Liberty Mutual Middle Markets'', ''33600'', ''33600'', ''Institutional''),
(''Liberty Mutual Middle Markets'', ''33600'', ''33600'', ''Professional''),
(''Liberty Northwest'', ''33600'', ''33600'', ''Institutional''),
(''Liberty Northwest'', ''33600'', ''33600'', ''Professional''),
(''Liberty Union'', ''37281'', ''37281'', ''Institutional''),
(''Liberty Union'', ''37281'', ''37281'', ''Professional''),
(''Liberty Wausau'', ''33600'', ''33600'', ''Institutional''),
(''Liberty Wausau'', ''33600'', ''33600'', ''Professional''),
(''Life and Health Insurance Company of America'', ''98205'', ''98205'', ''Institutional''),
(''Life and Health Insurance Company of America'', ''98205'', ''98205'', ''Professional''),
(''Life Assurance Company'', ''37281'', ''37281'', ''Institutional''),
(''Life Assurance Company'', ''37281'', ''37281'', ''Professional''),
(''Life Investors Insurance'', ''12T67'', ''12T67'', ''Institutional''),
(''Life Investors Insurance'', ''TH120'', ''TH120'', ''Professional''),
(''Life Investors Insurance of America - Long Term Care'', ''12T39'', ''12T39'', ''Institutional''),
(''Life Investors Insurance of America - Long Term Care'', ''TH093'', ''TH093'', ''Professional''),
(''LIFE Pittsburgh'', ''25181'', ''25181'', ''Institutional''),
(''LIFE Pittsburgh'', ''25181'', ''25181'', ''Professional''),
(''LIFE St. Mary - Trinity Health PACE'', ''TRNPC'', ''TRNPC'', ''Institutional''),
(''LIFE St. Mary - Trinity Health PACE'', ''TRNPC'', ''TRNPC'', ''Professional''),
(''Life Trac'', ''41136'', ''41136'', ''Institutional''),
(''Life Trac'', ''41136'', ''41136'', ''Professional''),
(''LifeCircles PACE'', ''71498'', ''71498'', ''Institutional''),
(''LifeCircles PACE'', ''71498'', ''71498'', ''Professional''),
(''LifeMap Assurance (formally Regence Life & Health)'', ''RLH01'', ''RLH01'', ''Institutional''),
(''LifeMap Assurance (formally Regence Life & Health)'', ''RLH01'', ''RLH01'', ''Professional''),
(''LifePath Hospice, Inc'', ''76870'', ''76870'', ''Institutional''),
(''LifePath Hospice, Inc'', ''76870'', ''76870'', ''Professional''),
(''Lifestyle Health Plans - Medova Healthcare'', ''27005'', ''27005'', ''Professional''),
(''Lifetime Benefit Solutions, Inc.'', ''16117'', ''16117'', ''Institutional''),
(''Lifetime Benefit Solutions, Inc.'', ''16117'', ''16117'', ''Professional''),
(''Lifetime Benefit Solutions, Inc.'', ''EBSRM'', ''EBSRM'', ''Institutional''),
(''Lifetime Benefit Solutions, Inc.'', ''EBSRM'', ''EBSRM'', ''Professional''),
(''LifeWise Health Plan of Oregon'', ''93093'', ''93093'', ''Institutional''),
(''LifeWise Health Plan of Oregon'', ''93093'', ''93093'', ''Professional''),
(''LifeWise Health Plan of Washington'', ''00430'', ''91049'', ''Institutional''),
(''LifeWise Health Plan of Washington'', ''91049'', ''91049'', ''Professional''),
(''LifeWorks Advantage (ISNP Plan)'', ''LWA01'', ''LWA01'', ''Institutional''),
(''LifeWorks Advantage (ISNP Plan)'', ''LWA01'', ''LWA01'', ''Professional''),
(''Lighthouse Health Plan'', ''31828'', ''31828'', ''Institutional''),
(''Lighthouse Health Plan'', ''31828'', ''31828'', ''Professional''),
(''LIPA/Agate Resources/Trillium'', ''68069'', ''68069'', ''Institutional''),
(''LIPA/Agate Resources/Trillium'', ''68069'', ''68069'', ''Professional''),
(''Livingston ISD'', ''41556'', ''41556'', ''Institutional''),
(''Livingston ISD'', ''41556'', ''41556'', ''Professional''),
(''Lk Arrowhead Co Club'', ''41556'', ''41556'', ''Institutional''),
(''Lk Arrowhead Co Club'', ''41556'', ''41556'', ''Professional''),
(''Local 135 Health Benefits Fund - Indianapolis, Indiana'', ''LO135'', ''PAPER'', ''Institutional''),
(''Local 135 Health Benefits Fund - Indianapolis, Indiana'', ''LO135'', ''PAPER'', ''Professional''),
(''Local 137 Operating Engineers Welfare Fund'', ''84041'', ''84041'', ''Institutional''),
(''Local 137 Operating Engineers Welfare Fund'', ''84041'', ''84041'', ''Professional''),
(''Lockard & Williams'', ''CB752'', ''CB752'', ''Institutional''),
(''Lockard & Williams'', ''CB752'', ''CB752'', ''Professional''),
(''Lodi Memorial Hospital'', ''41556'', ''41556'', ''Institutional''),
(''Lodi Memorial Hospital'', ''41556'', ''41556'', ''Professional''),
(''Loma Linda University Healthcare - Managed Care Claims'', ''33036'', ''33036'', ''Professional''),
(''Loma Linda University/Adventist Health System'', ''37267'', ''37267'', ''Institutional''),
(''Loma Linda University/Adventist Health System'', ''37267'', ''37267'', ''Professional''),
(''London Health Administrators'', ''LOND1'', ''PAPER'', ''Institutional''),
(''London Health Administrators'', ''LOND1'', ''PAPER'', ''Professional''),
(''Long Beach Memorial IPA (MHCLB)'', ''IP095'', ''MHIPA'', ''Professional''),
(''Long Beach Unified School District'', ''J1515'', ''J1515'', ''Institutional''),
(''Long Beach Unified School District'', ''J1515'', ''J1515'', ''Professional''),
(''Longevity Health Plan of Florida'', ''LFL01'', ''LFL01'', ''Institutional''),
(''Longevity Health Plan of Florida'', ''LFL01'', ''LFL01'', ''Professional''),
(''Longevity Health Plan of Illinois'', ''LIL01'', ''LIL01'', ''Institutional''),
(''Longevity Health Plan of Illinois'', ''LIL01'', ''LIL01'', ''Professional''),
(''Longevity Health Plan of New Jersey'', ''LNJ01'', ''LNJ01'', ''Institutional''),
(''Longevity Health Plan of New Jersey'', ''LNJ01'', ''LNJ01'', ''Professional''),
(''Longevity Health Plan of New York'', ''LNY01'', ''LNY01'', ''Institutional''),
(''Longevity Health Plan of New York'', ''LNY01'', ''LNY01'', ''Professional''),
(''Longevity Health Plan of Oklahoma'', ''LOK01'', ''LOK01'', ''Institutional''),
(''Longevity Health Plan of Oklahoma'', ''LOK01'', ''LOK01'', ''Professional''),
(''Longs Drugs (Bunch CareSolutions)'', ''J1464'', ''J1464'', ''Institutional''),
(''Longs Drugs (Bunch CareSolutions)'', ''J1464'', ''J1464'', ''Professional''),
(''Los Angeles Medical Center IPA'', ''PPM01'', ''PPM01'', ''Institutional''),
(''Los Angeles Medical Center IPA'', ''PPM01'', ''PPM01'', ''Professional''),
(''Louisiana Health Cooperative'', ''LAHC1'', ''PAPER'', ''Institutional''),
(''Louisiana Health Cooperative'', ''LAHC1'', ''PAPER'', ''Professional''),
(''Louisiana Healthcare Connections - Louisiana'', ''68069'', ''68069'', ''Institutional''),
(''Louisiana Healthcare Connections - Louisiana'', ''68069'', ''68069'', ''Professional''),
(''Louisiana State University'', ''J1953'', ''J1953'', ''Institutional''),
(''Louisiana State University'', ''J1953'', ''J1953'', ''Professional''),
(''Louisiana Workers'''' Compensation Corporation (LWCC)'', ''J1547'', ''J1547'', ''Institutional''),
(''Louisiana Workers'''' Compensation Corporation (LWCC)'', ''J1547'', ''J1547'', ''Professional''),
(''Lovelace Health Plan'', ''90328'', ''90328'', ''Institutional''),
(''Lovelace Health Plan'', ''90328'', ''90328'', ''Professional''),
(''Lovelace Sandia Health Plan'', ''90328'', ''90328'', ''Institutional''),
(''Lovelace Sandia Health Plan'', ''90328'', ''90328'', ''Professional''),
(''Lowe''''s (Bunch CareSolutions)'', ''J1465'', ''J1465'', ''Institutional''),
(''Lowe''''s (Bunch CareSolutions)'', ''J1465'', ''J1465'', ''Professional''),
(''Loyal American Life Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Institutional''),
(''Loyal American Life Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Professional''),
(''Lsg Sky Chefs International'', ''J1081'', ''J1081'', ''Institutional''),
(''Lsg Sky Chefs International'', ''J1081'', ''J1081'', ''Professional''),
(''Luba Casualty Insurance Company'', ''J1341'', ''J1341'', ''Institutional''),
(''Luba Casualty Insurance Company'', ''J1341'', ''J1341'', ''Professional''),
(''Lucent Health (fka North America Administrator, L.P.)'', ''65085'', ''65085'', ''Institutional''),
(''Lucent Health (fka North America Administrator, L.P.)'', ''65085'', ''65085'', ''Professional''),
(''Lumbermen''''s Underwriting Alliance'', ''J1540'', ''J1540'', ''Institutional''),
(''Lumbermen''''s Underwriting Alliance'', ''J1540'', ''J1540'', ''Professional''),
(''Lumbermen''''s Underwriting Alliance'', ''J1899'', ''J1899'', ''Institutional''),
(''Lumbermen''''s Underwriting Alliance'', ''J1899'', ''J1899'', ''Professional''),
(''Lynwood Unified School District (CA)'', ''J1669'', ''J1669'', ''Institutional''),
(''Lynwood Unified School District (CA)'', ''J1669'', ''J1669'', ''Professional''),
(''LYNX'', ''J1949'', ''J1949'', ''Institutional''),
(''LYNX'', ''J1949'', ''J1949'', ''Professional''),
(''Mabuhay Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Mabuhay Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''MacNeal Health Providers - Chicago Health Systems'', ''36334'', ''36334'', ''Professional''),
(''Macys  (Daly City)'', ''J1345'', ''J1345'', ''Institutional''),
(''Macys  (Daly City)'', ''J1345'', ''J1345'', ''Professional''),
(''Macys (Newport Beach)'', ''J1346'', ''J1346'', ''Institutional''),
(''Macys (Newport Beach)'', ''J1346'', ''J1346'', ''Professional''),
(''Macys Corporate Services Inc'', ''J1347'', ''J1347'', ''Institutional''),
(''Macys Corporate Services Inc'', ''J1347'', ''J1347'', ''Professional''),
(''Madera Community Hospital'', ''41556'', ''41556'', ''Institutional''),
(''Madera Community Hospital'', ''41556'', ''41556'', ''Professional''),
(''Maestro Health, fka Integra BMS'', ''56139'', ''56139'', ''Institutional''),
(''Maestro Health, fka Integra BMS'', ''56139'', ''56139'', ''Professional''),
(''Magellan Behavioral Health Services'', ''01260'', ''01260'', ''Institutional''),
(''Magellan Behavioral Health Services'', ''01260'', ''01260'', ''Professional''),
(''Magellan Complete Care Arizona'', ''MCC01'', ''MCC01'', ''Institutional''),
(''Magellan Complete Care Arizona'', ''MCC01'', ''MCC01'', ''Professional''),
(''Magellan Complete Care of Virginia'', ''MCCVA'', ''MCCVA'', ''Institutional''),
(''Magellan Complete Care of Virginia'', ''MCCVA'', ''MCCVA'', ''Professional''),
(''MagnaCare'', ''11303'', ''11303'', ''Institutional''),
(''MagnaCare'', ''11303'', ''11303'', ''Professional''),
(''Magnacare'', ''11303'', ''WCPAP'', ''Institutional''),
(''Magnacare'', ''11303'', ''WCPAP'', ''Professional''),
(''Magnolia Health Plan - Mississippi'', ''68069'', ''68069'', ''Institutional''),
(''Magnolia Health Plan - Mississippi'', ''68069'', ''68069'', ''Professional''),
(''Maine Community Health Options'', ''45341'', ''45341'', ''Institutional''),
(''Maine Community Health Options'', ''45341'', ''45341'', ''Professional''),
(''Major League Baseball 8'', ''J1082'', ''J1082'', ''Institutional''),
(''Major League Baseball 8'', ''J1082'', ''J1082'', ''Professional''),
(''MAMSI Life and Health Insurance Company (MLH)'', ''87726'', ''87726'', ''Institutional''),
(''MAMSI Life and Health Insurance Company (MLH)'', ''87726'', ''87726'', ''Professional''),
(''Managed Care Services, LLC'', ''35162'', ''35162'', ''Institutional''),
(''Managed Care Services, LLC'', ''35162'', ''35162'', ''Professional''),
(''Managed Care Systems'', ''MCS03'', ''MCS03'', ''Institutional''),
(''Managed Care Systems'', ''MCS03'', ''MCS03'', ''Professional''),
(''Managed Health Care Associates'', ''36312'', ''36312'', ''Institutional''),
(''Managed Health Care Associates'', ''36312'', ''36312'', ''Professional''),
(''Managed Health Networks (MHNet)'', ''22771'', ''22771'', ''Institutional''),
(''Managed Health Networks (MHNet)'', ''22771'', ''22771'', ''Professional''),
(''Managed Health Services - Indiana'', ''68069'', ''68069'', ''Institutional''),
(''Managed Health Services - Indiana'', ''68069'', ''68069'', ''Professional''),
(''Managed Health Services - Wisconsin'', ''68069'', ''68069'', ''Institutional''),
(''Managed Health Services - Wisconsin'', ''68069'', ''68069'', ''Professional''),
(''Manufacturers Alliance Insurance Company'', ''41556'', ''41556'', ''Institutional''),
(''Manufacturers Alliance Insurance Company'', ''41556'', ''41556'', ''Professional''),
(''MAPFRE Insurance'', ''C1086'', ''C1086'', ''Institutional''),
(''MAPFRE Insurance'', ''C1086'', ''C1086'', ''Professional''),
(''MAPFRE Life Insurance Co.'', ''46012'', ''46012'', ''Institutional''),
(''MAPFRE Life Insurance Co.'', ''46012'', ''46012'', ''Professional''),
(''March Vision Care'', ''52461'', ''52461'', ''Professional''),
(''Marcotte & Hearne'', ''41556'', ''41556'', ''Institutional''),
(''Marcotte & Hearne'', ''41556'', ''41556'', ''Professional''),
(''Maricopa County Community College District'', ''41556'', ''41556'', ''Institutional''),
(''Maricopa County Community College District'', ''41556'', ''41556'', ''Professional''),
(''Marion Health Services - CHW (Managed Care Systems)'', ''MCS03'', ''MCS03'', ''Institutional''),
(''Marion Health Services - CHW (Managed Care Systems)'', ''MCS03'', ''MCS03'', ''Professional''),
(''Mariposa County'', ''41556'', ''41556'', ''Institutional''),
(''Mariposa County'', ''41556'', ''41556'', ''Professional''),
(''Marrick Medical Finance'', ''20805'', ''20805'', ''Institutional''),
(''Marrick Medical Finance'', ''20805'', ''20805'', ''Professional''),
(''Martin''''s Point Health Care'', ''53275'', ''53275'', ''Institutional''),
(''Martin''''s Point Health Care'', ''53275'', ''53275'', ''Professional''),
(''Mary Washington Health Plan'', ''83269'', ''83269'', ''Institutional''),
(''Mary Washington Health Plan'', ''83269'', ''83269'', ''Professional''),
(''Maryland Casualty Company (Commercial Only)'', ''C1034'', ''C1034'', ''Institutional''),
(''Maryland Casualty Company (Commercial Only)'', ''C1034'', ''C1034'', ''Professional''),
(''Maryland Individual Practice Association, Inc. (MD IPA) - Maryland'', ''87726'', ''87726'', ''Institutional''),
(''Maryland Individual Practice Association, Inc. (MD IPA) - Maryland'', ''87726'', ''87726'', ''Professional''),
(''Maryland Physicians Care'', ''22348'', ''22348'', ''Institutional''),
(''Maryland Physicians Care'', ''22348'', ''22348'', ''Professional''),
(''Maryland Physicians Care'', ''76498'', ''76498'', ''Institutional''),
(''Maryland Physicians Care'', ''76498'', ''76498'', ''Professional''),
(''Mashantucket Pequot Tribal Nation'', ''37121'', ''37121'', ''Institutional''),
(''Mashantucket Pequot Tribal Nation'', ''37121'', ''37121'', ''Professional''),
(''Massachusetts Bay Insurance Company'', ''J1689'', ''J1689'', ''Institutional''),
(''Massachusetts Bay Insurance Company'', ''J1689'', ''J1689'', ''Professional''),
(''Massachusetts Mutual'', ''65935'', ''65935'', ''Professional''),
(''Masters, Mates and Pilots Plan'', ''MMPHB'', ''MMPHB'', ''Institutional''),
(''Masters, Mates and Pilots Plan'', ''MMPHB'', ''MMPHB'', ''Professional''),
(''Matagorda County'', ''41556'', ''41556'', ''Institutional''),
(''Matagorda County'', ''41556'', ''41556'', ''Professional''),
(''Matheson Trucking'', ''J1736'', ''J1736'', ''Institutional''),
(''Matheson Trucking'', ''J1736'', ''J1736'', ''Professional''),
(''Matrix Absence Management'', ''TP075'', ''TP075'', ''Institutional''),
(''Matrix Absence Management'', ''TP075'', ''TP075'', ''Professional''),
(''Max Specialty Benefits'', ''27320'', ''27320'', ''Professional''),
(''Maxim Crane Works'', ''J1083'', ''J1083'', ''Institutional''),
(''Maxim Crane Works'', ''J1083'', ''J1083'', ''Professional''),
(''Maxor Administrative Services'', ''92805'', ''92805'', ''Institutional''),
(''Maxor Administrative Services'', ''92805'', ''92805'', ''Professional''),
(''May Department Stores'', ''J1347'', ''J1347'', ''Institutional''),
(''May Department Stores'', ''J1347'', ''J1347'', ''Professional''),
(''Mayo Clinic FL/GA'', ''88090'', ''88090'', ''Institutional''),
(''Mayo Clinic FL/GA'', ''88090'', ''88090'', ''Professional''),
(''Mayo Clinic/Recovery and Claims Services'', ''41193'', ''41193'', ''Institutional''),
(''Mayo Clinic/Recovery and Claims Services'', ''41193'', ''41193'', ''Professional''),
(''MBA Benefit Administrators (UT)'', ''83028'', ''83028'', ''Institutional''),
(''MBA Benefit Administrators (UT)'', ''83028'', ''83028'', ''Professional''),
(''MBS (MedCost Benefit Services)'', ''56205'', ''56205'', ''Institutional''),
(''MBS (MedCost Benefit Services)'', ''56205'', ''56205'', ''Professional''),
(''Mc Donald''''S-Mcopco'', ''J1084'', ''J1084'', ''Institutional''),
(''Mc Donald''''S-Mcopco'', ''J1084'', ''J1084'', ''Professional''),
(''McKinley Medical Group (California)'', ''MHM02'', ''MHM02'', ''Professional''),
(''McLaren Advantage ( HMO SNP)'', ''3833R'', ''3833R'', ''Institutional''),
(''McLaren Advantage ( HMO SNP)'', ''3833R'', ''3833R'', ''Professional''),
(''McLaren Health Advantage'', ''3833A'', ''3833A'', ''Institutional''),
(''McLaren Health Advantage'', ''3833A'', ''3833A'', ''Professional''),
(''McLaren Health Plan - Commercial'', ''38338'', ''38338'', ''Institutional''),
(''McLaren Health Plan - Commercial'', ''38338'', ''38338'', ''Professional''),
(''McLaren Health Plan - MHP Medicaid'', ''3833C'', ''3833C'', ''Institutional''),
(''McLaren Health Plan - MHP Medicaid'', ''3833C'', ''3833C'', ''Professional''),
(''McLaren Health Plan - Northern Health Plan'', ''3833N'', ''3833N'', ''Institutional''),
(''McLaren Health Plan - Northern Health Plan'', ''3833N'', ''3833N'', ''Professional''),
(''MD - Individual Practice Association'', ''87726'', ''87726'', ''Institutional''),
(''MD - Individual Practice Association'', ''87726'', ''87726'', ''Professional''),
(''MD Anderson Physician Network'', ''MDAPN'', ''MDAPN'', ''Institutional''),
(''MD Anderson Physician Network'', ''MDAPN'', ''MDAPN'', ''Professional''),
(''MDSI Phys Group INC'', ''41556'', ''41556'', ''Institutional''),
(''MDSI Phys Group INC'', ''41556'', ''41556'', ''Professional''),
(''MDwise Healthy Indiana Plan (HIP)'', ''3135M'', ''3135M'', ''Institutional''),
(''MDwise Healthy Indiana Plan (HIP)'', ''3135M'', ''3135M'', ''Professional''),
(''MDWise Hoosier Healthwise'', ''3519M'', ''3519M'', ''Institutional''),
(''MDWise Hoosier Healthwise'', ''3519M'', ''3519M'', ''Professional''),
(''MDX Hawaii'', ''MDXHI'', ''MDXHI'', ''Institutional''),
(''MDX Hawaii'', ''MDXHI'', ''MDXHI'', ''Professional''),
(''Meadowbrook Insurance Group'', ''J1478'', ''J1478'', ''Institutional''),
(''Meadowbrook Insurance Group'', ''J1478'', ''J1478'', ''Professional''),
(''Med Pay'', ''88058'', ''88058'', ''Institutional''),
(''Med Pay'', ''88058'', ''88058'', ''Professional''),
(''Med Pay - Inter-Americas Insurance'', ''88058'', ''88058'', ''Institutional''),
(''Med Pay - Inter-Americas Insurance'', ''88058'', ''88058'', ''Professional''),
(''MedAdmin Solutions'', ''58204'', ''58204'', ''Professional''),
(''MedCom'', ''59231'', ''59231'', ''Institutional''),
(''MedCom'', ''59231'', ''59231'', ''Professional''),
(''Medcore Omni HP'', ''MDCOR'', ''MDCOR'', ''Institutional''),
(''Medcore Omni HP'', ''MDCOR'', ''MDCOR'', ''Professional''),
(''MedCost, Inc.'', ''56162'', ''56162'', ''Institutional''),
(''MedCost, Inc.'', ''56162'', ''56162'', ''Professional''),
(''MedDirect'', ''38353'', ''38353'', ''Professional''),
(''Medfocus'', ''95321'', ''95321'', ''Professional''),
(''Medica Health Care Plan'', ''78857'', ''78857'', ''Professional''),
(''Medica Health Plan - Choice'', ''94265'', ''94265'', ''Institutional''),
(''Medica Health Plan - Choice'', ''94265'', ''94265'', ''Professional''),
(''Medica Health Plan Solutions'', ''71890'', ''71890'', ''Institutional''),
(''Medica Health Plan Solutions'', ''71890'', ''71890'', ''Professional''),
(''Medica2 - Individual & Family'', ''12422'', ''12422'', ''Institutional''),
(''Medica2 - Individual & Family'', ''12422'', ''12422'', ''Professional''),
(''Medicaid - Alabama'', ''752548221'', ''ALMCD'', ''Institutional''),
(''Medicaid - Alabama'', ''752548221'', ''ALMCD'', ''Professional''),
(''Medicaid - Alaska'', ''12K86'', ''AKMCD'', ''Institutional''),
(''Medicaid - Alaska'', ''SKAK0'', ''AKMCD'', ''Professional''),
(''Medicaid - Arizona (AHCCCS)'', ''12K02'', ''AZMCD'', ''Institutional''),
(''Medicaid - Arizona (AHCCCS)'', ''AZMCD'', ''AZMCD'', ''Professional''),
(''Medicaid - Arkansas'', ''12023'', ''ARMCD'', ''Institutional''),
(''Medicaid - Arkansas'', ''716007869'', ''ARMCD'', ''Professional''),
(''Medicaid - California (Medi-Cal)'', ''610442'', ''CAMCD'', ''Institutional''),
(''Medicaid - California (Medi-Cal)'', ''610442'', ''CAMCD'', ''Professional''),
(''Medicaid - California (Medi-Cal) (CHDP only)'', ''610442'', ''CAMCC'', ''Professional''),
(''Medicaid - California (Medi-Cal) (CHDP only)'', ''CAMCC'', ''CAMCC'', ''Institutional''),
(''Medicaid - California (Medi-Cal) (Code Validation)'', ''CAMCK'', ''CAMCK'', ''Institutional''),
(''Medicaid - California (Medi-Cal) (FPACT - Family PACT)'', ''610442'', ''CAMCF'', ''Professional''),
(''Medicaid - California (Medi-Cal) (FPACT - Family PACT)'', ''CAMCF'', ''CAMCF'', ''Institutional''),
(''Medicaid - Colorado'', ''12K03'', ''COMCD'', ''Institutional''),
(''Medicaid - Colorado'', ''SKCO0'', ''COMCD'', ''Professional''),
(''Medicaid - Connecticut'', ''12K04'', ''CTMCD'', ''Institutional''),
(''Medicaid - Connecticut'', ''SKCT0'', ''CTMCD'', ''Professional''),
(''Medicaid - Delaware'', ''SKDE0'', ''DEMCD'', ''Professional''),
(''Medicaid - District of Columbia'', ''12001'', ''DCMCD'', ''Institutional''),
(''Medicaid - District of Columbia'', ''SKDC0'', ''DCMCD'', ''Professional''),
(''Medicaid - Florida'', ''12K34'', ''FLMCD'', ''Institutional''),
(''Medicaid - Florida'', ''77027'', ''FLMCD'', ''Professional''),
(''Medicaid - Georgia, HP'', ''12K05'', ''GAMCD'', ''Institutional''),
(''Medicaid - Georgia, HP'', ''77034'', ''GAMCD'', ''Professional''),
(''Medicaid - Hawaii'', ''HIMCD'', ''HIMCD'', ''Institutional''),
(''Medicaid - Hawaii'', ''SKHI0'', ''HIMCD'', ''Professional''),
(''Medicaid - Idaho'', ''IDMCD'', ''IDMCD'', ''Institutional''),
(''Medicaid - Idaho'', ''IDMCD'', ''IDMCD'', ''Professional''),
(''Medicaid - Illinois, IL Dept. of Health and Family Services'', ''00621'', ''ILMCD'', ''Institutional''),
(''Medicaid - Illinois, IL Dept. of Health and Family Services'', ''IL621'', ''ILMCD'', ''Professional''),
(''Medicaid - Indiana'', ''12K09'', ''INMCD'', ''Institutional''),
(''Medicaid - Indiana'', ''HP'', ''INMCD'', ''Professional''),
(''Medicaid - Iowa, Noridian'', ''12K10'', ''IAMCD'', ''Institutional''),
(''Medicaid - Iowa, Noridian'', ''18049'', ''IAMCD'', ''Professional''),
(''Medicaid - Kansas, HP'', ''47163'', ''KSMCD'', ''Institutional''),
(''Medicaid - Kansas, HP'', ''SKKS0'', ''KSMCD'', ''Professional''),
(''Medicaid - Kentucky'', ''12K11'', ''KYMCD'', ''Institutional''),
(''Medicaid - Kentucky'', ''SKKY0'', ''KYMCD'', ''Professional''),
(''Medicaid - Louisiana, Adult Day Health Care'', ''12K12'', ''LAMCC'', ''Institutional''),
(''Medicaid - Louisiana, Ambulance Transportation'', ''SKLA2'', ''LAMCT'', ''Professional''),
(''Medicaid - Louisiana, DME'', ''SKLA0'', ''LAMCM'', ''Professional''),
(''Medicaid - Louisiana, Home Health'', ''12K94'', ''LAMCH'', ''Institutional''),
(''Medicaid - Louisiana, LTC'', ''LAMCL'', ''LAMCL'', ''Institutional''),
(''Medicaid - Louisiana, Molina'', ''LAMCD'', ''LAMCD'', ''Institutional''),
(''Medicaid - Louisiana, Molina'', ''LAMCD'', ''LAMCD'', ''Professional''),
(''Medicaid - Louisiana, Non Emergency Transportation'', ''SKLA0'', ''LAMCN'', ''Professional''),
(''Medicaid - Louisiana, Rehabilitation'', ''SKLA4'', ''LAMCE'', ''Professional''),
(''Medicaid - Maine'', ''12K13'', ''MEMCD'', ''Institutional''),
(''Medicaid - Maine'', ''SKME0'', ''MEMCD'', ''Professional''),
(''Medicaid - Maryland, DHMH'', ''12007'', ''MDMCD'', ''Institutional''),
(''Medicaid - Maryland, DHMH'', ''526002033MCP'', ''MDMCD'', ''Professional''),
(''Medicaid - Massachusetts, MassHealth'', ''12K14'', ''MAMCD'', ''Institutional''),
(''Medicaid - Massachusetts, MassHealth'', ''SKMA0'', ''MAMCD'', ''Professional''),
(''Medicaid - Michigan Claims'', ''12K37'', ''MIMCD'', ''Institutional''),
(''Medicaid - Michigan Claims'', ''D00111'', ''MIMCD'', ''Professional''),
(''Medicaid - Michigan Encounters (MICare)'', ''D00111'', ''MIMHH'', ''Professional''),
(''Medicaid - Michigan Encounters (MICare)'', ''MIMHH'', ''MIMHH'', ''Institutional''),
(''Medicaid - Michigan Home Health Encounters (MICare)'', ''D00111'', ''MIMHH'', ''Professional''),
(''Medicaid - Michigan Home Health Encounters (MICare)'', ''MIMHH'', ''MIMHH'', ''Institutional''),
(''Medicaid - Michigan, BCCCP (Breast Cancer Cervical Cancer Prevention)'', ''D00111'', ''MIBCC'', ''Professional''),
(''Medicaid - Michigan, BCCCP (Breast Cancer Cervical Cancer Prevention)'', ''MIBCC'', ''MIBCC'', ''Institutional''),
(''Medicaid - Minnesota'', ''12K16'', ''MNMCD'', ''Institutional''),
(''Medicaid - Minnesota'', ''SKMN0'', ''MNMCD'', ''Professional''),
(''Medicaid - Mississippi'', ''12K17'', ''MSMCD'', ''Institutional''),
(''Medicaid - Mississippi'', ''MSCAID'', ''MSMCD'', ''Professional''),
(''Medicaid - Missouri'', ''12K15'', ''MOMCD'', ''Institutional''),
(''Medicaid - Missouri'', ''SKMO0'', ''MOMCD'', ''Professional''),
(''Medicaid - Montana'', ''12K77'', ''MTMCD'', ''Institutional''),
(''Medicaid - Montana'', ''SKMT0'', ''MTMCD'', ''Professional''),
(''Medicaid - Nebraska'', ''12K19'', ''NEMCD'', ''Institutional''),
(''Medicaid - Nebraska'', ''NEMEDICAID'', ''NEMCD'', ''Professional''),
(''Medicaid - Nevada'', ''DHCFP'', ''DHCFP'', ''Institutional''),
(''Medicaid - Nevada'', ''DHCFP'', ''DHCFP'', ''Professional''),
(''Medicaid - New Hampshire'', ''026000618'', ''NHMCD'', ''Professional''),
(''Medicaid - New Jersey'', ''NJMCD'', ''NJMCD'', ''Institutional''),
(''Medicaid - New Jersey'', ''NJMCD'', ''NJMCD'', ''Professional''),
(''Medicaid - New Mexico'', ''12K22'', ''NMMAD'', ''Institutional''),
(''Medicaid - New Mexico'', ''SKNM0'', ''NMMAD'', ''Professional''),
(''Medicaid - New York'', ''12K35'', ''NYMCD'', ''Institutional''),
(''Medicaid - New York'', ''SKNY0'', ''NYMCD'', ''Professional''),
(''Medicaid - North Carolina'', ''12K23'', ''NCMCD'', ''Institutional''),
(''Medicaid - North Carolina'', ''DNC00'', ''NCMCD'', ''Professional''),
(''Medicaid - North Carolina Health Choice'', ''12K23'', ''NCMCD'', ''Institutional''),
(''Medicaid - North Carolina Health Choice'', ''DNC00'', ''NCMCD'', ''Professional''),
(''Medicaid - North Dakota'', ''12K78'', ''NDMCD'', ''Institutional''),
(''Medicaid - North Dakota'', ''SKND0'', ''NDMCD'', ''Professional''),
(''Medicaid - Ohio'', ''12K24'', ''OHMCD'', ''Institutional''),
(''Medicaid - Ohio'', ''SKOH0'', ''OHMCD'', ''Professional''),
(''Medicaid - Oklahoma, SoonerCare'', ''12K25'', ''OKMCD'', ''Institutional''),
(''Medicaid - Oklahoma, SoonerCare'', ''731476619'', ''OKMCD'', ''Professional''),
(''Medicaid - Oregon, OHA'', ''12K41'', ''ORMCD'', ''Institutional''),
(''Medicaid - Oregon, OHA'', ''SKOR0'', ''ORMCD'', ''Professional''),
(''Medicaid - Pennsylvania'', ''000512'', ''PAMCD'', ''Professional''),
(''Medicaid - Pennsylvania'', ''12008'', ''PAMCD'', ''Institutional''),
(''Medicaid - Rhode Island'', ''SKRI0'', ''RIMCD'', ''Professional''),
(''Medicaid - South Carolina'', ''SCXIX'', ''SCXIX'', ''Professional''),
(''Medicaid - South Dakota'', ''12K36'', ''SDMCD'', ''Institutional''),
(''Medicaid - South Dakota'', ''SKSD0'', ''SDMCD'', ''Professional''),
(''Medicaid - Tennessee for TennCare Select and BlueCare Medicaid'', ''MC390'', ''TNXBC'', ''Institutional''),
(''Medicaid - Tennessee for TennCare Select and BlueCare Medicaid'', ''MC390'', ''TNXBC'', ''Professional''),
(''Medicaid - Texas, TMHP'', ''12K64'', ''TXMCD'', ''Institutional''),
(''Medicaid - Texas, TMHP'', ''617591011C21P'', ''TXMCD'', ''Professional''),
(''Medicaid - Texas, TMHP LTC'', ''617591011C21P'', ''TXLTC'', ''Professional''),
(''Medicaid - Texas, TMHP LTC'', ''TXLTC'', ''TXLTC'', ''Institutional''),
(''Medicaid - Utah Crossovers Only'', ''SKUT0'', ''UTMCC'', ''Professional''),
(''Medicaid - Utah Crossovers Only'', ''UTMCC'', ''UTMCC'', ''Institutional''),
(''Medicaid - Utah, UHIN'', ''SKUT0'', ''UTMCD'', ''Professional''),
(''Medicaid - Utah, UHIN'', ''UTMCD'', ''UTMCD'', ''Institutional''),
(''Medicaid - Vermont'', ''12K26'', ''VTMCD'', ''Institutional''),
(''Medicaid - Vermont'', ''SKVT0'', ''VTMCD'', ''Professional''),
(''Medicaid - Virginia'', ''SKVA0'', ''VAMCD'', ''Institutional''),
(''Medicaid - Virginia'', ''SKVA0'', ''VAMCD'', ''Professional''),
(''Medicaid - Washington'', ''12K27'', ''WAMCD'', ''Institutional''),
(''Medicaid - Washington'', ''77045'', ''WAMCD'', ''Professional''),
(''Medicaid - West Virginia, Molina'', ''12K28'', ''WVMCD'', ''Institutional''),
(''Medicaid - West Virginia, Molina'', ''SKWV0'', ''WVMCD'', ''Professional''),
(''Medicaid - Wisconsin'', ''WIMCD'', ''WIMCD'', ''Institutional''),
(''Medicaid - Wisconsin'', ''WIMCD'', ''WIMCD'', ''Professional''),
(''Medicaid - Wisconsin Chronic Disease Program (WCDP)'', ''SKWI0'', ''WICDP'', ''Professional''),
(''Medicaid - Wisconsin Chronic Disease Program (WCDP)'', ''WICDP'', ''WICDP'', ''Institutional''),
(''Medicaid - Wisconsin Well Woman Program (WWWP)'', ''SKWI0'', ''WIWWP'', ''Professional''),
(''Medicaid - Wisconsin Well Woman Program (WWWP)'', ''WIWWP'', ''WIWWP'', ''Institutional''),
(''Medicaid - Wyoming'', ''12K29'', ''WYMCD'', ''Institutional''),
(''Medicaid - Wyoming'', ''SKWY0'', ''WYMCD'', ''Professional''),
(''Medicaid - Louisiana, Medicare Advantage Part A'', ''LAMCI'', ''LAMCI'', ''Institutional''),
(''Medicaid - Louisiana, Medicare Advantage Part B'', ''LAMCB'', ''LAMCB'', ''Professional''),
(''Medical Associates Health Plan/Health Choices'', ''MAHC1'', ''MAHC1'', ''Institutional''),
(''Medical Associates Health Plan/Health Choices'', ''MAHC1'', ''MAHC1'', ''Professional''),
(''Medical Ben Admin'', ''41556'', ''41556'', ''Institutional''),
(''Medical Ben Admin'', ''41556'', ''41556'', ''Professional''),
(''Medical Benefits Administration'', ''MBA01'', ''MBADM'', ''Professional''),
(''Medical Benefits Administrators, Inc. - Newark, OH'', ''74323'', ''74323'', ''Institutional''),
(''Medical Benefits Administrators, Inc. - Newark, OH'', ''74323'', ''74323'', ''Professional''),
(''Medical Benefits Companies - Newark, OH'', ''74323'', ''74323'', ''Institutional''),
(''Medical Benefits Companies - Newark, OH'', ''74323'', ''74323'', ''Professional''),
(''Medical Benefits Mutual - Newark, Ohio'', ''74323'', ''74323'', ''Institutional''),
(''Medical Benefits Mutual - Newark, Ohio'', ''74323'', ''74323'', ''Professional''),
(''Medical Benefits Mutual Life Insurance Company'', ''74323'', ''74323'', ''Institutional''),
(''Medical Benefits Mutual Life Insurance Company'', ''74323'', ''74323'', ''Professional''),
(''Medical Card System,  Advantage (MCS Classicare) Puerto Rico'', ''L0170'', ''96197'', ''Institutional''),
(''Medical Card System,  Advantage (MCS Classicare) Puerto Rico'', ''L0170'', ''96197'', ''Professional''),
(''Medical Mutual'', ''29076'', ''29076'', ''Institutional''),
(''Medical Mutual'', ''29076'', ''29076'', ''Professional''),
(''Medical Mutual of Ohio'', ''29076'', ''29076'', ''Institutional''),
(''Medical Mutual of Ohio'', ''29076'', ''29076'', ''Professional''),
(''Medical Network of Colorado Springs'', ''CSMED'', ''CSMED'', ''Professional''),
(''Medical Reimbursements of America'', ''62177'', ''62177'', ''Institutional''),
(''Medical Reimbursements of America'', ''62177'', ''62177'', ''Professional''),
(''Medical Safety Net'', ''AMM02'', ''AMM02'', ''Institutional''),
(''Medical Safety Net'', ''AMM02'', ''AMM02'', ''Professional''),
(''Medical Services Initiative'', ''12057'', ''12057'', ''Institutional''),
(''Medical Services Initiative'', ''12057'', ''12057'', ''Professional''),
(''Medical Value Plan (MVP) Health Plan of Ohio'', ''38224'', ''38224'', ''Institutional''),
(''Medical Value Plan (MVP) Health Plan of Ohio'', ''38224'', ''38224'', ''Professional''),
(''Medicare - Alabama, Part A, Palmetto'', ''10111'', ''ALMCR'', ''Institutional''),
(''Medicare - Alabama, Part B, Palmetto'', ''10112'', ''ALMCR'', ''Professional''),
(''Medicare - Alaska, Part A, Noridian'', ''02001'', ''AKMCR'', ''Institutional''),
(''Medicare - Alaska, Part B, Noridian'', ''02102'', ''AKMCR'', ''Professional''),
(''Medicare - Arizona, Part A, Noridian'', ''03101'', ''AZMCR'', ''Institutional''),
(''Medicare - Arizona, Part B, Noridian'', ''03102'', ''AZMCR'', ''Professional''),
(''Medicare - Arkansas, Part A, Novitas'', ''07101'', ''ARMCR'', ''Institutional''),
(''Medicare - Arkansas, Part B, Novitas'', ''07102'', ''ARMCR'', ''Professional''),
(''Medicare - California, Northern, Part A, Noridian'', ''CAMCN'', ''CAMCN'', ''Institutional''),
(''Medicare - California, Northern, Part B, Noridian'', ''01112'', ''CAMCN'', ''Professional''),
(''Medicare - California, Southern, Part A, Noridian'', ''01111'', ''CAMCS'', ''Institutional''),
(''Medicare - California, Southern, Part B, Noridian'', ''01182'', ''CAMCS'', ''Professional''),
(''Medicare - Colorado, Part A, Novitas'', ''04111'', ''COMCR'', ''Institutional''),
(''Medicare - Colorado, Part B, Novitas'', ''04112'', ''COMCR'', ''Professional''),
(''Medicare - Connecticut, Part A, NGS'', ''13101'', ''CTMCR'', ''Institutional''),
(''Medicare - Connecticut, Part B, NGS'', ''13102'', ''CTMCR'', ''Professional''),
(''Medicare - Delaware, Part A, Novitas'', ''12101'', ''DEMCR'', ''Institutional''),
(''Medicare - Delaware, Part B, Novitas'', ''12102'', ''DEMCR'', ''Professional''),
(''Medicare - District of Columbia, Part A, Novitas Solutions'', ''12201'', ''DCMCR'', ''Institutional''),
(''Medicare - District of Columbia, Part B, Novitas Solutions'', ''12202'', ''DCMCR'', ''Professional''),
(''Medicare - DME Jurisdiction A, CEDI'', ''16013'', ''16013'', ''Professional''),
(''Medicare - DME Jurisdiction B, CEDI'', ''17013'', ''17013'', ''Professional''),
(''Medicare - DME Jurisdiction C, CEDI'', ''18003'', ''18003'', ''Professional''),
(''Medicare - DME Jurisdiction D, CEDI'', ''19003'', ''19003'', ''Professional''),
(''Medicare - Florida, Part A, First Coast Service Options (FCSO)'', ''09101'', ''FLMCR'', ''Institutional''),
(''Medicare - Florida, Part B, First Coast Service Options (FCSO)'', ''09102'', ''FLMCR'', ''Professional''),
(''Medicare - Georgia, Part A, Palmetto'', ''10211'', ''GAMCR'', ''Institutional''),
(''Medicare - Georgia, Part B, Palmetto'', ''10212'', ''GAMCR'', ''Professional''),
(''Medicare - Guam, Mariana Islands, AS, Part A, Noridian'', ''GUMCR'', ''GUMCR'', ''Institutional''),
(''Medicare - Guam, Mariana Islands, AS, Part B, Noridian'', ''01212'', ''GUMCR'', ''Professional''),
(''Medicare - Hawaii, Part A, Noridian'', ''01211'', ''HIMCR'', ''Institutional''),
(''Medicare - Hawaii, Part B, Noridian'', ''01212'', ''HIMCR'', ''Professional''),
(''Medicare - HHH, California'', ''06014'', ''06014'', ''Institutional''),
(''Medicare - HHH, CGS J15'', ''15004'', ''15004'', ''Institutional''),
(''Medicare - HHH, NGS JK Part A'', ''MEMCR'', ''MEMCR'', ''Institutional''),
(''Medicare - HHH, Palmetto'', ''SCMCR'', ''SCMCR'', ''Institutional''),
(''Medicare - Idaho, Part A, Noridian'', ''IDMCR'', ''IDMCR'', ''Institutional''),
(''Medicare - Idaho, Part B, Noridian'', ''02202'', ''IDMCR'', ''Professional''),
(''Medicare - Illinois, Part A, NGS'', ''06101'', ''ILMCR'', ''Institutional''),
(''Medicare - Illinois, Part B, NGS'', ''06102'', ''ILMCR'', ''Professional''),
(''Medicare - Indiana, Part A, WPS'', ''08101'', ''INMCR'', ''Institutional''),
(''Medicare - Indiana, Part B, WPS'', ''08102'', ''INMCR'', ''Professional''),
(''Medicare - Iowa, Part A, WPS'', ''05101'', ''IAMCR'', ''Institutional''),
(''Medicare - Iowa, Part B, WPS'', ''05102'', ''IAMCR'', ''Professional''),
(''Medicare - J04911 Part A, Novitas'', ''04911'', ''04911'', ''Institutional''),
(''Medicare - J1 Legacy Part A California'', ''J1LEG'', ''J1LEG'', ''Institutional''),
(''Medicare - J1 Legacy Part A Hawaii'', ''J1LEG'', ''J1LEG'', ''Institutional''),
(''Medicare - J1 Legacy Part A Nevada'', ''J1LEG'', ''J1LEG'', ''Institutional''),
(''Medicare - J5 National, WPS'', ''05901'', ''05901'', ''Institutional''),
(''Medicare - Kansas, Part A, WPS'', ''05201'', ''KSMCR'', ''Institutional''),
(''Medicare - Kansas, Part B, WPS'', ''05202'', ''KSMCR'', ''Professional''),
(''Medicare - Kentucky, Part A, CGS'', ''12M11'', ''KYMCR'', ''Institutional''),
(''Medicare - Kentucky, Part B, CGS'', ''15102'', ''KYMCR'', ''Professional''),
(''Medicare - Louisiana, Part A, Novitas'', ''07201'', ''LAMCR'', ''Institutional''),
(''Medicare - Louisiana, Part B, Novitas'', ''07202'', ''LAMCR'', ''Professional''),
(''Medicare - Maine, Part A, NGS'', ''14011'', ''MEMCR'', ''Institutional''),
(''Medicare - Maine, Part B, NGS'', ''14112'', ''MEMCR'', ''Professional''),
(''Medicare - Maryland, Part A, Novitas Solutions'', ''12301'', ''MDMCR'', ''Institutional''),
(''Medicare - Maryland, Part B, Novitas Solutions'', ''12302'', ''MDMCR'', ''Professional''),
(''Medicare - Massachusetts, Part A, NGS'', ''14211'', ''MAMCR'', ''Institutional''),
(''Medicare - Massachusetts, Part B, NGS'', ''14212'', ''MAMCR'', ''Professional''),
(''Medicare - Michigan, Part A, WPS'', ''08201'', ''MIMCR'', ''Institutional''),
(''Medicare - Michigan, Part B, WPS'', ''08202'', ''MIMCR'', ''Professional''),
(''Medicare - Minnesota, Part A, NGS'', ''06201'', ''MNMCR'', ''Institutional''),
(''Medicare - Minnesota, Part B, NGS'', ''06202'', ''MNMCR'', ''Professional''),
(''Medicare - Mississippi, Part A, Novitas'', ''07301'', ''MSMCR'', ''Institutional''),
(''Medicare - Mississippi, Part B, Novitas'', ''07302'', ''MSMCR'', ''Professional''),
(''Medicare - Missouri, Part A, WPS'', ''05301'', ''MOMCR'', ''Institutional''),
(''Medicare - Missouri, Part B, WPS'', ''05302'', ''MOMCR'', ''Professional''),
(''Medicare - Montana, Part A, Noridian'', ''03201'', ''MTMCR'', ''Institutional''),
(''Medicare - Montana, Part B, Noridian'', ''03202'', ''MTMCR'', ''Professional''),
(''Medicare - Nebraska, Part A, WPS'', ''05401'', ''NEMCR'', ''Institutional''),
(''Medicare - Nebraska, Part B, WPS'', ''05402'', ''NEMCR'', ''Professional''),
(''Medicare - Nevada, Part A, Noridian'', ''01311'', ''NVMCR'', ''Institutional''),
(''Medicare - Nevada, Part B, Noridian'', ''01312'', ''NVMCR'', ''Professional''),
(''Medicare - New Hampshire, Part B, NGS'', ''14312'', ''NHMCR'', ''Professional''),
(''Medicare - New Jersey, Part A, Novitas Solutions'', ''12401'', ''NJMCR'', ''Institutional''),
(''Medicare - New Jersey, Part B, Novitas Solutions'', ''12402'', ''NJMCR'', ''Professional''),
(''Medicare - New Mexico, Part A, Novitas'', ''04211'', ''NMMCR'', ''Institutional''),
(''Medicare - New Mexico, Part B, Novitas'', ''04212'', ''NMMCR'', ''Professional''),
(''Medicare - New York, Empire Downstate, Part B, NGS'', ''13202'', ''NYMRE'', ''Professional''),
(''Medicare - New York, Part A, NGS'', ''13201'', ''NYMCR'', ''Institutional''),
(''Medicare - New York, Queens, Part B, NGS'', ''13292'', ''NYMCQ'', ''Professional''),
(''Medicare - New York, Upstate, Part B, NGS'', ''13282'', ''NYMRU'', ''Professional''),
(''Medicare - North Carolina, Part A, Palmetto'', ''11501'', ''NCMCR'', ''Institutional''),
(''Medicare - North Carolina, Part B, Palmetto'', ''11502'', ''NCMCR'', ''Professional''),
(''Medicare - North Dakota, Part A, Noridian'', ''03301'', ''NDMCR'', ''Institutional''),
(''Medicare - North Dakota, Part B, Noridian'', ''03302'', ''NDMCR'', ''Professional''),
(''Medicare - Ohio, Part A, CGS'', ''12M24'', ''OHMCR'', ''Institutional''),
(''Medicare - Ohio, Part B, CGS'', ''15202'', ''OHMCR'', ''Professional''),
(''Medicare - Oklahoma, Part A, Novitas'', ''04311'', ''OKMCR'', ''Institutional''),
(''Medicare - Oklahoma, Part B, Novitas'', ''04312'', ''OKMCR'', ''Professional''),
(''Medicare - Oregon, Part A, Noridian'', ''ORMCR'', ''ORMCR'', ''Institutional''),
(''Medicare - Oregon, Part B, Noridian'', ''02302'', ''ORMCR'', ''Professional''),
(''Medicare - Pennsylvania, Part A, Novitas Solutions'', ''12501'', ''PAMCR'', ''Institutional''),
(''Medicare - Pennsylvania, Part B, Novitas Solutions'', ''12502'', ''PAMCR'', ''Professional''),
(''Medicare - Puerto Rico, Part A, FCSO'', ''09201'', ''PRMCR'', ''Institutional''),
(''Medicare - Puerto Rico, Part B, FCSO'', ''09202'', ''PRMCR'', ''Professional''),
(''Medicare - Railroad, Palmetto'', ''00882'', ''RRMCR'', ''Professional''),
(''Medicare - Rhode Island, Part B, NGS'', ''14412'', ''RIMCR'', ''Professional''),
(''Medicare - South Carolina, Part A, Palmetto'', ''11001'', ''SCMCR'', ''Institutional''),
(''Medicare - South Carolina, Part B, Palmetto'', ''11202'', ''SCMCR'', ''Professional''),
(''Medicare - South Dakota, Part A, Noridian'', ''03401'', ''SDMCR'', ''Institutional''),
(''Medicare - South Dakota, Part B, Noridian'', ''03402'', ''SDMCR'', ''Professional''),
(''Medicare - Tennessee, Part A, Palmetto'', ''10311'', ''TNMCR'', ''Institutional''),
(''Medicare - Tennessee, Part B, Palmetto'', ''10312'', ''TNMCR'', ''Professional''),
(''Medicare - Texas, Part A, Novitas'', ''04411'', ''TXMCR'', ''Institutional''),
(''Medicare - Texas, Part B, Novitas'', ''04412'', ''TXMCR'', ''Professional''),
(''Medicare - Utah, Part A, Noridian'', ''03501'', ''UTMCR'', ''Institutional''),
(''Medicare - Utah, Part B,  Noridian'', ''03502'', ''UTMCR'', ''Professional''),
(''Medicare - Vermont, Part A, NGS'', ''14013'', ''VTMCR'', ''Institutional''),
(''Medicare - Vermont, Part B, NGS'', ''14512'', ''VTMCR'', ''Professional''),
(''Medicare - Virgin Islands, Part A, FCSO'', ''VIMCR'', ''VIMCR'', ''Institutional''),
(''Medicare - Virgin Islands, Part B, FCSO'', ''09302'', ''VIMCR'', ''Professional''),
(''Medicare - Virginia, Part A, Palmetto'', ''11003'', ''VAMCR'', ''Institutional''),
(''Medicare - Virginia, Part B, Palmetto'', ''11302'', ''VAMCR'', ''Professional''),
(''Medicare - Washington, Part A, Noridian'', ''WAMCR'', ''WAMCR'', ''Institutional''),
(''Medicare - Washington, Part B, Noridian'', ''02402'', ''WAMCR'', ''Professional''),
(''Medicare - West Virginia, Part A, Palmetto'', ''WVMCR'', ''WVMCR'', ''Institutional''),
(''Medicare - West Virginia, Part B, Palmetto'', ''11402'', ''WVMCR'', ''Professional''),
(''Medicare - Wisconsin, Part A & (FQHC), NGS (00450)'', ''06001'', ''WIMCR'', ''Institutional''),
(''Medicare - Wisconsin, Part B, NGS'', ''06302'', ''WIMCR'', ''Professional''),
(''Medicare - Wyoming, Part A, Noridian'', ''03601'', ''WYMCR'', ''Institutional''),
(''Medicare - Wyoming, Part B, Noridian'', ''03602'', ''WYMCR'', ''Professional''),
(''Medicare - J12901 Part A, Novitas'', ''12901'', ''12901'', ''Institutional''),
(''Medicare and Much More of Florida'', ''MMMFL'', ''MMMFL'', ''Institutional''),
(''Medicare and Much More of Florida'', ''MMMFL'', ''MMMFL'', ''Professional''),
(''Medicare Y Mucho Mas (MMM)'', ''L0210'', ''MCMMM'', ''Professional''),
(''Medicina Familiar Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Medicina Familiar Medical Group (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Medico Insurance Co'', ''23160'', ''23160'', ''Institutional''),
(''Medico Insurance Co'', ''23160'', ''23160'', ''Professional''),
(''Medigold or Mt. Carmel Health Plan'', ''95655'', ''95655'', ''Institutional''),
(''Medigold or Mt. Carmel Health Plan'', ''95655'', ''95655'', ''Professional''),
(''Medigold PPO'', ''13123'', ''13123'', ''Institutional''),
(''Medigold PPO'', ''13123'', ''13123'', ''Professional''),
(''MedLogix MSO - Americo IPA'', ''MLAMR'', ''MLAMR'', ''Institutional''),
(''MedLogix MSO - Americo IPA'', ''MLAMR'', ''MLAMR'', ''Professional''),
(''Medova'', ''2700U'', ''2700U'', ''Institutional''),
(''Medova Bridgewell Health'', ''21322'', ''21322'', ''Institutional''),
(''Medova Bridgewell Health'', ''21322'', ''21322'', ''Professional''),
(''MedPartners'', ''412MP'', ''412MP'', ''Professional''),
(''MedPartners - Lutheran Preferred'', ''39198'', ''39198'', ''Professional''),
(''MedPartners - Three Rivers Preferred'', ''MP340'', ''MP340'', ''Professional''),
(''MedPartners Admin Services'', ''441MP'', ''441MP'', ''Professional''),
(''MedRisk'', ''J1956'', ''J1956'', ''Institutional''),
(''MedRisk'', ''J1956'', ''J1956'', ''Professional''),
(''MedStar Family Choice'', ''39190'', ''39190'', ''Institutional''),
(''MedStar Family Choice'', ''39190'', ''39190'', ''Professional''),
(''Medstar Family Choice - DC'', ''39190'', ''DCMED'', ''Professional''),
(''Medstar Family Choice - DC'', ''DCMED'', ''DCMED'', ''Institutional''),
(''MedStar Select/MedStar Medicare Choice'', ''251MS'', ''251MS'', ''Institutional''),
(''MedStar Select/MedStar Medicare Choice'', ''251MS'', ''251MS'', ''Professional''),
(''Meemic'', ''11983'', ''11983'', ''Institutional''),
(''Meemic'', ''11983'', ''11983'', ''Professional''),
(''Meijer Stores'', ''J1930'', ''J1930'', ''Institutional''),
(''Meijer Stores'', ''J1930'', ''J1930'', ''Professional''),
(''Member Select Insurance Company'', ''11983'', ''11983'', ''Institutional''),
(''Member Select Insurance Company'', ''11983'', ''11983'', ''Professional''),
(''MEMIC Casualty Company'', ''14164'', ''14164'', ''Institutional''),
(''MEMIC Casualty Company'', ''14164'', ''14164'', ''Professional''),
(''MEMIC Indemnity Company'', ''11030'', ''11030'', ''Institutional''),
(''MEMIC Indemnity Company'', ''11030'', ''11030'', ''Professional''),
(''Memorial Clinical Associates'', ''MCA11'', ''MCA11'', ''Professional''),
(''Memorial Health Services'', ''41556'', ''41556'', ''Institutional''),
(''Memorial Health Services'', ''41556'', ''41556'', ''Professional''),
(''Memorial Healthcare IPA'', ''IP095'', ''MHIPA'', ''Professional''),
(''Memorial Healthcare System'', ''59065'', ''59065'', ''Institutional''),
(''Memorial Healthcare System'', ''59065'', ''59065'', ''Professional''),
(''Memorial Hermann Health Network'', ''MHHNP'', ''MHHNP'', ''Institutional''),
(''Memorial Hermann Health Network'', ''MHHNP'', ''MHHNP'', ''Professional''),
(''MemorialCare Medical Foundatin-Capitation'', ''MMFCS'', ''MMFCS'', ''Institutional''),
(''MemorialCare Medical Foundatin-Capitation'', ''MMFCS'', ''MMFCS'', ''Professional''),
(''MemorialCare Medical Foundatin-UC Irvine Health'', ''MMFUC'', ''MMFUC'', ''Institutional''),
(''MemorialCare Medical Foundatin-UC Irvine Health'', ''MMFUC'', ''MMFUC'', ''Professional''),
(''MemorialCare Medical Group'', ''MMFMC'', ''MMFMC'', ''Professional''),
(''MemorialCare Select Health Plan'', ''46187'', ''46187'', ''Institutional''),
(''MemorialCare Select Health Plan'', ''46187'', ''46187'', ''Professional''),
(''Mendota Insurance Company'', ''33650'', ''33650'', ''Institutional''),
(''Mendota Insurance Company'', ''33650'', ''33650'', ''Professional''),
(''Mental Health Consultants Inc.'', ''37050'', ''37050'', ''Institutional''),
(''Mental Health Consultants Inc.'', ''37050'', ''37050'', ''Professional''),
(''Merchants Insurance Group'', ''C1095'', ''C1095'', ''Institutional''),
(''Merchants Insurance Group'', ''C1095'', ''C1095'', ''Professional''),
(''Mercury General Corporation'', ''J2277'', ''J2277'', ''Institutional''),
(''Mercury General Corporation'', ''J2277'', ''J2277'', ''Professional''),
(''Mercy Benefit Administrators'', ''37264'', ''37264'', ''Institutional''),
(''Mercy Benefit Administrators'', ''37264'', ''37264'', ''Professional''),
(''Mercy Care Plan (AHCCCS)'', ''86052'', ''86052'', ''Institutional''),
(''Mercy Care Plan (AHCCCS)'', ''86052'', ''86052'', ''Professional''),
(''Mercy Care Regional Behavioral Health Authority (RBHA)'', ''33628'', ''33628'', ''Institutional''),
(''Mercy Care Regional Behavioral Health Authority (RBHA)'', ''33628'', ''33628'', ''Professional''),
(''Mercy Physicians Medical Group (NAMM Southern CA)'', ''IP079'', ''IP079'', ''Institutional''),
(''Mercy Physicians Medical Group (NAMM Southern CA)'', ''IP079'', ''IP079'', ''Professional''),
(''MercyCare, Wisconsin'', ''39114'', ''39114'', ''Institutional''),
(''MercyCare, Wisconsin'', ''39114'', ''39114'', ''Professional''),
(''Meridian Construction Program'', ''41556'', ''41556'', ''Institutional''),
(''Meridian Construction Program'', ''41556'', ''41556'', ''Professional''),
(''Meridian Health Plan of Illinois, a WellCare Company'', ''13189'', ''13189'', ''Institutional''),
(''Meridian Health Plan of Illinois, a WellCare Company'', ''13189'', ''13189'', ''Professional''),
(''Meridian Health Plan of Iowa, a WellCare Company'', ''13189'', ''13189'', ''Institutional''),
(''Meridian Health Plan of Iowa, a WellCare Company'', ''13189'', ''13189'', ''Professional''),
(''Meridian Health Plan of Michigan, a WellCare Company'', ''83253'', ''83253'', ''Institutional''),
(''Meridian Health Plan of Michigan, a WellCare Company'', ''83253'', ''83253'', ''Professional''),
(''Meridian Health, a WellCare Company'', ''13189'', ''13189'', ''Institutional''),
(''Meridian Health, a WellCare Company'', ''13189'', ''13189'', ''Professional''),
(''Meridian Total'', ''68069'', ''68069'', ''Institutional''),
(''Meridian Total'', ''68069'', ''68069'', ''Professional''),
(''Meritage Corporation'', ''41556'', ''41556'', ''Institutional''),
(''Meritage Corporation'', ''41556'', ''41556'', ''Professional''),
(''Meritage Medical Network'', ''IP097'', ''IP097'', ''Professional''),
(''Meritain Health (previously known as E-V Benefits)'', ''41124'', ''41124'', ''Institutional''),
(''Meritain Health (previously known as E-V Benefits)'', ''41124'', ''41124'', ''Professional''),
(''Meritain Health (previously known as Weyco)'', ''41124'', ''41124'', ''Institutional''),
(''Meritain Health (previously known as Weyco)'', ''41124'', ''41124'', ''Professional''),
(''Meritain Health MN'', ''41124'', ''41124'', ''Institutional''),
(''Meritain Health MN'', ''41124'', ''41124'', ''Professional''),
(''Meritain Health/Agency Services Inc.'', ''64158'', ''64158'', ''Institutional''),
(''Meritain Health/Agency Services Inc.'', ''64158'', ''64158'', ''Professional''),
(''Meritain Health/North American Administrators'', ''64157'', ''64157'', ''Institutional''),
(''Meritain Health/North American Administrators'', ''64157'', ''64157'', ''Professional''),
(''Mesa County Colorado'', ''41556'', ''41556'', ''Institutional''),
(''Mesa County Colorado'', ''41556'', ''41556'', ''Professional''),
(''Mesa County Valley School District 51'', ''41556'', ''41556'', ''Institutional''),
(''Mesa County Valley School District 51'', ''41556'', ''41556'', ''Professional''),
(''Mesa Mental Health'', ''85035'', ''85035'', ''Institutional''),
(''Mesa Mental Health'', ''85035'', ''85035'', ''Professional''),
(''Metcare Health Plans'', ''65113'', ''65113'', ''Institutional''),
(''Metcare Health Plans'', ''65113'', ''65113'', ''Professional''),
(''Methodist First Choice'', ''23550'', ''23550'', ''Institutional''),
(''Methodist First Choice'', ''23550'', ''23550'', ''Professional''),
(''Metro Alliance'', ''82135'', ''82135'', ''Professional''),
(''MetroPlus Health Plan'', ''13265'', ''13265'', ''Institutional''),
(''MetroPlus Health Plan'', ''13265'', ''13265'', ''Professional''),
(''Metropolitan Council'', ''J1355'', ''J1355'', ''Institutional''),
(''Metropolitan Council'', ''J1355'', ''J1355'', ''Professional''),
(''Metropolitan Transit Authority'', ''J1238'', ''J1238'', ''Institutional''),
(''Metropolitan Transit Authority'', ''J1238'', ''J1238'', ''Professional''),
(''Metrowest Health Plan - Preferred Care'', ''MWP01'', ''MWP01'', ''Professional''),
(''Metrowest Star Medicaid'', ''TH069'', ''MWS01'', ''Professional''),
(''Mexicana Airlines'', ''41556'', ''41556'', ''Institutional''),
(''Mexicana Airlines'', ''41556'', ''41556'', ''Professional''),
(''MHLA (My Health Los Angeles) American Insurance Administrators'', ''MAP04'', ''MAP04'', ''Professional''),
(''Miami Children''''s Health Plan'', ''82832'', ''82832'', ''Institutional''),
(''Miami Children''''s Health Plan'', ''82832'', ''82832'', ''Professional''),
(''MIC General Insurance Corp.'', ''C1028'', ''C1028'', ''Institutional''),
(''MIC General Insurance Corp.'', ''C1028'', ''C1028'', ''Professional''),
(''MIC Property and Casualty Ins. Corp'', ''C1028'', ''C1028'', ''Institutional''),
(''MIC Property and Casualty Ins. Corp'', ''C1028'', ''C1028'', ''Professional''),
(''Michael Hogan Assoc'', ''41556'', ''41556'', ''Institutional''),
(''Michael Hogan Assoc'', ''41556'', ''41556'', ''Professional''),
(''Michigan Complete Health'', ''68069'', ''68069'', ''Institutional''),
(''Michigan Complete Health'', ''68069'', ''68069'', ''Professional''),
(''Micron Tech'', ''96598'', ''96598'', ''Professional''),
(''Mid Century Insurance Company (Commercial Only)'', ''C1034'', ''C1034'', ''Institutional''),
(''Mid Century Insurance Company (Commercial Only)'', ''C1034'', ''C1034'', ''Professional''),
(''Mid-America Associates, Inc.'', ''37281'', ''37281'', ''Institutional''),
(''Mid-America Associates, Inc.'', ''37281'', ''37281'', ''Professional''),
(''Mid-American Benefits'', ''22823'', ''22823'', ''Institutional''),
(''Mid-American Benefits'', ''22823'', ''22823'', ''Professional''),
(''Mid-County Physicians Medical Group'', ''SCP01'', ''SCP01'', ''Professional''),
(''MidCities IPA (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''MidCities IPA (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''MidCoast Care IPA - California'', ''77012'', ''77012'', ''Institutional''),
(''MidCoast Care IPA - California'', ''77012'', ''77012'', ''Professional''),
(''Midland National Insurance Company'', ''90956'', ''90956'', ''Institutional''),
(''Midland National Insurance Company'', ''90956'', ''90956'', ''Professional''),
(''Midlands Choice, Inc.'', ''47080'', ''47080'', ''Institutional''),
(''Midlands Choice, Inc.'', ''47080'', ''47080'', ''Professional''),
(''MidSouth Administrative Group'', ''62168'', ''62168'', ''Institutional''),
(''MidSouth Administrative Group'', ''62168'', ''62168'', ''Professional''),
(''Midwest Drywall (via EMC Risk Services)'', ''J1119'', ''J1119'', ''Institutional''),
(''Midwest Drywall (via EMC Risk Services)'', ''J1119'', ''J1119'', ''Professional''),
(''Midwest Family Mutual (Auto Only)'', ''C1051'', ''C1051'', ''Institutional''),
(''Midwest Family Mutual (Auto Only)'', ''C1051'', ''C1051'', ''Professional''),
(''Midwest Family Mutual Insurance Co (Work Comp Only)'', ''J1685'', ''J1685'', ''Institutional''),
(''Midwest Family Mutual Insurance Co (Work Comp Only)'', ''J1685'', ''J1685'', ''Professional''),
(''Midwest Group Benefits'', ''61146'', ''61146'', ''Professional''),
(''Midwest Health Partners'', ''76079'', ''76079'', ''Institutional''),
(''Midwest Health Partners'', ''76079'', ''76079'', ''Professional''),
(''Midwest Insurance'', ''10895'', ''10895'', ''Institutional''),
(''Midwest Insurance'', ''10895'', ''10895'', ''Professional''),
(''Midwest Physicians Administrative Services'', ''TH088'', ''TH088'', ''Professional''),
(''Millard Refrigerated'', ''J1482'', ''J1482'', ''Institutional''),
(''Millard Refrigerated'', ''J1482'', ''J1482'', ''Professional''),
(''Minnesota Counties Ins Trust (MCIT)'', ''J1351'', ''J1351'', ''Institutional''),
(''Minnesota Counties Ins Trust (MCIT)'', ''J1351'', ''J1351'', ''Professional''),
(''Minnesota Department of Labor & Industry - Claims Services & Investigations Unit'', ''J1436'', ''J1436'', ''Institutional''),
(''Minnesota Department of Labor & Industry - Claims Services & Investigations Unit'', ''J1436'', ''J1436'', ''Professional''),
(''Minnesota Dept of Health Sage & SagePlus Programs'', ''MNDH1'', ''MNDH1'', ''Institutional''),
(''Minnesota Dept of Health Sage & SagePlus Programs'', ''MNDH1'', ''MNDH1'', ''Professional''),
(''Minnesota Family Planning Program MFPP New PE'', ''MNCAD'', ''MNCAD'', ''Institutional''),
(''Minnesota Family Planning Program MFPP New PE'', ''MNCAD'', ''MNCAD'', ''Professional''),
(''Minnesota Family Planning Program MFPP Ongoing'', ''MNCAD'', ''MNCAD'', ''Institutional''),
(''Minnesota Family Planning Program MFPP Ongoing'', ''MNCAD'', ''MNCAD'', ''Professional''),
(''MIPS'', ''05018'', ''05018'', ''Professional''),
(''Mission Aviation Fellowship'', ''41556'', ''41556'', ''Institutional''),
(''Mission Aviation Fellowship'', ''41556'', ''41556'', ''Professional''),
(''Mission Community IPA Medical Group California'', ''PHM10'', ''PHM10'', ''Professional''),
(''Mission Lodge Sanitarium'', ''41556'', ''41556'', ''Institutional''),
(''Mission Lodge Sanitarium'', ''41556'', ''41556'', ''Professional''),
(''Mississippi Physicians Care Network (MPCN)'', ''64084'', ''64084'', ''Professional''),
(''Mississippi Public Entity Employee Benefit Trust (MPEEBT)'', ''37233'', ''37233'', ''Institutional''),
(''Mississippi Public Entity Employee Benefit Trust (MPEEBT)'', ''37233'', ''37233'', ''Professional''),
(''Mississippi Select Healthcare'', ''64088'', ''64088'', ''Institutional''),
(''Mississippi Select Healthcare'', ''64088'', ''64088'', ''Professional''),
(''Missoula Cart Co, In'', ''41556'', ''41556'', ''Institutional''),
(''Missoula Cart Co, In'', ''41556'', ''41556'', ''Professional''),
(''Missoula County Medical Benefits Plan'', ''37275'', ''37275'', ''Institutional''),
(''Missoula County Medical Benefits Plan'', ''37275'', ''37275'', ''Professional''),
(''Missouri Care (Encounters)'', ''59354'', ''59354'', ''Institutional''),
(''Missouri Care (Encounters)'', ''59354'', ''59354'', ''Professional''),
(''Missouri Care (FFS claims)'', ''14163'', ''14163'', ''Institutional''),
(''Missouri Care (FFS claims)'', ''14163'', ''14163'', ''Professional''),
(''Mitchell Energy & Devel'', ''J1085'', ''J1085'', ''Institutional''),
(''Mitchell Energy & Devel'', ''J1085'', ''J1085'', ''Professional''),
(''Mitsui Sumitomo Insurance Group - Toyota Claims Only'', ''J1692'', ''J1692'', ''Institutional''),
(''Mitsui Sumitomo Insurance Group - Toyota Claims Only'', ''J1692'', ''J1692'', ''Professional''),
(''Mitsui Sumitomo Insurance USA Inc. - Toyota Claim Only'', ''J1694'', ''J1694'', ''Institutional''),
(''Mitsui Sumitomo Insurance USA Inc. - Toyota Claim Only'', ''J1694'', ''J1694'', ''Professional''),
(''MLink'', ''37265'', ''37265'', ''Institutional''),
(''MLink'', ''37265'', ''37265'', ''Professional''),
(''MMIC'', ''J1622'', ''J1622'', ''Institutional''),
(''MMIC'', ''J1622'', ''J1622'', ''Professional''),
(''MMM Multi Health Government Health'', ''66065'', ''66065'', ''Institutional''),
(''MMM Multi Health Government Health'', ''66065'', ''66065'', ''Professional''),
(''Moda Health'', ''13350'', ''13350'', ''Institutional''),
(''Moda Health'', ''13350'', ''13350'', ''Professional''),
(''Modesto Irrigation District'', ''41556'', ''41556'', ''Institutional''),
(''Modesto Irrigation District'', ''41556'', ''41556'', ''Professional''),
(''Molina Health Plan of Kentucky - fka Passport'', ''61325'', ''61325'', ''Institutional''),
(''Molina Health Plan of Kentucky - fka Passport'', ''61325'', ''61325'', ''Professional''),
(''Molina Healthcare (Encounters)'', ''43174'', ''43174'', ''Professional''),
(''Molina Healthcare of California (Claims)'', ''38333'', ''38333'', ''Institutional''),
(''Molina Healthcare of California (Claims)'', ''38333'', ''38333'', ''Professional''),
(''Molina Healthcare of California (Encounters)'', ''33373'', ''33373'', ''Institutional''),
(''Molina Healthcare of California (Encounters)'', ''33373'', ''33373'', ''Professional''),
(''Molina Healthcare of Florida'', ''51062'', ''51062'', ''Institutional''),
(''Molina Healthcare of Florida'', ''51062'', ''51062'', ''Professional''),
(''Molina Healthcare of Idaho'', ''61799'', ''61799'', ''Institutional''),
(''Molina Healthcare of Idaho'', ''61799'', ''61799'', ''Professional''),
(''Molina Healthcare of Illinois'', ''20934'', ''20934'', ''Institutional''),
(''Molina Healthcare of Illinois'', ''20934'', ''20934'', ''Professional''),
(''Molina Healthcare of Michigan'', ''38334'', ''38334'', ''Institutional''),
(''Molina Healthcare of Michigan'', ''38334'', ''38334'', ''Professional''),
(''Molina Healthcare of Mississippi'', ''77010'', ''77010'', ''Institutional''),
(''Molina Healthcare of Mississippi'', ''77010'', ''77010'', ''Professional''),
(''Molina Healthcare of Nevada'', ''20676'', ''20676'', ''Institutional''),
(''Molina Healthcare of Nevada'', ''20676'', ''20676'', ''Professional''),
(''Molina Healthcare of New Mexico'', ''09824'', ''09824'', ''Institutional''),
(''Molina Healthcare of New Mexico'', ''09824'', ''09824'', ''Professional''),
(''Molina Healthcare of New York'', ''16146'', ''16146'', ''Professional''),
(''Molina Healthcare of Ohio'', ''20149'', ''20149'', ''Institutional''),
(''Molina Healthcare of Ohio'', ''20149'', ''20149'', ''Professional''),
(''Molina Healthcare of Puerto Rico'', ''81794'', ''81794'', ''Institutional''),
(''Molina Healthcare of Puerto Rico'', ''81794'', ''81794'', ''Professional''),
(''Molina Healthcare of South Carolina'', ''46299'', ''46299'', ''Institutional''),
(''Molina Healthcare of South Carolina'', ''46299'', ''46299'', ''Professional''),
(''Molina Healthcare of Texas'', ''20554'', ''20554'', ''Institutional''),
(''Molina Healthcare of Texas'', ''20554'', ''20554'', ''Professional''),
(''Molina Healthcare of Utah (American Family Care)'', ''SX109'', ''SX109'', ''Institutional''),
(''Molina Healthcare of Utah (American Family Care)'', ''SX109'', ''SX109'', ''Professional''),
(''Molina Healthcare of Virginia'', ''26176'', ''26176'', ''Institutional''),
(''Molina Healthcare of Virginia'', ''26176'', ''26176'', ''Professional''),
(''Molina Healthcare of Washington'', ''38336'', ''38336'', ''Institutional''),
(''Molina Healthcare of Washington'', ''38336'', ''38336'', ''Professional''),
(''Molina Healthcare of Wisconsin - Abri Health Plan'', ''ABRI1'', ''ABRI1'', ''Institutional''),
(''Molina Healthcare of Wisconsin - Abri Health Plan'', ''ABRI1'', ''ABRI1'', ''Professional''),
(''Momentum Health Services'', ''72135'', ''72135'', ''Professional''),
(''Monarch Healthcare IPA'', ''IP095'', ''IP095'', ''Institutional''),
(''Monarch Healthcare IPA'', ''IP095'', ''IP095'', ''Professional''),
(''Monitor Life Insurance Company'', ''16098'', ''16098'', ''Institutional''),
(''Monitor Life Insurance Company'', ''16098'', ''16098'', ''Professional''),
(''Montefiore Contract Management Organization'', ''13174'', ''13174'', ''Institutional''),
(''Montefiore Contract Management Organization'', ''13174'', ''13174'', ''Professional''),
(''Monterey Bay IPA'', ''MBIPA'', ''MBIPA'', ''Professional''),
(''Montgomery'', ''J1424'', ''J1424'', ''Institutional''),
(''Montgomery'', ''J1424'', ''J1424'', ''Professional''),
(''Montgomery County Self-Insurance Program (MD)'', ''J1890'', ''J1890'', ''Institutional''),
(''Montgomery County Self-Insurance Program (MD)'', ''J1890'', ''J1890'', ''Professional''),
(''Montgomery County Texas'', ''A0179'', ''A0179'', ''Institutional''),
(''Montgomery County Texas'', ''A0179'', ''A0179'', ''Professional''),
(''Monument Administrators - Cornerstone Comp'', ''J1530'', ''J1530'', ''Institutional''),
(''Monument Administrators - Cornerstone Comp'', ''J1530'', ''J1530'', ''Professional''),
(''Monument Administrators - Elite Country Club'', ''J1530'', ''J1530'', ''Institutional''),
(''Monument Administrators - Elite Country Club'', ''J1530'', ''J1530'', ''Professional''),
(''Monument Administrators - Guardian Comp'', ''J1530'', ''J1530'', ''Institutional''),
(''Monument Administrators - Guardian Comp'', ''J1530'', ''J1530'', ''Professional''),
(''Monument Administrators - Quality Comp'', ''J1530'', ''J1530'', ''Institutional''),
(''Monument Administrators - Quality Comp'', ''J1530'', ''J1530'', ''Professional''),
(''Monument Administrators - Victory Comp'', ''J1530'', ''J1530'', ''Institutional''),
(''Monument Administrators - Victory Comp'', ''J1530'', ''J1530'', ''Professional''),
(''Morongo Basin Transit Authority (CA)'', ''J1651'', ''J1651'', ''Institutional''),
(''Morongo Basin Transit Authority (CA)'', ''J1651'', ''J1651'', ''Professional''),
(''Morris Material Handling'', ''J1086'', ''J1086'', ''Institutional''),
(''Morris Material Handling'', ''J1086'', ''J1086'', ''Professional''),
(''Morrison Health Care, Inc.'', ''J1087'', ''J1087'', ''Institutional''),
(''Morrison Health Care, Inc.'', ''J1087'', ''J1087'', ''Professional''),
(''Motion Picture & Television Fund'', ''41556'', ''41556'', ''Institutional''),
(''Motion Picture & Television Fund'', ''41556'', ''41556'', ''Professional''),
(''Motion Picture Health Plan'', ''47198'', ''CABLC'', ''Institutional''),
(''Motion Picture Health Plan'', ''99282'', ''CABLC'', ''Professional''),
(''Motion Picture Industry'', ''47198'', ''CABLC'', ''Institutional''),
(''Motion Picture Industry'', ''99282'', ''CABLC'', ''Professional''),
(''Motivhealth - fka HSA Health Insurance'', ''U7632'', ''U7632'', ''Institutional''),
(''Motivhealth - fka HSA Health Insurance'', ''U7632'', ''U7632'', ''Professional''),
(''Motors Insurance Corporation'', ''C1028'', ''C1028'', ''Institutional''),
(''Motors Insurance Corporation'', ''C1028'', ''C1028'', ''Professional''),
(''MPE Services, Inc.'', ''37233'', ''37233'', ''Institutional''),
(''MPE Services, Inc.'', ''37233'', ''37233'', ''Professional''),
(''MPM Prospect'', ''MPM16'', ''MPM16'', ''Institutional''),
(''MPM Prospect'', ''MPM16'', ''MPM16'', ''Professional''),
(''MSA Care Guard'', ''20572'', ''20572'', ''Institutional''),
(''MSA Care Guard'', ''20572'', ''20572'', ''Professional''),
(''MTS'', ''J1641'', ''J1641'', ''Institutional''),
(''MTS'', ''J1641'', ''J1641'', ''Professional''),
(''Multicultural Primary Care Medical Group - San Diego (SynerMed)'', ''SYMED'', ''SYMED'', ''Professional''),
(''MultiPlan Health EOS - CAS - Wisconsin'', ''34080'', ''34080'', ''Institutional''),
(''MultiPlan Health EOS - CAS - Wisconsin'', ''34080'', ''34080'', ''Professional''),
(''Munford, Inc.'', ''J1088'', ''J1088'', ''Institutional''),
(''Munford, Inc.'', ''J1088'', ''J1088'', ''Professional''),
(''Municipal Health Benefit Plan'', ''81883'', ''81883'', ''Institutional''),
(''Municipal Health Benefit Plan'', ''81883'', ''81883'', ''Professional''),
(''Musco (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Musco (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Mutual Group  (US)'', ''59140'', ''59140'', ''Institutional''),
(''Mutual Group  (US)'', ''59140'', ''59140'', ''Professional''),
(''Mutual Health Services'', ''34192'', ''34192'', ''Institutional''),
(''Mutual Health Services'', ''34192'', ''34192'', ''Professional''),
(''Mutual of Omaha Insurance Co'', ''71412'', ''71412'', ''Institutional''),
(''Mutual of Omaha Insurance Co'', ''71412'', ''71412'', ''Professional''),
(''Mutually Preferred'', ''71412'', ''71412'', ''Institutional''),
(''Mutually Preferred'', ''71412'', ''71412'', ''Professional''),
(''MVP Health Care'', ''14165'', ''14165'', ''Institutional''),
(''MVP Health Care'', ''14165'', ''14165'', ''Professional''),
(''MyDecision HealthSmart'', ''18840'', ''18840'', ''Institutional''),
(''MyDecision HealthSmart'', ''18840'', ''18840'', ''Professional''),
(''MyNEXUS Anthem'', ''34009'', ''34009'', ''Institutional''),
(''MyNEXUS Anthem'', ''34009'', ''34009'', ''Professional''),
(''MyNEXUS, Aetna Medicare Advantage Texas'', ''34010'', ''34010'', ''Institutional''),
(''MyNEXUS, Aetna Medicare Advantage Texas'', ''34010'', ''34010'', ''Professional''),
(''N.W. Ironworkers Health & Security Trust Fund'', ''91136'', ''91136'', ''Institutional''),
(''N.W. Ironworkers Health & Security Trust Fund'', ''91136'', ''91136'', ''Professional''),
(''N.W. Roofers & Employers Health & Security Trust Fund'', ''91136'', ''91136'', ''Institutional''),
(''N.W. Roofers & Employers Health & Security Trust Fund'', ''91136'', ''91136'', ''Professional''),
(''N.W. Textile Processors'', ''91136'', ''91136'', ''Institutional''),
(''N.W. Textile Processors'', ''91136'', ''91136'', ''Professional''),
(''Nap Tools (via EMC Risk Services)'', ''J1120'', ''J1120'', ''Institutional''),
(''Nap Tools (via EMC Risk Services)'', ''J1120'', ''J1120'', ''Professional''),
(''Naperville Health Care Associates'', ''12T26'', ''NHCA1'', ''Institutional''),
(''Naperville Health Care Associates'', ''12T26'', ''NHCA1'', ''Professional''),
(''NaphCare'', ''58182'', ''58182'', ''Institutional''),
(''NaphCare'', ''58182'', ''58182'', ''Professional''),
(''Nascentia Health - fka VNA Homecare Options'', ''31626'', ''31626'', ''Institutional''),
(''Nascentia Health - fka VNA Homecare Options'', ''31626'', ''31626'', ''Professional''),
(''National Accident & Health General Agency Inc. (NAHGA)'', ''67788'', ''67788'', ''Institutional''),
(''National Accident & Health General Agency Inc. (NAHGA)'', ''67788'', ''67788'', ''Professional''),
(''National American Insurance Co (NAICO)'', ''J1695'', ''J1695'', ''Institutional''),
(''National American Insurance Co (NAICO)'', ''J1695'', ''J1695'', ''Professional''),
(''National Association of Letter Carriers / NALC'', ''53011'', ''53011'', ''Institutional''),
(''National Association of Letter Carriers / NALC'', ''53011'', ''53011'', ''Professional''),
(''National Capital Preferred Provider Organization (NCPPO)'', ''90001'', ''90001'', ''Professional''),
(''National Casualty Company'', ''J1551'', ''J1551'', ''Institutional''),
(''National Casualty Company'', ''J1551'', ''J1551'', ''Professional''),
(''National Claim Administration, Inc.'', ''37126'', ''37126'', ''Institutional''),
(''National Claim Administration, Inc.'', ''37126'', ''37126'', ''Professional''),
(''National Farmers Union Property and Casualty Company - QBE DBA'', ''J1484'', ''J1484'', ''Institutional''),
(''National Farmers Union Property and Casualty Company - QBE DBA'', ''J1484'', ''J1484'', ''Professional''),
(''National Finance Insurance Company'', ''90956'', ''90956'', ''Institutional''),
(''National Finance Insurance Company'', ''90956'', ''90956'', ''Professional''),
(''National Foundation Life Insurance Company'', ''98205'', ''98205'', ''Institutional''),
(''National Foundation Life Insurance Company'', ''98205'', ''98205'', ''Professional''),
(''National General Insurance Online, Inc. Formerly GMAC Insurance Company Online, Inc.'', ''C1028'', ''C1028'', ''Institutional''),
(''National General Insurance Online, Inc. Formerly GMAC Insurance Company Online, Inc.'', ''C1028'', ''C1028'', ''Professional''),
(''National General Insurance Online, Inc. Formerly GMAC Insurance Management Corporation'', ''C1028'', ''C1028'', ''Institutional''),
(''National General Insurance Online, Inc. Formerly GMAC Insurance Management Corporation'', ''C1028'', ''C1028'', ''Professional''),
(''National Guardian Life Insurance'', ''87020'', ''87020'', ''Institutional''),
(''National Guardian Life Insurance'', ''87020'', ''87020'', ''Professional''),
(''National Imaging Association'', ''SX190'', ''SX190'', ''Professional''),
(''National Jewish Health'', ''41556'', ''41556'', ''Institutional''),
(''National Jewish Health'', ''41556'', ''41556'', ''Professional''),
(''National Liability and Fire Insurance Company (DOI on or after 7/1/2014)'', ''J1453'', ''J1453'', ''Institutional''),
(''National Liability and Fire Insurance Company (DOI on or after 7/1/2014)'', ''J1453'', ''J1453'', ''Professional''),
(''National Loss Prevention, Inc'', ''J1021'', ''J1021'', ''Institutional''),
(''National Loss Prevention, Inc'', ''J1021'', ''J1021'', ''Professional''),
(''National Teachers Associates (NTA)'', ''NTA11'', ''NTA11'', ''Professional''),
(''National Telecommunications Cooperative Association (NTCA)'', ''52103'', ''52103'', ''Institutional''),
(''National Telecommunications Cooperative Association (NTCA)'', ''52103'', ''52103'', ''Professional''),
(''National Telecommunications Cooperative Association (NTCA/SMC)'', ''52120'', ''52120'', ''Institutional''),
(''National Telecommunications Cooperative Association (NTCA/SMC)'', ''52120'', ''52120'', ''Professional''),
(''National Telecommunications Cooperative Association Staff (NTCA- Staff)'', ''52104'', ''52104'', ''Institutional''),
(''National Telecommunications Cooperative Association Staff (NTCA- Staff)'', ''52104'', ''52104'', ''Professional''),
(''Nationwide Affinity Ins Co Of America (NAICOA)'', ''J1552'', ''J1552'', ''Institutional''),
(''Nationwide Affinity Ins Co Of America (NAICOA)'', ''J1552'', ''J1552'', ''Professional''),
(''Nationwide Agribusiness Companies'', ''J1551'', ''J1551'', ''Institutional''),
(''Nationwide Agribusiness Companies'', ''J1551'', ''J1551'', ''Professional''),
(''Nationwide Agribusiness Ins Co'', ''J1551'', ''J1551'', ''Institutional''),
(''Nationwide Agribusiness Ins Co'', ''J1551'', ''J1551'', ''Professional''),
(''Nationwide Ins Co Of America (NICOA)'', ''J1552'', ''J1552'', ''Institutional''),
(''Nationwide Ins Co Of America (NICOA)'', ''J1552'', ''J1552'', ''Professional''),
(''Nationwide Insurance Companies'', ''J1552'', ''J1552'', ''Institutional''),
(''Nationwide Insurance Companies'', ''J1552'', ''J1552'', ''Professional''),
(''Nationwide Mutual Fire Co'', ''J1552'', ''J1552'', ''Institutional''),
(''Nationwide Mutual Fire Co'', ''J1552'', ''J1552'', ''Professional''),
(''Nationwide Mutual Insurance Company'', ''J1552'', ''J1552'', ''Institutional''),
(''Nationwide Mutual Insurance Company'', ''J1552'', ''J1552'', ''Professional''),
(''Nationwide Property And Casualty Ins Co'', ''J1552'', ''J1552'', ''Institutional''),
(''Nationwide Property And Casualty Ins Co'', ''J1552'', ''J1552'', ''Professional''),
(''Native Care Health'', ''19191'', ''19191'', ''Institutional''),
(''Native Care Health'', ''19191'', ''19191'', ''Professional''),
(''NBC Universal'', ''J1359'', ''J1359'', ''Professional''),
(''NCLM - North Carolina League of Municipalities'', ''J1772'', ''J1772'', ''Institutional''),
(''NCLM - North Carolina League of Municipalities'', ''J1772'', ''J1772'', ''Professional''),
(''Nebraska Total Care'', ''68069'', ''68069'', ''Institutional''),
(''Nebraska Total Care'', ''68069'', ''68069'', ''Professional''),
(''Neighborhood Health Partnership (FL)'', ''95123'', ''95123'', ''Institutional''),
(''Neighborhood Health Partnership (FL)'', ''95123'', ''95123'', ''Professional''),
(''Neighborhood Health Partnership (FL)'', ''96107'', ''96107'', ''Institutional''),
(''Neighborhood Health Partnership (FL)'', ''96107'', ''96107'', ''Professional''),
(''Neighborhood Health Plan of Rhode Island'', ''05047'', ''05047'', ''Professional''),
(''Neighborhood Health Plan of Rhode Island - Exchange, Unity, Integrity'', ''96240'', ''96240'', ''Institutional''),
(''Neighborhood Health Plan of Rhode Island - Exchange, Unity, Integrity'', ''96240'', ''96240'', ''Professional''),
(''Nesika Health Group'', ''75280'', ''75280'', ''Institutional''),
(''Nesika Health Group'', ''75280'', ''75280'', ''Professional''),
(''Netcare Life and Health Insurance - Hagatna, Guam'', ''66055'', ''66055'', ''Institutional''),
(''Netcare Life and Health Insurance - Hagatna, Guam'', ''66055'', ''66055'', ''Professional''),
(''Network Health Insurance Corp - Medicare'', ''77076'', ''77076'', ''Institutional''),
(''Network Health Insurance Corp - Medicare'', ''77076'', ''77076'', ''Professional''),
(''Network Health Plan of Wisconsin'', ''39144'', ''39144'', ''Institutional''),
(''Network Health Plan of Wisconsin'', ''39144'', ''39144'', ''Professional''),
(''Network Medical Management (CA)'', ''NMM01'', ''NMM01'', ''Professional''),
(''Network Solutions IPA'', ''NSIPA'', ''NSIPA'', ''Institutional''),
(''Network Solutions IPA'', ''NSIPA'', ''NSIPA'', ''Professional''),
(''New Avenues, Inc'', ''95998'', ''95998'', ''Professional''),
(''New Century Health - CarePlus - Cardiology'', ''NCHCA'', ''NCHCA'', ''Professional''),
(''New Century Health - CarePlus - Oncology'', ''NCHON'', ''NCHON'', ''Professional''),
(''New Century Health - CarePlus - Urology'', ''NCH03'', ''NCHUR'', ''Professional''),
(''New Directions Behavioral Health (NDBH)'', ''NDX99'', ''NDX99'', ''Institutional''),
(''New Directions Behavioral Health (NDBH)'', ''NDX99'', ''NDX99'', ''Professional''),
(''New Era Life - Employee Benefit Plans'', ''96396'', ''96396'', ''Institutional''),
(''New Era Life - Employee Benefit Plans'', ''96396'', ''96396'', ''Professional''),
(''New Era Life Insurance Company'', ''98798'', ''98798'', ''Institutional''),
(''New Era Life Insurance Company'', ''98798'', ''98798'', ''Professional''),
(''New Jersey Manufacturing'', ''12122'', ''12122'', ''Institutional''),
(''New Jersey Manufacturing'', ''12122'', ''12122'', ''Professional''),
(''New Jersey Manufacturing - Auto Only'', ''C1048'', ''C1048'', ''Institutional''),
(''New Jersey Manufacturing - Auto Only'', ''C1048'', ''C1048'', ''Professional''),
(''New Jersey Skyland'', ''11303'', ''WCPAP'', ''Institutional''),
(''New Jersey Skyland'', ''11303'', ''WCPAP'', ''Professional''),
(''New Koosharem Corporation/Select Staffing (DOI after 7/31/2014)'', ''J1875'', ''J1875'', ''Institutional''),
(''New Koosharem Corporation/Select Staffing (DOI after 7/31/2014)'', ''J1875'', ''J1875'', ''Professional''),
(''New Life Medical Group dba Healthy New Life Medical Corp'', ''HSM01'', ''HSM01'', ''Institutional''),
(''New Life Medical Group dba Healthy New Life Medical Corp'', ''HSM01'', ''HSM01'', ''Professional''),
(''New Mexico Health Connections'', ''451NM'', ''451NM'', ''Institutional''),
(''New Mexico Health Connections'', ''451NM'', ''451NM'', ''Professional''),
(''New South Insurance Co.'', ''C1028'', ''C1028'', ''Institutional''),
(''New South Insurance Co.'', ''C1028'', ''C1028'', ''Professional''),
(''New York Hotel Fund'', ''7707C'', ''NY770'', ''Professional''),
(''New York Life - LTC'', ''NYL11'', ''NYL11'', ''Institutional''),
(''New York Life - LTC'', ''NYL11'', ''NYL11'', ''Professional''),
(''New York Network Management'', ''11334'', ''11334'', ''Professional''),
(''Nexus Health Medical Group'', ''NEX01'', ''NEX01'', ''Institutional''),
(''Nexus Health Medical Group'', ''NEX01'', ''NEX01'', ''Professional''),
(''Nippon Life Insurance Company of America'', ''81264'', ''81264'', ''Institutional''),
(''Nippon Life Insurance Company of America'', ''81264'', ''81264'', ''Professional''),
(''Nivano Physicians IPA'', ''MBA01'', ''MBA01'', ''Professional''),
(''NJ Property-Liability Ins Guaranty Assoc. NJPLIGA'', ''J3926'', ''J3926'', ''Institutional''),
(''NJ Property-Liability Ins Guaranty Assoc. NJPLIGA'', ''J3926'', ''J3926'', ''Professional''),
(''Noble AMA Select IPA'', ''PDT01'', ''PDT01'', ''Institutional''),
(''Noble AMA Select IPA'', ''PDT01'', ''PDT01'', ''Professional''),
(''Noble Community Medical Associates LA'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Noble Community Medical Associates LA'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Noble Mid Orange - HealthSmart (California)'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Noble Mid Orange - HealthSmart (California)'', ''HSM01'', ''HSM01'', ''Professional''),
(''Nonprofit Insurance Trust'', ''J1845'', ''J1845'', ''Institutional''),
(''Nonprofit Insurance Trust'', ''J1845'', ''J1845'', ''Professional''),
(''Nordstrom, Inc.'', ''J1360'', ''J1360'', ''Professional''),
(''Norfolk & Dedham Group'', ''C1096'', ''C1096'', ''Institutional''),
(''Norfolk & Dedham Group'', ''C1096'', ''C1096'', ''Professional''),
(''NorGUARD Insurance Company - Guard DBA'', ''J1453'', ''J1453'', ''Institutional''),
(''NorGUARD Insurance Company - Guard DBA'', ''J1453'', ''J1453'', ''Professional''),
(''North American Administrators, Inc.'', ''64157'', ''64157'', ''Institutional''),
(''North American Administrators, Inc.'', ''64157'', ''64157'', ''Professional''),
(''North American Benefits Network (NABN)'', ''41124'', ''41124'', ''Institutional''),
(''North American Benefits Network (NABN)'', ''41124'', ''41124'', ''Professional''),
(''North American Health Plan'', ''64157'', ''64157'', ''Institutional''),
(''North American Health Plan'', ''64157'', ''64157'', ''Professional''),
(''North Bay Schools Insurance Authority (NBSIA)'', ''J1549'', ''J1549'', ''Institutional''),
(''North Bay Schools Insurance Authority (NBSIA)'', ''J1549'', ''J1549'', ''Professional''),
(''North Broward Hospital District'', ''37314'', ''37314'', ''Institutional''),
(''North Broward Hospital District'', ''37314'', ''37314'', ''Professional''),
(''North Carolina Farm Bureau'', ''J1825'', ''J1825'', ''Institutional''),
(''North Carolina Farm Bureau'', ''J1825'', ''J1825'', ''Professional''),
(''North Clackamas School District #12'', ''41556'', ''41556'', ''Institutional''),
(''North Clackamas School District #12'', ''41556'', ''41556'', ''Professional''),
(''North County Transit District'', ''41556'', ''41556'', ''Institutional''),
(''North County Transit District'', ''41556'', ''41556'', ''Professional''),
(''North Dakota Vision Services'', ''55891'', ''NDBLS'', ''Professional''),
(''North East Independent School District (NEISD)'', ''J1872'', ''J1872'', ''Institutional''),
(''North East Independent School District (NEISD)'', ''J1872'', ''J1872'', ''Professional''),
(''North East Medical Services (NEMS)'', ''NEMS1'', ''NEMS1'', ''Professional''),
(''North Iowa Community Health Plan (NICH)'', ''78353'', ''78353'', ''Institutional''),
(''North Iowa Community Health Plan (NICH)'', ''78353'', ''78353'', ''Professional''),
(''North River Insurance Company'', ''31348'', ''31348'', ''Institutional''),
(''North River Insurance Company'', ''31348'', ''31348'', ''Professional''),
(''North West Life'', ''PH018'', ''PH018'', ''Professional''),
(''North West Orange County Medical Group'', ''PROSP'', ''PROSP'', ''Institutional''),
(''North West Orange County Medical Group'', ''PROSP'', ''PROSP'', ''Professional''),
(''Northern CA Advantage Medical Group'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Northern CA Advantage Medical Group'', ''HSM01'', ''HSM01'', ''Professional''),
(''Northern California Sheet Metal Workers Insurance Plan'', ''38238'', ''38238'', ''Professional''),
(''Northern Claims Management'', ''J1923'', ''J1923'', ''Institutional''),
(''Northern Claims Management'', ''J1923'', ''J1923'', ''Professional''),
(''Northern Colorado School Districts Workers'''' Compensation Pool'', ''41556'', ''41556'', ''Institutional''),
(''Northern Colorado School Districts Workers'''' Compensation Pool'', ''41556'', ''41556'', ''Professional''),
(''Northern Illinois Health Plan'', ''36347'', ''36347'', ''Institutional''),
(''Northern Illinois Health Plan'', ''36347'', ''36347'', ''Professional''),
(''Northern Kentucky University'', ''J1943'', ''J1943'', ''Institutional''),
(''Northern Kentucky University'', ''J1943'', ''J1943'', ''Professional''),
(''Northern Nevada Trust Fund - Reno, Nevada'', ''88027'', ''88027'', ''Professional''),
(''Northland Auto'', ''C1031'', ''C1031'', ''Institutional''),
(''Northland Auto'', ''C1031'', ''C1031'', ''Professional''),
(''Northridge Medical Group (California)'', ''NMG01'', ''NMG01'', ''Professional''),
(''Northshore Physician Associates IPA'', ''48026'', ''48026'', ''Institutional''),
(''Northshore Physician Associates IPA'', ''48026'', ''48026'', ''Professional''),
(''Northwest Administrators - Teamsters Miscellaneous Security Trust Fund'', ''NWADM'', ''NWADM'', ''Institutional''),
(''Northwest Administrators - Teamsters Miscellaneous Security Trust Fund'', ''NWADM'', ''NWADM'', ''Professional''),
(''Northwest Community Health Partners'', ''NWCHP'', ''NWCHP'', ''Institutional''),
(''Northwest Community Health Partners'', ''NWCHP'', ''NWCHP'', ''Professional''),
(''Northwest Diag. Clinic/Selectcare of Texas (NWDC)'', ''14163'', ''14163'', ''Institutional''),
(''Northwest Diag. Clinic/Selectcare of Texas (NWDC)'', ''14163'', ''14163'', ''Professional''),
(''Northwest Insurance'', ''J1361'', ''J1361'', ''Institutional''),
(''Northwest Insurance'', ''J1361'', ''J1361'', ''Professional''),
(''Northwest Physicians Network (DaVita Medical IPA)'', ''NPN11'', ''NPN11'', ''Institutional''),
(''Northwest Physicians Network (DaVita Medical IPA)'', ''NPN11'', ''NPN11'', ''Professional''),
(''Northwest Suburban IPA (Illinois)'', ''36346'', ''36346'', ''Institutional''),
(''Northwest Suburban IPA (Illinois)'', ''36346'', ''36346'', ''Professional''),
(''Norwood'', ''J1089'', ''J1089'', ''Institutional''),
(''Norwood'', ''J1089'', ''J1089'', ''Professional''),
(''Nova Dealership Advantage Program - WC'', ''41556'', ''41556'', ''Institutional''),
(''Nova Dealership Advantage Program - WC'', ''41556'', ''41556'', ''Professional''),
(''Nova Elite Comp Program'', ''41556'', ''41556'', ''Institutional''),
(''Nova Elite Comp Program'', ''41556'', ''41556'', ''Professional''),
(''Nova Healthcare Administrators, Inc. - Grand Island, New York'', ''16644'', ''16644'', ''Institutional''),
(''Nova Healthcare Administrators, Inc. - Grand Island, New York'', ''16644'', ''16644'', ''Professional''),
(''Nova Metals Advantage Plus Program - WC'', ''41556'', ''41556'', ''Institutional''),
(''Nova Metals Advantage Plus Program - WC'', ''41556'', ''41556'', ''Professional''),
(''Nova Pro Risk Solutions'', ''J1056'', ''J1056'', ''Institutional''),
(''Nova Pro Risk Solutions'', ''J1056'', ''J1056'', ''Professional''),
(''NovaNet'', ''06226'', ''06226'', ''Professional''),
(''Novant Health'', ''J1969'', ''J1969'', ''Institutional''),
(''Novant Health'', ''J1969'', ''J1969'', ''Professional''),
(''Nuestra Familia Medical Group (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Nuestra Familia Medical Group (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Professional''),
(''Nuevo Engineering'', ''41556'', ''41556'', ''Institutional''),
(''Nuevo Engineering'', ''41556'', ''41556'', ''Professional''),
(''NX Health Network (UCS)'', ''08354'', ''08354'', ''Institutional''),
(''NX Health Network (UCS)'', ''08354'', ''08354'', ''Professional''),
(''NXT IPA'', ''NXTOA'', ''NXTOA'', ''Institutional''),
(''NXT IPA'', ''NXTOA'', ''NXTOA'', ''Professional''),
(''NY State Insurance Fund (NYSIF)'', ''45052'', ''45052'', ''Institutional''),
(''NY State Insurance Fund (NYSIF)'', ''45052'', ''45052'', ''Professional''),
(''Nyhart'', ''37299'', ''37299'', ''Institutional''),
(''Nyhart'', ''37299'', ''37299'', ''Professional''),
(''NYS DOH UCP (New York ADAP)'', ''14142'', ''14142'', ''Institutional''),
(''NYS DOH UCP (New York ADAP)'', ''14142'', ''14142'', ''Professional''),
(''O''''Reilly Auto Parts'', ''J1670'', ''J1670'', ''Institutional''),
(''O''''Reilly Auto Parts'', ''J1670'', ''J1670'', ''Professional''),
(''Oak River Insurance Company (Member of BHHC)'', ''20044'', ''20044'', ''Institutional''),
(''Oak River Insurance Company (Member of BHHC)'', ''20044'', ''20044'', ''Professional''),
(''Oak West Physician Association'', ''36400'', ''36400'', ''Institutional''),
(''Oak West Physician Association'', ''36400'', ''36400'', ''Professional''),
(''Ocular Benefits'', ''L0140'', ''L0140'', ''Professional''),
(''ODS Healthcare'', ''13350'', ''13350'', ''Institutional''),
(''ODS Healthcare'', ''13350'', ''13350'', ''Professional''),
(''Ohana Health Plan'', ''14163'', ''14163'', ''Institutional''),
(''Ohana Health Plan'', ''14163'', ''14163'', ''Professional''),
(''Ohio Casualty Group'', ''24074'', ''24074'', ''Institutional''),
(''Ohio Casualty Group'', ''24074'', ''24074'', ''Professional''),
(''Ohio Health Choice, PPO'', ''34189'', ''34189'', ''Institutional''),
(''Ohio Health Choice, PPO'', ''34189'', ''34189'', ''Professional''),
(''Ohio PPO Connect'', ''74431'', ''74431'', ''Institutional''),
(''Ohio PPO Connect'', ''74431'', ''74431'', ''Professional''),
(''Old Republic Insurance Co'', ''24147'', ''24147'', ''Institutional''),
(''Old Republic Insurance Co'', ''24147'', ''24147'', ''Professional''),
(''OLOLRMC Uninsured Patient Services Program'', ''OLRMC'', ''OLRMC'', ''Institutional''),
(''OLOLRMC Uninsured Patient Services Program'', ''OLRMC'', ''OLRMC'', ''Professional''),
(''Olympus Managed Health'', ''65074'', ''65074'', ''Institutional''),
(''Olympus Managed Health'', ''65074'', ''65074'', ''Professional''),
(''OMNI Administrators'', ''OMNIA'', ''OMNIA'', ''Professional''),
(''Omnicare Medical Group (OMNI)'', ''OMN02'', ''OMN02'', ''Professional''),
(''Omnicare, A Coventry Health Plan'', ''25133'', ''25133'', ''Institutional''),
(''Omnicare, A Coventry Health Plan'', ''25133'', ''25133'', ''Professional''),
(''One Beacon'', ''20621'', ''20621'', ''Institutional''),
(''One Beacon'', ''20621'', ''20621'', ''Professional''),
(''One Beacon Insurance - Auto'', ''C1026'', ''C1026'', ''Institutional''),
(''One Beacon Insurance - Auto'', ''C1026'', ''C1026'', ''Professional''),
(''One Call Diagnostics (fka One Call Medical)'', ''22321'', ''22321'', ''Institutional''),
(''One Call Diagnostics (fka One Call Medical)'', ''22321'', ''22321'', ''Professional''),
(''One Call Medical - Diagnostic'', ''22321'', ''J3941'', ''Institutional''),
(''One Call Medical - Diagnostic'', ''J3941'', ''J3941'', ''Professional''),
(''One Health Plan of California, Inc.'', ''95379'', ''95379'', ''Professional''),
(''One Health Plan of Georgia, Inc.'', ''95569'', ''95569'', ''Professional''),
(''One Health Plan of Illinois, Inc.'', ''95388'', ''95388'', ''Professional''),
(''OnLok Senior Health Services, Inc.'', ''99485'', ''99485'', ''Institutional''),
(''OnLok Senior Health Services, Inc.'', ''99485'', ''99485'', ''Professional''),
(''Operating Engineers Local 501'', ''47198'', ''CABLC'', ''Institutional''),
(''Operating Engineers Local 501'', ''BC001'', ''CABLC'', ''Professional''),
(''Operating Engineers Locals 302 & 612 Health & Security Fund'', ''91136'', ''91136'', ''Institutional''),
(''Operating Engineers Locals 302 & 612 Health & Security Fund'', ''91136'', ''91136'', ''Professional''),
(''Optima Health Plan'', ''54154'', ''54154'', ''Institutional''),
(''Optima Health Plan'', ''54154'', ''54154'', ''Professional''),
(''Optima Insurance Company'', ''54154'', ''54154'', ''Institutional''),
(''Optima Insurance Company'', ''54154'', ''54154'', ''Professional''),
(''Optimum Choice of the Carolinas (OCCI)'', ''52152'', ''52152'', ''Professional''),
(''Optimum Choice, Inc (OCI)'', ''87726'', ''87726'', ''Institutional''),
(''Optimum Choice, Inc (OCI)'', ''87726'', ''87726'', ''Professional''),
(''Optimum Healthcare, Inc.'', ''20133'', ''20133'', ''Institutional''),
(''Optimum Healthcare, Inc.'', ''20133'', ''20133'', ''Professional''),
(''Optum Care Network - Arta Health Network'', ''OCN01'', ''OCN01'', ''Professional''),
(''Optum Care Network - HealthCare Partners (California)'', ''OCN01'', ''OCN01'', ''Institutional''),
(''Optum Care Network - HealthCare Partners (California)'', ''OCN01'', ''OCN01'', ''Professional''),
(''Optum Care Network - Physicians Assoc of Greater San Gabriel Valley'', ''OCN01'', ''OCN01'', ''Institutional''),
(''Optum Care Network - Physicians Assoc of Greater San Gabriel Valley'', ''OCN01'', ''OCN01'', ''Professional''),
(''Optum Care Network - Talbert Medical Group (California)'', ''OCN01'', ''OCN01'', ''Institutional''),
(''Optum Care Network - Talbert Medical Group (California)'', ''OCN01'', ''OCN01'', ''Professional''),
(''Optum Care Network of Connecticut'', ''E3287'', ''E3287'', ''Institutional''),
(''Optum Care Network of Connecticut'', ''E3287'', ''E3287'', ''Professional''),
(''Optum Maryland Behavioral Health'', ''OMDBH'', ''OMDBH'', ''Institutional''),
(''Optum Maryland Behavioral Health'', ''OMDBH'', ''OMDBH'', ''Professional''),
(''OptumCare Medical Network / AZ, UT'', ''LIFE1'', ''LIFE1'', ''Institutional''),
(''OptumCare Medical Network / AZ, UT'', ''LIFE1'', ''LIFE1'', ''Professional''),
(''OptumHealth Behavior Solutions'', ''87726'', ''87726'', ''Institutional''),
(''OptumHealth Behavior Solutions'', ''87726'', ''87726'', ''Professional''),
(''OptumHealth Behavioral Solutions (formerly PacifiCare Behavioral Health)'', ''87726'', ''87726'', ''Institutional''),
(''OptumHealth Behavioral Solutions (formerly PacifiCare Behavioral Health)'', ''87726'', ''87726'', ''Professional''),
(''OptumHealth Behavioral Solutions (formerly United Behavioral Health)'', ''87726'', ''87726'', ''Institutional''),
(''OptumHealth Behavioral Solutions (formerly United Behavioral Health)'', ''87726'', ''87726'', ''Professional''),
(''OptumHealth Behavioral Solutions New Mexico'', ''87726'', ''87726'', ''Institutional''),
(''OptumHealth Behavioral Solutions New Mexico'', ''87726'', ''87726'', ''Professional''),
(''OptumHealth Care Solutions - all plans'', ''41161'', ''41161'', ''Institutional''),
(''OptumHealth Care Solutions - all plans'', ''41161'', ''41161'', ''Professional''),
(''OptumHealth Complex Medical Conditions (CMC)'', ''41194'', ''41194'', ''Institutional''),
(''OptumHealth Complex Medical Conditions (CMC)'', ''41194'', ''41194'', ''Professional''),
(''Orange Coast Memorial IPA'', ''IP095'', ''MHIPA'', ''Professional''),
(''Orange County Advantage Medical Group, Inc'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Orange County Advantage Medical Group, Inc'', ''HSM01'', ''HSM01'', ''Professional''),
(''Orange County Fire Authority'', ''J1876'', ''J1876'', ''Institutional''),
(''Orange County Fire Authority'', ''J1876'', ''J1876'', ''Professional''),
(''Orange County Physicians IPA Medical Group, Inc dba Noble Community Medical Assoc of Mid-Orange County'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Orange County Physicians IPA Medical Group, Inc dba Noble Community Medical Assoc of Mid-Orange County'', ''HSM01'', ''HSM01'', ''Professional''),
(''Orchard Supply Company (Bunch CareSolutions)'', ''J1962'', ''J1962'', ''Institutional''),
(''Orchard Supply Company (Bunch CareSolutions)'', ''J1962'', ''J1962'', ''Professional''),
(''Oregon Health Mgmt, aka Primary Health of Josephine County'', ''OHMS'', ''OHMSP'', ''Professional''),
(''Oregon State Accident Insurance Fund (SAIF) Corporation'', ''J1720'', ''J1720'', ''Institutional''),
(''Oregon State Accident Insurance Fund (SAIF) Corporation'', ''J1720'', ''J1720'', ''Professional''),
(''Orica, Inc.'', ''J1090'', ''J1090'', ''Institutional''),
(''Orica, Inc.'', ''J1090'', ''J1090'', ''Professional''),
(''Orthonet (Uniformed Services Family Health Plan)'', ''13382'', ''13382'', ''Professional''),
(''Orthonet - Aetna'', ''13383'', ''13383'', ''Professional''),
(''Oscar Health'', ''OSCAR'', ''OSCAR'', ''Institutional''),
(''Oscar Health'', ''OSCAR'', ''OSCAR'', ''Professional''),
(''OSF Care Advantage'', ''OSFMC'', ''OSFMC'', ''Professional''),
(''OSF Health Plans - Peoria, Illinois'', ''62171'', ''62171'', ''Institutional''),
(''OSF Health Plans - Peoria, Illinois'', ''62171'', ''62171'', ''Professional''),
(''OSG - St. Therese  Physicians Association'', ''37116'', ''37116'', ''Institutional''),
(''OSG - St. Therese  Physicians Association'', ''37116'', ''37116'', ''Professional''),
(''OSI Group, LLC'', ''J1904'', ''J1904'', ''Institutional''),
(''OSI Group, LLC'', ''J1904'', ''J1904'', ''Professional''),
(''Outpatient Services'', ''04430'', ''04430'', ''Institutional''),
(''Outpatient Services'', ''04430'', ''04430'', ''Professional''),
(''Outrigger Lodging'', ''41556'', ''41556'', ''Institutional''),
(''Outrigger Lodging'', ''41556'', ''41556'', ''Professional''),
(''Overhill Farms, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Overhill Farms, Inc.'', ''41556'', ''41556'', ''Professional''),
(''Oxford Health Plan Medicare Advantage'', ''87726'', ''87726'', ''Institutional''),
(''Oxford Health Plan Medicare Advantage'', ''87726'', ''87726'', ''Professional''),
(''Oxford Health Plans Commercial'', ''06111'', ''06111'', ''Institutional''),
(''Oxford Health Plans Commercial'', ''06111'', ''06111'', ''Professional''),
(''P3 Health Partners - Arizona'', ''58375'', ''58375'', ''Institutional''),
(''P3 Health Partners - Arizona'', ''58375'', ''58375'', ''Professional''),
(''P3 Health Partners - Nevada'', ''58379'', ''58379'', ''Institutional''),
(''P3 Health Partners - Nevada'', ''58379'', ''58379'', ''Professional''),
(''P5 Health Plan Solutions of Utah'', ''87068'', ''PAPER'', ''Institutional''),
(''P5 Health Plan Solutions of Utah'', ''87068'', ''PAPER'', ''Professional''),
(''PACE Central Iowa'', ''72436'', ''72436'', ''Institutional''),
(''PACE Central Iowa'', ''72436'', ''72436'', ''Professional''),
(''PACE CNY'', ''70454'', ''70454'', ''Institutional''),
(''PACE CNY'', ''70454'', ''70454'', ''Professional''),
(''PACE Greater New Orleans'', ''21614'', ''21614'', ''Institutional''),
(''PACE Greater New Orleans'', ''21614'', ''21614'', ''Professional''),
(''PACE Nebraska'', ''35416'', ''35416'', ''Institutional''),
(''PACE Nebraska'', ''35416'', ''35416'', ''Professional''),
(''PACE of Southwest Michigan, Inc.'', ''45114'', ''45114'', ''Institutional''),
(''PACE of Southwest Michigan, Inc.'', ''45114'', ''45114'', ''Professional''),
(''PACE Southeast Michigan'', ''86711'', ''86711'', ''Institutional''),
(''PACE Southeast Michigan'', ''86711'', ''86711'', ''Professional''),
(''PACE Southwest Iowa'', ''53534'', ''53534'', ''Institutional''),
(''PACE Southwest Iowa'', ''53534'', ''53534'', ''Professional''),
(''Pacific Alliance Medical Group and Hospital (SynerMed)'', ''SYMED'', ''SYMED'', ''Professional''),
(''Pacific Associates IPA'', ''PAIPA'', ''PAIPA'', ''Institutional''),
(''Pacific Associates IPA'', ''PAIPA'', ''PAIPA'', ''Professional''),
(''Pacific Coast Building Products'', ''J1808'', ''J1808'', ''Institutional''),
(''Pacific Coast Building Products'', ''J1808'', ''J1808'', ''Professional''),
(''Pacific Compensation Insurance Company'', ''J1913'', ''J1913'', ''Institutional''),
(''Pacific Compensation Insurance Company'', ''J1913'', ''J1913'', ''Professional''),
(''Pacific Dental Services'', ''J1806'', ''J1806'', ''Institutional''),
(''Pacific Dental Services'', ''J1806'', ''J1806'', ''Professional''),
(''Pacific Gas & Electric -115'', ''J1916'', ''J1916'', ''Institutional''),
(''Pacific Gas & Electric -115'', ''J1916'', ''J1916'', ''Professional''),
(''Pacific Health MSO'', ''PHM10'', ''PHM10'', ''Professional''),
(''Pacific HealthCare IPA'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Pacific HealthCare IPA'', ''HSM01'', ''HSM01'', ''Professional''),
(''Pacific Hospital of Long Beach'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Pacific Hospital of Long Beach'', ''HSM01'', ''HSM01'', ''Professional''),
(''Pacific Hydrotech Co'', ''41556'', ''41556'', ''Institutional''),
(''Pacific Hydrotech Co'', ''41556'', ''41556'', ''Professional''),
(''Pacific Insurance Company LTD'', ''C1040'', ''C1040'', ''Institutional''),
(''Pacific Insurance Company LTD'', ''C1040'', ''C1040'', ''Professional''),
(''Pacific IPA (California)'', ''PCFCI'', ''PCFCI'', ''Professional''),
(''Pacific Lumber Company (Marathon)'', ''41556'', ''41556'', ''Institutional''),
(''Pacific Lumber Company (Marathon)'', ''41556'', ''41556'', ''Professional''),
(''Pacific Motor Company'', ''J1364'', ''J1364'', ''Institutional''),
(''Pacific Motor Company'', ''J1364'', ''J1364'', ''Professional''),
(''Pacific Partners Medical (SCCIPA)'', ''10378'', ''10378'', ''Professional''),
(''Pacific Southwest Administrators (PSWA)'', ''75309'', ''75309'', ''Institutional''),
(''Pacific Southwest Administrators (PSWA)'', ''75309'', ''75309'', ''Professional''),
(''Pacific Specialty Insurance'', ''41556'', ''41556'', ''Institutional''),
(''Pacific Specialty Insurance'', ''41556'', ''41556'', ''Professional''),
(''Pacific Sunwear'', ''J1805'', ''J1805'', ''Institutional''),
(''Pacific Sunwear'', ''J1805'', ''J1805'', ''Professional''),
(''PacificSource Administrators'', ''93031'', ''93031'', ''Institutional''),
(''PacificSource Administrators'', ''93031'', ''93031'', ''Professional''),
(''PacificSource Community Solutions'', ''20416'', ''20416'', ''Institutional''),
(''PacificSource Community Solutions'', ''20416'', ''20416'', ''Professional''),
(''PacificSource Health Plans'', ''93029'', ''93029'', ''Institutional''),
(''PacificSource Health Plans'', ''93029'', ''93029'', ''Professional''),
(''PacificSource Medicare'', ''20377'', ''20377'', ''Institutional''),
(''PacificSource Medicare'', ''20377'', ''20377'', ''Professional''),
(''Pajaro Vly Comnty Health Trust'', ''41556'', ''41556'', ''Institutional''),
(''Pajaro Vly Comnty Health Trust'', ''41556'', ''41556'', ''Professional''),
(''Paladin ISL'', ''J1827'', ''J1827'', ''Institutional''),
(''Paladin ISL'', ''J1827'', ''J1827'', ''Professional''),
(''Paladin Managed Care Services, Inc.'', ''J1475'', ''J1475'', ''Institutional''),
(''Paladin Managed Care Services, Inc.'', ''J1475'', ''J1475'', ''Professional''),
(''Palo Alto Medical Foundation'', ''41556'', ''41556'', ''Institutional''),
(''Palo Alto Medical Foundation'', ''41556'', ''41556'', ''Professional''),
(''Palomar Pomerado Hospital'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Palomar Pomerado Hospital'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Pan American Life Insurance'', ''87020'', ''87020'', ''Institutional''),
(''Pan American Life Insurance'', ''87020'', ''87020'', ''Professional''),
(''Pan American Life Insurance Co of Puerto Rico (PALIC)'', ''81240'', ''81240'', ''Institutional''),
(''Pan American Life Insurance Co of Puerto Rico (PALIC)'', ''81240'', ''81240'', ''Professional''),
(''Pan American Life Insurance Group'', ''04218'', ''04218'', ''Institutional''),
(''Pan American Life Insurance Group'', ''04218'', ''04218'', ''Professional''),
(''Papa John''''s International Inc'', ''J1091'', ''J1091'', ''Institutional''),
(''Papa John''''s International Inc'', ''J1091'', ''J1091'', ''Professional''),
(''Paper claims'', ''SPRNT'', ''PAPER'', ''Institutional''),
(''Paper claims'', ''SPRNT'', ''PAPER'', ''Professional''),
(''Paper Claims - Workers Compensation'', ''WCPAP'', ''WCPAP'', ''Institutional''),
(''Paper Claims - Workers Compensation'', ''WCPAP'', ''WCPAP'', ''Professional''),
(''Paradigm'', ''J1001'', ''J1001'', ''Institutional''),
(''Paradigm'', ''J1001'', ''J1001'', ''Professional''),
(''Paradigm Senior Care Advantage'', ''AGL02'', ''AGL02'', ''Institutional''),
(''Paradigm Senior Care Advantage'', ''AGL02'', ''AGL02'', ''Professional''),
(''Paragon Benefits, Inc.'', ''58174'', ''58174'', ''Institutional''),
(''Paragon Benefits, Inc.'', ''58174'', ''58174'', ''Professional''),
(''Paramount Healthcare'', ''PARHC'', ''PHCAR'', ''Institutional''),
(''Paramount Healthcare'', ''PHRAC'', ''PHCAR'', ''Professional''),
(''Parity Healthcare, LLC.'', ''58204'', ''58204'', ''Professional''),
(''Park District Risk Management Association (PDRMA)'', ''J1365'', ''J1365'', ''Institutional''),
(''Park District Risk Management Association (PDRMA)'', ''J1365'', ''J1365'', ''Professional''),
(''Parkland Community Health Plan'', ''66917'', ''66917'', ''Institutional''),
(''Parkland Community Health Plan'', ''66917'', ''66917'', ''Professional''),
(''Partners Behavioral Health Management'', ''52613'', ''52613'', ''Institutional''),
(''Partners Behavioral Health Management'', ''52613'', ''52613'', ''Professional''),
(''Partners National Health Plans of North Carolina, Inc.'', ''56152'', ''56152'', ''Institutional''),
(''Partners National Health Plans of North Carolina, Inc.'', ''56152'', ''56152'', ''Professional''),
(''Partnership Health Plan of California'', ''12M81'', ''PHPCA'', ''Institutional''),
(''Partnership Health Plan of California'', ''SX140'', ''PHPCA'', ''Professional''),
(''Partnership Healthplan (RCHC Sonoma County only)'', ''RCHC1'', ''RCHC1'', ''Professional''),
(''Pas Coffee Roasters'', ''41556'', ''41556'', ''Institutional''),
(''Pas Coffee Roasters'', ''41556'', ''41556'', ''Professional''),
(''Pasadena Primary Care Physicians (Conifer)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Pasadena Primary Care Physicians (Conifer)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Passport Advantage'', ''66008'', ''66008'', ''Institutional''),
(''Passport Advantage'', ''66008'', ''66008'', ''Professional''),
(''Passport Health Plan - Kentucky'', ''61325'', ''61325'', ''Institutional''),
(''Passport Health Plan - Kentucky'', ''61325'', ''61325'', ''Professional''),
(''Patient Advocates, Inc.'', ''55489'', ''55489'', ''Institutional''),
(''Patient Advocates, Inc.'', ''55489'', ''55489'', ''Professional''),
(''Patoka Valley Health Care (PVHCC)'', ''30031'', ''30031'', ''Institutional''),
(''Patoka Valley Health Care (PVHCC)'', ''30031'', ''30031'', ''Professional''),
(''Patriot General Insurance Co.'', ''J1417'', ''J1417'', ''Institutional''),
(''Patriot General Insurance Co.'', ''J1417'', ''J1417'', ''Professional''),
(''Patriot General Insurance Company'', ''C1033'', ''C1033'', ''Institutional''),
(''Patriot General Insurance Company'', ''C1033'', ''C1033'', ''Professional''),
(''Patterson Bro Light.'', ''41556'', ''41556'', ''Institutional''),
(''Patterson Bro Light.'', ''41556'', ''41556'', ''Professional''),
(''Payer Fusion'', ''27048'', ''27048'', ''Institutional''),
(''Payer Fusion'', ''27048'', ''27048'', ''Professional''),
(''PAYNET, INC.'', ''37210'', ''37210'', ''Institutional''),
(''PAYNET, INC.'', ''37210'', ''37210'', ''Professional''),
(''PCA Health Plan of Florida - Humana PR'', ''65018'', ''65018'', ''Professional''),
(''PDT - Hollywood Presbyterian - St. Vincent'', ''PDT02'', ''PDT02'', ''Institutional''),
(''PDT - Hollywood Presbyterian - St. Vincent'', ''PDT02'', ''PDT02'', ''Professional''),
(''Peach State Health Plan - Georgia'', ''68069'', ''68069'', ''Institutional''),
(''Peach State Health Plan - Georgia'', ''68069'', ''68069'', ''Professional''),
(''Peak Pace TPA'', ''27034'', ''27034'', ''Institutional''),
(''Peak Pace TPA'', ''27034'', ''27034'', ''Professional''),
(''Peak Property and Casualty Insurance Corporation'', ''C1033'', ''C1033'', ''Institutional''),
(''Peak Property and Casualty Insurance Corporation'', ''C1033'', ''C1033'', ''Professional''),
(''Peerless'', ''J1423'', ''J1423'', ''Institutional''),
(''Peerless'', ''J1423'', ''J1423'', ''Professional''),
(''Peg Discover Re'', ''J1092'', ''J1092'', ''Institutional''),
(''Peg Discover Re'', ''J1092'', ''J1092'', ''Professional''),
(''Peg Discover Re( Foood Merchant)'', ''J1054'', ''J1054'', ''Institutional''),
(''Peg Discover Re( Foood Merchant)'', ''J1054'', ''J1054'', ''Professional''),
(''Pegasus Risk Management CA'', ''J1924'', ''J1924'', ''Institutional''),
(''Pegasus Risk Management CA'', ''J1924'', ''J1924'', ''Professional''),
(''Pegi-Family Dining'', ''J1093'', ''J1093'', ''Institutional''),
(''Pegi-Family Dining'', ''J1093'', ''J1093'', ''Professional''),
(''Pekin Insurance'', ''37086'', ''37086'', ''Institutional''),
(''Pekin Insurance'', ''37086'', ''37086'', ''Professional''),
(''Penn Behavioral Health'', ''53226'', ''53226'', ''Institutional''),
(''Penn Behavioral Health'', ''53226'', ''53226'', ''Professional''),
(''Penn Millers Insurance Co'', ''J1573'', ''J1573'', ''Institutional''),
(''Penn Millers Insurance Co'', ''J1573'', ''J1573'', ''Professional''),
(''Penn National Insurance'', ''C1076'', ''C1076'', ''Institutional''),
(''Penn National Insurance'', ''C1076'', ''C1076'', ''Professional''),
(''Penn National Insurance'', ''J3903'', ''J3903'', ''Institutional''),
(''Penn National Insurance'', ''J3903'', ''J3903'', ''Professional''),
(''Pennsylvania Health & Wellness'', ''68069'', ''68069'', ''Institutional''),
(''Pennsylvania Health & Wellness'', ''68069'', ''68069'', ''Professional''),
(''Pennsylvania Manufacturers Indemnity Company'', ''41556'', ''41556'', ''Institutional''),
(''Pennsylvania Manufacturers Indemnity Company'', ''41556'', ''41556'', ''Professional''),
(''Pennsylvania Manufacturers'''' Association Insurance Company'', ''41556'', ''41556'', ''Institutional''),
(''Pennsylvania Manufacturers'''' Association Insurance Company'', ''41556'', ''41556'', ''Professional''),
(''Pennsylvania Manufacturing Associates'', ''J1439'', ''J1439'', ''Institutional''),
(''Pennsylvania Manufacturing Associates'', ''J1439'', ''J1439'', ''Professional''),
(''Pennsylvania Medicare Advantage Freedom Blue'', ''15460'', ''15460'', ''Institutional''),
(''Pennsylvania Medicare Advantage Freedom Blue'', ''15460'', ''15460'', ''Professional''),
(''Pennsylvania PACE'', ''20172'', ''20172'', ''Institutional''),
(''Pennsylvania PACE'', ''20172'', ''20172'', ''Professional''),
(''Pennsylvania''''s Preferred Health Networks (PPHN)'', ''06161'', ''06161'', ''Professional''),
(''Penser North America, Inc'', ''J1892'', ''J1892'', ''Institutional''),
(''Penser North America, Inc'', ''J1892'', ''J1892'', ''Professional''),
(''People 2.0  (Bunch CareSolutions)'', ''J1466'', ''J1466'', ''Institutional''),
(''People 2.0  (Bunch CareSolutions)'', ''J1466'', ''J1466'', ''Professional''),
(''Peoples Benefit Life Insurance'', ''PBLIC'', ''PBLIC'', ''Institutional''),
(''Peoples Benefit Life Insurance'', ''PBLIC'', ''PBLIC'', ''Professional''),
(''Peoples Health Network - Kenner, Louisiana'', ''72126'', ''72126'', ''Institutional''),
(''Peoples Health Network - Kenner, Louisiana'', ''72126'', ''72126'', ''Professional''),
(''Performance Contracting Inc'', ''J1940'', ''J1940'', ''Institutional''),
(''Performance Contracting Inc'', ''J1940'', ''J1940'', ''Professional''),
(''PerformCare Healthchoices'', ''65391'', ''65391'', ''Institutional''),
(''PerformCare Healthchoices'', ''65391'', ''65391'', ''Professional''),
(''Personal Choice (IBC) Highmark'', ''54704'', ''54704'', ''Institutional''),
(''Personal Choice (IBC) Highmark'', ''54704'', ''54704'', ''Professional''),
(''Personal Insurance Administrators (Agoura Hills, CA)'', ''95397'', ''95397'', ''Institutional''),
(''Personal Insurance Administrators (Agoura Hills, CA)'', ''95397'', ''95397'', ''Professional''),
(''PersonalCare (Coventry)'', ''25133'', ''25133'', ''Institutional''),
(''PersonalCare (Coventry)'', ''25133'', ''25133'', ''Professional''),
(''Petaluma Valley Hospital'', ''41556'', ''41556'', ''Institutional''),
(''Petaluma Valley Hospital'', ''41556'', ''41556'', ''Professional''),
(''Pflugerville ISD'', ''41556'', ''41556'', ''Institutional''),
(''Pflugerville ISD'', ''41556'', ''41556'', ''Professional''),
(''PHA Insurance Services - Orlando, Florida'', ''95183'', ''95183'', ''Institutional''),
(''PHA Insurance Services - Orlando, Florida'', ''95183'', ''95183'', ''Professional''),
(''Pharmacist Mutual Insurance Co.'', ''J1570'', ''J1570'', ''Institutional''),
(''Pharmacist Mutual Insurance Co.'', ''J1570'', ''J1570'', ''Professional''),
(''PHCS / Cigna West'', ''72099'', ''72099'', ''Institutional''),
(''PHCS / Cigna West'', ''72099'', ''72099'', ''Professional''),
(''Phh Fleetamerica'', ''J1094'', ''J1094'', ''Institutional''),
(''Phh Fleetamerica'', ''J1094'', ''J1094'', ''Professional''),
(''Philadelphia American Life Insurance - New Era Life'', ''98798'', ''98798'', ''Institutional''),
(''Philadelphia American Life Insurance - New Era Life'', ''98798'', ''98798'', ''Professional''),
(''PHP - Physicians Health Plan of Northern Indiana'', ''12399'', ''12399'', ''Institutional''),
(''PHP - Physicians Health Plan of Northern Indiana'', ''12399'', ''12399'', ''Professional''),
(''PHP of Mid-Michigan - Behavioral Health'', ''87726'', ''87726'', ''Institutional''),
(''PHP of South Michigan - Behavioral Health'', ''87726'', ''87726'', ''Institutional''),
(''PHP of Southwest Michigan - Behavioral Health'', ''87726'', ''87726'', ''Institutional''),
(''PHP of West Michigan - Behavioral Health'', ''87726'', ''87726'', ''Institutional''),
(''Physician Associates of Louisiana'', ''58204'', ''58204'', ''Professional''),
(''Physician Health Partners'', ''87726'', ''87726'', ''Institutional''),
(''Physician Health Partners'', ''87726'', ''87726'', ''Professional''),
(''Physician Partners IPA'', ''PPRT1'', ''PPRT1'', ''Institutional''),
(''Physician Partners IPA'', ''PPRT1'', ''PPRT1'', ''Professional''),
(''Physician''''s Accountable Care Organization'', ''28943'', ''28943'', ''Institutional''),
(''Physician''''s Accountable Care Organization'', ''28943'', ''28943'', ''Professional''),
(''Physician''''s Data Trust'', ''PDT01'', ''PDT01'', ''Institutional''),
(''Physician''''s Data Trust'', ''PDT01'', ''PDT01'', ''Professional''),
(''Physician''''s Health Plan- SC'', ''09173'', ''09173'', ''Institutional''),
(''Physician''''s Health Plan- SC'', ''09173'', ''09173'', ''Professional''),
(''Physicians Care Network'', ''36345'', ''36345'', ''Institutional''),
(''Physicians Care Network'', ''36345'', ''36345'', ''Professional''),
(''Physicians Choice Medical Group of San Luis Obispo'', ''SLOS1'', ''SLOS1'', ''Institutional''),
(''Physicians Choice Medical Group of San Luis Obispo'', ''SLOS1'', ''SLOS1'', ''Professional''),
(''Physicians Health Association of Illinois'', ''37136'', ''37136'', ''Institutional''),
(''Physicians Health Association of Illinois'', ''37136'', ''37136'', ''Professional''),
(''Physicians Health Choice  (Claims)'', ''PHCS1'', ''PHCS1'', ''Institutional''),
(''Physicians Health Choice  (Claims)'', ''PHCS1'', ''PHCS1'', ''Professional''),
(''Physicians Health Choice (Encounters)'', ''PHCS1'', ''PHCEN'', ''Professional''),
(''Physicians Health Choice (Encounters)'', ''TH114'', ''PHCEN'', ''Institutional''),
(''Physicians Health Collaborative'', ''20398'', ''20398'', ''Institutional''),
(''Physicians Health Collaborative'', ''20398'', ''20398'', ''Professional''),
(''Physicians Health Plan Mid-Michigan (PHP)'', ''37330'', ''37330'', ''Institutional''),
(''Physicians Health Plan Mid-Michigan (PHP)'', ''37330'', ''37330'', ''Professional''),
(''Physicians Health Plan of Michigan Medicare'', ''83276'', ''83276'', ''Institutional''),
(''Physicians Health Plan of Michigan Medicare'', ''83276'', ''83276'', ''Professional''),
(''Physicians Health Plan South Carolina'', ''87726'', ''87726'', ''Institutional''),
(''Physicians Medical Group of San Jose'', ''EXC01'', ''EXC01'', ''Professional''),
(''Physicians Mutual Insurance Company'', ''47027'', ''47027'', ''Institutional''),
(''Physicians Mutual Insurance Company'', ''47027'', ''47027'', ''Professional''),
(''Physicians of Southwest Washington'', ''91171'', ''91171'', ''Professional''),
(''Physicians Plus Insurance Corporation'', ''39156'', ''39156'', ''Institutional''),
(''Physicians Plus Insurance Corporation'', ''39156'', ''39156'', ''Professional''),
(''Physicians'''' Healthways IPA'', ''NMM01'', ''PHIPA'', ''Institutional''),
(''Physicians'''' Healthways IPA'', ''NMM01'', ''PHIPA'', ''Professional''),
(''PhysMetrics (formerly ChiroMetrics)'', ''CM001'', ''CM001'', ''Institutional''),
(''PhysMetrics (formerly ChiroMetrics)'', ''CM001'', ''CM001'', ''Professional''),
(''Pier 1 Inc. USA'', ''J1369'', ''J1369'', ''Professional''),
(''PIH Health (formerly Bright Health)'', ''BHP01'', ''BHP01'', ''Professional''),
(''Pima County'', ''41556'', ''41556'', ''Institutional''),
(''Pima County'', ''41556'', ''41556'', ''Professional''),
(''Pinnacle Claims Management, Inc.'', ''24735'', ''24735'', ''Institutional''),
(''Pinnacle Claims Management, Inc.'', ''24735'', ''24735'', ''Professional''),
(''Pinnacle Health Resources (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Pinnacle Health Resources (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Professional''),
(''Pinnacol Assurance'', ''84109'', ''84109'', ''Institutional''),
(''Pinnacol Assurance'', ''84109'', ''84109'', ''Professional''),
(''Pipefitters 597 - Chicago, Illinois'', ''PIP98'', ''PIP98'', ''Professional''),
(''Pittsburgh Care Partnership'', ''23283'', ''23283'', ''Institutional''),
(''Pittsburgh Care Partnership'', ''23283'', ''23283'', ''Professional''),
(''Plainview ISD'', ''41556'', ''41556'', ''Institutional''),
(''Plainview ISD'', ''41556'', ''41556'', ''Professional''),
(''Plan de Bienestar UTM-PRSSA'', ''02379'', ''02379'', ''Institutional''),
(''Plan de Bienestar UTM-PRSSA'', ''02379'', ''02379'', ''Professional''),
(''Plan de Salud Hospital Menonita Commercial'', ''L0190'', ''36242'', ''Institutional''),
(''Plan de Salud Hospital Menonita Commercial'', ''L0190'', ''36242'', ''Professional''),
(''Plan de Salud Hospital Menonita Vital'', ''66063'', ''36PSG'', ''Institutional''),
(''Plan de Salud Hospital Menonita Vital'', ''66063'', ''36PSG'', ''Professional''),
(''Plan de Socios Auxilio Mutuo'', ''78704'', ''78704'', ''Institutional''),
(''Plan de Socios Auxilio Mutuo'', ''78704'', ''78704'', ''Professional''),
(''Planned Administrators, Inc. (PAI)'', ''37287'', ''37287'', ''Institutional''),
(''Planned Administrators, Inc. (PAI)'', ''37287'', ''37287'', ''Professional''),
(''Plott Health Care'', ''41556'', ''41556'', ''Institutional''),
(''Plott Health Care'', ''41556'', ''41556'', ''Professional''),
(''Podi Care Managed Care'', ''58204'', ''58204'', ''Professional''),
(''Podiatry First'', ''POD1S'', ''POD1S'', ''Professional''),
(''Podiatry Network Florida'', ''59324'', ''59324'', ''Institutional''),
(''Podiatry Network Florida'', ''59324'', ''59324'', ''Professional''),
(''Podiatry Plan Inc.'', ''PODIA'', ''PODIA'', ''Professional''),
(''Point Comfort'', ''PCU01'', ''PCU01'', ''Institutional''),
(''Point Comfort'', ''PCU01'', ''PCU01'', ''Professional''),
(''Point Comfort Underwriters'', ''PCU02'', ''PCU02'', ''Institutional''),
(''Point Comfort Underwriters'', ''PCU02'', ''PCU02'', ''Professional''),
(''Polish Falcons of America'', ''87020'', ''87020'', ''Institutional''),
(''Polish Falcons of America'', ''87020'', ''87020'', ''Professional''),
(''Poly-America'', ''41556'', ''41556'', ''Institutional''),
(''Poly-America'', ''41556'', ''41556'', ''Professional''),
(''Pomona Valley Medical Group (PVMG)'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Pomona Valley Medical Group (PVMG)'', ''PROSP'', ''PROSP'', ''Professional''),
(''Ponderosa Landscape'', ''41556'', ''41556'', ''Institutional''),
(''Ponderosa Landscape'', ''41556'', ''41556'', ''Professional''),
(''Pool Administrators - CDPH'', ''PAI01'', ''PAI01'', ''Professional''),
(''Pool Administrators - Secondary'', ''PAI02'', ''PAI02'', ''Professional''),
(''Port of Oakland (CA)'', ''J1627'', ''J1627'', ''Institutional''),
(''Port of Oakland (CA)'', ''J1627'', ''J1627'', ''Professional''),
(''Positive Health Care (PHC)/FL MCO PHC'', ''95411'', ''95411'', ''Institutional''),
(''Positive Health Care (PHC)/FL MCO PHC'', ''95411'', ''95411'', ''Professional''),
(''PPN Pioneer Medical Group (MedPOINT)'', ''MPM18'', ''MPM18'', ''Institutional''),
(''PPN Pioneer Medical Group (MedPOINT)'', ''MPM18'', ''MPM18'', ''Professional''),
(''PPO Plus, LLC'', ''72148'', ''72148'', ''Institutional''),
(''PPO Plus, LLC'', ''72148'', ''72148'', ''Professional''),
(''PPP (Public Private Partnership) American Insurance Administrators - AIA, Primary Care'', ''MAP01'', ''MAP01'', ''Professional''),
(''Prairie Meadows (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Prairie Meadows (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Prairie States Enterprises, Inc.'', ''36373'', ''36373'', ''Institutional''),
(''Prairie States Enterprises, Inc.'', ''36373'', ''36373'', ''Professional''),
(''Preferred Admin'', ''88057'', ''88057'', ''Professional''),
(''Preferred Admin'', ''EPF10'', ''88057'', ''Institutional''),
(''Preferred Benefits Administrator - A Coventry Health Care Plan'', ''25133'', ''25133'', ''Institutional''),
(''Preferred Benefits Administrator - A Coventry Health Care Plan'', ''25133'', ''25133'', ''Professional''),
(''Preferred Care Partners - Miami, Florida'', ''65088'', ''65088'', ''Institutional''),
(''Preferred Care Partners - Miami, Florida'', ''65088'', ''65088'', ''Professional''),
(''Preferred Community Choice / PCCSelect / CompMed'', ''73145'', ''73145'', ''Institutional''),
(''Preferred Community Choice / PCCSelect / CompMed'', ''73145'', ''73145'', ''Professional''),
(''Preferred Employers'', ''J1095'', ''J1095'', ''Institutional''),
(''Preferred Employers'', ''J1095'', ''J1095'', ''Professional''),
(''Preferred Employers Group'', ''J1096'', ''J1096'', ''Institutional''),
(''Preferred Employers Group'', ''J1096'', ''J1096'', ''Professional''),
(''Preferred Employers Insurance Company (PEI)'', ''J1496'', ''J1496'', ''Institutional''),
(''Preferred Employers Insurance Company (PEI)'', ''J1496'', ''J1496'', ''Professional''),
(''Preferred Health Partners'', ''14966'', ''14966'', ''Institutional''),
(''Preferred Health Partners'', ''14966'', ''14966'', ''Professional''),
(''Preferred Health Plan of the Carolinas'', ''CB404'', ''CB404'', ''Institutional''),
(''Preferred Health Plan of the Carolinas'', ''CB404'', ''CB404'', ''Professional''),
(''Preferred Health Professionals (PHP) (ASK)'', ''31478'', ''31478'', ''Institutional''),
(''Preferred Health Professionals (PHP) (ASK)'', ''31478'', ''31478'', ''Professional''),
(''Preferred IPA (CA)'', ''PFIPA'', ''PFIPA'', ''Institutional''),
(''Preferred IPA (CA)'', ''PFIPA'', ''PFIPA'', ''Professional''),
(''Preferred Medicare Choice'', ''PREMD'', ''92131'', ''Professional''),
(''Preferred Mutual'', ''J3864'', ''J3864'', ''Institutional''),
(''Preferred Mutual'', ''J3864'', ''J3864'', ''Professional''),
(''Preferred Network Access, Inc. - Darien, Illinois'', ''36401'', ''36401'', ''Institutional''),
(''Preferred Network Access, Inc. - Darien, Illinois'', ''36401'', ''36401'', ''Professional''),
(''PreferredOne - Minnesota'', ''41147'', ''41147'', ''Institutional''),
(''PreferredOne - Minnesota'', ''41147'', ''41147'', ''Professional''),
(''Premier Care of Northern California'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Premier Care of Northern California'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Premier Eye Care'', ''65054'', ''65054'', ''Professional''),
(''Premier Health Plan'', ''251PR'', ''251PR'', ''Institutional''),
(''Premier Health Plan'', ''251PR'', ''251PR'', ''Professional''),
(''Premier Health Systems'', ''29076'', ''29076'', ''Institutional''),
(''Premier Health Systems'', ''29076'', ''29076'', ''Professional''),
(''Premier HealthCare Exchange (PHX) - Auxiant'', ''88050'', ''88050'', ''Institutional''),
(''Premier HealthCare Exchange (PHX) - Auxiant'', ''88051'', ''88050'', ''Professional''),
(''Premier HealthCare Exchange (PHX) - The Benefit Group'', ''88051'', ''88051'', ''Institutional''),
(''Premier HealthCare Exchange (PHX) - The Benefit Group'', ''88051'', ''88051'', ''Professional''),
(''Premier Physician Alliance'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Premier Physician Alliance'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Premier Physician Network'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Premier Physician Network'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Premier Physician Network (PPN)'', ''MPM22'', ''MPM22'', ''Institutional''),
(''Premier Physician Network (PPN)'', ''MPM22'', ''MPM22'', ''Professional''),
(''Presbyterian Centennial Care'', ''PRESA'', ''PRESA'', ''Institutional''),
(''Presbyterian Centennial Care'', ''PRESA'', ''PRESA'', ''Professional''),
(''Presbyterian Health Plan (Commercial)'', ''PREHP'', ''PREHP'', ''Institutional''),
(''Presbyterian Health Plan (Commercial)'', ''PREHP'', ''PREHP'', ''Professional''),
(''Presbyterian Intercommunity Hospital (PIH)'', ''BHP01'', ''BHP01'', ''Professional''),
(''Presbyterian Salud!'', ''PRESA'', ''PRESA'', ''Institutional''),
(''Presbyterian Salud!'', ''PRESA'', ''PRESA'', ''Professional''),
(''Preserver Insurance Company'', ''J3962'', ''J3962'', ''Institutional''),
(''Preserver Insurance Company'', ''J3962'', ''J3962'', ''Professional''),
(''Prestige Health Choice'', ''77003'', ''77003'', ''Institutional''),
(''Prestige Health Choice'', ''77003'', ''77003'', ''Professional''),
(''Prestige Health Choice - Florida True Health'', ''77003'', ''77003'', ''Institutional''),
(''Prestige Health Choice - Florida True Health'', ''77003'', ''77003'', ''Professional''),
(''Prevea Health Insurance Plan'', ''39185'', ''ARISE'', ''Professional''),
(''Primaria VillageMD of Central Indiana'', ''13027'', ''13027'', ''Professional''),
(''Primary Care & Pediatrics IPA (PCPIPA)'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Primary Care & Pediatrics IPA (PCPIPA)'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Primary Care Associates Medical Group (NAMM)'', ''IP079'', ''IP079'', ''Institutional''),
(''Primary Care Associates Medical Group (NAMM)'', ''IP079'', ''IP079'', ''Professional''),
(''Primary Care Associates of CA'', ''PCACZ'', ''PCACZ'', ''Professional''),
(''Primary Care of Joliet'', ''PCJOL'', ''PCJOL'', ''Institutional''),
(''Primary Care of Joliet'', ''PCJOL'', ''PCJOL'', ''Professional''),
(''Primary Care Practice of Sacramento - EHS'', ''SYMED'', ''SYMED'', ''Professional''),
(''Primary Health Network'', ''82048'', ''82048'', ''Institutional''),
(''Primary Health Network'', ''82048'', ''82048'', ''Professional''),
(''Primary PhysicianCare, Inc.'', ''56144'', ''56144'', ''Institutional''),
(''Primary PhysicianCare, Inc.'', ''56144'', ''56144'', ''Professional''),
(''Primary Provider Management Company'', ''PPM01'', ''PPM01'', ''Institutional''),
(''Primary Provider Management Company'', ''PPM01'', ''PPM01'', ''Professional''),
(''Prime Community Care Central Valley'', ''MVCV1'', ''PCCCV'', ''Professional''),
(''Prime Healthcare'', ''J1673'', ''J1673'', ''Institutional''),
(''Prime Healthcare'', ''J1673'', ''J1673'', ''Professional''),
(''Prime Property & Casulty'', ''C1081'', ''C1081'', ''Institutional''),
(''Prime Property & Casulty'', ''C1081'', ''C1081'', ''Professional''),
(''Prime Vision Health'', ''56190'', ''56190'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Chino'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Chino'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Citrus Valley'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Citrus Valley'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Coachella Valley'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Coachella Valley'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Corona'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Corona'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Hemet'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Hemet'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Inland Valley'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Inland Valley'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Moreno Valley'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Moreno Valley'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) North American Medical Management (CA)'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) North American Medical Management (CA)'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Redlands'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Redlands'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Riverside'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Riverside'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) San Bernardino'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) San Bernardino'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Sun City'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Sun City'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeCare Medical Network (NAMM) Temecula'', ''IP079'', ''IP079'', ''Institutional''),
(''PrimeCare Medical Network (NAMM) Temecula'', ''IP079'', ''IP079'', ''Professional''),
(''PrimeSource Health Network'', ''04320'', ''04320'', ''Institutional''),
(''PrimeSource Health Network'', ''04320'', ''04320'', ''Professional''),
(''PrimeWest Health Plan'', ''61604'', ''61604'', ''Institutional''),
(''PrimeWest Health Plan'', ''61604'', ''61604'', ''Professional''),
(''Prince George''''s County Government (MD)'', ''J1891'', ''J1891'', ''Institutional''),
(''Prince George''''s County Government (MD)'', ''J1891'', ''J1891'', ''Professional''),
(''Princeton Premier IPA'', ''PRI01'', ''PRI01'', ''Professional''),
(''Principal Financial Group'', ''61271'', ''61271'', ''Professional''),
(''Principal Life Insurance Company'', ''61271'', ''61271'', ''Professional''),
(''Priority Health'', ''38217'', ''38217'', ''Institutional''),
(''Priority Health'', ''38217'', ''38217'', ''Professional''),
(''Prism - Univera'', ''37315'', ''37315'', ''Institutional''),
(''Prism - Univera'', ''37315'', ''37315'', ''Professional''),
(''Prism Network, Inc.'', ''37268'', ''37268'', ''Professional''),
(''PRIZM Solutions'', ''PRIZ1'', ''WCPAP'', ''Institutional''),
(''PRIZM Solutions'', ''PRIZ1'', ''WCPAP'', ''Professional''),
(''Pro-Claim Plus, Inc.'', ''30031'', ''30031'', ''Institutional''),
(''Pro-Claim Plus, Inc.'', ''30031'', ''30031'', ''Professional''),
(''ProCare (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Institutional''),
(''ProCare (Prospect Medical Group)'', ''PROSP'', ''PROSP'', ''Professional''),
(''ProCare (TX)'', ''PTX01'', ''PTX01'', ''Institutional''),
(''ProCare (TX)'', ''PTX01'', ''PTX01'', ''Professional''),
(''ProCare MSO'', ''PCMSO'', ''PCMSO'', ''Professional''),
(''Productive Programming, Inc. (PPI)'', ''13396'', ''13396'', ''Institutional''),
(''Productive Programming, Inc. (PPI)'', ''13396'', ''13396'', ''Professional''),
(''Professional Benefit Administrators, Inc. - Oak Brook, Illinois'', ''36331'', ''36331'', ''Institutional''),
(''Professional Benefit Administrators, Inc. - Oak Brook, Illinois'', ''36331'', ''36331'', ''Professional''),
(''Professional Claims Management'', ''J1821'', ''J1821'', ''Professional''),
(''Professional Claims Management'', ''J1821'', ''PAPER'', ''Professional''),
(''Professional Risk Management'', ''34134'', ''34134'', ''Institutional''),
(''Professional Risk Management'', ''34134'', ''34134'', ''Professional''),
(''Progressive'', ''J1748'', ''J1748'', ''Institutional''),
(''Progressive'', ''J1748'', ''J1748'', ''Professional''),
(''Progressive Casualty Insurance Company'', ''J3692'', ''J3692'', ''Institutional''),
(''Progressive Casualty Insurance Company'', ''J3692'', ''J3692'', ''Professional''),
(''Progressive Classic Insurance Company'', ''J1788'', ''J1788'', ''Institutional''),
(''Progressive Classic Insurance Company'', ''J1788'', ''J1788'', ''Professional''),
(''Progressive Commercial Casualty Company'', ''J1779'', ''J1779'', ''Institutional''),
(''Progressive Commercial Casualty Company'', ''J1779'', ''J1779'', ''Professional''),
(''Progressive Direct Insurance Company'', ''J1780'', ''J1780'', ''Institutional''),
(''Progressive Direct Insurance Company'', ''J1780'', ''J1780'', ''Professional''),
(''Progressive Max Insurance Company'', ''J1783'', ''J1783'', ''Institutional''),
(''Progressive Max Insurance Company'', ''J1783'', ''J1783'', ''Professional''),
(''Progressive Medical Associates Inc'', ''PMAI2'', ''PMAI2'', ''Institutional''),
(''Progressive Medical Associates Inc'', ''PMAI2'', ''PMAI2'', ''Professional''),
(''Progressive Northern Insurance Company'', ''J1786'', ''J1786'', ''Institutional''),
(''Progressive Northern Insurance Company'', ''J1786'', ''J1786'', ''Professional''),
(''Progressive Northwestern Insurance Company'', ''J1787'', ''J1787'', ''Institutional''),
(''Progressive Northwestern Insurance Company'', ''J1787'', ''J1787'', ''Professional''),
(''Progressive Preferred Insurance Company'', ''J1785'', ''J1785'', ''Institutional''),
(''Progressive Preferred Insurance Company'', ''J1785'', ''J1785'', ''Professional''),
(''Progressive Premier Insurance Company'', ''J1781'', ''J1781'', ''Institutional''),
(''Progressive Premier Insurance Company'', ''J1781'', ''J1781'', ''Professional''),
(''Progressive Specialty Insurance Company'', ''J1784'', ''J1784'', ''Institutional''),
(''Progressive Specialty Insurance Company'', ''J1784'', ''J1784'', ''Professional''),
(''Progyny'', ''PROGY'', ''PROGY'', ''Institutional''),
(''Progyny'', ''PROGY'', ''PROGY'', ''Professional''),
(''ProMed HealthCare Administrators (California)'', ''PROSP'', ''PROSP'', ''Professional''),
(''Promina'', ''58226'', ''58226'', ''Institutional''),
(''Promina'', ''58226'', ''58226'', ''Professional''),
(''Prominence Health Plan'', ''88029'', ''88029'', ''Institutional''),
(''Prominence Health Plan'', ''88029'', ''88029'', ''Professional''),
(''Prominence Health Plan of Nevada'', ''93082'', ''93082'', ''Institutional''),
(''Prominence Health Plan of Nevada'', ''93082'', ''93082'', ''Professional''),
(''Prominence Health Plan of Texas'', ''80095'', ''80095'', ''Institutional''),
(''Prominence Health Plan of Texas'', ''80095'', ''80095'', ''Professional''),
(''Property & Casualty Co of Hartford'', ''C1040'', ''C1040'', ''Institutional''),
(''Property & Casualty Co of Hartford'', ''C1040'', ''C1040'', ''Professional''),
(''Prospect Health Network'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Prospect Health Network'', ''PROSP'', ''PROSP'', ''Professional''),
(''Prospect Health Services of Texas'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Prospect Health Services of Texas'', ''PROSP'', ''PROSP'', ''Professional''),
(''Prospect Medical Group'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Prospect Medical Group'', ''PROSP'', ''PROSP'', ''Professional''),
(''Prospect Provider Group of Rhode Island'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Prospect Provider Group of Rhode Island'', ''PROSP'', ''PROSP'', ''Professional''),
(''Prospect Sherman Oaks Medical Group'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Prospect Sherman Oaks Medical Group'', ''PROSP'', ''PROSP'', ''Professional''),
(''PROSSAM Asociacion de Maestros'', ''94027'', ''94027'', ''Professional''),
(''Protective Insurance Co'', ''J1568'', ''J1568'', ''Institutional''),
(''Protective Insurance Co'', ''J1568'', ''J1568'', ''Professional''),
(''Providence Health Plan'', ''SX133'', ''SX133'', ''Institutional''),
(''Providence Health Plan'', ''SX133'', ''SX133'', ''Professional''),
(''Providence Insurance and Admin Service'', ''PAS01'', ''PAS01'', ''Institutional''),
(''Providence Insurance and Admin Service'', ''PAS01'', ''PAS01'', ''Professional''),
(''Providence PPO'', ''PHP00'', ''PHP00'', ''Professional''),
(''Providence PPO'', ''SX187'', ''PHP00'', ''Institutional''),
(''Provident Life & Accident Insurance Company of America'', ''68195'', ''68195'', ''Institutional''),
(''Provident Life & Accident Insurance Company of America'', ''68195'', ''68195'', ''Professional''),
(''Provident Preferred of Washington'', ''91131'', ''91131'', ''Institutional''),
(''Provident Preferred of Washington'', ''91131'', ''91131'', ''Professional''),
(''Provider Partners Health Plan of Illinois'', ''31401'', ''31401'', ''Institutional''),
(''Provider Partners Health Plan of Illinois'', ''31401'', ''31401'', ''Professional''),
(''Provider Partners Health Plan of Maryland (formerly Tribute)'', ''31118'', ''31118'', ''Institutional''),
(''Provider Partners Health Plan of Maryland (formerly Tribute)'', ''31118'', ''31118'', ''Professional''),
(''Provider Partners Health Plan of Ohio'', ''31402'', ''31402'', ''Institutional''),
(''Provider Partners Health Plan of Ohio'', ''31402'', ''31402'', ''Professional''),
(''Provider Partners Health Plan of Pennsylvania'', ''31400'', ''31400'', ''Institutional''),
(''Provider Partners Health Plan of Pennsylvania'', ''31400'', ''31400'', ''Professional''),
(''ProviDRs Care Network'', ''48100'', ''48100'', ''Institutional''),
(''ProviDRs Care Network'', ''48100'', ''48100'', ''Professional''),
(''Prudent Medical Group'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Prudent Medical Group'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Prudent Medical Group'', ''MPM25'', ''MPM25'', ''Professional''),
(''Prudential Overall Supply - AZ, CA'', ''41556'', ''41556'', ''Institutional''),
(''Prudential Overall Supply - AZ, CA'', ''41556'', ''41556'', ''Professional''),
(''Pruitt Health Premier'', ''PH001'', ''PH001'', ''Institutional''),
(''Pruitt Health Premier'', ''PH001'', ''PH001'', ''Professional''),
(''Public Alliance Insurance Coverage Fund (PAIC Jif)'', ''J3936'', ''J3936'', ''Institutional''),
(''Public Alliance Insurance Coverage Fund (PAIC Jif)'', ''J3936'', ''J3936'', ''Professional''),
(''Publix Super Markets, Inc.'', ''J1897'', ''J1897'', ''Professional''),
(''Puget Sound Benefits Trust'', ''91136'', ''91136'', ''Institutional''),
(''Puget Sound Benefits Trust'', ''91136'', ''91136'', ''Professional''),
(''Puget Sound Electrical Workers Trust'', ''91136'', ''91136'', ''Institutional''),
(''Puget Sound Electrical Workers Trust'', ''91136'', ''91136'', ''Professional''),
(''QBE - General Casualty - Eden Prairie'', ''J1485'', ''J1485'', ''Institutional''),
(''QBE - General Casualty - Eden Prairie'', ''J1485'', ''J1485'', ''Professional''),
(''QBE - General Casualty - Farmers Union'', ''J1483'', ''J1483'', ''Institutional''),
(''QBE - General Casualty - Farmers Union'', ''J1483'', ''J1483'', ''Professional''),
(''QBE - General Casualty - Freeport'', ''J1486'', ''J1486'', ''Institutional''),
(''QBE - General Casualty - Freeport'', ''J1486'', ''J1486'', ''Professional''),
(''QBE - General Casualty - Indianapolis'', ''J1487'', ''J1487'', ''Institutional''),
(''QBE - General Casualty - Indianapolis'', ''J1487'', ''J1487'', ''Professional''),
(''QBE - General Casualty - Simsbury'', ''J1488'', ''J1488'', ''Institutional''),
(''QBE - General Casualty - Simsbury'', ''J1488'', ''J1488'', ''Professional''),
(''QBE - General Casualty - Sun Prairie'', ''J1489'', ''J1489'', ''Institutional''),
(''QBE - General Casualty - Sun Prairie'', ''J1489'', ''J1489'', ''Professional''),
(''QBE - General Casualty - West Des Moines'', ''J1490'', ''J1490'', ''Institutional''),
(''QBE - General Casualty - West Des Moines'', ''J1490'', ''J1490'', ''Professional''),
(''QBE - General Casualty Co of Wisconsin'', ''J1484'', ''J1484'', ''Institutional''),
(''QBE - General Casualty Co of Wisconsin'', ''J1484'', ''J1484'', ''Professional''),
(''Quad City Community Health Plan (QCCH)'', ''40437'', ''40437'', ''Institutional''),
(''Quad City Community Health Plan (QCCH)'', ''40437'', ''40437'', ''Professional''),
(''Qual-Med Colorado EPO'', ''QMDCE'', ''QMDCE'', ''Professional''),
(''Qual-Med New Mexico'', ''QUANM'', ''QUANM'', ''Institutional''),
(''Qual-Med New Mexico'', ''QUANM'', ''QUANM'', ''Professional''),
(''Qual-Med Portland (PO)'', ''QMDPO'', ''QMDPO'', ''Professional''),
(''QualCare, Inc.'', ''23342'', ''23342'', ''Institutional''),
(''QualCare, Inc.'', ''23342'', ''23342'', ''Professional''),
(''QualCare, Inc. (dba QANI Admin.)'', ''22312'', ''22312'', ''Institutional''),
(''QualCare, Inc. (dba QANI Admin.)'', ''22312'', ''22312'', ''Professional''),
(''QualChoice of Arkansas'', ''35174'', ''35174'', ''Institutional''),
(''QualChoice of Arkansas'', ''35174'', ''35174'', ''Professional''),
(''Quality Care Conv'', ''41556'', ''41556'', ''Institutional''),
(''Quality Care Conv'', ''41556'', ''41556'', ''Professional''),
(''Quality Care Partners'', ''89461'', ''89461'', ''Institutional''),
(''Quality Care Partners'', ''89461'', ''89461'', ''Professional''),
(''Quality Health M. G.'', ''41556'', ''41556'', ''Institutional''),
(''Quality Health M. G.'', ''41556'', ''41556'', ''Professional''),
(''Quality Health Plans of New York'', ''88622'', ''88622'', ''Professional''),
(''Quartz ASO'', ''46571'', ''46571'', ''Institutional''),
(''Quartz ASO'', ''46571'', ''46571'', ''Professional''),
(''Quartz Health Solutions, Inc.'', ''66705'', ''66705'', ''Institutional''),
(''Quartz Health Solutions, Inc.'', ''66705'', ''66705'', ''Professional''),
(''Queen of Angels - Hollywood'', ''41556'', ''41556'', ''Institutional''),
(''Queen of Angels - Hollywood'', ''41556'', ''41556'', ''Professional''),
(''QuikTrip'', ''73067'', ''73067'', ''Institutional''),
(''QuikTrip'', ''73067'', ''73067'', ''Professional''),
(''QVI Risk Solutions, Inc'', ''57117'', ''57117'', ''Professional''),
(''R & N Market'', ''TKFMC'', ''TKFMC'', ''Professional''),
(''Rady  Children''''s Health Network'', ''RCHN1'', ''RCHN1'', ''Professional''),
(''Rady Children''''s Specialists of San Diego'', ''CSSD2'', ''CSSD2'', ''Institutional''),
(''Rady Children''''s Specialists of San Diego'', ''CSSD2'', ''CSSD2'', ''Professional''),
(''Raley''''s Family of Fine Stores'', ''J1522'', ''J1522'', ''Institutional''),
(''Raley''''s Family of Fine Stores'', ''J1522'', ''J1522'', ''Professional''),
(''Ralph Lauren'', ''J1938'', ''J1938'', ''Institutional''),
(''Ralph Lauren'', ''J1938'', ''J1938'', ''Professional''),
(''RAM Mutual Insurance Company'', ''J1894'', ''J1894'', ''Institutional''),
(''RAM Mutual Insurance Company'', ''J1894'', ''J1894'', ''Professional''),
(''Rampart Insurance Company'', ''38512'', ''38512'', ''Institutional''),
(''Rampart Insurance Company'', ''38512'', ''38512'', ''Professional''),
(''Ramsey County (MN)'', ''J1663'', ''J1663'', ''Institutional''),
(''Ramsey County (MN)'', ''J1663'', ''J1663'', ''Professional''),
(''Rancho Santiago Community College District (CA)'', ''J1635'', ''J1635'', ''Institutional''),
(''Rancho Santiago Community College District (CA)'', ''J1635'', ''J1635'', ''Professional''),
(''Ravenswood Physician Associates'', ''RPAWC'', ''RPAWC'', ''Institutional''),
(''Ravenswood Physician Associates'', ''RPAWC'', ''RPAWC'', ''Professional''),
(''RBMS, LLC'', ''41124'', ''41124'', ''Institutional''),
(''RBMS, LLC'', ''41124'', ''41124'', ''Professional''),
(''RCH Protective - SNCC'', ''41556'', ''41556'', ''Institutional''),
(''RCH Protective - SNCC'', ''41556'', ''41556'', ''Professional''),
(''Reading Hospital Employee Group'', ''44219'', ''44219'', ''Institutional''),
(''Reading Hospital Employee Group'', ''44219'', ''44219'', ''Professional''),
(''Recology'', ''J1675'', ''J1675'', ''Institutional''),
(''Recology'', ''J1675'', ''J1675'', ''Professional''),
(''Red Oak Independent School District'', ''A0205'', ''A0205'', ''Institutional''),
(''Red Oak Independent School District'', ''A0205'', ''A0205'', ''Professional''),
(''Redlands-Yucaipa Medical Group'', ''18247'', ''18247'', ''Professional''),
(''Redwood Fire and Casualty Insurance Company (Member of BHHC)'', ''20044'', ''20044'', ''Institutional''),
(''Redwood Fire and Casualty Insurance Company (Member of BHHC)'', ''20044'', ''20044'', ''Professional''),
(''Regal Medical Group (California)'', ''REGAL'', ''REGAL'', ''Institutional''),
(''Regal Medical Group (California)'', ''REGAL'', ''REGAL'', ''Professional''),
(''Regence Group Administrators (RGA)'', ''RGA01'', ''RGA01'', ''Institutional''),
(''Regence Group Administrators (RGA)'', ''RGA01'', ''RGA01'', ''Professional''),
(''Regency Employee Benefits'', ''38221'', ''38221'', ''Institutional''),
(''Regency Employee Benefits'', ''38221'', ''38221'', ''Professional''),
(''Regent Insurance Company - QBE DBA'', ''J1484'', ''J1484'', ''Institutional''),
(''Regent Insurance Company - QBE DBA'', ''J1484'', ''J1484'', ''Professional''),
(''Regent Medical Group'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Regent Medical Group'', ''HSM01'', ''HSM01'', ''Professional''),
(''Regional Care, Inc.'', ''47076'', ''47076'', ''Institutional''),
(''Regional Care, Inc.'', ''47076'', ''47076'', ''Professional''),
(''Regis Brands (Bunch CareSolutions)'', ''J1467'', ''J1467'', ''Institutional''),
(''Regis Brands (Bunch CareSolutions)'', ''J1467'', ''J1467'', ''Professional''),
(''Rehab Center of Beverly Hills'', ''41556'', ''41556'', ''Institutional''),
(''Rehab Center of Beverly Hills'', ''41556'', ''41556'', ''Professional''),
(''Religious Order of Jehovah''''s Witnesses'', ''ROJW1'', ''ROJW1'', ''Professional''),
(''Renaissance Life and Health Ins. Co. of America'', ''87020'', ''87020'', ''Institutional''),
(''Renaissance Life and Health Ins. Co. of America'', ''87020'', ''87020'', ''Professional''),
(''Renaissance Physicians Organization'', ''76066'', ''76066'', ''Institutional''),
(''Renaissance Physicians Organization'', ''76066'', ''76066'', ''Professional''),
(''Republic Franklin Insurance'', ''12475'', ''12475'', ''Institutional''),
(''Republic Franklin Insurance'', ''12475'', ''12475'', ''Professional''),
(''Republic Indemnity Company of America'', ''J1008'', ''J1008'', ''Institutional''),
(''Republic Indemnity Company of America'', ''J1008'', ''J1008'', ''Professional''),
(''Republic Western Ins. Co'', ''J1597'', ''J1597'', ''Institutional''),
(''Republic Western Ins. Co'', ''J1597'', ''J1597'', ''Professional''),
(''Rescare, Inc.'', ''J1376'', ''J1376'', ''Professional''),
(''Residential Services Group'', ''J1097'', ''J1097'', ''Institutional''),
(''Residential Services Group'', ''J1097'', ''J1097'', ''Professional''),
(''Resolute Forest Products'', ''J1954'', ''J1954'', ''Institutional''),
(''Resolute Forest Products'', ''J1954'', ''J1954'', ''Professional''),
(''Resolve Health Plan Administrators'', ''RHA01'', ''RHA01'', ''Institutional''),
(''Resolve Health Plan Administrators'', ''RHA01'', ''RHA01'', ''Professional''),
(''Resource One Administrators'', ''20333'', ''20333'', ''Institutional''),
(''Resource One Administrators'', ''20333'', ''20333'', ''Professional''),
(''ResourceOne Administrators'', ''37278'', ''37278'', ''Institutional''),
(''ResourceOne Administrators'', ''37278'', ''37278'', ''Professional''),
(''Restaurant Reinsurance Limited'', ''J1098'', ''J1098'', ''Institutional''),
(''Restaurant Reinsurance Limited'', ''J1098'', ''J1098'', ''Professional''),
(''Restoration Prof'', ''41556'', ''41556'', ''Institutional''),
(''Restoration Prof'', ''41556'', ''41556'', ''Professional''),
(''Resurrection Health Care Preferred'', ''36396'', ''36396'', ''Institutional''),
(''Resurrection Health Care Preferred'', ''36396'', ''36396'', ''Professional''),
(''Resurrection Physician Provider Group'', ''RPPG1'', ''RPPG1'', ''Institutional''),
(''Resurrection Physician Provider Group'', ''RPPG1'', ''RPPG1'', ''Professional''),
(''Retail Business Services (RBS)'', ''J3733'', ''J3733'', ''Institutional''),
(''Retail Business Services (RBS)'', ''J3733'', ''J3733'', ''Professional''),
(''Return to Work'', ''J1202'', ''J1202'', ''Institutional''),
(''Return to Work'', ''J1202'', ''J1202'', ''Professional''),
(''RevMed'', ''J1848'', ''J1848'', ''Institutional''),
(''RevMed'', ''J1848'', ''J1848'', ''Professional''),
(''Rhone-Poulenc,Inc.'', ''J1099'', ''J1099'', ''Institutional''),
(''Rhone-Poulenc,Inc.'', ''J1099'', ''J1099'', ''Professional''),
(''Richardson ISD (Tristar Risk Management)'', ''J3974'', ''J3974'', ''Institutional''),
(''Richardson ISD (Tristar Risk Management)'', ''J3974'', ''J3974'', ''Professional''),
(''Rick Concrete Const.'', ''41556'', ''41556'', ''Institutional''),
(''Rick Concrete Const.'', ''41556'', ''41556'', ''Professional''),
(''Rieth-Riley Construction Compa'', ''J1100'', ''J1100'', ''Institutional''),
(''Rieth-Riley Construction Compa'', ''J1100'', ''J1100'', ''Professional''),
(''Right Care from Scott & White'', ''74205'', ''74205'', ''Institutional''),
(''Right Care from Scott & White'', ''74205'', ''74205'', ''Professional''),
(''Right Choice Benefit Administrators'', ''37331'', ''37331'', ''Institutional''),
(''Right Choice Benefit Administrators'', ''37331'', ''37331'', ''Professional''),
(''RISICO'', ''J1974'', ''J1974'', ''Institutional''),
(''RISICO'', ''J1974'', ''J1974'', ''Professional''),
(''Risk Administration Services'', ''J1828'', ''J1828'', ''Institutional''),
(''Risk Administration Services'', ''J1828'', ''J1828'', ''Professional''),
(''Risk Enterprise Management (REM)'', ''J1491'', ''J1491'', ''Institutional''),
(''Risk Enterprise Management (REM)'', ''J1491'', ''J1491'', ''Professional''),
(''Risk Transfer Technologies, Inc.'', ''J1101'', ''J1101'', ''Institutional''),
(''Risk Transfer Technologies, Inc.'', ''J1101'', ''J1101'', ''Professional''),
(''River City Medical Group'', ''RCMG1'', ''RCMG1'', ''Institutional''),
(''River City Medical Group'', ''RCMG1'', ''RCMG1'', ''Professional''),
(''Riverport Insurance (MN School Board Association)'', ''J1546'', ''J1546'', ''Institutional''),
(''Riverport Insurance (MN School Board Association)'', ''J1546'', ''J1546'', ''Professional''),
(''Riverport Insurance Company (Agricultural ONLY)'', ''J1477'', ''J1477'', ''Institutional''),
(''Riverport Insurance Company (Agricultural ONLY)'', ''J1477'', ''J1477'', ''Professional''),
(''Riverside Health of Maryland'', ''45281'', ''45281'', ''Institutional''),
(''Riverside Health of Maryland'', ''45281'', ''45281'', ''Professional''),
(''Riverspring Health Plan - Elderserv'', ''05178'', ''05178'', ''Institutional''),
(''Riverspring Health Plan - Elderserv'', ''05178'', ''05178'', ''Professional''),
(''RMSCO, INC. - Liverpool, New York'', ''16117'', ''16117'', ''Institutional''),
(''RMSCO, INC. - Liverpool, New York'', ''16117'', ''16117'', ''Professional''),
(''Robstown ISD'', ''41556'', ''41556'', ''Institutional''),
(''Robstown ISD'', ''41556'', ''41556'', ''Professional''),
(''Rockwall ISD'', ''41556'', ''41556'', ''Institutional''),
(''Rockwall ISD'', ''41556'', ''41556'', ''Professional''),
(''Rocky Mountain Health Plan'', ''84065'', ''84065'', ''Institutional''),
(''Rocky Mountain Health Plan'', ''SX141'', ''SX141'', ''Professional''),
(''Rooney Life Inc'', ''37602'', ''37602'', ''Institutional''),
(''Rooney Life Inc'', ''37602'', ''37602'', ''Professional''),
(''Rose Garden Guest Ho'', ''41556'', ''41556'', ''Institutional''),
(''Rose Garden Guest Ho'', ''41556'', ''41556'', ''Professional''),
(''Rosemont of Des Plaines, Illinois'', ''36215'', ''36215'', ''Institutional''),
(''Rosemont of Des Plaines, Illinois'', ''36215'', ''36215'', ''Professional''),
(''Rosewoood Equipment'', ''41556'', ''41556'', ''Institutional''),
(''Rosewoood Equipment'', ''41556'', ''41556'', ''Professional''),
(''Rossi Concrete, Inc'', ''41556'', ''41556'', ''Institutional''),
(''Rossi Concrete, Inc'', ''41556'', ''41556'', ''Professional''),
(''Royal Healthcare Extended Care MLTC'', ''46166'', ''46166'', ''Institutional''),
(''Royal Healthcare Extended Care MLTC'', ''46166'', ''46166'', ''Professional''),
(''RSC Insurance Services, Ltd.'', ''J1102'', ''J1102'', ''Institutional''),
(''RSC Insurance Services, Ltd.'', ''J1102'', ''J1102'', ''Professional''),
(''Rural Carrier Benefit Plan (Coventry)'', ''25133'', ''25133'', ''Institutional''),
(''Rural Carrier Benefit Plan (Coventry)'', ''25133'', ''25133'', ''Professional''),
(''Rural Special District Insurance Program'', ''41556'', ''41556'', ''Institutional''),
(''Rural Special District Insurance Program'', ''41556'', ''41556'', ''Professional''),
(''Rush Prudential Health Plans (HMO Only)'', ''36389'', ''36389'', ''Institutional''),
(''Rush Prudential Health Plans (HMO Only)'', ''36389'', ''36389'', ''Professional''),
(''Rutgers Casualty Insurance'', ''C1101'', ''C1101'', ''Institutional''),
(''Rutgers Casualty Insurance'', ''C1101'', ''C1101'', ''Professional''),
(''Rvierside University Health Systems - MISP'', ''00930'', ''00930'', ''Professional''),
(''Ryder Services, Inc.'', ''J1009'', ''J1009'', ''Institutional''),
(''Ryder Services, Inc.'', ''J1009'', ''J1009'', ''Professional''),
(''S & S Healthcare Strategies'', ''31441'', ''31441'', ''Institutional''),
(''S & S Healthcare Strategies'', ''31441'', ''31441'', ''Professional''),
(''SA Recycling, LLC'', ''J1728'', ''J1728'', ''Institutional''),
(''SA Recycling, LLC'', ''J1728'', ''J1728'', ''Professional''),
(''Safe TPA'', ''J3770'', ''J3770'', ''Institutional''),
(''Safe TPA'', ''J3770'', ''J3770'', ''Professional''),
(''SafeCo Insurance'', ''24740'', ''24740'', ''Institutional''),
(''SafeCo Insurance'', ''24740'', ''24740'', ''Professional''),
(''Safeco Insurance - AUTO ONLY'', ''C1053'', ''C1053'', ''Institutional''),
(''Safeco Insurance - AUTO ONLY'', ''C1053'', ''C1053'', ''Professional''),
(''SafeGuard'', ''SAFEG'', ''PAPER'', ''Professional''),
(''SafeShore - STA'', ''J3785'', ''J3785'', ''Institutional''),
(''SafeShore - STA'', ''J3785'', ''J3785'', ''Professional''),
(''Safety-Kleen Corporation'', ''J1103'', ''J1103'', ''Institutional''),
(''Safety-Kleen Corporation'', ''J1103'', ''J1103'', ''Professional''),
(''Sagamore Health Network'', ''35164'', ''35164'', ''Institutional''),
(''Sagamore Health Network'', ''35164'', ''35164'', ''Professional''),
(''Saint Agnes Medical Group'', ''CAPMN'', ''CAPMN'', ''Institutional''),
(''Saint Agnes Medical Group'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''Saint Louis County (MN)'', ''J1658'', ''J1658'', ''Institutional''),
(''Saint Louis County (MN)'', ''J1658'', ''J1658'', ''Professional''),
(''Salt Lake City Corporation'', ''41556'', ''41556'', ''Institutional''),
(''Salt Lake City Corporation'', ''41556'', ''41556'', ''Professional''),
(''Salt Lake City Corporation'', ''J1730'', ''J1730'', ''Institutional''),
(''Salt Lake City Corporation'', ''J1730'', ''J1730'', ''Professional''),
(''Sam Kane Beef Processors, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Sam Kane Beef Processors, Inc.'', ''41556'', ''41556'', ''Professional''),
(''Samaritan Given - Samaritan Ministries Int''''l'', ''SM325'', ''SM325'', ''Institutional''),
(''Samaritan Given - Samaritan Ministries Int''''l'', ''SM325'', ''SM325'', ''Professional''),
(''Samaritan Health Plans'', ''CP001'', ''CP001'', ''Institutional''),
(''Samaritan Health Plans'', ''CP001'', ''CP001'', ''Professional''),
(''SAMBA (Special Agents Mutual Benefit Association)'', ''62308'', ''62308'', ''Institutional''),
(''SAMBA (Special Agents Mutual Benefit Association)'', ''62308'', ''62308'', ''Professional''),
(''San Bernardino City Unified School District'', ''J1741'', ''J1741'', ''Institutional''),
(''San Bernardino City Unified School District'', ''J1741'', ''J1741'', ''Professional''),
(''San Bernardino County Superintendent of Schools (CA)'', ''J1690'', ''J1690'', ''Institutional''),
(''San Bernardino County Superintendent of Schools (CA)'', ''J1690'', ''J1690'', ''Professional''),
(''San Bernardino Medical Group (SBMED)'', ''SBMED'', ''SBMED'', ''Professional''),
(''San Diego Community College District (CA)'', ''J1638'', ''J1638'', ''Institutional''),
(''San Diego Community College District (CA)'', ''J1638'', ''J1638'', ''Professional''),
(''San Diego Hospice and The Institute for Palliative Medicine'', ''41556'', ''41556'', ''Institutional''),
(''San Diego Hospice and The Institute for Palliative Medicine'', ''41556'', ''41556'', ''Professional''),
(''San Diego Metropolitan Transit System'', ''41556'', ''41556'', ''Institutional''),
(''San Diego Metropolitan Transit System'', ''41556'', ''41556'', ''Professional''),
(''San Diego Metropolitan Transit System (SCHIP Liability)'', ''41556'', ''41556'', ''Institutional''),
(''San Diego Metropolitan Transit System (SCHIP Liability)'', ''41556'', ''41556'', ''Professional''),
(''San Diego PACE'', ''96400'', ''96400'', ''Institutional''),
(''San Diego PACE'', ''96400'', ''96400'', ''Professional''),
(''San Diego Transit Corp.'', ''41556'', ''41556'', ''Institutional''),
(''San Diego Transit Corp.'', ''41556'', ''41556'', ''Professional''),
(''San Diego Trolley, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''San Diego Trolley, Inc.'', ''41556'', ''41556'', ''Professional''),
(''San Diego/Imperial Schools JPA (CA)'', ''J1656'', ''J1656'', ''Institutional''),
(''San Diego/Imperial Schools JPA (CA)'', ''J1656'', ''J1656'', ''Professional''),
(''San Francisco Health Plan, Encounters other than Healthy San Francisco'', ''SFHP1'', ''SFHP1'', ''Institutional''),
(''San Francisco Health Plan, Encounters other than Healthy San Francisco'', ''SFHP1'', ''SFHP1'', ''Professional''),
(''San Francisco Health Plan, Healthy San Francisco, (Encounters only)'', ''SFHPE'', ''SFHPE'', ''Professional''),
(''San Francisco Municipal Transportation Agency (SFMTA)'', ''J1886'', ''J1886'', ''Institutional''),
(''San Francisco Municipal Transportation Agency (SFMTA)'', ''J1886'', ''J1886'', ''Professional''),
(''San Joaquin County'', ''41556'', ''41556'', ''Institutional''),
(''San Joaquin County'', ''41556'', ''41556'', ''Professional''),
(''San Luis Obispo Select'', ''33072'', ''33072'', ''Institutional''),
(''San Luis Obispo Select'', ''33072'', ''33072'', ''Professional''),
(''Sana Benefits'', ''50114'', ''50114'', ''Institutional''),
(''Sana Benefits'', ''50114'', ''50114'', ''Professional''),
(''SandHills Center'', ''SHC30'', ''SHC30'', ''Professional''),
(''Sanford Health Plan'', ''91184'', ''91184'', ''Institutional''),
(''Sanford Health Plan'', ''91184'', ''91184'', ''Professional''),
(''Sansum Clinic'', ''SAN01'', ''SAN01'', ''Professional''),
(''Santa Barbara Select IPA Medical Group'', ''SBIPA'', ''SBIPA'', ''Professional''),
(''Santa Clara Co Office Of Educ'', ''41556'', ''41556'', ''Institutional''),
(''Santa Clara Co Office Of Educ'', ''41556'', ''41556'', ''Professional''),
(''Santa Clara County IPA (SCCIPA)'', ''10378'', ''10378'', ''Professional''),
(''Santa Clara Family Health Plan'', ''24077'', ''24077'', ''Institutional''),
(''Santa Clara Family Health Plan'', ''24077'', ''24077'', ''Professional''),
(''Santa Clara Valley Tansportation Authority'', ''J1518'', ''J1518'', ''Institutional''),
(''Santa Clara Valley Tansportation Authority'', ''J1518'', ''J1518'', ''Professional''),
(''Sante Community Medical Centers'', ''SNTCC'', ''SNTCC'', ''Institutional''),
(''Sante Community Medical Centers'', ''SNTCC'', ''SNTCC'', ''Professional''),
(''Sante Community Physicians Medical Group Corp.'', ''SNTMC'', ''SNTMC'', ''Institutional''),
(''Sante Community Physicians Medical Group Corp.'', ''SNTMC'', ''SNTMC'', ''Professional''),
(''Sante Health System and Affiliates'', ''77038'', ''77038'', ''Institutional''),
(''Sante Health System and Affiliates'', ''77038'', ''77038'', ''Professional''),
(''Satellite Health Plan, Inc'', ''45552'', ''45552'', ''Institutional''),
(''Satellite Health Plan, Inc'', ''45552'', ''45552'', ''Professional''),
(''SCAN Health Plan California'', ''SCAN1'', ''SCAN1'', ''Institutional''),
(''SCAN Health Plan California'', ''SCAN1'', ''SCAN1'', ''Professional''),
(''SCCIPA Anthem Blue Cross PPO Claims'', ''SCACO'', ''SCACO'', ''Professional''),
(''Schlumberger Technology'', ''J1104'', ''J1104'', ''Institutional''),
(''Schlumberger Technology'', ''J1104'', ''J1104'', ''Professional''),
(''Schneider Gain'', ''41556'', ''41556'', ''Institutional''),
(''Schneider Gain'', ''41556'', ''41556'', ''Professional''),
(''Schnuck Market, Inc'', ''J1560'', ''J1560'', ''Institutional''),
(''Schnuck Market, Inc'', ''J1560'', ''J1560'', ''Professional''),
(''Scott & White Healthcare'', ''88030'', ''88030'', ''Institutional''),
(''Scott & White Healthcare'', ''88030'', ''88030'', ''Professional''),
(''Scotts Miracle-Gro Company'', ''J1049'', ''J1049'', ''Institutional''),
(''Scotts Miracle-Gro Company'', ''J1049'', ''J1049'', ''Professional''),
(''Screen Actors Guild'', ''47198'', ''CABLC'', ''Institutional''),
(''Screen Actors Guild'', ''BC001'', ''CABLC'', ''Professional''),
(''Scripps Health Plan Services'', ''SHPS1'', ''SHPS1'', ''Institutional''),
(''Scripps Health Plan Services'', ''SHPS1'', ''SHPS1'', ''Professional''),
(''Seabright (SBIC)'', ''J1499'', ''J1499'', ''Institutional''),
(''Seabright (SBIC)'', ''J1499'', ''J1499'', ''Professional''),
(''Seaview IPA'', ''SVIPA'', ''SVIPA'', ''Professional''),
(''SECURA Insurance A Mutual Company'', ''J1379'', ''J1379'', ''Professional''),
(''Secure Health Plans of Georgia, LLC'', ''28530'', ''28530'', ''Institutional''),
(''Secure Health Plans of Georgia, LLC'', ''28530'', ''28530'', ''Professional''),
(''Security Health Plan'', ''39045'', ''39045'', ''Institutional''),
(''Security Health Plan'', ''39045'', ''39045'', ''Professional''),
(''Sedgwick / Cargill, Inc.'', ''J1661'', ''J1661'', ''Institutional''),
(''Sedgwick / Cargill, Inc.'', ''J1661'', ''J1661'', ''Professional''),
(''Sedgwick CMS'', ''TP097'', ''TP097'', ''Institutional''),
(''Sedgwick CMS'', ''TP097'', ''TP097'', ''Professional''),
(''SeeChange Health Plan'', ''35098'', ''SCHP1'', ''Professional''),
(''SeeChange Health Plan'', ''SCHP1'', ''SCHP1'', ''Institutional''),
(''Seeno Construction (Chartis)'', ''41556'', ''41556'', ''Institutional''),
(''Seeno Construction (Chartis)'', ''41556'', ''41556'', ''Professional''),
(''Seeno Homes'', ''41556'', ''41556'', ''Institutional''),
(''Seeno Homes'', ''41556'', ''41556'', ''Professional''),
(''Sela Health Care'', ''41556'', ''41556'', ''Institutional''),
(''Sela Health Care'', ''41556'', ''41556'', ''Professional''),
(''Select Administrative Services (SAS)'', ''64088'', ''64088'', ''Institutional''),
(''Select Administrative Services (SAS)'', ''64088'', ''64088'', ''Professional''),
(''Select Benefit Administrators Inc'', ''93031'', ''93031'', ''Institutional''),
(''Select Benefit Administrators Inc'', ''93031'', ''93031'', ''Professional''),
(''Select Benefit Administrators of America  - Ashland, Winconsin'', ''37282'', ''37282'', ''Institutional''),
(''Select Benefit Administrators of America  - Ashland, Winconsin'', ''37282'', ''37282'', ''Professional''),
(''Select Energy Services'', ''J1937'', ''J1937'', ''Institutional''),
(''Select Energy Services'', ''J1937'', ''J1937'', ''Professional''),
(''Select Health of South Carolina - First Choice (Medicaid)'', ''23285'', ''23285'', ''Institutional''),
(''Select Health of South Carolina - First Choice (Medicaid)'', ''23285'', ''23285'', ''Professional''),
(''Select Staffing (Koosharem, Real Time Staffing, Remedy, Select/Remedy & Westaff'', ''J1446'', ''J1446'', ''Institutional''),
(''Select Staffing (Koosharem, Real Time Staffing, Remedy, Select/Remedy & Westaff'', ''J1446'', ''J1446'', ''Professional''),
(''SelectCare of Oklahoma (Tribute)'', ''73117'', ''73117'', ''Institutional''),
(''SelectCare of Oklahoma (Tribute)'', ''73117'', ''73117'', ''Professional''),
(''SelectCare of Texas (HPN) Heritage Physicians Network'', ''14163'', ''14163'', ''Institutional''),
(''SelectCare of Texas (HPN) Heritage Physicians Network'', ''14163'', ''14163'', ''Professional''),
(''SelectCare of Texas (Kelsey-Sebold) aka TexanPlus'', ''14163'', ''14163'', ''Institutional''),
(''SelectCare of Texas (Kelsey-Sebold) aka TexanPlus'', ''14163'', ''14163'', ''Professional''),
(''SelectHealth'', ''SX107'', ''SX107'', ''Institutional''),
(''SelectHealth'', ''SX107'', ''SX107'', ''Professional''),
(''Selective'', ''12572'', ''12572'', ''Institutional''),
(''Selective'', ''12572'', ''12572'', ''Professional''),
(''Selective Insurance'', ''12572'', ''C1077'', ''Professional''),
(''Selective Insurance'', ''C1077'', ''C1077'', ''Institutional''),
(''Self Insured Plans'', ''36404'', ''36404'', ''Institutional''),
(''Self Insured Plans'', ''36404'', ''36404'', ''Professional''),
(''Self Insured Services Company (SISCO)'', ''00540'', ''00540'', ''Institutional''),
(''Self Insured Services Company (SISCO)'', ''00540'', ''00540'', ''Professional''),
(''Self-Funded Plans (Illinois, Pennsylvania, Ohio)'', ''34131'', ''34131'', ''Institutional''),
(''Self-Funded Plans (Illinois, Pennsylvania, Ohio)'', ''34131'', ''34131'', ''Professional''),
(''Self-Insured Schools of California (SISC)'', ''J1520'', ''J1520'', ''Institutional''),
(''Self-Insured Schools of California (SISC)'', ''J1520'', ''J1520'', ''Professional''),
(''Selman Breitman'', ''41556'', ''41556'', ''Institutional''),
(''Selman Breitman'', ''41556'', ''41556'', ''Professional''),
(''Sempra Energy/Employee Care Services'', ''J1915'', ''J1915'', ''Institutional''),
(''Sempra Energy/Employee Care Services'', ''J1915'', ''J1915'', ''Professional''),
(''Senior Health Partners (SHP)'', ''80141'', ''80141'', ''Institutional''),
(''Senior Health Partners (SHP)'', ''80141'', ''80141'', ''Professional''),
(''Senior Network Health'', ''15682'', ''15682'', ''Institutional''),
(''Senior Network Health'', ''15682'', ''15682'', ''Professional''),
(''Senior Whole Health'', ''83035'', ''83035'', ''Institutional''),
(''Senior Whole Health'', ''83035'', ''83035'', ''Professional''),
(''Sentara Family Care'', ''54154'', ''54154'', ''Institutional''),
(''Sentara Family Care'', ''54154'', ''54154'', ''Professional''),
(''Sentara Health Management'', ''54154'', ''54154'', ''Institutional''),
(''Sentara Health Management'', ''54154'', ''54154'', ''Professional''),
(''Sentinel Insurance Company LTD'', ''C1040'', ''C1040'', ''Institutional''),
(''Sentinel Insurance Company LTD'', ''C1040'', ''C1040'', ''Professional''),
(''Sentinel Management Services'', ''23249'', ''23249'', ''Institutional''),
(''Sentinel Management Services'', ''23249'', ''23249'', ''Professional''),
(''Sentinel Security Life'', ''87020'', ''87020'', ''Institutional''),
(''Sentinel Security Life'', ''87020'', ''87020'', ''Professional''),
(''Sentry Auto'', ''C1033'', ''C1033'', ''Institutional''),
(''Sentry Auto'', ''C1033'', ''C1033'', ''Professional''),
(''Sentry Casualty Company'', ''C1033'', ''C1033'', ''Institutional''),
(''Sentry Casualty Company'', ''C1033'', ''C1033'', ''Professional''),
(''Sentry Insurance'', ''J1417'', ''J1417'', ''Institutional''),
(''Sentry Insurance'', ''J1417'', ''J1417'', ''Professional''),
(''Sentry Select Insurance Company'', ''C1033'', ''C1033'', ''Institutional''),
(''Sentry Select Insurance Company'', ''C1033'', ''C1033'', ''Professional''),
(''Seoul Medical Group'', ''AMM07'', ''AMM07'', ''Institutional''),
(''Seoul Medical Group'', ''AMM07'', ''AMM07'', ''Professional''),
(''Sequoia Beverage'', ''TKFMC'', ''TKFMC'', ''Professional''),
(''Sequoia Health IPA'', ''AGL01'', ''AGL01'', ''Institutional''),
(''Sequoia Health IPA'', ''AGL01'', ''AGL01'', ''Professional''),
(''Service Lloyds Insurance Co'', ''J1593'', ''J1593'', ''Institutional''),
(''Service Lloyds Insurance Co'', ''J1593'', ''J1593'', ''Professional''),
(''Seton Employee Plan'', ''SHEBP'', ''SHEBP'', ''Institutional''),
(''Seton Employee Plan'', ''SHEBP'', ''SHEBP'', ''Professional''),
(''Seton Health Plan - CHIP'', ''SHPCH'', ''SHPCH'', ''Institutional''),
(''Seton Health Plan - CHIP'', ''SHPCH'', ''SHPCH'', ''Professional''),
(''Seven Corners'', ''25404'', ''25404'', ''Institutional''),
(''Seven Corners'', ''25404'', ''25404'', ''Professional''),
(''SFN Group (Spherion, Technisource, Tatum, The Mergis Group, SourceRight Solutions, & Today''''s Office Professionals) (Bunch CareSolutions)'', ''J1456'', ''J1456'', ''Institutional''),
(''SFN Group (Spherion, Technisource, Tatum, The Mergis Group, SourceRight Solutions, & Today''''s Office Professionals) (Bunch CareSolutions)'', ''J1456'', ''J1456'', ''Professional''),
(''SGIC'', ''11789'', ''11789'', ''Institutional''),
(''SGIC'', ''11789'', ''11789'', ''Professional''),
(''Sharp Community Medical Group'', ''SCMG1'', ''SCMG1'', ''Professional''),
(''Sharp Health Plan'', ''SHP01'', ''SHP01'', ''Institutional''),
(''Sharp Health Plan'', ''SHP01'', ''SHP01'', ''Professional''),
(''Sharp Rees-Stealy Medical Group'', ''SRS83'', ''SRS83'', ''Institutional''),
(''Sharp Rees-Stealy Medical Group'', ''SRS83'', ''SRS83'', ''Professional''),
(''Sharyland Independent School District'', ''41556'', ''41556'', ''Institutional''),
(''Sharyland Independent School District'', ''41556'', ''41556'', ''Professional''),
(''Shasta Administrative Services'', ''75280'', ''75280'', ''Institutional''),
(''Shasta Administrative Services'', ''75280'', ''75280'', ''Professional''),
(''Shaws/StarMarket (Bunch CareSolutions)'', ''J1468'', ''J1468'', ''Institutional''),
(''Shaws/StarMarket (Bunch CareSolutions)'', ''J1468'', ''J1468'', ''Professional''),
(''SIEBA, Ltd.'', ''03699'', ''03699'', ''Institutional''),
(''SIEBA, Ltd.'', ''03699'', ''03699'', ''Professional''),
(''Sierra Health Services'', ''76342'', ''76342'', ''Institutional''),
(''Sierra Health Services'', ''76342'', ''76342'', ''Professional''),
(''Sierra Health Services (Encounters)'', ''76343'', ''76343'', ''Professional''),
(''Sierra Medical Group'', ''30891'', ''30891'', ''Institutional''),
(''Sierra Medical Group'', ''30891'', ''30891'', ''Professional''),
(''Sierra Nevada IPA'', ''MBA01'', ''MBADM'', ''Professional''),
(''Sierra Nevada Memorial'', ''41556'', ''41556'', ''Institutional''),
(''Sierra Nevada Memorial'', ''41556'', ''41556'', ''Professional''),
(''Signal Insurance'', ''J3792'', ''J3792'', ''Institutional''),
(''Signal Insurance'', ''J3792'', ''J3792'', ''Professional''),
(''Signature Advantage'', ''SA001'', ''SA001'', ''Institutional''),
(''Signature Advantage'', ''SA001'', ''SA001'', ''Professional''),
(''Significa Benefits Services'', ''23250'', ''23250'', ''Institutional''),
(''Significa Benefits Services'', ''23250'', ''23250'', ''Professional''),
(''Silberberger Engn'', ''41556'', ''41556'', ''Institutional''),
(''Silberberger Engn'', ''41556'', ''41556'', ''Professional''),
(''Silver Cross Managed Care Org'', ''NASCR'', ''PAPER'', ''Institutional''),
(''Silver Cross Managed Care Org'', ''NASCR'', ''PAPER'', ''Professional''),
(''Silver Summit Healthplan'', ''68069'', ''68069'', ''Institutional''),
(''Silver Summit Healthplan'', ''68069'', ''68069'', ''Professional''),
(''Simply Healthcare'', ''SMPLY'', ''CR423'', ''Professional''),
(''Simply Healthcare'', ''SMPLY'', ''SMPLY'', ''Institutional''),
(''Simply Healthcare'', ''SMPLY'', ''SMPLY'', ''Professional''),
(''SIMPRA Advantage'', ''SIM01'', ''SIM01'', ''Institutional''),
(''SIMPRA Advantage'', ''SIM01'', ''SIM01'', ''Professional''),
(''Sinclair Health Plan'', ''84076'', ''84076'', ''Institutional''),
(''Sinclair Health Plan'', ''84076'', ''84076'', ''Professional''),
(''SISCO (RCM&D Self Insured Services Company, Cost Containment Services)'', ''J1898'', ''J1898'', ''Institutional''),
(''SISCO (RCM&D Self Insured Services Company, Cost Containment Services)'', ''J1898'', ''J1898'', ''Professional''),
(''SKB Corporation'', ''41556'', ''41556'', ''Institutional''),
(''SKB Corporation'', ''41556'', ''41556'', ''Professional''),
(''Smart and Final'', ''J1824'', ''J1824'', ''Institutional''),
(''Smart and Final'', ''J1824'', ''J1824'', ''Professional''),
(''Smith Administrators'', ''02057'', ''02057'', ''Institutional''),
(''Smith Administrators'', ''02057'', ''02057'', ''Professional''),
(''Smoky Mountain Center'', ''13010'', ''13010'', ''Institutional''),
(''Smoky Mountain Center'', ''13010'', ''13010'', ''Professional''),
(''Snap-On Incorporated'', ''J1105'', ''J1105'', ''Institutional''),
(''Snap-On Incorporated'', ''J1105'', ''J1105'', ''Professional''),
(''Solidarity Healthshare'', ''77721'', ''77721'', ''Institutional''),
(''Solidarity Healthshare'', ''77721'', ''77721'', ''Professional''),
(''Solis Health Plan'', ''SOLIS'', ''73581'', ''Institutional''),
(''Solis Health Plan'', ''SOLIS'', ''73581'', ''Professional''),
(''Solvay America Inc'', ''J1106'', ''J1106'', ''Institutional''),
(''Solvay America Inc'', ''J1106'', ''J1106'', ''Professional''),
(''SOMOS - Emblem Health'', ''81336'', ''81336'', ''Institutional''),
(''SOMOS - Emblem Health'', ''81336'', ''81336'', ''Professional''),
(''SOMOS - HealthPlus'', ''81508'', ''81508'', ''Institutional''),
(''SOMOS - HealthPlus'', ''81508'', ''81508'', ''Professional''),
(''Sonic Automotive Inc.'', ''J1381'', ''J1381'', ''Professional''),
(''Sonoma County Primary Care IPA (SCPCI)'', ''SCPCI'', ''SCPCI'', ''Professional''),
(''Sonoma Valley Healthcare District'', ''41556'', ''41556'', ''Institutional''),
(''Sonoma Valley Healthcare District'', ''41556'', ''41556'', ''Professional''),
(''Sonoma Valley Hlth'', ''41556'', ''41556'', ''Institutional''),
(''Sonoma Valley Hlth'', ''41556'', ''41556'', ''Professional''),
(''South Atlantic Medical Group (CA)'', ''SAMG1'', ''SAMG1'', ''Institutional''),
(''South Atlantic Medical Group (CA)'', ''SAMG1'', ''SAMG1'', ''Professional''),
(''South Coast Area Transit (CA)'', ''J1731'', ''J1731'', ''Institutional''),
(''South Coast Area Transit (CA)'', ''J1731'', ''J1731'', ''Professional''),
(''South Country Health Alliance (SCHA)'', ''81600'', ''81600'', ''Institutional''),
(''South Country Health Alliance (SCHA)'', ''81600'', ''81600'', ''Professional''),
(''South Point Hotel & Casino'', ''35227'', ''35227'', ''Professional''),
(''SouthCare/Healthcare Preferred'', ''25147'', ''25147'', ''Institutional''),
(''SouthCare/Healthcare Preferred'', ''25147'', ''25147'', ''Professional''),
(''Southeast Leasing (legal name is Packard Claims Administration, Inc.)'', ''J1865'', ''J1865'', ''Institutional''),
(''Southeast Leasing (legal name is Packard Claims Administration, Inc.)'', ''J1865'', ''J1865'', ''Professional''),
(''Southeast Texas Gov''''t Employees Benefit Pool'', ''TH116'', ''STGEB'', ''Professional''),
(''Southeastern Indiana Health Organization (SIHO)'', ''77153'', ''77153'', ''Institutional''),
(''Southeastern Indiana Health Organization (SIHO)'', ''77153'', ''77153'', ''Professional''),
(''Southern Benefit Services'', ''37318'', ''PAPER'', ''Institutional''),
(''Southern Benefit Services'', ''37318'', ''PAPER'', ''Professional''),
(''Southern CA Children''''s Healthcare Network'', ''ECMSO'', ''ECMSO'', ''Institutional''),
(''Southern CA Children''''s Healthcare Network'', ''ECMSO'', ''ECMSO'', ''Professional''),
(''Southern California Edison'', ''J1817'', ''J1817'', ''Institutional''),
(''Southern California Edison'', ''J1817'', ''J1817'', ''Professional''),
(''Southern California Oncology Associates (SCOA)'', ''SCOA1'', ''SCOA1'', ''Professional''),
(''Southern California Oncology Associates (SCOA) Encounters'', ''SCOAE'', ''SCOAE'', ''Professional''),
(''Southern California Physicians Managed Care'', ''SCP01'', ''SCP01'', ''Professional''),
(''Southern California Risk Management'', ''J1690'', ''J1690'', ''Institutional''),
(''Southern California Risk Management'', ''J1690'', ''J1690'', ''Professional''),
(''Southern Illinois Healthcare Association'', ''SIH99'', ''SIHCA'', ''Professional''),
(''Southern Textile Recycling, Inc. (CA)'', ''J1648'', ''J1648'', ''Institutional''),
(''Southern Textile Recycling, Inc. (CA)'', ''J1648'', ''J1648'', ''Professional''),
(''Southland Advantage Medical Group'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Southland Advantage Medical Group'', ''HSM01'', ''HSM01'', ''Professional''),
(''Southland IPA'', ''SIPA1'', ''SIPA1'', ''Institutional''),
(''Southland IPA'', ''SIPA1'', ''SIPA1'', ''Professional''),
(''Southland San Gabriel Valley Medical Group'', ''HSM01'', ''HSM01'', ''Institutional''),
(''Southland San Gabriel Valley Medical Group'', ''HSM01'', ''HSM01'', ''Professional''),
(''Southwest Airlines (SWA)'', ''J1233'', ''J1233'', ''Institutional''),
(''Southwest Airlines (SWA)'', ''J1233'', ''J1233'', ''Professional''),
(''Southwest Gas Corporation'', ''41556'', ''41556'', ''Institutional''),
(''Southwest Gas Corporation'', ''41556'', ''41556'', ''Professional''),
(''Southwest Oregon IPA (Doctors of the Oregon Coast South)'', ''DOCSO'', ''DOCSO'', ''Professional''),
(''Southwest Service Administrators, Inc.'', ''CX100'', ''CX100'', ''Institutional''),
(''Southwest Service Administrators, Inc.'', ''CX100'', ''CX100'', ''Professional''),
(''Southwest Service Life'', ''37266'', ''37266'', ''Institutional''),
(''Southwest Service Life'', ''37266'', ''37266'', ''Professional''),
(''SP Net'', ''SPNET'', ''WCPAP'', ''Institutional''),
(''SP Net'', ''SPNET'', ''WCPAP'', ''Professional''),
(''Special Funds'', ''J2003'', ''J2003'', ''Institutional''),
(''Special Funds'', ''J2003'', ''J2003'', ''Professional''),
(''Specialty Coffee'', ''41556'', ''41556'', ''Institutional''),
(''Specialty Coffee'', ''41556'', ''41556'', ''Professional''),
(''Specialty Risk Services'', ''SRS01'', ''WCPAP'', ''Institutional''),
(''Specialty Risk Services'', ''SRS01'', ''WCPAP'', ''Professional''),
(''Spectera/United Healthcare Vision'', ''00773'', ''00773'', ''Institutional''),
(''Spectera/United Healthcare Vision'', ''00773'', ''00773'', ''Professional''),
(''Spencer Stuart (ARM, LTD)'', ''38416'', ''38416'', ''Institutional''),
(''Spencer Stuart (ARM, LTD)'', ''38416'', ''38416'', ''Professional''),
(''Spina Bifida - VA HAC'', ''84146'', ''84146'', ''Institutional''),
(''Spina Bifida - VA HAC'', ''84146'', ''84146'', ''Professional''),
(''SPNet - Integra Group'', ''J4041'', ''J4041'', ''Institutional''),
(''SPNet - Integra Group'', ''J4041'', ''J4041'', ''Professional''),
(''Spooner''''s Woodworks'', ''41556'', ''41556'', ''Institutional''),
(''Spooner''''s Woodworks'', ''41556'', ''41556'', ''Professional''),
(''Springfield Insurance Co.'', ''J1922'', ''J1922'', ''Institutional''),
(''Springfield Insurance Co.'', ''J1922'', ''J1922'', ''Professional''),
(''Sprouts Farmers Market, Inc.'', ''J1850'', ''J1850'', ''Institutional''),
(''Sprouts Farmers Market, Inc.'', ''J1850'', ''J1850'', ''Professional''),
(''St Paul Insurance'', ''J1926'', ''J1926'', ''Professional''),
(''St. Barnabas System Health Plan'', ''22099'', ''22099'', ''Institutional''),
(''St. Barnabas System Health Plan'', ''22099'', ''22099'', ''Professional''),
(''St. Francis Health Network'', ''35199'', ''35199'', ''Institutional''),
(''St. Francis Health Network'', ''35199'', ''35199'', ''Professional''),
(''St. Johns Health Clinic'', ''SJHC1'', ''SJHC1'', ''Institutional''),
(''St. Johns Health Clinic'', ''SJHC1'', ''SJHC1'', ''Professional''),
(''St. Joseph Health Foundation of Northern California'', ''68033'', ''68033'', ''Professional''),
(''St. Joseph Heritage Healthcare'', ''STJOE'', ''STJOE'', ''Institutional''),
(''St. Joseph Heritage Healthcare'', ''STJOE'', ''STJOE'', ''Professional''),
(''St. Jude (St. Joseph Heritage Healthcare)'', ''STJOE'', ''STJOE'', ''Institutional''),
(''St. Jude (St. Joseph Heritage Healthcare)'', ''STJOE'', ''STJOE'', ''Professional''),
(''St. Mary''''s Health Plans'', ''88029'', ''88029'', ''Institutional''),
(''St. Mary''''s Health Plans'', ''88029'', ''88029'', ''Professional''),
(''St. Mary''''s IPA'', ''CAPMN'', ''CAPMN'', ''Professional''),
(''St. Mary''''s IPA'', ''SMIPA'', ''SMIPA'', ''Professional''),
(''St. Peter Medical Group'', ''HSM01'', ''HSM01'', ''Institutional''),
(''St. Peter Medical Group'', ''HSM01'', ''HSM01'', ''Professional''),
(''St. Rose Hospital'', ''41556'', ''41556'', ''Institutional''),
(''St. Rose Hospital'', ''41556'', ''41556'', ''Professional''),
(''St. Therese Physician Association'', ''37116'', ''37116'', ''Institutional''),
(''St. Therese Physician Association'', ''37116'', ''37116'', ''Professional''),
(''St. Thomas Medical Network (Gulfquest)'', ''STM01'', ''STM01'', ''Professional''),
(''St. Vincent Catholic Medical Centers'', ''13407'', ''13407'', ''Institutional''),
(''St. Vincent Catholic Medical Centers'', ''13407'', ''13407'', ''Professional''),
(''St. Vincent IPA'', ''PDT01'', ''PDT01'', ''Institutional''),
(''St. Vincent IPA'', ''PDT01'', ''PDT01'', ''Professional''),
(''Staff Benefits Management & Admin (SBMA)'', ''SBMCO'', ''SBMCO'', ''Institutional''),
(''Staff Benefits Management & Admin (SBMA)'', ''SBMCO'', ''SBMCO'', ''Professional''),
(''Standard Forwarding (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Standard Forwarding (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Standard Fruit & Veg'', ''41556'', ''41556'', ''Institutional''),
(''Standard Fruit & Veg'', ''41556'', ''41556'', ''Professional''),
(''Standard Life and Accident Insurance Company'', ''73099'', ''73099'', ''Institutional''),
(''Standard Life and Accident Insurance Company'', ''73099'', ''73099'', ''Professional''),
(''Stanley Steemer International Inc'', ''J1939'', ''J1939'', ''Institutional''),
(''Stanley Steemer International Inc'', ''J1939'', ''J1939'', ''Professional''),
(''Stanley Works, Inc.'', ''J1385'', ''J1385'', ''Professional''),
(''Stant Corporation'', ''J1107'', ''J1107'', ''Institutional''),
(''Stant Corporation'', ''J1107'', ''J1107'', ''Professional''),
(''Starmark - Trustmark Small Business Benefits'', ''61425'', ''61425'', ''Institutional''),
(''Starmark - Trustmark Small Business Benefits'', ''61425'', ''61425'', ''Professional''),
(''State Auto Mutual Insurance Company'', ''J1966'', ''J1966'', ''Institutional''),
(''State Auto Mutual Insurance Company'', ''J1966'', ''J1966'', ''Professional''),
(''State Compensation Insurance Fund (SCIF)'', ''35076'', ''35076'', ''Institutional''),
(''State Compensation Insurance Fund (SCIF)'', ''35076'', ''35076'', ''Professional''),
(''State Farm'', ''J1548'', ''PAPER'', ''Institutional''),
(''State Farm'', ''J1548'', ''PAPER'', ''Professional''),
(''State Farm (Casualty & Property Claims)'', ''31059'', ''31059'', ''Institutional''),
(''State Farm (Casualty & Property Claims)'', ''31059'', ''31059'', ''Professional''),
(''State Farm Insurance Companies'', ''31053'', ''31053'', ''Institutional''),
(''State Farm Insurance Companies'', ''31053'', ''31053'', ''Professional''),
(''State Fund Mutual (SFM) Insurance Co.'', ''J1553'', ''J1553'', ''Institutional''),
(''State Fund Mutual (SFM) Insurance Co.'', ''J1553'', ''J1553'', ''Professional''),
(''State of Idaho Women''''s Health Check'', ''IDWH1'', ''IDWH1'', ''Institutional''),
(''State of Idaho Women''''s Health Check'', ''IDWH1'', ''IDWH1'', ''Professional''),
(''State of Idaho Women''''s Health Check - Firstsource'', ''12113'', ''12113'', ''Institutional''),
(''State of Idaho Women''''s Health Check - Firstsource'', ''12113'', ''12113'', ''Professional''),
(''State of Minnesota - DOER'', ''J1555'', ''J1555'', ''Institutional''),
(''State of Minnesota - DOER'', ''J1555'', ''J1555'', ''Professional''),
(''State of North Carolina'', ''J1659'', ''J1659'', ''Institutional''),
(''State of North Carolina'', ''J1659'', ''J1659'', ''Professional''),
(''State Office of Risk Management'', ''J1418'', ''J1418'', ''Institutional''),
(''State Office of Risk Management'', ''J1418'', ''J1418'', ''Professional''),
(''Statewide Insurance Fund'', ''J3937'', ''J3937'', ''Institutional''),
(''Statewide Insurance Fund'', ''J3937'', ''J3937'', ''Professional''),
(''Staywell Health Plan'', ''14163'', ''14163'', ''Institutional''),
(''Staywell Health Plan'', ''14163'', ''14163'', ''Professional''),
(''Staywell of Florida & Georgia (EPSDT)'', ''141FG'', ''141FG'', ''Institutional''),
(''Staywell of Florida & Georgia (EPSDT)'', ''141FG'', ''141FG'', ''Professional''),
(''Staywell of Kentucky (EPSDT)'', ''141KY'', ''141KY'', ''Institutional''),
(''Staywell of Kentucky (EPSDT)'', ''141KY'', ''141KY'', ''Professional''),
(''SteadPoint Group / Benchmark Insurance Company - CORVEL'', ''J3992'', ''J3992'', ''Institutional''),
(''SteadPoint Group / Benchmark Insurance Company - CORVEL'', ''J3992'', ''J3992'', ''Professional''),
(''Sterling Life Insurance Company'', ''13193'', ''13193'', ''Institutional''),
(''Sterling Life Insurance Company'', ''13193'', ''13193'', ''Professional''),
(''Steward Health Choice Arizona'', ''62179'', ''62179'', ''Institutional''),
(''Steward Health Choice Arizona'', ''62179'', ''62179'', ''Professional''),
(''Steward Health Choice Generations  - Medicare'', ''62180'', ''62180'', ''Institutional''),
(''Steward Health Choice Generations  - Medicare'', ''62180'', ''62180'', ''Professional''),
(''Steward Health Choice Generations Utah'', ''13054'', ''13054'', ''Institutional''),
(''Steward Health Choice Generations Utah'', ''13054'', ''13054'', ''Professional''),
(''Steward Health Choice Insurance Co.'', ''46221'', ''46221'', ''Institutional''),
(''Steward Health Choice Insurance Co.'', ''46221'', ''46221'', ''Professional''),
(''Steward Health Choice Integrated Care'', ''22100'', ''22100'', ''Institutional''),
(''Steward Health Choice Integrated Care'', ''22100'', ''22100'', ''Professional''),
(''Steward Health Choice Utah - Medicaid'', ''45399'', ''45399'', ''Institutional''),
(''Steward Health Choice Utah - Medicaid'', ''45399'', ''45399'', ''Professional''),
(''Stimson Lumber Company - MT, OR, WA'', ''41556'', ''41556'', ''Institutional''),
(''Stimson Lumber Company - MT, OR, WA'', ''41556'', ''41556'', ''Professional''),
(''Stones River IPA - Amerivantage'', ''57492'', ''57492'', ''Professional''),
(''Stones River Regional IPA - BHFG'', ''15754'', ''15754'', ''Professional''),
(''Stones River Regional IPA - Windsor'', ''15752'', ''15752'', ''Professional''),
(''Stones River Regional IPA/BCBST'', ''15750'', ''15750'', ''Professional''),
(''Stonington C. Club'', ''41556'', ''41556'', ''Institutional''),
(''Stonington C. Club'', ''41556'', ''41556'', ''Professional''),
(''Stork Club Fertility, Inc.'', ''STORK'', ''STORK'', ''Professional''),
(''SummaCare Health Plans'', ''95202'', ''95202'', ''Institutional''),
(''SummaCare Health Plans'', ''95202'', ''95202'', ''Professional''),
(''Summit Administration Services, Inc'', ''86083'', ''86083'', ''Institutional''),
(''Summit Administration Services, Inc'', ''86083'', ''86083'', ''Professional''),
(''Summit America Insurance Services, Inc.'', ''37301'', ''37301'', ''Institutional''),
(''Summit America Insurance Services, Inc.'', ''37301'', ''37301'', ''Professional''),
(''Summit Community Care'', ''PASSE'', ''PASSE'', ''Institutional''),
(''Summit Community Care'', ''PASSE'', ''PASSE'', ''Professional''),
(''Summit Health Ltd'', ''J1108'', ''J1108'', ''Institutional''),
(''Summit Health Ltd'', ''J1108'', ''J1108'', ''Professional''),
(''Summit Holdings'', ''J1437'', ''J1437'', ''Institutional''),
(''Summit Holdings'', ''J1437'', ''J1437'', ''Professional''),
(''Sun Mar Healthcare'', ''J1610'', ''J1610'', ''Institutional''),
(''Sun Mar Healthcare'', ''J1610'', ''J1610'', ''Professional''),
(''Sunamerica Life Insurance Company'', ''90956'', ''90956'', ''Institutional''),
(''Sunamerica Life Insurance Company'', ''90956'', ''90956'', ''Professional''),
(''Sunflower State Health - Kansas'', ''68069'', ''68069'', ''Institutional''),
(''Sunflower State Health - Kansas'', ''68069'', ''68069'', ''Professional''),
(''Sunrise Country Club'', ''41556'', ''41556'', ''Institutional''),
(''Sunrise Country Club'', ''41556'', ''41556'', ''Professional''),
(''Sunrise Health Plan of Illinois'', ''SIL01'', ''SIL01'', ''Institutional''),
(''Sunrise Health Plan of Illinois'', ''SIL01'', ''SIL01'', ''Professional''),
(''Sunrise Health Plan of New York'', ''SNY01'', ''SNY01'', ''Institutional''),
(''Sunrise Health Plan of New York'', ''SNY01'', ''SNY01'', ''Professional''),
(''Sunrise Health Plan of Pennsylvania'', ''SPA01'', ''SPA01'', ''Institutional''),
(''Sunrise Health Plan of Pennsylvania'', ''SPA01'', ''SPA01'', ''Professional''),
(''Sunrise Health Plan of Virginia'', ''SVA01'', ''SVA01'', ''Institutional''),
(''Sunrise Health Plan of Virginia'', ''SVA01'', ''SVA01'', ''Professional''),
(''Sunshine State Health Plan - Florida'', ''68069'', ''68069'', ''Institutional''),
(''Sunshine State Health Plan - Florida'', ''68069'', ''68069'', ''Professional''),
(''SUNZ Insurance Company'', ''J1584'', ''J1584'', ''Institutional''),
(''SUNZ Insurance Company'', ''J1584'', ''J1584'', ''Professional''),
(''superior'', ''23071'', ''23071'', ''Institutional''),
(''superior'', ''23071'', ''23071'', ''Professional''),
(''Superior Access Ins Services'', ''41556'', ''41556'', ''Institutional''),
(''Superior Access Ins Services'', ''41556'', ''41556'', ''Professional''),
(''Superior Choice Medical Group'', ''SCPR1'', ''SCPR1'', ''Institutional''),
(''Superior Choice Medical Group'', ''SCPR1'', ''SCPR1'', ''Professional''),
(''Superior Health Plan'', ''68069'', ''68069'', ''Institutional''),
(''Superior Health Plan'', ''68069'', ''68069'', ''Professional''),
(''Superior Health Plan - STAR Programs'', ''68069'', ''68069'', ''Institutional''),
(''Superior Health Plan - STAR Programs'', ''68069'', ''68069'', ''Professional''),
(''Superior Health Plan - STAR Programs Behavioral'', ''68068'', ''68068'', ''Institutional''),
(''Superior Health Plan - STAR Programs Behavioral'', ''68068'', ''68068'', ''Professional''),
(''Superior Health Plan - Texas'', ''68069'', ''68069'', ''Institutional''),
(''Superior Health Plan - Texas'', ''68069'', ''68069'', ''Professional''),
(''Superior Health Plan CHIPS EPO'', ''68069'', ''68069'', ''Institutional''),
(''Superior Health Plan CHIPS EPO'', ''68069'', ''68069'', ''Professional''),
(''Superior Industries International, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Superior Industries International, Inc.'', ''41556'', ''41556'', ''Professional''),
(''Superior Insurance Services'', ''97802'', ''97802'', ''Institutional''),
(''Superior Insurance Services'', ''97802'', ''97802'', ''Professional''),
(''Superior Ready Mix'', ''41556'', ''41556'', ''Institutional''),
(''Superior Ready Mix'', ''41556'', ''41556'', ''Professional''),
(''Superior Vision Services'', ''13305'', ''13305'', ''Professional''),
(''Supreme Court of California'', ''J1804'', ''J1804'', ''Institutional''),
(''Supreme Court of California'', ''J1804'', ''J1804'', ''Professional''),
(''Sussex Insurance Company (formerly Companion Property & Casualty Insurance)'', ''J1829'', ''J1829'', ''Institutional''),
(''Sussex Insurance Company (formerly Companion Property & Casualty Insurance)'', ''J1829'', ''J1829'', ''Professional''),
(''Sutter Connect - Mills Peninsula Health Services (SPS - Sutter)'', ''SC050'', ''SC050'', ''Professional''),
(''Sutter Connect - Mills Peninsula Medical Group (SPS - Sutter)'', ''SC050'', ''SC050'', ''Professional''),
(''Sutter Connect - Palo Alto Medical Foundation'', ''SC050'', ''SC050'', ''Professional''),
(''Sutter Connect - Sutter Independent Physicians, Sutter Medical Group, Sutter West Medical Group (SIP/SMF/SWMG)'', ''SC004'', ''SC004'', ''Professional''),
(''Sutter Connect - Sutter Medical Group of the Redwoods, Santa Rosa Network (SMGR/SRN)'', ''SC008'', ''SC008'', ''Professional''),
(''Sutter Health'', ''J1512'', ''J1512'', ''Institutional''),
(''Sutter Health'', ''J1512'', ''J1512'', ''Professional''),
(''Swedish Covenant Hospital'', ''36411'', ''36411'', ''Institutional''),
(''Swedish Covenant Hospital'', ''36411'', ''36411'', ''Professional''),
(''Swift Transportation'', ''J1109'', ''J1109'', ''Institutional''),
(''Swift Transportation'', ''J1109'', ''J1109'', ''Professional''),
(''Synermed'', ''SYMED'', ''SYMED'', ''Professional''),
(''Syngenta Corporation'', ''J1972'', ''J1972'', ''Institutional''),
(''Syngenta Corporation'', ''J1972'', ''J1972'', ''Professional''),
(''T.H.E. Insurance'', ''J1791'', ''J1791'', ''Institutional''),
(''T.H.E. Insurance'', ''J1791'', ''J1791'', ''Professional''),
(''Tall Tree Administrators'', ''88067'', ''88067'', ''Institutional''),
(''Tall Tree Administrators'', ''88067'', ''88067'', ''Professional''),
(''Tan Medical Group'', ''41556'', ''41556'', ''Institutional''),
(''Tan Medical Group'', ''41556'', ''41556'', ''Professional''),
(''TASEBA'', ''TKFMC'', ''TKFMC'', ''Professional''),
(''Taylor Benefits'', ''TAYLR'', ''TAYLR'', ''Professional''),
(''TBG Administrative Services'', ''39157'', ''39157'', ''Institutional''),
(''TBG Administrative Services'', ''39157'', ''39157'', ''Professional''),
(''TCC (Pre-Med Defender)'', ''TCC13'', ''TCC13'', ''Institutional''),
(''TCC (Pre-Med Defender)'', ''TCC13'', ''TCC13'', ''Professional''),
(''TCC (Self Funded)'', ''TCC93'', ''TCC93'', ''Institutional''),
(''TCC (Self Funded)'', ''TCC93'', ''TCC93'', ''Professional''),
(''TD Tile'', ''41556'', ''41556'', ''Institutional''),
(''TD Tile'', ''41556'', ''41556'', ''Professional''),
(''Teachers Health Trust'', ''88019'', ''88019'', ''Professional''),
(''Team Choice - Alpha Care Gold'', ''ADSL1'', ''ADSL1'', ''Institutional''),
(''Team Choice - Alpha Care Gold'', ''ADSL1'', ''ADSL1'', ''Professional''),
(''Team Choice - Gold'', ''75139'', ''75139'', ''Institutional''),
(''Team Choice - Gold'', ''75139'', ''75139'', ''Professional''),
(''Team Choice PNS'', ''75133'', ''75133'', ''Institutional''),
(''Team Choice PNS'', ''75133'', ''75133'', ''Professional''),
(''Team Choice UMC'', ''75134'', ''75134'', ''Institutional''),
(''Team Choice UMC'', ''75134'', ''75134'', ''Professional''),
(''Teamcare'', ''36215'', ''36215'', ''Institutional''),
(''Teamcare'', ''36215'', ''36215'', ''Professional''),
(''Teamsters (UT, ID, MT) Group Benefit Admin'', ''TGBA1'', ''PAPER'', ''Institutional''),
(''Teamsters (UT, ID, MT) Group Benefit Admin'', ''TGBA1'', ''PAPER'', ''Professional''),
(''Teamsters Benefit Trust'', ''TBT01'', ''PAPER'', ''Institutional''),
(''Teamsters Benefit Trust'', ''TBT01'', ''PAPER'', ''Professional''),
(''Teamsters Local 688 Insurance & Welfare Admin Office - Missouri'', ''43619'', ''43619'', ''Institutional''),
(''Teamsters Local 688 Insurance & Welfare Admin Office - Missouri'', ''43619'', ''43619'', ''Professional''),
(''Technology Insurance Co'', ''J1855'', ''J1855'', ''Institutional''),
(''Technology Insurance Co'', ''J1855'', ''J1855'', ''Professional''),
(''Tethys Health Ventures'', ''20212'', ''20212'', ''Institutional''),
(''Tethys Health Ventures'', ''20212'', ''20212'', ''Professional''),
(''Texan Plus (Kelsey-Sebold)'', ''14163'', ''14163'', ''Institutional''),
(''Texan Plus (Kelsey-Sebold)'', ''14163'', ''14163'', ''Professional''),
(''TexanPlus (Houston)'', ''14163'', ''14163'', ''Institutional''),
(''TexanPlus (Houston)'', ''14163'', ''14163'', ''Professional''),
(''Texas A&M'', ''A0235'', ''A0235'', ''Institutional''),
(''Texas A&M'', ''A0235'', ''A0235'', ''Professional''),
(''Texas Association of School Boards'', ''A0234'', ''A0234'', ''Institutional''),
(''Texas Association of School Boards'', ''A0234'', ''A0234'', ''Professional''),
(''Texas Association of School Boards'', ''WR902'', ''TTASB'', ''Professional''),
(''Texas Builders Insurance Co'', ''J1581'', ''J1581'', ''Institutional''),
(''Texas Builders Insurance Co'', ''J1581'', ''J1581'', ''Professional''),
(''Texas Children''''s Health Plan CHIP'', ''76048'', ''76048'', ''Institutional''),
(''Texas Children''''s Health Plan CHIP'', ''76048'', ''76048'', ''Professional''),
(''Texas Childrens Health Plan Medicaid/STAR'', ''75228'', ''75228'', ''Institutional''),
(''Texas Childrens Health Plan Medicaid/STAR'', ''75228'', ''75228'', ''Professional''),
(''Texas Christus'', ''45210'', ''45210'', ''Institutional''),
(''Texas Christus'', ''45210'', ''45210'', ''Professional''),
(''Texas First Health Plans - Tarrant County'', ''14163'', ''14163'', ''Institutional''),
(''Texas First Health Plans - Tarrant County'', ''14163'', ''14163'', ''Professional''),
(''Texas Health Aetna'', ''88221'', ''88221'', ''Institutional''),
(''Texas Health Aetna'', ''88221'', ''88221'', ''Professional''),
(''Texas HealthSpring'', ''33104'', ''33104'', ''Institutional''),
(''Texas HealthSpring'', ''33104'', ''33104'', ''Professional''),
(''Texas Independence Health Plan'', ''31403'', ''31403'', ''Institutional''),
(''Texas Independence Health Plan'', ''31403'', ''31403'', ''Professional''),
(''Texas Municipal League Group'', ''39026'', ''39026'', ''Institutional''),
(''Texas Municipal League Group'', ''39026'', ''39026'', ''Professional''),
(''Texas Mutual Insurance'', ''22945'', ''22945'', ''Institutional''),
(''Texas Mutual Insurance'', ''22945'', ''22945'', ''Professional''),
(''Texas Mutual League (TML-IRP) - Intergovernmental Risk Pool'', ''A0245'', ''A0245'', ''Institutional''),
(''Texas Mutual League (TML-IRP) - Intergovernmental Risk Pool'', ''A0245'', ''A0245'', ''Professional''),
(''Texas Political Subdivisions JSIF'', ''J1921'', ''J1921'', ''Institutional''),
(''Texas Political Subdivisions JSIF'', ''J1921'', ''J1921'', ''Professional''),
(''Texas Premier Plan'', ''TH089'', ''TH089'', ''Professional''),
(''Texas Roadhouse, Inc.'', ''J1676'', ''J1676'', ''Institutional''),
(''Texas Roadhouse, Inc.'', ''J1676'', ''J1676'', ''Professional''),
(''Texas Small Business Pool'', ''J1110'', ''J1110'', ''Institutional''),
(''Texas Small Business Pool'', ''J1110'', ''J1110'', ''Professional''),
(''Texas University Plan - UPG Commercial'', ''UPGUT'', ''UPGUT'', ''Professional''),
(''The Alliance'', ''88461'', ''88461'', ''Institutional''),
(''The Alliance'', ''88461'', ''88461'', ''Professional''),
(''The Atlas Group of Companies'', ''C1075'', ''C1075'', ''Institutional''),
(''The Atlas Group of Companies'', ''C1075'', ''C1075'', ''Professional''),
(''The Auto Club Group'', ''11983'', ''11983'', ''Institutional''),
(''The Auto Club Group'', ''11983'', ''11983'', ''Professional''),
(''The Care Network/The Savannah Business Group'', ''68423'', ''68423'', ''Institutional''),
(''The Care Network/The Savannah Business Group'', ''68423'', ''68423'', ''Professional''),
(''The CHP Group'', ''CHP01'', ''CHP01'', ''Professional''),
(''The City of Odessa'', ''75600'', ''75600'', ''Institutional''),
(''The City of Odessa'', ''75600'', ''75600'', ''Professional''),
(''The Empire Plan'', ''87726'', ''87726'', ''Professional''),
(''The Fringe Benefit Group Inc (Previously Employer Plan Services, Inc. - Austin)'', ''45289'', ''45289'', ''Institutional''),
(''The Fringe Benefit Group Inc (Previously Employer Plan Services, Inc. - Austin)'', ''45289'', ''45289'', ''Professional''),
(''The Fringe Benefit Group Inc (Previously Employer Plan Services, Inc. EPSI - Houston)'', ''74212'', ''74212'', ''Institutional''),
(''The Fringe Benefit Group Inc (Previously Employer Plan Services, Inc. EPSI - Houston)'', ''74212'', ''74212'', ''Professional''),
(''The Gap, Inc.'', ''J1671'', ''J1671'', ''Institutional''),
(''The Gap, Inc.'', ''J1671'', ''J1671'', ''Professional''),
(''The General Insurance'', ''C1050'', ''C1050'', ''Institutional''),
(''The General Insurance'', ''C1050'', ''C1050'', ''Professional''),
(''The Hartford'', ''J1422'', ''J1422'', ''Institutional''),
(''The Hartford'', ''J1422'', ''J1422'', ''Professional''),
(''The Health Exchange (Cerner Corp)'', ''20356'', ''20356'', ''Institutional''),
(''The Health Exchange (Cerner Corp)'', ''20356'', ''20356'', ''Professional''),
(''The Health Plan'', ''34150'', ''34150'', ''Institutional''),
(''The Health Plan'', ''34150'', ''34150'', ''Professional''),
(''The Health Plan of the Upper Ohio Valley'', ''34150'', ''34150'', ''Institutional''),
(''The Health Plan of the Upper Ohio Valley'', ''34150'', ''34150'', ''Professional''),
(''The Health Plan of Western Illinois (HOWI)'', ''29018'', ''29018'', ''Institutional''),
(''The Health Plan of Western Illinois (HOWI)'', ''29018'', ''29018'', ''Professional''),
(''The Healthcare Group'', ''35206'', ''35206'', ''Institutional''),
(''The Healthcare Group'', ''35206'', ''35206'', ''Professional''),
(''The Integrity Benefit Group'', ''58200'', ''58200'', ''Institutional''),
(''The Integrity Benefit Group'', ''58200'', ''58200'', ''Professional''),
(''The Jones Financial Companies, LLP'', ''J1846'', ''J1846'', ''Institutional''),
(''The Jones Financial Companies, LLP'', ''J1846'', ''J1846'', ''Professional''),
(''The Loomis Co - TPA Wyomissing, PA (IHS Gateway PA)'', ''23223'', ''23223'', ''Institutional''),
(''The Loomis Co - TPA Wyomissing, PA (IHS Gateway PA)'', ''23223'', ''23223'', ''Professional''),
(''The Main Street America Group / Austin Mutual'', ''J1834'', ''J1834'', ''Institutional''),
(''The Main Street America Group / Austin Mutual'', ''J1834'', ''J1834'', ''Professional''),
(''The Main Street America Group / Grain Dealers Mutual'', ''J1835'', ''J1835'', ''Institutional''),
(''The Main Street America Group / Grain Dealers Mutual'', ''J1835'', ''J1835'', ''Professional''),
(''The Main Street America Group / Great Lakes Casualty'', ''J1836'', ''J1836'', ''Institutional''),
(''The Main Street America Group / Great Lakes Casualty'', ''J1836'', ''J1836'', ''Professional''),
(''The Main Street America Group / Main Street America Assurance'', ''J1837'', ''J1837'', ''Institutional''),
(''The Main Street America Group / Main Street America Assurance'', ''J1837'', ''J1837'', ''Professional''),
(''The Main Street America Group / MSA Insurance Protection'', ''J1838'', ''J1838'', ''Institutional''),
(''The Main Street America Group / MSA Insurance Protection'', ''J1838'', ''J1838'', ''Professional''),
(''The Main Street America Group / MSAIC Surplus/Non-Admitted'', ''J1839'', ''J1839'', ''Institutional''),
(''The Main Street America Group / MSAIC Surplus/Non-Admitted'', ''J1839'', ''J1839'', ''Professional''),
(''The Main Street America Group / NGM'', ''J1840'', ''J1840'', ''Institutional''),
(''The Main Street America Group / NGM'', ''J1840'', ''J1840'', ''Professional''),
(''The Main Street America Group / Old Dominion Insurance Company'', ''J1841'', ''J1841'', ''Institutional''),
(''The Main Street America Group / Old Dominion Insurance Company'', ''J1841'', ''J1841'', ''Professional''),
(''The Main Street America Group / Spring Valley Mutual'', ''J1842'', ''J1842'', ''Institutional''),
(''The Main Street America Group / Spring Valley Mutual'', ''J1842'', ''J1842'', ''Professional''),
(''The Mega Life OKC'', ''59227'', ''59227'', ''Institutional''),
(''The Mega Life OKC'', ''59227'', ''59227'', ''Professional''),
(''The Men''''s Wearhouse, Inc'', ''J1615'', ''J1615'', ''Institutional''),
(''The Men''''s Wearhouse, Inc'', ''J1615'', ''J1615'', ''Professional''),
(''The Mentor Network (Bunch CareSolutions)'', ''J1963'', ''J1963'', ''Institutional''),
(''The Mentor Network (Bunch CareSolutions)'', ''J1963'', ''J1963'', ''Professional''),
(''The Oaks PACE'', ''57034'', ''57034'', ''Institutional''),
(''The Oaks PACE'', ''57034'', ''57034'', ''Professional''),
(''The Perfect Health Insurance Company'', ''13522'', ''13522'', ''Institutional''),
(''The Perfect Health Insurance Company'', ''13522'', ''13522'', ''Professional''),
(''The Preferred Healthcare System (PPO)'', ''04320'', ''04320'', ''Institutional''),
(''The Preferred Healthcare System (PPO)'', ''04320'', ''04320'', ''Professional''),
(''The Salvation Army (Bunch CareSolutions)'', ''J1472'', ''J1472'', ''Institutional''),
(''The Salvation Army (Bunch CareSolutions)'', ''J1472'', ''J1472'', ''Professional''),
(''The Scotts Company'', ''J1111'', ''J1111'', ''Institutional''),
(''The Scotts Company'', ''J1111'', ''J1111'', ''Professional''),
(''The TPA (Benesight)'', ''87265'', ''87265'', ''Professional''),
(''The Wellness Plan'', ''38200'', ''38200'', ''Institutional''),
(''The Wellness Plan'', ''38200'', ''38200'', ''Professional''),
(''The Zenith'', ''13269'', ''13269'', ''Institutional''),
(''The Zenith'', ''13269'', ''13269'', ''Professional''),
(''Theraphysics'', ''THERA'', ''THERA'', ''Professional''),
(''Theraphysics (Colorado ONLY)'', ''COTHE'', ''COTHE'', ''Professional''),
(''Therapy Direct Network'', ''J1831'', ''J1831'', ''Institutional''),
(''Therapy Direct Network'', ''J1831'', ''J1831'', ''Professional''),
(''Therapy Network of Puerto Rico'', ''TNPR1'', ''TNPR1'', ''Institutional''),
(''Therapy Network of Puerto Rico'', ''TNPR1'', ''TNPR1'', ''Professional''),
(''Thomas Staffing Services, Inc/Venturi Staffing'', ''41556'', ''41556'', ''Institutional''),
(''Thomas Staffing Services, Inc/Venturi Staffing'', ''41556'', ''41556'', ''Professional''),
(''Thrivent Financial Aid Association for Lutheran Medicare'', ''30167'', ''30167'', ''Institutional''),
(''Thrivent Financial Aid Association for Lutheran Medicare'', ''30167'', ''30167'', ''Professional''),
(''Thrivent Financial Lutheran Brotherhood Medicare'', ''30166'', ''30166'', ''Institutional''),
(''Thrivent Financial Lutheran Brotherhood Medicare'', ''30166'', ''30166'', ''Professional''),
(''Tidewater Marine Western'', ''J1392'', ''J1392'', ''Institutional''),
(''Tidewater Marine Western'', ''J1392'', ''J1392'', ''Professional''),
(''TLC Advantage of Sioux Falls'', ''TLC01'', ''TLC01'', ''Institutional''),
(''TLC Advantage of Sioux Falls'', ''TLC01'', ''TLC01'', ''Professional''),
(''TLC Benefit Solutions'', ''TLC79'', ''TLC79'', ''Institutional''),
(''TLC Benefit Solutions'', ''TLC79'', ''TLC79'', ''Professional''),
(''TML Intergovernmental Employee Benefit Pool'', ''39026'', ''39026'', ''Institutional''),
(''TML Intergovernmental Employee Benefit Pool'', ''39026'', ''39026'', ''Professional''),
(''Today''''s Options (American Progressive and Pyramid Life)'', ''14163'', ''14163'', ''Institutional''),
(''Today''''s Options (American Progressive and Pyramid Life)'', ''14163'', ''14163'', ''Professional''),
(''Together with Children''''s Community Health Plan'', ''251CC'', ''251CC'', ''Institutional''),
(''Together with Children''''s Community Health Plan'', ''251CC'', ''251CC'', ''Professional''),
(''TOPA Insurance Company'', ''J1537'', ''J1537'', ''Institutional''),
(''TOPA Insurance Company'', ''J1537'', ''J1537'', ''Professional''),
(''Topanga Roscoe Corp.'', ''41556'', ''41556'', ''Institutional''),
(''Topanga Roscoe Corp.'', ''41556'', ''41556'', ''Professional''),
(''Torrance Hospital IPA'', ''TMIPA'', ''TMIPA'', ''Professional''),
(''Torrance Memorial IPA'', ''THIPA'', ''THIPA'', ''Professional''),
(''Torrance Memorial Medical Center'', ''TMMC1'', ''TMMC1'', ''Institutional''),
(''Torrance Memorial Medical Center'', ''TMMC1'', ''TMMC1'', ''Professional''),
(''Total Care'', ''TCARE'', ''TCARE'', ''Institutional''),
(''Total Care'', ''TCARE'', ''TCARE'', ''Professional''),
(''Total Health Care Michigan'', ''38201'', ''38201'', ''Institutional''),
(''Total Health Care Michigan'', ''38201'', ''38201'', ''Professional''),
(''Total Health Choice Florida'', ''38202'', ''38202'', ''Institutional''),
(''Total Health Choice Florida'', ''38202'', ''38202'', ''Professional''),
(''Total Petroleum, Inc.'', ''J1112'', ''J1112'', ''Institutional''),
(''Total Petroleum, Inc.'', ''J1112'', ''J1112'', ''Professional''),
(''Total Plan Concepts'', ''80900'', ''80900'', ''Institutional''),
(''Total Plan Concepts'', ''80900'', ''80900'', ''Professional''),
(''Total Plan Service'', ''41202'', ''41202'', ''Institutional''),
(''Total Plan Service'', ''41202'', ''41202'', ''Professional''),
(''Touchpoint'', ''87726'', ''87726'', ''Institutional''),
(''Touchpoint'', ''87726'', ''87726'', ''Professional''),
(''Touchstone Health PSO'', ''23856'', ''23856'', ''Institutional''),
(''Touchstone Health PSO'', ''23856'', ''23856'', ''Professional''),
(''Tower Energy Group'', ''J1604'', ''J1604'', ''Institutional''),
(''Tower Energy Group'', ''J1604'', ''J1604'', ''Professional''),
(''Tower Insurance Company Of New York'', ''J3961'', ''J3961'', ''Institutional''),
(''Tower Insurance Company Of New York'', ''J3961'', ''J3961'', ''Professional''),
(''Tower National Insurance Company'', ''J1394'', ''J1394'', ''Institutional''),
(''Tower National Insurance Company'', ''J1394'', ''J1394'', ''Professional''),
(''Town & Country'', ''TKFMC'', ''TKFMC'', ''Professional''),
(''Town of Colma (CA)'', ''J1668'', ''J1668'', ''Institutional''),
(''Town of Colma (CA)'', ''J1668'', ''J1668'', ''Professional''),
(''TR Paul, Inc.'', ''37230'', ''37230'', ''Institutional''),
(''TR Paul, Inc.'', ''37230'', ''37230'', ''Professional''),
(''Tractor Supply Company (Bunch CareSolutions)'', ''J1505'', ''J1505'', ''Institutional''),
(''Tractor Supply Company (Bunch CareSolutions)'', ''J1505'', ''J1505'', ''Professional''),
(''TransAmerica Life Financial Insurance Company'', ''TFLIC'', ''TFLIC'', ''Institutional''),
(''TransAmerica Life Financial Insurance Company'', ''TFLIC'', ''TFLIC'', ''Professional''),
(''Transamerica Life Insurance Company'', ''TRP1E'', ''TRP1E'', ''Institutional''),
(''Transamerica Life Insurance Company'', ''TRP1E'', ''TRP1E'', ''Professional''),
(''TransAmerica Occidental Life Insurance Company'', ''TOLI2'', ''TOLI2'', ''Institutional''),
(''TransAmerica Occidental Life Insurance Company'', ''TOLI2'', ''TOLI2'', ''Professional''),
(''Transamerica Premier Life Insurance Co.'', ''MMLI3'', ''MMLI3'', ''Institutional''),
(''Transamerica Premier Life Insurance Co.'', ''MMLI3'', ''MMLI3'', ''Professional''),
(''TransChoice - Key Benefit Administrators'', ''37284'', ''37284'', ''Institutional''),
(''TransChoice - Key Benefit Administrators'', ''37284'', ''37284'', ''Professional''),
(''Transwestern Insurance Adminstrators, Inc.'', ''TRAN1'', ''TRAN1'', ''Professional''),
(''Travelers'', ''19046'', ''19046'', ''Institutional''),
(''Travelers'', ''19046'', ''19046'', ''Professional''),
(''Travelers Auto'', ''C1032'', ''C1032'', ''Institutional''),
(''Travelers Auto'', ''C1032'', ''C1032'', ''Professional''),
(''Travis County MAP Mediview'', ''TCMAP'', ''TCMAP'', ''Institutional''),
(''Travis County MAP Mediview'', ''TCMAP'', ''TCMAP'', ''Professional''),
(''Trellis Health Partners'', ''36397'', ''36397'', ''Institutional''),
(''Trellis Health Partners'', ''36397'', ''36397'', ''Professional''),
(''Tri-City Healthcare District'', ''41556'', ''41556'', ''Institutional''),
(''Tri-City Healthcare District'', ''41556'', ''41556'', ''Professional''),
(''Tri-City Healthcare District'', ''J1905'', ''J1905'', ''Institutional''),
(''Tri-City Healthcare District'', ''J1905'', ''J1905'', ''Professional''),
(''Tri-City Linen Suppl'', ''41556'', ''41556'', ''Institutional''),
(''Tri-City Linen Suppl'', ''41556'', ''41556'', ''Professional''),
(''Tri-State Insurance Company'', ''J1477'', ''J1477'', ''Institutional''),
(''Tri-State Insurance Company'', ''J1477'', ''J1477'', ''Professional''),
(''Triad Healthcare Inc'', ''39181'', ''39181'', ''Professional''),
(''Tricare East, WPS'', ''TREST'', ''TREST'', ''Institutional''),
(''Tricare East, WPS'', ''TREST'', ''TREST'', ''Professional''),
(''Tricare For Life, WPS'', ''TDDIR'', ''TDDIR'', ''Professional''),
(''Tricare For Life, WPS'', ''TDFIC'', ''TDDIR'', ''Institutional''),
(''Tricare HERO Humana Veterans Health Care Services'', ''HERO'', ''HERO'', ''Professional''),
(''Tricare Overseas, WPS'', ''FOREN'', ''FOREN'', ''Professional''),
(''Tricare West'', ''99726'', ''99726'', ''Institutional''),
(''Tricare West'', ''99726'', ''99726'', ''Professional''),
(''Tricity Uniform'', ''41556'', ''41556'', ''Institutional''),
(''Tricity Uniform'', ''41556'', ''41556'', ''Professional''),
(''TriHealth Physician Solutions - Concern'', ''31143'', ''31143'', ''Institutional''),
(''TriHealth Physician Solutions - Concern'', ''31144'', ''31143'', ''Professional''),
(''Trillium Advantage Medicare'', ''68069'', ''68069'', ''Institutional''),
(''Trillium Advantage Medicare'', ''68069'', ''68069'', ''Professional''),
(''Trillium Medicaid'', ''68069'', ''68069'', ''Institutional''),
(''Trillium Medicaid'', ''68069'', ''68069'', ''Professional''),
(''Trillium Staffing Solutions'', ''J1674'', ''J1674'', ''Institutional''),
(''Trillium Staffing Solutions'', ''J1674'', ''J1674'', ''Professional''),
(''Trilogy Health Network'', ''62777'', ''62777'', ''Institutional''),
(''Trilogy Health Network'', ''62777'', ''62777'', ''Professional''),
(''Trindel Insurance Fund'', ''J1971'', ''J1971'', ''Institutional''),
(''Trindel Insurance Fund'', ''J1971'', ''J1971'', ''Professional''),
(''Trinity Health PACE'', ''TRNPC'', ''TRNPC'', ''Institutional''),
(''Trinity Health PACE'', ''TRNPC'', ''TRNPC'', ''Professional''),
(''Trinity Healthshare'', ''TRIN1'', ''TRIN1'', ''Institutional''),
(''Trinity Healthshare'', ''TRIN1'', ''TRIN1'', ''Professional''),
(''Trinity Universal Insurance'', ''C1030'', ''C1030'', ''Institutional''),
(''Trinity Universal Insurance'', ''C1030'', ''C1030'', ''Professional''),
(''Triple A'', ''11983'', ''11983'', ''Institutional''),
(''Triple A'', ''11983'', ''11983'', ''Professional''),
(''Triplefin LLC'', ''64300'', ''64300'', ''Institutional''),
(''Triplefin LLC'', ''64300'', ''64300'', ''Professional''),
(''TRISTAR Benefit Administrators - Des Moines, Iowa'', ''42137'', ''42137'', ''Institutional''),
(''TRISTAR Benefit Administrators - Des Moines, Iowa'', ''42137'', ''42137'', ''Professional''),
(''TriState Benefit Solutions'', ''31144'', ''31144'', ''Institutional''),
(''TriState Benefit Solutions'', ''31144'', ''31144'', ''Professional''),
(''Tru Blue TPA'', ''83413'', ''83413'', ''Institutional''),
(''Tru Blue TPA'', ''83413'', ''83413'', ''Professional''),
(''Truck Insurance Exchange (Commercial Only)'', ''C1034'', ''C1034'', ''Institutional''),
(''Truck Insurance Exchange (Commercial Only)'', ''C1034'', ''C1034'', ''Professional''),
(''True Health New Mexico'', ''82288'', ''82288'', ''Institutional''),
(''True Health New Mexico'', ''82288'', ''82288'', ''Professional''),
(''Trumball Insurance Company'', ''C1040'', ''C1040'', ''Institutional''),
(''Trumball Insurance Company'', ''C1040'', ''C1040'', ''Professional''),
(''Trusted Health Plan Michigan'', ''38224'', ''38224'', ''Institutional''),
(''Trusted Health Plan Michigan'', ''38224'', ''38224'', ''Professional''),
(''Trusteed Plans Service Corporation - Tacoma, Washington'', ''91078'', ''91078'', ''Institutional''),
(''Trusteed Plans Service Corporation - Tacoma, Washington'', ''91078'', ''91078'', ''Professional''),
(''Trustmark Insurance Company'', ''61425'', ''61425'', ''Institutional''),
(''Trustmark Insurance Company'', ''61425'', ''61425'', ''Professional''),
(''TTPA Comm'', ''76054'', ''76054'', ''Institutional''),
(''TTPA Comm'', ''76054'', ''76054'', ''Professional''),
(''Tuality Health Select'', ''THASC'', ''THASC'', ''Professional''),
(''Tucson Unified School Dist WC'', ''41556'', ''41556'', ''Institutional''),
(''Tucson Unified School Dist WC'', ''41556'', ''41556'', ''Professional''),
(''Tufts Health Plan'', ''04298'', ''04298'', ''Institutional''),
(''Tufts Health Plan'', ''04298'', ''04298'', ''Professional''),
(''Tufts Health Public Plans'', ''04298'', ''04298'', ''Institutional''),
(''Tufts Health Public Plans'', ''04298'', ''04298'', ''Professional''),
(''TulareCare'', ''TULCR'', ''TULCR'', ''Professional''),
(''Twin Cities Fire Insurance Co'', ''C1040'', ''C1040'', ''Institutional''),
(''Twin Cities Fire Insurance Co'', ''C1040'', ''C1040'', ''Professional''),
(''TXEN AltPros'', ''75206'', ''75206'', ''Professional''),
(''Tyson Foods Inc.'', ''J1732'', ''J1732'', ''Institutional''),
(''Tyson Foods Inc.'', ''J1732'', ''J1732'', ''Professional''),
(''UBH - United Behavioral Health (Health Plan HMO)'', ''87726'', ''87726'', ''Institutional''),
(''UBH - United Behavioral Health (Health Plan HMO)'', ''87726'', ''87726'', ''Professional''),
(''UBH RIOS'', ''87726'', ''87726'', ''Institutional''),
(''UBH RIOS'', ''87726'', ''87726'', ''Professional''),
(''UC Davis Health System'', ''UCDMG'', ''UCDMG'', ''Institutional''),
(''UC Davis Health System'', ''UCDMG'', ''UCDMG'', ''Professional''),
(''UC Health Plan Administrators'', ''89789'', ''89789'', ''Institutional''),
(''UC Health Plan Administrators'', ''89789'', ''89789'', ''Professional''),
(''UCare Connect'', ''52629'', ''52629'', ''Institutional''),
(''UCare Connect'', ''52629'', ''52629'', ''Professional''),
(''UCare Connect +Medicare'', ''52629'', ''52629'', ''Institutional''),
(''UCare Connect +Medicare'', ''52629'', ''52629'', ''Professional''),
(''UCare Medicare'', ''55413'', ''55413'', ''Institutional''),
(''UCare Medicare'', ''55413'', ''55413'', ''Professional''),
(''UCare Medicare with M Health Fairview and N. Memorial Health'', ''55413'', ''55413'', ''Institutional''),
(''UCare Medicare with M Health Fairview and N. Memorial Health'', ''55413'', ''55413'', ''Professional''),
(''UCare Minnesota Senior Care Plus (MSC+)'', ''52629'', ''52629'', ''Institutional''),
(''UCare Minnesota Senior Care Plus (MSC+)'', ''52629'', ''52629'', ''Professional''),
(''UCare Minnesota Senior Health Options (MSHO)'', ''52629'', ''52629'', ''Institutional''),
(''UCare Minnesota Senior Health Options (MSHO)'', ''52629'', ''52629'', ''Professional''),
(''UCare MinnesotaCare (MnCare)'', ''52629'', ''52629'', ''Institutional''),
(''UCare MinnesotaCare (MnCare)'', ''52629'', ''52629'', ''Professional''),
(''UCare of Minnesota Individual and Family Plans'', ''55413'', ''55413'', ''Institutional''),
(''UCare of Minnesota Individual and Family Plans'', ''55413'', ''55413'', ''Professional''),
(''UCare Prepaid Medical Assistance Program (PMAP)'', ''52629'', ''52629'', ''Institutional''),
(''UCare Prepaid Medical Assistance Program (PMAP)'', ''52629'', ''52629'', ''Professional''),
(''UCI - University Physicians and Surgeons'', ''HSM01'', ''HSM01'', ''Institutional''),
(''UCI - University Physicians and Surgeons'', ''HSM01'', ''HSM01'', ''Professional''),
(''UCLA Medical Group'', ''USMBP'', ''USMBP'', ''Institutional''),
(''UCLA Medical Group'', ''USMBP'', ''USMBP'', ''Professional''),
(''UCS - Allegiance Health Management'', ''99588'', ''99588'', ''Institutional''),
(''UCS - Allegiance Health Management'', ''99588'', ''99588'', ''Professional''),
(''UCS - Benefit Management Administrators'', ''84566'', ''84566'', ''Institutional''),
(''UCS - Benefit Management Administrators'', ''84566'', ''84566'', ''Professional''),
(''UCS - Benefit Plan Administrators of Eau Claire, Inc.'', ''46891'', ''46891'', ''Institutional''),
(''UCS - Benefit Plan Administrators of Eau Claire, Inc.'', ''46891'', ''46891'', ''Professional''),
(''UCS - Coeur: Leonard Holding Company'', ''84365'', ''84365'', ''Institutional''),
(''UCS - Coeur: Leonard Holding Company'', ''84365'', ''84365'', ''Professional''),
(''UCS - Kempton Group TPA - Kempton Group Administrators'', ''90210'', ''90210'', ''Institutional''),
(''UCS - Kempton Group TPA - Kempton Group Administrators'', ''90210'', ''90210'', ''Professional''),
(''UCS Seminole Tribe of Florida'', ''78702'', ''78702'', ''Institutional''),
(''UCS Seminole Tribe of Florida'', ''78702'', ''78702'', ''Professional''),
(''UCS: Coeur Plan Services - Pinnacle Medical Systems, Inc.'', ''95287'', ''95287'', ''Institutional''),
(''UCS: Coeur Plan Services - Pinnacle Medical Systems, Inc.'', ''95287'', ''95287'', ''Professional''),
(''UCS: Diversified Benefit Administrators, Inc.'', ''65894'', ''65894'', ''Institutional''),
(''UCS: Diversified Benefit Administrators, Inc.'', ''65894'', ''65894'', ''Professional''),
(''UCSF/CSL Pulmonary'', ''65006'', ''65006'', ''Professional''),
(''UFCW - United Food & Commercial Workers Midwest Unions'', ''36659'', ''36659'', ''Professional''),
(''UFCW California (Blue Shield)'', ''94036'', ''CABLS'', ''Professional''),
(''UHA University Health Alliance'', ''99026'', ''99026'', ''Institutional''),
(''UHA University Health Alliance'', ''99026'', ''99026'', ''Professional''),
(''UICI Administrators - State of Nevada'', ''39026'', ''39026'', ''Institutional''),
(''UICI Administrators - State of Nevada'', ''39026'', ''39026'', ''Professional''),
(''Ultimate Health Plan'', ''77022'', ''77022'', ''Institutional''),
(''Ultimate Health Plan'', ''77022'', ''77022'', ''Professional''),
(''Ultra Benefits Inc'', ''41206'', ''41206'', ''Institutional''),
(''Ultra Benefits Inc'', ''41206'', ''41206'', ''Professional''),
(''UMC Health Plan'', ''75130'', ''75130'', ''Institutional''),
(''UMC Health Plan'', ''75130'', ''75130'', ''Professional''),
(''Umpqua Health Alliance'', ''77502'', ''77502'', ''Institutional''),
(''Umpqua Health Alliance'', ''77502'', ''77502'', ''Professional''),
(''UMR - Cincinnati, fka United Medical Resources'', ''39026'', ''39026'', ''Institutional''),
(''UMR - Cincinnati, fka United Medical Resources'', ''39026'', ''39026'', ''Professional''),
(''UMR - Harrington Benefit Services (Columbus, Ohio)'', ''39026'', ''39026'', ''Institutional''),
(''UMR - Harrington Benefit Services (Columbus, Ohio)'', ''39026'', ''39026'', ''Professional''),
(''UMR - Lexington, fka CommonWealth Administrative Group'', ''39026'', ''39026'', ''Institutional''),
(''UMR - Lexington, fka CommonWealth Administrative Group'', ''39026'', ''39026'', ''Professional''),
(''UMR - United Healthcare Shared Services'', ''39026'', ''39026'', ''Institutional''),
(''UMR - United Healthcare Shared Services'', ''39026'', ''39026'', ''Professional''),
(''UMR - Wausau/UHIS, fka Fiserv Health - Wausau Benefits, Benesight, Employers Insurance of Wisconsin'', ''39026'', ''39026'', ''Institutional''),
(''UMR - Wausau/UHIS, fka Fiserv Health - Wausau Benefits, Benesight, Employers Insurance of Wisconsin'', ''39026'', ''39026'', ''Professional''),
(''UMR Risk Management (previously POMCO)'', ''J2004'', ''J2004'', ''Institutional''),
(''UMR Risk Management (previously POMCO)'', ''J2004'', ''J2004'', ''Professional''),
(''UMWA Health & Retirement Funds'', ''52180'', ''52180'', ''Institutional''),
(''UMWA Health & Retirement Funds'', ''52180'', ''52180'', ''Professional''),
(''Underwriters Safety and Claims'', ''TP108'', ''TP108'', ''Institutional''),
(''Underwriters Safety and Claims'', ''TP108'', ''TP108'', ''Professional''),
(''UniCare, Anthem'', ''80314'', ''80314'', ''Institutional''),
(''UniCare, Anthem'', ''80314'', ''80314'', ''Professional''),
(''Unified Group Services'', ''35198'', ''35198'', ''Institutional''),
(''Unified Group Services'', ''35198'', ''35198'', ''Professional''),
(''Unified Health Services'', ''62170'', ''62170'', ''Institutional''),
(''Unified Health Services'', ''62170'', ''62170'', ''Professional''),
(''Unified Physicians Network'', ''34638'', ''34638'', ''Institutional''),
(''Unified Physicians Network'', ''34638'', ''34638'', ''Professional''),
(''Uniformed Service Family Health Plan'', ''13407'', ''13407'', ''Institutional''),
(''Uniformed Service Family Health Plan'', ''13407'', ''13407'', ''Professional''),
(''Unigard Insurance Company - QBE DBA'', ''J1484'', ''J1484'', ''Institutional''),
(''Unigard Insurance Company - QBE DBA'', ''J1484'', ''J1484'', ''Professional''),
(''Union Construction Workers'''' Comp Program'', ''J1629'', ''J1629'', ''Institutional''),
(''Union Construction Workers'''' Comp Program'', ''J1629'', ''J1629'', ''Professional''),
(''Union de Carpinteros'', ''46046'', ''46046'', ''Professional''),
(''Union Insurance Company'', ''J1274'', ''J1274'', ''Institutional''),
(''Union Insurance Company'', ''J1274'', ''J1274'', ''Professional''),
(''Union Insurance Company of Providence'', ''25844'', ''25844'', ''Institutional''),
(''Union Insurance Company of Providence'', ''25844'', ''25844'', ''Professional''),
(''Union Insurance Company of Providence'', ''C1029'', ''C1029'', ''Institutional''),
(''Union Insurance Company of Providence'', ''C1029'', ''C1029'', ''Professional''),
(''Union Insurance Company of Providence'', ''J1433'', ''J1433'', ''Institutional''),
(''Union Insurance Company of Providence'', ''J1433'', ''J1433'', ''Professional''),
(''Union Pacific Railroad Employees - Iron Road Health'', ''87042'', ''87042'', ''Institutional''),
(''Union Pacific Railroad Employees - Iron Road Health'', ''87042'', ''87042'', ''Professional''),
(''Unison Health Plan/Three Rivers'', ''87726'', ''87726'', ''Institutional''),
(''Unison Health Plan/Three Rivers'', ''87726'', ''87726'', ''Professional''),
(''Unite Health Share Ministries (UHSM)'', ''83173'', ''83173'', ''Institutional''),
(''Unite Health Share Ministries (UHSM)'', ''83173'', ''83173'', ''Professional''),
(''Unite Here'', ''UNITE'', ''UNITE'', ''Institutional''),
(''Unite Here'', ''UNITE'', ''UNITE'', ''Professional''),
(''United Agriculture Benefit Trust'', ''UAGBT'', ''UAGBT'', ''Professional''),
(''United Benefit Advisors'', ''38260'', ''38260'', ''Institutional''),
(''United Benefit Advisors'', ''38260'', ''38260'', ''Professional''),
(''United Care Medical Group'', ''ADCUC'', ''ADCUC'', ''Institutional''),
(''United Care Medical Group'', ''ADCUC'', ''ADCUC'', ''Professional''),
(''United Convalescent'', ''41556'', ''41556'', ''Institutional''),
(''United Convalescent'', ''41556'', ''41556'', ''Professional''),
(''United Dominion Realty Trust'', ''J1048'', ''J1048'', ''Institutional''),
(''United Dominion Realty Trust'', ''J1048'', ''J1048'', ''Professional''),
(''United Financial Casualty Company'', ''J1789'', ''J1789'', ''Institutional''),
(''United Financial Casualty Company'', ''J1789'', ''J1789'', ''Professional''),
(''United Fire'', ''J1401'', ''J1401'', ''Institutional''),
(''United Fire'', ''J1401'', ''J1401'', ''Professional''),
(''United Fire Group (aka Mercer Insurance)'', ''C1102'', ''C1102'', ''Institutional''),
(''United Fire Group (aka Mercer Insurance)'', ''C1102'', ''C1102'', ''Professional''),
(''United Food & Commercial Workers Unions and Food Employers Benefit'', ''SCUFW'', ''SCUFW'', ''Professional''),
(''United Group Programs'', ''UGP19'', ''UGP19'', ''Institutional''),
(''United Group Programs'', ''UGP19'', ''UGP19'', ''Professional''),
(''United Healthcare'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare - All Savers'', ''81400'', ''81400'', ''Institutional''),
(''United Healthcare - All Savers'', ''81400'', ''81400'', ''Professional''),
(''United Healthcare - Definity Health Plan'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare - Definity Health Plan'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare - Definity Services'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare - Definity Services'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare Caterpillar Inc.'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare Caterpillar Inc.'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare Community Plan Arizona Physicians IPA (APIPA)'', ''03432'', ''03432'', ''Institutional''),
(''United Healthcare Community Plan Arizona Physicians IPA (APIPA)'', ''03432'', ''03432'', ''Professional''),
(''United Healthcare Community Plan DE, LA, MD, OH, PA, WA'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare Community Plan DE, LA, MD, OH, PA, WA'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare Community Plan IA, MS, TN, River Valley'', ''95378'', ''95378'', ''Institutional''),
(''United Healthcare Community Plan IA, MS, TN, River Valley'', ''95378'', ''95378'', ''Professional''),
(''United Healthcare Community Plan Kansas - KanCare'', ''96385'', ''96385'', ''Institutional''),
(''United Healthcare Community Plan Kansas - KanCare'', ''96385'', ''96385'', ''Professional''),
(''United Healthcare Community Plan Michigan/Great Lakes Health Plan'', ''95467'', ''95467'', ''Institutional''),
(''United Healthcare Community Plan Michigan/Great Lakes Health Plan'', ''95467'', ''95467'', ''Professional''),
(''United Healthcare Community Plan Missouri'', ''86050'', ''86050'', ''Institutional''),
(''United Healthcare Community Plan Missouri'', ''86050'', ''86050'', ''Professional''),
(''United Healthcare Community Plan MS - CAN'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare Community Plan MS - CAN'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare Community Plan Nebraska'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare Community Plan Nebraska'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare Community Plan New Jersey (New Jersey Medicaid)'', ''86047'', ''86047'', ''Institutional''),
(''United Healthcare Community Plan New Jersey (New Jersey Medicaid)'', ''86047'', ''86047'', ''Professional''),
(''United Healthcare Community Plan New York'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare Community Plan New York'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare Community Plan New York - AmeriChoice New York'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare Community Plan New York - AmeriChoice New York'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare Community Plan Pennsylvania'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare Community Plan Pennsylvania'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare Medicare Solutions/UnitedHealthcare MedicareComplete (fka SecureHorizons)'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare Medicare Solutions/UnitedHealthcare MedicareComplete (fka SecureHorizons)'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare of Louisiana'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare of Louisiana'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare Plan of River Valley'', ''95378'', ''95378'', ''Institutional''),
(''United Healthcare Plan of River Valley'', ''95378'', ''95378'', ''Professional''),
(''United Healthcare Student Resources'', ''74227'', ''74227'', ''Institutional''),
(''United Healthcare Student Resources'', ''74227'', ''74227'', ''Professional''),
(''United Healthcare West (Encounters)'', ''95958'', ''95958'', ''Institutional''),
(''United Healthcare West (Encounters)'', ''95958'', ''95958'', ''Professional''),
(''United Healthcare West (formerly known as PacifiCare)'', ''87726'', ''87726'', ''Institutional''),
(''United Healthcare West (formerly known as PacifiCare)'', ''87726'', ''87726'', ''Professional''),
(''United Healthcare, U.S. Networks and Administrative Services'', ''USN01'', ''USN01'', ''Institutional''),
(''United Healthcare, U.S. Networks and Administrative Services'', ''USN01'', ''USN01'', ''Professional''),
(''United HealthOne / Golden Rule Insurance Company'', ''37602'', ''37602'', ''Institutional''),
(''United HealthOne / Golden Rule Insurance Company'', ''37602'', ''37602'', ''Professional''),
(''United Heartland'', ''J1859'', ''J1859'', ''Institutional''),
(''United Heartland'', ''J1859'', ''J1859'', ''Professional''),
(''United Life Insurance Company'', ''ULIFE'', ''PAPER'', ''Professional''),
(''United of Omaha'', ''71412'', ''71412'', ''Institutional''),
(''United of Omaha'', ''71412'', ''71412'', ''Professional''),
(''United Physician International (UPI)'', ''ECMSO'', ''ECMSO'', ''Institutional''),
(''United Physician International (UPI)'', ''SANDS'', ''ECMSO'', ''Professional''),
(''United Physicians of North Colorado'', ''84132'', ''84132'', ''Professional''),
(''United Security Life & Health'', ''81108'', ''81108'', ''Professional''),
(''United Security Life Ins Co'', ''USEC1'', ''PAPER'', ''Institutional''),
(''United Security Life Ins Co'', ''USEC1'', ''PAPER'', ''Professional''),
(''United Self Insured Services - USIS'', ''J1851'', ''J1851'', ''Institutional''),
(''United Self Insured Services - USIS'', ''J1851'', ''J1851'', ''Professional''),
(''United States Cold Storage'', ''J1113'', ''J1113'', ''Institutional''),
(''United States Cold Storage'', ''J1113'', ''J1113'', ''Professional''),
(''United States Fire Insurance Company'', ''31348'', ''31348'', ''Institutional''),
(''United States Fire Insurance Company'', ''31348'', ''31348'', ''Professional''),
(''United Teacher Assoc Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Institutional''),
(''United Teacher Assoc Ins Co - Medicare Supplement'', ''13193'', ''13193'', ''Professional''),
(''United Wisconsin Insurance Company'', ''J1235'', ''J1235'', ''Institutional''),
(''United Wisconsin Insurance Company'', ''J1235'', ''J1235'', ''Professional''),
(''UnitedHealthcare Community Plan / Texas (Americhoice)'', ''87726'', ''87726'', ''Professional''),
(''UnitedHealthcare Community Plan Ohio (formerly Unison Ohio)'', ''87726'', ''87726'', ''Institutional''),
(''UnitedHealthcare Community Plan Ohio (formerly Unison Ohio)'', ''87726'', ''87726'', ''Professional''),
(''UnitedHealthcare Dual Complete Plan'', ''87726'', ''87726'', ''Institutional''),
(''UnitedHealthcare Dual Complete Plan'', ''87726'', ''87726'', ''Professional''),
(''Unitrin Auto & Home Insurance'', ''C1030'', ''C1030'', ''Institutional''),
(''Unitrin Auto & Home Insurance'', ''C1030'', ''C1030'', ''Professional''),
(''Unitrin Direct Auto Insurance'', ''C1030'', ''C1030'', ''Institutional''),
(''Unitrin Direct Auto Insurance'', ''C1030'', ''C1030'', ''Professional''),
(''Unitrin Direct Property & Casualty Company'', ''16063'', ''16063'', ''Institutional''),
(''Unitrin Direct Property & Casualty Company'', ''16063'', ''16063'', ''Professional''),
(''Unitrin Safeguard Insurance'', ''C1030'', ''C1030'', ''Institutional''),
(''Unitrin Safeguard Insurance'', ''C1030'', ''C1030'', ''Professional''),
(''Unity Health Insurance Corp'', ''66705'', ''66705'', ''Institutional''),
(''Unity Health Insurance Corp'', ''66705'', ''66705'', ''Professional''),
(''Univera Healthcare'', ''UNINW'', ''UNINW'', ''Institutional''),
(''Univera Healthcare'', ''UNINW'', ''UNINW'', ''Professional''),
(''Universal Care (Encounters)'', ''UC002'', ''UC002'', ''Institutional''),
(''Universal Care (Encounters)'', ''UC002'', ''UC002'', ''Professional''),
(''Universal Care (FFS)'', ''UC001'', ''UC001'', ''Institutional''),
(''Universal Care (FFS)'', ''UC001'', ''UC001'', ''Professional''),
(''Universal Care - California'', ''33001'', ''33001'', ''Institutional''),
(''Universal Care - California'', ''33001'', ''33001'', ''Professional''),
(''University Care Advantage'', ''09830'', ''09830'', ''Institutional''),
(''University Care Advantage'', ''09830'', ''09830'', ''Professional''),
(''University Family Care'', ''09830'', ''09830'', ''Institutional''),
(''University Family Care'', ''09830'', ''09830'', ''Professional''),
(''University Family Care - Maricopa Health Plan'', ''09908'', ''09908'', ''Institutional''),
(''University Family Care - Maricopa Health Plan'', ''09908'', ''09908'', ''Professional''),
(''University Health Care Advantage'', ''46407'', ''46407'', ''Institutional''),
(''University Health Care Advantage'', ''46407'', ''46407'', ''Professional''),
(''University Healthcare Marketplace'', ''45437'', ''45437'', ''Institutional''),
(''University Healthcare Marketplace'', ''45437'', ''45437'', ''Professional''),
(''University of Colorado'', ''41556'', ''41556'', ''Institutional''),
(''University of Colorado'', ''41556'', ''41556'', ''Professional''),
(''University of Illinois at Chicago, Div of Specialized Care for Children'', ''37601'', ''37601'', ''Institutional''),
(''University of Illinois at Chicago, Div of Specialized Care for Children'', ''37601'', ''37601'', ''Professional''),
(''University of Kentucky Health Services'', ''J1941'', ''J1941'', ''Institutional''),
(''University of Kentucky Health Services'', ''J1941'', ''J1941'', ''Professional''),
(''University of Maryland Health Advantage'', ''45282'', ''45282'', ''Institutional''),
(''University of Maryland Health Advantage'', ''45282'', ''45282'', ''Professional''),
(''University of Miami Behavioral Health'', ''92579'', ''92579'', ''Institutional''),
(''University of Miami Behavioral Health'', ''92579'', ''92579'', ''Professional''),
(''University of Missouri (Coventry)'', ''25133'', ''25133'', ''Institutional''),
(''University of Missouri (Coventry)'', ''25133'', ''25133'', ''Professional''),
(''University of Utah Health Plans'', ''SX155'', ''SX155'', ''Institutional''),
(''University of Utah Health Plans'', ''SX155'', ''SX155'', ''Professional''),
(''University of Washington Students & Graduate Students'', ''91136'', ''91136'', ''Institutional''),
(''University of Washington Students & Graduate Students'', ''91136'', ''91136'', ''Professional''),
(''Univita'', ''ATEND'', ''ATEND'', ''Institutional''),
(''Univita'', ''ATEND'', ''ATEND'', ''Professional''),
(''Upland Medical Group (California)'', ''PROSP'', ''PROSP'', ''Professional''),
(''UPMC Health Plans'', ''23281'', ''23281'', ''Institutional''),
(''UPMC Health Plans'', ''23281'', ''23281'', ''Professional''),
(''Upper Peninsula Health Plan'', ''38337'', ''38337'', ''Institutional''),
(''Upper Peninsula Health Plan'', ''38337'', ''38337'', ''Professional''),
(''US Benefits'', ''93092'', ''93092'', ''Institutional''),
(''US Benefits'', ''93092'', ''93092'', ''Professional''),
(''US Department of Labor - DCMWC - Black Lung'', ''77104'', ''77104'', ''Professional''),
(''US Department of Labor - DEEOIC - Energy'', ''77103'', ''77103'', ''Professional''),
(''US Department of Labor - Office of Workers'''' Compensation Program'', ''77044'', ''77044'', ''Institutional''),
(''US Department of Labor - Office of Workers'''' Compensation Program'', ''77044'', ''77044'', ''Professional''),
(''US Family Health Plan at PACMed'', ''90551'', ''90551'', ''Institutional''),
(''US Family Health Plan at PACMed'', ''90551'', ''90551'', ''Professional''),
(''US Family Health Texas & Louisiana'', ''USFHP'', ''USFHP'', ''Institutional''),
(''US Family Health Texas & Louisiana'', ''USFHP'', ''USFHP'', ''Professional''),
(''US Foodservice, Inc.'', ''J1114'', ''J1114'', ''Institutional''),
(''US Foodservice, Inc.'', ''J1114'', ''J1114'', ''Professional''),
(''US Imaging Network (NY)'', ''50383'', ''50383'', ''Professional''),
(''US Mobile Wireless'', ''41556'', ''41556'', ''Institutional''),
(''US Mobile Wireless'', ''41556'', ''41556'', ''Professional''),
(''US National Resources (Aigrm)'', ''J1115'', ''J1115'', ''Institutional''),
(''US National Resources (Aigrm)'', ''J1115'', ''J1115'', ''Professional''),
(''US Sugar Corporation'', ''J1950'', ''J1950'', ''Institutional''),
(''US Sugar Corporation'', ''J1950'', ''J1950'', ''Professional''),
(''USAA (all states except FL, HI, NY, PA)'', ''J1822'', ''J1822'', ''Institutional''),
(''USAA (all states except FL, HI, NY, PA)'', ''J1822'', ''J1822'', ''Professional''),
(''USAA (United States Automobile Association)'', ''74095'', ''74095'', ''Institutional''),
(''USAA (United States Automobile Association)'', ''74095'', ''74095'', ''Professional''),
(''USAble Administrators'', ''00520'', ''ARBLU'', ''Institutional''),
(''USAble Administrators'', ''ARBLU'', ''ARBLU'', ''Professional''),
(''USFHP-St. Vincent Catholic Medical Center'', ''13407'', ''13407'', ''Institutional''),
(''USFHP-St. Vincent Catholic Medical Center'', ''13407'', ''13407'', ''Professional''),
(''Utah Public Employees Health Plan (PEHP)'', ''SX106'', ''SX106'', ''Institutional''),
(''Utah Public Employees Health Plan (PEHP)'', ''SX106'', ''SX106'', ''Professional''),
(''Utica'', ''C1027'', ''C1027'', ''Institutional''),
(''Utica'', ''C1027'', ''C1027'', ''Professional''),
(''Utica Mutual Insurance Co'', ''25976'', ''25976'', ''Institutional''),
(''Utica Mutual Insurance Co'', ''25976'', ''25976'', ''Professional''),
(''Utica National Insurance Co of Texas'', ''43478'', ''43478'', ''Institutional''),
(''Utica National Insurance Co of Texas'', ''43478'', ''43478'', ''Professional''),
(''V&M Restoration'', ''41556'', ''41556'', ''Institutional''),
(''V&M Restoration'', ''41556'', ''41556'', ''Professional''),
(''Valenzuela Eng. Inc'', ''41556'', ''41556'', ''Institutional''),
(''Valenzuela Eng. Inc'', ''41556'', ''41556'', ''Professional''),
(''Valir PACE'', ''64009'', ''64009'', ''Professional''),
(''Valley Care IPA'', ''VCIPA'', ''VCIPA'', ''Professional''),
(''Valley Care Select IPA'', ''VSIPA'', ''VSIPA'', ''Professional''),
(''Valley Casework Inc'', ''41556'', ''41556'', ''Institutional''),
(''Valley Casework Inc'', ''41556'', ''41556'', ''Professional''),
(''Valley Harvesting & Packing, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''Valley Harvesting & Packing, Inc.'', ''41556'', ''41556'', ''Professional''),
(''Valley Health Care Management Services, LLC'', ''41556'', ''41556'', ''Institutional''),
(''Valley Health Care Management Services, LLC'', ''41556'', ''41556'', ''Professional''),
(''Valley Health Plan - CHDP'', ''VHPCH'', ''VHPCH'', ''Institutional''),
(''Valley Health Plan - CHDP'', ''VHPCH'', ''VHPCH'', ''Professional''),
(''Valley Health Plan - Commercial'', ''VHP01'', ''VHPCO'', ''Professional''),
(''Valley Health Plan - Managed Care'', ''VHPMC'', ''VHPMC'', ''Institutional''),
(''Valley Health Plan - Managed Care'', ''VHPMC'', ''VHPMC'', ''Professional''),
(''Valley Health System'', ''41556'', ''41556'', ''Institutional''),
(''Valley Health System'', ''41556'', ''41556'', ''Professional''),
(''Valley Memorial Hospital'', ''41556'', ''41556'', ''Institutional''),
(''Valley Memorial Hospital'', ''41556'', ''41556'', ''Professional''),
(''Valley Mills ISD'', ''J1873'', ''J1873'', ''Institutional''),
(''Valley Mills ISD'', ''J1873'', ''J1873'', ''Professional''),
(''Valley Preferred - PPO Allentown, Pennsylvania  (HIS Gateway Payer)'', ''23253'', ''23253'', ''Professional''),
(''Van Diest (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Van Diest (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Vantage Health Plan, Inc. (Louisiana)'', ''72128'', ''72128'', ''Institutional''),
(''Vantage Health Plan, Inc. (Louisiana)'', ''72128'', ''72128'', ''Professional''),
(''Vantage Medical Group (California) Encounters'', ''PPM02'', ''PPM02'', ''Institutional''),
(''Vantage Medical Group (California) Encounters'', ''PPM02'', ''PPM02'', ''Professional''),
(''Vantage Medical Group (California) Encounters'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Vantage Medical Group (California) Encounters'', ''PROSP'', ''PROSP'', ''Professional''),
(''Vantage Medical Group (California) IPA'', ''PPM01'', ''PPM01'', ''Institutional''),
(''Vantage Medical Group (California) IPA'', ''PPM01'', ''PPM01'', ''Professional''),
(''Vantage Medical Group (California) IPA'', ''PROSP'', ''PROSP'', ''Institutional''),
(''Vantage Medical Group (California) IPA'', ''PROSP'', ''PROSP'', ''Professional''),
(''Varipro'', ''72187'', ''72187'', ''Institutional''),
(''Varipro'', ''72187'', ''72187'', ''Professional''),
(''Ventura County Health Care Plan'', ''VCHCP'', ''VCHCP'', ''Professional''),
(''Venture Pac Develop'', ''41556'', ''41556'', ''Institutional''),
(''Venture Pac Develop'', ''41556'', ''41556'', ''Professional''),
(''Verdugo Hills Medical Group'', ''66126'', ''LMG01'', ''Professional''),
(''Verdugo Hills Medical Group'', ''LMG01'', ''LMG01'', ''Institutional''),
(''Vermeer (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Vermeer (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Vertical Concrete'', ''41556'', ''41556'', ''Institutional''),
(''Vertical Concrete'', ''41556'', ''41556'', ''Professional''),
(''VestaCare'', ''VESTA'', ''VESTA'', ''Institutional''),
(''VestaCare'', ''VESTA'', ''VESTA'', ''Professional''),
(''Veterans Administration (VA) Fee Basis Programs'', ''12115'', ''12115'', ''Institutional''),
(''Veterans Administration (VA) Fee Basis Programs'', ''12115'', ''12115'', ''Professional''),
(''Veterans Affairs Community Care Network Reg. 1, 2, 3'', ''VACCN'', ''VACCN'', ''Institutional''),
(''Veterans Affairs Community Care Network Reg. 1, 2, 3'', ''VACCN'', ''VACCN'', ''Professional''),
(''VGM Homelink'', ''50701'', ''50701'', ''Institutional''),
(''VGM Homelink'', ''50701'', ''50701'', ''Professional''),
(''Via Christi HOPE'', ''48123'', ''48123'', ''Institutional''),
(''Via Christi HOPE'', ''48123'', ''48123'', ''Professional''),
(''Vibra Health Plan'', ''15976'', ''15976'', ''Institutional''),
(''Vibra Health Plan'', ''15976'', ''15976'', ''Professional''),
(''Vicorp Restaurants, Inc.'', ''J1116'', ''J1116'', ''Institutional''),
(''Vicorp Restaurants, Inc.'', ''J1116'', ''J1116'', ''Professional''),
(''Victor Plastics (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Institutional''),
(''Victor Plastics (via EMC Risk Services)'', ''J1118'', ''J1118'', ''Professional''),
(''Victor Valley IPA'', ''VVIPA'', ''VVIPA'', ''Professional''),
(''Victoria ISD'', ''41556'', ''41556'', ''Institutional''),
(''Victoria ISD'', ''41556'', ''41556'', ''Professional''),
(''Viking Insurance Company of Wisconsin'', ''C1033'', ''C1033'', ''Institutional''),
(''Viking Insurance Company of Wisconsin'', ''C1033'', ''C1033'', ''Professional''),
(''Village Family Health'', ''14163'', ''14163'', ''Institutional''),
(''Village Family Health'', ''14163'', ''14163'', ''Professional''),
(''VillageCareMax'', ''26545'', ''26545'', ''Institutional''),
(''VillageCareMax'', ''26545'', ''26545'', ''Professional''),
(''VillageMD'', ''VLGMD'', ''VLGMD'', ''Institutional''),
(''VillageMD'', ''VLGMD'', ''VLGMD'', ''Professional''),
(''Virginia Beach City Public Schools'', ''J2165'', ''J2165'', ''Institutional''),
(''Virginia Beach City Public Schools'', ''J2165'', ''J2165'', ''Professional''),
(''Virginia Health Network'', ''54138'', ''54138'', ''Professional''),
(''Virginia Premier - Medicaid'', ''VAPRM'', ''VAPRM'', ''Institutional''),
(''Virginia Premier - Medicaid'', ''VAPRM'', ''VAPRM'', ''Professional''),
(''Virginia Premier Coordinated Care'', ''VAPRM'', ''VAPRM'', ''Institutional''),
(''Virginia Premier Coordinated Care'', ''VAPRM'', ''VAPRM'', ''Professional''),
(''Virginia Premier Elite - Medallion 4'', ''VAPRM'', ''VAPRM'', ''Institutional''),
(''Virginia Premier Elite - Medallion 4'', ''VAPRM'', ''VAPRM'', ''Professional''),
(''Virginia Premier Elite Plus'', ''VAPRM'', ''VAPRM'', ''Institutional''),
(''Virginia Premier Elite Plus'', ''VAPRM'', ''VAPRM'', ''Professional''),
(''Virginia Premier Medicare Advantage'', ''VAPRM'', ''VAPRM'', ''Institutional''),
(''Virginia Premier Medicare Advantage'', ''VAPRM'', ''VAPRM'', ''Professional''),
(''Virginia Surety Company, Inc.'', ''J1404'', ''J1404'', ''Institutional''),
(''Virginia Surety Company, Inc.'', ''J1404'', ''J1404'', ''Professional''),
(''Vision Service Plan (VSP)'', ''94163'', ''94163'', ''Professional''),
(''Vista Health Plan'', ''25133'', ''25133'', ''Institutional''),
(''Vista Health Plan'', ''25133'', ''25133'', ''Professional''),
(''Vista Hills C Club'', ''41556'', ''41556'', ''Institutional''),
(''Vista Hills C Club'', ''41556'', ''41556'', ''Professional''),
(''Vitality Health Plan of CA FFS'', ''TU127'', ''TU127'', ''Institutional''),
(''Vitality Health Plan of CA FFS'', ''TU127'', ''TU127'', ''Professional''),
(''Viva Health Inc'', ''63114'', ''63114'', ''Institutional''),
(''Viva Health Inc'', ''63114'', ''63114'', ''Professional''),
(''Vivida Health'', ''45488'', ''45488'', ''Institutional''),
(''Vivida Health'', ''45488'', ''45488'', ''Professional''),
(''VNS Choice Medicare'', ''77073'', ''77073'', ''Institutional''),
(''VNS Choice Medicare'', ''77073'', ''77073'', ''Professional''),
(''Volusia Health Network'', ''59266'', ''59266'', ''Institutional''),
(''Volusia Health Network'', ''59266'', ''59266'', ''Professional''),
(''Vons / Safeway'', ''J1750'', ''J1750'', ''Institutional''),
(''Vons / Safeway'', ''J1750'', ''J1750'', ''Professional''),
(''Vought Aircraft Industries'', ''J1405'', ''J1405'', ''Professional''),
(''Vytra Healthcare'', ''22264'', ''22264'', ''Institutional''),
(''Vytra Healthcare'', ''22264'', ''22264'', ''Professional''),
(''W Co Radiology Cntr'', ''41556'', ''41556'', ''Institutional''),
(''W Co Radiology Cntr'', ''41556'', ''41556'', ''Professional''),
(''Wabash Memorial Hospital Association'', ''85256'', ''85256'', ''Institutional''),
(''Wabash Memorial Hospital Association'', ''85256'', ''85256'', ''Professional''),
(''Wagner Meinert'', ''31650'', ''31650'', ''Institutional''),
(''Wagner Meinert'', ''31650'', ''31650'', ''Professional''),
(''Wal-Mart'', ''J1004'', ''J1004'', ''Institutional''),
(''Wal-Mart'', ''J1004'', ''J1004'', ''Professional''),
(''Washington (State of) Labor & Industries'', ''916001069'', ''91600'', ''Institutional''),
(''Washington (State of) Labor & Industries'', ''916001069'', ''91600'', ''Professional''),
(''Washington County'', ''41556'', ''41556'', ''Institutional''),
(''Washington County'', ''41556'', ''41556'', ''Professional''),
(''Washington Hospital'', ''41556'', ''41556'', ''Institutional''),
(''Washington Hospital'', ''41556'', ''41556'', ''Professional''),
(''Washtenaw Health Plan'', ''38343'', ''38343'', ''Institutional''),
(''Washtenaw Health Plan'', ''38343'', ''38343'', ''Professional''),
(''Waterloo Municipal Employees Health Plan'', ''OBALB'', ''OBALB'', ''Institutional''),
(''Waterloo Municipal Employees Health Plan'', ''OBALB'', ''OBALB'', ''Professional''),
(''Waterstone Benefit Administrators'', ''73155'', ''73155'', ''Institutional''),
(''Waterstone Benefit Administrators'', ''73155'', ''73155'', ''Professional''),
(''Watkins Manufacturing Corporation'', ''41556'', ''41556'', ''Institutional''),
(''Watkins Manufacturing Corporation'', ''41556'', ''41556'', ''Professional''),
(''Watts Healthcare Corp (MedPOINT) California'', ''MPM09'', ''MPM09'', ''Professional''),
(''WATTSHealth Foundation, Inc. (SNCC)'', ''41556'', ''41556'', ''Institutional''),
(''WATTSHealth Foundation, Inc. (SNCC)'', ''41556'', ''41556'', ''Professional''),
(''Wawona Packing'', ''41556'', ''41556'', ''Institutional''),
(''Wawona Packing'', ''41556'', ''41556'', ''Professional''),
(''WE Energies'', ''J1406'', ''J1406'', ''Institutional''),
(''WE Energies'', ''J1406'', ''J1406'', ''Professional''),
(''WEA Insurance Group (Wisconsin Education Assoc)'', ''39151'', ''39151'', ''Institutional''),
(''WEA Insurance Group (Wisconsin Education Assoc)'', ''39151'', ''39151'', ''Professional''),
(''WebTPA Employer Services LLC'', ''75261'', ''75261'', ''Institutional''),
(''WebTPA Employer Services LLC'', ''75261'', ''75261'', ''Professional''),
(''Weiss Health Providers'', ''36337'', ''36337'', ''Institutional''),
(''Weiss Health Providers'', ''36337'', ''36337'', ''Professional''),
(''Wellcare Health Plan, (Encounters) Florida & Georgia'', ''59354'', ''593FG'', ''Professional''),
(''Wellcare Health Plan, (Encounters) Florida & Georgia'', ''593FG'', ''593FG'', ''Institutional''),
(''Wellcare Health Plan, Inc. (Encounters)'', ''59354'', ''59354'', ''Institutional''),
(''Wellcare Health Plan, Inc. (Encounters)'', ''59354'', ''59354'', ''Professional''),
(''Wellcare HMO, Inc.'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare HMO, Inc.'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Connecticut'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Connecticut'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Florida'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Florida'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Georgia'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Georgia'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Hawaii'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Hawaii'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Illinois'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Illinois'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Indiana'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Indiana'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Kentucky'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Kentucky'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Louisiana'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Louisiana'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Missouri'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Missouri'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Nebraska'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Nebraska'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of New Jersey'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of New Jersey'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of New York'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of New York'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Ohio'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Ohio'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of South Carolina'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of South Carolina'', ''14163'', ''14163'', ''Professional''),
(''Wellcare of Texas'', ''14163'', ''14163'', ''Institutional''),
(''Wellcare of Texas'', ''14163'', ''14163'', ''Professional''),
(''WellMed (Claims)'', ''WELM2'', ''WELM2'', ''Institutional''),
(''WellMed (Claims)'', ''WELM2'', ''WELM2'', ''Professional''),
(''WellMed (Encounters)'', ''WELMD'', ''WELMD'', ''Professional''),
(''WellMed/Secure Horizons'', ''WELM2'', ''WELM2'', ''Institutional''),
(''WellMed/Secure Horizons'', ''WELM2'', ''WELM2'', ''Professional''),
(''WellSpan Employee Assistance Program'', ''CB457'', ''CB457'', ''Professional''),
(''WellSystems LLC - Continental Benefits LLC'', ''35245'', ''35245'', ''Institutional''),
(''WellSystems LLC - Continental Benefits LLC'', ''35245'', ''35245'', ''Professional''),
(''Wels Benefit Plan Office'', ''22925'', ''22925'', ''Institutional''),
(''Wels Benefit Plan Office'', ''22925'', ''22925'', ''Professional''),
(''Wenatchee Valley Medical Center'', ''91064'', ''91064'', ''Institutional''),
(''Wenatchee Valley Medical Center'', ''91064'', ''91064'', ''Professional''),
(''Wesco Insurance Company'', ''J1857'', ''J1857'', ''Institutional''),
(''Wesco Insurance Company'', ''J1857'', ''J1857'', ''Professional''),
(''Weslaco Independent School District'', ''41556'', ''41556'', ''Institutional''),
(''Weslaco Independent School District'', ''41556'', ''41556'', ''Professional''),
(''West Coast Hospitals, Inc.'', ''41556'', ''41556'', ''Institutional''),
(''West Coast Hospitals, Inc.'', ''41556'', ''41556'', ''Professional''),
(''West Coast Stationary Engineers Health & Security Trust Fund'', ''91136'', ''91136'', ''Institutional''),
(''West Coast Stationary Engineers Health & Security Trust Fund'', ''91136'', ''91136'', ''Professional''),
(''West Covina Medical Group'', ''LMG01'', ''LMG01'', ''Institutional''),
(''West Covina Medical Group'', ''LMG01'', ''LMG01'', ''Professional''),
(''West Oso ISD'', ''41556'', ''41556'', ''Institutional''),
(''West Oso ISD'', ''41556'', ''41556'', ''Professional''),
(''West Surburban Health Providers'', ''80942'', ''80942'', ''Institutional''),
(''West Surburban Health Providers'', ''80942'', ''80942'', ''Professional''),
(''West Texas Rural Counties Association Preferred Risk Pool - WC'', ''41556'', ''41556'', ''Institutional''),
(''West Texas Rural Counties Association Preferred Risk Pool - WC'', ''41556'', ''41556'', ''Professional''),
(''West Virginia Family Health Plan'', ''45276'', ''45276'', ''Institutional''),
(''West Virginia Family Health Plan'', ''45276'', ''45276'', ''Professional''),
(''West Virginia Medicare Advantage Freedom Blue'', ''15459'', ''15459'', ''Professional''),
(''West Virginia Senior Advantage'', ''WVS01'', ''WVS01'', ''Institutional''),
(''West Virginia Senior Advantage'', ''WVS01'', ''WVS01'', ''Professional''),
(''West Virginia Workers Compensation - Brickstreet'', ''77025'', ''77025'', ''Professional''),
(''Westamerica/Phil Long Dealerships'', ''41556'', ''41556'', ''Institutional''),
(''Westamerica/Phil Long Dealerships'', ''41556'', ''41556'', ''Professional''),
(''Western Growers Assurance Trust'', ''24735'', ''24735'', ''Institutional''),
(''Western Growers Assurance Trust'', ''24735'', ''24735'', ''Professional''),
(''Western Growers Insurance Company'', ''24735'', ''24735'', ''Institutional''),
(''Western Growers Insurance Company'', ''24735'', ''24735'', ''Professional''),
(''Western Health Advantage'', ''68039'', ''68039'', ''Institutional''),
(''Western Health Advantage'', ''68039'', ''68039'', ''Professional''),
(''Western Mutual Insurance / WMI-TPA'', ''37247'', ''37247'', ''Institutional''),
(''Western Mutual Insurance / WMI-TPA'', ''37247'', ''37247'', ''Professional''),
(''Western National Assurance'', ''J1569'', ''J1569'', ''Institutional''),
(''Western National Assurance'', ''J1569'', ''J1569'', ''Professional''),
(''Western National Insurance \ Pioneer Specialties'', ''J1586'', ''J1586'', ''Institutional''),
(''Western National Insurance \ Pioneer Specialties'', ''J1586'', ''J1586'', ''Professional''),
(''Western National Insurance Group'', ''J1495'', ''J1495'', ''Institutional''),
(''Western National Insurance Group'', ''J1495'', ''J1495'', ''Professional''),
(''Western Sky Community Care'', ''68069'', ''68069'', ''Institutional''),
(''Western Sky Community Care'', ''68069'', ''68069'', ''Professional''),
(''Western Southern Financial Group - Cincinnati, Ohio'', ''31048'', ''31048'', ''Institutional''),
(''Western Southern Financial Group - Cincinnati, Ohio'', ''31048'', ''31048'', ''Professional''),
(''Westfield Insurance'', ''J1858'', ''J1858'', ''Institutional''),
(''Westfield Insurance'', ''J1858'', ''J1858'', ''Professional''),
(''WestGUARD Insurance Company - Guard DBA'', ''J1453'', ''J1453'', ''Institutional''),
(''WestGUARD Insurance Company - Guard DBA'', ''J1453'', ''J1453'', ''Professional''),
(''White Memorial Medical Center'', ''NMM01'', ''NMM01'', ''Professional''),
(''Willamette View'', ''41556'', ''41556'', ''Institutional''),
(''Willamette View'', ''41556'', ''41556'', ''Professional''),
(''William C. Earhart Company, Inc.'', ''93050'', ''93050'', ''Institutional''),
(''William C. Earhart Company, Inc.'', ''93050'', ''93050'', ''Professional''),
(''Williamette Valley Community Health'', ''33711'', ''33711'', ''Professional''),
(''Williams & Sonoma (Bunch CareSolutions)'', ''J1473'', ''J1473'', ''Institutional''),
(''Williams & Sonoma (Bunch CareSolutions)'', ''J1473'', ''J1473'', ''Professional''),
(''Wilmer-Hutchins ISD/Dallas ISD'', ''41556'', ''41556'', ''Institutional''),
(''Wilmer-Hutchins ISD/Dallas ISD'', ''41556'', ''41556'', ''Professional''),
(''Wilson Mutual Insurance (All States EXCEPT WI/MN)'', ''J1893'', ''J1893'', ''Institutional''),
(''Wilson Mutual Insurance (All States EXCEPT WI/MN)'', ''J1893'', ''J1893'', ''Professional''),
(''Wilson Mutual Insurance (MN/WI ONLY)'', ''J1407'', ''J1407'', ''Institutional''),
(''Wilson Mutual Insurance (MN/WI ONLY)'', ''J1407'', ''J1407'', ''Professional''),
(''Wilson-McShane'', ''41095'', ''41095'', ''Institutional''),
(''Wilson-McShane'', ''41095'', ''41095'', ''Professional''),
(''Wilson-McShane - International Brotherhood of Boilermakers'', ''48603'', ''48603'', ''Professional''),
(''Windsor Health Plan, Inc.'', ''14163'', ''14163'', ''Institutional''),
(''Windsor Health Plan, Inc.'', ''14163'', ''14163'', ''Professional''),
(''WINhealth Partners - Wyoming'', ''27327'', ''WNHLT'', ''Professional''),
(''Wisconsin Auto & Truck Dealers Insurance Plan'', ''39200'', ''39200'', ''Institutional''),
(''Wisconsin Auto & Truck Dealers Insurance Plan'', ''39200'', ''39200'', ''Professional''),
(''Wisconsin Department of Corrections (Vestica)'', ''74101'', ''74101'', ''Institutional''),
(''Wisconsin Department of Corrections (Vestica)'', ''74101'', ''74101'', ''Professional''),
(''WOAH Western Oregon Advanced Health'', ''DOCSO'', ''DOCSO'', ''Professional''),
(''Women''''s Integrated Network Inc (WIN Fertility)'', ''13413'', ''13413'', ''Professional''),
(''Woodland Park West'', ''41556'', ''41556'', ''Institutional''),
(''Woodland Park West'', ''41556'', ''41556'', ''Professional''),
(''Woodman Accident and Life Company'', ''81949'', ''81949'', ''Professional''),
(''Workers Compensation And Employer Liability'', ''J3722'', ''J3722'', ''Institutional''),
(''Workers Compensation And Employer Liability'', ''J3722'', ''J3722'', ''Professional''),
(''Worldcom Inc'', ''J1874'', ''J1874'', ''Institutional''),
(''Worldcom Inc'', ''J1874'', ''J1874'', ''Professional''),
(''WPS Commercial'', ''12X29'', ''WPS00'', ''Institutional''),
(''WPS Commercial'', ''SX022'', ''WPS00'', ''Professional''),
(''WPS My Choice Family Care - Inclusa'', ''12X29'', ''WPS00'', ''Institutional''),
(''WPS My Choice Family Care - Inclusa'', ''SX022'', ''WPS00'', ''Professional''),
(''WPS VA Patient Centered Community Care Regions 4, 5, 6'', ''VAPCCC3'', ''VAPC3'', ''Institutional''),
(''WPS VA Patient Centered Community Care Regions 4, 5, 6'', ''VAPCCC3'', ''VAPC3'', ''Professional''),
(''WPS Veterans Choice Program Regions 4, 5, 6'', ''VAPCCC3'', ''VAPC3'', ''Institutional''),
(''WPS Veterans Choice Program Regions 4, 5, 6'', ''VAPCCC3'', ''VAPC3'', ''Professional''),
(''Writer''''s Guild Industry Health Plan'', ''47198'', ''CABLC'', ''Institutional''),
(''Writer''''s Guild Industry Health Plan'', ''BC001'', ''CABLC'', ''Professional''),
(''Wyman-Gordon Companies'', ''J1117'', ''J1117'', ''Institutional''),
(''Wyman-Gordon Companies'', ''J1117'', ''J1117'', ''Professional''),
(''Xcel Energy'', ''J1628'', ''J1628'', ''Institutional''),
(''Xcel Energy'', ''J1628'', ''J1628'', ''Professional''),
(''Xchanging, Inc'', ''J1412'', ''J1412'', ''Institutional''),
(''Xchanging, Inc'', ''J1412'', ''J1412'', ''Professional''),
(''Ximed Medical Group IPA'', ''PDT01'', ''PDT01'', ''Institutional''),
(''Ximed Medical Group IPA'', ''PDT01'', ''PDT01'', ''Professional''),
(''xl Environmental, Inc.'', ''J1055'', ''J1055'', ''Institutional''),
(''xl Environmental, Inc.'', ''J1055'', ''J1055'', ''Professional''),
(''Yale New Haven Health - MSO INC.'', ''YALEH'', ''PAPER'', ''Institutional''),
(''Yale New Haven Health - MSO INC.'', ''YALEH'', ''PAPER'', ''Professional''),
(''Yale University Health Plan'', ''60646'', ''60646'', ''Professional''),
(''Yamhill CCO - Physical Health'', ''77946'', ''77946'', ''Institutional''),
(''Yamhill CCO - Physical Health'', ''77946'', ''77946'', ''Professional''),
(''Yamhill County CCO - Mental Health'', ''77130'', ''77130'', ''Institutional''),
(''Yamhill County CCO - Mental Health'', ''77130'', ''77130'', ''Professional''),
(''YMCA'', ''41556'', ''41556'', ''Institutional''),
(''YMCA'', ''41556'', ''41556'', ''Professional''),
(''Yorba Park (St. Joseph Heritage Healthcare)'', ''STJOE'', ''STJOE'', ''Institutional''),
(''Yorba Park (St. Joseph Heritage Healthcare)'', ''STJOE'', ''STJOE'', ''Professional''),
(''York Claim Services'', ''J1421'', ''J1421'', ''Institutional''),
(''York Claim Services'', ''J1421'', ''J1421'', ''Professional''),
(''YourCare Health Plan'', ''15003'', ''15003'', ''Institutional''),
(''YourCare Health Plan'', ''15003'', ''15003'', ''Professional''),
(''YouthCare Health IL'', ''68069'', ''68069'', ''Institutional''),
(''YouthCare Health IL'', ''68069'', ''68069'', ''Professional''),
(''Z-Nat Insurance (Zenith National)'', ''30120'', ''30120'', ''Institutional''),
(''Z-Nat Insurance (Zenith National)'', ''30120'', ''30120'', ''Professional''),
(''Zachry Construction'', ''J1409'', ''J1409'', ''Professional''),
(''Zenith American Solutions'', ''59140'', ''59140'', ''Institutional''),
(''Zenith American Solutions'', ''59140'', ''59140'', ''Professional''),
(''Zing Choice Illinois (HMO)'', ''83248'', ''83248'', ''Institutional''),
(''Zing Choice Illinois (HMO)'', ''83248'', ''83248'', ''Professional''),
(''Zurich Farmers'', ''J1015'', ''J1015'', ''Institutional''),
(''Zurich Farmers'', ''J1015'', ''J1015'', ''Professional''),
(''Zurich Insurance N.A.'', ''16535'', ''16535'', ''Institutional''),
(''Zurich Insurance N.A.'', ''16535'', ''16535'', ''Professional'')
  ) as source (Payer_Name, eMEDIX_Payer_Code, PracticeInsights_Payer_Code, Type);
  return;
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Get_ElectronicPayer_Eligibility_Conversion_From_PracticeSolutions_To_eMEDIX]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Get_ElectronicPayer_Eligibility_Conversion_From_PracticeSolutions_To_eMEDIX]()
RETURNS @resultTable TABLE
(
  Payer_Name Varchar(150),
  eMEDIX_Payer_Code VarChar(25),
  PracticeInsights_Payer_Code VarChar(25),
  Type Varchar(20)
)
AS
BEGIN
  INSERT INTO @resultTable (eMEDIX_Payer_Code, PracticeInsights_Payer_Code, Payer_Name, Type)
  select * from 
  ( VALUES 
( ''METHP'', ''10850'', ''HENNEPIN HEALTH (FORMERLY METROPOLITAN HEALTH PLAN)'', ''Professional''),
( ''MAGNA'', ''11303'', ''MAGNACARE'', ''Professional''),
( ''FDELS'', ''11315'', ''FIDELIS CARE NEW YORK'', ''Professional''),
( ''VAFEE'', ''12115'', ''VA FEE BASIS PROGRAMS'', ''Professional''),
( ''MEDCA'', ''12422'', ''MEDICA2 (GROUP IFB)'', ''Professional''),
( ''12956'', ''12956'', ''EMPOWER ARKANSAS'', ''Professional''),
( ''SNATB'', ''13162'', ''1199 SEIU NATIONAL BENEFIT FUND'', ''Professional''),
( ''MHPIL'', ''13189'', ''MERIDIAN HEALTH PLAN OF ILLINOIS'', ''Professional''),
( ''MHPRT'', ''13265'', ''METRO PLUS HEALTH PLAN'', ''Professional''),
( ''CRPHP'', ''13285'', ''CLOVER HEALTH LLC'', ''Professional''),
( ''AFNTY'', ''13334'', ''AFFINITY HEALTH PLAN - MEDICAID'', ''Professional''),
( ''13337'', ''13337'', ''BMC HEALTHNET PLAN (BOSTON MEDICAL)'', ''Professional''),
( ''13337'', ''13337'', ''WELL SENSE HEALTH PLAN (BMCHP)'', ''Professional''),
( ''EMBLM'', ''13551'', ''GHI GROUP HEALTH NEW YORK (EMBLEM)'', ''Professional''),
( ''EMBLM'', ''13551'', ''GHI PPO'', ''Professional''),
( ''77009'', ''14163'', ''FIRST CHOICE (CT)'', ''Professional''),
( ''WCOHP'', ''14163'', ''OHANA HEALTH PLAN'', ''Professional''),
( ''TXNSE'', ''14163'', ''TEXAN PLUS (HOUSTON BEAUMONT)'', ''Professional''),
( ''TDOPT'', ''14163'', ''TODAY''''S OPTIONS (AMERICAN PROGRESSIVE AND PYRAMID LIFE)'', ''Professional''),
( ''TDOPT'', ''14163'', ''TODAY''''S OPTIONS (AMERICAN PROGRESSIVE AND PYRAMID LIFE)'', ''Professional''),
( ''WCHP'', ''14163'', ''WELLCARE HEALTH PLAN'', ''Professional''),
( ''00432'', ''14165'', ''MVP HEALTH PLAN OF NY'', ''Professional''),
( ''16644'', ''16644'', ''NOVA HEALTHCARE ADMINISTRATORS / AZEROS'', ''Professional''),
( ''IAMCD'', ''18049'', ''MEDICAID IOWA'', ''Professional''),
( ''MLNOH'', ''20149'', ''MOLINA HEALTHCARE OF OHIO'', ''Professional''),
( ''PSCSO'', ''20416'', ''PACIFICSOURCE COMMUNITY SOLUTIONS - MEDICAID'', ''Professional''),
( ''MLNTX'', ''20554'', ''MOLINA HEALTHCARE OF TEXAS'', ''Professional''),
( ''ESSNC'', ''20818'', ''ESSENCE HEALTHCARE'', ''Professional''),
( ''MLNIL'', ''20934'', ''MOLINA HEALTHCARE OF ILLINOIS'', ''Professional''),
( ''KSRGA'', ''21313'', ''KAISER FOUNDATION HEALTH PLAN GEORGIA'', ''Professional''),
( ''HNJH'', ''22099'', ''HORIZON BCBS NEW JERSEY'', ''Professional''),
( ''AHMHP - AMCHC'', ''22248'', ''AMERIHEALTH CARITAS PENN FKA MERCY HEALTH PLAN'', ''Professional''),
( ''FALLN'', ''22254'', ''FALLON COMMUNITY HEALTH'', ''Professional''),
( ''HNJH'', ''22326'', ''HORIZON MERCY NEW JERSEY'', ''Professional''),
( ''HNJH'', ''22326'', ''HORIZON NJ HEALTH'', ''Professional''),
( ''MDPYC'', ''22348'', ''MARYLAND PHYSICIANS CARE'', ''Professional''),
( ''22384'', ''22384'', ''ADMINISTRATIVE CONCEPTS INC'', ''Professional''),
( ''HNMHN'', ''22771'', ''MANAGED HEALTH NETWORK (MHN)'', ''Professional''),
( ''23223'', ''23223'', ''THE LOOMIS COMPANY - TPA (IHS GATEWAY)'', ''Professional''),
( ''UPMC'', ''23281'', ''UPMC HEALTH PLAN'', ''Professional''),
( ''KYMHP'', ''23284'', ''KEYSTONE FIRST (MERCY)'', ''Professional''),
( ''SHSC'', ''23285'', ''SELECT HEALTH OF SOUTH CAROLINA'', ''Professional''),
( ''00154'', ''25127'', ''COVENTRY HEALTH CARE OF GEORGIA'', ''Professional''),
( ''00164'', ''25129'', ''COVENTRY HEALTH CARE OF THE CAROLINAS'', ''Professional''),
( ''00166'', ''25130'', ''COVENTRY HEALTH CARE OF DELAWARE'', ''Professional''),
( ''00170'', ''25132'', ''COVENTRY HEALTH CARE OF IOWA'', ''Professional''),
( ''00364'', ''25133'', ''ALTIUS HEALTH PLAN (COVENTRY)'', ''Professional''),
( ''COVTY00512'', ''25133'', ''COVENTRY HEALTH CARE OF FLORIDA'', ''Professional''),
( ''00172'', ''25133'', ''COVENTRY HEALTH CARE OF KANSAS (KANSAS CITY)'', ''Professional''),
( ''00172'', ''25133'', ''COVENTRY HEALTH CARE OF KANSAS-WICHITA'', ''Professional''),
( ''00160'', ''25133'', ''COVENTRY HEALTH CARE OF WEST VIRGINIA'', ''Professional''),
( ''00511'', ''25133'', ''COVENTRYCARES OF NEBRASKA FKA COVENTRY MEDICAID'', ''Professional''),
( ''00158'', ''25135'', ''COVENTRY HEALTH CARE OF LOUISIANA'', ''Professional''),
( ''00176'', ''25136'', ''COVENTRY HEALTH CARE OF NEBRASKA'', ''Professional''),
( ''00184'', ''25141'', ''COVENTRY HEALTH CARE OF MISSOURI'', ''Professional''),
( ''00250 - CH188'', ''25143'', ''COVENTRY HEALTHCARE USA'', ''Professional''),
( ''00179'', ''25146'', ''COVENTRY HEALTH CARE OF ILLINOIS FKA PERSONALCARE'', ''Professional''),
( ''00364'', ''25149'', ''COVENTRY HEALTH CARE NEVADA'', ''Professional''),
( ''00413'', ''25150'', ''COVENTRYCARES OF MICHIGAN FKA OMNICARE'', ''Professional''),
( ''25169'', ''25169'', ''GATEWAY HEALTH PLAN - MEDICAID PA'', ''Professional''),
( ''EMBLM'', ''25531'', ''GHI HMO GROUP HEALTH'', ''Professional''),
( ''AMGRP'', ''26375'', ''AMERIGROUP COMMUNITY CARE'', ''Professional''),
( ''AMGRP'', ''26375'', ''AMERIGROUP MULTI STATE'', ''Professional''),
( ''AMGRP'', ''26375'', ''AMERIGROUP MULTI STATE'', ''Professional''),
( ''AMGRP'', ''26375'', ''AMERIGROUP REAL SOLUTIONS'', ''Professional''),
( ''LCARE'', ''27357'', ''AMERIHEALTH CARITAS LOUISIANA FKA LACARE'', ''Professional''),
( ''00211'', ''29076'', ''MEDICAL MUTUAL OF OHIO'', ''Professional''),
( ''WSTSL'', ''31048'', ''WESTERN SOUTHERN FINANCIAL GROUP (CINCINNATI)'', ''Professional''),
( ''00325 - DAHP'', ''31114'', ''CARESOURCE OHIO'', ''Professional''),
( ''ELDRP'', ''31625'', ''ELDERPLAN, INC'', ''Professional''),
( ''86052'', ''33628'', ''MERCY MARICOPA INTEGRATED CARE'', ''Professional''),
( ''CTRSV'', ''34097'', ''CENTRAL RESERVE LIFE'', ''Professional''),
( ''ANTAR'', ''34192'', ''MUTUAL HEALTH SERVICES'', ''Professional''),
( ''35174'', ''35174'', ''QUAL CHOICE OF ARKANSAS'', ''Professional''),
( ''CRSMD'', ''35182'', ''CORESOURCE OF MD-PA-IL'', ''Professional''),
( ''CRSOH'', ''35183'', ''CORESOURCE OHIO'', ''Professional''),
( ''EVERC'', ''35605'', ''EVERENCE'', ''Professional''),
( ''AARP'', ''36273'', ''AARP MEDICARE SUPPLEMENTAL - UNITED HEALTHCARE'', ''Professional''),
( ''PLNDA'', ''37287'', ''PLANNED ADMINISTRATORS, INC.'', ''Professional''),
( ''ABSYS'', ''37308'', ''ALLIED BENEFIT SYSTEMS'', ''Professional''),
( ''37330'', ''37330'', ''PHP MID-MICHIGAN (NETWORK)'', ''Professional''),
( ''GLDNR'', ''37602'', ''GOLDEN RULE - UNITEDHEALTHONE'', ''Professional''),
( ''PRHTH'', ''38217'', ''PRIORITY HEALTH'', ''Professional''),
( ''HAPMC'', ''38224'', ''HEALTH ALLIANCE PLAN OF MICHIGAN (HAP)'', ''Professional''),
( ''CBSAB'', ''38308'', ''CHRISTIAN BROTHERS SERVICES'', ''Professional''),
( ''HNNC'', ''38309'', ''HEALTH NET ARIZONA'', ''Professional''),
( ''MLNCA'', ''38333'', ''MOLINA HEALTHCARE OF CALIFORNIA'', ''Professional''),
( ''MLNMI'', ''38334'', ''MOLINA HEALTHCARE OF MICHIGAN'', ''Professional''),
( ''MLNWA'', ''38336'', ''MOLINA HEALTHCARE OF WASHINGTON'', ''Professional''),
( ''5402'', ''39026'', ''UMR FKA UMR WAUSAU'', ''Professional''),
( ''SRTHP'', ''39045'', ''SECURITY HEALTH PLAN'', ''Professional''),
( ''DEANH'', ''39113'', ''DEAN HEALTH PLAN'', ''Professional''),
( ''DEANH'', ''39113'', ''DEAN HEALTH PLAN'', ''Professional''),
( ''NETHP'', ''39144'', ''NETWORK HEALTH PLAN OF WI'', ''Professional''),
( ''WPSAR'', ''39185'', ''ARISE HEALTH PLAN'', ''Professional''),
( ''39190'', ''39190'', ''MEDSTAR FAMILY CHOICE'', ''Professional''),
( ''41124'', ''41124'', ''MERITAIN HEALTH MINNEAPOLIS'', ''Professional''),
( ''PO'', ''41147'', ''PREFERREDONE MN'', ''Professional''),
( ''42344'', ''42344'', ''KEYSTONE FIRST COMMUNITY HEALTHCHOICES'', ''Professional''),
( ''GEHA'', ''44054'', ''GEHA'', ''Professional''),
( ''GEHA'', ''44054'', ''GOVERNMENT EMPLOYEES HOSP ASSN (GEHA)'', ''Professional''),
( ''00360'', ''44444'', ''AMERICAN POSTAL WORKERS UNION'', ''Professional''),
( ''00360'', ''44444'', ''APWU AFFORDABLE NETWORK'', ''Professional''),
( ''MLNSC'', ''46299'', ''MOLINA HEALTHCARE OF SOUTH CAROLINA'', ''Professional''),
( ''ABHNJ'', ''46320'', ''AETNA BETTER HEALTH - NEW JERSEY'', ''Professional''),
( ''PHYMU'', ''47027'', ''PHYSICIANS MUTUAL INSURANCE COMPANY'', ''Professional''),
( ''401OS'', ''47163'', ''BLUE SHIELD KANSAS'', ''Professional''),
( ''401OS'', ''47171'', ''BLUE SHIELD KANSAS CITY REGION'', ''Professional''),
( ''BCDEL - 47181'', ''47181'', ''HIGHMARK DE HEALTH OPTIONS (GATEWAY)'', ''Professional''),
( ''401OS'', ''47198'', ''BLUE CROSS OF CALIFORNIA (ANTHEM)'', ''Professional''),
( ''00204'', ''48117'', ''FMH BENEFIT SERVICES (CORESOURCE)'', ''Professional''),
( ''GRPEN'', ''48143'', ''GPA - GROUP AND PENSION ADMINISTRATORS'', ''Professional''),
( ''GRPEN'', ''48143'', ''GROUP AND PENSION ADMINISTRATORS'', ''Professional''),
( ''COMHC'', ''48145'', ''COMMUNITY HEALTH CHOICE - MEDICAID'', ''Professional''),
( ''BCHIC'', ''48330'', ''HAWAII MEDICAL ASSURANCE ASSN (HMAA / HWMG)'', ''Professional''),
( ''BMNKS'', ''48611'', ''BENEFIT MANAGEMENT INC. OF KANSAS'', ''Professional''),
( ''00506'', ''51062'', ''MOLINA HEALTHCARE OF FLORIDA'', ''Professional''),
( ''KSRA'', ''52095'', ''KAISER FOUNDATION HEALTH PLAN MID-ATLANTIC'', ''Professional''),
( ''JHFHP'', ''52123'', ''JOHNS HOPKINS US FAMILY HEALTH PLAN (USFHP)'', ''Professional''),
( ''UMWAH'', ''52180'', ''UMWA HEALTH &AMP; RETIREMENT FUND'', ''Professional''),
( ''JHHC'', ''52189'', ''JOHNS HOPKINS EHP - PRIORITY PARTNERS'', ''Professional''),
( ''ELDRP'', ''52192'', ''BRAVO HEALTH / ELDER HEALTH'', ''Professional''),
( ''62308 - ELDER'', ''52192'', ''CIGNA HEALTHSPRING'', ''Professional''),
( ''UCARM'', ''52629'', ''UCARE MINNESOTA (SX178)'', ''Professional''),
( ''00214'', ''53011'', ''NALC HEALTH BENEFITS'', ''Professional''),
( ''00214'', ''53011'', ''NATIONAL ASSOCIATION OF LETTER CARRIERS (NALC)'', ''Professional''),
( ''401OS'', ''53120'', ''BLUE SHIELD LOUISIANA'', ''Professional''),
( ''OPTMA'', ''54154'', ''OPTIMA HEALTH PLAN'', ''Professional''),
( ''BCIBC'', ''54704'', ''IBC - INDEPEN. BLUE CROSS PERSONAL CHOICE'', ''Professional''),
( ''BCIBC'', ''54704'', ''IBC - INDEPEN. BLUE CROSS PERSONAL CHOICE - INST'', ''Institutional''),
( ''54763'', ''54763'', ''AMERIHEALTH ADMINISTRATORS'', ''Professional''),
( ''54771'', ''54771'', ''BLUE SHIELD PENN HIGHMARK BCBS'', ''Professional''),
( ''401OS'', ''54828'', ''BLUE CROSS SHIELD WEST VIRGINIA'', ''Professional''),
( ''55204'', ''55204'', ''HEALTHNOW NEW YORK'', ''Professional''),
( ''EMBLM'', ''55247'', ''HIP HEALTH INS PLAN OF GREATER NEW YORK (EMBLEM)'', ''Professional''),
( ''PRMPC'', ''56144'', ''HEALTHGRAM INC'', ''Professional''),
( ''401OS'', ''56152'', ''BLUE MEDICARE ADVANTAGE NORTH CAROLINA'', ''Professional''),
( ''56205'', ''56162'', ''MEDCOST INC.'', ''Professional''),
( ''FCCRT'', ''56196'', ''FIRST CAROLINA CARE'', ''Professional''),
( ''ALNTH'', ''58234'', ''ALLIANT HEALTH PLANS OF GEORGIA'', ''Professional''),
( ''HHZCF'', ''59144'', ''CULINARY HEALTH FUND'', ''Professional''),
( ''AVMED'', ''59274'', ''AVMED HEALTH PLAN'', ''Professional''),
( ''59322'', ''59322'', ''FLORIDA HEALTH CARE PLANS (FHCP)'', ''Professional''),
( ''60054'', ''60054'', ''AETNA'', ''Professional''),
( ''60054'', ''60054'', ''AETNA HMO'', ''Professional''),
( ''60054'', ''60054'', ''AETNA MANAGED CHOICE'', ''Professional''),
( ''60054'', ''60054'', ''AETNA US HEALTHCARE'', ''Professional''),
( ''60495'', ''60495'', ''COMMUNITY HEALTH CHOICE - MARKETPLACE'', ''Professional''),
( ''91741'', ''60550'', ''GATEWAY HEALTH PLAN - MEDICARE ASSURED'', ''Professional''),
( ''95885'', ''61101'', ''HUMANA CARE PLAN'', ''Professional''),
( ''95885'', ''61101'', ''HUMANA EMPLOYERS HEALTH INSURANCE'', ''Professional''),
( ''95885'', ''61101'', ''HUMANA GOLD PLUS'', ''Professional''),
( ''95885'', ''61101'', ''HUMANA INSURANCE CHOICE CARE NETWORK'', ''Professional''),
( ''00143'', ''61271'', ''PRINCIPAL FINANCIAL GROUP - VISION'', ''Professional''),
( ''KYPST'', ''61325'', ''KENTUCKY PASSPORT'', ''Professional''),
( ''TRSMK'', ''61425'', ''TRUSTMARK INSURANCE INCL STARMARK'', ''Professional''),
( ''HCOAZ'', ''62180'', ''HEALTH CHOICE GENERATIONS'', ''Professional''),
( ''62308'', ''62308'', ''CIGNA'', ''Professional''),
( ''62308'', ''62308'', ''CIGNA HEALTH PLAN'', ''Professional''),
( ''62308'', ''62308'', ''CIGNA PPO'', ''Professional''),
( ''62308'', ''62308'', ''CIGNA PREMIER PLUS'', ''Professional''),
( ''62308'', ''62308'', ''CIGNA PROVIDER PIN'', ''Professional''),
( ''62308'', ''62308'', ''COMED CIGNA'', ''Professional''),
( ''62308'', ''62308'', ''SAMBA (CIGNA)'', ''Professional''),
( ''ELDER'', ''63092'', ''HEALTHSPRING HMO / MEDICARE+ CHOICE'', ''Professional''),
( ''VIVA'', ''63114'', ''VIVA HEALTH PLAN'', ''Professional''),
( ''VIVA'', ''63114'', ''VIVA MEDICARE PLUS'', ''Professional''),
( ''41124'', ''64157'', ''MERITAIN HEALTH - NORTH AMERICAN'', ''Professional''),
( ''41124'', ''64157'', ''NORTH AMERICAN ADMINISTRATORS'', ''Professional''),
( ''41124'', ''64157'', ''NORTH AMERICAN PREFERRED'', ''Professional''),
( ''CPHP'', ''65031'', ''CAREPLUS HEALTH PLANS'', ''Professional''),
( ''TXBLS'', ''66001'', ''BCBS TEXAS STAR AND CHIP MEDICAID'', ''Professional''),
( ''JHHC'', ''66003'', ''JOHNS HOPKINS ADVANTAGE MD'', ''Professional''),
( ''401OS'', ''66005'', ''BLUE CROSS COMMUNITY OPTIONS (IL)'', ''Professional''),
( ''401OS'', ''66006'', ''BLUE CROSS MEDICARE ADVANTAGE (IL-TX-MT-NM-OK)'', ''Professional''),
( ''66010'', ''66010'', ''CARE N CARE'', ''Professional''),
( ''MEDCS'', ''66039'', ''MEDICAL CARD SYSTEM (MCS)'', ''Professional''),
( ''00885'', ''66058'', ''MEDICARE Y MUCHO MAS (MMM)'', ''Professional''),
( ''PREMD'', ''66059'', ''PREFERRED MEDICARE CHOICE (PMC)'', ''Professional''),
( ''ANHMD'', ''66065'', ''AMERICAN HEALTH MEDICARE (AHM)'', ''Professional''),
( ''UNTHN'', ''66705'', ''UNITY HEALTH INSURANCE'', ''Professional''),
( ''00328'', ''66893'', ''GREATWEST HEALTHCARE FKA NEW ENGLAND FINANCIAL'', ''Professional''),
( ''00349'', ''68035'', ''HEALTH PLAN OF SAN JOAQUIN'', ''Professional''),
( ''CBHAZ'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH ARIZONA'', ''Professional''),
( ''CBHFL'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH FLORIDA'', ''Professional''),
( ''CBHIL'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH ILLINOIS'', ''Professional''),
( ''CBHIN'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH INDIANA'', ''Professional''),
( ''CBHKS'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH KANSAS'', ''Professional''),
( ''CBHMA'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH MASSACHUSETTS'', ''Professional''),
( ''CBHOH'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH OHIO'', ''Professional''),
( ''CBHSC'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH SOUTH CAROLINA'', ''Professional''),
( ''CBHTX'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH TEXAS'', ''Professional''),
( ''CGRPR'', ''68068'', ''CENPATICO BEHAVIORAL HEALTH WISCONSIN'', ''Professional''),
( ''CTOTL'', ''68069'', ''ABSOLUTE TOTAL CARE - SC'', ''Professional''),
( ''CBRIA'', ''68069'', ''ADVANTAGE BY BRIDGEWAY HEALTH SOLUTIONS'', ''Professional''),
( ''CBUCA'', ''68069'', ''ADVANTAGE BY BUCKEYE COMMUNITY HEALTH'', ''Professional''),
( ''CMHSA'', ''68069'', ''ADVANTAGE BY MANAGED HEALTH SERVICES'', ''Professional''),
( ''CSHPA'', ''68069'', ''ADVANTAGE BY SUPERIOR HEALTH PLAN'', ''Professional''),
( ''CAPSH'', ''68069'', ''AMBETTER FROM BUCKEYE HEALTH PLAN'', ''Professional''),
( ''CAPSH'', ''68069'', ''AMBETTER FROM CELTICARE'', ''Professional''),
( ''CAPSH'', ''68069'', ''AMBETTER FROM COORDINATED CARE'', ''Professional''),
( ''CAPSH'', ''68069'', ''AMBETTER FROM MAGNOLIA HEALTH SERVICES'', ''Professional''),
( ''CAPSH'', ''68069'', ''AMBETTER FROM PEACH STATE HEALTH PLAN'', ''Professional''),
( ''CAPSH'', ''68069'', ''AMBETTER FROM SUNSHINE HEALTH PLAN'', ''Professional''),
( ''CAPSH'', ''68069'', ''AMBETTER FROM SUPERIOR HEALTH PLAN'', ''Professional''),
( ''CBRID'', ''68069'', ''BRIDGEWAY HEALTH SOLUTIONS ARIZONA'', ''Professional''),
( ''CBUCK'', ''68069'', ''BUCKEYE COMMUNITY HEALTH PLAN OHIO'', ''Professional''),
( ''CELTI'', ''68069'', ''CELTICARE HEALTH PLAN'', ''Professional''),
( ''HNNC'', ''68069'', ''HEALTH NET CALIF. MEDICARE ADVANTAGE'', ''Professional''),
( ''HNNC'', ''68069'', ''HEALTH NET OF ARIZONA (ACCESS)'', ''Professional''),
( ''HNNC'', ''68069'', ''HEALTH NET OREGON MEDICARE ADVANTAGE'', ''Professional''),
( ''CLINI'', ''68069'', ''ILLINICARE GROUP HEALTH'', ''Professional''),
( ''CENLA'', ''68069'', ''LOUISIANA HEALTHCARE CONNECTIONS - BAYOU HEALTH'', ''Professional''),
( ''CMGHP'', ''68069'', ''MAGNOLIA HEALTH PLAN'', ''Professional''),
( ''CMHIN'', ''68069'', ''MANAGED HEALTH SERVICES INDIANA'', ''Professional''),
( ''CMHWI'', ''68069'', ''MANAGED HEALTH SERVICES WISCONSIN'', ''Professional''),
( ''NEBTC'', ''68069'', ''NEBRASKA TOTAL CARE'', ''Professional''),
( ''CAPSH'', ''68069'', ''PEACH STATE HEALTH PLAN'', ''Professional''),
( ''SILVR'', ''68069'', ''SILVERSUMMIT HEALTH PLAN NEVADA'', ''Professional''),
( ''SUNHP'', ''68069'', ''SUNFLOWER STATE HEALTH PLAN KANSAS'', ''Professional''),
( ''CSSHP'', ''68069'', ''SUNSHINE STATE HEALTH PLAN'', ''Professional''),
( ''CSHPT'', ''68069'', ''SUPERIOR HEALTH PLAN TEXAS'', ''Professional''),
( ''TMCHP'', ''68069'', ''TRILLIUM MEDICARE ADVANTAGE 2016'', ''Professional''),
( ''71063'', ''71063'', ''HEALTHSCOPE BENEFITS'', ''Professional''),
( ''MOONE'', ''71412'', ''MUTUAL OF OMAHA INSURANCE COMPANY'', ''Professional''),
( ''MHSRT'', ''71890'', ''MEDICA HEALTH PLAN SOLUTIONS'', ''Professional''),
( ''PPLSH'', ''72126'', ''PEOPLES HEALTH NETWORK'', ''Professional''),
( ''VHPLA'', ''72128'', ''VANTAGE HEALTH PLAN'', ''Professional''),
( ''ANICO'', ''74048'', ''AMERICAN NATIONAL INS CO (ANICO)'', ''Professional''),
( ''74095'', ''74095'', ''USAA (UNITED STATES AUTOMOBILE ASSN)'', ''Professional''),
( ''RTCRE'', ''74205'', ''RIGHT CARE SCOTT &AMP; WHITE'', ''Professional''),
( ''STDNT'', ''74227'', ''STUDENT RESOURCES (UNITEDHEALTHCARE)'', ''Professional''),
( ''CRSAR'', ''75136'', ''CORESOURCE LITTLE ROCK'', ''Professional''),
( ''ABNSL'', ''75137'', ''AMERIBEN SOLUTIONS'', ''Professional''),
( ''CFSAD'', ''75190'', ''CAREFIRST ADMINISTRATORS (NCAS FAIRFAX)'', ''Professional''),
( ''TXCPL'', ''75228'', ''TEXAS CHILDRENS HEALTH PLAN (STAR)'', ''Professional''),
( ''ALMCD'', ''75254'', ''MEDICAID ALABAMA'', ''Professional''),
( ''WBTPA'', ''75261'', ''CHEC - COMMUNITY HEALTH ELECTRONIC (WEB TPA)'', ''Professional''),
( ''WBTPA'', ''75261'', ''WEB TPA EMPLOYER SERVICES (CHEC)'', ''Professional''),
( ''75273'', ''75273'', ''GEISINGER HEALTH PLAN'', ''Professional''),
( ''TXCPL'', ''76048'', ''TEXAS CHILDRENS HEALTH PLAN (CHIP)'', ''Professional''),
( ''SERRA'', ''76342'', ''SIERRA HEALTH AND LIFE (UHG)'', ''Professional''),
( ''PRSHC'', ''77003'', ''PRESTIGE HEALTH CHOICE'', ''Professional''),
( ''77009'', ''77009'', ''FIRST CHOICE VIP CARE PLUS SOUTH CAROLINA'', ''Professional''),
( ''AMVIP'', ''77013'', ''AMERIHEALTH CARITUS VIP CARE PLUS MICHIGAN'', ''Professional''),
( ''CRPHP'', ''77023'', ''CLOVER INSURANCE'', ''Professional''),
( ''FLMCD'', ''77027'', ''MEDICAID FLORIDA'', ''Professional''),
( ''77032'', ''77032'', ''MEDICAID MISSISSIPPI'', ''Professional''),
( ''GAMCD'', ''77034'', ''MEDICAID GEORGIA'', ''Professional''),
( ''MTMCD'', ''77039'', ''MEDICAID MONTANA (DPHHS)'', ''Professional''),
( ''WYMCD'', ''77046'', ''MEDICAID WYOMING'', ''Professional''),
( ''HIMCD'', ''77060'', ''MEDICAID HAWAII'', ''Professional''),
( ''AMVIP - AHMHP'', ''77062'', ''AMERIHEALTH CARITAS VIP CARE PA'', ''Professional''),
( ''401OS'', ''77078'', ''BLUE CROSS BLUE SHIELD OF ARIZONA ADVANTAGE'', ''Professional''),
( ''CIPMD'', ''77082'', ''CARE IMPROVEMENT PLUS THRU DOS 12-31-2015'', ''Professional''),
( ''77799'', ''77799'', ''AMERIHEALTH CARITAS DELAWARE'', ''Professional''),
( ''HALLS - HAPMC'', ''77950'', ''HEALTH ALLIANCE MEDICAL PLAN IL-IA-NE'', ''Professional''),
( ''CNTCR'', ''78375'', ''CONNECTICARE MEDICARE VIP'', ''Professional''),
( ''MDHCP'', ''78857'', ''MEDICA HEALTHCARE PLAN FLORIDA'', ''Professional''),
( ''HFNJ'', ''80141'', ''HEALTHFIRST NEW JERSEY'', ''Professional''),
( ''HFNY'', ''80141'', ''HEALTHFIRST NEW YORK'', ''Professional''),
( ''HPPA'', ''80142'', ''HEALTH PARTNERS OF PHILADELPHIA'', ''Professional''),
( ''UNICR'', ''80314'', ''UNICARE (ANTHEM)'', ''Professional''),
( ''00328'', ''80705'', ''GREAT WEST HEALTHCARE'', ''Institutional''),
( ''00328'', ''80705'', ''GREAT WEST HEALTHCARE'', ''Professional''),
( ''00328'', ''80705'', ''GREAT WEST HEALTHCARE'', ''Professional''),
( ''00328'', ''80705'', ''GREAT WEST LIFE'', ''Professional''),
( ''EBMSI'', ''81039'', ''EBMS - EMPLOYEE BENEFIT MANAGEMENT SERVICES'', ''Professional''),
( ''EBMSI'', ''81039'', ''EMPLOYEE BENEFIT MANAGEMENT SVCS'', ''Professional''),
( ''81040'', ''81040'', ''ALLEGIANCE BENEFIT PLAN MANAGEMENT'', ''Professional''),
( ''81264'', ''81264'', ''NIPPON LIFE INSURANCE CO'', ''Professional''),
( ''ALLSA'', ''81400'', ''ALL SAVERS INSURANCE (UNITEDHEALTHONE)'', ''Professional''),
( ''MNHBF'', ''81883'', ''MUNICIPAL HEALTH BENEFIT FUND'', ''Professional''),
( ''82275'', ''82275'', ''MUTUAL OF OMAHA MEDICARE ADVANTAGE'', ''Professional''),
( ''SNRWH'', ''83035'', ''SENIOR WHOLE HEALTH'', ''Professional''),
( ''83276'', ''83276'', ''PHYSICIANS HEALTH PLAN OF MICHIGAN MEDICARE'', ''Professional''),
( ''00232'', ''84146'', ''CHAMP VA HAC'', ''Professional''),
( ''53021'', ''84555'', ''LOUISIANA BLUE ADVANTAGE HMO/PPO'', ''Professional''),
( ''TXBLS'', ''84980'', ''BLUE SHIELD BCBS TEXAS'', ''Professional''),
( ''TXBLS'', ''84980'', ''HMO BLUE TEXAS'', ''Professional''),
( ''86052'', ''86052'', ''MERCY CARE PLAN ARIZONA'', ''Professional''),
( ''HWMLD'', ''86066'', ''HMA INC'', ''Professional''),
( ''HWMLD'', ''86066'', ''HMA INC - HAWAII'', ''Professional''),
( ''TXMCD'', ''86916'', ''MEDICAID TEXAS TMHP'', ''Professional''),
( ''00184'', ''87043'', ''COVENTRY HEALTH CARE MISSOURI'', ''Professional''),
( ''00250'', ''87043'', ''COVENTRY NATIONAL NETWORK'', ''Professional''),
( ''00184'', ''87043'', ''UNIVERSITY OF MISSOURI CHOICE - COVENTRY'', ''Professional''),
( ''UHC57'', ''87726'', ''AARP MEDICARECOMPLETE BY UNITEDHEALTHCARE'', ''Professional''),
( ''UHC57'', ''87726'', ''MAMSI LIFE HEALTH INS CO (MLH)'', ''Professional''),
( ''UHC57'', ''87726'', ''SECURE HORIZONS DIRECT FFS UNITED HEALTHCARE'', ''Professional''),
( ''UHC57'', ''87726'', ''SECURE HORIZONS OF ARIZONA HMO'', ''Professional''),
( ''UHC57'', ''87726'', ''SECURE HORIZONS OF COLORADO HMO'', ''Professional''),
( ''UHC57'', ''87726'', ''UBH UNITED BEHAVIORAL HEALTH'', ''Professional''),
( ''UHC57'', ''87726'', ''UHC - UNITED HEALTHCARE'', ''Professional''),
( ''UHC57'', ''87726'', ''UHC MIDWEST MEDICARE COMPLETE'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITED BEHAVIORAL HEALTH'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITED BEHAVIORAL HEALTH'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITED HEALTHCARE'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITED HEALTHCARE HERITAGE'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITEDHEALTHCARE COMMUNITY PLAN'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITEDHEALTHCARE COMMUNITY PLAN CA, DE, FL, HI, IA, LA, MA, MD, MS, NE, NC, NM, NY, OH, OK, PA, RI, TX, VA, WA, WI'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITEDHEALTHCARE MEDICARE'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITEDHEALTHCARE OF THE RIVER VALLEY'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITEDHEALTHCARE WEST (FKA PACIFICARE AZ, CO)'', ''Professional''),
( ''UHC57'', ''87726'', ''UNITEDHEALTHCARE WEST (FKA PACIFICARE CA, OK, OR, TX, WA)'', ''Professional''),
( ''HSBS'', ''87815'', ''HEALTHSMART BENEFIT SOLUTIONS FKA WELLS FARGO TPA'', ''Professional''),
( ''RTCRE - TH002'', ''88030'', ''SCOTT AND WHITE HEALTH CARE PLAN'', ''Professional''),
( ''PREMA4'', ''91049'', ''LIFEWISE HEALTH PLAN OF WASHINGTON'', ''Professional''),
( ''91051'', ''91051'', ''KAISER FOUNDATION HEALTH PLAN WASHINGTON'', ''Professional''),
( ''91184'', ''91184'', ''SANFORD HEALTH PLAN'', ''Professional''),
( ''MDWHA'', ''91313'', ''MDWISE HOOSIER CARE CONNECT (THRU 2018)'', ''Professional''),
( ''91741'', ''91741'', ''GATEWAY HEALTH PLAN - OH MEDICARE ASSURED'', ''Professional''),
( ''PSHPC'', ''93029'', ''PACIFICSOURCE HEALTH PLAN'', ''Professional''),
( ''PREMA5'', ''93093'', ''LIFEWISE HEALTH PLAN OF OREGON'', ''Professional''),
( ''93321'', ''93221'', ''ASURIS NORTHWEST HEALTH'', ''Professional''),
( ''401OS'', ''94036'', ''BLUE SHIELD OF CALIFORNIA'', ''Professional''),
( ''00278'', ''94123'', ''KAISER PERMANENTE HAWAII'', ''Professional''),
( ''KSRCS'', ''94134'', ''KAISER FOUNDATION HEALTH PLAN SOUTH. CALIF.'', ''Professional''),
( ''KSRCN'', ''94135'', ''KAISER FOUNDATION HEALTH PLAN NORTH. CALIF.'', ''Professional''),
( ''MDHCP - MEDIC'', ''94265'', ''MEDICA HEALTH (UHC)'', ''Professional''),
( ''HFHP'', ''95019'', ''HEALTH FIRST HEALTH PLANS'', ''Professional''),
( ''SMAHP'', ''95202'', ''SUMMACARE HEALTH PLAN'', ''Professional''),
( ''10536'', ''95308'', ''INDEPENDENT HEALTH NEW YORK'', ''Professional''),
( ''HNNC'', ''95567'', ''HEALTH NET CALIFORNIA AND OREGON'', ''Professional''),
( ''NERAL'', ''98798'', ''NEW ERA LIFE'', ''Professional''),
( ''ALOHA'', ''99030'', ''ALOHACARE'', ''Professional''),
( ''401OS'', ''00050'', ''BLUE CROSS BLUE SHIELD COLORADO (ANTHEM)'', ''Professional''),
( ''401OS'', ''00060'', ''BLUE CROSS BLUE SHIELD CONNECTICUT (ANTHEM)'', ''Professional''),
( ''401OS'', ''00160'', ''BLUE CROSS BLUE SHIELD KENTUCKY (ANTHEM) - INST'', ''Institutional''),
( ''401OS'', ''00200'', ''BLUE SHIELD MASSACHUSETTS'', ''Professional''),
( ''WPSIC'', ''00235'', ''WPS COMMERCIAL (WPS01)'', ''Professional''),
( ''401OS'', ''00241'', ''BLUE CROSS BLUE SHIELD MISSOURI (ANTHEM)'', ''Professional''),
( ''401OS'', ''00265'', ''BLUE CROSS BLUE SHIELD NEVADA (ANTHEM)'', ''Professional''),
( ''SCBCH'', ''00403'', ''BLUECHOICE SOUTH CAROLINA MEDICAID (ANTHEM)'', ''Professional''),
( ''PREMA1'', ''00430'', ''PREMERA BLUE CROSS WASHINGTON'', ''Professional''),
( ''401OS'', ''00450'', ''BLUE CROSS BLUE SHIELD WISCONSIN (ANTHEM) - INST'', ''Institutional''),
( ''SISCO'', ''00540'', ''SISCO - SELF INSURED SERVICES COMPANY'', ''Professional''),
( ''BCBSM'', ''00562'', ''BCBSMN BLUE PLUS MEDICAID DOS 2019'', ''Professional''),
( ''BCDEL'', ''00570'', ''BLUE SHIELD DELAWARE HIGHMARK'', ''Professional''),
( ''BCGAC'', ''00601'', ''BLUE CROSS BLUE SHIELD GEORGIA (ANTHEM)'', ''Professional''),
( ''401OS'', ''00610'', ''BLUE CROSS OF IDAHO'', ''Professional''),
( ''401OS'', ''00611'', ''BLUE SHIELD OF IDAHO (REGENCE)'', ''Professional''),
( ''401OS'', ''00621'', ''BLUE CROSS BLUE SHIELD OF ILLINOIS ( HCSC)'', ''Professional''),
( ''401OS'', ''00621'', ''BLUE SHIELD ILLINOIS'', ''Professional''),
( ''401OS'', ''00630'', ''BLUE CROSS BLUE SHIELD INDIANA (ANTHEM)'', ''Professional''),
( ''00885'', ''00650'', ''MEDICARE KANSAS'', ''Professional''),
( ''HBLSA'', ''00661'', ''HEALTHY BLUE LOUISIANA'', ''Professional''),
( ''401OS'', ''00680'', ''BLUE CROSS BLUE SHIELD MAINE (ANTHEM)'', ''Professional''),
( ''BCBSM'', ''00720'', ''BLUE SHIELD MINNESOTA'', ''Professional''),
( ''401OS'', ''00760'', ''BLUE SHIELD NEBRASKA'', ''Professional''),
( ''401OS'', ''00770'', ''BLUE CROSS SHIELD NEW HAMPSHIRE (ANTHEM)'', ''Professional''),
( ''401OS'', ''00790'', ''BLUE CROSS BLUE SHIELD NEW MEXICO'', ''Professional''),
( ''401OS'', ''00834'', ''BLUE CROSS BLUE SHIELD OHIO (ANTHEM)'', ''Professional''),
( ''401OS'', ''00851'', ''BLUE SHIELD OREGON (REGENCE)'', ''Professional''),
( ''CB870'', ''00870'', ''BLUE SHIELD RHODE ISLAND'', ''Professional''),
( ''00885'', ''00882'', ''MEDICARE RAILROAD'', ''Professional''),
( ''401OS'', ''00932'', ''BLUE SHIELD OF WASHINGTON (REGENCE)'', ''Professional''),
( ''401OS'', ''00950'', ''BLUE CROSS BLUE SHIELD WISCONSIN (ANTHEM)'', ''Professional''),
( ''00071 - MLNNM'', ''009824'', ''MOLINA HEALTHCARE OF NEW MEXICO (NM505)'', ''Professional''),
( ''01260'', ''01260'', ''MAGELLAN HEALTH SERVICES'', ''Professional''),
( ''PNAIC'', ''04218'', ''PAN AMERICAN LIFE INSURANCE GROUP (PALIG)'', ''Professional''),
( ''HPHC'', ''04271'', ''HARVARD PILGRIM HEALTH CARE'', ''Professional''),
( ''04286'', ''04286'', ''HEALTH NEW ENGLAND'', ''Professional''),
( ''04293'', ''04293'', ''ALLWAYS HEALTH PARTNERS (FKA NEIGHBORHOOD HP)'', ''Professional''),
( ''TUFTS'', ''04298'', ''TUFTS HEALTH PLAN'', ''Professional''),
( ''TUFTS'', ''04332'', ''TUFTS HEALTH PUBLIC PLAN (NETWORK HEALTH)'', ''Professional''),
( ''CNTCR'', ''06105'', ''CONNECTICARE'', ''Professional''),
( ''06111'', ''06111'', ''OXFORD HEALTH'', ''Professional''),
( ''OXDLF'', ''OXHTH'', ''OXFORD HEALTH'', ''Professional''),
( ''CTYCR'', ''06541'', ''COUNTYCARE'', ''Professional''),
( ''HPMN'', ''07003'', ''HEALTHPARTNERS MN'', ''Professional''),
( ''UFC'', ''09830'', ''UNIVERSITY FAMILY CARE - ADVANTAGE (UAHP)'', ''Professional''),
( ''ABHFL'', ''128FL'', ''AETNA BETTER HEALTH - FLORIDA'', ''Professional''),
( ''ABHKS'', ''128KS'', ''AETNA BETTER HEALTH KANSAS'', ''Professional''),
( ''ABHKY'', ''128KY'', ''AETNA BETTER HEALTH - KENTUCKY'', ''Professional''),
( ''ABHLA'', ''128LA'', ''AETNA BETTER HEALTH - LOUISIANA'', ''Professional''),
( ''ABHMD'', ''128MD'', ''AETNA BETTER HEALTH - MARYLAND'', ''Professional''),
( ''ABHMI'', ''128MI'', ''AETNA BETTER HEALTH - MICHIGAN'', ''Professional''),
( ''ABHVA'', ''128VA'', ''AETNA BETTER HEALTH - VIRGINIA'', ''Professional''),
( ''ABHWV'', ''128WV'', ''AETNA BETTER HEALTH - WEST VIRGINIA'', ''Professional''),
( ''973MA'', ''973MA'', ''TRIPLE-S MEDICARE ADVANTAGE (AHM)'', ''Professional''),
( ''00516'', ''ABRI1'', ''MOLINA HEALTHCARE OF WISCONSIN'', ''Professional''),
( ''BCGAC'', ''BC101'', ''BLUE CROSS BLUE SHIELD GEORGIA (ANTHEM) - INST'', ''Institutional''),
( ''401OS'', ''BC210'', ''BLUE CROSS BLUE SHIELD MICHIGAN - INST'', ''Institutional''),
( ''NYBLS'', ''BC303'', ''EMPIRE BLUE CROSS BLUE SHIELD NEW YORK - INST'', ''Institutional''),
( ''401OS'', ''BC305'', ''BLUE CROSS CENTRAL NEW YORK - INST'', ''Institutional''),
( ''401OS'', ''BC390'', ''BLUE CROSS BLUE SHIELD TENNESSEE INST'', ''Institutional''),
( ''401OS'', ''BC590'', ''BLUE CROSS BLUE SHIELD FLORIDA - INST'', ''Institutional''),
( ''TXBLS'', ''BC980'', ''BLUE CROSS BLUE SHIELD TEXAS - INST'', ''Institutional''),
( ''401OS'', ''BCCIL'', ''BLUE CROSS COMMUNITY ILLINOIS'', ''Professional''),
( ''401OS'', ''BCCMI'', ''BLUE CROSS COMPLETE MICHIGAN - PROF'', ''Professional''),
( ''BOONA'', ''BOONG'', ''BOON GROUP'', ''Professional''),
( ''CBAR1'', ''BS020'', ''BLUE CROSS BLUE SHIELD ARKANSAS INST'', ''Institutional''),
( ''BCHIC'', ''BS115'', ''BLUE SHIELD HAWAII (HMSA)'', ''Professional''),
( ''MS392'', ''BS230'', ''BLUE CROSS BLUE SHIELD MISSISSIPPI (BL)'', ''Professional''),
( ''401OS'', ''BS390'', ''BLUE CROSS BLUE SHIELD TENNESSEE'', ''Professional''),
( ''CBAR1'', ''BS520'', ''BLUE CROSS BLUE SHIELD ARKANSAS'', ''Professional''),
( ''401OS'', ''BS590'', ''BLUE CROSS BLUE SHIELD FLORIDA'', ''Professional''),
( ''401OS'', ''BS660'', ''BLUE CROSS BLUE SHIELD KENTUCKY (ANTHEM)'', ''Professional''),
( ''401OS'', ''BS710'', ''BLUE SHIELD MICHIGAN - PROF'', ''Professional''),
( ''00800'', ''BS800'', ''BLUE SHIELD NORTHEASTERN NEW YORK'', ''Professional''),
( ''SB801'', ''BS801'', ''BLUE SHIELD NEW YORK WESTERN - BUFFALO'', ''Professional''),
( ''NYBLS'', ''BS803'', ''EMPIRE BLUE CROSS BLUE SHIELD NEW YORK'', ''Professional''),
( ''00800'', ''BS804'', ''BLUE SHIELD NEW YORK ROCHESTER (EXCELLUS)'', ''Professional''),
( ''00800'', ''BS805'', ''EXCELLUS BCBS CENTRAL NEW YORK'', ''Professional''),
( ''00800'', ''BS806'', ''BLUE SHIELD NEW YORK UTICA WATERTOWN (EXCELLUS)'', ''Professional''),
( ''PREMA2'', ''BSAK1'', ''PREMERA BLUE CROSS BLUE SHIELD ALASKA'', ''Professional''),
( ''401OS'', ''BSIA1'', ''BLUE SHIELD IOWA'', ''Professional''),
( ''NCBLS'', ''BSNC1'', ''BLUE SHIELD NORTH CAROLINA'', ''Professional''),
( ''401OS'', ''BSOK1'', ''BLUE CROSS BLUE SHIELD OKLAHOMA'', ''Professional''),
( ''401OS'', ''BSSD1'', ''BLUE SHIELD SOUTH DAKOTA'', ''Professional''),
( ''SB910'', ''BSUT2'', ''REGENCE BCBS UTAH'', ''Professional''),
( ''401OS'', ''BSVA1'', ''BLUE CROSS BLUE SHIELD VIRGINIA (ANTHEM)'', ''Professional''),
( ''401OS'', ''BSVT1'', ''BLUE SHIELD VERMONT'', ''Professional''),
( ''401OS'', ''BSWA2'', ''BLUE SHIELD OF WASHINGTON REGENCE (PIN)'', ''Professional''),
( ''401OS'', ''BSWY1'', ''BLUE SHIELD WYOMING'', ''Professional''),
( ''401OS'', ''C1SCA'', ''BLUE SHIELD OF CALIFORNIA PROMISE HEALTH PLAN'', ''Professional''),
( ''CB186'', ''CB186'', ''BRIGHT HEALTH PLAN'', ''Professional''),
( ''CCHP9'', ''CCHP1'', ''COOK CHILDRENS HEALTH PLAN'', ''Professional''),
( ''CCHP9'', ''CCHP9'', ''COOK CHILDRENS STAR HEALTH PLAN'', ''Professional''),
( ''CDPHP'', ''CDPHP'', ''CDPHP - CAPITAL DISTRICT PHYSICIANS HEALTH PLAN'', ''Professional''),
( ''CMTWA'', ''CHPWA'', ''COMMUNITY HEALTH PLAN OF WASHINGTON'', ''Professional''),
( ''COACC'', ''COACC'', ''ACCESS BEHAVIORAL CARE'', ''Professional''),
( ''00060 - COACC'', ''COACC'', ''COLORADO ACCESS'', ''Professional''),
( ''KSRCO'', ''COKSR'', ''KAISER FOUNDATION HEALTH PLAN COLORADO'', ''Professional''),
( ''DKCAS'', ''DAK01'', ''DAKOTACARE'', ''Professional''),
( ''NCMCD'', ''DNC00'', ''MEDICAID NORTH CAROLINA'', ''Professional''),
( ''TXMCD'', ''EP916'', ''MEDICAID TEXAS EPSDT - PIN'', ''Professional''),
( ''FOREN'', ''FOREN'', ''TRICARE OVERSEAS'', ''Professional''),
( ''00325 - DAHP'', ''GACS1'', ''CARESOURCE GEORGIA'', ''Professional''),
( ''HWMLD'', ''HMA01'', ''HMA HEALTHCARE MANAGEMENT ADMINISTRATORS'', ''Professional''),
( ''HPMN'', ''HPAMN'', ''HEALTHPARTNERS MN'', ''Professional''),
( ''SX174'', ''HPSM1'', ''HEALTH PLAN OF SAN MATEO (HPSM)'', ''Professional''),
( ''00333 - SPIEH'', ''IEHP1'', ''INLAND EMPIRE HEALTH PLAN (IEHP)'', ''Professional''),
( ''00325 - DAHP'', ''INCS1'', ''CARESOURCE INDIANA'', ''Professional''),
( ''00325 - DAHP'', ''KYCS1'', ''CARESOURCE KENTUCKY'', ''Professional''),
( ''LACAR'', ''LACAR'', ''LA CARE HEALTH PLAN (CALIF)'', ''Professional''),
( ''LIFE1'', ''LIFE1'', ''OPTUM MEDICAL NETWORK / AZ, UT (FORMERLY LIFEPRINT NETWORK)'', ''Professional''),
( ''00885'', ''MAAR1'', ''MEDICARE ARKANSAS PART A'', ''Institutional''),
( ''00885'', ''MAAZ1'', ''MEDICARE ARIZONA PART A'', ''Institutional''),
( ''00885'', ''MACA1'', ''MEDICARE CALIFORNIA PART A'', ''Institutional''),
( ''00885'', ''MACO1'', ''MEDICARE COLORADO PART A'', ''Institutional''),
( ''MASHP'', ''MAHC1'', ''MEDICAL ASSOCIATES HEALTH PLAN / HEALTH CHOICES'', ''Professional''),
( ''00885'', ''MAID1'', ''MEDICARE IDAHO PART A'', ''Institutional''),
( ''00885'', ''MAIL1'', ''MEDICARE ILLINOIS PART A'', ''Institutional''),
( ''00885'', ''MAIN1'', ''MEDICARE INDIANA J8 PART A'', ''Institutional''),
( ''00885'', ''MAJ11'', ''MEDICARE HOME HEALTH HOSPICE J11 (PALMETTO)'', ''Institutional''),
( ''00885'', ''MAJ49'', ''MEDICARE JH 04911 PART A'', ''Institutional''),
( ''00885'', ''MAKY1'', ''MEDICARE KENTUCKY PART (A)'', ''Institutional''),
( ''00885'', ''MALA1'', ''MEDICARE LOUISIANA PART A'', ''Institutional''),
( ''00885'', ''MAMA1'', ''MEDICARE MASSACHUSETTS PART A'', ''Institutional''),
( ''00885'', ''MAMI1'', ''MEDICARE MICHIGAN PART A'', ''Institutional''),
( ''00885'', ''MAMO1'', ''MEDICARE MISSOURI J5 PART A'', ''Institutional''),
( ''00885'', ''MANC1'', ''MEDICARE NORTH CAROLINA PART A'', ''Institutional''),
( ''00885'', ''MAND1'', ''MEDICARE NORTH DAKOTA PART A'', ''Institutional''),
( ''00885'', ''MANE1'', ''MEDICARE NEBRASKA J5 PART A'', ''Institutional''),
( ''00885'', ''MAOK1'', ''MEDICARE OKLAHOMA PART A'', ''Institutional''),
( ''00885'', ''MAPA1'', ''MEDICARE PENNSYLVANIA PART A'', ''Institutional''),
( ''00885'', ''MASC1'', ''MEDICARE SOUTH CAROLINA PART A'', ''Institutional''),
( ''00885'', ''MATN1'', ''MEDICARE TENNESSEE PART A'', ''Institutional''),
( ''00885'', ''MATX1'', ''MEDICARE TEXAS PART A AND INDIAN HEALTH SERVICES'', ''Institutional''),
( ''00885'', ''MAVA1'', ''MEDICARE VIRGINIA PART A'', ''Institutional''),
( ''00885'', ''MAWI1'', ''MEDICARE WISCONSIN PART A'', ''Institutional''),
( ''00885'', ''MAWV1'', ''MEDICARE WEST VIRGINIA PART A'', ''Institutional''),
( ''00885'', ''MB849'', ''MEDICARE IOWA'', ''Professional''),
( ''00885'', ''MBAK2'', ''MEDICARE ALASKA'', ''Professional''),
( ''00885'', ''MBAL2'', ''MEDICARE ALABAMA'', ''Professional''),
( ''00885'', ''MBAR2'', ''MEDICARE ARKANSAS'', ''Professional''),
( ''00885'', ''MBAZ2'', ''MEDICARE ARIZONA'', ''Professional''),
( ''00885'', ''MBCA1'', ''MEDICARE CALIFORNIA NORTHERN REGION'', ''Professional''),
( ''00885'', ''MBCA2'', ''MEDICARE CALIFORNIA SOUTHERN REG'', ''Professional''),
( ''00885'', ''MBCO2'', ''MEDICARE COLORADO'', ''Professional''),
( ''00885'', ''MBCT2'', ''MEDICARE CONNECTICUT'', ''Professional''),
( ''00885'', ''MBDC2'', ''MEDICARE DC METRO'', ''Professional''),
( ''00885'', ''MBDE2'', ''MEDICARE DELAWARE'', ''Professional''),
( ''00885'', ''MBFL2'', ''MEDICARE FLORIDA'', ''Professional''),
( ''00885'', ''MBGA2'', ''MEDICARE GEORGIA'', ''Professional''),
( ''00885'', ''MBHI2'', ''MEDICARE HAWAII'', ''Professional''),
( ''00885'', ''MBID2'', ''MEDICARE IDAHO'', ''Professional''),
( ''00885'', ''MBIL2'', ''MEDICARE ILLINOIS'', ''Professional''),
( ''00885'', ''MBIN2'', ''MEDICARE INDIANA'', ''Professional''),
( ''00885'', ''MBKS2'', ''MEDICARE KANSAS'', ''Professional''),
( ''00885'', ''MBKY2'', ''MEDICARE KENTUCKY'', ''Professional''),
( ''00885'', ''MBLA2'', ''MEDICARE LOUISIANA'', ''Professional''),
( ''00885'', ''MBMA2'', ''MEDICARE MASSACHUSETTS'', ''Professional''),
( ''00885'', ''MBMD2'', ''MEDICARE MARYLAND'', ''Professional''),
( ''00885'', ''MBME2'', ''MEDICARE MAINE'', ''Professional''),
( ''00885'', ''MBMI2'', ''MEDICARE MICHIGAN'', ''Professional''),
( ''00885'', ''MBMN2'', ''MEDICARE MINNESOTA'', ''Professional''),
( ''00885'', ''MBMO2'', ''MEDICARE MISSOURI EASTERN'', ''Professional''),
( ''00885'', ''MBMS2'', ''MEDICARE MISSISSIPPI'', ''Professional''),
( ''00885'', ''MBMT2'', ''MEDICARE MONTANA'', ''Professional''),
( ''00885'', ''MBNC2'', ''MEDICARE NORTH CAROLINA'', ''Professional''),
( ''00885'', ''MBND2'', ''MEDICARE NORTH DAKOTA'', ''Professional''),
( ''00885'', ''MBNE2'', ''MEDICARE NEBRASKA'', ''Professional''),
( ''00885'', ''MBNH2'', ''MEDICARE NEW HAMPSHIRE'', ''Professional''),
( ''00885'', ''MBNJ2'', ''MEDICARE NEW JERSEY'', ''Professional''),
( ''00885'', ''MBNM2'', ''MEDICARE NEW MEXICO'', ''Professional''),
( ''00885'', ''MBNV2'', ''MEDICARE NEVADA'', ''Professional''),
( ''00885'', ''MBNY2'', ''MEDICARE NEW YORK EMPIRE / DOWNSTATE'', ''Professional''),
( ''00885'', ''MBNY3'', ''MEDICARE NEW YORK UPSTATE'', ''Professional''),
( ''00885'', ''MBNY4'', ''MEDICARE NEW YORK QUEENS COUNTY ONLY'', ''Professional''),
( ''00885'', ''MBOH2'', ''MEDICARE OHIO'', ''Professional''),
( ''00885'', ''MBOK2'', ''MEDICARE OKLAHOMA'', ''Professional''),
( ''00885'', ''MBOR2'', ''MEDICARE OREGON'', ''Professional''),
( ''00885'', ''MBPA2'', ''MEDICARE PENNSYLVANIA'', ''Professional''),
( ''00885'', ''MBPR2'', ''MEDICARE PUERTO RICO'', ''Professional''),
( ''00885'', ''MBRI2'', ''MEDICARE RHODE ISLAND'', ''Professional''),
( ''00885'', ''MBSC2'', ''MEDICARE SOUTH CAROLINA'', ''Professional''),
( ''00885'', ''MBSD2'', ''MEDICARE SOUTH DAKOTA'', ''Professional''),
( ''00885'', ''MBTN2'', ''MEDICARE TENNESSEE'', ''Professional''),
( ''00885'', ''MBTX2'', ''MEDICARE TEXAS PART B'', ''Professional''),
( ''00885'', ''MBUT2'', ''MEDICARE UTAH'', ''Professional''),
( ''00885'', ''MBVA2'', ''MEDICARE VIRGINIA PART B'', ''Professional''),
( ''00885'', ''MBVT2'', ''MEDICARE VERMONT'', ''Professional''),
( ''00885'', ''MBWA2'', ''MEDICARE WASHINGTON'', ''Professional''),
( ''00885'', ''MBWI2'', ''MEDICARE WISCONSIN'', ''Professional''),
( ''00885'', ''MBWV2'', ''MEDICARE WEST VIRGINIA'', ''Professional''),
( ''00885'', ''MBWY2'', ''MEDICARE WYOMING'', ''Professional''),
( ''TNMCD'', ''MC390'', ''TENNCARE MEDICAID'', ''Professional''),
( ''CAMDCAL'', ''MCCA0'', ''MEDI-CAL CALIFORNIA 04 (OP) INST'', ''Institutional''),
( ''AKMCD'', ''MCDAK'', ''MEDICAID ALASKA'', ''Professional''),
( ''ARMCD'', ''MCDAR'', ''MEDICAID ARKANSAS'', ''Professional''),
( ''AZMCD'', ''MCDAZ'', ''MEDICAID ARIZONA (AHCCCS)'', ''Professional''),
( ''CAMDCAL'', ''MCDCA'', ''MEDI-CAL CALIFORNIA'', ''Professional''),
( ''COMCD'', ''MCDCO'', ''MEDICAID COLORADO'', ''Professional''),
( ''CTMCD'', ''MCDCT'', ''MEDICAID CONNECTICUT'', ''Professional''),
( ''DCMCD'', ''MCDDC'', ''MEDICAID DC - DEPT OF HEALTHCARE FINANCE'', ''Professional''),
( ''DWMCD'', ''MCDDE'', ''MEDICAID DELAWARE'', ''Professional''),
( ''IDMCD'', ''MCDID'', ''MEDICAID IDAHO'', ''Professional''),
( ''ILMCD'', ''MCDIL'', ''MEDICAID ILLINOIS'', ''Professional''),
( ''INMCD'', ''MCDIN'', ''MEDICAID INDIANA'', ''Professional''),
( ''KSMCD'', ''MCDKS'', ''MEDICAID KANSAS'', ''Professional''),
( ''KYMCD'', ''MCDKY'', ''MEDICAID KENTUCKY'', ''Professional''),
( ''LAMCD'', ''MCDLA'', ''MEDICAID LOUISIANA'', ''Professional''),
( ''MAMCD'', ''MCDMA'', ''MEDICAID MASSACHUSETTS'', ''Professional''),
( ''MDMCD'', ''MCDMD'', ''MEDICAID MARYLAND'', ''Professional''),
( ''MEMCD'', ''MCDME'', ''MEDICAID MAINE'', ''Professional''),
( ''MIMCD'', ''MCDMI'', ''MEDICAID MICHIGAN'', ''Professional''),
( ''MNMCD'', ''MCDMN'', ''MEDICAID MINNESOTA'', ''Professional''),
( ''MOMCD'', ''MCDMO'', ''MEDICAID MISSOURI'', ''Professional''),
( ''AID59'', ''MCDND'', ''MEDICAID NORTH DAKOTA'', ''Professional''),
( ''NEBMD'', ''MCDNE'', ''MEDICAID NEBRASKA'', ''Professional''),
( ''NHMCD'', ''MCDNH'', ''MEDICAID NEW HAMPSHIRE'', ''Professional''),
( ''NJMCD'', ''MCDNJ'', ''MEDICAID NEW JERSEY'', ''Professional''),
( ''NMMCD'', ''MCDNM'', ''MEDICAID NEW MEXICO'', ''Professional''),
( ''NVMCD'', ''MCDNV'', ''MEDICAID NEVADA'', ''Professional''),
( ''NYMCD'', ''MCDNY'', ''MEDICAID NEW YORK'', ''Professional''),
( ''OHMCD'', ''MCDOH'', ''MEDICAID OHIO'', ''Professional''),
( ''OKMCD'', ''MCDOK'', ''MEDICAID OKLAHOMA'', ''Professional''),
( ''ORMCD'', ''MCDOR'', ''MEDICAID OREGON'', ''Professional''),
( ''PAMCD'', ''MCDPA'', ''MEDICAID PENNSYLVANIA'', ''Professional''),
( ''00619'', ''MCDSC'', ''MEDICAID SOUTH CAROLINA'', ''Professional''),
( ''AID28'', ''MCDSD'', ''MEDICAID SOUTH DAKOTA'', ''Professional''),
( ''VAMCD'', ''MCDVA'', ''MEDICAID VIRGINIA'', ''Professional''),
( ''VTVTMCD'', ''MCDVT'', ''MEDICAID VERMONT'', ''Professional''),
( ''WAMCD'', ''MCDWA'', ''MEDICAID WASHINGTON'', ''Professional''),
( ''WIMCD'', ''MCDWI'', ''MEDICAID WISCONSIN'', ''Professional''),
( ''WVMCD'', ''MCDWV'', ''MEDICAID WEST VIRGINIA'', ''Professional''),
( ''MGDCA'', ''MCS03'', ''MANAGED CARE SYSTEMS'', ''Professional''),
( ''MMMFL'', ''MMMFL'', ''MMM OF FLORIDA'', ''Professional''),
( ''MNMCD'', ''MNATP'', ''MEDICAID MINNESOTA (FOR ATYPICAL USE ONLY)'', ''Professional''),
( ''MOMCD'', ''MODME'', ''MEDICAID MISSOURI DME'', ''Professional''),
( ''MRTPH'', ''MPHC1'', ''MARTINS POINT HEALTH CARE ( MPHC)'', ''Professional''),
( ''00885'', ''MR710'', ''MEDICARE ADVANTAGE MICHIGAN / PLUS BLUE - PROF'', ''Professional''),
( ''86052'', ''MRC01'', ''MERCY CARE PLAN ARIZONA'', ''Professional''),
( ''NCMCD'', ''NCLME'', ''NORTH CAROLINA LME REFERRALS - MEDICAID'', ''Professional''),
( ''OKMCD'', ''OKFOS'', ''MEDICAID OKLAHOMA FOSTER CARE [FOR ATYPICAL USE ONLY]'', ''Professional''),
( ''PARMT'', ''PARHC'', ''PARAMOUNT HEALTH CARE'', ''Professional''),
( ''00343 - SPPHP'', ''PHPCA'', ''PARTNERSHIP HEALTH PLAN CALIFORNIA'', ''Professional''),
( ''BCPRC'', ''PR973'', ''TRIPLE-S (BCBS PUERTO RICO)'', ''Professional''),
( ''00885'', ''RH280'', ''MEDICARE WPS J5 NATIONAL PART A 05901'', ''Institutional''),
( ''RMHP'', ''RMHMO'', ''ROCKY MOUNTAIN HEALTH PLANS'', ''Professional''),
( ''400'', ''SC400'', ''BCBSSC STATE EMPLOYEES HEALTH PLAN'', ''Professional''),
( ''400'', ''SC401'', ''BLUE CROSS BLUE SHIELD SOUTH CAROLINA'', ''Professional''),
( ''400'', ''SC402'', ''BCBSSC FEDERAL EMPLOYEES PLAN FEP'', ''Professional''),
( ''400'', ''SC481'', ''BCBSSC PREFERRED BLUE'', ''Professional''),
( ''400'', ''SC922'', ''BLUECHOICE HEALTH PLAN (BCBSSC)'', ''Professional''),
( ''00350'', ''SCAN1'', ''SCAN HEALTH PLAN CALIF'', ''Professional''),
( ''SIMPI'', ''SMPLY'', ''SIMPLY HEALTHCARE'', ''Professional''),
( ''00082'', ''STMSS'', ''MISSISSIPPI STATE &AMP; TEACHERS (ZZ)'', ''Professional''),
( ''SX105'', ''SX105'', ''DMBA - DESERET MUTUAL BENEFITS ASSOCIATION'', ''Professional''),
( ''SX106'', ''SX106'', ''PUBLIC EMPLOYEES HEALTH PROGRAMS (PEHP)'', ''Professional''),
( ''SX107'', ''SX107'', ''SELECTHEALTH- IHC (UHIN)'', ''Professional''),
( ''00227 - MLNUT'', ''SX109'', ''MOLINA HEALTHCARE OF UTAH'', ''Professional''),
( ''TDFIC'', ''TDFIC'', ''TRICARE FOR LIFE'', ''Professional''),
( ''614'', ''TREST'', ''TRICARE EAST'', ''Professional''),
( ''TNALF'', ''TRP1E'', ''TRANSAMERICA LIFE INSURANCE COMPANY'', ''Professional''),
( ''SB910'', ''UTFEP'', ''REGENCE BCBS UTAH FEDERAL'', ''Professional''),
( ''00334'', ''VHP01'', ''VALLEY HEALTH PLAN (COMMERCIAL)'', ''Professional''),
( ''OHMCD'', ''WRAP1'', ''MEDICAID OHIO - WRAP AROUND'', ''Professional''),
( ''00325 - DAHP'', ''WVCS1'', ''CARESOURCE WEST VIRGINIA'', ''Professional''),
( null, null, null, null)
) as source (Payer_Name, eMEDIX_Payer_Code, PracticeInsights_Payer_Code, Type);
  return;
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Get_ELGREQ_RestrictToDayPeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Get_ELGREQ_RestrictToDayPeriod]
(
)
RETURNS [smallint]
AS
BEGIN
	DECLARE @data [smallint],
		@eRxMessageTypeUid [uniqueidentifier] = ''6B18C334-E4A6-4F82-A831-1AAA6CF6009E''	-- ELGREQ

	SELECT @data = [RestrictTo]
	FROM [ListeRxMessageType]
	WHERE [eRxMessageTypeUid] = @eRxMessageTypeUid

	IF @data IS NULL
	BEGIN
		SET @data = 3
	END
	RETURN @data
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GET_InsuranceTotalBalance]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GET_InsuranceTotalBalance]
 (	
	 @superbillUid UNIQUEIDENTIFIER
 )

RETURNS Money AS
BEGIN
		DECLARE	@balance Money
		SELECT  @balance=AssignedLiabilityBalance
		FROM AR_ViewSuperbillAggregate
			WHERE SuperbillUid = @superbillUid			 

	RETURN @balance
END	

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountPeriodEligibilityDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetAccountPeriodEligibilityDate] (@accountuid uniqueidentifier, @date datetime) 
	RETURNS SMALLINT 
AS
BEGIN

	DECLARE	@accountPeriodUid UNIQUEIDENTIFIER
	DECLARE @eligibilityStatus SMALLINT

	SELECT @accountPeriodUid = dbo.GetAccountPeriod(@accountuid,@date)
	IF (@accountPeriodUid!=NULL)
		SELECT TOP 1 @eligibilityStatus = EligibilityStatus FROM ViewAccountPeriodEligibilityDate
			WHERE AccountPeriodUid = @accountPeriodUid

	RETURN @eligibilityStatus
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyMostRecentCollectionChargeAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetAccountResponsiblePartyMostRecentCollectionChargeAmount]
(
	@accountResponsiblePartyUid uniqueidentifier
)
RETURNS 
	money
AS

BEGIN
	DECLARE @mostRecentCollectionChargeAmount money
	SELECT TOP 1 @mostRecentCollectionChargeAmount = LD.Amount 
		FROM SuperbillProcedure SBP WITH (NOLOCK)
		INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid
		LEFT JOIN AR_Ledger L_VOID WITH (NOLOCK) ON L.LedgerUid = L_VOID.VoidLedgerUid
		INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid = ARB.ARBatchUid
		INNER JOIN Superbill SB WITH (NOLOCK) ON SBP.SuperbillUid = SB.SuperbillUid
		INNER JOIN Account AC WITH (NOLOCK) ON SB.AccountUid = AC.AccountUid
	WHERE SBP.procedureuid = (SELECT distinct feedefaultprocedureuid FROM collectionstatusglobal WITH (NOLOCK))
		AND AC.AccountResponsiblePartyUid = @accountResponsiblePartyUid
		AND (L.VoidLedgerUid IS NULL AND L_VOID.LedgerUid IS NULL) -- no voids
		AND LD.IsCredit = 0 -- non reversed charge
	ORDER BY ARB.GLDate DESC

	RETURN isnull(@mostRecentCollectionChargeAmount, 0)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyMostRecentPaymentAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetAccountResponsiblePartyMostRecentPaymentAmount]
(
	@AccountResponsiblePartyUid UNIQUEIDENTIFIER
)
RETURNS 
	MONEY
AS 
BEGIN
	DECLARE @MostRecentPaymentAmount MONEY
	SELECT TOP 1 @MostRecentPaymentAmount = 0 - LD.Amount 
		FROM AR_LedgerDetail LD
			INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
			LEFT JOIN AR_Ledger voidL ON L.LedgerUid = voidL.VoidLedgerUid
		WHERE L.EntryType = 0 AND LD.IsCredit = 1
			AND voidL.LedgerUid IS NULL AND L.VoidLedgerUid IS NULL
			AND LD.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
		ORDER BY LD.CreatedDateTime DESC -- USE Create Date not Posting Date

	RETURN ISNULL(@MostRecentPaymentAmount, 0)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyMostRecentPaymentDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetAccountResponsiblePartyMostRecentPaymentDate]
(
	@AccountResponsiblePartyUid UNIQUEIDENTIFIER
)
RETURNS 
	DATETIME
AS
BEGIN
	DECLARE @MostRecentDate DATETIME 
	SELECT TOP 1 @MostRecentDate = LD.CreatedDateTime
		FROM AR_LedgerDetail LD
			INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
			LEFT JOIN AR_Ledger voidL ON L.LedgerUid = voidL.VoidLedgerUid
		WHERE L.EntryType = 0 AND LD.IsCredit = 1
			AND voidL.LedgerUid IS NULL AND L.VoidLedgerUid IS NULL -- catch both sides of voids and discard
			AND LD.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
		ORDER BY LD.CreatedDateTime DESC -- USE Create Date not Posting Date

	RETURN @MostRecentDate
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyPaymentTotalAllByDateRange]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetAccountResponsiblePartyPaymentTotalAllByDateRange]
(
	@AccountResponsiblePartyUid UNIQUEIDENTIFIER,
	@FromDate DATE,
	@ToDate DATE
)
RETURNS 
	MONEY
AS
BEGIN
	DECLARE @TotalPayments MONEY
	SELECT @TotalPayments = SUM(LD_DebitSide.Amount)
		FROM AR_LedgerDetail LD_DebitSide
			INNER JOIN AR_LedgerDetail LD_CreditSide ON LD_DebitSide.LedgerUid = LD_CreditSide.LedgerUid
			INNER JOIN AR_Ledger L ON LD_DebitSide.LedgerUid = L.LedgerUid
			LEFT JOIN AR_Ledger L_VOID ON L.LedgerUid = L_VOID.VoidLedgerUid
			INNER JOIN SuperbillProcedure SBP ON LD_CreditSide.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
			INNER JOIN Account AC ON SB.AccountUid = AC.AccountUid
		WHERE L.EntryType = 2 AND LD_DebitSide.IsCredit = 0 -- Deposit Side of the Distribution
			AND LD_CreditSide.IsCredit = 1
			AND LD_CreditSide.LiabilityOwner = 0 -- bug 17442 and 21991 limit total to payments on patient liabilities only
			AND (L.VoidLedgerUid IS NULL AND L_VOID.LedgerUid IS NULL) -- not voided or voiding
			AND AC.AccountResponsiblePartyUid = @AccountResponsiblePartyUid -- match on the SB side
			AND L.CreatedDateTime BETWEEN @FromDate AND @ToDate  -- USE Create Date not Posting Date

	RETURN isnull(@TotalPayments, 0)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAddress]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAddress](@address xml(CONTENT dbo.Address)) RETURNS VARCHAR(255) AS
BEGIN
	IF @address IS NULL
		RETURN NULL
		
	DECLARE @address1 VARCHAR(100)
	DECLARE @address2 VARCHAR(100)
	DECLARE @a VARCHAR(255)
	
	SET @address1 = @address.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
	SET @address2 = @address.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
	
	IF RTRIM(ISNULL(@address1, '''')) <> ''''
		SET @a = @address1
		
	IF RTRIM(ISNULL(@address2, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@a, '''')) <> ''''
			SET @a = @a + '' ''
		
		SET @a = @a + @address2
	END
		
	RETURN @a
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCityStateZip]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetCityStateZip](@address xml(CONTENT dbo.Address)) RETURNS VARCHAR(255) AS
BEGIN
	IF @address IS NULL
		RETURN NULL
		
	DECLARE @city VARCHAR(100)
	DECLARE @state VARCHAR(100)
	DECLARE @zip VARCHAR(100)
	DECLARE @country VARCHAR(100)
	DECLARE @csz VARCHAR(255)
	
	SET @city = @address.value(''(/Address/City)[1]'', ''VARCHAR(100)'')
	SET @state = @address.value(''(/Address/State)[1]'', ''VARCHAR(100)'')
	SET @zip = @address.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
	SET @country = @address.value(''(/Address/Country)[1]'', ''VARCHAR(100)'')
	
	IF RTRIM(ISNULL(@city, '''')) <> ''''
		SET @csz = @city
		
	IF RTRIM(ISNULL(@state, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@csz, '''')) <> ''''
			SET @csz = @csz + '', ''
		
		SET @csz = @csz + @state
	END
	
	IF RTRIM(ISNULL(@zip, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@csz, '''')) <> ''''
			SET @csz = @csz + ''  ''
		
		SET @csz = @csz + @zip
	END
	
	IF RTRIM(ISNULL(@country, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@csz, '''')) <> ''''
			SET @csz = @csz + '' ''
			
		SET @csz = @csz + @country
	END
	
	RETURN @csz
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAddressCityStateZip]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAddressCityStateZip](@address xml(CONTENT dbo.Address)) RETURNS VARCHAR(255) AS
BEGIN
	IF @address IS NULL
		RETURN NULL
		
	DECLARE @a VARCHAR(100)
	DECLARE @address2 VARCHAR(100)
	DECLARE @csz VARCHAR(255)
	DECLARE @acsz VARCHAR(512)	
	
	SET @a = dbo.GetAddress(@address)
	SET @csz = dbo.GetCityStateZip(@address)
	
	IF RTRIM(ISNULL(@a, '''')) <> ''''
		SET @acsz = @a
			
	IF RTRIM(ISNULL(@csz, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@acsz, '''')) <> ''''
			SET @acsz = @acsz + '' ''
		
		SET @acsz = @acsz + @csz
	END
		
	RETURN @acsz
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAHFSClassificationID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetAHFSClassificationID] (@medid INT, @mnid INT)
RETURNS VARCHAR(6) AS
BEGIN
   DECLARE @classid VARCHAR(6)

   IF (ISNULL(@mnid, 0) > 0)
   BEGIN
      SELECT TOP 1 @classid = cls.classid
      FROM dbo.NDD_SearchDispensable dis
      INNER JOIN dbo.NDD_RAHFSGC1_GCNSEQNO_LINK rel ON rel.IsDelete = 0 AND rel.GCN_SEQNO = dis.gcnseqno
      INNER JOIN dbo.NDD_ViewClassificationAHFS cls ON cls.IsDelete = 0 AND cls.AHFS8 = rel.AHFS8
      WHERE dis.IsDelete = 0
        AND dis.mnid = @mnid
      ORDER BY rel.AHFS_REL
   END
   ELSE
   BEGIN
      SELECT TOP 1 @classid = cls.classid
      FROM dbo.NDD_SearchDispensable dis
      INNER JOIN dbo.NDD_RAHFSGC1_GCNSEQNO_LINK rel ON rel.IsDelete = 0 AND rel.GCN_SEQNO = dis.gcnseqno
      INNER JOIN dbo.NDD_ViewClassificationAHFS cls ON cls.IsDelete = 0 AND cls.AHFS8 = rel.AHFS8
      WHERE dis.IsDelete = 0
        AND dis.medid = @medid
      ORDER BY rel.AHFS_REL
   END
   RETURN @classid
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBatchNamesByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetBatchNamesByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	select @retVal = stuff( (select distinct '','' + arb.Name
								FROM AR_Ledger arl with (nolock) 
										inner join ARBatch arb with (nolock) on arl.ARBatchUid = arb.ARBatchUid
								where arl.TransactionUid = @transactionUid
								for xml path('''')), 1, 1, '''' )
	return @retVal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBatchStateByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetBatchStateByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	SELECT @retVal = stuff( (select DISTINCT '','' +
									CASE WHEN arb.IsClosed = 1 THEN ''Complete''
										 WHEN arb.IsLocked = 1 THEN ''Locked''
										 ELSE						''Open'' END
							 FROM AR_Ledger arl with (nolock)
									INNER JOIN ARBatch arb with (nolock) on arl.ARBatchUid = arb.ARBatchUid
							 WHERE arl.TransactionUid = @transactionUid
							 FOR XML PATH('''')), 1, 1, '''')
	
	return @retVal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBatchUidsByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetBatchUidsByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	select @retVal = stuff( (select distinct '','' + convert(varchar(36),arl.arbatchUid)
								FROM AR_Ledger arl with (nolock) 
								where arl.TransactionUid = @transactionUid
								for xml path('''')), 1, 1, '''' )
	return @retVal
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBestBloodPressure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetBestBloodPressure](@patientUid UNIQUEIDENTIFIER, @startDate DATE, @endDate DATE)
	RETURNS @PatientBloodPressure TABLE 
	(
		PatientUid UNIQUEIDENTIFIER PRIMARY KEY,
		BloodPressureDate DATE,
		BloodPressure VARCHAR(8),
		Systolic DECIMAL,
		Diastolic DECIMAL
	)
AS
BEGIN
			INSERT			@PatientBloodPressure
			SELECT TOP 1	@patientUid, CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS BloodPressureDate,
							CAST(CAST(ov.MetricValue1 AS INT) AS VARCHAR(3)) + ''/'' + CAST(CAST(ov.MetricValue2 AS INT) AS VARCHAR(3)), 
							ov.MetricValue1 AS Systolic, ov.MetricValue2 AS Diastolic
			FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
			WHERE			ov.ObservationItemUid = ''00000000-0000-0000-7777-100000000073'' AND
							oo.PatientUid = @patientUid AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL) 
			ORDER BY		CASE WHEN ov.MetricValue1 >= 90 OR ov.MetricValue2 >= 140 THEN 2000 + ov.MetricValue1 + ov.MetricValue2 ELSE ov.MetricValue1 + ov.MetricValue2 END, -- Make sure over 90 or 140 is higher than any that isn''t
							COALESCE(oo.ResultDate, oo.PerformDate) DESC
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getCreditCardName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getCreditCardName]
(@displayOrder INT)  
RETURNS Varchar(100) AS  
BEGIN 
	Declare @name varchar(100)
	Declare @cntCrCard int
	Set @name=''''
	Select @cntCrCard=count(*) From listpaymenttype Where InternalCardType IS NOT NULL
	IF (@cntCrCard >=@displayOrder)
	BEGIN
--	Select @name = Name from ListCreditCard Where DisplayOrder = @displayOrder
		IF @displayOrder=1
			Select top  1  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=2
			Select top  2  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=3
			Select top  3  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=4
			Select top  4  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=5
			Select top  5  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=6
			Select top  6  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
	END

	Return @name
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCurrentPatientHistoryQuestionAnswerName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetCurrentPatientHistoryQuestionAnswerName](@patientUid UNIQUEIDENTIFIER, @questionUid UNIQUEIDENTIFIER, @date DATE) RETURNS VARCHAR(255) AS
BEGIN
	DECLARE @answerName VARCHAR(255)
	
	SELECT TOP 1	@answerName = vph.AnswerName
	FROM			ViewPatientHistory vph
	WHERE			vph.QuestionUid = @questionUid AND
					(vph.ActiveDate <= @date OR @date IS NULL) AND
					vph.PatientUid = @patientUid					
	ORDER BY		vph.ActiveDate DESC

	RETURN @answerName
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCustomerNumber]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetCustomerNumber] () RETURNS VARCHAR(10) AS
BEGIN
	-- Declare the return variable here
	DECLARE @xml XML
	DECLARE @customerNumber VARCHAR(10)

	SELECT @xml = XmlValue FROM ListProductParameter WHERE ParameterName = ''RegistrationCustomerLicense''
	IF @xml IS NULL
		RETURN NULL
	
	SELECT @customerNumber = @xml.value(''(/License/Customer/@number)[1]'', ''VARCHAR(10)'')

	RETURN @customerNumber
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDepositNamesByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetDepositNamesByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	SELECT @retVal = stuff(( select DISTINCT '','' + d.ReferenceNumber
							FROM AR_Ledger arl with (nolock) 
									INNER JOIN AR_LedgerDetail ld with (nolock) on arl.TransactionUid = @transactionUid 
																					AND arl.LedgerUid = ld.LedgerUid
									INNER JOIN Deposit d with (nolock) on ld.DepositUid = d.DepositUid
							FOR XML PATH('''')), 1, 1, '''')
	return @retVal
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetDiagnosis] (@visitProcedureUid uniqueidentifier) RETURNS VARCHAR(100) AS
	BEGIN
		DECLARE @diagnosis varchar(100)
		DECLARE @diagCode varchar(25)
		
		DECLARE cur CURSOR FOR 
			SELECT		vd.Code
			FROM		VisitProcedureDiagnosis vspd INNER JOIN VisitDiagnosis vd ON vspd.VisitDiagnosisUid = vd.VisitDiagnosisUid
			WHERE		vspd.VisitProcedureUid = @visitProcedureUid
			ORDER BY	vspd.DisplayOrder
			
		OPEN cur

		FETCH NEXT FROM cur INTO @diagCode
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF NOT @diagnosis IS NULL
				SET @diagnosis = @diagnosis + '',''
			ELSE
				SET @diagnosis = ''''
				
				SET @diagnosis = @diagnosis + @diagCode

			FETCH NEXT FROM cur INTO @diagCode
		END
		
		CLOSE cur
		DEALLOCATE cur
			
	
	RETURN @diagnosis
	
	END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosisByMedication]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetDiagnosisByMedication] (@MedicationSigUid uniqueidentifier) RETURNS VARCHAR(max) AS
	BEGIN
		DECLARE @diagnosis varchar(max)
		DECLARE @diagCode varchar(max)
		--set @MedicationSigUid = ''BDD5454D-EA16-459F-99CD-2A640E939710''
		DECLARE cur CURSOR FOR 
			SELECT		coalesce(rdm.Code10,rdm.Code9) + '' '' + ISNULL(rdm.CodeDescription,'''')
			FROM		RelMedicationDiagnosis rdm --INNER JOIN VisitDiagnosis vd ON rvm.VisitDiagnosisUid = vd.VisitDiagnosisUid
			WHERE		rdm.MedicationSIGUid = @MedicationSigUid
			ORDER BY	rdm.DisplayOrder
			
		OPEN cur

		FETCH NEXT FROM cur INTO @diagCode
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF NOT @diagnosis IS NULL
				SET @diagnosis = @diagnosis + '', ''
			ELSE
				SET @diagnosis = ''''
				
				SET @diagnosis = @diagnosis + @diagCode

			FETCH NEXT FROM cur INTO @diagCode
		END
		
		CLOSE cur
		DEALLOCATE cur
		--print @diagnosis	
	
	RETURN @diagnosis
	
	END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosisCodeAndName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetDiagnosisCodeAndName]
(
	@code9 VARCHAR(25),
	@code10 VARCHAR(25),
	@codeDescription VARCHAR(255)
)
RETURNS VARCHAR(512)
AS
BEGIN
	DECLARE @code VARCHAR(51)


	IF @code9 IS NOT NULL OR RTRIM(@code9) <> ''''
		SET @code = @code9
	IF @code10 IS NOT NULL OR RTRIM(@code10) <> ''''
		SET @code = @code10 + ''-'' + @code9

	RETURN ''('' + @code + '') '' + @codeDescription
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosisCodeList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetDiagnosisCodeList](@superbillProcedureUid uniqueidentifier) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @diagnosisCodeList VARCHAR(MAX);

	WITH cteSuperbillProcedureDiagnosis AS
	(
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer1 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer2 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer3 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer4 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer5 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer6 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer7 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer8 = SD.DisplayOrder
	), cteSuperbillProcedureInfo AS
	(
	SELECT TOP 10000 VSPD.SuperbillProcedureUid, VSPD.DisplayOrder, -- TOP required for order by
				CASE WHEN LEN(ISNULL(SD.Code10,''''))>0 THEN SD.Code10 ELSE SD.Code9 END AS Code
				FROM cteSuperbillProcedureDiagnosis VSPD
					INNER JOIN SuperbillDiagnosis SD ON VSPD.SuperbillDiagnosisUid = SD.SuperbillDiagnosisUid
					WHERE VSPD.SuperbillProcedureUid = @superbillProcedureUid
					ORDER BY VSPD.SuperbillProcedureUid, VSPD.DisplayOrder
	)
	SELECT	@diagnosisCodeList = COALESCE(@diagnosisCodeList+'','' ,'''') + Code
	FROM	cteSuperbillProcedureInfo;
	
	RETURN @diagnosisCodeList;
END


' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDisplayOrder]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetDisplayOrder](@displayOrder [int], @kdbItemNode [nvarchar](255), @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [int] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetDisplayOrder]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitCLR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitCLR](@parameters [nvarchar](max), @delimiter [nchar](1))
RETURNS  TABLE (
	[Parameter] [nvarchar](4000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[SplitCLR]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDocumentBatchMeasure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetDocumentBatchMeasure](@reportParametersXml XML) RETURNS VARCHAR(1000) AS
BEGIN
	DECLARE @measureUids VARCHAR(MAX) = @reportParametersXml.value(''(/parameters/MeasureUid)[1]'', ''VARCHAR(MAX)'')
	DECLARE @measures VARCHAR(1000) = ''''
	DECLARE @cqmUid UNIQUEIDENTIFIER
	DECLARE @externalID VARCHAR(25)
	DECLARE @cms VARCHAR(255)

	DECLARE cur CURSOR READ_ONLY FOR
		SELECT	c.CQMUid, c.ExternalID, c.CMS
		FROM	dbo.SplitCLR(@measureUids, '','') s INNER JOIN ListCQM c ON CAST(s.Parameter AS UNIQUEIDENTIFIER) = c.CQMUid
	OPEN cur

	FETCH NEXT FROM cur INTO @cqmUid, @externalID, @cms
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @measures = @measures + '' '' + @cms

		FETCH NEXT FROM cur INTO @cqmUid, @externalID, @cms
	END
	CLOSE cur
	DEALLOCATE cur

	RETURN RTRIM(@measures)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFaxDocumentNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetFaxDocumentNames] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  RETURNS VARCHAR(MAX)
AS
BEGIN

	--Bug #17783	Track Fax. Sent documents are listed by attachment group name not the individual document name
/*	DECLARE @Names VARCHAR(max) 
	(select @Names = COALESCE(COALESCE(@Names + '';'', '''') + ag.Name, @Names)  from AttachmentGroup ag
			LEFT JOIN Attachment a ON a.AttachmentUid in (select Value FROM dbo.SplitList(@list, @separator))
			where a.AttachmentGroupUid = ag.AttachmentGroupUid) 
*/			
	DECLARE @Names VARCHAR(max) 
	(select @Names = COALESCE(COALESCE(@Names + '';'', '''') + a.filename+a.FileExtension, @Names)  from AttachmentGroup ag
			LEFT JOIN Attachment a ON a.AttachmentUid in (select Value FROM dbo.SplitList(@list, @separator))
			where a.AttachmentGroupUid = ag.AttachmentGroupUid) 
return @Names   

END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StripNonNumeric]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[StripNonNumeric]
	(
		@s VARCHAR(100)
	)
RETURNS VARCHAR(100)
AS
BEGIN
    -- cmr usage:  SELECT dbo.StripNonNumeric(''(12-34%)xaaa'')
	DECLARE @i INT

	SET @i = PATINDEX(''%[^0-9]%'', @s)
	while @i > 0
	begin
		SET @s = replace(@s, substring(@s, @i, 1), '''')
		SET @i = patindex(''%[^0-9]%'', @s)
	end

	RETURN @s
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPhoneFormatted]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'--20200709 kculberth bug 37376 Visit Receipt truncating Practice phone number--can this field be expanded for the receipt?
--		   issue is that the customer is using an extension denoted by ''x'' and we are also adding the ''x'' while cutting off the last character because we don''t account for the ''x''.
--         changed  - 11 to  - 10 in last SET statement

CREATE FUNCTION [dbo].[GetPhoneFormatted](@phone xml(CONTENT dbo.Phone)) RETURNS VARCHAR(255) AS
BEGIN
	IF @phone IS NULL
		RETURN NULL
		
	DECLARE @phonenumber VARCHAR(100)
	DECLARE @pt VARCHAR(255)
	
	SET @phonenumber = @phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'')

	IF RTRIM(ISNULL(@phonenumber, '''')) = ''''
		RETURN NULL
					
	SET @phonenumber = dbo.StripNonNumeric(@phonenumber)
	IF DATALENGTH(@phonenumber) = 7
		SET @pt = SUBSTRING(@phonenumber, 1, 3) + ''-'' + SUBSTRING(@phonenumber, 4, 4)
	ELSE
	BEGIN
		SET @pt = ''('' + SUBSTRING(@phonenumber, 1, 3) + '') '' + SUBSTRING(@phonenumber, 4, 3) + ''-'' + SUBSTRING(@phonenumber, 7, 4)
	
		IF DATALENGTH(@phonenumber) > 10
			SET @pt = @pt + '' x'' + SUBSTRING(@phonenumber, 11, DATALENGTH(@phonenumber) - 10)
	END
	
	RETURN @pt
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFaxPhone]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetFaxPhone](@phone1 xml(CONTENT dbo.Phone) = NULL, @phone2 xml(CONTENT dbo.Phone) = NULL, @phone3 xml(CONTENT dbo.Phone) = NULL, @phone4 xml(CONTENT dbo.Phone) = NULL) RETURNS VARCHAR(100) AS	
BEGIN
	DECLARE @Phonenumber VARCHAR(50)
	
	IF @phone1.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone1)
	
	IF @phone2.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone2)

	IF @phone3.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone3)

	IF @phone4.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone4)

	RETURN NULL
END




' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFilterOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetFilterOverride](@value [xml], @name [nvarchar](255), @uid [uniqueidentifier])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetFilterOverride]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFindControlAdditionalSearchParam]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- Returns a specific item from @XAdditionalSearchParameters based on the ColumnName passed in.
-- Usage: In stored procedures called by iMedica.FrameworkBO.FindControl.StoredProcedureFindControlService
-- This could become more generic tby taking out the ColumnName part, if necessary.
CREATE FUNCTION [dbo].[GetFindControlAdditionalSearchParam] (
	@XAdditionalSearchParameters XML,
	@ColumnName nvarchar(max)
) RETURNS XML
AS
BEGIN
	DECLARE @singleParam XML = @XAdditionalSearchParameters.query(''/ArrayOfFindControlSearchParameterItemDto/FindControlSearchParameterItemDto[ColumnName=sql:variable("@ColumnName")]'')
	return @singleParam
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFindControlSearchParam]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- Returns a property from @XFindControlStoredProcedureSearchParameters.
-- Usage: In stored procedures called by iMedica.FrameworkBO.FindControl.StoredProcedureFindControlService
CREATE FUNCTION [dbo].[GetFindControlSearchParam] (
	@XFindControlStoredProcedureSearchParameters XML,
	@PropertyName nvarchar(max)
) RETURNS XML
AS
BEGIN
	DECLARE @singleParam XML = @XFindControlStoredProcedureSearchParameters.query(''/FindControlStoredProcedureSearchParameters/*[local-name()=sql:variable("@PropertyName")][1]'')
	return @singleParam
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFindControlSecurityParam]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- Returns a property from @XFindControlSecurityParameters.
-- Usage: In stored procedures called by iMedica.FrameworkBO.FindControl.StoredProcedureFindControlService
CREATE FUNCTION [dbo].[GetFindControlSecurityParam] (
	@XFindControlSecurityParameters XML,
	@PropertyName nvarchar(max)
) RETURNS XML
AS
BEGIN
	DECLARE @singleParam XML = @XFindControlSecurityParameters.query(''/FindControlSecurityParameters/*[local-name()=sql:variable("@PropertyName")][1]'')
	return @singleParam
END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFormattedPRMVersion]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetFormattedPRMVersion](@version [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetFormattedPRMVersion]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getFormatVaribleValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getFormatVaribleValue]
(	
	@exportFormatGUID UNIQUEIDENTIFIER,
	@iProvider VARCHAR(50) = NULL
)RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	SELECT	@retVal = ISNULL(eClaimFormatValue.value, '''')	
	FROM ListClaimFormatValueType eListClaimFormatValueType
	LEFT JOIN ClaimFormatValue eClaimFormatValue ON	eClaimFormatValue.ClaimFormatValueTypeUid = eListClaimFormatValueType.ClaimFormatValueTypeUid AND
	(eClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ProviderUid) = @iProvider )
	WHERE	eListClaimFormatValueType.ClaimFormatValueTypeUid = @exportFormatGUID 
RETURN(@retVal)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFraminghamScore]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetFraminghamScore](@Age int,@Gender Varchar(2),@TC FLOAT,@Smoker VARCHAR(25),@HDL FLOAT,@BP FLOAT,@Treatment BIT) RETURNS int AS	
BEGIN

	DECLARE @FraminghamRisk INT
	
	Declare @AgeATP Table
	(
		minAge int,
		MaxAge int,
		Points int,
		Gender Varchar(2)
	)

	Insert into @AgeATP Values(20,34,-9,''M'')
	Insert into @AgeATP Values(35,39,-4,''M'')
	Insert into @AgeATP Values(40,44,0,''M'')
	Insert into @AgeATP Values(45,49,3,''M'')
	Insert into @AgeATP Values(50,54,6,''M'')
	Insert into @AgeATP Values(55,59,8,''M'')
	Insert into @AgeATP Values(60,64,10,''M'')
	Insert into @AgeATP Values(65,69,11,''M'')
	Insert into @AgeATP Values(70,74,12,''M'')
	Insert into @AgeATP Values(75,79,13,''M'')
	Insert into @AgeATP Values(20,34,-7,''F'')
	Insert into @AgeATP Values(35,39,-3,''F'')
	Insert into @AgeATP Values(40,44,0,''F'')
	Insert into @AgeATP Values(45,49,3,''F'')
	Insert into @AgeATP Values(50,54,6,''F'')
	Insert into @AgeATP Values(55,59,8,''F'')
	Insert into @AgeATP Values(60,64,10,''F'')
	Insert into @AgeATP Values(65,69,12,''F'')
	Insert into @AgeATP Values(70,74,14,''F'')
	Insert into @AgeATP Values(75,79,16,''F'')

	Declare @TotCholATP Table
	(
		MinChol int,
		MaxChol int,
		MinAge int,
		MaxAge int,
		Points int,
		Gender Varchar(2)
	)

	insert into @TotCholATP Values (0,159,20,39,0,''M'')
	insert into @TotCholATP Values (0,159,40,49,0,''M'')
	insert into @TotCholATP Values (0,159,50,59,0,''M'')
	insert into @TotCholATP Values (0,159,60,69,0,''M'')
	insert into @TotCholATP Values (0,159,70,79,0,''M'')
	insert into @TotCholATP Values (0,159,20,39,0,''F'')
	insert into @TotCholATP Values (0,159,40,49,0,''F'')
	insert into @TotCholATP Values (0,159,50,59,0,''F'')
	insert into @TotCholATP Values (0,159,60,69,0,''F'')
	insert into @TotCholATP Values (0,159,70,79,0,''F'')
	insert into @TotCholATP Values (160,199,20,39,4,''M'')
	insert into @TotCholATP Values (160,199,40,49,3,''M'')
	insert into @TotCholATP Values (160,199,50,59,2,''M'')
	insert into @TotCholATP Values (160,199,60,69,1,''M'')
	insert into @TotCholATP Values (160,199,70,79,0,''M'')
	insert into @TotCholATP Values (160,199,20,39,4,''F'')
	insert into @TotCholATP Values (160,199,40,49,3,''F'')
	insert into @TotCholATP Values (160,199,50,59,2,''F'')
	insert into @TotCholATP Values (160,199,60,69,1,''F'')
	insert into @TotCholATP Values (160,199,70,79,1,''F'')
	insert into @TotCholATP Values (200,239,20,39,7,''M'')
	insert into @TotCholATP Values (200,239,40,49,5,''M'')
	insert into @TotCholATP Values (200,239,50,59,3,''M'')
	insert into @TotCholATP Values (200,239,60,69,1,''M'')
	insert into @TotCholATP Values (200,239,70,79,0,''M'')
	insert into @TotCholATP Values (200,239,20,39,8,''F'')
	insert into @TotCholATP Values (200,239,40,49,6,''F'')
	insert into @TotCholATP Values (200,239,50,59,4,''F'')
	insert into @TotCholATP Values (200,239,60,69,2,''F'')
	insert into @TotCholATP Values (200,239,70,79,1,''F'')
	insert into @TotCholATP Values (240,279,20,39,9,''M'')
	insert into @TotCholATP Values (240,279,40,49,6,''M'')
	insert into @TotCholATP Values (240,279,50,59,4,''M'')
	insert into @TotCholATP Values (240,279,60,69,2,''M'')
	insert into @TotCholATP Values (240,279,70,79,1,''M'')
	insert into @TotCholATP Values (240,279,20,39,11,''F'')
	insert into @TotCholATP Values (240,279,40,49,8,''F'')
	insert into @TotCholATP Values (240,279,50,59,5,''F'')
	insert into @TotCholATP Values (240,279,60,69,3,''F'')
	insert into @TotCholATP Values (240,279,70,79,2,''F'')
	insert into @TotCholATP Values (280,9999,20,39,11,''M'')
	insert into @TotCholATP Values (280,9999,40,49,8,''M'')
	insert into @TotCholATP Values (280,9999,50,59,5,''M'')
	insert into @TotCholATP Values (280,9999,60,69,3,''M'')
	insert into @TotCholATP Values (280,9999,70,79,1,''M'')
	insert into @TotCholATP Values (280,9999,20,39,13,''F'')
	insert into @TotCholATP Values (280,9999,40,49,10,''F'')
	insert into @TotCholATP Values (280,9999,50,59,7,''F'')
	insert into @TotCholATP Values (280,9999,60,69,4,''F'')
	insert into @TotCholATP Values (280,9999,70,79,2,''F'')

	Declare @SmokerATP Table
	(
		Smoker Varchar(25),
		MinAge int,
		MaxAge int,
		Points int,
		Gender Varchar(2)
	)

	insert into @SmokerATP Values (''NonSmoker'',20,39,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',40,49,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',50,59,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',60,69,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',70,79,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',20,39,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',40,49,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',50,59,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',60,69,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',70,79,0,''F'')
	insert into @SmokerATP Values (''Smoker'',20,39,8,''M'')
	insert into @SmokerATP Values (''Smoker'',40,49,5,''M'')
	insert into @SmokerATP Values (''Smoker'',50,59,3,''M'')
	insert into @SmokerATP Values (''Smoker'',60,69,1,''M'')
	insert into @SmokerATP Values (''Smoker'',70,79,1,''M'')
	insert into @SmokerATP Values (''Smoker'',20,39,9,''F'')
	insert into @SmokerATP Values (''Smoker'',40,49,7,''F'')
	insert into @SmokerATP Values (''Smoker'',50,59,4,''F'')
	insert into @SmokerATP Values (''Smoker'',60,69,2,''F'')
	insert into @SmokerATP Values (''Smoker'',70,79,1,''F'')

	Declare @HDLATP Table
	(

		MinHDL int,
		MaxHDL int,
		Points int,
		Gender Varchar(2)
		
	)

	insert into @HDLATP Values (0,39,2,''M'')
	insert into @HDLATP Values (40,49,1,''M'')
	insert into @HDLATP Values (50,59,0,''M'')
	insert into @HDLATP Values (60,999,-1,''M'')
	insert into @HDLATP Values (0,39,2,''F'')
	insert into @HDLATP Values (40,49,1,''F'')
	insert into @HDLATP Values (50,59,0,''F'')
	insert into @HDLATP Values (60,999,-1,''F'')


	Declare @BpATP Table
	(
		MinBp int,
		MaxBp int,
		Points int,
		Gender Varchar(2),
		Treatment bit
	)

	insert into @BpATP Values (0,119,0,''M'',0)
	insert into @BpATP Values (120,129,0,''M'',0)
	insert into @BpATP Values (130,139,1,''M'',0)
	insert into @BpATP Values (140,159,1,''M'',0)
	insert into @BpATP Values (160,999,2,''M'',0)
	insert into @BpATP Values (0,129,0,''F'',0)	
	insert into @BpATP Values (120,129,1,''F'',0)
	insert into @BpATP Values (130,139,2,''F'',0)
	insert into @BpATP Values (140,159,3,''F'',0)
	insert into @BpATP Values (160,999,4,''F'',0)
	insert into @BpATP Values (0,119,0,''M'',1)
	insert into @BpATP Values (120,129,1,''M'',1)
	insert into @BpATP Values (130,139,2,''M'',1)
	insert into @BpATP Values (140,159,2,''M'',1)
	insert into @BpATP Values (160,999,3,''M'',1)
	insert into @BpATP Values (0,129,0,''F'',1)	
	insert into @BpATP Values (120,129,3,''F'',1)
	insert into @BpATP Values (130,139,4,''F'',1)
	insert into @BpATP Values (140,159,5,''F'',1)
	insert into @BpATP Values (160,999,6,''F'',1)


	Declare @ATP Table
	(
		Points int,
		Risk int,
		Gender Varchar(2)
	)

	insert into @ATP Values (0,1,''M'')
	insert into @ATP Values (1,1,''M'')
	insert into @ATP Values (2,1,''M'')
	insert into @ATP Values (3,1,''M'')
	insert into @ATP Values (4,1,''M'')
	insert into @ATP Values (5,2,''M'')
	insert into @ATP Values (6,2,''M'')
	insert into @ATP Values (7,3,''M'')
	insert into @ATP Values (8,4,''M'')
	insert into @ATP Values (9,5,''M'')
	insert into @ATP Values (10,6,''M'')
	insert into @ATP Values (11,8,''M'')
	insert into @ATP Values (12,10,''M'')
	insert into @ATP Values (13,12,''M'')
	insert into @ATP Values (14,16,''M'')
	insert into @ATP Values (15,20,''M'')
	insert into @ATP Values (16,25,''M'')
	insert into @ATP Values (9,1,''F'')
	insert into @ATP Values (10,1,''F'')
	insert into @ATP Values (11,1,''F'')
	insert into @ATP Values (12,1,''F'')
	insert into @ATP Values (13,2,''F'')
	insert into @ATP Values (14,2,''F'')
	insert into @ATP Values (15,3,''F'')
	insert into @ATP Values (16,4,''F'')
	insert into @ATP Values (17,5,''F'')
	insert into @ATP Values (18,6,''F'')
	insert into @ATP Values (19,8,''F'')
	insert into @ATP Values (20,11,''F'')
	insert into @ATP Values (21,14,''F'')
	insert into @ATP Values (22,17,''F'')
	insert into @ATP Values (23,22,''F'')
	insert into @ATP Values (24,27,''F'')
	insert into @ATP Values (25,30,''F'')

--	Select * from @AgeATP
--	Select * from @TotCholATP
--	Select * from @SmokerATP
--	Select * from @HDLATP
--	Select * from @BpATP
--	Select * from @ATP
	--@Age int,@Gender Varchar(2),@TC FLOAT,@Smoker bit,@HDL FLOAT,@BP FLOAT
	Declare @ATPscore INT
	SET @ATPscore=0
	SELECT  @ATPscore=@ATPscore + Points FROM @AgeATP	  WHERE Gender=@Gender AND (minAge<=@Age AND MaxAge>=@Age)
	SELECT  @ATPscore=@ATPscore + Points FROM @TotCholATP WHERE Gender=@Gender AND (minAge<=@Age AND MaxAge>=@Age) AND (MinChol<=@TC AND MaxChol>=@TC)
	SELECT  @ATPscore=@ATPscore + Points FROM @SmokerATP  WHERE Gender=@Gender AND (minAge<=@Age AND MaxAge>=@Age) AND Smoker=@Smoker
	SELECT  @ATPscore=@ATPscore + Points FROM @HDLATP  WHERE Gender=@Gender AND (MinHDL<=@HDL AND MaxHDL>=@HDL) 
	SELECT  @ATPscore=@ATPscore + Points FROM @BpATP  WHERE Gender=@Gender AND (MinBP<=@BP AND MaxBp>=@BP) AND Treatment=@Treatment 
	
	---- Declare @ATP Table
	----(
	----	Points int,
	----	Risk int,
	----	Gender Varchar(2)
	--)
	
	IF (@Gender=''M'' and @ATPscore>16)
	BEGIN
		SET @FraminghamRisk=30
	END
	ELSE
	BEGIN
		SELECT @FraminghamRisk=Risk FROM @ATP WHERE Gender=''M'' AND Points=@ATPscore
	END
	
	IF (@Gender=''F'' and @ATPscore>24)
	BEGIN
		SET @FraminghamRisk=30
	END
	ELSE
	BEGIN
		SELECT @FraminghamRisk=Risk FROM @ATP WHERE Gender=''F'' AND Points=@ATPscore
	END
		
	RETURN @FraminghamRisk	

END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetGroupList_SR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE Function [dbo].[GetGroupList_SR](@UID uniqueidentifier)
Returns Varchar(2000)
AS
Begin

Declare @Group Varchar(2000)
       Set @Group=null

;With CTE_UserGroupMember AS (
SELECT DISTINCT 
ugm.UserGroupUId,ugm.MemberUserUID,ugm.MemberUserGroupUid
FROM UserGroupMember ugm
WHERE  (ugm.MemberUserUID = @UID  OR ugm.MemberUserGroupUid=@UID)
)

SELECT 
@Group= COALESCE(@Group + '', '','''') + L.Name

       FROM   ListUserGroup L
       join
                     CTE_UserGroupMember ugm 
       on
                     L.UserGroupuid=ugm.UserGroupUId 
       CROSS JOIN 
                     ViewFindUserAndUserGroup fuug
       WHERE  (ugm.MemberUserUID = @UID  OR ugm.MemberUserGroupUid=@UID)AND
                     ((ugm.MemberUserUid = fuug.Uid AND fuug.ForeignKeyIndex = 1) OR
                     (ugm.MemberUserGroupUid = fuug.Uid AND fuug.ForeignKeyIndex = 2))
       Order by L.Name  

	Return @Group
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHCCCategoryGrouping]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHCCCategoryGrouping](@hccCategory smallint) RETURNS VARCHAR(255) AS
BEGIN
	IF @hccCategory = 1
		RETURN ''HIV/AIDS''
	IF @hccCategory = 2
		RETURN ''SEPSIS''
	IF @hccCategory = 6
		RETURN ''Opportunistic Infections''
	IF @hccCategory = 8 OR @hccCategory = 9 OR @hccCategory = 10 OR @hccCategory = 11 OR @hccCategory = 12
		RETURN ''Cancer''
	IF @hccCategory = 17 OR @hccCategory = 18 OR @hccCategory = 19
		RETURN ''Diabetes''
	IF @hccCategory = 21
		RETURN ''Protein-Calorie Malnutrition''
	IF @hccCategory = 22
		RETURN ''Morbid Obesity''
	IF @hccCategory = 23
		RETURN ''Other Significant Endocrine and Metabolic Disorders''
	IF @hccCategory = 27 OR @hccCategory = 28 OR @hccCategory = 29
		RETURN ''End-Stage Liver Disease''
	IF @hccCategory = 33
		RETURN ''Intestinal Obstruction/Perforation''
	IF @hccCategory = 34
		RETURN ''Chronic Pancreatitis''
	IF @hccCategory = 35
		RETURN ''Inflammatory Bowel Disease''
	IF @hccCategory = 39
		RETURN ''Bone/Joint/Muscle Infections/Necrosis''
	IF @hccCategory = 40
		RETURN ''Rheumatoid Arthritis and Inflammatory Connective Tissue Disease''
	IF @hccCategory = 46 OR @hccCategory = 48
		RETURN ''Severe Hematological Disorders''
	IF @hccCategory = 47
		RETURN ''IMMUNE''
	IF @hccCategory = 54 OR @hccCategory = 55 OR @hccCategory = 60
		RETURN ''Substance Use with Psychotic Complications''
	IF @hccCategory = 57 OR @hccCategory = 58 OR @hccCategory = 59 OR @hccCategory = 60
		RETURN ''Schizophrenia''
	IF @hccCategory = 70 OR @hccCategory = 71 OR @hccCategory = 72 OR @hccCategory = 103 OR @hccCategory = 104 OR @hccCategory = 169
		RETURN ''Quadriplegia''
	IF @hccCategory = 74
		RETURN ''Cerebral Palsy''
	IF @hccCategory = 75
		RETURN ''Myasthenia Gravis/Myoneural Disorders and Guillain-Barre Syndrome/Inflammatory and Toxic Neuropathy''
	IF @hccCategory = 76
		RETURN ''Muscular Dystrophy''
	IF @hccCategory = 77
		RETURN ''Multiple Sclerosis''
	IF @hccCategory = 78
		RETURN ''Parkinson/Huntington Diseases''
	IF @hccCategory = 79
		RETURN ''Seizure Disorders and Convulsions''
	IF @hccCategory = 82 OR @hccCategory = 83 OR @hccCategory = 84
		RETURN ''CARD_RESP_FAIL''
	IF @hccCategory = 85
		RETURN ''CHF''
	IF @hccCategory = 86 OR @hccCategory = 87 OR @hccCategory = 88
		RETURN ''Acute Myocardial Infarction''
	IF @hccCategory = 96
		RETURN ''Specified Heart Arrhythmias''
	IF @hccCategory = 99 OR @hccCategory = 100
		RETURN ''Cerebral Hemorrhage''
	IF @hccCategory = 106 OR @hccCategory = 107 OR @hccCategory = 108
		RETURN ''Atherosclerosis of Extremity with Ulceration or Gangrene''
	IF @hccCategory = 110 OR @hccCategory = 111 OR @hccCategory = 112
		RETURN ''COPD''
	IF @hccCategory = 114 OR @hccCategory = 115
		RETURN ''Aspiration and Specified Bacterial Pneumonias''
	IF @hccCategory = 122
		RETURN ''Proliferative Diabetic Retinopathy and Vitreous Hemorrhage''
	IF @hccCategory = 124
		RETURN ''Exudative Macular Degeneration''
	IF @hccCategory = 134 OR @hccCategory = 135 OR @hccCategory = 136 OR @hccCategory = 137 OR @hccCategory = 138
		RETURN ''Renal''
	IF @hccCategory = 157 OR @hccCategory = 158 OR @hccCategory = 161
		RETURN ''Ulcer of Skin''
	IF @hccCategory = 162
		RETURN ''Severe Skin Burn or Condition''
	IF @hccCategory = 166 OR @hccCategory = 80 OR @hccCategory = 167 
		RETURN ''Severe Head Injury''
	IF @hccCategory = 170
		RETURN ''Hip Fracture/Dislocation''
	IF @hccCategory = 173
		RETURN ''Traumatic Amputations and Complications''
	IF @hccCategory = 176
		RETURN ''COMPL''
	IF @hccCategory = 186
		RETURN  ''Major Organ Transplant Status or Replacement Status''
	IF @hccCategory = 188
		RETURN ''Artificial Openings for Feeding or Elimination''
	IF @hccCategory = 189
		RETURN ''Amputation Status, Lower Limb/Amputation Complication''

	RETURN NULL
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHCCCommuityFactors]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHCCCommuityFactors](@code9 VARCHAR(6), @code10 VARCHAR(10)) RETURNS DECIMAL(4,3) AS
BEGIN
	DECLARE @hcc DECIMAL(4,3)

	SELECT	@hcc= MAX(srb.HCCCommunityFactors)
	FROM	IMO_ProblemIT_SearchResult_Base srb
	WHERE	srb.Code09 = @code9 AND
			srb.Code10 = @code10

	RETURN @hcc
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHideFlag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHideFlag](@kdbItemNode [nvarchar](255), @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetHideFlag]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StringToDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[StringToDate](@answer [nvarchar](255))
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[StringToDate]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHistoryDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHistoryDate](@patientUid UNIQUEIDENTIFIER, @question VARCHAR(100)) RETURNS DATE AS BEGIN
	DECLARE @date DATE
	SELECT	@date = dbo.StringToDate(phd.AnswerName)
	FROM	PatientHistory ph INNER JOIN PatientHistoryDetail phd ON ph.PatientHistoryUid = phd.PatientHistoryUid
	WHERE	phd.QuestionUid IN (SELECT QuestionUid FROM ListQuestion WHERE Name LIKE ''%'' + @question + ''%'')
			AND ph.InactiveDate IS NULL
			AND ph.PatientUid = @patientUid
			AND dbo.StringToDate(phd.AnswerName) IS NOT NULL

	RETURN	@date
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHospitalRoundNames](@hospitalRoundUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + 
				dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	RelHospitalRoundProvider rel INNER JOIN ViewProvider p ON rel.ProviderUid = p.PersonUid
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid	
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + dbo.GetDiagnosisCodeAndName(rel.Code9, rel.Code10, rel.CodeDescription)
		FROM	RelHospitalRoundDiagnosis rel
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
		
	RETURN @names
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundNamesWithID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetHospitalRoundNamesWithID](@hospitalRoundUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '', '' END + dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	RelHospitalRoundProvider rel INNER JOIN ViewProvider p ON rel.ProviderUid = p.PersonUid
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid	
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '', '' END + 		COALESCE(code10, code9) + '' '' + CodeDescription 
		FROM	RelHospitalRoundDiagnosis rel --INNER JOIN VisitDiagnosis vd ON rel.DiagnosisUid = vd.DiagnosisUid
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
		
	RETURN @names
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRounds]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetHospitalRounds]
()
RETURNS @retTable TABLE 
(
	HospitalRoundUid UniqueIdentifier,
	ServiceSiteName varchar(255),
	ServiceSiteUid uniqueidentifier,
	PatientName varchar(255),
	PatientUid uniqueidentifier,
	Location varchar(255),
	AdmitDate datetime,
	DischargeDate datetime,
	Notes text,
	ProviderNames varchar(1000),
	ProviderUids varchar(1000),
	DiagnosisNames varchar(1000),
	DiagnosisCodes varchar(1000),
	Inactive bit
)
AS
	BEGIN
	-- Get all data except provider stuff
		insert into @retTable
		select 
			hr.HospitalRoundUid, ss.Name as ServiceSiteName,
			hr.ServiceSiteUid, p.LastName + '', '' + p.FirstName AS PatientName,
			PatientUid, Location, AdmitDate, DischargeDate,  hr.Notes,
			null, null, null, null, hr.Inactive
		from hospitalround hr
		inner join ListServiceSite ss on ss.ServiceSiteUid = hr.ServiceSiteUid
		inner join Person p on p.PersonUid = hr.PatientUid

	-- Now get the providers
	declare @curId uniqueidentifier
	select top 1 @curid = HospitalRoundUid from @retTable order by HospitalRoundUid

	while ( @curId is not null )
	begin
		declare @Names varchar(1000)
		declare @UidsOrCodes varchar(1000)
		set @Names = '''' 
		set @UidsOrCodes = ''''

	-- Provider info
		select @Names = @Names + dbo.UDF_getFormattedInternalName(firstname, middlename, lastname, akafirstname, akalastname) + ''; '',
		@UidsOrCodes = @UidsOrCodes + cast(ProviderUid as varchar(36)) + '';''
		from HospitalRound hr
		inner join RelHospitalRoundProvider rhrpv on rhrpv.HospitalRoundUid = @curId 
		inner join viewprovider vp on vp.personuid = rhrpv.ProviderUid
		where hr.HospitalRoundUid = @curid

		IF (len(@Names) > 0)
			SET @Names = left(@Names, len(@names) - 1)

		update @retTable
		set ProviderNames = @Names, ProviderUids = @UidsOrCodes
		where HospitalRoundUid = @curid and @names <> ''''

	-- Diagnosis names
		set @Names = '''' 
		set @UidsOrCodes = ''''

		select @Names = @Names + rhrd.CodeDescription + '' ('' + coalesce(rhrd.Code9, rhrd.Code10) + ''); '',
		@UidsOrCodes = @UidsOrCodes + cast(rhrd.Code9 as varchar(36)) + '';''
		from HospitalRound hr
		inner join RelHospitalRoundDiagnosis rhrd on rhrd.HospitalRoundUid = @curId 
		where hr.HospitalRoundUid = @curid

		IF (len(@Names) > 0)
			SET @Names = left(@Names, len(@names) - 1)

		update @retTable
		set DiagnosisNames = @Names, DiagnosisCodes = @UidsOrCodes
		where HospitalRoundUid = @curid and @names <> ''''

		-- advance to the next one
		select top 1 @curid = HospitalRoundUid from @retTable where HospitalRoundUid > @curid order by HospitalRoundUid 
		if @@rowcount = 0  set @curid = null
	end
	return 
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundSpecificUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetHospitalRoundSpecificUids](@hospitalRoundUid uniqueidentifier, @provider bit,@provideruid Varchar(max)=Null) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE	@uidsOrCodes VARCHAR(MAX)
		
	IF @provider <> 0
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.ProviderUid)
		FROM	RelHospitalRoundProvider rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
		and (@provideruid is null OR rel.ProviderUid in (Select Element From dbo.Split (@provideruid,'','')))
	ELSE
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.Code9)
		FROM	RelHospitalRoundDiagnosis rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
	
	
	RETURN @uidsOrCodes
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetHospitalRoundUids](@hospitalRoundUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE	@uidsOrCodes VARCHAR(MAX)
		
	IF @provider <> 0
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.ProviderUid)
		FROM	RelHospitalRoundProvider rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
	ELSE
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.Code9)
		FROM	RelHospitalRoundDiagnosis rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
	
	
	RETURN @uidsOrCodes
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetIndexColumns]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetIndexColumns]
(
	@object_id int,
	@index_id int
) RETURNS  VARCHAR(MAX) AS 
BEGIN 
		DECLARE @Columns VARCHAR(MAX)
		
		SELECT	@Columns = COALESCE(@Columns + '', '', '''') + c.Name
		FROM	sys.index_columns ic INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
		WHERE   ic.object_id = @object_id AND
				ic.index_id = @index_id AND
				ic.is_included_column = 0
		RETURN @Columns
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbConfigurationUidByProviders]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/****** Object:  UserDefinedFunction [dbo].[GetKdbConfigurationUidByProviders]    Script Date: 9/24/2019 1:51:58 PM ******/
-- #25759: This function will return the KdbConfigurationUid that is determined based on the current user, and optionally, a billing and rendering provider
CREATE FUNCTION [dbo].[GetKdbConfigurationUidByProviders]( @userUid UNIQUEIDENTIFIER = NULL, @renderingProviderUid UNIQUEIDENTIFIER = NULL, @billingProviderUid UNIQUEIDENTIFIER = NULL) RETURNS UNIQUEIDENTIFIER AS
BEGIN
	DECLARE @kdbConfigurationUid UNIQUEIDENTIFIER = NULL
	DECLARE @currentUserProviderUid UNIQUEIDENTIFIER = NULL

	IF @userUid IS NOT NULL
	BEGIN
		-- try to get KdbConfigurationUid from Provider table for the user
		SELECT @kdbConfigurationUid = p.KdbConfigurationUid,
			   @currentUserProviderUid = p.PersonUid
		FROM Provider p 
		WHERE p.PersonUid = @userUid

		-- If the user is not a Provider, or they don''t have a KdbConfigurationUid set, 
		-- then try to retrieve the KdbConfigurationUid from the ListUserSetting for the user
		IF @kdbConfigurationUid IS NULL
			SELECT	@kdbConfigurationUid = KdbConfigurationUid
			FROM	UserPRM u 
			INNER JOIN ListUserSetting us ON u.UserSettingUid = us.UserSettingUid
			WHERE	u.PersonUid = @userUid
	END

	-- If the user doesn''t have a KdbConfigurationUid on their ListUserSetting, and the user is NOT a Provider,
	-- then try to get the KdbConfigurationUid for the Rendering Provider, or the Billing Provider instead
	IF @kdbConfigurationUid IS NULL AND @currentUserProviderUid IS NULL
	BEGIN
		IF @renderingProviderUid IS NOT NULL 
		AND (@renderingProviderUid <> @userUid OR @userUid IS NULL)
			SET @kdbConfigurationUid = dbo.GetKdbConfigurationUidByProviders(@renderingProviderUid, DEFAULT, DEFAULT)

		IF @kdbConfigurationUid IS NULL 
		AND @billingProviderUid IS NOT NULL 
		AND (@billingProviderUid <> @renderingProviderUid OR @renderingProviderUid IS NULL)
		AND (@billingProviderUid <> @userUid OR @userUid IS NULL)
			SET @kdbConfigurationUid = dbo.GetKdbConfigurationUidByProviders(@billingProviderUid, DEFAULT, DEFAULT)
	END
			
	RETURN @kdbConfigurationUid
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbConfigurationUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'/****** Object:  UserDefinedFunction [dbo].[GetKdbConfigurationUid]    Script Date: 9/24/2019 2:48:27 PM ******/
-- #25759: This function has the same behavior as it previously did. The logic was just moved into dbo.GetKdbConfigurationUidByProviders, 
-- and this function was modified to call that function, and return the result.
CREATE FUNCTION [dbo].[GetKdbConfigurationUid]( @userUid UNIQUEIDENTIFIER ) RETURNS UNIQUEIDENTIFIER AS
BEGIN
	DECLARE @kdbConfigurationUid UNIQUEIDENTIFIER = dbo.GetKdbConfigurationUidByProviders(@userUid, DEFAULT, DEFAULT)		
	RETURN @kdbConfigurationUid
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbConfigurationUidByVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/****** Object:  UserDefinedFunction [dbo].[GetKdbConfigurationUidByVisit]    Script Date: 9/24/2019 1:51:58 PM ******/
-- #25759: This function will return the KdbConfigurationUid that is determined based on the current user, and optionally, values from a Visit
CREATE FUNCTION [dbo].[GetKdbConfigurationUidByVisit]( @userUid UNIQUEIDENTIFIER = NULL, @visitUid UNIQUEIDENTIFIER = NULL) RETURNS UNIQUEIDENTIFIER AS
BEGIN
	DECLARE @kdbConfigurationUid UNIQUEIDENTIFIER = NULL

	-- get the KdbConfigurationUid from just the userUid if the visitUid is null
	IF @userUid IS NOT NULL AND @visitUid IS NULL
		SET @kdbConfigurationUid = dbo.GetKdbConfigurationUidByProviders(@userUid, DEFAULT, DEFAULT)

	-- if the KdbConfigurationUid is still null, then use the userUid, and RenderingProvider or BillingProvider from the Visit to look it up
	IF @kdbConfigurationUid IS NULL AND @visitUid IS NOT NULL
	BEGIN
		DECLARE @renderingProviderUid UNIQUEIDENTIFIER
		DECLARE @billingProviderUid UNIQUEIDENTIFIER

		-- try to get BillingProvider and RenderingProvider from the visit, so they can be used to lookup the KdbConfiguration
		SELECT @renderingProviderUid = v.RenderingProviderUid,
			   @billingProviderUid = v.ProviderUid
		FROM Visit v 
		WHERE v.VisitUid = @visitUid

		SET @kdbConfigurationUid = dbo.GetKdbConfigurationUidByProviders(@userUid, @renderingProviderUid, @billingProviderUid)
	END
			
	RETURN @kdbConfigurationUid
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbOverrideElement]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetKdbOverrideElement](@uid [uniqueidentifier], @kdbOverride [xml])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetKdbOverrideElement]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbOverrideValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetKdbOverrideValue](@uid [uniqueidentifier], @kdbItemNode [nvarchar](255), @kdb [xml], @attributeName [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetKdbOverrideValue]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastObservationValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetLastObservationValue](@patientUid UNIQUEIDENTIFIER, @observationItemUid UNIQUEIDENTIFIER, @startDate DATE, @endDate DATE, @valueType TINYINT = 0) RETURNS VARCHAR(100) AS
BEGIN
	DECLARE @result VARCHAR(100)
	
	SELECT TOP 1	@result =	CASE @valueType
								WHEN 1 THEN
									CAST(ov.MetricValue1 AS VARCHAR(100))
								WHEN 2 THEN
									CAST(ov.MetricValue2 AS VARCHAR(100))
								WHEN 10 THEN
									CONVERT(VARCHAR(100), COALESCE(oo.ResultDate, oo.PerformDate), 101)
								ELSE
									CAST(ov.ObservationValue AS VARCHAR(100))
								END
	FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
	WHERE			ov.ObservationItemUid = @observationItemUid AND
					oo.PatientUid = @patientUid AND
					(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
					(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL)
	ORDER BY		COALESCE(oo.ResultDate, oo.PerformDate) DESC

	RETURN			@result
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastObservationValueByName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetLastObservationValueByName](@patientUid UNIQUEIDENTIFIER, @observationName VARCHAR(100), @startDate DATE, @endDate DATE, @valueType TINYINT = 0) RETURNS VARCHAR(100) AS
BEGIN
	DECLARE @result VARCHAR(100)
	
	DECLARE cur CURSOR FOR 
		SELECT			CASE @valueType
									WHEN 1 THEN
										CAST(ov.MetricValue1 AS VARCHAR(100))
									WHEN 2 THEN
										CAST(ov.MetricValue2 AS VARCHAR(100))
									WHEN 10 THEN
										CONVERT(VARCHAR(100), COALESCE(oo.ResultDate, oo.PerformDate), 101)
									ELSE
										CAST(ov.ObservationValue AS VARCHAR(100))
									END
		FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
						INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
		WHERE			oi.Name LIKE @observationName AND
						oo.PatientUid = @patientUid AND
						(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
						(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL)
		ORDER BY		oo.ResultDate DESC

	OPEN cur
	FETCH NEXT FROM cur INTO @result
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @result IS NOT NULL AND RTRIM(@result) <> ''''
			RETURN @result
		
		FETCH NEXT FROM cur INTO @result
	END
	
	RETURN @result
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastObservationValueTable]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetLastObservationValueTable](@patientUid UNIQUEIDENTIFIER, @observationName VARCHAR(100), @startDate DATE, @endDate DATE, @sortType smallint)
	RETURNS @Observation TABLE 
	(
		PatientUid UNIQUEIDENTIFIER,
		ObservationDate DATE,
		ObservationValue VARCHAR(100)
	)
AS
BEGIN
	IF @sortType = 1
			INSERT			@Observation
			SELECT TOP 1	t.PatientUid, t.ObservationDate, t.ObservationValue
			FROM			(	SELECT	@patientUid AS PatientUid, ov.ObservationValueUid,
										CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS ObservationDate,
										CAST(ov.ObservationValue AS VARCHAR(100)) AS ObservationValue
								FROM	ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
										INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
								WHERE	oi.Name LIKE @observationName AND
										oo.PatientUid = @patientUid AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) <= @endDate OR @endDate IS NULL) AND
										ov.ObservationValue IS NOT NULL AND
										RTRIM(CAST(ov.ObservationValue AS VARCHAR(100))) <> '''' AND
										ISNUMERIC(CAST(ov.ObservationValue AS VARCHAR(100))) = 1) t	
			ORDER BY		CAST(t.ObservationValue AS MONEY), t.ObservationDate DESC
	ELSE IF @sortType = 2
			INSERT			@Observation
			SELECT TOP 1	t.PatientUid, t.ObservationDate, t.ObservationValue
			FROM			(	SELECT	@patientUid AS PatientUid, ov.ObservationValueUid,
										CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS ObservationDate,
										CAST(ov.ObservationValue AS VARCHAR(100)) AS ObservationValue
								FROM	ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
										INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
								WHERE	oi.Name LIKE @observationName AND
										oo.PatientUid = @patientUid AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) <= @endDate OR @endDate IS NULL) AND
										ov.ObservationValue IS NOT NULL AND
										RTRIM(CAST(ov.ObservationValue AS VARCHAR(100))) <> '''' AND
										ISNUMERIC(CAST(ov.ObservationValue AS VARCHAR(100))) = 1) t	
			ORDER BY		CAST(t.ObservationValue AS MONEY) DESC, t.ObservationDate DESC
	ELSE
			INSERT			@Observation
			SELECT TOP 1	@patientUid, CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS ObservationDate,
							ov.ObservationValue							
			FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
							INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
			WHERE			oi.Name LIKE @observationName AND
							oo.PatientUid = @patientUid AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL) AND
							ov.ObservationValue IS NOT NULL AND
							RTRIM(CAST(ov.ObservationValue AS VARCHAR(MAX))) <> ''''
			ORDER BY		COALESCE(oo.ResultDate, oo.PerformDate) DESC
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastStatementDate_ForAccountResponsibleParty_WithAggregateOption]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetLastStatementDate_ForAccountResponsibleParty_WithAggregateOption] (@accountResponsiblePartyUid UNIQUEIDENTIFIER, @financialCenterUid UNIQUEIDENTIFIER, @aggregateMultpleFinancialCentersTogether BIT = 0)
RETURNS @retTable TABLE (AccountResponsiblePartyUid UNIQUEIDENTIFIER, FinancialCenterUid UNIQUEIDENTIFIER, LastStatementDate DATE, BatchComplete BIT)
AS
BEGIN
 WITH 
 cteStatementsByFinancialCenter AS /* get practice settings */ ( SELECT TOP 1 PS.StatementsByFinancialCenter FROM PracticeSettings PS ),
 cteStatementBatchDetailData AS (
  SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid, SBD.StatementDate, SBD.LastModifiedDate, CAST(CASE WHEN (NOT SBDWATCH.StatementBatchUid IS NULL) THEN 1 ELSE 0 END AS BIT) AS BatchComplete
  FROM StatementBatchDetail SBD WITH (NOLOCK)
    INNER JOIN StatementBatch SB WITH (NOLOCK) ON SBD.StatementBatchUid = SB.StatementBatchUid
    LEFT JOIN (
     SELECT DISTINCT StatementBatchUid
     FROM StatementBatchDetail WITH (NOLOCK)
     WHERE NOT AttachmentUid IS NULL
     ) SBDWATCH ON SBD.StatementBatchUid = SBDWATCH.StatementBatchUid
    INNER JOIN cteStatementsByFinancialCenter SBFC ON (1 = 1) -- will always have one record
  WHERE (NOT SB.StatementActionUid = ''A88F5A75-0AD5-4C90-B006-8A007A7FA13C'')
    AND (SBD.AccountResponsiblePartyUid = @accountResponsiblePartyUid)
    AND (  (SBFC.StatementsByFinancialCenter = 0 AND SBD.FinancialCenterUid IS NULL)
        OR (SBFC.StatementsByFinancialCenter = 1 AND SBD.FinancialCenterUid = @financialCenterUid))
  ), 
cteFilteredByBatch AS (
  SELECT DISTINCT AccountResponsiblePartyUid, FinancialCenterUid, CASE WHEN BatchComplete = 0 THEN LastModifiedDate ELSE StatementDate END AS StatementDate, BatchComplete
  FROM cteStatementBatchDetailData A
  WHERE (BatchComplete = 1 AND NOT StatementDate IS NULL) OR (Batchcomplete = 0)
  ), 
cteArpOldData AS (
  SELECT DISTINCT ARP.AccountResponsiblePartyUid, NULL AS FinancialCenterUid, ARP.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
  FROM AccountResponsibleParty ARP WITH (NOLOCK)
    INNER JOIN cteStatementsByFinancialCenter SBFC ON (1 = 1) -- will always have one record
  WHERE (SBFC.StatementsByFinancialCenter = 0) -- this is an ARP ONLY record
   AND ARP.AccountResponsiblePartyUid = @accountResponsiblePartyUid
  ),
cteArpFCCover AS ( /* we have no ARPFC set like ARP only above - creating FAKE data here */
  
  SELECT DISTINCT @accountResponsiblePartyUid AccountResponsiblePartyUid, @financialCenterUid FinancialCenterUid, NULL AS StatementDate, CAST(1 AS BIT) AS BatchComplete
  FROM cteStatementsByFinancialCenter SBFC
  WHERE (SBFC.StatementsByFinancialCenter = 1) -- these are FC ONLY records
  ), 
cteArpFcOldData AS (
  SELECT DISTINCT ARPFC.AccountResponsiblePartyUid, ARPFC.FinancialCenterUid, ARPFC.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
  FROM RelAccountResponsiblePartyFinancialCenter ARPFC WITH (NOLOCK)
    INNER JOIN cteStatementsByFinancialCenter SBFC ON (1 = 1) -- will always have one record
  WHERE (SBFC.StatementsByFinancialCenter = 1) -- this is an FC ONLY record
   AND ARPFC.AccountResponsiblePartyUid = @accountResponsiblePartyUid AND ARPFC.FinancialCenterUid = @financialCenterUid
  ), 
cteUnionAll AS (
  SELECT * FROM cteFilteredByBatch  
  UNION
  SELECT * FROM cteArpOldData
  UNION
  SELECT * FROM cteArpFcOldData
  UNION
  SELECT * FROM cteArpFCCover
  ),
cteSbdWithRowNumsSQL AS (
  SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid, SBD.StatementDate, 
    ROW_NUMBER() OVER ( PARTITION BY SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid ORDER BY SBD.StatementDate DESC ) AS ROWNUMWFC, 
    ROW_NUMBER() OVER ( PARTITION BY SBD.AccountResponsiblePartyUid ORDER BY SBD.StatementDate DESC ) AS ROWNUMWOFC, 
    SBD.BatchComplete --  @aggregateMultpleFinancialCentersTogether
    FROM cteUnionAll SBD
  ), 
cteHistoricalLastStatementDateSQL AS (
  SELECT RN.AccountResponsiblePartyUid, CASE WHEN @aggregateMultpleFinancialCentersTogether = 0 THEN RN.FinancialCenterUid ELSE NULL END AS FinancialCenterUid, RN.StatementDate AS LastStatementDate, RN.BatchComplete
  FROM cteSbdWithRowNumsSQL RN
  WHERE (@aggregateMultpleFinancialCentersTogether = 0 AND ROWNUMWFC = 1) OR (@aggregateMultpleFinancialCentersTogether = 1 AND ROWNUMWOFC = 1)
  )
 
 INSERT INTO @retTable (AccountResponsiblePartyUid, FinancialCenterUid, LastStatementDate, BatchComplete)
 SELECT DISTINCT HLSD.* FROM cteHistoricalLastStatementDateSQL HLSD;

 RETURN;
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastStatementDatesForAccountResponsiblePartyWithAggregateOption]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetLastStatementDatesForAccountResponsiblePartyWithAggregateOption](@accountResponsbilePartyUids VARCHAR(MAX), @financialCenterUids VARCHAR(MAX), @aggregateMultpleFinancialCentersTogether BIT = 0)
RETURNS @retTable TABLE 
(
    AccountResponsiblePartyUid UNIQUEIDENTIFIER,
	FinancialCenterUid UNIQUEIDENTIFIER,
	LastStatementDate DATE,
	BatchComplete BIT
)
AS
BEGIN

WITH cteStatementsByFinancialCenter AS -- get practice settings
(
	SELECT TOP 1  PS.StatementsByFinancialCenter 
		FROM PracticeSettings PS
), cteARP AS -- get AccountResponsiblePartyUid list, either all if none specified 
(
	SELECT DISTINCT CAST(SARP.Element AS UNIQUEIDENTIFIER) AS AccountResponsiblePartyUid  
		FROM dbo.Split(@accountResponsbilePartyUids, '';'')  SARP
			INNER JOIN AccountResponsibleParty ARP WITH (NOLOCK) ON CAST(SARP.Element AS UNIQUEIDENTIFIER) = ARP.AccountResponsiblePartyUid
	UNION
	SELECT AccountResponsiblePartyUid FROM AccountResponsibleParty WHERE @accountResponsbilePartyUids IS NULL
), cteFC AS -- get FinancialCenterUid list, either all if none specified 
(
	SELECT DISTINCT CAST(Element AS UNIQUEIDENTIFIER) AS FinancialCenterUid  
		FROM dbo.Split(@financialCenterUids, '';'') SFC
			INNER JOIN FinancialCenter FC WITH (NOLOCK) ON CAST(SFC.Element AS UNIQUEIDENTIFIER) = FC.FinancialCenterUid

	UNION
	SELECT FinancialCenterUid  FROM FinancialCenter WITH (NOLOCK) WHERE @financialCenterUids IS NULL
), cteStatementBatchDetailData AS
(
 SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid,  SBD.StatementDate, SBD.LastModifiedDate, 
		CAST(CASE WHEN (NOT SBDWATCH.StatementBatchUid IS NULL) THEN 1 ELSE 0 END AS BIT) AS BatchComplete 
	FROM StatementBatchDetail SBD WITH (NOLOCK) 
		INNER JOIN StatementBatch SB WITH (NOLOCK) ON SBD.StatementBatchUid = SB.StatementBatchUid 
			LEFT JOIN (SELECT DISTINCT StatementBatchUid FROM StatementBatchDetail WITH (NOLOCK)  WHERE NOT AttachmentUid IS NULL) SBDWATCH ON SBD.StatementBatchUid = SBDWATCH.StatementBatchUid 
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteARP ARPF ON SBD.AccountResponsiblePartyUid = ARPF.AccountResponsiblePartyUid
			LEFT JOIN cteFC FCF ON SBD.FinancialCenterUid = FCF.FinancialCenterUid
	WHERE (NOT SB.StatementActionUid = ''A88F5A75-0AD5-4C90-B006-8A007A7FA13C'') 
		AND ((SBFC.StatementsByFinancialCenter = 0 AND SBD.FinancialCenterUid IS NULL) 
			OR (SBFC.StatementsByFinancialCenter = 1 AND NOT FCF.FinancialCenterUid IS NULL))
), cteFilteredByBatch AS
(
	SELECT DISTINCT AccountResponsiblePartyUid, FinancialCenterUid,
			CASE WHEN BatchComplete = 0 THEN LastModifiedDate ELSE StatementDate END AS StatementDate,  BatchComplete
		FROM cteStatementBatchDetailData A
		WHERE (BatchComplete = 1 AND NOT StatementDate IS NULL) OR (Batchcomplete = 0)
), cteArpOldData AS
(
	SELECT DISTINCT ARP.AccountResponsiblePartyUid, NULL AS FinancialCenterUid,
			ARP.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
		FROM AccountResponsibleParty ARP  WITH (NOLOCK)
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteARP ARPF ON ARP.AccountResponsiblePartyUid = ARPF.AccountResponsiblePartyUid
		WHERE (SBFC.StatementsByFinancialCenter = 0) -- this is an ARP ONLY record
), cteArpFCCover AS -- we have no ARPFC set like ARP only above - creating FAKE data here 
(
	SELECT DISTINCT ARPF.AccountResponsiblePartyUid, FCF.FinancialCenterUid,
			NULL AS StatementDate, CAST(1 AS BIT) AS BatchComplete
		FROM cteARP ARPF 
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteFC FCF ON (1=1) -- gets me a CROSS JOIN
		WHERE (SBFC.StatementsByFinancialCenter = 1) -- these are FC ONLY records
), cteArpFcOldData AS
(
	SELECT DISTINCT ARPFC.AccountResponsiblePartyUid, ARPFC.FinancialCenterUid,
			ARPFC.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
		FROM RelAccountResponsiblePartyFinancialCenter ARPFC WITH (NOLOCK)
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteARP ARPF ON ARPFC.AccountResponsiblePartyUid = ARPF.AccountResponsiblePartyUid
			INNER JOIN cteFC FCF ON (ARPFC.FinancialCenterUid = FCF.FinancialCenterUid) -- limits by FC list
		WHERE (SBFC.StatementsByFinancialCenter = 1) -- this is an FC ONLY record
), cteUnionAll AS
(
	SELECT * FROM cteFilteredByBatch
		UNION 
	SELECT * FROM cteArpOldData
		UNION 
	SELECT * FROM cteArpFcOldData
		UNION 
	SELECT * FROM cteArpFCCover
), cteSbdWithRowNumsSQL AS
(
	SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid, SBD.StatementDate, 
			ROW_NUMBER() OVER (PARTITION BY SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid
				ORDER BY SBD.StatementDate DESC) AS ROWNUMWFC, 
			ROW_NUMBER() OVER (PARTITION BY SBD.AccountResponsiblePartyUid
				ORDER BY SBD.StatementDate DESC) AS ROWNUMWOFC, 
			SBD.BatchComplete  --  @aggregateMultpleFinancialCentersTogether
		FROM cteUnionAll SBD
), cteHistoricalLastStatementDateSQL AS
(
	SELECT RN.AccountResponsiblePartyUid, 
		CASE WHEN @aggregateMultpleFinancialCentersTogether = 0 THEN RN.FinancialCenterUid ELSE NULL END AS FinancialCenterUid, 
		RN.StatementDate AS LastStatementDate, RN.BatchComplete
		FROM cteSbdWithRowNumsSQL RN 
		WHERE (@aggregateMultpleFinancialCentersTogether = 0 AND ROWNUMWFC = 1)
			OR (@aggregateMultpleFinancialCentersTogether = 1 AND ROWNUMWOFC = 1)
)
INSERT INTO @retTable (AccountResponsiblePartyUid, FinancialCenterUid, LastStatementDate, BatchComplete)
SELECT DISTINCT HLSD.*
	FROM cteHistoricalLastStatementDateSQL HLSD;
	 
	RETURN;

END

















' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastStatementDatesForAccountResponsibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetLastStatementDatesForAccountResponsibleParty](@accountResponsbilePartyUids VARCHAR(MAX), @financialCenterUids VARCHAR(MAX))
RETURNS @retTable TABLE 
(
    AccountResponsiblePartyUid UNIQUEIDENTIFIER,
	FinancialCenterUid UNIQUEIDENTIFIER,
	LastStatementDate DATE,
	BatchComplete BIT
)
AS
BEGIN

	INSERT INTO @retTable (AccountResponsiblePartyUid, FinancialCenterUid, LastStatementDate, BatchComplete)
	SELECT *
		FROM GetLastStatementDatesForAccountResponsiblePartyWithAggregateOption(@accountResponsbilePartyUids, @financialCenterUids, 0);
	 
	RETURN;

END

















' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMappedDiagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/* Pancratius 01/07/2014: Changed listdiagnosis.diagnosisCode9 to visitDiagnosis.code and commented out listdiagnosis table
Pancratius 03/06/2014: Add ISNULL function to to the visitdiagnosis.code and visitdiagnosis.code10
select
code + '', '' + coalesce(code10,'' '') from visitdiagnosis
20150518 kc add UseICD10 parameter
20150901 kc add else clause to handle labs without HL7 partners. 
*/

CREATE FUNCTION [dbo].[GetMappedDiagnosis](@ProcedureUid uniqueidentifier, @ImedicaAccessionNumber VARCHAR(50),@UseICD10 bit)  
RETURNS VARCHAR(MAX) AS  
BEGIN  
   DECLARE @Diag VARCHAR(MAX)  
   SET @Diag = ''''  
  
   --SELECT @Diag=@Diag + Coalesce(VisitDiagnosis.Code,'' '')+'', ''+Coalesce(VisitDiagnosis.Code10,'' '') + '', ''  
   IF (@UseICD10 = 1) 
   BEGIN
          SELECT @Diag = @Diag + Coalesce(VisitDiagnosis.Code10, VisitDiagnosis.Code) + '', ''
          FROM ObservationOrder  
          INNER JOIN VisitProcedure ON VisitProcedure.VisitProcedureUid = ObservationOrder.VisitProcedureUid  
          INNER JOIN VisitProcedureDiagnosis ON VisitProcedureDiagnosis.VisitProcedureUid = VisitProcedure.VisitProcedureUid  
          INNER JOIN VisitDiagnosis ON VisitProcedureDiagnosis.VisitDiagnosisUid = VisitDiagnosis.VisitDiagnosisUid  
          WHERE ObservationOrder.ImedicaAccessionNumber = @ImedicaAccessionNumber  
               AND VisitProcedure.ProcedureUid = @ProcedureUid  
               AND VisitProcedureDiagnosis.DisplayOrder<>0
          ORDER BY VisitDiagnosis.DisplayOrder  
   END
   ELSE If (@useICD10 = 0)--must be ICD9
   BEGIN
          SELECT @Diag = @Diag + Coalesce(VisitDiagnosis.Code,'' '') + '', ''
          FROM ObservationOrder  
          INNER JOIN VisitProcedure ON VisitProcedure.VisitProcedureUid = ObservationOrder.VisitProcedureUid  
          INNER JOIN VisitProcedureDiagnosis ON VisitProcedureDiagnosis.VisitProcedureUid = VisitProcedure.VisitProcedureUid  
          INNER JOIN VisitDiagnosis ON VisitProcedureDiagnosis.VisitDiagnosisUid = VisitDiagnosis.VisitDiagnosisUid  
          WHERE ObservationOrder.ImedicaAccessionNumber = @ImedicaAccessionNumber  
               AND VisitProcedure.ProcedureUid = @ProcedureUid  
               AND VisitProcedureDiagnosis.DisplayOrder<>0
          ORDER BY VisitDiagnosis.DisplayOrder  
   END
   Else if (@UseICD10 is Null) 
   BEGIN
          SELECT @DIAG = (CASE WHEN (VisitDiagnosis.Code is not null and VisitDiagnosis.Code10 is not null) 
				THEN @Diag + Coalesce(VisitDiagnosis.Code,'' '') +  ''/'' + Coalesce(VisitDiagnosis.Code10,'' '') + '', '' 
				ELSE CASE WHEN (VisitDiagnosis.Code is not null and VisitDiagnosis.Code10 is  null)
				THEN @Diag + Coalesce(VisitDiagnosis.Code,'' '') + '', '' 
				ELSE CASE WHEN (VisitDiagnosis.Code10 is not null and VisitDiagnosis.Code is  null)
				THEN @Diag + Coalesce(VisitDiagnosis.Code10,'' '') + '', '' 
				END
				END
			END )
          FROM ObservationOrder  
          INNER JOIN VisitProcedure ON VisitProcedure.VisitProcedureUid = ObservationOrder.VisitProcedureUid  
          INNER JOIN VisitProcedureDiagnosis ON VisitProcedureDiagnosis.VisitProcedureUid = VisitProcedure.VisitProcedureUid  
          INNER JOIN VisitDiagnosis ON VisitProcedureDiagnosis.VisitDiagnosisUid = VisitDiagnosis.VisitDiagnosisUid  
          WHERE ObservationOrder.ImedicaAccessionNumber = @ImedicaAccessionNumber  
               AND VisitProcedure.ProcedureUid = @ProcedureUid  
               AND VisitProcedureDiagnosis.DisplayOrder<>0
          ORDER BY VisitDiagnosis.DisplayOrder  
   END

       
   IF LEN(@Diag) >1  
      SET @Diag =SUBSTRING(@Diag,1,LEN(@Diag)-1)  
   RETURN @Diag  
END  
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getMaxDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getMaxDate]
(
	@arg1 AS DATETIME,
	@arg2 AS DATETIME
)
RETURNS DATETIME
AS
BEGIN
	RETURN CASE
		WHEN @arg1 >= @arg2 or @arg2 is NULL THEN @arg1
		WHEN @arg2 > @arg1 or @arg1 is NULL THEN @arg2
		ELSE NULL
	END
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMD5Hash]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetMD5Hash](@SourceString varchar(8000), @Modulo INT = 0)
	RETURNS INTEGER
AS
BEGIN
	IF @Modulo = 0
		RETURN CAST(HashBytes( ''MD5'', @SourceString) AS INTEGER)
	ELSE
		RETURN ABS(CAST(HashBytes( ''MD5'', @SourceString) AS INTEGER)) % @Modulo
	RETURN 0
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMemberList_SR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE Function [dbo].[GetMemberList_SR](@UID uniqueIdentifier)
Returns Varchar(2000)
AS
Begin
	Declare @List Varchar(2000)
	Set @List=null
	
	SELECT	
			@List=COALESCE(@List + '', '' , '''') + Replace(fuug.Name,'','','' '')
	FROM	UserGroupMember ugm CROSS JOIN ViewFindUserAndUserGroup fuug
	WHERE	ugm.UserGroupUid = @UID AND
			((ugm.MemberUserUid = fuug.Uid AND fuug.ForeignKeyIndex = 1) OR
			 (ugm.MemberUserGroupUid = fuug.Uid AND fuug.ForeignKeyIndex = 2))

	Return @List
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedPreferredName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION [dbo].[UDF_getFormattedPreferredName]
(
        @PersonUid UNIQUEIDENTIFIER
)
RETURNS  VARCHAR(100)

AS
BEGIN

        DECLARE @PreferredName VARCHAR(100)

        SELECT @PreferredName = FormattedPreferredName
                
        FROM ViewPerson WHERE PersonUid = @PersonUid

        RETURN @PreferredName
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMessageAssignedTo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetMessageAssignedTo] (@messageUid uniqueidentifier) RETURNS VARCHAR(8000) AS
BEGIN
	DECLARE @assignedTo varchar(8000)
	DECLARE	@userUid uniqueidentifier
	DECLARE @userGroupUid uniqueidentifier

	SET @assignedTo = ''''
	
	DECLARE cur CURSOR FAST_FORWARD LOCAL FOR
		SELECT	UserUid, UserGroupUid FROM MessageUser WHERE MessageUid = @messageUid

	OPEN cur

	FETCH NEXT FROM cur INTO @userUid, @userGroupUid
	WHILE @@FETCH_STATUS = 0  
	BEGIN   
		IF @assignedTo <> ''''
			SET @assignedTo = @assignedTo + '';''
			
		IF NOT @userUid IS NULL
			SET @assignedTo = @assignedTo + RTRIM(dbo.UDF_getFormattedPreferredName(@userUid))
		ELSE
			SET @assignedTo = @assignedTo + RTRIM((SELECT [Name] FROM ListUserGroup WHERE UserGroupUid = @userGroupUid))

		FETCH NEXT FROM cur INTO @userUid, @userGroupUid
	END

	CLOSE cur
	DEALLOCATE cur

	RETURN @assignedTo
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetModifierForSuperbillProcedure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetModifierForSuperbillProcedure]
(
	@SuperbillProcedureUID UniqueIdentifier
) Returns Varchar(1000)
AS
Begin
	Declare @Modifier Varchar(1000)
		
	SELECT 
		@Modifier= COALESCE(@Modifier + '', '','''') + LPM.Modifier 
	FROM
		SuperbillProcedureModifier SPM
	LEFT JOIN
		ListProcedureModifier LPM
	ON
		LPM.ProcedureModifierUID=SPM.ProcedureModifierUID
	WHERE
		SPM.SuperbillProcedureUID=@SuperbillProcedureUID
	ORDER BY
		SPM.DisplayOrder
	
	Return @Modifier
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetModifiers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetModifiers]( @visitProcedureUid uniqueidentifier) RETURNS VARCHAR(100) AS 
	BEGIN
	
	DECLARE @modifiers varchar(100)
	DECLARE @modifier varchar(100)
	
	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier1Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @visitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END
		
	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier2Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @VisitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END

	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier3Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @VisitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END

	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier4Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @VisitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END
		
	RETURN @modifiers
	END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNestedGroups]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetNestedGroups]	(
	@IncludeParent bit,
	@UserGroupUid UniqueIdentifier	
)
RETURNS  @retTable TABLE (UserGroupUid UniqueIdentifier)
AS
BEGIN
	IF (@IncludeParent=1) 
	BEGIN
		INSERT INTO @retTable values(@UserGroupUid)
 	END

	DECLARE @lUserGroupUid UniqueIdentifier

	DECLARE RetrieveUserGroups CURSOR STATIC LOCAL FOR
	SELECT MemberUserGroupUid FROM UserGroupMember WHERE 
		UserGroupUid = @UserGroupUid and MemberUserGroupUid is not null

	OPEN RetrieveUserGroups

	FETCH NEXT FROM RetrieveUserGroups
	INTO @lUserGroupUid

	WHILE (@@FETCH_STATUS = 0) 
	BEGIN
		INSERT INTO @retTable values(@lUserGroupUid)
  
		INSERT INTO @retTable
		select * from dbo.GetNestedGroups(0, @lUserGroupUid)
   
		FETCH NEXT FROM RetrieveUserGroups
		INTO @lUserGroupUid
	END
	
	CLOSE RetrieveUserGroups
	DEALLOCATE RetrieveUserGroups

RETURN
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPatientBMIPercentile]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPatientBMIPercentile]
(	
	@ObservationValueUid UNIQUEIDENTIFIER
)
RETURNS FLOAT
AS
BEGIN 

	/*
	This is built using the logic from the AgeInMonthsSinceBirth, ZValue and ZValueToPercent methods in GrowthChartPercent.cs
	*/

	DECLARE @BMIPercentile FLOAT
	DECLARE @a1 DECIMAL(10,10) = 0.0000053830, @a2 DECIMAL(10,10) = 0.0000488906, @a3 DECIMAL(10,10) = 0.0000380036 
			, @a4 DECIMAL(10,10) = 0.0032776263, @a5 DECIMAL(10,10) = 0.0211410061, @a6 DECIMAL(10,10) = 0.0498673470;
	DECLARE @Male UNIQUEIDENTIFIER = ''8202FCB6-C28D-4985-9FC4-0C92E35C2DFD''
			,@Female UNIQUEIDENTIFIER = ''E5DED511-EE8A-4B47-AA68-8FF9F74741A1''

	DECLARE @PatBMI TABLE (PatientUid UNIQUEIDENTIFIER
							,PerformDate DATE
							,PatBMI FLOAT
							)

	DECLARE @PatDetails TABLE (
						PatientUid UNIQUEIDENTIFIER
						,BirthDate DATE
						,EndDate DATE
						,AgeInMonthsCalc FLOAT
						,Gender SMALLINT
						,PatBMI FLOAT
						,PatBMIPower FLOAT
						,PatBMIPercent FLOAT
						,MGCAge FLOAT
						)


	INSERT INTO @PatBMI
	SELECT oo.PatientUid
			,oo.PerformDate
			,ov.ObservationValue AS BMI
	FROM ObservationOrder oo WITH(NOLOCK)
	INNER JOIN ObservationValue ov WITH(NOLOCK) on oo.ObservationOrderUid = ov.ObservationOrderUid AND ov.ObservationValueUid = @ObservationValueUid AND ov.ObservationItemUid = ''00000000-0000-0000-7777-100000000007'' 

	INSERT INTO @PatDetails (PatientUid, BirthDate, EndDate, AgeInMonthsCalc, Gender, PatBMI)
	SELECT PersonUid AS PatientUid
			,p.Birthdate AS BirthDate
			,e.PerformDate AS EndDate
			,((DATEDIFF(YEAR, Birthdate, e.PerformDate) * 12.0 + DATEPART(MONTH, e.PerformDate) - DATEPART(MONTH, p.Birthdate)) - 1.0)/*+.5*/ AS AgeInMonthsCalc
			,CASE WHEN p.GenderUid = @Male THEN 1
				WHEN p.GenderUid = @Female THEN 2
				ELSE 0 END AS Gender
			,PatBMI
	FROM @PatBMI e
	JOIN Person p WITH(NOLOCK) on e.PatientUid = p.PersonUid

	UPDATE pd
	SET AgeInMonthsCalc = AgeInMonthsCalc + (1 - ((DATEPART(DAY, BirthDate) - DATEPART(DAY, PerformDate)) / 30.0))
	FROM @PatDetails pd
	INNER JOIN @PatBMI e on pd.PatientUid = e.PatientUid

	UPDATE pd
	SET MGCAge = (SELECT TOP 1 AgeMos FROM MasterGrowthChart m WHERE m.AgeMos >= pd.AgeInMonthsCalc AND (m.Agemos+1) > pd.AgeInMonthsCalc)
	FROM @PatDetails pd

	UPDATE @PatDetails
	SET PatBMIPower = (POWER((p.PatBMI / m), l) - 1) / (l * s)
	FROM @PatDetails p
	JOIN MasterGrowthChart m WITH(NOLOCK) on p.MGCAge = m.Agemos 
		AND p.Gender = m.Gender
		AND m.DataType = ''BMI''

	UPDATE @PatDetails
	SET PatBMIPercent = (((((@a1 * ABS(PatBMIPower) + @a2) * ABS(PatBMIPower) + @a3) * ABS(PatBMIPower) + @a4) * ABS(PatBMIPower) + @a5) * ABS(PatBMIPower) + @a6) * ABS(PatBMIPower) + 1;

	UPDATE @PatDetails
	SET PatBMIPercent = POWER(PatBMIPercent, -16)

	UPDATE @PatDetails
	SET PatBMIPercent = (1 - PatBMIPercent / 2) * 100;

	UPDATE @PatDetails
	SET PatBMIPercent = 100-PatBMIPercent
	WHERE PatBMIPower < 0

	SELECT @BMIPercentile = ROUND(PatBMIPercent, 0)
	FROM @PatDetails

	RETURN @BMIPercentile

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_utcToCurrentDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_utcToCurrentDate] 
(@utcDate DATETIME)  
RETURNS 
	DATETIME
AS  
BEGIN 
Return	dbo.Date_UTCToLocal_Practice(@utcDate)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientBp]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientBp] -- Returns like 1:30 One and half an hour
(
	@PateintUid Uniqueidentifier,
	@Type VarChar(1)
)
RETURNS DECIMAL(10,2)

BEGIN
	Declare @Bp DECIMAL(10,2)
	Select TOP 1 @Bp= (CASE WHEN @Type=''S'' THEN Metricvalue1 ELSE Metricvalue2 END)
	From [MDOL_RPT2_ViewPatientBP] 
	Where PatientUid=@PateintUid
	Order By MeasureDate Desc,Metricvalue1 ASC, Metricvalue2 ASC
	Return @Bp
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientBP2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientBP2] -- Returns like 1:30 One and half an hour
(
	@PateintUid Uniqueidentifier,
	@StartDate datetime=NULL,
	@EndDate datetime=NULL,
	@Type VarChar(1)
)
RETURNS DECIMAL(10,2)

BEGIN
	Declare @Bp DECIMAL(10,2)
	Select TOP 1 @Bp= (CASE WHEN @Type=''S'' THEN Metricvalue1 ELSE Metricvalue2 END)
	From [MDOL_RPT2_ViewPatientBP] 
	Where PatientUid=@PateintUid
	and (@StartDate IS NULL OR MeasureDate  >= @StartDate) AND (@EndDate IS NULL OR MeasureDate  <@EndDate)
	and Metricvalue1 != 0 and Metricvalue2 != 0
	Order By MeasureDate Desc,Metricvalue1 ASC, Metricvalue2 ASC
	Return @Bp
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPatientCareManagementNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPatientCareManagementNames](@PatientCareManagementUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + 
				dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	PatientCareManagement pcm INNER JOIN ViewProvider p ON pcm.ProviderUid = p.PersonUid
		WHERE	pcm.PatientCareManagementUid = @PatientCareManagementUid	
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + dbo.GetDiagnosisCodeAndName(rel.Code9, rel.Code10, rel.CodeDescription)
		FROM	RelPatientCareManagementDiagnosis rel
		WHERE	rel.PatientCareManagementUid = @PatientCareManagementUid
		
	RETURN @names
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPatientCondition]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[GetPatientCondition](@PersonUid uniqueidentifier) RETURNS VARCHAR(MAX) AS
BEGIN
	-- Retrieves all associated patient conditions for a patient. Conditions are delimited by '';'' and is returned as a string.
	IF @PersonUid IS NULL
		RETURN NULL
		
	DECLARE @conditions VARCHAR(MAX)
	
	DECLARE @cur CURSOR;
	DECLARE @PatientConditionUid uniqueidentifier;
	DECLARE @conditionName VARCHAR(255);	
	DECLARE @rowCnt int;	
	DECLARE @cnt int;

	BEGIN
		SET @conditions = NULL;
		Set @rowCnt = 1;

		--determine how many rows will be processed		
		SELECT @cnt = COUNT(*) FROM RelPatientCondition WHERE PatientUid = @PersonUid
	
		SET @cur = CURSOR FOR
		SELECT PatientConditionUid FROM RelPatientCondition WHERE PatientUid = @PersonUid ORDER BY DisplayOrder ASC

		OPEN @cur 
		FETCH NEXT FROM @cur 
		INTO @PatientConditionUid
		
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @conditionName = Name FROM ListPatientCondition lpc WHERE lpc.PatientConditionUid = @PatientConditionUid
			IF(LEN(@conditionName) > 0)
			BEGIN
				IF (@conditions IS NOT NULL)
					Set @conditions = @conditions + @conditionName
				ELSE
					Set @conditions = @conditionName

				IF(@rowCnt < @cnt)
					Set @conditions = @conditions + ''; ''

				Set @rowCnt = @rowCnt + 1					
			END
			FETCH NEXT FROM @cur 
			INTO @PatientConditionUid
		END; 

		CLOSE @cur ;
		DEALLOCATE @cur;
	END;
			
	RETURN @conditions
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientDemographicsComment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getPatientDemographicsComment]
(
 @VisitUid VARCHAR(50),
 @PatientUid VARCHAR(50),
 @TrackingNum VARCHAR(50)  =null
)

RETURNS VARCHAR(MAX)
AS
BEGIN
	DECLARE @NOTES VARCHAR(MAX)
	SELECT TOP 1 @NOTES=NOTES
	FROM ObservationOrder 
	WHERE NOTES LIKE ''%<Patient Demographics Comment>%</Patient Demographics Comment>%'' 
	  AND VisitUid=@VisitUid 
	  AND PatientUid=@PatientUid 
	  AND (TrackingNum=@TrackingNum OR TrackingNum is null)
	  AND IsDelete = 0
	
	Declare @CidxStart int 
    Declare @CidxEnd int
    Set @CidxStart = charindex(''<Patient Demographics Comment>'',@NOTES,1)  
    Set @CidxEnd = charindex(''</Patient Demographics Comment>'',@NOTES,1)
    IF @CidxEnd >30 AND @CidxStart >0
		SELECT @NOTES=Substring(@NOTES, @CidxStart+30, @CidxEnd-@CidxStart-30) 
	ELSE
		SET @NOTES=''''	
	RETURN @NOTES
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientDiastolic_Adult_Diabetes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getPatientDiastolic_Adult_Diabetes] -- Returns like 1:30 One and half an hour
(
	@VisitUid Uniqueidentifier
)
RETURNS DECIMAL(10,2)

BEGIN
	Declare @Diastolic DECIMAL(10,2)
	Select Top 1 @Diastolic=Metricvalue2 From ObservationValue Where Visituid=@VisitUid And ObservationItemuid=''00000000-0000-0000-7777-100000000073'' AND MetricValue2 IS NOT NULL AND IsVitals = 1
	Return @Diastolic
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientLabResultsTable]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientLabResultsTable]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@ObservationItem1Uid varchar(max)= NULL --Modified to use observation item instead of 
	 ,@ObservationItem1Range varchar(max)
	 ,@LogicOpr1 bit=0
	 ,@ObservationItem2Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem2Range varchar(max) = NULL
	 ,@LogicOpr2 bit=0
	 ,@ObservationItem3Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem3Range varchar(max) = NULL
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL 
	 ,@LaboratoryUid varchar(max) = NULL
)
RETURNS  --  VARCHAR(Max)
  @ReturnTable TABLE (
		ResultList varchar(MAX),
		ProviderList varchar(MAX)
  )
  AS
BEGIN
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''
		DECLARE @ProviderResultList VARCHAR(Max) = ''N/A''

		IF @LaboratoryUid=''''
			SET @LaboratoryUid=NULL
		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate()) 
	
		--SELECT @LabResults_StartDate = dbo.getPracticeUTCDateTime (@LabResults_StartDate)
		--SELECT @LabResults_EndDate =  DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@LabResults_EndDate))
		
				
		DECLARE @ObservationItem1Start varchar(100)
		DECLARE @ObservationItem1End varchar(100)
		
		Set @ObservationItem1Start = ''0''
		Set @ObservationItem1End = ''999''
		
		If( @ObservationItem1Range IS NOT NULL AND LEN( @ObservationItem1Range) > 0 )
		BEGIN
			select @ObservationItem1Start = Element from Split(@ObservationItem1Range,''-'') where ElementID = 1
			select @ObservationItem1End = Element from Split(@Observatio