<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:sdtc="urn:hl7-org:sdtc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 http://xreg2.nist.gov:8080/hitspValidation/schema/cdar2c32/infrastructure/cda/C32_CDA.xsd" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"   xmlns:ms="urn:schemas-microsoft-com:xslt"  xmlns:dt="urn:schemas-microsoft-com:datatypes">
  <xsl:output method="xml" omit-xml-declaration="no" indent="yes"/>
  <xsl:template match="CCD">
    <ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:sdtc="urn:hl7-org:sdtc"  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 http://xreg2.nist.gov:8080/hitspValidation/schema/cdar2c32/infrastructure/cda/C32_CDA.xsd">
      <realmCode code='US'/>
      <typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
      <templateId assigningAuthorityName="CDA/R2" root="2.16.840.1.113883.3.27.1776"/>
      <templateId assigningAuthorityName="CCD" root="2.16.840.1.113883.10.20.1"/>
      <templateId assigningAuthorityName="HITSP/C32" root="2.16.840.1.113883.3.88.11.32.1"/>
      <templateId root="2.16.840.1.113883.10.20.3"/>
      <templateId root="1.3.6.1.4.1.19376.1.5.3.1.1.1"/>
      <id extension="PRM C32" assigningAuthorityName="Aprima PRM C32">
        <xsl:attribute name="root">
          <xsl:value-of select="messageuid" />
        </xsl:attribute>
      </id>
      <code code="34133-9" codeSystem="2.16.840.1.113883.6.1" displayName="Summarization of episode note" codeSystemName="LOINC"/>
      <title>
        <xsl:value-of select="messagename"/>
      </title>
      <effectiveTime>
        <xsl:attribute name="value">
          <xsl:value-of select="DocumentDateTime" />
          <xsl:if test="Header/organization/timeZone > 0">
            <xsl:text>+</xsl:text>
          </xsl:if>
          <xsl:value-of select="format-number(Header/organization/timeZone, '00')" />
          <xsl:text>00</xsl:text>
        </xsl:attribute>
      </effectiveTime>
      <confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
      <languageCode code="en-US"/>
      <xsl:apply-templates select="//Header"/>
      <component>
        <structuredBody>
          <xsl:apply-templates select="Summary"/>
          <xsl:apply-templates select="Alerts"/>
          <xsl:apply-templates select="Problem"/>
          <xsl:apply-templates select="Medication"/>
          <xsl:apply-templates select="Immunizations"/>
          <xsl:apply-templates select="Result"/>
          <xsl:apply-templates select="Procedure"/>
        </structuredBody>
      </component>
    </ClinicalDocument>
  </xsl:template>
  <xsl:template name="Header"  match="//Header">
    <recordTarget>
      <patientRole>
        <id root="2.16.840.1.113883.19.5">
          <xsl:attribute name="extension">
            <xsl:value-of select="patient/externalID" />
          </xsl:attribute>
        </id>
        <xsl:for-each select="patient/address">
          <!--<xsl:if test="streetAddress1=''">
            <addr/>
          </xsl:if>-->
          <xsl:if test="streetAddress1 != ''">
            <addr use="HP">
              <xsl:if test="streetAddress1 != ''">
                <streetAddressLine>
                  <xsl:value-of select="streetAddress1"/>
                </streetAddressLine>
              </xsl:if>
              <xsl:if test="streetAddress2 != ''">
                <streetAddressLine>
                  <xsl:value-of select="streetAddress2"/>
                </streetAddressLine>
              </xsl:if>
              <xsl:if test="city != ''">
                <city>
                  <xsl:value-of select="city"/>
                </city>
              </xsl:if>
              <xsl:if test="state != ''">
                <state>
                  <xsl:value-of select="state"/>
                </state>
              </xsl:if>
              <xsl:if test="postalCode != ''">
                <postalCode>
                  <xsl:value-of select="postalCode"/>
                </postalCode>
              </xsl:if>
              <xsl:if test="country != ''">
                <country>
                  <xsl:value-of select="country"/>
                </country>
              </xsl:if>
              <xsl:if test="country = ''">
                <country>US</country>
              </xsl:if>
            </addr>
          </xsl:if>
        </xsl:for-each>
        <xsl:if test="patient/address/streetAddress1=''">
          <addr>
            <streetAddressLine/>
            <city/>
            <state/>
            <postalCode/>
            <country>US</country>
          </addr>
        </xsl:if>
        <xsl:for-each select="patient/phonenumber">
          <xsl:if test=". = ''">
            <telecom/>
          </xsl:if>
          <xsl:if test=". != ''">
            <telecom>
              <xsl:attribute name="value">
                <xsl:value-of select="." />
              </xsl:attribute>
            </telecom>
          </xsl:if>
        </xsl:for-each>
        <xsl:for-each select="patient/email">
          <xsl:if test=". != ''">
            <telecom>
              <xsl:attribute name="value">
                <xsl:text>mailto:</xsl:text>
                <xsl:value-of select="." />
              </xsl:attribute>
            </telecom>
          </xsl:if>
        </xsl:for-each>
        <patient>
          <name use="L">
            <prefix qualifier="AC">
              <xsl:value-of select="//patient/name/prefix"/>
            </prefix>
            <given qualifier="BR">
              <xsl:value-of select="//patient/name/given"/>
            </given>
            <family qualifier="CL">
              <xsl:value-of select="//patient/name/family"/>
            </family>
            <suffix qualifier="AC">
              <xsl:value-of select="//patient/name/suffix"/>
            </suffix>
          </name>
          <xsl:if test="//patient/alisename/given != '' or //patient/alisename/family != ''">
            <name use="P">
              <xsl:if test="//patient/alisename/given != ''">
                <given>
                  <xsl:value-of select="//patient/alisename/given"/>
                </given>
              </xsl:if>
              <xsl:if test="//patient/alisename/family != ''">
                <family>
                  <xsl:value-of select="//patient/alisename/family"/>
                </family>
              </xsl:if>
            </name>
          </xsl:if>
          <administrativeGenderCode codeSystem="2.16.840.1.113883.5.1">
            <xsl:attribute name="code">
              <xsl:value-of select="//patient/genderCode" />
            </xsl:attribute>
            <xsl:attribute name="displayName">
              <xsl:value-of select="//patient/genderCodeDisplayName" />
            </xsl:attribute>
          </administrativeGenderCode>
          <xsl:if test="patient/birthTime!=''">
            <birthTime>
              <xsl:attribute name="value">
                <xsl:value-of select="patient/birthTime" />
              </xsl:attribute>
            </birthTime>
          </xsl:if>
          <xsl:if test="patient/maritalStatusCode !=''">
            <maritalStatusCode codeSystem="2.16.840.1.113883.5.2">
              <xsl:attribute name="code">
                <xsl:value-of select="patient/maritalStatusCode" />
              </xsl:attribute>
              <xsl:attribute name="displayName">
                <xsl:value-of select="patient/maritalStatusCodeDisplayName" />
              </xsl:attribute>
            </maritalStatusCode>
          </xsl:if>
          <!--<xsl:if test="patient/maritalStatusCode =''">
						<maritalStatusCode nullFlavor="UNK"/>
					</xsl:if>-->
          <xsl:if test="patient/raceCode !=''">
            <raceCode codeSystem="2.16.840.1.113883.6.238">
              <xsl:attribute name="code">
                <xsl:value-of select="patient/raceCode" />
              </xsl:attribute>
              <xsl:attribute name="displayName">
                <xsl:value-of select="patient/raceCodeDisplayName" />
              </xsl:attribute>
            </raceCode>
          </xsl:if>
          <!--<xsl:if test="patient/raceCode =''">
						<raceCode nullFlavor="UNK"/>
					</xsl:if>-->
          <xsl:if test="patient/ethnicGroupCode !=''">
            <ethnicGroupCode codeSystem="2.16.840.1.113883.6.238">
              <xsl:attribute name="code">
                <xsl:value-of select="patient/ethnicGroupCode" />
              </xsl:attribute>
              <xsl:attribute name="displayName">
                <xsl:value-of select="patient/ethnicGroupCodeDisplayName" />
              </xsl:attribute>
            </ethnicGroupCode>
          </xsl:if>
          <!--<xsl:if test="patient/ethnicGroupCode =''">
						<ethnicGroupCode nullFlavor="UNK"/>
					</xsl:if>-->
          <xsl:if test="patient/guarantor/name/given != '' and patient/guarantor/name/family != ''">
            <guardian classCode="GUARD">
              <templateId root='2.16.840.1.113883.3.88.11.83.3'/>
              <templateId root='1.3.6.1.4.1.19376.1.5.3.1.2.4'/>
              <xsl:if test ="patient/guarantor/responsiblePartyRelationshipCode !=''">
                <code codeSystem="2.16.840.1.113883.5.111">
                  <xsl:attribute name="code">
                    <xsl:value-of select="patient/guarantor/responsiblePartyRelationshipCode" />
                  </xsl:attribute>
                  <xsl:attribute name="displayName">
                    <xsl:value-of select="patient/guarantor/responsiblePartyRelationshipName" />
                  </xsl:attribute>
                </code>
              </xsl:if>
              <xsl:for-each select="patient/guarantor/phonenumber">
                <xsl:if test=". != ''">
                  <telecom>
                    <xsl:attribute name="value">
                      <xsl:value-of select="." />
                    </xsl:attribute>
                  </telecom>
                </xsl:if>
              </xsl:for-each>
              <xsl:for-each select="patient/guarantor/email">
                <xsl:if test=". != ''">
                  <telecom>
                    <xsl:attribute name="value">
                      <xsl:text>mailto:</xsl:text>
                      <xsl:value-of select="." />
                    </xsl:attribute>
                  </telecom>
                </xsl:if>
              </xsl:for-each>
              <xsl:if test ="patient/guarantor/address/streetAddress1 = ''">
                <addr nullFlavor="ASKU"/>
              </xsl:if>
              <xsl:if test ="patient/guarantor/address/streetAddress1 !=''">
                <addr>
                  <xsl:if test="patient/guarantor/address/streetAddress1 != ''">
                    <streetAddressLine>
                      <xsl:value-of select="patient/guarantor/address/streetAddress1"/>
                    </streetAddressLine>
                  </xsl:if>
                  <xsl:if test="patient/guarantor/address/streetAddress2 != ''">
                    <streetAddressLine>
                      <xsl:value-of select="patient/guarantor/address/streetAddress2"/>
                    </streetAddressLine>
                  </xsl:if>
                  <xsl:if test="patient/guarantor/address/city != ''">
                    <city>
                      <xsl:value-of select="patient/guarantor/address/city"/>
                    </city>
                  </xsl:if>
                  <xsl:if test="patient/guarantor/address/state != ''">
                    <state>
                      <xsl:value-of select="patient/guarantor/address/state"/>
                    </state>
                  </xsl:if>
                  <xsl:if test="patient/guarantor/address/postalcode != ''">
                    <postalCode>
                      <xsl:value-of select="patient/guarantor/address/postalcode"/>
                    </postalCode>
                  </xsl:if>
                  <xsl:if test="patient/guarantor/address/country != ''">
                    <country>
                      <xsl:value-of select="patient/guarantor/address/country"/>
                    </country>
                  </xsl:if>
                  <xsl:if test="patient/guarantor/address/country = ''">
                    <country>US</country>
                  </xsl:if>
                </addr>
              </xsl:if>

              <guardianPerson>
                <name>
                  <xsl:if test="patient/guarantor/name/prefix != ''">
                    <prefix>
                      <xsl:value-of select="patient/guarantor/name/prefix"/>
                    </prefix>
                  </xsl:if>
                  <given>
                    <xsl:value-of select="patient/guarantor/name/given"/>
                  </given>
                  <family>
                    <xsl:value-of select="patient/guarantor/name/family"/>
                  </family>
                  <xsl:if test="patient/guarantor/name/suffix != ''">
                    <suffix>
                      <xsl:value-of select="patient/guarantor/name/suffix"/>
                    </suffix>
                  </xsl:if>
                </name>
              </guardianPerson>
            </guardian>
          </xsl:if>
          <languageCommunication>
            <templateId root='2.16.840.1.113883.3.88.11.83.2'/>
            <templateId root='1.3.6.1.4.1.19376.1.5.3.1.2.1'/>
            <xsl:if test="patient/languageCode = ''">
              <languageCode nullFlavor="UNK"/>
            </xsl:if>
            <xsl:if test="patient/languageCode != ''">
              <languageCode>
                <xsl:attribute name="code">
                  <xsl:value-of select="patient/languageCode" />
                </xsl:attribute>
                <xsl:attribute name="displayName">
                  <xsl:value-of select="patient/languageCodeDisplayName" />
                </xsl:attribute>
              </languageCode>
            </xsl:if>
          </languageCommunication>
        </patient>
        <providerOrganization>
          <id root="2.16.840.1.113883.19.5"/>
          <name>
            <xsl:value-of select="//organization/name"/>
          </name>
          <xsl:for-each select="//organization/phonenumber">
            <xsl:if test=". != ''">
              <telecom>
                <xsl:attribute name="value">
                  <xsl:value-of select="." />
                </xsl:attribute>
              </telecom>
            </xsl:if>
            <xsl:if test="//organization/phonenumber =''">
              <telecom nullFlavor="ASKU"/>
            </xsl:if>
          </xsl:for-each>
          <addr use="HP">
            <streetAddressLine>
              <xsl:value-of select="//organization/address/streetAddress1"/>
              <xsl:value-of select="//organization/address/streetAddress2"/>
            </streetAddressLine>
            <city>
              <xsl:value-of select="//organization/address/city"/>
            </city>
            <state>
              <xsl:value-of select="//organization/address/state"/>
            </state>
            <postalCode>
              <xsl:value-of select="//organization/address/postalCode"/>
            </postalCode>
            <country>
              <xsl:value-of select="//organization/address/country"/>
            </country>
          </addr>
        </providerOrganization>
      </patientRole>
    </recordTarget>
    <!--<xsl:if test="//patient/PCP/name/given !=''">-->
    <author>
      <time>
        <xsl:attribute name="value">
          <xsl:value-of select="//DocumentDateTime" />
          <xsl:if test="//Header/organization/timeZone > 0">
            <xsl:text>+</xsl:text>
          </xsl:if>
          <xsl:value-of select="format-number(//Header/organization/timeZone, '00')" />
          <xsl:text>00</xsl:text>
        </xsl:attribute>
      </time>
      <assignedAuthor>
        <id>
          <xsl:if test="//patient/PCP/provideruid != ''">
            <xsl:attribute name="root">
              <xsl:value-of select="//patient/PCP/provideruid"/>
            </xsl:attribute>
          </xsl:if>
        </id>
        <xsl:if test="patient/PCP/addres/streetAddress1=''">
          <addr/>
        </xsl:if>
        <xsl:for-each select="patient/PCP/address">
          <xsl:if test="streetAddress1 != ''">
            <addr use="HP">
              <xsl:if test="streetAddress1 != ''">
                <streetAddressLine>
                  <xsl:value-of select="streetAddress1"/>
                </streetAddressLine>
              </xsl:if>
              <xsl:if test="streetAddress2 != ''">
                <streetAddressLine>
                  <xsl:value-of select="streetAddress2"/>
                </streetAddressLine>
              </xsl:if>
              <xsl:if test="city != ''">
                <city>
                  <xsl:value-of select="city"/>
                </city>
              </xsl:if>
              <xsl:if test="state != ''">
                <state>
                  <xsl:value-of select="state"/>
                </state>
              </xsl:if>
              <xsl:if test="postalCode != ''">
                <postalCode>
                  <xsl:value-of select="postalCode"/>
                </postalCode>
              </xsl:if>
              <xsl:if test="country != ''">
                <country>
                  <xsl:value-of select="country"/>
                </country>
              </xsl:if>
              <xsl:if test="country = ''">
                <country>US</country>
              </xsl:if>
            </addr>
          </xsl:if>
        </xsl:for-each>
        <addr/>
        <xsl:for-each select="//patient/PCP/phonenumber">
          <xsl:if test=". = ''">
            <telecom/>
          </xsl:if>
          <xsl:if test=". != ''">
            <telecom>
              <xsl:attribute name="value">
                <xsl:value-of select="." />
              </xsl:attribute>
            </telecom>
          </xsl:if>
        </xsl:for-each>
        <telecom/>
        <assignedPerson>
          <name>
            <prefix>
              <xsl:value-of select="//patient/PCP/name/prefix"/>
            </prefix>
            <given>
              <xsl:value-of select="//patient/PCP/name/given"/>
            </given>
            <family>
              <xsl:value-of select="//patient/PCP/name/family"/>
            </family>
            <suffix>
              <xsl:value-of select="//patient/PCP/name/suffix"/>
            </suffix>
          </name>
        </assignedPerson>
        <representedOrganization>
          <id root="2.16.840.1.113883.19.5"/>
          <name>
            <xsl:value-of select="//organization/name"/>
          </name>
          <xsl:for-each select="//organization/phonenumber">
            <xsl:if test=". != ''">
              <telecom>
                <xsl:attribute name="value">
                  <xsl:value-of select="." />
                </xsl:attribute>
              </telecom>
            </xsl:if>
            <xsl:if test="//organization/phonenumber =''">
              <telecom nullFlavor="ASKU"/>
            </xsl:if>
          </xsl:for-each>
          <xsl:if test ="//organization/address/streetAddress1 =''">
            <addr nullFlavor="ASKU"/>
          </xsl:if>
          <xsl:if test ="//organization/address/streetAddress1 !=''">
            <addr use="HP">
              <streetAddressLine>
                <xsl:value-of select="//organization/address/streetAddress1"/>
                <xsl:value-of select="//organization/address/streetAddress2"/>
              </streetAddressLine>
              <city>
                <xsl:value-of select="//organization/address/city"/>
              </city>
              <state>
                <xsl:value-of select="//organization/address/state"/>
              </state>
              <postalCode>
                <xsl:value-of select="//organization/address/postalCode"/>
              </postalCode>
              <country>
                <xsl:value-of select="//organization/address/country"/>
              </country>
            </addr>
          </xsl:if>
        </representedOrganization>
      </assignedAuthor>
    </author>
    <!--</xsl:if>-->
    <!--<informant>
			<assignedEntity>
				-->
    <!-- Root OID is the Personal Physicians HealthCare NPI. Extension is John's medical record number. -->
    <!--
				<id extension="598-0478001" root="2.16.840.1.113883.4.6.1942405782"/>
				<representedOrganization>
					-->
    <!-- OID is the Personal Physicians HealthCare NPI -->
    <!--
					<id root="2.16.840.1.113883.4.6.1942405782"/>
					<name>
						<xsl:value-of select="//organization/name"/>
					</name>
          <addr use="HP">
            <streetAddressLine>
              <xsl:value-of select="//organization/address/streetAddress1"/>
              <xsl:value-of select="//organization/address/streetAddress2"/>
            </streetAddressLine>
            <city>
              <xsl:value-of select="//organization/address/city"/>
            </city>
            <state>
              <xsl:value-of select="//organization/address/state"/>
            </state>
            <postalCode>
              <xsl:value-of select="//organization/address/postalCode"/>
            </postalCode>
            <country>
              <xsl:value-of select="//organization/address/country"/>
            </country>
          </addr>
          <xsl:for-each select="//organization/phonenumber">
            <xsl:if test=". != ''">
              <telecom>
                <xsl:attribute name="value">

                  <xsl:value-of select="." />
                </xsl:attribute>
              </telecom>
            </xsl:if>
            <xsl:if test="//organization/phonenumber =''">
              <telecom nullFlavor="ASKU"/>
            </xsl:if>
          </xsl:for-each>
        </representedOrganization>
			</assignedEntity>
		</informant>-->
    <custodian>
      <assignedCustodian>
        <representedCustodianOrganization>
          <id root="2.16.840.1.113883.19.5"/>
          <name>
            <xsl:value-of select="//organization/name"/>
          </name>
          <xsl:for-each select="//organization/phonenumber">
            <xsl:if test=". != ''">
              <telecom>
                <xsl:attribute name="value">
                  <xsl:value-of select="." />
                </xsl:attribute>
              </telecom>
            </xsl:if>
            <xsl:if test="//organization/phonenumber =''">
              <telecom nullFlavor="ASKU"/>
            </xsl:if>
          </xsl:for-each>
          <xsl:if test ="//organization/address/streetAddress1 =''">
            <addr nullFlavor="ASKU"/>
          </xsl:if>
          <xsl:if test ="//organization/address/streetAddress1 !=''">
            <addr use="HP">
              <streetAddressLine>
                <xsl:value-of select="//organization/address/streetAddress1"/>
                <xsl:value-of select="//organization/address/streetAddress2"/>
              </streetAddressLine>
              <city>
                <xsl:value-of select="//organization/address/city"/>
              </city>
              <state>
                <xsl:value-of select="//organization/address/state"/>
              </state>
              <postalCode>
                <xsl:value-of select="//organization/address/postalCode"/>
              </postalCode>
              <country>
                <xsl:value-of select="//organization/address/country"/>
              </country>
            </addr>
          </xsl:if>
        </representedCustodianOrganization>
      </assignedCustodian>
    </custodian>
    <!--<legalAuthenticator>
			<time>
				<xsl:attribute name="value">
					<xsl:value-of select="//CCD/DocumentDateTime" />
				</xsl:attribute>
			</time>
			<signatureCode code="S"/>
			<assignedEntity>
				<id nullFlavor="NI"/>
        <assignedPerson>
          <name>
            <prefix>
              <xsl:value-of select="patient/PCP/name/prefix"/>
            </prefix>
            <given>
              <xsl:value-of select="patient/PCP/name/given"/>
            </given>
            <family>
              <xsl:value-of select="patient/PCP/name/family"/>
            </family>
            <suffix>
              <xsl:value-of select="patient/PCP/name/suffix"/>
            </suffix>
          </name>
        </assignedPerson>
          <xsl:if test="//patient/PCP/address =''">
            <addr nullFlavor="ASKU"/>
          </xsl:if>
        <xsl:for-each select="patient/PCP/address">
          <xsl:if test="streetAddress1 != ''">
            <addr use="HP">
              <xsl:if test="streetAddress1 != ''">
                <streetAddressLine>
                  <xsl:value-of select="streetAddress1"/>
                </streetAddressLine>
              </xsl:if>
              <xsl:if test="streetAddress2 != ''">
                <streetAddressLine>
                  <xsl:value-of select="streetAddress2"/>
                </streetAddressLine>
              </xsl:if>
              <xsl:if test="city != ''">
                <city>
                  <xsl:value-of select="city"/>
                </city>
              </xsl:if>
              <xsl:if test="state != ''">
                <state>
                  <xsl:value-of select="state"/>
                </state>
              </xsl:if>
              <xsl:if test="postalCode != ''">
                <postalCode>
                  <xsl:value-of select="postalCode"/>
                </postalCode>
              </xsl:if>
              <xsl:if test="country != ''">
                <country>
                  <xsl:value-of select="country"/>
                </country>
              </xsl:if>
              <xsl:if test="country = ''">
                <country>US</country>
              </xsl:if>
            </addr>
          </xsl:if>
        </xsl:for-each>
        <xsl:if test="//patient/PCP/phonenumber =''">
          <telecom nullFlavor="ASKU"/>
        </xsl:if>
        <xsl:for-each select="patient/PCP/phonenumber">
          <xsl:if test=". != ''">
            <telecom>
              <xsl:attribute name="value">
                <xsl:value-of select="." />
              </xsl:attribute>
            </telecom>
          </xsl:if>
        </xsl:for-each>
        <xsl:for-each select="patient/PCP/email">
          <xsl:if test=". != ''">
            <telecom>
              <xsl:attribute name="value">
                <xsl:text>mailto:</xsl:text>
                <xsl:value-of select="." />
              </xsl:attribute>
            </telecom>
          </xsl:if>
        </xsl:for-each>        
				<representedOrganization>
					<id root="2.16.840.1.113883.19.5"/>
					<name>
						<xsl:value-of select="//organization/name"/>
					</name>
          <xsl:for-each select="//organization/phonenumber">
            <xsl:if test=". != ''">
              <telecom>
                <xsl:attribute name="value">
                  <xsl:value-of select="." />
                </xsl:attribute>
              </telecom>
            </xsl:if>
            <xsl:if test="//organization/phonenumber =''">
              <telecom nullFlavor="ASKU"/>
            </xsl:if>
          </xsl:for-each>
          <addr use="HP">
            <streetAddressLine>
              <xsl:value-of select="//organization/address/streetAddress1"/>
              <xsl:value-of select="//organization/address/streetAddress2"/>
            </streetAddressLine>
            <city>
              <xsl:value-of select="//organization/address/city"/>
            </city>
            <state>
              <xsl:value-of select="//organization/address/state"/>
            </state>
            <postalCode>
              <xsl:value-of select="//organization/address/postalCode"/>
            </postalCode>
            <country>
              <xsl:value-of select="//organization/address/country"/>
            </country>
          </addr>
        </representedOrganization>
			</assignedEntity>
		</legalAuthenticator>-->
    <xsl:apply-templates select="//participant" />
    <documentationOf>
      <serviceEvent classCode="PCPR">
        <effectiveTime>
          <low value="0000"/>
          <high value="2010"/>
          <!--<xsl:attribute name="value">
            <xsl:value-of select="ms:format-date(//CCD/DocumentDateTime,'yyyy')" />
          </xsl:attribute>
          </high>-->
        </effectiveTime>
        <!--<performer typeCode="PRF">
					<templateId root='2.16.840.1.113883.3.88.11.83.4'/>
          <templateId root='1.3.6.1.4.1.19376.1.5.3.1.2.3'/>
					<functionCode code="PP" displayName="Primary Care Provider" codeSystem="2.16.840.1.113883.12.443">
						<originalText>Primary Care Provider</originalText>
					</functionCode>
					<time>
            <low nullFlavor="UNK"/>
            <high nullFlavor="UNK"/>
					</time>
					<assignedEntity>
						<id extension="ProviderID">
							<xsl:if test="patient/PCP/provideruid != ''">
								<xsl:attribute name="root">
									<xsl:value-of select="patient/PCP/provideruid" />
								</xsl:attribute>
							</xsl:if>
						</id>
						<xsl:if  test ="patient/PCP/providertypecode != ''">
							<code codeSystem="2.16.840.1.113883.6.101" codeSystemName="ProviderCodes">
								<xsl:attribute name="code">
									<xsl:value-of select="patient/PCP/providertypecode" />
								</xsl:attribute>
								<xsl:attribute name="displayName">
									<xsl:value-of select="patient/PCP/providertypename" />
								</xsl:attribute>
							</code>
						</xsl:if>
						<xsl:if  test ="patient/PCP/providertypecode = ''">
							<code nullFlavor="NA" />
						</xsl:if>
            <xsl:if test="//patient/PCP/phonenumber =''">
              <telecom nullFlavor="ASKU"/>
            </xsl:if>
            <xsl:for-each select="patient/PCP/phonenumber">
              <xsl:if test=". != ''">
                <telecom>
                  <xsl:attribute name="value">
                    <xsl:value-of select="." />
                  </xsl:attribute>
                </telecom>
              </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="patient/PCP/email">
              <xsl:if test=". != ''">
                <telecom>
                  <xsl:attribute name="value">
                    <xsl:text>mailto:</xsl:text>
                    <xsl:value-of select="." />
                  </xsl:attribute>
                </telecom>
              </xsl:if>
            </xsl:for-each>
            <xsl:if test="//patient/PCP/address =''">
              <addr nullFlavor="ASKU"/>
            </xsl:if>
						<xsl:for-each select="patient/PCP/address">
							<xsl:if test="streetAddress1 != ''">
								<addr use="HP">
									<xsl:if test="streetAddress1 != ''">
										<streetAddressLine>
											<xsl:value-of select="streetAddress1"/>
										</streetAddressLine>
									</xsl:if>
									<xsl:if test="streetAddress2 != ''">
										<streetAddressLine>
											<xsl:value-of select="streetAddress2"/>
										</streetAddressLine>
									</xsl:if>
									<xsl:if test="city != ''">
										<city>
											<xsl:value-of select="city"/>
										</city>
									</xsl:if>
									<xsl:if test="state != ''">
										<state>
											<xsl:value-of select="state"/>
										</state>
									</xsl:if>
									<xsl:if test="postalCode != ''">
										<postalCode>
											<xsl:value-of select="postalCode"/>
										</postalCode>
									</xsl:if>
									<xsl:if test="country != ''">
										<country>
											<xsl:value-of select="country"/>
										</country>
									</xsl:if>
									<xsl:if test="country = ''">
										<country>US</country>
									</xsl:if>
								</addr>
							</xsl:if>
						</xsl:for-each>
            
						<assignedPerson>
							<name>
								<prefix>
									<xsl:value-of select="patient/PCP/name/prefix"/>
								</prefix>
								<given>
									<xsl:value-of select="patient/PCP/name/given"/>
								</given>
								<family>
									<xsl:value-of select="patient/PCP/name/family"/>
								</family>
								<suffix>
									<xsl:value-of select="patient/PCP/name/suffix"/>
								</suffix>
							</name>
						</assignedPerson>
						<representedOrganization>
							<id root="2.16.840.1.113883.19.5"/>
							<name>
								<xsl:value-of select="//organization/name"/>
							</name>
              <xsl:for-each select="//organization/phonenumber">
                <xsl:if test=". != ''">
                  <telecom>
                    <xsl:attribute name="value">

                      <xsl:value-of select="." />
                    </xsl:attribute>
                  </telecom>
                </xsl:if>
                <xsl:if test="//organization/phonenumber =''">
                  <telecom nullFlavor="ASKU"/>
                </xsl:if>
              </xsl:for-each>
              <addr use="HP">
                <streetAddressLine>
                  <xsl:value-of select="//organization/address/streetAddress1"/>
                  <xsl:value-of select="//organization/address/streetAddress2"/>
                </streetAddressLine>
                <city>
                  <xsl:value-of select="//organization/address/city"/>
                </city>
                <state>
                  <xsl:value-of select="//organization/address/state"/>
                </state>
                <postalCode>
                  <xsl:value-of select="//organization/address/postalCode"/>
                </postalCode>
                <country>
                  <xsl:value-of select="//organization/address/country"/>
                </country>
              </addr>
						</representedOrganization>
						<sdtc:patient>
							<sdtc:id>
								<xsl:attribute name="root">
									<xsl:value-of select="patient/PersonUid" />
								</xsl:attribute>
								<xsl:attribute name="extension">
									<xsl:value-of select="patient/externalID" />
								</xsl:attribute>
							</sdtc:id>
						</sdtc:patient>
					</assignedEntity>
				</performer>-->
      </serviceEvent>
    </documentationOf>
  </xsl:template>
  <xsl:template name="participant"  match="//participant">
    <xsl:if test="name/given != '' or corporationname != ''">
      <participant typeCode="IND">
        <templateId root='2.16.840.1.113883.3.88.11.83.3'/>
        <time>
          <low nullFlavor="UNK"/>
        </time>
        <associatedEntity>
          <xsl:attribute name="classCode">
            <xsl:value-of select="classCode" />
          </xsl:attribute>
          <id>
            <xsl:attribute name="root">
              <xsl:value-of select="accountResponsiblePartyUid" />
            </xsl:attribute>
          </id>
          <xsl:if test ="responsiblePartyRelationshipCode !=''">
            <code codeSystem="2.16.840.1.113883.5.111">
              <xsl:attribute name="code">
                <xsl:value-of select="responsiblePartyRelationshipCode" />
              </xsl:attribute>
              <xsl:attribute name="displayName">
                <xsl:value-of select="responsiblePartyRelationshipName" />
              </xsl:attribute>
            </code>
          </xsl:if>
          <xsl:for-each select="phonenumber">
            <xsl:if test =". !=''">
              <telecom>
                <xsl:attribute name="value">
                  <xsl:value-of select="." />
                </xsl:attribute>
              </telecom>
            </xsl:if>
          </xsl:for-each>
          <xsl:for-each select="email">
            <xsl:if test=". != ''">
              <telecom>
                <xsl:attribute name="value">
                  <xsl:text>mailto:</xsl:text>
                  <xsl:value-of select="." />
                </xsl:attribute>
              </telecom>
            </xsl:if>
          </xsl:for-each>
          <xsl:if test ="address/streetAddress1 !=''">
            <addr use="HP">
              <streetAddressLine>
                <xsl:value-of select="address/streetAddress1"/>
                <xsl:value-of select="address/streetAddress2"/>
              </streetAddressLine>
              <city>
                <xsl:value-of select="address/city"/>
              </city>
              <state>
                <xsl:value-of select="address/state"/>
              </state>
              <postalCode>
                <xsl:value-of select="address/postalcode"/>
              </postalCode>
              <country>
                <xsl:value-of select="address/country"/>
              </country>
            </addr>
          </xsl:if>
          <xsl:if test="name/given != ''">
            <associatedPerson>
              <name>
                <prefix>
                  <xsl:value-of select="name/prefix"/>
                </prefix>
                <given>
                  <xsl:value-of select="name/given"/>
                </given>
                <family>
                  <xsl:value-of select="name/family"/>
                </family>
                <suffix>
                  <xsl:value-of select="name/suffix"/>
                </suffix>
              </name>
            </associatedPerson>
          </xsl:if>
          <xsl:if test="corporationname != ''">
            <associatedPerson>
              <name>
                <xsl:value-of select="corporationname"/>
              </name>
            </associatedPerson>
            <!--<representedOrganization>
						<id root="2.16.840.1.113883.19.5"/>
						<name>
							<xsl:value-of select="name"/>
						</name>
					</representedOrganization>-->
          </xsl:if>
        </associatedEntity>
      </participant>
    </xsl:if>
  </xsl:template>
  <xsl:template name="Summary"  match="//Summary">
    <component>
      <section>
        <templateId root="2.16.840.1.113883.10.20.1.13" />
        <!-- Purpose section template -->
        <code code="48764-5" codeSystem="2.16.840.1.113883.6.1" />
        <title>Summary Purpose</title>
        <text>
          <xsl:if test="//purpose = ''">
            <xsl:text>Transfer of care</xsl:text>
          </xsl:if>
          <xsl:value-of select="//purpose"/>
        </text>
        <entry typeCode="DRIV">
          <act classCode="ACT" moodCode="EVN">
            <templateId root="2.16.840.1.113883.10.20.1.30" />
            <!-- Purpose activity template -->
            <code code="23745001" codeSystem="2.16.840.1.113883.6.96" displayName="Documentation procedure" />
            <statusCode code="completed" />
            <entryRelationship typeCode="RSON">
              <act classCode="ACT" moodCode="EVN">
                <code code="308292007" codeSystem="2.16.840.1.113883.6.96" displayName="Transfer of care"/>
                <statusCode code="completed" />
              </act>
            </entryRelationship>
          </act>
        </entry>
      </section>
    </component>
  </xsl:template>
  <xsl:template name="Medication" match="//Medication">
    <xsl:if test="MedicationEntry/medicationUid!=''">
      <component>
        <section>
          <templateId root="2.16.840.1.113883.10.20.1.8"/>
          <!-- Medications section template -->
          <code code="10160-0" codeSystem="2.16.840.1.113883.6.1"/>
          <title>Medications</title>
          <text>
            <table border="1" width="100%">
              <thead>
                <tr>
                  <th>Medication</th>
                  <th>Instructions</th>
                  <th>Start Date</th>
                  <th>Status</th>
                </tr>
              </thead>
              <tbody>
                <xsl:for-each  select ="MedicationEntry">
                  <tr>
                    <td>
                      <xsl:value-of select="brandName" />
                    </td>
                    <td>
                      <xsl:value-of select="doseQuantity" />
                      <xsl:text> </xsl:text>
                      <xsl:value-of select="doseUnit" />
                      <xsl:text> </xsl:text>
                      <xsl:value-of select="frequency" />
                    </td>
                    <td>
                      <xsl:value-of select="itemStartDate" />
                    </td>
                    <td>
                      <xsl:if test="isMaintenanceDrug = 'False'">
                        <xsl:value-of select="status"/>
                      </xsl:if>
                      <xsl:if test="isMaintenanceDrug = 'True'">
                        <xsl:text>Active</xsl:text>
                      </xsl:if>
                    </td>
                    <!--ItemStopDate.CompareTo(DateTime.Now.Date) "LESS THAN" 0 ? "No longer active" : "Active"-->
                  </tr>
                </xsl:for-each>
              </tbody>
            </table>
          </text>
          <!--<informant>
						<assignedEntity>
							<id extension="996-756-495" root="2.16.840.1.113883.19.5"/>
							<representedOrganization>
								<id root="2.16.840.1.113883.19.5"/>
								<name></name>
							</representedOrganization>
						</assignedEntity>
					</informant>-->
          <xsl:apply-templates select="MedicationEntry"/>
        </section>
      </component>
    </xsl:if>
  </xsl:template>
  <xsl:template name="MedicationEntry" match="//MedicationEntry">
    <entry typeCode="DRIV">
      <substanceAdministration classCode="SBADM" moodCode="INT">
        <templateId root='2.16.840.1.113883.10.20.1.24'/>
        <templateId root='2.16.840.1.113883.3.88.11.83.8'/>
        <templateId root='1.3.6.1.4.1.19376.1.5.3.1.4.7'/>
        <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.1" />
        <!-- Medication activity template -->
        <id>
          <xsl:attribute name="root">
            <xsl:value-of select="medicationUid" />
          </xsl:attribute>
        </id>
        <statusCode code="completed"/>
        <effectiveTime nullFlavor="UNK"/>
        <!--<text>
					<xsl:value-of select="freeTextSIG" />
					<reference value="PointerToTextInSection"/>
				</text>
				
				<effectiveTime xsi:type="IVL_TS">
					<low>
						<xsl:attribute name="value">
							<xsl:value-of select="itemStartDate" />
						</xsl:attribute>
					</low>
					<high>
						<xsl:attribute name="value">
							<xsl:value-of select="itemStopDate" />
						</xsl:attribute>
					</high>
				</effectiveTime>
				<effectiveTime xsi:type="EIVL_TS" operator="A">
					<event>
						<xsl:attribute name="code">
							<xsl:value-of select="frequency" />
						</xsl:attribute>
					</event>
				</effectiveTime>-->
        <xsl:if test="routeCode!=''">
          <routeCode codeSystem="2.16.840.1.113883.3.26.1.1" codeSystemName="NCI Thesaurus">
            <xsl:attribute name="code">
              <xsl:value-of select="routeCode" />
            </xsl:attribute>
            <xsl:attribute name="displayName">
              <xsl:value-of select="routeCode" />
            </xsl:attribute>
          </routeCode>
        </xsl:if>
        <xsl:if test="doseQuantity !=''">
          <doseQuantity>
            <xsl:attribute name="value">
              <xsl:value-of select="doseQuantity" />
            </xsl:attribute>
            <xsl:if test ="doseUnit !=''">
              <xsl:attribute name="unit">
                <xsl:value-of select="doseUnit" />
              </xsl:attribute>
            </xsl:if>
          </doseQuantity>
        </xsl:if>
        <!--<administrationUnitCode code="415215001" codeSystem="2.16.840.1.113883.3.26.1.1">
					<xsl:attribute name="displayName">
						<xsl:value-of select="doseUnit" />
					</xsl:attribute>
				</administrationUnitCode>-->
        <consumable>
          <manufacturedProduct>
            <templateId root="2.16.840.1.113883.3.88.11.32.9" assigningAuthorityName="HITSP C32"/>
            <templateId root="2.16.840.1.113883.10.20.1.53"/>
            <templateId root="2.16.840.1.113883.3.88.11.83.8.2"/>
            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.2"/>
            <!-- Product template -->
            <manufacturedMaterial>
              <!--<code codeSystem="2.16.840.1.113883.6.88">-->
              <code codeSystem="2.16.840.1.113883.6.88" codeSystemName="RxNorm">
                <xsl:if test="productName != ''">
                  <xsl:attribute name="displayName">
                    <xsl:value-of select="productName" />
                  </xsl:attribute>
                </xsl:if>
                <xsl:attribute name="code">
                  <xsl:value-of select="productCode" />
                </xsl:attribute>
                <originalText>
                  <reference>
                    <xsl:attribute name="value">
                      <xsl:value-of select="productName" />
                    </xsl:attribute>
                  </reference>
                </originalText>
              </code>
              <name>
                <xsl:value-of select="brandName" />
              </name>
            </manufacturedMaterial>
          </manufacturedProduct>
        </consumable>
        <entryRelationship typeCode="REFR">
          <observation classCode="OBS" moodCode="EVN">
            <templateId root="2.16.840.1.113883.10.20.1.47"/>
            <code code="33999-4" displayName="Status" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
            <value xsi:type="CE" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT">
              <xsl:attribute name="displayName">
                <xsl:if test="isMaintenanceDrug = 'False'">
                  <xsl:value-of select="status"/>
                </xsl:if>
                <xsl:if test="isMaintenanceDrug = 'True'">
                  <xsl:text>Active</xsl:text>
                </xsl:if>
              </xsl:attribute>
              <xsl:attribute name="code">
                <xsl:if test="status = 'Active' or isMaintenanceDrug = 'True'">
                  <xsl:text>55561003</xsl:text>
                </xsl:if>
                <xsl:if test="status != 'Active'">
                  <xsl:text>73425007</xsl:text>
                </xsl:if>
              </xsl:attribute>
            </value>
          </observation>
        </entryRelationship>
        <entryRelationship typeCode="REFR">
          <supply classCode="SPLY" moodCode="INT">
            <templateId root="2.16.840.1.113883.10.20.1.34" assigningAuthorityName="CCD"/>
            <templateId root="2.16.840.1.113883.3.88.11.32.11" assigningAuthorityName="HITSP/C32"/>
            <id/>
            <code code="8716-3" displayName="Vital signs" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
            <statusCode code="completed"/>
            <effectiveTime nullFlavor="UNK"/>
          </supply>
        </entryRelationship>
        <xsl:for-each select="indication">
          <entryRelationship typeCode="RSON">
            <observation classCode="OBS" moodCode="EVN">
              <templateId root='2.16.840.1.113883.10.20.1.28'/>
              <code codeSystem="2.16.840.1.113883.6.96" codeSystemName='SNOMED CT'>
                <xsl:attribute name="code">
                  <xsl:value-of select="diagnosisCode" />
                </xsl:attribute>
                <xsl:attribute name="displayName">
                  <xsl:value-of select="diagnosisName" />
                </xsl:attribute>
              </code>
              <statusCode code="completed"/>
            </observation>
          </entryRelationship>
        </xsl:for-each>
        <xsl:if test="relpatient/type/sequentialNumber !='' or relpatient/type/processed !=''">
          <entryRelationship typeCode='SUBJ'>
            <observation classCode='OBS' moodCode='EVN'>
              <templateId root="2.16.840.1.113883.3.88.11.32.10" assigningAuthorityName="HITSP C32"/>

              <code codeSystem='2.16.840.1.113883.6.96' codeSystemName='SNOMED CT'>
                <xsl:if test="relpatient/type/sequentialNumber !=''">
                  <xsl:attribute name="code">
                    <xsl:text>73639000</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="displayName">
                    <xsl:text>Prescription Drug</xsl:text>
                  </xsl:attribute>
                </xsl:if>
                <xsl:if test="relpatient/type/processed !=''">
                  <xsl:attribute name="code">
                    <xsl:text>329505003</xsl:text>
                  </xsl:attribute>
                  <xsl:attribute name="displayName">
                    <xsl:text>Over the counter products</xsl:text>
                  </xsl:attribute>
                </xsl:if>
              </code>
              <statusCode code='completed'/>
            </observation>
          </entryRelationship>
        </xsl:if>
        <xsl:if test ="comment != ''">
          <entryRelationship typeCode="SUBJ" inversionInd="true">
            <act classCode="ACT" moodCode="EVN">
              <templateId root="2.16.840.1.113883.10.20.1.40" assigningAuthorityName="CCD"/>
              <templateId root="2.16.840.1.113883.3.88.11.32.12" assigningAuthorityName="HITSP/C32"/>
              <code code="48767-8" displayName="Annotation Comment" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
              <text>
                <xsl:value-of select="comment" />
              </text>
            </act>
          </entryRelationship>
        </xsl:if>
      </substanceAdministration>
    </entry>
  </xsl:template>
  <xsl:template name="Alerts" match="Alerts">
    <xsl:if test="AlertsEntry/AlertEntryRelationship/questionUid!=''">
      <component>
        <section>
          <templateId root="2.16.840.1.113883.10.20.1.2"/>
          <!-- Alerts section template -->
          <code code="48765-2" codeSystem="2.16.840.1.113883.6.1"/>
          <title>Allergies, Adverse Reactions, Alerts</title>
          <text>
            <table border="1" width="100%">
              <thead>
                <tr>
                  <th>Substance</th>
                  <th>Reaction</th>
                  <th>Status</th>
                </tr>
              </thead>
              <tbody>
                <xsl:for-each select="AlertsEntry">
                  <xsl:if test="AlertEntryRelationship/questionName != ''">
                    <tr>
                      <td>
                        <xsl:value-of select="AlertEntryRelationship/questionName" />
                      </td>
                      <td>
                        <xsl:for-each select="AlertEntryRelationship">
                          <xsl:variable name="cur" select='position()' />
                          <xsl:if test="$cur != 1" >
                            <xsl:text>, </xsl:text>
                          </xsl:if>
                          <xsl:value-of select="answerName"/>
                        </xsl:for-each>
                      </td>
                      <td>
                        Active
                      </td>
                    </tr>
                  </xsl:if>
                </xsl:for-each>
              </tbody>
            </table>
          </text>
          <xsl:apply-templates select="AlertsEntry" />
        </section>
      </component>
    </xsl:if>
  </xsl:template>
  <xsl:template name="AlertsEntry" match="AlertsEntry">
    <xsl:if test="AlertEntryRelationship/questionName != ''">
      <entry typeCode="DRIV">
        <act classCode="ACT" moodCode="EVN">
          <templateId root='2.16.840.1.113883.10.20.1.27'/>
          <templateId root='2.16.840.1.113883.3.88.11.83.6'/>
          <templateId root='1.3.6.1.4.1.19376.1.5.3.1.4.5.3'/>
          <templateId root='1.3.6.1.4.1.19376.1.5.3.1.4.5.1'/>
          <!-- Problem act template -->
          <id>
            <xsl:if test="AlertEntryRelationship/questionUid != ''">
              <xsl:attribute name="root">
                <xsl:value-of select="AlertEntryRelationship/questionUid" />
              </xsl:attribute>
            </xsl:if>
            <xsl:if test="AlertEntryRelationship/questionUid = ''">
              <xsl:attribute name="nullFlavor">
                <xsl:text>NI</xsl:text>
              </xsl:attribute>
            </xsl:if>
          </id>
          <code nullFlavor="NA"/>
          <statusCode code="completed"/>
          <effectiveTime>
            <low nullFlavor="UNK"/>
            <high nullFlavor="UNK"/>
          </effectiveTime>
          <entryRelationship typeCode="SUBJ" inversionInd="false">
            <observation classCode="OBS" moodCode="EVN">
              <templateId root='2.16.840.1.113883.10.20.1.18'/>
              <templateId root='1.3.6.1.4.1.19376.1.5.3.1.4.5'/>
              <templateId root='1.3.6.1.4.1.19376.1.5.3.1.4.6'/>
              <templateId root='2.16.840.1.113883.10.20.1.28'/>
              <!-- Problem observation template - NOT episode template-->
              <id root="d11275e7-67ae-11db-bd13-0800200c9a66"/>
              <!--<code code="64572001" displayName="Condition" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>-->
              <code codeSystem="2.16.840.1.113883.6.96">
                <xsl:attribute name="code">
                  <xsl:value-of select="eventType" />
                </xsl:attribute>
                <xsl:attribute name="displayName">
                  <xsl:value-of select="eventTypeDisplayName" />
                </xsl:attribute>
              </code>
              <text>
                <reference value="#CondID-1"/>
                <xsl:value-of select="AlertEntryRelationship/questionName" />
              </text>
              <statusCode code="completed"/>
              <effectiveTime>
                <low nullFlavor="UNK"/>
                <high nullFlavor="UNK"/>
              </effectiveTime>
              <value xsi:type="CD" code="416098002" codeSystem="2.16.840.1.113883.6.96" displayName="Drug Allergy" codeSystemName="SNOMED CT"/>
              <participant typeCode='CSM'>
                <participantRole classCode='MANU'>
                  <playingEntity classCode='MMAT'>
                    <xsl:if test="AlertEntryRelationship/questionRxNormCode != ''">
                      <code codeSystem='2.16.840.1.113883.6.88' codeSystemName="RxNorm">
                        <xsl:attribute name="code">
                          <xsl:value-of select="AlertEntryRelationship/questionRxNormCode" />
                        </xsl:attribute>
                        <originalText>
                          <reference value='#substance'/>
                          <xsl:value-of select="AlertEntryRelationship/questionName" />
                        </originalText>
                      </code>
                    </xsl:if>
                    <xsl:if test="AlertEntryRelationship/questionUNIICode != '' and AlertEntryRelationship/questionRxNormCode = ''">
                      <code codeSystem='2.16.840.1.113883.3.88.12.80.20' codeSystemName="UNII">
                        <xsl:attribute name="code">
                          <xsl:value-of select="AlertEntryRelationship/questionUNIICode" />
                        </xsl:attribute>
                        <originalText>
                          <reference value='#substance'/>
                          <xsl:value-of select="AlertEntryRelationship/questionName" />
                        </originalText>
                      </code>
                    </xsl:if>
                    <xsl:if test="AlertEntryRelationship/questionRxNormCode = '' and AlertEntryRelationship/questionUNIICode = ''">
                      <code>
                        <originalText>
                          <reference value='#substance'/>
                          <xsl:value-of select="AlertEntryRelationship/questionName" />
                        </originalText>
                      </code>
                    </xsl:if>
                    <name></name>
                  </playingEntity>
                </participantRole>
              </participant>

              <entryRelationship typeCode="REFR">
                <observation classCode="OBS" moodCode="EVN">
                  <templateId root="2.16.840.1.113883.10.20.1.50"/>
                  <!-- Problem status observation template -->
                  <code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
                  <statusCode code="completed"/>
                  <value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96" displayName="Active"/>
                </observation>
              </entryRelationship>
            </observation>
          </entryRelationship>
          <!--<entryRelationship typeCode="SUBJ" inversionInd="false">
            <observation classCode="OBS" moodCode="EVN">
              <templateId root='2.16.840.1.113883.10.20.1.18'/>
              -->
          <!-- Alert observation template -->
          <!--
              <id>
                <xsl:attribute name="root">
                  <xsl:value-of select="AlertEntryRelationship/answerUid" />
                </xsl:attribute>
              </id>
              <code codeSystem="2.16.840.1.113883.6.96">
                <xsl:attribute name="code">
                  <xsl:value-of select="eventType" />
                </xsl:attribute>
                <xsl:attribute name="displayName">
                  <xsl:value-of select="eventTypeDisplayName" />
                </xsl:attribute>
              </code>
              <statusCode code="completed"/>
              <effectiveTime>
                <low nullFlavor="UNK"/>
              </effectiveTime>
              -->
          <!--<value xsi:type="CD" code="282100009" codeSystem="2.16.840.1.113883.6.96" displayName="Adverse reaction to substance"/>-->
          <!--
              <participant typeCode="CSM">
                <participantRole classCode="MANU">
                  <playingEntity classCode="MMAT">
                    -->
          <!--<code nullFlavor="NA"/>-->
          <!--
                    -->
          <!--<code codeSystem="2.16.840.1.113883.6.88">-->
          <!--
                    <code codeSystem='2.16.840.1.113883.6.88' codeSystemName="RxNorm">
                      <xsl:attribute name="code">
                        <xsl:value-of select="AlertEntryRelationship/questionCode" />
                      </xsl:attribute>
                      <xsl:attribute name="displayName">
                        <xsl:value-of select="AlertEntryRelationship/questionName" />
                      </xsl:attribute>
                      -->
          <!--<xsl:attribute name="code">
											  <xsl:value-of select="AlertEntryRelationship/questionCode" />
										  </xsl:attribute>-->
          <!--
                    </code>
                    <name>
                      <xsl:value-of select="AlertEntryRelationship/questionName" />
                    </name>
                  </playingEntity>
                </participantRole>
              </participant>
              <xsl:apply-templates select="AlertEntryRelationship"/>
            </observation>
          </entryRelationship>-->
        </act>
      </entry>
    </xsl:if>
  </xsl:template>
  <xsl:template name="AlertEntryRelationship" match="AlertEntryRelationship">
    <xsl:if test="answerName != ''">
      <entryRelationship typeCode="MFST" inversionInd="true">
        <observation classCode="OBS" moodCode="EVN">
          <templateId root='2.16.840.1.113883.10.20.1.54'/>
          <!-- Reaction observation template -->
          <code code="SEV" codeSystem="2.16.840.1.113883.5.4"/>
          <text>
            <reference value="#severity-1"/>
            <xsl:value-of select="answerName" />
          </text>
          <statusCode code="completed"/>
          <value xsi:type="CD" code="247472004" codeSystem="2.16.840.1.113883.6.96">
            <xsl:attribute name="displayName">
              <xsl:value-of select="answerName" />
            </xsl:attribute>
          </value>
          <!--<entryRelationship typeCode="SUBJ" inversionInd="true">
			<observation classCode="OBS" moodCode="EVN">
				<templateId root="2.16.840.1.113883.10.20.1.55" assigningAuthorityName="CCD"/>
				<code code="SEV" displayName="Severity" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
				<text>
					<reference value="#severity-1"/>xcvxv
				</text>
				<statusCode code="completed"/>
				<value xsi:type="CD" code="24484000" displayName="Severe" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
			</observation>
		</entryRelationship>-->
        </observation>
      </entryRelationship>
    </xsl:if>
  </xsl:template>
  <xsl:template name="Problem"  match="//Problem">
    <xsl:if test="//ProblemEntry/historyUid != ''">
      <component>
        <section>
          <templateId root="2.16.840.1.113883.10.20.1.11" />
          <templateId root="2.16.840.1.113883.3.88.11.83.103" />
          <templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.6"/>
          <code code="11450-4" codeSystem="2.16.840.1.113883.6.1" />
          <title>Problems</title>
          <text>
            <xsl:if test="//ProblemEntry != ''">
              <table border="1" width="100%">
                <thead>
                  <tr>
                    <th>Condition</th>
                    <th>Effective Dates</th>
                    <th>Condition Status</th>
                  </tr>
                </thead>
                <tbody>
                  <xsl:for-each select="//ProblemEntry">
                    <tr>
                      <td>
                        <xsl:value-of select="questionName" />
                      </td>
                      <td>
                        <xsl:value-of select="time/effectiveTime"/>
                        <xsl:if test ="time/effectiveTime = ''">
                          <xsl:text>Unknown</xsl:text>
                        </xsl:if>
                      </td>
                      <td>
                        <xsl:value-of select="conditionStatusCodeDisplayName" />
                      </td>
                    </tr>
                  </xsl:for-each>
                </tbody>
              </table>
            </xsl:if>
          </text>
          <xsl:apply-templates select="//ProblemEntry" />
        </section>
      </component>
    </xsl:if>
  </xsl:template>
  <xsl:template name="ProblemEntry"  match="//ProblemEntry">
    <entry typeCode="DRIV">
      <act classCode="ACT" moodCode="EVN">
        <templateId root='2.16.840.1.113883.10.20.1.27'/>
        <templateId root='2.16.840.1.113883.3.88.11.83.7'/>
        <templateId root='1.3.6.1.4.1.19376.1.5.3.1.4.5.1'/>
        <templateId root='1.3.6.1.4.1.19376.1.5.3.1.4.5.2'/>
        <!-- Problem act template -->
        <id>
          <xsl:attribute name="root">
            <xsl:value-of select="historyUid" />
          </xsl:attribute>
        </id>
        <code nullFlavor="NA"/>
        <statusCode code="completed"/>
        <effectiveTime>
          <low nullFlavor="UNK"/>
          <high nullFlavor="UNK"/>
        </effectiveTime>
        <entryRelationship typeCode="SUBJ" inversionInd="false">
          <observation classCode="OBS" moodCode="EVN" negationInd="false">
            <templateId root='2.16.840.1.113883.10.20.1.28'/>
            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.5"/>
            <!-- Problem observation template -->
            <id>
              <xsl:attribute name="root">
                <xsl:value-of select="questionUid" />
              </xsl:attribute>
            </id>
            <code codeSystem="2.16.840.1.113883.6.96">
              <xsl:attribute name="code">
                <xsl:value-of select="problemTypeCode" />
              </xsl:attribute>
              <xsl:attribute name="displayName">
                <xsl:value-of select="problemTypeCodeDisplayName" />
              </xsl:attribute>
            </code>
            <text>
              <reference value="#CondID-2"/>
              <xsl:value-of select="questionName" />
            </text>
            <statusCode code="completed"/>
            <effectiveTime>
              <xsl:if test ="time/effectiveTime != ''">
                <low>
                  <xsl:attribute name="value">
                    <xsl:value-of select="time/effectiveTime" />
                  </xsl:attribute>
                </low>
              </xsl:if>
              <xsl:if test ="time/effectiveTime = ''">
                <low nullFlavor="UNK"/>
              </xsl:if>
              <high nullFlavor="UNK"/>
            </effectiveTime>
            <value xsi:type="CD" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT">
              <xsl:attribute name="code">
                <xsl:value-of select="questionCode" />
              </xsl:attribute>
              <xsl:attribute name="displayName">
                <xsl:value-of select="questionName" />
              </xsl:attribute>
            </value>
            <!--<text>
							<xsl:value-of select="questionName" />
						</text>-->
            <entryRelationship typeCode="REFR">
              <observation classCode="OBS" moodCode="EVN">
                <templateId root="2.16.840.1.113883.10.20.1.50"/>
                <!-- Problem status observation template -->
                <code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
                <statusCode code="completed"/>
                 <xsl:if test="conditionStatusCode !=''">
                   <value xsi:type="CE" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT">
              <xsl:attribute name="code">
                <xsl:value-of select="conditionStatusCode" />
              </xsl:attribute>
              <xsl:attribute name="displayName">
                <xsl:value-of select="conditionStatusCodeDisplayName" />
              </xsl:attribute>
            </value>
          </xsl:if>
                <!--<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96" displayName="Active"/>-->
              </observation>
            </entryRelationship>
            <!--CC Start-->
            <!--<performer typeCode="PRF">
							<templateId root='2.16.840.1.113883.3.88.11.32.4'/>
							<functionCode code="RP" displayName="Rendering Provider" codeSystem="2.16.840.1.113883.12.443"/>
							<time>
								<low nullFlavor="UNK"/>
								<high nullFlavor="UNK"/>
							</time>
							<assignedEntity>
								<id extension="ProviderID">
									<xsl:attribute name="root">
										<xsl:value-of select="provideruid" />
									</xsl:attribute>
								</id>
								<xsl:if  test ="providertypecode != ''">
									<code codeSystem="2.16.840.1.113883.6.101" codeSystemName="ProviderCodes">
										<xsl:attribute name="code">
											<xsl:value-of select="providertypecode" />
										</xsl:attribute>
										<xsl:attribute name="code">
											<xsl:value-of select="providertypename" />
										</xsl:attribute>
									</code>
								</xsl:if>
								<assignedPerson>
									<name>
										<prefix>
											<xsl:value-of select="name/prefix"/>
										</prefix>
										<given>
											<xsl:value-of select="name/given"/>
										</given>
										<family>
											<xsl:value-of select="name/family"/>
										</family>
										<suffix>
											<xsl:value-of select="name/suffix"/>
										</suffix>
									</name>
								</assignedPerson>
								<representedOrganization>
									<id root="2.16.840.1.113883.19.5"/>
									<name>
										<xsl:value-of select="//organization/Name"/>
									</name>
								</representedOrganization>
							</assignedEntity>
						</performer>
						<entryRelationship typeCode="REFR">
							<observation classCode="OBS" moodCode="EVN">
								<templateId root='2.16.840.1.113883.10.20.1.50'/>
								-->
            <!--Problem status observation template-->
            <!--
								<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
								<statusCode code="completed"/>
								<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96">
									<xsl:attribute name="displayName">
										<xsl:value-of select="ConditionStatus" />
									</xsl:attribute>
								</value>
							</observation>
						</entryRelationship>-->
            <!--CC End-->
          </observation>
        </entryRelationship>
      </act>
    </entry>
  </xsl:template>
  <xsl:template name="Procedure" match="//Procedure">
    <xsl:if test="ProcedureEntry/questionUid != ''">
      <component>
        <section>
          <templateId root="2.16.840.1.113883.10.20.1.12"/>
          <!-- Procedures section template -->
          <code code="47519-4" codeSystem="2.16.840.1.113883.6.1"/>
          <title>Procedures</title>
          <text>
            <table border="1" width="100%">
              <thead>
                <tr>
                  <th>Procedure</th>
                  <th>Date</th>
                </tr>
              </thead>
              <tbody>
                <xsl:for-each select="//ProcedureEntry">
                  <tr>
                    <td>
                      <xsl:value-of select="questionName" />
                    </td>
                    <td>
                      <xsl:if test="dateTime !='' ">
                        <xsl:value-of select="dateTime" />
                      </xsl:if>
                      <xsl:if test="dateTime ='' ">
                        <xsl:text>DateTime(Free Text in iMedica)</xsl:text>
                      </xsl:if>
                    </td>
                  </tr>
                </xsl:for-each>
              </tbody>
            </table>
          </text>
          <xsl:apply-templates select="//ProcedureEntry"/>
        </section>
      </component>
    </xsl:if>
  </xsl:template>
  <xsl:template name="ProcedureEntry" match="//ProcedureEntry">
    <entry typeCode="DRIV">
      <procedure classCode="PROC" moodCode="EVN">
        <templateId root="2.16.840.1.113883.10.20.1.29"/>
        <!-- Procedure activity template -->
        <id>
          <xsl:attribute name="root">
            <xsl:value-of select="questionUid" />
          </xsl:attribute>
        </id>
        <!--<code codeSystem="2.16.840.1.113883.6.96">
          <xsl:attribute name="code">
            <xsl:if test="questionCode !=''">
              <xsl:value-of select="questionCode" />
            </xsl:if>
            <xsl:if test="questionCode ='' or count(questionCode)=0">
              <xsl:text>…</xsl:text>
            </xsl:if>
          </xsl:attribute>
          <xsl:attribute name="displayName">
            <xsl:value-of select="questionName" />
          </xsl:attribute>-->
        <!--<code codeSystem="2.16.840.1.113883.6.96" code="55607006" displayName="Problem">-->
        <code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" code="47519-4" displayName="History of Procedures">
          <originalText>
            <reference>
              <xsl:attribute name="value">
                <xsl:value-of select="questionCode" />
              </xsl:attribute>
            </reference>
            <xsl:value-of select="questionName" />
          </originalText>
        </code>
        <statusCode code="completed"/>

        <effectiveTime>
          <xsl:if test="dateTime !='' ">
            <low>
              <xsl:attribute name="value">
                <xsl:value-of select="dateTime" />
              </xsl:attribute>
            </low>
          </xsl:if>
          <xsl:if test="dateTime ='' ">
            <low nullFlavor="UNK"/>
          </xsl:if>
        </effectiveTime>

        <!--<participant typeCode="DEV">
					<participantRole classCode="MANU">
						<templateId root="2.16.840.1.113883.10.20.1.52"/>
						-->
        <!-- Product instance template -->
        <!--
						<id root="03ca01b0-7be1-11db-9fe1-0800200c9a66"/>
						<scopingEntity/>
					</participantRole>
				</participant>-->
      </procedure>
    </entry>
  </xsl:template>
  <xsl:template name="Immunizations"  match="//Immunizations">
    <xsl:if test="ImmunizationEntry/VaccineName != ''">
      <component>
        <section>
          <templateId root="2.16.840.1.113883.10.20.1.6"/>
          <!-- Immunizations section template -->
          <code code="11369-6" codeSystem="2.16.840.1.113883.6.1"/>
          <title>Immunizations</title>
          <text>
            <table border="1" width="100%">
              <thead>
                <tr>
                  <th>Vaccine</th>
                  <th>Date</th>
                  <th>Status</th>
                </tr>
              </thead>
              <tbody>
                <xsl:for-each select ="//ImmunizationEntry">
                  <xsl:if test="VaccineName != ''">
                    <tr>
                      <td>
                        <xsl:value-of select="VaccineName" />
                      </td>
                      <td>
                        <xsl:value-of select="VaccineDate" />
                      </td>
                      <td>
                        <xsl:value-of select="Status" />
                      </td>
                    </tr>
                  </xsl:if>
                </xsl:for-each>
              </tbody>
            </table>
          </text>
          <xsl:apply-templates select ="//ImmunizationEntry"/>
        </section>
      </component>
    </xsl:if>
  </xsl:template>
  <xsl:template name="ImmunizationEntry" match ="//ImmunizationEntry">
    <xsl:if test="VaccineName != ''">
      <entry typeCode="DRIV">
        <substanceAdministration classCode="SBADM" moodCode="EVN" negationInd="false">
          <templateId root="2.16.840.1.113883.10.20.1.24"/>
          <!-- Medication activity template -->
          <id>
            <xsl:attribute name="root">
              <xsl:value-of select="ImmunizationHistoryUid" />
            </xsl:attribute>
          </id>
          <statusCode>
            <xsl:attribute name="code">
              <xsl:value-of select="Status" />
            </xsl:attribute>
          </statusCode>
          <xsl:if test="VaccineDate !=''">
            <effectiveTime xsi:type="IVL_TS">
              <center>
                <xsl:attribute name="value">
                  <xsl:value-of select="VaccineDate" />
                </xsl:attribute>
              </center>
            </effectiveTime>
          </xsl:if>
          <routeCode codeSystem="2.16.840.1.113883.5.112" codeSystemName="RouteOfAdministration">
            <xsl:if test="VaccineRouteId!=''">
              <xsl:attribute name="code">
                <xsl:value-of select="VaccineRouteId" />
              </xsl:attribute>
            </xsl:if>
            <xsl:if test="VaccineRoute!=''">
              <xsl:attribute name="displayName">
                <xsl:value-of select="VaccineRoute" />
              </xsl:attribute>
            </xsl:if>
          </routeCode>
          <doseQuantity value="0" />
          <consumable>
            <manufacturedProduct>
              <templateId root="2.16.840.1.113883.10.20.1.53"/>
              <!-- Product template -->
              <!--<xsl:if test="VaccineManufacturer/Name != ''">
							<manufacturerOrganization>
								<name>
									<xsl:value-of select="VaccineManufacturer/Name" />
								</name>
							</manufacturerOrganization>
						</xsl:if>-->
              <manufacturedMaterial>
                <code codeSystem="2.16.840.1.113883.6.59">
                  <xsl:if test="VaccineCode != ''">
                    <xsl:attribute name="code">
                      <xsl:value-of select="VaccineCode" />
                    </xsl:attribute>
                  </xsl:if>
                  <xsl:if test="VaccineName != ''">
                    <xsl:attribute name="displayName">
                      <xsl:value-of select="VaccineName" />
                    </xsl:attribute>
                  </xsl:if>
                  <xsl:if test="VaccineName != ''">
                    <originalText>
                      <xsl:value-of select="VaccineName" />
                    </originalText>
                  </xsl:if>
                </code>
                <xsl:if test="VaccineLot != ''">
                  <lotNumberText>
                    <xsl:value-of select="VaccineLot" />
                  </lotNumberText>
                </xsl:if>
              </manufacturedMaterial>
            </manufacturedProduct>
          </consumable>
        </substanceAdministration>
      </entry>
    </xsl:if>
  </xsl:template>

  <!--<xsl:template match="//Result/table">
      <xsl:copy-of select = "node()|@*"/>
    </xsl:template>-->

  <xsl:key name="rdate" match="//ResultDate" use="."/>
  <xsl:template name="Result"  match="//Result">
    <xsl:if test ="ObservationOrder/ProcedureUid != '' or ObservationOrder/ObservationUid != '' or pregnancy !=''">
      <component>
        <section>
          <templateId root="2.16.840.1.113883.3.88.11.83.122"/>
          <templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.28"/>
          <!-- Results section template -->
          <code code="30954-2" codeSystem="2.16.840.1.113883.6.1" displayName="STUDIES SUMMARY"/>
          <title>Results</title>
          <textResultNarrative>
          </textResultNarrative>
          <xsl:if test ="ObservationOrder/ProcedureUid != '' or ObservationOrder/ObservationUid != ''">
            <xsl:apply-templates select="//ObservationOrder" />
          </xsl:if>
        </section>
      </component>
    </xsl:if>
  </xsl:template>
  <xsl:template name="ObservationOrder"  match="//ObservationOrder">
    <xsl:if test ="ProcedureUid != '' or ObservationUid != ''">
      <entry typeCode="DRIV">
        <organizer classCode="BATTERY" moodCode="EVN">
          <templateId root="2.16.840.1.113883.10.20.1.32"/>
          <!--Result organizer template -->
          <id>
            <xsl:attribute name="root">
              <xsl:value-of select="ObservationUid" />
            </xsl:attribute>
          </id>
          <code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC">
            <xsl:attribute name="code">
              <xsl:value-of select="ObservationCode" />
            </xsl:attribute>
            <xsl:attribute name="displayName">
              <xsl:value-of select="ObservationDesc" />
            </xsl:attribute>
          </code>
          <statusCode code="completed"/>
          <effectiveTime>
                <xsl:if test="ResultDate!=''">
                  <xsl:attribute name="value">
                    <xsl:value-of select="ResultDate" />
                  </xsl:attribute>
                </xsl:if>
                <xsl:if test="ResultDate=''">
                  <xsl:attribute name="nullFlavor">
                    <xsl:text>UNK</xsl:text>
                  </xsl:attribute>
                </xsl:if>
              </effectiveTime>
          <component>
            <procedure classCode="PROC" moodCode="EVN">
              <templateId root="2.16.840.1.113883.3.88.11.83.17" assigningAuthorityName="HITSP C83"/>
              <templateId root="2.16.840.1.113883.10.20.1.29" assigningAuthorityName="CCD"/>
              <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.19" assigningAuthorityName="IHE PCC"/>
              <id/>
              <code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC">
            <xsl:attribute name="code">
              <xsl:value-of select="ObservationCode" />
            </xsl:attribute>
            <xsl:attribute name="displayName">
              <xsl:value-of select="ObservationDesc" />
            </xsl:attribute>
              <originalText>
                  <xsl:value-of select="ObservationDesc" /><reference value="Ptr to text  in parent Section"/>
                </originalText>
          </code>
              <text>
                <xsl:value-of select="ObservationDesc" /><reference value="Ptr to text  in parent Section"/>
              </text>
              <statusCode code="completed"/>
              <effectiveTime>
                <xsl:if test="ResultDate!=''">
                  <xsl:attribute name="value">
                    <xsl:value-of select="ResultDate" />
                  </xsl:attribute>
                </xsl:if>
                <xsl:if test="ResultDate=''">
                  <xsl:attribute name="nullFlavor">
                    <xsl:text>UNK</xsl:text>
                  </xsl:attribute>
                </xsl:if>
              </effectiveTime>
            </procedure>
          </component>
          <xsl:apply-templates select="ObservationValue"/>
        </organizer>
      </entry>
      <xsl:if test ="pregnancy != ''">
        <entry>
          <!-- Pregnancy -->
          <observation classCode="OBS" moodCode="EVN" negationInd="true">
            <code nullFlavor="NA" code="404684003" displayName="Finding" codeSystemName="SNOMED-CT" codeSystem="2.16.840.1.113883.6.96"/>
            <text>
              <reference value="#pregnancy-indicator-1"/>Patient is pregnant.
            </text>
            <statusCode code="completed"/>
            <value xsi:type="CD" code="77386006" displayName="Patient currently pregnant" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>
            <performer typeCode="PRF">
              <assignedEntity>
                <id extension="PseudoMD-1" root="2.16.840.1.113883.3.72.5.2"/>
              </assignedEntity>
            </performer>
          </observation>
        </entry>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  <xsl:template name="ObservationValue"  match="ObservationValue">
    <xsl:if test="ObservationValue != ''">
      <component>
        <observation classCode="OBS" moodCode="EVN">
          <templateId root="2.16.840.1.113883.3.88.11.83.15" assigningAuthorityName="HITSP C83"/>
          <templateId root="2.16.840.1.113883.10.20.1.31" assigningAuthorityName="CCD"/>
          <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.13" assigningAuthorityName="IHE PCC"/>
          <templateId root="2.16.840.1.113883.3.88.11.83.15.1"/>
          <!-- Result observation template -->
          <id>
            <xsl:attribute name="root">
              <xsl:value-of select="ObservationItemUid" />
            </xsl:attribute>
          </id>
          <code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC">
            <xsl:attribute name="code">
              <xsl:value-of select="ObservationItemCode" />
            </xsl:attribute>
            <xsl:attribute name="displayName">
              <xsl:value-of select="ObservationItemName" />
            </xsl:attribute>
          </code>
          <text>
            <reference value='#xxx'/>
            <xsl:value-of select="ObservationItemName" />
          </text>
          <statusCode code="completed"/>
          <effectiveTime>
            <xsl:attribute name="value">
              <xsl:value-of select="ResultDate" />
            </xsl:attribute>
          </effectiveTime>
          <xsl:variable name="OV_Value" select="ObservationValue" />
          <xsl:if test="not(string(number($OV_Value))='NaN')">
          <value xsi:type="PQ">
            <xsl:attribute name="value">
              <xsl:value-of select="$OV_Value" />
            </xsl:attribute>
            <xsl:if test="ObservationUnits != ''">
              <xsl:attribute name="unit">
                <xsl:value-of select="ObservationUnits" />
              </xsl:attribute>
            </xsl:if>
          </value>
          </xsl:if>
          <xsl:if test="string(number($OV_Value))='NaN'">
          <value xsi:type="CD" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT" nullFlavor="OTH">
            <originalText>
              <xsl:value-of select="$OV_Value" />
            </originalText>
          </value>
          </xsl:if>
          <interpretationCode code="N" codeSystem="2.16.840.1.113883.5.83"/>
          <xsl:if test="ObservationRefLow!=''">
            <referenceRange>
              <observationRange>
                <value xsi:type="IVL_PQ">
                  <low>
                    <xsl:attribute name="value">
                      <xsl:value-of select="ObservationRefLow" />
                    </xsl:attribute>
                    <xsl:if test="ObservationUnits != ''">
                      <xsl:attribute name="unit">
                        <xsl:value-of select="ObservationUnits" />
                      </xsl:attribute>
                    </xsl:if>
                  </low>
                  <high>
                    <xsl:attribute name="value">
                      <xsl:value-of select="ObservationRefHigh" />
                    </xsl:attribute>
                    <xsl:if test="ObservationUnits != ''">
                      <xsl:attribute name="unit">
                        <xsl:value-of select="ObservationUnits" />
                      </xsl:attribute>
                    </xsl:if>
                  </high>
                </value>
              </observationRange>
            </referenceRange>
          </xsl:if>
        </observation>
      </component>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>