﻿# Type this to run the command in a Powershell session  
# .\ValidateConfig.ps1 -ConfigFile 'Customer.config' 
# These are command line parameters that can be set on each run or they can be changed here
param ($ConfigFile = '', $SQLServername = '', $TestMode = 'false', $Path = '')

	# if ($TestMode -eq 'true')	{Write-Host "*** TestMode is on ***"}
    #Write-Host $Path "--"  $ConfigFile
    if ( ![string]::IsNullOrEmpty( $Path ) ){ Set-Location -Path "$Path"}
	## cast the file to an XML object
    Write-Host "Validating config file: $ConfigFile in folder: $pwd"
	[xml]$Customer = Get-Content -Path $ConfigFile

    if (Test-Path "Email.config") {
        [xml]$Email = Get-Content -Path "Email.config"
        $EmailTo = $Email.configuration.emailto.address 
        Write-Host "Email.config found for: $EmailTo"
     } else { Write-Host "Email.config was not found - no email will be sent"}

	## if the param is empty, override from the config
	$DatabaseName = $Customer.configuration.database.name
	$BackupFolder = $Customer.configuration.database.backupfolder
	if ( [string]::IsNullOrEmpty( $SQLServername ) ){$SQLServername = $Customer.configuration.database.server}
	if ( [string]::IsNullOrEmpty( $CommonDatabaseName ) ){$CommonDatabaseName = $Customer.configuration.database.common}
	
    $QueryPRM = "select CONCAT(PRMVersion, '.' ,PRMSeq) [version] from VersionPRM where Status = 0"
    $QueryCommon = "select CONCAT(PRMVersion, '.' ,PRMSeq) [version] from VersionCommon where Status = 0"
    Write-Host "`nValidating Database: $DatabaseName on SQLServer $SQLServername"
	if ($TestMode -eq 'false')	{
        $DBresult = invoke-sqlcmd -ServerInstance $SQLServername -Database $DatabaseName -Query $QueryPRM 
	    if($DBresult -eq $null) {Write-Host "  $DatabaseName is not valid"  -BackgroundColor Red } 
            else {Write-Host "  $DatabaseName is valid and is version: "$DBresult.version""}
        $DBresult = invoke-sqlcmd -ServerInstance $SQLServername -Database $CommonDatabaseName -Query $QueryCommon
	    if($DBresult -eq $null) {Write-Host "  $CommonDatabaseName is not valid"  -BackgroundColor Red } 
            else {Write-Host "  $CommonDatabaseName is valid and is version: "$DBresult.version""}
        
        if ( [string]::IsNullOrEmpty( $BackupFolder ) ) {Write-Host "  No Backup will be made.`n"}
        else {"  A Backup will be made in the folder $BackupFolder`n"}
	}

	$Customer.configuration.appservers.service	 |  ForEach-Object {
		$AppServerName = $_.server
		$AppserviceName = $_.name
		$AppservicePath = $_.path
		
		Write-Host "Validating Appserver: $AppserviceName on $AppServerName"
		if ($TestMode -eq 'false') {
            #$CIMQuery  = 'select * from Win32_Service where name like "{0}" ' -f $AppserviceName;
            #$Result = Get-CimInstance -ComputerName $AppServerName -Query $CIMQuery  | select Name, State, PathName
            #Write-Host "  " $Result.Name "is" $Result.State " installed path is" $Result.PathName  "`n"
            $Result = Get-Service -Name $AppserviceName -ComputerName $AppServerName | select Name, Status
            Write-Host "  Found Appserver" $Result.Name" Status: "$Result.Status
            if (Test-Path $AppservicePath) { Write-Host "  Appserver install path is valid  $AppservicePath" -NoNewline }
            else { Write-Host "  Appserver install path not found $AppservicePath" -BackgroundColor Red  }
            Add-Content -Path "$AppservicePath\Manager.log"  -Value ("{0} - {1}" -f (Get-Date -Format "MM/dd/yyyy hh:mm:ss tt"), "Validate $AppserviceName") -ErrorAction SilentlyContinue -ErrorVariable PathError;
            if(!$PathError) { Write-Host (" and is writeable`n") }
            else { Write-Host ("`n  However it is not writeable because:  $PathError") -BackgroundColor Red }
		}
	}
    if($Error.Count -eq 0)  {  write-host "Config file is valid: $ConfigFile" -BackgroundColor Green  }
    else  {  write-host "Validation failed for: $ConfigFile  check the error shown above" -BackgroundColor Red  }