﻿# type this to run the command in a powershell session   .\MultipleMigration.ps1
# these are command line paramerters that can be set on each run or they can be changed here
param ($SQLServername = '(local)', $CommonDatabaseName = 'PRM_Common18.1', $EmailTo = "")
#List the databases to be migrated in this line. they must be on the same SQL Server and share the same Common Database
$DatabasesToMigrate = @( 'PRMv18.1Demo',  'PRMv18.1Demo2' )
# this is where the Manager.exe is located.
$Manager = "..\NoUAC.Manager.exe"

#---------------------------------------------
# DO NOT change anything below this line
#---------------------------------------------
foreach( $DB in $DatabasesToMigrate)
{
	$DatabaseName = $DB
	$AnswerFilePath = Join-Path -Path  $pwd.Path -ChildPath ($DatabaseName + "-Migration.xml")
	$LogFilePath = $env:ProgramData + "\Aprima\InstallationManager\" + $env:USERNAME +"\Manager-"+ $DatabaseName +".log"
	
	# this is the AnswerFile template for Migration
	$AnswerFile = "<InstallationAnswers>
		<InstallAction Mode=""""/>
		<SqlConnection ServerName=""$SQLServername""/>
		<Migration CommonDatabaseName=""$CommonDatabaseName"" />
		<SendEmail SendTo=""$EmailTo""/>
	</InstallationAnswers>"

	#save the AnswerFile contents
	Set-Content -path $AnswerFilePath -Value $AnswerFile

	write-host "Migrating Database:" $DatabaseName "on SQLServer" $SQLServername "LogFile" $LogFilePath "AnswerFile" $AnswerFilePath
	# use the next line to watch the database migration log file
	# Start-Process -FilePath "powershell.exe"  "-command Get-Content $LogFilePath -Tail 10 -Wait"
	# use the next 2 lines to watch the main manager log file
	# $ManagerLogFilePath = $env:ProgramData + "\Aprima\InstallationManager\" + $env:USERNAME +"\Manager.log"
	# Start-Process -FilePath "powershell.exe"  "-command Get-Content $ManagerLogFilePath -Tail 10 -Wait"

	& $Manager $AnswerFilePath Migration $DatabaseName
	
	#short delay between startups
	Start-Sleep -Seconds 5
}
#   Read-Host "paused..."

# this is a list of SMS email addresses for various carriers
# "123456789@messaging.sprintpcs.com");  	Sprint
# "123456789@txt.att.net");					AT&T
# "123456789@tmomail.net");					T-Mobile
# "123456789@vtext.com");					Verizon
