angular.module("aprima-sigwriter",["ui.router","restangular","ngTouch","ngAnimate","ui.bootstrap","angularLocalStorage","gettext","lodash","toaster","rt.debounce","hmTouchEvents","mgo-angular-wizard","aprima-core","aprima-core-ui","aprima-bridge","aprima-config","aprima-legacy-common","aprima-provider-api","aprima-patient"]),angular.module("aprima-sigwriter").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("/sigwriter/component-views/drugIconGroup.html",'<i ng-class="$ctrl.genericTypeClass" ng-if="$ctrl.genericTypeClass"></i>\r\n<i ng-class="$ctrl.ePrescribeTypeClass" ng-if="$ctrl.ePrescribeTypeClass"></i>'),$templateCache.put("/sigwriter/component-views/epcsSignature.html",'                    <div class="row epcs-signature">\r\n                        <div class="col-xs-12">\r\n                            <div class="heading-title">{{::\'Provider Signature for Prescribing Controlled Substances\' | translate}}</div>\r\n                        </div>\r\n                        <div class="col-xs-12">\r\n                            <div class="heading-title col-xs-4 col-xs-flush">{{::\'Provider Name:\' | translate}}</div>\r\n                            <div class="col-xs-8 col-xs-flush">{{ $ctrl.epcsModel.providerName }}</div>\r\n                        </div>\r\n                        <div class="col-xs-12">\r\n                            <div class="heading-title col-xs-4 col-xs-flush">{{::\'DEA Number:\' | translate}}</div>\r\n                            <div class="col-xs-8 col-xs-flush">{{ $ctrl.epcsModel.providerDeaNumber }}</div>\r\n                        </div>\r\n                        <div class="col-xs-12">\r\n                            <div class="detail-group">\r\n                                <div class="form-group">\r\n                                    <div class="text-center" ng-if="$ctrl.loading"><ap-spinner size="2"></ap-spinner></div>\r\n                                    <div ng-if="!$ctrl.loading && $ctrl.epcsModel.pinType !== \'hid\'">\r\n                                        <div class="col-xs-6">\r\n                                                <label class="control-label" for="EpcsSignatureOtpPassword" translate>{{::\'Password\' | translate}}</label>\r\n                                                <br>\r\n                                                <input type="password"\r\n                                                        class="form-control"\r\n                                                        name="EpcsSignatureOtpPassword"\r\n                                                        ng-model="$ctrl.epcsModel.otpPassword"\r\n                                                        ap-required="true" />\r\n                                            </div>\r\n                                            <div class="col-xs-6">\r\n                                                <label class="control-label" for="EpcsSignatureOtpPinCode" translate>{{::\'PIN Code\' | translate}}</label>\r\n                                                <br>\r\n                                                <input type="text"\r\n                                                        class="form-control"\r\n                                                        name="EpcsSignatureOtpPinCode"\r\n                                                        ng-model="$ctrl.epcsModel.otpPinCode"\r\n                                                        ap-required="true" />\r\n                                            </div>\r\n                                    </div>\r\n                                    <div class= "epcs-instructions" ng-if="!$ctrl.loading && $ctrl.epcsModel.pinType === \'hid\'">\r\n                                            {{::\'HID Enabled\' | translate}}\r\n                                    </div>\r\n                                    \r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="col-xs-12 epcs-instructions">\r\n                            {{::\'By completing the two-factor authentication protocol at this time, you are legally signing the prescription(s) and authorizing the transmission of the above information to the pharmacy for dispensing. The two-factor authentication protocol may only be completed by the practitioner whose name and DEA registration number appear above.\' | translate}}\r\n                        </div>\r\n                    </div>\r\n'),$templateCache.put("/sigwriter/component-views/formularyDetails.html",'\r\n\r\n<div id="sigwriter-formulary-details">\r\n\r\n    <div class="row" ng-hide="$ctrl.isInfoAvailable || $ctrl.loading || !$ctrl.details">\r\n        <div class="col-xs-12">\r\n            <span translate>\r\n                Formulary information is not currently available.\r\n            </span>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="!$ctrl.loading && !$ctrl.error && $ctrl.isInfoAvailable">\r\n        <div class="row" id="drug-formulary-summary">\r\n            <div class="col-xs-12">\r\n                <div class="form-group row">\r\n                    <div class="col-xs-3 col-md-2">\r\n                        <label class="control-label text-left">{{::\'Medication\' | translate}}</label>\r\n                    </div>\r\n\r\n                    <div class="col-xs-9 col-md-10">\r\n                        <span class="text-left">{{$ctrl.details.primaryMedication.name}}</span>\r\n                    </div>\r\n                </div>\r\n                <div class="form-group row ng-hide" ng-show="$ctrl.details.primaryMedication.formularyStatus">\r\n                    <div class="col-xs-3 col-md-2">\r\n                        <label class="control-label text-left">{{::\'Formulary Status\' | translate}}</label>\r\n                    </div>\r\n\r\n                    <div class="col-xs-9 col-md-10">\r\n                        <span class="text-left">{{$ctrl.details.primaryMedication.formularyStatus}}</span>\r\n                    </div>\r\n                </div>\r\n                <div class="form-group row" ng-repeat="copay in $ctrl.details.primaryMedication.copays">\r\n                    <div class="col-xs-3 col-md-2">\r\n                        <label class="control-label text-left">{{copay.CopayLabel}}</label>\r\n                    </div>\r\n\r\n                    <div class="col-xs-9 col-md-10">\r\n                        <span class="text-left">{{copay.CopayValue}}</span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id="rx-formulary-display">\r\n        <div id="rx-formulary-loading" ng-show="$ctrl.loading">\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    Loading Formulary Details\r\n                    <br/>\r\n                    <ap-spinner data-size="3"></ap-spinner>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div ng-show="!$ctrl.loading && !$ctrl.error && $ctrl.details && !$ctrl.showResponseXml && !$ctrl.showRFSResponseXml">\r\n            <div class="row" ng-if="$ctrl.details.ResponsePMBC.Medications && $ctrl.details.ResponsePMBC.Medications.length > 0">\r\n                <div class="col-xs-12">\r\n                    <div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'!Alternative\'} : true">\r\n                        <span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Medication Requested" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                        <sigwriter-pmbc-medication\r\n                            med="med"\r\n                            show-drug-icons="true"\r\n                            select="$ctrl.changeMedication(med, pricingCoverage)"\r\n                        />\r\n                    </div>\r\n                    <div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true">\r\n                        <span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Alternative Medications" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                        <sigwriter-pmbc-medication\r\n                            med="med"\r\n                            show-drug-icons="true"\r\n                            select="$ctrl.changeMedication(med, pricingCoverage)"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n                <div class="col-xs-12">\r\n                    <span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails = !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails">Transmit Status - Patient Medication Benefit Check<span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.Status }}">\r\n                            Status: {{ $ctrl.details.ResponsePMBC.TransmitStatus.Status }}\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.Response }}">\r\n                            Response: {{ $ctrl.details.ResponsePMBC.TransmitStatus.Response }} <button ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.ResponseXml && $ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showResponseXml = true;"><span>View Response</span></button>\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus">\r\n                            Deny Status: {{ $ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus }}\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.RequestError">\r\n                            Request Error: {{ $ctrl.details.ResponsePMBC.TransmitStatus.RequestError }}\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n\r\n            <div class="row" ng-if="$ctrl.details.ResponseRFS.Medications && $ctrl.details.ResponseRFS.Medications.length > 0">\r\n                <div class="col-xs-12">\r\n                    <div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'!Alternative\'} : true">\r\n                        <span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Formulary Medication" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                        <sigwriter-rfs-medication\r\n                            med="med"\r\n                            show-drug-icons="true"\r\n                            select="$ctrl.changeMedication(med)"\r\n                        />\r\n                    </div>\r\n                    <div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true">\r\n                        <span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Formulary Alternatives" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                        <sigwriter-rfs-medication\r\n                            med="med"\r\n                            show-drug-icons="true"\r\n                            select="$ctrl.changeMedication(med)"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-if="$ctrl.details.ResponseRFS.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n                <div class="col-xs-12">\r\n                    <span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails = !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails">Transmit Status - Representative Formulary Service<span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.Status }}">\r\n                            Status: {{ $ctrl.details.ResponseRFS.TransmitStatus.Status }}\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.Response }}">\r\n                            Response: {{ $ctrl.details.ResponseRFS.TransmitStatus.Response }} <button ng-if="$ctrl.details.ResponseRFS.TransmitStatus.ResponseXml && $ctrl.details.ResponseRFS.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showRFSResponseXml = true;"><span>View Response</span></button>\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponseRFS.TransmitStatus.DenyStatus">\r\n                            Deny Status: {{ $ctrl.details.ResponseRFS.TransmitStatus.DenyStatus }}\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponseRFS.TransmitStatus.RequestError">\r\n                            Request Error: {{ $ctrl.details.ResponseRFS.TransmitStatus.RequestError }}\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row" ng-if="$ctrl.details.ResponseRTPS.copayAssistance && !$ctrl.hideTransmitStatus">\r\n                <div class="col-xs-12">\r\n                    <span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponseRTPS.copayAssistance.ShowDetails=!$ctrl.details.ResponseRTPS.copayAssistance.ShowDetails"> Real-Time Patient Savings <span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponseRTPS.copayAssistance.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                    <div class="col-xs-12 col-xs-flush rtps">\r\n\r\n                        <div  class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.responseMessageLong" >\r\n                            <span> Offer: </span> <span ng-bind-html=$ctrl.details.ResponseRTPS.copayAssistance.responseMessageLong></span>\r\n                        </div>\r\n                        <div  class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.responseMessageBrief" >\r\n                            <span> Additional Offer Info: </span> <span ng-bind-html=$ctrl.details.ResponseRTPS.copayAssistance.responseMessageBrief></span>\r\n                        </div>\r\n                        <div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.drug">\r\n                            Drug: {{$ctrl.details.ResponseRTPS.copayAssistance.drug}}\r\n                        </div>\r\n\r\n                         <div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.couponUrl">\r\n                            Coupon Url:  <a ng-href={{$ctrl.details.ResponseRTPS.copayAssistance.couponUrl}} target="_blank">\r\n                            <span class="detail-emphasis">Link to Patient-Savings</span> </a>\r\n                        </div>\r\n                        <div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.offerAmount">\r\n                            Offer Amount: <span class="detail-emphasis">{{$ctrl.details.ResponseRTPS.copayAssistance.offerAmount | currency }}</span>\r\n                        </div>\r\n                        <div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.patientPayAmountAdjustedByOffer">\r\n                            Est. patient pay amount w/coupon:<span>{{$ctrl.details.ResponseRTPS.copayAssistance.patientPayAmountAdjustedByOffer | currency }}</span>\r\n                        </div>\r\n                        <div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.offerAmountToApply">\r\n                            Offer Amount To Apply: <span>{{$ctrl.details.ResponseRTPS.copayAssistance.offerAmountToApply | currency }} </span>\r\n                         </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row" ng-if="$ctrl.details.ResponseRTPS.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n                <div class="col-xs-12">\r\n                    <span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails = !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails">Transmit Status - Real-Time Patient Savings <span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRTPS.TransmitStatus.Status }}">\r\n                            Status: {{ $ctrl.details.ResponseRTPS.TransmitStatus.Status }}\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRTPS.TransmitStatus.Response }}">\r\n                            Response: {{$ctrl.details.ResponseRTPS.TransmitStatus.Response}} <button ng-if="$ctrl.details.ResponseRTPS.TransmitStatus.ResponseXml && $ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showRTPSResponseXml = true;"><span>View Response</span></button>\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRTPS.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponseRTPS.TransmitStatus.DenyStatus">\r\n                            Deny Status: {{$ctrl.details.ResponseRTPS.TransmitStatus.DenyStatus}}\r\n                        </div>\r\n                        <div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRTPS.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponseRTPS.TransmitStatus.RequestError">\r\n                            Request Error: {{ $ctrl.details.ResponseRTPS.TransmitStatus.RequestError }}\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n\r\n        <div ng-show="$ctrl.showResponseXml">\r\n            <div class="row">\r\n                <div class="col-xs-12 col-xs-flush response-xml">\r\n                    <div class="col-xs-12">\r\n                        <span class="pull-left header">Response XML</span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n                    </div>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <pre ng-bind="$ctrl.details.ResponsePMBC.TransmitStatus.ResponseXml" />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div ng-show="$ctrl.showRFSResponseXml">\r\n            <div class="row">\r\n                <div class="col-xs-12 col-xs-flush response-xml">\r\n                    <div class="col-xs-12">\r\n                        <span class="pull-left header">Response XML</span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showRFSResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n                    </div>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <pre ng-bind="$ctrl.details.ResponseRFS.TransmitStatus.ResponseXml" />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div ng-show="$ctrl.showRTPSResponseXml">\r\n            <div class="row">\r\n                <div class="col-xs-12 col-xs-flush response-xml">\r\n                    <div class="col-xs-12">\r\n                        <span class="pull-left header">Response Json </span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showRTPSResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n                    </div>\r\n                    <div class="col-xs-12 col-xs-flush medication">\r\n                        <pre ng-bind="$ctrl.details.ResponseRTPS.TransmitStatus.ResponseXml" />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div ng-show="!$ctrl.loading && !$ctrl.error && !$ctrl.details">\r\n            <div class="col-xs-12">\r\n                <uib-alert type="success" translate>\r\n                    No formulary details were found.\r\n                </uib-alert>\r\n            </div>\r\n        </div>\r\n\r\n        <div ng-show="$ctrl.error">\r\n            <div class="col-xs-12">\r\n                <uib-alert type="danger" translate>\r\n                    There was a communication issue with the server.  Please contact support.\r\n                </uib-alert>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/sigwriter/component-views/formularyDisplay.html",'<div id="sigwriter-formulary-display">\r\n    <div class="row" ng-hide="$ctrl.isInfoAvailable || $ctrl.loading || !$ctrl.details">\r\n        <div class="col-xs-12">\r\n            <span translate>\r\n                Formulary information is not currently available.\r\n            </span>\r\n        </div>\r\n    </div>\r\n    \r\n    <div ng-show="!$ctrl.loading && !$ctrl.error && $ctrl.isInfoAvailable">\r\n        <div id="drug-formulary-summary">\r\n            <div class="form-group row">\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-medication-name">{{$ctrl.details.primaryMedication.name}}</span>\r\n                </div>\r\n            </div>\r\n            <div class="form-group row">\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-status" title="{{ $ctrl.formularyStatusCertification($ctrl.details.primaryMedication.formularyStatus) }}">{{$ctrl.formularyStatusShow($ctrl.details.primaryMedication.formularyStatus)}}</span>\r\n                </div>\r\n            </div>\r\n            <div class="form-group row" ng-show="$ctrl.details.ResponsePMBC.DiscountURL">\r\n                <div class="col-xs-12">\r\n                    <a href="{{$ctrl.details.ResponsePMBC.DiscountURL}}" id="drug-search-discount" target="_blank">\r\n                        <span class="rx-formulary-restrictions" title="Search for drug discount on website">{{::\'Drug Discount Pricing\' | translate }}</span>\r\n                    </a>\r\n                </div>    \r\n            </div>\r\n            <div class="form-group row" ng-repeat="copay in $ctrl.details.primaryMedication.copays">\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-copay-label">{{copay.CopayLabel}}:</span>\r\n                    <span class="rx-formulary-copay">{{copay.CopayValue}}</span>\r\n                </div>\r\n            </div>\r\n            <div class="form-group row" ng-show="$ctrl.details.primaryMedication.formularyCoverageRestrictions">\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-restrictions">{{::\'Has Coverage Factors\' | translate }}</span>\r\n                </div>\r\n            </div>\r\n            <div class="form-group row" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.drug && $ctrl.details.ResponseRTPS.copayAssistance.drug !=$ctrl.details.primaryMedication.name">\r\n                <div class="col-xs-12">\r\n                    <span class="rtps-drug-name">Drug: {{$ctrl.details.ResponseRTPS.copayAssistance.drug}}</span>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="form-group row" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.couponUrl">\r\n                <div class="col-xs-12">\r\n                    <span ng-if="$ctrl.details.ResponseRTPS.copayAssistance.offerAmount" class="rtps-data"> Offer Amount:\r\n                        {{$ctrl.details.ResponseRTPS.copayAssistance.offerAmount | currency }}</span>\r\n                    <span><a ng-href={{$ctrl.details.ResponseRTPS.copayAssistance.couponUrl}} target="_blank"> <span\r\n                                class="rtps-hyperlink">Link to Patient-Savings </span> </a> </span>\r\n                </div>\r\n            </div>\r\n            <div class="form-group row" ng-if="!$ctrl.details.ResponseRTPS.copayAssistance.couponUrl && $ctrl.details.ResponseRTPS.copayAssistance.responseMessageBriefText">\r\n                <div class="col-xs-12">\r\n                    <span ng-if="$ctrl.details.ResponseRTPS.copayAssistance.offerAmount" class="rtps-data"> Offer Amount:\r\n                        {{$ctrl.details.ResponseRTPS.copayAssistance.offerAmount | currency }}</span>\r\n                     <span class="rtps-data"\r\n                        ng-bind-html=$ctrl.details.ResponseRTPS.copayAssistance.responseMessageBriefText></span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="!$ctrl.loading && !$ctrl.error && $ctrl.details && $ctrl.hasAlternatives()">\r\n        <div id="drug-formulary-alternatives">\r\n            <div class="form-group row">\r\n                <div class="col-xs-12">\r\n                    <span class="crx-formulary-medication-name">{{::\'Alternatives\' | translate }}</span>\r\n                </div>\r\n            </div>        \r\n            <div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true" class="form-group" ng-if="$ctrl.details.ResponsePMBC.Medications && $ctrl.details.ResponsePMBC.Medications.length > 0">\r\n                <div class="col-xs-12" title="{{ med.Description }}">                        \r\n                    <span class="rx-formulary-medication-name" ng-class="{\'clickable\': (med.MedId > 0) }" title="{{ med.Description }}" ng-click="$ctrl.changeMedication(med, null)">{{ med.Description }}</span>\r\n                </div>\r\n                <div class="col-xs-12" title="{{ med.DisplaySinglePrice }}">                        \r\n                    <span class="rx-formulary-status" title="{{ $ctrl.formularyStatusCertification(med.FormularyStatus) }}" ng-show="med.FormularyStatus">{{ med.FormularyStatusTerse }}</span>\r\n                    <span class="rx-formulary-dash" ng-show="med.FormularyStatus && med.DisplayTerseSinglePrice">-</span>\r\n                    <span class="rx-formulary-copay-label" ng-show="med.DisplayTerseSinglePrice">{{ med.DisplayTerseSinglePrice }}</span>\r\n                    <span class="rx-formulary-restrictions">{{ med.DisplayHasRestrictions ? \' (Restrictions)\' : \'\' }}</span>\r\n                </div>\r\n            </div>\r\n            <div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true" class="form-group" ng-if="$ctrl.details.ResponseRFS.Medications && $ctrl.details.ResponseRFS.Medications.length > 0">\r\n                <div class="col-xs-12" title="{{ med.Description }}">\r\n                    <span class="rx-formulary-medication-name" ng-class="{\'clickable\': (med.MedId > 0) }" title="{{ med.Description }}" ng-click="$ctrl.changeMedication(med, null)">{{ med.Description }}</span>\r\n                </div>\r\n                <div class="col-xs-12">\r\n                    <span class="rx-formulary-status" title="{{ $ctrl.formularyStatusCertification(med.FormularyStatus) }}" ng-show="med.FormularyStatus">{{ med.FormularyStatusTerse }}</span>\r\n                    <span class="rx-formulary-dash" ng-show="med.FormularyStatus && med.DisplaySingleCopayTerseValue">-</span>\r\n                    <span class="rx-formulary-copay" title="{{ med.DisplaySingleCopayLabel + \': \' + med.DisplaySingleCopayValue }}" ng-show="med.DisplaySingleCopayTerseValue">{{ med.DisplaySingleCopayTerseValue }}</span>\r\n                    <span class="rx-formulary-restrictions">{{ med.DisplayHasRestrictions ? \' (Restrictions)\' : \'\' }}</span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="!$ctrl.loading && !$ctrl.error && !$ctrl.details">\r\n        <div class="col-xs-12">\r\n            <uib-alert type="success" translate>\r\n                No formulary details were found.\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n    \r\n    <div ng-show="$ctrl.error">\r\n        <div class="col-xs-12">\r\n            <uib-alert type="danger" translate>\r\n                There was a communication issue with the server.  Please contact support.\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/freeTextDirections.html",'<div ng-hide="vm.textOpen || vm.hasValue()">\r\n    <button type="button"\r\n            class="btn btn-link btn-square"\r\n            ng-click="vm.onClickOpen()">\r\n        <span class="ap-insert-text"></span>\r\n    </button>\r\n</div>\r\n<div ng-show="vm.textOpen || vm.hasValue()" ng-transclude>\r\n</div>\r\n'),$templateCache.put("/sigwriter/component-views/nddCondensedDrugScreening.html",'<div id="ndd-condensed-drug-screening">\r\n    <div id="drug-screening-loading" ng-if="$ctrl.loading">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Performing Drug Screening\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id="drug-screening-error" ng-if="!$ctrl.loading && $ctrl.error">\r\n        <div class="col-xs-12">\r\n            <uib-alert type="danger" translate>\r\n                There was an error while performing drug screening.  Please contact support.\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n    <div id="drug-screening-info" ng-if="!$ctrl.loading && !$ctrl.error">\r\n        <div ng-if="$ctrl.screening.Error">\r\n            <div ng-if="$ctrl.screening.Error === \'NoScreeningOptionsSelected\'">\r\n                <uib-alert type="warning" translate>None of the drug screening options have been selected.</uib-alert>\r\n            </div>\r\n            <div ng-if="$ctrl.screening.Error === \'NoActiveMedications\'">\r\n                <uib-alert type="warning" translate>The patient does not have any active medications to screen.</uib-alert>\r\n            </div>\r\n            <div ng-if="$ctrl.screening.Error === \'NoParameters\'">\r\n                <uib-alert type="warning" translate>There was nothing to screen.</uib-alert>\r\n            </div>\r\n        </div>\r\n        <div ng-if="!$ctrl.screening.Error">\r\n            <div class="row" ng-if="$ctrl.screening.Status === \'Completed\' || $ctrl.screening.Status === \'CompletedOutOfDate\'">\r\n                <div class="col-xs-12">\r\n                    <uib-alert type="success" translate>\r\n                        No medication alerts or precautions were found.\r\n                    </uib-alert>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-if="$ctrl.screening.Status === \'CompletedWithAlerts\'">\r\n                \x3c!-- FDB Alerts --\x3e\r\n                <div class="col-xs-12">\r\n                    <div ng-if="$ctrl.screening.ProposedDrug && $ctrl.screening.ProposedDrug.IsUserDefined">\r\n                        <uib-alert type="danger">{{::\'Drug screening cannot be performed with a user defined medication.\' | translate}}</uib-alert>\r\n                    </div>\r\n                    <div ng-if="$ctrl.screening.ActXResult">\r\n                        <uib-alert type="warning" translate>ActX result available below.</uib-alert>\r\n                    </div>\r\n\r\n                    <div ng-if="!($ctrl.screening.ProposedDrug && $ctrl.screening.ProposedDrug.IsUserDefined)">\r\n                        <div class="" ng-if="$ctrl.screening.InteractionResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.InteractionResult.OverallSeverity)" translate>\r\n                                INTERACTION ALERT\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.DuplicateTherapyResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.DuplicateTherapyResult.OverallSeverityLevel)" translate>\r\n                                DUPLICATE THERAPY ALERT\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.DuplicateIngredientResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.DuplicateIngredientResult.OverallSeverityLevel)" translate>\r\n                                DUPLICATE INGREDIENT ALERT\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.AllergyResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.AllergyResult.OverallSeverityLevel)" translate>\r\n                                ALLERGY ALERT\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.MedicalConditionResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.MedicalConditionResult.OverallSeverity)" translate>\r\n                                MEDICAL CONDITION PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.PregnancyResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.PregnancyResult.OverallSeverity)" translate>\r\n                                PREGNANCY PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.LactationResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.LactationResult.OverallSeverity)" translate>\r\n                                LACTATION PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.PediatricResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.PediatricResult.OverallSeverity)" translate>\r\n                                PEDIATRIC PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.GeriatricResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverity($ctrl.screening.GeriatricResult.OverallSeverity)" translate>\r\n                                GERIATRIC PRECAUTION\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.UserDefinedAllergyResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.UserDefinedAllergyResult.OverallSeverityLevel)" translate>\r\n                                USER DEFINED ALLERGIES\r\n                            </span>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.UserDefinedMedicationResult">\r\n                            <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.UserDefinedMedicationResult.OverallSeverityLevel)" translate>\r\n                                USER DEFINED MEDICATIONS\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="$ctrl.screening.DisclaimerText">\r\n            <hr/>\r\n            <div class="row">\r\n                <div id="ndd-legal-alert" class="col-xs-12">\r\n                    {{$ctrl.screening.DisclaimerText}}\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="$ctrl.screening.Version">\r\n            <hr/>\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    <div ng-if="$ctrl.screening.Version.ExpirationWarning">{{$ctrl.screening.Version.ExpirationWarning}}</div>\r\n                    <div>{{$ctrl.screening.Version.VersionInformation}}</div>\r\n                    <div>{{$ctrl.screening.Version.Copyright}}</div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="!$ctrl.screening.Error && $ctrl.screening.Status === \'CompletedWithAlerts\'">\r\n            \x3c!-- Non-FDB Alerts --\x3e\r\n            <div ng-if="$ctrl.screening.ActXResult">\r\n                <hr/>\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <span ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.ActXResult.OverallSeverityLevel)" translate>\r\n                            ACTX ALERT\r\n                        </span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/nddDetailedDrugScreening.html",'<div id="ndd-detailed-drug-screening">\r\n    <div id="drug-screening-loading" ng-if="$ctrl.loading">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Performing Drug Screening\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id="drug-screening-error" ng-if="!$ctrl.loading && $ctrl.error">\r\n        <div class="col-xs-12">\r\n            <uib-alert type="danger" translate>\r\n                There was an error while performing drug screening.  Please contact support.\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n    <div id="drug-screening-info" ng-if="!$ctrl.loading && !$ctrl.error">\r\n        <div ng-if="$ctrl.screening.Error">\r\n            <div ng-if="$ctrl.screening.Error === \'NoScreeningOptionsSelected\'">\r\n                <uib-alert type="warning" translate>None of the drug screening options have been selected.</uib-alert>\r\n            </div>\r\n            <div ng-if="$ctrl.screening.Error === \'NoActiveMedications\'">\r\n                <uib-alert type="warning" translate>The patient does not have any active medications to screen.</uib-alert>\r\n            </div>\r\n            <div ng-if="$ctrl.screening.Error === \'NoParameters\'">\r\n                <uib-alert type="warning" translate>There was nothing to screen.</uib-alert>\r\n            </div>\r\n        </div>\r\n        <div ng-if="!$ctrl.screening.Error">\r\n            <div class="row" ng-if="$ctrl.screening.Status === \'Completed\' || $ctrl.screening.Status === \'CompletedOutOfDate\'">\r\n                <div class="col-xs-12">\r\n                    <uib-alert type="success" translate>\r\n                        No medication alerts or precautions were found.\r\n                    </uib-alert>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-if="$ctrl.screening.Status === \'CompletedWithAlerts\'">\r\n                \x3c!-- FDB Alerts --\x3e\r\n                <div class="col-xs-12">\r\n                    <div ng-if="$ctrl.screening.ProposedDrug && $ctrl.screening.ProposedDrug.IsUserDefined">\r\n                        <uib-alert type="danger">{{::\'Drug screening cannot be performed with a user defined medication.\' | translate}}</uib-alert>\r\n                    </div>\r\n                    <div ng-if="$ctrl.screening.ActXResult">\r\n                        <uib-alert type="warning" translate>ActX result available below.</uib-alert>\r\n                    </div>\r\n\r\n                    <div ng-if="!($ctrl.screening.ProposedDrug && $ctrl.screening.ProposedDrug.IsUserDefined)">\r\n                        <div class="" ng-if="$ctrl.screening.InteractionResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.InteractionResult.OverallSeverity)" translate>\r\n                                INTERACTION ALERT\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="interactionFinding in $ctrl.screening.InteractionResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(interactionFinding.Severity)">\r\n                                    {{ $ctrl.getInteractionSeverityTitle(interactionFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span>Use of</span>\r\n                                    <span class="medication-name">{{ interactionFinding.FirstMedicationName }}</span>\r\n                                    <span>and</span>\r\n                                    <span class="medication-name">{{ interactionFinding.SecondMedicationName }}</span>\r\n                                    <span>may interact based on the potential interaction between</span>\r\n                                    <span class="interaction-description">{{ interactionFinding.Description + \'.\' }}</span>\r\n                                    <div class="interaction-effect" ng-repeat="effect in interactionFinding.Effects">\r\n                                        <span class="effect-label">Effect:</span>\r\n                                        <span>{{ effect }}</span>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.DuplicateTherapyResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.DuplicateTherapyResult.OverallSeverityLevel)" translate>\r\n                                DUPLICATE THERAPY ALERT\r\n                            </h4>\r\n                            <div class="warning" ng-repeat="duplicateTherapyWarning in $ctrl.screening.DuplicateTherapyResult.Warnings">\r\n                                <span>Use of</span>\r\n                                <span class="medication-name">{{ duplicateTherapyWarning.FirstMedicationName }}</span>\r\n                                <span>and</span>\r\n                                <span class="medication-name">{{ duplicateTherapyWarning.SecondMedicationName }}</span>\r\n                                <span>may represent a duplication in therapy based on their association to the therapeutic drug class</span>\r\n                                <span class="class-description">{{ duplicateTherapyWarning.ClassDescription + \'.\' }}</span>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.DuplicateIngredientResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.DuplicateIngredientResult.OverallSeverityLevel)" translate>\r\n                                DUPLICATE INGREDIENT ALERT\r\n                            </h4>\r\n                            <div class="warning" ng-repeat="duplicateIngredientWarning in $ctrl.screening.DuplicateIngredientResult.Warnings">\r\n                                <span>Use of</span>\r\n                                <span class="medication-name">{{ duplicateIngredientWarning.FirstMedicationName }}</span>\r\n                                <span>and</span>\r\n                                <span class="medication-name">{{ duplicateIngredientWarning.SecondMedicationName }}</span>\r\n                                <span>{{ \'represent a duplication based on the following ingredient\' + (duplicateIngredientWarning.IngredientListCount > 1 ? \'s\' : \'\') + \':\' }}</span>\r\n                                <span class="ingredient-list">{{ duplicateIngredientWarning.IngredientList + \'.\' }}</span>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.AllergyResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.AllergyResult.OverallSeverityLevel)" translate>\r\n                                ALLERGY ALERT\r\n                            </h4>\r\n                            <div class="warning" ng-repeat="allergyWarning in $ctrl.screening.AllergyResult.Warnings">\r\n                                <span>Use of</span>\r\n                                <span class="medication-name">{{ allergyWarning.MedicationName }}</span>\r\n                                <span>may result in an allergic reaction based on a reported history of allergy to</span>\r\n                                <span class="allergen">{{ allergyWarning.AllergenName + \'.\' }}</span>\r\n                                <div class="allergy-indent">\r\n                                    <div ng-show="allergyWarning.Ingredient">\r\n                                        <span class="allergy-label">Ingredient:</span>\r\n                                        {{allergyWarning.Ingredient}}\r\n                                    </div>\r\n                                    <div ng-show="allergyWarning.InactiveIngredient">\r\n                                        <span class="allergy-label">Inactive Ingredient:</span>\r\n                                        {{allergyWarning.InactiveIngredient}}\r\n                                    </div>\r\n                                    <div ng-show="allergyWarning.SpecificAllergenGroup">\r\n                                        <span class="allergy-label">Specific Allergen Group:</span>\r\n                                        {{allergyWarning.SpecificAllergenGroup}}\r\n                                    </div>\r\n                                    <div ng-show="allergyWarning.CrossSensitivity">\r\n                                        <span class="allergy-label">Cross Sensitivity:</span>\r\n                                        {{allergyWarning.CrossSensitivity}}\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.MedicalConditionResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.MedicalConditionResult.OverallSeverity)" translate>\r\n                                MEDICAL CONDITION PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="medicalConditionFinding in $ctrl.screening.MedicalConditionResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(medicalConditionFinding.Severity)">\r\n                                    {{ $ctrl.getMedicalConditionSeverityTitle(medicalConditionFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span>Use of</span>\r\n                                    <span class="medication-name">{{ medicalConditionFinding.MedicationName }}</span>\r\n                                    <span>is contraindicated when</span>\r\n                                    <span>{{ medicalConditionFinding.FdbDescription + \',\' }}</span>\r\n                                    <span>a condition related to</span>\r\n                                    <span>{{ medicalConditionFinding.DiseaseDescription + \',\' }}</span>\r\n                                    <span>exists.</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.PregnancyResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.PregnancyResult.OverallSeverity)" translate>\r\n                                PREGNANCY PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="pregnancyFinding in $ctrl.screening.PregnancyResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(pregnancyFinding.Severity)">\r\n                                    {{ $ctrl.getPregnancySeverityTitle(pregnancyFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span class="medication-name">{{ pregnancyFinding.MedicationName }}</span>\r\n                                    <span>{{ pregnancyFinding.Narrative }}</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.LactationResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.LactationResult.OverallSeverity)" translate>\r\n                                LACTATION PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="lactationFinding in $ctrl.screening.LactationResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(lactationFinding.Severity)">\r\n                                    {{ $ctrl.getLactationSeverityTitle(lactationFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span class="medication-name">{{ lactationFinding.MedicationName }}</span>\r\n                                    <span>(due to</span>\r\n                                    <span class="ingredient-name">{{ lactationFinding.Description }}</span>\r\n                                    <span>ingredient)</span>\r\n                                    <span>{{ lactationFinding.SeverityDescription }}</span>\r\n                                    <br/>\r\n                                    <span>{{ lactationFinding.EffectsOnInfant + \',\' }}</span>\r\n                                    <br/>\r\n                                    <span>{{ lactationFinding.ExcretionPotential + \',\' }}</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.PediatricResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.PediatricResult.OverallSeverity)" translate>\r\n                                PEDIATRIC PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="pediatricFinding in $ctrl.screening.PediatricResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(pediatricFinding.Severity)">\r\n                                    {{ $ctrl.getPediatricSeverityTitle(pediatricFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span class="medication-name">{{ pediatricFinding.MedicationName }}</span>\r\n                                    <span>{{ pediatricFinding.Narrative }}</span>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.GeriatricResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverity($ctrl.screening.GeriatricResult.OverallSeverity)" translate>\r\n                                GERIATRIC PRECAUTION\r\n                            </h4>\r\n                            <div class="finding" ng-repeat="geriatricFinding in $ctrl.screening.GeriatricResult.Findings">\r\n                                <h5 ng-class="$ctrl.getClassFromSeverity(geriatricFinding.Severity)">\r\n                                    {{ $ctrl.getGeriatricSeverityTitle(geriatricFinding) }}\r\n                                </h5>\r\n                                <div class="finding-content">\r\n                                    <span class="medication-name">{{ geriatricFinding.MedicationName }}</span>\r\n                                    <span class="geriatric-narrative">{{ geriatricFinding.Narrative }}</span>\r\n                                    <div ng-if="geriatricFinding.DrugListNames && geriatricFinding.DrugListNames.length">\r\n                                        <br/>\r\n                                        <span class="medication-name">{{ geriatricFinding.MedicationName }}</span>\r\n                                        <span>{{ \'is included in the following "potentially harmful drugs in the elderly" list\' + (geriatricFinding.DrugListNames.length > 1 ? \'s\' : \'\') + \':\' }}</span>\r\n                                        <span class="geriatric-drug-lists">{{ geriatricFinding.DrugListNames.join(\', \') + \'.\' }}</span>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.UserDefinedAllergyResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.UserDefinedAllergyResult.OverallSeverityLevel)" translate>\r\n                                USER DEFINED ALLERGIES\r\n                            </h4>\r\n                            <div class="warning">\r\n                                <span>The following drug allergies were not included in any allergy to drug screening test:</span>\r\n                                <span ng-repeat="userDefinedAllergyWarning in $ctrl.screening.UserDefinedAllergyResult.Warnings">\r\n                                    {{ userDefinedAllergyWarning.AllergyName + ($last ? \'\' : \',\') }}\r\n                                </span>\r\n                            </div>\r\n                        </div>\r\n                        <div class="" ng-if="$ctrl.screening.UserDefinedMedicationResult">\r\n                            <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.UserDefinedMedicationResult.OverallSeverityLevel)" translate>\r\n                                USER DEFINED MEDICATIONS\r\n                            </h4>\r\n                            <div class="warning">\r\n                                <span>The following medications were not included in any drug screening test:</span>\r\n                                <span ng-repeat="userDefinedMedicationWarning in $ctrl.screening.UserDefinedMedicationResult.Warnings">\r\n                                    {{ userDefinedMedicationWarning.MedicationName + ($last ? \'\' : \',\') }}\r\n                                </span>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="$ctrl.screening.DisclaimerText">\r\n            <hr/>\r\n            <div class="row">\r\n                <div id="ndd-legal-alert" class="col-xs-12">\r\n                    {{$ctrl.screening.DisclaimerText}}\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="$ctrl.screening.Version">\r\n            <hr/>\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    <div ng-if="$ctrl.screening.Version.ExpirationWarning">{{$ctrl.screening.Version.ExpirationWarning}}</div>\r\n                    <div>{{$ctrl.screening.Version.VersionInformation}}</div>\r\n                    <div>{{$ctrl.screening.Version.Copyright}}</div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div ng-if="!$ctrl.screening.Error && $ctrl.screening.Status === \'CompletedWithAlerts\'">\r\n            \x3c!-- Non-FDB Alerts --\x3e\r\n            <div ng-if="$ctrl.screening.ActXResult">\r\n                <hr/>\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <h4 ng-class="$ctrl.getClassFromSeverityLevel($ctrl.screening.ActXResult.OverallSeverityLevel)" translate>\r\n                            ACTX ALERT\r\n                        </h4>\r\n                        <div class="warning">\r\n                            <div ng-repeat="actXWarning in $ctrl.screening.ActXResult.Warnings">\r\n                                <div class="medication-name">{{ actXWarning.MedicationName }}</div>\r\n                                <div>\r\n                                    Seriousness: {{actXWarning.Seriousness}}\r\n                                </div>\r\n                                <div>\r\n                                    Summary: {{actXWarning.ShortSummary}}\r\n                                </div>\r\n                                <div>\r\n                                    Additional Information: {{actXWarning.ExtendedSummary}}\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/pmbcMedication.html",'<div class="col-xs-12 col-xs-flush medication">\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'clickable\': ($ctrl.med.MedId > 0), \'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         title="{{ $ctrl.med.Description }}"\r\n         ng-click="$ctrl.onSelect()">\r\n\r\n        Drug Description: {{ $ctrl.med.Description }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis">\r\n        Formulary Status: {{ $ctrl.med.FormularyStatus }}\r\n    </div>\r\n    <div class="hidden-xs hidden-sm col-md-4 overflow-ellipsis" ng-if="!$ctrl.med.ShowDetails">\r\n        &nbsp;\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis">\r\n        Quantity Requested: {{ $ctrl.med.QuantityRequested }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis">\r\n        Days Supply Requested: {{ $ctrl.med.DaysSupplyRequested }}\r\n    </div>\r\n    <div class="hidden-xs hidden-sm col-md-4 overflow-ellipsis" ng-if="!$ctrl.med.ShowDetails">\r\n        &nbsp;\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.ProductCode">\r\n        {{ $ctrl.med.ProductCodeQualifier}}: {{ $ctrl.med.ProductCode }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.Strength">\r\n        Strength: {{ $ctrl.med.Strength }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.DrugDbCode">\r\n        {{ $ctrl.med.DrugDbCodeQualifier}}: {{ $ctrl.med.DrugDbCode }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.DeaSchedule">\r\n        DEA Schedule: {{ $ctrl.med.DeaSchedule }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.Quantity">\r\n        Quantity: {{ $ctrl.med.Quantity }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.WrittenDate">\r\n        Date Written: {{ $ctrl.med.WrittenDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.LastFillDate">\r\n        Last Fill Date: {{ $ctrl.med.LastFillDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.ExpirationDate">\r\n        Expiration Date: {{ $ctrl.med.ExpirationDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.EarliestFillDate">\r\n        Earliest Fill Date: {{ $ctrl.med.EarliestFillDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.PeriodEndDate">\r\n        Period End Date: {{ $ctrl.med.PeriodEndDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.DeliveredOnDate">\r\n        Date Delivered: {{ $ctrl.med.DeliveredOnDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.ValidatedOnDate">\r\n        Date Validated: {{ $ctrl.med.ValidatedOnDate }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.DispenseAsWritten">\r\n        DAW: {{ $ctrl.med.DispenseAsWritten }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.NumberOfRefills">\r\n        # of Refills: {{ $ctrl.med.NumberOfRefills }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{ \'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         ng-if="$ctrl.med.ShowDetails && $ctrl.med.Diagnoses">\r\n\r\n        Diagnoses: {{ $ctrl.med.Diagnoses }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.CouponNumber">\r\n        Coupon Number: {{ $ctrl.med.CouponNumber }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{ \'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         ng-if="$ctrl.med.ShowDetails && $ctrl.med.Note">\r\n\r\n        Note: {{ $ctrl.med.Note }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.PriorAuthorization">\r\n        Prior Authorization: {{ $ctrl.med.PriorAuthorization }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.PriorAuthorizationStatus">\r\n        Prior Authorization Status: {{ $ctrl.med.PriorAuthorizationStatus }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.CompoundInformation">\r\n        Compound Info: {{ $ctrl.med.CompoundInformation }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{ \'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         ng-if="$ctrl.med.ShowDetails && $ctrl.med.SigText">\r\n\r\n        Sig Text: {{ $ctrl.med.SigText }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.RefillsRemaining">\r\n        Refills Remaining: {{ $ctrl.med.RefillsRemaining }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.RefillsLimit">\r\n        Refills Limit: {{ $ctrl.med.RefillsLimit }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.ReasonForDawCode">\r\n        Reason for DAW: {{ $ctrl.med.ReasonForDawCode }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && $ctrl.med.OfficeOfPharmacyAffairsId">\r\n        Office of Pharmacy Affairs ID: {{ $ctrl.med.OfficeOfPharmacyAffairsId }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4" ng-if="$ctrl.showDrugIcons">\r\n        <sigwriter-drug-icon-group drug="$ctrl.med.Drug" />\r\n    </div>\r\n</div>\r\n<div>\r\n    <div class="col-xs-12 col-xs-flush col-sm-6 col-md-4 pricing-spacer"\r\n         ng-repeat="pricingCoverage in $ctrl.med.PricingCoverages track by $index">\r\n        <div class="col-xs-12 col-xs-flush pricing">\r\n            <div class="col-xs-12"\r\n                 ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails, \'clickable\': pricingCoverage.PharmacyId }"\r\n                 title="{{ (pricingCoverage.PharmacyType || \'\') + \' \' + pricingCoverage.PharmacyName }}"\r\n                 ng-click="$ctrl.onSelect(pricingCoverage)">\r\n\r\n                Pharmacy<span ng-if="pricingCoverage.PharmacyType" ng-bind="pricingCoverage.PharmacyType"></span>: <span class="detail-emphasis" ng-bind="pricingCoverage.PharmacyName"></span>\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="pricingCoverage.QuantityPriced">\r\n                Quantity Priced: {{ pricingCoverage.QuantityPriced }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="pricingCoverage.DaysSupplyPriced">\r\n                Days Supply Priced: {{ pricingCoverage.DaysSupplyPriced }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="pricingCoverage.PatientPayAmount">\r\n                Est. Patient Pay Amount: <span class="detail-emphasis" ng-bind="pricingCoverage.PatientPayAmount | currency"></span>\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.DrugStatus">\r\n                Drug Status: {{ pricingCoverage.DrugStatus }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.FormularyStatus">\r\n                Formulary Status: {{ pricingCoverage.FormularyStatus }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.PriorAuthRequired">\r\n                Prior Auth Required: {{ pricingCoverage.PriorAuthRequired }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.OutOfPocketAppliedAmount">\r\n                OOP Applied Amount: {{ pricingCoverage.OutOfPocketAppliedAmount | currency }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.OutOfPocketRemainingAmount">\r\n                OOP Remaining Amount: {{ pricingCoverage.OutOfPocketRemainingAmount | currency }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.DeductibleAppliedAmount">\r\n                Deductible Applied Amount: {{ pricingCoverage.DeductibleAppliedAmount | currency }}\r\n            </div>\r\n            <div class="col-xs-12 overflow-ellipsis" ng-if="$ctrl.med.ShowDetails && pricingCoverage.DeductibleRemainingAmount">\r\n                Deductible Remaining Amount: {{ pricingCoverage.DeductibleRemainingAmount | currency }}\r\n            </div>\r\n            <div class="col-xs-12 col-xs-flush"\r\n                 ng-if="pricingCoverage.Restrictions && (pricingCoverage.Restrictions.length > 0)"\r\n                 title="{{ pricingCoverage.Restrictions.join(\', \') }}">\r\n\r\n                Restrictions/Alerts: <ul><li ng-repeat="restriction in pricingCoverage.Restrictions track by $index" list-group-item"" ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails }">{{ restriction }}</li></ul>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/rfsMedication.html",'<div class="col-xs-12 col-xs-flush medication">\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails, \'clickable\': ($ctrl.med.MedId > 0) }"\r\n         title="{{ $ctrl.med.Description }}"\r\n         ng-click="$ctrl.onSelect()">\r\n\r\n        Name: {{ $ctrl.med.Description }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis"\r\n         title="{{ $ctrl.med.FormularyStatus }}">\r\n\r\n        Formulary Status: {{ $ctrl.med.FormularyStatus }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 overflow-ellipsis"\r\n         ng-if="$ctrl.med.FormularyCost">\r\n\r\n        Formulary Cost: {{ $ctrl.med.FormularyCost }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         ng-repeat="copay in $ctrl.med.FormularyCopays track by $index">\r\n\r\n        {{ copay }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         title="{{ $ctrl.med.DrugClass }}">\r\n\r\n        Drug Class: {{ $ctrl.med.DrugClass }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-class="{\'overflow-ellipsis\': !$ctrl.med.ShowDetails }"\r\n         title="{{ $ctrl.med.DrugType }}">\r\n\r\n        Drug Type: {{ $ctrl.med.DrugType }}\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4 coverage-factors"\r\n         ng-if="$ctrl.med.CoverageFactors && $ctrl.med.CoverageFactors.length">\r\n\r\n        Restrictions:\r\n        <span ng-if="!$ctrl.med.ShowDetails" ng-bind="$ctrl.formatRestrictions($ctrl.med.FormularyCoverageRestrictions)"></span>\r\n        <ul ng-if="$ctrl.med.ShowDetails">\r\n            <li ng-repeat="coverageFactor in $ctrl.med.CoverageFactors track by $index" ng-bind-html="$ctrl.$sce.trustAsHtml(coverageFactor)"></li>\r\n        </ul>\r\n    </div>\r\n    <div class="col-xs-12 col-sm-6 col-md-4"\r\n         ng-if="$ctrl.showDrugIcons">\r\n\r\n        <sigwriter-drug-icon-group drug="$ctrl.med.Drug" />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/rxFormularyDetails.html",'<div id="rx-formulary-display">\r\n\t<div id="rx-formulary-loading" ng-show="$ctrl.loading">\r\n\t\t<div class="row">\r\n\t\t\t<div class="col-xs-12 text-center">\r\n\t\t\t\tLoading Formulary Details\r\n\t\t\t\t<br/>\r\n\t\t\t\t<ap-spinner data-size="3"></ap-spinner>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\r\n\t<div ng-show="!$ctrl.loading && !$ctrl.$scope.httpError && $ctrl.details && !$ctrl.showResponseXml && !$ctrl.showRFSResponseXml">\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponsePMBC.Medications && $ctrl.details.ResponsePMBC.Medications.length > 0">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'!Alternative\'} : true">\r\n\t\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Medication Requested" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t\t<sigwriter-pmbc-medication\r\n\t\t\t\t\t\tmed="med"\r\n\t\t\t\t\t\tshow-drug-icons="$ctrl.showDrugIcons"\r\n\t\t\t\t\t\tselect="$ctrl.changeMedication(med, pricingCoverage)"\r\n\t\t\t\t\t/>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div ng-repeat="med in $ctrl.details.ResponsePMBC.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true">\r\n\t\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Alternative Medications" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t\t<sigwriter-pmbc-medication\r\n\t\t\t\t\t\tmed="med"\r\n\t\t\t\t\t\tshow-drug-icons="$ctrl.showDrugIcons"\r\n\t\t\t\t\t\tselect="$ctrl.changeMedication(med, pricingCoverage)"\r\n\t\t\t\t\t/>\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails = !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails">Transmit Status - Patient Medication Benefit Check<span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.Status }}">\r\n\t\t\t\t\t\tStatus: {{ $ctrl.details.ResponsePMBC.TransmitStatus.Status }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.Response }}">\r\n\t\t\t\t\t\tResponse: {{ $ctrl.details.ResponsePMBC.TransmitStatus.Response }} <button ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.ResponseXml && $ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showResponseXml = true;"><span>View Response</span></button>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus">\r\n\t\t\t\t\t\tDeny Status: {{ $ctrl.details.ResponsePMBC.TransmitStatus.DenyStatus }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponsePMBC.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponsePMBC.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponsePMBC.TransmitStatus.RequestError">\r\n\t\t\t\t\t\tRequest Error: {{ $ctrl.details.ResponsePMBC.TransmitStatus.RequestError }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponseRFS.Medications && $ctrl.details.ResponseRFS.Medications.length > 0">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'!Alternative\'} : true">\r\n\t\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Formulary Medication" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t\t<sigwriter-rfs-medication\r\n\t\t\t\t\t\tmed="med"\r\n\t\t\t\t\t\tshow-drug-icons="$ctrl.showDrugIcons"\r\n\t\t\t\t\t\tselect="$ctrl.changeMedication(med)"\r\n\t\t\t\t\t/>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div ng-repeat="med in $ctrl.details.ResponseRFS.Medications | filter: { MedicationAlternativeType: \'Alternative\'} : true">\r\n\t\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="med.ShowDetails = !med.ShowDetails">{{ $index == 0 ? "Formulary Alternatives" : "" }}<span class="pull-right"><i class="fa" ng-class="!med.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t\t<sigwriter-rfs-medication\r\n\t\t\t\t\t\tmed="med"\r\n\t\t\t\t\t\tshow-drug-icons="$ctrl.showDrugIcons"\r\n\t\t\t\t\t\tselect="$ctrl.changeMedication(med)"\r\n\t\t\t\t\t/>\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponseRFS.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails = !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails">Transmit Status - Representative Formulary Service<span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.Status }}">\r\n\t\t\t\t\t\tStatus: {{ $ctrl.details.ResponseRFS.TransmitStatus.Status }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.Response }}">\r\n\t\t\t\t\t\tResponse: {{ $ctrl.details.ResponseRFS.TransmitStatus.Response }} <button ng-if="$ctrl.details.ResponseRFS.TransmitStatus.ResponseXml && $ctrl.details.ResponseRFS.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showRFSResponseXml = true;"><span>View Response</span></button>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponseRFS.TransmitStatus.DenyStatus">\r\n\t\t\t\t\t\tDeny Status: {{ $ctrl.details.ResponseRFS.TransmitStatus.DenyStatus }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRFS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRFS.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponseRFS.TransmitStatus.RequestError">\r\n\t\t\t\t\t\tRequest Error: {{ $ctrl.details.ResponseRFS.TransmitStatus.RequestError }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponseRTPS.copayAssistance && !$ctrl.hideTransmitStatus">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponseRTPS.copayAssistance.ShowDetails=!$ctrl.details.ResponseRTPS.copayAssistance.ShowDetails"> Real-Time Patient Savings <span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponseRTPS.copayAssistance.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush rtps">\r\n\r\n\t\t\t    \t<div  class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.responseMessageLong" >\r\n\t\t\t\t\t\t<span> Offer: </span> <span ng-bind-html=$ctrl.details.ResponseRTPS.copayAssistance.responseMessageLong></span>\r\n\t\t\t \t   </div>\r\n\t\t\t\t\t<div  class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.responseMessageBrief" >\r\n\t\t\t\t\t\t<span> Additional Offer Info: </span> <span ng-bind-html=$ctrl.details.ResponseRTPS.copayAssistance.responseMessageBrief></span>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.drug">\r\n\t\t\t\t\t\tDrug: {{$ctrl.details.ResponseRTPS.copayAssistance.drug}}\r\n\t\t\t\t\t</div>\r\n\r\n\t\t\t\t\t<div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.couponUrl">\r\n\t\t\t   \t\t\tCoupon Url:  <a ng-href={{$ctrl.details.ResponseRTPS.copayAssistance.couponUrl}} target="_blank">\r\n\t\t\t\t\t\t<span class="detail-emphasis">Link to Patient-Savings</span> </a>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.offerAmount">\r\n\t\t\t\t\t\tOffer Amount: <span class="detail-emphasis">{{$ctrl.details.ResponseRTPS.copayAssistance.offerAmount | currency }}</span>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.patientPayAmountAdjustedByOffer">\r\n\t\t\t\t\t\tEst. patient pay amount w/coupon:<span>{{$ctrl.details.ResponseRTPS.copayAssistance.patientPayAmountAdjustedByOffer | currency }}</span>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-if="$ctrl.details.ResponseRTPS.copayAssistance.offerAmountToApply">\r\n\t\t\t\t\t\tOffer Amount To Apply: <span>{{$ctrl.details.ResponseRTPS.copayAssistance.offerAmountToApply | currency }} </span>\r\n\t\t\t\t\t</div>\r\n\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t\t</div>\r\n\r\n\t\t<div class="row" ng-if="$ctrl.details.ResponseRTPS.TransmitStatus && !$ctrl.hideTransmitStatus">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<span class="col-xs-12 col-xs-flush header" ng-click="$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails = !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails">Transmit Status - Real-Time Patient Savings <span class="pull-right"><i class="fa" ng-class="!$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails ? \'fa-chevron-down\' : \'fa-chevron-up\'"></i></span></span>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRTPS.TransmitStatus.Status }}">\r\n\t\t\t\t\t\tStatus: {{ $ctrl.details.ResponseRTPS.TransmitStatus.Status }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRTPS.TransmitStatus.Response }}">\r\n\t\t\t\t\t\tResponse: {{$ctrl.details.ResponseRTPS.TransmitStatus.Response}} <button ng-if="$ctrl.details.ResponseRTPS.TransmitStatus.ResponseXml && $ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails" class="btn btn-xs" ng-click="$ctrl.showRTPSResponseXml = true;"><span>View Response</span></button>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRTPS.TransmitStatus.DenyStatus }}" ng-if="$ctrl.details.ResponseRTPS.TransmitStatus.DenyStatus">\r\n\t\t\t\t\t\tDeny Status: {{$ctrl.details.ResponseRTPS.TransmitStatus.DenyStatus}}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="col-xs-12" ng-class="{\'overflow-ellipsis\': !$ctrl.details.ResponseRTPS.TransmitStatus.ShowDetails }" title="{{ $ctrl.details.ResponseRTPS.TransmitStatus.RequestError }}" ng-if="$ctrl.details.ResponseRTPS.TransmitStatus.RequestError">\r\n\t\t\t\t\t\tRequest Error: {{ $ctrl.details.ResponseRTPS.TransmitStatus.RequestError }}\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\r\n\t</div>\r\n\r\n\t<div ng-show="$ctrl.showResponseXml">\r\n\t\t<div class="row">\r\n\t\t\t<div class="col-xs-12 col-xs-flush response-xml">\r\n\t\t\t\t<div class="col-xs-12">\r\n\t\t\t\t\t<span class="pull-left header">Response XML</span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<pre ng-bind="$ctrl.details.ResponsePMBC.TransmitStatus.ResponseXml" />\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\r\n\t<div ng-show="$ctrl.showRFSResponseXml">\r\n\t\t<div class="row">\r\n\t\t\t<div class="col-xs-12 col-xs-flush response-xml">\r\n\t\t\t\t<div class="col-xs-12">\r\n\t\t\t\t\t<span class="pull-left header">Response XML</span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showRFSResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<pre ng-bind="$ctrl.details.ResponseRFS.TransmitStatus.ResponseXml" />\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\r\n\t<div ng-show="$ctrl.showRTPSResponseXml">\r\n\t\t<div class="row">\r\n\t\t\t<div class="col-xs-12 col-xs-flush response-xml">\r\n\t\t\t\t<div class="col-xs-12">\r\n\t\t\t\t\t<span class="pull-left header">Response Json </span> <button class="btn btn-xs pull-right" ng-click="$ctrl.showRTPSResponseXml = false;"><span><i class="fa fa-close" /></span></button>\r\n\t\t\t\t</div>\r\n\t\t\t\t<div class="col-xs-12 col-xs-flush medication">\r\n\t\t\t\t\t<pre ng-bind="$ctrl.details.ResponseRTPS.TransmitStatus.ResponseXml" />\r\n\t\t\t\t</div>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\t<div ng-show="!$ctrl.loading && !$ctrl.$scope.httpError && !$ctrl.details">\r\n\t\t<div class="col-xs-12">\r\n\t\t\t<uib-alert type="success" translate>\r\n\t\t\t\tNo formulary details were found.\r\n\t\t\t</uib-alert>\r\n\t\t</div>\r\n\t</div>\r\n\r\n\t<div ng-show="$ctrl.$scope.httpError">\r\n\t\t<div class="col-xs-12">\r\n\t\t\t<uib-alert type="danger" translate>\r\n\t\t\t\tThere was a communication issue with the server.  Please contact support.\r\n\t\t\t</uib-alert>\r\n\t\t</div>\r\n\t</div>\r\n</div>\r\n'),$templateCache.put("/sigwriter/component-views/sigwriterTabletShell.html",'<form name="$ctrl.tabletShellForm" class="desktop-form" id="sigwriter-tablet-shell" ng-if="!$ctrl.resetting">\r\n    <div class="sigwriter-tablet-grid">\r\n        <div class="row sigwriter-tablet-content-row" ng-class="(!$ctrl.displayPdr) ? \'expanded\' : \'\'">\r\n            <div id="sigwriter-content-column" class="sigwriter-tablet-content-column" ng-class="$ctrl.getContentColumnClass()">\r\n                <div class="sigwriter-tablet-content">\r\n                    <sigwriter-tablet-directions\r\n                        form="$ctrl.tabletShellForm"\r\n                        hosted-from-desktop="$ctrl.hostedFromDesktop"\r\n                        patient-details="$ctrl.patientDetails"\r\n                        rx-options="$ctrl.rxOptions"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        sig-formulary="$ctrl.currentRx.sigFormulary"\r\n                        sig-instruction="$ctrl.currentInstruction"\r\n                        sig-options="$ctrl.currentRx.options"\r\n                        sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                        set-drug-from-search-result="$ctrl.setDrugFromSearchResult(selectedDrug)"\r\n                        update-sig-instruction="$ctrl.updateSigInstruction(updatedSigInstruction)"\r\n                        update-sig-options="$ctrl.updateSigOptions(updatedSigOptions)"\r\n                        update-sig-options-non-formulary="$ctrl.updateSigOptionsNonFormulary(updatedSigOptionsNonFormulary)">\r\n                    </sigwriter-tablet-directions>\r\n                </div>\r\n            </div>\r\n            <div class="sigwriter-tablet-info-column" ng-class="$ctrl.getInfoColumnClass()">\r\n                <div class="sigwriter-tablet-additional-info sigwriter-tablet-tile">\r\n                    <div class="sigwriter-tablet-additional-info-content sigwriter-tablet-tile-content">\r\n                        <sigwriter-tablet-additional-info\r\n                            sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                            show-additional-info-modal="$ctrl.showAdditionalInfoModal()"\r\n                        />\r\n                    </div>\r\n                </div>\r\n                <div class="sigwriter-tablet-drug-screening sigwriter-tablet-tile" ng-if="!$ctrl.disableDrugScreening">\r\n                    <div class="sigwriter-tablet-drug-screening-content sigwriter-tablet-tile-content">\r\n                        <sigwriter-tablet-drug-screening\r\n                            drug-screening="$ctrl.currentRx.drugScreening"\r\n                            rx-parameters="$ctrl.rxParameters"\r\n                            show-detailed-screening-modal="$ctrl.showDetailedScreeningModal()"\r\n                            update-drug-screening="$ctrl.updateDrugScreening(drugScreening)"\r\n                            update-is-screening-loaded="$ctrl.updateIsScreeningLoaded(isLoaded, isOverrideRequired)"\r\n                        />\r\n                    </div>\r\n                </div>\r\n                <div class="sigwriter-tablet-formulary sigwriter-tablet-tile" ng-if="!$ctrl.disableFormulary">\r\n                    <div class="sigwriter-tablet-formulary-content sigwriter-tablet-tile-content">\r\n                        <sigwriter-tablet-formulary-alternatives\r\n                            rel-visit-medication-id="$ctrl.currentRx.relVisitMedicationId"\r\n                            rx-parameters="$ctrl.rxParameters"\r\n                            sig-formulary="$ctrl.currentRx.sigFormulary"\r\n                            sig-instruction="$ctrl.currentInstruction"\r\n                            sig-options="$ctrl.currentRx.options"\r\n                            sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                            on-drug-selected="$ctrl.setNewDrug(drug, pharmacy)"\r\n                            update-rel-visit-medication-id="$ctrl.updateRelVisitMedicationId(relVisitMedicationId)"\r\n                            update-sig-formulary="$ctrl.updateSigFormulary(sigFormulary)"\r\n                            update-sig-options="$ctrl.updateSigOptions(sigOptions)"\r\n                        />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="row sigwriter-tablet-pdr-row" ng-show="$ctrl.displayPdr">\r\n            <div class="col-xs-12">\r\n                <div class="sigwriter-tablet-pdr">\r\n                    <sigwriter-tablet-pdr\r\n                        drug="$ctrl.rxParameters.drug"\r\n                        patient-id="$ctrl.rxParameters.patientId"\r\n                        rx-id="$ctrl.rxParameters.rxId"\r\n                        sig-type="$ctrl.rxParameters.sigType"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="row sigwriter-tablet-buttons-row">\r\n            <div class="col-xs-12 sigwriter-tablet-buttons-column">\r\n                <div class="sigwriter-tablet-buttons">\r\n                    <div class="sigwriter-tablet-left-buttons">\r\n                        <button type="button" class="btn btn-primary pull-left" ng-show="$ctrl.displaySaveDefaultSIG" ng-click="$ctrl.saveDefaultSig()"><span ng-hide="$ctrl.saveDefaultSigLoading">{{::\'Save Default SIG\' | translate}}</span><ap-spinner class="save-default-sig" ng-show="$ctrl.saveDefaultSigLoading"></ap-spinner></button>\r\n                        <button type="button" class="btn btn-default btn-pdr" ng-click="$ctrl.togglePdr()"><i class="ap-pdr" title="Toggle PDR"></i><i ng-class="($ctrl.displayPdr) ? \'ap-chevron-down-gray\' : \'ap-chevron-up-gray\'"></i></button>\r\n                    </div>\r\n                    <div class="sigwriter-tablet-right-buttons pull-right" ng-class="$ctrl.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n                        <button type="button" class="btn btn-primary" ng-click="$ctrl.cancel()">{{::\'Cancel\' | translate}}</button>\r\n                        <button type="submit" class="btn btn-primary" ng-hide="$ctrl.defaultSigContext" ng-click="$ctrl.save()">\r\n                            <ap-spinner size="1" ng-show="$ctrl.isSaving"></ap-spinner>\r\n                            {{::\'Save\' | translate}}\r\n                        </button>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</form>'),$templateCache.put("/sigwriter/component-views/sigwriterWizardShell.html",'<wizard name="{{$ctrl.wizardName}}" hide-indicators="true" on-finish="$ctrl.onFinish()">\r\n    <div class="modal-header modal-header-slim">\r\n        <ul class="ap-steps-indicator steps-{{$ctrl.getWizard().getEnabledSteps().length}}">\r\n            <li ng-repeat="step in $ctrl.getWizard().getEnabledSteps()">\r\n                <i ng-class="$ctrl.getStepIconClass(step)"\r\n                   id="{{$ctrl.getStepIconId(step)}}"\r\n                   ng-click="$ctrl.goToStep(step, $index + 1)">\r\n                </i>\r\n            </li>\r\n        </ul>\r\n    </div>\r\n    <div id=\'wizard-shell-body\' class="modal-body">\r\n        <wz-step wz-title="{{$ctrl.titles.sigInstructions}}" canexit="$ctrl.canAdvanceFromCurrentStep()">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.sigInstructions)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-sig-instructions\r\n                        disable-dates="$ctrl.disableSigDates"\r\n                        enable-medication-type-selection="$ctrl.enableMedicationTypeSelection"\r\n                        rx-options="$ctrl.rxOptions"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        sig-instruction="$ctrl.currentInstruction"\r\n                        sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                        apply-dosing-suggestion="$ctrl.applyDosingSuggestion(suggestion, instructionId)"\r\n                        register-form-submit-callback="$ctrl.registerFormSubmitCallback($ctrl.titles.sigInstructions, callbackFn)"\r\n                        update-is-valid="$ctrl.updateIsSigInstructionsValid(isValid)"\r\n                        update-sig-instruction="$ctrl.updateSigInstruction(sigInstruction)"\r\n                        update-sig-options-non-formulary="$ctrl.updateSigOptionsNonFormulary(sigOptionsNonFormulary)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.formularyAlternatives}}" wz-disabled="{{$ctrl.skipFormularyAlternatives}}">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.formularyAlternatives)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-formulary-alternatives-content\r\n                        is-active-step="$ctrl.getCurrentStepTitle() === $ctrl.titles.formularyAlternatives"\r\n                        rel-visit-medication-id="$ctrl.currentRx.relVisitMedicationId"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        sig-formulary="$ctrl.currentRx.sigFormulary"\r\n                        sig-instruction="$ctrl.currentInstruction"\r\n                        sig-options="$ctrl.currentRx.options"\r\n                        sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                        skip-formulary-alternatives="$ctrl.skipFormularyAlternatives"\r\n                        on-drug-selected="$ctrl.setNewDrug(drug, pharmacy)"\r\n                        update-is-available="$ctrl.updateIsFormularyAlternativesAvailable(isAvailable)"\r\n                        update-rel-visit-medication-id="$ctrl.updateRelVisitMedicationId(relVisitMedicationId)"\r\n                        update-sig-formulary="$ctrl.updateSigFormulary(sigFormulary)"\r\n                        update-sig-options="$ctrl.updateSigOptions(sigOptions)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.drugScreening}}">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.drugScreening)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-screening-content\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        update-drug-screening="$ctrl.updateDrugScreening(drugScreening)"\r\n                        update-is-screening-loaded="$ctrl.updateIsScreeningLoaded(isLoaded, isOverrideRequired, status)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.screeningOverride}}" wz-disabled="{{!$ctrl.isOverrideRequired}}">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.screeningOverride)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-screening-override\r\n                        drug-screening="$ctrl.currentRx.drugScreening"\r\n                        update-drug-screening="$ctrl.updateDrugScreening(drugScreening)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.sigOptions}}" canexit="$ctrl.canAdvanceFromCurrentStep()">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.sigOptions)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-sig-options\r\n                        rx-options="$ctrl.rxOptions"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        sig-formulary="$ctrl.currentRx.sigFormulary"\r\n                        sig-options="$ctrl.currentRx.options"\r\n                        sig-options-non-formulary="$ctrl.currentRx.optionsNonFormulary"\r\n                        register-form-submit-callback="$ctrl.registerFormSubmitCallback($ctrl.titles.sigOptions, callbackFn)"\r\n                        update-is-valid="$ctrl.updateIsSigOptionsValid(isValid)"\r\n                        update-sig-options="$ctrl.updateSigOptions(sigOptions)"\r\n                        update-sig-options-non-formulary="$ctrl.updateSigOptionsNonFormulary(sigOptionsNonFormulary)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n        <wz-step wz-title="{{$ctrl.titles.summary}}" canexit="$ctrl.canAdvanceFromCurrentStep()">\r\n            <div id="{{$ctrl.convertStepTitleToId($ctrl.titles.summary)}}" class="panel panel-default">\r\n                <div class="panel-body">\r\n                    <sigwriter-wizard-drug-description rx-parameters="$ctrl.rxParameters" />\r\n                    <sigwriter-wizard-review\r\n                        current-rx="$ctrl.currentRxClone"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                        register-form-submit-callback="$ctrl.registerFormSubmitCallback($ctrl.titles.summary, callbackFn)"\r\n                        update-epcs-signature="$ctrl.updateEpcsSignature(epcsSignature)"\r\n                        update-is-valid="$ctrl.updateIsSummaryValid(isValid)"\r\n                        update-sig-options="$ctrl.updateSigOptions(sigOptions)"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </wz-step>\r\n    </div>\r\n    <div class="modal-footer modal-footer-slim">\r\n        <div class="row">\r\n            <div class="col-xs-6">\r\n                <button id="previous-btn" type="submit" ng-hide="($ctrl.getWizard().currentStepNumber() === 1)" class="btn-modal btn-default" wz-previous>Back</button>\r\n            </div>\r\n            <div class="col-xs-6">\r\n                <button id="next-btn" type="submit" ng-hide="($ctrl.getWizard().currentStepNumber() === $ctrl.getWizard().getEnabledSteps().length)" class="btn-modal btn-default" wz-next="$ctrl.onNext()">Next</button>\r\n                <button id="finish-btn" type="submit" ng-show="($ctrl.getWizard().currentStepNumber() === $ctrl.getWizard().getEnabledSteps().length)" class="btn-modal btn-default" wz-finish>Finish</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</wizard>'),$templateCache.put("/sigwriter/component-views/tabletAdditionalInfo.html",'<div id="drug-tablet-additional-info-sidebar"></div>\r\n<div id="drug-tablet-additional-info-display">\r\n    <div>\r\n        <h4 class="additional-info-color"><b>{{$ctrl.getTitle()}}</b></h4>\r\n    </div>\r\n    <div class="show-details-container" ng-click="$ctrl.showDetails()">\r\n        <i class="clickable ap-expand-more"></i>\r\n    </div>\r\n    <div>\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n            <span class="additional-info-color" translate>Site:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.medicationSite.Name }}</span>\r\n        </div>\r\n        <div>\r\n            <span class="additional-info-color" translate>Lot #:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.lotNumber }}</span>\r\n        </div>\r\n        <div>\r\n            <span class="additional-info-color" translate>Manufacturer:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.manufacturer.Name }}</span>\r\n        </div>\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n            <span class="additional-info-color" translate>Funding Source:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.fundingSource.Name }}</span>\r\n        </div>\r\n        <div>\r\n            <span class="additional-info-color" translate>Expiration:</span>\r\n            <span><ap-date-formatter date="{{ $ctrl.sigOptionsNonFormulary.expirationDate }}" format="date"></ap-date-formatter></span>\r\n        </div>\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n            <span class="additional-info-color" translate>Initials:</span>\r\n            <span>{{ $ctrl.sigOptionsNonFormulary.initials }}</span>\r\n        </div>\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n            <span class="additional-info-color" translate>Administered Date:</span>\r\n            <span><ap-date-formatter date="{{ $ctrl.sigOptionsNonFormulary.administeredDateTime }}" format="date-time"></ap-date-formatter></span>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/tabletDirections.html",'<form id="drug-tablet-directions">\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="directions-header">\r\n                <a ng-if="$ctrl.allowSearchDrugDosage"\r\n                   class="clickable"\r\n                   ng-click="$ctrl.onClickSearchDrugDosage()"\r\n                   id="td-search-drug-dosage">\r\n                    {{$ctrl.rxParameters.drug.Description}}\r\n                </a>\r\n                <span ng-if="!$ctrl.allowSearchDrugDosage">\r\n                    {{$ctrl.rxParameters.drug.Description}}\r\n                </span>\r\n                <i class="ap-dosing-suggestions-black clickable"\r\n                    ng-click="$ctrl.onClickDosingSuggestions()"\r\n                    id="td-dosing-suggestions">\r\n                </i>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row">\r\n        <div class="col-xs-12" ng-if="$ctrl.warnings">\r\n            <div ng-repeat="(key, value) in $ctrl.warnings" ng-if="value">\r\n                <uib-alert type="warning" close="$ctrl.removeWarning(value, key)">{{value}}</uib-alert>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row" id="drug-tablet-directions-content">\r\n        <div class="col-xs-6">\r\n            <fieldset class="v18-fieldset" ap-fieldset-invalid="!$ctrl.isDirectionsValid()">\r\n                <legend>Directions ({{$ctrl.getRemainingSigCharacters()}} of {{($ctrl.updatedSigOptions && $ctrl.updatedSigOptions.pharmacy && $ctrl.updatedSigOptions.pharmacy.MasterPharmacy && $ctrl.updatedSigOptions.pharmacy.MasterPharmacy.SigDirectionsMaxLength) ? $ctrl.updatedSigOptions.pharmacy.MasterPharmacy.SigDirectionsMaxLength : 1000}})</legend>\r\n                <div class="rx-instructions-menu-text flexbox flexbox-horizontal-center flexbox-horizontal-wrap">\r\n\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                          data-text-value="$ctrl.updatedSigInstruction.startText">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.startText"\r\n                             id="td-start-text">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div>\r\n                        <div class="text-token instructions-action"\r\n                             ng-class="$ctrl.updatedSigInstruction.action.Name ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editAction()"\r\n                             id="td-edit-action">\r\n                            <span ng-if="$ctrl.updatedSigInstruction.action.Name && !$ctrl.updatedSigInstruction.action.isNull">\r\n                                {{$ctrl.updatedSigInstruction.action.Name}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.action || $ctrl.updatedSigInstruction.action.isNull || $ctrl.updatedSigInstruction.action.Name === 0" class="rx-instruction-placeholder">\r\n                                {{::\'Action\' | translate}}\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n\r\n\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.postAction">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.postAction"\r\n                             id="td-post-action">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div>\r\n                        <div class="text-token instructions-dosage"\r\n                             ng-class="$ctrl.updatedSigInstruction.dosage.Name ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editDosage()"\r\n                             id="td-edit-dosage">\r\n                            <span ng-if="$ctrl.updatedSigInstruction.dosage.Name && !$ctrl.updatedSigInstruction.dosage.isNull">\r\n                                {{$ctrl.updatedSigInstruction.dosage.Name}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.dosage || $ctrl.updatedSigInstruction.dosage.isNull || $ctrl.updatedSigInstruction.dosage.Name === 0" class="rx-instruction-placeholder">\r\n                                {{::\'Dosage\' | translate}}\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n\r\n\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.postDosage">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.postDosage"\r\n                             id="td-post-dosage">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div>\r\n                        <div class="text-token instructions-unit"\r\n                             ng-class="$ctrl.updatedSigInstruction.unit.Name ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editUnit()"\r\n                             id="td-edit-unit">\r\n                            <span ng-if="$ctrl.updatedSigInstruction.unit.Name && !$ctrl.updatedSigInstruction.unit.isNull">\r\n                                {{$ctrl.updatedSigInstruction.unit.Name || (\'Unit\' | translate)}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.unit || $ctrl.updatedSigInstruction.unit.isNull" class="rx-instruction-placeholder">\r\n                                {{::\'Unit\' | translate}}\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n\r\n\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.postUnit">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.postUnit"\r\n                             id="td-post-unit">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div>\r\n                        <div class="text-token instructions-route"\r\n                             ng-class="($ctrl.updatedSigInstruction.route | medCommonLanguage) ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editRoute()"\r\n                             id="td-edit-route">\r\n                            {{$ctrl.updatedSigInstruction.route | medCommonLanguage:false:\'Route\'}}\r\n                        </div>\r\n                    </div>\r\n\r\n\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.postRoute">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.postRoute"\r\n                             id="td-post-route">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div>\r\n                        <div class="text-token instructions-frequency"\r\n                             ng-class="($ctrl.updatedSigInstruction.frequency | medCommonLanguage) ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editFrequency()"\r\n                             id="td-edit-frequency">\r\n                            {{$ctrl.updatedSigInstruction.frequency | medCommonLanguage:false:\'Frequency\'}}\r\n                        </div>\r\n                    </div>\r\n\r\n\r\n                    <free-text-directions data-text-open="$ctrl.freeTextOpen"\r\n                                            data-text-value="$ctrl.updatedSigInstruction.postFrequency">\r\n                        <div contenteditable\r\n                             class="text-token"\r\n                             ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                             ng-model="$ctrl.updatedSigInstruction.postFrequency"\r\n                             id="td-post-frequency">\r\n                        </div>\r\n                    </free-text-directions>\r\n                    <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                        <div class="text-token instructions-prn-reason"\r\n                             ng-class="$ctrl.updatedSigInstruction.prnReason.Name ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editPrn()"\r\n                             id="td-edit-prn">\r\n                            <span ng-if="$ctrl.updatedSigInstruction.prnReason.Name && !$ctrl.updatedSigInstruction.prnReason.isNull">{{\'as needed\' | translate}}</span>\r\n                            <span ng-if="$ctrl.updatedSigInstruction.prnReason.Name && !$ctrl.updatedSigInstruction.prnReason.isNull">\r\n                                {{$ctrl.updatedSigInstruction.prnReason.Name || (\'PRN\' | translate)}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.prnReason || $ctrl.updatedSigInstruction.prnReason.isNull" class="rx-instruction-placeholder">\r\n                                {{::\'PRN\' | translate}}\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div contenteditable\r\n                         class="text-token"\r\n                         data-placeholder="Instructions"\r\n                         ng-change="$ctrl.onUpdatedSigInstructionChanged()"\r\n                         ng-model="$ctrl.updatedSigInstruction.endText"\r\n                         id="td-end-text">\r\n                    </div>\r\n                </div>\r\n\r\n\r\n                <div class="rx-instructions-menu-text flexbox flexbox-horizontal-center flexbox-horizontal-wrap">\r\n                    <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                        <div class="text-token instructions-days"\r\n                             ng-class="$ctrl.updatedSigInstruction.days ? \'\' : \'placeholder\'"\r\n                             ap-field-invalid="!$ctrl.isDaysValid()"\r\n                             ng-click="$ctrl.editDays()"\r\n                             id="td-edit-days">\r\n                            <span ng-if="$ctrl.updatedSigInstruction.days.Name && !$ctrl.updatedSigInstruction.days.isNull">\r\n                                {{$ctrl.updatedSigInstruction.days.Name}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.days || $ctrl.updatedSigInstruction.days.isNull || $ctrl.updatedSigInstruction.days.Name === 0" class="rx-instruction-placeholder">\r\n                                {{::\'Day(s)\' | translate}}\r\n                            </span>\r\n                            <span ng-if="$ctrl.updatedSigInstruction.days.Name && !$ctrl.updatedSigInstruction.days.isNull">{{\'day(s)\' | translate}}</span>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                        <div class="text-token instructions-refills"\r\n                             ng-class="$ctrl.updatedSigInstruction.refills ? \'\' : \'placeholder\'"\r\n                             ng-click="$ctrl.editRefills()"\r\n                             id="td-edit-refills">\r\n                            <span ng-if="($ctrl.updatedSigInstruction.refills.Name || $ctrl.updatedSigInstruction.refills.Name === 0) && !$ctrl.updatedSigInstruction.refills.isNull">\r\n                                {{$ctrl.updatedSigInstruction.refills.Name}}\r\n                            </span>\r\n                            <span ng-if="!$ctrl.updatedSigInstruction.refills || $ctrl.updatedSigInstruction.refills.isNull" class="rx-instruction-placeholder">\r\n                                {{::\'Refill(s)\' | translate}}\r\n                            </span>\r\n                            <span ng-if="($ctrl.updatedSigInstruction.refills.Name || $ctrl.updatedSigInstruction.refills.Name === 0) && !$ctrl.updatedSigInstruction.refills.isNull">{{\'refill(s)\' | translate}}</span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n\r\n                <div class="rx-instructions-menu-text flexbox flexbox-horizontal-center flexbox-horizontal-wrap">\r\n                    <div class="input-group tablet-directions-quantity">\r\n                        <input type="number" class="form-control"\r\n                               name="quantity"\r\n                               min="0.00001"\r\n                               max="99999"\r\n                               step="any"\r\n                               ap-field-invalid="!$ctrl.isQuantityValid()"\r\n                               ap-required="false"\r\n                               ng-disabled="$ctrl.sigInstruction.disallowChangingQuantity || !$ctrl.sigInstruction.isManualQuantity"\r\n                               ng-model="$ctrl.updatedSigInstruction.quantity"\r\n                               ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                        </input>\r\n                        <span class="input-group-btn" id="toggle-quantity-btn-group" ng-if="!$ctrl.sigInstruction.disallowChangingQuantity">\r\n                            <button class="btn btn-default"\r\n                                    ng-if="!$ctrl.updatedSigInstruction.isManualQuantity"\r\n                                    ng-click="$ctrl.toggleQuantityType()"\r\n                                    ng-disabled="$ctrl.updatedSigInstruction.disallowAutoQuantity"\r\n                                    id="auto-quantity-btn">\r\n                                {{::\'Auto\' | translate}}\r\n                            </button>\r\n                            <button class="btn btn-default"\r\n                                    ng-if="$ctrl.updatedSigInstruction.isManualQuantity"\r\n                                    ng-click="$ctrl.toggleQuantityType()"\r\n                                    ng-disabled="$ctrl.updatedSigInstruction.disallowAutoQuantity"\r\n                                    id="manual-quantity-btn">\r\n                                {{::\'Manual\' | translate}}\r\n                            </button>\r\n                        </span>\r\n                    </div>\r\n                    <div class="form-group tablet-directions-unit-of-measure">\r\n                        \x3c!--<label for="unitOfMeasure">{{::\'Unit of Measure\' | translate}}</label>--\x3e\r\n                        <ap-select>\r\n                            <select class="form-control" id="unitOfMeasure" ng-class="$ctrl.updatedSigOptions.uom && $ctrl.updatedSigOptions.uom.inactive ? \'inactive\' : \'\'"\r\n                                    ap-required="true"\r\n                                    ng-model="$ctrl.updatedSigOptions.uom"\r\n                                    ng-options="uom.Name for uom in $ctrl.rxOptions.lists.unitsOfMeasure track by uom.Id"\r\n                                    ng-change="$ctrl.onUpdatedSigOptionsChanged()" />\r\n                        </ap-select>\r\n                    </div>                    \r\n                </div>\r\n                <div class="form-group tablet-directions-repeat-sig flexbox flexbox-horizontal-center flexbox-horizontal-wrap"\r\n                        ng-show="$ctrl.shouldDisplayRepeatSig()">\r\n                    <span>{{::\'Repeat SIG\' | translate}}</span>\r\n                    <ap-select>\r\n                            <select class="form-control" id="repeatSig"\r\n                                    ap-required="false"\r\n                                    ng-model="$ctrl.repeatSigSelection"\r\n                                    ng-options="count as count.label for count in $ctrl.repeatSigOptions"\r\n                                    ng-change="$ctrl.onChangeRepeatSig()">\r\n                            </select>\r\n                    </ap-select>\r\n                </div>\r\n            </fieldset>\r\n            <div class="row" ng-show="$ctrl.shouldDisplayStartEndDates()">\r\n                <div class="col-xs-6">\r\n                    <div class="form-group">\r\n                        <label for="startDate">{{::\'Start Date\' | translate}}</label>\r\n                        <input type="date"\r\n                               class="form-control"\r\n                               id="startDate"\r\n                               name="startDate"\r\n                               min="1900-01-01"\r\n                               max="9998-12-31"\r\n                               ap-required="$ctrl.isStartDateRequired()"\r\n                               ng-model="$ctrl.updatedSigInstruction.startDate"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ng-change="$ctrl.onUpdatedSigInstructionChanged();">\r\n                        </input>\r\n                    </div>\r\n                </div>\r\n                <div class="col-xs-6">\r\n                    <div class="form-group">\r\n                        <label for="endDate">{{::\'End Date\' | translate}}</label>\r\n                        <input type="date"\r\n                               class="form-control"\r\n                               id="endDate"\r\n                               name="endDate"\r\n                               min="{{$ctrl.updatedSigInstruction.startDate}}"\r\n                               max="9998-12-31"\r\n                               ap-required="$ctrl.isEndDateRequired()"\r\n                               ng-model="$ctrl.updatedSigInstruction.endDate"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ng-change="$ctrl.onEndDateChanged()">\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="form-group">\r\n                <label for="category">{{::\'Category\' | translate}}</label>\r\n                <ap-select>\r\n                    <select class="form-control" id="category"\r\n                            ng-model="$ctrl.updatedSigOptionsNonFormulary.category"\r\n                            ng-options="category.Name for category in $ctrl.rxOptions.lists.medicationCategories track by category.Id"\r\n                            ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()" />\r\n                </ap-select>\r\n            </div>\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplayPrescriber()">\r\n                <label for="prescriber">{{::\'Prescriber\' | translate}}</label>\r\n                <ap-select>\r\n                        <select id="prescriber" name="prescriber"\r\n                                class="form-control"\r\n                                data-ng-model="$ctrl.updatedSigOptionsNonFormulary.prescriber"\r\n                                data-ng-options="provider.Description for provider in $ctrl.rxOptions.authorizedPrescribers track by provider.Id"\r\n                                ng-change="$ctrl.onChangePrescriber()"\r\n                                ng-disabled="$ctrl.shouldDisablePrescriber()"\r\n                                ap-required="$ctrl.isPrescriberRequired()">\r\n                        </select>\r\n                </ap-select>            \r\n            </div>\r\n\r\n            <div class="form-group" ng-if="$ctrl.shouldDisplayPharmacy()">\r\n                <label for="PharmacyId">{{::\'Pharmacy\' | translate}}</label>\r\n                <ap-find-pharmacy\r\n                        id="PharmacyId"\r\n                        name="PharmacyId"\r\n                        select-disabled="$ctrl.isFixedPharmacy()"\r\n                        ng-model="$ctrl.updatedSigOptions.pharmacy"\r\n                        ng-change="$ctrl.onUpdatedSigOptionsChanged()"\r\n                        data-patient-id="$ctrl.rxParameters.patientId"\r\n                        parent-container-id="$ctrl.parentContainerId"\r\n                        default-list="true">\r\n                </ap-find-pharmacy>\r\n            </div>\r\n\r\n            <ap-Pharmacy-Tile-Drag-Drop ng-if="$ctrl.shouldDisplayPharmacy()"\r\n            data-patient-Id="$ctrl.rxParameters.patientId" \r\n            data-pharmacy-List="$ctrl.pharmacyOrder(pharmacyListData)" \r\n            data-pharmacy-Selected="$ctrl.dragDropPharmacySelected(pharmacy)"\r\n            data-pharmacy-drop-down-Selection="$ctrl.updatedSigOptions.pharmacy.PatientPharmacyUid"></ap-Pharmacy-Tile-Drag-Drop>\r\n            \r\n            \r\n\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplaySupervisingProvider()">\r\n                <label for="supervisingProvider">{{::\'Supervising Provider\' | translate}}</label>\r\n                <input type="text" class="form-control" id="supervisingProvider" ng-model="$ctrl.supervisingProviderText" readonly>\r\n            </div>\r\n        </div>\r\n        <div class="col-xs-6">\r\n            <div class="directions-separator directions-separator-right" ap-vertical-separator="drug-tablet-directions-content"></div>\r\n            <div class="row" id="checkboxesAndButtons">\r\n                <div ng-class="$ctrl.getCheckboxesColumnClass()">\r\n                    <div>\r\n                        <div>\r\n                            <input type="checkbox"\r\n                                   id="bmn"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.bmn"\r\n                                   ng-change="$ctrl.onBrandMedicallyNecessaryChanged()">\r\n                            <label class="lg-touch" for="bmn">{{::\'Brand Medically Necessary\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                    <div>\r\n                        <div>\r\n                            <input type="checkbox"\r\n                                   id="daw"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.daw"\r\n                                   ng-change="$ctrl.onDispenseAsWrittenChanged()">\r\n                            <label class="lg-touch" for="daw">{{::\'Dispense as Written\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                    <div>\r\n                        <div>\r\n                            <input type="checkbox"\r\n                                   id="chronicMed"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.isChronicMed"\r\n                                   ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()">\r\n                            <label class="lg-touch" for="chronicMed">{{::\'Chronic Medication\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                    <div>\r\n                        <div>\r\n                            <input type="checkbox"\r\n                                   id="HighRiskMedication"\r\n                                   ng-model ="$ctrl.updatedSigOptionsNonFormulary.isHighRiskMed"\r\n                                   ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()">\r\n                            <label class="lg-touch" for="HighRiskMedication">{{::\'High Risk Medication\' | translate}}</label> \r\n                        </div>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplayIncludeMonograph()">\r\n                        <div>\r\n                            <input type="checkbox"\r\n                                   id="includeMonograph"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.includeMonograph"\r\n                                   ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()">\r\n                            <label class="lg-touch" for="includeMonograph">{{::\'Include Monograph\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplayMode()">\r\n                        <div>\r\n                            <input type="checkbox"\r\n                                   id="administered"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.isAdministered"\r\n                                   ng-change="$ctrl.onIsAdministeredChanged()">\r\n                            <label class="lg-touch" for="administered">{{::\'Administered\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplayMode()">\r\n                        <div>\r\n                            <input type="checkbox"\r\n                                   id="sampleGiven"\r\n                                   ng-model="$ctrl.updatedSigOptionsNonFormulary.isSampleGiven"\r\n                                   ng-change="$ctrl.onSampleGivenChanged()">\r\n                            <label class="lg-touch" for="sampleGiven">{{::\'Sample Given\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <div ng-class="$ctrl.getButtonsColumnClass()">\r\n                    <div class="directions-separator directions-separator-right" ap-vertical-separator="checkboxesAndButtons"></div>\r\n                    <div ng-show="$ctrl.shouldDisplayEpaButton()">\r\n                        <img class="tablet-directions-epa-button"\r\n                             id="toggle-epa-btn"\r\n                             ng-class="$ctrl.updatedSigOptionsNonFormulary.sendPriorAuth ? \'ap-ePA-selected\' : \'ap-ePA-unselected\'"\r\n                             ng-click="$ctrl.toggleEpaButton()"/>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplaySpecialtyButton() && $ctrl.updatedSigOptionsNonFormulary.isSpecialtyEnabled">\r\n                        <img class="tablet-directions-specialty-button"\r\n                             id="toggle-spo-btn"\r\n                             ng-class="$ctrl.updatedSigOptionsNonFormulary.sendIsSpecialty ? \'ap-spo-selected\' : \'ap-spo-unselected\'"\r\n                             ng-click="$ctrl.toggleSpoButton()"/>\r\n                    </div>\r\n                    <div ng-show="$ctrl.shouldDisplayConsent()">\r\n                        <img class="tablet-directions-rx-consent-button"\r\n                             ng-click="$ctrl.onOpenDrugConsent()" \r\n                             ng-class="$ctrl.updatedSigOptionsNonFormulary.MedicationConsent ? \'ap-rx-consent-green\' : \'ap-rx-consent-unselected\'"\r\n                             id="td-drug-consent">\r\n                        </img>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplayDxProblems()">\r\n                <label for="dxProblems">{{::\'Diagnosis\' | translate}}</label>\r\n                <sigwriter-dx-problems\r\n                    id="dxProblems"\r\n                    data-patient-id="$ctrl.rxParameters.patientId"\r\n                    data-medication-sig-id="$ctrl.rxParameters.medicationSigId"\r\n                    data-order-by-display-order="$ctrl.orderByDisplayOrder"\r\n                    ng-model="$ctrl.updatedSigOptionsNonFormulary.problems"\r\n                    ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()">\r\n                </sigwriter-dx-problems>\r\n            </div>\r\n            \r\n            <div class="form-group" ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered || $ctrl.sigOptionsNonFormulary.isSampleGiven">\r\n                <label for="pharmacyInstructions">\r\n                    <a class="clickable underline" ng-click="$ctrl.onClickPharmacyInstructions()" id="td-pharmacy-instructions-link">\r\n                        {{::\'Pharmacy Instructions\' | translate}}\r\n                    </a>\r\n                    <span class="char-count">\r\n                        &nbsp;({{$ctrl.getRemainingPharmacyInstructionsCharacters()}} {{::\'of\' | translate}} {{::$ctrl.maxPharmacyInstructionsCharacters}})\r\n                    </span>\r\n                </label>\r\n                <input type="text" \r\n                       ng-model="$ctrl.updatedSigOptionsNonFormulary.pharmacyInstructions"\r\n                       ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()"\r\n                       maxlength="{{$ctrl.maxPharmacyInstructionsCharacters}}"\r\n                       class="form-control" \r\n                       id="pharmacyInstructions"\r\n                       ap-field-invalid="!$ctrl.isPharmacyInstructionsValid()">\r\n            </div>\r\n\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplayCptCode()">\r\n                <label for="cpt">CPT<i class="ap-important-sm" ng-show="$ctrl.cptList && $ctrl.cptList.length > 0"></i>\r\n                </label>\r\n                <ap-select>\r\n                        <select class="form-control" id="cpt"\r\n                                ng-disabled="!$ctrl.cptList || $ctrl.cptList < 1"\r\n                                ng-model="$ctrl.updatedSigOptionsNonFormulary.procedure"\r\n                                ng-options="cpt as \'(\' + cpt.Code + \')\' + cpt.ShortDescription for cpt in $ctrl.cptList"\r\n                                ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()" />\r\n                </ap-select>\r\n            </div>\r\n            <div class="form-group" ng-show="$ctrl.shouldDisplayAuthorizationCode()">\r\n                <label for="authorization">{{::\'Authorization\' | translate}}</label>\r\n                <input type="text" class="form-control" id="authorization"\r\n                    ng-model="$ctrl.updatedSigOptionsNonFormulary.authorCode"\r\n                    ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()"\r\n                    ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.AuthorCode"\r\n                    maxlength="{{$ctrl.rxOptions.metadata.sig.Fields.AuthorCode.MaxLength}}"/>\r\n            </div>\r\n            <div class="form-group">\r\n                <label for="internalNote">\r\n                    <a class="clickable underline" ng-click="$ctrl.onClickInternalNote()" id="td-internal-note-link">\r\n                        {{\'Internal Note\' | translate}}\r\n                    </a>\r\n                    <span class="char-count">\r\n                        &nbsp;({{$ctrl.getRemainingInternalNoteCharacters()}} {{::\'of\' | translate}} {{::$ctrl.maxInternalNoteCharacters}})\r\n                    </span>\r\n                </label>\r\n                <input type="text"\r\n                        id="internalNote"\r\n                        class="form-control"\r\n                        ng-model="$ctrl.updatedSigOptionsNonFormulary.internalNote"\r\n                        ng-change="$ctrl.onUpdatedSigOptionsNonFormularyChanged()"\r\n                        maxlength="{{$ctrl.maxInternalNoteCharacters}}">\r\n            </div>\r\n        </div>\r\n    </div>\r\n</form>'),$templateCache.put("/sigwriter/component-views/tabletDrugScreening.html",'<div id="drug-tablet-screening-sidebar" ng-class="$ctrl.getSidebarClass()"></div>\r\n<div id="drug-tablet-screening-display">\r\n    <div id="drug-tablet-screening-header">\r\n        <div>\r\n            <h4><b>{{::\'Drug Screening\' | translate}}</b></h4>\r\n        </div>\r\n        <div class="sigwriter-tablet-show-details-container" ng-if="!$ctrl.loading && !$ctrl.nddScreeningError" ng-click="$ctrl.showDetails()">\r\n            <i class="clickable ap-expand-more"></i>\r\n        </div>\r\n    </div>\r\n    <div class="sigwriter-tablet-drug-screening-content">\r\n        <ndd-condensed-drug-screening\r\n            error="$ctrl.nddScreeningError"\r\n            loading="$ctrl.loading"\r\n            screening="$ctrl.nddScreening"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/tabletFormularyAlternatives.html",'<div id="drug-tablet-formulary-sidebar" ng-class="$ctrl.isAnimating(\'drug-tablet-formulary-sidebar\') ? \'\' : $ctrl.downloadStatusClass()"></div>\r\n<div id="drug-tablet-formulary-display">\r\n\r\n    <div id="drug-tablet-formulary-header" class="rxworkflow-formulary-header">\r\n        <div>\r\n            <h4><b>{{::\'Formulary\' | translate}}</b></h4>\r\n        </div>\r\n        <div ng-if="$ctrl.eRxEligibilities && $ctrl.eRxEligibilities.length > 0">\r\n            <div class="sigwriter-tablet-show-details-container rxworkflow-formulary-show-details-container" ng-click="$ctrl.openFormularyDetailsModal(null)" ng-show="$ctrl.eRxEligibility">\r\n                <i class="clickable ap-expand-more"></i>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="sigwriter-tablet-alternatives-formulary-content">\r\n        <div id="drug-tablet-formulary-banner">\r\n            <div class="row" ng-if="$ctrl.eRxEligibility">\r\n                <div class="col-xs-12" >\r\n                    <label for="DownloadedDate"\r\n                        ng-click="$ctrl.openRxBenefitDetailsModal()"\r\n                        ng-class="{\'rx-formulary-download-date-expired\': ($ctrl.eRxEligibility && $ctrl.eRxEligibility.IsExpired) }"><a class="clickable underline">Rx Benefits: {{$ctrl.formatEligibilityDate() }}</a></label>\r\n                </div>\r\n            </div>\r\n            <div class="form-group row  alternatives-formulary-change" ng-if="$ctrl.eRxEligibilities && $ctrl.eRxEligibilities.length > 0">\r\n                <div class="col-xs-12">\r\n                    <ap-select>\r\n                        <select class="form-control"\r\n                                ng-model="$ctrl.eRxEligibility"\r\n                                ng-options="erxe as $ctrl.formatEligibilityName(erxe) for erxe in $ctrl.eRxEligibilities track by erxe.PatienteRxElgibilityUid"\r\n                                ng-change="$ctrl.onERxEligibilityChanged()">\r\n                        </select>\r\n                    </ap-select>\r\n                </div>\r\n            </div>\r\n            <div ng-if="!$ctrl.eRxEligibilities.length && !$ctrl.loadingERxEligibilities">\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <span translate>\r\n                            There are no active coverages downloaded for this patient.\r\n                        </span>\r\n                    </div>\r\n                </div>\r\n                <br>\r\n            </div>\r\n        </div>\r\n        <div id="drug-tablet-formulary-data" ng-if="$ctrl.eRxEligibility">\r\n            <sigwriter-formulary-display\r\n                details="$ctrl.details"\r\n                error="$ctrl.$scope.httpError"\r\n                is-info-available="$ctrl.isInfoAvailable"\r\n                loading="$ctrl.loading"\r\n                on-drug-selected="$ctrl.changeMedication(drug, pharmacy)"\r\n            />\r\n        </div>\r\n    </div>\r\n\r\n\r\n</div>'),$templateCache.put("/sigwriter/component-views/tabletPdr.html",'<sigwriter-pdr\r\n    [drug]="$ctrl.drug"\r\n    [patient-id]="$ctrl.patientId"\r\n    [rx-id]="$ctrl.rxId"\r\n    [sig-type]="$ctrl.sigType"\r\n>\r\n</sigwriter-pdr>'),$templateCache.put("/sigwriter/component-views/tabletSigDetails.html",'<div id="tablet-sig-details">\r\n    <table>\r\n        <thead>\r\n            <tr>\r\n                <th translate>Action</th>\r\n                <th colspan="2">\r\n                    <span translate ng-if="!$ctrl.shouldDisplayDosingCalc()">Dosage</span>\r\n                    <a translate id="open-dosing-calc" class="clickable"\r\n                       ng-if="$ctrl.shouldDisplayDosingCalc()"\r\n                       ng-click="$ctrl.onClickDosingCalculator()">\r\n                       \r\n                       Dosage\r\n                    </a>\r\n                </th>\r\n                <th translate>Route</th>\r\n                <th translate ap-field-invalid="!$ctrl.isFrequencyValid()">Frequency</th>\r\n                <th translate ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <div>\r\n                        <input type="checkbox"\r\n                               id="prn"\r\n                               ng-attr-autofocus="{{$ctrl.initialField === \'prn\' || undefined}}"\r\n                               ng-model="$ctrl.updatedSigInstruction.isPrn"\r\n                               ng-change="$ctrl.onIsPrnChanged()">\r\n                        <label for="prn">{{\'PRN\' | translate}}</label>\r\n                    </div>\r\n                </th>\r\n                <th translate ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">Days</th>\r\n                <th translate ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">Refill</th>\r\n            </tr>\r\n        </thead>\r\n        <tbody>\r\n            <tr class="input-row">\r\n                <td>\r\n                    <input type="text" disabled\r\n                           ng-value="$ctrl.updatedSigInstruction.action | medCommonLanguage:true">\r\n                </td>\r\n                <td colspan="2" ng-if="$ctrl.isVariableDosing()">\r\n                    <div>\r\n                        <input type="checkbox"\r\n                                id="variable-dosing"\r\n                                ng-true-value="false" ng-false-value="true"\r\n                                ng-model="$ctrl.updatedSigInstruction.variableDosing.isDisabled"\r\n                                ng-change="$ctrl.onIsVariableDosingChanged()">\r\n                        <label for="variable-dosing">{{\'Variable Dosing\' | translate}}</label>\r\n                    </div>\r\n                </td>\r\n                <td ng-if="!$ctrl.isVariableDosing()">\r\n                    <input type="text"\r\n                           id="tsd-manual-dosage"\r\n                           ng-attr-autofocus="{{$ctrl.initialField === \'dosage\' || undefined}}"\r\n                           ng-model="$ctrl.manualDosage"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onDosageTyped()">\r\n                </td>\r\n                <td ng-if="!$ctrl.isVariableDosing()">\r\n                    <input type="text" disabled\r\n                           ng-model="$ctrl.updatedSigInstruction.unit.Name"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                </td>\r\n                <td>\r\n                    <input type="text" disabled\r\n                           ng-value="$ctrl.updatedSigInstruction.route | medCommonLanguage:true">\r\n                </td>\r\n                <td>\r\n                    <input type="text" disabled\r\n                           ng-value="$ctrl.updatedSigInstruction.frequency | medCommonLanguage:true:undefined:$ctrl.displayAbbrevFirstFrequency">\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <input type="text" disabled\r\n                           ng-model="$ctrl.updatedSigInstruction.prnReason.Name"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <input type="number"\r\n                           id="tsd-manual-days"\r\n                           ng-attr-autofocus="{{$ctrl.initialField === \'days\' || undefined}}"\r\n                           class="validated-control"\r\n                           min="0"\r\n                           max="999"\r\n                           ap-field-invalid="!$ctrl.isDaysValid()"\r\n                           ap-required="false"\r\n                           ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                           ng-model="$ctrl.manualDays"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onDaysTyped()">\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <input type="number"\r\n                           id="tsd-manual-refills"\r\n                           ng-attr-autofocus="{{$ctrl.initialField === \'refills\' || undefined}}"\r\n                           min="0"\r\n                           max="99"\r\n                           ap-required="false"\r\n                           ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                           ng-model="$ctrl.manualRefills"\r\n                           ng-model-options="$ctrl.inputModelOptions"\r\n                           ng-change="$ctrl.onRefillsTyped()">\r\n                </td>\r\n            </tr>\r\n            <tr>\r\n                <td>\r\n                    <select size="2"\r\n                            id="tsd-action-options"\r\n                            ng-attr-autofocus="{{$ctrl.initialField === \'action\' || undefined}}"\r\n                            ng-model="$ctrl.updatedSigInstruction.action"\r\n                            ng-options="option as (option | medCommonLanguage:true) for option in $ctrl.actionOptions"\r\n                            ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                    </select>\r\n                </td>\r\n                <td colspan="2" ng-if="$ctrl.isVariableDosing()">\r\n                    <textarea readonly\r\n                              class="form-control resize-none"\r\n                              cols="1"\r\n                              id="variable-dosing-info"\r\n                              ng-model="$ctrl.updatedSigInstruction.variableDosing.summary">\r\n                    </textarea>\r\n                </td>\r\n                <td ng-if="!$ctrl.isVariableDosing()">\r\n                    <select size="2"\r\n                            id="tsd-dosage-options"\r\n                            ng-model="$ctrl.updatedSigInstruction.dosage"\r\n                            ng-options="option as option.Name for option in $ctrl.dosageOptions"\r\n                            ng-change="$ctrl.onDosageSelected()">\r\n                    </select>\r\n                </td>\r\n                <td ng-if="!$ctrl.isVariableDosing()">\r\n                    <select size="2"\r\n                            id="tsd-unit-options"\r\n                            ng-attr-autofocus="{{$ctrl.initialField === \'unit\' || undefined}}"\r\n                            ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                            ng-model="$ctrl.updatedSigInstruction.unit"\r\n                            ng-options="option as option.Name for option in $ctrl.rxOptions.lists.medicationsUnits"\r\n                            ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                    </select>\r\n                </td>\r\n                <td>\r\n                    <select size="2"\r\n                            id="tsd-route-options"\r\n                            ng-attr-autofocus="{{$ctrl.initialField === \'route\' || undefined}}"\r\n                            ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                            ng-model="$ctrl.updatedSigInstruction.route"\r\n                            ng-options="option as (option | medCommonLanguage:true) for option in $ctrl.routeOptions"\r\n                            ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                    </select>\r\n                </td>\r\n                <td>\r\n                    <select size="2"\r\n                            id="tsd-frequency-options"\r\n                            ng-attr-autofocus="{{$ctrl.initialField === \'frequency\' || undefined}}"\r\n                            ng-model="$ctrl.updatedSigInstruction.frequency"\r\n                            ng-options="option as (option | medCommonLanguage:true:undefined:$ctrl.displayAbbrevFirstFrequency) for option in $ctrl.frequencyOptions"\r\n                            ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                    </select>\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <select size="2"\r\n                            id="tsd-prn-reason-options"\r\n                            ng-disabled="!$ctrl.updatedSigInstruction.isPrn"\r\n                            ng-model="$ctrl.updatedSigInstruction.prnReason"\r\n                            ng-options="option as option.Name for option in $ctrl.prnReasons"\r\n                            ng-change="$ctrl.onUpdatedSigInstructionChanged()">\r\n                    </select>\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <select size="2"\r\n                            id="tsd-day-options"\r\n                            ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                            ng-model="$ctrl.updatedSigInstruction.days"\r\n                            ng-options="option as option.Name for option in $ctrl.dayOptions"\r\n                            ng-change="$ctrl.onDaysSelected()">\r\n                    </select>\r\n                </td>\r\n                <td ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n                    <select size="2"\r\n                            id="tsd-refill-options"\r\n                            ng-disabled="$ctrl.rxParameters.sigType === \'ChangeRx\'"\r\n                            ng-model="$ctrl.updatedSigInstruction.refills"\r\n                            ng-options="option as option.Name for option in $ctrl.refillOptions"\r\n                            ng-change="$ctrl.onRefillsSelected()">\r\n                    </select>\r\n                </td>\r\n            </tr>\r\n        </tbody>\r\n    </table>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardDrugDescription.html",'<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="detail-group">\r\n            <div class="form-group">\r\n                <p class="form-control-static">\r\n                    <strong>{{$ctrl.rxParameters.drug.Description}}</strong>\r\n                </p>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardDrugSearch.html",'<sigwriter-drug-search\r\n    [patient-id]="$ctrl.patientId"\r\n    [use-previous-search-text]="$ctrl.usePreviousSearchText"\r\n    (drug-search-result-selected)="$ctrl.selectDrugSearchResult($event.drugSearchResult, $event.switchToGeneric, $event.dosingSuggestion, $event.useEnhancedDrugSearch)"\r\n    [kdb-parameters]="$ctrl.kdbParameters">\r\n</sigwriter-drug-search>\r\n'),$templateCache.put("/sigwriter/component-views/wizardFormularyAlternativesContent.html",'<sigwriter-wizard-formulary-alternatives-original\r\n    ng-if="!$ctrl.useSurescripts"\r\n    is-active-step="$ctrl.isActiveStep"\r\n    rel-visit-medication-id="$ctrl.relVisitMedicationId"\r\n    rx-parameters="$ctrl.rxParameters"\r\n    sig-instruction="$ctrl.sigInstruction"\r\n    sig-options="$ctrl.sigOptions"\r\n    sig-options-non-formulary="$ctrl.sigOptionsNonFormulary"\r\n    skip-formulary-alternatives="$ctrl.skipFormularyAlternatives"\r\n    on-drug-selected="$ctrl.onDrugSelected({drug: drug})"\r\n    update-is-available="$ctrl.updateIsAvailable({isAvailable: isAvailable})"\r\n    update-rel-visit-medication-id="$ctrl.updateRelVisitMedicationId({relVisitMedicationId: relVisitMedicationId})"\r\n    update-sig-options="$ctrl.updateSigOptions({sigOptions: sigOptions})"\r\n/>\r\n<sigwriter-wizard-formulary-alternatives-surescripts\r\n    ng-if="$ctrl.useSurescripts"\r\n    is-active-step="$ctrl.isActiveStep"\r\n    rel-visit-medication-id="$ctrl.relVisitMedicationId"\r\n    rx-parameters="$ctrl.rxParameters"\r\n    sig-formulary="$ctrl.sigFormulary"\r\n    sig-instruction="$ctrl.sigInstruction"\r\n    sig-options="$ctrl.sigOptions"\r\n    sig-options-non-formulary="$ctrl.sigOptionsNonFormulary"\r\n    skip-formulary-alternatives="$ctrl.skipFormularyAlternatives"\r\n    on-drug-selected="$ctrl.onDrugSelected({drug: drug, pharmacy: pharmacy})"\r\n    update-is-available="$ctrl.updateIsAvailable({isAvailable: isAvailable})"\r\n    update-rel-visit-medication-id="$ctrl.updateRelVisitMedicationId({relVisitMedicationId: relVisitMedicationId})"\r\n    update-sig-formulary="$ctrl.updateSigFormulary({sigFormulary: sigFormulary})"\r\n    update-sig-options="$ctrl.updateSigOptions({sigOptions: sigOptions})"\r\n/>'),$templateCache.put("/sigwriter/component-views/wizardFormularyAlternativesContentOriginal.html",'<div id="drug-formulary-display" class="text-center">\r\n\t<div id="drug-screening-loading" ng-show="$ctrl.loading">\r\n\t\t<div class="row">\r\n\t\t\t<div class="col-xs-12 text-center">\r\n\t\t\t\tLoading Formulary Alternatives\r\n\t\t\t\t<br/>\r\n\t\t\t\t<ap-spinner data-size="3"></ap-spinner>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\t\r\n\t<div ng-show="!$ctrl.loading && !$ctrl.$scope.httpError">\r\n\t\t<ul class="list-group" ng-show="$ctrl.drugs.length > 0">\r\n\t\t\t<li class="list-group-item" ng-repeat="drug in $ctrl.drugs">\r\n\t\t\t\t<div class="flexbox flexbox-horizontal-center reverse">\r\n                    <div class="text-center-vert flexbox-pull-right text-center center" style="flex: 0 1 auto;">\r\n\t\t\t\t\t\t<button class="btn btn-warning" hm-click="$ctrl.formularySelected(drug)" translate>Use</button>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t\t<div class="text-center-vert overflow-ellipsis flexbox-pull-left" style="flex: 0 10 auto;">\r\n\t\t\t\t\t\t<div class="heading-title overflow-ellipsis">{{::drug.Description}}</div>\r\n\t\t\t\t\t\t<div class="heading-subtitle overflow-ellipsis">Status - {{::drug.FormularyStatusName}}</div>\r\n\t\t\t\t\t\t<div class="heading-subtitle overflow-ellipsis">Retail Copay - {{::drug.CopayRetail}}</div>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</div>\r\n\t\t\t</li>\r\n\t\t</ul>\r\n\t\t<div ng-show="$ctrl.drugs.length === 0">\r\n\t\t\t<div class="col-xs-12">\r\n\t\t\t\t<uib-alert type="success" translate>\r\n\t\t\t\t\tNo formulary alternatives were found.\r\n\t\t\t\t</uib-alert>\r\n\t\t\t</div>\r\n\t\t</div>\r\n\t</div>\r\n\t\r\n\t<div ng-show="$ctrl.$scope.httpError">\r\n\t\t<div class="col-xs-12">\r\n\t\t\t<uib-alert type="danger" translate>\r\n\t\t\t\tThere was a communication issue with the server.  Please contact support.\r\n\t\t\t</uib-alert>\r\n\t\t</div>\r\n\t</div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardFormularyAlternativesSurescripts.html",'<div id="drug-surescripts-formulary-display">\r\n    <div class="row" ng-if="$ctrl.eRxEligibilities && $ctrl.eRxEligibilities.length > 1">\r\n        <div class="col-xs-12">\r\n            <div class="form-group row">\r\n                <div class="col-xs-3 col-md-2">\r\n                    <label class="control-label text-left">{{::\'eRx Eligibility\' | translate}}</label>\r\n                </div>\r\n\r\n                <div class="col-xs-9 col-md-10">\r\n                    <ap-select>\r\n                        <select class="form-control"\r\n                                ng-model="$ctrl.eRxEligibility"\r\n                                ng-options="erxe as erxe.Name for erxe in $ctrl.eRxEligibilities track by erxe.PatienteRxElgibilityUid"\r\n                                ng-change="$ctrl.onERxEligibilityChanged()">\r\n                        </select>\r\n                    </ap-select>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div ng-hide="$ctrl.eRxEligibilities.length || $ctrl.loadingERxEligibilities">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <span translate>\r\n                    There are no active coverages downloaded for this patient.\r\n                </span>\r\n            </div>\r\n        </div>\r\n        <br>\r\n    </div>\r\n    <sigwriter-formulary-details\r\n        details="$ctrl.details"\r\n        error="$ctrl.$scope.httpError"\r\n        hide-transmit-status="$ctrl.hideTransmitStatus"\r\n        is-info-available="$ctrl.isInfoAvailable"\r\n        loading="$ctrl.loading"\r\n        on-drug-selected="$ctrl.changeMedication(drug, pharmacy)"\r\n    />\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardPdr.html",'<div id="drug-documentation">\r\n    <div id="drug-documentation-loading" ng-show="$ctrl.loadingDrugDocumentation">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Loading Drug Documentation\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id="drug-documentation-content" ng-show="!$ctrl.loadingDrugDocumentation && !$ctrl.$scope.httpError">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <iframe ng-src="{{$ctrl.drugDocumentation.html}}"\r\n                        width="310px"\r\n                        height="180px"\r\n                        class="pdr-border">\r\n                </iframe>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row" ng-if="!!$ctrl.$scope.httpError">\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.unhandled">\r\n            <uib-alert type="danger">\r\n                {{::"An error has occurred and the documentation could not be loaded." | translate}}\r\n            </uib-alert>\r\n        </div>\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.is403">\r\n            <uib-alert type="danger">\r\n                {{::\'You do not have access to the documentation.\' | translate}}\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/sigwriter/component-views/wizardReview.html",'<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Medication Type\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                <span ng-if="$ctrl.currentRx.optionsNonFormulary.isAdministered" translate>Administered</span>\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.isAdministered && $ctrl.currentRx.optionsNonFormulary.isSampleGiven" translate>Sample Given</span>\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.isAdministered && !$ctrl.currentRx.optionsNonFormulary.isSampleGiven" translate>Standard</span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr />\r\n\r\n<div class="row" ng-repeat="instruction in $ctrl.currentRx.instructions">\r\n    <div class="row" ng-if="$index !== 0">\r\n        <hr/>\r\n    </div>\r\n    <div class="col-xs-12">\r\n        <div class="detail-group">\r\n            <div class="form-group">\r\n                <p class="form-control-static">\r\n                    {{instruction.sigString}}\r\n                </p>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="col-xs-6 col-md-3">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Duration\' | translate}}</label>\r\n\r\n            <p ng-if="instruction.days.Name" class="form-control-static">\r\n                {{instruction.days.Name}} {{::\'Day(s)\' | translate}}\r\n            </p>\r\n            <p ng-if="!instruction.days.Name">\r\n                {{::\'N/A\' | translate}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-6 col-md-3">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Refills\' | translate}}</label>\r\n\r\n            <p ng-if="instruction.refills.Name" class="form-control-static">\r\n                {{instruction.refills.Name}} {{::\'Refill(s)\' | translate}}\r\n            </p>\r\n            <p ng-if="!instruction.refills.Name">\r\n                {{::\'N/A\' | translate}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-6 col-md-3">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Quantity\' | translate}}\r\n                (<span ng-if="!instruction.isManualQuantity">{{::\'Auto\' | translate}}</span><span\r\n                        ng-if="instruction.isManualQuantity">{{::\'Manual\' | translate}}</span>)\r\n            </label>\r\n\r\n            <p class="form-control-static">\r\n                {{instruction.quantity}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-6 col-md-3">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Start + End\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                <ap-date-formatter date="{{instruction.startDate}}" format="long-date"></ap-date-formatter>\r\n                -\r\n                <ap-date-formatter date="{{instruction.endDate}}" format="long-date"></ap-date-formatter>\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr/>\r\n\r\n<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Unit of Measure\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.options.uom.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.options.uom">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Diagnoses & Problems\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                <span ng-repeat="problem in $ctrl.currentRx.optionsNonFormulary.problems">\r\n                    {{problem.Name}}\r\n                    <br/>\r\n                </span>\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.problems.length">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Category\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.category.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.category">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Pharmacy Instructions\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.pharmacyInstructions}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.pharmacyInstructions">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Internal Note\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.internalNote}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.internalNote">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Prescriber\' | translate}}</label>\r\n\r\n            <p class="form-control-static">\r\n                {{$ctrl.user.fullName}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered || $ctrl.currentRx.optionsNonFormulary.isSampleGiven"/>\r\n<div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered || $ctrl.currentRx.optionsNonFormulary.isSampleGiven" class="row">\r\n    <div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered" class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Site\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.medicationSite.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.medicationSite">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Lot #\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.lotNumber}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.lotNumber">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Manufacturer\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.manufacturer.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.manufacturer">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered" class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Funding Source\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.fundingSource.Name}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.fundingSource">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Expiration Date\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                <ap-date-formatter date="{{$ctrl.currentRx.optionsNonFormulary.expirationDate}}" format="long-date"></ap-date-formatter>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered" class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Initials\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                {{$ctrl.currentRx.optionsNonFormulary.initials}}\r\n\r\n                <span ng-if="!$ctrl.currentRx.optionsNonFormulary.initials">\r\n                    {{::\'N/A\' | translate}}\r\n                </span>\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div ng-show="$ctrl.currentRx.optionsNonFormulary.isAdministered" class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Administered Date\' | translate}}</label>\r\n            <p class="form-control-static">\r\n                <ap-date-formatter date="{{$ctrl.currentRx.optionsNonFormulary.administeredDateTime}}" format="long-date"></ap-date-formatter>\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr ng-show="$ctrl.currentRx.optionsNonFormulary.daw || $ctrl.currentRx.optionsNonFormulary.isChronicMed || $ctrl.currentRx.optionsNonFormulary.includeMonograph" />\r\n\r\n<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.daw">\r\n                {{::\'Dispense as Written\' | translate}}\r\n            </div>\r\n        </div>\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.isChronicMed">\r\n                {{::\'Chronic Medication\' | translate}}\r\n            </div>\r\n        </div>\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.isHighRiskMed">\r\n                {{::\'High Risk Medication\' | translate}}\r\n            </div>\r\n        </div>\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.includeMonograph">\r\n                {{::\'Include Monograph\' | translate}}\r\n            </div>\r\n        </div>\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.sendPriorAuth">\r\n                {{::\'Electronic Prior Authorization\' | translate}}\r\n            </div>\r\n        </div>\r\n        <div class="flexbox flexbox-horizontal-center">\r\n            <div ng-show="$ctrl.currentRx.optionsNonFormulary.sendIsSpecialty">\r\n                {{::\'Specialty Patient Enrollment\' | translate}}\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<hr/>\r\n\r\n<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <label class="control-label">{{::\'Pharmacy\' | translate}}</label>\r\n\r\n            <p ng-if="$ctrl.currentRx.options.pharmacy" class="form-control-static">\r\n                {{$ctrl.currentRx.options.pharmacy.Name}}\r\n\r\n                <br/>\r\n\r\n                ph. <a dial-href="$ctrl.currentRx.options.pharmacy.Phone.PhoneNumber">{{$ctrl.currentRx.options.pharmacy.Phone.PhoneNumber}}</a>\r\n\r\n                <ap-address [address]="$ctrl.currentRx.options.pharmacy.Address"></ap-address>\r\n            </p>\r\n            <p ng-if="!$ctrl.currentRx.options.pharmacy">\r\n                {{::\'N/A\' | translate}}\r\n            </p>\r\n        </div>\r\n    </div>\r\n</div>\r\n<hr/>\r\n\r\n<div class="row">\r\n    <div class="col-xs-12">\r\n        <div class="form-group">\r\n            <div class="flexbox flexbox-horizontal-center">\r\n                <div>\r\n                    {{::\'Save as Default SIG?\' | translate}}\r\n                </div>\r\n                <div class="flexbox-pull-right">\r\n                    <input type="checkbox" name="create-default-sig" id="create-default-sig"\r\n                            ng-model="$ctrl.options.createDefaultSig"\r\n                            ng-change="$ctrl.onOptionsChanged()"\r\n                            ap-checkbox-hidden-label="Save as Default SIG">\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n<form name="$ctrl.epcsForm" novalidate>\r\n    <sigwriter-epcs-signature\r\n        ng-if="$ctrl.needsEpcs()"\r\n        epcs-model="$ctrl.user.epcsModel"\r\n    />\r\n</form>'),$templateCache.put("/sigwriter/component-views/wizardScreeningContent.html",'<div id="drug-screening-alert">\r\n    <div id="drug-screening-loading" ng-show="$ctrl.loadingDrugScreening">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                Performing Drug Screening\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n        \r\n    <div ng-if="$ctrl.v18Screening">\r\n        <ndd-detailed-drug-screening screening="$ctrl.screening"></ndd-detailed-drug-screening>\r\n    </div>\r\n\r\n    <div ng-if="!$ctrl.v18Screening">\r\n        <div id="drug-screening-alerts" ng-show="$ctrl.drugScreeningMode === \'display\' || $ctrl.drugScreeningMode === \'redirecting\'">\r\n            <div class="row" ng-show="$ctrl.drugScreeningMode === \'display\'">\r\n                <div class="col-xs-12" translate>\r\n                    <div class="drug-screening-group" id="drug-screening-user-alert" ng-if="$ctrl.screening.ProspectiveDrugIsUserDefined && $ctrl.screening.NewDrugWarning.IsUserDefined">\r\n                        <span class="drug-screening-alert-header">{{::\'Drug screening cannot be performed when adding the user defined medication\' | translate}}</span>\r\n                        <div>\r\n                            {{::$ctrl.screening.NewDrugWarning.DrugName}}\r\n                        </div>\r\n                    </div>\r\n        \r\n                    <div ng-if="!$ctrl.screening.ProspectiveDrugIsUserDefined">\r\n                        <div class="drug-screening-group" id="drug-screening-interaction-alert" ng-if="$ctrl.screening.Interactions">\r\n                            <span class="drug-screening-alert-header">{{::\'Interaction Alert\' | translate}}</span>\r\n                            <div ng-repeat="msg in $ctrl.screening.Interactions.Messages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-repeat="msg in $ctrl.screening.Interactions.ScreenMessages track by $index">\r\n                                {{msg.ScreenMessage}}\r\n                                <div>\r\n                                    <strong>{{\'Severity\' | translate}}:</strong>&nbsp;{{msg.Severity}}\r\n                                </div>\r\n                                <div>\r\n                                    <strong>{{\'Effect\' | translate}}:</strong>&nbsp;{{msg.ClinicalEffectCode1}}\r\n                                </div>\r\n                                <div ng-show="msg.ClinicalEffectCode2">\r\n                                    <strong>{{\'Effect\' | translate}}:</strong>&nbsp;{{msg.ClinicalEffectCode2}}\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n        \r\n                        <div class="drug-screening-group" id="drug-screening-therapy-alert" ng-if="$ctrl.screening.DuplicateTherapy">\r\n                            <span class="drug-screening-alert-header">{{::\'Duplicate Therapy Alert\' | translate}}</span>\r\n                            <div ng-repeat="msg in $ctrl.screening.DuplicateTherapy.Messages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-repeat="msg in $ctrl.screening.DuplicateTherapy.ScreenMessages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                        </div>\r\n                        <div class="drug-screening-group" id="drug-screening-ingredients-alert" ng-if="$ctrl.screening.DuplicateIngredients && $ctrl.screening.DuplicateIngredients.length > 0">\r\n                            <span class="drug-screening-alert-header">{{::\'Duplicate Ingredient Alert\' | translate}}</span>\r\n                            <div ng-repeat="msg in $ctrl.screening.DuplicateIngredients.Messages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-repeat="msg in $ctrl.screening.DuplicateIngredients.ScreenMessages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                        </div>\r\n        \r\n                        <div class="drug-screening-group" id="drug-screening-allergy-alert" ng-if="$ctrl.screening.Allergies">\r\n                            <span class="drug-screening-alert-header">{{::\'Allergy Alert\' | translate}}</span>\r\n                            <div ng-repeat="msg in $ctrl.screening.Allergies.Messages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-repeat="msg in $ctrl.screening.Allergies.ScreenMessages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-if="$ctrl.screening.Allergies.UserDefinedDrugAllergies.length">\r\n                                <strong>{{::\'Custom Drug Allergy Present\' | translate}}</strong>\r\n                                {{\'The following drug allergies were not included in any allergy to drug screening test:\'}}\r\n                                <span ng-repeat="allergy in $ctrl.screening.Allergies.UserDefinedDrugAllergies track by $index">\r\n                                    {{allergy}}<span ng-if="$index !== $ctrl.screening.Allergies.UserDefinedDrugAllergies.length - 1">,</span>\r\n                                </span>\r\n                            </div>\r\n                        </div>\r\n        \r\n                        <div class="drug-screening-group" id="drug-screening-medical-precaution" ng-if="$ctrl.screening.MedicalCondition">\r\n                            <span class="drug-screening-alert-header">{{::\'Medical Condition Precaution\' | translate}}</span>\r\n                            <div ng-repeat="msg in $ctrl.screening.MedicalCondition.Messages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-repeat="msg in $ctrl.screening.MedicalCondition.ScreenMessages track by $index">\r\n                                {{msg.ScreenMessage}}\r\n                                <br />\r\n                                <strong>{{::\'Severity\' | translate}} {{msg.Severity}}</strong>\r\n                            </div>\r\n                            <div ng-if="$ctrl.screening.Allergies.UserDefinedDrugAllergies.length">\r\n                                <strong>{{::\'Custom Drug Allergy Present\' | translate}}</strong>\r\n                                {{\'The following drug allergies were not included in any allergy to drug screening test:\'}}\r\n                                <span ng-repeat="allergy in $ctrl.screening.Allergies.UserDefinedDrugAllergies track by $index">\r\n                                    {{allergy}}<span ng-if="$index !== $ctrl.screening.Allergies.UserDefinedDrugAllergies.length - 1">,</span>\r\n                                </span>\r\n                            </div>\r\n                        </div>\r\n        \r\n                        <div class="drug-screening-group" id="drug-screening-pregnancy-precaution" ng-if="$ctrl.screening.PregancyMessages">\r\n                            <span class="drug-screening-alert-header">{{::\'Pregnancy Precaution\' | translate}}</span>\r\n                            <div ng-repeat="msg in $ctrl.screening.PregancyMessages.Messages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-repeat="msg in $ctrl.screening.PregancyMessages.ScreenMessages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                        </div>\r\n        \r\n                        <div class="drug-screening-group" id="drug-screening-lactation-precaution" ng-if="$ctrl.screening.LactationScreening">\r\n                            <span class="drug-screening-alert-header">{{::\'Lactation Precaution\' | translate}}</span>\r\n                            <div ng-repeat="msg in $ctrl.screening.LactationScreening.Messages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-repeat="msg in $ctrl.screening.LactationScreening.ScreenMessages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                        </div>\r\n        \r\n                        <div class="drug-screening-group" id="drug-screening-pediatric-precaution" ng-if="$ctrl.screening.PediatricScreening">\r\n                            <span class="drug-screening-alert-header">{{::\'Pediatric Precaution\' | translate}}</span>\r\n                            <div ng-repeat="msg in $ctrl.screening.PediatricScreening.Messages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-repeat="msg in $ctrl.screening.PediatricScreening.ScreenMessages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                        </div>\r\n        \r\n                        <div class="drug-screening-group" id="drug-screening-geriatric-precaution" ng-if="$ctrl.screening.GeriatricScreening">\r\n                            <span class="drug-screening-alert-header">{{::\'Geriatric Precaution\' | translate}}</span>\r\n                            <div ng-repeat="msg in $ctrl.screening.GeriatricScreening.Messages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                            <div ng-repeat="msg in $ctrl.screening.GeriatricScreening.ScreenMessages track by $index">\r\n                                {{msg}}\r\n                            </div>\r\n                        </div>\r\n        \r\n                        <div class="drug-screening-group" id="drug-screening-definition-alert" ng-if="$ctrl.screening.WarnUserDefinedMedications.length">\r\n                            <span class="drug-screening-alert-header">{{::\'User Defined Medication Present\' | translate}}</span>\r\n                            <div>\r\n                                {{\'The following medications were not included in any drug screening test:\'}}\r\n                            </div>\r\n                            <div>\r\n                                <span ng-repeat="drug in $ctrl.screening.WarnUserDefinedMedications track by $index">\r\n                                    {{drug}}<span ng-if="!$last">,</span>\r\n                                </span>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="row" ng-show="$ctrl.drugScreeningMode === \'redirecting\'">\r\n                <div class="col-xs-12">\r\n                    <uib-alert type="success" translate>\r\n                        Drug screening found no interactions.\r\n                    </uib-alert>\r\n                </div>\r\n            </div>\r\n            <hr/>\r\n            <div class="row">\r\n                <div id="legal-alert" class="col-xs-12">\r\n                    {{::$ctrl.screening.DisclaimerText}}\r\n\r\n                    <div class="row">\r\n                        <div ng-if="$ctrl.screening.Version" class="col-xs-12 text-center">\r\n                            <div ng-if="$ctrl.screening.Version.NumberOfDaysExpired">\r\n                                {{::\'Number of days the First Databank data has been expired\' | translate}}\r\n                                {{$ctrl.screening.Version.NumberOfDaysExpired}}\r\n                            </div>\r\n                            <div>{{$ctrl.screening.Version.VersionInformation}}</div>\r\n                            <div>{{$ctrl.screening.Version.Copyright}}</div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        \r\n        <div id="drug-screening-out-of-date" ng-show="$ctrl.drugScreeningMode === \'outofdate\'">\r\n            <div class="row">\r\n                <div class="col-xs-12" translate>\r\n                    Drug database is out of date and drug screening cannot be performed.\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="drug-screening-group" id="drug-screening-actx-alert" ng-if="$ctrl.screening.ActXMessages">\r\n            <span class="drug-screening-alert-header">{{::\'ActX Precaution\' | translate}} </span>\r\n            <div ng-repeat="msg in $ctrl.screening.ActXMessages.Alerts track by $index">\r\n                <div>\r\n                    {{msg.MedicationName}}\r\n                </div>\r\n                <div>\r\n                    Seriousness: {{msg.Seriousness}}\r\n                </div>\r\n                <div>\r\n                Summary:  {{msg.ShortSummary}}\r\n                </div>\r\n                <div>\r\n                    Additional Information: {{msg.ExtendedSummary}}\r\n                </div>\r\n            </div>\r\n        </div> \r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardScreeningOverride.html",'<div id="drug-screening-alert-override">\r\n    <div id="drug-screening-override">\r\n        <div class="form-group">\r\n            <label class="control-label" translate>Enter Override Reason</label>\r\n            <ap-select>\r\n                <select\r\n                    class="form-control"\r\n                    name="NotesList"\r\n                    ng-model="$ctrl.selectedOverrideReason"\r\n                    ng-options="override.Notes as override.Name for override in $ctrl.drugScreeningOverrides"\r\n                    ng-change="$ctrl.overrideSelected()">\r\n                </select>\r\n            </ap-select>\r\n            <br />\r\n            <textarea\r\n                class="form-control"\r\n                name="Note"\r\n                ng-model="$ctrl.overrideText"\r\n                ng-change="$ctrl.onOverrideTextChanged()"\r\n                rows="5"\r\n                ng-trim="false"\r\n                ng-required="true">\r\n            </textarea>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardSigInstructions.html",'<form name="$ctrl.sigInstructionsForm">\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="detail-group">\r\n                <div class="form-group" ng-class="{ \'has-error\' : $ctrl.sigInstructionsForm.$error.siginstructionlength}">\r\n                    <div class="pull-right">\r\n                        <label class="control-label">\r\n                            {{$ctrl.getRemainingSigCharacters()}}\r\n                        </label>\r\n                    </div>\r\n                    <p class="form-control-static" ng-if="!$ctrl.isNested">\r\n                        <strong>{{$ctrl.rxParameters.drug.Description}}</strong>\r\n                    </p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row" id="sig-instructions-icons">\r\n        <div class="col-xs-6">\r\n            <i id="open-dosing-btn" class="ap-dosing-suggestions-black" ng-click="$ctrl.openDosingSuggestions()"></i>\r\n        </div>\r\n        <div class="col-xs-6">\r\n            <i class="ap-pdr" ng-click="$ctrl.openPdr()"></i>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="detail-group">\r\n                <div class="form-group" ng-class="{ \'has-error\' : $ctrl.sigInstructionsForm.$error.siginstructionlength}">\r\n                    <sigwriter-wizard-sig-instructions-content\r\n                        rx-options="$ctrl.rxOptions"\r\n                        sig-instruction="$ctrl.sigInstruction"\r\n                        sig-options-non-formulary="$ctrl.sigOptionsNonFormulary"\r\n                        on-select="$ctrl.onSigSelected(sig)"\r\n                        rx-parameters="$ctrl.rxParameters"\r\n                    />\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="form-horizontal">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <div class="form-group" id="quantity-form-group">\r\n                    <label class="col-xs-3 col-sm-2 control-label">{{::\'Quantity\' | translate}}</label>\r\n                    <div class="col-xs-9 col-sm-10">\r\n                        <div class="input-group">\r\n                            <input type="number" class="form-control"\r\n                                   name="quantity"\r\n                                   ng-disabled="$ctrl.sigInstruction.disallowChangingQuantity || !$ctrl.sigInstruction.isManualQuantity"\r\n                                   ng-model="$ctrl.sig.quantity"\r\n                                   ng-change="$ctrl.saveSigInstruction()"\r\n                                   ap-metadata="$ctrl.rxOptions.metadata.visit.Fields.Prescriptions.Fields.Instructions.Fields.TotalQuantity">\r\n                            <span class="input-group-btn" id="toggle-quantity-btn-group" ng-if="!$ctrl.sigInstruction.disallowChangingQuantity">\r\n                                <button class="btn btn-default"\r\n                                        ng-if="!$ctrl.sigInstruction.isManualQuantity"\r\n                                        ng-click="$ctrl.toggleQuantityType()"\r\n                                        ng-disabled="$ctrl.sigInstruction.disallowAutoQuantity"\r\n                                        id="auto-quantity-btn">\r\n                                    {{::\'Auto\' | translate}}\r\n                                </button>\r\n                                <button class="btn btn-default"\r\n                                        ng-if="$ctrl.sigInstruction.isManualQuantity"\r\n                                        ng-click="$ctrl.toggleQuantityType()"\r\n                                        ng-disabled="$ctrl.sigInstruction.disallowAutoQuantity"\r\n                                        id="manual-quantity-btn">\r\n                                    {{::\'Manual\' | translate}}\r\n                                </button>\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="row" ng-hide="$ctrl.disableDates">\r\n            <div class="col-xs-12">\r\n                <div class="form-group">\r\n                    <label class="col-xs-3 col-sm-2 control-label">{{::\'Start Date\' | translate}}</label>\r\n                    <div class="col-xs-9 col-sm-10">\r\n                        <input type="date" class="form-control"\r\n                               ng-model="$ctrl.sig.startDate"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ng-change="$ctrl.saveSigInstruction();"\r\n                               ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.StartDate">\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="row" ng-hide="$ctrl.disableDates">\r\n            <div class="col-xs-12">\r\n                <div class="form-group">\r\n                    <label class="col-xs-3 col-sm-2 control-label">{{::\'End Date\' | translate}}</label>\r\n                    <div class="col-xs-9 col-sm-10">\r\n                        <input type="date" class="form-control"\r\n                               ng-model="$ctrl.sig.endDate"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ng-change="$ctrl.endDateChanged()"\r\n                               ng-min="$ctrl.sig.startDate"\r\n                               ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.StopDate">\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row" ng-if="!$ctrl.rxParameters.isFixedPharmacy && $ctrl.enableMedicationTypeSelection">\r\n        <div class="col-xs-12">\r\n            <div class="form-group row">\r\n                <label class="col-xs-3 col-sm-2 control-label">{{::\'Medication Type\' | translate}}</label>\r\n\r\n                <div class="col-xs-9 col-sm-10">\r\n                    <ap-select>\r\n                        <select class="form-control"\r\n                                ng-model="$ctrl.medicationType"\r\n                                ng-options="type.name for type in $ctrl.rxOptions.additionalMedInfo.medTypes track by type.Id"\r\n                                ng-change="$ctrl.onMedTypeChanged()">\r\n                        </select>\r\n                    </ap-select>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</form>'),$templateCache.put("/sigwriter/component-views/wizardSigInstructionsContent.html",'<div>\r\n    <div class="rx-instructions-menu-text flexbox flexbox-horizontal-center flexbox-horizontal-wrap">\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.startText"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div class="ap-flex-group-r text-token-parent">\r\n            <div class="text-token instructions-dosage ap-flex-group-item"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'dosage\');"\r\n                 ap-context-menu-close="$ctrl.menuClosed(\'dosage\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.dosage.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.dosage.Name && !$ctrl.sig.dosage.isNull">\r\n                    {{$ctrl.sig.dosage.Name}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.dosage || $ctrl.sig.dosage.isNull || $ctrl.sig.dosage.Name === 0" class="rx-instruction-placeholder">\r\n                    {{::\'Dosage\' | translate}}\r\n                </span>\r\n            </div>\r\n            <button type="button"\r\n                    class="btn btn-default-blue-text ap-flex-group-item"\r\n                    ng-if="$ctrl.shouldDisplayDosingCalc()"\r\n                    ng-click="$ctrl.onClickDosingCalculator()">\r\n                {{::\'Calc\' | translate}}\r\n            </button>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postDosage"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div class="text-token instructions-unit"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'unit\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.unit.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.unit.Name && !$ctrl.sig.unit.isNull">\r\n                    {{$ctrl.sig.unit.Name || (\'Unit\' | translate)}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.unit || $ctrl.sig.unit.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'Unit\' | translate}}\r\n                </span>\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postUnit"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div class="text-token instructions-route"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'route\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.route.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.route.Name && !$ctrl.sig.route.isNull">\r\n                    {{$ctrl.sig.route.Name || (\'Route\' | translate)}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.route || $ctrl.sig.route.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'Route\' | translate}}\r\n                </span>\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postRoute"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div class="text-token instructions-frequency"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'frequency\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.frequency.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.frequency.Name && !$ctrl.sig.frequency.isNull">\r\n                    {{$ctrl.sig.frequency.Name || (\'Frequency\' | translate)}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.frequency || $ctrl.sig.frequency.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'Frequency\' | translate}}\r\n                </span>\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postFrequency"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div class="text-token instructions-prn-reason"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'prnReason\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.prnReason.Name ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.prnReason.Name && !$ctrl.sig.prnReason.isNull">{{\'as needed\' | translate}}</span>\r\n                <span ng-if="$ctrl.sig.prnReason.Name && !$ctrl.sig.prnReason.isNull">\r\n                    {{$ctrl.sig.prnReason.Name || (\'PRN\' | translate)}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.prnReason || $ctrl.sig.prnReason.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'PRN\' | translate}}\r\n                </span>\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.postPrn"\r\n                 data-placeholder="_"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div>\r\n            <div contenteditable\r\n                 class="text-token"\r\n                 ng-model="$ctrl.sig.endText"\r\n                 data-placeholder="Instructions"\r\n                 ng-change="$ctrl.fireOnSelect()">\r\n            </div>\r\n        </div>\r\n\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n            <div class="text-token instructions-days"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'days\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.days ? \'\' : \'placeholder\'">\r\n                <span ng-if="$ctrl.sig.days.Name && !$ctrl.sig.days.isNull">\r\n                    {{$ctrl.sig.days.Name}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.days || $ctrl.sig.days.isNull || $ctrl.sig.days.Name === 0" class="rx-instruction-placeholder">\r\n                    {{::\'Day(s)\' | translate}}\r\n                </span>\r\n                <span ng-if="$ctrl.sig.days.Name && !$ctrl.sig.days.isNull">{{\'day(s)\' | translate}}</span>\r\n            </div>\r\n        </div>\r\n\r\n        <div ng-hide="$ctrl.sigOptionsNonFormulary.isAdministered">\r\n            <div class="text-token instructions-refills"\r\n                 ap-context-menu\r\n                 ap-context-menu-on-click="true"\r\n                 ap-context-menu-type="rx-instructions"\r\n                 ap-context-menu-target="rx-instructions-context-menu"\r\n                 ap-context-menu-open="$ctrl.open(\'refills\');"\r\n                 ap-context-menu-set-position="false"\r\n                 ng-class="$ctrl.sig.refills ? \'\' : \'placeholder\'">\r\n                <span ng-if="($ctrl.sig.refills.Name || $ctrl.sig.refills.Name === 0) && !$ctrl.sig.refills.isNull">\r\n                    {{$ctrl.sig.refills.Name}}\r\n                </span>\r\n                <span ng-if="!$ctrl.sig.refills || $ctrl.sig.refills.isNull" class="rx-instruction-placeholder">\r\n                    {{::\'Refill(s)\' | translate}}\r\n                </span>\r\n                <span ng-if="($ctrl.sig.refills.Name || $ctrl.sig.refills.Name === 0) && !$ctrl.sig.refills.isNull">{{\'refill(s)\' | translate}}</span>\r\n            </div>\r\n        </div>\r\n\r\n\r\n    </div>\r\n</div>\r\n\r\n<div id="rx-instructions-context-menu" class="context-menu" ng-cloak style="bottom: 0px; left: 0; width: 100%;  height: {{$ctrl.maxHeight}}px;">\r\n    <ul class="dropdown-menu position-fixed" role="menu"\r\n        style="height: auto; min-height: {{$ctrl.maxHeight}}px; max-height: {{$ctrl.maxHeight}}px; overflow-x: hidden; width: 100%; top:0;">\r\n        <li class="dropdown-header">\r\n            {{$ctrl.currentOption.name}}\r\n        </li>\r\n\r\n        <li ng-if="$ctrl.currentOption.allowNumericFreeEntry">\r\n            <form>\r\n                <div class="form-group">\r\n                    <div class="input-group input-group-sm">\r\n                        <input type="number"\r\n                               class="form-control"\r\n                               placeholder="Custom {{$ctrl.currentOption.name}}"\r\n                               ng-model="$ctrl.sig.numericEntry" />\r\n                        <span class="input-group-btn">\r\n                            <button class="btn btn-default" type="submit"\r\n                                    ng-click="$ctrl.selectTextOption()">\r\n                                <span><i class="fa fa-check"></i></span>\r\n                            </button>\r\n                        </span>\r\n                    </div>\r\n                </div>\r\n            </form>\r\n        </li>\r\n\r\n        <li ng-repeat="option in $ctrl.options"\r\n            class="text-center rx-instructions-option"\r\n                ng-class="{\'selected\': $ctrl.optionSelected(option, $ctrl.currentOption)}">\r\n            <a class="pointer"\r\n               role="menuitem"\r\n               tabindex="{{$index}}"\r\n               ng-click="$ctrl.selectOption(option)"\r\n               translate>\r\n                {{option.Name || option}} {{option.suffix || option.Suffix}}\r\n            </a>\r\n        </li>\r\n    </ul>\r\n</div>'),$templateCache.put("/sigwriter/component-views/wizardSigOptions.html",'<form name="$ctrl.sigOptionsForm" novalidate>\r\n    <div>\r\n        <div ng-if="!$ctrl.rxParameters.isFixedPharmacy && !$ctrl.drugAdministered">\r\n            <div class="form-horizontal">\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group rx-pharmacy" id="pharmacy-form-group"\r\n                            ng-class="{ \'has-error\' : ($ctrl.sigOptionsForm.PharmacyId.$invalid && ($ctrl.sigOptionsForm.PharmacyId.$dirty || $ctrl.sigOptionsForm.isSubmitted))}">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Pharmacy\' | translate}}</label>\r\n\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <ap-find-pharmacy\r\n                                        name="PharmacyId"\r\n                                        ng-model="$ctrl.pharmacy"\r\n                                        ng-change="$ctrl.onFindPharmacyChanged()"\r\n                                        ap-required="true"\r\n                                        default-list="$ctrl.pharmacies"\r\n                                        parent-container-id="$ctrl.parentContainerId">\r\n                                </ap-find-pharmacy>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group"\r\n                        ng-class="{ \'has-error\' : ($ctrl.sigOptionsForm.pharmacyInstructions.$invalid && ($ctrl.sigOptionsForm.pharmacyInstructions.$dirty || $ctrl.sigOptionsForm.isSubmitted))}">\r\n                        <div class="pull-right">\r\n                            <label class="control-label">\r\n                                {{$ctrl.getRemainingPharmacyInstructionCharacters()}}\r\n                            </label>\r\n                        </div>\r\n                        <label class="control-label">{{::\'Pharmacy Instructions\' | translate}}</label>\r\n                        <textarea class="form-control"\r\n                                name="pharmacyInstructions"\r\n                                ng-model="$ctrl.optionsNonFormulary.pharmacyInstructions"\r\n                                ap-auto-grow\r\n                                ap-metadata="$ctrl.rxOptions.metadata.visit.Fields.Prescriptions.Fields.Instructions.Fields.PharmacyInstruction"\r\n                                ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                        </textarea>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="form-horizontal">\r\n            <div class="row" ng-if="$ctrl.rxParameters.isFixedPharmacy">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group" id="Pharmacy">\r\n                        <label class="col-xs-3 col-sm-2 control-label" class="control-label" translate>Pharmacy</label>\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <ap-pharmacy-item pharmacy="$ctrl.options.pharmacy"></ap-pharmacy-item>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <hr />\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="col-xs-3 col-sm-2 control-label">{{::\'UOM\' | translate}}</label>\r\n\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <ap-select>\r\n                                <select id="sig-options-uom"\r\n                                        class="form-control"\r\n                                        ng-model="$ctrl.options.uom"\r\n                                        ng-options="uom.Name for uom in $ctrl.rxOptions.lists.unitsOfMeasure track by uom.Id"\r\n                                        ng-change="$ctrl.onOptionsChanged()">\r\n                                </select>\r\n                            </ap-select>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <hr />\r\n\r\n            <div ng-if="$ctrl.optionsNonFormulary.isAdministered || $ctrl.optionsNonFormulary.isSampleGiven">\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 control-label" style="color:rgb(0, 105, 165);font-weight:bold">{{::\'MEDICATION OPTIONS\' | translate}}</label>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row" ng-if="$ctrl.optionsNonFormulary.isAdministered">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Site\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <ap-select>\r\n                                    <select class="form-control"\r\n                                            id="mt-site"\r\n                                            ng-model="$ctrl.optionsNonFormulary.medicationSite"\r\n                                            ng-options="site.Name for site in $ctrl.rxOptions.additionalMedInfo.medicationSites"\r\n                                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                    </select>\r\n                                </ap-select>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Lot #\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <textarea class="form-control"\r\n                                          id="mt-lot"\r\n                                          ng-model="$ctrl.optionsNonFormulary.lotNumber"\r\n                                          ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                </textarea>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label overflow-wrap-hyphens">{{::\'Manufacturer\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <ap-select>\r\n                                    <select class="form-control" id="mt-mfr"\r\n                                            ng-model="$ctrl.optionsNonFormulary.manufacturer"\r\n                                            ng-options="site.Name for site in $ctrl.rxOptions.additionalMedInfo.manufacturers"\r\n                                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                    </select>\r\n                                </ap-select>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row" ng-if="$ctrl.optionsNonFormulary.isAdministered">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Funding Source\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <ap-select>\r\n                                    <select class="form-control" id="mt-funding"\r\n                                            ng-model="$ctrl.optionsNonFormulary.fundingSource"\r\n                                            ng-options="site.Name for site in $ctrl.rxOptions.additionalMedInfo.fundingSources"\r\n                                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                    </select>\r\n                                </ap-select>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Expiration Date\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <input type="date" class="form-control" id="mt-expirDate"\r\n                                       ng-model="$ctrl.optionsNonFormulary.expirationDate"\r\n                                       ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.ExpirationDate"\r\n                                       ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                                       ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row" ng-if="$ctrl.optionsNonFormulary.isAdministered">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label">{{::\'Initials\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <textarea class="form-control"\r\n                                          id="mt-initials"\r\n                                          ng-model="$ctrl.optionsNonFormulary.initials"\r\n                                          ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                </textarea>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="row" ng-if="$ctrl.optionsNonFormulary.isAdministered">\r\n                    <div class="col-xs-12">\r\n                        <div class="form-group">\r\n                            <label class="col-xs-3 col-sm-2 control-label overflow-wrap-hyphens">{{::\'Administration Date\' | translate}}</label>\r\n                            <div class="col-xs-9 col-sm-10">\r\n                                <input type="date" class="form-control" id="mt-adminDate"\r\n                                       ng-model="$ctrl.optionsNonFormulary.administeredDateTime"\r\n                                       ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                                       ap-metadata="$ctrl.rxOptions.metadata.sig.Fields.AdministeredDate"\r\n                                       ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <hr ng-if="$ctrl.optionsNonFormulary.isAdministered || $ctrl.optionsNonFormulary.isSampleGiven" />\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="col-xs-3 col-sm-2 control-label">{{::\'Diagnoses & Problems\' | translate}}</label>\r\n\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <select class="form-control"\r\n                                    ng-model="$ctrl.optionsNonFormulary.problems"\r\n                                    ng-options="problem as problem.Name for problem in $ctrl.problems"\r\n                                    ng-change="$ctrl.onOptionsNonFormularyChanged()"\r\n                                    multiple="multiple">\r\n                            </select>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="col-xs-3 col-sm-2 control-label">{{::\'Category\' | translate}}</label>\r\n\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <ap-select>\r\n                                <select class="form-control"\r\n                                        ng-model="$ctrl.optionsNonFormulary.category"\r\n                                        ng-options="category as category.Name for category in $ctrl.rxOptions.lists.medicationCategories track by category.Id"\r\n                                        ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                                </select>\r\n                            </ap-select>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="col-xs-3 col-sm-2 control-label">{{::\'Options\' | translate}}</label>\r\n\r\n                        <div class="col-xs-9 col-sm-10">\r\n                            <div class="flexbox flexbox-horizontal-center">\r\n                                <div>\r\n                                    {{::\'Dispense as Written\' | translate}}\r\n                                </div>\r\n                                <div class="flexbox-pull-right">\r\n                                    <input type="checkbox" name="daw" id="daw"\r\n                                           ng-model="$ctrl.optionsNonFormulary.daw"\r\n                                           ng-disabled="$ctrl.dawDisabled"\r\n                                           ng-change="$ctrl.onOptionsNonFormularyChanged()"\r\n                                           ap-checkbox-hidden-label="Dispense as Written">\r\n                                </div>\r\n                            </div>\r\n                            <hr />\r\n                            <div class="flexbox flexbox-horizontal-center">\r\n                                <div>\r\n                                    {{::\'Chronic Medication\' | translate}}\r\n                                </div>\r\n                                <div class="flexbox-pull-right">\r\n                                    <input type="checkbox" name="chronic-med" id="chronic-med"\r\n                                           ng-model="$ctrl.optionsNonFormulary.isChronicMed"\r\n                                           ng-disabled="$ctrl.chronicDisabled"\r\n                                           ng-change="$ctrl.onOptionsNonFormularyChanged()"\r\n                                           ap-checkbox-hidden-label="Chronic Medication">\r\n                                </div>\r\n                            </div>\r\n                            <hr />\r\n                            <div class="flexbox flexbox-horizontal-center">\r\n                                <div>\r\n                                    {{::\'High Risk Medication\' | translate}}\r\n                                </div>\r\n                                <div class="flexbox-pull-right">\r\n                                    <input type="checkbox" name="high-risk-med" id="high-risk-med"\r\n                                           ng-model="$ctrl.optionsNonFormulary.isHighRiskMed"\r\n                                           ng-change="$ctrl.onOptionsNonFormularyChanged()"\r\n                                           ap-checkbox-hidden-label="High Risk Medication">\r\n                                </div>\r\n                            </div>\r\n                            <hr />\r\n                            <div class="flexbox flexbox-horizontal-center">\r\n                                <div>\r\n                                    {{::\'Include Monograph\' | translate}}\r\n                                </div>\r\n                                <div class="flexbox-pull-right">\r\n                                    <input type="checkbox" name="include-monograph" id="include-monograph"\r\n                                           ng-model="$ctrl.optionsNonFormulary.includeMonograph"\r\n                                           ng-change="$ctrl.onOptionsNonFormularyChanged()"\r\n                                           ap-checkbox-hidden-label="Include Monograph">\r\n                                </div>\r\n                            </div>\r\n                            <div ng-show="$ctrl.shouldDisplayEpaSpoCheckbox">\r\n                                <hr />\r\n                                <div class="flexbox flexbox-horizontal-center">\r\n                                    <div>\r\n                                        {{::\'Electronic Prior Authorization\' | translate}}\r\n                                    </div>\r\n                                    <div class="flexbox-pull-right">\r\n                                        <input type="checkbox" name="send-prior-auth" id="send-prior-auth"\r\n                                            ng-model="$ctrl.optionsNonFormulary.sendPriorAuth"\r\n                                            ng-change="$ctrl.onSendPriorAuthChanged()"\r\n                                            ap-checkbox-hidden-label="Electronic Prior Authorization">\r\n                                    </div>\r\n                                </div>\r\n                                <hr />\r\n                                <div class="flexbox flexbox-horizontal-center">\r\n                                    <div>\r\n                                        {{::\'Specialty Patient Enrollment\' | translate}}\r\n                                    </div>\r\n                                    <div class="flexbox-pull-right">\r\n                                        <input type="checkbox" name="send-is-specialty" id="send-is-specialty"\r\n                                            ng-model="$ctrl.optionsNonFormulary.sendIsSpecialty"\r\n                                            ng-change="$ctrl.onOptionsNonFormularyChanged()"\r\n                                            ap-checkbox-hidden-label="Specialty Patient Enrollment">\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="row" ng-if="!$ctrl.rxParameters.isFixedPharmacy">\r\n            <div class="col-xs-12">\r\n                <div class="form-group">\r\n                    <label class="control-label">{{::\'Internal Note\' | translate}} </label>\r\n                    <ap-select>\r\n                        <select class="form-control"\r\n                                name="NotesList"\r\n                                ng-model="$ctrl.notesList.Note"\r\n                                ng-options="generalNote.Notes as generalNote.Name for generalNote in $ctrl.generalNotes"\r\n                                ng-change="$ctrl.notesListChanged()">\r\n                        </select>\r\n                    </ap-select>\r\n                    <br>\r\n                    <textarea\r\n                            name="PharmacyNote"\r\n                            class="form-control"\r\n                            ng-model="$ctrl.optionsNonFormulary.internalNote"\r\n                            ap-auto-grow\r\n                            ng-change="$ctrl.onOptionsNonFormularyChanged()">\r\n                    </textarea>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</form>\r\n'),$templateCache.put("/sigwriter/views/modals/drug-consent-modal.html",'<div ap-full-modal class="modal-v18 modal-medication-consent">\r\n    <form ng-submit="vm.save(rxConsentForm)" name="rxConsentForm" novalidate>\r\n        <div class="modal-header">\r\n            <div class="row">\r\n                <div class="col-xs-8 heading-title modal-title">{{\'Rx Consent\' | translate}}</div>\r\n                <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n            </div>\r\n        </div>\r\n        <div class="modal-body">\r\n            <div class="form-group">\r\n                <label translate>How Discussed</label>\r\n                <div class="row col-xs-12">\r\n                    <input type="checkbox"\r\n                           id="cbOption"\r\n                           ng-model="vm.inPerson"\r\n                           ng-change="vm.telephone=false; vm.telemedicine=false; vm.previously=false;">\r\n                    <label for="cbOption">In-Person</label>\r\n                </div>\r\n                <div class="row col-xs-12">\r\n                    <input type="checkbox"\r\n                           id="cbOption2"\r\n                           ng-model="vm.telephone" ng-change="vm.inPerson=false; vm.telemedicine=false; vm.previously=false;">\r\n                    <label for="cbOption2">Telephone</label>\r\n                </div>\r\n                <div class="row col-xs-12">\r\n                    <input type="checkbox"\r\n                           id="cbOption3"\r\n                           ng-model="vm.telemedicine"\r\n                           ng-change="vm.inPerson=false; vm.telephone=false; vm.previously=false;">\r\n                    <label for="cbOption3">Telemedicine</label>\r\n                </div>\r\n                <div class="row col-xs-12">\r\n                    <input type="checkbox"\r\n                           id="cbOption4"\r\n                           ng-model="vm.previously"\r\n                           ng-change="vm.inPerson=false; vm.telephone=false; vm.telemedicine=false;">\r\n                    <label for="cbOption4">Previously</label>\r\n                </div>\r\n            </div>\r\n            <div class="row"></div>\r\n\r\n            <div class="row">\r\n                <div class="col col-xs-12">\r\n                    <div class="form-group">\r\n                        <label for="symptomtext">\r\n                            <a class="clickable underline" ng-click="vm.onClickSymptom()" id="mc-symptom-link">\r\n                                {{::\'Symptom\' | translate}}\r\n                            </a>\r\n                        </label>\r\n                        <input type="text" name="symptomtext" class="form-control" ng-model="vm.symptom" ap-required="true" />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row">\r\n                <div class="col col-xs-12">\r\n                    <div class="form-group">\r\n                        <label for="formattingmodel" translate>Formatting Model</label>\r\n                        <input type="text" name="formattingmodel" ng-model="vm.formattingTemplateName" class="form-control" readonly="true" />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n            <button type="button" class="btn btn-primary" ng-click="vm.cancel()">{{::\'Cancel\' | translate}}</button>\r\n            <button type="submit" class="btn btn-primary">{{::\'Save\' | translate}}</button>\r\n        </div>\r\n    </form>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/drug-consent-warning-modal.html",'<div id="drug-consent-warning" ap-full-modal>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="$dismiss(\'\')">&times;</button>\r\n        <h4 class="modal-title">Patient Consent Required</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <uib-alert type="danger">\r\n                    {{drugConsentWarning.drugName}}\r\n                    <span translate>\r\n                        cannot be prescribed because it requires patient consent. Aprima NOW does not support drugs which require patient consent.\r\n                    </span>\r\n                </uib-alert>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id="drug-consent-warning-footer" class="modal-footer">\r\n        <button type="submit" class="btn btn-default" ng-click="$dismiss(\'close\')">Close</button>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/sigwriter/views/modals/drug-documentation-modal.html",'<div id="drug-documentation" ap-full-modal class="modal-v18">\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title" translate>Drug Documentation</h4>\r\n    </div>\r\n    <div class="modal-body pdr-modal-body">\r\n        <sigwriter-wizard-pdr\r\n            drug="vm.drug"\r\n            patient="vm.patient"\r\n            rx-id="vm.rxId"\r\n        />\r\n    </div>\r\n    <div class="modal-footer">\r\n        <button class="btn btn-primary" ng-click="vm.close()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/drug-screening-modal.html",'<div ap-full-modal ap-full-modal-always>\r\n    <wizard name="{{vm.wizardName}}" on-finish="vm.onFinish()" hide-indicators="true">\r\n        <div class="modal-header">\r\n            <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n            <h4 class="modal-title">{{vm.getStepTitle()}}</h4>\r\n        </div>\r\n        <div class="modal-body">\r\n            <wz-step wz-title="{{::vm.lookups.screeningTitle}}">\r\n                <sigwriter-wizard-screening-content\r\n                    rx-parameters="vm.rxParameters"\r\n                    update-drug-screening="vm.updateDrugScreening(drugScreening)"\r\n                    update-is-screening-loaded="vm.updateIsScreeningLoaded(isLoaded, isOverrideRequired, status)"\r\n                />\r\n            </wz-step>\r\n            <wz-step wz-title="{{::vm.lookups.overrideTitle}}" wz-disabled="{{!vm.requiresOverride}}">\r\n                <sigwriter-wizard-screening-override\r\n                    drug-screening="vm.drugScreening"\r\n                    update-drug-screening="vm.updateDrugScreening(drugScreening)"\r\n                />\r\n            </wz-step>\r\n        </div>\r\n        <div class="modal-footer">\r\n            <div class="row">\r\n                <div class="col-xs-6">\r\n                    <button id="previous-btn" type="submit" class="btn-modal btn-default"\r\n                            ng-hide="(vm.getWizard().currentStepNumber() === 1)"\r\n                            wz-previous>\r\n\r\n                        Back\r\n                    </button>\r\n                </div>\r\n                <div class="col-xs-6">\r\n                    <button id="next-btn" type="submit" class="btn-modal btn-default"\r\n                            ng-hide="(vm.getWizard().currentStepNumber() === vm.getWizard().getEnabledSteps().length)"\r\n                            wz-next>\r\n\r\n                        Next\r\n                    </button>\r\n                    <button id="finish-btn" type="submit" class="btn-modal btn-default"\r\n                            ng-show="(vm.getWizard().currentStepNumber() === vm.getWizard().getEnabledSteps().length)"\r\n                            ng-disabled="!vm.isScreeningLoaded"\r\n                            wz-finish>\r\n\r\n                        Finish\r\n                    </button>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </wizard>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/dx-problems-modal.html",'<div class="modal-noborder" ap-full-modal>\r\n<div class="modal-header">\r\n        Active Diagnosis ({{vm.countSelected()}})\r\n        <button id="dpm-close-x"\r\n                type="button"\r\n                class="close"\r\n                ng-click="vm.cancel()">\r\n            &times;\r\n        </button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <uib-alert type="danger"\r\n                   ng-if="vm.httpError"\r\n                   translate\r\n                   class="alert-flush">\r\n            There was an error loading the patient\'s diagnoses and problems.\r\n        </uib-alert>\r\n\r\n        <div ng-if="!vm.httpError && !vm.orderByDisplayOrder">\r\n            <div ng-repeat="item in vm.items | orderBy: vm.getItemOrder track by item.Uid">\r\n                <input type="checkbox"\r\n                       ap-checkbox-label="{{vm.formatter(item)}}"\r\n                       id="dx-problem-{{$index}}"\r\n                       ng-click="vm.onClickDxProblemItem(item)"\r\n                       ng-model="item.selected">\r\n            </div>\r\n        </div>\r\n        <div ng-if="!vm.httpError && vm.orderByDisplayOrder">\r\n            <div ng-repeat="item in vm.items track by item.Uid">\r\n                <input type="checkbox"\r\n                       ap-checkbox-label="{{vm.formatter(item)}}"\r\n                       id="dx-problem-by-display-order-{{$index}}"\r\n                       ng-click="vm.onClickDxProblemItem(item)"\r\n                       ng-model="item.selected">\r\n            </div>\r\n        </div>\r\n\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button">\r\n        <button id="dpm-clear"\r\n                type="button"\r\n                class="btn btn-default"\r\n                ng-click="vm.clear()">\r\n            Clear\r\n        </button>\r\n        <button id="dpm-done"\r\n                type="button"\r\n                class="btn btn-primary"\r\n                ng-click="vm.done()"\r\n                translate>\r\n            Done\r\n        </button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/required-screens-modal.html",'<div id="required-screens" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.close()">&times;</button>\r\n        <h4 class="modal-title" translate>Required Screens</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <h4 translate>These pages must be viewed:</h4>\r\n        <div ng-repeat="title in vm.titles">\r\n            <a class="clickable" ng-click="vm.selectTitle(title)">\r\n                {{title}}\r\n            </a>\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer">\r\n        <button class="btn btn-primary" ng-click="vm.close()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/save-rx-modal.html",'<div id="save-rx" ap-full-modal ap-full-modal-always>\r\n    <div id=\'processing-overlay\' class=\'overlay\'  ng-if="vm.saving">\r\n    </div>\r\n\r\n    <div ng-if="vm.errorMessages">\r\n        <div class="modal-header">\r\n            <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n            <h4 class="modal-title" translate>Save Rx</h4>\r\n        </div>\r\n        <div class="modal-body">\r\n            <div ng-show="vm.saving" class="text-center">\r\n                <ap-spinner size="3"></ap-spinner>\r\n            </div>\r\n\r\n            <div id="save-rx-error" ng-if="vm.errorMessages">\r\n                <h4 translate>Error saving Rx:</h4>\r\n                <span ng-repeat="errorText in vm.errorMessages track by $index"><br>{{errorText}}</span>\r\n            </div>\r\n        </div>\r\n        <div class="modal-footer">\r\n            <button class="btn btn-primary" ng-click="vm.cancel()" ng-disabled="vm.saving" translate>OK</button>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/sigwriterFormularyDetailsModal.html",'<div id="formulary-details-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <sigwriter-formulary-details\r\n            details="vm.details"\r\n            is-info-available="vm.isInfoAvailable"\r\n            on-drug-selected="vm.changeMedication(drug, pharmacy)"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/sigwriterRxBenefitDetailsModal.html",'<div id="rx-benefit-details-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <patient-rx-benefit-details\r\n            eligibility="vm.eligibility"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/sigwriterScreeningModal.html",'<div id="sig-screening-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button ng-if="!vm.readOnly" id="ssm-close-x" type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title" translate>Drug Screening</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <div id="drug-screening-loading" ng-if="vm.loadingDrugScreening">\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    Performing Drug Screening\r\n                    <br/>\r\n                    <ap-spinner data-size="3"></ap-spinner>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div id="drug-screening-error" ng-if="!vm.loadingDrugScreening && vm.nddScreeningErrorMessages">\r\n            <h4 translate>Error Performing Drug Screening:</h4>\r\n            <span ng-repeat="errorText in vm.nddScreeningErrorMessages track by $index"><br>{{errorText}}</span>\r\n        </div>\r\n        <div id="drug-screening-alerts" ng-if="!vm.loadingDrugScreening && !vm.nddScreeningErrorMessages">\r\n            <div class="screening-content">\r\n                <ndd-detailed-drug-screening\r\n                    screening="vm.nddScreening"\r\n                />\r\n            </div>\r\n            <div ng-if="!vm.readOnly" class="screening-override">\r\n                <div class="form-group">\r\n                    <label for="overrideReason">\r\n                        <a class="clickable underline"\r\n                           ng-click="vm.onClickOverrideReason()"\r\n                           translate>\r\n                            Reason for Override\r\n                        </a>\r\n                    </label>\r\n                    <textarea\r\n                        ng-model="vm.overrideText"\r\n                        class="textarea-full"\r\n                        id="overrideReason">\r\n                    </textarea>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n        <button ng-if="!vm.readOnly" id="ssm-cancel" class="btn btn-primary" ng-click="vm.cancel()" translate>Cancel</button>\r\n        <button id="ssm-ok" class="btn btn-primary" ng-click="vm.ok()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/modals/sigwriterSigDetailsModal.html",'<div class="desktop-form" id="sig-details-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title" translate>{{vm.rxParameters.drug.Description}}</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <form name="vm.tabletSigDetailsForm">\r\n            <sigwriter-tablet-sig-details\r\n                initial-field="vm.initialField"\r\n                patient-details="vm.patientDetails"\r\n                rx-options="vm.rxOptions"\r\n                rx-parameters="vm.rxParameters"\r\n                sig-instruction="vm.sigInstruction"\r\n                sig-options-non-formulary="vm.sigOptionsNonFormulary"\r\n                update-sig-instruction="vm.updateSigInstruction(updatedSigInstruction)"\r\n            >\r\n            </sigwriter-tablet-sig-details>\r\n        </form>\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n        <button class="btn btn-primary" ng-click="vm.cancel()" translate>Cancel</button>\r\n        <button class="btn btn-primary" ng-click="vm.ok()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/sigwriter/views/rxWizardDrugSearch.html",'<sigwriter-wizard-drug-search\r\n    defer-saving="vm.deferSaving"\r\n    patient-id="vm.patientId"\r\n    use-previous-search-text="vm.usePreviousSearchText"\r\n    on-drug-selected="vm.onDrugSelected(rx)"\r\n    on-existing-sig-selected="vm.onExistingSigSelected(rx)"\r\n    kdb-parameters="vm.kdbParameters">\r\n</sigwriter-wizard-drug-search>'),$templateCache.put("/sigwriter/views/rxWizardRefill.html",'<div class="container-fluid search-unlocked" ng-cloak>\r\n    <div class="panel panel-default" ng-show="!vm.$scope.httpError">\r\n        <div class="panel-body">\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    <span ng-show="vm.loadingRefill">\r\n                        Preparing Refill...\r\n                    </span>\r\n                    <br/>\r\n                    <ap-spinner size="3"></ap-spinner>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="panel panel-default ng-hide" ng-show="vm.$scope.httpError">\r\n        <div class="panel-heading" translate>\r\n            New Rx Refill\r\n        </div>\r\n        <div class="panel-body">\r\n            <div class="row">\r\n                <div class="col-xs-12" ng-show="vm.$scope.httpError.unhandled">\r\n                    <uib-alert type="danger">\r\n                        {{::"An error has occurred and the SIG could not be loaded." | translate}}\r\n                    </uib-alert>\r\n                </div>\r\n                <div class="col-xs-12" ng-show="vm.$scope.httpError.is403">\r\n                    <uib-alert type="danger">\r\n                        {{::\'You do not have access to this SIG.\' | translate}}\r\n                    </uib-alert>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>')}]),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("freeTextDirections",{templateUrl:"/sigwriter/component-views/freeTextDirections.html",transclude:!0,bindings:{textOpen:"=",textValue:"<"},controller:["$element","$timeout",function($element,$timeout){var elementToFocus,vm=this;vm.onClickOpen=function(){vm.textOpen=!0,$timeout(function(){elementToFocus&&elementToFocus.focus()})},vm.$postLink=function(){elementToFocus=$element.children("[ng-transclude]").children()[0]},vm.hasValue=function(){return!!vm.textValue}}],controllerAs:"vm"})}(),function(angular){"use strict";angular.module("aprima-sigwriter").component("nddCondensedDrugScreening",{templateUrl:"/sigwriter/component-views/nddCondensedDrugScreening.html",bindings:{error:"<",loading:"<",screening:"<"},controller:["SigwriterDrugScreeningService",function(SigwriterDrugScreeningService){this.getClassFromSeverity=SigwriterDrugScreeningService.getClassFromSeverity,this.getClassFromSeverityLevel=SigwriterDrugScreeningService.getClassFromSeverityLevel}]})}(angular),function(angular){"use strict";angular.module("aprima-sigwriter").component("nddDetailedDrugScreening",{templateUrl:"/sigwriter/component-views/nddDetailedDrugScreening.html",bindings:{error:"<",loading:"<",screening:"<"},controller:["SigwriterDrugScreeningService",function(SigwriterDrugScreeningService){var vm=this;vm.getClassFromSeverity=SigwriterDrugScreeningService.getClassFromSeverity,vm.getClassFromSeverityLevel=SigwriterDrugScreeningService.getClassFromSeverityLevel,vm.getGeriatricSeverityTitle=SigwriterDrugScreeningService.getGeriatricSeverityTitle,vm.getInteractionSeverityTitle=SigwriterDrugScreeningService.getInteractionSeverityTitle,vm.getLactationSeverityTitle=SigwriterDrugScreeningService.getLactationSeverityTitle,vm.getMedicalConditionSeverityTitle=SigwriterDrugScreeningService.getMedicalConditionSeverityTitle,vm.getPediatricSeverityTitle=SigwriterDrugScreeningService.getPediatricSeverityTitle,vm.getPregnancySeverityTitle=SigwriterDrugScreeningService.getPregnancySeverityTitle}]})}(angular),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterDrugIconGroup",{templateUrl:"/sigwriter/component-views/drugIconGroup.html",bindings:{drug:"<",drugWithFormulary:"<"},controller:[function(){var vm=this;vm.drug?(vm.genericTypeClass=getGenericTypeClass(vm.drug.AKAIndicator),vm.ePrescribeTypeClass=getEPrescribeClass(vm.drug.EPrescribeIndicator)):vm.drugWithFormulary&&(vm.genericTypeClass=getGenericTypeClass(vm.drugWithFormulary.AKAIndicator),vm.ePrescribeTypeClass=getEPrescribeClass(vm.drugWithFormulary.EPrescribeIndicator));function getGenericTypeClass(genericType){switch(genericType){case"Brand":return"ap-rxsearch-icon-brand";case"Generic":return"ap-rxsearch-icon-generic"}}function getEPrescribeClass(ePrescribeType){switch(ePrescribeType){case"Schedule0":return"ap-rxsearch-icon-schedule0";case"Schedule1":return"ap-rxsearch-icon-schedule1";case"Schedule2":return"ap-rxsearch-icon-schedule2";case"Schedule3":return"ap-rxsearch-icon-schedule3";case"Schedule4":return"ap-rxsearch-icon-schedule4";case"Schedule5":return"ap-rxsearch-icon-schedule5";default:return"ap-rxsearch-icon-noeprescribe"}}}]})}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterDxProblems",{templateUrl:"/core-ui/component-views/ap-multi-select-button.html",bindings:{ngDisabled:"&",patientId:"<",medicationSigId:"<",orderByDisplayOrder:"<"},require:{ngModelCtrl:"ngModel"},controller:["$element","ApMultiSelectButton","DxProblemsModal","SigwriterDxProblemsService",function($element,ApMultiSelectButton,DxProblemsModal,SigwriterDxProblemsService){var vm=this;function formatter(value){if(!value)return null;var code=value.Icd10Code||value.Icd9Code,name=value.Name,description=name;return name&&code&&(description=code+" - "+name),!name&&code&&(description=code),description}function getOrder(item){if(!item)return"2";return vm.orderByDisplayOrder?SigwriterDxProblemsService.getSortOrderForSelectedDxProblemItem(item):""+(item.IsProblem?1:0)+(item.Name&&item.Name.toLowerCase())}ApMultiSelectButton.init(vm,function(selectedItems){return DxProblemsModal.openModal(vm.patientId,vm.medicationSigId,vm.orderByDisplayOrder,selectedItems,formatter,getOrder)},formatter,getOrder,$element.find("button"))}],controllerAs:"vm"})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterEpcsSignature",{templateUrl:"/sigwriter/component-views/epcsSignature.html",bindings:{epcsModel:"=",siteId:"<"},controller:["LocalStorageRepository","SettingRepository","$q",function(LocalStorageRepository,SettingRepository,$q){var vm=this;vm.epcsModel={},vm.loading=!0;var promises=[LocalStorageRepository.getUserName(),LocalStorageRepository.getUserID(),LocalStorageRepository.getDeviceId(),LocalStorageRepository.getUserFullName()];$q.all(promises).then(function(results){vm.epcsModel.loggedOnUser=results[0],vm.epcsModel.loggedOnUserId=results[1],vm.epcsModel.loggedOnDevice=results[2],vm.epcsModel.providerName=results[3],SettingRepository.getProviderEpcsSettings(results[1],vm.siteId).then(function(result){vm.epcsModel.providerDeaNumber=(result||{}).DeaNumber,vm.epcsModel.pinType=result&&result.PinType}).finally(function(){vm.loading=!1})})}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterFormularyDetails",{templateUrl:"/sigwriter/component-views/formularyDetails.html",bindings:{details:"<",error:"<",hideTransmitStatus:"<",isInfoAvailable:"<",loading:"<",onDrugSelected:"&"},controller:["toaster",function(toaster){var vm=this;vm.showResponseXml=!1,vm.showRFSResponseXml=!1,vm.changeMedication=function(med,pricingCoverage){if(!med.Drug)return void toaster.pop("error","","'"+med.Description+"' is an unknown drug in the system.");var pharmacy;pricingCoverage&&(pricingCoverage.Pharmacy&&pricingCoverage.Pharmacy.Id?pharmacy=pricingCoverage.Pharmacy:toaster.pop("warning","","'"+pricingCoverage.PharmacyName+"' is an unknown pharmacy in the system."));vm.onDrugSelected({drug:med.Drug,pharmacy:pharmacy})},vm.showRTPSResponseXml=!1}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterFormularyDisplay",{templateUrl:"/sigwriter/component-views/formularyDisplay.html",bindings:{details:"<",error:"<",isInfoAvailable:"<",loading:"<",onDrugSelected:"&"},controller:["toaster",function(toaster){var vm=this;vm.changeMedication=function(med,pricingCoverage){if(!med.Drug)return void toaster.pop("error","","'"+med.Description+"' is an unknown drug in the system.");var pharmacy;pricingCoverage&&(pricingCoverage.Pharmacy&&pricingCoverage.Pharmacy.Id?pharmacy=pricingCoverage.Pharmacy:toaster.pop("warning","","'"+pricingCoverage.PharmacyName+"' is an unknown pharmacy in the system."));vm.onDrugSelected({drug:med.Drug,pharmacy:pharmacy})},vm.formularyStatusCertification=function(formularyStatus){return formularyStatus?"Formulary"===formularyStatus?"On Formulary/Non-Preferred":formularyStatus.length>="Preferred".length&&"Preferred"===formularyStatus.substring(0,"Preferred".length)?"On Formulary/"+formularyStatus:formularyStatus:"Formulary Status Not Available"},vm.formularyStatusShow=function(formularyStatus){return formularyStatus?"Formulary"===formularyStatus?"On Formulary":formularyStatus.length>="Preferred".length&&"Preferred"===formularyStatus.substring(0,"Preferred".length)?"On Formulary/"+formularyStatus:formularyStatus:"Formulary Status Not Available"},vm.hasAlternatives=function(){var i;if(vm.details.ResponsePMBC&&vm.details.ResponsePMBC.Medications)for(i=0;i<vm.details.ResponsePMBC.Medications.length;i++){if("Alternative"===vm.details.ResponsePMBC.Medications[i].MedicationAlternativeType)return!0;if("AlternativeSubstitute"===vm.details.ResponsePMBC.Medications[i].MedicationAlternativeType)return!0}if(vm.details.ResponseRFS&&vm.details.ResponseRFS.Medications)for(i=0;i<vm.details.ResponseRFS.Medications.length;i++){if("Alternative"===vm.details.ResponseRFS.Medications[i].MedicationAlternativeType)return!0;if("AlternativeSubstitute"===vm.details.ResponseRFS.Medications[i].MedicationAlternativeType)return!0}return!1}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterPmbcMedication",{templateUrl:"/sigwriter/component-views/pmbcMedication.html",bindings:{med:"<",showDrugIcons:"<",select:"&"},controller:["$sce",function($sce){var vm=this;vm.$sce=$sce,vm.onSelect=function(pricingCoverage){vm.select({med:vm.med,pricingCoverage:pricingCoverage})}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterRfsMedication",{templateUrl:"/sigwriter/component-views/rfsMedication.html",bindings:{med:"<",showDrugIcons:"<",select:"&"},controller:["$sce","aprgettext",function($sce,gettext){var vm=this;vm.$sce=$sce,vm.formatRestrictions=function(restrictions){if(restrictions){var restrictionCodes=restrictions.split("|");return _.map(restrictionCodes,function(restrictionCode){switch(restrictionCode){case"DE":return gettext("Product Coverage Exclusion");case"PA":return gettext("Prior Authorization");case"MN":return gettext("Medical Necessity");case"ST":return gettext("Step Therapy");case"GL":return gettext("Gender Limit");case"AL":return gettext("Age Limit");case"QL":return gettext("Quantity Limit");case"SM":return gettext("Step Medication")}}).reduce(function(formatted,value){return value&&(formatted&&(formatted+=", "),formatted+=value),formatted},"")}},vm.onSelect=function(){vm.select({med:vm.med})}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("rxFormularyDetails",{templateUrl:"/sigwriter/component-views/rxFormularyDetails.html",controller:["$rootScope","Bridge","$timeout","$sce","$window",function($rootScope,Bridge,$timeout,$sce,$window){var vm=this;function processDetails(detailData){detailData?(vm.details=detailData,vm.details.ResponsePMBC&&vm.details.ResponsePMBC.Medications&&vm.details.ResponsePMBC.Medications.forEach(function(med){med.ShowDetails="Alternative"!==med.MedicationAlternativeType}),vm.details.ResponseRFS&&vm.details.ResponseRFS.Medications&&vm.details.ResponseRFS.Medications.forEach(function(med){med.ShowDetails="Alternative"!==med.MedicationAlternativeType}),vm.$scope.removeHttpError()):vm.$scope.addHttpError({}),vm.loading=!1}function processMedicationChange(){$window.close()}function timeOut(){vm.loading&&(vm.$scope.addHttpError({},"The server is taking longer than anticipated to respond to the data request. The request may have failed."),vm.loading=!1)}vm.$sce=$sce,vm.$scope=$rootScope.$new(),$rootScope.setupDirectiveScope(vm.$scope),vm.changeMedication=function(med,pricingCoverage){Bridge.fireEvent("formulary-details-change-medication",{MedId:med.MedId,PharmacyId:pricingCoverage&&pricingCoverage.PharmacyId})},vm.$onInit=function(){Bridge.on("formulary-details-response",vm.$scope,processDetails),Bridge.on("formulary-details-medication-changed",vm.$scope,processMedicationChange),vm.loading=!1,vm.loaded||(vm.loading=!0,vm.loaded=!0,Bridge.fireEvent("formulary-details-request",{}),$timeout(timeOut,5e3))}}]})}(),function(angular){"use strict";angular.module("aprima-sigwriter").component("sigwriterTabletAdditionalInfo",{templateUrl:"/sigwriter/component-views/tabletAdditionalInfo.html",bindings:{sigOptionsNonFormulary:"<",showAdditionalInfoModal:"&"},controller:["aprgettext",function(gettext){var vm=this;vm.getTitle=function(){var title;if(vm.sigOptionsNonFormulary.isAdministered)title="Administered";else{if(!vm.sigOptionsNonFormulary.isSampleGiven)return;title="Sample Given"}return gettext(title)},vm.showDetails=function(){vm.showAdditionalInfoModal()}}]})}(angular),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletDirections",{templateUrl:"/sigwriter/component-views/tabletDirections.html",bindings:{form:"<",hostedFromDesktop:"<",patientDetails:"<",rxOptions:"<",rxParameters:"<",sigFormulary:"<",sigInstruction:"<",sigOptions:"<",sigOptionsNonFormulary:"<",setDrugFromSearchResult:"&",updateSigInstruction:"&",updateSigOptions:"&",updateSigOptionsNonFormulary:"&"},controller:["_","CurrentUser","DosingService","DrugConsentModal","DrugDosingModal","GeneralNotesModal","GeneralNoteTypeKeys","SigwriterDrugDosageSearchModal","SigWriterRepository","SigwriterRxService","SigwriterSigDetailsModal","StrConvert",function(_,CurrentUser,DosingService,DrugConsentModal,DrugDosingModal,GeneralNotesModal,GeneralNoteTypeKeys,SigwriterDrugDosageSearchModal,SigWriterRepository,SigwriterRxService,SigwriterSigDetailsModal,StrConvert){var vm=this,oneTimeOverrideManual=!1;function loadCptList(medId){medId?SigWriterRepository.getDrugCptList(medId).then(function(result){vm.cptList=result,vm.cptList&&vm.updatedSigOptionsNonFormulary.procedure&&_.find(vm.cptList,function(procedure){vm.updatedSigOptionsNonFormulary.procedure.ProcedureId===procedure.ProcedureId&&(vm.updatedSigOptionsNonFormulary.procedure=procedure)}),onUpdatedSigOptionsNonFormularyChanged()}):vm.cptList=[]}function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&(vm.toggleEpaChanged=!1,vm.toggleSpoChanged=!1,vm.updatedSigOptionsNonFormulary&&null!==previousMedid&&(vm.updatedSigOptionsNonFormulary.sendPriorAuth=void 0,onUpdatedSigOptionsNonFormularyChanged()),vm.updatedSigOptionsNonFormulary&&null!==previousMedid&&(vm.updatedSigOptionsNonFormulary.procedure=null),loadCptList(currentMedid));var sigType=vm.rxParameters&&vm.rxParameters.sigType;switch(sigType){case"ChangeRx":vm.allowSearchDrugDosage=!1;break;default:vm.allowSearchDrugDosage=!0}}function onSigFormularyChanged(changeSigFormulary){changeSigFormulary.currentValue&&changeSigFormulary.currentValue.primaryMedication&&("ChangeRxFromMessage"!==vm.rxParameters.sigType?updateEpaButton(changeSigFormulary.currentValue.primaryMedication.requiresPa):updateEpaButton(changeSigFormulary.currentValue.SendPriorAuth||changeSigFormulary.currentValue.primaryMedication.requiresPa))}function onUpdatedSigInstructionChanged(){vm.updatedSigInstruction.dosage&&vm.updatedSigInstruction.frequency&&vm.updatedSigInstruction.days&&oneTimeOverrideManual&&(vm.updatedSigInstruction.isManualQuantity=!1,oneTimeOverrideManual=!1),vm.updateSigInstruction({updatedSigInstruction:vm.updatedSigInstruction}),getMinMaxWarning(),getQuantityWarning()}function onUpdatedSigOptionsChanged(){vm.updateSigOptions({updatedSigOptions:vm.updatedSigOptions}),getUomWarning()}function onUpdatedSigOptionsNonFormularyChanged(){vm.updateSigOptionsNonFormulary({updatedSigOptionsNonFormulary:vm.updatedSigOptionsNonFormulary})}function loadProviderDrugSettings(){var prescriberId=vm.updatedSigOptionsNonFormulary.prescriber&&vm.updatedSigOptionsNonFormulary.prescriber.Id;if(prescriberId){var drug=vm.rxParameters.drug,patientId=vm.rxParameters.patientId,sigType=vm.rxParameters.sigType,visitId=vm.rxParameters.visit&&vm.rxParameters.visit.VisitId;SigWriterRepository.getDrugSettings(sigType,drug,prescriberId,patientId,visitId).then(function(drugSettings){var isMaintenance=drugSettings.IsMaintenance,isHighRiskMed=drugSettings.IsHighRisk,isSpecialty=drugSettings.IsSpecialty,isSpecialtyEnabled=drugSettings.IsSpecialtyEnabled,specialtySureScriptsDownloadDateTime=drugSettings.SpecialtySureScriptsDownloadDateTime;isMaintenance&&(vm.updatedSigOptionsNonFormulary.isChronicMed=isMaintenance),isHighRiskMed&&(vm.updatedSigOptionsNonFormulary.isHighRiskMed=isHighRiskMed),vm.updatedSigOptionsNonFormulary.sendIsSpecialty=isSpecialty,vm.updatedSigOptionsNonFormulary.isSpecialtyEnabled=isSpecialtyEnabled,vm.updatedSigOptionsNonFormulary.specialtySureScriptsDownloadDateTime=specialtySureScriptsDownloadDateTime,onUpdatedSigOptionsNonFormularyChanged()})}}function loadProviderDirectionsSettings(){var prescriberId=vm.updatedSigOptionsNonFormulary.prescriber&&vm.updatedSigOptionsNonFormulary.prescriber.Id;if(prescriberId){var drug={Ndc:vm.rxParameters.drug.Ndc,RxNormCode:vm.rxParameters.drug.RxNormCode},sigType=vm.rxParameters.sigType,visitId=vm.rxParameters.visit&&vm.rxParameters.visit.VisitId;SigWriterRepository.getDirectionsSettings(drug,prescriberId,sigType,visitId,!0).then(function(directionSettings){vm.updatedSigOptionsNonFormulary.isSpecialtyEnabled=directionSettings.IsSpecialtyEnabled,null!==vm.updatedSigOptionsNonFormulary.sendIsSpecialty&&"undefined"!==vm.updatedSigOptionsNonFormulary.sendIsSpecialty||(vm.updatedSigOptionsNonFormulary.sendIsSpecialty=directionSettings.IsSpecialty),vm.updatedSigOptionsNonFormulary.specialtySureScriptsDownloadDateTime=directionSettings.SpecialtySureScriptsDownloadDateTime,onUpdatedSigOptionsNonFormularyChanged()})}}function openSigDetailsModal(initialField){SigwriterSigDetailsModal.openModal(vm.patientDetails,vm.rxOptions,vm.rxParameters,vm.sigInstruction,vm.sigOptionsNonFormulary,initialField).then(function(results){vm.updatedSigInstruction=_.merge(vm.updatedSigInstruction,results.sigInstruction),onUpdatedSigInstructionChanged()})}function shouldDisplayButtons(){return shouldDisplayConsent()||shouldDisplayEpaButton()||shouldDisplaySpecialtyButton()}function shouldDisplayConsent(){if(!vm.rxParameters.drug.RequiresConsent)return!1;switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"Hx":return!1;default:return!0}}function shouldDisplayEpaButton(){return shouldDisplaySurescriptsButton()}function shouldDisplaySpecialtyButton(){return shouldDisplaySurescriptsButton()}function shouldDisplaySurescriptsButton(){switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":case"Hx":return!1;default:return!0}}function updateEpaButton(value){vm.updatedSigOptionsNonFormulary&&!vm.toggleEpaChanged&&(vm.updatedSigOptionsNonFormulary.sendPriorAuth=value,onUpdatedSigOptionsNonFormularyChanged())}function onMedicationConsentCompleted(medicationConsent){vm.updatedSigOptionsNonFormulary.MedicationConsent=medicationConsent,onUpdatedSigOptionsNonFormularyChanged()}function getQuantityWarning(){"Hx"!==vm.rxParameters.sigType&&"CppMedication"!==vm.rxParameters.sigType&&"DefaultSig"!==vm.rxParameters.sigType&&(vm.updatedSigInstruction.quantity?removeWarning(null,"quantityWarning"):addOrReplaceWarning("Quantity is missing; cannot be e-prescribed.","quantityWarning"))}function getUomWarning(){if("CppMedication"!==vm.rxParameters.sigType&&"DefaultSig"!==vm.rxParameters.sigType)if(!vm.updatedSigOptions||vm.updatedSigOptions.uom&&!vm.updatedSigOptions.uom.inactive||!vm.updatedSigOptions.previousUom)vm.rxParameters.drug&&vm.rxParameters.drug.DefaultUnitName&&vm.rxParameters.drug.DefaultUnitOfMeasureId&&vm.updatedSigOptions.uom&&vm.rxParameters.drug.DefaultUnitOfMeasureId!==vm.updatedSigOptions.uom.Id?addOrReplaceWarning("Selected Quantity UOM "+vm.updatedSigOptions.uom.Name+" does not match default "+vm.rxParameters.drug.DefaultUnitName+".","uomWarning"):removeWarning(null,"uomWarning");else{var previousUom=vm.updatedSigOptions.previousUom&&vm.updatedSigOptions.previousUom.Name,previousMessage=previousUom&&"Invalid Quantity UOM: "+previousUom+";",standardFormMessage=vm.rxParameters.drug.DefaultUnitName&&" Standard: "+vm.rxParameters.drug.DefaultUnitName+" ";addOrReplaceWarning("Medication Unit of Measure is unspecified. ("+previousMessage+standardFormMessage+")","uomWarning")}}function getMinMaxWarning(){"CppMedication"!==vm.rxParameters.sigType&&"DefaultSig"!==vm.rxParameters.sigType&&DosingService.getMinMaxWarning(vm.updatedSigInstruction,vm.rxParameters,vm.patientDetails).then(function(minMaxWarningText){minMaxWarningText?addOrReplaceWarning(minMaxWarningText,"minMaxWarning"):removeWarning(null,"minMaxWarning")}).catch(function(response){removeWarning(null,"minMaxWarning"),console.log(response)})}function getDefaultDxWarning(){vm.rxParameters&&vm.updatedSigOptionsNonFormulary&&"Hx"!==vm.rxParameters.sigType&&"CppMedication"!==vm.rxParameters.sigType&&"DefaultSig"!==vm.rxParameters.sigType&&(vm.updatedSigOptionsNonFormulary.defaultDxIsSelected?addOrReplaceWarning("Default Diagnosis Selected.","defaultDxWarning"):removeWarning(null,"defaultDxWarning"))}function removeWarning(warning,key){key&&vm.warnings[key]&&(vm.warnings[key]=void 0)}function addOrReplaceWarning(message,key){var exist;if(message=StrConvert.replaceNewLine(message),key&&(exist=vm.warnings[key])&&exist.message!==message&&(removeWarning(exist,key),exist=null),!exist)return function(message,key){key&&(message=StrConvert.replaceNewLine(message),vm.warnings[key]=message)}(message,key)}vm.parentContainerId="sigwriter-content-column",vm.updatedSigInstruction=null,vm.updatedSigOptions=null,vm.updatedSigOptionsNonFormulary=null,vm.warnings={},vm.repeatSigOptions=[{value:0,label:"0"},{value:1,label:"x1"},{value:2,label:"x2"}],vm.repeatSigSelection=vm.repeatSigOptions[0],vm.$onChanges=function(changes){changes.sigInstruction&&changes.sigInstruction.currentValue&&(changesSigInstructions=changes.sigInstruction,vm.updatedSigInstruction=_.merge(vm.updatedSigInstruction,changesSigInstructions.currentValue));var changesSigInstructions;changes.sigFormulary&&changes.sigFormulary.currentValue&&onSigFormularyChanged(changes.sigFormulary);changes.sigOptions&&changes.sigOptions.currentValue&&(changesSigOptions=changes.sigOptions,vm.updatedSigOptions=_.merge(vm.updatedSigOptions,changesSigOptions.currentValue));var changesSigOptions;changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&(changesSigOptionsNonFormulary=changes.sigOptionsNonFormulary,vm.updatedSigOptionsNonFormulary=_.merge(vm.updatedSigOptionsNonFormulary,changesSigOptionsNonFormulary.currentValue));var changesSigOptionsNonFormulary;changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters);getDefaultDxWarning()},vm.allowSearchDrugDosage=!0,vm.editAction=function(){openSigDetailsModal("action")},vm.editDays=function(){openSigDetailsModal("days")},vm.editDosage=function(){openSigDetailsModal("dosage")},vm.editFrequency=function(){openSigDetailsModal("frequency")},vm.editPrn=function(){openSigDetailsModal("prn")},vm.editRefills=function(){openSigDetailsModal("refills")},vm.editRoute=function(){openSigDetailsModal("route")},vm.editUnit=function(){openSigDetailsModal("unit")},vm.getButtonsColumnClass=function(){return shouldDisplayButtons()?"col-xs-4":"ng-hide"},vm.getCheckboxesColumnClass=function(){return shouldDisplayButtons()?"col-xs-8":"col-xs-12"},vm.getMinMaxWarning=getMinMaxWarning,vm.getQuantityWarning=getQuantityWarning,vm.getRemainingSigCharacters=function(){var remainingCharacters=SigwriterRxService.getRemainingSigCharacters(vm.updatedSigInstruction,vm.updatedSigOptions&&vm.updatedSigOptions.pharmacy&&vm.updatedSigOptions.pharmacy.MasterPharmacy&&vm.updatedSigOptions.pharmacy.MasterPharmacy.SigDirectionsMaxLength);remainingCharacters<0?addOrReplaceWarning("Directions has exceeded the maximum character length for ePrescribing.","sigDirectionsMaxLengthWarning"):removeWarning(null,"sigDirectionsMaxLengthWarning");return remainingCharacters},vm.getRemainingPharmacyInstructionsCharacters=function(){return SigwriterRxService.getRemainingPharmacyInstructionsCharacters(vm.updatedSigOptionsNonFormulary.pharmacyInstructions)},vm.getRemainingInternalNoteCharacters=function(){return SigwriterRxService.getRemainingInternalNoteCharacters(vm.updatedSigOptionsNonFormulary.internalNote)},vm.getDefaultDxWarning=getDefaultDxWarning,vm.isDaysValid=function(){return SigwriterRxService.isDaysValid(vm.updatedSigInstruction)},vm.isDirectionsValid=function(){return vm.updatedSigInstruction.sigString||vm.updatedSigInstruction.days||vm.updatedSigInstruction.refills},vm.isPharmacyInstructionsValid=function(){if(!SigwriterRxService.isDxInPharmacyInstructions(vm.updatedSigOptionsNonFormulary.pharmacyInstructions))return removeWarning(null,"pharmacyInstructionsWarning"),!0;var isValid=!vm.rxOptions.additionalMedInfo.isDxInPharmacyInstructionsAnError;addOrReplaceWarning(isValid?"Dx should not be included in Pharmacy Instructions.":"Dx not allowed in Pharmacy Instructions.","pharmacyInstructionsWarning");return isValid},vm.isEndDateRequired=function(){return!!vm.updatedSigInstruction.repeatSigCount},vm.isFixedPharmacy=function(){return vm.rxParameters.isFixedPharmacy},vm.isPrescriberRequired=function(){switch(vm.rxParameters.sigType){case"Hx":case"ChangeRxFromMessage":return!1;default:return!0}},vm.isQuantityValid=function(){var quantity=vm.form.quantity.$viewValue;if(!quantity)return!0;var numDigitsAllowed=5;0===quantity.indexOf("0.")?numDigitsAllowed+=2:0<=quantity.indexOf(".")&&numDigitsAllowed++;return quantity.length<=numDigitsAllowed},vm.isStartDateRequired=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"Hx":return!1;default:return!0}},vm.onBrandMedicallyNecessaryChanged=function(){vm.updatedSigOptionsNonFormulary.bmn&&(vm.updatedSigOptionsNonFormulary.daw=!0);onUpdatedSigOptionsNonFormularyChanged(),onUpdatedSigInstructionChanged()},vm.onChangePrescriber=function(){onUpdatedSigOptionsNonFormularyChanged(),loadProviderDrugSettings()},vm.onChangeRepeatSig=function(){vm.updatedSigInstruction.repeatSigCount=vm.repeatSigSelection&&vm.repeatSigSelection.value||0,onUpdatedSigInstructionChanged()},vm.onClickDosingSuggestions=function(){DrugDosingModal.openModal(vm.rxParameters,vm.updatedSigInstruction).then(function(result){if(result.isSuccess){var dosingSuggestion=result.resultValue.suggestion;vm.updatedSigInstruction=SigwriterRxService.updateInstructionFromDosingSuggestion(vm.updatedSigInstruction,dosingSuggestion,vm.rxOptions),onUpdatedSigInstructionChanged()}})},vm.onClickPharmacyInstructions=function(){function onCommentUpdated(result){vm.updatedSigOptionsNonFormulary.pharmacyInstructions=result,onUpdatedSigOptionsNonFormularyChanged()}GeneralNotesModal.openModal("Pharmacy Instructions",vm.updatedSigOptionsNonFormulary.pharmacyInstructions,!0,vm.maxPharmacyInstructionsCharacters,GeneralNoteTypeKeys.SigPharmacyInstructions).then(onCommentUpdated)},vm.onClickInternalNote=function(){function onCommentUpdated(result){vm.updatedSigOptionsNonFormulary.internalNote=result,onUpdatedSigOptionsNonFormularyChanged()}GeneralNotesModal.openModal("Internal Note",vm.updatedSigOptionsNonFormulary.internalNote,!0,vm.maxInternalNoteCharacters,GeneralNoteTypeKeys.SigInternalNotes).then(onCommentUpdated)},vm.onClickSearchDrugDosage=function(){var providerId=vm.sigOptionsNonFormulary.prescriber&&vm.sigOptionsNonFormulary.prescriber.Id||CurrentUser.get().userId;SigwriterDrugDosageSearchModal.openModal(vm.rxParameters.sigType,vm.rxParameters.drug,vm.rxParameters.patientId,providerId).then(function(selectedDrug){vm.setDrugFromSearchResult({selectedDrug:selectedDrug})})},vm.onDispenseAsWrittenChanged=function(){vm.updatedSigOptionsNonFormulary.daw||(vm.updatedSigOptionsNonFormulary.bmn=!1);onUpdatedSigOptionsNonFormularyChanged(),onUpdatedSigInstructionChanged()},vm.onEndDateChanged=function(){vm.updatedSigInstruction.endDateChanged=!0,onUpdatedSigInstructionChanged()},vm.onIsAdministeredChanged=function(){vm.updatedSigOptionsNonFormulary.isAdministered&&(vm.updatedSigOptionsNonFormulary.isSampleGiven=!1);onUpdatedSigOptionsNonFormularyChanged()},vm.onOpenDrugConsent=function(){DrugConsentModal.openModal(vm.updatedSigOptionsNonFormulary.MedicationConsent,vm.rxParameters.drug.RxConsentFormattingTemplateName).then(onMedicationConsentCompleted)},vm.onSampleGivenChanged=function(){vm.updatedSigOptionsNonFormulary.isSampleGiven&&(vm.updatedSigOptionsNonFormulary.isAdministered=!1);onUpdatedSigOptionsNonFormularyChanged()},vm.onUpdatedSigInstructionChanged=onUpdatedSigInstructionChanged,vm.onUpdatedSigOptionsChanged=onUpdatedSigOptionsChanged,vm.onUpdatedSigOptionsNonFormularyChanged=onUpdatedSigOptionsNonFormularyChanged,vm.orderByDisplayOrder=!0,vm.removeWarning=removeWarning,vm.supervisingProviderText=vm.rxParameters&&vm.rxParameters.visit&&vm.rxParameters.visit.SupervisingProvider&&vm.rxParameters.visit.SupervisingProvider.Description,vm.shouldDisablePrescriber=function(){return vm.rxOptions.authorizedPrescribers&&1===vm.rxOptions.authorizedPrescribers.length&&"Hx"!==vm.rxParameters.sigType},vm.shouldDisplayAuthorizationCode=function(){switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":case"Hx":return!1}return!vm.sigOptionsNonFormulary.isSampleGiven},vm.shouldDisplayCptCode=function(){switch(vm.rxParameters.sigType){case"ChangeRx":case"Hx":case"RefillFromHx":case"RefillFromHxOnly":case"ChangeRxFromMessage":return!1}return!vm.sigOptionsNonFormulary.isSampleGiven},vm.shouldDisplayConsent=shouldDisplayConsent,vm.shouldDisplayDxProblems=function(){switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":return!1;default:return!0}},vm.shouldDisplayEpaButton=shouldDisplayEpaButton,vm.shouldDisplayIncludeMonograph=function(){switch(vm.rxParameters.sigType){case"EditRx":case"NewRx":case"RefillMessage":return vm.rxParameters.drug&&0<vm.rxParameters.drug.MedId;default:return!1}},vm.shouldDisplayMode=function(){switch(vm.rxParameters.sigType){case"ChangeRx":case"Hx":case"RxWorkflow":case"RefillFromHx":case"RefillFromHxOnly":case"ChangeRxFromMessage":return!1;default:return!0}},vm.shouldDisplayPharmacy=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"Hx":case"ChangeRxFromMessage":return!1}return!vm.sigOptionsNonFormulary.isAdministered&&!vm.sigOptionsNonFormulary.isSampleGiven},vm.shouldDisplayPrescriber=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"RefillMessage":case"ChangeRxFromMessage":return!1;default:return!0}},vm.shouldDisplayRepeatSig=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"Hx":case"RxWorkflow":case"ChangeRx":case"RefillMessage":case"ChangeRxFromMessage":return!1;default:return!0}},vm.shouldDisplaySpecialtyButton=shouldDisplaySpecialtyButton,vm.shouldDisplayStartEndDates=function(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":return!1}return!vm.sigOptionsNonFormulary.isAdministered},vm.shouldDisplaySupervisingProvider=function(){switch(vm.rxParameters.sigType){case"NewRx":case"EditRx":return!vm.hostedFromDesktop;default:return!1}},vm.toggleQuantityType=function(){oneTimeOverrideManual=!1,SigwriterRxService.toggleQuantityType(vm.updatedSigInstruction)&&onUpdatedSigInstructionChanged()},vm.toggleEpaButton=function(){if(!vm.updatedSigOptionsNonFormulary)return;vm.updatedSigOptionsNonFormulary.sendPriorAuth=!vm.updatedSigOptionsNonFormulary.sendPriorAuth,vm.toggleEpaChanged=!0,onUpdatedSigOptionsNonFormularyChanged()},vm.toggleEpaChanged=!1,vm.toggleSpoButton=function(){if(!vm.updatedSigOptionsNonFormulary)return;vm.updatedSigOptionsNonFormulary.sendIsSpecialty=!vm.updatedSigOptionsNonFormulary.sendIsSpecialty,vm.toggleSpoChanged=!0,onUpdatedSigOptionsNonFormularyChanged()},vm.toggleSpoChanged=!1,vm.maxPharmacyInstructionsCharacters=SigwriterRxService.getMaxPharmacyInstructionsCharacters(),vm.maxInternalNoteCharacters=SigwriterRxService.getMaxInternalNoteCharacters(),vm.dragDropPharmacySelected=function(pharmacy){vm.updatedSigOptions.pharmacy=pharmacy,onUpdatedSigOptionsChanged()},vm.$onInit=function(){"NewRx"===vm.rxParameters.sigType?loadProviderDrugSettings():"ChangeRxFromMessage"!==vm.rxParameters.sigType&&loadProviderDirectionsSettings();vm.updatedSigInstruction.dosage&&vm.updatedSigInstruction.frequency&&vm.updatedSigInstruction.days||(oneTimeOverrideManual=!0);getQuantityWarning(),getDefaultDxWarning(),getMinMaxWarning(),getUomWarning()}}]})}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletDrugScreening",{templateUrl:"/sigwriter/component-views/tabletDrugScreening.html",bindings:{drugScreening:"<",rxParameters:"<",showDetailedScreeningModal:"&",updateDrugScreening:"&",updateIsScreeningLoaded:"&"},controller:["DrugRepository","ErrorService","FncRxRepository","RxChangeRepository",function(DrugRepository,ErrorService,FncRxRepository,RxChangeRepository){var vm=this;function getSidebarClass(){var base="drug-tablet-screening-sidebar-";if(vm.loading)return base+"loading";if(vm.error)return base+"unknown";var nddScreening=vm.nddScreening;if(nddScreening){if(nddScreening.Error)return base+"unknown";switch(nddScreening.Status){case"Completed":return base+"none";case"CompletedOutOfDate":return base+"unknown";case"CompletedWithAlerts":switch(nddScreening.OverallSeverityLevel){case-1:return base+"unknown";case 10:return base+"low";case 20:return base+"moderate";case 30:return base+"high";case 40:return base+"severe"}}}return base+"unknown"}function onRxParametersChanged(){vm.loading=!0,vm.updateIsScreeningLoaded({isLoaded:!1,isOverrideRequired:!1}),(vm.rxParameters.visit&&vm.rxParameters.visit.VisitId?FncRxRepository.getSigwriterNddDrugScreeningResults(vm.rxParameters.patientId,vm.rxParameters.visit.VisitId,vm.rxParameters.drug,null):"ChangeRxFromMessage"===vm.rxParameters.sigType?performChangeRxFromMessageScreening():DrugRepository.nddDrugScreening(vm.rxParameters.patientId,vm.rxParameters.drug,vm.drugScreening.otherDrugs,vm.rxParameters.previousMedicationSigId)).then(function(results){vm.loading=!1,vm.nddScreening=results,vm.nddScreeningError=null,vm.updateDrugScreening({drugScreening:{nddScreening:vm.nddScreening,screeningResult:vm.nddScreening.PlainText}}),vm.updateIsScreeningLoaded({isLoaded:!0,isOverrideRequired:"drug-tablet-screening-sidebar-none"!==getSidebarClass()})}).catch(function(error){vm.nddScreeningError=ErrorService.convertToErrorMessages(error),vm.updateIsScreeningLoaded({isLoaded:!0,isOverrideRequired:!1})}).finally(function(){vm.loading=!1})}function performChangeRxFromMessageScreening(){if(vm.rxParameters.changeRxFromMessageDrugScreeningParams){var drugScreeningParams=vm.rxParameters.changeRxFromMessageDrugScreeningParams;return drugScreeningParams.medicationParams.forEach(function(param){param.IsSelectedMedication&&(param.MedId=vm.rxParameters.drug.MedId)}),RxChangeRepository.nddDrugScreeningByMedIds(drugScreeningParams.messageId,vm.rxParameters.patientId,drugScreeningParams.providerId,drugScreeningParams.medicationParams)}return DrugRepository.nddDrugScreening(vm.rxParameters.patientId,vm.rxParameters.drug,vm.drugScreening.otherDrugs,vm.rxParameters.previousMedicationSigId)}vm.loading=!1,vm.nddScreening=null,vm.nddScreeningError=null,vm.$onChanges=function(changes){changes.rxParameters&&onRxParametersChanged(changes.rxParameters)},vm.getSidebarClass=getSidebarClass,vm.showDetails=function(){if(vm.loading||vm.nddScreeningError)return;vm.showDetailedScreeningModal()}}]})}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletFormularyAlternatives",{templateUrl:"/sigwriter/component-views/tabletFormularyAlternatives.html",bindings:{relVisitMedicationId:"<",rxParameters:"<",sigFormulary:"<",sigInstruction:"<",sigOptions:"<",sigOptionsNonFormulary:"<",suppressEligibilityExpiredMessageOnInit:"<",onDrugSelected:"&",updateSigFormulary:"&",updateIsAvailable:"&",updateRelVisitMedicationId:"&",updateSigOptions:"&"},controller:["$rootScope","$sce","$scope","$document","debounce","DrugRepository","aprgettext","moment","PatientRepository","SigwriterRxService","SigwriterFormularyDetailsModal","SigwriterRxBenefitDetailsModal","toaster",function($rootScope,$sce,$scope,$document,debounce,DrugRepository,gettext,moment,PatientRepository,SigwriterRxService,SigwriterFormularyDetailsModal,SigwriterRxBenefitDetailsModal,toaster){var initialFormularyLoadPromise,vm=this,debouncedRefreshFormularyData=debounce(1e3,refreshFormularyData),defaultedERxEligibility=!1;function onERxEligibilityChanged(){vm.eRxEligibility&&vm.eRxEligibility.PatienteRxElgibilityUid?(vm.options.eRxEligibility=_.cloneDeep(vm.eRxEligibility),vm.eRxEligibility.IsExpired&&function(){if(vm.loadingERxEligibilitiesOnInit&&vm.suppressEligibilityExpiredMessageOnInit)return;toaster.pop("warning","",gettext("The patient's coverage has not been downloaded recently and may be out of date"))}()):vm.options.eRxEligibility=null,vm.updateSigOptions({sigOptions:vm.options})}function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&(initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData())}function onSigInstructionsChanged(){initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData()}function onSigOptionsChanged(changesSigOptions){vm.options=_.merge(vm.options,changesSigOptions.currentValue),initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData(),!defaultedERxEligibility&&vm.eRxEligibilities&&setDefaultERxEligibility()}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){var previousDaw=changesSigOptionsNonFormulary.previousValue?changesSigOptionsNonFormulary.previousValue.daw:null,currentDaw=changesSigOptionsNonFormulary.currentValue?changesSigOptionsNonFormulary.currentValue.daw:null;previousDaw!==currentDaw&&updatePrimaryMedication();var previousPrescriberId=changesSigOptionsNonFormulary.previousValue?changesSigOptionsNonFormulary.previousValue.prescriber:null;previousPrescriberId&&(previousPrescriberId=previousPrescriberId.Id);var currentPrescriberId=changesSigOptionsNonFormulary.currentValue?changesSigOptionsNonFormulary.currentValue.prescriber:null;currentPrescriberId&&(currentPrescriberId=currentPrescriberId.Id),previousPrescriberId!==currentPrescriberId&&(console.log("onSigOptionsNonFormularyChanged: (previousPrescriberId ("+previousPrescriberId+") !== currentPrescriberId ("+currentPrescriberId+").  Calling refreshFormularyData."),vm.details=null,refreshFormularyData())}function refreshFormularyData(){if(vm.sigOptions&&vm.sigInstruction&&!vm.loadingERxEligibilities)if(!vm.eRxEligibilities||vm.eRxEligibilities.length){var medId=vm.rxParameters.drug.MedId,eRxEligibilityId=vm.sigOptions.eRxEligibility?vm.sigOptions.eRxEligibility.PatienteRxElgibilityUid:null;medId<=0||!eRxEligibilityId?vm.updateIsAvailable({isAvailable:!1}):(vm.loading=!0,vm.updateIsAvailable({isAvailable:null}),DrugRepository.getDrugRepresentativeFormularies(medId,eRxEligibilityId,vm.rxParameters.patientId,vm.relVisitMedicationId,vm.sigOptions.pharmacy?vm.sigOptions.pharmacy.Id:null,vm.sigInstruction.days?parseInt(vm.sigInstruction.days.Name):null,vm.sigOptionsNonFormulary.daw,vm.sigInstruction.quantity,vm.sigOptions.uom?vm.sigOptions.uom.Id:null,vm.details&&vm.details.ResponsePMBC.Parameters,vm.details&&vm.details.ResponseRFS.Parameters,vm.sigOptionsNonFormulary.prescriber?vm.sigOptionsNonFormulary.prescriber.Id:null).then(refreshFormularyDataSuccessful).catch(function(err){vm.$scope.addHttpError(err),vm.loading=!1,vm.updateIsAvailable({isAvailable:!0})}))}else vm.updateIsAvailable({isAvailable:!0})}function refreshFormularyDataSuccessful(data){switch(vm.relVisitMedicationId||vm.updateRelVisitMedicationId({relVisitMedicationId:data.RelVisitMedicationId}),vm.details||(vm.details={}),data.Details.ResponsePMBC.Status){case"unchanged":break;default:vm.details.ResponsePMBC=data.Details.ResponsePMBC}switch(data.Details.ResponseRFS.Status){case"unchanged":break;default:vm.details.ResponseRFS=data.Details.ResponseRFS}switch(data.Details.ResponseRTPS.Status){case"unchanged":break;default:vm.details.ResponseRTPS=data.Details.ResponseRTPS}vm.updateIsAvailable({isAvailable:!0}),vm.loading=!1,vm.$scope.removeHttpError(),updatePrimaryMedication()}function setDefaultERxEligibility(forceUpdate){defaultedERxEligibility=!0;var defaultEligibility=function(){var defaultEligibility=_.find(vm.eRxEligibilities,{IsMainAccountEligibility:!0});!defaultEligibility&&vm.eRxEligibilities&&0<vm.eRxEligibilities.length&&(defaultEligibility=vm.eRxEligibilities[0]);return defaultEligibility||null}();defaultEligibility!==vm.eRxEligibility?(vm.eRxEligibility=defaultEligibility,onERxEligibilityChanged()):forceUpdate&&debouncedRefreshFormularyData()}function updatePrimaryMedication(){vm.details&&(vm.details.primaryMedication=SigwriterRxService.getPrimaryMedication(vm.details,vm.sigOptionsNonFormulary),vm.updateSigFormulary({sigFormulary:vm.details}))}vm.$sce=$sce,vm.$scope=$scope,vm.details=null,vm.eRxEligibility=null,vm.eRxEligibilities=null,vm.hideTransmitStatus=!0,vm.isInfoAvailable=!1,vm.loading=!1,vm.loadingERxEligibilities=!1,vm.loadingERxEligibilitiesOnInit=!1,vm.options=_.cloneDeep(vm.sigOptions),vm.showDrugIcons=!0,vm.$onChanges=function(changes){changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters);changes.sigInstruction&&changes.sigInstruction.currentValue&&onSigInstructionsChanged(changes.sigInstruction);changes.sigFormulary&&changes.sigFormulary.currentValue&&(changeSigFormulary=changes.sigFormulary,vm.details=changeSigFormulary.currentValue,vm.isInfoAvailable=vm.details&&vm.details.ResponsePMBC&&"completed"===vm.details.ResponsePMBC.Status||vm.details&&vm.details.ResponseRFS&&"completed"===vm.details.ResponseRFS.Status);var changeSigFormulary;changes.sigOptions&&changes.sigOptions.currentValue?onSigOptionsChanged(changes.sigOptions):changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.$onInit=function(){vm.loadingERxEligibilitiesOnInit=!0,vm.loadingERxEligibilities=!0,PatientRepository.geteRxEligibilities(vm.rxParameters.patientId).then(function(results){vm.eRxEligibilities=results,vm.options&&setDefaultERxEligibility(!0)}).finally(function(){vm.loadingERxEligibilities=!1,debouncedRefreshFormularyData.flushPending(),vm.loadingERxEligibilitiesOnInit=!1})},vm.changeMedication=function(drug,pharmacy){vm.onDrugSelected({drug:drug,pharmacy:pharmacy})},vm.downloadStatusClass=function(){var base="rx-formulary-download-status-";if(vm.loading)return base+"loading";if(vm.loadingERxEligibilities)return base+"loading";if(!vm.details)return base+"default";if(!vm.details.ResponsePMBC)return base+"default";switch(vm.details.ResponsePMBC.Status){case"processing":return base+"loading";case"insufficient":return base+"insufficient";case"error":return base+"error";case"completed":return base+"completed";case"none":case"denied":case"disposed":default:return base+"default"}},vm.formatEligibilityDate=function(){return vm.eRxEligibility?moment(vm.eRxEligibility.LastDownloadedDate).format("L")+(vm.eRxEligibility.IsExpired?" (3+ Days)":""):""},vm.formatEligibilityName=function(erxe){return erxe.Name+(erxe.HealthPlanName?" ("+erxe.HealthPlanName+")":"")},vm.isAnimating=function(elementId){if(!$document)return!1;var element=$document[0].getElementById(elementId);if(!element)return!1;if(!element.className)return!1;if(0<=element.className.indexOf("ng-animate"))return console.log(element.className),!0;return!1},vm.onERxEligibilityChanged=onERxEligibilityChanged,vm.openFormularyDetailsModal=function(){function formularyDetailsModalCompleted(results){results.chosenMedication&&vm.onDrugSelected(results.chosenMedication)}SigwriterFormularyDetailsModal.openModal(vm.details,vm.isInfoAvailable).then(formularyDetailsModalCompleted)},vm.openRxBenefitDetailsModal=function(){SigwriterRxBenefitDetailsModal.openModal(vm.eRxEligibility)},$rootScope.setupDirectiveScope(vm.$scope),vm.relVisitMedicationId||(initialFormularyLoadPromise=DrugRepository.getDrugRepresentativeFormularies(0,void 0,void 0,vm.relVisitMedicationId).then(refreshFormularyDataSuccessful).finally(function(){initialFormularyLoadPromise=null}))}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterTabletPdr",{templateUrl:"/sigwriter/component-views/tabletPdr.html",bindings:{drug:"<",patientId:"<",rxId:"<",sigType:"<"},controller:[function(){}]})}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletShell",{templateUrl:"/sigwriter/component-views/sigwriterTabletShell.html",bindings:{options:"<",canceled:"&",completed:"&"},controller:["$timeout","_","aprgettext","DeviceSettings","NewDefaultSigModal","PersistentWarningService","SigwriterAdditionalInfoModal","SigwriterDosingService","SigwriterDrugSearchService","SigWriterRepository","SigwriterRxService","SigwriterScreeningModal","toaster",function($timeout,_,gettext,DeviceSettings,NewDefaultSigModal,PersistentWarningService,SigwriterAdditionalInfoModal,SigwriterDosingService,SigwriterDrugSearchService,SigWriterRepository,SigwriterRxService,SigwriterScreeningModal,toaster){var vm=this;function activate(){switch(vm.currentRx=vm.options.rx,vm.currentInstruction=vm.currentRx.instructions[0],vm.hostedFromDesktop=vm.options.hostedFromDesktop,vm.rxOptions=vm.currentRx.rxOptions,vm.rxParameters={drug:vm.currentRx.drug,isFixedPharmacy:isFixedPharmacy(vm.currentRx.sigType),patientId:vm.currentRx.patient&&vm.currentRx.patient.Id,rxId:vm.currentRx.id,sigType:vm.currentRx.sigType,visit:vm.currentRx.visit,previousMedicationSigId:vm.currentRx.options.previousMedicationSigId,medicationSigId:vm.currentRx.options.medicationSigId},vm.patientDetails=vm.currentRx.patientDosingDetails,vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":case"EditRx":vm.disableDrugScreening=!0}switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":case"Hx":vm.disableFormulary=!0}"DefaultSig"===vm.rxParameters.sigType&&(vm.defaultSigContext=!0),"ChangeRxFromMessage"===vm.rxParameters.sigType&&(vm.rxOptions&&vm.rxOptions.initialFormularyData&&vm.rxOptions.initialFormularyData.Details&&(vm.currentRx.sigFormulary=vm.rxOptions.initialFormularyData.Details),vm.currentRx.changeRxFromMessageDrugScreeningParams&&(vm.rxParameters.changeRxFromMessageDrugScreeningParams=vm.currentRx.changeRxFromMessageDrugScreeningParams)),setDisplaySaveDefaultSig(),SigwriterDosingService.showVariableDosingErrors(vm.currentInstruction),$timeout(autoHidePdr,15e3)}function getNumberOfVisibleInfoTiles(){var numTiles=0;return(vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven)&&numTiles++,vm.disableDrugScreening||numTiles++,vm.disableFormulary||numTiles++,numTiles}function isFixedPharmacy(sigType){switch(sigType){case"ChangeRx":case"RefillMessage":return!0;default:return!1}}function shouldRequireConsent(){if(!vm.rxParameters.drug.RequiresConsent)return!1;switch(vm.rxParameters.sigType){case"ChangeRx":case"CppMedication":case"DefaultSig":case"Hx":case"RefillFromHx":case"RefillFromHxOnly":case"RefillMessage":return!1;default:return!0}}function showAdditionalInfoModal(){var additionalInfo={administeredDateTime:_.cloneDeep(vm.currentRx.optionsNonFormulary.administeredDateTime),expirationDate:_.cloneDeep(vm.currentRx.optionsNonFormulary.expirationDate),fundingSource:_.cloneDeep(vm.currentRx.optionsNonFormulary.fundingSource),initials:_.cloneDeep(vm.currentRx.optionsNonFormulary.initials),isAdministered:_.cloneDeep(vm.currentRx.optionsNonFormulary.isAdministered),isSampleGiven:_.cloneDeep(vm.currentRx.optionsNonFormulary.isSampleGiven),lotNumber:_.cloneDeep(vm.currentRx.optionsNonFormulary.lotNumber),manufacturer:_.cloneDeep(vm.currentRx.optionsNonFormulary.manufacturer),medicationSite:_.cloneDeep(vm.currentRx.optionsNonFormulary.medicationSite)};SigwriterAdditionalInfoModal.openModal(additionalInfo,vm.rxOptions).then(function(modalResult){var optionsNonFormulary=_.cloneDeep(vm.currentRx.optionsNonFormulary);modalResult.isSuccess&&(optionsNonFormulary.administeredDateTime=modalResult.resultValue.administeredDateTime?modalResult.resultValue.administeredDateTime:null,optionsNonFormulary.expirationDate=modalResult.resultValue.expirationDate?modalResult.resultValue.expirationDate:null,optionsNonFormulary.fundingSource=modalResult.resultValue.fundingSource?modalResult.resultValue.fundingSource:null,optionsNonFormulary.initials=modalResult.resultValue.initials?modalResult.resultValue.initials:null,optionsNonFormulary.lotNumber=modalResult.resultValue.lotNumber?modalResult.resultValue.lotNumber:null,optionsNonFormulary.manufacturer=modalResult.resultValue.manufacturer?modalResult.resultValue.manufacturer:null,optionsNonFormulary.medicationSite=modalResult.resultValue.medicationSite?modalResult.resultValue.medicationSite:null),updateSigOptionsNonFormulary(optionsNonFormulary)})}function showDetailedScreeningModal(){var drugScreening=vm.currentRx.drugScreening;if(vm.isScreeningLoaded&&drugScreening.nddScreening)return SigwriterScreeningModal.openModal(drugScreening.nddScreening,drugScreening.overrideText).then(function(result){updateDrugScreening({overrideText:result.overrideText}),vm.isScreeningViewed=!0})}function updateDrugScreening(drugScreening){vm.currentRx.drugScreening=_.assignIn(_.cloneDeep(vm.currentRx.drugScreening),_.cloneDeep(drugScreening))}function updateRxParameters(rxParameters){vm.rxParameters=_.assignIn(_.cloneDeep(vm.rxParameters),_.cloneDeep(rxParameters))}function updateSigInstruction(updatedSigInstruction){var source;vm.currentInstruction=_.cloneDeep((source=updatedSigInstruction,SigwriterRxService.setRxInstructions(vm.currentRx,source,!0)))}function updateSigOptions(updatedSigOptions){vm.currentRx.options=_.assignIn(_.cloneDeep(vm.currentRx.options),_.cloneDeep(updatedSigOptions))}function updateSigOptionsNonFormulary(updatedSigOptionsNonFormulary){var administeredChanged=vm.currentRx.optionsNonFormulary.isAdministered^updatedSigOptionsNonFormulary.isAdministered,shouldShowAdditionalInfoModal=!vm.currentRx.optionsNonFormulary.isAdministered&&updatedSigOptionsNonFormulary.isAdministered||!vm.currentRx.optionsNonFormulary.isSampleGiven&&updatedSigOptionsNonFormulary.isSampleGiven,clearDefaultDxIsSelected=!1;if(vm.currentRx.optionsNonFormulary.defaultDxIsSelected&&updatedSigOptionsNonFormulary)if(updatedSigOptionsNonFormulary.problems)if(vm.currentRx.optionsNonFormulary.problems.length!==updatedSigOptionsNonFormulary.problems.length)clearDefaultDxIsSelected=!0;else for(var i=0;i<vm.currentRx.optionsNonFormulary.defaultDxIsSelected;i++)vm.currentRx.optionsNonFormulary.problems[i].Icd10Code!==updatedSigOptionsNonFormulary.problems[i].Icd10Code&&(clearDefaultDxIsSelected=!0);else clearDefaultDxIsSelected=!0;vm.currentRx.optionsNonFormulary=_.assignIn(_.cloneDeep(vm.currentRx.optionsNonFormulary),_.cloneDeep(updatedSigOptionsNonFormulary)),clearDefaultDxIsSelected&&(vm.currentRx.optionsNonFormulary.defaultDxIsSelected=!1),administeredChanged&&updateSigInstruction(vm.currentInstruction),shouldShowAdditionalInfoModal&&showAdditionalInfoModal()}function validateAll(){var isValid=!0;return shouldRequireConsent()&&!vm.currentRx.optionsNonFormulary.MedicationConsent&&(toaster.pop({type:"error",title:gettext("Missing Rx Consent"),body:gettext("This drug requires medication consent before prescribing.")}),isValid=!1),vm.tabletShellForm.$valid||(toaster.error("SIG is not valid. Please correct all errors."),isValid=!1),isValid}function autoHidePdr(){vm.togglePdrModified||vm.togglePdr(!0)}function setDisplaySaveDefaultSig(){var providerDefaultSigId=null,defaultSig=vm.options.defaultSig;defaultSig&&(providerDefaultSigId=defaultSig.id),SigWriterRepository.initializeDefaultSig(SigwriterRxService.mapToSigwriterResultsDto(vm.currentRx),providerDefaultSigId).then(function(data){vm.displaySaveDefaultSIG=data.HasSavePermission}).catch(function(){vm.displaySaveDefaultSIG=!0})}vm.$onInit=function(){activate()},vm.currentInstruction=null,vm.currentRx=null,vm.disableDrugScreening=!1,vm.disableFormulary=!1,vm.displayPdr=!0,vm.displaySaveDefaultSIG=!0,vm.hostedFromDesktop=!1,vm.isSaving=!1,vm.isScreeningLoaded=!1,vm.isScreeningOverrideRequired=!1,vm.isScreeningViewed=!1,vm.rxOptions=null,vm.rxParameters=null,vm.cancel=function(){PersistentWarningService.clear(),vm.canceled()},vm.getContentColumnClass=function(){return 0<getNumberOfVisibleInfoTiles()?"col-xs-9":"col-xs-12"},vm.getInfoColumnClass=function(){var cls="sigwriter-tablet-info-column-tiles-";vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven||(cls="sigwriter-tablet-tile-hide-addl-info "+cls);var numTiles=getNumberOfVisibleInfoTiles();cls=0<numTiles?"col-xs-3 "+cls:"ng-hide "+cls;return cls+numTiles},vm.saveDefaultSig=function(){vm.saveDefaultSigLoading=!0;var defaultSig=vm.options.defaultSig,providerDefaultSigId=defaultSig&&defaultSig.id;SigWriterRepository.initializeDefaultSig(SigwriterRxService.mapToSigwriterResultsDto(vm.currentRx),providerDefaultSigId).then(function(data){if(data.CanSaveDefaultSig){var createModifyDefaultSigDto=SigwriterRxService.newCreateModifyDefaultSigDto(vm.currentRx);defaultSig&&(createModifyDefaultSigDto=SigwriterRxService.mergeDefaultSigWithCreateModifyDefaultSigDto(defaultSig,createModifyDefaultSigDto)),createModifyDefaultSigDto.Notes=data.Notes,NewDefaultSigModal.openModal(createModifyDefaultSigDto,providerDefaultSigId).then(function(isSuccess){vm.defaultSigContext&&isSuccess&&vm.canceled()})}else data.HasSavePermission?toaster.pop({type:"warning",title:gettext("Invalid Request"),body:gettext("Unable to save Default SIG, Provider does not have KDB configured."),timeout:5e3}):toaster.pop({type:"warning",title:gettext("Invalid Request"),body:gettext("Unable to save Default SIG, User does not have permission to Save Default SIG."),timeout:5e3})}).catch(function(){toaster.pop({type:"error",title:gettext("Failed Request"),body:gettext("An error occurred and we are unable to save Default SIG."),timeout:5e3})}).finally(function(){vm.saveDefaultSigLoading=!1})},vm.save=function(){{if(vm.isScreeningOverrideRequired&&!vm.isScreeningViewed)return showDetailedScreeningModal().then(function(){complete()});complete()}function complete(){if(validateAll()){vm.isSaving=!0;var sigwriterCompleted={rx:vm.currentRx},promise=vm.completed(sigwriterCompleted)||sigwriterCompleted.completedResult;promise&&promise.finally(function(){vm.isSaving=!1}),PersistentWarningService.clear()}}},vm.setCurrentRx=function(rx){updateRxParameters({drug:rx.drug,rxId:rx.id}),vm.currentRx=rx,vm.currentInstruction=vm.currentRx.instructions[0],vm.rxOptions=vm.currentRx.rxOptions},vm.setDrugFromSearchResult=function(selectedDrug){SigwriterDrugSearchService.updateRxFromDrugSearchResult(vm.currentRx,selectedDrug.drugSearchResult,selectedDrug.switchToGeneric,selectedDrug.dosingSuggestion,selectedDrug.useEnhancedDrugSearch).then(function(rx){vm.resetting=!0,$timeout(function(){vm.setCurrentRx(rx),vm.resetting=!1})})},vm.setNewDrug=function(drug,pharmacy){if(updateRxParameters({drug:drug}),SigwriterRxService.setRxDrug(vm.currentRx,drug),!vm.rxParameters.isFixedPharmacy&&pharmacy){var sigOptions={pharmacy:pharmacy};updateSigOptions(sigOptions)}},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},vm.showAdditionalInfoModal=showAdditionalInfoModal,vm.showDetailedScreeningModal=showDetailedScreeningModal,vm.togglePdr=function(forceHide){vm.togglePdrModified=!0,vm.displayPdr||forceHide?vm.displayPdr=!1:vm.displayPdr=!0},vm.updateDrugScreening=updateDrugScreening,vm.updateIsScreeningLoaded=function(isLoaded,isOverrideRequired){vm.isScreeningLoaded=isLoaded,vm.isScreeningOverrideRequired=isOverrideRequired,vm.isScreeningViewed=!1},vm.updateRelVisitMedicationId=function(relVisitMedicationId){vm.currentRx.relVisitMedicationId||(vm.currentRx.relVisitMedicationId=relVisitMedicationId)},vm.updateSigFormulary=function(updatedSigFormulary){vm.currentRx.sigFormulary=_.assignIn(_.cloneDeep(vm.currentRx.sigFormulary),_.cloneDeep(updatedSigFormulary))},vm.updateSigInstruction=updateSigInstruction,vm.updateSigOptions=updateSigOptions,vm.updateSigOptionsNonFormulary=updateSigOptionsNonFormulary}]})}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").component("sigwriterTabletSigDetails",{templateUrl:"/sigwriter/component-views/tabletSigDetails.html",bindings:{initialField:"<",patientDetails:"<",rxOptions:"<",rxParameters:"<",sigInstruction:"<",sigOptionsNonFormulary:"<",updateSigInstruction:"&"},controller:["_","DefaultSigDosingCalcModal","DosingCalcModal","SigwriterRxOptionsService","SigwriterRxService",function(_,DefaultSigDosingCalcModal,DosingCalcModal,SigwriterRxOptionsService,SigwriterRxService){var vm=this,dosingCalcSupported=DosingCalcModal.isSupported();function initializeInstruction(source){var model,instruction=_.cloneDeep(source);return instruction.days&&((model=_(vm.dayOptions).find({Id:instruction.days.Id}))&&(instruction.days=model),vm.manualDays=parseFloat(instruction.days.Name)),instruction.dosage&&((model=_(vm.dosageOptions).find({Id:instruction.dosage.Id}))&&(instruction.dosage=model),vm.manualDosage=instruction.dosage.Name),instruction.frequency&&(model=_(vm.frequencyOptions).find({Id:instruction.frequency.Id}))&&(instruction.frequency=model),instruction.prnReason&&(model=_(vm.prnReasons).find({Id:instruction.prnReason.Id}))&&(instruction.prnReason=model),instruction.refills&&((model=_(vm.refillOptions).find({Id:instruction.refills.Id}))&&(instruction.refills=model),vm.manualRefills=parseFloat(instruction.refills.Name)),instruction.route&&(model=_(vm.routeOptions).find({Id:instruction.route.Id}))&&(instruction.route=model),instruction.unit&&(model=SigwriterRxOptionsService.findUnit(instruction.unit.Id,""+instruction.unit.Name,vm.rxOptions))&&(instruction.unit=model),instruction.action&&(model=_(vm.actionOptions).find({Id:instruction.action.Id}))&&(instruction.action=model),instruction}function isVariableDosing(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":return vm.updatedSigInstruction.variableDosing&&!vm.updatedSigInstruction.variableDosing.isDisabled&&shouldDisplayDosingCalc()}return!1}function onUpdatedSigInstructionChanged(){vm.updateSigInstruction({updatedSigInstruction:vm.updatedSigInstruction})}function shouldDisplayDosingCalc(){switch(vm.rxParameters.sigType){case"CppMedication":case"DefaultSig":return dosingCalcSupported&&vm.rxParameters.drug&&vm.rxParameters.drug.GcnSeqNo;case"Hx":return!1}return dosingCalcSupported}vm.actionOptions=[],vm.dayOptions=[],vm.dosageOptions=[],vm.inputModelOptions={debounce:300},vm.frequencyOptions=[],vm.manualDays=null,vm.manualDosage=null,vm.manualRefills=null,vm.prnReasons=[],vm.refillOptions=[],vm.routeOptions=[],vm.updatedSigInstruction=null,vm.displayAbbrevFirstFrequency=!1,vm.$onInit=function(){vm.actionOptions=vm.rxOptions.lists.medicationsActions,vm.dayOptions=vm.rxOptions.lists.medicationsDays,vm.dosageOptions=vm.rxOptions.lists.medicationsDosages,vm.frequencyOptions=vm.rxOptions.lists.medicationsFrequencies,4<=vm.rxOptions.options.length&&"frequency"===vm.rxOptions.options[3].key&&(vm.displayAbbrevFirstFrequency=!!vm.rxOptions.options[3].displayNameFirst);vm.prnReasons=vm.rxOptions.lists.medicationsPrnReasons,vm.refillOptions=vm.rxOptions.lists.medicationsRefills,vm.routeOptions=vm.rxOptions.lists.medicationsRoutes,vm.updatedSigInstruction=initializeInstruction(vm.sigInstruction)},vm.isDaysValid=function(){return SigwriterRxService.isDaysValid(vm.updatedSigInstruction)},vm.isDosingCalcSupported=function(){return dosingCalcSupported},vm.isFrequencyValid=function(){return!isVariableDosing()||vm.updatedSigInstruction.frequency&&vm.updatedSigInstruction.frequency.Id},vm.isVariableDosing=isVariableDosing,vm.onClickDosingCalculator=function(){switch(vm.rxParameters.sigType){case"Hx":break;case"CppMedication":case"DefaultSig":DefaultSigDosingCalcModal.openFromSigwriter(vm.updatedSigInstruction,vm.rxParameters).then(function(result){if(vm.updatedSigInstruction.variableDosing=result.variableDosing,result.variableDosing){var dosage="variable "+result.variableDosing.unitDescription;vm.updatedSigInstruction.dosage={Name:dosage,Id:dosage}}onUpdatedSigInstructionChanged()});break;default:DosingCalcModal.openFromSigwriter(vm.updatedSigInstruction,vm.rxParameters,vm.patientDetails)}},vm.onDaysSelected=function(){vm.updatedSigInstruction.days?vm.manualDays=parseFloat(vm.updatedSigInstruction.days.Name):vm.manualDays=null;onUpdatedSigInstructionChanged()},vm.onDaysTyped=function(){vm.manualDays?vm.updatedSigInstruction.days={Name:""+vm.manualDays,Id:""+vm.manualDays}:vm.updatedSigInstruction.days=null;onUpdatedSigInstructionChanged()},vm.onDosageSelected=function(){vm.updatedSigInstruction.dosage?vm.manualDosage=parseFloat(vm.updatedSigInstruction.dosage.Id):vm.manualDosage=null;onUpdatedSigInstructionChanged()},vm.onDosageTyped=function(){vm.manualDosage?vm.updatedSigInstruction.dosage={Name:vm.manualDosage,Id:vm.manualDosage}:vm.updatedSigInstruction.dosage=null;onUpdatedSigInstructionChanged()},vm.onIsPrnChanged=function(){vm.updatedSigInstruction.isPrn||(vm.updatedSigInstruction.prnReason=null);onUpdatedSigInstructionChanged()},vm.onRefillsSelected=function(){vm.updatedSigInstruction.refills?vm.manualRefills=parseFloat(vm.updatedSigInstruction.refills.Name):vm.manualRefills=null;onUpdatedSigInstructionChanged()},vm.onRefillsTyped=function(){vm.manualRefills?vm.updatedSigInstruction.refills={Name:""+vm.manualRefills,Id:""+vm.manualRefills}:vm.updatedSigInstruction.refills=null;onUpdatedSigInstructionChanged()},vm.onUpdatedSigInstructionChanged=onUpdatedSigInstructionChanged,vm.shouldDisplayDosingCalc=shouldDisplayDosingCalc}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardDrugDescription",{templateUrl:"/sigwriter/component-views/wizardDrugDescription.html",bindings:{rxParameters:"<"},controller:[function(){}]})}(),function(angular){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardDrugSearch",{templateUrl:"/sigwriter/component-views/wizardDrugSearch.html",bindings:{deferSaving:"<",patientId:"<",usePreviousSearchText:"<",onDrugSelected:"&",onExistingSigSelected:"&",kdbParameters:"<?"},controller:["DrugConsentWarningModal","SigwriterDrugSearchService","toaster",function(DrugConsentWarningModal,SigwriterDrugSearchService,toaster){var vm=this;vm.selectDrugSearchResult=function(drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch){var validationResult=SigwriterDrugSearchService.validateDrugSearchResult(drugSearchResult,!1);if(!validationResult.success)return validationResult.consentUnsupported?DrugConsentWarningModal.openDrugConsentWarningModal(drugSearchResult.Drug.Name):toaster.error("Unknown error selecting the drug search result"),void(drugSearchResult.indicateSelected=!1);SigwriterDrugSearchService.createNewRxFromDrugSearchResult("NewRx",drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch,vm.patientId,vm.deferSaving,!1).then(function(rx){rx.relPatientMedicationId?vm.onExistingSigSelected({rx:rx}):vm.onDrugSelected({rx:rx})}).catch(function(){toaster.error("Unknown error selecting the drug search result"),drugSearchResult.indicateSelected=!1})}}]})}(angular),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardFormularyAlternativesContent",{templateUrl:"/sigwriter/component-views/wizardFormularyAlternativesContent.html",bindings:{isActiveStep:"<",relVisitMedicationId:"<",rxParameters:"<",sigFormulary:"<",sigInstruction:"<",sigOptions:"<",sigOptionsNonFormulary:"<",skipFormularyAlternatives:"<",onDrugSelected:"&",updateIsAvailable:"&",updateRelVisitMedicationId:"&",updateSigFormulary:"&",updateSigOptions:"&"},controller:["ServerInfoRepository",function(ServerInfoRepository){this.useSurescripts=ServerInfoRepository.isFeatureSupported(["SurescriptsRFSPMBC"])}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardFormularyAlternativesOriginal",{templateUrl:"/sigwriter/component-views/wizardFormularyAlternativesContentOriginal.html",bindings:{isActiveStep:"<",relVisitMedicationId:"<",rxParameters:"<",sigInstruction:"<",sigOptions:"<",onDrugSelected:"&",updateIsAvailable:"&",updateRelVisitMedicationId:"&"},controller:["$rootScope","DrugRepository",function($rootScope,DrugRepository){var vm=this;function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&(vm.loading=!0,DrugRepository.getDrugFormularyInfo(vm.rxParameters.drug.MedId,vm.rxParameters.patientId).then(function(data){vm.drugs=_.filter(data,{IsFormularyAlternative:!0}),vm.$scope.removeHttpError()}).catch(function(err){vm.$scope.addHttpError(err)}).finally(function(){vm.loading=!1,vm.updateIsAvailable({isAvailable:!0})}))}vm.$scope=null,vm.drugs=[],vm.loading=!1,vm.$onChanges=function(changes){changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters)},vm.formularySelected=function(med){vm.onDrugSelected({drug:med})},vm.$scope=$rootScope.$new(),$rootScope.setupDirectiveScope(vm.$scope)}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardFormularyAlternativesSurescripts",{templateUrl:"/sigwriter/component-views/wizardFormularyAlternativesSurescripts.html",bindings:{isActiveStep:"<",relVisitMedicationId:"<",rxParameters:"<",sigFormulary:"<",sigInstruction:"<",sigOptions:"<",sigOptionsNonFormulary:"<",skipFormularyAlternatives:"<",onDrugSelected:"&",updateIsAvailable:"&",updateRelVisitMedicationId:"&",updateSigFormulary:"&",updateSigOptions:"&"},controller:["$rootScope","$sce","$scope","debounce","DrugRepository","aprgettext","PatientRepository","SigwriterRxService","toaster",function($rootScope,$sce,$scope,debounce,DrugRepository,gettext,PatientRepository,SigwriterRxService,toaster){var initialFormularyLoadPromise,vm=this,debouncedRefreshFormularyData=debounce(1e3,function(){if(!vm.sigOptions||!vm.sigInstruction||vm.skipFormularyAlternatives||vm.loadingERxEligibilities)return;if(vm.eRxEligibilities&&!vm.eRxEligibilities.length)return void vm.updateIsAvailable({isAvailable:!0});var medId=vm.rxParameters.drug.MedId,eRxEligibilityId=vm.sigOptions.eRxEligibility?vm.sigOptions.eRxEligibility.PatienteRxElgibilityUid:null;if(medId<=0||!eRxEligibilityId)return void vm.updateIsAvailable({isAvailable:!1});vm.loading=!0,vm.updateIsAvailable({isAvailable:null}),DrugRepository.getDrugRepresentativeFormularies(medId,eRxEligibilityId,vm.rxParameters.patientId,vm.relVisitMedicationId,vm.sigOptions.pharmacy?vm.sigOptions.pharmacy.Id:null,vm.sigInstruction.days?parseInt(vm.sigInstruction.days.Name):null,vm.sigOptionsNonFormulary.daw,vm.sigInstruction.quantity,vm.sigOptions.uom?vm.sigOptions.uom.Id:null,vm.details&&vm.details.ResponsePMBC.Parameters,vm.details&&vm.details.ResponseRFS.Parameters).then(refreshFormularyDataSuccessful).catch(function(err){vm.$scope.addHttpError(err),vm.loading=!1,vm.updateIsAvailable({isAvailable:!0})})}),defaultedERxEligibility=!1,pendingShowExpiredEligibilityMessage=!1;function onERxEligibilityChanged(){vm.eRxEligibility&&vm.eRxEligibility.PatienteRxElgibilityUid?(vm.options.eRxEligibility=_.cloneDeep(vm.eRxEligibility),vm.eRxEligibility.IsExpired&&(vm.isActiveStep?showExpiredEligibilityMessage():pendingShowExpiredEligibilityMessage=!0)):vm.options.eRxEligibility=null,vm.updateSigOptions({sigOptions:vm.options})}function onIsActiveStepChanged(changesIsActiveStep){changesIsActiveStep.currentValue&&pendingShowExpiredEligibilityMessage&&showExpiredEligibilityMessage()}function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&(initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData())}function onSigInstructionsChanged(){initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData()}function onSigOptionsChanged(changesSigOptions){vm.options=_.merge(vm.options,changesSigOptions.currentValue),initialFormularyLoadPromise?initialFormularyLoadPromise.then(debouncedRefreshFormularyData):debouncedRefreshFormularyData(),!defaultedERxEligibility&&vm.eRxEligibilities&&setDefaultERxEligibility()}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){vm.optionsNonFormulary=_.merge(vm.optionsNonFormulary,changesSigOptionsNonFormulary.currentValue);var previousDaw=changesSigOptionsNonFormulary.previousValue?changesSigOptionsNonFormulary.previousValue.daw:null,currentDaw=changesSigOptionsNonFormulary.currentValue?changesSigOptionsNonFormulary.currentValue.daw:null;previousDaw!==currentDaw&&updatePrimaryMedication()}function refreshFormularyDataSuccessful(data){switch(vm.relVisitMedicationId||vm.updateRelVisitMedicationId({relVisitMedicationId:data.RelVisitMedicationId}),vm.details||(vm.details={}),data.Details.ResponsePMBC.Status){case"unchanged":break;default:vm.details.ResponsePMBC=data.Details.ResponsePMBC}switch(data.Details.ResponseRFS.Status){case"unchanged":break;default:vm.details.ResponseRFS=data.Details.ResponseRFS}switch(data.Details.ResponseRTPS.Status){case"unchanged":break;default:vm.details.ResponseRTPS=data.Details.ResponseRTPS}vm.updateIsAvailable({isAvailable:!0}),vm.loading=!1,vm.$scope.removeHttpError(),updatePrimaryMedication()}function setDefaultERxEligibility(forceUpdate){defaultedERxEligibility=!0;var defaultEligibility=function(){var defaultEligibility=_.find(vm.eRxEligibilities,{IsMainAccountEligibility:!0});!defaultEligibility&&vm.eRxEligibilities&&0<vm.eRxEligibilities.length&&(defaultEligibility=vm.eRxEligibilities[0]);return defaultEligibility||null}();defaultEligibility!==vm.eRxEligibility?(vm.eRxEligibility=defaultEligibility,onERxEligibilityChanged()):forceUpdate&&debouncedRefreshFormularyData()}function showExpiredEligibilityMessage(){pendingShowExpiredEligibilityMessage=!1,toaster.pop("warning","",gettext("The patient's coverage has not been downloaded recently and may be out of date"))}function updatePrimaryMedication(){vm.details&&(vm.details.primaryMedication=SigwriterRxService.getPrimaryMedication(vm.details,vm.sigOptionsNonFormulary),vm.updateSigFormulary({sigFormulary:vm.details}))}vm.$sce=$sce,vm.$scope=$scope,vm.details=null,vm.eRxEligibility=null,vm.eRxEligibilities=null,vm.hideTransmitStatus=!0,vm.isInfoAvailable=!1,vm.loading=!1,vm.loadingERxEligibilities=!1,vm.options=_.cloneDeep(vm.sigOptions),vm.optionsNonFormulary=_.cloneDeep(vm.sigOptionsNonFormulary),vm.showDrugIcons=!0,vm.$onChanges=function(changes){changes.isActiveStep&&onIsActiveStepChanged(changes.isActiveStep);changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters);changes.sigInstruction&&changes.sigInstruction.currentValue&&onSigInstructionsChanged(changes.sigInstruction);changes.sigFormulary&&changes.sigFormulary.currentValue&&(changeSigFormulary=changes.sigFormulary,vm.details=changeSigFormulary.currentValue,vm.isInfoAvailable=vm.details&&vm.details.ResponsePMBC&&"completed"===vm.details.ResponsePMBC.Status||vm.details&&vm.details.ResponseRFS&&"completed"===vm.details.ResponseRFS.Status);var changeSigFormulary;changes.sigOptions&&changes.sigOptions.currentValue&&onSigOptionsChanged(changes.sigOptions);changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.$onInit=function(){vm.loadingERxEligibilities=!0,PatientRepository.geteRxEligibilities(vm.rxParameters.patientId).then(function(results){vm.eRxEligibilities=results,vm.options&&setDefaultERxEligibility(!0)}).finally(function(){vm.loadingERxEligibilities=!1,debouncedRefreshFormularyData.flushPending()})},vm.changeMedication=function(drug,pharmacy){vm.onDrugSelected({drug:drug,pharmacy:pharmacy})},vm.onERxEligibilityChanged=onERxEligibilityChanged,$rootScope.setupDirectiveScope(vm.$scope),vm.relVisitMedicationId||(initialFormularyLoadPromise=DrugRepository.getDrugRepresentativeFormularies(0,void 0,void 0,vm.relVisitMedicationId).then(refreshFormularyDataSuccessful).finally(function(){initialFormularyLoadPromise=null}))}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardPdr",{templateUrl:"/sigwriter/component-views/wizardPdr.html",bindings:{drug:"<",patient:"<",rxId:"<"},controller:["$rootScope","$sce","$scope","SigwriterRxService",function($rootScope,$sce,$scope,SigwriterRxService){var vm=this;function updateDisplay(){if(vm.drug){var medId=vm.drug.MedId,ndc=vm.drug.Ndc,patientId=vm.patient&&vm.patient.Id;vm.loadingDrugDocumentation=!0,SigwriterRxService.getDrugDocumentation(medId,ndc,patientId,"HistoryRx",vm.rxId).then(function(result){vm.$scope.removeHttpError(),vm.drugDocumentation={html:$sce.trustAsResourceUrl("data:text/html;charset=utf-8; base64,"+result.Html)}}).catch(function(err){vm.$scope.addHttpError(err)}).finally(function(){vm.loadingDrugDocumentation=!1})}}vm.$scope=$scope,vm.loadingDrugDocumentation=!1,vm.$onChanges=function(changes){changes.drug&&updateDisplay()},$rootScope.setupDirectiveScope(vm.$scope)}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardReview",{templateUrl:"/sigwriter/component-views/wizardReview.html",bindings:{currentRx:"<",rxParameters:"<",sigOptions:"<",registerFormSubmitCallback:"&",updateEpcsSignature:"&",updateIsValid:"&",updateSigOptions:"&"},controller:["$scope","$timeout","aprgettext","CurrentUser","SettingRepository","toaster",function($scope,$timeout,gettext,CurrentUser,SettingRepository,toaster){var formWatcherCleanupFn,formValidWatcherCleanupFn,vm=this,epcsEnabled=!1;function isControlledSubstance(){return vm.rxParameters.drug&&"0"!==vm.rxParameters.drug.FederalDeaClassCode}function isDeferredRx(){return vm.rxParameters.isDeferredRx}function isEpcsPharmacy(){var masterPharmacy=vm.currentRx&&vm.currentRx.options&&vm.currentRx.options.pharmacy&&vm.currentRx.options.pharmacy.MasterPharmacy;return masterPharmacy&&masterPharmacy.IsEpcsPharmacy}function isERxPharmacy(){var masterPharmacy=vm.currentRx&&vm.currentRx.options&&vm.currentRx.options.pharmacy&&vm.currentRx.options.pharmacy.MasterPharmacy;return masterPharmacy&&masterPharmacy.ConfiguredForEPrescribing}function onFormChanged(newValue,oldValue){formValidWatcherCleanupFn&&newValue===oldValue||(formValidWatcherCleanupFn?formValidWatcherCleanupFn():vm.registerFormSubmitCallback({callbackFn:submit}),formValidWatcherCleanupFn=$scope.$watch("$ctrl.epcsForm.$valid",onFormValidChanged),vm.epcsForm&&$timeout(function(){onFormValidChanged(vm.epcsForm.$valid)},0))}function onFormValidChanged(newValue,oldValue){newValue!==oldValue&&verifyPrescription(!1)}function submit(){verifyPrescription(!0)&&vm.updateEpcsSignature({epcsSignature:function(){if(vm.user.epcsModel){var loggedOnUser=(vm.user.epcsModel.loggedOnUser||"").split("\\");return{LoggedOnUserDomain:loggedOnUser[0],LoggedOnUserName:loggedOnUser[1],LoggedOnUserWorkstation:vm.user.epcsModel.loggedOnDevice,PinType:vm.user.epcsModel.pinType||"hid",OtpPinCode:vm.user.epcsModel.otpPinCode,OtpPassword:vm.user.epcsModel.otpPassword}}return null}()}),vm.epcsForm.$setSubmitted(!0),vm.epcsForm.isSubmitted=!0}function verifyPrescription(showToasters){var valid=!0;return vm.currentRx?(angular.forEach(vm.currentRx.instructions,function(instruction){instruction.quantity||(showToasters&&toaster.pop("error","",gettext("Quantity required. Please go back and enter a quantity before submitting.")),valid=!1)}),vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven||isDeferredRx()||(vm.currentRx&&vm.currentRx.options&&vm.currentRx.options.pharmacy&&vm.currentRx.options.pharmacy.Id?isERxPharmacy()?isControlledSubstance()&&!isEpcsPharmacy()&&(showToasters&&toaster.pop("error","",gettext("EPCS Pharmacy required. Please go back and select a pharmacy configured for EPCS before submitting.")),valid=!1):(showToasters&&toaster.pop("error","",gettext("ERx Pharmacy required. Please go back and select a pharmacy configured for ERx before submitting.")),valid=!1):(showToasters&&toaster.pop("error","",gettext("Pharmacy required. Please go back and select a pharmacy before submitting.")),valid=!1))):valid=!1,vm.epcsForm?vm.epcsForm.$valid||(showToasters&&toaster.pop("error","",gettext("Signature required.")),valid=!1):valid=!1,vm.updateIsValid({isValid:valid}),valid}vm.options=_.cloneDeep(vm.sigOptions),vm.user=null,vm.$onChanges=function(changes){changes.sigOptions&&changes.sigOptions.currentValue&&(changesSigOptions=changes.sigOptions,vm.options=_.merge(vm.options,changesSigOptions.currentValue));var changesSigOptions},vm.$onDestroy=function(){formWatcherCleanupFn&&formWatcherCleanupFn();formValidWatcherCleanupFn&&formValidWatcherCleanupFn()},vm.$onInit=function(){formWatcherCleanupFn=$scope.$watch("$ctrl.epcsForm",onFormChanged)},vm.needsEpcs=function(){return!isDeferredRx()&&isControlledSubstance()&&epcsEnabled&&isERxPharmacy()&&isEpcsPharmacy()},vm.onOptionsChanged=function(){vm.updateSigOptions({sigOptions:vm.options})},vm.user=CurrentUser.get(),SettingRepository.getProviderEpcsSettings(vm.user.userId).then(function(data){epcsEnabled=data&&data.IsEpcsEnabled})}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardScreeningContent",{templateUrl:"/sigwriter/component-views/wizardScreeningContent.html",bindings:{rxParameters:"<",updateIsScreeningLoaded:"&",updateDrugScreening:"&",visitScreeningParameters:"<"},controller:["ServerInfoRepository","SigwriterRxService","FncRxRepository",function(ServerInfoRepository,SigwriterRxService,FncRxRepository){var vm=this;function onRxParametersChanged(changesRxParameters){var previousMedid=changesRxParameters.previousValue&&changesRxParameters.previousValue.drug?changesRxParameters.previousValue.drug.MedId:null,currentMedid=changesRxParameters.currentValue.drug?changesRxParameters.currentValue.drug.MedId:null;previousMedid!==currentMedid&&performScreening()}function performScreening(){vm.v18Screening||(vm.v18Screening=ServerInfoRepository.isFeatureSupported("V18_DrugScreening")),vm.loadingDrugScreening=!0,vm.updateIsScreeningLoaded({isLoaded:!1});(vm.v18Screening?vm.visitScreeningParameters?FncRxRepository.getNddDrugScreeningResults(vm.visitScreeningParameters.patientId,vm.visitScreeningParameters.visitId):SigwriterRxService.getNddDrugScreeningResults(vm.rxParameters.patientId,vm.rxParameters.drug.MedId,vm.rxParameters.rxId):vm.visitScreeningParameters?FncRxRepository.getDrugScreeningResults(vm.visitScreeningParameters.patientId,vm.visitScreeningParameters.visitId):SigwriterRxService.getDrugScreeningResults(vm.rxParameters.patientId,vm.rxParameters.drug.MedId,vm.rxParameters.rxId)).then(function(results){var overrideRequired=!1,status="yellow";vm.screening=results,"Completed"===vm.screening.Status?(vm.drugScreeningMode="redirecting",overrideRequired=!1,status="green"):"CompletedWithAlerts"===vm.screening.Status?(vm.drugScreeningMode="display",overrideRequired=!0):"CompletedOutOfDate"===vm.screening.Status?(vm.drugScreeningMode="outofdate",overrideRequired=!0):vm.drugScreeningMode="unknown",vm.updateDrugScreening({drugScreening:{screeningResult:vm.screening.PlainText}}),vm.updateIsScreeningLoaded({isLoaded:!0,isOverrideRequired:overrideRequired,status:status})}).finally(function(){vm.loadingDrugScreening=!1})}vm.drugScreeningMode=null,vm.loadingDrugScreening=!1,vm.screening=null,vm.v18Screening=!1,vm.$onChanges=function(changes){changes.rxParameters&&changes.rxParameters.currentValue&&onRxParametersChanged(changes.rxParameters)},vm.$onInit=function(){vm.visitScreeningParameters&&performScreening()}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardScreeningOverride",{templateUrl:"/sigwriter/component-views/wizardScreeningOverride.html",bindings:{drugScreening:"<",updateDrugScreening:"&"},controller:["$q","ListService","LocalStorageRepository",function($q,ListService,LocalStorageRepository){var vm=this;function loadDrugScreeningOverrideReasons(){var medOverrideGeneralNoteTypeId=LocalStorageRepository.getMedicationOverrideGeneralNoteTypeId();return medOverrideGeneralNoteTypeId?ListService.getList("generalnotes/"+medOverrideGeneralNoteTypeId):$q.when([])}function onOverrideTextChanged(){vm.updateDrugScreening({drugScreening:{overrideText:vm.overrideText}})}function onDrugScreeningChanged(changesDrugScreening){vm.overrideText!==changesDrugScreening.currentValue.overrideText&&(vm.overrideText=changesDrugScreening.currentValue.overrideText)}vm.drugScreeningOverrides=null,vm.overrideText="",vm.selectedOverrideReason=null,vm.$onChanges=function(changes){changes.drugScreening&&changes.drugScreening.currentValue&&onDrugScreeningChanged(changes.drugScreening)},vm.onOverrideTextChanged=onOverrideTextChanged,vm.overrideSelected=function(){var changed=!1;vm.overrideText&&(vm.overrideText+="\r\n",changed=!0);vm.selectedOverrideReason&&(vm.overrideText+=vm.selectedOverrideReason,changed=!0);changed&&onOverrideTextChanged()},loadDrugScreeningOverrideReasons().then(function(reasons){vm.drugScreeningOverrides=reasons})}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardShell",{templateUrl:"/sigwriter/component-views/sigwriterWizardShell.html",bindings:{options:"<",completed:"&"},controller:["$anchorScroll","$scope","$timeout","aprgettext","RequiredScreensModal","SaveRxModal","SigwriterDosingService","SigwriterRxService","toaster","VisitRepository","WizardHandler",function($anchorScroll,$scope,$timeout,gettext,RequiredScreensModal,SaveRxModal,SigwriterDosingService,SigwriterRxService,toaster,VisitRepository,WizardHandler){var formSubmitCallbackFns,vm=this;function canAdvanceFromCurrentStep(){var stepTitle=getCurrentStepTitle();return stepTitle===vm.titles.sigInstructions?vm.isSigInstructionsValid:stepTitle===vm.titles.sigOptions?vm.isSigOptionsValid:stepTitle!==vm.titles.summary||vm.isSummaryValid}function cloneCurrentRx(){vm.currentRxClone=_.cloneDeep(vm.currentRx)}function convertStepTitleToId(stepTitle){return stepTitle.replace(/ /g,"-")+"-top"}function getCurrentStepTitle(){var wizard=getWizard();if(wizard){var currentStep=wizard.currentStep();if(currentStep)return currentStep.wzTitle}}function getWizard(){return WizardHandler.wizard(vm.wizardName)}function isStepBehindCurrentStep(stepNumber){var currentStepNumber=getWizard().currentStepNumber();return stepNumber<=currentStepNumber}function onStepChanged(){var currentStepTitle=getCurrentStepTitle();currentStepTitle===vm.titles.drugScreening&&vm.isScreeningLoaded?vm.isScreeningViewed=!0:currentStepTitle===vm.titles.formularyAlternatives?(vm.isFormularyAvailable&&(vm.hasEverViewedFormulary=!0,vm.isFormularyViewed=!0),console.log("stepChanged: formulary, isFormularyAvailable: "+vm.isFormularyAvailable+", isFormularyViewed: "+vm.isFormularyViewed+", hasEverViewedFormulary: "+vm.hasEverViewedFormulary)):currentStepTitle===vm.titles.summary&&verifyReviewedRequiredScreens(),$timeout(function(){$anchorScroll(convertStepTitleToId(currentStepTitle))},0)}function setRxInstructions(source){return SigwriterRxService.setRxInstructions(vm.currentRx,source)}function shouldSkipFormularyAlternatives(){return vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven}function submitCurrentStep(){var stepTitle=getCurrentStepTitle(),callbackFn=formSubmitCallbackFns[stepTitle];callbackFn&&callbackFn()}function updateRxParameters(rxParameters){vm.rxParameters=_.assignIn(_.cloneDeep(vm.rxParameters),_.cloneDeep(rxParameters))}function updateSigOptions(sigOptions){vm.currentRx.options=_.assignIn(_.cloneDeep(vm.currentRx.options),_.cloneDeep(sigOptions)),cloneCurrentRx()}function verifyReviewedRequiredScreens(){var unviewedScreens=[];return vm.hasEverViewedFormulary||vm.skipFormularyAlternatives||unviewedScreens.push(vm.titles.formularyAlternatives),vm.isScreeningViewed||unviewedScreens.push(vm.titles.drugScreening),unviewedScreens.length?RequiredScreensModal.openModal(unviewedScreens).then(function(stepTitle){getWizard().goTo(stepTitle)}):null}vm.currentInstruction=null,vm.currentRx=null,vm.currentRxClone=null,vm.disableSigDates=!1,vm.enableMedicationTypeSelection=!1,vm.hasEverViewedFormulary=!1,vm.isFormularyAvailable=null,vm.isFormularyViewed=!1,vm.isOverrideRequired=!1,vm.isScreeningLoaded=!1,vm.isScreeningViewed=!1,vm.isSigInstructionsValid=null,vm.isSigOptionsValid=null,vm.isSummaryValid=!1,vm.rxOptions=null,vm.rxParameters=null,vm.screeningStatus="black",vm.skipFormularyAlternatives=!1,vm.titles={drugScreening:gettext("Drug Screening"),formularyAlternatives:gettext("Formulary Alternatives"),screeningOverride:gettext("Override"),sigInstructions:gettext("SIG Instructions"),sigOptions:gettext("SIG Options"),summary:gettext("Summary")},vm.wizardName="sigwriterWizardShell",vm.applyDosingSuggestion=function(suggestion,instructionId){var instructions=SigwriterRxService.newRxInstructions(vm.currentRx);(instructions=SigwriterRxService.updateInstructionFromDosingSuggestion(instructions,suggestion,vm.currentRx.rxOptions)).id=instructionId;var newInstruction=setRxInstructions(instructions);vm.currentInstruction.id===newInstruction.id&&(vm.currentInstruction=newInstruction)},vm.canAdvanceFromCurrentStep=canAdvanceFromCurrentStep,vm.convertStepTitleToId=convertStepTitleToId,vm.getCurrentStepTitle=getCurrentStepTitle,vm.getStepIconClass=function(step){switch(step.wzTitle){case vm.titles.drugScreening:return"ap-sigwizard-screening-"+vm.screeningStatus;case vm.titles.formularyAlternatives:return vm.isFormularyViewed?"ap-sigwizard-formulary-green":null===vm.isFormularyAvailable?"ap-sigwizard-formulary-black":vm.isFormularyAvailable?"ap-sigwizard-formulary-yellow":"ap-sigwizard-formulary-red";case vm.titles.screeningOverride:return"ap-sigwizard-override-"+vm.screeningStatus;case vm.titles.sigInstructions:return null===vm.isSigInstructionsValid?"ap-sigwizard-script-black":vm.isSigInstructionsValid?"ap-sigwizard-script-green":"ap-sigwizard-script-red";case vm.titles.sigOptions:return null===vm.isSigOptionsValid?"ap-sigwizard-options-black":vm.isSigOptionsValid?"ap-sigwizard-options-green":"ap-sigwizard-options-red";case vm.titles.summary:return"ap-sigwizard-review-black"}},vm.getStepIconId=function(step){return step.wzTitle.replace(/ /g,"-")+"-icon"},vm.getWizard=getWizard,vm.goToStep=function(step,stepNumber){var targetStepTitle=step.wzTitle;isStepBehindCurrentStep(stepNumber)||submitCurrentStep();getWizard().goTo(targetStepTitle)},vm.onFinish=function(){if(submitCurrentStep(),canAdvanceFromCurrentStep()){if(verifyReviewedRequiredScreens())return;if(vm.rxParameters.isDeferredRx)vm.completed({rx:vm.currentRx});else{var visitDto=SigwriterRxService.mapToVisitDto(vm.currentRx),savePromise=VisitRepository.createVisit(visitDto);SaveRxModal.openModal(savePromise).then(function(result){toaster.pop("success","",gettext("RX submitted successfully.")),vm.completed({rx:vm.currentRx,visit:result})})}}},vm.onNext=function(){submitCurrentStep()},vm.registerFormSubmitCallback=function(stepTitle,callbackFn){formSubmitCallbackFns[stepTitle]=callbackFn},vm.setNewDrug=function(drug,pharmacy){if(updateRxParameters({drug:drug}),SigwriterRxService.setRxDrug(vm.currentRx,drug),!vm.rxParameters.isFixedPharmacy&&pharmacy){var sigOptions={pharmacy:pharmacy};updateSigOptions(sigOptions)}else cloneCurrentRx();getWizard().goTo(vm.titles.sigInstructions)},vm.updateDrugScreening=function(drugScreening){vm.currentRx.drugScreening=_.assignIn(_.cloneDeep(vm.currentRx.drugScreening),_.cloneDeep(drugScreening)),cloneCurrentRx()},vm.updateEpcsSignature=function(epcsSignature){vm.currentRx.epcsSignature=_.cloneDeep(epcsSignature),cloneCurrentRx()},vm.updateIsFormularyAlternativesAvailable=function(isAvailable){(vm.isFormularyAvailable=isAvailable)&&(vm.isFormularyViewed=getCurrentStepTitle()===vm.titles.formularyAlternatives,vm.hasEverViewedFormulary=vm.hasEverViewedFormulary||vm.isFormularyViewed);console.log("updateIsFormularyAlternativesAvailable: "+isAvailable+", isFormularyViewed: "+vm.isFormularyViewed+", hasEverViewedFormulary: "+vm.hasEverViewedFormulary)},vm.updateIsScreeningLoaded=function(isLoaded,isOverrideRequired,status){vm.isScreeningLoaded=isLoaded,vm.isOverrideRequired=isOverrideRequired,vm.screeningStatus=status||"black",vm.isScreeningViewed=!!isLoaded&&getCurrentStepTitle()===vm.titles.drugScreening},vm.updateIsSigInstructionsValid=function(isValid){vm.isSigInstructionsValid=isValid},vm.updateIsSigOptionsValid=function(isValid){vm.isSigOptionsValid=isValid},vm.updateIsSummaryValid=function(isValid){vm.isSummaryValid=isValid},vm.updateRelVisitMedicationId=function(relVisitMedicationId){vm.currentRx.relVisitMedicationId||(vm.currentRx.relVisitMedicationId=relVisitMedicationId,cloneCurrentRx())},vm.updateSigFormulary=function(sigFormulary){vm.currentRx.sigFormulary=_.assignIn(_.cloneDeep(vm.currentRx.sigFormulary),_.cloneDeep(sigFormulary))},vm.updateSigInstruction=function(sigInstruction){vm.currentInstruction=_.cloneDeep(setRxInstructions(sigInstruction)),cloneCurrentRx()},vm.updateSigOptions=updateSigOptions,vm.updateSigOptionsNonFormulary=function(sigOptionsNonFormulary){vm.currentRx.optionsNonFormulary=_.assignIn(_.cloneDeep(vm.currentRx.optionsNonFormulary),_.cloneDeep(sigOptionsNonFormulary)),vm.disableSigDates=vm.currentRx.optionsNonFormulary.isAdministered||vm.currentRx.optionsNonFormulary.isSampleGiven,vm.skipFormularyAlternatives=shouldSkipFormularyAlternatives(),cloneCurrentRx()},$scope.$on("wizard:stepChanged",onStepChanged),formSubmitCallbackFns={},vm.currentRx=vm.options.rx,vm.currentInstruction=vm.currentRx.instructions[0],vm.rxOptions=vm.currentRx.rxOptions,vm.rxParameters={drug:vm.currentRx.drug,isDeferredRx:vm.options.isDeferredRx,isFixedPharmacy:vm.options.isFixedPharmacy,patientId:vm.currentRx.patient.Id,rxId:vm.currentRx.id,sigType:vm.currentRx.sigType},vm.enableMedicationTypeSelection=vm.rxOptions.additionalMedInfo.isMedicationTypeEditable,vm.skipFormularyAlternatives=shouldSkipFormularyAlternatives(),SigwriterDosingService.showVariableDosingErrors(vm.currentInstruction),cloneCurrentRx()}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardSigInstructions",{templateUrl:"/sigwriter/component-views/wizardSigInstructions.html",bindings:{disableDates:"<",enableMedicationTypeSelection:"<",rxOptions:"<",rxParameters:"<",sigInstruction:"<",sigOptionsNonFormulary:"<",applyDosingSuggestion:"&",registerFormSubmitCallback:"&",updateIsValid:"&",updateSigInstruction:"&",updateSigOptionsNonFormulary:"&"},controller:["_","$anchorScroll","$scope","$timeout","DrugDocumentationModal","SigwriterRxService","DrugDosingModalService",function(_,$anchorScroll,$scope,$timeout,DrugDocumentationModal,SigwriterRxService,DrugDosingModalService){var formWatcherCleanupFn,formValidWatcherCleanupFn,vm=this;function onDisableDatesChanged(changesDisableDates){changesDisableDates.currentValue?(vm.sig.startDate=null,vm.sig.endDate=null):vm.sig.endDateChanged=!1,saveSigInstruction()}function onFormChanged(newValue,oldValue){formValidWatcherCleanupFn&&newValue===oldValue||(formValidWatcherCleanupFn?formValidWatcherCleanupFn():vm.registerFormSubmitCallback({callbackFn:onFormSubmit}),formValidWatcherCleanupFn=$scope.$watch("$ctrl.sigInstructionsForm.$valid",onFormValidChanged),vm.sigInstructionsForm&&$timeout(function(){onFormValidChanged(vm.sigInstructionsForm.$valid)},0))}function onFormSubmit(){vm.sigInstructionsForm.$setSubmitted(!0),vm.sigInstructionsForm.$valid||$anchorScroll("quantity-form-group")}function onFormValidChanged(newValue,oldValue){newValue!==oldValue&&vm.updateIsValid({isValid:newValue})}function onMedTypeChangedExternally(){var selectedMedType;selectedMedType=vm.sigOptionsNonFormulary.isAdministered?vm.rxOptions.additionalMedInfo.medTypes[1]:vm.sigOptionsNonFormulary.isSampleGiven?vm.rxOptions.additionalMedInfo.medTypes[2]:vm.rxOptions.additionalMedInfo.medTypes[0],vm.medicationType=selectedMedType}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){vm.optionsNonFormulary=_.merge(vm.optionsNonFormulary,changesSigOptionsNonFormulary.currentValue),onMedTypeChangedExternally()}function saveSigInstruction(){vm.updateSigInstruction({sigInstruction:vm.sig})}vm.medicationType=null,vm.optionsNonFormulary=_.cloneDeep(vm.sigOptionsNonFormulary),vm.sig=_.cloneDeep(vm.sigInstruction),vm.sigInstructionsForm=null,vm.$onChanges=function(changes){changes.disableDates&&void 0!==changes.disableDates.currentValue&&onDisableDatesChanged(changes.disableDates);changes.sigInstruction&&changes.sigInstruction.currentValue&&(changesSigInstruction=changes.sigInstruction,vm.sig=_.merge(vm.sig,changesSigInstruction.currentValue));var changesSigInstruction;changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.$onDestroy=function(){formWatcherCleanupFn&&formWatcherCleanupFn();formValidWatcherCleanupFn&&formValidWatcherCleanupFn()},vm.$onInit=function(){formWatcherCleanupFn=$scope.$watch("$ctrl.sigInstructionsForm",onFormChanged)},vm.getRemainingSigCharacters=function(){var remainingCharacters=SigwriterRxService.getRemainingSigCharacters(vm.sigInstruction);vm.sigInstructionsForm&&vm.sigInstructionsForm.$setValidity("siginstructionlength",0<=remainingCharacters);return Math.max(0,remainingCharacters)},vm.endDateChanged=function(){vm.sig.endDateChanged=!0,saveSigInstruction()},vm.openDosingSuggestions=function(){DrugDosingModalService.openModal(vm.rxParameters,vm.sigInstruction).toPromise().then(function(result){if(result.isSuccess){var dosingSuggestion=result.resultValue.suggestion;vm.applyDosingSuggestion(dosingSuggestion)}})},vm.openPdr=function(){DrugDocumentationModal.openModal(vm.rxParameters.drug.MedId,vm.rxParameters.drug.Ndc,vm.rxParameters.patientId,vm.rxParameters.rxId)},vm.onMedTypeChanged=function(){vm.medicationType&&1!==vm.medicationType.Id?2===vm.medicationType.Id?(vm.optionsNonFormulary.isAdministered=!0,vm.optionsNonFormulary.isSampleGiven=!1):3===vm.medicationType.Id&&(vm.optionsNonFormulary.isAdministered=!1,vm.optionsNonFormulary.isSampleGiven=!0):(vm.optionsNonFormulary.isAdministered=!1,vm.optionsNonFormulary.isSampleGiven=!1);vm.updateSigOptionsNonFormulary({sigOptionsNonFormulary:vm.optionsNonFormulary})},vm.onSigSelected=function(sig){vm.updateSigInstruction({sigInstruction:sig})},vm.saveSigInstruction=saveSigInstruction,vm.toggleQuantityType=function(){SigwriterRxService.toggleQuantityType(vm.sig)&&saveSigInstruction()}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardSigInstructionsContent",{templateUrl:"/sigwriter/component-views/wizardSigInstructionsContent.html",bindings:{rxOptions:"<",sigInstruction:"<",sigOptionsNonFormulary:"<",onSelect:"&",rxParameters:"<"},controller:["$rootScope","DosingCalcModal","ViewportInfo",function($rootScope,DosingCalcModal,ViewportInfo){var mode,vm=this,dosingCalcSupported=DosingCalcModal.isSupported();function fireOnSelect(){vm.sig&&vm.sigInstruction&&(vm.sig.isPrn=vm.sig.prnReason&&!vm.sig.prnReason.isNull,vm.onSelect({sig:vm.sig}))}function loadTopMenu(){setDimensions(),vm.currentOption=null,vm.options=vm.rxOptions.options}function menuClosed(closingMode){mode===closingMode&&loadTopMenu()}function navigateToNextOption(parentOption){setDimensions(),parentOption?(vm.currentOption=_(vm.rxOptions.options).dropWhile(function(i){return parentOption.key!==i.key}).filter(function(o){return!vm.sig[o.key]}).head(),vm.currentOption?(vm.options=vm.currentOption.items,mode=vm.currentOption.key):"top"!==mode?($rootScope.$broadcast("close-context-menu"),menuClosed()):loadTopMenu()):loadTopMenu()}function onIsAdministeredChanged(){vm.sigOptionsNonFormulary.isAdministered&&(vm.sig.days={Name:"None",isNull:!0},vm.sig.refills={Name:"None",isNull:!0},vm.sig.StartDate=null,vm.sig.EndDate=null,fireOnSelect())}function onSigInstructionsChanged(changesSigInstructions){if(!vm.sig){vm.sig={startText:"",postDosage:"",postUnit:"",postRoute:"",postFrequency:"",postPrn:"",endText:""}}vm.sig=_.merge(vm.sig,changesSigInstructions.currentValue)}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){var previousIsAdministered=!changesSigOptionsNonFormulary.isFirstChange()&&changesSigOptionsNonFormulary.previousValue?changesSigOptionsNonFormulary.previousValue.isAdministered:void 0;previousIsAdministered!==changesSigOptionsNonFormulary.currentValue.isAdministered&&onIsAdministeredChanged()}function setDimensions(){vm.maxHeight=Math.max(ViewportInfo.getWindowHeight()/2,200),vm.maxWidth=ViewportInfo.getWindowWidth()}vm.currentOption=null,vm.options=null,vm.sig=null,vm.$onInit=function(){setDimensions()},vm.$onChanges=function(changes){changes.sigInstruction&&changes.sigInstruction.currentValue&&onSigInstructionsChanged(changes.sigInstruction);changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.fireOnSelect=fireOnSelect,vm.menuClosed=menuClosed,vm.open=function(key){setDimensions(),mode=key;var option=_(vm.rxOptions.options).find({key:key});if(option){vm.currentOption=option,vm.options=option.items;var selectedVal=vm.sig[vm.currentOption.key];selectedVal&&selectedVal.isCustom&&(vm.sig.numericEntry=selectedVal.Name)}else loadTopMenu()},vm.optionSelected=function(option,currentOption){return option.key&&vm.sig[option.key]||currentOption&&(option===vm.sig[currentOption.key]||option&&option.Name&&vm.sig[currentOption.key]&&option.Name===vm.sig[currentOption.key].Name)},vm.selectOption=function(option){var parent=vm.currentOption;(vm.currentOption=option).items?vm.options=option.items:(parent&&(vm.sig[parent.key]=option),navigateToNextOption(parent),fireOnSelect())},vm.selectTextOption=function(){vm.sig[vm.currentOption.key]={Name:vm.sig.numericEntry,isCustom:!0},navigateToNextOption(vm.currentOption),vm.sig.numericEntry=null,fireOnSelect()},vm.onClickDosingCalculator=function(){DosingCalcModal.openFromSigwriter(vm.sig,vm.rxParameters,null)},vm.shouldDisplayDosingCalc=function(){return dosingCalcSupported}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").component("sigwriterWizardSigOptions",{templateUrl:"/sigwriter/component-views/wizardSigOptions.html",bindings:{rxOptions:"<",rxParameters:"<",sigFormulary:"<",sigOptions:"<",sigOptionsNonFormulary:"<",registerFormSubmitCallback:"&",updateIsValid:"&",updateSigOptions:"&",updateSigOptionsNonFormulary:"&"},controller:["_","$anchorScroll","$scope","$timeout","ListService","LocalStorageRepository","PatientRepository","PharmacyRepository","ServerInfoRepository","SigWriterRepository",function(_,$anchorScroll,$scope,$timeout,ListService,LocalStorageRepository,PatientRepository,PharmacyRepository,ServerInfoRepository,SigWriterRepository){var formWatcherCleanupFn,formValidWatcherCleanupFn,vm=this,defaultedPharmacy=!1,defaultedProblems=!1,chronicMedCheckSupported=ServerInfoRepository.isFeatureSupported("SigWriter_ChronicMed");function getMedicationTypeChanged(current,previous){var currentType=getMedicationType(current),previousType=getMedicationType(previous);return previousType!==currentType;function getMedicationType(optionsNonFormulary){return optionsNonFormulary?optionsNonFormulary.isAdministered?2:optionsNonFormulary.isSampleGiven?3:1:1}}function loadPharmacyNotes(){var pharmacyGeneralNoteTypeId=LocalStorageRepository.getPharmacyGeneralNoteTypeId();if(pharmacyGeneralNoteTypeId){var listsToLoad={generalNotes:"generalnotes/"+pharmacyGeneralNoteTypeId};ListService.getLists(listsToLoad).then(function(lists){lists.generalNotes&&(vm.generalNotes=lists.generalNotes)})}}function onFindPharmacyChanged(){vm.pharmacy&&vm.pharmacy.Id?vm.options.pharmacy=_.cloneDeep(vm.pharmacy):vm.options.pharmacy=null,onOptionsChanged()}function onFormChanged(newValue,oldValue){formValidWatcherCleanupFn&&newValue===oldValue||(formValidWatcherCleanupFn?formValidWatcherCleanupFn():vm.registerFormSubmitCallback({callbackFn:onFormSubmit}),formValidWatcherCleanupFn=$scope.$watch("$ctrl.sigOptionsForm.$valid",onFormValidChanged),vm.sigOptionsForm&&$timeout(function(){onFormValidChanged(vm.sigOptionsForm.$valid)},0))}function onFormSubmit(){vm.sigOptionsForm.$setSubmitted(!0),vm.sigOptionsForm.isSubmitted=!0,vm.sigOptionsForm.$valid||$anchorScroll("pharmacy-form-group")}function onFormValidChanged(newValue,oldValue){newValue!==oldValue&&vm.updateIsValid({isValid:newValue})}function onMedTypeChanged(){vm.optionsNonFormulary.isAdministered?(vm.options.pharmacy=null,vm.drugAdministered=!0,vm.optionsNonFormulary.daw=!1,vm.dawDisabled=!0,vm.optionsNonFormulary.isChronicMed=!1,vm.optionsNonFormulary.isHighRiskMed=!1,vm.chronicDisabled=!0):(vm.optionsNonFormulary.isSampleGiven&&(vm.options.pharmacy=null),vm.drugAdministered=!1,vm.dawDisabled=!1,vm.chronicDisabled=!1),onOptionsChanged(),onOptionsNonFormularyChanged()}function onOptionsChanged(){vm.updateSigOptions({sigOptions:vm.options})}function onOptionsNonFormularyChanged(){vm.updateSigOptionsNonFormulary({sigOptionsNonFormulary:vm.optionsNonFormulary})}function onSigFormularyChanged(changeSigFormulary){changeSigFormulary.currentValue&&changeSigFormulary.currentValue.primaryMedication&&updateEpaButton(changeSigFormulary.currentValue.primaryMedication.requiresPa)}function onSigOptionsChanged(changesSigOptions){var pharmacyChanged=(vm.pharmacy?vm.pharmacy.Id:void 0)!==(changesSigOptions.currentValue.pharmacy?changesSigOptions.currentValue.pharmacy.Id:void 0);vm.options=_.merge(vm.options,changesSigOptions.currentValue),vm.pharmacies&&(defaultedPharmacy?pharmacyChanged&&setPharmacyById():setDefaultPharmacy())}function onSigOptionsNonFormularyChanged(changesSigOptionsNonFormulary){var medTypeChanged=getMedicationTypeChanged(changesSigOptionsNonFormulary.currentValue,vm.optionsNonFormulary),prescriberChanged=hasPrescriberChanged(changesSigOptionsNonFormulary.currentValue,vm.optionsNonFormulary,changesSigOptionsNonFormulary.isFirstChange());vm.optionsNonFormulary=_.merge(vm.optionsNonFormulary,changesSigOptionsNonFormulary.currentValue),medTypeChanged&&onMedTypeChanged(),!defaultedProblems&&vm.problems&&setDefaultProblems(),prescriberChanged&&loadProviderDrugSettings()}function hasPrescriberChanged(current,previous,firstChange){var currentPrescriberId=current&&current.prescriber&&current.prescriber.Id,previousPrescriberId=previous&&previous.prescriber&&previous.prescriber.Id,prescriberChanged=currentPrescriberId&&(firstChange||currentPrescriberId!==previousPrescriberId);return prescriberChanged}function setDefaultPharmacy(){var foundPharmacy,searchObj;vm.options.pharmacy&&vm.options.pharmacy.Id?vm.options.pharmacy.MasterPharmacy&&vm.options.pharmacy.MasterPharmacy.PharmacyClearinghouse?foundPharmacy=vm.options.pharmacy:(searchObj={Id:vm.options.pharmacy.Id},(foundPharmacy=_(vm.pharmacies).filter(searchObj).head())||PharmacyRepository.getPharmacy(searchObj.Id).then(function(pharmacy){vm.pharmacy=pharmacy,onFindPharmacyChanged()})):(searchObj={IsPreferredPharmacy:!0},foundPharmacy=_(vm.pharmacies).filter(searchObj).head()),defaultedPharmacy=!0,foundPharmacy&&(vm.pharmacy=foundPharmacy,onFindPharmacyChanged())}function setDefaultProblems(){var currentProblems=_(vm.optionsNonFormulary.problems);vm.optionsNonFormulary.problems=_(vm.problems).filter(function(problem){return problem.DiseaseId?currentProblems.some({DiseaseId:problem.DiseaseId}):currentProblems.some(function(p){return p.Icd10Code===problem.Icd10Code&&p.Icd9Code===problem.Icd9Code})}).value(),defaultedProblems=!0,onOptionsNonFormularyChanged()}function setPharmacyById(){if(vm.options.pharmacy&&vm.options.pharmacy.Id){var selectedPharmacy=_(vm.pharmacies).filter({Id:vm.options.pharmacy.Id}).head();selectedPharmacy&&(vm.pharmacy=selectedPharmacy)}else vm.pharmacy=null}function updateEpaButton(value){vm.optionsNonFormulary&&!vm.toggleEpaChanged&&(vm.optionsNonFormulary.sendPriorAuth=value,onOptionsNonFormularyChanged())}function loadProviderDrugSettings(){if(chronicMedCheckSupported){var prescriberId=vm.optionsNonFormulary&&vm.optionsNonFormulary.prescriber&&vm.optionsNonFormulary.prescriber.Id;if(prescriberId){var drug=vm.rxParameters.drug,patientId=vm.rxParameters.patientId,sigType=vm.rxParameters.sigType;SigWriterRepository.getDrugSettings(sigType,drug,prescriberId,patientId).then(function(data){var isChronic=data.IsMaintenance,isSpecialty=data.IsSpecialty,isHighRisk=data.IsHighRisk;isChronic&&(vm.optionsNonFormulary.isChronicMed=isChronic),isHighRisk&&(vm.optionsNonFormulary.isHighRiskMed=isHighRisk),vm.optionsNonFormulary.sendIsSpecialty=isSpecialty,onOptionsNonFormularyChanged()})}}}vm.chronicDisabled=!1,vm.dawDisabled=!1,vm.drugAdministered=!1,vm.generalNotes=[],vm.notesList={},vm.options=_.cloneDeep(vm.sigOptions),vm.optionsNonFormulary=_.cloneDeep(vm.sigOptionsNonFormulary),vm.parentContainerId="wizard-shell-body",vm.pharmacy=null,vm.pharmacies=null,vm.problems=null,vm.shouldDisplayEpaSpoCheckbox=!1,vm.sigOptionsForm=null,vm.toggleEpaChanged=!1,vm.$onChanges=function(changes){changes.sigFormulary&&changes.sigFormulary.currentValue&&onSigFormularyChanged(changes.sigFormulary);changes.sigOptions&&changes.sigOptions.currentValue&&onSigOptionsChanged(changes.sigOptions);changes.sigOptionsNonFormulary&&changes.sigOptionsNonFormulary.currentValue&&onSigOptionsNonFormularyChanged(changes.sigOptionsNonFormulary)},vm.$onDestroy=function(){formWatcherCleanupFn&&formWatcherCleanupFn();formValidWatcherCleanupFn&&formValidWatcherCleanupFn()},vm.$onInit=function(){formWatcherCleanupFn=$scope.$watch("$ctrl.sigOptionsForm",onFormChanged),vm.shouldDisplayEpaSpoCheckbox=ServerInfoRepository.isFeatureSupported("SendPriorAuthIsSpecialty"),PatientRepository.getPharmacies(vm.rxParameters.patientId).then(function(pharmacies){vm.pharmacies=pharmacies,vm.options&&setDefaultPharmacy()}),loadPharmacyNotes(),PatientRepository.getProblems(vm.rxParameters.patientId).then(function(problems){vm.problems=problems,vm.optionsNonFormulary&&setDefaultProblems()})},vm.getRemainingPharmacyInstructionCharacters=function(){if(!vm.rxOptions||!vm.options)return 0;var metadata=vm.rxOptions.metadata.visit,maxLength=metadata&&metadata.Fields&&metadata.Fields.Prescriptions&&metadata.Fields.Prescriptions.Fields&&metadata.Fields.Prescriptions.Fields.Instructions&&metadata.Fields.Prescriptions.Fields.Instructions.Fields&&metadata.Fields.Prescriptions.Fields.Instructions.Fields.PharmacyInstruction&&metadata.Fields.Prescriptions.Fields.Instructions.Fields.PharmacyInstruction.MaxLength||0;return void 0!==vm.optionsNonFormulary.pharmacyInstructions?Math.max(0,vm.optionsNonFormulary.pharmacyInstructions?maxLength-vm.optionsNonFormulary.pharmacyInstructions.length:maxLength):0},vm.notesListChanged=function(){vm.optionsNonFormulary.internalNote&&(vm.optionsNonFormulary.internalNote+="\r\n");vm.optionsNonFormulary.internalNote+=vm.notesList.Note,onOptionsNonFormularyChanged()},vm.onFindPharmacyChanged=onFindPharmacyChanged,vm.onOptionsChanged=onOptionsChanged,vm.onOptionsNonFormularyChanged=onOptionsNonFormularyChanged,vm.onSendPriorAuthChanged=function(){vm.toggleEpaChanged=!0,onOptionsNonFormularyChanged()}}]})}(),function(){"use strict";angular.module("aprima-sigwriter").controller("SigwriterWizardDrugSearchCtrl",["SigwriterRxService","TransitionManager","deferSaving","patientId","pharmacy","billingProviderId",function(SigwriterRxService,TransitionManager,deferSaving,patientId,pharmacy,billingProviderId){var isValidPharmacy,previousTransition,vm=this;vm.deferSaving=deferSaving,vm.patientId=patientId,vm.usePreviousSearchText=!1,vm.kdbParameters={billingProviderId:billingProviderId},vm.onDrugSelected=function(rx){isValidPharmacy&&(rx.options.pharmacy=pharmacy);SigwriterRxService.setStoredWizardOptions(previousTransition,rx,deferSaving,isValidPharmacy),TransitionManager.transition({appRoute:"rxwizardsigwriter",opts:{}})},vm.onExistingSigSelected=function(rx){isValidPharmacy&&(rx.options.pharmacy=pharmacy);previousTransition.opts.sigwriterCompleted=!0,SigwriterRxService.setStoredSigwriterResults(rx),TransitionManager.replaceCurrentState(previousTransition)},isValidPharmacy=pharmacy&&pharmacy.Id,(previousTransition=TransitionManager.getPreviousTransition()).opts.sigwriterCompleted=!1,vm.usePreviousSearchText="rxwizardsigwriter"===previousTransition.appRoute}])}(),function(){"use strict";angular.module("aprima-sigwriter").controller("SigwriterWizardRefillCtrl",["$scope","gettext","SigwriterRxService","toaster","TransitionManager","medicationSigId","patientId","relPatientMedicationId",function($scope,gettext,SigwriterRxService,toaster,TransitionManager,medicationSigId,patientId,relPatientMedicationId){var vm=this;function onRxLoaded(rx){if(vm.$scope.removeHttpError(),!rx||!rx.drug||!rx.drug.MedId)return toaster.pop("warning","",gettext("The medication is invalid and cannot be refilled.")),void TransitionManager.goBack();SigwriterRxService.setStoredWizardOptions(TransitionManager.getPreviousTransition(),rx),TransitionManager.replaceCurrentState({appRoute:"rxwizardsigwriter",opts:{}})}vm.$scope=$scope,vm.loadingRefill=!1,vm.loadingRefill=!0,SigwriterRxService.startWizardRefill(patientId,medicationSigId,relPatientMedicationId).then(onRxLoaded).catch(function(response){response&&response.cancelled?TransitionManager.goBack():vm.$scope.addHttpError(response)}).finally(function(){vm.loadingRefill=!1})}])}(),function(angular){"use strict";window.angular.module("aprima-sigwriter").filter("medCommonLanguage",["SigwriterRxServiceTs",function(SigwriterRxServiceTs){return function(object,includeAbbrev,description,displayAbbrevFirst){return SigwriterRxServiceTs.getMedCommonLanguage(object,includeAbbrev,description,displayAbbrevFirst)}}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("DefaultSigDosingCalcModal",["$q","DefaultSigDosingCalculatorModalService",function($q,DefaultSigDosingCalculatorModalService){return{openFromSigwriter:function(sigInstruction,rxParameters){var promise=DefaultSigDosingCalculatorModalService.openFromSigwriter(sigInstruction,rxParameters).toPromise().then(function(result){return result.isSuccess?result.resultValue:$q.reject(result)});return $q.when(promise)}}}])}(angular),function(angular){"use strict";window.angular.module("aprima-sigwriter").factory("DosingCalcModal",["$q","DosingCalculatorModalService",function($q,DosingCalculatorModalService){return{openFromSigwriter:function(sigInstruction,rxParameters,patientDetails){var promise=DosingCalculatorModalService.openFromSigwriter(sigInstruction,rxParameters,patientDetails).toPromise();return $q.when(promise)},isSupported:function(){return DosingCalculatorModalService.isSupported()}}}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugConsentModal",["$uibModal",function($modal){return{openModal:function(medicationConsent,formattingTemplateName){return openModalOnly(medicationConsent,formattingTemplateName).result},openModalOnly:openModalOnly};function openModalOnly(medicationConsent,formattingTemplateName){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/drug-consent-modal.html",controller:"DrugConsentModalCtrl",controllerAs:"vm",resolve:{formattingTemplateName:function(){return formattingTemplateName},medicationConsent:function(){return medicationConsent}}})}}]),angular.module("aprima-sigwriter").controller("DrugConsentModalCtrl",["$uibModalInstance","DeviceSettings","formattingTemplateName","GeneralNotesModal","GeneralNoteTypeKeys","aprgettext","medicationConsent","toaster",function($modalInstance,DeviceSettings,formattingTemplateName,GeneralNotesModal,GeneralNoteTypeKeys,gettext,medicationConsent,toaster){var vm=this;if(vm.cancel=function(){$modalInstance.dismiss()},vm.onClickSymptom=function(){GeneralNotesModal.openModal("Symptom",vm.symptom,!0,!1,GeneralNoteTypeKeys.MedicationConsent).then(function(result){vm.symptom=result})},vm.save=function(){var howDiscussed=vm.inPerson?"In-Person":vm.telephone?"Telephone":vm.telemedicine?"Telemedicine":vm.previously?"Previously":null;howDiscussed?vm.symptom&&""!==vm.symptom?$modalInstance.close({HowDiscussed:howDiscussed,Symptom:vm.symptom}):toaster.pop("error","","Symptom is required."):toaster.pop("error","",gettext("You must select an option for How Discussed."))},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},vm.formattingTemplateName=formattingTemplateName,medicationConsent){switch(medicationConsent.HowDiscussed){case"In-Person":vm.inPerson=!0;break;case"Telephone":vm.telephone=!0;break;case"Telemedicine":vm.telemedicine=!0;break;case"Previously":vm.previously=!0}vm.symptom=medicationConsent.Symptom}}])}(),angular.module("aprima-sigwriter").factory("DrugConsentWarningModal",["$uibModal","$q","$rootScope",function($modal,$q,$rootScope){"use strict";return{openDrugConsentWarningModal:function(drugName){var $scope=$rootScope.$new();$rootScope.setupDirectiveScope($scope);var deferred=$q.defer();$scope.drugConsentWarning={drugName:drugName};var drugConsentModal=$modal.open({backdrop:"static",scope:$scope,templateUrl:"/sigwriter/views/modals/drug-consent-warning-modal.html",windowClass:"modal-full"});return drugConsentModal.result.catch(function(result){deferred.reject(result)}),$scope.$on("$destroy",function(){drugConsentModal.close()}),deferred.promise}}}]),function(angular){"use strict";angular.module("aprima-sigwriter").factory("DrugCoreService",["_","$q","apConfirmService",function(_,$q,apConfirmService){return{validateDrugs:function(drugs,sigType){if(!drugs)return $q.reject({message:"Invalid drugs: empty",cancelled:!1});var drugsToValidate;if(angular.isArray(drugs))drugsToValidate=drugs;else{if(!angular.isObject(drugs))return $q.reject({message:"Invalid drugs: "+drugs,cancelled:!1});drugsToValidate=[drugs]}if("Hx"===sigType)return $q.when(!0);var inactiveDrugs=_.filter(drugsToValidate,"IsInactiveOrObsolete");if(!inactiveDrugs.length)return $q.when(!0);var msg='The following medications are obsolete or retired:<br>"'+_.map(inactiveDrugs,"Name").join('",<br>"')+'"<br>Do you wish to continue?';return apConfirmService.confirm(msg,"Yes","No","md").then(function(accepted){return!!accepted||$q.reject({cancelled:!0})},function(){return $q.reject({cancelled:!0})})}}}])}(window.angular),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugDetailModal",["$q","SigwriterDrugDetailModalService",function($q,SigwriterDrugDetailModalService){return{openModal:function(drug,medId,patientId,relPatientMedicationId,sigId,rxId,searchEnabled){var promise=SigwriterDrugDetailModalService.openModal(drug,medId,patientId,relPatientMedicationId,sigId,rxId,searchEnabled).toPromise();return $q.when(promise)}}}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugDocumentationModal",["$uibModal",function($modal){return{openModal:function(medId,ndc,patientId,rxId){var drug={MedId:medId,Ndc:ndc},patient={Id:patientId},something={value:medId};return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/drug-documentation-modal.html",windowClass:"modal-pdr",controller:"DrugDocumentationModalCtrl",controllerAs:"vm",resolve:{drug:drug,patient:patient,rxId:rxId,something:something}}).result}}}]),angular.module("aprima-sigwriter").controller("DrugDocumentationModalCtrl",["$uibModalInstance","drug","patient","rxId","something",function($modalInstance,drug,patient,rxId,something){var vm=this;vm.something=something,vm.drug=drug,vm.patient=patient,vm.rxId=rxId,vm.cancel=function(){$modalInstance.dismiss()},vm.close=function(){$modalInstance.close()}}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugDosingModal",["$q","DrugDosingModalService",function($q,DrugDosingModalService){return{openModal:function(rxParameters,sigInstruction){var promise=DrugDosingModalService.openModal(rxParameters,sigInstruction).toPromise();return $q.when(promise)}}}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("DrugScreeningModal",["$uibModal",function($modal){return{openModal:function(patientId,drugMedId,rxId,defaultOverrideText){var rxParameters={drug:{MedId:drugMedId},patientId:patientId,rxId:rxId},drugScreening={overrideText:defaultOverrideText};return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/drug-screening-modal.html",windowClass:"modal-full",controller:"DrugScreeningModalCtrl",controllerAs:"vm",resolve:{drugScreening:drugScreening,rxParameters:rxParameters}}).result}}}]),angular.module("aprima-sigwriter").controller("DrugScreeningModalCtrl",["$uibModalInstance","aprgettext","drugScreening","rxParameters","WizardHandler",function($modalInstance,gettext,drugScreening,rxParameters,WizardHandler){var vm=this;function cancel(){$modalInstance.dismiss()}function getWizard(){var wizard=WizardHandler.wizard(vm.wizardName);return wizard}vm.drugScreening=_.cloneDeep(drugScreening),vm.isScreeningLoaded=!1,vm.lookups={screeningTitle:gettext("Drug Screening + Alerts"),overrideTitle:gettext("Drug Screening Override")},vm.progress={requiresOverride:!1,screeningComplete:!1},vm.requiresOverride=!1,vm.rxParameters=rxParameters,vm.wizardName="DrugScreeningWizard",vm.cancel=cancel,vm.getWizard=getWizard,vm.onFinish=function(){vm.isScreeningLoaded?$modalInstance.close(vm.drugScreening):cancel()},vm.updateDrugScreening=function(updatedDrugScreening){vm.drugScreening=_.assignIn(vm.drugScreening,_.cloneDeep(updatedDrugScreening))},vm.updateIsScreeningLoaded=function(isLoaded,isOverrideRequired){vm.isScreeningLoaded=isLoaded,vm.requiresOverride=isOverrideRequired},vm.getStepTitle=function(){var wizard=getWizard();if(wizard&&wizard.totalStepCount())return wizard.currentStepTitle();return}}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("DxProblemsModal",["$uibModal",function($modal){return{openModal:function(patientId,medicationSigId,orderByDisplayOrder,selectedItems,formatter,orderFn){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/dx-problems-modal.html",controller:"DxProblemsModalCtrl",controllerAs:"vm",resolve:{selectedItems:function(){return selectedItems},patientId:function(){return patientId},formatter:function(){return formatter},orderFn:function(){return orderFn},medicationSigId:function(){return medicationSigId},orderByDisplayOrder:function(){return orderByDisplayOrder}}}).result}}}]),angular.module("aprima-sigwriter").controller("DxProblemsModalCtrl",["_","$uibModalInstance","debounce","ErrorService","formatter","medicationSigId","orderByDisplayOrder","orderFn","patientId","PatientRepository","selectedItems","SigwriterDxProblemsService",function(_,$modalInstance,debounce,ErrorService,formatter,medicationSigId,orderByDisplayOrder,orderFn,patientId,PatientRepository,selectedItems,SigwriterDxProblemsService){var vm=this;function loadData(ignoreCache){vm.loading=!0;var promise=PatientRepository.getActiveProblems(patientId,{ignoreCache:!!ignoreCache}).then(function(problems){ErrorService.removeHttpErrorFromScope(vm),vm.items=_.compact(problems).filter(function(item){if(!item.IsProblem)return item}),vm.items.forEach(function(item){item.previouslySelected=!1,item.selected=!1,item.DisplayOrder=0}),selectedItems&&_.intersectionBy(vm.items,selectedItems,"Uid").forEach(function(item){item.previouslySelected=!0,item.selected=!0}),vm.orderByDisplayOrder&&(vm.items=SigwriterDxProblemsService.sortSelectedDxProblemsByDisplayOrder(vm.items,selectedItems))}).catch(function(response){ErrorService.addHttpErrorToScope(vm,response)}).finally(function(){vm.loading=!1});return promise}vm.cancel=function(){$modalInstance.dismiss()},vm.done=function(){var selected=_.filter(vm.items,"selected");_.forEach(selected,function(item){item.DisplayOrder=0}),vm.orderByDisplayOrder&&(selected=SigwriterDxProblemsService.updateDisplayOrderForSelectedDxProblemList(selected));$modalInstance.close(selected)},vm.clear=debounce(100,function(){if(!vm.items)return;_.forEach(vm.items,function(item){item&&(item.selected=!1,item.DisplayOrder=0)}),SigwriterDxProblemsService.clearDisplayOrderLists()}),vm.load=debounce(200,loadData),vm.getItemOrder=function(item){return item?""+(item.previouslySelected?0:1)+orderFn(item):"2"},vm.countSelected=function(){return vm.items?_.sumBy(vm.items,function(val){return val&&val.selected?1:0}):0},vm.loading=!1,vm.items=[],vm.formatter=formatter,vm.orderByDisplayOrder=orderByDisplayOrder,vm.onClickDxProblemItem=function(dxProblemItem){if(!vm.orderByDisplayOrder)return;SigwriterDxProblemsService.updateSelectedDxProblemList(dxProblemItem)},loadData(!0)}])}(window.angular),function(){"use strict";angular.module("aprima-sigwriter").factory("NewDefaultSigModal",["$q","NewDefaultSigModalService",function($q,NewDefaultSigModalService){return{openModal:function(createModifyDefaultSigDto,providerDefaultSigId){var promise=NewDefaultSigModalService.openModal$(createModifyDefaultSigDto,providerDefaultSigId).toPromise();return $q.when(promise)}}}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("RequiredScreensModal",["$uibModal",function($modal){return{openModal:function(titles){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/required-screens-modal.html",windowClass:"modal-full",controller:"RequiredScreensModalCtrl",controllerAs:"vm",resolve:{titles:function(){return titles}}}).result}}}]),angular.module("aprima-sigwriter").controller("RequiredScreensModalCtrl",["$uibModalInstance","titles",function($modalInstance,titles){function selectTitle(title){$modalInstance.close(title)}this.titles=titles,this.close=function(){selectTitle(titles[0])},this.selectTitle=selectTitle}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("SaveRxModal",["$uibModal",function($modal){return{openModal:function(savePromise){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/save-rx-modal.html",windowClass:"modal-full",controller:"SaveRxModalCtrl",controllerAs:"vm",resolve:{wrappedSavePromise:function(){return{promise:savePromise}}}}).result}}}]),angular.module("aprima-sigwriter").controller("SaveRxModalCtrl",["$uibModalInstance","ErrorService","wrappedSavePromise",function($modalInstance,ErrorService,wrappedSavePromise){var vm=this;function onFailure(error){vm.saving=!1,vm.errorMessages=ErrorService.convertToErrorMessages(error)}function onSuccess(result){$modalInstance.close(result)}vm.errorMessages=null,vm.saving=!0,vm.cancel=function(){vm.saving||$modalInstance.dismiss()},wrappedSavePromise.promise.then(onSuccess).catch(onFailure)}])}(),function(){"use strict";angular.module("aprima-sigwriter").factory("SigwriterAdditionalInfoModal",["$q","SigOptsNonFormularyAdditionalInfoModalService",function($q,SigOptsNonFormularyAdditionalInfoModalService){return{openModal:function(optionsNonFormularyAdditionalInfo,rxOptions){var promise=SigOptsNonFormularyAdditionalInfoModalService.openModal$(optionsNonFormularyAdditionalInfo,rxOptions).toPromise();return $q.when(promise)}}}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterDosingService",["toaster",function(toaster){return{showVariableDosingErrors:function(sigInstruction){if(sigInstruction.variableDosing&&sigInstruction.variableDosing.calculationErrors&&sigInstruction.variableDosing.calculationErrors.length){var message="Failed to apply variable dosing: ";message+=sigInstruction.variableDosing.calculationErrors.join(", "),toaster.error(message),sigInstruction.variableDosing=null}}}}])}(angular),function(){"use strict";angular.module("aprima-sigwriter").factory("SigwriterDrugDosageSearchModal",["$q","SigwriterDrugStrengthSearchV1ModalService",function($q,SigwriterDrugStrengthSearchV1ModalService){return{openModal:function(sigType,drug,patientId,providerId){var promise=SigwriterDrugStrengthSearchV1ModalService.openModal$(sigType,drug,patientId,providerId).toPromise().then(function(result){return result.isSuccess?result.resultValue:$q.reject(result)});return $q.when(promise)}}}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterDrugScreeningService",["$q","DrugRepository","FncRxRepository","Guid","SigwriterScreeningModal",function($q,DrugRepository,FncRxRepository,Guid,SigwriterScreeningModal){return{getClassFromSeverity:function(severity){return severity?getClassFromSeverityLevel(severity.NormalizedSeverity):""},getClassFromSeverityLevel:getClassFromSeverityLevel,getGeriatricSeverityTitle:function(geriatricFinding){return getSeverityTitle(geriatricFinding&&geriatricFinding.Severity)},getInteractionSeverityTitle:function(interactionFinding){return getSeverityTitle(interactionFinding&&interactionFinding.Severity)},getLactationSeverityTitle:function(lactationFinding){return getSeverityTitle(lactationFinding&&lactationFinding.Severity)},getMedicalConditionSeverityTitle:function(medicalConditionFinding){return getSeverityTitle(medicalConditionFinding&&medicalConditionFinding.Severity)},getPediatricSeverityTitle:function(pediatricFinding){return getSeverityTitle(pediatricFinding&&pediatricFinding.Severity)},getPregnancySeverityTitle:function(pregnancyFinding){return getSeverityTitle(pregnancyFinding&&pregnancyFinding.Severity)},isCleanScreening:isCleanScreening,performDrugScreening:function(defaultOverrideText,drug,patientId,visitId,medicationSigId){var drugScreeningPromise;drugScreeningPromise=visitId&&visitId!==Guid.empty()?FncRxRepository.getSigwriterNddDrugScreeningResults(patientId,visitId,drug,medicationSigId):DrugRepository.nddDrugScreening(patientId,drug);var screeningSuccess=!1;return drugScreeningPromise.then(function(nddScreening){return screeningSuccess=!0,showDrugScreening(defaultOverrideText,nddScreening)}).catch(function(error){if(screeningSuccess)return $q.reject(error);var deferred=$q.defer();return SigwriterScreeningModal.openModalWithPromise(drugScreeningPromise,defaultOverrideText).catch(function(modalError){deferred.reject(modalError)}).finally(function(){deferred.reject(error)}),deferred.promise})},showDrugScreening:showDrugScreening};function getClassFromSeverityLevel(severityLevel){switch(severityLevel){case 10:return"low-alert";case 20:return"moderate-alert";case 30:return"high-alert";case 40:return"severe-alert"}}function getSeverityTitle(severity){return severity?severity.Severity+": "+severity.Description:""}function isCleanScreening(nddScreening){return nddScreening&&!nddScreening.Error&&"Completed"===nddScreening.Status}function showDrugScreening(defaultOverrideText,nddScreening,readOnly,alwaysShow){var result={nddScreening:nddScreening,overrideText:null,screeningResult:nddScreening.PlainText};return isCleanScreening(nddScreening)&&!alwaysShow?$q.when(result):SigwriterScreeningModal.openModal(nddScreening,defaultOverrideText,readOnly).then(function(modalResult){return result.overrideText=modalResult.overrideText,result})}}])}(angular),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterDrugSearchService",["$q","apConfirm","DosingService","DrugCoreService","SigwriterRxService",function($q,apConfirm,DosingService,DrugCoreService,SigwriterRxService){return{createNewRxFromDrugSearchResult:createNewRxFromDrugSearchResult,updateRxFromDrugSearchResult:function(rx,drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch,patientDosingDetails){var sigType=rx.sigType,patientId=rx.patient.Id,visitInfo=rx.visit,existingRelVisitMedicationId=rx.relVisitMedicationId;return"DefaultProvider"===drugSearchResult.ResultType||rx.drug.UnitOfMeasureId!==drugSearchResult.Drug.UnitOfMeasureId?createNewRxFromDrugSearchResult(sigType,drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch,patientId,!1,!0,visitInfo,patientDosingDetails).then(function(rx){return rx.relVisitMedicationId=existingRelVisitMedicationId,rx}):function(sigType,drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch,patientId,isConsentSupported,visitInfo,patientDosingDetails,existingRx){return DrugCoreService.validateDrugs(drugSearchResult.Drug,sigType).then(function(){var deferred=$q.defer(),validationResult=validateDrugSearchResult(drugSearchResult,isConsentSupported);if(!validationResult.success){var error="validation error";return validationResult.invalid?error="invalid drug search result":validationResult.invalidResultType?error="need to support additional drug result types":validationResult.consentUnsupported&&(error="consent is required but not supported by the calling screen"),deferred.reject(error),deferred.promise}var promises=[];return useEnhancedDrugSearch&&promises.push(SigwriterRxService.loadFromEnhancedDrugSearchWithExistingRx(sigType,patientId,drugSearchResult,switchToGeneric,visitInfo,patientDosingDetails,existingRx)),$q.all(promises).then(function(results){var rx=results[0];if(rx.drug&&dosingSuggestion){var source=rx.instructions[0];source=SigwriterRxService.updateInstructionFromDosingSuggestion(source,dosingSuggestion,rx.rxOptions)}deferred.resolve(rx)}).catch(function(error){deferred.reject(error)}),deferred.promise})}(sigType,drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch,patientId,!0,visitInfo,patientDosingDetails,rx)},validateDrugSearchResult:validateDrugSearchResult};function createNewRxFromDrugSearchResult(sigType,drugSearchResult,switchToGeneric,dosingSuggestion,useEnhancedDrugSearch,patientId,allowAsIs,isConsentSupported,visitInfo,patientDosingDetails){var creationPromise=DrugCoreService.validateDrugs(drugSearchResult.Drug,sigType).then(function(){var relPatientMedicationId,sigId,canSkipSigwriter=drugSearchResult.CanSkipSigwriter,deferred=$q.defer(),validationResult=validateDrugSearchResult(drugSearchResult,isConsentSupported);if(!validationResult.success){var error="validation error";return validationResult.invalid?error="invalid drug search result":validationResult.invalidResultType?error="need to support additional drug result types":validationResult.consentUnsupported&&(error="consent is required but not supported by the calling screen"),deferred.reject(error),deferred.promise}"Patient"!==drugSearchResult.ResultType&&"DefaultProvider"!==drugSearchResult.ResultType||(sigId=drugSearchResult.SigId,relPatientMedicationId=drugSearchResult.RelPatientMedicationId);var acceptConfirmation=canSkipSigwriter&&relPatientMedicationId&&sigId&&allowAsIs?apConfirm("Accept the medication as is?","Yes","No"):$q.when(!1),promises=[acceptConfirmation];return useEnhancedDrugSearch?promises.push(SigwriterRxService.loadFromEnhancedDrugSearch(sigType,patientId,drugSearchResult,switchToGeneric,visitInfo,patientDosingDetails)):sigId?promises.push(SigwriterRxService.loadFromExistingSig(sigType,patientId,sigId)):promises.push(SigwriterRxService.loadFromDrugSearchResult(sigType,patientId,drugSearchResult)),$q.all(promises).then(function(results){var useAsIs=results[0],rx=results[1];if(rx.drug&&dosingSuggestion){var source=rx.instructions[0];source=SigwriterRxService.updateInstructionFromDosingSuggestion(source,dosingSuggestion,rx.rxOptions)}useAsIs&&(rx.relPatientMedicationId=relPatientMedicationId),deferred.resolve(rx)}).catch(function(error){deferred.reject(error)}),deferred.promise});return creationPromise}function validateDrugSearchResult(drugSearchResult,isConsentSupported){var result={consentUnsupported:!1,invalid:!1,invalidResultType:!1,success:!0};if(!drugSearchResult||!drugSearchResult.Drug)return result.invalid=!0,result.success=!1,result;switch(drugSearchResult.ResultType){case"Drug":case"Mfu":case"Patient":case"DefaultProvider":break;default:result.invalidResultType=!0,result.success=!1}return drugSearchResult.Drug.RequiresConsent&&!isConsentSupported&&(result.consentUnsupported=!0,result.success=!1),result}}])}(angular),function(angular){"use strict";window.angular.module("aprima-sigwriter").factory("SigwriterDxProblemsService",[function(){var displayOrderDxList=[],displayOrderProblemList=[];return{clearDisplayOrderLists:clearDisplayOrderLists,getSortOrderForSelectedDxProblemItem:function(dxProblemItem){return""+(dxProblemItem.IsProblem?1:0)+dxProblemItem.DisplayOrder+(dxProblemItem.Name&&dxProblemItem.Name.toLowerCase())},sortSelectedDxProblemsByDisplayOrder:function(displayDxProblemItems,selectedDxProblemItems){_.forEach(selectedDxProblemItems,function(dxProblemItem){var item=_.find(displayDxProblemItems,{Uid:dxProblemItem.Uid});item&&(item.DisplayOrder=dxProblemItem.DisplayOrder)}),clearDisplayOrderLists();var sortedDisplayItems=[];return _.forEach(_.orderBy(_.filter(displayDxProblemItems,function(item){return!1===item.IsProblem&&0!==item.DisplayOrder}),["DisplayOrder"],["asc"]),function(dxItem){sortedDisplayItems.push(dxItem),updateSelectedDxList(dxItem.Icd9Code,dxItem.Icd10Code,"PUSH")}),_.forEach(_.orderBy(_.filter(displayDxProblemItems,function(item){return!1===item.IsProblem&&0===item.DisplayOrder}),["Name"],["asc"]),function(dxItem){sortedDisplayItems.push(dxItem)}),_.forEach(_.orderBy(_.filter(displayDxProblemItems,function(item){return!0===item.IsProblem&&0!==item.DisplayOrder}),["DisplayOrder"],["asc"]),function(problemItem){sortedDisplayItems.push(problemItem),updateSelectedProblemList(problemItem.DiseaseId,"PUSH")}),_.forEach(_.orderBy(_.filter(displayDxProblemItems,function(item){return!0===item.IsProblem&&0===item.DisplayOrder}),["Name"],["asc"]),function(problemItem){sortedDisplayItems.push(problemItem)}),sortedDisplayItems},updateSelectedDxProblemList:function(dxProblemItem){dxProblemItem.IsProblem?updateSelectedProblemList(dxProblemItem.DiseaseId,dxProblemItem.selected?"PUSH":"REMOVE"):updateSelectedDxList(dxProblemItem.Icd9Code,dxProblemItem.Icd10Code,dxProblemItem.selected?"PUSH":"REMOVE")},updateDisplayOrderForSelectedDxProblemList:function(selectedDxProblemItems){_.forEach(selectedDxProblemItems,function(item){item.DisplayOrder=0});var displayOrder=1;return _.forEach(displayOrderDxList,function(displayOrderItem){var selectedDx=_.filter(selectedDxProblemItems,function(selectedDxProblemItem){return selectedDxProblemItem.Icd9Code===displayOrderItem.Icd9Code&&selectedDxProblemItem.Icd10Code===displayOrderItem.Icd10Code});selectedDx&&0<selectedDx.length&&(selectedDx[0].DisplayOrder=displayOrder++)}),displayOrder=1,_.forEach(displayOrderProblemList,function(displayOrderItem){var selectedProblem=_.filter(selectedDxProblemItems,function(selectedDxProblemItem){return selectedDxProblemItem.DiseaseId===displayOrderItem.DiseaseId});selectedProblem&&0<selectedProblem.length&&(selectedProblem[0].DisplayOrder=displayOrder++)}),selectedDxProblemItems}};function clearDisplayOrderLists(){displayOrderDxList=[],displayOrderProblemList=[]}function updateSelectedDxList(icd9Code,icd10Code,action){"PUSH"===action?displayOrderDxList.push({Icd9Code:icd9Code,Icd10Code:icd10Code}):_.remove(displayOrderDxList,function(item){return item.Icd9Code===icd9Code&&item.Icd10Code===icd10Code})}function updateSelectedProblemList(diseaseId,action){"PUSH"===action?displayOrderProblemList.push({DiseaseId:diseaseId}):_.remove(displayOrderProblemList,function(item){return item.DiseaseId===diseaseId})}}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterFormularyDetailsModal",["$uibModal",function($modal){return{openModal:function(details,isInfoAvailable){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/sigwriterFormularyDetailsModal.html",windowClass:"modal-full",controller:"SigwriterFormularyDetailsModalCtrl",controllerAs:"vm",resolve:{details:function(){return details},isInfoAvailable:function(){return isInfoAvailable}}}).result}}}]),angular.module("aprima-sigwriter").controller("SigwriterFormularyDetailsModalCtrl",["$uibModalInstance","details","isInfoAvailable",function($modalInstance,details,isInfoAvailable){var vm=this;vm.details=details,vm.isInfoAvailable=isInfoAvailable,vm.changeMedication=function(drug,pharmacy){$modalInstance.close({chosenMedication:{drug:drug,pharmacy:pharmacy}})},vm.cancel=function(){$modalInstance.dismiss()},vm.ok=function(){$modalInstance.close({})}}])}(window.angular),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterRxBenefitDetailsModal",["$uibModal",function($modal){return{openModal:function(eligibility){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/sigwriterRxBenefitDetailsModal.html",windowClass:"modal-full",controller:"SigwriterRxBenefitDetailsModalCtrl",controllerAs:"vm",resolve:{eligibility:function(){return eligibility}}}).result}}}]),angular.module("aprima-sigwriter").controller("SigwriterRxBenefitDetailsModalCtrl",["$uibModalInstance","eligibility",function($modalInstance,eligibility){this.eligibility=eligibility,this.cancel=function(){$modalInstance.dismiss()}}])}(window.angular),function(){"use strict";angular.module("aprima-sigwriter").factory("SigwriterRxService",["$q","MetadataRepository","SigwriterRxServiceTs",function($q,MetadataRepository,SigwriterRxServiceTs){return{addOtherDrugsForScreening:function(rx,otherDrugs){SigwriterRxServiceTs.addOtherDrugsForScreening(rx,otherDrugs)},getDrugDetail:function(medId,patientId,relPatientMedicationId,sigId,rxId){var promise=SigwriterRxServiceTs.getDrugDetail(medId,patientId,rxId,relPatientMedicationId,sigId).toPromise();return $q.when(promise)},getDrugDetailHistory:function(medId,patientId,medicationId){var promise=SigwriterRxServiceTs.getDrugDetailHistory(medId,patientId,medicationId).toPromise();return $q.when(promise)},getDrugDocumentation:function(medId,ndc,patientId,briefMode,rxId){var promise=SigwriterRxServiceTs.getDrugDocumentation(medId,ndc,patientId,briefMode,rxId).toPromise();return $q.when(promise)},getDrugScreeningResults:function(patientId,medId,rxId){var promise=SigwriterRxServiceTs.getDrugScreeningResults(patientId,medId,rxId).toPromise();return $q.when(promise)},getNddDrugScreeningResults:function(patientId,medId,rxId){var promise=SigwriterRxServiceTs.getNddDrugScreeningResults(patientId,medId,rxId).toPromise();return $q.when(promise)},getPrimaryMedication:function(details,sigOptionsNonFormulary){return SigwriterRxServiceTs.getPrimaryMedication(details,sigOptionsNonFormulary)},getRemainingSigCharacters:function(sigInstruction,sigDirectionsMaxLength){return SigwriterRxServiceTs.getRemainingSigCharacters(sigInstruction,sigDirectionsMaxLength)},getRemainingPharmacyInstructionsCharacters:function(pharmacyInstructions){return SigwriterRxServiceTs.getRemainingPharmacyInstructionsCharacters(pharmacyInstructions)},getMaxPharmacyInstructionsCharacters:function(){return SigwriterRxServiceTs.getMaxPharmacyInstructionsCharacters()},getRemainingInternalNoteCharacters:function(internalNote){return SigwriterRxServiceTs.getRemainingInternalNoteCharacters(internalNote)},getMaxInternalNoteCharacters:function(){return SigwriterRxServiceTs.getMaxInternalNoteCharacters()},getStoredSigwriterResults:function(){return SigwriterRxServiceTs.getStoredSigwriterResults()},getStoredWizardOptions:function(){return SigwriterRxServiceTs.getStoredWizardOptions()},isDaysValid:function(instruction){return SigwriterRxServiceTs.isDaysValid(instruction)},isDxInPharmacyInstructions:function(instructions){return SigwriterRxServiceTs.isDxInPharmacyInstructions(instructions)},loadFromDrugSearchResult:function(sigType,patientId,dsr){var promise=SigwriterRxServiceTs.loadFromDrugSearchResult$(sigType,patientId,dsr).toPromise().then(fixRxOptions);return $q.when(promise)},loadFromEnhancedDrugSearch:function(sigType,patientId,dsr,switchToGeneric,visitInfo,patientDosingDetails){var promise=SigwriterRxServiceTs.loadFromEnhancedDrugSearch$(sigType,patientId,dsr,switchToGeneric,visitInfo,patientDosingDetails).toPromise().then(fixRxOptions);return $q.when(promise)},loadFromEnhancedDrugSearchWithExistingRx:function(sigType,patientId,dsr,switchToGeneric,visitInfo,patientDosingDetails,existingRx){var promise=SigwriterRxServiceTs.loadFromEnhancedDrugSearchWithExistingRx$(sigType,patientId,dsr,switchToGeneric,visitInfo,existingRx).toPromise().then(fixRxOptions);return $q.when(promise)},loadFromExistingRelVisitMedication:function(sigType,patientId,relVisitMedicationId,visitInfo,getStateFromDesktopContext){var promise=SigwriterRxServiceTs.loadFromExistingRelVisitMedication(sigType,patientId,relVisitMedicationId,visitInfo,getStateFromDesktopContext).then(fixRxOptions);return $q.when(promise)},loadFromExistingSig:function(sigType,patientId,sigId){var promise=SigwriterRxServiceTs.loadFromExistingSig$(sigType,patientId,sigId).toPromise().then(fixRxOptions);return $q.when(promise)},loadFromSigwriterResultsDto:function(sigType,patientId,sigwriterResultsDto,visitInfo,patientDosingDetails){var promise=SigwriterRxServiceTs.loadFromSigwriterResultsDto(sigType,patientId,sigwriterResultsDto,visitInfo,patientDosingDetails).then(fixRxOptions);return $q.when(promise)},mapToVisitDto:function(rx){return SigwriterRxServiceTs.mapToVisitDto(rx)},mapToVisitPrescriptions:function(rx){return SigwriterRxServiceTs.mapToVisitPrescriptions(rx)},mapToSigwriterResultsDto:function(rx){return SigwriterRxServiceTs.mapToSigwriterResultsDto(rx)},mergeDefaultSigWithCreateModifyDefaultSigDto:function(defaultSig,createModifyDefaultSigDto){return SigwriterRxServiceTs.mergeDefaultSigWithCreateModifyDefaultSigDto(defaultSig,createModifyDefaultSigDto)},newCreateModifyDefaultSigDto:function(rx){return SigwriterRxServiceTs.newCreateModifyDefaultSigDto(rx)},newId:function(){return SigwriterRxServiceTs.newId()},newRxInstructions:function(rx){return SigwriterRxServiceTs.newRxInstructions(rx)},setRxDrug:function(rx,drug){return SigwriterRxServiceTs.setRxDrug(rx,drug)},setRxInstructions:function(rx,source,isCallerSigwriterShell){return SigwriterRxServiceTs.setRxInstructions(rx,source,isCallerSigwriterShell)},setStoredSigwriterResults:function(rx,visit){SigwriterRxServiceTs.setStoredSigwriterResults(rx,visit)},setStoredWizardOptions:function(previousTransition,rx,isDeferredRx,isFixedPharmacy){SigwriterRxServiceTs.setStoredWizardOptions(previousTransition,rx,isDeferredRx,isFixedPharmacy)},startWizardRefill:function(patientId,medicationSigId,relPatientMedicationId){var promise=SigwriterRxServiceTs.startWizardRefill(patientId,medicationSigId,relPatientMedicationId).toPromise().then(function(modalResult){return modalResult.isSuccess?fixRxOptions(modalResult.resultValue):$q.reject({cancelled:!0})});return $q.when(promise)},toggleQuantityType:function(instruction){return SigwriterRxServiceTs.toggleQuantityType(instruction)},updateInstructionFromDosingSuggestion:function(instruction,dosingSuggestion,rxOptions){return SigwriterRxServiceTs.updateInstructionFromDosingSuggestion(instruction,dosingSuggestion,rxOptions)}};function fixRxOptions(rx){var rxOptions=rx.rxOptions;return rxOptions.metadata={visit:MetadataRepository.parseRawMetadata(rxOptions.rawMetadata.visit),sig:rxOptions.rawMetadata.sig?MetadataRepository.parseRawMetadata(rxOptions.rawMetadata.sig):void 0},rx}}])}(),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterScreeningModal",["$uibModal","$q",function($modal,$q){return{openModal:function(nddScreening,overrideText,readOnly){return openModalWithPromise($q.when(nddScreening),overrideText,readOnly)},openModalWithPromise:openModalWithPromise};function openModalWithPromise(nddScreeningPromise,overrideText,readOnly){var modal=$modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/sigwriterScreeningModal.html",windowClass:"modal-full ajs-modal-emds",controller:"SigwriterScreeningModalCtrl",controllerAs:"vm",resolve:{wrappedNddScreeningPromise:function(){return{promise:nddScreeningPromise}},overrideText:function(){return overrideText},readOnly:function(){return readOnly}}});return modal.result}}]),angular.module("aprima-sigwriter").controller("SigwriterScreeningModalCtrl",["$uibModalInstance","DeviceSettings","ErrorService","GeneralNotesModal","GeneralNoteTypeKeys","overrideText","readOnly","wrappedNddScreeningPromise",function($modalInstance,DeviceSettings,ErrorService,GeneralNotesModal,GeneralNoteTypeKeys,overrideText,readOnly,wrappedNddScreeningPromise){var vm=this;function onFailure(error){vm.nddScreeningErrorMessages=ErrorService.convertToErrorMessages(error)}function onSuccess(result){vm.nddScreening=result}vm.loadingDrugScreening=!0,vm.nddScreening=null,vm.nddScreeningErrorMessages=null,vm.overrideText=overrideText,vm.readOnly=readOnly,vm.cancel=function(){$modalInstance.dismiss({cancelled:!0})},vm.ok=function(){$modalInstance.close({overrideText:vm.overrideText})},vm.onClickOverrideReason=function(){GeneralNotesModal.openModal("Reason for Override",vm.overrideText,!0,0,GeneralNoteTypeKeys.DrugScreeningOverrideReason).then(function(overrideText){vm.overrideText=overrideText})},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},wrappedNddScreeningPromise.promise.then(onSuccess).catch(onFailure).finally(function(){vm.loadingDrugScreening=!1})}])}(window.angular),function(angular){"use strict";angular.module("aprima-sigwriter").factory("SigwriterSigDetailsModal",["$uibModal",function($modal){return{openModal:function(patientDetails,rxOptions,rxParameters,sigInstruction,sigOptionsNonFormulary,initialField){return $modal.open({backdrop:"static",templateUrl:"/sigwriter/views/modals/sigwriterSigDetailsModal.html",windowClass:"modal-full",controller:"SigwriterSigDetailsModalCtrl",controllerAs:"vm",resolve:{initialField:function(){return initialField},patientDetails:function(){return patientDetails},rxOptions:function(){return rxOptions},rxParameters:function(){return rxParameters},sigInstruction:function(){return sigInstruction},sigOptionsNonFormulary:function(){return sigOptionsNonFormulary}}}).result}}}]),angular.module("aprima-sigwriter").controller("SigwriterSigDetailsModalCtrl",["$uibModalInstance","DeviceSettings","toaster","initialField","patientDetails","rxOptions","rxParameters","sigInstruction","sigOptionsNonFormulary",function($modalInstance,DeviceSettings,toaster,initialField,patientDetails,rxOptions,rxParameters,sigInstruction,sigOptionsNonFormulary){var vm=this,updatedSigInstruction=null;function cancel(){$modalInstance.dismiss()}function validateAll(){var isValid=!0;return vm.tabletSigDetailsForm.$valid||(toaster.error("SIG is not valid. Please correct all errors."),isValid=!1),isValid}vm.initialField=initialField,vm.patientDetails=patientDetails,vm.rxOptions=rxOptions,vm.rxParameters=rxParameters,vm.sigInstruction=sigInstruction,vm.sigOptionsNonFormulary=sigOptionsNonFormulary,vm.cancel=cancel,vm.ok=function(){updatedSigInstruction?validateAll()&&$modalInstance.close({sigInstruction:updatedSigInstruction}):cancel()},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},vm.updateSigInstruction=function(modifiedSigInstruction){updatedSigInstruction=modifiedSigInstruction}}])}(window.angular);
//# sourceMappingURL=aprima-sigwriter.min.js.map