﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="UTF-8"/>
  <xsl:template match="/">
    <link href="ActivityMonitor.css" type="text/css" rel="stylesheet"/>
    <table width="100%">
      <thead>
        <tr>
          <td></td>
          <td colspan="2" align="center">Timeout</td>
          <td></td>
          <td colspan="2" align="center">Mode</td>
          <td colspan="3" align="center">Max Concurrent</td>
          <td></td>
          <td colspan="2" align="center">Calls</td>
        </tr>
        <tr>
          <td>
            Name
          </td>
          <td align="right">
            Open
          </td>
          <td align="right">
            Close
          </td>
          <td>
            State
          </td>
          <td>
            Concurrency
          </td>
          <td>
            Instance Context
          </td>
          <td align="right">
            Calls
          </td>
          <td align="right">
            Instances
          </td>
          <td align="right">
            Sessions
          </td>
          <td align="right">
            Instances
          </td>
          <td align="right">
            Outstanding
          </td>
          <td align="right">
            Total
          </td>
        </tr>
      </thead>
      <tbody>
        <xsl:for-each select="process/services/service">
          <tr>
            <xsl:if test="position() mod 2 = 0">
              <xsl:attribute name="class">oddrow</xsl:attribute>
            </xsl:if>
            <xsl:if test="position() mod 2 = 1">
              <xsl:attribute name="class">evenrow</xsl:attribute>
            </xsl:if>
            <td>
              <xsl:value-of select="@name"/>
            </td>
            <td align="right">
              <xsl:value-of select="@open_timeout"/>
            </td>
            <td align="right">
              <xsl:value-of select="@close_timeout"/>
            </td>
            <td>
              <xsl:value-of select="@state"/>
            </td>
            <td>
              <xsl:value-of select="@concurrency_mode"/>
            </td>
            <td>
              <xsl:value-of select="@instance_context_mode"/>
            </td>
            <td align="right">
              <xsl:value-of select="@max_concurrent_calls"/>
            </td>
            <td align="right">
              <xsl:value-of select="@max_concurrent_instances"/>
            </td>
            <td align="right">
              <xsl:value-of select="@max_concurrent_sessions"/>
            </td>
            <xsl:for-each select="categoryName/counter">
            <td align="right">
              <xsl:value-of select="@value"/>
            </td>
          </xsl:for-each>
          </tr>
        </xsl:for-each>
      </tbody>
    </table>
  </xsl:template>
</xsl:stylesheet>