window.onload = function () {
    window.ui = SwaggerUIBundle({
        url: buildSwaggerDocUrl(),
        dom_id: '#swagger-ui',
        deepLinking: true,
        presets: [
            SwaggerUIBundle.presets.apis,
            SwaggerUIStandalonePreset
        ],
        plugins: [
            SwaggerUIBundle.plugins.DownloadUrl
        ],
        layout: "StandaloneLayout"
    });
};

function buildSwaggerDocUrl() {
    var pathArray = window.location.pathname.split('/');
    var newPathname = "";
    for (i = 0; i < pathArray.length - 2; i++) {
        newPathname += pathArray[i].toLowerCase();
        newPathname += "/";
    }
    newPathname += "swagger/docs/v1";
    return window.location.protocol + "//" + window.location.host + newPathname;
}