<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:sdtc="urn:hl7-org:sdtc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 http://xreg2.nist.gov:8080/hitspValidation/schema/cdar2c32/infrastructure/cda/C32_CDA.xsd" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"   xmlns:ms="urn:schemas-microsoft-com:xslt"  xmlns:dt="urn:schemas-microsoft-com:datatypes">
<xsl:output method="xml" omit-xml-declaration="no" indent="yes"/>
	<xsl:template match="CCD">
		<ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 http://healthinfo.med.dal.ca/hl7intro/CDA_R2_NormativeWebEdition/infrastructure/cda/CDA.xsd">
			<realmCode code="US"/>
	<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
	<templateId root="2.16.840.1.113883.10.20.12" />
	<templateId root= "2.16.840.1.113883.3.249.11.100.1"/>
	<xsl:apply-templates select="//Header"/>
	<component>
		<structuredBody>
			<component>
				<section>
					<templateId root="2.16.840.1.113883.3.249.11.200"/>
					<!-- templateId uniquely identifies the measure -->
					<code code="55185-3" codeSystem="2.16.840.1.113883.6.1" />
					<title>Measure Set: CMS EHR Measure Set</title>
					<text>PQRI EHR 2012 Measure set</text>
					<component>
						<section>
							<!-- EHR QRDA measure-specific template ID for each measure in this Section -->
							<xsl:apply-templates select="//MeasureHeader"/>
							<!--<templateId root="2.16.840.1.113883.3.249.11.2"/>
							<templateId root="2.16.840.1.113883.3.249.11.3"/>
							<templateId root="2.16.840.1.113883.3.249.11.4"/>
							<templateId root="2.16.840.1.113883.3.249.11.5"/>
							<templateId root="2.16.840.1.113883.3.249.11.6"/>
							<templateId root="2.16.840.1.113883.3.249.11.51"/>
							<templateId root="2.16.840.1.113883.3.249.11.52"/>
							<templateId root="2.16.840.1.113883.3.249.11.53"/>							
							<templateId root="2.16.840.1.113883.3.249.11.7"/>
							<templateId root="2.16.840.1.113883.3.249.11.8"/>
							<templateId root="2.16.840.1.113883.3.249.11.9"/>
							<templateId root="2.16.840.1.113883.3.249.11.10"/>
							<templateId root="2.16.840.1.113883.3.249.11.11"/>
							<templateId root="2.16.840.1.113883.3.249.11.54"/>
							<templateId root="2.16.840.1.113883.3.249.11.55"/>
							<templateId root="2.16.840.1.113883.3.249.11.56"/>
							<templateId root="2.16.840.1.113883.3.249.11.57"/>
							<templateId root="2.16.840.1.113883.3.249.11.58"/>
							<templateId root="2.16.840.1.113883.3.249.11.59"/>
							<templateId root="2.16.840.1.113883.3.249.11.60"/>
							<templateId root="2.16.840.1.113883.3.249.11.15"/>							
							<code code="55186-1" codeSystem="2.16.840.1.113883.6.1" />
							<title>Measure Section</title>
							<text>
								<list>
									<item> Measure #1: Diabetes Mellitus: Hemoglobin A1c Poor Control in Diabetes Mellitus  </item>
									<item> Measure #2: Diabetes Mellitus: Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus  </item>
									<item> Measure #3: Diabetes Mellitus: High Blood Pressure Control in Diabetes Mellitus  </item>
									<item> Measure #5: Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)  </item>
									<item> Measure #7: Coronary Artery Disease (CAD): Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction (MI)  </item>
									<item> Measure #110: Preventive Care and Screening: Influenza Immunization for Patients >= 50 Years  </item>
									<item> Measure #111: Preventive Care and Screening: Pneumonia Vaccination for Patients 65 Years and Older  </item>
									<item> Measure #112: Preventive Care and Screening: Screening Mammography  </item>
									<item> Measure #113: Preventive Care and Screening: Colorectal Cancer Screening  </item>
									<item> Measure #124: Health Information Technology (HIT): Adoption/Use of Electronic Health Records (EHR)  </item>
									<item> Measure eRx: Adoption/Use of Medication Electronic Prescribing Measure – QRDA Cat I template  </item>
									<item> Measure #39: Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older  </item>
									<item> Measure #47: Advance Care Plan  </item>
									<item> Measure #48: Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older  </item>
									<item> Measure #128: Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up  </item>
									<item> Measure #173: Preventive Care and Screening: Unhealthy Alcohol Use-Screening  </item>
									<item> Measure #237: Hypertension (HTN): Blood Pressure Measurement - QRDA Cat I template   </item>
									<item> Measure #238: Drugs to be avoided in the Elderly - QRDA Cat I template  </item>
									<item> Measure #239: Weight Assessment and Counseling for Children and Adolescents - QRDA Cat I template   </item>
									<item> Measure #226: Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention  - QRDA Cat I template   </item>
									<item> Measure #240: Childhood Immunization Status - QRDA Cat I template  </item>
								</list>
							</text>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-1" codeSystem="2.16.840.1.113883.3.249.12" displayName=" Measure #1: Diabetes Mellitus: Hemoglobin A1c Poor Control in Diabetes Mellitus"/>
									<text>Measure #1: Diabetes Mellitus: Hemoglobin A1c Poor Control in Diabetes Mellitus</text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
										<code code="PhysicianQualityReporting-2" codeSystem="2.16.840.1.113883.3.249.12" displayName="  Measure #2: Diabetes Mellitus: Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus "/>
									<text> Measure #2: Diabetes Mellitus: Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-3" codeSystem="2.16.840.1.113883.3.249.12" displayName=" Measure #3: Diabetes Mellitus: High Blood Pressure Control in Diabetes Mellitus"/>
									<text>High Blood Pressure Control in Diabetes Mellitus</text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-5" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #5: Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD) "/>
									<text>Measure #5: Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)  </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-7" codeSystem="2.16.840.1.113883.3.249.12" displayName=" Measure #7: Coronary Artery Disease (CAD): Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction (MI)"/>
									<text> Measure #7: Coronary Artery Disease (CAD): Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction (MI) </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-39" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #39: Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older"/>
									<text>Measure #39: Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-47" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #47: Advance Care Plan"/>
									<text>Measure #47: Advance Care Plan</text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-48" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #48: Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older"/>
									<text>Measure #48: Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older</text>
									<statusCode code="completed" />
								</act>
							</entry>							
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-110" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #110: Preventive Care and Screening: Influenza Immunization for Patients >= 50 Years "/>
									<text> Measure #110: Preventive Care and Screening: Influenza Immunization for Patients >= 50 Years</text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-111" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #111: Preventive Care and Screening: Pneumonia Vaccination for Patients 65 Years and Older"/>
									<text>Measure #111: Preventive Care and Screening: Pneumonia Vaccination for Patients 65 Years and Older </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-112" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #112: Preventive Care and Screening: Screening Mammography"/>
									<text>Measure #112: Preventive Care and Screening: Screening Mammography</text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-113" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #113: Preventive Care and Screening: Colorectal Cancer Screening"/>
									<text> Measure #113: Preventive Care and Screening: Colorectal Cancer Screening</text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-124" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #124: Health Information Technology (HIT): Adoption/Use of Electronic Health Records (EHR)"/>
									<text>Measure #124: Health Information Technology (HIT): Adoption/Use of Electronic Health Records (EHR) </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-128" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #128: Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up"/>
									<text>Measure #128: Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-173" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #173: Preventive Care and Screening: Unhealthy Alcohol Use-Screening"/>
									<text>Measure #173: Preventive Care and Screening: Unhealthy Alcohol Use-Screening </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-237" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #0013: Hypertension (HTN): Blood Pressure Measurement"/>
									<text>Measure #237: Hypertension (HTN): Blood Pressure Measurement - QRDA Cat I template </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-238" codeSystem="2.16.840.1.113883.3.249.12" displayName="NQF Measure #0022: Drugs to be Avoided in the Elderly"/>
									<text>Measure #238: Drugs to be avoided in the Elderly - QRDA Cat I template</text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-239" codeSystem="2.16.840.1.113883.3.249.12" displayName="NQF Measure #0024: Body Mass Index (BMI) 2 through 18 years of age"/>
									<text>Measure #239: Weight Assessment and Counseling for Children and Adolescents - QRDA Cat I template </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-226" codeSystem="2.16.840.1.113883.3.249.12" displayName="NQF Measure #0028: Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention"/>
									<text>Measure #226: Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention  - QRDA Cat I template </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="PhysicianQualityReporting-240" codeSystem="2.16.840.1.113883.3.249.12" displayName="NQF Measure #0038: Childhood Immunization Status"/>
									<text>Measure #240: Childhood Immunization Status - QRDA Cat I template </text>
									<statusCode code="completed" />
								</act>
							</entry>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="DEF">
									<code code="eRx" codeSystem="2.16.840.1.113883.3.249.11.12" displayName="Measure eRx: Adoption/Use of Medication Electronic Prescribing Measure – QRDA Cat I template"/>
									<text>Measure eRx: Adoption/Use of Medication Electronic Prescribing Measure – QRDA Cat I template </text>
									<statusCode code="completed" />
								</act>
							</entry>-->							
							<component>
								<section>
									<code code="55187-9" codeSystem="2.16.840.1.113883.6.1" />
									<title>Reporting Parameters</title>
									<entry>
										<act classCode="ACT" moodCode="EVN">
											<code code="252116004" codeSystem="2.16.840.1.113883.6.96"
											displayName="Observation Parameters" />
											<effectiveTime>
												<low>
													<xsl:attribute name="value">
														<xsl:value-of select="messageStartDate" />
													</xsl:attribute>
												</low>
												<!-- The first day of the period reported. -->
												<high >
													<xsl:attribute name="value">
														<xsl:value-of select="messageEndDate" />
													</xsl:attribute>
												</high>
												<!-- The last day of the period reported. -->
											</effectiveTime>
										</act>
									</entry >
								</section>
							</component>
							<component>
								<section>
									<code code="55188-7" codeSystem="2.16.840.1.113883.6.1" />
									<title>Patient Data </title>
									<xsl:apply-templates select="//Problems"/>
									<xsl:apply-templates select="//Procedure"/>
									<xsl:apply-templates select="//Payer"/>
									<!-- 
									<xsl:apply-templates select="//Alerts"/>-->
									<xsl:apply-templates select="//Medication"/>
									<xsl:apply-templates select="//Immunizations"/>
									<xsl:apply-templates select="//Result"/>
									<xsl:apply-templates select="//Vital"/>
									<xsl:apply-templates select="//Structural"/>
									<xsl:apply-templates select="//AdvanceDirective"/>									
									<xsl:apply-templates select="//Plan"/>
									<xsl:apply-templates select="//Enounter"/>
									<xsl:apply-templates select="//Social"/>
									<xsl:apply-templates select="//Equipment"/>
									<xsl:apply-templates select="//FamilyHistory"/>
								</section>
							</component>
						</section>
					</component>
				</section>
			</component>
		</structuredBody>
	</component>
</ClinicalDocument>
</xsl:template>
	<xsl:template name="Header"  match="//Header">
		<id root="2.16.840.1.113883.3.638" extension="c266">
			<xsl:attribute name="extension">
				<xsl:value-of select="//documentationOf/providerNPI" />
			</xsl:attribute>
		</id>
		<code code="55182-0" displayName="Summarization of Quality measure with Patient data" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
		<title>Quality Measure Report</title>
		<effectiveTime>
			<xsl:attribute name="value">
				<xsl:value-of select="DocumentDateTime" />
			</xsl:attribute>
		</effectiveTime>
		<confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
		<setId root="2.16.840.1.113883.19.4" extension="c266"/>
		<versionNumber value="2"/>
		<recordTarget>
			<patientRole>
				<!-- patient SSN -->
				<xsl:if test="//patient/ssn != ''">
					<id root="2.16.840.1.113883.4.1">
					<xsl:attribute name="extension">
						<xsl:value-of select="patient/ssn" />
					</xsl:attribute>
					</id>
				</xsl:if >
				<xsl:if test="//patient/ssn = ''">
					<id root="2.16.840.1.113883.4.1" extension="111111111">
					</id>
				</xsl:if >				
				<xsl:if test="//patient/address/streetAddress1 != ''">	
				<addr>
					<streetAddressLine>
						<xsl:value-of select="//patient/address/streetAddress1"/>
					</streetAddressLine>
					<xsl:if test="//patient/address/city != ''">
					<city>
						<xsl:value-of select="//patient/address/city"/>
					</city>
					</xsl:if >
					<xsl:if test="//patient/address/state != ''">
					<state>
						<xsl:value-of select="//patient/address/state"/>
					</state>
					</xsl:if >
					<xsl:if test="//patient/address/postalCode != ''">
					<postalCode>
						<xsl:value-of select="//patient/address/postalCode"/>
					</postalCode>
					</xsl:if >
				</addr>
				</xsl:if >
				<xsl:if test="//patient/phonenumber != ''">	
				<telecom>
					<xsl:attribute name="value">
						<xsl:value-of select="//patient/phonenumber" />
					</xsl:attribute>					
				</telecom>
					</xsl:if >
				<patient>
					<name use="L">
						<given>
							<xsl:value-of select="//patient/name/given"/>
						</given>
						<family>
							<xsl:value-of select="//patient/name/family"/>
						</family>
					</name>
					<administrativeGenderCode codeSystem="2.16.840.1.113883.5.1">
						<xsl:attribute name="code">
							<xsl:value-of select="//patient/genderCode" />
						</xsl:attribute>
					</administrativeGenderCode>
					<birthTime>
						<xsl:attribute name="value">
							<xsl:value-of select="//patient/birthTime" />
						</xsl:attribute>
					</birthTime>
					<xsl:if test="//patient/raceCode != ''">	
					<raceCode codeSystem="2.16.840.1.113883.5.104" code="2131-1">
						<xsl:attribute name="code">
							<xsl:value-of select="//patient/raceCode" />
						</xsl:attribute>
					</raceCode>
					</xsl:if>
					<xsl:if test="//patient/raceCode = ''">
						<raceCode codeSystem="2.16.840.1.113883.5.104" code="2131-1">
							</raceCode>
					</xsl:if>	
					<xsl:if test="//patient/ethnicGroupCode != ''">	
					<ethnicGroupCode codeSystem="2.16.840.1.113883.5.50">
						<xsl:attribute name="code">
							<xsl:value-of select="//patient/ethnicGroupCode" />
						</xsl:attribute>
					</ethnicGroupCode>
				</xsl:if>
				<xsl:if test="//patient/ethnicGroupCode = ''">	
				<ethnicGroupCode codeSystem="2.16.840.1.113883.5.50" code="2186-5">
				</ethnicGroupCode>
				</xsl:if>
				</patient>
				<providerOrganization>
					<!--provider NPI-->
					<id root="2.16.840.1.113883.4.6">
						<xsl:attribute name="extension">
							<xsl:value-of select="//patient/provider/providerNPI" />
						</xsl:attribute>
					</id>
					<name>
						<!--<xsl:value-of select="//organization/name"/>-->
						<xsl:value-of select="substring(//organization/name,0,50)"/>					
					</name>
					<telecom value="mailto:tinUser@aClinic.com">
					<xsl:attribute name="value">
						<xsl:value-of select="//documentationOf/phonenumber" />
					</xsl:attribute>
					</telecom>
					<xsl:if test="//organization/address/streetAddress1 != ''">
					<addr>
							<streetAddressLine>
								<xsl:value-of select="//organization/address/streetAddress1"/>
							</streetAddressLine>
						<xsl:if test="//organization/address/city != ''">
							<city>
								<xsl:value-of select="//organization/address/city"/>
							</city>
						</xsl:if>
						<state>
							<xsl:value-of select="//organization/address/state"/>
						</state>
						<xsl:if test="//organization/address/postalCode!= ''">
							<postalCode>
								<xsl:value-of select="//organization/address/postalCode"/>
							</postalCode>
						</xsl:if>
					</addr>
					</xsl:if> 
					<asOrganizationPartOf>
						<wholeOrganization>
							<!--provider TIN -->
							<id root="2.16.840.1.113883.4.2" >
								<xsl:attribute name="extension">
									<xsl:value-of select="//patient/provider/providerTPIN/value" />
								</xsl:attribute>
							</id>
						<telecom value="mailto:tinUser@aClinic.com">
						<xsl:attribute name="value">
							<xsl:value-of select="//patient/provider/phonenumber" />
						</xsl:attribute>
					</telecom>
						</wholeOrganization>
					</asOrganizationPartOf>
				</providerOrganization>
			</patientRole>
		</recordTarget>
		<author>
			<time value="20080401"/>
			<assignedAuthor>
				<id root="2.16.840.1.113883.3.249.6" extension="110001"/>
			</assignedAuthor>
		</author>
		<informant>
			<assignedEntity>
				<id nullFlavor="NA"/>
				<representedOrganization>
			<id root="2.16.840.1.113883.19.5"/>
					<name>
						<xsl:value-of select="//organization/name"/>
					</name>
				</representedOrganization>
			</assignedEntity>
		</informant>
		<custodian>
			<assignedCustodian>
				<representedCustodianOrganization>
			<id root="2.16.840.1.113883.19.5"/>
					<name>
						<xsl:value-of select="//organization/name"/>
					</name>
				</representedCustodianOrganization>
			</assignedCustodian>
		</custodian>
		<legalAuthenticator>
			<time value="20100121185118" />
			<signatureCode code="S" />
			<assignedEntity>
				<id nullFlavor="NI" />
				<representedOrganization>
			<id root="2.16.840.1.113883.19.5" />
					<name>
						<xsl:value-of select="//organization/name"/>
					</name>
				</representedOrganization>
			</assignedEntity>
		</legalAuthenticator>
		<participant typeCode="PRF">
			<functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88"/>
			<associatedEntity classCode="PROV">
				<id root="1.3.6.4.1.4.1.2835.1">
          <xsl:if test="//patient/PCP/externalId != ''">
  					<xsl:attribute name="extension">
  						<xsl:value-of select="//patient/PCP/externalId" />
  					</xsl:attribute>
          </xsl:if>
				</id>
				<associatedPerson>
					<name>
						<xsl:if test="//patient/PCP/name/prefix != ''">
							<prefix>
								<xsl:value-of select="//patient/PCP/name/prefix"/>
							</prefix>
						</xsl:if>
						<given>
							<xsl:value-of select="//patient/PCP/name/given"/>
						</given>
						<family>
							<xsl:value-of select="//patient/PCP/name/family"/>
						</family>
					</name>
				</associatedPerson>
			</associatedEntity>
		</participant>
		<xsl:for-each select="//documentationOf">
			<documentationOf>
				<serviceEvent>
					<xsl:if test ="questionCodeTypeName != 'HCPCS'">
					<code codeSystem="2.16.840.1.113883.6.12" codeSystemName="C4">
						<xsl:attribute name="code">
							<xsl:value-of select="questionCode" />
						</xsl:attribute>
					</code>
						</xsl:if>
					<xsl:if test ="questionCodeTypeName = 'HCPCS'">
					<code codeSystem="2.16.840.1.113883.6.14" codeSystemName="C4">
						<xsl:attribute name="code">
							<xsl:value-of select="questionCode" />
						</xsl:attribute>
					</code>
					</xsl:if>
					<effectiveTime>
						<low>
							<xsl:attribute name="value">
								<xsl:value-of select="visitDate" />
							</xsl:attribute>
						</low>
						<high>
							<xsl:attribute name="value">
								<xsl:value-of select="visitDate" />
							</xsl:attribute>
						</high>
					</effectiveTime>
					<performer typeCode="PRF">
						<assignedEntity>
							<!-- provider NPI -->
							<id root="2.16.840.1.113883.4.6">
								<xsl:attribute name="extension">
									<xsl:value-of select="providerNPI" />
								</xsl:attribute>
							</id>
							<xsl:if test ="providertypecode !=''">
								<code codeSystem="2.16.840.1.113883.6.101" codeSystemName="ProviderCodes" >
									<xsl:attribute name="code">
										<xsl:value-of select="providertypecode" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="providertypename" />
									</xsl:attribute>
								</code>
							</xsl:if>
							<xsl:if test ="providertypecode =''">
								<code code="59058001" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT" displayName="General Physician"/>
							</xsl:if>
							<xsl:if test ="address/streetAddress1 =''">
							<addr>
								<streetAddressLine>
									<xsl:value-of select="address/streetAddress1" />
								</streetAddressLine>
								<xsl:if test="address/city != ''">
								<city>
									<xsl:value-of select="address/city" />
								</city>
								</xsl:if >
									<xsl:if test="address/state != ''">
								<state>
									<xsl:value-of select="address/state" />
								</state>
									</xsl:if >
								<xsl:if test="address/postalCode != ''">
								<postalCode>
									<xsl:value-of select="address/postalCode" />
								</postalCode>
								</xsl:if >
							</addr>
							</xsl:if >
							<assignedPerson>
								<name>
									<xsl:if test ="name/prefix !=''">
										<prefix>
											<xsl:value-of select="name/prefix" />
										</prefix>
									</xsl:if>
									<given>
										<xsl:value-of select="name/given" />
									</given>
									<family>
										<xsl:value-of select="name/family" />
									</family>
									<xsl:if test ="name/suffix !=''">
										<suffix>
											<xsl:value-of select="name/suffix" />
										</suffix>
									</xsl:if>
								</name>
							</assignedPerson>
						</assignedEntity>
					</performer>
				</serviceEvent>
			</documentationOf>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="Problems"  match="//Problems">
	<xsl:if test ="//ProblemEntry/problemCode != '' or //ProblemEntryProc/problemCode != '' or //ProblemEntryProc1P/problemCode != '' or //ProblemEntryProc2P/problemCode != '' or //ProblemEntryProc3P/problemCode != ''  or //ProblemSnomedEntry/problemCode != '' or //ProblemEntryLoinc/problemCode != '' or //ProblemEntryHxSN/ProblemEntryRelationship/problemCode != ''  or //ProblemEntryPESN/problemCode != ''  or //ProblemEntryHpiSN/problemCode != '' ">
		<component>
			<section>
				<templateId root="2.16.840.1.113883.10.20.1.11" />
				<code code="11450-4" displayName="Problem list" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
				<title>Conditions or Problems</title>
				<text>
					PROBLEM SECTION
				</text>
				<xsl:for-each select="//ProblemEntry">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN"  negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<id root="2.16.840.1.113883.19.5.9" extension="123501"/>
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.103">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									</value>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime1" />
													</xsl:attribute>
											</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProblemEntryProc">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN"  negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<id root="2.16.840.1.113883.19.5.9" extension="123501"/>
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<xsl:if test ="problemCodeTypeName != 'HCPCS'">
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.12">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									</value>
									</xsl:if>
									<xsl:if test ="problemCodeTypeName = 'HCPCS'">
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.14">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									</value>
									</xsl:if>									
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime1" />
											</xsl:attribute>
									</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProblemEntryProc1P">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN" negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<id root="2.16.840.1.113883.19.5.9" extension="123501"/>
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<xsl:if test ="problemCodeTypeName != 'HCPCS'">
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.12">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									<qualifier>
										<name code="1P"/>
									</qualifier>									
									</value>
									</xsl:if>
									<xsl:if test ="problemCodeTypeName = 'HCPCS'">
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.14">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									<qualifier>
										<name code="1P"/>
									</qualifier>									
									</value>
									</xsl:if>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime1" />
											</xsl:attribute>
											</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>	
				<xsl:for-each select="//ProblemEntryProc2P">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN" negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<xsl:if test ="problemCodeTypeName != 'HCPCS'">
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.12">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									<qualifier>
										<name code="2P"/>
									</qualifier>									
									</value>
									</xsl:if>
									<xsl:if test ="problemCodeTypeName = 'HCPCS'">
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.14">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									<qualifier>
										<name code="2P"/>
									</qualifier>									
									</value>										
									</xsl:if>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime1" />
											</xsl:attribute>
											</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>	
				<xsl:for-each select="//ProblemEntryProc3P">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN" negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<id root="2.16.840.1.113883.19.5.9" extension="123501"/>
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<xsl:if test ="problemCodeTypeName != 'HCPCS'">
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.12">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
										<qualifier>
											<name code="3P"/>
										</qualifier>										
									</value>
									</xsl:if>
									<xsl:if test ="problemCodeTypeName = 'HCPCS'">
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.14">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									<qualifier>
										<name code="3P"/>
									</qualifier>									
									</value>
									</xsl:if>

									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
												<xsl:attribute name="value">
													<xsl:value-of select="effectiveTime1" />
												</xsl:attribute>
											</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProblemSnomedEntry">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN" negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<id root="2.16.840.1.113883.19.5.9" extension="123501"/>
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.96">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									</value>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime1" />
											</xsl:attribute>
									</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProblemEntryLoinc">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN" negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<id root="2.16.840.1.113883.19.5.9" extension="123501"/>
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.1">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									</value>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime1" />
											</xsl:attribute>
									</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProblemEntryHxSN/ProblemEntryRelationship">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN"  negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<id root="2.16.840.1.113883.19.5.9" extension="123501"/>
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.96">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									</value>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime1" />
													</xsl:attribute>
											</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>	
				<xsl:for-each select="//ProblemEntryPESN">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN"  negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<id root="2.16.840.1.113883.19.5.9" extension="123501"/>
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.96">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									</value>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime1" />
													</xsl:attribute>
											</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>	
				<xsl:for-each select="//ProblemEntryHpiSN">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123001"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN"  negationInd="false">
									<templateId root="2.16.840.1.113883.10.20.1.28"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.8"/>
									<!-- Problem observation template -->
									<id root="2.16.840.1.113883.19.5.9" extension="123501"/>
									<!--<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>-->
									<code code="282291009" displayName="Diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime>
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.96">
										<xsl:attribute name="code">
											<xsl:value-of select="problemCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="problemName" />
										</xsl:attribute>
									</value>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.50"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.12"/>
											<!-- Problem status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime1" />
													</xsl:attribute>
											</effectiveTime>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
				</xsl:for-each>										
			</section>
		</component>
	</xsl:if>
</xsl:template>
<xsl:template name="Procedure"  match="//Procedure">
	<xsl:if test ="//ProcedureEntry/questionCode != '' or //ProcedureEntryDiag/questionCode != '' or //ProcedureSnomedEntryDiag/questionCode != '' or //ProcedureEntryHxSN/ProcedureEntryRelationship/questionCode != ''  or //ProcedureEntryPESN/questionCode != ''  or //ProcedureEntryHpiSN/questionCode != '' ">
		<component>
			<section>
				<templateId root="2.16.840.1.113883.10.20.1.12" />
				<code code="47519-4" displayName="History of procedures" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
				<title>All interventional, surgical, diagnostic, or therapeutic procedures or treatments </title>
				<text>
					PROCEDURE SECITON
				</text>
				<xsl:for-each select="//ProcedureEntry">
			<entry typeCode="DRIV">
				<procedure classCode="PROC" moodCode="EVN"  negationInd="false">
					<templateId root="2.16.840.1.113883.10.20.1.29"/>
					<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
					<!-- Procedure activity template -->
					<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
					<xsl:if test ="questionCodeTypeName != 'HCPCS'">
						<code codeSystem="2.16.840.1.113883.6.12" >
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<xsl:attribute name="displayName">
								<xsl:value-of select="questionName" />
							</xsl:attribute>
						</code>
					</xsl:if>
					<xsl:if test ="questionCodeTypeName = 'HCPCS'">
						<code codeSystem="2.16.840.1.113883.6.14" >
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<xsl:attribute name="displayName">
								<xsl:value-of select="questionName" />
							</xsl:attribute>
						</code>
					</xsl:if>
					<statusCode code="completed"/>
					<effectiveTime >
						<xsl:attribute name="value">
							<xsl:value-of select="dateTime" />
						</xsl:attribute>
					</effectiveTime>
				</procedure>
			</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProcedureEntryDiag">
					<entry typeCode="DRIV">
						<procedure classCode="PROC" moodCode="EVN"  negationInd="false">
							<templateId root="2.16.840.1.113883.10.20.1.29"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
							<!-- Procedure activity template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
							<xsl:if test ="questionCodeTypeName != 'HCPCS'">
								<code codeSystem="2.16.840.1.113883.6.104" >
									<xsl:attribute name="code">
										<xsl:value-of select="questionCode" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="questionName" />
									</xsl:attribute>
								</code>
							</xsl:if>
							<statusCode code="completed"/>
							<effectiveTime >
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</effectiveTime>
						</procedure>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProcedureEntryDiag2">
					<entry typeCode="DRIV">
						<procedure classCode="PROC" moodCode="EVN" negationInd="false">
							<templateId root="2.16.840.1.113883.10.20.1.29"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
							<!-- Procedure activity template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
							<!--<xsl:if test ="questionCodeTypeName != 'HCPCS'">-->
								<code codeSystem="2.16.840.1.113883.6.103" >
									<xsl:attribute name="code">
										<xsl:value-of select="questionCode2" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="questionName2" />
									</xsl:attribute>
								</code>
							<!--</xsl:if>-->
							<statusCode code="completed"/>
							<effectiveTime >
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime2" />
								</xsl:attribute>
							</effectiveTime>
						</procedure>
					</entry>
				</xsl:for-each>	
				<xsl:for-each select="//ProcedureSnomedEntryDiag">
					<entry typeCode="DRIV">
						<procedure classCode="PROC" moodCode="EVN" negationInd="false">
							<templateId root="2.16.840.1.113883.10.20.1.29"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
							<!-- Procedure activity template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
							<!--<xsl:if test ="questionCodeTypeName != 'HCPCS'">-->
								<code codeSystem="2.16.840.1.113883.6.96" >
									<xsl:attribute name="code">
										<xsl:value-of select="questionCode" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="questionName" />
									</xsl:attribute>
								</code>
							<!--</xsl:if>-->
							<statusCode code="completed"/>
							<effectiveTime >
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</effectiveTime>
						</procedure>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProcedureEntryHxSN/ProcedureEntryRelationship">
					<entry typeCode="DRIV">
						<procedure classCode="PROC" moodCode="EVN" negationInd="false">
							<templateId root="2.16.840.1.113883.10.20.1.29"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
							<!-- Procedure activity template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
								<code codeSystem="2.16.840.1.113883.6.96" >
									<xsl:attribute name="code">
										<xsl:value-of select="questionCode" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="questionName" />
									</xsl:attribute>
								</code>
							<!--</xsl:if>-->
							<statusCode code="completed"/>
							<effectiveTime >
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</effectiveTime>
						</procedure>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProcedureEntryPESN">
					<entry typeCode="DRIV">
						<procedure classCode="PROC" moodCode="EVN" negationInd="false">
							<templateId root="2.16.840.1.113883.10.20.1.29"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
							<!-- Procedure activity template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
							<!--<xsl:if test ="questionCodeTypeName != 'HCPCS'">-->
								<code codeSystem="2.16.840.1.113883.6.96" >
									<xsl:attribute name="code">
										<xsl:value-of select="questionCode" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="questionName" />
									</xsl:attribute>
								</code>
							<!--</xsl:if>-->
							<statusCode code="completed"/>
							<effectiveTime >
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</effectiveTime>
						</procedure>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ProcedureEntryHpiSN">
					<entry typeCode="DRIV">
						<procedure classCode="PROC" moodCode="EVN" negationInd="false">
							<templateId root="2.16.840.1.113883.10.20.1.29"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
							<!-- Procedure activity template -->
							<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
							<!--<xsl:if test ="questionCodeTypeName != 'HCPCS'">-->
								<code codeSystem="2.16.840.1.113883.6.96" >
									<xsl:attribute name="code">
										<xsl:value-of select="questionCode" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="questionName" />
									</xsl:attribute>
								</code>
							<!--</xsl:if>-->
							<statusCode code="completed"/>
							<effectiveTime >
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</effectiveTime>
						</procedure>
					</entry>
				</xsl:for-each>					
			</section>
		</component>
	</xsl:if>
</xsl:template>
<xsl:template name="Payer"  match="//Payer">
<component>
	<section>
		<templateId root="2.16.840.1.113883.10.20.1.9" />
		<code code="48768-6" displayName="Payment sources" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
		<title>Payer Section </title>
		<text>
			patient’s payers, whether “third party” insurance, self-pay, other payer or guarantor, or some combination of payers, and is used to define which entity is the responsible fiduciary for the financial aspects of a patient’s care.
		</text>
		<xsl:for-each select="//payerEntry">
			<xsl:if test="PQRIInsuranceCarrier = 'Medicare' or  PQRIInsuranceCarrier = 'MEDICARE'">
			<entry typeCode="DRIV">
				<act classCode="ACT" moodCode="DEF">
					<templateId root="2.16.840.1.113883.10.20.1.20"/>
					<!-- Coverage activity template -->
					<id root="2.16.840.1.113883.19.5.10" extension="103209"/>
					<code code="48768-6" codeSystem="2.16.840.1.113883.6.1" displayName="Payment sources"/>
					<statusCode code="completed"/>
					<entryRelationship typeCode="COMP">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.26"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.7"/>
							<!-- Policy activity template -->
							<xsl:if test="planGroupID != ''">
								<id root="2.16.840.1.113883.19.5.10">
									<xsl:attribute name="extension">
										<xsl:value-of select="planGroupID" />
									</xsl:attribute>
								</id>
							</xsl:if>
							<xsl:if test="planGroupID = '' and planMemberID != '' ">
								<id root="2.16.840.1.113883.19.5.10">
									<xsl:attribute name="extension">
										<xsl:value-of select="planMemberID" />
									</xsl:attribute>
								</id>
							</xsl:if>
							<xsl:if test="planGroupID = '' and planMemberID = '' ">
								<id root="2.16.840.1.113883.19.5.10" extension ="103210">
								</id>
							</xsl:if>
							<code code="PUBLICPOL" codeSystem="2.16.840.1.113883.5.4"
							displayName="Public healthcare"/>
							<statusCode code="completed"/>
							<performer typeCode="PRF">
								<assignedEntity>
									<!-- Medicare -->
									<!--<xsl:if test="insurancePlanType != ''">
										<id root="2.16.840.1.113883.12.86" >
										<xsl:attribute name="extension">
											<xsl:value-of select="insurancePlanType" />
										</xsl:attribute>
										</id>
									</xsl:if>
									<xsl:if test="insurancePlanType = ''">
										<id root="2.16.840.1.113883.12.86" extension="OT"/>
									</xsl:if>	
									<representedOrganization>
										<name>CMS</name>
									</representedOrganization>-->
									
									<xsl:if test="PQRIInsuranceCarrier != ''">
										<id root="2.16.840.1.113883.12.86" extension="MB"/>
									</xsl:if>
									<representedOrganization>
										<name>
										<xsl:value-of select="InsurancePlanName" />
										</name>
									</representedOrganization>
									
								</assignedEntity>
							</performer>
							<participant typeCode="COV">
								<participantRole>
									<!-- Medicare patients needs provide either SSN or HIC number -->
									<!-- SSN for the patient is given below -->
									<!--<id root="2.16.840.1.113883.4.1" extension="654329876">-->
									<!--<id root="2.16.840.1.113883.3.249.13" extension="654329876">
										<xsl:attribute name="extension">
											<xsl:value-of select="planMemberID" />
										</xsl:attribute>
									</id>-->
									<xsl:if test="translate(planMemberID,'0123456789','000000000')= '000000000A'">
										<id root="2.16.840.1.113883.3.249.13" extension="654329876">
										<xsl:attribute name="extension">
											<xsl:value-of select="planMemberID" />
										</xsl:attribute>
										</id>
									</xsl:if>	
									<xsl:if test="translate(planMemberID,'0123456789','000000000')!= '000000000A' and subscriber/ssn != ''">
										<id root="2.16.840.1.113883.4.1" extension="654329876">
										<xsl:attribute name="extension">
											<xsl:value-of select="subscriber/ssn" />
										</xsl:attribute>
										</id>
									</xsl:if>	
									
									<xsl:if test="translate(planMemberID,'0123456789','000000000')!= '000000000A' and subscriber/ssn = ''">
										<id root="2.16.840.1.113883.4.1" extension="111111111">
											</id>
									</xsl:if>
										
									<!--<code code="SELF" codeSystem="2.16.840.1.113883.5.111" displayName="Self"/>-->
									<code codeSystem="2.16.840.1.113883.5.111">
										<xsl:attribute name="code">
											<xsl:value-of select="relationshipName" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="relationshipName" />
										</xsl:attribute>
									</code>
								</participantRole>
							</participant>
							<entryRelationship typeCode="REFR">
								<act classCode="ACT" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.19"/>
									<!-- Authorization activity template -->
									<id root="2.16.840.1.113883.19.5.10" extension="103212"/>
									<code nullFlavor="NA"/>
									<entryRelationship typeCode="SUBJ">
										<procedure classCode="PROC" moodCode="PRMS">
											<!-- <code nullFlavor="NA"/>-->
										</procedure>
									</entryRelationship>
								</act>
							</entryRelationship>
						</act>
					</entryRelationship>
				</act>
			</entry>
			</xsl:if>	
		</xsl:for-each>
	</section>
</component>
</xsl:template>
<xsl:template name="Alerts"  match="//Alerts">
		<xsl:if test ="//AlertsEntry/AlertEntryRelationship/questionName != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.2" />
					<code code="448765-2" displayName="Allergies" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
					<title>Alerts (Allergies, Adverse Reactions) Section </title>
					<text>
						Any allergies, adverse reactions, and alerts that are pertinent to the patient’s current or past medical history.
					</text>
					<xsl:for-each select="//AlertsEntry">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.27"/>
							<!-- Problem act template -->
							<id root="2.16.840.1.113883.19.5.10" extension="100015"/>
							<code nullFlavor="NA"/>
							<entryRelationship typeCode="SUBJ">
								<observation classCode="OBS" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.18"/>
									<!-- Alert observation template -->
									<id root="2.16.840.1.113883.19.5.10" extension="100016"/>
									<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>
									<statusCode code="completed"/>
									<effectiveTime>
										<low>
											<xsl:attribute name="value">
												<xsl:value-of select="AlertEntryRelationship/recordDate" />
											</xsl:attribute>
										</low>
									</effectiveTime>
									<value xsi:type="CD" code="281647001" codeSystem="2.16.840.1.113883.6.96" displayName="Adverse reaction to substance"/>
									<participant typeCode="CSM">
										<participantRole classCode="MANU">
											<playingEntity classCode="MMAT">
												<xsl:if test ="AlertEntryRelationship/questionRxNormCode != ''">
													<code codeSystem="2.16.840.1.113883.6.96">
														<xsl:attribute name="code">
															<xsl:value-of select="AlertEntryRelationship/questionRxNormCode" />
														</xsl:attribute>
														<xsl:attribute name="displayName">
															<xsl:value-of select="AlertEntryRelationship/questionName" />
														</xsl:attribute>
													</code>
													</xsl:if>
													<xsl:if test ="AlertEntryRelationship/questionRxNormCode = ''">
														<xsl:if test ="AlertEntryRelationship/questionRxNormCode != ''">
															<code code="NA" codeSystem="2.16.840.1.113883.6.96">
																<xsl:attribute name="displayName">
																	<xsl:value-of select="AlertEntryRelationship/questionName" />
																</xsl:attribute>
															</code>
														</xsl:if>
												</xsl:if>
											</playingEntity>
										</participantRole>
									</participant>
									<entryRelationship typeCode="MFST" inversionInd="true">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.54"/>
											<!-- Reaction observation template -->
											<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>
											<statusCode code="completed"/>
											<value xsi:type="CD" code="247472004" codeSystem="2.16.840.1.113883.6.96">
												<xsl:attribute name="displayName">
													<xsl:value-of select="AlertEntryRelationship/answerName" />
												</xsl:attribute>
											</value>
										</observation>
									</entryRelationship>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.39"/>
											<!-- Alert status observation template -->
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
											<statusCode code="completed"/>
											<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96" 
											displayName="Active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entryRelationship>
						</act>
					</entry>
					</xsl:for-each>
				</section>
			</component>
		</xsl:if>
	</xsl:template>
<xsl:template name="Medication"  match="//Medication">
	<xsl:if test ="//MedicationEntry/brandName != ''">
		<component>
			<section>
				<templateId root="2.16.840.1.113883.10.20.1.8" />
				<code code="10160-0" displayName="History of medication use" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
				<title>Medication Section </title>
				<text>
					Patient's Medications.
				</text>
				<xsl:for-each select="//MedicationEntry">
					<entry typeCode="DRIV">
						<substanceAdministration classCode="SBADM" moodCode="EVN" negationInd="false">
							<templateId root="2.16.840.1.113883.10.20.1.24"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.28"/>
							<!-- Medication activity template -->
							<id root="2.16.840.1.113883.19.5.10" extension="100016"/>
							<statusCode code="active"/>
							<xsl:if test ="itemStartDate != ''">
								<effectiveTime xsi:type="IVL_TS">
									<low>
										<xsl:attribute name="value">
											<xsl:value-of select="itemStartDate" />
										</xsl:attribute>
									</low>
								</effectiveTime>
							</xsl:if>
							<xsl:if test ="itemStartDate = ''">
								<effectiveTime nullFlavor="UNK"/>
							</xsl:if>
							<effectiveTime xsi:type="PIVL_TS" operator="A">
								<period value="24" unit="h"/>
							</effectiveTime>
							<xsl:if test ="routeCode != ''">
								<routeCode  codeSystem="2.16.840.1.113883.5.112" codeSystemName="RouteOfAdministration">
									<xsl:attribute name="code">
										<xsl:value-of select="routeCode" />
									</xsl:attribute>
								</routeCode>
							</xsl:if>
							<doseQuantity value="1"/>
							<consumable>
								<manufacturedProduct>
									<templateId root="2.16.840.1.113883.10.20.1.53"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.13"/>
									<!-- Product template -->
									<manufacturedMaterial>
										<code codeSystem="2.16.840.1.113883.6.88">
											<xsl:attribute name="code">
												<xsl:value-of select="productCode" />
											</xsl:attribute>
											<xsl:attribute name="displayName">
												<xsl:value-of select="brandName" />
											</xsl:attribute>
											<originalText>
												<xsl:value-of select="brandName" />
											</originalText>
										</code>
									</manufacturedMaterial>
								</manufacturedProduct>
							</consumable>
						</substanceAdministration>
					</entry>
				</xsl:for-each>
			</section>
		</component>
	</xsl:if>
</xsl:template>
<xsl:template name="Immunizations"  match="//Immunizations">
	<xsl:if test ="//ImmunizationEntry/VaccineCode != '' or //ImmunizationEntryProc/VaccineCode != '' or //ImmunizationEntryDiag/VaccineCode != ''">
		<component>
			<section>
				<templateId root="2.16.840.1.113883.10.20.1.6" />
				<code code="11369-6" displayName="History of immunizations" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
				<title>Immunizations Section </title>
				<text>
					The Immunizations section defines a patient’s current immunization status and pertinent immunization history
				</text>
				<xsl:for-each select="//ImmunizationEntry">
<xsl:if test ="VaccineCode != ''">
			<entry typeCode="DRIV">
				<substanceAdministration classCode="SBADM" moodCode="EVN"  negationInd="false">
					<templateId root="2.16.840.1.113883.10.20.1.24"/>
					<templateId root="2.16.840.1.113883.3.249.11.100.28"/>	
					<!-- 
					Medication activity template -->
					<id root="2.16.840.1.113883.19.5.10" extension="1723677"/>
					<statusCode code="completed"/>
					<xsl:if test ="AdministeredDateTime != ''">
						<effectiveTime xsi:type="IVL_TS">
							<low value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="AdministeredDateTime" />
								</xsl:attribute>
							</low>
						</effectiveTime>
					</xsl:if>
					<xsl:if test ="AdministeredDateTime = '' and AdministeredDateTime1 != ''">
						<effectiveTime xsi:type="IVL_TS">
							<low value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="AdministeredDateTime1" />
								</xsl:attribute>
							</low>
						</effectiveTime>
					</xsl:if>	
					<xsl:if test ="VaccineRoute1 != '' and VaccineRoute != ''">
					<routeCode codeSystem="2.16.840.1.113883.5.112" codeSystemName="RouteOfAdministration">
						<xsl:attribute name="code">
							<xsl:value-of select="VaccineRoute" />
						</xsl:attribute>
						<xsl:attribute name="displayName">
							<xsl:value-of select="VaccineRoute" />
						</xsl:attribute>
					</routeCode>
					</xsl:if>
					<xsl:if test ="VaccineRoute1 = ''">
						<routeCode nullFlavor="NA"/>
					</xsl:if>
					<consumable>
						<manufacturedProduct>
							<templateId root="2.16.840.1.113883.10.20.1.53"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.13"/>
							<!-- Product template -->
							<manufacturedMaterial>
								<code codeSystem="2.16.840.1.113883.6.59">
									<xsl:attribute name="code">
										<xsl:value-of select="VaccineCode" />
								</xsl:attribute>
									<xsl:if test ="VaccineName != ''">
										<xsl:attribute name="displayName">
											<xsl:value-of select="VaccineName" />
										</xsl:attribute>
									</xsl:if>
									<xsl:if test ="VaccineName = ''">
										<xsl:attribute name="displayName">UNK</xsl:attribute>
									</xsl:if>
									<originalText>
										<xsl:value-of select="VaccineName" />
									</originalText>
								</code>
							</manufacturedMaterial>
						</manufacturedProduct>
					</consumable>
				</substanceAdministration>
			</entry>
	</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="//ImmunizationEntryProc">
					<entry typeCode="DRIV">
						<substanceAdministration classCode="SBADM" moodCode="EVN" negationInd="false">
							<templateId root="2.16.840.1.113883.10.20.1.24"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.28"/>	
							<!-- 
					Medication activity template -->
							<id root="2.16.840.1.113883.19.5.10" extension="1723677"/>
							<statusCode code="completed"/>
							<xsl:if test ="AdministeredDateTime != ''">
								<effectiveTime xsi:type="IVL_TS">
									<low value="20100425">
										<xsl:attribute name="value">
											<xsl:value-of select="AdministeredDateTime" />
										</xsl:attribute>
									</low>
								</effectiveTime>
							</xsl:if>
							<xsl:if test ="VaccineRoute != ''">
								<routeCode codeSystem="2.16.840.1.113883.5.112" codeSystemName="RouteOfAdministration">
									<xsl:attribute name="code">
										<xsl:value-of select="VaccineRoute" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="VaccineRoute" />
									</xsl:attribute>
								</routeCode>
							</xsl:if>
							<xsl:if test ="VaccineRoute = ''">
								<routeCode nullFlavor="NA"/>
							</xsl:if>
							<consumable>
								<manufacturedProduct>
									<templateId root="2.16.840.1.113883.10.20.1.53"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.13"/>
									<!-- Product template -->
									<manufacturedMaterial>
										<code codeSystem="2.16.840.1.113883.6.12">
											<xsl:attribute name="code">
												<xsl:value-of select="VaccineCode" />
											</xsl:attribute>
											<xsl:attribute name="displayName">
												<xsl:value-of select="VaccineName" />
											</xsl:attribute>
											<originalText>
												<xsl:value-of select="VaccineName" />
											</originalText>
										</code>
									</manufacturedMaterial>
								</manufacturedProduct>
							</consumable>
						</substanceAdministration>
					</entry>
				</xsl:for-each>
				<xsl:for-each select="//ImmunizationEntryDiag">
					<entry typeCode="DRIV">
						<substanceAdministration classCode="SBADM" moodCode="EVN" negationInd="false">
							<templateId root="2.16.840.1.113883.10.20.1.24"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.28"/>
							<!-- 
					Medication activity template -->
							<id root="2.16.840.1.113883.19.5.10" extension="1723677"/>
							<statusCode code="completed"/>
							<xsl:if test ="AdministeredDateTime != ''">
								<effectiveTime xsi:type="IVL_TS">
									<center value="20100425">
										<xsl:attribute name="value">
											<xsl:value-of select="AdministeredDateTime" />
										</xsl:attribute>
									</center>
								</effectiveTime>
							</xsl:if>
							<!--<xsl:if test ="VaccineRoute != ''">
								<routeCode codeSystem="2.16.840.1.113883.5.112" codeSystemName="RouteOfAdministration">
									<xsl:attribute name="code">
										<xsl:value-of select="VaccineRoute" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="VaccineRoute" />
									</xsl:attribute>
								</routeCode>
							</xsl:if>
							-->
								<routeCode nullFlavor="NA"/>
							<consumable>
								<manufacturedProduct>
									<templateId root="2.16.840.1.113883.10.20.1.53"/>
									<!-- Product template -->
									<manufacturedMaterial>
										<code codeSystem="2.16.840.1.113883.6.103">
											<xsl:attribute name="code">
												<xsl:value-of select="VaccineCode" />
											</xsl:attribute>
											<xsl:attribute name="displayName">
												<xsl:value-of select="VaccineName" />
											</xsl:attribute>
											<originalText>
												<xsl:value-of select="VaccineName" />
											</originalText>
										</code>
									</manufacturedMaterial>
								</manufacturedProduct>
							</consumable>
						</substanceAdministration>
					</entry>
				</xsl:for-each>
			</section>
		</component>
	</xsl:if>
</xsl:template>
	<xsl:template name="Result"  match="//Result">
		<xsl:if test ="(//ObservationLionc/ObservationUnits != '' and //ObservationLionc/ObservationItemCode != '' ) or //ObservationOrder/ProcedureUid  != '' or //ObservationSNOMED/ObservationItemCode !='' ">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.14" />
					<code code="30954-2" displayName="Relevant diagnostic tests and/or laboratory data" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
					<title>Result Section </title>
					<text>
						This section contains the results of observations generated by laboratories, imaging procedures, and other procedures. The scope includes hematology, chemistry, serology, virology, toxicology, microbiology, plain x-ray, ultrasound, CT, MRI, angiography, cardiac echo, nuclear medicine, pathology, and procedure observations.
					</text>
					<xsl:for-each select="//ObservationOrder[ProcedureUid!='']">
							<entry contextConductionInd="true" typeCode="DRIV">
								<organizer classCode="BATTERY" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.32"/>
									<id root="2.16.840.1.113883.19.5.10" extension="103218"/>
									<code codeSystem="2.16.840.1.113883.6.96" code="71388002" displayName="Procedure" />
									<!--
									<code codeSystem="2.16.840.1.113883.6.12">
										<xsl:attribute name="code">
											<xsl:value-of select="ProcedureCode" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="ProcedureDesc" />
										</xsl:attribute>
									</code>-->
										<statusCode code="completed"/>
										<xsl:if test ="ResultDateTime != ''">
											<effectiveTime>
												<xsl:attribute name="value">
													<xsl:value-of select="ResultDateTime" />
												</xsl:attribute>
											</effectiveTime>
										</xsl:if>
									<component>
										<observation classCode="OBS" moodCode="EVN" negationInd="false">
											<templateId root="2.16.840.1.113883.10.20.1.31"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.10"/>
											<id root="2.16.840.1.113883.19.5.10" extension="103219"/>
											<code  codeSystem="2.16.840.1.113883.6.12" >
												<xsl:attribute name="code">
													<xsl:value-of select="ProcedureCode" />
												</xsl:attribute>
											</code>
											<statusCode code="completed"/>
											<xsl:if test ="ObservationValue/ResultDate != ''">
												<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="ResultDateTime" />
													</xsl:attribute>
												</effectiveTime>
											</xsl:if>
											<value xsi:type="PQ">
												<xsl:attribute name="unit">
													<xsl:value-of select="ObservationValue/ObservationUnits" />
												</xsl:attribute>
												<xsl:attribute name="value">
													<xsl:value-of select="ObservationValue/ObservationValue" />
												</xsl:attribute>
											</value>
											<xsl:if  test ="ObservationValue/ObservationRefLow = '' or  ObservationValue/ObservationRefHigh =''">
												<interpretationCode code="S" codeSystem="2.16.840.1.113883.5.83">
													<!--<xsl:attribute name="code">
														<xsl:value-of select="ObservationValue/AbnormalFlagCode" />
													</xsl:attribute>
													-->
												</interpretationCode>
											</xsl:if>
											<xsl:if  test ="ObservationValue/ObservationRefLow != '' and  ObservationValue/ObservationRefHigh !=''">
												<interpretationCode code="N" codeSystem="2.16.840.1.113883.5.83"/>
											</xsl:if>
											<referenceRange>
												<observationRange>
													<text>
														<xsl:value-of select="ObservationValue/ObservationRefLow" /> - <xsl:value-of select="ObservationValue/ObservationRefHigh" />
													</text>
												</observationRange>
											</referenceRange>
										</observation>
									</component>
								</organizer>
							</entry>
					</xsl:for-each>
					<xsl:for-each select="//ObservationLionc[ObservationItemCode!='']">
						<xsl:if test="ObservationUnits != ''">							
							<entry contextConductionInd="true" typeCode="DRIV">
							<organizer classCode="BATTERY" moodCode="EVN">
								<templateId root="2.16.840.1.113883.10.20.1.32"/>
								<id root="2.16.840.1.113883.19.5.10" extension="103218"/>
								<code codeSystem="2.16.840.1.113883.6.96" code="71388002" displayName="Procedure" />
								<!--
								<code codeSystem="2.16.840.1.113883.6.12">
									<xsl:attribute name="code">
										<xsl:value-of select="ProcedureCode" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="ProcedureDesc" />
									</xsl:attribute>
								</code>-->
								<statusCode code="completed"/>
								<xsl:if test ="ResultDateTime != ''">
									<effectiveTime>
										<xsl:attribute name="value">
											<xsl:value-of select="ResultDateTime" />
										</xsl:attribute>
									</effectiveTime>
								</xsl:if>
								<component >
									<observation classCode="OBS" moodCode="EVN" negationInd="false">
										<templateId root="2.16.840.1.113883.10.20.1.31"/>
										<templateId root="2.16.840.1.113883.3.249.11.100.10"/>
										<id root="2.16.840.1.113883.19.5.10" extension="103219"/>
										<code xsi:type="CE" codeSystem="2.16.840.1.113883.6.1" >
											<xsl:attribute name="code">
												<xsl:value-of select="ObservationItemCode" />
											</xsl:attribute>
											<!--<xsl:attribute name="displayName">
												<xsl:value-of select="ProcedureDesc" />
											</xsl:attribute>-->
											<xsl:if test ="ProcedureDesc != ''">
												<xsl:attribute name="displayName">
												<xsl:value-of select="ProcedureDesc" />
											</xsl:attribute>
											</xsl:if>
											<xsl:if test ="ProcedureDesc = ''">
												<xsl:attribute name="displayName">UNK</xsl:attribute>
											</xsl:if>					
										</code>
										<statusCode code="completed"/>
										<xsl:if test ="ResultDate1 != ''">
											<effectiveTime>
												<xsl:attribute name="value">
													<xsl:value-of select="ResultDate1" />
												</xsl:attribute>
											</effectiveTime>
										</xsl:if>
										<value xsi:type="PQ">
											<xsl:attribute name="unit">
												<xsl:value-of select="ObservationUnits" />
											</xsl:attribute>
											<xsl:attribute name="value">
												<xsl:value-of select="ObservationValue" />
											</xsl:attribute>
										</value>
										<xsl:if  test ="ObservationRefLow = '' or  ObservationRefHigh =''">
											<interpretationCode code="S" codeSystem="2.16.840.1.113883.5.83">
												<!--<xsl:attribute name="code">
													<xsl:value-of select="ObservationValue/AbnormalFlagCode" />
												</xsl:attribute>
												-->
											</interpretationCode>
										</xsl:if>
										<xsl:if  test ="ObservationRefLow != '' and  ObservationRefHigh !=''">
											<interpretationCode code="N" codeSystem="2.16.840.1.113883.5.83"/>
										</xsl:if>
										<referenceRange>
											<observationRange>
												<text>
													<xsl:value-of select="ObservationRefLow" /> - <xsl:value-of select="ObservationRefHigh" />
												</text>
											</observationRange>
										</referenceRange>
									</observation>
								</component>
							</organizer>
						</entry>
						</xsl:if>
					</xsl:for-each>		
					<xsl:for-each select="//ObservationSNOMED[ObservationItemCode!='']">
						<xsl:if test="ObservationUnits != ''">							
							<entry contextConductionInd="true" typeCode="DRIV">
							<organizer classCode="BATTERY" moodCode="EVN">
								<templateId root="2.16.840.1.113883.10.20.1.32"/>
								<id root="2.16.840.1.113883.19.5.10" extension="103218"/>
								<code codeSystem="2.16.840.1.113883.6.96" code="71388002" displayName="Procedure" />
								<!--
								<code codeSystem="2.16.840.1.113883.6.12">
									<xsl:attribute name="code">
										<xsl:value-of select="ProcedureCode" />
									</xsl:attribute>
									<xsl:attribute name="displayName">
										<xsl:value-of select="ProcedureDesc" />
									</xsl:attribute>
								</code>-->
								<statusCode code="completed"/>
								<xsl:if test ="ResultDateTime != ''">
									<effectiveTime>
										<xsl:attribute name="value">
											<xsl:value-of select="ResultDateTime" />
										</xsl:attribute>
									</effectiveTime>
								</xsl:if>
								<component >
									<observation classCode="OBS" moodCode="EVN" negationInd="false">
										<templateId root="2.16.840.1.113883.10.20.1.31"/>
										<templateId root="2.16.840.1.113883.3.249.11.100.10"/>
										<id root="2.16.840.1.113883.19.5.10" extension="103219"/>
										<code xsi:type="CE" codeSystem="2.16.840.1.113883.6.96" >
											<xsl:attribute name="code">
												<xsl:value-of select="ObservationItemCode" />
											</xsl:attribute>
											<!--<xsl:attribute name="displayName">
												<xsl:value-of select="ProcedureDesc" />
											</xsl:attribute>-->
											<xsl:if test ="ProcedureDesc != ''">
												<xsl:attribute name="displayName">
													<xsl:value-of select="ProcedureDesc" />
												</xsl:attribute>
											</xsl:if>
											<xsl:if test ="ProcedureDesc = ''">
												<xsl:attribute name="displayName">UNK</xsl:attribute>
											</xsl:if>
										</code>
										<statusCode code="completed"/>
										<xsl:if test ="ResultDate1 != ''">
											<effectiveTime>
												<xsl:attribute name="value">
													<xsl:value-of select="ResultDate1" />
												</xsl:attribute>
											</effectiveTime>
										</xsl:if>
										<value xsi:type="PQ">
											<xsl:attribute name="unit">
												<xsl:value-of select="ObservationUnits" />
											</xsl:attribute>
											<xsl:attribute name="value">
												<xsl:value-of select="ObservationValue" />
											</xsl:attribute>
										</value>
										<xsl:if  test ="ObservationRefLow = '' or  ObservationRefHigh =''">
											<interpretationCode code="S" codeSystem="2.16.840.1.113883.5.83">
												<!--<xsl:attribute name="code">
													<xsl:value-of select="ObservationValue/AbnormalFlagCode" />
												</xsl:attribute>
												-->
											</interpretationCode>
										</xsl:if>
										<xsl:if  test ="ObservationRefLow != '' and  ObservationRefHigh !=''">
											<interpretationCode code="N" codeSystem="2.16.840.1.113883.5.83"/>
										</xsl:if>
										<referenceRange>
											<observationRange>
												<text>
													<xsl:value-of select="ObservationRefLow" /> - <xsl:value-of select="ObservationRefHigh" />
												</text>
											</observationRange>
										</referenceRange>
									</observation>
								</component>
							</organizer>
						</entry>
						</xsl:if>
					</xsl:for-each>						
				</section>
			</component>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Vital"  match="//Vital">

		<!--<xsl:if test="//VitalEntry/weight/value != '' or //VitalEntry/height/value != '' or //VitalEntry/bp/bpSystolic/value != '' or //VitalEntry/bp/bpDiastolic/value != ''">
			-->
		<xsl:if test="//VitalEntry/bp/bpSystolic/value != '' or //VitalEntry/bp/bpDiastolic/value != '' or //VitalEntry/bmi/value != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.16" />
					<code code="8716-3" displayName="Vital signs" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
					<title>Vital Sign Section </title>
					<text>
						This section contains current and historically relevant vital signs, such as blood pressure, heart rate, respiratory rate, height, weight, body mass index, head circumference, crown-to-rump length, and pulse oximetry.
					</text>
					<xsl:for-each select="//VitalEntry">
						<xsl:if test="bp/bpSystolic/value != '' or bp/bpDiastolic/value != '' or bmi/value != ''">
							<!--
						<xsl:if test="weight/value != '' or height/value != '' or bp/bpSystolic/value != '' or bp/bpDiastolic/value != ''">-->
							<entry contextConductionInd="true" typeCode="DRIV">
								<organizer classCode="CLUSTER" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.35"/>
									<id root="2.16.840.1.113883.19.5.10" extension="116622"/>
									<code code="46680005" codeSystem="2.16.840.1.113883.6.96" displayName="Vital signs"/>
									<statusCode code="completed"/>
									<!--
									<xsl:if test="height/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<id root="2.16.840.1.113883.19.5.10" extension="112881"/>
												<code xsi:type="CE" code="50373000" codeSystem="2.16.840.1.113883.6.96"
												displayName="Body height"/>
												<statusCode code="completed"/>
												<effectiveTime >
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="cm" >
													<xsl:attribute name="value">
														<xsl:value-of select="height/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
									<xsl:if test="weight/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<id root="2.16.840.1.113883.19.5.10" extension="112882"/>
												<code xsi:type="CE" code="27113001" codeSystem="2.16.840.1.113883.6.96"
												displayName="Body weight"/>
												<statusCode code="completed"/>
												<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="kg">
													<xsl:attribute name="value">
														<xsl:value-of select="weight/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
									-->
									<xsl:if test="bp/bpSystolic/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN"  negationInd="false">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<templateId root="2.16.840.1.113883.3.249.11.100.33"/>
												<id root="2.16.840.1.113883.19.5.10" extension="112883"/>
												<code code="271649006" codeSystem="2.16.840.1.113883.6.96"
												displayName="Systolic BP"/>
												<statusCode code="completed"/>
												<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="mm[Hg]">
													<xsl:attribute name="value">
														<xsl:value-of select="bp/bpSystolic/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
									<xsl:if test="bp/bpDiastolic/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN" negationInd="false">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<templateId root="2.16.840.1.113883.3.249.11.100.33"/>
												<id root="2.16.840.1.113883.19.5.10" extension="112884"/>
												<code code="271650006" codeSystem="2.16.840.1.113883.6.96"
												displayName="Diastolic BP"/>
												<statusCode code="completed"/>
												<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="mm[Hg]">
													<xsl:attribute name="value">
														<xsl:value-of select="bp/bpDiastolic/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
									<xsl:if test="bmi/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN" negationInd="false">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<templateId root="2.16.840.1.113883.3.249.11.100.33"/>												
												<id root="2.16.840.1.113883.19.5.10" extension="112884"/>
												<code code="60621009" codeSystem="2.16.840.1.113883.6.96"
												displayName="Body mass index"/>
												<statusCode code="completed"/>
												<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="kg/m²">
													<xsl:attribute name="value">
														<xsl:value-of select="bmi/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
								</organizer>
							</entry>
						</xsl:if>
					</xsl:for-each>
				</section>
			</component>
		</xsl:if>
	</xsl:template>
	<xsl:template name="Structural"  match="//Structural">
		<!--<xsl:if test="//MedicationEntry/questionCode != '' and //StructuralEntry/questionName != '' or //StructuralEntry/questionCode != '' " >-->
		<!--<xsl:if test="//MedicationEntry/itemStartDate != '' or //VisitEntry/Medication != '0'" >-->
   <xsl:if test="//VisitEntry/SIG != '' and //VisitEntry/SIG != '0'" >
    <component>
				<section>
					<templateId root="2.16.840.1.113883.3.249.11.16"/>
					<code code="STRUCT" codeSystem="2.16.840.1.113883.3.249.12"/>
					<title>Structured data section</title>
					<text>Structured data section</text>
					<!--<xsl:for-each select="//StructuralEntry">
						<xsl:if test="questionCode != '' and questionName != ''">
					<entry>
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.3.249.11.13"/>
							<id root="2.16.840.1.113883.19.5" extension="96756495"/>
							<code  codeSystem="2.16.840.1.113883.6.14">
								<xsl:attribute name="code">
									<xsl:value-of select="questionCode" />
								</xsl:attribute>
								<xsl:attribute name="displayName">
									<xsl:value-of select="questionName" />
								</xsl:attribute>
							</code>
							<effectiveTime>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</effectiveTime>
						</act>
					</entry>
						</xsl:if>
					</xsl:for-each>-->
					<xsl:for-each select="//VisitEntry">
					<xsl:if test="SIG1 != '' and SIG1 != '0'">						
						<entry>
							<act classCode="ACT" moodCode="EVN">
								<templateId root="2.16.840.1.113883.3.249.11.14"/>
								<id root="2.16.840.1.113883.19.5" extension="96756615"/>
								<code code="G8553" codeSystem="2.16.840.1.113883.6.14" displayName="Electronic prescription has been generated using a qualified eRx system">
								</code>
								<effectiveTime>
									<xsl:attribute name="value">
										<xsl:value-of select="//VisitEntry/effectiveTime" />
									</xsl:attribute>
								</effectiveTime>
							</act>
						</entry>
					</xsl:if> 
					</xsl:for-each>
					<!--<entry>
						<act classCode="ACT" moodCode="EVN">
							<templateId root="2.16.840.1.113883.3.249.11.13"/>
							<id root="2.16.840.1.113883.19.5" extension="96756555"/>
							<code code="G8553" codeSystem="2.16.840.1.113883.6.14"
							displayName="Patient encounter was documented using a CCHIT certified EHR"/>
							<effectiveTime value="20090210"/>
						</act>
					</entry>-->
				</section>
			</component>
		</xsl:if >
	</xsl:template>
	<xsl:template name="Enounter"  match="//Enounter">
		<xsl:if test="//EnounterEntry/effectiveTime != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.3"/>
					<code code="46240-8" displayName="History of encounters" codeSystem="2.16.840.1.113883.6.1"/>
					<title>encounters</title>
					<text>encounters</text>
					<xsl:for-each select="//EnounterEntry">
						<xsl:if test="effectiveTime != ''">
							<entry typeCode="DRIV">
								<encounter classCode="ENC" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.21"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.3"/>
									<!-- Encounter activity template -->
									<id root="2.16.840.1.113883.19.5.10" extension="1032432405"/>
									<code code="GENRL" codeSystem="2.16.840.1.113883.5.4"	displayName="General"/>
									<effectiveTime>
										<xsl:attribute name="value">
											<xsl:value-of select="effectiveTime" />
										</xsl:attribute>
									</effectiveTime>
									
								<!--	
									<participant typeCode="LOC">
										<templateId root="2.16.840.1.113883.10.20.1.45"/>
										 Location participation template -->
								<!--
										<participantRole classCode="SDLOC">
											<id root="2.16.840.1.113883.19.5.10" extension="103545405"/>
											<code code="HOSP" codeSystem="2.16.840.1.113883.5.111"/>
											<playingEntity classCode="PLC">
												<name>Aprima Medical Clinic</name>
											</playingEntity>
										</participantRole>
									</participant>
								-->	
									
								</encounter>
							</entry>
						</xsl:if>
					</xsl:for-each>
				</section>
			</component>
		</xsl:if >
	</xsl:template>
	<xsl:template name="Social"  match="//Social">
		<xsl:if test="//SocialEntry/SocialEntryRelationship/answerId != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.15" />
					<code code="29762-2" displayName="Social history" codeSystem="2.16.840.1.113883.6.1" />
					<title>social history</title>
					<text>social history</text>
					<xsl:for-each select="//SocialEntry/SocialEntryRelationship">
					<xsl:if test="answerId != ''">		
					<entry typeCode="DRIV">
						<observation classCode="OBS" moodCode="EVN">
							<templateId root="2.16.840.1.113883.10.20.1.33"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.5"/>
							<!-- social history observations template -->
							<id root="2.16.840.1.113883.19.5.10" extension="1032134248"/>
							<code codeSystem="2.16.840.1.113883.6.96" >
								<xsl:attribute name="code">
									<xsl:value-of select="answerId" />
								</xsl:attribute>
								<xsl:attribute name="displayName">
									<xsl:value-of select="answerName" />
								</xsl:attribute>
							</code>
							<statusCode code="completed"/>
							<effectiveTime>
								<center >
									<xsl:attribute name="value">
										<xsl:value-of select="recordDateTime" />
									</xsl:attribute>
								</center>
							</effectiveTime>
							<entryRelationship typeCode="REFR">
								<observation classCode="OBS" moodCode="EVN">
									<!-- social history status observation template -->
									<templateId root="2.16.840.1.113883.10.20.1.56"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.4"/>
									<code code="33999-4" codeSystem="2.16.840.1.113883.6.1"/>
									<statusCode code="completed"/>
									<value xsi:type="CD" code="55561003" codeSystem="2.16.840.1.113883.6.96" displayName="active"/>
								</observation>
							</entryRelationship>
						</observation>
					</entry>
					</xsl:if >	
					</xsl:for-each>
				</section>
			</component>
		</xsl:if >
	</xsl:template>
	<xsl:template name="Plan"  match="//Plan">
		<xsl:if test="//PlanProcedureEntry/questionCode != '' or //PlanSocialEntry/PlanSocialEntryRelationship/SmokingCessation != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.10" />
					<code code="18776-5"  displayName="Treatment plan" codeSystem="2.16.840.1.113883.6.1" />
					<title>Treatment plan</title>
					<text>plan</text>
					<xsl:for-each select="//PlanProcedureEntry">
					<entry typeCode="DRIV">
						<observation classCode="OBS" moodCode="RQO">
							<templateId root="2.16.840.1.113883.10.20.1.25"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.2"/>
							<!-- Plan of Activity activity template -->
							<id root="2.16.840.1.113883.19.5.10" extension="10322552"/>
							<xsl:if test ="questionCodeTypeName != 'HCPCS'">			
							<code  codeSystem="2.16.840.1.113883.6.12">
								<xsl:attribute name="code">
									<xsl:value-of select="questionCode" />
								</xsl:attribute>
							</code>
							</xsl:if>	
							<xsl:if test ="questionCodeTypeName = 'HCPCS'">			
							<code  codeSystem="2.16.840.1.113883.6.14">
								<xsl:attribute name="code">
									<xsl:value-of select="questionCode" />
								</xsl:attribute>
							</code>
							</xsl:if>							
							<statusCode code="Aborted"/>
							<effectiveTime>
								<center value="20101001">
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
								</center>
							</effectiveTime>
						</observation>
					</entry>
					</xsl:for-each>
					<xsl:for-each select="//PlanSocialEntry">
					<xsl:if test="PlanSocialEntryRelationship/SmokingCessation != ''">	
					<entry typeCode="DRIV">
						<observation classCode="OBS" moodCode="RQO">
							<templateId root="2.16.840.1.113883.10.20.1.25"/>
							<templateId root="2.16.840.1.113883.3.249.11.100.2"/>
							<!-- Plan of Activity activity template -->
							<id root="2.16.840.1.113883.19.5.10" extension="103217678"/>
							<!--<code  codeSystem="2.16.840.1.113883.6.96" code="225323000">-->
              <code  codeSystem="2.16.840.1.113883.6.96" code="384742004">
								<!--<xsl:attribute name="code">
									<xsl:value-of select="questionCode" />
								</xsl:attribute>-->
							</code>
							<statusCode code="Aborted"/>
							<effectiveTime>
								<center value="20101001">
								<xsl:attribute name="value">
									<xsl:value-of select="PlanSocialEntryRelationship/recordDate" />
								</xsl:attribute>
								</center>
							</effectiveTime>
						</observation>
					</entry>
						</xsl:if >
					</xsl:for-each>				
					</section>
			</component>
		</xsl:if >
	</xsl:template>
	<xsl:template name="AdvanceDirective"  match="//AdvanceDirective">
		<xsl:if test="//AdvanceDirectiveEntry/RelAttachmentGroupUid != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.1" />
					<code code="42348-3"  codeSystem="2.16.840.1.113883.6.1" />
					<title>advance directives</title>
					<text>advance directives</text>
					<entry typeCode="DRIV">
						<observation classCode="OBS" moodCode="EVN">
							<templateId root='2.16.840.1.113883.10.20.1.17'/>
							<templateId root="2.16.840.1.113883.3.249.11.100.15"/>
							<!-- Advance directive observation template -->
							<id root="2.16.840.1.113883.19.5.10" extension="1123223"/>
							<code code="304251008" codeSystem="2.16.840.1.113883.6.96" displayName="Resuscitation"/>
							<statusCode code="completed"/>
							<value xsi:type="CD" code="425392003" codeSystem="2.16.840.1.113883.6.96" displayName="Current and Verified">
								<originalText>
									<reference value="#AD1"/>
								</originalText>
							</value>
							<participant typeCode="VRF">
								<templateId root='2.16.840.1.113883.10.20.1.58'/>
								<!-- Verification of an advance directive observation template -->
								<time value="20100907"/>
								<participantRole>
									<id root="2.16.840.1.113883.19.5.10"
									extension="1123424"/>
								</participantRole>
							</participant>
							<entryRelationship typeCode="REFR">
								<observation classCode="OBS" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.37"/>
									<!-- Advance directive status observation template -->
									<id root="2.16.840.1.113883.19.5.10"
									extension="11343533"/>
									<code code="33999-4" codeSystem="2.16.840.1.113883.6.1"
									displayName="Status"/>
									<statusCode code="completed"/>
									<effectiveTime xsi:type="IVL_TS"/>
									<value xsi:type="CE" code="425392003"
									codeSystem="2.16.840.1.113883.6.96"
									displayName="Current and verified"/>
								</observation>
							</entryRelationship>
						</observation>
					</entry>
				</section>
			</component>
		</xsl:if >
	</xsl:template>
	<xsl:template name="Equipment"  match="//Equipment">
		<xsl:if test="//EquipmentEntry/problemCode != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.7" />
					<code code="46264-8" codeSystem="2.16.840.1.113883.6.1" />
					<title>equipment</title>
					<text>equipment</text>
					<xsl:for-each select="//EquipmentEntry">
						<xsl:if test="problemCode != ''">
						<entry typeCode="DRIV">
								<supply classCode="SPLY" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.34"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.22"/>
									<!-- Supply activity template -->
									<id root="2.16.840.1.113883.19.5.10" extension="32328395"/>
									<statusCode code="completed"/>
									<effectiveTime xsi:type="IVL_TS">
										<center value="20051101">
										<xsl:attribute name="value">
											<xsl:value-of select="effectiveTime" />
										</xsl:attribute>
									</center>
									</effectiveTime>
									<participant typeCode="DEV">
										<participantRole classCode="MANU">
											<templateId root="2.16.840.1.113883.10.20.1.52"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.23"/>
											<!-- Product instance template -->
											<playingDevice>
												<code codeSystem="2.16.840.1.113883.6.103">
													<xsl:attribute name="code">
														<xsl:value-of select="problemCode" />
													</xsl:attribute>
													<xsl:attribute name="displayName">
														<xsl:value-of select="problemName" />
													</xsl:attribute>
												</code>
											</playingDevice>
										</participantRole>
									</participant>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.47"/>
											<!-- Medication status observation template -->
											<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"
											code="33999-4" displayName="Status"/>
											<statusCode code="completed"/>
											<value xsi:type="CE" codeSystem="2.16.840.1.113883.6.96"
											codeSystemName="SNOMED-CD" code="55561003" displayName="Active"/>
										</observation>
									</entryRelationship>
								</supply>
							</entry>	
						</xsl:if>
					</xsl:for-each>
				</section>
			</component>
		</xsl:if >
	</xsl:template>
<xsl:template name="FamilyHistory"  match="//FamilyHistory">
		<xsl:if test="//FamilyHistoryHxEntry/FamilyHistoryEntryRelationship/answerId != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.4" />
					<code code="10157-6" codeSystem="2.16.840.1.113883.6.1" />
					<title>family history</title>
					<text>family history</text>
					<xsl:for-each select="//FamilyHistoryHxEntry/FamilyHistoryEntryRelationship">
					<xsl:if test="problemCode != ''">
					<entry typeCode="DRIV">
								<organizer moodCode="EVN" classCode="CLUSTER">
									<templateId root="2.16.840.1.113883.10.20.1.23"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.20"/>
									<!-- Family history organizer template -->
									<statusCode code="completed"/>
									<subject>
										<relatedSubject classCode="PRS">
											<code code="NMTH" codeSystem="2.16.840.1.113883.5.111"
											displayName="Natural mother"/>
											<subject>
												<administrativeGenderCode code="F" codeSystem="2.16.840.1.113883.5.1"
												displayName="Female"/>
												<birthTime value="1922"/>
											</subject>
										</relatedSubject>
									</subject>
									<component>
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.22"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.21"/>
											<!-- Family history observation template -->
											<id root="2.16.840.1.113883.19.5.10" extension="32328383"/>
											<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>
											<statusCode code="completed"/>
											<effectiveTime>
												<low value="1962"/>
											</effectiveTime>
											<value xsi:type="CD"  codeSystem="2.16.840.1.113883.6.103">
													<xsl:attribute name="code">
														<xsl:value-of select="answerId" />
													</xsl:attribute>
													<xsl:attribute name="displayName">
														<xsl:value-of select="answerName" />
													</xsl:attribute>
											</value>			
										</observation>
									</component>
								</organizer>
							</entry>		
						</xsl:if>
					</xsl:for-each>
				</section>
			</component>
		</xsl:if >
	</xsl:template>
	<xsl:template name="MeasureHeader"  match="//MeasureHeader">
		<xsl:for-each select="//Measures">
			<xsl:if test="MeasureID= '1'">
				<templateId root="2.16.840.1.113883.3.249.11.2"/>
			</xsl:if >
			<xsl:if test="MeasureID= '2'">
				<templateId root="2.16.840.1.113883.3.249.11.3"/>
			</xsl:if >
			<xsl:if test="MeasureID= '3'">
				<templateId root="2.16.840.1.113883.3.249.11.4"/>
			</xsl:if >
			<xsl:if test="MeasureID= '5'">
				<templateId root="2.16.840.1.113883.3.249.11.5"/>
			</xsl:if >
			<xsl:if test="MeasureID= '6'">
				<templateId root="2.16.840.1.113883.3.249.11.201"/>
			</xsl:if >
			<xsl:if test="MeasureID= '7'">
				<templateId root="2.16.840.1.113883.3.249.11.6"/>
			</xsl:if >
			<xsl:if test="MeasureID= '8'">
				<templateId root="2.16.840.1.113883.3.249.11.202"/>
			</xsl:if >
			<xsl:if test="MeasureID= '9'">
				<templateId root="2.16.840.1.113883.3.249.11.203"/>
			</xsl:if >		
			<xsl:if test="MeasureID= '12'">
				<templateId root="2.16.840.1.113883.3.249.11.204"/>
			</xsl:if >		
			<xsl:if test="MeasureID= '18'">
				<templateId root="2.16.840.1.113883.3.249.11.205"/>
			</xsl:if >			
			<xsl:if test="MeasureID= '19'">
				<templateId root="2.16.840.1.113883.3.249.11.206"/>
			</xsl:if >		
			<xsl:if test="MeasureID= '39'">
				<templateId root="2.16.840.1.113883.3.249.11.51"/>
			</xsl:if >
			<xsl:if test="MeasureID= '47'">
				<templateId root="2.16.840.1.113883.3.249.11.52"/>
			</xsl:if >
			<xsl:if test="MeasureID= '48'">
				<templateId root="2.16.840.1.113883.3.249.11.53"/>
			</xsl:if >
			<xsl:if test="MeasureID= '53'">
				<templateId root="2.16.840.1.113883.3.249.11.207"/>
			</xsl:if >		
			<xsl:if test="MeasureID= '64'">
				<templateId root="2.16.840.1.113883.3.249.11.208"/>
			</xsl:if >	
			<xsl:if test="MeasureID= '66'">
				<templateId root="2.16.840.1.113883.3.249.11.209"/>
			</xsl:if >		
			<xsl:if test="MeasureID= '71'">
				<templateId root="2.16.840.1.113883.3.249.11.210"/>
			</xsl:if >	
			<xsl:if test="MeasureID= '72'">
				<templateId root="2.16.840.1.113883.3.249.11.211"/>
			</xsl:if >		
			<xsl:if test="MeasureID= '102'">
				<templateId root="2.16.840.1.113883.3.249.11.212"/>
			</xsl:if >					
			<xsl:if test="MeasureID= '110'">
				<templateId root="2.16.840.1.113883.3.249.11.7"/>
			</xsl:if >
			<xsl:if test="MeasureID= '111'">
				<templateId root="2.16.840.1.113883.3.249.11.8"/>
			</xsl:if >	
			<xsl:if test="MeasureID= '112'">
				<templateId root="2.16.840.1.113883.3.249.11.9"/>
			</xsl:if >
			<xsl:if test="MeasureID= '113'">
				<templateId root="2.16.840.1.113883.3.249.11.10"/>
			</xsl:if >
			<xsl:if test="MeasureID= '117'">
				<templateId root="2.16.840.1.113883.3.249.11.213"/>
			</xsl:if >
			<xsl:if test="MeasureID= '119'">
				<templateId root="2.16.840.1.113883.3.249.11.214"/>
			</xsl:if >
			<xsl:if test="MeasureID= '128'">
				<templateId root="2.16.840.1.113883.3.249.11.54"/>
			</xsl:if >
			<xsl:if test="MeasureID= '163'">
				<templateId root="2.16.840.1.113883.3.249.11.217"/>
			</xsl:if >
			<xsl:if test="MeasureID= '173'">
				<templateId root="2.16.840.1.113883.3.249.11.55"/>
			</xsl:if >
			<xsl:if test="MeasureID= '197'">
				<templateId root="2.16.840.1.113883.3.249.11.218"/>
			</xsl:if >
			<xsl:if test="MeasureID= '200'">
				<templateId root="2.16.840.1.113883.3.249.11.219"/>
			</xsl:if >
			<xsl:if test="MeasureID= '201'">
				<templateId root="2.16.840.1.113883.3.249.11.220"/>
			</xsl:if >
			<xsl:if test="MeasureID= '204'">
				<templateId root="2.16.840.1.113883.3.249.11.223"/>
			</xsl:if >
			<xsl:if test="MeasureID= '226'">
				<templateId root="2.16.840.1.113883.3.249.11.59"/>
			</xsl:if >
			<xsl:if test="MeasureID= '236'">
				<templateId root="2.16.840.1.113883.3.249.11.228"/>
			</xsl:if >				
			<xsl:if test="MeasureID= '237'">
				<templateId root="2.16.840.1.113883.3.249.11.56"/>
			</xsl:if >
			<xsl:if test="MeasureID= '238'">
				<templateId root="2.16.840.1.113883.3.249.11.57"/>
			</xsl:if >
			<xsl:if test="MeasureID= '239'">
				<templateId root="2.16.840.1.113883.3.249.11.58"/>
			</xsl:if >
			<xsl:if test="MeasureID= '240'">
				<templateId root="2.16.840.1.113883.3.249.11.60"/>
			</xsl:if >
			<xsl:if test="MeasureID= '241'">
				<templateId root="2.16.840.1.113883.3.249.11.221"/>
			</xsl:if >
			<xsl:if test="MeasureID= '305'">
				<templateId root="2.16.840.1.113883.3.249.11.225"/>
			</xsl:if >
			<xsl:if test="MeasureID= '306'">
				<templateId root="2.16.840.1.113883.3.249.11.226"/>
			</xsl:if >
			<xsl:if test="MeasureID= '307'">
				<templateId root="2.16.840.1.113883.3.249.11.227"/>
			</xsl:if >
			<xsl:if test="MeasureID= '308'">
				<templateId root="2.16.840.1.113883.3.249.11.229"/>
			</xsl:if >
			<xsl:if test="MeasureID= '309'">
				<templateId root="2.16.840.1.113883.3.249.11.230"/>
			</xsl:if >
			<xsl:if test="MeasureID= '310'">
				<templateId root="2.16.840.1.113883.3.249.11.231"/>
			</xsl:if >
			<xsl:if test="MeasureID= '311'">
				<templateId root="2.16.840.1.113883.3.249.11.232"/>
			</xsl:if >
			<xsl:if test="MeasureID= '312'">
				<templateId root="2.16.840.1.113883.3.249.11.233"/>
			</xsl:if >
			<xsl:if test="MeasureID= '313'">
				<templateId root="2.16.840.1.113883.3.249.11.224"/>
			</xsl:if >
			<xsl:if test="MeasureID= '316'">
				<templateId root="2.16.840.1.113883.3.249.11.234"/>
			</xsl:if >
			<xsl:if test="MeasureID= '317'">
				<templateId root="2.16.840.1.113883.3.249.11.235"/>
			</xsl:if >
			<xsl:if test="MeasureID= '999'">
				<templateId root="2.16.840.1.113883.3.249.11.15"/>
			</xsl:if >		
		</xsl:for-each>
		<code code="55186-1" codeSystem="2.16.840.1.113883.6.1" />
		<title>Measure Section</title>
		<text>
			<list>
				<xsl:for-each select="//Measures">
					<xsl:if test="MeasureID= '1'">
						<item> CMS Measure #1: Diabetes Mellitus: Hemoglobin A1c Poor Control in Diabetes Mellitus</item>
					</xsl:if >
					<xsl:if test="MeasureID= '2'">
						<item> CMS Measure #2: Diabetes Mellitus: Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus</item>
					</xsl:if >
					<xsl:if test="MeasureID= '3'">
						<item> CMS Measure #3: Diabetes Mellitus: High Blood Pressure Control in Diabetes Mellitus</item>
					</xsl:if >
					<xsl:if test="MeasureID= '5'">
						<item> CMS Measure #5: Heart Failure (HF): Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)</item>
					</xsl:if >
					<xsl:if test="MeasureID= '6'">
						<item> CMS Measure #6:  Coronary Artery Disease (CAD): Antiplatelet Therapy</item>
					</xsl:if >
					<xsl:if test="MeasureID= '7'">
						<item> CMS Measure #7: Coronary Artery Disease (CAD): Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction (MI)</item>
					</xsl:if >
					<xsl:if test="MeasureID= '8'">
						<item> CMS Measure #8:  Heart Failure: Beta-Blocker Therapy for Left Ventricular Systolic Dysfunction (LVSD)</item>
					</xsl:if >
					<xsl:if test="MeasureID= '9'">
						<item> CMS Measure #9:  Anti-depressant medication management: (a) Effective Acute Phase Treatment, (b) Effective Continuation Phase Treatment</item>
					</xsl:if >
					<xsl:if test="MeasureID= '12'">
						<item> CMS Measure #12:  Primary Open Angle Glaucoma (POAG): Optic Nerve Evaluation</item>
					</xsl:if >
					<xsl:if test="MeasureID= '18'">
						<item> CMS Measure #18:  Diabetic Retinopathy: Documentation of Presence or Absence of Macular Edema and Level of Severity of Retinopathy</item>
					</xsl:if >
					<xsl:if test="MeasureID= '19'">
						<item> CMS Measure #19:  Diabetic Retinopathy: Communication with the Physician Managing On-going Diabetes Care</item>
					</xsl:if >
					<xsl:if test="MeasureID= '39'">
						<item> CMS Measure #39: Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older</item>
					</xsl:if >
					<xsl:if test="MeasureID= '47'">
						<item> CMS Measure #47: Advance Care Plan  </item>
					</xsl:if >
					<xsl:if test="MeasureID= '48'">
						<item> CMS Measure #48: Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older </item>
					</xsl:if >
					<xsl:if test="MeasureID= '53'">
						<item> CMS Measure #53:  Asthma: Pharmacologic Therapy</item>
					</xsl:if >
					<xsl:if test="MeasureID= '64'">
						<item> CMS Measure #64:  Asthma: Asthma Assessment of Asthma Control</item>
					</xsl:if >
					<xsl:if test="MeasureID= '66'">
						<item> CMS Measure #66:  Appropriate Testing for Children with Pharyngitis</item>
					</xsl:if >
					<xsl:if test="MeasureID= '71'">
						<item> CMS Measure #71:  Breast Cancer: Hormonal Therapy for Stage IC–IIIC Estrogen Receptor/ Progesterone Receptor (ER/PR) Positive Breast Cancer</item>
					</xsl:if >
					<xsl:if test="MeasureID= '72'">
						<item> CMS Measure #72:  Colon Cancer: Chemotherapy for Stage III Colon Cancer Patients</item>
					</xsl:if >
					<xsl:if test="MeasureID= '102'">
						<item> CMS Measure #102:  Prostate Cancer: Avoidance of Overuse of Bone Scan for Staging Low-Risk Prostate Cancer Patients</item>
					</xsl:if >
					<xsl:if test="MeasureID= '110'">
						<item> CMS Measure #110: Preventive Care and Screening: Influenza Immunization</item>
					</xsl:if >
					<xsl:if test="MeasureID= '111'">
						<item> CMS Measure #111: Preventive Care and Screening: Pneumonia Vaccination for Patients 65 Years and Older</item>
					</xsl:if >
					<xsl:if test="MeasureID= '112'">
						<item> CMS Measure #112: Preventive Care and Screening: Screening Mammography</item>
					</xsl:if >
					<xsl:if test="MeasureID= '113'">
						<item> CMS Measure #113: Preventive Care and Screening: Colorectal Cancer Screening</item>
					</xsl:if >
					<xsl:if test="MeasureID= '117'">
						<item> CMS Measure #117:  Diabetes Mellitus: Dilated Eye Exam in Diabetic Patients</item>
					</xsl:if >
					<xsl:if test="MeasureID= '119'">
						<item> CMS Measure #119:  Diabetes Mellitus: Urine Screening for Microalbumin or Medical Attention for Nephropathy in Diabetic Patients</item>
					</xsl:if >
					<xsl:if test="MeasureID= '128'">
						<item> CMS Measure #128: Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up  </item>
					</xsl:if >
					<xsl:if test="MeasureID= '163'">
						<item> CMS Measure #163:  Diabetes Mellitus: Foot Exam</item>
					</xsl:if >
					<xsl:if test="MeasureID= '173'">
						<item> CMS Measure #173: Preventive Care and Screening: Unhealthy Alcohol Use - Screening</item>
					</xsl:if >
					<xsl:if test="MeasureID= '197'">
						<item> CMS Measure #197:  Coronary Artery Disease (CAD): Drug Therapy for Lowering LDL-Cholesterol</item>
					</xsl:if >
					<xsl:if test="MeasureID= '200'">
						<item> CMS Measure #200:  Heart Failure: Warfarin Therapy for Patients with Atrial Fibriliation</item>
					</xsl:if >
					<xsl:if test="MeasureID= '201'">
						<item> CMS Measure #201:  Ischemic Vascular Disease (IVD): Blood Pressure Management Control</item>
					</xsl:if >
					<xsl:if test="MeasureID= '204'">
						<item> CMS Measure #204:  Ischemic Vascular Disease (IVD): Use of Aspirin or Another Antithrombotic</item>
					</xsl:if >
					<xsl:if test="MeasureID= '226'">
						<item> CMS Measure #226: Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention</item>
					</xsl:if >
					<xsl:if test="MeasureID= '236'">
						<item> CMS Measure #236: Hypertension: Controlling High Blood Pressure</item>
					</xsl:if >
					<xsl:if test="MeasureID= '237'">
						<item> CMS Measure #237: Hypertension (HTN): Blood Pressure Measurement</item>
					</xsl:if >
					<xsl:if test="MeasureID= '238'">
						<item> CMS Measure #238: Drugs to be avoided in the Elderly </item>
					</xsl:if >
					<xsl:if test="MeasureID= '239'">
						<item> CMS Measure #239: Weight Assessment and Counseling for Children and Adolescents</item>
					</xsl:if >
					<xsl:if test="MeasureID= '240'">
						<item> CMS Measure #240: Childhood Immunization Status </item>
					</xsl:if >
					<xsl:if test="MeasureID= '241'">
						<item> CMS Measure #241: Ischemic Vascular Disease (IVD): Complete Lipid Panel and Low Density Lipoprotein (LDL-C) Control</item>
					</xsl:if >
					<xsl:if test="MeasureID= '305'">
						<item> CMS Measure #305:  Initiation and Engagement of Alcohol and Other Drug Dependence Treatment: (a) Inititiation, (b) Engagement</item>
					</xsl:if >
					<xsl:if test="MeasureID= '306'">
						<item> CMS Measure #306:  Prenatal Care:  Screening for Human Immunodeficiency Virus (HIV)</item>
					</xsl:if >
					<xsl:if test="MeasureID= '307'">
						<item> CMS Measure #307:  Prenatal Care:  Anti-D Immune Globulin</item>
					</xsl:if >
					<xsl:if test="MeasureID= '308'">
						<item> CMS Measure #308:  Smoking and Tobacco Use Cessation, Medical Assistance: a. Advising Smokers and Tobacco Users to Quit, b. Discussing Smoking and Tobacco Use Cessation Medications, c. Discussing Smoking and Tobacco Use Cessation Strategies</item>
					</xsl:if >
					<xsl:if test="MeasureID= '309'">
						<item> CMS Measure #309:  Cervical Cancer Screening</item>
					</xsl:if >
					<xsl:if test="MeasureID= '310'">
						<item> CMS Measure #310:  Chlamydia Screening for Women</item>
					</xsl:if >
					<xsl:if test="MeasureID= '311'">
						<item> CMS Measure #311:  Use of Appropriate Medications for Asthma</item>
					</xsl:if >
					<xsl:if test="MeasureID= '312'">
						<item> CMS Measure #312:  Low Back Pain: Use of Imaging Studies</item>
					</xsl:if >
					<xsl:if test="MeasureID= '313'">
						<item> CMS Measure #313:  Diabetes Mellitus:Hemoglobin A1c Control </item>
					</xsl:if >
					<xsl:if test="MeasureID= '316'">
						<item> CMS Measure #316:  Preventive Care and Screening: Cholesterol - Fasting Low Density Lipoprotein (LDL) Test Performed and Risk-Stratified Fasting LDL</item>
					</xsl:if >
					<xsl:if test="MeasureID= '317'">
						<item> CMS Measure #317:  Preventive Care and Screening: Screening for High Blood Pressure</item>
					</xsl:if >
					<xsl:if test="MeasureID= '999'">
						<item> eRx: Adoption/Use of Medication Electronic Prescribing Measure </item>
					</xsl:if >					
				</xsl:for-each>				
			</list>
		</text>
		<xsl:for-each select="//Measures">
			<xsl:if test="MeasureID= '1'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-1" codeSystem="2.16.840.1.113883.3.249.12" displayName=" Measure #1: Diabetes Mellitus: Hemoglobin A1c Poor Control in Diabetes Mellitus"/>
						<text>Measure #1: Diabetes Mellitus: Hemoglobin A1c Poor Control in Diabetes Mellitus</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '2'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-2" codeSystem="2.16.840.1.113883.3.249.12" displayName="  Measure #2: Diabetes Mellitus: Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus "/>
						<text> Measure #2: Diabetes Mellitus: Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '3'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-3" codeSystem="2.16.840.1.113883.3.249.12" displayName=" Measure #3: Diabetes Mellitus: High Blood Pressure Control in Diabetes Mellitus"/>
						<text>High Blood Pressure Control in Diabetes Mellitus</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '5'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-5" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #5: Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD) "/>
						<text>Measure #5: Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)  </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '6'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-6" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #6:  Coronary Artery Disease (CAD): Antiplatelet Therapy"/>
						<text>CMS Measure #6:  Coronary Artery Disease (CAD): Antiplatelet Therapy </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '7'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-7" codeSystem="2.16.840.1.113883.3.249.12" displayName=" Measure #7: Coronary Artery Disease (CAD): Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction (MI)"/>
						<text> Measure #7: Coronary Artery Disease (CAD): Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction (MI) </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '8'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-8" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #8:  Heart Failure: Beta-Blocker Therapy for Left Ventricular Systolic Dysfunction (LVSD)"/>
						<text>CMS Measure #8:  Heart Failure: Beta-Blocker Therapy for Left Ventricular Systolic Dysfunction (LVSD)</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '9'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-9" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #9:  Anti-depressant medication management: (a) Effective Acute Phase Treatment, (b) Effective Continuation Phase Treatment"/>
						<text>CMS Measure #9:  Anti-depressant medication management: (a) Effective Acute Phase Treatment, (b) Effective Continuation Phase Treatment </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '12'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-12" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #12:  Primary Open Angle Glaucoma (POAG): Optic Nerve Evaluation"/>
						<text>CMS Measure #12:  Primary Open Angle Glaucoma (POAG): Optic Nerve Evaluation </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '18'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-18" codeSystem="2.16.840.1.113883.3.249.12" displayName=" CMS Measure #18:  Diabetic Retinopathy: Documentation of Presence or Absence of Macular Edema and Level of Severity of Retinopathy"/>
						<text> CMS Measure #18:  Diabetic Retinopathy: Documentation of Presence or Absence of Macular Edema and Level of Severity of Retinopathy </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '19'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-19" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #19:  Diabetic Retinopathy: Communication with the Physician Managing On-going Diabetes Care"/>
						<text>CMS Measure #19:  Diabetic Retinopathy: Communication with the Physician Managing On-going Diabetes Care </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '39'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-39" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #39: Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older"/>
						<text>Measure #39: Screening or Therapy for Osteoporosis for Women Aged 65 Years and Older </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '47'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-47" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #47: Advance Care Plan"/>
						<text>Measure #47: Advance Care Plan</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '48'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-48" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #48: Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older"/>
						<text>Measure #48: Urinary Incontinence: Assessment of Presence or Absence of Urinary Incontinence in Women Aged 65 Years and Older</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '53'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-53" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #53:  Asthma: Pharmacologic Therapy"/>
						<text>CMS Measure #53:  Asthma: Pharmacologic Therapy</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '64'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-64" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #64:  Asthma: Asthma Assessment of Asthma Control"/>
						<text>CMS Measure #64:  Asthma: Asthma Assessment of Asthma Control </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '66'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-66" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #66:  Appropriate Testing for Children with Pharyngitis"/>
						<text>CMS Measure #66:  Appropriate Testing for Children with Pharyngitis</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '71'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-71" codeSystem="2.16.840.1.113883.3.249.12" displayName=" CMS Measure #71:  Breast Cancer: Hormonal Therapy for Stage IC–IIIC Estrogen Receptor/ Progesterone Receptor (ER/PR) Positive Breast Cancer"/>
						<text> CMS Measure #71:  Breast Cancer: Hormonal Therapy for Stage IC–IIIC Estrogen Receptor/ Progesterone Receptor (ER/PR) Positive Breast Cancer</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '72'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-72" codeSystem="2.16.840.1.113883.3.249.12" displayName=" CMS Measure #72:  Colon Cancer: Chemotherapy for Stage III Colon Cancer Patients"/>
						<text> CMS Measure #72:  Colon Cancer: Chemotherapy for Stage III Colon Cancer Patients</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '102'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-102" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #102:  Prostate Cancer: Avoidance of Overuse of Bone Scan for Staging Low-Risk Prostate Cancer Patients"/>
						<text>CMS Measure #102:  Prostate Cancer: Avoidance of Overuse of Bone Scan for Staging Low-Risk Prostate Cancer Patients </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '110'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-110" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #110: Preventive Care and Screening: Influenza Immunization for Patients greater than or equal 50 Years "/>
						<text> Measure #110: Preventive Care and Screening: Influenza Immunization for Patients greater than or equal 50 Years</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '111'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-111" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #111: Preventive Care and Screening: Pneumonia Vaccination for Patients 65 Years and Older"/>
						<text>Measure #111: Preventive Care and Screening: Pneumonia Vaccination for Patients 65 Years and Older </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '112'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-112" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #112: Preventive Care and Screening: Screening Mammography"/>
						<text>Measure #112: Preventive Care and Screening: Screening Mammography</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '113'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-113" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #113: Preventive Care and Screening: Colorectal Cancer Screening"/>
						<text> Measure #113: Preventive Care and Screening: Colorectal Cancer Screening</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '117'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-117" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #117:  Diabetes Mellitus: Dilated Eye Exam in Diabetic Patients"/>
						<text>CMS Measure #117:  Diabetes Mellitus: Dilated Eye Exam in Diabetic Patients</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '119'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-119" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #119:  Diabetes Mellitus: Urine Screening for Microalbumin or Medical Attention for Nephropathy in Diabetic Patients"/>
						<text>CMS Measure #119:  Diabetes Mellitus: Urine Screening for Microalbumin or Medical Attention for Nephropathy in Diabetic Patients </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<!--
			<xsl:if test="MeasureID= '124'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-124" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #124: Health Information Technology (HIT): Adoption/Use of Electronic Health Records (EHR)"/>
						<text>Measure #124: Health Information Technology (HIT): Adoption/Use of Electronic Health Records (EHR) </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if > -->
			<xsl:if test="MeasureID= '128'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-128" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #128: Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up"/>
						<text>Measure #128: Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '163'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-163" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #163:  Diabetes Mellitus: Foot Exam"/>
						<text>CMS Measure #163:  Diabetes Mellitus: Foot Exam</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '173'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-173" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #173: Preventive Care and Screening: Unhealthy Alcohol Use-Screening"/>
						<text>Measure #173: Preventive Care and Screening: Unhealthy Alcohol Use-Screening </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '197'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-197" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #197:  Coronary Artery Disease (CAD): Drug Therapy for Lowering LDL-Cholesterol"/>
						<text>CMS Measure #197:  Coronary Artery Disease (CAD): Drug Therapy for Lowering LDL-Cholesterol</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '200'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-200" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #200:  Heart Failure: Warfarin Therapy for Patients with Atrial Fibriliation"/>
						<text>CMS Measure #200:  Heart Failure: Warfarin Therapy for Patients with Atrial Fibriliation</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '201'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-201" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #201:  Ischemic Vascular Disease (IVD): Blood Pressure Management Control"/>
						<text>CMS Measure #201:  Ischemic Vascular Disease (IVD): Blood Pressure Management Control</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '204'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-204" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #204:  Ischemic Vascular Disease (IVD): Use of Aspirin or Another Antithrombotic"/>
						<text>CMS Measure #204:  Ischemic Vascular Disease (IVD): Use of Aspirin or Another Antithrombotic</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '226'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-226" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #226: Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention"/>
						<text>CMS Measure #226: Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '236'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-236" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #236: Hypertension: Controlling High Blood Pressure"/>
						<text>CMS Measure #236: Hypertension: Controlling High Blood Pressure </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '237'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-237" codeSystem="2.16.840.1.113883.3.249.12" displayName="Measure #0013: Hypertension (HTN): Blood Pressure Measurement"/>
						<text>Measure #237: Hypertension (HTN): Blood Pressure Measurement - QRDA Cat I template </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '238'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-238" codeSystem="2.16.840.1.113883.3.249.12" displayName="NQF Measure #0022: Drugs to be Avoided in the Elderly"/>
						<text>Measure #238: Drugs to be avoided in the Elderly - QRDA Cat I template</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '239'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-239" codeSystem="2.16.840.1.113883.3.249.12" displayName="NQF Measure #0024: Body Mass Index (BMI) 2 through 18 years of age"/>
						<text>Measure #239: Weight Assessment and Counseling for Children and Adolescents - QRDA Cat I template </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '240'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-240" codeSystem="2.16.840.1.113883.3.249.12" displayName="NQF Measure #0038: Childhood Immunization Status"/>
						<text>Measure #240: Childhood Immunization Status - QRDA Cat I template </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '241'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-241" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #241: Ischemic Vascular Disease (IVD): Complete Lipid Panel and Low Density Lipoprotein (LDL-C) Control"/>
						<text>CMS Measure #241: Ischemic Vascular Disease (IVD): Complete Lipid Panel and Low Density Lipoprotein (LDL-C) Control</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '305'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-305" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #305:  Initiation and Engagement of Alcohol and Other Drug Dependence Treatment: (a) Inititiation, (b) Engagement"/>
						<text>CMS Measure #305:  Initiation and Engagement of Alcohol and Other Drug Dependence Treatment: (a) Inititiation, (b) Engagement </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '306'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-306" codeSystem="2.16.840.1.113883.3.249.12" displayName=" CMS Measure #306:  Prenatal Care:  Screening for Human Immunodeficiency Virus (HIV)"/>
						<text> CMS Measure #306:  Prenatal Care:  Screening for Human Immunodeficiency Virus (HIV)</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '307'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-307" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #307:  Prenatal Care:  Anti-D Immune Globulin"/>
						<text>CMS Measure #307:  Prenatal Care:  Anti-D Immune Globulin </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '308'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-308" codeSystem="2.16.840.1.113883.3.249.12" displayName=" CMS Measure #308:  Smoking and Tobacco Use Cessation, Medical Assistance: a. Advising Smokers and Tobacco Users to Quit, b. Discussing Smoking and Tobacco Use Cessation Medications, c. Discussing Smoking and Tobacco Use Cessation Strategies"/>
						<text> CMS Measure #308:  Smoking and Tobacco Use Cessation, Medical Assistance: a. Advising Smokers and Tobacco Users to Quit, b. Discussing Smoking and Tobacco Use Cessation Medications, c. Discussing Smoking and Tobacco Use Cessation Strategies </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '309'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-309" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #309:  Cervical Cancer Screening"/>
						<text>CMS Measure #309:  Cervical Cancer Screening </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '310'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-310" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #310:  Chlamydia Screening for Women"/>
						<text>CMS Measure #310:  Chlamydia Screening for Women </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '311'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-311" codeSystem="2.16.840.1.113883.3.249.12" displayName=" CMS Measure #311:  Use of Appropriate Medications for Asthma"/>
						<text> CMS Measure #311:  Use of Appropriate Medications for Asthma </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '312'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-312" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #312:  Low Back Pain: Use of Imaging Studies"/>
						<text>CMS Measure #312:  Low Back Pain: Use of Imaging Studies</text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '313'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-313" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #313:  Diabetes Mellitus:Hemoglobin A1c Control "/>
								<text>CMS Measure #313:  Diabetes Mellitus:Hemoglobin A1c Control </text>
								<statusCode code="completed" />
							</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '316'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-316" codeSystem="2.16.840.1.113883.3.249.12" displayName=" CMS Measure #316:  Preventive Care and Screening: Cholesterol - Fasting Low Density Lipoprotein (LDL) Test Performed and Risk-Stratified Fasting LDL"/>
						<text> CMS Measure #316:  Preventive Care and Screening: Cholesterol - Fasting Low Density Lipoprotein (LDL) Test Performed and Risk-Stratified Fasting LDL </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '317'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="PhysicianQualityReporting-317" codeSystem="2.16.840.1.113883.3.249.12" displayName="CMS Measure #317:  Preventive Care and Screening: Screening for High Blood Pressure"/>
						<text>CMS Measure #317:  Preventive Care and Screening: Screening for High Blood Pressure </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >		
			<xsl:if test="MeasureID= '999'">
				<entry typeCode="DRIV">
					<act classCode="ACT" moodCode="DEF">
						<code code="eRx" codeSystem="2.16.840.1.113883.3.249.12" displayName="eRx:  Adoption/Use of Medication Electronic Prescribing Measure"/>
						<text>eRx:  Adoption/Use of Medication Electronic Prescribing Measure </text>
						<statusCode code="completed" />
					</act>
				</entry>
			</xsl:if >				
		</xsl:for-each>		
	</xsl:template>
</xsl:stylesheet>
